<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'no', branch 'MOODLE_36_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Ingen tilgang';
$string['accounts'] = 'Kontoer';
$string['addcategory'] = 'Legg til en kategori';
$string['additionalhtml'] = 'Ekstra HTML';
$string['additionalhtml_desc'] = 'Disse innstillingene lar deg skrive HTML-kode du vil legge til på alle sider. Du kan legge inn HTML innenfor HEAD-taggen for siden, straks etter at BODY taggen er åpnet, eller straks før BODY-taggen lukkes.<br />Dette åpner for egendefinert topp- og bunntekst på alle sider eller legge til støtte for f.eks. Google Analytics samme hvilket design som brukes.';
$string['additionalhtmlfooter'] = 'Før BODY-taggen lukkes';
$string['additionalhtmlfooter_desc'] = 'Innhold plassert her vil bli lagt til på alle sider rett før BODY-taggen lukkes.';
$string['additionalhtmlhead'] = 'Innenfor HEAD';
$string['additionalhtmlhead_desc'] = 'Innhold plassert her vil bli lagt til i bunnen av HEAD-taggen på alle sider.';
$string['additionalhtml_heading'] = 'Ekstra HTML som skal legges til å alle sider.';
$string['additionalhtmltopofbody'] = 'Når BODY-taggen åpnes';
$string['additionalhtmltopofbody_desc'] = 'Innhold plassert her blir lagt til på alle sider rett etter innledende BODY-tagg.';
$string['admincategory'] = 'Kategori: {$a}';
$string['adminseesall'] = 'Administratorer ser alt';
$string['adminseesallevents'] = 'Administratorer ser alle hendelser';
$string['adminseesownevents'] = 'Administratorer er som alle andre brukere';
$string['advancedfeatures'] = 'Avanserte funksjoner';
$string['agedigitalconsentverification'] = 'Bekreftelse av alder for samtykke';
$string['agedigitalconsentverification_desc'] = 'Aktiverer bekreftelse av alder for samtykke før visningen av registreringssiden for egenregistrerte brukere. Dette beskytter portalen din fra mindreårige som registrerer seg uten foresattes samtykke. <a target="_blank" href="{$a}">Kontakt support</a> mer informasjon for mindreårige for mer assistanse.';
$string['ageofdigitalconsentmap'] = 'Alder for samtykke';
$string['ageofdigitalconsentmap_desc'] = 'Standard alder for samtykke og alder for samtykke i land som ikke benytter standardalderen kan spesifiseres her. Skriv inn hver alder på egen linje med følgende format: landkode, alder (separert med komma). Standardalderenindikeres med * i stedet for landkoden. Landkoder er de samme som i ISO 3166-2.';
$string['allcountrycodes'] = 'Alle landskoder';
$string['allowattachments'] = 'Tillat vedlegg';
$string['allowbeforeblock'] = 'Tillatte lister vil bli prosessert først';
$string['allowbeforeblockdesc'] = 'Som standard vil oppføringer i IP-sperrelista bli sjekket først. Dersom dette valget er aktivt, vil oppføringer i lista over godkjente IP-adresser bli prosessert før sperrelista.';
$string['allowblockstodock'] = 'Tillat blokker å bruke sidestolpen';
$string['allowcategorythemes'] = 'Tillat katagoridesign';
$string['allowcohortthemes'] = 'Tillat cohortdesign';
$string['allowcoursethemes'] = 'Tillat egne kursdesign';
$string['allowedemaildomains'] = 'Tillatte epostdomener';
$string['allowediplist'] = 'Liste over godkjente IP-adr.';
$string['allowemailaddresses'] = 'Tillatte epost domener';
$string['allowframembedding'] = 'Tillat innebygging av rammer';
$string['allowframembedding_help'] = 'Tillat at denne portalen bygges inn i rammer på eksterne portalen, noe som anbefales når en publiseres via LTI. Utenom dette er aktivering av denne funksjonen ikke anbefalt av sikkerhetsgrunnner.';
$string['allowguestmymoodle'] = 'Tillat gjestetilgang til Min startside';
$string['allowindexing'] = 'Tillat indeksering av søkemotorer';
$string['allowindexing_desc'] = 'Dette bestemmer om søkemotorer skal få tilgang til å indeksere portalen.. "Overalt vil tillate at søkemotorene søker overalt inkludert innlogging- og registreringssidene, noe som betyr at portalen med "Tving innlogging" likevel blir indeksert.

For å unngå risikioen med spam som kommer av at registreringssiden er inkludert i indeksering bruk "Over alt unntatt innlogging- og registreringssidene". "Ingen steder" vil be søkemotorene om å ikke indeksere, men dette er bare en tag i headeren og det er opp til søkemotoren å respektere dette.';
$string['allowindexingeverywhere'] = 'Overalt';
$string['allowindexingexceptlogin'] = 'Overalt unntatt innloggings- og registreringssiden';
$string['allowindexingnowhere'] = 'Ingen steder';
$string['allowobjectembed'] = 'Tillat EMBED og OBJECT tagger';
$string['allowthemechangeonurl'] = 'Tillat design-skifte via URL';
$string['allowuserblockhiding'] = 'Tillat brukerne å skjule blokker';
$string['allowusermailcharset'] = 'Tillat brukerne å velge eget tegnsett';
$string['allowuserswitchrolestheycantassign'] = 'Tillat at brukere med begrensede rettigheter kan bytte roller';
$string['allowuserthemes'] = 'Tillat brukeren å velge design';
$string['alternativefullnameformat'] = 'Alternativt fullt navn format';
$string['alternativefullnameformat_desc'] = 'Dette definerer hvordan navn blir vist for brukere med viewfullnames rettigheten (som standard er dette rollene leder, lærer og gjestelærer) Plassholdere som kan brukes er de samme som for "Fullt navneformat"-innstillingen.';
$string['always'] = 'Alltid';
$string['appearance'] = 'Visning';
$string['aspellpath'] = 'Sti til Aspell stavekontroll';
$string['authentication'] = 'Autentisering';
$string['authpreventaccountcreation'] = 'Forhindre opprettelse av konto mens autentisering pågår';
$string['authpreventaccountcreation_help'] = 'Når en bruker autentiseres lages det automatisk en brukerkonto hvis den ikke finnes fra før. Dersom det brukes en ekstern database, som f.eks. LDAP, og du ønsker å begrense tilgangen til brukere som bare finnes i denne databasen, må du aktivere dette valget. Nye brukerkontoer må da lages manuelt eller via opplasting fra fil. Merk at denne innstillingen ikke har noen effekt på MNET-autentiseringen.';
$string['authsettings'] = 'Administrer autentisering';
$string['autolang'] = 'Autodetekter språk';
$string['autologinguests'] = 'Logg inn gjester automatisk';
$string['availablelicenses'] = 'Tilgjengelige lisenser';
$string['availableto'] = 'Tilgjengelig til';
$string['backgroundcolour'] = 'Gjennomsiktig farge';
$string['backups'] = 'Sikkerhetskopier';
$string['backup_shortname'] = 'Bruk kursnavnet i sikkerhetskopifilnavnet';
$string['backup_shortnamehelp'] = 'Bruk kursnavnet som en del av sikkerhetskopifilnavnet';
$string['badwordsconfig'] = 'Legg inn liste over fyord adskilt med komma';
$string['badwordsdefault'] = 'Hvis spesialtilpasset pakke er tom, vil en standardpakke fra språkpakken brukes.';
$string['badwordslist'] = 'Spesialtilpasset pakke for fyord';
$string['blockediplist'] = 'IP sperreliste';
$string['blockinstances'] = 'Hendelser';
$string['blockmultiple'] = 'Flere';
$string['blockprotect'] = 'Beskytt instanser';
$string['blockprotect_help'] = 'Dersom du låser en bestemt blokk vil ingen kunne legge til eller slette instanser av denne blokken. (Du kan selvsagt låse opp igjen for å redigere blokken)

Denne funksjonen har til hensikt å beskytte blokker som navigasjon og innstillinger som kan være veldig vanskelig å gjenopprette om de blir slettet ved et uhell.';
$string['blocksettings'] = 'Administrer blokker';
$string['blockunprotect'] = 'Lås opp';
$string['bloglevel'] = 'Synlighet av blogg';
$string['bookmarkadded'] = 'Bokmerke er lagt til';
$string['bookmarkalreadyexists'] = 'Du har allerede bokmerket denne siden';
$string['bookmarkdeleted'] = 'Bokmerket er slettet';
$string['bookmarkthispage'] = 'Bokmerk denne siden';
$string['cacheapplication'] = 'Programmellomlager';
$string['cacheapplicationhelp'] = 'Mellomlagrede elementer er delt mellom alle brukere og utløper etter en bestemt tid.';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Javaskript mellomlagring og komprimering gir bedre brukeropplevelse siden sider lastes raskere. Vi anbefaler sterkt dette for produksjonsportaler. Utviklere vil derimot ofte slå av funksjonen.';
$string['cacherequest'] = 'Mellomlager for forespørsler';
$string['cacherequesthelp'] = 'Brukerspesifikk mellomlager som slettes når forespørselen er fullført. Designet for å erstatte områder hvor vi bruker statisk lagring.';
$string['cachesession'] = 'Sesjons-mellomlager';
$string['cachesessionhelp'] = 'Brukerspesifkk mellomlager som slettes når brukerens sesjon avsluttes. Designet for å unngå overbelastning.';
$string['cachesettings'] = 'Innstillinger for mellomlager';
$string['caching'] = 'Mellomlagring';
$string['calendarexportsalt'] = 'Krypteringsfrase for kalendereksport (SALT)';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendertype';
$string['calendartype_desc'] = 'Velg en standard kalendertype for kursportalen. Denne innstillingen kan overstyres i kursinnstillingene eller av brukerne i deres egen profil.';
$string['calendar_weekend'] = 'Helgedager';
$string['cannotdeletemodfilter'] = 'Du kan ikke avinstallere \'{$a->filter}\' fordi den er en del av \'{$a->module}\'  modulen. ';
$string['cannotuninstall'] = '{$a} kan ikke avinstalleres.';
$string['categoryemail'] = 'Epost';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot er feil angitt i config.php fila. Du har inkluder et \'/\' tegn på slutten. Vær vennlig å fjern det tegnet, ellers kan du oppleve merkelige feil som f.eks. <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Du har definert $CFG->wwwroot feil i config.php fila. Den stemmer ikke med URL\'en du bruker for å nå siden. Vær vennlig å fjern det ellers kan du oppleve merkelige feil som f.eks. <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'endre';
$string['checkboxno'] = 'Nei';
$string['checkboxyes'] = 'Ja';
$string['choosefiletoedit'] = 'Velg filen du skal endre';
$string['cleanup'] = 'Rydd opp';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Feil, ugyldig verdi angitt for  "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Feil verdi, vennligst prøv igjen';
$string['clistatusdisabled'] = 'Status: deaktivert';
$string['clistatusenabled'] = 'Status: aktivert';
$string['clistatusenabledlater'] = 'status: CLI vedlikeholdsmodus vil bli aktivert på {$a}';
$string['clitypevalue'] = 'verditype';
$string['clitypevaluedefault'] = 'verditype, tast Enter for å bruke standardverdien {$a}';
$string['cliunknowoption'] = 'Ugyldige valg:
{$a}
Vennligst bruk Hjelp.';
$string['cliupgradedefault'] = 'Ny innstilling: {$a}';
$string['cliupgradedefaultheading'] = 'Setter nye standardverdier';
$string['cliupgradedefaultverbose'] = 'Ny innstilling: {$a->name}, Standardverdi: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Oppgradering via kommandolinje fra {$a->oldversion} til {$a->newversion} var vellykket.';
$string['cliupgradenoneed'] = 'Det trengs ingen oppgraderinger for den installerte versjonen {$a}. Takk likevel for at du sjekker!';
$string['cliyesnoprompt'] = 'Tast j (betyr JA) eller n (betyr NEI)';
$string['commentsperpage'] = 'Antall kommentarer pr. side';
$string['commonactivitysettings'] = 'Vanlige innstillinger';
$string['commonfiltersettings'] = 'Felles filterinnstillinger';
$string['commonsettings'] = 'Vanlige innstillinger';
$string['componentinstalled'] = 'Komponent er installert';
$string['computedfromlogs'] = 'Beregnet fra logger siden {$a}.';
$string['condifmodeditdefaults'] = 'Verdiene du angir her blir standardinnstillinger for hver ny aktivitet som opprettes.';
$string['confeditorhidebuttons'] = 'Velg de knappene som skal skjules i html-editoren.';
$string['configallcountrycodes'] = 'Dette er landoversikten som det kan velges fra mange steder, f.eks. i brukerens profil.  Dersom tom (standard) vil den engelske versjonen av landoversikten vises - ISO 3166-1. Ellers kan du angi en kommaseparert liste med landkoder, som f.eks. \'GB,FR,ES\'. Dersom du legger til nye ikke-standard koder her må du også legge dem til i filen \'countries.php\' i \'EN\' og din språkpakke.';
$string['configallowassign'] = 'Tillat at rollene på venstre side definerer rollene i hver kolonne.';
$string['configallowattachments'] = 'Aktivering av denne innstillingen vil tillate filvedlegg å bli sendt med epost-genererte meldinger av ulike funksjoner på hele portalen, sånn som blogger, forum og utmerkelser.';
$string['configallowblockstodock'] = 'Dersom aktivert og støttet av valgte design, kan brukere flytte blokker til sidestolpen.';
$string['configallowcategorythemes'] = 'Hvis du slår på denne kan design velges på kategorinivå. Dette vil påvirke alle underkategorier og -kurs såfremt de ikke har satt et eget design. ADVARSEL: Ved å slå på kategoridesign kan ytelsen påvirkes noe.';
$string['configallowcohortthemes'] = 'Dersom du aktiverer dette kan designsettes på cohortnivå. Dette vil påvirke alle brukere med bare en cohort eller flere cohorter som alle har det samme designet.';
$string['configallowcoursethemes'] = 'Hvis du skrur på denne, kan alle kurs velge eget design. Kursvalg for design overstyrer alle andre valg (for hele portalen,brukere eller sesjoner).';
$string['configallowedemaildomains'] = 'Vis e-postdomener som tillates å bli inkludert i "Fra"-seksjonen i utgående e-post. Standard er "Tom" og vil da benytte Ikke-svar adressen for all utgående e-post. Det er tillatt å bruke asterix, som f.eks. *.eksempel.com, noe som vil medføre at alle subdomener av eksempel.com tillates, men ikke eksempel.com i seg selv. Det vil kreve en egen oppføring.';
$string['configallowemailaddresses'] = 'For å begrense epostadresser til spesifikke domener kan du liste dem opp her separert med mellomrom. Alle andre domener vil avvises. For å tillate underdomener, legg til domenet med et \'.\' foran. For å tillate rotdomenet sammen med dets underdomener, legg til domenet to ganger - en gang med \'.\' foran og en gang uten. F.eks. \'.ourcollege.edu.au\' og \'ourcollege.edu.au\'.';
$string['configallowguestmymoodle'] = 'Dersom aktivert, vil gjester få vist Min startside. Ellers vil de bli omdirigert til kursportalens forside.';
$string['configallowobjectembed'] = 'Som en standard sikkerhetsinnstilling vil ikke vanlige brukere få lov til å legge multimedieobjekt (som f.eks. Flash) inn i tekst ved hjelp av html-tagger som EMBED og OBJECT. Multimedieobjekter kan likevel trygt legges inn ved hjelp av media-filter. Hvis du vil tillate bruk av disse html-taggene, slår du på denne muligheten her.';
$string['configallowoverride'] = 'Tillat at rollene på venstre side overstyrer rollene i hver kolonne';
$string['configallowoverride2'] = 'Velg hvilke rolle(r) som kan bli overstyrt av hver rolle i venstre kolonne.<br />NB! Disse innstillingene har bare betydning for brukere som har fått tillatelsene: moodle/role:override eller moodle/role:safeoverride.';
$string['configallowswitch'] = 'Velg hvilken rolle en bruker skal kunne bytte til, basert på rollen de allerede har. I tillegg til en oppføring i denne tabellen må brukeren også ha rettigheten "Tillat å bytte rolle" for å kunne bytte.<br />Merk at det bare er mulig å bytte til roller som har rett til å se kurs og de ikke får rett til å gjøre hva som helst, så noen kolonner i denne tabellen er deaktivert.';
$string['configallowthemechangeonurl'] = 'Dersom aktivert kan en bytte design ved å legge til theme={themename} til Moodle URL. F.eks. mymoodlesite.com/?theme=afterburner';
$string['configallowuserblockhiding'] = 'Vil du at brukerne skal kunne skjule/vise blokker på hele nettstedet? Denne egenskap bruker javascript og informasjonskapsler for å huske tilstanden til hver blokk, og påvirker kun brukerens eget skjermbilde.';
$string['configallowusermailcharset'] = 'Hvis du tillater dette, vil alle brukere på nettstedet kunne spesifisere sitt eget karaktersett for bruk i epost.';
$string['configallowuserswitchrolestheycantassign'] = 'Som standard kreves det moodle/role:assign for at brukere skal få bytte roller i et kurs. Aktiverer du denne fravikes dette kravet og listemenyen for bytte av rolle vises. Vi anbefaler at "Tillat å tildele roller" ikke settes slik at en bruker kan skifte til en overordnet rolle med flere rettigheter enn de allerede har.';
$string['configallowuserthemes'] = 'Hvis du tillater dette, kan brukerne velge sitt eget design (utseende). Brukerdesign overstyrer portaldesign (men ikke kursdesign).';
$string['configallowview'] = 'Velg rollene en bruker skal kunne se, filtrere på osv. basert på brukerens egne roller.';
$string['configallusersaresitestudents'] = 'Skal alle brukere betraktes som studenter i forhold til aktiviteter på forsiden til nettstedet? Hvis du svarer \'JA\', vil alle aksepterte brukerkonti tillates å delta som student i disse aktivitetene. Hvis du svarer \'NEI\', kan bare brukere som allerede er deltagere i minst ett kurs delta i disse aktiviteter. Kun administratorer og spesielt tilordnede lærere kan fungere som lærere for disse forsideaktivitetene.';
$string['configauthenticationplugins'] = 'Vennligst velg autentiseringsmetoder du vil bruke i stigende rekkefølge. Egenregistrering vil skje via metoden valgt under "Registering" (vanligvis e-post).';
$string['configautolang'] = 'Detekter standardspråk fra nettleseren, hvis standardspråk for portalen er deaktivert.';
$string['configautologinguests'] = 'Skal besøkende automatisk logges inn som gjester når de går til et kurs med gjestetilgang?';
$string['configbloglevel'] = 'Denne innstillingen tillater deg å begrense på hvilket nivå brukerblogger kan leses på dette nettstedet. Merk at de spesifiserer maksimum nivå til den som leser - ikke den som skriver eller typene bloggmeldinger. Blogger kan også kobles ut for hele nettstedet.';
$string['configcalendarcustomexport'] = 'Aktiver egendefinert tidsperiode ved eksport av kalender';
$string['configcalendarexportsalt'] = 'Denne tilfeldige teksten brukes for å forbedre sikkerheten av autentiseringen ved eksportering av kalendere. Merk at alle nåværende godkjennelser blir ugyldige hvis du forandrer denne krypteringsfrasen.';
$string['configcookiehttponly'] = 'Slår på ny PHP 5.2.0 egenskaper - nettlesere er instruert til å send cookies med virkelige http forespørsler, cookies bør ikke være tilgjengelig for scriptspråk. Dette er ikke støttet i alle nettlesere og behøver ikke å være fullstendig kompatibelt med nåværende kode. Dette hjelper til å forhindre enkelte XSS angrep.';
$string['configcookiesecure'] = 'Hvis serveren bare aksepterer https-forbindelser er det anbefalt å slå på at du kan sende sikre cookies. Hvis dette er aktivert så pass på at webserveren ikke aksepterer http://, eller sett opp permanent viderekopling til en https:// adresse. Når <em>wwwroot<em> adressen ikke starter med https:// blir denne innstillingen automatisk slått av.';
$string['configcountry'] = 'Hvis du velger et land her, vil dette landet brukes som standard for nye brukerkonti. For å tvinge brukere til å velge land, lar du denne stå usatt.';
$string['configcoursegraceperiodafter'] = 'La tidligere kurs vises som nåværende i så mange dager etter kursets sluttdato';
$string['configcoursegraceperiodbefore'] = 'La fremtidige kurs vises som nåværende i så mange dager før kursets startdato.';
$string['configcourseoverviewfilesext'] = 'Kommaseparert liste over tillatte filtyper for kursbilder.';
$string['configcourseoverviewfileslimit'] = 'Maksimalt antall filer som kan vises ved siden av kursbeskrivelsen i kurskatalogen. Den første filen blir brukt som kursbilde i kursoversikten på startsiden. Øvrige filer vises kun i kurskatalogen.';
$string['configcourserequestnotify'] = 'Skriv brukernavnet til brukeren som skal få varsel hvis noen ønsker å opprette nytt kurs.';
$string['configcourserequestnotify2'] = 'Brukere som vil bli varsles når et nytt kurs ønskes opprettet. Bare brukere som kan gi godkjennelse til å opprette nytt kurs skal listes opp her.';
$string['configcoursesperpage'] = 'Skriv inn antall kurs som skal vises på hver side i en kursoversikt.';
$string['configcourseswithsummarieslimit'] = 'Maksimum antall kurs som skal vises på hver side før Moodle skifter til forenklet kurslisting.';
$string['configcronclionly'] = 'Å kjøre cron fra adressefeltet i nettleseren kan eksponere sensitiv informasjon til anonyme brukere. Det er derfor anbefalt å kun kjøre cron fra kommandolinjen eller sette et passord for fjerntilgang';
$string['configcronremotepassword'] = 'Dette betyr at cron.php ikke kan kjøres rett fra nettleseren uten at passordet skrives inn på følgende form:
<pre>
http://site.example.com/admin/cron.php?password=opensesame
</pre> Dersom deaktivert, kan passordet utelates.';
$string['configcurlcache'] = 'Sesjonslengde for cURL cache, angitt i sekunder';
$string['configcustommenuitems'] = 'Du kan her sette opp en tilpasset meny som skal vises sammen med designet.  Hver linje består av tekst og en URL (valgfritt), et pekertips (valgfritt) og atskilles med pipe-tegnet. Du kan angi en struktur med bindestrek ved hjelp av ###. Det siste menyvalget viser kodetillegget som trengs for å åpne i et nytt vindu.
Eksempel:
<pre>
Moodle community|http://moodle.org
-Moodle free support|http://moodle.org/support
-###
-Moodle development|http://moodle.org/development
--Moodle Tracker|http://tracker.moodle.org
--Moodle Docs|http://docs.moodle.org|Dokumentasjon på engelsk
-Moodle News|http://moodle.org/news
Moodle company|Nyheter fra Moodle
-Moodle commercial hosting|http://moodle.com/hosting
-Moodle commercial support|http://moodle.com/support" target="new"
</pre>';
$string['configcustomusermenuitems'] = 'Du kan endre innholdet i brukermenyen, unntatt utloggingslenken som er der automatisk). Hver linje er separert med |-tegn og består av 1) en streng på formen "langstringname, componentname" eller som ren tekst, 2) en URL og 3) et ikon enten som et pix ikon eller en URL. Du kan legge til skilletegn ved å legge til en linje eller flere # tegn hvor ønskelig.';
$string['configdbsessions'] = 'Hvis slått på, vil denne innstillingen bruke databasen til å lagre informasjon om aktuelle sesjoner. Dette er spesielt nyttig for store/travle nettsteder eller portaler som er bygget opp over en klynge tjenere. For de fleste portaler burde den antageligvis være slått av slik at disken på serveren brukes i stedenfor. Merk at å forandre denne innstillingen nå vil logge ut alle brukere (deg inkludert). Hvis du bruker MYSQL, husk at \'max_allowed_packet\' i my.cnf (eller my.ini) er minst 4M. Andre metoder for sesjonshåntering kan konfigureres rett i config.php, du finner mer informasjon om dette i config-dist.php-fila. Dette valget forsvinner dersom du angir sesjonshåndteringen i config.php.';
$string['configdebug'] = 'Hvis du slår på denne, vil PHPs error_reporting økes slik at flere advarsler kan lagres. Dette er kun nyttig for utviklere.';
$string['configdebugdisplay'] = 'Dersom aktivert, vil feilmeldingene vise på html-siden. Dette er kanskje praktisk, men herper XHTML, JS, COOKIES og HTTP. Slår du den av vil du i stedet få feilmeldingene i serverloggen. Det gir oftest best debugging informasjon. Det er PHP innstillingen for error_log som avgjør hvilken logg det skrives til.';
$string['configdebugpageinfo'] = 'Aktiveres dersom du ønsker at sideinformasjon skal vises i footer.';
$string['configdebugsmtp'] = 'Aktiver detaljert debug informasjon ved sending av epost til smtp-serveren.';
$string['configdebugvalidators'] = 'Aktiver denne hvis du har lenker til eksterne valideringsservere i sidens bunntekst. Du kan f.eks. lage en bruker med brukernavnet <em>w3cvalidator</em>,  og aktivere gjestetilgang. Disse endringene kan medføre uønsket tilgang til serveren og må ikke aktiveres på produksjonsportaler!';
$string['configdefaulthomepage'] = 'Her angis hjemmesiden for innloggede brukere';
$string['configdefaultrequestcategory'] = 'Kursønsker fra brukere vil automatisk bli plassert i denne kategorien.';
$string['configdefaultrequestedcategory'] = 'Standard kategori forespurte kurs skal legges i hvis de godkjennes.';
$string['configdefaultuserroleid'] = 'Alle innloggede brukere vil få tildelt rettighetene til den rollen du setter opp her, på portalnivå, i tillegg til de andre roller de har blitt tildelt. Standard er Godkjent bruker. Merk at dette ikke vil være i strid med andre roller en bruker har med mindre du forbyr rettigheter, den bare sikrer at alle brukere har rettigheter som ikke kan tildeles på kursnivå (f.eks. lese i forum, ressurser osv)';
$string['configdeleteincompleteusers'] = 'Etter denne perioden vil kontoer uten fornavn, etternavn eller epostadresse bli slettet.';
$string['configdeleteunconfirmed'] = 'For enkelte autentiseringsmetoder, som f.eks. epostbasert selvregistrering, må brukerne bekrefte kontoen innen en viss tid. Dersom kontoen ikke bekreftes tidsnok vil den slettes.';
$string['configdenyemailaddresses'] = 'For å avvise adresser fra spesielle domener, lister du dem på samme måte her. Alle andre domener vil godkjennes. Eks. <strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'Slå av muligheten for at brukerne selv kan laste opp bilde av seg selv.';
$string['configdisplayloginfailures'] = 'Dette vil vise informasjon om tidligere mislykkede innlogginger.';
$string['configdndallowtextandlinks'] = 'Aktiver eller deaktiver "dra og slipp" av tekst og lenker på en kursside, i tillegg til "dra og slipp" av filer. Merk at "dra og slipp" av tekst i Firefox eller mellom forskjellige nettlesere ikke er mulig og kan resultere i at ingen data blir lastet opp eller at teksten blir ødelagt.';
$string['configdoclang'] = 'Dette språket vil bli benyttet til lenker til dokumentasjonssider.';
$string['configdocroot'] = 'Definerer stien til Moodles dokumentasjon på Moodle.org. Du kan forandre denne hvis du ønsker å ha din egen tilpassede dokumentasjon på nettet. Men hvis du gjør det, sørg for at stiene i din dokumentasjon følger samme format som den på http://docs.moodle.org.
Hvis du lar feltet stå tomt vil det ikke tilbys noen dokumentasjon.';
$string['configdoctonewwindow'] = 'Hvis du slår denne på, så vil lenker til Moodle dokumentasjon vises i neste vindu.';
$string['configeditordictionary'] = 'Denne verdien blir benyttet hvis aspell ikke har noen ordliste for brukerens valgte språk.';
$string['configeditorfontlist'] = 'Velg de fontene som skal være tilgjengelige i html-editoren.';
$string['configemailchangeconfirmation'] = 'Tving brukeren til å gjenta e-postadressen når den endres.';
$string['configemailfromvia'] = 'Legg til via informasjon i "Fra-"-delen av den utgående eposten. Dette informerer mottakeren om hvor denne eposten ble sendt fra, og hjelper også til å forhindre at motakerne svarer til ikke-svar adresser.';
$string['configenableactivitychooser'] = 'Aktivitetsvelgeren er en dialogboks med en kort beskrielse av hver aktivitet og ressurs. Hvis deaktivert vises det i stedet separate nedtrekksmenyer for aktiviteter og ressurser.';
$string['configenableblogs'] = 'Denne knappen gir alle brukerne på portalen egen blogg.';
$string['configenablecalendarexport'] = 'Slå på eksportering/abonnering på kalendre.';
$string['configenablecomments'] = 'Aktiver kommentarer';
$string['configenablecourserequests'] = 'Dette vil tillate at alle brukere kan be om at et kurs skal opprettes.';
$string['configenabledevicedetection'] = 'Aktiverer deteksjon av mobile enheter, smarttelefoner, nettbrett eller standardenheter (PC, bærbare, osv.) for korrekt visning av design eller andre funksjoner.';
$string['configenablemobilewebservice'] = 'Aktiverer mobiltjenesten for den offisielle Moodle appen eller andre apper som trenger det. For mer informasjon les {$a}';
$string['configenablerssfeeds'] = 'Hvis aktivert, vil RSS genereres av diverse aktiviteter over hele portalen, f.eks. blogger, forum, databaser og ordbøker. Vær oppmerksom på at RSS også må aktiveres i innstillingene til hver enkelt aktivitetsmodul.';
$string['configenablerssfeedsdisabled'] = 'Denne er ikke tilgjengelig siden RSS er inaktiv på denne portalen. For å aktivisere RSS må du gå til Admin; Variabler.';
$string['configenablerssfeedsdisabled2'] = 'RSS-agenter er slått av på portalnivå. Du må slå dem på under "Avanserte funksjoner" på portalnivå.';
$string['configenablesafebrowserintegration'] = 'Dette legger til valget "Krever sikker eksamensnettleser" til feltet for nettlesersikkerhet i Quiz-innstillingene. Gå til <a href="http://www.safeexambrowser.org/" target="_blank">http://www.safeexambrowser.org/</a> for mer informasjon.';
$string['configenablestats'] = 'Hvis du velger \'ja\' her, vil Moodles cronjobb prosessere loggene og samle statistikk. Avhengig av mengden trafikk på nettstedet, kan dette ta litt tid. Hvis du tillater det, vil du kunne se interessante grafer og statistikk om hvert av kursene dine eller på basis av hele nettstedet.';
$string['configenabletrusttext'] = 'Som standard vil Moodle alltid renske tekst fra brukere for potensielt skadelig kode, media eller annet som kan være en sikkerhetsrisiko. "Godkjent Innhold" systemet er en måte å gi bestemte brukere adgang til å inkludere avanserte funksjoner i publisert innhold uten at Moodle fjerner noe. <br />For å aktivisere denne funksjonen må du først aktivisere denne innstillingen og deretter tildele "Godkjent Innhold"-tillatelse til en bestemt Moodle-rolle. Tekst som blir produsert eller lastet opp av slike brukere vil bli merket som Godkjent og ikke rensket før den vises.';
$string['configenablewebservices'] = 'Webtjenester tillater at andre systemer kan logge inn i Moodle og utføre bestemte operasjoner. Denne funksjonen bør være avslått hvis du ikke bruker den.';
$string['configenablewsdocumentation'] = 'Aktiver autogenerering av webtjeneste - dokumentasjon. En bruker kan via webtjenester få tilgang til egen dokumentasjon på sin side for sikkerhetsnøkkel {$a}. Denne funksjonen viser bare dokumentasjonen for aktivert protokoll.';
$string['configerrorlevel'] = 'Velg hvor mye PHP-advarsler du ønsker skal vises. Normal er vanligvis det beste valg.';
$string['configexportlookahead'] = 'Antall dager å se framover under eksport';
$string['configexportlookback'] = 'Antall dager å se tilbake i tid under eksport';
$string['configextendedusernamechars'] = 'Slå på denne for å la studenter bruke alle tegn i sine brukernavn (merk at dette ikke påvirker deres virkelige navn). Standard er "falsk" som avgrenser brukernavn til å bestå av kun alfanumeriske tegn pluss (_)  (-) og (@).';
$string['configextramemorylimit'] = 'Noen scripts, som Søk, Backup/Restore eller cron, krever mer minne. Angi derfor en høyere verdi på store portaler.';
$string['configfilterall'] = 'Filtrer alle tekststrenger, inkludert overskrifter, titler, navigasjonslinjer osv. Dette er nyttigst når du bruker filter for flere språk, ellers vil den kun skape ekstra belasting på nettstedet uten at du tjener på det.';
$string['configfiltermatchoneperpage'] = 'Auto-lenking filtre vil bare generere en lenke for første treff på en side. Alle andre blir ignorert.';
$string['configfiltermatchonepertext'] = 'Auto-lenking filtre vil bare generere en lenke for første treff i hver tekstblokk (i en ressurs, blokk osv). Alle andre blir ignorert. Denne innstillingen overstyres hvis du har aktivisert bare ett auto-lenke treff pr. side.';
$string['configfilteruploadedfiles'] = 'Alle opplastetede html- og tekstfiler vil filtreres før de vises, bare html-filer eller ingen i det hele  tatt.';
$string['configforcelogin'] = 'Vanligvis kan forsiden på nettstedet og listen med kurs (men ikke kursene) leses av folk uten at de logger på nettstedet. Hvis du ønsker at folk skal være nødt til å logge på før de kan se noe som helst på nettstedet, bør du slå på denne innstillingen.';
$string['configforceloginforprofiles'] = 'Slå på denne innstillingen for å tvinge folk til å logge på med en virkelige konto (ikke gjester) før de kan se sider med brukerprofiler. Som standard er dette deaktivert slik at potensielle studenter kan lese om lærerne på hvert kurs, men dette betyr også at søkemaskiner på nettet kan se dem.';
$string['configfrontpage'] = 'Elementene over vil vises på hovedsiden.';
$string['configfrontpagecourselimit'] = 'Maksimum antall kurs';
$string['configfrontpagecourselimithelp'] = 'Maksimum antall kurs som skal vises på portalens forside i kursoversikten';
$string['configfrontpageloggedin'] = 'Elementene over vil vises på hovedsiden etter innlogging.';
$string['configfullnamedisplay'] = 'Dette definerer hvordan navn vises når de vises fullt ut. For ett-språklige nettsteder er den mest effektive innstillingen "Fornavn + Etternavn", men du kan velge å skjule etternavn helt, eller du kan la valget være opp til den aktuelle språkpakken (noen språk har andre konvensjoner).

Plassholdere som kan brukes er:  firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, and alternatename.';
$string['configgeoipfile'] = 'Plassering av GeoLite2 City binærdatafil. Denne filen er ikke en del av Moodledistribusjonen og må hentes fra <a href="http://www.maxmind.com/">MaxMind</a>.  Du kan enten kjøpe en kommersiell versjon eller bruke gratisversjonen.<br/> Last ned <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/">https://dev.maxmind.com/geoip/geoip2/geolite2/</a> og pakk den ut i "{$a}"-mappen på serveren din.';
$string['configgetremoteaddrconf'] = 'Dersom serveren er bak en proxy, kan du bruke denne innstillingen til å sette opp hvilke http-headere som skal tillates å inneholde innkommende IP-adresser. Headerne blir lest i oppgitt rekkefølge og bruker første treff.';
$string['configgradebookroles'] = 'Innstillingen lar deg styre hvem som skal fremkomme i vurderingsboka. En bruker må ha minst EN av disse rollene for å vises i vurderingsboka for et kurs.';
$string['configgradeexport'] = 'Velg hvilket format som skal være førstevalg for å eksportere karakterer. Valgt plugin vil settes og bruke "siste eksporterte" felt for alle karakterer. Hvis foreksempel, dette resulterer i at eksporterte poster blir identifisert som "new" eller "updated". Hvis du ikke er sikker på hva dette er, la alt stå ukrysset.';
$string['confighiddenuserfields'] = 'Velg hvilke felt med brukerinformasjon du vil skal skjules for andre brukere enn kursets lærere og administratorer. Dette vil øke studentens personvern. Hold CTRL-knappen nede for å velge flere felt.';
$string['configidnumber'] = 'Ette valget spesifiserer hvorvidt (a) Brukere spørres ikke om ID-nummer i det hele tatt, (b) Brukere spørres om et ID-nummer, men kan la det stå blankt eller (c) Brukere spørres om et ID-nummer og kan ikke velge å la det stå tomt. Hvis det er gitt, vil brukers ID-nummer vises i deres profil.';
$string['configintro'] = 'På denne siden kan du spesifisere et antall konfigurasjonsvariable som hjelper til å få Moodle til å fungere skikkelig på tjeneren din. Ikke bekymr  deg for mye om det - standardverdiene vil normalt fungere fintog du kan alltids komme tilbake til denne siden senere for å forandre disse innstillingene.';
$string['configintroadmin'] = 'På denne siden skal du konfigurere hovedadministratorkontoen. Denne vil ha to fullstendig kontroll over nettstedet. Forsikre deg om at det er et sikkert brukernavn og passord i tillegg til en gyldig epostadresse. Du kan opprette flere administratorkonti senere.';
$string['configintrosite'] = 'Denne siden lar deg konfigurere forsiden og navnet på dette nye nettstedet. Du kan komme tilbake hit senere for å forandre disse innstillingene når som helst ved å bruke lenken \'Innstillinger for nettstedet\' på forsiden.';
$string['configiplookup'] = 'Når du klikker på en IP-adresse (som f.eks. 81.191.105.103), vil du få opp et kart med visning av hvor denne adressen er registrert/kommer fra. Det finnes flere plugins for dette du kan velge mellom. Hver av dem har fordeler og ulemper.';
$string['configkeeptagnamecase'] = 'Slå på denne hvis du vil at taggnavn skal beholde store/små bokstaver slik som brukerne laget dem.';
$string['configlang'] = 'Velg et standardspråk for hele nettstedet. Brukere kan overstyre denne innstillingen senere via språkmenyen eller innstillingene i egen profil. ';
$string['configlanglist'] = 'La denne stå tom hvis du vil at brukerne skal velge fritt fra installerte språk i Moodle. Du kan også avgrense valgmulighetene ved å legge inn språk-kodene for ønskede språk. Eks: en,es_es,fr,it,no';
$string['configlangmenu'] = 'Bestem om språkmenyen skal vises på hovedsiden, login-siden etc. Brukeren vil likevel kunne angi ønsket språk i sin egen profil.';
$string['configlangstringcache'] = 'Mellomlagrer alle språkstrenger i kompilerte filer i datamappen. Dersom du oversetter Moodle eller endrer strenger i Moodles kildekode, vil du nok deaktivere denne. Ellers bør du la denne være på for å øke ytelsen på systemet.';
$string['configlatinexcelexport'] = 'Velg kodesett for Excel-eksporter';
$string['configlocale'] = 'Angi datoformat for hele portalen. Dette vil overstyre både format og språk for alle installerte språkpakker. (Kalenderdatoer påvirkes ikke) Du må ha  disse lokale datoinnstillingene installert i operativsystemet. I de fleste tilfeller anbefaler vi  at du lar feltet stå blankt.';
$string['configloginhttps'] = 'Aktiviserer du dette vil Moodle bruke en sikker https-forbindelse for login-prosessen, og deretter vende tilbake til normal http-protokoll. (Raskere)
ADVARSEL! Denne innstillingen KREVER at https er aktivisert på webserveren. Er den ikke det vil du bli utestengt fra din egen site.';
$string['configloglifetime'] = 'Dette spesifiserer hvor lang tid du ønsker å bevare logger om brukeraktivitet. Logger som er eldre enn dette blir automatisk slettet. Det er best å beholde logger så lenge som mulig, i tilfelle du trenger dem, men hvis du har en veldig travel tjener og opplever problemer med ytelsen, bør du vurdere å senke levetiden til loggene.';
$string['configlookahead'] = 'Dager inn i fremtiden';
$string['configmailnewline'] = 'Tegn for ny linje i mailbeskjeder. CRLF skal brukes ifølge RFC 822bis, noen epostservere bruker automatisk konvertering fra LF til CRLF, andre gjør feil konvertering fra CRLF til CRCRLF, andre igjen avviser epost med bare LF (qmail foreksempel). Prøv å endre denne innstillingen hvis du opplever problemer med epost som ikke blir levert eller doble blanke linjer.';
$string['configmaxbytes'] = 'Denne innstillingen bestemmer største tillate filstørrelse (ved opplasting) for hele portalen. Innstillingen er begrenset av PHP-innstillingen "post_max_size" og "upload_max_filesize", og Apaches "LimitRequestBody". Her settes største tillatte filstørrelse som kan velges på kurs eller modulnivå.';
$string['configmaxconsecutiveidentchars'] = 'Passord må ikke ha mer enn dette antallet påfølgende identiske tegn. bruk verdien 0 for å koble ut denne sjekken.';
$string['configmaxeditingtime'] = 'Dette spesifiserer hvor lang tid folk har til å endre på innlegg til forum, kommentarer til glossar osv. Vanligvis vil 30 min være en god verdi.';
$string['configmaxevents'] = 'Begivenheter inn i fremtiden';
$string['configmaxusersperpage'] = 'Maks antall brukere vist i brukervelger i kurs, gruppe, cohort, webservice, osv.';
$string['configmessaging'] = 'Dersom aktivert kan brukere sende meldinger til andre brukere på portalen.';
$string['configmessagingallowemailoverride'] = 'Tillater brukere å få tilsendt meldinger fra kursportalen til en annen e-postadresse enn den som er oppgitt i brukerprofilen.';
$string['configmessagingallusers'] = 'Hvis aktivert kan brukere se alle portalens brukere når de velger hvem de skal sende en melding til ogmeldingspreferansene vil inkludere et valg om å motta meldinger fra alle på portalen. Dersom deaktivert kan brukere bare se brukere som er medlem av samme kurs og de har kun to valg i meldingspreferansene - akseptere medinger fra kontakter eller kontakter og brukre i deres kurs.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Leste og uleste varsler kan slette for å lspare plass. Når skal varslinger slettes?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Leste varsler kan slettes for å spare diskplass. Hvor lang tid etter at varselet er lest kan det gå før den slettes?';
$string['configminpassworddigits'] = 'Passordene må ha minst så mange tall.';
$string['configminpasswordlength'] = 'Passordene må være minst så mange tegn lang.';
$string['configminpasswordlower'] = 'Passordene må ha minst så mange små bokstaver.';
$string['configminpasswordnonalphanum'] = 'Passordene må minst så mange spesialtegn.';
$string['configminpasswordupper'] = 'Passordene må ha minst så mange store bokstaver.';
$string['configmodchooserdefault'] = 'Skal aktivitetsvelgeren vises til brukere som standard?';
$string['configmycoursesperpage'] = 'Maks antall kurs som skal vises pr.side på brukerens kursoversikt';
$string['configmymoodleredirect'] = 'Innstillingen sender alle ikke-administratorer til en egendefinert hovedside etter innlogging. (Min Moodle-startside)';
$string['configmypagelocked'] = 'Denne innstillngen hindrer standardsiden fra å bli endret av andre enn administratorer.';
$string['confignavcourselimit'] = 'Begrenser antall viste kurs i navigasjonsmenyen.';
$string['confignavshowallcourses'] = 'Dette innstillingen bestemmer om brukere som er påmeldt i kurs kan se "Kurskatalog" i blokken Navigasjon (som viser alle kurs), i tillegg til "Mine kurs" (kun kurs som de er påmeldt).';
$string['confignavshowcategories'] = 'Viser kurskategorier i navigasjonsmenyen og i navigasjonsblokken. Påmeldte kurs vil vises i sideblokken "Mine kurs" som før.';
$string['confignoreplyaddress'] = 'E-post blir noen ganger sent på vegne av en bruker (ved forum-innlegg etc). E-postadressen du oppgir her vil bli benyttet som FRA-adresse i de tilfeller hvor mottakerne IKKE skal svare på e-posten. Denne FRA-adressen brukes også på de brukerne som har reservert seg mot visning av egen e-postadresse.';
$string['confignotifyloginfailures'] = 'Dersom mislykkede login er logget, kan et e-postvarsel sendes ut. Dette krever at en intern lagring av logger (standard logger) aktiveres.';
$string['confignotifyloginthreshold'] = 'Dersom varsling om mislykkede login er aktivisert, hvor mange mislykkede forsøk fra en bruker eller IP-adresse er det bryet verdt å varsle om?';
$string['confignotloggedinroleid'] = 'Brukere som ikke er innlogget vil bli behandlet som om de hadde denne rollen. Gjesterollen er vel den du ønsker her? (Du kan opprette mer eller mindre restriktive roller.) Skal en bruker skrive et forum-innlegg kreves innlogging uansett.';
$string['configopentogoogle'] = 'Hvis du slår på denne instillingen, vil Google kunne  inspisere nettstedet som gjest. I tillegg vil folk som kommer til nettstedet via Google automatisk bli logget inn som en gjest. Merk at dette kun gir en transparent aksess til kurs som allerede tillater tilgang for gjester.';
$string['configoverride'] = 'Definert i config.php';
$string['configpasswordpolicy'] = 'Hvis du slår på denne vil Moodle sjekke brukerpassordene i forhold til gjeldene passordpolitikk. Bruk innstillingene under for å bestemme din politikk (de vil ikke bli tatt hensyn til hvis du setter denne til \'Nei\').';
$string['configpasswordresettime'] = 'Denne innstillingen bestemmer hvor lang tid brukeren har for å bekrefte ett nytt passord før det utløper. 30 minutter er vanligvis en bra tid.';
$string['configpathtodu'] = 'Sti til du (disc usage). Antagelig noe sånt som /usr/bin/du. Hvis du skriver inn dette, vil sider som viser innhold i en mappe kjøre mye raskere for mapper med mange filer.';
$string['configpathtophp'] = 'Stien til PHP CLI. Sannsynligvis noe sånt som /usr/bin/php. Dersom du skriver inne dette vil cronskriptene bli utført fra adminwebpanelet.';
$string['configperfdebug'] = 'Hvis du setter på denne innstillingen, vil informasjon om ytelse skrives i bunnteksten på standardtema.';
$string['configprofileroles'] = 'Viser en liste over roller som skal være synlig på brukerprofilen og deltakernes sider,';
$string['configprofilesforenrolledusersonly'] = 'For å hindre misbruk fra spammere, skjules beskrivelsesfeltet for brukere som ennå ikke er påmeldt kurs. Nye brukere må melde seg på minst ett kurs før de kan redigere beskrivelsesfeltet i egen profil.';
$string['configprotectusernames'] = 'Som standard viser ikke "Glemt passord"-skjemaet noen hint for å hjelpe til å gjette på brukernavn eller epost-adresser.';
$string['configproxybypass'] = 'Kommaseparert liste over verter eller IP-adresser som ikke skal bruke Proxy. (eks: 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Dersom denne <b>serveren</b> må kobles via en proxy/brannmur mot internett, må du oppgi proxy-navn og portnummer her. Ellers kan feltet stå tomt.';
$string['configproxypassword'] = 'Passord som trengs for å få tilgang til Internett gjennom proxy hvis du har dette, la den stå tom hvis du ikke har det (PHP cURL-tillegg nødvendig.)';
$string['configproxyport'] = 'Dersom serveren kobles via proxy oppgir du portnummeret her.';
$string['configproxytype'] = 'Type webproxy (PHP5 og cURL-tillegg er nødvendig for SOCKS5-støtte).';
$string['configproxyuser'] = 'Brukernavn nødvendig for å få tilgang på Internett gjennom proxyserver, la den stå tom hvis du ikke trenger det (PHP cURL ekstensjon er nødvendig.)';
$string['configrecaptchaprivatekey'] = 'Privat nøkkel som brukes for å kommunisere mellom Moodleserveren din og recapthca.net-serveren. Du kan få en privat nøkkel for denne nettsiden fra  <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Offentlig nøkkel som brukes for å vise reCAPTCHA-elementet i påmeldingsskjemaet.
Du kan skaffe en nøkkel for denne nettsiden fra <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestcategoryselection'] = 'Tillat valg av kategori når man ber om et kurs';
$string['configrequestedstudentname'] = 'Ord brukt for student i forespurte kurs';
$string['configrequestedstudentsname'] = 'Ord brukt for studenter i forespurte kurs';
$string['configrequestedteachername'] = 'Ord brukt for lærer i forespurte kurs';
$string['configrequestedteachersname'] = 'Ord brukt for lærere i forespurte kurs';
$string['configsectioninterface'] = 'Grensesnitt';
$string['configsectionmail'] = 'E-post';
$string['configsectionmaintenance'] = 'Vedlikehold';
$string['configsectionmisc'] = 'Diverse';
$string['configsectionoperatingsystem'] = 'Operativsystem';
$string['configsectionpermissions'] = 'Tillatelser';
$string['configsectionrequestedcourse'] = 'Klassesøknader';
$string['configsectionsecurity'] = 'Sikkerhet';
$string['configsectionstats'] = 'Statistikk';
$string['configsectionuser'] = 'Buker';
$string['configsecureforms'] = 'Moodle kan bruke et ekstra sikkerhetsnivå når det aksepteres data fra nettskjema. Hvis dette er slått på, vil nettleserens HTTP_REFERER variabel sjekkes opp mot det aktuelle skjemaets adresse. I noen få tilfeller kan dette medføre problemer hvis brukeren bruker en brannmur (f.eks. Zonealarm) som er konfigurert for å fjerne HTTP_REFERER fra sin nettrafikk. Symptomer er at en sitter \'fast\' i et skjema. Hvis dine brukere f.eks. har problemer med innloggingssiden, bør du vurdere å slå av denne innstillingen, selv om det kan gjøre nettstedet ditt mer åpent for direkte angrep på passord. Hvis du er i tvil, la det stå \'ja\' her.';
$string['configsessioncookie'] = 'Denne innstillingen tilpasser navn på cookien som brukes for Moodle-innstillinger. Den er valgfri, og er bare nyttig for å unngå at cookies blir forvirret når det er flere enn en versjon av Moodle som kjører på den samme nettjeneren.';
$string['configsessioncookiedomain'] = 'Denne innstillingen tillater deg å endre domene som Moodle-cookies er tilgjengelige fra. Dette er nyttig for tilpassede Moodle-installasjoner (f.eks autentiserings eller påmeldingstillegg) som trenger å dele sesjonsdata fra Moodle til en webapplikasjon eller et annet underdomene. <strong>ADVARSEL: det er sterkt å anbefale at man lar denne står på standardinnstilling (tom) - en feil verdi her vil forhindre all innlogging til nettstedet.</strong>';
$string['configsessioncookiepath'] = 'Hvis du har behov for å endre hvor nettlesere sender sine Moodle-cookies, kan du forandre denne innstillingen for å spesifiere en underkatalog på nettserveren. Hvis ikke, er standardinnstillingen \'/\' helt fin.';
$string['configsessiontimeout'] = 'Hvis folk som er logget inn på dette nettstedet er passive i lang tid (uten å laste sider) vil de automatisk logges ut (sesjonene deres vil termineres). Denne variabelen spesifiserer hvor lang tid som skal gå før dette skjer.';
$string['configshowcommentscount'] = 'Vis antall kommentarerer. Vil medføre en ekstra spørring før siden vises.';
$string['configshowicalsource'] = 'Vis kildeinformasjon om iCal-hendelser';
$string['configshowsiteparticipantslist'] = 'Alle disse studenter og lærere på nettstedet vil bli listet opp på nettstedets deltakerliste. Hvem skal få lov til å se deltakerlisten for dette nettstedet?';
$string['configsitedefaultlicense'] = 'Standard portallisens';
$string['configsitedefaultlicensehelp'] = 'Standardlisensen vil benyttes for publisering av innhold på denne portalen';
$string['configsitemailcharset'] = 'All epost som genereres på ditt nettsted vil sendes i det spesifiserte karaktersett. Men hver enkelt bruker har lov til å tilpasse den hvis denne innstillingen er slått på.';
$string['configsitemaxcategorydepth'] = 'Maksimal kategoridybde';
$string['configsitemaxcategorydepthhelp'] = 'Denne angir maksimalt antall dybde av underkategorier som vises. Dypere nivåer av underkategorier vil da vises som lenker.';
$string['configslasharguments'] = '"Slash-arguments" (som bruker <em>PATH_INFO</em>) kreves for SCORM-pakker og multiple filressurser for å vises korrekt. Dersom webserveren ikke støtter "Slash-arguments", og du ikke får konfigurert det, kan du la denne innstillingen være deaktivert, men vil medføre at ting ikke vil fungere. <br />Støtte for "slash-arguments" er påkrevd i framtidige Moodle-versjoner.';
$string['configsmartpix'] = 'With this on, icons are served through a PHP script that searches the current theme, then all parent themes, then the Moodle /pix folder. This reduces the need to duplicate image files within themes, but has a slight performance cost.';
$string['configsmtpauthtype'] = 'Dette setter autentiseringstypen som skal brukes på smtp-server.';
$string['configsmtphosts'] = 'Oppgi fullt navn for en eller flere lokale SMTP-servere som Moodle skal bruke til epost-utsending  (f.eks. \'mail.a.com\' eller \'mail.a.com;mail.b.com\'). For å spesifisere en port som ikke er standard (altså en annen enn port 25) kan du bruke syntaksen [server]:[port] (f.eks. \'mail.a.com:587\'). For sikker tilkobling brukes port 465 vanligvis med SSL, port 587 vanligvis med TLS. Angi sikkerhetsprotokoll under hvis det kreves. Dersom du lar feltet stå tomt, vil Moodle bruke PHP\'s standardmetode for å sende epost.';
$string['configsmtpmaxbulk'] = 'Antall beskjeder sent per SMTP-sesjon. Å gruppere beskjeder kan gi økt hastigheten på epostsending. Verdier på mindre enn to tvinger at en ny SMTP-sesjon blir startet for hver epost som sendes.';
$string['configsmtpsecure'] = 'Hvis SMTP-serveren krever sikker tilkobling, vennligst angi riktig protokolltype.';
$string['configsmtpuser'] = 'Dersom du har oppgitt en SMTP-server over, og serveren krever godkjenning, må du skrive inn brukernavn og passord her.';
$string['configstartwday'] = 'Uken starter på';
$string['configstatsfirstrun'] = 'Dette setter hvor langt tilbake i tid loggene skal bearbeides <b>første gangen</b> cron kjører statistikk-rutinene. Hvis du har mye trafikk og leier et webhotell (som ofte deler maskinvare med mange andre) er det neppe en god ide å sette for langt tilbake i tid.';
$string['configstatsmaxruntime'] = 'Statistikk-kjøringen kan være svært prosessorintensiv, så bruk en kombinasjon av dette feltet og det neste for å spesifisere hvor lenge en skal holde på.';
$string['configstatsmaxruntime2'] = 'Statistikkbehandling kan være ganske intensiv, oppgi maxtid en kan bruke for å samle en dags statistikk. Max. antall dager som kan behandles i en cronkjøring er 31.';
$string['configstatsmaxruntime3'] = 'Dette angir makstiden serveren får bruke på statistikkgenerering hver dag. Dette sikrer at ikke serveren bruker så mye prosessorkraft på statistikken at ytelsen går ned. Maks antall dager som skal gjennomgås ved hver cron-kjøring settes under.';
$string['configstatsruntimedays'] = 'Dette angir maks antall dager som skal gjennomgås i hver statistikkjøring. Når statistikken er oppdatert, vil bare en dag bli gjennomgått, så sett denne verdien avhengig av serverbelastningen på din installasjon. Reduser verdien hvis du trenger kortere cronkjøringer.';
$string['configstatsruntimestart'] = 'Når skal cronjobben som kjører statestikkgjennomgangen starte? Det anbefales å angi forskjellige tidpunkter hvis det er flere Moodleportaler på en server.';
$string['configstatsuserthreshold'] = 'Dersom du skriver inn et tall forskjellig fra null, eller et bokstavverdi her, vil kurs med færre deltakere enn oppgitt her bli ignorert fra ranking-lista over mest populære kurs.';
$string['configstrictformsrequired'] = 'Hvis aktivert, vil brukere bli forhindret i å bruke kun mellomrom eller linjeskift i obligatoriske skjemafelt.';
$string['configstripalltitletags'] = 'Fjern haken her hvis du vil tillate HTML-tagger i aktivitets- og ressursnavn.';
$string['configsupportemail'] = 'Epostadressen vil bli publisert til brukere av denne portalen i tillegg til epost til den som står for generell hjelp (for eksempel, når brukerne lager egne konti). Hvis feltet er blankt vil ikke noen  epostadresse bli oppgitt.';
$string['configsupportname'] = 'Dette er navnet på en person eller enhet som tilbyr generell hjelp via supportepost eller hjemmeside.';
$string['configsupportpage'] = 'Denne webadressen vil bli publisert til brukere av siden som den adressen de må gå til hvis de trenger generell hjelp (for eksempel når nye brukere vil lage egne konti). Hvis adressen er tom vil ingen lenke bli gitt';
$string['configtempdatafoldercleanup'] = 'Fjern midlertidige file som er  elder enn valgt alder fra data-mappen.';
$string['configthemedesignermode'] = 'Normalt vil all grafikk i designet og stilark bli mellomlagret i nettleserne og på serveren i ganske lang tid for å gi best mulig ytelse. Dersom du er designutvikler eller skriver kode vil du kanskje aktivere denne for å unngå server-mellomlagrede visninger. Advarsel: Dette vil gjøre portalen tregere for samtlige brukere! Alternativt kan du iblant resette servermellomlageret manuelt - det gjøres fra Designgalleriet.';
$string['configthemelist'] = 'La denne stå tom dersom du ønsker at alle gyldige design skal kunne velges: Hvis du vil korte ned listen over design, kan du spesifisere en kommaseparert liste med navn her (Ikke bruk mellomrom!).
Eksempelvis: standard,orangewhite';
$string['configtimezone'] = 'Du kan sette standard tidssone her. Dette er kun STANDARD tidssone for å vise datoer - hver bruker kan overstyre denne ved å sette sin egen i profilen. "Tjenertid" her vil sette Moodles standard til tjenermaskinens systeminnstilling, men "Tjenertid" i brukerens profil vil gjøre denne tidssoneinnstillingen til brukerens standard. Cron-jobber som avhenger av en tid  på dagen for å kjøre, vil bruke denne tidssonen.';
$string['configuseblogassociations'] = 'Skal brukere få anledning til å organisere egen blogg ved å assossiere innlegg med kurs og kursmoduler?';
$string['configuseexternalyui'] = 'I stedet for å bruke lokale filer, bruk heller online filer på Yahoo sine servere. ADVARSEL: Dette krever internett-tilgang for at AJAX skal fungere. Denne innstillingen er ikke kompatibel med portaler som bruker https.';
$string['configuserquota'] = 'Max antall bytes brukeren kan lagre på privat filområde. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Hvis aktivert, vil kursportalens kortnavn bli brukt på navigasjonsnoder for portalsider i stedet for teksten "Kursportalsider"';
$string['configusetags'] = 'Skal tagfunksjonalitet på hele portalen slås på?';
$string['configvariables'] = 'Innstillinger';
$string['configverifychangedemail'] = 'Aktiverer verifisering av e-postadressen når den endres - og sjekker mot innstillingene for tillate/sperrede e-postdomener. Hvis deaktivert vil domenesjekken bare bli utført for nye brukere.';
$string['configvisiblecourses'] = 'Vis kurs fra skjulte kategorier';
$string['configwarning'] = 'Vær forsiktig med disse innstillingene. Feil valg kan skape problemer.';
$string['configyuicomboloading'] = 'Dette valget aktiverer kombinert fillastingsoptimering for YUI-biblioteker. Dette valget bør aktiveres på produksjonsportaler for best mulig ytelse.';
$string['confirmation'] = 'Bekreftelse';
$string['confirmcontextlock'] = '{$a->contextname} er åpent. Låsing vil gjøre at den kun kan leses og forhindre brukere i å gjøre endringer. Ønsker du å fortsette?';
$string['confirmcontextunlock'] = '{$a->contextname} er låst. Åpning vil tillate at brukere kan gjøre endringer. Ønsker du å fortsette?';
$string['confirmdeletecomments'] = 'Du er i ferd med å slette kommentarer, er du sikker?';
$string['confirmed'] = 'Bekreftet';
$string['contextlockappliestoadmin'] = 'Kontekstslåsing gjelder kun administratorier';
$string['contextlockappliestoadmin_desc'] = 'Dersom deaktivert vil administratorer ha skrivetilgang i låste kontekster.';
$string['contextlocking'] = 'Kontekstlåsing';
$string['contextlocking_desc'] = 'Denne innstillinge aktiverer kun les tilgang for valgte kategoirer, kurs, aktiviteter og blokker.';
$string['cookiehttponly'] = 'Bare http cookies';
$string['cookiesecure'] = 'Bare sikre cookies';
$string['country'] = 'Standard land';
$string['coursecontact'] = 'Kursadministratorer';
$string['coursecontact_desc'] = 'Denne innstillingen lar deg bestemme hvilke(n) roller som skal vises i kursbeskrivelsen. Du må MINST velge EN rolle.';
$string['coursecontactduplicates'] = 'Vis alle kurskontaktroller';
$string['coursecontactduplicates_desc'] = 'Dersom aktivert vil brukere med mer enn en av de valgte kurskontaktrollene bli vist i kursbeskrivelsen sammen med hver av rollene sine. Ellers vil de bare bli vist med en rolle. Rollen som vises er den som ligger øverst i listen på siden "Definer roller".';
$string['coursegraceperiodafter'] = 'Venteperiode for tidligere kurs';
$string['coursegraceperiodbefore'] = 'Venteperiode for fremtidige kurs';
$string['courselistshortnames'] = 'Vis utvidede kursnavn';
$string['courselistshortnames_desc'] = 'Når man viser kurslister, eller referer til kurs på administrasjonsskjermer, vises både kursets kortnavn og hele navnet. Når du slår på denne innstillingen, bruker visningen språkstrengen \'courseextendednamedisplay\' slik at du kan endre det som vises ved hjelp av Språk-tilpasning.';
$string['coursemgmt'] = 'Legg til/Endre kurs og kategorier';
$string['courseoverview'] = 'Kursoversikt';
$string['courserequestnotify'] = 'Anmodning om å opprette nytt kurs';
$string['courserequestnotifyemail'] = 'Bruker: {$a->user} ber om at nytt kurs blir opprettet på {$a->link}';
$string['courserequests'] = 'Kursønsker';
$string['courserequestspending'] = 'Kursforespørsler under behandling';
$string['courses'] = 'Kurs';
$string['coursesperpage'] = 'Kurs pr.side';
$string['courseswithsummarieslimit'] = 'Kurs med begrenset sammendrag';
$string['creatornewroleid'] = 'Kursoppretters rolle i nye kurs';
$string['creatornewroleid_help'] = 'Dersom brukeren ikke allerede har rett til å administrere det nye kurset, vil brukeren bli automatisk tildelt denne rollen ved påmelding.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Tillat kun Cron fra kommandolinja';
$string['cronerrorclionly'] = 'Beklager, internett-tilgangen til denne siden er sperret av administrator.';
$string['cronerrorpassword'] = 'Beklager, du har ikke gyldig passord for tilgang til denne siden.';
$string['cron_help'] = 'Cron.php er et skript som kjører flere ulike oppgaver til bestemte tider, som f.eks. sende ut e-post fra foruminnlegg. Skriptet bør kjøres med jevne mellomrom - ideelt hvert minutt.';
$string['cronremotepassword'] = 'Cron passord for fjerntilgang';
$string['cronwarning'] = '<a href="{$a}">cron.php vedlikeholds-skriptet </a> har ikke blitt kjørt på over 24 timer.';
$string['cronwarningcli'] = 'CLI/cron.php er ikke kjørt de siste 24 timene.';
$string['ctyperequired'] = 'PHP tillegget ctype er nå påkrevd av Moodle for å forbedre nettstedsytelse og å støtte kompatibilitet med en del andre språk.';
$string['curlcache'] = 'cURL mellomlager TTL';
$string['curlrequired'] = 'PHP-tillegget cURL kreves nå av Moodle for å kommunisere med Moodles fillagre.';
$string['curlsecurityallowedport'] = 'Liste over tillatte porter for cURL';
$string['curlsecurityallowedportsyntax'] = 'Liste med portnumre som cURL kan koble til. Kun oppføringer som består av heltall er gyldige. Skriv hver oppføring på en egen linje. Dersom feltet holdes tomt er alle porter tilgjengelige. Dersom det skrives noe ifeltet bør både 80 og 443 være med slik at cURL kan koble til standarportene for HTTP og HTTPS.';
$string['curlsecurityblockedhosts'] = 'Liste over blokkerte cURL-verter';
$string['curlsecurityblockedhostssyntax'] = 'Skriv inn nye oppføringer atskilt med linjeskift. Gyldige verdier er enten fullstendige IPv4- eller IPv6-adresser (slik som 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) som samsvarer med en enkelt vert; eller CIDR-notasjon (slik som 231.54.211.0/20 eller fe80::/64); eller en blokk med IP-adresser (slik som 231.3.56.10-20 eller fe80::1111-bbbb) hvor blokken samsvarer med siste gruppe av adresser; eller domenenavn (slik som localhost eller example.com); eller asterix-domenenavn (slik som *.example.com eller *.sub.example.com). Tomme linjer er ikke tillatt.';
$string['curlsecurityurlblocked'] = 'Denne URLen er blokkert.';
$string['curltimeoutkbitrate'] = 'Bitrate som skal brukes når det beregnes cURL timeout (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Denne innstillingen brukes til å beregne en fornuftig timeout ved store cURL-forespørsler. Som en del av denne beregningen gjøres det en HTTP HEAD-forespørsel for å bestemme størrelsen på innholdet. Hvis denne settes til 0, blir denne forespørselen deaktivert.';
$string['currenttheme'] = 'Gjeldende design';
$string['customcheck'] = 'Andre kontroller';
$string['custommenu'] = 'Egendefinert meny';
$string['custommenuitems'] = 'Egendefinerte menyelementer';
$string['customusermenuitems'] = 'Brukermenyelementer';
$string['datarootsecurityerror'] = '<p><strong>SIKKERHETSADVARSEL!</strong></p><p>Rotkatalogen for dine Moodledata er plassert feil og er fritt tilgjengelig fra web. Dette betyr at alle dine private filer er tilgjengelige for hvem som helst, og du må regne med at hackere vil bruke informasjonen her til å finne svakheter i brukernavn/passord og skaffe seg uautorisert tilgang til din installasjon!</p>
<p>Du <em>må</em> flytte moodledata-katalogen ({$a}) til et annet sted UTENFOR webområdet og oppdatere <code>$CFG->dataroot</code> innstillingen i config.php tilsvarende.</p>';
$string['datarootsecuritywarning'] = 'Site-oppsettet ditt er kanskje ikke sikkert nok. Vennligst sjekk at dataroot katalogen ({$a}) ikke er direkte tilgjengelig via web.';
$string['dbsessions'] = 'Bruk databasen til sesjonsinformasjon';
$string['debug'] = 'Debug meldinger';
$string['debugall'] = 'ALL: Vis alle fornuftige PHP debug-meldinger';
$string['debugdeveloper'] = 'Utvikler: Utvidede Moodle-debug meldinger for utviklere.';
$string['debugdisplay'] = 'Vis debug meldinger';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MINIMAL: Vis bare de verste feilmeldingene';
$string['debugnone'] = 'INGEN: Ikke vis noen feil eller advarsler';
$string['debugnormal'] = 'NORMAL: Vis feilmeldinger, advarsler og notiser';
$string['debugpageinfo'] = 'Vise sideinformasjon';
$string['debugsmtp'] = 'Debug e-postsending';
$string['debugstringids'] = 'Vis opphavet til språkstrengene';
$string['debugstringids_desc'] = 'Denne valgmuligheten er designet for å hjelpe oversettere. Når denne funksjonen er aktivert, vises språkfilen og streng-IDen ved siden av hver resultatstreng hvis du legger til parameteren "strings=1" til en URL-request,';
$string['debugvalidators'] = 'Vis valideringslenker';
$string['defaultcity'] = 'Standard sted';
$string['defaultcity_help'] = 'Dette blir standard stedsnavn når det opprettes nye brukere.';
$string['defaultformatnotset'] = 'Kunne ikke fastslå standard kursformat. Vennligst sjekk portalinnstillingene.';
$string['defaulthomepage'] = 'Standard hjemmeside for brukere';
$string['defaultrequestcategory'] = 'Standard kategori for kursønsker';
$string['defaultsettinginfo'] = 'Standard: {$a}';
$string['defaultuserroleid'] = 'Standard rolle for alle brukere';
$string['deleteincompleteusers'] = 'Slett ufullstendige brukere etter';
$string['deleteunconfirmed'] = 'Slett ubekreftede brukere etter';
$string['deleteuser'] = 'Slett bruker';
$string['density'] = 'Tetthet';
$string['denyemailaddresses'] = 'Ikke tillatte domener';
$string['development'] = 'Utvikling';
$string['devicedetectregex'] = 'Enhetsdeteksjon via regulære uttrykk';
$string['devicedetectregex_desc'] = '<p>Som standard kan Moodle detektere forskjellige typer enheter (vanlige PC-er, bærbare, osv.), mobile enheter (mobiltelefoner og håndholdte enheter), nettbrett (f.eks. iPad og Android nettbrett.) og arvet (beregnet på Internet Explorer 6 brukere). Designvelgeren kan brukes til å tilby forskjellige design for alle disse enhetene. Denne innstillingen tillater at regulære uttrykk kan brukes til enhetsdeteksjon (disse regulære uttrykkene overstyrer de innebygde).</p>
<p>For eksempel kan du legge til det regulære uttrykket \'/(MIDP-1.0|Maemo|Windows CE)/\' for å detektere noen vanlig brukte smarttelefoner (featurephone) og returnere verdien \'featurephone\'. Dette legger til \'featurephone\' i designvelgeren og gir deg muligheten til å velge et design skreddersydd for denne enhetstypen. Andre mobiler vil fortsatt bruke standarddesign valgt for moble enheter.</p>';
$string['devicedetectregexexpression'] = 'Regulært uttrykk';
$string['devicedetectregexvalue'] = 'Returverdi';
$string['devicetype'] = 'Enhetstype';
$string['devlibdirpresent'] = 'Mapper med utviklingsbiblioteker, spesielt <em>/vendor</em> og <em>/node_modules</em>, bør aldri tas med på portaler i produksjon. Se på<a href="{$a->moreinfourl}">Sikkerhetsoversikt</a> for flere detaljer.';
$string['disableuserimages'] = 'Slå av Brukerprofil-bilder';
$string['displayerrorswarning'] = 'Aktivering av PHP-innstillingen <em>display_errors</em> frarådes på portaler i produksjon siden noen av feilmeldingene kan inneholde sensitiv informasjon om serveren din.';
$string['displayloginfailures'] = 'Vis mislykkede innloggsforsøk';
$string['dndallowtextandlinks'] = 'Dra- og slipp opplasting av tekst/lenker';
$string['doclang'] = 'Språkvalg for dokumentasjon';
$string['docroot'] = 'Moodle Docs rotkatalog';
$string['doctonewwindow'] = 'Åpne i nytt vindu';
$string['doesnotfit'] = 'Visningsinnstillinger for e-post';
$string['doesnotfitdetail'] = 'Visningsinnstillinger for epost som sendes fra Moodle';
$string['download'] = 'Nedlasting';
$string['durationunits'] = 'Varighetsenheter';
$string['edithelpdocs'] = 'Rediger hjelpedokumenter';
$string['editlang'] = '<b>Rediger</b>';
$string['editorbackgroundcolor'] = 'Bakgrunnsfarge';
$string['editordictionary'] = 'Editor ordliste';
$string['editorfontfamily'] = 'Fontfamilie';
$string['editorfontlist'] = 'Fontliste';
$string['editorfontsize'] = 'Standard fontstørrelse';
$string['editorhidebuttons'] = 'Skjulte knapper';
$string['editorkillword'] = 'Word-filter';
$string['editorspelling'] = 'Stavekontroll';
$string['editorspellinghelp'] = 'Kobler til/fra stavekontroll. Dersom aktivert må <strong>aspell</strong> være installert på serveren.';
$string['editstrings'] = 'Rediger strenger';
$string['emailchangeconfirmation'] = 'E-postbekreftelse';
$string['emailfromvia'] = 'Epost via informasjon';
$string['emoticonalt'] = 'Alternativ tekst';
$string['emoticoncomponent'] = 'Bildefragment';
$string['emoticonimagename'] = 'Navn på bildet';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'Dette skjemaet definerer hvilke emosjoner (smilefjes) som skal brukes på din portal. For å fjerne en rad fra tabellen, kan du lagre med tomme felt i en av de obligatoriske feltene. For å legge inn enn ny emosjon fyller du ut den siste tomme raden. For å tilbakestille til standardverdier følger du  lenken over.

* Tekst (Obligatorisk) - Denne teksten blir erstattet med bildet av emosjonen. Teksten må være minst to tegn lang.
* Bildenavn (Obligatorisk) - Bildefil-navnet uten filtype (ikke med .jpg, .gif osv). Filnavnet oppgis relativt til fragment-pix mappen.
* Bildefragment (Obligatorisk) - Fragmentmappen som inneholder ikonet.
* En alternativ tekst (valgfritt) - Streng ID og en alternativ tekst som vises hvis ikke bildefilen kan vises.';
$string['emoticonsreset'] = 'TIlbakestill emosjoner til standard oppsett';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Tom';
$string['enableactivitychooser'] = 'Aktiver aktivitetsvelger';
$string['enableblogs'] = 'Aktiver blogger';
$string['enablecalendarexport'] = 'Slå på kalendereksport';
$string['enablecomments'] = 'Aktiver kommentarer';
$string['enablecourserequests'] = 'Aktiviser kursønsker';
$string['enabled'] = 'Aktivert';
$string['enabledevicedetection'] = 'Aktiver deteksjon av enheter';
$string['enableglobalsearch'] = 'Aktiver globalt søk';
$string['enableglobalsearch_desc'] = 'Hvis aktivert, vil alle data bli indeksert og synkronisert via en cron-jobb.';
$string['enablegravatar'] = 'Aktiver Gravatar';
$string['enablegravatar_help'] = 'Hvis Gravatar er aktivert vil Moodle hente et profilbilde herfra når brukeren ikke har lastet opp noe bilde.';
$string['enablemobilewebservice'] = 'Aktiver webservice for mobile enheter';
$string['enablerecordcache'] = 'Aktiviser hurtiglagring';
$string['enablerssfeeds'] = 'Aktiviser RSS';
$string['enablesafebrowserintegration'] = 'Aktiver "Sikker eksamensnettleser" integrasjon';
$string['enablesearchareas'] = 'Aktivér søkeområder';
$string['enablestats'] = 'Aktiviser statistikk';
$string['enabletrusttext'] = 'Aktiviser Godkjent Innhold';
$string['enablewebservices'] = 'Aktiver webtjenester';
$string['enablewsdocumentation'] = 'Webtjenester dokumentasjon';
$string['enrolinstancedefaults'] = 'Standardverdier for påmeldinger';
$string['enrolinstancedefaults_desc'] = 'Standard påmeldingsinnstillinger for nye kurs';
$string['enrolmultipleusers'] = 'Meld inn brukerne';
$string['environment'] = 'Omgivelse';
$string['environmenterrortodo'] = 'Du må løse alle de nevnte problem (feil) identifiserti omgivelsene før du fortsetter å installere denne Moodle versjonen!';
$string['environmenterrorupgrade'] = 'Warning: you should solve all the environmental problems (errors) found above before proceeding to upgrade this Moodle version! Upgrading without fixing these requirements could cause problems such as data loss. Are you sure you want to continue with the upgrade?';
$string['environmentmariadbwrongdbtype'] = 'Feil <code>$CFG->dbtype</code>: du må endre det i  <code>config.php</code> filen fra \'<code>mysql</code>\' til \'<code>mariadb</code>\'.';
$string['environmentmustfixsetting'] = 'PHP-innstillingene må endres.';
$string['environmentok'] = 'Serveren tilfredsstiller alle minimumskrav.';
$string['environmentrecommendcustomcheck'] = 'Hvis denne testen feiler, kan det bety et mulig problem.';
$string['environmentrecommendinstall'] = 'er anbefalt at du installerer/tillater';
$string['environmentrecommendversion'] = 'versjon {$a->needed} er anbefalt og du kjører {$a->current}';
$string['environmentrequirecustomcheck'] = 'denne testen må godkjennes';
$string['environmentrequireinstall'] = 'er påkrevd at du installerer/tillater';
$string['environmentrequireversion'] = 'Du må ha versjon {$a->needed}. Du kjører {$a->current}';
$string['environmentsettingok'] = 'anbefalt innstilling oppdaget';
$string['environmentshouldfixsetting'] = 'PHP-innstillingen bør endres.';
$string['environmentxmlerror'] = 'En feil oppsto under lesing av omgivelsesdata ({$a->error_code})';
$string['errordeletingconfig'] = 'Det oppstod en feil under sletting av innstillingene for modulen \'{$a}\'.';
$string['errorsetting'] = 'Kunne ikke lagre innstillingene';
$string['errorwithsettings'] = 'Noen innstillinger kunne ikke lagres pga en feil';
$string['eventshandlersinuse'] = 'Følgende moduler på systemet benytter Events 1 API håndtering:  \'{$a}\'. Vennligst oppdater dem til å benytte Events 2 API. Se https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers for mer informasjon.';
$string['everyonewhocan'] = 'Alle som kan \'{$a}\'';
$string['exceptions'] = 'unntak';
$string['execpathnotallowed'] = 'Muligheten for å angi kjørbare og lokale programstier er deaktivert i config.php';
$string['experimental'] = 'Eksperimentell';
$string['experimentalsettings'] = 'Eksperimentelle innstillinger';
$string['extendedusernamechars'] = 'Tillat utvidet karaktersett i brukernavn';
$string['extramemorylimit'] = 'Utvidet minnegrense for PHP';
$string['fatalsessionautostart'] = '<p>Alvorlig konfigurasjonsfeil oppdaget, vennligst varsle administrator.</p><p>For å fungere normalt krever Moodle at administrator endrer PHP-innstillingene.</p><p><code>session.auto_start</code> må endres til <code>off</code>.</p><p>Denne endringen gjøres i <code>php.ini</code>, Apache/IIS <br />oppsettet eller <code>.htaccess</code> filen på serveren.</p>';
$string['fileconversioncleanuptask'] = 'Rydder opp i midlertidige filer etter filkonverteringer';
$string['filecreated'] = 'Ny fil opprettet';
$string['filestoredin'] = 'Lagre fil i mappen:';
$string['filestoredinhelp'] = 'Hvor filen vil bli lagret';
$string['filterall'] = 'Filtrer alle strenger';
$string['filtermatchoneperpage'] = 'Filtrer ett treff per side';
$string['filtermatchonepertext'] = 'Filtrer ett treff per tekst';
$string['filters'] = 'Filtere';
$string['filtersettings'] = 'Filterinnstillinger';
$string['filtersettingsgeneral'] = 'Generelle filterinnstillinger';
$string['filteruploadedfiles'] = 'Filtrer opplastede filer';
$string['forceclean'] = 'Rensk innhold over alt.';
$string['forceclean_desc'] = 'Innhold som legges til i denne portalen blir vanlivis rensket for alle potensielle sikkerhetstrusler før det vises. Imidlertidig blir ikke alt innhold sjekket, f.eks. på steder som aktivitetsbeskrivelser, sideressurser eller HTML-lokker for å tillate at script, innbygde rammer osv legges til. Dersom denne innstillingen aktiveres vil alt innhold sjekkes og renskes og det kan føre til at eksisterende innhold ikke lengre blir vist korrekt.';
$string['forcelogin'] = 'Krev at brukeren logger inn';
$string['forceloginforprofileimage'] = 'Tving brukere til å logge inn før de får se profilbilder';
$string['forceloginforprofileimage_help'] = 'Hvis aktivert må brukere logge inn før de får se profilbilder. Standard profilbilde vil bli brukt i alle meldinger som sendes ut via e-post.';
$string['forceloginforprofiles'] = 'Krev at brukere logger inn før de får se profiler.';
$string['forcetimezone'] = 'Overstyr standard tidssone';
$string['formatuninstallwithcourses'] = '{$a->count} kurs bruker {$a->format}. Disse kursenes format vil bli endret til {$a->defaultformat} (standardformat for denne portalen). Noen data knyttet til det gamle formatet kan gå tapt. Er du sikker på at du vil fortsette?';
$string['frontpage'] = 'Hovedside';
$string['frontpagebackup'] = 'Hovedside backup';
$string['frontpagedefaultrole'] = 'Standard forsiderolle';
$string['frontpagefilters'] = 'Filtere for Hovedsiden';
$string['frontpageloggedin'] = 'Hovedsidens elementer når innlogget';
$string['frontpageoverrides'] = 'Overstyringer for Hovedsiden';
$string['frontpagequestions'] = 'Global testbank';
$string['frontpagerestore'] = 'Hovedside restore';
$string['frontpageroles'] = 'Hovedside roller';
$string['frontpagesettings'] = 'Hovedside innstillinger';
$string['fullnamedisplay'] = 'Format på fullt navn';
$string['fullnamedisplayprivate'] = 'Fullt navneformat - privat';
$string['gdrequired'] = 'GD-filtypen er nå påkrevd av Moodle for bildekonvertering.';
$string['generalsettings'] = 'Generelle innstillinger';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Logget IP-adressekilde';
$string['globalsearch'] = 'Globalt søk';
$string['globalsearchmanage'] = 'Administrere globalt søk';
$string['googlemapkey3'] = 'Google Maps API V3 nøkkel';
$string['googlemapkey3_help'] = 'Du må skrive en spesiell kode for å bruke Google Maps for IP adress lookup vizualization. Du kan få gratis kode på <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Gå til første manglende streng';
$string['gradebook'] = 'Karakterbok';
$string['gradebookroles'] = 'Roller i karakterboka';
$string['gradeexport'] = 'Primære eksportmetode for karakterer';
$string['gravatardefaulturl'] = 'Standard bilde-URL for Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar må ha et standardbilde som det kan vise hvis det ikke finnes noe bilde av den oppgitte brukeren. Oppgi full URL til et bilde. Hvis du lar denne innstillingen stå tom, vil Moodle prøve å bruke det mest passende standardbildet for siden du ser på. Vær også oppmerksom på at Gravatar har flere koder som kan brukes for å <a href="https://en.gravatar.com/site/implement/images/#default-image">generere standardbilder</a>.';
$string['groupenrolmentkeypolicy'] = 'Nøkkel-regler for gruppepåmelding';
$string['groupenrolmentkeypolicy_desc'] = 'Hvis denne aktiveres vil Moodle sjekke påmeldingsnøkler for grupper mot gjeldende passord-regler.';
$string['guestroleid'] = 'Gjesterolle';
$string['guestroleid_help'] = 'Denne rollen er automatisk lagt til gjestebrukeren. Den er også midlertid satt til ikke å ta imot påmeldinger fra brukere som kommer inn på kurset via plugin for gjestepåmelding.';
$string['helpadminseesall'] = 'Ser administratorer alle hendelser i kalenderen eller kun fra kurs de selv de meldt inn i? Uavhenig av dette valget vil administratorer alltid administrere hendelser for hvert kurs ved å først gå til kurset og så gå inn i kalenderen derfra.';
$string['helpcalendarcustomexport'] = 'Aktiver egentilpasset eksportvalg med datoutvalg i kalendereksport. Kalendereksport må aktiveres før denne innstillingen trer i kraft.';
$string['helpexportlookahead'] = 'Hvor mange dager framover i tid skal kalenderen se etter hendelser under eksporten i det egentilpassede eksportvalget?';
$string['helpexportlookback'] = 'Hvor mange dager tilbake i tid skal kalenderen se etter hendelser under eksporten i det egentilpassede eksportvalget?';
$string['helpforcetimezone'] = 'Du kan la brukere velge tidssone individuelt, eller du kan tvinge en tidssone på alle.';
$string['helpshowicalsource'] = 'Hvis aktivert, vil abonnementnavnet og lenken for iCal-importerte hendelser vises.';
$string['helpsitemaintenance'] = 'For oppgraderinger og vedlikehold';
$string['helpstartofweek'] = 'Hvilken dag starter uken på i kalenderen?';
$string['helpupcominglookahead'] = 'Hvor mange dager (som standard) inn i fremtiden skal kalenderen se etter begivenheter?';
$string['helpupcomingmaxevents'] = 'Hvor mange (maksimum) forestående hendelser vises til brukere som en standard';
$string['helpweekenddays'] = 'Hvilke ukerdager betraktes som "weekend" og skal vises med en annen farge?';
$string['hiddenuserfields'] = 'Skjul brukerfelt';
$string['hidefromall'] = 'Skjul fra alle brukere';
$string['hidefromnone'] = 'Ikke skjul for noen';
$string['hidefromstudents'] = 'Skjul for studenter';
$string['htmleditor'] = 'HTML-Editor';
$string['htmleditorsettings'] = 'HTML-editor innstillinger';
$string['htmlsettings'] = 'HTML-innstillinger';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP sikkerhet';
$string['hubs'] = 'Nav';
$string['iconvrequired'] = 'Et nødvendig PHP-tillegg: ICONV mangler.';
$string['ignore'] = 'Ignorér';
$string['includemoduleuserdata'] = 'Ta med modulens brukerdata';
$string['incompatibleblocks'] = 'Inkompatible blokker';
$string['incompleteunicodesupport'] = 'Det nåværende oppsettet av MySQL eller MariaDB bruker \'utf8\'. Dette tegnsettet støtter ikke 4 bytes tegn noe som inkluderer enkelte emojier. Dersom du bruker et av disse tegnene vil det føre til en feil og informasjonen som sendes til databasen vil bli tapt. Vennligst vurder å bytte tegnsett til \'utf8mb4\' i innstillingene. Se dokumentasjonen for alle detaljer.';
$string['indexdata'] = 'Indeksdata';
$string['indexinginfo'] = 'Den anbefalte måten å indeksere innholdet på din portale, er å bruke cron-jobben "Globalt søk indeksering"';
$string['installhijacked'] = 'Installasjonen må fullføres fra IP-adressen den ble startet fra, beklager.';
$string['installsessionerror'] = 'Kan ikke initialisere PHP-sesjonen, vennligstsjekk at nettleseren din tillater informasjonskapsler (cookies).';
$string['intlrecommended'] = 'Intl-tillegget brukes for å forbedre landspesifikke innstillinger, f.eks. sortering baset på lokale regler.';
$string['intlrequired'] = 'INTL-tillegget er påkrevd for å forbedre flerspråkstøtte og gir mulighet for lokal sorteringsrekkefølge og lokale varianter av internett domenenavn.';
$string['invalidagedigitalconsent'] = 'Ugyldig alder for samtykke: {$a}';
$string['invalidforgottenpasswordurl'] = 'Glemt passord-URL\'en er ikke en gyldig URL.';
$string['invalidsection'] = 'Ugyldig seksjon';
$string['invaliduserchangeme'] = 'Brukernavn "changeme" er reservert -- du kan ikke opprette en konto med det.';
$string['ipblocked'] = 'Denne portalen er ikke tilgjengelig akkurat nå.';
$string['ipblocker'] = 'IP-blokkerer';
$string['ipblockersyntax'] = 'Skriv inn en oppføring pr. linje. Gyldige oppføringer er enten full IP-addresse (som <b>192.168.10.1</b>) peker til en bestemt vert; eller del av en adresse (som <b>192.168</b>) samsvarer med alle adresser som begynner med siffrene; eller CIDR notasjon som <b>231.54.211.0/20</b>); eller et IP-addresseområde (som <b>231.3.56.10-20</b>) hvor området  skal samsvare med siste del av adressen. Testdomener (som example.com) er ikke støttet. Blanke linjer og tekst bak et "#"-tegn blir ignorert.';
$string['iplookup'] = 'IP-adresseoppslag';
$string['iplookupgeoplugin'] = 'En <a href="http://www.geoplugin.com">geoPlugin</a> brukes for å vise geografisk informasjon. For mer presise resultater anbefaler vi at det installeres en lokal kopi av MaxMind GeoLite databasen.';
$string['iplookupinfo'] = 'Som standard bruker Moodle den gratis NatGeo (The Internet Geographic Database) serveren for å slå opp sted for IP-adresser, dessverre blir ikke denne databasen vedlikeholdt lenger og kan gi <em>sykt feile</em> data.
Det anbefales at du installrer en lokal kopi av den gratis versjonen av GeoLite2 City database fra MaxMind.<br/> IP adressen blir vist på et enkelt kart eller ved å bruke Google Maps. Vær oppmerskom på at du trenger en Google konto og søke om en gratis Google Maps API nøkkel for å slå på interaktive kart.';
$string['iplookupmaxmindnote'] = 'Dette produktet inkluderer GeoLite2 data laget av MaxMind, tilgjengelig for nedlasting fra <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['ishttpswarning'] = 'Portalen din er ikke sikret med HTTPS. For økt sikkerhet og forbedrede integrasjoner med andre systemer anbefales det sterkt å migrere portalen til HTTPS.';
$string['keeptagnamecase'] = 'Behold store/små bokstaver i taggene';
$string['lang'] = 'Standard språk';
$string['langcache'] = 'Mellomlagre språkmenyen';
$string['langcache_desc'] = 'Mellomlagre språkmenyen. Hvis aktivert, vil listen over tilgjengelige oversettelser også bli mellomlagret. Mellomlageret blir automatisk oppdatert hver gang du installerer eller sletter en språkpakke via det innebygde språkpakkeverktøyet. Dersom du installerer en språkpakke manuelt må du tømme alle mellomlagre for å oppdatere språkmenyen.';
$string['langlist'] = 'Språk på språkmenyen';
$string['langmenu'] = 'Vis språkmenyen';
$string['langpackwillbeupdated'] = 'MERK: I løpet av oppgraderingen vil Moodle prøve å oppdatere alle installerte språkpakker.';
$string['langstringcache'] = 'Mellomlagre alle språkstrenger';
$string['languagesettings'] = 'Innstillinger for språk';
$string['latinexcelexport'] = 'Excel tegnsett';
$string['legacyfilesaddallowed'] = 'Tillat å legge til kursfiler (fra Moodle 1.9)';
$string['legacyfilesaddallowed_help'] = 'Dersom et kurs har et filområde fra Moodle 1.9.x - kan du tillate at nye filer og mapper kan legges til dette filområdet.';
$string['legacyfilesinnewcourses'] = 'Arvede kursfiler i nye kurs';
$string['legacyfilesinnewcourses_help'] = 'Som standard er arvede kursfiler bare tilgjengelig i oppgraderte kurs. Vennligst merk at enkelte gjøremål som sikkerhetskopiering/gjenoppretting ikke er kompatible med denne innstillingen.';
$string['libcurlwarning'] = 'Det er detektert at libcurl ikke har støtte for CURLOPT_PROTOCOL. Av sikkerhetsgrunner anbefaler vi at du oppdaterer libcurl-installasjonen.';
$string['licensesettings'] = 'Lisensinnstillinger';
$string['linkadmincategories'] = 'Lenk adminkategorier';
$string['linkadmincategories_help'] = 'Hvis aktivert, vil adminkategorier vises som lenker i navigasjonen og lede til administrasjonssider.';
$string['linkcoursesections'] = 'Alltid lenke til emnefelt';
$string['linkcoursesections_help'] = 'Vanligvis lenkes bare emnefeltene når kursformatet er satt til å vise ett emne per side. Hvis du aktiverer denne innstillingen vil det også lenkes til emnefelt når alle emnefeltene vises på kurssiden.';
$string['loading'] = 'Laster';
$string['localetext'] = 'Datoformat for portalen';
$string['localstringcustomization'] = 'Lokale språk filer';
$string['location'] = 'Sted';
$string['locationsettings'] = 'Innstillinger for sted';
$string['locked'] = 'Låst';
$string['lockoutduration'] = 'Varighet på sperring.';
$string['lockoutduration_desc'] = 'Sperret brukerkonto blir låst opp igjen etter denne perioden.';
$string['lockoutemailbody'] = 'Din brukerkonto med brukernavn {$a->username} på serveren \'{$a->sitename}\'
ble sperret etter en rekke ugyldige forsøk på å logge inn.

For å låse opp brukerkontoen øyeblikkelig, gå til følgende adresse

{$a->link}

I de fleste epostprogrammer vises dette som en blå lenke som du bare kan klikke på. Hvis det ikke virker, kan du kopiere nettadressen og lime den inn i adressefeltet på toppen av nettleservinduet ditt.

Hvis du trenger hjelp, vennligst ta kontakt med portaladministrator, {$a->admin}';
$string['lockoutemailsubject'] = 'Din brukerkonto på {$a} har blitt sperret.';
$string['lockouterrorunlock'] = 'Ugyldig opplåsingsinformasjon oppgitt.';
$string['lockoutthreshold'] = 'Terskel for å sperre brukerkonti';
$string['lockoutthreshold_desc'] = 'Velg antall mislykkede innlogginger som skal resultere i sperring av brukerkonto. Denne funksjonen kan misbrukes ved nekting av tjeneste-angrep.';
$string['lockoutwindow'] = 'Observasjonsvindu for sperring av brukerkonti';
$string['lockoutwindow_desc'] = 'Observasjonstid for terskel for å sperre brukerkonti. Hvis det ikke er noen mislykkede forsøk på å logge inn, blir terskeltelleren nullstilt etter denne tiden.';
$string['log'] = 'Logger';
$string['logguests'] = 'Logg gjestetilgang';
$string['logguests_help'] = 'Denne innstillingen aktiverer logging av handlinger fra gjestebrukere og brukere som ikke er innlogget.Portaler med mye trafikk vil nok kanskje deaktivere denne loggefunksjonen for å spare systemressurser. Det er anbefalt å la logging være aktivert på portaler i produksjon.';
$string['loginhttps'] = 'Bruk HTTPS ved innlogging';
$string['loginpageautofocus'] = 'Autofokus innloggingsskjema';
$string['loginpageautofocus_help'] = 'Hvis du aktiverer denne funksjonen, øker brukervennligheten av innloggingssiden for brukere med spesielle behov.';
$string['loginpasswordautocomplete'] = 'Forhindre autoutfylling av passord i innloggingsskjemaet.';
$string['loginpasswordautocomplete_help'] = 'Når aktivert, kan ikke brukere lagre passordet sitt i nettleseren';
$string['loglifetime'] = 'Behold loggene i';
$string['logo'] = 'Logo';
$string['logocompact'] = 'Bedriftslogo';
$string['logocompact_desc'] = 'En kompakt versjon av logoen. Dette bildet må vises klart og tydelig selv i små størrelser.Bildeformatet må være PNG eller JPEG';
$string['logo_desc'] = 'En stor logo som kan brukes som dekorasjon i enkelte design. Dette bildet bør ha ganske høy oppløsning fordi det vil bli skalert nedved bruk. Logoer som har større bredde enn høyde vil vanligvis se best ut. Bildeformatet må være PNG eller JPEG.';
$string['logossettings'] = 'Logoer';
$string['logstorenotrequired'] = 'Loggarkiv ikke påkrevd';
$string['logstoressupported'] = 'Loggarkiver som støtter denne rapporten';
$string['longtimewarning'] = '<b>Vær tålmodig, denne prosessen kan ta noe tid.</b>';
$string['mailnewline'] = 'Nylinje tegn i epost';
$string['maintenancemode'] = 'I vedlikeholdsmodus';
$string['maintenancemodeisscheduled'] = 'Portalen går over til vedlikeholdsmodus om {$a} minutter og {$a->sec} sekunder.';
$string['maintenancemodeisscheduledlong'] = 'Dette nettstedet vil gå over til vedlikeholdsmodus om {$->hours} timer, {$a->min} minutter og {$a->sec} sekunder.';
$string['maintfileopenerror'] = 'Feil ved åpning av vedlikeholdsfiler!';
$string['maintinprogress'] = 'Vedlikehold pågår ...';
$string['managecontextlock'] = 'Lås denne konteksten';
$string['managecontextlocklocked'] = '{$a->contextname} og alle underornede kontekster er nå låst.';
$string['managecontextlockunlocked'] = '{$a->contextname} og alle underordnede kontekster er nå åpnet.';
$string['managecontextunlock'] = 'Åpne denne konteksten';
$string['manageformats'] = 'Administrer kursformater';
$string['manageformatsgotosettings'] = 'Standardformatet kan endres i {$a}';
$string['managelang'] = '<b>Administrer</b>';
$string['managelicenses'] = 'Administrere lisenser';
$string['manageqbehaviours'] = 'Administrer spørsmålsatferd';
$string['manageqtypes'] = 'Administrere spørsmålstyper';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Klargjøres for lansering';
$string['maturity200'] = 'Stabil versjon';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Hint: Du vil kanskje kjøre dette skriptet med -allow-unstable valget';
$string['maturitycoreinfo'] = 'Kursportalen din kjører for øyeblikket den ustabile "{$a}" utviklerversjonen.';
$string['maturitycorewarning'] = 'Du er i ferd med å installere eller oppgradere Moodle til en versjon merket som "{$a}". En slik versjon regnes ikke som produksjonsklar ennå. Hvis dette ikke er ønsket, forsikre deg om at du bruker korrekt utsjekk fra Moodles kildekode. See Moodle Docs for mer informasjon.';
$string['maxbytes'] = 'Max filstørrelse for opplasting';
$string['maxconsecutiveidentchars'] = 'Fortløpende identiske tegn';
$string['maxeditingtime'] = 'Max tid for endring av innlegg';
$string['maxtimelimit'] = 'Maks tidsgrense';
$string['maxtimelimit_desc'] = 'For å begrense maksimum PHP-kjøretid for skript i Moodle, uten at noe resultat kommer ut av det, kan du skrive inn en verdi i sekunder her. "0" betyr at Moodles standard begrensning blir benyttet. Hvis du har en front-end server med sin egen tidsgrense, kan du angi denne verdien lavere for å få med PHP-feil i loggene. Dette gjelder ikke skript som kjøres via CLI.';
$string['maxusersperpage'] = 'Maks antall brukere per side';
$string['mbstringrecommended'] = 'Installering av det valgfrie bibliotek MBSTRING er  anbefalt for at du skal forbedre ytelsen til nettstedet, spesielt hvis nettstedet støtter ikke-latinske språk.';
$string['mbstringrequired'] = 'Installere mbstring bibliotek er nødvendig for å forbedre ytelsen til nettstedet, spesielt hvis nettstedet støtter ikke-latinske språk.';
$string['mediapluginavi'] = 'Skru på filter for .avi-filer';
$string['mediapluginflv'] = 'Skru på filter for .flv-filer';
$string['mediapluginimg'] = 'Aktiver automatisk innebygging av lenkede bilder';
$string['mediapluginmov'] = 'Skru på filter for .mov-filer';
$string['mediapluginmp3'] = 'Skru på filter for .mp3-filer';
$string['mediapluginmpg'] = 'Skru på filter for .mpg-filer';
$string['mediapluginogg'] = 'Aktiviser .ogg-filteret';
$string['mediapluginogv'] = 'Aktiviser .ogv-filteret';
$string['mediapluginram'] = 'Skru på filter for .ram-filer';
$string['mediapluginrm'] = 'Skru på filter for .rm-filer';
$string['mediapluginrpm'] = 'Skru på filter for .rpm-filer';
$string['mediapluginswf'] = 'Skru på filter for .swf-filer';
$string['mediapluginswfnote'] = 'Som en standard sikkerhetsinnstilling, bør ikke vanlige brukere tillates å legge inn swf-filer embedded i en tekst.';
$string['mediapluginwmv'] = 'Skru på filter for . wmv-filer';
$string['mediapluginyoutube'] = 'Aktivér YouTube-filter';
$string['messaging'] = 'Aktiviser meldingssystemet';
$string['messagingallowemailoverride'] = 'Overstyring av varsling via e-post';
$string['messagingallusers'] = 'Tillat meldinger fra alle på denne portalen';
$string['messagingdeleteallnotificationsdelay'] = 'Slett alle varsler';
$string['messagingdeletereadnotificationsdelay'] = 'Slett leste varsler';
$string['minpassworddigits'] = 'Tall';
$string['minpasswordlength'] = 'Passordlengde';
$string['minpasswordlower'] = 'Små bokstaver';
$string['minpasswordnonalphanum'] = 'Spesialtegn';
$string['minpasswordupper'] = 'Store bokstaver';
$string['misc'] = 'Forskjellig';
$string['mnetrestore_extusers'] = '<strong>OBS:</strong> Denne sikkerhetskopien inneholder brukere fra andre Moodle Network-installasjoner som vil bli tilbakeført som en del av gjenopprettingsprosessen.';
$string['mnetrestore_extusers_admin'] = '<strong>Merk:</strong>Denne sikkerhetskopien ser ut som den kommer fra en annen Moodleinstallasjon og inneholder brukerkonti fra et annet Moodlenettverk. Gjenopprettingsprosessen vil prøve å matche Moodlenettverksverter for alle opprettede brukere. De som ikke har match vil bli satt over på intern autentisering (istedet for mnet). Opprettingsloggen vil gi deg all informasjon om dette.';
$string['mnetrestore_extusers_mismatch'] = '<strong>OBS:</strong> Denne sikkerhetskopien ser ut til å komme fra en annen Moodle-installasjon og inneholder brukerkontoer fra Moodle Network. Dette kan føre til feil, og funksjonen er ikke støttet. Er du sikker på at denne sikkerhetskopien er opprettet her, eller at nødvendige Moodle Network Host er satt opp, kan du jo forsøke en gjenoppretting.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Merk:</strong>Denne sikkerhetskopien ser ut som den kommer fra en annen Moodleinstallasjon og inneholder brukerkonti fra et annet Moodlenettverk.
Du har ikke tillatelse til å kjøre en slik gjenoppretting. Kontakt ansvarlig for nettstedet eller, alternativt, gjenopprett dette kurset uten brukerinformasjon (moduler,filer...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Moodle Network Fjernbruker {$a->username} (som kommer fra {$a->mnethosturl}) byttes til lokal {$a->auth} autentisert bruker.';
$string['mobilenotconfiguredwarning'] = 'Moodleappen er ikke aktivert';
$string['modchooserdefault'] = 'Standard aktivitetsvelger';
$string['modeditdefaults'] = 'Standardverdier for aktivitetsinnstillinger';
$string['modsettings'] = 'Administrer aktiviteter';
$string['modulesecurity'] = 'Sikkerhet for moduler';
$string['moodleapp'] = 'Moodleapp';
$string['moodleapp_help'] = '<p>Dersom du har en brukerkonto på en Moodleportal kan du få tilgang til alle kursene dine på mobile enheter med Moodleappen.</p>
<a href="https://moodle.com/mobile-app">Få Moodleappen</a>';
$string['moodlebrandedapp'] = 'Tilpasset Moodleapp';
$string['moodlebrandedapp_help'] = '<p>Den tilpassede Moodleappen har allfunksjonalitet fra den vanlige appen kombinert med dine tilpasninger.</p>
<a href="https://moodle.com/branded-app">Om den tilpassede Moodleappen.</a>';
$string['moodlebrandedappreference'] = 'Alternativt kan du skaffe deg den <a href="https://moodle.com/branded-app">tilpassede Moodleappen</a> med dine egne designmessige tilpasninger.';
$string['moodleorghubname'] = 'Moodle';
$string['moodlepartners'] = 'Moodle partnere';
$string['moodlepartners_help'] = '<p>Moodle partnere er tjenestetilbydere som er sertifisert av Moodle hoedkvarter for å tilby høykvalitets Moodletjenester for e-læring. </p>
<a href="https://moodle.com/about-partners/">Om våre partnere</a><br />
<a href="https://moodle.com/partners">Finn en partner</a>';
$string['moodleservices'] = 'Moodletjenester';
$string['moodleservices_help'] = 'Forsikre deg om at du får det beste fra Moodles LMS ved å bruke disse Moodletjenestene:';
$string['multilangforceold'] = 'Tving gammel multilangsyntaks: &lt;span&gt; uten klassen="multilang" og &lt;lang&gt;';
$string['mustenablestats'] = 'Statistikk er ikke aktivisert ennå på denne portalen.';
$string['mycoursesperpage'] = 'Maks antall kurs som skal vises pr.side på brukerens kursoversikt';
$string['mydashboard'] = 'Kontrollpanel for systemets standardinnstillinger';
$string['mymoodle'] = 'Min startside';
$string['mymoodleredirect'] = 'Vanlige brukere får "Min Moodle" som hovedside';
$string['mypage'] = 'Standard Min startside';
$string['mypagelocked'] = 'Lås standard side';
$string['myprofile'] = 'Standard profilside';
$string['navadduserpostslinks'] = 'Legg til lenker for å se brukerinnlegg';
$string['navadduserpostslinks_help'] = 'Hvis aktivert, vil det legges til to lenker på hver bruker i navigasjonen for å vise diskusjoner brukeren har startet og innlegg brukeren har bidratt med i forum på kursportalen eller i bestemte kurs.';
$string['navcourselimit'] = 'Kursgrense';
$string['navigationupgrade'] = 'Denne oppgraderingen vil introdusere to nye navigasjonsblokker som vil erstatte disse blokkene: Administrasjon, Kurs, Aktiviteter og Deltakere. Dersom du hadde satt bestemte tilganger på disse blokkene bør du sjekke om alt fortsatt oppførerer seg som du ønsker.';
$string['navshowallcourses'] = 'Vis alle kurs';
$string['navshowcategories'] = 'Vis kurskategorier';
$string['navshowfrontpagemods'] = 'Vis hovedsidens aktiviteter i navigasjonen';
$string['navshowfrontpagemods_help'] = 'Hvis aktivert, vil hovedsidens aktiviteter og ressurser vises i navigasjonen under kursportalsider.';
$string['navshowfullcoursenames'] = 'Vis kursenes fulle navn';
$string['navshowfullcoursenames_help'] = 'Hvis aktivert, blir kursene vist med sine fulle navn i navigasjonen i stedet for kortnavnene.';
$string['navshowmycoursecategories'] = 'Vis mine kurskategorier';
$string['navshowmycoursecategories_help'] = 'Hvis aktivert, vil kurs under Mine kurs vises sortert i de kategoriene de hører til under.';
$string['navsortmycoursessort'] = 'Sortér mine kurs';
$string['navsortmycoursessort_help'] = 'Bestemmer hvordan kursene skal vises under "Mine kurs" og hvilken sorteringsrekkefølge som skal brukes. Som standard vises de slik de ligger i kurskatalogen.';
$string['never'] = 'Aldri';
$string['neverdeleteruns'] = 'Slett aldri kjørende jobber';
$string['newestdocindexed'] = 'Nyeste dokument indeksert';
$string['nobookmarksforuser'] = 'Du har ingen bokmerker';
$string['nodatabase'] = 'Ingen database';
$string['nohttpsformobilewarning'] = 'Det anbefales å aktivere HTTPS med et gyldig sertifikat. Moodleappen vil alltid prøve den sikre forbindelsen først.';
$string['nomissingstrings'] = 'Ingen manglende strenger';
$string['none'] = 'Ingen';
$string['nonewsettings'] = 'Det er ikke lagt til noen nye innstillinger i denne oppgraderingen.';
$string['nonexistentbookmark'] = 'Bokmerket du ba om eksisterer ikke';
$string['noreplyaddress'] = 'No-reply adresse';
$string['noreplydomain'] = 'Ikke-svar og domene';
$string['noreplydomaindetail'] = 'Innstillinger for ikke-svar og konfigurerte domener';
$string['noresults'] = 'Ingen resultater';
$string['noroles'] = 'Ingen roller';
$string['nosupportedlogstore'] = 'Fant ingen støttede loggarkiver';
$string['notifications'] = 'Varslinger';
$string['notifyloginfailures'] = 'Mislykkede login sendes på e-post til';
$string['notifyloginthreshold'] = 'Ventetid før e-post sendes';
$string['notloggedinroleid'] = 'Rolle for besøkende';
$string['numberofmissingstrings'] = 'Antall manglende strenger: {$a}';
$string['numberofstrings'] = 'Totalt antall strenger: {$a->strings}<br/>Mangler: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Oppdateringstokenet for en av OAuth-tjenestene {$a->issuer} på din portal: {$a->siteurl}  er utløpt. Dette vil begrense funksjonaliteten for alle moduler som benytter denne tjenesten. For å fikse dette må du gå til OAuth 2-tjenestenes innstillinger og klikke på "Koble til systemkonto"-ikonet i tabellraden for denne tjenesten. Vær sikker på at du er innlogget med samme tjenestekonto for OAuth-tjenesten hver gang.';
$string['oauthrefreshtokenexpiredshort'] = 'OAuth-oppdateringstoken er utløpt for  {$a->issuer} på din portal: {$a->siteurl}.';
$string['onlynoreply'] = 'Kun ved sending fra en ikke-svar adresse';
$string['opcacherecommended'] = 'PHP opcode mellomlagring forbedrer ytelsen og reduserer minnebehovet. OPcache-tillegget anbefales og støttes fullt ut.';
$string['opensslrecommended'] = 'Vi anbefaler sterkt at openssl-biblioteket installeres. Du må ha det for å aktivisere Moodle Network funksjonaliteten.';
$string['opensslrequired'] = 'OpenSSL PHP-utvidlesen kreves nå av Moodle for å tilby sterkere krypteringstjenester.';
$string['opentogoogle'] = 'Åpen for Google';
$string['optionalmaintenancemessage'] = 'Ekstra vedlikeholdsmelding';
$string['order1'] = 'Første';
$string['order2'] = 'Andre';
$string['order3'] = 'Tredje';
$string['order4'] = 'Fjerde';
$string['outgoingmailconfig'] = 'Konfigurasjon av utgående epost';
$string['overridetossl'] = 'HTTPS for innlogginger er foreldet. Denne instansen er nå tvunget til SSL. For å fjerne denne advarselen må du endre wwwroot i config.php til HTTPS://';
$string['pageinfodebugsummary'] = 'Denne siden er: {$a}';
$string['passwordchangelogout'] = 'Logg ut etter passordbytte';
$string['passwordchangelogout_desc'] = 'Når aktivert vil alle andre enn den aktive fanen lukkes automatisk. (Innstillingen påvirker ikke passordbytte fra masseopplasting av brukere.';
$string['passwordchangetokendeletion'] = 'Fjern tilgangangstokener til webtjenester etter passordbytte';
$string['passwordchangetokendeletion_desc'] = 'Hvis aktivert, vil alle tilgangstokener for webtjenester bli slettet når et passord endres.';
$string['passwordpolicy'] = 'Passordregler';
$string['passwordresettime'] = 'Maksimal tid for å bekrefte nytt passord';
$string['passwordreuselimit'] = 'Rotasjonsgrense på passord';
$string['passwordreuselimit_desc'] = 'Antall ganger en bruker må endre passordet sitt, før brukeren kan gjenbruke et gammelt passord. Tidligere passord lagres i en lokal databasetabell. Denne innstillingen fungerer ikke nødvendigvis mot ved bruk av eksterne autentifiseringsmoduler.';
$string['pathtodot'] = 'Sti til dot';
$string['pathtodot_help'] = 'Sti til dot. For Linux er det noe slikt som /usr/bin/dot. På Windows er det noe slikt som C:\\Program Files(x86)\\Graphviz2.38\\bin\\dot.exe. På Mac er det noe slikt som /op/local/bin/dot. For å kunne generere grafikk fra dot-filer må du ha dot installert og peke til programmet her.';
$string['pathtodu'] = 'Sti til "du"';
$string['pathtogs'] = 'Sti til ghostscript';
$string['pathtogs_help'] = 'I de fleste Linuxinstallasjoner kan dette feltet settes til \'/ust/bin/gs\'. For Windows vil det være noe sånt som \'c:\\gs\\bin\\gswin32c.exe\' (forsikre deg om at det ikke er langt inn noen mellomrom i stein - om nødvending kpoier filene \'gswin32.exe\' og \'gsdll32.dll\' til en ny mappe uten mellomrom i stien.';
$string['pathtopgdump'] = 'Sti til pg_dump';
$string['pathtopgdumpdesc'] = 'Dette trenger du kun spesifisere dersom du har mer enn en pg_dump på ditt system (for eksempel hvis du har installert mer enn en versjon av postgresql)';
$string['pathtopgdumpinvalid'] = 'Ugyldig sti til pg_dump - enten gal sti eller ikke eksekverbar';
$string['pathtophp'] = 'Sti til PHP CLI';
$string['pathtopsql'] = 'Sti til psql';
$string['pathtopsqldesc'] = 'Dette trenger du kun spesifisere dersom du har mer enn en psql på systemet (for eksempel hvis du har installert mer enn en versjon av postgresql)';
$string['pathtopsqlinvalid'] = 'Ugyldig sti til psql - enten gal sti eller ikke eksekverbar';
$string['pathtopython'] = 'Sti til Python';
$string['pathtopythondesc'] = 'Sti til din kjørbare Python binærfil (både Python 2 og Python 3 aksepteres)';
$string['pathtosassc'] = 'Sti til SassC';
$string['pathtosassc_help'] = 'Spesifisering av plasseringen av SassC binær-fil vil bytt SASS kompilerer fra Moodle PHP implementering til SassC. Se http://github.com/sass/sassc for mer informasjon.';
$string['pcreunicodewarning'] = 'Det anbefales på det sterkeste å bruke PCRE PHP-tillegget som er kompatibelt med Unicode-tegnsettet.';
$string['perfdebug'] = 'Info om ytelse';
$string['performance'] = 'Ytelse';
$string['pgcluster'] = 'PostgreSQL klynge';
$string['pgclusterdescription'] = 'PostgreSQL versjons/cluster parametre for bruk ved kommandolinjen. Dersom du har bare en PostgreSQL på systemet ditt, eller ikke er helt sikker på hva dette er, la feltet stå tomt.';
$string['phpfloatproblem'] = 'Oppdaget uventet problem i behandlingen av PHP flytnummer - {$a}';
$string['pleaserefreshregistration'] = 'Portalregistreringen din er oppdatert og ble sist oppdatert {$a}. <br /> Den planlagte oppgaven \'Portalregistrering\' sørger for å holde registreringen din oppdatert. Du kan når som helst oppdatere registreringen manuelt.';
$string['pleaserefreshregistrationnewdata'] = 'Registreringsinformasjonen er endret. Vennligst bekreft den ved å bruke "Oppdater registrering"-knappen.';
$string['pleaserefreshregistrationunknown'] = 'Portalen din er registrert, men registreringsdatoen er ukjent. Vennligst oppdater registreringen ved å bruke "Oppdater registrering"s-knappen eller forsikre deg om at cron-jobben "Portalregistrering" er aktivert slik at dette skjer automatisk.';
$string['plugin'] = 'Modul';
$string['plugins'] = 'Moduler';
$string['pluginscheck'] = 'Sjekk av modulavhengigheter';
$string['pluginscheckfailed'] = 'Sjekk av modulavhengigheter ga feilmeldinger for {$a->pluginslist}';
$string['pluginschecktodo'] = 'Du må løse alle modulkravene før du installerer denne Moodle-versjonen!';
$string['pluginsoverview'] = 'Moduloversikt';
$string['pluginsoverviewsee'] = 'Se <a href="{$a->url}">moduloversikt</a>siden for mer informasjon.';
$string['policysettings'] = 'Regelinnstillinger';
$string['privacyandpolicies'] = 'Personvern og regler';
$string['privacy:metadata'] = 'Modulen "Administrasjon" lagrer ikke noen persondata.';
$string['privacysettings'] = 'Personverninnstillinger';
$string['profilecategory'] = 'Kategori';
$string['profilecategoryname'] = 'Kategorinavn (må være unikt)';
$string['profilecategorynamenotunique'] = 'Dette kategorinavnet er allerede i bruk';
$string['profilecommonsettings'] = 'Vanlige innstillinger';
$string['profileconfirmcategorydeletion'] = 'Det er {$a} felter i denne kategorien som vil bli flyttet til kategorien over.<br/>Ønsker du fortsatt å slette denne kategorien?';
$string['profileconfirmfielddeletion'] = 'Det er {$a} brukerdata for dette feltet som vil bli slettet. <br/>Ønsker du fortsatt å slette dette feltet?';
$string['profilecreatecategory'] = 'Opprett ny kategoriprofil';
$string['profilecreatefield'] = 'Opprett nytt profilfelt';
$string['profilecreatenewcategory'] = 'Oppretter en ny kategori';
$string['profilecreatenewfield'] = 'Oppretter et nytt \'{$a}\' profilfelt';
$string['profiledefaultcategory'] = 'Andre felt';
$string['profiledefaultchecked'] = 'Merket av som standard';
$string['profiledefaultdata'] = 'Standardverdi';
$string['profiledeletecategory'] = 'Sletter en kategori';
$string['profiledeletefield'] = 'Sletter felt \'{$a}\'';
$string['profiledescription'] = 'Feltbeskrivelse';
$string['profiledscript'] = 'Dette skriptet er nå profilert.';
$string['profiledscriptview'] = 'Vis profileringsinformasjon for dette skriptet';
$string['profileeditcategory'] = 'Redigerer kategorien: {$a}';
$string['profileeditfield'] = 'Redigerer profilfeltet: {$a}';
$string['profilefield'] = 'Profilfelt';
$string['profilefieldcolumns'] = 'Kolonner';
$string['profilefieldispassword'] = 'Er dette et passordfelt';
$string['profilefieldlink'] = 'Lenke';
$string['profilefieldlink_help'] = 'For å konvertere en tekst til en lenke, kan du legge inn en URL som inneholder $$, hvor $$ vil bli erstattet med teksten. For eksempel: Ønsker du å konvertere en Twitter ID til en lenke skriver du inn http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Lenkemål';
$string['profilefieldmaxlength'] = 'Max lengde';
$string['profilefieldrows'] = 'Rader';
$string['profilefields'] = 'Bruker profilfelt';
$string['profilefieldsize'] = 'Vises i størrelse';
$string['profileforceunique'] = 'Skal data være unike?';
$string['profileinvaliddata'] = 'Ugyldig verdi';
$string['profilelocked'] = 'Er dette feltet låst?';
$string['profilemenudefaultnotinoptions'] = 'Standardverdien er ikke en av valgene.';
$string['profilemenunooptions'] = 'Ingen menyvalg støttet';
$string['profilemenuoptions'] = 'Menyvalg (ett pr.linje)';
$string['profilemenutoofewoptions'] = 'Du må angi minst to valg';
$string['profilename'] = 'Navn';
$string['profilenofieldsdefined'] = 'Ingen felter er definert';
$string['profilerequired'] = 'Er dette feltet obligatorisk?';
$string['profileroles'] = 'Synlige rolleprofiler';
$string['profilesforenrolledusersonly'] = 'Profiler kun for påmeldte brukere';
$string['profileshortname'] = 'Kort-navn (unikt)';
$string['profileshortnameinvalid'] = 'Kortnavnet kan bare inneholde alfanumeriske tegn (bokstaver og tall) eller understrek (_).';
$string['profileshortnamenotunique'] = 'Dette kort-navnet er allerede i bruk';
$string['profilesignup'] = 'Vis på side for brukerregistrering?';
$string['profilespecificsettings'] = 'Spesielle innstillinger';
$string['profilevisible'] = 'Hvem er dette feltet synlig for?';
$string['profilevisibleall'] = 'Synlig for alle';
$string['profilevisible_help'] = '<p>Hvert egendefinert felt kan gis en av tre innstillinger for synlighet: usynlig, alle og bruker. Usynlig-innstillingen brukes typisk av administrator til å lagre private data på den enkelte bruker. Bruker-innstillingen velges normalt for felt inneholder sensitiv informasjon, mens Alle-innstillingen kan brukes for felt som alle kan se.</p>';
$string['profilevisiblenone'] = 'Ikke synlig';
$string['profilevisibleprivate'] = 'Synlig for brukeren';
$string['profiling'] = 'Profilering';
$string['profilingallowall'] = 'Kontinuerlig profilering';
$string['profilingallowall_help'] = 'Dersom du aktiverer denne innstillingen kan du når som helst bruke parameteren PROFILEALL hvor som helst for å aktivere profilering for alle kjørte skript i Moodle-sesjonen. Tilsvarende kan du bruke parameteren PROFILEALLSTOP for å stoppe den.';
$string['profilingallowme'] = 'Selektiv profilering';
$string['profilingallowme_help'] = 'Dersom du aktiverer denne innstillingen kan du selektivt bruke parameteren PROFILEME hvor som helst og dette skriptet blir profilert. Tilsvarende kan du bruke parameteren DONTPROFILEME for å forhindre profilering.';
$string['profilingautofrec'] = 'Automatisk profilering';
$string['profilingautofrec_help'] = 'Ved å konfigurerere denne innstillingen, kan noen forespørsler ( tilfeldige, basert på angitt frekvens - 1  av  XXX) bli fanget opp og automatisk profilert og lagret for fremtidig analyser. Merk at denne måten å profilere på er avhengig av inkluder/eksluder-innstillingene. Sett verdien -0- for å deaktivere automatisk profilering.';
$string['profilingenabled'] = 'Aktiver profilering';
$string['profilingenabled_help'] = 'Dersom du aktiverer denne innstillingen vil profilering blir tilgjengelig på denne portalen og kan bestemme oppførselen ved å sette oppp de neste valgene.';
$string['profilingexcluded'] = 'Ekskluder profilering';
$string['profilingexcluded_help'] = 'Liste over (kommaseparerte, absolutte uten www-rotmappen) URL-er sopm blir unntatt fra profilering fra de som er angitt i "Profiler disse" innstillingene.';
$string['profilingimportprefix'] = 'Prefix for importprofiling';
$string['profilingimportprefix_desc'] = 'For lettere å finne igjen importen vil alle importerte profier får prefiksen du angir her.';
$string['profilingincluded'] = 'Profiler disse';
$string['profilingincluded_help'] = 'Liste over (kommaseparerte, absolutte uten www-mappen, aktive) URL-er som vil bli automatisk profilert. Eks:  /index.php, /course/view.php. Godtar også stjernetegn *  i alle posisjoner. Eks: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Behold profileringskjøringer';
$string['profilinglifetime_help'] = 'Angi hvor lang tid du vil ta vare på informasjon fra eldre profileringskjøringer. Mer at dette utelater alle profileringskjøringer merket som "referansekjøring".';
$string['protectusernames'] = 'Skjul brukernavnene';
$string['proxybypass'] = 'Mellomlagringsservere';
$string['proxyhost'] = 'Proxyserver';
$string['proxypassword'] = 'Proxypassord';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Proxytype';
$string['proxyuser'] = 'Proxybrukernavn';
$string['purgecaches'] = 'Oppdater alle mellomlagre';
$string['purgecachesconfirm'] = 'Moodle kan mellomlagre designfiler, javascript, språkstrenger, filtrert tekst, rss og mange andre typer data. Tømming av disse mellomlagrene vil slette data fra serveren og tvinge nettleserne til å lese inn dataene en gang til så du blir sikker på at du ser de siste dataene produsert av gjeldende kode. Det er ikke farlig å tømme mellomlagrene, men portalen kan oppleves som treg inntil serveren og brukerne har lastet ned ny informasjon og mellomlagret det igjen.';
$string['purgecachesfinished'] = 'Alle mellomlagre ble oppdatert';
$string['purgecachesnoneselected'] = 'Velg et eller flere mellomlagre å tømme';
$string['purgecachespage'] = 'Tøm mellomlagre';
$string['purgefiltercache'] = 'Tekstfiltre';
$string['purgejscache'] = 'JavScript';
$string['purgelangcache'] = 'Språkstrenger';
$string['purgemuc'] = 'Alle MUC mellomlagre';
$string['purgeothercaches'] = 'Alle fil og diverse mellomlagre';
$string['purgeselectedcaches'] = 'Tøm valgte mellomlagre';
$string['purgeselectedcachesfinished'] = 'Valgte melomlagre ble tømt.';
$string['purgethemecache'] = 'Design';
$string['query'] = 'Spørring';
$string['question'] = 'Spørsmål';
$string['questionbehaviours'] = 'Spørsmålsatferd';
$string['questioncwqpfscheck'] = 'En eller flere \'tilfeldige\' spørsmål i prøvemodulen er satt opp til å velge spørsmål fra en blanding av delte og udelte spørsmålskategorier. Det finnes en mer detaljert rapport <a href="{$a->reporturl}">her</a> og se Moodle Docs side <a href="{$a->docsurl}">her</a>.';
$string['questioncwqpfsok'] = 'Bra. Det er ingen \'tilfeldige\' spørsmål i quizene som er satt opp til å velge spørsmål fra en blanding av delte og udelte kategorier.';
$string['questiontype'] = 'Spørsmålstype';
$string['questiontypes'] = 'Spørsmålstyper';
$string['quizattemptsupgradedmessage'] = 'I Moodle 2.1 kom det en stor oppgradering av spørsmål. Det ble mulig å utsette en del av databaseoppgraderingen til senere. Før du oppgraderer til Moodle 2.7 må denne oppgraderingen være fullført.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA privat nøkkel';
$string['recaptchapublickey'] = 'ReCAPTCHA offentlig nøkkel';
$string['register'] = 'Registrér kursportalen din';
$string['registermoodlenet'] = '<p>Vi ønsker å gi deg informasjon om viktige nyheter for din Moodleportal!</p><p>Ved å registrer deg får du:</p>
<ul>
<li>Tidlig informasjon om sikkerhetsvarsler og nye Moodleutgivelser.</li>
<li>Tilgang til å aktivere pushvarsler fra din Moodleportal via den gratisen appen<a href="https://download.moodle.org/mobile/">Moodle Mobile</a></li>
<li>Bidra til <a href="https://moodle.net/stats/">Moodle statistics</a> for verdensomspennende bruk av Moodle som er til hjelp i videreutviklingen av oodle.</li>
<li>Muligheten til å inkluderes på <a href="https://moodle.net/sites/">listen med registrerte Moodleportaler</a> i landet ditt.</li></ul>';
$string['registermoodleorg'] = 'Når du registrerer kursportalen din';
$string['registermoodleorgli1'] = 'Du er lagt til en lavvolums e-postliste hvor det kun sendes ut viktige sikkerhetsmeldinger og varsler om nye utgaver av Moodle.';
$string['registermoodleorgli2'] = 'Statistikk fra din kursportal vil bli lagt til {$a} som en del av det globale Moodlefellesskapet.';
$string['registerwithmoodleorg'] = 'Registrer portalen din';
$string['registration'] = 'Registrering';
$string['registration_help'] = 'Ved registrering:

* Du vil motta sikkerhetsvarsler
* Du kan aktivere mobil-appen og push-meldinger fra portalen din
* Du bidrar til vår statistikk over global utbredelse av Moodle';
$string['registrationwarning'] = 'Kursportalen din er ikke registrert ennå.';
$string['registrationwarningcontactadmin'] = 'Denne portalen er ikke registrert. Vennligst kontakt portaladministratoren.';
$string['releasenoteslink'] = 'For mer informasjon om denne versjonen av Moodle, sjekk online via  <a target="_new" href="{$a}">Release Notes</a>';
$string['rememberusername'] = 'Husk brukernavn';
$string['rememberusername_desc'] = 'Aktiver hvis du ønsker at det skal permanent skal lagres en cookie med brukernavn. Permanente cookies kan være en risiko hvis det brukes uten samtykke.';
$string['reportsmanage'] = 'Administrere rapporter';
$string['requestcategoryselection'] = 'Aktiver kategorivalg';
$string['requiredentrieschanged'] = 'Merk: Etter oppgradering er innstillingen \'Krev utfylling før visning\' nå tvungen for følgende databaseaktiviteter::<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Krever aktivitetsbeskrivelse';
$string['requiremodintro_desc'] = 'Når aktivert vil denne innstillingen tvinge alle brukere til å fylle ut beskrivelsesfeltet i alle aktiviteter';
$string['requires'] = 'Krever';
$string['restorecourse'] = 'Gjenopprett kurs';
$string['restorernewroleid'] = 'Gjenoppretters rolle i kurs';
$string['restorernewroleid_help'] = 'Hvis brukeren ikke allerede har tillatelse til å administrere nylig gjenopprettede kurs, blir brukeren automatisk tildelt denne rollen og om nødvendig påmeldt. Velg "Ingen" hvis du ikke ønsker at gjenopprettere skal være i stand til å administrere hvert gjenopprettede kurs.';
$string['reverseproxy'] = 'Revers proxy';
$string['riskconfig'] = 'Brukeren kan endre site-oppsettet og hvordan det oppfører seg!';
$string['riskconfigshort'] = 'Risiko ved innstillingene';
$string['riskdataloss'] = 'Brukere kan ødelegge store mengder innhold eller informasjon';
$string['riskdatalossshort'] = 'Risiko for tap av data';
$string['riskmanagetrust'] = 'Brukere kan endre sikkerhetsinnstillinger på andre brukere';
$string['riskmanagetrustshort'] = 'Administrere sikre siter';
$string['riskpersonal'] = 'Brukere kan få tilgang til privat informasjon hos andre brukere.';
$string['riskpersonalshort'] = 'Risiko for privat info';
$string['riskspam'] = 'Brukere kan sende spam til site-brukere eller andre';
$string['riskspamshort'] = 'Risiko for spam';
$string['riskxss'] = 'Brukere kan legge til filer og tekst som tillater skripting mellom siter.';
$string['riskxssshort'] = 'XSS risiko';
$string['roleswithexceptions'] = '{$a->roles}, med {$a->exceptions}';
$string['rssglobaldisabled'] = 'Slå av på portalnivå';
$string['save'] = 'Lagre';
$string['savechanges'] = 'Lagre endringer';
$string['scssinvalid'] = 'Ugyldig SCSS-kode, feilet med {$a}';
$string['search'] = 'Søk';
$string['searchallavailablecourses'] = 'Søkbare kurs';
$string['searchallavailablecourses_desc'] = 'I noen situasjoner kan det hende at søkemotoren ikke fungerer mens den søker gjennom mange kurs. Be den om å kun søke gjennom påmeldte kurs for å begrense søket.';
$string['searchallavailablecourses_off'] = 'Søk kun innen påmeldte kurs';
$string['searchallavailablecourses_on'] = 'Søk innen alle tilgjengelige kurs';
$string['searchalldeleted'] = 'Alt indeksert innhold har blitt slettet';
$string['searchareadisabled'] = 'Søkeområde er deaktivert';
$string['searchareaenabled'] = 'Søkeområde er aktivert';
$string['searchareas'] = 'Søkeområder';
$string['searchdeleteindex'] = 'Slett alt indeksert innhold';
$string['searchengine'] = 'Søkemotor';
$string['searchindexactions'] = 'Indekseringshandlinger';
$string['searchindexdeleted'] = 'Indeks slettet';
$string['searchindextime'] = 'Tidsgrense for indeksering';
$string['searchindextime_desc'] = 'Ved indeksering av store mengder nytt innhold vil cronjobben for indeksering stopper etter at tidsgrensen er nådd og deretter fortsette neste gang cronjobben kjøres';
$string['searchindexupdated'] = 'Søkemotorinnhold har blitt oppdatert';
$string['searchindexwhendisabled'] = 'Indekser når deaktivert';
$string['searchindexwhendisabled_desc'] = 'Tillater at cronjobben indekserer selv om søkefunksjonen er deaktivert. Dette kan være nyttig om du ønsker å bygge opp søkebiblioteket før brukerne får tilgang til søkefunksjonen';
$string['searchinsettings'] = 'Søk i innstillingene';
$string['searchlastrun'] = 'Siste kjørt (tidspunkt, # dokumenter, # oppføringer, # ignoreringer)';
$string['searchnotavailable'] = 'Søk er ikke tilgjengelig';
$string['searchoptions'] = 'Søkevalg';
$string['searchpartial'] = '(ennå ikke ferdigsindeksert)';
$string['searchreindexed'] = 'Alt innhold på portalen har blirr reindeksert';
$string['searchreindexindex'] = 'Reindekser alt innhold på portalen';
$string['searchresults'] = 'Søkeresultater';
$string['searchsetupinfo'] = 'Søkeinnstillinger';
$string['searchupdateindex'] = 'Oppdater indeksert innhold';
$string['sectionerror'] = 'Seksjonsfeil!';
$string['secureforms'] = 'Bruk sikkert skjema';
$string['security'] = 'Sikkerhet';
$string['selectdevice'] = 'Velg enhet';
$string['selectsearchengine'] = 'Velg søkemotor';
$string['selecttheme'] = 'Velg design for {$a} enhet';
$string['server'] = 'Server';
$string['serverchecks'] = 'Serveren sjekker';
$string['serverlimit'] = 'Serverbegrensning';
$string['sessionautostartwarning'] = '<p>Alvorlig konfigurasjonsfeil oppdaget, vennligst varsle administrator.</p><p>For å fungere normalt krever Moodle at administrator endrer PHP-innstillingene.</p><p><code>session.auto_start</code> må endres til <code>off</code>.</p><p>Denne innstillingen endres i <code>php.ini</code>, Apache/IIS <br />oppsettet eller <code>.htaccess</code> fila på serveren.</p>';
$string['sessioncookie'] = 'Cookie prefix';
$string['sessioncookiedomain'] = 'Cookiedomene';
$string['sessioncookiepath'] = 'Cookie sti';
$string['sessionhandling'] = 'Sesjonshåndtering';
$string['sessiontimeout'] = 'Tiden utløper';
$string['settingfileuploads'] = 'Filopplasting kreves for normal bruk, vennligst aktiver dette i PHP-oppsettet.';
$string['settingmemorylimit'] = 'Minnegrensen er satt for lavt, vennligst angi en høyere minnegrense i PHP-innstillingene.';
$string['settingsafemode'] = 'Moodle er ikke fullt kompatibel med "safe mode", vennligst be administrator om å slå dette av. Kjøring av Moodle i "safe mode" støttes ikke og du må regne med en rekke problemer hvis du prøver.';
$string['setupsearchengine'] = 'Innstillinger for søkemotor';
$string['showcommentscount'] = 'Vis kommentarantall';
$string['showdetails'] = 'Vis detaljer';
$string['showuseridentity'] = 'Vis brukeridentitet';
$string['showuseridentity_desc'] = 'Når du velger eller søker etter brukere, og når du viser lister over brukere, vil disse feltene vises i tillegg til deres fulle navn. Feltene blir kun vist til brukere som har retten moodle/site:viewuseridentity capability; som standard er dette lærere og superbrukere. (Dette valget gir mest mening dersom du velger ett eller to felter som er obligatorisk for din organisasjon)';
$string['simplexmlrequired'] = 'Moodle krever nå PHP-tillegget "SimpleXML".';
$string['sitemailcharset'] = 'Karaktersett';
$string['sitemaintenance'] = 'Nettstedet er midlertidig nede p.g.a. vedlikehold';
$string['sitemaintenancemode'] = 'Vedlikeholdsmodus';
$string['sitemaintenanceoff'] = 'Vedlikeholdsmodus er slått av, og nettstedet fungerer normalt igjen';
$string['sitemaintenanceon'] = 'Nettstedet er i vedlikeholdsmodus(bare administratorer kan logge inn eller bruke nettstedet)';
$string['sitemaintenanceoncli'] = 'Nettstedet er i CLI-vedlikeholdsmodus. Ingen nettilgang er tillatt.';
$string['sitemaintenancewarning'] = 'Dette nettstedet er i vedlikeholdsmodus for øyeblikket (kun administratorer kan logge inn). For å kunne returnere til normal operasjon, må du <a href="maintenance.php">slå av vedlikeholdsmodus</a>.';
$string['sitemaintenancewarning2'] = 'Portalen din er i vedlikeholdsmodus og bare administratorer kan logge inn. For å skifte tilbake til vanlig drift, gå til <a href="{$a}">slå av vedlikeholdsmodus</a>.';
$string['sitemenubar'] = 'Navigasjon';
$string['sitepolicies'] = 'Portalens sikkerhetsinnstillinger';
$string['sitepolicy'] = 'Site regler URL';
$string['sitepolicyguest'] = 'URL for oversikt over regler for gjester';
$string['sitepolicyguest_help'] = 'URL-en til retningslinjer som alle gjester må se og akseptere før de får tilgang til portalen. Merk at denne innstillingen bare har effekt hvis velgeren for portal-retningslinjer er satt til standard (core).';
$string['sitepolicyhandler'] = 'Handler for nettstedregler';
$string['sitepolicyhandlercore'] = 'Standard (core)';
$string['sitepolicyhandler_desc'] = 'Dette valget bestemmer hvordan retningslinjer og brukeraksept håndteres. Standard (core)-valget aktiverer et dokument med retningslinjer for standard brukere, og et annet for gjester. Valget for håndtering av utvidede retningslinjer som';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitepolicy_help'] = 'Nettadressen til portalretningslinjene som alle registrerte brukere må se og godkjenne før de får tilgang til nettstedet. Vær oppmerksom på at denne innstillingen bare har effekt hvis håndtereren for portalretningslinjer er satt til standard (core).';
$string['sitesectionhelp'] = 'Dersom valgt, vil en emneseksjon vises på forsiden til portalen.';
$string['sixtyfourbitswarning'] = 'Portalen din benytter seg ikke av en 64 bits PHP-versjon. Det anbefales at du oppgraderer for å sikre fremtidig kompatibilitet.';
$string['slasharguments'] = 'Bruk slash argumenter';
$string['slashargumentswarning'] = 'Det anbefales at bruk av slash argumenter er aktivert. I fremtiden vil det være nødvendig. For flere detaljer, se dokumentasjonen <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Bruke slash argumenter</a> .';
$string['smartpix'] = 'Smart PIX søk';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP Auth Type';
$string['smtpdetail'] = 'Simple Mail Transfer Protocol (SMTP) innstillinger for sending av epost.';
$string['smtphosts'] = 'SMTP-server';
$string['smtpmaxbulk'] = 'SMTP sesjongrense';
$string['smtppass'] = 'SMTP passord';
$string['smtpsecure'] = 'SMTP-sikkerhet';
$string['smtpuser'] = 'SMTP  brukernavn';
$string['soaprecommended'] = 'SOAP-tillegget anbefales installert siden dette er nyttig for webtjenester og noen tilleggsmoduler.';
$string['sort_fullname'] = 'Fullt navn på kurset';
$string['sort_idnumber'] = 'Kursets ID-nummer';
$string['sort_shortname'] = 'Kursets kortnavn';
$string['sort_sortorder'] = 'Sorteringsrekkefølge';
$string['spellengine'] = 'Stavemotor';
$string['spelllanguagelist'] = 'Stavekontroll språkliste';
$string['splrequired'] = 'PHP-tillegget "SPL" kreves nå av Moodle.';
$string['stats'] = 'Statistikk';
$string['statsfirstrun'] = 'Hvor langt tilbake skal statistikk-kjøringen starte?';
$string['statsmaxruntime'] = 'Maks tid for daglig statistikkbearbeiding';
$string['statsmoodleorg'] = 'statistikk';
$string['statsruntimedays'] = 'Dager som skal prosesseres';
$string['statsruntimestart'] = 'Kjør statistikk kl:';
$string['statsuserthreshold'] = 'Utelat kurs med færre brukere enn';
$string['stickyblocks'] = 'Tvungne blokker';
$string['stickyblockscourseview'] = 'Kursside';
$string['stickyblocksduplicatenotice'] = 'Hvis blokken du legger til her allerede finnes på en bestemt side, vil den dupliseres. <br/>Bare blokken du legger til vil være fast, duplikaten kan fremdeles endres på.';
$string['stickyblocksmymoodle'] = 'Min Moodle';
$string['stickyblockspagetype'] = 'Sidetype som skal konfigureres';
$string['strictformsrequired'] = 'Streng validering av obligatoriske felt';
$string['stripalltitletags'] = 'Fjern HTML-tagger fra alle aktivitetsnavn';
$string['supportcontact'] = 'Brukerstøtte';
$string['supportemail'] = 'Support epost';
$string['supportname'] = 'Support kontaktnavn';
$string['supportpage'] = 'Supportside';
$string['suspenduser'] = 'Deaktiver brukerkonto';
$string['switchlang'] = 'Bytt språkmappe';
$string['systempaths'] = 'Systemstier';
$string['tablenosave'] = 'Endringer i tabellen over lagres automatisk.';
$string['tablesnosave'] = 'Endringer i tabellen over lagres automatisk.';
$string['tabselectedtofront'] = 'I tabeller med tabber, skal raden med gjeldende tab plasseres først';
$string['tabselectedtofronttext'] = 'Bring valgte tab-rekke til forgrunnen';
$string['taskanalyticscleanup'] = 'Analytics opprydding';
$string['taskautomatedbackup'] = 'Automatiske sikkerhetskopier';
$string['taskbackupcleanup'] = 'Slett sikkerhetskopitabeller og logger';
$string['taskbadgescron'] = 'Tildel utmerkelser';
$string['taskblogcron'] = 'Synkroniser eksterne blogger';
$string['taskcachecleanup'] = 'Slett utløpte mellomlagrede data';
$string['taskcachecron'] = 'Bakgrunnsprosessering for mellomlagrede data';
$string['taskcalendarcron'] = 'Send kalendervarsler';
$string['taskcheckforupdates'] = 'Se etter oppdateringer';
$string['taskcompletiondaily'] = 'Registrere at kurset er påbegynt';
$string['taskcompletionregular'] = 'Beregn vanlig fullførtdata';
$string['taskcontextcleanup'] = 'Rydd i kontekster';
$string['taskcreatecontexts'] = 'Opprett manglende kontekster';
$string['taskdeletecachetext'] = 'Slett gamle tekstbaserte mellomlagrede data';
$string['taskdeleteincompleteusers'] = 'Slett ufullstendige brukerkontoer';
$string['taskdeleteunconfirmedusers'] = 'Slett ubekreftede brukerkontoer';
$string['taskeventscron'] = 'Bakgrunnsprosessering for handlinger';
$string['taskfiletrashcleanup'] = 'Rydd opp i søppelbøtta';
$string['taskglobalsearchindex'] = 'Globalt søk-indeksering';
$string['taskglobalsearchoptimize'] = 'Globalt søk indeksoptimalisering';
$string['taskgradecron'] = 'Bakgrunnsprosessering av karakterbok';
$string['tasklegacycron'] = 'Arvede cron-prosesser for moduler';
$string['taskmessagingcleanup'] = 'Bakgrunnsprosesser for meldinger';
$string['taskpasswordresetcleanup'] = 'Rydd i forsøk på å resette passord';
$string['taskplagiarismcron'] = 'Bakgrunnsprosessering (bakoverkompatibel) av plagiatmoduler';
$string['taskportfoliocron'] = 'Bakgrunnsprosessering av porteføljemoduler';
$string['taskquestioncron'] = 'Bakgrunnsprosessering av spørsmålsmotoren';
$string['taskrefreshsystemtokens'] = 'Forny OAuth-token for tjenestekontoer';
$string['taskregistrationcron'] = 'Registrering av kursportalen';
$string['tasksendfailedloginnotifications'] = 'Send oversikt over mislykkede innlogginger';
$string['tasksendnewuserpasswords'] = 'Send nye brukerpassord';
$string['tasksessioncleanup'] = 'Slett gamle sesjoner';
$string['taskstatscron'] = 'Bakgrunnsprosesser for statistikker';
$string['tasktagcron'] = 'Bakgrunnsprosesser for tagger';
$string['tasktempfilecleanup'] = 'Slett foreldede temp filer';
$string['tempdatafoldercleanup'] = 'Rydd opp i midlertidige filer som er eldre enn';
$string['testsiteupgradewarning'] = 'Du bruker nå {$} testportal, for å oppgradere denne korrekt bør du bruke kommandolinjeverktøyet.';
$string['themedesignermode'] = 'Modus for å arbeide med design';
$string['themedesignermodewarning'] = 'Designermodus er aktivert. Dette bør ikke være aktivert på produksjonsportalen siden det medfører en signifikant reduksjon i ytelsen.';
$string['themelist'] = 'Designoversikt';
$string['themenoselected'] = 'Ingen design valgt';
$string['themeresetcaches'] = 'Slett mellomlagre av design';
$string['themeselect'] = 'Endre design';
$string['themeselector'] = 'Designgalleri';
$string['themesettings'] = 'Design-innstillinger';
$string['therewereerrors'] = 'Det var feil i dine data';
$string['thirdpartylibrary'] = 'Bibliotek';
$string['thirdpartylibrarylocation'] = 'Sted';
$string['thirdpartylibs'] = 'Tredjeparts biblioteker';
$string['timezone'] = 'Standard tidssone';
$string['timezoneforced'] = 'Dette er påtvunget av nettstedets administrator';
$string['timezoneinvalid'] = 'Ugyldig tidssone "{$a}"';
$string['timezoneisforcedto'] = 'Tving alle brukere til å benytte';
$string['timezonenotforced'] = 'Brukere kan velge sin egen tidssone';
$string['timezonephpdefault'] = 'Standard PHP tidssone ({$a})';
$string['timezoneserver'] = 'Serverens tidssone ({$a})';
$string['tlswarning'] = 'Fant ingen PHP/cURL-tillegg med støtte for TLS v1.2. Noen tjenester vil da muligens ikke fungere. Vi anbefaler sterkt at du oppdaterer TLS-bibliotekene.';
$string['tokenduration'] = 'Varighet for brukertoken.';
$string['tokenduration_desc'] = 'Hvor lenge en webservicetoken opprettet av en bruker (f.eks. via mobilappen) skal være gyldig.';
$string['tokenizerrecommended'] = 'Vi anbefaler sterkt at PHP Tokenizer biblioteket installeres - det forbedrer Moodle Networking funksjonaliteten.';
$string['tools'] = 'Administratorverktøy';
$string['toolsmanage'] = 'Administrer administrasjonsverktøy';
$string['unattendedoperation'] = 'Automatisk installasjon';
$string['unbookmarkthispage'] = 'Fjern bokmerket for denne siden';
$string['unicoderequired'] = 'Det er påkrevd at du lagrer alle data i Unicode format(UTF-8).Nye installasjoner må gjøres til Unicode-databaser. Dersom du oppgraderer må etterpå du kjøre UTF-8 migrasjonsrutinen i admin-menyen.';
$string['uninstallplugin'] = 'Fjern';
$string['unlockaccount'] = 'Lås opp brukerkonto';
$string['unoconvwarning'] = 'Den installerte versjonen av unoconv støttes ikke';
$string['unsettheme'] = 'Angre designvalg';
$string['unsupported'] = 'Ikke støttet';
$string['unsupporteddbfileformat'] = 'Databasen din bruker Antilope som filformat i enkelte tabeller. Full UTF8-støtte i MySQL og MariaDB krever at du benytter Barracuda-filformatet. Vennligst konverter tabellene til Barracuda filformatet. Se dokumentasjon for dette her: <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL full unicode support</a> for mer informasjon.';
$string['unsupporteddbfilepertable'] = 'For full støtte av UTF-8 fra både MySQL og MariaDB må du endre MySQL-innstillingen \'innodb_file_per_table\' til \'ON\'. Les dokumentasjonen for flere detaljer.';
$string['unsupporteddblargeprefix'] = 'For full støtte av UTF-8 fra både MySQL og MariaDB må du endre MySQL-innstillingen \'innodb_file_per_table\' til \'ON\'. Les dokumentasjonen for flere detaljer.';
$string['unsupporteddbstorageengine'] = 'Databaselagringsmotoren som brukes er ikke lenger støttet.';
$string['unsupporteddbtablerowformat'] = 'Databasen har tabeller ved hjelp Antelope som filformat . Du anbefales å konvertere tabellene til Barracuda filformat. Se dokumentasjonen <a href="https://docs.moodle.org/en/cli"> Administrasjon via kommandolinjen </a> for detaljer om et verktøy for å konvertere InnoDB tabeller til Barracuda .';
$string['unsupportedphpversion7'] = 'PHP versjon 7 støttes ikke.';
$string['unsupportedphpversion71'] = 'PHP verjon 7.1 støttes ikke';
$string['unsupportedphpversion72'] = 'PHP 7.2 støttes ikke';
$string['unsupportedphpversion73'] = 'PHP versjon 7.3 støttes ikke.';
$string['unsupportedphpversion74'] = 'PHP versjon 7.4 støttes ikke.';
$string['unsuspenduser'] = 'Aktiver brukerkonto';
$string['updateaccounts'] = 'Oppdater eksisterende konti';
$string['updateautocheck'] = 'Sjekk automatisk for tilgjengelige oppdateringer';
$string['updateautocheck_desc'] = 'Dersom aktivert, vil kursportalen automatisk sjekke om det finnes tilgjengelige oppdateringer for både Moodlekode og alle tilleggsmoduler. Hvis det finnes oppgraderinger, vil det sendes en varslingsepost til portaladministrator.';
$string['updateavailable'] = 'En nyere versjon av Moodle er tilgjengelig!';
$string['updateavailabledetailslink'] = 'Se {$a->url} for mer informasjon';
$string['updateavailableforplugin'] = 'En nyere versjon av noen av dine tilleggsmoduler er tilgjengelig!';
$string['updateavailableinstall'] = 'Installer denne oppdateringen';
$string['updateavailableinstallall'] = 'Installer tilgjengelige oppdateringer ({$a})';
$string['updateavailableinstallallhead'] = 'Installerer tilgjengelige oppdateringer';
$string['updateavailable_moreinfo'] = 'Mer informasjon...';
$string['updateavailablenot'] = 'Moodleinstallasjonen din er oppdatert!';
$string['updateavailablerecommendation'] = 'Det anbefales på det sterkeste at du oppdaterer portalen til siste versjon for å få tilgang til alle nylige sikkerhetsoppdateringer og opprettede feil.';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versjon {$a}';
$string['updatecomponent'] = 'Oppdater komponent';
$string['updateminmaturity'] = 'Nødvendig kodemodenhet';
$string['updateminmaturity_desc'] = 'Melding om tilgjengelig oppdatering gis bare når koden er moden nok. Oppdateringer for tilleggsmoduler som ikke oppgir kodemodenhet blir alltid meldt uavhengig av denne innstillingen.';
$string['updatenotificationfooter'] = 'Din Moodleportal {$a->siteurl} er konfigurert til å automatisk sjekke for oppdateringer. Du mottar denne meldingen som administrator for kursportalen. Du kan deaktivere automatisk oppgraderingssjekk ved å gå til Portalen / Server / Oppdateringsvarlser. Om du ønsker å motta denne meldingen på en annen måte kan du gjøre det under dine meldingspreferanser.';
$string['updatenotifications'] = 'Melding om oppdateringer';
$string['updatenotificationsubject'] = 'Det finnes en tilgjengelig oppdatering for din Moodleportal ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Gi melding om nye distribusjoner';
$string['updatenotifybuilds_desc'] = 'Dersom aktivert, blir tilgjengelige oppdateringer av Moodlekoden også varslet om når en ny distribusjon til den gjeldende Moodle-versjonen er gjort tilgjengelig. Distribusjoner er pågående forbedringer i en bestemt Moodleversjon. De blir vanligvis sluppet en gang i uken. Hvis deaktivert, vil tilgjengelige oppdateringer bare bli meldt om det kommer en høyere versjon av Moodle. Modulsjekken påvirkes ikke av denne innstillingen.';
$string['upgradeerror'] = 'Ukjent feil ved oppgradering av  {$a->plugin} til versjon {$a->version}, kan ikke fortsette.';
$string['upgradeforumread'] = 'En ny egenskap har blitt lagt til i Moodle 1.5 for å spore leste/uleste foruminnlegg.<br />For å bruke denne funksjonaliteten må du <a href="{$a}">oppdatere tabellene dine</a>.';
$string['upgradeforumreadinfo'] = 'En ny funksjon for sporing av leste/uleste foruminnlegg ble lagt til i Moodle 1.5. For å ta i bruk denne funksjonen må du oppdatere tabellene med all sporingsinfo fra eksisterende innlegg. Avhengig av størrelsen på din portal kan dette ta lang tid (timer) og belaste databasen kraftig, så det er best du gjør dette i en stille periode. Likevel; Portalen vil fungere som normalt og brukerne blir ikke berørt. Når du starter prosessen må du la den gå ferdig.(Ikke lukk nettleservinduet). Dersom du likevel skulle lukke nettleseren din, ikke bekymre deg - du kan starte på nytt. <br /><br />Ønsker du å starte oppgraderingen nå?';
$string['upgradekeyreq'] = 'Oppgraderingsnøkkel påkrevd';
$string['upgradekeyset'] = 'Oppgraderingsnøkkel (la være tom for å kreve noen)';
$string['upgradelogs'] = 'For full funksjonalitet må de gamle loggene oppgraderes. <a href="{$a}">Mer informasjon</a>';
$string['upgradelogsinfo'] = 'Det er nylige endringer i måten loggene lagres. For å kunne se alle gamle logger sortert etter aktivitet må de gamle loggene oppgraderes. Dette kan ta lang tid avhengig av din side (flere timer) og det kan kreve store ressurser fra databasen for større nettsteder. Når du har startet denne prosessen bør du la den fullføre (med å ha nettleservinduet åpent). Og - siden vil fungere fint for andre brukere mens loggene oppgraderes.<br /><br />Vil du oppgradere loggene nå?';
$string['upgradepluginsfirst'] = 'Du må laste ned og installere tilgjengelige oppdateringer først.';
$string['upgradepluginsinfo'] = 'Oppdaterer moduler';
$string['upgradepluginsinfo_help'] = 'Det finnes tilgjengelige oppdateringer for noen av dine tilleggsmoduler. Du bør installere dem før du oppgraderer Moodle-databasen. Hvis portalen din ikke støtter automatiske oppdateringer må du laste ned og installere de nye modulversjonene manuelt.';
$string['upgradesettings'] = 'Nye innstillinger';
$string['upgradesettingsintro'] = 'Innstillingene under ble lagt til i løpet av din siste Moodle-oppgradering. Utfør de endringene du trenger og klikk \'Lagre endringer\' nederst på denne siden.';
$string['upgradestalefiles'] = 'Sammenblandede Moodleversjoner oppdaget. Oppgraderingen kan ikke fortsette.';
$string['upgradestalefilesinfo'] = 'Moodle-oppdateringen har blitt stanset fordi PHP-skript fra minst to hovedversjoner av Moodleer oppdaget i Moodle-katalogen.

Dette kan føre til betydelige problemer senere, så for å fortsette må du sørge for at Moodle-katalogen inneholder kun filer for en enkelt versjon av Moodle.

Den anbefalte måten å rydde i Moodle-katalogen på er som følger:

* Endre gjeldende Moodle-katalog til "moodle_old"
* Lage en ny Moodle-katalog som kun inneholder filer fra enten en standard Moodle-pakke eller GIT.

* Flytt den opprinnelige config.php filen og eventuelle ikke-standardiserte moduler fra "moodle_old"-katalogen til den nye Moodle-katalogen

Når du har en ren Moodle-katalog, gjenopptar du oppdateringsprosessen i Moodle.

Denne advarselen er ofte forårsaket av en har unzippet en standard Moodle-pakke over en tidligere versjon av Moodle. Selv om dette er OK for mindre oppgraderinger, er det sterkt å fraråde for større Moodle-oppgraderinger.

Denne advarselen kan også være forårsaket av en ufullstendig oppdatering via  GIT, og da må du bare vente på at operasjon går ferdig, eller kanskje kjøre den aktuelle prosessen på nytt.

Du kan finne mer informasjon i oppgraderingsinformasjonen på <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Oppgrader Moodledatabasen nå';
$string['upgradesure'] = '<p>Dine Moodle-filer har blitt endret, og du er i ferd med automatisk å oppgradere installasjonen til denne versjonen: <br /> <br />
<strong>{$a}</strong> </p>
<p>Når du starter på dette kan du ikke gå tilbake igjen. Vennligst vær klar over at oppgraderingsprosessen kan ta lang tid.</p>
<p>
Er du sikker på at du ønsker å oppgradere denne tjeneren til denne versjonen?</p>';
$string['upgradetimedout'] = 'Oppgraderingen tok for lang tid, vennligst prøv på nytt.';
$string['upgradingdata'] = 'Oppgraderer data';
$string['upgradinglogs'] = 'Oppgraderer logger';
$string['upgradingversion'] = 'Oppgraderer til ny versjon';
$string['upwards'] = 'oppover';
$string['useblogassociations'] = 'Aktiver asossieringer';
$string['useexternalyui'] = 'Bruk nettbaserte YUI-biblioteker';
$string['user'] = 'Bruker';
$string['userbulk'] = 'Massehandlinger med brukere';
$string['userbulkdownload'] = 'Eksportér brukere som';
$string['userdefaultpreferences'] = 'Standard brukerpreferanser';
$string['userimagesdisabled'] = 'Brukerprofilbilder er deaktivert';
$string['userlist'] = 'Vis brukeroversikt';
$string['userpolicies'] = 'Brukerprofiler';
$string['userpreference'] = 'Brukerinnstillinger';
$string['userquota'] = 'Brukerkvoter';
$string['users'] = 'Brukere';
$string['usesitenameforsitepages'] = 'Bruk portalnavn på portalsider';
$string['usetags'] = 'Slå på tagfunksjonalitet';
$string['validateemptylineerror'] = 'Tomme linjer er ugyldige';
$string['validateerror'] = 'Denne verdien er ikke gyldig';
$string['validateerrorlist'] = 'Disse oppføringene er ugyldige: {$a}';
$string['validateiperror'] = 'Disse IP-dressene er ugyldige: {$a}';
$string['verifychangedemail'] = 'Begrens tillatte domener ved endring av e-postadresse';
$string['warningcurrentsetting'] = 'Feil nåværende verdi: {$a}';
$string['warningiconvbuggy'] = 'Din versjon av iconv-tillegget støtter ikke //IGNORE modifier. Du må derfor installere mbstring-tillegget, (siden det kan brukes i stedet) for å  rense strenger som inneholder ugyldige UTF-8 tegn.';
$string['webproxy'] = 'Webproxy';
$string['webproxyinfo'] = 'Fyll inn følgende valg hvis ikke Moodle-serveren din har tilgang til Internet direkte. Internett-tilgang er nødvendig for å laste ned informasjon, språkpakker, RSS-agenter, tidssoner osv.<br/><em>PHP cURL ekstensjon er svært anbefalt.</em>';
$string['xmlrpcrecommended'] = 'XMLRPC-tilleegget er nyttig for webservicer og Moodlenettverk.';
$string['yuicomboloading'] = 'kombinert lasting av YUI';
$string['ziprequired'] = 'ZIP PHP-tillegget kreves nå av Moodle. Info-ZIP eller PclZIP biblioteket er ikke lenger i bruk.';
