<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'de', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Fehler beim Laden der Blogbeiträge';
$string['addon.blog.showonlyyourentries'] = 'Nur Ihre Beiträge anzeigen';
$string['addon.calendar.calendarevent'] = 'Kalendereintrag';
$string['addon.calendar.calendarevents'] = 'Kalender';
$string['addon.calendar.calendarreminders'] = 'Kalendererinnerungen';
$string['addon.calendar.currentmonth'] = 'Aktueller Monat';
$string['addon.calendar.defaultnotificationtime'] = 'Benachrichtigungszeit';
$string['addon.calendar.errorloadevent'] = 'Fehler beim Laden des Kalendereintrags';
$string['addon.calendar.errorloadevents'] = 'Fehler beim Laden der Kalendereinträge';
$string['addon.calendar.noevents'] = 'Keine Kalendereinträge';
$string['addon.calendar.reminders'] = 'Erinnerungen';
$string['addon.calendar.setnewreminder'] = 'Neue Erinnerung erstellen';
$string['addon.competency.errornocompetenciesfound'] = 'Keine Kompetenzen gefunden';
$string['addon.competency.nocompetencies'] = 'Keine Kompetenzen';
$string['addon.coursecompletion.complete'] = 'Abschließen';
$string['addon.coursecompletion.couldnotloadreport'] = 'Fehler beim Laden des Abschlussberichts. Versuchen Sie es später noch einmal.';
$string['addon.files.couldnotloadfiles'] = 'Die Dateiliste konnte nicht geladen werden.';
$string['addon.files.emptyfilelist'] = 'Keine Dateien';
$string['addon.files.erroruploadnotworking'] = 'Im Moment können keine Dateien zur Website hochgeladen werden.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Geräte konfigurieren';
$string['addon.messages.contactlistempty'] = 'Die Kontaktliste ist leer.';
$string['addon.messages.contactname'] = 'Name';
$string['addon.messages.deletemessage'] = 'Mitteilung löschen';
$string['addon.messages.deletemessageconfirmation'] = 'Möchten Sie diese Mitteilung wirklich löschen? Die Mitteilung wird nur in Ihrem Verlauf gelöscht, aber nicht bei der Person, die die Mitteilung gesendet oder empfangen hat.';
$string['addon.messages.errordeletemessage'] = 'Fehler beim Löschen der Mitteilung';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Fehler beim Abrufen der Kontakte vom Server';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Fehler beim Abrufen der Themen vom Server';
$string['addon.messages.errorwhileretrievingmessages'] = 'Fehler beim Abrufen der Mitteilungen vom Server';
$string['addon.messages.errorwhileretrievingusers'] = 'Fehler beim Abrufen der Personen vom Server';
$string['addon.messages.messagenotsent'] = 'Die Mitteilung wurde nicht gesendet. Versuchen Sie es später noch einmal.';
$string['addon.messages.newmessages'] = 'Neue Mitteilungen';
$string['addon.messages.nousersfound'] = 'Keine Personen gefunden';
$string['addon.messages.showdeletemessages'] = 'Mitteilungen löschen anzeigen';
$string['addon.messages.type_blocked'] = 'Gesperrt';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Suchergebnisse';
$string['addon.messages.type_strangers'] = 'Weitere Personen';
$string['addon.messages.useentertosenddescdesktop'] = 'Falls deaktiviert, können Sie mit Ctrl+Enter die Mitteilung senden.';
$string['addon.messages.useentertosenddescmac'] = 'Falls deaktiviert, können Sie mit Cmd+Enter die Mitteilung senden.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Mitteilung zum Thema {{conversation}} konnte nicht gesendet werden. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Mitteilung an {{user}} konnte nicht gesendet werden. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Bestätigen Sie die Erklärung zur Eigenständigkeit.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Sie können in der App keine Abgabe hinzufügen oder bearbeiten, weil keine Erklärung zur Eigenständigkeit von der Website abgerufen werden konnte.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Manche Bewertungsmethoden werden von der App bisher nicht unterstützt und können nicht verändert werden.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Sie können in der App keine Abgabe machen, weil von der Website keine Erklärung zur Eigenständigkeit abgerufen werden konnte.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Sie können in der App keine Abgabe hinzufügen oder bearbeiten, weil manche Plugins bisher keine Bearbeitung erlauben:';
$string['addon.mod_assign.errorshowinginformation'] = 'Die Abgabeinformationen können nicht angezeigt werden.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Dieses Feedback wird von der App nicht unterstützt, so dass Informationen fehlen könnten.';
$string['addon.mod_assign.gradenotsynced'] = 'Bewertung nicht synchronisiert';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Teilnehmer/innen, die nichts abgegeben haben, werden nicht angezeigt.';
$string['addon.mod_assign.submissionnotsupported'] = 'Diese Abgabe wird von der App nicht unterstützt und es könnten Infos fehlen.';
$string['addon.mod_assign.userwithid'] = 'Nutzer/in mit ID {{id}}';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Die Abgabebewertung wurde auf der Website geändert.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Die Abgabe wurde auf der Website geändert.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Fehler beim Verbinden zum Chat';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Fehler beim Abrufen des Chats';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Fehler beim Anzeigen der Personen im Chat';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Fehler beim Abrufen der Mitteilungen vom Server';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Fehler beim Senden der Mitteilung';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Sie müssen online sein, um Mitteilungen senden zu können.';
$string['addon.mod_chat.nosessionsfound'] = 'Keine Sessions';
$string['addon.mod_chat.showincompletesessions'] = 'Unvollständige Sessions anzeigen';
$string['addon.mod_choice.errorgetchoice'] = 'Fehler beim Laden der Abstimmung';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% haben die Option gewählt: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Ihre letzte Antwort ist in den Ergebnissen noch nicht enthalten. Synchronisieren Sie die Daten.';
$string['addon.mod_data.edittagsnotsupported'] = 'Das Bearbeitung von Tags wird in der App nicht unterstützt.';
$string['addon.mod_data.errorapproving'] = 'Fehler beim Freigeben bzw. Ablehnen des Eintrags';
$string['addon.mod_data.errordeleting'] = 'Fehler beim Löschen des Eintrags';
$string['addon.mod_data.gettinglocation'] = 'Standort bestimmen ...';
$string['addon.mod_data.locationpermissiondenied'] = 'Die Berechtigung zum Zugriff auf Ihren Standort wurde verweigert.';
$string['addon.mod_data.mylocation'] = 'Mein Standort';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Die Suche nach Tags wird in der App nicht unterstützt.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Ein Feedback mit Captcha kann offline nicht beendet werden. Captcha funktioniert nur, wenn der Server antworten kann.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Das Feedback wurde gespeichert, um es später zu übertragen.';
$string['addon.mod_folder.emptyfilelist'] = 'Keine Dateien';
$string['addon.mod_forum.errorgetforum'] = 'Fehler beim Laden der Forumsdaten';
$string['addon.mod_forum.errorgetgroups'] = 'Fehler beim Laden der Gruppeneinstellungen';
$string['addon.mod_forum.errorposttoallgroups'] = 'Das neue Thema konnte nicht in allen Gruppen angelegt werden.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Keine Themen im Forum';
$string['addon.mod_forum.group'] = 'Gruppe';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} Themen';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} Antworten';
$string['addon.mod_forum.refreshdiscussions'] = 'Themen aktualisieren';
$string['addon.mod_forum.refreshposts'] = 'Forenbeiträge aktualisieren';
$string['addon.mod_glossary.browsemode'] = 'Einträge durchblättern';
$string['addon.mod_glossary.byalphabet'] = 'Alphabetisch';
$string['addon.mod_glossary.byauthor'] = 'Nach Autor/in';
$string['addon.mod_glossary.bycategory'] = 'Nach Kategorie';
$string['addon.mod_glossary.bynewestfirst'] = 'Neu zuerst';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Kürzlich aktualisiert';
$string['addon.mod_glossary.bysearch'] = 'Suchen';
$string['addon.mod_glossary.cannoteditentry'] = 'Eintrag nicht bearbeitbar';
$string['addon.mod_glossary.entriestobesynced'] = 'Einträge zum Synchronisieren';
$string['addon.mod_glossary.entrypendingapproval'] = 'Dieser Eintrag wartet auf eine Freigabe.';
$string['addon.mod_glossary.errorloadingentries'] = 'Fehler beim Laden der Einträge';
$string['addon.mod_glossary.errorloadingentry'] = 'Fehler beim Laden des Eintrags';
$string['addon.mod_glossary.errorloadingglossary'] = 'Fehler beim Laden des Glossars';
$string['addon.mod_glossary.noentriesfound'] = 'Keine Einträge';
$string['addon.mod_glossary.searchquery'] = 'Suchanfrage';
$string['addon.mod_imscp.showmoduledescription'] = 'Beschreibung anzeigen';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Diese Lektion enthält einen Sprung zu einer zufälligen Seite. Die Lektion kann in der App nicht versucht werden, ohne im Webbrowser begonnen worden zu sein.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Dieser Versuch kann nicht mehr angesehen werden, weil ein weiterer Versuch beendet wurde.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Dieser Versuch wurde offline beendet.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Ein Offline-Versuch wurde synchronisiert. Möchten Sie ihn erneut prüfen?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Der Versuch wurde auf der Website beendet.';
$string['addon.mod_lti.errorgetlti'] = 'Fehler beim Laden der Moduldaten';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Die Launch-URL ist ungültig.';
$string['addon.mod_lti.launchactivity'] = 'Aktivität starten';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Fehler beim Laden des Seiteninhalts';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Sie können einen Testversuch in der App beginnen, aber Sie müssen ihn aus folgenden Gründen im Webbrowser abgeben:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Der Test kann aus folgenden Gründen nicht abgegeben werden:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Dieser Versuch wurde seit {{$a}} nicht synchronisiert. Falls Sie inzwischen mit einem anderen Gerät weiter gearbeitet haben, könnten Daten verloren gehen.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Fehler beim Speichern der Antworten. Möchten Sie den Test wirklich verlassen?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Der Test kann nicht in der App durchgeführt werden, weil das Frageverhalten nicht unterstützt wird:';
$string['addon.mod_quiz.errordownloading'] = 'Fehler beim Laden notwendiger Daten';
$string['addon.mod_quiz.errorgetattempt'] = 'Fehler beim Laden der Versuche';
$string['addon.mod_quiz.errorgetquestions'] = 'Fehler beim Laden der Fragen';
$string['addon.mod_quiz.errorgetquiz'] = 'Fehler beim Laden der Testdaten';
$string['addon.mod_quiz.errorparsequestions'] = 'Fehler beim Darstellen der Fragen. Versuchen Sie, diesen Test in einem Browser zu öffnen.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Dieser Test wird in der App nicht ausgeführt, weil er von der App nicht unterstützte Fragen enthält:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Dieser Test wird in der App nicht ausgeführt, weil er von der App nicht unterstützte Zugriffsregeln enthält:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Fehler beim Speichern des Versuchs';
$string['addon.mod_quiz.finishnotsynced'] = 'Beendet, aber nicht synchronisiert';
$string['addon.mod_quiz.opentoc'] = 'Navigationsfeld öffnen';
$string['addon.mod_quiz.warningattemptfinished'] = 'Der Offline-Versuch wurde verworfen, weil er auf der Website beendet wurde oder nicht mehr existiert.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Einige Offline-Antworten könnten verworfen worden sein, weil die Fragen online verändert wurden.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Der Versuch wurde nicht beendet, weil Offline-Antworten verworfen wurden. Überprüfen Sie Ihre Antworten und übermitteln Sie den Versuch noch einmal.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Dieser Test enthält Fragen, die nicht von der App unterstützt werden:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Fehler beim Laden des Inhalts';
$string['addon.mod_resource.openthefile'] = 'Datei öffnen';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Die Bewertung konnte nicht berechnet werden.';
$string['addon.mod_scorm.dataattemptshown'] = 'Diese Daten gehören zu Versuch {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Fehler beim Hinzufügen eines Offline-Versuchs. Versuchen Sie es noch einmal.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Fehler beim Laden des Lernpakets \'{{name}}\'.';
$string['addon.mod_scorm.errorgetscorm'] = 'Fehler beim Laden von Lernpaketdaten';
$string['addon.mod_scorm.errorinvalidversion'] = 'Die App unterstützt nur Lernpakete mit SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Das Herunterladen von Lernpaketen ist für diese Website deaktiviert. Fragen Sie  den Administrator.';
$string['addon.mod_scorm.errornovalidsco'] = 'Dieses Lernpaket hat kein sichtbares SCO zum Laden.';
$string['addon.mod_scorm.errorpackagefile'] = 'Die App unterstützt ausschließlich ZIP-Pakete.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Fehler beim Synchronisieren. Versuchen Sie es noch einmal.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Dieser Versuch enthält Daten, die noch nicht synchronisiert wurden.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Dieser Versuch kann nicht gesendet werden, weil Sie die maximale Anzahl von Versuchen überschritten haben.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Dieses Lernpaket ist noch nicht geladen. Es wird automatisch heruntergeladen, wenn Sie es öffnen.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Dieses Lernpaket wurde seit dem Herunterladen verändert. Es wird automatisch geladen, wenn Sie es öffnen.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Die Offline-Daten von Versuch {{number}} wurden gelöscht, weil sie nicht als neuer Versuch gezählt werden können.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Einige Versuche konnten nicht synchronisiert werden, weil der letzte Online-Versuch nicht beendet wurde. Beenden Sie zuerst den Online-Versuch.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Fehler beim Übertragen der Umfragedaten. Versuchen Sie es noch einmal.';
$string['addon.mod_survey.errorgetsurvey'] = 'Fehler beim Laden der Umfragedaten';
$string['addon.mod_survey.results'] = 'Ergebnisse';
$string['addon.mod_url.accessurl'] = 'URL öffnen';
$string['addon.mod_url.pointingtourl'] = 'Verlinkte URL';
$string['addon.mod_wiki.errorloadingpage'] = 'Fehler beim Laden der Seite';
$string['addon.mod_wiki.errornowikiavailable'] = 'Dieses Wiki hat noch keinen Inhalt.';
$string['addon.mod_wiki.gowikihome'] = 'Zur Wiki-Startseite';
$string['addon.mod_wiki.subwiki'] = 'Teilwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Der Titel darf nicht leer sein.';
$string['addon.mod_wiki.viewpage'] = 'Seite anzeigen';
$string['addon.mod_wiki.wikipage'] = 'Wiki-Seite';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Die Beurteilungsstrategie {{$a}} wird nicht unterstützt.';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Sie müssen einen Titel eingeben.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Die Abgabe wurde auf der Website geändert.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Die Beurteilung wurde auf der Website geändert.';
$string['addon.notes.userwithid'] = 'Nutzer/in mit ID {{id}}';
$string['addon.notes.warningnotenotsent'] = 'Die Anmerkungen konnten nicht zum Kurs {{course}} hinzugefügt werden. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Fehler beim Empfangen von Systemnachrichten';
$string['addon.notifications.notifications'] = 'Systemnachrichten';
$string['addon.notifications.playsound'] = 'Signalton abspielen';
$string['addon.notifications.therearentnotificationsyet'] = 'Keine Systemnachrichten';
$string['addon.storagemanager.deletecourse'] = 'Alle Kursdaten entladen';
$string['addon.storagemanager.deletedatafrom'] = 'Daten von {{name}} entladen';
$string['addon.storagemanager.info'] = 'Auf Ihrem Gerät gespeicherte Daten beschleunigen die Arbeit und ermöglichen die Offline-Verwendung der App. Sie können Daten entladen, wenn Sie Speicherplatz freigeben müssen.';
$string['addon.storagemanager.managestorage'] = 'Speicher verwalten';
$string['addon.storagemanager.storageused'] = 'Verwendeter Dateispeicher:';
$string['appstoredescription'] = 'Die offizielle Moodle App funktioniert mit allen Moodle-Plattformen, die für den mobilen Zugriff freigegeben sind. Bei Problemen wenden Sie sich an den Administrator für Ihr Moodle.

Mit der mobilen App können Sie mit Moodle lernen und arbeiten, egal wo Sie möchten. Folgende Möglichkeiten stehen zur Verfügung:
- Zugriff auf Kursinhalte ... auch wenn Sie offline sind
- Kontakt mit anderen Personen aufnehmen
- Mitteilungen zu Terminen und Nachrichten empfangen
- Bilder, Audio, Videos und andere Dateien mit dem mobilen Endgerät hochladen
- Persönliche Fortschritte verfolgen, Leistungen und Badges anzeigen
- und vieles mehr!

Alle Möglichkeiten finden Sie unter https://docs.moodle.org/de/Moodle_App

Über gute Bewertungen und Anregungen zur App würden wir uns sehr freuen.

Die App erfordert folgende Systemrechte:
- Zugriff auf Fotoalbum, Kamera und Audio
- Zugriff auf das Netzwerk, um sich mit Moodle zu verbinden
- Zugriff auf die SD-Karte (Lesen und Schreiben), um Inhalte zu speichern und offline zu nutzen
- Beim Start ausführen, um Systemnachrichten zu empfangen, auch wenn die App im Hintergrund läuft
- Ruhezustand verhindern, um jederzeit Systemnachrichten empfangen zu können';
$string['core.android'] = 'Android';
$string['core.browser'] = 'Browser';
$string['core.cannotconnect'] = '<strong>Keine Verbindung</strong>. Prüfen Sie, ob die URL für Ihre Website richtig eingegeben ist.';
$string['core.cannotdownloadfiles'] = 'Das Herunterladen von Dateien ist deaktiviert. Wenden Sie sich an den Administrator.';
$string['core.captureaudio'] = 'Audio aufnehmen';
$string['core.capturedimage'] = 'Foto aufgenommen';
$string['core.captureimage'] = 'Foto aufnehmen';
$string['core.capturevideo'] = 'Video aufnehmen';
$string['core.clearsearch'] = 'Suche löschen';
$string['core.clicktoseefull'] = 'Tippen zum Anzeigen aller Inhalte';
$string['core.comments.commentsnotworking'] = 'Kommentare können nicht abgerufen werden';
$string['core.comments.warningcommentsnotsent'] = 'Kommentare konnten nicht synchronisiert werden. {{error}}';
$string['core.confirmcanceledit'] = 'Möchten Sie diese Seite wirklich verlassen? Alle Änderungen gehen verloren!';
$string['core.confirmgotabroot'] = 'Möchten Sie wirklich zu {{name}} zurückgehen?';
$string['core.confirmgotabrootdefault'] = 'Möchten Sie wirklich zur initalen Seite des aktuellen Tabs zurückkehren?';
$string['core.confirmloss'] = 'Möchten Sie wirklich alle Änderungen verlieren?';
$string['core.confirmopeninbrowser'] = 'Möchten Sie dies im Webbrowser öffnen?';
$string['core.contenteditingsynced'] = 'Der Inhalt, den Sie gerade bearbeiten, wurde synchronisiert.';
$string['core.contentlinks.chooseaccount'] = 'Nutzerkonto wählen';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Nutzerkonto wählen, mit dem der Link geöffnet werden soll.';
$string['core.contentlinks.confirmurlothersite'] = 'Dieser Link führt zu einer anderen Website. Möchten Sie den Link öffnen?';
$string['core.contentlinks.errornoactions'] = 'Keine Aktion zu diesem Link gefunden';
$string['core.contentlinks.errornosites'] = 'Keine Website zu diesem Link gefunden';
$string['core.contentlinks.errorredirectothersite'] = 'Die URL-Weiterleitung kann nicht auf eine andere Website zeigen.';
$string['core.copiedtoclipboard'] = 'Text in die Zwischenablage kopiert';
$string['core.course.activitydisabled'] = 'Für die Website ist diese Aktivität in der mobilen App deaktiviert.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Für die Website ist ein Plugin installiert, das bisher nicht unterstützt wird.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'Diese Website muss aktualisiert werden.';
$string['core.course.allsections'] = 'Alle Abschnitte';
$string['core.course.askadmintosupport'] = 'Wenden Sie sich an den Administrator der Website, um diese Aktivität mit der mobilen App verwenden zu können.';
$string['core.course.availablespace'] = 'Sie haben im Moment etwa {{available}} freien Speicher.';
$string['core.course.confirmdeletemodulefiles'] = 'Möchten Sie diese Dateien wirklich löschen?';
$string['core.course.confirmdownload'] = 'Möchten Sie wirklich {{size}} herunterladen? {{availableSpace}}';
$string['core.course.confirmdownloadunknownsize'] = 'Die Datenmenge kann nicht berechnet werden. Möchten Sie wirklich die Daten herunterladen? {{availableSpace}}';
$string['core.course.confirmdownloadzerosize'] = 'Möchten Sie wirklich die Daten herunterladen? {{availableSpace}}';
$string['core.course.confirmlimiteddownload'] = 'Sie sind im Moment nicht über WLAN verbunden.';
$string['core.course.confirmpartialdownloadsize'] = 'Sie sind dabei, <strong>mindestens</strong> {{size}} herunterzuladen. {{availableSpace}} Möchten Sie wirklich weitermachen?';
$string['core.course.contents'] = 'Inhalte';
$string['core.course.couldnotloadsectioncontent'] = 'Die Abschnittsinhalte konnten nicht geladen werden. Versuchen Sie es später noch einmal.';
$string['core.course.couldnotloadsections'] = 'Die Abschnitte konnten nicht geladen werden. Versuchen Sie es später noch einmal.';
$string['core.course.errordownloadingcourse'] = 'Fehler beim Herunterladen des Kurses';
$string['core.course.errordownloadingsection'] = 'Fehler beim Herunterladen des Abschnitts';
$string['core.course.errorgetmodule'] = 'Fehler beim Laden von Aktivitätsdaten';
$string['core.course.insufficientavailablequota'] = 'Ihr Gerät konnte für diesen Download keinen Speicherplatz zuweisen. Möglicherweise ist Speicherplatz für anstehende App- oder Systemupdates reserviert. Sorgen Sie zuerst für ausreichend freien Speicher.';
$string['core.course.insufficientavailablespace'] = 'Sie versuchen, {{size}} herunterzuladen. Ihr Gerät hat danach möglicherweise nicht genügend Platz, um normal zu funktionieren. Sorgen Sie zuerst für ausreichend freien Speicher.';
$string['core.course.manualcompletionnotsynced'] = 'Manueller Abschluss wurde nicht synchronisiert';
$string['core.course.nocontentavailable'] = 'Momentan sind keine Inhalte verfügbar';
$string['core.coursenogroups'] = 'Sie sind nicht Mitglied einer Gruppe in diesem Kurs.';
$string['core.course.refreshcourse'] = 'Kurs neu laden';
$string['core.courses.cannotretrievemorecategories'] = 'Kursbereiche tiefer als Level {{$a}} können nicht abgerufen werden.';
$string['core.courses.confirmselfenrol'] = 'Möchten Sie sich selbst in diesen Kurs einschreiben?';
$string['core.courses.downloadcourses'] = 'Kurse herunterladen';
$string['core.courses.enrolme'] = 'Selbst einschreiben';
$string['core.courses.errorloadcategories'] = 'Fehler beim Laden von Kursbereichen';
$string['core.courses.errorloadcourses'] = 'Fehler beim Laden von Kursen';
$string['core.courses.errorloadplugins'] = 'Für diesen Kurs notwendige Plugins konnten nicht richtig geladen werden. Starten Sie die App neu und versuchen Sie es noch einmal.';
$string['core.courses.errorsearching'] = 'Fehler beim Suchen';
$string['core.courses.errorselfenrol'] = 'Fehler bei der Selbsteinschreibung';
$string['core.courses.filtermycourses'] = 'Meine Kurse filtern';
$string['core.courses.notenrollable'] = 'Sie können sich nicht selbst in diesen Kurs einschreiben.';
$string['core.courses.password'] = 'Einschreibeschlüssel';
$string['core.courses.searchcoursesadvice'] = 'Sie können Kurse suchen, um als Gast teilzunehmen oder sich selbst einzuschreiben, falls dies erlaubt ist.';
$string['core.courses.selfenrolment'] = 'Selbsteinschreibung';
$string['core.courses.totalcoursesearchresults'] = 'Alle Kurse: {{$a}}';
$string['core.course.useactivityonbrowser'] = 'Sie können dies im Webbrowser verwenden.';
$string['core.course.warningmanualcompletionmodified'] = 'Manueller Abschluss einer Aktivität wurde auf der Website geändert.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Manueller Offline-Abschluss des Kurses \'{{name}}\' wurde gelöscht. {{error}}';
$string['core.currentdevice'] = 'Aktuelles Gerät';
$string['core.datastoredoffline'] = 'Die Daten wurden Lokal auf dem Gerät gespeichert, weil sie nicht gesendet werden konnten. Sie werden automatisch später gesendet.';
$string['core.deletedoffline'] = 'Offline gelöscht';
$string['core.deleting'] = 'Löschen ...';
$string['core.desktop'] = 'Schreibtisch';
$string['core.dfdaymonthyear'] = 'DD.MM.YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D. MMM';
$string['core.dffulldate'] = 'dddd, D. MMMM YYYY, HH[:]mm';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'HH[:]mm';
$string['core.discard'] = 'Verwerfen';
$string['core.dismiss'] = 'Abbrechen';
$string['core.downloaded'] = 'Heruntergeladen';
$string['core.downloading'] = 'Herunterladen ...';
$string['core.editor.hidetoolbar'] = 'Leiste verbergen';
$string['core.editor.toggle'] = 'Editor umschalten';
$string['core.emptysplit'] = 'Das Seitenmenü ist leer oder wird noch geladen ...';
$string['core.errorchangecompletion'] = 'Fehler beim Ändern des Abschlussstatus. Versuchen Sie es noch einmal.';
$string['core.errordeletefile'] = 'Fehler beim Löschen der Datei. Versuchen Sie es noch einmal.';
$string['core.errordownloading'] = 'Fehler beim Laden der Datei';
$string['core.errordownloadingsomefiles'] = 'Fehler beim Laden der Dateien. Einige Dateien könnten fehlen.';
$string['core.errorfileexistssamename'] = 'Eine Datei mit gleichem Namen existiert bereits.';
$string['core.errorinvalidform'] = 'Das Formular enthält ungültige Daten. Füllen Sie alle notwendigen Felder aus und prüfen Sie, dass alle Daten richtig sind.';
$string['core.errorinvalidresponse'] = 'Ungültige Antwort empfangen. Wenden Sie sich an den Administrator, wenn der Fehler wieder auftritt.';
$string['core.errorloadingcontent'] = 'Fehler beim Laden des Inhalts';
$string['core.errorofflinedisabled'] = 'Der Offline-Zugriff auf diese Website ist deaktiviert. Sie müssen online sein, um die App zu verwenden.';
$string['core.erroropenfilenoapp'] = 'Fehler: Keine App zum Öffnen dieses Dateityps gefunden.';
$string['core.erroropenfilenoextension'] = 'Fehler beim Öffnen: Die Datei hat keine Endung.';
$string['core.erroropenpopup'] = 'Die Aktivität versucht, ein Popup zu öffnen. Popups werden in der App aber nicht unterstützt.';
$string['core.errorrenamefile'] = 'Fehler beim Ändern des Dateinamens. Versuchen Sie es noch einmal.';
$string['core.errorsomedatanotdownloaded'] = 'Beim Herunterladen dieser Aktivität könnten möglicherweise einige Daten aus Performance- und Datennutzungsgründen ausgenommen worden sein.';
$string['core.errorsync'] = 'Fehler beim Synchronisieren. Versuchen Sie es noch einmal.';
$string['core.errorsyncblocked'] = '{{$a}} kann im Moment wegen eines anderen Vorgangs nicht synchronisiert werden. Versuchen Sie es später noch einmal. Falls das Problem weiterhin besteht, starten Sie die App neu.';
$string['core.filenameexist'] = 'Der Dateiname existiert bereits: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Möchten Sie wirklich {{size}} hochladen?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Die Datenmenge kann nicht berechnet werden. Möchten Sie wirklich hochladen?';
$string['core.fileuploader.errorcapturingaudio'] = 'Fehler bei der Audioaufnahme';
$string['core.fileuploader.errorcapturingimage'] = 'Fehler beim Fotografieren';
$string['core.fileuploader.errorcapturingvideo'] = 'Fehler bei der Videoaufnahme';
$string['core.fileuploader.errorgettingimagealbum'] = 'Fehler beim Laden aus dem Fotoalbum';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Dateien können nur online hochgeladen werden.';
$string['core.fileuploader.errornoapp'] = 'Keine App zum Ausführen dieser Aktion gefunden';
$string['core.fileuploader.errorreadingfile'] = 'Fehler beim Lesen der Datei';
$string['core.fileuploader.errorwhileuploading'] = 'Fehler beim Hochladen der Datei';
$string['core.fileuploader.file'] = 'Datei';
$string['core.fileuploader.fileuploaded'] = 'Datei erfolgreich hochgeladen';
$string['core.fileuploader.maxbytesfile'] = 'Die Datei {{$a.file}} ist zu groß. Die maximale Größe zum Hochladen ist {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Fotoalbum';
$string['core.fileuploader.readingfile'] = 'Datei lesen';
$string['core.fileuploader.readingfileperc'] = 'Datei lesen: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Datei wählen';
$string['core.fileuploader.uploadafile'] = 'Datei hochladen';
$string['core.fileuploader.uploading'] = 'Hochladen ...';
$string['core.fileuploader.uploadingperc'] = 'Hochladen: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.offlinedisabled'] = 'Die Website erlaubt nicht das Herunterladen von H5P-Paketen.';
$string['core.h5p.play'] = 'H5P abspielen';
$string['core.hasdatatosync'] = 'Die Offline-Daten von {{$a}} müssen synchronisiert werden.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Bild';
$string['core.imageviewer'] = 'Bildanzeige';
$string['core.ios'] = 'iOS';
$string['core.lastdownloaded'] = 'Zuletzt heruntergeladen';
$string['core.lastsync'] = 'Zuletzt synchronisiert';
$string['core.loadmore'] = 'Mehr laden';
$string['core.login.authenticating'] = 'Authentifizieren ...';
$string['core.login.changepasswordbutton'] = 'Seite zur Kennwortänderung aufrufen';
$string['core.login.changepasswordhelp'] = 'Wenn Sie Probleme beim Ändern Ihres Kennworts haben, wenden Sie sich an den Administrator Ihrer Website. Administrator/innen sind die Personen, die das Moodle an Ihrer Schule, Universität, Firma oder Organisation verwalten. Wenn Sie nicht wissen, wie Sie mit ihnen Kontakt aufnehmen können, wenden Sie sich an Ihre Trainer/innen.';
$string['core.login.changepasswordinstructions'] = 'Sie können Ihr Kennwort nicht in der App ändern. Klicken Sie auf die folgende Taste, um Moodle in einem Webbrowser zu öffnen und Ihr Kennwort zu ändern. Beachten Sie, dass Sie den Browser nach dem Ändern des Kennworts schließen müssen, um wieder in die App zurückzukommen.';
$string['core.login.changepasswordlogoutinstructions'] = 'Wenn Sie die Website wechseln oder sich abmelden möchten, klicken Sie auf die folgende Taste:';
$string['core.login.changepasswordreconnectinstructions'] = 'Klicken Sie auf die folgende Taste, um die Website neu zu verbinden. Wenn Sie das Kennwort nicht erfolgreich ändern, öffnet sich wieder der vorherige Bildschirm.';
$string['core.login.confirmdeletesite'] = 'Möchten Sie \'{{sitename}}\' wirklich aus der Liste löschen?';
$string['core.login.connect'] = 'Verbinden';
$string['core.login.connecttomoodle'] = 'Zu Moodle verbinden';
$string['core.login.connecttomoodleapp'] = 'Sie versuchen, sich mit einer normalen Moodle-Website zu verbinden. Verwenden Sie die offizielle Moodle-App, um auf diese Website zu gelangen.';
$string['core.login.connecttoworkplaceapp'] = 'Sie versuchen, sich mit einer Moodle-Workplace-Website zu verbinden. Verwenden Sie die Moodle-Workplace-App, um auf diese Website zu gelangen.';
$string['core.login.contactyouradministrator'] = 'Wenden Sie sich an den Administrator, um weitere Hilfe zu bekommen.';
$string['core.login.contactyouradministratorissue'] = 'Wenden Sie sich an den Administrator, um folgendes Problem prüfen zu lassen: {{$a}}';
$string['core.login.credentialsdescription'] = 'Geben Sie den Anmeldenamen und das Kennwort ein. ';
$string['core.login.emailconfirmsentnoemail'] = '<p>An Ihre E-Mail-Adresse wurde eine Mitteilung gesendet.</p><p>Die Mitteilung enthält eine einfache Anleitung, um Ihre Registrierung abzuschließen. Falls Sie Probleme haben, wenden Sie sich an den Administrator der Website.</p>';
$string['core.login.emailnotmatch'] = 'Die E-Mail-Adressen stimmen nicht überein.';
$string['core.login.erroraccesscontrolalloworigin'] = 'Der Cross-Origin-Aufruf wurde zurückgewiesen. Weitere Infos: https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Fehler beim Entfernen der Website aus der Liste. Versuchen Sie es noch einmal.';
$string['core.login.errorexampleurl'] = 'Die URL https://campus.example.edu ist eine Beispiel-URL, die nicht zu einer echten Website gehört. <strong>Verwenden Sie die URL für die Website Ihrer Schule oder Ihrer Organisation.</strong>';
$string['core.login.errorupdatesite'] = 'Fehler bei der Authentifizierung';
$string['core.login.faqcannotconnectanswer'] = 'Wenden Sie sich bitte an den Administrator.';
$string['core.login.faqcannotconnectquestion'] = 'Ich habe meine Website-Adresse richtig eingegeben, aber ich kann mich nicht verbinden.';
$string['core.login.faqsetupsiteanswer'] = 'Besuchen Sie {{$link}}, um die verschiedenen Optionen zum Erstellen Ihrer eigenen Moodle-Website zu prüfen.';
$string['core.login.faqsetupsitelinktitle'] = 'Beginnen Sie.';
$string['core.login.faqsetupsitequestion'] = 'Ich möchte meine eigene Moodle-Website aufsetzen.';
$string['core.login.faqtestappanswer'] = 'Um die App mit einer Demo-Website zu testen, geben Sie im Feld "Ihre Website-Adresse" entweder "teacher" oder "student" ein und tippen Sie auf "Verbinden!"';
$string['core.login.faqtestappquestion'] = 'Ich möchte die App testen. Was kann ich machen?';
$string['core.login.faqwhatisurlanswer'] = '<p>Jede Schule oder Organisation hat ihre eigene Adresse für ihre Moodle-Website.</p><p>Um die Adresse herauszufinden, zu der Sie eine Verbindung herstellen möchten, machen Sie Folgendes:</p>
<ol><li>Öffnen Sie Ihren Webbrowser und rufen Sie die Anmeldeseite der Moodle-Website Ihrer Schule oder Organisation auf.</li><li>Oben in der Adressleiste sehen Sie die URL, z.B. "campus.example.edu". {{$image}}</li><li>Kopieren Sie die Adresse (kopieren Sie aber nicht /login und was danach kommt), fügen Sie die Adresse in die Moodle App ein und tippen Sie auf "Verbinden!"</li><li>Jetzt können Sie sich mit Ihrem Anmeldenamen und Ihrem Kennwort anmelden.</li>';
$string['core.login.faqwhatisurlquestion'] = 'Wie lautet die URL meiner Moodle-Website? Wie kann ich die Website meiner Schule finden?';
$string['core.login.findyoursite'] = 'Website suchen';
$string['core.login.helpmelogin'] = '<p>Auf der Welt gibt es viele tausend Websites mit Moodle. Diese App kann aber nur mit Websites verbunden werden, die für den Zugriff mit der mobilen Moodle App freigegeben wurden.</p><p>Falls Sie sich nicht mit Ihrer Website verbinden können, wenden Sie sich an den Administrator der Website und bitten ihn, die Anleitung zu lesen. <a href="https://docs.moodle.org/de/Moodle_App" target="_blank"> https://docs.moodle.org/de/Moodle_App </a></p><p>Um die App mit einer Demoseite auszuprobieren, schreiben Sie <i>teacher</i> oder <i>student</i> in das Feld <i>Website-Adresse</i> und tippen dann auf <b>Verbinden</b>.</p>';
$string['core.login.invalidaccount'] = 'Prüfen Sie Ihre Anmeldedaten oder wenden Sie sich an den Administrator der Website.';
$string['core.login.invalidmoodleversion'] = '<p>Falsche Moodle-Version.  Die Moodle-App unterstützt nur Moodle-Systeme ab {{$a}}.</p>
<p>Wenden Sie sich an den Administrator Ihrer Website, damit Ihr Moodle-System aktualisiert wird. Administrator/innen sind die Personen, die das Moodle an Ihrer Schule, Universität, Firma oder Organisation verwalten. Wenn Sie nicht wissen, wie Sie mit ihnen in Kontakt treten sollen, wenden Sie sich an Ihre Trainer/innen.</p>';
$string['core.login.invalidsite'] = 'Die URL der Website ist ungültig.';
$string['core.login.invalidtime'] = 'Ungültige Zeitangabe';
$string['core.login.invalidvaluemax'] = 'Der Maximalwert ist {{$a}}.';
$string['core.login.invalidvaluemin'] = 'Der Minimalwert ist {{$a}}.';
$string['core.login.localmobileunexpectedresponse'] = 'Die Verbindung zum Plugin \'Moodle Mobile - Zusatzfeatures\' ist fehlgeschlagen. Sie werden über den standardmäßigen mobilen Webservice authentifiziert.';
$string['core.login.loggedoutssodescription'] = 'Sie müssen sich neu authentifizieren. Melden Sie sich im Browser auf der Website an.';
$string['core.login.loginbutton'] = 'Anmelden';
$string['core.login.logininsiterequired'] = 'Sie müssen sich für diese Website im Browser anmelden.';
$string['core.login.mobileservicesnotenabled'] = 'Der mobile Zugriff ist für dieses Moodle nicht aktiviert. Wenden Sie sich an den Administrator, wenn Sie die mobile App aktiviert haben möchten.';
$string['core.login.newsitedescription'] = 'Geben Sie die URL zu Ihrer Website ein.';
$string['core.login.notloggedin'] = 'Sie müssen angemeldet sein.';
$string['core.login.passwordrequired'] = 'Kennwort fehlt';
$string['core.login.problemconnectingerror'] = 'Probleme beim Verbinden mit';
$string['core.login.problemconnectingerrorcontinue'] = 'Prüfen Sie, ob die URL richtig ist. Versuchen Sie es noch einmal.';
$string['core.login.recaptchachallengeimage'] = 'reCaptcha Challenge-Bild';
$string['core.login.recaptchaexpired'] = 'Überprüfung abgelaufen. Beantworten Sie die Sicherheitsfrage noch einmal.';
$string['core.login.recaptchaincorrect'] = 'Die Antwort auf die Sicherheitsfrage ist falsch.';
$string['core.login.reconnect'] = 'Neu verbinden';
$string['core.login.reconnectdescription'] = 'Die Authentifizierung ist abgelaufen oder ungültig. Sie müssen sich neu anmelden.';
$string['core.login.reconnectssodescription'] = 'Die Authentifizierung ist abgelaufen oder ungültig. Sie müssen sich im Webbrowser neu anmelden.';
$string['core.login.searchby'] = 'Suche nach:';
$string['core.login.selectsite'] = 'Wählen Sie Ihre Website';
$string['core.login.signupplugindisabled'] = '{{$a}} ist nicht aktiviert.';
$string['core.login.siteaddress'] = 'Ihre Website-Adresse';
$string['core.login.sitehasredirect'] = 'Ihre Website enthält mindestens eine HTTP-Weiterleitung. Die App kann keine Weiterleitungen verarbeiten und der Verbindungaufbau könnte fehlschlagen.';
$string['core.login.siteinmaintenance'] = 'Diese Website ist im Wartungsmodus.';
$string['core.login.sitepolicynotagreederror'] = 'Die Zustimmungserklärung wurde nicht bestätigt.';
$string['core.login.siteurl'] = 'URL der Website';
$string['core.login.siteurlrequired'] = 'Die URL der Website ist notwendig, z.B. <i>https://www.meinmoodle.de</i>';
$string['core.login.stillcantconnect'] = 'Können Sie sich immer noch nicht verbinden?';
$string['core.login.usernamerequired'] = 'Anmeldename fehlt';
$string['core.login.visitchangepassword'] = 'Möchten Sie die Website aufrufen, um das Kennwort zu ändern?';
$string['core.login.webservicesnotenabled'] = 'Die Webservices sind für diese Website deaktiviert. Wenden Sie sich an den Administrator, wenn Sie die mobile App aktiviert haben möchten.';
$string['core.lostconnection'] = 'Die Authentifizierung ist abgelaufen oder ungültig. Sie müssen sich neu anmelden.';
$string['core.mainmenu.appsettings'] = 'Einstellungen';
$string['core.mainmenu.changesite'] = 'Website wechseln';
$string['core.mainmenu.website'] = 'Website im Browser';
$string['core.needhelp'] = 'Brauchen Sie Hilfe?';
$string['core.networkerroriframemsg'] = 'Dieser Inhalt ist offline nicht verfügbar. Sie müssen online sein und es dann noch einmal versuchen.';
$string['core.networkerrormsg'] = 'Problem mit der Verbindung. Prüfen Sie die Verbindung und versuchen Sie es noch einmal.';
$string['core.nooptionavailable'] = 'Keine Option verfügbar';
$string['core.nopasswordchangeforced'] = 'Sie können nicht weitermachen, ohne das Kennwort zu ändern.';
$string['core.nopermissionerror'] = 'Sie haben aktuell keine Rechte, um dies zu tun.';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Nicht gesendet';
$string['core.nummore'] = '{{$a}} mehr';
$string['core.openfullimage'] = 'Tippen, um das Bild zu vergrößern';
$string['core.openinbrowser'] = 'Im Browser öffnen';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Zum Aktualisieren runterziehen';
$string['core.question.cannotdeterminestatus'] = 'Status kann nicht festgestellt werden';
$string['core.question.errorattachmentsnotsupported'] = 'Die App erlaubt keine Antworten mit Dateianhängen.';
$string['core.question.errorinlinefilesnotsupported'] = 'Die App unterstützt keine Bearbeitung von integrierten Dateien.';
$string['core.question.errorquestionnotsupported'] = 'Die App unterstützt diesen Fragetyp nicht: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tippen Sie zum Auswählen und tippen Sie noch einmal zum Ablegen.';
$string['core.question.questionmessage'] = 'Frage {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Sie werden zur Website weitergeleitet.';
$string['core.removefiles'] = 'Dateien entfernen {{$a}}';
$string['core.requireduserdatamissing'] = 'Im Nutzerprofil fehlen notwendige Einträge. Füllen Sie die Daten in der Website aus und versuchen Sie es noch einmal.<br>{{$a}}';
$string['core.retry'] = 'Neu versuchen';
$string['core.searching'] = 'Suchen';
$string['core.settings.about'] = 'Über die App';
$string['core.settings.appready'] = 'App nutzbar';
$string['core.settings.appsettings'] = 'Einstellungen der App';
$string['core.settings.appversion'] = 'Version';
$string['core.settings.cannotsyncoffline'] = 'Offline kann nicht synchronisiert werden.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Die Daten wurden nicht synchronisiert, weil die Einstellungen dies nur mit WLAN erlauben. Stellen Sie eine WLAN-Verbindung her.';
$string['core.settings.colorscheme'] = 'Farbschema';
$string['core.settings.colorscheme-auto'] = 'Automatisch (entsprechend den Systemeinstellungen)';
$string['core.settings.colorscheme-dark'] = 'Dunkel';
$string['core.settings.colorscheme-light'] = 'Hell';
$string['core.settings.compilationinfo'] = 'Compilation';
$string['core.settings.copyinfo'] = 'Device-Info in die Zwischenablage kopieren';
$string['core.settings.cordovadevicemodel'] = 'Cordova Device Model';
$string['core.settings.cordovadeviceosversion'] = 'Cordova Device OS Version';
$string['core.settings.cordovadeviceplatform'] = 'Cordova Device Platform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova Device UUID';
$string['core.settings.cordovaversion'] = 'Cordova Version';
$string['core.settings.debugdisplaydescription'] = 'Wenn diese Option aktiviert ist, werden zusätzliche Fehlerdaten angezeigt.';
$string['core.settings.deletesitefiles'] = 'Möchten Sie wirklich alle heruntergeladenen Dateien und gespeicherten Daten der Website \'{{sitename}}\' löschen? Sie können dann die App nicht mehr offline verwenden.';
$string['core.settings.deletesitefilestitle'] = 'Dateien löschen';
$string['core.settings.deviceinfo'] = 'Geräteinformationen';
$string['core.settings.deviceos'] = 'Geräte-OS';
$string['core.settings.devicewebworkers'] = 'Device Web Workers unterstützt';
$string['core.settings.displayformat'] = 'Bildschirm';
$string['core.settings.enabledownloadsection'] = 'Abschnitte herunterladen';
$string['core.settings.enablefirebaseanalytics'] = 'Firebase Analytics aktivieren';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Wenn diese Option aktiviert ist, sammelt die App anonymisierte Nutzungsdaten.';
$string['core.settings.enablerichtexteditor'] = 'Texteditor aktivieren';
$string['core.settings.enablerichtexteditordescription'] = 'Der Texteditor ist verfügbar, wenn Texte eingegeben werden sollen.';
$string['core.settings.enablesyncwifi'] = 'Nur mit WLAN synchronierieren';
$string['core.settings.entriesincache'] = '{{$a}} Einträge im Cache';
$string['core.settings.errordeletesitefiles'] = 'Fehler beim Löschen der Dateien';
$string['core.settings.errorsyncsite'] = 'Fehler beim Synchronisieren der Daten. Sie müssen online sein und es dann noch einmal versuchen.';
$string['core.settings.estimatedfreespace'] = 'Verfügbarer Speicher';
$string['core.settings.filesystemroot'] = 'Dateisystembasis';
$string['core.settings.fontsize'] = 'Schriftgröße';
$string['core.settings.forcedsetting'] = 'Diese Einstellung wird durch die Website-Konfiguration erzwungen.';
$string['core.settings.localnotifavailable'] = 'Lokale Systemnachrichten verfügbar';
$string['core.settings.locationhref'] = 'Webview URL';
$string['core.settings.navigatorlanguage'] = 'Browsersprache';
$string['core.settings.navigatoruseragent'] = 'Browserkennung (userAgent)';
$string['core.settings.networkstatus'] = 'Internetverbindung';
$string['core.settings.opensourcelicenses'] = 'Open Source Lizenzen';
$string['core.settings.privacypolicy'] = 'Datenschutzerklärung';
$string['core.settings.publisher'] = 'Herausgeber/in';
$string['core.settings.pushid'] = 'ID für Push-Nachrichten';
$string['core.settings.reportinbackground'] = 'Fehler automatisch senden';
$string['core.settings.screen'] = 'Bildschirmgröße';
$string['core.settings.showdownloadoptions'] = 'Optionen zum Herunterladen anzeigen';
$string['core.settings.siteinfo'] = 'Website';
$string['core.settings.spaceusage'] = 'Speichernutzung';
$string['core.settings.spaceusagehelp'] = 'Beim Löschen der gespeicherten Infos werden alle Offline-Daten der Website entfernt. Sie können die App dann nicht mehr ohne Internetverbindung verwenden.';
$string['core.settings.synchronization'] = 'Synchronisieren';
$string['core.settings.synchronizenow'] = 'Synchronisieren';
$string['core.settings.synchronizenowhelp'] = 'Beim Synchronisieren werden ausstehende Änderungen und alle im Gerät speicherten Offline-Aktivitäten mit der Website ausgetauscht. Mitteilungen und Systemnachrichten werden übertragen.';
$string['core.settings.syncsettings'] = 'Synchronisieren';
$string['core.settings.versioncode'] = 'Versionscode';
$string['core.settings.versionname'] = 'Versionsname';
$string['core.settings.wificonnection'] = 'WLAN-Verbindung';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Wählen Sie ein Nutzerkonto, um die Datei dort zu speichern.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Eine Datei mit gleichem Namen existiert bereits. Möchten Sie die vorhandene Datei ersetzen oder umbenennen in \'{{$a}}\'?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Keine gespeicherten Websites. Fügen Sie zuerst eine Website hinzu, bevor Sie eine Datei mit der App teilen.';
$string['core.sharedfiles.nosharedfiles'] = 'Keine geteilten Dateien für diese Website';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Sie haben hier keine Dateien zum Hochladen. Wenn Sie eine Datei aus einer anderen App hochladen möchten, suchen Sie diese Datei und tippen Sie auf die Taste \'Öffnen in\'.';
$string['core.sharedfiles.rename'] = 'Umbenennen';
$string['core.sharedfiles.replace'] = 'Ersetzen';
$string['core.sharedfiles.sharedfiles'] = 'Geteilte Dateien';
$string['core.sharedfiles.successstorefile'] = 'Die Datei wurde erfolgreich gespeichert. Sie können die Datei in \'Meine Dateien\' hochladen oder in einer Aktivität verwenden.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Sorry ...';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Dieser Tag-Bereich wird von der App nicht unterstützt.';
$string['core.tag.warningareasnotsupported'] = 'Einige der Tag-Bereiche werden nicht angezeigt, weil sie von der App nicht unterstützt werden.';
$string['core.thereisdatatosync'] = 'Die Offline-Daten {{$a}} müssen synchronisiert werden.';
$string['core.tryagain'] = 'Versuchen Sie es noch einmal.';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh oh!';
$string['core.unexpectederror'] = 'Unerwarteter Fehler! Sie müssen die App neu starten und es dann noch einmal versuchen.';
$string['core.unicodenotsupported'] = 'Manche Emojis können auf dieser Website nicht verwendet werden. Die betreffenden Zeichen werden beim Senden der Mitteilung gelöscht.';
$string['core.unicodenotsupportedcleanerror'] = 'Der Text ist leer, nachdem die Unicode-Zeichen gelöscht wurden.';
$string['core.unknown'] = 'Unbekannt';
$string['core.unzipping'] = 'Entpacken ...';
$string['core.updaterequired'] = 'Aktualisierung der App notwendig';
$string['core.updaterequireddesc'] = 'Aktualisieren Sie Ihre App auf die Version {{$a}}';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Die Nutzerdetails zu dieser Person sind für Sie nicht verfügbar.';
$string['core.user.errorloaduser'] = 'Fehler beim Laden der Nutzerdetails';
$string['core.user.sendemail'] = 'E-Mail';
$string['core.viewcode'] = 'Code zeigen';
$string['core.vieweditor'] = 'Editor zeigen';
$string['core.viewembeddedcontent'] = 'Eingebettete Inhalte anzeigen';
$string['core.warningofflinedatadeleted'] = 'Die Offline-Daten von {{component}} \'{{name}}\' wurden gelöscht. {{error}}';
$string['core.whoissiteadmin'] = 'Administrator/innen sind Personen, die die Moodle-Website in Ihrer Schule, Universität, Organisation oder Firma verwalten. Falls Sie nicht wissen, wie Sie diese kontaktieren können, fragen Sie Ihre Trainer/innen.';
$string['core.whoops'] = 'Uuups!';
$string['core.whyisthishappening'] = 'Warum passiert das?';
$string['core.windowsphone'] = 'Windows Phone';
$string['core.wsfunctionnotavailable'] = 'Die Webservice-Funktion ist nicht verfügbar.';
$string['core.youreoffline'] = 'Offline';
$string['core.youreonline'] = 'Sie sind wieder online';
$string['pluginname'] = 'Sprachpaket für die Moodle App';
