<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_boostnavigation', language 'de', branch 'MOODLE_36_STABLE'
 *
 * @package   local_boostnavigation
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'Boost Navigations-Frickelei';
$string['privacy:metadata:preference:collapse'] = 'Der Status des Zusammenklappens eines Knotens in der Boost Navigation.';
$string['privacy:request:preference:collapse'] = 'Der Status des Zusammenklappens des Knotens "{$a->nodename}" in der Boost Navigation ist {$a->collapse}.';
$string['setting_collapseactivitiescoursenode'] = '"Aktivitäten"-Knoten zusammenklappbar';
$string['setting_collapseactivitiescoursenodedefault'] = '"Aktivitäten"-Knoten standardmäßig zusammenklappen';
$string['setting_collapseactivitiescoursenodedefault_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der "Aktivitäten"-Knoten standardmäßig zusammengeklappt ist. Andernfalls ist er standardmäßig ausgeklappt. Diese Einstellung wirkt sich für jeden Nutzer nur genau einmal aus, wenn der Knoten zum ersten Mal angezeigt wird.<br /><em>Diese Einstellung wird nur verwendet, wenn das Zusammenklappen des "Aktivitäten"-Knoten auch aktiviert ist.</em>';
$string['setting_collapseactivitiescoursenode_desc'] = 'Durch Aktivieren dieser Einstellung ermöglichen Sie es den Nutzern, den "Aktivitäten"-Knoten zusammenzuklappen.<br /><em>Diese Einstellung wird nur verwendet, wenn das Hinzufügen des "Aktivitäten"-Knoten auch aktiviert ist.</em>';
$string['setting_collapseactivitiescoursenodesession'] = 'Zusammenklapp-Status des "Aktivitäten"-Knoten nur für Sitzung speichern';
$string['setting_collapseactivitiescoursenodesession_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der Status, ob der "Aktivitäten"-Knoten zusammengeklappt oder ausgeklappt ist, nur innerhalb einer Sitzung gespeichert wird. Nach dem nächsten Logout und Login eines Nutzers wird der Status wieder auf den Standardwert, welcher weiter oben definiert ist, gesetzt. Wenn die Einstellung deaktiviert ist, wird der Status sitzungsübergreifend gespeichert.<br /><em>Diese Einstellung wird nur verwendet, wenn das Zusammenklappen des "Aktivitäten"-Knoten auch aktiviert ist.</em>';
$string['setting_collapsebottomnodesheading'] = 'Eigene Knoten am Ende der Boost-Navigation zusammenklappen';
$string['setting_collapsecoursenodesheading'] = 'Knoten in der Boost-Kursnavigation zusammenklappen';
$string['setting_collapsecoursesectionscoursenode'] = '"Abschnitte"-Knoten zusammenklappbar';
$string['setting_collapsecoursesectionscoursenodedefault'] = '"Abschnitte"-Knoten standardmäßig zusammenklappen';
$string['setting_collapsecoursesectionscoursenodedefault_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der "Abschnitte"-Knoten standardmäßig zusammengeklappt ist. Andernfalls ist er standardmäßig ausgeklappt. Diese Einstellung wirkt sich für jeden Nutzer nur genau einmal aus, wenn der Knoten zum ersten Mal angezeigt wird.<br /><em>Diese Einstellung wird nur verwendet, wenn das Zusammenklappen des "Abschnitte"-Knoten auch aktiviert ist.</em>';
$string['setting_collapsecoursesectionscoursenode_desc'] = 'Durch Aktivieren dieser Einstellung ermöglichen Sie es den Nutzern, den "Abschnitte"-Knoten zusammenzuklappen.<br /><em>Diese Einstellung wird nur verwendet, wenn das Hinzufügen des "Abschnitte"-Knoten auch aktiviert ist.</em>';
$string['setting_collapsecoursesectionscoursenodesession'] = 'Zusammenklapp-Status des "Abschnitte"-Knoten nur für Sitzung speichern';
$string['setting_collapsecoursesectionscoursenodesession_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der Status, ob der "Abschnitte"-Knoten zusammengeklappt oder ausgeklappt ist, nur innerhalb einer Sitzung gespeichert wird. Nach dem nächsten Logout und Login eines Nutzers wird der Status wieder auf den Standardwert, welcher weiter oben definiert ist, gesetzt. Wenn die Einstellung deaktiviert ist, wird der Status sitzungsübergreifend gespeichert.<br /><em>Diese Einstellung wird nur verwendet, wenn das Zusammenklappen des "Abschnitte"-Knoten auch aktiviert ist.</em>';
$string['setting_collapsecustombottomnodesadmins'] = 'Eigene Endknoten für Administratoren zusammenklappbar';
$string['setting_collapsecustombottomnodesadminsaccordion'] = 'Eigene Endknoten für Administratoren als Akkordeon zusammenklappen';
$string['setting_collapsecustombottomnodesadminsaccordion_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Endknoten für Administratoren als Akkordeon zusammengeklappt, was bedeutet dass stets nur ein Elternknoten ausgeklappt sein kann. Wird ein zweiter Elternknoten ausgeklappt, wird der aktuell ausgeklappte Knoten automatisch zusammengeklappt. Wenn diese Einstellung deaktiviert ist, können mehrere Elternknoten gleichzeitig ausgeklappt sein.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Endknoten für Administratoren zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustombottomnodesadminsdefault'] = 'Eigene Endknoten für Administratoren standardmäßig zusammenklappen';
$string['setting_collapsecustombottomnodesadminsdefault_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Endknoten für Administratoren standardmäßig zugeklappt ausgeliefert. Sonst sind sie standardmäßig ausgeklappt. Diese Einstellung hat nur Einfluss auf den initialen Zustand des Menüs, wenn es dem Administrator zum ersten mal angezeigt wird.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Endknoten für Administratoren zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustombottomnodesadmins_desc'] = 'Durch Aktivierung dieser Einstellung können Administratoren die hinzugefügten Endknoten zusammenklappen. <br/>
<em>Diese Einstellung wird nur verarbeitet, wenn zur Einstellung "Eigene Endknoten für Administratoren einfügen" mindestens ein Knoten hinzugefügt wurde.</em>';
$string['setting_collapsecustombottomnodesadminssession'] = 'Zusammenklapp-Status der eigenen Endknoten für Administratoren nur für Sitzung speichern';
$string['setting_collapsecustombottomnodesadminssession_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der Status, ob die Endknoten für Administratoren zusammengeklappt oder ausgeklappt sind, nur innerhalb einer Sitzung gespeichert wird. Nach dem nächsten Logout und Login eines Nutzers wird der Status wieder auf den Standardwert, welcher weiter oben definiert ist, gesetzt. Wenn die Einstellung deaktiviert ist, wird der Status sitzungsübergreifend gespeichert.<br /><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Endknoten für Administratoren zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustombottomnodesusers'] = 'Eigene Endknoten für Nutzer/innen zusammenklappbar';
$string['setting_collapsecustombottomnodesusersaccordion'] = 'Eigene Endknoten für Nutzer/innen als Akkordeon zusammenklappen';
$string['setting_collapsecustombottomnodesusersaccordion_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Endknoten den Nutzer/innen als Akkordeon zusammengeklappt, was bedeutet dass stets nur ein Elternknoten ausgeklappt sein kann. Wird ein zweiter Elternknoten ausgeklappt, wird der aktuell ausgeklappte Knoten automatisch zusammengeklappt. Wenn diese Einstellung deaktiviert ist, können mehrere Elternknoten gleichzeitig ausgeklappt sein.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Endknoten für Nutzer/innen zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustombottomnodesusersdefault'] = 'Eigene Endknoten für Nutzer/innen standardmäßig zusammenklappen';
$string['setting_collapsecustombottomnodesusersdefault_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Endknoten den Nutzer/innen standardmäßig zugeklappt ausgeliefert. Sonst sind sie standardmäßig ausgeklappt. Diese Einstellung hat nur Einfluss auf den initialen Zustand des Menüs, wenn es einer Person zum ersten Mal angezeigt wird.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Endknoten für Nutzer/innen zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustombottomnodesusers_desc'] = 'Durch Aktivierung dieser Einstellung können Nutzer/innen die hinzugefügten Endknoten zusammenklappen. <br/>
<em>Diese Einstellung wird nur verarbeitet, wenn zur Einstellung "Eigene Endknoten für Nutzer/innen einfügen" mindestens ein Knoten hinzugefügt wurde.</em>';
$string['setting_collapsecustombottomnodesuserssession'] = 'Zusammenklapp-Status der eigenen Endknoten für Nutzer/innen nur für Sitzung speichern';
$string['setting_collapsecustombottomnodesuserssession_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der Status, ob die Endknoten für Nutzer/innen zusammengeklappt oder ausgeklappt sind, nur innerhalb einer Sitzung gespeichert wird. Nach dem nächsten Logout und Login eines Nutzers wird der Status wieder auf den Standardwert, welcher weiter oben definiert ist, gesetzt. Wenn die Einstellung deaktiviert ist, wird der Status sitzungsübergreifend gespeichert.<br /><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Endknoten für Nutzer/innen zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomcoursenodesadmins'] = 'Eigene Kursknoten für Administratoren zusammenklappbar';
$string['setting_collapsecustomcoursenodesadminsaccordion'] = 'Eigene Kursknoten für Administratoren als Akkordeon zusammenklappen';
$string['setting_collapsecustomcoursenodesadminsaccordion_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Kursnavigationsknoten den Administratoren als Akkordeon zusammengeklappt, was bedeutet dass stets nur ein Elternknoten ausgeklappt sein kann. Wird ein zweiter Elternknoten ausgeklappt, wird der aktuell ausgeklappte Knoten automatisch zusammengeklappt. Wenn diese Einstellung deaktiviert ist, können mehrere Elternknoten gleichzeitig ausgeklappt sein.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Kursnavigationsknoten für Administratoren zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomcoursenodesadminsdefault'] = 'Eigene Kursknoten für Administratoren standardmäßig zusammenklappen';
$string['setting_collapsecustomcoursenodesadminsdefault_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Kursnavigationsknoten den Administratoren standardmäßig zugeklappt ausgeliefert. Sonst sind sie standardmäßig ausgeklappt. Diese Einstellung hat nur Einfluss auf den initialen Zustand des Menüs, wenn es dem Administrator zum ersten mal angezeigt wird.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Kursnavigationsknoten für Administratoren zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomcoursenodesadmins_desc'] = 'Durch Aktivierung dieser Einstellung können Administratoren die hinzugefügten Kursnavigationsknoten zusammenklappen. <br/>
<em>Diese Einstellung wird nur verarbeitet, wenn zur Einstellung "Eigene Kursnavigationsknoten für Administratoren hinzufügen" mindestens ein Knoten hinzugefügt wurde.</em>';
$string['setting_collapsecustomcoursenodesadminssession'] = 'Zusammenklapp-Status der eigenen Kursnavigationsknoten für Administratoren nur für Sitzung speichern';
$string['setting_collapsecustomcoursenodesadminssession_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der Status, ob die Kursnavigationsknoten für Administratoren zusammengeklappt oder ausgeklappt sind, nur innerhalb einer Sitzung gespeichert wird. Nach dem nächsten Logout und Login eines Nutzers wird der Status wieder auf den Standardwert, welcher weiter oben definiert ist, gesetzt. Wenn die Einstellung deaktiviert ist, wird der Status sitzungsübergreifend gespeichert.<br /><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Kursnavigationsknoten für Administratoren zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomcoursenodesusers'] = 'Eigene Kursknoten für Nutzer/innen zusammenklappbar';
$string['setting_collapsecustomcoursenodesusersaccordion'] = 'Eigene Kursknoten für Nutzer/innen als Akkordeon zusammenklappen';
$string['setting_collapsecustomcoursenodesusersaccordion_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Kursnavigationsknoten den Nutzer/innern als Akkordeon zusammengeklappt, was bedeutet dass stets nur ein Elternknoten ausgeklappt sein kann. Wird ein zweiter Elternknoten ausgeklappt, wird der aktuell ausgeklappte Knoten automatisch zusammengeklappt. Wenn diese Einstellung deaktiviert ist, können mehrere Elternknoten gleichzeitig ausgeklappt sein.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Kursnavigationsknoten für Nutzer/innen zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomcoursenodesusersdefault'] = 'Eigene Kursknoten für Nutzer/innen standardmäßig zusammenklappen';
$string['setting_collapsecustomcoursenodesusersdefault_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Kursnavigationsknoten den Nutzer/innern standardmäßig zugeklappt ausgeliefert. Sonst sind sie standardmäßig ausgeklappt. Diese Einstellung hat nur Einfluss auf den initialen Zustand des Menüs, wenn es für dem / der Nutzer/in zum ersten mal angezeigt wird.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Kursnavigationsknoten für Nutzer/innen zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomcoursenodesusers_desc'] = 'Durch Aktivierung dieser Einstellung können Nutzer/innen die hinzugefügten Kursnavigationsknoten zusammenklappen. <br/>
<em>Diese Einstellung wird nur verarbeitet, wenn zur Einstellung "Eigene Kursnavigationsknoten für Nutzer/innen hinzufügen" mindestens ein Knoten hinzugefügt wurde.</em>';
$string['setting_collapsecustomcoursenodesuserssession'] = 'Zusammenklapp-Status der eigenen Kursnavigationsknoten für Nutzer/innen nur für Sitzung speichern';
$string['setting_collapsecustomcoursenodesuserssession_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der Status, ob die Kursnavigationsknoten für Nutzer/innen zusammengeklappt oder ausgeklappt sind, nur innerhalb einer Sitzung gespeichert wird. Nach dem nächsten Logout und Login eines Nutzers wird der Status wieder auf den Standardwert, welcher weiter oben definiert ist, gesetzt. Wenn die Einstellung deaktiviert ist, wird der Status sitzungsübergreifend gespeichert.<br /><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Kursnavigationsknoten für Nutzer/innen zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomnodesadmins'] = 'Eigene Hauptnavigationsnoten für Administratoren zusammenklappbar';
$string['setting_collapsecustomnodesadminsaccordion'] = 'Eigene Hauptnavigationsnoten für Administratoren als Akkordeon zusammenklappen';
$string['setting_collapsecustomnodesadminsaccordion_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Hauptnavigationsknoten den Administratoren als Akkordeon zusammengeklappt, was bedeutet dass stets nur ein Elternknoten ausgeklappt sein kann. Wird ein zweiter Elternknoten ausgeklappt, wird der aktuell ausgeklappte Knoten automatisch zusammengeklappt. Wenn diese Einstellung deaktiviert ist, können mehrere Elternknoten gleichzeitig ausgeklappt sein.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Hauptnavigationsknoten für Administratoren zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomnodesadminsdefault'] = 'Eigene Hauptnavigationsknoten für Administratoren standardmäßig zusammenklappen';
$string['setting_collapsecustomnodesadminsdefault_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Hauptnavigationsknoten den Administratoren standardmäßig zugeklappt ausgeliefert. Sonst sind sie standardmäßig ausgeklappt. Diese Einstellung hat nur Einfluss auf den initialen Zustand des Menüs, wenn es für den Administrator zum ersten mal angezeigt wird.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Hauptnavigationsknoten für Administratoren zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomnodesadmins_desc'] = 'Durch Aktivierung dieser Einstellung können Administratoren die hinzugefügten Hauptnavigationsknoten zusammenklappen. <br/>
<em>Diese Einstellung wird nur verarbeitet, wenn zur Einstellung "Eigene Hauptnavigationsknoten für Administratoren hinzufügen" mindestens ein Knoten hinzugefügt wurde.</em>';
$string['setting_collapsecustomnodesadminssession'] = 'Zusammenklapp-Status der eigenen Hauptnavigationsknoten für Administratoren nur für Sitzung speichern';
$string['setting_collapsecustomnodesadminssession_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der Status, ob die Hauptnavigationsknoten für Administratoren zusammengeklappt oder ausgeklappt sind, nur innerhalb einer Sitzung gespeichert wird. Nach dem nächsten Logout und Login eines Nutzers wird der Status wieder auf den Standardwert, welcher weiter oben definiert ist, gesetzt. Wenn die Einstellung deaktiviert ist, wird der Status sitzungsübergreifend gespeichert.<br /><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Hauptnavigationsknoten für Administratoren zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomnodesusers'] = 'Eigene Hauptnavigationsknoten für Nutzer/innen zusammenklappbar';
$string['setting_collapsecustomnodesusersaccordion'] = 'Eigene Hauptnavigationsknoten für Nutzer/innen als Akkordeon zusammenklappen';
$string['setting_collapsecustomnodesusersaccordion_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Hauptnavigationsknoten den Nutzer/innern als Akkordeon zusammengeklappt, was bedeutet dass stets nur ein Elternknoten ausgeklappt sein kann. Wird ein zweiter Elternknoten ausgeklappt, wird der aktuell ausgeklappte Knoten automatisch zusammengeklappt. Wenn diese Einstellung deaktiviert ist, können mehrere Elternknoten gleichzeitig ausgeklappt sein.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Hauptnavigationsknoten für Nutzer/innen zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomnodesusersdefault'] = 'Eigene Hauptnavigationsknoten für Nutzer/innen standardmäßig zusammenklappen';
$string['setting_collapsecustomnodesusersdefault_desc'] = 'Durch Aktivierung dieser Einstellung werden die hinzugefügten Hauptnavigationsknoten den Nutzer/innern standardmäßig zugeklappt ausgeliefert. Sonst sind sie standardmäßig ausgeklappt. Diese Einstellung hat nur Einfluss auf den initialen Zustand des Menüs, wenn es Einer Person zum ersten Mal angezeigt wird.<br/><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Hauptnavigationsknoten für Nutzer/innen zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsecustomnodesusers_desc'] = 'Durch Aktivierung dieser Einstellung können Nutzer/innen die hinzugefügten Hauptnavigationsknoten zusammenklappen. <br/>
<em>Diese Einstellung wird nur verarbeitet, wenn zur Einstellung "Eigene Hauptnavigationsknoten für Nutzer/innen hinzufügen" mindestens ein Knoten hinzugefügt wurde.</em>';
$string['setting_collapsecustomnodesuserssession'] = 'Zusammenklapp-Status der eigenen Hauptnavigationsknoten für Nutzer/innen nur für Sitzung speichern';
$string['setting_collapsecustomnodesuserssession_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der Status, ob die Hauptnavigationsknoten für Nutzer/innen zusammengeklappt oder ausgeklappt sind, nur innerhalb einer Sitzung gespeichert wird. Nach dem nächsten Logout und Login eines Nutzers wird der Status wieder auf den Standardwert, welcher weiter oben definiert ist, gesetzt. Wenn die Einstellung deaktiviert ist, wird der Status sitzungsübergreifend gespeichert.<br /><em>Diese Einstellung wird nur verarbeitet, wenn die  Einstellung "Eigene Hauptnavigationsknoten für Nutzer/innen zusammenklappbar" aktiviert ist.</em>';
$string['setting_collapsemycoursesnode'] = '"Meine Kurse"-Knoten zusammenklappbar';
$string['setting_collapsemycoursesnodedefault'] = '"Meine Kurse"-Knoten standardmäßig zusammenklappen';
$string['setting_collapsemycoursesnodedefault_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der "Meine Kurse"-Knoten standardmäßig zusammengeklappt ist. Andernfalls ist er standardmäßig ausgeklappt. Diese Einstellung wirkt sich für jeden Nutzer nur genau einmal aus, wenn der Knoten zum ersten Mal angezeigt wird.<br /><em>Diese Einstellung wird nur verwendet, wenn das Zusammenklappen des "Meine Kurse"-Knoten auch aktiviert ist.</em>';
$string['setting_collapsemycoursesnode_desc'] = 'Durch Aktivieren dieser Einstellung ermöglichen Sie es den Nutzern, den "Meine Kurse"-Knoten zusammenzuklappen.';
$string['setting_collapsemycoursesnodeperformancehint'] = 'Beachten Sie, dass diese Einstellung nur funktioniert, wenn Sie die Einstellung <a href="{$a->url}">navshowmycoursecategories</a> nicht aktiviert haben. Falls Sie navshowmycoursecategories aktiviert haben, wird diese Einstellung ignoriert werden.';
$string['setting_collapsemycoursesnodesession'] = 'Zusammenklapp-Status des "Meine Kurse"-Knoten nur für Sitzung speichern';
$string['setting_collapsemycoursesnodesession_desc'] = 'Durch Aktivieren dieser Einstellung steuern Sie, dass der Status, ob der "Meine Kurse"-Knoten zusammengeklappt oder ausgeklappt sind, nur innerhalb einer Sitzung gespeichert wird. Nach dem nächsten Logout und Login eines Nutzers wird der Status wieder auf den Standardwert, welcher weiter oben definiert ist, gesetzt. Wenn die Einstellung deaktiviert ist, wird der Status sitzungsübergreifend gespeichert.<br /><em>Diese Einstellung wird nur verwendet, wenn das Zusammenklappen des "Meine Kurse"-Knoten auch aktiviert ist.</em>';
$string['setting_collapsenodesheading'] = 'Knoten in der Boost-Hauptnavigation zusammenklappen';
$string['setting_collapsenodestechnicalhint'] = 'Aus technischer Sicht wird diese Funktionalität erreicht, indem etwas JavaScript und CSS zur Seite hinzugefügt wird, welche die Knoten zweiter Ebene anzeigt oder verbirgt, sobald der Nutzer auf den Knoten klickt. Der Zuammenklapp-Status des Knoten wird in der Session jedes Nutzers verarbeitet und in einer persönlichen Nutzereinstellung gespeichert. Die Knoten werden also nur in der Boost Navigation verborgen, sie verbleiben aber im internen Navigationsbaum und können weiterhin von anderen Teilen von Moodle genutzt werden.';
$string['setting_customnodesusageadmins'] = 'Jede Zeile besteht aus einem Link-Titel, einer Link-URL und unterstützten Sprachen (optional). Die einzelnen Elemente sind mit einem Trennzeichen ("|") separiert. Jeder Knoten steht in einer neuen Zeile.<br/><br/>
Beispiele:<br/>
Moodle|http://www.moodle.org|en,de<br />
Nutzerliste|/admin/user.php<br /><br />
Weitere Informationen zu den Parametern:
<ul>
<li><b>Titel:</b> Dieser Text wird als anklickbare Beschriftung des Knotens angezeigt.</li>
<li><b>Link:</b> Das Linkziel muss eine vollständige URL (z.B. https://moodle.org) oder ein relativer Pfad innerhalb der Moodle Instanz (z.B. /login/logout.php) sein.</li>
<li><b>Unterstützte Sprachen (optional):</b> Der Knoten wird nur Nutzer/innen angezeigt, die die entsprechende Sprache eingestellt haben. Mehrere unterstütze Sprachen werden über Komma separiert. Um den Knoten in allen Sprachen anzuzeigen, lassen Sie dieses Feld leer.</li>
</ul>
Bitte beachten Sie:
<ul>
<li>Eigene Knoten für Administratoren werden von der selben Funktion verarbeitet wie eigene Knoten für Nutzer/innen. Daher stehen für eigene Knoten für Administratoren neben den oben angegebenen Parametern prinzipiell dieselben Parameter wie für eigene Knoten für Nutzer/innen zur Verfügung. Sie können diese problemlos einsetzen falls Sie sie für einen speziellen Bedarf benötigen, auch wenn sie hier aus Gründen der Vereinfachung nicht noch einmal dokumentiert werden.</li>
<li>Der angegebene Titel kann auch Platzhalter enthalten, z.B. {coursefullname} um einen Knoten zu erzeugen, der mit dem Namen des aktuellen Kurses beschriftet ist. Platzhalter werden in geschweifte Klammern eingefasst und automatisch beim Erzeugen des Knotens ersetzt.<br />Folgende Platzhalter stehen zur Verfügung:
<ul>
<li>{coursefullname}: Der Langname des Kurses</li>
<li>{courseshortname}: Der Kurzname des Kurses</li>
<li>{editingtoggle}: Der Wert \'Bearbeiten einschalten\' oder \'Bearbeiten ausschalten\' des verwendeten Sprachpakets</li>
<li>{userfullname}: Der Name des angemeldeten Nutzers</li>
<li>{userusername}: Der Anmeldename des angemeldeten Nutzers</li>
</ul>
</li>
<li>Das angegebene Linkziel kann ebenfalls Platzhalter enthalten, z.B. /course/edit.php?id={courseid} um einen Knoten zu erzeugen, der auf die Einstellungen des aktuellen Kurses verlinkt. Platzhalter werden in geschweifte Klammern eingefasst und automatisch beim Erzeugen des Knotens ersetzt.
<br />Folgende Platzhalter stehen zur Verfügung:
<ul>
<li>{courseid}: Die (interne) ID des Kurses</li>
<li>{courseshortname}: Der Kurzname des Kurses</li>
<li>{editingtoggle}: Der Wert \'on\' oder \'off\' welcher benötigt wird, um den Bearbeiten-Modus an- und auszuschalten</li>
<li>{userid}: Die (interne) ID des angemeldeten Nutzers</li>
<li>{userusername}: Der Anmeldename des angemeldeten Nutzers</li>
<li>{pagecontextid}: Die Kontext-ID der aktuellen Seite</li>
<li>{pagepath}: Der URL Pfad der aktuellen Seite</li>
<li>{sesskey}: Der Sesskey zur Verwendung in abgesicherten URLs</li>
</ul>
</li>
<li>Falls der Knoten in der Navigation nicht erscheint, überprüfen Sie bitte, ob Sie alle Pflichtparameter korrekt gesetzt haben und ob dieser in der momentanen Nutzersprache bzw. globalen Gruppe (falls gesetzt) überhaupt angezeigt werden kann.</li>
<li>Aufgrund der Art und Weise wie die Navigation in Boost in Moodle gebaut ist, werden alle Knoten gleichartig angezeigt. Nicht möglich ist es, eigene CSS Klassen, IDs für HTML-Elemente oder ein Zielattribut zum Öffnen eines Links in einem neuen Fenster anzugeben.</li>
</ul>';
$string['setting_customnodesusagechildnodes'] = 'Eigene Knoten können mit einer Hierarchieebene verschachtelt werden. Dies bedeutet, dass ein benutzerdefinierter Knoten Kindknoten haben kann. Um einen Knoten als einen Kindknoten zu deklarieren, stellen Sie diesem einfach einen Bindestrich voran.<br/>
Zum Beispiel:<br/>
Administration|/admin/index.php<br />
-Nutzerliste|/admin/user.php<br />
-Kursverwaltung|/course/management.php<br /><br />
Bitte beachten Sie:
<ul>
<li>Aus technischen Gründen benötigt ein Elternknoten immer eine gültige URL, auch wenn der Knoten später zusammen geklappt werden soll.</li>
<li>Wenn ein Elternknoten aufgrund einer Beschränkung (Sprache, globale Gruppe oder Rolle) nicht angezeigt wird, werden seine Kindknoten auch nicht dargestellt.</li>
</ul>';
$string['setting_customnodesusageusers'] = 'Jede Zeile besteht aus einem Link-Titel, einer Link-URL, unterstützten Sprachen (optional), unterstützten globalen Gruppen (optional), unterstützten Rollen (optional), unterstützten globalen Rollen (optional), dem logischen Verknüpfungs-Operator (optional), einem Icon (optional), dem ID Attribut (optional) und einem \'Vor-diesem-Knoten Schlüssel\' (optional). Die einzelnen Elemente sind mit einem Trennzeichen ("|") separiert. Jeder Knoten steht in einer neuen Zeile.<br/><br/>
Beispiele:<br/>
Moodle|http://www.moodle.org|en,de<br />
Unsere Universität|http://www.our-university.edu<br />
Mathematische Fakultät|http://www.our-university.edu/math||math<br />
Handbuch für Trainer|http://www.our-university.edu/teacher-handbook|||editingteacher,teacher<br />
Informationen für Studenten|/course/view.php?id=1234||||||fa-graduation-cap<br />
{editingtoggle}|/course/view.php?id={courseid}&sesskey={sesskey}&edit={editingtoggle}|||editingteacher|admin,manager|OR|fa-pencil|editing|participants<br /><br />
Infos zu den Parametern:
<ul>
<li><b>Titel:</b> Dieser Text wird als anklickbare Beschriftung des Knotens angezeigt.</li>
<li><b>Link:</b> Das Linkziel muss eine vollständige URL (z.B. https://moodle.org) oder ein relativer Pfad innerhalb der Moodle Instanz (z.B. /login/logout.php) sein.</li>
<li><b>Unterstützte Sprachen (optional):</b> Der Knoten wird nur Nutzer/innen angezeigt, die die entsprechende Sprache eingestellt haben. Mehrere unterstütze Sprachen werden über Komma separiert. Um den Knoten in allen Sprachen anzuzeigen, lassen Sie dieses Feld leer.</li>
<li><b>Unterstützte globale Gruppen (optional):</b> Der Knoten wird nur Mitgliedern der hier angegebenen globalen Gruppen angezeigt. Nutzen Sie die Gruppen-ID, nicht den Namen. Mehrere globale Gruppen werden über Komma separiert. Um den Knoten allen Nutzer/innen unabhängig von globalen Gruppen anzuzeigen, lassen Sie dieses Feld einfach leer.</li>
<li><b>Unterstützte Rollen (optional):</b> Der Knoten wird nur Nutzer/innen mit bestimmten Rollen angezeigt. Nutzen Sie jeweils den Kurznamen der Rollen. Mehrere Rollen werden über Komma separiert. Um den Knoten allen Nutzer/innen unabhängig von Rollen anzuzeigen, lassen Sie dieses Feld einfach leer.</li>
<li><b>Unterstützte globale Rollen (optional):</b> Der Knoten wird nur Nutzer/innen mit bestimmten globalen Rollen angezeigt. Nutzen Sie jeweils den Kurznamen der globalen Rollen. Der Kurzname \'admin\' identifiziert die Administratoren. Mehrere Rollen werden über Komma separiert. Um den Knoten allen Nutzer/innen unabhängig von globalen Rollen anzuzeigen, lassen Sie dieses Feld einfach leer.</li>
<li><b>Logischer Verknüpfungs-Operator (optional):</b> Dieser Parameter kann dazu verwendet werden um die logische Verknüpfung der Parameter für globale Gruppen, Rollen und globale Rollen abzuändern. Wenn Sie diesen Parameter auf AND setzen oder ihn weglassen werden die Parameter für globale Gruppen, Rollen und globale Rollen mit AND logisch verknüpft und der Knoten wird nur sichtbar sein wenn ALLE Parameter zutreffen. Wenn Sie diesen Parameter auf OR setzen oder ihn weglassen werden die Parameter für globale Gruppen, Rollen und globale Rollen mit OR logisch verknüpft und der Knoten wird nur sichtbar sein wenn mindestens EINER der Parameter zutrifft. Dies gibt Ihnen die Flexibilität um einen Knoten zu erstellen, der beispielsweise Nutzern mit einer bestimmten Kursrolle als auch Nutzern mit einer bestimmten globalen Rolle angezeigt wird wie in unserem Beispiel oben angegeben.</li>
<li><b>Icon (optional):</b> Dieses Icon wird als Icon für den Knoten verwendet werden, z.B. fa-flag. Nutzen Sie den Font Awesome Icon Identifier (<a href="https://fontawesome.com/v4.7.0/icons/">Siehe Liste der Icons auf fontawesome.io</a>) um das zu nutzende Icon zu referenzieren. Font Awesome ist in Boost enthalten, klassische Moodle pix icons werden hier nicht unterstützt. Um den Knoten mit einem standardmäßigen Bullet Icon anzuzeigen, lassen Sie dieses Feld einfach leer.</li>
<li><b>ID Attribut (optional):</b> Dieser Parameter kann dazu verwendet werden um das ID Attribut eines Knotens auf den angegebenen Wert zu setzen. Der angegebene Wert wird von allen nicht-alphanumerischen Zeichen befreit und mit dem betreffenden Bereich eigener Knoten gepräfixed. Ein Knoten im Bereich eigener Knoten am Ende der Boost-Navigation mit dem Wert \'my_node\' würde dann ein ID Attribut mit dem Wert \'localboostnavigationcustombottomadminsmynode\' erhalten. Diese Einstellung gibt Ihnen die Möglichkeit, den Knoten in CSS Selektoren oder gar in eigenem JavaScript Code zu referenzieren. Das Setzen derselben ID für mehrere Knoten wird hier nicht verhindert, aber
 beachten Sie bitte dass in einer HTML Seite am Ende trotzdem eine ID nur einmal vorkommen sollte. Falls dieses Feld leer gelassen wird, wird der eigene Knoten eine automatisch erstellte ID erhalten, die nicht unbedingt als Referenz herangezogen werden kann.</li>
<li><b>\'Vor-diesem-Knoten Schlüssel\' (optional):</b> Dieser Parameter kann dazu verwendet werden um anzugeben vor welchem anderen Knoten ein Knoten eingefügt werden soll. Sie finden den Wert für diesen Parameter im \'data-key\' HTML Attribut des Knotens vor welchem Sie den Knoten einfügen möchten. Falls Sie eine Kombination bestehend aus einem Eltern- und einem oder mehreren Kind-Knoten vor einen anderen Knoten platzieren möchten, muss dieser Parameter für alle Knoten der Kombination angegeben werden.<br/>Bitte beachten Sie, dass Sie nur Knoten aus demselben Kontext wie der zu dem Sie den Knoten hinzufügen möchten referenzieren können. Zum Beispiel können Sie \'privatefiles\' oder \'calendar\' in der Boost-Hauptnavigation sowie \'participants\' oder \'grades\' in der Boost-Kursnavigation referenzieren. Falls der \'Vor-diesem-Knoten Schlüssel\' nicht gefunden oder aus anderen Gründen nicht verarbeitet werden kann, wird der Knoten am Ende der Navigation hinzugefügt.<br />Bitte beachten Sie auch, dass Sie mit diesem Parameter gegebenenfalls nicht alle anderen Knoten referenzieren können und der Parameter daher als teilweise experimentell angesehen werden muss.</li>
</ul>
Bitte beachten Sie:
<ul>
<li>Möchten Sie optionale Werte nicht nutzen, müssen Sie für diese Parameter trotzdem ein Trennungszeichen setzen, wenn sich die Option zwischen anderen Parametern befindet. Schauen Sie sich dazu das Beispiel für die mathematische Fakultät an.</li>
<li>Der angegebene Titel kann auch Platzhalter enthalten, z.B. {coursefullname} um einen Knoten zu erzeugen, der mit dem Namen des aktuellen Kurses beschriftet ist. Platzhalter werden in geschweifte Klammern eingefasst und automatisch beim Erzeugen des Knotens ersetzt.
<br />Folgende Platzhalter stehen zur Verfügung:
<ul>
<li>{coursefullname}: Der Langname des Kurses</li>
<li>{courseshortname}: Der Kurzname des Kurses</li>
<li>{editingtoggle}: Der Wert \'Bearbeiten einschalten\' oder \'Bearbeiten ausschalten\' des verwendeten Sprachpakets</li>
<li>{userfullname}: Der Name des angemeldeten Nutzers</li>
<li>{userusername}: Der Anmeldename des angemeldeten Nutzers</li>
</ul>
</li>
<li>Das angegebene Linkziel kann ebenfalls Platzhalter enthalten, z.B. /course/edit.php?id={courseid} um einen Knoten zu erzeugen, der auf die Einstellungen des aktuellen Kurses verlinkt. Platzhalter werden in geschweifte Klammern eingefasst und automatisch beim Erzeugen des Knotens ersetzt.
<br />Folgende Platzhalter stehen zur Verfügung:
<ul>
<li>{courseid}: Die (interne) ID des Kurses</li>
<li>{courseshortname}: Der Kurzname des Kurses</li>
<li>{editingtoggle}: Der Wert \'on\' oder \'off\' welcher benötigt wird, um den Bearbeiten-Modus an- und auszuschalten</li>
<li>{userid}: Die (interne) ID des angemeldeten Nutzers</li>
<li>{userusername}: Der Anmeldename des angemeldeten Nutzers</li>
<li>{pagecontextid}: Die Kontext-ID der aktuellen Seite</li>
<li>{pagepath}: Der URL Pfad der aktuellen Seite</li>
<li>{sesskey}: Der Sesskey zur Verwendung in abgesicherten URLs</li>
</ul>
</li>
<li>Falls der Knoten in der Navigation nicht erscheint, überprüfen Sie bitte, ob Sie alle Pflichtparameter korrekt gesetzt haben und ob dieser in der momentanen Nutzersprache bzw. globalen Gruppe (falls gesetzt) überhaupt angezeigt werden kann.</li>
<li>Aufgrund der Art und Weise wie die Navigation in Boost in Moodle gebaut ist, werden alle Knoten gleichartig angezeigt. Nicht möglich ist es, eigene CSS Klassen, IDs für HTML-Elemente oder ein Zielattribut zum Öffnen eines Links in einem neuen Fenster anzugeben.</li>
</ul>';
$string['setting_insertactivitiescoursenode'] = '"Aktivitäten"-Knoten hinzufügen';
$string['setting_insertactivitiescoursenode_desc'] = 'Durch Aktivieren dieser Einstellung fügen Sie einen "Abschnitte"-Knoten zur Boost-Kursnavigation hinzu, welcher wiederum Knoten enthält, die auf die Überseitsseiten der Aktivitäten verlinken. Dieser Knoten bringt im Prinzip die Funktionalität des "Aktivitäten" Blocks in die Boost-Hauptnavigation.';
$string['setting_insertbottomnodesheading'] = 'Eigene Knoten am Ende der Boost-Navigation einfügen';
$string['setting_insertcoursenodesheading'] = 'Knoten zur Boost-Kursnavigation hinzufügen';
$string['setting_insertcoursesectionscoursenode'] = '"Abschnitte"-Knoten hinzufügen';
$string['setting_insertcoursesectionscoursenodecorehint'] = 'Bitte beachten: Diese Einstellung funktioniert nur, wenn Sie die Einstellung <a href="{$a->url}">linkcoursesections</a> aktiviert haben. Falls Sie linkcoursesections nicht aktiviert haben, wird diese Einstellung ignoriert.';
$string['setting_insertcoursesectionscoursenode_desc'] = 'Durch Aktivieren dieser Einstellung fügen Sie einen "Abschnitte"-Knoten zur Boost-Kursnavigation hinzu, welcher oberhalb des ersten Abschnitts des aktuellen Kurses platziert wird.';
$string['setting_insertcustombottomnodesadmins'] = 'Eigene Endknoten für Administratoren einfügen';
$string['setting_insertcustombottomnodesadmins_desc'] = 'Mit dieser Einstellung können eigene Knoten am Ende der Boost Navigation hinzugefügt werden. Diese Knoten werden nach dem Hauptnavigationsabschnitt, vergleichbar zum Knoten "Webseiten-Administration" hinzugefügt.
Diese Knoten werden ausschließlich den Seitenadministratoren angezeigt.';
$string['setting_insertcustombottomnodesusers'] = 'Eigene Endknoten für Nutzer/innen einfügen';
$string['setting_insertcustombottomnodesusers_desc'] = 'Mit dieser Einstellung können eigene Knoten am Ende der Boost Navigation hinzugefügt werden. Diese Knoten werden nach dem Hauptnavigationsabschnitt, vergleichbar zum Knoten "Webseiten-Administration" hinzugefügt.
Diese Knoten werden allen Nutzer/innen angezeigt.';
$string['setting_insertcustomcoursenodesadmins'] = 'Eigene Kursknoten für Administratoren einfügen';
$string['setting_insertcustomcoursenodesadmins_desc'] = 'Mit dieser Einstellung können eigene Knoten zu der Boost Kursnavigation hinzugefügt werden. Diese Knoten werden nach dem letzten Kursknoten, höchstwahrscheinlich nach dem Knoten für den letzten Kursabschnitt, hinzugefügt. Diese Knoten werden ausschließlich den Seitenadministratoren angezeigt.';
$string['setting_insertcustomcoursenodesusers'] = 'Eigene Kursknoten für Nutzer/innen einfügen';
$string['setting_insertcustomcoursenodesusers_desc'] = 'Mit dieser Einstellung können eigene Knoten zu der Boost Kursnavigation hinzugefügt werden. Diese Knoten werden nach dem letzten Kursknoten, höchstwahrscheinlich nach dem Knoten für den letzten Kursabschnitt, hinzugefügt. Diese Knoten werden allen Nutzer/innen angezeigt.';
$string['setting_insertcustomnodesadmins'] = 'Eigene Hauptnavigationsknoten für Administrator/innen hinzufügen';
$string['setting_insertcustomnodesadmins_desc'] = 'Mit dieser Einstellung können eigene Knoten zu der Boost Hauptnavigation hinzugefügt werden. Diese Knoten werden am Ende des Hauptabschnitts hinzugefügt, höchstwahrscheinlich unter dem Knoten "Meine Kurse". Diese Knoten werden ausschließlich den Seitenadministratoren angezeigt.';
$string['setting_insertcustomnodesusers'] = 'Eigene Hauptnavigationsknoten für Nutzer/innen hinzufügen';
$string['setting_insertcustomnodesusers_desc'] = 'Mit dieser Einstellung können eigene Knoten zu der Boost Hauptnavigation hinzugefügt werden. Diese Knoten werden am Ende des Hauptabschnitts hinzugefügt, höchstwahrscheinlich unter dem Knoten "Meine Kurse". Diese Knoten werden allen Nutzer/innen angezeigt.';
$string['setting_insertnodescollapsehint'] = 'Bitte beachten Sie, dass dieser neu hinzugefügte Knoten mit einem Link hinterlegt ist, welcher auf die Kursstartseite verlinkt. Dies ist nötig, da Boost leider das Hinzufügen von Knoten ohne Link nicht unterstützt. Der Link wird, sobald Sie ebenfalls die Einstellung zum Zusammenklappen des Knoten aktivieren, wirkungslos sein.';
$string['setting_insertnodesheading'] = 'Eigene Hauptnavigationsknoten hinzufügen';
$string['setting_insertresourcescoursenode'] = '"Arbeitsmaterial"-Knoten hinzufügen';
$string['setting_insertresourcescoursenode_desc'] = 'Durch Aktivieren dieser Einstellung fügen Sie einen "Arbeitsmaterial"-Knoten zur Boost-Kursnavigation hinzu, welcher auf die Übersichtsseite für Arbeitsmaterial verlinkt.<br /><em>Diese Einstellung steht in Zusammenhang mit der Einstellung "\'Aktivitäten\'-Knoten hinzufügen". Wenn Sie beide Einstellungen aktivieren, erhalten Sie sowohl einen "Aktivitäten"- als auch einen "Arbeitsmaterial"-Knoten. Wenn Sie nur die "Aktivitäten"-Einstellung aktivieren, erhalten Sie, wird der "Aktivitäten"-Knoten auch einen Link zur Übersichtsseite für Arbeitsmaterial enthalten.</em>';
$string['setting_removebadgescoursenode'] = '"Auszeichnungen"-Knoten entfernen';
$string['setting_removebadgescoursenode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Auszeichnungen"-Knoten aus der Boost-Kursnavigation, falls im Kurs keine Auszeichnungen angelegt sind. Trainer/innen können weiterhin immer auf die Auszeichnungen über das Kursmenü (Zahnrad-Menü) zugreifen.<br /><em>Diese Einstellung wird nur verwendet, wenn das Subsystem für Auszeichnungen in Moodle auch aktiviert ist.</em>';
$string['setting_removecalendarnode'] = '"Kalender"-Knoten entfernen';
$string['setting_removecalendarnode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Kalender"-Knoten aus der Boost-Hauptnavigation.';
$string['setting_removecompetenciescoursenode'] = '"Kompetenzen"-Knoten entfernen';
$string['setting_removecompetenciescoursenode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Kompetenzen"-Knoten aus der Boost-Kursnavigation, falls im Kurs keine Kompetenzen angelegt sind. Für Trainer/innen wird ein neuer "Kompetenzen" Eintrag zum Kursmenü (Zahnrad-Menü) hinzugefügt.<br /><em>Diese Einstellung wird nur verwendet, wenn das Subsystem für Kompetenzen in Moodle auch aktiviert ist.</em>';
$string['setting_removecoursenodesheading'] = 'Knoten aus der Boost-Kursnavigation entfernen';
$string['setting_removecoursenodestechnicalhint'] = 'Aus technischer Sicht wird der Knoten entfernt, indem er aus dem Navigationsbaum gelöscht wird. Damit kann der Knoten nicht mehr von anderen Teilen in Moodle genutzt werden. Für normale Moodle Instanzen sollte dies jedoch nicht zu Problemen führen.';
$string['setting_removedashboardnode'] = '"Dashboard"-Knoten entfernen';
$string['setting_removedashboardnode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Dashboard"-Knoten aus der Boost-Hauptnavigation.';
$string['setting_removefirsthomenode'] = '"Startseite"- oder "Dashboard"-Knoten entfernen';
$string['setting_removefirsthomenode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Startseite"- oder "Dashboard"-Knoten, je nachdem welchen Knoten der Nutzer als seine Moodle Startseite eingestellt hat, aus der Boost-Hauptnavigation.';
$string['setting_removegradescoursenode'] = '"Bewertungen"-Knoten entfernen';
$string['setting_removegradescoursenode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Bewertungen"-Knoten aus der Boost-Kursnavigation. Er wird für alle Nutzer/innen entfernt, ungeachtet ob sie berechtigt wären den Knoten zu sehen und ungeachtet der Einstellung \'Bewertungen anzeigen\' in der Kurs-Administration.';
$string['setting_removehomenode'] = '"Startseite"-Knoten entfernen';
$string['setting_removehomenode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Startseite"-Knoten aus der Boost-Hauptnavigation.';
$string['setting_removemycoursesnode'] = '"Meine Kurse"-Knoten entfernen';
$string['setting_removemycoursesnode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Meine Kurse"-Knoten aus der Boost-Hauptnavigation.';
$string['setting_removemycoursesnodeperformancehint'] = 'Bitte beachten: Wenn Sie diese Einstellung aktivieren und gleichzeitig die Einstellung <a href="{$a->url}">navshowmycoursecategories</a> aktiviert ist, wird das Entfernen des "Meine Kurse"-Knoten mehr Zeit benötigen. Sie sollten in diesem Fall prüfen, ob Sie die Einstellung navshowmycoursecategories nicht deaktivieren können.';
$string['setting_removenodesheading'] = 'Knoten aus der Boost-Hauptnavigation entfernen';
$string['setting_removenodestechnicalhint'] = 'Aus technischer Sicht wird der Knoten entfernt, indem sein showinflatnavigation Attribut auf nein gesetzt wird. Damit wird der Knoten nur in der Boost-Hauptnavigation verborgen, er verbleibt aber im internen Navigationsbaum und kann weiterhin von anderen Teilen von Moodle genutzt werden.';
$string['setting_removeparticipantscoursenode'] = '"Teilnehmer/innen"-Knoten entfernen';
$string['setting_removeparticipantscoursenode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Teilnehmer/innen"-Knoten aus der Boost-Kursnavigation. Er wird für alle Nutzer/innen entfernt, ungeachtet ob sie berechtigt wären den Knoten zu sehen.';
$string['setting_removeprivatefilesnode'] = '"Meine Dateien"-Knoten entfernen';
$string['setting_removeprivatefilesnode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den "Meine Dateien"-Knoten aus der Boost-Hauptnavigation.';
$string['setting_removesecondhomenode'] = 'Zweiten "Startseite"- oder "Dashboard"-Knoten entfernen';
$string['setting_removesecondhomenode_desc'] = 'Durch Aktivieren dieser Einstellung entfernen Sie den zweiten "Startseite"- oder "Dashboard"-Knoten, je nachdem welchen Knoten der Nutzer nicht als seine Moodle Startseite eingestellt hat, aus der Boost-Hauptnavigation.';
$string['settingspage_bottomnodes'] = 'Knoten am Ende der Boost-Navigation';
$string['settingspage_coursenodes'] = 'Knoten in der Boost-Kursnavigation';
$string['settingspage_rootnodes'] = 'Knoten in der Boost-Hauptnavigation';
