<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'ru', branch 'MOODLE_36_STABLE'
 *
 * @package   competency
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Все дочерние компетенции выполнены';
$string['competencies'] = 'Компетенции';
$string['competenciesarenotenabled'] = 'Компетенции не включены.';
$string['competenciessettings'] = 'Настройки компетенций';
$string['completeplanstask'] = 'Выполнить учебные планы, по которым подошел срок';
$string['coursecompetencyoutcome_complete'] = 'Выполнить компетенцию';
$string['coursecompetencyoutcome_evidence'] = 'Прикрепить доказательство';
$string['coursecompetencyoutcome_none'] = 'Ничего не делать';
$string['coursecompetencyoutcome_recommend'] = 'Отправить на проверку';
$string['coursemodulecompetencyoutcome_complete'] = 'Выполнить компетенцию';
$string['coursemodulecompetencyoutcome_evidence'] = 'Прикрепить доказательство';
$string['coursemodulecompetencyoutcome_none'] = 'Ничего не делать';
$string['coursemodulecompetencyoutcome_recommend'] = 'Отправить на пересмотр';
$string['deletecompetencyratings'] = 'Удалить рейтинги компетенций';
$string['duplicateditemname'] = '{$a} (копия)';
$string['enablecompetencies'] = 'Включить компетенции';
$string['enablecompetencies_desc'] = 'Компетентности позволяют оценивать пользователей на соответствие требованиям учебных планов.';
$string['errorcannotchangeapastduedate'] = 'Срок выполнения прошел; он не может быть изменен.';
$string['errorcannotsetduedateinthepast'] = 'Срок выполнения не может быть задан в прошлом.';
$string['errorcannotsetduedatetoosoon'] = 'Срок выполнения наступит слишком быстро.';
$string['errorcompetencyrule'] = 'Неизвестное правило компетенции курса «{$a}»';
$string['errorcoursecompetencyrule'] = 'Неизвестное правило компетенции курса «{$a}»';
$string['errorinvalidcourse'] = 'Некорректный курс.';
$string['errornocompetency'] = 'Не удалось найти компетенцию «{$a}»';
$string['errorplanstatus'] = 'Неизвестный статус учебных планов «{$a}»';
$string['errorscalealreadyused'] = 'Шкала не может быть изменена, так как она уже используется.';
$string['errorscaleconfiguration'] = 'Шкала должна быть настроена путем выбора значения по умолчанию и значения владения компетенцией.';
$string['errorusercomptencystatus'] = 'Неизвестный статус компетенции пользователя «{$a}»';
$string['eventcompetencycreated'] = 'Компетенция создана.';
$string['eventcompetencydeleted'] = 'Компетенция удалена.';
$string['eventcompetencyframeworkcreated'] = 'Фреймворк компетенций создан.';
$string['eventcompetencyframeworkdeleted'] = 'Фреймворк компетенций удален.';
$string['eventcompetencyframeworkupdated'] = 'Фреймворк компетенций обновлен.';
$string['eventcompetencyframeworkviewed'] = 'Фреймворк компетенций просмотрен.';
$string['eventcompetencyupdated'] = 'Компетенция обновлена.';
$string['eventcompetencyviewed'] = 'Компетенция просмотрена.';
$string['eventevidencecreated'] = 'Доказательство создано.';
$string['eventplanapproved'] = 'Учебный план одобрен.';
$string['eventplancompleted'] = 'Учебный план выполнен.';
$string['eventplancreated'] = 'Учебный план создан.';
$string['eventplandeleted'] = 'Учебный план удален.';
$string['eventplanreopened'] = 'Учебный план открыт заново.';
$string['eventplanreviewrequestcancelled'] = 'Запрос на пересмотр учебного плана отклонен.';
$string['eventplanreviewrequested'] = 'Запрошен пересмотр учебного плана.';
$string['eventplanreviewstarted'] = 'Начат пересмотр учебного плана.';
$string['eventplanreviewstopped'] = 'Остановлен пересмотр учебного плана.';
$string['eventplanunapproved'] = 'Отменено одобрение учебного плана.';
$string['eventplanunlinked'] = 'Отменена связь учебного плана.';
$string['eventplanupdated'] = 'Учебный план обновлен.';
$string['eventplanviewed'] = 'Учебный план просмотрен.';
$string['eventtemplatecreated'] = 'Шаблон учебного плана создан.';
$string['eventtemplatedeleted'] = 'Шаблон учебного плана удален.';
$string['eventtemplateupdated'] = 'Шаблон учебного плана обновлен.';
$string['eventtemplateviewed'] = 'Шаблон учебного плана просмотрен.';
$string['eventusercompetencyplanviewed'] = 'Просмотрен план компетенций пользователя.';
$string['eventusercompetencyrated'] = 'Задан рейтинг компетенции пользователя.';
$string['eventusercompetencyratedincourse'] = 'Задан рейтинг компетенции пользователя в курсе.';
$string['eventusercompetencyratedinplan'] = 'Задан рейтинг компетенции пользователя в учебном плане.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Запрос на пересмотр компетенции пользователя отклонен.';
$string['eventusercompetencyreviewrequested'] = 'Запрошен пересмотр компетенции пользователя.';
$string['eventusercompetencyreviewstarted'] = 'Начат пересмотр компетенции пользователя.';
$string['eventusercompetencyreviewstopped'] = 'Остановлен пересмотр компетенции пользователя.';
$string['eventusercompetencyviewed'] = 'Просмотрена компетенция пользователя.';
$string['eventusercompetencyviewedincourse'] = 'Просмотрена компетенция пользователя в курсе.';
$string['eventusercompetencyviewedinplan'] = 'Просмотрена компетенция пользователя в учебном плане.';
$string['eventuserevidencecreated'] = 'Создано доказательство предыдущего обучения.';
$string['eventuserevidencedeleted'] = 'Удалено доказательство предыдущего обучения.';
$string['eventuserevidenceupdated'] = 'Обновлено доказательство предыдущего обучения.';
$string['evidence_competencyrule'] = 'Выполнены требования правила компетенции.';
$string['evidence_coursecompleted'] = 'Курс «{$a}» завершен.';
$string['evidence_coursemodulecompleted'] = 'Элемент «{$a}» завершен.';
$string['evidence_courserestored'] = 'Рейтинг был восстановлен вместе с курсом «{$a}».';
$string['evidence_evidenceofpriorlearninglinked'] = 'Доказательство предыдущего обучения «{$a}» было привязано.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Отменена связь доказательства предыдущего обучения «{$a}».';
$string['evidence_manualoverride'] = 'Рейтинг компетенции был задан вручную.';
$string['evidence_manualoverrideincourse'] = 'Рейтинг компетенции был задан вручную для курса «{$a}».';
$string['evidence_manualoverrideinplan'] = 'Рейтинг компетенции был задан вручную для учебного плана «{$a}».';
$string['invalidevidencedesc'] = 'Неправильное описание доказательства';
$string['invalidgrade'] = 'Неправильный рейтинг';
$string['invalidpersistenterror'] = 'Ошибка: {$a}';
$string['invalidplan'] = 'Неправильный учебный план';
$string['invalidtaxonomy'] = 'Неправильная таксономия: {$a}';
$string['invalidurl'] = 'Проверьте адрес! Он должен начинаться с «http://» или  «https://».';
$string['planstatusactive'] = 'Активно';
$string['planstatuscomplete'] = 'Выполнено';
$string['planstatusdraft'] = 'Черновик';
$string['planstatusinreview'] = 'Проверяется';
$string['planstatuswaitingforreview'] = 'Ожидание отзыва';
$string['pointsrequiredaremet'] = 'Набраны необходимые баллы';
$string['privacy:evidence:action:complete'] = 'Выполнить компетенцию, если не задан рейтинг';
$string['privacy:evidence:action:log'] = 'Ведение журнала действий';
$string['privacy:evidence:action:override'] = 'Переопределить рейтинг компетенции';
$string['privacy:metadata:competency'] = 'Запись компетенций';
$string['privacy:metadata:competency_coursecomp'] = 'Запись компетенций, связанных с курсом';
$string['privacy:metadata:competency_coursecompsetting'] = 'Запись настроек компетенций в курсе';
$string['privacy:metadata:competency_evidence'] = 'Запись доказательств, влияющих на состояние компетенции';
$string['privacy:metadata:competency_framework'] = 'Запись фреймворков кометенций';
$string['privacy:metadata:competency_modulecomp'] = 'Запись компетенций, связанных с модулем';
$string['privacy:metadata:competency_plan'] = 'Запись учебных планов';
$string['privacy:metadata:competency_plancomp'] = 'Запись компетенций в учебный план';
$string['privacy:metadata:competency_relatedcomp'] = 'Запись отношений между компетенциями';
$string['privacy:metadata:competency_template'] = 'Запись шаблонов учебных планов';
$string['privacy:metadata:competency_templatecohort'] = 'Запись глобальных групп, связанных с шаблоном учебного плана';
$string['privacy:metadata:competency_templatecomp'] = 'Запись компетенций в шаблон учебного плана';
$string['privacy:metadata:competency_usercomp'] = 'Запись состояния компетенций пользователя';
$string['privacy:metadata:competency_usercompcourse'] = 'Запись состояния компетенций пользователя в курсе';
$string['privacy:metadata:competency_usercompplan'] = 'Запись состояния компетенций пользователя в учебном плане';
$string['privacy:metadata:competency_userevidence'] = 'Запись доказательств предыдущего обучения';
$string['privacy:metadata:competency_userevidencecomp'] = 'Запись компетенций, связанных с доказательством предыдущего обучения';
$string['privacy:metadata:core_comments'] = 'Комментарии, сделанные к учебным планам и компетенциям';
$string['privacy:metadata:evidence:action'] = 'Тип предпринятых действий с доказательствами';
$string['privacy:metadata:evidence:actionuserid'] = 'Пользователь, выполнивший действие';
$string['privacy:metadata:evidence:desca'] = 'Необязательные параметры описания переводимого доказательства';
$string['privacy:metadata:evidence:desccomponent'] = 'Компонент описания переводимого доказательства';
$string['privacy:metadata:evidence:descidentifier'] = 'Идентификатор описания переводимого доказательства';
$string['privacy:metadata:evidence:grade'] = 'Оценка, связанная с доказательством';
$string['privacy:metadata:evidence:note'] = 'Не переведенная заметка, прикрепленная к доказательству';
$string['privacy:metadata:evidence:url'] = 'URL, связанный с доказательством';
$string['privacy:metadata:plan:description'] = 'Описание учебного плана';
$string['privacy:metadata:plan:duedate'] = 'Срок выполнения учебного плана';
$string['privacy:metadata:plan:name'] = 'Название учебного плана';
$string['privacy:metadata:plan:reviewerid'] = 'ID пользователя, пересматривающего учебный план';
$string['privacy:metadata:plan:status'] = 'Статус учебного плана';
$string['privacy:metadata:plan:userid'] = 'ID пользователя-владельца учебного плана';
$string['privacy:metadata:timecreated'] = 'Дата создания записи';
$string['privacy:metadata:timemodified'] = 'Дата редактирования записи';
$string['privacy:metadata:usercomp:grade'] = 'Оценка, выставленная за компетенцию';
$string['privacy:metadata:usercomp:proficiency'] = 'Достигнуто ли умение';
$string['privacy:metadata:usercomp:reviewerid'] = 'ID пользователя, занимавшегося пересмотром';
$string['privacy:metadata:usercomp:status'] = 'Статус компетенции';
$string['privacy:metadata:usercomp:userid'] = 'ID пользователя-обладателя компетенции';
$string['privacy:metadata:userevidence:description'] = 'Описание доказательства';
$string['privacy:metadata:userevidence:name'] = 'Название доказательства предыдущего обучения';
$string['privacy:metadata:userevidence:url'] = 'URL, связанный с доказательством';
$string['privacy:metadata:usermodified'] = 'Пользователь, создавший или изменивший запись';
$string['privacy:path:plans'] = 'Учебные планы';
$string['privacy:path:relatedtome'] = 'Относящиеся ко мне';
$string['privacy:path:userevidence'] = 'Доказательства предыдущего обучения';
$string['pushcourseratingstouserplans'] = 'Передавать оценки курсов в индивидуальные учебные планы';
$string['pushcourseratingstouserplans_desc'] = 'Значение по умолчанию для настройки курса при обновлении индивидуальных учебных планов если оценены компетентности курса.';
$string['syncplanscohorts'] = 'Синхронизировать планы из глобальных групп шаблонов учебных планов';
$string['taxonomy_behaviour'] = 'Поведение';
$string['taxonomy_competency'] = 'Компетенция';
$string['taxonomy_concept'] = 'Концепт';
$string['taxonomy_domain'] = 'Отрасль';
$string['taxonomy_indicator'] = 'Индикатор';
$string['taxonomy_level'] = 'Уровень';
$string['taxonomy_outcome'] = 'Результат';
$string['taxonomy_practice'] = 'Практика';
$string['taxonomy_proficiency'] = 'Умение';
$string['taxonomy_skill'] = 'Навык';
$string['taxonomy_value'] = 'Ценность';
$string['usercommentedonacompetency'] = '{$a->fullname} оставил(а) комментарий к компетенции «{$a->competency}»:

{$a->comment}

Смотрите: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} оставил(а) комментарий к компетенции «{$a->competency}»:</p>
<div>{$a->comment}</div>
<p>Смотрите: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} оставил(а) комментарий к компетенции «{$a->competency}».';
$string['usercommentedonacompetencysubject'] = '{$a} оставил(а) комментарий к компетенции.';
$string['usercommentedonaplan'] = '{$a->fullname} оставил(а) комментарий к учебному плану «{$a->plan}»:

{$a->comment}

Смотрите: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} оставил(а) комментарий к учебному плану «{$a->plan}»:</p>
<div>{$a->comment}</div>
<p>Смотрите: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} оставил(а) комментарий к учебному плану «{$a->plan}».';
$string['usercommentedonaplansubject'] = '{$a} оставил(а) комментарий к учебному плану.';
$string['usercompetencystatus_idle'] = 'Не используется';
$string['usercompetencystatus_inreview'] = 'В процессе пересмотра';
$string['usercompetencystatus_waitingforreview'] = 'Ожидает пересмотра';
$string['userplans'] = 'Учебные планы';
