<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'es_mx', branch 'MOODLE_36_STABLE'
 *
 * @package   competency
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Todos los hijos están completos';
$string['competencies'] = 'Competencias';
$string['competenciesarenotenabled'] = 'Las competencias no están habilitadas.';
$string['competenciessettings'] = 'Configuraciones de competencias';
$string['completeplanstask'] = 'Planes de aprendizaje completos que están en fecha prometida';
$string['coursecompetencyoutcome_complete'] = 'Completar la competencia';
$string['coursecompetencyoutcome_evidence'] = 'Anexar evidencia';
$string['coursecompetencyoutcome_none'] = 'No hacer nada';
$string['coursecompetencyoutcome_recommend'] = 'Mandar a revisar';
$string['coursemodulecompetencyoutcome_complete'] = 'Completar la competencia';
$string['coursemodulecompetencyoutcome_evidence'] = 'Anexar evidencia';
$string['coursemodulecompetencyoutcome_none'] = 'No hacer nada';
$string['coursemodulecompetencyoutcome_recommend'] = 'Mandar a revisar';
$string['deletecompetencyratings'] = 'Eliminar valoraciones de competencia';
$string['duplicateditemname'] = '{$a} (copiar)';
$string['enablecompetencies'] = 'Habilitar competencias';
$string['enablecompetencies_desc'] = 'Las competencias le permiten a los usuarios que sean evaluados de acuerdo a planes de aprendizaje.';
$string['errorcannotchangeapastduedate'] = 'La fecha prometida ha pasado, no puede cambiarse.';
$string['errorcannotsetduedateinthepast'] = 'La fecha prometida no puede configurarse en el pasado.';
$string['errorcannotsetduedatetoosoon'] = 'La fecha prometida es demasiado pronto.';
$string['errorcompetencyrule'] = 'Regla de competencia del curso \'{$a}\' desconocida';
$string['errorcoursecompetencyrule'] = 'Regla de competencia del curso \'{$a}\' desconocida';
$string['errorinvalidcourse'] = 'Curso inválido.';
$string['errornocompetency'] = 'la competencia {$a} no puede encontrarse';
$string['errorplanstatus'] = 'Planes de aprendizaje \'{$a}\' estatus desconocido';
$string['errorscalealreadyused'] = 'La escala no puede cambiarse, porque ya está en uso.';
$string['errorscaleconfiguration'] = 'La escala necesita configurarse al seleccionar los ítems por defecto y dominado.';
$string['errorusercomptencystatus'] = 'Estatus de competencia del usuario \'{$a}\' desconocido';
$string['eventcompetencycreated'] = 'Competencia creada.';
$string['eventcompetencydeleted'] = 'Competencia eliminada.';
$string['eventcompetencyframeworkcreated'] = 'Estructura de competencia creada.';
$string['eventcompetencyframeworkdeleted'] = 'Estructura de competencia eliminada.';
$string['eventcompetencyframeworkupdated'] = 'Estructura de competencia actualizada.';
$string['eventcompetencyframeworkviewed'] = 'Estructura de competencia vista.';
$string['eventcompetencyupdated'] = 'Competencia actualizada.';
$string['eventcompetencyviewed'] = 'ompetencia vista.';
$string['eventevidencecreated'] = 'Evidencia creada.';
$string['eventplanapproved'] = 'Plan de aprendizaje aprobado.';
$string['eventplancompleted'] = 'Plan de aprendizaje completao.';
$string['eventplancreated'] = 'Plan de aprendizaje creado.';
$string['eventplandeleted'] = 'Plan de aprendizaje eliminado.';
$string['eventplanreopened'] = 'Plan de aprendizaje reabierto.';
$string['eventplanreviewrequestcancelled'] = 'Solicitud cancelada para revisión de Plan de aprendizaje.';
$string['eventplanreviewrequested'] = 'Revisión de Plan de aprendizaje solicitada.';
$string['eventplanreviewstarted'] = 'Revisión de Plan de aprendizaje iniciada.';
$string['eventplanreviewstopped'] = 'Revisión de Plan de aprendizaje detenida.';
$string['eventplanunapproved'] = 'Plan de aprendizaje no-aprobado.';
$string['eventplanunlinked'] = 'Plan de aprendizaje  des-ligado.';
$string['eventplanupdated'] = 'Plan de aprendizaje actualizado.';
$string['eventplanviewed'] = 'Plan de aprendizaje visto';
$string['eventtemplatecreated'] = 'Plantilla de Plan de aprendizaje creada.';
$string['eventtemplatedeleted'] = 'Plantilla de Plan de aprendizaje eliminada.';
$string['eventtemplateupdated'] = 'Plantilla de Plan de aprendizaje actualizada.';
$string['eventtemplateviewed'] = 'Plantilla de Plan de aprendizaje vista.';
$string['eventusercompetencyplanviewed'] = 'Plan de competencia del usuario visto.';
$string['eventusercompetencyrated'] = 'Competencia del usuario valorada.';
$string['eventusercompetencyratedincourse'] = 'Competencia del usuario valorada en curso.';
$string['eventusercompetencyratedinplan'] = 'Competencia del usuario valorada en un plan de aprendizaje.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Solicitud de revisión de competencia del usuario cancelada.';
$string['eventusercompetencyreviewrequested'] = 'Revisión de competencia del usuario solicitada.';
$string['eventusercompetencyreviewstarted'] = 'Revisión de competencia del usuario iniciada.';
$string['eventusercompetencyreviewstopped'] = 'Revisión de competencia del usuario detenida.';
$string['eventusercompetencyviewed'] = 'Competencia del usuario vista.';
$string['eventusercompetencyviewedincourse'] = 'Competencia del usuario vista en un curso.';
$string['eventusercompetencyviewedinplan'] = 'Competencia del usuario vista en un plan de aprendizaje.';
$string['eventuserevidencecreated'] = 'Evidencia de aprendizaje previo creada.';
$string['eventuserevidencedeleted'] = 'Evidencia de aprendizaje previo eliminada.';
$string['eventuserevidenceupdated'] = 'Evidencia de aprendizaje previo actualizada.';
$string['evidence_competencyrule'] = 'Se cumplió la regla de la competencia.';
$string['evidence_coursecompleted'] = 'El curso \'{$a}\' fue completado.';
$string['evidence_coursemodulecompleted'] = 'La actividad \'{$a}\' fue completada.';
$string['evidence_courserestored'] = 'La valoración fue restaurada junto con el curso \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'La evidencia de aprendizaje previo \'{$a}\' fue enlazada.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'La evidencia de aprendizaje previo \'{$a}\' fue des-enlazada.';
$string['evidence_manualoverride'] = 'La valoración de competencia fue configurada manualmente.';
$string['evidence_manualoverrideincourse'] = 'La valoración de competencia fue configurada manualmente en el curso \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'La valoración de competencia fue configurada manualmente en el plan de aprendizaje \'{$a}\'.';
$string['invalidevidencedesc'] = 'Descripción de evidencia inválida';
$string['invalidgrade'] = 'Valoración inválida';
$string['invalidpersistenterror'] = 'Error: {$a}';
$string['invalidplan'] = 'Plan de aprendizaje inválido';
$string['invalidtaxonomy'] = 'Taxonomía inválida: {$a}';
$string['invalidurl'] = 'La URL no es válida. Asegúrese de que comienza con  \'http://\' o \'https://\'.';
$string['planstatusactive'] = 'Activa/o';
$string['planstatuscomplete'] = 'Completo';
$string['planstatusdraft'] = 'Borrador';
$string['planstatusinreview'] = 'En revisión';
$string['planstatuswaitingforreview'] = 'Esperando para revisión';
$string['pointsrequiredaremet'] = 'Se cumplieron los puntos requeridos';
$string['privacy:evidence:action:complete'] = 'Completar competencia si fuera no_valorada';
$string['privacy:evidence:action:log'] = 'Guardar acción en bitácora';
$string['privacy:evidence:action:override'] = 'Anular valoración de competencia';
$string['privacy:metadata:competency'] = 'Un registro de las competencias';
$string['privacy:metadata:competency_coursecomp'] = 'Un registro de las competencias enlazadas a un curso';
$string['privacy:metadata:competency_coursecompsetting'] = 'Un registro de las configuraciones de las competencias en un curso';
$string['privacy:metadata:competency_evidence'] = 'Un registro de la evidencia que afecta un estado de competencia';
$string['privacy:metadata:competency_framework'] = 'Un registro de las estructuras de competencia';
$string['privacy:metadata:competency_modulecomp'] = 'Un registro de las competencias enlazadas a un módulo';
$string['privacy:metadata:competency_plan'] = 'Un registro de los planes de aprendizaje';
$string['privacy:metadata:competency_plancomp'] = 'Un registro de las competencias en un plan de aprendizaje';
$string['privacy:metadata:competency_relatedcomp'] = 'Un registro de las relaciones entre las competencias';
$string['privacy:metadata:competency_template'] = 'Un registro de las plantillas de los planes de aprendizaje';
$string['privacy:metadata:competency_templatecohort'] = 'Un registro de las cohortes asociadas con una plantilla de plan de aprendizaje';
$string['privacy:metadata:competency_templatecomp'] = 'Un registro de las competencias en una plantilla de plan de aprendizaje';
$string['privacy:metadata:competency_usercomp'] = 'Un registro del estado de las competencias del usuario';
$string['privacy:metadata:competency_usercompcourse'] = 'Un registro del estado de las competencias del usuario en un curso';
$string['privacy:metadata:competency_usercompplan'] = 'Un registro del estado de las competencias del usuario en un plan de aprendizaje';
$string['privacy:metadata:competency_userevidence'] = 'Un registro de la evidencia de aprendizaje previo';
$string['privacy:metadata:competency_userevidencecomp'] = 'Un registro de las competencias asociadas con evidencia de aprendizaje previo';
$string['privacy:metadata:core_comments'] = 'Comentarios hechos en planes de aprendizaje y competencias';
$string['privacy:metadata:evidence:action'] = 'El tipo de acción tomada con la evidencia';
$string['privacy:metadata:evidence:actionuserid'] = 'El usuario que realiza la acción';
$string['privacy:metadata:evidence:desca'] = 'Los parámetros opcionales de la descripción de la evidencia traducible';
$string['privacy:metadata:evidence:desccomponent'] = 'El componente de la descripción de evidencia traducible';
$string['privacy:metadata:evidence:descidentifier'] = 'Un identificador de la descripción de evidencia traducible';
$string['privacy:metadata:evidence:grade'] = 'La calificación asociada con la evidencia';
$string['privacy:metadata:evidence:note'] = 'Una anotación no-localizada anexada a la evidencia';
$string['privacy:metadata:evidence:url'] = 'Una URL asociada con la evidencia';
$string['privacy:metadata:plan:description'] = 'La descripción del plan de aprendizaje';
$string['privacy:metadata:plan:duedate'] = 'La fecha esperada del plan de aprendizaje';
$string['privacy:metadata:plan:name'] = 'El nombre del plan de aprendizaje';
$string['privacy:metadata:plan:reviewerid'] = 'La ID del revisor del plan de aprendizaje';
$string['privacy:metadata:plan:status'] = 'El estado del plan de aprendizaje';
$string['privacy:metadata:plan:userid'] = 'La ID del usuario de quien es el plan de aprendizaje';
$string['privacy:metadata:timecreated'] = 'El momento en el cual fue creado el registro';
$string['privacy:metadata:timemodified'] = 'El momento en el cual fue editado el registro';
$string['privacy:metadata:usercomp:grade'] = 'La calificación dada para la competencia';
$string['privacy:metadata:usercomp:proficiency'] = 'Si se logró la maestría/pericia/dominio';
$string['privacy:metadata:usercomp:reviewerid'] = 'La Id del revisor';
$string['privacy:metadata:usercomp:status'] = 'El estado de la competencia';
$string['privacy:metadata:usercomp:userid'] = 'La ID del usuario de quien es la competencia';
$string['privacy:metadata:userevidence:description'] = 'La descripción de la evidencia';
$string['privacy:metadata:userevidence:name'] = 'El nombre de la evidencia del aprendizaje previo';
$string['privacy:metadata:userevidence:url'] = 'Una URL asociada con la evidencia';
$string['privacy:metadata:usermodified'] = 'El usuario que creó o modificó el registro';
$string['privacy:path:plans'] = 'Planes de aprendizaje';
$string['privacy:path:relatedtome'] = 'Relacionado conmigo';
$string['privacy:path:userevidence'] = 'Evidencia de aprendizaje anterior';
$string['pushcourseratingstouserplans'] = 'Empujar valoraciones de cursos a planes de aprendizaje individuales';
$string['pushcourseratingstouserplans_desc'] = 'Valor por defecto para la configuración del curso de actualizar los planes de aprendizaje individuales cuando son valoradas las competencias del curso.';
$string['syncplanscohorts'] = 'Sincronizar planes desde cohortes de plantilla de plan de aprendizaje';
$string['taxonomy_behaviour'] = 'Comportamiento';
$string['taxonomy_competency'] = 'Competencia';
$string['taxonomy_concept'] = 'Concepto';
$string['taxonomy_domain'] = 'Dominio';
$string['taxonomy_indicator'] = 'Indicador';
$string['taxonomy_level'] = 'Nivel';
$string['taxonomy_outcome'] = 'Resultado';
$string['taxonomy_practice'] = 'Práctica';
$string['taxonomy_proficiency'] = 'Pericia/dominio/maestría';
$string['taxonomy_skill'] = 'Habilidad';
$string['taxonomy_value'] = 'Valor';
$string['usercommentedonacompetency'] = '{$a->fullname} comentó acerca de la competencia "{$a->competency}":

{$a->comment}

Vea: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} comentó sobre la competencia "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Vea: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} comentó sobre la competencia "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} comentó sobre una competencia.';
$string['usercommentedonaplan'] = '{$a->fullname} comentó sobre el plan de aprendizaje "{$a->plan}":

{$a->comment}

Vea: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} comentó sobre el plan de aprendizaje "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Vea: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} comentó sobre el plan de aprendizaje  "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} comentó sobre un plan de aprendizaje.';
$string['usercompetencystatus_idle'] = 'desocupado';
$string['usercompetencystatus_inreview'] = 'En revisión';
$string['usercompetencystatus_waitingforreview'] = 'Esperando para revisión';
$string['userplans'] = 'Planes de aprendizaje';
