<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'sr_cr', branch 'MOODLE_36_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Изнад';
$string['activitynavigationposition'] = 'Позиција навигације за активности';
$string['activitynavigationpositiondesc'] = 'Изаберите између опција \'Изнад\' и \'Испод\', где \'Изнад\' значи да се навигација налази изнад активности, док \'Испод\' подразумева да се навигација налази испод активности. Ако желите да користите прилагођени CSS онда употребите селектор \'#activitynavigation\'.';
$string['advert_alttext'] = 'Theme Design Level 1 рекламни банер';
$string['advert_heading'] = 'Theme Design Level 1';
$string['advert_tagline'] = 'Ако желите да научите како да прилагодите тему, али немате искуство са PHP-ом или развојем Moodle тема, онда је \'MoodleBites Theme Design Level 1\' за вас! Он ће вам дати једноставан увод у развој Moodle тема и пружити добру основу ако будете хтели да наставите даље. Кликните овде за више информација.';
$string['aftercontent'] = 'Након садржаја';
$string['alert1'] = 'Прво важно обавештење';
$string['alert2'] = 'Друго важно обавештење';
$string['alert3'] = 'Треће важно обавештење';
$string['alert_edit'] = 'Уреди важна обавештења';
$string['alert_general'] = 'Најава';
$string['alert_info'] = 'Информације';
$string['alertinfodesc'] = 'Унесите подешавања за ваше важно обавештење.';
$string['alertsdesc'] = 'Ово ће вашим корисницима приказати важно обавештење/а на насловној страници Moodlea. Немојте заборавите да их искључите када вам више нису потребна.';
$string['alertsheading'] = 'Важно обавештење корисницима';
$string['alertsheadingsub'] = 'Прикажите важне поруке вашим корисницима на насловној страници';
$string['alerttext'] = 'Текст важног обавештењa';
$string['alerttextdesc'] = 'Како гласи текст који желите да прикажете у важном обавештењу.';
$string['alerttitle'] = 'Наслов';
$string['alerttitledesc'] = 'Главни наслов вашег важног обавештењa.';
$string['alerttype'] = 'Ниво';
$string['alerttypedesc'] = 'Подесите одговарајући ниво/тип важног обавештењa како бисте најбоље информисали своје кориснике.';
$string['alert_warning'] = 'Упозорење';
$string['allclasses'] = 'Сви часови';
$string['allcourses'] = 'Сви курсеви';
$string['allmodules'] = 'Сви модули';
$string['allunits'] = 'Све јединице';
$string['alternativecolors'] = 'Алтернативне боје {$a}';
$string['alternativethemecolor'] = 'Алтернативна боја теме {$a}';
$string['alternativethemecolordesc'] = 'Које боје треба да буде ваша тема за алтернативне боје теме {$a}.';
$string['alternativethemecolorname'] = 'Назив алтернативног скупа боја {$a}';
$string['alternativethemecolornamedesc'] = 'Унесите препознатљив назив за овај скуп алтернативних боја теме';
$string['alternativethemecolors'] = 'Алтернативне боје теме';
$string['alternativethemecolorsdesc'] = 'Дефинише алтернативне боје теме које корисник може да изабере.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Боја позадине стандардног дугмета {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Подесите боју позадине за сву стандардну дугмад {$a}.';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'Лебдећа боја позадине стандардног дугмета {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'Подесите лебдећу боју позадине за сву стандардну дугмад {$a}.';
$string['alternativethemedefaultbuttontextcolour'] = 'Боја текста стандардног дугмета {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Подесите боју текста за сву стандардну дугмад {$a}.';
$string['alternativethemedefaultbuttontexthovercolour'] = 'Лебдећа боја текста стандардног дугмета {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'Подесите лебдећу боју текста за сву стандардну дугмад {$a}.';
$string['alternativethemefooterblockbackgroundcolour'] = 'Боја позадине блока подножја за алтернативне боје теме {$a}';
$string['alternativethemefooterblockbackgroundcolourdesc'] = 'Подесите боју за позадину блока у подножју странице за алтернативне боје теме {$a}.';
$string['alternativethemefooterblockhovercolour'] = 'Лебдећа боја линка блока подножја за алтернативне боје теме {$a}';
$string['alternativethemefooterblockhovercolourdesc'] = 'Подесите боју за текст линкова блока у подножју странице када се мишем пређе преко њих за алтернативне боје теме {$a}.';
$string['alternativethemefooterblocktextcolour'] = 'Боја текста блока подножја за алтернативне боје теме {$a}';
$string['alternativethemefooterblocktextcolourdesc'] = 'Подесите боју текста блока у подножју странице за алтернативне боје теме {$a}.';
$string['alternativethemefooterblockurlcolour'] = 'Боја линка блока подножја за алтернативне боје теме {$a}';
$string['alternativethemefooterblockurlcolourdesc'] = 'Подесите боју за текст линкова блока у подножју странице за алтернативне боје теме {$a}.';
$string['alternativethemefootercolor'] = 'Боја позадине подножја странице за алтернативне боје теме {$a}';
$string['alternativethemefootercolordesc'] = 'Подесите које боје треба да буде подножје странице за алтернативне боје теме {$a}.';
$string['alternativethemefooterheadingcolor'] = 'Боја заглавља подножја странице за алтернативне боје теме {$a}';
$string['alternativethemefooterheadingcolordesc'] = 'Подесите боју за заглавље подножја странице за алтернативне боје теме {$a}.';
$string['alternativethemefooterhovercolor'] = 'Лебдећа боја линка подножја за алтернативне боје теме {$a}';
$string['alternativethemefooterhovercolordesc'] = 'Подесите боју за текст линкова у подножју странице када се мишем пређе преко њих за алтернативне боје теме {$a}.';
$string['alternativethemefootersepcolor'] = 'Боја граничника подножја за алтернативне боје теме {$a}.';
$string['alternativethemefootersepcolordesc'] = 'Граничници су линије које се користе за раздвајање садржаја. Подесите овде њихову боју за алтернативне боје теме {$a}.';
$string['alternativethemefootertextcolor'] = 'Боја текста подножја за алтернативне боје теме {$a}.';
$string['alternativethemefootertextcolordesc'] = 'Подесите боју текста у подножју странице за алтернативне боје теме {$a}.';
$string['alternativethemefooterurlcolor'] = 'Боја линка подножја за алтернативне боје теме {$a}.';
$string['alternativethemefooterurlcolordesc'] = 'Подесите боју за текст линкова у подножју странице за алтернативне боје теме {$a}.';
$string['alternativethemehovercolor'] = 'Алтернативна лебдећа боја теме {$a}';
$string['alternativethemehovercolordesc'] = 'Која боје треба да буде лебдећа боја у вашој теми за алтернативне боје теме {$a}.';
$string['alternativethemeiconcolor'] = 'Алтернативна боја иконице {$a}';
$string['alternativethemeiconcolordesc'] = 'Подесите алтернативну боју {$a} за све иконице.';
$string['alternativethememycoursesorderenrolbackcolour'] = 'Алтернативна боја позадине {$a} за уписане курсеве којима корисник још није приступио';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = 'Подесите алтернативну боју позадине {$a} за уписане курсеве којима корисник још није приступио, када је \'Редослед сортирања курсева\' подешен на \'Време последњег приступа...\'';
$string['alternativethemename'] = 'Назив шеме боја';
$string['alternativethemenamedesc'] = 'Унесите назив за ваше алтернативне боје теме';
$string['alternativethemenavcolor'] = 'Боја текста у траци за навигацију {$a}';
$string['alternativethemenavcolordesc'] = 'Подесите алтернативну боју {$a} за текст у траци за навигацију.';
$string['alternativethemequizsubmitbackgroundcolour'] = 'Боја позадине дугмета \'Предај све одговоре и заврши тест\' {$a}';
$string['alternativethemequizsubmitbackgroundcolourdesc'] = 'Подесите алтернативну боју {$a} позадине за дугме \'Предај све одговоре и заврши тест\'.';
$string['alternativethemequizsubmitbackgroundhovercolour'] = 'Лебдећа боја позадине дугмета \'Предај све одговоре и заврши тест\' {$a}';
$string['alternativethemequizsubmitbackgroundhovercolourdesc'] = 'Подесите алтернативну лебдећу боју {$a} позадине за дугме \'Предај све одговоре и заврши тест\'.';
$string['alternativethemequizsubmittextcolour'] = 'Боја текста дугмета \'Предај све одговоре и заврши тест\' {$a}';
$string['alternativethemequizsubmittextcolourdesc'] = 'Подесите алтернативну боју текста {$a} за дугме \'Предај све одговоре и заврши тест\'.';
$string['alternativethemequizsubmittexthovercolour'] = 'Лебдећа боја текста дугмета \'Предај све одговоре и заврши тест\' {$a}';
$string['alternativethemequizsubmittexthovercolourdesc'] = 'Подесите алтернативну лебдећу боју текста {$a} за дугме \'Предај све одговоре и заврши тест\'.';
$string['alternativethemesidepreblockbackgroundcolour'] = 'Алтернативна {$a} боја позадине блока с леве стране';
$string['alternativethemesidepreblockbackgroundcolourdesc'] = 'Подесите алтернативну {$a} боју позадине за блок с леве стране.';
$string['alternativethemesidepreblockhovercolour'] = 'Алтернативна {$a} лебдећа боја линка блока с леве стране';
$string['alternativethemesidepreblockhovercolourdesc'] = 'Подесите алтернативну {$a} лебдећу боју линка за блок с леве стране.';
$string['alternativethemesidepreblocktextcolour'] = 'Алтернативна {$a} боја текста блока с леве стране';
$string['alternativethemesidepreblocktextcolourdesc'] = 'Подесите алтернативну {$a} боју текста за блок с леве стране.';
$string['alternativethemesidepreblockurlcolour'] = 'Алтернативна {$a} боја линка блока с леве стране';
$string['alternativethemesidepreblockurlcolourdesc'] = 'Подесите алтернативну {$a} боју линка за блок с леве стране.';
$string['alternativethemeslidebuttoncolor'] = 'Алтернативна боја дугмета на слајду {$a}';
$string['alternativethemeslidebuttoncolordesc'] = 'Која боје треба да буде боја дугмета на слајду у вашој теми за алтернативне боје теме {$a}.';
$string['alternativethemeslidebuttonhovercolor'] = 'Алтернативна лебдећа боја дугмета на слајду {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'Која би требало да буде ваша лебдећа боја дугмета на слајду за алтернативне боје теме {$a}.';
$string['alternativethemeslidecaptionbackgroundcolor'] = 'Алтернативна боја позадине натписа на слајду {$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'Која боје треба да буде боја позадине натписа на слајду у вашој теми за алтернативне боје теме {$a}. Није примењиво ако је за натпис на слајду изабрана опција \'Поред\'.';
$string['alternativethemeslidecaptiontextcolor'] = 'Алтернативна боја текста натписа на слајду {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'Која боје треба да буде боја текста натписа на слајду у вашој теми за алтернативне боје теме {$a}. Није примењиво ако је за натпис на слајду изабрана опција \'Поред\'.';
$string['alternativethemeslidecolors'] = 'Алтернативне боје слајдова теме';
$string['alternativethemeslidecolorsdesc'] = 'Дефинише алтернативне боје слајдова теме које корисник може да изабере.';
$string['alternativethemestripebackgroundcolour'] = 'Алтернативна боја позадине пруге {$a}';
$string['alternativethemestripebackgroundcolourdesc'] = 'Подесите алтернативну {$a} боју позадине за пруге у табелама';
$string['alternativethemestripetextcolour'] = 'Алтернативна боја текста пруге {$a}';
$string['alternativethemestripetextcolourdesc'] = 'Подесите алтернативну {$a} боју текста за пруге у табелама';
$string['alternativethemestripeurlcolour'] = 'Алтернативна боја URL линка унутар пруге {$a}';
$string['alternativethemestripeurlcolourdesc'] = 'Подесите алтернативну боју {$a} URL линка унутар пруга у табелама.';
$string['alternativethemetextcolor'] = 'Алтернативна боја текста {$a}';
$string['alternativethemetextcolordesc'] = 'Подесите своју алтернативну боју за текст {$a}.';
$string['alternativethemeurlcolor'] = 'Алтернативна боја линка {$a}';
$string['alternativethemeurlcolordesc'] = 'Подесите своју алтернативну боју за текст линкова {$a}.';
$string['alwaysdisplay'] = 'Увек прикажи';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Унесите URL адресу за вашу мобилну апликацију у Google Play продавници. Уколико немате своју можете унети адресу бесплатне званичне Moodle Mobile апликације (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['androidurl'] = 'Android (Google Play) URL адреса';
$string['asconfigintlower'] = '{$a->value} је мање од доње границе опсега {$a->lower}';
$string['asconfigintnan'] = '{$a->value} није број';
$string['asconfigintupper'] = '{$a->value} је веће од горње границе опсега {$a->upper}';
$string['backtotop'] = 'Назад на врх';
$string['badgepreferences'] = 'Беџ';
$string['badgesmi'] = 'Беџеви';
$string['badgesmidesc'] = 'Прикажите ставку менија за беџеве ако корисник има способност \'moodle/badges:manageownbadges\' и ако су беџеви омогућени на нивоу сајта.';
$string['beforecontent'] = 'Пре садржаја';
$string['below'] = 'Испод';
$string['breadcrumbsimple'] = 'Једноставан';
$string['breadcrumbstyle'] = 'Стил навигационе путање';
$string['breadcrumbstyled'] = 'Елегантан';
$string['breadcrumbstyledesc'] = 'Овде можете да промените стил навигационе путање.';
$string['breadcrumbstylednocollapse'] = 'Елегантан без скупљања';
$string['breadcrumbthin'] = 'Проређен';
$string['cachesused'] = 'Коришћена кеш меморија';
$string['calendarmi'] = 'Календар';
$string['calendarmidesc'] = 'Прикажите ставку менија за календар ако корисник има способност \'moodle/calendar:manageownentries\'.';
$string['categoryctidesc'] = 'Ако је ова опција укључена, то ће вам омогућити да поставите слике за сваку категорију.';
$string['categoryctiheading'] = 'Насловне слике категорије курсева';
$string['categoryctiheadingcategory'] = 'Насловна слика категорије курсева за: {$a->category}';
$string['categoryctiheadingcs'] = 'Конфигурација насловних слика категорије курсева';
$string['categoryctiheadingsub'] = 'Користите слике за представљање ваших категорија унутар курса';
$string['categoryctiheight'] = 'Категорија \'{$a->category}\' - висина насловне слике курса';
$string['categoryctiheightdesc'] = 'Висина слике за наслов курса у категорији \'{$a->category}\' између {$a->lower} и {$a->upper} пиксела. Немојте додавати \'px\' на крају, већ само унесите број.';
$string['categoryctiinfo'] = 'Подешавање категорије {$a->category}';
$string['categoryctiinfodesc'] = 'Подешавања насловне слике категорије курсева за: {$a->category}.';
$string['categoryctimage'] = 'Категорија \'{$a->category}\' - датотека насловне слике курса';
$string['categoryctimagedesc'] = 'Слика датотеке за наслов курса у категорији \'{$a->category}\'.';
$string['categoryctimageurl'] = 'Категорија \'{$a->category}\' - URL адреса насловне слике курса';
$string['categoryctimageurldesc'] = 'URL адреса слике за наслов курса у категорији \'{$a->category}\'. Ако је датотека постављена онда ће то заменити ово подешавање.';
$string['categoryctitextbackgroundcolour'] = 'Категорија \'{$a->category}\' - боја позадине текста наслова курса';
$string['categoryctitextbackgroundcolourdesc'] = 'Боја позадине текста за наслов курса у категорији \'{$a->category}\'.';
$string['categoryctitextbackgroundopacity'] = 'Категорија \'{$a->category}\' - непрозирност позадине текста наслова курса';
$string['categoryctitextbackgroundopacitydesc'] = 'Непрозирност позадине текста за наслова курса у категорији \'{$a->category}\'.';
$string['categoryctitextcolour'] = 'Категорија \'{$a->category}\' - боја текста наслова курса';
$string['categoryctitextcolourdesc'] = 'Боја текста за наслов курса у категорији \'{$a->category}\'.';
$string['categoryiconcategory'] = 'Иконица за категорију: {$a->category}.';
$string['categoryicondesc'] = 'Ако омогућена ова опција ће вам дозволити да подесите иконице за сваку категорију курса.';
$string['categoryiconheading'] = 'Иконице категорија';
$string['categoryiconheadingsub'] = 'Користите иконице за приказивање ваших категорија';
$string['categoryiconinfo'] = 'Подесите прилагођене иконице категорија';
$string['categoryiconinfodesc'] = 'Унесите назив иконице коју желите да користите. Списак иконица можете наћи <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">овде</a>. Унесите само оно што следи иза "fa-".';
$string['categoryimagecategory'] = 'Слика за категорију: {$a->category}.';
$string['categoryincoursebreadcrumbfeature'] = 'Категорије у навигационој путањи курса';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Прикажите линк категорије у навигационој путањи курса.';
$string['ccd'] = 'Датум креирања курса';
$string['ced'] = 'Датум завршетка курса';
$string['cfn'] = 'Пун назив курса';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" alt="Essential screen shot"/></p>
</div>
<div class="well">
<h3>О теми Essential</h3>
<p>Essential  се заснива на теми Bootstrap, која је креирана за Moodle 2.5. Креирање теме су помогли:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Заслуге за тему</h3>
<p>Оригинални аутор: Julian Ridden<br>
Од јула 2014 развој теме преузели су:<br>
Gareth J. Barnard<br>
David Bezemer<br>
Од 9. октобра 2014 развој теме преузео је:<br>
Gareth J. Barnard<br>
</p>
<h3>Спонзорство</h3>
<p>Ова тема је бесплатна. Уколико желите да изразите своју захвалност што је користите, молимо вас, размислите о спонзорисању путем:
<h4>PayPal</h4>
<p>Молим вас, контактирајте ме путем мог <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle профила\'</a> за више информације пошто као појединац не могу да имам дугме \'Купи сада\' под условима Pay Pal система.</p>
<br>Спонзорство ће помоћи да се тема лакше одржава, као и да се развију нове и боље функције. Без ваше подршке тема се не може одржавати.</p>
<p>
<h3>Спонзори</h3>
<p>Захваљујем се на спонзорству:</p>
<ul>
<li>Mihai Bojonca, TCM International Institute.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank">hlasek-it.de/moodle</a></li>
</ul>
</p>
<p>
<h3>Развој теме Essential за Moodle 3.3 спонзорисали су:</h3>
<ul>
<li>ClassroomRevolution, LLC -- Moodle Partner</li>
<li>Daniel Méthot - e-learning-facile.com/formations/</li>
<li>Floyd Saner, Learning Contexts, LLC</li>
<li>Gemma Lesterhuis</li>
<li>Mihai Bojonca, TCM International Institute</li>
</ul>
</p>
<h3>Прилагођавање</h3>
<p>Ако вам се ова тема свиђа и уколико желите да је прилагодим, пребацим њене функције у другу тему, развијем нову тему испочетка или креирам подређену тему, онда вам нудим разумне цене. Молим вас, контактирајте ме путем \'http://moodle.org/user/profile.php?id=442195\' како бисмо размотрили ваше захтеве.</p>
</div></div>';
$string['cid'] = 'ID ознака курса';
$string['colordesc'] = 'Овде можете наћи различита подешавања за промену многих боја у овој теми.';
$string['colorheading'] = 'Боје';
$string['colorheadingsub'] = 'Подесите боје које се користе у вашој теми';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Контакт информације';
$string['contactinfodesc'] = 'Упишите своје контакт информације';
$string['copyright'] = 'Ауторско право';
$string['copyrightdesc'] = 'Назив ваше институције/организације.';
$string['coursecategorysettingstitle'] = 'Подешавања категорије курсева';
$string['coursecontentsearch'] = 'Претрага садржаја курса';
$string['coursecontentsearchdesc'] = 'Омогућите претрагу садржаја курса на страници \'Контролни панел\'. Ово функционише само када тема Essential није наведена у \'$CFG->themedir\'.';
$string['coursecontentsearchsortattribute'] = 'Атрибут сортирања резултата претраге курса';
$string['coursecontentsearchsortattributedesc'] = 'Сортирајте резултате претраге према овом атрибуту.';
$string['coursecontentsearchsortorder'] = 'Редослед сортирања претраге комплетног садржаја курса';
$string['coursecontentsearchsortorderdesc'] = 'Сортирајте резултате претраге опадајућим или растућим редоследом.';
$string['coursegrades'] = 'Оцене на курсу';
$string['coursegradesmi'] = 'Оцене на курсу';
$string['coursegradesmidesc'] = 'Прикажите ставку менија за оцене на курсу ако корисник има способност \'gradereport/user:view\'  и ако је опција за приказ оцена подешена на курсу.';
$string['courselistteachericon'] = 'Иконица за предавача на списку курсева';
$string['courselistteachericondesc'] = 'Назив иконице коју желите да користите или оставите празно. Списак иконица можете наћи <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">овде</a>. Унесите само оно што следи иза  "fa-",", нпр.  "star".';
$string['coursesettingstitle'] = 'Подешавања курса';
$string['coursetitleposition'] = 'Позиција наслова курса';
$string['coursetitlepositiondesc'] = 'Изаберите између опција \'Изнад\' и \'Унутар\', где опција \'Изнад\' значи положај изнад региона \'Лево\', \'Врх странице\' и \'Садржај курса\', док опција \'Унутар\' подразумева положај унутар региона \'Садржај курса\', како то је и било пре него што је уведено ово подешавања.';
$string['csd'] = 'Датум почетка курса';
$string['ctioverride'] = 'Редефинисање слика категорија унутар курса';
$string['ctioverridedesc'] = 'Ако желите да редефинишете насловну слику категорије курсева, када је ово омогућено са подешавањем \'enablecategorycti\', онда уредите резиме курса у подешавањима курса и додајте слику. Онда уредите у HTML режиму - уклоните све \'p\' и \'br\' ознаке, потом уклоните атрибуте \'style\', \'width\' и \'height\' као и класе \'classes\' које је додао едитор текста уз ознаку \'img\'. Затим додајте класу  \'categorycti\'. Како бисте одредили висину (у пикселима) као и боју наслова текста, боју позадине и непрозирност, користите следеће атрибуте: \'ctih\', \'ctit\', \'ctib\' и \'ctio\', на пример:<br/><br/><img src="https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg" alt="Replacement image" class="categorycti" ctih="250" ctit="#afafaf" ctib="#222222" ctio="0.5"><br/><br/>. Ова слика неће бити приказани у самом резимеу када гледате листу курсева.';
$string['ctioverrideheight'] = 'Стандардна редефинисана висина насловне слике курса';
$string['ctioverrideheightdesc'] = 'Стандардна редефинисана висина слике за наслов курса између  {$a->lower} и {$a->upper} пиксела. Немојте додавати \'px\' на крају, већ само унесите број.';
$string['ctioverridetextbackgroundcolour'] = 'Стандардна редефинисана боја позадине текста наслова курса';
$string['ctioverridetextbackgroundcolourdesc'] = 'Стандардна редефинисана боја позадине текста за наслов курса.';
$string['ctioverridetextbackgroundopacity'] = 'Стандардна редефинисана непрозирност позадине текста наслова курса';
$string['ctioverridetextbackgroundopacitydesc'] = 'Стандардна редефинисана непрозирност позадине текста за наслова курса.';
$string['ctioverridetextcolour'] = 'Стандардна редефинисана боја текста наслова курса';
$string['ctioverridetextcolourdesc'] = 'Стандардна редефинисана боја текста за наслов курса.';
$string['customcss'] = 'Прилагођени CSS';
$string['customcssdesc'] = 'CSS правила која додате у ово поље за текст одразиће се на изглед свих страница, што олакшава прилагођавање ове теме.';
$string['customscrollbars'] = 'Прилагођене клизне траке';
$string['customscrollbarsdesc'] = 'Користите прилагођене клизне траке за померање садржаја. Ово ће заменити стандардне клизне траке у веб читачу.';
$string['dbqueries'] = 'База података - читање/уписивање';
$string['dbtime'] = 'Време упита базе података';
$string['defaultcategoryicon'] = 'Подразумевана иконица категорије';
$string['defaultcategoryicondesc'] = 'Подесите подразумевану иконицу категорије';
$string['defaultcategoryimage'] = 'Подразумевана слика категорије';
$string['defaultcategoryimagedesc'] = 'Подесите подразумевану слику категорије. Када поставите слику она ће заменити иконицу.';
$string['defaultcolors'] = 'Подразумеване боје';
$string['displayafterlogin'] = 'Прикажи само након пријаве на систем';
$string['displaybeforelogin'] = 'Прикажи само пре пријаве на систем';
$string['displayeditingmenu'] = 'Прикажи дугме за уређивање';
$string['displayeditingmenudesc'] = 'Приказује дугме са истим функционалностима као стандардно дугме за уређивање странице у заглављу.';
$string['displayhiddenmycourses'] = 'Прикажи сакривене курсеве';
$string['displayhiddenmycoursesdesc'] = 'Приказује сакривене курсеве корисницима у \'Менију курсева\' ако имају овлашћење да виде сакривене курсеве.';
$string['displaymycourses'] = 'Прикажи курсеве';
$string['displaymycoursesdesc'] = 'Корисницима се у навигационој траци приказују курсеви које су уписали.';
$string['docking'] = 'Омогући пребацивања блокова у док.';
$string['dockingdesc'] = 'Ако је ова опција омогућена биће доступно пребацивање блокова у док.';
$string['dontdisplay'] = 'Никад не приказуј';
$string['dropdownmenumaxheight'] = 'Максимална висина падајућег менија';
$string['dropdownmenumaxheightdesc'] = 'Максимална висина падајућег менија када су омогућене клизне траке. Између  {$a->lower} и {$a->upper} пиксела.';
$string['dropdownmenuscroll'] = 'Клизне траке на падајућим менијима';
$string['dropdownmenuscrolldesc'] = 'Додајте клизну траку падајућем менију када је његова висина ограничена.';
$string['editingmenu'] = 'Прекидач за уређивање странице';
$string['editingmenudesc'] = 'Приказује дугме за укључивање/искључивање уређивања текуће странице ако је кориснику дозвољено да уређује страницу. Иста функционалност као и код обичног дугмета за уређивање странице.';
$string['enablealert'] = 'Укључи важна обавештења';
$string['enablealertdesc'] = 'Укључите или искључите важна обавештења';
$string['enablealternativethemecolors'] = 'Омогући алтернативне боје теме {$a}';
$string['enablealternativethemecolorsdesc'] = 'Ако је ова опција омогућена корисник ће моћи да изабере алтернативне боје теме {$a}.';
$string['enablecategorycti'] = 'Омогући насловне слике категорије курсева';
$string['enablecategoryctics'] = 'Омогући засебне странице за све категорија за подешавање насловне слике категорије курсева';
$string['enablecategorycticsdesc'] = 'Ако је омогућено ово подешавање, све категорије курсева највишег нивоа имаће сопствену страницу за подешавање.';
$string['enablecategoryctidesc'] = 'Ако је омогућено ово подешавање, моћи ћете да изаберете насловне слике категорије курсева након што кликнете на ”Сачувај промене”.';
$string['enablecategoryicon'] = 'Омогући иконице категорија';
$string['enablecategoryicondesc'] = 'Ако је омогућено, моћи ћете да изаберете иконице категорија након што кликнете на "Сачувај промене".';
$string['enablecustomcategoryicon'] = 'Омогући прилагођене иконице категорија';
$string['enablecustomcategoryicondesc'] = 'Ако је ова опција омогућена. испод овог одељка видећете категорије са подесивим опцијама поред сваке категорије. Молимо вас да сачувате промене након што омогућите/онемогућите ову опцију.';
$string['extperfinfoheading'] = 'Информације о додатним перформансама';
$string['facebook'] = 'Facebook URL адреса';
$string['facebookdesc'] = 'Унесите URL адресу ваше Facebook странице (тј. http://www.facebook.com/mojaskola).';
$string['facebookurl'] = 'Facebook URL адреса';
$string['favicon'] = 'Прилагођена фавиконица';
$string['favicondesc'] = 'Поставите сопствену фавиконицу. То треба да буде .ico датотека.';
$string['featuredesc'] = 'Овде можете наћи различита подешавања за промену многих функционалности које се налазе у овој теми.';
$string['featureheading'] = 'Функционалности';
$string['featureheadingsub'] = 'Подесите функционалности које се користе у вашој теми';
$string['findcoursecontent'] = 'Претрага курса:';
$string['fitvids'] = 'Kористи FitVids';
$string['fitvidsdesc'] = 'Омогућите FitVids (fitvidsjs.com) како би ваши видео снимци били прилагодљиви. Ако је FitVids укључен, и притом желите да видео снимак буде изузет, онда у HTML кôд додајте \'class="fitvidsignore"\' унутар \'iframe\' ознаке. На пример:<iiframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe>.';
$string['fixedwidthnarrow'] = 'Фиксна ширина - Уско';
$string['fixedwidthnormal'] = 'Фиксна ширина - Нормално';
$string['fixedwidthwide'] = 'Фиксна ширина - Широко';
$string['flatnavigation'] = 'Омогући равну навигацију.';
$string['flatnavigationdesc'] = 'Ако је ова опција омогућена, уместо блокова за навигацију и администрацију (подешавања) биће коришћена равна навигација.';
$string['flickr'] = 'Flickr URL адреса';
$string['flickrdesc'] = 'Унесите URL адресу ваше Flickr странице (тј. http://www.flickr.com/mojaskola).';
$string['flickrurl'] = 'Flickr URL адреса';
$string['floatingsubmitbuttons'] = 'Плутајућа дугмад';
$string['floatingsubmitbuttonsdesc'] = 'Ова опција омогућава коришћење \'плутајућег\' региона који садржи дугмад за слање образаца на стоним рачунарима. Ово помаже да се смањи премотавања садржаја на неким страницама. Не користи се за упис на курс и постове на форумима.';
$string['fontcharacterset'] = 'Додатан скуп карактера Google фонта';
$string['fontcharactersetcyrillic'] = 'Ћирилица';
$string['fontcharactersetcyrillicext'] = 'Проширена ћирилица';
$string['fontcharactersetdesc'] = 'Изаберите додатни скупове карактера за различите језике.
Како коришћење више скупова карактера може да успори ваш Moodle изаберите само оне који су вам стварно потребни.';
$string['fontcharactersetgreek'] = 'Грчки алфабет';
$string['fontcharactersetgreekext'] = 'Проширени грчки алфабет';
$string['fontcharactersetlatinext'] = 'Проширена латиница';
$string['fontcharactersetvietnamese'] = 'Вијетнамски';
$string['fontfileeotbody'] = 'Датотека основног EOT фонта';
$string['fontfileeotheading'] = 'Датотека EOT фонта наслова';
$string['fontfileotfbody'] = 'Датотека основног OTF фонта';
$string['fontfileotfheading'] = 'Датотека OTF фонта наслова';
$string['fontfiles'] = 'Датотеке фонтова';
$string['fontfilesdesc'] = 'Поставите овде своје датотеке фонтова.';
$string['fontfilesvgbody'] = 'Датотека основног SVG фонта';
$string['fontfilesvgheading'] = 'Датотека SVG фонта наслова';
$string['fontfilettfbody'] = 'Датотека основног TTF фонта';
$string['fontfilettfheading'] = 'Датотека TTF фонта наслова';
$string['fontfilewoffbody'] = 'Датотека основног WOFF фонта';
$string['fontfilewoffheading'] = 'Датотека WOFF фонта наслова';
$string['fontfilewofftwobody'] = 'Датотека основног WOFF2 фонта';
$string['fontfilewofftwoheading'] = 'Датотека WOFF2 фонта наслова';
$string['fontheadingdesc'] = 'Изаберите и унесите фонтове које желите да користите у свом Moodle окружењу.';
$string['fontheadingsub'] = 'Подешавања фонта';
$string['fontnamebody'] = 'Фонт текста';
$string['fontnamebodydesc'] = 'Унесите тачан назив фонта који желите да користите за сав остали текст.';
$string['fontnameheading'] = 'Фонт наслова';
$string['fontnameheadingdesc'] = 'Унесите тачан назив фонта који желите да користите за наслове.';
$string['fontselect'] = 'Бирач типа фонта';
$string['fontselectdesc'] = 'Изаберите са списка доступних типова фонтова. Молимо сачувајте како би се приказале опције за тип фонта који сте изабрали.';
$string['fontsettings'] = 'Фонт';
$string['fonttypecustom'] = 'Нестандардни фонт';
$string['fonttypegoogle'] = 'Google  веб фонтови';
$string['fonttypeuser'] = 'Кориснички фонтови';
$string['footerblockbackgroundcolour'] = 'Боја позадине блока подножја';
$string['footerblockbackgroundcolourdesc'] = 'Подесите боју за позадину блока у подножју странице.';
$string['footerblockhovercolour'] = 'Лебдећа боја линка блока подножја';
$string['footerblockhovercolourdesc'] = 'Подесите боју за текст линкова блока у подножју странице када се мишем пређе преко њих.';
$string['footerblocktextcolour'] = 'Боја текста блока подножја';
$string['footerblocktextcolourdesc'] = 'Подесите боју текста блока у подножју странице.';
$string['footerblockurlcolour'] = 'Боја линка блока подножја';
$string['footerblockurlcolourdesc'] = 'Подесите боју за текст линкова блока у подножју странице.';
$string['footercolor'] = 'Боја позадине подножја';
$string['footercolordesc'] = 'Подесите боју позадине региона који се налази у подножју странице.';
$string['footercolors'] = 'Боје подножја';
$string['footercolorsdesc'] = 'Промените боје подножја странице';
$string['footerheading'] = 'Подножје странице';
$string['footerheadingcolor'] = 'Боја наслова у подножју странице';
$string['footerheadingcolordesc'] = 'Подесите боју за наслове блокова у подножју странице.';
$string['footerhovercolor'] = 'Лебдећа боја линка подножја';
$string['footerhovercolordesc'] = 'Подесите боју за текст линкова у подножју странице када се мишем пређе преко њих.';
$string['footersepcolor'] = 'Боја сепаратора у подножју странице';
$string['footersepcolordesc'] = 'Сепаратори су линије које се користе да би се раздвојио садржај. Овде подесите боју за сепараторе.';
$string['footertextcolor'] = 'Боја текста у подножју странице';
$string['footertextcolordesc'] = 'Подесите боју којом желите да буде приказан текст у подножју странице.';
$string['footerurlcolor'] = 'Боја линка у подножју странице';
$string['footerurlcolordesc'] = 'Подесите боју за текст линкова у подножју странице.';
$string['footnote'] = 'Подножје';
$string['footnotedesc'] = 'Садржај који додате у ово поље за текст биће приказан у подножју сваке странице вашег Moodle сајта.';
$string['forumdiscussionsmi'] = 'Дискусије';
$string['forumdiscussionsmidesc'] = 'Прикажите ставку менија за дискусије ако корисник има способност \'mod/forum:viewdiscussion\'.';
$string['forumpostsmi'] = 'Поруке на форумима';
$string['forumpostsmidesc'] = 'Прикажите ставку менија за поруке на форумима ако корисник има способност \'mod/forum:viewdiscussion\'.';
$string['fppagetopblocks'] = 'Омогући додатне блокове на насловној страници у региону \'Врх странице\'';
$string['fppagetopblocksdesc'] = 'Ако је омогућено ово подешавање, на насловној страници, изнад дела са садржајем, биће приказан додатни регион за блокове. Напомена: број блокова по једном реду зависи од подешавања \'fppagetopblocksperrow\' (Број блокова по једном реду на насловној страници у региону \'Врх странице\').';
$string['fppagetopblocksperrow'] = 'Број блокова по једном реду на насловној страници у региону \'Врх странице\'';
$string['fppagetopblocksperrowdesc'] = 'Наведите колико ће бити блокова по једном реду (између {$a->lower} и {$a->upper}) у региону \'Врх странице\' на насловној страници.';
$string['frontcontent'] = 'Омогући текстуални блок на насловној страници';
$string['frontcontentarea'] = 'Садржај текстуалног блока на насловној страници';
$string['frontcontentareadesc'] = 'Садржај који унесете у овај текстуални блок биће приказан читавом ширином насловне странице у простору који се налази између слајд презентације и промотивних блокова.';
$string['frontcontentdesc'] = 'Ако је омогућено, ово додаје текстуални блок за ваш наменски прилагођени садржај, смештен између слајд презентације и промотивних блокова.';
$string['frontcontentheading'] = 'Текстуални блок на насловној страници';
$string['frontpageblocks'] = 'Поравнање блокова на насловној страници';
$string['frontpageblocksdesc'] = 'Овде можете одредити да ли су стандардни Moodle блокови на насловној страници поравнати пре или после садржаја.';
$string['frontpageblocksheading'] = 'Блокови насловне странице';
$string['frontpageheading'] = 'Насловна страница';
$string['frontpageheadingdesc'] = 'Подесите овде које додатне ставке желите да прикажете на насловној страници.';
$string['frontpagehomeblocksperrow'] = 'Број блокова у региону \'Почетак странице\' (раније \'Средина странице\')';
$string['frontpagehomeblocksperrowdesc'] = 'Наведите колико ће бити блокова по једном реду (између {$a->lower} и {$a->upper}) у региону \'Почетак странице\'.';
$string['frontpagemiddleblocks'] = 'Омогући додатне блокове на насловној страници у региону \'Почетак странице\' (раније \'Средина странице\')';
$string['frontpagemiddleblocksdesc'] = 'Ако је омогућено, ово подешавање ће приказати додатан регион за блокове, одмах испод промотивних блокова.';
$string['frontpagesettingstitle'] = 'Подешавања насловне странице';
$string['fullname'] = 'Пун назив сајта';
$string['fullnamesummary'] = 'Пун назив сајта и резиме';
$string['generalheadingdesc'] = 'Конфигуришите овде општа подешавања теме.';
$string['generalheadingsub'] = 'Општа подешавања';
$string['genericsettings'] = 'Опште';
$string['googleplus'] = 'Google+ URL адреса';
$string['googleplusdesc'] = 'Унесите URL адресу вашег Google+ профила (тј. http://plus.google.com/+mojaskola).';
$string['googleplusurl'] = 'Google+ URL адреса';
$string['gotobottom'] = 'Иди на дно странице';
$string['gotopeople'] = 'Учесници';
$string['haveheaderblock'] = 'Регион блокова \'Заглавље\'';
$string['haveheaderblockdesc'] = 'Омогућите регион блокова \'Заглавље\' одмах испод навигационе траке.';
$string['headerbackground'] = 'Позадинска слика заглавља';
$string['headerbackgrounddesc'] = 'Поставите своју слику позадине.';
$string['headerbackgroundstyle'] = 'Стил позадине заглавља';
$string['headerbackgroundstyledesc'] = 'Изаберите стил за позадину заглавља.';
$string['headerblocksperrow'] = 'Број блокова по једном реду у региону \'Заглавље\'';
$string['headerblocksperrowdesc'] = 'Наведите колико ће бити блокова по једном реду (између {$a->lower} и {$a->upper}) на страницама са регионом \'Заглавље\'.';
$string['headerheading'] = 'Заглавље';
$string['headertextcolor'] = 'Боја текста заглавља';
$string['headertextcolordesc'] = 'Подесите боју текста у заглављу.';
$string['headertitle'] = 'Наслов заглавља';
$string['headertitledesc'] = 'Подесите овде наслов који ће се појавити у заглављу';
$string['helplink'] = 'Линк за помоћ';
$string['helplinkdesc'] = 'Ако сте претходно изабрали опцију "URL адреса" унесите комплетну URL адресу сајта са помоћним информацијама (адреса мора да садржи префикс http:// или https://). Ако сте изабрали опцију "E-адреса" унесите своју електронску адресу.';
$string['helplinktype'] = 'Омогући линк за помоћ у менију';
$string['helplinktypedesc'] = 'Изаберите да ли желите да омогућите опцију за помоћи у корисничком менију, Можете да бирате између URL адресе сајта са помоћним информације, који ће се отварати у новом прозору, и електронске адресе.';
$string['hidedefaulteditingbutton'] = 'Сакриј стандардно дугме за уређивање странице';
$string['hidedefaulteditingbuttondesc'] = 'Сакрива, са свих страница, стандардно дугме за уређивање странице. Ово подешавање има ефекта ако је омогућено подешавање ”Прикажи дугме за уређивање”.';
$string['hideonphone'] = 'Сакриј слајд-шоу на мобилним уређајима';
$string['hideonphonedesc'] = 'Изаберите да ли желите да онемогућите слајд-шоу на мобилним уређајима.';
$string['hideontablet'] = 'Сакриј слајд-шоу на мобилним таблетима';
$string['hideontabletdesc'] = 'Изаберите да ли желите да онемогућите слајд-шоу на таблетима.';
$string['hvpcustomcss'] = 'H5P прилагођени CSS';
$string['hvpcustomcssdesc'] = 'Прилагођени CSS за H5P модул је (moodle.org/plugins/mod_hvp) инсталиран.';
$string['icon'] = 'иконица';
$string['image'] = 'слика';
$string['included'] = 'Датотеке укључене';
$string['instagram'] = 'Instagram URL адреса';
$string['instagramdesc'] = 'Унесите URL адресу ваше Instagram странице (тј. http://web.stagram.com/mojaskola/).';
$string['instagramurl'] = 'Instagram URL адреса';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Унесите URL адресу за вашу мобилну апликацију у Apple App продавници. Уколико немате своју можете унети адресу бесплатне званичне мобилне апликације за Moodle (https://itunes.apple.com/en/app/moodle-mobile/id633359593)..';
$string['iosicon'] = 'Иконице iOS почетног екрана';
$string['iosicondesc'] = 'Тема обезбеђује стандардне иконице за iOS и Android почетне екране. Ако желите можете поставити своје прилагођене иконице.';
$string['iosurl'] = 'iPhone/iPad (App Store) URL адреса';
$string['ipadicon'] = 'iPad иконица (Non Retina)';
$string['ipadicondesc'] = 'Иконица треба да буде PNG датотека величине 72 x 72 пиксела.';
$string['ipadretinaicon'] = 'iPad иконица (Retina)';
$string['ipadretinaicondesc'] = 'Иконица треба да буде PNG датотека величине 144 x 144 пиксела.';
$string['iphoneicon'] = 'iPhone/iPod Touch иконица (Non Retina)';
$string['iphoneicondesc'] = 'Иконица треба да буде PNG датотека величине 57 x 57 пиксела.';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch иконица (Retina)';
$string['iphoneretinaicondesc'] = 'Иконица треба да буде PNG датотека величине 114 x 114 пиксела.';
$string['layout'] = 'Користи стандардни изглед курса';
$string['layoutdesc'] = 'Ова теме је дизајнирана тако да оба ступца са блоковима поставља са десне стране. Уколико преферирате стандардни изглед Moodle курсева можете да означите ово поље за потврду како бисте користили стари изглед курса са три ступца.';
$string['left'] = 'Лево';
$string['linkedin'] = 'LinkedIn URL адреса';
$string['linkedindesc'] = 'Унесите URL адресу вашег LinkedIn профила (тј. http://www.linkedin.com/company/mojaskola).';
$string['linkedinurl'] = 'LinkedIn URL адреса';
$string['loadtime'] = 'Време учитавања';
$string['loggedinas'] = 'пријављен на систем као';
$string['loggedinfrom'] = 'Пријављен на систем са';
$string['loggedinfrommi'] = 'Пријављен на систем са';
$string['loggedinfrommidesc'] = 'Прикажите ставку менија \'Пријављен на систем са\' ако је корисник MNET удаљени корисник.';
$string['loginbackground'] = 'Позадинска слике странице за пријаву на систем';
$string['loginbackgrounddesc'] = 'Поставите сопствену позадинску слику на страници за пријаву на систем. Изаберите у наставку стил слике.';
$string['loginbackgroundopacity'] = 'Непрозирност поља за пријаву када постоји позадинска слика';
$string['loginbackgroundopacitydesc'] = 'Ниво непрозирности поља за пријаву када постоји позадинска слика.';
$string['loginbackgroundstyle'] = 'Стил позадинске слике странице за пријаву';
$string['loginbackgroundstyledesc'] = 'Изаберите стил постављене слике.';
$string['logo'] = 'Логотип';
$string['logodesc'] = 'Поставите овде прилагођени лого уколико желите да га додате у заглавље. <br>Величина слика ће бити пропорционално промењена тако да се уклопи у расположиву процентуалну ширину која је одређена за доле наведени уређај. Ако имате пуно иконица друштвених мрежа / апликација добро проверите крајњи изглед. <br>Ако поставите лого, он ће заменити стандардну иконицу и назив који се приказује као подразумевани.';
$string['logodesktopwidth'] = 'Ширина логотипа за стоне рачунаре';
$string['logodesktopwidthdesc'] = 'Ширина контејнера слике логотипа на стоним рачунарима , >= 980px.<br>Наведите проценат расположивог простора између {$a->lower} и {$a->upper}.<br>Расположиви простор је ширина коју дозвољава подешавање \'pagewidth\' Слика ће попунити наведени проценат до ширине њене резолуције.<br>Напомена! Минимална висина контејнера је 64 пиксела, па ће, уколико је висина слике израчуната као мања,  испод ње постојати празнина.';
$string['logodimerror'] = 'је неисправна вредност. Молимо, наведите јединицу \'px\' или \'em\' одмах након  јединичне вредности, и ништа пре ње.';
$string['logomobilewidth'] = 'Ширина логотипа за мобилне уређаје';
$string['logomobilewidthdesc'] = 'Ширина контејнера слике логотипа на стоним рачунарима , >= 980px.<br>Наведите проценат расположивог простора између {$a->lower} и {$a->upper}.<br>Расположиви простор је ширина коју дозвољава подешавање \'pagewidth\' Слика ће попунити наведени проценат до ширине њене резолуције.<br>Напомена! Минимална висина контејнера је 52 пиксела, па ће, уколико је висина слике израчуната као мања,  испод ње постојати празнина.';
$string['marketing1'] = 'Промотивни блок један';
$string['marketing2'] = 'Промотивни блок два';
$string['marketing3'] = 'Промотивни блок три';
$string['marketingbuttontext'] = 'Текст линка';
$string['marketingbuttontextdesc'] = 'Текст који се појављује на дугмету';
$string['marketingbuttonurl'] = 'URL адреса линка';
$string['marketingbuttonurldesc'] = 'URL адреса са којом је дугме повезано.';
$string['marketingcontent'] = 'Садржај';
$string['marketingcontentdesc'] = 'Текст који се приказује у промотивном блоку. Треба да буде кратак и занимљив.';
$string['marketingdesc'] = 'Ова тема пружа опцију да на насловној страници поставите три промотивна блока или огласа, одмах испод слајд-шоу презентације. Ово вам омогућава да својим корисницима лако назначите најбитније информације и обезбедите одговарајуће директне линкове.';
$string['marketingheading'] = 'Промотивни блокови';
$string['marketingheadingsub'] = 'Три места на насловној страници сајта за додавање информација и линкова.';
$string['marketingheight'] = 'Висина контејнера промотивог блока (пиксели)';
$string['marketingheightdesc'] = 'Одредите висину контејнера промотивног блока у пикселима. Подесите ово тако да одговара вашем садржају. Ако било који блок има слику или линк, онда ће и то бити додато овој вредности висине у свим блоковима.';
$string['marketingicon'] = 'Иконица';
$string['marketingicondesc'] = 'Назив иконице коју желите да користите. Списак иконица можете наћи <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">овде</a>. Унесите само оно што следи иза  "fa-",", нпр.  "star".';
$string['marketingimage'] = 'Слика';
$string['marketingimagedesc'] = 'Ово пружа могућност да изнад текста у промотивном блоку буде приказана слика';
$string['marketingimageheight'] = 'Висина промотивних слика (пиксели)';
$string['marketingimageheightdesc'] = 'Ако желите да прикажете слике у промотивним блоковима овде можете да одредите њихову висину у пикселима.';
$string['marketinginfodesc'] = 'Унесите подешавања за ваш промотивни блок.';
$string['marketingtitle'] = 'Наслов';
$string['marketingtitledesc'] = 'Наслов који ће бити приказан у овом промотивном блоку';
$string['marketingurltarget'] = 'Одредиште линка';
$string['marketingurltargetdesc'] = 'Изаберите како линк треба да буде отворен';
$string['marketingurltargetnew'] = 'Нова страница';
$string['marketingurltargetparent'] = 'Матични оквир';
$string['marketingurltargetself'] = 'Текућа страница';
$string['memused'] = 'Коришћена меморија';
$string['messagesmi'] = 'Поруке';
$string['messagesmidesc'] = 'Прикажите ставку менија за поруке ако је слање порука омогућено';
$string['mobileappsdesc'] = 'Да ли имате веб апликацију у Apple App или Google Play продавници? Унесите овде линк како би ваши корисници могли да преузму апликације онлајн.';
$string['mobileappsheading'] = 'Мобилне апликације';
$string['mobileappsheadingsub'] = 'Линк ка вашој апликација за полазнике који користе мобилне уређаје';
$string['modulesettingstitle'] = 'Подешавања модула';
$string['myclasses'] = 'Моји часови';
$string['mycourses'] = 'Моји курсеви';
$string['mycoursescatsubmenu'] = 'Подмени категорија и курсева';
$string['mycoursescatsubmenudesc'] = 'Организујте курсеве у подменија на основу хијерархије категорија у којима се налазе. Када је опција \'enablecategoryicon\' (Омогући иконице категорија) подешена на \'Не\' онда ће бити коришћена иконица категорије подразумевана за тему. Када је ова опција подешена на \'Да\' онда ће бити коришћена или вредност опције  \'defaultcategoryicon\' (Подразумеване иконице категорија), или иконица саме категорије ако је опција \'enablecustomcategoryicon\' (Омогући прилагођене иконице категорија) подешена на \'Да\'. Подешавање \'mycoursesmax\' (Максималан број курсева) и даље ће се примењивати али на нивоу категорије.';
$string['mycoursesinfo'] = 'Мени курсева';
$string['mycoursesinfodesc'] = 'Приказује корисницима динамички списак уписаних курсева.';
$string['mycoursesmax'] = 'Максималан број курсева';
$string['mycoursesmaxdesc'] = 'Наведите број курсева који треба да буде приказани на списку, између {$a->lower} и {$a->upper},  где \'{$a->lower}\' представља све курсеве.';
$string['mycoursesorder'] = 'Редослед курсева';
$string['mycoursesorderdesc'] = 'Наведите како курсеви треба да буду поређани. Редослед курсева може да се подеси помоћу подешавања за навигацију \'Сортирај моје курсеве\' (\'navsortmycoursessort\').';
$string['mycoursesorderenrolbackcolour'] = 'Боја позадине за уписане курсеве којима корисник још није приступио.';
$string['mycoursesorderenrolbackcolourdesc'] = 'Боја позадине за уписане курсеве којима корисник још није приступио, када је \'Редослед сортирања курсева\' подешен на \'Време последњег приступа...\'';
$string['mycoursesorderid'] = 'ID ознака курса';
$string['mycoursesorderidasc'] = 'Растући';
$string['mycoursesorderiddes'] = 'Опадајући';
$string['mycoursesorderidorder'] = 'Редослед ID ознака курсева';
$string['mycoursesorderidorderdesc'] = 'Редослед ID ознака курсева када је \'Редослед сортирања курсева\' подешен на \'ID ознака курса\'.';
$string['mycoursesorderlast'] = 'Време последњег приступа или почетно време уписа ако корисник никад није приступио курсу';
$string['mycoursesordersort'] = 'Редослед сортирања курсева';
$string['mycoursetitle'] = 'Терминологија';
$string['mycoursetitledesc'] = 'Промените термин наслова менија "Моји курсеви". Када је \'Редослед сортирања курсева\' подешен на \'Време последњег приступа...\' онда ће бити додата реч \'најновији\'.';
$string['mygrades'] = 'Моје оцене';
$string['mygradesmi'] = 'Моје оцене';
$string['mygradesmidesc'] = 'Прикажите ставку менија \'Моје оцене\' ако корисник има способност gradereport/overview:view\' на курсу. Није потврђено на нивоу сајта.';
$string['mylatestclasses'] = 'Моји најновији часови';
$string['mylatestcourses'] = 'Моји најновији курсеви';
$string['mylatestmodules'] = 'Моји најновији модули';
$string['mylatestunits'] = 'Моје најновије јединице';
$string['mymodules'] = 'Моји модули';
$string['myunits'] = 'Моје јединице';
$string['navbarabove'] = 'Навигациона трака изнад заглавља';
$string['navbarbelow'] = 'Навигациона трака испод заглавља';
$string['navbartitle'] = 'Наслов траке за навигацију';
$string['navbartitledesc'] = 'Подесите овде наслов који ће се појавити у таци за навигацију';
$string['nextsection'] = 'Следећа секција';
$string['nobreadcrumb'] = 'Сакриј';
$string['noenrolments'] = 'Тренутно нисте уписани ни на један курс';
$string['noslidetitle'] = 'Нема наслова за слајд {$a->slide}';
$string['notitle'] = 'Без наслова';
$string['numberofcoursesandsubcatcourses'] = 'Број курсева - поткатегорија курсева';
$string['numberofslides'] = 'Број слајдова';
$string['numberofslides_desc'] = 'Број слајдова у оквиру слајд презентације.';
$string['oldnavbar'] = 'Користи стари положај навигационе траке';
$string['oldnavbardesc'] = 'Омогућите ову опцију како бисте користили стари положај навигационе траке.';
$string['pagebackground'] = 'Позадинска слика странице';
$string['pagebackgrounddesc'] = 'Поставите своју позадинску слику. Изаберите стил слике у наставку.';
$string['pagebackgroundstyle'] = 'Стил позадине странице';
$string['pagebackgroundstyledesc'] = 'Изаберите стил постављене слике.';
$string['pagebottomblocksperrow'] = 'Број блокова по једном реду у региону \'Дно странице\'';
$string['pagebottomblocksperrowdesc'] = 'Наведите број блокова (између {$a->lower} и {$a->upper}) који ће бити приказани на страницама са регионом \'Блокови на дну странице\'. Тренутне странице су: Администрација, Управљање курсевима, Оцењивање и Уређивање теста.';
$string['pagetopblocks'] = 'Омогући додатан регион блокова \'Врх странице\' на страницама';
$string['pagetopblocksdesc'] = 'Ако је омогућено ово подешавање, на свим страницам осим на насловној (која има сопствена подешавања), изнад дела са садржајем биће приказан додатни регион за блокове. Напомена: број блокова по једном реду зависи од подешавања \'pagetopblocksperrow\' (Број блокова по једном реду у региону \'Врх странице\').';
$string['pagetopblocksperrow'] = 'Број блокова по једном реду у региону \'Врх странице\'';
$string['pagetopblocksperrowdesc'] = 'Наведите колико ће блокова бити по једном реду (између {$a->lower} и {$a->upper}) на страницама са регионом \'Врх странице\'. Тренутне странице су: Администрација, Курс, Категорија курсева, Контролни панел и Страница за штампу.';
$string['pagewidth'] = 'Подеси ширину странице';
$string['pagewidthdesc'] = 'Изаберите са списка доступних ширина странице за ваш сајт.';
$string['participantsmenu'] = 'Мени учесника';
$string['participantsmenudesc'] = 'Прикажите мени учесника на страницама курса и модула.';
$string['paypal_click'] = 'Moodle профила';
$string['paypal_desc'] = '{$a->url}\' за више информација, пошто према условима коришћења Pay Pal сервиса, као појединац, не могу да користим дугмад \'донација\' / \'купи сад\', или';
$string['peakmem'] = 'Максимум оптерећења меморије';
$string['perfinfo'] = 'Информације о перформансама';
$string['perfinfodesc'] = 'Многим сајтовима нису потребне детаљне информације о перформансама, посебно када се посматра из угла корисника. Када је омогућено, ово приказује основне информације о учитавању странице.';
$string['perfinfoheading'] = 'Информације о перформансама';
$string['perf_max'] = 'Детаљно';
$string['perf_min'] = 'Минимално';
$string['pinterest'] = 'Pinterest URL адреса';
$string['pinterestdesc'] = 'Унесите URL адресу ваше Pinterest странице (тј. http://pinterest.com/mojaskola).';
$string['pinteresturl'] = 'Pinterest URL адреса';
$string['pluginname'] = 'Essential';
$string['preferencesmi'] = 'Параметри';
$string['preferencesmidesc'] = 'Прикажите ставку менија \'Параметри\'';
$string['previoussection'] = 'Претходна секција';
$string['privacy:metadata:preference:courseitemsearchtype'] = 'Избор корисника за претрагу курсева  (\'пун назив курса\' - \'0\' или \'комплетан садржај курса\' - \'1\'),у случају да је сачуван када је у подешавањим теме потврђена опција  \\\'coursecontentsearch\\\'. Ако ништа није наведено онда је или претрага курса искључена или корисник никада није видео \'Контролни панел\' када је био на сајту.';
$string['privacy:request:preference:courseitemsearchtype'] = 'Корисник је изабрао "{$a->value}" као параметар "{$a->name}" за претрагу курсева, где је \'0\' означава \'само пун назив курса\' а \'1\' је \'комплетан садржај курса\'.';
$string['privatefilesmi'] = 'Приватне датотеке';
$string['privatefilesmidesc'] = 'Прикажите ставку менија за приватне датотеке ако корисник има способност \'moodle/user:manageownfiles\'.';
$string['profilebarcustomtitle'] = 'Трака профила - наслов прилагођеног блок';
$string['profilebarcustomtitledesc'] = 'Наслов за прилагођени блок са траком профила.';
$string['profilelinkmi'] = 'Линк профила';
$string['profilelinkmidesc'] = 'Прикажите ставку менија за линк ка профилу корисника';
$string['properties'] = 'Својства';
$string['propertiesdesc'] = 'Списак својстава.';
$string['propertiesexport'] = 'Извези својства као JSON стринг';
$string['propertiesproperty'] = 'Својство';
$string['propertiesreturn'] = 'Врати се';
$string['propertiessub'] = 'Својства';
$string['propertiesvalue'] = 'Вредност';
$string['putpropertiesadded'] = 'Додато:';
$string['putpropertieschanged'] = 'Промењено:';
$string['putpropertiesdesc'] = 'Налепите JSON стринг и кликните на \'Сачувај промене\'. Упозорење! Вредности подешавања се не проверавају а команда \'Обриши све записе из кеш меморије\' се аутоматски извршава.';
$string['putpropertiesfrom'] = 'од';
$string['putpropertiesignorecti'] = 'Игнорисање свих подешавања насловне слике курса.';
$string['putpropertiesignored'] = 'Игнорисано:';
$string['putpropertiesname'] = 'Поставите својства - Експериментално!';
$string['putpropertiesreportfiles'] = 'Не заборавите да поставите следеће датотеке у њихова подешавања:';
$string['putpropertiessettingsreport'] = 'Извештај о подешавањима:';
$string['putpropertiesunchanged'] = 'Непромењено:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Наша';
$string['putpropertyproperties'] = 'Својства';
$string['putpropertyreport'] = 'Извештај:';
$string['putpropertyversion'] = 'верзија:';
$string['readme_click'] = 'кликните овде за README.md';
$string['readme_desc'] = 'Молимо {$a->url} датотеку која садржи више информација о теми Essential.';
$string['readme_title'] = 'Essential read-me датотека са упутством';
$string['readmore'] = 'Прочитај више';
$string['region-footer-left'] = 'Подножје (лево)';
$string['region-footer-middle'] = 'Подножје (средина)';
$string['region-footer-right'] = 'Подножје (десно)';
$string['region-header'] = 'Заглавље';
$string['region-hidden-dock'] = 'Сакривено од корисника';
$string['region-home'] = 'Почетак странице';
$string['region-page-top'] = 'Врх странице';
$string['region-side-post'] = 'Десно';
$string['region-side-pre'] = 'Лево';
$string['returntosection'] = 'Повратак на: {$a->section}';
$string['returntosectionfeature'] = 'Повратак на секцију';
$string['returntosectionfeaturedesc'] = 'Омогућите функционалност повратка на секцију унутар модула курса.';
$string['returntosectiontextlimitfeature'] = 'Повратак на секцију - ограничење дужине назива';
$string['returntosectiontextlimitfeaturedesc'] = 'Ограничење дужине за \'назив\' секције на дугмету између {$a->lower} и {$a->upper} карактера.';
$string['right'] = 'Десно';
$string['searchallcoursecontent'] = 'Претражи комплетан садржај курса';
$string['searchallcoursecontentdefault'] = 'Подразумевана претрага комплетног садржај курса';
$string['searchallcoursecontentdefaultdesc'] = 'Подешава вредност поља за потврду \'Претражи комплетан садржај курса\' за претрагу садржаја курса. Ако ово поље није потврђено онда ће се претраживати само пун назив курса.';
$string['searchallcoursecontentenable'] = 'Омогући претрагу комплетног садржај курса';
$string['searchallcoursecontentenabledesc'] = 'Дозволите кориснику да одлучи да ли жели да претражује комплетан садржај курса. Ако је онемогућено, онда ће се за претрагу курса применити вредност  \'searchallcoursecontentdefault\' (Подразумевана претрага комплетног садржај курса).';
$string['serverload'] = 'Оптерећење сервера';
$string['sessionsize'] = 'Величина сесије';
$string['shortname'] = 'Скраћени назив сајта';
$string['shortnamesummary'] = 'Скраћени назив  и резиме';
$string['siteicon'] = 'Иконица сајта';
$string['siteicondesc'] = 'Немате свој лого? Унесите назив иконице коју желите да користите. Списак иконица можете наћи <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">овде</a>. Унесите само оно што следи иза "fa-".';
$string['skype'] = 'Skype налог';
$string['skypedesc'] = 'Унесите корисничко име за Skype налог ваше институције/организације (тј. skype://moja.skola).';
$string['skypeuri'] = 'URL адреса Skype налога';
$string['slidebuttoncolor'] = 'Боја дугмета на слајду';
$string['slidebuttoncolordesc'] = 'Које боје треба да буде навигационо дугме на слајду.';
$string['slidebuttonhovercolor'] = 'Лебдећа боја дугмета на слајду';
$string['slidebuttonhovercolordesc'] = 'Које боје треба да буде лебдећа боја навигационог дугмета на слајду.';
$string['slidecaption'] = 'Опис слајда';
$string['slidecaptionbackgroundcolor'] = 'Боја позадине натписа на слајду';
$string['slidecaptionbackgroundcolordesc'] = 'Која боје треба да буде боја позадине натписа на слајду. Није примењиво ако је за натпис на слајду изабрана опција \'Поред\'.';
$string['slidecaptionbelow'] = 'Опис слајда испод слике';
$string['slidecaptionbelowdesc'] = 'Да ли опис слајда треба да буде испод слике.';
$string['slidecaptionbeside'] = 'Поред';
$string['slidecaptioncentred'] = 'Опис слајда центриран';
$string['slidecaptioncentreddesc'] = 'Да ли опис слајда треба да буде на средини.';
$string['slidecaptiondesc'] = 'Унесите текст који ће се користити за опис слајда';
$string['slidecaptionontop'] = 'На врху';
$string['slidecaptionoptions'] = 'Опције за опис слајда';
$string['slidecaptionoptionsdesc'] = 'Где треба да се налази опис слајда у односу на слику.';
$string['slidecaptiontextcolor'] = 'Боја текста натписа на слајду';
$string['slidecaptiontextcolordesc'] = 'Која боје треба да буде боја текста натписа на слајду. Није примењиво ако је за натпис на слајду изабрана опција \'Поред\'.';
$string['slidecaptionunderneath'] = 'Испод';
$string['slidecolor'] = 'Боја текста слајда';
$string['slidecolordesc'] = 'Које боје треба да буде текст описа слајда.';
$string['slideimage'] = 'Слика слајда';
$string['slideimagedesc'] = 'Најбоље је користити транспарентну слику.';
$string['slideinterval'] = 'Интервал између слајдова';
$string['slideintervaldesc'] = 'Време преласка са једног на други слајд у милисекундама.';
$string['slideno'] = 'Слајд {$a->slide}';
$string['slidenodesc'] = 'Унесите подешавања за слајд {$a->slide}.';
$string['slideshowdesc'] = 'Ово креира динамички слајд-шоу од максимално 16 слајдова за промовисање важних ствари на вашем сајту. Слајд-шоу је прилагодљив тако да се висина слике подешава према величини екрана. Препоручена висина је 300 пиксела. Ширина је подешена на 100 % па ће зато стварна висина слике бити мања ако је ширина већа од величине екрана. На екранима мање величине, висина се динамички смањује, без потребе да се обезбеде засебне слике. За екране чија је ширина мања од 767 пиксела висина ће бити165 пиксела, за екране чија је ширина између 768 и 979 пиксела, висина ће бити 225пиксела, док ће за екране ширине веће од 980 пиксела висина бити 300 пиксела. Ако је није изабрана ниједна слика за слајд, онда ће се користити слика default_slide која се налази у фолдеру pix.';
$string['slideshowheading'] = 'Слајд-шоу';
$string['slideshowheadingsub'] = 'Динамички слајд-шоу на насловној страници';
$string['slidetitle'] = 'Наслов слајда';
$string['slidetitledesc'] = 'Унесите описни наслов за ваш слајд';
$string['slideurl'] = 'Линк слајда';
$string['slideurldesc'] = 'Унесите циљно одредиште линка прве слике слајда';
$string['slideurltarget'] = 'Одредиште линка';
$string['slideurltargetdesc'] = 'Изаберите како линк треба да буде отворен';
$string['slideurltargetnew'] = 'Нова страница';
$string['slideurltargetparent'] = 'Матични оквир';
$string['slideurltargetself'] = 'Текућа страница';
$string['socialdesc'] = 'Унесите директне линкове ка главним друштвеним мрежама како бисте промовисали свој сајт. Ови линкови ће се појављивати у заглављу сваке странице.';
$string['socialheading'] = 'Друштвене мреже';
$string['socialheadingsub'] = 'Анимирајте своје кориснике путем друштвених мрежа';
$string['socialnetworks'] = 'Друштвене мреже';
$string['sponsor_desc'] = 'Молимо вас да путем PayPal система будете спонзор тако што ћете ме контактирати преко мог';
$string['sponsor_desc2'] = 'како би се наставио развој теме Essential , или једноставно, да бисте изразили своју захвалност.';
$string['sponsor_title'] = 'Спонзоришите тему Essential';
$string['stylecover'] = 'Прекривено';
$string['stylefixed'] = 'Фиксирано';
$string['styleguide'] = 'Стилски водич';
$string['styleguidedesc'] = 'Оригинална документација кôда је под \'{$a->origcodelicenseurl}\' лиценцом. Holder.js има \'{$a->holderlicenseurl}\' лиценцу. Додатни кôд је под \'{$a->thiscodelicenseurl}\' лиценцом, која је \'{$a->compatible}\' лиценца. Садржај има \'{$a->contentlicenseurl}\' лиценцу. Документација је форматирана за приказ у Moodleu са додатком FontAwesome иконица где је то потребно. Додатни CSS може се наћи у датотеци \'essential_admin_setting_styleguide.php\' под коментаром \'// Beyond docs.css.\'. Секција \'{$a->globalsettings}\' је уклоњена.';
$string['styleguidesub'] = 'Bootstrap V2.3.2 Стилски водич';
$string['stylestretch'] = 'Развучено';
$string['styletiled'] = 'Поплочано';
$string['switchrolemi'] = 'Промена улоге';
$string['switchrolemidesc'] = 'Прикажите ставку менија за промену улоге ако корисник може да мења улоге.';
$string['tallyinoftotal'] = '{$a->rtally} у {$a->ctally} од {$a->ctotal}';
$string['tallyoftotal'] = '{$a->tally} од {$a->total}';
$string['themecolor'] = 'Боја теме';
$string['themecolordesc'] = 'Које боје треба да буде ваша тема. Ово ће променити бројне компоненте како бисте користили боју коју желите на читавом сајту.';
$string['themecolors'] = 'Боје теме';
$string['themedefaultbuttonbackgroundcolour'] = 'Боја позадине стандардног дугмета';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Подесите боју позадине за сву стандардну дугмад.';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Лебдећа боја позадине стандардног дугмета';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Подесите лебдећу боју позадине за сву стандардну дугмад.';
$string['themedefaultbuttontextcolour'] = 'Боја текста стандардног дугмета';
$string['themedefaultbuttontextcolourdesc'] = 'Подесите боју текста за сву стандардну дугмад.';
$string['themedefaultbuttontexthovercolour'] = 'Лебдећа боја текста стандардног дугмета';
$string['themedefaultbuttontexthovercolourdesc'] = 'Подесите лебдећу боју текста за сву стандардну дугмад.';
$string['themehovercolor'] = 'Лебдећа боја теме';
$string['themehovercolordesc'] = 'Која боје треба да буде лебдећа боја у вашој теми. Она се користи за линкове, меније итд.';
$string['themeiconcolor'] = 'Боја иконица';
$string['themeiconcolordesc'] = 'Подесите боју за све иконице.';
$string['themenavcolor'] = 'Боја навигације';
$string['themenavcolordesc'] = 'Подесите боју текста за навигацију, имајући у виду навигациону траку и елегантни стил навигационе путање.';
$string['themequizsubmitbackgroundcolour'] = 'Боја позадине дугмета \'Предај све одговоре и заврши тест\'';
$string['themequizsubmitbackgroundcolourdesc'] = 'Подесите боју позадине за дугме \'Предај све одговоре и заврши тест\'.';
$string['themequizsubmitbackgroundhovercolour'] = 'Лебдећа боја позадине дугмета \'Предај све одговоре и заврши тест\'';
$string['themequizsubmitbackgroundhovercolourdesc'] = 'Подесите лебдећу боју позадине за дугме \'Предај све одговоре и заврши тест\'.';
$string['themequizsubmittextcolour'] = 'Боја текста дугмета \'Предај све одговоре и заврши тест\'';
$string['themequizsubmittextcolourdesc'] = 'Подесите боју текста за дугме \'Предај све одговоре и заврши тест\'.';
$string['themequizsubmittexthovercolour'] = 'Лебдећа боја текста дугмета \'Предај све одговоре и заврши тест\'';
$string['themequizsubmittexthovercolourdesc'] = 'Подесите алтернативну лебдећу боју текста за дугме \'Предај све одговоре и заврши тест\'.';
$string['themesidepreblockbackgroundcolour'] = 'Боја позадине блока с леве стране';
$string['themesidepreblockbackgroundcolourdesc'] = 'Подесите боју позадине у региону с леве стране';
$string['themesidepreblockhovercolour'] = 'Боја позадине лебдећег линка с леве стране';
$string['themesidepreblockhovercolourdesc'] = 'Подесите лебдеће боју позадине линк за блок с леве стране';
$string['themesidepreblocktextcolour'] = 'Боја текста блока с леве стране';
$string['themesidepreblocktextcolourdesc'] = 'Подесите боју текста за блок с леве стране';
$string['themesidepreblockurlcolour'] = 'Боја линка блока с леве стране';
$string['themesidepreblockurlcolourdesc'] = 'Подесите боју линка за блок с леве стране';
$string['themestripebackgroundcolour'] = 'Боја позадине пруге';
$string['themestripebackgroundcolourdesc'] = 'Подесите боју позадине за пруге у табелама';
$string['themestripetextcolour'] = 'Боја текста пруге';
$string['themestripetextcolourdesc'] = 'Подесите боју текста за пруге у табелама';
$string['themestripeurlcolour'] = 'Боја URL линка унутар пруге';
$string['themestripeurlcolourdesc'] = 'Подесите боју URL линка унутар пруга у табелама';
$string['themetextcolor'] = 'Боја текста';
$string['themetextcolordesc'] = 'Подесите боју за ваш текст.';
$string['themeurlcolor'] = 'Боја линка';
$string['themeurlcolordesc'] = 'Подесите боју за текст линкова.';
$string['thiscourse'] = 'Овај курс';
$string['togglemarketing'] = 'Прекидач за приказ промотивних блокова';
$string['togglemarketingdesc'] = 'Изаберите да ли желите да сакријете или прикажете три промотивна блока.';
$string['toggleslideshow'] = 'Слајд-шоу - прекидач приказа';
$string['toggleslideshowdesc'] = 'Изаберите да ли желите да сакријете или прикажете слајд-шоу.';
$string['twitter'] = 'Twitter URL адреса';
$string['twitterdesc'] = 'Унесите URL адресу ваше Twitter странице (тј. http://www.twitter.com/mojaskola).';
$string['twitterurl'] = 'Twitter URL адреса';
$string['userimageborderradius'] = 'Полупречник ивице корисничке слике';
$string['userimageborderradiusdesc'] = 'Наведите полупречник ивице корисничке слике, између  {$a->lower} и {$a->upper} пиксела, на читавом сајту осим у заглављу које користи подешавање \'usermenuuserimageborderradius\'.';
$string['usermenu'] = 'Корисничко име';
$string['usermenudesc'] = 'Мени за корисника.';
$string['usermenuuserimageborderradius'] = 'Полупречник ивице слике у корисничком менију';
$string['usermenuuserimageborderradiusdesc'] = 'Наведите полупречник ивице слике у корисничком менију, између  {$a->lower} и {$a->upper} пиксела.';
$string['usersettingstitle'] = 'Корисничка подешавања';
$string['usesiteicon'] = 'Користи иконицу сајта';
$string['usesiteicondesc'] = 'Користите иконицу сајта ако не постоји лого.';
$string['variablewidth'] = 'Променљива ширина';
$string['versionalerttext1'] = 'Тема није дизајнирана за ову верзију Moodlea.';
$string['versionalerttext2'] = 'Могу се јавити неочекивани проблем, молимо, преузмите исправну верзију тему за вашу верзију Moodlea.';
$string['versionalerttitle'] = 'Упозорење о верзији:';
$string['visibleadminonly'] = 'Блокови премештени у доњи регион биће видљиви само администраторима';
$string['vk'] = 'VKontakte URL адреса';
$string['vkdesc'] = 'Унесите URL адресу ваше Vkontakte странице (тј. http://www.vk.com/mojaskola).';
$string['vkurl'] = 'VKontakte URL адреса';
$string['website'] = 'URL адреса веб сајта';
$string['websitedesc'] = 'Унесите URL адресу вашег главног веб сајта (тј. http://www.mojfakultet.ac.rs или http://www.mojaskola.edu.rs).';
$string['websiteurl'] = 'URL адреса веб сајта';
$string['windows'] = 'Windows стони рачунар';
$string['windowsdesc'] = 'Унесите URL адресу за вашу мобилну апликацију у Windows продавници. Уколико немате своју можете унети адресу бесплатне званичне Moodle Desktop апликације (https://www.microsoft.com/en-us/store/p/moodle-desktop/9p9bwvhdc8c8).';
$string['windowsurl'] = 'URL адреса апликације за Windows стони рачунар';
$string['winphone'] = 'Windows мобилни уређај';
$string['winphonedesc'] = 'Унесите URL адресу за вашу мобилну апликацију у Windows  продавници. Уколико немате своју можете унети адресу бесплатне званичне мобилне апликације за Moodle (https://www.microsoft.com/en-rs/store/p/moodlemobile/9wzdncrdk93x?rtc=1).';
$string['winphoneurl'] = 'URL адреса апликације за Windows мобилни уређај';
$string['within'] = 'Унутар';
$string['youtube'] = 'YouTube URL адреса';
$string['youtubedesc'] = 'Унесите URL адресу вашег YouTube канала (тј. http://www.youtube.com/mojaskola).';
$string['youtubeurl'] = 'YouTube URL адреса';
