<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'sr_cr', branch 'MOODLE_36_STABLE'
 *
 * @package   theme_adaptable
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'О мени';
$string['actingasrole'] = 'Тренутно имате другу улогу';
$string['activebreadcrumb'] = 'Боја позадине активне ставке навигационе путање';
$string['activebreadcrumbdesc'] = 'Подесите боју позадине тренутно активне ставке у навигационој путањи, као и остатка траке навигационе путање.';
$string['activitiesheading'] = 'Активности';
$string['alertaccess'] = 'Видљивост важног обавештења';
$string['alertaccessadmins'] = 'Видљиво администраторима';
$string['alertaccessdesc'] = 'Подесите тип ограничења приступа за видљивост оквира са важним обавештењем. Напомена: ако користите опцију ”Додај ограничење везано за прилагођено поље профила” мораћете да унесете вредности за поља профила у доње поље.';
$string['alertaccessglobal'] = 'Видљиво свима';
$string['alertaccessprofile'] = 'Додај ограничење везано за прилагођено поље профила';
$string['alertaccessusers'] = 'Видљиво пријављеним корисницима';
$string['alertannounce'] = 'Оглас';
$string['alertannouncedesc'] = 'Приказује оглас у оквиру за важна обавештења.';
$string['alertbackgroundcolorinfo'] = 'Информација - боја позадине';
$string['alertbackgroundcolorinfodesc'] = 'Боја позадине оквира за важна обавештења типа "Информација"';
$string['alertbackgroundcolorsuccess'] = 'Оглас - боја позадине';
$string['alertbackgroundcolorsuccessdesc'] = 'Боја позадине оквира за важна обавештења типа "Оглас"';
$string['alertbackgroundcolorwarning'] = 'Упозорење - боја позадине';
$string['alertbackgroundcolorwarningdesc'] = 'Боја позадине оквира за важна обавештења типа "Упозорење"';
$string['alertbordercolorinfo'] = 'Информација - боја бордуре';
$string['alertbordercolorinfodesc'] = 'Боја бордуре оквира за важна обавештења типа "Информација"';
$string['alertbordercolorsuccess'] = 'Оглас - боја бордуре';
$string['alertbordercolorsuccessdesc'] = 'Боја бордуре оквира за важна обавештења типа "Оглас"';
$string['alertbordercolorwarning'] = 'Упозорење - боја бордуре';
$string['alertbordercolorwarningdesc'] = 'Боја бордуре оквира за важна обавештења типа "Упозорење"';
$string['alertcolorinfo'] = 'Информација - боја иконице';
$string['alertcolorinfodesc'] = 'Боја иконице оквира за важна обавештења типа "Информација"';
$string['alertcolorsheading'] = 'Прилагодите оквире са важним обавештењем на врху странице';
$string['alertcolorsheadingdesc'] = 'Подесите боје и иконице';
$string['alertcolorsuccess'] = 'Оглас - боја иконице';
$string['alertcolorsuccessdesc'] = 'Боја иконице оквира за важна обавештења типа "Оглас"';
$string['alertcolorwarning'] = 'Упозорење - боја иконице';
$string['alertcolorwarningdesc'] = 'Боја иконице оквира за важна обавештења типа "Упозорење"';
$string['alertcount'] = 'Број важних обавештења';
$string['alertcountdesc'] = 'Број важних обавештење који се приказује у наставку ове странице за уређивање.';
$string['alertdesc'] = 'Унесите и прилагодите текст који ће бити приказан на врху сајта као важно обавештење. Могуће је подесити више од једног важног обавештења, тако да свако буде намењено различитим типовима корисника. Такође, имате могућност да обавештења прикажете на читавом сајту или само на насловној страници. <br /><br /><strong>Напомена:</strong> Сада је могуће приказати важно обавештење на страницама курса како бисте упозорили предаваче да су курсеви скривени.';
$string['alertdisabled'] = 'Онемогућено';
$string['alertdisabledesc'] = 'Онемогући ово важно обавештење.';
$string['alerthiddencourse'] = 'Упозорење о скривеном курсу';
$string['alerthiddencoursedesc'] = 'Приказује важно обавештење на страници курса ако је курс скривен';
$string['alerthiddencoursetext-1'] = 'Овај курс је скривен и полазници не могу да му приступе.';
$string['alerthiddencoursetext-2'] = 'Кликните овде да бисте ажурирали подешавања';
$string['alerticoninfo'] = 'Иконица "Информација"';
$string['alerticoninfodesc'] = 'Подесите <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome иконицу</a> која ће се користити за важна обавештења типа "Информација". Унесите назив иконице без префикса fa-.';
$string['alerticonsuccess'] = 'Иконица "Оглас"';
$string['alerticonsuccessdesc'] = 'Подесите <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome иконицу</a> која ће се користити за важна обавештења типа "Оглас". Унесите назив иконице без префикса fa-.';
$string['alerticonwarning'] = 'Иконица "Упозорење"';
$string['alerticonwarningdesc'] = 'Подесите <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome иконицу</a> која ће се користити за важна обавештења типа "Уозорење". Унесите назив иконице без префикса fa-.';
$string['alertinfo'] = 'Информација';
$string['alertinfodesc'] = 'Приказује информацију у оквиру за важна обавештења.';
$string['alertkeyvalue'] = 'Кључ важног обавештења';
$string['alertkeyvalue_details'] = 'Кључ који разликује ово важно обавештење од претходних. Ако промените овај кључ, сви корисници који су претходно одбацили обавештење, видеће га поново. Ако измените обавештење, вероватно ћете хтети да промените и кључ како бисте били сигурни да ће корисници видети обавештење.';
$string['alertprofilefield'] = 'Назив прилагођеног поља профила=вредност (опционо)';
$string['alertprofilefielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: "usertype=student"';
$string['alertsettings'] = 'Оквир са важним обавештењем {$a}';
$string['alertsettingscourse'] = 'Подешавања важних обавештења на курсу';
$string['alertsettingsgeneral'] = 'Општа подешавања важних обавештења';
$string['alertsettingsheading'] = 'Прилагодите оквир са важним обавештењем на врху странице. Погледајте пример распореда елемената на страници <a href="./../theme/adaptable/pix/layout.png" target="_blank">овде</a>';
$string['alerttext'] = 'Текст важног обавештења';
$string['alerttextdesc'] = 'Унети текст који ће бити приказан у оквиру са важним обавештењем.';
$string['alerttype'] = 'Тип оквира са важним обавештењем';
$string['alerttypedesc'] = 'Изаберите тип обавештења: информација (плаво), упозорење (жуто) или оглас (зелено).';
$string['alertwarning'] = 'Упозорење';
$string['alertwarningdesc'] = 'Приказује упозорење у оквиру за важна обавештења.';
$string['analyticscount'] = 'Број поља аналитике';
$string['analyticscountdesc'] = 'Број поља аналитике који се приказује у наставку ове странице за уређивање.';
$string['analyticsprofilefield'] = 'Назив прилагођеног поља профила=вредност (опционо)';
$string['analyticsprofilefielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: "usertype=student"';
$string['analyticssettings'] = 'Аналитика';
$string['analyticssettingsdesc'] = 'Можете да подесите више кôдова за Google Analytics и повежете их са пољима корисничких профила. Такође можете да користите Piwik, алат за аналитику, отвореног кôда.';
$string['analyticssettingsheading'] = 'Подешавање за Google Analytics и/или Piwik';
$string['analyticstext'] = 'ID ознака за Google Analytics';
$string['analyticstextdesc'] = 'Унесите ID ознаку за Google Analytics.';
$string['anonymizega'] = 'Сакриј корисничку IP адресу';
$string['anonymizegadesc'] = 'Сакриј корисничку IP адресу пре слања података за Google Analytics';
$string['answered'] = 'Одговорено';
$string['attempted'] = 'Покушано';
$string['backcolor'] = 'Боја позадине';
$string['backcolordesc'] = 'Подесите боју позадине.';
$string['bcustyle'] = 'BCU стил';
$string['beta'] = 'РАЗВОЈНА ВЕРЗИЈА. НЕМОЈТЕ ЈЕ КОРИСТИТИ НА ПРОДУКЦИОНИМ САЈТОВИМА';
$string['blockbackgroundcolor'] = 'Боја позадине блока';
$string['blockbackgroundcolordesc'] = 'Подесите боју позадине за све блокове.';
$string['blockbordercolor'] = 'Боја бордуре блока';
$string['blockbordercolordesc'] = 'Подесите боју бордуре блока.';
$string['blockheaderbackgroundcolor'] = 'Боја позадине наслова блока';
$string['blockheaderbackgroundcolordesc'] = 'Подесите боју позадине наслова за све блокове.';
$string['blockheaderborderbottom'] = 'Дебљина доње бордуре заглавља блока';
$string['blockheaderborderbottomdesc'] = 'Подесите дебљину доње бордуре заглавља блокова.';
$string['blockheaderborderleft'] = 'Дебљина леве бордуре заглавља блока';
$string['blockheaderborderleftdesc'] = 'Подесите дебљину леве бордуре заглавља блокова.';
$string['blockheaderborderright'] = 'Дебљина десне бордуре заглавља блока';
$string['blockheaderborderrightdesc'] = 'Подесите дебљину десне бордуре заглавља блокова.';
$string['blockheaderbordertop'] = 'Дебљина горње бордуре заглавља блока';
$string['blockheaderbordertopdesc'] = 'Подесите дебљину горње бордуре заглавља блокова.';
$string['blockheaderbordertopstyle'] = 'Стил бордура заглавља блокова';
$string['blockheaderbordertopstyledesc'] = 'Подесите стил бордура заглавља блокова.';
$string['blockheaderbottomradius'] = 'Доњи полупречник заглавља блока';
$string['blockheaderbottomradiusdesc'] = 'Подесите доњи полупречник заглавља блока како бисте постигли ефекат закривљености/заобљености.';
$string['blockheadercolor'] = 'Боја текста заглавља блока';
$string['blockheadercolordesc'] = 'Подесите боју текста заглавља блока.';
$string['blockheadertopradius'] = 'Горњи полупречник заглавља блока';
$string['blockheadertopradiusdesc'] = 'Подесите горњи полупречник заглавља блока како бисте постигли ефекат закривљености/заобљености.';
$string['blockicons'] = 'Иконице блока';
$string['blockiconsdesc'] = 'Подесите ово како би иконице блокова биле приказане у заглављу блока.';
$string['blockiconsheadersize'] = '';
$string['blocklayoutbuilder'] = 'Региони насловне странице са блоковима';
$string['blocklayoutbuilderdesc'] = 'Испод можете да направите свој распоред региона са блоковима на насловној страници. Да бисте додали садржај у ове регионе мораћете да <strong> укључите уређивање на насловној страници вашег Moodle сајта</strong>.
Након тога можете да превлачите и спуштате блокове у регионе које сте креирали.';
$string['blocklayoutlayoutcheck'] = 'Проверите свој распоред блокова';
$string['blocklayoutlayoutcheckdesc'] = 'Употребите алат у наставку како бисте проверили број блокова које користите и видели како изгледа ваш нови распоред блокова.';
$string['blocklayoutlayoutcount1'] = 'Можете да подесите највише';
$string['blocklayoutlayoutcount2'] = 'регион/a са блоковима. Тренутно користите:';
$string['blocklayoutlayoutrow'] = 'Ред региона са блоковима';
$string['blocklayoutlayoutrowdesc'] = 'Додајте / подесите распоред блокова у реду региона са блоковима на насловној страници.';
$string['blockmainborderbottom'] = 'Дебљина доње бордуре тела блока';
$string['blockmainborderbottomdesc'] = 'Подесите дебљину доње бордуре тела блока';
$string['blockmainborderleft'] = 'Дебљина леве бордуре тела блока';
$string['blockmainborderleftdesc'] = 'Подесите дебљину леве бордуре тела блока';
$string['blockmainborderright'] = 'Дебљина десне бордуре тела блока';
$string['blockmainborderrightdesc'] = 'Подесите дебљину десне бордуре тела блока';
$string['blockmainbordertop'] = 'Дебљина горње бордуре тела блока';
$string['blockmainbordertopdesc'] = 'Подесите дебљину горње бордуре тела блока';
$string['blockmainbordertopstyle'] = 'Стил бордура тела блока';
$string['blockmainbordertopstyledesc'] = 'Подесите стил бордура тела блока';
$string['blockmainbottomradius'] = 'Доњи полупречник тела блока';
$string['blockmainbottomradiusdesc'] = 'Подесите доњи полупречник тела блока како бисте постигли ефекат закривљености/заобљености';
$string['blockmaintopradius'] = 'Горњи полупречник тела блока';
$string['blockmaintopradiusdesc'] = 'Подесите горњи полупречник тела блока како бисте постигли ефекат закривљености/заобљености';
$string['blockregionbackground'] = 'Боја позадине региона блокова';
$string['blockregionbackgrounddesc'] = 'Боја позадине контејнера који садржи прилагођени распоред блокова на насловној страници';
$string['blocksettings'] = 'Подешавања блокова';
$string['blockside'] = 'Позиција блокова';
$string['blocksidedesc'] = 'Контролише да ли се блокови на страници појављују лево или десно';
$string['breadcrumb'] = 'Боја позадине навигационе путање';
$string['breadcrumbbackgroundcolor'] = 'Боја позадине навигационе траке';
$string['breadcrumbbackgroundcolordesc'] = 'Подесите боју позадине навигационе траке.';
$string['breadcrumbhome'] = 'Ознака почетне странице у навигационој путањи';
$string['breadcrumbhomedesc'] = 'Приказује ознаку за почетну страницу у навигационој путањи као иконицу или као текст.';
$string['breadcrumbhomeicon'] = 'Иконица';
$string['breadcrumbhometext'] = 'Текст';
$string['breadcrumbseparator'] = 'Граничник навигационе путање';
$string['breadcrumbseparatordesc'] = 'Подесите <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome иконицу</a> која ће се користити као граничник у навигационој траци. Унесите назив иконице без префикса fa-.';
$string['breadcrumbtextcolor'] = 'Боја текста навигационе путање';
$string['breadcrumbtextcolordesc'] = 'Подесите боју текста навигационе путање.';
$string['breadcrumbtitle'] = 'Назив курса у навигационој путањи';
$string['breadcrumbtitledesc'] = 'Подесите начин на који ће назив курса бити приказан у навигационој путањи.';
$string['buttoncolor'] = 'Боја дугмета';
$string['buttoncolordesc'] = 'Боја главне дугмади која се користе на читавом сајту.';
$string['buttondesc'] = 'Промените изглед дугмади која се користе у овој теми.';
$string['buttonhovercolor'] = 'Лебдећа боја дугмета';
$string['buttonhovercolordesc'] = 'Боја дугмета када се мишем пређе преко њега';
$string['buttonlogincolor'] = 'Боја дугмета за пријаву';
$string['buttonlogincolordesc'] = 'Боја дугмета за пријаву на систем.';
$string['buttonloginheight'] = 'Подеси висину дугмета за пријаву';
$string['buttonloginheightdesc'] = 'Ово подешавање има ефекта само ако се користи образац за пријаву на систем у горњем заглављу';
$string['buttonloginhovercolor'] = 'Лебдећа боја дугмета за пријаву';
$string['buttonloginhovercolordesc'] = 'Боја дугмета за пријаву на систем када се мишем пређе преко њега';
$string['buttonloginmargintop'] = 'Подеси горњу маргину дугмета за пријаву';
$string['buttonloginmargintopdesc'] = 'Омогућава да растојање дугмета за пријаву од горње ивице, односно његово позиција буде промењена';
$string['buttonloginpadding'] = 'Подеси размак између ивице и текста дугмета за пријаву';
$string['buttonloginpaddingdesc'] = 'Већи број = веће дугме';
$string['buttonlogintextcolor'] = 'Боја текста дугмета за пријаву';
$string['buttonlogintextcolordesc'] = 'Боја текста који се користи на дугмету за пријаву на систем.';
$string['buttonradius'] = 'Подеси полупречник дугмета';
$string['buttonradiusdesc'] = 'Већи полупречник = закривљена дугмад, мањи полупречник = четвртаста дугмад,';
$string['buttonsettings'] = 'Дугмад';
$string['buttonsettingsheading'] = 'Подесите дугмад у овој теми';
$string['buttontextcolor'] = 'Боја текста дугмета';
$string['buttontextcolordesc'] = 'Боја текста за сву дугмад на читавом сајту';
$string['cachedef_userdata'] = 'Кеш меморија сесије која се користи за складиштење података специфичних за кориснике.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
<h2>Заслуге</h2>
<h3>О теми</h3>
<p>Adaptable је Moodle прилагодљива тема са два ступца, и са великим бројем опција за прилагођавање. Тема се базира на популарној BCU теми.</p>
<p>Ова тема је објављена под GPL  лиценцом (GNU General Public License). Комплетну копију лиценце можете наћи на: http://www.gnu.org/licenses/</p>
<p>Мењајте је / Унапређујте / Делите</p>
<br>
<p>Ову тему су развили:<br>
Jeremy Hopkins (Coventry University)<br>
Fernando Acedo (3-bits.com)<br>
</p>
<br>
 <p>и многи други програмери, тестери, преводиоци и волонтери (See <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p>
<br>
<h3>Извештај о грешкама</h3>
<p>Грешке можете пријавити (и молимо вас, <b>САМО</b> грешке) на нашем <a href="https://bitbucket.org/covuni/moodle-theme_adaptable/issues" target="_blank">Bitbucket репозиторијуму</a></p>
<br>
<h3>Техничка подршка</h3>
<p>Можете постављати своја питања и недоумице, и делити своје савете на Moodle форуму:</p>
<ul>
<li>English: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a>
<li>Español: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a>
<li>Català: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a>
</ul>
<br>
<h3>Документација</h3>
<p>Ускоро</p>
<br>
<h3>Демо</h3>
<p>Демо верзију теме можете видети <a href="http://3-bits.com/demo/adaptable" target="_blank">ОВДЕ</a></p>
<br>
</div>
</div>';
$string['colordesc'] = 'Можете да изаберете боје које желите да користите у оквиру ове теме. Користите хексадецималну или било коју другу стандардну нотацију. Алтернативно, можете да користите вредности "transparent" или "inherited"';
$string['colorsettings'] = 'Боје';
$string['colorsettingsheading'] = 'Измените главне боје које се користе у овој теми.';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Курс';
$string['coursepageblocklayoutbuilder'] = 'Региони блокова на страници курса';
$string['coursepageblocklayoutbuilderdesc'] = 'Испод можете да направите свој распоред региона са блоковима на страници курса.
Да бисте додали садржај у ове регионе мораћете да <strong> укључите уређивање на страници курса</strong>.
Након тога можете да превлачите и спуштате блокове у регионе које сте креирали.';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Ред региона са блоковима на дну странице курса';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Додајте / подесите распоред блокова у реду региона са блоковима на страници курса.';
$string['coursepageblocklayoutlayouttoprow'] = 'Ред региона са блоковима на врху странице курса';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Додајте / подесите распоред блокова у реду региона са блоковима на страници курса.';
$string['coursepageblockregionsettings'] = 'Алат за креирање региона блокова на страници курса';
$string['coursepageblocksenabled'] = 'Омогући прилагођене регионе са блоковима на страници курса';
$string['coursepageblocksenableddesc'] = 'Можете да омогућите / онемогућите прилагођене регионе са блоковима (горњи и доњи) на страници курса.
Затим можете да превучете и спустите блокове у регионе које сте креирали';
$string['coursepageheaderhidesitetitle'] = 'Сакриј назив сајта на страницама курса';
$string['coursepageheaderhidesitetitledesc'] = 'Сакријте назив сајта, лого и поље за претрагу на страницама курса. Користите ово заједно са подешавањем висине заглавља странице како бисте приказали мање заглавље на страницама курса.';
$string['coursepagesidebarinfooterenabled'] = 'Премести бочни стубац са блоковима у подножје странице курса';
$string['coursepagesidebarinfooterenableddesc'] = 'Премештањем ступца са блоковима у подножје странице, део странице курса са секцијама ће се проширити.';
$string['coursepagesidebarinfooterenabledsection'] = 'Положај бочног ступца са блоковима';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Прикажите странице курса преко целог екрана пребацивањем бочног ступца са блоковима у подножје.';
$string['coursesectionactivityassignbgcolor'] = 'Боја позадине "Задатка"';
$string['coursesectionactivityassignbgcolordesc'] = 'Подесите боју позадине за активност "Задатак".';
$string['coursesectionactivityborderwidth'] = 'Ширина бордуре активности унутар секције курса';
$string['coursesectionactivityborderwidthdesc'] = 'Подесите ширину бордуре активности (Форум, Тест, Задатак) унутар секције курса.';
$string['coursesectionactivitycolors'] = 'Подешавања активности унутар секције курса';
$string['coursesectionactivityforumbgcolor'] = 'Боја позадине "Форума"';
$string['coursesectionactivityforumbgcolordesc'] = 'Подесите боју позадине за активност "Форум".';
$string['coursesectionactivityiconsize'] = 'Величина иконица активности';
$string['coursesectionactivityiconsizedesc'] = 'Подесите величину иконица за активности / ресурсе (нпр. вредност "16px" ће подесити димензије иконица на величину 16 x 16 пиксела).';
$string['coursesectionactivityquizbgcolor'] = 'Боја позадине "Теста"';
$string['coursesectionactivityquizbgcolordesc'] = 'Подесите боју позадине за активност "Тест".';
$string['coursesectionactivityuseadaptableicons'] = 'Користи скуп иконица теме Adaptable';
$string['coursesectionactivityuseadaptableiconsdesc'] = 'Укључите ово како бисте користили иконице теме Adaptable. Ако је ова опција искључена, уклоните директоријуме adaptable/pix_plugins and adaptable/pix_core/f како бисте користили стандардне Moodle иконице.';
$string['coursesectionbgcolor'] = 'Позадина секције курса';
$string['coursesectionbgcolordesc'] = 'Подесите боју позадине секције курса.';
$string['coursesectionbordercolor'] = 'Боја бордура секције курса';
$string['coursesectionbordercolordesc'] = 'Подесите боју бордура секција курса';
$string['coursesectionborderradius'] = 'Полупречник бордура секције';
$string['coursesectionborderradiusdesc'] = 'Подесите полупречник бордура секције курса (заобљени углови)';
$string['coursesectionborderstyle'] = 'Стил бордура секције';
$string['coursesectionborderstyledesc'] = 'Подесите стил бордура секције курса';
$string['coursesectionborderwidth'] = 'Ширина бордура секције';
$string['coursesectionborderwidthdesc'] = 'Подесите ширину бордура секција курса';
$string['coursesectionheaderbg'] = 'Позадина заглавља секције';
$string['coursesectionheaderbgdesc'] = 'Подесите боју позадине заглавља секције курса';
$string['coursesectionheaderbordercolor'] = 'Боја бордуре заглавља секције';
$string['coursesectionheaderbordercolordesc'] = 'Подесите боју бордуре заглавља секције (користи се само доња бордура пошто спољашњи контејнер има бордуру)';
$string['coursesectionheaderborderradiusbottom'] = 'Доњи полупречник бордуре заглавља секције';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Подесите доњи полупречник бордуре заглавља секције (заобљени углови)';
$string['coursesectionheaderborderradiustop'] = 'Горњи полупречник бордуре заглавља секције';
$string['coursesectionheaderborderradiustopdesc'] = 'Подесите горњи полупречник бордуре заглавља секције (заобљени углови)';
$string['coursesectionheaderborderstyle'] = 'Стил бордуре заглавља секције курса';
$string['coursesectionheaderborderstyledesc'] = 'Подесите стил бордуре заглавља секције курса (само доња бордура се користи пошто спољашњи контејнер такође име бордуру)';
$string['coursesectionheaderborderwidth'] = 'Ширина бордуре заглавља секције курса';
$string['coursesectionheaderborderwidthdesc'] = 'Подесите ширину бордуре заглавља секције курса (само доња бордура се користи пошто спољашњи контејнер такође име бордуру)';
$string['coursesettings'] = 'Формати курса';
$string['coursesettingsdesc'] = 'Прилагодите неке од најчешће коришћених формата Moodle курсева како би одговарали главном дизајну.';
$string['coursesettingsheading'] = 'Подешавања формата курса';
$string['coursetitlemaxwidth'] = 'Максимална ширина наслова курса';
$string['coursetitlemaxwidthdesc'] = 'Подесите максималну ширину региона са насловом курса';
$string['coursetitlepaddingleft'] = 'Удаљеност наслова курса од леве ивице';
$string['coursetitlepaddingleftdesc'] = 'За подешавање положаја наслова курса одредите његову удаљеност  од леве ивице';
$string['coursetitlepaddingtop'] = 'Удаљеност наслова курса од горње ивице';
$string['coursetitlepaddingtopdesc'] = 'За подешавање положаја наслова курса одредите његову удаљеност од горње ивице';
$string['covbkcolor'] = 'Боја позадине наслова на Ковентри плочицама';
$string['covbkcolordesc'] = 'Подесите боју позадине наслова када су изабране Ковентри плочице';
$string['coventrystyle'] = 'Ковентри стил';
$string['covfontcolor'] = 'Боја слова наслова на Ковентри плочицама';
$string['covfontcolordesc'] = 'Подесите боју слова наслова када су изабране Ковентри плочице';
$string['covhidebutton'] = 'Дугме курса на Ковентри плочицама';
$string['covhidebuttondesc'] = 'Подесите ову опцију како бисте сакрили дугме за курс када су изабрана Ковентри плочице.';
$string['currentcolor'] = 'Боја наглашавања текуће секције курса';
$string['currentcolordesc'] = 'Подесите боју којом ће бити наглашена текућа секција курса';
$string['customcss'] = 'Прилагођени CSS';
$string['customcssdesc'] = 'CSS правила која додате у ово поље за текст одразиће се на изглед свих страница, што олакшава прилагођавање ове теме.';
$string['customcssjssettings'] = 'Прилагођени CSS & JS';
$string['dashblocklayoutbuilder'] = 'Региони контролног панела са блоковима';
$string['dashblocklayoutbuilderdesc'] = 'Испод можете да направите свој распоред региона са блоковима на страници "Контролни панел".
Да бисте додали садржај у ове регионе мораћете да <strong> укључите уређивање на насловној страници вашег Moodle сајта</strong>.
Након тога можете да превлачите и спуштате блокове у регионе које сте креирали.';
$string['dashblocklayoutlayoutrow'] = 'Ред региона са блоковима на контролном панелу';
$string['dashblocklayoutlayoutrowdesc'] = 'Додајте / подесите распоред блокова у реду региона са блоковима на страници "Контролни панел".';
$string['dashblocksenabled'] = 'Омогући прилагођени регион са блоковима на страници "Контролни панел"';
$string['dashblocksenableddesc'] = 'Можете да омогућите / онемогућите прилагођени регион са блоковима на страници "Контролни панел".
Затим можете да превучете и спустите блокове у регионе које сте креирали';
$string['dashboardblockregionsettings'] = 'Алат за креирање региона блокова на контролном панелу';
$string['deprecated'] = 'MOODLE  ЗАСТАРЕЛА ВЕРЗИЈА. НЕМОЈТЕ КОРИСТИТИ ТЕМУ ADAPTABLE НА ОВОМ САЈТУ';
$string['disablecustommenu'] = 'Онемогући Moodle прилагођени мени';
$string['disablecustommenudesc'] = 'Ово ће онемогућити Moodle прилагођени мени у навигационој траци (мени ће и даље бити видљив у другим темама које сте инсталирали)';
$string['disabled'] = 'Онемогућено';
$string['disablemenuscoursepages'] = 'Онемогући меније на страницама курса';
$string['disablemenuscoursepagesdesc'] = 'Укључивање ове опције ће ограничити приказ горњих менија на страницама сајта, почетној страници, контролном панелу (Моја почетна страница) итд. Такође, они неће бити приказани на било којој страници курса.';
$string['discardbuttontext'] = 'Откажи';
$string['displaylogin'] = 'Приказ пријаве на сајт';
$string['displayloginbox'] = 'Поља за пријаву';
$string['displayloginbutton'] = 'Дугме';
$string['displaylogindesc'] = 'Изаберите како да се на екрану прикаже пријава на сајт (када је горе омогућено).';
$string['displayloginno'] = 'Без пријаве';
$string['dividingline'] = 'Линија раздвајања у заглављу';
$string['dividingline2'] = 'Линија раздвајања у подножју';
$string['dividingline2desc'] = 'Боја за линију раздвајања која се налази у подножју странице';
$string['dividinglinedesc'] = 'Боја за линију раздвајања која се налази у заглављу странице';
$string['editfont'] = 'Боја фонта дугмета ”Уреди и прилагоди ову страницу”';
$string['editfontdesc'] = 'Подесите боју фонта на дугмету ”Уреди и прилагоди ову страницу”';
$string['edithorizontalpadding'] = 'Подеси хоризонтални размак између ивице и текста дугмади за уређивање';
$string['editoffbk'] = 'Боја фонта дугмета за искључивање ”Уреди и прилагоди ову страницу”';
$string['editoffbkdesc'] = 'Подесите боју фонта на дугмету за искључивање режима \'Уреди и прилагоди ову страницу\'';
$string['editonbk'] = 'Боја позадине дугмета ”Уреди и прилагоди ову страницу”';
$string['editonbkdesc'] = 'Подесите боју позадине дугмета \'Уреди и прилагоди ову страницу\'';
$string['editverticalpadding'] = 'Подеси вертикални размак између ивице и текста дугмади за уређивање';
$string['emoticonsize'] = 'Величина емотикона';
$string['emoticonsizedesc'] = 'Подесите висину и ширину Moodle емотикона.';
$string['enablealert'] = 'Омогући оквир са важним обавештењем {$a}';
$string['enablealertcoursepages'] = 'Омогући оквир са важним обавештењем на страницама курса';
$string['enablealertcoursepagesdesc'] = 'Ако укључите ову опцију на врху страница курса биће приказан оквир са важним обавештењем';
$string['enablealertdesc'] = 'Омогући оквир са важним обавештењем {$a}';
$string['enablealerts'] = 'Омогући / Онемогући важна обавештења';
$string['enablealertsdesc'] = 'Омогућите односно онемогућите приказивање важних обавештења на вашем сајту';
$string['enablealertstriptags'] = 'Уклони аутоматски html ознаке из обавештења';
$string['enablealertstriptagsdesc'] = 'Ако омогућите ову опцију из обавештења ће аутоматски бити уклоњене html ознаке. Ако пак онемогућите ову опцију, онда ћете моћи да користите html ознаке/линкове у својим обавештењима, али ћете морати ручно да их уклонити у html приказу.';
$string['enableanalytics'] = 'Омогући Google Analytics';
$string['enableanalyticsdesc'] = 'Омогућите  подешавања за Google Analytics на свом Moodle сајту';
$string['enableavailablecourses'] = 'Прикажи "Доступни курсеви"';
$string['enableavailablecoursesdesc'] = 'Приказује натпис ”Доступни курсеви” на насловној страници';
$string['enablebadges'] = 'Беџеви';
$string['enablebadgesdesc'] = 'Приказује линк ка беџевима корисника';
$string['enableblog'] = 'Моји блогови';
$string['enableblogdesc'] = 'Приказује линк ка страницама блогова корисника';
$string['enablecalendar'] = 'Кориснички календар';
$string['enablecalendardesc'] = 'Приказује линк ка календару корисника';
$string['enableeditprofile'] = 'Уреди профил';
$string['enableeditprofiledesc'] = 'Приказује линк за уређивање профила корисника';
$string['enableeventsdesc'] = 'Приказује линк ка календару';
$string['enablefeed'] = 'Моје повратне информације';
$string['enablefeeddesc'] = 'Приказује линк ка страници корисника ”Моје повратне информације” - напомена: ово захтева <a href="https://moodle.org/plugins/report_myfeedback" target="blank">додатак ”Моје повратне информације”</a>';
$string['enablegrades'] = 'Оцене';
$string['enablegradesdesc'] = 'Приказује линк ка оценама корисника';
$string['enableheading'] = 'Заглавље са насловом курса';
$string['enableheadingdesc'] = 'Подесите режим за приказ наслова курса у заглављу када је омогућен подразумеван наслов Moodle сајта.';
$string['enablehelp'] = 'Линк за помоћ';
$string['enablehelpdesc'] = 'Додајте линк за помоћ у навигациону траку.';
$string['enablehomedesc'] = 'Приказује линк ка насловној страници.';
$string['enablehomeredirect'] = 'Омогући редирекцију (redirect=0) ка насловној страници';
$string['enablehomeredirectdesc'] = 'Омогућите редирекцију (redirect=0) ка насловној страници. Ово се користи на сајтовима на којима је као подразумевана почетна страница постављена ”Моја почетна страница / Контролни панел”. Ово ће спречити да корисник, када кликне на линк ”Почетна страница”, буде преусмерен на ”Моја почетна страница / Контролни панел”.';
$string['enablemenus'] = 'Омогући меније';
$string['enablemenusdesc'] = 'Препоручује се да ово оставите искључено, ако се менији не користе због перформанси система';
$string['enablemy'] = 'Моја почетна страница';
$string['enablemydesc'] = 'Приказује линк ка ”Моја почетна страница”';
$string['enablemyhomedesc'] = 'Приказује линк ка {$a}';
$string['enablemysitesdesc'] = 'Приказује падајући мени са курсевима корисника';
$string['enablenote'] = 'Моја обавештења';
$string['enablenotedesc'] = 'Приказује линк ка страници са обавештењима за корисника';
$string['enableposts'] = 'Моји постови';
$string['enablepostsdesc'] = 'Приказује линк ка страници ”Моји постови”';
$string['enablepref'] = 'Моја подешавања';
$string['enableprefdesc'] = 'Приказује линк ка страници са преферисаним подешавањима корисника';
$string['enableprivatefiles'] = 'Приватне датотеке';
$string['enableprivatefilesdesc'] = 'Приказује линк ка ка приватним датотекама корисника';
$string['enableprofile'] = 'Кориснички профил';
$string['enableprofiledesc'] = 'Приказује линк ка профилу корисника';
$string['enablesearchbox'] = 'Омогући поље за претрагу';
$string['enablesearchboxdesc'] = 'Приказује поље за претрагу у заглављу';
$string['enableshowhideblocks'] = 'Омогући прекидач ”Прикажи/Сакриј блокове”';
$string['enableshowhideblocksdesc'] = 'Омогућава корисницима да прикажу/сакрију све блокове.';
$string['enablethiscoursedesc'] = 'Приказује падајући мени са активностима из текућег курса';
$string['enableticker'] = 'Омогући покретну траку са вестима на почетној страници';
$string['enabletickerc'] = 'Омогући покретну траку са вестима на интерним страницама';
$string['enabletickercdesc'] = 'Означите ово како бисте омогућили покретну траку са вестима на интерним страницама.';
$string['enabletickerdesc'] = 'Означите ово како бисте омогућили покретну траку са вестима на почетној страници.';
$string['enabletickermy'] = 'Омогући покретну траку са вестима на ”Моја почетна страница / Контролни панел”';
$string['enabletickermydesc'] = 'Означите ово како бисте омогућили покретну траку са вестима на ”Моја почетна страница / Контролни панел”.';
$string['enabletoolsmenus'] = 'Омогући меније ”Алати”';
$string['enabletoolsmenusdesc'] = 'Препоручује се да ово оставите искључено, ако се менији не користе због перформанси система';
$string['enablezoom'] = 'Омогући зумирање';
$string['enablezoomdesc'] = 'Дозвољава корисницима да мењају приказ странице (између приказа преко целог екрана и приказа фиксне ширине).';
$string['events'] = 'Догађаји';
$string['favicon'] = 'Фавиконица';
$string['favicondesc'] = 'Поставите фавиконицу која ће се користити на вашем сајту';
$string['fontblockheadercolor'] = 'Боја фонта заглавља блокова';
$string['fontblockheadercolordesc'] = 'Подесите боју фонта заглавља у Moodle блоковима, користећи html хексадецимални кôд.';
$string['fontblockheadersize'] = 'Величина фонта заглавља блокова';
$string['fontblockheadersizedesc'] = 'Подесите величину фонта који се користи у заглављу Moodle блокова. Изаберите вредност са списка.';
$string['fontblockheaderweight'] = 'Дебљина фонта заглавља блокова';
$string['fontblockheaderweightdesc'] = 'Подесите дебљину фонта који се користи у заглављу Moodle блокова. Изаберите вредност са списка.';
$string['fontcolor'] = 'Боја главног фонта';
$string['fontcolordesc'] = 'Подесите боју фонта у теми, користећи html хексадецимални кôд.';
$string['fontdesc'] = 'Можете да изаберете <a href="https://www.google.com/fonts" target="_blank">Google фонтове</a> које желите да користите у оквиру теме. Изаберите жељени подскуп карактера (латинични је увек укључен) и унесите одговарајућу дебљину фонта, иначе фонт неће бити приказан.';
$string['fontheadercolor'] = 'Боја фонта заглавља';
$string['fontheadercolordesc'] = 'Подесите боју фонта заглавља у теми, користећи html хексадецимални кôд.';
$string['fontheadername'] = 'Фонт заглавља';
$string['fontheadernamedesc'] = 'Изаберите подразумевани фонт или <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> који ће се користити за заглавља у тексту, као и у заглављима блокова.';
$string['fontheaderweight'] = 'Дебљина фонта заглавља';
$string['fontheaderweightdesc'] = 'Дебљина фонта заглавља који се користе на сајту. Изаберите вредност до 100 до 900, зависно од изабраног фонта.';
$string['fontname'] = 'Главни фонт';
$string['fontnamedesc'] = 'Изаберите подразумевани фонт или <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> који ће се користити на сајту.';
$string['fontsettings'] = 'Фонтови';
$string['fontsettingsheading'] = 'Измените фонтове који се користе у оквиру теме.';
$string['fontsize'] = 'Величина главног фонта';
$string['fontsizedesc'] = 'Изаберите подразумевану величину фонта (у процентима) која се користи на читавом сајту.';
$string['fontsubset'] = 'Подскуп Google фонтова';
$string['fontsubsetdesc'] = 'Изаберите који ће се други подскуп карактера, поред латиничног, примењивати на све фонтове. Латинични подскуп је стандардно већ укључен.';
$string['fonttitlecolor'] = 'Боја фонта наслова сајта /курса';
$string['fonttitlecolorcourse'] = 'Боја фонта наслова курса';
$string['fonttitlecolorcoursedesc'] = 'Подесите боју фонта наслова курса у теми, користећи html хексадецимални кôд.';
$string['fonttitlecolordesc'] = 'Подесите боју фонта наслова сајта и наслова курса у теми, користећи html хексадецимални кôд.';
$string['fonttitlename'] = 'Фонт наслова сајта / курса';
$string['fonttitlenamedesc'] = 'Изаберите подразумевани фонт или <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> који ће се користити за наслов сајта и наслове курсева.';
$string['fonttitlesize'] = 'Величина фонта наслова сајта / курса';
$string['fonttitlesizedesc'] = 'Величина фонта наслова сајта и наслова курса који се користи на сајту. Изаберите вредност са списка.';
$string['fonttitleweight'] = 'Дебљина фонта наслова сајта / курса';
$string['fonttitleweightdesc'] = 'Подесите дебљину фонта који се користи за наслов сајта и наслове курсева. Изаберите вредност до 100 до 900, зависно од изабраног фонта.';
$string['fontweight'] = 'Дебљина главног фонта';
$string['fontweightdesc'] = 'Подесите дебљину фонта који се користи се на сајту. Изаберите вредност до 100 до 900, зависно од изабраног фонта.';
$string['footerbkcolor'] = 'Боја позадине подножја';
$string['footerbkcolordesc'] = 'Подесите боју позадине у подножју странице.';
$string['footerblocksplacement'] = 'Појављивање блокова подножја';
$string['footerblocksplacement1'] = 'На читавом сајту';
$string['footerblocksplacement2'] = 'Само почетна страница';
$string['footerblocksplacement3'] = 'Нигде';
$string['footerblocksplacementdesc'] = 'Ово подешавање контролише где ће се приказивати горњи блокови подножја. Подразумевана вредност је \'На читавом сајту\'.';
$string['footercontent'] = 'Секција са садржајем подножја';
$string['footercontentdesc'] = 'Додајте садржај у секцију подножја странице';
$string['footerdesc'] = 'Додај наслов за секцију подножја';
$string['footerheader'] = 'Наслов секције подножја';
$string['footerlayoutrow'] = 'Алат за креирање распореда блокова у подножју';
$string['footerlayoutrowdesc'] = 'Дизајнирајте распоред блокова за регион подножја странице са блоковима.';
$string['footerlinkcolor'] = 'Боја линка у блоковима подножја';
$string['footerlinkcolordesc'] = 'Боја линка у блоковима подножја странице.';
$string['footersettings'] = 'Подножје';
$string['footersettingsheading'] = 'Подесите садржај који треба да се појави у подножју странице. Погледајте пример распореда елемената на страници <a href="./../theme/adaptable/pix/layout.png" target="_blank">овде</a>';
$string['footertextcolor'] = 'Боја текста подножја';
$string['footertextcolor2'] = 'Боја текста доњег подножја';
$string['footertextcolor2desc'] = 'Боја текста у доњем делу подножја странице.';
$string['footertextcolordesc'] = 'Подесите боју текста у подножју странице, користећи html хексадецимални кôд.';
$string['footnote'] = 'Фуснота';
$string['footnotedesc'] = 'Додаје текст у подножје.';
$string['forumbodybackgroundcolor'] = 'Позадина тела поста на форуму';
$string['forumbodybackgroundcolordesc'] = 'Боја позадине тела поста на форуму';
$string['forumheaderbackgroundcolor'] = 'Позадина заглавља поста на форуму';
$string['forumheaderbackgroundcolordesc'] = 'Боја позадине заглавља поста на форуму';
$string['frnt-footer'] = 'Блокови у овом региону биће видљиви само администраторима.';
$string['frontpagealertsettings'] = 'Оквир са важним обавештењем';
$string['frontpageblockregionsettings'] = 'Алат за креирање региона блокова';
$string['frontpageblocksenabled'] = 'Омогући прилагођени регион са блоковима на насловној страници';
$string['frontpageblocksenableddesc'] = 'Можете да омогућите / онемогућите прилагођене регионе са блоковима на насловној страници. Након тога, можете да превлачите и спуштате блокове у регионе које сте креирали.';
$string['frontpageblocksettings'] = 'Промотивни блокови';
$string['frontpagecoursesettings'] = 'Насловна страница - списак курсева';
$string['frontpagedesc'] = 'Конфигуришите начин на који се приказују блокови са курсевима на насловној страници.';
$string['frontpagemarketenabled'] = 'Омогући промотивне блокове';
$string['frontpagemarketenableddesc'] = 'Подесите промотивне блокове на насловној страници.';
$string['frontpagemarketoption'] = 'Изаберите стил за промотивне блокове';
$string['frontpagemarketoptiondesc'] = 'Можете да примените различите стилове на промотивне блокове. Напомена: BCU стил је дизајниран тако да ради са сликама на врху блока.';
$string['frontpagerenderer'] = 'Блокови курсева на насловној страници';
$string['frontpagerendererdefaultimage'] = 'Подразумевана слика курса';
$string['frontpagerendererdefaultimagedesc'] = 'Подразумевана слика курса која ће се користити када не постоји слика курса (примењиво само за опцију \'Плочице са прекривачем\')';
$string['frontpagerendererdesc'] = 'Контролише начин на који се приказују блокови курсева на насловној страници.';
$string['frontpagerendereroption1'] = 'Плочице';
$string['frontpagerendereroption2'] = 'Плочице са прекривачем';
$string['frontpagerendereroption3'] = 'Moodle стандардно';
$string['frontpagerendereroption4'] = 'Ковентри плочице';
$string['frontpagesettingsheading'] = 'Приказ насловне странице';
$string['frontpageslidersettings'] = 'Насловна страница - Слајд-шоу';
$string['frontpagetickersettings'] = 'Насловна страница - Покретни трака';
$string['fullscreen'] = 'Приказ преко целог екрана';
$string['fullscreenwidth'] = 'Ширина приказа преко целог екрана';
$string['fullscreenwidthdesc'] = 'Подесите максималну ширину теме када је у режиму приказа преко целог екрана / зумирања.';
$string['genericsettingsdescription'] = 'Овде можете наћи различита подешавања како бисте теми додали свој CSS и JavaScript кôд.';
$string['genericsettingsheading'] = 'Примените своје модификације';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Можете да подесите више кôдова за Google Analytics и повежете их са пољима корисничких профила.';
$string['googleanalyticssettingsheading'] = 'Google Analytics подешавања за ваш сајт';
$string['headerbgimage'] = 'Позадинска слика';
$string['headerbgimagedesc'] = 'Подесите позадинску слику у заглављу. Минимална величина је 1600 x 180 пиксела (препоручује се 1600 x 180 пиксела). Слика покрива читаво заглавље. Можете да додате боју у \'Боја позадине горњег заглавља\' или да користите опцију <i>transparent</i> како бисте приказали позадинску слику. У том случају, како би текст исправно био приказан преко слике, модификујте његову боју.';
$string['headerbkcolor'] = 'Боја позадине горњег заглавља';
$string['headerbkcolor2'] = 'Боја позадине доњег заглавља';
$string['headerbkcolor2desc'] = 'Подесите боју позадине доњег заглавља.';
$string['headerbkcolordesc'] = 'Подесите боју позадине горњег заглавља';
$string['headerdesc'] = 'Поставите своју фавиконицу и лого, подесите образац за пријаву у заглављу, као и наслове у заглављу.<br />
Величину фонта и стилове за наслове можете да подесите на страници за подешавање <a href="./../admin/settings.php?section=theme_adaptable_font">фонтова</a>.';
$string['headersettings'] = 'Заглавље';
$string['headersettingsheading'] = 'Прилагодите заглавље ове теме. Погледајте пример распореда елемената на страници <a href="./../theme/adaptable/pix/layout.png" target="_blank">овде</a>';
$string['headertextcolor'] = 'Боја текста и линка горњег заглавља';
$string['headertextcolor2'] = 'Боја текста и линка доњег заглавља';
$string['headertextcolor2desc'] = 'Подесите боју текста и линка доњег заглавља';
$string['headertextcolordesc'] = 'Подесите боју текста и линка горњег заглавља';
$string['help'] = 'Помоћ';
$string['helpprofilefield'] = 'Прилагођено поље профила за помоћ (опционо)';
$string['helpprofilefielddesc'] = 'Додајте правило за приступ помоћи користећи прилагођено поље профила нпр: usertype=student';
$string['helptarget'] = 'Одредиште линка за помоћ';
$string['helptargetdesc'] = 'Да ли желите да се линк за помоћ отвори у новом прозору?';
$string['helptitle'] = 'Помоћ';
$string['hiddencourses'] = 'Сакривени курсеви';
$string['hide'] = 'Сакриј';
$string['hidealertsmobile'] = 'Сакриј важна обавештења (ако су у употреби) на мобилним уређајима';
$string['hidealertsmobiledesc'] = 'Сакривање ће уклонити важна обавештења на мобилним уређајима';
$string['hideblocks'] = 'Сакриј блокове';
$string['hidebreadcrumbmobile'] = 'Сакриј навигациону путању на мобилним уређајима';
$string['hidebreadcrumbmobiledesc'] = 'Сакривање ће уклонити навигациону путању на мобилним уређајима';
$string['hidecoursetitlemobile'] = 'Сакриј наслов курса / сајта на мобилним уређајима';
$string['hidecoursetitlemobiledesc'] = 'Сакријте наслов курса односно сајта на мобилни уређајима';
$string['hidefootersocial'] = 'Прикажи иконице друштвених мрежа';
$string['hidefootersocialdesc'] = 'Прикажите иконице друштвених мрежа у подножју испод блокова.';
$string['hideheadermobile'] = 'Сакриј заглавље на мобилним уређајима';
$string['hideheadermobiledesc'] = 'Сакривање ће уклонити заглавље са логотипом / иконицама друштвених мрежа / пољем за претрагу на мобилним уређајима';
$string['hideinforum'] = 'Сакриј ”Помоћ” и мени ”Алати” у форумима';
$string['hideinforumdesc'] = 'Када се користи приказ фиксне ширине и све опције менија, поље за претрагу форума може склизнути у ред испод. Укључивање ове опције ће сакрити \'Помоћ\' и мени \'Алати\' у форумима, што ће омогућити да страница форума буду исправно приказана.';
$string['hidelogomobile'] = 'Сакриј лого на мобилним уређајима';
$string['hidelogomobiledesc'] = 'Сакривање ће уклонити лого на мобилним уређајима';
$string['hidepagefootermobile'] = 'Сакриј подножје на мобилним уређајима';
$string['hidepagefootermobiledesc'] = 'Сакривање ће уклонити подножје на мобилним уређајима';
$string['hideslidermobile'] = 'Сакриј слајд-шоу на мобилним уређајима';
$string['hideslidermobiledesc'] = 'Сакривање ће уклонити слајд-шоу на насловној страници на мобилним уређајима';
$string['hidesocialmobile'] = 'Сакриј иконице друштвених мрежа на мобилним уређајима';
$string['hidesocialmobiledesc'] = 'Сакривање ће уклонити иконице друштвених мрежа на мобилним уређајима';
$string['homebk'] = 'Позадинска слика насловне странице';
$string['homebkdesc'] = 'Поставите слику која ће бити позадинска слика насловне странице';
$string['infobox'] = 'Инфо-блок насловне странице';
$string['infobox2'] = 'Секундарни инфо-блок насловне странице';
$string['infobox2desc'] = 'Секундарни инфо-блок насловне странице (погледајте датотеку <a href="./../theme/adaptable/README.txt" target="_blank">README.txt</a> за више информација и савете).';
$string['infoboxdesc'] = 'Инфо-блок насловне странице HTML (погледајте датотеку <a href="./../theme/adaptable/README.txt" target="_blank">README.txt</a> за више информација и савете).';
$string['infoboxfullscreen'] = 'Инфо-блок преко целог екрана';
$string['infoboxfullscreendesc'] = 'Ако укључите ову опцију садржај инфо-блока биће приказан читавом ширином екрана.';
$string['jssection'] = 'Javascript секција';
$string['jssectiondesc'] = 'Додајте javascript кôд на сајт.';
$string['layoutaddcontent'] = 'Задовољни сте са својим распоредом блокова? Сада додајте садржај у ваше блокове:';
$string['layoutaddcontentdesc1'] = 'Конфигурисали сте';
$string['layoutaddcontentdesc2'] = 'промотивне блокове. Ако сте задовољни са овим распоредом додајте у наставку странице садржај у блокове. Ако нисте задовољни употребите горњи алат за креирање распореда блокова како бисте направили промене.<br />';
$string['layoutcheck'] = 'Проверите свој распоред блокова';
$string['layoutcheckdesc'] = 'Употребите алат у наставку како бисте проверили број блокова које користите и видели како изгледа ваш нови распоред блокова.';
$string['layoutcount1'] = 'Можете да подесите највише';
$string['layoutcount2'] = 'регион/a са блоковима. Тренутно користите:';
$string['layoutdesc'] = 'Подесите подразумевани распоред блокова који корисници виде.';
$string['layoutmobilesettings'] = 'Подешавања за мобилне уређаје';
$string['layoutmobilesettingsdesc'] = 'Измените подешавања за мобилне уређаје';
$string['layoutsettings'] = 'Изглед сајта';
$string['layoutsettingsheading'] = 'Контролни аспекти изгледа сајта';
$string['leftblocks'] = 'Лева страна';
$string['linkcolor'] = 'Боја линка';
$string['linkcolordesc'] = 'Подесите боју линкова у теми, користећи html хексадецимални кôд.';
$string['linkhover'] = 'Лебдећа боја линка';
$string['linkhoverdesc'] = 'Подесите боју линкова у теми (када се мишем пређе преко њих), користећи html хексадецимални кôд.';
$string['linksmenu'] = 'Мени линкова';
$string['loadingcolor'] = 'Боја учитавања';
$string['loadingcolordesc'] = 'Боја траке учитавања на врху странице.';
$string['loadtime'] = 'Страница учитана';
$string['loginplaceholder'] = 'Корисничко име';
$string['logintextbutton'] = 'Пријави се';
$string['logo'] = 'Лого';
$string['logodesc'] = 'Поставите лого који ће се користити на вашем сајту. Препоручена величина је 200 x 80 пиксела';
$string['maincolor'] = 'Главна боја';
$string['maincolordesc'] = 'Главна боја за блокове и подножје странице.';
$string['market'] = 'Промотивни блок';
$string['marketblockbordercolor'] = 'Боја бордуре промотивног блока';
$string['marketblockbordercolordesc'] = 'Подесите боју бордуре промотивног блока.';
$string['marketblocksbackgroundcolor'] = 'Боја позадине региона са промотивним блоковима';
$string['marketblocksbackgroundcolordesc'] = 'Подесите боју позадине региона са промотивним блоковима.';
$string['marketdesc'] = 'Додајте HTML за промотивни блок (погледајте датотеку <a href="./../theme/adaptable/README.txt" target="_blank">README.txt</a> за више информација и савете).';
$string['marketingbuilderdesc'] = 'Употребите алат у наставку како бисте подесили своје промотивне блокове. Једном када овде дефинишите број блокова у доњем делу странице појавиће се подешавања за сваки од њих.';
$string['marketingbuilderheading'] = 'Алат за распоред промотивних блокова';
$string['marketingdesc'] = 'Постоје два инфо-блока пуне ширине са различитим стиловима које можете да користите. Поред тога постоји и алат за креирање распореда блокова који вам даје могућност да одлучите колико блокова вам је потребно и да дефинишете свој распоред блокова. Молимо, погледајте датотеку <a href="./../theme/adaptable/README.txt" target="_blank">README.txt</a> која долази са овом темом.';
$string['marketingsettings'] = 'Промотивни блокови';
$string['marketingsettingsheading'] = 'Прилагодите промотивне блокове који се појављују на насловној страници. Погледајте пример распореда елемената на страници <a href="./../theme/adaptable/pix/layout.png" target="_blank">овде</a>';
$string['marketlayoutrow'] = 'Ред промотивних блокова';
$string['marketlayoutrowdesc'] = 'Додајте / подесите изглед реда са промотивним блоковима на насловној страници';
$string['menubkcolor'] = 'Боја позадине главног менија';
$string['menubkcolordesc'] = 'Подесите боју позадине главног менија';
$string['menubordercolor'] = 'Боја доње бордуре главног менија';
$string['menubordercolordesc'] = 'Подесите боју доње бордуре главног менија';
$string['menufontcolor'] = 'Боја фонта главног менија';
$string['menufontcolordesc'] = 'Подесите боју фонта главног менија';
$string['menufontpadding'] = 'Размак између ставки навигације';
$string['menufontpaddingdesc'] = 'Подесите размак између ставки у главној навигационој траци.';
$string['menufontsize'] = 'Величина фонта за навигациону траку';
$string['menufontsizedesc'] = 'Подесите величину фонта који се користи у главној навигационој траци.';
$string['menuhovercolor'] = 'Лебдећа боја главног менија';
$string['menuhovercolordesc'] = 'Подесите лебдећу боју главног менија';
$string['menuoverrideprofilefield'] = 'Назив прилагођеног поља профила';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'Назив прилагођеног поља профила (у формату ”списка”) које се користе за корисничке измене.';
$string['menusdesc'] = '';
$string['menusession'] = 'Сачувај детаље о приступу у сесији корисника';
$string['menusessiondesc'] = 'Због перформанси система сугерише се да укључите ову опцију. Можда ћете желети да је онемогућити приликом тестирања.';
$string['menusessionttl'] = 'Време чувања правила приступа у сесији корисника';
$string['menusessionttldesc'] = 'Временски период (број минута) након ког се правила за приступ менију освежавају у сесији корисника.';
$string['menusettings'] = 'Заглавље - менији';
$string['menusettingsheading'] = 'Прилагодите меније у горњем заглављу ове теме.';
$string['menusheading'] = 'Конфигуришите навигацију за меније у горњем заглављу';
$string['menusheadingvisibility'] = 'Општа подешавања за видљивост менија горњег заглавља';
$string['menusheadingvisibilitydesc'] = 'Следећа подешавања омогућавају да контролишете где се појављују менији и опционо омогућавају корисницима да прилагоде своја подешавања';
$string['menuslinkright'] = 'Прикажи мени линкова горе десно';
$string['menuslinkrightdesc'] = 'Ако је означено, мени са линковима се приказује у горњем десном углу одмах поред менија са порукама';
$string['menustitledesc'] = 'Менији ”Алати” (у навигационој траци) и Горњи менији (у горњем заглављу) се могу ограничити на основу прилагођених поља у профилу корисника (опционо). Да бисте додали ограничење унесите назив поља профила и очекивану вредност. Структура менија следи уобичајени Moodle формат:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = 'Дозволи измене од стране корисника';
$string['menuuseroverridedesc'] = 'Ово подешавање може да се користи како би се, путем прилагођеног поља профила, корисницима дала контрола над појављивањем менија. За коришћење ове опције биће потребно да креирате прилагођено поље профила у формату ”списка” са вредностима поређаним одговарајућим редоследом:
<pre>1. На читавом сајту (прва ставка на списку биће за видљивост менија на читавом сајту)
2. Само почетне странице (друга ставка на списку ограничиће видљивост менија само на сајт / почетне странице)
3. Скривено (трећа ставка на списку ће сакрити меније у потпуности)</pre>
НЕМОЈТЕ користити опцију ”Онемогући меније на страницама курса” заједно са подешавањима поља профила. Уместо тога, када подешавате ваш списак поља профила, користите као подразумевану вредност ”Само почетне странице”.

Напомена: да би ова промена ступила на снагу, корисници ће морати да се одјаве са сајта и поново пријаве. Било би добро да у прилагођено поље профила додате напомену која ово објашњава.';
$string['messagepopupbackground'] = 'Боја позадине искачућег прозора са порукама';
$string['messagepopupbackgrounddesc'] = 'Подесите боју позадине заглавља искачућег прозора са порукама.';
$string['messagepopupcolor'] = 'Боја текста искачућег прозора са порукама';
$string['messagepopupcolordesc'] = 'Подесите боју текста заглавља искачућег прозора са порукама.';
$string['messagingbackgroundcolor'] = 'Боја позадине главног прозора приватне поруке';
$string['messagingbackgroundcolordesc'] = 'Подесите боју позадине главног прозора приватних порука.';
$string['mobilemenubkcolor'] = 'Боја позадине менија на мобилним уређајима';
$string['mobilemenubkcolordesc'] = 'Подесите боју позадине главног менија на мобилним уређајима (скупљено)';
$string['mobilesettings'] = 'Подешавања за мобилне уређаје';
$string['mobilesettingsheading'] = 'Управљање изгледом вашег сајта на мобилним уређајима';
$string['moodledocs'] = 'Линк ка Moodle документацији';
$string['moodledocsdesc'] = 'Приказује линк ка Moodle документацији у подножју странице';
$string['msgbadgecolor'] = 'Боја позадина маркера непрочитаних порука';
$string['msgbadgecolordesc'] = 'Подесите боју позадина маркера (мехурића) порука у заглављу (који приказује број непрочитаних порука).';
$string['myblogs'] = 'Моји блогови';
$string['mycoursesmenulimit'] = 'Ограничење менија "Моји курсеви"';
$string['mycoursesmenulimitdesc'] = 'Подесите максималан број курсева који се појављују у падајућем менију "Моји курсеви". 0 ће приказати све курсеве.';
$string['mysites'] = 'Моји курсеви';
$string['mysitesdisabled'] = 'Онемогући';
$string['mysitesexclude'] = 'Омогући искључивање сакривених курсева';
$string['mysitesinclude'] = 'Омогући укључивање сакривених курсева';
$string['mysitesmaxlength'] = 'Максимална дужина назива мојих курсева';
$string['mysitesmaxlengthdesc'] = 'Подесите максималну дужину назива курсева у падајућем менију ”Моји курсеви”.';
$string['mysitessortoverride'] = 'Омогући прилагођено сортирање у менију ”Моји курсеви”';
$string['mysitessortoverridedesc'] = 'Употребите прилагођена поља профила или генеричке стрингове (година итд) како бисте скупили протекле курсеве у подменију.';
$string['mysitessortoverridefield'] = 'Прилагођена поља профила или стрингови за мени ”Моји курсеви”';
$string['mysitessortoverridefielddesc'] = 'Списак поља профила или стрингова, раздвојених зарезом, за проверу у кратким кôдовим курсева.';
$string['mysitessortoverrideoff'] = 'Прикажи све уписане курсеве као обичан списак';
$string['mysitessortoverrideprofilefields'] = 'Прикажи курсеве пронађене у пољима профила у првом списку, остале у подменију';
$string['mysitessortoverrideprofilefieldscohort'] = 'Прикажи курсеве пронађене у пољима профила и кохортама у првом списку, остале у подменију';
$string['mysitessortoverridestrings'] = 'Прикажи уписане курсеве који садрже стрингове у првом списку, остале у подменију';
$string['navbarcachetime'] = 'Време кеширања навигационе траке';
$string['navbarcachetimedesc'] = 'Број минута током којих се кешира навигациона трака.';
$string['navbardesc'] = 'Омогућава вам да контролишете све елементе који се појављују у навигационој траци.';
$string['navbarmenusettings'] = 'Навигациона трака - мени ”Алати”';
$string['navbarmenusettingsdesc'] = 'Омогућава вам да додате мени у навигациону траку.';
$string['navbarmenusettingsheading'] = 'Прилагодите мени у навигационој траци. Погледајте пример распореда елемената на страници <a href="./../theme/adaptable/pix/layout.png" target="_blank">овде</a>';
$string['navbarsettings'] = 'Заглавље - навигациона трака';
$string['navbarsettingsheading'] = 'Прилагодите навигациону траку';
$string['newmenu'] = 'Горњи падајући мени';
$string['newmenu1trigger'] = 'Реч окидач за Горњи падајући мени 1';
$string['newmenu1triggerdesc'] = 'Подесите реч окидач за Горњи падајући мени 1. Могу да се користе  Font Awesome иконице.';
$string['newmenu2trigger'] = 'Реч окидач за Горњи падајући мени 2';
$string['newmenu2triggerdesc'] = 'Подесите реч окидач за Горњи падајући мени 2. Могу да се користе  Font Awesome иконице.';
$string['newmenudesc'] = 'Конфигуришите линкови који ће бити приказани у менију горњег заглавља.';
$string['newmenufield'] = 'Назив прилагођеног поља профила=Вредност (опционо)';
$string['newmenufielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: "usertype=student"';
$string['newmenuheading'] = 'Горњи мени';
$string['newmenurequirelogin'] = 'Захтева пријаву на систем';
$string['newmenurequirelogindesc'] = 'Ако је подешавање омогућено, овај мени ће видети само пријављени корисници';
$string['newmenutitle'] = 'Наслов Горњег менија';
$string['newmenutitledefault'] = 'Мени';
$string['newmenutitledesc'] = 'Наслов падајућег менија који се појављује у заглављу вашег сајта';
$string['newstickercount'] = 'Број секција покретне траке са вестима';
$string['newstickercountdesc'] = 'Дефинишите више секција покретне траке са вестима, заједно са правилима приступа како бисте таргетирали различиту публику.';
$string['nextsection'] = 'Следећа секција';
$string['noenrolments'] = 'Није пронађен ниједан упис на курс.';
$string['nostyle'] = 'Без стила';
$string['pageheaderheight'] = 'Висина заглавља странице';
$string['pageheaderheightdesc'] = 'Подесите висину региона главног заглавља (који садржи лого и наслове)';
$string['passwordplaceholder'] = 'Лозинка';
$string['pastcourses'] = 'Протекли курсеви';
$string['people'] = 'Људи';
$string['piwikenabled'] = 'Омогућено';
$string['piwikenableddesc'] = 'Омогућите Piwik праћење података за Moodle.';
$string['piwikimagetrack'] = 'Праћење слика';
$string['piwikimagetrackdesc'] = 'Омогућите праћење слике на Moodle сајту за веб читаче код којих је искључен JavaScript.';
$string['piwiksettings'] = 'Piwik Analytics';
$string['piwiksettingsdesc'] = 'Генерише прочишћену URL адресу за напредно праћење.';
$string['piwiksettingsheading'] = 'Piwik подешавања';
$string['piwiksiteid'] = 'ID ознака сајта';
$string['piwiksiteiddesc'] = 'Унесите ID ознаку вашег сајта';
$string['piwiksiteurl'] = 'Piwik URL адреса';
$string['piwiksiteurldesc'] = 'Унесите URL адресу за Piwik Analytics  без http(s) и пратећих косих црта';
$string['piwiktrackadmin'] = 'Праћење администратора';
$string['piwiktrackadmindesc'] = 'Омогућите праћење администратора (не препоручује се)';
$string['pluginname'] = 'Adaptable';
$string['previoussection'] = 'Претходна секција';
$string['region-course-bottom-a'] = 'Дно странице курса - регион 5';
$string['region-course-bottom-b'] = 'Дно странице курса - регион 6';
$string['region-course-bottom-c'] = 'Дно странице курса - регион 7';
$string['region-course-bottom-d'] = 'Дно странице курса - регион 8';
$string['region-course-top-a'] = 'Врх странице курса - регион 1';
$string['region-course-top-b'] = 'Врх странице курса - регион 2';
$string['region-course-top-c'] = 'Врх странице курса - регион 3';
$string['region-course-top-d'] = 'Врх странице курса - регион 4';
$string['region-frnt-footer'] = 'Подножје';
$string['region-frnt-market-a'] = 'Регион странице 1';
$string['region-frnt-market-b'] = 'Регион странице 2';
$string['region-frnt-market-c'] = 'Регион странице 3';
$string['region-frnt-market-d'] = 'Регион странице 4';
$string['region-frnt-market-e'] = 'Регион странице 5';
$string['region-frnt-market-f'] = 'Регион странице 6';
$string['region-frnt-market-g'] = 'Регион странице 7';
$string['region-frnt-market-h'] = 'Регион странице 8';
$string['region-frnt-market-i'] = 'Регион странице 9';
$string['region-frnt-market-j'] = 'Регион странице 10';
$string['region-frnt-market-k'] = 'Регион странице 11';
$string['region-frnt-market-l'] = 'Регион странице 12';
$string['region-frnt-market-m'] = 'Регион странице 13';
$string['region-frnt-market-n'] = 'Регион странице 14';
$string['region-frnt-market-o'] = 'Регион странице 15';
$string['region-frnt-market-p'] = 'Регион странице 16';
$string['region-frnt-market-q'] = 'Регион странице 17';
$string['region-frnt-market-r'] = 'Регион странице 18';
$string['region-frnt-market-s'] = 'Регион странице 19';
$string['region-frnt-market-t'] = 'Регион странице 20';
$string['regionmaincolor'] = 'Боја главног региона';
$string['regionmaincolordesc'] = 'Подесите боју позадине за регион са главним садржајем.';
$string['region-middle'] = 'Средина';
$string['region-side-post'] = 'Десно';
$string['region-side-pre'] = 'Лево';
$string['rendereroverlaycolor'] = 'Боја прекривача';
$string['rendereroverlaycolordesc'] = 'Боја прекривача, када је изабрана опција приказа \'Плочице са прекривачем\'.';
$string['rendereroverlayfontcolor'] = 'Боја фонта прекривача';
$string['rendereroverlayfontcolordesc'] = 'Боја фонта када се мишем пређе преко поља курса (у ситуацији када је омогућена опција приказа \'Плочице са прекривачем\').';
$string['rightblocks'] = 'Десна страна';
$string['savebuttontext'] = 'Сачувај промене';
$string['searchboxpadding'] = 'Слободан простор око поља за претрагу';
$string['searchboxpaddingdesc'] = 'Подесите удаљеност поља за претрагу од ивица странице (ако се ово поље користи уместо иконица друштвених мрежа) <br />Нпр. 5px 10px 5px 10px (горе, десно, доле, лево).<br> Иконице друштвених мрежа можете подесити на страници за подешавање <a href="./../admin/settings.php?section=theme_adaptable_social">Заглавље - друштвене мреже</a>.';
$string['sectionheadingcolor'] = 'Боја текста наслова секције';
$string['sectionheadingcolordesc'] = 'Подесите боју за текст наслова секције';
$string['selectionbackground'] = 'Боја позадине изабраног текста';
$string['selectionbackgrounddesc'] = 'Подесите боју позадине текста који је изабран на екрану.';
$string['selectiontext'] = 'Боја изабраног текста';
$string['selectiontextdesc'] = 'Подесите боју текста који је изабран на екрану.';
$string['settingsalertbox'] = 'Оквир са важним обавештењем';
$string['settingsanalytics'] = 'Аналитика';
$string['settingsborders'] = 'Бордуре';
$string['settingsbreadcrumbcolors'] = 'Боје навигационе путање';
$string['settingscolors'] = 'Боје';
$string['settingsfonts'] = 'Фонтови';
$string['settingsfootercolors'] = 'Боје подножја';
$string['settingsforumheading'] = 'Форум';
$string['settingsheadercolors'] = 'Боје заглавља';
$string['settingsinfoboxcolors'] = 'Боје инфо-блока';
$string['settingsmaincolors'] = 'Главне боје';
$string['settingsmarketingcolors'] = 'Боје промотивних блокова';
$string['settingsmessagescolors'] = 'Боје искачућег прозора са порукама';
$string['settingsnavbarcolors'] = 'Боје навигационе траке';
$string['settingsoverlaycolors'] = 'Боје плочица прекривача';
$string['settingssecondinfoboxcolors'] = 'Боје секундарног инфо-блока';
$string['settingstopicsweeks'] = 'Теме/Седмице';
$string['show'] = 'Прикажи';
$string['showblocks'] = 'Прикажи блокове';
$string['showfooterblocks'] = 'Прикажи блокове подножја';
$string['showfooterblocksdesc'] = 'Прикажи/сакриј четири подесива блока у подножју странице';
$string['side-post1'] = 'бочни стубац са блоковима у подножју';
$string['sitetitle'] = 'Прикажи наслов сајта';
$string['sitetitlecoursesdisabled'] = 'Онемогућено - прикажи само наслове курсева на страницама курсева';
$string['sitetitlecoursesenabled'] = 'Омогућено - прикажи наслов сајта и наслове курсева на страницама курсева';
$string['sitetitlecustom'] = 'Користите прилагођени наслов сајта (унесите га у доње текстуално поље)';
$string['sitetitledefault'] = 'Користи наслов Moodle сајта (назив сајта)';
$string['sitetitledesc'] = 'Приказује подразумевани наслов Moodle сајта преузет из <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Подешавања насловне странице</a> или унесите у доње поље прилагођени назив сајта. Ако додате слику логотипа онда наслов неће бити приказан.';
$string['sitetitlemaxwidth'] = 'Максимална ширина наслова сајта';
$string['sitetitlemaxwidthdesc'] = 'Подесите максимална ширину региона са насловом сајта';
$string['sitetitleoff'] = 'Онемогући наслов сајта';
$string['sitetitlepaddingleft'] = 'Удаљеност наслова сајта од леве ивице';
$string['sitetitlepaddingleftdesc'] = 'За подешавање положаја наслова сајта одредите његову удаљеност  од леве ивице';
$string['sitetitlepaddingtop'] = 'Удаљеност наслова сајта од горње ивице';
$string['sitetitlepaddingtopdesc'] = 'За подешавање положаја наслова сајта одредите његову удаљеност  од горње ивице';
$string['sitetitletext'] = 'Наслов сајта';
$string['sitetitletextdesc'] = 'Наслов сајта који се приказује у заглављу. Можете да користите било коју HTML ознаку и применити уметнуте стилове.';
$string['slider2h3bgcolor'] = 'Слајд-шоу 2 - боја позадине H3 ознаке';
$string['slider2h3bgcolordesc'] = 'Изаберите боју позадине коју желите за ознаку H3 (за слајд-шоу стил 2)';
$string['slider2h3color'] = 'Слајд-шоу 2 - боја текста ознаке H3';
$string['slider2h3colordesc'] = 'Изаберите боју текста коју желите за ознаку H3 (за слајд-шоу стил 2)';
$string['slider2h4bgcolor'] = 'Слајд-шоу 2 - боја позадине H4 ознаке';
$string['slider2h4bgcolordesc'] = 'Изаберите боју позадине коју желите за ознаку H4 (за слајд-шоу стил 2)';
$string['slider2h4color'] = 'Слајд-шоу 2 - боја текста ознаке H4';
$string['slider2h4colordesc'] = 'Изаберите боју текста коју желите за ознаку H4 (за слајд-шоу стил 2)';
$string['slidercaption'] = 'Натпис на слајду';
$string['slidercaptiondesc'] = 'Додајте натпис за ваш слајд';
$string['slidercount'] = 'Број слајдова';
$string['slidercountdesc'] = 'Изаберите колико слајдова желите да додате, а <strong>онда кликните на дугме \'САЧУВАЈ\'</strong> како би се учитала поља за унос подешавања.';
$string['sliderenabled'] = 'Омогући слајд-шоу';
$string['sliderenableddesc'] = 'Омогућите слајд-шоу на врху ваше почетне странице';
$string['sliderfullscreen'] = 'Слајд-шоу преко целог екрана';
$string['sliderfullscreendesc'] = 'Означите ово поље како би слајд-шоу био приказан преко целог екрана (100% ширине)';
$string['sliderh3color'] = 'Слајд-шоу 1 - боја H3 ознаке';
$string['sliderh3colordesc'] = 'Изаберите боју коју желите за ознаку H3 (за слајд-шоу стил 1)';
$string['sliderh4color'] = 'Слајд-шоу 1 - боја H4 ознаке';
$string['sliderh4colordesc'] = 'Изаберите боју коју желите за ознаку H4 (за слајд-шоу стил 1)';
$string['sliderimage'] = 'Слика слајда';
$string['sliderimagedesc'] = 'Додајте слику за ваш слајд. Препоручена величина је 1600 x 400 пиксела или већа.';
$string['slidermarginbottom'] = 'Слајд-шоу - доња маргина';
$string['slidermarginbottomdesc'] = 'Подесите величину маргине испод слајд-шоу презентације.';
$string['slidermargintop'] = 'Слајд-шоу - горња маргина';
$string['slidermargintopdesc'] = 'Подесите величину маргине изнад слајд-шоу презентације';
$string['slideroption2'] = 'Изабери тип слајд-шоу презентације';
$string['slideroption2a'] = 'Боја позадине стрелице (слајд-шоу стил 2)';
$string['slideroption2adesc'] = 'Подесите боју позадине стрелице (за слајд-шоу стил 2).';
$string['slideroption2color'] = 'Слајд-шоу 2 - позадина дугмета';
$string['slideroption2colordesc'] = 'Подесите боју позадине дугмета (за слајд-шоу стил 2)';
$string['slideroption2desc'] = 'Изаберите тип слајд-шоу презентације, а <strong>онда кликните на дугме \'САЧУВАЈ\'</strong> како бисте видела подешавања боја за изабрани тип презентације.';
$string['slideroption2snippet'] = '<p>Пример HTML-а за натпис на слајду:</p>
<pre>
<div class="span6 col-sm-6">
<h3>Мудл Мрежа Србије</h3> <h4>Асоцијација мудлера Србије</h4>
<a href="#" class="submit">Посетите наш сајт!</a>
</pre>';
$string['slideroption2submitcolor'] = 'Слајд-шоу 2 - текст дугмета';
$string['slideroption2submitcolordesc'] = 'Подесите боју текста на дугмету (за слајд-шоу стил 2)';
$string['sliderstyle1'] = 'Слајд-шоу - стил 1';
$string['sliderstyle2'] = 'Слајд-шоу - стил 2';
$string['slidersubmitbgcolor'] = 'Слајд-шоу 1 - позадина дугмета';
$string['slidersubmitbgcolordesc'] = 'Изаберите боју позадине дугмета (за слајд-шоу стил 1)';
$string['slidersubmitcolor'] = 'Слајд-шоу 1 - текст дугмета';
$string['slidersubmitcolordesc'] = 'Изаберите боју текста на дугмету (за слајд-шоу стил 1)';
$string['sliderurl'] = 'URL адреса линка слајда';
$string['sliderurldesc'] = 'Додајте URL адресу са којом ће ваш слајд бити повезан када се кликне на њега.';
$string['slideshowdesc'] = 'Поставите слике, додајте линкове и опис за карусел слајдова на насловној страници.';
$string['slideshowsettings'] = 'Слајд-шоу';
$string['slideshowsettingsheading'] = 'Прилагодите карусел слајдова на насловној страници. Погледајте пример распореда елемената на страници <a href="./../theme/adaptable/pix/layout.png" target="_blank">овде</a>';
$string['socialheading'] = 'Подешавање иконица друштвених мрежа';
$string['socialicondesc'] = 'Подесите Font Awesome иконице, на пример: fa-facebook';
$string['socialiconlist'] = 'Списак иконица друштвених мрежа';
$string['socialiconlistdesc'] = 'Унесите списак са граничницима, како бисте подесили иконице друштвених мрежа / линкове који су вам потребни, користећи формат: url|title|icon';
$string['socialorsearch'] = 'Користи поље за претрагу или иконице друштвених мрежа';
$string['socialorsearchdesc'] = 'Можете подесити тему тако да се у заглављу приказују или иконице друштвених мрежа или поље за претрагу.<br />
Иконице друштвених мрежа можете подесити на страници за подешавање <a href="./../admin/settings.php?section=theme_adaptable_social">Заглавље - друштвене мреже</a>.';
$string['socialorsearchsearch'] = 'Прикажи поље за претрагу у заглављу';
$string['socialorsearchsocial'] = 'Прикажи иконице друштвених мрежа у заглављу';
$string['socialpaddingtop'] = 'Подесите размак изнад иконица друштвених мрежа (мења вертикални положај)';
$string['socialsearchicon'] = 'Претражи Moodle';
$string['socialsearchicondesc'] = 'Ово подешавање омогућава да се постави линк за претрагу упоредо са иконицама друштвених мрежа (пошто њихово коришћење онемогућава поље за претрагу на читавом сајту).';
$string['socialsettings'] = 'Заглавље - друштвене мреже';
$string['socialsize'] = 'Подеси величину фонта за иконице друштвених мрежа';
$string['socialsizemobile'] = 'Подеси величину фонта за иконице друштвених мрежа на мобилним уређајима';
$string['socialtarget'] = 'Одредиште линкова друштвених мрежа';
$string['socialtargetdesc'] = 'Како желите да се линкови друштвених мрежа отварају (у истом или новом прозору).';
$string['socialtitledesc'] = 'Можете да онемогућите поље за претрагу на читавом сајту и уместо њега омогућите иконице / линкове друштвених мрежа.
Да бисте подесили иконице друштвених мрежа унесите списак са граничницима у доње поље "Списак иконица друштвених мрежа".
Списак треба да буде у формату:

url|title|icon

На пример:
<pre>
https://example.com/course/search.php|Search Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
https://example.com|My Web|fa-globe
</pre>
Комплетан списак Font Awesome иконица можете наћи <a href="https://fortawesome.github.io/Font-Awesome/icons/">овде</a>.';
$string['socialwall'] = 'Друштвени зид';
$string['socialwallactionlinkcolor'] = 'Боја линка акције';
$string['socialwallactionlinkcolordesc'] = 'Боја линка реакције корисника (”Свиђа ми се” / Напиши коментар”) на курсу у формату ”Друштвени зид”.';
$string['socialwallactionlinkhovercolor'] = 'Лебдећа боја линка акције';
$string['socialwallactionlinkhovercolordesc'] = 'Боја линка реакције корисника (”Свиђа ми се” / Напиши коментар”), када се мишем пређе преко њега, на курсу у формату ”Друштвени зид”.';
$string['socialwallbackgroundcolor'] = 'Боја позадине';
$string['socialwallbackgroundcolordesc'] = 'Боја позадине курса у формату ”Друштвени зид”';
$string['socialwallbordercolor'] = 'Боја бордуре';
$string['socialwallbordercolordesc'] = 'Боја бордуре секција курса у формату ”Друштвени зид”.';
$string['socialwallbordertopstyle'] = 'Стил бордуре';
$string['socialwallbordertopstyledesc'] = 'Боја бордуре секција курса у формату ”Друштвени зид”.';
$string['socialwallborderwidth'] = 'Ширина бордуре';
$string['socialwallborderwidthdesc'] = 'Ширина бордуре секције курса у формату "Друштвени зид"';
$string['socialwalldesc'] = 'Прилагодите изглед <a href="https://moodle.org/plugins/format_socialwall">формата курса ”Друштвени зид”</a> (уколико се користи на вашем сајту).';
$string['socialwallheading'] = 'Друштвени зид - подешавања';
$string['socialwallsectionradius'] = 'Полупречник бордуре';
$string['socialwallsectionradiusdesc'] = 'Полупречник бордуре секције курса у формату "Друштвени зид"';
$string['standardview'] = 'Стандардни приказ';
$string['stickynavbar'] = 'Лепљива навигациона трака на врху';
$string['stickynavbardesc'] = 'Фиксирајте навигациону траку за врх екрана приликом премотавања садржаја  странице.';
$string['targetnewwindow'] = 'Нови прозор';
$string['targetsamewindow'] = 'Исти прозор';
$string['thiscourse'] = 'Овај курс';
$string['ticker'] = 'Најаве';
$string['tickerdefault'] = 'Нема нових вести за приказ';
$string['tickerdesc'] = 'Овде можете подесити покретну траку са вестима која се креће преко насловне странице вашег Moodle сајта.
Њена намена је да буде мање наметљива алтернатива за слајд-шоу, с обзиром да заузима врло мало простора.
Да бисте подесили покретну траку са вестима једноставно унесите списак  вести, заједно са  хиперлинковима који су вам потребни у тексту вести.
<strong>Напомена:</strong> Ако се ваша покретна трака са вестима не учитава исправно пребаците се на HTML приказ и проверите да имате само &lt;p&gt; ознаке:
<pre>
&lt;p&gt;Прва вест.....&lt;/p&gt;
&lt;p&gt; Друга вест.....&lt;/p&gt;
</pre>';
$string['tickerfullscreen'] = 'Приказ преко целог екрана';
$string['tickersettings'] = 'Покретна трака са вестима';
$string['tickersettingsheading'] = 'Прилагодите покретну траку са вестима на насловној страници. Погледајте пример распореда елемената на страници <a href="./../theme/adaptable/pix/layout.png" target="_blank">овде</a>';
$string['tickertext'] = 'Текст покретне траке са вестима';
$string['tickertextdesc'] = 'Додајте текст за покретну траку са вестима у формату списка. Погледајте readme.txt датотеку за више информација.';
$string['tickertextprofilefield'] = 'Назив прилагођеног поља профила=вредност (опционо)';
$string['tickertextprofilefielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: "usertype=student"';
$string['tickerwidth'] = 'Фиксна ширина';
$string['tickerwidthdesc'] = 'Можете користити ово подешавање како бисте фиксирали покретну траку са  вестима на 100% ширине.';
$string['tilesbordercolor'] = 'Боја бордуре плочица оквира курса';
$string['tilesbordercolordesc'] = 'Подесите боју бордуре плочица оквира курса.';
$string['tilescontactstitle'] = 'Прикажи улоге контакт особа';
$string['tilescontactstitledesc'] = 'Прикажите / сакријте улогу контакт особа на курсу. Ако се не приказује, биће приказана слика поред сваке контакт особе.';
$string['tilesshowallcontacts'] = 'Прикажи све контакт особе';
$string['tilesshowallcontactsdesc'] = 'Прикажите све контакт особе на курсу или само једну.';
$string['tilesshowcontacts'] = 'Прикажи контакт особе';
$string['tilesshowcontactsdesc'] = 'Прикажите / сакријте контакт особе на курсу.';
$string['toolsmenu'] = 'Падајући мени \'Алати\'';
$string['toolsmenu2'] = 'Други мени \'Алати\'';
$string['toolsmenu2desc'] = 'Можете да конфигуришете линкове у оквиру менија ”Алати”. Сваки ред се састоји од текста ставке у менију, одговарајуће URL адресе линка (опционо), кратког описа ставке (опционо), као и ознаке језика или листе ознака језика, одвојених зарезима, (опционо, за приказ тог реда искључиво корисницима наведеног језика) који су међусобно одвојени вертикалном цртом |. Можете да одредите и структуру менија користећи цртицe. На пример:
<pre>
Moodle заједница|https://moodle.org
-Moodle бесплатна подршка|https://moodle.org/support
-Moodle развој|https://moodle.org/development
--Moodle документација|https://docs.moodle.org|Moodle документација
--Moodle документација на немачком|http://docs.moodle.org/de|Документација на немачком
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenudesc'] = 'Додајте падајући мени у главну навигациону траку';
$string['toolsmenufield'] = 'Назив прилагођеног поља профила=вредност (опционо)';
$string['toolsmenufielddesc'] = 'Додајте правило приступа користећи прилагођено поље профила, нпр: "usertype=student"';
$string['toolsmenuheading'] = 'Мени ”Алати”';
$string['toolsmenuheadingdesc'] = 'Можете да конфигуришете линкове у оквиру менија \'Алати\' (у главној навигационој траци. Формат је сличан оном који се користи за Moodle прилагођене меније, али вам омогућава да уз ставке менија додате Font Awesome иконице:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenulabel'] = 'Мени ”Алати”';
$string['toolsmenulabel2'] = 'Алати 2';
$string['toolsmenuscount'] = 'Број менија ”Алати”';
$string['toolsmenuscountdesc'] = 'Подесите број менија ”Алати” које желите да додате у главну навигациону траку';
$string['toolsmenutitle'] = 'Наслов менија ”Алати”';
$string['toolsmenutitledefault'] = 'Алати';
$string['toolsmenutitledesc'] = 'Додајте наслов менија који  желите да прикажете у главној навигацијионој траци';
$string['topicsweeks'] = 'Тематски/Седмични формат курса';
$string['topicsweeksdesc'] = 'Подесите стилове за Тематски/Седмични формат курса';
$string['topmenufontsize'] = 'Величина фонта Горњег менија';
$string['topmenufontsizedesc'] = 'Подесите величину фонта менија у горњем заглављу';
$string['topmenuscount'] = 'Број горњих менија';
$string['topmenuscountdesc'] = 'Подесите број горњих менија које желите да додате у навигациону траку';
$string['usernav'] = 'Заглавље - кориснички мени';
$string['usernavdesc'] = 'Омогућава вам да контролишете све елементе који се појављују у корисничком падајућем менију.';
$string['usernavheading'] = 'Прилагодите кориснички падајући мени';
