<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'sr_cr', branch 'MOODLE_36_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Активности';
$string['addcategory'] = 'Додај категорију';
$string['addcategoryerror'] = 'Није могуће додати категорију';
$string['addexceptionerror'] = 'Дошло је до грешке током додавања изузетка за userid:gradeitem';
$string['addfeedback'] = 'Додај повратне информације';
$string['addgradeletter'] = 'Додај словну оцену';
$string['addidnumbers'] = 'Додај ID бројеве';
$string['additem'] = 'Додај ставку оцене';
$string['addoutcome'] = 'Додај исход учења';
$string['addoutcomeitem'] = 'Додај ставку исхода учења';
$string['addscale'] = 'Додај скалу';
$string['adjustedweight'] = 'Прилагођена тежина';
$string['aggregateextracreditmean'] = 'Средња вредност оцена (са додатним бодовима)';
$string['aggregatemax'] = 'Највећа оцена';
$string['aggregatemean'] = 'Средња вредност оцена';
$string['aggregatemedian'] = 'Медијана оцена';
$string['aggregatemin'] = 'Најнижа оцена';
$string['aggregatemode'] = 'Мод оцена (најчешћа оцена)';
$string['aggregatenotonlygraded'] = 'Укључи празне оцене';
$string['aggregateonlygraded'] = 'Искључи празне оцене';
$string['aggregateonlygraded_help'] = '"Празна" оцена је оцена која недостаје у књизи оцена. То може бити предати задатка који још није оцењен или тест који полазник још увек није покушао да реши итд.

Ово подешавање одређује  да ли ће ове "празне" оцене бити укључене у збирну оцену или ће се рачунати као минимална оцена, на пример 0 за задатак који се оцењује од 0 до 100.';
$string['aggregateoutcomes'] = 'Укључи исходе учења у сумирање';
$string['aggregateoutcomes_help'] = 'Ако је ова опција омогућена, исходи учења су укључени у збирни резултат. Ово може да резултира неочекиваном укупном оценом за категорију.';
$string['aggregatesonly'] = 'Само збирне оцене';
$string['aggregatesubcatsupgradedgrades'] = 'Напомена: Подешавање "Сабери укључујући поткатегорије" је уклоњено као део ажурирања сајта. Будући да је "Сабери укључујући поткатегорије" претходно коришћено у овом курсу препоручујемо да прегледате ову промену у књизи оцена.';
$string['aggregatesum'] = 'Природно';
$string['aggregateweightedmean'] = 'Пондерисана средња вредност оцена';
$string['aggregateweightedmean2'] = 'Проста пондерисана средња вредност оцена';
$string['aggregation'] = 'Сумирање оцена';
$string['aggregationcoef'] = 'Коефицијент сумирања';
$string['aggregationcoefextra'] = 'Додатни бодови';
$string['aggregationcoefextra_help'] = 'Ако је метод сумирања \'Природно\' или \'Једноставна пондерисана средња вредност\' и ако је означено поље за додатне бодове, максимална оцена ставке се не додаје највећој укупној оцени категорије, Ово ће за последицу имати могућност да се достигне максимална оцена у категорији, а да при томе не постоје максималне оцене у свим ставкама оцене. Ако је администратор сајта омогућио оцене веће од максималне, онда могу постојати такве оцене.

Ако је метод сумирања ‘Средња вредност оцена’ (са додатним бодовима) и ако је вредност за додатне бодове већа од нуле, онда су додатни бодови фактор којим се оцена множи пре њеног додавања укупној оцени након израчунавања средње вредности.';
$string['aggregationcoefextrasum'] = 'Додатни бодови';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextrasum_help'] = 'Ако је поље за додатне бодове означено максимална оцена за ставку се не додаје максималној оцени категорије, што резултира могућношћу да максимална оцена у категорији буде достигнута (или чак прекорачена, ако је администратор сајта омогућио ту опцију), а да при томе нема ниједне максималне оцене за било коју од ставки које се оцењују.';
$string['aggregationcoefextraweight'] = 'Пондер додатних бодова';
$string['aggregationcoefextraweight_help'] = 'Ако је пондер додатних бодова постављен тако да буде већи од 0, онда се оцена понаша као додатни кредит у току сумирања. Број је фактор којим се оцена множи пре него што се дода укупној вредности за израчунавање средње вредности.';
$string['aggregationcoefweight'] = 'Пондер ставке';
$string['aggregationcoefweight_help'] = 'Пондер ставке се користи у израчунавању сумарне оцене категорије како би одредио важност ставке, у поређењу са другим ставкама које се оцењују унутар исте категорије.';
$string['aggregation_help'] = 'Начин сумирања одређује како се комбинују оцене у појединој категорији, а могући начини су:

* Средња вредност оцена - збир свих оцена подељен са укупним бројем оцена
* Медијана оцена - средишња оцена у распону од највеће до најмање оцене
* Најнижа оцена
* Највиша оцена
* Мод оцена - оцена која се најчешће појављује
* Природно - збир свих вредности оцена, скалираних по тежини';
$string['aggregationhintdropped'] = '(Одбачено)';
$string['aggregationhintexcluded'] = '(Искључено)';
$string['aggregationhintextra'] = '(Додатни бодови)';
$string['aggregationhintnovalue'] = '(Празно)';
$string['aggregationofa'] = 'Агрегација за {$a}';
$string['aggregationposition'] = 'Позиција сумарне оцене';
$string['aggregationposition_help'] = 'Ово подешавање одређује да ли ће  колоне са оценама за категорије и колона са укупном оценом на курсу бити приказане прве или последње у извештајима из књиге оцена.';
$string['aggregationsvisible'] = 'Доступни начини сумирања';
$string['aggregationsvisiblehelp'] = 'Изаберите све начине сумирања оцена који би требало да су доступни. Држите CTRL тастер за избор више начина.';
$string['allgrades'] = 'Све оцене по категоријама';
$string['allstudents'] = 'Сви полазници';
$string['allusers'] = 'Сви корисници';
$string['autosort'] = 'Аутоматско сортирање';
$string['availableidnumbers'] = 'Расположиви ID бројеви';
$string['average'] = 'Просек';
$string['averagesdecimalpoints'] = 'Број децимала у просецима колона';
$string['averagesdecimalpoints_help'] = 'Ово подешавање одређује број децималних места који ће бити приказана за сваки просек односно да ли ће се користити подешавање броја децималних места за категорију или за ставку оцене (наслеђено).';
$string['averagesdisplaytype'] = 'Тип приказа колоне са средњим оценам';
$string['averagesdisplaytype_help'] = 'Ово подешавање одређује да ли се просек (средња вредност) приказује као број, проценат или слово, односно, да ли ће се користити тип приказа за категорију или за ставку оцене (наслеђено).';
$string['backupwithoutgradebook'] = 'Резервна копија не садржи податке о конфигурацији књиге оцена';
$string['badgrade'] = 'Дата оцена је неисправна';
$string['badlyformattedscale'] = 'Молимо вас унесите списак вредности раздвојених зарезом (неопходне су најмање две вредности).';
$string['baduser'] = 'Дати корисник је неисправан';
$string['bonuspoints'] = 'Додатни поени';
$string['bulkcheckboxes'] = 'Опсежна поља за потврду';
$string['calculatedgrade'] = 'Израчуната оцена';
$string['calculation'] = 'Прорачун';
$string['calculationadd'] = 'Додај прорачун';
$string['calculationedit'] = 'Уреди прорачун';
$string['calculation_help'] = 'Израчунавање оцене представља формулу која се користи како би се одредиле оцене. Формула треба да почиње знаком једнакости (=), и може да користи уобичајене математичке операторе, као што су max, min и sum. Ако желите, другe ставке за оцењивање могу бити укључене у израчунавање тако што ћете уписати ID бројева тих ставки унутар двоструких угластих заграда.';
$string['calculationsaved'] = 'Прорачун сачуван';
$string['calculationview'] = 'Погледај прорачун';
$string['cannotaccessgroup'] = 'Опростите, али не можете да приступите оценама изабраве групе.';
$string['categories'] = 'Категорије';
$string['category'] = 'Категорија';
$string['categoryedit'] = 'Уреди категорију';
$string['categoryname'] = 'Назив категорије';
$string['categorytotal'] = 'Укупна оцена за категорију';
$string['categorytotalfull'] = '{$a->category} укупно';
$string['categorytotalname'] = 'Назив за укупну оцену категоријe';
$string['changedefaults'] = 'Промени подразумевана подешавања';
$string['changereportdefaults'] = 'Промени подразумевана подешавања извештаја';
$string['chooseaction'] = 'Изабери акцију...';
$string['choosecategory'] = 'Изабери категорију';
$string['combo'] = 'Картице и падајући мени';
$string['compact'] = 'Компактно';
$string['componentcontrolsvisibility'] = 'Подешавања активности контролишу да ли је ова ставка оцене сакривена.';
$string['contract'] = 'Скупи категорију';
$string['contributiontocoursetotal'] = 'Допринос укупној оцени на курсу';
$string['controls'] = 'Контроле';
$string['courseavg'] = 'Просек на нивоу курса';
$string['coursegradecategory'] = 'Категорија оцена курса';
$string['coursegradedisplaytype'] = 'Тип приказивања оцена на курсу';
$string['coursegradedisplayupdated'] = 'Тип приказа оцена на курсу је ажуриран.';
$string['coursegradesettings'] = 'Подешавање оцена курса';
$string['coursename'] = 'Назив курса';
$string['coursescales'] = 'Скале курса';
$string['coursesettings'] = 'Подешавања курса';
$string['coursesettingsexplanation'] = 'Подешавања курса одређују како се књига оцена приказује свим учесницима курса.';
$string['coursesiamtaking'] = 'Курсеви које похађам';
$string['coursesiamteaching'] = 'Курсеви које држим';
$string['coursetotal'] = 'Укупно за курс';
$string['createcategory'] = 'Креирај категорију';
$string['createcategoryerror'] = 'Креирање нове категорије немогуће';
$string['creatinggradebooksettings'] = 'Креирање подешавања књиге оцена';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Тренутно надређено сумирање';
$string['curveto'] = 'Прилагоди на';
$string['decimalpoints'] = 'Број децималних места';
$string['decimalpoints_help'] = 'Ово подешавање одређује број децималних места која ће бити приказана за сваку оцену. Оно не утиче на израчунавања оцена, која се врше са прецизношћу од 5 децималних места.';
$string['default'] = 'Подразумевано';
$string['defaultprev'] = 'Подразумевано ({$a})';
$string['deletecategory'] = 'Обриши категорију';
$string['disablegradehistory'] = 'Онемогући историју оцена';
$string['disablegradehistory_help'] = 'Онемогући праћење историје промена у табелама које се односе на оцене. Ово може мало да убрза сервер и сачува простор у бази података.';
$string['displaylettergrade'] = 'Прикажи словне оцене (A, B, C...)';
$string['displaypercent'] = 'Прикажи проценте';
$string['displaypoints'] = 'Прикажи поене';
$string['displayweighted'] = 'Прикажи пондерисане оцене';
$string['dropdown'] = 'Пaдајући мени';
$string['droplow'] = 'Одбаци најниже';
$string['droplowestvalue'] = 'Подесите број најнижих оцене за одбацивање';
$string['droplowestvalues'] = 'Одбаци {$a} најнижу/е/их вредност(и)';
$string['droplow_help'] = 'Ово подешавање омогућује да одређени број најнижих оцена буде искључен из сумирања.';
$string['dropped'] = 'Одбачено';
$string['dropxlowest'] = 'Одбаци X најнижих';
$string['dropxlowestwarning'] = 'Напомена: Ако користите опцију \'одбаци X најнижих оцена\' оцењивање претпоставља да све ставке унутар категорије имају исту вредност бода. Уколико се вредности бода разликују резултати ће бити непредвидљиви';
$string['duplicatescale'] = 'Дуплирај скалу';
$string['edit'] = 'Уреди';
$string['editcalculation'] = 'Уреди прорачун';
$string['editcalculationverbose'] = 'Уреди израчунaвање за {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Уреди повратне информације';
$string['editgrade'] = 'Уреди оцену';
$string['editgradeletters'] = 'Уреди словне оцене';
$string['editoutcome'] = 'Уреди исход учења';
$string['editoutcomes'] = 'Уреди исходе учења';
$string['editscale'] = 'Уреди скалу';
$string['edittree'] = 'Подешавања';
$string['editverbose'] = 'Уреди {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Омогући AJAX';
$string['enableajax_help'] = 'Додаје AJAX функционалност извештају оцењивача, чиме поједностављује и убрзава уобичајене операције. Зависи од тога да ли је корисник укључио Javascript у свом веб читачу.';
$string['enableoutcomes'] = 'Омогући исходе учења';
$string['enableoutcomes_help'] = 'Ако је ова опција омогућена ставке за оцењивање могу се оцењивати коришћењем једне или више скала које су повезане са изјавама о исходима.';
$string['encoding'] = 'Кодирање';
$string['encoding_help'] = 'Одаберите кодирање знакова које се користи за податке. (Стандардни кодни распоред је UTF-8). Ако се случајно одабере погрешно кодирање то ће се приметити при прегледу података за увоз.';
$string['errorcalculationbroken'] = 'Вероватно постоји кружна референца или је формула за израчунавање оштећена';
$string['errorcalculationnoequal'] = 'Формула мора почети знаком једнакости (=1+2)';
$string['errorcalculationunknown'] = 'Неисправна формула';
$string['errorgradevaluenonnumeric'] = 'Добијена је ненумеричка вредност за високу или ниску оцену за';
$string['errornocalculationallowed'] = 'Израчунавања нису дозвољена за ову ставку';
$string['errornocategorisedid'] = 'Није могуће добити некатегорисан id!';
$string['errornocourse'] = 'Није могуће добити информације о курсу';
$string['errorreprintheadersnonnumeric'] = 'Добијена је ненумеричка вредност за поновни испис заглавља';
$string['errorsavegrade'] = 'Опростите, није могуће сачувати оцену.';
$string['errorsettinggrade'] = 'Грешка при покушају да се сачува "{$a->itemname}" оцена за кориснички id {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Грешка при ажурирању подешавања "Сумирај само уписане оцене" за категорију оцена чији је ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Грешка при ажурирању подешавања "Укључи исходе учења у сумирање" за категорију оцена чији је ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Грешка при ажурирању начина сумирања за категорију оцена чији је ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Грешка при ажурирању коефицијента сумирања (пондера или додатних бодова) ставке која се оцењује чији је ID {$a->id}';
$string['eventgradedeleted'] = 'Оцена обрисана';
$string['eventgradelettercreated'] = 'Словна оцена је креирана';
$string['eventgradeletterdeleted'] = 'Словна оцена је обрисана';
$string['eventgradeletterupdated'] = 'Словна оцена је ажурирана';
$string['eventgradeviewed'] = 'Оцене корисника приказане у књизи  оцена.';
$string['eventscalecreated'] = 'Скала је креирана';
$string['eventscaledeleted'] = 'Скала је обрисана';
$string['eventscaleupdated'] = 'Скала је ажурирана';
$string['eventusergraded'] = 'Корисник оцењен';
$string['excluded'] = 'Искључено';
$string['excluded_help'] = 'Ако је означено, оцена неће бити укључена у било које сумирање.';
$string['expand'] = 'Прошири категорију';
$string['export'] = 'Извоз';
$string['exportalloutcomes'] = 'Извези све исходе учења';
$string['exportfeedback'] = 'Укључи повратне информације у извоз';
$string['exportfeedback_desc'] = 'Ово може бити измењено приликом извоза.';
$string['exportformatoptions'] = 'Опције формата за извоз';
$string['exportonlyactive'] = 'Искључи суспендоване кориснике';
$string['exportonlyactive_help'] = 'Приликом извоза биће укључени само полазници који су активни на курсу и нису суспендовани';
$string['exportplugins'] = 'Извези додатке';
$string['exportsettings'] = 'Извези подешавања';
$string['exportto'] = 'Извези у';
$string['externalurl'] = 'Екстерни URL';
$string['externalurl_desc'] = 'Ако је екстерна књига оцена у употреби, URL треба овде специфицирати.';
$string['extracreditvalue'] = 'Додатни бодови за {$a}';
$string['extracreditwarning'] = 'Напомена: Подешавање додатних бодова за све ставке у категорији ће их уклонити из прорачуна оцене, те неће бити укупног броја бодова';
$string['feedback'] = 'Повратне информације';
$string['feedbackadd'] = 'Додај повратне информације';
$string['feedbackedit'] = 'Уреди повратне информације';
$string['feedbackfiles'] = 'Датотеке повратних информација';
$string['feedbackforgradeitems'] = 'Повратна информација за {$a}';
$string['feedback_help'] = 'Ово поље омогућава додавање било каквог коментара о оцени.';
$string['feedbackhistoryfiles'] = 'Датотеке историје повратних информација';
$string['feedbacks'] = 'Повратне информације';
$string['feedbacksaved'] = 'Повратне информације су сачуване';
$string['feedbackview'] = 'Погледај повратне информације';
$string['finalgrade'] = 'Коначна оцена';
$string['finalgrade_help'] = 'Ако је поље за измену означено, оцена може да буде додата или измењена.';
$string['fixedstudents'] = 'Статична колона са полазницима';
$string['fixedstudents_help'] = 'Ова опција фиксира колону са именима полазника и на тај начин омогућава да се колоне са оценама померају хоризонтално, а да се при томе колона са именима  полазника све време види.';
$string['forceimport'] = 'Форсирај увоз';
$string['forceimport_help'] = 'Форсирај увоз оцена чак и ако су оцене ажуриране након извоза датотеке из које је рађен увоз';
$string['forceoff'] = 'Обавезно: Искључено';
$string['forceon'] = 'Обавезно: Укључено';
$string['forelementtypes'] = 'за изабрани {$a}';
$string['forstudents'] = 'За полазнике';
$string['full'] = 'Пун';
$string['fullmode'] = 'Пуни приказ';
$string['generalsettings'] = 'Општа подешавања';
$string['grade'] = 'Оцена';
$string['gradeadministration'] = 'Администрација оцена';
$string['gradealreadyupdated'] = '{$a} оцена није увезено јер су оцене у датотеци из које се ради увоз старије од оних у оцењивачком извештају. Да бисте свеједно наставили са увозом користите опцију за његово форсирање.';
$string['gradeanalysis'] = 'Анализа оцена';
$string['gradebook'] = 'Књига оцена';
$string['gradebookcalculationsfixbutton'] = 'Прихватите измене оцена и исправите грешке у израчунавању';
$string['gradebookcalculationsuptodate'] = 'Прорачуни у књизи оцена су ажурирани. Можда ћете морати поново да учитате ову страницу како бисте видели измене.';
$string['gradebookcalculationswarning'] = 'Напомена: Неке грешке су откривене приликом рачунања оцена које су приказане у књизи оцена. Ако ваш курс још није започет или је у току препоручује се  да се грешке исправе тако што ћете кликнути на доње дугме иако ће неке оцене бити промењене због тога. Ако се ваш курс већ завршио и оцене су предате вероватно нећете желети да исправљате ове грешке.

Новија верзија је {$a->currentversion}; ако користите дневник оцена у верзији {$a->gradebookversion}. Можете видети списак измена на страници <a href="{$a->url}">Измене израчунавања оцена</a>.';
$string['gradebookhiddenerror'] = 'Књига оцена је тренутно подешена тако да све скрива од полазника';
$string['gradebookhistories'] = 'Историје оцена';
$string['gradebooksetup'] = 'Подешавање дневника оцена';
$string['gradeboundary'] = 'Границе словних оцена';
$string['gradeboundary_help'] = 'Ово подешавање одређује минимални проценат изнад којег ће бити додељена словна оцена.';
$string['gradecategories'] = 'Категорије оцена';
$string['gradecategory'] = 'Категорија оцена';
$string['gradecategoryonmodform'] = 'Категорија оцена';
$string['gradecategoryonmodform_help'] = 'Ово подешавање контролише категорију у коју се смештају оцене за ову активност унутар књиге оцена.';
$string['gradecategorysettings'] = 'Подешавања категорије оцена';
$string['gradedisplay'] = 'Приказ оцена';
$string['gradedisplaytype'] = 'Тип приказа оцена';
$string['gradedisplaytype_help'] = 'Ово подешавање одређује начин на који ће оцене бити приказане у извештајима оцењивача и корисника.

* Број - праве оцене
* Проценат
* Слово - слова или речи се користе за приказ распона оцена';
$string['gradedon'] = 'Оцењено: $а';
$string['gradeexport'] = 'Извоз оцена';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Прилагођена поља профила укључена у извоз оцена';
$string['gradeexportcustomprofilefields_desc'] = 'Укључи у извоз оцена ова прилагођена поља профила, раздвојена зарезима.';
$string['gradeexportdecimalpoints'] = 'Број децималних места при извозу оцена';
$string['gradeexportdecimalpoints_desc'] = 'Број децималних места за приказ при извозу. Ова вредност може бити промењена током извоза.';
$string['gradeexportdisplaytype'] = 'Тип приказа за извоз оцена';
$string['gradeexportdisplaytype_desc'] = 'Оцене могу бити приказане као цели бројеви, као проценти (у односу на најмање и највеће оцене) или као слова (А, Б, Ц итд.). Ово може бити промењено током експортовања.';
$string['gradeexportdisplaytypes'] = 'Типови приказа извоза оцена';
$string['gradeexportuserprofilefields'] = 'Поља корисничког профила укључена у извоз оцена';
$string['gradeexportuserprofilefields_desc'] = 'Укључи у извоз оцена ова поља корисничког профила, раздвојена зарезима.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Почетна минимална и почетна максимална оцена';
$string['gradehelp'] = 'Помоћ за оцене';
$string['gradehistorylifetime'] = 'Трајање историје оцена';
$string['gradehistorylifetime_help'] = 'Ово одређује колико дуго желите да чувате историју промена у табелама које су повезане са оценама. Препоручено је да историју чувате што је дуже могуће. Уколико будете имали проблема са перформансама система или ако имате ограничен простор за базу података, покушајте да поставите нижу вредност.';
$string['gradeimport'] = 'Увоз оцена';
$string['gradeimportfailed'] = 'Увоз оцена није успео. Више информација:';
$string['gradeitem'] = 'Ставка оцене';
$string['gradeitemaddusers'] = 'Искључи из оцењивања';
$string['gradeitemadvanced'] = 'Напредне опције за ставке оцене';
$string['gradeitemadvanced_help'] = 'Изабери све елементе које треба приказати као напредне када се уређују ставке оцена.';
$string['gradeitemislocked'] = 'Ова активност је закључана у књизи оцена. Промене које су начињене у оквиру ове активности неће бити копиране у књигу оцена све док се иста не откључа.';
$string['gradeitemlocked'] = 'Оцењивање закључано';
$string['gradeitemmembersselected'] = 'Искључено из оцењивања';
$string['gradeitemminmax'] = 'Минимална оцена и максимална оцена које су одређене у подешавањима ставке за оцењивање';
$string['gradeitemnonmembers'] = 'Укључено у оцењивање';
$string['gradeitemremovemembers'] = 'Укључи у оцењивање';
$string['gradeitems'] = 'Ставке оцене';
$string['gradeitemsettings'] = 'Подешавања ставки оцене';
$string['gradeitemsinc'] = 'Ставке оцене које треба укључити';
$string['gradeletter'] = 'Словна оцена';
$string['gradeletter_help'] = 'Словне оцене су А, Б, Ц... или речи, нпр. одличан, добар, довољан,... које се користе да представе распон оцена.';
$string['gradeletternote'] = 'Да бисте избрисали словну оцену само обришите било које од <br /> три текстулна поља за то слово и сачувајте промене.';
$string['gradeletteroverridden'] = 'Подразумеване словне оцене су тренутно измењене.';
$string['gradeletters'] = 'Словне оцене';
$string['gradelocked'] = 'Оцена је закључана';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Највећа оцена';
$string['grademax_help'] = 'Ово подешавање одређује максималну оцену када се као тип оцене користи бројчана вредност. Максимална оцена за активност се одређује на страници за подешавање те активности.';
$string['grademin'] = 'Најмања оцена';
$string['grademin_help'] = 'Ово подешавање одређује минималну оцену када се као тип оцене користи бројчана вредност.';
$string['gradeoutcomeitem'] = 'Оцени ставку исхода учења';
$string['gradeoutcomes'] = 'Исходи учења';
$string['gradeoutcomescourses'] = 'Исходи учења курса';
$string['gradepass'] = 'Оцена за пролаз';
$string['gradepassgreaterthangrade'] = 'Прелазна оцена не може бити већа од максимално могуће оцене {$a}';
$string['gradepass_help'] = 'Ово подешавање одређује минималну оцену потребну за пролаз. Вредност се користи за процену завршеност активности и курса, као и у књизи оцена где су прелазне оцене означене зеленом, а непрелазне црвеном бојом.';
$string['gradepointdefault'] = 'Подразумeвани број поена';
$string['gradepointdefault_help'] = 'Ово подешавање одређује подразумевану вредност за број поена који је на располагању приликом оцењивања активности.';
$string['gradepointdefault_validateerror'] = 'Ови подешавање мора да буде цео број између 1 и максималног броја поена.';
$string['gradepointmax'] = 'Максималан број поена';
$string['gradepointmax_help'] = 'Ово подешавање одрећује максималан број поена који је на располаgању приликом оцењивања активности.';
$string['gradepointmax_validateerror'] = 'Ови подешавање мора да буде цео број између 1 и 10000';
$string['gradepreferences'] = 'Параметри оцене';
$string['gradepreferenceshelp'] = 'Помоћ за параметре оцене';
$string['gradepublishing'] = 'Омогући објављивање';
$string['gradepublishing_help'] = 'Објављивање оцена је начин увоза/извоза оцена путем URL-а без обавезне пријаве на Moodle сајт. Уколико је омогућено, администратори и други корисници са правом објављивања оцена (подразумевано су то само корисници са улогом менаџера) имају на располагању подешавања извозног објављивања оцена у свакој књизи оцена.';
$string['gradepublishinglink'] = 'Преузми: {$a}';
$string['gradereport'] = 'Извештај o оценама';
$string['graderreport'] = 'Извештај оцењивача';
$string['grades'] = 'Оцене';
$string['gradesforuser'] = 'Оцене за {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Упозорење: брисање активност у току! Неке оцене биће уклоњене.';
$string['gradesmoduledeletionprefix'] = '[Брисање у току]';
$string['gradesonly'] = 'Само оцене';
$string['gradessettings'] = 'Подешавања оцена';
$string['gradetype'] = 'Тип оцене';
$string['gradetype_help'] = 'Постоје 4 типа оцена:

* Ништа - оцењивање није могуће
* Вредност - бројчана вредност са максималном и минималном вредношћу
* Скала - ставка на списку
* Текст - само повратне информације

Само вредности и скале могу да се сумирају. Тип оцене за поједину активност се одређује на страници за подешавања те активности.';
$string['gradevaluetoobig'] = 'Једна од вредности оцена је већа од дозвољеног максимума ({$a})';
$string['gradeview'] = 'Погледај оцену';
$string['gradewasmodifiedduringediting'] = 'Оцена унета под ставком {$a->itemname} за полазника са корисничким именом {$a->username} је игнорисана јер ју је касније ажурирао неко други.';
$string['gradeweighthelp'] = 'Помоћ за пондер оцена';
$string['groupavg'] = 'Просек групе';
$string['hidden'] = 'Сакривено';
$string['hiddenasdate'] = 'Прикажи датум за скривене оцене';
$string['hiddenasdate_help'] = 'Уколико корисник не може да види сакривене оцене прикажите датум када је оцена постављена уместо знака \'-\'.';
$string['hidden_help'] = 'Ако је означено, оцене су сакривене од полазника. Ако желите можете поставити опцију \'сакривено до дана\' како би се оцене објавиле након што је оцењивање завршено.';
$string['hiddenuntil'] = 'Сакривен до';
$string['hiddenuntildate'] = 'Сакривен до: {$a}';
$string['hideadvanced'] = 'Сакриј напредне опције';
$string['hideaverages'] = 'Сакриј просеке';
$string['hidecalculations'] = 'Сакриј прорачуне';
$string['hidecategory'] = 'Сакривено';
$string['hideeyecons'] = 'Сакриј иконице прикажи/сакриј';
$string['hidefeedback'] = 'Сакриј повратне информације';
$string['hideforcedsettings'] = 'Сакриј принудна подешавања';
$string['hideforcedsettings_help'] = 'Не приказуј принудна подешавања у корисничком интерфејсу за оцењивање';
$string['hidegroups'] = 'Сакриј групе';
$string['hidelocks'] = 'Сакриј закључавања';
$string['hidenooutcomes'] = 'Прикажи исходе учења';
$string['hidequickfeedback'] = 'Сакриј брзе повратне информације';
$string['hideranges'] = 'Сакриј опсеге';
$string['hidetotalifhiddenitems'] = 'Сакриј укупне оцене ако садрже скривене ставке';
$string['hidetotalifhiddenitems_help'] = 'Ово подешавање одређује да ли се укупне оцене које садрже сакривене ставке приказују полазницима или се замењују цртицом (-). Ако се приказују, укупна оцена може бити израчуната или без или са сакривеним ставкама.

Ако су сакривене ставке искључене, укупна оцена ће бити различита од укупне оцене коју види предавач у извештају оцењивача, зато што предавач увек види укупну оцену за све ставке, без обзира јесу ли оне сакривене или не. Ако су сакривене ставке укључене у укупну оцену, полазници могу да израчунају оцене за сакривене ставке.';
$string['hidetotalshowexhiddenitems'] = 'Прикажи укупне оцене без сакривених ставки';
$string['hidetotalshowinchiddenitems'] = 'Прикажи укупне оцене укључујући сакривене ставке';
$string['hideverbose'] = 'Сакриј {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Сортирај по висини оцене - растући низ';
$string['highgradedescending'] = 'Сортирај по висини оцене - опадајући низ';
$string['highgradeletter'] = 'Горња граница';
$string['identifier'] = 'Идентификуј корисника према';
$string['idnumbers'] = 'ID бројеви';
$string['ignore'] = 'Игнориши';
$string['import'] = 'Увези';
$string['importcsv'] = 'Увези CSV';
$string['importcsv_help'] = 'Оцене се могу увести из CSV датотеке следећег формата:

* Сваки ред датотеке садржи један запис
* Сваки запис је низ података одвојених зарезима или алтернативним граничним знацима
* Први запис садржи списак назива поља дефинишући формат за остатак датотеке
* Поље које садржи идентитет корисника је обавезно - корисничко име, ID број или адреса електронске поште

Датотека одговарајућег формата се може добити извозом неких оцена. Та се датотека потом може уредити и сачувати у CSV формату.';
$string['importcustom'] = 'Увези као наменски прилагођене исходе учења (само за овај курс)';
$string['importerror'] = 'Дошло је до грешке, овај скрипт није био позван са правим параметрима';
$string['importfailed'] = 'Увоз није успео. Ништа од података није увезено.';
$string['importfeedback'] = 'Увези повратне информације';
$string['importfile'] = 'Увези датотеку';
$string['importfilemissing'] = 'Ниједна датотека није примљена, вратите се на образац и уверите се да сте проследили исправну датотеку.';
$string['importfrom'] = 'Увези из';
$string['importoutcomenofile'] = 'Постављена датотека је празна или оштећена. Молимо, проверите да ли је датотека исправна. Проблем је откривен у реду {$a}; ово је покренуто због редова са подацима који нису имали једнак број колона као први (насловни) ред, или уколико су недостајала очекивана заглавља у увезеној датотеци. Погледајте извезену датотеку за пример датотеке исправним заглављем.';
$string['importoutcomes'] = 'Увези исходе учења';
$string['importoutcomes_help'] = 'Исходи учења могу бити увезени из CSV датотеке која има формат као и CSV датотека за извоз исхода учења.';
$string['importoutcomesuccess'] = 'Увезен исход учења "{$a->name}" са ID #{$a->id}';
$string['importplugins'] = 'Увези додатке';
$string['importpreview'] = 'Преглед увезених оцена';
$string['importsettings'] = 'Подешавања увоза';
$string['importskippednomanagescale'] = 'Немате овлашћење за додавање нове скале оцењивања, тако да је исход учења"{$a}" изузет  јер је захтевао креирање нове скале';
$string['importskippedoutcome'] = 'Исход са краћим називом "{$a}" већ постоји у овом контексту, онај из увезене датотеке је прескочен.';
$string['importstandard'] = 'Увези као стандардне исходе учења';
$string['importsuccess'] = 'Успешан увоз оцена';
$string['importxml'] = 'Увези XML';
$string['includescalesinaggregation'] = 'Укључи скале у сумирање';
$string['includescalesinaggregation_help'] = 'Можете променити да се скале за оцењивање укључе као бројеви у свим збирним оценама у свим књигама оцена на свим курсевима. УПОЗОРЕЊЕ: промена овог подешавања покренуће поновно израчунавање свих збирних оцена.';
$string['incorrectcourseid'] = 'ID курса је нетачан';
$string['incorrectcustomscale'] = '(Неисправна прилагођена скала, молимо промените.)';
$string['incorrectminmax'] = 'Минимална вредност мора бити мања од максималне';
$string['inherit'] = 'Наслеђено';
$string['intersectioninfo'] = 'Полазник/Оцена инфо';
$string['invalidgradeexporteddate'] = 'Датум извоза није валидан јер је од пре више од годину дана, или је у будућности или његов формат није коректан.';
$string['item'] = 'Ставка';
$string['iteminfo'] = 'Информације о ставци';
$string['iteminfo_help'] = 'Ово подешавање обезбеђује простор за унос информација о ставци. Информације се нигде другде не приказују.';
$string['itemname'] = 'Назив ставке';
$string['itemnamehelp'] = 'Назив ове ставке добијен од модула.';
$string['items'] = 'Ставке';
$string['itemsedit'] = 'Уреди ставку оцене';
$string['keephigh'] = 'Задржи највећу';
$string['keephighestvalues'] = 'Задржи {$a} највишу/е/их оцена';
$string['keephigh_help'] = 'Ако је ова опција подешена, чуваће се само X највиших оцена, где је X одабрана вредност за ову опцију.';
$string['keymanager'] = 'Управљање кључевима';
$string['lessthanmin'] = 'Оцена унета за {$a->itemname} за корисника {$a->username} је мања од минимално дозвољене';
$string['letter'] = 'Слово';
$string['lettergrade'] = 'Словна оцена';
$string['lettergradenonnumber'] = 'Најнижа и/или највиша оцена нису биле нумеричке за';
$string['letterpercentage'] = 'Слово (проценат)';
$string['letterreal'] = 'Слово (реална вредност)';
$string['letters'] = 'Слова';
$string['linkedactivity'] = 'Линкована активност';
$string['linkedactivity_help'] = 'Ово подешавање одређује активност са којом је овај исход учења повезан. Ово се може користити за мерење постигнућа полазника која се не процењују помоћу оцена активности.';
$string['linktoactivity'] = 'Линк ка {$a->name} активности {$a->title}';
$string['lock'] = 'Закључај';
$string['locked'] = 'Закључано';
$string['locked_help'] = 'Ако је означено, оцене су закључане и више не могу бити аутоматски ажуриране од стране припадајуће активности.';
$string['locktime'] = 'Закључано након';
$string['locktimedate'] = 'Закључај након: {$a}';
$string['lockverbose'] = 'Закључај {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Најниже';
$string['lowgradeletter'] = 'Доња граница';
$string['manualitem'] = 'Ручне ставке';
$string['mapfrom'] = 'Пресликај из';
$string['mapfrom_help'] = 'Одаберите колону у табели која садржи податке за идентификацију корисника, као што је корисничко име, идентификациони број корисника или адреса електронске поште.';
$string['mappings'] = 'Пресликавање ставки оцена';
$string['mappings_help'] = 'За сваку колону оцена у табели одаберите одговарајућу ставку за оцењивање у коју ће се увести оцене.';
$string['mapto'] = 'Пресликај у';
$string['mapto_help'] = 'Одаберите исте податке за идентификацију као што су одабрани за "Пресликај из"';
$string['max'] = 'Највише';
$string['maxgrade'] = 'Максимална оцена';
$string['meanall'] = 'Све оцене';
$string['meangraded'] = 'Уписане оцене';
$string['meanselection'] = 'Оцене изабране за рачунање просека колоне';
$string['meanselection_help'] = 'Ово подешавање одредите да ли  поља без уписане оцене треба да буду укључене у рачунање просека (средње вредности) за сваку категорију или ставку оцене.';
$string['median'] = 'Медијана';
$string['min'] = 'Најниже';
$string['minimum_show'] = 'Прикажи најнижу оцену';
$string['minimum_show_help'] = 'Минимална оцена се користи за рачунање оцена и тежина. Ако није приказана минимална оцена има подразумевану вредност нула и не може се уређивати.';
$string['minmaxtouse'] = 'Минималне и максималне оцене коришћене у израчунавању';
$string['minmaxtouse_desc'] = 'Подешавање које утврђује да ли да се користе почетне минималне и максималне вредности оцене када се даје конкретна оцена или да се минималне и максималне вредности посебно утврде у подешавањима, када се израчунава оцена приказана у књизи оцена. Препорука је да се ово подешавање модификује у времену смањене активности будући да ће се све оцене поново рачунати што може довести до повећаног оптерећења на серверу.';
$string['minmaxtouse_help'] = 'Подешавање које утврђује да ли да се користе почетне минималне и максималне вредности оцене када се даје конкретна оцена или да се минималне и максималне вредности посебно утврде у подешавањима, када се израчунава оцена приказана у књизи оцена.';
$string['minmaxupgradedgrades'] = 'Напомена: Неке оцене су измењене ради решавања питања неусаглашености у књизи оцена изазване променом минималних и максималних оцена коришћених при израчунавању приказане оцене. Препоручује се да се измене прегледају у прихвате.';
$string['minmaxupgradefixbutton'] = 'Разреши недоследности';
$string['minmaxupgradewarning'] = 'Напомена: Уочена је неусаглашеност између неких оцена изазвана променом минималних и максималних оцена коришћених при израчунавању оцене приказане у књизи оцена. Препоручује се да се та неусаглашеност реши кликом на дугме испод, мада ће то довести до измене неких оцена.';
$string['missingitemtypeoreid'] = 'Кључ низа (itemtype или eid) недостаје од другог параметра за grade_edit_tree_column_select::get_item_cell($item, $params)';
$string['missingscale'] = 'Скала за оцењивање мора бити изабрана';
$string['mode'] = 'Мод';
$string['modgrade'] = 'Оцена';
$string['modgradecantchangegradetype'] = 'Не можете променити тип је већ постоје оцене за ову ставку.';
$string['modgradecantchangegradetypemsg'] = 'Неке оцене су већ додељене, тако да се тип оцене не може мењати. Ако желите да измените максималну оцену морате прво одабрати да ли ће се или неће скалирати постојеће оцене.';
$string['modgradecantchangegradetyporscalemsg'] = 'Неке оцене су већ додељене, тако да се тип оцене и скала не могу мењати.';
$string['modgradecantchangeratingmaxgrade'] = 'Не можете именити максималну оцену кад већ постоје оцене за активност са рангирањем.';
$string['modgradecantchangescale'] = 'Не можете изменити скалу јер већ постоје оцене за ову ставку.';
$string['modgradecategorycantchangegradetypemsg'] = 'За ову категорију су везане ставке за оцењивање којима су преписане вредности. Стога су неке оцене већ додељене па се у тим случајевима тип оцене не може мењати. Ако желите да измените максималну могућу оцену морате прво одабрати да ли ће то иницирати скалирање постојећих оцена или ипак неће.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'За ову категорију су везане ставке за оцењивање којима су преписане вредности. Стога су неке оцене већ додељене па се у тим случајевима тип оцене и скала не могу мењати.';
$string['modgradecategoryrescalegrades'] = 'Скалирај преписане оцене';
$string['modgradecategoryrescalegrades_help'] = 'Када се мењају максималне могуће оцене за ставку за оцењивање морате специфицирати да ли ће то проузроковати и промену постојећих процентуалних оцена или ипак неће.

Ако је ово подешавање постављено на \'Да\', свака постојећа преписана оцена ће бити скалирана тако да процентуална оцена остане иста.

На пример, уколико је ова опција постављена на \'Да\', измена максималане могуће оцене за неку ставку са 10 на 20 би проузроковала скалирање оцене 6/10 (60%) на 12/20 (60%). Са овом опцијом постављеном на \'Не\' оцена би остала непромењена, што би захтевало ручно прилагођавање ставки за оцењивање да би се обезбедили тачни резултати.';
$string['modgradedonotmodify'] = 'Без измена постојећих оцена';
$string['modgradeerrorbadpoint'] = 'Неисправна вредност оцене. Мора да буде цео број између 1 и {$a}';
$string['modgradeerrorbadscale'] = 'Изабрана је неисправна скала. Проверите да ли сте изабрали скалу из доњег падајућег менија.';
$string['modgrade_help'] = 'Изаберите тип оцењивања  који се користи за ову активност. Ако је изабрана "скала", онда можете да изаберете врсту скалу из падајућег менија. Ако користите оцењивање помоћу "поена", онда можете да унесете максималну оцену која ће бити на располагању за ову активност.';
$string['modgrademaxgrade'] = 'Максимална оцена';
$string['modgraderescalegrades'] = 'Скалирај постојеће оцене';
$string['modgraderescalegrades_help'] = 'Када мењате максималну оцену ставке за оцењивање морате специфицирати да ли ће то проузроковати и измену процентуалне оцене или неће.

Ако је ово подешавање постављено на \'Да\', све постојеће оцене ће бити скалиране тако да процентуална оцена остане иста.

На пример, ако је ова опција постављена на \'Да\', измена максималне оцене за ставку са 10 на 20 би проузроковала скалирање оцене 6/10 (60%) на 12/20 (60%). А ако је ова опција постављена на \'Не\', оцена би била измењена са 6/10 (60%) на 6/20 (30%), што би захтевало ручну корекцију ставки за оцењивање да би се обезбедили тачни резултати.';
$string['modgradetype'] = 'Тип';
$string['modgradetypenone'] = 'Ниједан';
$string['modgradetypepoint'] = 'Поен';
$string['modgradetypescale'] = 'Скала';
$string['morethanmax'] = 'Оцена унета за {$a->itemname} за корисника {$a->username} је већа од максимално дозвољене';
$string['moveselectedto'] = 'Премести изабране ставке у';
$string['movingelement'] = 'Померање {$a}';
$string['multfactor'] = 'Мултипликатор';
$string['multfactor_help'] = 'Мултипликатор је фактор којим ће све оцене за ову ставку бити помножене, са највећом вредношћу максималне оцене. На пример, ако је мултипликатор 2 а максимална оцена 100, онда ће све оцене мање од 50 бити помножене са 2, а све оцене изнад 50 промењене у 100.';
$string['multfactorvalue'] = 'Вредност мултипликатора за {$a}';
$string['mustchooserescaleyesorno'] = 'Морате одабрати да ли ће се скалирати постојеће оцене или неће.';
$string['mygrades'] = 'Линк ка оценама у корисничком менију';
$string['mygrades_desc'] = 'Ово подешавање вам даје могућност повезивања са екстерном књигом оцена из корисничког менија.';
$string['mypreferences'] = 'Моја подешавања';
$string['myreportpreferences'] = 'Мој извештај - подешавања';
$string['navmethod'] = 'Метод навигације';
$string['neverdeletehistory'] = 'Никада не бриши историју';
$string['newcategory'] = 'Нова категорија';
$string['newitem'] = 'Нова ставка оцене';
$string['newoutcomeitem'] = 'Нови исход учења';
$string['no'] = 'Не';
$string['nocategories'] = 'Категорије оцена за овај курс не могу бити додате или пронађене';
$string['nocategoryname'] = 'Није дат назив категорије';
$string['nocategoryview'] = 'Нема категорије за приказ';
$string['nocourses'] = 'Још увек нема курсева';
$string['noforce'] = 'Не форсирај подешавања';
$string['nogradeletters'] = 'Нема подешених словних оцена';
$string['nogradesreturned'] = 'Нема добијених оцена';
$string['noidnumber'] = 'Нема ID броја';
$string['nolettergrade'] = 'Нема словне оцене за';
$string['nomode'] = 'Није применљиво';
$string['nonnumericweight'] = 'Добијена је ненумеричка вредност за';
$string['nonunlockableverbose'] = 'Ова оцена не може се откључати док се не откључа {$a->itemname}.';
$string['nonweightedpct'] = 'непондерисани %';
$string['nooutcome'] = 'Без исхода учења';
$string['nooutcomes'] = 'Ставке исхода учења морају бити повезане са исходом курса, али за овај курс не постоје исхода . Да ли желите да додате исход учења?';
$string['nopermissiontoresetweights'] = 'Немате овлашћења за ресетовање пондера';
$string['nopublish'] = 'Не објављивати';
$string['noreports'] = 'Нисте уписани нити се предавач ни на једном курсу на овом сајту.';
$string['norolesdefined'] = 'Ниједна улога није дефинисана у Администрација > Oцене > Општа подешавања > Улоге које се оцењују';
$string['noscales'] = 'Исходи морају бити повезани са скалом курса или глобалном скалом';
$string['noselectedcategories'] = 'није изабрана ниједна категорија.';
$string['noselecteditems'] = 'није изабрана ниједна ставка.';
$string['notenrolled'] = 'Тренутно нисте уписани ни на један курс.';
$string['notteachererror'] = 'Морате бити предавач да бисте користили ову опцију.';
$string['nousersloaded'] = 'Нису учитани корисници';
$string['numberofgrades'] = 'Број оцена';
$string['onascaleof'] = 'на скали од {$a->grademin} до {$a->grademax}';
$string['operations'] = 'Операције';
$string['options'] = 'Опције';
$string['others'] = 'Остало';
$string['outcome'] = 'Исход учења';
$string['outcomeassigntocourse'] = 'Додели други исход учења овом курсу';
$string['outcomecategory'] = 'Креирај исходе у категорији';
$string['outcomecategorynew'] = 'Нова категорија';
$string['outcomeconfirmdelete'] = 'Да ли сте сигурни да желите да обришете исход учења "{$a}"?';
$string['outcomecreate'] = 'Додај нови исход учења';
$string['outcomedelete'] = 'Обриши исход учења';
$string['outcomefullname'] = 'Пуно име';
$string['outcome_help'] = 'Ово подешавање одређује исход учења који ће ова ставка оцене представљати у књизи оцена.';
$string['outcomeitem'] = 'Ставка исхода учења';
$string['outcomeitemsedit'] = 'Уреди ставку исхода учења';
$string['outcomereport'] = 'Извештај о исходима учења';
$string['outcomes'] = 'Исходи учења';
$string['outcomescourse'] = 'Исходи учења коришћени на курсу';
$string['outcomescoursecustom'] = 'Користе се нестандардни исходи учења (не могу се уклонити)';
$string['outcomescoursenotused'] = 'Не користе се стандардни исходи учења';
$string['outcomescourseused'] = 'Користе се стандардни исходи учења (не могу се уклонити)';
$string['outcomescustom'] = 'Нестандардни исходи учења';
$string['outcomeshortname'] = 'Скраћени назив';
$string['outcomesstandard'] = 'Стандардни исходи учења';
$string['outcomesstandardavailable'] = 'Расположиви стандардни исходи учења';
$string['outcomestandard'] = 'Стандардни исход учења';
$string['outcomestandard_help'] = 'Стандардни исход учења је доступан у свим курсевима на сајту.';
$string['overallaverage'] = 'Свеукупан просек';
$string['overridden'] = 'Поништено';
$string['overridden_help'] = 'Ако је означено, оцене не могу више да се мењају унутар припадајуће активности.

Када се оцена мења унутар извештаја оцењивача, поље за измену оцене је аутоматски означено.
Међутим, ознака се може уклонити како би се се дозволило да оцена буде промењена унутар припадајуће активности.';
$string['overriddennotice'] = 'Ваша завршна оцена за ову активност је ручно подешена';
$string['overridecat'] = 'Дозволи да категорије оцена могу ручно да се мењају';
$string['overridecat_help'] = 'Искључивање овог подешавања, онемогућава кориснике да мењају категорије оцена.';
$string['overridesitedefaultgradedisplaytype'] = 'Поништи подразумеване вредности на нивоу сајта';
$string['overridesitedefaultgradedisplaytype_help'] = 'Ако је означено, могу се подешавати словне оцене и њихови опсези на нивоу курса, уместо да се користе подразумевана подешавања на нивоу сајта.';
$string['overrideweightofa'] = 'Измени пондер за {$a}';
$string['parentcategory'] = 'Надређена категорија';
$string['pctoftotalgrade'] = '% од укупне оцене';
$string['percent'] = 'Проценат';
$string['percentage'] = 'Проценат';
$string['percentageletter'] = 'Проценат (слово)';
$string['percentagereal'] = 'Проценат (реална вредност)';
$string['percentascending'] = 'Сортирај по процентима - растући низ';
$string['percentdescending'] = 'Сортирај по процентима - опадајући низ';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Помак';
$string['plusfactor_help'] = 'Помак је број који се додаје свакој оцени за ову ставку, након примене мултипликатора.';
$string['plusfactorvalue'] = 'Офсет (додатnа) вредност за {$a}';
$string['points'] = 'поена';
$string['pointsascending'] = 'Сортирај по поенима - растући низ';
$string['pointsdescending'] = 'Сортирај по поенима - опадајући низ';
$string['positionfirst'] = 'Први';
$string['positionlast'] = 'Последњи';
$string['preferences'] = 'Подешавања';
$string['prefgeneral'] = 'Општа подешавања';
$string['prefletters'] = 'Словне оцене и границе';
$string['prefrows'] = 'Специјални редови';
$string['prefshow'] = 'Прекидачи прикажи/сакриј';
$string['previewrows'] = 'Преглед редова';
$string['privacy:metadata:categorieshistory'] = 'Досије претходних верзија категорија оцена';
$string['privacy:metadata:filepurpose'] = 'Датотеке повратних информација смештене у књизи оцена за корисника.';
$string['privacy:metadata:grade_import_newitem'] = 'Привремена табела за складиштење нових назива за grade_item из увоза оцена';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Јединствени групни кôд за идентификацију једног групног увоза';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Корисник који увози податке';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Назив нове ставке оцене';
$string['privacy:metadata:grade_import_values'] = 'Привремена табела за увоз оцена';
$string['privacy:metadata:grade_import_values:feedback'] = 'Повратне информације уз оцену';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Необрађена вредност оцене';
$string['privacy:metadata:grade_import_values:importcode'] = 'Јединствени групни кôд за идентификацију једног групног увоза';
$string['privacy:metadata:grade_import_values:importer'] = 'Корисник који увози податке';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Означи ако су увезене само повратне информације';
$string['privacy:metadata:grade_import_values:userid'] = 'Корисник чије су оцене увезене';
$string['privacy:metadata:grades'] = 'Досије оцена';
$string['privacy:metadata:grades:aggregationstatus'] = 'Статус сумирања';
$string['privacy:metadata:grades:aggregationweight'] = 'Пондер у сумирању';
$string['privacy:metadata:grades:feedback'] = 'Повратне информације';
$string['privacy:metadata:grades:finalgrade'] = 'Оцена';
$string['privacy:metadata:gradeshistory'] = 'Досије раније стечених оцена';
$string['privacy:metadata:grades:information'] = 'Додатне информације о оцени';
$string['privacy:metadata:grades:timemodified'] = 'Време када је оцена последњи пут измењена';
$string['privacy:metadata:grades:userid'] = 'ID ознака корисника чија је оцена';
$string['privacy:metadata:grades:usermodified'] = 'ID ознака корисника који је последњи изменио досије';
$string['privacy:metadata:history:loggeduser'] = 'ID ознака корисника који је био пријављен на систем када је објављена нова  верзија оцена';
$string['privacy:metadata:history:timemodified'] = 'Време када је објављена нова  верзија оцена';
$string['privacy:metadata:itemshistory'] = 'Досије ранијих верзија ставки за оцењивање';
$string['privacy:metadata:outcomes'] = 'Досије исхода';
$string['privacy:metadata:outcomeshistory'] = 'Досије ранијих верзија исхода';
$string['privacy:metadata:outcomes:timemodified'] = 'Време када је запис измењен';
$string['privacy:metadata:outcomes:usermodified'] = 'Корисник који је последњи изменио досије';
$string['privacy:metadata:scale'] = 'Досије скала';
$string['privacy:metadata:scalehistory'] = 'Досије претходних верзија скала';
$string['privacy:metadata:scale:timemodified'] = 'Време када је запис последњи пут измењен';
$string['privacy:metadata:scale:userid'] = 'Корисник који је последњи изменио досије';
$string['privacy:path:relatedtome'] = 'Повезано са мном';
$string['privacy:request:historyactiondelete'] = 'Обриши';
$string['privacy:request:historyactioninsert'] = 'Уметни';
$string['privacy:request:historyactionupdate'] = 'Ажурирај';
$string['privacy:request:unknowndeletedgradeitem'] = 'Непознато (ставка оцене је обрисана)';
$string['profilereport'] = 'Извештај корисничког профила';
$string['profilereport_help'] = 'Извештај о оценама који се користи на страници са профилом корисника.';
$string['publishing'] = 'Објављивање';
$string['publishingoptions'] = 'Опције за објављивање оцена';
$string['quickfeedback'] = 'Брзе повратне информације';
$string['quickgrading'] = 'Брзо оцењивање';
$string['quickgrading_help'] = 'Ако је ова опција омогућена, када је уређивање укључено , за сваку оцену се појављује поље за унос текста, што омогућава да се истовремено уређује већи број оцена. Када се кликне да на дугме за ажурирање, промене су сачуване и истакнуте.

Имајте у виду да је, приликом уређивања оцене у извештају оцењивача, постављена заставица (индикатор) измене, што значи да оцена не може више да се мења унутар припадајуће активности.';
$string['range'] = 'Опсег';
$string['rangedecimals'] = 'Број децималних места опсега';
$string['rangedecimals_help'] = 'Број децималних места које треба приказати за опсег .';
$string['rangesdecimalpoints'] = 'Децимале приказане у опсезима';
$string['rangesdecimalpoints_help'] = 'Ово подешавање одређује број децималних места који ће бити приказан за сваки опсег, односно да ли ће бити коришћено подешавање броја децималних места за категорију или за ставку оцене (наслеђено)';
$string['rangesdisplaytype'] = 'Тип приказа опсега';
$string['rangesdisplaytype_help'] = 'Ово подешавање одређује да ли се опсег приказује као број, проценат или слово, односно, да ли ће се користити тип приказа за категорију или за ставку оцене (наслеђено).';
$string['rank'] = 'Ранг';
$string['rawpct'] = 'Необрађени %';
$string['real'] = 'Реална вредност';
$string['realletter'] = 'Реална вредност (слово)';
$string['realpercentage'] = 'Реална вредност (проценат)';
$string['recalculatinggrades'] = 'Оцене се прерачунавају';
$string['recovergradesdefault'] = 'Поврати подразумеване оцене';
$string['recovergradesdefault_help'] = 'Стандардно, враћа старе оцене када поново уписујете корисника на курс.';
$string['refreshpreview'] = 'Освежи преглед';
$string['regradeanyway'] = 'Ипак поново оцени';
$string['removeallcoursegrades'] = 'Обриши све оцене';
$string['removeallcoursegrades_help'] = 'Ако је означено све ставке за оцењивање које су ручно додате у дневник биће обрисане, заједно са оценама и подацима о преписаним, искљученим, сакривеним и закључаним оценама. Остаће само ставке за оцењивање које су повезане са активностима на курсу.';
$string['removeallcourseitems'] = 'Обриши све ставке и категорије';
$string['removeallcourseitems_help'] = 'Ако је означено све ставке за оцењивање које су ручно додате у дневник биће обрисане, заједно са оценама и подацима о преписаним, искљученим, сакривеним и закључаним оценама. Остаће само ставке за оцењивање које су повезане са активностима на курсу.';
$string['report'] = 'Извештај';
$string['reportdefault'] = 'Подразумевани извештај ({$a})';
$string['reportplugins'] = 'Додаци за извештај';
$string['reportsettings'] = 'Подешавање извештаја';
$string['reprintheaders'] = 'Поновни испис заглавља';
$string['resetweights'] = 'Ресетуј пондере за {$a->itemname}';
$string['resetweightsshort'] = 'Ресетуј  тежину';
$string['respectingcurrentdata'] = 'остављајући тренутна подешавања неизмењена';
$string['rowpreviewnum'] = 'Број редова за преглед';
$string['rowpreviewnum_help'] = 'Подаци за увоз могу бити прегледани пре потврђивања увоза. Ово подешавање утврђује колико редова се приказује у прегледу.';
$string['savechanges'] = 'Сачувај промене';
$string['savepreferences'] = 'Сачувај параметре';
$string['scaleconfirmdelete'] = 'Да ли сте сигурни да желите да обришете скалу "{$a}"?';
$string['scaledpct'] = 'Скалирани %';
$string['seeallcoursegrades'] = 'Погледај све оцене курса';
$string['select'] = 'Изабери {$a}';
$string['selectalloroneuser'] = 'Изабери све или ниједног корисника';
$string['selectauser'] = 'Изабери корисника';
$string['selectdestination'] = 'Изабери одредиште за {$a}';
$string['separator'] = 'Граничник';
$string['separator_help'] = 'Одаберите гранични знак који користи CSV датотека. (Уобичајено је то зарез.)';
$string['sepcolon'] = 'Двотачка';
$string['sepcomma'] = 'Зарез';
$string['sepsemicolon'] = 'Тачка и зарез';
$string['septab'] = 'Табулатор';
$string['setcategories'] = 'Подеси категорије';
$string['setcategorieserror'] = 'Прво морате да подесите категорије за свој курс пре него што им одредите пондере.';
$string['setgradeletters'] = 'Подеси словне оцене';
$string['setpreferences'] = 'Подеси параметре';
$string['setting'] = 'Подешавање';
$string['settings'] = 'Подешавања';
$string['setweights'] = 'Подеси пондере';
$string['showactivityicons'] = 'Прикажи иконице активности';
$string['showactivityicons_help'] = 'Ако је ова опција омогућена, иконице активности ће бити приказане поред назива активности.';
$string['showallhidden'] = 'Прикажи скривене';
$string['showallstudents'] = 'Прикажи све полазнике';
$string['showanalysisicon'] = 'Прикажи иконицу за анализу оцена';
$string['showanalysisicon_desc'] = 'Да ли, стандардно, приказати иконицу за анализу оцена. Ако модул активност то подржава, иконица за анализу оцена је повезана са страницом са детаљнијим објашњењем оцене и како је она добијена.';
$string['showanalysisicon_help'] = 'Ако модул активност то подржава, иконица за анализу оцена је повезана са страницом са детаљнијим објашњењем оцене и како је она добијена.';
$string['showaverage'] = 'Прикажи просек';
$string['showaverage_help'] = 'Да ли приказати просек колоне? Имајте у виду да би учесници могли да процене оцене других ако се просек рачуна на основу мањег броја оцена. Због брзине извођења, просек је приближан уколико зависи од скривених ставки.';
$string['showaverages'] = 'Прикажи просечне вредности колона';
$string['showaverages_help'] = 'Ако је ова опција омогућена, извјештај оцењивача ће садржати додатни ред у којем ће бити приказан просек (средња вредност) за сваку категорију и сваку ставку која се оцењује.';
$string['showcalculations'] = 'Прикажи прорачуне';
$string['showcalculations_help'] = 'Ако је ова опција омогућена, када је уређивање укључено, за сваку ставку оцене и категорију  приказује се калкулатор, заједно са визуелним индикатором да је ставка оцене израчуната.';
$string['showcontributiontocoursetotal'] = 'Прикажи доприноси укупној оцени на курсу';
$string['showcontributiontocoursetotal_help'] = 'Да ли приказати колону са процентима који показују колико свака ставка оцене доприноси укупном проценту корисника на курсу (након што је примењено пондерисање).';
$string['showeyecons'] = 'Прикажи иконице прикажи/сакриј';
$string['showeyecons_help'] = 'Ако је ова опција омогућена, када је уређивање укључено, поред сваке оцене се појављује иконица прикажи/сакриј, чиме се контролише да ли ће полазник моћи да види своје оцене.';
$string['showfeedback'] = 'Прикажи повратне информације';
$string['showfeedback_help'] = 'Да ли приказати колону са повратним информацијама?';
$string['showgrade'] = 'Прикажи оцене';
$string['showgrade_help'] = 'Да ли приказати колону са оценама?';
$string['showgroups'] = 'Прикажи групе';
$string['showhiddenitems'] = 'Прикажи сакривене ставке';
$string['showhiddenitems_help'] = 'Да ли су сакривене ставке оцена сакривенe у потпуности или су називи тих ставки видљиви полазницима?

* Прикажи сакривено - називи сакривених ставки су приказани, али оцене полазника нису
* Сакривено до - ставке су потпуно сакривене до наведеног датума након чега су у потпуности видљиве.
* Не приказуј - сакривене ставке су у потпуности сакривене';
$string['showhiddenuntilonly'] = 'Сакривено до';
$string['showingaggregatesonly'] = 'Приказује само збирове';
$string['showingfullmode'] = 'Приказује пун прикз';
$string['showinggradesonly'] = 'Приказује само оцене';
$string['showlettergrade'] = 'Прикажи словне оцене';
$string['showlettergrade_help'] = 'Да ли приказати колону са словним оценама?';
$string['showlocks'] = 'Прикажи закључавања';
$string['showlocks_help'] = 'Ако је ова опција омогућена, када је уређивање укључено, поред сваке оцене се приказује иконица закључај/откључај којом се контролише да ли оцене могу аутоматски да се ажурирају од стране припадајуће активности.';
$string['shownohidden'] = 'Не приказуј';
$string['shownooutcomes'] = 'Сакриј исходе учења';
$string['shownumberofgrades'] = 'Прикажи број оцена у просецима';
$string['shownumberofgrades_help'] = 'Ако је омогућена ова опција, број оцена, коришћених приликом израчунавања просека (средње вредности), приказан је у загради поред сваког просека.';
$string['showonlyactiveenrol'] = 'Прикажи само активне уписе';
$string['showonlyactiveenrol_help'] = 'Ово подешавање одређује да ли ће у извештају из књиге оцена бити видљиви само уписани корисници који су активни. Ако је подешавање омогућено суспендовани корисници неће бити приказани у књизи оцена.';
$string['showpercentage'] = 'Прикажи проценат';
$string['showpercentage_help'] = 'Да ли приказати процентуалну вредност за сваку ставку оцене?';
$string['showquickfeedback'] = 'Прикажи брзе повратне информације';
$string['showquickfeedback_help'] = 'Ако је ова опција омогућена, када је уређивање укључено, поред сваке оцене приказује се поље, са испрекиданим ивицама, за унос повратних информација. што омогућава да се истовремено уређују повратне информације за већи број оцена. Када се кликне да на дугме за ажурирање, промене су сачуване и истакнуте.

Имајте у виду да је, приликом уређивања повратних информација у извештају оцењивача, постављена заставица (индикатор) измене, што значи да повратне информације не могу више да се мењају унутар припадајуће активности';
$string['showrange'] = 'Прикажи опсеге';
$string['showrange_help'] = 'Да ли приказати колону са опсегом?';
$string['showranges'] = 'Прикажи опсеге';
$string['showranges_help'] = 'Ако је ова опција омогућена, извештај оцењивача ће садржати додатни ред у којем ће бити приказан опсег за сваку категорију и ставку која се оцењује.';
$string['showrank'] = 'Прикажи ранг';
$string['showrank_help'] = 'Да ли приказати позицију полазника у односу на остале учеснике за сваку ставку оцене?';
$string['showuserimage'] = 'Прикажи слике из корисничких профила';
$string['showuserimage_help'] = 'Да ли приказати слику корисника поред његовог имена у извешатају оцењивача?';
$string['showverbose'] = 'Прикажи {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Прикажи пондере';
$string['showweight_help'] = 'Да ли приказати колону са пондерима оцена?';
$string['simpleview'] = 'Појединачни приказ';
$string['singleview'] = 'Појединачни приказ за {$a}';
$string['sitewide'] = 'На целом сајту';
$string['sort'] = 'сортирај';
$string['sortasc'] = 'Сортирај у растућем низу';
$string['sortbyfirstname'] = 'Сортирај по имену';
$string['sortbylastname'] = 'Сортирај по презимену';
$string['sortdesc'] = 'Сортирај у опадајућем низу';
$string['standarddeviation'] = 'Стандардна девијација';
$string['stats'] = 'Статистика';
$string['statslink'] = 'Статистика';
$string['student'] = 'Полазник';
$string['studentsperpage'] = 'Број полазника по страни';
$string['studentsperpage_help'] = 'Ово подешавање одређује број полазника који ће бити приказан на свакој страници извештаја оцењивача';
$string['studentsperpagereduced'] = 'Максималан број полазника по страници је смањен са {$a->originalstudentsperpage} на {$a->studentsperpage}. Размислите о повећању вредности за PHP подешавање max_input_vars из {$a->maxinputvars}.';
$string['subcategory'] = 'Нормална категорија';
$string['submissions'] = 'Предато';
$string['submittedon'] = 'Предато: {$a}';
$string['sumofgradesupgradedgrades'] = 'Напомена: Агрегациони метод "Сума оцена" је измењена у "Природни" као део надоградње сајта. Како је "Сума оцена" претходно коришћена на овом курсу препоручује се да прегледате ове измене у књизи оцена.';
$string['switchtofullview'] = 'Пређи на потпун приказ';
$string['switchtosimpleview'] = 'Пређи на једноставан приказ';
$string['tabs'] = 'Картице';
$string['topcategory'] = 'Надкатегорија';
$string['total'] = 'Укупно';
$string['totalweight100'] = 'Укупни пондер је једнак 100';
$string['totalweightnot100'] = 'Укупни пондер није једнак 100';
$string['turnfeedbackoff'] = 'Искључи повратне информације';
$string['turnfeedbackon'] = 'Укључи повратне информације';
$string['typenone'] = 'Ниједан';
$string['typescale'] = 'Скала';
$string['typescale_help'] = 'Ово подешавање одређује скалу која се користи када се оцењивање врши помоћу скала. Скала за оцењивање активности се поставља на страници за подешавање те активности.';
$string['typetext'] = 'Текст';
$string['typevalue'] = 'Вредност';
$string['uncategorised'] = 'Некатегорисано';
$string['unchangedgrade'] = 'Оцена је непромењена';
$string['unenrolledusersinimport'] = 'Овај увоз је укључио следеће оцене за кориснике који тренутно нису уписани на овај курсу: {$a}';
$string['unlimitedgrades'] = 'Неограничене оцене';
$string['unlimitedgrades_help'] = 'Стандардно, оцене су ограничене максималном и минималном вредношћу ставке која се оцењује. Ако се омогући ово подешавања укида се то ограничење и дозвољава се да оцене веће од 100% буду директно унете у књигу оцена.';
$string['unlock'] = 'Откључај';
$string['unlockverbose'] = 'Откључај {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Некоришћено';
$string['updatedgradesonly'] = 'Извези само нове или ажуриране оцене';
$string['upgradedgradeshidemessage'] = 'Одбаци обавештење';
$string['upgradedminmaxrevertmessage'] = 'Поништи измене';
$string['uploadgrades'] = 'Пошаљи оцене';
$string['useadvanced'] = 'Користи напредне опције';
$string['usedcourses'] = 'Коришћени курсеви';
$string['usedgradeitem'] = 'Коришћена ставка оцене';
$string['usenooutcome'] = 'Не користи исходе учења';
$string['usenoscale'] = 'Без скала';
$string['usepercent'] = 'Користи проценте';
$string['user'] = 'Корисник';
$string['userenrolmentsuspended'] = 'Упис корисника је суспендован';
$string['userfields_show'] = 'Прикажи корисничка поља';
$string['userfields_show_help'] = 'Прикажи додатна корисничка поља као шти су е-адреса у ивештају оцењивача. Посебна поља која се приказују су под контролом подешавања сајта showuseridentity';
$string['usergrade'] = 'Корисник {$a->fullname} ({$a->useridnumber}) за ставку {$a->gradeidnumber}';
$string['userid'] = 'Идентификатор корисника';
$string['useridnumberwarning'] = 'Корисници без ID броја искључени су из извоза пошто не могу да буду увезени.';
$string['usermappingerror'] = 'Грешка приликом мапирања корисника: није могуће пронаћи корисника са пољем {$a->field} које има вредност "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Корисник није члан текуће групе.';
$string['usermappingerrormultipleusersfound'] = 'Грешка приликом мапирања корисника: пронађено је више корисника са пољем  {$a->field} које има вредност "{$a->value}". Молимо вас, да за мапирање искористите поље које је више јединствено.';
$string['usermappingerrorusernotfound'] = 'Грешка приликом мапирања корисника: Није могуће пронаћи корисника,';
$string['userpreferences'] = 'Корисничка подешавања';
$string['useweighted'] = 'Користи пондерисане вредности';
$string['verbosescales'] = 'Детаљне скале';
$string['verbosescales_help'] = 'Вербална скала користи речи уместо бројева. Поставите на "Да" ако желите да се увезу и нумеричке и вербалне скале. Поставите на "Не" за увоз само нумеричких скала.';
$string['viewbygroup'] = 'Група';
$string['viewgrades'] = 'Погледај оцене';
$string['weight'] = 'Пондер';
$string['weightcourse'] = 'Користи пондерисане оцене за курс';
$string['weightedascending'] = 'Сортирај према пондерисаном проценту - растући низ';
$string['weighteddescending'] = 'Сортирај према пондерисаном проценту - опадајући низ';
$string['weightedpct'] = 'пондерисани %';
$string['weightedpctcontribution'] = 'допринос пондерисаних % у укупној оцени';
$string['weight_help'] = 'Вредност која се користи за одређивање релативне вредности више ставки оцене унутар категорије или курса.';
$string['weightofa'] = 'Пондер од {$a}';
$string['weightorextracredit'] = 'Пондер или додатни бодови';
$string['weightoverride'] = 'подешавање пондера';
$string['weightoverride_help'] = 'Искључите ово да бисте поново поставили тежину ставке за оцењивање на њену аутоматски израчунату вредност. Укључивање ове опције би спречило аутоматско прилагођавање тежине.';
$string['weights'] = 'Пондери';
$string['weightsadjusted'] = 'Ваши пондери су подешени на укупну оцену 100';
$string['weightsedit'] = 'Уреди пондер и додатне бодове';
$string['weightuc'] = 'Израчунати пондер';
$string['writinggradebookinfo'] = 'Записивање подешавања књиге оцена';
$string['xml'] = 'XML';
$string['yes'] = 'Да';
$string['yourgrade'] = 'Ваша оцена';
