<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'calendar', language 'ja', branch 'MOODLE_36_STABLE'
 *
 * @package   calendar
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityevent'] = '活動イベント';
$string['addevent'] = 'イベントを追加する';
$string['advancedoptions'] = '高度なオプション';
$string['allday'] = '終日';
$string['annually'] = '毎年';
$string['calendar'] = 'カレンダー';
$string['calendarheading'] = '{$a} カレンダー';
$string['calendarpreferences'] = 'カレンダープリファレンス';
$string['calendartypes'] = 'カレンダータイプ';
$string['calendarurl'] = 'カレンダーURL: {$a}';
$string['categoryevent'] = 'カテゴリイベント';
$string['categoryevents'] = 'カテゴリイベント';
$string['clickhide'] = '非表示';
$string['clickshow'] = '表示';
$string['colactions'] = '操作';
$string['colcalendar'] = 'カレンダー';
$string['collastupdated'] = '最終更新日時';
$string['colpoll'] = '更新間隔';
$string['commontasks'] = 'オプション';
$string['confirmeventdelete'] = '本当にこのイベント「 {$a} 」を削除してもよろしいですか?';
$string['confirmeventseriesdelete'] = '「 {$a->name} 」イベントはシリーズの一部です。このイベントのみ削除しますか、それともシリーズ内 {$a->count} イベントすべてを削除しますか?';
$string['course'] = 'コース';
$string['courseevent'] = 'コースイベント';
$string['courseevents'] = 'コースイベント';
$string['courses'] = 'コース';
$string['customexport'] = 'カスタム範囲 ({$a->timestart} - {$a->timeend})';
$string['daily'] = '毎日';
$string['daynext'] = '翌日';
$string['dayprev'] = '前日';
$string['dayviewfor'] = '日表示:';
$string['dayviewtitle'] = '日表示: {$a}';
$string['daywithnoevents'] = 'この日にはイベントがありません。';
$string['default'] = 'デフォルト';
$string['deleteallevents'] = 'すべてのイベントを削除する';
$string['deleteevent'] = 'イベントを削除する';
$string['deleteevents'] = 'イベントを削除する';
$string['deleteoneevent'] = 'このイベントを削除する';
$string['detailedmonthviewfor'] = '詳細月表示:';
$string['detailedmonthviewtitle'] = '詳細月表示: {$a}';
$string['durationminutes'] = '期間 (分)';
$string['durationnone'] = '期間なし';
$string['durationuntil'] = '終了日時:';
$string['editevent'] = 'イベントの編集';
$string['erroraddingevent'] = 'イベント追加失敗';
$string['errorbadsubscription'] = 'カレンダー購読が見つかりませんでした。';
$string['errorbeforecoursestart'] = 'コースの開始日以前にイベントを登録できません';
$string['errorcannotimport'] = '現在、あなたはカレンダー購読を設定することはできません。';
$string['errorhasuntilandcount'] = '「UNTIL」または「COUNT」は反復ルールに出現させることができますが「UNTIL」および「COUNT」は同じ反復ルールに存在させることはできません。';
$string['errorinvalidbydayprefix'] = 'BYDAYルールの前の整数値は「MONTHLY」または「YEARLY」ルールにのみ渡すことができます。';
$string['errorinvalidbydaysuffix'] = 'BYDAYルールの一部の有効な週の曜日の値は「MO」「TU」「WE」「TH」「FR」「SA」「SU」です。';
$string['errorinvalidbyhour'] = 'BYHOURルールの有効な値は0～23です。';
$string['errorinvalidbyminute'] = 'BYMINUTEルールの有効な値は0～59です。';
$string['errorinvalidbymonth'] = 'BYMONTHルールの有効な値は1～12です。';
$string['errorinvalidbymonthday'] = 'BYMONTHDAYルールの有効な値は1～31または-31～-1です。';
$string['errorinvalidbysecond'] = 'BYSECONDルールの有効な値は0～59です。';
$string['errorinvalidbysetpos'] = 'BYSETPOSルールの有効な値は1～366または-366～-1です。';
$string['errorinvalidbyweekno'] = 'BYWEEKNOルールの有効な値は1～53または-53～-1です。';
$string['errorinvalidbyyearday'] = 'BYYEARDAYルールの有効な値は1～366または-366～-1です。';
$string['errorinvaliddate'] = '日付が正しくありません';
$string['errorinvalidicalurl'] = 'iCal URLが有効ではありません。';
$string['errorinvalidinterval'] = 'INTERVALルールの値は正の整数にする必要があります。';
$string['errorinvalidminutes'] = '期間 (分) を1から999の間で指定してください。';
$string['errorinvalidrepeats'] = 'イベント数を1から99の間で指定してください。';
$string['errormustbeusedwithotherbyrule'] = 'BYSETPOSルールは別のBYxxxルールの一部としてのみ使用する必要があります。';
$string['errornodescription'] = '説明を入力してください';
$string['errornoeventname'] = '名称を入力してください';
$string['errornonyearlyfreqwithbyweekno'] = 'BYWEEKNOルールはYEARLYルールに対してのみ有効です。';
$string['errorrequiredurlorfile'] = 'カレンダーのインポートに必要なURLまたはファイルです。';
$string['errorrrule'] = '通過した繰り返しルールが正しくないようです。';
$string['errorrruleday'] = '繰り返しルールに無効な日付パラメータがあります。';
$string['errorrrulefreq'] = '繰り返しルールに無効な頻度パラメータがあります。';
$string['eventcalendareventcreated'] = 'カレンダーイベントが作成されました。';
$string['eventcalendareventdeleted'] = 'カレンダーイベントが削除されました。';
$string['eventcalendareventupdated'] = 'カレンダーイベントが更新されました。';
$string['eventdate'] = '日付';
$string['eventdescription'] = '説明';
$string['eventduration'] = '期間';
$string['eventendtime'] = '終了日時';
$string['eventendtimewrapped'] = '{$a} (終了時間)';
$string['eventinstanttime'] = '時間';
$string['eventkind'] = 'イベントタイプ';
$string['eventname'] = 'イベントタイトル';
$string['eventnameandcategory'] = '{$a->category}: {$a->name}';
$string['eventnameandcourse'] = '{$a->course}: {$a->name}';
$string['eventnone'] = 'イベントなし';
$string['eventrepeat'] = '繰り返し';
$string['events'] = 'イベントです。';
$string['eventsall'] = 'すべてのイベント';
$string['eventsdeleted'] = '削除済みイベント';
$string['eventsfor'] = '{$a} イベント';
$string['eventsimported'] = 'インポート済みイベント: {$a}';
$string['eventskey'] = 'イベントキー';
$string['eventsource'] = 'イベントソース';
$string['eventspersonal'] = 'マイパーソナルイベント';
$string['eventsrelatedtocategories'] = 'カテゴリ関連イベント';
$string['eventsrelatedtocourses'] = 'コースに関連したイベント';
$string['eventsrelatedtogroups'] = 'グループ関連イベント';
$string['eventsskipped'] = 'スキップされたイベント : {$a}';
$string['eventstarttime'] = '開始日時';
$string['eventstoexport'] = 'エクスポートするイベント';
$string['eventsubscriptioncreated'] = 'カレンダー購読が作成されました。';
$string['eventsubscriptiondeleted'] = 'カレンダー購読が削除されました。';
$string['eventsubscriptioneditwarning'] = 'このカレンダーイベントは購読の一部です。購読が削除された場合、あなたのこのイベントに対する変更を喪失します。';
$string['eventsubscriptionupdated'] = 'カレンダー購読が更新されました。';
$string['eventsupdated'] = '更新済みイベント: {$a}';
$string['eventtime'] = '時間';
$string['eventtype'] = 'イベントタイプ';
$string['eventtypecategory'] = 'カテゴリ';
$string['eventtypecourse'] = 'コース';
$string['eventtypeglobal'] = 'グローバル';
$string['eventtypegroup'] = 'グループ';
$string['eventtypemodule'] = 'モジュール';
$string['eventtypesite'] = 'グローバル';
$string['eventtypeuser'] = 'ユーザ';
$string['eventview'] = 'イベント詳細';
$string['expired'] = '期間終了';
$string['explain_site_timeformat'] = 'あなたは12時間表示または24時間表示をサイトの時間表示方法として選択することができます。「デフォルト」を選択した場合、使用言語に合わせて、フォーマットが自動的に選択されます。この設定はユーザプリファレンスによりオーバーライドすることができます。';
$string['export'] = 'エクスポート';
$string['exportbutton'] = 'エクスポート';
$string['exportcalendar'] = 'カレンダーをエクスポートする';
$string['exporthelp'] = 'どのようにして私はこのカレンダーをカレンダーアプリケーション  (Google/Outlook/その他) から購読できますか?';
$string['forcecalendartype'] = 'カレンダーの強制';
$string['fri'] = '金';
$string['friday'] = '金曜日';
$string['generateurlbutton'] = 'カレンダーのURLを取得する';
$string['global'] = 'グローバル';
$string['globalevent'] = '全体のイベント';
$string['globalevents'] = '全体のイベント';
$string['gotoactivity'] = '活動に移動する';
$string['gotocalendar'] = 'カレンダーへ移動する';
$string['group'] = 'グループ';
$string['groupevent'] = 'グループイベント';
$string['groupevents'] = 'グループイベント';
$string['hidecourseevents'] = 'コースイベントを隠す';
$string['hideeventtype'] = '{$a} イベントを隠す';
$string['hideglobalevents'] = 'グローバルイベントを隠す';
$string['hidegroupsevents'] = 'グループイベントを隠す';
$string['hideuserevents'] = 'ユーザイベントを隠す';
$string['hourly'] = '毎時';
$string['ical'] = 'iCal';
$string['importcalendar'] = 'カレンダーをインポートする';
$string['importcalendarfrom'] = 'インポート先';
$string['importcalendarheading'] = 'カレンダーをインポートする ...';
$string['importfromfile'] = 'カレンダーファイル (.ics)';
$string['importfrominstructions'] = 'リモートカレンダーのURLを提供するか、ファイルをアップロードしてください。';
$string['importfromurl'] = 'カレンダーURL';
$string['invalideventtype'] = 'あなたが選択したイベントタイプは有効ではありません。';
$string['invalidtimedurationminutes'] = 'あなたが入力した期間は有効ではありません。ゼロよりも大きな期間を分で入力するか空白にしてください。';
$string['invalidtimedurationuntil'] = 'あなたはイベント開始日時より前の終了日時を選択しました。処理を続行する前に訂正してください。';
$string['iwanttoexport'] = 'エクスポート';
$string['less'] = '減らす';
$string['managesubscriptions'] = '購読を管理する';
$string['manyevents'] = '{$a} イベント';
$string['mon'] = '月';
$string['monday'] = '月曜日';
$string['monthly'] = '毎月';
$string['monthlyview'] = '月表示';
$string['monthnext'] = '来月';
$string['monthprev'] = '前月';
$string['monththis'] = '当月';
$string['more'] = '増やす';
$string['namewithsource'] = '{$a->name} ({$a->source})';
$string['never'] = 'なし';
$string['newevent'] = '新しいイベント';
$string['nocalendarsubscriptions'] = 'あなたにカレンダー購読はありません。';
$string['notitle'] = 'タイトルなし';
$string['noupcomingevents'] = '直近のイベントはありません。';
$string['oneevent'] = '1 イベント';
$string['pollinterval'] = '更新間隔';
$string['pollinterval_help'] = 'あなたが新しいイベントに関して、カレンダーを更新したい間隔です。';
$string['preferences'] = 'プリファレンス';
$string['preferences_available'] = 'あなたのパーソナルプリファレンス';
$string['preferredcalendar'] = '推奨カレンダー';
$string['pref_lookahead'] = '直近イベントの日数範囲';
$string['pref_lookahead_help'] = 'この設定では直近イベントとしてイベントを表示するための将来的な日数の範囲を指定します。この日数を超えるイベントは直近イベントとして表示されることはありません。この日数範囲内のすべてのイベントが表示されるという<strong>保証はありません</strong>。多くの直近イベント (「直近イベントの最大表示件数」プリファレンス以上) が登録されている場合、最も時間の離れたイベントは表示されません。';
$string['pref_maxevents'] = '直近イベントの最大表示件数';
$string['pref_maxevents_help'] = 'この設定では表示できる直近イベントの最大数を設定します。あなたがここで大きな値を設定した場合、直近イベントの表示により多くの画面スペースが使われることになります。';
$string['pref_persistflt'] = 'フィルタ設定を記憶する';
$string['pref_persistflt_help'] = 'この設定を有効にした場合、Moodleはあなたの直近のイベントフィルタ設定を記憶して、ログインするたびに自動的にその内容をリストアします。';
$string['pref_startwday'] = '週の初め';
$string['pref_startwday_help'] = 'あなたがここで選択した曜日を週の初めとして、カレンダー週が表示されます。';
$string['pref_timeformat'] = '時間フォーマット';
$string['pref_timeformat_help'] = 'あなたは時間表示に関して、12時間または24時間フォーマットを選択することができます。「デフォルト」を選択した場合、あなたのサイトの言語設定に基づき自動的に時間フォーマットが選択されます。';
$string['privacy:metadata:calendar:event'] = 'カレンダーコンポーネントはコアサブシステム内のユーザカレンダーイベント詳細を保存することができます。';
$string['privacy:metadata:calendar:event:description'] = 'カレンダーイベントの説明です。';
$string['privacy:metadata:calendar:event:eventtype'] = 'カレンダーイベントのイベントタイプです。';
$string['privacy:metadata:calendar:event:name'] = 'カレンダーイベントの名称です。';
$string['privacy:metadata:calendar:event_subscriptions'] = 'カレンダーコンポーネントはコアサブシステム内のユーザカレンダー購読詳細を保存することができます。';
$string['privacy:metadata:calendar:event_subscriptions:eventtype'] = 'カレンダー購読のイベントタイプです。';
$string['privacy:metadata:calendar:event_subscriptions:name'] = 'カレンダー購読の名称です。';
$string['privacy:metadata:calendar:event_subscriptions:url'] = 'カレンダー購読のURLです。';
$string['privacy:metadata:calendar:event:timeduration'] = 'カレンダーイベントの継続時間です。';
$string['privacy:metadata:calendar:event:timestart'] = 'カレンダーイベントの開始日時です。';
$string['privacy:metadata:calendar:preferences:calendar_savedflt'] = 'ユーザプリファレンスに表示される設定済みカレンダーイベントのタイプです。';
$string['quickdownloadcalendar'] = 'クイックダウンロード / カレンダーを購読する';
$string['recentupcoming'] = '最近および次の60日間';
$string['repeatedevents'] = '繰り返しイベント';
$string['repeateditall'] = '変更内容を他の {$a} 件の繰り返しイベントに適用する';
$string['repeateditthis'] = '変更内容をこのイベントにのみ適用する。';
$string['repeatevent'] = 'このイベントを繰り返す';
$string['repeatnone'] = '繰り返しなし';
$string['repeatweeksl'] = '毎週、作成イベント数';
$string['repeatweeksr'] = '件';
$string['sat'] = '土';
$string['saturday'] = '土曜日';
$string['showcourseevents'] = 'コースイベントを表示する';
$string['showeventtype'] = '{$a} イベントを表示する';
$string['showglobalevents'] = 'グローバルイベントを表示する';
$string['showgroupsevents'] = 'グループイベントを表示する';
$string['shown'] = '表示中';
$string['showuserevents'] = 'ユーザイベントを表示する';
$string['siteevents'] = 'サイトイベント';
$string['spanningevents'] = '進行中イベント';
$string['subscriptionname'] = 'カレンダー名';
$string['subscriptionremoved'] = 'カレンダー購読「 {$a} 」が削除されました。';
$string['subscriptions'] = '購読';
$string['subscriptionsource'] = 'イベントソース: {$a}';
$string['subscriptionupdated'] = 'カレンダー購読「 {$a} 」が更新されました。';
$string['subsource'] = 'イベントソース: {$a->name}';
$string['sun'] = '日';
$string['sunday'] = '日曜日';
$string['thu'] = '木';
$string['thursday'] = '木曜日';
$string['timeformat_12'] = '12時間 (午前/午後)';
$string['timeformat_24'] = '24時間';
$string['timeperiod'] = '期間';
$string['today'] = '本日';
$string['todayplustitle'] = '本日 {$a}';
$string['tomorrow'] = '明日';
$string['tt_deleteevent'] = 'イベントを削除する';
$string['tt_editevent'] = 'イベントを編集する';
$string['tt_hidecourse'] = 'コースイベントは表示中です(クリックで非表示)';
$string['tt_hideglobal'] = '全体のイベントは表示中です(クリックで非表示)';
$string['tt_hidegroups'] = 'グループイベントは表示中です(クリックで非表示)';
$string['tt_hideuser'] = 'ユーザイベントは表示中です(クリックで非表示)';
$string['tt_showcourse'] = 'コースイベントは非表示中です(クリックで表示)';
$string['tt_showglobal'] = '全体のイベントは非表示中です(クリックで表示)';
$string['tt_showgroups'] = 'グループイベントは非表示中です(クリックで表示)';
$string['tt_showuser'] = 'ユーザイベントは非表示中です(クリックで表示)';
$string['tue'] = '火';
$string['tuesday'] = '火曜日';
$string['typecategory'] = 'カテゴリイベント';
$string['typeclose'] = '終了イベント';
$string['typecourse'] = 'コースイベント';
$string['typedue'] = '期限到来イベント';
$string['typegradingdue'] = '評定期限イベント';
$string['typegroup'] = 'グループイベント';
$string['typeopen'] = '開催中イベント';
$string['typesite'] = 'サイトイベント';
$string['typeuser'] = 'ユーザイベント';
$string['upcomingevents'] = '直近イベント';
$string['upcomingeventsfor'] = '直近イベント:';
$string['urlforical'] = 'iCalendarエクスポートおよびカレンダー購読のためのURL';
$string['user'] = 'ユーザ';
$string['userevent'] = 'ユーザイベント';
$string['userevents'] = 'ユーザイベント';
$string['wed'] = '水';
$string['wednesday'] = '水曜日';
$string['weekly'] = '毎週';
$string['weeknext'] = '来週';
$string['weekthis'] = '今週';
$string['when'] = 'いつ';
$string['yesterday'] = '昨日';
$string['youcandeleteallrepeats'] = 'このイベントは繰り返しイベントの一部です。あなたはこのイベントのみ削除することができます。また、一度に {$a} 件すべてのイベントを削除することもできます。';
