<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'cs', branch 'MOODLE_36_STABLE'
 *
 * @package   questionnaire
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akce';
$string['activityoverview'] = 'Máte jeden nebo více povinných dotazníků (klikněte zde pro zobrazení).';
$string['additionalinfo'] = 'Další informace';
$string['additionalinfo_help'] = 'Další informace slouží k podrobnější specifikaci dotazování nebo přidání jakýchkoli dalších informací, které jsou pak zobrazeny pod Podtitulem.';
$string['addnewquestion'] = 'Přidání otázky typu {$a}';
$string['addquestions'] = 'Přidat otázky';
$string['addselqtype'] = 'Přidat vybraný typ otázky';
$string['alignment'] = 'Orientace tlačítek';
$string['alignment_help'] = 'Vyberte orientaci tlačítek: vodorovně (výchozí) nebo svisle';
$string['all'] = 'Vše';
$string['alreadyfilled'] = 'Tento dotazník jste již vyplnili. Děkujeme.';
$string['andaveragevalues'] = 'a průměrné hodnoty';
$string['anonymous'] = 'Anonymní';
$string['answerquestions'] = 'Odpovědět na otázky...';
$string['attempted'] = 'Dotazník byl odevzdán.';
$string['attemptstillinprogress'] = 'Zpracovává se. Uloženo na:';
$string['autonumbering'] = 'Automatické číslování';
$string['autonumbering_help'] = 'Umožňuje nastavit, zda mají být otázky či stránky automaticky číslovány. Použití automatického číslování by nemuselo být vhodné například u otázek s větvením.';
$string['autonumberno'] = 'Nečíslovat otázky ani stránky';
$string['autonumberpages'] = 'Automaticky číslovat stránky';
$string['autonumberpagesandquestions'] = 'Automaticky číslovat stránky i otázky';
$string['autonumberquestions'] = 'Automaticky číslovat otázky';
$string['average'] = 'Průměr';
$string['averageposition'] = 'Průměrné umístění';
$string['averagerank'] = 'Průměrný rozsah';
$string['bodytext'] = 'Textové pole';
$string['boxesnbexact'] = 'přesně {$a} polí.';
$string['boxesnbmax'] = 'maximálně z {$a} polí.';
$string['boxesnbmin'] = 'minimálně z {$a} polí.';
$string['boxesnbreq'] = 'Tuto otázku si musíte zaškrtnout';
$string['by'] = 'od';
$string['cannotviewpublicresponses'] = 'Ve veřejném dotazování nelze zobrazit odpovědi.';
$string['chart:bipolar'] = 'Bipolární sloupce';
$string['chart:hbar'] = 'Horizontální sloupce';
$string['chart:radar'] = 'Paprskový graf';
$string['chart:rose'] = 'Růžicový graf';
$string['chart:type'] = 'Typ grafu';
$string['chart:type_help'] = 'Vyberte typ grafu, který chcete použít';
$string['chart:vprogress'] = 'Ukazatel průběhu';
$string['checkallradiobuttons'] = 'Všechny přepínače musí být zodpovězeny. Zkontrolujte prosím <strong>{$a}</strong> přepínače.';
$string['checkboxes'] = 'Zaškrtávací pole';
$string['checkboxes_help'] = 'Vepište pod sebe možnosti pro účastníka, který bude následně vybírat jednu nebo více z těchto nabízených možností.';
$string['checkbreaksadded'] = 'Nová stránka byla přidána na pozici:';
$string['checkbreaksok'] = 'Všechny požadované Nové stránky již existují!';
$string['checkbreaksremoved'] = 'Odstraněno {$a} přebývajících Nových stránek';
$string['checknotstarted'] = 'Vybrat nezahájené';
$string['checkstarted'] = 'Vybrat zahájené';
$string['clicktoswitch'] = '(klikněte pro přepnutí)';
$string['closed'] = 'Dotazování bylo ukončeno {$a}. Děkuji.';
$string['closedate'] = 'Dostupné do';
$string['closedate_help'] = 'Po zaškrtnutí políčka Dostupné do je možno nastavit datum a čas uzavření daného dotazování. Po tomto datu není dotazování uživatelům dostupné. Pokud políčko není zaškrtnuto, je dotazování dostupné kdykoliv.';
$string['closeson'] = 'Dotazování bude uzavřeno: {$a}';
$string['completionsubmit'] = 'Pro splnění musí student tento dotazník odevzdat';
$string['confalts'] = '- nebo - <br />Stránka potvrzení';
$string['configmaxsections'] = 'Maximum sekcí dotazníku';
$string['configusergraph'] = 'Zobrazit grafy pro Dotazník "Test osobnosti"';
$string['configusergraphlong'] = 'Pro zobrazení grafu dotazníku "Test osobnosti" použijte knihovnu <a href="http://www.rgraph.net/">Rgraph</a> .';
$string['confirmdelallresp'] = 'Jste si jisti, že chcete smazat VŠECHNY odpovědi v tomto dotazníku?';
$string['confirmdelchildren'] = 'Odstraníte-li tuto otázku, budou odstraněny i její dceřiné otázky:';
$string['confirmdelgroupresp'] = 'Jste si jisti, že chcete odstranit VŠECHNY odpovědi {$a}?';
$string['confirmdelquestion'] = 'Jste si jisti, že chcete odstranit otázku na pozici {$a}?';
$string['confirmdelquestionresps'] = 'Tímto odstraníte také {$a} odpovědí na tuto otázku, které již byly odeslány.';
$string['confirmdelresp'] = 'Jste si jisti, že chcete smazat odpovědi &nbsp;{$a}&nbsp;?';
$string['confpage'] = 'Text hlavičky';
$string['confpagedesc'] = 'Hlavička (tučně) a tělo text pro  Stránku " potvrzení "  se zobrazí po vyplnění dotazníku uživatelem. (URL, pokud je uvedeno, má přednost před textem.)';
$string['confpage_help'] = 'Hlavička (tučně) a tělo text pro  Stránku " potvrzení "  se zobrazí po vyplnění dotazníku uživatelem. (URL, pokud je uvedeno, má přednost před textem.)

Pokud toto pole necháte prázdné, bude zobrazena výchozí zpráva po vyplnění Dotazování (Děkujeme za vyplnění).';
$string['contentoptions'] = 'Volby obsahu';
$string['couldnotcreatenewsurvey'] = 'Nelze vytvořit nový průzkum!';
$string['couldnotdelresp'] = 'Odpověď nelze zrušit';
$string['createcontent'] = 'Definování nového obsahu';
$string['createcontent_help'] = 'Vyberte jeden z přepínačů. Výchozím je "Vytvořit nový".';
$string['createnew'] = 'Vytvořit nový';
$string['crontask'] = 'Vyčištění dotazníku';
$string['date'] = 'Datum';
$string['dateformatting'] = 'Použijte formát den/měsíc/rok, např. pro 14. 3. 1945:&nbsp; <strong>14/3/1945</strong>';
$string['date_help'] = 'Použijte tento typ otázky požadujete-li odpověď ve formě data.';
$string['deleteallresponses'] = 'Zrušit všechny odpovědi';
$string['deletecurrentquestion'] = 'Zrušit otázku {$a}';
$string['deletedallgroupresp'] = 'Zrušeny všechny odpovědi ve skupině {$a}';
$string['deletedallresp'] = 'Odpovědi dotazníku odstraněny';
$string['deletedisabled'] = 'Tuto položku není možné odstranit';
$string['deletedresp'] = 'Zrušená odpověď';
$string['deleteresp'] = 'Zrušit tuto odpověď';
$string['deletingresp'] = 'Rušení odpovědi';
$string['dependquestion'] = 'Mateřská otázka';
$string['dependquestion_help'] = 'Můžete zvolit mateřskou otázku a k ní možnou odpověď, po jejímž zvolení bude otevřena dceřiná otázka.';
$string['displaymethod'] = 'Pro otázku není definován způsob zobrazení.';
$string['download'] = 'Stáhnout';
$string['downloadtextformat'] = 'Stáhnout v textovém formátu';
$string['downloadtextformat_help'] = 'Tato funkce umožňuje stáhnout všechny odpovědi z dotazníku ve formě textového souboru (CSV). Tento soubor lze poté imporotvat do pokročilých statistických nástrojů (např. MS Excel či Open Office Calc) pro další zpracování dat a podrobnější analýzu.';
$string['dropdown'] = 'Rozbalovací nabídka';
$string['dropdown_help'] = 'Otázku typu Rozbalovací nabídka může být vhodnější použít namísto otázky typu Přepínač tehdy, je-li seznam možných odpovědí dlouhý. Pomocí Rozbalovací nabídky je takto možné ušetřit místo na stránce.';
$string['edit'] = 'Upravit';
$string['editingquestionnaire'] = 'Upravit nastavení Dotazování';
$string['editquestion'] = 'Upravení {$a} otázky';
$string['email'] = 'Email';
$string['errnewname'] = 'Je nám líto, název je již používán. Vyberte nový název.';
$string['erroropening'] = 'Chyba při otevírání dotazníku.';
$string['errortable'] = 'Systémová chyba - poškozená tabulka .';
$string['essaybox'] = 'Dlouhé textové pole';
$string['essaybox_help'] = 'Typ otázky Dlouhé textové pole nabízí pro vepsání odpovědi textové pole, jehož velikost může učitel nastavit podle svých potřeb nebo jej zanechat ve standardní velikosti. K nastavení velikosti textového pole slouží možnosti "Počet sloupců textového pole" a "Počet řádků textového pole".';
$string['event_all_responses_deleted'] = 'Všechny odpovědi odstraněny';
$string['event_all_responses_saved_as_text'] = 'Všechny odpovědi uloženy jako text';
$string['event_all_responses_viewed'] = 'Zobrazen seznam všech odpovědí';
$string['event_individual_responses_viewed'] = 'Zobrazen seznam jednotlivých odpovědí';
$string['event_non_respondents_viewed'] = 'Zobrazení účastníků, kteří neodpověděli';
$string['event_previewed'] = 'Dotazník zobrazen';
$string['event_question_created'] = 'Otázka vytvořena';
$string['event_question_deleted'] = 'Otázka odstraněna';
$string['event_response_deleted'] = 'Odstraněna jedna odpověď';
$string['event_resumed'] = 'Pokus obnoven';
$string['event_saved'] = 'Odpovědi uloženy';
$string['event_submitted'] = 'Odpovědi odeslány';
$string['feedback'] = 'Komentář';
$string['feedbackaddmorefeedbacks'] = 'Přidat {no} pole se zpětnou vazbou.';
$string['feedbackbysection'] = 'Sekce komentáře';
$string['feedbackeditingglobal'] = 'Upravit celkovou zpětnou vazbu Dotazování';
$string['feedbackeditingmessages'] = 'Upravit sdělení zpětné vazby Dotazování';
$string['feedbackeditingsections'] = 'Upravit jednotlivé části zpětné vazby v Dotazování';
$string['feedbackeditmessages'] = 'Uložit nastavení částí a upravit sdělení zpětné vazby';
$string['feedbackeditsections'] = 'Uložit nastavení a upravit jednotlivé části zpětné vazby';
$string['feedbackerrorboundaryformat'] = 'Hranice skóre této zpětné vazby musí být buď procentní nebo číselná. Hodnota zadaná v hranici {$a} není rozpoznána.';
$string['feedbackerrorboundaryoutofrange'] = 'Hranice skóre zpětné vazby musí být mezi 0% a 100%. Hodnota zadaná v hranici {$a} je mimo rozsah.';
$string['feedbackerrorjunkinboundary'] = 'Musíte vyplnit rozbalovací pole ve zpětné vazbě beze mezery.';
$string['feedbackerrorjunkinfeedback'] = 'Musíte vyplnit pole ve zpětné vazbě beze mezery.';
$string['feedbackerrororder'] = 'Hranice skóre zpětné vazby musí být v pořadí, nejvyšší jako první. Hodnota zadaná v hranici {$a} je mimo posloupnost.';
$string['feedbackglobal'] = 'Celková zpětná vazba';
$string['feedbackglobalheading'] = 'Záhlaví celkové zpětné vazby';
$string['feedbackglobalmessages'] = 'Sdělení celkové zpětné vazby';
$string['feedbackhdr'] = 'Zpětné vazby';
$string['feedbackheading'] = 'Záhlaví zpětné vazby';
$string['feedbackheading_help'] = 'V poli Nadpis můžete použít dvě proměnné: $scorepercent a $oppositescorepercent.';
$string['feedback_help'] = 'Nápověda zpětné vazby';
$string['feedbackmessages'] = 'Sdělení zpětné vazby pro část {$a}';
$string['feedbacknextsection'] = 'Další část {$a}';
$string['feedbacknone'] = 'Žádná zpětná vazba';
$string['feedbacknotes'] = 'Poznámky ke zpětné vazbě';
$string['feedbacknotes_help'] = 'Tento text se zobrazí respondentům na konci jejich zpětné vazby';
$string['feedbackoptions'] = 'Volby zpětné vazby';
$string['feedbackoptions_help'] = 'Volby zpětné vazby jsou dostupné pouze tehdy, obsahuje-li Dotazování následující typ otázek: Ano/Ne, Přepínač, Rozbalovací nabídka nebo Měřítko. Tyto otázky musí být nastaveny jako povinné, jejich pole Název otázky nesmí být prázdné a pole Možné odpovědi musí obsahovat číselnou hodnotu.';
$string['feedbackremovequestionfromsection'] = 'Tato otázka je součástí [{$a}]. části zpětné vazby';
$string['feedbackremovesection'] = 'Odstraněním této otázky dojde také k odstranění celé [{$a}]. části zpětné vazby';
$string['feedbackreport'] = 'Zpráva se zpětnou vazbou';
$string['feedbackscore'] = 'Skóre zpětné vazby';
$string['feedbackscoreboundary'] = 'Hranice skóre této zpětné vazby';
$string['feedbackscores'] = 'Zobrazit skóre';
$string['feedbackscores_help'] = 'Zobrazit tabulku skóre zpětné vazby';
$string['feedbacksection'] = 'Část';
$string['feedbacksectionheading'] = 'Záhlaví zpětné vazby pro část {$a}';
$string['feedbacksectionheadingmissing'] = 'Musíte vyplnit pole Nadpis pro tuto část zpětné vazby!';
$string['feedbacksectionheadingtext'] = 'Nadpis';
$string['feedbacksectionlabel'] = 'Štítek';
$string['feedbacksectionlabel_help'] = 'Tento text bude použit v grafickém znázornění. Napište ho, prosím, co nejkratší!';
$string['feedbacksections'] = '{$a} části/í zpětné vazby';
$string['feedbacksectionsselect'] = 'Části';
$string['feedbacksectionsselect_help'] = 'Rozdělte následující otázky do jednotlivých částí';
$string['feedbacksettingssaved'] = 'Nastavení zpětné vazby uloženo';
$string['feedbacktype'] = 'Typ zpětné vazby';
$string['field'] = 'Otázka {$a}';
$string['fieldlength'] = 'Délka vstupního pole';
$string['fieldlength_help'] = 'Otázka typu Textové pole nabízí pro odpověď krátké textové pole, které může mít délku maximálně jednoho řádku. K nastavení délky pole a maximální délky textu slouží možnosti "Délka vstupního pole" (v původním nastavení má hodnotu 20) a "Max. délka textu" (v původním nastavení má hodnotu 25).';
$string['finished'] = 'Zodpověděli jste všechny otázky v tomto dotazníku.';
$string['firstrespondent'] = 'První respondent';
$string['formateditor'] = 'HTML editor';
$string['formatplain'] = 'Prostý text';
$string['grade'] = 'Hodnocení odpovědi';
$string['gradesdeleted'] = 'Hodnocení dotazování byla odstraněna';
$string['headingtext'] = 'Záhlaví textu';
$string['horizontal'] = 'Vodorovně';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Zahrnout kódy výběry';
$string['includechoicetext'] = 'Zahrnout text výběry';
$string['incorrectcourseid'] = 'Nesprávné ID kurzu';
$string['incorrectmodule'] = 'Nesprávné ID modulu kurzu';
$string['incorrectquestionnaire'] = 'Nesprávné Dotazování';
$string['invalidresponse'] = 'Uvadena neplatná odpověď.';
$string['invalidresponserecord'] = 'Uveden neplatný záznam odpovědi.';
$string['invalidsurveyid'] = 'Chybné ID Dotazování';
$string['kindofratescale'] = 'Typ stupnice měřítka';
$string['kindofratescale_help'] = 'Klepněte pravým tlačítkem myši na odkaz Další pomoc níže.';
$string['lastrespondent'] = 'Poslední respondent';
$string['length'] = 'Délka';
$string['managequestions'] = 'Spravovat otázky';
$string['managequestions_help'] = 'V sekci Spravovat otázky v nastavení dotazování je možno manipulovat s otázkami či upravovat jejich nastavení.';
$string['maxdigitsallowed'] = 'Max. počet cifer';
$string['maxdigitsallowed_help'] = 'Pro nastavení limitu  počtu znaků vložených pro číselnou otázku použijte ** Max. počet cifer **. Všimněte si, že desetinná tečka se také počítá jako jeden znak!';
$string['maxforcedresponses'] = 'Max. vyžadované odpovědi';
$string['maxtextlength'] = 'Max. délka textu';
$string['messageprovider:message'] = 'Připomenutí dotazníku';
$string['messageprovider:notification'] = 'Odpověď dotazníku';
$string['minforcedresponses'] = 'Min. vyžadované odpovědi';
$string['misconfigured'] = 'Chybně nastavený kurz';
$string['missingname'] = 'Odpověď na otázku {$a} nemůže být zahrnuta do zpětné vazby, jelikož jste nevyplnili pole Název otázky.';
$string['missingnameandrequired'] = 'Odpověď na otázku {$a} nemůže být zahrnuta do zpětné vazby, jelikož jste nevyplnili pole Název otázky a odpověď není povinná.';
$string['missingquestion'] = 'Chyba, zodpovězte otázku';
$string['missingquestions'] = 'Chyba, zodpovězte otázky:';
$string['missingrequired'] = 'Odpověď na otázku {$a} nemůže být zahrnuta do zpětné vazby, jelikož odpověď není povinná.';
$string['modulename'] = 'Dotazování';
$string['modulename_help'] = 'Modul Dotazování poskytuje řadu standardních dotazníkových nástrojů, které mohou být velmi přínosné pro získání zpětné vazby na kurz a zjištění potřeb studentů. Velmi dobře mohou také sloužit ke stimulaci výuky v on-line prostředí. Učitel má možnost vytvořit širokou škálu otázek a díky odpovědím uživatelů tak zjistit, jak je kurz hodnocen. Cílem Dotazování není studenta nějakým způsobem testovat či hodnotit, slouží ke sběru dat, které mohou být uplatněny ke zlepšení chodu kurzu.';
$string['modulenameplural'] = 'Dotazování';
$string['movedisabled'] = 'Tuto položku nelze přesunout';
$string['myresponses'] = 'Všechny vaše odpovědi';
$string['myresponsetitle'] = 'Vaše {$a} odpověd(i)';
$string['myresults'] = 'Vaše odpovědi';
$string['name'] = 'Jméno';
$string['navigate'] = 'Povolit větvení otázek';
$string['navigate_help'] = 'Umožní k otázkám typu Ano/Ne a Přepínač přiřazovat dceřiné otázky v závislosti na zvolené odpovědi na mateřskou otázku.';
$string['next'] = 'Další';
$string['nextpage'] = 'Další stránka';
$string['nlines'] = '{$a} řádků';
$string['noanswer'] = 'Žádná odpověď';
$string['noattempts'] = 'Žádné pokusy v tomto dotazníku';
$string['nodata'] = 'Neodeslána žádná data.';
$string['noduplicates'] = 'Bez duplicitních voleb';
$string['noduplicateschoiceserror'] = 'Musíte vložit alespoň 2 možné odpovědi.';
$string['noneinuse'] = 'Dotazník neobsahuje žádné otázky.';
$string['non_respondents'] = 'Uživatelé, kteří dosud neodeslali své odpovědi na toto dotazování';
$string['nopublicsurveys'] = 'Žádný veřejný dotazník.';
$string['noresponsedata'] = 'Pro tuto otázku nejsou žádné odpovědi';
$string['noresponses'] = 'Žádné odpovědi';
$string['normal'] = 'Normální';
$string['notanumber'] = '<strong>{$a}</strong> je nepovolená číselný formát.';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'sloupec N/A';
$string['notavail'] = 'Dotazování není doposud dostupné. Zkuste později.';
$string['noteligible'] = 'Nemáte oprávnění užívat tento dotazník.';
$string['notemplatesurveys'] = 'Žádná šablona';
$string['notenoughscaleitems'] = 'Musíte zadat minimální hodnotu 2 položek stupnice!';
$string['notifications'] = 'Odeslání oznámení o odpovědi';
$string['notopen'] = 'Dotazování nebude otevřeno do {$a}.';
$string['notrequired'] = 'Odpověď není vyžadována';
$string['not_started'] = 'není zahájeno';
$string['nousersselected'] = 'Není vybrán uživatel';
$string['num'] = '#';
$string['numattemptsmade'] = 'Počet pokusů v tomto dotazníku: {$a}';
$string['numberfloat'] = 'Vaše zadané číslo  <strong>{$a->number}</strong> bylo zaokrouhleno na <strong>{$a->precision}</strong> desetinných míst.';
$string['numberofdecimaldigits'] = 'Počet desetinných míst';
$string['numberscaleitems'] = 'Počet položek stupnice';
$string['numeric'] = 'Číselná odpověď';
$string['numeric_help'] = 'Tento typ otázky použijte v případě, že vyžadujete přesnou číselnou odpověď.';
$string['of'] = 'z';
$string['opendate'] = 'Použijte datum otevření';
$string['opendate_help'] = 'Po zaškrtnutí políčka Dostupné od je možno nastavit datum a čas otevření daného dotazování. Před tímto datem není dotazování uživatelům dostupné. Pokud políčko není zaškrtnuto, je dotazování dostupné kdykoliv.';
$string['option'] = 'volba  {$a}';
$string['optionalname'] = 'Název otázky';
$string['optionalname_help'] = 'Název otázky se používá pouze v případě převodu odpovědí do formátu CSV/Excel. Pokud tento převod nebudete provádět, můžete pole ponechat zcela prázdné. Pokud však plánujete pravidelně převádět data z Dotazování do formátu CSV/Excel, máte na výběr dvě možnosti pojmenování otázky.';
$string['or'] = '- nebo -';
$string['order_ascending'] = 'Vzestupné řazení';
$string['order_default'] = 'Zobrazit výchozí řazení';
$string['order_descending'] = 'Sestupné řazení';
$string['orderresponses'] = 'Řadit odpovědi';
$string['osgood'] = 'Osgood (Sémantický diferenciál)';
$string['other'] = 'Jiné:';
$string['otherempty'] = 'Když vyberete tuto volbu musíte vložit do textového pole nějaký text!';
$string['overviewnumresplog'] = 'odpovědi';
$string['overviewnumresplog1'] = 'odpověď';
$string['overviewnumrespvw'] = 'odpovědi';
$string['overviewnumrespvw1'] = 'odpověď';
$string['owner'] = 'Vlastník';
$string['page'] = 'Strana';
$string['pageof'] = 'Strana {$a->page} z {$a->totpages}';
$string['participant'] = 'Účastník';
$string['pleasecomplete'] = 'Vyplňte, prosím, tuto volbu.';
$string['pluginadministration'] = 'Správa Dotazování';
$string['pluginname'] = 'Dotazování';
$string['position'] = 'pozice';
$string['possibleanswers'] = 'Možné odpovědi';
$string['posteddata'] = 'Stránka s odeslanými údaji:';
$string['previewing'] = 'Náhled Dotazování';
$string['preview_label'] = 'Náhled';
$string['preview_questionnaire'] = 'Náhled Dotazování';
$string['previous'] = 'Předchozí';
$string['previouspage'] = 'Předchozí stránka';
$string['print'] = 'Tisk této odpovědi';
$string['printblank'] = 'Vytisknout nevyplněné';
$string['printblanktooltip'] = 'Otevřít okno pro tisk s prázdným dotazníkem';
$string['printtooltip'] = 'Otevřít okno pro tisk s aktuálním dotazníkem';
$string['private'] = 'Soukromý';
$string['public'] = 'Veřejný';
$string['publiccopy'] = 'Kopie:';
$string['publicoriginal'] = 'Originál:';
$string['qtype'] = 'Typ';
$string['qtypedaily'] = 'Odpovídat denně';
$string['qtype_help'] = 'Vyberte, zda bude uživatelům povoleno odpovědět na dotazování vícekrát, jednou, denně, týdně nebo měsíčně.';
$string['qtypemonthly'] = 'Odpovídat měsíčně';
$string['qtypeonce'] = 'Odpovědět jednou';
$string['qtypeunlimited'] = 'Odpovídat vícekrát';
$string['qtypeweekly'] = 'Odpovídat týdně';
$string['questionnaire:addinstance'] = 'Přidat nový dotazník';
$string['questionnaireadministration'] = 'Správa Dotazování';
$string['questionnairecloses'] = 'Zavřené dotazníky';
$string['questionnaire:copysurveys'] = 'Kopírovat šablonu a soukromé dotazníky';
$string['questionnaire:createpublic'] = 'Vytvořit veřejné dotazníky';
$string['questionnaire:createtemplates'] = 'Vytvořit šablonu dotazníků';
$string['questionnaire:deleteresponses'] = 'Odstranit odpověď';
$string['questionnaire:downloadresponses'] = 'Stáhnout odpovědi v CSV souboru';
$string['questionnaire:editquestions'] = 'Vytvořit a upravit otázky dotazníku';
$string['questionnaire:manage'] = 'Vytvořit a upravit dotazníky';
$string['questionnaire:message'] = 'Poslat učástrníkům, kteří neodpověděli zprávu';
$string['questionnaireopens'] = 'Otevřené dotazníky';
$string['questionnaire:preview'] = 'Zobrazit náhled dotazníků';
$string['questionnaire:printblank'] = 'Tisk prázdného dotazníku';
$string['questionnaire:readallresponseanytime'] = 'Vidět kdykoli všechny odpovědi';
$string['questionnaire:readallresponses'] = 'Vidět kdykoli souhrny odpovědí';
$string['questionnaire:readownresponses'] = 'Číst vlastní odpovědi';
$string['questionnairereport'] = 'Sestava Dotazování';
$string['questionnaire:submit'] = 'Ukončit a odeslat dotazník';
$string['questionnaire:view'] = 'Zobrazit dotazník';
$string['questionnaire:viewsingleresponse'] = 'Zobrazit úplně jednotlivé odpovědi';
$string['questionnum'] = 'Otázka #';
$string['questions'] = 'Otázky';
$string['questionsinsection'] = 'Otázky v této sekci:';
$string['questiontypes'] = 'Typy otázek';
$string['questiontypes_help'] = 'Prohlédněte si dokumentaci Moodlu níže';
$string['radiobuttons'] = 'Přepínač';
$string['radiobuttons_help'] = 'V tomto typu dotazu musí respondent vybrat jednu z nabízených možností.';
$string['rank'] = 'Rozsah';
$string['ratescale'] = 'Měřítko (stupnice 1 .. 5)';
$string['ratescale_help'] = 'Prohlédněte si dokumentaci Moodlu níže';
$string['realm'] = 'Typ dotazníku';
$string['realm_help'] = 'K dispozici jsou tři typy dotazování:
 * Soukromý - určený pouze pro potřeby daného kurzu.
 * Šablona - může být zkopírován a editován v jiném kurzu.
 * Veřejný - může být používán v jiných kurzech v původní podobě, bez možnosti editace.';
$string['redirecturl'] = 'URL, na které je uživatel přesměrován po vyplnění tohoto dotazníku.';
$string['remove'] = 'Zrušit';
$string['removeallquestionnaireattempts'] = 'Odstranit všechny odpovědi v dotazníku';
$string['removenotinuse'] = 'Tento dotazník závisel na veřejném dotazníku, který byl smazán. Nelze ji používat a měl by být smazán.';
$string['required'] = 'Odpověď je vyžadována';
$string['required_help'] = 'Při zaškrtnutí možnosti **Ano** bude mít student povinnost na tuto otázku odpovědět, jinak nebude možné dotazování ukončit.';
$string['requiredparameter'] = 'Chybí povinný parametr.';
$string['reset'] = 'Reset';
$string['respeligiblerepl'] = '(nahrazeno přepsáním role)';
$string['respondent'] = 'Účastník';
$string['respondenteligibleall'] = 'vše';
$string['respondenteligiblestudents'] = 'jen studenti';
$string['respondenteligibleteachers'] = 'jen učitelé';
$string['respondents'] = 'Účastníci';
$string['respondenttype'] = 'Zobrazení jména účastníka';
$string['respondenttypeanonymous'] = 'Anonym';
$string['respondenttypefullname'] = 'Plné jméno';
$string['respondenttype_help'] = 'Umožňuje nastavit, zda se u odpovědí na dotazování bude zobrazovat respondentovo plné jméno, nebo zda budou jeho odpovědi anonymní.';
$string['response'] = 'Odpověď';
$string['responsefieldlines'] = 'Počet řádků textového pole';
$string['responseformat'] = 'Formát odpovědi';
$string['responseoptions'] = 'Možnosti odpovědi';
$string['responses'] = 'Odpovědi';
$string['responseview'] = 'Studenti mohou vidět VŠECHNY odpovědi';
$string['responseview_help'] = 'Zde je možno specifikovat, kdy budou studenti moci zobrazit odpovědi ostatních.';
$string['responseviewstudentsalways'] = 'Vždy';
$string['responseviewstudentsnever'] = 'Nikdy';
$string['responseviewstudentswhenanswered'] = 'Po odpovězení dotazníku';
$string['responseviewstudentswhenclosed'] = 'Po dotazníku je uzavřen';
$string['restrictedtoteacher'] = 'Tyto funkce jsou povoleny pouze pro učitele!';
$string['resume'] = 'Uložit odpovědi a pokračovat';
$string['resume_help'] = 'Nastavení této možnosti umožňuje uživatelům uložit odpovědi do dotazníku před odesláním.  Uživatelé mohou ponechat dotazník nedokončený a pokračovat od místa uložení později.';
$string['resumesurvey'] = 'Pokračovat v dotazníku';
$string['return'] = 'Zpět';
$string['save'] = 'Uložit';
$string['saveasnew'] = 'Uložit jako Novou otázku';
$string['savedbutnotsubmitted'] = 'Tento dotazník byl uložen, ale dosud nebyl odeslán.';
$string['savedprogress'] = 'Vaše odpovědi byly uloženy. K tomuto Dotazování se můžete kdykoli vrátit a dokončit jej.';
$string['saveeditedquestion'] = 'Uložit otázku {$a}';
$string['savesettings'] = 'Uložit nastavení';
$string['search:activity'] = 'Dotazování - informace o činnosti';
$string['search:question'] = 'Dotazování - otázky';
$string['section'] = 'Popis';
$string['sectionbreak'] = '----- Nová stránka -----';
$string['sectionbreak_help'] = '----- Nová stránka -----';
$string['sectionsnotset'] = 'Musíte na jednu sekci vybrat alespoň jednu otázku! <br /> Nevybrané sekce: {$ a}';
$string['sectiontext'] = 'Informace';
$string['sectiontext_help'] = 'Nejedná se přímo o otázku, ale o informativní text, který je možné použít ke konkretizaci určité otázky či série otázek.';
$string['selecttheme'] = 'Vyberte téma (css), které chcete použít s tímto dotazníkem.';
$string['send'] = 'Odeslat';
$string['sendemail'] = 'Odeslat mail';
$string['sendemail_help'] = 'Umožňuje odeslat potvrzení o vyplnění každého dotazníku na zadanou e-mailovou adresu. Potvrzovací e-mail je možno zaslat i na více adres, tyto adresy od sebe pak oddělujte čárkou.

Nepřejete-li si zasílat potvrzovací e-maily, žádnou adresu nezadávejte.';
$string['send_message'] = 'Poslat zprávu vybraným uživatelům';
$string['send_message_to'] = 'Poslat zprávu:';
$string['settings'] = 'Nastavení';
$string['settingssaved'] = 'Nastavení uloženo';
$string['show_nonrespondents'] = 'Účastníci bez odpovědi';
$string['started'] = 'zahájeno';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['subject'] = 'Předmět';
$string['submissionnotificationhtmlanon'] = 'Nová <a href="{$a->submissionurl}">odpověď  </a>  v dotazníku "{$a->name}".';
$string['submissionnotificationhtmluser'] = 'Nová <a href="{$a->submissionurl}">odpověď  </a>  v dotazníku "{$a->name}" od  "<a href="{$a->profileurl}">{$a->username}</a>".';
$string['submissionnotificationsubject'] = 'Nová odpověď dotazníku';
$string['submissionnotificationtextanon'] = 'Nová odpověď  ({$a->submissionurl}) v dotazníku "{$a->name}".';
$string['submissionnotificationtextuser'] = 'Nová odpověď  ({$a->submissionurl}) v dotazníku "{$a->name}" od  "{$a->username}" ({$a->profileurl}).';
$string['submitoptions'] = 'Volby odpovědi';
$string['submitpreview'] = 'Náhled odpovědi';
$string['submitpreviewcorrect'] = 'Tato odpověď bude považována za správně vyplněnou.';
$string['submitsurvey'] = 'Odeslat dotazník';
$string['submitted'] = 'Odesláno:';
$string['subtitle'] = 'Podtitul';
$string['subtitle_help'] = 'Podtitul je text, který bude zobrazen na první straně dotazování pod Nadpisem.';
$string['summary'] = 'Popis';
$string['surveynotexists'] = 'dotazník neexistuje.';
$string['surveyowner'] = 'Pro provedení operace musíte být vlastníkem dotazníku.';
$string['surveyresponse'] = 'Odpovědi z dotazníku';
$string['template'] = 'Šablona';
$string['templatenotviewable'] = 'Šablona dotazníků není zobrazitelná.';
$string['text'] = 'Text otázky';
$string['textareacolumns'] = 'Počet sloupců textového pole';
$string['textarearows'] = 'Počet řádků textového pole';
$string['textbox'] = 'Textové pole';
$string['textbox_help'] = 'Otázka typu Textové pole nabízí pro odpověď krátké textové pole, které může mít délku maximálně jednoho řádku. K nastavení délky pole a maximální délky textu slouží možnosti "Délka vstupního pole" (v původním nastavení má hodnotu 20) a "Max. délka textu" (v původním nastavení má hodnotu 25).';
$string['textdownloadoptions'] = 'Volby pro stáhnutí textu (CSV)';
$string['thank_head'] = 'Děkujeme Vám za vyplnění tohoto dotazníku.';
$string['theme'] = 'Motiv';
$string['thismonth'] = 'tento měsíc';
$string['thisresponse'] = 'Tato odpověď';
$string['thisweek'] = 'tento týden';
$string['title'] = 'Nadpis';
$string['title_help'] = 'Název tohoto dotazníku, který se objeví v horní části každé stránky. Ve výchozím nastavení je název nastaven na název činnosti Dotazování, ale můžete jej upravit, jak chcete.';
$string['today'] = 'Dnes';
$string['total'] = 'Celkem';
$string['type'] = 'Typ otázky';
$string['undefinedquestiontype'] = 'Nedefinován typ otázky!';
$string['unknown'] = 'Neznámý';
$string['unknownaction'] = 'Zadána neznámá akce ...';
$string['url'] = 'URL potvrzení';
$string['url_help'] = 'URL, na které je uživatel přesměrován po vyplnění tohoto dotazníku.';
$string['useprivate'] = 'Kopírovat existující';
$string['usepublic'] = 'Použít veřejný';
$string['usetemplate'] = 'Kopírovat existující';
$string['vertical'] = 'Svisle';
$string['view'] = 'Zobrazit';
$string['viewallresponses'] = 'Zobrazit všechny odpovědi';
$string['viewbyresponse'] = 'Seznam odpovědí';
$string['viewindividualresponse'] = 'Jednotlivé odpovědi';
$string['viewindividualresponse_help'] = 'Kliknutím na respondentovo jméno přejdete na zobrazení odpovědí, které do dotazování zadal.';
$string['viewresponses'] = 'Všechny odpovědi  ({$a})';
$string['viewyourresponses'] = 'Vaše odpovědi ({$a})';
$string['warning'] = 'Varování, došlo k chybě.';
$string['wronganswers'] = 'Něco je ve vaší odpovědi špatně (viz níže)';
$string['wrongdateformat'] = 'Zadané datum: <strong>{$a}</strong> neodpovídá formátu uvedeném v příkladu.';
$string['wrongdaterange'] = 'Chyba! Rok musí být vyplněnv rozmezí 1902 - 2037.';
$string['wrongformat'] = 'Něco je špatně ve vaší odpovědi na otázku:&nbsp;';
$string['wrongformats'] = 'Něco je špatně ve vaší odpovědi na otázku:&nbsp;';
$string['yesno'] = 'Ano/Ne';
$string['yesno_help'] = 'Otázka Ano/Ne.';
$string['yourresponse'] = 'Vaše odpověď';
$string['yourresponses'] = 'Vaše odpovědi';
