<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'eu', branch 'MOODLE_36_STABLE'
 *
 * @package   scheduler
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ekintza';
$string['actions'] = 'Ekintza';
$string['addappointment'] = 'Gehitu beste ikasle bat';
$string['addcommands'] = 'Gehitu ordutegiak';
$string['addondays'] = 'Gehitu hitzorduak';
$string['addsession'] = 'Gehitu errepikatzen diren ordutegiak';
$string['addsingleslot'] = 'Gehitu ordutegi bakar bat';
$string['addslot'] = 'Beste ordutegi bat gehi dezakezu noiznahi.';
$string['addstudenttogroup'] = 'Gehitu ikasle hau hitzorduaren taldera';
$string['allappointments'] = 'Hitzordu guztiak';
$string['allononepage'] = 'Ordutegi guztiak orri batean';
$string['allowgroup'] = 'Ordutegia ikasle bakarrarekin - sakatu aldatzeko';
$string['allteachersgrading'] = 'Irakasleek hitzordu guztiak kalifika ditzakete';
$string['allteachersgrading_desc'] = 'Gaituz gero, irakasleek ebalua ditzakete esleitu ez zaizkien hitzorduak.';
$string['alreadyappointed'] = 'Ezin da hitzordua erreserbatu. Ordutegia jadanik okupatuta dago.';
$string['appointagroup_help'] = 'Aukeratu hitzordua bakarrik zuretzat ala talde oso batentzat erreserbatu nahi duzun.';
$string['appointfor'] = 'Ezarri hitzordua ondokoarentzat';
$string['appointforgroup'] = 'Ezarri hitzordua ondokoarentzat: {$a}';
$string['appointingstudent'] = 'Ordutegiaren erreserba';
$string['appointingstudentinnew'] = 'Ordutegi berri baten erreserba';
$string['appointment'] = 'Hitzordua';
$string['appointmentmode'] = 'Hitzordu-mota ezartzen';
$string['appointmentmode_help'] = '<p>Hemen hitzorduak erreserbatzeko moduan hainbat aukeren artean hauta dezakezu </p>
<p><ul>
<li><strong>"<emph>n</emph> hitzordu agenda honetan":</strong> Jarduera honetan ikasleak hitzordu-kopuru jakin bat baino ezin du erreserbatu. Irakasleak "ikusia" marka jarririk ere, ezingo dute ondorengo bilerarik erreserbatu. Ikasleek berriro erreserbak egiteko baimena berreskuratzeko modu bakarra "ikusia" marka duten erregistro zaharrak ezabatzea da.</li>
<li><strong>"<emph>n</emph> erreserba batera":</strong> Ikasleak hitzordu-kopuru finkoa erreserba dezake. Bileraren ondoren, irakasleak  ikasleari "ikusia" marka jarri eta gero,  ikasleak hitzordu gehiago erreserbatu ahal izango ditu. Hala ere, ikasleak edonoiz "ireki" (ikusi gabeko) <emph>n</emph> erreserba egiteko muga dauka.
</li>
</ul>
</p>';
$string['appointmentno'] = '{$a} hitzordua';
$string['appointmentnote'] = 'Hitzordurako oharrak (ikasleak ikus ditzake)';
$string['appointments'] = 'Hitzorduak';
$string['appointmentsgrouped'] = 'Taldekatutako erreserbak ordutegiaren arabera';
$string['appointmentsummary'] = 'Hitzordua {$a->startdate} ordu honetatik: {$a->starttime} honetara: {$a->endtime} irakasle honekin: {$a->teacher}';
$string['appointsolo'] = 'neu bakarrik';
$string['appointsomeone'] = 'Gehitu beste hitzordu bat';
$string['areaappointmentnote'] = 'Fitxategiak hitzorduaren oharretan';
$string['areaslotnote'] = 'Fitxategiak ordutegiaren oharretan';
$string['areateachernote'] = 'Fitxategiak isilpeko oharretan';
$string['attendable'] = 'Erreserbagarria';
$string['attendablelbl'] = 'Hitzordurako hautagai guztiak';
$string['attended'] = 'Artatua';
$string['attendedlbl'] = 'Artatutako ikasle-kopurua';
$string['attendedslots'] = 'Atenditutako ordutegiak';
$string['availableslots'] = 'Eskuragarri dauden ordutegiak';
$string['availableslotsall'] = 'Ordutegi guztiak';
$string['availableslotsnotowned'] = 'Besterenak';
$string['availableslotsowned'] = 'Norberarenak';
$string['bookaslot'] = 'Erreserbatu ordutegia';
$string['bookingdetails'] = 'Errreserbaren xehetasunak';
$string['bookingformoptions'] = 'Erreserbatzeko formularioa eta ikasleak emandako datuak';
$string['bookinginstructions'] = 'Erreserbarako argibideak';
$string['bookinginstructions_help'] = 'Testu hau erreserba egin berri duten ikasleei erakutsiko zaie. Mezuaren aukerazko eremua betetzeko edo fitxategiak igotzeko laguntza eman diezaieke.';
$string['bookslot'] = 'Erreserbatu ordutegia';
$string['bookwithteacher'] = 'Irakaslea';
$string['bookwithteacher_help'] = 'Aukeratu irakaslea hitzordurako';
$string['break'] = 'Ordutegien arteko atsedenak';
$string['breaknotnegative'] = 'Atsedenaldiaren iraupena ezin da negatiboa izan';
$string['canbook1appointment'] = 'Agenda honetan  hitzordu bat gehiago erreserba dezakezu.';
$string['canbooknappointments'] = 'Agenda honetan  {$a} hitzordu gehiago erreserba dezakezu.';
$string['canbooknofurtherappointments'] = 'Agenda honetan ezin duzu hitzordu gehiago erreserbatu.';
$string['canbooksingleappointment'] = 'Agenda honetan hitzordu bat erreserba dezakezu.';
$string['canbookunlimitedappointments'] = 'Agenda honetan nahi beste hitzordu erreserba dezakezu.';
$string['cancelbooking'] = 'Utzi erreserba';
$string['chooseexisting'] = 'Aukeratu existitzen dena';
$string['choosingslotstart'] = 'Hasiera-ordua aukeratzen';
$string['choosingslotstart_help'] = 'Aldatu (edo aukeratu) hitzordua noiz hasiko den. Hitzorduak beste erreserba batzuekin gatazka sortzen badu, erreserba honek lehentasuna izango ote duen galdetuko zaizu. Ohar zaitez erreserba berriaren ezarpenek aurreko guztienak gainidatziko dituztela.';
$string['comments'] = 'Iruzkinak';
$string['complete'] = 'Erreserbatuta';
$string['confirmbooking'] = 'Baieztatu erreserba';
$string['confirmdelete-all'] = 'Honek agenda honetan ordutegi  <b>guztiak</b> ezabatuko ditu. Ezin da berregin. Hala ere, jarraitu nahi al duzu?';
$string['confirmdelete-mine'] = 'Honek agenda honetan zure ordutegi  guztiak ezabatuko ditu. Ezin da berregin. Hala ere, jarraitu nahi al duzu?';
$string['confirmdelete-myunused'] = 'Honek agenda honetan zuk erabili gabeko ordutegiak ezabatuko ditu. Ezin da berregin. Hala ere, jarraitu nahi al duzu?';
$string['confirmdelete-one'] = 'Ordutegia ezabatu nahi al duzu?';
$string['confirmdelete-selected'] = 'Honek aukeratutako ordutegiak ezabatuko ditu. Ezin da berregin. Hala ere, jarraitu nahi al duzu?';
$string['confirmdelete-unused'] = 'Honek agenda honetan erabili gabeko ordutegiak ezabatuko ditu. Ezin da berregin. Hala ere, jarraitu nahi al duzu?';
$string['conflictingslots'] = '{$a} orduko erreserba ezin da sortu beste batzuekin gatazkan baitago:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} minutu) agenda honetan';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} minututan)  {$a->courseshortname} ikastaroan, {$a->schedulername} agenda';
$string['contentformat'] = 'Formatua';
$string['contentformat_help'] = '<p>Esportatzeko formaturako oinarrizko hiru aukera daude, erreserba anitzeko orduak tratatzeko moduaren arabera.
<dl>
<dt>Lerro bat ordutegi-tarteko</dt>:
<dd>
Irteerako fitxategiak ordutegi-tarte bakoitzeko lerro bat izango du. Tarte batek hitzordu asko izanez gero, ikaslearen izenez gain (adibidez) marka bat "(anitza") erakutsiko da.
</dd>
<dt>Lerro bat hitzorduko</dt>:
<dd>
Irteerako fitxategiak hitzorduko lerro bana izango du. Tarte batek hitzordu anitz badauka, zerrenda hainbat alditan azaldukoa da (datu errepikatuekin).
</dd>
<dt>Hitzorduak ordutegi-tartetan taldekatuta</dt>:
<dd>
Tarte bateko hitzordu guztiak elkarrekin azalduko dira, goialdean tartea zein den azaltzen delarik. Horrek arazoak sor ditzake CSV CSV irteeerako fitxategi-formatuarekin zutabe kopurua aldagarria baita.
</dd>
</dl>
"Aurreikusi" botoia erabil dezakezu aukera horien ondorioak aztertzeko.</p>';
$string['copytomyself'] = 'Bidali kopia neuri ere';
$string['course'] = 'Ikastaroa';
$string['createexport'] = 'Sortu esportatzeko fitxategia';
$string['csvfieldseparator'] = 'Eremu-bereizlea CSVrako';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Hitzorduen denerako iraupena';
$string['datatoinclude'] = 'Gehitzeko datuak';
$string['datatoinclude_help'] = 'Aukeratu esportazioan sartu beharreko eremuak. Horiek guztiak irteerako fitxategiko zutabe batean azalduko dira.';
$string['date'] = 'Data';
$string['datelist'] = 'Ikuspegi orokorra';
$string['defaultslotduration'] = 'Ordutegien berezko iraupena';
$string['defaultslotduration_help'] = 'Zuk finkatutako hitzordu-erreserbetarako lehenetsitako iraupena (minututan)';
$string['deleteallslots'] = 'Ezabatu ordutegi guztiak';
$string['deleteallunusedslots'] = 'Ezabatu erabili gabeko ordutegiak';
$string['deletecommands'] = 'Ezabatu ordutegiak';
$string['deletedconflictingslots'] = '{$a} orduko erreserbarekin gatazka sortzen zutenak ezabatu dira:';
$string['deletemyslots'] = 'Ezabatu nire ordutegi guztiak';
$string['deleteonsave'] = 'Ezabatu hitzordu hau (formularioa gordetzean)';
$string['deleteselection'] = 'Ezabatu aukeratutako ordutegiak';
$string['deletetheseslots'] = 'Ezabatu ordutegi hauek';
$string['deleteunusedslots'] = 'Ezabatu erabili ez ditudan ordutegiak';
$string['department'] = 'Nondik?';
$string['disengage'] = 'Utzi nire hitzorduak bertan behera';
$string['displayfrom'] = 'Noiztik erakutsi ordutegia ikasleei';
$string['distributetoslot'] = 'Banatu talde osoari';
$string['divide'] = 'Ordutegitan banatu?';
$string['duration'] = 'Iraupena';
$string['durationrange'] = 'Ordutegiaren iraupenak  {$a->min} eta  {$a->max} minutu bitartekoa izan behar du.';
$string['editbooking'] = 'Editatu erreserba';
$string['email_applied_html'] = '<p><a href="{$a->attendee_url}">{$a->attendee}</a> ikasleak hitzordua {$a->date} datan eta {$a->time} orduan eskatu du ikastaro honetarako:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>"<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" izenburuko agenda erabiliz webgune honetan: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = '{$a->attendee}</a> ikasleak hitzordua {$a->date} egunean eta {$a->time} orduan eskatu du ikastaro honetarako:

{$a->course_short}: {$a->course}

"{$a->module}" izenburuko agenda erabiliz webgune honetan: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Hitzordu berria';
$string['email_cancelled_html'] = '<p><strong>{$a->date}</strong> datan eta <strong>{$a->time}</strong> orduan <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> irakaslearekin ikastaro honetan duzun hitzordua:</p>

<p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>"<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" izenburuko agendan gune honetan : <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">ezeztatu edo mugitu da</span></strong>.</p>';
$string['email_cancelled_plain'] = '{$a->date} datan eta {$a->time} orduan {$a->attendee} ikaslearekin zenuen hitzordua ondoko ikastaroan:

{$a->course_short} : {$a->course}

{$a->site} web-guneko "{$a->module}" izeneko agendan

eta bertan behera geratu da edo ezabatu da.';
$string['email_cancelled_subject'] = '{$a->course_short}: Ikasleak hitzordua bertan behera utzi edo ezabatu du';
$string['email_invite_html'] = '<p>Mesedez, aukera ezazu ordutegi bat hitzordurako hemen: </p> <p>{$a->scheduler_url}</p>';
$string['email_invitereminder_html'] = '<p>Hau jakinarazpena da hitzordua oraindik finkatu ez duzula gogora dezazun. Aukeratu hemen ordutegi bat ahal bezain laster, mesedez:</p><p>{$a->scheduler_url}</p>';
$string['email_invitereminder_subject'] = 'Gogoratzeko abisua: {$a->module}';
$string['email_invite_subject'] = 'Gonbidapena: {$a->module}';
$string['emailreminder'] = 'Bidali gogoratzeko abisua posta elektroniko bidez';
$string['email_reminder_html'] = '<p>Hitzordua izango duzu <strong>{$a->date}</strong> datan
 <strong>{$a->time}</strong> ordutik <strong>{$a->endtime}</strong> ordura<br/>
 <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> irakaslearekin.</p>

<p>Kokapena: <strong>{$a->location}</strong></p>';
$string['emailreminderondate'] = 'Bidali gogoratzeko abisua posta elektroniko bidez une honetan:';
$string['email_reminder_plain'] = 'Hitzordua izango duzu {$a->date} datan {$a->time} ordutik {$a->endtime} ordura
 {$a->attendant} irakaslearekin.

Kokapena: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Hitzordua gogoratzeko abisua';
$string['email_teachercancelled_html'] = '<p>Zure hitzordua <strong>{$a->date}</strong> egunean eta <strong>{$a->time} </strong> orduan,<br/>
{$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> irakaslearekin ikastaro honetarako:</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>"<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" agendan web-gune honetan: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">bertan bera geratu da</span></strong>. Eskatu beste ordutegi bat, mesedez.</p>';
$string['email_teachercancelled_plain'] = '{$a->date} datan eta {$a->time} orduan {$a->attendee} irakaslearekin zenuen hitzordua ondoko ikastaroan:

{$a->course_short} : {$a->course}

{$a->site} web-guneko "{$a->module}" izeneko agendan

eta bertan behera geratu da edo ezabatu da. Mesedez, eskatu beste ordutegi bat.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Irakasleak utzi du bertan behera hitzordua';
$string['end'] = 'Amaiera';
$string['enddate'] = 'Noiz arte errepikatu ordutegiak';
$string['event_appointmentlistviewed'] = 'Agendako hitzorduen zerrenda ikusi da';
$string['event_bookingadded'] = 'Agendako erreserba gehitu da';
$string['event_bookingformviewed'] = 'Agendako erreserben formularioa ikusi da';
$string['event_bookingremoved'] = 'Agendako erreserba ezabatu da';
$string['event_slotadded'] = 'Agendako ordutegia gehitu da';
$string['event_slotdeleted'] = 'Agendako ordutegia ezabatu da';
$string['everyone'] = 'Guztiak';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Esklusiboa';
$string['exclusivity'] = 'Esklusibotasuna';
$string['exclusivity_help'] = '<p>Ordutegi bera eska dezaketen ikasleen kopurua muga dezakezu. </p>
<p>Lehenetsitako 1 mugak esan nahi du ordutegia ikasle bakar batek eska dezakeela.</p>
<p>Adibidez, 3 ezarriz gero, ordutegia gehienez hiru ikaslek eskatu ahal izango dute.</p>
<p>Desgaituz gero, ikasle-kopurua ez da mugatuko eta ordutegia ez da inoiz "betetzat" hartuko.</p>';
$string['exclusivityoverload'] = 'Ordutegia {$a} ikaslek eskatu dute, ezarritakoak baino gehiago.';
$string['exclusivitypositive'] = 'Ordutegiko ikasle-kopuruak 1 edo gehiagokoa izan behar du.';
$string['explaingeneralconfig'] = 'Aukera hauek bakarrik gunearen mailan ezar daitezke eta Moodle instalazio honetako agenda guztiei dagozkie.';
$string['export'] = 'Esportatu';
$string['exporthdr'] = 'Esportatu ordutegiak eta hitzorduak';
$string['field-appointmentnote'] = 'Hitzorduaren oharrak (ikaslearentzat)';
$string['field-attended'] = 'Artatuak';
$string['field-date'] = 'Data';
$string['field-endtime'] = 'Amaiera-ordua';
$string['field-filecount'] = 'Kargatutako fitxategi-kopurua';
$string['field-grade'] = 'Kalifikazioa';
$string['field-groupsmulti'] = 'Taldeak (zutabe anitzak)';
$string['field-groupssingle'] = 'Taldeak';
$string['field-groupssingle-label'] = 'Taldeak (zutabe bakarra)';
$string['field-location'] = 'Kokapena';
$string['field-maxstudents'] = 'Gehieneko ikasleak';
$string['field-slotnotes'] = 'Ordutegiaren oharrak';
$string['field-starttime'] = 'Hasiera-ordua';
$string['field-studentemail'] = 'Ikasleentzako posta elektronikoa';
$string['field-studentfirstname'] = 'Ikaslearen izena';
$string['field-studentfullname'] = 'Ikaslearen izen osoa';
$string['field-studentidnumber'] = 'Ikaslearen ID zenbakia';
$string['field-studentlastname'] = 'Ikaslearen deitura';
$string['field-studentnote'] = 'Mezua ikaslearen arabera';
$string['field-studentusername'] = 'Ikaslearen erabiltzaile-izena';
$string['field-teachernote'] = 'isilpeko oharrak (irakaslearentzat bakarrik)';
$string['fileformat'] = 'Fitxategi-formatua';
$string['fileformat_help'] = 'Fitxategi-formatu hauek eskuragarri daude:
 <ul>
<li>Komaz banatutako baloreak (CSV) testu-fitxategiak. Eremu-banatzailea, koma lehenetsita dago, behealdean dago.
CSV fitxategiak kalkulu-orriko aplikazio gehienetan ireki daitezke;</li>
<li>Microsoft Excel fitxategiak (Excel 2007 formatua);</li>
<li>Open Document kalkulu-orriak (ODS);</li>
<li>HTML formatua - web orri batek taula erakusten du eta nabigatzailetik inprima daiteke;</li>
<li>PDF dokumentuak. Orientazio bertikal eta horizontalaren artean aukera daiteke.</li>
</ul>';
$string['finalgrade'] = 'Azken kalifikazioa';
$string['firstslotavailable'] = 'Lehen ordutegia ordu honetan irekiko da: {$a}';
$string['forbidgroup'] = 'Taldeko ordutegia - klikatu aldatzeko';
$string['forcewhenoverlap'] = 'Behartu gainjarriz gero';
$string['forcewhenoverlap_help'] = '<h3>Behartu ordutegi-sorrera tarteak gainjartzen direnean</h3>
<p>Ezarpen honek zehazten du ordutegi berriak nola tratatuko diren zaharrekin gainjartzen direnean.</p>
<p>Gaituz gero, gainjarritako ordutegi zaharra ezabatu eta berria sortuko da.</p>
<p>Desgaituz gero,  gainjarritako ordutegi zaharra gorde eta ordutegi berria <em>ez</em> da sortuko.</p>';
$string['forcourses'] = 'Aukeratu ikasleak ikastaroetan';
$string['friday'] = 'Ostirala';
$string['generalconfig'] = 'Ezarpen orokorrak';
$string['grade'] = 'Kalifikazioa';
$string['gradeingradebook'] = 'Kalifikatu kalifikazio-liburuan';
$string['gradingstrategy'] = 'Kalifikazio-estrategia';
$string['gradingstrategy_help'] = 'Ikasleek hitzordu asko edukitzea onartzen duen agenda batean aukeratu kalifikazioak nola jartzen diren.
Kalifikazio-liburuak ikasleak lortu duen <ul><li>nota baxuena edo </li><li>altuena</li></ul> erakuts dezake.';
$string['group'] = 'taldea';
$string['groupbookings'] = 'Erreserba taldeka';
$string['groupbookings_help'] = 'Gaitu ikasleek beren taldeko kide guztientzako ordutegia eska dezaten.
(Ohar zaitez hau ez dela "taldeko modua" ezarpena bezalakoa, ikasleak ikus ditzakeen tarteak kontrolatzen duena.)';
$string['groupbreakdown'] = 'Talde-tamainaren arabera';
$string['groupmodeyourgroups'] = 'Taldeko modua: {$a->groupmode}. Bakarrik {$a->grouplist} taldeko ikasleek hitzorduak zurekin eska ditzakete.';
$string['groupmodeyourgroupsempty'] = 'Taldeko modua: {$a->groupmode}. Ez zara ezein taldeko kidea. Hori dela-eta, ikasleek ezin dute zurekiko hitzordua eskatu.';
$string['groupscheduling'] = 'Gaitu taldeko planifikazioa';
$string['groupscheduling_desc'] = 'Gaitu talde osoek hitzorduak batera eskatu ahal izatea.
(Aukera orokorraz gain, "Taldekako erreserbak" ezarpena ere agendaren instantzietan gaitu beharra dago.)';
$string['groupsession'] = 'Taldekako saioa';
$string['groupsize'] = 'Talde-tamaina';
$string['guardtime'] = 'Zaintza-ordua';
$string['guardtime_help'] = 'Zaintza-orduek ekiditen dute ikasleek hitzordua indargabetzeko gutxi falta denean.
<p>Zaintza-ordua gaitu eta, adibidez, 2 ordutara ezarriz gero, ikasleek ezingo dute tartea erreserbatu bi orduko epean baino lehenago, eta ezingo dute indargabetu bi ordu baino gutxiago falta direnean.</p>';
$string['guestscantdoanything'] = 'Hemen gonbidatuek ezin dute ezer egin.';
$string['howtoaddstudents'] = 'Maila orokorreko agendan ikasleak gehitzeko, erabili moduluaren baimen-ezarpena.<br/>Moduluaren baimen-definizioak ere erabil ditzakezu zure ikasleen solaskideak zehazteko.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Baztertu planifikazio-gatazkak';
$string['ignoreconflicts_help'] = 'Laukitxo hau aukeratuz gero, tartea eskatutako egun eta ordura mugituko da, unea berean tarteak egon arren. Horrek irakasle edo ikasle batzuen hitzorduak teilakatzea ekar dezake, eta horregatik kontuz erabili behar den ezarpena da.';
$string['includeemptyslots'] = 'Hutsik dauden ordutegiak barne ditu';
$string['includeslotsfor'] = 'Ondokoentzako ordutegiak barne ditu';
$string['incourse'] = 'ikastaroan';
$string['introduction'] = 'Sarrera';
$string['isnonexclusive'] = 'Ez-esklusiboa';
$string['landscape'] = 'Horizontala';
$string['lengthbreakdown'] = 'Ordutegiaren  arabera';
$string['limited'] = 'Mugatua ({$a} left)';
$string['location'] = 'Kokapena';
$string['location_help'] = 'Zehaztu bileraren kokapena.';
$string['markasseennow'] = 'Markatu ikusitzat orain';
$string['markseen'] = 'Ikasle batekin hitzordua izan ondoren, marka ezazu ikusitzat goialdeko bere erabiltzailearen irudiaren ondoko laukitxoan klikatuz.';
$string['maxgrade'] = 'Hartu kalifikazio altuena';
$string['maxstudentlistsize'] = 'Ikasleen zerrendaren gehieneko luzera';
$string['maxstudentlistsize_desc'] = 'Hitzordua behar duten ikasleen zerrendaren gehienezko luzera, agendaren irakaslearen ikuspegian erakutsi bezala. Ikasle gehiago izanez gero, ez da zerrendarik erakutsiko.';
$string['maxstudentsperslot'] = 'Gehieneko ikasle-kopurua ordutegiko';
$string['maxstudentsperslot_desc'] = 'Taldeko ordutegiek / ordutegi ez-esklusiboek gehienez ikasle-kopuru hau izan dezakete. Ohar zaitez ordutegi baterako "mugarik ez" ezarpena beti aukera daitekeela.';
$string['meangrade'] = 'Hartu kalifikazio baxuena';
$string['meetingwith'] = 'Bilera zure';
$string['meetingwithplural'] = 'Bilera zure';
$string['message'] = 'Mezua';
$string['messagebody'] = 'Mezuaren testua';
$string['messageprovider:bookingnotification'] = 'Jakinarazi erreserba egin edo indargabetzen denean';
$string['messageprovider:invitation'] = 'Ordutegia erreserbatzeko gonbidapena';
$string['messageprovider:reminder'] = 'Hitzordu baterako oharpena';
$string['messagesent'] = 'Mezua {$a} hartzaileri bidali zaie';
$string['messagesubject'] = 'Gaia';
$string['minutes'] = 'minutu';
$string['minutesperslot'] = 'minutu ordutegiko';
$string['missingstudents'] = 'Oraindik {$a} ikaslek hitzordua behar dute';
$string['missingstudentsmany'] = 'Oraindik {$a} ikaslek hitzordua behar dute. Tamaina dela-eta, ez da zerrendarik erakusten.';
$string['mixindivgroup'] = 'Nahastu banakako eta taldeko erreserbak';
$string['mixindivgroup_desc'] = 'Taldeko agenda gaituta dagoenean, onartu ere norbanakoen erreserbak.';
$string['mode'] = 'Modua';
$string['modeappointments'] = 'hitzordutarako';
$string['modeintro'] = 'Ikasleek erregistroa egin dezakete';
$string['modeoneatatime'] = 'aldi berean';
$string['modeoneonly'] = 'agenda honetan';
$string['modulename'] = 'Agenda';
$string['modulename_help'] = 'Agenda jarduerak zure ikasleekin hitzorduak adosten laguntzen dizu.

Irakasleek bileretarako ordutegiak zehazten dituzte eta ikasleek Moodlen horietako bat aukera dezakete. Irakasleek agenda barruan bileraren txostena gorde eta, nahi izanez gero, kalifika dezakete.

Taldeko agenda gaituta dago, hau da, ordutegi bakoitzean ikasle asko onar daitezke eta, hala nahi izanez gero, talde osoentzako hitzorduak ere erreserba daitezke.';
$string['modulenameplural'] = 'Agendak';
$string['monday'] = 'Astelehena';
$string['multiple'] = '(anitzak)';
$string['myappointments'] = 'Nire hitzorduak';
$string['myself'] = 'Ni neu';
$string['name'] = 'Agendaren izena';
$string['needteachers'] = 'Talde honek irakaslerik ez duenez, ezin da ordutegirik gehitu.';
$string['negativerange'] = 'Tartea ezin da negatiboa izan.';
$string['never'] = 'Inoiz ez';
$string['nfiles'] = '{$a} fitxategi';
$string['noappointments'] = 'Hitzordurik ez';
$string['noexistingstudents'] = 'Hitzordua erreserbatzeko ikaslerik ez';
$string['nogroups'] = 'Hitzordua erreserbatzeko talderik ez';
$string['noresults'] = 'Emaitzarik ez.';
$string['noschedulers'] = 'Ez dago agendarik';
$string['noslots'] = 'Ez dago ordutegi-tarte eskuragarririk';
$string['noslotsavailable'] = 'Une honetan ez dago hitzordurako ordutegirik.';
$string['noslotsopennow'] = 'Oraintxe ez dago erreserbatzeko ordutegirik.';
$string['nostudents'] = 'Ez dago erreserba duen ikaslerik';
$string['nostudenttobook'] = 'Erreserbatzeko ikaslerik ez';
$string['note'] = 'Kalifikazioa';
$string['noteacherforslot'] = 'Ordutegi horietarako irakaslerik ez';
$string['noteachershere'] = 'Ez dago irakasle librerik';
$string['notenoughplaces'] = 'Sentitzen dugu baina ordutegi-tarte honetan ez dago aski ordutegi libre.';
$string['notesrequired'] = 'Ordutegia erreserbatu aurretik eremu honetan testua idatzi behar duzu.';
$string['notifications'] = 'Jakinarazpenak';
$string['notifications_help'] = 'Aukera hau gaituz gero, ikasle eta irakasleei jakinaraziko zaie hitzorduak eskatu edo ezeztatzen direnean.';
$string['notseen'] = 'Ikusi gabea';
$string['now'] = 'Orain';
$string['occurrences'] = 'Istiluak';
$string['odsformat'] = 'ODS';
$string['on'] = 'hemen';
$string['onedaybefore'] = 'Ordutegia baino egun bete lehenago';
$string['onelineperappointment'] = 'Lerro bat hitzorduko';
$string['onelineperslot'] = 'Lerro bat ordutegiko';
$string['oneslotadded'] = 'Ordutegi bat gehitu da';
$string['oneslotdeleted'] = 'Ordutegi bat ezabatu da';
$string['oneweekbefore'] = 'Ordutegia baino astebete lehenago';
$string['onthemorningofappointment'] = 'Hitzorduaren goizean';
$string['options'] = 'Aukerak';
$string['otherstudents'] = 'Beste partaideak';
$string['outlineappointments'] = 'izandako {$a->attended} hitzordu, {$a->upcoming} egiteko.';
$string['outlinegrade'] = 'Kalifikazioa: {$a}.';
$string['overall'] = 'Denera';
$string['overlappings'] = 'Ordutegi batzuk gainjarrita daude';
$string['pageperteacher'] = 'Orri bat bakoitzeko: {$a}';
$string['pagination'] = 'Orrikatzea';
$string['pagination_help'] = 'Aukeratu esportazioan irakasle bakoitzak berezko orria izan behar duen.
Excel eta ODS fitxategi-formatuetan orri hauek liburuko fitxei dagozkie.';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'PDF orrien orientazioa';
$string['pluginadministration'] = 'Agendaren kudeaketa';
$string['pluginname'] = 'Agenda';
$string['portrait'] = 'Bertikala';
$string['preview'] = 'Aurreikusi';
$string['previewlimited'] = '(Aurreikuspena {$a} errenkadatara dago mugatuta.)';
$string['privacy:metadata:filepurpose'] = 'Oharretan ordutegi edo hitzorduetarako erabilitako fitxategia';
$string['privacy:metadata:scheduler_appointment'] = 'Ordutegi batean ikasle baten hitzordua ordezkatzen du';
$string['privacy:metadata:scheduler_appointment:appointmentnote'] = 'Irakaslearen oharra (ikasleak ikus dezakeena)';
$string['privacy:metadata:scheduler_appointment:appointmentnoteformat'] = 'Irakaslearen oharren formatua';
$string['privacy:metadata:scheduler_appointment:attended'] = 'Hitzordua bete ote den';
$string['privacy:metadata:scheduler_appointment:grade'] = 'Hitzorduaren kalifikazioa';
$string['privacy:metadata:scheduler_appointment:studentid'] = 'Hitzordua erreserbatu duen ikaslea';
$string['privacy:metadata:scheduler_appointment:studentnote'] = 'Ikaslearen oharra';
$string['privacy:metadata:scheduler_appointment:studentnoteformat'] = 'Ikaslearen oharraren formatua';
$string['privacy:metadata:scheduler_appointment:teachernote'] = 'Ikaslearen oharra (pribatua)';
$string['privacy:metadata:scheduler_appointment:teachernoteformat'] = 'Irakaslearen ohar pribatuaren formatua';
$string['privacy:metadata:scheduler_slots'] = 'Agendaren ordutegi bat ordezkatzen du';
$string['privacy:metadata:scheduler_slots:appointmentlocation'] = 'Hitzordu-lekua';
$string['privacy:metadata:scheduler_slots:duration'] = 'Ordutegiaren iraupena minututan';
$string['privacy:metadata:scheduler_slots:exclusivity'] = 'Ordutegi batean parte har dezaketen ikasleen gehieneko kopurua';
$string['privacy:metadata:scheduler_slots:notes'] = 'Ordutegiari buruzko oharra';
$string['privacy:metadata:scheduler_slots:notesformat'] = 'Oharren formatua';
$string['privacy:metadata:scheduler_slots:starttime'] = 'Ordutegiaren hasiera';
$string['privacy:metadata:scheduler_slots:teacherid'] = 'Ordutegiaren lotutako irakaslea';
$string['purgeunusedslots'] = 'Ezabatu pasatutako ordutegi erabili gabeak';
$string['recipients'] = 'Hartzaileak';
$string['registeredlbl'] = 'Hitzordutako ikaslea';
$string['reminder'] = 'Gogoratzeko abisua';
$string['requireupload'] = 'Fitxategia kargatzea beharrezkoa';
$string['resetappointments'] = 'Ezabatu hitzorduak eta kalifikazioak';
$string['resetslots'] = 'Ezabatu agendako ordutegiak';
$string['return'] = 'Itzuli ikastarora';
$string['revealteachernotes'] = 'Erakutsi irakasleen oharrak esportazio pribatuetan';
$string['revealteachernotes_desc'] = 'Aukera hau gaituz gero, irakaslearen ohar pribatua, hots, ikasleek ikus ezin dituztenak, datuen esportazio-eskaeretan erakutsiko zaizkie ikasleei pribatutasun APIaren bidez. Eremu honen erabilera indibidualaren arabera erabaki beharko zenuke ea ikasleentzako datuen esportazioan sartu behar diren, GDPRi dagokionez.';
$string['revoke'] = 'Utzi bertan behera hitzordua';
$string['saturday'] = 'larunbata';
$string['save'] = 'Gorde';
$string['savechoice'] = 'Gorde nire aukera';
$string['saveseen'] = 'Gorde ikusitakoak';
$string['schedule'] = 'Programatu';
$string['scheduleappointment'] = 'Programatu hitzordua honentzat: {$a}';
$string['schedulecancelled'] = '{$a}: Zure hitzordua bertan behera geratu da edo ezabatu da';
$string['schedulegroups'] = 'Programatu taldearen arabera';
$string['scheduleinnew'] = 'Programatu ordutegi berri batean';
$string['scheduleinslot'] = 'Programatu ordutegi batean';
$string['scheduler'] = 'Agenda';
$string['scheduler:addinstance'] = 'Gehitu beste agenda bat';
$string['scheduler:appoint'] = 'Erreserbatu ordutegiak';
$string['scheduler:attend'] = 'Artatu ikasleak';
$string['scheduler:canscheduletootherteachers'] = 'Erreserbatu beste langileentzako hitzorduak';
$string['scheduler:canseeotherteachersbooking'] = 'Ikusi eta aztertu beste irakasleen erreserbak';
$string['scheduler:disengage'] = 'Ezarpen hau gaitzetsi da eta ez du eraginik';
$string['scheduler:manage'] = 'Kudeatu zure ordutegiak eta hitzorduak';
$string['scheduler:manageallappointments'] = 'Kudeatu agenda guztien datuak';
$string['scheduler:seeotherstudentsbooking'] = 'Ikusi ordutegia erreserbatu duten beste ikasleak';
$string['scheduler:seeotherstudentsresults'] = 'Ikusi ikaslearen emaitzak beste ordutegi baterako';
$string['scheduler:seeoverviewoutsideactivity'] = 'Erabili gainbegiratzeko pantaila agenda-jarduera honetatik kanpoko beste ordutegiak ikusteko';
$string['scheduler:viewfullslots'] = 'Ikusi ordutegiak guztiz beteta izan arren (ikaslearen pantailan)';
$string['scheduler:viewslots'] = 'Ikusi erreserba daitezkeen ordutegiak (ikaslearen pantailan)';
$string['schedulestudents'] = 'Programatu ikaslearen  arabera';
$string['scopemenu'] = 'Non erakutsi ordutegiak: {$a}';
$string['scopemenuself'] = 'Non erakutsi nire ordutegiak: {$a}';
$string['search:activity'] = 'Agenda- jarduera-informazioa';
$string['seen'] = 'Ikusita';
$string['selectedtoomany'] = 'Ordutegi asko aukeratu dituzu. Ezin duzu  {$a} baino gehiago aukeratu.';
$string['sendinvitation'] = 'Bidali gonbidapena';
$string['sendmessage'] = 'Bidali mezua';
$string['sendreminder'] = 'Bidali gogoratzeko abisua';
$string['sendreminders'] = 'Bidali hurrengo hitzorduetarako posta elektroniko bidezko jakinarazpenak';
$string['sepcolon'] = 'Bi puntu';
$string['sepcomma'] = 'Koma';
$string['sepsemicolon'] = 'Puntu eta koma';
$string['septab'] = 'Tabulazioa';
$string['showemailplain'] = 'Erakutsi helbide elektronikoak testu lauan';
$string['showemailplain_desc'] = 'Erakutsi hitzordua behar duten ikasleen helbide elektronikoak testu lauan agendaren irakaslearen ikuspegian, jasotzaileen estekekin batera.';
$string['showparticipants'] = 'Erakutsi partaideak';
$string['slot'] = 'Ordutegia';
$string['slotdatetime'] = '{$a->shortdatetime} {$a->duration} minutuz';
$string['slotdatetimelabel'] = 'Data eta ordua';
$string['slotdatetimelong'] = '{$a->date}, {$a->starttime} &ndash; {$a->endtime}';
$string['slotdescription'] = '{$a->status} {$a->startdate} datan {$a->starttime}(e)tik  {$a->endtime}(e)ra {$a->location}(e)n {$a->facilitator}(e)kin.';
$string['slot_is_just_in_use'] = 'Barkatu, baina hitzordua dagoeneko beste ikasle batek aukeratu du. Saiatu berriro, mesedez.';
$string['slots'] = 'Ordutegiak';
$string['slotsadded'] = '{$a} ordutegi gehitu d(ir)a';
$string['slotsdeleted'] = '{$a} ordutegi ezabatu d(ir)a';
$string['slottype'] = 'Ordutegi-mota';
$string['slotupdated'] = 'Ordutegi bat eguneratu da';
$string['slotwarning'] = '<strong>Kontuz!</strong> Ordutegi hau aukeratutako ordutegira mugitzeak behealdean zerrendatutako ordutegiekin gatazkak sortuko ditu. Klikatu "Baztertu planifikazio-gatazkak", ordutegia edonola ere mugitu nahi baduzu.';
$string['staffbreakdown'] = '{$a}ren arabera';
$string['staffrolename'] = 'Irakasle rolerako izena';
$string['staffrolename_help'] = 'Ikasleak artatzeko baimenaren etiketa. Ez du halabeharrez "irakaslea" izan behar.';
$string['start'] = 'Hasiera';
$string['startpast'] = 'Ordutegia ezin da hasi pasatako data batean';
$string['statistics'] = 'Estatistikak';
$string['student'] = 'Ikaslea';
$string['studentbreakdown'] = 'Ikaslearen arabera';
$string['studentcomments'] = 'Ikaslearen mezua';
$string['studentdetails'] = 'Ikaslearen zehaztapenak';
$string['studentfiles'] = 'Kargatutako fitxategiak';
$string['studentmultiselect'] = 'Ikasle bakoitza behin bakarrik har daiteke ordutegi honetan';
$string['studentnote'] = 'Mezua ikaslearen arabera';
$string['studentprovided'] = 'Ikasleak emandakoa: {$a}';
$string['students'] = 'Ikasleak';
$string['sunday'] = 'Igandea';
$string['tab-otherappointments'] = 'Ikasle honen hitzordu guztiak';
$string['tab-otherstudents'] = 'Ordutegi honetako ikasleak';
$string['tab-thisappointment'] = 'Hitzordu hau';
$string['teacher'] = 'Irakaslea';
$string['teachernote'] = 'isilpeko oharrak, ikusgarri bakarrik irakasleentzat';
$string['teachersmenu'] = 'Norentzat erakutsi ordutegiak: {$a}';
$string['thiscourse'] = 'ikastaro honetan';
$string['thisscheduler'] = 'agenda honetan';
$string['thissite'] = 'gune osoan';
$string['thursday'] = 'Osteguna';
$string['timefrom'] = 'Noiztik:';
$string['timerange'] = 'Denbora-tartea';
$string['timeto'] = 'Noiz arte:';
$string['totalgrade'] = 'Kalifikazio osoa';
$string['tuesday'] = 'Asteartea';
$string['unattended'] = 'Artatu gabe';
$string['unlimited'] = 'Mugarik gabe';
$string['unregisteredlbl'] = 'Hitzordurik gabeko ikasleak';
$string['upcomingslots'] = 'Datozen ordutegiak';
$string['updategrades'] = 'Eguneratu kalifikazioak';
$string['updatesingleslot'] = 'Eguneratu ordutegia';
$string['uploadmaxfiles'] = 'Kargatzeko gehieneko fitxategi-kopurua';
$string['uploadmaxfilesglobal'] = 'Kargatzeko gehieneko fitxategi-kopurua';
$string['uploadmaxfilesglobal_desc'] = 'Erreserba-inprimakian ikasleak igo dezakeen gehienezko fitxategi-kopurua. Kopurua agenda indibidualetan murriz daiteke.';
$string['uploadmaxfiles_help'] = 'Erreserba-inprimakian ikasleak igo dezakeen gehienezko fitxategi-kopurua. Fitxategiak igotzea hautazkoa da, "Fitxategia kargatzea beharrezkoa" botoia aukeratu ezean. 0 ezarriz gero, ikasleei ez zaie igotzeko laukitxoa erakutsiko.';
$string['uploadmaxsize'] = 'Fitxategiaren gehieneko tamaina';
$string['uploadmaxsize_help'] = 'Ikasleek igotzen dituzten fitxategien gehienezko tamaina. Muga fitxategiko aplikatzen da.';
$string['uploadrequired'] = 'Fitxategiak kargatu behar dituzu ordutegia erreserbatu baino lehen.';
$string['uploadstudentfiles'] = 'Kargatu fitxategiak';
$string['usebookingform'] = 'Erabili erreserbatzeko formularioa';
$string['usebookingform_help'] = 'Gaituz gero, ikasleek ordutegia erreserbatu ahal izan baino lehen erreserba-pantaila ikusten du. Baliteke erreserba-pantailak data zehazteko, fitxategiak igotzeko edo captcha betetzeko eskatzea. Ikusi aukerak beherago.';
$string['usecaptcha'] = 'Erabili CAPTCHA erreserba berrietarako';
$string['usecaptcha_help'] = 'Gaituz gero, erreserba berria egin aurretik ikasleek CAPTCHAko segurtasun-galdera erantzun beharko dute.
Erabili ezarpen hau ikasleak ordutegiak ahal bezain laster erreserbatzeko aplikazio automatikoak erabiltzen ari direla susmatzen baduzu.
<p>Ikaslea erreserba zaharra editatzen ari bada, ez zaio captcha erakutsiko-</p>';
$string['usenotes'] = 'Erabili oharrak hitzorduetan';
$string['usenotesboth'] = 'Bi ohar-motak';
$string['usenotesnone'] = 'bat ere ez';
$string['usenotesstudent'] = 'Hitzorduaren oharra, irakasle nahiz ikaslearentzat ikusgarri';
$string['usenotesteacher'] = 'isilpeko oharra, ikusgarri bakarrik irakasleentzat';
$string['usestudentnotes'] = 'Utzi ikasleei mezua idazten';
$string['usestudentnotes_help'] = 'Gaituz gero, erreserba-pantailak testu-eremua edukiko ikasleek mezua idaz dezaten. Erabili goialdeko "erreserba-argibideak" ikasleei zer informazio eman beharko luketen jakinarazteko.';
$string['viewbooking'] = 'Ikusi xehetasunak';
$string['wednesday'] = 'Asteazkena';
$string['welcomebackstudent'] = 'Ordutegi gehiago erreserba ditzakezu dagokion beheko  "Erreserbatu ordutegia" botoian klikatuz.';
$string['welcomenewstudent'] = 'Beheko taulak hitzordu baterako eskura dauden ordutegi guztiak erakusten ditu. Aukeratzeko klikatu "Erreserbatu ordutegia" botoian. Geroago aldaketarik egin behar baduzu, orri hau berriro bisita dezakezu.';
$string['welcomenewteacher'] = 'Klikatu behealdeko botoian hitzordu-tartea gehitzeko.';
$string['what'] = 'Zer?';
$string['whathappened'] = 'Zer gertatu da?';
$string['whatresulted'] = 'Zein emaitza?';
$string['when'] = 'Noiz?';
$string['where'] = 'Non?';
$string['who'] = 'Norekin?';
$string['whosthere'] = 'Nor dago hor?';
$string['xdaysbefore'] = 'Ordutegia baino {$a} egun lehenago';
$string['xweeksbefore'] = 'Ordutegia baino {$a} aste lehenago';
$string['yesallgroups'] = 'Bai, talde guztietarako';
$string['yesingrouping'] = 'Bai, {$a} taldetan';
$string['yesoptional'] = 'Bai, aukerakoa ikaslearentzat';
$string['yesrequired'] = 'Bai, ikasleak mezua idatzi behar du';
$string['yourappointmentnote'] = 'Zuretzako iruzkinak';
$string['yourslotnotes'] = 'Bilerari buruzko iruzkinak';
$string['yourstudentnote'] = 'Zure mezua';
$string['yourtotalgrade'] = 'Hauxe da jarduera honetako zure kalifikazioa: <strong>{$a}</strong>.';
