<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'eu', branch 'MOODLE_36_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Sarrera ukatu egin zaizu';
$string['accounts'] = 'Kontuak';
$string['addcategory'] = 'Gehitu kategoria';
$string['additionalhtml'] = 'HTML osagarria';
$string['additionalhtml_desc'] = 'Ezarpen hauek nahi dituzun orri guztietan HTML kodea zehazteko modua emango dizute. Orriaren HEAD etiketaren barruan gehituko den HTMLa ezarri ahal duzu, BODY etiketa zabaldutakoan edo BODY etiketa itxitakoan. <br />Hau egiteak orri bakoitzean goiburu edo orri-oin pertsonalizatuak gehitzeko modua eskaintzen dizu, edo, aukeratutako itxura gorabehera, Google Analytics bezalako zerbitzuetarako euskarria gehitzeko oso modu errazean.';
$string['additionalhtmlfooter'] = 'BODY itxi baino lehen';
$string['additionalhtmlfooter_desc'] = 'Edukia orri bakoitzean gehituko da BODY etiketa itxi baino lehen.';
$string['additionalhtmlhead'] = 'Goiburuaren barruan';
$string['additionalhtmlhead_desc'] = 'Edukia orri bakoitzean gehituko da HEAD  etiketaren amaieran.';
$string['additionalhtml_heading'] = 'Orri bakoitzean gehitzen den HTML osagarria';
$string['additionalhtmltopofbody'] = 'BODY zabalik dagoenean';
$string['additionalhtmltopofbody_desc'] = 'Edukia orri bakoitzean gehituko da BODY etiketa irekitakoan.';
$string['admincategory'] = 'Kategoria: {$a}';
$string['adminseesall'] = 'Kudeatzaileek dena ikusten dute';
$string['adminseesallevents'] = 'Kudeatzaileek agerraldi guztiak ikusten dituzte';
$string['adminseesownevents'] = 'Kudeatzaileak gainerako erabiltzaileak bezalakoak dira';
$string['advancedfeatures'] = 'Funtzio aurreratuak';
$string['agedigitalconsentverification'] = 'Onespen-adin digitalaren egiaztatzea';
$string['agedigitalconsentverification_desc'] = 'Erabiltzaileek auto-erregistroaren bidez izena emateko orriaren aurretik onespen-adin digitalaren egiaztatzea erakustea gaitzen du. Ezarpen honek zure gunean adin txikikoek euren guraso/tutoreen onespenik gabe izena ematea saihesten du. Laguntza gehiago eskuratzeko adin txikikoei <a target="_blank" href="{$a}">Laguntzarako kontaktuaren zehaztasunak</a> eskaintzen zaizkie.';
$string['ageofdigitalconsentmap'] = 'Onespen-adin digitala';
$string['ageofdigitalconsentmap_desc'] = 'Hemen lehenetsitako onespen-adin digitala eta lehenetsitako balio horrekin bat egiten ez duten herrialdeen adinak zehaztu daitezke. Idatzi adin bakoitza errenkada batean hurrengo formatuarekin: herrialde-kodea, adina (komaz banatuta). Lehenetsitako adina herrialde-kodean * karakterea jarrita adierazten da. Herrialde-kodeak ISO 3166-2-an zehaztuta daude.';
$string['allcountrycodes'] = 'Herrialdeetako kode guztiak';
$string['allowattachments'] = 'Baimendu eranskinak';
$string['allowbeforeblock'] = 'Baimendutako zerrenda prozesatuko da lehenik';
$string['allowbeforeblockdesc'] = 'Modu lehenetsian, lehenbizi blokeatutako IP helbideen zerrenda prozesatuko da; aukera hau gaituz gero, baimendutako IP zerrenda blokeatutako zerrenda baino lehenago prozesatuko da.';
$string['allowblockstodock'] = 'Baimendu blokeak ertzera eramaten';
$string['allowcategorythemes'] = 'Baimendu kategoriaren itxurak';
$string['allowcohortthemes'] = 'Baimendu kohorteen itxurak';
$string['allowcoursethemes'] = 'Baimendu ikastaroaren itxurak';
$string['allowedemaildomains'] = 'Baimendutako posta elektronikoko domeinuak';
$string['allowediplist'] = 'Baimendutako IP zerrenda';
$string['allowemailaddresses'] = 'Baimendutako posta elektronikoko domeinuak';
$string['allowframembedding'] = 'Baimendu markoa enbotatzea';
$string['allowframembedding_help'] = 'Gaituz gero, gunea hau urruneko sistema bateko marko batean enbotatu ahal izango da \'Argitaratu LTI tresna gisa\' matrikula-plugina erabiltzekotan. Bestela, segurtasuna dela-eta, markoak enbotatzea aholkatzen da.';
$string['allowguestmymoodle'] = 'Baimendu bisitariei Aginte-panelerako sarbidea';
$string['allowindexing'] = 'Baimendu bilatzaileek indexatzea';
$string['allowindexing_desc'] = 'Ezarpen honek bilaketa-tresnek zure gunea indexatzea ahalbidetzen du. "Nonahi" aukeratuz gero, bilaketa-tresnek nonahi bilatuko dute, sarbide- eta matrikula-orriak barne direlarik. Horrek esan nahi du sarbidea behartzen duten guneak ere indexatzen direla. Matrikula-orrian bilatu ahal izateak ekar dezakeen spamaren arazoa saihesteko, erabil ezazu "Nonahi sarbide- eta matrikula-orrietan izan ezik". "Inon ez" ezarpenak bilaketa-tresnei esaten die orririk ez indexatzeko. Ohar zaitez hori gunearen goialdeko etiketa baino ez dela. Etiketa errespetatzea bilaketa-tresnaren araberakoa da.';
$string['allowindexingeverywhere'] = 'Toki guztietan';
$string['allowindexingexceptlogin'] = 'Nonahi sarbide- eta matrikula-orrietan izan ezik';
$string['allowindexingnowhere'] = 'Inora ere ez';
$string['allowobjectembed'] = 'Baimendu EMBED eta OBJECT etiketak';
$string['allowthemechangeonurl'] = 'Baimendu itxurak URLan aldatzea';
$string['allowuserblockhiding'] = 'Baimendu erabiltzaileei blokeak ezkutatzea';
$string['allowusermailcharset'] = 'Baimendu erabiltzaileari karaktere-multzoa aldatzen';
$string['allowuserswitchrolestheycantassign'] = 'Baimendu rolak aldatzen rolak ezartzeko gaitasuna ez duten erabiltzaileei';
$string['allowuserthemes'] = 'Baimendu erabiltzailearen itxurak';
$string['alternativefullnameformat'] = 'Ordezko izen osoaren formatua';
$string['alternativefullnameformat_desc'] = 'Ezarpen honek definitzen du izenak nola erakusten zaizkien izen osoa ikustea gaituta duten erabiltzaileei (kudeatzaile-, irakasle- edo edizio-baimenik gabeko irakasle-rola dutenei, besterik adierazi ezean). Erabil daitezkeen gakoak "Izen osoaren formatua" ezarpenarenak bezalakoak dira.';
$string['always'] = 'Beti';
$string['appearance'] = 'Itxura';
$string['aspellpath'] = 'Aspell-erako bidea';
$string['authentication'] = 'Autentifikazioa';
$string['authpreventaccountcreation'] = 'Galarazi kontuen sorrera identifikatzean';
$string['authpreventaccountcreation_help'] = 'Erabiltzaile batek izena eman eta bere kontua oraindik ere ez badago, automatikoki sortuko da bat gunean. Izena emateko kanpoko datu-basea erabiltzen bada, LDAP esterako, baina aldez aurretik kontua duten erabiltzaileei baino ez bazaie gunean sartzen utzi nahi, gaitu egin behar da aukera hau. Kontu berriak eskuz sortu beharko dira edo erabiltzaileak igotzeko funtzioa erabilita. Kontuan izan ezarpen honek ez diola eragiten MNet izena emateko aukerari.';
$string['authsettings'] = 'Kudeatu autentifikazioa';
$string['autolang'] = 'Atzeman hizkuntza automatikoki';
$string['autologinguests'] = 'Bisitarientzako sarbide automatikoa';
$string['availablelicenses'] = 'Eskura dauden lizentziak';
$string['availableto'] = 'Eskuragarria honentzat';
$string['backgroundcolour'] = 'Kolore gardena';
$string['backups'] = 'Segurtasun-kopiak';
$string['backup_shortname'] = 'Erabili ikastaroaren izena segurtasun-kopiaren fitxategi-izenean';
$string['backup_shortnamehelp'] = 'Erabili ikastaroaren izena segurtasun-kopiaren fitxategiaren izen gisa';
$string['badwordsconfig'] = 'Idatzi zentsuratutako hitzen zerrenda, komaz banatuta';
$string['badwordsdefault'] = 'Zerrenda pertsonalizatua hutsik badago, lehenetsitako zerrenda erabiliko da.';
$string['badwordslist'] = 'Zentsuratutako hitzen zerrenda pertsonalizatua';
$string['blockediplist'] = 'Blokeatutako IP zerrenda';
$string['blockinstances'] = 'Instantziak';
$string['blockmultiple'] = 'Anitza';
$string['blockprotect'] = 'Babestu instantziak';
$string['blockprotect_help'] = 'Bloke-mota zehatz bat blokeatzen baduzu, instantziak edonork gehitu edo ezabatu ahal izango ditu. (Jakina, instantziak editatu behar badituzu, berriz desblokea dezakezu.)

Horren helburua nabigazio-blokea bezalakoak babestea da, baita nahigabe ezabatuz gero berreskuratzeko zailak diren ezarpenak ere.';
$string['blocksettings'] = 'Kudeatu blokeak';
$string['blockunprotect'] = 'Babesa kendu';
$string['bloglevel'] = 'Bloga ikusi';
$string['bookmarkadded'] = 'Laster-marka gehituta.';
$string['bookmarkalreadyexists'] = 'Orri hau markatua duzu dagoeneko';
$string['bookmarkdeleted'] = 'Laster-marka ezabatuta.';
$string['bookmarkthispage'] = 'Markatu orri hau';
$string['cacheapplication'] = 'Aplikazio-cachea';
$string['cacheapplicationhelp'] = 'Cachean gordetako elementuak erabiltzaile guztiekin partekatzen dira eta biziraupen jakin bat dute (ttl).';
$string['cachejs'] = 'Javascript-en cachea';
$string['cachejs_help'] = 'Javascript fitxategien cachea eta konpresioak orri-kargaren errendimendua asko hobetzen du. Lanean ari diren guneetan irmoki gomendatzen da. Garatzaileek ezarpen hau desgaitu nahiko dute, ziurrenik.';
$string['cacherequest'] = 'Eskatu cachea';
$string['cacherequesthelp'] = 'Erabiltzaile-cache espezifikoa, eskaria osatzen denean iraungitzen dena. Biltegiratze estatikoa erabiltzen ari garenean eremuak ordezkatzeko diseinatua.';
$string['cachesession'] = 'Saio-cachea';
$string['cachesessionhelp'] = 'Erabiltzaile-cache espezifikoa, erabiltzailearen saioa amaitzen denean  iraungitzen dena. Saioaren gainkarga arintzeko diseinatua.';
$string['cachesettings'] = 'Cachearen ezarpenak';
$string['caching'] = 'Cacheak';
$string['calendarexportsalt'] = 'Egutegia esportatzeko eraldaketa';
$string['calendarsettings'] = 'Egutegia';
$string['calendartype'] = 'Egutegi-mota';
$string['calendartype_desc'] = 'Aukeratu lehenetsitako egutegi-mota bat gune osorako. Ezarpen honek salbuespenak izan ditzake ikastaroaren ezarpenen bidez edo erabiltzaileek beren profiletan zehaztutakoaren bidez.';
$string['calendar_weekend'] = 'Asteburuko egunak';
$string['cannotdeletemodfilter'] = 'Ezin duzu \'{$a->filter}\' desinstalatu \'{$a->module}\' moduluaren zati bat baita.';
$string['cannotuninstall'] = '{$a} ezin da desinstalatu.';
$string['categoryemail'] = 'Posta elektronikoa';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot aldagaia modu ezegokian zehaztuta dago config.php fitxategian. Amaieran kendu beharreko \'/\' karakterea dauka.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot aldagaia modu ezegokian zehaztuta dago config.php fitxategian. Orri honetara sartzeko erabiltzen ari zaren URLarekin bat etorri behar du.';
$string['change'] = 'aldatu';
$string['checkboxno'] = 'Ez';
$string['checkboxyes'] = 'Bai';
$string['choosefiletoedit'] = 'Aukeratu fitxategi bat editatu ahal izateko';
$string['cleanup'] = 'Garbiketa';
$string['clianswerno'] = 'e';
$string['cliansweryes'] = 'b';
$string['cliincorrectvalueerror'] = 'Errorea, "{$a->value}" balioa ez da egokia "{$a->option}"-rako';
$string['cliincorrectvalueretry'] = 'Balio ezegokia, mesedez saiatu berriz';
$string['clistatusdisabled'] = 'Egoera: desgaituta';
$string['clistatusenabled'] = 'Egoera: gaituta';
$string['clistatusenabledlater'] = 'egoera: CLI mantenu-modua gaituko da hemen: {$a}';
$string['clitypevalue'] = 'Sartu balioa';
$string['clitypevaluedefault'] = 'sartu balioa, sakatu Enter-i lehenetsitako balioa erabiltzeko ({$a})';
$string['cliunknowoption'] = 'Aukera ezezagunak:
 {$a}
Mesedez, erabili --help aukera.';
$string['cliupgradedefault'] = 'Ezarpen berria: {$a}';
$string['cliupgradedefaultheading'] = 'Lehenetsitako balio berriak ezartzen';
$string['cliupgradedefaultverbose'] = 'Ezarpen berria: {$a->name}, Lehenetsitako balioa: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Komando-lerro bidezko {$a->oldversion} bertsiotik {$a->newversion} bertsiorako eguneraketa ondo osatu da.';
$string['cliupgradenoneed'] = 'Ez da eguneraketarik behar instalatutako  {$a} bertsiorako.';
$string['cliyesnoprompt'] = 'idatzi b (bai esateko) edo e (ez esateko)';
$string['commentsperpage'] = 'Orriko erakutsiko diren iruzkinak';
$string['commonactivitysettings'] = 'Jardueren ezarpen komunak';
$string['commonfiltersettings'] = 'Iragazkien ezarpen komunak';
$string['commonsettings'] = 'Ezarpen komunak';
$string['componentinstalled'] = 'Osagaia instalatuta';
$string['computedfromlogs'] = 'Log-etarako konputatua {$a}-tik';
$string['condifmodeditdefaults'] = 'Lehenetsitako balioak jarduera edo baliabide berria sortzeko formularioaren ezarpenetan erabiliko dira.';
$string['confeditorhidebuttons'] = 'Aukeratu HTML editorean ezkutuan egongo diren botoiak';
$string['configallcountrycodes'] = 'Hainbat tokitan, erabiltzailearen profilean esaterako, aukeratzeko erabiliko den herrialdeen zerrenda da hau. Hutsik utzita (lehenetsitakoa) Ingelesezko hizkuntza-pakete estandarreko countries.php fitxategiko zerrenda erabiliko da. ISo 3166-1-eko zerrenda da hau. Bestela, komaz banatuta zehaz dezakezu kodeen zerrenda, adibidez \'GB,FR,ES\'. Berririk gehitzen baduzu, kode ez estandarrak alegia, zure hizkuntza-paketeko countries.php fitxategira ere gehitu beharko dituzu.';
$string['configallowassign'] = 'Ezkerreko rolak dituztenei beste batzuei rolen zutabekoren bat ezartzen utzi';
$string['configallowattachments'] = 'Gaituz gero, gune honetatik bidalitako e-mailek eranskinak izan ditzakete, dominak adibidez.';
$string['configallowblockstodock'] = 'Gaituz gero eta aukeratutako itxurak onartzen badu, erabiltzaileak blokeak bazterrera eraman ditzake.';
$string['configallowcategorythemes'] = 'Hau gaituta, itxurak kategoria mailan ezar daitezke. Honek beheragoko kategoria eta ikastaro guztiei eragingo die ez bazaie beste itxura bat propio ezarri. KONTUZ: Itxurak gaitzeak errendimenduari eragin ahal dio.';
$string['configallowcohortthemes'] = 'Hau gaitzen baduzu, itxurak kohorteen mailan ezarri ahal izango dira. Horrek itxura bera erabiltzen duten baina kohorte bakar bat edo gehiago duten erabiltzaile guztiengan eragina izango du.';
$string['configallowcoursethemes'] = 'Aukera hau hartuz gero, ikastaroen itxura aldatu ahal izango da. Ikastaroen itxurak lehentasuna du beste itxurekiko (gunea, erabiltzailea edo saioa)';
$string['configallowedemaildomains'] = 'Aukera honek irteerako e-mailen "Igorlea" atalean erakuts daitezkeen posta elektronikoko domeinuak zerrendatzen ditu. Lehenetsita dagoen "Hutsik" ezarpenak Ez-erantzun helbidea erabiliko du irteerako e-mail guztietan. Komodinak erabil daitezke, esate baterako *.adibide.com ezartzeak adibide.com-eko edozein azpidomeinutik bidalitako irteerako -emailak ahalbidetuko ditu, baina ez adibide.com-etik. Horrek beste sarrera beharko luke.';
$string['configallowemailaddresses'] = 'Helbide elektronikoak domeinu partikularretara murriztu nahi badituzu, zerrenda itzazu tarteek banatuta. Beste domeinu guztiak gaitzetsiko dira. Azpidomeinuak baimentzeko, gehitu aurretik \'.\' domeinuari. Jatorrizko domeinua eta bere azpidomeinuak baimentzeko gehitu domeinua bi aldiz - behin aurretik \'.\' gehituta eta beste behin domeinua baino ez adibidez: .gureeskola.eus gureeskola.eus';
$string['configallowguestmymoodle'] = 'Gaituz gero, bisitariek Aginte-panelerako sarbidea dute, bestela guneko hasiera-orrira birbideratuko dira.';
$string['configallowobjectembed'] = 'Lehenetsitako segurtasun-neurri gisa, erabiltzaile arruntek ezingo dute HTML kodean multimedia-objekturik txertatu (adibidez, Flash) testuaren barruan EMBED eta OBJECT etiketen bidez (media-plugin iragazkiekin egiterik izango da, baina). Marka horiek onartzea nahi baduzu, aukera aktibatu.';
$string['configallowoverride'] = 'Zutabeetan agertzen diren rolak beste batzuei baliogabetzen utzi ahal diezu ezkerreko rolak dituztenei';
$string['configallowoverride2'] = 'Aukeratu zein rol baliogabetu ahal duen ezkerreko zutabeko rol bakoitzak.<br />Kontuan izan ezarpen hau moodle/role:override edo moodle/role:safeoverride gaitasunak baimenduta dituzten erabiltzaileei baino ezin zaiela aplikatu.';
$string['configallowswitch'] = 'Aukeratu erabiltzaile bat zein roletara alda daitekeen, jadanik dituen roletan oinarrituz. Taula honetako sarreraz gain, erabiltzaileak moodle/role:switchroles gaitasuna gaituta izan beharko du. <br />Ohar zaitez soilik moodle/course:view gaitasuna duten baina moodle/site:doanything gaitasuna ez duten roletara alda daitekeenez, taula honetako zutabe batzuk desgaituta daudela.';
$string['configallowthemechangeonurl'] = 'Gaituz gero, itxura aldatu egin daiteke edozein Moodleren URL-tatik &theme=itxurarenizena gehituta (adibidez: niremoodlegunea.com/?theme=afterburner edo niremoodlegunea.com/course/view.php?id=2&theme=afterburner).';
$string['configallowuserblockhiding'] = 'Erabiltzaileek guneko aldeetako blokeak erakutsi eta ezkutatu ahal izatea nahi al duzu? Aukera honek Javascript eta cookie-ak erabiltzen ditu blokeen egoera gogoratzeko, eta erabiltzaileek informazioa nola ikusiko duten zehazten du.';
$string['configallowusermailcharset'] = 'Gaituz gero, guneko erabiltzaile guztiek ezarri ahal izango dute bere karaktere-multzoa e-mailak idazteko.';
$string['configallowuserswitchrolestheycantassign'] = 'Modu lehenetsian, moodle/role:assign gaitasuna beharrezkoa da erabiltzaileek beste rol bat hartu ahal izateko. Ezarpen hau gaituta baldintza hori kendu egiten duzu eta ondorioz "Aukeratu beste rol bat" zabaltzen den menuan agertuko diren rolak soilik "Baimendu rol esleipenak" taulan ezarritakoak baldintzatuko du.
Gomendagarria da "Baimendu rol esleipenak" taulako ezarpenek ez ematea erabiltzaileei duten rolak baino gaitasun handiagoa duen beste bat hartzeko aukera.';
$string['configallowuserthemes'] = 'Aukera hau aktibatzen baduzu, erabiltzaileek nahi duten itxura aukeratu ahal izango dute. Erabiltzailearen itxurak gunearenarekiko lehentasuna dauka (baina ez ikastaroarenarekiko)';
$string['configallowview'] = 'Aukeratu erabiltzaileak ikusi, iragazi... ahalko dituen rolak, dagoeneko dituen roletan oinarrituta.';
$string['configallusersaresitestudents'] = 'Webgunearen lehen orriko jarduerei dagokienez, erabiltzaile guztiak ikasletzat hartu behar al dira? Erantzuna "Bai" balitz, onartutako partaide guztiek jardueratan parte ahal izango lukete. Erantzuna "Ez" balitz, gutxienez ikastaro batean parte hartzen dutenek izango dute eskubide hori. Lehen orriko jardueretan soilik horretarako esleitutako kudeatzaileek eta irakasleek  parte har dezakete.';
$string['configauthenticationplugins'] = 'Mesedez, aukera itzazu erabili nahi dituzun autentifikazio-pluginak eta jar itzazu ordenan.';
$string['configautolang'] = 'Atzeman nabigatzailean lehenetsitako hizkuntza, desgaituz gero gunean lehenetsitako balio erabiltzen bada.';
$string['configautologinguests'] = 'Bisitariei sarbidea onartzen duten ikastaroetara automatikoki sartzen utziko al zaie?';
$string['configbloglevel'] = 'Aukera honek gune honetan erabiltzaileen blogak ikusteko mailak murrizten utziko dizu. Kontuan izan ikusten dituenaren gehienezko testuingurua zehazten dela baina ez mezuak bidaltzen dituenarena eta ezta blogera bidalitako mezu-motena ere. Nahi izanez gero, blogak erabat desgaitu daitezke.';
$string['configcalendarcustomexport'] = 'Gaitu egutegiko daten tarte baten pertsonalizatutako esportazioa';
$string['configcalendarexportsalt'] = 'Ausazko testu hau egutegiak esportzeko orduan erabilitako fitxen autentifikazioaren segurtasuna hobetzeko erabiltzen da. Kontuan izan fitxa guztiak indargabetuko direla eraldaketa-kode hau aldatzen baduzu.';
$string['configcookiehttponly'] = 'PHP 5.2.0 bertsioaren funtzio berria gaitzen du - nabigatzaileei adierazten zaie cookie-a soilik benetako http-eskariei bidaltzeko. Cookie-ak ez lirateke script hizkuntzetatik eskuragarri egon behar. Nabigatzaile guztiek ez dute funtzio hau onartzen eta agian ez da oraingo kodearekin bateragarri izango. Hainbat XSS erasori aurre egiten laguntzen du.';
$string['configcookiesecure'] = 'Zerbitzariak soilik https konexioak onartzen baditu, cookie seguruak bidaltzea gaitzea gomendatzen da. Aukera hau gaituz gero, mesedez ziurtatu web-zerbitzariak ez duela onartzen http:// edo ezarri https:// helbideetarako behin betiko berbidalketa eta ahal dela HSTS goiburuak bidaltzea. <em>wwwroot</em> helbide bat https://-rekin hasten ez denean ezarpen hau automatikoki desgaitzen da.';
$string['configcountry'] = 'Herrialde bat aukeratuz gero, herrialde hori lehenetsitako balioa izango da kontu edo erabiltzaile  berrientzat. Erabiltzaileak herrialde bat aukeratzera behartzeko, aukera ez hartu.';
$string['configcoursegraceperiodafter'] = 'Sailkatu iraganeko ikastaroak martxan baileuden ikastaroen amaiera-dataren ondorengo egun-epe honetan.';
$string['configcoursegraceperiodbefore'] = 'Sailkatu etorkizuneko ikastaroak martxan baileuden ikastaroak hasi aurreko egun-epe honetan.';
$string['configcourseoverviewfilesext'] = 'Ikastaroko ikuspegi orokorrean onartutako fitxategien luzapenen zerrenda, komaz banatuta';
$string['configcourseoverviewfileslimit'] = 'Ikastaroen zerrendan ikastaroaren laburpenaren ondoan gehienez erantsi daitekeen fitxategi-kopurua. Gehitutako lehen irudi-fitxategia ikastaroko irudi gisa erabiliko da erabiltzaileen Aginte-paneleko ikastaroen ikuspegi orokorrean; gehitzen diren beste fitxategi guztiak ikastaroen zerrendan baino ez dira erakutsiko.';
$string['configcourserequestnotify'] = 'Erabiltzailearen erabiltzaile-izena ikastaro berriaren eskaria egiten denerako';
$string['configcourserequestnotify2'] = 'Ikastaro-eskaria egiten denean jakinarazpena jasoko duten erabiltzaileak. Soilik ikastaro-eskariak onar ditzaketen erabiltzaileak agertuko dira zerrenda honetan.';
$string['configcoursesperpage'] = 'Idatzi ikastaro-zerrenda batean orriko zenbat ikastaro erakutsi behar den.';
$string['configcourseswithsummarieslimit'] = 'Ikastaro-zerrendan erakutsiko den gehienezko ikastaro-kopurua, laburpena edukita, zerrenda sinplera itzuli aurretik.';
$string['configcronclionly'] = 'Cron-a web-nabigatzaile baten bitartez exekutatzeak informazio pribilegiatua erabiltzaile ezezagunei ikusgai jartzea suposatu lezake. Horregatik cron-a komando-lerro batetik baino ez exekutatzea edo bestela cron-aren urruneko sarbideetarako pasahitza zehaztea gomendatzen da.';
$string['configcronremotepassword'] = 'Honek esan nahi du cron.php script-a ezin dela web nabigatzaile batetik exekutatu pasahitza eman gabe, ondokoa bezalako URL motako formularioa erabiliz: <pre>
 https://gunea.adibidea.eus/admin/cron.php?password=opensesame
</pre>. Hutsik utziz gero, ez da pasahitzik behar.';
$string['configcurlcache'] = 'cURL cachearen biziraupena (segundoetan).';
$string['configcustommenuitems'] = 'Zure Moodle gunearen goiburuan erakutsiko den menu pertsonalizatua sor dezakezu. Menu hau gaika antola daiteke eta horrela, lerro bakoitzean menuaren testu-zati bat, URL bat (aukerakoa), izenburuaren deskribapena (aukerakoa) eta hizkuntzen kodea edo komaz banatutako kodeen zerrenda (aukerazkoa, errenkada erabiltzailearen hizkuntzaren arabera erakusteko edo ez) izango dira, marra bertikal batek banatuta. Azpimenuen egitura sor dezakezu gidoiak erabilita eta bereizleak erabil daitezke lerro bat edo bat baino gehiago gehitzeko # ikurra erabilita. Adibidez:
<pre>
Moodle komunitatea|https://moodle.org
-Moodle-ren doako laguntza|https://moodle.org/support
-Moodle-ren dokumentazioa|https://docs.moodle.org|Moodle Docs
-Moodle-ren Dokumentazioa euskaraz|https://docs.moodle.org/eu|Dokumentazioa euskaraz|eu
-###
-Moodle-ren garapena|https://moodle.org/development
Moodle.com|https://moodle.com/
</pre>';
$string['configcustomusermenuitems'] = 'Erabiltzailearen menuaren edukiak konfigura ditzakezu (automatikoki gehitzen den irteera-menua izan ezik). Lerroak tutu karakterez banatzen dira eta egitura hau dute: 1) "langstringname, componentname" formatua duen katea edo testu laukoa, 2) URL bat, eta 3) ikono bat, irudi gisakoa (pix karpetan, [azpikarpeta]/[ikonoarenizena] egiturarekin) edo URL gisakoa. Bereizgailuak erabil daitezke, bereizgailua nahi duzun lekuan # karakterearen lerro bat edo gehiago gehituta.';
$string['configdbsessions'] = 'Gaituz gero, saioen informazioa metatzeko datu-basea erabiliko da. Ohar zaitez honen aldaketa erabiltzaile guztiak deskonektatuko dituela, zeu ere barne. MySQL erabiltzen baduzu ziurtatu my.cnf (edo my.ini) fitxategian dagoen \'max_allowed_packet\' ezarpenaren balioa gutxienez 4M dela. Saioari buruzko beste ezarpenak config.php-n zuzenean ezarri daitezke; ikusi config-dist.php informazio gehiago lortzeko. Aukera hau desagertzen da config.php-n saioaren driverra ezartzen baduzu.';
$string['configdebug'] = 'Aukera hau aktibatuz gero, PHPko error_reporting maila igoko da eta abisu gehiago jasoko duzu. Garatzaileentzat baino ez da erabilgarria.';
$string['configdebugdisplay'] = 'Aukera hau gaituz gero, erroreen txostena HTML orrira joango da. Praktikoa da baina, oro har, XHTML, JS, cookie-ak eta HTTP goiburuak apurtzen ditu. Aukera hau desgaituz gero, zerbitzariaren erregistroetara bidaliko da eta arazketa hobeto egingo da. PHPren error_log ezarpenak zein erregistrotara doan kontrolatzen du.';
$string['configdebugpageinfo'] = 'Gaitu ezazu orriaren informazioa orri-oinean inprimatzea nahi baduzu.';
$string['configdebugsmtp'] = 'SMTP zerbitzarira posta elektronikoak bidali bitartean, informazio zehatzeko arazketa gaitzen du. Ezarpen honek eragina izan dezan, \'Arazketa mezuen maila\' ezarpenak \'Garatzailea\' izan behar du.';
$string['configdebugvalidators'] = 'Gaitu orri-oinean balioesteko kanpoko zerbitzarietarako estekak nahi izanez gero. Baliteke <em>w3cvalidator</em> erabiltzaile-izeneko erabiltzaile berria sortu behar izatea, baita gonbidatuentzako sarbidea gaitu behar izatea ere. Aldaketa horiek baimenik gabeko sarbidea gai lezaketenez, ez aplikatu lanean ari diren guneetan!';
$string['configdefaulthomepage'] = 'Honek zehazten du identifikatutako erabiltzaileentzako nabigazioko lehen esteka.';
$string['configdefaultrequestcategory'] = 'Erabiltzaileek eskatutako ikastaroak kategoria honetan kokatuko dira automatikoki.';
$string['configdefaultrequestedcategory'] = 'Eskatutako ikastaroak barneratuko dituen lehenetsitako kategoria, onartuak izatekotan.';
$string['configdefaultuserroleid'] = 'Hemen, gune-mailan, zehazten duzun rolaren gaitasunak emango zaizkie autentifikatutako erabiltzaile guztiei, izan ditzaketen beste rolez GAIN. Lehenetsitako rola Bisitaria da. Honek gainontzeko rolekin ez du arazorik sortuko dituzten gaitasunak ukatzen ez badituzu, erabiltzaile guztiek gunean zerbait erabilgarri egin dezaketela baino ez du ziurtatzen (besteak beste, blogetako sarrerak, norbere egutegia kudeatzea, e.a.)';
$string['configdeleteincompleteusers'] = 'Tarte honen ondoren, izena, abizena eta helbide elektronikoa beteta ez duten kontuak ezabatuak izango dira.';
$string['configdeleteunconfirmed'] = 'Autentifikazio-mota konkretu batzuetan, hala nola posta elektronikoan oinarritutako auto-erregistroan, erabiltzaileek denbora-epe batean euren kontuak baieztatu behar dituzte. Denbora-epea horren ondoren, baieztatu gabeko kontu zahar guztiak ezabatuko dira.';
$string['configdenyemailaddresses'] = 'Domeinu batzuen helbide elektronikoak ukatzeko, idatzi hemen horien zerrenda. Beste domeinu guztiak onartu egingo dira. Gehitu ezazu aurretik \'.\' azpidomeinuak debekatu nahi badituzu. Adibidez, <strong>adibidea.eus .bestebat.eus</strong>';
$string['configdisableuserimages'] = 'Desgaitu erabiltzaileek beren profiletako irudiak aldatzeko aukera.';
$string['configdisplayloginfailures'] = 'Aukera honek erabiltzaileei huts egindako aurreko sarrerei buruzko informazioa erakutsiko die.';
$string['configdndallowtextandlinks'] = 'Gaitu edo desgaitu testu eta fitxategiak hartu eta eramatea, baita ikastaroko orrietako estekak ere. Ohar zaitez testu hartu eta Firefox-era eramatea edo nabigatzaileen artean egitea ez dela fidagarria. Hortaz, baliteke daturik ez igotzea edo testu akastuna igotzea.';
$string['configdoclang'] = 'Hizkuntza hau dokumentazio-orrietarako esteketan erabiliko da.';
$string['configdocroot'] = 'Orri-oineko \'Moodle Doc-ak orri honetarako\' esteken bidezko Moodle Doc-etako testuinguru zehatzetarako bidea definitzen du. Eremu hau hutsik utziz gero, estekak ez dira erakutsiko.';
$string['configdoctonewwindow'] = 'Hau aukeratuz gero, Moodle Doc-etarako estekak leiho berrian erakutsiko dira.';
$string['configeditordictionary'] = 'Balio hau erabiliko da zuzentzaile ortografikoak erabiltzaileen hizkuntzako hiztegia ez baldin badu.';
$string['configeditorfontlist'] = 'Aukeratu editorearen menuaren zerrendan agertuko diren letra-motak.';
$string['configemailchangeconfirmation'] = 'Behartu posta elektroniko bidezko baieztatzea erabiltzaileek profiletan helbide elektronikoa aldatzen dutenean.';
$string['configemailfromvia'] = 'Gehitu igorlearen informazioa bidalitako e-mailen igorlearen atalean. Horrek mezua nork bidali zuen jakinarazten dio jasotzaileari eta ustekabean ez-erantzuteko posta-helbidera erantzutea eragozten du.';
$string['configenableactivitychooser'] = 'Jarduera-hautagailua jarduera eta baliabide bakoitzaren deskribapen laburreko testu-koadroa da. Desgaituz gero, baliabide- eta jarduera-menu zabalgarri independienteak eskainiko dira.';
$string['configenableblogs'] = 'Ezarpen honek guneko erabiltzaile guztiei bloga izateko modua ematen die.';
$string['configenablecalendarexport'] = 'Gaitu egutegiak esportatzea eta harpidetzea.';
$string['configenablecomments'] = 'Gaitu iruzkinak';
$string['configenablecourserequests'] = 'Edozein erabiltzailek ikastaro bat sortzeko eska dezala ahalbidetzen du.';
$string['configenabledevicedetection'] = 'Ezarpen hau gaitzeak telefono mugikorrak, smartphone-ak, tabletak edo bestelako gailuak (mahai-gaineko ordenagailuak, ordenagailu eramangarriak, e.a.) atzematea baimentzen du, itxura edo beste ezaugarri batzuk aplikatu ahal izateko.';
$string['configenablemobilewebservice'] = 'Gaitu zerbitzu mugikorra Moodleren app ofizialerako edo eska dezaketen beste aplikazio baterako. Informazio gehiagorako, irakurri {$a}';
$string['configenablerssfeeds'] = 'Gaituz gero, guneko hainbat funtzionalitatek RSS jarioak sortuko dituzte, besteak beste, blog, foro, datu-base jarduera eta glosarioek. Kontuan izan modulu bakoitzean ere RSS jarioak aktibatu behar direla.';
$string['configenablerssfeedsdisabled'] = 'Ez dago eskuragarri RSS kanalak gune osoan desaktibatuta daudelako. Aktibatzeko, Aldagaietara joan Admin - Konfigurazioan.';
$string['configenablerssfeedsdisabled2'] = 'RSS jarioak ez daude gaituta gunearen mailan. Gunearen kudeaketako Funtzio Aurreratuak aukeran gaitu ahal dira.';
$string['configenablesafebrowserintegration'] = 'Ezarpen honek \'Behartu Safe Exam Browser erabiltzera\' aukera gehitzen du galdetegiaren ezarpen-formularioko \'Nabigatzailearen segurtasuna\' atalean. Ikusi https://www.safeexambrowser.org/ informazio gehiagorako.';
$string['configenablestats'] = '\'Bai\' aukeratuz gero, Moodleko cronjoba erregistroak prozesatu eta estatistika batzuk bilduko ditu. Gunearen trafikoaren arabera, operazio hau luza daiteke. Aukera hau hartuz gero, zure ikastaroen grafiko eta estatistika interesgarri batzuk ikusi ahal izango dituzu, edo gune osoari buruzkoak.';
$string['configenabletrusttext'] = 'Modu lehenetsian, Moodlek erabiltzaileek idatzitako testua sakon garbituko du segurtasunerako arrisku izan daitekeen edozein \'script\', media e.a. ezabatzeko. Konfiantzazko Edukiaren sistemarekin zure konfiantza duten erabiltzaile jakinei edukietan ezaugarri aurreratu horiek sartzeko baimena ematen diezu, interferentziarik gabe. Sistema gaitzeko, ezarpen hau gaitu behar duzu lehenik eta ondoren Konfiantzazko Eduki baimena eman Moodleren rol zehatz bati. Erabiltzaile horiek sortu edo igotako testuak konfiantzazko gisa markatuko dira eta ez dira garbiketa prozesutik pasako erakutsi aurretik.';
$string['configenablewebservices'] = 'Web-zerbitzuak aukera ematen die beste sistema batzuei Moodle honetan identifikatu eta bertan eragiteko. Segurtasunerako, aukera hau desgaitu egin behar da benetan erabiltzen ari ez bazara.';
$string['configenablewsdocumentation'] = 'Gaitu web-zerbitzuen dokumentazioa automatikoki sortzea. Erabiltzaileak bere dokumentaziora sarbidea {$a} bere segurtasun-kodeen orrian dauka. Horrek gaitu diren protokoloen dokumentazioa soilik erakusten ditu.';
$string['configerrorlevel'] = 'Aukeratu erakustsi nahi duzun PHP abisu-kopurua. Aukera onena \'Arrunta\' izan ohi da.';
$string['configexportlookahead'] = 'Aurrera begiratzeko egunak esportazioa izan bitartean';
$string['configexportlookback'] = 'Atzera begiratzeko egunak esportazioa izan bitartean';
$string['configextendedusernamechars'] = 'Aukera honek ikasleek beren erabiltzaile-izenetan edozein karaktere erabiltzea ahalbidetzen du (honek benetako izenetan eraginik ez daukala ohar zaitez). Lehenetsikako balioa "false" da eta  erabiltzaile-izenak balio hauetara mugatzen du: letra xeheak, zenbakiak, beheko gidoia (_), gidoia (-), puntua (.) eta a bildua (@).';
$string['configextramemorylimit'] = 'Bilatu, segurtasun-kopia/berreskuratu edo cron-ak bezalako script-ek memoria handiagoa behar dute. Gune handietarako ezarri balio handiagoak.';
$string['configfilterall'] = 'Iragazi kate guztiak, goiburu, izenburu, nabigazio-barrak, etab. barne. Hau bereziki erabilgarria izan daiteke iragazki eleanitzarekin; bestela, gunean karga handia ezarriko du etekin gutxi lortzeko.';
$string['configfiltermatchoneperpage'] = 'Esteka automatikoaren iragazkiek esteka bakarra sortuko dute orri osoan aurkituko den lehenengo testu-adibide egokiarekiko, beste guztia alde batera utziz.';
$string['configfiltermatchonepertext'] = 'Esteka automatikoaren iragazkiek esteka bakarra sortuko dute orriko testu-elementu bakoitzean (ad. baliabidea, blokea...) aurkituko den lehenengo testu-adibide egokiarekiko, beste guztia alde batera utziz. Ezarpen hau ez da kontuan hartuko orriko ezarpen bakarra <i>bai</i> baldin bada.';
$string['configfilteruploadedfiles'] = 'Aukera honek Moodlek igotako HTML eta testu-fitxategi guztiak erakutsi aurretik iragazkiekin prozesatzea ahalbidetzen du.';
$string['configforcelogin'] = 'Normalean gunearen orri nagusia eta ikastaroen zerrenda (baina ikastaroak ez) edonork irakur ditzake bere erabiltzaile-izena eta pasahitza idatzi beharrik gabe. Bisitariek EZEIN EDUKIRIK ikusi aurretik gunera pasahitzez sartzera behartu nahi badituzu, aukera hau aktibatu beharko duzu.';
$string['configforceloginforprofiles'] = 'Aukera honek gunera kontu baliagarrien bidez sartzera behartzen du (bisitari gisa ez) erabiltzaile-profilen orria ikusi aurretik. Ezarpen hau ezgaitzen baduzu, gerta daiteke erabiltzaile batzuk iragarkiak (spam) edo eduki ezegokiak argitaratzea bere profiletan eta edonorentzat ikusgai geratuko lirateke.';
$string['configfrontpage'] = 'Aukeratutako elementuak gunearen hasiera-orrian erakutsiko dira.';
$string['configfrontpagecourselimit'] = 'Gehienezko ikastaro-kopurua';
$string['configfrontpagecourselimithelp'] = 'Ikastaroak zerrendatzean, gunearen hasiera-orrian erakutsiko den gehienezko ikastaro-kopurua.';
$string['configfrontpageloggedin'] = 'Aukeratutako elementuak gunearen hasiera-orrian erakutsiko dira erabiltzailea autentifikatzen denean.';
$string['configfullnamedisplay'] = 'Aukera honek izenak osorik erakustean nola ikusiko diren definitzen du. Balio lehenetsiak, "language", erakutsi beharrekoa hizkuntza pakete bakoitzaren "fullnamedisplay" katearen menpe uzten du. Hizkuntza batzuek izenak erakusteko arau ezberdinak dituzte.

Hizkuntza bakarra erabiltzen duten gune gehienek lehenetsitako balioa mantentzea aholkatzen da: ("Izena + Abizena"), baina abizena ezkutatzea erabaki dezakezu. Erabili daitezken gakoak hauek dira: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, and alternatename.';
$string['configgeoipfile'] = 'GeoLite2 City fitxategi bitarraren kokapena. Fitxategi hau ez dator Moodleren pakete estandarrean eta aparte lortu behar da hemen: <a href="https://www.maxmind.com/">MaxMind</a>. Bertsio komertziala nahiz doakoa dituzu eskura. Erregistratu beharko duzu City datu-basea hurrengo estekatik jaitsi ahal izateko: <a href="https://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz" >https://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz</a>. Behin erregistratuta eta fitxategia jaitsita, zure zerbitzariaren "{$a}" direktorioan erauzi ezazu.';
$string['configgetremoteaddrconf'] = 'Zure zerbitzaria \'reverse proxy\' baten atzean badago aukera hau erabil dezakezu urrutiko IP helbidea duten zein HTTP goibururekin fidatu daitekeen zehazteko. Goiburuak ordenean irakurriko dira eta eskuragarri dagoen lehenengoa erabiliko da.';
$string['configgradebookroles'] = 'Ezarpen honek kalifikazio-liburuan nor agertuko den kontrolatzen utziko dizu. Erabiltzaileek hauetako rolen bat izan behar dute gutxienez ikastaro batean ikastaro horretako kalifikazio-liburuan agertzeko.';
$string['configgradeexport'] = 'Aukeratu kalifikazio-liburua esportatzeko zein formatu izango den kalifikazioak esportatzeko metodo nagusia. Aukeratutako lokailuek eremu bat (\'esporatutako azkenak\') erabiliko dute kalifikazio bakoitzerako. Adibidez, honen ondorioz esportatutako erregistroak "berriak" edo "eguneratuta" gisa identifikatuko dira. Hau nola egin ez badakizu, ez markatu ezer.';
$string['confighiddenuserfields'] = 'Aukeratu irakasle eta kudeatzaileak ez diren ikastaroko erabiltzaileei zer erabiltzaile-eremuren informazioa ezkutatu nahi diezun, ikasleen pribatutasuna handitzeko. CTRL sakatuta mantendu eremu batzuk aukeratzeko.';
$string['configidnumber'] = 'Aukera honek zehazten du ea (a) Erabiltzaileei ID zenbakia ez zaien eskatzen, (b) ID zenbakia eskatu, baina hutsik utz dezaketen edo (c) ID zenbakia eskatu eta ezin duten hutsik utzi. Baiezko kasuan, erabiltzailearen ID zenbakia bere profilean erakusten da.';
$string['configintro'] = 'Orri honetan Moodlek zure zerbitzarian modu egokian lan egiten laguntzen duten aldagai-kopuru bat zehatz dezakezu. Horrek ez zaitu gehiegi kezkatu behar: lehenetsitako balioek ondo funtzionatuko dute eta, hala ere, orri honetara nahi duzunean itzul zaitezke ezarpenak aldatzeko.';
$string['configintroadmin'] = 'Orri honetan kudeatzaile nagusiaren kontua konfiguratu beharko zenuke -horrek gunearen erabateko kontrola emango baitizu-. Ziurtatu ezazu erabiltzaile-izen eta pasahitz seguruak erabiltzen dituzula, bai eta zure helbide elektronikoa baliagarria dela ere. Aurrerago kudeatzaile-kontu gehiago sortu ahal izango dituzu.';
$string['configintrosite'] = 'Orri honek orri nagusia konfiguratzen eta zure gune berriari izena ematen ahalbidetzen dizu. Beranduago itzul zaitezke zerbait aldatzera orri nagusiko \'Gunearen kudeaketa\' menuaren bitartez.';
$string['configiplookup'] = 'IP helbidean klik egiten duzunean (adib. 34.12.222.93), erregistroetan egiten denaren antzera, IP hori ahalik eta zehatzen kokatuko zaizu mapan. Hori egiteko, hainbat pluginen artean aukeratu dezakezu. Bakoitzak bere abantailak eta desabantailak ditu.';
$string['configkeeptagnamecase'] = 'Markatu hau etiketen izenek jatorrizko \'casing\'-a mantentzea  nahi baduzu, sortu zuten erabiltzaileek sartutako bezala';
$string['configlang'] = 'Aukeratu gune osoan lehenetsitako hizkuntza. Erabiltzaileek ezarpen hau aldatu dezakete hizkuntza-menua edo euren profileko ezarpena erabilita.';
$string['configlanglist'] = 'Erabiltzaileek Moodle-ren instalazioan dagoen edozein hizkuntza aukeratzeko hau hutsik utzi dezakezu. Hala ere, menua laburbildu daiteke komaz banatutako nahi dituzun hizkuntzen kodeen zerrenda idatziz. Adibidez, eu,fr,it,en,es';
$string['configlangmenu'] = 'Erabaki hizkuntza aukeratzeko menua orri nagusian, hasiera-orrian, sarbide-orrian, etab. erakutsi nahi duzun. Horrek ez du oztopatzen erabiltzaileek beren profilean nahi duten hizkuntza lehenesteko.';
$string['configlangstringcache'] = 'Hizkuntza-kateak datu-direktorioko fitxategi konpilatutan gordetzen ditu. Moodle itzultzen edo iturburu kodearen kateak aldatzen ari bazara, aukera hau desgaitu dezakezu. Bestela, utz ezazu gaituta errendimenduaren onurak nabaritzeko.';
$string['configlatinexcelexport'] = 'Aukeratu kodifikazioa Excel formatuko esportazioetarako.';
$string['configlocale'] = 'Aukeratu gunearen kokapena (honek hizkuntzaren formatan eta datetan eragina izango du). Datu horiek zure sistema eragilean ere instalatuta egon behar dute (ad., en_US.UTF-8 edo es_ES.UTF-8). Zalantzan bazaude, hutsik utzi.';
$string['configloginhttps'] = 'Aukera honek Moodle-ri sarbide-orrian https konexio segurua erabilarazten dio (sarbide segurua ziurtatzen) URL http arruntera itzultzeko. KONTUZ: aukera honek https zure zerbitzarian indarrean egotea behar du. Bestela, ZU ZEU EZINGO ZARA GUNERA SARTU.';
$string['configloglifetime'] = 'Aukera honek zehazten du erabiltzaile bakoitzaren jarduera-erregistroak noiz arte gorde nahi dituzun. Aurreko erregistro guztiak ezabatuko dira. Hobe da epe luzean gordetzea (badaezpada behar dituzun) baina zerbitzaria oso lanpetuta balitz eta funtzionamendu arazoak baleude, epea laburtzea komenigarria izan liteke. Ez dira gomendatzen 30 azpiko balioak estatistiken funtzionamendu egokian eragin dezaketelako.';
$string['configlookahead'] = 'Aurreikusitako egunak';
$string['configmailnewline'] = 'E-mailetan erabilitako karaktere berriak. RFC 822bis-en arabera, CRLF beharrezkoa da; zenbait zerbitzarik automatikoki bihurtzen dute LF-tik CRLF-ra, beste batzuk modu ezegokian bihurtzen dute CRLF-tik CRCRLF-ra eta, azkenik, beste batzuk (qmail, kasu) LF hutsa duten mezuak baztertu egiten dituzte. Saiatu ezarpen hau aldatzen entregatu gabeko edo lerro bikoitz berriak dituzten e-mailekin arazoak badituzu.';
$string['configmaxbytes'] = 'Aukera honek gunera igotako fitxategien gehienezko tamaina zehazten du. Ezarpen hau PHP post_max_size upload_max_filesize ezarpenek eta Apacheko LimitRequestBody ezarpenak mugatzen dute. Beste aldetik, aukera honek ikastaro eta moduluetan zehaztu daitezkeen tamainen tartea ere mugatzen du. \'Gunearen igoera-muga\' aukera hautatzen bada, zerbitzariak baimendutako gehienezko tamaina erabiliko da.';
$string['configmaxconsecutiveidentchars'] = 'Pasahitzak ezin ditu jarrian zenbaki honek adierazten duen kopurua baino karaktere berdin gehiago izan. Erabili 0 hau ekiditeko.';
$string['configmaxeditingtime'] = 'Aukera honek zehazten du erabiltzaileen epea foroetara bidalitako mezuak editatzeko, egunkariaren feed-backa, etab. Normalean 30 minutu epe egokia izaten da.';
$string['configmaxevents'] = 'Aurreikusitako ekitaldiak';
$string['configmaxusersperpage'] = 'Guneko hasiera-orrian erabiltzaile-hautatzailean erakutsiko den gehienezko erabiltzaile-kopura ikastaroetan, kohorteetan, web-zerbitzuetan eta abarrean.';
$string['configmessaging'] = 'Gaituz gero, zure guneko erabiltzaileek beste erabiltzaileei mezuak bidaltzeko aukera izango dute.';
$string['configmessagingallowemailoverride'] = 'Baimendu erabiltzaileei beren profilean duten helbide elektronikoa ez den beste helbide elektroniko batera bidalitako mezuen jakinarazpenak jasotzea';
$string['configmessagingallusers'] = 'Gaituz gero, erabiltzaileek guneko erabiltzaile guztien zerrenda ikus dezakete mezua bidaltzeko norbait aukeratzean, eta mezuetarako beren lehentasunek guneko edonoren mezuak onartzeko aukera edukiko dute.
Desgaituz gero, erabiltzaileek beren ikastaroetako erabiltzaileen zerrenda ikus dezakete, eta mezuetarako lehentasunetan bi aukera daude: beren kontaktuen mezuak soilik onartzea edo ikastaroetako edonoren mezuak.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Espazioa irabaztearren, irakurritako nahiz irakurri gabeko jakinarazpenak ezaba daitezke. Jakinarazpenak ezabatu baino lehen zer denbora-epetan mantendu behar dira?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Irakurritako jakinarazpenak ezaba daitezke espazioa aurrezteko. Irakurri ondoren, zenbat denbora pasatu behar da ezabatzeko?';
$string['configminpassworddigits'] = 'Pasahitzek gutxienez zenbaki-kopuru hau izan behar dute';
$string['configminpasswordlength'] = 'Pasahitzek gutxienez karaktere-kopuru hau izan behar dute';
$string['configminpasswordlower'] = 'Pasahitzek gutxienez letra xeheen kopuru hau izan behar dute.';
$string['configminpasswordnonalphanum'] = 'Pasahitzek gutxienez karaktere alfanumerikoen kopuru hau izan behar dute';
$string['configminpasswordupper'] = 'Pasahitzek gutxienez letra larrien kopuru hau izan behar dute.';
$string['configmodchooserdefault'] = 'Jarduera-hautatzailea modu lehenetsian erakutsi behar litzaieke erabiltzaileei?';
$string['configmycoursesperpage'] = 'Erabiltzaile baten ikastaroen zerrendan erakutsiko den gehienezko ikastaro kopurua.';
$string['configmymoodleredirect'] = 'Aukera honek kudeatzaileak ez direnak sartzean /my-ra bideratzen ditu gunearen nabigazio orokorra /my-rekin ordezkatzen du.';
$string['configmypagelocked'] = 'Ezarpen honek orri lehenetsia babestu egiten du kudeatzaile ez den inork edita ez dezan';
$string['confignavcourselimit'] = 'Erabiltzaileari erakutsiko zaion ikastaro-kopurua nabigazioan.';
$string['confignavshowallcourses'] = 'Ezarpen honek ikastaroetan matrikulatutako erabiltzaileei Ikastaroak (ikastaro guztien zerrenda) esteka nabigazio-barran azalduko zaien zehazten du, Nire Ikastaroak (matrikulatutako ikastaroen zerrenda) estekaz gain.';
$string['confignavshowcategories'] = 'Erakutsi ikastaro-kategoriak nabigazio-barran eta nabigazio-blokeetan. Ikaslea matrikulatuta dagoen ikastaroetan ez du eraginik, eta horrela \'Nire ikastaroak\' zerrendan agertuko dira kategoriarik gabe.';
$string['confignoreplyaddress'] = 'Batzuetan e-mailak erabiltzailearen izenean bidaltzen dira (ad., foro bateko mezuak). Hemen zehazten duzun helbide elektronikoa "Igorlea" gisa azalduko da jasotzaileek zuzenean erantzuteko aukera ez duten kasuetan (ad., erabiltzaileak bere helbidea ezkutatu nahi duenean). Ezarpen hau e-mailaren bidaltzaile gisa ere erabiliko da.';
$string['confignotifyloginfailures'] = 'Bidali saio-hasiera saiakera okerren jakinarazpen-mezuak aukeratutako erabiltzaileei. Horretarako, barne erregistro gordailu bat gaituta egon behar du (adib: Standard Logstore).';
$string['confignotifyloginthreshold'] = 'Sarbide saiakera okerren oharrak aktibatuta badaude, zenbat saiakera oker beharko da erabiltzaileari edo IP helbide bati oharra bidaltzeko?';
$string['confignotloggedinroleid'] = 'Gunean autentifikatu gabeko erabiltzaileak gunearen testuinguruan rol hau izango balute bezala arituko dira. \'Bisitaria\' zuk nahi duzuna da hemen, baina agian rol mugatzaileagoak sortu nahiko dituzu. Mezuak bidaltzea bezalako kontuek erabiltzailea behar bezala autentifika dadin eskatzen dute.';
$string['configopentogoogle'] = 'Aukera hau aktibatuz gero, Google gunera gonbidatu gisa sartu ahal izango da. Horrez gain, Google-ren bilaketaren bitartez gunera sartzen denak zuzenean gonbidatu gisa egingo du. Aukera honek sarrera zuzena soilik ematen du gonbidatuak onartzen dituzten ikastaroetara.';
$string['configoverride'] = 'config.php-n definituta';
$string['configpasswordpolicy'] = 'Aukera hau gaituz gero, erabiltzaileen pasahitzak alderatuko dira pasahitzen baliozkotasunerako beheko zehaztapenekin. Pasahitzen politikak ez du eraginik izango erabiltzaileengan pasahitza aldatzea erabakitzen ez badute, edo eskatzen ez bazaie.';
$string['configpasswordresettime'] = 'Honek pasahitz baten berrabiaraztea iraungi aurretik balioesteko epea zehazten du. Normalean epe egokia 30 minutu izan daiteke.';
$string['configpathtodu'] = 'Du-rako bidea. Seguru asko honako zerbait: /usr/bin/du. Hori idazten baduzu, direktorioaren edukia erakusten duten orriak askoz azkarrago exekutatuko dira karpetek fitxategi asko dauzkatenean.';
$string['configpathtophp'] = 'PHP CLI-rako bidea. Seguru asko /usr/bin/php antzeko zerbait. Hori sartuz gero, cron script-ak web-kudeaketako interfazetik exekutatu ahal izango da.';
$string['configperfdebug'] = 'Aukera hau aktibatuz gero, itxura estandarreko orri-oinean errendimenduaren informazioa azalduko da.';
$string['configprofileroles'] = 'Erabiltzaile-profiletan eta partaidetza-orrian ikusten den rol-zerrenda';
$string['configprofilesforenrolledusersonly'] = 'Spam sortzaileen gehiegikeriari aurre egiteko, inongo ikastarotan matrikula egin ez duten erabiltzaileen profilen deskribapenak ezkutatu egiten dira. Erabiltzaile berriek gutxienez ikastaro batean matrikulatu behar dute profilaren deskribapena gehitu ahal izateko.';
$string['configprotectusernames'] = 'Gaituz gero, ahaztutako pasahitzaren formularioan ez da erakutsiko erabiltzaile-kontuak edo helbide elektronikoak asmatzeko aukera eman dezakeen inolako pistarik.';
$string['configproxybypass'] = 'Proxy-a ekidin beharko luketen ostalari-izen edo IP-en (zati) zerrenda, komaz banatuta (adib., 192.168., .niredomeinua.com)';
$string['configproxyhost'] = '<b>Zerbitzari</b> honek Internetera sartzeko proxy bat behar badu (ad., firewall bat), proxya eta portuaren zenbakia hemen idatzi. Bestela, hutsik utzi.';
$string['configproxypassword'] = 'Internetera proxy bidez sartzeko behar den pasahitza; horrela ez bada, utz ezazu hutsik (beharrezkoa da PHP cURL hedapena).';
$string['configproxyport'] = 'Zerbitzari honek proxy-ordenagailua behar badu, idatzi hemen proxyaren portua.';
$string['configproxytype'] = 'Web proxy mota (PHP5 eta cURL hedapena behar dira SOCKS5 euskarrirako)';
$string['configproxyuser'] = 'Internetera proxy-ren bidez sartzeko behar den erabiltzaile-izena; bestela, zuri utzi (PHP cURL hedapena behar da).';
$string['configrecaptchaprivatekey'] = 'Zure Moodle zerbitzariaren eta recaptcha zerbitzariaren arteko komunikatzeko erabilitako karaktere-katea (gako pribatua). ReCAPTCHA gakoak <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a> helbidetik eskura daitezke.';
$string['configrecaptchapublickey'] = 'Izena emateko formularioan reCAPTCHA elementua erakusteko karaktere-multzoa (giltza publikoa). ReCAPTCHA giltzak <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a> gunean lor daitezke.';
$string['configrequestcategoryselection'] = 'Baimendu kategoria aukeratzen ikastaro-eskaria egiten denean.';
$string['configrequestedstudentname'] = 'Eskatutako ikastaroetan \'ikaslea\' izendatzeko erabilitako hitza';
$string['configrequestedstudentsname'] = 'Eskatutako ikastaroetan  \'ikasleak\' izendatzeko erabilitako hitza';
$string['configrequestedteachername'] = 'Eskatutako ikastaroetan  \'irakaslea\' izendatzeko erabilitako hitza';
$string['configrequestedteachersname'] = 'Eskatutako ikastaroetan  \'irakasleak\' izendatzeko erabilitako hitza';
$string['configreverseproxyignore'] = 'Zure zerbitzaria X-Forwarded-For goiburua gehitzen duten alderantzizko proxy anitzen atzean badago erabiltzaileen benetako IP helbidea aurkitu ahal izateko komaz banatutako ezikusi beharreko alderantzizko proxy-en IP helbide edo azpisareen zerrenda zehaztu beharko duzu.';
$string['configsectioninterface'] = 'Interfazea';
$string['configsectionmail'] = 'Posta';
$string['configsectionmaintenance'] = 'Mantenua';
$string['configsectionmisc'] = 'Bestelakoak';
$string['configsectionoperatingsystem'] = 'Sistema eragilea';
$string['configsectionpermissions'] = 'Baimenak';
$string['configsectionrequestedcourse'] = 'Ikastaro-eskariak';
$string['configsectionsecurity'] = 'Segurtasuna';
$string['configsectionstats'] = 'Estatistikak';
$string['configsectionuser'] = 'Erabiltzailea';
$string['configsecureforms'] = 'Moodlek segurtasun-maila altuagoa erabil dezake web formularioetako datuak onartzen dituenean. Aukera aktibatuz gero, nabigatzailearen HTTP_REFERER formularioaren helbidearekin konparatuko da. Honek oso kasu gutxitan emango ditu erroreak erabiltzaileak firewalla badauka (ad., ZoneAlarm) bere HTTP_REFERER web trafikotik aparte izateko. Sintoma formularioan \'trabatuta\' geratzea izaten da. Erabiltzaileek, esaterako, sarbide-orrian arazorik izango balute, agian aukera hau desaktibatzea komeniko litzateke, gunea indar gordineko (brute force) erasoetara irekiago uzteko desabantailarekin. Zalantza kasuan, \'Bai\' aukeratu.';
$string['configsessioncookie'] = 'Aukera honek Moodleko saioetako cookie-aren izena pertsonalizatzen du. Aukerazkoa da, eta praktikoa izaten da soilik zerbitzari berean Moodleko beste kopia bat egikaritzen ari denean cookie-ak nahas daitezkeelako.';
$string['configsessioncookiedomain'] = 'Honek Moodleko cookie-ak hartuko diren domeinua aldatzeko aukera ematen dizu. Erabilgarria da Moodle saioaren informazioa beste azpidomeinu bateko web-aplikazio batekin sarean egotea eskatzen duten pertsonalizazioetarako (adib. autentifikazio edo matrikulatzeko pluginak). <strong>KONTUZ: erabat gomendatzen da ezarpen hau modu lehenetsian datorren bezala uztea (hutsik) - balio ezegoki batek guneko sarbide guztiak galaraziko ditu.</strong>';
$string['configsessioncookiepath'] = 'Nabigatzaileek Moodleren cookie-ak bidaltzen dituzten lekua aldatu beharra baduzu, aukera hau alda dezakezu zure web-gunean azpidirektorio bat zehazteko. Bestela lehenetsitako balioak (\'/\') balioko dizu.';
$string['configsessiontimeout'] = 'Gunean konektatutako erabiltzaileek epe luzean aktibitaterik ez badute (ad., ez badute orririk kargatzen), automatikoki deskonektatuko dira (ad., saioa amaituko da). Aldagai honek deskonektatu baino lehen pasa beharreko aktibitaterik gabeko epea zehazten du.';
$string['configshowcommentscount'] = 'Iruzkin-kopurua erakutsiz gero, beste kontsulta bat egin beharko da iruzkinetarako esteka erakusten denean';
$string['configshowicalsource'] = 'Erakutsi iturburuaren informazioa iCal ekitaldietarako';
$string['configshowsiteparticipantslist'] = 'Guneko ikasle eta irakasle guztiak partaideen zerrendan azalduko dira. Nork ikus dezake zerrenda hori?';
$string['configsitedefaultlicense'] = 'Gunean lehenetsitako lizentzia';
$string['configsitedefaultlicensehelp'] = 'Gune honetan edukia argitaratzeko erabiliko den lehenetsitako lizentzia';
$string['configsitemailcharset'] = 'Ezarpen honek zehazten du lehenetsitako karaktere-multzoa gunetik bidalitako e-mail guztietarako.';
$string['configsitemaxcategorydepth'] = 'Gehienezko kategoria-mailak';
$string['configsitemaxcategorydepthhelp'] = 'Honek zehazten du gehienez zenbat azpiko kategoria erakutsiko den zerrenda moduan erakusteko garaian. Maila sakonagoetan dauden kategoriak esteka moduan agertuko dira eta erabiltzaileak zabaldu ahal izango ditu AJAX eskaeren bitartez.';
$string['configslasharguments'] = 'SCORM paketeak eta fitxategi-anitzeko baliabideak modu egokian erakusteko \'slash arguments\' delakoak erabiltzen dira (<em>PATH_INFO</em> erabilita). Zure zerbitzariak ez baditu \'slash arguments\'-ak onartzen eta konfiguratzeko gai ez bazara, aukera hau desgaitu dezakezu, nahiz eta horrek gauza batzuk ez funtzionatzea suposatuko duen.<br />Oharra: \'slash arguments\'-en erabilera derrigorrezkoa izango da etorkizuneko Moodle bertsioetan.';
$string['configsmartpix'] = 'Aktibatuta, lehenik oraingo itxura, ondoren goragoko itxura guztiak eta ondoren Moodleren /pix karpeta bilatzen duen PHP script baten bitartez ematen dira ikonoak. Horrela, ez da beharrezkoa irudi-fitxategiak behin baino gehiagotan izatea itxuretan, baina errendimendua jaitsi egiten da pixka bat.';
$string['configsmtpauthtype'] = 'Honek smtp zerbitzarian erabiliko den autentifikazio-mota konfiguratzen du.';
$string['configsmtphosts'] = 'Moodlek posta-mezuak bidaltzeko erabiliko duen SMTP zerbitzari lokal bat edo gehiagoren izenak hemen idatzi (ad., \'mail.a.com\' edo \'mail.a.com;mail.b.com\'). Lehenetsitakoa ez den portu bat aukeratzeko (adibidez: 25a ez den bat) [zerbitzaria]:[portua] sintaxia erabili dezakezu (adibidez: \'mail.a.com:587\'). Konexio seguruak egiteko, normalean 465 SSL-arekin erabiltzen da eta 587 TLS-arekin. Behar izanez gero segurtasun protokoloa behian adierazi. Hutsik uzten baduzu, Moodlek posta bidaltzeko lehenetsitako PHP metodoa erabiliko du.';
$string['configsmtpmaxbulk'] = 'SMTP saioko bidalitako gehienezko mezu-kopurua. Mezuak taldekatzeak arindu egin dezake e-mail bidalketa. 2tik beherako balioek e-mail bakoitzeko SMTP saio berria sortarazten dute.';
$string['configsmtpsecure'] = 'smtp zerbitzarian konexio segurua behar badu, ezarri protokolo-mota zuzena.';
$string['configsmtpuser'] = 'Lehenago SMTP zerbitzaria zehaztu baduzu, eta zerbitzariak autentifikazioa behar badu, erabiltzaile-izena eta pasahitza hemen idatzi.';
$string['configstartwday'] = 'Astearen hasiera';
$string['configstatsfirstrun'] = 'Aukera honek zehazten du erregistroak noiztik prozesatu behar diren cronjobak estatistikak prozesatzen dituen <b>lehenengo aldian</b>. Guneak trafiko handia pairatzen badu eta zerbitzaria elkarbanatua bada, seguru asko laster hastea ez ideia ona izango, horrek luze joko duelako eta baliabide asko erabiliko direlako. (Aukera honetan hilabetea 28 egunen baliokidea dela ohartu. Sortutako grafiko eta txostenei dagokienez, aldiz, hilabetea egutegiko hilabetea da).';
$string['configstatsmaxruntime'] = 'Prozesamendu estatistikoa oso astuna izan daitekeenez, eremu hau hurrengoarekin elkartzea komenigarria da noiztik eta noiz arte martxan iraungo duen zehazteko.';
$string['configstatsmaxruntime2'] = 'Estatistika-datuen prozesamendua oso trinkoa izan daiteke. Zehaztu gehienez zenbat denbora utziko den eguneko estatistikak jasotzeko. Kronaren exekuzio batean prozesatutako gehienezko egun kopurura 31 da.';
$string['configstatsmaxruntime3'] = 'Ezarpen honek estatistikak kalkulatzeko eguneko gehienez zenbat denbora utziko den zehazten du, kontuan izanda estatistika-datuen prozesamenduak gainkarga ezartzen diola zerbitzariari. Beherago zehaz daiteke kronean prozesatutako gehienezko egun kopurua.';
$string['configstatsruntimedays'] = 'Ezarpen honek estatistika-datuen azterketa bakoitzean prozesatutako gehienezko egun kopurua zehazten du. Estatistikak eguneratuta daudenean egun bakarra prozesatuko da eta beraz balio hau zure zerbitzariaren kargaren arabera doitu beharko duzu eta gutxitu krona sarriago exekutatu behar bada.';
$string['configstatsruntimestart'] = 'Noiz hasi behar da lanean estatistikak prozesatzen dituen cronjoba? Zerbitzari berean hainbat Moodle baldin badago bakoitzean une ezberdinak zehaztea gomendatzen da.';
$string['configstatsuserthreshold'] = 'Ezarpen honek zehazten du gutxienez zenbat erabiltzaile izan behar dituen matrikulatuta ikastaro batek estatistiken kalkuluan sartzeko.';
$string['configstrictformsrequired'] = 'Gaituz gero, erabiltzaileek ezin izango dute zuriunerik edo lerro-jauzia sartu formularioen derrigorrezko eremuetan.';
$string['configstripalltitletags'] = 'Desmarkatu aukera hau HTML etiketa eta baliabide-izenetan baimentzeko.';
$string['configsupportemail'] = 'Helbide elektroniko hau guneko erabiltzaileei eskainiko zaie laguntza orokorra behar badute bertara e-maila idazteko (adibidez, erabiltzaile batek bere kontua sortzen duenean). Hutsik utziz gero, ez da helbide elektronikorik aipatuko laguntzarako.';
$string['configsupportname'] = 'Hau da posta elektroniko edo webgune bidez laguntza orokorra eskaintzen duen pertsona edo beste erakunde baten izena.';
$string['configsupportpage'] = 'Helbide elektroniko hau guneko erabiltzaileentzat argitaratuko da, laguntza orokorra behar dutenean erabiltzeko (adibidez, erabiltzaile berri batek bere kontua sortzen duenea). Hutsik utziz gero, ez da dagokion esteka agertuko.';
$string['configtempdatafoldercleanup'] = 'Ezabatu aukeratutako data baino lehenagokoak diren datu-karpetako aldi baterako datuen fitxategiak';
$string['configthemedesignermode'] = 'Normalean itxuraren irudi eta estilo-orri guztiak nabigatzaileen cache-an epe luzez gordetzen dira, errendimendu arrazoiak direla-eta. Itxurak edo kodea garatzen ari bazara ziurrenik modu hau desgaitu nahiko duzu cache-an dauden  bertsioak ez erabiltzeko. Kontuz: honek zure gunea erabiltzaile guztientzat motelduko du! Bestela, itxuraren cache-ak eskuz berrabiarazi ditzakezu Itxura-hautatzailea orritik.';
$string['configthemelist'] = 'Aukera hau hutsik utzi baliozko edozein itxuraren erabilera baimentzeko. Itxuren menua laburbildu nahi baduzu, komaz banatutako izenbururen zerrenda adieraz dezakezu (Ez utzi tarterik!). Adibidez: standard,orangewhite';
$string['configtimezone'] = 'Hau datak erakusteko lehenetsitako ordu eremua da - erabiltzaileek beren profiletan alda dezakete. Cron zereginak eta bestelako zerbitzariko ezarpenak ordu eremu honetan konfiguratzen dira. Ezarpen hau aldatu beharko zenuke "Ordu eremu baliogabea" erakusten badu.';
$string['configuseblogassociations'] = 'Aukera izan behar al dute erabiltzaileek euren blog-a antolatzeko sarrerak ikastaroekin eta ikastaro-moduluekin lotuta?';
$string['configuseexternalyui'] = 'Fitxategi lokalak erabili beharrean, erabili Yahoo-ren zerbitzarietako eskuragarri dauden fitxategitak. KONTUZ: ezarpen honek Interneterako konexioa behar du; bestela, AJAX ez da ibiliko zure gunean. Ezarpen hau ez da https erabiltzen duten guneekin bateragarria.';
$string['configuserquota'] = 'Erabiltzaileak bere fitxategi-pribatu eremuan gorde ahal duen gehinezko byte kopurua. {$a->bytes} byt == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Gaituz gero nabigazioan gunearen izen laburra erabiliko da guneko orrien nodo gisa, \'Guneko orriak\' katearen ordez';
$string['configusetags'] = 'Webgunean zehar etiketen funtzionalitatea gaitu nahi al duzu?';
$string['configvariables'] = 'Aldagaiak';
$string['configverifychangedemail'] = 'Aldatutako helbide elektronikoak baimendutako eta ukatutako posta elektronikoko domeinuak erabilita egiaztatzea gaitzen du. Gaitu gabe badago, domeinuak soilik erabiltzaile berriak sortzean derrigortuko dira.';
$string['configvisiblecourses'] = 'Erakutsi ezkutuko kategorietako ikastaroak';
$string['configwarning'] = 'Emaitza hauek aldatzerakoan kontuz ibili (balio bitxiek arazoak sor ditzakete).';
$string['configyuicomboloading'] = 'Aukera honek YUI liburutegiaren optimizaziorako fitxategi-konbinaketa gaitzen du. Ezarpen hau lanean ari diren guneetan gaituta egon beharko litzateke errendimendu arrazoiak direla-eta.';
$string['confirmation'] = 'Baieztatzea';
$string['confirmcontextlock'] = '{$a->contextname} ez dago izoztuta. Izoztuz gero, soilik irakurtzeko baimena izango du eta, hortaz, erabiltzaileek ezingo dute aldatu. Ziur zaude aurrera egin nahi duzula?';
$string['confirmcontextunlock'] = '{$a->contextname} izoztuta dago. Desizoztuz gero, erabiltzaileek aldatu ahal izango dute. Ziur zaude aurrera egin nahi duzula?';
$string['confirmdeletecomments'] = 'Iruzkinak ezabatzeko zorian zaude, ziur zaude?';
$string['confirmed'] = 'Baieztatutakoak';
$string['contextlockappliestoadmin'] = 'Testuinguruaren izoztea kudeatzaileei aplikatzen zaie';
$string['contextlockappliestoadmin_desc'] = 'Desgaituz gero, kudeatzaileek  izoztutako edozein testuingurutan idazteko baimena mantentzen dute';
$string['contextlocking'] = 'Testuinguruen izoztea';
$string['contextlocking_desc'] = 'Ezarpen honek aukeratutako kategoria, ikastaro, jarduera edo blokeetan soilik irakurtzeko baimena egoztea ahalbidetzen du.';
$string['cookiehttponly'] = 'HTTP cookie-ak baino ez';
$string['cookiesecure'] = 'Cookie seguruak baino ez';
$string['country'] = 'Lehenetsitako herrialdea';
$string['coursecontact'] = 'Ikastaroko kontaktuak';
$string['coursecontact_desc'] = 'Honek aukera ematen dizu ikastaroaren deskribapenean nor agertuko den kontrolatzeko. erabiltzaileek gutxienez hauetako rolen bat izan behar dute ikastaroan beronen deskribapenean agertzeko.';
$string['coursecontactduplicates'] = 'Erakutsi ikastaroko kontaktuen rol guztiak';
$string['coursecontactduplicates_desc'] = 'Gaituz gero, aukeratutako ikastaroan rol bat baino gehiago duten erabiltzaileak ikastaro-deskribapenean dagozkien rol guztiekin azalduko dira. Bestela, baimen bakar batekin azalduko dira (gunearen kudeaketako \'Definitu baimenak\' ataleko zerrendako goiena, alegia).';
$string['coursegraceperiodafter'] = 'Graziazko epea iraganeko ikastaroetarako';
$string['coursegraceperiodbefore'] = 'Graziazko epea etorkizuneko ikastaroetarako';
$string['courselistshortnames'] = 'Erakutsi ikastaroen izen luzeak';
$string['courselistshortnames_desc'] = 'Gaituz gero, ikastaro-zerrendetan ikastaroen izen laburrak erakutsiko dira izen osoarekin batera. Behar izanez gero, ikastaroen izen luzeak pertsonalizatu daitezke Hizkuntzen pertsonalizazioa aukeran \'courseextendednamedisplay\' hizkuntza-katea editatuz.';
$string['coursemgmt'] = 'Kudeatu ikastaroak eta kategoriak';
$string['courseoverview'] = 'Ikastaroaren ikuspegi orokorra';
$string['courserequestnotify'] = 'Ikastaro-eskariaren jakinarazpena';
$string['courserequestnotifyemail'] = '{$a->user} erabiltzaileak ikastaro-eskaria egin du hemen {$a->link}';
$string['courserequests'] = 'Ikastaro-eskariak';
$string['courserequestspending'] = 'Onarpenaren zain dauden ikastaro-eskariak';
$string['courses'] = 'Ikastaroak';
$string['coursesperpage'] = 'Ikastaroak orriko';
$string['courseswithsummarieslimit'] = 'Laburpen mugatuak dituzten ikastaroak';
$string['creatornewroleid'] = 'Sortzaileen rola ikastaro berrietan';
$string['creatornewroleid_help'] = 'Erabiltzaileak dagoeneko ikastaro berria kudeatzeko baimenik ez badu, erabiltzailea automatikoki matrikulatuko da rol hori erabiliz.';
$string['cron'] = 'Cron-a';
$string['cronclionly'] = 'Cron-a soilik komando-lerro bidez exekutatuko da';
$string['cronerrorclionly'] = 'Sentitzen dugu, baina orri honetarako sarbidea kudeatzaileak desgaitu du';
$string['cronerrorpassword'] = 'Sentitzen dugu, ez duzu baliozko pasahitza idatzi orri honetara sartzeko';
$string['cron_help'] = 'cron.php script-ak zeregin asko maiztasun ezberdinarekin exekutatzen ditu, hala nola foroetako mezuen jakinarazpen e-mailak bidaltzea. Script-a erregularki exekutatu beharko litzateke - ahal dela minutuero.';
$string['cronremotepassword'] = 'Urrutiko sarbiderako cron-pasahitza';
$string['cronwarning'] = '<a href="{$a}">cron.php mantenu scripta</a> ez da azken 24 orduetan exekutatu.';
$string['cronwarningcli'] = 'cli/cron.php mantentze-script-a azkenengoz exekutatu zenetik gutxienez 24 ordu igaro dira.';
$string['ctyperequired'] = 'Moodlek orain PHP ctype hedapena behar du, gunearen errendimendua hobetzeko eta hizkuntz anitzeko bateragarritasuna eskaini ahal izateko.';
$string['curlcache'] = 'cURl cachea TTL';
$string['curlrequired'] = 'Moodlek orain cURL PHP hedapena behar du, Moodle biltegiekin harremanetan jartzeko.';
$string['curlsecurityallowedport'] = 'Baimendutako cURL ataken zerrenda';
$string['curlsecurityallowedportsyntax'] = 'Konektatzea baimenduta dagoen cURL ataken zerrenda. Soilik zenbaki osoak onartzen dira. Jar ezazu sarrera bakoitza lerro berri batean. Hutsik utziz gero, ataka guztiak onartuko dira. Zehaztuz gero, 443 eta 80 atakak zehaztu beharko dira HTTPS eta HTTP ataka estandarrak erabilita konektatzeko.';
$string['curlsecurityblockedhosts'] = 'Blokeatutako cURL ataken zerrenda';
$string['curlsecurityblockedhostssyntax'] = 'Jar ezazu sarrera bakoitza lerro berri batean. Onartzen diren sarrerak hurrengoak dira: ostalari bakarrarekin bat datozen IPv4 edo IPv6 helbide osoak (hala nola 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::); CIDR notazioa duten helbideak (231.54.211.0/20 edo fe80::/64); IP helbideen tarteak (hala nola 231.3.56.10-20 edo fe80::1111-bbbb), non tarteak azken helbide-taldeari aplikatzen zaizkion; domeinu-izenak (hala nola localhost edo adibidea.eus); komodinak dituzten domeinu izenak (hala nola *.adibidea.eus or *.azpi.adibidea.eus). Hutsik dauden lerroak ez dira onartzen.';
$string['curlsecurityurlblocked'] = 'URLa blokeatuta dago.';
$string['curltimeoutkbitrate'] = 'cURL denbora-mugak kalkulatzeko bit-emaria (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Ezarpen hau cURL eskaera luzeetan denbora-muga egokia kalkulatzeko erabiltzen da. Kalkulu honen une batean HTTP HEAD eskaera bat egiten da edukiaren tamaina zehazteko. Hemen 0 jarriz gero eskaera hori egitea desgaitzen da.';
$string['currenttheme'] = 'Oraingo itxura';
$string['customcheck'] = 'Beste konprobazio batzuk';
$string['custommenu'] = 'Pertsonalizatutako menua';
$string['custommenuitems'] = 'Pertsonalizatutako menuaren elementuak';
$string['customusermenuitems'] = 'Erabiltzaile-menuaren elementuak';
$string['datarootsecurityerror'] = '<p><strong>SEGURTASUN-ALERTA!</strong></p><p>Zure dataroot direktorioa ez dago ondo kokatuta eta agerian dago web-ean. Horrek esan nahi du zure fitxategi pribatuak edozeinek eskura ditzakeela eta horietako batzuk edozein cracker-ek erabil ditzake zure gunean baimenik gabe sartzeko!</p>
<p>Mugitu egin <em>behar</em> duzu dataroot direktorioa ({$a}) kokapen berri batera, zure web direktorio publikotik kanpo, eta ondorioz eguneratu <code>$CFG->dataroot</code> ezarpena zure config.php-en.</p>';
$string['datarootsecuritywarning'] = 'Zure gunearen konfigurazioa agian ez da segurua izango. Mesedez, ziurta ezazu zure sustrai-direktoriora ({$a}) ezin dela zuzenean web-etik heldu.';
$string['dbsessions'] = 'Erabili datu-basea saioaren informazioa lortzeko';
$string['debug'] = 'Arazketa mezuen maila';
$string['debugall'] = 'DENAK: Erakutsi PHP arazketa-mezu guztiak';
$string['debugdeveloper'] = 'GARATZAILEA: Moodle arazketa-mezu gehigarriak garatzaileentzako';
$string['debugdisplay'] = 'Erakutsi arazketa-mezuak';
$string['debugging'] = 'Arazketa';
$string['debugminimal'] = 'GUTXIENEKOA: Erakutsi soilik akats larriak';
$string['debugnone'] = 'BAT ERE EZ: ez erakutsi ez akatsik ez abisurik';
$string['debugnormal'] = 'NORMALA: Erakutsi akatsak, abisuak eta berriak';
$string['debugpageinfo'] = 'Erakutsi orriaren informazioa';
$string['debugsmtp'] = 'E-posta bidalketaren arazketa';
$string['debugstringids'] = 'Erakutsi hizkuntza-kateen jatorria';
$string['debugstringids_desc'] = 'Gaituz gero, hizkuntza-kateen osagaiak eta identifikatzaileak erakutsiko dira URLan ?strings=1 edo &strings=1 gehituz gero.';
$string['debugvalidators'] = 'Erakutsi esteka balidatzaileak';
$string['defaultcity'] = 'Lehenetsitako hiria';
$string['defaultcity_help'] = 'Hemen idatzitako hiria erabiltzaile-kontu berriak sortzean lehenetsitako hiria izango da.';
$string['defaultformatnotset'] = 'Errorea lehenetsitako ikastaro-formatua zehaztean. Mesedez, egiazta itzazu gunearen ezarpenak';
$string['defaulthomepage'] = 'Hasiera-orria erabiltzaileentzat';
$string['defaultrequestcategory'] = 'Ikastaro-eskariek modu lehenetsian duten kategoria';
$string['defaultsettinginfo'] = 'Lehenetsitako balioa: {$a}';
$string['defaultuserroleid'] = 'Erabiltzaile guztiek modu lehenetsian duten rola';
$string['deleteincompleteusers'] = 'Ezabatu osatu gabeko erabiltzaileak tarte honen ondoren';
$string['deleteunconfirmed'] = 'Ezabatu konfirmatu gabeko erabiltzaileak honen ondoren:';
$string['deleteuser'] = 'Ezabatu erabiltzailea';
$string['density'] = 'Dentsitatea';
$string['denyemailaddresses'] = 'Ukatutako posta elektronikoko domeinuak';
$string['development'] = 'Garapena';
$string['devicedetectregex'] = 'Gailuen antzematerako adierazpen erregularrak';
$string['devicedetectregex_desc'] = '<p>Modu lehenetsian, Moodlek hurrengo gailu-motak antzeman ditzake: arrunta (mahaigaineko PCa, eramangarria,...) sakeleko gailuak (sakeleko telefonoak eta eskurako gailu txikiak), tablet-ak  (iPad-ak, Android tablet-ak) eta zaharkitutakoak (Internet Explorer 6 erabiltzaileak). Itxura-hautatzailea erabil daitezke horietako bakoitzari itxura ezberdinak aplikatzeko. Ezarpen honek gailu-mota gehigarriak antzemateko adierazpen erregularrak erabiltzea ahalbidetzen du (honek modu lehenetsian antzemandako gailu-motekiko lehentasuna izango luke).</p>
<p>Adibidez, zuk \'/(MIDP-1.0|Maemo|Windows CE)/\' adierazpen erregularra sar dezakezu telefonoen funtzio arrunt batzuk antzeman eta horietan \'funtzioduntelefonoa\' balioa bueltatzeko. Honek Itxura-hautatzailean \'funtzioduntelefonoa\' aukera gehitzen du eta horrek gailu hauei itxura bat aplikatzeko aukera emango lizuke. Beste telefonoek gailu mugikorrentzako aukeratutako itxura erabiltzen jarraituko lukete.</p>';
$string['devicedetectregexexpression'] = 'Adierazpen erregularra';
$string['devicedetectregexvalue'] = 'Itzulera-balioa';
$string['devicetype'] = 'Gailu-mota';
$string['devlibdirpresent'] = 'Garapenerako liburutegiak dituzten karpetak, bereziki <em>/vendor</em> eta <em>/node_modules</em>, ez lirateke gune publikoetan egon beharko. Ikusi <a href="{$a->moreinfourl}">segurtasunaren txostenaren aurrebista</a> informazio gehiago eskuratzeko.';
$string['disableuserimages'] = 'Desgaitu erabiltzailearen profileko irudiak';
$string['displayerrorswarning'] = 'Ez da gomendatzen <em>erakutsi_erroreak</em> PHP ezarpena martxan ari diren guneetan gaitzea hainbat errore-mezuk zure zerbitzariaren inguruko oso informazio garrantzitsua erakutsi ahal dutelako.';
$string['displayloginfailures'] = 'Erakutsi huts egindako saio-hasierak';
$string['dndallowtextandlinks'] = 'Hartu eta eraman testu/esteken igoera';
$string['doclang'] = 'Dokumentaziorako hizkuntza';
$string['docroot'] = 'Moodle Doc-en iturburua';
$string['doctonewwindow'] = 'Ireki leiho berrian';
$string['doesnotfit'] = 'Helbide elektronikoa erakusteko ezarpenak';
$string['doesnotfitdetail'] = 'Erakutsi Moodletik bidaltzen diren e-mailetarako ezarpenak';
$string['download'] = 'Jaitsi';
$string['durationunits'] = 'iraupen-unitateak';
$string['edithelpdocs'] = 'Editatu laguntza-dokumentuak';
$string['editlang'] = '<b>Editatu</b>';
$string['editorbackgroundcolor'] = 'Azpiko kolorea';
$string['editordictionary'] = 'Editorearen hiztegia';
$string['editorfontfamily'] = 'Iturri-familia';
$string['editorfontlist'] = 'Iturri-zerrenda';
$string['editorfontsize'] = 'Letra-tamaina';
$string['editorhidebuttons'] = 'Ezkutuko botoiak';
$string['editorkillword'] = 'Word formatuko iragazkia';
$string['editorspelling'] = 'Editorearen zuzentzailea';
$string['editorspellinghelp'] = 'Gaitu edo desgaitu ortografia-zuzentzailea. Gaituz gero <strong>aspell</strong>-k zerbitzarian instalatuta egon behar du.';
$string['editstrings'] = 'Editatu hitzak edo esaldiak';
$string['emailchangeconfirmation'] = 'Helbide elektronikoaren aldaketaren baieztapena';
$string['emailfromvia'] = 'E-mailaren igorlearen informazioa';
$string['emoticonalt'] = 'Ordezko testua';
$string['emoticoncomponent'] = 'Irudiaren osagaia';
$string['emoticonimagename'] = 'Irudiaren izena';
$string['emoticons'] = 'Aurpegierak';
$string['emoticons_desc'] = 'Formulario honek zure gunean erabilitako aurpegierak (edo smiley-ak) zehazten ditu. Taulako errenkada bat ezabatzeko formularioa beharrezko eremuak hutsik utzita gorde ezazu. Aurpegiera berri bat erregistratzeko, bete itzazu hutsik dagoen azken errenkadako eremuak. Eremu guztiak lehenetsitako balioetara berrezartzeko jarraitu beheko esteka.

* Testua (beharrezkoa) - Testu hau aurpegiera irudiarekin ordezkatuko da. Gutxienez bi karaktereko luzera izan behar du.
* Irudiaren izena (beharrezkoa) - Aurpegiera irudiaren fitxategiaren izena luzapenik gabe, osagaiaren pix karpetarekiko.
* Irudiaren osagaia (beharrezkoa) - Ikonoa ematen duen osagaia.
* Ordezko testua (beharrezkoa) - Kate-identifikatzailea eta aurpegieraren ordezko testua.';
$string['emoticonsreset'] = 'Berrabiarazi aurpegieren ezarpenak lehenetsitako balioetara';
$string['emoticontext'] = 'Testua';
$string['emptysettingvalue'] = 'Hutsik';
$string['enableactivitychooser'] = 'Gaitu jarduera-hautatzailea';
$string['enableblogs'] = 'Gaitu blogak';
$string['enablecalendarexport'] = 'Gaitu egutegiaren esportazioa';
$string['enablecomments'] = 'Gaitu iruzkinak';
$string['enablecourserequests'] = 'Gaitu ikastaro-eskariak';
$string['enabled'] = 'Gaituta';
$string['enabledevicedetection'] = 'Gaitu gailua atzematea';
$string['enableglobalsearch'] = 'Gaitu bilaketa orokorra';
$string['enableglobalsearch_desc'] = 'Gaituz gero, programatutako zeregin batek datuak indexatu eta sinkronizatuko ditu.';
$string['enablegravatar'] = 'Gaitu Gravatar';
$string['enablegravatar_help'] = 'Gaituta dagoenean erabiltzaileak irudirik igo ez badu, Moodle erabiltzailearen irudia Gravatar-etik eskuratzen saiatuko da.';
$string['enablemobilewebservice'] = 'Gaitu web-zerbitzuak gailu mugikorretarako';
$string['enablerecordcache'] = 'Gaitu erregistro-cachea';
$string['enablerssfeeds'] = 'Gaitu RSS jarioak';
$string['enablesafebrowserintegration'] = 'Gaitu integrazioa Safe Exam Browser-ekin';
$string['enablesearchareas'] = 'Gaitu bilaketa-eremuak';
$string['enablestats'] = 'Gaitu estatistikak';
$string['enabletrusttext'] = 'Gaitu konfiantzazko edukia';
$string['enablewebservices'] = 'Gaitu web-zerbitzuak';
$string['enablewsdocumentation'] = 'Web-zerbitzuen dokumentazioa';
$string['enrolinstancedefaults'] = 'Lehenetsitako matrikulaziorako instantzia';
$string['enrolinstancedefaults_desc'] = 'Lehenetsitako matrikulazio-ezarpenak ikastaro berrietan.';
$string['enrolmultipleusers'] = 'Matrikulatu erabiltzaileak';
$string['environment'] = 'Ingurunea';
$string['environmenterrortodo'] = 'Moodleren bertsio hau instalatu aurretik goian aurkitutako inguru-arazo (errore) guztiak zuzendu behar dituzu.';
$string['environmenterrorupgrade'] = 'Kontuz: ingurune-arazo guztiak konpondu beharko zenituzke Moodleren bertsio hau eguneratzen hasi aurretik! Baldintza hau bete gabe egindako eguneraketak hainbat arazo sor dezakete, besteak beste datuak galtzea. Ziur zaude eguneraketarekin aurrera egin nahi duzula?';
$string['environmentmariadbwrongdbtype'] = '<code>$CFG->dbtype</code> ezegokia: zure <code>config.php</code> fitxategia editatu behar duzu, \'<code>mysql</code>\' beharrean \'<code>mariadb</code>\' jarrita.';
$string['environmentmustfixsetting'] = 'PHP ezarpenak aldatu egin behar dira.';
$string['environmentok'] = 'Zure zerbitzariaren inguruneak beharrezko eskakizunak betetzen ditu.';
$string['environmentrecommendcustomcheck'] = 'honek kale egiten badu, ustezko arazo bat dagoela adierazten du.';
$string['environmentrecommendinstall'] = 'gomendagarria da instalatuta eta gaituta egotea emaitza hobeak izateko.';
$string['environmentrecommendversion'] = '{$a->needed} bertsioa gomendatzen da eta zu {$a->current} ari zara egikaritzen';
$string['environmentrequirecustomcheck'] = 'test hau pasatu beharra dago';
$string['environmentrequireinstall'] = 'derrigorrezkoa da instalatuta eta gaituta izatea';
$string['environmentrequireversion'] = '{$a->needed} bertsioa beharrezkoa da eta zu {$a->current} ari zara egikaritzen';
$string['environmentsettingok'] = 'gomendatutako ezarpena aurkitu da';
$string['environmentshouldfixsetting'] = 'PHP ezarpenak aldatu egin beharko lirateke.';
$string['environmentxmlerror'] = 'Errorea inguruari buruzko informazioa irakurtzean ({$a->error_code})';
$string['errordeletingconfig'] = 'Errorea gertatu da  \'{$a}\' pluginerako konfigurazio-erregistroak ezabatzean.';
$string['errorsetting'] = 'Ezin izan da aukeratutakoa gorde:';
$string['errorwithsettings'] = 'Hainbat ezarpen ez dira gorde akats bat dela-eta.';
$string['eventshandlersinuse'] = 'Zure sistemako hurrengo pluginek baztertutako Events 1 API-aren kudeatzaileak erabiltzen dituzte: \'{$a}\'. Mesedez, eguneratu itzazu Events 2 API-ra. Ikusi https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers gehiago jakiteko.';
$string['everyonewhocan'] = '\'{$a}\' egin dezakeen edozein';
$string['exceptions'] = 'salbuespenak';
$string['execpathnotallowed'] = 'Exekutagarrien eta bide lokalak config.php fitxategian ezartzea desgaituta dago.';
$string['experimental'] = 'Esperimentala';
$string['experimentalsettings'] = 'Ezarpen esperimentalak';
$string['extendedusernamechars'] = 'Baimendu karaktere zabalduak erabiltzaile-izenetan';
$string['extramemorylimit'] = 'Aparteko PHP memoriaren muga';
$string['fatalsessionautostart'] = '<p>Konfirgurazio-errore larria aurkitu da; mesedez, jakinarazi zerbitzari-kudeatzaileari.</p><p> Ondo aritzeko, kudeatzaileak PHP ezarpenak aldatu behar ditu.</p><p><code>session.auto_start</code>-ek <code>off</code> ezarrita izan behar du.</p><p>Ezarpen hau zerbitzariko <code>php.ini</code> editatuz, Apache/IIS <br /> ezarpenen bitartez edo <code>.htaccess</code> fitxategiarekin kontrolatzen da.</p>';
$string['fileconversioncleanuptask'] = 'Garbitu dokumentu-bihurgailuetako behin-behineko erregistroak';
$string['filecreated'] = 'Fitxategia sortu da';
$string['filestoredin'] = 'Gorde fitxategia ondoko karpetan:';
$string['filestoredinhelp'] = 'Fitxategia gordetzeko lekua';
$string['filterall'] = 'Iragazi kate guztiak';
$string['filtermatchoneperpage'] = 'Iragazi kointzidentziak behin orri bakoitzeko';
$string['filtermatchonepertext'] = 'Iragazi kointzidentziak behin testu bakoitzeko';
$string['filters'] = 'Iragazkiak';
$string['filtersettings'] = 'Kudeatu iragazkiak';
$string['filtersettingsgeneral'] = 'Iragazkien ezarpen orokorrak';
$string['filteruploadedfiles'] = 'Iragazi igotako fitxategiak';
$string['forceclean'] = 'Edukia alde guztietan garbitzen';
$string['forceclean_desc'] = 'Gune honetan gehitutako edukia erakutsi aurretik garbitu egiten da, arriskutsuak izan litekeen guztia ezabatzeko.
Hala ere, gehitu beharreko hainbat lekutako edukia ez da garbitzen, hala nola, jardueren deskribapenak, orrialdeetako baliabideak edo HTML blokeak script-ak ahalbidetzeko, media, inline frame-ak etab. Horrek eragin lezake lehenengo edukiak oker erakustea.';
$string['forcelogin'] = 'Behartu erabiltzaileak identifikatzera';
$string['forceloginforprofileimage'] = 'Behartu erabiltzaileak identifikatzera erabiltzaileen irudiak ikusteko';
$string['forceloginforprofileimage_help'] = 'Gaituz gero, erabiltzaileak sartu beharko dira erabiltzaileen irudiak ikusteko eta erabiltzaileen lehenetsitako irudia erabiliko da jakinarazpen e-mail guztietan.';
$string['forceloginforprofiles'] = 'Behartu erabiltzaileak identifikatzera profilak ikusi ahal izateko';
$string['forcetimezone'] = 'Behartu ordu eremua';
$string['formatuninstallwithcourses'] = '{$a->format} formatua erabiltzen duen {$a->count} ikastaro dago. Euren formatua {$a->defaultformat}-(e)ra aldatuko da (gunearen lehenetsitako formatua). Formatuaren lotutako datu batzuk gal daitezke. Ziur zaude aurrera egin nahi duzula?';
$string['frontpage'] = 'Hasiera-orria';
$string['frontpagebackup'] = 'Hasiera-orriaren segurtasun-kopia';
$string['frontpagedefaultrole'] = 'Hasiera-orriko rol lehenetsia';
$string['frontpagefilters'] = 'Hasiera-orriaren iragazkiak';
$string['frontpageloggedin'] = 'Hasiera-orriaren elementuak gunean sartzean';
$string['frontpageoverrides'] = 'Hasiera-orriaren baimen-baliogabetzeak';
$string['frontpagequestions'] = 'Hasiera-orriaren galderak';
$string['frontpagerestore'] = 'Hasiera-orria berreskuratu';
$string['frontpageroles'] = 'Hasiera-orriaren rolak';
$string['frontpagesettings'] = 'Hasiera-orriaren ezarpenak';
$string['fullnamedisplay'] = 'Izen osoaren formatua';
$string['fullnamedisplayprivate'] = 'Izen osoaren formatua - pribatua';
$string['gdrequired'] = 'GD hedapena orain Moodlen derrigorrezkoa da irudiak bihurtzeko.';
$string['generalsettings'] = 'Ezarpen orokorrak';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Erregistratutako IP helbideen iturburua';
$string['globalsearch'] = 'Bilaketa orokorra';
$string['globalsearchmanage'] = 'Kudeatu bilaketa orokorra';
$string['googlemapkey3'] = 'Google Maps API V3 rako giltza';
$string['googlemapkey3_help'] = 'Gako berezi bat sartu behar duzu Google Maps IP helbideen bilaketaren irudikatzea erabiltzeko. Gakoa doan lortu dezakezu <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a> helbidean';
$string['gotofirst'] = 'Joan falta den lehenengo katera';
$string['gradebook'] = 'Kalifikazio-liburua';
$string['gradebookroles'] = 'Kalifikatutako rolak';
$string['gradeexport'] = 'Lehen mailako kalifikazioak esportatzeko metodoak';
$string['gravatardefaulturl'] = 'Gravatar-en lehenetsitako irudiaren URLa';
$string['gravatardefaulturl_help'] = 'Gravatar-ek lehenetsitako irudi bat behar du erabiltzaile baten irudia eskuratzeko gai ez denerako. Eman irudiaren URL osoa. Ezarpen hau hutsik utziz gero, Moodle ikusten ari zaren orriarentzako lehenetsitako irudi egokiena erabiltzen saiatuko da. Kontuan izan Gravatar-ek erabil daitezkeen kode batzuk ere badituela <a href="https://en.gravatar.com/site/implement/images/#default-image">lehenetsitako irudiak sortzeko</a>.';
$string['groupenrolmentkeypolicy'] = 'Taldeen matrikulaziorako giltza-politika';
$string['groupenrolmentkeypolicy_desc'] = 'Ezarpen hau gaituz gero, taldeko matrikulazio-giltzek pasahitzen politika betetzen duten egiaztatuko da, beheko ezarpenetan zehaztutakoaren arabera.';
$string['guestroleid'] = 'Bisitarientzako rola';
$string['guestroleid_help'] = 'Rol hau automatikoki esleitzen zaio bisitariari. Aldi baterako esleitzen zaio matrikulatu gabeko erabiltzaileari ere, bisitaria matrikulatu plugina erabilita sartzen bada.';
$string['helpadminseesall'] = 'Guneko egutegi honetan, kudeatzaileek egutegiaren ekitaldi guztiak ikusi eta iragazi ditzakete edo matrikulatuta dauden ikastaroetakoak soilik? Edonola ere, kudeatzaileek ikastaro bakoitzaren ekitaldiak kudeatu ahalko dituzte lehen ikastaro bakoitzera nabigatuz eta ikastaroko egutegira zuzenean sartuta.';
$string['helpcalendarcustomexport'] = 'Gaitu data-tarte pertsonalizatua esportatzeko aukera egutegia esportatzean. Egutegia esportatzea gaituta egon behar da ezarpen hau aplikatzeko.';
$string['helpexportlookahead'] = 'Etorkizuneko zenbat egun hartuko da kontuan egutegian ekitaldiak esportatzerakoan data-tarte pertsonalizatuan?';
$string['helpexportlookback'] = 'Iraganeko zenbat egun hartuko da kontuan egutegian ekitaldiak esportatzerakoan data-tarte pertsonalizatuan?';
$string['helpforcetimezone'] = 'Erabiltzaileek beren ordu eremua aukeratzea baimendu edo guztientzat bera izatea erabaki dezakezu.';
$string['helpshowicalsource'] = 'Gaituz gero, harpidetza-izena eta esteka erakutsiko dira iCal-etik inportatutako ekitaldietan.';
$string['helpsitemaintenance'] = 'Eguneratze eta beste zereginetarako';
$string['helpstartofweek'] = 'Astea zein egunetan hasten da?';
$string['helpupcominglookahead'] = 'Zenbat egun hartu behar ditu kontuan egutegiak hurrengo ekitaldietako lehenetsitako balio gisa?';
$string['helpupcomingmaxevents'] = 'Gehienez hurrengo zenbat ekitaldi erakutsiko zaizkie erabiltzaileei?';
$string['helpweekenddays'] = 'Asteko zenbat egun \'asteburutzat\' hartu eta beste kolore batez erakutsiko dira?';
$string['hiddenuserfields'] = 'Ezkutatu erabiltzailearen eremuak';
$string['hidefromall'] = 'Ezkutatu erabiltzaile guztiei';
$string['hidefromnone'] = 'Ez ezkutatu inori';
$string['hidefromstudents'] = 'Ezkutatu ikasleei';
$string['htmleditor'] = 'HTML editorea';
$string['htmleditorsettings'] = 'HTML editorearen ezarpenak';
$string['htmlsettings'] = 'HTML ezarpenak';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP segurtasuna';
$string['hubs'] = 'Bilguneak';
$string['iconvrequired'] = 'ICONV hedapena instalatzea beharrezkoa da.';
$string['ignore'] = 'Baztertu';
$string['includemoduleuserdata'] = 'Sartu moduluaren erabiltzailearen datuak';
$string['incompatibleblocks'] = 'Bloke bateraezinak';
$string['incompleteunicodesupport'] = 'Oraingo MySQL eta MariaDB-ren konfigurazioak \'utf8\' erabiltzen du. Karaktere-multzo honek ez du lau bit-ez osatutako karaktereak onartzen emoji batzuk barne. Karaktere horiek erabiltzen saiatuz gero errore bat gertatutako da erregistroa eguneratzerakoan, eta datu-basera bidaltzen ari den informazioa galduko da. Mesedez hausnartu ezazu ezarpen hau \'utf8mb4\' aldatzea. Ikusi dokumentazioa xehetasunak ezagutzeko.';
$string['indexdata'] = 'Indexatu datuak';
$string['indexinginfo'] = 'Zure guneko edukiak indexatzeko gomendatutako modua \'Bilaketa globalerako indexatzea\' programatutako zeregina erabiltzea da';
$string['installhijacked'] = 'Instalazioa jatorrizko IP helbidearekin amaitu behar da, sentitzen dugu.';
$string['installsessionerror'] = 'Ezin da PHP saiorik hasi; mesedez, egiazta ezazu zure nabigatzeileak cookie-ak onartzen dituela.';
$string['intlrecommended'] = 'Intl hedapena internazionalizazioaren sostengua hobetzeko erabiltzen da, hala nola kokapena kontuan hartzen duen ordenatzeko.';
$string['intlrequired'] = 'Intl hedapena internazionalizazioaren sostengua hobetzeko behar da, hala nola kokapena kontuan hartzen duen ordenatzeko edo nazioarteko domeinu-izenak erakusteko.';
$string['invalidagedigitalconsent'] = 'Onespen-adin digitala ez da baliozkoa: {$a}';
$string['invalidforgottenpasswordurl'] = 'Ahaztutako pasahitzaren URLa ez da URL baliozkoa.';
$string['invalidsection'] = 'Atal ezegokia.';
$string['invaliduserchangeme'] = '"changeme" erabiltzaile-izena erreserbatuta dago: ezin da izen horrekin konturik sortu.';
$string['ipblocked'] = 'Gunea ez dago eskuragarri une honetan.';
$string['ipblocker'] = 'IP blokeatzailea';
$string['ipblockersyntax'] = 'Sarrera bakoitza lerro batean idatzi. Baliozko sarrerak horrelakoak izan daitezke: IP helbide osoak (hala nola <b>192.168.10.1</b>), hostalari bakar batekin bat egiten dutenak; IP helbideen zatiak (hala nola <b>192.168</b>), zenbaki horiekin bat egiten duten helbideekin bat egiten dutenak; CIDR notazioko helbideak (hala nola <b>231.54.211.0/20</b>); IP helbideen tarte bat (hala nola <b>231.3.56.10-20</b>), non tartea helbidearen azken zatiari aplikatzen zaion. Testuzko domeinu -izenak (\'adibidea.eus\' adibidez) ez dira onartzen. Hutsik dauden lerroak eta "#" karakterearen ondorengoko testuak ez dira kontuan hartuko.';
$string['iplookup'] = 'IP helbidea bilatu';
$string['iplookupgeoplugin'] = 'Une honetan <a href="https://www.geoplugin.com">geoPlugin</a> zerbitzua informazio geografikoa eskuratzeko erabiltzen da. Emaitza zehatzagoak lortzeko MaxMind GeoLite datu-basearen kopia bat lokalean instalatzea gomendatzen dugu.';
$string['iplookupinfo'] = 'Modu lehenetsian, Moodlek NetGeo (The Internet Geographic Database) doako on-line zerbitzari erabiltzen du IP helbideen kokapena bilatzeko. Tamalez, datu-base horren mantenua eten egin da eta emaitza <em>erabat ezegokiak</em> eman ditzake.
Gomendagarria da doako GeoLite2 City datu-basearen kopia lokala instalatzea MaxMind-etik.<br />
IP helbideen kokapena mapa erraz batean edo Google Maps erabilita erakusten da. Mesedez, ohartu mapa interaktiboak gaitzeko Google kontua behar duzula eta Google Maps API giltza doan eskatu.';
$string['iplookupmaxmindnote'] = 'Produktu honek MaxMind-ek sortutako GeoLite2 datuak barne ditu eta hemendik eskura daitezke: <a href="https://www.maxmind.com/">https://www.maxmind.com/</a>.';
$string['ishttpswarning'] = 'Zure gunea HTTPS erabiliz babesturik ez dagoela antzeman dugu. Zure gunea HTTPS erabiltzeko migratzea irmoki gomendatzen da segurtasuna eta beste sistemekiko integrazioak hobetzeko.';
$string['keeptagnamecase'] = 'Mantendu etiketen izenen jatorrizko \'casing\'-a';
$string['lang'] = 'Lehenetsitako hizkuntza';
$string['langcache'] = 'Hizkuntza-menuaren cachea';
$string['langcache_desc'] = 'Cacheatu hizkuntza-menua. Gaituz gero, eskuragarri dauden hizkuntzak cacheatu egingo dira. Cachea automatikoki freskatzen da hizkuntzen kudeaketa-erremintaren bidez hizkuntza-pakete bat instalatu edo ezabatzen den bakoitzean. Hizkuntza-pakete bat eskuz instalatzen baduzu, Ezabatu cache guztiak funtzioa erabili beharko duzu cacheatutako zerrenda eguneratzeko.';
$string['langlist'] = 'Hizkuntzak hizkuntza-menuan';
$string['langmenu'] = 'Erakutsi hizkuntza-menua';
$string['langpackwillbeupdated'] = 'OHARRA: Moodle une honetan aukeratutako hizkuntza-paketea eguneratzen saiatuko da.';
$string['langstringcache'] = 'Gorde cache-an hizkuntza-kate guztiak';
$string['languagesettings'] = 'Hizkuntza-ezarpenak';
$string['latinexcelexport'] = 'Excel kodifikazioa';
$string['legacyfilesaddallowed'] = 'Baimendu heredatutako ikastaroko fitxategietara gehitzen';
$string['legacyfilesaddallowed_help'] = 'Ikastaro batek heredatutako ikastaroko fitxategiak baditu, baimendu bertan fitxategi eta karpeta berriak gehitzea.';
$string['legacyfilesinnewcourses'] = 'Heredatutako ikastaroko fitxategiak ikastaro berrietan';
$string['legacyfilesinnewcourses_help'] = 'Modu lehenetsian, heredatutako ikastaroko fitxategiak eguneratutako ikastaroetan soilik daude eskuragarri. Mesedez kontuan izan jardueren segurtasun-kopia eta berreskuratzea bezalako funtzio batzuk ez direla ezarpen honekin bateragarriak.';
$string['libcurlwarning'] = 'libcurl-ek CURLOPT_PROTOCOL ez duela onartzen antzeman da. Segurtasun arrazoiengatik eguneratutako libcurl instalazio bat gomendatzen da.';
$string['licensesettings'] = 'Lizentziaren ezarpenak';
$string['linkadmincategories'] = 'Estekatu kudeaketako kategoriak';
$string['linkadmincategories_help'] = 'Gaituz gero nabigazioan kudeaketa ezarpenen kategoriak esteka gisa erakutsiko dira eta kudeaketa kategoriaren orrira eramango dute.';
$string['linkcoursesections'] = 'Estekatu beti ikastaro-atalak';
$string['linkcoursesections_help'] = 'Saiatu beti ikastaroko ataletara esteka bat ematen. Ikastaro-atalak normalean soilik ikastaro-formatuak orriko atal bakarra erakusten duenean erakusten dira esteka gisa. Ezarpen hau gaituta badago esteka beti emango da.';
$string['loading'] = 'Igotzen';
$string['localetext'] = 'Gunearen locale-a';
$string['localstringcustomization'] = 'Pertsonalizatu hizkuntza lokala';
$string['location'] = 'Kokapena';
$string['locationsettings'] = 'Kokapenaren ezarpenak';
$string['locked'] = 'Blokeatuta';
$string['lockoutduration'] = 'Kontuaren blokeoaren iraupena';
$string['lockoutduration_desc'] = 'Blokeatutako kontua denbora-tarte honen ondoren automatikoki desblokeatuko da.';
$string['lockoutemailbody'] = 'Zure \'{$a->sitename}\' zerbitzariko {$a->username} erabiltzailearen kontua blokeatua izan da sartzeko saiakera oker anitz egin direlako.

Kontua berehala desblokeatzeko, sartu hurrengo estekan:

{$a->link}

Posta elektronikoko programa gehienetan goiko helbidea esteka urdin gisa agertu beharko litzateke eta zuk zuzenean klik egiteko aukera izan beharko zenuke. Horrela ez bada, helbidea kopiatu eta zure nabigatzailearen goialdean dagoen helbide-barran itsatsi ezazu.

Laguntza behar baduzu, mesedez jarri harremanetan zure guneko kudeatzailearekin,
{$a->admin}';
$string['lockoutemailsubject'] = 'Zure {$a} guneko kontua blokeatu da';
$string['lockouterrorunlock'] = 'Kontua desblokeatzeko informazio baliogabea eman da.';
$string['lockoutthreshold'] = 'Kontuen blokeorako atalasea';
$string['lockoutthreshold_desc'] = 'Aukeratu kontua blokeatzeko egin beharreko sartzeko saiakera okerren kopurua. Funtzio honen abusua egin daiteke zerbitzua bertan behera uzteko (DoS) erasoetan.';
$string['lockoutwindow'] = 'Kontuen blokeoaren erakuste-leihoa';
$string['lockoutwindow_desc'] = 'Blokeoa mantentzeko denbora-tartea, ez badago saiakera okerrik tarte hau igaro ondoren atalasea berrabiarazten da.';
$string['log'] = 'Agerraldiak';
$string['logguests'] = 'Gonbidatuen sarbidearen erregistroa';
$string['logguests_help'] = 'Ezarpen honek erabiltzaile gonbidatua eta sartu gabeko erabiltzaileen ekintzak erregistratzea gaitzen du. Profil altuko guneek agian aukera hau desgaitu nahiko dute errendimendu arrazoiak direla-eta. Lanean dauden guneetan ezarpen hau gaitzea gomendatzen da.';
$string['loginhttps'] = 'Erabili HTTPS saioa hasteko';
$string['loginpageautofocus'] = 'Foku automatikoa sarbide-orriko formularioan';
$string['loginpageautofocus_help'] = 'Aukera hau gaitzeak sarbide-orriko erabilterraztasuna handitzen du, baina eremuak automatikoki fokatzea irisgarritasun arazo gisa ere ikusi daiteke.';
$string['loginpasswordautocomplete'] = 'Ekidin sarrera formularioan pasahitzak automatikoki betetzea';
$string['loginpasswordautocomplete_help'] = 'Gaituz gero, erabiltzaileek ezin izango dute pasahitza beren nabigatzailean gorde.';
$string['loglifetime'] = 'Mantendu erregistroak tarte honetan:';
$string['logo'] = 'Logoa';
$string['logocompact'] = 'Logo txikia';
$string['logocompact_desc'] = 'Goiko logoaren bertsio txikiago bat, hala nola enblema, ezkutu edo ikono bat. Irudia garbia izan beharko litzateke baita tamaina txikietan ere. Onartutako formatuak: PNG eta JPG.';
$string['logo_desc'] = 'Logo handia itxura batzuk apaintzeko erabiltzen dute (hala nola itxura estandarrak). Irudi hau nahiko erresoluzio handikoa izan daiteke erabilerako txikitua izango delako (eta cacheatua izango da errendimendua hobetzeko).';
$string['logossettings'] = 'Logoak';
$string['logstorenotrequired'] = 'Ez da erregistro-biltegirik behar';
$string['logstoressupported'] = 'Txosten hau onartzen duten erregistro-biltegiak';
$string['longtimewarning'] = '<b>Mesedez, kontuan hartu prozesu hau oso luzea izan daitekeela.</b>';
$string['mailnewline'] = 'Lerro berriaren karaktereak e-mailean';
$string['maintenancemode'] = 'Mantenu-moduan';
$string['maintenancemodeisscheduled'] = 'Gune hau mantenu-modura aldatuko da {$a->min} minutu eta {$a->sec} segundutan';
$string['maintenancemodeisscheduledlong'] = 'Gune hau mantenu-moduan jarriko da {$a->hour} ordu, {$a->min} minutu eta {$a->sec} segundu barru';
$string['maintfileopenerror'] = 'Errorea mantenu-fitxategiak irekitzean';
$string['maintinprogress'] = 'Mantenua martxan...';
$string['managecontextlock'] = 'Izoztu testuinguru hau';
$string['managecontextlocklocked'] = '{$a->contextname} eta beheragoko beste edozein testuinguru izoztuta daude dagoeneko.';
$string['managecontextlockunlocked'] = '{$a->contextname} eta beheragoko beste edozein testuinguru dagoeneko ez daude izoztuta.';
$string['managecontextunlock'] = 'Desizoztu testuinguru hau';
$string['manageformats'] = 'Kudeatu ikastaro-formatuak';
$string['manageformatsgotosettings'] = 'Lehenetsitako formatua alda daiteke hemen: {$a}';
$string['managelang'] = 'Kudeatu';
$string['managelicenses'] = 'Kudeatu lizentziak';
$string['manageqbehaviours'] = 'Kudeatu galderen jokaerak';
$string['manageqtypes'] = 'Kudeatu galdera-motak';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Azken bertsiorako hautagaia';
$string['maturity200'] = 'Bertsio egonkorra';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Pista: script-a ziurrenik –allow-unstable aukerarekin exekutatu nahiko duzu';
$string['maturitycoreinfo'] = 'Zure guneak une honetan "{$a}" garapenerako kode ezegonkorra exekutatzen ari da.';
$string['maturitycorewarning'] = 'Instalatzera zoazen Moodle bertsioak lanean dauden gune gehienentzat egokia ez den "{$a}" garapenerako kode ezegonkorra dauka. Hau ez bada egin nahi duzuna ziurtatu ezazu zure Moodle kodea adar STABLE batetik eguneratzen ari zarela. Ikusi Moodle Docs-ak xehetasun gehiago jakiteko.';
$string['maxbytes'] = 'Igotako fitxategiaren gehienezko tamaina';
$string['maxconsecutiveidentchars'] = 'Jarraian dauden karaktere berdinak';
$string['maxeditingtime'] = 'Mezuak editatzeko gehienezo denbora-tartea';
$string['maxtimelimit'] = 'Gehienezko denbora-epea';
$string['maxtimelimit_desc'] = 'Moodlek onartuko duen gehienezko PHP exekuzio-denbora mugatzeko inolako irteerarik erakutsi gabe, sartu hemen balio bat (segundoetan), 0 jarriz gero Moodleko lehenetsitako mugak aplikatuko dira. Bere muga propioak dituen frontend zerbitzari bat baduzu hemen balio baxuago bat ezarri PHP error mezuak jasotzeko. Muga hau ez zaie CLI script-ei aplikatzen.';
$string['maxusersperpage'] = 'Gehienezko erabiltzaileak orriko';
$string['mbstringrecommended'] = 'MBSTRING aukerako liburutegia instalatzea gomendagarria da  oso gunearen errendimendua hobetzeko, batez ere zure guneak latindarrak ez diren hizkuntzak erabiltzen baditu.';
$string['mbstringrequired'] = 'MBSTRING liburutegia instalatzea derrigorrezkoa da gunearen errendimendua hobetzeko, bereziki zure guneak hizkuntza erromantzeak ez direnak onartzen baditu.';
$string['mediapluginavi'] = 'Gaitu .avi iragazkia';
$string['mediapluginflv'] = 'Gaitu .flv iragazkia';
$string['mediapluginimg'] = 'Gaitu estekatutako irudien auto-enbotatzea';
$string['mediapluginmov'] = 'Gaitu .mov iragazkia';
$string['mediapluginmp3'] = 'Gaitu .mp3 iragazkia';
$string['mediapluginmpg'] = 'Gaitu .mpg iragazkia';
$string['mediapluginogg'] = 'Gaitu .ogg iragazkia';
$string['mediapluginogv'] = 'Gaitu .ogv iragazkia';
$string['mediapluginram'] = 'Gaitu .ram iragazkia';
$string['mediapluginrm'] = 'Gaitu .rm iragazkia';
$string['mediapluginrpm'] = 'Gaitu .rpm iragazkia';
$string['mediapluginswf'] = 'Gaitu .swf iragazkia';
$string['mediapluginswfnote'] = 'Lehenetsitako segurtasun-neurri gisa, erabiltzaile arruntei ez zaie swf flash fitxategirik sartzen uzten.';
$string['mediapluginwmv'] = 'Gaitu .wmv iragazkia';
$string['mediapluginyoutube'] = 'Gaitu YouTube esteken iragazkia';
$string['messaging'] = 'Gaitu mezularitza-sistema';
$string['messagingallowemailoverride'] = 'Baliogabetu posta elektroniko bidezko jakinarazpenak';
$string['messagingallusers'] = 'Baimendu gunean zeharreko mezularitza';
$string['messagingdeleteallnotificationsdelay'] = 'Ezabatu jakinarazpen guztiak';
$string['messagingdeletereadnotificationsdelay'] = 'Ezabatu irakurritako jakinarazpenak';
$string['minpassworddigits'] = 'Digituak';
$string['minpasswordlength'] = 'Pasahitzaren luzera';
$string['minpasswordlower'] = 'Letra xeheak';
$string['minpasswordnonalphanum'] = 'Karaktere alfanumerikorik ez';
$string['minpasswordupper'] = 'Letra larriak';
$string['misc'] = 'Bestelakoak';
$string['mnetrestore_extusers'] = '<strong>Oharra:</strong> Segurtasun-kopia honek Moodle Sareko urrutiko erabiltzaile-kontuak ditu eta prozesuaren zati bezala berreskuratuko dira.';
$string['mnetrestore_extusers_admin'] = '<strong>Oharra:</strong> Segurtasun-kopia honek Moodleren instalazio ezberdin batean du iturburua antza eta Moodle Sareko urrutiko erabiltzaile-kontuak ditu. Berreskuratzeko prozesuan sortutako erabiltzaile guztien Moodle Sareko hostalariekin bat egiten saiatuko gara. Bat ez datozenak automatikoki bihurtuko dira barne-autentifikaziora (mnet-en ordez). Berreskuratzeko logek emango dizute horren berri.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Oharra:</strong> Segurtasun-kopia honek Moodleren instalazio ezberdin batean du iturburua antza eta berreskura ezin daitezkeen Moodle Sareko urrutiko erabiltzaile-kontuak ditu. Ezin da eragiketa hau burutu. Ziur bazaude Moodle instalazio honetan sortu dela, edo beharrezko diren Moodle Sareko hostalari guztiak konfiguratuta daudela ziur bazaude, berreskuratzen saia zaitezke.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Oharra:</strong> Segurtasun-kopia honek Moodleren instalazio ezberdin batean du iturburua eta Moodle Sareko urrutiko erabiltzaile-kontuak ditu. Zuk ez duzu berreskuratze-mota hau burutzeko baimenik. Jarri harremanetan guneko kudeatzailearekin edo, bestela, berreskuratu ikastaro hau erabiltzaileen informaziorik (moduluak, fitxategiak...) gabe.';
$string['mnetrestore_extusers_switchuserauth'] = '{$a->username} urrutiko Moodle Sareko erabiltzailea ({$a->mnethosturl}-tik datorrena) {$a->auth} lokalean autentifikatutako erabiltzaile bihurtu da.';
$string['mobilenotconfiguredwarning'] = 'Moodle aplikazioa ez dago gaituta';
$string['modchooserdefault'] = 'Lehenetsitako jarduera-hautatzailea';
$string['modeditdefaults'] = 'Lehenetsitako balioak jardueren ezarpenetarako';
$string['modsettings'] = 'Kudeatu jarduerak';
$string['modulesecurity'] = 'Moduluaren segurtasuna';
$string['moodleapp'] = 'Moodle aplikazioa';
$string['moodleapp_help'] = '<p>Moodle gune batean kontua baduzu, gailu mugikorretan zure ikastaro guztietarako sarbidea izan dezakezu mugikorretarako gure doako aplikazioa erabiliz.</p>
<a href="https://moodle.com/mobile-app">Eskuratu Moodle aplikazioa</a>';
$string['moodlebrandedapp'] = 'Moodle markako aplikazioa';
$string['moodlebrandedapp_help'] = '<p>Moodle markako aplikazioak gure Moodlerako aplikazio librearen funtzionalitate guztiak ditu, zure marka pertsonalizatua ere jasoz.</p>
<a href="https://moodle.com/branded-app">Moodle markako aplikazioari buruz</a>';
$string['moodlebrandedappreference'] = 'Bestela, lortu <a href="https://moodle.com/branded-app/">Moodle markako aplikazioa</a> zure marka pertsonalizatuarekin.';
$string['moodleorghubname'] = 'Moodle';
$string['moodlepartners'] = 'Moodle Bazkideak';
$string['moodlepartners_help'] = '<p>Moodle Bazkideak Moodle HQk egiaztatutako zerbitzu-hornitzaileak dira, zure erakundearen online hezkuntza-ingurunerako goi mailako kalitateko Moodle-zerbitzuak eman ditzaketenak.</p>
<a href="https://moodle.com/about-partners/">Gure Bazkideen zerbitzuez</a><br />
<a href="https://moodle.com/partners">Bilatu bazkide bat</a>';
$string['moodleservices'] = 'Moodle zerbitzuak';
$string['moodleservices_help'] = 'Ziurtatu ezazu zure Moodle hezkuntza-inguruneari etekin handiena ateratzen diozula Moodle-zerbitzu hauek erabiliz:';
$string['multilangforceold'] = 'Behartu sintaxi eleanitz zaharra: &lt;span&gt; etiketa class="multilang" eta &lt;lang&gt; gabe';
$string['mustenablestats'] = 'Estatistikak ez daude gaituta gune honetan.';
$string['mycoursesperpage'] = 'Ikastaro-kopurua';
$string['mydashboard'] = 'Sisteman lehenetsitako aginte-panela';
$string['mymoodle'] = 'Aginte-panela';
$string['mymoodleredirect'] = 'Behartu erabiltzaileak Nire Moodle erabiltzera';
$string['mypage'] = 'Aginte-panel lehenetsia';
$string['mypagelocked'] = 'Blokeatu lehenetsitako orria';
$string['myprofile'] = 'Profil-orri lehenetsia';
$string['navadduserpostslinks'] = 'Gehitu estekak erabiltzailearen mezuak ikusteko';
$string['navadduserpostslinks_help'] = 'Gaituz gero erabiltzaile bakoitzari nabigazioan bi esteka gehituko zaizkio berak gunean edo ikastaro zehatzetan hasitako eztabaidak ikusteko eta mezuak idatzi dituen foroak.';
$string['navcourselimit'] = 'Ikastaro-muga';
$string['navigationupgrade'] = 'Eguneraketa honek bi nabigazio bloke berri sartzen ditu, hurrengo blokeak ordezkatuko dituztenak: Kudeaketa, Ikastaroak, Jarduerak eta Partaideak. Bloke horietan inolako baimen bereziak zehaztu badituzu dena ondo dagoela konprobatu beharko zenuke.';
$string['navshowallcourses'] = 'Erakutsi ikastaro guztiak';
$string['navshowcategories'] = 'Erakutsi ikastaro-kategoriak';
$string['navshowfrontpagemods'] = 'Erakutsi hasiera-orriaren jarduerak nabigazioan';
$string['navshowfrontpagemods_help'] = 'Gaituz gero, hasiera-orriko jarduerak nabigazio blokean erakutsiko dira guneko orrien azpian.';
$string['navshowfullcoursenames'] = 'Erakutsi ikastaroen izen osoak';
$string['navshowfullcoursenames_help'] = 'Gaituz gero, nabigazioan ikastaroen izen osoak erabiliko dira izen laburren ordez.';
$string['navshowmycoursecategories'] = 'Erakutsi nire ikastaro-kategoriak';
$string['navshowmycoursecategories_help'] = 'Gaituz gero, erabiltzaileen Nire Ikastaroak blokean ikastaroak kategorietan erakutsiko dira.';
$string['navsortmycoursessort'] = 'Ordenatu nire ikastaroak';
$string['navsortmycoursessort_help'] = 'Aukera honek zehazten du Nire ikastaroak atalean ikastaroak sailkatze-ordenaren arabera (Gunearen Kudeaketa > Ikastaroak > Kudeatu ikastaroak eta kategoriak atalean zehaztutakoaren arabera) edo alfabetikoki erakutsiko diren.';
$string['never'] = 'Inoiz ez';
$string['neverdeleteruns'] = 'Inoiz ez ezabatu exekuzioak';
$string['newestdocindexed'] = 'Indexatutako dokumentu berriena';
$string['nobookmarksforuser'] = 'Ez duzu inongo markarik.';
$string['nodatabase'] = 'Ez dago datu-baserik';
$string['nohttpsformobilewarning'] = 'HTTPS ziurtagiri onargarri batekin gaitzea gomendatzen da. Moodle aplikazioak lehenik konexio segurua erabiltzen saiatuko da beti.';
$string['nomissingstrings'] = 'Ez da katerik falta';
$string['none'] = 'Bat ere ez';
$string['nonewsettings'] = 'Eguneraketa honetan ez da ezarpen berririk egin.';
$string['nonexistentbookmark'] = 'Eskatutako laster-marka ez dago';
$string['noreplyaddress'] = 'Ez-erantzun helbidea';
$string['noreplydomain'] = 'Ez-erantzun eta domeinua';
$string['noreplydomaindetail'] = 'Ezarpenak ez-erantzun eta konfiguratutako domeinuetarako';
$string['noresults'] = 'Ez da emaitzarik aurkitu.';
$string['noroles'] = 'Rolik ez';
$string['nosupportedlogstore'] = 'Onartzen ez den erregistro-biltegia aurkitu da';
$string['notifications'] = 'Jakinarazpenak';
$string['notifyloginfailures'] = 'Bidali posta elektronikoz huts egindako sarrerak hona:';
$string['notifyloginthreshold'] = 'Posta elektroniko bidezko jakinarazpenetarako sarbidea';
$string['notloggedinroleid'] = 'Gonbidatuen rola';
$string['numberofmissingstrings'] = 'Itzuli gabeko kateen kopurua: {$a}';
$string['numberofstrings'] = 'Kateak denera: {$a->strings}<br />Falta dira: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Zure {$a->siteurl} guneko {$a->issuer} OAuth zerbitzuko freskatze-tokena iraungi da. Honek zerbitzu hori erabiltzen duten pluginen funtzionalitatea mugatuko du. Arazoa konpontzeko, sartu Oauth 2 zerbitzuen ezarpenen orrian eta egin klik taulako zerbitzu horren errenkadan “Konektatu sistemaren kontua” ikonoan. Ziurta ezazu OAuth sisteman sartzen zaren bakoitzean zerbitzuko kontu bera erabiltzen ari zarela.';
$string['oauthrefreshtokenexpiredshort'] = 'Zure {$a->siteurl} guneko {$a->issuer} OAuth freskatze-tokena iraungi da.';
$string['onlynoreply'] = 'Soilik ez-erantzun helbide batetik denean';
$string['opcacherecommended'] = 'PHP opcode cacheak errendimendua hobetzen du eta memoria eskakizunak murrizten ditu. OPcache hedapena gomendatzen da eta erabat sostengatzen da.';
$string['opensslrecommended'] = 'Aukerako OpenSSL liburutegia oso da gomendagarria - Moode Sarearen funtzionamendua gaitzen du.';
$string['opensslrequired'] = 'PHPko OpenSSL hedapena orain beharrezkoa da Moodlen zerbitzu kriptografiko sendoagoak eskaintzeko.';
$string['opentogoogle'] = 'Google-ri zabaldu';
$string['optionalmaintenancemessage'] = 'Mantenuari buruzko aukerazko mezua';
$string['order1'] = 'Lehena';
$string['order2'] = 'Bigarrena';
$string['order3'] = 'Hirugarrena';
$string['order4'] = 'Laugarrena';
$string['outgoingmailconfig'] = 'Kanporako posta elektronikoaren konfigurazioa';
$string['overridetossl'] = 'HTTPS soilik saioa hasteko erabiltzea baztertu egin da. Instantzia honek orain SSL erabiltzea derrigortzen du. Mezu hau ekiditeko, alda ezazu config.php fitxategiko wwwroot aldagaia eta jarri https://';
$string['pageinfodebugsummary'] = 'Orri hau da: {$a}';
$string['passwordchangelogout'] = 'Itxi saioa pasahitza aldatu ondoren';
$string['passwordchangelogout_desc'] = 'Gaituz gero, pasahitz bat aldatzen den bakoitzean nabigatzaile guztietako saioak amaitzen dira, pasahitz berria zehaztu dena izan zenik. (Ezarpen honek ez du eraginik pasahitzak Igo erabiltzaileak funtziotik aldatzen direnean.)';
$string['passwordchangetokendeletion'] = 'Ezabatu web-zerbitzuen sarrera-tokenak pasahitza aldatu ondoren';
$string['passwordchangetokendeletion_desc'] = 'Gaituz gero, pasahitz bat aldatzen den bakoitzean erabiltzailearen web-zerbitzuetako sarrera-tokenak ezabatzen dira.';
$string['passwordpolicy'] = 'Pasahitzen politika';
$string['passwordresettime'] = 'Gehienezko denbora-tartea pasahitza berrezartzeko eskaria balioztatzeko';
$string['passwordreuselimit'] = 'Pasahitzen rotatze-muga';
$string['passwordreuselimit_desc'] = 'Erabiltzaile batek pasahitza aldatu beharreko aldi-kopurua bere pasahitz bat berriz erabili ahal izateko. Aurretik erabilitako pasahitzen hash-ak datu-basean gordetzen dira. Baliteke funtzio hau kanpoko autentifikazio-plugin batzuekin ezin erabiltzea.';
$string['pathtodot'] = 'dot-erako bidea';
$string['pathtodot_help'] = 'dot-erako bidea. Linux-en /usr/bin/dot moduko zerbait izan ohi da. Windows-en C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe moduko zerbait izan ohi da. Mac-en /opt/local/bin/dot moduko zerbait izan ohi da. DOT fitxategietatik grafikoak sortu ahal izateko, dot exekutagarria instalatuta izan eta hemen konfiguratu behar duzu.';
$string['pathtodu'] = 'du-rako bidea';
$string['pathtogs'] = 'ghostscript-erako bidea';
$string['pathtogs_help'] = 'Linux instalazio gehienetan, aukera honetan ‘/usr/bin/gs’ utzi daiteke. Windows-en \'c:\\gs\\bin\\gswin32c.exe\' moduko zerbait izango da (ziurtatu bidean ez dagoela hutsunerik – behar izanez gero kopiatu \'gswin32c.exe\' eta \'gsdll32.dll\' fitxategiak bidean hutsunerik ez duen karpeta berri batera)';
$string['pathtopgdump'] = 'pg_dump-erako bidea';
$string['pathtopgdumpdesc'] = 'Zure sisteman soilik pg_dump bat baino gehiago baduzu sartu behar duzu (adibidez, postgresql-ren bertsio bat baino gehiago badituzu instalatuta).';
$string['pathtopgdumpinvalid'] = 'pg_dump-erako bide ez egokia: ez da zuzena edo ezin da exekutatu.';
$string['pathtophp'] = 'PHP CLIrako bidea';
$string['pathtopsql'] = 'psql-rako bidea';
$string['pathtopsqldesc'] = 'Zure sisteman soilik psql bat baino gehiago baduzu da beharrezkoa hau (adibidez, postgresql-ren bertsio bat baino gehiago baduzu instalatuta).';
$string['pathtopsqlinvalid'] = 'psql-rako bideak ez du balio: akatsa du edo ezin da exekutatu.';
$string['pathtopython'] = 'Python-erako  bidea';
$string['pathtopythondesc'] = 'Zure Python exekutagarri bitarrerako bidea (bai Python 2 zein Pyhton 3 onartzen dira).';
$string['pathtosassc'] = 'SassCerako bidea';
$string['pathtosassc_help'] = 'SassC bitarraren kokapena zehaztuta SASS konpilatzailearen Moodleren PHP inplementaziotik SassC-ra aldatuko du. Informazio gehiagorako https://github.com/sass/sassc ikusi ezazu.';
$string['pcreunicodewarning'] = 'Unicode karaktereekin bateragarria den PHPko PCRE hedapena instalatzea irmoki gomendatzen da.';
$string['perfdebug'] = 'Errendimendu-informazioa';
$string['performance'] = 'Errendimendua';
$string['pgcluster'] = 'PostgreSQL Clusterra';
$string['pgclusterdescription'] = 'Komando-lerro eragiketetarako PostgreSQL bertsio/clusterraren parametroa. Zure sisteman postgresql bakarra baduzu edo ez badakizu zer den hau, hutsik utzi.';
$string['phpfloatproblem'] = 'Ezusteko arazoa gertatu da PHPko float zenbakiak kudeatzean - {$a}';
$string['pleaserefreshregistration'] = 'Zure gunea erregistratuta dago. Erregistroa {$a}-n eguneratu zen azkenekoz.<br />Programatutako \'Gunearen erregistroa\' zereginak zure erregistroa eguneratuta mantentzen du. Edozein unetan erregistroa eskuz ere egunera dezakezu.';
$string['pleaserefreshregistrationnewdata'] = 'Erregistroko informazioa aldatu da. Mesedez, konfirma ezazu ‘Eguneratu erregistroa’ botoian klik eginda.';
$string['pleaserefreshregistrationunknown'] = 'Zure gunea erregistratu da baina erregistro-data ezezaguna da. Mesedez, eguneratu zure erregistroa ‘Eguneratu erregistroa’ botoiaren bitartez edo ziurtatu ‘Gunearen erregistroa’ programatutako zeregina gaituta dagoela erregistroa automatikoki eguneratzeko.';
$string['plugin'] = 'Plugina';
$string['plugins'] = 'Pluginak';
$string['pluginscheck'] = 'Egiaztatu pluginen menpekotasuna';
$string['pluginscheckfailed'] = 'Menpekotasun egiaztapenak huts egin du hurrengo hauetan: {$a->pluginslist}';
$string['pluginschecktodo'] = 'Plugin guztien betebeharrak konpondu behar dituzu Moodle bertsio hau instalatzen jarraitu baino lehen!';
$string['pluginsoverview'] = 'Pluginen ikuspegi orokorra';
$string['pluginsoverviewsee'] = 'Ikusi <a href="{$a->url}">pluginen ikuspegi orokorra</a> orria xehetasun gehiagotarako.';
$string['policysettings'] = 'Politikaren ezarpenak';
$string['privacyandpolicies'] = 'Pribatutasuna eta politikak';
$string['privacy:metadata'] = 'Kudeaketa pluginak ez du datu pertsonalik biltzen.';
$string['privacysettings'] = 'Pribatutasun-ezarpenak';
$string['profilecategory'] = 'Kategoria';
$string['profilecategoryname'] = 'Kategoriaren izena (bakarra izan behar du)';
$string['profilecategorynamenotunique'] = 'Kategoria-izen hau dagoeneko erabiltzen ari da';
$string['profilecommonsettings'] = 'Ezarpen komunak';
$string['profileconfirmcategorydeletion'] = '{$a} eremu daude kategoria honetan eta goragoko kategoriara eramango dira (edo beheragokora goragokoan badaude). <br/> Oraindik ere kategoria hau ezabatu egin nahi al duzu?';
$string['profileconfirmfielddeletion'] = '{$a} erabiltzaile-erregistro daude eremu honetarako eta ezabatu egingo dira. <br/> Oraindik ere eremu hau ezabatu egin nahi al duzu?';
$string['profilecreatecategory'] = 'Sortu profil-kategoria berria';
$string['profilecreatefield'] = 'Sortu profilaren eremu berria';
$string['profilecreatenewcategory'] = 'Kategoria berria sortzen';
$string['profilecreatenewfield'] = '"{$a}" profil-eremu berria sortzen';
$string['profiledefaultcategory'] = 'Beste eremu batzuk';
$string['profiledefaultchecked'] = 'Markatuta modu lehenetsian';
$string['profiledefaultdata'] = 'Lehenetsitako balioa';
$string['profiledeletecategory'] = 'Kategoria ezabatzen';
$string['profiledeletefield'] = '\'{$a}\' eremua ezabatzen';
$string['profiledescription'] = 'Eremuaren deskribapena';
$string['profiledscript'] = 'Script hau profilatua izan da';
$string['profiledscriptview'] = 'Ikusi script honentzako profilatze-informazioa';
$string['profileeditcategory'] = '{$a} kategoria editatzen';
$string['profileeditfield'] = '{$a} profil-eremua editatzen';
$string['profilefield'] = 'Profil-eremua';
$string['profilefieldcolumns'] = 'Zutabeak';
$string['profilefieldispassword'] = 'Pasahitzerako eremua al da hau?';
$string['profilefieldlink'] = 'Esteka';
$string['profilefieldlink_help'] = 'Testua esteka bihurtzeko, idatzi $$ duen URLa, zeinetan $$ testuak ordezkatuko duen. Adibidez, Twitter ID bat esteka bihurtzeko, idatzi https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Estekaren helmuga';
$string['profilefieldmaxlength'] = 'Gehienezko luzera';
$string['profilefieldrows'] = 'Errenkadak';
$string['profilefields'] = 'Erabiltzaile-profilaren eremuak';
$string['profilefieldsize'] = 'Erakutsi tamaina';
$string['profileforceunique'] = 'Datuak bakarrak izan behar al dira?';
$string['profileinvaliddata'] = 'Balio ezegokia';
$string['profilelocked'] = 'Eremu hau blokeatuta al dago?';
$string['profilemenudefaultnotinoptions'] = 'Lehenetsitako balioa ez dago aukeren artean';
$string['profilemenunooptions'] = 'Ez dago menu-aukerarik';
$string['profilemenuoptions'] = 'Menu-aukerak (bat lerroko)';
$string['profilemenutoofewoptions'] = 'Gutxienez bi aukera eman behar dituzu';
$string['profilename'] = 'Izena';
$string['profilenofieldsdefined'] = 'Ez dago definitutako eremurik';
$string['profilerequired'] = 'Beharrezkoa al da eremu hau?';
$string['profileroles'] = 'Ikus daitezkeen profilen rolak';
$string['profilesforenrolledusersonly'] = 'Profilak soilik matrikulatutako erabiltzaileentzako';
$string['profileshortname'] = 'Izen laburra (bakarra izan behar du)';
$string['profileshortnameinvalid'] = 'Izen labur honek soilik karaktere alfanumerikoak (letra eta zenbakiak) eta marratxo baxua (_) eduki ditzake.';
$string['profileshortnamenotunique'] = 'Izen labur hau dagoeneko erabiltzen ari da';
$string['profilesignup'] = 'Orria erakutsi behar da saioa hastean?';
$string['profilespecificsettings'] = 'Ezarpen espezifikoak';
$string['profilevisible'] = 'Zeinek ikus dezake eremu hau?';
$string['profilevisibleall'] = 'Edozeinentzako ikusgai';
$string['profilevisible_help'] = '* Ez ikusgai - soilik kudeatzaileak ikusteko datu pribatuetarako.
* Erabiltzailearentzako ikusgai - soilik kudeatzaileak eta erabiltzaileak ikusteko datu pribatuetarako.
* Edozeinentzako ikusgai';
$string['profilevisiblenone'] = 'Ez ikusgai';
$string['profilevisibleprivate'] = 'Erabiltzailearentzako ikusgai';
$string['profiling'] = 'Profilatzea';
$string['profilingallowall'] = 'Profilatze jarraia';
$string['profilingallowall_help'] = 'Ezarpen hau gaitzen baduzu, edozein unetan PROFILEALL parametroa edonon (PGC) erabili ahal izango duzu Moodle saioak iraun bitartean exekutatutako script guztien profilatzea gaitzeko. Modu berean, PROFILEALLSTOP parametroa erabili ahalko duzu profilatzea geratzeko.';
$string['profilingallowme'] = 'Profilatzen selektiboa';
$string['profilingallowme_help'] = 'Ezarpen hau gaitzen baduzu, modu selektiboan PROFILEME parametroa edonon (PGC) erabili ahalko duzu exekutatuko den script hori profilatzeko. Modu berean, DONTPROFILEME parametroa erabili ahalko duzu profilatzea egin ez dadin.';
$string['profilingautofrec'] = 'Profil automatikoak';
$string['profilingautofrec_help'] = 'Ezarpen hau konfiguratuta, eskaera batzuk (ausaz, 1 eta N bitartean zehaztutako maiztasunarekin) profilatuak izateko aukeratuak izango dira, eta emaitzak aurreragoko aztertzeko gordeko dira. Kontuan izan mota honetako profilatzeak gehitu/kendu ezarpenak ikuskatzen dituela. O jarri profilatze automatikoa desgaitzeko.';
$string['profilingenabled'] = 'Gaitu profilak';
$string['profilingenabled_help'] = 'Ezarpen hau gaituz gero, profilatzea gune honetan eskuragarri egongo da eta bere portaera hurrengo aukeretan zehaztu ahal izango duzu.';
$string['profilingexcluded'] = 'Baztertu profilak';
$string['profilingexcluded_help'] = '\'Hauek profilatu’ ezarpenean zehaztutako profilatzetik kanpo utziko diren URLen zerrenda (komaz banatuta, wwwroot erabat saihestuz, eskuragarri).';
$string['profilingimportprefix'] = 'Profilak inportatzeko aurrizkia';
$string['profilingimportprefix_desc'] = 'Errazago antzemateko, inportatutako profilatze-exekuzioari hemen zehaztutako aurrizkia jarriko zaie.';
$string['profilingincluded'] = 'Profilatu hauek';
$string['profilingincluded_help'] = 'Automatikoki profilatuko diren URLen zerrenda (komaz banatuta, wwwroot erabat saihestuz, eskuragarri). Adibideak: /index.php, /course/view.php. * komodina ere edozein kokapenetan erabili daiteke. Adibideak:  /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Mantendu profilatze-exekuzioak';
$string['profilinglifetime_help'] = 'Zehaztu profilatze-exekuzio zaharretako informazioa mantendu nahi duzun denbora. Zaharrenak automatikoki ezabatuko dira. Kontuan izan honek ‘reference run’ gisa markatutako edozein profilatze-exekuzio alde batera utziko duela.';
$string['protectusernames'] = 'Babestu erabiltzaile-izenak';
$string['proxybypass'] = 'Proxy-a saihesten duten hostalariak';
$string['proxyhost'] = 'Proxy ostalaria';
$string['proxypassword'] = 'Proxy pasahitza';
$string['proxyport'] = 'Proxy portua';
$string['proxytype'] = 'Proxy mota';
$string['proxyuser'] = 'Proxy erabiltzaile-izena';
$string['purgecaches'] = 'Ezabatu cache guztiak';
$string['purgecachesconfirm'] = 'Moodlek katxean gorde ditzake itxura, javascript, hizkuntza-kate, iragazitako testu, RSS jario eta beste datu asko. Datu horiek zerbitzarian arazteak bezeroen nabigatzaileak informazioa eguneratzera behartuko ditu eta ziurtatu egingo duzu, horrela, erabiltzaileek azken aldaketak dituen informazioa ikusiko dutela. Hau egiteak ez dakar inongo arriskurik, baina hasieran gunea makalago dabilela eman dezake, zerbitzariak eta bezeroek informazioa berriz eguneratu eta datuak katxean gorde arte.';
$string['purgecachesfinished'] = 'Cache guztiak ezabatu dira.';
$string['purgecachesnoneselected'] = 'Aukeratu ezabatzeko cache baten bat';
$string['purgecachespage'] = 'Ezabatu cacheak';
$string['purgefiltercache'] = 'Testu-iragazkiak';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Hizkuntza-kateak';
$string['purgemuc'] = 'MUC cache guztiak';
$string['purgeothercaches'] = 'Fitxategien eta bestelakoen cacheak';
$string['purgeselectedcaches'] = 'Ezabatu aukeratutako cacheak';
$string['purgeselectedcachesfinished'] = 'Aukeratutako cacheak ezabatu dira.';
$string['purgethemecache'] = 'Itxurak';
$string['query'] = 'Kontsulta';
$string['question'] = 'Galdera';
$string['questionbehaviours'] = 'Galderen jokaerak';
$string['questioncwqpfscheck'] = 'Galdetegi bateko \'ausazko\' galdera bat edo beste elkarbanatutako eta elkarbanatugabeko galdera-kategoria multzo batetik aukeratzeko ezarrita daude. Txosten zehatzagoa ikus dezakezu <a href="{$a->reporturl}">hemen</a>  eta Moodle Doc-etako orria  <a href="{$a->docsurl}">hemen</a>.';
$string['questioncwqpfsok'] = 'Ondo. Ez dago zure galdetegietan \'ausazko\' galdera bat edo beste elkarbanatutako eta elkarbanatugabeko galdera-kategoria multzo batetik aukeratzeko ezarrita.';
$string['questiontype'] = 'Galdera-mota';
$string['questiontypes'] = 'Galdera-motak';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1-ean galderen eguneraketa handi bat egin zen. Datu-basearen eguneraketen atal bat beranduago exekutatzeko atzera zitekeen.Moodle 2.7-ra eguneratu baino lehen eguneraketa hori osatu behar da.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA-rako gako sekretua';
$string['recaptchapublickey'] = 'ReCAPTCHA-rako guneko gakoa';
$string['register'] = 'Erregistratu zure gunea';
$string['registermoodlenet'] = '<p>Zurekin harremanetan egotea eta zure Moodle gunerako gauza garrantzitsuak eskaintzea gustatuko litzaiguke!</p>
<p>Erregistratuz gero:</p>
<ul><li>Moodle bertsio berrien kaleratzeen, segurtasun-alerten eta bestelako berri garrantzitsuen jakinarazpenak jasotzeko harpidetu zaitezke.</li>
<li>Zure Moodle gunerako mugikorrentzako push jakinarazpenak gaitu ditzakezu gure doako <a href="https://download.moodle.org/mobile/">Moodle app</a>-aren bidez.</li>
<li>Gure mundu mailako komunitatearen <a href="https://moodle.net/stats/">Moodle estatistikei</a> ekarpena egingo diezu, Moodle eta gure komunitateen guneak hobetzen laguntzen diguna.</li>
<li>Nahi baduzu, gunea zure herrialdeko <a href="https://moodle.net/sites/">erregistratutako Moodle guneen zerrendan</a> gehitu daiteke ere.</li></ul>';
$string['registermoodleorg'] = 'Zure gunea erregistratzean';
$string['registermoodleorgli1'] = 'Bolumen gutxiko posta-zerrenda batean gehituko zaizu jakinarazpen garrantzitsuak jasotzeko, hala nola segurtasun-abisuak eta Moodleko bertsio berrien kaleratzea.';
$string['registermoodleorgli2'] = 'Zure gunearen estatistikak mundu osoko Moodle komunitatera gehituko dira {$a}.';
$string['registerwithmoodleorg'] = 'Erregistratu zeure gunea';
$string['registration'] = 'Erregistroa';
$string['registration_help'] = 'Erregistratuz gero:

* Segurtasun-abisuak jasoko dituzu
* Zure guneko Moodle aplikazioarentzako push jakinarazpenak gaitu ahal izango dituzu
* Mundu mailako gure Moodle komunitatearen estatistikei ekarpena egingo diezu';
$string['registrationwarning'] = 'Zure gunea oraindik ez dago erregistratuta.';
$string['registrationwarningcontactadmin'] = 'Zure gunea oraindik ez dago erregistratuta. Mesedez jarri harremanetan zure kudeatzailearekin.';
$string['releasenoteslink'] = 'Moodleren bertsio honi buruzko informazioa nahi baduzu, mesedez begiratu <a target="_new" href="{$a}">Bertsio-kaleratze oharrak</a>';
$string['rememberusername'] = 'Gogoratu erabiltzaile-izena';
$string['rememberusername_desc'] = 'Gaitu erabiltzaileen cookie iraunkorrak gorde nahi badituzu erabiltzailea barruan dagoen bitartean. Cookie iraunkorrak pribatutasun arazo gisa ikusiak izan daitezke baimenik gabe erabiliz gero.';
$string['reportsmanage'] = 'Kudeatu txostenak';
$string['requestcategoryselection'] = 'Gaitu kategoria-aukeraketa';
$string['requiredentrieschanged'] = 'Oharra: Eguneraketaren ondoren, \'Ikusi aurretiko beharrezko sarrerak\' ezarpena behartutakoa izango da hurrengo datu-base jardueretan:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Behartu jardueraren deskribapena';
$string['requiremodintro_desc'] = 'Gaituz gero, erabiltzaileek jarduera bakoitzaren deskribapena idatzi beharko dute.';
$string['requires'] = 'Beharrezkoa';
$string['restorecourse'] = 'Berreskuratu ikastaroa';
$string['restorernewroleid'] = 'Berreskuratze rola ikastaroetan';
$string['restorernewroleid_help'] = 'Erabiltzaileak aurretik ez badu berreskuratu berri duen ikastaroa kudeatzeko baimenik, erabiltzaileari automatikoki rol hau esleitzen zaio eta behar izanez gero matrikulatzen zaio. Aukeratu ‘Bat ere ez’ ez baduzu nahi ikastaroak berreskuratzen dutenek berreskuratutako ikastaro guztiak kudeatzeko baimenik izatea.';
$string['reverseproxy'] = 'Alderantzizko proxy-a';
$string['reverseproxyignore'] = 'Ezikusi alderantzizko proxy-ak';
$string['riskconfig'] = 'Erabiltzaileek gunearen konfigurazioa eta ezarpenak alda litzakete';
$string['riskconfigshort'] = 'Ezarpen-arriskua';
$string['riskdataloss'] = 'Erabiltzaileek eduki edo informazio atal asko desegin dezakete';
$string['riskdatalossshort'] = 'Datuak galtzeko arriskua';
$string['riskmanagetrust'] = 'Erabiltzaileek beste erabiltzaileen konfiantza-ezarpenak alda litzakete';
$string['riskmanagetrustshort'] = 'Kudeatu konfiantzak';
$string['riskpersonal'] = 'Erabiltzaileek beste erabiltzaile batzuen informazio pribatua lor lezakete.';
$string['riskpersonalshort'] = 'Pribatutasun-arriskuak';
$string['riskspam'] = 'Erabiltzaileek \'spam\'a bidal liezaiekete guneko erabiltzaileei edo beste batzuei';
$string['riskspamshort'] = 'Spam arriskua';
$string['riskxss'] = 'Erabiltzaileek gunean zeharreko \'scripting\'erako (XSS)aukera ematen duen fitxategi eta testuak gainera litzakete';
$string['riskxssshort'] = 'XSS arriskua';
$string['roleswithexceptions'] = '{$a->roles}, {$a->exceptions} -(ar)ekin';
$string['rssglobaldisabled'] = 'Desgaituta gunearen mailan';
$string['save'] = 'Gorde';
$string['savechanges'] = 'Gorde aldaketak';
$string['scssinvalid'] = 'SCSS kodea ez da baliozkoa, errorea ematen du honekin: {$a}';
$string['search'] = 'Bilatu';
$string['searchallavailablecourses'] = 'Bila daitezkeen ikastaroak';
$string['searchallavailablecourses_desc'] = 'Baliteke egoera batzuetan bilatze-motorra ondo ez funtzionatzea ikastaro askotan zehar bilaketak egitean. Ezarri matrikulatutako ikastaroetan soilik bilatzea bilatutako ikastaroen kopurua murriztu nahi baduzu.';
$string['searchallavailablecourses_off'] = 'Bilatu soilik matrikulatutako ikastaroen barruan';
$string['searchallavailablecourses_on'] = 'Bilatu erabiltzaileak sarbidea duen ikastaro guztietan';
$string['searchalldeleted'] = 'Indexatutako eduki guztiak ezabatu dira.';
$string['searchareadisabled'] = 'Bilaketa-eremua desgaitu da';
$string['searchareaenabled'] = 'Bilaketa-eremua gaitu da';
$string['searchareas'] = 'Bilaketa-eremuak';
$string['searchdeleteindex'] = 'Ezabatu indexatutako eduki guztiak';
$string['searchengine'] = 'Bilatzailea';
$string['searchindexactions'] = 'Ekintzak indexatu';
$string['searchindexdeleted'] = 'Indizea ezabatu da';
$string['searchindextime'] = 'Indexatzearen denbora-muga';
$string['searchindextime_desc'] = 'Eduki berri asko indexatzean programatutako zeregina denbora tarte hau igaro ondoren geratuko da. Zeregina exekutatzen den hurrengo aldian jarraituko du.';
$string['searchindexupdated'] = 'Bilatzailearen edukiak eguneratu dira';
$string['searchindexwhendisabled'] = 'Indexatu desgaituta dagoenean';
$string['searchindexwhendisabled_desc'] = 'Programatutako zereginak indizeak eraikitzea ahalbidetzen du bilaketak desgaituta egonda ere. Hau erabilgarria da ikasleei bilatzeko aukera eman aurretik indizeak eraiki nahi badituzu.';
$string['searchinsettings'] = 'Bilatu ezarpenetan';
$string['searchlastrun'] = 'Azken exekutatzea (denbora, dokumentu kopurua, erregistro kopurua, ezikusitakoen kopurua)';
$string['searchnotavailable'] = 'Bilaketa ez dago eskuragarri';
$string['searchoptions'] = 'Bilaketa-aukerak';
$string['searchpartial'] = '(oraindik guztiz indexatu gabe)';
$string['searchreindexed'] = 'Guneko eduki guztiak berriz indexatu dira.';
$string['searchreindexindex'] = 'Berriz indexatu guneko eduki guztiak';
$string['searchresults'] = 'Bilaketaren emaitzak';
$string['searchsetupinfo'] = 'Bilatze-ezarpenak';
$string['searchupdateindex'] = 'Eguneratu indexatutako edukiak';
$string['sectionerror'] = 'Errorea atalean!';
$string['secureforms'] = 'Erabili segurtasun-formulario gehigarria';
$string['security'] = 'Segurtasuna';
$string['selectdevice'] = 'Aukeratu gailua';
$string['selectsearchengine'] = 'Aukeratu bilatzailea';
$string['selecttheme'] = 'Aukeratu itxura {$a} gailurako';
$string['server'] = 'Zerbitzaria';
$string['serverchecks'] = 'Zerbitzariaren egiaztatzeak';
$string['serverlimit'] = 'Zerbitzariaren muga';
$string['sessionautostartwarning'] = '<p>Ezarpenetan garrantzizko errorea aurkitu da. Mesedez, jakinarazi zerbitzariaren kudatzaileari.</p><p> Ondo aritzeko, Moodlek beharrezkoa du kudeatzaileak  PHP ezarpenak aldatzea.</p><p><code>session.auto_start</code> -k honela behar du egon ezarrita: <code>off</code>.</p><p>Ezarpen hau zerbitzariko <code>php.ini</code> editatuz, Apache/IIS <br /> ezarpenen bitartez edo <code>.htaccess</code> fitxategiarekin kontrolatzen da.</p>';
$string['sessioncookie'] = 'Cookie-aren aurrizkia';
$string['sessioncookiedomain'] = 'Cookie-n domeinua';
$string['sessioncookiepath'] = 'Cookie-bidea';
$string['sessionhandling'] = 'Saioaren kudeaketa';
$string['sessiontimeout'] = 'Gehienezko denbora';
$string['settingfileuploads'] = 'Fitxategi-eguneraketa beharrezkoa da eragiketa normalerako; mesedez, gaitu hori PHP ezarpenetan.';
$string['settingmemorylimit'] = 'Memoria gutxiegi aurkitu da; mesedez, handitu memoriaren muga PHP ezarpenetan.';
$string['settingsafemode'] = 'Moodle ez da bateragarria modu seguruarekin; mesedez, eskatu kudeatzaileari itzaltzeko. Moodle modu seguruan aritzea ez da onartzen; hainbat arazo espero izatekoak dira.';
$string['setupsearchengine'] = 'Konfiguratu bilatzailea';
$string['showcommentscount'] = 'Erakutsi iruzkin-kopurua';
$string['showdetails'] = 'Erakutsi xehetasunak';
$string['showuseridentity'] = 'Erakutsi erabiltzailearen identitatea';
$string['showuseridentity_desc'] = 'Erabiltzaileak aukeratu edo bilatzean, eta erabiltzaileen zerrenda erakusterakoan, eremu hauek euren izen osoarekin batera erakutsi daitezke. Eremuok soilik moodle/site:viewuseridentity gaitasuna duten erabiltzaileei erakusten zaizkie; modu lehenetsian, irakasle eta kudeatzaileei. (Aukera honek zentzua du zure erakundeak beharrezkoak diren eremu bat edo bi aukeratzen badituzu.)';
$string['simplexmlrequired'] = 'Moodlek orain beharrezkoa du SimpleXML PHP hedapena';
$string['sitemailcharset'] = 'Karaktere-multzoa';
$string['sitemaintenance'] = 'Gune hau mantenuan dago eta oraingoz ez da eskuragarria';
$string['sitemaintenancemode'] = 'Mantenu-modua';
$string['sitemaintenanceoff'] = 'Mantenu-modua ez dago indarrean eta gunea berriro normaltasunez funtzionatzen ari da';
$string['sitemaintenanceon'] = 'Gunea mantenu-moduan dago (sarbidea kudeatzaileek dute soilik).';
$string['sitemaintenanceoncli'] = 'Zure gunea  CLI mantenu-moduan dago, ez da web bidezko sarbiderik onartzen.';
$string['sitemaintenancewarning'] = 'Gunea mantenu-moduan dago (sarbidea kudeatzaileek dute soilik). Berriro martxan jartzeko, <a href="maintenance.php">mantenu-modua desaktibatu</a>.';
$string['sitemaintenancewarning2'] = 'Zure gunea une honetan mantenu-moduan dago (kudeatzaileek baino ezin dute saioa hasi). Gune hau egoera normalera itzultzeko, <a href="{$a}">mantenu-modua desgaitu</a>.';
$string['sitemenubar'] = 'Guneko nabigazioa';
$string['sitepolicies'] = 'Gunearen segurtasun-ezarpenak';
$string['sitepolicy'] = 'Guneko politikaren URLa';
$string['sitepolicyguest'] = 'Guneko politikaren URLa bisitarientzako';
$string['sitepolicyguest_help'] = 'Gonbidatu guztiek gunean sartu aurretik ikusi eta onartu behar duten gunearen politikaren URLa. Kontuan izan ezarpen honek soilik izango duela eragina guneko politika-kudeatzaileak \'Lehenetsitakoa (sistema)\' balioa badu.';
$string['sitepolicyhandler'] = 'Guneko politiken kudeatzailea';
$string['sitepolicyhandlercore'] = 'Lehenetsitakoa (sistema)';
$string['sitepolicyhandler_desc'] = 'Honek politikak eta erabiltzaile-onespenak nola kudeatuko diren zehazten du. Lehenetsitakoa (sistema) kudeatzaileak guneko politikaren URLa eta gonbidatuentzako guneko politikaren URLa zehazteko aukera ematen du. Politikak kudeatzaileak guneko, pribatutasun eta bestelako politikak zehazteko aukera ematen du. Erabiltzaile-onespenak ikustea ere ahalbidetzen du eta, beharrezkoa bada, adingabekoen izenean onespena emateko aukera ere bai.';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitepolicy_help'] = 'Guneko erabiltzaile guztiek gunean sartu aurretik ikusi eta onartu behar duten gunearen politikaren URLa. Kontuan izan ezarpen honek soilik izango duela eragina guneko politika-kudeatzaileak \'Lehenetsitakoa (sistema)\' balioa badu.';
$string['sitesectionhelp'] = 'Aukeratuz gero, atal bat erakutsiko da gunearen azalean.';
$string['sixtyfourbitswarning'] = 'Zure guneak 64-bitekoa ez den PHP bertsioa erabiltzen ari dela antzeman da. Etorkizuneko bateragarritasuna bermatze aldera, zure gunea eguneratzea gomendatzen da.';
$string['slasharguments'] = 'Erabili "slash" argumentuak';
$string['slashargumentswarning'] = 'Slash argumentuak gaituta egotea gomendatzen da. Etorkizunean derrigorrezkoa izango da. Xehetasun gehiago izateko ikusi <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Slash argumentuak erabiltzen</a>.';
$string['smartpix'] = 'Bilatu smart pix';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP autentifikazio-mota';
$string['smtpdetail'] = 'Simple Mail Transfer Protocol (SMTP) ezarpenak bidaltzen diren e-mailetarako';
$string['smtphosts'] = 'SMTP ostalariak';
$string['smtpmaxbulk'] = 'SMTP saiorako muga';
$string['smtppass'] = 'SMTP pasahitza';
$string['smtpsecure'] = 'SMTP segurtasuna';
$string['smtpuser'] = 'SMTP erabiltzaile-izena';
$string['soaprecommended'] = 'SOAP hedapena instalatzea erabilgarria da web-zerbitzu eta plugin batzuentzat.';
$string['sort_fullname'] = 'Ikastaroaren izen osoa';
$string['sort_idnumber'] = 'Ikastaroaren ID zenbakia';
$string['sort_shortname'] = 'Ikastaroaren izen laburra';
$string['sort_sortorder'] = 'Sailkatze-ordena';
$string['spellengine'] = 'Motor ortografikoa';
$string['spelllanguagelist'] = 'Hizkuntza-zerrenda';
$string['splrequired'] = 'Moodlek orain SPL PHP hedapena beharrezkoa du.';
$string['stats'] = 'Estatistikak';
$string['statsfirstrun'] = 'Prozesamenduaren gehienezko tartea';
$string['statsmaxruntime'] = 'Egikaritzeko gehienezko denbora';
$string['statsmoodleorg'] = 'estatistikak';
$string['statsruntimedays'] = 'Prozesatzeko egunak';
$string['statsruntimestart'] = 'Exekutatu hemen';
$string['statsuserthreshold'] = 'Erabiltzaile-atalasea';
$string['stickyblocks'] = 'Bloke finkoak';
$string['stickyblockscourseview'] = 'Ikastaroaren orria';
$string['stickyblocksduplicatenotice'] = 'Hemen gehitzen duzun edozein bloke orri jakin batean jadanik indarrean badago, emaitza kopia bikoiztua izango da.<br />gehitutako blokea ezingo da editatu, bikoiztutakoa editagarria izango den bitartean.';
$string['stickyblocksmymoodle'] = 'Nire Moodle';
$string['stickyblockspagetype'] = 'Konfiguratu beharreko orri-mota';
$string['strictformsrequired'] = 'Beharrezko eremuen balidatze zorrotza';
$string['stripalltitletags'] = 'Ezabatu HTML etiketak jarduera-izen guztietatik';
$string['supportcontact'] = 'Laguntzarako kontaktua';
$string['supportemail'] = 'Laguntzarako helbide elektronikoa';
$string['supportname'] = 'Laguntzarako izena';
$string['supportpage'] = 'Laguntzarako orria';
$string['suspenduser'] = 'Eten erabiltzailearen kontua';
$string['switchlang'] = 'Aldatu hizkuntzaren direktorioa';
$string['systempaths'] = 'Sistemaren bideak';
$string['tablenosave'] = 'Goiko taulako aldaketak automatikoki gordetzen dira.';
$string['tablesnosave'] = 'Goiko tauletako aldaketak automatikoki gorde dira.';
$string['tabselectedtofront'] = 'Fitxak dituzten tauletan, une bakoitzean aukeratutako fitxa duen errenkada hasieran egon beharko lukeen edo ez';
$string['tabselectedtofronttext'] = 'Aukeratutako leihatila-ilada ipini lehengoa';
$string['taskanalyticscleanup'] = 'Analitiken garbiketa';
$string['taskautomatedbackup'] = 'Segurtasun-kopia automatizatuak';
$string['taskbackupcleanup'] = 'Garbitu segurtasun-kopiak eta agerraldiak';
$string['taskbadgescron'] = 'Eman dominak';
$string['taskblogcron'] = 'Sinkronizatu kanpoko blogak';
$string['taskcachecleanup'] = 'Ezabatu iraungitako cache sarrerak';
$string['taskcachecron'] = 'Cache-en atzeko planoko prozesatzea';
$string['taskcalendarcron'] = 'Bidali egutegiaren jakinarazpenak';
$string['taskcheckforupdates'] = 'Egiaztatu eguneraketak';
$string['taskcompletiondaily'] = 'Osatze-marka hasitako bezala';
$string['taskcompletionregular'] = 'Kalkulatu osatze datu arruntak';
$string['taskcontextcleanup'] = 'Garbitu testuinguruak';
$string['taskcreatecontexts'] = 'Sortu falta diren testuinguruak';
$string['taskdeletecachetext'] = 'Ezabatu iraungitako testu-cache erregistroak';
$string['taskdeleteincompleteusers'] = 'Ezabatu osatu gabeko erabiltzaieak';
$string['taskdeleteunconfirmedusers'] = 'Ezabatu kontua egiaztatu gabeko erabiltzaileak';
$string['taskeventscron'] = 'Ekitaldien atzeko planoko prozesatzea';
$string['taskfiletrashcleanup'] = 'Zakarrontzian dauden fitxategien garbiketa';
$string['taskglobalsearchindex'] = 'Bilaketa globalerako indexatzea';
$string['taskglobalsearchoptimize'] = 'Bilaketa globalaren indexatze-optimizazioa';
$string['taskgradecron'] = 'Kalifikazio-liburuaren atzeko planoko prozesatzea';
$string['tasklegacycron'] = 'Pluginen zaharkitutako cron-aren prozesatzea';
$string['taskmessagingcleanup'] = 'Mezularitzaren atzeko planoko prozesatzea';
$string['taskpasswordresetcleanup'] = 'Garbitu pasahitza berrezartzeko saiakerak';
$string['taskplagiarismcron'] = 'Plagio-pluginen zaharkitutako cron-aren atzeko planoko prozesatzea';
$string['taskportfoliocron'] = 'Portfolio-pluginen atzeko planoko prozesatzea';
$string['taskquestioncron'] = 'Galdera-motorraren atzeko planoko prozesatzea';
$string['taskrefreshsystemtokens'] = 'Freskatu zerbitzu-kontuen OAuth tokenak';
$string['taskregistrationcron'] = 'Gunearen erregistroa';
$string['tasksendfailedloginnotifications'] = 'Bidali huts egindako sarrera saiakeren jakinarazpenak';
$string['tasksendnewuserpasswords'] = 'Bidali erabiltzaile berrien pasahitzak';
$string['tasksessioncleanup'] = 'Saio zaharren garbiketa';
$string['taskstatscron'] = 'Estatistiken atzeko planoko prozesatzea';
$string['tasktagcron'] = 'Etiketen atzeko planoko prozesatzea';
$string['tasktempfilecleanup'] = 'Ezabatu behin-behineko stale fitxategiak';
$string['tempdatafoldercleanup'] = 'Garbitu data hau baino zaharragoak diren behin-behineko datuetako fitxategiak:';
$string['testsiteupgradewarning'] = 'Une honetan probetarako {$a} gunea erabiltzen ari zara, modu egokian eguneratzeko erabili komando lerroko interfazea';
$string['themedesignermode'] = 'Itxura-diseinatzaile modua';
$string['themedesignermodewarning'] = 'Itxura-diseinatzaile modua gaituta dago. Hau ez litzateke lanean dauden guneetan gaituta egon beharko errendimendua nabarmenki kaltetu dezakeelako.';
$string['themelist'] = 'Itxuren zerrenda';
$string['themenoselected'] = 'Ez da itxura aukeratu';
$string['themeresetcaches'] = 'Garbitu itxuren cache-ak';
$string['themeselect'] = 'Aldatu itxura';
$string['themeselector'] = 'Itxura-hautatzailea';
$string['themesettings'] = 'Itxuraren ezarpenak';
$string['therewereerrors'] = 'Zure datuetan erroreak daude';
$string['thirdpartylibrary'] = 'Liburutegia';
$string['thirdpartylibrarylocation'] = 'Kokapena';
$string['thirdpartylibs'] = 'Hirugarrenen liburutegiak';
$string['timezone'] = 'Lehenetsitako ordu eremua';
$string['timezoneforced'] = 'Aukera hau gunearen administratzaileak behartu egin du';
$string['timezoneinvalid'] = 'Ordu eremu baliogabea "{$a}"';
$string['timezoneisforcedto'] = 'Behartu erabiltzaile guztiak erabiltzera';
$string['timezonenotforced'] = 'Erabiltzaileek euren ordu eremua aukera dezakete';
$string['timezonephpdefault'] = 'Lehenetsitako PHP ordu eremua ({$a})';
$string['timezoneserver'] = 'Zerbitzariaren ordu eremua ({$a}) ({$a})';
$string['tlswarning'] = 'Ez da TLSv1.2 onartzen duen PHP/cURL hedapenik aurkitu. Baliteke zerbitzu batzuk ez funtzionatzea. Zure TLS liburutegiak eguneratzea irmoki gomendatzen da.';
$string['tokenduration'] = 'Erabiltzaileek sortutako token-en iraupena';
$string['tokenduration_desc'] = 'Erabiltzaile batek sortutako web-zerbitzu baten token-a (mobile aplikazioaren bidez adibidez) baliozkoa izango den denbora.';
$string['tokenizerrecommended'] = 'PHP Tokenizer aukerako hedapena instalatzea gomendagarria da - Moodle Sarearen funtzionamendua hobetzen du.';
$string['tools'] = 'Kudeaketarako tresnak';
$string['toolsmanage'] = 'Kudeatu kudeaketarako tresnak';
$string['unattendedoperation'] = 'Alde batera utzitako eragiketa';
$string['unbookmarkthispage'] = 'Desmarkatu orri hau';
$string['unicoderequired'] = 'Datu guztiak Unicode (UTF-8)-n gorde behar dituzu. Instalazio berriak modu lehenetsian Unicode karaktere-multzoa duten datu-baseetan exekutatu beharko lirateke. Eguneraketa bat egiten ari bazara, UTF-8rako migrazio-prozesua egin beharko zenuke (begiratu horretarako Kudeaketa-orria)';
$string['uninstallplugin'] = 'Desinstalatu';
$string['unlockaccount'] = 'Desblokeatu kontua';
$string['unoconvwarning'] = 'Instalatu duzun unoconv-en bertsioak ez du mantenurik.';
$string['unsettheme'] = 'Kendu itxura';
$string['unsupported'] = 'Onartu gabea';
$string['unsupporteddbfileformat'] = 'Zure datu-baseak Antelope fitxategi formatuko gisa erabiltzen du. MySQLn eta MariaDBn UTF-8 sostengu osoa izateko Barracuda fitxategi-formatua derrigorrezkoa da. Mesedez aldatu Barracuda fitxategi-formatura. Ikusi dokumentazioa <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL-ko unicode sostengu osoaren</a> zehaztasun gehiagorako.';
$string['unsupporteddbfilepertable'] = 'UTF-8 mantenu osorako MySQLk eta MariaDBk MySQLren \'innodb_file_per_table\' ezarpenean \'ON\' jartzeko eskatzen dute. Ikusi dokumentazioa zehaztapen gehiagorako.';
$string['unsupporteddblargeprefix'] = 'UTF-8 mantenu osorako MySQLk eta MariaDBk MySQLren \'innodb_large_prefix\' ezarpenean \'ON\' jartzeko eskatzen dute. Ikusi dokumentazioa zehaztapen gehiagorako.';
$string['unsupporteddbstorageengine'] = 'Aurrerantzean datu-basea erabiltzen ari den biltegi-tresnak ez du mantenurik izango.';
$string['unsupporteddbtablerowformat'] = 'Zure datu-baseak Antelope fitxategi formatuko taulak dauzka. Taulak Barracuda fitxategi-formatura pasatzea aholkatzen dizuegu. Ikusi <a href="https://docs.moodle.org/en/cli">Komando-lerroaren bidezko kudeaketa</a> InnoDB taulak Barracuda formatura pasatzeko tresna bati buruzko zehaztasun gehiagorako.';
$string['unsupportedphpversion7'] = 'Ez da PHP 7 bertsioa  onartzen.';
$string['unsupportedphpversion71'] = 'Ez da PHP 7 bertsioa  onartzen.';
$string['unsupportedphpversion72'] = 'Ez da PHP 7.2 bertsioa onartzen.';
$string['unsupportedphpversion73'] = 'Ez dago PHP 7.3 bertsirako sostengurik';
$string['unsupportedphpversion74'] = 'PHPren 7.4 bertsioa ez da onartzen.';
$string['unsuspenduser'] = 'Aktibatu erabiltzailearen kontua';
$string['updateaccounts'] = 'Eguneratu dauden kontuak';
$string['updateautocheck'] = 'Bilatu eskuragai dauden eguneraketak automatikoki';
$string['updateautocheck_desc'] = 'Gaituz gero, zure guneak Moodle nahiz plugin gehigarrietarako eskuragai dauden eguneraketak automatikoki bilatuko ditu.';
$string['updateavailable'] = 'Bada Moodleren bertsio berriago bat eskuragarri!';
$string['updateavailabledetailslink'] = 'Ikusi {$a->url} xehetasun gehiago izateko';
$string['updateavailableforplugin'] = 'Eskuragarri dago zure hainbat pluginen bertsio berriagoa!';
$string['updateavailableinstall'] = 'Instalatu eguneraketa hau';
$string['updateavailableinstallall'] = 'Instalatu eskuragarri dauden eguneraketak ({$a})';
$string['updateavailableinstallallhead'] = 'Eskuragarri dauden eguneraketak instalatzen';
$string['updateavailable_moreinfo'] = 'Informazio gehiago...';
$string['updateavailablenot'] = 'Zure Moodle kodea eguneratuta dago!';
$string['updateavailablerecommendation'] = 'Azken segurtasun- eta errore-konponketak eskuratzearren zure gunea azken bertsiora eguneratzea irmoki gomendatzen da.';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = '{$a} bertsioa';
$string['updatecomponent'] = 'Eguneratu osagaia';
$string['updateminmaturity'] = 'Beharrezko kode-heldutasuna';
$string['updateminmaturity_desc'] = 'Ohartarazi eskuragai dauden eguneraketez soilik baldin eta kodeak gutxienez aukeratutako heldutasun-maila badauka. Kodearen heldutasun-maila zehazten ez duten pluginen eguneraketez beti informatzen da ezarpen honi jaramonik egin gabe.';
$string['updatenotificationfooter'] = 'Zure {$a->siteurl} Moodle gunea eskuragarri dauden eguneraketak automatikoki bilatzeko dago konfiguratuta. Gunearen kudeatzaile gisa jasotzen duzu mezu hau. Eskuragarri dauden eguneraketak automatikoki bilatzea desgaitu dezakezu Gunearen Kudeaketa / Zerbitzaria / Eguneraketa jakinarazpenak atalean, eta bestela mezu honen bidalketa pertsonalizatu dezakezu zure hobespenen orria erabilita.';
$string['updatenotifications'] = 'Eguneraketen jakinarazpenak';
$string['updatenotificationsubject'] = 'Moodlen hainbat eguneraketa daude eskuragarri ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Ohartarazi "build" berrietaz';
$string['updatenotifybuilds_desc'] = 'Gaituz gero, eskuragarri dauden Moodleren eguneraketez ere informatuko da instalatutako bertsiorako "build" berri bat dagoenean. "Build" bat Moodle bertsio baterako hobekuntza jarraitua da, eta astero argitaratu ohi dira. Desgaituz gero, eskuragarri dauden eguneraketez soilik Moodleren bertsio berriagoak argitaratzen direnean informatuko da. Ezarpen honek ez du eraginik pluginen eguneraketen bilaketan.';
$string['upgradeerror'] = 'Errore ezezaguna {$a->plugin} {$a->version} bertsiora eguneratzean, ezin da aurrera egin.';
$string['upgradeforumread'] = 'Moodle 1.5en foroetara bidalitako irakurritako eta irakurri gabeko mezuen jarraipena egiteko funtzionalitate berria gehitu da.<br />Funtzionalitate hori erabiltzeko, <a href="{$a}">zure taulak eguneratu behar dituzu</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5en foroetara bidalitako irakurritako eta irakurri gabeko mezuen jarraipena egiteko funtzionalitate berria erantsi da. Funtzionalitate hori erabiltzeko, zure taulak eguneratu behar dituzu mezuen jarraipenaren informazio osoarekin. Gunearen tamainaren arabera, honek luze jo dezake (orduak) eta datu-basearen erabilera astuna ekarri. Hori dela eta, hobe da lasaitasun une batea egitea. Hala ere, eguneratzean zehar guneak martxan jarraituko du eta erabiltzaileak ez dira kaltetuko. Behin prozesua hasita, bukatzen utzi beharko zenuke (ad., nabigatzailearen leihoa irekita utzi). Hala ere, leihoa itxi eta prozesua eteten baduzu, ez zaitez kezkatu, beti ere berriro has zaitezke.<br /><br />Prozesua orain hasi nahi al duzu?';
$string['upgradekeyreq'] = 'Eguneraketa-kodea beharrezkoa';
$string['upgradekeyset'] = 'Eguneraketa-kodea (utzi hutsik kodea erabili nahi ez baduzu)';
$string['upgradelogs'] = 'Funtzionalitate osoa lortzeko, zure erregistro zaharrak eguneratu behar dira. <a href="{$a}">Informazio gehiago</a>';
$string['upgradelogsinfo'] = 'Duela gutxi erregistroak gordetzeko moduan aldaketak egin dira. Zure erregistro zaharrak jardueraren arabera sailkatuta ikusteko, erregistro horiek eguneratu behar dira. Tamainaren arabera prozesuak luze jo dezake (ad., ordu batzuk) datu-basean behin eta berriro kontsultako beharko baita. bukatzen utzi beharko zenuke (ad., nabigatzailearen leihoa irekita utzi). Hala ere, leihoa itxi eta prozesua eteten baduzu, ez zaitez kezkatu, beti ere berriro has zaitezke.<br /><br />Prozesua orain hasi nahi al duzu?';
$string['upgradepluginsfirst'] = 'Gomendagarria da lehenengo eskuragarri dauden eguneraketa guztiak instalatzea';
$string['upgradepluginsinfo'] = 'Pluginak eguneratzen';
$string['upgradepluginsinfo_help'] = 'Zure plugin batzuetarako eguneraketak daude eskuragai. Moodleko datu-basea eguneratu aurretik horiek guztiak instalatu beharko zenituzke. Zure guneak eguneraketa automatikoak onartzen ez baditu, pluginen bertsio berriak jaitsi eta zure zerbitzarian eskuz instalatu beharko dituzu.';
$string['upgradesettings'] = 'Ezarpen berriak';
$string['upgradesettingsintro'] = 'Beheragoko ezarpenak Moodleren azken eguneraketan gehitu ziren. Egin beharrezko aldaketak lehenetsitako balioetan eta ondoren egin klik orriaren amaierako \'Gorde aldaketak\' botoiari.';
$string['upgradestalefiles'] = 'Moodle bertsio nahastuak atzeman dira. Eguneraketak ezin du jarraitu.';
$string['upgradestalefilesinfo'] = 'Moodleren eguneraketa-prozesua gelditu da Moodleren direktorioan gutxienez Moodleren bi bertsio nagusiren PHP scriptak atzeman direlako.

Hori beranduago arazo-iturria izan daitekeenez, jarraitu aurretik Moodleren direktorioak Moodleren bertsio bakarreko fitxategiak dauzkala ziurtatu behar duzu.

Zure Moodleren direktorioa garbitzeko hau egiteko aholkatzen dizugu:

* Berrizendatu oraingo Moodleren direktorioa, adibidez "moodle_old" jarriz.
* Sortu Moodle direktorioa berri bat jaitsitako Moodle pakete estandar baten edo Moodle Git biltegitik jaitsitakoaren fitxategiekin.
* Mugitu jatorrizko config.php fitxategia eta plugin ezestandarrak  "moodle_old" direktoriotik Moodle direktorio berrira.

Moodle direktorioa garbi dagoenean, freskatu orri hau eguneraketa-prozesuak jarrai dezan.

Abisua askotan gertatzen da Moodle estandar paketea aurreko bertsio baten gainean deskonprimatzeagatik. Azpibertsioekin hori prozedura egokia izan arren, ez da inola ere bertsio nagusiekin egin behar.

Abisua ere gerta daiteke amaitu gabeko Git biltegiko azterketa edo eguneraketagatik. Kasu horretan nahikoa izango da itxarotea eragiketa amaitu arte, edo agian garbiketa-komando egokia erabiltzea eta berriro saiatzea.

Eguneraketako dokumentazioan informazio gehiago aurkituko duzu: <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Eguneratu orain Moodleko datu-basea';
$string['upgradesure'] = '<p>Moodleko zure fitxategiak aldatu dira, eta zure zerbitzaria bertsio honetara eguneratzear zaude:</p>
<p><b>{$a}</b></p>
<p>Hori egin eta gero, ezingo duzu atzera jo. Kontuan izan prozesu honek denbora luzea eraman dezakeela.</p>
<p>Ziur zaude zerbitzari hau bertsio horretara eguneratu nahi duzula?</p>';
$string['upgradetimedout'] = 'Bukatu da eguneraketarako denbora; mesedez, ekin berriz eguneraketari.';
$string['upgradingdata'] = 'Datuak eguneratzen';
$string['upgradinglogs'] = 'Erregistroak eguneratzen';
$string['upgradingversion'] = 'Bertsio berrira eguneratzen';
$string['upwards'] = 'gora';
$string['useblogassociations'] = 'Gaitu loturak';
$string['useexternalyui'] = 'Erabili on-line YUI liburutegiak';
$string['user'] = 'Erabiltzailea';
$string['userbulk'] = 'Erabiltzaile-eragiketa masiboak';
$string['userbulkdownload'] = 'Esportatu erabiltzaileak honela';
$string['userdefaultpreferences'] = 'Erabiltzailearen lehenetsitako hobespenak';
$string['userimagesdisabled'] = 'Erabiltzailearen profileko irudiak desgaituta daude';
$string['userlist'] = 'Arakatu erabiltzaileen zerrenda';
$string['userpolicies'] = 'Erabiltzaile-politikak';
$string['userpreference'] = 'Erabiltzailearen hobespena';
$string['userquota'] = 'Erabiltzailearen kuota';
$string['users'] = 'Erabiltzaileak';
$string['usesitenameforsitepages'] = 'Erabili gunearen izena guneko orrietarako';
$string['usetags'] = 'Gaitu etiketen funtzionalitatea';
$string['validateemptylineerror'] = 'Lerro hutsak ez dira baliagarriak';
$string['validateerror'] = 'Balio hau ez zen onargarria';
$string['validateerrorlist'] = 'Sarrera hauek ez dira baliagarriak: {$a}';
$string['validateiperror'] = 'IP helbide hauek ez dira baliagarriak: {$a}';
$string['verifychangedemail'] = 'Murriztu domeinuak helbide elektronikoa aldatzean';
$string['warningcurrentsetting'] = 'Oraingo balioa ez da baliozkoa: {$a}';
$string['warningiconvbuggy'] = 'Iconv liburutegiaren zure bertsioak ez du //IGNORE aldatzailea onartzen. UTF-8 karaktere baliogabeak dituzten kateak garbitzeko erabil daitekeen mbstring hedapena instalatu beharko zenuke.';
$string['webproxy'] = 'Web proxya';
$string['webproxyinfo'] = 'Ondoko aukerak bete zure Moodle zerbitzariak zuzenean interneterako sarbidea ez badu. Beharrezkoa da ingunearen datuak, hizkuntza-paketeak, RSS jaioak, ordu eremuak... jaitsi ahal izateko. <br /><em>Oso gomendagarria da PHP cURL hedapena.</em>\'*;';
$string['xmlrpcrecommended'] = 'XMLRPC hedapena erabilgarria da web-zerbitzuetarako eta Moodle sarerako.';
$string['yuicomboloading'] = 'YUI combo kargatzen';
$string['ziprequired'] = 'Moodlek orain Zip PHP hedapena behar du. Dagoeneko ez dira info-ZIP bitarrak erabiltzen ezta PclZip liburutegia ere.';
