<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_boostnavigation', language 'pt', branch 'MOODLE_36_STABLE'
 *
 * @package   local_boostnavigation
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'Navegação Boost melhorada';
$string['privacy:metadata:preference:collapse'] = 'O estado contraído/expandido de um nó de navegação no menu de navegação.';
$string['privacy:request:preference:collapse'] = 'O estado contraído/expandido do nó de navegação "{$a->nodename}" no menu de navegação é {$a->collapse}.';
$string['setting_collapseactivitiescoursenode'] = 'Contrair o nó "Atividades"';
$string['setting_collapseactivitiescoursenodedefault'] = 'Contrair o nó "Atividades" por predefinição';
$string['setting_collapseactivitiescoursenodedefault_desc'] = 'Se ativar esta opção, o nó "Atividades" estará contraído por predefinição. Se desativada, estará expandido. Esta configuração apenas controla o estado predefinido para cada utilizador quando o nó é apresentado ao utilizador pela primeira vez.<br /><em>Esta configuração só é processada quando \'Contrair o nó Atividades\' está ativada.</em>';
$string['setting_collapseactivitiescoursenode_desc'] = 'A ativação desta configuração permitirá que os utilizadores possam contrair o nó "Atividades".<br /><em>Esta configuração só é processada quando \'Inserir o nó Atividades\' também está ativada.</em>';
$string['setting_collapseactivitiescoursenodesession'] = 'Lembrar o estado contraído/expandido do nó "Atividades" apenas para a sessão atual';
$string['setting_collapseactivitiescoursenodesession_desc'] = 'A ativação desta configuração lembrará o estado contraído/expandido do nó "Atividades" apenas para a sessão atual do utilizador. Após o próximo fim de sessão e nova autenticação de um utilizador em particular, o estado contraído/expandido será redefinido para o valor que está acima indicado como predefinido. Se esta configuração estiver desativada, o estado contraído/expandido desses nós será lembrado após o final da sessão do utilizador.<br /><em>Esta configuração só é processada quando \'Contrair o nó "Atividades"\' está ativada.</em>';
$string['setting_collapsebottomnodesheading'] = 'Contrair os nós do fundo do menu de navegação do Boost';
$string['setting_collapsecoursenodesheading'] = 'Contrair os nós de disciplina do menu de navegação do Boost';
$string['setting_collapsecoursesectionscoursenode'] = 'Contrair o nó "Secções"';
$string['setting_collapsecoursesectionscoursenodedefault'] = 'Contrair o nó "Secções" por predefinição';
$string['setting_collapsecoursesectionscoursenodedefault_desc'] = 'Se ativar esta opção, o nó "Secções" estará contraído por predefinição. Se desativado, estará expandido. Esta configuração apenas controla o estado predefinido para cada utilizador quando o nó é apresentado ao utilizador pela primeira vez.<br /><em>Esta configuração só é processada quando \'Contrair o nó Secções\' está ativada.</em>';
$string['setting_collapsecoursesectionscoursenode_desc'] = 'A ativação desta configuração permitirá que os utilizadores possam contrair o nó "Secções".<br /><em>Esta configuração só é processada quando \'Inserir o nó Secções\' também está ativada.</em>';
$string['setting_collapsecoursesectionscoursenodesession'] = 'Lembrar o estado contraído/expandido do nó "Secções" apenas para a sessão atual';
$string['setting_collapsecoursesectionscoursenodesession_desc'] = 'A ativação desta configuração lembrará o estado contraído/expandido do nó "Secções" apenas para a sessão atual do utilizador. Após o próximo fim de sessão e nova autenticação de um utilizador em particular, o estado contraído/expandido será redefinido para o valor que está acima indicado como predefinido. Se esta configuração estiver desativada, o estado contraído/expandido desses nós será lembrado após o final da sessão do utilizador.<br /><em>Esta configuração só é processada quando \'Contrair o nó "Secções"\' está ativada.</em>';
$string['setting_collapsecustombottomnodesadmins'] = 'Contrair os nós do fundo personalizados para os administradores';
$string['setting_collapsecustombottomnodesadminsaccordion'] = 'Contrair os nós do fundo personalizados para os administradores como acordeão';
$string['setting_collapsecustombottomnodesadminsaccordion_desc'] = 'A ativação desta configuração contrairá os nós do fundo personalizados para os administradores como acordeão, o que significa que só pode ser expandido um nó ascendente de cada vez. Se um segundo nó ascendente for expandido, o nó atualmente expandido será contraído automaticamente. Se esta configuração estiver desativada, vários nós ascendentes poderão ser expandidos ao mesmo tempo.<br /><em>Esta configuração só é processada quando \'Contrair os nós do fundo personalizados para os administradores\' está ativada.</em>';
$string['setting_collapsecustombottomnodesadminsdefault'] = 'Contrair os nós do fundo personalizados para os administradores por predefinição';
$string['setting_collapsecustombottomnodesadminsdefault_desc'] = 'Se ativar esta opção, os nós do fundo personalizados estarão contraídos, por predefinição, para os administradores. Se desativada, estarão expandidos. Esta configuração apenas controla o estado predefinido para cada utilizador quando o nó é apresentado ao utilizador pela primeira vez.<br /><em>Esta configuração só é processada quando \'Contrair os nós personalizados do fundo para os administradores\' está ativada.</em>';
$string['setting_collapsecustombottomnodesadmins_desc'] = 'A ativação desta configuração permitirá que os utilizadores possam contrair os nós do fundo personalizados para os administradores.<br /><em>Esta configuração só é processada quando "Inserir nós do fundo personalizados para administradores" tem pelo menos um nó personalizado com pelo menos um nó descendente adicionado.</em>';
$string['setting_collapsecustombottomnodesadminssession'] = 'Lembrar o estado contraído/expandido dos nós do fundo personalizados para os administradores apenas para a sessão atual';
$string['setting_collapsecustombottomnodesadminssession_desc'] = 'A ativação desta configuração lembrará o estado contraído/expandido dos nós do fundo personalizados para os administradores apenas na sessão atual do utilizador. Após o próximo fim de sessão e nova autenticação de um utilizador em particular, o estado contraído/expandido será redefinido para o valor que está acima indicado como predefinido. Se esta configuração estiver desativada, o estado contraído/expandido desses nós será lembrado após o final da sessão do utilizador.<br /><em>Esta configuração só é processada quando \'Contrair os nós do fundo personalizados para os administradores\' está ativada.</em>';
$string['setting_collapsecustombottomnodesusers'] = 'Contrair os nós do fundo para os utilizadores';
$string['setting_collapsecustombottomnodesusersaccordion'] = 'Contrair os nós do fundo para os utilizadores como acordeão';
$string['setting_collapsecustombottomnodesusersaccordion_desc'] = 'A ativação desta configuração contrairá os nós do fundo personalizados para os utilizadores como acordeão, o que significa que só pode ser expandido um nó ascendente de cada vez. Se um segundo nó ascendente for expandido, o nó atualmente expandido será contraído automaticamente. Se esta configuração estiver desativada, vários nós ascendentes poderão ser expandidos ao mesmo tempo.<br /><em>Esta configuração só é processada quando \'Contrair os nós do fundo para os utilizadores\' está ativada.</em>';
$string['setting_collapsecustombottomnodesusersdefault'] = 'Contrair os nós do fundo para os utilizadores por predefinição';
$string['setting_collapsecustombottomnodesusersdefault_desc'] = 'Se ativar esta opção, os nós do fundo personalizados estarão contraídos, por predefinição, para os utilizadores. Se desativada, estarão expandidos. Esta configuração apenas controla o estado predefinido para cada utilizador quando o nó é apresentado ao utilizador pela primeira vez.<br /><em>Esta configuração só é processada quando \'Contrair os nós personalizados do fundo para os utilizadores\' está ativada.</em>';
$string['setting_collapsecustombottomnodesusers_desc'] = 'A ativação desta configuração permitirá que os utilizadores possam contrair os nós do fundo personalizados para os utilizadores.<br /><em>Esta configuração só é processada quando "Inserir nós do fundo personalizados para utilizadores" tem pelo menos um nó personalizado com pelo menos um nó descendente adicionado.</em>';
$string['setting_collapsecustombottomnodesuserssession'] = 'Lembrar o estado contraído/expandido dos nós do fundo personalizados para os utilizadores apenas para a sessão atual';
$string['setting_collapsecustombottomnodesuserssession_desc'] = 'A ativação desta configuração lembrará o estado contraído/expandido dos nós do fundo personalizados para os utilizadores apenas na sessão atual do utilizador. Após o próximo fim de sessão e nova autenticação de um utilizador em particular, o estado contraído/expandido será redefinido para o valor que está acima indicado como predefinido. Se esta configuração estiver desativada, o estado contraído/expandido desses nós será lembrado após o final da sessão do utilizador.<br /><em>Esta configuração só é processada quando \'Contrair os nós do fundo personalizados para os utilizadores\' está ativada.</em>';
$string['setting_collapsecustomcoursenodesadmins'] = 'Contrair os nós de disciplina para administradores';
$string['setting_collapsecustomcoursenodesadminsaccordion'] = 'Contrair os nós de disciplina para administradores como acordeão';
$string['setting_collapsecustomcoursenodesadminsaccordion_desc'] = 'A ativação desta configuração contrairá os nós de disciplina para administradores como acordeão, o que significa que só pode ser expandido um nó ascendente de cada vez. Se um segundo nó ascendente for expandido, o nó atualmente expandido será contraído automaticamente. Se esta configuração estiver desativada, vários nós ascendentes poderão ser expandidos ao mesmo tempo.<br /><em>Esta configuração só é processada quando \'Contrair os nós de disciplina para administradores\' está ativada.</em>';
$string['setting_collapsecustomcoursenodesadminsdefault'] = 'Contrair os nós de disciplina para administradores por predefinição';
$string['setting_collapsecustomcoursenodesadminsdefault_desc'] = 'Se ativar esta opção, os nós de disciplina estarão contraídos, por predefinição, para os administradores. Se desativada, estarão expandidos. Esta configuração apenas controla o estado predefinido para cada utilizador quando o nó é apresentado ao utilizador pela primeira vez.<br /><em>Esta configuração só é processada quando \'Contrair os nós de disciplina para os administradores\' está ativada.</em>';
$string['setting_collapsecustomcoursenodesadmins_desc'] = 'A ativação desta configuração permitirá que os utilizadores possam contrair os nós de disciplina para administradores.<br /><em>Esta configuração só é processada quando "Inserir nós de disciplina personalizados para administradores" tem pelo menos um nó personalizado com pelo menos um nó descendente adicionado.</em>';
$string['setting_collapsecustomcoursenodesadminssession'] = 'Lembrar o estado contraído/expandido dos nós de disciplina para administradores apenas para a sessão atual';
$string['setting_collapsecustomcoursenodesadminssession_desc'] = 'A ativação desta configuração lembrará o estado contraído/expandido dos nós de disciplina para administradores apenas na sessão atual do utilizador. Após o próximo fim de sessão e nova autenticação de um utilizador em particular, o estado contraído/expandido será redefinido para o valor que está acima indicado como predefinido. Se esta configuração estiver desativada, o estado contraído/expandido desses nós será lembrado após o final da sessão do utilizador.<br /><em>Esta configuração só é processada quando \'Contrair os nós de disciplina para administradores\' está ativada.</em>';
$string['setting_collapsecustomcoursenodesusers'] = 'Contrair os nós de disciplina para utilizadores';
$string['setting_collapsecustomcoursenodesusersaccordion'] = 'Contrair os nós de disciplina para utilizadores como acordeão';
$string['setting_collapsecustomcoursenodesusersaccordion_desc'] = 'A ativação desta configuração contrairá os nós de disciplina para utilizadores como acordeão, o que significa que só pode ser expandido um nó ascendente de cada vez. Se um segundo nó ascendente for expandido, o nó atualmente expandido será contraído automaticamente. Se esta configuração estiver desativada, vários nós ascendentes poderão ser expandidos ao mesmo tempo.<br /><em>Esta configuração só é processada quando \'Contrair os nós de disciplina para utilizadores\' está ativada.</em>';
$string['setting_collapsecustomcoursenodesusersdefault'] = 'Contrair os nós de disciplina para utilizadores por predefinição';
$string['setting_collapsecustomcoursenodesusersdefault_desc'] = 'Se ativar esta opção, os nós de disciplina estarão contraídos, por predefinição, para os utilizadores. Se desativada, estarão expandidos. Esta configuração apenas controla o estado predefinido para cada utilizador quando o nó é apresentado ao utilizador pela primeira vez.<br /><em>Esta configuração só é processada quando \'Contrair os nós de disciplina para os utilizadores\' está ativada.</em>';
$string['setting_collapsecustomcoursenodesusers_desc'] = 'A ativação desta configuração permitirá que os utilizadores possam contrair os nós de disciplina para utilizadores.<br /><em>Esta configuração só é processada quando "Inserir nós de disciplina personalizados para administradores" tem pelo menos um nó personalizado com pelo menos um nó descendente adicionado.</em>';
$string['setting_collapsecustomcoursenodesuserssession'] = 'Lembrar o estado contraído/expandido dos nós de disciplina para utilizadores apenas para a sessão atual';
$string['setting_collapsecustomcoursenodesuserssession_desc'] = 'A ativação desta configuração lembrará o estado contraído/expandido dos nós de disciplina para utilizadores apenas na sessão atual do utilizador. Após o próximo fim de sessão e nova autenticação de um utilizador em particular, o estado contraído/expandido será redefinido para o valor que está acima indicado como predefinido. Se esta configuração estiver desativada, o estado contraído/expandido desses nós será lembrado após o final da sessão do utilizador.<br /><em>Esta configuração só é processada quando \'Contrair os nós de disciplina para utilizadores\' está ativada.</em>';
$string['setting_collapsecustomnodesadmins'] = 'Contrair os nós personalizados da raiz para os administradores';
$string['setting_collapsecustomnodesadminsaccordion'] = 'Contrair os nós personalizados da raiz para os administradores como acordeão';
$string['setting_collapsecustomnodesadminsaccordion_desc'] = 'A ativação desta configuração contrairá os nós personalizados da raiz para os administradores como acordeão, o que significa que só pode ser expandido um nó ascendente de cada vez. Se um segundo nó ascendente for expandido, o nó atualmente expandido será contraído automaticamente. Se esta configuração estiver desativada, vários nós ascendentes poderão ser expandidos ao mesmo tempo.<br /><em>Esta configuração só é processada quando \'Contrair os nós personalizados da raiz para os administradores\' está ativada.</em>';
$string['setting_collapsecustomnodesadminsdefault'] = 'Contrair os nós personalizados da raiz para os administradores por predefinição';
$string['setting_collapsecustomnodesadminsdefault_desc'] = 'Se ativar esta opção, os nós personalizados da raiz estarão contraídos, por predefinição, para os administradores. Se desativada, estarão expandidos. Esta configuração apenas controla o estado predefinido para cada utilizador quando o nó é apresentado ao utilizador pela primeira vez.<br /><em>Esta configuração só é processada quando \'Contrair os nós personalizados da raiz para os administradores\' está ativada.</em>';
$string['setting_collapsecustomnodesadmins_desc'] = 'A ativação desta configuração permitirá que os utilizadores possam contrair os nós personalizados da raiz para administradores.<br /><em>Esta configuração só é processada quando "Inserir nós da raiz personalizados para administradores" tem pelo menos um nó personalizado com pelo menos um nó descendente adicionado.</em>';
$string['setting_collapsecustomnodesadminssession'] = 'Lembrar o estado contraído/expandido dos nós personalizados da raiz para os administradores apenas para a sessão atual';
$string['setting_collapsecustomnodesadminssession_desc'] = 'A ativação desta configuração lembrará o estado contraído/expandido dos nós personalizados da raiz para os administradores apenas na sessão atual do utilizador. Após o próximo fim de sessão e nova autenticação de um utilizador em particular, o estado contraído/expandido será redefinido para o valor que está acima indicado como predefinido. Se esta configuração estiver desativada, o estado contraído/expandido desses nós será lembrado após o final da sessão do utilizador.<br /><em>Esta configuração só é processada quando \'Contrair os nós personalizados da raiz para os administradores\' está ativada.</em>';
$string['setting_collapsecustomnodesusers'] = 'Contrair os nós personalizados da raiz para os utilizadores';
$string['setting_collapsecustomnodesusersaccordion'] = 'Contrair os nós personalizados da raiz para os utilizadores como acordeão';
$string['setting_collapsecustomnodesusersaccordion_desc'] = 'A ativação desta configuração contrairá os nós personalizados da raiz para os utilizadores como acordeão, o que significa que só pode ser expandido um nó ascendente de cada vez. Se um segundo nó ascendente for expandido, o nó atualmente expandido será contraído automaticamente. Se esta configuração estiver desativada, vários nós ascendentes poderão ser expandidos ao mesmo tempo.<br /><em>Esta configuração só é processada quando \'Contrair os nós personalizados da raiz para os utilizadores\' está ativada.</em>';
$string['setting_collapsecustomnodesusersdefault'] = 'Contrair os nós personalizados da raiz para os utilizadores por predefinição';
$string['setting_collapsecustomnodesusersdefault_desc'] = 'Se ativar esta opção, os nós personalizados da raiz estarão contraídos, por predefinição, para os utilizadores. Se desativada, estarão expandidos. Esta configuração apenas controla o estado predefinido para cada utilizador quando o nó é apresentado ao utilizador pela primeira vez.<br /><em>Esta configuração só é processada quando \'Contrair os nós personalizados da raiz para os utilizadores\' está ativada.</em>';
$string['setting_collapsecustomnodesusers_desc'] = 'A ativação desta configuração permitirá que os utilizadores possam contrair os nós personalizados da raiz para utilizadores.<br /><em>Esta configuração só é processada quando "Inserir nós da raiz personalizados para utilizadores" tem pelo menos um nó personalizado com pelo menos um nó descendente adicionado.</em>';
$string['setting_collapsecustomnodesuserssession'] = 'Lembrar o estado contraído/expandido dos nós personalizados da raiz para os utilizadores apenas para a sessão atual';
$string['setting_collapsecustomnodesuserssession_desc'] = 'A ativação desta configuração lembrará o estado contraído/expandido dos nós personalizados da raiz para os utilizadores apenas na sessão atual do utilizador. Após o próximo fim de sessão e nova autenticação de um utilizador em particular, o estado contraído/expandido será redefinido para o valor que está acima indicado como predefinido. Se esta configuração estiver desativada, o estado contraído/expandido desses nós será lembrado após o final da sessão do utilizador.<br /><em>Esta configuração só é processada quando \'Contrair os nós personalizados da raiz para os utilizadores\' está ativada.</em>';
$string['setting_collapsemycoursesnode'] = 'Contrair o nó "As minhas disciplinas"';
$string['setting_collapsemycoursesnodedefault'] = 'Contrair o nó "As minhas disciplinas" por predefinição';
$string['setting_collapsemycoursesnodedefault_desc'] = 'Se ativar esta opção, o nó "As minhas disciplinas" estará contraído por predefinição. Se desativada, estará expandido. Esta configuração apenas controla o estado predefinido para cada utilizador quando o nó é apresentado ao utilizador pela primeira vez.<br /><em>Esta configuração só é processada quando \'Contrair o nó As minhas disciplinas\' está ativada.</em>';
$string['setting_collapsemycoursesnode_desc'] = 'A ativação desta configuração permitirá que os utilizadores possam contrair o nó "As minhas disciplinas".';
$string['setting_collapsemycoursesnodeperformancehint'] = 'Observação: Esta funcionalidade só funcionará se a configuração <a href="{$a->url}">navshowmycoursecategories</a> não estiver ativa. Se ativou \'navshowmycoursecategories\', esta configuração será ignorada.';
$string['setting_collapsemycoursesnodesession'] = 'Lembrar o estado contraído/expandido do nó "As minhas disciplinas" apenas para a sessão atual';
$string['setting_collapsemycoursesnodesession_desc'] = 'A ativação desta configuração lembrará o estado contraído/expandido do nó "As minhas disciplinas" apenas para a sessão atual do utilizador. Após o próximo fim de sessão e nova autenticação de um utilizador em particular, o estado contraído/expandido será redefinido para o valor que está acima indicado como predefinido. Se esta configuração estiver desativada, o estado contraído/expandido desses nós será lembrado após o final da sessão do utilizador.<br /><em>Esta configuração só é processada quando \'Contrair o nó "As minhas disciplinas"\' está ativada.</em>';
$string['setting_collapsenodesheading'] = 'Contrair os nós da raiz do menu de navegação do Boost';
$string['setting_collapsenodestechnicalhint'] = 'Informação técnica: é conseguido através da adição de alguns códigos JavaScript e CSS à página que mostrará ou ocultará os nós de segundo nível assim que o utilizador clicar no nó. O estado contraído/expandido do nó será processado na sessão de cada utilizador e será guardado nas preferências de cada utilizador. Os nós só estarão ocultos no menu de navegação durante o tempo de execução, mas permanecerão na árvore de navegação e poderão ser acedidos por outras partes do Moodle.';
$string['setting_customnodesusageadmins'] = 'Cada linha consiste num título, uma hiperligação do URL e idiomas suportados (opcional) - separados por barras verticais. Cada nó personalizado deve ser escritos numa linha.<br />
Por exemplo: <br />
Site Moodle|http: //www.moodle.org|en,pt<br />
Lista de utilizadores do Moodle|/admin/user.php<br /><br />
Informações detalhadas sobre os parâmetros:
<ul>
<li><b>Título:</b> texto que será mostrado como hiperligação/separador clicável do nó personalizado.</li>
<li><b>Hiperligação:</b> destino da hiperligação pode ser definido por um URL completo (por exemplo, https://moodle.org) ou por um caminho relativo na sua instância do Moodle (por exemplo, /login/logout.php).</li>
<li><b>Idiomas suportados (opcional):</b> esta configuração pode ser usada para mostrar o nó personalizado apenas aos utilizadores dos idiomas especificados. Para mais de um idioma suportado, separe-os por vírgulas. Se o nó personalizado é para ser mostrado em todos os idiomas, deixe este campo vazio.
</li>
</ul>
Atenção:
<ul>
<li>Os nós personalizados para administradores são processados pela mesma função que os nós personalizados para utilizadores. Por isso, além dos parâmetros fornecidos acima, também são suportados os mesmos parâmetros que os nós personalizados para utilizadores. Sinta-se à vontade para usá-los aqui, se realmente precisar para qualquer cenário especial, mesmo que não sejam documentados aqui (para evitar repetições de documentação).</li>
<li>O parâmetro título pode conter espaços reservados, por exemplo, {coursefullname} para criar um nó com o nome completo da disciplina atual. Espaços reservados são encapsulados em chavetas e serão substituídos automaticamente quando o nó personalizado for criado.<br />
Os espaços reservados disponíveis são:
<ul>
<li>{coursefullname}: nome completo da disciplina</li>
<li>{courseshortname}: nome curto da disciplina</li>
<li>{editingtoggle}: valor de \'Ativar edição\' ou \'Desativar edição\' do pacote de idiomas atualmente usado</li>
<li>{userfullname}: nome completo do utilizador autenticado</li>
<li>{userusername}: nome de utilizador do utilizador autenticado</li>
</ul>
</li>
<li>O parâmetro hiperligação pode conter espaços reservados, por exemplo, /course/edit.php?id={courseid} para criar um nó ligado à página de configurações da disciplina atual. Espaços reservados são encapsulados em chavetas e serão substituídos automaticamente quando o nó personalizado for criado.<br />
Os espaços reservados disponíveis são:
<ul>
<li>{courseid}: ID da disciplina (interno)</li>
<li>{courseshortname}: nome curto da disciplina</li>
<li>{editingtoggle}: o valor de \'on\' ou \'off\' necessário para alternar o modo de edição</li>
<li>{userid}: ID do utilizador autenticado (interno)</li>
<li>{userusername}: nome de utilizador do utilizador autenticado</li>
<li>{pagecontextid}: ID do contexto da página atual</li>
<li>{pagepath}: caminho do URL da página atual</li>
<li>{sesskey}: chave de sessão para URLs seguros</li>
</ul>
</li>
<li>Se o nó personalizado não aparecer no menu de navegação do Boost, verifique se todos os parâmetros obrigatórios estão definidos corretamente e se a configuração de idioma opcional se ajusta ao seu idioma atual de utilizador do Moodle.</li>
<li>Devido ao modo como o menu de navegação do Boost é construído no \'core\' do Moodle, todos os nós personalizados são mostrados de igual modo. Não é possível adicionar classes CSS personalizadas, IDs de elementos HTML personalizados ou um atributo de destino para abrir a hiperligação numa nova janela.
</li>
</ul>';
$string['setting_customnodesusagechildnodes'] = 'Os nós personalizados podem ser aninhados com um nível de hierarquia, ou seja, um nó personalizado pode ter nós descendentes. A criação de um nó descendente em vez de um nó de topo, apenas irá colocar um hífen como prefixo no título do nó personalizado.<br />
Por exemplo:<br />
Administração|/admin/index.php<br />
-Lista de utilizadores do Moodle|/admin/user.php<br />
-Gerir disciplinas|/course/management.php<br /><br />
Atenção:
<ul>
<li>Por motivos técnicos, um nó de topo precisa sempre de um URL válido, mesmo que o nó fique contraído.</li>
<li>Se um nó de topo não for mostrado por qualquer restrição (idioma, grupo global ou papel), os nós descendentes também não serão mostrados. </li>
</ul>';
$string['setting_customnodesusageusers'] = 'Cada linha consiste num título, uma hiperligação do URL, idiomas suportados (opcional), grupos globais (opcional), papéis (opcional), papéis globais (opcional), operador lógico (opcional), um ícone (opcional), o ID do atributo (opcional) e \'chave do nó ascendente\' (opcional) - separados por barras verticais. Cada nó personalizado deve ser escritos numa linha.<br />
Por exemplo:<br />
Site Moodle|http: //www.moodle.org|en,pt<br />
A Universidade|http://www.our-university.edu<br />
Faculdade de Matemática|http://www.our-university.edu/math||math<br />
Manual do professor|http://www.our-university.edu/teacher-handbook|||editingteacher,teacher<br />
Informações para o aluno|/course/view.php?id=1234||||||fa-graduation-cap<br />
{editingtoggle}|/course/view.php?id={courseid}&sesskey={sesskey}&edit={editingtoggle}|||editingteacher|admin,manager|OR|fa-pencil|editing|participants<br /><br />
Informações detalhadas sobre os parâmetros:
<ul>
<li><b>Título:</b> texto que será mostrado como hiperligação/separador clicável do nó personalizado.</li>
<li><b>Hiperligação:</b> destino da hiperligação pode ser definido por um URL completo (por exemplo, https://moodle.org) ou por um caminho relativo na sua instância do Moodle (por exemplo, /login/logout.php).</li>
<li><b>Idiomas suportados (opcional):</b> esta configuração pode ser usada para mostrar o nó personalizado apenas aos utilizadores dos idiomas especificados. Para mais de um idioma suportado, separe-os por vírgulas. Se o nó personalizado é para ser mostrado em todos os idiomas, deixe este campo vazio.</li>
<li><b>Grupos globais suportados (opcional):</b> esta configuração pode ser usada para mostrar o nó personalizado apenas aos membros dos grupos globais especificados. Use o ID grupo global, não o nome. Separe os grupos globais suportados por vírgulas. Se o nó personalizado é para ser mostrados a todos os utilizadores, independentemente de qualquer associação de grupo, deixe este campo vazio.</li>
<li><b>Papéis suportados (opcional):</b> esta configuração pode ser usada para mostrar o nó personalizado apenas aos utilizadores com o papel especificado em cada contexto. Use o nome curto do papel. Separe os papéis suportados por vírgulas. Se o nó personalizado é para ser mostrados a todos os utilizadores, independentemente do papel, deixe este campo vazio.</li>
<li><b>Papéis no sistema suportados (opcional):</b> esta configuração pode ser usada para mostrar o nó personalizado apenas para membros com o papel no sistema especificado. Use o nome curto do papel. O nome curto \'admin\' é suportado para verificar se o utilizador é um administrador do site. Separe os papéis suportados por vírgulas. Se o nó personalizado é para ser mostrado a todos os utilizadores, independentemente do papel no sistema, deixe este campo vazio.</li>
<li><b>Operador lógico de combinação (opcional):</b> esta configuração pode ser usada para alterar a combinação lógica dos parâmetros opcionais do grupo global, papel e papel no sistema. Se definir esta configuração como \'AND\' ou deixar esta configuração vazia, os parâmetros opcionais do grupo global, papel e papel no sistema serão combinados logicamente com \'AND\' e o nó personalizado será mostrado apenas se TODOS os parâmetros forem verdadeiros. Se definir esta configuração como \'OR\', os parâmetros opcionais do grupo global, papel e papel no sistema serão combinados logicamente com \'OR\' e o nó personalizado será mostrado se QUALQUER um dos parâmetros for verdadeiro. Isso permite a flexibilidade de criar, por exemplo, um nó que é mostrado aos utilizadores com um determinado papel na disciplina, bem como aos utilizadores com um determinado papel no sistema, conforme mostrado no exemplo acima.</li>
<li><b>Ícone (opcional):</b> o ícone será usado como ícone para o nó personalizado, por exemplo fa-flag. Use os identificadores de ícones do tipo de letra Awesome  (<a href="https://fontawesome.com/v4.7.0/icons/">lista de ícones em fontawesome.com</a>) para selecionar o ícone que pretende usar. O tipo de letra Awesome está incluído no Boost. Os ícones pix clássicos do Moodle não são suportados. Se pretender apenas usar um ícone de marcador predefinido para o nó personalizado, deixe este campo vazio. De momento, os nós personalizados que não tenham um ícone de marcador predefinido atribuído automaticamente também não podem ter um ícone personalizado.</li>
<li><b>ID do atributo (opcional):</b> esta configuração pode ser usada para definir, com o valor fixo especificado, o ID do atributo do nó personalizado. Apenas carateres alfanuméricos podem ser usados como valor do ID e terá como prefixo a área específica do nó personalizado. Por exemplo, configurar o ID de um nó, pertencente à área dos nós do fundo para administradores, com o valor \'my_node\' resultará num ID do atributo preenchido com \'localboostnavigationcustombottomadminsmynode\'. Esta configuração permite a possibilidade de fazer referência a um nó personalizado nos seletores CSS ou até mesmo em código JavaScript personalizado. Definir o mesmo ID para vários nós não é proibido, mas tenha em atenção que os ID de atributos duplicados são desencorajados em páginas HTML. Se este campo estiver vazio, o nó personalizado irá ter um ID gerado automaticamente que não é realmente adequado para referência.</li>
<li><b>Chave do nó ascendente (opcional):</b> Esta configuração pode personalizado deve ser colocado. A chave do nó está no atributo HTML \'data-key\' do nó que pretende referenciar aqui. No caso de ser um conjunto de nós composto por um ascendente e um ou mais descendentes, esta configuração deve ser indicada em cada nó do conjunto.<br/>Tenha em atenção que só pode usar chaves do nó do contexto do nó antes do nó que está a adicionara. Por exemplo, pode usar \'privatefiles\' ou \'calendar\' no contexto do nó de disciplina. Se a chave do nó anterior for desconhecida ou não puder ser processada por algum motivo desconhecido, o nó será adicionado no final do contexto do nó.<br />Tenha em atenção que esta configuração é considerada parcialmente experimental, uma vez que talvez ainda não seja possível usar alguns nós como antes dos nós com essa configuração.</li>
</ul>
Atenção:
<ul>
<li>A divisão dos parâmetros opcionais com barras verticais é sempre necessária se estiverem localizados entre outras opções. Isto significa que deve separar os parâmetros com o carácter | (barra vertical), mesmo que estejam vazios. Veja acima o exemplo do nó personalizado da Faculdade de Matemática.</li>
<li>O parâmetro título pode conter espaços reservados, por exemplo, {coursefullname} para criar um nó com o nome completo da disciplina atual. Os espaços reservados são encapsulados em chavetas e serão substituídos automaticamente quando o nó personalizado for criado.</li><br />Os espaços reservados disponíveis são:
<ul>
<li>{coursefullname}: nome completo da disciplina</li>
<li>{courseshortname}: nome curto da disciplina</li>
<li>{editingtoggle}: valor de \'Ativar edição\' ou \'Desativar edição\' no pacote de idiomas atualmente usado</li>
<li>{userfullname}: nome completo do utilizador autenticado</li>
<li>{userusername}: nome de utilizador do utilizador autenticado</li>
</ul>
<li>O parâmetro hiperligação pode conter espaços reservados, por exemplo, /course/edit.php?id={courseid} para criar um nó ligado à página de configurações da disciplina atual. Os espaços reservados são encapsulados em chavetas e serão substituídos automaticamente quando o nó personalizado for criado.<br />Os espaços reservados disponíveis são:
<ul>
<li>{courseid}: ID da disciplina (interno)</li>
<li>{courseshortname}: nome curto da disciplina</li>
<li>{editingtoggle}: o valor de \'on\' ou \'off\' necessário para alternar o modo de edição</li>
<li>{userid}: ID do utilizador autenticado (interno)</li>
<li>{userusername}: nome de utilizador do utilizador autenticado</li>
<li>{pagecontextid}: ID do contexto da página atual</li>
<li>{pagepath}: caminho do URL da página atual</li>
<li>{sesskey}: chave de sessão para URLs seguros</li>
</ul>
</li>
<li>Se o nó personalizado não aparecer no menu de navegação do Boost, verifique se todos os parâmetros obrigatórios estão definidos corretamente, se a configuração de idioma opcional está ajustada ao seu idioma atual de utilizador do Moodle e se é um membro da configuração opcional de grupo global.</li>
<li>Devido ao modo como o menu de navegação do Boost é construído no \'cor\' do Moodle, todos os nós personalizados são mostrados de igual modo. Não é possível adicionar classes CSS personalizadas, IDs de elementos HTML personalizados ou um atributo de destino para abrir a hiperligação numa nova janela.</li>
</ul>';
$string['setting_insertactivitiescoursenode'] = 'Inserir o nó "Atividades"';
$string['setting_insertactivitiescoursenode_desc'] = 'Ativar esta opção irá inserir o nó "Atividades" no menu de navegação do Boost, que manterá os nós vinculados às páginas da visão global de cada atividade. Basicamente é trazer a funcionalidade existente no bloco "Atividades" para o menu de navegação do Boost.';
$string['setting_insertbottomnodesheading'] = 'Inserção de nós do fundo no menu de navegação do Boost';
$string['setting_insertcoursenodesheading'] = 'Inserção de nós de disciplina no menu de navegação do Boost';
$string['setting_insertcoursesectionscoursenode'] = 'Inserir o nó "Secções"';
$string['setting_insertcoursesectionscoursenodecorehint'] = 'Observação: Esta funcionalidade só funcionará se a configuração<a href="{$a->url}">linkcoursesections</a> estiver ativa. Se desativou \'linkcoursesections\', esta configuração será ignorada.';
$string['setting_insertcoursesectionscoursenode_desc'] = 'Ativar esta opção irá inserir o nó "Secções" no menu de navegação do Boost, que será colocado acima da primeira secção da disciplina atual.';
$string['setting_insertcustombottomnodesadmins'] = 'Inserir nós do fundo personalizados para os administradores';
$string['setting_insertcustombottomnodesadmins_desc'] = 'Se ativar esta opção, poderá inserir nós personalizados no menu de navegação do Boost, que serão adicionados abaixo da secção principal do menu de navegação, tal como "Administração do Site". Estes nós personalizados apenas serão mostrados aos administradores do site.';
$string['setting_insertcustombottomnodesusers'] = 'Inserir nós do fundo personalizados para os utilizadores';
$string['setting_insertcustombottomnodesusers_desc'] = 'Se ativar esta opção, poderá inserir nós personalizados no menu de navegação do Boost, que serão adicionados abaixo da secção principal do menu de navegação, tal como "Administração do Site". Estes nós personalizados serão mostrados a todos os utilizadores.';
$string['setting_insertcustomcoursenodesadmins'] = 'Inserir nós de disciplina personalizados para os administradores';
$string['setting_insertcustomcoursenodesadmins_desc'] = 'Se ativar esta opção, poderá inserir nós personalizados no menu de navegação do Boost, que serão adicionados após o último item da secção da disciplina no menu de navegação, provavelmente abaixo do último item. Estes nós personalizados apenas serão mostrados aos administradores do site.';
$string['setting_insertcustomcoursenodesusers'] = 'Inserir nós de disciplina personalizados para os utilizadores';
$string['setting_insertcustomcoursenodesusers_desc'] = 'Se ativar esta opção, poderá inserir nós personalizados no menu de navegação do Boost, que serão adicionados após o último item da secção da disciplina do menu de navegação, provavelmente abaixo do último item. Estes nós personalizados serão mostrados a todos os utilizadores.';
$string['setting_insertcustomnodesadmins'] = 'Inserir nós da raiz personalizados para os administradores';
$string['setting_insertcustomnodesadmins_desc'] = 'Se ativar esta opção, poderá inserir nós personalizados no menu de navegação do Boost, que serão adicionados após o último item da secção principal do menu de navegação, provavelmente abaixo do item "As minhas disciplinas". Estes nós personalizados apenas serão mostrados aos administradores do site.';
$string['setting_insertcustomnodesusers'] = 'Inserir nós da raiz personalizados para os utilizadores';
$string['setting_insertcustomnodesusers_desc'] = 'Se ativar esta opção, poderá inserir nós personalizados no menu de navegação do Boost, que serão adicionados após o último item da secção principal do menu de navegação, provavelmente abaixo do item "As minhas disciplinas". Estes nós personalizados serão mostrados a todos os utilizadores.';
$string['setting_insertnodescollapsehint'] = 'Tenha em atenção que o nó inserido possui uma hiperligação de ação que direciona para a página principal da disciplina porque o Boost não suporta a adição de nós sem uma hiperligação de ação. A hiperligação de ação será substituída assim que também ativar a configuração para contrair o nó ao mesmo tempo.';
$string['setting_insertnodesheading'] = 'Inserção de nós da raiz no menu de navegação do Boost';
$string['setting_insertresourcescoursenode'] = 'Inserir o nó "Recursos"';
$string['setting_insertresourcescoursenode_desc'] = 'Ativar esta opção irá inserir o nó "Recursos" no menu de navegação do Boost, que estará vinculado à página da visão global dos recursos.<br /><em> Esta configuração está associada à configuração \'Inserir o nó Atividades\'. Se ativar as duas configurações, estarão disponíveis o nó "Atividades" e o nó "Recursos", conforme solicitado. Se ativar apenas a configuração "Atividades", o nó "Atividades" também manterá um nó vinculado à página da visão global dos recursos.</em>';
$string['setting_removebadgescoursenode'] = 'Remover o nó "Medalhas"';
$string['setting_removebadgescoursenode_desc'] = 'Ativar esta opção removerá o nó "Medalhas" do menu de navegação do Boost, se não houver medalhas na disciplina. Para os professores, haverá outro nó "Medalhas" adicionado ao menu da disciplina (cog menu).<br /><em>Esta configuração só é processada quando o subsistema de medalhas do Moodle está ativado.</em>';
$string['setting_removecalendarnode'] = 'Remover o nó "Calendário"';
$string['setting_removecalendarnode_desc'] = 'Ativar esta opção removerá o nó "Calendário" do menu de navegação do Boost.';
$string['setting_removecompetenciescoursenode'] = 'Remover o nó "Competências"';
$string['setting_removecompetenciescoursenode_desc'] = 'Ativar esta opção removerá o nó "Competências" do menu de navegação do Boost, se não houver competências na disciplina. Para os professores, haverá outro nó "Competências" adicionado ao menu da disciplina (cog menu).<br /><em>Esta configuração só é processada quando o subsistema de competências do Moodle está ativado.</em>';
$string['setting_removecoursenodesheading'] = 'Remoção dos nós de disciplina do menu de navegação do Boost';
$string['setting_removecoursenodestechnicalhint'] = 'Informação técnica: é conseguido através da remoção do nó da árvore de navegação. Assim, o nó não pode ser acedido por outras partes do Moodle. Em configurações normais do Moodle, esta opção não deve causar qualquer problema.';
$string['setting_removedashboardnode'] = 'Remover o nó "Painel do utilizador"';
$string['setting_removedashboardnode_desc'] = 'Ativar esta opção removerá o nó "Painel do utilizador" do menu de navegação do Boost.';
$string['setting_removefirsthomenode'] = 'Remover o primeiro nó "Página principal" ou "Painel do utilizador"';
$string['setting_removefirsthomenode_desc'] = 'Ativar esta opção removerá o nó "Página principal" ou "Painel de utilizador" do menu de navegação do Boost, dependendo do que o utilizador escolheu ser a sua página inicial.';
$string['setting_removegradescoursenode'] = 'Remover o nó "Pauta"';
$string['setting_removegradescoursenode_desc'] = 'Ativar esta opção removerá o nó "Pauta" do menu de navegação do Boost. Será removido para todos os utilizadores, independentemente das permissões do utilizador e da configuração "Mostrar pauta aos alunos"';
$string['setting_removehomenode'] = 'Remover o nó "Página Principal"';
$string['setting_removehomenode_desc'] = 'Ativar esta opção removerá o nó "Página principal" do menu de navegação do Boost.';
$string['setting_removemycoursesnode'] = 'Remover o nó "As minhas disciplinas"';
$string['setting_removemycoursesnode_desc'] = 'Ativar esta opção removerá o nó "As minhas disciplinas" do menu de navegação do Boost.';
$string['setting_removemycoursesnodeperformancehint'] = 'Observação: Se ativar esta opção, e também está ativa a opção <a href="{$a->url}">navshowmycoursecategories</a>, a remoção do nó "As minhas disciplinas" demorará mais tempo e deve considerar em desativar a configuração \'navshowmycoursecategories\'.';
$string['setting_removenodesheading'] = 'Remoção dos nós da raiz do menu de navegação do Boost';
$string['setting_removenodestechnicalhint'] = 'Informação técnica: é conseguido através da atribuição do valor \'false\' ao atributo \'showinflatnavigation\' do nó. O nó estará oculto no menu de navegação mas permanecerá na árvore de navegação e poderá ser acedido por outras partes do Moodle.';
$string['setting_removeparticipantscoursenode'] = 'Remover o nó "Participantes"';
$string['setting_removeparticipantscoursenode_desc'] = 'Ativar esta opção removerá o nó "Participantes" do menu de navegação do Boost. Será removido para todos os utilizadores, independentemente das permissões do utilizador.';
$string['setting_removeprivatefilesnode'] = 'Remover o nó "Ficheiros privados"';
$string['setting_removeprivatefilesnode_desc'] = 'Ativar esta opção removerá o nó "Ficheiros privados" do menu de navegação do Boost.';
$string['setting_removesecondhomenode'] = 'Remover o segundo nó "Página principal" ou "Painel do utilizador"';
$string['setting_removesecondhomenode_desc'] = 'Ativar esta opção removerá o nó "Página Inicial" ou "Painel do utilizador", dependendo do que o utilizador escolheu não ser a sua página inicial, no menu de navegação do Boost.';
$string['settingspage_bottomnodes'] = 'Nós do fundo';
$string['settingspage_coursenodes'] = 'Nós de disciplina';
$string['settingspage_rootnodes'] = 'Nós da raiz';
