<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'es_mx', branch 'MOODLE_36_STABLE'
 *
 * @package   reservation
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Añadir solicitud';
$string['after10min'] = 'Después de 10 minutos de iniciado el evento';
$string['after12h'] = 'Después de 12 horas de iniciado el evento';
$string['after1d'] = 'Después de 1 día de iniciado el evento';
$string['after1h'] = 'Después de 1 hora de iniciado el evento';
$string['after1w'] = 'Después de 1 semana de iniciado el evento';
$string['after2d'] = 'Después de 2 días de iniciado el evento';
$string['after2h'] = 'Después de 2 horas de iniciado el evento';
$string['after2w'] = 'Después de 2 semanas de iniciado el evento';
$string['after30min'] = 'Después de 30 minutos de iniciado el evento';
$string['after3w'] = 'Después de 3 semanas de iniciado el evento';
$string['after4h'] = 'Después de 4 horas de iniciado el evento';
$string['after4w'] = 'Después de 4 semanas de iniciado el evento';
$string['after5min'] = 'Después de 5 minutos de iniciado el evento';
$string['after6h'] = 'Después de 26 horas de iniciado el evento';
$string['alreadybooked'] = 'Usted ya está reservado';
$string['alreadyoverbooked'] = 'Usted ya está en la lista de espera';
$string['atstart'] = 'Al inicio del evento';
$string['autohide'] = 'Auto ocultar lista de Reservación';
$string['availablerequests'] = 'Asientos disponibles';
$string['badcourse'] = 'El curso no existe';
$string['badparent'] = 'Esta reservación estaba conectada con otra reservación actualmente no restaurada. La conexión ha sido quitada. Si se necesita, reconéctelas manualmente.';
$string['badsection'] = 'La sección no existe en el curso "{$a}"';
$string['badteachers'] = 'El profesor con Email con ({$a}) no se encontró';
$string['badteachersmail'] = 'El Email del profesor especificado ({$a}) es falso';
$string['badtimeclose'] = 'la hora_de_cierre es falsa';
$string['badtimeend'] = 'la hora_de_término es falsa';
$string['badtimeopen'] = 'la hora_de_apertura es falsa';
$string['badtimestart'] = 'la hora_de_inicio es falsa';
$string['by'] = 'por';
$string['bydate'] = 'Fecha del evento';
$string['byname'] = 'Nombre';
$string['bysection'] = 'Tópico/Semana';
$string['cancelledon'] = 'Cancelado en';
$string['checkclashes'] = 'Revisar colisiones de lugar y hora';
$string['clashesfound'] = 'Se encontraron colisiones dehora o lugar';
$string['clashesreport'] = 'Reporte de colisiones';
$string['cleanview'] = 'Ver solamente las actualmente reservadas';
$string['close'] = 'cerrar';
$string['closed'] = 'Cerrado';
$string['completionreserved'] = 'Los estudiantes tienen que reservar para completar esta actividad';
$string['config'] = 'Configuraciones de reservación';
$string['configautohide'] = 'Esto define cuando es que las reservaciones deben ocultarse de la lista de reservaciones (mod/reservation/index.php). Esto puede ser útil si se usa con listas públicas, para mostrar una lista limpiada.';
$string['configcheckclashes'] = 'Habilite el botón de "Revisar colisiones de lugar y hora" en la página de edición de reservaciones';
$string['configconnectto'] = 'Defina en donde se conectará el módulo para buscar reservaciones';
$string['configdownload'] = 'Esto define el formato por defecto del archivo para descarga para todas las listas de solicitudes y reservaciones.';
$string['configevents'] = 'Esta configuración define cuales eventos serán creados para cada reservación';
$string['configfields'] = 'Esta configuración define cuales campos se mostrarán en la tabla de reservaciones';
$string['configlocations'] = 'Gestionar locaciones estándar para reservaciones en este sitio Moodle';
$string['configmanualusers'] = 'Esto define cual lista de usuarios se mostrará en el menú desplegable usado para reservar usuarios manualmente.';
$string['configmaxoverbook'] = 'Esto define el porcentaje máximo de sobrecupo para reservaciones.';
$string['configmaxrequests'] = 'Define el límite del menú desplegable en la página de editar reservación';
$string['configminduration'] = 'Esto indica la duración mínima de eveento reservado. Se usa con eventos que no terminan para revisarles disponibilidad de hora y lugar.';
$string['confignotifies'] = 'Esta configuración define caules notificaciones deben enviarse';
$string['configoverbookstep'] = 'Esto define el porcentaje de granularidad del sobrecupo. A un grado menor habrá mayor granularidad.';
$string['configpubliclists'] = 'Esto define si es que las listas de reservaciones son públicas (pueden verse sin entrar al sitio Moodle) o no.';
$string['configsortby'] = 'Esto define como se ordena la lista de reservaciones.';
$string['configsublimits'] = 'Definir el número de filas de reglas de sublímites en la página de edición de reservación';
$string['configupload'] = 'Crear varias reservaciones subiéndolas mediante archivo de texto';
$string['confirmdelete'] = '¿Está Usted seguro de querer eliminar las solicitudes de reservaciones seleccionadas?';
$string['connectedto'] = 'Reservación conectada a';
$string['connectto'] = 'Reservación conectable desde';
$string['description'] = 'Descripción';
$string['downloadas'] = 'Formato por defecto para descarga';
$string['duration10h'] = '10 horas';
$string['duration10min'] = '10 minutos';
$string['duration11h'] = '11 horas';
$string['duration12h'] = '12 horas';
$string['duration15min'] = '15 minutos';
$string['duration20min'] = '20 minutos';
$string['duration2h'] = '2 horas';
$string['duration30min'] = '30 minutos';
$string['duration3h'] = '3 horas';
$string['duration45min'] = '45  minutos';
$string['duration4h'] = '4 horas';
$string['duration5h'] = '5 horas';
$string['duration5min'] = '5 minutos';
$string['duration60min'] = '60 minutos';
$string['duration6h'] = '6 horas';
$string['duration7h'] = '7 horas';
$string['duration8h'] = '8 horas';
$string['duration90min'] = '90 minutos';
$string['duration9h'] = '9 horas';
$string['enablenote'] = 'Habilitar nota de usuarios';
$string['equal'] = 'igual a';
$string['err_sublimitsgreater'] = 'La suma de sublímites es mayor que el máximo permitido';
$string['err_timeendlower'] = 'La fecha de fin del evento está configurada anterior a la fecha de inicio';
$string['err_timeopengreater'] = 'La fecha de inicio de reservación está configurada posterior a la fecha de fin';
$string['eventevent'] = 'Crear un evento del curso en fechas de inicio a fin (del evento)';
$string['eventreminder'] = '{$a} (reservado)';
$string['eventrequestadded'] = 'Solicitud de reservación añadida';
$string['eventrequestcancelled'] = 'Solicitud de reservación cancelada';
$string['eventrequestdeleted'] = 'Solicitud de reservación eliminada';
$string['events'] = 'Eventos del calendario';
$string['eventsettings'] = 'Configuraciones del evento';
$string['explainconfig'] = 'Los administradores pueden definir aquí las configuraciones globales para el módulo de reservación';
$string['fields'] = 'Campos mostrados';
$string['fullview'] = 'Ver también reservaciones eliminadas';
$string['getreservation'] = 'Ver reservación';
$string['gradedmail'] = '{$a->teacher} ha publicado retroalimentación sobre su reservación \'{$a->reservation}\'

Usted puede verla aquí:

 {$a->url}';
$string['gradedmailhtml'] = '{$a->teacher}  ha publicado retroalimentación sobre su reservación \'<i>{$a->reservation}</i>\'<br /><br /> Usted puede verla <a href="{$a->url}">aquí</a>.';
$string['importreservations'] = 'Importar reservaciones';
$string['invalidreservationid'] = 'ID de reservación inválido';
$string['justbooked'] = 'Usted está reservado como: {$a}';
$string['justoverbooked'] = 'Usted está sobre_reservado como: {$a}';
$string['linenumber'] = '#';
$string['listafterclose'] = 'lista de solicitudes de reservación después de que la reservación fue cerrada';
$string['listalways'] = 'lista de solicitudes de reservación en cualquier momento';
$string['location'] = 'Lugar';
$string['locations'] = 'Gestionar Locaciones';
$string['locationslist'] = 'Lista de Locaciones';
$string['mail'] = 'La reservación \'{$a->reservation}\' ha sido cerrada.

Usted puede descargar la lista de reservaciones desde:

{$a->url}';
$string['mailhtml'] = 'Reservación <em>{$a->reservation}</em> ha sido cerrada.<br /><br /> Usted puede descargar la lista de reservaciones desde <a href="{$a->url}">aquí</a>.';
$string['mailrequest'] = 'La Reservación \'{$a->reservation}\' ha sido cerrada

Usted puede obtener su número de reservación en:

{$a->url}';
$string['mailrequesthtml'] = 'La reservación <em>{$a->reservation}</em> ha sido cerrada.<br /><br />
Usted puede obtener su número de reservación <a href="{$a->url}">aquí</a>.';
$string['manage'] = 'Gestionar';
$string['manualusers'] = 'Reservación manual, mostrar usuarios de';
$string['maxoverbook'] = 'Porcentaje máximo de sobrecupo';
$string['maxrequest'] = 'Máximo de reservaciones';
$string['message'] = 'Mensaje para participantes';
$string['minduration'] = 'Duración mínima del evento';
$string['modulename'] = 'Reservación';
$string['modulename_help'] = '<p>El principal objetivo de esta actividad es agendar sesiones de laboratorio y de exámenes, pero Usted puede agendar todo lo que desee.</p><p>El profesor puede definir el número de lugares disponibles para el evento, la fecha del evento y las fechas de apertura y de cierre de reservaciones.<br />Una reservación puede tener una calificación o una escala.<br />Los estudiantes pueden reservar y des-reservar un lugar y añadir una nota acerca de esta reservación.</p><p>Después de uqe inicie el evento, el profesor puede calificar el evento. Los estudiantes serán notificados por Email.</p><p>Puede descargarse la lista de reservaciones en varios formatos.</p>';
$string['modulenameplural'] = 'Reservaciones';
$string['newlocation'] = 'Nueva Locación';
$string['noclashcheck'] = 'El control de cheques no está habilitado. Por favor pregúntele al administrador del sitio.';
$string['noclashes'] = 'No se encontraron colisiones de lugar y hora';
$string['nocourseswithnsections'] = 'No se encontraron cursos con {$a} secciones';
$string['nolimit'] = 'Sin límite de reservación';
$string['nomorerequest'] = 'No más asientos disponibles';
$string['none'] = 'sin información acerca del orden de reservación';
$string['nooverbook'] = 'Sin sobrecupo';
$string['noparent'] = 'Ninguno/a';
$string['noreservations'] = 'Sin reservación';
$string['note'] = 'Nota';
$string['noteachers'] = 'Sin profesores disponibles';
$string['notequal'] = 'no es igual a';
$string['notifies'] = 'Notificaciones enviadas';
$string['notifygrades'] = 'Notificar reservación calificada a estudiantes';
$string['notifystudents'] = 'Notificar hora de reservación cerrada a estudiantes';
$string['notifyteachers'] = 'Notificar hora de reservación cerrada a profesores';
$string['notopened'] = 'No abierto';
$string['novalues'] = 'No hay valores disponibles para este campo';
$string['number'] = 'Número de Reservación';
$string['numberafterclose'] = 'número de solicitudes de reservación después de que la reservación fue cerrada';
$string['numberalways'] = 'número de solicitudes de reservación en cualquier momento';
$string['optional'] = 'Opcional';
$string['otherlocation'] = 'Otras locaciones especificadas';
$string['overbook'] = 'Sobrecupo';
$string['overbookonly'] = 'Solamente hay asientos en sobrecupo';
$string['overbookstep'] = 'Grado de sobrecupo';
$string['overview'] = 'Vista general';
$string['parent'] = 'Conectar esta reservación con';
$string['pluginadministration'] = 'Administración de reservación';
$string['pluginname'] = 'Reservación';
$string['privacy:metadata:reservation_note'] = 'Almacenar nota del usuario de una solicitud de reservación';
$string['privacy:metadata:reservation_note:note'] = 'Nota del usuario para una solicitud de reservación';
$string['privacy:metadata:reservation_request'] = 'Almacenar nota del usuario de una solicitud de reservación';
$string['privacy:metadata:reservation_request:grade'] = 'Calificación de solicitud de reservación de usuario';
$string['privacy:metadata:reservation_request:grader'] = 'ID de evaluador';
$string['privacy:metadata:reservation_request:mailed'] = 'El estado de notificación enviada de la calificación';
$string['privacy:metadata:reservation_request:reservationid'] = 'ID de la reservación';
$string['privacy:metadata:reservation_request:timecancelled'] = 'Fecha y hora de solicitud de cancelación';
$string['privacy:metadata:reservation_request:timecreated'] = 'Fecha y hora de solicitud de creación';
$string['privacy:metadata:reservation_request:timegraded'] = 'Fecha y hora de solicitud de calificación';
$string['privacy:metadata:reservation_request:userid'] = 'ID del usuario';
$string['publiclists'] = 'Lista pública de reservación';
$string['requestoverview'] = 'Vista general de Solicitudes';
$string['requests'] = 'Solicitudes';
$string['required'] = 'Requerido';
$string['reservation:addinstance'] = 'Añadir una nueva reservación';
$string['reservationcancelled'] = 'Reservación cancelada';
$string['reservationclosed'] = 'Reservaciones cerradas';
$string['reservationdenied'] = 'Reservaciones no permitidas';
$string['reservation:downloadrequests'] = 'Puede descargar lista de solicitudes';
$string['reservationevent'] = 'Crear un evento del curso con fechas desde apertura a cierre (hora de reservación)';
$string['reservation:grade'] = 'Puede asignar calificación';
$string['reservation_listing'] = 'Configuraciones de página de índice';
$string['reservation:manualdelete'] = 'Puede eliminar solicitudes de otros usuarios';
$string['reservation:manualreserve'] = 'Puede enviar solicitudes para otros usuarios';
$string['reservationnotopened'] = 'Las reservaciones aún no se han abierto';
$string['reservation_other'] = 'Otras configuraciones';
$string['reservation:reserve'] = 'Puede enviar sus propias solicitudes';
$string['reservations'] = 'Reservaciones';
$string['reservationsettings'] = 'Configuraciones de Reservaciones';
$string['reservation_settings'] = 'Editar configuraciones';
$string['reservation:uploadreservations'] = 'Puede subir reservaciones';
$string['reservation_view'] = 'Ver configuraciones de página';
$string['reservation:viewnote'] = 'Puede ver nota de solicitudes';
$string['reservation:viewrequest'] = 'Puede ver lista de solicitudes';
$string['reserve'] = 'Reservar';
$string['reservecancel'] = 'Cancelar reservación';
$string['reserved'] = 'Reservado';
$string['reservedon'] = 'Reservado en';
$string['reservedonconnected'] = 'Usted ya está reservado/a en una reservación conectada: {$a}';
$string['resetreservation'] = 'Remover todas las reservaciones';
$string['save'] = 'Guardar calificación';
$string['search:activity'] = 'Reservación - información de actividad';
$string['selectvalue'] = 'Sleccionar uno de los valores disponibles';
$string['showrequest'] = 'Los usuarios pueden ver la lista de solicitudes';
$string['showuserrequest'] = 'Los usuarios pueden ver';
$string['sortby'] = 'Listas de solicitudes ordenadas por';
$string['sublimit'] = 'Sublímite {$a}';
$string['sublimitrules'] = 'Reglas de sublímites';
$string['sublimits'] = 'Sublímites de Reservación';
$string['timeclose'] = 'Reservación termina en';
$string['timeend'] = 'Fecha de término';
$string['timeopen'] = 'Reservación inicia en';
$string['timestart'] = 'Fecha de inicio';
$string['tools'] = 'Herramientas de reservación';
$string['upload'] = 'Subida de Reservaciones';
$string['upload_help'] = '<p>Las reservaciones pueden subirse mediante archivo de texto. El formato del archivo debería de ser como sigue:</p><ul><li>Cada línea del archivo contiene un registro</li><li>Cada registro es una serie de datos separados por comas (o algun otro delimitador)</li><li>El primer registro contiene una lista de nombres_de_campos (\'\' fieldnames \'\') que definen el formato del resto del archivo</li><li>Los nombres_de_campos (\'\' fieldsname \'\') requeridos son  (así escritos en inglés) section, name y timestart</li><li>Los nombres_de_campo ( \'\' fieldsname \'\') opcionales son (así escritos en inglés) course, intro, teachers, timeend, maxgrade, timeopen, timeclose, maxrequest</li><li>Si course no está especificado, deberá de elegirse después de la vista previa</li></ul>';
$string['uploadreservations'] = 'Subir Reservaciones';
$string['uploadreservationspreview'] = 'Vista previa  de subir reservaciones';
$string['uploadreservationsresult'] = 'Resultado de subir reservaciones';
$string['useralreadybooked'] = 'Usuario ya reservado';
$string['userevent'] = 'Crear un evento de usuario desde fecha de inicio a fecha de término cuando el usuario reserva en una reservación';
$string['with'] = 'con';
$string['withselected'] = 'Con seleccionados...';
$string['yourgrade'] = 'Su calificación para esta reservación es: {$a->grade}/${a->maxgrade}';
$string['yournote'] = 'Su nota:';
$string['yourscale'] = 'Su calificación para esta reservación es:  {$a}';
