<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_enlightlite', language 'de', branch 'MOODLE_36_STABLE'
 *
 * @package   theme_enlightlite
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = 'Über';
$string['aboutus'] = '<b>Über</b> uns';
$string['aboutusdesc'] = 'Jeder unserer Kurse führt Sie zu einer bestimmten Karriere. Unternehmen wollen nur noch einen College-Absolventen, sie wollen Mitarbeiter mit spezifischen Fähigkeiten. Durch die Explosion von Social Media, neuen Geräten wie Tablets und Smartphones und einer zunehmenden Nutzung des Internets erhöhen Unternehmen ihr IT-Personal. Darüber hinaus suchen viele neue Unternehmen nach mehr Programmierern und Designern. Datenschutzbedenken nehmen weiter zu. Der Bereich Informationstechnologie deckt ein breites Spektrum ab, das Datenbankmanagement, Webentwicklung, Systemanalyse, Informationssicherheit und mehr umfasst. Das Beschäftigungswachstum wird laut US-Arbeitsministerium bis 2018 auf 53 Prozent geschätzt. Die Gehälter in vielen IT-Jobs werden voraussichtlich um 4 bis 6 Prozent steigen.';
$string['aboutustxt'] = 'Über uns';
$string['acourse_displaytype'] = 'Display Style verfügbarer Kurse';
$string['acourse_displaytypedesc'] = 'Wählen Sie einen Anzeigestil für die Liste der verfügbaren Kurse.';
$string['activateblock'] = 'Block aktivieren';
$string['address'] = 'Adresse';
$string['address_desc'] = 'Sie können Ihre Adresse eingeben.';
$string['autoslideshow'] = 'Auto play';
$string['autoslideshowdesc'] = 'Verwenden Sie diese Option, um die Folien nach dem Laden der Seite automatisch zu scrollen.';
$string['availablecoursebg_type'] = 'Hintergrundfarboptionen für verfügbare Kurse blockieren';
$string['availablecoursebg_typedesc'] = 'Wählen Sie eine Hintergrundoption, die Sie für den verfügbaren Kursblock wünschen.';
$string['availablecoursesbg'] = 'Hintergrundbild für verfügbaren Kursblock';
$string['availablecoursesbg_desc'] = 'Laden Sie ein Bild hoch, um den Hintergrund für verfügbare Kurse zu blockieren. <br> Die empfohlene Bildgröße breit = 1350px und hoch = 450px';
$string['backToTop_status'] = 'Schaltfläche "Zurück zum Anfang" hinzufügen';
$string['backToTop_statusdesc'] = 'Diese Option legt fest, ob auf Ihren Seiten eine Schaltfläche "Zurück zum Anfang" aktiviert werden soll.';
$string['bgcolor'] = 'Hintergrund Farbe';
$string['bgnone'] = 'Weisser Hintergrund';
$string['blindCurtainBottomLeft'] = 'Blind Curtain unten links';
$string['blindCurtainBottomRight'] = 'Blind Curtain unten rechts';
$string['blindCurtainSliceBottom'] = 'BlindCurtainSliceBottom';
$string['blindCurtainSliceTop'] = 'BlindCurtainSliceTop';
$string['blindCurtainTopLeft'] = 'BlindCurtainTopLinks';
$string['blindCurtainTopRight'] = 'BlindCurtainTopRechts';
$string['blog'] = 'Blog';
$string['blue'] = 'Blau';
$string['bottomCenter'] = 'BottomMitte';
$string['bottomLeft'] = 'BottomLinks';
$string['bottomLeftTopRight'] = 'BottomLinksMitteRechts';
$string['bottomRight'] = 'BottomLinks';
$string['bottomRightTopLeft'] = 'BottomRechtsMitteLinks';
$string['bounceIn'] = 'BounceIn';
$string['bounceInDown'] = 'BounceInUnten';
$string['bounceInLeft'] = 'BounceInLinks';
$string['bounceInRight'] = 'BounceInRechts';
$string['bounceInUp'] = 'BounceInOben';
$string['button'] = 'Button';
$string['buttonAnimate'] = 'Slide Bildbeschriftung Button Animation';
$string['buttonAnimatedesc'] = 'buttonAnimatedesc';
$string['categories'] = 'Kategorien';
$string['categoriesbg_desc'] = 'Laden Sie ein Bild hoch, um den Hintergrund der Kurskategorien zu blockieren. <br> Die empfohlene Bildgröße breit = 1350px und hoch = 450px';
$string['categoriesbg_type'] = 'Hintergrundfarboptionen für den Block der Kurskategorien';
$string['categoriesbg_typedesc'] = 'Wählen Sie eine Hintergrundoption, die Sie für den Block der Kurskategorien wünschen.';
$string['categoriescoursesbg'] = 'Hintergrundbild für den Block der Kurskategorien';
$string['categories_displaytype'] = 'Kurs Kategorien Display Style';
$string['categories_displaytypedesc'] = 'Wählen Sie einen Darstellungsstil für die Auflistung von Kursen aus.';
$string['categoryimgcategory'] = 'Das Bild für die Kategorie: {$a->category}.';
$string['categoryimgdesc'] = 'In diesem Abschnitt können Sie Bilder für jede der obersten Kurskategorien einstellen. Die empfohlene Bildgröße breit = 360px und hoch = 360px';
$string['categoryimgheading'] = 'Kategorie Bild';
$string['categoryimgheadingsub'] = 'VERWENDEN SIE BILDER, UM IHREN KURSKATEGORIEN ZU DARSTELLEN';
$string['cat-placeholder'] = 'Geben Sie hier den Kursnamen ein ...';
$string['center'] = 'Mitte';
$string['centerLeft'] = 'MitteLinks';
$string['centerRight'] = 'MitteRechts';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><img class=img-polaroid src="enlightlite/pix/screenshot.jpg" /><h3>Theme Credits</h3><p><h3>Moodle Enlightlite theme</h3><p>Dieses Design basiert auf dem Bootstrapbase-Moodle-Design</p><p><a href="http://getbootstrap.com">http://getbootstrap.com</a></p><p>Autoren: LMSACE Dev Team<br>Kontakt: info@lmsace.com<br>Website: <a target="_blank" href="http://www.lmsace.com">www.lmsace.com</a><br></p>';
$string['cmenuPosition'] = 'Kurs MegaMenü Position';
$string['cmenuPosition_desc'] = 'Verwenden Sie diese Einstellung, um die Position des MegaMenüs für Kurse in Hauptmenüs festzulegen.';
$string['cmenushow'] = 'Kurs MegaMenü aktivieren';
$string['cmenushowdesc'] = 'Verwenden Sie diese Einstellung, um das Erscheinungsbild von "Courses Mega Menu" in Hauptmenüs ein- oder auszublenden.';
$string['collapse'] = 'Zusammenbrechen';
$string['comboListboxType'] = 'Kombinationslisten-Anzeigestil';
$string['comboListboxType_desc'] = 'Wählen Sie einen Anzeigestil für den Kombinationslistenblock.';
$string['community'] = 'Community';
$string['configtitle'] = 'Enlightlite';
$string['contactus'] = 'Kontaktiere uns';
$string['contentAnimate'] = 'Inhaltsanimation (Slide #{$a->slide})';
$string['contentAnimatedesc'] = 'Verwenden Sie diese Option, um einen Animationstyp für den Folieninhalt festzulegen (z. B. Folientitel, Beschreibung und Schaltfläche).';
$string['contentOverlay'] = 'Inhaltsüberlagerung';
$string['copyright'] = 'Copyright Inhalt';
$string['copyrightdefault'] = 'Copyright © 2017 - Entwickelt von <a href="http://lmsace.com">LMSACE.com</a>. Powered by <a href="https://moodle.org">Moodle</a>';
$string['copyrightdesc'] = 'Geben Sie die Copyright-Informationen als Nur-Text oder Sprache ein: Sprach_Schlüssel für International Support (Ex <b>lang:information</b>). <br/>Die Standardsprachschlüssel finden Sie hier : /theme/enlightlite/lang[FOLDER].';
$string['copyrightheading'] = 'Copyright-Informationen ändern';
$string['courseexp'] = 'Kurserfahrung';
$string['courselayout'] = 'Kurs Kategorie Layout';
$string['courselayoutdesc'] = 'Um das Anzeigeformat der Seite für die Liste der Kurskategorien zu ändern, wählen Sie eines der hier aufgelisteten benutzerdefinierten Layouts. Dadurch wird das Layout des course/index.php (d. H. Kurskategorie) überschrieben. Jetzt wird die benutzerdefinierte Layoutdatei anstelle des Standardlayouts von Moodle verwendet.';
$string['courses'] = 'Kurse';
$string['curtainBottomLeft'] = 'CurtainBottomLinks';
$string['curtainBottomRight'] = 'CurtainBottomRechts';
$string['curtainSliceLeft'] = 'CurtainSliceLinks';
$string['curtainSliceRight'] = 'CurtainSliceRechts';
$string['curtainTopLeft'] = 'CurtainTopLinks';
$string['curtainTopRight'] = 'CurtainTopRechts';
$string['custom'] = 'Costum';
$string['customcss'] = 'Custom SCSS';
$string['customcssdesc'] = 'In diesem Feld können Sie SCSS- oder CSS-Code angeben, der am Ende des Stylesheets eingefügt wird.';
$string['custom_layout'] = 'Custom layout';
$string['default'] = 'Standard';
$string['defaultaddress'] = '20-A , Nehru Street , Sathyamoorthi Nagar Madurai - 625010 , Tamilnadu , India.';
$string['defaultemailid'] = 'yourmailid@example.com';
$string['default_layout'] = 'Moodle Standard Layout';
$string['defaultphoneno'] = '+123456789';
$string['default_type'] = 'Moodle Standard';
$string['describtionAnimate'] = 'Folienbeschriftung Beschreibung Animation';
$string['describtionAnimatedesc'] = 'Beschreibung der Slider-Beschriftung';
$string['disable'] = 'Ausschalten';
$string['dots'] = 'Punkte';
$string['dotThumb'] = 'Punkte und Vorschaubilder';
$string['doubleHeading'] = 'Doppelter Titel';
$string['double_heading_content'] = 'Doppelter Header Inhalt';
$string['email_desc'] = 'Sie können Ihre E-Mail-Adresse eingeben.';
$string['emailid'] = 'eMail';
$string['enable'] = 'Aktivieren';
$string['enlightlite_settings'] = 'ENLIGHTLITE THEME EINSTELLUNGEN';
$string['enlightlite_type'] = 'Benutzerdefinierter Stil für das Enlightlite-Design';
$string['enrolledcoursebg_type'] = 'Hintergrundfarbenoptionen für registrierte Kurse werden gesperrt';
$string['enrolledcoursebg_typedesc'] = 'Wählen Sie eine Hintergrundoption aus, die Sie für den Block der angemeldeten Kurse wünschen.';
$string['enrolledcoursesbg'] = 'Hintergrundbild für den eingeschriebenen Kursblock';
$string['enrolledcoursesbg_desc'] = 'Laden Sie ein Bild hoch, um den Hintergrund der Kurskategorien zu blockieren. <br> Die empfohlene Bildgröße breit = 1350px und hoch = 450px';
$string['expand'] = 'Erweitert';
$string['fadeIn'] = 'Einblenden';
$string['fadeInDown'] = 'Unten einblenden';
$string['fadeInDownBig'] = 'Unten gross einblenden';
$string['fadeInLeft'] = 'Links einblenden';
$string['fadeInLeftBig'] = 'Links gross einblenden';
$string['fadeInRight'] = 'Rechts einblenden';
$string['fadeInRightBig'] = 'Rechts gross einblenden';
$string['fadeInUp'] = 'Oben einblenden';
$string['fadeInUpBig'] = 'Oben gross einblenden';
$string['fadeOut'] = 'Ausblenden';
$string['featuredcoursesheading'] = 'Ausgewählte Kurse';
$string['feedbackprogram'] = 'Feedback Programm';
$string['flash'] = 'Flash';
$string['flip'] = 'Flip';
$string['flipInX'] = 'FlipInX';
$string['flipInY'] = 'FlipInY';
$string['flipOutX'] = 'FlipOutX';
$string['flipOutY'] = 'FlipOutY';
$string['followuson'] = 'Folge uns auf';
$string['footbgimg'] = 'Hintergrundbild für den Footerabschnitt';
$string['footbgimg_desc'] = 'Laden Sie ein Bild für den Hintergrund des Fußbereichs hoch. Die empfohlene Bildgröße breit = 1350px und hoch = 350px';
$string['footbgimg_type'] = 'Hintergrundfarboptionen für den Fußzeilenabschnitt';
$string['footbgimg_type_desc'] = 'Wählen Sie eine Hintergrundoption, die Sie für den Fußzeilenabschnitt haben möchten.';
$string['footerb1_status'] = 'Footer Block1 Display Option';
$string['footerb1_statusdesc'] = 'Wenn Sie diesen Block in der Fußzeile deaktivieren möchten, deaktivieren Sie das Kontrollkästchen <i> Aktivieren Sie diesen Block </ i>.';
$string['footerb2_status'] = 'Footer Block2 Display Option';
$string['footerb3_status'] = 'Footer Block3 Display Option';
$string['footerb4_status'] = 'Footer Block4 Display Option';
$string['footerblink'] = 'Footer Block Link';
$string['footerblink1default'] = '<div><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut et lobortis diam.&nbsp;</p><p>Duis tellus enim, vestibulum eget varius id, vulputate et mi. Nullam feugiat, diam quis interdum varius</p></div><a href="#"><span style="color: #fff; font-weight: bold; border-bottom: 1px solid #fff">Start Learning Now</span></a>';
$string['footerblink2default'] = 'Zukünftige Studenten|http://www.example.com/
Internationale Studenten |http://www.example.com/
Suchende|http://www.example.com/';
$string['footerblink3default'] = 'Zugänglichkeit|http://www.example.com/
Kontaktiere uns|http://www.example.com/
Jobs|http://www.example.com/';
$string['footerblink_desc'] = 'Sie können Footer Block {$ a-> blockno} Links so konfigurieren, dass sie von Designs angezeigt werden. Jede Zeile besteht aus einem Menütext (lang: language_key oder nur Klartext), einer durch Pipe-Zeichen getrennten Link-URL. Zum Beispiel: <pre> lang: moodlecommunity | https: //moodle.org
Moodle-Unterstützung | https: //moodle.org/support </ pre>';
$string['footerblock'] = 'Footer Block';
$string['footerbtitle1default'] = 'Über uns';
$string['footerbtitle2default'] = 'INFORMATION FÜR';
$string['footerbtitle3default'] = 'QUICK LINKS';
$string['footerbtitle4default'] = 'KONTAKTIERE UNS';
$string['footerbtitledesc'] = 'Geben Sie einen Titel für diesen Block als Nur-Text oder als Sprache: Sprachschlüssel für mehrsprachige Unterstützung ein. Sie finden die Schlüssel für die Themensprache hier: /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['footerdescription'] = 'Eine kurze Beschreibung im Kontext des Blocktitels. Für mehrsprachige Unterstützung geben Sie Sprache: language_key ein.';
$string['footerdescription_desc'] = 'Eine kurze Beschreibung im Rahmen des Blocktitels, für die mehrsprachige Unterstützung eingeben: language_key.';
$string['footerheading'] = 'Footer Blöcke';
$string['footnote'] = 'Fussnote';
$string['footphone_desc'] = 'Sie können Ihre Telefonnummer eingeben.';
$string['for_content'] = 'nur für Folieninhalt';
$string['for_slide'] = 'für volle Folie';
$string['frontpageheading'] = 'Marketing Spots';
$string['generallogo_menu'] = 'Farbschemas, Headers Styles, Logos und Menüs';
$string['green'] = 'Grün';
$string['header'] = 'Style {$a->no}';
$string['headerStyle'] = 'Header Style';
$string['headerStyle_desc'] = 'Verwenden Sie diese Option, um einen Kopfstil für Ihre Site festzulegen.';
$string['helpfaq'] = 'Hilfe & FAQ';
$string['hinge'] = 'Scharnier';
$string['id_base'] = 'Kundenspezifische Kurse';
$string['image'] = 'Bild';
$string['imagecolor'] = 'Designfarbe + Hintergrundbild';
$string['imagecolor_parellax'] = 'Bild mit Überlagerung';
$string['imageparelex'] = 'Bild Parallaxe';
$string['importDemo'] = 'Importieren Sie Demo-Inhalte';
$string['importDemo_desc'] = 'Aktivieren Sie das obige Kästchen, um die Demo-Daten zu importieren, die Ihre Installation wie unsere aussehen lassen <a href=\'http://www.lmsace.com/lab/m32/\'>Demo</a> site.<br> <b>WARNUNG!</b>Installieren Sie die Beispieldaten nicht auf Ihrer vorhandenen Live-Website, es sei denn, es handelt sich um eine Neuinstallation. <br> Es kann möglich sein, dass Ihre aktuellen Daten beschädigt werden. Es wird dringend empfohlen, die Beispieldaten in einer neuen Moodle-Installation zu installieren.';
$string['information'] = 'Information';
$string['informationdesc'] = '<div><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut et lobortis diam. </p><p>Duis tellus enim, vestibulum eget varius id, vulputate et mi. Nullam feugiat, diam quis interdum varius</p></div><a href="#" style="color: #353535;">Beginne zu lernen</a>';
$string['jobs'] = 'Jobs';
$string['knowmore'] = 'Mehr wissen';
$string['lavender'] = 'Lavendel';
$string['layout'] = 'Layout';
$string['learnanytime'] = 'Lerne immer und überall';
$string['learnanytimedesc'] = 'Genießen Sie unsere kostenlosen Online-Kurse, wo und wann immer Sie möchten. Greifen Sie auf Kursinhalte auf mobilen Geräten, Tablets oder Desktops zu.';
$string['learntitle'] = 'LERNEN SIE JEDERZEIT ÜBERALL';
$string['left'] = 'Links';
$string['legal'] = 'Rechtliches';
$string['lightSpeedIn'] = 'LightSpeedIn';
$string['link'] = 'Link';
$string['links'] = 'Links';
$string['loaderStatus'] = 'Fortschrittsbalken anzeigen';
$string['loaderStatus_desc'] = 'Verwenden Sie diese Option, um den Fortschrittsbalken anzuzeigen / auszublenden.';
$string['loadmore_type'] = 'Lade mehr Style';
$string['loginbg'] = 'Hintergrundbild für die Anmeldeseite';
$string['loginbgdesc'] = 'Laden Sie ein BG-Bild für die Benutzeranmeldeseite hoch. Die empfohlene Bildgröße breit = 1350px und hoch = 650px';
$string['loginheader'] = 'Melden Sie sich in Ihrem Konto an';
$string['loginpageType'] = 'Login-Seitenlayout';
$string['loginpageType_desc'] = 'Verwenden Sie diese Option, um das Layout der Anmeldeseite zu überschreiben.';
$string['logintheme'] = 'Enlightlite Theme Style';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Laden Sie das Logo-Bild für Ihre Website hoch. <br> Das Bild sollte 50px hoch sein und eine angemessene Breite (Minimum: 235px) haben.';
$string['managebgimages'] = 'HINTERGRUNDBILDER & FARBEN VERWALTEN';
$string['managefrontpage_items'] = 'VORDERE SEITE EINSETZEN';
$string['marketingspot'] = 'Marketing Spot';
$string['marketingspot1_content'] = '<div class="site-info"><div class="container"><div class="info-content"><div class="info-video"><video width="540px" controls><source src="" type="video/mp4"><source src="" type="video/ogg"></video></div><div class="info-block"><h2><b>About</b> Us</h2><p>Jeder unserer Kurse führt Sie zu einer bestimmten Karriere. Unternehmen wollen nur noch einen College-Absolventen, sie wollen Mitarbeiter mit spezifischen Fähigkeiten. Durch die Explosion von Social Media, neuen Geräten wie Tablets und Smartphones und einer zunehmenden Nutzung des Internets erhöhen Unternehmen ihr IT-Personal. Darüber hinaus suchen viele neue Unternehmen nach mehr Programmierern und Designern. Datenschutzbedenken nehmen weiter zu. Der Bereich Informationstechnologie deckt ein breites Spektrum ab, das Datenbankmanagement, Webentwicklung, Systemanalyse, Informationssicherheit und mehr umfasst.</p><div class="read-more"><a href="#">Mehr lesen</a></div></div><div class="clearfix"></div></div></div></div>';
$string['marketingspot1desc'] = 'Geben Sie den Blockinhalt für Marketing Spot 1 hier entweder als Sprachschlüssel oder als Text ein. Beispiel: lang: anzeigen oder Anzeigen';
$string['marketingSpot1_status'] = 'Diesen Block aktivieren';
$string['marketingSpot1_statusdesc'] = 'Wenn Sie diesen Block auf der Startseite deaktivieren möchten, deaktivieren Sie das Kontrollkästchen <i> Aktivieren Sie diesen Block </ i>.';
$string['marketingspot2desc'] = 'Geben Sie den Marketing Spot 2-Blockinhalt entweder als Sprachschlüssel oder als Text ein. Beispiel: lang: anzeigen oder Anzeigen';
$string['marketingSpot2_status'] = 'Diesen Block aktivieren';
$string['marketingSpot2_statusdesc'] = ': Wenn Sie diesen Block auf der Startseite deaktivieren möchten, deaktivieren Sie das Kontrollkästchen <i> Aktivieren Sie diesen Block </ i>.';
$string['media'] = 'Medien';
$string['meetups'] = 'Meetups';
$string['miscellaneous'] = 'SONSTIGE LINKS';
$string['mosaic'] = 'Mosaik';
$string['mosaicRandom'] = 'Mosaik zufällig';
$string['mosaicReverse'] = 'Mosaikumkehrung';
$string['mosaicSpiral'] = 'Mosaikspirale';
$string['mosaicSpiralReverse'] = 'Moasikspirale Umkehrung';
$string['mspot1media'] = '<iframe src="https://www.youtube.com/embed/fNE7pyDyw3Y" allowfullscreen="" frameborder="0" height="391" width="545"></iframe>';
$string['mspot2urldesc'] = 'Verwenden Sie diese Option, um die Verknüpfung für die Schaltfläche festzulegen.';
$string['mspot2urltarget_desc'] = 'Verwenden Sie diese Option, um das Link-Ziel für die Schaltfläche festzulegen.';
$string['mspot2urltxtdesc'] = 'Verwenden Sie diese Option, um den Text für die Schaltfläche festzulegen. Wenn Sie die Schaltfläche nicht möchten, setzen Sie diese Option auf leer. Geben Sie den Schaltflächentext als Nur-Text oder lang: language_key ein, um mehrsprachige Unterstützung zu erhalten. Sie finden die Schlüssel für die Themensprache hier: /theme/enlightlite/lang/de/theme_enlightlite.php';
$string['mspotdescdesc'] = 'Geben Sie die Beschreibung als Klartext oder lang: language_key ein, um mehrsprachige Unterstützung zu erhalten. Die Schlüssel für die Themensprache finden Sie hier: /theme/enlightlite/lang/en/theme_enlightlite.php.';
$string['mspotmediadesc'] = 'Fügen Sie ein Bild ein oder binden Sie ein Youtube-Video ein.';
$string['mspottitledesc'] = 'Geben Sie den Blocktitel als Klartext oder lang: language_key für mehrsprachige Unterstützung ein. <br> Sie finden die Schlüssel für die Themensprache hier: /theme/enlightlite/lang/en/theme_enlightlite.php. <br/> Sie finden die Standardsprachentasten hier: /theme/enlightlite/lang [FOLDER].';
$string['mycourse_displaytype'] = 'Meine Kurse zeigen';
$string['mycourse_displaytypedesc'] = 'Wählen Sie einen Anzeigestil für meine Kursliste.';
$string['name'] = 'Name';
$string['newcourses'] = 'Neue Kurse';
$string['newsmedia'] = 'News & Medien';
$string['newWindow'] = 'Neues Fenster';
$string['no_enrol'] = 'Anzahl der registrierten Benutzer';
$string['none'] = 'Keiner';
$string['numberofslides'] = 'Anzahl der Folien';
$string['numberofslidesdesc'] = 'Wählen Sie mit dieser Option zuerst die Anzahl der Folien aus und klicken Sie auf die Schaltfläche Änderungen speichern am unteren Rand der Einstellungsseite. Danach wird die Seite neu geladen, und Sie haben Optionen und Textfelder für die gewünschte Anzahl von Folien.';
$string['numberoftmonials'] = 'Anzahl der Testimonials';
$string['numberoftmonials_desc'] = 'Wählen Sie mit dieser Option zuerst die Anzahl der Erfahrungsberichte aus und klicken Sie auf die Schaltfläche Änderungen speichern am unteren Rand der Einstellungsseite. Danach wird die Seite neu geladen, und Sie haben Optionen und Textfelder für die gewünschte Anzahl an Testimonials.';
$string['ourorg'] = 'Unsere Organisation';
$string['oursiteorg'] = 'Unsere Website für Organisationen';
$string['ourteamAutoplay'] = 'Unser Team Autoplay';
$string['overlay'] = 'Theme Farbe';
$string['overlay_type'] = 'Überlagerung (Slide #{$a->slide})';
$string['overlaytype_desc'] = 'Mit dieser Option können Sie eine Überlagerung für den gesamten Folien- oder Folieninhalt festlegen (z. B. Folientitel, Beschreibung und Schaltfläche). Auf diese Weise garantieren Sie die Lesbarkeit von Textinhalten der Folie.';
$string['pagination'] = 'Seitennummerierung';
$string['pagination_desc'] = 'Verwenden Sie diese Option, um Paginierungsstile in der Diashow festzulegen.';
$string['pagi_none'] = 'Keine Seitennummerierung';
$string['patternselect'] = 'Wählen Sie das Farbschema der Website';
$string['patternselectdesc'] = 'Wählen Sie das Farbschema aus, das Sie für Ihre Site haben möchten.';
$string['phoneno'] = 'Telefonnummer';
$string['pluginname'] = 'Enlightlite';
$string['popularcoursebg_type'] = 'Hintergrundfarboptionen für beliebte Kurse blockieren';
$string['popularcoursebg_typedesc'] = 'Wählen Sie eine Hintergrundoption, die Sie für beliebte Kursblöcke wünschen.';
$string['popularCourse_iddesc'] = 'Bitte geben Sie die IDs der Kurse durch Kommas getrennt ein.';
$string['popularcourses'] = 'Beliebte Kurse';
$string['popularcoursesbg'] = 'Hintergrundbild für populären Kursblock';
$string['popularcoursesbg_desc'] = 'Laden Sie ein Bild hoch, um den Hintergrund für beliebte Kurse zu blockieren. Die empfohlene Bildgröße breit = 1350px und hoch = 450px';
$string['popularCourses_id'] = 'Beliebte Kurse IDs';
$string['popularCourse_status'] = 'Beliebte Kurse anzeigen';
$string['popularCourse_statusdesc'] = 'Aktivieren oder deaktivieren Sie den Block für beliebte Kurse auf der Startseite.';
$string['popularCourses_type'] = 'Generieren Sie beliebte Kurse basierend auf';
$string['popularCourse_typedesc'] = 'Bitte wählen Sie Ihre bevorzugten Kriterien aus, um beliebte Kurse zu generieren. <br> Wenn Sie die Option "Benutzerdefinierte Kurse" wählen, müssen Sie die IDS der Kurse, die Sie für beliebte Kurse anbieten möchten, in der Einstellung unten angeben.';
$string['preloader'] = 'Preloader-Bild';
$string['preloaderbg_color'] = 'Preloader-Hintergrundfarbe';
$string['preloaderbg_colordesc'] = 'Verwenden Sie diese Option, um die Hintergrundfarbe der Pre-Loader-Seite zu ändern.';
$string['preloader_desc'] = 'Verwenden Sie diese Option, um das Pre-Loader-Animationsbild (GIF) zu ändern.';
$string['preloader_status'] = 'Preloader aktivieren';
$string['preloader_statusdesc'] = 'Mit dieser Option können Sie die Preloader-Animation anzeigen / ausblenden, während Sie die Site-Seiten öffnen.';
$string['primarymenu'] = 'Hauptmenüpunkte';
$string['primary_menu'] = 'Home|#';
$string['primarymenudesc'] = 'Sie können hier ein Hauptmenü konfigurieren, das nach Themen angezeigt wird. Jede Zeile besteht aus einem Menütext, einer Link-URL (optional), einem QuickInfo-Titel (optional) und einem Sprachcode oder einer durch Kommas getrennten Codeliste (optional, um die Zeile nur Benutzern der angegebenen Sprache anzuzeigen), getrennt durch Pipe-Zeichen. Zeilen, die mit einem Bindestrich beginnen, werden als Menüelemente im vorherigen Menü der obersten Ebene angezeigt. Teiler können verwendet werden, indem Sie eine Zeile mit einem oder mehreren # -Zeichen einfügen. <br>
For example: <br> Moodle community|https://moodle.org <br>
-Moodle free support|https://moodle.org/support <br>
-Moodle Docs|http://docs.moodle.org|Moodle Docs <br>
-German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de <br>
-### <br>
-Moodle development|https://moodle.org/development <br>
Moodle.com|http://moodle.com/ <br>';
$string['purple'] = 'Lila';
$string['random'] = 'Zufällig';
$string['readmore'] = 'Mehr lesen';
$string['red'] = 'Rot';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['right'] = 'Recht';
$string['rollIn'] = 'RollIn';
$string['rotateIn'] = 'Rotieren';
$string['rotateInDownLeft'] = 'Rotieren unten Links';
$string['rotateInDownRight'] = 'Rotieren unten Rechts';
$string['rotateInUpLeft'] = 'Rotieren oben links';
$string['rotateInUpRight'] = 'Rotieren oben rechts';
$string['sameWindow'] = 'Alle Fenster';
$string['scrollBottom'] = 'ScrollBottom';
$string['scrollHorz'] = 'ScrollHorz';
$string['scrollLeft'] = 'ScrollLinks';
$string['scrollRight'] = 'ScrollRechts';
$string['scrollTop'] = 'ScrollMitte';
$string['search'] = 'Suche';
$string['search_courses'] = 'Kurse suchen';
$string['seeallcourses'] = 'Alle Kurse anzeigen';
$string['seeprofile'] = 'Profil anzeigen';
$string['siconbgc1default'] = '#47caf6';
$string['siconbgc2default'] = '#e84c3d';
$string['siconbgc3default'] = '#cd2129';
$string['siconbgc4default'] = '#3598dc';
$string['siconbgcdesc'] = 'Ändern Sie die Farben der Hintergrundfarbe für Social Media-Symbole';
$string['siconurl'] = 'Social Media Icon Url';
$string['siconurl1default'] = 'https://twitter.com/yourtwittername';
$string['siconurl2default'] = 'https://www.google.com/+yourgoogleplusid';
$string['siconurl3default'] = 'https://in.pinterest.com/yourpinterestname/';
$string['siconurl4default'] = 'https://www.facebook.com/yourfacebookid';
$string['siconurldesc'] = 'Die Social Media-URL Ihrer Organisation';
$string['signup'] = 'Anmelden';
$string['simpleFade'] = 'SimpleFade';
$string['sitenewsType'] = 'Darstellungsstil der Site-Nachrichten';
$string['sitenewsType_desc'] = 'Wählen Sie einen Anzeigestil für die Auflistung von Site-News';
$string['slidecaption'] = 'Titel (Slide #{$a->slide})';
$string['slidecaption1default'] = 'EINE RESPONSIVE AUSBILDUNG IM FOODUSIERTEN MODUS';
$string['slidecaption2default'] = 'Das Beste || MOODLE THEME für LMS';
$string['slidecaption3default'] = 'VOLL RESPONSIVE DESIGN';
$string['slidecaptiondefault'] = 'DIE BESTE LÖSUNG';
$string['slidecaptiondesc'] = 'Geben Sie den Titel für Ihre Folie als Nur-Text oder als lang: language_key für mehrsprachige Unterstützung ein.<br/> Sie finden die Schlüsselsprache der Themensprache hier: /theme/enlightlite/lang/de/theme_enlightlite.php';
$string['slidecontent'] = 'Inhaltsposition (Slide #{$a->slide})';
$string['slidecontentdesc'] = 'Verwenden Sie diese Option, um den Ort des Folientitels, der Beschreibung und der Schaltfläche in der Folie festzulegen.';
$string['slideContentStyle'] = 'Style Inhalt';
$string['slideContentStyle_desc'] = 'Verwenden Sie diese Option, um den Inhaltsstil in der Folie festzulegen. <br> Wenn Sie den Inhaltsstil als "Doppeltitel" auswählen, sollten Sie die beiden Titel für den Folientitel erwähnen. <br>
Die Titel müssen mit Pipe getrennt werden (|), Ex: <i> Titel1 | Titel2 </ i>.';
$string['slideCont_full'] = 'Inhaltbreite';
$string['slideCont_fulldesc'] = 'Verwenden Sie diese Option, um die Inhaltsbreite für die Folie festzulegen. Diese Breite wird als Prozentsatz der Breite des Hauptgitters berechnet. Der Standardwert für diese Option beträgt 50%.';
$string['slidedesc'] = 'Beschreibung(Slide #{$a->slide})';
$string['slidedesc1default'] = 'Mit Funktionen für eine beeindruckende Website für Schulen oder Universitäten';
$string['slidedesc2default'] = 'Für das Learning Management System konzipiert';
$string['slidedesc3default'] = 'Sieht auf allen mobilen Geräten perfekt aus';
$string['slidedescdefault'] = 'Ausbildung zum einzigartigen Moodle-Thema.';
$string['slidedesctext'] = 'Geben Sie die Beschreibung für Ihre Folie als Nur-Text oder als lang: language_key für mehrsprachige Unterstützung ein. <br>
Sie finden die Schlüssel für die Themensprache hier: /theme/enlightlite/lang/de/theme_enlightlite.php';
$string['slideEffect'] = 'Slide Animation';
$string['slideEffectdesc'] = 'Verwenden Sie diese Option, um einen Animationstyp für den Folienübergang festzulegen.';
$string['slideheight'] = 'Höhe der Diashow';
$string['slideheight_desc'] = 'Verwenden Sie diese Option, um die Höhe der Diashow festzulegen';
$string['slideimage'] = 'Bild (Slide #{$a->slide})';
$string['slideimagedesc'] = 'Laden Sie das Bild hoch, das Sie als Hintergrundbild der Folie anzeigen möchten. Die empfohlene Bildbreite = 1600px und Höhe = 1080px';
$string['slideImgpos'] = 'Schärfepunkt für das Bild';
$string['slideImgpos_desc'] = 'Verwenden Sie diese Option, um den Fokuspunkt des Diabildes auszuwählen.';
$string['slideInDown'] = 'Slide nach unten';
$string['slideInLeft'] = 'Slide nach links';
$string['slideInRight'] = 'Slide nach rechts';
$string['slideinterval'] = 'Pause Zeit';
$string['slideintervaldesc'] = 'Mit dieser Option können Sie die Pause oder Wartezeit zwischen den einzelnen Folienwechseln in der Diashow einstellen. Wert ist in Millisekunden (d. H. 1 Sekunde = 1000 Millisekunden)';
$string['slideInUp'] = 'Slide oben';
$string['slideno'] = 'Slide #{$a->slide}';
$string['slidenodesc'] = 'Geben Sie die Einstellungen für die Folie ein{$a->slide}.';
$string['slideOverlay'] = 'Deckkraft überlagern';
$string['slideOverlay_desc'] = 'Verwenden Sie diese Option, um die Deckkraft einzustellen. Der Standardwert für diese Option ist 0,4';
$string['sliderOverlay'] = 'Fullslide-Überlagerung';
$string['slider_type'] = 'Karussell';
$string['slideshowdesc'] = 'Mit dem Homepage-Schieberegler können Sie wichtige Elemente Ihrer Website promoten. Sie müssen mindestens ein Folienbild hochladen, damit die Diashow angezeigt wird. Folientitel, Beschreibung und Schaltfläche sind optional. Verwenden Sie größere Bilder, um optimale Ergebnisse zu erzielen. Mit dem Schieberegler werden Ihre Bilder auf Höhe und Breite der Diashow zugeschnitten. Wenn Sie zu kleine Bilder verwenden, funktioniert es nicht richtig.';
$string['slideshowheading'] = 'Homepage Diashow';
$string['slideshowheadingsub'] = 'SLIDER OPTIONEN';
$string['slideshowStatus'] = 'Homepage-Slider anzeigen';
$string['slideshowStatus_desc'] = 'Wählen Sie "Nein", wenn Sie keinen Bildschieberegler auf Ihrer Startseite wünschen.';
$string['slideStatus'] = 'Status (Slide #{$a->slide})';
$string['slideStatus_desc'] = 'Wählen Sie "Deaktivieren", wenn Sie diese Folie nicht im Homepage-Schieberegler anzeigen möchten.';
$string['slideurl1'] = 'Button 1 URL';
$string['slideurl1desc'] = 'Verwenden Sie diese Option, um den Link für die erste Schaltfläche der Folie festzulegen.';
$string['slideurl1text'] = 'Button 1 Text';
$string['slideurl1textdesc'] = 'Verwenden Sie diese Option, um den Text für die erste Schaltfläche der Folie festzulegen. Wenn Sie keine Schaltfläche auf Ihrer Folie haben möchten, setzen Sie diese Option auf leer. <br> Geben Sie den Text der Schaltfläche als Nur-Text oder als lang: language_key für mehrsprachige Unterstützung ein. <br> Die Tasten für die Themensprache finden Sie hier: /theme/enlightlite/lang/de/theme_enlightlite.php';
$string['slideurl2'] = 'Button 2 URL';
$string['slideurl2desc'] = 'Verwenden Sie diese Option, um den Link für die zweite Schaltfläche der Folie festzulegen.';
$string['slideurl2text'] = 'Button 2 Text';
$string['slideurl2textdesc'] = 'Verwenden Sie diese Option, um den Text für die zweite Schaltfläche der Folie festzulegen. Wenn Sie keine Schaltfläche auf Ihrer Folie haben möchten, setzen Sie diese Option auf leer. <br> Geben Sie den Text der Schaltfläche als Nur-Text oder als lang: language_key für mehrsprachige Unterstützung ein. <br> Die Tasten für die Themensprache finden Sie hier: /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['socialicon'] = 'Social Media Icon';
$string['socialicon1default'] = 'Twitter';
$string['socialicon2default'] = 'Google-plus';
$string['socialicon3default'] = 'Pinterest-p';
$string['socialicon4default'] = 'Facebook-f';
$string['socialicondesc'] = 'Geben Sie den Namen des Symbols ein, das Sie verwenden möchten. Liste ist <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">here</a>. Just enter what is after the "fa-".';
$string['socialmediadesc'] = '<strong> Dieser Block enthält Social-Media-Symbole </strong>';
$string['stampede'] = 'Ansturm';
$string['style'] = 'Style';
$string['target'] = 'Ziel';
$string['testiGeneral'] = 'Allgemeine Einstellungen der Testimonials';
$string['testimonial'] = 'Testimonial';
$string['testimonialAutoplay'] = 'Auto Play';
$string['testimonialno'] = 'Testimonial {$a->tmonial}';
$string['testimonialnodesc'] = 'Geben Sie die Einstellungen für das Testimonial ein {$a->tmonial}.';
$string['testimonialsbg'] = 'Hintergrundbild für Zeugnisblock';
$string['testimonialsbg_desc'] = 'Laden Sie ein Bild für den Hintergrund des Testimonialblocks hoch. Die empfohlene Bildgröße breit = 1350px und hoch = 350px';
$string['testimonialsbg_type'] = 'Hintergrundfarboptionen für Testimonials-Block';
$string['testimonialsbg_typedesc'] = 'Wählen Sie eine Hintergrundoption, die Sie für den Block der Testimonials haben möchten.';
$string['text'] = 'Text';
$string['textFillContent'] = 'TextFillContent';
$string['text_item_content'] = 'Text_Link_Inhalt';
$string['themebased'] = 'Einfaches Thema gefärbt';
$string['themecolorsettings'] = 'Theme Farbe';
$string['themegeneralsettings'] = 'Allgemein';
$string['thumbnails'] = 'Vorschaubilder';
$string['title'] = 'Titel';
$string['tmonialheading'] = 'Testimonials';
$string['tmonialheadingsub_desc'] = 'In diesem Abschnitt können Sie Erfahrungsberichte von Benutzern auf der Startseite anzeigen.';
$string['tmonialimg'] = 'Nutzerbild';
$string['tmonialimgdesc'] = 'Die empfohlene Bildgröße breit = 1350px und hoch = 450px';
$string['tmonialtext'] = 'Testimonial';
$string['tmonialtext_default'] = 'Wir erstellen dieses Curriculum mit Enlightlite, weil wir glauben, dass es widerspiegelt, was Entwickler überall wissen sollten.';
$string['tmonialTraversal_status'] = 'Zeige Paginierung';
$string['tmonialuname'] = 'Nutzername';
$string['tmonialuname_default'] = 'Peter Lubbers';
$string['toggletmonial'] = 'Testimonials Display';
$string['toggletmonialdesc'] = 'Wenn Sie diesen Block auf der Startseite deaktivieren möchten, deaktivieren Sie das Kontrollkästchen <i> Aktivieren Sie diesen Block </ i>.';
$string['topCenter'] = 'TopCenter';
$string['topLeft'] = 'TopLinks';
$string['topLeftBottomRight'] = 'Oben links unten rechts';
$string['topRight'] = 'TopRechts';
$string['typesearch'] = 'Geben Sie ein und drücken Sie Suchen';
$string['typography'] = 'Typografie';
$string['url'] = 'URL';
$string['urltarget1'] = 'Button 1 Ziel';
$string['urltarget2'] = 'Button 2 Ziel';
$string['urltarget_desc'] = 'Setzen Sie diese Option auf <i>Neues Fenster</i>, wenn Sie die URL in einer neuen Registerkarte öffnen möchten.';
$string['viewall'] = 'Alles zeigen';
$string['viewallcourses'] = 'Alle Kurse zeigen';
$string['whatweoffer'] = 'Was wir anbieten';
$string['zoom-In'] = 'Zoom-In';
$string['zoomInDown'] = 'Zoom nach Unten';
$string['zoomInLeft'] = 'Zoom nach Links';
$string['zoomInRight'] = 'Zoom nach Rechts';
$string['zoomInUp'] = 'Zoom nach Oben';
