<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_coupon', language 'de', branch 'MOODLE_36_STABLE'
 *
 * @package   block_coupon
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:coupon:delete'] = 'Gutschein löschen';
$string['action:coupon:delete:confirm'] = 'Diesen Gutschein löschen? Vorgang kann nicht rückgängig gemacht werden!';
$string['action:error:delete'] = 'Fehler löschen';
$string['and'] = 'und';
$string['blockname'] = 'Gutschein';
$string['button:next'] = 'Weiter';
$string['button:save'] = 'Gutscheine erstellen';
$string['button:submit_coupon_code'] = 'Gutschein einlösen';
$string['cohort'] = 'Globale Gruppe';
$string['confirm_coupons_sent_body'] = 'Hallo,<br /><br />

Wir haben die Gutscheine, die du am {$a->timecreated} erstellt hast, versendet.<br /><br />

Mit freundlichen Grüßen,<br /><br />

Moodle Administrator';
$string['confirm_coupons_sent_subject'] = 'Alle Gutscheine wurden verschickt';
$string['coupon:addinstance'] = 'Neues Gutschein-Block einfügen';
$string['coupon:administration'] = 'Einstellungen des Gutschein-Blocks ändern';
$string['coupon:deleted'] = 'Der Gutschein wurde gelöscht';
$string['coupon:generatecoupons'] = 'Neuen Gutschein erstellen';
$string['coupon:inputcoupons'] = 'Mit einem Gutschein einschreiben';
$string['coupon_mail_content'] = 'Hallo {$a->to_name},<br /><br />

Mit dieser Nachricht werden neu erstellte Gutscheine verschickt. Sie sind im Anhang dieser Nachricht. <br /><br />

Mit freundlichen Grüßen,<br /><br />

{$a->from_name}';
$string['coupon_mail_csv_content'] = 'Hallo ##to_gender## ##to_name##,<br /><br />

Du bist in unserem Kurs ##course_fullnames## eingeschrieben.
Während des Kurses hast du Zugriff auf unser online Lernsystem : ##site_name##.<br /><br />

In diesem Lernsystem bekommst du, abgesehen von Kursunterlagen, auch Möglichkeiten, dich mit anderen Teilnehmern zu vernetzen.
Der Kurs fängt mit vorbereitenden Aufgaben an. Wir bitten dich, diese Aufgaben spätestens 3 Arbeitstage vor dem Kursanfang genauer anzuschauen.
So können du und der Dozent / die Dozentin sich ordentlich auf den Kurs vorbereiten.<br /><br />

Alle Kursunterlagen werden dir spätestens 4 Tage vor dem Kursanfang zur Verfügung stehen.
Möglicherweise fügt der Dozent / die Dozentin später weitere Unterlagen hinzu, zum Beispiel nach einer Präsenzeinheit. In einem solchen Fall wirst du die Unterlagen auch hier im Lernsystem wiederfinden.
Während den Treffen werden keine Papierunterlagen verteilt. Wir empfehlen, ein Laptop oder Tablet mitzubringen. <br /><br />

Der Gutschein für den Kurs ist als Anhang angefügt. Dieser Gutschein ist persönlich und einmalig. Er verleiht dir Zugang zu den passenden Kursen für deine Ausbildung.
Lese die Anweisungen auf dem Gutschein bitte sorgfältig.<br /><br />

Solltest du noch Fragen haben über das Anmelden oder über sonstige Probleme, kannst du unsere Helpdesk kontaktieren.
Informationen dazu findest du in unserem Lernsystem.
Wenn unsere Helpdesk nicht besetzt sein sollte, bitten wir dich, deinen Namen, Mailadresse und Telefonnummer anzugeben. Wir werden uns dann so schnell wie möglich melden.<br /><br />

Viel Erfolg mit dem Kurs.<br /><br />

Mit freundlichen Grüßen,<br /><br />

##site_name##';
$string['coupon_mail_csv_content_cohorts'] = 'Hallo ##to_gender## ##to_name##,<br /><br />

Du bist in unserem Kurs ##course_fullnames## eingeschrieben.
Während des Kurses hast du Zugriff auf unser online Lernsystem : ##site_name##.<br /><br />

In diesem Lernsystem bekommst du, abgesehen von Kursunterlagen, auch Möglichkeiten, dich mit anderen Teilnehmern zu vernetzen.
Der Kurs fängt mit vorbereitenden Aufgaben an. Wir bitten dich, diese Aufgaben spätestens 3 Arbeitstage vor dem Kursanfang genauer anzuschauen.
So können du und der Dozent / die Dozentin sich ordentlich auf den Kurs vorbereiten.<br /><br />

Alle Kursunterlagen werden dir spätestens 4 Tage vor dem Kursanfang zur Verfügung stehen.
Möglicherweise fügt der Dozent / die Dozentin später weitere Unterlagen hinzu, zum Beispiel nach einer Präsenzeinheit. In einem solchen Fall wirst du die Unterlagen auch hier im Lernsystem wiederfinden.
Während den Treffen werden keine Papierunterlagen verteilt. Wir empfehlen, ein Laptop oder Tablet mitzubringen. <br /><br />

Der Gutschein für den Kurs ist als Anhang angefügt. Dieser Gutschein ist persönlich und einmalig. Er verleiht dir Zugang zu den passenden Kursen für deine Ausbildung.
Lese die Anweisungen auf dem Gutschein bitte sorgfältig.<br /><br />

Solltest du noch Fragen haben über das Anmelden oder über sonstige Probleme, kannst du unsere Helpdesk kontaktieren.
Informationen dazu findest du in unserem Lernsystem.
Wenn unsere Helpdesk nicht besetzt sein sollte, bitten wir dich, deinen Namen, Mailadresse und Telefonnummer anzugeben. Wir werden uns dann so schnell wie möglich melden.<br /><br />

Viel Erfolg mit dem Kurs.<br /><br />

Mit freundlichen Grüßen,<br /><br />

##site_name##';
$string['coupon_mail_subject'] = 'Ein Moodle Gutschein wurde erstellt';
$string['coupon:myaddinstance'] = 'Neues Gutschein-Block in My Moodle-Seite einfügen';
$string['coupon_recipients_desc'] = 'Die folgenden Spalten müssen in der hochgeladenen CSV-Datei vorhanden sein (die Reihenfolge ist nicht wichtig): E-Mail, Geschlecht, Name.<br/>
Für jede Person in der CSV, wird ein Gutschein erstellt und dem Teilnehmer zugeschickt.<br/>
Beachte, dass diese Gutscheine von einem Hintergrundprogramm asynchron erstellt werden. Sie werden  <i>nicht</i> sofort verfügbar sein.
Der Grund dafür ist, dass die Erstellung von Gutscheinen lange dauern kann, besonders wenn mehrere Gutscheine für mehrere Teilnehmer erstellt werden sollen.';
$string['coupon:send:fail'] = 'Mailversand fehlgeschlagen! Fehlermeldung: {$a}';
$string['coupons_ready_to_send'] = 'Deine Gutscheine wurden erstellt und werden am eingestellten Datum versendet.<br /> Wenn alle Gutscheine verschickt wurden, wirst du eine Bestätigung per E-Mail bekommen.';
$string['coupons_sent'] = 'Deine Gutscheine wurden erstellt. Eine E-Mail mit den Gutscheinen im Anhang ist unterwegs zu dir.';
$string['coupon:viewallreports'] = 'Gutschein-Bericht zeigen (für alle Gutscheine)';
$string['coupon:viewreports'] = 'Gutschein-Bericht zeigen (nur für meine Gutscheine)';
$string['course'] = 'Kurs';
$string['days_access'] = '{$a} Tage';
$string['default-coupon-page-template-botleft'] = '<ol>
<li>Melde dich an bei {site_url}</li>
<li>Du wirst eine E-Mail mit einem Aktivierungslink bekommen. Folge diesen Link um deinen Zugang zu aktivieren. </li>
<li>Gib die Nummer des Gutscheins im Block "Gutschein" ein.</li>
<li>Viel Vergnügen!</li>
</ol>';
$string['default-coupon-page-template-botright'] = '<ol>
<li>Melde dich an bei {site_url}</li>
<li>Gib die Nummer des Gutscheins im Block "Gutschein" ein.</li>
<li>Viel Vergnügen!</li>
</ol>';
$string['default-coupon-page-template-main'] = 'Mit diesem Gutschein kannst du Zugang zu E-Learning Modul bekommen. Du hast  {accesstime} Zugriff auf das Modul.

Aktiviere den Zugang mit dem nachstehenden Kode.

{coupon_code}';
$string['download-sample-csv'] = 'Beispieldatei (CSV) herunterladen';
$string['enrolperiod:indefinite'] = '<i>unbegrenzt</i>';
$string['error:alternative_email_invalid'] = 'Wenn du \'andere Mailadresse verwenden\' ausgewählt hast, sollte dieses Feld eine gültige Mailadresse enthalten.';
$string['error:alternative_email_required'] = 'Wenn du \'andere Mailadresse verwenden\' ausgewählt hast, ist dieses Feld ein Pflichtfeld.';
$string['error:cohort_sync'] = 'Fehler beim Synchronisieren der globalen Gruppen. Bitte Kontaktiere den Support.';
$string['error:coupon_already_used'] = 'Der Gutschein mit dieser Nummer wurde bereits verwendet.';
$string['error:coupon_amount-recipients-both-set'] = 'Gebe bitte die Anzahl Gutscheine an, die erstellt werden sollen, ODER wähle eine CSV-Liste mit Adressaten aus.';
$string['error:coupon_amount-recipients-both-unset'] = 'Dieses Feld oder das Feld Adressaten muss besetzt sein.';
$string['error:coupon_amount_too_high'] = 'Gebe bitte eine Menge zwischen {$a->min} und {$a->max} an.';
$string['error:coupon_reserved'] = 'Der Gutschein mit dieser Nummer wurde für einen anderen Teilnehmer ausgestellt.';
$string['error:course-coupons-not-copied'] = 'Das Kopieren von den Gutschein-Kursen in die neue Tabelle coupon_courses ist fehlgeschlagen. Bitte kontaktiere den Support.';
$string['error:course-not-found'] = 'Der Kurs ist nicht vorhanden.';
$string['error:invalid_coupon_code'] = 'Sie haben eine ungültige Gutschein-Nummer eingegeben.';
$string['error:invalid_email'] = 'Bitte geben Sie eine gültige Mailadresse ein.';
$string['error:missing_cohort'] = 'Die globale Gruppe, die mit diesem Gutschein verknüpft ist, existiert nicht mehr. Bitte kontaktiere den Support.';
$string['error:missing_course'] = 'Der Kurs, der mit diesem Gutschein verknüpft ist, existiert nicht mehr. Bitte kontaktiere den Support.';
$string['error:missing_group'] = 'Die Gruppen, die mit diesem Gutschein verknüpft ist, existieren nicht mehr. Bitte kontaktiere den Support.';
$string['error:moodledata_not_writable'] = 'In das Verzeichnis moodledata/coupon_logos hast du keine Schreibrechte. Dieses Recht muss dir erst gewährt werden.';
$string['error:no_coupons_submitted'] = 'Keiner deiner Gutscheine wurde bis jetzt eingelöst.';
$string['error:nopermission'] = 'Für diesen Vorgang haben Sie keine Berechtigung.';
$string['error:numeric_only'] = 'Dieses Feld muss mit einer Zahl besetzt werden.';
$string['error:plugin_disabled'] = 'Das cohort_sync Plugin wurde abgeschaltet. Bitte kontaktiere den Support.';
$string['error:recipients-columns-missing'] = 'Die Datei konnte nicht geprüft werden. Bist du sicher, dass die richtigen Spalten und Trennzeichen eingegeben wurden?';
$string['error:recipients-email-invalid'] = 'Die Mailadresse {$a->email} ist nicht gültig. Bitte in der CSV-Datei korrigieren.';
$string['error:recipients-empty'] = 'Bitte mindestens einen Teilnehmer eingeben.';
$string['error:recipients-extension'] = 'Es können nur CSV-Dateien hochgeladen werden.';
$string['error:recipients-invalid'] = 'Die Datei konnte nicht geprüft werden. Bist du sicher, dass die richtigen Spalten und Trennzeichen eingegeben wurden?';
$string['error:recipients-max-exceeded'] = 'Die CSV-Datei enthält mehr als die Höchstzahl von 10.000 Gutschein-Adressaten. Bitte kürze die Datei.';
$string['error:required'] = 'Dieses Feld darf nicht leer sein.';
$string['error:sessions-expired'] = 'Ihre Sitzung ist abgelaufen. Bitte erneut versuchen.';
$string['error:unable_to_enrol'] = 'Die Einschreibung in den neuen Kurs ist fehlgeschlagen. Bitte kontaktiere den Support.';
$string['error:wrong_code_length'] = 'Geben Sie eine Zahl zwischen 6 und 32 ein.';
$string['error:wrong_doc_page'] = 'Sie versuchen eine Seite zu erreichen, die nicht existiert.';
$string['error:wrong_image_size'] = 'Der hochgeladene Hintergrund hat nicht die vorgeschriebene Größe. Bitte laden Sie ein Bild hoch mit einem Seitenverhältnis von 210 mm zu 197 mm.';
$string['heading:administration'] = 'Bearbeiten';
$string['heading:amountForm'] = 'Mengen-Einstellungen';
$string['heading:coupon_type'] = 'Art Gutschein';
$string['heading:csvForm'] = 'CSV-Einstellungen';
$string['heading:general_settings'] = 'Letzte Einstellungen';
$string['heading:generatecoupons'] = 'Gutscheine erstellen';
$string['heading:imageupload'] = 'Bild hochladen';
$string['heading:info'] = 'Info';
$string['heading:input_cohorts'] = 'Globale Gruppen auswählen';
$string['heading:input_coupon'] = 'Gutschein eingeben';
$string['heading:inputcoupons'] = 'Gutschein eingeben';
$string['heading:input_course'] = 'Kurs auswählen';
$string['heading:input_groups'] = 'Gruppen auswählen';
$string['heading:label_instructions'] = 'Anleitung';
$string['heading:manualForm'] = 'Manuelle Einstellungen';
$string['label:alternative_email'] = 'Andere Mailadresse';
$string['label:alternative_email_help'] = 'Für den Gutschein-Versand wird grundsätzlich diese Adresse verwendet, wenn \'Andere Mailadresse verwenden\' ausgewählt wurde.';
$string['label:api_enabled'] = 'API aktivieren';
$string['label:api_enabled_desc'] = 'Das Gutschein API ermöglicht die Erstellung von Gutscheinen über ein externes System.';
$string['label:api_password'] = 'API Passwort';
$string['label:api_password_desc'] = 'Das Passwort wird gebraucht, um mit Hilfe des API einen Gutschein zu erstellen.';
$string['label:api_user'] = 'API Benutzername';
$string['label:api_user_desc'] = 'Der API Benutzername wird gebraucht, um mit Hilfe des API einen Gutschein zu erstellen.';
$string['label:cleanupage'] = 'Das höchste Alter?';
$string['label:cleanupage_help'] = 'Gib das höchste Alter ein, das ein unbenutzter Gutschein erreichen darf, bevor er gelöscht wird.';
$string['label:cohort'] = 'Globale Gruppe';
$string['label:connected_courses'] = 'Verknüpfte(r) Kurs(e)';
$string['label:coupon_amount'] = 'Anzahl Gutscheine';
$string['label:coupon_amount_help'] = 'Die Anzahl Gutscheine, die erstellt werden sollen. Nutze ENTWEDER dieses Feld ODER das Feld Adressaten, nicht beide.';
$string['label:coupon_code'] = 'Gutschein-Kode';
$string['label:coupon_code_help'] = 'Der Gutschein-Kode ist der Kode, der den Gutschein eindeutig identifiziert. Sie finden ihn auf Ihren Gutschein.';
$string['label:coupon_code_length'] = 'Länge des Kodes';
$string['label:coupon_code_length_desc'] = 'Anzahl Zeichen, die für einen Gutschein-Kode verwendet werden sollen.';
$string['label:coupon_cohorts'] = 'Globale Gruppe(n)';
$string['label:coupon_cohorts_help'] = 'Wähle eine globale Gruppe (oder mehrere) zu denen deine Teilnehmer gehören sollen.';
$string['label:coupon_connect_course'] = 'Kurs(e) hinzufügen';
$string['label:coupon_connect_course_help'] = 'Wähle alle Kurse, die zu der globalen Gruppe gehören sollen.
    <br /><b><i>Beachte: </i></b>Alle Teilnehmer, die bereits zu dieser globalen Gruppe gehören, werden ebenfalls automatisch in die genannten Kurse eingeschrieben!';
$string['label:coupon_courses'] = 'Kurs(e)';
$string['label:coupon_courses_help'] = 'Wähle alle Kurse in die deine Teilnehmer eingeschrieben werden sollen.';
$string['label:coupon_email'] = 'Mailadresse';
$string['label:coupon_email_help'] = 'Dies ist die Mailadresse, an die die Gutscheine geschickt werden.';
$string['label:coupon_groups'] = 'Guppe(n) hinzufügen';
$string['label:coupon_groups_help'] = 'Wähle die Gruppen, zu denen deine Teilnehmer gehören sollen, wenn sie in die Kurse eingeschrieben werden.';
$string['label:coupon_recipients'] = 'Empfänger';
$string['label:coupon_recipients_help'] = 'Mit diesem Feld kannst du eine CSV-Datei mit Teilnehmerdaten hochladen.';
$string['label:coupon_recipients_txt'] = 'Empfänger';
$string['label:coupon_recipients_txt_help'] = 'In diesem Feld kannst letzte Änderungen an der hochgeladenen CSV-Datei vornehmen.';
$string['label:coupon_type'] = 'Gutschein für';
$string['label:coupon_type_help'] = 'Die Gutscheine werden entweder Zugang zu einem Kurs oder zu einer (oder mehrere) globalen Gruppe geben.';
$string['label:current_image'] = 'Aktueller Hintergrund für die Gutscheine';
$string['label:date_send_coupons'] = 'Versanddatum';
$string['label:date_send_coupons_help'] = 'Datum, an dem die Gutscheine an den oder die Empfänger geschickt werden.';
$string['label:email_body'] = 'Email-Nachricht';
$string['label:email_body_help'] = 'Die Begleitmail, an die der Gutschein angehängt ist.';
$string['label:enablecleanup'] = 'Löschen von nicht eingelösten Gutscheinen zulassen?';
$string['label:enablecleanup_help'] = 'Wenn diese Option ausgewählt ist, können nicht eingelöste Gutscheine automatisch aus dem System gelöscht werden.';
$string['label:enrolment_period'] = 'Dauer der Einschreibung';
$string['label:enrolment_period_help'] = 'Dauer (in Tagen) bevor der Teilnehmer automatisch aus dem Kurs ausgeschrieben wird. Wenn 0 eingestellt ist, wird der Teilnehmer nie ausgeschrieben.';
$string['label:enter_coupon_code'] = 'Geben Sie hier Ihren Gutschein-Kode ein';
$string['label:generate_pdfs'] = 'Erstelle getrennte PDF-Dateien';
$string['label:generate_pdfs_help'] = 'Hier kann eingegeben werden, ob alle Gutscheine in einer einzigen PDF-Datei, oder ob jeder Gutschein in eine getrennte PDF-Datei gedruckt wird.';
$string['label:image'] = 'Hintergrund für Gutscheine';
$string['label:image_desc'] = 'Der Hintergrund der erstellten Gutscheine';
$string['label:info_coupon_cohort_courses'] = 'Info auf der Seite: Kurse der globalen Gruppe';
$string['label:info_coupon_cohorts'] = 'Info auf der Seite: Wähle globale Gruppen';
$string['label:info_coupon_confirm'] = 'Info auf der Seite: Bestätige Gutschein';
$string['label:info_coupon_course'] = 'Info auf der Seite: Wähle Kurs';
$string['label:info_coupon_course_groups'] = 'Info auf der Seite: Wähle Gruppen für den Kurs';
$string['label:info_coupon_type'] = 'Info auf der Seite: Wähle Art Gutschein';
$string['label:info_desc'] = 'Informationen, die über dem Formular erscheinen.';
$string['label:info_imageupload'] = 'Info auf der Seite: Bild hochladen';
$string['label:max_coupons'] = 'Höchste Anzahl Gutscheine';
$string['label:max_coupons_desc'] = 'Höchste Anzahl Gutscheine, die in einem Arbeitsgang angelegt werden können.';
$string['label:no_courses_connected'] = 'Zu dieser globalen Gruppe wurden keine Kurse zugeordnet.';
$string['label:no_groups_selected'] = 'Zu diesen Kursen wurden keine Gruppen zugeordnet.';
$string['label:redirect_url'] = 'Weiterleiten an';
$string['label:redirect_url_help'] = 'Die Adresse, an die die Teilnehmer weitergeleitet werden, nachdem sie ihren Gutschein eingelöst haben.';
$string['label:selected_cohort'] = 'Gewählte globale Gruppe(n)';
$string['label:selected_courses'] = 'Gewählte Kurse';
$string['label:selected_groups'] = 'Gewählte Gruppe(n)';
$string['label:showform'] = 'Einstellungen';
$string['label:type_cohorts'] = 'Globale Gruppe(n)';
$string['label:type_course'] = 'Kurse';
$string['label:use_alternative_email'] = 'Andere Mailadresse verwenden';
$string['label:use_alternative_email_help'] = 'Wenn diese Option ausgewählt ist, werden Gutscheine an diese Adresse geschickt.';
$string['missing_config_info'] = 'Geben Sie hier ggf. zusätzliche Informationen ein - sie erscheinen in den globalen Einstellungen des Blocks.';
$string['page:generate_coupon.php:title'] = 'Gutscheine erstellen';
$string['page:generate_coupon_step_five.php:title'] = 'Gutscheine erstellen';
$string['page:generate_coupon_step_four.php:title'] = 'Gutscheine erstellen';
$string['page:generate_coupon_step_three.php:title'] = 'Gutscheine erstellen';
$string['page:generate_coupon_step_two.php:title'] = 'Gutscheine erstellen';
$string['page:unused_coupons.php:title'] = 'Nicht eingelöste Gutscheine';
$string['pdf_generated'] = 'Die Gutscheine finden Sie als PDF-Dateien im Anhang.<br /><br />';
$string['pdf-meta:keywords'] = 'Moodle Gutschein';
$string['pdf-meta:subject'] = 'Moodle Gutschein';
$string['pdf-meta:title'] = 'Moodle Gutschein';
$string['pdf:titlename'] = 'Moodle Gutschein';
$string['pluginname'] = 'Gutschein';
$string['promo'] = 'Gutschein Plugin für Moodle';
$string['promodesc'] = 'Dieses Plugin wurde von Sebsoft Managed Hosting & Software Development entwickelt
(<a href=\'http://www.sebsoft.nl/\' target=\'_new\'>http://sebsoft.nl</a>).<br /><br />
{$a}<br /><br />';
$string['report:cohorts'] = 'Globale Gruppe';
$string['report:coupon_code'] = 'Gutschein-Kode';
$string['report:dateformat'] = '%d.%m.%Y %H:%M:%S';
$string['report:dateformatymd'] = '%d.%m.%Y';
$string['report:download-excel'] = 'Nicht eingelöste Gutscheine herunterladen';
$string['report:enrolperiod'] = 'Dauer der Einschreibung';
$string['report:for_user_email'] = 'Geplant für';
$string['report:heading:action'] = 'Vorgehen';
$string['report:heading:coupon'] = 'Gutschein';
$string['report:heading:coursename'] = 'Name des Kurses';
$string['report:heading:coursetype'] = 'Kurstyp';
$string['report:heading:datecomplete'] = 'Abschlussdatum';
$string['report:heading:datestart'] = 'Anfangsdatum';
$string['report:heading:errormessage'] = 'Fehler';
$string['report:heading:errortype'] = 'Typ';
$string['report:heading:grade'] = 'Note';
$string['report:heading:status'] = 'Status';
$string['report:heading:timecreated'] = 'Datum';
$string['report:heading:user'] = 'Nutzer(in)';
$string['report:immediately'] = 'Sofort';
$string['report:issend'] = 'Ist versendet';
$string['report:owner'] = 'Eigner';
$string['report:senddate'] = 'Versanddatum';
$string['report:status_completed'] = 'Kurs abgeschlossen';
$string['report:status_not_started'] = 'Kurs noch nicht angefangen';
$string['report:status_started'] = 'Kurs in Bearbeitung';
$string['showform-amount'] = 'Ich möchte eine beliebige Anzahl Gutscheine erstellen';
$string['showform-csv'] = 'Ich möchte Gutscheine erstellen für Adressaten in einer CSV-Liste';
$string['showform-manual'] = 'Ich möchte die Empfänger manuell konfigurieren';
$string['str:mandatory'] = 'Plicht';
$string['str:optional'] = 'Optional';
$string['success:coupon_used'] = 'Der Gutschein ist eingelöst - Sie haben jetzt Zugriff auf den Kurs / die Kurse';
$string['success:uploadimage'] = 'Das neue Gutschein-Bild wurde hochgeladen.';
$string['tab:apidocs'] = 'API Dokumentation';
$string['tab:errors'] = 'Fehlerberichte';
$string['tab:report'] = 'Fortgangsberichte';
$string['tab:unused'] = 'Nicht eingelöste Gutscheine';
$string['tab:used'] = 'Nicht eingelöste Gutscheine';
$string['tab:wzcouponimage'] = 'Bildvorlage';
$string['tab:wzcoupons'] = 'Gutschein(e) erstellen';
$string['task:cleanup'] = 'Nicht eingelöste Gutscheine automatisch löschen';
$string['task:sendcoupons'] = 'Gutscheine geplant versenden';
$string['tasksettings'] = 'Einstellungen';
$string['textsettings'] = 'Text-Einstellungen';
$string['textsettings_desc'] = 'Hier können Texte erstellt werden, die im Assistenten des Gutschein-Generators verwendet werden.';
$string['th:action'] = 'Vorgehen';
$string['th:cohorts'] = 'Globale Gruppe';
$string['th:course'] = 'Kurse';
$string['th:enrolperiod'] = 'Einschreibedauer';
$string['th:for_user_email'] = 'Geplant für';
$string['th:groups'] = 'Gruppe(n)';
$string['th:immediately'] = 'Sofort';
$string['th:issend'] = 'Versendet?';
$string['th:owner'] = 'Eigner';
$string['th:senddate'] = 'Versanddatum';
$string['th:submission_code'] = 'Gutschein-Kode';
$string['unlimited_access'] = 'unbegrenzt';
$string['url:api_docs'] = 'API Dokumentation';
$string['url:generate_coupons'] = 'Gutschein erstellen';
$string['url:input_coupon'] = 'Gutschein einlösen';
$string['url:uploadimage'] = 'Gutschein-Bild ändern';
$string['url:view_reports'] = 'Berichte';
$string['url:view_unused_coupons'] = 'Nicht eingelöste Gutscheine';
$string['view:api_docs:heading'] = 'Dokumentation Gutschein API';
$string['view:api_docs:title'] = 'Dokumentation Gutschein API';
$string['view:api:heading'] = 'Gutschein API';
$string['view:api:title'] = 'Gutschein API';
$string['view:errorreport:heading'] = 'Bericht - Gutschein Fehler';
$string['view:errorreport:title'] = 'Bericht - Gutschein Fehler';
$string['view:generate_coupon:heading'] = 'Gutschein erstellen';
$string['view:generate_coupon:title'] = 'Gutschein erstellen';
$string['view:input_coupon:heading'] = 'Gutschein einlösen';
$string['view:input_coupon:title'] = 'Gutschein einlösen';
$string['view:reports:heading'] = 'Bericht - Fortschritt für Gutscheine';
$string['view:reports:title'] = 'Bericht - Fortschritt für Gutscheine';
$string['view:reports-unused:heading'] = 'Bericht - Nicht eingelöste Gutscheine';
$string['view:reports-unused:title'] = 'Bericht - Nicht eingelöste Gutscheine';
$string['view:reports-used:heading'] = 'Bericht - Eingelöste Gutscheine';
$string['view:reports-used:title'] = 'Bericht - Eingelöste Gutscheine';
$string['view:uploadimage:heading'] = 'Neuen Hintergrund für Gutscheine hochladen';
$string['view:uploadimage:title'] = 'Hintergrund für Gutscheine hochladen';
