<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'nl', branch 'MOODLE_36_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Bovenaan';
$string['activitynavigationposition'] = 'Activiteit navigatiepositie';
$string['activitynavigationpositiondesc'] = 'Kies tussen \'Boven\' en \'Onder\' voor de activiteitennavigatie. Waar \'Boven\' boven de activiteit staat en \'Onder\' eronder. Als u aangepaste CSS wilt gebruiken, gebruik dan de selector \'#activitynavigation\'.';
$string['advert_alttext'] = 'Thema Design Level 1 advertentiebanner';
$string['advert_heading'] = 'Thema Design Level 1';
$string['advert_tagline'] = 'Wil je weten hoe je thema\'s wilt aanpassen, maar je hebt geen achtergrond in ontwikkeling, ervaring met PHP en ervaring met Moodle Thema\'s, dan is \'MoodleBites Theme Design Level 1\' voor jou! Het  introduceert op een eenvoudige wijze Moodle Thema\'s ontwikkeling en zorgt voor een goede basis als je verder wilt ontwikkelen. Klik hier voor meer informatie.';
$string['aftercontent'] = 'Na inhoud';
$string['alert1'] = 'Eerste mededeling';
$string['alert2'] = 'Tweede mededeling';
$string['alert3'] = 'Derde mededeling';
$string['alert_edit'] = 'Bewerk mededelingen';
$string['alert_general'] = 'Aankondiging';
$string['alert_info'] = 'Informatie';
$string['alertinfodesc'] = 'Stel hier de instellingen voor je meldingen in.';
$string['alertsdesc'] = 'Deze optie maakt het mogelijk om drie notificaties op de voorpagina te tonen. Vergeet ze niet uit te zetten als ze niet meer nodig zijn!';
$string['alertsheading'] = 'Notificaties';
$string['alertsheadingsub'] = 'Toon belangrijke notificaties op de voorpagina.';
$string['alerttext'] = 'Notificatietekst';
$string['alerttextdesc'] = 'Voer hier de notificatietekst in.';
$string['alerttitle'] = 'Titel';
$string['alerttitledesc'] = 'Voer hier de titel van je notificatie in.';
$string['alerttype'] = 'Type';
$string['alerttypedesc'] = 'Stel hier het type notificatie in.';
$string['alert_warning'] = 'Waarschuwing';
$string['allclasses'] = 'Alle klassen';
$string['allcourses'] = 'Alle cursussen';
$string['allmodules'] = 'Alle modules';
$string['allunits'] = 'Alle lessen';
$string['alternativecolors'] = 'Alternatief kleurschema {$a}';
$string['alternativethemecolor'] = 'Alternatieve themakleur {$a}';
$string['alternativethemecolordesc'] = 'Welke kleur moet het thema in alternatief kleurschema {$a} zijn?';
$string['alternativethemecolorname'] = 'Naam van alternatief kleurschema {$a}';
$string['alternativethemecolornamedesc'] = 'Geef een herkenbare naam op voor dit alternatieve kleurschema.';
$string['alternativethemecolors'] = 'Alternatieve themakleur';
$string['alternativethemecolorsdesc'] = 'Definieer de alternatieve kleurschema\'s.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Achtergrond kleur standaard knop {$a}.';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Kies hier de achtergrondkleur voor alle standaard knoppen {$a}.';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'Achtergrond-hover-kleur standaardknop {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'Kies hier de achtergrond-hover-kleur voor alle standaardknoppen {$a}.';
$string['alternativethemedefaultbuttontextcolour'] = 'Tekstkleur standaardknop {$a}.';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Kies de tekstkleur voor alle standaardknoppen {$a}.';
$string['alternativethemedefaultbuttontexthovercolour'] = 'Standaardknop: hover-tekstkleur {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'Stel hier de hover-tekstkleur in voor alle standaardknoppen {$a}.';
$string['alternativethemefooterblockbackgroundcolour'] = 'De kleur van het footer-achtergrondblok in de alternatieve themakleur {$a}';
$string['alternativethemefooterblockbackgroundcolourdesc'] = 'Stel hier de achtergrondkleur van footer-blok in de alternatieve themakleur {$a}';
$string['alternativethemefooterblockhovercolour'] = 'De hover-link van het blok-footer in de alternatieve themakleur {$a}';
$string['alternativethemefooterblockhovercolourdesc'] = 'Stel hier de link hover-kleur in voor het blok in de footer in de alternatieve themakleur {$a}';
$string['alternativethemefooterblocktextcolour'] = 'Tekstkleur footer-blok voor de alternatieve themakleur {$a}';
$string['alternativethemefooterblocktextcolourdesc'] = 'Stel hier de bloktekstkleur in de footer voor de alternatieve themakleur {$a}';
$string['alternativethemefooterblockurlcolour'] = 'Link-kleur footer-blok voor de alternatieve themakleur {$a}';
$string['alternativethemefooterblockurlcolourdesc'] = 'Stel hier de link-kleur in voor je footer-blok voor de alternatieve themakleur {$a}.';
$string['alternativethemefootercolor'] = 'Footer achtergrondkleur voor de alternatieve themakleuren {$a}';
$string['alternativethemefootercolordesc'] = 'Stel hier de achtergrondkleur in voor de footer-box voor de alternatieve themakleuren {$a}';
$string['alternativethemefooterheadingcolor'] = 'Footer heading-kleur voor de alternatieve themakleuren {$a}';
$string['alternativethemefooterheadingcolordesc'] = 'Stel hier de achtergrondkleur in voor de headings in de footer voor de alternatieve themakleuren {$a}';
$string['alternativethemefooterhovercolor'] = 'Footer link hover-kleur voor de alternatieve themakleuren {$a}';
$string['alternativethemefooterhovercolordesc'] = 'Stel hier de kleur in voor de gelinkte tekst bij hovered over in de footer voor de alternatieve themakleuren {$a}';
$string['alternativethemefootersepcolor'] = 'Footer-separatorkleur voor de alternatieve themakleuren {$a}';
$string['alternativethemefootersepcolordesc'] = 'Scheidingslijnen worden gebruikt om inhoud te scheiden. Stel hier hun kleur in voor de alternatieve themakleuren {$a}';
$string['alternativethemefootertextcolor'] = 'Footer tekstkleur voor de alternatieve themakleuren {$a}';
$string['alternativethemefootertextcolordesc'] = 'Stel de kleur in voor de tekst in de footer voor de alternatieve themakleuren {$a}';
$string['alternativethemefooterurlcolor'] = 'Footer link-kleur voor de alternatieve themakleuren {$a}';
$string['alternativethemefooterurlcolordesc'] = 'Stel de kleur in voor de gelinkte tekst in de footer voor de alternatieve themakleuren {$a}';
$string['alternativethemehovercolor'] = 'Alternatieve thema hover-kleur {$a}';
$string['alternativethemehovercolordesc'] = 'Welke kleur moet er gebruikt worden voor hovers in alternatief kleurschema {$a}?';
$string['alternativethemeiconcolor'] = 'Alternatieve icoonkleur {$a}.';
$string['alternativethemeiconcolordesc'] = 'Kies hier de alternatieve {$a} kleur voor alle iconen.';
$string['alternativethememycoursesorderenrolbackcolour'] = 'Alternatieve achtergrondkleur voor {$a} ingeschreven en niet toegelaten cursussen';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = 'Stel alternative {$a} achtergrondkleur in voor ingeschreven maar niet toegelaten cursussen. Want "mycourseorder" is gewijzigd in "Laatst aangemeld..."';
$string['alternativethemename'] = 'Naam voor kleurschema {$a}';
$string['alternativethemenamedesc'] = 'Voer hier de naam van alternatief kleurschema {$a} in.';
$string['alternativethemenavcolor'] = 'Navigatietekstkleur {$a}.';
$string['alternativethemenavcolordesc'] = 'Kies hier de alternatieve {$a} tekstkleur voor de navigatie. Het betreft de navigatiebalk en het stijlvolle kruimelpad.';
$string['alternativethemequizsubmitbackgroundcolour'] = 'Test \'Alles indienen en beëindigen\' achtergrondkleur {$a}';
$string['alternativethemequizsubmitbackgroundcolourdesc'] = 'Stel de alternatieve {$a} achtergrondkleur in voor de test \'Alles indienen en beëindigen\'-knop.';
$string['alternativethemequizsubmitbackgroundhovercolour'] = 'Test \'Alles indienen en beëindigen\'-achtergrond-hover-kleur {$a}';
$string['alternativethemequizsubmitbackgroundhovercolourdesc'] = 'Stel de alternatieve {$a} achtergrond-hover-kleur in voor de test \'Alles indienen en beëindigen\'-knop.';
$string['alternativethemequizsubmittextcolour'] = 'Test \'Alles indienen en beëindigen\'-tekstkleur';
$string['alternativethemequizsubmittextcolourdesc'] = 'Stel de alternatieve {$a} tekstkleur in voor de test \'Alles indienen en beëindigen\'-knop.';
$string['alternativethemequizsubmittexthovercolour'] = 'Test \'Alles indienen en beëindigen\'-tekst-hover-kleur {$a}';
$string['alternativethemequizsubmittexthovercolourdesc'] = 'Stel de alternatieve {$a} tekst-hover-kleur in voor de test \'Alles indienen en beëindigen\'-knop.';
$string['alternativethemesidepreblockbackgroundcolour'] = 'Alternatieve {$a} \'side-pre\' blokachtergrondkleur';
$string['alternativethemesidepreblockbackgroundcolourdesc'] = 'Stel de alternatieve {$a} blokachtergrondkleur voor het \'side-pre\' blok in.';
$string['alternativethemesidepreblockhovercolour'] = 'Alternatieve {$a} \'side-pre\' blok-link-hover-kleur';
$string['alternativethemesidepreblockhovercolourdesc'] = 'Stel de alternatieve {$a} link-cover-kleur voor het \'side-pre\' blok in.';
$string['alternativethemesidepreblocktextcolour'] = 'Alternatieve {$a} \'side-pre\' blok-tekstkleur';
$string['alternativethemesidepreblocktextcolourdesc'] = 'Stel de alternatieve {$a} tekstkleur voor het \'side-pre\' blok in.';
$string['alternativethemesidepreblockurlcolour'] = 'Alternatieve {$a} \'side-pre\' bloklinkkleur';
$string['alternativethemesidepreblockurlcolourdesc'] = 'Stel de alternatieve {$a} lijkkleur voor het \'side-pre\' blok in.';
$string['alternativethemeslidebuttoncolor'] = 'Alternatieve thema-diaknopkleur';
$string['alternativethemeslidebuttoncolordesc'] = 'Welke kleur zou je thema slide-knop moeten zijn voor de alternatieve themakleuren {$a}.';
$string['alternativethemeslidebuttonhovercolor'] = 'Alternatieve thema slide knop hover-kleur {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'Welke hover-kleur zou je thema slide-knop moeten zijn voor de alternatieve themakleuren {$a}.';
$string['alternativethemeslidecaptionbackgroundcolor'] = 'Achtergrondkleur {$a} voor het dia-onderschrift van het alternatieve thema';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'Welke achtergrondkleur moet dia-onderschrift zijn voor de alternatieve themakleuren {$a} van uw thema. Niet van toepassing op \'naast\' dia-onderschriftoptie.';
$string['alternativethemeslidecaptiontextcolor'] = 'Alternatieve tekstkleur voor het thema van het dia-bijschrift {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'Welke kleur moet je thema-diabijschrifttekst zijn voor de alternatieve themakleuren {$a}. Dit geldt niet voor de \'bijzijde\' optie voor het bijschrift van de dia.';
$string['alternativethemeslidecolors'] = 'Alternatieve themakleuren voor de dia.';
$string['alternativethemeslidecolorsdesc'] = 'Definieert alternatieve thema-diakleuren die de gebruiker kan selecteren .';
$string['alternativethemestripebackgroundcolour'] = 'Alternatieve gestreepte achtergrondkleur {$a}';
$string['alternativethemestripebackgroundcolourdesc'] = 'Stel de alternatieve {$a} achtergrondkleur in voor lijnen in tabellen.';
$string['alternativethemestripetextcolour'] = 'Alternatieve kleur voor de gestreepte tekst {$a}';
$string['alternativethemestripetextcolourdesc'] = 'Stel de alternatieve {$a} tekstkleur in voor lijnen in tabellen';
$string['alternativethemestripeurlcolour'] = 'Alternatieve url-kleur voor lijnen';
$string['alternativethemestripeurlcolourdesc'] = 'Stel de alternatieve url-kleur {$a} in voor lijnen in tabellen.';
$string['alternativethemetextcolor'] = 'Alternatieve tekstkleuren {$a}';
$string['alternativethemetextcolordesc'] = 'Stel de kleur in voor je alternatieve tekst {$a}';
$string['alternativethemeurlcolor'] = 'Alternatieve link-kleur {$a}';
$string['alternativethemeurlcolordesc'] = 'Stel hier de kleur in voor je alternatieve link-tekst {$a}';
$string['alwaysdisplay'] = 'Altijd tonen';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Geef een URL aan voor uw mobiele app in de Google Play Store. Als u die niet zelf hebt, kunt u overwegen om een link naar de officiële Moodle Mobile app te gebruiken. (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['androidurl'] = 'Android-URL (Google Play)';
$string['asconfigintlower'] = '{$a->value} is minder dan de limiet van het laagste bereik van {$a->lower}';
$string['asconfigintnan'] = '{$a->value} is geen nummer';
$string['asconfigintupper'] = '{$a->value} is groter dan de limiet van het hoogste bereik van {$a->upper}';
$string['backtotop'] = 'Naar boven';
$string['badgepreferences'] = 'Badge';
$string['badgesmi'] = 'Badges';
$string['badgesmidesc'] = 'Geef het menu-item "badges" weer als de gebruiker de functie \'moodle / badges: manageownbadges\' heeft en badges zijn ingeschakeld op siteniveau.';
$string['beforecontent'] = 'Voor de inhoud';
$string['below'] = 'Onder';
$string['breadcrumbsimple'] = 'Simpel';
$string['breadcrumbstyle'] = 'Kruimelpad stijl';
$string['breadcrumbstyled'] = 'Stijlvol';
$string['breadcrumbstyledesc'] = 'Stel hier in hoe je het kruimelpad getoond wilt hebben.';
$string['breadcrumbstylednocollapse'] = 'Stijlvol zonder invouwen';
$string['breadcrumbthin'] = 'Dun';
$string['cachesused'] = 'In cache gebruikt';
$string['calendarmi'] = 'Kalender';
$string['calendarmidesc'] = 'Toon het kalendermenu-item als de gebruiker de \'moodle / calendar: manageownentries\'-mogelijkheid heeft';
$string['categoryctidesc'] = 'Als dit is ingeschakeld, kunt u de afbeeldingen voor elke categorie instellen.';
$string['categoryctiheading'] = 'Titelafbeeldingen voor de cursuscategorie';
$string['categoryctiheadingcategory'] = 'Titelafbeeldingen voor de cursuscategorie voor: {$a->category}';
$string['categoryctiheadingcs'] = 'Configuratie van titelafbeeldingen voor de cursuscategorie';
$string['categoryctiheadingsub'] = 'Gebruik afbeeldingen om uw categorieën in een cursus uit te beelden';
$string['categoryctiheight'] = 'Hoogte van de titelafbeelding van de cursuscategorie  \'{$a->category}\'';
$string['categoryctiheightdesc'] = 'Hoogte van de titelafbeelding van de cursuscategorie  \'{$a->category}\' tussen {$a->lower} en {$a->upper} pixels.  Voeg geen \'px\' toe, maar voeg enkel een nummer in.';
$string['categoryctiinfo'] = '{$a->category} instellingen';
$string['categoryctiinfodesc'] = 'Instellingen voor de afbeeldingen van de titel van de cursuscategorie: {$a->category}.';
$string['categoryctimage'] = 'Categorie \'{$a->category}\' afbeeldingsbestand van de cursustitel';
$string['categoryctimagedesc'] = 'Afbeeldingsbestand voor de cursustitel in categorie \'{$a->category}\'.';
$string['categoryctimageurl'] = 'Categorie \'{$a->category}\' afbeeldings-URL van de cursustitel';
$string['categoryctimageurldesc'] = 'Afbeeldings-URL voor de cursustitel in categorie \'{$a->category}\'.  Als het bestand is geüpload dan zal het dit overschrijven.';
$string['categoryctitextbackgroundcolour'] = 'Categorie \'{$a->category}\' achtergrondkleur van de titeltekst van de cursus';
$string['categoryctitextbackgroundcolourdesc'] = 'Achtergrondkleur van de tekst van de cursustitel in categorie \'{$a->category}\'.';
$string['categoryctitextbackgroundopacity'] = 'Category \'{$a->category}\' course title text background opacity';
$string['categoryctitextbackgroundopacitydesc'] = 'Transparantie van de tekstachtergrond van de cursustitel in categorie \'{$a->category}\'.';
$string['categoryctitextcolour'] = 'Categorie \'{$a->category}\' tekstkleur van de cursustitel';
$string['categoryctitextcolourdesc'] = 'Tekstkleur van de cursustitel in categorie \'{$a->category}\'.';
$string['categoryiconcategory'] = 'Het icoon voor de categorie: {$a->category}.';
$string['categoryicondesc'] = 'Indien ingeschakeld kun je hier iconen voor iedere categorie instellen.';
$string['categoryiconheading'] = 'Categorie Iconen';
$string['categoryiconheadingsub'] = 'Gebruik iconen om jouw categorieën te vertegenwoordigen';
$string['categoryiconinfo'] = 'Aangepaste categorie iconen';
$string['categoryiconinfodesc'] = 'Stel hier per categorie een icoon in. De mogelijke opties vind je <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>, voer het gedeelte na "fa-" in.';
$string['categoryimagecategory'] = 'De afbeelding voor de categorie: {$a->category}.';
$string['categoryincoursebreadcrumbfeature'] = 'Categorieën in het cursus-kruimelpad';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Toon de categorie-links in het kruimelpad van de cursus.';
$string['ccd'] = 'Cursus creatiedatum';
$string['ced'] = 'Cursus einddatum';
$string['cfn'] = 'Cursus volledige naam';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" alt="Essential screen shot"/></p>
</div>
<div class="well">
<h3>Over Essential</h3>
<p>Essential is gebaseerd op het Bootstrap thema, dat was gecreëerd voor Moodle 2.5, met behulp van:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Thema Credits</h3>
<p>Oorspronkelijk Auteur: Julian Ridden<br>
Werk is overgenomen in juli 2014 door:<br>
Gareth J. Barnard<br>
David Bezemer<br>
Werk is overgenomen op 9 oktober 2014 door:<br>Gareth J. Barnard<br></p>
<h3>Sponsoren</h3>
<p>Dit thema is vrij te gebruiken en als je je erkentelijkheid wilt uiten voor het gebruik van dit thema, overweeg dan alsjeblieft een bijdrage via:
<h4>PayPal</h4>
<p>Neem contact met me op via mijn <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle profile\'</a> voor details, omdat ik geen bedrijf ben en daarom geen \'buy me now\' knoppen onder de voorwaarden heb.</p>
<br>Sponsoren helpen me het onderhoud te vergemakkelijken en helpen me je te voorzien met meer en betere voorzieningen. Zonder je ondersteuning kan dit thema niet worden onderhouden.</p>
<p>
<h3>Sponsoren</h3>
<p>Sponsoren die reeds hebben bijgedragen en vriendelijk worden bedankt zijn:</p>
<ul>
<li>Mihai Bojonca, TCM International Institute.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank">hlasek-it.de/moodle</a></li>
</ul>
</p>
<p>
<h3>Essential voor Moodle 3.3 vriendelijk gesponsord door:</h3>
<ul>
<li>ClassroomRevolution, LLC -- Moodle Partner</li>
<li>Daniel Méthot - e-learning-facile.com/formations/</li>
<li>Floyd Saner, Learning Contexts, LLC</li>
<li>Gemma Lesterhuis</li>
<li>Mihai Bojonca, TCM International Institute</li>
</ul>
</p>
<h3>Maatwerk</h3>
<p>Als dit thema je bevalt en je zou graag maatwerk willen, functionaliteit willen omzetten naar een ander thema, een nieuw thema vanaf de grond opbouwen of een kinderthema creëren, dan bied ik concurrerende  tarieven aan.  Neem contact met me op via \'http://moodle.org/user/profile.php?id=442195\' to discuss your requirements.</p>
</div></div>';
$string['cid'] = 'Cursus ID';
$string['colordesc'] = 'Hieronder staan de verschillende instellingen om veel van de gebruikte kleuren in dit thema aan te passen.';
$string['colorheading'] = 'Kleurinstellingen';
$string['colorheadingsub'] = 'Kies hier de kleuren die je in je thema wil gebruiken.';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Contactinformatie';
$string['contactinfodesc'] = 'Voer hier je contactinformatie in.';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'Naam van je organisatie om als copyright-houder te tonen.';
$string['coursecategorysettingstitle'] = 'Instellingen cursuscategorie';
$string['coursecontentsearch'] = 'Zoek cursusinhoud';
$string['coursecontentsearchdesc'] = 'Schakel zoeken in cursusinhoud in op de \'Dashboard\'-pagina.  Werkt alleen als Essential niet in \'\\$CFG->themedir\' is.';
$string['coursecontentsearchsortattribute'] = 'CursusInhoud sorteerattribuut';
$string['coursecontentsearchsortattributedesc'] = 'Sorteer de zoekresultaten op dit attribuut.';
$string['coursecontentsearchsortorder'] = 'CursusInhoud sorteervolgorde';
$string['coursecontentsearchsortorderdesc'] = 'Sorteer de zoekresultaten oplopend of aflopend.';
$string['coursegrades'] = 'Cursuscijfers';
$string['coursegradesmi'] = 'Cursuscijfers';
$string['coursegradesmidesc'] = 'Toon het menu-item "cursuscategorieën" als de gebruiker de mogelijkheid \'gradereport / user: view\' heeft en de instelling \'showgrades\' in een cursus is ingesteld.';
$string['courselistteachericon'] = 'Cursuslijst: docenten-icoon';
$string['courselistteachericondesc'] = 'Naam het het icon dat je wilt gebruiken of laat leeg als je er geen gebruikt. Lijst is <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">here</a>.  Voeg toe wat achter "fa-", e.g. "star" staat.';
$string['coursesettingstitle'] = 'Cursusinstellingen';
$string['coursetitleposition'] = 'Positie cursustitel';
$string['coursetitlepositiondesc'] = 'Kies tussen \'Boven\' en \'Binnen\' voor de cursus. Waar \'Boven\' boven de voorzijde, pagina\'s en cursusinhoudregio\'s ligt en \'Binnen\' ligt binnen de cursusinhoudregio zoals het was voordat deze instelling werd geïntroduceerd.';
$string['csd'] = 'Cursus startdatum';
$string['ctioverride'] = 'Overschrijven van categorie-afbeeldingen in een cursus';
$string['ctioverridedesc'] = 'Als u de titelafbeelding van de cursuscategorie wilt overschrijven in een cursus wanneer deze is ingeschakeld met de instelling \'enablecategorycti\', wijzigt u de cursussamenvatting in de cursusinstellingen en voegt u een afbeelding toe. Stel bewerken in HTML-modus in, verwijder de ingesloten \'p\' tags en \'br\' tag, verwijder vervolgens de attributen \'stijl\', \'breedte\' en \'hoogte\' en eventuele \'klassen\' die door de tekstverwerker zijn toegevoegd op de \'img\' -tag. Voeg dan de cursus \'categorycti\' toe. Om de hoogte (px) en de ingevoerde titeltekstkleur, achtergrondkleur en transparantie te specificeren, gebruik de volgende attributen: respectievelijk \'ctih\', \'ctit\', \'ctib\' en \'ctio\', bijvoorbeeld:<br/><br/><img src="https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg" alt="Replacement image" class="categorycti" ctih="250" ctit="#afafaf" ctib="#222222" ctio="0.5"><br/><br/>Deze afbeelding wordt niet weergegeven in de samenvatting zelf wanneer u de cursuslijst bekijkt.';
$string['ctioverrideheight'] = 'Standaard overschreven afbeeldingshoogte van de cursustitel';
$string['ctioverrideheightdesc'] = 'Standaard overschreven afbeeldingshoogte van de cursustitel tussen {$a->lower} en {$a->upper} pixels. Voeg geen postfix \'px\' toe, alleen het nummer.';
$string['ctioverridetextbackgroundcolour'] = 'Standaard overschreven tekstachtergrondkleur van de cursustitel';
$string['ctioverridetextbackgroundcolourdesc'] = 'Standaard overschreven tekstachtergrondkleur van de cursustitel';
$string['ctioverridetextbackgroundopacity'] = 'Standaard overschreven tekstachtergrondtransparantie van de cursustitel';
$string['ctioverridetextbackgroundopacitydesc'] = 'Standaard overschreven tekstachtergrondtransparantie van de cursustitel';
$string['ctioverridetextcolour'] = 'Standaard overschreven tekstkleur van de cursustitel';
$string['ctioverridetextcolourdesc'] = 'Standaard overschreven tekstkleur van de cursustitel';
$string['customcss'] = 'Aanvullende CSS';
$string['customcssdesc'] = 'Als er aanvullende CSS vereist is kan dit in het onderstaande tekstvak worden ingevoerd, en zal automatisch op iedere pagina ingevoegd worden.';
$string['customscrollbars'] = 'Standaard scrollbars';
$string['customscrollbarsdesc'] = 'Gebruik standaard scrollbars. Dit vervangt de standaard browser-scrollbars';
$string['dbqueries'] = 'DB Lezen/Schrijven';
$string['dbtime'] = 'DB-vragen tijdsduur';
$string['defaultcategoryicon'] = 'Standaard categorie-icoon';
$string['defaultcategoryicondesc'] = 'Stel hier een standaard categorie-icoon in.';
$string['defaultcategoryimage'] = 'Standaard categorie-afbeelding';
$string['defaultcategoryimagedesc'] = 'Stel een standaard categorie-afbeelding in. Zal het pictogram overschrijven wanneer het wordt ingevuld.';
$string['defaultcolors'] = 'Standaardkleuren';
$string['displayafterlogin'] = 'Alleen na inloggen tonen';
$string['displaybeforelogin'] = 'Alleen voor inloggen tonen';
$string['displayeditingmenu'] = 'Toon bewerkknop';
$string['displayeditingmenudesc'] = 'Toont een knop met dezelfde functionaliteit als de standaard paginabewerkingsknop in de header';
$string['displayhiddenmycourses'] = 'Toon verborgen cursussen';
$string['displayhiddenmycoursesdesc'] = 'Toon verborgen cursussen voor gebruikers in het "Cursussenmenu" als ze bevoegd zijn om verborgen cursussen te zien';
$string['displaymycourses'] = 'Toon ingeschreven cursussen';
$string['displaymycoursesdesc'] = 'Toon ingeschreven cursussen in het aangepaste menu.';
$string['docking'] = 'Schakel koppelen in.';
$string['dockingdesc'] = 'Indien ingeschakeld dan is koppelen beschikbaar.';
$string['dontdisplay'] = 'Nooit tonen';
$string['dropdownmenumaxheight'] = 'Dropdown-menu maximum hoogte';
$string['dropdownmenumaxheightdesc'] = 'Dropdown-menu maximum hoogte als de scrollbars geactiveerd zijn. Tussen {$a->lower} en {$a->upper} pixels.';
$string['dropdownmenuscroll'] = 'Scrollbars in het dropdown-menu';
$string['dropdownmenuscrolldesc'] = 'Heb een scrollbar in het dropdown-menu waar de hoogte van het menu beperkt is.';
$string['editingmenu'] = 'Paginabewerkingsschakelaar';
$string['editingmenudesc'] = 'Toont een knop om de bewerking van de huidige pagina aan/uit te schakelen als de gebruiker de pagina mag bewerken. Dezelfde functionaliteit als de normale paginabewerkingsknop.';
$string['enablealert'] = 'Notificatie  inschakelen';
$string['enablealertdesc'] = 'Kies hier of je notificaties wil inschakelen.';
$string['enablealternativethemecolors'] = 'Schakel alternatief kleurschema {$a} in';
$string['enablealternativethemecolorsdesc'] = 'Indien ingeschakeld krijgen gebruikers de keuze om alternatief kleurschema {$a}te kiezen.';
$string['enablecategorycti'] = 'Categorie cursustitelafbeeldingen inschakelen';
$string['enablecategoryctics'] = 'Categorie cursustitelafbeeldingen categorie instellingspagina\'s instellen';
$string['enablecategorycticsdesc'] = 'Indien ingeschakeld krijgt elke categorie op het hoogste niveau een eigen instellingenpagina.';
$string['enablecategoryctidesc'] = 'Indien ingeschakeld, kunt u de categoriecursus-titelafbeeldingen selecteren door op "Wijzigingen opslaan" te klikken.';
$string['enablecategoryicon'] = 'Sta categorie-iconen / afbeeldingen toe';
$string['enablecategoryicondesc'] = 'Als u bevoegd bent, kunt u categorie-iconen / afbeeldingen selecteren nadat u op "Wijzigingen opslaan" hebt geklikt.';
$string['enablecustomcategoryicon'] = 'Schakel aangepaste categoriepictogrammen / afbeeldingen in';
$string['enablecustomcategoryicondesc'] = 'Als deze optie onder deze sectie wordt geactiveerd, ziet u elke categorie met een aanpasbare optie achter elke categorie. Bewaar deze optie nadat deze optie is ingeschakeld en uitgeschakeld.';
$string['extperfinfoheading'] = 'Uitgebreide prestatie-informatie';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Link naar je Facebook pagina. (bvb. https://www.facebook.com/mijnorganisatie)';
$string['facebookurl'] = 'Facebook-URL';
$string['favicon'] = 'Aangepast icoon';
$string['favicondesc'] = 'Upload je eigen favicon. Het moet een bestand zijn met de extensie .ico';
$string['featuredesc'] = 'Hier vind je verschillende instellingen om veel van de functies in dit thema te wijzigen.';
$string['featureheading'] = 'Kenmerken';
$string['featureheadingsub'] = 'Stel de functies in die in uw thema zijn gebruikt';
$string['findcoursecontent'] = 'Cursusinhoud:';
$string['fitvids'] = 'Gebruik FitVids';
$string['fitvidsdesc'] = 'ActiveVids (fitvidsjs.com) inschakelen om uw ingebedde video\'s responsief te maken. Als FitVids aan staat en u wilt dat een video wordt uitgesloten, voeg dan \'class = "fitvidsignore\' \'toe aan de \'iframe\' tag in de HTML-modus van de editor. Bijvoorbeeld: \'iframe class = "fitvidsignore" width="420"height="315"src="//www.youtube.com/embed/enmEmym85xc" frameborder = "0" allowfullscreen = ""> </ iframe\'.';
$string['fixedwidthnarrow'] = 'Vaste breedte - Smal';
$string['fixedwidthnormal'] = 'Vaste breedte - Normaal';
$string['fixedwidthwide'] = 'Vaste breedte - breed';
$string['flatnavigation'] = 'Schakel de platte navigatie in';
$string['flatnavigationdesc'] = 'Indien ingeschakeld, wordt de platte navigatie gebruikt in plaats van de navigatie- en instellingenblokken.';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = 'Link naar je Flickr pagina. (bvb. https://www.flickr.com/photos/mijnorganisatie)';
$string['flickrurl'] = 'Flickr-URL';
$string['floatingsubmitbuttons'] = 'Drijvende indienen-knoppen';
$string['floatingsubmitbuttonsdesc'] = 'Heb een \'zwevend\' gebied dat de knoppen bevat bij het indienen van een formulier op bureaubladapparaten. Dit helpt om scrolling op sommige pagina\'s te verminderen. Niet gebruikt bij cursusinschrijving of forum posts.';
$string['fontcharacterset'] = 'Google-lettertype extra tekenset';
$string['fontcharactersetcyrillic'] = 'Cyrillisch';
$string['fontcharactersetcyrillicext'] = 'Cyrillisch Uitgebreid';
$string['fontcharactersetdesc'] = 'Kies extra tekensets voor verschillende talen. Veel tekensets gebruiken kan uw Moodle vertragen, dus selecteer alleen de tekensets die u eigenlijk nodig hebt.';
$string['fontcharactersetgreek'] = 'Grieks';
$string['fontcharactersetgreekext'] = 'Grieks uitgebreid';
$string['fontcharactersetlatinext'] = 'Latijn';
$string['fontcharactersetvietnamese'] = 'Vietnamees';
$string['fontfileeotbody'] = 'Body EOT lettertypebestand';
$string['fontfileeotheading'] = 'Heading EOT lettertypebestand';
$string['fontfileotfbody'] = 'Body OTF lettertypebestand';
$string['fontfileotfheading'] = 'Heading OTF lettertypebestand';
$string['fontfiles'] = 'Lettertypebestanden';
$string['fontfilesdesc'] = 'Upload hier je lettertypebestanden';
$string['fontfilesvgbody'] = 'Body SVG lettertypebestand';
$string['fontfilesvgheading'] = 'Heading SVG lettertypebestand';
$string['fontfilettfbody'] = 'Body TTF lettertypebestand';
$string['fontfilettfheading'] = 'Heading TTF lettertypebestand';
$string['fontfilewoffbody'] = 'Body WOFF lettertypebestand';
$string['fontfilewoffheading'] = 'Heading WOFF lettertypebestand';
$string['fontfilewofftwobody'] = 'Body WOFF2 lettertypebestand';
$string['fontfilewofftwoheading'] = 'Heading WOFF2 lettertypebestand';
$string['fontheadingdesc'] = 'Selecteer en vul de lettertypen in die u in uw Moodle-omgeving wilt gebruiken.';
$string['fontheadingsub'] = 'Lettertype-instellingen';
$string['fontnamebody'] = 'Tekstlettertype';
$string['fontnamebodydesc'] = 'Voer de exacte naam in van het lettertype dat u wilt gebruiken voor alle andere tekst.';
$string['fontnameheading'] = 'Heading lettertype';
$string['fontnameheadingdesc'] = 'Voer de exacte naam in van het lettertype dat u wilt gebruiken voor readings.';
$string['fontselect'] = 'Lettertypekiezer';
$string['fontselectdesc'] = 'Kies hier uit de lijst met beschikbare lettertypes.';
$string['fontsettings'] = 'Lettertype';
$string['fonttypecustom'] = 'Aangepaste lettertypes';
$string['fonttypegoogle'] = 'Google web-lettertypes';
$string['fonttypeuser'] = 'Gebruiker-lettertypes';
$string['footerblockbackgroundcolour'] = 'Voettekst-blok-achtergrondkleur';
$string['footerblockbackgroundcolourdesc'] = 'Stel de kleur in voor de blokachtergrond in de voettekst.';
$string['footerblockhovercolour'] = 'Voettekst-bloklink-hover-kleur';
$string['footerblockhovercolourdesc'] = 'Stel de kleur in voor uw gekoppelde bloktekst als u in de voettekst hovered.';
$string['footerblocktextcolour'] = 'Voettekst bloktekstkleur';
$string['footerblocktextcolourdesc'] = 'Stel de kleur in van uw bloktekst die u in de voettekst wilt.';
$string['footerblockurlcolour'] = 'Linkkleur voettekstblok';
$string['footerblockurlcolourdesc'] = 'Stel de kleur voor uw gekoppelde bloktekst in de voettekst in.';
$string['footercolor'] = 'Voetnoot achtergrondkleur';
$string['footercolordesc'] = 'Stel hier de kleur in voor de achtergrond van de voetnoot-regio.';
$string['footercolors'] = 'Voetnoot kleuren';
$string['footercolorsdesc'] = 'Verander de kleuren van de voetnoot';
$string['footerheading'] = 'Voettekst';
$string['footerheadingcolor'] = 'Voetnoot titelkleur';
$string['footerheadingcolordesc'] = 'Stel hier de kleur in van de titel van de voetnoot.';
$string['footerhovercolor'] = 'Voetnoot link-hover-kleur';
$string['footerhovercolordesc'] = 'Stel hier de kleur in voor de links in de voetnoot als je er met de muis op zweeft.';
$string['footersepcolor'] = 'Voetnoot scheidingskleur';
$string['footersepcolordesc'] = 'Hier kun je de kleur van de scheidingslijnen instellen.';
$string['footertextcolor'] = 'Voetnoot tekstkleur';
$string['footertextcolordesc'] = 'Stel hier de kleur in van de tekst in de voetnoot.';
$string['footerurlcolor'] = 'Voetnoot link-kleur';
$string['footerurlcolordesc'] = 'Stel hier de kleur van de links in de voetnoot in.';
$string['footnote'] = 'Voetnoot';
$string['footnotedesc'] = 'Tekst welke in dit veld wordt ingevoegd zal op iedere pagina in de voetnoot worden weergegeven.';
$string['forumdiscussionsmi'] = 'Discussies';
$string['forumdiscussionsmidesc'] = 'Toon het menu-item "discussies" (forum) als de gebruiker beschikt over de mogelijkheid \'mod / forum: viewdiscussion\'';
$string['forumpostsmi'] = 'Forumberichten';
$string['forumpostsmidesc'] = 'Toon het menu-item "forumberichten" als de gebruiker beschikt over de mogelijkheid \'mod / forum: viewdiscussion\'.';
$string['fppagetopblocks'] = 'Schakel \'Pagina bovenaan\'-blokken in op de voorpagina';
$string['fppagetopblocksdesc'] = 'Indien ingeschakeld, geeft dit een extra bloklocatie weer naast de zijblokken en boven het inhoudsgebied. Opmerking: het aantal blokken per rij hangt af van de instelling \'fppagetopblocksperrow\'.';
$string['fppagetopblocksperrow'] = 'Paginatop-blokken per rij';
$string['fppagetopblocksperrowdesc'] = 'Geef aan tot hoeveel blokken per rij tussen {$a->lower} en {$a->upper} voor het \'Pagina top\'-blokgebied op de voorpagina.';
$string['frontcontent'] = 'Schakel het inhoudsgebied van de voorpagina in';
$string['frontcontentarea'] = 'Voorpagina content';
$string['frontcontentareadesc'] = 'De inhoud van dit blik wordt over de gehele breedte van de pagina tussen de slidehsow en marketing blokken weergegeven.';
$string['frontcontentdesc'] = 'Dit voegt een speciaal blok in tussen de slideshow en de marketing blokken waar je eigen content kan plaatsen.';
$string['frontcontentheading'] = 'Voorpagina-instellingen';
$string['frontpageblocks'] = 'Uitlijning van voorpagina blokken';
$string['frontpageblocksdesc'] = 'Hier kunt u bepalen of de standaard Moodle-blokken op de voorpagina voor of na de inhoud uitlijnen.';
$string['frontpageblocksheading'] = 'Voorpagina-blokken';
$string['frontpageheading'] = 'Voorpagina';
$string['frontpageheadingdesc'] = 'Hier configureren welke extra items u op de voorpagina wilt weergeven.';
$string['frontpagehomeblocksperrow'] = 'Home (was "Middle") blokken per rij';
$string['frontpagehomeblocksperrowdesc'] = 'Geef aan tot hoeveel blokken per rij tussen {$a->lower} en {$a->upper} voor het blokregio \'Home blocks\'. Opmerking: Voor het gemak bij het bewerken, worden twee blokken per rij getoond, ongeacht deze instelling.';
$string['frontpagemiddleblocks'] = 'Voorpagina middenblokken inschakelen';
$string['frontpagemiddleblocksdesc'] = 'Indien ingeschakeld worden er drie blokken weergegeven onder de marketing blokken.';
$string['frontpagesettingstitle'] = 'Voorpagina-instellingen';
$string['fullname'] = 'Volledige site-naam';
$string['fullnamesummary'] = 'Volledige naam en samenvatting';
$string['generalheadingdesc'] = 'Configureer hier de algemene instellingen voor het thema.';
$string['generalheadingsub'] = 'Algemene instellingen';
$string['genericsettings'] = 'Algemeen';
$string['googleplus'] = 'Google+ URL';
$string['googleplusdesc'] = 'Link naar je Google+ profiel. (bvb. https://plus.google.com/+mijnorganisatie)';
$string['googleplusurl'] = 'Google+ URL';
$string['gotobottom'] = 'Ga naar de onderzijde van de pagina';
$string['gotopeople'] = 'Ga naar mensen';
$string['haveheaderblock'] = 'Kopblokgebied';
$string['haveheaderblockdesc'] = 'Een kopblokregio net onder het broodkruimelpad plaatsen.';
$string['headerbackground'] = 'Kop achtergrondafbeelding';
$string['headerbackgrounddesc'] = 'Upload hier je eigen achtergrondafbeelding';
$string['headerbackgroundstyle'] = 'Kop achtergrondstijl';
$string['headerbackgroundstyledesc'] = 'Selecteer de stijl voor de koptekstachtergrond.';
$string['headerblocksperrow'] = 'kopblokken per rij';
$string['headerblocksperrowdesc'] = 'Vermeld tot hoeveel blokken per rij tussen {$a->lower} en {$a->upper} voor pagina\'s met kopblokgebied.';
$string['headerheading'] = 'Kop';
$string['headertextcolor'] = 'Kop tekstkleur';
$string['headertextcolordesc'] = 'Kies hier de tekst kleur voor de kop.';
$string['headertitle'] = 'Koptitel';
$string['headertitledesc'] = 'Configureer hier de titel die getoond moet worden in de kop. Noot: De koptitel wordt alleen gebruikt als er geen logo is.';
$string['helplink'] = 'Helplink';
$string['helplinkdesc'] = 'Als je hierboven "URL" heeft gekozen, vul dan de volledige URL naar uw help-site in (moet http:// of https:// bevatten). Als je "e-mailadres" hebt gekozen, vul dan je e-mailadres in.';
$string['helplinktype'] = 'Zet help-link in het menu aan';
$string['helplinktypedesc'] = 'Kies hier of je een helpmogelijkheid wilt tonen in het gebruikersmenu. Je kunt kiezen uit een link die geopend wordt in een nieuw scherm of een e-mailadres.';
$string['hidedefaulteditingbutton'] = 'Verberg de knop voor het bewerken van de standaardpagina';
$string['hidedefaulteditingbuttondesc'] = 'Verbergt de standaard paginabewerkingsknop voor elke pagina. Deze instelling is alleen van kracht als de knop "Bewerkingsknop tonen" is ingeschakeld.';
$string['hideonphone'] = 'Verberg slideshow op telefoons';
$string['hideonphonedesc'] = 'Kies hier of je de slideshow wil uitschakelen op telefoons.';
$string['hideontablet'] = 'Verberg slide shows op tablets';
$string['hideontabletdesc'] = 'Kies hier als je de slide show niet op tablets wil laten tonen';
$string['hvpcustomcss'] = 'H5P Custom Css';
$string['hvpcustomcssdesc'] = 'Custom CSS veld toont wanneer de H5P module geïnstalleerd is.((moodle.org/plugins/mod_hvp).';
$string['icon'] = 'icoon';
$string['image'] = 'afbeelding';
$string['included'] = 'Inclusief bestanden';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Link naar je Instagram feed. (bvb. http://instagram.com/mijnorganisatie)';
$string['instagramurl'] = 'Instagram-URL';
$string['ios'] = 'iPhone/iPad (Apple App Store)';
$string['iosdesc'] = 'Geef een URL op naar uw mobiele app in de App Store. Als u niet over een eigen versie beschikt, kunt u overwegen om een koppeling te maken naar de officiële Moodle Mobile-app (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'iOS thuisscherm-iconen';
$string['iosicondesc'] = 'In dit thema zijn iconen in te stellen die getoond worden op het iOS thuisscherm als je een bladwijzer maakt voor de Moodle-omgeving.';
$string['iosurl'] = 'iPhone/iPad-(App Store)-URL';
$string['ipadicon'] = 'iPad icoon (Zonder Retina)';
$string['ipadicondesc'] = 'Dit icoon moet een 72px x 72px PNG icoon zijn.';
$string['ipadretinaicon'] = 'iPad icoon (Retina)';
$string['ipadretinaicondesc'] = 'Dit icoon moet een 144px x 144px PNG icoon zijn.';
$string['iphoneicon'] = 'iPhone/iPod Touch icoon (Zonder Retina)';
$string['iphoneicondesc'] = 'Dit icoon moet een 57px x 57px PNG zijn.';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch icoon (Retina)';
$string['iphoneretinaicondesc'] = 'Dit icoon moet een 114px x 114px PNG zijn.';
$string['layout'] = 'Gebruik standaard cursus layout';
$string['layoutdesc'] = 'Dit thema is ontworpen om beide blokkolommen aan de zijkant te plaatsen. Als u de standaard Moodle-cursusindeling verkiest, kunt u dit vakje aanvinken en terugkeren naar de oude indeling met drie kolommen.';
$string['left'] = 'Links';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'Link naar je LinkedIn-profiel. (b.v. https://www.linkedin.com/company/mijnorganisatie)';
$string['linkedinurl'] = 'LinkedIn-URL';
$string['loadtime'] = 'Laadtijd';
$string['loggedinas'] = 'Inloggen als';
$string['loggedinfrom'] = 'Ingelogd vanaf';
$string['loggedinfrommi'] = 'Ingelogd vanuit';
$string['loggedinfrommidesc'] = 'Toon het item "ingelogd van het menu" als de gebruiker een MNET externe gebruiker is.';
$string['loginbackground'] = 'Login-achtergrondafbeelding';
$string['loginbackgrounddesc'] = 'Upload je eigen achtergrondafbeelding voor het inlogscherm. Selecteer de stijl van de afbeelding hieronder.';
$string['loginbackgroundopacity'] = 'De opaciteit van het zoekvak als er een achtergrondafbeelding is';
$string['loginbackgroundopacitydesc'] = 'De achtergronddekking voor het inlogvak als er een achtergrondafbeelding is.';
$string['loginbackgroundstyle'] = 'Login-achtergrondstijl';
$string['loginbackgroundstyledesc'] = 'Selecteer de stijl voor de geüploade afbeelding.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Upload hier je aangepaste logo als je dit aan de kop wil toevoegen.<br>De afbeelding wordt geschaald om in de beschikbare percentagebreedte te passen die is opgegeven voor het onderstaande apparaat. Dit geeft een responsieve oplossing. Als je veel sociale / app-pictogrammen hebt, controleer dan extra het resultaat.<br>Als je een logo uploadt, vervangt dit het standaardpictogram en de standaardnaam die standaard werd weergegeven.';
$string['logodesktopwidth'] = 'Logo-bureaublad-breedte';
$string['logodesktopwidthdesc'] = 'De breedte van de logo-afbeeldingscontainer op een bureaublad,>= 980px.<br>Geef als percentage van de beschikbare ruimte tussen {$a->lower} en {$a->upper} aan.<br>De beschikbare ruimte is de breedte toegestaan door de instelling \'Pagewidth\'. De afbeelding vult het opgegeven percentage tot aan de breedte van de resolutie.<br>Opmerking: de minimale hoogte van de container is 64 pixels, dus er is een opening onderaan als de hoogte van het beeld minder wordt berekend.';
$string['logodimerror'] = 'is ongeldig. Geef \'px\' of \'em\' onmiddellijk na de waarde van de eenheid en niets vóór de waarde van de eenheid.';
$string['logomobilewidth'] = 'Logo mobielbreedte';
$string['logomobilewidthdesc'] = 'De breedte van de logobeeldcontainer op een mobiel, <980px.<Br>Geef als percentage van de beschikbare ruimte tussen {$a->lower} en {$a->upper} aan.<br>De beschikbare ruimte is de breedte toegestaan door de instelling \'Pagewidth\'. De afbeelding vult het opgegeven percentage tot aan de breedte van de resolutie.<br>Opmerking: de minimale hoogte van de container is 52 pixels, dus er is een opening onderaan als de hoogte van het beeld minder wordt berekend.';
$string['marketing1'] = 'Marketing blok 1';
$string['marketing2'] = 'Marketing blok 2';
$string['marketing3'] = 'Marketing blok 3';
$string['marketingbuttontext'] = 'Link-tekst';
$string['marketingbuttontextdesc'] = 'Tekst om te tonen op de link-button.';
$string['marketingbuttonurl'] = 'Link-URL';
$string['marketingbuttonurldesc'] = 'URL the button will point to.';
$string['marketingcontent'] = 'Inhoud';
$string['marketingcontentdesc'] = 'Stel hier de inhoud van het marketing blok in. Maak het kort maar krachtig.';
$string['marketingdesc'] = 'Dit thema bevat de optie om drie marketing blokken te tonen onder de slideshow. Dit geeft je de mogelijkheid om direct informatie te tonen aan gebruikers, ook zonder dat deze ingelogd zijn. Dit is handig voor als je specifieke cursussen wil uitlichten.';
$string['marketingheading'] = 'Marketingblokken';
$string['marketingheadingsub'] = 'De marketingblokken zijn drie blokken op de voorpagina waarin informatie en links getoond worden.';
$string['marketingheight'] = 'Hoogte van de marketingafbeeldingen';
$string['marketingheightdesc'] = 'Als je afbeeldingen wil tonen in de marketingblokken kun je hier de hoogte instellen.';
$string['marketingicon'] = 'Icoon';
$string['marketingicondesc'] = 'Naam van het iccon dat je wil gebruiken. Kies uit de lijst <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voor de naam in achter "fa-", bijvoorbeeld "star".';
$string['marketingimage'] = 'Afbeelding';
$string['marketingimagedesc'] = 'Stel hier een afbeelding in om boven de tekst in dit marketingblok te tonen.';
$string['marketingimageheight'] = 'Hoogte van de marketingafbeeldingen (px)';
$string['marketingimageheightdesc'] = 'Specificeer hier de hoogte in pixels van de afbeeldingen die je  wilt plaatsen in de marketingblokken';
$string['marketinginfodesc'] = 'Configureer hier de marketingblokken.';
$string['marketingtitle'] = 'Titel';
$string['marketingtitledesc'] = 'Marketing bloktitel.';
$string['marketingurltarget'] = 'Link-doel';
$string['marketingurltargetdesc'] = 'Voer hier in hoe de link geopend moet worden';
$string['marketingurltargetnew'] = 'Open in nieuwe pagina';
$string['marketingurltargetparent'] = 'Open in hoofdframe';
$string['marketingurltargetself'] = 'Open in huidige pagina';
$string['memused'] = 'Geheugengebruik';
$string['messagesmi'] = 'Berichten';
$string['messagesmidesc'] = 'Toon het menu-item "berichten" als berichten is ingeschakeld.';
$string['mobileappsdesc'] = 'Heb je een app in de App Store of Play Store? Voer hier de links in zodat je apps eenvoudig gevonden kunnen worden.';
$string['mobileappsheading'] = 'Mobiele applicaties';
$string['mobileappsheadingsub'] = 'Link naar je apps om te stimuleren dat gebruikers mobiele apparaten gebruiken.';
$string['modulesettingstitle'] = 'Module-instellingen';
$string['myclasses'] = 'Mijn klassen';
$string['mycourses'] = 'Mijn cursussen';
$string['mycoursescatsubmenu'] = 'Categorie- en cursus-submenu';
$string['mycoursescatsubmenudesc'] = 'Organiseer cursussen in een submenu op basis van de categorie op het hoogste niveau. Wanneer \'enablecategoryicon\' \'false\' is, is het gebruikte categoriepictogram het standaardthema, wanneer \'true\' dan is de waarde van \'defaultcategoryicon\' of de categorie zelf als \'enablecustomcategoryicon\' waar. De instelling \'mycoursesmax\' is nog steeds van toepassing, maar op een niveau per categorie.';
$string['mycoursesinfo'] = 'Automatische cursuslijst';
$string['mycoursesinfodesc'] = 'Toont een lijst met alle cursussen waarin een gebruiker ingeschreven is.';
$string['mycoursesmax'] = 'Max-cursussen';
$string['mycoursesmaxdesc'] = 'Geef aan hoeveel cursussen tussen {$a->lower} en {$a->upper} moeten worden weergegeven, waarbij \'{$a->lower}\' alles vertegenwoordigt.';
$string['mycoursesorder'] = 'Cursusvolgorde';
$string['mycoursesorderdesc'] = 'Geef aan hoe de cursussen moeten worden besteld. De sorteervolgorde van de koers kan worden ingesteld door de navigatie-instelling \'navsortmycoursessort\'.';
$string['mycoursesorderenrolbackcolour'] = 'Ingeschreven en niet toegankelijke achtergrondkleur van de cursus';
$string['mycoursesorderenrolbackcolourdesc'] = 'De achtergrondkleur voor ingeschreven maar niet bezochte cursussen. Voor wanneer \'mijn cursusvolgorde\' is ingesteld op \'Laatst bezocht ...\'.';
$string['mycoursesorderid'] = 'Cursus-ID';
$string['mycoursesorderidasc'] = 'Oplopend';
$string['mycoursesorderiddes'] = 'Aflopend';
$string['mycoursesorderidorder'] = 'Cursus-ID-volgorde';
$string['mycoursesorderidorderdesc'] = 'Cursus-ID-volgorde voor wanneer \'Cursus-ID\' is ingesteld als \'Cursus sorteervolgorde\'.';
$string['mycoursesorderlast'] = 'De laatst gebruikte tijd of starttijd van de inschrijving als deze nooit wordt gebruikt';
$string['mycoursesordersort'] = 'Cursus sorteervolgorde';
$string['mycoursetitle'] = 'Naamgeving';
$string['mycoursetitledesc'] = 'Verander de naamgeving voor het "Mijn cursussen" menu hieronder.';
$string['mygrades'] = 'Mijn cijfers';
$string['mygradesmi'] = 'Mijn punten';
$string['mygradesmidesc'] = 'Toon het menu-item "Mijn rangen" als de gebruiker beschikt over de mogelijkheid \'gradereport / overview: view\' in een cursus. Niet gecontroleerd op siteniveau.';
$string['mylatestclasses'] = 'Mijn laatste klassen';
$string['mylatestcourses'] = 'Mijn laatste cursussen';
$string['mylatestmodules'] = 'Mijn laatste modules';
$string['mylatestunits'] = 'Mijn laatste units';
$string['mymodules'] = 'Mijn modules';
$string['myunits'] = 'Mijn lessen';
$string['navbarabove'] = 'Navigatiestrook boven de kop';
$string['navbarbelow'] = 'Navigatiestrook onder de kop';
$string['navbartitle'] = 'Navigatiebalktitel';
$string['navbartitledesc'] = 'Configureer hier de titel die op de navigatiebalk getoond wordt.';
$string['nextsection'] = 'Volgende sectie';
$string['nobreadcrumb'] = 'Verbergen';
$string['noenrolments'] = 'Geen cursusinschrijving bekend';
$string['noslidetitle'] = 'Geen titel voor de dia {$a->slide}';
$string['notitle'] = 'Geen titel';
$string['numberofcoursesandsubcatcourses'] = 'Het aantal cursussen - sub categorie cursussen';
$string['numberofslides'] = 'Aantal dia\'s';
$string['numberofslides_desc'] = 'Aantal dia\'s op de slider';
$string['oldnavbar'] = 'Gebruik oude navigatiebalkpositie';
$string['oldnavbardesc'] = 'Indien ingeschakeld wordt de navigatiebalk op de oude positie getoond.';
$string['pagebackground'] = 'Pagina achtergrondafbeelding';
$string['pagebackgrounddesc'] = 'Upload hier je achtergrondafbeelding. Deze achtergrondafbeelding zal op alle pagina\'s getoond worden. Als je geen afbeelding upload wordt hier een vaste kleur voor gebruikt.';
$string['pagebackgroundstyle'] = 'Pagina achtergrondstijl';
$string['pagebackgroundstyledesc'] = 'Selecteer de stijl voor de geüploade afbeelding';
$string['pagebottomblocksperrow'] = 'Pagina-onderzijdeblokken per rij';
$string['pagebottomblocksperrowdesc'] = 'Vermeld tot hoeveel blokken per rij tussen {$a->lower} en {$a->upper} voor pagina\'s met \'Pagina-onderzijdeblokken\'. Huidige pagina\'s zijn: Beheer, Cursusbeheer, Beoordeling en Quiz-bewerking.';
$string['pagetopblocks'] = 'Schakel \'Pagina top\'-blokken in voor extra pagina\'s';
$string['pagetopblocksdesc'] = 'Indien ingeschakeld, geeft dit een extra bloklocatie weer naast de zijblokken en boven het inhoudsgebied op alle pagina\'s, behalve de \'Voorpagina\' die een eigen instelling heeft. Opmerking: het aantal blokken per rij hangt af van de instelling \'pagetopblocksperrow\'.';
$string['pagetopblocksperrow'] = 'Paginatop-blokken per rij';
$string['pagetopblocksperrowdesc'] = 'Vermeld tot hoeveel blokken per rij tussen {$a->lower} en {$a->upper} voor pagina\'s met \'Paginatop-blokken\'. Huidige pagina\'s zijn: Cursus, Cursuscategorie, Dashboard, Mijn publiek en Afdrukken.';
$string['pagewidth'] = 'Kies paginabreedte';
$string['pagewidthdesc'] = 'Kies uit de lijst met beschikbare breedtes om de site-breedte in te stellen.';
$string['participantsmenu'] = 'Menu deelnemers';
$string['participantsmenudesc'] = 'Toon het menu deelnemers op de cursus en module pagina\'s';
$string['paypal_click'] = 'Moodle-profiel';
$string['paypal_desc'] = '{$a->url} \'voor meer informatie omdat ik een persoon ben en daarom geen knoppen voor \'Nu kopen\' onder hun voorwaarden of';
$string['peakmem'] = 'Piekgeheugen';
$string['perfinfo'] = 'Performance informatie';
$string['perfinfodesc'] = 'Veel sites hebben geen volledig gedetailleerde prestatiegegevens nodig. Vooral wanneer bekeken door gebruikers. Indien ingeschakeld, toont dit een opgeruimd minimaal formulier met informatie over het laden van basispagina\'s.';
$string['perfinfoheading'] = 'Prestatiegegevens';
$string['perf_max'] = 'Gedetailleerd';
$string['perf_min'] = 'Minimaal';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'Link naar je Pinterest prikbord. (b.v. http://www.pinterest.com/mijnorganisatie/mijnprikbord)';
$string['pinteresturl'] = 'Pinterest-URL';
$string['pluginname'] = 'Essential';
$string['preferencesmi'] = 'Voorkeuren';
$string['preferencesmidesc'] = 'Toon het onderdeel voorkeurenmenu';
$string['previoussection'] = 'Vorige sectie';
$string['privacy:metadata:preference:courseitemsearchtype'] = 'De keuze van de gebruiker voor het zoeken naar een cursus (\'course fullname\' - \'0\' of alle cursusinhoud - \'1\') als deze ooit is opgeslagen wanneer \'coursecontentsearch\' was aangevinkt. Als niets wordt vermeld, is het zoeken naar de cursus uitgeschakeld of heeft de gebruiker het dashboard nooit bekeken toen het voor stond.';
$string['privacy:request:preference:courseitemsearchtype'] = 'De gebruiker heeft "{$a->value}" gekozen voor de gebruikersvoorkeur van de cursuszoekopdracht "{$a->naam}" waarbij \'0\' de \'course fullname only\' is en \'1\' is \'all course content\'.';
$string['privatefilesmi'] = 'Privé-bestanden';
$string['privatefilesmidesc'] = 'Toon het menu-item "persoonlijke bestanden" als de gebruiker de \'moodle / user: manageownfiles\'-mogelijkheid heeft.';
$string['profilebarcustomtitle'] = 'Aangepaste profielbalk-titel';
$string['profilebarcustomtitledesc'] = 'Voer hier indien gewenst een aangepaste titel in voor de profielbalk.';
$string['profilelinkmi'] = 'Profiellink';
$string['profilelinkmidesc'] = 'Toon het menu-onderdeel "profiellink"';
$string['properties'] = 'Eigenschappen';
$string['propertiesdesc'] = 'Lijst van eigenschappen.';
$string['propertiesexport'] = 'Exporteer eigenschappen als een JSON-string';
$string['propertiesproperty'] = 'Eigenschap';
$string['propertiesreturn'] = 'Terug';
$string['propertiessub'] = 'De eigenschappen';
$string['propertiesvalue'] = 'Waarde';
$string['putpropertiesadded'] = 'Toegevoegd:';
$string['putpropertieschanged'] = 'Gewijzigd:';
$string['putpropertiesdesc'] = 'Plak de JSON-string en \'Wijzigingen opslaan\'. Waarschuwing! Waardeert geen instellingswaarden en voert een \'Alle caches opschonen\' uit.';
$string['putpropertiesfrom'] = 'van';
$string['putpropertiesignorecti'] = 'Alle instellingen van de titel van de cursus negeren.';
$string['putpropertiesignored'] = 'Genegeerd:';
$string['putpropertiesname'] = 'Zet eigenschappen - Experimenteel!';
$string['putpropertiesreportfiles'] = 'Vergeet niet om de volgende bestanden naar hun instellingen te uploaden:';
$string['putpropertiessettingsreport'] = 'Instellingenrapport:';
$string['putpropertiesunchanged'] = 'Ongewijzigd:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Onze';
$string['putpropertyproperties'] = 'Eigenschappen';
$string['putpropertyreport'] = 'Rapport:';
$string['putpropertyversion'] = 'Versie:';
$string['readme_click'] = 'klik hier voor README.txt';
$string['readme_desc'] = 'Voor meer informatie over het Essential-thema: {$a->url}';
$string['readme_title'] = 'Essential lees-mij';
$string['readmore'] = 'Lees verder';
$string['region-footer-left'] = 'Voetnoot (links)';
$string['region-footer-middle'] = 'Voetnoot (midden)';
$string['region-footer-right'] = 'Voetnoot (rechts)';
$string['region-header'] = 'Kop';
$string['region-hidden-dock'] = 'Verborgen';
$string['region-home'] = 'Startpagina';
$string['region-page-top'] = 'Paginatop';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['returntosection'] = 'Keer terug naar: {$a->section}';
$string['returntosectionfeature'] = 'Terug naar de sectie';
$string['returntosectionfeaturedesc'] = 'Schakel terugkeer naar sectiefunctie in cursusmodules in.';
$string['returntosectiontextlimitfeature'] = 'Keer terug naar de tekstlimiet van de sectienaam';
$string['returntosectiontextlimitfeaturedesc'] = 'Lengtebegrenzing voor de \'naam\' van het gedeelte op de knop tussen {$a->lager} en {$a->boven} tekens.';
$string['right'] = 'Rechts';
$string['searchallcoursecontent'] = 'Zoek in alle cursusinhoud';
$string['searchallcoursecontentdefault'] = 'Zoek standaard in alle cursusinhoud';
$string['searchallcoursecontentdefaultdesc'] = 'Stelt de waarde in van het selectievakje "Alle cursusinhoud zoeken" bij het zoeken naar cursusinhoud. Als "Alle cursusinhoud doorzoeken" niet is geselecteerd, wordt alleen naar de volledige naam van de cursus gezocht voor een overeenkomst.';
$string['searchallcoursecontentenable'] = 'Zoeken inschakelen voor alle cursusinhoud';
$string['searchallcoursecontentenabledesc'] = 'Sta de gebruiker toe om te beslissen of deze alle cursusinhoud wil doorzoeken. Indien uitgeschakeld, wordt de waarde van \'searchallcoursecontentdefault\' toegepast voor het zoeken naar de cursus.';
$string['serverload'] = 'Servercapaciteit';
$string['sessionsize'] = 'Sessiegrootte';
$string['shortname'] = 'Site korte naam';
$string['shortnamesummary'] = 'Korte naam en samenvatting';
$string['siteicon'] = 'Site afbeelding';
$string['siteicondesc'] = 'Als je geen logo hebt kun je hier een icoon invullen om op de plaats van het logo te tonen. De volledige lijst staat op <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer het gedeelte achter "fa-" hier in.';
$string['skype'] = 'Skype-Account';
$string['skypedesc'] = 'Skype gebruikersnaam van je organisatie. (b.v. mijn.organisatie)';
$string['skypeuri'] = 'Skype-account-URL';
$string['slidebuttoncolor'] = 'Dia knopkleur';
$string['slidebuttoncolordesc'] = 'Kies hier de kleur voor de navigatie-knoppen.';
$string['slidebuttonhovercolor'] = 'Diaknop hover-kleur';
$string['slidebuttonhovercolordesc'] = 'Welke kleur de navigatieknop van de dia moet hebben.';
$string['slidecaption'] = 'Dia tekst';
$string['slidecaptionbackgroundcolor'] = 'Schuiven van de ondertitel-achtergrondkleur';
$string['slidecaptionbackgroundcolordesc'] = 'Welke kleur de achtergrond van de dia-ondertitel moet hebben. Is niet van toepassing op de  optie \'Naast\' dia-ondertitels';
$string['slidecaptionbelow'] = 'Dia-ondertitel onder de afbeelding';
$string['slidecaptionbelowdesc'] = 'Als de ondertitel van de dia onder de afbeelding moet staan.';
$string['slidecaptionbeside'] = 'Naast';
$string['slidecaptioncentred'] = 'Dia-ondertitel gecentreerd';
$string['slidecaptioncentreddesc'] = 'Als de dia-ondertitel gecentreerd moet zijn.';
$string['slidecaptiondesc'] = 'Voer hier de tekst in die op de dia getoond zal worden.';
$string['slidecaptionontop'] = 'Bovenaan';
$string['slidecaptionoptions'] = 'dia-ondertitelopties';
$string['slidecaptionoptionsdesc'] = 'Waar de ondertitels moeten verschijnen in relatie tot de afbeelding';
$string['slidecaptiontextcolor'] = 'Dia-ondertitel-tekstkleur';
$string['slidecaptiontextcolordesc'] = 'Welke kleur moet de ondertitel van de dia hebben? Is niet van toepassing op de optie \'Naast\' diaondertitels';
$string['slidecaptionunderneath'] = 'Onderop';
$string['slidecolor'] = 'Dia tekstkleur';
$string['slidecolordesc'] = 'Kies hier de kleur van de hoofdtekst op de dia.';
$string['slideimage'] = 'Dia-afbeelding';
$string['slideimagedesc'] = 'Gebruik hier een transparante png (formaat is 256px x 256px voor de kleine afbeelding, en 300px x 1200px voor de achtergrondafbeelding)';
$string['slideinterval'] = 'Dia-interval';
$string['slideintervaldesc'] = 'Dia transitie-interval in milliseconden.';
$string['slideno'] = 'Dia {$a->slide}';
$string['slidenodesc'] = 'Vul de instellingen in voor dia {$a->slide}';
$string['slideshowdesc'] = 'Indien ingeschakeld wordt er een dynamische diashow met maximaal 4 dia\'s getoond om belangrijke informatie aantrekkelijk weer te geven.';
$string['slideshowheading'] = 'Voorpagina diashow';
$string['slideshowheadingsub'] = 'Een dynamische diashow voor de voorpagina';
$string['slidetitle'] = 'Diatitel';
$string['slidetitledesc'] = 'Voer een titel in voor je dia.';
$string['slideurl'] = 'Dia-link';
$string['slideurldesc'] = 'Voer hier in waar de link achter "Verder lezen" naar moet verwijzen.';
$string['slideurltarget'] = 'Link-doel';
$string['slideurltargetdesc'] = 'Voer hier in hoe de link geopend moet worden';
$string['slideurltargetnew'] = 'Open in nieuwe pagina';
$string['slideurltargetparent'] = 'Open in hoofdframe';
$string['slideurltargetself'] = 'Open in huidige pagina';
$string['socialdesc'] = 'Geef hier directe links naar de locaties op sociale netwerken waar jouw merk of organisatie voorkomt. Deze links worden overal in de koptekst van de pagina getoond.';
$string['socialheading'] = 'Sociaal netwerken';
$string['socialheadingsub'] = 'Bind je gebruikers door gebruik te maken van sociale netwerken.';
$string['socialnetworks'] = 'Sociale netwerk-sites';
$string['sponsor_desc'] = 'Sponsor alsjeblieft via PayPal door contact met me te maken via \\';
$string['sponsor_desc2'] = 'om de ontwikkeling van Essential gaande te houden, of simpelweg om je dankbaarheid te uiten.';
$string['sponsor_title'] = 'Sponsor Essential';
$string['stylecover'] = 'Afgeschermd';
$string['stylefixed'] = 'Vastgelegd';
$string['styleguide'] = 'Stijlgids';
$string['styleguidedesc'] = 'Originele documentatiecode \'{$a->origcodelicensell}\' van licentie voorzien. Holder.js is \'{$a-holderlicenseurl}\' van licentie voorzien. Extra code \'{$a->thiscodelicensel}\' van licentie voorzien, wat een \'{$a->compatible}\' licentie is. Content \'{$a->contentlicenseurl}\' van licentie voorzien. De documentatie is geformatteerd voor Moodle-uitvoer met toevoeging van FontAwesome-pictogrammen, indien van toepassing. Aanvullende CSS is te vinden in het bestand \'essential_admin_setting_styleguide.php\' onder de opmerking \'// Beyond docs.css.\'. Het gedeelte \'{$a->globalsettings}\' is verwijderd.';
$string['styleguidesub'] = 'Bootstrap V2.3.2 Stijlgids';
$string['stylestretch'] = 'Rekken';
$string['styletiled'] = 'Betegeld';
$string['switchrolemi'] = 'Wissel van rol';
$string['switchrolemidesc'] = 'Toon het wisselrolmenu-item als de gebruiker van rol kan veranderen';
$string['tallyinoftotal'] = '{$a->rtally} in {$a->ctally} of {$a->ctotal}';
$string['tallyoftotal'] = '{$a->tally} of {$a->total}';
$string['themecolor'] = 'Themakleuren';
$string['themecolordesc'] = 'Welke kleur wil je het thema hebben? Dit heeft invloed op meerdere componenten binnen Moodle en bepaalt de basiskleur voor je thema.';
$string['themecolors'] = 'Themakleuren';
$string['themedefaultbuttonbackgroundcolour'] = 'Standaard knop-achtergrondkleur';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Stel de achtergrondkleur in voor alle standaardknoppen.';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Standaard knop-achtergrond-hover-kleur';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Stel de achtergrondkleur-cover-kleur in voor alle standaardknoppen.';
$string['themedefaultbuttontextcolour'] = 'Standaard knoptekstkleur';
$string['themedefaultbuttontextcolourdesc'] = 'Stel de tekstkleur in voor alle standaardknoppen.';
$string['themedefaultbuttontexthovercolour'] = 'Standaard knoptekst-hover-kleur';
$string['themedefaultbuttontexthovercolourdesc'] = 'Stel de tekst-hover-kleur in voor alle standaardknoppen.';
$string['themehovercolor'] = 'Thema hover-kleuren';
$string['themehovercolordesc'] = 'Welke kleuren moeten de hovers in het thema hebben? Dit wordt bijvoorbeeld gebruikt voor links.';
$string['themeiconcolor'] = 'Icoon kleur';
$string['themeiconcolordesc'] = 'Kies de kleur voor alle iconen';
$string['themenavcolor'] = 'Navigatietekstkleur';
$string['themenavcolordesc'] = 'Kies de kleur van de tekst in de navigatie. Het gaat om de navigatiebalk en het kruimelpad-fancy-stijl';
$string['themequizsubmitbackgroundcolour'] = 'Quiz \'Alles insturen en afsluiten\' achtergrondkleur';
$string['themequizsubmitbackgroundcolourdesc'] = 'Stel de achtergrondkleur in voor de quiz \'Alles insturen en afsluiten\' knop.';
$string['themequizsubmitbackgroundhovercolour'] = 'Quiz \'Alles insturen en afsluiten\' achtergrond-hover-kleur';
$string['themequizsubmitbackgroundhovercolourdesc'] = 'Stel de achtergrond-hover-kleur in voor de quiz \'Alles insturen en afsluiten\' knop.';
$string['themequizsubmittextcolour'] = 'Quiz \'Alles insturen en afsluiten\' tekstkleur';
$string['themequizsubmittextcolourdesc'] = 'Stel de tekstkleur in voor de quiz \'Alles insturen en afsluiten\' knop.';
$string['themequizsubmittexthovercolour'] = 'Quiz \'Alles insturen en afsluiten\' tekst-hover-kleur';
$string['themequizsubmittexthovercolourdesc'] = 'Stel de tekst-hover-kleur in voor de quiz \'Alles insturen en afsluiten\' knop.';
$string['themesidepreblockbackgroundcolour'] = '\'side-pre\' block-achtergrondkleur';
$string['themesidepreblockbackgroundcolourdesc'] = 'Stel de achtergrondkleur in voor het \'side-pre\' block.';
$string['themesidepreblockhovercolour'] = '\'side-pre\' link-hover-achtergrondkleur';
$string['themesidepreblockhovercolourdesc'] = 'Stel de link-hover-kleur in voor het \'side-pre\' block.';
$string['themesidepreblocktextcolour'] = '\'side-pre\' blok-tekstkleur';
$string['themesidepreblocktextcolourdesc'] = 'Stel de tekstkleur in voor het \'side-pre\' block.';
$string['themesidepreblockurlcolour'] = '\'side-pre\' block-link-kleur';
$string['themesidepreblockurlcolourdesc'] = 'Stel de linkkleur in voor het \'side-pre\' block.';
$string['themestripebackgroundcolour'] = 'Strepen-achtergrondkleur';
$string['themestripebackgroundcolourdesc'] = 'Stel de achtergrondkleur in voor strepen in tabellen.';
$string['themestripetextcolour'] = 'Strepen-tekstkleur';
$string['themestripetextcolourdesc'] = 'Stel de tekstkleur in voor strepen in tabellen.';
$string['themestripeurlcolour'] = 'Strepen-URL-kleur';
$string['themestripeurlcolourdesc'] = 'Stel de URL-kleur in voor strepen in tablet.';
$string['themetextcolor'] = 'Tekstkleur';
$string['themetextcolordesc'] = 'Selecteer de kleur voor je tekst.';
$string['themeurlcolor'] = 'Linkkleur';
$string['themeurlcolordesc'] = 'Selecteer de kleur voor de tekst hyperlink.';
$string['thiscourse'] = 'In deze cursus';
$string['togglemarketing'] = 'Marketing-blokken inschakelen';
$string['togglemarketingdesc'] = 'Kies hier of je de marketing-blokken wil tonen.';
$string['toggleslideshow'] = 'Diashow inschakelen';
$string['toggleslideshowdesc'] = 'Kies hier of je de diashow in wil schakelen.';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'Link naar je Twitter-feed. (b.v. https://twitter.com/mijnorganisatie)';
$string['twitterurl'] = 'Twitter-URL';
$string['userimageborderradius'] = 'Randradius van gebruikersfoto';
$string['userimageborderradiusdesc'] = 'Specificeer de grensradius tussen {$a->lager} en {$a->boven} pixels van de gebruikersfoto op de hele site, behalve de kop die de instelling \'usermenuuserimageborderradius\' gebruikt.';
$string['usermenu'] = 'Gebruikersmenu';
$string['usermenudesc'] = 'Het menu voor de gebruiker.';
$string['usermenuuserimageborderradius'] = 'Beeldrandradius van het gebruikersmenu';
$string['usermenuuserimageborderradiusdesc'] = 'Geef de randradius op tussen {$a->lager} en {$a->boven} pixels van de gebruikersfoto in het gebruikersmenu.';
$string['usersettingstitle'] = 'Gebruikersinstellingen';
$string['usesiteicon'] = 'Gebruik site-icoon';
$string['usesiteicondesc'] = 'Gebruik het site-icoon als er geen logo is.';
$string['variablewidth'] = 'Volledige breedte';
$string['versionalerttext1'] = 'Dit thema is niet ontwikkeld voor deze Moodle versie';
$string['versionalerttext2'] = 'Onverwachte problemen kunnen zich voordoen, installeer de juiste themaversie voor je Moodle versie.';
$string['versionalerttitle'] = 'Versiewaarschuwing:';
$string['visibleadminonly'] = 'Blokken in deze regio worden alleen aan beheerders getoond';
$string['vk'] = 'VKontakte URL';
$string['vkdesc'] = 'Link naar je VKontakte profiel. (bvb. http://vk.com/mijnorganisatie)';
$string['vkurl'] = 'VKontakte-URL';
$string['website'] = 'Website-URL';
$string['websitedesc'] = 'Link naar je website. (b.v. http://www.uplearning.nl)';
$string['websiteurl'] = 'Website-URL';
$string['windows'] = 'Windows Desktop';
$string['windowsdesc'] = 'Geef een URL op voor je Moodle APP in de Window Store. Als je zelf geen URL hebt, overweeg dan de link van de officiële Moodle App te gebruiken. (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['windowsurl'] = 'Windows Desktop-URL';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = 'Geef een URL op voor je Moodle APP in de Google Play Store. Als je zelf geen URL hebt, overweeg dan de link van de officiële Moodle App te gebruiken. (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['winphoneurl'] = 'Windows-Mobile-URL';
$string['within'] = 'Binnen';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Link naar je YouTube kanaal. (bvb. https://www.youtube.com/user/mijnorganisatie)';
$string['youtubeurl'] = 'YouTube-URL';
