<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'no', branch 'MOODLE_36_STABLE'
 *
 * @package   backup
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['autoactivedescription'] = 'Velg om du vil aktivere automatisk sikkerhetskopiering. Dersom manuell er valgt, vil automatisk sikkerhetskopiering bare være mulig via egne CLI-skript. Dette kan gjøres manuelt via kommandolinja eller via cron.';
$string['autoactivedisabled'] = 'Deaktivert';
$string['autoactiveenabled'] = 'Aktivert';
$string['autoactivemanual'] = 'Manuell';
$string['automatedbackupschedule'] = 'Tidsplan';
$string['automatedbackupschedulehelp'] = 'Velg hvilke dager i uken det skal tas automatiske sikkerhetskopier.';
$string['automatedbackupsinactive'] = 'Portaladministrator har ikke aktivert automatiske sikkerhetskopier';
$string['automatedbackupstatus'] = 'Status for automatiske sikkerhetskopier';
$string['automateddeletedays'] = 'Slett sikkerhetskopier eldre enn';
$string['automatedmaxkept'] = 'Maksimalt antall sikkerhetskopier som skal beholdes';
$string['automatedmaxkepthelp'] = 'Her angir du det største antallet av automatiske sikkerhetskopier som skal beholdes for hvert kurs. Eldre sikkerhetskopier vil bli slettet automatisk.';
$string['automatedminkept'] = 'Minste antall sikkerhetskopier som skal beholdes';
$string['automatedminkepthelp'] = 'Hvis sikkerhetskopier slettes kun på bakgrunn av alder, så kan det hende at et kurs blir stående uten sikkerhetskopier. For å forhindre dette så bør du angi et minste antall sikkerhetskopier som skal beholdes.';
$string['automatedsettings'] = 'Innstillinger for automatiske sikkerhetskopier';
$string['automatedsetup'] = 'Oppsett av automatiske sikkerhetskopier';
$string['automatedstorage'] = 'Lagring av automatiske sikkerhetskopier';
$string['automatedstoragehelp'] = 'Velg hvor du ønsker å lagre automatiske sikkerhetskopier';
$string['backupactivity'] = 'Sikkerhetskopieraktivitet: {$a}';
$string['backupcourse'] = 'Sikkerhetskopier kurs: {$a}';
$string['backupcoursedetails'] = 'Kursinformasjon';
$string['backupcoursesection'] = 'Seksjon: {$a}';
$string['backupcoursesections'] = 'Kursseksjoner';
$string['backupdate'] = 'Dato utført';
$string['backupdetails'] = 'Sikkerhetskopidetaljer';
$string['backupdetailsnonstandardinfo'] = 'Den valgte filen er ingen standard Moodle sikkerhetskopifil. Gjenopprettingsprosessen vil forsøke å konvertere sikkerhetskopifilen til standardformatet og deretter gjenopprette den.';
$string['backupformat'] = 'Format';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Ukjent format';
$string['backuplog'] = 'Teknisk informasjon og advarsler';
$string['backupmode'] = 'Modus';
$string['backupmode10'] = 'Generelt';
$string['backupmode20'] = 'Importér';
$string['backupmode30'] = 'Hub';
$string['backupmode40'] = 'Samme kursportal';
$string['backupmode50'] = 'Automatisk';
$string['backupmode60'] = 'Konvertert';
$string['backupsection'] = 'Sikkerhetskopier kursseksjon: {$a}';
$string['backupsettings'] = 'Innstillinger for sikkerhetskopiering';
$string['backupsitedetails'] = 'Portalinformasjon';
$string['backupstage16action'] = 'Fortsett';
$string['backupstage1action'] = 'Neste';
$string['backupstage2action'] = 'Neste';
$string['backupstage4action'] = 'Utfør sikkerhetskopieringen';
$string['backupstage8action'] = 'Fortsett';
$string['backuptype'] = 'Type';
$string['backuptypeactivity'] = 'Aktivitet';
$string['backuptypecourse'] = 'Kurs';
$string['backuptypesection'] = 'Emne/uke';
$string['backupversion'] = 'Versjon av sikkerhetskopi';
$string['cannotfindassignablerole'] = 'Rollen {$a} i sikkerhetskopien kan ikke mappes til noen av rollene du har tillatelse til å administrere.';
$string['choosefilefromactivitybackup'] = 'Aktiviteters skkkerhetskopiområde';
$string['choosefilefromactivitybackup_help'] = 'Dersom sikkerhetskopi av aktiviteter bruker standardinnstillingene, vil sikkerhetskopifilen bli lagret her';
$string['choosefilefromautomatedbackup'] = 'Automatiske sikkerhetskopier';
$string['choosefilefromautomatedbackup_help'] = 'Inneholder sikkerhetskopier som er automatisk generert.';
$string['choosefilefromcoursebackup'] = 'Kursets sikkerhetskopi-område';
$string['choosefilefromcoursebackup_help'] = 'Når du sikkerhetskopierer kurs med standardinnstillinger vil sikkerhetskopiene bli lagret her';
$string['choosefilefromuserbackup'] = 'Privat sikkerhetskopi-område';
$string['choosefilefromuserbackup_help'] = 'Når kurs blir sikkerhetskopiert med opsjonen "Anonymiser brukerinformasjon" avmerket, vil sikkerhetskopiene bli lagret her';
$string['configgeneralactivities'] = 'Angir som standard at aktiviteter skal tas med i sikkerhetskopier.';
$string['configgeneralanonymize'] = 'Dersom aktivert vil all brukerinformasjon som standard bli anonymisert.';
$string['configgeneralbadges'] = 'Angir at utmerkelser som standard skal tas med i sikkerhetskopier.';
$string['configgeneralblocks'] = 'Angir at blokker som standard skal tas med i sikkerhetskopier.';
$string['configgeneralcalendarevents'] = 'Bestemmer standardinnstillingene for inkludering av kalenderhendelser i en sikkerhetskopi';
$string['configgeneralcomments'] = 'Angir at kommentarer som standard skal tas med i sikkerhetskopier.';
$string['configgeneralcompetencies'] = 'Bestemmer standardinnstillingene for inkludering av læringsmål i en sikkerhetskopi.';
$string['configgeneralfilters'] = 'Angir at filtre som standard skal tas med i sikkerhetskopier.';
$string['configgeneralgroups'] = 'Bestemmer standardinnstillingen for inkludering av grupper og tilgangsgrupper i sikkerhetskopier';
$string['configgeneralhistories'] = 'Angir at brukerhistorie som standard skal tas med i sikkerhetskopier.';
$string['configgenerallogs'] = 'Angir at logger som standard skal tas med i sikkerhetskopier.';
$string['configgeneralquestionbank'] = 'Når aktivert vil testbanken være inkludert i sikkerhetskopier som standard. VENNLIGST MERK: Å deaktivere denne innstillingen vil fjerne sikkerhetskopieringen av aktiviter som bruker testbanken, slik som quiz.';
$string['configgeneralroleassignments'] = 'Angir at rolletildelinger som standard skal tas med i sikkerhetskopier.';
$string['configgeneralusers'] = 'Angir at brukere som standard skal tas med i sikkerhetskopier.';
$string['configgeneraluserscompletion'] = 'Angir at brukernes fullførtinformasjon som standard skal tas med i sikkerhetskopier.';
$string['config_keep_groups_and_groupings'] = 'Behold nåværende grupper og tilgangsgrupper som standard.';
$string['config_keep_roles_and_enrolments'] = 'Behold nåværende grupper og tilgangsgrupper som standard.';
$string['configloglifetime'] = 'Dette angir hvor lenge du ønsker å ta vare på logginformasjon fra sikkerhetskopieringen. Logger som er eldre enn dette blir slettet. Det anbefales å holde denne verdien lav, siden loggene fra sikkerhetskopieringen kan bli svære.';
$string['config_overwrite_conf'] = 'Tillat bruker å overskrive nåværende kursinnstillinger';
$string['config_overwrite_course_fullname'] = 'Overskriv kursets fulle navn med det fra sikkerhetskopien som standard. Dette krever tillatelsen "Overskriv kursinnstillinger" og at brukeren har tillaten om å endre kursnavn (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Overskriv kursets kortnavn med det fra sikkerhetskopien som standard. Dette krever tillatelsen "Overskriv kursinnstillinger" og at brukeren har tillaten om å endre kursets kortnavn (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Overskriv kursets startdato med den fra sikkerhetskopien som standard. Dette krever tillatelsen "Overskriv kursinnstillinger" og at brukeren har tillaten om å endre kursdato ved gjenoppretting (moodle/restore:rolldates)';
$string['configrestoreactivities'] = 'Bestemmer standardinnstillingene for gjenoppretting av aktiviteter';
$string['configrestorebadges'] = 'Bestemmer standardinnstillingene for gjenoppretting av utmerkelser.';
$string['configrestoreblocks'] = 'Bestemmer standardinnstillingene for gjenoppretting av blokker.';
$string['configrestorecalendarevents'] = 'Bestemmer standardinnstillingene for gjenoppretting av kalenderhendelser';
$string['configrestorecomments'] = 'Bestemmer tandardinnstillingene for gjenoppretting av kommentarer';
$string['configrestorecompetencies'] = 'Bestemmer standardinnstillingene for gjenoppretting av læringsmål';
$string['configrestoreenrolments'] = 'Bestemmer standardinnstillingene for gjenoppretting av innmeldingsmetoder.';
$string['configrestorefilters'] = 'Bestemmer standardinnstillingen for å gjenopprette filtre.';
$string['configrestoregroups'] = 'Bestemmer standardinnstillingene for gjenoppretting av grupper og tilgangsgrupper dersom de er inkludert i sikkerhetskopien';
$string['configrestorehistories'] = 'Bestemmer standardinnstillingene for gjenoppretting av brukerhistorie dersom det er inkludert i sikkehetskopien.';
$string['configrestorelogs'] = 'Hvis aktivert vil logger som standard bli gjenopprettet dersom de er inkludert i sikkerhetskopien.';
$string['configrestoreroleassignments'] = 'Hvis aktivert vil rolletildelinger som standard bli gjenopprettet dersom de er inkludert i sikkerhetskopien.';
$string['configrestoreusers'] = 'Bestemmer om det skal være standar å inkludere brukere i sikkerhetskopier';
$string['configrestoreuserscompletion'] = 'Hvis aktivert vil fullførtdata bli gjenopprettet dersom det var inkludert i sikkerhetskopien.';
$string['confirmcancel'] = 'Avbryt sikkerhetskopieringen';
$string['confirmcancelimport'] = 'Avbryt import';
$string['confirmcancelno'] = 'Ikke avbryt';
$string['confirmcancelquestion'] = 'Er du sikker på at du vil avbryte?
All informasjon som er lagt inn vil gå tapt.';
$string['confirmcancelrestore'] = 'Avbryt gjenoppretting';
$string['confirmcancelyes'] = 'Avbryt sikkerhetskopiering';
$string['confirmnewcoursecontinue'] = 'Varsel om nytt kurs';
$string['confirmnewcoursecontinuequestion'] = 'Som en del av gjenopprettingsprosessen lages det et skjult midlertidig kurs. Klikk på Avbryt for å stoppe gjenopprettingen. Ikke lukk nettleservinduet mens gjenopprettingen foregår.';
$string['coursecategory'] = 'Kategorien hvor gjenopprettet kurs vil bli plassert';
$string['courseid'] = 'Original ID';
$string['coursesettings'] = 'Kursinnstillinger';
$string['coursetitle'] = 'Tittel';
$string['currentstage1'] = 'Grunnleggende innstillinger';
$string['currentstage16'] = 'Fullført';
$string['currentstage2'] = 'Skjemainnstillinger';
$string['currentstage4'] = 'Se over og bekreft';
$string['currentstage8'] = 'Utfør sikkerhetskopieringen';
$string['enterasearch'] = 'Skriv inn søkeord(ene)';
$string['error_block_for_module_not_found'] = 'Blokkinstans uten tilknytning (id: {$a->bid}) for kursmodulen (id: {$a->mid}) funnet. Denne blokken vil ikke bli sikkerhetskopiert.';
$string['errorcopyingbackupfile'] = 'Kunne ikke kopiere sikkerhetskopien til den midlertidige mappen';
$string['error_course_module_not_found'] = 'Modulinstans uten tilknytning (id: {$a})  funnet. Denne modulen vil ikke bli sikkerhetskopiert.';
$string['errorfilenamemustbezip'] = 'Filnavnet du skriver inn må være en ZIP eller ha filendelsen .mbz';
$string['errorfilenamerequired'] = 'Du må angi et gyldig filnavn for denne sikkerhetskopien';
$string['errorfilenametoolong'] = 'Filnavnet må være på mindre enn 255 tegn';
$string['errorinvalidformat'] = 'Ukjent format for sikkerhetskopi';
$string['errorinvalidformatinfo'] = 'Den valgte fila er ingen gyldig Moodle sikkerhetskopifil og kan ikke gjenopprettes.';
$string['errorminbackup20version'] = 'Denne sikkerhetskopien er blitt opprettet med en  utviklingsversjon av Moodle {$a->backup}). Minstekrav er {$a->min}. Kan ikke gjenopprettes.';
$string['errorrestorefrontpagebackup'] = 'Du kaan bare gjenopprette en sikkerhetskopi av forsiden på forsiden.';
$string['executionsuccess'] = 'Oppretting av sikkerhetskopifilen gikk fint.';
$string['filealiasesrestorefailures'] = 'Feil ved gjenoppretting av aliaser.';
$string['filealiasesrestorefailures_help'] = 'Aliaser er symbolske lenker til andre filer, inkludert de som er lagret i eksterne fillagre. I noen tilfeller kan Moodle ikke gjenopprette dem - for eksempel når sikkerhetskopien gjenopprettes på et annet nettsted, eller når filen det refereres til ikke eksisterer.

Flere detaljer og den faktiske årsaken til feilen finnes i gjenopprettingensloggfilen.';
$string['filealiasesrestorefailuresinfo'] = 'Noen aliaser inkludert i sikkerhetskopifilen kunne ikke gjenopprettes. Følgende liste innholder forventet plassering og kildefilen de viser til på den originale installasjonen.';
$string['filename'] = 'Filnavn';
$string['filereferencesincluded'] = 'Filreferanser til eksternt innhold inkludert i sikkerhetskopipakken. Disse referansene vil ikke fungere på andre kursportaler.';
$string['filereferencesnotsamesite'] = 'Sikkerhetskopien er fra en annen kursportal. Filreferansene kan ikke gjenopprettes.';
$string['filereferencessamesite'] = 'Sikkerhetskopien er fra samme kursportal og filreferansene kan gjenopprettes.';
$string['generalactivities'] = 'Inkluder aktiviteter og ressurser';
$string['generalanonymize'] = 'Anonymiser informasjon';
$string['generalbackdefaults'] = 'Generelle standardinnstillinger for sikkerhetskopier';
$string['generalbadges'] = 'Ta med utmerkelser';
$string['generalblocks'] = 'Inkluder blokker';
$string['generalcalendarevents'] = 'Inkluder kalenderhendelser';
$string['generalcomments'] = 'Inkluder kommentarer';
$string['generalcompetencies'] = 'Inkluder læringsmål';
$string['generalenrolments'] = 'Inkluder innmeldingsmetoder';
$string['generalfilters'] = 'Inkluder filtre';
$string['generalgradehistories'] = 'Inkluder historie';
$string['generalgroups'] = 'Inkluder grupper og tilgangsgrupper';
$string['generalhistories'] = 'Inkluder historie';
$string['generallogs'] = 'Inkluder logger';
$string['generalquestionbank'] = 'Inkluder testbanken';
$string['generalrestoredefaults'] = 'Standardinstillinger for gjenoppretting';
$string['generalrestoresettings'] = 'Generelle gjenopprettingsinnstillinger';
$string['generalroleassignments'] = 'Inkluder rolletildelinger';
$string['generalsettings'] = 'Generelle sikkerhetskopiinnstillinger';
$string['generalusers'] = 'Inkluder brukere';
$string['generaluserscompletion'] = 'Inkluder brukernes fullførtinformasjon';
$string['hidetypes'] = 'Skjul typevalgene';
$string['importbackupstage16action'] = 'Fortsett';
$string['importbackupstage1action'] = 'Neste';
$string['importbackupstage2action'] = 'Neste';
$string['importbackupstage4action'] = 'Utfør importen';
$string['importbackupstage8action'] = 'Fortsett';
$string['importcurrentstage0'] = 'Valg av kurs';
$string['importcurrentstage1'] = 'Grunnleggende innstillinger';
$string['importcurrentstage16'] = 'Fullfør';
$string['importcurrentstage2'] = 'Skjemainnstillinger';
$string['importcurrentstage4'] = 'Se over og bekreft';
$string['importcurrentstage8'] = 'Utfør import';
$string['importfile'] = 'Importer en sikkerhetskopifil';
$string['importgeneralduplicateadminallowed'] = 'Tillat adminkonfilktløsning';
$string['importgeneralduplicateadminallowed_desc'] = 'Dersom det er en brukerkonto på portalen med brukernavnet "admin", kan det skape problemer om du gjenoppretter en sikkerhetskopi som inneholder en brukerkonto med brukernavn "Admin". Dersom denne innstillingen aktiveres vil den løse problemet ved å endre brukernavnet i sikkerhetskopien til "admin_xyz"';
$string['importgeneralmaxresults'] = 'Maks antall kurs oppgitt for import';
$string['importgeneralmaxresults_desc'] = 'Dette kontrollerer antall kurs som vises under det første steget av importprosessen.';
$string['importgeneralsettings'] = 'Generelle standarder for import';
$string['importrootsettings'] = 'Importinnstillinger';
$string['importsettings'] = 'Generelle importeringsinnstillinger';
$string['importsuccess'] = 'Importen er ferdig. Klikk på Fortsett for å gå til kurset.';
$string['includeactivities'] = 'Inkluder:';
$string['includeditems'] = 'Inkluderte elementer:';
$string['includefilereferences'] = 'Filreferanser til eksternt innhold';
$string['includesection'] = 'Seksjon: {$a}';
$string['includeuserinfo'] = 'Brukerdata';
$string['jumptofinalstep'] = 'Fortsett til sluttsteget';
$string['keep'] = 'Behold';
$string['locked'] = 'Låst';
$string['lockedbyconfig'] = 'Denne innstillingen er låst i standardinnstillingene for sikkerhetskopiering';
$string['lockedbyhierarchy'] = 'Låst på grunn av avhengighetene';
$string['lockedbypermission'] = 'Du har ikke tilstrekkelige rettigheter til å endre disse innstillingene';
$string['loglifetime'] = 'Behold logger for';
$string['managefiles'] = 'Administrere sikkerhetskopifiler';
$string['mergerestoredefaults'] = 'Bruk standardinnstillinger når et kurs slås sammen med et annet';
$string['missingfilesinpool'] = 'Noen filer ble ikke lagret under sikkerhetskopieringen. Det vil ikke være mulig å gjenopprette dem.';
$string['module'] = 'Modul';
$string['moodleversion'] = 'Moodle versjon';
$string['morecoursesearchresults'] = 'Flere enn {$a} kurs funnet. Viser de første {$a} resultatene';
$string['moreresults'] = 'Det er for mange treff, skriv inn mer avgrensede søkekriterier.';
$string['nomatchingcourses'] = 'Ingen kurs å vise';
$string['norestoreoptions'] = 'Det er ingen kategorier eller eksisterende kurs du kan gjenopprette til.';
$string['originalwwwroot'] = 'URL til en sikkerhetskopi';
$string['overwrite'] = 'Overskriv';
$string['preparingdata'] = 'Forbereder data';
$string['preparingui'] = 'Forbereder sidevisningen';
$string['previousstage'] = 'Forrige';
$string['privacy:metadata:backup_controllers'] = 'Listen med sikkerhetskopieringsoperasjoner';
$string['privacy:metadata:backup_controllers:itemid'] = 'KurseID\'en.';
$string['privacy:metadata:backup_controllers:operation'] = 'Operasjonen som ble utført, f.eks. gjenoppretting.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Tidspunktet for når handlingen ble opprettet';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Tidspunktet handlingen ble endret';
$string['privacy:metadata:backup_controllers:type'] = 'Elementtypen det opereres på, f.eks. aktivitet.';
$string['privacy:metadata:backup:detailsofarchive'] = 'Dette arkivet kan inneholde ulike brukerdata reatert til kurset, som f.eks. karakterer, innmeldinger og aktivitetsdata.';
$string['privacy:metadata:backup:externalpurpose'] = 'Formålet med denne tte arkivet er å oppbevare kursrelatert informasjon slik at kurset kan gjenopprettes på et senere tidspunkt';
$string['qcategory2coursefallback'] = 'Spørsmålskategorien "{$a->name}", som originalt befant seg på kurskategori-nivå i sikkerhetskopifilen, vil bli gjenopprettet som en kursbasert kategori ved gjenoppretting.';
$string['qcategorycannotberestored'] = 'Spørsmålskategorien "{$a->name}", kan ikke opprettes ved gjenoppretting';
$string['question2coursefallback'] = 'Spørsmålskategorien "{$a->name}", som originalt befant seg på kurskategori-nivå i sikkerhetskopifilen, vil bli gjenopprettet som en kursbasert kategori ved gjenoppretting.';
$string['questionegorycannotberestored'] = 'Spørsmålene  "{$a->name}" kan ikke opprettes ved gjenoppretting';
$string['recyclebin_desc'] = 'Disse innstillingene vil også påvirke papirkurven.';
$string['replacerestoredefaults'] = 'Gjenopprett standardinnstillingene når sammenslåing med et annet kurs vil slette innhold';
$string['restoreactivity'] = 'Gjenopprett aktiviet';
$string['restorecourse'] = 'Gjenopprett kurs';
$string['restorecoursesettings'] = 'Kursinnstillinger';
$string['restoreexecutionsuccess'] = 'Gjenoppretting av kurset var vellykket, klikk på Fortsett-knappen for å gå til kurset.';
$string['restorefileweremissing'] = 'Noen filer kunne ikke gjenopprettes fordi de ikke var lagret i sikkerhetskopien.';
$string['restorenewcoursefullname'] = 'Nytt kursnavn';
$string['restorenewcourseshortname'] = 'Nytt kurs kortnavn';
$string['restorenewcoursestartdate'] = 'Ny startdato';
$string['restorerolemappings'] = 'Gjenopprett rollemappingen';
$string['restorerootsettings'] = 'Gjenopprett innstillinger';
$string['restoresection'] = 'Gjenopprett seksjon';
$string['restorestage1'] = 'Bekreft';
$string['restorestage16'] = 'Se over';
$string['restorestage16action'] = 'Utfør gjenopprettingen';
$string['restorestage1action'] = 'Neste';
$string['restorestage2'] = 'Mål';
$string['restorestage2action'] = 'Neste';
$string['restorestage32'] = 'Prosess';
$string['restorestage32action'] = 'Fortsett';
$string['restorestage4'] = 'Innstillinger';
$string['restorestage4action'] = 'Neste';
$string['restorestage64'] = 'Ferdig';
$string['restorestage64action'] = 'Fortsett';
$string['restorestage8'] = 'Skjema';
$string['restorestage8action'] = 'Neste';
$string['restoretarget'] = 'Mål for gjenopprettingen';
$string['restoretocourse'] = 'Gjenopprett til kurs: ';
$string['restoretocurrentcourse'] = 'Gjenopprett i dette kurset';
$string['restoretocurrentcourseadding'] = 'Flett det gjenopprettede kurset inn i dette kurset';
$string['restoretocurrentcoursedeleting'] = 'Slett dette kursets innhold og deretter gjenopprett hit.';
$string['restoretoexistingcourse'] = 'Gjenopprett inn i et eksisterende kurs';
$string['restoretoexistingcourseadding'] = 'Flett det gjenopprettede kurset inn i et eksisterende kurs';
$string['restoretoexistingcoursedeleting'] = 'Slett innholdet i eksisterende kurs og deretter gjenopprett.';
$string['restoretonewcourse'] = 'Gjenopprett som et nytt kurs';
$string['restoringcourse'] = 'Kursgjenoppretting pågår';
$string['restoringcourseshortname'] = 'gjenoppretter';
$string['rootenrolmanual'] = 'Gjenoppretter som manuelle påmeldinger';
$string['rootsettingactivities'] = 'Inkluder aktiviteter og ressurser';
$string['rootsettinganonymize'] = 'Anonymiser brukerinformasjon';
$string['rootsettingbadges'] = 'Ta med utmerkelser';
$string['rootsettingblocks'] = 'Inkluder blokker';
$string['rootsettingcalendarevents'] = 'Ta med kalenderhendelser';
$string['rootsettingcomments'] = 'Inkluder kommentarer';
$string['rootsettingcompetencies'] = 'Inkluder kompetanser';
$string['rootsettingenrolments'] = 'Inkluder innmeldingsmetoder';
$string['rootsettingenrolments_always'] = 'Ja, alltid';
$string['rootsettingenrolments_never'] = 'Nei, gjenopprett brukere som manuelle påmeldinger';
$string['rootsettingenrolments_withusers'] = 'Ja, men bare dersom brukere er inkludert';
$string['rootsettingfilters'] = 'Inkluder filtre';
$string['rootsettinggradehistories'] = 'Inkluder karakterhistorie';
$string['rootsettinggroups'] = 'Inkluder grupper og tilgangsgrupper';
$string['rootsettingimscc1'] = 'Konverter til IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Konverter til IMS Common Cartridge 1.1';
$string['rootsettinglogs'] = 'Inkluder kurslogger';
$string['rootsettingquestionbank'] = 'Inkluder testbanken';
$string['rootsettingroleassignments'] = 'Inkluder brukerrolle tildelinger';
$string['rootsettings'] = 'Innstillinger for sikkerhetskopiering';
$string['rootsettingusers'] = 'Inkluder påmeldte brukere';
$string['rootsettinguserscompletion'] = 'Inkluder brukernes fullførtinformasjon';
$string['sectionactivities'] = 'Aktiviteter';
$string['sectioninc'] = 'Inkludert i sikkerhetskopien (ingen brukerinformasjon)';
$string['sectionincanduser'] = 'Inkludert i sikkerhetskopien sammen med brukerinfomasjonen';
$string['selectacategory'] = 'Velg en kategori';
$string['selectacourse'] = 'Velg et kurs';
$string['setting_course_fullname'] = 'Kursnavn';
$string['setting_course_shortname'] = 'Kursets kortnavn';
$string['setting_course_startdate'] = 'Kursets startdato';
$string['setting_keep_groups_and_groupings'] = 'Behold gjeldende grupper og tilgangsgrupper';
$string['setting_keep_roles_and_enrolments'] = 'Behold gjeldende roller og påmeldinger';
$string['setting_overwrite_conf'] = 'Overskriv kursinnstillinger';
$string['setting_overwrite_course_fullname'] = 'Overskriv kursets fulle navn';
$string['setting_overwrite_course_shortname'] = 'Overskriv kursets kortnavn';
$string['setting_overwrite_course_startdate'] = 'Overskriv kursets startdato';
$string['showtypes'] = 'Vis typevalgene';
$string['sitecourseformatwarning'] = 'Dette er en sikkerhetskopi av forsiden. Denne kan bare gjenopprettes fra forsiden.';
$string['skiphidden'] = 'Hopp over skjulte kurs';
$string['skiphiddenhelp'] = 'Velg om du vil hoppe over skjulte kurs';
$string['skipmodifdays'] = 'Hopp over kurs som ikke er endret siden';
$string['skipmodifdayshelp'] = 'Velg å hoppe over kurs som ikke har blitt endret på et bestemt antall dager';
$string['skipmodifprev'] = 'Hopp over kurs som ikke har blitt endret siden forrige sikkerhetskopiering';
$string['skipmodifprevhelp'] = 'Velg om du vil hoppe over kurs som ikke har blitt endret siden forrige sikkerhetskopiering. Dette krever at logging er aktivert.';
$string['storagecourseandexternal'] = 'Kursets filområde for sikkerhetskopier med spesifisert mappe';
$string['storagecourseonly'] = 'Kursets filområde for sikkerhetskopier';
$string['storageexternalonly'] = 'Angitt mappe for automatiske sikkerhetskopier';
$string['timetaken'] = 'Totalt brukt tid';
$string['title'] = 'Tittel';
$string['totalcategorysearchresults'] = 'Totalt antall kategorier: {$a}';
$string['totalcoursesearchresults'] = 'Totalt antall kurs: {$a}';
$string['undefinedrolemapping'] = 'Rollemapping udefinert for \'{$a}\' arketypen.';
$string['unnamedsection'] = 'Seksjon uten navn';
$string['userinfo'] = 'Brukerinformasjon';
