<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'no', branch 'MOODLE_36_STABLE'
 *
 * @package   auth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Aktive autentiseringstillegg';
$string['allowaccountssameemail'] = 'Tillat duplikate epostradresser på brukere.';
$string['allowaccountssameemail_desc'] = 'Når aktivert, kan mer enn en brukerkonto registreres med samme epostadresse. Dette kan være problematisk i forhold til sikkehets- og personvernhensyn, f.eks. ved utsendelse av epost ved passordbytte.';
$string['alternatelogin'] = 'Dersom du skriver inn en URL her, vil den bli brukt som innloggingsside for denne Moodle-portalen. Siden må inneholde et skjema med action-egenskapen satt til  <strong>\'{$a}\'</strong> og returnere feltene <strong>username</strong> and <strong>password</strong>.<br/> OBS! Hvis du skriver inn feil URL risikerer du å låse deg selv ute fra Moodle.<br/>La feltet være tomt for å bruke standard innloggingsside.';
$string['alternateloginurl'] = 'Alternativ innlogging URL';
$string['auth_changepasswordhelp'] = 'Hjelp for passordendring';
$string['auth_changepasswordhelp_expl'] = 'Vis mistet passordhjelp til brukere som har mistet sitt {$a} passord. Dette vil bli enten i tillegg eller i stedet for <strong>Endre Passord URL</strong> og Intern Moodle passordendring.';
$string['auth_changepasswordurl'] = 'URL for å endre passord';
$string['auth_changepasswordurl_expl'] = 'Angi url hvor en skal sende brukere som har mistet {$a} passordet sitt. Angi <strong>Bruk standard passordendringsside</strong> til <strong>Nei</strong>.';
$string['auth_changingemailaddress'] = 'Du har bedt om å endre e-postadressen, fra {$a->oldemail} to {$a->newemail}. Av sikkerhetsgrunner sender vi deg en e-post til den nye adressen for å bekrefte at denne tilhører deg. E-postadressen din vil bli oppdatert straks du klikker på URL-en i den tilsendte meldingen.<br />
<strong>OBS!</strong> Bekreft via URL straks du har fått e-posten. Går det for lang tid vil bekreftelsesprosessen bli annulert automatisk og du må begynne på nytt!';
$string['auth_common_settings'] = 'Vanlige instillinger';
$string['auth_data_mapping'] = 'Datamapping';
$string['authenticationoptions'] = 'Valgmuligheter autentisering';
$string['auth_fieldlock'] = 'Låseverdi';
$string['auth_fieldlock_expl'] = '<p><b>Låseverdi:</b> Hvis slått på, vil den forhindre Moodlebrukere og administratorer fra å redigere feltet direkte. Bruk dette valget hvis du vedlikeholder dataene i et ekstern autentiseringssystem. </p>';
$string['auth_fieldlockfield'] = 'Lås verdi ({$a})';
$string['auth_fieldlocks'] = 'Lås brukerfelt';
$string['auth_fieldlocks_help'] = '<p>Du kan låse brukerdatafelter. Dette er nyttig for nettsteder hvor data er vedlikeholdt manuelt vedd å redigere brukerfelter og laste opp brukere. Hvis du låser felter som trengs av Moodle, pass på at du gir de nødvendige data når du oppretter brukerkontoen, ellers vil brukerkontoen være ubrukbar </p><p>Vurder å bruk valget \'Ulåst hvis tom\' for å unngå dette problemet.';
$string['auth_fieldmapping'] = 'Datamapping ({$a})';
$string['authinstructions'] = 'La dette feltet være blankt hvis du ønsker at standard innloggingsinstruksjoner skal benyttes. Dersom du vil skrive dine egne instruksjoner, gjør du det her.';
$string['auth_invalidnewemailkey'] = 'FEIL: Dersom du prøver å bekrefte endring av en e-postadresse, kan du ha fått feil i adressen du kopierte inn i nettleseren din. Vennligst kopier tilsendt URL på nytt og prøv igjen.';
$string['authloginviaemail'] = 'Tillat innlogging via e-post';
$string['authloginviaemail_desc'] = 'Tillater brukere å bruke både brukernavn og epost (dersom unike) for innlogging på portalen.';
$string['auth_multiplehosts'] = 'Flere verter kan spesifiseres (f.eks. vert1.no;vert2.no;vert3.no)';
$string['auth_notconfigured'] = 'Autentiseringsmetoden {$a} er ikke konfigurert.';
$string['auth_outofnewemailupdateattempts'] = 'Du har nå forsøkt endre e-postadressen for mange ganger. Oppdateringen er derfor avbrutt.';
$string['auth_passwordisexpired'] = 'Passordet ditt er utløpt. Vennligst endre det med en gang.';
$string['auth_passwordwillexpire'] = 'Passordet ditt utløper om {$a} dager. Vil du endre passord nå?';
$string['auth_remove_delete'] = 'Full sletting internt';
$string['auth_remove_keep'] = 'Behold internt';
$string['auth_remove_suspend'] = 'Fjern internt';
$string['auth_remove_user'] = 'Angi hva du vil gjøre med intern brukerkonto ved massesynkronisering når brukeren slettes fra ekstern kilde. Bare utestengte brukere gjenåpnes automatisk hvis de gjenoppstår i ekstern kilde.';
$string['auth_remove_user_key'] = 'Fjernet fjernbruker';
$string['auth_sync_script'] = 'Brukerkontosynkronisering';
$string['auth_sync_suspended'] = 'Hvis det er aktivert, vil den suspenderte attributteten bli brukt til å oppdatere den lokale brukerkontoens suspensjonsstatus.';
$string['auth_sync_suspended_key'] = 'Synkroniser lokal brukers suspenderingsstatus';
$string['auth_updatelocal'] = 'Oppdater lokal';
$string['auth_updatelocal_expl'] = '<p><b>Oppdater lokal:</b>Hvis påslått, vil felt bli oppdatert (fra ekstern kilde) hver gang brukeren logger inn eller at det er en brukersynkronisering. Felter satt til lokal oppdatering bør låses.</p>';
$string['auth_updatelocalfield'] = 'Oppdater lokal ({$a})';
$string['auth_updateremote'] = 'Oppdater ekstern';
$string['auth_updateremote_expl'] = '<p><b>Oppdater ekstern:</b>Hvis påslått, vil ekstern kilde bli oppdatert når brukeropplysningene oppdateres. Felter bør ikke låses for å tillate endringer.</p>';
$string['auth_updateremotefield'] = 'Oppdater ekstern ({$a})';
$string['auth_updateremote_ldap'] = '<p><b>Å oppdatere eksterne LDAP data betinger at du setter binddn og bindpw til en bind-bruker med redigeringstillatelser til alle brukerdata. Den støtter for ikke egenskaper med multi-verdier, og vil fjerne ekstra verdier i oppdateringen.</p>';
$string['auth_user_create'] = 'Slå på brukerinnmelding';
$string['auth_user_creation'] = 'Nye (anonyme) brukere kan opprette brukerkontoer med kilden til den eksterne autentiseringen og bekrefte via e-post. Hvis du slår på denne må du også huske på å konfigurere spesielle innstillinger for oppretting av brukere.';
$string['auth_usernameexists'] = 'Noen har allerede valgt dette brukernavnet. Vennligst prøv et annet.';
$string['auth_usernotexist'] = 'Kan ikke oppdatere ikke-eksisterende bruker: {$a}';
$string['auto_add_remote_users'] = 'Legg til fjernbrukere automatisk';
$string['cannotmapfield'] = 'Feltet "{$a->fieldname}" kan ikke mappes fordi kortnavnet "{$a->shortname}" er for langt. For at det skal kunne mappes må kortnavnet reduseres til til grensen på  {$a->charlimit} tegn. <a href="{$a->link}">Rediger brukerprofilfelt</a>';
$string['changepassword'] = 'URL for å endre passord';
$string['changepasswordhelp'] = 'URL til glemt passord-siden, som blir sendt til brukere i en e-post. Merk at denne innstillingen ikke vil ha noen effekt dersom glemt passord-url er angitt i standardinnstillingene for autentisering av brukere.';
$string['chooseauthmethod'] = 'Velg en autentiseringsmetode:';
$string['chooseauthmethod_help'] = 'Denne innstillingen bestemmer hvilken autentiseringsmetode som skal brukes når brukeren logger inn. Bare aktiverte autentiseringsmetoder bør velges, ellers vil ikke brukere kunne logge inn. Dersom du vil forhindre innlogging bruker du "Ingen innlogging".';
$string['createpassword'] = 'Generer passord og varsle bruker';
$string['createpasswordifneeded'] = 'Lag passord om nødvendig og send det via e-post';
$string['emailchangecancel'] = 'Avbryt e-postendringen';
$string['emailchangepending'] = 'Venter på endringsbekreftelse. Vennligst klikk på lenken som ble sendt til deg på {$a->preference_newemail}.';
$string['emailnowexists'] = 'E-postadressen du forsøkte å skrive inn tilhører en annen bruker. Endringen av e-postadresse er derfor avbrutt, men du kan prøve igjen med en annen e-postadresse.';
$string['emailupdate'] = 'E-postadresse oppdatering';
$string['emailupdatemessage'] = 'Kjære {$a->fullname},

du må bekrefte at e-postadressen i din profil på {$a->site} er riktig. Vennligst åpne følgende URL i nettleseren din for å bekrefte den.

{$a->url}

Dersom du har noen spørsmål, vennligst kontakt brukerstøtte på: {$a->supportemail}';
$string['emailupdatesuccess'] = 'E-postadressen til brukeren <em>{$a->fullname}</em> er bekreftet endret til <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Bekreftelse av e-postoppdatering på  {$a->site}';
$string['enterthenumbersyouhear'] = 'Skriv inn tallene du hører';
$string['enterthewordsabove'] = 'Skriv inn ordene over';
$string['errormaxconsecutiveidentchars'] = 'Passord må maksimum {$a} fortløpende like tegn.';
$string['errorminpassworddigits'] = 'Passord må ha minst {$a} tall.';
$string['errorminpasswordlength'] = 'Passord må være minst {$a} tegn langt.';
$string['errorminpasswordlower'] = 'Passord må ha minst {$a} små bokstaver.';
$string['errorminpasswordnonalphanum'] = 'Passord må ha minst {$a} ikke-alfanumeriske tegn, slik som  *, -, eller #.';
$string['errorminpasswordupper'] = 'Passord må ha minst {$a} store bokstaver.';
$string['errorpasswordreused'] = 'Dette passordet har blitt brukt før, og er ikke tillatt å gjenbrukes.';
$string['errorpasswordupdate'] = 'Feil ved oppdatering av passord, passordet ble ikke endret.';
$string['eventuserloggedin'] = 'Bruker har logget inn.';
$string['eventuserloggedinas'] = 'Bruker er logget inn som en annen bruker.';
$string['eventuserloginfailed'] = 'Brukerpålogging mislyktes';
$string['forcechangepassword'] = 'Tving passordbytte';
$string['forcechangepasswordfirst_help'] = 'Tving brukere å endre passord ved første pålogging på Moodle.';
$string['forcechangepassword_help'] = 'Tving brukere å endre passord ved neste pålogging på Moodle.';
$string['forgottenpassword'] = 'Hvis du skriver en URL her, vil den bli brukt på mistet passordsiden for siden. Dette er ment når en har passordhåndtering utenom Moodle. La den stå blank for standard passordgjenfinning.';
$string['forgottenpasswordurl'] = 'Glemt passord URL';
$string['getanaudiocaptcha'] = 'Få en hørbar CAPTCHA';
$string['getanimagecaptcha'] = 'Få et bilde CAPTCHA';
$string['getanothercaptcha'] = 'Få en CAPTCHA til';
$string['getrecaptchaapi'] = 'For å bruke re CAPTCHA må du få en API-nøkkel fra <a href=\'https://www.google.com/recaptcha/admin\'>https://www.google.com/recaptcha/admin</a>';
$string['guestloginbutton'] = 'Logg inn-knapp for gjester';
$string['incorrectpleasetryagain'] = 'Feil. Vær vennlig å prøv en gang til.';
$string['infilefield'] = 'Felt trengs i filen';
$string['informminpassworddigits'] = 'minst {$a} tall';
$string['informminpasswordlength'] = 'minst {$a} tegn';
$string['informminpasswordlower'] = 'minst {$a} små bokstaver';
$string['informminpasswordnonalphanum'] = 'minst {$a} spesialtegn,  slik som  *, -, eller #.';
$string['informminpasswordreuselimit'] = 'Passord kan brukes på nytt etter {$a} bytter';
$string['informminpasswordupper'] = 'minst {$a} store bokstaver';
$string['informpasswordpolicy'] = 'Det nye passordet ditt må oppfylle følgende krav; {$a}';
$string['instructions'] = 'Instruksjoner';
$string['internal'] = 'Intern';
$string['limitconcurrentlogins'] = 'Begrens samtidige innlogginger';
$string['limitconcurrentlogins_desc'] = 'Hvis aktivert vil antall samtidige nettleserpålogginger for hver bruker være begrenset. Den eldste økten avsluttes etter å ha nådd grensen, vennligst vær oppmerksom på at brukerne kan miste alt ulagret arbeid . Denne innstillingen er ikke kompatibel med single sign-on påloggingsmoduler (SSO).';
$string['locked'] = 'Låst';
$string['md5'] = 'MD5-kryptering';
$string['nopasswordchange'] = 'Passord kan ikke endres';
$string['nopasswordchangeforced'] = 'Du kan ikke fortsette uten å endre passordet ditt, men det er ingen tilgjengelig side for å endre det. Vær vennlig å kontakt Moodleadministratoren din.';
$string['noprofileedit'] = 'Profilen kan ikke endres';
$string['ntlmsso_attempting'] = 'Forsøker Singel Sign on via NTLM...';
$string['ntlmsso_failed'] = 'Auto-login feilet, prøver vanlig innloggingsside';
$string['ntlmsso_isdisabled'] = 'NTLM SSO er slått av.';
$string['passwordhandling'] = 'Passordfelt behandling';
$string['plaintext'] = 'Ren tekst';
$string['pluginnotenabled'] = 'Autentiseringsplugin \'{$a}\'er ikke slått på.';
$string['pluginnotinstalled'] = 'Autentiseringsplugin \'{$a}\' er ikke installert.';
$string['potentialidps'] = 'Klikk på knappen for å logge inn:';
$string['privacy:metadata:userpref:createpassword'] = 'Indikerer at et passord skal bli generert for brukeren';
$string['privacy:metadata:userpref:forcepasswordchange'] = 'Indikerer om brukeren må endre passord etter innlogging';
$string['privacy:metadata:userpref:loginfailedcount'] = 'Antall ganger brukeren ikke har gklert å logge inn';
$string['privacy:metadata:userpref:loginfailedcountsincesuccess'] = 'Antall mislykkede innloggingsforsøk fra brukeren siden forrige innlogging.';
$string['privacy:metadata:userpref:loginfailedlast'] = 'Datoen for siste mislykkede innloggingsforsøk';
$string['privacy:metadata:userpref:loginlockout'] = 'Indikerer om brukerens konto er låst på gunn av mislykkede innloggingsforsøk og når kontoen ble låst';
$string['privacy:metadata:userpref:loginlockoutignored'] = 'Indikerer at en brukers konto aldri skal låses.';
$string['privacy:metadata:userpref:loginlockoutsecret'] = 'Når låst må brukeren bruke den hemmelige strengen brukes for å låse opp kontoen sin.';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA brukes til å forhindre automatiserte angrep fra roboter. Skriv inn det du ser i figuren, i samme rekkefølge og med et mellomrom.

Hvis du ikke er sikker på hva ordene er, kan du be om en annen CAPTCHA eller en lydfil som sier det du skal skrive.';
$string['security_question'] = 'Sikkerhetsspørmål';
$string['selfregistration'] = 'Selvregistrering';
$string['selfregistration_help'] = 'Dersom f.eks. e-postbasert registrering er valgt, kan nye brukere registrere seg selv og opprette brukerkontoer. Dette KAN resultere i at spammere lager seg brukerkontoer for å poste uønskede foruminnlegg, blogger osv. Er dette et problem bør du vurdere å slå av e-postbasert registrering eller begrense den via innstillingene for tillatte e-postdomener.';
$string['settingmigrationmismatch'] = 'Manglende samsvar på verdier er oppdaget under korrigeringen av navn på innstillinger! Autentiseringsmodulen \'{$a->plugin}\' hadde innstillingen \'{$a->setting}\' satt til \'{$a->legacy}\' under tidligere navn og  \'{$a->current}\'  som gjeldende navn. Den siste verdien er nå satt som gyldig, men du bør likevel sjekke om det ble som forventet.';
$string['sha1'] = 'SHA-1 hash';
$string['showguestlogin'] = 'Du kan skjule eller vise logg inn-knappen for gjester på innloggingssiden.';
$string['stdchangepassword'] = 'Bruk standardside for passordskifte';
$string['stdchangepassword_expl'] = 'Hvis det eksterne autentiseringssystemet tillater passordendringer gjennom Moodle, endre til Ja. Denne innstillingen overstyrer \'Endre Passord URL\'';
$string['stdchangepassword_explldap'] = 'MERK: Det er anbefalt å bruke LDAP gjennom en SSL kryptert tunnel (ldaps://) hvis du har en ekstern LDAP-server.';
$string['suspended'] = 'Deaktivert konto';
$string['suspended_help'] = 'Deaktiverte brukerkontoer kan ikke logge inn eller bruke webservicer, og alle utgående meldinger blir stoppet.';
$string['testsettings'] = 'Test innstillinger';
$string['testsettingsheading'] = 'Test autentiseringsinnstillinger - {$a}';
$string['unlocked'] = 'Ikke låst';
$string['unlockedifempty'] = 'Ikke låst hvis tom';
$string['update_never'] = 'Aldri';
$string['update_oncreate'] = 'Ved oppretting';
$string['update_onlogin'] = 'Ved hver innlogging';
$string['update_onupdate'] = 'Ved oppdatering';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() støtter ikke valgte brukertype: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() støtter ikke valgte brukertype (..ennå)';
$string['username'] = 'Brukernavn';
$string['username_help'] = 'Noen autentiseringsmoduler vil ikke la deg endre brukernavnet';
