<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'ja', branch 'MOODLE_20_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'インストールされます';
$string['action'] = '操作';
$string['actions'] = '操作';
$string['active'] = 'アクティブ';
$string['activeusers'] = 'アクティブユーザ';
$string['activities'] = '活動';
$string['activities_help'] = 'フォーラム、小テストおよびWiki等の活動では相互作用的なコンテンツをコースに追加することができます。';
$string['activity'] = '活動';
$string['activityclipboard'] = 'この活動を移動する: <b>{$a}</b>';
$string['activityiscurrentlyhidden'] = '申し訳ございません、この活動は現在非表示にされています。';
$string['activitymodule'] = '活動モジュール';
$string['activitymodules'] = '活動モジュール';
$string['activityreport'] = '活動レポート';
$string['activityreports'] = '活動レポート';
$string['activityselect'] = '他の場所に移動するため、この活動を選択する';
$string['activitysince'] = '{$a} 以来の活動';
$string['activityweighted'] = 'ユーザごとの活動';
$string['add'] = '追加';
$string['addactivity'] = '活動を追加する ...';
$string['addadmin'] = '管理者を追加する';
$string['addblock'] = 'ブロックを追加する';
$string['addcomment'] = 'コメントを追加する ...';
$string['addcountertousername'] = 'ユーザ名に数字を付加してユーザを作成する';
$string['addcreator'] = 'コース作成者を追加する';
$string['adddots'] = '追加 ...';
$string['added'] = '{$a} が追加されました';
$string['addedrecip'] = '新しい受信者 {$a} 名が追加されました。';
$string['addedrecips'] = '新しい受信者 {$a} 名が追加されました。';
$string['addedtogroup'] = 'グループ「 {$a} 」に追加されました。';
$string['addedtogroupnot'] = 'グループ「 {$a} 」に追加されませんでした。';
$string['addedtogroupnotenrolled'] = 'コースに登録されていないため、グループ「 {$a} 」に追加されませんでした。';
$string['addinganew'] = '新しい {$a} の追加';
$string['addinganewto'] = '新しい {$a->what} を {$a->to} に追加';
$string['addingdatatoexisting'] = '既存のデータに追加';
$string['addnewcategory'] = '新しいカテゴリを追加する';
$string['addnewcourse'] = '新しいコースを追加する';
$string['addnewuser'] = '新しいユーザを追加する';
$string['addnousersrecip'] = 'この {$a} にアクセスしていないユーザを受信者リストに追加する';
$string['addresource'] = 'リソースを追加する ...';
$string['address'] = '住所';
$string['addstudent'] = '学生を追加する';
$string['addsubcategory'] = 'サブカテゴリを追加する';
$string['addteacher'] = '教師を追加する';
$string['admin'] = '管理';
$string['adminhelpaddnewuser'] = '新しいユーザを手動作成します。';
$string['adminhelpassignadmins'] = '管理者はサイト内ですべての作業および移動することができます。';
$string['adminhelpassigncreators'] = 'コース作成者は新しいコースを作成することができます。';
$string['adminhelpassignsiteroles'] = '定義したサイトロールを特定のユーザに適用します。';
$string['adminhelpassignstudents'] = 'コースに入って管理メニューより学生を追加します。';
$string['adminhelpauthentication'] = 'あなたは内部ユーザアカウントまたは外部データベースを使用することができます。';
$string['adminhelpbackup'] = '自動バックアップおよびスケジュールを設定します。';
$string['adminhelpconfiguration'] = 'サイトのデザインおよび動作に関して設定します。';
$string['adminhelpconfigvariables'] = 'サイト全般の運用に関する変数を設定します。';
$string['adminhelpcourses'] = 'コース・カテゴリの設定およびユーザの割り当て、承認審査中コースを編集します。';
$string['adminhelpeditorsettings'] = 'HTMLエディタの基本的設定を定義します。';
$string['adminhelpedituser'] = 'ユーザアカウントリストを表示および編集します。';
$string['adminhelpenvironment'] = 'あなたのサーバが現在および将来のインストールのシステム要件に適合しているかチェックします。';
$string['adminhelpfailurelogs'] = 'ログイン失敗のログを表示する';
$string['adminhelphealthcenter'] = 'サイトに関する問題の自動検出';
$string['adminhelplanguage'] = '現在の言語パックを確認および編集します。';
$string['adminhelplogs'] = 'サイトの活動すべてに関するログを表示します。';
$string['adminhelpmanageblocks'] = 'インストール済みブロックを管理および設定します。';
$string['adminhelpmanagedatabase'] = 'データベースに直接アクセスする (注意してください!)';
$string['adminhelpmanagefilters'] = 'テキストフィルタを選択および関連設定します。';
$string['adminhelpmanagemodules'] = 'インストール済モジュールおよびその設定を管理します。';
$string['adminhelpmanageroles'] = 'ユーザに適用するロールを作成および定義します。';
$string['adminhelpmymoodle'] = 'ユーザのマイMoodleブロックを設定します。';
$string['adminhelpreports'] = 'サイトレベルのレポートを表示します。';
$string['adminhelpsitefiles'] = '一般的なファイルの公開または外部バックアップファイルをアップロードします。';
$string['adminhelpsitesettings'] = 'フロントページのデザインを設定します。';
$string['adminhelpstickyblocks'] = 'Moodle全体のスティッキーブロックを設定します。';
$string['adminhelpthemes'] = 'サイトのデザイン (色、フォント等) を選択します。';
$string['adminhelpuploadusers'] = 'テキストファイルから新しいユーザをインポートします。';
$string['adminhelpusers'] = 'ユーザの定義および認証を設定します。';
$string['adminhelpxmldbeditor'] = 'XMLDBファイルを編集するためのインターフェースです。開発者のみ利用できます。';
$string['administration'] = '管理';
$string['administrationsite'] = 'サイト管理';
$string['administrator'] = '管理者';
$string['administratordescription'] = '通常、管理者はサイト内のすべてのコースでどのような作業でも実施できます。';
$string['administrators'] = '管理者';
$string['administratorsall'] = 'すべての管理者';
$string['administratorsandteachers'] = '管理者および教師';
$string['advanced'] = '高度';
$string['advancedfilter'] = '検索オプション';
$string['advancedsettings'] = '高度な設定';
$string['again'] = 'もう一度';
$string['aimid'] = 'AIM ID';
$string['ajaxno'] = 'いいえ: 基本的なウェブ機能を使用します';
$string['ajaxuse'] = 'AJAXおよびJavascript';
$string['ajaxyes'] = 'はい: 高度なウェブ機能を使用します';
$string['all'] = 'すべて';
$string['allactions'] = 'すべての行動';
$string['allactivities'] = 'すべての活動';
$string['allchanges'] = 'すべての変更';
$string['alldays'] = 'すべての日付';
$string['allfieldsrequired'] = 'すべての項目に入力してください。';
$string['allfiles'] = 'すべてのファイル';
$string['allgroups'] = 'すべてのグループ';
$string['alllogs'] = 'すべてのログ';
$string['allmods'] = 'すべての {$a}';
$string['allow'] = '許可する';
$string['allowinternal'] = '内部登録も許可する';
$string['allownone'] = 'どれも許可しない';
$string['allownot'] = '許可しない';
$string['allparticipants'] = 'すべての参加者';
$string['allteachers'] = 'すべての教師';
$string['alphanumerical'] = '半角英数字、ハイフン (-)、ピリオド (.) のみ含むことができます。';
$string['alreadyconfirmed'] = 'ユーザ登録はすでに承認されています。';
$string['always'] = '常に';
$string['and'] = '{$a->one} および {$a->two}';
$string['answer'] = '回答';
$string['any'] = 'すべて';
$string['approve'] = '承認';
$string['areyousuretorestorethis'] = '本当に続けてもよろしいですか?';
$string['areyousuretorestorethisinfo'] = '後ほどこのバックアップを既存のコースに追加するか、完全に新しいコースを作成するか選択します。';
$string['asc'] = '昇順';
$string['assessment'] = '評価';
$string['assignadmins'] = '管理者を割り当てる';
$string['assigncreators'] = 'コース作成者を割り当てる';
$string['assignsiteroles'] = 'サイト全体のロールを割り当てる';
$string['authenticateduser'] = '認証済みユーザ';
$string['authenticateduserdescription'] = 'すべてのログインしたユーザです。';
$string['authentication'] = '認証オプション';
$string['authenticationplugins'] = '認証プラグイン';
$string['autosubscribe'] = 'フォーラム自動メール購読';
$string['autosubscribeno'] = 'いいえ: フォーラムをメール購読しません';
$string['autosubscribeyes'] = 'はい: 投稿した場合、フォーラムをメール購読します';
$string['availability'] = 'コース利用';
$string['availability_help'] = 'この設定ではコース一覧にコースを表示するかどうか決定します。教師および管理者以外、ユーザはコースへ入ることを許可されません。';
$string['availablecourses'] = 'コース一覧';
$string['back'] = '戻る';
$string['backto'] = '{$a} に戻る';
$string['backtocourselisting'] = 'コース一覧に戻る';
$string['backtopageyouwereon'] = '元のページに戻る';
$string['backtoparticipants'] = '参加者リストに戻る';
$string['backup'] = 'バックアップ';
$string['backupactivehelp'] = '自動バックアップを実行するかどうか選択してください。';
$string['backupcancelled'] = 'バックアップが中止されました。';
$string['backupcoursefileshelp'] = 'このオプションを有効にした場合、自動バックアップにコースファイルが含まれます。';
$string['backupdate'] = 'バックアップ日付';
$string['backupdatenew'] = '現在の {$a->TAG} は {$a->weekday}, {$a->mday} {$a->month} {$a->year} です。<br />';
$string['backupdateold'] = '{$a->TAG} は {$a->weekday}, {$a->mday} {$a->month} {$a->year} でした。';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'バックアップ詳細';
$string['backupexecuteathelp'] = '何時に自動バックアップを実行するか選択してください。';
$string['backupfailed'] = 'いくつかのコースが保存されませんでした!!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'バックアップが正常に完了しました。';
$string['backupfromthissite'] = 'バックアップはこのサイトで作成されましたか?';
$string['backupgradebookhistoryhelp'] = 'このオプションを有効にした場合、自動バックアップに評定履歴が含まれます。この機能を動作させるためには、サーバ設定において評定履歴を無効 (disablegradehistory) にしてはいけないことに留意してください。';
$string['backupincludemoduleshelp'] = '自動バックアップにおいて、コースモジュールにユーザデータを含むかどうか、選択してください。';
$string['backupincludemoduleuserdatahelp'] = 'モジュールユーザデータを自動バックアップに含むかどうか、選択してください。';
$string['backupkeephelp'] = 'コースの直近バックアップをいくつ保存しますか? (古いものから自動的に削除されます。)';
$string['backuplogdetailed'] = '詳細実行ログ';
$string['backuploglaststatus'] = '最新実行ログ';
$string['backupmissinguserinfoperms'] = '注意: このバックアップには、ユーザデータが含まれていません。また、このタイプのバックアップに互換性がないため、エクササイズおよびワークショップはバックアップに含まれません。';
$string['backupnext'] = '次のバックアップ';
$string['backupnonisowarning'] = '警告: このバックアップは、非ユニコードバージョンのMoodle (1.6以前) によって作成されたものです。このバックアップに非ISO-8859-1テキストが含まれている場合、ユニコードバージョンのMoodleにリストアすると文字化けが発生する可能性があります。このバックアップを正常にするための詳細情報は、<a href="http://docs.moodle.org/ja/バックアップFAQ">バックアップFAQ</a>をご覧ください。';
$string['backuporiginalname'] = 'バックアップ名';
$string['backuproleassignments'] = 'これらのロールに対するロール割り当てをバックアップする';
$string['backupsavetohelp'] = 'バックアップファイルの保存先ディレクトリをフルパスで入力してください。<br />(コースのデフォルトディレクトリに保存する場合は空白)';
$string['backupsitefileshelp'] = 'このオプションを有効にした場合、コースで使用されているサイトファイルが自動バックアップに含まれます。';
$string['backuptakealook'] = '次のバックアップログをご覧ください: {$a}';
$string['backupuserfileshelp'] = '自動バックアップにユーザファイル (例 プロファイルイメージ) を含むかどうか、選択してください。';
$string['backupversion'] = 'バックアップバージョン';
$string['block'] = 'ブロック';
$string['blockconfiga'] = '{$a} ブロックの設定';
$string['blockconfigbad'] = 'このブロックは正常に組み込まれていないため、設定インターフェースを表示することができません。';
$string['blockdeleteconfirm'] = 'あなたは「 {$a} 」ブロックを完全に削除しようとしています。これにより、このブロックに関連するデータベース内すべてのデータが完全削除されます。本当に続けてもよろしいですか?';
$string['blockdeletefiles'] = '「 {$a->block} 」に関連するすべてのデータがデータベースより削除されました。削除を完了するため (ブロックが再インストールされることを防ぐため) に次のディレクトリをサーバより削除してください: {$a->directory}';
$string['blocks'] = 'ブロック';
$string['blocksaddedit'] = 'ブロックを追加/編集する';
$string['blockseditoff'] = 'ブロック編集の終了';
$string['blocksediton'] = 'ブロック編集の開始';
$string['blocksetup'] = 'ブロックテーブル設定中';
$string['blocksuccess'] = '{$a} テーブルが正常に設定されました。';
$string['brief'] = '概要';
$string['bycourseorder'] = 'コース順';
$string['byname'] = 'by {$a}';
$string['bypassed'] = 'バイパス';
$string['cachecontrols'] = 'キャッシュコントロール';
$string['cancel'] = 'キャンセル';
$string['cancelled'] = 'キャンセルされました。';
$string['categories'] = 'コースカテゴリ';
$string['category'] = 'カテゴリ';
$string['categoryadded'] = 'カテゴリ「 {$a} 」 が追加されました。';
$string['categorycontents'] = 'サブカテゴリおよびコース';
$string['categorycurrentcontents'] = '{$a} のコンテンツ';
$string['categorydeleted'] = 'カテゴリ「 {$a} 」 が削除されました。';
$string['categoryduplicate'] = '「{$a}」はすでに登録されています!';
$string['category_help'] = 'この設定ではコース一覧内のコースが表示されるカテゴリを決定します。';
$string['categorymodifiedcancel'] = 'カテゴリが変更されました! キャンセルの後、もう一度お試しください。';
$string['categoryname'] = 'カテゴリ名';
$string['categoryupdated'] = 'カテゴリ「 {$a} 」が更新されました。';
$string['changedpassword'] = 'パスワードを変更しました。';
$string['changepassword'] = 'パスワードを変更する';
$string['changessaved'] = '変更内容が保存されました。';
$string['check'] = 'チェック';
$string['checkall'] = 'すべてをチェック';
$string['checkingbackup'] = 'バックアップの確認中';
$string['checkingcourse'] = 'コースの確認中';
$string['checkingforbbexport'] = 'BlackBoardエクスポートの確認中';
$string['checkinginstances'] = 'インスタンスの確認中';
$string['checkingsections'] = 'セクションの確認中';
$string['checklanguage'] = '言語の確認';
$string['checknone'] = 'チェックなし';
$string['childcoursenotfound'] = '子コースが見つかりませんでした!';
$string['childcourses'] = '子コース';
$string['choose'] = '選択';
$string['choosecourse'] = 'コースを選択してください。';
$string['choosedots'] = '選択 ...';
$string['chooselivelogs'] = 'または現在の活動を表示する';
$string['chooselogs'] = '閲覧したいログを選択してください';
$string['choosereportfilter'] = 'レポートのフィルタを選択してください。';
$string['choosetheme'] = 'テーマの選択';
$string['chooseuser'] = 'ユーザを選択してください。';
$string['city'] = '都道府県';
$string['clambroken'] = '管理者がアップロードファイルに対するウイルスチェックを有効にしていますが、設定が正しくありません。<br />あなたのファイルは正常にアップロードされませんでした。管理者宛に対応するよう、メールが送信されました。<br />おそらく、後で再度アップロードすることができるようになります。';
$string['clamdeletedfile'] = 'ファイルが削除されました。';
$string['clamdeletedfilefailed'] = 'ファイルが削除されませんでした。';
$string['clamemailsubject'] = '{$a} :: ClamAV通知';
$string['clamfailed'] = 'ClamAVの起動が失敗しました。 エラーメッセージは {$a} です。Clamからの出力結果は次のとおりです:';
$string['clamlost'] = 'Moodleはファイルアップロード時にclamが動作するよう設定されていますが、ClamAVのパス {$a} が正しくありません。';
$string['clamlostandactinglikevirus'] = '加えて、MoodleはClamが動作失敗したときに、ファイルをウイルスとして扱うように設定されています。あなたが修正するまで、原則的に学生はファイルをアップロードできないことを意味します。';
$string['clammovedfile'] = 'ファイルはあなたが指定した隔離用ディレクトリに移動されました。新しい保存場所は {$a} です。';
$string['clammovedfilebasic'] = 'ファイルが隔離用ディレクトリに移動されました。';
$string['clamquarantinedirfailed'] = 'あなたが指定した隔離用ディレクトリ {$a} にファイルを移動できませんでした。ファイルが感染していることが分かった場合、感染したファイルが削除されるため、そのファイルを回復してください。';
$string['clamunknownerror'] = 'Calmに不明なエラーが発生しました。';
$string['cleaningtempdata'] = '一時データの消去';
$string['clear'] = 'クリア';
$string['clickhelpiconformoreinfo'] = '... 続ける ... 詳細記事を閲覧するには、ヘルプアイコンをクリックしてください。';
$string['clickhere'] = 'ここをクリック ...';
$string['clicktochange'] = '変更するには、ここをクリックしてください。';
$string['clicktohideshow'] = '展開または折りたたむには、ここをクリックしてください。';
$string['closewindow'] = 'ウィンドウを閉じる';
$string['collapseall'] = 'すべてを折りたたむ';
$string['commentincontext'] = 'このコメントをコンテクスト内で探す';
$string['comments'] = 'コメント';
$string['commentsnotenabled'] = 'コメント機能は有効にされていません。';
$string['commentsrequirelogin'] = 'コメントを閲覧するには、あなたはログインする必要があります。';
$string['comparelanguage'] = '現在の言語の比較・編集';
$string['complete'] = '詳細';
$string['completereport'] = '詳細レポート';
$string['configuration'] = '設定';
$string['confirm'] = '確認';
$string['confirmcheckfull'] = '本当に {$a} を承認してもよろしいですか?';
$string['confirmed'] = 'あなたの登録が完了しました。';
$string['confirmednot'] = 'あなたの登録はまだ完了していません！';
$string['content'] = 'コンテンツ';
$string['continue'] = '続ける';
$string['continuetocourse'] = 'あなたのコースに入るには、ここをクリックしてください';
$string['convertingwikitomarkdown'] = 'WikiをMarkdownに変換';
$string['cookiesenabled'] = 'ブラウザのクッキー設定を有効にしてください。';
$string['cookiesenabled_help'] = 'このサイトでは2種類のクッキーが使用されます:

重要なクッキーはセッションクッキーで、通常<b>MoodleSession<・b>と呼ばれます。継続的にログインして各ページに移動するため、ブラウザをクッキー利用可にしてください。 ログアウトまたはブラウザを閉じた場合、(ブラウザおよびサーバの) クッキーは破棄されます。

もう1つのクッキーは、純粋に便宜的な理由で使用され、通常<b>MOODLEID</b>と呼ばれます。このクッキーは、あなたのユーザ名をブラウザに覚えさせるために使用されます。これは、あなたがサイトへ戻ったときに、ログインページにユーザ名が初めから入力されていることを意味します。このクッキーを拒否しても大丈夫です - しかし、ログイン時にあなたのユーザ名を毎回入力する必要があります。';
$string['cookiesnotenabled'] = '残念ですが、あなたのブラウザーではクッキーの設定が有効にされていません。';
$string['copy'] = 'コピー';
$string['copyasnoun'] = 'コピー';
$string['copyingcoursefiles'] = 'コースファイルのコピー';
$string['copyingsitefiles'] = 'コースで使用されているサイトファイルのコピー';
$string['copyinguserfiles'] = 'ユーザファイルの複写';
$string['copyingzipfile'] = 'ZIPファイルのコピー';
$string['copyrightnotice'] = '著作権表示';
$string['coresystem'] = 'システム';
$string['cost'] = '費用';
$string['costdefault'] = 'デフォルト費用';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = '国';
$string['course'] = 'コース';
$string['courseadministration'] = 'コース管理';
$string['courseapprovedemail'] = 'あなたのリクエストしたコース「 {$a->name} 」が承認され、{$a->teacher} が作成されました。新しいコースにアクセスするには、{$a->url} へ移動してください。';
$string['courseapprovedemail2'] = 'あなたのリクエストしたコース「 {$a->name} 」が承認されました。新しいコースにアクセスするには、{$a->url} へ移動してください。';
$string['courseapprovedfailed'] = 'コースを承認済みとして保存できませんでした!';
$string['courseapprovedsubject'] = 'あなたのコースは承認されました!';
$string['courseavailable'] = '学生はこのコースを利用できる';
$string['courseavailablenot'] = '学生はこのコースを利用できない';
$string['coursebackup'] = 'コースバックアップ';
$string['coursecategories'] = 'コースカテゴリ';
$string['coursecategory'] = 'コースカテゴリ';
$string['coursecategorydeleted'] = 'コースカテゴリ {$a} を削除しました。';
$string['coursecompletion'] = 'コース完了';
$string['coursecompletions'] = 'コース完了';
$string['coursecreators'] = 'コース作成者';
$string['coursecreatorsdescription'] = 'コース作成者は新しいコースを作成することができます。';
$string['coursedeleted'] = 'コース {$a} を削除しました。';
$string['coursefiles'] = 'レガシーコースファイル';
$string['coursefilesedit'] = 'レガシーコースファイルを編集する';
$string['coursefileswarning'] = 'コースファイルは廃止されました。';
$string['coursefileswarning_help'] = 'コースファイルはMoodle 2.0より廃止されます。、代わりに、可能な限り外部リポジトリを使用してください。';
$string['courseformatdata'] = 'コースフォーマットデータ';
$string['courseformats'] = 'コースフォーマット';
$string['coursegrades'] = 'コース評定';
$string['coursehelpcategory'] = 'コース一覧上にコースを配置することで、学生が探しやすくします。';
$string['coursehelpforce'] = 'コース内のすべての活動でグループモードを強制します。';
$string['coursehelpformat'] = 'このフォーマットでコースメインページが表示されます。';
$string['coursehelphiddensections'] = 'コース内の非表示セクションを学生に対して、どのように表示するか設定します。';
$string['coursehelpmaximumupload'] = 'このコースで学生がアップロードできる最大サイズを定義します。サイト全体の設定に制限されます。';
$string['coursehelpnewsitemsnumber'] = 'コースホームページに表示する最新ニュースアイテム数です。ニュースボックスは、右側に表示されます <br />ゼロは、ニュースボックスが表示されないことを意味します)。';
$string['coursehelpnumberweeks'] = 'コースメインページに表示される週/トピックの数です。';
$string['coursehelpshowgrades'] = '評定表の表示を有効にします。個々の活動に関する評定表の表示を抑制するものではありません。';
$string['coursehidden'] = '現在、学生はこのコースを利用できません。';
$string['courseinfo'] = 'コース情報';
$string['courselegacyfiles'] = 'レガシーコースファイル';
$string['courselegacyfiles_help'] = 'コースファイルエリアはMoodle 1.9およびそれ以前のバージョンのために下位互換性を確保します。このファイルエリアのファイルすべてには (あなたがリンクするかどうかに関わらず) コース参加者すべてがアクセスすることができます。また、これらのファイルがMoodle内のどこで使用されているか知る手段がありません。

あなたがこのファイルエリアをコースファイルの保存に使用する場合、多くのプライバシーおよびセキュリティ問題に自分をさらすことになります。同時にバックアップおよびコースインポートのファイル喪失、常にコンテンツが共有および再利用されることを経験することになります。そのため、あなたが何をしているのか本当に理解している場合以外、このエリアの使用はお勧めできません。

以下のリンクではこの内容に関する詳細情報およびMoodle 2におけるファイル管理のいくつかの改善策をご覧いただけます。';
$string['coursemessage'] = 'コースユーザにメッセージを送信する';
$string['coursenotaccessible'] = 'このコースはパブリックアクセスを許可していません。';
$string['courseoverview'] = 'コース概要';
$string['courseoverviewgraph'] = 'コース概要グラフ';
$string['courseprofiles'] = 'コースプロファイル';
$string['coursereasonforrejecting'] = 'あなたがこのリクエストを拒否する理由';
$string['coursereasonforrejectingemail'] = 'これは申請者にメール送信されます。';
$string['coursereject'] = 'コースリクエストを拒否する';
$string['courserejected'] = 'コースは拒否され、申請者に通知メールが送信されました。';
$string['courserejectemail'] = '申し訳ございません、あなたがリクエストしたコースは拒否されました。拒否理由は下記のとおりです:

{$a}';
$string['courserejectreason'] = 'あなたがこのコースを拒否する理由の概要<br />(この内容は申請者にメール送信されます)';
$string['courserejectsubject'] = 'あなたのコースは拒否されました。';
$string['coursereport'] = 'コースレポート';
$string['coursereports'] = 'コースレポート';
$string['courserequest'] = 'コースリクエスト';
$string['courserequestdetails'] = 'あなたがリクエストするコースの詳細';
$string['courserequestfailed'] = '何らかの理由で、あなたのコースリクエストを保存できませんでした。';
$string['courserequestintro'] = 'あなたのコース作成をリクエストをするには、このフォームを利用してください。<br />コース開設の理由を管理者が理解し、承認するために必要な情報を可能な限りく<br />多入力してください。';
$string['courserequestreason'] = 'このコースを開設したい理由';
$string['courserequestsuccess'] = 'あなたのコースリクエストが正常に保存されました。数日以内に審査結果に関するメールが送信される予定です。';
$string['courserequestsupport'] = '管理者がこのリクエストを判断するための支援情報';
$string['courserestore'] = 'コースリストア';
$string['courses'] = 'コース';
$string['coursesectionsummaries'] = 'コースセクション要約';
$string['coursesettings'] = 'コースデフォルト設定';
$string['coursesmovedout'] = '{$a} からコースを移動しました。';
$string['coursespending'] = '承認審査中コース';
$string['coursestart'] = 'コース開始日';
$string['coursesummary'] = 'コース概要';
$string['coursesummary_help'] = 'コース概要はコース一覧に表示されます。コース検索ではコース名に加えてコース概要も検索対象とします。';
$string['courseupdates'] = 'コース更新内容';
$string['courseuploadlimit'] = 'コースアップロード制限';
$string['create'] = '作成';
$string['createaccount'] = '私の新しいアカウントを作成する';
$string['createcategory'] = 'カテゴリを作成する';
$string['createfolder'] = '{$a} にフォルダを作成する';
$string['createuserandpass'] = 'あなたのユーザ名 およびパスワードを入力してください。';
$string['createziparchive'] = 'ZIP書庫を作成する';
$string['creatingblocks'] = 'ブロックの作成';
$string['creatingblocksroles'] = 'ブロックレベルロール割り当ておよびオーバーライドの作成';
$string['creatingblogsinfo'] = 'ブログ情報の作成';
$string['creatingcategoriesandquestions'] = 'カテゴリおよび問題の作成';
$string['creatingcoursemodules'] = 'コースモジュールの作成';
$string['creatingcourseroles'] = 'コースレベルロール割り当ておよびオーバーライドの作成';
$string['creatingevents'] = 'イベントの作成';
$string['creatinggradebook'] = '評定表の作成';
$string['creatinggroupings'] = 'グルーピングの作成';
$string['creatinggroupingsgroups'] = 'グループのグルーピングへの追加';
$string['creatinggroups'] = 'グループの作成';
$string['creatinglogentries'] = 'ログエントリの作成';
$string['creatingmessagesinfo'] = 'メッセージ情報の作成';
$string['creatingmodroles'] = 'モジュールレベルのロール割り当ておよびオーバーライドの作成';
$string['creatingnewcourse'] = '新しいコースの作成';
$string['creatingrolesdefinitions'] = 'ロール定義の作成';
$string['creatingscales'] = '評価尺度の作成';
$string['creatingsections'] = 'セクションの作成';
$string['creatingtemporarystructures'] = '一時構造の作成';
$string['creatinguserroles'] = 'ユーザレベルロール割り当ておよびオーバーライドの作成';
$string['creatingusers'] = 'ユーザの作成';
$string['creatingxmlfile'] = 'XMLファイルの作成';
$string['currency'] = '通貨';
$string['currentcourseadding'] = '現在のコース、データを追加する';
$string['currentcoursedeleting'] = '現在のコース、最初に削除する';
$string['currentlanguage'] = '現在の言語';
$string['currentlocaltime'] = 'あなたの現在のローカルタイム';
$string['currentlyselectedusers'] = '現在の選択済みユーザ';
$string['currentpicture'] = '現在の画像';
$string['currentrelease'] = '現在のリリース情報';
$string['currentversion'] = '現在のバージョン';
$string['databasechecking'] = 'Moodleデータベースをバージョン {$a->oldversion} より {$a->newversion} へアップグレードしています ...';
$string['databaseperformance'] = 'データベースパフォーマンス';
$string['databasesetup'] = 'データベース設定中';
$string['databasesuccess'] = 'データベースが正常にアップグレードされました。';
$string['databaseupgradebackups'] = '現在のバックアップバージョンは {$a} です。';
$string['databaseupgradeblocks'] = '現在のブロックバージョンは {$a} です。';
$string['databaseupgradegroups'] = '現在のグループバージョンは {$a} です。';
$string['databaseupgradelocal'] = '現在のローカルデータベースのカスタマイズバージョンは {$a} です。';
$string['databaseupgrades'] = 'データベースのアップグレード';
$string['date'] = '日付';
$string['datechanged'] = '開講日変更';
$string['datemostrecentfirst'] = '日付 - 新しいものを最初に';
$string['datemostrecentlast'] = '日付 - 新しいものを最後に';
$string['day'] = '日';
$string['days'] = '日';
$string['decodinginternallinks'] = '内部リンクのデコード';
$string['default'] = 'デフォルト';
$string['defaultcoursestudent'] = '学生';
$string['defaultcoursestudentdescription'] = '通常、学生にはコース内でより少ない権限が割り当てられます。';
$string['defaultcoursestudents'] = '学生';
$string['defaultcoursesummary'] = 'このコースに関する簡潔で興味深い説明文をここに入力してください。';
$string['defaultcourseteacher'] = '教師';
$string['defaultcourseteacherdescription'] = '教師はコース内での活動変更および学生評定を含むどのような作業でも実施することができます。';
$string['defaultcourseteachers'] = '教師';
$string['delete'] = '削除';
$string['deleteablock'] = 'ブロックを削除する';
$string['deleteall'] = 'すべてを削除する';
$string['deleteallcannotundo'] = 'すべてを削除する - 元に戻すことはできません。';
$string['deleteallcomments'] = 'すべてのコメントを削除する';
$string['deleteallratings'] = 'すべての評価を削除する';
$string['deletecategory'] = 'カテゴリを削除する: {$a}';
$string['deletecategorycheck'] = '本当にこのカテゴリ<b>「 {$a} 」</b>を完全に削除してもよろしいですか? 親カテゴリがある場合、このカテゴリ内すべてのコースが親カテゴリに移動されます。親カテゴリがない場合、その他のカテゴリに移動されます。';
$string['deletecategorycheck2'] = 'このカテゴリを削除した場合、あなたはカテゴリが含むコースおよびサブカテゴリをどのようにするか選択する必要があります。';
$string['deletecategoryempty'] = 'このカテゴリは空です。';
$string['deletecheck'] = '{$a} を削除してもよろしいですか?';
$string['deletecheckfiles'] = '本当にこれらのファイルを削除してもよろしいですか?';
$string['deletecheckfull'] = '本当に {$a} を完全に削除してもよろしいですか?';
$string['deletecheckwarning'] = 'あなたはこれらのファイルを削除しようとしています';
$string['deletecomment'] = 'このコメントを削除する';
$string['deletecompletely'] = '完全に削除する';
$string['deletecourse'] = 'コースを削除する';
$string['deletecoursecheck'] = '本当にこのコースおよびコース内データすべてを完全に削除してもよろしいですか?';
$string['deleted'] = '削除完了';
$string['deletedactivity'] = '{$a} を削除しました。';
$string['deletedcourse'] = '{$a} が完全に削除されました。';
$string['deletednot'] = '{$a} を削除できませんでした!';
$string['deletelogs'] = 'ログを削除する';
$string['deleteselected'] = '選択したものを削除する';
$string['deleteselectedkey'] = '選択されたキーを削除する';
$string['deletingcourse'] = '{$a} の削除';
$string['deletingexistingcoursedata'] = '既存のコースデータの削除';
$string['deletingolddata'] = '古いデータの削除';
$string['department'] = '部署';
$string['desc'] = '降順';
$string['description'] = '説明';
$string['deselectall'] = 'すべての選択を解除する';
$string['detailedless'] = '一覧表示';
$string['detailedmore'] = '詳細表示';
$string['directory'] = 'ディレクトリ';
$string['disable'] = 'No';
$string['disabledcomments'] = 'コメントは無効にされています。';
$string['displayingfirst'] = '最初の {$a->count} {$a->things} のみ表示されます。';
$string['displayingrecords'] = 'レコード {$a} 件を表示';
$string['displayingusers'] = 'ユーザを {$a->start} から {$a->end} まで表示';
$string['displayonpage'] = 'ページに表示する';
$string['documentation'] = 'Moodleドキュメンテーション';
$string['down'] = '下へ';
$string['download'] = 'ダウンロード';
$string['downloadall'] = 'すべてをダウンロードする';
$string['downloadexcel'] = 'Excelフォーマットでダウンロードする';
$string['downloadfile'] = 'ファイルをダウンロードする';
$string['downloadods'] = 'ODSフォーマットでダウンロードする';
$string['downloadtext'] = 'テキストフォーマットでダウンロードする';
$string['doyouagree'] = 'これらの要件を読んで理解できましたか?';
$string['duplicate'] = '複製';
$string['duplicatinga'] = '複製: {$a}';
$string['duplicatingain'] = '{$a->in} の {$a->what} を複製';
$string['edhelpaspellpath'] = 'エディタでスペルチェックを利用するには <strong>aspell 0.50</strong> またはそれ以上をサーバにインストールしてください。また、aspellバイナリの正しいパスを指定する必要があります。通常このパスはUnix/Linux システムで<strong>/usr/bin/aspell</strong>となりますが、他のパスになる場合もあります。';
$string['edhelpbgcolor'] = '編集領域の背景色を設定します。<br />有効な設定値の例: #FFFFFF または white';
$string['edhelpcleanword'] = 'ここではWord特有のフォーマットをフィルタするかどうか設定します。';
$string['edhelpenablespelling'] = 'ここではスペルチェックするかどうか設定します。有効にする場合、サーバに<strong>aspell</strong>をインストールする必要があります。2番目の設定値は<strong>デフォルト辞書</strong>です。aspellがユーザ言語の辞書を持っていない場合、この設定値が使用されます。';
$string['edhelpfontfamily'] = 'フォントファミリー属性はフォントファミリーの一覧および一般的なフォントファミリー名です。フォントファミリー名はカンマで区切ってください。';
$string['edhelpfontlist'] = 'エディタのドロップダウンメニューで使用されるフォントを設定します。';
$string['edhelpfontsize'] = 'ここではデフォルトのフォントサイズを設定します。<br />有効な設定値の例: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = '編集';
$string['edita'] = '{$a} を編集する';
$string['editcategorysettings'] = 'カテゴリ設定を編集する';
$string['editcategorythis'] = 'このカテゴリを編集する';
$string['editcoursesettings'] = 'コース設定を編集する';
$string['editfiles'] = 'ファイルを編集する';
$string['editgroupprofile'] = 'グループプロファイルを編集する';
$string['editinga'] = '{$a} の編集';
$string['editingteachershort'] = 'コース編集者';
$string['editlock'] = 'この値は編集できません!';
$string['editmyprofile'] = 'プロファイルを編集する';
$string['editorbgcolor'] = '背景色';
$string['editorcleanonpaste'] = 'ペースト時にWord HTMLを消去する';
$string['editorcommonsettings'] = '共通設定';
$string['editordefaultfont'] = 'デフォルトフォント';
$string['editorenablespelling'] = 'スペルチェックを有効にする';
$string['editorfontlist'] = 'フォントリスト';
$string['editorfontsize'] = 'デフォルトフォントサイズ';
$string['editorresettodefaults'] = 'デフォルト値にリセットする';
$string['editorsettings'] = 'エディタ設定';
$string['editorshortcutkeys'] = 'エディタショートカットキー';
$string['editsettings'] = '設定を編集する';
$string['editsummary'] = '要約を編集する';
$string['editthisactivity'] = 'この活動を編集する';
$string['editthiscategory'] = 'このカテゴリを編集する';
$string['edituser'] = 'ユーザアカウントを編集する';
$string['email'] = 'メールアドレス';
$string['emailactive'] = 'メール有効化';
$string['emailagain'] = 'メールアドレス (もう一度)';
$string['emailcharset'] = 'メール文字コード';
$string['emailconfirm'] = 'アカウントの確定';
$string['emailconfirmation'] = 'こんにちは {$a->firstname} さん

「 {$a->sitename} 」であなたのメールアドレスによる新しいアカウントの作成が依頼されました。

あなたの新しいアカウントを確定するには、下記のウェブアドレスにアクセスしてください:

{$a->link}

ほとんどのメールプログラムでは、上記部分はクリックできるよう青色にリンク表示されています。

動作しない場合は、コピー&ペーストを使ってウェブブラウザ上部のアドレス欄に、このアドレスを入力してください。

お分かりにならない場合は、サイト管理者 {$a->admin} にご連絡ください。';
$string['emailconfirmationsubject'] = '{$a}: アカウントの確定';
$string['emailconfirmsent'] = '<p>メールが <b>{$a}</b> 宛に送信されました。
<p>メールには、簡単に登録を確定するための説明が記載されています。
<p>お分かりにならない場合は、サイト管理者にご連絡ください。';
$string['emaildigest'] = 'メール要約タイプ';
$string['emaildigestcomplete'] = '全部 (すべての投稿を毎日メール)';
$string['emaildigestoff'] = '要約なし (フォーラムの投稿ごとにメール)';
$string['emaildigestsubjects'] = '題名 (題名のみを毎日メール)';
$string['emaildisable'] = 'このメールアドレスは無効です';
$string['emaildisableclick'] = 'このメールアドレス宛にすべてのメールが送信されないようにする';
$string['emaildisplay'] = 'メールアドレス公開';
$string['emaildisplaycourse'] = '同じコースのメンバーにだけ私のメールアドレスを公開します';
$string['emaildisplayhidden'] = 'Eメール非表示';
$string['emaildisplayno'] = 'すべてのユーザから私のメールアドレスを隠します';
$string['emaildisplayyes'] = 'すべてのユーザに私のメールアドレスを公開します';
$string['emailenable'] = 'このメールアドレスは有効です';
$string['emailenableclick'] = 'このメールアドレスにメールすべてが再度送信されるようにする';
$string['emailexists'] = 'このメールアドレスはすでに使用されています。';
$string['emailformat'] = 'メールフォーマット';
$string['emailmustbereal'] = '注意：メールアドレスは実際に使えるアドレスを入力してください。';
$string['emailnotallowed'] = 'これらのドメインのメールアドレスは許可されていません ({$a})';
$string['emailnotfound'] = 'データベース内にメールアドレスが見つかりませんでした。';
$string['emailonlyallowed'] = 'このメールアドレスは許可されている次のドメインに入っていません ({$a})';
$string['emailpasswordchangeinfo'] = 'こんにちは {$a->firstname} さん

誰か (おそらくあなた) が、「 {$a->sitename} 」 のアカウントで新しいパスワードを請求しました。

あなたのパスワードを変更するには、下記のウェブアドレスにアクセスしてください:

{$a->link}

ほとんどのメールプログラムでは、上記部分はクリックできるよう青色にリンク表示されています。

動作しない場合は、コピー&ペーストを使ってウェブブラウザ上部のアドレス欄に、このアドレスを入力してください。

お分かりにならない場合は、サイト管理者 {$a->admin} にご連絡ください。';
$string['emailpasswordchangeinfodisabled'] = 'こんにちは {$a->firstname} さん

誰か (おそらくあなた) が、「 {$a->sitename} 」 のアカウントで新しいパスワードを請求しました。

残念ですが、このサイトであなたのアカウントは無効にされています。パスワードをリセットすることができません。サイト管理者 {$a->admin} にご連絡ください。';
$string['emailpasswordchangeinfofail'] = 'こんにちは {$a->firstname} さん

誰か (おそらくあなた) が、「 {$a->sitename} 」 のアカウントで新しいパスワードを請求しました。

残念ですが、このサイトではパスワードをリセットすることができません。サイト管理者 {$a->admin} にご連絡ください。';
$string['emailpasswordchangeinfosubject'] = '{$a}: パスワード変更情報';
$string['emailpasswordconfirmation'] = 'こんにちは {$a->firstname} さん

誰か (おそらくあなた) が、「 {$a->sitename} 」 のアカウントで新しいパスワードを請求しました。

新しいパスワード請求を確認して、新たなパスワードをメールであなた宛に送信するために下記のページをご覧ください:

{$a->link}

ほとんどのメールプログラムでは、上記部分はクリックできるよう青色にリンク表示されています。

動作しない場合は、コピー&ペーストを使ってウェブブラウザ上部のアドレス欄に、このアドレスを入力してください。

お分かりにならない場合は、サイト管理者 {$a->admin} にご連絡ください。';
$string['emailpasswordconfirmationsubject'] = '{$a}: パスワード変更確認';
$string['emailpasswordconfirmmaybesent'] = '<p>正しいユーザ名またはメールアドレスを入力した場合、あなたにメールが送信されています。</p>
<p>送信されたメールには、パスワードの変更を確認および完了するため、簡単な説明が記載されています。パスワード変更作業が難しい場合、サイト管理者にご連絡ください。</p>';
$string['emailpasswordconfirmsent'] = 'メールがあなたのアドレス <b>{$a}</b> 宛に送信されました。<br />送信されたメールにはパスワードの変更を確認・完了するための簡単な説明が書いてあります。問題がある場合、サイト管理者にご連絡ください。';
$string['emailpasswordsent'] = 'パスワードの変更確認ありがとうございます。
<p>新しいパスワードが記載されたメールがあなたのメールアドレス<br /><b>{$a->email}</b>に送信されました。<br />新しいパスワードは自動的に生成されたものです - <a href="{$a->link}">パスワードの変更</a> で覚えやすいものに変更することができます。';
$string['enable'] = 'Yes';
$string['encryptedcode'] = '暗号化コード';
$string['english'] = '英語';
$string['entercourse'] = 'このコースに入るにはクリックしてください。';
$string['enteremail'] = 'あなたのメールアドレスを入力してください。';
$string['enteremailaddress'] = 'パスワードをリセットして新しいパスワードを送信します。メールアドレスを入力してください。';
$string['enterusername'] = 'あなたのユーザ名を入力してください。';
$string['entries'] = 'エントリ';
$string['error'] = 'エラー';
$string['errortoomanylogins'] = '申し訳ございません、ログイン失敗回数の上限に達しました。ブラウザを再起動してください。';
$string['errorwhenconfirming'] = 'エラーが発生したため、あなたのアカウントは認証されませんでした。メール本文のリンクをクリックして、このページにたどり着いた場合は、リンクが記されている行が崩れていないか確認してください。正しくリンクを動作させるためにコピー＆ペーストを使用してください。';
$string['everybody'] = '全員';
$string['executeat'] = 'バックアップ処理開始時刻';
$string['existing'] = '既存';
$string['existingadmins'] = '管理者一覧';
$string['existingcourse'] = '既存のコース';
$string['existingcourseadding'] = '既存のコース、既存のコースにデータを追加する';
$string['existingcoursedeleting'] = '既存のコース、最初に既存のコースを削除する';
$string['existingcreators'] = '既存のコース作成者';
$string['existingstudents'] = '登録済み学生';
$string['existingteachers'] = '教師一覧';
$string['expandall'] = 'すべてを展開する';
$string['expirynotify'] = '登録期間終了通知';
$string['expirynotifyemail'] = 'このコースに関する次の学生の登録期間は厳密に {$a->threshold} 日で終了します:

{$a->current}

このコースに関する次の学生の登録期間は {$a->threshold} 日以内に終了します:

{$a->past}

学生の登録期間を延長するには、次のページにアクセスしてください:
{$a->extendurl}';
$string['expirynotifystudents'] = '学生に通知';
$string['expirynotifystudentsemail'] = 'こんにちは、{$a->studentstr} さん

このメールは、あなたのコース「 {$a->course} 」に対する登録期間があと {$a->threshold} 日で終了するお知らせのため送信されました。

詳細な情報は、{$a->teacherstr} にお聞きください。';
$string['expirynotifystudents_help'] = '利用有効期間が設定された場合、学生がコースから受講登録解除される前にメール通知を受信するかどうか設定します。';
$string['expirythreshold'] = '閾値';
$string['expirythreshold_help'] = '利用有効期間が設定された場合、この設定では学生がコースから受講登録解除される前に何日で通知されるか設定します。';
$string['explanation'] = '説明';
$string['extendenrol'] = '登録期間を延長する (個別)';
$string['extendperiod'] = '延長期間';
$string['failedloginattempts'] = '最終ログインより {$a->attempts} 回のログイン失敗がありました。';
$string['failedloginattemptsall'] = '{$a->accounts} 件のアカウントがログインに {$a->attempts} 回失敗しました。';
$string['feedback'] = 'フィードバック';
$string['file'] = 'ファイル';
$string['filemissing'] = '{$a} が見つかりません。';
$string['files'] = 'ファイル';
$string['filesfolders'] = 'ファイル/フォルダ';
$string['filloutallfields'] = 'このフォームすべての欄に入力してください。';
$string['filter'] = 'フィルタ';
$string['findmorecourses'] = 'さらにコースを探す ...';
$string['firstaccess'] = '初回アクセス';
$string['firstname'] = '名';
$string['firsttime'] = 'はじめての方ですか?';
$string['flashlinkmessage'] = 'あなたのFlashプレイヤーをアップグレードしてください:';
$string['flashupgrademessage'] = 'このコンテンツを動作させるためにはFlashプラグインが必要です。しかし、あなたのFlashバージョンは古すぎます。

一旦ログアウトしてFlashプラグインをアップグレードした後、再度ログインしてください。';
$string['folder'] = 'フォルダ';
$string['folderclosed'] = 'クローズフォルダ';
$string['folderopened'] = 'オープンフォルダ';
$string['followingoptional'] = '下記は任意入力項目です';
$string['followingrequired'] = '下記は必須入力項目です';
$string['force'] = '強制';
$string['forcedmode'] = '強制モード';
$string['forcelanguage'] = '言語の強制';
$string['forceno'] = '強制しない';
$string['forcepasswordchange'] = 'パスワード変更を強制する';
$string['forcepasswordchangecheckfull'] = '本当に {$a} のパスワード変更を強制してもよろしいですか?';
$string['forcepasswordchange_help'] = 'チェックボックスをチェックした場合、ユーザの次回ログイン時にパスワードの変更を促します。';
$string['forcepasswordchangenot'] = '{$a} のパスワード変更を強制できませんでした。';
$string['forcepasswordchangenotice'] = '続けるにはパスワードを変更してください。';
$string['forcetheme'] = 'テーマの強制';
$string['forgotaccount'] = 'パスワードを忘れましたか?';
$string['forgotten'] = 'ユーザ名またはパスワードを忘れましたか?';
$string['forgottenduplicate'] = 'メールアドレスが複数のアカウントにより共有されています。代わりにユーザ名を入力してください。';
$string['forgotteninvalidurl'] = 'パスワードリセットのURIが正しくありません。';
$string['format'] = 'フォーマット';
$string['format_help'] = 'コースフォーマットではコースページのレイアウトを決定します。

* SCORMフォーマット - コースページの最初のセクションに (SCORM/AICCモジュールを使用する代替手段として) SCORMパッケージを表示します。
* ソーシャルフォーマット - コースページにフォーラムが表示されます。
* トピックフォーマット - コースページはトピックセクションにより構成されます。
* ウィークリーフォーマット- 最初の週がコース開始日時となるよう、コースページは週ごとのセクションにより構成されます。';
$string['formathtml'] = 'HTMLフォーマット';
$string['formatmarkdown'] = 'Markdownフォーマット';
$string['formatplain'] = 'プレインテキストフォーマット';
$string['formattext'] = 'Moodleオートフォーマット';
$string['formattexttype'] = 'フォーマット';
$string['framesetinfo'] = 'このフレームセットのドキュメント:';
$string['from'] = 'From';
$string['frontpagecategorycombo'] = 'コンボリスト';
$string['frontpagecategorynames'] = 'カテゴリ一覧';
$string['frontpagecourselist'] = 'コース一覧';
$string['frontpagedescription'] = 'フロントページ説明';
$string['frontpagedescriptionhelp'] = 'このサイト説明はフロントページに表示されます。';
$string['frontpageformat'] = 'フロントページフォーマット';
$string['frontpageformatloggedin'] = 'フロントページフォーマット (ログイン後)';
$string['frontpagenews'] = 'ニュースアイテム';
$string['frontpagesettings'] = 'フロントページ設定';
$string['frontpagetopiconly'] = 'トピックセクション';
$string['fulllistofcourses'] = 'すべてのコース';
$string['fullname'] = '名称';
$string['fullnamecourse'] = '長いコース名';
$string['fullnamecourse_help'] = '長いコース名はコースページ内トップおよびコース一覧に表示されます。';
$string['fullnamedisplay'] = '{$a->lastname} {$a->firstname}';
$string['fullnameuser'] = 'ユーザフルネーム';
$string['fullprofile'] = 'プロファイル詳細';
$string['fullsitename'] = '長いサイト名';
$string['functiondisabled'] = 'この機能は現在無効にされています。';
$string['gd1'] = 'GD 1.xインストール済';
$string['gd2'] = 'GD 2.xインストール済';
$string['gdneed'] = 'このグラフを表示するためにはGDのインストールが必要です。';
$string['gdnot'] = 'GD未インストール';
$string['general'] = '一般';
$string['geolocation'] = '緯度 - 経度';
$string['gettheselogs'] = 'これらのログを取得する';
$string['go'] = 'Go';
$string['gpl'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア財団によって発行された GNU 一般公衆利用許諾契約書 (バージョン2、または希望によってはそれ以降のバージョンのうちどれか) の定める条件の下で再頒布または改変することができます。

このプログラムは有用であることを願って頒布されますが、*全くの無保証*です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め全く存在しません。

詳しくはMoodleライセンス情報をご覧ください：
http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア財団によって発行された GNU 一般公衆利用許諾契約書 (バージョン3、または希望によってはそれ以降のバージョンのうちどれか) の定める条件の下で再頒布または改変することができます。

このプログラムは有用であることを願って頒布されますが、*全くの無保証*です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め全く存在しません。

詳しくはMoodleライセンス情報をご覧ください：
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPLライセンス';
$string['grade'] = '評点';
$string['grades'] = '評定';
$string['group'] = 'グループ';
$string['groupadd'] = '新しいグループを追加する';
$string['groupaddusers'] = '選択した人をグループに追加する';
$string['groupextendenrol'] = '登録期間を延長する (共通)';
$string['groupfor'] = 'グループ';
$string['groupinfo'] = '選択したグループの情報';
$string['groupinfoedit'] = 'グループ設定を編集する';
$string['groupinfomembers'] = '選択したメンバーの情報';
$string['groupinfopeople'] = '選択したユーザの情報';
$string['groupmembers'] = 'グループメンバー';
$string['groupmemberssee'] = 'グループメンバーを表示する';
$string['groupmembersselected'] = '選択したグループのメンバー';
$string['groupmode'] = 'グループモード';
$string['groupmodeforce'] = '強制グループモード';
$string['groupmy'] = 'マイグループ';
$string['groupnonmembers'] = 'グループに属さないユーザ';
$string['groupnotamember'] = '申し訳ございません、あなたはグループのメンバーではありません。';
$string['grouprandomassign'] = 'すべてをランダムにグループに割り当てる';
$string['groupremove'] = '選択したグループを削除する';
$string['groupremovemembers'] = '選択したメンバーを削除する';
$string['groups'] = 'グループ';
$string['groupsnone'] = 'グループなし';
$string['groupsseparate'] = '分離グループ';
$string['groupsvisible'] = '可視グループ';
$string['guest'] = 'ゲスト';
$string['guestdescription'] = 'ゲストには最小限の権限があり、通常テキストを入力することはできません。';
$string['guestskey'] = '登録キーを持っているゲストを許可する';
$string['guestsno'] = 'ゲストを許可しない';
$string['guestsnotallowed'] = '申し訳ございません、「 {$a} 」ではゲストでの入室は許可されていません。';
$string['guestsyes'] = '登録キーを持っていないゲストを許可する';
$string['guestuser'] = 'ゲストユーザ';
$string['guestuserinfo'] = 'このユーザはいくつかのコースに閲覧のみ許可された特別ユーザです。';
$string['healthcenter'] = 'ヘルスセンター';
$string['healthnoproblemsfound'] = '健康問題は見つかりませんでした!';
$string['healthproblemsdetected'] = '健康問題が発見されました!';
$string['healthproblemsolution'] = '健康問題の解決方法';
$string['healthreturntomain'] = '続ける';
$string['healthsolution'] = '解決方法';
$string['help'] = 'ヘルプ';
$string['helpprefix2'] = '{$a} のヘルプ';
$string['helpwiththis'] = 'この内容に関するヘルプ';
$string['hiddenassign'] = '割り当て非表示';
$string['hiddenfromstudents'] = '学生から非表示';
$string['hiddensections'] = 'コースセクションの非表示';
$string['hiddensectionscollapsed'] = '非表示コースセクションを折りたたんで表示する';
$string['hiddensections_help'] = 'ここでは学生に非表示セクションを折りたたんだ形で (おそらくウィークリーフォーマットで休日を示すため)　表示するか、完全に隠すか指定します。';
$string['hiddensectionsinvisible'] = '非表示のコースセクションを完全に見えなくする';
$string['hide'] = '非表示';
$string['hideadvancedsettings'] = '高度な設定を隠す';
$string['hidepicture'] = '画像を隠す';
$string['hidesection'] = 'セクション {$a} を隠す';
$string['hidesettings'] = '設定を隠す';
$string['hideshowblocks'] = 'ブロックを隠す、または表示する';
$string['hidetopicfromothers'] = 'トピックを隠す';
$string['hideweekfromothers'] = '週を隠す';
$string['hits'] = 'アクセス';
$string['hitsoncourse'] = 'アクセス状況 - コース: {$a->coursename} / ユーザ: {$a->username}';
$string['hitsoncoursetoday'] = '本日のアクセス状況 - コース: {$a->coursename} / ユーザ: {$a->username}';
$string['home'] = 'Home';
$string['hour'] = '時間';
$string['hours'] = '時間';
$string['howtomakethemes'] = '新しいテーマの作り方';
$string['htmleditor'] = 'HTMLエディタを使用します (互換性のあるブラウザのみ)';
$string['htmleditoravailable'] = 'HTMLエディタは利用可能です';
$string['htmleditordisabled'] = 'あなたのユーザプロファイルではHTMLエディタが使用禁止にされています。';
$string['htmleditordisabledadmin'] = 'このサイトでのHTMLエディタ使用を管理者が禁止しています。';
$string['htmleditordisabledbrowser'] = 'あなたのブラウザの互換性がないため、HTMLエディタを使用できません。';
$string['htmlfilesonly'] = 'HTMLファイルのみ';
$string['htmlformat'] = 'HTMLフォーマット';
$string['icon'] = 'アイコン';
$string['icqnumber'] = 'ICQナンバー';
$string['idnumber'] = 'IDナンバー';
$string['idnumbercourse'] = 'コースIDナンバー';
$string['idnumbercourse_help'] = 'コースのIDナンバーは外部のシステムとマッチングする場合のみ使用され、サイト内のどこにも表示されることはありません。このコースに関わる公式のコードがある場合はここに設定してください。それ以外は空白のままにしてください。';
$string['idnumbermod'] = 'IDナンバー';
$string['idnumbermod_help'] = 'IDナンバーを設定することで、評定計算の目的で活動を識別する手段を提供します。評定計算に活動が含まれていない場合、IDナンバーフィールドを空白のままにすることができます。

IDナンバーは活動の更新ページでのみ編集することができますが、 評定表にある評定計算の編集ページで設定することもできます。';
$string['idnumbertaken'] = 'このIDナンバーはすでに使用されています。';
$string['imagealt'] = '写真説明';
$string['import'] = 'インポート';
$string['importdata'] = 'コースデータをインポートする';
$string['importdataexported'] = 'コースデータのエクスポートが完了しました。<br /> 続けてあなたのコースにインポートします。';
$string['importdatafinished'] = 'インポートが完了しました! あなたのコースに移動します。';
$string['importdatafrom'] = 'インポートするコースデータを探す:';
$string['inactive'] = '停止';
$string['include'] = 'バックアップ';
$string['includeallusers'] = 'すべてのユーザを含む';
$string['includecoursefiles'] = 'コースファイルを含む';
$string['includecourseusers'] = 'コースユーザを含む';
$string['included'] = 'バックアップ済';
$string['includelogentries'] = 'ログエントリを含む';
$string['includemodules'] = 'モジュールを含む';
$string['includemoduleuserdata'] = 'モジュールユーザデータを含む';
$string['includeneededusers'] = '必要なユーザを含む';
$string['includenoneusers'] = 'ユーザを含まない';
$string['includeroleassignments'] = 'ロール割り当てを含む';
$string['includesitefiles'] = 'このコースで使用されているサイトファイルを含む';
$string['includeuserfiles'] = 'ユーザファイルを含む';
$string['info'] = '情報';
$string['institution'] = '所属組織';
$string['instudentview'] = ': 学生モード使用中';
$string['interests'] = '興味があること';
$string['interestslist'] = '興味リスト';
$string['interestslist_help'] = 'あなたの興味があることをカンマ ( , ) で区切って入力してください。あなたの興味があることはプロファイルページにタグとして表示されます。';
$string['invalidemail'] = '無効なメールアドレスです。';
$string['invalidlogin'] = '不正なログインです、再度ログインしてください。';
$string['invalidusername'] = 'ユーザ名には半角英数小文字、アンダースコア (_)、ハイフン (-)、ピリオド (.) またはアットマーク (@) のみ含むことができます。';
$string['invalidusernameupload'] = '無効なユーザ名です。';
$string['ip_address'] = 'IPアドレス';
$string['jump'] = 'ジャンプ';
$string['jumpto'] = 'ジャンプ ...';
$string['keep'] = '保存';
$string['keepsearching'] = '再度検索する';
$string['langltr'] = '言語の向き 左 >> 右';
$string['langrtl'] = '言語の向き 右 >> 左';
$string['language'] = '言語設定';
$string['languagegood'] = 'この言語パックは最新版です! :-)';
$string['lastaccess'] = '最終アクセス';
$string['lastedited'] = '最終編集日時';
$string['lastlogin'] = '最終ログイン';
$string['lastmodified'] = '最終更新日時';
$string['lastname'] = '姓';
$string['lastyear'] = '昨年';
$string['latestlanguagepack'] = 'moodle.orgで最新の言語パックをチェックする';
$string['layouttable'] = 'レイアウトテーブル';
$string['leavetokeep'] = '現在のパスワードを使用する場合、空白にしてください。';
$string['legacythemeinuse'] = 'あなたのブラウザが古すぎるため、このサイトは互換モードで表示されています。';
$string['legacythemesaved'] = '新しいレガシーテーマが保存されました。';
$string['license'] = 'ライセンス';
$string['licenses'] = 'ライセンス';
$string['liketologin'] = 'フルユーザアカウントでログインしますか?';
$string['list'] = 'リスト';
$string['listfiles'] = '{$a} のファイルリスト';
$string['listofallpeople'] = '全員を表示する';
$string['livelogs'] = '過去1時間のライブログ';
$string['local'] = 'ローカル';
$string['localplugindeleteconfirm'] = 'あなたはローカルプラグイン「 {$a} 」を完全に削除しようとしています。この処理でデータベースよりこのプラグインに関わるすべてのデータが完全に削除されます。本当に続けてもよろしいですか？';
$string['localplugins'] = 'ローカルプラグイン';
$string['localpluginsmanage'] = 'ローカルプラグインの管理';
$string['location'] = 'ロケーション';
$string['log_excel_date_format'] = 'yyyy/mm/dd h:mm';
$string['loggedinas'] = 'あなたは {$a} としてログインしています';
$string['loggedinasguest'] = 'あなたは現在ゲストアクセスを利用しています';
$string['loggedinnot'] = 'あなたはログインしていません。';
$string['login'] = 'ログイン';
$string['loginalready'] = 'あなたはすでにログインしています';
$string['loginas'] = 'このユーザとしてログインする';
$string['loginaspasswordexplain'] = '<p>この機能を使用するには、特別な「ログインパスワード」を入力する必要があります。<br />パスワードが分からない場合は、サーバ管理者にお聞きください。</p>';
$string['login_failure_logs'] = 'ログイン失敗ログ';
$string['loginguest'] = 'ゲストとしてログインする';
$string['loginsite'] = 'サイトにログインする';
$string['loginsteps'] = 'こんにちは! コースにアクセスするために新しいアカウントを作成してください。アカウント作成方法は下記のとおりです。
<ol>
<li>アカウントの作成</li>
<ul>
<li type=disc><a href="{$a}">新しいアカウントを作成する</a>で<b>必要事項を入力してください</b>。</li>
</ul>

<li>アカウントの確定</li>
<ul>
<li type=disc>あなたが登録したメールアドレスにメールがすぐに送信されます。</li>
<li type=disc>メールを開いて、その中の<b>リンクをクリックしてください</b>。</li>
<li type=disc>アカウントの確定が行われ、ログイン可能になります。</li>
</ul>

<li>コースへのアクセス</li>
<ul>
<li type=disc>参加したい<b>コースを選択してください</b>。</li>
<li type=disc>「登録キー」を入力する必要がある場合は、先生があなたに教えた「登録キー」を入力してください。これでコースにアクセスできるようになります。</li>
<li type=disc>今後、登録したコースにアクセスするために必要なものは、ユーザ名とパスワードのみです。 このページの左側のユーザ名とパスワードの入力欄を利用してください。</li>
</ul>
</ol>';
$string['loginstepsnone'] = '<p>こんにちは!</p>
<p>コースを利用するためにはアカウントを開設する必要があります。</p>
<p>あなたがやることはユーザ名とパスワードをこのページのフォームを使って作成するだけです!</p>
<p>もし、他の人が同じユーザ名を使っている場合は違うユーザ名で登録してください。</p>';
$string['loginto'] = '{$a} にログインする';
$string['loginusing'] = 'ユーザ名とパスワードを入力してください';
$string['logout'] = 'ログアウト';
$string['logoutconfirm'] = '本当にログアウトしてもよろしいですか?';
$string['logs'] = 'ログ';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">さらに表示する</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">さらに表示する</a> ]';
$string['lookback'] = '期間';
$string['mailadmins'] = '管理者に通知する';
$string['mailstudents'] = '学生に通知する';
$string['mailteachers'] = '教師に通知する';
$string['makeafolder'] = 'フォルダを作成する';
$string['makeeditable'] = '「 {$a} 」をサーバ上 (例 Apache) で編集可能にした場合、あなたはこのページで直接編集することができます。';
$string['makethismyhome'] = 'このページをマイデフォルトホームページにする';
$string['manageblocks'] = 'ブロック';
$string['managecourses'] = 'コースを管理する';
$string['managedatabase'] = 'データベース';
$string['manageeditorfiles'] = 'エディタで使用されるファイルを管理する';
$string['managefilters'] = 'フィルタ';
$string['managemodules'] = 'モジュール';
$string['manageroles'] = 'ロールおよびパーミッション';
$string['markedthistopic'] = 'このトピックは最新トピックとして強調表示されています。';
$string['markthistopic'] = 'このトピックを最新トピックとして強調表示します。';
$string['matchingsearchandrole'] = '「 {$a->search} 」および「 {$a->role} 」に合致';
$string['maxfilesize'] = '新しいファイルの最大サイズ: {$a}';
$string['maximumchars'] = '{$a} の最大文字数';
$string['maximumgrade'] = '最大評点';
$string['maximumgradex'] = '最大評点: {$a}';
$string['maximumshort'] = '最大';
$string['maximumupload'] = '最大アップロードサイズ';
$string['maximumupload_help'] = 'ここではコース内で学生がアップロードできるファイルの最大サイズを設定します。このサイズは管理者がサイト全体に設定したファイルの最大サイズに制限されます。さらに活動モジュールでこのサイズを制限することが可能です。';
$string['maxnumcoursesincombo'] = '<a href="{$a->link}">{$a->numberofcourses} 件のコース</a>を閲覧します。';
$string['maxsize'] = '最大サイズ: {$a}';
$string['memberincourse'] = 'コースに属するユーザ';
$string['messagebody'] = 'メッセージ本文';
$string['messagedselectedusers'] = '選択されたユーザにメッセージが送信され、受信者リストがリセットされました。';
$string['messagedselectedusersfailed'] = '選択されたユーザへのメッセージ送信時に問題が発生しました。数名のユーザにはメールが送信されました。';
$string['messageprovider:backup'] = 'バックアップ通知';
$string['messageprovider:courserequestapproved'] = 'コース作成リクエスト承認通知';
$string['messageprovider:courserequested'] = 'コース作成リクエスト通知';
$string['messageprovider:courserequestrejected'] = 'コース作成リクエスト拒否通知';
$string['messageprovider:errors'] = 'サイトの重大なエラー';
$string['messageprovider:errors_help'] = '管理者が知る必要のある重大なエラーです。';
$string['messageprovider:instantmessage'] = 'ユーザ間のパーソナルメッセージ';
$string['messageprovider:instantmessage_help'] = 'このセクションではこのサイトのほかのユーザからあなた宛に直接メッセージ送信された場合の動作を設定します。';
$string['messageprovider:notices'] = '小さな問題に関する警告';
$string['messageprovider:notices_help'] = 'これらは管理者にとって興味深い内容の通知です。';
$string['messageselect'] = 'このユーザをメール受信者として選択する';
$string['messageselectadd'] = 'メッセージを送信する';
$string['migratinggrades'] = '評定の移行';
$string['min'] = '分';
$string['mins'] = '分';
$string['minutes'] = '分';
$string['miscellaneous'] = 'その他';
$string['missingcategory'] = 'あなたはカテゴリを選択する必要があります。';
$string['missingcity'] = '都道府県が入力されていません。';
$string['missingcountry'] = '国が選択されていません。';
$string['missingdescription'] = '自己紹介が入力されていません。';
$string['missingemail'] = 'メールアドレスが入力されていません。';
$string['missingfirstname'] = '名が入力されていません。';
$string['missingfromdisk'] = 'ディスクにありません';
$string['missingfullname'] = 'フルネームが入力されていません。';
$string['missinglastname'] = '姓が入力されていません。';
$string['missingname'] = '名前が入力されていません。';
$string['missingnewpassword'] = '新しいパスワードが入力されていません。';
$string['missingpassword'] = 'パスワードが入力されていません。';
$string['missingrecaptchachallengefield'] = 'reCAPTCHAチャレンジフィールドがありません。';
$string['missingreqreason'] = '理由が入力されていません。';
$string['missingshortname'] = '省略名が入力されていません。';
$string['missingshortsitename'] = 'サイト省略名が入力されていません。';
$string['missingsitedescription'] = 'サイトの説明が入力されていません。';
$string['missingsitename'] = 'サイト名が入力されていません。';
$string['missingstrings'] = '未翻訳ストリングを確認する';
$string['missingstudent'] = '何か選んでください。';
$string['missingsummary'] = '要約が入力されていません。';
$string['missingteacher'] = '何か選択してください。';
$string['missingurl'] = 'リンク切れ';
$string['missingusername'] = 'ユーザ名が入力されていません。';
$string['modified'] = '更新日時';
$string['moduledeleteconfirm'] = 'あなたはモジュール「 {$a} 」を完全に削除しようとしています。この処理でデータベースよりこの活動モジュールに関わるすべてのデータが完全に削除されます。本当に続けてもよろしいですか？';
$string['moduledeletefiles'] = 'モジュール「 {$a->module} 」に関わるすべてのデータがデータベースより削除されました。削除を完全なものにするために (モジュールの自動再インストールを防ぐために) サーバより次のディレクトリを削除してください: {$a->directory}';
$string['moduleintro'] = '説明';
$string['modulesetup'] = 'モジュールテーブル設定中';
$string['modulesuccess'] = '{$a} テーブルが正常に設定されました。';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'このページのMoodle Docs';
$string['moodlerelease'] = 'Moodleリリース';
$string['moodleversion'] = 'Moodleバージョン';
$string['more'] = '詳細';
$string['morehelp'] = '詳細情報';
$string['moreinformation'] = 'このエラーに関する詳細情報';
$string['moreprofileinfoneeded'] = 'あなたのことをもっと教えてください。';
$string['mostrecently'] = '直近の';
$string['move'] = '移動';
$string['movecategorycontentto'] = '移動先';
$string['movecategoryto'] = 'カテゴリを移動する:';
$string['movecontentstoanothercategory'] = 'コンテンツを別のカテゴリに移動する';
$string['movecourseto'] = 'コースの移動:';
$string['movedown'] = '下へ';
$string['movefilestohere'] = 'ファイルをここに移動する';
$string['movefull'] = '{$a} をこの場所に移動する';
$string['movehere'] = 'ここに移動する';
$string['moveleft'] = '左へ';
$string['moveright'] = '右へ';
$string['movesection'] = 'セクション {$a} を移動する';
$string['moveselectedcoursesto'] = '選択したコースを移動する ...';
$string['movetoanotherfolder'] = '他のフォルダへ移動する';
$string['moveup'] = '上へ';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = '新しいパスワードには現在のパスワードと異なるものを指定してください。';
$string['mustconfirm'] = 'ログイン情報を確認してください。';
$string['mycourses'] = 'マイコース';
$string['myfiles'] = 'マイプライベートファイル';
$string['myfilesmanage'] = 'マイプライベートファイルを管理する';
$string['myhome'] = 'マイホーム';
$string['mymoodledashboard'] = 'マイMoodleダッシュボード';
$string['myprofile'] = 'マイプロファイル';
$string['name'] = '名称';
$string['navigation'] = 'ナビゲーション';
$string['needed'] = '必要';
$string['never'] = 'なし';
$string['neverdeletelogs'] = 'ログを削除しない';
$string['new'] = '新規';
$string['newaccount'] = '新しいアカウント';
$string['newcourse'] = '新しいコース';
$string['newpassword'] = '新しいパスワード';
$string['newpasswordfromlost'] = '<strong>注意:</strong> 喪失パスワードリカバリ処理の一環として送信される2通のメールの<strong>2番目</strong>に、あなたの<strong>現在のパスワード</strong>が送信されます。この画面を続ける前に、あなたの新しいパスワードが記載されたメールを受信したことをよく確かめてください。';
$string['newpassword_help'] = '新しいパスワードを入力、または現在のパスワードを使用する場合は空白にしてください。';
$string['newpasswordtext'] = 'こんにちは {$a->firstname} さん

「 {$a->sitename} 」のパスワードリセットおよび仮パスワードの作成が完了しました。

あなたのログイン情報は下記のとおりです:
  ユーザ名: username: {$a->username}
  パスワード: password: {$a->newpassword}

パスワードを変更する場合は、下記のページにアクセスしてください。

  {$a->link}

ほとんどのメールプログラムでは、上記部分はクリックできるよう青色にリンク表示されています。動作しない場合は、コピー&ペーストを使ってウェブブラウザ上部のアドレス欄に、このアドレスを入力してください。

「 {$a->sitename} 」の管理者よりご挨拶でした。
{$a->signoff}';
$string['newpicture'] = '新しい画像';
$string['newpicture_help'] = '新しい画像を追加する場合、イメージ (JPGまたはPNGフォーマット) を閲覧および選択して「プロファイルを更新する」をクリックしてください。イメージは正方形にトリミングおよび100x100ピクセルにリサイズされます。';
$string['newsitem'] = '件のニュースアイテムを表示する';
$string['newsitems'] = '件のニュースアイテムを表示する';
$string['newsitemsnumber'] = 'ニュースアイテムの表示件数';
$string['newsitemsnumber_help'] = 'この設定ではコースページの最新ニュースブロックに何件の最新項目を表示するか設定します。「0 件のニュースアイテムを表示する」を選択した場合、最新ニュースブロックは表示されません。';
$string['newuser'] = '新しいユーザ';
$string['newusernewpasswordsubj'] = '新しいユーザアカウント';
$string['newusernewpasswordtext'] = 'こんにちは {$a->firstname} さん

あなたの新しいアカウントが「 {$a->sitename} 」に作成され、新しい一時的なパスワードが発行されました。

あなたの現在のログイン情報は下記のとおりです:
  ユーザ名: {$a->username}
  パスワード: {$a->newpassword}
  (最初にログインしたときにパスワードを変更してください。)

{$a->sitename} で作業を始めるには {$a->link} にログインしてください。

ほとんどのメールプログラムでは、上記部分はクリックできるよう青色にリンク表示されています。動作しない場合は、コピー&ペーストを使ってウェブブラウザ上部のアドレス欄に、このアドレスを入力してください。

「 {$a->sitename} 」の管理者よりご挨拶でした。
{$a->signoff}';
$string['newusers'] = '新しいユーザ';
$string['newwindow'] = '新しいウィンドウ';
$string['next'] = '次へ';
$string['nextsection'] = '次のセクション';
$string['no'] = 'No';
$string['noblockstoaddhere'] = 'あなたがこのページに追加できるブロックはありません。';
$string['nobody'] = 'なし';
$string['nochange'] = '変更なし';
$string['nocomments'] = 'コメントなし';
$string['nocourses'] = 'コースなし';
$string['nocoursesfound'] = 'キーワード 「 {$a} 」 でコースは見つかりませんでした。';
$string['nocoursesyet'] = 'このカテゴリにコースはありません。';
$string['nodstpresets'] = '管理者が夏時間のサポートを有効にしていません。';
$string['nofilesselected'] = 'レストアするファイルが選択されていません。';
$string['nofilesyet'] = 'コースにファイルがアップロードされていません。';
$string['nograde'] = '評点なし';
$string['noimagesyet'] = 'あなたのコースにまだイメージがアップロードされていません。';
$string['nologsfound'] = 'ログが見つかりませんでした。';
$string['nomatchingusers'] = '「 {$a} 」に合致するユーザは見つかりませんでした。';
$string['nomorecourses'] = '該当するコースは見つかりませんでした。';
$string['nomoreidnumber'] = '重複を回避するためのIDナンバーは使用されていません。';
$string['none'] = 'なし';
$string['noneditingteacher'] = '編集権限のない教師';
$string['noneditingteacherdescription'] = '編集権限のない教師はコース内での教育および学生を評定できますが、活動を変更することはできません。';
$string['nonstandard'] = '非標準';
$string['nopendingcourses'] = '承認処理中のコースはありません。';
$string['nopotentialadmins'] = '潜在的な管理者は登録されていません。';
$string['nopotentialcreators'] = '潜在的なコース作成者は登録されていません。';
$string['nopotentialstudents'] = '潜在的な学生は登録されていません。';
$string['nopotentialteachers'] = '潜在的な教師は登録されていません。';
$string['norecentactivity'] = '最近の活動はありません。';
$string['noreplybouncemessage'] = 'あなたはno-replyメールアドレスに返信しました。フォーラムの投稿に返信したい場合、メールに返信する代わりにフォーラム {$a} で返信を投稿してください。

あなたのメール本文は下記のとおりです:';
$string['noreplybouncesubject'] = '{$a} -宛先不明メール';
$string['noreplyname'] = 'このメールアドレス宛に返信しないでください';
$string['noresults'] = '該当データがありません。';
$string['normal'] = 'ノーマル';
$string['normalfilter'] = '通常検索';
$string['nosite'] = 'サイトレベルのコースは見つかりませんでした。';
$string['nostudentsfound'] = '{$a} が見つかりませんでした。';
$string['nostudentsingroup'] = 'このグループにはまだ学生が登録されていません。';
$string['nostudentsyet'] = 'このコースにはまだ学生が登録されていません。';
$string['nosuchemail'] = 'そのようなメールアドレスは存在しません。';
$string['notavailable'] = '利用できません。';
$string['noteachersyet'] = 'このコースにはまだ教師が登録されていません。';
$string['notenrolled'] = '{$a} はこのコースに登録されていません。';
$string['notenrolledprofile'] = 'コースに登録されていないため、このユーザのプロファイルを閲覧することはできません。';
$string['noteusercannotrolldatesoncontext'] = '<strong>注意:</strong> あなたには必要なパーミッションが不足しているため、このバックアップをリストアする場合の日付変更機能が無効にされました。';
$string['noteuserschangednonetocourse'] = '<strong>注意:</strong> ユーザデータをリストアする場合、コースユーザをリストアする必要があります。あなたの設定が変更されました。';
$string['nothingnew'] = '最終ログインより更新されたものはありません。';
$string['nothingtodisplay'] = '表示するデータはありません。';
$string['notice'] = '警告';
$string['noticenewerbackup'] = 'このバックアップファイルは現在インストールされているMoodle {$a->serverrelease} ({$a->serverversion}) より新しいバージョンMoodle {$a->backuprelease} ({$a->backupversion}) により作成されました。旧バージョンへの互換性が保障されないため、バックアップデータに矛盾を生じる恐れがあります。';
$string['notifications'] = '通知';
$string['notifyloginfailuresmessage'] = '{$a->time}  IP: {$a->ip}  ユーザ: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'あなたはこのログを {$a}/course/report/log/index.php?id=1&chooselog=1&modid=site_errors で閲覧することができます。';
$string['notifyloginfailuresmessagestart'] = '前回、あなたに報告して以降の {$a} におけるログイン失敗の一覧です。';
$string['notifyloginfailuressubject'] = '{$a} :: ログイン失敗通知';
$string['notincluded'] = 'バックアップ対象外';
$string['notingroup'] = '申し訳ございません、あなたがこの活動を閲覧するには、グループに属している必要があります。';
$string['notpublic'] = '非公開!';
$string['nousersfound'] = 'ユーザは見つかりませんでした。';
$string['nousersmatching'] = 'ユーザ「 {$a} 」は見つかりませんでした。';
$string['nousersyet'] = 'まだユーザは登録されていません。';
$string['novalidcourses'] = '表示する有効なコースはありません。';
$string['now'] = '現在';
$string['numattempts'] = 'ログイン失敗回数 {$a}';
$string['numberofcourses'] = 'コース数';
$string['numberweeks'] = '週/トピックの数';
$string['numdays'] = '{$a} 日';
$string['numhours'] = '{$a} 時間';
$string['numletters'] = '{$a} 文字';
$string['numminutes'] = '{$a} 分';
$string['nummonths'] = '{$a} ヶ月';
$string['numseconds'] = '{$a} 秒';
$string['numviews'] = '{$a} 閲覧';
$string['numweeks'] = '{$a} 週';
$string['numwords'] = '{$a} 語';
$string['numyears'] = '{$a} 年';
$string['ok'] = 'OK';
$string['oldpassword'] = '現在のパスワード';
$string['olduserdirectory'] = 'これは古いユーザディレクトリのため必要ありません。あなたはこのディレクトリを安全に削除することができます。古いユーザディレクトリに含まれるファイルは新しいユーザディレクトリにコピーされました。';
$string['opentoguests'] = 'ゲストアクセス';
$string['optional'] = '任意';
$string['order'] = '表示順';
$string['orphanedactivities'] = '迷子の活動';
$string['other'] = '他の';
$string['outline'] = 'アウトライン';
$string['outlinereport'] = 'アウトラインレポート';
$string['page'] = 'ページ';
$string['pageheaderconfigablock'] = '%fullname% 内のブロック設定';
$string['pagepath'] = 'ページパス';
$string['pageshouldredirect'] = 'このページは自動的にリダイレクトされます。何も起こらない場合、下の「続ける」リンクをクリックしてください。';
$string['parentcategory'] = '親カテゴリ';
$string['parentcoursenotfound'] = '親コースが見つかりませんでした!';
$string['parentfolder'] = '親フォルダ';
$string['participants'] = '参加者';
$string['participantslist'] = '参加者リスト';
$string['participationratio'] = '参加率';
$string['participationreport'] = '参加レポート';
$string['password'] = 'パスワード';
$string['passwordchanged'] = 'パスワードが変更されました。';
$string['passwordconfirmchange'] = 'パスワード変更を確認する';
$string['passwordextlink'] = '次のリンクはあなたのパスワードを回復するために提供されています。クリックすることで、Moodle外部に移動します。';
$string['passwordforgotten'] = 'パスワード喪失';
$string['passwordforgotteninstructions'] = '最初に、あなたの詳細情報がユーザデータベースに登録されている必要があります。あなたの「ユーザ名」<strong>または</strong>登録に使用した「メールアドレス」をテキストボックスに入力してください。「ユーザ名」「メールアドレス」の両方を入力する必要はありません。';
$string['passwordforgotteninstructions2'] = 'パスワードをリセットするには、あなたのユーザ名またはメールアドレスを以下に入力してください。私たちがデータベース内であなたを探すことができた場合、再度アクセスするためのインストラクションを記載したメールを、あなたのメールアドレス宛に送信します。';
$string['passwordnohelp'] = 'あなたのパスワードを探すためのヘルプは利用できません。Moodle管理者にご連絡ください。';
$string['passwordrecovery'] = 'はい、ログイン情報を教えてください';
$string['passwordsdiffer'] = 'パスワードが正しくありません。';
$string['passwordsent'] = 'パスワードが送信されました。';
$string['passwordsenttext'] = '<p>メールが {$a->email} 宛に送信されました。
<p><b>メールに記載されている新パスワードを確認してください。</b>
<p>新パスワードは自動的に作成されたものです。ここで<a href="{$a->link}">アクセスして覚えやすいものに変更してください</a>。';
$string['path'] = 'パス';
$string['pathnotexists'] = 'サーバにパスが見当たりません!';
$string['pathslasherror'] = 'パスの最後にスラッシュを付けないでください!!';
$string['paymentinstant'] = '下のボタンをお使いください。お支払いと登録がすぐに完了します!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> 保留</small>)';
$string['paymentrequired'] = 'このコースへの登録は有料です。';
$string['payments'] = '支払い';
$string['paymentsorry'] = 'お支払いありがとうございます! 残念ですが、あなたの支払いおよびコース 「 {$a->fullname} 」 に入るための登録作業は完了してません。再度、支払いおよび登録作業を行ってください。引き続きエラーが表示される場合は、{$a->teacher} またはサイト管理者にご連絡ください。';
$string['paymentthanks'] = 'お支払いありがとうございます! あなたは次のコースに登録されました:<br /> 「 {$a} 」';
$string['pendingrequests'] = '保留中のリクエスト';
$string['periodending'] = '期間終了 ({$a})';
$string['personal'] = 'パーソナル';
$string['personalprofile'] = 'パーソナルプロファイル';
$string['phone'] = '電話';
$string['phone2'] = '携帯電話';
$string['phpinfo'] = 'PHP情報';
$string['pictureof'] = '画像 {$a}';
$string['pictureofuser'] = 'ユーザ画像';
$string['pleaseclose'] = 'このウィンドウを閉じてください。';
$string['pleasesearchmore'] = 'もう少し検索してください。';
$string['pleaseusesearch'] = '検索を使用してください。';
$string['plugin'] = 'プラグイン';
$string['plugincheck'] = 'プラグインチェック';
$string['pluginchecknotice'] = '次のテーブルにはあなたの現在のMoodleで検出されたモジュール、ブロックおよびフィルタが表示されています。テーブルではどのプラグインが標準であり、どのプラグインが標準でないか示されています。このMoodleのアップグレードを続ける前に、すべての非標準プラグインを確認および最新バージョンにアップグレードしてください。';
$string['plugindeletefiles'] = 'プラグイン「 {$a->name} 」に関わるすべてのデータがデータベースより削除されました。プラグインの自動再インストールを防ぐため、あなたのサーバより次のディレクトリを削除してください: {$a->directory}';
$string['pluginsetup'] = 'プラグインテーブル設定中';
$string['policyaccept'] = '内容を理解し、同意します。';
$string['policyagree'] = 'このサイトを継続して使用するには、使用許諾に同意する必要があります。同意しますか?';
$string['policyagreement'] = 'サイト使用許諾';
$string['policyagreementclick'] = 'サイト使用許諾にリンクする';
$string['popup'] = 'ポップアップ';
$string['popupwindow'] = '新しいウィンドウでファイルを開く';
$string['popupwindowname'] = 'ポップアップウィンドウ';
$string['post'] = '投稿';
$string['posts'] = '投稿';
$string['potentialadmins'] = '潜在的な管理者';
$string['potentialcreators'] = '潜在的なコース作成者';
$string['potentialstudents'] = '潜在的な学生';
$string['potentialteachers'] = '潜在的な教師';
$string['preferences'] = '設定';
$string['preferredlanguage'] = '使用言語';
$string['preferredtheme'] = '使用テーマ';
$string['preprocessingbackupfile'] = 'バックアップファイル処理中';
$string['preview'] = 'プレビュー';
$string['previewhtml'] = 'HTMLフォーマットプレビュー';
$string['previeworchoose'] = 'テーマを選択またはプレビューしてください。';
$string['previous'] = '前へ';
$string['previouslyselectedusers'] = '「 {$a} 」に合致せずに選択されたユーザ';
$string['previoussection'] = '前のセクション';
$string['primaryadminsetup'] = '管理者アカウントの設定';
$string['profile'] = 'プロファイル';
$string['profilenotshown'] = 'プロファイル自己紹介欄はこのユーザが少なくとも1つのコースに登録されるまで表示されません。';
$string['publicprofile'] = 'パブリックプロファイル';
$string['publicsitefileswarning'] = '注意: ここに置いたファイルには誰でもアクセスすることができます。';
$string['publicsitefileswarning2'] = '注意: ここに置いたファイルはURIを知っている (または推測できる) 誰でもアクセスすることができます。セキュリティ上の理由から、リストア完了後、すべてのバックアップファイルをすぐに削除することをお勧めします。';
$string['publicsitefileswarning3'] = '注意: ここに置いたファイルはURIを知っている (または推測できる) 誰でもアクセスすることができます。<br />セキュリティ上の理由から、バックアップファイルは安全なbackupdataフォルダ内にのみ保存してください。';
$string['publish'] = '公開';
$string['question'] = '問題';
$string['questionsinthequestionbank'] = '問題バンクの問題';
$string['readinginfofrombackup'] = 'バックアップより情報を読取り中';
$string['readme'] = 'README';
$string['recentactivity'] = '最近の活動';
$string['recentactivityreport'] = '最近の活動詳細 ...';
$string['recipientslist'] = '受信者リスト';
$string['recreatedcategory'] = '再作成カテゴリ {$a}';
$string['redirect'] = 'リダイレクト';
$string['refresh'] = 'リフレッシュ';
$string['refreshingevents'] = 'イベントの更新';
$string['registration'] = 'Moodle登録';
$string['registrationcontact'] = '一般からの問い合わせ';
$string['registrationcontactno'] = 'いいえ、サイト一覧にお問い合わせフォームを設置しないでください';
$string['registrationcontactyes'] = 'はい、潜在的なMoodlerが問い合わせできるよう、問い合わせフォームを設置してください';
$string['registrationemail'] = 'メール通知';
$string['registrationinfo'] = '<p>このページではあなたのMoodleサイトをmoodle.orgに登録できます。登録は無料です。登録の主な利点は発信数の少ないメーリングリストにあなたのメールアドレスが追加され、セキュリティに関する警告およびMoodleの最新リリースに関する情報を受取れることです。</p>
<p>あなたの情報はデフォルトでは公開されません。また、他の人に販売・転送されることはありません。情報を収集する唯一の理由はサポートを目的とするものであり、Moodleコミュニティの統計的全体像を構築することにあります。<p>登録する場合、あなたのサイト名、国、URIがMoodleサイトの公開リストに登録されます。</p>
<p>すべての登録内容は公開リストに登録される前に手作業で確認されますが、一旦登録されるといつでも登録内容 (および公開リストの内容) をこのフォームで再登録することができます。</p>';
$string['registrationinfotitle'] = '登録情報';
$string['registrationno'] = 'いいえ、メールは送信しないでください';
$string['registrationsend'] = 'moodle.orgに登録情報を送信する';
$string['registrationyes'] = 'はい、重要事項を知らせてください';
$string['reject'] = '拒否';
$string['rejectdots'] = '拒否 ...';
$string['reload'] = 'リロード';
$string['remoteappuser'] = 'リモート {$a} ユーザ';
$string['remove'] = '削除';
$string['removeadmin'] = '管理者を削除する';
$string['removecreator'] = 'コース作成者を削除する';
$string['removestudent'] = '学生を削除する';
$string['removeteacher'] = '教師を削除する';
$string['rename'] = 'リネーム';
$string['renamefileto'] = '<b>{$a}</b> を下記名称にリネームする';
$string['report'] = 'レポート';
$string['reports'] = 'レポート';
$string['repositories'] = 'リポジトリ';
$string['requestcourse'] = 'コースをリクエストする';
$string['requestedby'] = 'リクエスト:';
$string['requestedcourses'] = 'リクエストされたコース';
$string['requestreason'] = 'コースリクエストの理由';
$string['required'] = '必須';
$string['requirespayment'] = 'このコースは有料です。';
$string['reset'] = 'リセット';
$string['resetcomponent'] = 'コンポーネント';
$string['resetcourse'] = 'コースをリセットする';
$string['resetinfo'] = 'このページでは活動および他の設定を保持しながら、コースのユーザデータを空にすることができます。下記アイテムを選択して、このページを実行することで、選択されたユーザデータをこのコースから完全に削除しますので注意してください!';
$string['resetnotimplemented'] = 'リセット未実装';
$string['resetstartdate'] = '開講日をリセットする';
$string['resetstatus'] = 'ステータス';
$string['resettask'] = 'タスク';
$string['resettodefaults'] = 'デフォルト値にリセットする';
$string['resortcoursesbyname'] = 'コース名で並び替える';
$string['resource'] = 'リソース';
$string['resourcedisplayauto'] = '自動';
$string['resourcedisplaydownload'] = 'ダウンロードを強制する';
$string['resourcedisplayembed'] = '埋め込み';
$string['resourcedisplayframe'] = 'フレーム';
$string['resourcedisplaynew'] = '新しいウィンドウ';
$string['resourcedisplayopen'] = 'オープン';
$string['resourcedisplaypopup'] = 'ポップアップ';
$string['resources'] = 'リソース';
$string['resources_help'] = 'リソースタイプではほとんどの種類のウェブコンテンツをコース内に追加することができます。';
$string['restore'] = 'リストア';
$string['restorecancelled'] = 'リストアがキャンセルされました。';
$string['restorecannotassignroles'] = 'リストアにはロールを割り当てる必要がありますが、あなたにはパーミッションがありません。';
$string['restorecannotcreateorassignroles'] = 'リストアにはロールを作成または割り当てる必要がありますが、あなたにはパーミッションがありません。';
$string['restorecannotcreateuser'] = 'リストアではバックアップファイルよりユーザ {$a} を作成する必要がありますが、あなたにはパーミッションがありません。';
$string['restorecannotoverrideperms'] = 'リストアにはパーミッションをオーバーライドする必要がありますが、あなたにはパーミッションがありません。';
$string['restorecoursenow'] = 'このコースをリストアする!';
$string['restoredaccount'] = 'リストア済みアカウント';
$string['restoredaccountinfo'] = 'このアカウントは別のサーバからインポートされたため、パスワードが喪失しました。新しいパスワードをメールで設定するには、「続ける」をクリックしてください。';
$string['restorefinished'] = 'リストアが完了しました。';
$string['restoreto'] = 'リストア';
$string['restoretositeadding'] = '警告: あなたはサイトフロントページをリストアしようとしています。サイトフロントページにデータが追加されます!';
$string['restoretositedeleting'] = '警告: あなたはサイトフロントページをリストアしようとしています。最初にサイトフロントページからデータが削除されます!';
$string['restoreuserconflict'] = 'バックアップからユーザ {$a} をリストアすることで衝突が発生してしまいます。';
$string['restoreuserinfofailed'] = 'あなたにはユーザデータをリストアするパーミッションがないため、リストア処理は中止されました。';
$string['restoreusersprecheck'] = 'ユーザデータのチェック';
$string['restoreusersprecheckerror'] = 'ユーザデータのチェックに関して問題が検出されました。';
$string['restricted'] = '使用禁止';
$string['restrictmodules'] = '活動モジュールを制限しますか?';
$string['returningtosite'] = 'アカウントをお持ちの方ですか?';
$string['returntooriginaluser'] = '{$a} に戻る';
$string['revert'] = 'クリア';
$string['role'] = 'ロール';
$string['rolemappings'] = 'ロールマッピング';
$string['rolerenaming'] = 'ロールのリネーム';
$string['rolerenaming_help'] = 'このオプションではあなたのコースで表示されるロール名を変更することができます。ロール表示名のみ変更されます - 実際のロールパーミッションは影響を受けません。新しいロール名はコース参加者ページおよびコース内の様々な場所に表示されます。リネームしたロールが管理者によりコース管理者として選択されたロールの場合、コース一覧においても新しいロール名が表示されます。';
$string['roles'] = 'ロール';
$string['rss'] = 'RSS';
$string['rssarticles'] = '最近の記事のRSS数';
$string['rsserror'] = 'RSSデータの読み込み中にエラーが発生しました。';
$string['rsserrorauth'] = 'あなたのRSSリンクには有効な認証トークンが含まれていません。';
$string['rsserrorguest'] = 'このフィードはデータへのアクセスにゲストアクセスを使用しますが、データを読むためのパーミッションがありません。このフィードのオリジナルロケーション (URI) に有効なユーザでアクセスした後、新しいRSSリンクを取得してください。';
$string['rsstype'] = 'この活動のRSSフィード';
$string['saveandnext'] = '保存して次を表示する';
$string['savechanges'] = '変更を保存する';
$string['savechangesanddisplay'] = '保存して表示する';
$string['savechangesandreturntocourse'] = '保存してコースに戻る';
$string['savecomment'] = 'コメントを保存する';
$string['savedat'] = '保存日時:';
$string['savepreferences'] = '設定を保存する';
$string['saveto'] = '保存先';
$string['scale'] = '評価尺度';
$string['scale_help'] = '活動内のパフォーマンスを評価または評定するために評価尺度が提供されます。評価尺度自体はマイナスからプラスへ、カンマで区切られた数値の並びです。例えば「不満足, 不十分, 平均, 良い, 大変良い, 素晴らしい!」のように定義します。';
$string['scales'] = '評価尺度';
$string['scalescustom'] = 'カスタム評価尺度';
$string['scalescustomcreate'] = '新しい評価尺度を追加する';
$string['scalescustomno'] = 'カスタム評価尺度はまだ作成されていません。';
$string['scalesstandard'] = '標準評価尺度';
$string['scalestandard'] = '標準評価尺度';
$string['scalestandard_help'] = '標準評価尺度はサイト全体およびすべてのコースで利用可能な評価尺度です。';
$string['scalestip'] = 'カスタム評価尺度を作成するためには、コース管理メニューにある「評価尺度..」を使用してください。';
$string['scalestip2'] = 'カスタム評価尺度を作成するには、コース管理メニューにある「評価」リンクをクリックした後、「処理の選択 ... > 編集 > 評価尺度」を選択してください。';
$string['schedule'] = 'スケジュール';
$string['screenreaderno'] = 'No';
$string['screenreaderuse'] = 'スクリーンリーダ';
$string['screenreaderuse_help'] = '有効にした場合、チャット等の様々な場所でさらに利用しやすいインターフェースが提供されます。';
$string['screenreaderyes'] = 'Yes';
$string['screenshot'] = 'スクリーンショット';
$string['search'] = '検索';
$string['searchagain'] = '再検索';
$string['searchbyemail'] = 'メールアドレスで探す';
$string['searchbyusername'] = 'ユーザ名で探す';
$string['searchcourses'] = 'コースの検索';
$string['searchhelp'] = 'あなたは同時に複数の言葉で探すことができます。<br /><br />単語 : テキストの中に含まれる単語を探します。<br />+単語 : 合致する単語を検索します。<br />-単語 : この単語を含まない検索をします。';
$string['search_help'] = 'テキスト中に存在する1つまたはそれ以上の言葉を検索する基本的な検索では空白で区切られた言葉を入力してください。半角2文字より大きな言葉が検索に使用されます。

高度な検索では検索ボックス内に文字を入力せずに検索ボタンをクリックしてください。高度な検索フォームが表示されます。';
$string['searchoptions'] = '検索オプション';
$string['searchresults'] = '検索結果';
$string['sec'] = '秒';
$string['seconds'] = '秒';
$string['secondstotime172800'] = '2日間';
$string['secondstotime259200'] = '3日間';
$string['secondstotime345600'] = '4日間';
$string['secondstotime432000'] = '5日間';
$string['secondstotime518400'] = '6日間';
$string['secondstotime604800'] = '1週間';
$string['secondstotime86400'] = '1日間';
$string['secretalreadyused'] = 'パスワード変更の確認リンクはすでに使用されています。パスワードは変更されませんでした。';
$string['secs'] = '秒';
$string['section'] = 'セクション';
$string['sectionname'] = 'セクション名';
$string['sections'] = 'セクション';
$string['sectionusedefaultname'] = 'デフォルトセクション名を使用する';
$string['seealsostats'] = '関連項目: 統計データ';
$string['select'] = '選択';
$string['selectacountry'] = '国を選択する';
$string['selectall'] = 'すべてを選択する';
$string['selectamodule'] = '活動モジュールを選択してください。';
$string['selectaregion'] = '区を選択する';
$string['selectdefault'] = 'デフォルトを選択する';
$string['selectedfile'] = '選択済みファイル';
$string['selectednowmove'] = '移動するため {$a} 個のファイルが選択されました。<br />移動先フォルダに移動して「ファイルをここに移動する」ボタンをクリックしてください。';
$string['selectfiles'] = 'ファイルを選択する';
$string['selectnos'] = 'すべて「no」を選択する';
$string['selectperiod'] = '期間を選択する';
$string['senddetails'] = '私のログイン情報をメール送信する';
$string['separate'] = '分離';
$string['separateandconnected'] = '分離・関連認識';
$string['separateandconnectedinfo'] = '分離認識および関連認識の理論に基づく評価尺度です。
この理論では私たちが見たり聞いたりすることを評価および学習する、2つの方法を説明しています。
<ul>
<li><strong>分離認識の人</strong> は感情を含まず可能な限り客観的であろうとします。他の人とのディスカッションにおいて、相手の考えの穴を探す論理を使って自分たちの意見を守ることを好みます。</li>
<li><strong>関連認識の人</strong> は他の人に対してより敏感です。また、相手に共感する能力があり、自分が関係できて「相手の立場に立ってものごとを理解できた」と感じるまで話を聞く傾向があります。そして、自分に知識をもたらす他の人の経験を共有することで学ぼうとします。</li>
</ul>';
$string['serverlocaltime'] = 'サーバのシステム時間';
$string['setcategorytheme'] = 'カテゴリテーマの設定';
$string['settings'] = '設定';
$string['shortname'] = '省略名';
$string['shortnamecollisionwarning'] = '[*] = この省略名はすでに他のコースで使用されています。承認されるためには、省略名を変更する必要があります。';
$string['shortnamecourse'] = 'コース省略名';
$string['shortnamecourse_help'] = 'コース省略名はナビゲーションおよびコースのメールメッセージ件名に使用されます。';
$string['shortnametaken'] = '省略名はすでに別のコース ({$a}) で使用されています。';
$string['shortnameuser'] = 'ユーザ省略名';
$string['shortsitename'] = 'サイト省略名 (例 単語)';
$string['show'] = '表示';
$string['showactions'] = '行動の表示';
$string['showadvancedsettings'] = '高度な設定を表示する';
$string['showall'] = 'すべての {$a} を表示する';
$string['showallcourses'] = 'すべてのコースを表示する';
$string['showalltopics'] = 'すべてのトピックを表示する';
$string['showallusers'] = 'すべてのユーザを表示する';
$string['showallweeks'] = 'すべての週を表示する';
$string['showblockcourse'] = 'ブロックを含むコース一覧を表示する';
$string['showcomments'] = 'コメントを表示/非表示する';
$string['showcommentsnonjs'] = 'コメントを表示する';
$string['showgrades'] = '学生に評定表を表示する';
$string['showgrades_help'] = 'コース内の多くの活動では評定を設定することができます。この設定ではコース管理ブロック内の評定リンク経由で学生が自分のコース評定すべてを一覧表示できるかどうか決定します。';
$string['showlistofcourses'] = 'コース一覧を表示する';
$string['showmodulecourse'] = '活動を含むコース一覧を表示する';
$string['showonly'] = '表示限定';
$string['showonlytopic'] = 'トピック {$a} のみ表示する';
$string['showonlyweek'] = '第 {$a} 週のみ表示する';
$string['showperpage'] = '1ページあたりの表示数: {$a}';
$string['showrecent'] = '最新の活動を表示する';
$string['showreports'] = '活動レポートを表示する';
$string['showreports_help'] = '活動レポートではコースに関する活動内容をコース参加者に表示することができます。これらのレポートには参加者の投稿内容および詳細なアクセスログも含まれます。この設定では学生がプロファイルページ経由で自分の活動レポートを閲覧できるかどうか決定します。';
$string['showsettings'] = '設定を表示する';
$string['showtheselogs'] = '選択したログを表示する';
$string['showthishelpinlanguage'] = 'このヘルプを次の言語で表示する: {$a}';
$string['showtopicfromothers'] = 'トピックを表示する';
$string['showweekfromothers'] = '週を表示する';
$string['since'] = '対象範囲';
$string['sincelast'] = '最終ログインより';
$string['site'] = 'サイト';
$string['sitedefault'] = 'サイトデフォルト';
$string['siteerrors'] = 'サイトエラー';
$string['sitefiles'] = 'サイトファイル';
$string['sitefilesused'] = 'このコースで使用されているサイトファイル';
$string['sitehome'] = 'サイトホーム';
$string['sitelegacyfiles'] = 'レガシーサイトファイル';
$string['sitelogs'] = 'サイトログ';
$string['sitenews'] = 'サイトニュース';
$string['sitepages'] = 'サイトページ';
$string['sitepartlist'] = 'あなたには参加者リストを閲覧するために必要なパーミッションがありません。';
$string['sitepartlist0'] = 'サイト参加者リストを閲覧するには、あなたはサイト教師である必要があります。';
$string['sitepartlist1'] = 'サイト参加者リストを閲覧するには、あなたは教師である必要があります。';
$string['sites'] = 'サイト';
$string['sitesection'] = 'トピックセクションを表示する';
$string['sitesettings'] = 'サイト設定';
$string['siteteachers'] = 'サイト教師';
$string['size'] = 'サイズ';
$string['sizeb'] = 'バイト';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'スキップ';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'ソーシャルフォーラム - 最新トピック';
$string['someallowguest'] = 'いくつかのコースはゲストアクセスできます';
$string['someerrorswerefound'] = 'いくつかの情報が未入力または正しくありません。詳細は下記をご覧ください。';
$string['sortby'] = '並び替え';
$string['sortbyx'] = '{$a} の昇順で並び替える';
$string['sortbyxreverse'] = '{$a} の降順で並び替える';
$string['sourcerole'] = 'ソースロール';
$string['specifyname'] = 'あなたは名前を指定する必要があります。';
$string['standard'] = '標準';
$string['starpending'] = '([*] = 承認審査中コース)';
$string['startdate'] = '開講日';
$string['startdate_help'] = 'この設定ではウィークリーフォーマットコースにおける最初の週の開始日を設定します。また、コース活動のログを利用できる最も早い日付も決定します。';
$string['startingfrom'] = '開始日';
$string['startsignup'] = '新しいアカウントを作成する';
$string['state'] = '州/県';
$string['statistics'] = '統計';
$string['statisticsgraph'] = '統計グラフ';
$string['stats'] = '統計';
$string['statslogins'] = 'ログイン';
$string['statsmodedetailed'] = '詳細 (ユーザ) 表示';
$string['statsmodegeneral'] = '概要表示';
$string['statsnodata'] = 'このコースおよび期間の組み合わせで利用できるデータはありません。';
$string['statsnodatauser'] = 'このコース、ユーザおよび期間の組み合わせで利用できるデータはありません。';
$string['statsoff'] = '現在、統計は利用できません。';
$string['statsreads'] = '表示';
$string['statsreport1'] = 'ログイン';
$string['statsreport10'] = 'ユーザ活動';
$string['statsreport11'] = '最も活発なコース';
$string['statsreport12'] = '最も活発なコース (加重)';
$string['statsreport13'] = '最も参加者の多いコース (登録)';
$string['statsreport14'] = '最も参加者の多いコース (閲覧/投稿)';
$string['statsreport2'] = '閲覧 (すべてのロール)';
$string['statsreport3'] = '投稿 (すべてのロール)';
$string['statsreport4'] = 'すべての活動 (すべてのロール)';
$string['statsreport5'] = 'すべての活動 (閲覧および投稿)';
$string['statsreport7'] = 'ユーザ活動 (閲覧および投稿)';
$string['statsreport8'] = 'すべてのユーザの活動';
$string['statsreport9'] = 'ログイン (サイトコース)';
$string['statsreportactivity'] = 'すべての活動 (すべてのロール)';
$string['statsreportactivitybyrole'] = 'すべての活動 (閲覧および投稿)';
$string['statsreportforuser'] = ':';
$string['statsreportlogins'] = 'ログイン';
$string['statsreportreads'] = '閲覧 (すべてのロール)';
$string['statsreporttype'] = 'レポートタイプ';
$string['statsreportwrites'] = '投稿 (すべてのロール)';
$string['statsstudentactivity'] = '学生の活動';
$string['statsstudentreads'] = '学生の閲覧';
$string['statsstudentwrites'] = '学生の投稿';
$string['statsteacheractivity'] = '教師の活動';
$string['statsteacherreads'] = '教師の閲覧';
$string['statsteacherwrites'] = '教師の投稿';
$string['statstimeperiod'] = '期間 - 最後:';
$string['statsuniquelogins'] = 'ユニークログイン';
$string['statsuseractivity'] = 'すべての活動';
$string['statsuserlogins'] = 'ログイン';
$string['statsuserreads'] = '閲覧';
$string['statsuserwrites'] = '投稿';
$string['statswrites'] = '投稿';
$string['status'] = '状態';
$string['stringsnotset'] = '下記の文字は {$a} で定義されていません。';
$string['studentnotallowed'] = '申し訳ございません、このコースには「 {$a} 」として入ることはできません。';
$string['students'] = '学生';
$string['studentsandteachers'] = '学生および教師';
$string['subcategories'] = 'サブカテゴリ';
$string['submit'] = '送信';
$string['success'] = '成功';
$string['summary'] = '要約';
$string['summary_help'] = '要約はトピックまたは週の中の活動を学生が準備するための短いテキストです。テキストはコースページのセクション名の下に表示されます。';
$string['summaryof'] = '{$a} の要約';
$string['supplyinfo'] = '詳細情報';
$string['switchrolereturn'] = '通常のロールに戻る';
$string['switchroleto'] = 'ロールを切り替える ...';
$string['tag'] = 'タグ';
$string['tagalready'] = 'このタグはすでに登録されています。';
$string['tagmanagement'] = 'タグを追加/削除する ...';
$string['tags'] = 'タグ';
$string['targetrole'] = 'ターゲットロール';
$string['teacheronly'] = '{$a} 専用';
$string['teacherroles'] = '{$a} ロール';
$string['teachers'] = '教師';
$string['textediting'] = 'テキスト編集';
$string['texteditor'] = '標準ウェブフォームを使用します';
$string['textformat'] = 'プレインテキストフォーマット';
$string['thanks'] = 'ありがとうございます';
$string['theme'] = 'テーマ';
$string['themes'] = 'テーマ';
$string['themesaved'] = '新しいテーマが保存されました。';
$string['thereareno'] = 'このコースには {$a} がありません。';
$string['thiscategorycontains'] = 'このカテゴリは以下のコンテンツを含みます。';
$string['time'] = '時間';
$string['timezone'] = 'タイムゾーン';
$string['to'] = 'To';
$string['tocreatenewaccount'] = '新しいアカウント作成にスキップする';
$string['today'] = '本日';
$string['todaylogs'] = '本日のログ';
$string['toeveryone'] = '全員';
$string['toomanybounces'] = 'このメールアドレスには多くの宛先不明メールが戻って来ています。続けるにはメールアドレスを<b>変更してください</b>。';
$string['toomanytoshow'] = '表示するユーザが多すぎます。';
$string['toomanyusersmatchsearch'] = '「{$a->search}」に対して合致するユーザ ({$a->count}) が多すぎます。';
$string['toomanyuserstoshow'] = '表示するユーザ ({$a}) が多すぎます。';
$string['toonly'] = '{$a} のみ';
$string['top'] = 'トップ';
$string['topic'] = 'トピック';
$string['topichide'] = '{$a} よりこのトピックを隠す';
$string['topicoutline'] = 'トピックアウトライン';
$string['topicshow'] = '{$a} にこのトピックを表示する';
$string['total'] = '合計';
$string['trackforums'] = 'フォーラム未読管理';
$string['trackforumsno'] = 'いいえ: 私が閲覧した投稿を追跡しません';
$string['trackforumsyes'] = 'はい: 新しい投稿をハイライトしてください';
$string['trysearching'] = '代わりに検索してください。';
$string['turneditingoff'] = '編集モードの終了';
$string['turneditingon'] = '編集モードの開始';
$string['undecided'] = '未決定';
$string['unfinished'] = '未了';
$string['unknowncategory'] = '不明のカテゴリ';
$string['unlimited'] = '無制限';
$string['unpacking'] = '{$a} の解凍';
$string['unsafepassword'] = '安全ではないパスワードです - 他のパスワードを入力してください。';
$string['untilcomplete'] = '完了するまで';
$string['unusedaccounts'] = '{$a} 日以上利用されていないアカウントは自動的に登録抹消されます。';
$string['unzip'] = '展開';
$string['unzippingbackup'] = 'バックアップの展開';
$string['up'] = '上へ';
$string['update'] = '更新';
$string['updated'] = '{$a} を更新しました。';
$string['updatemymoodleoff'] = 'このページのカスタマイズを終了する';
$string['updatemymoodleon'] = 'このページをカスタマイズする';
$string['updatemyprofile'] = 'プロファイルを更新する';
$string['updatesevery'] = '{$a} 秒ごとに更新する';
$string['updatethis'] = 'この {$a} を更新する';
$string['updatethiscourse'] = 'このコースを更新する';
$string['updatinga'] = '{$a} を更新中';
$string['updatingain'] = '{$a->in} の {$a->what} を更新中';
$string['upload'] = 'アップロード';
$string['uploadafile'] = 'ファイルをアップロードする';
$string['uploadcantwrite'] = 'ディスクへのファイル書き込みに失敗しました。';
$string['uploadedfile'] = 'ファイルが正常にアップロードされました。';
$string['uploadedfileto'] = '{$a->file} を {$a->directory} にアップロードしました。';
$string['uploadedfiletoobig'] = '申し訳ございません、ファイルサイズが大きすぎます (上限 {$a} バイト)。';
$string['uploadextension'] = '拡張子を原因としてファイルアップロードが停止しました。';
$string['uploadfailednotrecovering'] = 'ファイル {$a->name} に問題があるため、あなたのファイルは正常にアップロードされませんでした。<br /> この問題に関するログ:<br />{$a->problem}<br />この問題は解消されていません。';
$string['uploadfilelog'] = 'ファイル {$a} のアップロードログ';
$string['uploadformlimit'] = 'アップロードファイルがフォームで設定された最大サイズを超えました。';
$string['uploadlabel'] = 'タイトル:';
$string['uploadnewfile'] = '新しいファイルをアップロードする';
$string['uploadnofilefound'] = 'ファイルが見つかりませんでした - アップロードするファイルを選択しましたか?';
$string['uploadnotallowed'] = 'アップロードは許可されません';
$string['uploadnotempdir'] = '一時ディレクトリがありません。';
$string['uploadoldfilesdeleted'] = 'あなたのアップロードエリア内の古いファイルが削除されました。';
$string['uploadpartialfile'] = 'ファイルは部分的にアップロードされました。';
$string['uploadproblem'] = 'ファイル「 {$a} 」のアップロード中に不明なエラーが発生しました (ファイルサイズが大きすぎると思われます)';
$string['uploadrenamedchars'] = '無効なキャラクターが使用されているため、ファイルが {$a->oldname} から {$a->newname} にリネームされました。';
$string['uploadrenamedcollision'] = '同一名称のファイルが存在するため、ファイルが {$a->oldname} から {$a->newname} にリネームされました。';
$string['uploadserverlimit'] = 'アップロードファイルがサーバで設定された最大サイズを超えました。';
$string['uploadthisfile'] = 'このファイルをアップロードする';
$string['url'] = 'URI';
$string['used'] = '使用';
$string['usedinnplaces'] = '{$a} 箇所で使用';
$string['useforlegacytheme'] = '古いブラウザを使用する';
$string['useformaintheme'] = '最新のブラウザを使用する';
$string['usemessageform'] = 'または、選択した学生に下記のフォームを使用してメッセージを送信してください。';
$string['user'] = 'ユーザ';
$string['userconfirmed'] = '{$a} を承認しました';
$string['usercurrentsettings'] = 'マイプロファイル設定';
$string['userdata'] = 'ユーザデータ';
$string['userdeleted'] = 'このユーザのアカウントは削除されました。';
$string['userdescription'] = '自己紹介';
$string['userdescription_help'] = 'このテキストボックスにはあなた自身に関するテキストを入力することができます。入力した内容は他のユーザが閲覧できるよう、あなたのプロファイルページに表示されます。';
$string['userdetails'] = 'ユーザ詳細';
$string['userfiles'] = 'ユーザファイル';
$string['userlist'] = 'ユーザリスト';
$string['username'] = 'ユーザ名';
$string['usernameemailmatch'] = 'ユーザ名およびメールアドレスが同じユーザに関連していません。';
$string['usernameexists'] = 'このユーザ名はすでに使用されています。他のユーザ名を入力してください。';
$string['usernamelowercase'] = '小文字のみ使用できます。';
$string['usernamenotfound'] = 'ユーザ名がデータベース内に見つかりませんでした。';
$string['usernameoremail'] = 'ユーザ名またはメールアドレスを入力してください。';
$string['usernotconfirmed'] = '{$a} を確認できませんでした。';
$string['userpic'] = 'ユーザ画像';
$string['users'] = 'ユーザ';
$string['userselectorautoselectunique'] = '検索該当ユーザが1名のみの場合、自動的にユーザを選択する';
$string['userselectorpreserveselected'] = '検索に合致しない場合でも、選択したユーザを保持する';
$string['userselectorsearchanywhere'] = 'ユーザ名のどの部分に対しても、検索テキストを一致させる';
$string['usersnew'] = '新しいユーザ';
$string['usersnoaccesssince'] = '次の期間以上活動していない';
$string['userswithfiles'] = 'ファイルを含むユーザ';
$string['useruploadtype'] = 'ユーザアップロードタイプ: {$a}';
$string['userviewingsettings'] = '{$a} のプロファイル設定';
$string['userzones'] = 'ユーザゾーン';
$string['usingexistingcourse'] = '既存のコースを使用する';
$string['valuealreadyused'] = 'この設定値はすでに使用されています。';
$string['version'] = 'バージョン';
$string['view'] = '表示';
$string['viewallcourses'] = 'すべてのコースを表示する';
$string['viewallcoursescategories'] = 'すべてのコースおよびカテゴリを表示する';
$string['viewfileinpopup'] = 'ファイルをポップアップウィンドウに表示する';
$string['viewprofile'] = 'プロファイルを表示する';
$string['views'] = '表示';
$string['viewsolution'] = '解決方法を表示する';
$string['virusfound'] = '管理者の方!  {$a->user} によってコース {$a->course} にアップロードされたファイルにClamAVがウイルスを発見しました。clamscanの出力結果は次のとおりです:';
$string['virusfoundlater'] = '{$a->date} に{$a->filename} というファイル名でコース {$a->course} にあなたがアップロードしたファイルにウイルスが発見されました。あなたのファイルに対して実行された処理の要約です:

{$a->action}

これが提出した課題の場合、あなたの教師が閲覧できるよう再度提出してください。';
$string['virusfoundlateradmin'] = '管理者の方! {$a->date} に{$a->filename} というファイル名でコース {$a->course} へユーザ {$a->user} によってアップロードされたファイルにウイルスが発見されました。感染ファイルに対して実行された処理の要約です:

{$a->action}

ユーザにもウイルスに感染している旨が通知されました。';
$string['virusfoundlateradminnolog'] = '管理者の方! {$a->filename} というファイル名でアップロードされたファイルにウイルスが発見されました。Moodleはアップロードされたファイルのウイルスを駆除することができませんでした。

感染ファイルに対して実行された処理の要約です:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: ウイルスが見つかりました!';
$string['virusfounduser'] = 'あなたがアップロードしたファイル {$a->filename} はウイルスチェッカーによりスキャンされ、ウイルスに感染していることが発見されました!　あなたのファイルは正常にアップロードされませんでした。';
$string['virusplaceholder'] = 'このアップロードファイルにウイルスが含まれていることが検出されました。感染したファイルは移動または削除され、ユーザに感染が通知されました。';
$string['visible'] = '可視性';
$string['visibletostudents'] = '{$a} に表示する';
$string['warningdeleteresource'] = '警告: {$a} はりソースに参照されています。本当にリソースを更新してもよろしいですか?';
$string['webpage'] = 'ウェブページ';
$string['week'] = '週';
$string['weekhide'] = '{$a} よりこの週を隠す';
$string['weeklyoutline'] = 'ウィークリーアウトライン';
$string['weekshow'] = '{$a} にこの週を表示する';
$string['welcometocourse'] = '{$a} へようこそ';
$string['welcometocoursetext'] = '{$a->coursename} へようこそ!

まだプロファイルの編集が終わっていない場合は、受講している皆さんのことを私たちが知ることができるよう、あなたのプロファイルページを編集してください:

 {$a->profileurl}';
$string['whattocallzip'] = 'Zipファイルの名称は?';
$string['whattodo'] = '処理';
$string['windowclosing'] = 'このウィンドウは自動的に閉じられます。自動的に閉じられない場合、ウィンドウを閉じてください。';
$string['withchosenfiles'] = '選択したものを';
$string['withoutuserdata'] = 'ユーザデータを除く';
$string['withselectedusers'] = '選択したユーザに対して ...';
$string['withselectedusers_help'] = '* メッセージを送信する - 1名またはそれ以上の参加者にメッセージを送信します。
* 新しいノートを追加する - 選択した参加者にノートを追加します。
* 共通ノートを追加する - 同じノートを1名以上の参加者に追加します。';
$string['withuserdata'] = 'ユーザデータを含む';
$string['wordforstudent'] = '学生 (単数) に対する呼称';
$string['wordforstudenteg'] = '例 学生、参加者等';
$string['wordforstudents'] = '学生 (複数) に対する呼称';
$string['wordforstudentseg'] = '例 学生、参加者等';
$string['wordforteacher'] = '教師 (単数) に対する呼称';
$string['wordforteachereg'] = '例 教師、チューター、世話役等';
$string['wordforteachers'] = '教師 (複数) に対する呼称';
$string['wordforteacherseg'] = '例 教師、チューター、世話役等';
$string['writingblogsinfo'] = 'ブログ情報の書き出し';
$string['writingcategoriesandquestions'] = 'カテゴリおよび質問の書き出し';
$string['writingcoursedata'] = 'コースデータの書き出し';
$string['writingeventsinfo'] = 'イベント情報の書き出し';
$string['writinggeneralinfo'] = '一般情報の書き出し';
$string['writinggradebookinfo'] = '評定表情報の書き出し';
$string['writinggroupingsgroupsinfo'] = 'グルーピング-グループ情報の書き出し';
$string['writinggroupingsinfo'] = 'グルーピング情報の書き出し';
$string['writinggroupsinfo'] = 'グループ情報の書き出し';
$string['writingheader'] = 'ヘッダの書き出し';
$string['writingloginfo'] = 'ログ情報の書き出し';
$string['writingmessagesinfo'] = 'メッセージ情報の書き出し';
$string['writingmoduleinfo'] = 'モジュール情報の書き出し';
$string['writingscalesinfo'] = '評価尺度情報の書き出し';
$string['writinguserinfo'] = 'ユーザ情報の書き出し';
$string['wrongpassword'] = 'このユーザ名のパスワードは正しくありません。';
$string['xmldbeditor'] = 'XMLDBエディタ';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = '年';
$string['years'] = '年';
$string['yes'] = 'Yes';
$string['youareabouttocreatezip'] = 'あなたは下記ファイルを含んだzipファイルを作成しようとしています';
$string['youaregoingtorestorefrom'] = 'あなたは下記ファイルのリストア処理を開始しようとしています';
$string['youneedtoenrol'] = 'この操作を実行するには、あなたがこのコースに受講登録している必要があります。';
$string['yourlastlogin'] = 'あなたの最終ログイン';
$string['yourself'] = 'あなた自身';
$string['yourteacher'] = 'あなたの {$a}';
$string['yourwordforx'] = '「{$a} 」に対するあなたの呼称';
$string['zippingbackup'] = 'バックアップファイルの圧縮中';
