<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'ja', branch 'MOODLE_20_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'アクセスが拒否されました。';
$string['accounts'] = 'アカウント';
$string['additionalhtml'] = '追加HTML';
$string['additionalhtml_desc'] = 'これらの設定では、あなたがすべてのページに追加したいHTMLを指定することができます。あなたはページのHEADタグ内、BODYタグが開かれた直後、またはBODYタグが閉じられる直前にHTMLを設定することができます。<br />この設定により、すべてのページにカスタムヘッダおよびフッタを追加またはGoogle Analytics のようなサービスのサポートを、あなたが選択したテーマから独立して簡単に追加することができます。';
$string['additionalhtmlfooter'] = 'BODYタグが閉じられる前';
$string['additionalhtmlfooter_desc'] = 'このコンテンツはすべてのページのBODYタグが閉じられる直前に追加されます。';
$string['additionalhtmlhead'] = 'HEADタグ内';
$string['additionalhtmlhead_desc'] = 'このコンテンツはすべてのページのHEADタグの最後に追加されます。';
$string['additionalhtml_heading'] = 'すべてのページに追加される追加HTMLです。';
$string['additionalhtmltopofbody'] = 'BODYタグが開かれる時';
$string['additionalhtmltopofbody_desc'] = 'このコンテンツはすべてのページのBODYタグが開かれた直後に追加されます。';
$string['adminseesall'] = '管理者にすべてを表示する';
$string['adminseesallevents'] = '管理者にすべてのイベントを表示する';
$string['adminseesownevents'] = '管理者は他のユーザと同じ';
$string['advancedfeatures'] = '拡張機能';
$string['allcountrycodes'] = 'すべての国コード';
$string['allowbeforeblock'] = '最初に「許可されるIPアドレスリスト」を参照する';
$string['allowbeforeblockdesc'] = 'デフォルトでは「ブロックIPアドレスリスト」が最初に参照されます。このオプションが有効にされた場合、「ブロックIPアドレスリスト」の前に「許可されるIPアドレスリスト」が参照されます。';
$string['allowblockstodock'] = 'ブロックによるドックの使用を許可する';
$string['allowcategorythemes'] = 'カテゴリテーマを許可する';
$string['allowcoursethemes'] = 'コーステーマを許可する';
$string['allowdeletes'] = '削除を許可する';
$string['allowediplist'] = '許可されるIPアドレスリスト';
$string['allowemailaddresses'] = '許可されるメールアドレスのドメイン';
$string['allowobjectembed'] = 'EMBEDおよびOBJECTタグを許可する';
$string['allowrenames'] = 'リネームを許可する';
$string['allowthemechangeonurl'] = 'テーマ変更URIを許可する';
$string['allowuserblockhiding'] = 'ユーザのブロック非表示を許可する';
$string['allowusermailcharset'] = 'ユーザの文字セット選択を許可する';
$string['allowuserswitchrolestheycantassign'] = '「ユーザにロールを割り当てる」ケイパビリティのないユーザにロールのスイッチを許可する';
$string['allowuserthemes'] = 'ユーザテーマを許可する';
$string['antivirus'] = 'アンチウイルス';
$string['appearance'] = 'アピアランス';
$string['aspellpath'] = 'aspellのパス';
$string['authentication'] = '認証';
$string['authsettings'] = '認証管理';
$string['autolang'] = '言語の自動認識';
$string['autologinguests'] = 'ゲストのオートログイン';
$string['availablelicenses'] = '利用可能なライセンス';
$string['availableto'] = '利用可能';
$string['backgroundcolour'] = '透過色';
$string['backups'] = 'バックアップ';
$string['badwordsconfig'] = '使用禁止用語をカンマで区切って入力してください。';
$string['badwordsdefault'] = '使用禁止用語リストが空白の場合、言語パックからデフォルトリストが使用されます。';
$string['badwordslist'] = '特別使用禁止用語リスト';
$string['blockediplist'] = 'ブロックIPアドレスリスト';
$string['blockinstances'] = 'インスタンス';
$string['blockmultiple'] = '複数設置';
$string['blockprotect'] = '削除から保護する';
$string['blockprotect_help'] = '選択されたブロックインスタンスはサイト全体のコンテクストからの削除より保護されます。これは主に間違って削除された場合に元に戻すことが難しいナビゲーションおよび設定ブロックを保護します。';
$string['blocksettings'] = 'ブロック管理';
$string['blockunprotect'] = '保護なし';
$string['bloglevel'] = 'ブログ可視性';
$string['bloglevelupgrade'] = 'ブログ可視性アップグレード
';
$string['bloglevelupgradedescription'] = '<p>このサイトはMoodle 2.0にアップグレードされました。</p>
<p>2.0にてブログ可視性は単純にされましたが、あなたのサイトはまだ古い可視性タイプを使用しています。</p>
<p>あなたのサイトのブログエントリに関してコースベースまたはグループベースの可視性を保持するには、それぞれのコースに受講登録したユーザが投稿したブログエントリをコピーするための特別な「ブログ」タイプのフォーラムを作成する以下のアップグレードスクリプトを実行する必要があります。</p>
<p>アップグレードスクリプトの実行後、ブログは完全にサイトレベルに移行されます。アップグレード処理によりブログエントリが削除されることはありません。</p>
<p>あなたは<a href="{$a->fixurl}">ブログレベルアップグレードページ</a>にてスクリプトを実行することができます。</p>';
$string['bloglevelupgradeinfo'] = '2.0にてブログ可視性はシンプルにされましたが、あなたのサイトはまだ古い可視性タイプを使用しています。あなたのサイトのブログエントリに関してコースベースまたはグループベースの可視性を保持するには、それぞれのコースに受講登録したユーザが投稿したブログエントリをコピーするための特別な「ブログ」タイプのフォーラムを作成する以下のアップグレードスクリプトを実行する必要があります。アップグレードスクリプトの実行後、ブログは完全にサイトレベルに移行されます。アップグレード処理によりブログエントリが削除されることはありません。';
$string['bloglevelupgradenotice'] = 'あなたのサイトは古いブログ可視性設定を使用しています。<a href="bloglevelupgrade.php">ブログ可視性のアップグレード</a>をお勧めします。';
$string['bloglevelupgradeprogress'] = 'コンバージョン進捗状況: レビュー済みユーザ = {$a->userscount} / コンバージョン済みエントリ数 = {$a->blogcount}';
$string['bookmarkadded'] = 'ブックマークが追加されました。';
$string['bookmarkalreadyexists'] = 'あなたはすでにこのページをブックマークしています。';
$string['bookmarkdeleted'] = 'ブックマークが削除されました。';
$string['bookmarkthispage'] = 'このページをブックマークする';
$string['cachejs'] = 'Javaスクリプトをキャッシュする';
$string['cachejs_help'] = 'Javaスクリプトのキャッシングおよび圧縮によりページローディングのパフォーマンスが大幅に向上します。実運用サイトでの適用を強くお勧めします。開発者はおそらくこの機能を無効にしても良いでしょう。';
$string['cachetext'] = 'テキストキャッシュ保存時間';
$string['cachetype'] = 'キャッシュタイプ';
$string['calendarexportsalt'] = 'カレンダーエクスポートsalt';
$string['calendarsettings'] = 'カレンダー';
$string['calendar_weekend'] = '週末日';
$string['cannotdeletemissingqtype'] = 'システムで必要なため、あなたは不明な問題タイプを削除することはできません。';
$string['cannotdeletemodfilter'] = '「 {$a->module} 」モジュールの一部のため、あなたは「 {$a->filter} 」をアンインストールできません。';
$string['cannotdeleteqtypeinuse'] = 'あなたは問題タイプ「 {$a} 」を削除することはできません。このタイプの問題が問題バンクに登録されています。';
$string['cannotdeleteqtypeneeded'] = 'あなたは問題タイプ「 {$a} 」を削除することはできません。この問題タイプに依存する他の問題タイプがインストールされています。';
$string['cfgwwwrootslashwarning'] = 'あなたはconfig.phpファイルの$CFG->wwwrootを正しく定義していません。あなたは末尾に「/」文字を含めています。「/」文字を取り除いてください。取り除かない場合、<a href="http://tracker.moodle.org/browse/MDL-11061">MDL-11061</a>のようなバグを経験することになります。';
$string['cfgwwwrootwarning'] = 'あなたはconfig.phpファイルの$CFG->wwwroot 正しく定義していません。あなたがこのページにアクセスしているURIと合致しません。URIを修正してください。修正しない場合、<a href="http://tracker.moodle.org/browse/MDL-11061">MDL-11061</a>のようなバグを経験することになります。';
$string['change'] = '変更';
$string['changesitelang'] = 'サイト言語の変更';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Yes';
$string['choosefiletoedit'] = '編集するファイルを選択してください。';
$string['clamfailureonupload'] = 'ClamAVの障害時';
$string['cleanup'] = 'クリーンアップ';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'エラー、「 {$a->option} 」の値「 {$a->value} 」が正しくありません。';
$string['cliincorrectvalueretry'] = '値が正しくありません、再度お試しください。';
$string['clistatusdisabled'] = 'ステータス: 無効';
$string['clistatusenabled'] = 'ステータス: 有効';
$string['clitypevalue'] = '値を入力してください。';
$string['clitypevaluedefault'] = '値を入力してください。デフォルト値 ({$a}) を使用するにはEnterキーを押してください。';
$string['cliunknowoption'] = '不明なオプション:
{$a}
「--help」オプションを使用してください。';
$string['cliupgradefinished'] = 'コマンドラインによるアップグレードが正常に完了しました。';
$string['cliyesnoprompt'] = 'y (yes) または n (no) を入力してください。';
$string['commentsperpage'] = '1ページあたりに表示するコメント数';
$string['commonfiltersettings'] = 'フィルタ共通設定';
$string['commonsettings'] = '共通設定';
$string['componentinstalled'] = 'コンポーネントがインストールされました。';
$string['computedfromlogs'] = '{$a} 以降のログより計算しています。';
$string['condifmodeditdefaults'] = 'ここではあなたが新しい活動を作成する場合に使用される、活動設定フォームのデフォルト値を定義します。また、どの活動設定が「高度な設定」とみなされるのか設定することもできます。';
$string['confeditorhidebuttons'] = 'HTMLエディタで隠すボタンを選択してください。';
$string['configallcountrycodes'] = '例えばユーザプロファイルのように、これは多くの場所で選択することのできる国リストです。空白にした場合 (デフォルト)、標準英語言語パックのcountries.phpのリストが使用されます。このリストはISO 3166-1から作成されます。そうでない場合、例えば「JA,GB,FR,ES」 のように、カンマ区切りのコードのリストを記述することができます。あなたが新しい非標準のコードをここに入力した場合、「en」内のcontries.phpおよびあなたの言語パックに追加する必要があります。';
$string['configallowassign'] = 'あなたは左側に表示されているロールのユーザに対して、いくつかのカラムのロールを他のユーザに割り当てることができるようにします。';
$string['configallowblockstodock'] = 'この設定を有効にした場合、そして選択されたテーマによりサポートされている場合、ユーザはブロックを特別ドックに移動することができます。';
$string['configallowcategorythemes'] = 'この設定を有効にした場合、カテゴリに独自のテーマを設定することができます。独自のテーマが設定されない限り、カテゴリテーマはすべての子カテゴリおよびコースのテーマを上書きします。警告: カテゴリテーマを有効にした場合、パフォーマンスに影響を及ぼします。';
$string['configallowcoursethemes'] = 'この設定を有効にした場合、コースに独自テーマを設定することができます。コーステーマは他のすべてのテーマ (サイト、ユーザ、セッションテーマ) に優先します。';
$string['configallowemailaddresses'] = '新しいメールアドレスすべてを特定のドメインのみに制限したい場合、この欄にスペースで区切って入力してください。他のドメインはすべて拒否されます。サブドメインを許可するには、先頭に「.」を付けたドメインを入力してください。例 <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowobjectembed'] = 'デフォルトのセキュリティ対策として、通常のユーザはマルチメディア (Flash等) をEMBEDおよびOBJECTタグでHTMLに埋め込むことが許可されていません (メディアプラグインフィルタを使用して安全に埋め込むことは可能です)。これらのタグの使用を許可したい場合、このオプションを有効にしてください。';
$string['configallowoverride'] = 'あなたは左側に表示されているロールのユーザに対して、いくつかのカラムのロールをオーバーライドできるようにすることができます。';
$string['configallowoverride2'] = '左側カラム内のロールでオーバライドできるロールを選択してください。<br />これらの設定はケイパビリティ「moodle/role:override」または「moodle/role:safeoverride」を持っているユーザにのみ適用されますので注意してください。';
$string['configallowswitch'] = 'ユーザが持つロールをベースに、どのロールにスイッチできるか選択してください。このテーブルのエントリに加えてロールをスイッチできるようにするには、ユーザが「moodle/role:switchroles」ケイパビリティを持つ必要があります。<br />「moodle/course:vie」wケイパビリティを持ち、「moodle/site:doanything」ケイパビリティを持たないロールにのみスイッチすることができるため、このテーブルのいくつかのカラムは無効にされていることに留意してください。';
$string['configallowthemechangeonurl'] = 'この設定を有効にした場合、MoodleのURIに「theme={themename}」を追加してテーマを変更することができるようになります。';
$string['configallowuserblockhiding'] = 'サイト全体において、ユーザにブロックの表示/非表示を許可しますか? 折りたたみ可能なブロックの状態を記憶するため、この機能はJavaスクリプトおよびクッキーを使用します。また、この設定はユーザ自身の閲覧にのみ影響します。';
$string['configallowusermailcharset'] = 'この設定を有効にした場合、サイトの全ユーザは自分のメール文字コードを指定することができます。';
$string['configallowuserswitchrolestheycantassign'] = 'デフォルトでは「moodle/role:assign」はロールをスイッチするユーザに必要です。この設定を有効にすることで、この必要条件を解除します。また、「ロールを切り替える ...」ドロップダウンメニューで利用できるロールは「ロールの割り当て許可」テーブルの設定のみで決定されることになります。「ロールの割り当て許可」テーブルの設定ではユーザの既存ロールより多くのケイパビリティを持ったロールへの切り替えを許可しないようにすることをお勧めします。';
$string['configallowuserthemes'] = 'この設定を有効にした場合、ユーザは自分のテーマを設定することができます。ユーザテーマはサイトテーマに優先されます (しかし、コーステーマには優先されません)。';
$string['configallusersaresitestudents'] = 'サイトのフロントページにある活動に関して、すべてのユーザを学生と考えてもよろしいですか? この設定を「Yes」にした場合、承認済みユーザアカウントは、学生としてこれらの活動に参加することができます。この設定を「No」にした場合、少なくとも1つのコースに登録しているユーザのみ、フロントページの活動に参加することができます。管理者および特別に割り当てられた教師のみ、これらのフロントページ活動に関して、教師として活動することができます。';
$string['configauthenticationplugins'] = 'あなたが使用したい認証プラグインを選択して、フェイルスルーの順に並び替えてください。';
$string['configautolang'] = 'ブラウザの設定からデフォルト言語を認識します。この設定を有効にしない場合、サイトデフォルトが使用されます。';
$string['configautologinguests'] = '利用者がコースにゲストアクセスした場合、自動的にゲストとしてログインさせますか?';
$string['configbloglevel'] = 'ここではどのユーザブログをこのサイトで閲覧できるか、アクセスレベルを制限することができます。ここで設定するのは閲覧者に関する最大コンテクストであり、投稿者またはブログ記事のタイプではないことに注意してください。不要な場合、ブログを完全に無効にすることもできます。';
$string['configcachetext'] = '規模の大きなサイト、またはテキストフィルタを使用しているサイトでは、この設定で処理速度を上げることができます。ここで指定された期間、処理に適した形でテキストのコピーが保持されます。この値を小さくしすぎると、処理速度を若干落とすことになります。しかし、大きすぎると (例えば新しいリンクを) リフレッシュするまでのテキスト保持期間が長くなります。';
$string['configcachetype'] = 'Moodleが使用するキャッシュタイプを選択してください。ここではキャッシュのみ設定します。キャッシュが使用されるためには、忘れずにレコードキャッシュ (rcache) 設定を有効にしてください。あなたがデータベースシステムのロードを減らしたい場合<strong>のみ</strong>使用してください -- そうでない場合、Moodleの動作が実際に遅くなります。中トラフィックのサイトでは「internal」の選択でメリットがあります。eAcceleratorまたはTurckmmcacheがインストールされ、「shared memoryオプションが有効にされた」単体のウェブサーバでは、「eaccelerator」をお試しください。複数のサーバを使用して、1つまたはそれ以上のmemcachedデーモンが動作およびPHP-memcached拡張モジュールが設定されている場合、「memcached」を選択して、下記のmemachedオプションを設定してください。<br /><strong>注意:</strong> ロード下でパフォーマンスを確認し、それに応じて調整してください -- キャッシュにより、あなたのサイトが遅くなる可能性があります。高トラフィックの場合、eAcceleratorおよびmemcachedの使用に大きなメリットがありますが、ウェブサーバのCPU使用に関して高いコストがかかります。';
$string['configcalendarexportsalt'] = 'このランダムテキストはカレンダーのエクスポート時に使用される認証トークンのセキュリティを改善するため使用されます。あなたがこのハッシュsaltを変更する場合、現在のトークンすべてが無効にされますので注意してください。';
$string['configclamactlikevirus'] = 'ファイルをウイルスとして扱う';
$string['configclamdonothing'] = 'ファイルをウイルス感染なしとして扱う';
$string['configclamfailureonupload'] = 'アップロードファイルをClamがスキャンするよう設定したとして、間違って設定されている、または不明な理由で動作しない場合、あなたはどのように処理しますか? 「ファイルをウイルスとして扱う」を選択した場合、感染ファイルは隔離用エリアに移動されるか、削除されます。「ファイルをウイルス感染なしとして扱う」を選択した場合、通常のファイルと同じように、指定したディレクトリに移動されます。どちらの場合でも、管理者にはClamに問題がある旨が通知されます。「ファイルをウイルスとして扱う」を選択してもClamが正常に動作しない場合 (一般的にClamに間違ったパスを指定)、アップロードされたすべてのファイルは指定された隔離用エリアに移動されるか、削除されます。この設定には注意してください。';
$string['configconvertformat'] = 'latex、dvipsおよびconvertが利用可能な場合、指定されたフォーマットを使用してイメージが作成されます。そうでない場合、mimeTeXによりGIFイメージが作成されます。';
$string['configcookiehttponly'] = 'ブラウザが実HTTPリクエストのみ送信する、PHP 5.2.0の新しい機能を有効にすることで、スクリプト言語からクッキーにアクセスできないようになります。この機能はすべてのブラウザでサポートされているわけではありません。また、現在のコードと完全な互換性はありません。いくつかのタイプのXSSアタックを防ぐためには役立ちます。';
$string['configcookiesecure'] = 'サーバがhttps接続のみ受け付ける場合、セキュアクッキーの送信を有効にすることをお勧めします。有効にした場合、ウェブサーバが http:// を受け付けないこと、または https:// アドレスにパーマネントにリダイレクトされていることを確認してください。<em>wwwroot</em> アドレスが https:// で始まらない場合、この設定は自動的に無効にされます。';
$string['configcountry'] = 'ここで国を設定した場合、新規ユーザアカウントの国のデフォルトとして選択されます。ユーザに自分で国を選ばせる場合、設定しないままにしてください。';
$string['configcourserequestnotify'] = '新しいコースがリクエストされた場合、通知されるユーザのユーザ名を入力してください。';
$string['configcourserequestnotify2'] = '新しいコースがリクエストされた場合、通知されるユーザです。コースリクエストを承認できるユーザのみ、ここに一覧表示されます。';
$string['configcoursesperpage'] = 'コース一覧の1ページあたりに表示するコース数を入力してください。';
$string['configcronclionly'] = 'この設定を有効にした場合、ウェブ経由の代わりにコマンドラインのみでcronスクリプトを実行することができます。この設定は下記のcronパスワード設定をオーバーライドします。';
$string['configcronremotepassword'] = 'cronパスワードを設定した場合、下記の形式のURIを使用してcronパスワードを提供しない限り、ウェブブラウザからcron.phpを動作させることはできません。<pre>
http://site.example.com/admin/cron.php?password=opensesame
</pre>これが空白の場合、パスワードは要求されません。';
$string['configcurlcache'] = 'cURLキャッシュの有効期間 (Time-to-live) を秒で指定してください。';
$string['configcustommenuitems'] = 'あなたはテーマに表示されるカスタムメニューをここで設定することができます。それぞれの行はパイプ文字 (|) によって分離されたメニューテキスト、リンクURI (任意) およびツールチップタイトル (任意) により構成されます。あなたはハイフンを使用して構造を定義することもできます。例えば次のようになります:
<pre>
Moodle community|http://moodle.org
-Moodle free support|http://moodle.org/support
-Moodle development|http://moodle.org/development
--Moodle Tracker|http://tracker.moodle.org
--Moodle Docs|http://docs.moodle.org
-Moodle News|http://moodle.org/news Moodle company
-Moodle commercial hosting|http://moodle.com/hosting
-Moodle commercial support|http://moodle.com/support
</pre>';
$string['configdbsessions'] = 'この設定を有効にした場合、現在のセッション情報はデータベースに保存されます。これは特に規模の大きな/アクセス数の多いサイト、またはクラスタサーバで構築されたサイトに適しています。ほとんどのサイトではこの設定をサーバディスクにセッションを保存する、無効のままにしてください。この設定を変更すると、(あなたも含めて) 現在のユーザがログアウトされます。あなたがMySQLを使用している場合、my.cnf (またはmy.ini) の「max_allowed_packet」を少なくとも4Mにしてください。';
$string['configdebug'] = 'この設定を有効にした場合、PHPのerror_reportingが増加して、より多くの警告が表示されるようになります。これは、開発者のみに便利な設定です。';
$string['configdebugdisplay'] = 'この設定を有効にした場合、エラー報告はHTMLページに表示されます。これは実際、役に立ちますが、一般的にXHTML、JS、cookiesおよびHTTPヘッダを壊します。この設定を無効にした場合、エラー報告がサーバログに記録されて、デバッグしやすくなります。PHP設定のerror_logにて、どのログを記録するかコントロールできます。';
$string['configdebugpageinfo'] = 'この設定を有効にした場合、ページフッタにページ情報が表示されます。';
$string['configdebugsmtp'] = 'メールメッセージがSMTPサーバに送信される間、詳細デバッグ情報を表示します。';
$string['configdebugstringids'] = 'このオプションは翻訳者を手助けするよう作成されました。それぞれ表示されるストリングの横に言語ファイルおよびストリングIDを表示します (この設定を変更した場合、次のページ読み込みからのみ反映されます)。';
$string['configdebugvalidators'] = 'この設定を有効にした場合、フッタに外部Validatorサーバのリンクが表示されます。あなたは新たなユーザ名「w3cvalidator」を作成して、ゲストアクセスを有効にする必要があります。これらの変更により、サーバに対して不正なアクセスを許可してしまうことになります。実稼動サイトでは有効にしないでください!';
$string['configdefaultallowedmodules'] = '上位カテゴリに分類される<b>コースが作成される場合</b>、デフォルトでどのモジュールを許可しますか?';
$string['configdefaulthomepage'] = 'ここではログインユーザのホームページを設定します。';
$string['configdefaultrequestcategory'] = 'ユーザからリクエストされたコースは、自動的にこのカテゴリに配置されます。';
$string['configdefaultrequestedcategory'] = 'リクエストされたコースが承認された場合、コースが設置されるデフォルトカテゴリです。';
$string['configdefaultuserroleid'] = 'すべてのログインユーザにはそれぞれのユーザに与えられるロールに加えて、あなたがここで指定したケイパビリティを持つロールがサイトレベルで与えられます。デフォルトは認証済みユーザロールです。ここでの設定はユーザに与えられているロールと衝突することはなく、すべてのユーザにコースレベルで割り当てできないケイパビリティを割り当てます (例 ブログエントリの投稿、自分のカレンダーの管理等)。';
$string['configdeleteincompleteusers'] = 'この期間終了後、完全にセットアップされていない古いアカウントが削除されます。';
$string['configdeleteunconfirmed'] = 'メールによる認証を利用している場合、この値はユーザからの返答を受けつける期間を指します。この期間終了後、セットアップ未了の古いアカウントが削除されます。';
$string['configdenyemailaddresses'] = '特定ドメインから新しいメールアドレスを拒否したい場合、この欄にスペースで区切って入力してください。他のドメインはすべて認められます。サブドメインを拒否するには設定値の先頭に「.」を追加してください。例  <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdigestmailtime'] = 'メール送信を選択したユーザに、投稿内容を要約したメールが毎日送信されます。ここでは1日の内で何時に要約メールを送信するか設定します (この設定後に実行される次のcronがメールを送信します)。';
$string['configdisableuserimages'] = 'ユーザがユーザプロファイルイメージを変更できないようにします。';
$string['configdisplayloginfailures'] = 'ここで選択したユーザに対して、前回のログイン失敗情報を表示します。';
$string['configdocroot'] = 'Moodle Docsのパスを定義します。あなたが独自のオンラインドキュメントを使用したい場合、この設定を変更することができます。設定を変更する場合、ドキュメンテーションのパスがhttp://docs.moodle.orgと同じフォーマットであることを確認してください。';
$string['configdoctonewwindow'] = 'この設定を有効にした場合、新しいウィンドウにMoodle Docsの内容が表示されます。';
$string['configeditordictionary'] = 'この値はAspellがユーザ言語の辞書を持っていない場合に使用されます。';
$string['configeditorfontlist'] = 'エディタのドロップダウンリストに表示されるフォントを選択してください。';
$string['configemailchangeconfirmation'] = 'ユーザがプロファイルでメールアドレスを変更した場合、メール確認ステップを求めます。';
$string['configenableajax'] = 'ここではサイト全体におけるAJAX (Javaスクリプトを使用した高度なクライアント/サーバインターフェース) の使用をコントロールできます。この設定を有効にした場合、ユーザはプロファイルページでAJAXの使用を選択できます。この設定を無効にした場合、すべてのユーザに対して、AJAXの使用が無効にされます。';
$string['configenablecalendarexport'] = 'カレンダーのエクスポートまたは購読を有効にします。';
$string['configenablecomments'] = 'コメントを有効にします。';
$string['configenablecourserequests'] = 'すべてのユーザにコース作成のリクエストを許可します。';
$string['configenableglobalsearch'] = 'ここではリソースおよび活動のグローバルテキストサーチを有効にします。この設定はPHP4での互換性はありません。';
$string['configenablegroupmembersonly'] = 'この設定を有効にした場合、グループメンバーのみに活動へのアクセスを制限することができます。この設定により、あなたのサーバの負荷を増大させることになります。加えて活動を非グループメンバーより隠すため、評定表カテゴリを特別な方法でセットアップする必要があります。';
$string['configenablehtmlpurifier'] = '信頼できないテキストのクリーニングに関して、KSESの代わりにHTML Purifierを使用します。HTML Purifierは活発に開発され、さらにセキュアだと考えられていますが、リソースに負荷がかかります。HTML Purifierでは表示されるHTMLコードに若干の違いが生じると予想されます。embedおよobjectタグを有効にできないこと、MathMLタグおよび古いlangタグがサポートされないことに留意してください。';
$string['configenablerssfeeds'] = 'ここではサイト全体のRSSフィードを有効にします。RSSフィードの更新を実際に表示したい場合、各モジュールのRSSフィード設定も有効にする必要があります - サイト管理にあるモジュール管理を確認してください。';
$string['configenablerssfeedsdisabled'] = 'サイトすべてにおいてRSSフィードが利用不可にされているため、利用できません。管理メニュー内の詳細設定にて、RSSフィードを利用可にすることができます。';
$string['configenablerssfeedsdisabled2'] = 'RSSフィードはサーバレベルで無効にされています。あなたは最初に「サーバ > RSS」にて、RSSを有効にする必要があります。';
$string['configenablesafebrowserintegration'] = 'この設定を有効にした場合、小テスト設定の「ブラウザセキュリティ」フィールドに「Safe Exam Browserの使用を必要とする」を追加します。詳細は、http://www.safeexambrowser.org/ をご覧ください。';
$string['configenablestats'] = 'この設定を有効にした場合、Moodleのcronジョブがログを処理して統計情報を集めます。あなたのサイトのトラフィックにより、しばらく時間がかかる場合があります。このオプションを有効にした場合、あなたの各コースまたはサイト全体に関して、面白いグラフおよび統計データを閲覧することができます。';
$string['configenabletrusttext'] = 'デフォルトではMoodleは常にユーザによりアップロードされたセキュリティ上のリスクのある悪意を持ったスクリプト、メディア等をテキストから完全にクリーニングしています。コンテンツ信頼システムでは特定のユーザによるコンテンツに対して、干渉しない拡張機能を適用することができます。このシステムを動作させるには最初にこの設定を有効にした後、個別のMoodleロールにコンテンツ信頼パーミッションを与える必要があります。このようなユーザにより作成またはアップロードされたテキストには信頼されている旨のマークが付けられ、表示前にクリーニングされることはありません。';
$string['configenablewebservices'] = 'ウェブサービスでは他のシステムがこのMoodleにログインして操作できるようにします。セキュリティのため、あなたが本当に使用したい場合以外、この機能を無効にしてください。';
$string['configenablewsdocumentation'] = 'ウェブサービスドキュメンテーションの自動生成を有効にします。ユーザは「セキュリティキー」ページにて、ドキュメンテーションにアクセスすることができます。有効にされたプロトコルのドキュメンテーションのみ表示されます。';
$string['configerrorlevel'] = '表示したいPHPの警告数を選択してください。通常はNormalが最適な選択です。';
$string['configexcludeoldflashclients'] = 'いくつかのAdobe Flashでは悪意を持ったFlashコンテンツにより、脆弱性を突いた攻撃を受ける可能性があることを知られています。あなたはここでサポートするバージョンの最低限度を指定することができます。ここで指定したバージョンより古いバージョンの場合、MoodleはFlashファイルを表示しません。代わりにアップグレード方法に関する代替Flashファイルが表示されます。すべてのチェックを無効にするにはここを空のままにしてください。';
$string['configextendedusernamechars'] = 'この設定を有効にした場合、学生はユーザ名にどのような文字でも使用することができます (実際の名前には影響しません)。デフォルトは英数字小文字、アンダースコア (_)、ハイフン (-)、ピリオド (.) またはアットマーク (@) の使用を制限する「無効」です。';
$string['configextramemorylimit'] = '検索、バックアップ/リストアまたはcronのようなスクリプトではさらなるメモリを必要とします。規模の大きなサイトでは設定値を上げてください。';
$string['configextrauserselectorfields'] = '例えば、ロールの割り当て、グループの割り当てに関してユーザを選択する場合、フルネームに加えて、どのフィールドを検索および表示するか選択します。セキュリティ上の理由から、ここでユーザ名フィールドを選択するのは賢明ではないことに留意してください。';
$string['configfilterall'] = 'ヘッダ、タイトル、ナビゲーションバー等を含むすべての文字をフィルタします。これは多言語フィルタを使用しているときに最も有用です。そうでない場合、あなたのサイトに単に負荷がかかるだけになります。';
$string['configfiltermatchoneperpage'] = 'オートリンクフィルタはページ全体で最初のテキストマッチングに該当した1つのテキストリンクのみ生成します。他のすべては無視されます。';
$string['configfiltermatchonepertext'] = 'オートリンクフィルタはそれぞれのアイテムのページテキスト (例 リソース、ブロック) で最初のテキストマッチングに該当した1つのテキストリンクのみ生成します。「1ページあたり1回フィルタマッチする」が有効にされている場合、この設定は無視されます。';
$string['configfilteruploadedfiles'] = '「すべてのファイル」はアップロードしたすべてのHTMLおよびテキストファイル、「HTMLファイルのみ」はアップロードしたHTMLファイルのみ、表示する前にフィルタをかけます。「なし」は全くフィルタをかけません。';
$string['configforcelogin'] = '通常、サイトおよびコース一覧 (コースではなく) のフロントページは、サイトにログインせずに閲覧することができます。すべての前にログインを強制したい場合、この設定を有効にしてください。';
$string['configforceloginforprofiles'] = 'この設定ではユーザプロファイルページの閲覧に関して、(ゲストではない) 実アカウントでのログインをユーザに強制します。この設定を無効にした場合、ユーザが広告 (スパム) を投稿、または他の不適切なコンテンツをプロファイルに投稿して、世界中から閲覧できる可能性があります。';
$string['configframename'] = 'Moodleをフレーム内で使用する場合、ここでフレーム名を指定してください。フレームを使用しない場合、この値を「_top」のままにしてください。';
$string['configfrontpage'] = '上で選択したアイテムはサイトフロントページに表示されます。';
$string['configfrontpageloggedin'] = '上で選択したアイテムはユーザログイン時、サイトフロントページに表示されます。';
$string['configfullnamedisplay'] = 'ここでは氏名がどのように表示されるか設定します。単一言語を使用したほとんどのサイトでは「名 + 姓」を使用した方が良いでしょう。しかし、あなたは姓を隠したり、現在の言語パックが指定したままにすることも可能です (いくつかの言語では異なる並びとなります)。';
$string['configgdversion'] = 'インストールされているGDのバージョンを選択してください。デフォルト値として表示されているバージョンは自動判別されたものです。あなたが何をしているのか分からない場合、そのままにしてください。';
$string['configgeoipfile'] = 'GeoIP Cityバイナリデータファイルのロケーションです。このファイルはMoodleディストリビューションの一部ではなく、<a href="http://www.maxmind.com/">MaxMind</a>から個別に取得する必要があります。あなたは商用バージョンを購入、または無料バージョンを使用することができます。<br />無料バージョンの場合、<a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz">http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a>からダウンロードして、あなたのサーバの「 {$a} 」ディレクトリに解凍してください。';
$string['configgetremoteaddrconf'] = 'あなたがリバースプロクシの背後にサーバを設置している場合、リモートIPアドレスを含んだ信頼できるHTTPヘッダを指定することができます。ヘッダは順番に読まれ、最初の有効なヘッダが使用されます。';
$string['configgooglemapkey'] = 'IPアドレスのルックアップを視覚化するため利用するGoogle Mapsの特殊キーを入力してください。あなたは<a href="http://code.google.com/apis/maps/signup.html">http://code.google.com/apis/maps/signup.html</a>より、キーを無償で取得することができます。<br />あなたのウェブサイトURIは: {$a}';
$string['configgradebookroles'] = 'ここでは誰が評定表に表示されるか設定することができます。ユーザがコース評定表で表示されるためには、これらの中から少なくとも１つのロールを割り当ててください。';
$string['configgradeexport'] = 'どの評定表エクスポートフォーマットをあなたの主要な評定表エクスポート方法にするか選択してください。選択されたフォーマットのプラグインが設定され、すべての評定の「最新エクスポート」フィールドに使用されます。例えば、エクスポートされたレコードは「新規」または「更新」レコードとして認識されます。この設定に関して、あなたに自信がない場合、すべてをチェックしないままにしてください。';
$string['confighiddenuserfields'] = 'あなたがコース教師/管理者以外のユーザに隠したいユーザ情報フィールドを選択してください。この設定により、ユーザのプライバシーを強化することができます。複数フィールドを選択するにはCTRLキーを押したままにしてください。';
$string['configidnumber'] = 'このオプションでは次の内容を設定します。(a)ユーザがユーザIDの入力を求められない、(b)ユーザがユーザIDを空白にすることができる、(c)ユーザはユーザIDの入力を求められ、空白にできない。ユーザIDが入力された場合、ユーザのプロファイルに表示されます。';
$string['configintcachemax'] = 'この値は内部キャッシュのみに使用します。キャッシュに保持する最大レコード数です。推奨値は50です。 メモリ使用量を減らすには値を低くしてください。';
$string['configintro'] = 'このページではあなたのサーバでMoodleが最適に動くための設定値を入力できます。設定値を過度に心配しないでください - 通常、デフォルト値で最適に動作するよう設定されています。いつでもこのページに戻って再度設定することができます。';
$string['configintroadmin'] = 'このページではサイトすべてを管理できる最高管理者アカウントを作成します。正しいメールアドレスおよび安全なユーザ名、パスワードを設定してください。あなたは後でさらに管理者アカウントを作成することができます。';
$string['configintrosite'] = 'このページではこの新しいサイトのフロントページおよびサイト名を設定します。管理メニューを使用することで、いつでもここに戻って、これらの設定を変更することができます。';
$string['configintrotimezones'] = 'ここでは世界のタイムゾーン情報 (夏時間ルールを含む) を検索して、あなたのローカルデータベースを更新します。次のロケーションが順番にチェックされます: {$a} この処理は一般的に非常に安全であり、標準インストールのMoodleを壊すことはありません。タイムゾーン情報を更新してもよろしいですか?';
$string['configiplookup'] = 'あなたがログ等でIPアドレス (例 34.12.222.93) をクリックした場合、そのIPアドレスがどこから来たものなのか推量しやすいマップが表示されます。この機能にはあなたが選択できる異なるプラグインがあり、それぞれに利点と不利点があります。';
$string['configjabberhost'] = 'Jabber メッセージ通知を送信するために接続するサーバです。';
$string['configjabberpassword'] = 'Jabberサーバへの接続時に使用するパスワードです。';
$string['configjabberport'] = 'Jabberサーバへの接続時に使用するポートです。';
$string['configjabberserver'] = 'XMPPホストID (Jabberホストと同じ場合、空白のままにすることができます)';
$string['configjabberusername'] = 'Jabberサーバへの接続時に使用するユーザ名です。';
$string['configkeeptagnamecase'] = 'ユーザが入力したタグ名の大文字小文字を保持したい場合、この設定を有効にしてください。';
$string['configlang'] = 'サイト全体に適用されるデフォルト言語を選択してください。ユーザは言語設定メニューまたはパーソナルプロファイルにより、この設定をオーバーライドすることができます。';
$string['configlangdir'] = 'ほとんどの言語は左から右に記述されますが、アラビア語およびヘブライ語等は、右から左に記述されます。';
$string['configlanglist'] = 'ここを空白にすることで、インストールしたMoodleのすべての言語をユーザが選択することができるようになります。カンマで区切ることにより、言語メニューを短くすることができます。例: ja,en,es_es,fr,it';
$string['configlangmenu'] = '汎用の言語選択メニューをホームページ、ログイン画面等に表示するかどうか選択してください。この設定はユーザがユーザプロファイルで表示言語を選択することに影響を及ぼしません。';
$string['configlangstringcache'] = 'すべての言語ファイルをデータディレクトリ内のコンパイル済みファイル内にキャッシュします。あなたがMoodleを翻訳またはMoodleソースコード内のストリングを変更した場合、無効にしてください。それ以外は、パフォーマンスを向上させるために有効のままにしてください。';
$string['configlatinexcelexport'] = 'Excelエクスポートのエンコーディングを選択してください。';
$string['configlocale'] = 'サイト全体に適用されるロケールを選択してください - この設定はすべての言語パックの日付の書式および言語を上書きします (カレンダーの曜日には影響しません)。あなたのオペレーティングシステムにロケールデータがインストールされている必要があります (例 linuxの場合、ja_JP.UTF-8、en_US.UTF-8、es_ES.UTF-8)。 ほとんどの場合、このフィールドは、空白のままにしてください。';
$string['configloginhttps'] = 'この設定を有効にした場合、Moodleはログインページのみでセキュアhttps接続 (セキュアログイン) を使用します。その後、一般的な速度を保つため、通常のhttp URIに戻ります。警告: この設定ではウェブサーバのhttpsを厳密に有効にする必要があります。httpsが有効ではない状態でこの設定を有効にした場合、あなたは自分のサイトから閉め出されることになります。';
$string['configloglifetime'] = 'ここではユーザの活動に関するログの保持期間を設定します。指定した値より古いログは自動的に削除されます。あなたが必要な場合、可能な限り長い間ログを保持することをお勧めしますが、アクセス件数が多く、サーバのパフォーマンスに問題がある場合、ログの保持期間を短い期間に設定してください。統計が正常に動作しないため、30以下の値はお勧めできません。';
$string['configlookahead'] = '直近イベント日';
$string['configmailnewline'] = 'メールメッセージに使用される改行文字です。RFC 822bisによるとCRLFは必須です。いくつかのメールサーバでは自動的にLFがCRLFに変換され、他のメールサーバではCRLFがCRCRLFに誤って変換され、また、生のLFを拒否するメールサーバ (例えば、qmail) もあります。メールが送信されなかったり、改行が2重になる問題がある場合、この設定を変更してください。';
$string['configmaxbytes'] = 'ここではサイト全体でアップロードできるファイルの最大サイズを設定します。この設定はPHP設定のpost_max_sizeおよびupload_max_filesize、同様にApache設定のLimitRequestBodyに制限されます。maxbytesはコースレベルまたはモジュールレベルで選択できるサイズの範囲を制限します。「サーバリミット」が選択された場合、サーバで設定された最大値が使用されます。';
$string['configmaxconsecutiveidentchars'] = 'パスワードにはこの値以上の連続した同一文字を使用することができません。このチェックを無効にするには、ゼロを指定してください。';
$string['configmaxeditingtime'] = 'ここではフォーラム投稿、用語集コメント等を編集可能な時間を設定します。通常30分が適切な値です。';
$string['configmaxevents'] = '直近イベント数';
$string['configmemcachedhosts'] = 'memcached用の設定です。memcachedデーモンを動作させるホスト一覧をカンマで区切って入力してください。DNSの遅延を避けるには、IPアドレスを使用してください。動作中のMoodleからホストを追加/削除した場合、memcachedが正常に機能しない場合があります。';
$string['configmemcachedpconn'] = 'memcached用の設定です。持続的接続を使用します。慎重に設定してください - memcachedデーモンの再起動後、Apache/PHPをクラッシュする可能性があります。';
$string['configmessaging'] = 'サイトユーザ間でメッセージシステムを利用できるようにしますか?';
$string['configmessagingdeletereadnotificationsdelay'] = 'スペースを空けるため、未読通知を削除することができます。どのくらいの期間の後、未読通知を削除しますか?';
$string['configmessaginghidereadnotifications'] = 'メッセージ履歴を閲覧する場合、フォーラム投稿のようなイベント未読通知を隠します。';
$string['configminpassworddigits'] = 'パスワードには少なくともここで設定した数の数字を使用する必要があります。';
$string['configminpasswordlength'] = 'パスワードは少なくともここで設定した長さである必要があります。';
$string['configminpasswordlower'] = 'パスワードには少なくともここで設定した数の小文字を使用する必要があります。';
$string['configminpasswordnonalphanum'] = 'パスワードには少なくともここで設定した数の非英数字を使用する必要があります。';
$string['configminpasswordupper'] = 'パスワードには少なくともここで設定した数の大文字を使用する必要があります。';
$string['configmycoursesperpage'] = 'ユーザ自身のコース一覧に表示される最大コース数です。';
$string['configmymoodleredirect'] = 'この設定では管理者以外のユーザがログインした場合、強制的に「/my」へリダイレクトします。また、トップレベルのサイトナビゲーションを「/my」に置き換えます。';
$string['configmypagelocked'] = 'この設定により、非管理者からデフォルトページが編集されることを防ぎます。';
$string['confignavcourselimit'] = 'ここではユーザが未ログインまたはコースに登録していない場合に表示されるコース数を制限します。';
$string['confignavshowallcourses'] = 'この設定を有効にした場合、サイト内のコースすべてがナビゲーションに常に表示されます。';
$string['confignavshowcategories'] = 'ナビゲーションバーおよびナビゲーションブロックにコースカテゴリを表示します。この設定変更は現在ユーザが登録しているコースには反映されません。これらのコースでのナビゲーションバーおよびナビゲーションブロックはカテゴリなしのマイコース下に表示されます。';
$string['confignoreplyaddress'] = 'Moodleではユーザに代わってメールが送信される場合があります (例 フォーラムの投稿)。ここで設定するメールアドレスは「From」に使用され、受信者が直接送信者に返信できないようにします (例 ユーザが自分のメールアドレスを隠すよう設定している場合)。';
$string['confignotifyloginfailures'] = 'ログイン失敗が記録された場合、メール通知を送信することができます。誰が通知を受け取りますか?';
$string['confignotifyloginthreshold'] = 'ログイン失敗通知が有効の場合、同一ユーザまたはIPアドレスで何回ログインに失敗することで通知を送信しますか?';
$string['confignotloggedinroleid'] = 'サイトにログインしていないユーザはサイトコンテクストに関して、このロールが割り当てられているかのように扱われます。ほとんどの場合、あなたがここで割り当てるロールは「ゲスト」で十分ですが、権限を減らしたロールまたはさらに制限されたロールを作成することもできます。それでもフォーラムへの投稿等はユーザが適切にログインする必要があります。';
$string['configopentogoogle'] = 'この設定を有効にした場合、Googleはあなたのサイトにゲストとして入ることができます。加えてGoogleが自動的に記録したデータを元に、他の人がゲストとしてあなたのサイトにアクセスできます。これはすでにゲストアクセスを許可しているコースのみ、透過アクセスを提供することに留意してください。';
$string['configoverride'] = 'config.phpで設定済み';
$string['configpasswordpolicy'] = 'この設定を有効にすることで、パスワードポリシーを基にMoodleがユーザパスワードの妥当性をチェックします。あなたのポリシーを指定するため、下記設定を使用してください (この設定を無効にした場合、下記設定は無視されます)。';
$string['configpathtoclam'] = 'ClamAVのパスを指定してください。おそらく /usr/bin/clamscan または /usr/bin/clamdscan のようになります。あなたがClamAVを動作させるためには、ClamAVのパスを指定する必要があります。';
$string['configpathtodu'] = 'duのパスを指定してください。おそらく /usr/bin/du のようになります。あなたがduのパスを設定した場合、多くのファイルを含んだディレクトリに関してディレクトリコンテンツを表示するページの表示速度がはるかに速くなります。';
$string['configperfdebug'] = 'この設定を有効にした場合、パフォーマンス情報がスタンダードテーマのフッタに表示されます。';
$string['configprofileroles'] = 'ユーザプロファイルおよび参加者ページにて閲覧可能なロールの一覧です。';
$string['configprofilesforenrolledusersonly'] = 'スパム送信者による乱用を避けるため、コースに受講登録されていないユーザに関するプロファイルの自己紹介欄が非表示にされます。プロファイルの自己紹介欄にコンテンツを追加するには、新しいユーザは少なくとも1つのコースに受講登録する必要があります。';
$string['configprotectusernames'] = 'デフォルトでは、forget_password.phpはユーザ名またはメールアドレスを推測できるヒントを表示しません。';
$string['configproxybypass'] = 'プロクシをバイパスするホスト名 (一部) またはIPアドレスのカンマ区切り一覧です (例 192.168., .mydomain.com)。';
$string['configproxyhost'] = '<b>サーバ</b>のインターネットアクセスにプロクシ (例 ファイアーウォール) が必要な場合、プロクシのホスト名を入力してください。必要でない場合、空白にしてください。';
$string['configproxypassword'] = 'プロクシ経由でインターネットにアクセスする必要がある場合、パスワードを入力してください。必要でない場合、空白にしてください (PHP cURL拡張モジュールが必要です)。';
$string['configproxyport'] = 'サーバがプロクシの使用を必要とする場合、ここにプロクシのポート番号を入力してください。';
$string['configproxytype'] = 'ウェブプロクシのタイプです (SOCKS5をサポートするには、PHP5およびcURL拡張モジュールが必要です)。';
$string['configproxyuser'] = 'プロクシ経由でインターネットにアクセスする必要がある場合、ユーザ名を入力してください。必要でない場合、空白にしてください (PHP cURL拡張モジュールが必要です)。';
$string['configquarantinedir'] = 'ClamAVによって感染ファイルを隔離用ディレクトリに移動させたい場合、そのディレクトリを指定してください。このディレクトリはウェブサーバより書き込みができるようにする必要があります。空白にした場合、または存在しないか、書き込み権がないディレクトリを指定した場合、感染ファイルは削除されます。末尾にスラッシュを付けないでください。';
$string['configrcache'] = 'データベースレコードを保存するため、キャッシュを使用します。忘れずに「キャッシュタイプ」も設定してください!';
$string['configrcachettl'] = 'キャッシュレコードの有効期間 (秒)です。ここでは15秒より小さな値を使用してください。';
$string['configrecaptchaprivatekey'] = 'あなたのMoodleサーバとrecaptcha.netサーバの通信に使用する文字列です。このサイト用にhttp://www.google.com/recaptchaで取得してください。';
$string['configrecaptchapublickey'] = 'サインアップフォームでreCAPTCHA要素を表示するときに表示される文字列です。http://www.google.com/recaptchaで生成されます。';
$string['configrequestedstudentname'] = 'リクエストされたコースで使用する学生 (単数) に対する呼称';
$string['configrequestedstudentsname'] = 'リクエストされたコースで使用する学生 (複数) に対する呼称';
$string['configrequestedteachername'] = 'リクエストされたコースで使用する教師 (単数) に対する呼称';
$string['configrequestedteachersname'] = 'リクエストされたコースで使用する教師 (複数) に対する呼称';
$string['configrequiremodintro'] = 'あなたがそれぞれのユーザに活動説明の入力を強制したくない場合、このオプションを無効にしてください。';
$string['configrestrictbydefault'] = '上位カテゴリに分類される新しく作成されたコースにおいて、モジュールをデフォルトで制限しますか?';
$string['configrestrictmodulesfor'] = 'どのコースでいくつかの活動モジュールを無効に<b>設定</b>しますか? この設定は教師にのみ適用されることに留意してください。管理者はどのような活動でもコースに追加することができます。';
$string['configrunclamavonupload'] = 'この設定を有効にした場合、すべてのアップロードファイルをスキャンするためにClamAVが使用されます。';
$string['configrunclamonupload'] = 'ファイルアップロード時にClamAVを動作させますか? 正常に動作させるにはpathtoclamに正しいパスを入力する必要があります (ClamAVは次の場所で入手できる無料ウイルススキャナです: http://www.clamav.net/)。';
$string['configsectioninterface'] = 'インターフェース';
$string['configsectionmail'] = 'メール';
$string['configsectionmaintenance'] = 'メンテナンス';
$string['configsectionmisc'] = 'その他';
$string['configsectionoperatingsystem'] = 'オペレーティングシステム';
$string['configsectionpermissions'] = 'パーミッション';
$string['configsectionrequestedcourse'] = 'コースリクエスト';
$string['configsectionsecurity'] = 'セキュリティ';
$string['configsectionstats'] = '統計';
$string['configsectionuser'] = 'ユーザ';
$string['configsecureforms'] = 'フォームデータを受入れる場合、Moodleでは追加的なレベルのセキュリティを使用することができます。この設定を有効にした場合、ブラウザのHTTP_REFERER変数とフォーム設置のアドレスが照合されます。 ユーザがファイアーウォールソフト (例 Zonealarm) を使用してトラフィックからHTTP_REFERERを取除く設定をしている場合、まれに問題が生じる場合があります。 これはフォーム使用時に画面が「固まる」現象です。例えば、ユーザがログインページで問題を抱えている場合、この設定をNoにしてください。しかし、この設定ではあなたのサイトがブルートフォース・パスワードアタックに対して、無防備な状態になります。分からない場合、この設定を「Yes」のままにしてください。';
$string['configsessioncookie'] = 'ここではMoodleセッションで使用されるクッキーの名称をカスタマイズします。1つ以上のMoodleが同じウェブサイトで稼動している場合、クッキーが混乱するのを防ぐためだけに、この設定を任意でお使いください。';
$string['configsessioncookiedomain'] = 'ここではMoodleクッキーが利用できるドメインを変更します。これは別のサブドメインのウェブアプリケーションとMoodleセッションを共有する必要のある特別なMoodle (例 認証または登録プラグイン) に有用です。<strong>警告: この設定をデフォルト (空) のままにすることを強くお勧めします - 正しくない値を設定することで、すべてのユーザがサイトにログインできなくなります。</strong>';
$string['configsessioncookiepath'] = 'ブラウザが送信するMoodleクッキーの場所を変更したい場合、ここでウェブサイトのサブディレクトリを指定することができます。変更しない場合、デフォルトの「/」を使用してください。';
$string['configsessiontimeout'] = 'このサイトにログインして長時間何もしない (ページを読み込まない) 場合、ユーザを自動的にログアウト (セッションを終了) させます。この変数には、ログアウトさせるまでの時間を設定します。';
$string['configshowcommentscount'] = 'コメントカウントを表示します。コメントリンクの表示時にさらに1つのクエリ実行による負荷がかかります。';
$string['configshowsiteparticipantslist'] = 'サイトすべての学生および教師がサイト参加者リストに表示されます。誰がこのサイト参加者リストを閲覧することができますか?';
$string['configsitedefaultlicense'] = 'デフォルトサイトライセンス';
$string['configsitedefaultlicensehelp'] = 'デフォルトライセンスはこのサイトのコンテンツを公開するため使用されます。';
$string['configsitemailcharset'] = 'あなたのサイトで生成されたすべてのメールは、ここで指定した文字コードで送信されます。次の設定が有効にされた場合、ユーザは自分の文字コードを指定することができます。';
$string['configsitemaxcategorydepth'] = '最大カテゴリ深度';
$string['configsitemaxcategorydepthhelp'] = 'ここでは表示される子カテゴリの最大深度を設定します。';
$string['configslasharguments'] = 'ファイル (イメージ、アップロード等) は、スラッシュを使ってスクリプト経由で受け渡されます。この方法により、簡単にブラウザ、プロクシ等にイメージを一時保存させることができます。いくつかのPHPサーバではこの方法が取れない場合があります。もし、アップロードされたファイルまたはイメージ (例 ユーザ画像) の表示に問題がある場合、この設定を無効にしてください。';
$string['configsmartpix'] = 'この設定を有効にした場合、PHPスクリプトが現在のテーマ、そしてすべてのテーマ、最後にMoodle/pixフォルダを検索して、アイコンを表示します。これにより、テーマ間の重複するイメージファイルを減らすことができますが、パフォーマンスにおいてわずかな負荷がかかります。';
$string['configsmtphosts'] = 'Moodleでメールを送信するときに使用する、1つ以上のローカルSMTPサーバ名を入力してください (例 mail.a.comまたはmail.a.com;mail.b.com)。デフォルト以外のポート (例 ポート25以外) を指定するには、[サーバ]:[ポート]シンタックスを使用することができます (例 mail.a.com:587)。空白にした場合、MoodleはデフォルトのPHPメール送信メソッドを使用します。';
$string['configsmtpmaxbulk'] = 'SMTPセッションごとに送信するメッセージの最大数です。メッセージのグルーピングにより、メールの送信をスピードアップすることができます。2より少ない値に設定した場合、メールごとに新しいSMTPセッションの開始が強制されます。';
$string['configsmtpuser'] = '上でSMTPサーバを設定し、なおかつ認証が必要な場合、ユーザ名およびパスワードを入力してください。';
$string['configstartwday'] = '週の始め';
$string['configstatsfirstrun'] = 'ここではcronジョブが<b>最初の</b>統計処理で、どのくらい過去にさかのぼるか指定します。トラフィックが多く、共有ホスティングを利用している場合、あまりにも過去にさかのぼることは良い考えではありません。統計処理は長時間を必要とし、リソースに過大な負荷がかかります (この設定では1ヵ月 = 28日となりますので注意してください。グラフおよびレポートの生成には1ヶ月 = 1カレンダー月が利用されます)。';
$string['configstatsmaxruntime'] = '統計処理ではサーバに大きな負荷がかかる場合があります。このオプションおよび次のオプションの組み合わせで、「いつ」および「どのくらい」稼動させるか設定してください。';
$string['configstatsmaxruntime2'] = '統計処理ではサーバに大きな負荷がかかる場合があります。1日の統計データの収集で許可する最大時間を指定してください。1回のcron実行で処理できる最大日数は「31」です。';
$string['configstatsmaxruntime3'] = '1日のうち、統計の計算に許される最大時間を指定してください。統計処理はサーバに対して大きな負荷がかかることに留意してください。1つのcronで処理する最大日数は次の設定で指定することができます。';
$string['configstatsruntimedays'] = 'それぞれの統計処理で処理する最大日数を指定してください。統計が最新の場合、1日のみ処理されますので、あなたのサーバの負荷に応じて設定値を調整してください。cron実行間隔が短い場合、この値を小さくしてください。';
$string['configstatsruntimestart'] = '何時にcronジョブの統計処理を<b>開始</b>させますか? 1つの物理サーバに複数のMoodleをインストールしている場合、異なる時間を指定してください。';
$string['configstatsuserthreshold'] = 'この設定では統計計算に含まれるコースの登録ユーザ最少数を指定します。';
$string['configstrictformsrequired'] = '有効にした場合、フォームの必須フィールドにスペースまたは改行を入力できないようにします。';
$string['configstripalltitletags'] = 'この設定を無効にした場合、活動およびリソース名において、HTMLタグの使用を許可します。';
$string['configsupportemail'] = 'このメールアドレスは一般的なサポート (例えば、ユーザが自分の新しいアカウントを作成する) が必要な場合、このサイトのユーザに公開されます。この欄を空白のままにした場合、そのような有益なメールアドレスは提供されません。';
$string['configsupportname'] = 'サポートメールまたはウェブ経由で一般的なサポートを提供する人の名前または団体の名称です。';
$string['configsupportpage'] = 'このウェブアドレスは、一般的なサポート (例えば、ユーザが自分の新しいアカウントを作成する) が必要な場合、このサイトのユーザに公開されます。この欄を空白のままにした場合、リンクは提供されません。';
$string['configthemedesignermode'] = '通常パフォーマンスのため、すべてのテーマイメージおよびスタイルシートは長期間ブラウザおよびサーバ内にキャッシュされます。あなたがテーマをデザインまたはコードを開発している場合、キャッシュされたバージョンを表示しないため、この設定を有効にしてください。警告: この設定により、あなたのサイトがすべてのユーザに対して遅くなります! 代わりに「テーマセレクタ」ページにて手動でテーマキャッシュをクリアすることができます。';
$string['configthemelist'] = '空白にした場合、すべてのテーマを使用することができます。テーマメニューを短くしたい場合、カンマで区切ったテーマ名を入力してください (テーマ名に空白を使用しないでください!)。例: standard,orangewhite';
$string['configtimezone'] = 'ここではデフォルトタイムゾーンを設定することができます。これは日付表示のためのデフォルトタイムゾーンを設定するのみで、各ユーザはプロファイル設定画面にて、ここで設定されたタイムゾーンを変更することができます。「サーバのシステム時間」を選択することにより、オペレーティングシステムの時間設定をMoodleのデフォルトにします。これに対して、ユーザプロファイル設定画面のタイムゾーンで選択する「サーバのシステム時間」では、ここで設定したタイムゾーンをユーザデフォルトにします。時刻に依存するcronジョブは、このタイムゾーンを使用して実行されます。';
$string['configunzip'] = 'unzipプログラムのパスを指定してください (Unix/Linuxのみ、任意)。パスを指定した場合、サーバ内のzipファイル解凍時に使用されます。空白にした場合、Moodleは内部ルーチンを使用します。';
$string['configuseblogassociations'] = 'ユーザがブログエントリをコースおよびコースモジュールに関連付けることができるようにしますか?';
$string['configuseexternalyui'] = 'ローカルファイルを使用する代わりに、Yahooサーバで利用可能なオンラインファイルを使用します。警告: この設定にはインターネット接続が必要です。そうでない場合、あなたのサイトでAJAXは動作しません。';
$string['configuserquota'] = 'ユーザがプライベートファイルエリアに保存することのできる最大バイト数です。{$a->bytes} バイト == {$a->displaysize}';
$string['configusetags'] = 'サイト全体でタグ機能を有効にしますか?';
$string['configvariables'] = '詳細設定';
$string['configverifychangedemail'] = '変更済みメールアドレスの確認に関して、「許可されるメールアドレスのドメイン」および「拒否されるメールアドレスのドメイン」設定を使用します。この設定が無効にされた場合、新しいユーザ作成時のみ、ドメインが強制されます。';
$string['configvisiblecourses'] = '非表示のカテゴリ内に通常どおりコースを表示します。';
$string['configwarning'] = 'これらの設定は慎重に変更してください - 間違った設定はトラブルの原因となります。';
$string['configxmlstrictheaders'] = 'この設定を有効にした場合、それぞれのページはXML httpヘッダrおよびprologを使用して生成されるため、ブラウザには、XHTMLエラーがインライン表示されます。これは開発者のみに有用です。';
$string['configyuicomboloading'] = 'このオプションによりYUIライブラリの入出力共用ファイルのローディングを最適化することができます。パフォーマンスの理由から、実運用サイトではこの設定を有効にすべきです。';
$string['configzip'] = 'zipプログラムのパスを指定してください (Unix/Linuxのみ、任意)。パスを指定した場合、サーバ内のzip書庫作成時に使用されます。空白にした場合、Moodleは内部ルーチンを使用します。';
$string['confirmation'] = '確認';
$string['confirmdeletecomments'] = '本当にコメントを削除してもよろしいですか?';
$string['confirmed'] = '確認済み';
$string['confirminstall'] = 'あなたは言語パック ({$a}) をインストールしようとしています。本当によろしいですか?';
$string['convertformat'] = '<i>convert</i> 出力フォーマット';
$string['cookiehttponly'] = 'HTTPクッキーのみ';
$string['cookiesecure'] = 'セキュアクッキーのみ';
$string['country'] = 'デフォルトの国';
$string['coursecontact'] = 'コース管理者';
$string['coursecontact_desc'] = 'ここでは誰がコース説明に表示されるか設定することができます。ユーザをコース説明に表示するには、これらの中から少なくとも１つのコースロールを割り当ててください。';
$string['coursemgmt'] = 'コースを追加/編集する';
$string['courseoverview'] = 'コース概要';
$string['courserequestnotify'] = 'コースリクエスト通知';
$string['courserequestnotifyemail'] = 'ユーザ {$a->user} が {$a->link} に新しいコースをリクエストしました。';
$string['courserequests'] = 'コースリクエスト';
$string['courserequestspending'] = '保留中のコースリクエスト';
$string['courses'] = 'コース';
$string['coursesperpage'] = '1ページあたりのコース数';
$string['creatornewroleid'] = '新しいコースにおけるコース作成者のロール';
$string['creatornewroleid_help'] = 'ユーザに新しいコースを管理するパーミッションがない場合、このロールを使用して自動的に受講登録されます。';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'コマンドラインのみでcronを実行する';
$string['cronerrorclionly'] = '申し訳ございません、このページへのインターネットアクセスは管理者より無効にされています。';
$string['cronerrorpassword'] = '申し訳ございません、あなたはこのページへアクセスするための有効なパスワードを入力していません。';
$string['cron_help'] = 'cron.phpメンテナンススクリプトは新しいフォーラム投稿のコピーをメール送信する等、スケジュールベースでMoodleモジュールによるタスク実行をサポートします。例えば5分ごとのように、スクリプトを定期的に実行させる仕組みが必要です。';
$string['cronremotepassword'] = 'リモートアクセスのcronパスワード';
$string['cronwarning'] = '<a href="cron.php">cron.phpメンテナンススクリプト</a>が少なくとも24時間稼動していません。';
$string['csvdelimiter'] = 'CSVデリミタ';
$string['ctyperecommended'] = 'あなたのサイトが特に非ラテン言語をサポートしている場合、サイトパフォーマンスを改善するため、PHP ctype拡張モジュールのインストールを強くお勧めします。';
$string['ctyperequired'] = 'サイトパフォーマンスの改善および多言語サポートを提供するため、MoodleではPHP ctype拡張モジュールが必須です。';
$string['curlcache'] = 'cURLキャッシュTTL';
$string['curlrecommended'] = 'Moodleネットワーキング機能を有効にするため、cURLライブラリのインストールを強くお勧めします。';
$string['curlrequired'] = 'Moodleリポジトリと通信するため、MoodleではPHP cURL拡張モジュールが必須です。';
$string['curltimeoutkbitrate'] = 'cURLタイムアウト計算時のビットレート (Kbps)';
$string['curltimeoutkbitrate_help'] = 'この設定では大きなcURLリクエストに対する適切なタイムアウトを計算します。この計算の一部として、コンテンツのサイズを決定するため、HTTP HEADリクエストが作成されます。この設定を「0」にした場合、すべてのHEADリクエストを無効にします。';
$string['customcheck'] = 'その他のチェック';
$string['custommenu'] = 'カスタムメニュー';
$string['custommenuitems'] = 'カスタムメニューアイテム';
$string['datarootsecurityerror'] = '<p><strong>セキュリティ警告!</strong></p><p>あなたのデータディレクトリは適切ではない場所にあるため、ウェブにさらされています。これは、あなたの個人ファイルを世界中の誰でも利用でき、あなたのサイトに対して、クラッカーが不正に管理アクセスできることを意味します!</p>
<p>あなたはデータディレクトリ ({$a}) を公開ウェブディレクトリ以外の新しい場所に移動すべきです。それに応じて、あなたのconfig.phpの「<code>$CFG->dataroot</code>」設定を変更してください。</p>';
$string['datarootsecuritywarning'] = 'あなたのサイト設定は安全ではない可能性があります。datarootディレクトリ ({$a}) がウェブから直接アクセスできないことを確認してください。';
$string['dbmigrate'] = 'Moodleデータベース移行';
$string['dbmigrateconnecerror'] = '指定されたデータベースに接続できませんでした。';
$string['dbmigrateencodingerror'] = '指定されたデータベースのエンコードは必須のユニコード/UTF8とは異なり、{$a} となっています。<br />他のエンコードを指定してください。';
$string['dbmigratepostgres'] = 'あなたはデータベースサーバとして、PostgreSQLを使用しているようです。移行処理を続けるには、移行データを保存するため「ユニコード」 (PostgreSQL 7) または「UTF8」 (PostgreSQL 8) の新たなデータベースを手動で作成してください。続けるには、以下に新たなデータベース接続設定を入力してください:';
$string['dbmigratewarning'] = 'この処理を始める前に、Moodleデータベースをバックアップしたか確認してください。バックアップの方法が分からない場合、システム管理者にご連絡ください。移行プロセス開始後、あなたのMoodleサイトはメンテナンスモードに変更されます。';
$string['dbmigratewarning2'] = '<b>警告: あなたはデータベース移行処理を開始しようとしています。すべてのMoodleデータベースをバックアップしているか、確実に確認してください。</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">このデータベースは廃止され、新しいUTF8データベースに移行されました。このMoodleに新しいデータベースを使用するため、config.phpを編集してください。</font>';
$string['dbmigrationdupfailed'] = 'データベース重複エラー:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'セッション情報にデータベースを使用する';
$string['dbtest'] = 'DB機能テスト';
$string['debug'] = 'デバッグメッセージ';
$string['debugall'] = 'ALL: すべての妥当なPHPデバッグメッセージを表示する';
$string['debugdeveloper'] = 'DEVELOPER: 開発者のための特別Moodleデバッグメッセージ';
$string['debugdisplay'] = 'デバックメッセージを表示する';
$string['debugging'] = 'デバッグ';
$string['debugminimal'] = 'MINIMAL: 致命的なエラーのみ表示する';
$string['debugnone'] = 'NONE: デバッグ情報を表示しない';
$string['debugnormal'] = 'NORMAL: エラー、警告および注意を表示する';
$string['debugpageinfo'] = 'ページ情報を表示する';
$string['debugsmtp'] = 'デバッグメール送信';
$string['debugstringids'] = '言語ストリングのオリジンを表示する';
$string['debugvalidators'] = 'Validatorリンクを表示する';
$string['defaultallowedmodules'] = 'デフォルトで許可するモジュール';
$string['defaultcity'] = 'デフォルトの都道府県';
$string['defaultcity_help'] = 'ここに入力した都道府県は新しいユーザアカウント作成時のデフォルトの都道府県となります。';
$string['defaulthomepage'] = 'ユーザのデフォルトホームページ';
$string['defaultrequestcategory'] = 'コースリクエストのデフォルトカテゴリ';
$string['defaultsettinginfo'] = 'デフォルト: {$a}';
$string['defaultuserroleid'] = 'すべてのユーザのデフォルトロール';
$string['defaultvalues'] = 'デフォルト値';
$string['deleteerrors'] = '削除エラー';
$string['deletefilterareyousure'] = '本当にフィルタ「 {$a} 」を削除してもよろしいですか?';
$string['deletefilterareyousuremessage'] = 'あなたはフィルタ「 {$a} 」を削除しようとしています。本当にアンインストールしてもよろしいですか?';
$string['deletefilterfiles'] = 'データベースより「 {$a->filter} 」フィルタに関連する、すべてのデータが削除されました。削除を完了する (およびフィルタの再インストールを防ぐ) ため、あなたのサーバからこのディレクトリを削除する必要があります: {$a->directory}';
$string['deleteincompleteusers'] = '不完全なユーザを削除する日数';
$string['deleteqtypeareyousure'] = '本当に問題タイプ「 {$a} 」を削除してもよろしいですか?';
$string['deleteqtypeareyousuremessage'] = 'あなたは問題タイプ「 {$a} 」を完全に削除しようとしています。本当にアンインストールしてもよろしいですか?';
$string['deleteunconfirmed'] = 'セットアップ未了のユーザを削除する日数';
$string['deleteuser'] = 'ユーザを削除する';
$string['deletingfilter'] = 'フィルタ「 {$a} 」の削除中';
$string['deletingqtype'] = '問題タイプ「 {$a} 」の削除中';
$string['density'] = '密度';
$string['denyemailaddresses'] = '拒否されるメールアドレスのドメイン';
$string['development'] = '開発';
$string['digestmailtime'] = '要約メールを送信する時間 (時)';
$string['disableuserimages'] = 'ユーザプロファイルイメージを無効にする';
$string['displayerrorswarning'] = 'いくつかのエラーメッセージではあなたのサーバに関する機密情報を公開する場合があるため、実稼動サイトでのPHP設定「display_errors」の有効化はお勧めできません。';
$string['displayloginfailures'] = 'ログイン失敗を表示する';
$string['docroot'] = 'Moodle Docsドキュメントルート';
$string['doctonewwindow'] = '新しいウィンドウに開く';
$string['download'] = 'ダウンロード';
$string['editennotallowed'] = 'このページでは言語ファイル「en_utf8」を編集することはできません。ローカルに切り替えてください。';
$string['edithelpdocs'] = 'ヘルプドキュメントの編集';
$string['editingnoncorelangfile'] = 'あなたはアドオンモジュール/プラグインの翻訳済み言語ファイルを修正しようとしています。あなたはサードパーティの翻訳言語ファイルを_localフォルダのみに保存することができます。サードパーティの翻訳済み言語ファイルはモジュールの言語ディレクトリに移動するか、アドオンモジュールの管理者に送信してください。';
$string['editlang'] = '<b>編集</b>';
$string['editorbackgroundcolor'] = '背景色';
$string['editordictionary'] = 'エディタディレクトリ';
$string['editorfontfamily'] = 'フォントファミリー';
$string['editorfontlist'] = 'フォント一覧';
$string['editorfontsize'] = 'フォントサイズ';
$string['editorhidebuttons'] = 'ボタンの非表示';
$string['editorkillword'] = 'ワードフォーマットフィルタ';
$string['editorspelling'] = 'エディタスペリング';
$string['editorspellinghelp'] = 'ここではスペルチェックをするかどうか設定します。有効にした場合、サーバに<strong>aspell</strong> をインストールする必要があります。';
$string['editstrings'] = '翻訳ストリングを編集する';
$string['emailchangeconfirmation'] = 'メール変更確認';
$string['emoticonalt'] = '代替テキスト';
$string['emoticoncomponent'] = 'イメージコンポーネント';
$string['emoticonimagename'] = 'イメージ名';
$string['emoticons'] = 'エモーティコン';
$string['emoticons_desc'] = 'このフォームではあなたのサイトで使用されるエモーティコン (またはスマイリー) を定義します。テーブルから行を削除するには、すべての必須フィールドを空白にして保存してください。新しいエモーティコンを追加するには、最後の空白行のフィールドに必要事項を入力してください。すべてのフィールドをデフォルト値にリセットするには、上記リンクをクリックしてください。

* テキスト (必須) - このテキストはエモーティコンイメージと置換されます。少なくとも半角2文字を入力してください。
* イメージ名 (必須) - コンポーネントpixフォルダ内のエモーティコンイメージファイル名 (拡張子なし) です。
* イメージコンポーネント (必須) - アイコンを提供するコンポーネントです。
* 代替テキスト (任意) - ストリング識別子およびエモーティコン代替テキストのコンポーネントです。';
$string['emoticonsreset'] = 'エモーティコン設定をデフォルト値にリセットする';
$string['emoticontext'] = 'テキスト';
$string['emptysettingvalue'] = '空';
$string['enableajax'] = 'AJAXを有効にする';
$string['enablecalendarexport'] = 'カレンダーエクスポートを有効にする';
$string['enablecomments'] = 'コメントを有効にする';
$string['enablecourseajax'] = 'AJAXコース編集を有効にする';
$string['enablecourseajax_desc'] = 'メインコース編集時にAJAXの使用を許可します。コースフォーマットおよびテーマにてAJAX編集をサポートしている必要があること、ユーザもプロファイルにてAJAXを有効にする必要があることに留意してください。';
$string['enablecourserequests'] = 'コースリクエストを有効にする';
$string['enableglobalsearch'] = 'グローバルサーチを有効にする';
$string['enablegroupmembersonly'] = '「グループメンバーのみ利用可」を有効にする';
$string['enablehtmlpurifier'] = 'HTML Purifierを有効にする';
$string['enablerecordcache'] = 'レコードキャッシュを有効にする';
$string['enablerssfeeds'] = 'RSSフィードを有効にする';
$string['enablesafebrowserintegration'] = 'Safe Exam Browserインテグレーションを有効にする';
$string['enablestats'] = '統計を有効にする';
$string['enabletrusttext'] = 'コンテンツ信頼を有効にする';
$string['enablewebservices'] = 'ウェブサービスを有効にする';
$string['enablewsdocumentation'] = 'ウェブサービスドキュメンテーション';
$string['encoding'] = 'エンコーディング';
$string['enrolinstancedefaults'] = '登録インスタンスデフォルト';
$string['enrolinstancedefaults_desc'] = '新しいコースのデフォルト登録設定';
$string['enrolmultipleusers'] = 'ユーザを受講登録する';
$string['environment'] = '動作環境';
$string['environmenterrortodo'] = 'このバージョンのMoodleをインストールする前に、発見された動作環境の問題 (エラー) を解消してください!';
$string['environmenterrorupgrade'] = '警告: このバージョンのMoodleをアップグレードする前に、発見された動作環境の問題 (エラー) を解消してください! これらの必要条件を修正せずにアップグレードした場合、データ喪失等の問題が生じる可能性があります。本当にアップグレードを続けてもよろしいですか?';
$string['environmentmustfixsetting'] = 'PHP設定を必ず変更してください。';
$string['environmentok'] = 'あなたのサーバ環境は最小限の必要条件すべてに合致します。';
$string['environmentrecommendcustomcheck'] = 'このテストに不適合の場合、潜在的な問題が存在することを意味します。';
$string['environmentrecommendinstall'] = '最適な動作のため、インストールおよび有効化してください。';
$string['environmentrecommendversion'] = 'バージョン {$a->needed} 以上を推奨します。あなたは現在 {$a->current} を使用しています。';
$string['environmentrequirecustomcheck'] = 'このテストにパスする必要があります。';
$string['environmentrequireinstall'] = '必ずインストールおよび有効化してください。';
$string['environmentrequireversion'] = 'バージョン {$a->needed} 以上が必須です。あなたは現在 {$a->current} を使用しています。';
$string['environmentsettingok'] = '推奨設定が検出されました。';
$string['environmentshouldfixsetting'] = 'PHP設定を変更してください。';
$string['environmentxmlerror'] = '環境データ ({$a->error_code}) の読み込み中にエラーが発生しました。';
$string['errordeletingconfig'] = 'プラグイン「 {$a} 」の設定レコード削除中にエラーが発生しました。';
$string['errors'] = 'エラー';
$string['errorsetting'] = '設定を保存できませんでした:';
$string['errorwithsettings'] = 'エラーが発生したため、いくつかの設定は変更されませんでした:';
$string['everyonewhocan'] = '「 {$a} 」ことができるユーザすべて';
$string['exceptions'] = '例外';
$string['excludeoldflashclients'] = '必須Flashプレイヤーバージョン';
$string['experimental'] = '実験用';
$string['experimentalsettings'] = '実験用設定';
$string['extendedusernamechars'] = 'ユーザ名に拡張文字を許可する';
$string['extramemorylimit'] = '特別PHPメモリ制限';
$string['extrauserselectorfields'] = 'ユーザの選択、検索および表示';
$string['fatalmagicquotesruntime'] = '<p>深刻な設定エラーが見つかりました、サーバ管理者に報告してください。</p><p>適切に動作させるため、Moodleは管理者によるPHP設定変更を必要とします。</p><p><code>magic_quotes_runtime</code>を<code>off</code>にしてください。</p><p>この設定は<code>php.ini</code>、Apache/IIS <br />設定またはサーバの<code>.htaccess</code>ファイルの編集によりコントロールすることができます。</p>';
$string['fatalsessionautostart'] = '<p>深刻な設定エラーが見つかりました、サーバ管理者に報告してください。</p><p>適切に動作させるため、Moodleは管理者によるPHP設定変更を必要とします。</p><p><code>session.auto_start</code>を<code>off</code>にしてください。</p><p>この設定は<code>php.ini</code>、Apache/IIS <br />設定またはサーバの<code>.htaccess</code>ファイルの編集によりコントロールすることができます。</p>';
$string['filecreated'] = '新しいファイルが作成されました。';
$string['filestoredin'] = '言語ファイルを保存するフォルダ:';
$string['filestoredinhelp'] = 'ファイルが保存される場所';
$string['filterall'] = 'すべての文字をフィルタする';
$string['filtermatchoneperpage'] = '1ページあたり1回フィルタマッチする';
$string['filtermatchonepertext'] = 'テキストあたり1回フィルタマッチする';
$string['filters'] = 'フィルタ';
$string['filtersettings'] = 'フィルタ設定';
$string['filtersettingsgeneral'] = '一般フィルタ設定';
$string['filteruploadedfiles'] = 'アップロードファイルをフィルタする';
$string['forcelogin'] = 'ユーザのログインを強制する';
$string['forceloginforprofileimage'] = 'ユーザ閲覧時にユーザのログインを強制する';
$string['forceloginforprofileimage_help'] = 'この設定を有効にした場合、ユーザプロファイル写真の閲覧時にユーザはログインする必要があります。また、すべての通知メールにおいて、デフォルトのユーザ写真が使用されます。';
$string['forceloginforprofiles'] = 'プロファイル閲覧時にユーザのログインを強制する';
$string['forcetimezone'] = 'デフォルトタイムゾーンを強制する';
$string['framename'] = 'フレーム名';
$string['frontpage'] = 'フロントページ';
$string['frontpagebackup'] = 'フロントページバックアップ';
$string['frontpagedefaultrole'] = 'デフォルトのフロントページロール';
$string['frontpagefilters'] = 'フロントページフィルタ';
$string['frontpageloggedin'] = 'ログイン時のフロントページアイテム';
$string['frontpageoverrides'] = 'フロントページパーミッションのオーバーライド';
$string['frontpagequestions'] = 'フロントページ問題';
$string['frontpagerestore'] = 'フロントページリストア';
$string['frontpageroles'] = 'フロントページロール';
$string['frontpagesettings'] = 'フロントページ設定';
$string['fullnamedisplay'] = 'フルネームフォーマット';
$string['gdrecommended'] = 'GD拡張モジュールはユーザプロファイルイメージ等のイメージ変換に使用されます。GD拡張モジュールが設定されない場合、この機能を利用できません。';
$string['gdversion'] = 'GDバージョン';
$string['generalsettings'] = '一般設定';
$string['geoipfile'] = 'GeoIP Cityデータファイル';
$string['getremoteaddrconf'] = '記録されるIPアドレスのソース';
$string['globalsquoteswarning'] = '<p><strong>セキュリティ警告</strong>: Moodleを適切に動作させるため、<br />現在のPHP設定を変更する必要があります。<p/><p><code>register_globals=off</code> および/または <code>magic_quotes_gpc=on</code> の<em>設定を行って</em>ください。<br />可能でしたら、一般的なサーバセキュリティを改善するため、<code>register_globals=off</code> の設定を行ってください。<br />また、<code>magic_quotes_gpc=on</code> の設定も推奨します。<p/><p>これらの設定は、<code>php.ini</code>、Apache/IIS <br />設定、または <code>.htaccess</code> ファイルの編集により管理することができます。</p>';
$string['globalswarning'] = '<p><strong>セキュリティ警告</strong>: Moodleを適切に動作させるため、<br />あなたは、現在のPHP設定を変更する必要があります。<p/><p><code>register_globals=off</code>に設定してください。</p><p>この設定は、<code>php.ini</code>、Apache/IIS <br />設定、または<code>.htaccess</code>ファイルの編集により管理することができます。</p>';
$string['googlemapkey'] = 'Google Maps API キー';
$string['gotofirst'] = '最初の未翻訳ストリングに移動する';
$string['gradebook'] = '評定表';
$string['gradebookroles'] = '評定表のロール';
$string['gradeexport'] = '主要な評定表エクスポート方法';
$string['groupenrolmentkeypolicy'] = 'デフォルト登録キーポリシー';
$string['groupenrolmentkeypolicy_desc'] = 'この設定を有効にすることで、パスワードポリシーに基づきMoodleがグループ登録キーをチェックするようにします。';
$string['guestroleid'] = 'ゲストのロール';
$string['guestroleid_help'] = 'このロールは自動的にゲストユーザに割り当てられます。また、パスワードなしで受講できるコースにゲスト登録プラグイン経由で入ったユーザに対しても一時的に割り当てられます。';
$string['helpadminseesall'] = '管理者はカレンダーイベントすべてを閲覧または自分自身のイベントとすることができますか?';
$string['helpcalendarsettings'] = 'Moodleのカレンダーおよび日付/時間に関する様々な設定を行います。';
$string['helpforcetimezone'] = 'ここではユーザに独自のタイムゾーンを選択させることができます。または、すべてのユーザに対してタイムゾーンを強制します。';
$string['helpsitemaintenance'] = 'アップグレードやその他の作業時に使用します。';
$string['helpstartofweek'] = '何曜日をカレンダーの週の始めとしますか?';
$string['helpupcominglookahead'] = '何日前のイベントをデフォルトで直近イベントとして表示しますか?';
$string['helpupcomingmaxevents'] = 'デフォルトで直近イベントを最大何件ユーザに表示しますか?';
$string['helpweekenddays'] = '何曜日を「週末」として異なる色で表示しますか?';
$string['hiddenuserfields'] = 'ユーザフィールドを隠す';
$string['hidefromall'] = 'ユーザすべてに対して非表示にする';
$string['hidefromnone'] = '誰に対しても非表示にしない';
$string['hidefromstudents'] = '学生に対して非表示にする';
$string['htmleditor'] = 'HTMLエディタ';
$string['htmleditorsettings'] = 'HTMLエディタ設定';
$string['htmlsettings'] = 'HTML設定';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTPセキュリティ';
$string['iconvrecommended'] = 'より良いパフォーマンスを得るため、ICONVライブラリのインストールを強くお勧めします。あなたのサイトが非ラテン言語をサポートしている場合、特にお勧めします。';
$string['iconvrequired'] = 'ICONV拡張モジュールのインストールが必須です。';
$string['ignore'] = '無視';
$string['importlangreminder'] = 'データベース移行処理が開始しました。アップグレードを有効にするには、<b>再度ログイン</b>する必要があります。データベース移行処理が<b>完了した後</b>、可能な限り早く、「管理 -> 言語設定 -> 言語インポートユーティリティ」からユニコード言語パックをインストールしてください。';
$string['importtimezones'] = 'タイムゾーンリストの更新';
$string['importtimezonescount'] = '{$a->source} より {$a->count} 件のエントリがインポートされました。';
$string['importtimezonesfailed'] = 'ソースが見つかりませんでした! (悪いお知らせです)';
$string['includemoduleuserdata'] = 'モジュールユーザデータを含む';
$string['incompatibleblocks'] = '互換性がないブロック';
$string['install'] = '選択した言語パックをインストールする';
$string['installedlangs'] = 'インストール済み言語パック';
$string['installhijacked'] = '申し訳ございません、インストールはオリジナルのIPアドレスから完了する必要があります。';
$string['installsessionerror'] = 'PHPセッションを初期化できません、あなたのブラウザがクッキーを受け付けるかどうか確認してください。';
$string['intcachemax'] = '内部キャッシュ最大値';
$string['intlrecommended'] = 'intl拡張モジュールの使用はロケールに関するソート等の国際化サポートを改善します。';
$string['invalidlangpack'] = 'この言語パックを編集するには、言語パックを言語フォルダに置く必要があります。';
$string['invalidsection'] = 'セクションが正しくありません。';
$string['invaliduserchangeme'] = 'ユーザ名「changeme」は予約されています -- あなたはこのユーザ名のアカウントを作成することができません。';
$string['ipblocked'] = '現在、このサイトは利用できません。';
$string['ipblocker'] = 'IPブロッカー';
$string['ipblockersyntax'] = '1行に1エントリを入力してください。有効なエントリは単一ホストに合致する (<b>192.168.10.1</b>) のようなフルIPアドレス、指定されたIPアドレスで始まる (<b>192.168.</b>) のような部分的なアドレス、(<b>231.54.211.0/20</b>) のようなCIDR表記法、またはアドレスの最後の部分に適用される (<b>231.3.56.10-20</b>) のようなIPアドレスの範囲です。(\'example.com\')  のようなテキストドメインはサポートされません。空白行は無視されます。';
$string['iplookup'] = 'IPアドレスのルックアップ';
$string['iplookupinfo'] = 'IPアドレスのロケーションをルックアップするため、MoodleはフリーオンラインNetGeo (The Internet Geographic Database) サーバをデフォルトで利用します。残念ですが、このデータベースは今後メンテナンスされることはなく、「大幅に不正確」なデータを返します。MaxMindからフリーGeoLite Cityデータベースのローカルコピーをインストールすることをお勧めします。<br />IPアドレスのロケーションは、シンプルマップまたはGoogle Mapsを利用して表示されます。インタラクティブマップを有効にするには、Googleアカウントを取得して、フリーGoogle Maps APIキーを適用する必要がありますので注意してください。';
$string['iplookupmaxmindnote'] = 'この製品は、<a href="http://www.maxmind.com/">http://www.maxmind.com/</a>で利用できる、MaxMindによって作成されたGeoLiteデータを含みます。';
$string['iplookupnetgeonote'] = '現在、NetGeoサーバは地理情報をルックアップするため利用されています。さらに正確な情報を取得するには、MaxMind GeoLiteデータベースのローカルコピーのインストールをお勧めします。';
$string['jabber'] = 'Jabber';
$string['jabberhost'] = 'Jabberホスト';
$string['jabberpassword'] = 'Jabberパスワード';
$string['jabberport'] = 'Jabberポート';
$string['jabberserver'] = 'Jabberサーバ';
$string['jabberusername'] = 'Jabberユーザ名';
$string['keeptagnamecase'] = 'タグ名の大文字小文字を保持する';
$string['lang'] = 'デフォルト言語';
$string['lang16notify'] = 'Moodle1.6以上のバージョンでは、下記のリンクでdownload.moodle.orgより直接言語パックをインストールおよびアップデートすることができます。';
$string['langcache'] = '言語メニューをキャッシュする';
$string['langcache_desc'] = '言語メニューをキャッシュします。この設定を有効にした場合、利用可能な翻訳一覧がキャッシュされます。あなたがビルトインの言語パック管理ツール経由で言語パックをインストールまたは削除した場合、自動的にキャッシュが更新されます。あなたが手動で新しい言語パックをインストールした場合、すべてのキャッシュをクリアする機能を使って、キャッシュリストを更新する必要があります。';
$string['langedit'] = '言語の編集';
$string['langimport'] = '言語インポートユーティリティ';
$string['langimportdisabled'] = '言語インポート機能は無効にされています。あなたはファイルシステムレベルで言語パックを手動更新する必要があります。';
$string['langimportsuccess'] = '言語パックが正常に更新されました。';
$string['langlist'] = '言語メニューの言語';
$string['langlocalpackage'] = 'ローカル修正';
$string['langmasterenglish'] = 'マスター英語パック';
$string['langmasterpackage'] = 'マスター言語パック';
$string['langmenu'] = '言語メニューを表示する';
$string['langnoeditenglish'] = 'ベースの英語言語パックを上書きすることはできません。使用言語を編集するには言語ディレクトリに移動してください。';
$string['langpackinstalled'] = '言語パック {$a} が正常にインストールされました。';
$string['langpackmaintaining'] = '言語パックのメンテナンス';
$string['langpackremoved'] = '言語パックがアンインストールされました。';
$string['langpacks'] = '言語パック';
$string['langpackupdated'] = '言語パック {$a} が正常に更新されました。';
$string['langpackupdateskipped'] = '言語パック {$a} の更新がスキップされました。';
$string['langpackwillbeupdated'] = 'アップグレード中、Moodleは現在の言語パックのアップグレードを試みます。';
$string['langrmyourself'] = 'データ損失を防ぐため、lang.phpは既存のファイルを空のコンテンツで上書きできません。ファイルを取り除くには、手動で削除してください。';
$string['langstringcache'] = 'すべての言語ストリングをキャッシュする';
$string['languagesettings'] = '言語設定';
$string['langupdatecomplete'] = '言語パックの更新が完了しました。';
$string['latexpreamble'] = 'LaTeXプリアンブル';
$string['latexsettings'] = 'LaTeXレンダラ設定';
$string['latinexcelexport'] = 'Excelエンコーディング';
$string['legacyfilesinnewcourses'] = '新しいコースのレガシーコースファイル';
$string['legacyfilesinnewcourses_help'] = 'デフォルトでは、レガシーコースファイルエリアはアップグレードされたコースのみで使用することができます。単一の活動のバックアップ/リストアのようないくつかの機能に関して、この設定の互換性がないことに留意してください。';
$string['licensesettings'] = 'ライセンス設定';
$string['loading'] = 'ローディング';
$string['localetext'] = 'サイト全体のロケール';
$string['localstringcustomization'] = 'ローカルストリングのカスタマイズ';
$string['location'] = 'ロケーション';
$string['locationsettings'] = 'ロケーション設定';
$string['locked'] = 'ロック';
$string['log'] = 'ログ';
$string['logguests'] = 'ゲストアクセスを記録する';
$string['logguests_help'] = 'この設定ではゲストアクセスおよび未ログインユーザの行動を記録します。パフォーマンスの理由から、高負荷のサイトではこの設定を無効にした方が良いでしょう。実運用サイトではこの設定を有効のままにすることをお勧めします。';
$string['loginhttps'] = 'ログインにHTTPSを使用する';
$string['loginpasswordautocomplete'] = 'ログインフォームのパスワード自動補完を防ぎます。';
$string['loginpasswordautocomplete_help'] = 'このオプションを無効にした場合、ユーザのブラウザにパスワードが保存されてしまいます。このオプションを有効にした場合、あなたのサイトはXHTMLの厳密な妥当性検査ルールに従わないことになります。';
$string['loglifetime'] = 'ログの保存期間';
$string['longtimewarning'] = '<b>この処理には長時間がかかりますので注意してください。</b>';
$string['mail'] = 'Eメール';
$string['mailnewline'] = 'メールの改行文字';
$string['maintenancemode'] = 'メンテナンスモード';
$string['maintfileopenerror'] = 'メンテナンスファイルのオープン中にエラーが発生しました！';
$string['maintinprogress'] = 'メンテナンス処理中です ...';
$string['managelang'] = '管理';
$string['managelicenses'] = 'ライセンス管理';
$string['manageqtypes'] = '問題タイプを管理する';
$string['maturity100'] = 'ベータ';
$string['maturity150'] = 'リリース候補版';
$string['maturity200'] = '安定版';
$string['maturity50'] = 'アルファ';
$string['maturitycorewarning'] = 'あなたは「 {$a} 」とマークされたバージョンのMoodleをインストールまたはアップグレードしようとしています。このバージョンは実運用サイト向きではないと考えられます。これが意図的な作業であり、あなたが正しいMoodleソースコードを入手していることを確認してください。';
$string['maxbytes'] = '最大アップロードサイズ';
$string['maxconsecutiveidentchars'] = '連続した同一文字';
$string['maxeditingtime'] = '投稿を編集できる最大時間';
$string['mbstringrecommended'] = 'サイトパフォーマンスを改善するため、mbstringライブラリのインストールおよび稼動を強くお勧めします。あなたのサイトがラテン文字以外をサポートしている場合、特にお勧めします。';
$string['mediapluginavi'] = '.aviフィルタを有効にする';
$string['mediapluginflv'] = '.flvフィルタを有効にする';
$string['mediapluginimg'] = 'リンクイメージの自動埋め込みを有効にする';
$string['mediapluginmov'] = '.movフィルタを有効にする';
$string['mediapluginmp3'] = '.mp3フィルタを有効にする';
$string['mediapluginmpg'] = '.mpgフィルタを有効にする';
$string['mediapluginogg'] = '.oggフィルタを有効にする';
$string['mediapluginogv'] = 'ogvフィルタを有効にする';
$string['mediapluginram'] = '.ramフィルタを有効にする';
$string['mediapluginrm'] = '.rmフィルタを有効にする';
$string['mediapluginrpm'] = '.rpmフィルタを有効にする';
$string['mediapluginswf'] = '.swfフィルタを有効にする';
$string['mediapluginswfnote'] = 'デフォルトのセキュリティ対策として、通常のユーザがswfフラッシュファイルを埋め込むことは許可されていません。';
$string['mediapluginwmv'] = '.wmvフィルタを有効にする';
$string['mediapluginyoutube'] = 'YouTubeリンクフィルタを有効にする';
$string['memcachedhosts'] = 'memcachedホスト';
$string['memcachedpconn'] = 'memcachedが持続的接続を使用する';
$string['messaging'] = 'メッセージングシステムを有効にする';
$string['messagingdeletereadnotificationsdelay'] = '未読通知を削除する';
$string['messaginghidereadnotifications'] = '未読通知を隠す';
$string['minpassworddigits'] = '数字';
$string['minpasswordlength'] = 'パスワード長';
$string['minpasswordlower'] = '小文字';
$string['minpasswordnonalphanum'] = '非英数字';
$string['minpasswordupper'] = '大文字';
$string['misc'] = 'その他';
$string['missinglangparent'] = '「 {$a->lang} 」の親言語「 {$a->parent} 」がありません。';
$string['mnetrestore_extusers'] = '<strong>注意:</strong> このバックアップファイルは処理中にリストアされるMoodleネットワークユーザアカウントを含んでいます。';
$string['mnetrestore_extusers_admin'] = '<strong>注意:</strong> このバックアップファイルは他のMoodleで作成され、Moodleネットワークユーザアカウントを含んでるようです。リストア処理ではすべての作成済みユーザに対して、Moodleネットワークホストでのマッチングを試みます。合致しないユーザは (mnet認証の代わりに) 自動的に内部認証へ切り替えられます。あなたはこの処理に関する情報をリストアログで閲覧することができます。';
$string['mnetrestore_extusers_mismatch'] = '<strong>注意:</strong> このバックアップファイルは他のMoodleで作成され、リストアできないMoodleネットワークユーザアカウントを含んでいます。この処理はサポートされていません。バックアップファイルがこのMoodleでバックアップされたこと、または必要なすべてのMoodleネットワークホストが設定されていることをあなたが保証できる場合のみ、リストアを試みてください。';
$string['mnetrestore_extusers_noadmin'] = '<strong>注意:</strong> このバックアップファイルは他のMoodleで作成され、Moodleネットワークユーザアカウントを含んでいます。あなたはこのタイプのリストア処理の実行を許可されていません。サイト管理者に連絡するか、代わりにこのコースをユーザ情報なし (モジュール、ファイル ...) でリストアしてください。';
$string['mnetrestore_extusers_switchuserauth'] = 'リモートMoodleネットワークユーザ {$a->username} ({$a->mnethosturl}) がローカル {$a->auth} 認証済みユーザに切り替えられました。';
$string['modeditdefaults'] = '活動設定のデフォルト値';
$string['modsettings'] = '活動の管理';
$string['modulesecurity'] = 'モジュールセキュリティ';
$string['multilangforceold'] = '古いmultilangシンタックスを強制する: class="multilang" なしの &lt;span&gt; および &lt;lang&gt;';
$string['multilangupgrade'] = 'multilangアップグレード';
$string['multilangupgradeinfo'] = 'multilangフィルタシンタックスはMoodle 1.8で変更されました。今後、<lang> タグはサポートされません。<br /><br />例: <span lang="en" class="multilang">Hello!</span><span lang="es" class="multilang">Hola!</span><br /><br /><strong>既存のすべてのテキストに関するシンタックスをアップグレードしてもよろしいですか?</strong>';
$string['multilangupgradenotice'] = 'あなたのサイトはおそらく古いmultilangシンタックスを使用しています。<a href="multilangupgrade.php">multilangアップグレード</a>をお勧めします。';
$string['mustenablestats'] = 'このサイトでは統計が有効にされていません。';
$string['mycoursesperpage'] = 'コース数';
$string['mydashboard'] = 'システムデフォルダッシュボード';
$string['mymoodle'] = 'マイMoodle';
$string['mymoodleredirect'] = 'ユーザにマイMoodleの使用を強制する';
$string['mypage'] = 'デフォルトマイホームページ';
$string['mypagelocked'] = 'デフォルトページをロックする';
$string['myprofile'] = 'デフォルトプロファイルページ';
$string['mysql416bypassed'] = 'あなたのサイトがiso-8859-1 (ラテン) 言語のみ使用している場合、現在インストールされている MySQL 4.1.12 (またはそれ以上) を使用することができます。';
$string['mysql416required'] = '将来すべてのデータをUTF-8に変換できるため、Moodle 1.6ではMySQL 4.1.16が要求される最低限のバージョンです。';
$string['navcourselimit'] = 'コース制限';
$string['navigationupgrade'] = 'このアップグレードでは次のブロックに替えて、新しい2つのナビゲーションブロックが導入されます: 管理、コース、活動および参加者。これらのブロックに特別なパーミッションを設定している場合、あなたの希望するとおりに、すべてが動作するかどうか確認してください。';
$string['navshowallcourses'] = 'すべてのコースを表示する';
$string['navshowcategories'] = 'コースカテゴリを表示する';
$string['neverdeleteruns'] = '実行結果を削除しない';
$string['nobookmarksforuser'] = 'あなたのブックマークはありません。';
$string['nochanges'] = '変更なし';
$string['nodatabase'] = 'データベースなし';
$string['nolangupdateneeded'] = 'すべての言語パックは最新版です。アップデートの必要はありません。';
$string['nomissingstrings'] = '未翻訳ストリングはありません。';
$string['nonewsettings'] = 'このアップグレード中、新しい設定は追加されませんでした。';
$string['nonexistentbookmark'] = 'あなたがリクエストしたブックマークは登録されていません。';
$string['noreplyaddress'] = 'No-replyアドレス';
$string['noresults'] = '該当するデータは見つかりませんでした。';
$string['noroles'] = 'ロールなし';
$string['notifications'] = '通知';
$string['notifyloginfailures'] = 'ログイン失敗をメール通知する';
$string['notifyloginthreshold'] = 'メール通知の閾値';
$string['notloggedinroleid'] = 'ビジターのロール';
$string['numberofmissingstrings'] = '未翻訳ストリング数: {$a}';
$string['numberofstrings'] = '合計ストリング数: {$a->strings}<br />未翻訳数: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['numcoursesincombo'] = 'コンボリスト内コースの最大数';
$string['numcoursesincombo_help'] = '多数のコースが登録されている場合、コンボリストは快適に動作しません。サイトのコース合計数がこの設定より多い場合、フロントページにすべてのコースを表示する代わりに、専用コース一覧へのリンクが表示されます。';
$string['numquestions'] = '問題数';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} 非表示)';
$string['opensslrecommended'] = 'Moodleネットワーキング機能を有効にするため、OpenSSLライブラリのインストールを強くお勧めします。';
$string['opentogoogle'] = 'Googleに公開する';
$string['optionalmaintenancemessage'] = '任意のメンテナンスメッセージ';
$string['order1'] = '1番目';
$string['order2'] = '2番目';
$string['order3'] = '3番目';
$string['order4'] = '4番目';
$string['passwordpolicy'] = 'パスワードポリシー';
$string['pathconvert'] = '<i>convert</i>バイナリのパス';
$string['pathdvips'] = '<i>dvips</i>バイナリのパス';
$string['pathlatex'] = '<i>latex</i>バイナリのパス';
$string['pathtoclam'] = 'ClamAVパス';
$string['pathtodot'] = 'dotのパス';
$string['pathtodot_help'] = 'dotのパスを指定してください。おそらく、/usr/bin/dotのようになります。 DOTファイルからグラフィックスを生成するには、あなたはdot実行ファイルをインストールした後、ここでパスを指定する必要があります。現在のところ、これはMoodleにビルトインされているプロファイリング機能 (開発 > プロファイリング) でのみ使用できることに留意してください。';
$string['pathtodu'] = 'duのパス';
$string['pathtopgdump'] = 'pg_dumpのパス';
$string['pathtopgdumpdesc'] = 'あなたのシステムに1つ以上のpg_dumpが存在する場合 (例 1つ以上のバージョンのpostgresqlがインストールされている場合) のみ入力する必要があります。';
$string['pathtopgdumpinvalid'] = 'pg_dumpのパスが正しくありません - パスが間違っているか、実行可能ではありません。';
$string['pathtopsql'] = 'psqlのパス';
$string['pathtopsqldesc'] = 'あなたのシステムに1つ以上のpsqlが存在する場合 (例 1つ以上のバージョンのpostgresqlがインストールされている場合) のみ入力する必要があります。';
$string['pathtopsqlinvalid'] = 'psqlのパスが正しくありません - パスが間違っているか、実行可能ではありません。';
$string['pathtounzip'] = 'unzipのパス';
$string['pathtozip'] = 'zipのパス';
$string['perfdebug'] = 'パフォーマンス情報';
$string['performance'] = 'パフォーマンス';
$string['pgcluster'] = 'PostgreSQLクラスタ';
$string['pgclusterdescription'] = 'コマンドライン処理のためのPostgreSQLバージョン/クラスタパラメータです。あなたのシステムに1つのPostgreSQLのみある場合、またはこの設定が分からない場合、空白にしてください。';
$string['php50restricted'] = 'PHP 5.0.x には数多くの既知の問題があります。5.1.x にアップグレードするか、4.3.x または 4.4.x にダウングレードしてください。';
$string['php533warning'] = 'PHP 5.3.3およびそれ以上のバージョンを推奨します。';
$string['phpfloatproblem'] = 'PHP浮動数の処理に予想外の問題が発見されました - {$a}';
$string['pleaserefreshregistration'] = 'あなたのサイトがmoodle.orgに登録されました。最終更新日 {$a} 以降、サイトに大幅な変更があった場合、登録内容の更新をお考えください。';
$string['pleaseregister'] = 'このボタンを消すには、あなたのサイトを登録してください。';
$string['plugin'] = 'プラグイン';
$string['plugins'] = 'プラグイン';
$string['profilecategory'] = 'カテゴリ';
$string['profilecategoryname'] = 'カテゴリ名 (ユニークにしてください)';
$string['profilecategorynamenotunique'] = 'このカテゴリ名はすでに使用されています。';
$string['profilecommonsettings'] = '共通設定';
$string['profileconfirmcategorydeletion'] = 'このカテゴリには上記 (トップカテゴリの場合は下記) カテゴリに移動される {$a} 個のフィールドが含まれています。<br />本当にこのカテゴリを削除してもよろしいですか?';
$string['profileconfirmfielddeletion'] = 'このフィールドには削除される  {$a} 名のユーザレコードが含まれています。<br />本当にこのフィールドを削除してもよろしいですか?';
$string['profilecreatecategory'] = '新しいプロファイルカテゴリを作成する';
$string['profilecreatefield'] = '新しいプロファイルフィールドを作成する:';
$string['profilecreatenewcategory'] = '新しいカテゴリの作成';
$string['profilecreatenewfield'] = '新しいプロファイルフィールド「 {$a} 」の作成';
$string['profiledefaultcategory'] = '他のフィールド';
$string['profiledefaultchecked'] = 'デフォルトでチェックする';
$string['profiledefaultdata'] = 'デフォルト値';
$string['profiledeletecategory'] = 'カテゴリの削除';
$string['profiledeletefield'] = 'フィールドの削除';
$string['profiledescription'] = 'フィールドの説明';
$string['profiledscript'] = 'このスクリプトはプロファイルされました。';
$string['profiledscriptview'] = 'このスクリプトのプロファイリング情報を表示する';
$string['profileeditcategory'] = 'カテゴリの編集: {$a}';
$string['profileeditfield'] = 'プロファイルフィールドの編集: {$a}';
$string['profilefield'] = 'プロファイルフィールド';
$string['profilefieldcolumns'] = '列';
$string['profilefieldispassword'] = 'これはパスワードフィールドですか?';
$string['profilefieldlink'] = 'リンク';
$string['profilefieldlink_help'] = 'テキストをリンクに変換するには、$$ を含んだURIを入力してください。$$ はテキストと置換されます。例えば、Twitter IDをリンクに変換したい場合、次のように入力してください: http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'リンクターゲット';
$string['profilefieldmaxlength'] = '最大長';
$string['profilefieldrows'] = '行';
$string['profilefields'] = 'ユーザプロファイルフィールド';
$string['profilefieldsize'] = '表示サイズ';
$string['profileforceunique'] = 'データがユニークである必要がありますか?';
$string['profileinvaliddata'] = '値が有効ではありません。';
$string['profilelocked'] = 'このフィールドをロックしますか?';
$string['profilemenudefaultnotinoptions'] = 'デフォルト値がオプションの1つではありません。';
$string['profilemenunooptions'] = 'メニューオプションを入力してください。';
$string['profilemenuoptions'] = 'メニューオプション (1行あたり１つ)';
$string['profilemenutoofewoptions'] = '少なくとも2つのオプションを入力してください。';
$string['profilename'] = '名称';
$string['profilenofieldsdefined'] = '定義されているフィールドはありません。';
$string['profilerequired'] = 'このフィールドは必須入力ですか?';
$string['profileroles'] = 'プロファイル可視ロール';
$string['profilesforenrolledusersonly'] = 'プロファイルを登録ユーザのみに表示する';
$string['profileshortname'] = '省略名 (ユニークにしてください)';
$string['profileshortnamenotunique'] = 'この省略名はすでに使用されています。';
$string['profilesignup'] = 'サインアップページに表示しますか?';
$string['profilespecificsettings'] = '詳細設定';
$string['profilevisible'] = 'このフィールドを誰に表示しますか?';
$string['profilevisibleall'] = 'すべての人に表示する';
$string['profilevisible_help'] = '* 非表示 - 管理者のみ閲覧することのできる個人情報です。
* ユーザに表示する - ユーザおよび管理者のみ閲覧することのできる個人情報です。
* すべての人に表示する';
$string['profilevisiblenone'] = '非表示';
$string['profilevisibleprivate'] = 'ユーザに表示する';
$string['profiling'] = 'プロファイリング';
$string['profilingallowall'] = '継続プロファイリング';
$string['profilingallowall_help'] = 'この設定を有効にした場合、あなたはいつでもどこでも (PGC) Moodleセッションにおける実行スクリプトすべてをプロファイリングするため、PROFILEALLパラメータを使用することができます。同様にスクリプトを停止するため、あなたはPROFILEALLSTOPパラメータを使用することができます。';
$string['profilingallowme'] = '選択的プロファイリング';
$string['profilingallowme_help'] = 'この設定を有効にした場合、あなたは選択的にどこでも (PGC) Moodleセッションにおける実行スクリプトをプロファイリングするため、PROFILEMEパラメータを使用することができます。同様にプロファイリングの実行を回避するため、あなたはDONTPROFILEMEパラメータを使用することができます。';
$string['profilingautofrec'] = '自動プロファイリング';
$string['profilingautofrec_help'] = 'このオプションを設定することで、いくつかのリクエスト (指定された頻度に基づいて - 1/ XXX) が選択されて、継続解析結果を保存するために自動的にプロファイルされます。このプロファイリングでは「組み込み/除外」設定を参照することに留意してください。ゼロを設定した場合、自動プロファイリングは無効にされます。';
$string['profilingenabled'] = 'プロファイリングを有効にする';
$string['profilingenabled_help'] = 'この設定を有効にした場合、このサイト内でプロファイリングを使用できるようになります。あなたは次のオプションでプロファイリングの動作を定義することができます。';
$string['profilingexcluded'] = 'プロファイリングを除外する';
$string['profilingexcluded_help'] = '「これらをプロファイルする」設定で定義されたURIからプロファイリングを除外する (wwwrootを除いたカンマ区切りの実行可能な絶対パスの ) 一覧です。';
$string['profilingincluded'] = 'これらをプロファイルする';
$string['profilingincluded_help'] = '自動的にプロファイルされる (wwwrootを除いたカンマ区切りの実行可能な絶対パスの ) 一覧です。例: /index.php, /course/view.php また、どのような場所であってもワイルドカード (*) を使用することができます。例:  /mod/forum/*, /mod/*/view.php';
$string['profilinglifetime'] = 'プロファイリング実行を保持する';
$string['profilinglifetime_help'] = 'あなたが古いプロファイリング実行を保持したい期間を指定してください。古いプロファイリングは定期的に削除されます。この設定では「参照実行」としてマークされたプロファイリングを除外することに留意してください。';
$string['protectusernames'] = 'ユーザ名を保護する';
$string['proxybypass'] = 'プロクシバイパスホスト';
$string['proxyhost'] = 'プロクシホスト';
$string['proxypassword'] = 'プロクシパスワード';
$string['proxyport'] = 'プロクシポート';
$string['proxytype'] = 'プロクシタイプ';
$string['proxyuser'] = 'プロクシユーザ名';
$string['purgecaches'] = 'すべてのキャッシュを削除する';
$string['purgecachesconfirm'] = 'Moodleではテーマ、javascript、言語ストリング、フィルタテキスト、RSSフィードおよび多くの計算データをキャッシュすることができます。キャッシュを削除することにより、あなたが現在のコードにより作成された最新データを閲覧できるよう、サーバからキャッシュデータが削除され、ブラウザによるデータ再取得が強制されます。キャッシュを削除することに危険性はありませんが、サーバおよびクライアントが新しい情報を計算してキャッシュするまで、あなたのサイトが若干遅くなります。';
$string['purgecachesfinished'] = 'すべてのキャッシュが削除されました。';
$string['qtypedeletefiles'] = '問題タイプ「 {$a->qtype} 」に関連する、すべてのデータがデータベースから削除されました。削除を完了する (および問題タイプの再インストールを防ぐ) には、あなたのサーバより次のディレクトリを削除する必要があります: {$a->directory}';
$string['qtyperqpwillberemoved'] = 'アップグレード中、RQP問題タイプは削除されます。あなたはこの問題タイプを使用していないため、トラブルを経験することはありません。';
$string['qtyperqpwillberemovedanyway'] = 'アップグレード中、RQP問題タイプは削除されます。あなたのデータベース内にRQP問題タイプが登録されています。アップグレードを続ける前に、http://moodle.org/mod/data/view.php?d=13&amp;rid=797 から対応するプログラムをインストールしない場合、これらの問題は動作しなくなります。';
$string['quarantinedir'] = '隔離ディレクトリ';
$string['question'] = '問題';
$string['questioncwqpfscheck'] = '1つまたはそれ以上の小テストの「ランダム」問題が共有および非共有カテゴリから混在して選択されるよう、設定されています。詳細レポートは<a href="{$a->reporturl}">こちらを</a>ご覧ください。また、<a href="{$a->docsurl}">こちら</a>でMoodle Docsページをご覧ください。';
$string['questioncwqpfsok'] = '素晴らしい。あなたの小テストでは共有および非共有カテゴリから混在して選択されるよう、設定されている「ランダム」問題はありません。';
$string['questiontype'] = '問題タイプ';
$string['questiontypes'] = '問題タイプ';
$string['rcache'] = 'レコードキャッシュ';
$string['rcachettl'] = 'レコードキャッシュTTL';
$string['recaptchaprivatekey'] = 'reCAPTCHAプライベートキー';
$string['recaptchapublickey'] = 'reCAPTCHAパブリックキー';
$string['registration'] = '登録';
$string['releasenoteslink'] = 'このバージョンのMoodleに関する詳細情報は<a target="_blank" href="{$a}">オンラインリリースノート</a>をご覧ください。';
$string['remotelangnotavailable'] = 'Moodleがmoodle.orgに接続できないため、言語パックを自動的にインストールできません。適切なzipファイルを下記リンクより手動でダウンロードして、{$a} ディレクトリにコピーおよびunzipしてください。';
$string['renameerrors'] = 'リネームエラー';
$string['requiredentrieschanged'] = '<strong>重要 - お読みください<br />(この警告メッセージはこのアップグレード中のみ表示されます)。</strong><br />バグ修正のため、「必須エントリ数」および「閲覧前に必要な入力エントリ数」を使用しているデータベース活動の設定は変更されます。この変更に関する詳細は、<a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">データベースモジュールフォーラム</a>でご覧いただけます。また、これらの設定に関する詳細は<a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>でご覧いただけます。<br /><br />この変更はあなたのシステムの以下のデータベースに影響します: (このリストを保存して、アップグレード後、教師が意図するよう、動作するか確認してください)<br /><strong>{$a->text}</strong><br />';
$string['requiredtemplate'] = '必須項目です。あなたはここでテンプレート構文 (%l = 姓、%f = 名、%u = ユーザ名) を使用することができます。詳細および例に関して、ヘルプをご覧ください。';
$string['requiremodintro'] = '活動説明を必須とする';
$string['requires'] = '必要条件';
$string['restrictbydefault'] = 'モジュールをデフォルトで制限する';
$string['restrictmodulesfor'] = 'モジュールの制限';
$string['reverseproxy'] = 'リバースプロクシ';
$string['riskconfig'] = 'ユーザはサイトの設定および動作を変更することができます。';
$string['riskconfigshort'] = '設定リスク';
$string['riskdataloss'] = 'ユーザは大量のコンテンツまたは情報を破壊することができます。';
$string['riskdatalossshort'] = 'データロスリスク';
$string['riskmanagetrust'] = 'ユーザは他のユーザの信頼度設定を変更することができます。';
$string['riskmanagetrustshort'] = '信頼度管理';
$string['riskpersonal'] = 'ユーザは他のユーザの個人情報にアクセスすることができます。';
$string['riskpersonalshort'] = 'プライバシーリスク';
$string['riskspam'] = 'ユーザはサイトユーザまたはそれ以外にスパムを送信することができます。';
$string['riskspamshort'] = 'スパムリスク';
$string['riskxss'] = 'ユーザはクロスサイトスクリプティング (XSS) を許すファイルおよびテキストを追加することができます。';
$string['riskxssshort'] = 'XSSリスク';
$string['roleswithexceptions'] = '{$a->roles} および {$a->exceptions}';
$string['rowpreviewnum'] = 'プレビュー行';
$string['rssglobaldisabled'] = 'サーバレベルで無効済み';
$string['runclamavonupload'] = 'アップロードファイルにClamAVを使用する';
$string['save'] = '保存';
$string['savechanges'] = '変更を保存する';
$string['search'] = '検索';
$string['searchinsettings'] = '設定検索';
$string['searchresults'] = '検索結果';
$string['sectionerror'] = 'セクションエラー!';
$string['secureforms'] = '追加的なフォームセキュリティを使用する';
$string['security'] = 'セキュリティ';
$string['server'] = 'サーバ';
$string['serverchecks'] = 'サーバチェック';
$string['serverlimit'] = 'サーバリミット';
$string['sessionautostartwarning'] = '<p>深刻な設定エラーが検出されました。サーバ管理者に通知してください。</p><p>Moodleを適切に動作させるためには、PHP設定の変更を必要とします。</p><p><code>session.auto_start</code>を<code>off</code>にしてください。</p><p>この設定は<code>php.ini</code>、 Apache/IIS設定またはサーバの<code>.htaccess</code>ファイルを使用して管理することができます。</p>';
$string['sessioncookie'] = 'クッキー接頭辞';
$string['sessioncookiedomain'] = 'クッキードメイン';
$string['sessioncookiepath'] = 'クッキーパス';
$string['sessionhandling'] = 'セッションハンドリング';
$string['sessiontimeout'] = 'タイムアウト';
$string['settingfileuploads'] = 'ファイルアップロードは通常の操作に必要です。PHP設定で有効にしてください。';
$string['settingmemorylimit'] = 'メモリの不足が検出されました。PHP設定でメモリ制限を現在より高く設定してください。';
$string['settingsafemode'] = 'Moodleではセーフモードに完全な互換性がありません。サーバ管理者にセーフモードの無効化を依頼してください。セーフモードでのMoodleの動作はサポートされていません。Moodleをセーフモードで動作させる場合、様々な問題が発生する可能性があります。';
$string['showcommentscount'] = 'コメントカウントを表示する';
$string['showdetails'] = '詳細を表示する';
$string['simpletest'] = 'ユニットテスト';
$string['simplexmlrequired'] = '現在、MoodleにはSimpleXML PHP拡張モジュールが必要です。';
$string['sitelangchanged'] = 'サイト言語の設定が正常に完了しました。';
$string['sitemailcharset'] = '文字セット';
$string['sitemaintenance'] = 'このサイトはメンテナンス中です。現在ご利用いただけません。';
$string['sitemaintenancemode'] = 'メンテナンスモード';
$string['sitemaintenanceoff'] = 'メンテナンスモードが解除されました。サイトは正常に動作しています。';
$string['sitemaintenanceon'] = 'あなたのサイトは、現在メンテナンスモードで運用されています (管理者のみログインまたはサイトを利用することができます)。';
$string['sitemaintenancewarning'] = 'あなたのサイトは現在メンテナンスモードで運用されています (管理者のみログインできます)。通常運用に戻すには、<a href="maintenance.php">メンテナンスモードを解除してください</a>。';
$string['sitemaintenancewarning2'] = 'あなたのサイトは現在メンテナンスモードで運用されています (管理者のみログインできます)。通常運用に戻すには、<a href="{$a}">メンテナンスモードを解除してください</a>。';
$string['sitepolicies'] = 'サイトポリシー';
$string['sitepolicy'] = 'サイトポリシーURI';
$string['sitepolicyguest'] = 'ゲストのサイトポリシーURI';
$string['sitepolicyguest_help'] = 'すべてのゲストが閲覧および同意するサイトポリシーがある場合、ここにそのURIを指定してください。そうでない場合、このフィールドを空白のままにしてください。この設定にはどのようなパブリックURIも入力することができます。注意: 未ログインユーザののアクセスは「ユーザのログインを強制する」設定により拒否されます。';
$string['sitepolicy_help'] = 'すべてのゲストが閲覧および同意するサイトポリシーがある場合、ここにそのURIを指定してください。そうでない場合、このフィールドを空白のままにしてください。この設定にはどのようなパブリックURIも入力することができます。';
$string['sitesectionhelp'] = '選択した場合、トピックセクションがサイトフロントページに表示されます。';
$string['slasharguments'] = 'スラッシュを使用する';
$string['smartpix'] = 'スマートpixサーチ';
$string['smtphosts'] = 'SMTPホスト';
$string['smtpmaxbulk'] = 'SMTPセッション制限';
$string['smtppass'] = 'SMTPパスワード';
$string['smtpuser'] = 'SMTPユーザ名';
$string['soaprecommended'] = 'ウェブサービスおよびcontribモジュールためにSOAP拡張モジュールのインストールをお勧めします。';
$string['spellengine'] = 'スペルエンジン';
$string['splrequired'] = '現在、MoodleではSPL PHP拡張モジュールを必要とします。';
$string['stats'] = '統計資料';
$string['statsfirstrun'] = '最大処理間隔';
$string['statsmaxruntime'] = '最大実行時間';
$string['statsruntimedays'] = '処理日数';
$string['statsruntimestart'] = '開始時刻';
$string['statsuserthreshold'] = 'ユーザ閾値';
$string['stickyblocks'] = 'スティッキーブロック';
$string['stickyblockscourseview'] = 'コースページ';
$string['stickyblocksduplicatenotice'] = 'あなたがここで追加するブロックがすでに特定のページに登録されている場合、ブロックが重複することになります。<br />この場合、スティッキーブロックのみ編集不可となりますが、重複したブロックは編集することができます。';
$string['stickyblocksmymoodle'] = 'マイMoodle';
$string['stickyblockspagetype'] = '設定するページタイプ';
$string['strictformsrequired'] = '必須フィールドの厳密な確認';
$string['stripalltitletags'] = 'すべての活動名からHTMLタグを取り除く';
$string['supportemail'] = 'サポートメール';
$string['supportname'] = 'サポート名';
$string['supportpage'] = 'サポートページ';
$string['switchlang'] = '言語ディレクトリを切り替える';
$string['systempaths'] = 'システムパス';
$string['tablenosave'] = '上記テーブル内の変更は自動的に保存されます。';
$string['tablesnosave'] = '上記テーブル内の変更は自動的に保存されます。';
$string['tabselectedtofront'] = 'タブ付きテーブルにおいて、現在選択されているタブを最前部に表示します。';
$string['tabselectedtofronttext'] = '選択されたタブを最前部に表示する';
$string['themedesignermode'] = 'テーマデザイナモード';
$string['themelist'] = 'テーマリスト';
$string['themeresetcaches'] = 'テーマキャッシュをクリアする';
$string['themeselector'] = 'テーマセレクタ';
$string['themesettings'] = 'テーマ設定';
$string['therewereerrors'] = 'あなたのデータにエラーがあります。';
$string['timezone'] = 'デフォルトタイムゾーン';
$string['timezoneforced'] = 'サイト管理者によって強制されています。';
$string['timezoneisforcedto'] = 'すべてのユーザに使用を強制する';
$string['timezonenotforced'] = 'ユーザは独自のタイムゾーンを使用できる';
$string['tokenizerrecommended'] = 'PHP Tokenizer拡張モジュールのインストールをお勧めします - Moodleネットーワーキングの機能性を改善します。';
$string['unattendedoperation'] = '無人オペレーション';
$string['unbookmarkthispage'] = 'このページをブックマーク解除する';
$string['unicoderecommended'] = 'あなたのすべてのデータをユニコードフォーマット (UTF-8) で保存することをお勧めします。Moodleの新しいインストールはユニコードをデフォルトキャラクタにセットしたデータベースで実行してください。アップグレードの場合、UTF-8移行処理を実行してださい (詳細は管理ページをご覧ください)。';
$string['unicoderequired'] = 'あなたのすべてのデータをユニコードフォーマット (UTF-8) で保存することが必須です。Moodleの新しいインストールはユニコードをデフォルトキャラクタにセットしたデータベースで実行してください。アップグレードの場合、UTF-8移行処理を実行してださい (詳細は管理ページをご覧ください)。';
$string['unicodeupgradenotice'] = 'Moodle1.6において、私たちはすべての言語をユニコードに移行しました。このサイトのアップグレードを完了するには、移行スクリプトを使用してデータベースのすべてのデータをユニコード (UTF-8) に変換する必要があります。<a href="utfdbmigrate.php">移行スクリプトを実行するには、ここをクリックしてください</a>!';
$string['uninstall'] = '選択した言語パックをアンインストールする';
$string['uninstallconfirm'] = 'あなたは言語パック {$a} を完全にアンインストールしようとしています。本当によろしいですか?';
$string['uninstallplugin'] = 'アンインストール';
$string['uninstallqtype'] = 'この問題タイプを削除します。';
$string['unsupported'] = '未サポート';
$string['updateaccounts'] = '既存のアカウントを更新する';
$string['updatecomponent'] = 'コンポーネントを更新する';
$string['updatelangs'] = 'すべてのインストール済み言語パックを更新する';
$string['updatetimezones'] = 'タイムゾーンを更新する';
$string['upgrade197notice'] = '<p>あなたのサイトのユーザ情報を保護するため、Moodle 1.9.7にはユーザパスワードおよびバックアップに関して、数多くのセキュリティ上の修正が含まれます。結果として、あなたのバックアップに関する設定およびパーミッションが変更された可能性があります。詳細は<a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes</a>をご覧ください。</p>';
$string['upgrade197noticesubject'] = 'Moodle 1.9.7アップグレードに関するセキュリティ通知';
$string['upgrade197salt'] = 'また、パスワード盗難のリスクを大幅に減らすため、パスワードSALTの設定を強くお勧めします。<br />詳細は、<a href="http://docs.moodle.org/en/Password_salting" target="_blank">Password saltingドキュメント</a>をご覧ください。';
$string['upgradeerror'] = '{$a->plugin} のバージョン {$a->version} へのバージョンアップに不明なエラーが発生したため、継続できません。';
$string['upgradeforumread'] = 'Moodle1.5では、フォーラムの既読/未読記事を追跡する新しい機能が追加されました。<br />この機能を有効にするには、<a href="{$a}">あなたのテーブルをアップデート</a>する必要があります。';
$string['upgradeforumreadinfo'] = 'Moodle1.5では、フォーラムの既読/未読記事を追跡するための新しい機能が追加されました。この機能を有効にするには、投稿内容の未読管理を含むテーブルをアップデートする必要があります。あなたのサイトのサイズにより、この作業には長時間かかる場合があります。また、データベースに非常に負荷がかかる可能性がありますので、閑散期のアップデート作業をお勧めします。このアップデート期間中も、あなたのサイトは動作し続け、ユーザは影響を受けません。この処理を開始した場合、 (ブラウザを開いたままにして) 処理を終わらせてください。ウィンドウを閉じて処理を終わらせてしまった場合でも心配しないでください。アップデート処理を再開することができます。<br /><br />本当に今からアップデート処理を始めてもよろしいですか?';
$string['upgradelogs'] = '正常に動作させるためには、古いログのアップグレードが必要です。<a href="{$a}">詳細はこちら</a>';
$string['upgradelogsinfo'] = 'ログの保存方法に変更点があります。全活動ベースのログを閲覧することができるようにするには、古いログをアップグレードする必要があります。サイトによってはアップグレード作業に長時間(例 数時間)を要し、規模が大きなサイトではデータベースに負荷がかかります。処理を開始した場合は終了するまでそのまま (ブラウザを開いたまま) にしてください。心配する必要はありません - ログが更新された後に、あなたのサイトは正常に動作します。<br /><br />本当にログをアップグレードしてもよろしいですか?';
$string['upgradesettings'] = '新しい設定';
$string['upgradesettingsintro'] = '以下に表示されている設定は、あなたの直近のMoodleアップグレードで追加されました。必要に応じて変更内容をデフォルトに設定した後、このページ下部にある「変更を保存する」ボタンをクリックしてください。';
$string['upgradestart'] = 'アップグレード';
$string['upgradesure'] = 'あなたのMoodleファイルが更新されました。自動的にMoodleを下記バージョンにアップグレードしようとしています: <br /><br /><strong>{$a}</strong> <br /><br />
一旦この処理を開始すると元に戻すことはできません。<br /><br />
この処理には時間がかかりますので注意してください。<br /><br />
本当にこのサーバのMoodleをこのバージョンにアップグレードしてもよろしいですか?';
$string['upgradetimedout'] = 'アップグレードがタイムアウトしました。アップグレードをリスタートしてください。';
$string['upgradingdata'] = 'データのアップグレード';
$string['upgradinglogs'] = 'ログのアップグレード';
$string['upgradingversion'] = '新しいバージョンへのアップグレード';
$string['uploadpicture_baduserfield'] = '指定されたユーザ属性は有効ではありません。もう一度お試しください。';
$string['uploadpicture_cannotmovezip'] = '一時ディレクトリにZIPファイルを移動できません。';
$string['uploadpicture_cannotprocessdir'] = 'ZIP解凍されたファイルを処理できません。';
$string['uploadpicture_cannotsave'] = 'ユーザ {$a} の画像を保存できません。画像ファイルを確認してください。';
$string['uploadpicture_cannotunzip'] = '画像ファイルを解凍できません。';
$string['uploadpicture_invalidfilename'] = '画像ファイル {$a} のファイル名に無効な文字があります。スキップします。';
$string['uploadpicture_overwrite'] = '既存のユーザ画像を上書きしますか?';
$string['uploadpictures'] = 'ユーザ画像をアップロードする';
$string['uploadpictures_help'] = 'ZIP圧縮したイメージファイルをユーザ画像としてアップロードすることができます。イメージファイルは、「選択されたユーザ属性.拡張子」という形で名前付けをする必要があります。例えば、ユーザ属性でusernameを選択して、ユーザ名1234のユーザが登録されている場合、ファイル名は「1234.jpg」のようになります。';
$string['uploadpicture_userfield'] = '画像にマッチさせるユーザ属性';
$string['uploadpicture_usernotfound'] = '「 {$a->userfield} 」の値が「 {$a->uservalue} 」のユーザは存在しません。スキップします。';
$string['uploadpicture_userskipped'] = 'ユーザ {$a} をスキップします (画像登録済みです)。';
$string['uploadpicture_userupdated'] = 'ユーザ {$a} の画像が更新されました。';
$string['uploadusers'] = 'ユーザをアップロードする';
$string['uploadusers_help'] = 'テキストファイル経由でユーザをアップロード (および任意にコース受講登録) することができます。ファイルのフォーマットは下記のとおりです:

* それぞれの行には1レコード含みます。
* それぞれのレコードはカンマ (または他のデリミタ) で分離された一連のデータです。
* 最初の行にはファイル内の残りのフォーマットを定義するためのフィールド名一覧を含みます。
* 必須フィールドは「username」「password」「firstname」「lastname」「email」です。';
$string['uploaduserspreview'] = 'アップロードユーザプレビュー';
$string['uploadusersresult'] = 'アップロードユーザ結果';
$string['upwards'] = '以上';
$string['useblogassociations'] = '関連付けを有効にする';
$string['useexternalyui'] = 'オンラインYUI ライブラリを使用する';
$string['usehtmleditor'] = 'HTMLエディタを使用する';
$string['user'] = 'ユーザ';
$string['useraccountupdated'] = 'ユーザが更新されました。';
$string['useraccountuptodate'] = '最新ユーザ';
$string['userbulk'] = 'バルクユーザ処理';
$string['userdeleted'] = 'ユーザが削除されました。';
$string['userlist'] = 'ユーザ一覧を表示する';
$string['userpolicies'] = 'ユーザポリシー';
$string['userpreference'] = 'ユーザプリファレンス';
$string['userquota'] = 'ユーザクオータ';
$string['userrenamed'] = 'ユーザがリネームされました。';
$string['users'] = 'ユーザ';
$string['userscreated'] = 'ユーザが作成されました';
$string['usersdeleted'] = 'ユーザが削除されました';
$string['usersrenamed'] = 'ユーザがリネームされました';
$string['usersskipped'] = 'ユーザがスキップされました';
$string['usersupdated'] = 'ユーザが更新されました';
$string['usersweakpassword'] = '弱いパスワードを持ったユーザ';
$string['usetags'] = 'タグ機能を有効にする';
$string['uubulk'] = 'バルク処理の選択';
$string['uubulkall'] = 'すべてのユーザ';
$string['uubulknew'] = '新しいユーザ';
$string['uubulkupdated'] = '更新されたユーザ';
$string['uucsvline'] = 'CSV行';
$string['uulegacy1role'] = '(オリジナルの学生) タイプ=1';
$string['uulegacy2role'] = '(オリジナルの教師) タイプ=2';
$string['uulegacy3role'] = '(オリジナルの編集権限のない教師) タイプ=3';
$string['uunoemailduplicates'] = 'メールアドレスの重複を避ける';
$string['uuoptype'] = 'アップロードタイプ';
$string['uuoptype_addinc'] = 'すべてを追加する、必要に応じてユーザ名に番号を付加する';
$string['uuoptype_addnew'] = '新しいユーザのみ追加する、既存のユーザをスキップする';
$string['uuoptype_addupdate'] = '新しいユーザの追加および既存のユーザを更新する';
$string['uuoptype_update'] = '既存のユーザのみ更新する';
$string['uupasswordcron'] = 'cronにより生成';
$string['uupasswordnew'] = '新しいユーザパスワード';
$string['uupasswordold'] = '既存のユーザパスワード';
$string['uustandardusernames'] = 'ユーザ名を標準化する';
$string['uuupdateall'] = 'ファイルおよびデフォルトでオーバーライドする';
$string['uuupdatefromfile'] = 'ファイルでオーバライドする';
$string['uuupdatemissing'] = '欠けているデータをファイルおよびデフォルトで補完する';
$string['uuupdatetype'] = '既存のユーザ詳細';
$string['uuusernametemplate'] = 'ユーザ名テンプレート';
$string['validateerror'] = 'この値は有効ではありません:';
$string['verifychangedemail'] = 'メールアドレスの変更時、ドメインを制限する';
$string['warningcurrentsetting'] = '無効な現在値: {$a}';
$string['webproxy'] = 'ウェブプロクシ';
$string['webproxyinfo'] = 'あなたのMoodleサーバが直接インターネットに接続できない場合、以下のオプションに必要事項を入力してください。インターネットアクセスは環境データ、言語パック、RSSフィード、タイムゾーン等のダウンロードに必要です。<br />PHP cURL拡張モジュールの使用を強くお勧めします。';
$string['xmlrpcrecommended'] = 'xmlrpc拡張モジュールはハブコミュニケーションに必要です。また、ウェブサービスおよびMoodleネットワーキングに有用です。';
$string['xmlstrictheaders'] = 'XMLストリクトヘッダ';
$string['yuicomboloading'] = 'YUI comboローディング';
$string['ziprequired'] = 'MoodleではPHP Zip拡張モジュールが必須です。info-ZIPバイナリまたはPclZipライブラリは今後使用されません。';
