<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'xmldb', language 'it', branch 'MOODLE_20_STABLE'
 *
 * @package   xmldb
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actual'] = 'Attuale';
$string['aftertable'] = 'Dopo la tabella:';
$string['back'] = 'Indietro';
$string['backtomainview'] = 'Torna alla vista principale';
$string['binaryincorrectlength'] = 'Lunghezza errata per un campo binario';
$string['cannotuseidfield'] = 'Non è possibile inserire il campo "id". E è una colonna autonumeric';
$string['change'] = 'Modifica';
$string['charincorrectlength'] = 'Lunghezza errata per un campo carattere';
$string['checkbigints'] = 'Controlla Bigint';
$string['check_bigints'] = 'Cerca DB Integer errati';
$string['checkdefaults'] = 'Controlla default';
$string['check_defaults'] = 'Cerca valori di default inconsistenti';
$string['checkforeignkeys'] = 'Controlla Foreign key';
$string['check_foreign_keys'] = 'Cerca violazioni di Foreign key';
$string['checkindexes'] = 'Controlla indici';
$string['check_indexes'] = 'Cerca indici mancanti nel DB';
$string['completelogbelow'] = '(visualizza il log della ricerca)';
$string['confirmcheckbigints'] = 'Questa funzione individua la presenza di  <a href="http://tracker.moodle.org/browse/MDL-11038">Integer potenzialmente errati </a> nel vostro server Moodle, generando automaticamente il codice SQL necessario per sistemare gli Integer errati individuati. Il codice SQL viene generato ma non eseguito.<br /><br />
Una volta completata l\'individuazione, potete copiare il codice SQL generato ed eseguirlo tramite l\'interfaccia SQL che preferite (non dimenticate di effettuare un backup del database prima di eseguire il codice SQL).<br /><br />
Si raccomanda di utilizzare la versione di Moodle più recente (versione +) disponibile per la vostra release.(1.8, 1.9, 2.x ...) prima di cercare Integer errati..<br /><br />
Questa funzione non effettua nessuna operazione sul database, legge solamente i dati e pertanto può essere eseguita con sicurezza in qualsiasi momento.';
$string['confirmcheckdefaults'] = 'Questa funzione individua la presenza di valori di default inconsistenti nel vostro server Moodle, generando automaticamente il codice SQL necessario per sistemare tutti i valori dei default inconsistenti eventualmente presenti. Il codice SQL viene generato ma non eseguito.<br /><br />
Una volta completata l\'individuazione, potete copiare il codice SQL generato ed eseguirlo tramite l\'interfaccia SQL che preferite (non dimenticate di effettuare un backup del database prima di eseguire il codice SQL).<br /><br />
Si raccomanda di utilizzare la versione di Moodle più recente (versione +) disponibile per la vostra release.(1.8, 1.9, 2.x ...) prima di cercare Integer errati..<br /><br />
Questa funzione non effettua nessuna operazione sul database, legge solamente i dati e pertanto può essere eseguita con sicurezza in qualsiasi momento.';
$string['confirmcheckforeignkeys'] = 'Questa funzione individua la presenza di violazioni delle foreign key definite nel file install.xml. (Al momento Moodle non genera vincoli per le foreign key, ed è questo il motivo per cui potrebbero essere presenti violazioni.<br /><br />
Si raccomanda di utilizzare la versione di Moodle più recente (versione +) disponibile per la vostra release.(1.8, 1.9, 2.x ...) prima di cercare indici mancanti<br /><br />
Questa funzione non effettua nessuna operazione sul database, legge solamente i dati e pertanto può essere eseguita con sicurezza in qualsiasi momento.';
$string['confirmcheckindexes'] = 'Questa funzione individua indici mancanti nel vostro server Moodle, generando automaticamente il codice SQL necessario per sistemare tutti i valori dei default inconsistenti eventualmente presenti. Il codice SQL viene generato ma non eseguito.<br /><br />
Una volta completata l\'individuazione, potete copiare il codice SQL generato ed eseguirlo tramite l\'interfaccia SQL che preferite (non dimenticate di effettuare un backup del database prima di eseguire il codice SQL).<br /><br />
Si raccomanda di utilizzare la versione di Moodle più recente (versione +) disponibile per la vostra release.(1.8, 1.9, 2.x ...) prima di cercare Integer errati..<br /><br />
Questa funzione non effettua nessuna operazione sul database, legge solamente i dati e pertanto può essere eseguita con sicurezza in qualsiasi momento.';
$string['confirmdeletefield'] = 'Sei sicuro di voler rimuovere il campo:';
$string['confirmdeleteindex'] = 'Sei sicuro di voler rimuovere l\'indice:';
$string['confirmdeletekey'] = 'Sei sicuro di voler rimuovere la chiave:';
$string['confirmdeletetable'] = 'Sei sicuro di voler rimuovere la tabella:';
$string['confirmdeletexmlfile'] = 'Sei sicuro di voler rimuovere il file:';
$string['confirmrevertchanges'] = 'Sei sicuro di voler ripristinare le modifiche effettuate:';
$string['create'] = 'Crea';
$string['createtable'] = 'Crea tabella:';
$string['defaultincorrect'] = 'Default errato';
$string['delete'] = 'Rimuovi';
$string['delete_field'] = 'Elimina campo';
$string['delete_index'] = 'Elimina indice';
$string['delete_key'] = 'Elimina chiave';
$string['delete_table'] = 'Elimina tabella';
$string['delete_xml_file'] = 'Elimina file XML';
$string['doc'] = 'Doc';
$string['docindex'] = 'Indice documentazione:';
$string['documentationintro'] = 'La documentazione viene generata automaticamente dalle definizioni XMLDB del database. E\' disponibile solamente in Inglese.';
$string['down'] = 'Sotto';
$string['duplicate'] = 'Duplica';
$string['duplicatefieldname'] = 'Un altro campo con quel nome esiste';
$string['duplicatekeyname'] = 'Esiste già una chiave con quel nome';
$string['edit'] = 'Modifica';
$string['edit_field'] = 'Modifica campo';
$string['edit_field_save'] = 'Salva campo';
$string['edit_index'] = 'Modifica indice';
$string['edit_index_save'] = 'Salva indice';
$string['edit_key'] = 'Modifica chiave';
$string['edit_key_save'] = 'Salva chiave';
$string['edit_table'] = 'Modifica tabella';
$string['edit_table_save'] = 'Salva tabella';
$string['edit_xml_file'] = 'Modifica file XML';
$string['enumvaluesincorrect'] = 'Valori incorretti per un campo enumerato';
$string['expected'] = 'Attesi';
$string['extensionrequired'] = 'Spiacente - per svolgere questa azione è necessaria l\'estensione PHP \'{$a}\'. Se volete usare questa funzionalità per favore installate l\'estensione.';
$string['field'] = 'Campo';
$string['fieldnameempty'] = 'Nome campo vuoto';
$string['fields'] = 'Campi';
$string['fieldsnotintable'] = 'Il campo non è presente nella tabella';
$string['fieldsusedinkey'] = 'Questo campo è una chiave';
$string['filenotwriteable'] = 'File non scrivibile';
$string['fkviolationdetails'] = 'La Foreign key {$a->keyname} nella tabella  {$a->tablename} è stata violata  {$a->numviolations} su un totale di {$a->numrows} righe.';
$string['float2numbernote'] = 'Nota: sebbene i campi "float" siano supportati al 100% da XMLDB, si consiglia comunque di migrare verso campi "number".';
$string['floatincorrectdecimals'] = 'Numero incorretto di decimali per un campo reale';
$string['floatincorrectlength'] = 'Lunghezza incorretta per un campo reale';
$string['generate_all_documentation'] = 'Tutta la documentazione';
$string['generate_documentation'] = 'Documentazione';
$string['gotolastused'] = 'Vai all\'ultimo file utilizzato';
$string['incorrectfieldname'] = 'Nome errato';
$string['index'] = 'Indice';
$string['indexes'] = 'Indici';
$string['integerincorrectlength'] = 'Lunghezza errata per un campo Integer';
$string['key'] = 'Chiave';
$string['keys'] = 'Chiavi';
$string['listreservedwords'] = 'Elenco delle Parole Riservate<br/>(utilizzato per mantenere aggiornato <a href="http://docs.moodle.org/en/XMLDB_reserved_words" target="_blank">XMLDB_reserved_words</a>)';
$string['load'] = 'Carica';
$string['main_view'] = 'Vista principale';
$string['masterprimaryuniqueordernomatch'] = 'I campi nella tua foreign key devono essere elencati nello stesso ordine con cui compaiono nella UNIQUE KEY della tabella referenziata.';
$string['missing'] = 'Mancanti';
$string['missingindexes'] = 'Sono stati individuati indici mancanti';
$string['mustselectonefield'] = 'Si deve selezionare un campo per vedere le azioni correlate!';
$string['mustselectoneindex'] = 'Si deve selezionare un indice per vedere le azioni correlate!';
$string['mustselectonekey'] = 'Si deve selezionare una chiave per vedere le azioni correlate!';
$string['mysqlextracheckbigints'] = 'Se utilizzate MySQL, verranno cercati anche Signed bigint errati e verrà generato il codice SQL per risolvere eventuali problemi individuati su questi tipi di campi.';
$string['newfield'] = 'Nuovo campo';
$string['newindex'] = 'Nuovo indice';
$string['newkey'] = 'Nuova chiave';
$string['newtable'] = 'Nuova tabella';
$string['newtablefrommysql'] = 'Nuova tabella da MySQL';
$string['new_table_from_mysql'] = 'Nuova tabella da MySQL';
$string['nomasterprimaryuniquefound'] = 'La(e) colonna(e) referenziata dalla tua foreign key deve essere inclusa in una primary o unique KEY della tabella referenziata. Da notare che la colonna in UNIQUE INDEX non è sufficiente.';
$string['nomissingindexesfound'] = 'Non sono stati individuati indici mancanti. Il vostro DB non ha bisogno di altre azioni.';
$string['noviolatedforeignkeysfound'] = 'Non sono state individuate violazioni di Foreign key';
$string['nowrongdefaultsfound'] = 'Non sono stati individuati valori di default inconsistenti. Il vostro DB non ha bisogno di altre azioni.';
$string['nowrongintsfound'] = 'Non sono stati individuati Integer errati. Il vostro DB non ha bisogno di altre azioni.';
$string['numberincorrectdecimals'] = 'Numero errato di decimali per un campo numerico';
$string['numberincorrectlength'] = 'Lunghezza errata per un campo numerico';
$string['pendingchanges'] = 'Nota: avete effettuato modiche al file. Potete salvarle in qualsiasi momento.';
$string['pendingchangescannotbesaved'] = 'Il file è stato modificato ma non è possibile salvare le modifiche. Per favore verificate che il processo del web server abbia i permessi di scrittura per la cartella e per il file "install.xml".';
$string['pendingchangescannotbesavedreload'] = 'Il file è stato modificato ma non è possibile salvare le modifiche. Per favore verificate che il processo del web server abbia i permessi di scrittura per la cartella e per il file "install.xml". Dopo la verifica ricaricate la pagina per controllare se è possibile salvare le modifiche.';
$string['reserved'] = 'Riservata';
$string['reservedwords'] = 'Parole riservate';
$string['revert'] = 'Ripristina';
$string['revert_changes'] = 'Ripristina modifiche';
$string['save'] = 'Salva';
$string['searchresults'] = 'Risultati della ricerca';
$string['selectaction'] = 'Scegli un\'azione:';
$string['selectdb'] = 'Scegli un database:';
$string['selectfieldkeyindex'] = 'Scegli un campo/chiave/indice:';
$string['selectonecommand'] = 'Per favore seleziona un\'azione dalla lista per visualizzare il codice PHP';
$string['selectonefieldkeyindex'] = 'Per favore seleziona un campo/chiave/indice dalla lista per visualizzare il codice PHP';
$string['selecttable'] = 'Scegli una tabella:';
$string['table'] = 'Tabella';
$string['tables'] = 'Tabelle';
$string['textincorrectlength'] = 'Lunghezza errata per un campo testo';
$string['unload'] = 'Scarica';
$string['up'] = 'Sopra';
$string['view'] = 'Visualizza';
$string['viewedited'] = 'Visualizza con le modifiche';
$string['vieworiginal'] = 'Visualizza originale';
$string['viewphpcode'] = 'Visualizza codice PHP';
$string['view_reserved_words'] = 'Visualizza parole Riservate';
$string['viewsqlcode'] = 'Visualizza codice SQL';
$string['view_structure_php'] = 'Visualizza struttura PHP';
$string['view_structure_sql'] = 'Visualizza struttura SQL';
$string['view_table_php'] = 'Visualizza tabella PHP';
$string['view_table_sql'] = 'Visualizza tabella SQL';
$string['viewxml'] = 'XML';
$string['violatedforeignkeys'] = 'Violazioni di foreign key';
$string['violatedforeignkeysfound'] = 'Sono stati individuate violazioni di Foreign key';
$string['violations'] = 'Violazioni';
$string['wrong'] = 'Errati';
$string['wrongdefaults'] = 'Sono stati individuati valori di default errati';
$string['wrongints'] = 'Sono stati individuati Integer errati';
$string['wronglengthforenum'] = 'Lunghezza errata per un campo enum';
$string['wrongreservedwords'] = 'Parole riservate in uso<br/>(notare che il nomi delle tabelle non sono importanti se si utilizza $CFG->prefix)';
$string['yesmissingindexesfound'] = 'Nel vostro DB sono stati individuati alcuni indici mancanti. Di seguito vengono riportati i dettagli e il codice SQL necessario per crearli (non dimenticate di effettuare un backup del database prima di eseguire il codice SQL.<br /><br />Dopo aver eseguito il codice SQL utilizzate di nuovo questa funzione per verificare che non manchino altri indici.';
$string['yeswrongdefaultsfound'] = 'Nel tuo DB sono stati individuati valori di default inconsistenti. Di seguito vengono riportati i dettagli e il codice SQL necessario per sistemarli (non dimenticare di effettuare un backup del database prima di eseguire il codice SQL.<br /><br />Dopo aver eseguito il codice SQL utilizza di nuovo questa funzione per verificare che non siano presenti altri valori di default inconsistenti.';
$string['yeswrongintsfound'] = 'Nel vostro DB sono stati individuati Integer errati. Di seguito vengono riportati i dettagli e il codice SQL necessario per sistemarli (non dimenticate di effettuare un backup del database prima di eseguire il codice SQL.<br /><br />Dopo aver eseguito il codice SQL utilizzate di nuovo questa funzione per verificare che non siano presenti altri Integer errati.';
