<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'it', branch 'MOODLE_20_STABLE'
 *
 * @package   question
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminreport'] = 'Report su possibili problemi nel tuo database di domande.';
$string['availableq'] = 'Disponibile?';
$string['badbase'] = 'Base errata prima di **: {$a}**';
$string['broken'] = 'Questo è un "link interrotto", punta a un file inesistente.';
$string['byandon'] = 'di <em>{$a->user}</em> di <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Impossibile copiare il file di backup';
$string['cannotcreate'] = 'Impossibile creare un nuovo elemento nella tabella dei tentativi del quiz';
$string['cannotcreatepath'] = 'Impossibile creare il path: {$a}';
$string['cannotdeletecate'] = 'Impossibile elimiare la categoria in quanto è quella default per questo contesto.';
$string['cannotenable'] = 'Il tipo di domanda {$a} non può essere creato diretamente.';
$string['cannotfindcate'] = 'Non è stato possibile trovare nessun record di categoria';
$string['cannotfindquestionfile'] = 'Non è stato possibile trovare nessuna domanda nel file zip';
$string['cannotgetdsfordependent'] = 'Non è stato possibile ottenere il dataset specificato per una domanda che dipende dal dal dataset!  (domanda: {$a->id}, , datasetitem: {$a->item})';
$string['cannotgetdsforquestion'] = 'Non è stato possibile ottenere il dataset specificato per una domanda Calcolata!  (domanda: {$a[0]})';
$string['cannothidequestion'] = 'Impossibile nascondere la domanda';
$string['cannotimportformat'] = 'Il software per l\'importazione di questo formato non è ancora stato realizzato!';
$string['cannotinsertquestion'] = 'Impossibile inserire una nuova domanda!';
$string['cannotinsertquestioncatecontext'] = 'Impossibile inserire la nuova categoria di domande {$a->cat}, contesto illegale {$a->ctx}';
$string['cannotloadquestion'] = 'Impossibile caricare la domanda';
$string['cannotmovequestion'] = 'Impossibile usare questo script per spostare domande che hanno file associati da aree differenti.';
$string['cannotopenforwriting'] = 'Impossibile aprire per scrittura: {$a}';
$string['cannotpreview'] = 'Impossibile vedere l\'anteprima di queste domande!';
$string['cannotretrieveqcat'] = 'Non è stato possibile ottenere la categoria di domande';
$string['cannotunhidequestion'] = 'Errore nel mostrare la domanda.';
$string['cannotunzip'] = 'Impossibile unzippare il file.';
$string['cannotwriteto'] = 'Impossibile scrivere le domande esportate su {$a}';
$string['categorycurrent'] = 'Categoria in uso';
$string['categorycurrentuse'] = 'Usa questa categoria';
$string['categorydoesnotexist'] = 'Questa categoria non esiste';
$string['categorymoveto'] = 'Salva nella categoria';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">La categoria "{$a->name}"</a> nel corso "{$a->coursename}" avrà il suo stato di condivisione cambiato da <strong>{$a->changefrom} a {$a->changeto}</strong>.';
$string['chooseqtypetoadd'] = 'Scegli un tipo di domanda da aggiungere';
$string['clicktoflag'] = 'Clicca per contrassegnare questa domanda';
$string['clicktounflag'] = 'Clicca qui per non contrassegnare questa domanda';
$string['contexterror'] = 'Non dovresti essere qui se non stai spostando una categoria in un altro contesto.';
$string['copy'] = 'Copia da {$a} e cambia i link.';
$string['created'] = 'Creazione';
$string['createdby'] = 'Creata da';
$string['createdmodifiedheader'] = 'Creazione/salvataggio più recente';
$string['createnewquestion'] = 'Crea una nuova domanda...';
$string['cwrqpfs'] = 'Domande prese \'a caso\' da domande delle sotto-categorie.';
$string['cwrqpfsinfo'] = '<p>Durante l\'aggiornamento a Moodle 1.9 le categorie di domande saranno suddivise in  contesti differenti. Per alcune domande e categorie di domande e domande sarà modificato il modo con cui sono condivise. La modifica si rende necessaria nel  nel raro caso in cui in un quiz una o più domande \'random\' vengono prese da diverse categorie sia condivise che no, come avviene in questo sito. Le domande \'random\' vengono prese da sotto categorie di domande e le sotto categorie sono condivise in modi diversi rispetto alla categorie genitore da dove viene creata la domanda random.</p>
<p>La condivisione sarà cambiata per le seguenti categorie di domande. Le domande interessate dal cambiamento continueranno a funzionare come prima fino a quando non verranno rimosse dai quiz nei quali appaiono.</p>';
$string['cwrqpfsnoprob'] = 'Nessuna categoria del tuo sito è affetta dal problema \'Domande a caso che pescano domande da sotto-categorie\'.';
$string['defaultfor'] = 'Default per {$a}';
$string['defaultinfofor'] = 'La categoria default per le domande condivise nel contesto \'{$a}\'.';
$string['deletecoursecategorywithquestions'] = 'Ci sono domande nel deposito delle domande associate con questa categoria di corso. Se procedi, queste saranno eliminate. Puoi comunque spostarle prima, usando l\'interfaccia del deposito delle domande.';
$string['disabled'] = 'Disabilitato';
$string['disterror'] = 'La distribuzione {$a} ha causato problemi';
$string['donothing'] = 'Non copiare o spostare files o cambiare links.';
$string['editcategories'] = 'Modifica categorie';
$string['editcategories_help'] = 'Le domande possono essere utilmente raccolte in categorie.

Ciascuna categoria appartiene ad un contesto che determina dove le relative domande possono essere utilizzate:

* Contesto dell\'attività . Le domande sono utilizzabili solo all\'interno del modulo di attività
* Contesto del corso - le domande possono essere utilizzate nelle attività del corso
- Contesto della categoria di corso - le domande possono essere utilizzate nelle attività dei corsi che appartengono alla categoria
- Contesto di sistema - le domande possono essere utilizzate nelle attività dei corsi di tutto il sito

le categorie sono utili anche per le domande casuali che possono essere selezionate da specifiche categorie.';
$string['editingcategory'] = 'Modifica una categoria';
$string['editingquestion'] = 'Modifica una domanda';
$string['editthiscategory'] = 'Modifica questa categoria';
$string['emptyxml'] = 'Errore sconosciuto - file imsmanifest.xml vuoto';
$string['enabled'] = 'Abilitato';
$string['erroraccessingcontext'] = 'Il contesto non può essere acceduto';
$string['errordeletingquestionsfromcategory'] = 'Errore durante l\'eliminazione di domande dalla categoria {$a}.';
$string['errorduringpost'] = 'Si è verificato un errore durante la post-elaborazione!';
$string['errorduringpre'] = 'Si è verificato un errore durante la pre-elaborazione!';
$string['errorduringproc'] = 'Si è verificato un errore durante l\'elaborazione!';
$string['errorduringregrade'] = 'Impossibile rivalutare la domanda {$a->qid}, spostamento nello stato {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Errore: non è possibile copiare il file {$a}.';
$string['errorfilecannotbemoved'] = 'Errore: non è possibile spostare il file {$a}.';
$string['errorfileschanged'] = 'Errore: i file linkati dalle domande sono cambiati da quando è iniziata la visualizzazione del form.';
$string['errormanualgradeoutofrange'] = 'La valutazione {$a->grade} non è compresa tra 0 e {$a->maxgrade} per la domanda {$a->name}. Punteggio e commento non sono stati salvati.';
$string['errormovingquestions'] = 'Errore nello spostamento di domande con ids {$a}.';
$string['errorpostprocess'] = 'Si è verificato un errore durante la post-elaborazione!';
$string['errorpreprocess'] = 'Si è verificato un errore durante la pre-elaborazione!';
$string['errorprocess'] = 'Si è verificato un errore durante l\'elaborazione!';
$string['errorprocessingresponses'] = 'Si è verificato un errore durante l\'elaborazione delle tue risposte.';
$string['errorsavingcomment'] = 'Errore durante il salvataggio nel database del commento per la domanda {$a->name}.';
$string['errorupdatingattempt'] = 'Errore durante l\'aggiornamento del tentativo {$a->id} nel database.';
$string['exportcategory'] = 'Esporta categoria';
$string['exportcategory_help'] = 'L\'impostazione determina la categoria dalla quale esportare le domande.

Alcuni formati di importazione come GIFT e Moodle XML permettono che la categoria e i dati di contesto siano specificati all\'interno del file, in modo da poter scegliere se ricrearli o meno durante l\'importazione. Nel caso, spuntare le caselle opportune.';
$string['exporterror'] = 'Si è verificato un errore durante l\'esportazione!';
$string['exportfilename'] = 'domande';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportquestions'] = 'Esporta le domande in un file';
$string['exportquestions_help'] = 'Questa funzione permette di esportare in un file di testo una intera categoria di domande (e tutte le sue sotto-categorie).
Da notare in base al formato prescelto non sarà possibile esportare alcuni alcuni tipi di domande e alcune informazioni.';
$string['filecantmovefrom'] = 'I file delle domande non possono essere spostati poiché noi hai il privilegio di rimuovere file di domande dal loro posto.';
$string['filecantmoveto'] = 'Il file di domande non può essere copiato né spostato poiché non hai il privilegio di aggiungere file nell\'area dove stai cercando di metterlo.';
$string['filesareacourse'] = 'area file del corso';
$string['filesareasite'] = 'area file del sito';
$string['filestomove'] = 'Sposta / copia i file a {$a}?';
$string['flagged'] = 'Contrassegnata';
$string['flagthisquestion'] = 'Contrassegna questa domanda';
$string['formquestionnotinids'] = 'Il form contiene una domanda non presente tra le id delle domande.';
$string['fractionsnomax'] = 'Una delle risposte dovrebbe avere un punteggio del 100% affinché sia possibile ottenere un voto pieno per questa domanda.';
$string['getcategoryfromfile'] = 'Categoria da file';
$string['getcontextfromfile'] = 'Contesto da file';
$string['ignorebroken'] = 'Ignora link interrotti';
$string['importcategory'] = 'Importa categoria';
$string['importcategory_help'] = 'L\'impostazione permette di scegliere la categoria dove importare le domande.

Alcuni formati di importazione come GIFT e Moodle XML permettono che la categoria e i dati di contesto siano specificati all\'interno del file. Per usare questi dati si devono selezionare le caselle di spunta opportune, senza selezionare la categoria. Qualora la categoria presente nel file non dovesse esistere, sarà creata automaticamente.';
$string['importquestions'] = 'Importa le domande da un file';
$string['importquestions_help'] = 'Permette di importare domande usando file di testo in vari tipi di formato. I file di testo devono essere codificati UTF-8.';
$string['impossiblechar'] = 'Carattere sconosciuto {$a} rilevato al posto della parentesi';
$string['invalidarg'] = 'Argomenti non validi o configurazione server non corretta';
$string['invalidcategoryidforparent'] = 'ID non valido per categoria superiore!';
$string['invalidcategoryidtomove'] = 'ID non valido per categoria da spostare!';
$string['invalidconfirm'] = 'Stringa di conferma non corretta';
$string['invalidcontextinhasanyquestions'] = 'Contesto non valido passato a question_context_has_any_questions.';
$string['invalidwizardpage'] = 'Specificata pagina di aiuto non corretta o assente!';
$string['lastmodifiedby'] = 'Ultima modifica di';
$string['linkedfiledoesntexist'] = 'Il file linkato {$a} non esiste';
$string['makechildof'] = 'Fai figlio di \'{$a}\'';
$string['maketoplevelitem'] = 'Muovi al primo livello';
$string['matchgrades'] = 'Allinea voti';
$string['matchgrades_help'] = '<p>Le valutazioni importate <b>devono</b> corrispondere a uno dei valori della lista fissata, come segue...</p>

<ul>
  <li>100%</li>
  <li>90%</li>
  <li>80%</li>
  <li>75%</li>
  <li>70%</li>
  <li>66.666%</li>
  <li>60%</li>
  <li>50%</li>
  <li>40%</li>
  <li>33.333</li>
  <li>30%</li>
  <li>25%</li>
  <li>20%</li>
  <li>16.666%</li>
  <li>14.2857</li>
  <li>12.5%</li>
  <li>11.111%</li>
  <li>10%</li>
  <li>5%</li>
  <li>0%</li>
</ul>

<p>sono anche permessi valori negativi della lista precedente.</p>

<p>Ci sono due possibilità per questa impostazione. Esse definiscono come il modulo di importazione tratta i valori che non corrispondono <b>esattamente</b> a uno dei valori della lista</p>

<ul>
  <li><b>Errore se valutazione non in elenco</b><br />
Se una domanda contiene valutazioni non elencate nella lista, è mostrato un errore e la domanda non sarà importata.</li>
  <li><b>Valutazione più vicina se non in elenco</b><br />
Se si trova una valutazione che non corrisponde ad alcun valore della lista, la stessa è sostituita dal valore più vicino trovato nella lista</li>
</ul>

<p><i>Nota: alcuni formati di importazione scrivono direttamente nel database e possono bypassare questo controllo</i></p>';
$string['missingcourseorcmid'] = 'Bisogna fornire courseid o cmid a print_questione.';
$string['missingcourseorcmidtolink'] = 'Bisogna fornire courseid o cmid a get_question_edit_link.';
$string['missingimportantcode'] = 'In questo tipo di domanda manca una parte importante: <b>{$a}</b>.';
$string['missingoption'] = 'La domanda cloze {$a} è priva delle sue opzioni';
$string['modified'] = 'Ultimo salvataggio';
$string['move'] = 'Sposta da {$a} e modifica i link.';
$string['movecategory'] = 'Sposta categoria';
$string['movedquestionsandcategories'] = 'Le domande e le categorie di domande sono state spostate da {$a->oldplace} a {$a->newplace}.';
$string['movelinksonly'] = 'Cambia solamente l\'indirizzamento dei link, non spostare o copiare i files.';
$string['moveq'] = 'Sposta domande';
$string['moveqtoanothercontext'] = 'Sposta domanda in un altro contesto';
$string['movingcategory'] = 'Spostamento categoria';
$string['movingcategoryandfiles'] = 'Sei sicuro di voler spostare la categoria {$a->name} e tutte le sotto categorie nel contesto "{$a->contextto}"?<br /> Sono stati rilevati {$a->urlcount} files linkati da domande in {$a->fromareaname}, vuoi copiare o spostare questi in {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Sei sicuro di voler spostare la categoria "{$a->name}" e tutte le sottocategorie nel contesto "{$a->contextto}"?';
$string['movingquestions'] = 'Spostamento domande e File';
$string['movingquestionsandfiles'] = 'Sei sicuro di voler spostare domande da {$a->questions} al contesto di <strong>"{$a->tocontext}"</strong>?<br /> Sono stati rilevati<strong>{$a->urlcount} files</strong> linkati da queste domande in {$a->fromareaname}, vuoi copiare o spostare questi files in {$a->toareaname}?.';
$string['movingquestionsnofiles'] = 'Sei sicuro di voler spostare domande da {$a->questions} al contesto di <strong>"{$a->tocontext}"</strong>?<br /> <strong>Non ci sono files</strong> linkati da queste domande in {$a->fromareaname}.';
$string['needtochoosecat'] = 'Devi scegliere una categoria dove spostare questa domanda oppure clicca su \'Annulla\'.';
$string['nocate'] = 'La categoria {$a} non esiste!';
$string['nopermissionadd'] = 'Non sei autorizzato ad aggiungere domande qui.';
$string['nopermissionmove'] = 'Non sei autorizzato a spostare domande da qui. Puoi salvare la domanda in questa categoria oppure salvarla come nuova domanda.';
$string['noprobs'] = 'Non trovato alcun problema nel tuo database delle domande.';
$string['notenoughdatatoeditaquestion'] = 'Non è stato specificato un id di domanda, o un id di categoria e il tipo domanda.';
$string['notenoughdatatomovequestions'] = 'Devi fornire l\'ID delle domande che vuoi spostare.';
$string['notflagged'] = 'Non contrassegnata';
$string['novirtualquestiontype'] = 'Non ci sono tipi virtuali di domanda per il tipo di domanda {$a}';
$string['parentcategory'] = 'Categoria genitore';
$string['parentcategory_help'] = 'La nuova categoria sarà inserita all\'interno della categoria genitore. "Top" significa che la nuova categoria non sarà inserita in nessun\'altra categoria.
I contesti delle categoria sono visualizzati in grassetto. Per ogni contesto dovrebbe essere presente almeno una categoria. ';
$string['parenthesisinproperclose'] = 'La parentesi prima di ** non è chiusa correttamente in {$a}**';
$string['parenthesisinproperstart'] = 'La parentesi prima di ** non è aperta correttamente in {$a}**';
$string['penaltyfactor'] = 'Fattore di penalità';
$string['penaltyfactor_help'] = '<p>Per ogni risposta errata può essere definita la frazione di punteggio raggiunto che deve essere sottratta. Questo è significativo solamente se il quiz è eseguito in modo adattativo tale per cui allo studente è permesso di rispondere più volte alla domanda. Il fattore di penalità può essere un numero tra 0 e 1. Un fattore uguale a 1 significa che lo studente deve rispondere correttamente al primo tentativo se vuole ottenere qualche punto dalla domanda in questione. Un fattore uguale a 0 significa che lo studente può provare quante volte vuole e ancora aspirare al massimo punteggio per la stessa domanda.</p>';
$string['permissionedit'] = 'Modificare questa domanda';
$string['permissionmove'] = 'Spostare questa domanda';
$string['permissionsaveasnew'] = 'Salvare questa domanda come nuova domanda';
$string['permissionto'] = 'Sei autorizzato a:';
$string['published'] = 'condivise';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">La domanda "{$a->name}" ({$a->qtype})</a> è in questa categoria ma è anche usata nel <a href="{$a->qurl}">quiz "{$a->quizname}"</a> nell\'altro corso "{$a->coursename}".';
$string['questionbank'] = 'Deposito delle domande';
$string['questioncategory'] = 'Categoria di domande';
$string['questioncatsfor'] = 'Categorie di domande per \'{$a}\'';
$string['questiondoesnotexist'] = 'Questa domanda non esiste';
$string['questionname'] = 'Nome della domanda';
$string['questionsaveerror'] = 'Si sono verificati errori durante il salvataggio della domanda - ({$a})';
$string['questionsmovedto'] = 'Domande ancora in uso spostate a "{$a}" nella categoria superiore di corso.';
$string['questionsrescuedfrom'] = 'Domande salvate dal contesto {$a}.';
$string['questionsrescuedfrominfo'] = 'Queste domande (alcune delle quali possono essere nascoste) sono state salvate quando il contesto {$a} è stato eliminato, in quanto sono ancora utilizzate da qualche quiz o da altre attività.';
$string['questiontype'] = 'Tipo di domanda';
$string['questionuse'] = 'Usa domanda in questa attività';
$string['saveflags'] = 'Salva lo stato dei contrassegni';
$string['selectacategory'] = 'Scegli una categoria:';
$string['selectaqtypefordescription'] = 'Scegli un tipo di domanda per vederne la descrizione.';
$string['selectquestionsforbulk'] = 'Seleziona le domande per azioni su elenchi';
$string['shareincontext'] = 'Condividi in contesto per {$a}';
$string['stoponerror'] = 'Fermati in presenza di errori';
$string['stoponerror_help'] = 'L\'impostazione determina se il processo di importazione si deve fermare in presenza di errori senza importare nessuna domanda, oppure se deve tralasciare le domande con errori importando solo le domande corrette.';
$string['tofilecategory'] = 'Scrivi categoria su file';
$string['tofilecontext'] = 'Scrivi contesto su file';
$string['unknown'] = 'Sconosciuto';
$string['unknownquestiontype'] = 'Tipo domanda sconosciuto: {$a}.';
$string['unknowntolerance'] = 'Tipo tolleranza sconosciuto: {$a}.';
$string['unpublished'] = 'non condivise';
$string['upgradeproblemcategoryloop'] = 'Rilevato un problema nell\'aggiornamento delle categorie di domande. C\'è un circolo nell\'albero delle categorie. Gli id delle categorie interessate sono {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'La categoria di domande {$a->name} ({$a->id}) non può essere aggiornata.';
$string['upgradeproblemunknowncategory'] = 'Rilevato un problema nell\'aggiornamento delle categorie di domande. La categoria {$a->id} sta sotto alla categoria {$a->parent}, che non esiste. La categoria superiore è stata cambiata per risolvere il problema.';
$string['wrongprefix'] = 'Nameprefix {$a} formattato erroneamente';
$string['youmustselectaqtype'] = 'Devi scegliere il tipo di domanda.';
$string['yourfileshoulddownload'] = 'Il download del file di esportazione dovrebbe cominciare tra breve. Altrimenti cliccare <a href="{$a}">qui</a>.';
