<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'hu', branch 'MOODLE_20_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptederror'] = 'Elfogadott hiba';
$string['accessnoticesheader'] = 'Előzetesen megtekintheti a tesztet, de ha ez valóságos próbálkozás volna, Ön nem hajthatná végre, mert:';
$string['action'] = 'Művelet';
$string['adaptive'] = 'Adaptív mód';
$string['adaptive_help'] = 'Bekapcsolása esetén egy kérdésre a teszt ugyanazon megoldása során több válasz adható. Így ha egy válasz hibásnak minősül, a tanuló azonnal újból próbálkozhat. Ugyanakkor a "Levonások alkalmazása" beállítástól függően minden hibás válasz esetén megtörténik a levonás.';
$string['addaquestion'] = 'Kérdés hozzáadása...';
$string['addarandomquestion'] = 'Véletlen kérdés hozzáadása...';
$string['addarandomquestion_help'] = 'Véletlenszerű kérdés hozzáadásakor a tesztbe beszúrandó kategóriából származó, véletlenszerűen kiválasztott kérdés kerül. Vagyis a tanulók más-más kérdéseket fognak kapni, és ha a teszten több próbálkozás hajtható végre, akkor minden próbálkozás esetén más-más kérdésekkel fog találkozni.';
$string['addcategory'] = 'Kategória hozzáadása';
$string['adddescriptionlabel'] = 'Leírás/címke hozzáadása';
$string['addingcalculated'] = 'Számításos kérdés hozzáadása';
$string['addingdescription'] = 'Leírás hozzáadása';
$string['addingessay'] = 'Esszé hozzáadása';
$string['addingmatch'] = 'Párosító kérdés hozzáadása';
$string['addingmultianswer'] = 'Beágyazott válaszok (kiegészítendő) hozzáadása ';
$string['addingmultichoice'] = 'Feleletválasztós kérdés hozzáadása';
$string['addingnumerical'] = 'Számjegyes kérdés hozzáadása';
$string['addingquestion'] = 'Kérdés hozzáadása';
$string['addingquestions'] = 'Az oldalon itt kezelheti kérdéseinek adatbázisát. A kérdések kategóriákba vannak rendezve és kurzusán belül bármely tesztben felhasználhatók, sőt, más kurzusokban is, ha úgy dönt, hogy "közzéteszi" őket. Kérdéskategória kiválasztása vagy létrehozása után hozhat létre vagy szerkeszthet kérdéseket. A kérdések közül bármelyiket kiválaszthatja és hozzáadhatja az oldal másik felén lévő teszthez.';
$string['addingrandom'] = 'Véletlenszerű kérdés hozzáadása';
$string['addingrandomsamatch'] = 'Véletlenszerű kiegészítendő párosító kérdés hozzáadása';
$string['addingshortanswer'] = 'Kiegészítendő kérdés hozzáadása';
$string['addingtruefalse'] = 'Igaz-hamis kérdés hozzáadása';
$string['addmoreoverallfeedbacks'] = 'További {no} visszajelzésmező hozzáadása';
$string['addnewgroupoverride'] = 'Csoportfelülírás hozzáadása';
$string['addnewpagesafterselected'] = 'Új oldalak hozzáadása a kiválasztott kérdések után';
$string['addnewquestionsqbank'] = 'Kérdések hozzáadása a(z)  {$a->catname}: {$a->link} kategóriához';
$string['addnewuseroverride'] = 'Felhasználói felülírás hozzáadása';
$string['addpagehere'] = 'Oldal hozzáadása ide';
$string['addquestion'] = 'Kérdés hozzáadása';
$string['addquestions'] = 'Kérdések hozzáadása';
$string['addquestionstoquiz'] = 'Kérdések hozzáadása ehhez a teszthez';
$string['addrandom'] = '{$a} véletlenszerű kérdés hozzáadása';
$string['addrandom1'] = '<< Hozzáadás';
$string['addrandom2'] = 'véletlenszerű kérdések';
$string['addrandomfromcategory'] = 'Véletlenszerű kérdések hozzáadása ebből a kategóriából:';
$string['addrandomquestion'] = 'Véletlenszerű kérdés hozzáadása';
$string['addrandomquestiontoquiz'] = 'Véletlenszerű kérdés hozzáadása a(z) {$a} teszthez';
$string['addselectedtoquiz'] = 'Kiválasztott hozzáadása a teszthez';
$string['addtoquiz'] = 'Hozzáadás a teszthez';
$string['affectedstudents'] = 'Érintett {$a}';
$string['aftereachquestion'] = 'Az egyes kérdések hozzáadása után';
$string['afternquestions'] = '{$a} kérdés hozzáadása után';
$string['age'] = 'kor';
$string['aiken'] = 'Aiken-forma';
$string['allattempts'] = 'Minden próbálkozás';
$string['allinone'] = 'Korlátlan';
$string['allowreview'] = 'Ellenőrzés engedélyezése';
$string['alreadysubmitted'] = 'Ezt a próbálkozást már feltehetőleg leadta';
$string['alternativeunits'] = 'Alternatív egységek';
$string['alwaysavailable'] = 'Mindig elérhető';
$string['analysisoptions'] = 'Elemzési lehetőségek';
$string['analysistitle'] = 'Tételelemzési táblázat';
$string['answer'] = 'Válasz';
$string['answered'] = 'Megválaszolva';
$string['answerhowmany'] = 'Egy vagy több válasz?';
$string['answers'] = 'Válaszok';
$string['answersingleno'] = 'Több válasz lehetséges';
$string['answersingleyes'] = 'Csak egy válasz';
$string['answerswithacceptederrormarginmustbenumeric'] = 'Az elfogadott hibát tartalmazó válaszok csak számjegyesek lehetnek';
$string['answertoolong'] = 'A válasz a {$a} sor után túl hosszú (max. 255 kar.)';
$string['aon'] = 'AON-forma';
$string['areyousureremoveselected'] = 'Biztosan törli az összes kiválasztott kérdést?';
$string['asshownoneditscreen'] = 'Amint a szerkesztő képernyőn látható.';
$string['attempt'] = '{$a} próbálkozás';
$string['attemptalreadyclosed'] = 'A próbálkozás már véget ért.';
$string['attemptclosed'] = 'A próbálkozás még nincs lezárva';
$string['attemptduration'] = 'Felhasznált idő';
$string['attemptedon'] = 'Próbálkozás ideje';
$string['attempterror'] = 'Most nem próbálkozhat ezzel a teszttel, mert: {$a}';
$string['attemptfirst'] = 'Első próbálkozás';
$string['attemptincomplete'] = 'A próbálkozás ({$a} részéről) még nem fejeződött be.';
$string['attemptlast'] = 'Utolsó próbálkozás';
$string['attemptnumber'] = 'Próbálkozás';
$string['attemptquiznow'] = 'Teszt megoldása most';
$string['attempts'] = 'Próbálkozások';
$string['attemptsallowed'] = 'Engedélyezett próbálkozás';
$string['attemptsallowedn'] = 'Engedélyezett próbálkozás: {$a}';
$string['attemptsdeleted'] = 'Teszt próbálkozásai törölve';
$string['attemptselection'] = 'Felhasználónként elemzendő próbálkozások kiválasztása';
$string['attemptsexist'] = 'A teszttel már történt próbálkozás. Több kérdést nem adhat hozzá és nem törölhet.';
$string['attemptsnum'] = 'Próbálkozás: {$a}';
$string['attemptsnumthisgroup'] = 'Próbálkozás: {$a->total} ({$a->group} ebből a csoportból)';
$string['attemptsnumyourgroups'] = 'Próbálkozás: {$a->total} ({$a->group} a csoportjából)';
$string['attemptsonly'] = 'Csak a próbálkozó tanulók megjelenítése';
$string['attemptsunlimited'] = 'Korlátlan számú próbálkozás';
$string['back'] = 'Vissza a kérdés előzetes megtekintéséhez';
$string['backtoquestionlist'] = 'Vissza a kérdések felsorolásához';
$string['backtoquiz'] = 'Vissza a teszt szerkesztéséhez';
$string['basicideasofquiz'] = 'A tesztkészítés alapelvei';
$string['bestgrade'] = 'Legjobb pont';
$string['blackboard'] = 'Blackboard';
$string['blackboard_six'] = 'Blackboard V6+';
$string['bothattempts'] = 'Próbálkozó és nem próbálkozó tanulók megjelenítése';
$string['braceerror'] = 'A válaszokat nem veszi körül {...}';
$string['browsersecurity'] = 'A böngésző biztonságossága';
$string['browsersecurity_help'] = 'Ha a "Teljes képernyős előugró ablak némi javascript biztonsággal" van kiválasztva,

* A teszt csak akkor kezdődik, ha a tanuló böngészője bekapcsolt javascripttel rendelkezik
* A teszt teljes képernyős előugró ablakban jelenik meg, amely elfedi az összes többi ablakot, és nincsenek rajta navigációs eszközök
* A tanulók az adott lehetőségek függvényében nem használhatnak olyan funkciókat, mint a másolás és a beillesztés';
$string['calculated'] = 'Számításos';
$string['calculatedquestion'] = 'A számításos kérdés {$a} sornál nincs támogatva. A kérdés kimarad.';
$string['cannotcreatepath'] = 'Az útvonal nem hozható létre ({$a})';
$string['cannoteditafterattempts'] = 'Nem adhat hozzá és nem távolíthat el kérdéseket, mert a teszt megoldása folyamatban van. ({$a})';
$string['cannotfindprevattempt'] = 'Nem található a felhasználandó korábbi próbálkozás.';
$string['cannotfindquestionregard'] = 'Nem sikerült a kérdéseket újrapontozáshoz elérni!';
$string['cannotinsert'] = 'Nem szúrható be kérdés';
$string['cannotinsertrandomquestion'] = 'Nem sikerült az új véletlenszerű kérdés hozzáadása';
$string['cannotloadquestion'] = 'A kérdés válaszlehetőségeinek betöltése nem sikerült!';
$string['cannotloadtypeinfo'] = 'Nem sikerült betölteni a kérdéstípusra vonatkozó kérdésadatokat';
$string['cannotopen'] = 'Exportálási fájl nem nyitható meg ({$a})';
$string['cannotread'] = 'Importálási fájl nem olvasható (vagy üres)';
$string['cannotrestore'] = 'A kérdésszakaszok helyreállítása nem sikerült!';
$string['cannotreviewopen'] = 'A próbálkozást nem ellenőrizheti, még nincs lezárva.';
$string['cannotsavelayout'] = 'Az elrendezést nem sikerült elmenteni.';
$string['cannotsavenumberofquestion'] = 'Nem sikerült elmenteni az oldalankénti kérdésszámot.';
$string['cannotsavequestion'] = 'Nem menthető el a kérdéslista';
$string['cannotsetgrade'] = 'Nem sikerült elmenteni a teszt új maximális pontszámát.';
$string['cannotsetsumgrades'] = 'A sumgrades elmentése nem sikerült.';
$string['cannotwrite'] = 'Nem lehet az exportálási állományba írni ({$a})';
$string['caseno'] = 'Nincs jelentősége a kis-/nagybetűnek';
$string['casesensitive'] = 'Kis-/nagybetű különböző';
$string['caseyes'] = 'Igen, a kis- és nagybetűk különbözőek';
$string['categories'] = 'Kategóriák';
$string['category'] = 'Kategória';
$string['categoryadded'] = 'A(z) \'{$a}\' kategória hozzáadva';
$string['categorydeleted'] = 'A(z) \'{$a}\' kategória törlése megtörtént';
$string['categoryinfo'] = 'Kategóriára vonatkozó infó';
$string['categorymove'] = 'A(z) \'{$a->name}\' kategória {$a->count} kérdést tartalmaz (egy részük lehet régi, rejtett, de még néhány tesztben előfordul). Válassza ki, melyik kategóriába kerüljenek át.';
$string['categorymoveto'] = 'Ebbe a kategóriába kerüljenek át';
$string['categorynamecantbeblank'] = 'A kategórianév nem lehet üres.';
$string['categorynoedit'] = 'A(z) \'{$a}\' kategóriához nincs szerkesztési jogosultsága.';
$string['categoryupdated'] = 'A kategória frissítése sikerült';
$string['changessaved'] = 'Pontozási változások elmentve';
$string['changessavedwitherrors'] = 'A pontozási változások mentése közben néhány hiba történt';
$string['checkanswer'] = 'Ellenőrzés';
$string['choice'] = 'Válaszlehetőség';
$string['choices'] = 'Lehetséges válaszlehetőségek';
$string['choosefile'] = 'Válasszon egy állományt';
$string['close'] = 'Ablak bezárása';
$string['closebeforeopen'] = 'A tesztet nem lehetett frissíteni. A befejezés időpontjának korábbi dátumot adott meg, mint a kezdésnek.';
$string['closed'] = 'Lezárva';
$string['closepreview'] = 'Megtekintés bezárása';
$string['closereview'] = 'Ellenőrzés bezárása';
$string['comment'] = 'Megjegyzés';
$string['commentorgrade'] = 'Megjegyzés írása vagy pont felülírása';
$string['comments'] = 'Megjegyzések';
$string['completedon'] = 'Befejezés dátuma';
$string['configadaptive'] = 'Ha itt Igent választ, a tanuló több választ adhat egy kérdésre akár ugyanazon próbálkozás során is.';
$string['configattemptsallowed'] = 'A tanulók számára a teszt során megengedett próbálkozások számának korlátozása';
$string['configdecimaldigits'] = 'Pontok kijelzésekor a tizedesjegy után megjelenítendő számjegyek száma';
$string['configdecimalplaces'] = 'A teszt pontszámainak megjelenítése során a tizedesvessző után kijelzendő számjegyek száma';
$string['configdecimalplacesquestion'] = 'Az egyes kérdések pontszámainak megjelenítése során a tizedesvessző után kijelzendő számjegyek száma';
$string['configdelay1'] = 'Ha késleltetést állít be, a tanulónak az első próbálkozás után eddig kell várnia a teszttel való ismételt próbálkozásig.';
$string['configdelay1st2nd'] = 'Ha késleltetést állít be, a tanulónak az első próbálkozás után ennyi ideig várnia kell a teszttel való ismételt próbálkozásig.';
$string['configdelay2'] = 'Ha késleltetést állít be, a tanulónak eddig kell várnia a harmadik vagy azt követő próbálkozásig.';
$string['configdelaylater'] = 'Ha késleltetést állít be, a tanulónak az előző próbálkozás után ennyi ideig várnia kell a teszttel való harmadik, negyedik... próbálkozásig.';
$string['configeachattemptbuildsonthelast'] = 'Ha több próbálkozásra van lehetőség, akkor az egyes próbálkozások tartalmazzák a korábbi eredményét.';
$string['configgrademethod'] = 'Ha több próbálkozásra van lehetőség, melyik módszerrel számítsa ki a rendszer a tanuló tesztben elért végső pontszámát?';
$string['configintro'] = 'Az itt megadott értékek lesznek azok az alapértékek, amelyek új teszt létrehozásakor megjelennek a beállítások űrlapján. Azt is megadhatja, hogy melyik tesztbeállítások legyenek haladó szintűek.';
$string['configmaximumgrade'] = 'Azon alappont, amelyhez viszonyítva a teszt pontjai tartományt képeznek.';
$string['confignewpageevery'] = 'Ha kérdéseket ad a teszthez, az oldaltörések automatikusan az itt megadottak szerint szúródnak be.';
$string['configpenaltyscheme'] = 'Adaptív módban a hibás válaszokért levonandó büntetés.';
$string['configpopup'] = 'A próbálkozás előugró ablakban jelenjen meg és használja a javascriptet a másolás és beillesztés stb. korlátozására próbálkozások során.';
$string['configrequirepassword'] = 'A tanulóknak ezt a jelszót kell megadni a teszt megoldása előtt.';
$string['configrequiresubnet'] = 'A tanulók csak ezekről a számítógépekről próbálkozhatnak a teszt megoldásával.';
$string['configreviewoptions'] = 'Ezek a beállítások szabályozzák, milyen információkat láthatnak a felhasználók egy próbálkozás ellenőrzése vagy tesztjelentések megtekintése során.';
$string['configshowblocks'] = 'Blokkok megjelenítése a teszten végrehajtott próbálkozások során.';
$string['configshowuserpicture'] = 'Próbálkozások alatt jelenítse meg a felhasználó képét.';
$string['configshufflequestions'] = 'Bekapcsolása esetén a teszt kérdései véletlenszerűen keverednek minden egyes próbálkozás előtt.';
$string['configshufflewithin'] = 'Bekapcsolása esetén az egyes kérdések részei véletlenszerűen keverednek minden egyes próbálkozás előtt, amennyiben ezt a kérdés beállításainál is bekapcsolja.';
$string['configtimelimit'] = 'Percekben megadott alapértelmezett időkorlát a tesztekhez. A 0 azt jelenti, hogy nincs időkorlát.';
$string['configtimelimitsec'] = 'Tesztek alapvető időkorlátja másodpercekben. A 0 az időkorlát hiányát jelenti.';
$string['configurerandomquestion'] = 'Kérdés beállítása';
$string['confirmclose'] = 'A próbálkozást be fogja zárni. Ha így tesz, utána nem módosíthatja válaszait.';
$string['confirmserverdelete'] = 'Biztosan el akarja távolítani a(z) {$a} szervert a felsorolásból?';
$string['confirmstartattemptlimit'] = 'Ezen a teszten csak {$a} próbálkozás hajtható végre. Új próbálkozást készül végrehajtani. Folytatja?';
$string['confirmstartattempttimelimit'] = 'Ezen a teszten időkorlát van és csak {$a} próbálkozás hajtható végre rajta. Új próbálkozást készül végrehajtani. Folytatja?';
$string['confirmstarttimelimit'] = 'Ezen a teszten időkorlát van. Biztosan nekikezd?';
$string['containercategorycreated'] = 'Ezzel a kategóriával az alábbi okok miatt portálszintre áthelyezett összes eredeti kategória tárolására van lehetőség.';
$string['continueattemptquiz'] = 'Utolsó próbálkozás folytatása';
$string['continuepreview'] = 'Utolsó megtekintés folytatása';
$string['copyingfrom'] = 'Másolat készül a(z) \'{$a}\' kérdésről';
$string['copyingquestion'] = 'Kérdés másolása';
$string['correct'] = 'Helyes';
$string['correctanswer'] = 'Helyes válasz';
$string['correctanswerformula'] = 'Helyes válasz képlete';
$string['correctansweris'] = 'A helyes válasz: {$a}';
$string['correctanswerlength'] = 'Szignifikáns számjegyek';
$string['correctanswers'] = 'Helyes válaszok';
$string['correctanswershows'] = 'A helyes válasz látszik';
$string['corrresp'] = 'Helyes válasz';
$string['countdown'] = 'Visszaszámlálás';
$string['countdownfinished'] = 'A teszt véget ér, válaszait most adja le.';
$string['countdowntenminutes'] = 'A teszt 10 percen belül véget ér.';
$string['coursetestmanager'] = 'Kurzusteszt kezelési formája';
$string['createcategoryandaddrandomquestion'] = 'Kategória létrehozása és véletlenszerű kérdés hozzáadása';
$string['createfirst'] = 'Először készítsen néhány kiegészítendő kérdést.';
$string['createmultiple'] = 'Adjon a teszthez néhány véletlen kérdést';
$string['createnewquestion'] = 'Új kérdés létrehozása';
$string['createquestionandadd'] = 'Új kérdés létrehozása és hozzáadása a teszthez.';
$string['custom'] = 'Saját forma';
$string['dataitemneed'] = 'Legalább egy adatkészletet meg kell adnia, hogy érvényes kérdést kapjon';
$string['datasetdefinitions'] = '{$a} kategóriához újrahasználható adatkészlet megadása';
$string['datasetnumber'] = 'Szám';
$string['daysavailable'] = 'Hátralévő napok';
$string['decimaldigits'] = 'Tizedesjegyek a pontozásban';
$string['decimalformat'] = 'tizedesjegyek';
$string['decimalplaces'] = 'Pontok tizedeshelyei';
$string['decimalplaces_help'] = '<p>Itt választhatja ki, hány tizedesjegyig jelenjenek meg a próbálkozásokra adott pontok. \'0\' kiválasztása esetén a pontok egész számokra kerekítődnek.</p>
<p>Ez a beállítás csak a pontok kijelzésére van hatással. Nem befolyásolja a belső számolásokat és a pontok kerekítését.</p>';
$string['decimalplacesquestion'] = 'Kérdéspontok tizedeshelyei';
$string['decimalplacesquestion_help'] = '<p>Az egyes kérdésekhez a globálisak tesztpontszámmal szemben egyedi pontosságot adhat meg a pontok megjelenítéséhez. Például kerekítheti a teszt végső pontszámát a
legközelebbi egész számra, miközben az egyes kérdések továbbra is tört értékeket tartalmaznak.</p>';
$string['decimalpoints'] = 'Tizedesjegyek';
$string['decimals'] = '{$a}-val';
$string['default'] = 'Alapbeállítás';
$string['defaultgrade'] = 'Alapbeállítás szerinti kérdéspont';
$string['defaultinfo'] = 'Kérdések alapkategóriája.';
$string['delay1'] = 'Az első és a második próbálkozás közötti időköz';
$string['delay1st2nd'] = 'Kivárás az 1. és a 2. próbálkozás között.';
$string['delay1st2nd_help'] = '<p>Időköz beállítása esetén a tanulónak az első próbálkozás után a teszt újrapróbálásával várnia kell a megadott ideig.</p>';
$string['delay2'] = 'A későbbi próbálkozások közötti időköz';
$string['delaylater'] = 'Kivárás a későbbi próbálkozások között.';
$string['delaylater_help'] = '<p>Időköz beállítása esetén a tanulónak a második próbálkozás után várnia kell a megadott ideig a teszt harmadik vagy további újrapróbálásaival.</p>';
$string['deleteattemptcheck'] = 'Biztosan törölni akarja az összes próbálkozást?';
$string['deletequestioncheck'] = 'Biztosan törölni akarja a(z) \'{$a}\'-t?';
$string['deletequestionscheck'] = 'Biztosan törli ezeket a kérdéseket?  {$a}';
$string['deleteselected'] = 'A kiválasztott törlése';
$string['deletingquestionattempts'] = 'Kérdéssel való próbálkozások törlése';
$string['description'] = 'Leírás';
$string['disabled'] = 'Kikapcsolva';
$string['discrimination'] = 'Megkül. index';
$string['displayoptions'] = 'Kijelzési lehetőségek';
$string['download'] = 'Az exportált kategóriafájl letöltéséhez kattintson';
$string['downloadextra'] = '(a fájl szerepel a kurzusállományok között is a /backupdata/quiz mappában)';
$string['duplicateresponse'] = 'A leadott munka figyelmen kívül hagyva, mert korábban már adott le ezzel egyenértékű választ.';
$string['eachattemptbuildsonthelast'] = 'Minden próbálkozás az előzőre épül';
$string['eachattemptbuildsonthelast_help'] = '<p>Ha többszöri próbálkozásra van lehetőség és ez a beállítás
<strong>Igen</strong>-re van állítva, akkor minden egyes új próbálkozás  tartalmazni fogja a korábbi próbálkozás eredményét. Ennek eredményeként a teszt több próbálkozással is teljesíthető.</p>

<p>Ha ez a beállítás <strong>Nem</strong>, akkor minden próbálkozás esetén friss teszt jelenik meg.</p>';
$string['editcategories'] = 'Kategóriák szerkesztése';
$string['editcategory'] = 'Kategória szerkesztése';
$string['editcatquestions'] = 'Kategóriakérdések szerkesztése';
$string['editingcalculated'] = 'Számításos kérdés szerkesztése';
$string['editingdescription'] = 'Leírás szerkesztése';
$string['editingessay'] = 'Esszé szerkesztése';
$string['editingmatch'] = 'Párosító kérdés szerkesztése';
$string['editingmultianswer'] = 'Beépített válaszos (kiegészítendő) kérdés szerkesztése';
$string['editingmultichoice'] = 'Feleletválasztós kérdés szerkesztése';
$string['editingnumerical'] = 'Számjegyes kérdés szerkesztése';
$string['editingquestion'] = 'Kérdés szerkesztése';
$string['editingquiz'] = 'Teszt szerkesztése';
$string['editingquiz_help'] = 'Teszt létrehozása esetén a fő fogalmak a következők:
* Az egy vagy több oldalon rögzített kérdéseket tartalmazó teszt
* Az összes kérdés másodpéldányát kategóriákba szervezve tároló kérdésbank
* Véletlenszerű kérdések - A tanuló, ill. a tanulók minden tesztmegoldás alkalmával más-más kérdéseket kap(nak)';
$string['editingrandom'] = 'Véletlenszerű kérdés szerkesztése';
$string['editingrandomsamatch'] = 'Véletlenszerű kiegészítendő párosító kérdés szerkesztése';
$string['editingrqp'] = '{$a}: kérdés szerkesztése';
$string['editingshortanswer'] = 'Kiegészítendő kérdés szerkesztése';
$string['editingtruefalse'] = 'Igaz-hamis kérdés szerkesztése';
$string['editoverride'] = 'Szerkesztés felülírása';
$string['editqcats'] = 'Kérdéskategóriák szerkesztése';
$string['editquestions'] = 'Kérdések szerkesztése';
$string['editquiz'] = 'Teszt szerkesztése';
$string['editquizquestions'] = 'Tesztkérdések szerkesztése';
$string['emailconfirmbody'] = 'Tisztelt {$a->username}!  Köszönjük, hogy \'{$a->quizname}\' tesztre \'{$a->coursename}\' kurzus keretében adott válaszait {$a->submissiontime} időpontban leadta. Ez az e-mail megerősíti, hogy válaszai rendben megérkeztek. A tesztet itt érheti el: {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Köszönjük \'{$a->quizname}\' tesztre leadott válaszát.';
$string['emailconfirmsubject'] = 'Tesztleadás megerősítése: {$a->quizname}';
$string['emailnotifybody'] = 'Tisztelt {$a->username}! {$a->studentname} kitöltötte a(z) \'{$a->coursename}\' kurzus \'{$a->quizname}\' tesztjét ({$a->quizurl}). A próbálkozást megtekintheti itt: {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} a {$a->quizname} tesztet befejezte.';
$string['emailnotifysubject'] = '{$a->studentname} kitöltötte a {$a->quizname} tesztet';
$string['empty'] = 'Üres';
$string['enabled'] = 'Bekapcsolva';
$string['endtest'] = 'Ellenőrzés vége ...';
$string['erroraccessingreport'] = 'A jelentéshez nem férhet hozzá.';
$string['errorinquestion'] = 'Hiba a kérdésben';
$string['errormissingquestion'] = 'Hiba: a rendszerből hiányzik a(z) {$a} azonosítójú kérdés';
$string['errornotnumbers'] = 'Hiba - a válaszoknak számjegyesnek kell lenni';
$string['errorsdetected'] = '{$a} hiba fordult elő';
$string['errorunexpectedevent'] = 'Váratlan {$a->event} eseménykód fordult elő {$a->questionid} kérdéssel kapcsolatban {$a->attemptid} próbálkozás során.';
$string['essay'] = 'Esszé';
$string['essayquestions'] = 'Kérdések';
$string['event1'] = 'Automatikus mentés';
$string['event2'] = 'Mentés';
$string['event3'] = 'Pontozás';
$string['event5'] = 'Hitelesítés';
$string['event6'] = 'Lezárás és pontozás';
$string['event7'] = 'Leadás';
$string['event8'] = 'Lezárás';
$string['event9'] = 'Kézi pontozás';
$string['everynquestions'] = 'Minden {$a}. kérdés';
$string['everyquestion'] = 'Minden kérdés';
$string['everythingon'] = 'Minden bekapcsolva';
$string['examview'] = 'Vizsganézet';
$string['export'] = 'Exportálás';
$string['exportcategory'] = 'exportkategória';
$string['exporterror'] = 'Hiba az exportálás feldolgozása közben';
$string['exportingquestions'] = 'A kérdéseket a rendszer állományba exportálja';
$string['exportname'] = 'Állománynév';
$string['exportquestions'] = 'Kérdések exportálása állományba';
$string['extraattemptrestrictions'] = 'Külön megszorítások a próbálkozásokhoz';
$string['false'] = 'Hamis';
$string['feedback'] = 'Visszajelzés';
$string['feedbackerrorboundaryformat'] = 'A visszajelzési ponthatárok százalékosan vagy számmal adhatók meg. A {$a} határként megadott érték nem kezelhető.';
$string['feedbackerrorboundaryoutofrange'] = 'A visszajelzési ponthatárok 0% és 100% közé eshetnek. A {$a} határként megadott érték nem esik ebbe a tartományba.';
$string['feedbackerrorjunkinboundary'] = 'A visszajelzési ponthatárokat kihagyások nélkül kell megadnia.';
$string['feedbackerrorjunkinfeedback'] = 'A visszajelzési mezőket kihagyások nélkül kell kitöltenie.';
$string['feedbackerrororder'] = 'A visszajelzési ponthatárokat sorrendben kell megadni a legmagasabbtól lefelé. A {$a} határként megadott érték nem esik ebbe a sorba.';
$string['file'] = 'Állomány';
$string['fileformat'] = 'Állományforma';
$string['fillcorrect'] = 'Helyesként töltendő ki';
$string['filloutnumericalanswer'] = 'Legalább egy lehetséges választ és tűrési értéket adjon meg. Az első megfelelő válasz határozza meg a pontszámot és a visszajelzést. Ha visszajelzést ad meg, de nincs a végén válasz, akkor azt azok a tanulók látják, akiknek a válasza egyik válaszhoz sem illik.';
$string['filloutoneanswer'] = 'Legalább egy lehetséges választ meg kell adnia. Az üresen hagyott válaszok kimaradnak. A \'*\' használható bármely karakter helyettesítőjeként. A pontszám és a visszajelzés meghatározása az első helyes válasz alapján történik.';
$string['filloutthreequestions'] = 'Legalább három kérdést kell kitöltenie a hozzájuk tartozó válaszokkal együtt. További rossz válaszokat is megadhat, ha üres kérdésre ad választ. Az üresen hagyott kérdéseket és válaszokat tartalmazó bejegyzéseket a rendszer figyelmen kívül hagyja.';
$string['fillouttwochoices'] = 'Legalább két válaszlehetőséget meg kell adnia. Az üresen hagyott válaszlehetőségek kimaradnak.';
$string['finishattemptdots'] = 'Próbálkozás befejezése...';
$string['finishreview'] = 'Ellenőrzés befejezése';
$string['forceregeneration'] = 'újragenerálás előírása';
$string['formatnotfound'] = 'Az importálási/exportálási {$a} forma nem található';
$string['formatnotimplemented'] = 'A forma hibás, küldjön hibajelentést';
$string['formulaerror'] = 'Képlethiba!';
$string['fractionsaddwrong'] = 'A pozitív pontok összege nem 100%,<br />hanem {$a}%.<br />Visszatér és kijavítja ezt a kérdést?';
$string['fractionsnomax'] = 'Az egyik válaszlehetőségnek 100%-nak kell lenni ahhoz,<br />hogy teljes pontszámot kapjon erre a kérdésre.<br />Visszatér és kijavítja a kérdést?';
$string['fromfile'] = 'forrásállomány:';
$string['functiondisabledbysecuremode'] = 'Ez a funkció jelenlen ki van kapcsolva';
$string['functiontakesatleasttwo'] = 'A(z) {$a} függvénynek legalább két argumentummal kell rendelkezni.';
$string['functiontakesnoargs'] = 'A(z) {$a} függvénynek nincsenek argumentumai';
$string['functiontakesonearg'] = 'A(z) {$a} függvénynek pontosan egy argumentummal kell rendelkezni.';
$string['functiontakesoneortwoargs'] = 'A(z) {$a} függvénynek egy vagy két argumentummal kell rendelkezni.';
$string['functiontakestwoargs'] = 'A(z) {$a} függvénynek pontosan két argumentummal kell rendelkezni.';
$string['generalfeedback'] = 'Általános visszajelzés';
$string['generalfeedback_help'] = '<p>A kérdéshez kapcsolódó általános szöveget a tanuló a kérdéssel való próbálkozás után látja.
A visszajelzéstől eltérően, amely a kérdésfajtától és a tanuló válaszától függően változik,
az általános szöveget minden tanuló látja.</p>

<p>Az általános szöveg megjelenítését a tesztszerkesztő űrlapon lévő "A tanulók megtekinthetik:" jelölőnégyzetekkel
állíthatja be.</p>
<p>Az általános szöveggel a tanulókat tájékoztathatja arról, hogy a kérdés milyen ismereteket
ellenőriz, illetve ugrópontokat adhat meg nekik, melyeken keresztül a kérdésről részletesebben
tájékozódhatnak.</p>';
$string['generatevalue'] = 'Új érték létrehozása ezek között';
$string['geometric'] = 'Geometriai';
$string['gift'] = 'GIFT-forma';
$string['giftleftbraceerror'] = 'Hiányzik egy {';
$string['giftmatchingformat'] = 'A párosító kérdések formája hibás';
$string['giftnonumericalanswers'] = 'Számjegyes kérdéshez nincs válasz';
$string['giftnovalidquestion'] = 'Nincs érvényes kérdés';
$string['giftqtypenotset'] = 'A kérdéstípus nincs beállítva';
$string['giftrightbraceerror'] = 'Hiányzik egy }';
$string['grade'] = 'Pont';
$string['gradeall'] = 'Az összes pontozása';
$string['gradeaverage'] = 'Átlagpont';
$string['gradeboundary'] = 'Ponthatár';
$string['gradeessays'] = 'Esszék pontozása';
$string['gradehighest'] = 'Legmagasabb pont';
$string['grademethod'] = 'Pontozási módszer';
$string['grademethod_help'] = '<p>Ha többszöri próbálkozást enged meg, többféleképpen hasznosíthatja a pontokat a tanuló adott tesztben elért végső pontszámának a kiszámításához.</p>

<h2>Legmagasabb pont</h2>
<p>A végső pontszám minden egyes próbálkozás esetén a legmagasabb (legjobb) pontszám.</p>

<h2>Átlagpont</h2>
<p>A végső pontszám az összes próbálkozás alapján számított átlagos (egyszerű számtani középarányos) pontszám.
</p>
<h2>Első próbálkozás</h2>
<p>A végső pontszám az első próbálkozás során szerzett pontszám (a többi próbálkozást a rendszer figyelmen kívül hagyja).
</p>
<h2>Utolsó próbálkozás</h2>
<p>A végső pontszám kizárólag a legutóbbi próbálkozás során elért pontszámot tartalmazza.
</p>';
$string['gradesdeleted'] = 'Tesztpontok törölve';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Leadott munka pontjai: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Az előző büntetésekkel ez <strong>{$a->cur}/{$a->max}</strong> lesz.';
$string['gradingdetailspenalty'] = 'Erre a leadott munkára {$a} büntetőpontot kapott.';
$string['gradingdetailszeropenalty'] = 'Erre a leadott munkára nem kapott büntetőpontot.';
$string['gradingmethod'] = 'Pontozási módszer: {$a}';
$string['groupoverrides'] = 'Csoport felülírásai';
$string['groupsnone'] = 'A kurzusban nincsenek csoportok';
$string['guestsno'] = 'Vendégek nem tekinthetnek meg és nem oldhatnak meg teszteket';
$string['hidebreaks'] = 'Oldaltörések elrejtése';
$string['hidereordertool'] = 'Az átrendező eszköz elrejtése';
$string['history'] = 'Válaszok előzményei';
$string['illegalformulasyntax'] = 'Hibás szintaxisú képlet a(z) \'{$a}\' ponttól';
$string['imagedisplay'] = 'Megjelenítendő kép';
$string['imagemissing'] = 'A(z) {$a} soron nincs meg a kép. Az állomány neve kihagyva.';
$string['import'] = 'Importálás';
$string['importcategory'] = 'kategória importálása';
$string['importerror'] = 'Hiba importálás feldolgozása közben';
$string['importerrorquestion'] = 'Hiba kérdés importálása közben';
$string['importfilearea'] = 'Kurzusfájlok között már szereplő állomány importálása...';
$string['importfileupload'] = 'Importálás fájlfeltöltésből...';
$string['importfromthisfile'] = 'Importálás ebből az állományból';
$string['import_help'] = 'A funkcióval kérdéseket importálhat külső szöveges állományokból.
Ha nem ascii-karaktereket tartalmaznak, az UTF-8 kódolást kell használnia. Különösen a Microsoft Office által előállított állományokkal legyen óvatos, mert ezek gyakran speciális, megfelelő módon kezelhetetlen kódolást használnak.
Az importálási és exportálási formátumok használata választható. Egyéb formátumokat talál a Modulok és a Segédprogramok adatbázisban.';
$string['importingquestions'] = '{$a} kérdés importálása állományból';
$string['importmax10error'] = 'Hiba a kérdésben. Tíznél több választ nem adhat meg.';
$string['importmaxerror'] = 'Hiba a kérdésben. Túl sok a válasz.';
$string['importminerror'] = 'Hiba a kérdésben. Kevés a válasz ehhez a kérdéstípushoz.';
$string['importparseerror'] = 'Hiba az importált állomány feldolgozása közben. Nem került sor kérdések importálására. A jó kérdések importálásához próbálja meg Nem-re állítani a Hiba esetén leállás-t.';
$string['importquestions'] = 'Kérdések importálása állományból';
$string['inactiveoverridehelp'] = '- A tanuló nem rendelkezik megfelelő csoporttal vagy szereppel a teszt megoldásához';
$string['incorrect'] = 'Hibás';
$string['indivresp'] = 'Az egyes tételekre leadott válaszok ';
$string['info'] = 'Infó';
$string['infoshort'] = 'i';
$string['introduction'] = 'Bevezetés';
$string['invalidattemptid'] = 'Nincs ilyen próbálkozásazonosító';
$string['invalidcategory'] = 'Érvénytelen kategóriaazonosító';
$string['invalidnumericanswer'] = 'Az egyik megadott válasz nem érvényes szám.';
$string['invalidnumerictolerance'] = 'Az egyik megadott tűréshatár nem érvényes szám.';
$string['invalidoverrideid'] = 'Érvénytelen felülírási azonosító';
$string['invalidquestionid'] = 'Érvénytelen kérdésazonosító';
$string['invalidquizid'] = 'Érvénytelen tesztazonosító';
$string['invalidsource'] = 'A forrás nem érvényes';
$string['invalidsourcetype'] = 'A forrás típusa nem érvényes';
$string['invalidstateid'] = 'Érvénytelen állapotazonosító';
$string['itemanal'] = 'Tételre adott feleletek elemzése';
$string['itemdefinition'] = 'Meghatározás';
$string['itemsource'] = 'Tételforrás';
$string['itemsourceformat'] = 'Tételforrás formája';
$string['itemtypes'] = 'Távoli kérdéstípusok';
$string['lastanswer'] = 'Utolsó válasza ez volt';
$string['layout'] = 'Elrendezés';
$string['layoutasshown'] = 'Elrendezés a megjelenítés szerint';
$string['layoutasshownwithpages'] = 'Elrendezés a megjelenítés szerint. <small>(Automatikus új oldal {$a} kérdésenként.)</small>';
$string['layoutshuffledandpaged'] = 'Kérdések véletlenszerű összekeverése oldalanként {$a} kérdéssel.';
$string['layoutshuffledsinglepage'] = 'Kérdések véletlenszerű összekeverése egyetlen oldalon.';
$string['learnwise'] = 'Learnwise-forma';
$string['link'] = 'Ugrópont';
$string['listitems'] = 'Teszt tételeinek felsorolása';
$string['literal'] = 'Szövegkonstans';
$string['loadingquestionsfailed'] = 'A kérdések betöltése nem sikerült: {$a}';
$string['loguniform'] = 'egységes logaritmusos szórásból származó számjegyek';
$string['makecopy'] = 'Mentés új kérdésként';
$string['managetypes'] = 'Kérdéstípusok és szerverek kezelése';
$string['manualgrading'] = 'Pontozás';
$string['mark'] = 'Leadás';
$string['markall'] = 'Oldal leadása';
$string['marks'] = 'Pontok';
$string['match'] = 'Párosító';
$string['matchanswer'] = 'Párosító válasz';
$string['matchanswerno'] = 'Hozzáillő {$a} válasz';
$string['matcherror'] = 'A pontok és a pontozási opciók nem egyeznek - kérdés kihagyva';
$string['matchgrades'] = 'Pontok összehasonlítása';
$string['matchgradeserror'] = 'Hiba, ha a pont nem szerepel a felsorolásban';
$string['matchgradesnearest'] = 'A legközelebbi pont, ha a pont nem szerepel a felsorolásban';
$string['max'] = 'Max.';
$string['messageprovider:confirmation'] = 'Saját tesztleadásainak megerősítése';
$string['messageprovider:submission'] = 'Értesítés tesztleadásokról ';
$string['min'] = 'min.';
$string['minutes'] = 'perc';
$string['missinganswer'] = 'Túl kevés :VÁLASZ, :Lx, :Rx megadva a(z) {$a} kérdéssorhoz. Legalább 2 lehetséges választ meg kell adnia';
$string['missingcorrectanswer'] = 'A helyes választ meg kell adni';
$string['missingformula'] = 'Hiányzó képlet';
$string['missingitemtypename'] = 'Hiányzó név';
$string['missingname'] = 'Hiányzó kérdésnév';
$string['missingquestion'] = '{$a} sor után hiányzó kérdéscímke';
$string['missingquestiontext'] = 'Hiányzó kérdésszöveg';
$string['missingword'] = 'Hiányzó szóforma';
$string['modulename'] = 'Teszt';
$string['modulename_help'] = 'A tesztmodullal a tanár feleletválasztós, igaz-hamis, párosító és más kérdéseket tartalmazó teszteket tervezhet és állíthat össze. Az egyes próbálkozások követése automatikus, a tanár pedig választása szerint adhat visszajelzést és/vagy megjelenítheti a helyes válaszokat.';
$string['modulenameplural'] = 'Tesztek';
$string['moveselectedonpage'] = 'A kiválasztott kérdések áthelyezése a(z) {$a} oldalra';
$string['moveto'] = 'Áthelyezés >>';
$string['multianswer'] = 'Beépített válaszok (kitöltő)';
$string['multichoice'] = 'Feleletválasztós';
$string['multipleanswers'] = 'Válasszon legalább egy válaszlehetőséget.';
$string['multiplier'] = 'Szorzó';
$string['name'] = 'Név';
$string['navnojswarning'] = 'Vigyázat: az ugrópontokkal nem menti el válaszait. Használja az oldal alján lévő Következő gombot.';
$string['neverallononepage'] = 'Soha, minden kérdés egy oldalon.';
$string['newattemptfail'] = 'Hiba: a tesztben nem lehetett új próbálkozást indítani';
$string['newpage'] = 'Új oldal';
$string['newpageevery'] = 'Új oldal automatikus megkezdése';
$string['newpage_help'] = '<p>Hosszabb tesztek esetén célszerű azt több oldalra széthúzni
az oldalanként jelzendő kérdések számának módosításával.
A kérdések hozzáadása során ennek megfelelően automatikusan
laptörések kerülnek az állományba. Ezeket később a szerkesztő
oldalon kézzel módosíthatja.
</p>';
$string['noanswers'] = 'Nincs kiválasztva válasz!';
$string['noattempts'] = 'A teszt megoldásával még nem próbálkoztak';
$string['noattemptstoshow'] = 'Nincs megmutatható próbálkozás';
$string['nocategory'] = 'Hibás, vagy nincs megadva kategória';
$string['noclose'] = 'Nincs lezárási időpont';
$string['nocommentsyet'] = 'Még nincs megjegyzés.';
$string['noconnection'] = 'Jelenleg nincs olyan webszolgáltatási kapcsolat, amely ezt a kérdést fel tudná dolgozni. Lépjen kapcsolatba a rendszergazdával.';
$string['nodataset'] = 'semmi - ez nem helyettesítő karakter';
$string['nodatasubmitted'] = 'Nem adott le adatokat.';
$string['noessayquestionsfound'] = 'Nincs kézzel pontozott kérdés';
$string['nogradewarning'] = 'A teszt nincs pontozva, ezért nem állíthat be pontonként eltérő visszajelzést.';
$string['nomatchinganswer'] = 'Adjon meg egy választ a \'{$a}\' kérdéshez.';
$string['nominal'] = 'Névleges';
$string['nomoreattempts'] = 'Több próbálkozás nem lehetséges';
$string['none'] = 'Egy sem';
$string['noopen'] = 'Nincs megnyitási időpont';
$string['nooverridedata'] = 'A teszt beállításai közül legalább egyet felül kell írnia.';
$string['nopossibledatasets'] = 'Nincsenek lehetséges adatkészletek';
$string['noquestionintext'] = 'A kérdés szövegében nincs beépített kérdés';
$string['noquestions'] = 'Nincs még hozzáadva kérdés';
$string['noquestionsfound'] = 'Nincs kérdés';
$string['noquestionsinfile'] = 'Az importálási állományban nincsenek kérdések';
$string['noquestionsinquiz'] = 'A teszt nem tartalmaz kérdéseket.';
$string['noquestionsnotinuse'] = 'Ez a véletlenszerű kérdés nem használatos, mert üres a kategóriája.';
$string['noquestionsonpage'] = 'Üres oldal';
$string['noresponse'] = 'Nincs válasz';
$string['noreview'] = 'Ezt a tesztet nem ellenőrizheti';
$string['noreviewattempt'] = 'Ezt a próbálkozást nem ellenőrizheti.';
$string['noreviewshort'] = 'Nincs engedélyezve';
$string['noreviewuntil'] = 'Ezt a tesztet {$a}-ig nem ellenőrizheti';
$string['noreviewuntilshort'] = 'Elérhető {$a}';
$string['noscript'] = 'A folytatáshoz be kell kapcsolni a javascriptet.';
$string['notavailable'] = 'Ez a teszt most nem elérhető';
$string['notavailabletostudents'] = 'Megjegyzés: ezt a tesztet tanulói jelenleg nem oldhatják meg';
$string['notenoughanswers'] = 'Ehhez a kérdéshez legalább {$a} válaszra van szükség';
$string['notenoughsubquestions'] = 'Kevés alkérdést adott meg!<br />Visszatér és kijavítja ezt a kérdést?';
$string['notimedependentitems'] = 'A tesztmodul nem támogatja az időfüggő tételeket. Adjon meg egy időkorlátot az egész tesztre. Másik tételt kíván választani (vagy mégis a jelenlegit használja)?';
$string['notyourattempt'] = 'Ez nem az Ön próbálkozása!';
$string['noview'] = 'Belépett felhasználó nem tekintheti meg ezt a tesztet';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} összesen {$a->attemptnum} próbálkozást tett';
$string['numattemptsmade'] = '{$a} próbálkozást hajtottak végre ezen a teszten';
$string['numberabbr'] = 'sz.';
$string['numerical'] = 'Számjegyes';
$string['numquestionsx'] = 'Kérdés: {$a}';
$string['onlyteachersexport'] = 'Csak tanárok exportálhatnak kérdéseket';
$string['onlyteachersimport'] = 'Csak szerkesztési joggal rendelkező tanárok importálhatnak kérdéseket';
$string['open'] = 'Nincs megoldva';
$string['openclosedatesupdated'] = 'A teszt megnyitási és lezárási időpontjait frissítettük';
$string['optional'] = 'opcionális';
$string['orderandpaging'] = 'Sorrend és oldalszám';
$string['orderandpaging_help'] = 'Az egyes kérdésekkel szemközti 10, 20, 30, ... szám a kérdések sorrendjére utal. A számok későbbi kérdésekhez további hely biztosítása érdekében 10-esével növekednek. Újrarendezésükhöz módosítsa a számokat, majd kattintson a "Kérdések újrarendezése" gombra.

Ha a kérdésekhez oldaltörést kíván beszúrni, jelölje be a kérdések melletti négyzeteket, majd kattintson az "Új oldalak beszúrása a kiválasztott kérdések után" gombra.

Ha a kérdések több oldalra férnek ki, kattintson az "Újratördelés" gombra és válassza ki az oldalankénti kérdések számát..
';
$string['orderingquiz'] = 'Sorrend és oldalszám';
$string['outof'] = '{$a->grade} a maximum {$a->maxgrade} közül';
$string['outofpercent'] = '{$a->grade} a maximum {$a->maxgrade} közül ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Globális visszajelzés';
$string['overallfeedback_help'] = 'A globális visszajelzés olyan szöveg, amelyet a tanuló egy teszt megoldását követően lát. (Százalékban vagy számmal megadott) ponthatárok  esetén a szöveg a tanuló által szerzett pontoktól függően változhat.';
$string['overdue'] = 'Lejárt';
$string['override'] = 'Felülírás';
$string['overridedeletegroupsure'] = 'Biztosan törli {$a} csoport felülírását?';
$string['overridedeleteusersure'] = 'Biztosan törli {$a} felhasználó felülírását?';
$string['overridegroup'] = 'Csoport felülírása';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Felülírások';
$string['overrideuser'] = 'Felhasználó felülírása';
$string['overrideusereventname'] = '$a->quiz} - Felülírás';
$string['pagesize'] = 'Oldalanként megjelenített próbálkozás:';
$string['paragraphquestion'] = '{$a} soron a bekezdéses kérdés nincs támogatva. A kérdés kimarad.';
$string['parent'] = 'Szülő- (felettes) kategória';
$string['parentcategory'] = 'Fölső kategória';
$string['parsingquestions'] = 'Importált állomány kérdéseinek feldolgozása.';
$string['partiallycorrect'] = 'Részben helyes';
$string['passworderror'] = 'A megadott jelszó hibás';
$string['penalty'] = 'Büntetés';
$string['penaltyscheme'] = 'Büntetőpontok alkalmazása';
$string['penaltyscheme_help'] = '<p>Ha egy teszt adaptív módban működik, akkor a tanuló a rossz válasz után újból
próbálkozhat. Ez esetben a kérdésre adott végleges osztályzatból a rossz válaszokra büntetőpont vonható le. Ennek mennyisége az egyes kérdésekre külön-külön adható meg a kérdés beállítása vagy szerkesztése során.</p>

<p>Ez a beállítás csak adaptív módban bír jelentőséggel.</p>';
$string['percentcorrect'] = 'százalék helyes';
$string['pleaseclose'] = 'Kérését feldolgoztuk. Bezárhatja ezt az ablakot.';
$string['pluginadministration'] = 'Teszt kezelése';
$string['pluginname'] = 'Teszt';
$string['popup'] = 'Teszt megjelenítése &quot;biztonságos&quot; ablakban';
$string['popupblockerwarning'] = 'A dolgozat ezen része biztonságos üzemmódban van, vagyis a tesztet biztonságos ablakban kell megoldania. Kapcsolja ki az előbukkanó ablakok tiltását. Köszönjük.';
$string['popupnotice'] = 'A tanulók a tesztet egy biztonságos ablakban látják';
$string['popupwithjavascriptsupport'] = 'Teljes képernyős felugró ablak némi Javascript-biztonsággal';
$string['preprocesserror'] = 'Hiba történt az előfeldolgozás során!';
$string['preview'] = 'Előzetes megtekintés';
$string['previewquestion'] = 'Kérdés előzetes megtekintése';
$string['previewquiz'] = '{$a} előzetes megtekintése';
$string['previewquiznow'] = 'Teszt előzetes megtekintése most';
$string['previous'] = 'Előző állapot';
$string['publish'] = 'Közzététel';
$string['publishedit'] = 'Engedéllyel kell rendelkeznie a közreadó kurzusban ahhoz, hogy a kategóriában kérdéseket adhasson hozzá és szerkeszthessen';
$string['qname'] = 'név';
$string['qti'] = 'IMS QTI forma';
$string['qti_two'] = 'IMS QTI 2.0 forma';
$string['qtypename'] = 'típus, név';
$string['question'] = 'Kérdés';
$string['questionbankcontents'] = 'Kérdésbank tartalma';
$string['questionbankmanagement'] = 'Kérdésbank kezelése';
$string['questionbehaviour'] = 'Kérdés viselkedése';
$string['questioncats'] = 'Kérdéskategóriák';
$string['questiondeleted'] = 'A kérdést törölték. Forduljon tanárához';
$string['questioninuse'] = 'A(z) \'{$a->questionname}\' jelenleg a {$a->quiznames} között szerepel. A kérdés csak a kategóriák jegyzékéből törlődik, a tesztekből nem.';
$string['questionmissing'] = 'A szakaszból hiányzik egy kérdés';
$string['questionname'] = 'Kérdés neve';
$string['questionnametoolong'] = 'A kérdés neve túl hosszú a(z) {$a} soron (max. 255 kar.) Innentől levágva.';
$string['questionno'] = '{$a} kérdés';
$string['questionnotloaded'] = 'A(z) {$a} kérdés nem töltődött be az adatbázisból';
$string['questionorder'] = 'Kérdések sorrendje';
$string['questions'] = 'Kérdések';
$string['questionsinclhidden'] = 'Kérdések (a rejtettek is)';
$string['questionsinthisquiz'] = 'Kérdések ebben a tesztben';
$string['questionsinuse'] = '(* A csillaggal jelölt kérdéseket egyes tesztek már használják. A kérdések csak a kategóriák jegyzékéből törlődnek, a tesztekből nem.';
$string['questionsperpage'] = 'Oldalankénti max. kérdésszám';
$string['questionsperpageselected'] = 'Az oldalankénti kérdésszám be van állítva, így az oldalakra törés jelenleg rögzített. Ezért az oldaltörés kezelőszervei ki vannak kapcsolva. Módosíthatja itt: {$a}.';
$string['questionsperpagex'] = 'Oldalankénti kérdésszám: {$a}';
$string['questiontext'] = 'Kérdés szövege';
$string['questiontextisempty'] = '[Üres kérdésszöveg]';
$string['questiontype'] = '{$a} típusú kérdés';
$string['questiontypesetupoptions'] = 'Kérdéstípusok beállítási lehetőségei:';
$string['quiz:attempt'] = 'Próbálkozás tesztekkel';
$string['quizavailable'] = 'A teszt megoldható eddig: {$a}';
$string['quizclose'] = 'Teszt lezárása';
$string['quizclosed'] = 'Teszt lezárva ekkor: {$a}';
$string['quizcloses'] = 'Teszt véget ér';
$string['quizcloseson'] = 'Teszt véget ér ekkor: {$a}';
$string['quiz:deleteattempts'] = 'Próbálkozások törlése';
$string['quiz:emailconfirmsubmission'] = 'Leadáskor megerősítés e-mailben';
$string['quiz:emailnotifysubmission'] = 'Leadásokról értesítés e-mailben';
$string['quiz:grade'] = 'Tesztek kézi pontozása';
$string['quiz:ignoretimelimits'] = 'Tesztek időkorlátjának mellőzése';
$string['quizisclosed'] = 'A teszt le van zárva.';
$string['quizisopen'] = 'A teszt nyitva van.';
$string['quizisopenwillclose'] = 'A teszt nyitva van ({$a} bezáródik)';
$string['quiz:manage'] = 'Tesztek kezelése';
$string['quiz:manageoverrides'] = 'Tesztfelülírások kezelése';
$string['quiznavigation'] = 'Tesztnavigáció';
$string['quiznotavailable'] = 'Teszt ekkortól lesz elérhető: {$a}';
$string['quizopen'] = 'Teszt megnyitása';
$string['quizopened'] = 'A teszt elérhető.';
$string['quizopenedon'] = 'A teszt {$a} időponttól elérhető';
$string['quizopens'] = 'Teszt elérhető';
$string['quizopenwillclose'] = 'A teszt elérhető, lezárásának időpontja: {$a}';
$string['quizordernotrandom'] = 'A teszt sorrendje nincs összekeverve';
$string['quizorderrandom'] = '* A teszt sorrendje össze van keverve';
$string['quiz:preview'] = 'Tesztek előzetes megtekintése';
$string['quiz:regrade'] = 'Próbálkozások újrapontozása';
$string['quiz:reviewmyattempts'] = 'Saját próbálkozások ellenőrzése';
$string['quizsettings'] = 'Teszt beállításai';
$string['quiztimelimit'] = 'Időkorlát: {$a}';
$string['quiz:view'] = 'Tesztadatok megtekintése';
$string['quiz:viewreports'] = 'Tesztjelentések megtekintése';
$string['quizwillopen'] = 'A teszt elérhető lesz ekkor: {$a}.';
$string['random'] = 'Véletlenszerű kérdés';
$string['randomcreate'] = 'Véletlenszerű kérdések létrehozása';
$string['randomfromcategory'] = 'Véletlen kérdés ebből a kategóriából:';
$string['randomfromexistingcategory'] = 'Meglévő kategóriából származó véletlenszerű kérdés';
$string['randomnosubcat'] = 'Kérdések ebből a kategóriából, de nem ennek alkategóriáiból.';
$string['randomquestionusinganewcategory'] = 'Új kategóriából származó véletlenszerű kérdés';
$string['randomsamatch'] = 'Véletlenszerű kiegészítendő párosító';
$string['randomsamatchcreate'] = 'Véletlenszerű kiegészítendő párosító kérdések létrehozása';
$string['randomsamatchintro'] = 'Az alábbi kérdésekhez válassza ki a megfelelő választ a menüből';
$string['randomsamatchnumber'] = 'Választandó kérdések száma';
$string['randomwithsubcat'] = 'Kérdések ebből a kategóriából és ennek alkategóriáiból.';
$string['readytosend'] = 'Teljes tesztjét pontozásra készül beküldeni. Biztosan folytatni kívánja?';
$string['reattemptquiz'] = 'Újbóli próbálkozás a teszt megoldásával';
$string['recentlyaddedquestion'] = 'Nemrégen hozzáadott kérdés!';
$string['recurse'] = 'Alkategóriák kérdései is benne legyenek';
$string['regrade'] = 'Minden próbálkozás újrapontozása';
$string['regradecomplete'] = 'Minden próbálkozás újrapontozása kész';
$string['regradecount'] = '{$a->attempt} pontból {$a->changed} módosult';
$string['regradedisplayexplanation'] = 'Az újrapontozás során módosuló próbálkozások a kérdésellenőrzés ablakához vezető ugrópontokként jelennek meg';
$string['regradenotallowed'] = 'Ezt a tesztet nem pontozhatja újra';
$string['regradingquestion'] = 'A(z) "{$a}" újrapontozása.';
$string['regradingquiz'] = 'A(z) "{$a}" teszt újrapontozása';
$string['relative'] = 'Relatív';
$string['remove'] = 'Törlés';
$string['removeallquizattempts'] = 'Minden próbálkozás törlése';
$string['removeemptypage'] = 'Üres oldal eltávolítása';
$string['removeselected'] = 'A kiválasztott törlése';
$string['rename'] = 'Átnevezés';
$string['renderingserverconnectfailed'] = 'A(z) {$a} szerver nem dolgozott fel egy RQP-kérést. Ellenőrizze az URL helyességét.';
$string['reorderquestions'] = 'Kérdések átrendezése';
$string['reordertool'] = 'Átrendezési eszköz megjelenítése';
$string['repaginate'] = 'Újraszámozás oldalanként {$a} kérdéssel';
$string['repaginatecommand'] = 'Újratördelés';
$string['repaginatenow'] = 'Újratördelés most';
$string['replace'] = 'Csere';
$string['replacementoptions'] = 'Csere lehetőségei';
$string['report'] = 'Jelentések';
$string['reportanalysis'] = 'Tételelemzés';
$string['reportfullstat'] = 'Részletes statisztika';
$string['reportmulti_percent'] = 'Többszörös százalék';
$string['reportmulti_q_x_student'] = 'Többtanulós választási lehetőségek';
$string['reportmulti_resp'] = 'Egyedi válaszok';
$string['reportnotfound'] = 'Ismeretlen jelentés ({$a})';
$string['reportoverview'] = 'Áttekintés';
$string['reportregrade'] = 'Próbálkozások újrapontozása';
$string['reportresponses'] = 'Részletes tanulói válaszok';
$string['reports'] = 'Jelentések';
$string['reportsimplestat'] = 'Egyszerű statisztika';
$string['requirepassword'] = 'Jelszó előírása';
$string['requirepassword_help'] = '<p>Ez a mező opcionális.</p>

<p>Ha itt megad egy jelszót, akkor a résztvevőknek ugyanezt a jelszót kell megadniuk ahhoz, hogy
megpróbálkozhassanak a teszttel.</p>';
$string['requirepasswordmessage'] = 'A teszt megoldásához ismernie kell a teszt jelszavát';
$string['requiresafeexambrowser'] = 'Biztonságos Vizsgáztatási Böngésző használatának előírása';
$string['requiresubnet'] = 'Hálózati cím előírása';
$string['requiresubnet_help'] = '<p>Ez a mező opcionális.</p>

<p>Helyi hálózaton vagy az Interneten egy teszt elérhetőségét konkrét alhálózatokhoz
kötheti oly módon, hogy megad egy vesszőkkel határolt, részleges vagy teljes IP-címet tartalmazó
listát.</p>

<p>Ez különösen ellenőrzött teszt esetén hasznos, ahol biztos akar lenni abban, hogy csakis egy
meghatározott teremben lévők számára legyen hozzáférhető a teszt.</p>

<p>Például: <strong>192.168. , 231.54.211.0/20, 231.3.56.211</strong></p>

<p>Háromféle számot használhat (nincs mód szöveges doménnevek használatára):
<ol>
<li>Teljes IP-címek, például <strong>192.168.10.1</strong>, amelyek egy konkrét számítógépet
(vagy proxy-t) azonosítanak.</li>
<li>Részleges címek, például <strong>192.168</strong>, amely bármely adott számokkal
kezdődő helyet azonosít.</li>
<li>CIDR-jelölés, például <strong>231.54.211.0/20</strong>, mellyel részletesebb alhálózatokat
jelölhet.</li>
</ol>
</p>

<p>A szóközöket a rendszer figyelmen kívül hagyja.</p>';
$string['response'] = 'Tanuló válasza';
$string['responses'] = 'Tanuló válaszai';
$string['results'] = 'Eredmények';
$string['reuseifpossible'] = 'korábban eltávolított újbóli használata';
$string['reverttodefaults'] = 'Visszatérés a teszt alapbeállításaihoz';
$string['review'] = 'Értékelés';
$string['reviewafter'] = 'Teszt lezárása után értékelés engedélyezése';
$string['reviewalways'] = 'Bármikori értékelés  engedélyezése';
$string['reviewattempt'] = 'Próbálkozás értékelése';
$string['reviewbefore'] = 'Értékelés engedélyezése, amíg a teszt elérhető';
$string['reviewclosed'] = 'A teszt lezárása után';
$string['reviewimmediately'] = 'Közvetlenül a próbálkozás után';
$string['reviewnever'] = 'Értékelés sosem lehetséges';
$string['reviewofattempt'] = 'A(z) {$a} próbálkozás értékelése';
$string['reviewofpreview'] = 'Előkép értékelése';
$string['reviewopen'] = 'Később, amíg a teszt elérhető';
$string['reviewoptions'] = 'Tanulók értékelhetik';
$string['reviewoptionsheading'] = 'Értékeléi lehetőségek';
$string['reviewoptionsheading_help'] = '<p>Ezek a lehetőségek szabályozzák, milyen adatokat láthatnak a felhasználók egy teszttel való próbálkozás értékelése vagy tesztjelentések megtekintése során.</p>

<p>A <b>Közvetlenül a próbálkozás után </b> azt jelenti, hogy két percen belül attól számítva, hogy a felhasználó <b>Az összes próbálkozás leadása és befejezés</b> gombra kattint.
</p>

<p>A <b>Később, amíg a teszt elérhető</b> azt jelenti, hogy ezt követően, de még a teszt lezárási időpontja előtt.</p>

<p><b>A teszt lezárása után</b> pedig azt jelenti, hogy azt követően, hogy a teszt lezárási időpontja letelt. Ha a teszthez nincs lezárási időpont, akkor ez az állapot sosem következik be.</p>

<p>A "Rejtett pontok megtekintése" [moodle/grade:viewhidden] engedéllyel rendelkező felhasználók (általában tanárok és rendszergazdák) lehetőségeit ezek a beállítások nem érintik,
így mindenkor megtekinthetnek minden, egy tanuló próbálkozására vonatkozó adatot.</p>';
$string['reviewresponse'] = 'Tanuló válaszának értékelése';
$string['reviewresponsetoq'] = 'Tanuló válaszának értékelése ({$a} kérdés)';
$string['reviewthisattempt'] = 'Ellenőrizze az ezen próbálkozásra adott válaszait.';
$string['rqp'] = 'Távoli kérdés';
$string['rqps'] = 'Távoli kérdések';
$string['safebrowsererror'] = 'A teszt készen áll, de csak a Biztonságos Vizsgáztatási Böngészővel oldható meg. Ebből a böngészőből a teszt nem érhető el.';
$string['safebrowsernotice'] = 'A teszt készen áll, de a tanulók csak a Biztonságos Vizsgáztatási Böngészővel oldhatják meg.';
$string['sameasoverall'] = 'A globális pontokkal egyező';
$string['save'] = 'Mentés';
$string['saveandedit'] = 'Változások mentése és kérdések szerkesztése';
$string['saveattemptfailed'] = 'A jelen teszten végrehajtott próbálkozás mentése nem sikerült.';
$string['savedfromdeletedcourse'] = 'A törölt "{$a}" kurzusból elmentve';
$string['savegrades'] = 'Pontok mentése';
$string['savemyanswers'] = 'Válaszaim mentése';
$string['savenosubmit'] = 'Mentés leadás nélkül';
$string['saveoverrideandstay'] = 'Mentés és egy másik felülírás megadása';
$string['savequiz'] = 'Az egész teszt mentése';
$string['score'] = 'Nyers pontszám';
$string['scores'] = 'Pontszámok';
$string['select'] = 'Kiválasztás';
$string['selectall'] = 'Az összes kiválasztása';
$string['selectcategory'] = 'Kategória kiválasztása';
$string['selectcategoryabove'] = 'Fentről kategória kiválasztása';
$string['selectedattempts'] = 'Kiválasztott próbálkozások...';
$string['selectnone'] = 'Összes kiválasztásának megszüntetése';
$string['selectquestiontype'] = '-- Kérdéstípus kiválasztása --';
$string['serveradded'] = 'Szerver hozzáadva';
$string['serveridentifier'] = 'Azonosító';
$string['serverinfo'] = 'Szerverinformáció';
$string['serverinuse'] = 'A törölni kívánt szerver az utolsó {$a} szerver, és már vannak olyan kérdések, amelyek a szerver törlése esetén nem fognak működni.';
$string['servers'] = 'Szerverek';
$string['serverurl'] = 'Szerver URL-je';
$string['settingsoverrides'] = 'Beállítások felülírásai';
$string['shortanswer'] = 'Kiegészítendő';
$string['show'] = 'Mutat';
$string['showall'] = 'Minden kérdés egy oldalon látsszon';
$string['showblocks'] = 'Blokkok megjelenítése a teszten végrehajtott próbálkozások során';
$string['showblocks_help'] = 'Igenre állítás esetén a szokásos blokkok megjelennek a teszten végrehajtott próbálkozások során';
$string['showbreaks'] = 'Oldaltörések látsszanak';
$string['showcategorycontents'] = 'A(z)  {$a->arrow} kategória tartalmának kijelzése';
$string['showcorrectanswer'] = 'Visszajelzésben megjelenjenek a helyes válaszok?';
$string['showdetailedmarks'] = 'Jegy részleteinek megjelenítése';
$string['showeachpage'] = 'Egyszerre egy oldal megjelenítése';
$string['showfeedback'] = 'Válasz után a visszajelzés megjelenjen?';
$string['showhidden'] = 'Régi kérdések is látsszanak';
$string['showinsecurepopup'] = 'A próbálkozásokhoz külön "biztonságos" ablak használata';
$string['shownoattempts'] = 'Próbálkozás nélküli tanulók megjelenítése';
$string['shownoattemptsonly'] = 'Csak a próbálkozás nélküli tanulók megjelenítése';
$string['showquestiontext'] = 'A kérdés szövege látsszon a kérdések listáján';
$string['showteacherattempts'] = 'Tanári próbálkozások megjelenítése';
$string['showuserpicture'] = 'Felhasználó képének megjelenítése';
$string['showuserpicture_help'] = '<p>Bekapcsolása esetén próbálkozás közben és az értékelő képernyőn látható lesz a tanuló neve és képe.</p>

<p>Erre szükség lehet például felügyelet mellett zajló vizsga esetén, mert így könnyebben ellenőrizhető, hogy valóban a felhasználó lépett-e be.</p>';
$string['shuffle'] = 'Összekeverés';
$string['shuffleanswers'] = 'Válaszok összekeverése';
$string['shuffledrandomly'] = 'Véletlenszerű összekeverés';
$string['shufflequestions'] = 'Kérdések összekeverése';
$string['shufflequestionsselected'] = 'A kérdések összekeverése be van állítva, így az oldalakhoz kapcsolódó egyes tevékenységeket nem hajthatja végre. Az összekeverést módosíthatja: {$a}.';
$string['shufflewithin'] = 'Kérdéseken belüli összekeverés';
$string['shufflewithin_help'] = '<p>Az opció bekapcsolása esetén az egyes kérdések részei véletlenszerűen összekeverednek, ha egy tanuló a teszttel próbálkozik, feltéve, hogy az opció a kérdések beállításában is be van kapcsolva.</p>

<p>Ennek az a célja, hogy kissé megnehezítse azt, hogy a tanulók egymástól átmásoljanak megoldásokat.</p>

<p>Az opció csak a több részből felépülő kérdések, például a feleletválasztós és a párosító kérdések esetén használható. Feleletválasztós kérdések esetén a válaszok sorrendje csak akkor keveredik össze, ha ez az opció &quot;Igen&quot;-re van állítva. Párosító kérdéseknél a válaszok mindig összekeverednek. Ez a beállítás a kérdés-válasz párok sorrendjének a felcserélését is érinti.</p>

<p>Ugyanakkor a beállítás nem érinti a véletlenszerű kérdések használatát.</p>';
$string['significantfigures'] = '{$a} számmal';
$string['significantfiguresformat'] = 'szignifikáns számjegyek';
$string['singleanswer'] = 'Válasszon egy választ.';
$string['sortage'] = 'Rendezés kor szerint';
$string['sortalpha'] = 'Rendezés név szerint';
$string['sortquestionsbyx'] = 'Kérdések rendezése {$a} szerint';
$string['sortsubmit'] = 'Kérdések rendezése';
$string['sorttypealpha'] = 'Rendezés típus, név szerint';
$string['specificapathnotonquestion'] = 'A megadott útvonal nincs a megadott kérdésben';
$string['specificquestionnotonquiz'] = 'A megadott kérdés nincs a megadott tesztben';
$string['startagain'] = 'Újrakezdés';
$string['startedon'] = 'Kezdés ideje';
$string['statenotloaded'] = 'A(z) {$a} kérdés állapota nem töltődött be az adatbázisból';
$string['status'] = 'Állapot';
$string['stoponerror'] = 'Hiba esetén leállás';
$string['submitallandfinish'] = 'Az összes leadása és befejezés';
$string['subneterror'] = 'Sajnos a teszt zárolva van és csak egyes helyekről érhető el. Jelenleg számítógépéről nem használhatja a tesztet.';
$string['subnetnotice'] = 'Ez a teszt le van zárva, így csak egyes helyekről érhető el. Számítógépe nem ilyen alhálózaton van. Tanárként a tesztoldalakat egyébként megtekintheti.';
$string['subnetwrong'] = 'A teszt csak egyes helyekről érhető el, a számítógépe pedig nem szerepel az engedélyezettek listáján.';
$string['substitutedby'] = 'helyett';
$string['summaryofattempt'] = 'Próbálkozások összegzése';
$string['summaryofattempts'] = 'Korábbi próbálkozásainak összegzése';
$string['temporaryblocked'] = 'Ideiglenesen nem próbálkozhat újra a teszttel.<br /> Újból próbálkozhat ekkor:';
$string['time'] = 'Idő';
$string['timecompleted'] = 'Kész';
$string['timedelay'] = 'Nem oldhatja meg a tesztet, mert még nem telt el a következő próbálkozásig előírt időköz';
$string['timeleft'] = 'Hátralévő idő';
$string['timelimit'] = 'Időkorlát';
$string['timelimitexeeded'] = 'Sajnos a tesztidőt túllépte!';
$string['timelimit_help'] = '<p>Alaphelyzetben a teszteknek nincs időbeli korlátjuk, így a tanulók annyi időt fordítanak a teszt
kitöltésére, amennyire csak szükségük van.</p>

<p>Ha viszont megad egy időkorlátot, egy sor dolog történik annak érdekében, hogy a teszteket ezen
idő alatt kitöltsék:</p>

<ul>
  <li>A böngészőben a Javascript támogatása kötelezővé válik - ennek köszönhetően
  az időmérő helyesen fog működni.</li>
  <li>Egy folyamatjelző, visszaszámláló időmérő ablak jelenik meg a képernyőn.</li>
  <li>Ha az időmérő lejár, a teszt leadása automatikusan megtörténik, függetlenül
  attól, hogy mennyi válasz született meg akkorra.</li>
  <li>Ha a tanuló csal és a kijelölt időnél 60 másodperccel többet tölt el, akkor a tesztre
  automatikusan nulla pontot kap.</li>
</ul>';
$string['timelimitmin'] = 'Időkorlát (perc)';
$string['timelimitsec'] = 'Időkorlát (másodperc)';
$string['timestr'] = '%Ó:%P:%MPS %y/%m/%d időpontban';
$string['timesup'] = 'Ideje elfogyott';
$string['timetaken'] = 'Felhasznált idő';
$string['tofile'] = 'állományba';
$string['tolerance'] = 'Tűrés';
$string['tolerancetype'] = 'Tűrés típusa';
$string['toomanyrandom'] = 'A szükséges véletlenszerű kérdések száma nagyobb, mint amennyit ez a kategória még tartalmaz! ({$a})';
$string['top'] = 'Fent';
$string['totalpointsx'] = 'Összes pontszám: {$a}.';
$string['totalquestionsinrandomqcategory'] = 'A kategória összes {$a} kérdése.';
$string['true'] = 'Igaz';
$string['truefalse'] = 'Igaz-hamis';
$string['truefalseimporterror'] = 'Figyelem: a(z) \'{$a->questiontext}\' igaz-hamis kérdést nem lehetett megfelelően importálni. Nem egyértelmű, hogy a jó válasz az igaz, vagy a hamis. A kérdés importálása során a válasz \'{$a->answer}\' válasznak minősült. Ha ez téves, újra kell szerkesztenie a kérdést.';
$string['type'] = 'Típus';
$string['unfinished'] = 'nyitva';
$string['ungraded'] = 'Pontozatlan';
$string['uniform'] = 'egyenletes eloszlásból a tizedesjegyek';
$string['unit'] = 'Egység';
$string['unknowntype'] = 'A kérdéstípust {$a} sornál a rendszer nem támogatja. A kérdést figyelmen kívül hagyja';
$string['unsupportedformulafunction'] = 'A(z) {$a} funkciót a rendszer nem támogatja.';
$string['unusedcategorydeleted'] = 'Ez a kategória törölve lett, mert a kurzus törlése után a kérdéseket már nem használta.';
$string['updatesettings'] = 'Tesztbeállítások frissítése';
$string['upgradesure'] = '<div style="color: red;">A tesztmodul számottevően átalakítja a teszttáblázatokat, ez a frissítés pedig még nincs kellőképpen leellenőrizve. Továbblépés előtt mindenképpen készítsen biztonsági mentést adatbázisa táblázatairól.</div>';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Ez a kategória portálszintre lett áthelyezve, mert közzétett kategória, melyet egyéb kurzusok továbbra is használnak.';
$string['useroverrides'] = 'Felhasználó felülírásai';
$string['usersnone'] = 'A tesztet egy tanuló sem éri el';
$string['validate'] = 'Érvényesít';
$string['viewallanswers'] = '{$a} tesztpróbálkozás megtekintése';
$string['viewallreports'] = '{$a} próbálkozás jelentéseinek megtekintése';
$string['warningmissingtype'] = 'Ez olyan kérdésfajta, amely a Moodle-rendszerében még nincs telepítve. Figyelmeztesse a Moodle rendszergazdáját.';
$string['warningsdetected'] = '{$a} figyelmeztetés észlelve';
$string['webct'] = 'WebCT-forma';
$string['wheregrade'] = 'Hol van a pontom?';
$string['wildcard'] = 'Helyettesítő';
$string['windowclosing'] = 'Az ablak rövidesen bezáródik.';
$string['withselected'] = 'kiválasztottal';
$string['withsummary'] = 'összegző statisztikával';
$string['wronggrade'] = 'Hibás pont ({$a} sor után)';
$string['wronguse'] = 'Így ezt az oldalt nem használhatja';
$string['xhtml'] = 'XHTML-forma';
$string['xml'] = 'Moodle XML-forma';
$string['xmlimportnoname'] = 'Hiányzik a kérdés neve az XML-állományból';
$string['xmlimportnoquestion'] = 'Hiányzik a kérdés szövege az XML-állományból';
$string['xmltypeunsupported'] = 'A(z) {$a} kérdéstípust az XML-importálás nem támogatja.';
$string['youcannotwait'] = 'A teszt azelőtt lezáródik, hogy új próbálkozást indíthatna el.';
$string['youmustwait'] = 'A teszttel való újbóli próbálkozás előtt várnia kell. {$a} után újból próbálkozhat.';
$string['youneedtoenrol'] = 'A teszt megoldásához be kell iratkoznia a kurzusba.';
$string['yourfinalgradeis'] = 'Végső pontja erre a tesztre {$a}';
$string['zerosignificantfiguresnotallowed'] = 'A helyes válasznak nem lehet nulla szignifikáns számjegye!';
