<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'hu', branch 'MOODLE_20_STABLE'
 *
 * @package   question
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminreport'] = 'Jelentés a kérdéseinek adatbázisával kapcsolatos esetleges problémákról.';
$string['availableq'] = 'Elérhető?';
$string['badbase'] = 'Hibás alap a **: {$a}** előtt';
$string['broken'] = 'Az ugrópont "hibás", mert nem létező állományra mutat.';
$string['byandon'] = 'leadta {$a->user} ekkor: {$a->time}';
$string['cannotcopybackup'] = 'A biztonsági mentés állománya nem másolható';
$string['cannotcreate'] = 'Nem hozható létre új tétel a question_attempts táblázatban';
$string['cannotcreatepath'] = 'Nem hozható létre a(z) {$a} útvonal';
$string['cannotdeletecate'] = 'A kategóriát nem törölheti, mert az az adott környezetben az alapkategória.';
$string['cannotenable'] = 'A(z) {$a} kérdéstípus közvetlenül nem hozható létre.';
$string['cannotfindcate'] = 'Nincs meg a kategóriarekord.';
$string['cannotfindquestionfile'] = 'Nincs meg a tömörített állományban a kérdés adatállománya';
$string['cannotgetdsfordependent'] = 'Függő kérdéshez nem érhető el a megadott adatkészlet! (kérdés: {$a->id}, adatkészletelem:  {$a->item})';
$string['cannotgetdsforquestion'] = 'Számításos kérdéshez nem érhető el a megadott adatkészlet ! (kérdés: {$a})';
$string['cannothidequestion'] = 'Nem lehetett elrejteni a kérdést.';
$string['cannotimportformat'] = 'Ebben a formában még nem lehet importálni!';
$string['cannotinsertquestion'] = 'Az új kérdést nem sikerült beszúrni';
$string['cannotinsertquestioncatecontext'] = 'Nem lehetett beszúrni az új {$a->cat} kérdéskategóriát, érvénytelen {$a->ctx} környezetazonosító';
$string['cannotloadquestion'] = 'Nem lehetett kérdést betölteni.';
$string['cannotmovequestion'] = 'Ezzel a kóddal nem helyezhet át olyan kérdéseket, amelyekhez különböző területekről származó állományok kapcsolódnak.';
$string['cannotopenforwriting'] = 'Nem nyitható meg írásra a(z) {$a}';
$string['cannotpreview'] = 'Ezeket a kérdéseket nem tekintheti meg előre!';
$string['cannotretrieveqcat'] = 'A kérdéskategória elérése nem sikerült.';
$string['cannotunhidequestion'] = 'A kérdést nem sikerült megjeleníteni.';
$string['cannotunzip'] = 'A tömörített állományt nem sikerült kicsomagolni.';
$string['cannotwriteto'] = 'Az exportált kérdéseket nem lehet a(z) {$a} állományba írni';
$string['categorycurrent'] = 'Mostani kategória';
$string['categorycurrentuse'] = 'Ezen kategória használata';
$string['categorydoesnotexist'] = 'A kategória nem létezik';
$string['categorymoveto'] = 'Mentés ezen kategória alatt';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">kategória megosztási állapota "{$a->name}"</a> a(z) "{$a->coursename}" kurzusban {$a->changefrom} helyett {$a->changeto} lesz.';
$string['chooseqtypetoadd'] = 'Válassza ki a hozzáadandó kérdéstípust.';
$string['clicktoflag'] = 'A kérdés megjelöléséhez kattintson.';
$string['clicktounflag'] = 'A kérdés bejelölésének megszüntetéséhez kattintson.';
$string['contexterror'] = 'Nem kerülhet ide, ha nem egy kategóriát helyez át egy másik környezetbe.';
$string['copy'] = '{$a} másolása és ugrópontok módosítása.';
$string['created'] = 'Létrehozva';
$string['createdby'] = 'Létrehozta';
$string['createdmodifiedheader'] = 'Létrehozva/utoljára mentve';
$string['createnewquestion'] = 'Új kérdés létrehozása...';
$string['cwrqpfs'] = 'Véletlen kérdések alkategóriák kérdéseiből választva.';
$string['cwrqpfsinfo'] = '<p>A Moodle 1.9-re frissítés során a kérdéskategóriákat különféle környezetekre fogjuk bontani. Portálján néhány kérdés és kérdéskategória megosztását módosítani kell. Erre azon ritka esetekben lesz szükség, amikor egy tesztben egy vagy több \'véletlen\' kérdés megosztott és megosztatlan kategóriákból vegyesen kerül ki (mint ezen a portálon is). Ez olyankor fordul elő, amikor egy \'véletlen\' kérdés úgy van beállítva, hogy különböző megosztású alkategóriákból kerül a felettes kategóriába, ahol a véletlen kérdés létrejön. A felettes kategóriába választott \'véletlen\' kérdések közül az alábbiak kategóriájának a megosztása fog módosulni a felettes kategória megosztásának megfelelően a Moodle 1.9-re való frissítés során. Az érintett kérdések tovább működnek az adott tesztekben, amíg el nem távolítja őket.</p>';
$string['cwrqpfsnoprob'] = 'Portálján egy kérdéskategóriát sem érint a \'Véletlen kérdések alkategóriák kérdéseiből való választása\' probléma.';
$string['defaultfor'] = '{$a} alapbeállítása';
$string['defaultinfofor'] = '\'{$a}\' környezet megosztott kérdéseinek alapkategóriája';
$string['deletecoursecategorywithquestions'] = 'A kérdésbank ezen kurzuskategóriához kapcsolódó kérdéseket tartalmaz. Ha folytatja, akkor törli őket. Először helyezze át őket a kérdésbank felületének segítségével.';
$string['disabled'] = 'Kikapcsolva';
$string['disterror'] = 'A(z) {$a} szétosztás hibákat okozott';
$string['donothing'] = 'Ne másoljon vagy helyezzen át állományokat, és ne módosítson ugrópontokat.';
$string['editcategories'] = 'Kategóriák szerkesztése';
$string['editcategories_help'] = 'Egyetlen hosszú felsorolás helyett kérdéseit tárolhatja kategóriákba és alkategóriákba rendezve.

Az egyes kategóriákhoz környezet tartozik, amely meghatározza, hol használhatók a benne szereplő kérdések.

* Tevékenység környezete - A kérdések csak a tevékenységmodulban érhetők el.

* Kurzus környezete - A kérdések a kurzus összes tevékenységmoduljában elérhetők.

* Kurzuskategória környezete - A kérdések a kurzuskategória összes kurzusában és összes tevékenységmoduljában elérhetők.


* Portál környezete - A kérdések a portálon az összes kurzusban és az összes tevékenységben elérhetők.

A kategóriák véletlenszerű kérdésekkel is használatosak, mivel a kérdések kiválasztása egy megadott kategóriából történik.';
$string['editingcategory'] = 'Kategória szerkesztése';
$string['editingquestion'] = 'Kérdés szerkesztése';
$string['editthiscategory'] = 'Kategória szerkesztése';
$string['emptyxml'] = 'Ismeretlen hiba – üres az imsmanifest.xml';
$string['enabled'] = 'Bekapcsolva';
$string['erroraccessingcontext'] = 'Hiba a környezet elérése során';
$string['errordeletingquestionsfromcategory'] = 'Hiba történt a(z) {$a} kategóriába tartozó kérdések törlése során.';
$string['errorduringpost'] = 'Hiba történt utófeldolgozás közben!';
$string['errorduringpre'] = 'Hiba történt előfeldolgozás közben!';
$string['errorduringproc'] = 'Hiba történt feldolgozás közben!';
$string['errorduringregrade'] = 'Nem pontozható újra a(z) {$a->qid}, áttérés {$a->stateid} állapotba.';
$string['errorfilecannotbecopied'] = 'Hiba: a(z) {$a} állomány nem másolható.';
$string['errorfilecannotbemoved'] = 'Hiba: a(z) {$a} állomány nem helyezhető át.';
$string['errorfileschanged'] = 'Hiba: az űrlapkérdésekhez kapcsolt állományok az űrlap megjelenítése óta módosultak.';
$string['errormanualgradeoutofrange'] = 'A(z) {$a->grade} pontszám  {$a->name} kérdés esetén nem esik 0 és {$a->maxgrade} közé. A pontszám és a megjegyzés mentésére nem került sor.';
$string['errormovingquestions'] = 'Hiba történt a(z) {$a} azonosítójú kérdések áthelyezése közben.';
$string['errorpostprocess'] = 'Utófeldolgozás közben hiba történt!';
$string['errorpreprocess'] = 'Előfeldolgozás közben hiba történt!';
$string['errorprocess'] = 'Feldolgozás közben hiba történt!';
$string['errorprocessingresponses'] = 'Hiba történt válaszainak feldolgozása közben';
$string['errorsavingcomment'] = 'Hiba történt az adatbázis {$a->name} kérdéséhez tartozó megjegyzés mentése közben.';
$string['errorupdatingattempt'] = 'Hiba történt az adatbázis {$a->id} azonosítójú próbálkozásának frissítése közben';
$string['exportcategory'] = 'Kategória exportálása';
$string['exportcategory_help'] = '<p align="center"><b>Exportálási kategória</b></p>

<p>A <b>Kategória:</b> a lenyíló menüből választhatja ki, mely kategóriából jöjjenek az exportált kérdések.</p>

<p>Egyes importálási formátumok (GIFT és XML) esetén a kategória bekerülhet az írott állományba, így a kategóriák (választhatóan) importáláskor újból előállíthatók. Ezen adatok hozzáadásához jelölje be a <b>Kategória kiírása állományba </b> négyzetet. Ennek kiválasztása esetén beépítheti a kategória környezetét is, ha bejelöli a <b>Környezet kiírása állományba</b> négyzetet. A Moodle régebbi változataival való kompatibilitáshoz szüntesse meg a környezet kiválasztását.</p>';
$string['exporterror'] = 'Hiba történt exportálás közben!';
$string['exportfilename'] = 'teszt';
$string['exportnameformat'] = '%É%h%n-%Ó%P';
$string['exportquestions'] = 'Kérdések exportálása állományba';
$string['exportquestions_help'] = '<p>Ezzel a funkcióval kérdések egész kategóriáját exportálhatjuk egy szöveges állományba.

<p>Ne feledje, hogy egy sor fájlformátum esetén bizonyos információk elvesznek, ha exportálja a kérdéseket. Ennek az az oka, hogy számos formátum nem rendelkezik az összes olyan jellemzővel, amellyel a Moodle kérdései fel vannak ruházva. Nem várhatjuk el, hogy a kérdések exportálása és importálása után azok majd azonosak is lesznek. Ráadásul előfordulhat, hogy egyes kérdéstípusokat egyáltalán nem lehet exportálni. Ajánlatos az exportált adatokat ellenőrizni, mielőtt konkrét előállítási környezetben használná őket.</p>

<p>Egy sor állományformátumot támogat a rendszer. Az egyes súgóállományokban és a <a href="http://docs.moodle.org/en/question/import">Moodle Docs</a>-ban megtalálja a részleteket.</p>


<p>Az importálási és exportálási formák külön használható programforrások. Más opcionális formátumokat találhat a modulok és segédprogramok adatbázisában.</p>';
$string['filecantmovefrom'] = 'A kérdésállományokat nem helyezheti át, mert nincs meg a jogosultsága az állományok eltávolításához ';
$string['filecantmoveto'] = 'A kérdésállományokat nem helyezheti át és nem másolhatja, mert nincs meg az állományok hozzáadásához a jogosultsága';
$string['filesareacourse'] = 'a kurzusállományok területe';
$string['filesareasite'] = 'a portálállományok területe';
$string['filestomove'] = 'Állományok áthelyezése/másolása ide: {$a}?';
$string['flagged'] = 'Megjelölve';
$string['flagthisquestion'] = 'Megjelöli a kérdést';
$string['formquestionnotinids'] = 'Az űrlapon kérdésazonosítóval nem rendelkező kérdés szerepelt';
$string['fractionsnomax'] = 'Valamelyik válasz pontszámának 100%-nak kell lenni a kérdés teljes pontozhatósága érdekében.';
$string['getcategoryfromfile'] = 'Kategória átvétele állományból';
$string['getcontextfromfile'] = 'Környezet átvétele állományból';
$string['ignorebroken'] = 'Hibás ugrópontok kihagyása';
$string['importcategory'] = 'Kategória importálása';
$string['importcategory_help'] = '<p>A <b>Kategória:</b> lenyíló ablakból választható ki, mely kategóriába kerüljenek az importált kérdések.</p>

<p>Egyes importálási formátumok (GIFT és XML) esetén a kategória megadható az importálandó állományon belül.
Ehhez be kell jelölnie a <b>Kategória átvétele állományból</b> négyzetet. Ha nem, a kérdések az állományban lévő esetleges utasításoktól függetlenül a kiválasztott kategóriába kerülnek. A Moodle-ból exportált formátumokban szerepelhet a kategória szövegébe beépített kategóriakörnyezet. Az alapkörnyezet használatához szüntesse meg a <b>Környezet átvétele állományból</b> bejelölését.</p>

<p>Ha a kategóriák az importálandó állományon belül vannak megadva, de még nem léteznek, a rendszer létrehozza őket.</p>';
$string['importquestions'] = 'Kérdések importálása állományból';
$string['importquestions_help'] = 'Ezzel különféle formájú kérdéseket importálhat szöveges állományon keresztül. Ügyeljen arra, hogy a kódolásuk UTF-8 legyen!';
$string['impossiblechar'] = 'Az elfogadhatatlan {$a} karaktert a rendszer zárójelként észleli';
$string['invalidarg'] = 'Nincs megadva érvényes argumentum, vagy hibás a szerver beállítása.';
$string['invalidcategoryidforparent'] = 'Felettes kategóriához érvénytelen kategóriaazonosító!';
$string['invalidcategoryidtomove'] = 'Áthelyezéshez érvénytelen kategóriaazonosító!';
$string['invalidconfirm'] = 'A megerősítő szöveg hibás volt.';
$string['invalidcontextinhasanyquestions'] = 'Érvénytelen környezetet kapott a question_context_has_any_questions.';
$string['invalidwizardpage'] = 'Hibás, vagy nincs megadva varázslóoldal!';
$string['lastmodifiedby'] = 'Utoljára módosította';
$string['linkedfiledoesntexist'] = 'A(z) {$a} kapcsolt állomány nem létezik';
$string['makechildof'] = 'Legyen {$a} leszármazottja';
$string['maketoplevelitem'] = 'Áthelyezés felső szintre';
$string['matchgrades'] = 'Pontok egyeztetése';
$string['matchgrades_help'] = '<p>Az importált pontoknak meg <b>kell</b> felelni az érvényes pontszámok valamelyik rögzített értékének az alábbiak szerint...</p>
<ul>
  <li>100%</li>
  <li>90%</li>
  <li>80%</li>
  <li>75%</li>
  <li>70%</li>
  <li>66.666%</li>
  <li>60%</li>
  <li>50%</li>
  <li>40%</li>
  <li>33,333</li>
  <li>30%</li>
  <li>25%</li>
  <li>20%</li>
  <li>16,666%</li>
  <li>14,2857</li>
  <li>12,5%</li>
  <li>11,111%</li>
  <li>10%</li>
  <li>5%</li>
  <li>0%</li>
</ul>

<p>A fenti felsorolás negatív értékei úgyszintén megengedettek.</p>

<p>Ehhez a kapcsolóhoz kétféle beállítás létezik. Ezek határozzák meg azt, hogy az importálási rutin miként kezeli a fenti felsorolásnak <strong>pontosan</strong>
meg nem feleltethető értékeket.</p>

<ul>
  <li><strong>Hiba, ha a pontszám nincs felsorolva</strong><br />
  Ha egy kérdés a felsorolásban nem szereplő értéket tartalmaz, hibajelzés jelenik meg és a kérdés importálása elmarad.</li>
  <li><strong>Legközelebbi pontszám, ha a pontszám nincs felsorolva</strong><br />
  Ha a rendszer a felsorolásban nem szereplő pontszámra bukkan, a pontszámot a felsorolásban legközelebbi értéknek felelteti meg.
</li>
</ul>

<p><i>Megjegyzés: egyes egyedi importálási formátumok közvetlenül az adatbázisba írnak és kihagyják ezt az ellenőrzést.</i></p>';
$string['missingcourseorcmid'] = 'Kurzusazonosító vagy cmid szükséges a print_questionhez.';
$string['missingcourseorcmidtolink'] = 'A get_question_edit_link-hez courseid vagy cmid megadása szükséges.';
$string['missingimportantcode'] = 'A kérdéstípusból fontos kód hiányzik: {$a}.';
$string['missingoption'] = 'A(z) {$a} kitöltő kérdéshez nincsenek meg a választási lehetőségek';
$string['modified'] = 'Utoljára mentve';
$string['move'] = 'Áthelyezés innen: {$a}, és az ugrópontok módosítása.';
$string['movecategory'] = 'Kategória áthelyezése';
$string['movedquestionsandcategories'] = 'Kérdések és kérdéskategóriák áthelyezésére került sor {$a->oldplace} helyről {$a->newplace} helyre.';
$string['movelinksonly'] = 'Csak az ugrópontok hivatkozásának módosítása az állományok érintetlenül hagyásával.';
$string['moveq'] = 'Kérdés(ek) áthelyezése';
$string['moveqtoanothercontext'] = 'Kérdés áthelyezése másik környezetbe.';
$string['movingcategory'] = 'Kategória áthelyezése';
$string['movingcategoryandfiles'] = 'Biztosan áthelyezi a(z) {$a->name} kategóriát az alatta lévőkkel együtt "{$a->contextto}" környezetébe? A(z) {$a->fromareaname} területről való kérdésekhez {$a->urlcount} kapcsolt állományt találtunk, ezek vagy másolatuk átkerüljön a(z) {$a->toareaname} területre?';
$string['movingcategorynofiles'] = 'Biztosan áthelyezi a(z) "{$a->name}" kategóriát és az alatta lévőket a(z) "{$a->contextto}" környezetbe?';
$string['movingquestions'] = 'Kérdések és esetleges állományok áthelyezése';
$string['movingquestionsandfiles'] = 'Biztosan áthelyezi a(z) {$a->questions} kérdés(eke)t a(z) "{$a->tocontext}" környezetbe? A(z) {$a->fromareaname} területről való kérdésekhez {$a->urlcount} kapcsolt állományt találtunk, ezek vagy másolatuk átkerüljön a(z) {$a->toareaname} területre??';
$string['movingquestionsnofiles'] = 'Biztosan áthelyezi a(z) {$a->questions} kérdés(eke)t a(z) "{$a->tocontext}" környezetbe? A(z) {$a->fromareaname} területről való kérdés(ek)hez nincs hozzákapcsolt állomány.';
$string['needtochoosecat'] = 'A kérdés áthelyezéséhez válasszon egy kategóriát, vagy nyomja meg a \'Mégse\' gombot.';
$string['nocate'] = 'Nincs {$a} kategória!';
$string['nopermissionadd'] = 'Itt nem adhat hozzá kérdéseket.';
$string['nopermissionmove'] = 'Nincs engedélye kérdések áthelyezésére. Mentse el a kérdést ezen kategória alá, vagy mentse el új kérdésként.';
$string['noprobs'] = 'Kérdéseinek adatbázisa rendben van.';
$string['notenoughdatatoeditaquestion'] = 'Nem adott meg sem kérdésazonosítót, sem kategóriaazonosítót kérdéstípussal.';
$string['notenoughdatatomovequestions'] = 'Az áthelyezendő kérdések azonosítóit meg kell adnia.';
$string['notflagged'] = 'Nincs megjelölve';
$string['novirtualquestiontype'] = 'A(z) {$a} kérdéstípushoz nincs virtuális kérdés';
$string['parentcategory'] = 'Felettes kategória';
$string['parentcategory_help'] = 'A felettes kategória az a kategória, amely alá az új kerül. A \'Fent\' azt jelenti, hogy a kategória semmilyen egyéb kategória alá nem tartozik. Általában több kategóriához tartozó környezet látható, ezek vastag betűkkel jelennek meg. Mindegyik környezetnek legalább egy kategóriát kell tartalmazni.';
$string['parenthesisinproperclose'] = 'A ** előtt a zárójel hibásan fejeződik be {$a}** esetén';
$string['parenthesisinproperstart'] = 'A ** előtt a zárójel hibásan indul {$a}** esetén';
$string['penaltyfactor'] = 'Büntetési tényező';
$string['penaltyfactor_help'] = '<p>Megadhatja, hogy az elért pontok közül mennyied rész legyen levonva az egyes rossz válaszokért. Ennek csak akkor van jelentősége, ha a teszt adaptív módban üzemel és a tanuló újból próbálkozhat. A büntetési tényező egy 0 és 1 közötti szám. Az 1 azt jelenti, hogy a tanulónak már az első válasznál helyesen kell felelnie ahhoz, hogy egyáltalán pontot kapjon. 0 esetén a tanuló tetszése szerinti alkalommal próbálkozhat, mégis a teljes pontszámot kapja.</p>';
$string['permissionedit'] = 'Kérdés szerkesztése';
$string['permissionmove'] = 'Kérdés áthelyezése';
$string['permissionsaveasnew'] = 'Mentés új kérdésként';
$string['permissionto'] = 'Van engedélye erre:';
$string['published'] = 'megosztva';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = 'A(z) <a href="{$a->qurl}">kérdés "{$a->name}" ({$a->qtype})</a> ebben a kérdéskategóriában szerepel, de használja a(z) <a href="{$a->qurl}">teszt "{$a->quizname}"</a> egy másik kurzusban "{$a->coursename}".';
$string['questionbank'] = 'Kérdésbank';
$string['questioncategory'] = 'Kérdéskategória';
$string['questioncatsfor'] = 'Kérdéskategóriák ehhez: \'{$a}\'';
$string['questiondoesnotexist'] = 'A kérdés nem létezik';
$string['questionname'] = 'A kérdés neve';
$string['questionsaveerror'] = 'Hiba történt kérdés mentése közben - ({$a})';
$string['questionsmovedto'] = 'Használatban lévő kérdéseket helyezett át "{$a}" alá a felettes kurzuskategóriában.';
$string['questionsrescuedfrom'] = 'Kérdések mentése {$a} környezetből.';
$string['questionsrescuedfrominfo'] = 'Ezekről a kérdésekről (melyek egy része lehet rejtett) mentés készült a(z) {$a} környezet törlésekor, mert egyes tesztekben vagy más tevékenységekben továbbra is szerepelnek.';
$string['questiontype'] = 'A kérdés típusa';
$string['questionuse'] = 'Kérdés használata ezen tevékenység során';
$string['saveflags'] = 'A jelölők állapotának mentése';
$string['selectacategory'] = 'Kategória kiválasztása:';
$string['selectaqtypefordescription'] = 'A leírás megtekintéséhez válasszon ki egy kérdéstípust.';
$string['selectquestionsforbulk'] = 'A csoportos intézkedésekhez válasszon ki kérdéseket.';
$string['shareincontext'] = 'Megosztás {$a} környezetében';
$string['stoponerror'] = 'Hiba esetén leállás';
$string['stoponerror_help'] = 'Ez a beállítás szabja meg, hogy az importálás hiba esetén megszakadjon-e, így a kérdések importálása elmarad, vagy kimaradjanak a hibát tartalmazó kérdések, de az érvényes importálása megtörténjen.';
$string['tofilecategory'] = 'Kategória kiírása állományba';
$string['tofilecontext'] = 'Környezet kiírása állományba';
$string['unknown'] = 'ismeretlen';
$string['unknownquestiontype'] = 'Ismeretlen kérdéstípus: {$a}.';
$string['unknowntolerance'] = 'Ismeretlen {$a} toleranciatípus';
$string['unpublished'] = 'nincs megosztva';
$string['upgradeproblemcategoryloop'] = 'Gond volt a kérdéskategóriák frissítésével. A kategóriafa hurkot tartalmaz. Az érintett kategóriaazonosítók: {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'A(z) {$a->name} ({$a->id}) kérdéskategória frissítése nem sikerült.';
$string['upgradeproblemunknowncategory'] = 'Gond volt a kérdéskategóriák frissítésével. A(z) {$a->id} kategória nem létező {$a->parent} felettes kategóriára hivatkozik. A hiba kijavításához módosult a felettes kategória.';
$string['wrongprefix'] = 'Hibás formájú {$a} névelőtag';
$string['youmustselectaqtype'] = 'Válasszon kérdéstípust!';
$string['yourfileshoulddownload'] = 'Exportállományának letöltése hamarosan elkezdődik. Ha mégsem, kattintson <a href="{$a}">ide</a>.';
