<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'hu', branch 'MOODLE_20_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Hozzáférés szabályozása';
$string['actionaftercorrectanswer'] = 'Helyes válasz utáni lépés';
$string['actionaftercorrectanswer_help'] = 'A kérdés helyes megválaszolása után 3 lehetőség közül választhat a következő oldalon:

* Szokásos - a lecke következő oldalának megjelenítése
* Egy új oldal megjelenítése - Az oldalak véletlenszerűen jelennek meg, minden oldal csak egyszer
* Egy megválaszolatlan oldal megjelenítése - Az oldalak véletlenszerűen jelennek meg a megválaszolatlan kérdések újbóli megjelenítésével';
$string['actions'] = 'Műveletek';
$string['activitylink'] = 'Kapcsolás tevékenységhez';
$string['activitylink_help'] = 'A lenyíló menüből válasszon ki egy tevékenységet, amely a lecke végén ugrópontként lesz látható az adott tevékenységhez.';
$string['activitylinkname'] = 'Áttérés ide: {$a}';
$string['addabranchtable'] = 'Tartalomoldal beszúrása';
$string['addanendofbranch'] = 'Elágazás végének hozzáadása';
$string['addanewpage'] = 'Új oldal hozzáadása';
$string['addaquestionpage'] = 'Kérdésoldal beszúrása';
$string['addaquestionpagehere'] = 'Kérdésoldal beszúrása ide';
$string['addbranchtable'] = 'Tartalomoldal beszúrása';
$string['addcluster'] = 'Tömb beszúrása';
$string['addedabranchtable'] = 'Tartalomoldal hozzáadva';
$string['addedanendofbranch'] = 'Elágazás vége hozzáadva';
$string['addedaquestionpage'] = 'Kérdésoldal hozzáadva';
$string['addedcluster'] = 'Tömb hozzáadva';
$string['addedendofcluster'] = 'Tömb vége hozzáadva';
$string['addendofcluster'] = 'Tömb végének hozzáadása';
$string['addpage'] = 'Oldal hozzáadása';
$string['anchortitle'] = 'A fő tartalom kezdete';
$string['and'] = 'ÉS';
$string['answer'] = 'Válasz';
$string['answeredcorrectly'] = 'helyesen megválaszolva.';
$string['answersfornumerical'] = 'A számjegyes kérdések válaszait minimális és maximális értékeket tartalmazó, egymáshoz illő párok formájában kell megadni';
$string['arrangebuttonshorizontally'] = 'A tartalomgombok vízszintesen jelenjenek meg?';
$string['attempt'] = 'Próbálkozás: {$a}';
$string['attempts'] = 'Próbálkozások';
$string['attemptsdeleted'] = 'Törölt próbálkozások';
$string['attemptsremaining'] = '{$a} próbálkozása maradt';
$string['available'] = 'Elérhető ekkortól';
$string['averagescore'] = 'Átlagpontszám';
$string['averagetime'] = 'Átlagidő';
$string['branch'] = 'Tartalom';
$string['branchtable'] = 'Tartalom';
$string['cancel'] = 'Mégse';
$string['cannotfindanswer'] = 'Hiba: nem található a válasz';
$string['cannotfindattempt'] = 'Hiba: nem található a próbálkozás';
$string['cannotfindessay'] = 'Hiba: nem található az esszé';
$string['cannotfindfirstgrade'] = 'Hiba: nem találhatók a pontok';
$string['cannotfindfirstpage'] = 'Nincs meg az első oldal';
$string['cannotfindgrade'] = 'Hiba: nem találhatók a pontok';
$string['cannotfindnewestgrade'] = 'Hiba: nem található a legutolsó pont';
$string['cannotfindnextpage'] = 'Lecke biztonsági mentése: nincs meg a következő oldal!';
$string['cannotfindpagerecord'] = 'Elágazás vége beszúrandó: az oldal rekordja nem található';
$string['cannotfindpages'] = 'Nincsenek meg a lecke oldalai';
$string['cannotfindpagetitle'] = 'Törlés megerősítése: az oldal címe nem található';
$string['cannotfindpreattempt'] = 'Az előző próbálkozás rekordja nem található!';
$string['cannotfindrecords'] = 'Hiba: nem találhatók a lecke rekordjai';
$string['cannotfindtimer'] = 'Hiba: nem találhatók a lesson_timer rekordok';
$string['cannotfinduser'] = 'Hiba: nem találhatók felhasználók';
$string['canretake'] = '{$a} újra próbálkozhat';
$string['casesensitive'] = 'Reguláris kifejezések használata';
$string['casesensitive_help'] = 'Reguláris kifejezések válaszok elemzésére való használatához jelölje be a jelölőnégyzetet';
$string['checkbranchtable'] = 'Tartalomoldal ellenőrzése';
$string['checkedthisone'] = 'Ellenőrizve.';
$string['checknavigation'] = 'Navigálás ellenőrzése';
$string['checkquestion'] = 'Kérdés ellenőrzése';
$string['classstats'] = 'Osztálystatisztika';
$string['clicktodownload'] = 'A következő ugrópontra kattintva töltse le az állományt.';
$string['clicktopost'] = 'Ide kattintva pontozása felkerül a legmagasabb pontszámok közé.';
$string['cluster'] = 'Tömb';
$string['clusterjump'] = 'Kihagyott kérdés egy tömbben';
$string['clustertitle'] = 'Tömb';
$string['collapsed'] = 'Összecsukott';
$string['comments'] = 'Megjegyzései';
$string['completed'] = 'Kész';
$string['completederror'] = 'Fejezze be a leckét';
$string['completethefollowingconditions'] = 'A következőket kell teljesítenie a(z) <b>{$a}</b> leckében, mielőtt továbbléphet.';
$string['conditionsfordependency'] = 'A teljesítés feltétele(i)';
$string['configactionaftercorrectanswer'] = 'Helyes válasz utáni tevékenység alapesetben';
$string['configmaxanswers'] = 'Oldalankénti válaszok maximális száma alapesetben';
$string['configmaxhighscores'] = 'Megjelenített legmagasabb pontok száma';
$string['configmediaclose'] = 'Megjelenít egy kapcsolt médiumállományhoz előállított, előugró ablak bezárására való gombot';
$string['configmediaheight'] = 'Beállítja a kapcsolt médiumállományhoz előállított előugró ablak magasságát';
$string['configmediawidth'] = 'Beállítja a kapcsolt médiumállományhoz előállított előugró ablak szélességét';
$string['configslideshowbgcolor'] = 'Bekapcsolt diavetítés esetén annak háttérszíne';
$string['configslideshowheight'] = 'Bekapcsolt diavetítés esetén beállítja annak magasságát';
$string['configslideshowwidth'] = 'Bekapcsolt diavetítés esetén beállítja annak szélességét';
$string['confirmdelete'] = 'Oldal törlése';
$string['confirmdeletionofthispage'] = 'Oldal törlésének megerősítése';
$string['congratulations'] = 'Gratulálunk - elérte a lecke végét!';
$string['continue'] = 'Tovább';
$string['continuetoanswer'] = 'Tovább a válaszok módosításához';
$string['continuetonextpage'] = 'Tovább a következő oldalra';
$string['correctanswerjump'] = 'Helyes válasz utáni ugrás';
$string['correctanswerscore'] = 'Helyes válasz pontszáma';
$string['correctresponse'] = 'Tanuló helyes válasza';
$string['credit'] = 'Kredit';
$string['customscoring'] = 'Testre szabott pontozás';
$string['customscoring_help'] = 'Bekapcsolása esetén minden válaszhoz megadhat egy számjegyes (negatív vagy pozitív) pontértéket';
$string['deadline'] = 'Határidő';
$string['defaultessayresponse'] = 'Az esszét kurzusvezetője fogja pontozni.';
$string['deleteallattempts'] = 'Leckével kapcsolatos összes próbálkozás törlése';
$string['deletedefaults'] = '{$a} x lecke alapbeállítása törölve';
$string['deletedpage'] = 'Oldal törölve';
$string['deleting'] = 'Törlés';
$string['deletingpage'] = 'A(z) {$a} oldal törlése';
$string['dependencyon'] = 'Összefüggés';
$string['dependencyon_help'] = '<p>Ezzel a beállítással a lecke összefüggésbe hozható a tanulónak az adott kurzuson belül egy
másik lecke során elért teljesítményével.  Ha az ezzel kapcsolatos
követelményeket nem teljesíti, akkor a tanuló számára ez a lecke nem lesz elérhető.</p>

<p>Az összefüggést meghatározó feltételek a következők:
    <ul>
        <li><span style="font-weight: bold;">Eltöltött idő</span>: a tanulónak az adott leckével ennyi ideig kell foglalkoznia.</li>
        <li><span style="font-weight: bold;">Elvégzés</span>: a tanulónak az adott leckét el kell végeznie.</li>
        <li><span style="font-weight: bold;">Ponthatár</span>: a tanulónak az adott leckével kapcsolatban
        a megadottnál magasabb pontot kell elérnie.</li>
    </ul>
    Szükség esetén a fentiek tetszés szerint kombinálhatók.
</p>';
$string['description'] = 'Leírás';
$string['detailedstats'] = 'Részletes statisztika';
$string['didnotanswerquestion'] = 'Nem válaszolt erre a kérdésre';
$string['didnotreceivecredit'] = 'Nem kapott kreditpontot';
$string['displaydefaultfeedback'] = 'Alapbeállítás szerinti visszajelzés';
$string['displaydefaultfeedback_help'] = '<p>Ha <strong>Igen</strong>-re állítja, egy adott kérdés esetén ha nincs megadva egyéb visszajelzés,
az alapbeállítás szerinti "Helyes válasz" vagy "Helytelen válasz" lesz látható.</p>
<p>Ha <strong>Nem</strong>-re állítja, egy adott kérdés esetén ha nincs megadva egyéb visszajelzés,
semmilyen visszajelzés nem lesz látható.
A leckét tanulmányozó tanuló automatikusan a lecke következő oldalára kerül.</p>';
$string['displayhighscores'] = 'Legmagasabb pontszámok kijelzése';
$string['displayinleftmenu'] = 'A bal menüben jelenjen meg?';
$string['displayleftif'] = 'Bal menü megjelenítése csak ennél magasabb pontszám esetén:';
$string['displayleftif_help'] = 'Valamely pont megadása esetén a leckét felvevő tanulónak a bal menü megtekintéséhez legalább a beállított pontot el kell érnie. Így arra kényszeríti a tanulót, hogy az első próbálkozás alkalmával végigmenjen a teljes leckén. Ha a szükséges pont elérése után újból átveszi a leckét, akkor segítségként megjelenik számára a bal oldali menü.';
$string['displayleftmenu'] = 'Bal menü kijelzése';
$string['displayleftmenu_help'] = 'Bekapcsolása esetén megjeleníti az oldalak felsorolását.';
$string['displayofgrade'] = 'Pont kijelzése (csak tanulóknak)';
$string['displayreview'] = 'Újrapróbálkozás lehetővé tétele';
$string['displayreview_help'] = 'Bekapcsolása esetén hibás választ követően a tanuló kreditpont nélkül újrapróbálkozhat, vagy továbbléphet a leckében.';
$string['displayscorewithessays'] = 'Az automatikus pontozású kérdéseknél {$a->score} pontot kapott a maximális {$a->tempmaxgrade} pontból.<br /><br />Az {$a->essayquestions} esszékérdés(é/ei)t később pontozzák és adják hozzá végső pontszámához.<br /><br />Az esszékérdés(ek) nélküli jelenlegi pontszáma {$a->score} a(z) {$a->grade} pontból';
$string['displayscorewithoutessays'] = 'Pontszáma {$a->score} ({$a->grade} pontból).';
$string['edit'] = 'Szerkesztés';
$string['editingquestionpage'] = 'A(z) {$a} kérdésoldal szerkesztése';
$string['editlessonsettings'] = 'Leckebeállítások szerkesztése';
$string['editpage'] = 'Oldal tartalmának szerkesztése';
$string['editpagecontent'] = 'Oldal tartalmának szerkesztése';
$string['email'] = 'E-mail';
$string['emailallgradedessays'] = 'Az ÖSSZES pontozott <br />esszé elküldése e-mailben';
$string['emailgradedessays'] = 'Pontozott esszék elküldése e-mailben';
$string['emailsuccess'] = 'Az e-mailek elküldése sikerült';
$string['emptypassword'] = 'A jelszó nem lehet üres';
$string['endofbranch'] = 'Elágazás vége';
$string['endofcluster'] = 'Tömb vége';
$string['endofclustertitle'] = 'Tömb vége';
$string['endoflesson'] = 'Lecke vége';
$string['enteredthis'] = 'adta meg ezt.';
$string['entername'] = 'Legmagasabb pontszámokhoz becenév megadása';
$string['enterpassword'] = 'Adja meg a jelszót:';
$string['eolstudentoutoftime'] = 'Figyelem! Túllépte a leckeidőt. Előfordulhat, hogy utolsó válasza már nem fog beszámítani.';
$string['eolstudentoutoftimenoanswers'] = 'Nem válaszolt egyetlen kérdésre sem. A leckére 0 pontot kapott.';
$string['essay'] = 'Esszé';
$string['essayemailmessage'] = '<p>Esszéüzenet:<blockquote>{$a->question}</blockquote></p><p>Tanuló válasza:<blockquote><em>{$a->response}</em></blockquote></p><p>{$a->teacher} megjegyzései:<blockquote><em>{$a->comment}</em></blockquote></p><p>Ön {$a->earned} pontot kapott {$a->outof} pontból erre az esszékérdésre.</p><p>A leckére kapott pontszáma így {$a->newgrade}%.</p>';
$string['essayemailmessage2'] = '<p>Esszéüzenet:<blockquote>{$a->question}</blockquote></p><p>Az Ön válasza:<blockquote><em>{$a->response}</em></blockquote></p><p>A pontozó megjegyzései:<blockquote><em>{$a->comment}</em></blockquote></p><p>Ezen essszékérdésre a lehetséges {$a->outof} pontból {$a->earned} pontot kapott.</p><p>A leckével kapcsolatos pontszáma {$a->newgrade}&#37; pontra módosult.</p>';
$string['essayemailsubject'] = 'Pontja a {$a} kérdésre';
$string['essays'] = 'Esszék';
$string['essayscore'] = 'Esszé pontszáma';
$string['fileformat'] = 'Állományforma';
$string['finish'] = 'Kész';
$string['firstanswershould'] = 'Az első válasznak a Helyes oldalra kell ugrania';
$string['firstwrong'] = 'Ezt a pontot nem kaphatja meg, mert rosszul válaszolt. Azért a tanulás kedvéért folytatná még a próbálkozást (de már pontszerzés nélkül)?';
$string['flowcontrol'] = 'Folyamat szabályozása';
$string['full'] = 'Kibontva';
$string['general'] = 'Általános';
$string['gotoendoflesson'] = 'Tovább a lecke végére';
$string['grade'] = 'Pont';
$string['gradebetterthan'] = 'Ponthatár';
$string['gradebetterthanerror'] = '{$a} százaléknál magasabb pontszám szerzése';
$string['gradeessay'] = 'Esszékérdések pontozása ({$a->notgradedcount} pontozatlan és {$a->notsentcount} elküldetlen)';
$string['gradeis'] = 'A pont: {$a}';
$string['gradeoptions'] = 'Pontozási lehetőségek';
$string['handlingofretakes'] = 'Leckeismétlés kezelése';
$string['handlingofretakes_help'] = '<p>Ha a tanulók megismételhetnek egy leckét, ezzel az opcióval a tanár megjelenítheti a leckére adott pontok számát például a Pontok oldalon, vagy úgy, mint a különféle próbálkozások pontjainak <b>átlagát</b>, vagy úgy, mint a tanulók <b>legjobb</b> próbálkozásaira adott pontszámot.</p>

<p>Ez az opció bármikor módosítható.</p>';
$string['havenotgradedyet'] = 'Még nincs pontozva.';
$string['here'] = 'itt';
$string['highscore'] = 'Magas pontszám';
$string['highscores'] = 'Magas pontszámok';
$string['hightime'] = 'Leghosszabb idő';
$string['importcount'] = '{$a} kérdés importálása';
$string['importppt'] = 'PowerPoint importálása';
$string['importppt_help'] = '<p> Használata</p>
<p>Minden PowerPoint dia elágazási táblázatként importálódik, <span style="font-style: italic;">előző</span> és
<span style="font-style: italic;">következő</span> válasszal.</p>
<p>
<ol>
<li>Nyissa meg a PowerPoint prezentációját.</li>
<li>Mentse el weboldalként (külön opciók nélkül)</li>
<li>A 3. lépés eredménye egy htm-állomány vagy egy mappa, melyben minden dia weboldallá van átalakítva.<br />
  CSAK A MAPPÁT tömörítse.</li>
<li>Térjen át a Moodle portálra és adjon hozzá egy új leckét.</li>
<li>A lecke beállításainak mentése után 4 opciót lát a
"Mit kíván tenni először?" alatt. Kattintson a "PowerPoint importálása" pontra.</li>
<li>A "Tallózás ..." gombbal keresse meg a 3. lépésben elkészített tömörített
állományt. Ezután kattintson az "Állomány feltöltése" pontra.</li>
<li>Ha minden rendben zajlott, a következő képernyőn csak a Tovább gomb látható.</li>
</ol>
</p>
<p>Ha a PowerPoint képeket is tartalmazott, ezek kurzusállományként lettek elmentve a moddata/XY alá, ahol
 az X a lecke neve és az Y egy szám (rendszerint 0). Emellett az importálás alatt állományok jönnek
 létre a moodledata könyvtárban a temp/lesson alatt. Ezeket az állományokat az importppt.php most még nem törli.</p>
<p align="center"> </p>';
$string['importquestions'] = 'Kérdések importálása';
$string['importquestions_help'] = 'Ezzel a funkcióval külső, űrlapon keresztül feltöltött szöveges állományból importálhat különféle formájú kérdéseket.  
';
$string['insertedpage'] = 'Oldal beszúrva';
$string['invalidfile'] = 'Érvénytelen állomány';
$string['invalidid'] = 'Nem került sor kurzusmodul-azonosító vagy leckeazonosító átadására';
$string['invalidlessonid'] = 'hibás volt a leckeazonosító';
$string['invalidpageid'] = 'Érvénytelen oldalazonosító';
$string['jump'] = 'Ugrás';
$string['jumps'] = 'Ugrások';
$string['jumps_help'] = 'Minden (kérdésre adott) válaszhoz vagy (tartalomoldalhoz tartozó) leíráshoz hozzátartozik egy ugrópont. Az ugrás lehet relatív, pl. ez az oldal vagy a következő oldal,  vagy abszolút, azaz a lecke bármely oldala.';
$string['jumpsto'] = 'Ugrások ide: {$a}';
$string['leftduringtimed'] = 'Időméréses lecke közben távozott.<br />Kattintson a Folytatás gombra, és kezdje újra a leckét.';
$string['leftduringtimednoretake'] = 'Időméréses lecke közben távozott, ezért nem ismételheti meg és nem folytathatja a leckét.';
$string['lessonattempted'] = 'Elkezdett lecke';
$string['lessonclosed'] = 'A lecke lezárult {$a} időpontban.';
$string['lessoncloses'] = 'A lecke lezárul';
$string['lessoncloseson'] = 'A lecke lezárul ekkor: {$a}';
$string['lesson:edit'] = 'Lecketevékenység szerkesztése';
$string['lessonformating'] = 'Lecke formázása';
$string['lesson:manage'] = 'Lecketevékenység kezelése';
$string['lessonmenu'] = 'Lecke menü';
$string['lessonnotready'] = 'A lecke nem végezhető el. Forduljon a(z) {$a}-hoz.';
$string['lessonnotready2'] = 'A lecke még nem végezhető el.';
$string['lessonopen'] = 'A lecke {$a} időpontban kezdődik.';
$string['lessonopens'] = 'A lecke kezdődik';
$string['lessonpagelinkingbroken'] = 'Nincs meg az első oldal. A leckeoldal nem kapcsolódik. Forduljon a rendszergazdához.';
$string['lessonstats'] = 'Leckestatisztika';
$string['linkedmedia'] = 'Kapcsolt média';
$string['loginfail'] = 'Belépése nem sikerült, próbálja újra...';
$string['lowscore'] = 'Alacsony pontszám';
$string['lowtime'] = 'Legrövidebb idő';
$string['manualgrading'] = 'Esszék pontozása';
$string['matchesanswer'] = 'Válasszal egyezik';
$string['matching'] = 'Párosítás';
$string['matchingpair'] = 'A(z) {$a} pár párosítása';
$string['maxgrade'] = 'Maximális pont';
$string['maxgrade_help'] = '<p>Ez az érték határozza meg azt a maximális pontszámot, amely a leckére adható. A tartomány 0 és 100% között változhat. Ez az érték a lecke alatt
bármikor módosítható. Bármely változás azonnal megjelenik a Pontok oldalon és a különféle listákban a tanulók számára megjelenő pontoknál.
Ha a pontszám 0-ra van állítva, a lecke nem jelenik  meg egy Pontok oldalon sem.</p>';
$string['maxhighscores'] = 'Kijelzett legmagasabb pontszámok';
$string['maximumnumberofanswersbranches'] = 'Válaszok maximális száma';
$string['maximumnumberofanswersbranches_help'] = 'Ez az érték határozza meg azon válaszok maximális számát, amelyek egy leckében használhatók. Ha mindvégig csak IGAZ vagy HAMIS kérdések szerepelnek, akkor az értéket 2-re állíthatja. A beállítás bármikor módosítható, mivel csak azt érinti, amit a tanár lát, nem pedig az adatokat.';
$string['maximumnumberofattempts'] = 'Próbálkozások maximális száma';
$string['maximumnumberofattempts_help'] = 'Ez az érték határozza meg, hogy legfeljebb hányszor
lehet próbálkozni az egyes kérdések megoldása során. Hibás ismételt válasz esetén a maximális szám
elérését követően a lecke következő oldala jelenik meg.';
$string['maximumnumberofattemptsreached'] = 'A próbálkozások maximális számát elérte - áttérés a következő oldalra.';
$string['maxtime'] = 'Időméréses (perc)';
$string['maxtimewarning'] = 'A lecke befejezésére {$a} perc áll rendelkezésére.';
$string['mediaclose'] = 'Lezárás gombjának kijelzése';
$string['mediafile'] = 'Ugrás állományhoz vagy weboldalra';
$string['mediafile_help'] = '<p>Ennek segítségével egy lecke elején előbukkanó ablak hozható létre egy
állományhoz (pl. egy mp3 fájlhoz) vagy egy weboldalhoz. Emellett minden leckeoldalon egy ugrópont jelenik meg,
amely ezt az ablakot szükség esetén újból megnyitja.</p>

<p>Választható emellett egy "Ablak bezárása" gomb elhelyezése az előbukkanó ablak
alján, továbbá beállítható az ablak magassága és szélessége is.</p>';
$string['mediafilepopup'] = 'A megtekintéshez kattintson ide.';
$string['mediaheight'] = 'Előugró ablak magassága';
$string['mediawidth'] = 'Előugró ablak szélessége';
$string['messageprovider:graded_essay'] = 'Értesített pontozott esszéről';
$string['minimumnumberofquestions'] = 'Kérdések minimális száma';
$string['minimumnumberofquestions_help'] = 'Ez az érték határozza meg a tevékenységre adott pont kiszámításához használt kérdések minimális számát. Ha a leckében egy vagy több tartalomoldal szerepel, a kérdések minimális számát nullára kell állítani.
Ha például ezt a paramétert 20-ra állítja be, ez esetben a lecke nyitó oldalán valami alábbihoz hasonló szöveg szerepelhet: "Ebben a leckében legalább 20 kérdést kell megoldania. Ha kívánja,
többel is próbálkozhat. Ha viszont 20 kérdésnél kevesebbel próbálkozik, pontszámának kiszámításakor a rendszer abból indul ki, hogy Ön 20-szor próbálkozott."';
$string['missingname'] = 'Adjon meg egy becenevet';
$string['modattempts'] = 'Önértékelés engedélyezése';
$string['modattempts_help'] = '<p>Lehetővé teszi, hogy a tanuló a leckében visszalépve módosítsa válaszait.</p>';
$string['modattemptsnoteacher'] = 'Önértékelést csak tanulók végezhetnek.';
$string['modulename'] = 'Lecke';
$string['modulename_help'] = '<p><img alt="" src="<?php echo $CFG->wwwroot?>/mod/lesson/icon.gif" />&nbsp;<strong>Lecke</strong>

<div class="indent">A lecke tartalmak érdekes és rugalmas módon való közvetítésére használható. Több oldalból tevődik össze. Minden oldal általában egy kérdéssel és hozzá egy sor lehetséges válasszal zárul. A tanuló a válaszadási lehetőségektől függően vagy továbblép a következő oldalra, vagy visszajut az előzőre. A leckén való végighaladás a közreadandó anyag struktúrájától függően lehet egyszerű és bonyolult.</div>';
$string['modulenameplural'] = 'Leckék';
$string['move'] = 'Oldal áthelyezése';
$string['movedpage'] = 'Oldal áthelyezve';
$string['movepagehere'] = 'Oldal áthelyezése ide';
$string['moving'] = 'A(z) {$a} oldal áthelyezése';
$string['multianswer'] = 'Feleletválasztós';
$string['multianswer_help'] = 'Jelölje be a négyzetet, ha egynél több válasz helyes.';
$string['multichoice'] = 'Feleletválasztós';
$string['multipleanswer'] = 'Több válasz';
$string['nameapproved'] = 'Név elfogadva';
$string['namereject'] = 'Nevét a szűrő nem fogadta el. Próbálkozzon egy másik névvel.';
$string['new'] = 'új';
$string['nextpage'] = 'Következő oldal';
$string['noanswer'] = 'Nincs megadva válasz. Lépjen vissza és adjon le egy választ.';
$string['noattemptrecordsfound'] = 'Nincs próbálkozás rögzítve: nem kapott pontot';
$string['nobranchtablefound'] = 'Nincs tartalomoldal';
$string['nocommentyet'] = 'Még nincs megjegyzés.';
$string['nocoursemods'] = 'Nincs tevékenység';
$string['nocredit'] = 'Nincs kreditpont';
$string['nodeadline'] = 'Nincs határidő';
$string['noessayquestionsfound'] = 'A leckében nincs esszékérdés.';
$string['nohighscores'] = 'Nincsenek legmagasabb pontszámok';
$string['nolessonattempts'] = 'A leckével kapcsolatosan nem történt próbálkozás.';
$string['nooneansweredcorrectly'] = 'Senki nem felelt helyesen.';
$string['nooneansweredthisquestion'] = 'Senki nem felelt a kérdésre.';
$string['noonecheckedthis'] = 'Senki nem ellenőrizte ezt.';
$string['nooneenteredthis'] = 'Senki nem válaszolta ezt.';
$string['noonehasanswered'] = 'Senki nem válaszolt még egyetlen esszékérdésre sem.';
$string['noretake'] = 'Ezt a leckét nem ismételheti meg.';
$string['normal'] = 'Szokásos - kövesse a lecke útvonalát';
$string['notcompleted'] = 'Nincs befejezve';
$string['notdefined'] = 'Nincs megadva';
$string['nothighscore'] = 'Nem érte el a legmagasabb {$a} pontszámú listát.';
$string['notitle'] = 'Nincs cím';
$string['numberofcorrectanswers'] = 'A helyes válaszok száma: {$a}';
$string['numberofcorrectmatches'] = 'A helyes megfelelések száma: {$a}';
$string['numberofpagestoshow'] = 'Megjelenítendő oldalak száma';
$string['numberofpagestoshow_help'] = '<p>Ez a paraméter kizárólag Flash Card típusú leckékre érvényes. Az alapérték
nulla, ami azt jelenti, hogy egy leckében minden oldal/kártya megjelenik. Ha ezt a paramétert nem nullának
megfelelő valamilyen értékre állítja, akkor az adott számú oldal fog megjelenni. Ha az adott
számú oldalt/kártyát a rendszer megmutatta, a lecke véget ér és a tanuló előtt
láthatóvá válik az elért pontszám.</p>

<p>Ha a paramétert a leckében lévő oldalak számánál nagyobb értékre
állítja, akkor a lecke akkor ér véget, ha megtörtént minden oldal megjelenítése.</p>';
$string['numberofpagesviewed'] = 'A megtekintett oldalak száma: {$a}';
$string['numberofpagesviewednotice'] = 'Megválaszolt kérdések száma: {$a->nquestions}; (Megválaszolandó legalább: {$a->minquestions})';
$string['numerical'] = 'Számjegyes';
$string['ongoing'] = 'Pillanatnyi pont mutatása';
$string['ongoingcustom'] = '{$a->score} pontot ért el az eddig elérhető {$a->currenthigh} pontból.';
$string['ongoing_help'] = '<p>Bekapcsolása esetén az egyes oldalakon megjelenik a tanuló által az összes
 megszerezhető pontból ez idáig megszerzett pontok száma.
 Példa: egy tanuló négy 5 pontos kérdésre válaszolt és egyre hibás választ adott.
 Ekkor a pillanatnyi pont 15/20 pont lesz.</p>';
$string['ongoingnormal'] = '{$a-&gt;correct} kérdést válaszolt meg helyesen az eddigi {$a-&gt;viewed} próbálkozásból';
$string['onpostperpage'] = 'Pontonként csak egy hozzászólás';
$string['options'] = 'Lehetőségek';
$string['or'] = 'VAGY';
$string['ordered'] = 'Rendezett';
$string['other'] = 'Egyéb';
$string['outof'] = '{$a}-ból/-ből';
$string['overview'] = 'Áttekintés';
$string['overview_help'] = 'Egy-egy lecke néhány oldalból és esetlegesen tartalomoldalakból épül föl.
Egy oldalon valamilyen tartalom  jelenik meg, és általában egy kérdéssel végződik. A válaszokhoz hozzátartozik egy ugrópont. Az ugrópont lehet relatív - adott oldalhoz, következő oldalhoz való ugrás - vagy abszolút - a lecke bármely oldalára vagy a lecke végére ugrás. A tartalomoldal a lecke más oldalaira, például a tartalomjegyzékre  mutató ugrópontokat tartalmaz.';
$string['page'] = 'Oldal: {$a}';
$string['pagecontents'] = 'Oldal tartalma';
$string['pages'] = 'Oldalak';
$string['pagetitle'] = 'Oldal címe';
$string['password'] = 'Jelszó';
$string['passwordprotectedlesson'] = 'A(z) {$a} egy jelszóval védett lecke.';
$string['pleasecheckoneanswer'] = 'Jelöljön be egy választ';
$string['pleasecheckoneormoreanswers'] = 'Jelöljön be egy vagy több választ';
$string['pleaseenteryouranswerinthebox'] = 'A négyzetbe írja be a választ';
$string['pleasematchtheabovepairs'] = 'Párosítsa a fenti elemeket';
$string['pluginadministration'] = 'Lecke kezelése';
$string['pluginname'] = 'Lecke';
$string['pointsearned'] = 'Kapott pontok';
$string['postprocesserror'] = 'Hiba történt utófeldolgozás közben!';
$string['postsuccess'] = 'Az elküldés sikerült';
$string['pptsuccessfullimport'] = 'A feltöltött PowerPoint-bemutató oldalainak importálása sikerült';
$string['practice'] = 'Gyakorló lecke';
$string['practice_help'] = '<p>A gyakorló lecke nem jelenik meg az osztálynaplóban.</p>';
$string['preprocesserror'] = 'Hiba történt előfeldolgozás közben!';
$string['preview'] = 'Előzetes megtekintés';
$string['previewlesson'] = '{$a} előzetes képe';
$string['previouspage'] = 'Előző oldal';
$string['processerror'] = 'Hiba történt feldolgozás közben!';
$string['progressbar'] = 'Folyamatjelző';
$string['progressbar_help'] = '<p>Folyamatjelző megjelenítése a lecke alján.
Jelenleg a folyamatjelző lineáris lecke esetén pontos.</p>
<p>A teljesített százalék kiszámításakor a lecke elvégzésébe az
elágazási táblázatok és a helyesen
megválaszolt kérdésoldalak számítanak bele.  A lecke összes oldalainak a kiszámítása
során a tömbök és a tömbökön belüli oldalak csak egyetlen oldalnak számítanak,
a tömb vége és az elágazási táblázat oldalainak a vége viszont nem.
Minden egyéb oldal beleszámít a lecke teljes oldalszámába.</p>
<p>Megjegyzés: a folyamatjelző alapstílusa nem éppen tetszetős ;)  A folyamatjelző minden stílusa
(például: színek, háttérképek stb.) a mod/lesson/styles.php állományban módosítható.';
$string['progressbarteacherwarning'] = '{$a} folyamatjelzője nem látszik';
$string['progressbarteacherwarning2'] = 'A folyamatjelzőt nem fogja látni, mert Ön szerkesztheti ezt a leckét.';
$string['qtype'] = 'Oldal típusa';
$string['question'] = 'Kérdés';
$string['questionoption'] = 'Kérdés';
$string['questiontype'] = 'Kérdésfajta';
$string['randombranch'] = 'Véletlenszerűen tartalomoldal';
$string['randompageinbranch'] = 'Véletlenszerű kérdés tartalomoldalon belül';
$string['rank'] = 'Sorrend';
$string['rawgrade'] = 'Nyers pont';
$string['receivedcredit'] = 'Kreditpontot kapott';
$string['redisplaypage'] = 'Oldal újbóli megjelenítése';
$string['report'] = 'Jelentés';
$string['reports'] = 'Jelentések';
$string['response'] = 'Tanuló válasza';
$string['retakesallowed'] = 'Újbóli próbálkozások engedélyezve';
$string['retakesallowed_help'] = '<p>Ez a beállítás határozza meg, hogy a tanulók egynél többször is elvégezhetnek-e egy
leckét. A tanár vélekedhet úgy, hogy a leckében szerepelnek olyan anyagok, amelyeket a tanulóknak
alaposan ismerniük kell. Ilyen esetben lehetővé kell tenni a lecke ismételt megtekintését. Ha viszont a
tananyag inkább afféle vizsga szerepét tölti be, azt a tanulók csak egyszer vehetik végig.</p>

<p>Ha engedélyezi a lecke újbóli elvégzését, akkor a pontokat tartalmazó oldalon
lévő <strong>pontok</strong> vagy az ismétlések <strong>átlagos</strong> pontszámát, vagy a
tanulóknak a leckére kapott <strong></strong> pontszámát jelzik. A következő paraméter azt
határozza meg, hogy a két pontozási lehetőség közül melyiket fogja használni.</p>

<p>Ne feledje, hogy a <strong>kérdéselemzés</strong> mindig a leckén végrehajtott első
próbálkozásból kapott válaszokra vonatkozik, a tanulók későbbi
próbálkozásait figyelmen kívül hagyja.</p>

<p>Alaphelyzetben ez az opció <strong>Igen</strong>-re van beállítva, vagyis a tanulók újból
elvégezhetik a leckét. Ezt az opciót feltehetőleg csak kivételes esetekben kell <strong>Nem</strong>-re állítani.</p>';
$string['returnto'] = 'Vissza ide: {$a}';
$string['returntocourse'] = 'Vissza a kurzushoz';
$string['review'] = 'Értékelés';
$string['reviewlesson'] = 'Összefoglaló lecke';
$string['reviewquestionback'] = 'Igen, megpróbálnám';
$string['reviewquestioncontinue'] = 'Nem, továbblépek a következő kérdésre';
$string['sanitycheckfailed'] = 'Alaphiba ellenőrzése sikertelen: a próbálkozás törölve';
$string['savechanges'] = 'Változások mentése';
$string['savechangesandeol'] = 'Minden változás mentése és áttérés a lecke végére';
$string['savepage'] = 'Oldal mentése';
$string['score'] = 'Pontszám';
$string['scores'] = 'Pontszámok';
$string['secondpluswrong'] = 'Nem pontos. Próbálkozna újra?';
$string['selectaqtype'] = 'Válasszon kérdéstípust';
$string['shortanswer'] = 'Kiegészítendő';
$string['showanunansweredpage'] = 'Megválaszolatlan oldal megjelenítése';
$string['showanunseenpage'] = 'Kihagyott oldal megjelenítése';
$string['singleanswer'] = 'Egy válasz';
$string['skip'] = 'Navigálás kihagyása';
$string['slideshow'] = 'Bemutató';
$string['slideshowbgcolor'] = 'Bemutató háttérszíne';
$string['slideshowheight'] = 'Bemutató magassága';
$string['slideshow_help'] = '<p>A leckét rögzített szélességű és magasságú, testre szabott hátterű
bemutatóként jeleníti meg. CSS-alapú gördítősáv jelenik meg, ha a tartalom
szélessége vagy magassága meghaladja a képkockáét. A kérdések \'kilépnek\'
a bemutató módból, csak az oldalak (elágazási táblázatok) látszanak a
képkockában. A képkocka jobb és bal szélén a "Következő" és a "Vissza" gombok jelennek meg,
ha ez az opció az oldalon ki van választva. A többi gomb a képkocka alatt középen látszik.</p>';
$string['slideshowwidth'] = 'Bemutató szélessége';
$string['startlesson'] = 'Lecke elkezdése';
$string['studentattemptlesson'] = '{$a->lastname} {$a->firstname} próbálkozásainak száma {$a->attempt}';
$string['studentname'] = '{$a} név';
$string['studentoneminwarning'] = 'Vigyázat! A lecke befejezéséhez 1 percnél kevesebb ideje maradt.';
$string['studentresponse'] = '{$a} tanuló válasza';
$string['submit'] = 'Leadás';
$string['submitname'] = 'Név leadása';
$string['teacherjumpwarning'] = 'A lecke {$a->cluster} ugrást vagy {$a->unseen} ugrást tartalmaz. Helyette a következő oldalra ugrik. Az ugrások ellenőrzéséhez lépjen be tanulóként.';
$string['teacherongoingwarning'] = 'A pillanatnyi pontszám csak tanuló számára látható. Ellenőrzéséhez lépjen be tanulóként.';
$string['teachertimerwarning'] = 'Az időmérő csak tanuló számára látható. Ellenőrzéséhez lépjen be tanulóként.';
$string['thatsthecorrectanswer'] = 'Ez a helyes válasz';
$string['thatsthewronganswer'] = 'Ez a hibás válasz';
$string['thefollowingpagesjumptothispage'] = 'A következő oldalak erre az oldalra ugranak';
$string['thispage'] = 'Ez az oldal';
$string['timeremaining'] = 'Hátralévő idő';
$string['timespenterror'] = 'Töltsön legalább {$a} percet a leckével';
$string['timespentminutes'] = 'Eltöltött idő (perc)';
$string['timetaken'] = 'Felhasznált idő';
$string['topscorestitle'] = 'Lecke {$a} legmagasabb pontszáma.';
$string['truefalse'] = 'Igaz/hamis';
$string['unabledtosavefile'] = 'A feltöltött állományt nem lehetett elmenteni';
$string['unknownqtypesnotimported'] = 'A nem támogatott kérdéstípusú {$a} kérdés importálása nem történt meg';
$string['unseenpageinbranch'] = 'Kihagyott kérdés egy tartalomoldalon';
$string['unsupportedqtype'] = 'Nem támogatott kérdéstípus ({$a})!';
$string['updatedpage'] = 'Frissített oldal';
$string['updatefailed'] = 'A frissítés nem sikerült';
$string['usemaximum'] = 'Maximális érték használata';
$string['usemean'] = 'Középérték használata';
$string['usepassword'] = 'Jelszóval védett lecke';
$string['usepassword_help'] = '<p>A tanuló csak akkor férhet hozzá a leckéhez, ha begépeli a jelszót.</p>';
$string['viewgrades'] = 'Pontok kijelzése';
$string['viewhighscores'] = 'Legmagasabb pontszámok megtekintése';
$string['viewreports'] = '{$a->attempts} befejezett {$a->student} próbálkozás megtekintése';
$string['viewreports2'] = '{$a} befejezett próbálkozás megtekintése';
$string['welldone'] = 'Nagyszerű!';
$string['whatdofirst'] = 'Mivel szeretne kezdeni?';
$string['wronganswerjump'] = 'Ugrás helytelen válaszról';
$string['wronganswerscore'] = 'Helytelen válaszra adott pontszám';
$string['wrongresponse'] = 'Tanuló helytelen válasza';
$string['xattempts'] = '{$a} próbálkozás';
$string['youhaveseen'] = 'Ebből a leckéből már egynél több oldalt látott.<br />Az utolsó megtekintett oldalon kívánja folytatni?';
$string['youmadehighscore'] = 'Felelete a legjobb {$a} között volt';
$string['youranswer'] = 'Válasza';
$string['yourcurrentgradeis'] = 'Jelenlegi pontja:  {$a}';
$string['yourcurrentgradeisoutof'] = 'Jelenlegi pontjainak száma {$a->grade} pont a {$a->total} pontból';
$string['youshouldview'] = 'Minimálisan megválaszolandó: {$a}';
