<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'hu', branch 'MOODLE_20_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Hozzáférés elutasítva';
$string['accounts'] = 'Fiókok';
$string['additionalhtml'] = 'Kiegészítő HTML';
$string['additionalhtml_desc'] = 'Itt állíthatja be, milyen HTML szerepeljen minden oldalon. Megadhatja, milyen HTML szerepeljen az oldal HEAD címkéjében közvetlenül a BODY címke megnyitása után vagy a bezárása előtt.<br />Ezzel testre szabott fejlécet és láblécet használhat minden oldalon, illetve szolgáltatásokat, pl. a Google Analytics használatát támogathatja igen egyszerűen és a kiválasztott stílustól függetlenül.';
$string['additionalhtmlfooter'] = 'A BODY bezárása előtt';
$string['additionalhtmlfooter_desc'] = 'Az itt szereplő tartalom minden oldalhoz hozzáadódik a BODY bezárása előtt.';
$string['additionalhtmlhead'] = 'A HEAD-en belül';
$string['additionalhtmlhead_desc'] = 'Az itt szereplő tartalom minden oldalhoz hozzáadódik a HEAD-címke aljához.';
$string['additionalhtml_heading'] = 'Minden oldalhoz hozzáadandó kiegészítő HTML. ';
$string['additionalhtmltopofbody'] = 'A BODY megnyitásakor';
$string['additionalhtmltopofbody_desc'] = 'Az itt szereplő tartalom minden oldalhoz hozzáadódik, közvetlenül a BODY-címke megnyitása után.';
$string['adminseesall'] = 'A rendszergazdák mindent látnak';
$string['adminseesallevents'] = 'A rendszergazdák minden eseményt látnak';
$string['adminseesownevents'] = 'A rendszergazdák nem különböznek a többi felhasználótól';
$string['advancedfeatures'] = 'További jellemzők';
$string['allcountrycodes'] = 'Az összes országkód';
$string['allowbeforeblock'] = 'Először az engedélyezett lista feldolgozására kerül sor.';
$string['allowbeforeblockdesc'] = 'Alaphelyzetben először a zárolt IP-lista elemeinek párosítására kerül sor. Ezen funkció bekapcsolása esetén a zárolt  lista feldolgozása előtt történik az engedélyezett IP-lista elemeinek a feldolgozása.';
$string['allowblockstodock'] = 'Blokkok számára a tároló használatának engedélyezése';
$string['allowcategorythemes'] = 'Kategóriastílusok engedélyezése';
$string['allowcoursethemes'] = 'Kurzusstílusok engedélyezése';
$string['allowdeletes'] = 'Törlés engedélyezése';
$string['allowediplist'] = 'Engedélyezett IP-lista';
$string['allowemailaddresses'] = 'Engedélyezett e-mail domének';
$string['allowobjectembed'] = 'EMBED- és OBJECT-címke használatának engedélyezése';
$string['allowrenames'] = 'Átnevezés engedélyezése';
$string['allowthemechangeonurl'] = 'Stílusmódosítások engedélyezése az URL-ben';
$string['allowuserblockhiding'] = 'Felhasználók számára blokkok elrejtésének engedélyezése';
$string['allowusermailcharset'] = 'Felhasználók számára karakterkészlet kiválasztásának engedélyezése';
$string['allowuserswitchrolestheycantassign'] = 'Szerepváltás engedélyezése szerep-hozzárendelő funkcióval nem rendelkező felhasználók részére';
$string['allowuserthemes'] = 'Felhasználói stílusok engedélyezése';
$string['antivirus'] = 'Vírusirtó';
$string['appearance'] = 'Megjelenés';
$string['aspellpath'] = 'Útvonal az aspellhez';
$string['authentication'] = 'Hitelesítés';
$string['authsettings'] = 'Hitelesítés kezelése';
$string['autolang'] = 'Nyelv automatikus észlelése';
$string['autologinguests'] = 'Vendégek automatikus beléptetése';
$string['availablelicenses'] = 'Elérhető licencek';
$string['availableto'] = 'Elérheti';
$string['backgroundcolour'] = 'Áttetsző szín';
$string['backups'] = 'Biztonsági mentések';
$string['badwordsconfig'] = 'Adja meg a nem használható szavak vesszővel elválasztott jegyzékét.';
$string['badwordsdefault'] = 'Ha a testre szabott lista üres, a rendszer a nyelvi csomag alapbeállítás szerinti listáját fogja használni.';
$string['badwordslist'] = 'Nem használható szavak egyedi felsorolása';
$string['blockediplist'] = 'Blokkolt IP-lista';
$string['blockinstances'] = 'Előfordulások';
$string['blockmultiple'] = 'Többszöri';
$string['blockprotect'] = 'Törlés elleni védelem';
$string['blockprotect_help'] = 'A kiválasztott blokkpéldányok portálszinten törlés ellen védve lesznek. Ez alapvetően a navigációs és a beállítási blokkokat védi, amelyek visszaállítása véletlen törlés esetén igen körülményes lehet.';
$string['blocksettings'] = 'Blokkok kezelése';
$string['blockunprotect'] = 'Védelem feloldása';
$string['bloglevel'] = 'Blogok láthatósága';
$string['bloglevelupgrade'] = 'Blog láthatóságának frissítése';
$string['bloglevelupgradedescription'] = '<p>A portált nemrégen Moodle 2.0-ra frissítették.</p>
<p>A blog láthatósága a 2.0 változatban egyszerűsödött, de az Ön portálja továbbra is régi típusú láthatóságot használ. Ahhoz, hogy portálján megőrizze a blogüzenetek kurzusalapú vagy csoportalapú láthatóságát, le kell futtatnia az alábbi frissítési kódot, mellyel minden blogüzenettel rendelkező felhasználót tartalmazó kurzusában létrejön egy külön blogszerű fórum, melybe ezek a blogüzenetek bemásolódnak.</p>
<p>Ezt követően portálszinten a blogokat a rendszer kikapcsolja. A folyamat során a blogüzenetek nem törlődnek.</p>
<p>A kód lefuttatásához látogasson el a <a href="{$a->fixurl}">blogszintű frissítés oldalára</a>.</p>';
$string['bloglevelupgradeinfo'] = 'A blog láthatósága a 2.0 változatban egyszerűsödött, de az Ön portálja továbbra is régi típusú láthatóságot használ. Ahhoz, hogy portálján megőrizze a blogüzenetek kurzusalapú vagy csoportalapú láthatóságát, le kell futtatnia az alábbi frissítési kódot, mellyel minden blogüzenettel rendelkező felhasználót tartalmazó kurzusában létrejön egy külön blogszerű fórum, melybe ezek a blogüzenetek bemásolódnak.
Ezt követően portálszinten a blogokat a rendszer kikapcsolja. A folyamat során a blogüzenetek nem törlődnek.';
$string['bloglevelupgradenotice'] = 'Az Ön portálja továbbra is régi típusú láthatóságot használ, ajánlott a <a href="bloglevelupgrade.php">blog láthatóságát frissíteni</a>.';
$string['bloglevelupgradeprogress'] = 'Átalakítás folyamatban: {$a->userscount} felhasználó értékelve, {$a->blogcount} üzenet átalakítva.';
$string['bookmarkadded'] = 'Könyvjelző hozzáadva.';
$string['bookmarkalreadyexists'] = 'Ezt az oldalt már megjelölte.';
$string['bookmarkdeleted'] = 'Könyvjelző törölve.';
$string['bookmarkthispage'] = 'Oldal megjelölése';
$string['cachejs'] = 'Javascript gyorsítótárban futtatása';
$string['cachejs_help'] = 'A javascript gyorsítótárban futtatása és tömörítése nagyban javítja az oldalak betöltését, használata éles portálokon mindenképpen ajánlatos. Fejlesztők inkább kerülik a funkció használatát.';
$string['cachetext'] = 'Szöveggyorsítótár időtartama';
$string['cachetype'] = 'Gyorsítótár típusa';
$string['calendarexportsalt'] = 'Naptárexportáló rejtjelbitek';
$string['calendarsettings'] = 'Naptár';
$string['calendar_weekend'] = 'Hétvége';
$string['cannotdeletemissingqtype'] = 'A hiányzó kérdéstípus nem törölhető. A rendszernek szüksége van rá.';
$string['cannotdeletemodfilter'] = 'A(z) \'{$a->filter}\' nem távolítható el, mert a(z) \'{$a->module}\' modul része.';
$string['cannotdeleteqtypeinuse'] = 'A \'{$a}\' kérdéstípus nem törölhető. A kérdésbankban vannak ilyen típusú kérdések.';
$string['cannotdeleteqtypeneeded'] = 'A \'{$a}\' kérdéstípus nem törölhető. Léteznek egyéb, ezzel összefüggő telepített kérdéstípusok.';
$string['cfgwwwrootslashwarning'] = 'A $CFG->wwwroot hibásan van megadva config.php fájljában. Nem egyezik az ezen oldal elérésére használt URL-lel. Javítsa ki, ellenkező esetben furcsa hibákkal találja szemben magát, pl.:  <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'A config.php állományban hibásan van megadva a $CFG->wwwroot. Nem egyezik az oldal elérésére használt URL-lel. Ha nem javítja ki, váratlan hibákba fog ütközni, pl. <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'módosítás';
$string['changesitelang'] = 'Portál nyelvének módosítása';
$string['checkboxno'] = 'Nem';
$string['checkboxyes'] = 'Igen';
$string['choosefiletoedit'] = 'Válassza ki a szerkesztendő állományt';
$string['clamfailureonupload'] = 'A clam vírusirtó hibája esetén';
$string['cleanup'] = 'Tisztítás';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'i';
$string['cliincorrectvalueerror'] = 'Hiba, "{$a->value}" értéke "{$a->option}" esetén hibás';
$string['cliincorrectvalueretry'] = 'Hibás érték, próbálja újra.';
$string['clistatusdisabled'] = 'Állapot: kikapcsolva';
$string['clistatusenabled'] = 'Állapot: bekapcsolva';
$string['clitypevalue'] = 'érték beírása';
$string['clitypevaluedefault'] = 'érték beírása, Enter esetén alapérték ({$a}) használata';
$string['cliunknowoption'] = 'Ismeretlen paraméter: {$a}. Használja a --help paramétert.';
$string['cliupgradefinished'] = 'A parancssori frissítés sikerült.';
$string['cliyesnoprompt'] = 'írjon be i-t (igen) vagy n-t (nem)';
$string['commentsperpage'] = 'Oldalanként megjelenő megjegyzések száma';
$string['commonfiltersettings'] = 'Általános szűrőbeállítások';
$string['commonsettings'] = 'Általános beállítások';
$string['componentinstalled'] = 'Összetevő telepítve';
$string['computedfromlogs'] = 'A(z) {$a} óta gyűjtött naplókból kiszámítva.';
$string['condifmodeditdefaults'] = 'Az itt megadott értékek új tevékenység létrehozásakor a tevékenységbeállítás űrlapján alapértékként jelennek meg. Itt beállíthatja azt is, hogy mely tevékenységbeállítások legyenek különlegesek.';
$string['confeditorhidebuttons'] = 'Válassza ki a HTML-szerkesztőben elrejtendő gombokat.';
$string['configallcountrycodes'] = 'Ez a különféle helyeken, például a felhasználói profilban kiválasztható országok listája. Ha üresen hagyja (alaphelyzet), akkor az angol nyelvi alapcsomagban lévő felsorolás jelenik meg. Ez az ISO 3166-1 szerinti lista. Ellenkező esetben meghatározhat egy sor vesszővel elválasztott kódot, pl. GB,FR,ES. Ha új, nem szabvány szerinti kódokat ad meg, azokat hozzá kell adnia mind a nyelvi csomagjának megfelelő, mind az \'en\' countries.php állományhoz.';
$string['configallowassign'] = 'A bal oldalon lévő szerepekkel rendelkezők részére engedélyezheti egyes oszlopszerepek másokhoz való hozzárendelését';
$string['configallowblockstodock'] = 'Bekapcsolása és a kiválasztott stílusok általi támogatása esetén a felhasználók speciális tárolóba is áthelyezhetnek blokkokat.';
$string['configallowcategorythemes'] = 'Bekapcsolása esetén a stílusokat kategóriaszinten állíthatja be. Ez minden lentebbi kategóriára és kurzusra érvényes lesz, hacsak azokhoz nincs külön stílus beállítva. FIGYELEM: A kategóriastílusok bekapcsolása befolyásolhatja a teljesítményt!';
$string['configallowcoursethemes'] = 'Ennek bekapcsolásakor a kurzusok önmaguk állíthatják be a stílusokat. A kurzusstílusok minden egyéb kiválasztott stílust (portál-, felhasználó- vagy eseménystílust) felülírnak.';
$string['configallowemailaddresses'] = 'Ha minden e-mail címet konkrét doménekre kíván korlátozni, szóközökkel elválasztva sorolja fel őket itt. Minden egyéb domént a rendszer elutasít. Aldomének engedélyezéséhez a domén neve elé írjon  \'.\' karaktert, pl. <strong>tok.u-szeged.hu .u-szeged.hu.</strong>';
$string['configallowobjectembed'] = 'Alapvető biztonsági intézkedésként a felhasználók nem építhetnek be multimédiát (pl. flash-t) a HTML-be EMBED- és OBJECT-címkékkel (jóllehet, erre módot ad a médiaprogramkódok biztonságos szűrője). Ezen címkék engedélyezéséhez az opciót be kell kapcsolni.';
$string['configallowoverride'] = 'A bal oldalon lévő szerepekkel rendelkezők részére engedélyezheti egyes oszlopszerepek felülírását';
$string['configallowoverride2'] = 'Válassza ki, mely szerep(ek)et írhatnak felül a bal oszlopban lévő egyes szerepek.<br />Ne feledje, hogy ezek a beállítások csak azon felhasználókra érvényesek, akiknél a moodle/role:override vagy a moodle/role:safeoverride képesség engedélyezve van.';
$string['configallowswitch'] = 'Válassza ki, a meglévő szerepeik alapján a felhasználók mely szerepekre válthatnak át. Az átváltáshoz a tábla bejegyzésén túl a felhasználónak moodle/role:switchroles képességgel is rendelkeznie kell.<br />Ne feledje, hogy a szerepváltás csak akkor lehetséges, ha a felhasználó a  moodle/course:view képességgel rendelkezik, de nem rendelkezik moodle/site:doanything képességgel, ezért a tábla néhány oszlopa ki van kapcsolva.';
$string['configallowthemechangeonurl'] = 'Ha ezt a beállítást bekapcsolja, akkor a stílust bármely Moodle URL esetén módosíthatja a theme={themename} hozzáadásával.';
$string['configallowuserblockhiding'] = 'A felhasználók az egész portálon elrejthetik/megjeleníthetik az oldalsó blokkokat? Ez a funkció javascript és sütik használatával emlékezik az egyes becsukható blokkok állapotára, és csak a felhasználó saját nézetére van hatással.';
$string['configallowusermailcharset'] = 'Bekapcsolásakor a felhasználó saját karakterkészletet állíthat be az e-mailhez.';
$string['configallowuserswitchrolestheycantassign'] = 'Alaphelyzetben a felhasználók a moodle/role:assign segítségével váltanak szerepet. Ennek bekapcsolása esetén ez a követelmény elhárul és a szerepek elérhetővé válnak a "Szerep átváltása erre..." lenyíló menüből, melyet csak a "Szerepek hozzárendelésének engedélyezése" táblázat beállításai határoznak meg. Ajánlatos elkerülni, hogy a "Szerepek hozzárendelésének engedélyezése" táblázat beállításai alapján a felhasználók meglévő szerepüknél szélesebb hatókörű szerepre váltsanak át.';
$string['configallowuserthemes'] = 'Ennek bekapcsolásakor a felhasználók beállíthatják saját stílusukat. A felhasználói stílusok felülírják a portálstílusokat (de a kurzusstílusokat nem).';
$string['configallusersaresitestudents'] = 'A portál kezdőoldalán szereplő tevékenységekhez MINDEN felhasználó tanulónak tekintendő? Ha válasza "Igen", akkor minden jóváhagyott felhasználó tanulóként részt vehet ezen tevékenységekben. Ha válasza "Nem", akkor csak a legalább egy kurzusban már részt vevő felhasználók  kapcsolódhatnak be a kezdőoldalon szereplő tevékenységekbe. A kezdőoldalon szereplő tevékenységeket illetően csak a rendszergazdák és a külön kijelölt tanárok vehetnek részt tanári minőségben.';
$string['configauthenticationplugins'] = 'Válassza ki a használni kívánt hitelesítő segédprogramokat és rendezze el őket végrehajtási sorrend szerint.';
$string['configautolang'] = 'Kikapcsolt portálbeállítás esetén az alapbeállítás szerinti nyelvet állapítsa meg a böngésző beállítása alapján.';
$string['configautologinguests'] = 'A látogatók automatikusan vendégként lépjenek-e be, ha valamely kurzusba vendégként jelentkeznek be?';
$string['configbloglevel'] = 'Ezzel a beállítással korlátozhatja, mely felhasználói blogokat lehet megtekinteni ezen a portálon. Ezzel a blog MEGTEKINTÉSÉNEK tartalmát szabja meg, nem annak feladóját vagy a blogüzenetek típusait. A blogokat teljes egészében kikapcsolhatja, ha egyáltalán nem akarja őket használni.';
$string['configcachetext'] = 'Nagyobb portálokon vagy szövegszűrőt használó portálokon ez a beállítás ugyancsak felgyorsíthatja az eseményeket. A szövegek másolata az itt megadott ideig feldolgozott formában megőrződik. Ennek az értéknek túl kicsire állítása valamelyest lassíthatja a programot, túl nagyra állítva viszont a szövegek (például új hivatkozásokkal való) frissítése sokáig tarthat.';
$string['configcachetype'] = 'Válasszon ki egy gyorsítótártípust a Moodle számára. Ezzel csak beállítja a gyorsítótárat. Ne feledje az rcache-t be is kapcsolni ahhoz, hogy a gyorsítótárat használatba tudja venni. Csak akkor vegye igénybe, ha csökkentenie kell az adatbázis leterhelését -- ellenkező esetben ez a Moodle lassabb működését fogja eredményezni. Közepes forgalmú portálokon előnyös lehet az \'internal\' használata. Egyetlen, eAcceleratorral vagy Turckmmcache-sel rendelkező és bekapcsolt osztott memóriával telepített  webszerver esetén ajánlatos kipróbálni az \'eaccelerator\' opciót. Többszerveres kialakítás, egy vagy több futó memóriában gyorsított démon és memóriában gyorsított PHP-bővítmény esetén válassza a \'memcached\' opciót és állítsa be az alábbi memóriában gyorsított lehetőségeket. Megjegyzés: ellenőrizze a terhelés alatti teljesítményt és végezze el az ennek megfelelő finomhangolást -- a gyorsítótárak miatt portálja lelassulhat. Nagy forgalmat bonyolító portálokon az eAccelerator és a memcached használata lehet a legelőnyösebb, ugyanakkor nagyobb mértékben veszi igénybe a központi feldolgozó egységet a webszerveren.';
$string['configcalendarexportsalt'] = 'Ez a véletlenszerűen előálló szöveg a naptárexportáláshoz használt hitelesítő jelek biztonságosságát fokozza. Ha ezeket a rejtjelbiteket módosítja, minden jelenlegi jel érvénytelenné válik.';
$string['configclamactlikevirus'] = 'Állományok vírusosként kezelése';
$string['configclamdonothing'] = 'Állományok vírusmentesként kezelése';
$string['configclamfailureonupload'] = 'Ha a vírusirtó úgy van beállítva, hogy ellenőrizze a feltöltött állományokat, de rosszul van konfigurálva vagy valamilyen ismeretlen okból nem fut le, mi legyen a teendő? Ha a beállítás \'Állományok vírusosként kezelése\', akkor vagy karanténba kerülnek, vagy a rendszer törli őket. Ha a beállítás \'Állományok vírusmentesként kezelése\', akkor az állományok szokásos módon a célkönyvtárba kerülnek. Mindenesetre a rendszergazdák figyelmeztetést kapnak arról, hogy a vírusirtó nem működött. Ha a beállítás \'Állományok vírusosként kezelése\', a vírusirtó pedig valamilyen okból nem fut le (rendszerint azért, mert rossz útvonalat adott meg hozzá), akkor MINDEN feltöltött állomány vagy karanténba kerül, vagy a rendszer törli őket. Ezzel a beállítással legyen óvatos!';
$string['configconvertformat'] = 'Ha elérhető a <i>latex</i>, a <i>dvips</i> és a <i>convert</i>, akkor a képek a megadott formátum felhasználásával jönnek létre. Ellenkező esetben a rendszer mimeTeX-et használ és GIF-képeket hoz létre.';
$string['configcookiehttponly'] = 'Bekapcsolja a PHP 5.2.0 új funkcióját – a böngészők csak valódi http-kérésekkel küldenek sütit, a sütiket szkriptnyelvek nem érhetik el. Ezt nem minden böngésző támogatja, emellett előfordulhat, hogy a jelenlegi kóddal nem teljesen kompatibilis. Célszerű lehet bizonyos XSS-támadásokat megelőzni.';
$string['configcookiesecure'] = 'Ha a szerver csak https-kapcsolatot fogad el, akkor ajánlott bekapcsolni a biztonságos sütik küldését. Bekapcsolása esetén ügyeljen arra, hogy a webszerver ne fogadjon el http://-t, vagy állítson be állandó https://-címre való átirányítást. Ha a <em>wwwroot</em> címe nem https:// kezdetű, akkor ez a beállítás automatikusan kikapcsol.';
$string['configcountry'] = 'Ha itt egy ország van megadva, akkor az új felhasználók esetén alaphelyzetben ez az ország lesz a kiválasztott ország. A választás előírásához hagyja ezt a helyet üresen.';
$string['configcourserequestnotify'] = 'Adja meg az új kurzus kérésekor értesítendő felhasználó felhasználói nevét.';
$string['configcourserequestnotify2'] = 'Kurzuskérés esetén értesített felhasználók. A listán csak a kurzuskérést jóváhagyó felhasználók jelennek meg.';
$string['configcoursesperpage'] = 'Kurzusok oldalankénti számának megadása a kurzuslista megjelenítéséhez.';
$string['configcronclionly'] = 'Beállítása esetén a cron-kód csak a parancssorból futtatható, a webről nem. Felülírja a cron alább beállított jelszavát.';
$string['configcronremotepassword'] = 'Ez azt jelenti, hogy a cron.php kód böngészőből nem futtatható az alábbi formájú URL:<pre>      http://site.example.com/admin/cron.php?password=opensesame </pre> segítségével megadott jelszó nélkül. Ha üresen hagyja, nem lesz szükség jelszóra.';
$string['configcurlcache'] = 'A cURL gyorsítótár működési ideje másodpercekben.';
$string['configcustommenuitems'] = 'Itt egy stílusok által megjelenítendő egyéni menüt állíthat be. Minden sor valamilyen menüszöveget,  (választhatóan) egy URL-ugrópontot és  (választhatóan) egy elemleírást tartalmaz, melyeket függőleges vonalak választanak el egymástól. Kötőjelekkel struktúrát adhat meg. Például: <pre> Moodle-közösség|http://moodle.org -Moodle ingyenes támogatása|http://moodle.org/support -Moodle-fejlesztés|http://moodle.org/development --Moodle-hibakövetés|http://tracker.moodle.org --Moodle-dokumentumok|http://docs.moodle.org -Moodle-hírek|http://moodle.org/news Moodle Társaság -Moodle kereskedelmi üzemeltetés|http://moodle.com/hosting -Moodle kereskedelmi támogatás|http://moodle.com/support </pre>';
$string['configdbsessions'] = 'Bekapcsolásakor ez a beállítás a pillanatnyi eseményekről szóló adatokat adatbázisban tárolja. Ez különösen nagy vagy forgalmas portálok, illetve összekapcsolt szerveren működő portálok esetén hasznos. A legtöbb portál esetén kikapcsolva hagyható, ekkor a szerver lemezét fogja használni. Ne feledje, hogy a beállítás módosítása esetén minden belépett felhasználót a rendszer kiléptet (Önt is beleértve). Ha MySQL-t használ, a my.cnf-ben (vagy my.ini-ben) a  \'max_allowed_packet\' legalább 4 MB legyen.';
$string['configdebug'] = 'Bekapcsolt állapotban a PHP hibajelentése bővebb lesz, azaz több figyelmeztetést nyomtat ki. Ez csak a fejlesztőknek hasznos.';
$string['configdebugdisplay'] = 'Bekapcsolása esetén a hibajelentések a HTML-oldalra kerülnek. Noha ez egy praktikus megoldás, általában véve tönkreteszi az XHTML-t, a JS-t, a sütiket és a HTTP-fejléceket. Kikapcsolása esetén a hibajelentéseket a szervernaplóba küldi, így jobb hibaelhárítást tesz lehetővé. A PHP error_log beállítása határozza meg, hogy ez melyik naplóba kerül.';
$string['configdebugpageinfo'] = 'Ha bekapcsolja, az oldal láblécén megjelennek az oldallal kapcsolatos információk.';
$string['configdebugsmtp'] = 'Bekapcsolja szöveges hibaelhárítási információk megadását e-mail üzenetek SMTP-szerverre küldése során.';
$string['configdebugstringids'] = 'Ez a fordítókat segíti. Megmutatja a kiírt szöveg mellett a nyelvi állományt és a szöveg azonosítóját. (A beállítás módosítása csak az oldal következő betöltésétől lép érvénybe.)';
$string['configdebugvalidators'] = 'Ha bekapcsolja, az oldal láblécén ugrópontok jelennek meg a külső validálóhoz. Előfordulhat, hogy új felhasználót kell létrehoznia <em>w3cvalidator</em> névvel és engedélyeznie kell a vendégként való hozzáférést.';
$string['configdefaultallowedmodules'] = 'A fenti kategóriába tartozó kurzusok közül melyik modulokat kívánja alapbeállítás szerint engedélyezni <strong>a kurzus létrehozásakor</strong>?';
$string['configdefaulthomepage'] = 'Ez határozza meg a belépett felhasználók kezdőoldalát';
$string['configdefaultrequestcategory'] = 'A felhasználók által igényelt kurzusok automatikusan ebbe a kategóriába kerülnek.';
$string['configdefaultrequestedcategory'] = 'Alapkategória az igényelt kurzusok elhelyezésére, amennyiben megtörténik jóváhagyásuk.';
$string['configdefaultuserroleid'] = 'Minden belépett felhasználó megkapja az itt megadott szerephez tartozó portálszintű jogosultságokat, az esetleges EGYÉB szerepei mellett. Az alapbeállítás a hitelesített felhasználói szerep. Ne feledje, hogy ez nem ütközik többi szerepükkel, csak biztosítja, hogy minden felhasználó rendelkezzen olyan lehetőségekkel, amelyek kurzusszinten nem rendelhetők hozzá (pl. blogüzeneteket helyezhetnek el, saját naptárukat kezelhetik stb.).';
$string['configdeleteincompleteusers'] = 'Ezen idő eltelte után minden hiányosan beállított fiókot töröl a rendszer.';
$string['configdeleteunconfirmed'] = 'Ha az e-mail hitelesítéssel működik, ez lesz az az idő, amely alatt a felhasználók által adott választ a rendszer elfogadja. Ezen időszak elteltével a korábbi, meg nem erősített felhasználói azonosítókat törli a rendszer.';
$string['configdenyemailaddresses'] = 'Ha nem kíván konkrét doménekről e-mailt fogadni, ugyanúgy sorolja fel őket itt. Minden egyéb domént a rendszer elfogad. Aldomének elutasításához a domént \'.\'-vel adja meg. Pl. hotmail.com yahoo.co.uk.';
$string['configdigestmailtime'] = 'Azok, akik összesítve kérik az e-mailek kézbesítését, ezt naponta fogják megkapni. Ezzel állítható be, hogy a napi e-mail elküldése hány órakor történjék (az adott óra utáni első cron fogja elküldeni).';
$string['configdisableuserimages'] = 'Felhasználói profilkép módosításának tiltása felhasználók számára.';
$string['configdisplayloginfailures'] = 'Ez tájékoztatja az adott felhasználókat a korábbi sikertelen belépésekről.';
$string['configdocroot'] = 'A Moodle Docs útvonalát adja meg. Megváltoztathatja, ha saját, testre szabott online dokumentációt kíván használni. Ha viszont ekként cselekszik, ügyeljen arra, hogy dokumentációjában az útvonalak ugyanazt a formátumot kövessék, mint a http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Ennek bekapcsolásakor a Moodle Docs ugrópontjai új ablakban jelennek meg.';
$string['configeditordictionary'] = 'A rendszer ezt az értéket használja, ha az aspell nem rendelkezik a felhasználó nyelve szerinti szótárral.';
$string['configeditorfontlist'] = 'Válassza ki a szerkesztő lenyíló listáján megjelenítendő betűfajtákat.';
$string['configemailchangeconfirmation'] = 'E-mailben való megerősítést ír elő, ha a felhasználók profiljukban módosítják e-mail címüket.';
$string['configenableajax'] = 'Ezzel a beállítással szabályozhatja az AJAX (javascriptet használó továbbfejlesztett kliens/szerver interfészek) használatát a portál egészén.  Ezen beállítás esetén a felhasználók továbbra is választhatnak profiljaik közül; ellenkező esetben az AJAX mindenki számára kikapcsolt állapotba kerül.';
$string['configenablecalendarexport'] = 'Exportálás vagy naptárak előjegyzésének engedélyezése.';
$string['configenablecomments'] = 'Megjegyzések engedélyezése';
$string['configenablecourserequests'] = 'Ezzel bármely felhasználó kérheti egy kurzus létrehozását.';
$string['configenableglobalsearch'] = 'Ezzel a beállítással globális szövegkeresést végezhet a tananyagokban és a tevékenységekben, a PHP 4-gyel nem kompatibilis.';
$string['configenablegroupmembersonly'] = 'Bekapcsolása esetén a tevékenységek elérése csoporttagokra korlátozható. Ezzel megnőhet a szerver leterhelése. Ráadásul az osztályozó napló kategóriáit úgy kell beállítani, hogy a tevékenységeket a csoporton kívüliek ne láthassák.';
$string['configenablehtmlpurifier'] = 'A nem megbízható szöveg tisztázására a KSES helyett használja a HTML Purifiert. A HTML Purifier fejlesztése folyamatos és biztonságosabb, ugyanakkor több erőforrást köt le. Az eredményül kapott HTML-kód megjelenítése némileg eltérő lehet. Az embed- és object-címkéket nem lehet bekapcsolni, a MathML és a régi lang címkék használatát nem támogatja.';
$string['configenablerssfeeds'] = 'Ezzel az egész portálra bekapcsolja az RSS-híreket. A változások megjelenítéséhez az egyes modulokban is be kell kapcsolni az RSS-híreket - lásd a Modulok pontot a Portáladminisztráció beállításai alatt.';
$string['configenablerssfeedsdisabled'] = 'Nem elérhető, mert az RSS-hírek az egész portálon ki vannak kapcsolva. Bekapcsolásukhoz térjen át a Portáladminisztráció alatt a Változók beállítása pontra.';
$string['configenablerssfeedsdisabled2'] = 'Az RSS-hírek szerverszinten ki vannak kapcsolva.';
$string['configenablesafebrowserintegration'] = 'Ezzel a tesztbeállítási űrlapon a böngésző biztonsági mezőjéhez hozzáadhatja a \'Biztonságos vizsgáztatási böngésző előírása\' opciót. További információk: http://www.safeexambrowser.org/ .';
$string['configenablestats'] = 'Ha ezt bekapcsolja, a Moodle cronjob programja feldolgozza a naplókat és statisztikát állít elő. A portál forgalmától függően ez sok időt vehet igénybe. Használata esetén az egyes kurzusokról vagy az egész portálról érdekes grafikonokat és statisztikákat tekinthet meg.';
$string['configenabletrusttext'] = 'Alaphelyzetben a Moodle a felhasználóktól érkező szövegeket mindig gondosan megtisztítja a biztonságot veszélyeztető esetleges hibás kódtól, médiafájloktól stb. A megbízható tartalom rendszerével a megbízhatónak tekintett felhasználóknak engedélyezheti ezen fejlettebb funkciók ütközésmentes használatát. A rendszer bekapcsolásához először jelölje be ezt a beállítást, majd rendeljen megbízható tartalom szerinti engedélyt egy konkrét Moodle-szerephez.  Az ilyen felhasználók által létrehozott vagy feltöltött szövegek megbízható jelölést kapnak és megjelenítésük előtt nem esnek át a tisztítási folyamaton.';
$string['configenablewebservices'] = 'A webszolgáltatások lehetővé teszik egyéb rendszerek számára, hogy belépjenek ezen Moodle alá és műveleteket hajtsanak végre.';
$string['configenablewsdocumentation'] = 'Bekapcsolása esetén a webszolgáltatások dokumentációja automatikusan előállítódik. A felhasználó saját dokumentációját biztonsági kulcsainak {$a} oldalán érheti el. Csak a bekapcsolt protokollok dokumentációját jeleníti meg.';
$string['configerrorlevel'] = 'Válassza ki, hány PHP-figyelmeztetés jelenjen meg. A Szokásos kiválasztása rendszerint a legjobb megoldás.';
$string['configexcludeoldflashclients'] = 'Az Adobe Flash segédprogram egyes változatai köztudottan ki vannak téve rosszindulatú támadásoknak. Itt állíthatja be a minimális támogatott verziószámot. A Moodle ennél korábbi verzióval rendelkező felhasználóknak nem jelenít meg Flash tartalmakat. Helyettük tájékoztatást kapnak a frissítés módjáról. Ha nem kíván semmilyen ellenőrzést, hagyja üresen.';
$string['configextendedusernamechars'] = 'Ezt bekapcsolva a tanulók bármilyen karaktert használhatnak felhasználónevükben (ez nincs befolyással konkrét nevükre!). Az alapbeállítás \'Nem\', amely esetén a felhasználónév csak betűket, számokat, aláhúzást (_), kötőjelet (-), pontot (.) vagy kukacot (@) tartalmazhat.';
$string['configextramemorylimit'] = 'Egyes programkódoknak (pl. keresés, mentés/helyreállítás, cron) nagyobb memóriára van szükségük. Nagy portál esetén állítson be magasabb értékeket.';
$string['configextrauserselectorfields'] = 'Felhasználók kiválasztása során, például szerepek hozzárendelése vagy felhasználók csoporthoz való hozzáadása közben ezek a mezők a teljes néven túl szintén megjelennek, és belekerülnek a keresésekbe. Biztonsági okokból nem ajánlatos a felhasználók nevének megjelenítése.';
$string['configfilterall'] = 'Minden szövegsor szűrése, beleértve a fejléceket, a címeket, a navigációs sávot stb. Bekapcsolása akkor hasznos, ha a multilang szűrőt használja, egyéb esetben csak növeli a portál leterhelését.';
$string['configfiltermatchoneperpage'] = 'Automatikusan kapcsoló szűrők esetén csak az oldalon a szöveg első előfordulásához áll elő kapcsolat. Az összes többit a rendszer figyelmen kívül hagyja.';
$string['configfiltermatchonepertext'] = 'Automatikusan kapcsoló szűrők esetén az oldalon csak az egyes szövegek (pl. forrás, blokk) első előfordulásához áll elő kapcsolat. Az összes többit a rendszer figyelmen kívül hagyja. Ezt a beállítást figyelmen kívül hagyja, ha a fenti \'Oldalanként egy...\' beállítás <i>igen</i>.';
$string['configfilteruploadedfiles'] = 'Minden feltöltött HTML- és szöveges állományt, csak a feltöltött HTML-állományokat, illetve egyetlen állományt se dolgozzon fel a szűrőkkel, mielőtt megjelennének.';
$string['configforcelogin'] = 'A portál ckezdőoldalát és a kurzuslistákat (de nem a kurzusokat) bárki megtekintheti anélkül, hogy belépne a portálra. Ha azt szeretné, hogy a portálra látogatók ELŐSZÖR lépjenek be, ezt a beállítást be kell kapcsolni.';
$string['configforceloginforprofiles'] = 'Ezzel a beállítással érhető el, hogy a bejelentkezőknek ne vendégként, hanem valódi felhasználónévvel kelljen belépni, mielőtt valamely felhasználói profilt megtekintenének. Ha ezt a beállítást kikapcsolta, előfordulhat, hogy egyes felhasználók hirdetést (levélszemetet) vagy egyéb, oda nem való tartalmat tesznek közzé profiljukban, amely így az egész világ számára láthatóvá válik.';
$string['configframename'] = 'Ha a Moodle-t keretben helyezi el, itt adja meg a keret nevét. Ellenkező esetben ennek \'_top\' értéket kell adni.';
$string['configfrontpage'] = 'Kiválasztása esetén a kiválasztott elemek megjelennek a portál kezdőoldalán.';
$string['configfrontpageloggedin'] = 'A fent kiválasztott elemek megjelennek a portál kezdőoldalán, ha egy felhasználó bejelentkezik.';
$string['configfullnamedisplay'] = 'Itt adható meg a megjelenő nevek alakja. Az egynyelvű portálok esetén a legmegfelelőbb beállítás az alapértelmezett \'Vezetéknév + Keresztnév\', de dönthet úgy, hogy a vezetéknevek egyáltalán ne jelenjenek meg, vagy dönthet erről az adott nyelvi csomag alapján is (egyes nyelvekben az elrendezés ettől eltérő lehet).';
$string['configgdversion'] = 'Itt kell megadni a telepített GD változatát. A rendszer az alapértékként megadott változatot észleli. Ne módosítsa, ha nem teljesen biztos annak következményében!';
$string['configgeoipfile'] = 'A GeoIP City bináris adatállomány helye. Az állomány nem része a Moodle-csomagnak, külön kell beszerezni a <a href="http://www.maxmind.com/">MaxMind</a>-tól. Megvásárolhatja a kereskedelmi változatot vagy használhatja az ingyeneset.<br />Mindössze le kell töltenie a <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> állományt és ki kell csomagolnia szervere "{$a}" könyvtárába.';
$string['configgetremoteaddrconf'] = 'Ha szervere egy fordított gyorsítótár mögött van, ezzel a beállítással megadhatja, mely HTTP-fejlécek tartalmazhatják a megbízható távoli IP-címet. A fejlécek beolvasása sorrendben történik, kezdve az első elérhetővel.';
$string['configgooglemapkey'] = 'Speciális kódot kell megadnia, ha a Google Maps segítségével kíván IP-címeket megjeleníteni. A kód ingyenesen beszerezhető a <a href="http://code.google.com/apis/maps/signup.html" >http://code.google.com/apis/maps/signup.html</a> címről.<br />Portáljának URL-je: {$a}';
$string['configgradebookroles'] = 'Ezzel a beállítással szabályozhatja, ki szerepeljen az osztályozó naplóban.  A felhasználóknak adott kurzusban legalább ezen szerepek egyikével kell rendelkezni ahhoz, hogy megjelenjenek a kurzus osztályozó naplójában.';
$string['configgradeexport'] = 'Válassza ki, mely formátumú osztályozó naplók lesznek a pontok exportálására használt elsődleges módszerek. A kiválasztott segédprogramok minden jegy esetén a \'last exported\' mezőt fogják beállítani és használni. Az exportált rekordok azonosítója ennek alapján lehet például \'new\' vagy \'updated\'. Ha bizonytalan, hagyjon mindent bejelöletlenül.';
$string['confighiddenuserfields'] = 'Válassza ki, milyen információt tartalmazó mezőket kíván elrejteni a tanárokon/rendszergazdákon kívül minden egyéb felhasználó elől. Ezzel növelheti a tanulók adatainak titkosságát. A CTRL-billentyű lenyomásával egyszerre több mezőt is kiválaszthat.';
$string['configidnumber'] = 'Ezzel az opcióval adható meg, hogy (a) a felhasználóktól kell-e egyáltalán azonosítószámot kérni, (b) a felhasználóktól kér a rendszer azonosítószámot, de üresen hagyhatják, illetve (c) a felhasználóktól a rendszer azonosítószámot kér, ők pedig ezt nem hagyhatják üresen. Ha van megadva, akkor a felhasználói azonosítószám megjelenik a profiljukban.';
$string['configintcachemax'] = 'Csak belső gyorsítótárhoz. A gyorsítótárba kerülő rekordok maximális száma. Ajánlott érték: 50. A memória igénybevételének csökkentéséhez adjon meg kisebb számot.';
$string['configintro'] = 'Ezen az oldalon adhatók meg olyan beállítási változók, amelyekkel a Moodle megfelelően működhet az adott szerveren. Nem szükséges a beállítással sokat vesződni, az alapbeállítások rendszerint megfelelnek, emellett bármikor vissza lehet térni erre az oldalra és módosítani lehet a beállításokon.';
$string['configintroadmin'] = 'Ezen az oldalon kell megadni a fő rendszergazdát, aki ezt követően az egész portál fölött rendelkezik majd. Ügyeljen arra, hogy a felhasználónév és a jelszó biztonságos, az e-mail cím pedig valóságos legyen. Később további rendszergazdákat adhat meg.';
$string['configintrosite'] = 'Ezen az oldalon állíthatja be a kezdőoldalt és az új portál nevét. Később bármikor visszatérhet ide és módosíthatja a beállításokat a honlap portáladminisztrációs menüiről.';
$string['configintrotimezones'] = 'Ez az oldal új információkat keres a világ időzónáiról (beleértve a nyári időszámítással kapcsolatos szabályokat), és ezen információk alapján frissíti a helyi adatbázist. A helyek ellenőrzése {$a} alapján történik. Az eljárás biztonságosnak mondható és nem szakítja meg a szokásos telepítést. Most kívánja frissíteni az időzónákat?';
$string['configiplookup'] = 'Ha a naplózásokhoz hasonlóan egy IP-címre kattint (pl. 34.12.222.93), egy térkép jelenik meg, amely megbecsüli, hol található az adott IP.  Különféle segédprogramok közül választhat, melyek más-más előnyökkel és hátrányokkal rendelkeznek.';
$string['configjabberhost'] = 'A jabber-üzenetekről szóló értesítések elküldéséhez csatlakoztatandó szerver';
$string['configjabberpassword'] = 'A jabber-szerverhez csatlakozásra használt jelszó';
$string['configjabberport'] = 'A jabber-szerverhez csatlakozásra használt port';
$string['configjabberserver'] = 'Az XMPP-gazdagép azonosítója (üres maradhat, ha megegyezik a jabber-gazdagéppel)';
$string['configjabberusername'] = 'A jabber-szerverhez csatlakozásra használt felhasználónév';
$string['configkeeptagnamecase'] = 'Jelölje be, ha meg szeretné tartani a felhasználók által eredetileg megadott kis- és nagybetűket.';
$string['configlang'] = 'Válasszon egy alapértelmezett nyelvet a teljes portál számára. A felhasználók ezt a beállítást a nyelvi menüben vagy személyes profiljukban felülírhatják.';
$string['configlangdir'] = 'A legtöbb nyelv balról jobbra ír, de némelyek, például az arab és a héber írás, jobbról halad balra.';
$string['configlanglist'] = 'Ha ezt üresen hagyja, a felhasználók a Moodle adott telepítéséből elérhető bármely nyelvet választhatják. A nyelvi menüt lerövidítheti, ha vesszővel elválasztva itt felsorolja a kívánt nyelvek kódjait. Például:  en,es_es,fr,it';
$string['configlangmenu'] = 'Itt adja meg, hogy megjelenjen-e az általános nyelvi menü a honlapon, a belépési oldalon stb. Ez nem korlátozza a felhasználókat abban, hogy a nekik megfelelő nyelvet saját profiljukban beállítsák.';
$string['configlangstringcache'] = 'Az adatkönyvtárban az összes nyelvi szöveget lefordított fájlokká alakítja a gyorsítótárhoz. Ha a Moodle-t fordítja vagy annak forráskódját módosítja, ezt kikapcsolhatja. Ellenkező esetben a jobb teljesítmény érdekében hagyja bekapcsolva.';
$string['configlatinexcelexport'] = 'Válassza ki az Excel-exportálás kódolását.';
$string['configlocale'] = 'Válasszon egy egész portálra érvényes nyelvterületet - ez befolyásolja a dátumok formáját és nyelvét. Ehhez az adott operációs rendszerben a nyelvterületre vonatkozó adatoknak már telepítve kell lenni (linux esetén pl. en_US vagy es_ES). A legtöbbször ezt a mezőt célszerű üresen hagyni.';
$string['configloginhttps'] = 'Ennek bekapcsolása esetén a Moodle csak a belépési oldalon használ biztonságos https-csatlakozást (így biztonságos belépést), ezt követően visszatér a gyorsabb normál http-vel megadott URL használatára. VIGYÁZAT: ennek a beállításához a https-t külön be KELL állítani a webszerveren - ellenkező esetben KIREKESZTHETI MAGÁT SAJÁT PORTÁLJÁRÓL!';
$string['configloglifetime'] = 'Itt adható meg a felhasználói aktivitás naplózásának megőrzési ideje. Az ennél régebbi naplókat a rendszer automatikusan törli. Érdemes a naplókat a lehető leghosszabb ideig megőrizni, mert szükség lehet rájuk. Ha viszont túlságosan nagy a szerver forgalma és gondok merülnek fel a teljesítménnyel kapcsolatban, akkor csökkentheti a naplómegőrzés időtartamát. A statisztika megfelelő működése érdekében azonban 30-nál alacsonyabb értéket nem célszerű megadni.';
$string['configlookahead'] = 'Előrenézési napok száma';
$string['configmailnewline'] = 'Levélüzenetekben használt újsor-karakterek. A CRLF használatát az RFC 822bis írja elő, egyes mailszerverek automatikusan végrehajtják az LF-ről CRLF-re való átalakítást, más mailszerverek hibásan alakítják át a CRLF-et CRCRLF-re, és vannak olyanok, amelyek elutasítják a sima LF-et tartalmazó leveleket (például a qmail). Próbálja meg módosítani ezt a beállítást, ha gondja van a kézbesítetlen levelekkel vagy a kettős új sorokkal.';
$string['configmaxbytes'] = 'Itt adható meg a teljes portálra vonatkozóan a feltöltött állományok maximális mérete. Ezt a beállítást a PHP upload_max_filesize és az Apache LimitRequestBody beállítása határolja be. Ugyanakkor a maxbytes a kurzusszinten vagy a modulszinten választható méreteket korlátozza. Ha a \'Server Limit\' lett kiválasztva, a rendszer a szerver által engedélyezett szervermaximumot fogja használni.';
$string['configmaxconsecutiveidentchars'] = 'A jelszavak legfeljebb ennyi egymás után következő azonos karakterből állhatnak. Az ellenőrzést a 0-t választva kapcsolhatja ki.';
$string['configmaxeditingtime'] = 'Ez adja meg azt az időt, amely alatt még lehet fórumüzeneteket, naplóvisszajelzéseket stb. újraszerkeszteni. Rendszerint egy 30 perces időtartam megfelelőnek mondható.';
$string['configmaxevents'] = 'Előrenézés eseményei';
$string['configmemcachedhosts'] = 'Memóriában való gyorsításhoz. A memóriában gyorsított démont futtató gazdagépek vesszővel elválasztott felsorolása. A DNS-látencia elkerülésére használjon IP-címeket. A memóriagyorsítás nem viselkedik megfelelően, ha futó beállításnál ad hozzá/távolít el gazdagépeket.';
$string['configmemcachedpconn'] = 'Memóriában való gyorsításhoz. Használjon stabil kapcsolatot. Bánjon vele óvatosan - az Apache/PHP a memóriában gyorsított démon újraindítása után kiakadhat.';
$string['configmessaging'] = 'Bekapcsolandó-e a portál felhasználói közötti üzenetküldő rendszer?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Az elolvasott értesítések helytakarékosság céljából törölhetők. Az olvasás és a törlés között mennyi idő teljen el?';
$string['configmessaginghidereadnotifications'] = 'Üzenetelőzmények megtekintése közben elolvasandókról, pl. fórumhozzászólásokról szóló értesítések elrejtése';
$string['configminpassworddigits'] = 'A jelszavakban legalább ennyi számjegynek kell szerepelni.';
$string['configminpasswordlength'] = 'A jelszavakban legalább ennyi karakternek kell szerepelni.';
$string['configminpasswordlower'] = 'A jelszavakban legalább ennyi kisbetűnek kell szerepelni.';
$string['configminpasswordnonalphanum'] = 'A jelszavakban legalább ennyi nem alfanumerikus karakternek kell szerepelni.';
$string['configminpasswordupper'] = 'A jelszavakban legalább ennyi nagybetűnek kell szerepelni.';
$string['configmycoursesperpage'] = 'Maximális megjelenítendő kurzusszám a felhasználó bármelyik saját kurzuslistáján belül';
$string['configmymoodleredirect'] = 'Ez a beállítás az átirányításokat a /my-ba tereli, ha nem a rendszergazda jelentkezik be, és lecseréli a legfelső szintű portálnavigálás nyomvonalát /my-ra';
$string['configmypagelocked'] = 'Ezzel megakadályozza, hogy az alapoldalt rendszergazdákon kívül mások szerkeszthessék.';
$string['confignavcourselimit'] = 'Korlátozza a be nem lépett vagy be nem iratkozott felhasználók számára a megjelenő kurzusok számát.';
$string['confignavshowallcourses'] = 'Beállítása esetén a felhasználó által felvett összes kurzus folyamatosan látszik a navigációs részen.';
$string['confignavshowcategories'] = 'A navigációs sávon és a navigációs blokkokban látsszanak a kurzuskategóriák. Ez nem fordul elő azon kurzusokkal, amelyeket a felhasználó felvett, ugyanakkor kategóriák nélkül megjelennek a Kurzusaim alatt.';
$string['confignoreplyaddress'] = 'E-maileket esetenként egy felhasználó nevében továbbít a rendszer (pl. fórumüzenetek). Az itt megadott e-mail cím jelenik meg mint \'Feladó\' azon esetekben, amikor a címzettek nem válaszolhatnak közvetlenül a felhasználónak (például amikor a felhasználó úgy dönt, hogy címét nem hozza nyilvánosságra).';
$string['confignotifyloginfailures'] = 'A belépési hibák rögzítése után e-mail értesítések küldhetők. Ki láthatja ezeket az értesítéseket?';
$string['confignotifyloginthreshold'] = 'Ha a sikertelen belépésekről szóló értesítés be van kapcsolva, egy felhasználótól vagy egy IP-címről hány sikertelen belépés után kerüljön sor az értesítésre?';
$string['confignotloggedinroleid'] = 'A portálra be nem lépett felhasználókat úgy tekinti a rendszer, mint akik a portálon ezzel a szereppel rendelkeznek.  Legtöbbször a vendégként való kezelés megfelelő, de létrehozhat ennél bővebb vagy szűkebb jogosultságot biztosító szerepeket.  Például az üzenetküldés továbbra is csak megfelelő belépés esetén engedélyezett.';
$string['configopentogoogle'] = 'Ezen beállítás bekapcsolásakor a Google-lal vendégként léphet be a portálra. Emellett a Google-keresés révén a portálra eljutók automatikusan vendégként tudnak bejelentkezni. Ne feledje, hogy ez csak azon kurzusokhoz biztosít követhető hozzáférést, amelyek engedélyezik vendégek belépésé.';
$string['configoverride'] = 'A config.php definiálja';
$string['configpasswordpolicy'] = 'Bekapcsolásakor a Moodle a jelszavakat az érvényben lévő jelszószabvány szempontjából ellenőrzi. Az alábbi beállításokkal adhat meg egy jelszószabványt (ha \'Nem\'-re állítja, a rendszer kihagyja az ellenőrzést).';
$string['configpathtoclam'] = 'Útvonal a vírusirtóhoz. Feltehetőleg egy /usr/bin/clamscan vagy /usr/bin/clamdscan jellegű útvonal. Erre a vírusirtó működéséhez van szükség.';
$string['configpathtodu'] = 'Útvonal a du-hoz. Például /usr/bin/du. Megadásakor a könyvtártartalmakat mutató oldalak sokkal gyorsabban futtathatók olyan könyvtárak esetén, amelyekben sok állomány van.';
$string['configperfdebug'] = 'Ha bekapcsolja, a teljesítményre vonatkozó információk megjelennek a standard stílus lábrészében.';
$string['configprofileroles'] = 'A felhasználói profilokban és a részvételi oldalon látható szerepek felsorolása';
$string['configprofilesforenrolledusersonly'] = 'A levélszemétküldők támadásának megelőzésére a még be nem iratkozott felhasználók profiljának leírása rejtve marad. Az új felhasználóknak legalább egy kurzust fel kell venni ahhoz, hogy hozzáadhassák profiljuk leírását.';
$string['configprotectusernames'] = 'Alapesetben a forget_password.php nem ad semmilyen ötletet a felhasználónevek vagy az e-mail címek kitalálásához.';
$string['configproxybypass'] = 'Olyan (részleges) gazdagépek és IP-címek vesszővel elválasztott listája, amelyeknek a proxyt ki kell hagyni (pl., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Ha ennek a szervernek proxyszámítógépet (például tűzfal) kell használni az Internet eléréséhez, akkor a proxygazdagép nevét és portszámát itt kell megadni. Ellenkező esetben hagyja üresen.';
$string['configproxypassword'] = 'Szükség esetén az internet proxyn keresztüli eléréséhez szükséges jelszó, üres, ha nincs rá szükség (PHP cURL-bővítményre van szükség).';
$string['configproxyport'] = 'Ha a szerver proxy-számítógépet használ, itt adja meg a proxy portját.';
$string['configproxytype'] = 'Webproxy típusa (PHP5-re és cURL-bővítményre van szükség a SOCKS5 támogatásához).';
$string['configproxyuser'] = 'Szükség esetén az internet proxyn keresztüli eléréséhez szükséges felhasználónév, üres, ha nincs rá szükség (PHP cURL-bővítményre van szükség).';
$string['configquarantinedir'] = 'Ha azt szeretné, hogy a vírusirtó a fertőzött állományokat karanténkönyvtárba helyezze, azt itt adja meg. A könyvtárnak a webszerver számára írhatónak kell lenni. Ha ezt üresen hagyja, illetve olyan könyvtárat ad meg, amely nem létezik vagy nem írható, akkor a rendszer törölni fogja a fertőzött állományokat. Lezáró perjelet ne használjon.';
$string['configrcache'] = 'A gyorsítótárat adatbázisrekordok tárolására használja. Ne feledje el beállítani a \'cachetype\'-ot is!';
$string['configrcachettl'] = 'Gyorsítótáras rekordok megőrzése másodpercben. Rövid (&lt;15) értéket adjon meg.';
$string['configrecaptchaprivatekey'] = 'Karaktersor az Ön Moodle-szervere és a recaptcha.net szerver közötti kommunikációhoz. Erről a portálról szerezhet be egyet: http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Karaktersor a reCAPTCHA-elem használatához a belépési űrlapon. A http://www.google.com/recaptcha állítja elő.';
$string['configrequestedstudentname'] = 'A tanuló megnevezése a kért kurzusokban';
$string['configrequestedstudentsname'] = 'A tanulók megnevezése a kért kurzusokban';
$string['configrequestedteachername'] = 'A tanár megnevezése a kért kurzusokban';
$string['configrequestedteachersname'] = 'A tanárok megnevezése a kért kurzusokban';
$string['configrequiremodintro'] = 'Kapcsolja ki, ha nem írja elő a felhasználók számára, hogy minden egyes tevékenységhez mellékeljenek leírást.';
$string['configrestrictbydefault'] = 'Ha az új kurzusok a fenti kategóriába tartoznak, moduljaik alapbeállításban korlátozottak legyenek?';
$string['configrestrictmodulesfor'] = 'Mely kurzusok esetén legyen egyes modulok kikapcsolása beállítva? Ez a beállítás csak a tanárokra vonatkozik, a rendszergazdák továbbra is hozzáadhatnak tevékenységeket a kurzusokhoz.';
$string['configrunclamavonupload'] = 'Bekapcsolása esetén a clam vírusirtó ellenőrzi az összes feltöltött állományt.';
$string['configrunclamonupload'] = 'Állományok feltöltésekor lefusson a vírusirtó? Ahhoz, hogy ez működjék, a pathtoclam útvonalnak helyesnek kell lennie. (Az ingyenes vírusirtó a http://www.clamav.net/ címről tölthető le.)';
$string['configsectioninterface'] = 'Felület';
$string['configsectionmail'] = 'Levelezés';
$string['configsectionmaintenance'] = 'Karbantartás';
$string['configsectionmisc'] = 'Egyéb';
$string['configsectionoperatingsystem'] = 'Operációs rendszer';
$string['configsectionpermissions'] = 'Engedélyek';
$string['configsectionrequestedcourse'] = 'Kurzuskérések';
$string['configsectionsecurity'] = 'Biztonság';
$string['configsectionstats'] = 'Statisztika';
$string['configsectionuser'] = 'Felhasználó';
$string['configsecureforms'] = 'A Moodle további biztonsági szintet használhat internetes űrlapok fogadásakor. Ennek bekapcsolásakor a böngésző HTTP_REFERER változóját ellenőrzi az adott űrlap címe szempontjából. Igen ritka esetekben ez gondot okozhat, ha a felhasználó olyan beállítású tűzfalat (pl. Zonealarm) használ, amely a HTTP_REFERER változót kiiktatja az internetes forgalomból. Ezt jelzi, ha az űrlap \'lefagy\'. Ha felhasználóinak gondja támad (például) a belépési oldallal, megfontolható ennek a beállításnak a kikapcsolása, jóllehet, ez a durvább jelszó elleni támadásokkal szemben védtelenül hagyhatja a rendszert. Ha bizonytalan, hagyja ezt a paramétert \'Igen\' beállításban.';
$string['configsessioncookie'] = 'Ez a beállítás szabja meg azt a sütinevet, amelyet a Moodle eseményei használni fognak. Megadása opcionális, és csak annyiban van értelme, hogy a sütik nem keverednek össze, ha ugyanazon a portálon a Moodle egynél több példányban fut.';
$string['configsessioncookiedomain'] = 'Ezzel módosíthatja azt a domént, ahonnan a Moodle-sütik elérhetők. Ez hasznos a Moodle olyan testre szabása esetén (pl. hitelesítés vagy beiratkozási segédprogramok), amely során a Moodle egy internetes alkalmazással vagy egy másik aldoménnel információkat kényszerül megosztani. <strong>VIGYÁZAT: kifejezetten ajánlott megtartani az alapbeállítást (üres), mert hibás érték esetén senki nem jelentkezhet be a portálra.</strong>';
$string['configsessioncookiepath'] = 'Ha módosítani kívánja a Moodle sütijeinek helyét, megadhat egy alkönyvtárat a portálján. Ellenkező esetben megfelelő az alapértelmezett \'/\'.';
$string['configsessiontimeout'] = 'Ha a portálra belépett személyek sokáig tétlenek (oldalak betöltése nélkül), a rendszer automatikusan kilépteti őket (eseményük befejeződik). Ez a változó szabja meg ezt az időtartamot.';
$string['configshowcommentscount'] = 'Megjegyzések számának kijelzése; a megjegyzések ugrópontjának kijelzésekor eggyel több lekérdezést jelent.';
$string['configshowsiteparticipantslist'] = 'Az oldalhoz tartozó összes tanuló és tanár neve szerepelni fog az oldalhoz tartozó résztvevők felsorolásában. Ki tekintheti meg az oldalhoz tartozó résztvevők felsorolását?';
$string['configsitedefaultlicense'] = 'Alapértelmezett portállicenc';
$string['configsitedefaultlicensehelp'] = 'Alapértelmezett licenc valamely tartalom portálon való közzétételéhez';
$string['configsitemailcharset'] = 'A portálon létrejövő összes e-mail ebben a karakterkészletben jelenik meg. Egyébként bármely felhasználó beállíthatja, ha az alábbi lehetőség be van kapcsolva.';
$string['configsitemaxcategorydepth'] = 'Maximális kategóriamélység';
$string['configsitemaxcategorydepthhelp'] = 'Ez határozza meg a megjelenő gyermekkategóriák maximális mélységét.';
$string['configslasharguments'] = 'Az állományok (képek, feltöltések stb.) olyan kódon keresztül állnak rendelkezésre, amely \'perjeles argumentumokat\' használ. Ezzel a módszerrel az állományokat könnyebben betöltheti webböngészőbe, proxyszerverbe stb. Némely PHP-szerverrel ez a módszer nem használható, ezért ha gond támad a feltöltött állományok vagy képek (például felhasználók képei) megtekintésével, kapcsolja ki ezt a beállítást.';
$string['configsmartpix'] = 'Bekapcsolása esetén az ikonokat olyan PHP-kód biztosítja, amely az adott stílust, majd az összes fölötte lévő stílust, végül a Moodle /pix mappáját nézi végig. Ezáltal kevesebb ismétlődő képállományra lesz szükség a stílusokon belül, ugyanakkor némileg csökken a teljesítmény.';
$string['configsmtphosts'] = 'Adja meg egy vagy több olyan helyi SMTP-szerver teljes nevét, amelyet a Moodle levélküldésre használhat (pl. \'mail.a.com\' vagy \'mail.a.com;mail.b.com\'). Ha nem alapértelmezett (vagyis 25) portot ad meg, használhatja a [server]:[port] alakot (pl. \'mail.a.com:587\'. Ha üresen hagyja, a Moodle levélküldésre a PHP alapbeállítás szerinti módszerét fogja használni.';
$string['configsmtpmaxbulk'] = 'Egy SMTP-folyamat alatt küldött üzenetek maximális száma. Az üzenetek csoportosítása felgyorsíthatja az e-mailek küldését. A 2-nél alacsonyabb értékek minden egyes e-mailhez új SMTP-folyamatot írnak elő.';
$string['configsmtpuser'] = 'Ha fentebb beállított egy SMTP-szervert és a szervernek hitelesítésre van szüksége, a felhasználónevet és a jelszót adja meg itt.';
$string['configstartwday'] = 'A hét kezdete';
$string['configstatsfirstrun'] = 'Itt adható meg, mely korábbi naplók legyenek feldolgozva, amikor a cronjob először készül feldolgozni a statisztikát. Ha nagy a forgalma és másokkal osztozik a portálon, jobb kerülni a túl régre való visszanyúlást, mert sokáig tarthat és sok erőforrást köthet le. (Ne feledje, hogy ennél a beállításnál 1 hónap = 28 nap. Az előállított grafikonok és jelentések esetén viszont 1 hónap = 1 naptári hónap.)';
$string['configstatsmaxruntime'] = 'A statisztika feldolgozása erőforrás-igényes lehet, ezért ezt a mezőt a lefuttatás idejének és időtartamának a megadásához kapcsolja össze a következővel.';
$string['configstatsmaxruntime2'] = 'A statisztika feldolgozása erőforrás-igényes lehet, ezért adjon meg egy maximális időt, amelyet az egy napi statisztika összegyűjtésére engedélyez. Egyetlen cron lefuttatásához a feldolgozható napok száma maximum 31 lehet.';
$string['configstatsmaxruntime3'] = 'Adja meg az egy napra statisztika kiszámítására fordítható maximális időt, figyelembe véve azt, hogy ez a feldolgozás erősen megterheli a szervert. Alább adhatja meg az egy cron alatt feldolgozható napok maximális számát.';
$string['configstatsruntimedays'] = 'Adja meg az egyes statisztikákban feldolgozott napok maximális számát. Naprakész statisztika esetén csak egy napot dolgoz föl a rendszer, ezért ezt az értéket a szerver leterheltsége szerint állítsa be; ha rövidebb cronra van szüksége, rövidítse az időtartamot.';
$string['configstatsruntimestart'] = 'A statisztikai feldolgozást végző cronjob mikor <b>induljon el</b>?';
$string['configstatsuserthreshold'] = 'Ez határozza meg a kurzust felvettek azon minimális számát, akikről készül statisztika.';
$string['configstrictformsrequired'] = 'Bekapcsolása esetén a felhasználók az űrlapok kitöltendő mezőibe nem írhatnak szóközt vagy sortörést. ';
$string['configstripalltitletags'] = 'Szüntesse meg a bejelölést, ha engedélyezni kívánja HTML-címkék használatát tevékenység- és tananyagnevekben.';
$string['configsupportemail'] = 'A portál felhasználói ezt az e-mail címet kapják meg levelezéshez, ha általában segítségre szorulnak (például amikor létrehozzák saját fiókjukat). Ha üresen hagyja, a felhasználókat nem segíti egy ilyen elérhetőség.';
$string['configsupportname'] = 'Azon személy vagy intézmény neve, aki/amely a kisegítő e-mailen vagy weboldalon keresztüli általános segítséget nyújtja.';
$string['configsupportpage'] = 'A portál felhasználói ezt az ugrópontot kapják meg arra az esetre, ha általában segítségre szorulnak (például amikor létrehozzák saját fiókjukat).  Ha üresen hagyja, a felhasználókat nem segíti egy ilyen ugrópont.';
$string['configthemedesignermode'] = 'A stílusokhoz tartozó képek és a CSS a teljesítmény érdekében régóta a böngésző és a szerver gyorsítótárában vannak. Stílusok kidolgozása vagy kódírás esetén kapcsolja be a gyorsítótáras verziók elkerülése érdekében. Figyelem: ezzel portálja minden felhasználó számára lelassul! A gyorsítótárban lévő stílusokat kézzel is visszaállíthatja a stílusválasztó oldalon.';
$string['configthemelist'] = 'Ha ez üres, bármely érvényes stílus használható. Ha a stílusmenüt rövidíteni kívánja, itt a nevekből megadhat egy vesszővel elválasztott felsorolást. Ne használjon szóközt! Például: standard,orangewhite.';
$string['configtimezone'] = 'Itt állíthatja be az alapértelmezett időzónát. Ez az egyetlen alapértelmezett időzóna a dátumok megjelenítésére - minden felhasználó felülírhatja ezt a beállítást a saját profiljában. A \'Szerveridő\' beállításakor a Moodle a szerver operációs rendszerének a beállítását fogja használni, a felhasználói profilban megadott \'Szerveridő\' viszont a felhasználó számára írja elő az idő megjelenítéséhez ezt az alapbeállítást.';
$string['configunzip'] = 'Itt adja meg a kicsomagoló program helyét (csak Unix esetén, opcionális). Ha meg van adva, a rendszer ezt a programot fogja használni a tömörített állományok szerverre való kicsomagolására. Ha ez kitöltetlen marad, akkor a Moodle belső eljárásait fogja használni.';
$string['configuseblogassociations'] = 'A felhasználók szervezhessék blogjukat az üzenetek kurzusokhoz és kurzusmodulokhoz kapcsolása révén?';
$string['configuseexternalyui'] = 'Helyi állományok helyett használjon online fájlokat a Yahoo szervereiről. VIGYÁZAT: ehhez internetes kapcsolatra van szükség, különben portálján nem fog működni az AJAX.';
$string['configuserquota'] = 'Az egyes felhasználók által saját állományterületükön tárolható bájtok maximális száma.
$a->bytes} bytes == {$a->displaysize}';
$string['configusetags'] = 'A címkék használatát az egész portálra bekapcsolja?';
$string['configvariables'] = 'Változók';
$string['configverifychangedemail'] = 'Bekapcsolja a módosított e-mail címek ellenőrzését az engedélyezett és a tiltott e-mail doménbeállítások alapján. Kikapcsolása esetén a domének használatára csak új felhasználók létrehozása esetén kerül sor.';
$string['configvisiblecourses'] = 'Rejtett kategóriák kurzusainak szokásos megjelenítése.';
$string['configwarning'] = 'Ezen beállítások módosításakor óvatosságra van szükség - a furcsa értékek gondot okozhatnak.';
$string['configxmlstrictheaders'] = 'Bekapcsolása esetén minden oldal előállítása az XML http-fejléce és bevezetője szerint történik annak érdekében, hogy a böngészők az XHTML-hibákat az adott szövegsoron belül jelezzék. Csak fejlesztőknek hasznos.';
$string['configyuicomboloading'] = 'Ennek révén YUI-könyvtárak optimális kombinált állománybetöltésre nyílik lehetőség. Éles környezetben a teljesítmény érdekében bekapcsolandó.';
$string['configzip'] = 'Itt adja meg a tömörítő program helyét (csak Unix esetén, opcionális). Ha meg van adva, a rendszer ezt a programot fogja használni tömörített állományok szerveren való létrehozására. Ha ez kitöltetlen marad, akkor a Moodle belső eljárásait fogja használni.';
$string['confirmation'] = 'Megerősítés';
$string['confirmdeletecomments'] = 'Biztosan törli a megjegyzéseket?';
$string['confirmed'] = 'Megerősítve';
$string['confirminstall'] = 'Nyelvi csomagot ({$a}) készül telepíteni, biztos, hogy ezt akarja?';
$string['convertformat'] = 'kimeneti forma <i>átalakítása</i>';
$string['cookiehttponly'] = 'Csak http-sütik';
$string['cookiesecure'] = 'Csak biztonságos sütik';
$string['country'] = 'Alapértelmezett ország';
$string['coursecontact'] = 'Kurzusvezetők';
$string['coursecontact_desc'] = 'Ezzel a beállítással megadhatja, ki jelenjen meg a kurzusleírásban. A felhasználóknak legalább ezen szerepek közül eggyel rendelkezni kell az adott kurzusban ahhoz, hogy annak kurzusleírásában megjelenjenek.';
$string['coursemgmt'] = 'Kurzusok hozzáadása/szerkesztése';
$string['courseoverview'] = 'Kurzus áttekintése';
$string['courserequestnotify'] = 'Értesítés kurzuskérésről';
$string['courserequestnotifyemail'] = '{$a->user} felhasználó {$a->link} címen új kurzust igényelt.';
$string['courserequests'] = 'Kurzuskérések';
$string['courserequestspending'] = 'Függőben lévő kurzuskérések';
$string['courses'] = 'Kurzusok';
$string['coursesperpage'] = 'Kurzus oldalanként';
$string['creatornewroleid'] = 'Szerkesztői szerep új kurzusokban';
$string['creatornewroleid_help'] = 'Ha a felhasználó még nem rendelkezik az új kurzus kezeléséhez szükséges engedéllyel, akkor automatikusan ezzel a szereppel iratkozik be.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'A cron futtatása csak a parancssorból';
$string['cronerrorclionly'] = 'Az oldal internetes elérését a rendszergazda kikapcsolta.';
$string['cronerrorpassword'] = 'Az oldal eléréséhez nem adott meg érvényes jelszót';
$string['cron_help'] = 'A cron.php karbantartó programkóddal egyes Moodle-modulok ütemezett feladatokat hajthatnak végre (pl. új fórumüzenetek kiküldése). A kód rendszeres, pl. 5 percenkénti  lefuttatásához valamilyen megoldásra van szükség.';
$string['cronremotepassword'] = 'Cron-jelszó a távoli eléréshez';
$string['cronwarning'] = 'A <a href="cron.php">cron.php karbantartó kódot</a> legalább 24 órája nem futtatta le.';
$string['csvdelimiter'] = 'CSV-határoló';
$string['ctyperecommended'] = 'Ajánlatos telepíteni az opcionális ctype PHP-bővítményt a portál teljesítményének növelése érdekében, különösen abban az esetben, ha a portál támogatja nem latin nyelvek használatát.';
$string['ctyperequired'] = 'A ctype PHP-bővítményt a Moodle előírja a portál teljesítményének növelése és a több nyelvű kompatibilitás érdekében.';
$string['curlcache'] = 'cURL-gyorsítótári TTL';
$string['curlrecommended'] = 'Ajánlatos a választható Curl-könyvtár telepítése a Moodle Networking bekapcsolásához.';
$string['curlrequired'] = 'A Moodle a Moodle-adattárakkal való kommunikációhoz most már megköveteli a cURL PHP bővítményt.';
$string['curltimeoutkbitrate'] = 'A cURL időtúllépésének (Kbps) kiszámításához használt bitsebesség';
$string['curltimeoutkbitrate_help'] = 'Kiterjedt cURL-kérés idején a megfelelő időtúllépés kiszámításához használt beállítás.A HTTP HEAD-hez kapcsolódó kérés alapján történik az időtúllépés kiszámítása a tartalom mérete alapján. A 0 kikapcsolja a kérelmet.';
$string['customcheck'] = 'Egyéb ellenőrzések';
$string['custommenu'] = 'Egyedi menü';
$string['custommenuitems'] = 'Egyedi menü elemei';
$string['datarootsecurityerror'] = '<p><strong>BIZTONSÁGI FIGYELMEZTETÉS!</strong></p><p>Adatainak gyökérkönyvtára rossz helyen van és elérhető a netről. Így minden magánállományát bárki elérheti, portáljára pedig jogtalan rendszergazdakénti belépésre ad lehetőséget!</p>
<p>Adatainak gyökérkönyvtárát ({$a}) <em>mindenképpen</em> helyezze át nyilvánosan elérhető internetes könyvtárán kívülre, valamint frissítse a <code>$CFG->dataroot</code> beállítást config.php állományában.</p>';
$string['datarootsecuritywarning'] = 'Előfordulhat, hogy portáljának beállítása nem biztonságos. Ellenőrizze, hogy adatainak gyökérkönyvtárát ({$a}) nem lehet-e közvetlenül elérni a netről.';
$string['dbmigrate'] = 'A Moodle adatbázisának áttelepítése';
$string['dbmigrateconnecerror'] = 'Nem lehetett a megadott adatbázishoz kapcsolódni.';
$string['dbmigrateencodingerror'] = 'A megadott adatbázis kódolása UNICODE/UTF8 helyett {$a}. Adjon meg helyette egy másikat.';
$string['dbmigratepostgres'] = 'Az Ön által használt adatbázisszerver feltehetőleg a PostgreSQL. Az áttelepítési folyamat folytatásához az áttelepített adatok tárolásához kézi úton új adatbázist kell \'UNICODE\' (PostgreSQL 7) vagy \'UTF8\' (PostgreSQL 8) kódolással létrehozni. Folytatáshoz adja meg alább az új adatbázis kapcsolódási beállításait:';
$string['dbmigratewarning'] = 'A folytatás előtt ellenőrizze, készített-e biztonsági mentést Moodle-adatbázisáról. Ha nem biztos abban, hogyan kell ezt megtenni, forduljon a rendszergazdához. Az áttelepítési folyamat elindítása után a Moodle-portál karbantartási üzemmódba kerül.';
$string['dbmigratewarning2'] = 'Figyelmeztetés: most indítja el az áttelepítési folyamatot. Mindenképpen győződjön meg arról, hogy a teljes Moodle adatbázisról készült-e biztonsági másolat.';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Az adatbázisról új UTF8 áttelepítés készült, így ez elavulttá vált. Szerkessze meg a config.php állományt és a Moodle-t használja ezzel az új adatbázissal.</font>';
$string['dbmigrationdupfailed'] = 'Az adatbázisról nem sikerült másodpéldányt készíteni, ennek feltételezett oka:<font color="#ff0000">{$a}</font>';
$string['dbsessions'] = 'Adatbázis használata a folyamatról szóló információkhoz';
$string['dbtest'] = 'Funkcionális adatbázistesztek';
$string['debug'] = 'Hibaszűrési üzenetek';
$string['debugall'] = 'MIND: a PHP összes használható hibaszűrési üzenetének megjelenítése';
$string['debugdeveloper'] = 'FEJLESZTŐ: a Moodle külön hibaszűrési üzenetei fejlesztők számára';
$string['debugdisplay'] = 'Hibaszűrési üzenetek megjelenítése';
$string['debugging'] = 'Hibaszűrés';
$string['debugminimal'] = 'MINIMÁLIS: csak a végzetes hibákat jelzi';
$string['debugnone'] = 'EGY SEM: semmilyen hibát vagy figyelmeztetést nem jelez';
$string['debugnormal'] = 'SZOKÁSOS: jelzi a hibákat, a figyelmeztetéseket és a tájékoztató üzeneteket';
$string['debugpageinfo'] = 'Oldalra vonatkozó információk megjelenítése';
$string['debugsmtp'] = 'E-mailküldés hibaszűrése';
$string['debugstringids'] = 'Nyelvi szövegek eredetének kijelzése';
$string['debugvalidators'] = 'Validáló ugrópontjainak megjelenítése';
$string['defaultallowedmodules'] = 'Megengedett alapmodulok';
$string['defaultcity'] = 'Alapbeállítás szerinti város';
$string['defaultcity_help'] = 'Az itt megadott város lesz új felhasználói fiókok létrehozása során az alapbeállítás szerinti város.';
$string['defaulthomepage'] = 'Alapértelmezett honlap felhasználóknak';
$string['defaultrequestcategory'] = 'Alapkategória kurzuskérésekhez';
$string['defaultsettinginfo'] = 'Alapbeállítás ({$a})';
$string['defaultuserroleid'] = 'Alapszerep minden felhasználó esetén';
$string['defaultvalues'] = 'Alapértékek';
$string['deleteerrors'] = 'Hibák törlése';
$string['deletefilterareyousure'] = 'Biztosan törli a(z) \'{$a}\' szűrőt?';
$string['deletefilterareyousuremessage'] = 'Törölni fogja a(z) \'{$a}\' szűrőt. Biztosan ezt akarja?';
$string['deletefilterfiles'] = 'A(z) \'{$a->filter}\' szűrőhöz kapcsolódó összes adat törlődött az adatbázisból. A törlés befejezéséhez (és a szűrő újbóli településének megelőzéséhez) törölje szerveréről ezt a könyvtárat: {$a->directory}';
$string['deleteincompleteusers'] = 'Hiányosan megadott felhasználók törlése ennyi idő elteltével';
$string['deleteqtypeareyousure'] = 'Biztosan törli a(z)\'{$a}\' kérdéstípust?';
$string['deleteqtypeareyousuremessage'] = 'Teljesen törölni fogja a(z)\'{$a}\' kérdéstípust. Biztosan eltávolítja?';
$string['deleteunconfirmed'] = 'Hiányosan beállított felhasználók törlése ennyi idő elteltével';
$string['deleteuser'] = 'Felhasználó törlése';
$string['deletingfilter'] = 'A(z) \'{$a}\' szűrő törlése';
$string['deletingqtype'] = 'A(z)\'{$a}\' kérdéstípus törlése';
$string['density'] = 'Sűrűség';
$string['denyemailaddresses'] = 'Elutasított e-mailek doménjei';
$string['development'] = 'Fejlesztés';
$string['digestmailtime'] = 'Összesített e-mailek elküldésének órája';
$string['disableuserimages'] = 'Felhasználói profilképek kikapcsolása';
$string['displayerrorswarning'] = 'A <em>display_errors</em> PHP-beállítás bekapcsolása nem ajánlott éles portálokon, mert egyes hibaüzenetek érzékeny adatokat adhatnak ki a szerveréről.';
$string['displayloginfailures'] = 'Sikertelen belépéskről értesítendő';
$string['docroot'] = 'Moodle Docs dokumentumok gyökérkönyvtára';
$string['doctonewwindow'] = 'Új ablakban jelenik meg';
$string['download'] = 'Letöltés';
$string['editennotallowed'] = 'Az en_utf8 nyelv ezen az oldalon nem szerkeszthető - váltson át a helyi nyelvre';
$string['edithelpdocs'] = 'Súgóállományok szerkesztése';
$string['editingnoncorelangfile'] = 'Kiegészítő modult/segédprogram fordítását próbálja módosítani. Külső programozású modulok fordítását csak a _local mappába mentheti. Az állomány fordítását áthelyezheti a modul lang könyvtárába és/vagy elküldheti a kiegészítő modult gondozó fél részére.';
$string['editlang'] = '<b>Szerkesztés</b>';
$string['editorbackgroundcolor'] = 'Háttérszín';
$string['editordictionary'] = 'Szerkesztő szótára';
$string['editorfontfamily'] = 'Betűtípus';
$string['editorfontlist'] = 'Betűtípusok felsorolása';
$string['editorfontsize'] = 'Betűméret';
$string['editorhidebuttons'] = 'Rejtett gombok';
$string['editorkillword'] = 'Word-forma szűrője';
$string['editorspelling'] = 'Szerkesztő helyesírás-ellenőrzése';
$string['editorspellinghelp'] = 'Helyesírás-ellenőrzés ki-/bekapcsolása. Bekapcsolása esetén az aspell-nek a szerveren telepítve kell lennie.';
$string['editstrings'] = 'Szavak vagy kifejezések szerkesztése';
$string['emailchangeconfirmation'] = 'E-mail módosításának megerősítése';
$string['emoticonalt'] = 'Alternatív szöveg ';
$string['emoticoncomponent'] = 'Képelem';
$string['emoticonimagename'] = 'Kép neve';
$string['emoticons'] = 'Hangulatjelek használata';
$string['emoticons_desc'] = 'Az űrlap meghatározza a portálján használt hangulatjeleket (emotikonokat). Ha egy sort ki akar törölni a táblázatból, mentse el az űrlapot bármely kitöltendő mezőben egy üres értékkel. Új hangulatjel felvételéhez töltse ki az utolsó üres sorban lévő mezőket. Az összes mező alapértékekkel való visszaállításához kövesse a fenti ugrópontot.
* Szöveg (kitöltendő) - Ez a szöveg jelenik meg a hangulatjel képe helyén. Legalább két karakter hosszúnak kell lennie.
* Kép neve (kitöltendő) - A hangulatjel képállományának neve kiterjesztés nélkül, a pix mappához viszonyítva.
* Képelem (kitöltendő) - Az ikont létrehozó elem.
* Alternatív szöveg (választható) - Szövegazonosító és a hangulatjel alternatív szövegeleme.';
$string['emoticonsreset'] = 'Hangulatjelek visszaállítása alapértékekre';
$string['emoticontext'] = 'Szöveg';
$string['emptysettingvalue'] = 'Üres';
$string['enableajax'] = 'Az AJAX bekapcsolása';
$string['enablecalendarexport'] = 'Naptárexportálás bekapcsolása';
$string['enablecomments'] = 'Megjegyzések engedélyezése';
$string['enablecourseajax'] = 'AJAX-os kurzusszerkesztés bekapcsolása';
$string['enablecourseajax_desc'] = 'AJAX bekapcsolása fő kurzusoldalak szerkesztéséhez. A kurzusformának és a stílusnak támogatnia kell az AJAX-os szerkesztést, emellett a felhasználónak is engedélyeznie kell profiljában az AJAX használatát.';
$string['enablecourserequests'] = 'Kurzuskérések bekapcsolása';
$string['enableglobalsearch'] = 'Globális keresés bekapcsolása';
$string['enablegroupmembersonly'] = 'Csak csoporttagok bekapcsolása';
$string['enablehtmlpurifier'] = 'A HTML Purifier bekapcsolása.';
$string['enablerecordcache'] = 'Rekord-gyorsítótár bekapcsolása';
$string['enablerssfeeds'] = 'RSS-hírek bekapcsolása';
$string['enablesafebrowserintegration'] = 'A biztonságos vizsgáztatási böngésző integrálásának bekapcsolása';
$string['enablestats'] = 'Statisztika bekapcsolása';
$string['enabletrusttext'] = 'Megbízható tartalom bekapcsolása';
$string['enablewebservices'] = 'Webszolgáltatások bekapcsolása';
$string['enablewsdocumentation'] = 'Webszolgáltatások dokumentációja';
$string['encoding'] = 'Kódolás';
$string['enrolinstancedefaults'] = 'Beiratkozási esemény alapbeállításai';
$string['enrolinstancedefaults_desc'] = 'Beiratkozás alapbeállításai új kurzusok esetén';
$string['enrolmultipleusers'] = 'A felhasználók beíratása';
$string['environment'] = 'Környezet';
$string['environmenterrortodo'] = 'A fentiekben fellelt összes környezeti problémát (hibát) el kell hárítania, mielőtt folytatja a Moodle ezen változatának a telepítését!';
$string['environmenterrorupgrade'] = 'Figyelmeztetés: a fentiekben talált összes környezeti problémát (hibát) el kell hárítania, mielőtt folytatja a Moodle ezen változatának frissítését! Ha a követelmények teljesítése nélkül végzi el a frissítést, gondokba (például adatvesztés) ütközhet. Biztosan folytatja a frissítést?';
$string['environmentmustfixsetting'] = 'A PHP beállításait módosítani kell.';
$string['environmentok'] = 'Szerverkörnyezete megfelel az összes minimális követelménynek.';
$string['environmentrecommendcustomcheck'] = 'ha ez az ellenőrzés sikertelen, az potenciális gondot jelez';
$string['environmentrecommendinstall'] = 'a megfelelő teljesítmény érdekében telepítse és kapcsolja be';
$string['environmentrecommendversion'] = 'a {$a->needed} változatot ajánlott a mostani {$a->current} helyett használni';
$string['environmentrequirecustomcheck'] = 'ennek az ellenőrzésnek sikerülnie kell';
$string['environmentrequireinstall'] = 'telepíteni kell és be kell kapcsolni';
$string['environmentrequireversion'] = 'a {$a->needed} változatot kell a mostani {$a->current} helyett használni';
$string['environmentsettingok'] = 'ajánlott beállítás észlelve';
$string['environmentshouldfixsetting'] = 'A PHP beállítását módosítani kell.';
$string['environmentxmlerror'] = 'Hiba a környezeti adatok ({$a->error_code}) beolvasása közben';
$string['errordeletingconfig'] = 'Hiba történt a(z)\'{$a}\' segédprogram beállítási rekordjainak törlése közben.';
$string['errors'] = 'Hibák';
$string['errorsetting'] = 'Ezt a beállítást nem lehetett elmenteni:';
$string['errorwithsettings'] = 'Egyes beállításokat hiba miatt nem lehetett módosítani.';
$string['everyonewhocan'] = 'Bárki, aki számára \'{$a}\' engedélyezve van.';
$string['exceptions'] = 'kivételek';
$string['excludeoldflashclients'] = 'A Flash-lejátszó előírt verziója';
$string['experimental'] = 'Kísérleti';
$string['experimentalsettings'] = 'Kísérleti beállítások';
$string['extendedusernamechars'] = 'Tetszőleges karakterek engedélyezése a felhasználónevekben';
$string['extramemorylimit'] = 'Külön php-memóriakorlát';
$string['extrauserselectorfields'] = 'Felhasználók kiválasztása során keresés és megjelenítés';
$string['fatalmagicquotesruntime'] = '<p>Súlyos konfigurációs hiba, tájékoztassa róla a rendszergazdát.</p><p> A helyes működéshez a rendszergazdának módosítania kell a PHP beállításait.</p><p>A <code>magic_quotes_runtime</code> <code>off</code>-ra állítandó.</p><p>Ezt a beállítást a szerveren lévő <code>php.ini</code>, Apache/IIS <br />beállításának vagy a <code>.htaccess</code> állomány szerkesztésével módosíthatja.</p>';
$string['fatalsessionautostart'] = '<p>Súlyos konfigurációs hiba, tájékoztassa róla a rendszergazdát.</p><p> A helyes működéshez a rendszergazdának módosítania kell a PHP beállításait.</p><p>A <code>session.auto_start</code> <code>off</code>-ra állítandó.</p><p>Ezt a beállítást a szerveren lévő <code>php.ini</code>, Apache/IIS <br />beállításának vagy a <code>.htaccess</code> állomány szerkesztésével módosíthatja.</p>';
$string['filecreated'] = 'Új állomány létrehozva';
$string['filestoredin'] = 'Állomány mentése ebbe a mappába:';
$string['filestoredinhelp'] = 'Ahová az állomány kerül';
$string['filterall'] = 'Minden szövegsor szűrése';
$string['filtermatchoneperpage'] = 'Oldalanként egy találat kiszűrése';
$string['filtermatchonepertext'] = 'Szövegenként egy találat kiszűrése';
$string['filters'] = 'Szűrők';
$string['filtersettings'] = 'Szűrők kezelése';
$string['filtersettingsgeneral'] = 'Általános szűrőbeállítások';
$string['filteruploadedfiles'] = 'Feltöltött állományok szűrése';
$string['forcelogin'] = 'Felhasználói belépés előírása';
$string['forceloginforprofileimage'] = 'Felhasználók belépésének előírása a felhasználói képek megtekintéséhez';
$string['forceloginforprofileimage_help'] = 'Bekapcsolása esetén a felhasználóknak be kell lépni a felhasználói képek megtekintéséhez. A rendszer minden tájékoztató e-mailhez az alapbeállítás szerinti felhasználói képet fogja használni.';
$string['forceloginforprofiles'] = 'Felhasználói belépés előírása a profilhoz';
$string['forcetimezone'] = 'Alapidőzóna megadásának előírása';
$string['framename'] = 'Keret neve';
$string['frontpage'] = 'Kezdőoldal';
$string['frontpagebackup'] = 'A kezdőoldal biztonsági mentése';
$string['frontpagedefaultrole'] = 'Kezdőoldali alapszerep';
$string['frontpagefilters'] = 'Kezdőoldali szűrők';
$string['frontpageloggedin'] = 'A kezdőoldal elemei belépéskor';
$string['frontpageoverrides'] = 'A kezdőoldalra vonatkozó engedélyek felülírása';
$string['frontpagequestions'] = 'A kezdőoldal kérdései';
$string['frontpagerestore'] = 'A kezdőoldal helyreállítása';
$string['frontpageroles'] = 'A kezdőoldal szerepei';
$string['frontpagesettings'] = 'A kezdőoldal beállításai';
$string['fullnamedisplay'] = 'Teljes név szerinti forma';
$string['gdrecommended'] = 'A GD-bővítmény képek átalakítására szolgál. Ha nem telepíti, egyes funkciók, például a felhasználói profilképek hiányozni fognak.';
$string['gdversion'] = 'GD-verzió';
$string['generalsettings'] = 'Általános beállítások';
$string['geoipfile'] = 'GeoIP City adatállomány';
$string['getremoteaddrconf'] = 'Naplózott IP-cím forrása';
$string['globalsquoteswarning'] = '<p><strong>Biztonsági figyelmeztetés</strong>: a megfelelő működéshez a Moodle <br></br>bizonyos módosításokat ír elő az adott PHP-beállításokban.</p><p>A <em>beállítandó</em> érték: <code>register_globals=off</code> és/vagy <code>magic_quotes_gpc=on</code>.<br></br>Ha lehet, a szerver biztonságának növelése érdekében állítsa be a <code>register_globals=off</code> értéket,<br></br> emellett ajánlott a <code>magic_quotes_gpc=on</code> értékre állítása is.</p><p>Ezek a beállítások a <code>php.ini</code>, az Apache/IIS <br></br>beállítása vagy a<code>.htaccess</code> állomány szerkesztésével módosíthatók.</p>';
$string['globalswarning'] = '<p><strong>BIZTONSÁGI FIGYELMEZTETÉS</strong>: A megfelelő működéshez a Moodle <br />bizonyos módosításokat ír elő az adott PHP-beállításokban.<p/><p>A <em>beállítandó</em> érték: <code>register_globals=off</code>. <p>Ezek a beállítások a <code>php.ini</code>, az Apache/IIS <br />beállításával vagy a <code>.htaccess</code>-állomány szerkesztésével módosíthatók.</p>';
$string['googlemapkey'] = 'A Google Maps API kulcsa';
$string['gotofirst'] = 'Ugrás az első hiányzó szövegsorra';
$string['gradebook'] = 'Osztályozó napló';
$string['gradebookroles'] = 'Osztályozott szerepek';
$string['gradeexport'] = 'Elsődleges osztályzat exportálásának módszerei';
$string['groupenrolmentkeypolicy'] = 'Csoportos beiratkozási kulcsra vonatkozó szabvány';
$string['groupenrolmentkeypolicy_desc'] = 'Ennek bekapcsolása esetén a Moodle ellenőrzi, hogy a csoportos beiratkozási kulcsok megfelelnek-e egy érvényes jelszószabványnak.';
$string['guestroleid'] = 'Vendégszerep';
$string['guestroleid_help'] = 'Ezt a szerepet a vendég automatikusan megkapja. Ideiglenesen azon be nem iratkozott felhasználók is megkapják, akik a kurzusba a vendéget beiratkoztató segédprogramon keresztül lépnek be.
';
$string['helpadminseesall'] = 'A rendszergazdák minden naptáreseményt lássanak, vagy csak a rájuk vonatkozókat?';
$string['helpcalendarsettings'] = 'A Moodle különféle, naptárral és dátummal/idővel kapcsolatos dolgainak beállítása';
$string['helpforcetimezone'] = 'A felhasználók számára lehetővé teheti, hogy egyenként válasszák ki a saját időzónájukat, vagy dönthet úgy, hogy mindenkinek egyetlen időzónát biztosít.';
$string['helpsitemaintenance'] = 'Verziófrissítések és egyéb tennivalók';
$string['helpstartofweek'] = 'Melyik nappal kezdődjék a naptárban a hét?';
$string['helpupcominglookahead'] = 'Alaphelyzetben a naptár hány nappal előre keressen közelgő eseményeket?';
$string['helpupcomingmaxevents'] = '(Maximum) hány közelgő eseményt lássanak a felhasználók alaphelyzetben?';
$string['helpweekenddays'] = 'A hét mely napjait kezelje a rendszer eltérő színben megjelenített \'ünnepnapként\'?';
$string['hiddenuserfields'] = 'Felhasználói mezők elrejtése';
$string['hidefromall'] = 'Elrejtés minden felhasználó elől';
$string['hidefromnone'] = 'Senki elől ne rejtse el';
$string['hidefromstudents'] = 'Elrejtés a tanulók elől';
$string['htmleditor'] = 'HTML-szerkesztő';
$string['htmleditorsettings'] = 'A HTML-szerkesztő beállításai';
$string['htmlsettings'] = 'HTML-beállítások';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP-biztonság';
$string['iconvrecommended'] = 'A portál teljesítményének növelése érdekében ajánlatos telepíteni az opcionális ICONV-könyvtárat, különösen akkor, ha a portál támogatja nemlatin nyelvek használatát.';
$string['iconvrequired'] = 'Telepíteni kell az ICONV-bővítményt.';
$string['ignore'] = 'Kihagy';
$string['importlangreminder'] = 'Az adatbázis áttelepítése elkezdődik. A frissítés életbe lépéséhez lépjen be ismét. Mielőbb telepítse az unikódos nyelvi csomagokat a Portáladminisztráció->Nyelv->Nyelvi csomagok segítségével, amint az adatbázis áttelepítése megtörtént.';
$string['importtimezones'] = 'A teljes időzónalista frissítése';
$string['importtimezonescount'] = '{$a->count} elem importálva innen: {$a->source}';
$string['importtimezonesfailed'] = 'Nincs adatforrás! (Ez gondot jelent!)';
$string['includemoduleuserdata'] = 'Modul felhasználói adatainak hozzáadása';
$string['incompatibleblocks'] = 'A blokkok nem kompatibilisek';
$string['install'] = 'A kiválasztott nyelvi csomag telepítése';
$string['installedlangs'] = 'Telepített nyelvi csomagok';
$string['installhijacked'] = 'A telepítést az eredeti IP-címről kell befejezni.';
$string['installsessionerror'] = 'A PHP-folyamat nem indítható el, ellenőrizze, hogy böngészőjében a sütik be vannak-e kapcsolva.';
$string['intcachemax'] = 'Max. belső gyorsítótár';
$string['intlrecommended'] = 'Az Intl-bővítménnyel javítható a többnyelvű szövegek támogatása, például a portál nyelve szerinti rendezés.';
$string['invalidlangpack'] = 'a nyelvi csomag szerkesztéséhez át kell helyeznie a nyelvi mappába.';
$string['invalidsection'] = 'Érvénytelen szekció.';
$string['invaliduserchangeme'] = 'A \'changeme\' felhasználói név fenntartott név - ezzel nem hozhat létre felhasználói nevet.';
$string['ipblocked'] = 'A portál jelenleg nem érhető el.';
$string['ipblocker'] = 'IP-blokkoló';
$string['ipblockersyntax'] = 'Minden tételt egy sorba írjon. Érvényes az a teljes IP-cím (pl. <b>192.168.10.1</b>), amely egyetlen gazdagépet azonosít; a részleges cím (pl. <b>192.168.</b>), amely bármely ilyen számokkal kezdődő címet azonosít; a CIDR-jelölés (pl. <b>231.54.211.0/20</b>); az IP-címek tartománya (pl. <b>231.3.56.10-20</b>), ahol a tartomány a cím utolsó részére vonatkozik. A szöveges doménnevek (pl \'example.com\') használatát a rendszer nem támogatja, az üres sorokat pedig figyelmen kívül hagyja.';
$string['iplookup'] = 'IP-cím keresése';
$string['iplookupinfo'] = 'Alaphelyzetben a Moodle az ingyenes online NetGeo (az Internet földrajzi adatbázisa) szerverét használja IP-címek helyének kikereséséhez, de ezt az adatbázist már nem frissítik, így <em>merőben téves</em> adatokkal szolgálhat. Ajánlott a MaxMind ingyenes GeoLite City adatbázisának helyi példányát telepíteni.<br /> Az IP-cím helye vagy egy egyszerű térképen, vagy a Google Maps-en jelenik meg. Az interaktív térképek bekapcsolásához Google-fiókkal és ingyenes Google Maps API kulccsal kell rendelkeznie.';
$string['iplookupmaxmindnote'] = 'Ez a termék a MaxMind által létrehozott GeoLite-ot tartalmazza, amely elérhető a <a href="http://www.maxmind.com/">http://www.maxmind.com/</a> portálról.';
$string['iplookupnetgeonote'] = 'A Moodle a NetGeo szerverét használja földrajzi adatok kikereséséhez. Pontosabb eredmények érdekében ajánlott a MaxMind GeoLite adatbázisa helyi példányának a telepítése.';
$string['jabber'] = 'Jabber';
$string['jabberhost'] = 'Jabber-gazdagép';
$string['jabberpassword'] = 'Jabber-jelszó';
$string['jabberport'] = 'Jabber-port';
$string['jabberserver'] = 'Jabber-szerver';
$string['jabberusername'] = 'Jabber-felhasználónév';
$string['keeptagnamecase'] = 'Címkenév betűalakjának megőrzése';
$string['lang'] = 'Alapnyelv';
$string['lang16notify'] = 'A Moodle 1.6 és magasabb verziószámú változataival a nyelvi csomagok közvetlenül letölthetők és frissíthetők a download.moodle.org portálról az alábbi ugrópont segítségével';
$string['langcache'] = 'Nyelvi menü gyorsítótárba helyezése';
$string['langcache_desc'] = 'Nyelvi menü gyorsítótárba helyezése. Bekapcsolása esetén az elérhető fordítások a gyorsítótárba kerülnek. A gyorsítótár egy nyelvi csomag beépített nyelvcsomag-kezelővel  való telepítése vagy törlése esetén automatikusan frissítődik. A nyevi csomag kézi telepítése esetén az összes gyorsítótár kiürítése funkcióval kell frissítenie a gyorsítótárban lévő csomagok listáját.';
$string['langedit'] = 'Nyelv szerkesztése';
$string['langimport'] = 'Nyelvimportáló segédeszköz';
$string['langimportdisabled'] = 'A nyelvimportálás ki van kapcsolva. Nyelvi csomagjait állományonként kézzel kell frissítenie.';
$string['langimportsuccess'] = 'A nyelvi csomag frissítése sikerült';
$string['langlist'] = 'A nyelvi menü nyelvei';
$string['langlocalpackage'] = 'Helyi módosítások';
$string['langmasterenglish'] = 'Angol nyelvi alapcsomag';
$string['langmasterpackage'] = 'Nyelvi alapcsomag';
$string['langmenu'] = 'A nyelvi menü megjelenítése';
$string['langnoeditenglish'] = 'Az alapvető angol nyelvi csomag nem írható felül. Helyi módosításokhoz térjen át egy másik nyelvi könyvtárra';
$string['langpackinstalled'] = 'A(z) {$a} nyelvi csomag telepítése sikerült';
$string['langpackmaintaining'] = 'Nyelvi csomag karbantartása';
$string['langpackremoved'] = 'A nyelvi csomag eltávolítása megtörtént';
$string['langpacks'] = 'Nyelvi csomagok';
$string['langpackupdated'] = 'A(z) {$a} nyelvi csomag frissítése sikerült';
$string['langpackupdateskipped'] = 'A(z) {$a} nyelvi csomag frissítése kihagyva';
$string['langpackwillbeupdated'] = 'A verzióváltás során a Moodle megpróbálja frissíteni a kiválasztott nyelvi csomagot.';
$string['langrmyourself'] = 'Adatvesztés elkerülése érdekében a lang.php nem írhatja felül a meglévő állományt üres tartalommal. Az állományt távolítsa el kézi úton.';
$string['langstringcache'] = 'Az összes nyelvi szöveg gyorsítótárba helyezése';
$string['languagesettings'] = 'Nyelvi beállítások';
$string['langupdatecomplete'] = 'A nyelvi csomag frissítése befejeződött';
$string['latexpreamble'] = 'LaTeX-preambulum';
$string['latexsettings'] = 'A LaTeX-átalakító beállításai';
$string['latinexcelexport'] = 'Excel-kódolás';
$string['legacyfilesinnewcourses'] = 'Új kurzusokban szereplő korábbi kurzusállományok';
$string['legacyfilesinnewcourses_help'] = 'Alapesetben a korábbi kurzusállományok területe csak frissített kurzusokban érhető el. Ezzel a beállítással egyes funkciók, pl. az egyetlen tevékenység biztonsági mentése/visszaállítása, nem használhatók.';
$string['licensesettings'] = 'Licencbeállítások';
$string['loading'] = 'Betöltés';
$string['localetext'] = 'Az egész portál nyelvi környezete';
$string['localstringcustomization'] = 'Helyi szöveg testre szabása';
$string['location'] = 'Hely';
$string['locationsettings'] = 'Hely beállításai';
$string['locked'] = 'zárolva';
$string['log'] = 'Naplók';
$string['logguests'] = 'Vendég hozzáférésének naplózása';
$string['logguests_help'] = 'Ezzel bekapcsolja vendégek és be nem lépők tevékenységeinek naplózását. Nagy forgalmú portálokon a teljesítményre tekintettel kikapcsolható ez a naplózás. Éles portálokon azonban ajánlott bekapcsolva tartani.';
$string['loginhttps'] = 'HTTPS használata belépéshez';
$string['loginpasswordautocomplete'] = 'Jelszó automatikus kitöltésének megakadályozása a bejelentkezési űrlapon';
$string['loginpasswordautocomplete_help'] = 'Kikapcsolása esetén a felhasználók jelszavukat elmenthetik böngészőjükben. Bekapcsolásakor a portálja felhagy az XHTML szigorú érvényesítési szabályainak betartásával.';
$string['loglifetime'] = 'Naplók megőrzése ehhez';
$string['longtimewarning'] = '<b>Ne feledje, hogy ez a folyamat eltarthat egy ideig.</b>';
$string['mail'] = 'E-mail';
$string['mailnewline'] = 'Újsor-karakterek a levélben';
$string['maintenancemode'] = 'Karbantartási üzemmódban';
$string['maintfileopenerror'] = 'Hiba a karbantartási állományok megnyitása közben!';
$string['maintinprogress'] = 'A karbantartás folyamatban...';
$string['managelang'] = 'Kezelés';
$string['managelicenses'] = 'Licencek kezelése';
$string['manageqtypes'] = 'Kérdéstípusok kezelése';
$string['maturity100'] = 'Béta';
$string['maturity150'] = 'Jelölt közzététele';
$string['maturity200'] = 'Stabil verzió';
$string['maturity50'] = 'Alfa';
$string['maturitycorewarning'] = 'Olyan "{$a}" jelzéssel megjelölt verzióra kívánja frissíteni a Moodle-t, amely még nem használható élesben. Ellenőrizze, hogy valóban ezt akarja-e, és ehhez a Moodle megfelelő forráskódját jelölte-e be.';
$string['maxbytes'] = 'Maximálisan feltölthető állományméret';
$string['maxconsecutiveidentchars'] = 'Egymást követő azonos karakterek';
$string['maxeditingtime'] = 'Maximális üzenetszerkesztési idő';
$string['mbstringrecommended'] = 'A portál teljesítményének javítása érdekében ajánlatos telepíteni az opcionális MBSTRING-könyvtárat, különösen, ha a portál támogatja nemlatin nyelvek használatát.';
$string['mediapluginavi'] = '.avi szűrő bekapcsolása';
$string['mediapluginflv'] = '.flv szűrő bekapcsolása';
$string['mediapluginimg'] = 'Kapcsolt képek automatikus beágyazásának engedélyezése';
$string['mediapluginmov'] = '.mov szűrő bekapcsolása';
$string['mediapluginmp3'] = '.mp3 szűrő bekapcsolása';
$string['mediapluginmpg'] = '.mpg szűrő bekapcsolása';
$string['mediapluginogg'] = 'Az .ogg szűrő bekapcsolása';
$string['mediapluginogv'] = 'Az .ogv szűrő bekapcsolása';
$string['mediapluginram'] = '.ram szűrő bekapcsolása';
$string['mediapluginrm'] = '.rm szűrő bekapcsolása';
$string['mediapluginrpm'] = '.rpm szűrő bekapcsolása';
$string['mediapluginswf'] = '.swf szűrő bekapcsolása';
$string['mediapluginswfnote'] = 'A biztonság érdekében szokásos felhasználók nem építhetnek be swf flash típusú állományokat.';
$string['mediapluginwmv'] = '.wmv szűrő bekapcsolása';
$string['mediapluginyoutube'] = 'A YouTube ugrópontszűrőjének bekapcsolása';
$string['memcachedhosts'] = 'Memóriában gyorsított gazdagépek';
$string['memcachedpconn'] = 'Memóriában gyorsított stabil kapcsolatok használata.';
$string['messaging'] = 'Üzenetküldő rendszer bekapcsolása';
$string['messagingdeletereadnotificationsdelay'] = 'Elolvasott értesítések törlése';
$string['messaginghidereadnotifications'] = 'Elolvasandókról szóló értesítések elrejtése';
$string['minpassworddigits'] = 'Számjegyek';
$string['minpasswordlength'] = 'Jelszó hossza';
$string['minpasswordlower'] = 'Kisbetűk';
$string['minpasswordnonalphanum'] = 'Nem alfanumerikus karakterek';
$string['minpasswordupper'] = 'Nagybetűk';
$string['misc'] = 'Egyéb';
$string['missinglangparent'] = 'Hiányzik a(z) <em>{$a->lang}</em> nyelv <em>{$a->parent}</em> felettes nyelve.';
$string['mnetrestore_extusers'] = '<strong>Megjegyzés</strong>: Ebben a biztonsági mentésben a Moodle Network olyan távoli felhasználói fiókjai szerepelnek, amelyeket a rendszer a folyamat részeként helyreállít.';
$string['mnetrestore_extusers_admin'] = '<strong>Megjegyzés:</strong> Ez a biztonsági mentés feltehetőleg egy másik Moodle-telepítésből való, a Moodle-hálózat távoli felhasználói fiókjait tartalmazza. A helyreállítási folyamat minden létrehozott fiókot a Moodle-hálózat gazdagépeihez illeszt. A nem egyező fiókok esetén automatikusan belső hitelesítésre kapcsol át (mnet helyett). Erről a helyreállítási napló tájékoztatja.';
$string['mnetrestore_extusers_mismatch'] = 'Megjegyzés: Ez a biztonsági mentés nyilvánvalóan egy másik Moodle-telepítésből való, és benne a Moodle Network olyan távoli felhasználói fiókjai szerepelnek, amelyek helyreállítása esetleg sikertelen lesz. Ezt a műveletet a rendszer nem támogatja. Ha biztos benne, hogy a Moodle ezen telepítésével hozta létre, illetve ha gondoskodni tud arról, hogy a Moodle Network összes gazdagépe konfigurálva legyen, úgy megpróbálkozhat a helyreállítással.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Megjegyzés:</strong> Ez a biztonsági mentés feltehetőleg egy másik Moodle-telepítésből való, a Moodle-hálózat távoli felhasználói fiókjait tartalmazza. Ilyen típusú helyreállítást nem hajthat végre. Forduljon a portál rendszergazdájához vagy felhasználói információk (modulok, állományok...) nélkül hajtsa végre a helyreállítást.';
$string['mnetrestore_extusers_switchuserauth'] = 'A Moodle-hálózat {$a->username} távoli felhasználója ({$a->mnethosturl} helyről) helyi {$a->auth} hitelesítésű felhasználóra váltott.';
$string['modeditdefaults'] = 'Alapértékek tevékenységek beállításához';
$string['modsettings'] = 'Tevékenységek kezelése';
$string['modulesecurity'] = 'Modulbiztonság';
$string['multilangforceold'] = 'Régi többnyelvű szintaxis előírása a class="multilang" és a &lt;lang&gt; nélkül';
$string['multilangupgrade'] = 'Többnyelvű verziófrissítés';
$string['multilangupgradeinfo'] = 'A többnyelvű szűrőt használó szintaxis az 1.8-ban módosult, a &lt;lang&gt; jelölő használatát a rendszer már nem támogatja. Példa: &lt;span lang="en" class="multilang">Hello!&lt;/span&gt;&lt;span lang="es" class="multilang">Hola!&lt;/span&gt;<br /><br />A szintaxist az összes szövegben frissíteni kívánja most?';
$string['multilangupgradenotice'] = 'Portálja feltehetőleg a régi többnyelvű szintaxist használja: ajánlott a <a href="multilangupgrade.php">többnyelvű frissítés</a> használata.';
$string['mustenablestats'] = 'A portálon nincs bekapcsolva a statisztika.';
$string['mycoursesperpage'] = 'Kurzusok száma';
$string['mydashboard'] = 'A rendszer alapértelmezett irányítópultja';
$string['mymoodle'] = 'Az én Moodle-om';
$string['mymoodleredirect'] = 'Az én Moodle-om használatának előírása';
$string['mypage'] = 'Elsődleges Moodle oldalam';
$string['mypagelocked'] = 'Elsődleges oldal zárolása';
$string['myprofile'] = 'Elsődleges profiloldal';
$string['mysql416bypassed'] = 'Ha viszont a portálja CSAK iso-8859-1 (latin) nyelveket használ, továbbra is használhatja a pillanatnyilag telepített MySQL 4.1.12 (vagy magasabb) verziót.';
$string['mysql416required'] = 'A Moodle 1.6 esetén a MySQL minimális verziószáma a 4.1.16 azért, hogy a későbbiekben minden adatot UTF-8 formában lehessen tárolni.';
$string['navcourselimit'] = 'Kurzuskorlát';
$string['navigationupgrade'] = 'Ez a verziófrissítés két új navigációs blokkot tartalmaz, melyek ezen blokkokat váltják fel: Adminisztráció, Kurzusok, Tevékenységek és Felhasználók. Ha ezekhez a blokkokhoz külön engedélyeket rendelt, ellenőrizze, hogy minden a kívánt módon működik-e.';
$string['navshowallcourses'] = 'Az összes kurzus megjelenítése';
$string['navshowcategories'] = 'Kurzuskategóriák megjelenítése';
$string['neverdeleteruns'] = 'Profilkészítések soha ne törlődjenek';
$string['nobookmarksforuser'] = 'Nincsenek könyvjelzői.';
$string['nochanges'] = 'Nincs változás';
$string['nodatabase'] = 'Nincs adatbázis';
$string['nolangupdateneeded'] = 'Minden nyelvi csomagja friss, frissítésre nincs szükség';
$string['nomissingstrings'] = 'Nincs hiányzó szöveg';
$string['nonewsettings'] = 'A frissítés során nem került sor új beállítások hozzáadására.';
$string['nonexistentbookmark'] = 'A kért könyvjelző nem létezik.';
$string['noreplyaddress'] = 'Választ nem váró cím';
$string['noresults'] = 'Nincs eredmény.';
$string['noroles'] = 'Nincs szerep.';
$string['notifications'] = 'Értesítések';
$string['notifyloginfailures'] = 'Sikertelen e-mailben történt belépésekről értesítendő';
$string['notifyloginthreshold'] = 'E-mailben történt értesítések küszöbértéke';
$string['notloggedinroleid'] = 'Látogatói szerep';
$string['numberofmissingstrings'] = 'Hiányzó szövegek száma: {$a}';
$string['numberofstrings'] = 'Összes szövegszám: {$a->strings}<br></br>Hiányzó: {$a->missing} ({$a->missingpercent} %)';
$string['numcoursesincombo'] = 'A listával kombinált beviteli mezőben megjelenő kurzusok maximális száma ';
$string['numcoursesincombo_help'] = 'A listával kombinált beviteli mező nagy számú kurzus esetén nehézkesen használható. Ha a portálon a kurzusok száma meghaladja az itt beállítottat, az összes kurzus címoldalon való megjelenítése helyett csak a vonatkozó kurzusokra mutató ugrópontok lesznek láthatók. ';
$string['numquestions'] = 'Kérdésszám';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} rejtett)';
$string['opensslrecommended'] = 'Határozottan ajánlott az OpenSSL-könyvtár telepítése - ezzel kapcsolható be a hálózati Moodle.';
$string['opentogoogle'] = 'A Google engedélyezése';
$string['optionalmaintenancemessage'] = 'Opcionális karbantartási üzenet';
$string['order1'] = 'Első';
$string['order2'] = 'Második';
$string['order3'] = 'Harmadik';
$string['order4'] = 'Negyedik';
$string['passwordpolicy'] = 'Jelszószabvány';
$string['pathconvert'] = 'A <i>convert</i> bináris állomány útvonala';
$string['pathdvips'] = 'A <i>dvips</i> bináris állomány útvonala';
$string['pathlatex'] = 'A <i>latex</i> bináris állomány útvonala';
$string['pathtoclam'] = 'A clam vírusirtó útvonala';
$string['pathtodot'] = 'Útvonal a dothoz';
$string['pathtodot_help'] = 'Útvonal a dothoz. Például /usr/bin/dot. Ahhoz, hogy DOT-állományokból grafikát tudjon előállítani, rendelkeznie kell telepített dot-programmal és itt hivatkoznia kell rá. Jelenleg ez csak a Moodle-ba beépített profilfunkciókkal (Fejlesztés->Profilkészítés) használatos.';
$string['pathtodu'] = 'A du útvonala';
$string['pathtopgdump'] = 'A pg_dump útvonala';
$string['pathtopgdumpdesc'] = 'Ezt csak akkor kell megadni, ha egynél több pg_dump van a rendszerben (ha pl. a postgresql egynél több verziója van telepítve)';
$string['pathtopgdumpinvalid'] = 'Érvénytelen pg_dump-útvonal - vagy az útvonal hibás, vagy a kód nem futtatható';
$string['pathtopsql'] = 'A psql útvonala';
$string['pathtopsqldesc'] = 'Ezt csak akkor kell megadni, ha egynél több psql van a rendszerben (ha pl. a postgresql egynél több verziója van telepítve)';
$string['pathtopsqlinvalid'] = 'Érvénytelen psql-útvonal - vagy az útvonal hibás, vagy a kód nem futtatható';
$string['pathtounzip'] = 'Az unzip útvonala';
$string['pathtozip'] = 'A zip útvonala';
$string['perfdebug'] = 'Teljesítményről szóló tájékoztató';
$string['performance'] = 'Teljesítmény';
$string['pgcluster'] = 'PostgreSQL-fürt';
$string['pgclusterdescription'] = 'A PostgreSQL-verzió/-fürt paramétere parancssori műveletekhez. Ha csak egy postgresql van a rendszerén telepítve, illetve ha nem biztos abban, melyik van telepítve, akkor hagyja ezt a mezőt üresen.';
$string['php50restricted'] = 'A PHP 5.0.x számos ismert problémával rendelkezik, frissítsen 5.1.x-re vagy térjen vissza a 4.3.x vagy a 4.4.x változathoz';
$string['php533warning'] = 'Ajánlott a PHP 5.3.3 vagy későbbi verzió használata';
$string['phpfloatproblem'] = 'A PHP lebegőpontos számainak - {$a} - kezelésében váratlan hiba történt.';
$string['pleaserefreshregistration'] = 'Portáljának a moodle.org-on való regisztrálása megtörtént, ha számottevő változások történtek utolsó frissítés óta, kérjük, végezzen frissítést a(z) {$a} portálon';
$string['pleaseregister'] = 'A gomb eltávolításához regisztrálja portálját!';
$string['plugin'] = 'Segédprogram';
$string['plugins'] = 'Segédprogramok';
$string['profilecategory'] = 'Kategória';
$string['profilecategoryname'] = 'Kategórianév (egyedinek kell lennie)';
$string['profilecategorynamenotunique'] = 'Ezt a kategórianevet már használják';
$string['profilecommonsettings'] = 'Általános beállítások';
$string['profileconfirmcategorydeletion'] = 'Ebben a kategóriában olyan mező(k) van(nak), amely(ek) a felette lévő kategóriába kerül(nek) át (vagy - legfelső kategória esetén - az alá).<br />Biztosan törli a kategóriát?';
$string['profileconfirmfielddeletion'] = 'Ebben a mezőben felhasználói rekord(ok) van(nak), amely(ek)et a rendszer törölni fog.<br />Biztosan törli a mezőt?';
$string['profilecreatecategory'] = 'Új profilkategória létrehozása';
$string['profilecreatefield'] = 'Új profilmező létrehozása:';
$string['profilecreatenewcategory'] = 'Új kategória létrehozása';
$string['profilecreatenewfield'] = 'Új &quot;{$a}&quot; profilmező létrehozása';
$string['profiledefaultcategory'] = 'Egyéb mezők';
$string['profiledefaultchecked'] = 'Alaphelyzetben ellenőrizve';
$string['profiledefaultdata'] = 'Alapérték';
$string['profiledeletecategory'] = 'Kategória törlése';
$string['profiledeletefield'] = 'Mező törlése';
$string['profiledescription'] = 'A mező leírása';
$string['profiledscript'] = 'A kód bekerült a profilba.';
$string['profiledscriptview'] = 'A kód profiladatainak megtekintése';
$string['profileeditcategory'] = 'Kategória szerkesztése: {$a}';
$string['profileeditfield'] = 'Profilmező szerkesztése: {$a}';
$string['profilefield'] = 'Profilmező';
$string['profilefieldcolumns'] = 'Oszlopok';
$string['profilefieldispassword'] = 'Ez jelszómező?';
$string['profilefieldlink'] = 'Ugrópont';
$string['profilefieldlink_help'] = 'A szöveg ugróponttá alakításához adjon meg egy $$-t tartalmazó URL-t, ahol a $$ helyére kerül a szöveg. Például egy Twitter azonosító ugróponttá alakításához írja be a http://twitter.com/$$-t.';
$string['profilefieldlinktarget'] = 'Ugrópont célja';
$string['profilefieldmaxlength'] = 'Maximális hossz';
$string['profilefieldrows'] = 'Sorok';
$string['profilefields'] = 'Felhasználói profilmezők';
$string['profilefieldsize'] = 'Megjelenítési méret';
$string['profileforceunique'] = 'Az adatok egyediek legyenek?';
$string['profileinvaliddata'] = 'Érvénytelen érték';
$string['profilelocked'] = 'A mező zárolva van?';
$string['profilemenudefaultnotinoptions'] = 'Az alapérték nem szerepel a lehetőségek között';
$string['profilemenunooptions'] = 'Nincsenek megadva menüpontok';
$string['profilemenuoptions'] = 'Menüpontok (soronként egy)';
$string['profilemenutoofewoptions'] = 'Legalább két menüpontot meg kell adnia';
$string['profilename'] = 'Név';
$string['profilenofieldsdefined'] = 'Nincsenek megadva mezők';
$string['profilerequired'] = 'Szükség van erre a mezőre?';
$string['profileroles'] = 'Látható szerepek profilja';
$string['profilesforenrolledusersonly'] = 'Profil csak beiratkozott felhasználó esetén';
$string['profileshortname'] = 'Rövid név (egyedinek kell lennie)';
$string['profileshortnamenotunique'] = 'Ezt a rövid nevet már használják';
$string['profilesignup'] = 'Látsszon a belépési oldalon?';
$string['profilespecificsettings'] = 'Konkrét beállítások';
$string['profilevisible'] = 'Ki látja ezt a mezőt?';
$string['profilevisibleall'] = 'Mindenki látja';
$string['profilevisible_help'] = '<p>Az egyedi mezőkhöz háromféle láthatóság állítható be: láthatatlan, bárki és felhasználó. A láthatatlan általában a rendszergazda állítja be, ha a felhasználók magánadatait rejtve kívánja megőrizni. A \'felhasználó\' beállítás általában olyan mezőre vonatkozik, amely érzékeny adatot tartalmaz, míg a \'bárki\' tetszőleges információkat tartalmazhat.</p>';
$string['profilevisiblenone'] = 'Nem látható';
$string['profilevisibleprivate'] = 'A felhasználó látja';
$string['profiling'] = 'Profilkészítés';
$string['profilingallowall'] = 'Folyamatos profilkészítés';
$string['profilingallowall_help'] = 'Bekapcsolása esetén bármikor bárhol (PGC) használhatja a PROFILEALL paramétert az összes végrehajtott kód profilkészítéséhez a Moodle-folyamat teljes tartama alatt. Leállítására használja a PROFILEALLSTOP paramétert. ';
$string['profilingallowme'] = 'Választható profilkészítés';
$string['profilingallowme_help'] = 'Bekapcsolása esetén bárhol (PGC) használhatja a PROFILEME paramétert, és sor kerül az adott kód profilkészítésére. A profilkészítés megelőzésére használja a DONTPROFILEME paramétert. ';
$string['profilingautofrec'] = 'Automatikus profilkészítés';
$string['profilingautofrec_help'] = 'Beállítása esetén (véletlenszerűen, a megadott 1/XXX frekvencia alapján) kiválaszt valamely kérelmet és automatikusan elkészíti profilját, az eredményeket további elemzéshez eltárolja. Az ilyen profilkészítés tekintetbe veszi a beiktat/kihagy beállításokat. 0-ra állítva kikapcsolja az automatikus profilkészítést.';
$string['profilingenabled'] = 'Profilkészítés bekapcsolása';
$string['profilingenabled_help'] = 'Bekapcsolása esetén a portálon elérhető lesz a profilkészítés, melynek  viselkedését a következők szerint állíthatja be. ';
$string['profilingexcluded'] = 'Profilkészítés kihagyása';
$string['profilingexcluded_help'] = 'Azon (vesszővel elválasztott, a wwwroot útvonalat teljesen kihagyó, elérhető) URL-ek listája, amelyeket kihagy azon profilkészítésből, amely a \'Profilkészítés ezekről\' beállításban van megadva.';
$string['profilingincluded'] = 'Profilkészítés ezekről';
$string['profilingincluded_help'] = 'Azon (vesszővel elválasztott, a wwwroot útvonalat teljesen kihagyó, elérhető) URL-ek listája, amelyekről automatikusan profil készül. Pl.:  /index.php, /course/view.php. Also accepts the * wildchar at any position. Examples: /mod/forum/*, /mod/*/view.php. ';
$string['profilinglifetime'] = 'Profilkészítések megőrződjenek';
$string['profilinglifetime_help'] = 'Adja meg, mennyi ideig kívánja megőrizni a régi profilkészítéseket. A régiek időről időre törlődnek. A folyamatból kimaradnak a \'referenciaprofilok\' névvel megjelöltek.';
$string['protectusernames'] = 'Felhasználónevek védelme';
$string['proxybypass'] = 'Proxyt elkerülő gazdagépek';
$string['proxyhost'] = 'Proxy-gazdagép';
$string['proxypassword'] = 'Proxy-jelszó';
$string['proxyport'] = 'Proxy-port';
$string['proxytype'] = 'Proxy típusa';
$string['proxyuser'] = 'Proxy-felhasználó';
$string['purgecaches'] = 'Az összes gyorsítótár kiürítése';
$string['purgecachesconfirm'] = 'A Moodle gyorsítótárban tud kezelni stílusokat, javascriptet, nyelvi szövegeket, szűrt szövegeket, rss-híreket és egy sor egyéb, számított adatot. A gyorsítótárak kiürítése során ezek az adatok törlődnek a szerverről, a böngészőknek pedig újból be kell olvasni ezeket az adatokat, hogy mindenkor a legfrissebbek legyenek láthatók. A gyorsítótárak kiürítése nem veszélyes, de a portál működése lassabbnak tűnhet, amíg a szerver és az ügyfélprogramok kiszámítják és gyorsítótárba helyezik az új adatokat. ';
$string['purgecachesfinished'] = 'Az összes gyorsítótár kiürítése megtörtént.';
$string['qtypedeletefiles'] = 'A(z) \'{$a->qtype}\' kérdéstípushoz kapcsolódó összes adat törlődött az adatbázisból. A törlés befejezéséhez (és a kérdéstípus visszatelepülésének megakadályozásához) szerveréről törölnie kell ezt a könyvtárat: {$a->directory}.';
$string['qtyperqpwillberemoved'] = 'Frissítés közben az RQP-kérdéstípus törlődik. Ön nem használta ezt a kérdéstípust, ezért nem lesz gondja ezzel kapcsolatban.';
$string['qtyperqpwillberemovedanyway'] = 'Frissítés során törlődik az RQP kérdéstípus. Mivel adatbázisában szerepelnek RQP-kérdések, ezek használhatatlanok lesznek, ha nem telepíti újra a kódot a http://moodle.org/mod/data/view.php?d=13&amp;rid=797 weboldalról, mielőtt folytatja a frissítést.';
$string['quarantinedir'] = 'Karanténkönyvtár';
$string['question'] = 'Kérdés';
$string['questioncwqpfscheck'] = 'Valamely tesztben egy vagy több \'véletlenszerűen kiválasztott\' kérdés úgy van beállítva, hogy megosztott és megosztatlan kérdéskategóriák egyvelegéből válasszon kérdéseket. Részletesebb beszámolót olvashat erről <a href="{$a->reporturl}">itt</a> és a Moodle Docs oldalon <a href="{$a->docsurl}">itt</a>.';
$string['questioncwqpfsok'] = 'Rendben. Tesztjei között nem szerepelnek  \'véletlenszerűen kiválasztott\', megosztott és megosztatlan kérdéskategóriák egyvelegéből választandó kérdések.';
$string['questiontype'] = 'Kérdéstípus';
$string['questiontypes'] = 'Kérdéstípusok';
$string['rcache'] = 'Rekordgyorsítótár';
$string['rcachettl'] = 'TTL típusú rekordgyorsítótár';
$string['recaptchaprivatekey'] = 'A ReCAPTCHA magánkulcsa';
$string['recaptchapublickey'] = 'A ReCAPTCHA nyilvános kulcsa';
$string['registration'] = 'Regisztráció';
$string['releasenoteslink'] = 'A Moodle ezen verziójának adataival kapcsolatosan olvassa el az online <a target="_blank" href="{$a}">Változatra vonatkozó megjegyzések</a>et';
$string['remotelangnotavailable'] = 'Mivel a Moodle nem képes a download.moodle.org-hoz kapcsolódni, a nyelvi csomag nem telepíthető automatikusan. Töltse le a megfelelő tömörített állomány(oka)t a http://download.moodle.org portálról, másolja a {$a} könyvtárába és kézzel csomagolja ki őket.';
$string['renameerrors'] = 'Átnevezési hibák';
$string['requiredentrieschanged'] = '<strong>FONTOS - OLVASSA EL!<br/>(Ez a figyelmeztetés csak ezen verziófrissítés alkalmával jelenik meg)</strong><br/>Hibajavítás miatt a \'Kitöltendő bejegyzések\' és a \'Megtekintés beállítása előtti kitöltendő bejegyzések\' beállításokat használó adatbázis-tevékenységek viselkedése módosulni fog. Részletesebben lásd az <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">adatbázismodul fórumát</a>. Az elvárt viselkedésről olvashat itt is: <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>. <br/><br/>A változás az Ön rendszerében az alábbi adatbázisokat fogja érinteni: (a listát most is és verziófrissítés után is mentse el, és ellenőrizze, hogy a tevékenységek továbbra is a tanár szándékainak megfelelően működnek-e.)<br/><strong>{$a->text}</strong><br/>';
$string['requiredtemplate'] = 'Kitöltendő. Itt használhat sablonszintaxist (%l = vezetéknév, %f = keresztnév, %u = felhasználónév). A részleteket és a példákat lásd a súgóban!';
$string['requiremodintro'] = 'Tevékenység leírásának előírása';
$string['requires'] = 'Kitöltendő.';
$string['restrictbydefault'] = 'Modulok korlátozása alapesetben';
$string['restrictmodulesfor'] = 'Modulok korlátozása:';
$string['reverseproxy'] = 'Fordított proxy';
$string['riskconfig'] = 'A felhasználók módosíthatják a portál beállításait és működését';
$string['riskconfigshort'] = 'Konfigurációs veszély';
$string['riskdataloss'] = 'A felhasználók terjedelmes tartalmat és információkat tehetnek tönkre.';
$string['riskdatalossshort'] = 'Adatvesztés kockázata';
$string['riskmanagetrust'] = 'A felhasználók módosíthatják más felhasználók megbízhatósági beállításait';
$string['riskmanagetrustshort'] = 'Megbízhatóság kezelése';
$string['riskpersonal'] = 'A felhasználók hozzáférhetnek más felhasználók magánadataihoz';
$string['riskpersonalshort'] = 'Személyes adatok veszélyben';
$string['riskspam'] = 'A felhasználók levélszemetet küldhetnek a portál felhasználóinak és másoknak';
$string['riskspamshort'] = 'Levélszemétveszély';
$string['riskxss'] = 'A felhasználók hozzáadhatnak portálok közötti kódolást (XSS) engedélyező állományokat és szövegeket';
$string['riskxssshort'] = 'XSS-veszély';
$string['roleswithexceptions'] = '{$a->roles}, {$a->exceptions} kivétellel';
$string['rowpreviewnum'] = 'Sorok előnézete';
$string['rssglobaldisabled'] = 'Szerverszinten kikapcsolva';
$string['runclamavonupload'] = 'A clam vírusirtó használata feltöltött állományokhoz';
$string['save'] = 'Mentés';
$string['savechanges'] = 'Változások mentése';
$string['search'] = 'Keresés';
$string['searchinsettings'] = 'Keresés a beállítások között';
$string['searchresults'] = 'Keresési eredmények';
$string['sectionerror'] = 'Szekcióhiba!';
$string['secureforms'] = 'Kiegészítő űrlapbiztonság használata';
$string['security'] = 'Biztonság';
$string['server'] = 'Szerver';
$string['serverchecks'] = 'Szerverellenőrzések';
$string['serverlimit'] = 'Szerverkorlát';
$string['sessionautostartwarning'] = '<p>Súlyos beállítási hiba lépett föl, tájékoztassa a rendszergazdát.</p><p>A Moodle megfelelő működéséhez a rendszergazdának módosítania kell a PHP beállításait.</p><p>A <code>session.auto_start</code> <code>off</code>-ra állítandó.</p><p>Ezt a szerveren a <code>php.ini</code> fájlnak, az Apache/IIS <br />konfigurációjának vagy a <code>.htaccess</code> fájlnak a szerkesztésével érheti el.</p>';
$string['sessioncookie'] = 'Süti előtagja';
$string['sessioncookiedomain'] = 'Süti doménje';
$string['sessioncookiepath'] = 'Süti útvonala';
$string['sessionhandling'] = 'Folyamat kezelése';
$string['sessiontimeout'] = 'Időtúllépés';
$string['settingfileuploads'] = 'A szokásos működéshez állományfeltöltésre van szükség, engedélyezze a PHP beállításában.';
$string['settingmemorylimit'] = 'Kevés a memória, állítsa be magasabbra a PHP beállításában.';
$string['settingsafemode'] = 'A Moodle nem teljesen kompatibilis a csökkentett üzemmóddal, kérje meg a rendszergazdát, hogy kapcsolja ki. Ha csökkentett üzemmódban futtatja a Moodle-t, különféle problémákra kell felkészülnie.';
$string['showcommentscount'] = 'Megjegyzések számának kijelzése';
$string['showdetails'] = 'Részletek megtekintése';
$string['simpletest'] = 'Egységek ellenőrzése';
$string['simplexmlrequired'] = 'A Moodle most már előírja a SimpleXML PHP-bővítményt .';
$string['sitelangchanged'] = 'A portál nyelvének módosítása sikerült';
$string['sitemailcharset'] = 'Karakterkészlet';
$string['sitemaintenance'] = 'A portálon karbantartás folyik, jelenleg nem elérhető';
$string['sitemaintenancemode'] = 'Karbantartási üzemmód';
$string['sitemaintenanceoff'] = 'A karbantartási üzemmód kikapcsolva, a portál ismét a szokásos módon üzemel';
$string['sitemaintenanceon'] = 'Portálja jelenleg karbantartási üzemmódban van (a portálra csak rendszergazdák jelentkezhetnek be).';
$string['sitemaintenancewarning'] = 'Portálja jelenleg karbantartási üzemmódban van (csak rendszergazdák jelentkezhetnek be). Szokásos üzemmódba való visszatéréshez <a href="maintenance.php">kapcsolja ki a karbantartási üzemmódot</a>.';
$string['sitemaintenancewarning2'] = 'Portálja most karbantartási módban üzemel (csak rendszergazdák jelentkezhetnek be). A normál üzemmód visszaállításához  <a href="{$a}">kapcsolja ki a karbantartási módot</a>.';
$string['sitepolicies'] = 'Portálszabványok';
$string['sitepolicy'] = 'Portálszabvány URL-je';
$string['sitepolicyguest'] = 'Portálszabvány URL-je vendégek számára';
$string['sitepolicyguest_help'] = 'Ha létezik olyan portálszabványa, amelyet a vendégeknek belépés előtt el kell olvasni és el kell fogadni, akkor annak URL-jét adja meg itt. Ellenkező esetben hagyja a mezőt üresen. A beállítás tartalmazhat bármilyen nyilvános URL-t. Megjegyzés: ha be nem lépett felhasználók hozzáférését kívánja korlátozni, ezt a belépés előírásával teheti meg.';
$string['sitepolicy_help'] = 'Ha olyan portálszabványa van, amely szerint azt belépés előtt minden regisztrált felhasználónak el kell olvasni és el kell fogadni, akkor annak URL-jét adja meg itt. Ellenkező esetben hagyja a mezőt üresen. A beállítás tartalmazhat bármilyen nyilvános URL-t. ';
$string['sitesectionhelp'] = 'Kiválasztása esetén a stílusszekció megjelenik a portál kezdőoldalán.';
$string['slasharguments'] = 'Perjeles argumentumok használata';
$string['smartpix'] = 'Smart pix szerinti keresés';
$string['smtphosts'] = 'SMTP-gazdagépek';
$string['smtpmaxbulk'] = 'Az SMTP-folyamat korlátja';
$string['smtppass'] = 'SMTP-jelszó';
$string['smtpuser'] = 'SMTP-felhasználó';
$string['soaprecommended'] = 'A soap-kiegészítés telepítése webszolgáltatások és egyes külső fejlesztésű modulok esetén hasznos lehet.';
$string['spellengine'] = 'Helyesírásmotor';
$string['splrequired'] = 'A Moodle előírja az SPL PHP-bővítményt.';
$string['stats'] = 'Statisztika';
$string['statsfirstrun'] = 'Maximális feldolgozási intervallum';
$string['statsmaxruntime'] = 'Maximális futásidő';
$string['statsruntimedays'] = 'Földolgozandó napok';
$string['statsruntimestart'] = 'Végrehajtás időpontja';
$string['statsuserthreshold'] = 'Felhasználói küszöbérték';
$string['stickyblocks'] = 'Megmaradó blokkok';
$string['stickyblockscourseview'] = 'Kurzusoldal';
$string['stickyblocksduplicatenotice'] = 'Ha ide beszúr egy blokkot, amely már létezik egy másik oldalon, akkor másodpéldány jön létre.<br />Csak a rögzített blokkot nem tudja szerkeszteni, a másodpéldányt viszont igen.';
$string['stickyblocksmymoodle'] = 'Az én Moodle-om';
$string['stickyblockspagetype'] = 'Beállítandó oldaltípus';
$string['strictformsrequired'] = 'A kitöltendő mezők szigorú ellenőrzése';
$string['stripalltitletags'] = 'Minden tevékenységnévből törölje a HTML-címkéket.';
$string['supportemail'] = 'Támogatói e-mail';
$string['supportname'] = 'Támogató neve';
$string['supportpage'] = 'Támogató oldala';
$string['switchlang'] = 'Nyelvi könyvtárak közötti váltás';
$string['systempaths'] = 'Rendszerútvonalak';
$string['tablenosave'] = 'A fenti táblázat módosításainak mentése automatikus';
$string['tablesnosave'] = 'A fenti táblázatok módosításainak mentése automatikus';
$string['tabselectedtofront'] = 'Tabulátoros táblázatokban a kiválasztott elemet tartalmazó sor elölre kerüljön.';
$string['tabselectedtofronttext'] = 'Fülek kiválasztott sorának előtérbe hozása';
$string['themedesignermode'] = 'Stílustervező üzemmód';
$string['themelist'] = 'Stílusjegyzék';
$string['themeresetcaches'] = 'Stílust tartalmazó gyorsítótárak törlése';
$string['themeselector'] = 'Stílusválasztó';
$string['themesettings'] = 'Stílusbeállítások';
$string['therewereerrors'] = 'Adataiban hiba volt';
$string['timezone'] = 'Alapidőzóna';
$string['timezoneforced'] = 'Ezt a portál rendszergazdája írja elő';
$string['timezoneisforcedto'] = 'Használatának előírása minden felhasználó számára';
$string['timezonenotforced'] = 'A felhasználók kiválaszthatják saját időzónájukat';
$string['tokenizerrecommended'] = 'Ajánlott a PHP Tokenizer bővítmény telepítése - javítja a hálózati Moodle használhatóságát.';
$string['unattendedoperation'] = 'Felügyelet nélküli működtetés';
$string['unbookmarkthispage'] = 'Oldal könyvjelzőjének eltávolítása';
$string['unicoderecommended'] = 'Ajánlott minden adatot unikódban (UTF-8) tárolni. Az új telepítéseket unikód alapkészletű adatbázisokba kell telepíteni. Ha újabb változatra vált, végre kell hajtania az UTF-8-ra való áttérést (lásd a Portáladminisztráció oldalát).';
$string['unicoderequired'] = 'Minden adatot unikódban (UTF-8) kell tárolni. Az új telepítéseket unikód alapkészletű adatbázisokba kell telepíteni. Ha újabb változatra vált, végre kell hajtania az UTF-8-ra való áttérést (lásd a Portáladminisztráció oldalát).';
$string['unicodeupgradenotice'] = 'A Moodle 1.6 változatában minden nyelvi dokumentáció unikóddá lett átalakítva. A portál frissítéséhez adatbázisának minden adatát az áttelepítő programunk segítségével unikód (UTF-8) formájúvá kell alakítania. <a href="utfdbmigrate.php">Ide kattintva futtathatja az áttelepítő kódot</a>!';
$string['uninstall'] = 'Kiválasztott nyelvi csomag törlése';
$string['uninstallconfirm'] = 'A {$a} nyelvi csomagot teljesen eltávolítja, biztosan ezt akarja tenni?';
$string['uninstallplugin'] = 'Eltávolítás';
$string['uninstallqtype'] = 'A kérdéstípus eltávolítása.';
$string['unsupported'] = 'Nem támogatott';
$string['updateaccounts'] = 'Meglévő fiókok frissítése';
$string['updatecomponent'] = 'Összetevő frissítése';
$string['updatelangs'] = 'Minden telepített nyelvi csomag frissítése';
$string['updatetimezones'] = 'Időzónák frissítése';
$string['upgrade197notice'] = '<p>A Moodle 1.9.7 egy sor jelszóval és biztonsági mentéssel kapcsolatos biztonsági javítást tartalmaz a portálján tárolt felhasználói adatok védelme érdekében. Ezért egyes biztonsági mentéssel kapcsolatos beállításai és engedélyei módosulhattak.<br />
A részleteket lásd itt: <a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">A Moodle 1.9.7 verzió megjegyzései</a>.</p>';
$string['upgrade197noticesubject'] = 'A Moodle 1.9.7 frissítésének biztonsági megjegyzései';
$string['upgrade197salt'] = 'A jelszólopás elkerülése érdekében ajánlatos zajos jelszót beállítani.<br />A részleteket l. a <a href="{$a}" target="_blank">jelszó zajossá tételéről szóló dokumentációban</a>.';
$string['upgradeerror'] = 'Ismeretlen hiba {$a->plugin} {$a->version} verzióra frissítése során, a Moodle leáll.';
$string['upgradeforumread'] = 'A Moodle 1.5 új elemmel bővült az elolvasott/még nem olvasott fórumhozzászólások nyomon követésére.<br />Ennek használatához <a href="{$a}">frissítenie kell táblázatait</a>.';
$string['upgradeforumreadinfo'] = 'A Moodle 1.5 új elemmel bővült az elolvasott/még nem olvasott fórumhozzászólások nyomon követésére. Ennek használatához frissítenie kell táblázatait az összes meglévő hozzászólásra vonatkozó nyomon követési információval. A portál méretétől függően ez hosszú időbe (akár órákba) telhet és igénybe veheti az adatbázis erőforrását, ezért ennek elvégzésére célszerű egy nyugodtabb időszakot kiválasztani. Ugyanakkor a portál a frissítés alatt továbbra is üzemel, a felhasználókat ez nem érinti. Ha a folyamatot elindítja, hagyja, hogy véget érjen (a böngésző ablakát tartsa nyitva). Ha mégis becsukná, semmi probléma, újrakezdheti.<br /><br />Most akarja elindítani a frissítést?';
$string['upgradelogs'] = 'Az összes funkció működéséhez minden régi naplóállományt frissíteni kell. <a href="{$a}">További tájékoztatás</a>';
$string['upgradelogsinfo'] = 'A naplóállományok tárolásában nemrégiben változásokra került sor. Ha a régebbi naplóállományokat tevékenységek szerint kívánja megtekinteni, akkor ezeket frissítenie kell. Ez az adott portáltól függően sok időt (akár órákat) vehet igénybe és meglehetősen megterhelheti a nagyobb portálok adatbázisait. Ha nekilát a folyamatnak, hagynia kell, hogy befejeződjék (azaz a böngésző ablakát hagyja nyitva). A naplóállományok frissítése közben a portál mások számára minden gond nélkül üzemel.<br /><br />Most kívánja frissíteni a naplóállományait?';
$string['upgradesettings'] = 'Új beállítások';
$string['upgradesettingsintro'] = 'Az alábbi beállítások hozzáadása a Moodle utolsó verziófrissítése óta történt. Az alapbeállításokon hajtsa végre a szükséges módosításokat, majd kattintson az oldal alján lévő &quot;Beállítások mentése&quot; pontra.';
$string['upgradestart'] = 'Verziófrissítés';
$string['upgradesure'] = 'Moodle-állományai módosultak, szerverét pedig automatikusan erre a változatra frissíti:  <strong>{$a}</strong> <br /><br /> Ha ez megtörtént, nem lesz módja a visszatérésre. <br /><br /> A folyamat elég sokáig tarthat. <br /><br /> Biztosan frissíti a szervert erre a változatra?';
$string['upgradetimedout'] = 'A frissítési idő lejárt, indítsa újra a frissítést.';
$string['upgradingdata'] = 'Adatok frissítése';
$string['upgradinglogs'] = 'Naplóállományok frissítése';
$string['upgradingversion'] = 'Frissítés új verzióra';
$string['uploadpicture_baduserfield'] = 'A megadott felhasználói attribútum érvénytelen.';
$string['uploadpicture_cannotmovezip'] = 'A tömörített állomány nem helyezhető át ideiglenes könyvtárba.';
$string['uploadpicture_cannotprocessdir'] = 'A kibontott állományokat nem lehet feldolgozni.';
$string['uploadpicture_cannotsave'] = 'A(z) {$a} felhasználó képállományát nem lehet elmenteni. Ellenőrizze az eredeti képállományt.';
$string['uploadpicture_cannotunzip'] = 'A képállományt nem lehet kibontani.';
$string['uploadpicture_invalidfilename'] = 'A(z) {$a} képállomány nevében érvénytelen karakterek vannak.';
$string['uploadpicture_overwrite'] = 'Felülírja a meglévő felhasználói képeket?';
$string['uploadpictures'] = 'Felhasználók képének feltöltése';
$string['uploadpictures_help'] = 'Felhasználói képeket képállományokból készített tömörített fájlként tölthet fel. A képállományokat kiválasztott-felhasználói-attribútum.kiterjesztés formában kell elnevezni. Ha például a képek megfeleltetéséhez a kiválasztott felhasználói attribútum a felhasználónév, a felhasználó neve pedig user1234, akkor az állomány neve user1234.jpg lesz.';
$string['uploadpicture_userfield'] = 'A képekhez kapcsolódó felhasználói attribútum:';
$string['uploadpicture_usernotfound'] = '\'{$a->userfield}\' értékű \'{$a->uservalue}\' felhasználó nem létezik.';
$string['uploadpicture_userskipped'] = 'A(z) {$a} felhasználó kihagyva (már van képe).';
$string['uploadpicture_userupdated'] = 'A(z) {$a} felhasználó képe frissítve.';
$string['uploadusers'] = 'Felhasználók feltöltése';
$string['uploadusers_help'] = 'A felhasználókat feltöltheti (és adott esetben beiratkoztathatja) szöveges állományból is. A szöveget az alábbiak szerint kell megformáznia:

* Az állomány minden sora egy rekordot tartalmazzon.
* Minden rekord egy-egy vesszőkkel (vagy más határoló karakterekkel) elválasztott adatsort tartalmazzon.
* Az állomány első a mezőneveket tartalmazza, melyek meghatározzák az állomány fennmaradó részének a szerkezetét.
* Előírt mezőnevek: felhasználónév, jelszó, keresztnév, vezetéknév, e-mail cím';
$string['uploaduserspreview'] = 'Felhasználók feltöltésének előzetes megtekintése';
$string['uploadusersresult'] = 'Felhasználók feltöltésének eredménye';
$string['upwards'] = 'felfelé';
$string['useblogassociations'] = 'Társítások bekapcsolása';
$string['useexternalyui'] = 'Használjon online YUI-könyvtárakat';
$string['usehtmleditor'] = 'HTML-szerkesztő használata';
$string['user'] = 'Felhasználó';
$string['useraccountupdated'] = 'Felhasználó frissítve';
$string['useraccountuptodate'] = 'Felhasználó frissítve';
$string['userbulk'] = 'Vegyes felhasználói lépések';
$string['userdeleted'] = 'Felhasználó törölve';
$string['userlist'] = 'Felhasználók felsorolásának böngészése';
$string['userpolicies'] = 'Felhasználói szabványok';
$string['userpreference'] = 'Felhasználói beállítások';
$string['userquota'] = 'Felhasználói kvóta';
$string['userrenamed'] = 'Átnevezett felhasználó';
$string['users'] = 'Felhasználók';
$string['userscreated'] = 'Létrehozott felhasználók';
$string['usersdeleted'] = 'Törölt felhasználók';
$string['usersrenamed'] = 'Átnevezett felhasználók';
$string['usersskipped'] = 'Kihagyott felhasználók';
$string['usersupdated'] = 'Frissített felhasználók';
$string['usersweakpassword'] = 'Gyenge jelszóval rendelkező felhasználók';
$string['usetags'] = 'Címkék működésének bekapcsolása';
$string['uubulk'] = 'Tömeges művelethez kiválaszt';
$string['uubulkall'] = 'Minden felhasználó';
$string['uubulknew'] = 'Új felhasználók';
$string['uubulkupdated'] = 'Frissített felhasználók';
$string['uucsvline'] = 'CSV-sor';
$string['uulegacy1role'] = '(Eredeti tanuló) típusszám=1';
$string['uulegacy2role'] = '(Eredeti tanár) típusszám=2';
$string['uulegacy3role'] = '(Eredeti nem tananyagszerkesztő tanár) típusszám=3';
$string['uunoemailduplicates'] = 'E-mail címek ismétlődésének megakadályozása';
$string['uuoptype'] = 'Típus feltöltése';
$string['uuoptype_addinc'] = 'Mind hozzáadása, szükség esetén számláló hozzákapcsolása a felhasználónevekhez';
$string['uuoptype_addnew'] = 'Csak újak hozzáadása, meglévő felhasználók kihagyása';
$string['uuoptype_addupdate'] = 'Újak hozzáadása és meglévő felhasználók frissítése';
$string['uuoptype_update'] = 'Csak meglévő felhasználók frissítése';
$string['uupasswordcron'] = 'A cron állítja elő';
$string['uupasswordnew'] = 'Új felhasználói jelszó';
$string['uupasswordold'] = 'Meglévő felhasználói jelszó';
$string['uustandardusernames'] = 'Felhasználónevek szabványosítása';
$string['uuupdateall'] = 'Állománnyal és alapbeállításokkal való felülírás';
$string['uuupdatefromfile'] = 'Állománnyal való felülírás';
$string['uuupdatemissing'] = 'Hiányzó állományból és alapbeállításokból való kitöltése';
$string['uuupdatetype'] = 'Meglévő felhasználó adatai';
$string['uuusernametemplate'] = 'Felhasználónév-sablon';
$string['validateerror'] = 'Ez az érték nem érvényes:';
$string['verifychangedemail'] = 'Domének korlátozása e-mail módosításakor';
$string['warningcurrentsetting'] = 'Érvénytelen aktuális érték: {$a}';
$string['webproxy'] = 'Web-proxy';
$string['webproxyinfo'] = 'Töltse ki az alábbi lehetőségeket, ha Moodle-szerverének nincs közvetlen hozzáférése az internethez. Internet-hozzáférés szükséges környezeti adatok, nyelvi csomagok, RSS-hírek, időzónák stb. letöltéséhez.<br /><em>Használja a PHP cURL-bővítményét.</em>';
$string['xmlrpcrecommended'] = 'Az xmlrpc-bővítmény az elosztó kommunikációjához szükséges, és hasznos a webszolgáltatások és a hálózati Moodle használatához.';
$string['xmlstrictheaders'] = 'Szigorú XML-fejlécek';
$string['yuicomboloading'] = 'YUI-kombó betöltése';
$string['ziprequired'] = 'A Moodle a Zip PHP bővítményt igényli, az info-ZIP bináris állományokra vagy a PclZip könyvtárra már nincs szükség.';
