<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'fr', branch 'MOODLE_20_STABLE'
 *
 * @package   scorm
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Activation';
$string['activityloading'] = 'Vous allez être dirigé automatiquement vers l\'activité dans';
$string['activitypleasewait'] = 'Activité en cours de chargement. Veuillez patienter...';
$string['advanced'] = 'Paramètres';
$string['allowapidebug'] = 'Activer l\'API de débogage et de tracement (veuillez spécifier le masque de capture)';
$string['allowtypeexternal'] = 'Activer le type de paquetage externe';
$string['allowtypeimsrepository'] = 'Activer le type de paquetage IMS';
$string['allowtypelocalsync'] = 'Activer le type de paquetage téléchargé';
$string['apidebugmask'] = 'Masque de capture de l\'API de débogage (simple expression régulière sur <username>:<activityname>). Par exemple, admin:.* ne déboguera que l\'utilisateur admin';
$string['areacontent'] = 'Contenu des fichiers';
$string['areapackage'] = 'Fichier de paquetage';
$string['asset'] = 'Élément';
$string['assetlaunched'] = 'Élément - affiché';
$string['attempt'] = 'tentative';
$string['attempt1'] = '1 tentative';
$string['attempts'] = 'tentatives';
$string['attemptsx'] = '{$a} tentatives';
$string['attr_error'] = 'Valeur incorrecte de l\'attribut ({$a->attr}) dans la balise {$a->tag}.';
$string['autocontinue'] = 'Continuer automatiquement';
$string['autocontinuedesc'] = 'Ce réglage détermine si par défaut l\'activité continue automatiquement ou non';
$string['autocontinue_help'] = '<!-- $Id$ -->


<p>Si l\'option « Continuer automatiquement » est activée, l\'objet d\'apprentissage suivant est automatiquement lancé lorsque le précédent objet d\'apprentissage appelle la méthode standard « close communication.»</p>

<p>Si elle n\'est pas activée, l\'apprenant doit cliquer explicitement le bouton « Continuer » pour obtenir l\'exercice ou l\'étape suivante.</p>';
$string['averageattempt'] = 'Moyenne des tentatives';
$string['badmanifest'] = 'Erreurs dans le fichier « manifest » : veuillez consulter l\'historique des erreurs';
$string['badpackage'] = 'Le paquetage/manifeste indiqué n\'est pas valide. Veuillez le vérifier et essayer à nouveau.';
$string['browse'] = 'Prévisualiser';
$string['browsed'] = 'Consulté';
$string['browsemode'] = 'Mode prévisualisation';
$string['browserepository'] = 'Consulter le dépôt';
$string['cannotfindsco'] = 'Objet d\'apprentissage introuvable';
$string['chooseapacket'] = 'Sélectionner ou mettre à jour un paquetage';
$string['completed'] = 'Terminé';
$string['confirmloosetracks'] = 'Attention ! Le paquetage semble avoir été modifié. Si sa structure a été modifiée, les historiques de certains utilisateurs (tracking) seront perdus lors du processus de mise à jour.';
$string['contents'] = 'Contenus';
$string['coursepacket'] = 'Paquetage du cours';
$string['coursestruct'] = 'Structure du cours';
$string['currentwindow'] = 'Fenêtre courante';
$string['datadir'] = 'Erreur du système de fichier : impossible de créer le dossier de données du cours';
$string['deleteallattempts'] = 'Supprimer toutes les tentatives de SCORM';
$string['deleteattemptcheck'] = 'Voulez-vous vraiment supprimer totalement ces tentatives ?';
$string['details'] = 'Détails du parcours';
$string['directories'] = 'Afficher les liens de dossier';
$string['display'] = 'Afficher le paquetage';
$string['displayattemptstatus'] = 'Afficher l\'état de la tentative';
$string['displayattemptstatusdesc'] = 'Ce réglage détermine si par défaut l\'état de la tentative doit être affiché ou non';
$string['displayattemptstatus_help'] = 'Si ce réglage est activé, les scores et notes des tentatives seront affichés dans le résumé du SCORM.';
$string['displaycoursestructure'] = 'Afficher la structure du cours sur la page d\'entrée';
$string['displaycoursestructuredesc'] = 'Ce réglage détermine si par défaut la structure du cours doit être affichée ou non sur la page d\'entrée';
$string['displaycoursestructure_help'] = 'Si ce réglage est activé, la table des matières sera affichée dans le résumé du SCORM.';
$string['displaydesc'] = 'Ce réglage détermine si par défaut le paquetage de l\'activité doit être affiché ou non';
$string['domxml'] = 'Bibliothèque externe DOMXML';
$string['duedate'] = 'Date de remise';
$string['element'] = 'Élément';
$string['enter'] = 'Entrer';
$string['entercourse'] = 'Commencer le cours';
$string['errorlogs'] = 'Historique des erreurs';
$string['everyday'] = 'Chaque jour';
$string['everytime'] = 'À chaque utilisation';
$string['exceededmaxattempts'] = 'Vous avez atteint le nombre maximum de tentatives.';
$string['exit'] = 'Terminer le cours';
$string['exitactivity'] = 'Terminer l\'activité';
$string['expired'] = 'Désolé, cette activité s\'est terminée le {$a} et n\'est plus disponible';
$string['external'] = 'Mise à jour des paquetages externes';
$string['failed'] = 'Échec';
$string['finishscorm'] = 'Si vous avez fini de consulter cette ressource, {$a}';
$string['finishscormlinkname'] = 'cliquez ici pour revenir à la page de cours';
$string['firstaccess'] = 'Premier accès';
$string['firstattempt'] = 'Première tentative';
$string['forcecompleted'] = 'Imposer de terminer';
$string['forcecompleteddesc'] = 'Ce réglage détermine si par défaut il est imposé de terminer l\'activité ou non';
$string['forcecompleted_help'] = 'Si ce réglage est activé, l\'état de la tentative actuelle est forcé sur « Terminé ». Ce réglage n\'est valable que pour les paquetages SCORM 1.2. Il est utile si le paquetage ne traite pas correctement les consultations ultérieures d\'une tentative dans le mode relecture ou consultation, ou lors d\'autres problèmes avec l\'état d\'achèvement.';
$string['forcejavascript'] = 'Forcer les utilisateurs à activer JavaScript';
$string['forcejavascript_desc'] = 'Si ce réglage est activé (recommandé), il empêche l\'accès aux objets SCORM lorsque JavaScript est désactivé ou n\'est pas supporté dans le navigateur de l\'utilisateur. Si le réglage est désactivé, l\'utilisateur pourra voir le SCORM, mais les communications entre le serveur et le navigateur ne fonctionneront pas et aucune information d\'évaluation ne sera enregistrée.';
$string['forcejavascriptmessage'] = 'JavaScript est requis pour voir cet élément. Veuillez activer JavaScript dans votre navigateur et essayer à nouveau.';
$string['forcenewattempt'] = 'Imposer une nouvelle tentative';
$string['forcenewattemptdesc'] = 'Ce réglage détermine si par défaut une nouvelle tentative sera imposée ou non';
$string['forcenewattempt_help'] = 'Si ce réglage est activé, une nouvelle tentative est comptée chaque fois que le paquetage SCORM est consulté.';
$string['found'] = 'Fichier « manifest » trouvé';
$string['frameheight'] = 'Ce réglage détermine la hauteur par défaut du cadre ou de la fenêtre';
$string['framewidth'] = 'Ce réglage détermine la largeur par défaut du cadre ou de la fenêtre';
$string['fullscreen'] = 'Remplir tout l\'écran';
$string['general'] = 'Généralités';
$string['gradeaverage'] = 'Note moyenne';
$string['gradeforattempt'] = 'Note de la tentative';
$string['gradehighest'] = 'Note la plus haute';
$string['grademethod'] = 'Méthode d\'évaluation';
$string['grademethoddesc'] = 'Ce réglage détermine la méthode d\'évaluation par défaut de l\'activité';
$string['grademethod_help'] = 'La méthode de notation définit comment la note d\'une tentative est calculée.

Il y a 4 méthodes possibles pour cela :

* Objets complétés : le nombre d\'objets d\'apprentissage complétés/réussis de l\'activité
* Note la plus haute : le plus haut score AICC obtenu dans les objets d\'apprentissage achevés
* Note moyenne : la moyenne des scores AICC obtenus
* Somme : la somme des scores AICC obtenus';
$string['gradereported'] = 'Note envoyée';
$string['gradescoes'] = 'Objets d\'apprentissage';
$string['gradesum'] = 'Note totale';
$string['height'] = 'Hauteur';
$string['hidden'] = 'Invisible';
$string['hidebrowse'] = 'Désactiver le mode prévisualisation';
$string['hidebrowsedesc'] = 'Ce réglage détermine si par défaut le mode prévisualisation doit être activé ou non';
$string['hidebrowse_help'] = '<!-- $Id$ -->


<p>En choisissant Oui, le bouton de prévisualisation de l\'activité SCORM/AICC sera caché.</p>

<p>L\'étudiant peut choisir de prévisualiser (parcourir) l\'activité ou de réaliser une tentative en mode normal.</p>

<p>Lorsqu\'un objet d\'apprentissage est achevé en mode prévisualisation, il est signalé par l\'icône <img src="<?php echo $CFG->wwwroot.\'/mod/scorm/pix/browsed.gif\' ?>" alt="<?php print_string(\'browsed\',\'scorm\') ?>" title="<?php print_string(\'browsed\',\'scorm\') ?>" />.</p>';
$string['hideexit'] = 'Masquer le bouton de sortie';
$string['hidenav'] = 'Masquer les boutons de navigation';
$string['hidenavdesc'] = 'Ce réglage détermine si par défaut les boutons de navigation doivent être affichés ou non';
$string['hidereview'] = 'Masquer le bouton de relecture';
$string['hidetoc'] = 'Affichage de la structure du cours dans le lecteur';
$string['hidetocdesc'] = 'Ce réglage détermine comment doit être affichée par défaut la structure du cours (table des matières) dans le lecteur SCORM';
$string['hidetoc_help'] = 'Ce réglage détermine comment est affichée la table des matières dans le lecteur SCORM';
$string['highestattempt'] = 'Meilleure tentative';
$string['identifier'] = 'Identifiant de question';
$string['incomplete'] = 'Incomplet';
$string['info'] = 'Info';
$string['interactions'] = 'Interactions';
$string['invalidactivity'] = 'L\'activité SCORM n\'est pas correcte';
$string['last'] = 'Dernier accès le';
$string['lastaccess'] = 'Dernier accès';
$string['lastattempt'] = 'Dernière tentative';
$string['lastattemptlock'] = 'Verrouiller après la tentative finale';
$string['lastattemptlockdesc'] = 'Ce réglage détermine si par défaut l\'activité doit être verrouillée après la tentative finale';
$string['lastattemptlock_help'] = 'Si ce réglage est activé, les étudiants ne peuvent plus lancer le lecteur SCORM une fois qu\'ils ont épuisé le nombre de tentatives qui leur sont allouées.';
$string['location'] = 'Afficher la barre d\'URL';
$string['max'] = 'Score max';
$string['maximumattempts'] = 'Nombre de tentatives';
$string['maximumattemptsdesc'] = 'Ce réglage détermine la valeur par défaut du nombre maximal de tentatives de l\'activité';
$string['maximumattempts_help'] = '<!-- $Id$ -->


<p>Ceci indique le nombre de tentatives que l\'utilisateur peut réaliser.<br />Utilisable uniquement avec les paquetages SCORM1.2 ou AICC. SCORM2004 comporte ses propres paramètres pour le nombre de tentatives.</p>';
$string['maximumgradedesc'] = 'Ce réglage détermine la note maximale par défaut de l\'activité';
$string['menubar'] = 'Afficher la barre des menus';
$string['min'] = 'Score min';
$string['missing_attribute'] = 'Attribut {$a->attr} manquant dans la balise {$a->tag}';
$string['missingparam'] = 'Un paramètre requis est manquant ou incorrect';
$string['missing_tag'] = 'Balise {$a->tag} manquante';
$string['mode'] = 'Mode';
$string['modulename'] = 'Paquetage SCORM';
$string['modulename_help'] = 'SCORM et AICC sont des spécifications permettant l\'interopérabilité, l\'accessibilité et la réutilisation de contenus d\'apprentissage web. Le module SCORM/AICC permet d\'inclure des paquetages SCORM/AICC dans les cours.';
$string['modulenameplural'] = 'Paquetages SCORM';
$string['navigation'] = 'Navigation';
$string['newattempt'] = 'Commencer une nouvelle tentative';
$string['next'] = 'Continuer';
$string['noactivity'] = 'Aucune activité';
$string['noattemptsallowed'] = 'Nombre de tentatives permises';
$string['noattemptsmade'] = 'Nombre de tentatives effectuées';
$string['no_attributes'] = 'La balise {$a->tag} doit avoir des attributs';
$string['no_children'] = 'La balise {$a->tag} doit avoir des descendants';
$string['nolimit'] = 'Tentatives illimitées';
$string['nomanifest'] = 'Aucun descriptif trouvé';
$string['noprerequisites'] = 'Désolé ! Vous n\'avez pas obtenu les prérequis suffisants pour accéder à cet objet';
$string['noreports'] = 'Pas de rapport à afficher';
$string['normal'] = 'Normal';
$string['noscriptnoscorm'] = 'Votre navigateur ne supporte pas JavaScript ou celui-ci est désactivé. Ce paquetage SCORM ne fonctionnera pas correctement et le suivi des participants ne sera pas enregistré.';
$string['notattempted'] = 'Aucune tentative';
$string['not_corr_type'] = 'Erreur de type pour la balise {$a->tag}';
$string['notopenyet'] = 'Désolé, cette activité n\'est pas disponible avant le {$a}';
$string['objectives'] = 'Objectifs';
$string['onchanges'] = 'À chaque modification';
$string['optallstudents'] = 'Tous les utilisateurs';
$string['optattemptsonly'] = 'Seulement les utilisateurs avec tentatives';
$string['options'] = 'Options (bloqué par certains navigateurs)';
$string['optnoattemptsonly'] = 'Seulement les utilisateurs sans tentative';
$string['organization'] = 'Organisation';
$string['organizations'] = 'Organisations';
$string['othersettings'] = 'Réglages additionels';
$string['othertracks'] = 'Autres pistes';
$string['package'] = 'Fichier paquetage';
$string['packagedir'] = 'Erreur du système de fichier : impossible de créer le dossier du paquetage';
$string['packagefile'] = 'Pas de paquetage spécifié';
$string['package_help'] = '<!-- $Id$ -->


<p>Un paquetage est proposé sous forme d\'un seul fichier d\'extension <b>.zip</b> (ou .pif) qui contient des fichiers de description AICC ou SCORM valides.</p>

<p>Un paquetage <b>SCORM</b> DOIT contenir à la racine du volume compressé, un fichier nommé <b>imsmanifest.xml</b> qui décrit la structure du cours SCORM, la situation des ressources et une foule d\'autres méta-informations.</p>

<p>Un paquet <b>AICC</b> est défini par un ensemble de fichiers (de 4 à 7) avec des extensions prédéfinies. Voici les extensions et leurs signification :</p>

<ul>

<li>CRS - Fichier de description du cours (Course Description file - présence obligatoire)</li>

<li>AU  - Fichier des éléments évaluables (Assignable Unit file - présence obligatoire)</li>

<li>DES - Fichier des descripteurs (Descriptor file - présence obligatoire)</li>

<li>CST - Fichier de structure du cours (Course Structure file - présence obligatoire)</li>

<li>ORE - Fichier des relations entre objectifs (Objective Relationship file - optionnel)</li>

<li>PRE - Fichier des prérequis (Prerequisites file - optionnel)</li>

<li>CMP - Fichier des conditions de validation (Completion Requirements file - optionnel)</li>

</ul>';
$string['packageurl'] = 'URL';
$string['packageurl_help'] = 'Ce réglage permet de spécifier une URL pour le paquetage SCORM, au lieu de choisir un paquetage dans le sélecteur de fichiers.';
$string['pagesize'] = 'Taille de page';
$string['passed'] = 'Réussi';
$string['php5'] = 'PHP 5 (bibliothèque DOMXML native)';
$string['pluginadministration'] = 'Administration SCORM/AICC';
$string['pluginname'] = 'Paquetage SCORM';
$string['popup'] = 'Nouvelle fenêtre';
$string['popupmenu'] = 'Dans un menu déroulant';
$string['popupopen'] = 'Ouvrir le paquetage dans une nouvelle fenêtre';
$string['popupsblocked'] = 'Les fenêtres surgissantes sont bloquées, ce qui a stoppé l\'exécution de ce SCORM. Veuillez vérifier les réglages de votre navigateur avant de recommencer.';
$string['position_error'] = 'La balise {$a->tag} ne peut pas être un descendant de la balise {$a->parent}';
$string['preferencespage'] = 'Préférences de cette seule page';
$string['preferencesuser'] = 'Préférences de ce rapport';
$string['prev'] = 'Précédent';
$string['raw'] = 'Score brut';
$string['regular'] = 'Descriptif normal';
$string['report'] = 'Rapport';
$string['reportcountallattempts'] = '{$a->nbattempts} tentatives pour {$a->nbusers} utilisateurs, sur {$a->nbresults} résultats';
$string['reportcountattempts'] = '{$a->nbresults} résultats ({$a->nbusers} utilisateurs)';
$string['resizable'] = 'Permettre le redimensionnement de la fenêtre';
$string['result'] = 'Résultat';
$string['results'] = 'Résultats';
$string['review'] = 'Relecture';
$string['reviewmode'] = 'Mode relecture';
$string['scoes'] = 'Objets d\'apprentissage';
$string['score'] = 'Résultat';
$string['scormclose'] = 'Jusqu\'au';
$string['scormcourse'] = 'Cours d\'apprentissage';
$string['scorm:deleteresponses'] = 'Supprimer les tentatives SCORM';
$string['scormloggingoff'] = 'L\'historique API est désactivée';
$string['scormloggingon'] = 'L\'historique API est activée';
$string['scormopen'] = 'Ouvert';
$string['scormresponsedeleted'] = 'Tentative supprimées de l\'utilisateur';
$string['scorm:savetrack'] = 'Enregistrer les traces';
$string['scorm:skipview'] = 'Sauter la vue d\'ensemble';
$string['scormtype'] = 'Type';
$string['scormtype_help'] = 'Ce réglage détermine comment le paquetage est inclus dans le cours.

Il y a quatre options.

* Paquetage déposé : le paquetage SCORM peut être choisi dans le sélecteur de fichiers.
* Manifeste SCORM externe : permet d\'indiquer l\'URL d\'un fichier imsmanifest.xml. Si l\'URL est dans un autre domaine que le site Moodle, l\'option Paquetage téléchargé est mieux adaptée, car sinon les notes ne seraient pas enregistrées.
* Paquetage téléchargé : permet d\'indiquer l\'URL d\'un paquetage SCORM externe. Le paquetage sera décompressé et enregistré localement, et mis à jour si le paquetage externe est modifié.
* Dépôt local IMS content : permet de choisir un paquetage depuis un dépôt IMS.';
$string['scorm:viewreport'] = 'Voir les rapports';
$string['scorm:viewscores'] = 'Voir les scores';
$string['scrollbars'] = 'Permettre le défilement de la fenêtre';
$string['selectall'] = 'Tout sélectionner';
$string['selectnone'] = 'Tout désélectionner';
$string['show'] = 'Afficher';
$string['sided'] = 'Sur le côté';
$string['skipview'] = 'Ne pas afficher la structure du contenu des pages';
$string['skipviewdesc'] = 'Ce réglage détermine quand par défaut ne pas afficher pour les participants la structure du contenu d\'une page';
$string['skipview_help'] = '<!-- $Id$ -->


<p>Si vous ajoutez un paquetage ne comportant qu\'un objet d\'apprentissage, vous pouvez vous dispenser d\'afficher la liste des contenus s\'affichant au lancement de l\'activité SCORM.</p>

<p>Vous pouvez choisir :</p>

<ul>

<li><strong>Jamais</strong> affiche la liste des contenus</li>

<li><strong>Premier accès</strong> n\'affiche la liste des contenus que la première fois</li>

<li><strong>Toujours</strong> n\'affiche pas la liste des contenus</li>

</ul>';
$string['slashargs'] = 'ATTENTION ! Le réglage <i>slasharguments</i> est désactivé. Les objets SCORM ne fonctionneront pas correctement !';
$string['stagesize'] = 'Taille cadre/fenêtre';
$string['stagesize_help'] = '<!-- $Id$ -->


<p>Ces deux paramètres déterminent les dimensions (hauteur et largeur) du cadre ou de la fenêtre de l\'objet d\'apprentissage.</p>';
$string['started'] = 'Démarré le';
$string['status'] = 'État';
$string['statusbar'] = 'Afficher la barre d\'état';
$string['student_response'] = 'Réponse du participant';
$string['suspended'] = 'Suspendu';
$string['syntax'] = 'Erreur de syntaxe';
$string['tag_error'] = 'Balise inconnue ({$a->tag}) avec ce contenu : {$a->value}';
$string['time'] = 'Durée';
$string['timerestrict'] = 'Restreindre les réponses à cette période';
$string['title'] = 'Titre';
$string['toc'] = 'TOC';
$string['toolbar'] = 'Afficher la barre d\'outils';
$string['too_many_attributes'] = 'La balise {$a->tag} a trop d\'attributs';
$string['too_many_children'] = 'La balise {$a->tag} a trop de descendants';
$string['totaltime'] = 'Durée';
$string['trackingloose'] = 'Attention ! Les données du suivi de ce paquetage seront perdues !';
$string['type'] = 'Type';
$string['typeexternal'] = 'Manisfeste SCORM externe';
$string['typeimsrepository'] = 'Dépôt local IMS content';
$string['typelocal'] = 'Paquetage déposé';
$string['typelocalsync'] = 'Paquetage téléchargé';
$string['unziperror'] = 'Une erreur est survenue lors du décompactage du paquetage';
$string['updatefreq'] = 'Fréquence de mise à jour';
$string['updatefreqdesc'] = 'Ce réglage détermine la valeur par défaut de la fréquence de la mise à jour automatique de l\'activité';
$string['validateascorm'] = 'Valider un paquetage';
$string['validation'] = 'Résultat de la validation';
$string['validationtype'] = 'Ce réglage détermine la bibliothèque DOMXML utilisée pour la validation du fichier « manifest » des SCORM. Si vous ne savez pas de quoi il s\'agit, ne modifiez pas la valeur.';
$string['value'] = 'Valeur';
$string['versionwarning'] = 'La version du fichier « manifest » est antérieure à 1.3, avertissement à la balise {$a->tag}';
$string['viewallreports'] = 'Afficher les rapports des {$a} tentatives';
$string['viewalluserreports'] = 'Afficher les rapports des {$a} utilisateurs';
$string['whatgrade'] = 'Évaluation des tentatives';
$string['whatgradedesc'] = 'Ce réglage détermine le mode d\'évaluation par défaut des tentatives';
$string['whatgrade_help'] = 'Si vous permettez plusieurs tentatives, vous pouvez choisir quel résultat intégrer au carnet de notes : celui de la tentative la plus élevée, la moyenne, la première ou la dernière.';
$string['width'] = 'Largeur';
$string['window'] = 'Fenêtre';
$string['zlibwarning'] = 'Attention !: La compression PHP Zlib a été activée sur ce site. Certains utilisateurs pourraient avoir des problèmes de téléchargement d\'objets SCORM avec certains navigateurs.';
