<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'fr', branch 'MOODLE_20_STABLE'
 *
 * @package   data
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Action';
$string['add'] = 'Ajouter une fiche';
$string['addcomment'] = 'Ajouter un commentaire';
$string['addentries'] = 'Ajouter des fiches';
$string['addtemplate'] = 'Modèle nouvelle fiche';
$string['advancedsearch'] = 'Recherche avancée';
$string['alttext'] = 'Texte alternatif';
$string['approve'] = 'Approuver';
$string['approved'] = 'Approuvé';
$string['ascending'] = 'Ascendant';
$string['asearchtemplate'] = 'Modèle recherche avancée';
$string['atmaxentry'] = 'Vous avez ajouté le nombre maximum de fiches permises !';
$string['authorfirstname'] = 'Prénom auteur';
$string['authorlastname'] = 'Nom auteur';
$string['autogenallforms'] = 'Générer tous les modèles par défaut';
$string['autolinkurl'] = 'Lien automatique de l\'URL';
$string['availablefromdate'] = 'Disponible du';
$string['availabletags'] = 'Balises disponibles';
$string['availabletags_help'] = 'Les balises sont des paramètres du modèle, qui seront remplacés par des champs ou d\'autres éléments, par exemple une icône d\'édition, lorsque les fiches sont modifiées ou affichées.

Les champs ont le format [[nom_de_champ]]. Toutes les autres balises sont formatées ainsi  ##une_balise##.

Seules les balises dans la liste des « Balises disponibles » peuvent être utilisées dans le modèle actuel.';
$string['availabletodate'] = 'Disponible jusqu\'au';
$string['blank'] = 'Vide';
$string['buttons'] = 'Actions';
$string['bynameondate'] = 'par {$a->name}, le {$a->date}';
$string['cancel'] = 'Annuler';
$string['cannotaccesspresentsother'] = 'Vous n\'avez pas la permission d\'accéder à des préréglages d\'autres utilisateurs';
$string['cannotadd'] = 'Impossible d\'ajouter des fiches !';
$string['cannotdeletepreset'] = 'Error deleting a preset!';
$string['cannotunziptopreset'] = 'Impossible de décompresser le dossier du préréglages';
$string['checkbox'] = 'Case à cocher';
$string['chooseexportfields'] = 'Sélectionnez les champs que vous voulez exporter :';
$string['chooseexportformat'] = 'Sélectionnez le format d\'exportation désiré :';
$string['chooseorupload'] = 'Sélectionner un fichier';
$string['columns'] = 'colonnes';
$string['comment'] = 'Commentaire';
$string['commentdeleted'] = 'Commentaire supprimé';
$string['commentempty'] = 'Le commentaire était vide';
$string['comments'] = 'Commentaires';
$string['commentsaved'] = 'Commentaire enregistré';
$string['commentsn'] = '{$a} commentaire(s)';
$string['commentsoff'] = 'La fonctionnalité de commentaire n\'est pas activée';
$string['configenablerssfeeds'] = 'Cette option permet l\'activation des flux RSS pour toutes les bases de données. Il est en outre nécessaire d\'activer manuellement les flux RSS dans les réglages de chaque base de données.';
$string['confirmdeletefield'] = 'Vous êtes sur le point de supprimer ce champ. Voulez-vous continuer ?';
$string['confirmdeleterecord'] = 'Voulez-vous vraiment supprimer cette fiche ?';
$string['csstemplate'] = 'Modèle CSS';
$string['csvfailed'] = 'Impossible de lire les données du fichier CSV';
$string['csvfile'] = 'Fichier CSV';
$string['csvimport'] = 'Importation fichier CSV';
$string['csvimport_help'] = 'Des fiches peuvent être importées à partir d\'un fichier texte pur, dont la première ligne contient la liste des noms des champs. Les lignes suivantes contiendront les données à importer, une fiche par ligne.';
$string['csvwithselecteddelimiter'] = 'Texte <acronym title="Comma Separated Values">CSV</acronym> avec séparateur :';
$string['data:approve'] = 'Approuver des fiches';
$string['data:comment'] = 'Écrire des commentaires';
$string['data:exportallentries'] = 'Export toutes les fiches d\'une base de données';
$string['data:exportentry'] = 'Exporter des fiches de base de données';
$string['data:exportownentry'] = 'Exporter ses propres fiches de base de données';
$string['data:managecomments'] = 'Gérer les commentaires';
$string['data:manageentries'] = 'Gérer les fiches';
$string['data:managetemplates'] = 'Gérer les modèles';
$string['data:manageuserpresets'] = 'Gérer tous les préréglages';
$string['data:rate'] = 'Évaluer des fiches';
$string['data:readentry'] = 'Lire des fiches';
$string['data:viewallratings'] = 'Voir toutes les évaluations brutes données par des participants';
$string['data:viewalluserpresets'] = 'Voir les préréglages de tous les utilisateurs';
$string['data:viewanyrating'] = 'Voir les évaluations globales reçues par les participants';
$string['data:viewentry'] = 'Voir les fiches';
$string['data:viewrating'] = 'Voir l\'évaluation globale que vous avez reçue';
$string['data:writeentry'] = 'Ajouter des fiches';
$string['date'] = 'Date';
$string['dateentered'] = 'Date de saisie';
$string['defaultfielddelimiter'] = '(par défaut une virgule)';
$string['defaultfieldenclosure'] = '(par défaut vide)';
$string['defaultsortfield'] = 'Champ de tri par défaut';
$string['delete'] = 'Supprimer';
$string['deleteallentries'] = 'Supprimer toutes les fiches';
$string['deletecomment'] = 'Voulez-vous vraiment supprimer ce commentaire ?';
$string['deleted'] = 'supprimée';
$string['deletefield'] = 'Suppression d\'un champ existant';
$string['deletenotenrolled'] = 'Supprimer les fiches des utilisateurs non inscrits';
$string['deletewarning'] = 'Voulez-vous vraiment supprimer ce préréglage ?';
$string['descending'] = 'Descendant';
$string['directorynotapreset'] = '{$a->directory} n\'est pas un préréglage. Fichiers manquants : {$a->missing_files}';
$string['download'] = 'Télécharger';
$string['edit'] = 'Modifier';
$string['editcomment'] = 'Modifier le commentaire';
$string['editentry'] = 'Modifier la fiche';
$string['editordisable'] = 'Désactiver l\'éditeur';
$string['editorenable'] = 'Activer l\'éditeur';
$string['emptyadd'] = 'Le modèle d\'ajout est vide. Génération d\'un formulaire par défaut...';
$string['emptyaddform'] = 'Vous n\'avez rempli aucun champ !';
$string['entries'] = 'Fiches';
$string['entrieslefttoadd'] = 'Vous devez ajouter encore {$a->entriesleft} fiches pour terminer cette activité';
$string['entrieslefttoaddtoview'] = 'Vous devez ajouter encore {$a->entrieslefttoview} fiches avant de pouvoir consulter les fiches des autres participants.';
$string['entry'] = 'Fiche';
$string['entrysaved'] = 'Votre fiche a été enregistrée';
$string['errormustbeteacher'] = 'Vous devez être enseignant pour afficher cette page !';
$string['errorpresetexists'] = 'Un préréglage de ce nom existe déjà';
$string['example'] = 'Exemple de module Base de données';
$string['excel'] = 'Excel';
$string['expired'] = 'Cette activité est fermée depuis {$a} et n\'est plus disponible';
$string['export'] = 'Exporter';
$string['exportaszip'] = 'Exporter en zip';
$string['exportaszip_help'] = 'Cette fonctionnalité vous permet de télécharger sur votre propre ordinateur les modèles, que vous pourrez déposer ultérieurement dans d\'autres bases de données, à l\'aide de la commande « Importer d\'un fichier zip ».';
$string['exportedtozip'] = 'Exporté vers un zip temporaire...';
$string['exportentries'] = 'Exporter des fiches';
$string['exportownentries'] = 'N\'exporter que vos propres fiches ? ({$a->mine}/{$a->all})';
$string['failedpresetdelete'] = 'Erreur lors de la suppression d\'un préréglage !';
$string['fieldadded'] = 'Champ ajouté';
$string['fieldallowautolink'] = 'Permettre les liens automatiques';
$string['fielddeleted'] = 'Champ supprimé';
$string['fielddelimiter'] = 'Séparateur de champ';
$string['fielddescription'] = 'Description du champ';
$string['fieldenclosure'] = 'Identificateur de texte';
$string['fieldheight'] = 'Hauteur';
$string['fieldheightlistview'] = 'Hauteur en affichage liste';
$string['fieldheightsingleview'] = 'Hauteur en affichage fiche';
$string['fieldids'] = 'Identifiants de champs';
$string['fieldmappings'] = 'Correspondance des champs';
$string['fieldmappings_help'] = 'Ce menu vous permet de conserver des données de la base de données existante. Pour préserver les données d\'un champ, vous devez faire correspondre ce champ à un nouveau champ, dans lequel apparaîtront les données. Les champs peuvent aussi être laissé vides, sans qu\'aucune donnée n\'y soit copiée. Les anciens champs n\'étant pas mis en correspondance avec un nouveau seront supprimés, et toutes les données qu\'ils contenaient seront perdues.
Vous ne pouvez mettre en correspondance que des champs de même type. Les deux menus déroulants comporteront des champs différents. Veuillez en outre faire attention à ne pas mettre en correspondance un ancien champ avec plus d\'un nouveau.';
$string['fieldname'] = 'Nom du champ';
$string['fieldnotmatched'] = 'Les champs suivants de votre fichier n\'existent pas dans cette base de données : {$a}';
$string['fieldoptions'] = 'Options (une par ligne)';
$string['fields'] = 'Champs';
$string['fieldupdated'] = 'Champ modifié';
$string['fieldwidth'] = 'Largeur';
$string['fieldwidthlistview'] = 'Largeur en affichage liste';
$string['fieldwidthsingleview'] = 'Largeur en affichage fiche';
$string['file'] = 'Fichier';
$string['filesnotgenerated'] = 'Les fichiers n\'ont pas tous été générés : {$a}';
$string['filtername'] = 'Liens automatiques des bases de données';
$string['footer'] = 'Pied de page';
$string['forcelinkname'] = 'Nom imposé pour le lien';
$string['foundnorecords'] = 'Aucune fiche trouvée (<a href="{$a->reseturl}">Réinitialiser les filtres</a>)';
$string['foundrecords'] = 'Fiches trouvées : {$a->num}/{$a->max} (<a href="{$a->reseturl}">Réinitialiser les filtres</a>)';
$string['fromfile'] = 'Importer d\'un fichier zip';
$string['fromfile_help'] = 'Utilisez cette fonctionnalité pour importer des préréglages que vous avez enregistrés auparavant sur votre propre ordinateur en les exportant.';
$string['generateerror'] = 'Erreur de génération de certains fichiers !';
$string['header'] = 'Entête';
$string['headeraddtemplate'] = 'Définit l\'interface présentée lors de la modification de fiches';
$string['headerasearchtemplate'] = 'Définit l\'interface présentée pour les recherches avancées';
$string['headercsstemplate'] = 'Définit les styles CSS des autres modèles';
$string['headerjstemplate'] = 'Définit du code JavaScript utilisable dans les autres modèles';
$string['headerlisttemplate'] = 'Définit l\'interface présentée lors de la consultation de plusieurs fiches';
$string['headerrsstemplate'] = 'Définit l\'aspect des fiches dans les flux RSS';
$string['headersingletemplate'] = 'Définit l\'interface présentée lors de la consultation d\'une fiche';
$string['importentries'] = 'Importer des fiches';
$string['importsuccess'] = 'Le préréglage a été mis en place correctement.';
$string['insufficiententries'] = 'autres fiches sont requises pour afficher cette base de données';
$string['intro'] = 'Introduction';
$string['invalidaccess'] = 'L\'accès à cette page n\'a pas été effectué correctement';
$string['invalidfieldid'] = 'L\'identifiant du champ est incorrect';
$string['invalidfieldname'] = 'Veuillez choisir un autre nom pour ce champ';
$string['invalidfieldtype'] = 'Le type de champ est incorrect';
$string['invalidid'] = 'Incorrect data ID';
$string['invalidpreset'] = '{$a} n\'est pas un préréglage.';
$string['invalidrecord'] = 'Fiche incorrecte';
$string['invalidurl'] = 'L\'URL que vous venez de saisir n\'est pas valide';
$string['jstemplate'] = 'Modèle Javascript';
$string['latitude'] = 'Latitude';
$string['latlong'] = 'Latitude/longitude';
$string['latlongdownloadallhint'] = 'Lien pour télécharger tous les éléments comme KML';
$string['latlongkmllabelling'] = 'Comment étiqueter des éléments dans les fichiers KML (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Services liés à afficher';
$string['latlongotherfields'] = 'Autres champs';
$string['list'] = 'Affichage liste';
$string['listtemplate'] = 'Modèle liste';
$string['longitude'] = 'Longitude';
$string['mapexistingfield'] = 'Faire correspondre à {$a}';
$string['mapnewfield'] = 'Créer un nouveau champ';
$string['mappingwarning'] = 'Les anciens champs qui ne sont pas mis en correspondance avec un nouveau champ seront perdus, ainsi que toutes les données qu\'ils contiennent.';
$string['maxentries'] = 'Nombre maximum de fiches';
$string['maxentries_help'] = 'Le nombre maximum de fiches qu\'un participant peut remettre dans le cadre de cette activité.';
$string['maxsize'] = 'Taille maximale';
$string['menu'] = 'Menu déroulant';
$string['menuchoose'] = 'Sélectionner...';
$string['missingdata'] = 'Un identifiant de données ou un objet doit être fourni à la classe champ';
$string['missingfield'] = 'Erreur de programmation : veuillez indiquer le champ et/ou les données lors de la définition d\'une classe.';
$string['modulename'] = 'Base de données';
$string['modulename_help'] = 'Le module d\'activité Base de données permet aux participants de construire, afficher et rechercher une base de fiches sur n\'importe quel sujet imaginable. Le format et la structure de ces fiches sont presque illimités, comprenant des images, des fichiers, des URLs, des nombres et du texte, entre autres.';
$string['modulenameplural'] = 'Bases de données';
$string['more'] = 'Plus';
$string['moreurl'] = 'Plus d\'infos';
$string['movezipfailed'] = 'Impossible de déplacer le fichier zip';
$string['multientry'] = 'Fiche répétée';
$string['multimenu'] = 'Menu (sélection multiple)';
$string['multipletags'] = 'Plusieurs balises ont été trouvées ! Le modèle n\'a pas été enregistré';
$string['namecheckbox'] = 'Champ case à cocher';
$string['namedate'] = 'Champ date';
$string['namefile'] = 'Champ fichier';
$string['namelatlong'] = 'Champ latitude/longitude';
$string['namemenu'] = 'Champ menu';
$string['namemultimenu'] = 'Champ menu à sélection multiple';
$string['namenumber'] = 'Champ numérique';
$string['namepicture'] = 'Champ image';
$string['nameradiobutton'] = 'Champ bouton radio';
$string['nametext'] = 'Champ texte';
$string['nametextarea'] = 'Champ texte long';
$string['nameurl'] = 'Champ URL';
$string['newentry'] = 'Nouvelle fiche';
$string['newfield'] = 'Créer un nouveau champ';
$string['newfield_help'] = '<!-- $Id$ -->


<p>Sur cette page, vous pouvez définir les champs créant la structure de votre base de données.</p>

<p>Chaque champ permet différents types de données, proposées par différentes interfaces.</p>';
$string['noaccess'] = 'Vous n\'avez pas accès à cette page';
$string['nodefinedfields'] = 'Le nouveau préréglage ne comporte pas de champ !';
$string['nofieldcontent'] = 'Contenu du champ non trouvé';
$string['nofieldindatabase'] = 'Cette base de données ne contient encore aucun champ.';
$string['nolisttemplate'] = 'Le modèle liste n\'est pas encore défini';
$string['nomatch'] = 'Aucune fiche trouvée !';
$string['nomaximum'] = 'Pas de limite';
$string['norecords'] = 'Aucune fiche dans la base de données';
$string['nosingletemplate'] = 'Le modèle fiche n\'est pas encore défini';
$string['notapproved'] = 'La fiche n\'est pas encore approuvée.';
$string['notinjectivemap'] = 'N\'est pas une application injective';
$string['notopenyet'] = 'Cette activité n\'est pas disponible avant le {$a}';
$string['number'] = 'Nombre';
$string['numberrssarticles'] = 'Fiches RSS';
$string['numnotapproved'] = 'En attente';
$string['numrecords'] = '{$a} fiches';
$string['ods'] = 'Document <acronym title="OpenDocument Spreadsheet">ODS</acronym> (OpenOffice)';
$string['optionaldescription'] = 'Brève description (facultative)';
$string['optionalfilename'] = 'Nom affiché (facultatif)';
$string['other'] = 'Autre';
$string['overrwritedesc'] = 'Écraser le préréglage s\'il existe déjà';
$string['overwrite'] = 'Écraser';
$string['overwritesettings'] = 'Écraser les réglages actuels';
$string['pagesize'] = 'Fiches par page';
$string['participants'] = 'Participants';
$string['picture'] = 'Image';
$string['pleaseaddsome'] = 'Veuillez en créer maintenant ou <a href="{$a}">choisir un préréglage disponible</a>.';
$string['pluginadministration'] = 'Administration de la base de données';
$string['pluginname'] = 'Base de données';
$string['portfolionotfile'] = 'Exporter vers un portfolio plutôt que vers un fichier (CSV et LEAP2a seulement)';
$string['presetinfo'] = 'L\'enregistrement en tant que préréglage publiera ce modèle. D\'autres utilisateurs pourront l\'utiliser dans leurs bases de données.';
$string['presets'] = 'Préréglages';
$string['radiobutton'] = 'Boutons radio';
$string['recordapproved'] = 'Fiche approuvée';
$string['recorddeleted'] = 'Fiche supprimée';
$string['recordsnotsaved'] = 'Aucune fiche n\'a été importée. Veuillez vérifier le format du fichier déposé.';
$string['recordssaved'] = 'fiches importées';
$string['requireapproval'] = 'Nécessite une approbation ?';
$string['requireapproval_help'] = 'Si vous désirez que les fiches soient approuvées par un enseignant avant de pouvoir être vues par les autres participants, activez cette option.';
$string['requiredentries'] = 'Fiches requises';
$string['requiredentries_help'] = 'Le nombre de fiches qu\'un participant a l\'obligation de créer dans cette activité pour qu\'elle soit considérée comme terminée.';
$string['requiredentriestoview'] = 'Fiches requises avant consultation';
$string['requiredentriestoview_help'] = '<!-- $Id$ -->


<p>Ce réglage indique le nombre de fiches qu\'un participant doit créer avant de pouvoir consulter les autres fiches de cette activité de base de données.</p>

<p>Remarque ! Cette fonctionnalité ne peut pas être utilisée en même temps que le filtre des liens automatiques des articles de base de données, car ce filtre est incapable de déterminer si un utilisateur a proposé le nombre requis d\'articles.</p>';
$string['resetsettings'] = 'Réinitialiser les filtres';
$string['resettemplate'] = 'Réinitialiser le modèle';
$string['resizingimages'] = 'Génération des vignettes...';
$string['rows'] = 'rangées';
$string['rssglobaldisabled'] = 'Désactivé. Voir les paramètres de configuration du Moodle.';
$string['rsshowmany'] = '(nombre de fiches récentes à afficher, 0 pour désactiver les RSS)';
$string['rsstemplate'] = 'Modèle RSS';
$string['rsstitletemplate'] = 'Modèle titre RSS';
$string['save'] = 'Enregistrer';
$string['saveandadd'] = 'Enregistrer et ajouter une fiche';
$string['saveandview'] = 'Enregistrer et afficher';
$string['saveaspreset'] = 'Enregistrer en tant que préréglage';
$string['saveaspreset_help'] = '<!-- $Id$ -->


<p>Ceci publie le modèle actuel en tant que préréglage, de sorte que tout le monde sur ce site pourra le voir et l\'utiliser. Ce modèle apparaîtra dans la liste des préréglages. Il vous sera possible de le retirer de cette liste en tout temps.</p>';
$string['savesettings'] = 'Enregistrer les réglages';
$string['savesuccess'] = 'Enregistrement réussi. Votre préréglage est maintenant disponible sur tout le site.';
$string['savetemplate'] = 'Enregistrer modèle';
$string['search'] = 'Recherche';
$string['selectedrequired'] = 'Toute la sélection requise';
$string['showall'] = 'Afficher toutes les fiches';
$string['single'] = 'Affichage fiche';
$string['singletemplate'] = 'Modèle fiche';
$string['teachersandstudents'] = '{$a->teachers} et {$a->students}';
$string['templates'] = 'Modèles';
$string['templatesaved'] = 'Modèle enregistré';
$string['text'] = 'Texte';
$string['textarea'] = 'Texte long';
$string['timeadded'] = 'Date ajout';
$string['timemodified'] = 'Date modification';
$string['todatabase'] = 'à cette base de données.';
$string['type'] = 'Type de champ';
$string['undefinedprocessactionmethod'] = 'Aucune méthode n\'est définie dans Data_Preset pour traiter l\'action « {$a} ».';
$string['unsupportedexport'] = '({$a->fieldtype}) ne peut pas être exporté.';
$string['updatefield'] = 'Modifier un champ existant';
$string['uploadfile'] = 'Déposer un fichier';
$string['uploadrecords'] = 'Importer des fiches à partir d\'un fichier';
$string['uploadrecords_help'] = 'Des fiches peuvent être déposées à partir d\'un fichier texte. Le format du fichier doit être comme suit :

* chaque ligne du fichier contient une fiche
* chaque fiche est constituée d\'une série de données, séparées par des virgules (ou d\'autres séparateurs)
* la première ligne du fichier comprend les noms des champs définissant le format du reste du fichier.  Le délimiteur de champ est un caractère qui entoure chaque champ d\'une fiche, par exemple les guillemets droits. Il peut être laissé vide.';
$string['url'] = 'URL';
$string['usestandard'] = 'Utiliser un préréglage';
$string['usestandard_help'] = '<!-- $Id$ -->


<p>Ceci vous permet d\'utiliser pour votre base de données un modèle disponible dans tout le site en tant que préréglage.</p>

<p>Si vous avez ajouté un préréglage en utilisant la fonctionnalité « Enregistrer en tant que préréglage », vous pouvez le supprimer.</p>';
$string['viewfromdate'] = 'En lecture seule dès le';
$string['viewtodate'] = 'En lecture seule jusqu\'au';
$string['wrongdataid'] = 'L\'identifiant de données fourni est incorrect';
