<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_formal_white', language 'de', branch 'MOODLE_20_STABLE'
 *
 * @package   theme_formal_white
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['blockcolumnwidth'] = 'Spaltenbreite für Blöcke';
$string['blockcolumnwidthdesc'] = 'Diese Einstellung bestimmt die Spaltenbreite für Blöcke. <strong>Mit Werten unter 200px kann der Kalenderblock nicht richtig angezeigt werden.</strong>';
$string['blockcontentbgc'] = 'Hintergrundfarbe für Blockinhalte';
$string['blockcontentbgcdesc'] = 'Diese Einstellung legt die Hintergrundfarbe für die Blockinhalte fest.
';
$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2>Formal White</h2>
<img src="formal_white/pix/screenshot.gif" />
<h3>Forum zur Designdiskussion:</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Danksagungen (Designs):</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Dokumentationen:</h3>
<p><a href="http://docs.moodle.org/de/Designs">http://docs.moodle.org/de/Designs</a></p>
<h3>Fehler melden:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Über Formal White</h2>
<p>Formal White ist ein Drei-Spalten-Design mit variabler Breite für Moodle 2.0.</p>
<h2>Hinweise</h2>
<p>Dieses Design basiert auf den beiden in Moodle enthaltenen Grunddesigns Base und Canvas. Wenn Sie Änderungen vornehmen wollen, empfehlen wir unbedingt, vorher immer eine Kopie zu erstellen und diese umzubenennen. So wird verhindert, dass Ihre Änderungen bei einem Update von Moodle verloren gehen; Sollte Ihnen ein Fehler in den Änderungen unterlaufen, haben Sie so ebenfalls noch eine funktionierende Sicherheitskopie. Weitere Informationen zum Bearbeiten von Designs finden Sie in den <a href="http://docs.moodle.org/de/Designs">Design-Dokumentationen</a>.</p>
<h2>Autor</h2>
<p>Dieses Design wurde für Moodle 2.0 erstellt und wird weiter unterstützt von MediaTouch 2000. </p>
<h2>Lizenz</h2>
<p>Alle in Moodle enthaltenen Grunddesigns stehen unter der <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
</div>
</div>';
$string['configtitle'] = 'Formal White-Einstellungen';
$string['customcss'] = 'Eigenes CSS';
$string['customcssdesc'] = 'Das eigene CSS wird auf jeder Seite eingefügt, um das Design an Ihre Bedürfnisse anzupassen.';
$string['displaylogo'] = 'Kopfbereich';
$string['displaylogodesc'] = 'Wählen Sie, ob im Kopfbereich das Logo oder der Kopfzeilentext angezeigt werden soll.';
$string['fontsizereference'] = 'Referenz für Textgröße';
$string['fontsizereferencedesc'] = 'Diese Einstellung legt die standardmäßige Textgröße fest. Es wird empfohlen, einen Wert größer als 13px zu verwenden, da andernfalls Problem in einigen Blöcken auftreten könnten.';
$string['footnote'] = 'Fußnote';
$string['footnotedesc'] = 'Der Inhalt dieses Feldes wird auf jeder Seite als Fußzeile angezeigt.';
$string['headerbgc'] = 'Hintergrundfarbe für Kopfbereich';
$string['headerbgcdesc'] = 'Diese Einstellung legt die Hintergrundfarbe für den Kopfbereich fest.';
$string['heading'] = 'Kopfzeilentext anzeigen';
$string['lblockcolumnbgc'] = 'Hintergrundfarbe für die linke Spalte';
$string['lblockcolumnbgcdesc'] = 'Diese Einstellung legt die Hintergrundfarbe für die linke Spalte fest.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Um das Logo für dieses Design zu ändern, geben Sie die URL eines Bildes an, das Sie als Logo verwenden möchten (z.B. http://www.seite.de/verzeichnis/logo.png). Das Standardlogo ist 300px breit und 80px hoch und bietet sich als Größenreferenz an. Am besten funktionieren transparente Bilder im Format *.png. Das ausgewählte Logo wird auf allen Seiten der Website gezeigt, u.z. ohne Unterscheidung zwischen Startseite und den übrigen Seiten.';
$string['moodlelogo'] = 'Moodle-Logo anzeigen';
$string['noframe'] = 'Erscheinungsbild wie 1.9';
$string['noframedesc'] = 'Wenn diese Option aktiviert ist, wird das Design wie in Moodle 1.9 angezeigt, und zwar ohne den umgebenden äußeren Rahmen.';
$string['pluginname'] = 'Formal White';
$string['rblockcolumnbgc'] = 'Hintergrundfarbe für die rechte Spalte';
$string['rblockcolumnbgcdesc'] = 'Diese Einstellung legt die Hintergrundfarbe für die rechte Spalte fest. Wenn Sie dieses Feld leer lassen, wird hier ebenfalls die Farbe für die linke Spalte benutzt.';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
