<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'de', branch 'MOODLE_20_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addanewdiscussion'] = 'Neues Thema hinzufügen';
$string['addanewquestion'] = 'Neue Frage hinzufügen';
$string['addanewtopic'] = 'Neues Thema hinzufügen';
$string['advancedsearch'] = 'Erweiterte Suche';
$string['allforums'] = 'Alle Foren';
$string['allowdiscussions'] = 'Darf \'{$a}\' in diesem Forum schreiben?';
$string['allowsallsubscribe'] = 'Alle dürfen im Forum über ihr Abonnement entscheiden';
$string['allowsdiscussions'] = 'Alle dürfen im Forum ein neues Thema beginnen';
$string['allsubscribe'] = 'Alle Foren abonnieren';
$string['allunsubscribe'] = 'Alle Foren abbestellen';
$string['alreadyfirstpost'] = 'Dies ist der erste Beitrag zu diesem Thema';
$string['anyfile'] = 'Jede Datei';
$string['attachment'] = 'Anhang';
$string['attachment_help'] = 'Sie dürfen eine oder mehrere Dateien an einen Beitrag anhängen. Ein angehängtes Bild wird am Ende des Beitrags angezeigt.';
$string['attachmentnopost'] = 'Ohne Nachrichten-ID können Anhänge nicht exportiert werden';
$string['attachments'] = 'Anhänge';
$string['blockafter'] = 'Sperre';
$string['blockafter_help'] = 'Diese Zahl legt fest, wie viele Beiträge pro Nutzer/in im angegebenen Zeitfenster maximal ins Forum eingetragen werden dürfen. Nutzer/innen mit der Berechtigung mod/forum:postwithoutthrottling sind von einer Sperre ausgenommen.';
$string['blockperiod'] = 'Zeitfenster';
$string['blockperioddisabled'] = 'Nicht sperren';
$string['blockperiod_help'] = 'In diesem Zeitfenster dürfen maximal so viele Beiträge pro Nutzer/in ins Forum eingetragen werden, wie mit der Zahl \'Sperre\' festgelegt sind. Nutzer/innen mit der Berechtigung mod/forum:postwithoutthrottling sind von einer Sperre ausgenommen.';
$string['blogforum'] = 'Standardforum, angezeigt in blog-ähnlichem Format';
$string['bynameondate'] = 'von {$a->name} - {$a->date}';
$string['cannotadd'] = 'Der Beitrag konnte nicht zum Forum hingefügt werden';
$string['cannotadddiscussion'] = 'Nur Gruppenmitglieder dürfen Beiträge zum Forum hinzufügen.';
$string['cannotadddiscussionall'] = 'Sie dürfen kein neues Diskussionsthema für alle Teilnehmer/innen hinzufügen.';
$string['cannotaddsubscriber'] = 'Die Nutzer-ID {$a} konnte nicht zur Forumsliste hinzugefügt werden!';
$string['cannotaddteacherforumto'] = 'Die konvertierte Instanz des Trainerforums konnte nicht im Kursabschnitt 0 eingefügt werden.';
$string['cannotcreatediscussion'] = 'Die neue Diskussion konnte nicht erstellt werden.';
$string['cannotcreateinstanceforteacher'] = 'Die neue Kursinstanz für das Trainerforum konnte nicht erstellt werden.';
$string['cannotdeleteforummodule'] = 'Sie dürfen das Forenmodul nicht löschen.';
$string['cannotdeletepost'] = 'Sie dürfen diesen Beitrag nicht löschen!';
$string['cannoteditposts'] = 'Sie dürfen keine Beiträge anderer Nutzer/innen ändern!';
$string['cannotfinddiscussion'] = 'Die Diskussion wurde nicht in diesem Forum gefunden';
$string['cannotfindfirstpost'] = 'Der erste Beitrag wurde nicht in diesem Forum gefunden';
$string['cannotfindorcreateforum'] = 'Das Nachrichtenforum dieser Website wurde nicht gefunden oder konnte nicht angelegt werden';
$string['cannotfindparentpost'] = 'Der erste Beitrag zu diesem Thema {$a} wurde nicht gefunden';
$string['cannotmovefromsingleforum'] = 'Die Diskussion kann nicht aus einem einfachen Einzeldiskussionsforum verschoben werden';
$string['cannotmovenotvisible'] = 'Forum nicht sichtbar';
$string['cannotmovetonotexist'] = 'Sie können nicht in dieses Forum wechseln - es existiert nicht!';
$string['cannotmovetonotfound'] = 'Das Zielforum wurde nicht im Kurs gefunden.';
$string['cannotmovetosingleforum'] = 'Das Thema kann nicht ein Einzeldiskussionsforum verschoben werden';
$string['cannotpurgecachedrss'] = 'Die zwischengespeicherten RSS-Feeds für die Quell- und/oder Ziel-Foren können nicht beseitigt werden - überprüfen Sie Ihre Forenberechtigungen.';
$string['cannotremovesubscriber'] = 'Die Nutzer-ID {$a} konnte nicht aus der Forumsliste entfernt werden!';
$string['cannotreply'] = 'Sie dürfen nicht auf diesen Beitrag antworten';
$string['cannotsplit'] = 'Die Diskussionen können in diesem Forum nicht geteilt werden';
$string['cannotsubscribe'] = 'Für ein Abonnement müssen Sie Gruppenmitglied sein';
$string['cannottrack'] = 'Das Tracking des Forums konnte nicht beendet werden';
$string['cannotunsubscribe'] = 'Sie könnten nicht aus dem Forum abgemeldet werden';
$string['cannotupdatepost'] = 'Sie können den Beitrag nicht aktualisieren.';
$string['cannotviewpostyet'] = 'Sie können die Beiträge anderer Teilnehmer/innen erst dann lesen, wenn Sie selbst Beiträge verfasst haben.';
$string['cannotviewusersposts'] = 'Es gibt keine von dieser Person erstellten Beiträge, die Sie ansehen können';
$string['cleanreadtime'] = '\'Gelesen\' zu diesen Zeitpunkt markieren';
$string['completiondiscussions'] = 'Teilnehmer/in muss Themen neu beginnen:';
$string['completiondiscussionsgroup'] = 'Diskussionen erforderlich';
$string['completiondiscussionshelp'] = 'Zum Beenden sind Diskussionen erforderlich';
$string['completionposts'] = 'Teilnehmer/in muss Diskussionen oder Antworten verfassen:';
$string['completionpostsgroup'] = 'Forumsbeiträge erforderlich';
$string['completionpostshelp'] = 'Zum Beenden sind Diskussionen oder Antworten erforderlich';
$string['completionreplies'] = 'Teilnehmer/in muss Antworten verfassen:';
$string['completionrepliesgroup'] = 'Antworten erforderlich';
$string['completionreplieshelp'] = 'Zum Beenden sind Antworten erforderlich';
$string['configcleanreadtime'] = 'Zu dieser Uhrzeit (Stunde) werden täglich die älteren Beiträge automatisch als \'gelesen\' markiert.';
$string['configdisplaymode'] = 'Standardanzeige für Diskussionen, falls nichts eingestellt wurde.';
$string['configenablerssfeeds'] = 'Diese Option aktiviert die Möglichkeit von RSS-Feeds für alle Foren. Jedes Forum muss einzeln für RSS-Feeds freigegeben werden.';
$string['configenabletimedposts'] = 'Wenn diese Option aktiviert ist, dann lässt sich ein Zeitraum für Sichtbarkeit eines Forumsbeitrags festzulegen (experimentell und noch nicht umfassend getestet).';
$string['configlongpost'] = 'Jeder Beitrag wird als lang eingestuft, wenn er länger als diese Zeichenzahl ist (ohne Berücksichtigung der HTML-Codierung).';
$string['configmanydiscussions'] = 'Maximalzahl von Themen pro Seite';
$string['configmaxattachments'] = 'Voreinstellung für die maximale Anzahl von Anhängen, die pro Beitrag in einem Forum erlaubt sind';
$string['configmaxbytes'] = 'Voreinstellung für die maximale Dateigröße von Anhängen in Foren auf dieser Website (je nach Kurs oder durch andere lokale Einstellungen weiter eingeschränkt)';
$string['configoldpostdays'] = 'Anzahl der Tage, nach denen eine neue Nachricht automatisch als gelesen gilt.';
$string['configreplytouser'] = 'Wenn ein Forumsbeitrag per E-Mail verschickt wird, soll er die Teilnehmeradresse enthalten, damit der Empfänger persönlich antworten kann (statt über das Forum)? Wenn Sie "Ja" auswählen, können die Teilnehmer/innen in ihrem Profil festlegen, ob die E-Mail-Adresse veröffentlicht werden soll oder nicht.';
$string['configshortpost'] = 'Jeder Beitrag wird als kurz eingestuft, wenn er kürzer als diese Zeichenzahl ist (ohne Berücksichtigung der HTML-Codierung).';
$string['configtrackreadposts'] = 'Wenn diese Option aktiviert ist, steht die Markierung gelesen/ungelesen für alle zur Verfügung.';
$string['configusermarksread'] = 'Wenn diese Option aktiviert ist, müssen neue Nachrichten manuell als gelesen markiert werden. Andernfalls gilt eine Nachricht automatisch als gelesen, sobald sie einmal aufgerufen wurde.';
$string['confirmsubscribe'] = 'Möchten Sie wirklich das Forum \'{$a}\' abonnieren?';
$string['confirmunsubscribe'] = 'Möchten Sie wirklich das Forum \'{$a}\' abbestellen?';
$string['couldnotadd'] = 'Der Beitrag wurde wegen eines Fehlers nicht hinzugefügt.';
$string['couldnotdeletereplies'] = 'Der Beitrag darf nicht gelöscht werden, weil es dazu bereits Antworten gibt.';
$string['couldnotupdate'] = 'Der Beitrag wurde wegen eines Fehlers nicht aktualisiert.';
$string['delete'] = 'Löschen';
$string['deleteddiscussion'] = 'Das Thema wurde gelöscht.';
$string['deletedpost'] = 'Der Beitrag wurde gelöscht.';
$string['deletedposts'] = 'Diese Beiträge wurden gelöscht.';
$string['deletesure'] = 'Möchten Sie diesen Beitrag wirklich löschen?';
$string['deletesureplural'] = 'Sind Sie sicher, dass Sie diesen Beitrag und alle dazugehörigen Antworten löschen wollen? (insgesamt {$a} Beiträge)';
$string['digestmailheader'] = 'Dies ist die tägliche Zusammenfassung (Digest) neuer Forumsbeiträge von {$a->sitename}. Sie können Ihre E-Mail-Einstellungen für Foren unter {$a->userprefs} abändern.';
$string['digestmailprefs'] = 'Ihr Profil';
$string['digestmailsubject'] = '{$a}: Zusammenfassung des Forums';
$string['digestsentusers'] = 'Die E-Mail-Zusammenfassung wurde erfolgreich an {$a} Teilnehmer/innen versandt.';
$string['disallowsubscribe'] = 'Das Forums kann nicht abonniert werden';
$string['disallowsubscribeteacher'] = 'Das Forums kann nicht abonniert werden (nur Trainer/innen)';
$string['discussion'] = 'Thema';
$string['discussionmoved'] = 'Dieses Thema wurde nach \'{$a}\' verschoben.';
$string['discussionmovedpost'] = 'Dieses Thema wurde verschoben nach <a href="{$a->discusshref}">hier</a> ins Forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Thema';
$string['discussions'] = 'Themen';
$string['discussionsstartedby'] = 'Themen begonnen von {$a}';
$string['discussionsstartedbyrecent'] = 'Themen kürzlich begonnen von {$a}';
$string['discussionsstartedbyuserincourse'] = 'Themen von {$a->fullname} in {$a->coursename} begonnen';
$string['discussthistopic'] = 'Thema diskutieren';
$string['displayend'] = 'Anzeigeende';
$string['displayend_help'] = 'Die Einstellung legt fest, ob ein Forumsbeitrag nach einem bestimmten Datum verborgen werden soll. Beachten Sie, dass Admins die Beiträge immer sehen dürfen.';
$string['displaymode'] = 'Anzeigemodus';
$string['displayperiod'] = 'Anzeigeperiode';
$string['displaystart'] = 'Anzeigebeginn';
$string['displaystart_help'] = 'Die Option legt fest, ob ein Forumsbeitrag erst ab einem bestimmten Datum angezeigt werden soll. Administrator/innen dürfen immer alle Beiträge sehen.';
$string['eachuserforum'] = 'Jede Person darf genau ein Thema anlegen';
$string['edit'] = 'Bearbeiten';
$string['editedby'] = 'Geändert von {$a->name} - Originaleintrag {$a->date}';
$string['editing'] = 'Wird bearbeitet';
$string['emptymessage'] = 'Bei Ihrem Beitrag ist ein Fehler aufgetreten. Eventuell haben Sie keinen Text eingegeben oder der Anhang war zu groß. Die Änderungen wurden nicht gespeichert.';
$string['erroremptymessage'] = 'Die Mitteilung darf nicht leer sein.';
$string['erroremptysubject'] = 'Der Betreff darf nicht leer sein.';
$string['errorenrolmentrequired'] = 'Sie müssen in den Kurs eingeschrieben sein, um auf diesen Inhalt zugreifen zu können';
$string['errorwhiledelete'] = 'Beim Löschen des Beitrags ist ein Fehler aufgetreten.';
$string['everyonecanchoose'] = 'Alle dürfen entscheiden, ob sie das Forum abonnieren';
$string['everyonecannowchoose'] = 'Alle dürfen jetzt entscheiden, ob sie das Forum abonnieren';
$string['everyoneisnowsubscribed'] = 'Alle haben jetzt dieses Forum abonniert';
$string['everyoneissubscribed'] = 'Alle haben dieses Forum abonniert';
$string['existingsubscribers'] = 'Derzeitige Abonnenten';
$string['exportdiscussion'] = 'Gesamte Diskussion exportieren';
$string['forcessubscribe'] = 'Dieses Forum muss von allen abonniert werden';
$string['forum'] = 'Forum';
$string['forum:addnews'] = 'Nachrichten hinzufügen';
$string['forumauthorhidden'] = 'Autor/in (verborgen)';
$string['forumblockingalmosttoomanyposts'] = 'Sie erreichen bald die Höchstzahl der zulässigen Beiträge. Sie haben {$a->numposts} Beiträge im Zeitraum {$a->blockperiod} veröffentlicht. Die Grenze ist bei {$a->blockafter} Beiträgen erreicht.';
$string['forumbodyhidden'] = 'Sie können diesen Beitrag nicht ansehen. Entweder haben Sie selbst in dieser Diskussion noch nichts geschrieben oder die Bearbeitungszeit für den Beitrag läuft noch.';
$string['forum:createattachment'] = 'Anhänge hinzufügen';
$string['forum:deleteanypost'] = 'Alle Beiträge löschen (jederzeit)';
$string['forum:deleteownpost'] = 'Eigene Beiträge löschen (mit Zeitbegrenzung)';
$string['forum:editanypost'] = 'Alle Beiträge bearbeiten';
$string['forum:exportdiscussion'] = 'Gesamtes Thema exportieren';
$string['forum:exportownpost'] = 'Eigenen Beitrag exportieren';
$string['forum:exportpost'] = 'Beitrag exportieren';
$string['forum:initialsubscriptions'] = 'Zunächst eintragen';
$string['forumintro'] = 'Beschreibung';
$string['forum:managesubscriptions'] = 'Abonnent/innen verwalten';
$string['forum:movediscussions'] = 'Themen verschieben';
$string['forumname'] = 'Forumsname';
$string['forumposts'] = 'Forumsbeiträge';
$string['forum:postwithoutthrottling'] = 'Keine Sperre bei zu vielen Beiträgen';
$string['forum:rate'] = 'Beiträge bewerten';
$string['forum:replynews'] = 'Auf Nachrichten antworten';
$string['forum:replypost'] = 'Auf Beiträge antworten';
$string['forums'] = 'Foren';
$string['forum:splitdiscussions'] = 'Themen aufteilen';
$string['forum:startdiscussion'] = 'Neue Themen beginnen';
$string['forumsubjecthidden'] = 'Betreff (verborgen)';
$string['forum:throttlingapplies'] = 'Beiträge beschränken';
$string['forumtracked'] = 'Ungelesene Beiträge werden verfolgt';
$string['forumtrackednot'] = 'Ungelesene Beiträge werden nicht verfolgt';
$string['forumtype'] = 'Forumstyp';
$string['forumtype_help'] = 'Es gibt fünf verschiedene Forentypen:

* Diskussion zu einem Thema - Forum zu nur einem einzigen Thema, zu dem alle etwas schreiben dürfen. Dies ermöglicht kurze und sehr spezielle Diskussionen.
* Jede Person postet genau ein Thema - Forum in dem jede Person genau ein einziges Diskussionsthema eröffnen darf. Zu jedem Thema dürfen alle anderen etwas antworten.
* Frage- und Antwort-Forum - Forum, bei dem die Teilnehmer/innen zuerst ihre eigene Position posten müssen, bevor sie die anderen Beiträge sehen und darauf antworten können.
* Standardforum in einem blog-ähnlichen Anzeigeformat - offenes Forum, in dem jeder zu jeder Zeit ein neues Diskussionsthema eröffnen und auf alle Beiträge antworten kann. Bei diesem Forum werden alle Themen auf einer Seite zusammen mit Links "Dieses Thema diskutieren" gezeigt.
* Standardforum - ein offenes Forum, in dem jeder zu jeder Zeit ein neues Diskussionsthema eröffnen und auf alle Beiträge antworten kann.
';
$string['forum:viewallratings'] = 'Alle Teilwertungen sehen';
$string['forum:viewanyrating'] = 'Alle Gesamtwertungen sehen';
$string['forum:viewdiscussion'] = 'Themen sehen';
$string['forum:viewhiddentimedposts'] = 'Verborgene zeitliche Beiträge sehen';
$string['forum:viewqandawithoutposting'] = 'Frage- und Antwortbeiträge immer sehen';
$string['forum:viewrating'] = 'Eigene Gesamtwertung sehen';
$string['forum:viewsubscribers'] = 'Abonnentenliste sehen';
$string['generalforum'] = 'Standardforum zur allgemeinen Nutzung';
$string['generalforums'] = 'Allgemeines Forum';
$string['inforum'] = 'in {$a}';
$string['introblog'] = 'Die Beiträge in diesem Forum wurden automatisch aus Teilnehmerblogs des Kurses erstellt, weil die Blogeinträge nicht mehr verfügbar sind';
$string['intronews'] = 'Nachrichten und Ankündigungen';
$string['introsocial'] = 'Offenes Forum ohne Themeneinschränkung';
$string['introteacher'] = 'Forum für Traineranmerkungen und -diskussionen';
$string['invalidaccess'] = 'Seitenzugriff war nicht korrekt';
$string['invaliddiscussionid'] = 'Falsche Themen-ID';
$string['invalidforcesubscribe'] = 'Falscher Modus beim Abonnement ';
$string['invalidforumid'] = 'Falsche Foren-ID';
$string['invalidparentpostid'] = 'Vorgänger Beitrags-ID war ungültig.';
$string['invalidpostid'] = 'Ungültige Beitrags-ID {$a}';
$string['lastpost'] = 'Letzter Beitrag';
$string['learningforums'] = 'Lernforen';
$string['longpost'] = 'Langer Beitrag';
$string['mailnow'] = 'Sofort als E-Mail';
$string['manydiscussions'] = 'Themen pro Seite';
$string['markalldread'] = 'Alle Beiträge dieser Diskussion als gelesen markieren';
$string['markallread'] = 'Alle Beiträge in diesem Forum als gelesen markieren';
$string['markread'] = 'Als gelesen markieren';
$string['markreadbutton'] = 'Als gelesen<br />markieren';
$string['markunread'] = 'Als ungelesen markieren';
$string['markunreadbutton'] = 'Als ungelesen<br /> markieren';
$string['maxattachments'] = 'Anhänge (max. Anzahl)';
$string['maxattachments_help'] = 'Diese Einstellung legt fest, wie viele Anhänge maximal pro Beitrag in diesem Forum erlaubt sind.';
$string['maxattachmentsize'] = 'Dateigröße (max.)';
$string['maxattachmentsize_help'] = 'Diese Einstellung legt fest, welche maximale Dateigröße pro Anhang in diesem Forum erlaubt ist.';
$string['maxtimehaspassed'] = 'Die Höchstdauer für die Bearbeitung dieses Eintrags ({$a}) ist überschritten!';
$string['message'] = 'Mitteilung';
$string['messageprovider:digests'] = 'Abonnierte Forenzusammenfassungen';
$string['messageprovider:posts'] = 'Abonnierte Forenbeiträge';
$string['missingsearchterms'] = 'Die folgenden Suchbegriffe tauchen lediglich in den HTML-Formatierungen dieser Mitteilung auf:';
$string['modeflatnewestfirst'] = 'Anzeige zeitlich sortiert (neu > alt)';
$string['modeflatoldestfirst'] = 'Anzeige zeitlich sortiert (alt > neu)';
$string['modenested'] = 'Anzeige in verschachtelter Form';
$string['modethreaded'] = 'Anzeige als hierarchische Struktur';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Mit der Aktivität \'Forum\' sind asynchrone Diskussionen möglich.';
$string['modulenameplural'] = 'Foren';
$string['more'] = 'weiter';
$string['movedmarker'] = '(Verschoben)';
$string['movethisdiscussionto'] = 'Das Thema verschieben nach ...';
$string['mustprovidediscussionorpost'] = 'Für den Export müssen Sie entweder eine Themen-ID oder eine Nachrichten-ID angeben';
$string['namenews'] = 'Nachrichtenforum';
$string['namenews_help'] = 'Das Nachrichtenforum ist ein spezielles Forum für Ankündigungen, welches automatisch von Moodle in jedem Kurs und auch der Startseite generiert wird. Ausschließlich Trainer/innen und Administrator/innen dürfen im Nachrichtenforum schreiben. Pro Kurs kann es nur ein Nachrichtenforum geben. Im Block "Neue Nachrichten" werden die aktuelle Beiträge angezeigt. ';
$string['namesocial'] = 'Soziales Forum';
$string['nameteacher'] = 'Trainerforum';
$string['newforumposts'] = 'Neue Forumsbeiträge';
$string['noattachments'] = 'Die Nachricht hat keine Anhänge';
$string['nodiscussions'] = 'Keine Themen im Forum';
$string['nodiscussionsstartedby'] = '\'{$a}\' hat noch kein Thema begonnen';
$string['nodiscussionsstartedbyyou'] = 'Sie haben noch kein Thema begonnen';
$string['noguestpost'] = 'Gäste dürfen keine Beiträge schreiben';
$string['noguesttracking'] = 'Gäste dürfen keine Einstellungen vornehmen';
$string['nomorepostscontaining'] = 'Es wurden keine weiteren Beiträge mit \'{$a}\' gefunden.';
$string['nonews'] = 'Keine Nachrichten im Forum';
$string['noonecansubscribenow'] = 'Abonnements sind jetzt nicht erlaubt';
$string['nopermissiontosubscribe'] = 'Sie haben nicht die Berechtigung die Liste der Foren-Abonnenten einzusehen';
$string['nopermissiontoview'] = 'Sie haben keine Berechtigung, diesen Beitrag anzusehen.';
$string['nopostforum'] = 'In diesem Forum können Sie keine Beiträge veröffentlichen';
$string['noposts'] = 'Keine Beiträge';
$string['nopostscontaining'] = 'Keine Beiträge gefunden, die in denen \'{$a}\' enthaltenen ist';
$string['nopostsmadebyuser'] = '\'{$a}\' hat keine Beiträge geschrieben';
$string['nopostsmadebyyou'] = 'Sie haben noch keine Beiträge geschrieben';
$string['noquestions'] = 'Keine Beiträge im Forum';
$string['nosubscribers'] = 'Keine Abonnent/innen im Forum';
$string['notexists'] = 'Diskussion existiert nicht länger';
$string['nothingnew'] = 'Nichts Neues für {$a}';
$string['notingroup'] = 'Das Forum steht nur für Mitglieder der Gruppe zur Verfügung';
$string['notinstalled'] = 'Das Modul \'Forum\' ist nicht installiert.';
$string['notpartofdiscussion'] = 'Dieser Beitrag ist nicht Teil einer Diskussion!';
$string['notrackforum'] = 'Ungelesene Beiträge nicht markieren';
$string['noviewdiscussionspermission'] = 'Sie dürfen die Themen in diesem Forum nicht sehen';
$string['nowallsubscribed'] = 'Sie haben alle Foren von {$a} abonniert';
$string['nowallunsubscribed'] = 'Sie haben kein Forum von {$a} abonniert';
$string['nownotsubscribed'] = '{$a->name} wird künftig KEINE Kopien von \'{$a->forum}\' per E-Mail erhalten.';
$string['nownottracking'] = '{$a->name} will \'{$a->forum}\' nicht weiter verfolgen.';
$string['nowsubscribed'] = '{$a->name} wird künftig Kopien von \'{$a->forum}\'  per E-Mail erhalten.';
$string['nowtracking'] = '{$a->name} verfolgt nun das \'{$a->forum}\'.';
$string['numposts'] = '{$a} Beiträge';
$string['olderdiscussions'] = 'Ältere Diskussionen';
$string['oldertopics'] = 'Ältere Beiträge';
$string['oldpostdays'] = '\'Gelesen\' nach x Tagen';
$string['openmode0'] = 'Keine neuen Themen, keine Antworten';
$string['openmode1'] = 'Keine neuen Themen, aber Antworten erlaubt';
$string['openmode2'] = 'Neue Themen und Antworten erlaubt';
$string['overviewnumpostssince'] = 'Beiträge seit dem letzten Login';
$string['overviewnumunread'] = 'Ungelesene Beiträge';
$string['parent'] = 'Ursprungsbeitrag';
$string['parentofthispost'] = 'Ursprungsbeitrag zum Beitrag';
$string['pluginadministration'] = 'Forum-Administration';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Ihr Beitrag wurde erfolgreich hinzugefügt. </p><p>Sofern Sie noch etwas korrigieren möchten, haben Sie dafür {$a} Zeit. Danach wird keine Änderung mehr angenommen.</p>';
$string['postaddedsuccess'] = 'Der Beitrag wurde erfolgreich eingefügt.';
$string['postaddedtimeleft'] = 'Sofern Sie noch etwas korrigieren möchten, haben Sie dafür {$a} Zeit. Danach wird keine Änderung mehr angenommen.';
$string['postincontext'] = 'Diskussion im Forum zeigen';
$string['postmailinfo'] = 'Dies ist die Kopie einer Mitteilung, die auf der Webseite \'{$a}\' eingetragen wurde.

Um darauf zu antworten, folgen Sie bitte diesem Link:';
$string['postmailnow'] = '<p>Dieser Beitrag wird direkt an alle eingetragenen Abonnent/innen dieses Forums versandt.</p>';
$string['postrating1'] = 'Nutzt Wissen über einzelne Fakten';
$string['postrating2'] = 'Reflektiert das Wissen in Einzelfällen';
$string['postrating3'] = 'Berücksichtigt den Gesamtzusammenhang und wägt Fakten ab';
$string['posts'] = 'Beiträge';
$string['postsmadebyuser'] = 'Beiträge von {$a}';
$string['postsmadebyuserincourse'] = 'Beiträge von {$a->fullname} in {$a->coursename}';
$string['posttoforum'] = 'Beitrag absenden';
$string['postupdated'] = 'Der Beitrag wurde aktualisiert';
$string['potentialsubscribers'] = 'Mögliche Abonnent/innen';
$string['processingdigest'] = 'Verarbeitung der E-Mail-Zusammenfassung für {$a}';
$string['processingpost'] = 'Beitrag {$a} wird bearbeitet';
$string['prune'] = 'Thema teilen';
$string['prunedpost'] = 'Mit diesem Beitrag wurde ein neues Thema begonnen';
$string['pruneheading'] = 'Das Thema teilen und mit diesem Beitrag ein neues Thema beginnen';
$string['qandaforum'] = 'Frage-Antwort-Forum';
$string['qandanotify'] = 'In diesem Frage-Antwort-Forum müssen Sie zuerst eine eigene Antworten eintragen, bevor Sie die Antworten anderer Personen sehen können';
$string['re'] = 'Re:';
$string['readtherest'] = 'weiterlesen...';
$string['replies'] = 'Antworten';
$string['repliesmany'] = '{$a} Antworten bis jetzt';
$string['repliesone'] = '{$a} Antwort bis jetzt';
$string['reply'] = 'Antwort';
$string['replyforum'] = 'Antwort ins Forum';
$string['replytouser'] = 'E-Mail-Adresse in Antwort verwenden';
$string['resetforums'] = 'Beiträge entfernen von';
$string['resetforumsall'] = 'Alle Beiträge löschen';
$string['resetsubscriptions'] = 'Alle Forumsabonnements entfernen';
$string['resettrackprefs'] = 'Alle Einstellungen zu Forenmarkierungen löschen';
$string['rssarticles'] = 'Anzahl der neuen RSS-Artikel';
$string['rssarticles_help'] = 'Diese Einstellung legt die Anzahl der Beiträge fest, die als aktuell in
den RSS-Feed übernommen werden. Eine Zahl zwischen 5 und 20 sollte bei den meisten Foren angemessen sein. Eine höhere Zahl ist erforderlich, wenn das Forum sehr aktiv ist.';
$string['rsssubscriberssdiscussions'] = 'RSS-Feed für Diskussionen';
$string['rsssubscriberssposts'] = 'RSS-Feed für Beiträge';
$string['rsstype'] = 'RSS-Feed für diese Aktivität';
$string['rsstype_help'] = 'Um RSS-Feeds für diese Aktivität zu aktivieren, wählen SIe entweder Themen oder Beiträge für diesen Feed aus.
';
$string['search'] = 'Suche';
$string['searchdatefrom'] = 'Beiträge müssen neuer sein als';
$string['searchdateto'] = 'Beiträge müssen älter sein als';
$string['searchforumintro'] = 'Tragen Sie die Suchbegriffe in einem oder mehreren Feldern ein:';
$string['searchforums'] = 'Suche in Foren';
$string['searchfullwords'] = 'Als vollständige Worte suchen';
$string['searchnotwords'] = 'Diese Worte sollen NICHT im Suchergebnis vorkommen';
$string['searcholderposts'] = 'Ältere Beiträge suchen...';
$string['searchphrase'] = 'Dieser Text muss genau so im Beitrag vorkommen';
$string['searchresults'] = 'Suchergebnisse';
$string['searchsubject'] = 'Diese Worte sollen im Betreff vorkommen';
$string['searchuser'] = 'Name des Autors/der Autorin';
$string['searchuserid'] = 'Moodle-ID des Autors/der Autorin';
$string['searchwhichforums'] = 'Forum für Suche auswählen';
$string['searchwords'] = 'Alle Worte können an jeder Stelle des Beitrags auftauchen';
$string['seeallposts'] = 'Alle Beiträge dieser Person ansehen';
$string['shortpost'] = 'Kurzer Beitrag';
$string['showsubscribers'] = 'Abonnentenliste';
$string['singleforum'] = 'Diskussion zu einzelnem Thema';
$string['smallmessage'] = '{$a->user} schrieb in {$a->forumname}';
$string['startedby'] = 'Begonnen von';
$string['subject'] = 'Betreff';
$string['subscribe'] = 'Ich möchte das Forum abonnieren';
$string['subscribeall'] = 'Alle Teilnehmer/innen haben in dieses Forum abonniert';
$string['subscribed'] = 'Abonniert';
$string['subscribeenrolledonly'] = 'Nur eingeschriebene Nutzer/innen dürfen Forumsbeiträge per E-Mail abonnieren.';
$string['subscribenone'] = 'Forum für alle Teilnehmer/innen abbestellen';
$string['subscribers'] = 'Abonnent/innen';
$string['subscribersto'] = 'Abonnent/innen für \'{$a}\'';
$string['subscribestart'] = 'Beiträge per E-Mail an mich senden';
$string['subscribestop'] = 'Keine Beiträge als E-Mail an mich senden';
$string['subscription'] = 'Abonnement';
$string['subscriptionauto'] = 'Automatisch';
$string['subscriptiondisabled'] = 'Deaktiviert';
$string['subscriptionforced'] = 'Verpflichtend';
$string['subscription_help'] = 'Wenn Sie ein Forum abonnieren, werden alle Beiträge dieses Forums per E-Mail an Sie gesandt.

Normalerweise dürfen Sie auswählen, ob Sie dieses Abonnement wünschen. Manche Foren sind allerdings so eingestellt, dass ein Abonnement verpflichtend ist und jeder alle Beiträge per E-Mail bekommt.';
$string['subscriptionmode'] = 'Abonnement';
$string['subscriptionmode_help'] = 'Alle, die ein Forum abonnieren, bekommen die Beiträge dieses Forums per E-Mail zugesandt.

Es gibt 4 Modi für ein Abonnement:

* Optional - alle dürfen auswählen, ob sie das Forum abonnieren möchten oder nicht
* Verpflichtend - alle haben das Forum abonniert und niemand kann es abbestellen
* Automatisch - alle haben das Forum abonniert, dürfen es aber jederzeit abbestellen
* Deaktiviert - Das Forum kann von niemandem abonniert werden';
$string['subscriptionoptional'] = 'Optional';
$string['subscriptions'] = 'Abonnements';
$string['thisforumisthrottled'] = 'Für dieses Forum ist eine Höchstzahl von Beiträgen innerhalb eines bestimmten Zeitraums festgelegt worden. Dies gilt nach {$a->blockafter} Beiträgen innerhalb von {$a->blockperiod}';
$string['timedposts'] = 'Zeitgesteuerte Beiträge';
$string['timestartenderror'] = 'Der Endtermin kann nicht vor dem Starttermin liegen.';
$string['trackforum'] = 'Ungelesene Beiträge markieren';
$string['tracking'] = 'Markieren?';
$string['trackingoff'] = 'Aus';
$string['trackingon'] = 'An';
$string['trackingoptional'] = 'Optional';
$string['trackingtype'] = 'Lesemarkierung';
$string['trackingtype_help'] = 'Wenn diese Option aktiviert ist, sehen Teilnehmer/innen gelesene und ungelesene Beiträge unterschiedlich markiert im Forum.

Es stehen drei Optionen zur Verfügung:

* Optional - Die Markierung ist ein- und ausschaltbar
* An  - Die Markierung ist immer an
* Aus - Die Markierung ist immer aus';
$string['unread'] = 'Ungelesen';
$string['unreadposts'] = 'Ungelesene Beiträge';
$string['unreadpostsnumber'] = '{$a} ungelesene Beiträge';
$string['unreadpostsone'] = '1 ungelesener Beitrag';
$string['unsubscribe'] = 'Ich möchte das Forum abbestellen';
$string['unsubscribeall'] = 'Ich möchte alle Foren abbestellen';
$string['unsubscribeallconfirm'] = 'Zahl der aktuell abonnierten Foren: {$a}. Möchten Sie wirklich alle Foren abbestellen und die automatische Anmeldung ausschalten?';
$string['unsubscribealldone'] = 'Sie haben alle Abonnements abbestellt. Trotzdem werden Sie Beiträge aus Foren erhalten, in die Personen zwingend eingetragen sind. Falls Sie gar keine E-Mails von diesem Server erhalten möchten, deaktivieren Sie bitte Ihre E-Mail-Adresse im Nutzerprofil.';
$string['unsubscribeallempty'] = 'Sie haben kein Forum abonniert. Falls Sie gar keine E-Mails von diesem Server erhalten möchten, deaktivieren Sie Ihre E-Mail-Adresse im Nutzerprofil.';
$string['unsubscribed'] = 'Abgemeldet';
$string['unsubscribeshort'] = 'Abmelden';
$string['usermarksread'] = '\'Gelesen\' manuell markieren';
$string['viewalldiscussions'] = 'Alle Themen anzeigen';
$string['warnafter'] = 'Warnung';
$string['warnafter_help'] = 'Vor dem Erreichen der Beitragshöchstzahl innerhalb des Zeitfensters können die Nutzer/innen gewarnt werden. Die Einstellung legt fest, nach wie vielen Beiträgen die Warnung gezeigt wird. Nutzer/innen mit der Berechtigung mod/forum:postwithoutthrottling sind von einer Sperre ausgenommen.';
$string['warnformorepost'] = 'Warnung! Es gibt mehr als eine Diskussion in diesem Forum. Es wird die Aktuellste genutzt.';
$string['yournewquestion'] = 'Neue Frage';
$string['yournewtopic'] = 'Neues Thema';
$string['yourreply'] = 'Antwort';
