<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_email', language 'ja', branch 'MOODLE_20_STABLE'
 *
 * @package   auth_email
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_changingemailaddress'] = 'あなたは、{$a->oldemail} から {$a->newemail} へのメールアドレス変更をリクエストしました。セキュリティ上の理由から、新しいメールアドレスがあなたのメールアドレスか確認するため、私たちはあなたにメッセージを送信しています。このメッセージ内のURIにアクセスすることで、あなたのメールアドレスがすぐに更新されます。';
$string['auth_emailchangecancel'] = 'メール変更をキャンセルする';
$string['auth_emailchangepending'] = '変更保留中です。あなたのメールアドレス {$a->preference_newemail} に送信されたメッセージ内のリンクにアクセスしてください。';
$string['auth_emaildescription'] = 'メールによるアカウント登録確認は、デフォルトの認証方法です。ユーザが新しいユーザ名およびパスワードを選択してサインアップした場合、アカウント確定用メールがユーザのメールアドレス宛に送信されます。このメールには、ユーザがアカウントの登録を確認するためのリンクが記入されています。アカウント確定後のログインでは、Moodleデータベースに保存されているユーザ名およびパスワードのみ確認します。';
$string['auth_emailnoemail'] = 'あなたへのメール送信を試みましたが、失敗しました!';
$string['auth_emailnoinsert'] = 'あなたのレコードをデータベースに追加できませんでした!';
$string['auth_emailnowexists'] = 'あなたのプロファイルに割り当てようと試みたメールアドレスは、あなたがリクエストした後、他のユーザに割り当てられています。このため、あなたのメールアドレス変更は、キャンセルされました。しかし、あなたは、他のメールアドレスを割り当てることができます。';
$string['auth_emailrecaptcha'] = 'Eメールによる自己登録ユーザのため、サインアップページにビジュアル/オーディオ確認フォームエレメントを追加します。これは、あなたのサイトをスパム発信者から守り、価値ある活動に貢献します。詳細は、http://www.google.com/recaptcha/learnmore をご覧ください。<br />PHP cURL拡張モジュールが必須です。';
$string['auth_emailrecaptcha_key'] = 'reCAPTCHAエレメントを有効にする';
$string['auth_emailsettings'] = '設定';
$string['auth_emailupdate'] = 'メールアドレス更新';
$string['auth_emailupdatemessage'] = '{$a->fullname} さん

あなたは、{$a->site} のアカウントに関するメールアドレス変更をリクエストしました。この変更を確認するには、あなたのブラウザで以下のURIにアクセスしてください。

{$a->url}';
$string['auth_emailupdatesuccess'] = 'ユーザ {$a->fullname} のメールアドレスは、正常に {$a->email} に変更されました。';
$string['auth_emailupdatetitle'] = '{$a->site} のメール更新確認';
$string['auth_invalidnewemailkey'] = 'エラー: あなたがメールアドレスの変更確認を試みているのでしたら、あなたに送信されたメール内のURIのコピーに失敗しているようです。URIをコピーして、もう一度お試しください。';
$string['auth_outofnewemailupdateattempts'] = 'あなたはメールアドレスの変更許容回数を超えました。あなたのメール変更リクエストはキャンセルされました。';
$string['pluginname'] = 'Eメールによる自己登録';
