<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'it', branch 'MOODLE_20_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'in procinto di essere installata';
$string['action'] = 'Azione';
$string['actions'] = 'Azioni';
$string['active'] = 'Attivo';
$string['activeusers'] = 'Utenti attivi';
$string['activities'] = 'Attività';
$string['activities_help'] = 'Le attività, come i forum, i quiz, i wiki, consentono di inserire contenuti interattivi nei corsi.';
$string['activity'] = 'Attività';
$string['activityclipboard'] = 'Stai spostando questa attività :<b>{$a}</b>';
$string['activityiscurrentlyhidden'] = 'Spiacente, al momento questa attività è disattivata';
$string['activitymodule'] = 'Modulo attività';
$string['activitymodules'] = 'Moduli attività';
$string['activityreport'] = 'Report delle attività';
$string['activityreports'] = 'Report delle attività';
$string['activityselect'] = 'Seleziona questa attività per spostarla';
$string['activitysince'] = 'Attività a partire da {$a}';
$string['activityweighted'] = 'Attività per utente';
$string['add'] = 'Aggiungi';
$string['addactivity'] = 'Aggiungi un\'attività ...';
$string['addadmin'] = 'Aggiungi amministratore';
$string['addblock'] = 'Aggiungi un blocco';
$string['addcomment'] = 'Scrivi un commento...';
$string['addcountertousername'] = 'Crea gli utenti aggiungendo un numero allo username';
$string['addcreator'] = 'Aggiungi creatore corsi';
$string['adddots'] = 'Aggiungi...';
$string['added'] = 'Aggiunto {$a}';
$string['addedrecip'] = 'Aggiunto {$a} nuovo destinatario';
$string['addedrecips'] = 'Aggiunti {$a} nuovi destinatari';
$string['addedtogroup'] = 'Aggiunto al gruppo "{$a}"';
$string['addedtogroupnot'] = 'Non è stato aggiunto al gruppo {$a}';
$string['addedtogroupnotenrolled'] = 'Non è stato aggiunto al gruppo "{$a}" in quanto non iscritto al corso';
$string['addinganew'] = 'Creazione {$a}';
$string['addinganewto'] = 'Aggiungi {$a->what} a {$a->to}';
$string['addingdatatoexisting'] = 'Aggiungi a dati esistenti';
$string['addnewcategory'] = 'Aggiungi una nuova categoria';
$string['addnewcourse'] = 'Aggiungi un corso';
$string['addnewuser'] = 'Nuovo utente';
$string['addnousersrecip'] = 'Aggiungi all\'elenco dei destinatari gli utenti che non hanno mai acceduto {$a}';
$string['addresource'] = 'Aggiungi una risorsa...';
$string['address'] = 'Indirizzo';
$string['addstudent'] = 'Aggiungi studente';
$string['addsubcategory'] = 'Aggiungi una sotto-categoria';
$string['addteacher'] = 'Aggiungi docente';
$string['admin'] = 'Amministratore';
$string['adminhelpaddnewuser'] = 'Crea manualmente un utente';
$string['adminhelpassignadmins'] = 'Gli amministratori possono fare tutto ed andare dovunque nel sito';
$string['adminhelpassigncreators'] = 'I creatori di corsi posso creare nuovi corsi';
$string['adminhelpassignsiteroles'] = 'Applica i ruoli del sito a specifici utenti';
$string['adminhelpassignstudents'] = 'Vai in un corso e aggiungi gli studenti dal menu di amministrazione';
$string['adminhelpauthentication'] = 'Puoi usare iscrizioni interne o basi di dati esterne';
$string['adminhelpbackup'] = 'Configura le copie di sicurezza e la loro programmazione';
$string['adminhelpconfiguration'] = 'Configura le variabili che agiscono sulle operazioni generali del sito.';
$string['adminhelpconfigvariables'] = 'Configura le variabili generali del sito';
$string['adminhelpcourses'] = 'Definisci corsi e categorie e assegnagli le persone';
$string['adminhelpeditorsettings'] = 'Impostazioni di base dell\'editor HTML';
$string['adminhelpedituser'] = 'Visualizza l\'elenco degli utenti e modificali';
$string['adminhelpenvironment'] = 'Verifica se il tuo server supporta la versione installata e le versioni future di Moodle';
$string['adminhelpfailurelogs'] = 'Visualizza log degli accessi falliti';
$string['adminhelphealthcenter'] = 'Rilevamento automatico di problemi di sito';
$string['adminhelplanguage'] = 'Controlla e modifica il language pack corrente';
$string['adminhelplogs'] = 'Visualizza i log di tutte le attività in questo sito';
$string['adminhelpmanageblocks'] = 'Gestisci i blocchi installati e le loro impostazioni';
$string['adminhelpmanagedatabase'] = 'Accedi direttamente alla base dati (Usare con molta attenzione!)';
$string['adminhelpmanagefilters'] = 'Scegli i filtri testuali e le relative impostazioni';
$string['adminhelpmanagemodules'] = 'Gestisci i moduli installati e le loro impostazioni';
$string['adminhelpmanageroles'] = 'Crea e definisci ruoli che possono essere assegnati agli utenti';
$string['adminhelpmymoodle'] = 'Configura i blocchi MyMoodle per gli utenti';
$string['adminhelpreports'] = 'Report per l\'intero sito';
$string['adminhelpsitefiles'] = 'Pubblica file generici e carica copie di salvataggio esterne';
$string['adminhelpsitesettings'] = 'Definisci come la pagina home deve essere visualizzata';
$string['adminhelpstickyblocks'] = 'Imposta blocchi "permanenti" per tutto il sito Moodle';
$string['adminhelpthemes'] = 'Scelta del tema del sito (colori, caratteri, ecc)';
$string['adminhelpuploadusers'] = 'Importa registrazioni di nuovi utenti da un file di testo';
$string['adminhelpusers'] = 'Definisci e configura il metodo di autenticazione degli utenti';
$string['adminhelpxmldbeditor'] = 'Interfaccia per la modifica dei files XMLDB. Solo per sviluppatori.';
$string['administration'] = 'Amministrazione';
$string['administrationsite'] = 'Amministrazione del sito';
$string['administrator'] = 'Amministratore';
$string['administratordescription'] = 'Di norma gli Amministratori possono fare qualsiasi cosa nel sito ed in tutti i corsi.';
$string['administrators'] = 'Amministratori';
$string['administratorsall'] = 'Tutti gli amministratori';
$string['administratorsandteachers'] = 'Amministratori e docenti';
$string['advanced'] = 'Avanzato';
$string['advancedfilter'] = 'Ricerca avanzata';
$string['advancedsettings'] = 'Impostazioni avanzate';
$string['again'] = 'ancora';
$string['aimid'] = 'AIM ID';
$string['ajaxno'] = 'No: utilizza le funzionalità di base del web';
$string['ajaxuse'] = 'AJAX e Javascript';
$string['ajaxyes'] = 'Si: utilizza le funzionalità avanzate del web';
$string['all'] = 'Tutti';
$string['allactions'] = 'Tutte le azioni';
$string['allactivities'] = 'Tutte le attività';
$string['allchanges'] = 'Tutte le modifiche';
$string['alldays'] = 'Tutti i giorni';
$string['allfieldsrequired'] = 'È obbligatoria la compilazione di tutti i campi';
$string['allfiles'] = 'Tutti i file';
$string['allgroups'] = 'Tutti i gruppi';
$string['alllogs'] = 'Tutti i log';
$string['allmods'] = 'Tutti {$a}';
$string['allow'] = 'Permettere';
$string['allowinternal'] = 'Permetti anche i metodi interni';
$string['allownone'] = 'Permetti nulla';
$string['allownot'] = 'Non permettere';
$string['allparticipants'] = 'Tutti i partecipanti';
$string['allteachers'] = 'Tutti i docenti';
$string['alphanumerical'] = 'Può contenere solamente caratteri alfanumerici, segno meno (-) o punto (.)  dell\'alfabeto o numeri';
$string['alreadyconfirmed'] = 'La registrazione è già  stata confermata';
$string['always'] = 'Sempre';
$string['and'] = '{$a->one} e {$a->two}';
$string['answer'] = 'Risposta';
$string['any'] = 'Qualsiasi';
$string['approve'] = 'Approva';
$string['areyousuretorestorethis'] = 'Sei sicuro di ripristinare i dati?';
$string['areyousuretorestorethisinfo'] = 'Più avanti ti verrà chiesto di ripristinare questo backup aggiungendo i dati ad un corso esistente oppure di crearne un corso nuovo.';
$string['asc'] = 'Crescente';
$string['assessment'] = 'Valutazione';
$string['assignadmins'] = 'Assegna amministratori';
$string['assigncreators'] = 'Assegna creatori corsi';
$string['assignsiteroles'] = 'Attribuisci ruoli a livello di sito';
$string['authenticateduser'] = 'Utente autenticato';
$string['authenticateduserdescription'] = 'Tutti gli utenti loggati.';
$string['authentication'] = 'Autenticazione';
$string['authenticationplugins'] = 'Plugin di autenticazione';
$string['autosubscribe'] = 'Auto iscrizione al forum';
$string['autosubscribeno'] = 'No: non iscrivermi automaticamente ai forum';
$string['autosubscribeyes'] = 'Si: quando invio post, iscrivimi a quel forum';
$string['availability'] = 'Disponibilità';
$string['availability_help'] = 'L\'impostazione determina la visibilità del corso nell\'elenco dei corsi. Gli amministratori ed i docenti potranno comunque accedervi, mentre gli altri utenti non potranno entrare nel corso.';
$string['availablecourses'] = 'Corsi disponibili';
$string['back'] = 'Indietro';
$string['backto'] = 'Torna a {$a}';
$string['backtocourselisting'] = 'Torna all\'elenco dei corsi';
$string['backtopageyouwereon'] = 'Torna alla pagina di provenienza';
$string['backtoparticipants'] = 'Torna alla pagina dei partecipanti';
$string['backup'] = 'Backup';
$string['backupactivehelp'] = 'Scegli se automatizzare o meno i backup';
$string['backupcancelled'] = 'Backup annullato';
$string['backupcoursefileshelp'] = 'Se abilitato, i file del corso saranno inclusi nel backup automatico';
$string['backupdate'] = 'Data del backup';
$string['backupdatenew'] = '{$a->TAG} ora è {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} era {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Dettagli del backup';
$string['backupexecuteathelp'] = 'Scegli a che ora devono essere effettuati i backup automatici';
$string['backupfailed'] = 'Alcuni dei vostri corsi non sono stati salvati!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Backup completato correttamente';
$string['backupfromthissite'] = 'Sono stati eseguiti backup in questo sito?';
$string['backupgradebookhistoryhelp'] = 'Se abilitato, lo storico delle valutazioni verrà incluso nei backup automatici. Affinché questa impostazione funzioni correttamente è necessario che lo storico delle valutazioni sia abilitato al livello di sistema.';
$string['backupincludemoduleshelp'] = 'Scegli se includere nei backup automatici i moduli dei corsi, con o senza i dati utente.';
$string['backupincludemoduleuserdatahelp'] = 'Scegli se vuoi includere i dati utente dei moduli nei backup automatici';
$string['backupkeephelp'] = 'Quante versioni di backup vuoi conservare per ciascun corso? (quella più vecchia verrà  eliminata automaticamente)';
$string['backuplogdetailed'] = 'Log dettagliato';
$string['backuploglaststatus'] = 'Log del backup più recente';
$string['backupmissinguserinfoperms'] = 'Nota: questo backup non contiene dati utente. Le attività Esercizio e workshop non saranno incluse nel backup poiché queste attività non sono compatibili con i backup privi di dati utente.';
$string['backupnext'] = 'Prossimo backup';
$string['backupnonisowarning'] = 'Attenzione: questo backup proviene da una versione di Moodle (pre 1.6) non-Unicode. Se il backup contiene qualche testo non-ISO-8859-1, questo potrebbe essere ALTERATO se ne viene fatto il ripristino sulla presente versione Unicode di Moodle. Leggere <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> per maggiori informazioni su come ripristinare correttamente questo backup.';
$string['backuporiginalname'] = 'Nome del backup';
$string['backuproleassignments'] = 'Backup delle assegnazioni per questi ruoli';
$string['backupsavetohelp'] = 'Percorso completo della directory dove vuoi salvare i file di backup<br />(lascia vuoto per salvarli nella directory standard)';
$string['backupsitefileshelp'] = 'Se abilitato, i file del sito saranno inclusi nei backup automatici';
$string['backuptakealook'] = 'Si prega di controllare i log dei backup in: {$a}';
$string['backupuserfileshelp'] = 'Scegli quali file utente (es immagini del profilo) devono essere incluse nei backup automatici';
$string['backupversion'] = 'Versione del backup';
$string['block'] = 'Blocco';
$string['blockconfiga'] = 'Configurazione del blocco {$a}';
$string['blockconfigbad'] = 'Questo blocco non è stato implementato correttamente e così non è possibile fornire un\'interfaccia di configurazione.';
$string['blockdeleteconfirm'] = 'Stai per eliminare il blocco \'{$a}\'. Saranno eliminati tutti i dati presenti nel database relativi al blocco.. Sei SICURO di continuare?';
$string['blockdeletefiles'] = 'Tutti i dati associati al blocco \'{$a->block}\' sono stati eliminati dal database. Per completare l\'eliminazione ed evitare che il blocco si re-installi automaticamente, devi eliminare anche la cartella {$a->directory} dal tuo server.';
$string['blocks'] = 'Blocchi';
$string['blocksaddedit'] = 'Aggiung/Modifica blocchi';
$string['blockseditoff'] = 'Termina modifica blocchi';
$string['blocksediton'] = 'Attiva modifica blocchi';
$string['blocksetup'] = 'Impostazione tabelle blocchi';
$string['blocksuccess'] = 'le tabelle {$a} sono state correttamente impostate';
$string['brief'] = 'Riassuntivo';
$string['bycourseorder'] = 'Ordina per corso';
$string['byname'] = 'di {$a}';
$string['bypassed'] = 'Aggirato';
$string['cachecontrols'] = 'Controlli Cache';
$string['cancel'] = 'Annulla';
$string['cancelled'] = 'Annullato';
$string['categories'] = 'Categorie di corso';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'La categoria \'{$a}\' è stata aggiunta';
$string['categorycontents'] = 'Sotto categorie e corsi';
$string['categorycurrentcontents'] = 'Contenuto di {$a}';
$string['categorydeleted'] = 'La categoria \'{$a}\' è stata eliminata';
$string['categoryduplicate'] = 'Esiste già una categoria di nome \'{$a}\'!';
$string['category_help'] = '<p>L\'amministratore di questo sito Moodle dovrebbe aver predisposto diverse categorie di corsi</p>

<p>Ad esempio "Scienze", "Lettere", "Medicina", eccetera.</p>

<p>Scegliete la categoria che ritenete più adatta per il vostro corso: poiché il titolo del corso comparirà all\'interno della categoria, una scelta appropriata faciliterà gli studenti nel reperire il vostro corso.</p>';
$string['categorymodifiedcancel'] = 'La categoria è stata modificata! Annulla e riprova.';
$string['categoryname'] = 'Nome categoria';
$string['categoryupdated'] = 'La categoria \'{$a}\' è stata aggiornata';
$string['changedpassword'] = 'Password modificata';
$string['changepassword'] = 'Cambia password';
$string['changessaved'] = 'Modifiche salvate';
$string['check'] = 'Verifica';
$string['checkall'] = 'Verifica tutto';
$string['checkingbackup'] = 'Verifica backup';
$string['checkingcourse'] = 'Verifica corso';
$string['checkingforbbexport'] = 'Verifica per l\'esportazione BlackBoard';
$string['checkinginstances'] = 'Verifica istanze';
$string['checkingsections'] = 'Verifica sezioni';
$string['checklanguage'] = 'Verifica lingua';
$string['checknone'] = 'Verifica nulla';
$string['childcoursenotfound'] = 'Il corso figlio non è stato trovato!';
$string['childcourses'] = 'Corsi figli';
$string['choose'] = 'Seleziona';
$string['choosecourse'] = 'Scegli un corso';
$string['choosedots'] = 'Scegli...';
$string['chooselivelogs'] = 'Oppure osserva le attività  in corso';
$string['chooselogs'] = 'Scegli i log da visualizzare';
$string['choosereportfilter'] = 'Seleziona  un filtro per il report';
$string['choosetheme'] = 'Seleziona un tema';
$string['chooseuser'] = 'Seleziona un utente';
$string['city'] = 'Città /Località';
$string['clambroken'] = 'L\'amministratore di Moodle ha abilitato il controllo dei virus per i file inviati ma ha sbagliato qualcosa.<br />Il tuo file NON è stato inviato correttamente. L\'amministratore è stato avvertito tramite email in modo che possa risolvere il problema.<br /> Riprova ad inviare il file più tardi.';
$string['clamdeletedfile'] = 'Il file è stato eliminato';
$string['clamdeletedfilefailed'] = 'Il file non può essere eliminato';
$string['clamemailsubject'] = '{$a} :: Notifica Clam AV';
$string['clamfailed'] = 'Clam AV ha avuto problemi durante l\'esecuzione. Il messaggio d\'errore era: {$a}. Qui trovate l\'output di Clam:';
$string['clamlost'] = 'Moodle è configurato per eseguire Clam all\'invio dei file, ma il percorso fornito per Clam AV, {$a}, non è corretto.';
$string['clamlostandactinglikevirus'] = 'In aggiunta, Moodle è impostato in modo che se Clam incontra problemi durante l\'esecuzione, i file siano trattati come virus. Questo essenzialmente significa che nessuno studente può inviare file correttamente finché questo non è corretto.';
$string['clammovedfile'] = 'Il file è stato spostato nella cartella di quarantena specificata, la nuova locazione è {$a}';
$string['clammovedfilebasic'] = 'Il file è stato spostato in una cartella di quarantena.';
$string['clamquarantinedirfailed'] = 'Non è possibile spostare il file nella cartella di quarantena specificata, {$a}. E\' necessario correggere l\'impostazione in modo che i file infetti vengano eliminati.';
$string['clamunknownerror'] = 'Clam ha segnalato un errore sconosciuto.';
$string['cleaningtempdata'] = 'Eliminazione dati temporanei';
$string['clear'] = 'Svuota';
$string['clickhelpiconformoreinfo'] = '...prosegue...Fate click sulla icona aiuto per accedere all\'articolo completo';
$string['clickhere'] = 'Clicca qui ...';
$string['clicktochange'] = 'Clicca per cambiare';
$string['clicktohideshow'] = 'Click per aprire e chiudere';
$string['closewindow'] = 'Chiudi questa finestra';
$string['collapseall'] = 'Minimizza tutto';
$string['commentincontext'] = 'Trova questo commento nel contesto';
$string['comments'] = 'Commenti';
$string['commentsnotenabled'] = 'La funzionalità commenti non è abilitata';
$string['commentsrequirelogin'] = 'Per visualizzare i commenti devi autenticarti.';
$string['comparelanguage'] = 'Confronta e modifica la lingua in uso';
$string['complete'] = 'Completo';
$string['completereport'] = 'Report completo';
$string['configuration'] = 'Configurazione';
$string['confirm'] = 'Conferma';
$string['confirmcheckfull'] = 'Sei sicuro di confermare {$a}?';
$string['confirmed'] = 'La tua registrazione è stata confermata';
$string['confirmednot'] = 'La tua registrazione non è stata ancora confermata';
$string['content'] = 'Contenuto';
$string['continue'] = 'Continua';
$string['continuetocourse'] = 'Clicca qui per entrare nel tuo corso';
$string['convertingwikitomarkdown'] = 'Conversione dal formato Wiki al formato Markdown in corso...';
$string['cookiesenabled'] = 'I cookies devono essere abilitati nel tuo browser';
$string['cookiesenabled_help'] = '<p>I siti Moodle utilizzano due tipi di cookie.</p>

<p>Il primo è un cookie di sessione chiamato <b>MoodleSession</b>. E\' indispensabile che il browser sia configurato per accettare questo cookie al fine di garantire la validità della propria autenticazione navigando tra le pagine mantenendo il proprio login. Quando ci si scollega dal sito Moodle o si chiude il browser, il cookie <b>MoodleSession</b> viene cancellato.</p>

<p>Il secondo cookie, generalmente chiamato <b>MOODLEID</b>, serve solo per ricordare il vostro username all\'interno del browser. Grazie a questo cookie quando ritornerete a far vista al sito Moodle, troverete il campo della pagina di login già riempito con il vostro username. Non ci sono problemi se rifiutate di accettare questo cookie, l\'unico inconveniente sarà quello di dover inserire nuovamente il vostro username nella pagina di login.</p>';
$string['cookiesnotenabled'] = 'Purtroppo al momento i cookie non sono abilitati nel tuo browser.';
$string['copy'] = 'copia';
$string['copyasnoun'] = 'copia';
$string['copyingcoursefiles'] = 'Copia dei file del corso';
$string['copyingsitefiles'] = 'Copia dei file del sito usati nel corso';
$string['copyinguserfiles'] = 'Copia dei file utente';
$string['copyingzipfile'] = 'Copia dei file compressi';
$string['copyrightnotice'] = 'Informazioni sul copyright';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Costo';
$string['costdefault'] = 'Costo standard';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Nazione';
$string['course'] = 'Corso';
$string['courseadministration'] = 'Amministrazione del corso';
$string['courseapprovedemail'] = 'Il corso da te richiesto, {$a->name}, è stato approvato e ti è stato assegnato il ruolo {$a->teacher}. Per accedere al nuovo corso, vai a {$a->url}';
$string['courseapprovedemail2'] = 'Il corso da te richiesto, {$a->name}, è stato approvato. Per accedere al nuovo corso, vai a {$a->url}';
$string['courseapprovedfailed'] = 'E\' fallito il salvataggio dell\'approvazione del corso';
$string['courseapprovedsubject'] = 'Il corso è stato approvato';
$string['courseavailable'] = 'Corso disponibile agli studenti';
$string['courseavailablenot'] = 'Corso non disponibile agli studenti';
$string['coursebackup'] = 'Backup del corso';
$string['coursecategories'] = 'Categorie di corso';
$string['coursecategory'] = 'Categoria del corso';
$string['coursecategorydeleted'] = 'La categoria di corsi {$a} è stata eliminata';
$string['coursecompletion'] = 'Completamento corso';
$string['coursecompletions'] = 'Corsi completati';
$string['coursecreators'] = 'Creatore di corsi';
$string['coursecreatorsdescription'] = 'I creatori di corsi possono creare nuovi corsi.';
$string['coursedeleted'] = 'Corso {$a} eliminato';
$string['coursefiles'] = 'File legacy del corso';
$string['coursefilesedit'] = 'Gestisci file legacy del corso';
$string['coursefileswarning'] = 'I file del corso sono obsoleti';
$string['coursefileswarning_help'] = 'I File del corso sono stati deprecati a partire da Moodle 2.0. Per favore utilizza i repository esterni.';
$string['courseformatdata'] = 'Dati sul formato del corso';
$string['courseformats'] = 'Tipologie di corso';
$string['coursegrades'] = 'Valutazioni del corso';
$string['coursehelpcategory'] = 'Definisce a quale categoria apparterrà il corso.';
$string['coursehelpforce'] = 'Forza la modalità gruppo prescelta in qualsiasi attività presente nel corso.';
$string['coursehelpformat'] = 'Il formato con il quale sarà visualizzata la pagina principale del corso.';
$string['coursehelphiddensections'] = 'Imposta se ed in quale modo gli studenti visualizzeranno le sezioni nascoste nella pagina principale del corso.';
$string['coursehelpmaximumupload'] = 'Definisce la dimensione massima dei file che sarà possibile caricare nel corso. Questa dimensione  non può eccedere il limite impostato a livello di sito.';
$string['coursehelpnewsitemsnumber'] = 'Il numero di nuovi post del Forum News da far comparire nel blocco "Ultime notizie".  (Impostando il valore a 0, il blocco "Ultime notizie" non comparirà).';
$string['coursehelpnumberweeks'] = 'Il numero di settimane o di argomenti ("sezioni") che saranno visualizzati nella pagina principale del corso.';
$string['coursehelpshowgrades'] = 'Gli studenti possono essere autorizzati a vedere il proprio registro valutazioni. Indipendentemente da questa impostazione, gli studenti potranno comunque visualizzare le valutazioni ricevute nelle singole attività.';
$string['coursehidden'] = 'Questo corso al momento non è disponibile agli studenti';
$string['courseinfo'] = 'Informazioni sul corso';
$string['courselegacyfiles'] = 'File legacy del corso';
$string['courselegacyfiles_help'] = 'I File del corso forniscono una compatibilità con Moodle 1.9 e versioni precedenti. I file presenti in quest\'area sono sempre accessibili a tutti i partecipanti al corso, indipendentemente se sono collegati o meno tramite un link. Inoltre non è possibile sapere dove i file sono utilizzati da Moodle.

Utilizzando i File del corso ti esponi ad una serie di problemi di privacy, di sicurezza e problemi di backup, ripristino ed importazione: in generale potresti incorre in problemi tutte le volte che un file è riutilizzato o condiviso. Si raccomanda di non usare i File del corso a meno che non ti siano perfettamente chiare le limitazioni.

Il link sottostante fornisce una serie di utili informazioni su come gestire assai meglio i file grazie alle caratteristiche di  Moodle 2.0.';
$string['coursemessage'] = 'Messaggio ai partecipanti';
$string['coursenotaccessible'] = 'Questo corso non è abilitato all\'accesso pubblico';
$string['courseoverview'] = 'Sommario del corso';
$string['courseoverviewgraph'] = 'Grafico riassuntivo del corso';
$string['courseprofiles'] = 'Profili corso';
$string['coursereasonforrejecting'] = 'Motivazione del rifiuto';
$string['coursereasonforrejectingemail'] = 'La motivazione sarà inviata per email al richiedente';
$string['coursereject'] = 'Rifiuta l\'attivazione di un corso a richiesta';
$string['courserejected'] = 'L\'attivazione del corso è stata rifiutata ed il richiedente è stato avvisato.';
$string['courserejectemail'] = 'Spiacente, la tua richiesta di attivazione del corso è stata rifiutata con la seguente motivazione:

{$a}';
$string['courserejectreason'] = 'Sintetizzate la motivazione per il rifiuto della creazione di questo corso<br /> (verrà  spedita al richiedente)';
$string['courserejectsubject'] = 'La tua richiesta di attivazione del corso è stata rifiutata';
$string['coursereport'] = 'Report del corso';
$string['coursereports'] = 'Report del corso';
$string['courserequest'] = 'Corsi a richiesta';
$string['courserequestdetails'] = 'Dettagli del corso che desideri sia attivato';
$string['courserequestfailed'] = 'Per qualche motivo, non è stato possibile salvare la tua richiesta';
$string['courserequestintro'] = 'Utilizzare questo modulo per richiedere la creazione di un corso.<br /> Fornire più informazioni possibili per permettere agli amministratori di capire la motivazione della richiesta.';
$string['courserequestreason'] = 'Motivazione della richiesta';
$string['courserequestsuccess'] = 'La tua richiesta di attivazione è stata salvata. L\'esito della richiesta vi sarà inviato tramite email.';
$string['courserequestsupport'] = 'Informazioni aggiuntive per consentire agli Amministratori di valutare al meglio la richiesta';
$string['courserestore'] = 'Recupera corso';
$string['courses'] = 'Corsi';
$string['coursesectionsummaries'] = 'Sommari delle sezioni del corso';
$string['coursesettings'] = 'Default creazione corsi';
$string['coursesmovedout'] = 'Corsi spostati da {$a}';
$string['coursespending'] = 'Corsi a richiesta in attesa di approvazione';
$string['coursestart'] = 'Inizio corso';
$string['coursesummary'] = 'Introduzione al corso';
$string['coursesummary_help'] = 'L\'introduzione verrà visualizzata nell\'elenco dei corsi e sarà anche utilizzata per cercare corsi.';
$string['courseupdates'] = 'Aggiornamenti del corso';
$string['courseuploadlimit'] = 'Dimensione massima file caricabili nel corso';
$string['create'] = 'Crea';
$string['createaccount'] = 'Crea il mio nuovo account';
$string['createcategory'] = 'Crea una categoria';
$string['createfolder'] = 'Crea una cartella dentro {$a}';
$string['createuserandpass'] = 'Scegli username e password';
$string['createziparchive'] = 'Crea un archivio compresso';
$string['creatingblocks'] = 'Creazione blocchi';
$string['creatingblocksroles'] = 'Creazione attribuzioni di ruolo a livello di blocco e relative modifiche';
$string['creatingblogsinfo'] = 'Creazione info dei blog';
$string['creatingcategoriesandquestions'] = 'Creazione categorie e domande';
$string['creatingcoursemodules'] = 'Creazione moduli corso';
$string['creatingcourseroles'] = 'Creazione attribuzioni di ruolo a livello di corso e relative modifiche';
$string['creatingevents'] = 'Creazione eventi';
$string['creatinggradebook'] = 'Creazione registro valutazioni';
$string['creatinggroupings'] = 'Creazione raggruppamenti';
$string['creatinggroupingsgroups'] = 'Aggiunta gruppi in raggruppamenti';
$string['creatinggroups'] = 'Creazione gruppi';
$string['creatinglogentries'] = 'Creazione record di log';
$string['creatingmessagesinfo'] = 'Creazione informazioni dei messaggi';
$string['creatingmodroles'] = 'Creazione attribuzioni di ruolo a livello di modulo e relative modificheo';
$string['creatingnewcourse'] = 'Creazione nuovo corso';
$string['creatingrolesdefinitions'] = 'Creazione definizione dei ruoli';
$string['creatingscales'] = 'Creazione scale';
$string['creatingsections'] = 'Creazione sezioni';
$string['creatingtemporarystructures'] = 'Creazione strutture temporanee';
$string['creatinguserroles'] = 'Creazione attribuzioni di ruolo a livello di utente e relative modificheo';
$string['creatingusers'] = 'Creazione utenti';
$string['creatingxmlfile'] = 'Creazione file XML';
$string['currency'] = 'Valuta';
$string['currentcourseadding'] = 'Corso in uso, accoda i dati';
$string['currentcoursedeleting'] = 'Corso in uso, sostituisci i dati';
$string['currentlanguage'] = 'Lingua in uso';
$string['currentlocaltime'] = 'La tua ora locale';
$string['currentlyselectedusers'] = 'Utenti già selezionati';
$string['currentpicture'] = 'Immagine attuale';
$string['currentrelease'] = 'Informazioni sulla versione attuale';
$string['currentversion'] = 'Versione installata';
$string['databasechecking'] = 'Aggiornamento del database di Moodle dalla versione {$a->oldversion} to {$a->newversion}...';
$string['databaseperformance'] = 'Prestazioni database';
$string['databasesetup'] = 'Impostazione database';
$string['databasesuccess'] = 'Il database è stato aggiornato con successo';
$string['databaseupgradebackups'] = 'La versione del backup ora è {$a}';
$string['databaseupgradeblocks'] = 'La versione dei blocchi ora è {$a}';
$string['databaseupgradegroups'] = 'La versione dei gruppi ora è {$a}';
$string['databaseupgradelocal'] = 'La versione della personalizzazione locale del database è ora {$a}';
$string['databaseupgrades'] = 'Aggiornamento database';
$string['date'] = 'Data';
$string['datechanged'] = 'Data di modifica';
$string['datemostrecentfirst'] = 'Data - la più recente per prima';
$string['datemostrecentlast'] = 'Data - la più recente per ultima';
$string['day'] = 'giorno';
$string['days'] = 'giorni';
$string['decodinginternallinks'] = 'Decodifica collegamenti interni';
$string['default'] = 'Default';
$string['defaultcoursestudent'] = 'Studente';
$string['defaultcoursestudentdescription'] = 'Gli studenti all\'interno di un corso di norma hanno meno privilegi.';
$string['defaultcoursestudents'] = 'Studenti';
$string['defaultcoursesummary'] = 'Scrivi un paragrafo breve ma interessante che spieghi le caratteristiche di questo corso.';
$string['defaultcourseteacher'] = 'Docente';
$string['defaultcourseteacherdescription'] = 'I docenti possono fare tutto all\'interno di un corso, come modificare le attività e valutare gli studenti.';
$string['defaultcourseteachers'] = 'Docenti';
$string['delete'] = 'Elimina';
$string['deleteablock'] = 'Elimina blocco';
$string['deleteall'] = 'Elimina tutto';
$string['deleteallcannotundo'] = 'Elimina tutto - non sarà possibile tornare indietro';
$string['deleteallcomments'] = 'Elimina tutti i commenti';
$string['deleteallratings'] = 'Elimina tutte le valutazioni';
$string['deletecategory'] = 'Elimina categoria: {$a}';
$string['deletecategorycheck'] = 'Sei sicuro di eliminare questa categoria <b>\'{$a}\'</b>?<br />Questa operazione sposterà tutti i corsi nella categoria padre, se esiste, o in quella Generale.';
$string['deletecategorycheck2'] = 'Prima di eliminare questa categoria, è necessario decidere cosa fare dei corsi e delle sotto categorie che contiene.';
$string['deletecategoryempty'] = 'Questa categoria è vuota.';
$string['deletecheck'] = 'Elimino {$a} ?';
$string['deletecheckfiles'] = 'Se sicuro di eliminare questi file?';
$string['deletecheckfull'] = 'Sei sicuro di eliminare {$a} ?';
$string['deletecheckwarning'] = 'Stai per eliminare questi file';
$string['deletecomment'] = 'Elimina il commento';
$string['deletecompletely'] = 'Elimina completamente';
$string['deletecourse'] = 'Elimina un corso';
$string['deletecoursecheck'] = 'Sei sicuro eliminare questo corso e tutti i dati che contiene?';
$string['deleted'] = 'Eliminato';
$string['deletedactivity'] = '{$a} è stato eliminato';
$string['deletedcourse'] = '{$a} è stato eliminato completamente';
$string['deletednot'] = 'Non è stato possibile eliminare {$a} !';
$string['deletelogs'] = 'Elimina i log';
$string['deleteselected'] = 'Elimina i selezionati';
$string['deleteselectedkey'] = 'Elimina chiave selezionata';
$string['deletingcourse'] = 'Eliminazione di {$a}';
$string['deletingexistingcoursedata'] = 'Eliminazione dei dati del corso';
$string['deletingolddata'] = 'Eliminazione vecchi dati';
$string['department'] = 'Dipartimento';
$string['desc'] = 'Decrescente';
$string['description'] = 'Descrizione';
$string['deselectall'] = 'Deseleziona tutto';
$string['detailedless'] = 'Meno dettagli';
$string['detailedmore'] = 'Più dettagli';
$string['directory'] = 'Cartella';
$string['disable'] = 'Disabilita';
$string['disabledcomments'] = 'I commenti non sono abilitati';
$string['displayingfirst'] = 'Sono visualizzati solo il primi {$a->count} {$a->things}';
$string['displayingrecords'] = 'Visualizzazione di {$a} record';
$string['displayingusers'] = 'Visualizza gli iscritti a partire da {$a->start} fino a {$a->end}';
$string['displayonpage'] = 'Visualizza nella pagina';
$string['documentation'] = 'Documentazione Moodle';
$string['down'] = 'In basso';
$string['download'] = 'Download';
$string['downloadall'] = 'Download di tutto';
$string['downloadexcel'] = 'Download in formato Excel';
$string['downloadfile'] = 'Download file';
$string['downloadods'] = 'Download in formato ODS';
$string['downloadtext'] = 'Download in formato testo';
$string['doyouagree'] = 'Hai letto queste condizioni e le hai accettate?';
$string['duplicate'] = 'Duplica';
$string['duplicatinga'] = 'Duplicazione: {$a}';
$string['duplicatingain'] = 'Duplicazione di {$a->what} in {$a->in}';
$string['edhelpaspellpath'] = 'Per usare il controllo ortografico nell\'editor HTML, è necessario installare <strong>aspell 0.50</strong> o una versione successiva sul server. Inoltre è necessario specificare il percorso di accesso alle librerie aspell nella configurazione di Moodle. Su sistemi Unix/Linux, in genere il percorso è <strong>/usr/bin/aspell</strong>.';
$string['edhelpbgcolor'] = 'Imposta il colore di sfondo dell\'area di edit.<br /> Valori possibili sono per esempio: #ffffff o white';
$string['edhelpcleanword'] = 'Questa impostazione abilita o disabilita il filtro del formato Word.';
$string['edhelpenablespelling'] = 'Abilita o disabilita il controllo ortografico. Quando abilitato <strong>aspell</strong> deve essere installato sul server.';
$string['edhelpfontfamily'] = 'La proprietà font-family è un elenco di nomi di font e/o font generici (es. serif). I nomi devono essere separati da virgole.';
$string['edhelpfontlist'] = 'Definisce i font utilizzati nel menu a discesa dell\'editor.';
$string['edhelpfontsize'] = 'font-size imposta la dimensione standard per i font.<br />Valori possibili sono per esempio: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Modifica';
$string['edita'] = 'Modifica {$a}';
$string['editcategorysettings'] = 'Modifica impostazioni categoria';
$string['editcategorythis'] = 'Modifica questa categoria';
$string['editcoursesettings'] = 'Modifica impostazioni del corso';
$string['editfiles'] = 'Modifica i file';
$string['editgroupprofile'] = 'Modifica profilo del gruppo';
$string['editinga'] = 'Modifica di {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Questo valore non può essere modificato!';
$string['editmyprofile'] = 'Modifica';
$string['editorbgcolor'] = 'Colore di sfondo';
$string['editorcleanonpaste'] = 'Pulisci HTML di Word incollandolo';
$string['editorcommonsettings'] = 'Impostazioni comuni';
$string['editordefaultfont'] = 'Font di default';
$string['editorenablespelling'] = 'Abilita controllo ortografico';
$string['editorfontlist'] = 'Elenco font';
$string['editorfontsize'] = 'Dimensione standard del font';
$string['editorresettodefaults'] = 'Ripristina i valori standard';
$string['editorsettings'] = 'Impostazioni editor';
$string['editorshortcutkeys'] = 'Tasti di scelta rapida dell\'editor';
$string['editsettings'] = 'Impostazioni';
$string['editsummary'] = 'Modifica introduzione';
$string['editthisactivity'] = 'Modifica questa attività';
$string['editthiscategory'] = 'Modifica questa categoria';
$string['edituser'] = 'Modifica account utenti';
$string['email'] = 'Indirizzo email';
$string['emailactive'] = 'Email attiva';
$string['emailagain'] = 'Indirizzo email (ripeti)';
$string['emailcharset'] = 'Codifica caratteri delle email';
$string['emailconfirm'] = 'Conferma il tuo account';
$string['emailconfirmation'] = 'Salve {$a->firstname},

Un nuovo account è stato richiesto a \'{$a->sitename}\' usando il tuo indirizzo di posta elettronica.

Per confermare questo account, devi cliccare sul seguente link:

{$a->link}

In molti programmi di posta, questo dovrebbe apparire come un link colorato di blu sul quale è sufficiente cliccare. Se in questo modo non dovesse funzionare, allora taglia e incolla il link nella finestra degli indirizzi in alto nel tuo browser e premi invio.

Se hai bisogno di aiuto, contatta l\'amministratore del sito,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: conferma iscrizione';
$string['emailconfirmsent'] = '<p>Una email è stata inviata al tuo indirizzo <b>{$a}</b></p>
<p>Contiene semplici istruzioni per completare la tua registrazione.</p>
<p>Se hai qualche difficoltà contatta l\'amministratore del sito.</p>';
$string['emaildigest'] = 'Tipo di raccolta email';
$string['emaildigestcomplete'] = 'Completa (giornalmente invia i messaggi completi)';
$string['emaildigestoff'] = 'Nessuna raccolta (ogni messaggio viene spedito via mail)';
$string['emaildigestsubjects'] = 'Oggetti (giornalmente invia solo gli oggetti dei messaggi)';
$string['emaildisable'] = 'Questo indirizzo email è disabilitato.';
$string['emaildisableclick'] = 'Clicca qui per disabilitare tutte le email dall\'essere spedite a questo indirizzo';
$string['emaildisplay'] = 'Mostra email';
$string['emaildisplaycourse'] = 'Permetti solo agli altri iscritti al corso di vedere il mio indirizzo email';
$string['emaildisplayhidden'] = 'Email nascosta';
$string['emaildisplayno'] = 'Non mostrare il mio indirizzo email agli altri';
$string['emaildisplayyes'] = 'Mostra il mio indirizzo email agli altri';
$string['emailenable'] = 'Questo indirizzo email è abilitato.';
$string['emailenableclick'] = 'Clicca qui per riabilitare tutte le email che sono spedite a questo indirizzo';
$string['emailexists'] = 'Questo indirizzo email è già esistente.';
$string['emailformat'] = 'Formato email';
$string['emailmustbereal'] = 'Nota: il tuo indirizzo email deve essere esistente';
$string['emailnotallowed'] = 'Gli indirizzi email di questi domini non sono ammessi ({$a})';
$string['emailnotfound'] = 'L\'indirizzo email non è stato trovato nella base dati';
$string['emailonlyallowed'] = 'Questo indirizzo email non è uno di quelli ammessi ({$a})';
$string['emailpasswordchangeinfo'] = 'Salve {$a->firstname},

qualcuno (probabilmente tu) ha richiesto una nuova password per la tua registrazione su \'{$a->sitename}\'.

Per cambiare la tua password vai al seguente indirizzo web:

{$a->link}

Nella maggior parte dei programmi di posta, questo dovrebbe apparire come un link blu che puoi cliccare. Se questo non funziona, taglia e incolla l\'indirizzo nell\'area indirizzi in alto nel tuo browser.

Se hai bisogno di aiuto, contatta l\'amministratore del sito, {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Salve {$a->firstname},

qualcuno (probabilmente tu) ha richiesto una nuova password per la tua registrazione su \'{$a->sitename}\'.
Sfortunatamente il tuo account su questo sito è disabilitato e non può essere riabilitato.
Contatta l\'amministratore del sito, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Ciao {$a->firstname},

qualcuno (probabilmente tu) ha chiesto una nuova password per il tuo account su \'{$a->sitename}\'.

Purtroppo su questo sito non possono essere cambiate: per favore contatta l\'amministratore {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informazioni su cambio password';
$string['emailpasswordconfirmation'] = 'Salve, {$a->firstname},

qualcuno (probabilmente tu) ha richiesto una nuova password per il tuo accesso a \'{$a->sitename}\'.

Per confermare la richiesta e per ricevere la nuova password tramite email, vai al seguente indirizzo web:

{$a->link}

In molti programmi di posta, questo dovrebbe apparire come un link colorato di blu sul quale è sufficiente cliccare. Se in questo modo non dovesse funzionare, allora taglia e incolla il link nella finestra degli indirizzi in alto nel tuo browser e premi invio.

Se hai bisogno di aiuto, puoi contattare l\'amministratore del sito,
{$a->admin}.';
$string['emailpasswordconfirmationsubject'] = '{$a}: Conferma cambiamento password';
$string['emailpasswordconfirmmaybesent'] = '<p> Se hai fornito uno username corretto o un indirizzo corretto, dovresti ricevere una email.</p>
<p>Nel messaggio troverai le istruzioni per confermare e completare la modifica della password. Se continui ad avere difficoltà, contatta l\'amministratore del sito.</p>';
$string['emailpasswordconfirmsent'] = 'Una email sarà spedita al tuo indirizzo <b>{$a}</b>.

<p>Essa contiene facili istruzioni per confermare e completare il cambiamento della password.

Se continui ad avere difficoltà, contatta l\'amministratore del sito.</p>';
$string['emailpasswordsent'] = 'Grazie per aver confermato il cambiamento di password.

<p>Una email contenente la tua nuova password è stata spedita al tuo indirizzo presso <b>{$a->email}</b>.</p>

<p>La nuova password è stata generata in modo automatico - se tu vuoi, puoi <a href="{$a->link}">cambiare la password</a> con qualcosa che sia più facile da ricordare.';
$string['enable'] = 'Abilita';
$string['encryptedcode'] = 'Codice criptato';
$string['english'] = 'Inglese';
$string['entercourse'] = 'Clicca per accedere a questo corso';
$string['enteremail'] = 'Inserisci la tua email';
$string['enteremailaddress'] = 'Digita la tuo email per e ottenere una nuova password che ti sarà spedita via email.';
$string['enterusername'] = 'Inserisci il tuo username';
$string['entries'] = 'Elementi';
$string['error'] = 'Errore';
$string['errortoomanylogins'] = 'Spiacente hai superato il numero ti tentativi di login permessi. Fai ripartire il tuo browser.';
$string['errorwhenconfirming'] = 'La tua iscrizione non è stata ancora confermata a causa di un errore. Se hai cliccato sul link di una email per arrivare qui, assicurati che la riga nella tua email non era spezzata o andava accapo. Potresti dover utilizzare Copia e Incolla per ricostruire il link corretto.';
$string['everybody'] = 'Tutti';
$string['executeat'] = 'Esegui alle';
$string['existing'] = 'Esistente';
$string['existingadmins'] = 'Amministratori esistenti';
$string['existingcourse'] = 'Corso esistente';
$string['existingcourseadding'] = 'Corso esistente, accoda i dati';
$string['existingcoursedeleting'] = 'Corso esistente, sostituisci i dati';
$string['existingcreators'] = 'Creatori di corsi esistenti';
$string['existingstudents'] = 'Studenti iscritti';
$string['existingteachers'] = 'Docenti esistenti';
$string['expandall'] = 'Espandi tutto';
$string['expirynotify'] = 'Notifica scadenza iscrizione';
$string['expirynotifyemail'] = 'Gli studenti qui elencati saranno disinscritti da questo corso tra esattamente {$a->threshold} giorni:

{$a->current}

Questi altri saranno disiscritti da questo corso in meno di {$a->threshold} giorni:

{$a->past}

È possibile andare alla pagina seguente per estendere la durata della loro iscrizione:
{$a->extendurl}';
$string['expirynotifystudents'] = 'Avverti gli studenti';
$string['expirynotifystudentsemail'] = 'Caro {$a->studentstr}:

Ti informiamo che la tua l\'iscrizione al corso {$a->course} scadrà tra {$a->threshold} giorni.

Per ulteriori informazioni puoi contattare {$a->teacherstr}';
$string['expirynotifystudents_help'] = 'Se è stata specificata una durata per l\'iscrizione al corso, questa impostazione consente di avvertire gli studenti via email quando la loro iscrizione sta per scadere.';
$string['expirythreshold'] = 'Soglia';
$string['expirythreshold_help'] = 'Imposta quanti giorni prima della scadenza dell\'iscrizione sarà inviata la notifica agli studenti.';
$string['explanation'] = 'Spiegazione';
$string['extendenrol'] = 'Prolunga iscrizione';
$string['extendperiod'] = 'Estendi periodo';
$string['failedloginattempts'] = '{$a->attempts} accessi falliti dall\'ultimo accesso corretto';
$string['failedloginattemptsall'] = '{$a->attempts} accessi falliti per {$a->accounts} utenti';
$string['feedback'] = 'Feedback';
$string['file'] = 'File';
$string['filemissing'] = '{$a} è mancante';
$string['files'] = 'File';
$string['filesfolders'] = 'File/Cartelle';
$string['filloutallfields'] = 'Compila tutti i campi di questo form';
$string['filter'] = 'Filtro';
$string['findmorecourses'] = 'Trova altri corsi...';
$string['firstaccess'] = 'Primo accesso';
$string['firstname'] = 'Nome';
$string['firsttime'] = 'È la prima volta che accedi qui?';
$string['flashlinkmessage'] = 'Aggiorna Flash player adesso:';
$string['flashupgrademessage'] = 'Per visualizzare il contenuto è necessario il plugin Flash player, tuttavia la tua versione è troppo antiquata. Dovresti scollegarti, aggiornare il plugin e ricollegarti.';
$string['folder'] = 'Cartella';
$string['folderclosed'] = 'Cartella chiusa';
$string['folderopened'] = 'Cartella aperta';
$string['followingoptional'] = 'I seguenti elementi sono opzionali';
$string['followingrequired'] = 'I seguenti elementi sono obbligatori';
$string['force'] = 'Forza';
$string['forcedmode'] = 'Modo forzato';
$string['forcelanguage'] = 'Forza lingua';
$string['forceno'] = 'Non forzare';
$string['forcepasswordchange'] = 'Forza il cambiamento della password';
$string['forcepasswordchangecheckfull'] = 'Sei sicuro di voler obbligare {$a} a cambiare la password ?';
$string['forcepasswordchange_help'] = '<p>Richiede che l\'utente cambi la propria password al suo primo login.</p>';
$string['forcepasswordchangenot'] = 'Non è stato possibile obbligare il cambio di password per {$a}';
$string['forcepasswordchangenotice'] = 'È necessario cambiare la password per proseguire.';
$string['forcetheme'] = 'Tema obbligato';
$string['forgotaccount'] = 'Hai dimenticato la password?';
$string['forgotten'] = 'Hai dimenticato lo username o la password?';
$string['forgottenduplicate'] = 'L\'indirizzo email è usato da più account, per favore inserisci lo username';
$string['forgotteninvalidurl'] = 'URL per il reset della password non valido';
$string['format'] = 'Formato';
$string['format_help'] = '<h2>LAMS</h2>
<p class="indent">
Con il formato LAMS, Learning Activity Management System, il copro centrale della pagina principale del corso visualizzerà le attività provenienti da LAMS. Per usare il formato LAMS è indispensabile che un amministratore abbia già interfacciato Moodle con un server LAMS.</p>

<h2>SCORM</h2>
<p class="indent">
Questo formato visualizza il manifest del pacchetto SCORM nella prima sezione della pagina principale del corso. (Il modulo di attività SCORM/AICC offre un metodo alternativo per usare uno o più pacchetti SCORM in un corso).</p>

<h2>Relazionale</h2>
<p class="indent">
Questo formato è incentrato sul Forum relazionale, che apparirà nell copro centrale della
pagina principale del corso. Questo formato, ideale per situazioni di tipo informale, può essere utilizzato efficacemente anche per attività non formative o per creare bacheche dipartimentali.</p>

<h2>Per argomenti</h2>
<p class="indent">
Il corpo centrale della pagina principale del corso è organizzato in sezioni, ognuna delle quali rappresenta un argomento del corso. Ogni sezione potrà contenere risorse e attività.</p>

<h2>Settimanale</h2>
<p class="indent">
Il corpo centrale della pagina principale del corso è organizzato in sezioni, ognuna delle quali rappresenta una settimana di corso con una data di inizio ed una data di fine.  Ogni settimana potrà contenere risorse e attività.</p>

<h2>Settimanale - CSS/Senza tabelle</h2>
<p class="indent">
Ha le stesse caratteristiche dl formato settimanale ma non fa uso di tabelle per il layout della pagina principale del corso.</p>';
$string['formathtml'] = 'Formato HTML';
$string['formatmarkdown'] = 'Formato Markdown';
$string['formatplain'] = 'Formato testo';
$string['formattext'] = 'Formattazione automatica Moodle';
$string['formattexttype'] = 'Formattazione';
$string['framesetinfo'] = 'Questo frame contiene:';
$string['from'] = 'Da';
$string['frontpagecategorycombo'] = 'Elenco combinato';
$string['frontpagecategorynames'] = 'Elenco delle categorie';
$string['frontpagecourselist'] = 'Elenco dei corsi';
$string['frontpagedescription'] = 'Descrizione Pagina home';
$string['frontpagedescriptionhelp'] = 'La descrizione del sito può essere visualizzata nella pagina home tramite il blocco "Descrizione del corso/sito"';
$string['frontpageformat'] = 'Formato pagina home';
$string['frontpageformatloggedin'] = 'Formato pagina home dopo il login';
$string['frontpagenews'] = 'Mostra le news';
$string['frontpagesettings'] = 'Impostazioni Pagina home';
$string['frontpagetopiconly'] = 'Mostra una sezione con contenuto HTML libero';
$string['fulllistofcourses'] = 'Tutti i corsi';
$string['fullname'] = 'Nome';
$string['fullnamecourse'] = 'Titolo del corso';
$string['fullnamecourse_help'] = 'Il titolo del corso viene visualizzato nella sommità delle pagine del corso e nell\'elenco dei corsi.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nome completo dell\'utente';
$string['fullprofile'] = 'Descrizione completa';
$string['fullsitename'] = 'Nome del sito';
$string['functiondisabled'] = 'Funzionalità al momento non abilitata';
$string['gd1'] = 'GD 1.x è installato';
$string['gd2'] = 'GD 2.x è installato';
$string['gdneed'] = 'GD deve essere installato per vedere questo grafico';
$string['gdnot'] = 'GD non è installato';
$string['general'] = 'Generale';
$string['geolocation'] = 'latitudine - longitudine';
$string['gettheselogs'] = 'Ottieni i log';
$string['go'] = 'Vai';
$string['gpl'] = 'Copyright (C) dal 1999 in poi  Martin Dougiamas
(http://moodle.com)

Questo programma è software libero; puoi ridistribuirlo e/o modificarlo secondo le condizioni previste dalla licenza GNU General Public License  pubblicata dalla \'Free Software Foundation\'; versione 2 della Licenza oppure, (a tua scelta) qualsiasi versione successiva.

Questo programma è distribuito con la speranza che possa essere utile, ma SENZA ALCUNA GARANZIA; ivi inclusa la garanzia implicita di COMMERCIABILITÀ o di IDONEITÀ PER UN USO SPECIFICO.

Per maggiori dettagli leggere la pagina informativa sulla Licenza Moodle:
http://docs.moodle.org/en/License';
$string['gpl3'] = 'Copyright (C) dal 1999 in poi  Martin Dougiamas
(http://moodle.com)

Questo programma è software libero; puoi ridistribuirlo e/o modificarlo secondo le condizioni previste dalla licenza GNU General Public License  pubblicata dalla \'Free Software Foundation\'; versione 3 della Licenza oppure, (a tua scelta) qualsiasi versione successiva.

Questo programma è distribuito con la speranza che possa essere utile, ma SENZA ALCUNA GARANZIA; ivi inclusa la garanzia implicita di COMMERCIABILITÀ o di IDONEITÀ PER UN USO SPECIFICO.

Per maggiori dettagli leggere la pagina informativa sulla Licenza Moodle:
http://docs.moodle.org/en/License';
$string['gpllicense'] = 'Licenza GPL';
$string['grade'] = 'Valutazione';
$string['grades'] = 'Valutazioni';
$string['group'] = 'Gruppo';
$string['groupadd'] = 'Aggiunta nuovo gruppo';
$string['groupaddusers'] = 'Aggiunta al gruppo selezionato';
$string['groupextendenrol'] = 'Prolunga iscrizione (comune)';
$string['groupfor'] = 'per gruppo';
$string['groupinfo'] = 'Informazioni sul gruppo selezionato';
$string['groupinfoedit'] = 'Modifica le impostazioni del gruppo';
$string['groupinfomembers'] = 'Informazioni sui membri selezionati';
$string['groupinfopeople'] = 'Informazioni sulla gente selezionata';
$string['groupmembers'] = 'Membri del gruppo';
$string['groupmemberssee'] = 'Mostra membri del gruppo';
$string['groupmembersselected'] = 'Membri del gruppo selezionato';
$string['groupmode'] = 'Modalità gruppo';
$string['groupmodeforce'] = 'Forza modalità gruppo';
$string['groupmy'] = 'Mio gruppo';
$string['groupnonmembers'] = 'Persone non in un gruppo';
$string['groupnotamember'] = 'Spiacente, non sei membro di quel gruppo';
$string['grouprandomassign'] = 'Assegna casualmente tutti ai gruppi';
$string['groupremove'] = 'Rimuovi gruppo selezionato';
$string['groupremovemembers'] = 'Rimuovi membri selezionati';
$string['groups'] = 'Gruppi';
$string['groupsnone'] = 'Senza gruppi';
$string['groupsseparate'] = 'Gruppi separati';
$string['groupsvisible'] = 'Gruppi visibili';
$string['guest'] = 'Ospite';
$string['guestdescription'] = 'Gli ospiti hanno privilegi minimi e normalmente non possono inserire testi.';
$string['guestskey'] = 'Consenti l\'accesso agli ospiti tramite la chiave di iscrizione';
$string['guestsno'] = 'Non permettere agli ospiti l\'accesso';
$string['guestsnotallowed'] = 'Spiacenti, \'{$a}\' non consente l\'accesso agli ospiti.';
$string['guestsyes'] = 'Consenti l\'accesso agli ospiti senza chiave di iscrizione';
$string['guestuser'] = 'Utente ospite';
$string['guestuserinfo'] = 'Questo utente è un utente speciale che ha accesso ai documenti del corso in modalità solo lettura in alcuni corsi.';
$string['healthcenter'] = 'Centro salute';
$string['healthnoproblemsfound'] = 'Non c\'è nessun problema di salute!';
$string['healthproblemsdetected'] = 'Sono stati rilevati problemi di salute!';
$string['healthproblemsolution'] = 'Soluzione problema di salute';
$string['healthreturntomain'] = 'Continua';
$string['healthsolution'] = 'Soluzione';
$string['help'] = 'Aiuto';
$string['helpprefix2'] = 'Aiuto su {$a}';
$string['helpwiththis'] = 'Aiuto per questo';
$string['hiddenassign'] = 'Attribuzione nascosta';
$string['hiddenfromstudents'] = 'Nascosta agli studenti';
$string['hiddensections'] = 'Sezioni nascoste';
$string['hiddensectionscollapsed'] = 'Le sezioni nascoste mostrano solo l\'intestazione';
$string['hiddensections_help'] = 'L\'impostazione determina come visualizzare le sezioni nascoste agli studenti. La sezione può essere visualizzata in formato compatto (ad esempio una settimana di vacanze quando il formato del corso è settimanale) oppure può essere nascosta del tutto.';
$string['hiddensectionsinvisible'] = 'Le sezioni nascoste non sono visibili';
$string['hide'] = 'Nascondi';
$string['hideadvancedsettings'] = 'Nascondi le impostazioni avanzate';
$string['hidepicture'] = 'Nascondi immagine';
$string['hidesection'] = 'Nascondi sezione {$a}';
$string['hidesettings'] = 'Nascondi impostazioni';
$string['hideshowblocks'] = 'Mostra/nascondi blocchi';
$string['hidetopicfromothers'] = 'Nascondi argomento';
$string['hideweekfromothers'] = 'Nascondi settimana';
$string['hits'] = 'Accessi';
$string['hitsoncourse'] = 'Accessi al corso {$a->coursename} dell\'utente {$a->username}';
$string['hitsoncoursetoday'] = 'Accessi di oggi al corso {$a->coursename} dell\'utente {$a->username}';
$string['home'] = 'Home';
$string['hour'] = 'ora';
$string['hours'] = 'ore';
$string['howtomakethemes'] = 'Come realizzare un nuovo tema';
$string['htmleditor'] = 'Usa editor HTML (solo alcuni browser)';
$string['htmleditoravailable'] = 'L\'editor HTML è disponibile';
$string['htmleditordisabled'] = 'Hai disabilitato l\'editor HTML nel tuo profilo utente.';
$string['htmleditordisabledadmin'] = 'L\'amministratore ha disabilitato l\'editor HTML in questo sito';
$string['htmleditordisabledbrowser'] = 'L\'editor HTML non è disponibile in quanto stai utilizzando un browser non compatibile.';
$string['htmlfilesonly'] = 'Solo file HTML';
$string['htmlformat'] = 'Formato HTML';
$string['icon'] = 'Icona';
$string['icqnumber'] = 'Numero ICQ';
$string['idnumber'] = 'Numero ID';
$string['idnumbercourse'] = 'Numero ID del corso';
$string['idnumbercourse_help'] = '<p>Il Numero ID del corso viene utilizzato quando si interfaccia Moodle a sistemi esterni e non è mai visualizzato all\'interno di Moodle. Se conoscete il Numero ID del corso, potete inserirlo in questo campo, altrimenti potete lasciarlo vuoto.</p>';
$string['idnumbermod'] = 'Numero ID';
$string['idnumbermod_help'] = 'L\'impostazione del numero ID permette di identificare l\'attività ai fini del calcolo della valutazione. Se l\'attività non è inclusa in nessun calcolo, il campo può essere lasciato vuoto.

Il numero ID può essere impostato anche nel Registro delle valutazioni, ma sarà comunque modificabile solo nelle impostazioni dell\'attività';
$string['idnumbertaken'] = 'Questo numero ID è già usato';
$string['imagealt'] = 'Descrizione dell\' immagine';
$string['import'] = 'Importa';
$string['importdata'] = 'Importa i dati del corso';
$string['importdataexported'] = 'I dati del corso \'from\' sono stati esportati correttamente..<br /> Prosegui con l\'importazione nel tuo corso \'to\'';
$string['importdatafinished'] = 'Importazione completa! Accedi al corso';
$string['importdatafrom'] = 'Trova un corso e importa i dati:';
$string['inactive'] = 'Non attivo';
$string['include'] = 'Includi';
$string['includeallusers'] = 'Includi tutti gli utenti';
$string['includecoursefiles'] = 'Includi i file del corso';
$string['includecourseusers'] = 'Includi gli utenti del corso';
$string['included'] = 'Incluso';
$string['includelogentries'] = 'Includi i log';
$string['includemodules'] = 'Includi i moduli';
$string['includemoduleuserdata'] = 'Includi i dati utente presenti nel modulo';
$string['includeneededusers'] = 'Includi gli utenti necessari';
$string['includenoneusers'] = 'Escludi gli utenti';
$string['includeroleassignments'] = 'Includi le attribuzioni di ruolo';
$string['includesitefiles'] = 'Includi i file del sito usati in questo corso';
$string['includeuserfiles'] = 'Includi i file degli utenti';
$string['info'] = 'Informazioni';
$string['institution'] = 'Istituzione';
$string['instudentview'] = 'nella vista studente';
$string['interests'] = 'Interessi';
$string['interestslist'] = 'Elenco interessi';
$string['interestslist_help'] = '<p>Inserisci i tuoi interessi separati da una virgola.</p>';
$string['invalidemail'] = 'Indirizzo email non valido';
$string['invalidlogin'] = 'Login errato, riprova';
$string['invalidusername'] = 'Lo username può contenere solamente caratteri alfanumerici minuscoli, trattino basso (_), segno meno (-), punto (.) ed il simbolo \'at\' (@)';
$string['invalidusernameupload'] = 'Username non valido';
$string['ip_address'] = 'Indirizzo IP';
$string['jump'] = 'Vai';
$string['jumpto'] = 'Vai a...';
$string['keep'] = 'Mantieni';
$string['keepsearching'] = 'Continua a cercare';
$string['langltr'] = 'Direzione scrittura da sinistra a destra';
$string['langrtl'] = 'Direzione scrittura da destra a sinistra';
$string['language'] = 'Lingua';
$string['languagegood'] = 'Questo language pack è aggiornato! :-)';
$string['lastaccess'] = 'Accesso più recente';
$string['lastedited'] = 'Ultima modifica';
$string['lastlogin'] = 'Login più recente';
$string['lastmodified'] = 'Ultime modifiche';
$string['lastname'] = 'Cognome';
$string['lastyear'] = 'Anno scorso';
$string['latestlanguagepack'] = 'Verifica la presenza di un language pack aggiornato su moodle.org';
$string['layouttable'] = 'Tabella layout';
$string['leavetokeep'] = 'Lascia in bianco per conservare la tua attuale password';
$string['legacythemeinuse'] = 'Il sito viene visualizzato in compatibility mode poiché il tuo browser è obsoleto.';
$string['legacythemesaved'] = 'Il nuovo tema legacy è stato slavato';
$string['license'] = 'Licenza';
$string['licenses'] = 'Licenze';
$string['liketologin'] = 'Desideri collegarti con un account completo?';
$string['list'] = 'Elenco';
$string['listfiles'] = 'Elenco dei file in {$a}';
$string['listofallpeople'] = 'Elenco di tutte le persone';
$string['livelogs'] = 'Live log dell\'ultima ora';
$string['local'] = 'Locale';
$string['localplugindeleteconfirm'] = 'Stai per eliminare il pugin \'{$a}\'. Tutti i dati nel database andranno perduti. Intendi procedere?';
$string['localplugins'] = 'Plugin locali';
$string['localpluginsmanage'] = 'Gestione plugin locali';
$string['location'] = 'File o sito web';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Sei collegato come {$a}.';
$string['loggedinasguest'] = 'Stai utilizzando un accesso da ospite';
$string['loggedinnot'] = 'Non sei collegato.';
$string['login'] = 'Login';
$string['loginalready'] = 'Sei già collegato';
$string['loginas'] = 'Login come';
$string['loginaspasswordexplain'] = '<p>È necessario impostare la speciale "password login come" per utilizzare questa caratteristica.<br />Se non la conoscete, chiedete all\'amministratore del server.</p>';
$string['login_failure_logs'] = 'Log accessi falliti';
$string['loginguest'] = 'Login come ospite';
$string['loginsite'] = 'Login al sito';
$string['loginsteps'] = 'Per accedere al sito, puoi creare facilmente il tuo account in pochi minuti.
L\'accesso ai corsi può essere regolato da chiavi di accesso, necessarie solo all\'atto dell\'iscrizione.
Per creare l\'account:
<ol>
<li>Compila il form <a href="{$a}">Nuovo account</a> con i tuoi dati.</li>
<li>Ti verrà spedita una email all\'indirizzo da te fornito.</li>
<li>Leggi l\'email e clicca sul link presente nel corpo del messaggio.</li>
<li>Dopo aver confermato il tuo account, sarai autenticato dal sistema.</li>
<li>Una volta autenticato, potrai scegliere a quale corso iscriverti.</li>
<li>Se ti verrà richiesta una chiave di iscrizione, usa la chiave fornita dal docente del corso.</li>
<li>Una volta iscritto al corso potrai frequentarlo autenticandoti con il tuo account. </li>
</ol>';
$string['loginstepsnone'] = '<p>Per accedere ai corsi è necessario creare un account.</p>
<p>Per farlo, scegli username e password ed autenticati usando questa pagina</p>
<p>Se lo username scelto è già utilizzato, dovrai scegliere uno username diverso.</p>';
$string['loginto'] = 'Accesso a {$a}';
$string['loginusing'] = 'Accedi qui utilizzando il tuo username e la password';
$string['logout'] = 'Esci';
$string['logoutconfirm'] = 'Vuoi uscire veramente?';
$string['logs'] = 'Log';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">continua</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">continua</a> ]';
$string['lookback'] = 'Guarda dietro';
$string['mailadmins'] = 'Informa gli amministratori';
$string['mailstudents'] = 'Informa gli studenti';
$string['mailteachers'] = 'Informa i docenti';
$string['makeafolder'] = 'Crea una cartella';
$string['makeeditable'] = 'Se si rende \'{$a}\' modificabile dal processo del server web (es. apache) si potrà modificare questo file direttamente da questa pagina.';
$string['makethismyhome'] = 'Rendi questa pagina la mia home page di default';
$string['manageblocks'] = 'Blocchi';
$string['managecourses'] = 'Gestisci i corsi';
$string['managedatabase'] = 'Gestione database';
$string['manageeditorfiles'] = 'Gestione file usati dall\'editor';
$string['managefilters'] = 'Filtri';
$string['managemodules'] = 'Moduli';
$string['manageroles'] = 'Ruoli e privilegi';
$string['markedthistopic'] = 'Questo argomento è evidenziato come argomento attuale';
$string['markthistopic'] = 'Contrassegna questo argomento come argomento corrente';
$string['matchingsearchandrole'] = 'Corrispondenze per \'{$a->search}\' e {$a->role}';
$string['maxfilesize'] = 'Dimensione massima dei nuovi file: {$a}';
$string['maximumchars'] = 'Massimo di {$a} caratteri';
$string['maximumgrade'] = 'Voto massimo';
$string['maximumgradex'] = 'Voto massimo: {$a}';
$string['maximumshort'] = 'Massimo';
$string['maximumupload'] = 'Dimensione massima file caricabili';
$string['maximumupload_help'] = '<p>Questa impostazione determina la dimensione massima dei file che gli studenti e i docenti possono caricare. L\'impostazione influenza solo i file caricabili nell\'ambito del corso ed è a sua volta limitata nel suo valore massimo dalla analoga impostazione effettuata a livello di sito dagli Amministratori del sistema.</p>

<p>E\' inoltre possibile limitare ulteriormente la dimensione massima dei file caricabili per ciascuna attività del corso.</p>';
$string['maxnumcoursesincombo'] = 'Visualizza <a href="{$a->link}">{$a->numberofcourses} corsi</a>.';
$string['maxsize'] = 'Dimensione massima: {$a}';
$string['memberincourse'] = 'Persone nel corso';
$string['messagebody'] = 'Corpo del messaggio';
$string['messagedselectedusers'] = 'È stato inviato il messaggio agli utenti selezionati e l\'elenco dei destinatari è stata svuotata.';
$string['messagedselectedusersfailed'] = 'Qualcosa non è andato a buon fine mentre veniva mandato il messaggio agli utenti selezionati. Alcuni utenti potrebbero aver ricevuto la mail.';
$string['messageprovider:backup'] = 'Notifiche backup';
$string['messageprovider:courserequestapproved'] = 'Notifica di approvazione corso a richiesta';
$string['messageprovider:courserequested'] = 'Notifica di richiesta corso';
$string['messageprovider:courserequestrejected'] = 'Notifica di mancata approvazione corso a richiesta';
$string['messageprovider:errors'] = 'Errori gravi del sito';
$string['messageprovider:errors_help'] = 'Sono errori rilevanti dei quali l\'amministratore dovrebbe essere informato.';
$string['messageprovider:instantmessage'] = 'Messaggi personali tra utenti';
$string['messageprovider:instantmessage_help'] = 'Questa sezione permette di configurare cosa succede ai messaggi che ricevi dagli altri utenti del sito.';
$string['messageprovider:notices'] = 'Note su problemi minori';
$string['messageprovider:notices_help'] = 'Si tratta di note che dovrebbero essere rese note l\'amministratore.';
$string['messageselect'] = 'Seleziona questo utente come destinatario del messaggio';
$string['messageselectadd'] = 'Invia un messaggio';
$string['migratinggrades'] = 'Migrazione valutazioni';
$string['min'] = 'min.';
$string['mins'] = 'min.';
$string['minutes'] = 'minuti';
$string['miscellaneous'] = 'Generale';
$string['missingcategory'] = 'Devi scegliere una categoria';
$string['missingcity'] = 'Non hai inserito città/località';
$string['missingcountry'] = 'Non hai scelto lo stato';
$string['missingdescription'] = 'Non hai inserito la descrizione';
$string['missingemail'] = 'Non hai inserito l\'email';
$string['missingfirstname'] = 'Non hai inserito il nome';
$string['missingfromdisk'] = 'Manca sul disco';
$string['missingfullname'] = 'Non hai inserito il Nome';
$string['missinglastname'] = 'Non hai inserito il cognome';
$string['missingname'] = 'Non hai inserito il nome';
$string['missingnewpassword'] = 'Nuova password mancante';
$string['missingpassword'] = 'Non hai inserito la password';
$string['missingrecaptchachallengefield'] = 'Non hai riempito il campo reCAPTCHA';
$string['missingreqreason'] = 'Non hai inserito la motivazione';
$string['missingshortname'] = 'Non hai inserito il nome abbreviato';
$string['missingshortsitename'] = 'Nome breve del sito mancante';
$string['missingsitedescription'] = 'Non hai inserito la descrizione del sito';
$string['missingsitename'] = 'Non hai inserito il nome del sito';
$string['missingstrings'] = 'Controlla le stringhe mancanti';
$string['missingstudent'] = 'Devi scegliere qualcosa';
$string['missingsummary'] = 'Non hai inserito l\'Introduzione';
$string['missingteacher'] = 'Devi scegliere qualcosa';
$string['missingurl'] = 'Non hai inserito la URL';
$string['missingusername'] = 'Non hai inserito un username';
$string['modified'] = 'Modificato';
$string['moduledeleteconfirm'] = 'Stai per eliminare il modulo \'{$a}\'. Questo eliminerà tutto ciò che nel database è associato al modulo. Sei SICURO di continuare?';
$string['moduledeletefiles'] = 'Tutti i dati associati al modulo \'{$a->module}\' sono stati eliminati dal database. Per completare l\'eliminazione ed evitare che il modulo si re-installi automaticamente, devi eliminare anche la cartella {$a->directory} dal tuo server.';
$string['moduleintro'] = 'Descrizione';
$string['modulesetup'] = 'Impostazione tabelle modulo';
$string['modulesuccess'] = 'Tabelle {$a} impostate correttamente';
$string['moodledocs'] = 'Moodle Doc';
$string['moodledocslink'] = 'Documentazione di Moodle per questa pagina';
$string['moodlerelease'] = 'Release di Moodle';
$string['moodleversion'] = 'Versione Moodle';
$string['more'] = 'ancora';
$string['morehelp'] = 'Aiuto ulteriore';
$string['moreinformation'] = 'Maggiori informazioni su questo errore';
$string['moreprofileinfoneeded'] = 'Per cortesia, dicci di più su te stesso';
$string['mostrecently'] = 'più recentemente';
$string['move'] = 'Sposta';
$string['movecategorycontentto'] = 'Sposta in';
$string['movecategoryto'] = 'Sposta categoria in:';
$string['movecontentstoanothercategory'] = 'Sposta i corsi in un altra categoria';
$string['movecourseto'] = 'Sposta corso in:';
$string['movedown'] = 'Sposta in basso';
$string['movefilestohere'] = 'Sposta i files qui';
$string['movefull'] = 'Sposta {$a} in questo posto';
$string['movehere'] = 'Sposta qui';
$string['moveleft'] = 'Sposta a sinistra';
$string['moveright'] = 'Sposta a destra';
$string['movesection'] = 'Sposta sezione {$a}';
$string['moveselectedcoursesto'] = 'Sposta i corsi selezionati in...';
$string['movetoanotherfolder'] = 'Sposta in un\'altra cartella';
$string['moveup'] = 'Sposta in alto';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'La nuova password deve essere diversa da quella che hai scelto';
$string['mustconfirm'] = 'È necessario confermare il tuo accesso';
$string['mycourses'] = 'I miei corsi';
$string['myfiles'] = 'File personali';
$string['myfilesmanage'] = 'Gestisci file personali';
$string['myhome'] = 'My home';
$string['mymoodledashboard'] = 'Dashboard My Moodle';
$string['myprofile'] = 'Il mio profilo';
$string['name'] = 'Nome';
$string['navigation'] = 'Navigazione';
$string['needed'] = 'Necessario';
$string['never'] = 'Mai';
$string['neverdeletelogs'] = 'Non eliminare mai i log';
$string['new'] = 'Nuovo';
$string['newaccount'] = 'Nuovo account';
$string['newcourse'] = 'Nuovo corso';
$string['newpassword'] = 'Nuova password';
$string['newpasswordfromlost'] = '<strong>NOTA:</strong> La tua  <strong>Password </strong> ti verrà spedita nella <strong>seconda</strong> delle due mail spedite dalla procedura di recupero password. Accertati di aver ricevuto la nuova passowrd prima di proseguire.';
$string['newpassword_help'] = '<p>Lasciare vuoto per mantenere la password attuale.</p>';
$string['newpasswordtext'] = 'Salve {$a->firstname},

la password del tuo account a \'{$a->sitename}\' è stata resettata ed hai avuto una nuova password temporanea
L\'informazione attuale per il tuo login è ora:
username: {$a->username}
password: {$a->newpassword}

Per favore vai alla seguente pagina per cambiare la tua password:
{$a->link}

Nella maggior parte dei programmi di posta elettronica, questo deve apparire con un link in blu sul quale puoi semplicemente cliccare.
Se questo non funziona, taglia e incolla questo indirizzo nella linea degli indirizzo in alto nel tuo browser web.

Saluti dall\'amministratore del sito \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Nuova immagine';
$string['newpicture_help'] = '<P>Si può caricare una foto dal proprio computer a questo server:
questa immagine verrà utilizzata in vari punti del sistema per rappresentarti.</p>
<P>A tale scopo, il "taglio" migliore è costituito da fotografie in primo piano dove si veda bene il viso, ma si può usare qualunque immagine che si desideri.</p>
<P>Il file dell\'immagine deve essere in formato JPG o PNG (controllare l\'estensione dopo il punto, per esempio: miafoto.jpg o miafoto.png)</p>
<P>Si può ottenere un file immagine utilizzando uno dei seguenti metodi:</p>
<OL>
<LI>Utilizzando una fotocamera digitale, le immagini saranno già pronte per essere trasferite nel giusto formato (non serve usare una risoluzione esagerata!)
<LI>Si può utilizzare uno scanner per duplicare una stampa su carta. Assicurarsi di salvare in formato JPG o PNG (non GIF)
<LI>Si può disegnare un\'immagine utilizzando un programma di computer grafica.
<LI>Infine, si può "rubare" un\'immagine sul Web. <A TARGET=google HREF="http://images.google.com/">http://images.google.com</A> è un ottimo motore di ricerca per cercare immagini.
Una volta trovata una che piace, si clicca sopra col tasto destro del mouse e si salva sul proprio computer con la funzione "Salva Immagine con nome".
</OL>
<P>Per caricare una immagine, cliccare "Sfoglia" su questa pagina di editing e selezionare una immagine dall\'hard disk del proprio computer.</p>
<P>NOTA: Assicurarsi che il file non superi le dimensioni indicate, altrimenti non verrà caricato.</p>
<P>Poi cliccare su "Aggiornamento profilo" in basso - l\'immagine verrà tagliata in formato quadrato e portata ad una dimensione di 100x100 pixels.</p>
<P>Quando si torna sulla pagina del proprio profilo, potrebbe non visualizzarsi il cambiamento: in questo caso cliccare sul pulsante di aggiornamento del browser.</p>';
$string['newsitem'] = 'news';
$string['newsitems'] = 'news';
$string['newsitemsnumber'] = 'Numero di news da mostrare';
$string['newsitemsnumber_help'] = '<p>Nei corsi che usano il "formato settimanale" ed il "formato per argomenti", è presente un Forum di default chiamato "Forum News". Questo forum è utile per comunicare agli studenti informazioni e novità riguardanti il corso. (Per impostazione predefinita tutti gli studenti sono automaticamente iscritti a questo Forum e riceveranno nella propria casella di email qualsiasi intervento inserito nel Forum stesso).</p>

<p>Il Numero di news da mostrare determina il numero di ultime notizie da presentare nella pagina principale del corso, nel blocco appunto chiamato "Ultime notizie".</p>

<p>Se "News da mostrare" è impostato a "0", nella pagina principale del corso il blocco "Ultime notizie" non sarà visibile.</p>';
$string['newuser'] = 'Nuovo utente';
$string['newusernewpasswordsubj'] = 'Registrazione nuovo utente';
$string['newusernewpasswordtext'] = 'Gentile {$a->firstname},

su \'{$a->sitename}\' è stato creato per te un nuovo account con una password temporanea.

Informazioni sul tuo account:
username: {$a->username}
password: {$a->newpassword}
(la password dovrà essere modificata al primo accesso)

Per iniziare ad utilizzare \'{$a->sitename}\', autenticati con il tuo account su {$a->link}

Nella maggior parte dei programmi di posta elettronica il link appare in blu e puoi cliccarci direttamente.

Se il link non dovesse essere attivo, copia e incolla l\'indirizzo nella barra dell\'indirizzo del tuo broser web

Saluti dall\'amministratore del sito \'{$a->sitename}\',
{$a->signoff}';
$string['newusers'] = 'Nuovi utenti';
$string['newwindow'] = 'nuova finestra';
$string['next'] = 'Successivo';
$string['nextsection'] = 'Sezione successiva';
$string['no'] = 'No';
$string['noblockstoaddhere'] = 'Non ci sono blocchi da aggiungere alla pagina';
$string['nobody'] = 'Nessuno';
$string['nochange'] = 'Nessun cambiamento';
$string['nocomments'] = 'Non ci sono commenti';
$string['nocourses'] = 'Nessun corso';
$string['nocoursesfound'] = 'Non è stato trovato nessun corso contente \'{$a}\'';
$string['nocoursesyet'] = 'Questa categoria non ha corsi';
$string['nodstpresets'] = 'L\'amministratore non ha attivato il supporto per l\'ora legale.';
$string['nofilesselected'] = 'Non sono stati selezionati file da recuperare';
$string['nofilesyet'] = 'Nessun file è stato ancora trasferito sul server';
$string['nograde'] = 'Senza valutazione';
$string['noimagesyet'] = 'Nessuna immagine è stata ancora trasferita sul server';
$string['nologsfound'] = 'Non ci sono log da visualizzare';
$string['nomatchingusers'] = 'Non è stato trovato nessun utente che corrisponda al criterio di ricerca \'{$a}\'';
$string['nomorecourses'] = 'Non possono essere trovati altri corsi corrispondenti';
$string['nomoreidnumber'] = 'Non vengono usati numeri di id per evitare conflitti';
$string['none'] = 'Nessuno';
$string['noneditingteacher'] = 'Docente non editor';
$string['noneditingteacherdescription'] = 'I docenti non editor possono insegnare nei corsi e valutare gli studenti, ma non possono modificare le attività.';
$string['nonstandard'] = 'Non standard';
$string['nopendingcourses'] = 'Non ci sono corsi in attesa di approvazione';
$string['nopotentialadmins'] = 'Non ci sono possibili amministratori';
$string['nopotentialcreators'] = 'Non ci sono possibili creatori di corsi';
$string['nopotentialstudents'] = 'Non ci sono possibili studenti';
$string['nopotentialteachers'] = 'Non ci sono potenziali docenti';
$string['norecentactivity'] = 'Nessuna attività recente';
$string['noreplybouncemessage'] = 'Hai risposto ad un indirizzo no-reply. Se stavi rispondendo ad un messaggio di un forum, dovresti usare il forum  {$a}.

Questo è il messaggio che hai inviato:';
$string['noreplybouncesubject'] = '{$a} - email ritornata';
$string['noreplyname'] = 'Non rispondere a questa email';
$string['noresults'] = 'Nessun risultato';
$string['normal'] = 'Normale';
$string['normalfilter'] = 'Filtro normale';
$string['nosite'] = 'Non si trova corso a livello di sito';
$string['nostudentsfound'] = 'Nessun {$a} trovato';
$string['nostudentsingroup'] = 'In questo gruppo non ci sono ancora studenti';
$string['nostudentsyet'] = 'Non ci sono ancora studenti iscritti in questo corso';
$string['nosuchemail'] = 'Nessun indirizzo email';
$string['notavailable'] = 'Non disponibile';
$string['noteachersyet'] = 'Non ci sono ancora docenti in questo corso';
$string['notenrolled'] = '{$a} non è iscritto a questo corso.';
$string['notenrolledprofile'] = 'Questo profilo non è disponibile perché questo utente non è iscritto a questo corso.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Nota:</strong> La possibilità di posticipare date di attività durante il ripristino è stato disabilitato poiché non possiedi questo privilegio.';
$string['noteuserschangednonetocourse'] = '<strong>Nota:</strong> devono essere recuperati anche i partecipanti del corso quando vengono recuperati i dati degli utenti. L\'impostazione è stata cambiata per te.';
$string['nothingnew'] = 'Nessuna novità dal tuo login più recente';
$string['nothingtodisplay'] = 'Non ci sono elementi da visualizzare';
$string['notice'] = 'Nota';
$string['noticenewerbackup'] = 'Questo backup è stato creato con Moodle {$a->backuprelease} ({$a->backupversion}) che è più recente della versione di Moodle attualmente installata {$a->serverrelease} ({$a->serverversion}). Questo può provocare alcune inconsistenze perché la compatibilità con versioni precedenti dei backup non può essere garantita.';
$string['notifications'] = 'Notifiche';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Utente: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Puoi visualizzare questi log all\'indirizzo {$a}/course/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Ecco l\'elenco degli accessi falliti a {$a} dall\'ultima notifica.';
$string['notifyloginfailuressubject'] = '{$a} :: Notifica accessi falliti';
$string['notincluded'] = 'Non incluso';
$string['notingroup'] = 'Spiacente, ma devi appartenere ad un gruppo per visualizzare questa attività.';
$string['notpublic'] = 'Questi dati non saranno pubblicati';
$string['nousersfound'] = 'Non trovato alcun utente';
$string['nousersmatching'] = 'Nessun utente \'{$a}\' è stato trovato';
$string['nousersyet'] = 'Non ci sono ancora utenti registrati';
$string['novalidcourses'] = 'Nessun corso valido da mostrare';
$string['now'] = 'adesso';
$string['numattempts'] = '{$a} tentativi di accesso falliti';
$string['numberofcourses'] = 'Numero di corsi';
$string['numberweeks'] = 'Numero di argomenti/settimane';
$string['numdays'] = '{$a} giorni';
$string['numhours'] = '{$a} ore';
$string['numletters'] = '{$a} lettere';
$string['numminutes'] = '{$a} minuti';
$string['nummonths'] = '{$a} mesi';
$string['numseconds'] = '{$a} secondi';
$string['numviews'] = '{$a} letture';
$string['numweeks'] = '{$a} settimane';
$string['numwords'] = '{$a} parole';
$string['numyears'] = '{$a} anni';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Password attuale';
$string['olduserdirectory'] = 'Questa è la VECCHIA cartella utenti, e non è più necessaria. La puoi tranquillamente eliminare. Tutti i file che contiene sono stati copiati nella NUOVA cartella utenti.';
$string['opentoguests'] = 'Accesso come ospite';
$string['optional'] = 'opzionale';
$string['order'] = 'Ordine';
$string['orphanedactivities'] = 'Attività orfane';
$string['other'] = 'Altro';
$string['outline'] = 'Profilo';
$string['outlinereport'] = 'Report riassuntivo';
$string['page'] = 'Pagina';
$string['pageheaderconfigablock'] = 'Configurazione di un blocco in %fullname%';
$string['pagepath'] = 'Percorso della pagina';
$string['pageshouldredirect'] = 'La pagina dovrebbe reindirizzarvi automaticamente. Se il reindirizzamento non avviene, potete continuare usando il link sottostante.';
$string['parentcategory'] = 'Categoria di appartenenza';
$string['parentcoursenotfound'] = 'Corso padre non trovato!';
$string['parentfolder'] = 'Cartella superiore';
$string['participants'] = 'Partecipanti';
$string['participantslist'] = 'Elenco';
$string['participationratio'] = 'Tasso di partecipazione';
$string['participationreport'] = 'Report della Partecipazione';
$string['password'] = 'Password';
$string['passwordchanged'] = 'La password è stata modificata';
$string['passwordconfirmchange'] = 'Conferma il cambiamento di password';
$string['passwordextlink'] = 'Il link seguente è stato fornito per recuperare la password smarrita. Questo vi porterà fuori da Moodle.';
$string['passwordforgotten'] = 'Password dimenticata';
$string['passwordforgotteninstructions'] = 'I tuoi dati devono essere reperiti nel database di Moodle. Inserisci il tuo username <strong>oppure</strong> la tua email nelle caselle corrispondenti. Non è necessario inserirli entrambi.';
$string['passwordforgotteninstructions2'] = 'Per recuperare la tua password, inserisci lo username oppure la email nei campi sottostanti. Se Moodle troverà il dato nel database, invierà una email con le istruzioni per completare il recupero.';
$string['passwordnohelp'] = 'Non esiste un aiuto per recuperare la password. Sei pregato di contattare l\'amministratore di Moodle.';
$string['passwordrecovery'] = 'Si, per favore aiutatemi per il login';
$string['passwordsdiffer'] = 'Le password non corrispondono';
$string['passwordsent'] = 'La password è stata spedita';
$string['passwordsenttext'] = '<p>Una email è stata spedita a {$a->email}.</p>
<p><b> Per favore controlla la tua posta per la nuova password</b></p>
<p>La nuova password è stata generata automaticamente, perciò potresti voler <a href="{$a->link}">cambiarla in una più facile da ricordare</a>.</p>';
$string['path'] = 'Percorso';
$string['pathnotexists'] = 'Il percorso non esiste sul tuo server!';
$string['pathslasherror'] = 'Il percorso non può terminare con uno slash!!';
$string['paymentinstant'] = 'Utilizza il bottone sottostante per pagare ed essere iscritto in pochi minuti!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pendenti</small>)';
$string['paymentrequired'] = 'L\'accesso al corso richiede un pagamento.';
$string['payments'] = 'Pagamenti';
$string['paymentsorry'] = 'Grazie per il pagamento! Sfortunatamente il pagamento non è stato completamente elaborato, e l\'iscrizione al corso "{$a->fullname}" non è stata completata. Per favore prova a cliccare su continua tra alcuni secondi, ma se incontri problemi allora avverti il {$a->teacher} o l\'amministratore del sito.';
$string['paymentthanks'] = 'Grazie per il pagamento! Ora sei iscritto nel tuo corso:<br />"{$a}"';
$string['pendingrequests'] = 'Corsi da approvare';
$string['periodending'] = 'Termine periodo ({$a})';
$string['personal'] = 'Personale';
$string['personalprofile'] = 'Profilo personale';
$string['phone'] = 'Telefono';
$string['phone2'] = 'Cellulare';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = 'Immagine {$a}';
$string['pictureofuser'] = 'Immagine dell\'utente';
$string['pleaseclose'] = 'Si prega di chiudere questa finestra adesso.';
$string['pleasesearchmore'] = 'Per favore cercate ancora';
$string['pleaseusesearch'] = 'Per favore usate la ricerca';
$string['plugin'] = 'Plugin';
$string['plugincheck'] = 'Controllo dei plugin';
$string['pluginchecknotice'] = 'Le tabelle che seguono mostrano i moduli, i blocchi ed i filtri individuati nella tua installazione di Moodle.
Nelle tabelle sono indicati anche quali plugin sono standard e quali non lo sono. Prima di proseguire con l\'aggiornamento di Moodle, tutti i plugin che non sono standard dovrebbero essere controllati ed aggiornati alla più recente versione disponibile.';
$string['plugindeletefiles'] = 'Tutti i dati relativi al plugin \'{$a->name}\' sono stati eliminati dal database. Per evitare che il plugin si installi nuovamente da solo, devi rimuovere questa cartella dal tuo server: {$a->directory}';
$string['pluginsetup'] = 'Impostazione tabelle plugin';
$string['policyaccept'] = 'Ho letto le condizioni e le accetto';
$string['policyagree'] = 'Per continuare ad usare questo sito, è necessario accettare le condizioni riportate.';
$string['policyagreement'] = 'Condizioni di utilizzo del sito';
$string['policyagreementclick'] = 'Leggi le condizioni di utilizzo del sito';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Apri file in una nuova finestra';
$string['popupwindowname'] = 'Finestra popup';
$string['post'] = 'Scrittura';
$string['posts'] = 'Scritture';
$string['potentialadmins'] = 'Amministratori possibili';
$string['potentialcreators'] = 'Creatori di corsi possibili';
$string['potentialstudents'] = 'Studenti possibili';
$string['potentialteachers'] = 'Potenziali docenti';
$string['preferences'] = 'Preferenze';
$string['preferredlanguage'] = 'Lingua preferita';
$string['preferredtheme'] = 'Tema preferito';
$string['preprocessingbackupfile'] = 'Pre elaborazione del file di backup';
$string['preview'] = 'Anteprima';
$string['previewhtml'] = 'Anteprima in formato HTML';
$string['previeworchoose'] = 'Anteprima o scegli tema';
$string['previous'] = 'Precedente';
$string['previouslyselectedusers'] = 'Utenti selezionati in precedenza che non soddisfano il criterio di ricerca \'{$a}\'';
$string['previoussection'] = 'Sezione precedente';
$string['primaryadminsetup'] = 'Imposta account amministratore';
$string['profile'] = 'Profilo';
$string['profilenotshown'] = 'La descrizione presente nel profilo di questo utente non sarà visualizzata finché l\'utente stesso non risulti iscritto ad almeno un corso.';
$string['publicprofile'] = 'Profilo pubblico';
$string['publicsitefileswarning'] = 'Nota: i file salvati qui possono essere visualizzati da chiunque';
$string['publicsitefileswarning2'] = 'Nota: i file salvati qui possono essere visualizzati da chiunque a conoscenza della URL oppure in grado di ricavarla. Per motivi di sicurezza si consiglia di eliminare file di backup subito dopo il ripristino.';
$string['publicsitefileswarning3'] = 'Nota: i file caricati qui possono essere visualizzati da chiunque a conoscenza della URL oppure in grado di ricavarla. <br />Per motivi di sicurezza si raccomanda di caricare file di backup solamente nel folder sicuro \'backupdata\'.';
$string['publish'] = 'Pubblica';
$string['question'] = 'Domanda';
$string['questionsinthequestionbank'] = 'Domande nel deposito';
$string['readinginfofrombackup'] = 'Lettura informazioni dal Backup';
$string['readme'] = 'LEGGIMI';
$string['recentactivity'] = 'Attività recente';
$string['recentactivityreport'] = 'Report completo dell\'attività recente...';
$string['recipientslist'] = 'Elenco destinatari';
$string['recreatedcategory'] = 'La categoria {$a} è stata creata nuovamente';
$string['redirect'] = 'Reindirizza';
$string['refresh'] = 'Aggiorna';
$string['refreshingevents'] = 'Aggiorna eventi';
$string['registration'] = 'Registrazione di Moodle';
$string['registrationcontact'] = 'Possibilità di essere contattati';
$string['registrationcontactno'] = 'No, non desidero un contact form nell\'elenco pubblico dei siti';
$string['registrationcontactyes'] = 'Si, desidero un contact form affinché altri Moodler mi possano contattare';
$string['registrationemail'] = 'Notifiche via email';
$string['registrationinfo'] = '<p>In questa pagina puoi registrare il tuo sito Moodle su moodle.org. La registrazione è gratuita e la tua email sarà inserita in una mailing list a basso traffico dalla quale riceverai avvisi di sicurezza e messaggi sulle nuove release di Moodle.</p>
<p>I dati da te inviati rimarranno privati e non saranno venduti o trasferiti a terzi. I motivi per cui ti suggeriamo di registrarti sono la ricezione di avvisi sulla sicurezza e la raccolta di dati statistici utili a capire meglio l\'intera comunità Moodle.</p>
<p>Se lo desideri il nome del tuo sito assieme alla nazionalità ed alla URL per raggiungerlo possono essere pubblicati nell\'elenco dei siti registrati.</p>
<p>Le nuove registrazioni sono tutte verificate manualmente prima di essere inserite nell\'elenco pubblico. In qualsiasi momento è  possibile aggiornare i dati e modificare le preferenze di pubblicazione inviando nuovamente la registrazione.</p>';
$string['registrationinfotitle'] = 'Informazioni per la registrazione';
$string['registrationno'] = 'No, non voglio ricevere email';
$string['registrationsend'] = 'Invia la registrazione a moodle.org';
$string['registrationyes'] = 'Si, inviatemi email su argomenti di rilievo';
$string['reject'] = 'Invia il rifiuto';
$string['rejectdots'] = 'Rifiuta...';
$string['reload'] = 'Ricarica';
$string['remoteappuser'] = 'Utente remoto di {$a}';
$string['remove'] = 'Rimuovi';
$string['removeadmin'] = 'Rimuovi amministratore';
$string['removecreator'] = 'Rimuovi creatore di corsi';
$string['removestudent'] = 'Rimuovi studente';
$string['removeteacher'] = 'Rimuovi docente';
$string['rename'] = 'Rinomina';
$string['renamefileto'] = 'Rinomina <b>{$a}</b> in';
$string['report'] = 'Report';
$string['reports'] = 'Report';
$string['repositories'] = 'Repository';
$string['requestcourse'] = 'Richiedi l\'attivazione di un corso';
$string['requestedby'] = 'Richiesto da';
$string['requestedcourses'] = 'Corsi richesti';
$string['requestreason'] = 'Motivazione della richiesta del corso';
$string['required'] = 'Obbligatorio';
$string['requirespayment'] = 'Questo corso richiede un pagamento per l\'accesso';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Componente';
$string['resetcourse'] = 'Reset corso';
$string['resetinfo'] = 'Questa pagina permette di rimuovere i dati degli utenti dal corso, mantenendo le attività e le altre impostazioni. Fate molta attenzione perché selezionando le opzioni sotto specificate e cliccando su Reset corso, i dati utente selezionati saranno eliminati da questo corso per sempre!';
$string['resetnotimplemented'] = 'Reset non effettuato';
$string['resetstartdate'] = 'Data inizio reset';
$string['resetstatus'] = 'Stato';
$string['resettask'] = 'Task';
$string['resettodefaults'] = 'Reimposta i valori standard';
$string['resortcoursesbyname'] = 'Riordina corsi per nome';
$string['resource'] = 'Risorsa';
$string['resourcedisplayauto'] = 'Automatica';
$string['resourcedisplaydownload'] = 'Forza download';
$string['resourcedisplayembed'] = 'Embed';
$string['resourcedisplayframe'] = 'Frame';
$string['resourcedisplaynew'] = 'Nuova finestra';
$string['resourcedisplayopen'] = 'Apri';
$string['resourcedisplaypopup'] = 'Popup';
$string['resources'] = 'Risorse';
$string['resources_help'] = 'I tipi di risorse permettono di aggiungere al corso praticamente qualsiasi tipo di contenuto web.';
$string['restore'] = 'Ripristino';
$string['restorecancelled'] = 'Ripristino annullato';
$string['restorecannotassignroles'] = 'Il ripristino ha bisogno di assegnare ruoli ma tu non sei autorizzato a farlo';
$string['restorecannotcreateorassignroles'] = 'Il ripristino ha bisogno di creare o assegnare ruoli ma tu non sei autorizzato a farlo';
$string['restorecannotcreateuser'] = 'Il ripristino deve creare l\'utente \'{$a}\' ma non hai il permesso di farlo.';
$string['restorecannotoverrideperms'] = 'Il ripristino ha bisogno di modificare i privilegi ma tu non sei autorizzato a farlo';
$string['restorecoursenow'] = 'Recupera questo corso ora!';
$string['restoredaccount'] = 'Account ripristinato';
$string['restoredaccountinfo'] = 'Questo account è stato importato da un altro server e la password è stata perduta. Per impostare una nuova password tramite email, fai click su "Continua"';
$string['restorefinished'] = 'Recupero completato con successo';
$string['restoreto'] = 'Recupera a';
$string['restoretositeadding'] = 'Attenzione: state per ripristinare la pagina home del sito in modalità aggiunta dati!';
$string['restoretositedeleting'] = 'Attenzione: state per ripristinare la pagina home del sito in modalità eliminazione dati esistenti!';
$string['restoreuserconflict'] = 'Tentare di ripristinare l\'utente \'{$a}\' causerà dei conflitti';
$string['restoreuserinfofailed'] = 'Il ripristino è stato interrotto poiché non hai il permesso di ripristinare dati utente.';
$string['restoreusersprecheck'] = 'Controllo dati utente';
$string['restoreusersprecheckerror'] = 'Si sono verificati alcuni problemi durante il controllo dei dati utente';
$string['restricted'] = 'Ridotto';
$string['restrictmodules'] = 'Ridurre moduli attività?';
$string['returningtosite'] = 'Ciao, sei ritornato?';
$string['returntooriginaluser'] = 'Ritorna a {$a}';
$string['revert'] = 'Ripristina';
$string['role'] = 'Ruolo';
$string['rolemappings'] = 'Mappatura dei ruoli';
$string['rolerenaming'] = 'Ridenominazione ruolo';
$string['rolerenaming_help'] = 'L\'opzione permette di personalizzare i nomi dei ruoli usati nel corso. I privilegi non vengono modificati, verrò cambiato solo il nome del ruolo. I nomi personalizzati dei ruoli verranno usati nella pagina con l\'elenco dei partecipanti al corso e nelle altre pagine del corso dove compaiono i  nomi dei ruoli. Se assegnate un nome personalizzato ad un ruolo che è stati definito dall\'Amministratore del sito come Gestore del corso, il nome personalizzato apparirà anche nella descrizione del corso disponibile all\'interno delle Categorie.';
$string['roles'] = 'Ruoli';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Numero di ultimi articoli RSS';
$string['rsserror'] = 'Errore nella lettura dei dati RSS';
$string['rsserrorauth'] = 'Il tuo feed RSS non contiene un token di autenticazione valido.';
$string['rsserrorguest'] = 'Questo feed utilizza l\'accesso come ospite per accedere ai dati ma l\'ospite non è autorizzato a leggere i dati, Recati alla URL sorgente del del feed e ottieni un nuovo feed RSS valido,';
$string['rsstype'] = 'RSS per questa attività';
$string['saveandnext'] = 'Salva e mostra il prossimo';
$string['savechanges'] = 'Salva modifiche';
$string['savechangesanddisplay'] = 'Salva e visualizza';
$string['savechangesandreturntocourse'] = 'Salva e torna al corso';
$string['savecomment'] = 'Salva commento';
$string['savedat'] = 'Salvato:';
$string['savepreferences'] = 'Salva impostazioni';
$string['saveto'] = 'Salva in';
$string['scale'] = 'Scala';
$string['scale_help'] = '<p>I docenti possono creare scale di valutazione personalizzate utilizzabili
  in qualsiasi attività valutabile.</p>
<p>E\' preferibile assegnare alle scale di valutazione dei nomi che le identifichino
  in modo chiaro: il nome infatti apparirà nella lista drop-down delle scale
  di valutazione disponibili e negli help sensibili al contesto.</p>
<p>Le scale di valutazione sono definite tramite una lista di parole
  separate da virgole che spaziano da una valutazione minima a una massima. Di
  seguito è riportato un esempio di scala di valutazione:</p>
<blockquote><i>
   Gravemente insufficiente, Insufficiente, Sufficiente, Buono, Molto buono,
       Ottimo</i></blockquote>
<p>Le scale di valutazione personalizzate possono includere una descrizione
  del loro significato e suggerimenti su come potrebbero essere impiegate.
  Questa descrizione apparirà nelle pagine di help dei docenti e degli studenti.</p>
<p>E\' anche possibile definire una o più scale di valutazione "standard"
  a livello di sito da parte dell\'amministratore del sistema e queste saranno disponibili in tutti i corsi.</p>';
$string['scales'] = 'Scale';
$string['scalescustom'] = 'Scale personalizzate';
$string['scalescustomcreate'] = 'Aggiungi una scala';
$string['scalescustomno'] = 'Non sono ancora state create scale personalizzate';
$string['scalesstandard'] = 'Scale standard';
$string['scalestandard'] = 'Scala standard';
$string['scalestandard_help'] = '<p>E\' una scala definita a livello di sito e disponibile in qualsiasi corso.</p>';
$string['scalestip'] = 'Per creare scale personalizzate, utilizza il link \'Scale\' nel menu di amministrazione del tuo corso.';
$string['scalestip2'] = 'Per creare scale personalizzate, fate click sul link Scale presente nel blocco Amministrazione del corso, poi selezionate Modifica -> Scale';
$string['schedule'] = 'Schedula';
$string['screenreaderno'] = 'No';
$string['screenreaderuse'] = 'Screen reader';
$string['screenreaderuse_help'] = 'Permette di avere una interfaccia maggiormente accessibile in vari parti di Moodle, come ad esempio la chat.';
$string['screenreaderyes'] = 'Si';
$string['screenshot'] = 'Screenshot';
$string['search'] = 'Cerca';
$string['searchagain'] = 'Cerca ancora';
$string['searchbyemail'] = 'Cerca indirizzo email';
$string['searchbyusername'] = 'Cerca username';
$string['searchcourses'] = 'Cerca corsi';
$string['searchhelp'] = 'Puoi ricercare con più chiavi.<br />chiave : trova ogni corrispondenza di questa chiave nel testo.</br>+chiave : solo le esatte corrispondenze della chiave verranno trovate.</br>-chiave : non include i risultati che contengono questa chiave.';
$string['search_help'] = 'Per ricerche semplici, inserisci una o più parole separate da uno spazio. Saranno utilizzate tutte le parole più lunghe di due caratteri.

Per ricerche complesse, puoi accedere al form di ricerca avanzata facendo click sul pulsante cerca avendo cura di non aver inserito parole.';
$string['searchoptions'] = 'Opzioni di ricerca';
$string['searchresults'] = 'Risultati della ricerca';
$string['sec'] = 'secondo';
$string['seconds'] = 'secondi';
$string['secondstotime172800'] = '2 giorni';
$string['secondstotime259200'] = '3 giorni';
$string['secondstotime345600'] = '4 giorni';
$string['secondstotime432000'] = '5 giorni';
$string['secondstotime518400'] = '6 giorni';
$string['secondstotime604800'] = '1 settimana';
$string['secondstotime86400'] = '1 giorno';
$string['secretalreadyused'] = 'Link di conferma cambio password già utilizzato, la password non è stataodificata.';
$string['secs'] = 'secondi';
$string['section'] = 'Sezione';
$string['sectionname'] = 'Nome sezione';
$string['sections'] = 'Sezioni';
$string['sectionusedefaultname'] = 'Utilizza il nome di default della sezione';
$string['seealsostats'] = 'Vedi anche: statistiche';
$string['select'] = 'Seleziona';
$string['selectacountry'] = 'Seleziona il tuo stato';
$string['selectall'] = 'Seleziona tutto';
$string['selectamodule'] = 'Prego selezionare un modulo attività';
$string['selectaregion'] = 'Seleziona una regione';
$string['selectdefault'] = 'Seleziona default';
$string['selectedfile'] = 'File selezionati';
$string['selectednowmove'] = 'Hai selezionato {$a} file da spostare. Ora vai alla cartella di destinazione e premi \'Sposta i file qui\'';
$string['selectfiles'] = 'Seleziona file';
$string['selectnos'] = 'Seleziona tutti i \'no\'';
$string['selectperiod'] = 'Seleziona periodo';
$string['senddetails'] = 'Invia i miei dati via email';
$string['separate'] = 'Separato';
$string['separateandconnected'] = 'Stile di apprendimento Separato e Collegato';
$string['separateandconnectedinfo'] = 'Scala basata sulla teoria della conoscenza isolata e della conoscenza collegata. descrive due modi differenti con i quali possiamo valutare e imparare le cose che vediamo e che sentiamo.<ul>
<li>Il <strong>Conoscitore isolato</strong> preferisce rimanere il più obiettivo possibile senza tener conto dei propri sentimenti e delle proprie emozioni. Durante una discussione con persone che hanno idee diverse, gli piace difendere le proprie, usando la logica per trovare difetti nelle idee altrui.
<li>Il <strong>Conoscitore collegato</strong> è più disponibile verso le altre persone. E\' in grado di comunicare meglio e tende ad ascoltare e porre domande finché entra in sintonia e  "capisce le cose dal punto di vista degli altri". Impara cercando di condividere le esperienze che hanno portato alla conoscenza che ha trovato negli altri.</li></ul>';
$string['serverlocaltime'] = 'Ora locale del server';
$string['setcategorytheme'] = 'Imposta Tema di categoria';
$string['settings'] = 'Impostazioni';
$string['shortname'] = 'Nome abbreviato';
$string['shortnamecollisionwarning'] = '[*] = Questo Titolo abbreviato è già utilizzato da un corso e sarà necessario modificarlo all\'approvazione';
$string['shortnamecourse'] = 'Titolo abbreviato';
$string['shortnamecourse_help'] = '<p>Molte istituzioni assegnano ai corsi delle sigle come
BP102 o COMMS. Se volete potete usare queste sigle come Titolo abbreviato, altrimenti poterete utilizzare un titolo a piacere. Il Titolo abbreviato sarà usato al posto del Titolo del corso in tutte quelle situazioni dove è pratico usare stringhe di caratteri più brevi, come ad esempio nelle briciole di pane o nelle intestazioni delle email.</p>';
$string['shortnametaken'] = 'Titolo abbreviato già in uso in un altro corso ({$a})';
$string['shortnameuser'] = 'Nome utente abbreviato';
$string['shortsitename'] = 'Nome abbreviato del sito (es. singola parola)';
$string['show'] = 'Mostra';
$string['showactions'] = 'Mostra azioni';
$string['showadvancedsettings'] = 'Mostra impostazioni avanzate';
$string['showall'] = 'Mostra tutti i {$a}';
$string['showallcourses'] = 'Mostra tutti i corsi';
$string['showalltopics'] = 'Mostra tutti gli argomenti';
$string['showallusers'] = 'Mostra tutti gli utenti';
$string['showallweeks'] = 'Mostra tutte le settimane';
$string['showblockcourse'] = 'Mostra l\'elenco dei corsi che contengono blocchi';
$string['showcomments'] = 'Mostra/nascondi i commenti';
$string['showcommentsnonjs'] = 'Visualizza commenti';
$string['showgrades'] = 'Mostra valutazioni agli studenti';
$string['showgrades_help'] = '<p>Molte delle attività di un corso possono essere oggetto di valutazione.</p>

<p>Per impostazione predefinita, i risultati ottenuti dagli studenti vengono mostrati nella pagina Valutazioni, raggiungibile direttamente dalla pagina principale del corso.</p>

<p>Qualora un docente non sia interessato ad utilizzare le valutazioni oppure desideri evitare che gli studenti possano accedere alla pagina contenente i risultati ottenuti, è sufficiente impostare "Mostra valutazioni agli studenti" su "No". L\'impostazione su "No" non impedisce di valutare le attività del corso, impedisce solamente agli studenti di visualizzarle.</p>';
$string['showlistofcourses'] = 'Mostra l\'elenco dei corsi';
$string['showmodulecourse'] = 'Mostra l\'elenco dei corsi che contengono attività';
$string['showonly'] = 'Mostra solo';
$string['showonlytopic'] = 'Mostra solo argomento {$a}';
$string['showonlyweek'] = 'Mostra solo settimana {$a}';
$string['showperpage'] = 'Mostra {$a} per pagina';
$string['showrecent'] = 'Mostra le attività recenti';
$string['showreports'] = 'Visualizza i report delle attività';
$string['showreports_help'] = 'Per ciascun partecipanti sono disponibili i report delle attività svolte nel corso. Nei report, oltre all\'elenco delle attività svolte, è presente anche il log di accesso. Questa impostazione determina se uno studente può visualizzare i propri report dalla pagina del profilo personale.';
$string['showsettings'] = 'Mostra impostazioni';
$string['showtheselogs'] = 'Visualizza i log';
$string['showthishelpinlanguage'] = 'Mostra l\'help nella lingua: {$a}';
$string['showtopicfromothers'] = 'Visualizza argomento';
$string['showweekfromothers'] = 'Visualizza settimana';
$string['since'] = 'Dal';
$string['sincelast'] = 'dal login più recente';
$string['site'] = 'Sito';
$string['sitedefault'] = 'Default del sito';
$string['siteerrors'] = 'Errori sito';
$string['sitefiles'] = 'File del sito';
$string['sitefilesused'] = 'File del sito usati in questo corso';
$string['sitehome'] = 'Home del sito';
$string['sitelegacyfiles'] = 'File legacy del sito ';
$string['sitelogs'] = 'Log del sito';
$string['sitenews'] = 'News del sito';
$string['sitepages'] = 'Pagine del sito';
$string['sitepartlist'] = 'Non hai il privilegio per vedere l\'elenco dei partecipanti';
$string['sitepartlist0'] = 'Bisogna essere il docente del sito per poter vedere l\'elenco dei partecipanti al corso di sito';
$string['sitepartlist1'] = 'Bisogna essere un docente per poter vedere l\'elenco dei partecipanti al corso di sito';
$string['sites'] = 'Siti';
$string['sitesection'] = 'Includi una sezione';
$string['sitesettings'] = 'Impostazioni sito';
$string['siteteachers'] = 'Docenti del sito';
$string['size'] = 'Dimensione';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Saltato';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Forum relazionale - argomenti recenti';
$string['someallowguest'] = 'Alcuni corsi possono permettere l\'accesso agli ospiti';
$string['someerrorswerefound'] = 'Qualche informazione è mancante o errata. Vedi sotto per i dettagli.';
$string['sortby'] = 'Ordina per';
$string['sortbyx'] = 'Ordinamento crescente per {$a}';
$string['sortbyxreverse'] = 'Ordinamento decrescente per {$a}';
$string['sourcerole'] = 'Ruolo sorgente';
$string['specifyname'] = 'Devi specificare un nome.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = corso in attesa di approvazione)';
$string['startdate'] = 'Data di inizio del corso';
$string['startdate_help'] = 'L\'impostazione stabilisce l\'inizio della prima settimana nei corsi con formato settimanale. L\'impostazione stabilisce anche la data da cui partono i log delle attività del corso';
$string['startingfrom'] = 'Inizio da';
$string['startsignup'] = 'Crea un account';
$string['state'] = 'Stato/Provincia';
$string['statistics'] = 'Statistiche';
$string['statisticsgraph'] = 'Grafico statistiche';
$string['stats'] = 'Statistiche';
$string['statslogins'] = 'Login';
$string['statsmodedetailed'] = 'Vista dettagliata (utente)';
$string['statsmodegeneral'] = 'Vista generale';
$string['statsnodata'] = 'Non ci sono dati disponibili per quella combinazione di corso e periodo di tempo.';
$string['statsnodatauser'] = 'Non ci sono dati disponibili per quella combinazione di corso, utente e periodo di tempo.';
$string['statsoff'] = 'Le statistiche non sono abilitate';
$string['statsreads'] = 'Letture';
$string['statsreport1'] = 'Login';
$string['statsreport10'] = 'Attività utente';
$string['statsreport11'] = 'Corsi più attivi';
$string['statsreport12'] = 'Corsi più attivi (pesato)';
$string['statsreport13'] = 'Corsi con maggiore partecipazione (iscrizioni)';
$string['statsreport14'] = 'Corsi con maggiore partecipazione (letture/interventi)';
$string['statsreport2'] = 'Letture (tutti i ruoli)';
$string['statsreport3'] = 'Interventi (tutti i ruoli)';
$string['statsreport4'] = 'Tutta l\'attività (tutti i ruoli)';
$string['statsreport5'] = 'Tutta l\'attività (letture e interventi)';
$string['statsreport7'] = 'Attività utenti (letture e interventi)';
$string['statsreport8'] = 'Attività di tutti gli utenti';
$string['statsreport9'] = 'Login (sito)';
$string['statsreportactivity'] = 'Tutta l\'attività (tutti i ruoli)';
$string['statsreportactivitybyrole'] = 'Tutta l\'attività (letture e interventi)';
$string['statsreportforuser'] = 'per';
$string['statsreportlogins'] = 'Accessi';
$string['statsreportreads'] = 'Letture (tutti i ruoli)';
$string['statsreporttype'] = 'Tipo di report';
$string['statsreportwrites'] = 'Interventi (tutti i ruoli)';
$string['statsstudentactivity'] = 'Attività studente';
$string['statsstudentreads'] = 'Letture studente';
$string['statsstudentwrites'] = 'Interventi studente';
$string['statsteacheractivity'] = 'Attività docente';
$string['statsteacherreads'] = 'Letture docente';
$string['statsteacherwrites'] = 'Interventi docente';
$string['statstimeperiod'] = 'Periodo di tempo - ultimo:';
$string['statsuniquelogins'] = 'Login unici';
$string['statsuseractivity'] = 'Tutta l\'attività';
$string['statsuserlogins'] = 'Login';
$string['statsuserreads'] = 'Letture';
$string['statsuserwrites'] = 'Interventi';
$string['statswrites'] = 'Interventi';
$string['status'] = 'Stato';
$string['stringsnotset'] = 'Le seguenti stringhe non sono definite in {$a}';
$string['studentnotallowed'] = 'Spiacenti, ma non puoi accedere a questo corso come \'{$a}\'';
$string['students'] = 'Studenti';
$string['studentsandteachers'] = 'Studenti e docenti';
$string['subcategories'] = 'Sottocategorie';
$string['submit'] = 'Invia';
$string['success'] = 'Operazione eseguita con successo';
$string['summary'] = 'Introduzione';
$string['summary_help'] = '<p>Il sommario dell\'argomento o della settimana è un breve testo utile per preparare gli studenti alle attività che intraprenderanno nell\'argomento o nella settimana.</p>

<p>Il sommario dovrebbe essere breve per evitare che la pagina del corso divenga troppo lunga.</p>

<p>Se nel vostro sommario desiderate utilizzare una testo più lungo, è forse preferibile
valutare l\'utilizzo di una Risorsa, chiamate per esempio "Contenuto dell\'argomento" che illustri l\'argomento stesso con maggiore dettaglio.</p>';
$string['summaryof'] = 'Riassunto di {$a}';
$string['supplyinfo'] = 'Inserisci i tuoi dati';
$string['switchrolereturn'] = 'Ritorna al mio ruolo normale';
$string['switchroleto'] = 'Cambia ruolo in ...';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Questa tag già esiste';
$string['tagmanagement'] = 'Gestione tag';
$string['tags'] = 'Tag';
$string['targetrole'] = 'Ruolo finale';
$string['teacheronly'] = 'solo per {$a}';
$string['teacherroles'] = '{$a} ruoli';
$string['teachers'] = 'Docenti';
$string['textediting'] = 'Scrivere in formato testo';
$string['texteditor'] = 'Usa i forms web standard';
$string['textformat'] = 'Formato testo';
$string['thanks'] = 'Grazie';
$string['theme'] = 'Tema';
$string['themes'] = 'Temi';
$string['themesaved'] = 'Nuovo tema salvato';
$string['thereareno'] = 'Non ci sono {$a} in questo corso';
$string['thiscategorycontains'] = 'Questa categoria contiene';
$string['time'] = 'Ora';
$string['timezone'] = 'Fuso orario';
$string['to'] = 'A';
$string['tocreatenewaccount'] = 'Vai a creazione account';
$string['today'] = 'Oggi';
$string['todaylogs'] = 'Log di oggi';
$string['toeveryone'] = 'per tutti';
$string['toomanybounces'] = 'Questo indirizzo di email ha subito troppi rimbalzi. <b>Devi cambiarlo</b> per poter continuare.';
$string['toomanytoshow'] = 'Ci sono troppi utenti da visualizzare';
$string['toomanyusersmatchsearch'] = 'Ci sono troppi utenti ({$a->count}) che corrispondono alla ricerca \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Ci sono troppi utenti ({$a}) da visualizzare';
$string['toonly'] = 'per {$a} solamente';
$string['top'] = 'Primo livello';
$string['topic'] = 'Argomento';
$string['topichide'] = 'Nascondi questo argomento da {$a}';
$string['topicoutline'] = 'Indice degli argomenti';
$string['topicshow'] = 'Mostra questo argomento a {$a}';
$string['total'] = 'Totale';
$string['trackforums'] = 'Evidenziazione messaggi forum';
$string['trackforumsno'] = 'No, non evidenziare i post non letti';
$string['trackforumsyes'] = 'Si, evidenzia i post che non ho letto';
$string['trysearching'] = 'Prova a cercare.';
$string['turneditingoff'] = 'Termina modifica';
$string['turneditingon'] = 'Attiva modifica';
$string['undecided'] = 'Indeciso';
$string['unfinished'] = 'Non terminato';
$string['unknowncategory'] = 'Categoria sconosciuta';
$string['unlimited'] = 'Nessun limite';
$string['unpacking'] = 'Decompressione {$a}';
$string['unsafepassword'] = 'Password insicura - provarne un\'altra';
$string['untilcomplete'] = 'Fino al completamento';
$string['unusedaccounts'] = 'Gli account inutilizzati per più di {$a} giorni saranno rimossi automaticamente dal corso.';
$string['unzip'] = 'Decomprimi';
$string['unzippingbackup'] = 'Decompressione Backup';
$string['up'] = 'In alto';
$string['update'] = 'Aggiorna';
$string['updated'] = 'Aggiornato {$a}';
$string['updatemymoodleoff'] = 'Termina personalizzazione';
$string['updatemymoodleon'] = 'Personalizza questa pagina';
$string['updatemyprofile'] = 'Aggiornamento profilo';
$string['updatesevery'] = 'Aggiornamenti ogni {$a} secondi';
$string['updatethis'] = 'Aggiorna {$a}';
$string['updatethiscourse'] = 'Aggiorna questo corso';
$string['updatinga'] = 'Aggiornamento {$a}';
$string['updatingain'] = '{$a->in}: aggiornamento {$a->what}';
$string['upload'] = 'Caricamento sul server';
$string['uploadafile'] = 'Carica un file sul server';
$string['uploadcantwrite'] = 'Scrittura del file su disco fallita';
$string['uploadedfile'] = 'File caricato correttamente';
$string['uploadedfileto'] = 'File {$a->file} salvato nella directory {$a->directory}';
$string['uploadedfiletoobig'] = 'Spiacente, ma questo file è troppo grande (il limite è {$a} byte)';
$string['uploadextension'] = 'Upload interrotto a causa di un\'estensione PHP';
$string['uploadfailednotrecovering'] = 'L\'invio del file è fallito perché c\'è stato un problema con uno dei file, {$a->name}.<br />Qui c\'è il log dei problemi:<br />{$a->problem}<br />Non recuperabile.';
$string['uploadfilelog'] = 'Upload del log per il file  {$a}';
$string['uploadformlimit'] = 'Il file caricato eccede la dimensione massima impostata per il modulo';
$string['uploadlabel'] = 'Titolo:';
$string['uploadnewfile'] = 'Carica un file';
$string['uploadnofilefound'] = 'Non è stato trovato alcun file. Sei sicuro di averne selezionato uno per l\'upload?';
$string['uploadnotallowed'] = 'Gli upload di file non sono consentiti';
$string['uploadnotempdir'] = 'Manca una cartella temporanea';
$string['uploadoldfilesdeleted'] = 'I vecchi file sul server sono stati eliminati';
$string['uploadpartialfile'] = 'Il file era stato solo parzialmente inviato';
$string['uploadproblem'] = 'Un problema sconosciuto si è verificato salvando il file \'{$a}\' (può essere troppo grande?)';
$string['uploadrenamedchars'] = 'Il file è stato rinominato da {$a->oldname} a {$a->newname} perché conteneva caratteri non validi.';
$string['uploadrenamedcollision'] = 'Il file è stato rinominato da {$a->oldname} a {$a->newname} perché il nome era in conflitto con un altro.';
$string['uploadserverlimit'] = 'La dimensione del file inviato eccede la dimensione massima impostata per il server';
$string['uploadthisfile'] = 'Trasferisci questo file';
$string['url'] = 'URL';
$string['used'] = 'In uso';
$string['usedinnplaces'] = 'Utilizzato in {$a} posti';
$string['useforlegacytheme'] = 'Uso con browser obsoleti ';
$string['useformaintheme'] = 'Uso con browser moderni';
$string['usemessageform'] = 'o utilizzare il modulo sottostante per spedire un messaggio agli studenti selezionati';
$string['user'] = 'Utente';
$string['userconfirmed'] = 'Utente {$a} confermato';
$string['usercurrentsettings'] = 'Impostazioni profilo';
$string['userdata'] = 'Dati utente';
$string['userdeleted'] = 'Questo account è stato eliminato';
$string['userdescription'] = 'Descrizione';
$string['userdescription_help'] = 'Questa area di testo ti permette di inserire delle informazioni su di te che compariranno nel tuo profilo e che saranno visibili agli altri utenti.';
$string['userdetails'] = 'Con dettagli dell\'utente';
$string['userfiles'] = 'File utente';
$string['userlist'] = 'Elenco utenti';
$string['username'] = 'Username';
$string['usernameemailmatch'] = 'Il nome utente e l\'indirizzo mail non appartengono allo stesso utente';
$string['usernameexists'] = 'Questo username è già esistente, sceglierne un altro';
$string['usernamelowercase'] = 'Sono consentite solo lettere minuscole';
$string['usernamenotfound'] = 'Lo username non è stato trovato nella base dati';
$string['usernameoremail'] = 'Inserisci username o indirizzo email';
$string['usernotconfirmed'] = 'Non è possibile confermare {$a}';
$string['userpic'] = 'Immagine utente';
$string['users'] = 'Utenti';
$string['userselectorautoselectunique'] = 'Se la ricerca trova un solo utente, selezionalo automaticamente';
$string['userselectorpreserveselected'] = 'Mantieni gli utenti selezionati, anche se non soddisfano più i criteri di ricerca';
$string['userselectorsearchanywhere'] = 'Cerca corrispondenze dei criteri di ricerca in tutto il nome utente';
$string['usersnew'] = 'Nuovi utenti';
$string['usersnoaccesssince'] = 'Visualizza gli utenti che sono stati inattivi per più di';
$string['userswithfiles'] = 'Utenti con file';
$string['useruploadtype'] = 'Tipo caricamento utente: {$a}';
$string['userviewingsettings'] = 'Impostazioni profilo per {$a}';
$string['userzones'] = 'Zone utenti';
$string['usingexistingcourse'] = 'Utilizza un corso già esistente';
$string['valuealreadyused'] = 'Questo valore è stato già utilizzato';
$string['version'] = 'Versione';
$string['view'] = 'Visualizza';
$string['viewallcourses'] = 'Visualizza tutti i corsi';
$string['viewallcoursescategories'] = 'Visualizza tutti i corsi e le categorie';
$string['viewfileinpopup'] = 'Visualizza il file in un finestra popup';
$string['viewprofile'] = 'Visualizza';
$string['views'] = 'Letture';
$string['viewsolution'] = 'visualizza soluzione';
$string['virusfound'] = 'Amministratore attenzione! Clam AV ha individuato un virus in un file caricato da {$a->user} nel corso {$a->course}. Di seguito l\'output di clamscan:';
$string['virusfoundlater'] = 'Un file caricato il {$a->date} nel corso {$a->course} di nome {$a->filename} contiene un virus. Questo è il resoconto di ciò che è accaduto al tuo file:

{$a->action}

Se questo file è un lavoro che hai inviato, è preferibile inviarlo nuovamente.';
$string['virusfoundlateradmin'] = 'Amministratore attenzione! Un file caricato il {$a->date} nel corso {$a->course} di nome {$a->filename} contiene un virus. Questo è il resoconto di ciò che è accaduto al tuo file:

{$a->action}

L\'utente è stato avvisato.';
$string['virusfoundlateradminnolog'] = 'Amministratore attenzione! Un file di nome {$a->filename} è infetto da virus. Moodle non è stato in grado di individuare l\'utente che lo ha caricato.

Di seguito viene riportato cosa è avvenuto al file:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: trovato virus!';
$string['virusfounduser'] = 'Il file che hai caricato, {$a->filename}, è stato analizzato dall\'antivirus e ed è stata rilevata un\'infezione. Il caricamento del file non è andato a buon fine.';
$string['virusplaceholder'] = 'Questo file contiene un virus, pertanto è stato spostato altrove o eliminato. L\'utente è stato informato.';
$string['visible'] = 'Visibile';
$string['visibletostudents'] = 'Visibile da {$a}';
$string['warningdeleteresource'] = 'Attenzione: {$a} è collegato a una risorsa. Si vuole aggiornare la risorsa?';
$string['webpage'] = 'Pagina web';
$string['week'] = 'Settimana';
$string['weekhide'] = 'Nascondi questa settimana da {$a}';
$string['weeklyoutline'] = 'Attività settimanale';
$string['weekshow'] = 'Mostra questa settimana a {$a}';
$string['welcometocourse'] = 'Benvenuto(a) {$a}';
$string['welcometocoursetext'] = 'Benvenuto(a) in {$a->coursename}!

Se non lo hai già fatto, dovresti modificare la pagina del tuo profilo personale in modo da permetterci di conoscerti meglio:

{$a->profileurl}';
$string['whattocallzip'] = 'Come vuoi chiamare il file zip?';
$string['whattodo'] = 'Cosa fare';
$string['windowclosing'] = 'Questa finestra dovrebbe chiudersi automaticamente. Se non si chiude, per favore chiudetela ora.';
$string['withchosenfiles'] = 'Con i files scelti';
$string['withoutuserdata'] = 'senza dati utente';
$string['withselectedusers'] = 'Con gli utenti selezionati...';
$string['withselectedusers_help'] = '* Invia messaggio - Per inviare un mesaggio a uno o più partecipanti
* Aggiungi un\'annotazione - per aggiungere un\'annotazione ad un determinato partecipante
* Aggiungi un\'annotazione generale - Per aggiungere la stessa annotazione a più partecipanti';
$string['withuserdata'] = 'con i dati utente';
$string['wordforstudent'] = 'Come vuoi chiamare lo studente';
$string['wordforstudenteg'] = 'es. Studente, Partecipante etc';
$string['wordforstudents'] = 'Come vuoi chiamare gli studenti';
$string['wordforstudentseg'] = 'es. Studenti, Partecipanti etc';
$string['wordforteacher'] = 'Come vuoi chiamare il docente';
$string['wordforteachereg'] = 'es. Docente, Tutor, Facilitatore etc';
$string['wordforteachers'] = 'Come vuoi chiamare i docenti';
$string['wordforteacherseg'] = 'es. Docenti, Tutor, Facilitatori etc.';
$string['writingblogsinfo'] = 'Scrittura informazioni di blog';
$string['writingcategoriesandquestions'] = 'Scrittura categorie e domande';
$string['writingcoursedata'] = 'Scrittura dati corso';
$string['writingeventsinfo'] = 'Scrittura informazioni eventi';
$string['writinggeneralinfo'] = 'Scrittura informazioni generali';
$string['writinggradebookinfo'] = 'Scrittura informazioni sulle valutazioni';
$string['writinggroupingsgroupsinfo'] = 'Scrittura informazioni raggruppamenti-gruppi';
$string['writinggroupingsinfo'] = 'Scrittura informazioni raggruppamenti';
$string['writinggroupsinfo'] = 'Scrittura informazioni gruppi';
$string['writingheader'] = 'Scrittura intestazione';
$string['writingloginfo'] = 'Scrittura informazioni log';
$string['writingmessagesinfo'] = 'Scrittura messaggi';
$string['writingmoduleinfo'] = 'Scrittura informazioni moduli';
$string['writingscalesinfo'] = 'Scrittura informazioni scale';
$string['writinguserinfo'] = 'Scrittura informazioni utenti';
$string['wrongpassword'] = 'Password errata per questo username';
$string['xmldbeditor'] = 'Editor XMLDB';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'anno';
$string['years'] = 'anni';
$string['yes'] = 'Sì';
$string['youareabouttocreatezip'] = 'Stai per creare un file compresso contenente';
$string['youaregoingtorestorefrom'] = 'Stai per ripristinare da:';
$string['youneedtoenrol'] = 'Per effettuare questa operazione bisogna essere iscritti a questo corso.';
$string['yourlastlogin'] = 'Il tuo login più recente è stato:';
$string['yourself'] = 'te stesso';
$string['yourteacher'] = 'il tuo {$a}';
$string['yourwordforx'] = 'Denomina il ruolo \'{$a}\' come';
$string['zippingbackup'] = 'Compressione Backup';
