<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'de', branch 'MOODLE_20_STABLE'
 *
 * @package   role
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Neue Rolle wird hinzugefügt';
$string['addingrolebycopying'] = 'Neue Rolle basierend auf {$a} wird hinzugefügt';
$string['addrole'] = 'Neue Rolle hinzufügen';
$string['advancedoverride'] = 'Erweiterte Rollenänderung';
$string['allow'] = 'Erlauben';
$string['allowassign'] = 'Rollenzuweisung erlauben';
$string['allowed'] = 'Erlaubt';
$string['allowoverride'] = 'Rollenänderung erlauben';
$string['allowroletoassign'] = 'Nutzer/innen mit der Rolle {$a->fromrole} erlauben, die Rolle {$a->targetrole} einzunehmen';
$string['allowroletooverride'] = 'Nutzer/innen mit der Rolle {$a->fromrole} erlauben, die Rolle {$a->targetrole} zu verändern';
$string['allowroletoswitch'] = 'Nutzer mit der {$a->fromrole} Rolle erlauben in $a-targetrole zu wechseln';
$string['allowswitch'] = 'Rollenwechsel erlauben';
$string['allsiteusers'] = 'Alle Nutzer des Systems';
$string['archetype'] = 'Grundform der Rolle';
$string['archetypecoursecreator'] = 'Basisrolle: Kursersteller/in';
$string['archetypeeditingteacher'] = 'Basisrolle: Trainer/in';
$string['archetypefrontpage'] = 'Basisrolle: Authentifizierte/r Nutzer/in der Startseite';
$string['archetypeguest'] = 'Basisrolle: Gast';
$string['archetype_help'] = 'Der Typ Basisrolle bestimmt die Berechtigungen, wenn eine Rolle in ihren Ausgangszustand zurückgesetzt wird. Es legt ebenfalls die Berechtigungen fest, falls eine Rolle upgedatet wird.';
$string['archetypemanager'] = 'Basisrolle: Manager/in';
$string['archetypestudent'] = 'Basisrolle: Teilnehmer/in';
$string['archetypeteacher'] = 'Basisrolle: Trainer/in ohne Bearbeitungsrecht';
$string['archetypeuser'] = 'Basisrolle: Authentifizierte/r Nutzer/in';
$string['assignanotherrole'] = 'Weitere Rolle zuweisen';
$string['assignedroles'] = 'Rollen zuweisen';
$string['assignerror'] = 'Bei der Zuordnung der Rolle {$a->role} zum Nutzerkonto {$a->user} ist ein Fehler aufgetreten.';
$string['assignglobalroles'] = 'Globale Rollen';
$string['assignmentcontext'] = 'Zuweisungskontext';
$string['assignmentoptions'] = 'Zuweisungsoptionen';
$string['assignrole'] = 'Rollen zuweisen';
$string['assignrolenameincontext'] = 'Weise die Rolle \'{$a->role}\' in \'{$a->context}\' zu.';
$string['assignroles'] = 'Rollen zuweisen';
$string['assignroles_help'] = 'Durch die Rollenzuweisung in einem Kontext werden alle Fähigkeiten der Rolle übertragen, und zwar im aktuellen Kontext und in allen nachrangigen Kontexten. Wird beispielsweise Nutzer/innen die Teilnehmerrolle in einem Kurs zugewiesen, so haben sie diese Teilnehmerrolle ebenfalls für alle Aktivitäten und Blöcke innerhalb des Kurses. ';
$string['assignrolesin'] = 'Rollen zuweisen in {$a}';
$string['assignrolesrelativetothisuser'] = 'Rollen relativ zu diesem Nutzerkonto zuweisen';
$string['backtoallroles'] = 'Zurück zur Rollenliste';
$string['backup:anonymise'] = 'Nutzeranonymisierung bei der Sicherung';
$string['backup:backupactivity'] = 'Aktivitäten sichern';
$string['backup:backupcourse'] = 'Kurse sichern';
$string['backup:backupsection'] = 'Abschnitte sichern';
$string['backup:backuptargethub'] = 'Sicherung für einen Hub';
$string['backup:backuptargetimport'] = 'Sicherung für den Import';
$string['backup:configure'] = 'Sicherungsoptionen konfigurieren';
$string['backup:downloadfile'] = 'Sicherungsdateien herunterladen';
$string['backup:userinfo'] = 'Nutzerdaten sichern';
$string['block:edit'] = 'Blockeinstellungen ändern';
$string['block:view'] = 'Block sehen';
$string['blog:associatecourse'] = 'Blogeinträge mit Kursen verbinden';
$string['blog:associatemodule'] = 'Blogeinträge mit Aktivitäten verbinden';
$string['blog:create'] = 'Neue Blogeinträge erstellen';
$string['blog:manageentries'] = 'Blogeinträge verwalten';
$string['blog:manageexternal'] = 'Externe Blogs verwalten';
$string['blog:manageofficialtags'] = 'Offizielle Schlagworte verwalten';
$string['blog:managepersonaltags'] = 'Persönliche Schlagworte verwalten';
$string['blog:search'] = 'Blogeinträge suchen';
$string['blog:view'] = 'Blogeinträge sehen';
$string['blog:viewdrafts'] = 'Blogeinträge als Entwürfe sehen';
$string['calendar:manageentries'] = 'Alle Kalendereinträge verwalten';
$string['calendar:managegroupentries'] = 'Kalendereinträge für Gruppen verwalten';
$string['calendar:manageownentries'] = 'Eigene Kalendereinträge verwalten';
$string['capabilities'] = 'Fähigkeiten';
$string['capability'] = 'Fähigkeit';
$string['category:create'] = 'Kursbereiche anlegen';
$string['category:delete'] = 'Kursbereiche löschen';
$string['category:manage'] = 'Kursbereiche verwalten';
$string['category:update'] = 'Kursbereiche aktualisieren';
$string['category:viewhiddencategories'] = 'Verborgene Kursbereiche sehen';
$string['category:visibility'] = 'Verborgene Kursbereiche sehen';
$string['checkglobalpermissions'] = 'Systemrechte prüfen';
$string['checkpermissions'] = 'Rechte prüfen';
$string['checkpermissionsin'] = 'Rechte prüfen in {$a}';
$string['checksystempermissionsfor'] = 'Rechte prüfen für {$a->fullname}';
$string['checkuserspermissionshere'] = 'Rechte prüfen, die {$a->fullname} bei {$a->contextlevel} hat';
$string['chooseroletoassign'] = 'Wählen Sie bitte eine zuzuweisende Rolle';
$string['cohort:assign'] = 'Mitglieder von globalen Gruppen verwalten';
$string['cohort:manage'] = 'Globale Gruppen anlegen, löschen und bewegen';
$string['cohort:view'] = 'Globale Gruppen sehen';
$string['comment:delete'] = 'Kommentare löschen';
$string['comment:post'] = 'Kommentare schreiben';
$string['comment:view'] = 'Kommentare lesen';
$string['community:add'] = 'Community-Block nutzen, um Hubs zu durchsuchen und Kurse zu finden';
$string['community:download'] = 'Kurs aus dem Community-Block herunterladen';
$string['confirmaddadmin'] = 'Möchten Sie wirklich <strong>{$a}</strong> als neuen Administrator hinzufügen?';
$string['confirmdeladmin'] = 'Möchten Sie wirklich <strong>{$a}</strong> aus der Liste der Administratoren löschen?';
$string['confirmroleprevent'] = 'Möchten Sie wirklich <strong>{$a->role}</strong> aus der Liste der erlaubten Rollen für die Fähigkeit {$a->cap} im Kontext {$a->context} entfernen?';
$string['confirmroleunprohibit'] = 'Möchten Sie wirklich <strong>{$a->role}</strong> aus der Liste der verbotenen Rollen für die Fähigkeit {$a->cap} im Kontext {$a->context} entfernen?';
$string['confirmunassign'] = 'Sind Sie sicher, dass Sie die Rolle bei dieser Person löschen möchten?';
$string['confirmunassignno'] = 'Abbrechen';
$string['confirmunassigntitle'] = 'Rollenwechsel bestätigen';
$string['confirmunassignyes'] = 'Löschen';
$string['context'] = 'Kontext';
$string['course:activityvisibility'] = 'Aktivitäten anzeigen / verbergen';
$string['course:bulkmessaging'] = 'Nachrichten an viele Empfänger senden';
$string['course:changecategory'] = 'Kursbereich ändern';
$string['course:changefullname'] = 'Vollständigen Kursnamen ändern';
$string['course:changeidnumber'] = 'Kurs-ID-Nummer ändern';
$string['course:changeshortname'] = 'Kurztitel des Kurses ändern';
$string['course:changesummary'] = 'Kursbeschreibung ändern';
$string['course:create'] = 'Kurse anlegen';
$string['course:delete'] = 'Kurse löschen';
$string['course:enrolconfig'] = 'Einschreibeverfahren in Kursen konfigurieren';
$string['course:enrolreview'] = 'Kurseinschreibungen überprüfen';
$string['course:manageactivities'] = 'Aktivitäten verwalten';
$string['course:managefiles'] = 'Dateien verwalten';
$string['course:managegrades'] = 'Bewertungen verwalten';
$string['course:managegroups'] = 'Gruppen verwalten';
$string['course:managescales'] = 'Bewertungskalen verwalten';
$string['course:markcomplete'] = 'Nutzer/innen in \'Kursabschluss\' als \'abgeschlossen\' markieren';
$string['course:publish'] = 'Kurs in einem Hub veröffentlichen';
$string['course:request'] = 'Neue Kurse beantragen';
$string['course:reset'] = 'Kurs zurücksetzen';
$string['course:sectionvisibility'] = 'Abschnitte anzeigen / verbergen';
$string['course:setcurrentsection'] = 'Kursabschnitt als \'aktuell\' markieren';
$string['course:update'] = 'Kurseinstellungen aktualisieren';
$string['course:useremail'] = 'E-Mail-Adresse ein-/ausschalten';
$string['course:view'] = 'Kurse ohne Beteiligung ansehen';
$string['course:viewcoursegrades'] = 'Bewertungen sehen';
$string['course:viewhiddenactivities'] = 'Verborgene Aktivitäten sehen';
$string['course:viewhiddencourses'] = 'Verborgene Kurse sehen';
$string['course:viewhiddensections'] = 'Verborgene Kursabschnitte sehen';
$string['course:viewhiddenuserfields'] = 'Verborgene Nutzerfelder sehen';
$string['course:viewparticipants'] = 'Kursteilnehmer/innen sehen';
$string['course:viewscales'] = 'Bewertungskalen sehen';
$string['course:visibility'] = 'Kurse anzeigen / verbergen';
$string['createrolebycopying'] = 'Neue Rolle als Kopie von {$a} erzeugen';
$string['createthisrole'] = 'Neue Rolle erzeugen';
$string['currentcontext'] = 'Aktueller Kontext';
$string['currentrole'] = 'Derzeitige Rolle';
$string['defaultrole'] = 'Standardrolle';
$string['defaultx'] = 'Standard: {$a}';
$string['defineroles'] = 'Rollen verwalten';
$string['deletecourseoverrides'] = 'Alle Änderungen im Kurs löschen';
$string['deletelocalroles'] = 'Alle lokalen Rollenzuordnungen löschen';
$string['deleterolesure'] = 'Sind Sie sicher, dass Sie die Rolle "{$a->name} ({$a->shortname})" wirklich löschen möchten?</p>
<p>Aktuell sind dieser Rolle insgesamt {$a->count} Nutzer/innen zugewiesen.';
$string['deletexrole'] = 'Rolle {$a} löschen';
$string['duplicaterole'] = 'Rolle duplizieren';
$string['duplicaterolesure'] = 'Sind Sie sicher, dass Sie die Rolle "{$a->name} ({$a->shortname})" duplizieren möchten?</p>';
$string['editingrolex'] = 'Rolle \'{$a}\' wird bearbeitet';
$string['editrole'] = 'Rolle bearbeiten';
$string['editxrole'] = 'Rolle \'{$a}\' bearbeiten';
$string['errorbadrolename'] = 'Ungültiger Rollenname';
$string['errorbadroleshortname'] = 'Ungültiger Rollenkurzname';
$string['errorexistsrolename'] = 'Rollenname existiert bereits';
$string['errorexistsroleshortname'] = 'Rollenname existiert bereits';
$string['existingadmins'] = 'Aktuelle Administrator/innen';
$string['existingusers'] = '{$a} Nutzer/innen';
$string['explanation'] = 'Erklärung';
$string['extusers'] = 'Vorhandene Nutzer/innen';
$string['extusersmatching'] = 'Nutzer/innen, die zu \'{$a}\' passen';
$string['filter:manage'] = 'Lokale Filterinstellungen verwalten';
$string['frontpageuser'] = 'Authentifizierte/r Nutzer/in der Startseite';
$string['frontpageuserdescription'] = 'Alle Nutzer/innen, die auf der Startseite eingeloggt sind';
$string['globalrole'] = 'Globale Rolle';
$string['globalroleswarning'] = 'ACHTUNG! Jede hier zugewiesene Rolle wird für die gesamte Webseite angelegt. Die jeweiligen Nutzer/innen besitzen die Rolle dann wirklich für alle Kurse und auch für die Startseite.';
$string['gotoassignroles'] = 'Gehe zu Rollen zuweisen für {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Globale Rollen zuweisen';
$string['grade:edit'] = 'Bewertungen bearbeiten';
$string['grade:export'] = 'Bewertungen exportieren';
$string['grade:hide'] = 'Bewertungen oder Aspekte anzeigen / verbergen';
$string['grade:import'] = 'Bewertungen importieren';
$string['grade:lock'] = 'Bewertungen oder Aspekte sperren';
$string['grade:manage'] = 'Bewertungsaspekte verwalten';
$string['grade:manageletters'] = 'Bewertungsbuchstaben verwalten';
$string['grade:manageoutcomes'] = 'Lernziele verwalten';
$string['grade:override'] = 'Bewertungen ändern';
$string['grade:unlock'] = 'Bewertungen oder Aspekte freigeben';
$string['grade:view'] = 'Eigene Bewertungen ansehen';
$string['grade:viewall'] = 'Fremde Bewertungen ansehen';
$string['grade:viewhidden'] = 'Verborgene Bewertungen sehen';
$string['hidden'] = 'Verborgen';
$string['highlightedcellsshowdefault'] = 'Die in der folgenden Tabelle markierten Rechte sind die Standardwerte für diese Rolle. Grundlage ist die ausgewählte Basisrolle.';
$string['highlightedcellsshowinherit'] = 'Die in der folgenden Tabelle markierten Zellen zeigen die (möglicherweise vorhandenen) vererbten Rechte. Mit Ausnahme des zu ändernden Rechts sollten alle Einstellungen unverändert auf \'vererben\' bleiben.';
$string['inactiveformorethan'] = 'länger als {$a->timeperiod} inaktiv';
$string['ingroup'] = 'in der Gruppe \'{$a->group}\'';
$string['inherit'] = 'Vererben';
$string['legacy:admin'] = 'Basisrolle: Administrator';
$string['legacy:coursecreator'] = 'Basisrolle: Kursersteller/in';
$string['legacy:editingteacher'] = 'Basisrolle: Trainer/in';
$string['legacy:guest'] = 'Basisrolle: Gast';
$string['legacy:student'] = 'Basisrolle: Teilnehmer/in';
$string['legacy:teacher'] = 'Basisrolle: Trainer/in ohne Bearbeitungsrecht';
$string['legacytype'] = 'Basisrollentyp';
$string['legacy:user'] = 'Basisrolle: Authentifizierte/r Nutzer/in';
$string['listallroles'] = 'Alle Rollen auflisten';
$string['localroles'] = 'Lokale Rollen zuweisen';
$string['manageadmins'] = 'Administrator/innen verwalten';
$string['manager'] = 'Manager/in';
$string['managerdescription'] = 'Manager/innen können alle Kurse betreten und bearbeiten, ohne in die Kurse eingeschrieben zu sein.';
$string['manageroles'] = 'Rollen verwalten';
$string['maybeassignedin'] = 'Kontexttypen, in denen diese Rolle möglicherweise zugewiesen ist.';
$string['morethan'] = 'Mehr als {$a}';
$string['multipleroles'] = 'Mehrfach-Rollen';
$string['my:configsyspages'] = 'Systemvorlagen für \'Meine Startseite\' konfigurieren';
$string['my:manageblocks'] = 'Blöcke für \'Meine Startseite\' verwalten';
$string['neededroles'] = 'Rollen mit Rechten';
$string['nocapabilitiesincontext'] = 'In diesem Kontext sind keine Fähigkeiten verfügbar';
$string['noneinthisx'] = 'Nichts in dieser {$a}';
$string['noneinthisxmatching'] = 'Keine Nutzer für die Suche nach \'{$a->search}\' im Kontext {$a->contexttype}\' gefunden';
$string['noroleassignments'] = 'Diesem Nutzerkonto wurde keine Rolle systemweit zuwiesen.';
$string['noroles'] = 'Keine Rollen';
$string['notabletoassignroleshere'] = 'Sie dürfen hier keine Rollen zuzuweisen.';
$string['notabletooverrideroleshere'] = 'Sie dürfen hier keine Rollenrechte ändern.';
$string['notes:manage'] = 'Anmerkungen verwalten';
$string['notes:view'] = 'Anmerkungen sehen';
$string['notset'] = 'Nicht gesetzt';
$string['overrideanotherrole'] = 'Weitere Rolle ändern';
$string['overridecontext'] = 'Kontext ändern';
$string['overridepermissions'] = 'Rechte ändern';
$string['overridepermissionsforrole'] = 'Rollenrechte für \'{$a->role}\' in {$a->context} ändern';
$string['overridepermissions_help'] = 'Die Änderung von Rollenrechten ermöglicht, ausgewählte Fähigkeiten in bestimmten Kontexten zu erlauben oder zu verbieten.';
$string['overridepermissionsin'] = 'Rechte in {$a} ändern';
$string['overrideroles'] = 'Rollen ändern';
$string['overriderolesin'] = 'Rollen in {$a} ändern';
$string['overrides'] = 'Änderungen';
$string['overridesbycontext'] = 'Änderungen (im Kontext)';
$string['permission'] = 'Recht';
$string['permission_help'] = 'Rechte sind Einstellungen für bestimmte Nutzerfähigkeiten, für die es 4 Optionen gibt:

* Nicht gesetzt - Die Fähigkeit wird vererbt, d.h. sie wird unverändert von einem übergeordneten (weniger speziellen) Kontext übernommen
* Erlauben - Die Fähigkeit wird erlaubt und darf ausgeführt werden
* Entziehen - Die Fähigkeit wird entzogen, auch wenn sie in übergeordnetem Kontext erlaubt ist
* Verbieten - Die Fähigkeit wird vollständig verboten und kann in keinem untergeordneten (spezielleren) Kontext wieder erlaubt werden';
$string['permissions'] = 'Rechte';
$string['permissionsforuser'] = 'Rechte für Nutzerkonto \'{$a}\'';
$string['permissionsincontext'] = 'Rechte für {$a}';
$string['portfolio:export'] = 'In Portfolios exportieren';
$string['potentialusers'] = '{$a} mögliche Nutzer/innen';
$string['potusers'] = 'Mögliche Nutzer/innen';
$string['potusersmatching'] = 'Mögliche Nutzer/innen, die zu \'{$a}\' passen';
$string['prevent'] = 'Entziehen';
$string['prohibit'] = 'Verbieten';
$string['prohibitedroles'] = 'Verboten';
$string['question:add'] = 'Neue Fragen hinzufügen';
$string['question:config'] = 'Fragetypen konfigurieren';
$string['question:editall'] = 'Alle Fragen bearbeiten';
$string['question:editmine'] = 'Eigene Fragen bearbeiten';
$string['question:flag'] = 'Fragen während der Beantwortung markieren';
$string['question:managecategory'] = 'Fragenkategorien verwalten';
$string['question:moveall'] = 'Alle Fragen verschieben';
$string['question:movemine'] = 'Eigene Fragen verschieben';
$string['question:useall'] = 'Alle Fragen verwenden';
$string['question:usemine'] = 'Eigene Fragen verwenden';
$string['question:viewall'] = 'Alle Fragen sehen';
$string['question:viewmine'] = 'Eigene Fragen sehen';
$string['rating:rate'] = 'Bewertung hinzufügen';
$string['rating:view'] = 'Eigene Gesamtwertung sehen';
$string['rating:viewall'] = 'Alle Teilwertungen sehen';
$string['rating:viewany'] = 'Alle Gesamtwertungen sehen';
$string['resetrole'] = 'Grundeinstellungen wiederherstellen';
$string['resetrolenolegacy'] = 'Rechte löschen';
$string['resetrolesure'] = 'Sind Sie sicher, dass Sie die Rolle "{$a->name} ({$a->shortname})" auf die Standardwerte zurücksetzen möchten? <br />Alle Einstellungen werden entsprechend dem ausgewählten Basisrolle ({$a->legacytype}) belegt.';
$string['resetrolesurenolegacy'] = 'Sind Sie sicher, dass Sie alle Rechte entfernen möchten, die in der Rolle "{$a->name} ({$a->shortname})" definiert wurden?';
$string['restore:configure'] = 'Wiederherstellung konfigurieren';
$string['restore:createuser'] = 'Nutzerkonten beim Wiederherstellen anlegen';
$string['restore:restoreactivity'] = 'Aktivitäten wiederherstellen';
$string['restore:restorecourse'] = 'Kurse wiederherstellen';
$string['restore:restoresection'] = 'Kursabschnitte wiederherstellen';
$string['restore:restoretargethub'] = 'Aus für Hubs bestimmten Dateien wiederherstellen';
$string['restore:restoretargetimport'] = 'Aus für Import bestimmten Dateien wiederherstellen';
$string['restore:rolldates'] = 'Beim Wiederherstellen ist das Hinzufügen von Konfigurationsdaten erlaubt';
$string['restore:uploadfile'] = 'Dateien ins Verzeichnis \'backup\' hochladen';
$string['restore:userinfo'] = 'Nutzerdaten wiederherstellen';
$string['restore:viewautomatedfilearea'] = 'Kurse aus automatisch erstellten Sicherungen wiederherstellen';
$string['risks'] = 'Risiken';
$string['roleallowheader'] = 'Erlaube Rolle:';
$string['roleallowinfo'] = 'Wählen Sie eine Rolle aus, die in die Liste der erlaubten Rollen hinzugefügt werden soll - Kontext {$a->context}, Fähigkeit {$a->cap}:';
$string['role:assign'] = 'Rollen an Nutzer/innen zuweisen';
$string['roleassignments'] = 'Rollenzuweisungen';
$string['roledefinitions'] = 'Rollendefinitionen';
$string['rolefullname'] = 'Name';
$string['role:manage'] = 'Rollen erstellen und verwalten';
$string['role:override'] = 'Rolle überschreiben';
$string['roleprohibitheader'] = 'Nichterlaubte Rolle';
$string['roleprohibitinfo'] = 'Wählen Sie eine Rolle aus, die in die Liste der nichterlaubten Rollen hinzugefügt werden soll - Kontext {$a->context}, Fähigkeit {$a->cap}:';
$string['role:review'] = 'Rechte überprüfen';
$string['roles'] = 'Rollen';
$string['role:safeoverride'] = 'Sichere Rechte für andere ändern';
$string['roleselect'] = 'Rolle aussuchen';
$string['roles_help'] = 'Eine Rolle ist definiert durch einen Satz von Rechten, die für die gesamte Website festgelegt sind. Rollen können einzelnen Nutzer/innen in bestimmten Kontexten (Zusammenhängen) zugewiesen werden.
';
$string['roleshortname'] = 'Kurzbezeichnung';
$string['role:switchroles'] = 'Rollen wechseln';
$string['roletoassign'] = 'Zuzuweisende Rolle';
$string['roletooverride'] = 'Zu überschreibende Rolle';
$string['safeoverridenotice'] = 'Anmerkung: Rechte mit höheren Risiken sind gesperrt. Sie dürfen nur sichere Rechte ändern.';
$string['selectanotheruser'] = 'Weitere Nutzer auswählen';
$string['selectauser'] = 'Nutzer/in auswählen';
$string['selectrole'] = 'Rolle auswählen';
$string['showallroles'] = 'Alle Rollen anzeigen';
$string['showthisuserspermissions'] = 'Rechte für dieses Nutzerkonto zeigen';
$string['site:accessallgroups'] = 'Auf alle Gruppen zugreifen';
$string['siteadministrators'] = 'Administrator/innen';
$string['site:approvecourse'] = 'Kurserstellung genehmigen';
$string['site:backup'] = 'Kurse sichern';
$string['site:config'] = 'Moodle-Konfiguration anpassen';
$string['site:doanything'] = 'Darf alles machen';
$string['site:doclinks'] = 'Links zu den MoodleDocs anzeigen';
$string['site:import'] = 'Andere Kurse in eigenen Kurs importieren';
$string['site:manageblocks'] = 'Blöcke auf einer Seite verwalten';
$string['site:mnetloginfromremote'] = 'Aus anderem Moodle über MNet einloggen';
$string['site:mnetlogintoremote'] = 'Zu anderem Moodle über MNet verbinden';
$string['site:readallmessages'] = 'Alle Mitteilungen lesen';
$string['site:restore'] = 'Kurse wiederherstellen';
$string['site:sendmessage'] = 'Nachrichten an alle versenden';
$string['site:trustcontent'] = 'Übermittelten Inhalten vertrauen';
$string['site:uploadusers'] = 'Neue Nutzer/innen aus Datei importieren';
$string['site:viewfullnames'] = 'Vollständige Nutzernamen sehen';
$string['site:viewparticipants'] = 'Alle Nutzer/innen sehen';
$string['site:viewreports'] = 'Berichte sehen';
$string['tag:create'] = 'Neue Schlagworte erstellen';
$string['tag:edit'] = 'Vorhandene Schlagworte bearbeiten';
$string['tag:editblocks'] = 'Blöcke auf Schlagwortseiten bearbeiten';
$string['tag:manage'] = 'Schlagworte verwalten';
$string['thisusersroles'] = 'Rollenzuweisungen für dieses Nutzerkonto';
$string['unassignarole'] = 'Nicht zugewiesene Rolle {$a}';
$string['unassignconfirm'] = 'Wollen Sie wirklich Teilnehmer/in "{$a->user}" die Rolle "{$a->role}" entziehen?';
$string['unassignerror'] = 'Es ist ein Fehler während der Entfernung der Rolle {$a->role} des/r Nutzer/in {$a->user} aufgetreten.';
$string['user:changeownpassword'] = 'Eigenes Kennwort ändern';
$string['user:create'] = 'Nutzer/innen anlegen';
$string['user:delete'] = 'Nutzer/innen löschen';
$string['user:editmessageprofile'] = 'Nutzer-Mitteilungsprofil bearbeiten';
$string['user:editownmessageprofile'] = 'Eigenes Mitteilungsprofil bearbeiten';
$string['user:editownprofile'] = 'Eigenes Nutzerprofil bearbeiten';
$string['user:editprofile'] = 'Nutzerprofile bearbeiten';
$string['user:loginas'] = 'Login als anderer Nutzer';
$string['user:manageblocks'] = 'Blöcke im Nutzerprofil anderer Nutzer/innen verwalten';
$string['user:manageownblocks'] = 'Blöcke im eigenen öffentlichen Nutzerprofil verwalten';
$string['user:manageownfiles'] = 'Dateien im Bereich \'Eigene Dateien\' verwalten';
$string['user:managesyspages'] = 'Standardlayout für die öffentlichen Nutzerprofile konfigurieren';
$string['user:readuserblogs'] = 'Alle Nutzerblogs sehen';
$string['user:readuserposts'] = 'Alle Nutzerbeiträge sehen';
$string['usersfrom'] = 'Nutzer/innen von {$a}';
$string['usersfrommatching'] = 'Nutzer/innen im Kontext {$a->contextname} passen zur Suche \'{$a->search}\'';
$string['usersinthisx'] = 'Nutzer/innen in diesem {$a}';
$string['usersinthisxmatching'] = 'Nutzer/innen in diesem {$a->contexttype} passen zur Suche \'{$a->search}\'.';
$string['userswithrole'] = 'Alle Nutzer/innen mit Rollenzuweisung';
$string['userswiththisrole'] = 'Nutzer/innen mit Rollenzuweisung';
$string['user:update'] = 'Nutzerprofile aktualisieren';
$string['user:viewalldetails'] = 'Alle Nutzerinformationen sehen';
$string['user:viewdetails'] = 'Nutzerprofile sehen';
$string['user:viewhiddendetails'] = 'Verborgene Nutzerdetails sehen';
$string['user:viewuseractivitiesreport'] = 'Nutzerberichte sehen';
$string['user:viewusergrades'] = 'Nutzerbewertungen sehen';
$string['useshowadvancedtochange'] = '\'Optionale Felder anzeigen\', <br />um Änderungen duchzuführen';
$string['viewingdefinitionofrolex'] = 'Definition der Rolle \'{$a}\' anzeigen';
$string['viewrole'] = 'Rollendetails sehen';
$string['webservice:createtoken'] = 'Webservice-Token erzeugen';
$string['whydoesuserhavecap'] = 'Warum besitzt {$a->fullname} die Fähigkeit {$a->capability} im Kontext {$a->context}?';
$string['whydoesusernothavecap'] = 'Warum besitzt {$a->fullname} keine Fähigkeit {$a->capability} im Kontext {$a->context}?';
$string['xroleassignments'] = 'Rollenzuweisungen von \'{$a}\'';
$string['xuserswiththerole'] = 'Nutzer/innen mit der Rolle \'{$a->role}\'';
