<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'de', branch 'MOODLE_20_STABLE'
 *
 * @package   data
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aktion';
$string['add'] = 'Eintrag hinzufügen';
$string['addcomment'] = 'Kommentar hinzufügen';
$string['addentries'] = 'Einträge hinzufügen';
$string['addtemplate'] = 'Vorlage für neue Einträge';
$string['advancedsearch'] = 'Erweiterte Suche';
$string['alttext'] = 'Alternativer Text';
$string['approve'] = 'Zulassen';
$string['approved'] = 'Bestätigt';
$string['ascending'] = 'Aufsteigend';
$string['asearchtemplate'] = 'Vorlage zur erweiterten Suche';
$string['atmaxentry'] = 'Sie haben die Höchstzahl zulässiger Einträge erreicht!';
$string['authorfirstname'] = 'Vorname (Autor)';
$string['authorlastname'] = 'Nachname (Autor)';
$string['autogenallforms'] = 'Alle Basisvorlagen anlegen';
$string['autolinkurl'] = 'URL automatisch verlinken';
$string['availablefromdate'] = 'Verfügbar ab';
$string['availabletags'] = 'Verfügbare Elemente';
$string['availabletags_help'] = 'Elemente sind Platzhalter in einer Vorlage, die durch Textfelder oder Knöpfe (z.B. das Icon zum Bearbeiten) ersetzt werden, um Einträge in der Datenbank zu ändern oder anzuzeigen.

Nutzerdefinierte Felder haben das Format [[feldname]]. Alle anderen Elemente (Tags) haben das Format ##tag##.

Nur Elemente aus der Liste "Verfügbare Elemente"  können in der Vorlage verwendet werden.
';
$string['availabletodate'] = 'Verfügbar bis';
$string['blank'] = 'Leer';
$string['buttons'] = 'Aktionen';
$string['bynameondate'] = 'von {$a->name} - {$a->date}';
$string['cancel'] = 'Abbrechen';
$string['cannotaccesspresentsother'] = 'Sie können nicht auf fremde Nutzervorlagen zugreifen';
$string['cannotadd'] = 'Kann keine Einträge hinzufügen!';
$string['cannotdeletepreset'] = 'Fehler beim Löschen der Vorlage';
$string['cannotunziptopreset'] = 'Fehler beim Entpacken im Vorlagenverzeichnis';
$string['checkbox'] = 'Mehrfachauswahl';
$string['chooseexportfields'] = 'Felder für Export auswählen:';
$string['chooseexportformat'] = 'Exportformat auswählen:';
$string['chooseorupload'] = 'Datei wählen';
$string['columns'] = 'Spalten';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentar gelöscht';
$string['commentempty'] = 'Kommentar war leer';
$string['comments'] = 'Kommentare';
$string['commentsaved'] = 'Kommentare gespeichert';
$string['commentsn'] = '{$a} Kommentare';
$string['commentsoff'] = 'Kommentare sind nicht aktiviert';
$string['configenablerssfeeds'] = 'Mit dieser Funktion aktivieren Sie RSS-Feeds für alle Datenbanken. Nach der Aktivierung an dieser Stelle ist zusätzlich die Aktivierung in jeder einzelnen Datenbank innerhalb der Kursräume erforderlich.';
$string['confirmdeletefield'] = 'Wollen Sie dieses Feld wirklich aus der Datenbank löschen?';
$string['confirmdeleterecord'] = 'Wollen Sie diesen Datensatz wirklich aus der Datenbank löschen?';
$string['csstemplate'] = 'CSS für Vorlagen';
$string['csvfailed'] = 'Aus der CSV-Datei konnten keine Daten gelesen werden';
$string['csvfile'] = 'CSV-Datei';
$string['csvimport'] = 'CSV-Dateiimport';
$string['csvimport_help'] = 'Daten können über eine Text-Datei importiert werden, wobei die erste Zeile eine Liste von Feldnamen enthalten muss, gefolgt von den Daten mit jeweils einem Datensatz pro Zeile.';
$string['csvwithselecteddelimiter'] = '<acronym title="Komma getrennte Werte">CSV</acronym> mit diesem Trennzeichen:';
$string['data:approve'] = 'Einträge freigeben';
$string['data:comment'] = 'Kommentare schreiben';
$string['data:exportallentries'] = 'Alle Datenbankeinträge exportieren';
$string['data:exportentry'] = 'Datenbankeintrag exportieren';
$string['data:exportownentry'] = 'Eigenen Datenbankeintrag exportieren';
$string['data:managecomments'] = 'Kommentare verwalten';
$string['data:manageentries'] = 'Einträge verwalten';
$string['data:managetemplates'] = 'Vorlagen verwalten';
$string['data:manageuserpresets'] = 'Vorlagensätze verwalten';
$string['data:rate'] = 'Einträge bewerten';
$string['data:readentry'] = 'Einträge lesen';
$string['data:viewallratings'] = 'Alle Einzelwertungen sehen';
$string['data:viewalluserpresets'] = 'Alle Vorlagensätze sehen';
$string['data:viewanyrating'] = 'Alle Gesamtwertungen sehen';
$string['data:viewentry'] = 'Einträge sehen';
$string['data:viewrating'] = 'Eigene Gesamtwertung sehen';
$string['data:writeentry'] = 'Einträge schreiben';
$string['date'] = 'Datum';
$string['dateentered'] = 'Datum eingetragen';
$string['defaultfielddelimiter'] = '(Vorgabe: Komma)';
$string['defaultfieldenclosure'] = '(Vorgabe: kein Zeichen)';
$string['defaultsortfield'] = 'Standard-Sortierfeld';
$string['delete'] = 'Löschen';
$string['deleteallentries'] = 'Alle Einträge löschen';
$string['deletecomment'] = 'Sind Sie sicher, dass Sie diesen Kommentar löschen wollen?';
$string['deleted'] = 'gelöscht';
$string['deletefield'] = 'Bestehendes Feld löschen';
$string['deletenotenrolled'] = 'Einträge von abgemeldeten Nutzer/innen löschen';
$string['deletewarning'] = 'Sind Sie sicher, dass Sie diesen Vorlagensatz löschen möchten?';
$string['descending'] = 'Absteigend';
$string['directorynotapreset'] = '{$a->directory} ist kein Vorlagensatz. Fehlende Dateien: {$a->missing_files}';
$string['download'] = 'Herunterladen';
$string['edit'] = 'Bearbeiten';
$string['editcomment'] = 'Kommentar bearbeiten';
$string['editentry'] = 'Eintrag bearbeiten';
$string['editordisable'] = 'Editor ausschalten';
$string['editorenable'] = 'Editor einschalten';
$string['emptyadd'] = 'Eine Vorlage für das Eintragen neuer Daten ist noch nicht vorhanden. Es wird ein Basisformular erstellt...';
$string['emptyaddform'] = 'Sie haben keine Einträge vorgenommen!';
$string['entries'] = 'Einträge';
$string['entrieslefttoadd'] = 'Sie müssen {$a->entriesleft} (weitere) Einträge vornehmen, um diese Aktivität zu beenden.';
$string['entrieslefttoaddtoview'] = 'Sie müssen {$a->entrieslefttoview} (weitere) Einträge vornehmen, bevor du andere Teilnehmerbeiträge anschauen darfst.';
$string['entry'] = 'Eintrag';
$string['entrysaved'] = 'Ihr Eintrag wurde gespeichert';
$string['errormustbeteacher'] = 'Diese Seite dürfen nur Trainer/innen benutzen!';
$string['errorpresetexists'] = 'Es gibt bereits eine Vorlage mit dem gewählten Namen';
$string['example'] = 'Datenbankbeispiel';
$string['excel'] = 'Excel';
$string['expired'] = 'Diese Aktivität wurde am {$a} abgeschlossen und ist nicht weiter verfügbar';
$string['export'] = 'Export';
$string['exportaszip'] = 'Export als ZIP-Datei';
$string['exportaszip_help'] = 'Mit dem Export als ZIP-Datei können Sie den Vorlagensatz auf Ihren Computer herunterladen, um ihn später als "Import aus einer ZIP-Datei" in einem anderen Kurs hochzuladen und zu nutzen.';
$string['exportedtozip'] = 'In eine temporäre ZIP-Datei exportiert....';
$string['exportentries'] = 'Einträge exportieren';
$string['exportownentries'] = 'Nur eigene Einträge exportieren? ({$a->mine}/{$a->all})';
$string['failedpresetdelete'] = 'Fehler beim Löschen eines Vorlagensatzes';
$string['fieldadded'] = 'Feld hinzugefügt';
$string['fieldallowautolink'] = 'Autolink erlauben';
$string['fielddeleted'] = 'Feld gelöscht';
$string['fielddelimiter'] = 'Feldtrennzeichen';
$string['fielddescription'] = 'Feldbeschreibung';
$string['fieldenclosure'] = 'Feldbegrenzung';
$string['fieldheight'] = 'Höhe';
$string['fieldheightlistview'] = 'Höhe in Listenansicht';
$string['fieldheightsingleview'] = 'Höhe in Einzelansicht';
$string['fieldids'] = 'Feldnummern';
$string['fieldmappings'] = 'Feldübersicht';
$string['fieldmappings_help'] = '<p>Dieses Menü ermöglicht es Ihnen, die Daten aus der bestehenden Datenbank zu erhalten, wenn Sie die Datenbank neu anlegen. Um die Daten zu behalten, die in einem Feld gesammelt sind, müssen Sie das Feld in ein neues Feld übertragen ("mappen"), in dem die Daten dann erscheinen. Felder können dabei auch leer gelassen werden. Jedes alte Feld, das nicht in ein neues übertragen wird, geht verloren und alle Daten darin sind unwiederbringlich weg.</p>

<p>Sie können nur Felder desselben Typs übertragen. Deshalb enthält das Klappmenü jedes Mal andere Felder zur Auswahl. Versuchen Sie bitte auch nicht, ein altes Feld in mehr als ein neues Feld zu übertragen.</p>';
$string['fieldname'] = 'Feldname';
$string['fieldnotmatched'] = 'Die folgenden Felder in Ihrer Datei sind in der Datenbank unbekannt: {$a}';
$string['fieldoptions'] = 'Optionen (eine pro Zeile)';
$string['fields'] = 'Felder';
$string['fieldupdated'] = 'Feld wurde aktualisiert';
$string['fieldwidth'] = 'Breite';
$string['fieldwidthlistview'] = 'Breite in Listenansicht';
$string['fieldwidthsingleview'] = 'Breite in Einzelansicht';
$string['file'] = 'Datei';
$string['filesnotgenerated'] = 'Es wurden nicht alle Dateien erzeugt: {$a}';
$string['filtername'] = 'Automatische Verlinkung zur Datenbank';
$string['footer'] = 'Fußzeile';
$string['forcelinkname'] = 'Namenseintrag  für den Link erzwingen';
$string['foundnorecords'] = 'Keine Einträge gefunden (<a href="{$a->reseturl}">Filter zurücksetzen</a>)';
$string['foundrecords'] = 'Einträge gefunden: {$a->num}/{$a->max} (<a href="{$a->reseturl}">Filter zurücksetzen</a>)';
$string['fromfile'] = 'Import aus ZIP-Datei';
$string['fromfile_help'] = 'Mit dem Import aus einer ZIP-Datei können Sie Vorlagensätze hochladen, die Vorlagen und Felder enthalten.';
$string['generateerror'] = 'Mehrere Dateien wurden nicht angelegt!';
$string['header'] = 'Kopfzeile';
$string['headeraddtemplate'] = 'Definiert Formular zum Anlegen neuer Einträge';
$string['headerasearchtemplate'] = 'Definiert das Interface zur erweiterten Suche';
$string['headercsstemplate'] = 'Definiert lokale CSS-Styles für die anderen Vorlagen';
$string['headerjstemplate'] = 'Definiert allgemeines JavaScript für die anderen Vorlagen';
$string['headerlisttemplate'] = 'Definiert Übersichtsansicht für mehrere Einträge';
$string['headerrsstemplate'] = 'Definiert Darstellung der Einträge in RSS-Feeds';
$string['headersingletemplate'] = 'Definiert Darstellung für die Einzelansicht';
$string['importentries'] = 'Einträge importieren';
$string['importsuccess'] = 'Die Vorlagensatz wurde erfolgreich übernommen.';
$string['insufficiententries'] = 'Weitere Einträge sind erforderlich, um die Datenbank einzusehen.';
$string['intro'] = 'Beschreibung';
$string['invalidaccess'] = 'Seite wurde nicht richtig aufgerufen';
$string['invalidfieldid'] = 'Feld-ID ist falsch';
$string['invalidfieldname'] = 'Wählen Sie bitte einen anderen Namen für dieses Feld.';
$string['invalidfieldtype'] = 'Ungültiger Feldtyp
';
$string['invalidid'] = 'Falsche Daten-ID';
$string['invalidpreset'] = '{$a} ist kein Vorlagensatz.';
$string['invalidrecord'] = 'Falscher Eintrag';
$string['invalidurl'] = 'Die eingegebene URL ist nicht gültig.';
$string['jstemplate'] = 'Javascript für Vorlagen';
$string['latitude'] = 'Breitengrad';
$string['latlong'] = 'Geografische Breite und Länge';
$string['latlongdownloadallhint'] = 'Download aller Einträge als KML';
$string['latlongkmllabelling'] = 'Wie sollen Ziele in KML-Dateien bezeichnet werden? (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Links zum Anzeigen geografischer Daten';
$string['latlongotherfields'] = 'Weitere Felder';
$string['list'] = 'Listenansicht';
$string['listtemplate'] = 'Vorlage für Liste';
$string['longitude'] = 'Längengrad';
$string['mapexistingfield'] = 'Verknüpfen mit {$a}';
$string['mapnewfield'] = 'Neues Feld anlegen';
$string['mappingwarning'] = 'Alle alten Felder, die keinem neuen Feld zugeordnet wurden, werden zusammen mit allen Daten aus diesen Feldern gelöscht.';
$string['maxentries'] = 'Maximale Einträge';
$string['maxentries_help'] = 'Die maximale Zahl der Einträge begrenzt die Einträge, die ein/e Teilnehmer/in bei dieser Aktivität vornehmen darf.';
$string['maxsize'] = 'Größe (max)';
$string['menu'] = 'Menü';
$string['menuchoose'] = 'Auswählen ...';
$string['missingdata'] = 'Daten-ID bzw. Datenobjekt müssen zur Feldklasse passen';
$string['missingfield'] = 'Programmierfehler: Sie müssen Feld und Daten angeben, wenn Sie eine Feldklasse definieren.';
$string['modulename'] = 'Datenbank';
$string['modulename_help'] = 'Die Aktivität \'Datenbank\' erlaubt es, dass Teilnehmer/innen Datensätzen anlegen, verwalten und darin suchen. Format und Struktur der Einträge sind weitgehend unbegrenzt. In der Datenbank können Texte, Zahlen, Bilder, Dateien, URLs usw. verwendet werden.';
$string['modulenameplural'] = 'Datenbanken';
$string['more'] = 'Einzelansicht';
$string['moreurl'] = 'Weitere URL';
$string['movezipfailed'] = 'Kann ZIP nicht bewegen';
$string['multientry'] = 'Wiederholter Eintrag';
$string['multimenu'] = 'Menü (Mehrfachauswahl)';
$string['multipletags'] = 'Elemente mehrfach gefunden! Keine Vorlage gespeichert.';
$string['namecheckbox'] = 'Feld für Mehrfachauswahl (Checkboxen)';
$string['namedate'] = 'Datumsfeld';
$string['namefile'] = 'Dateifeld';
$string['namelatlong'] = 'Feld für Längen- und Breitengrad';
$string['namemenu'] = 'Feld für einfaches Menü';
$string['namemultimenu'] = 'Feld für Menü mit Mehrfachauswahl';
$string['namenumber'] = 'Zahlenfeld';
$string['namepicture'] = 'Bildfeld';
$string['nameradiobutton'] = 'Einfachauswahl (Radiobutton)';
$string['nametext'] = 'Textzeilenfeld';
$string['nametextarea'] = 'Textbereichsfeld';
$string['nameurl'] = 'URL-Feld';
$string['newentry'] = 'Neuer Eintrag';
$string['newfield'] = 'Neues Feld erstellen';
$string['newfield_help'] = 'Auf dieser Seite können Sie die Felder anlegen, die Teil der Datenbank sein sollen. Für jedes Feld können unterschiedliche Datentypen festgelegt werden, zu denen jeweils unterschiedliche Formulare für datenspezifische Angaben gehören.

Jedes Feld muss einen eindeutigen Feldnamen bekommen, die Feldbeschreibung ist optional.';
$string['noaccess'] = 'Sie haben keinen Zugriff auf diese Seite.';
$string['nodefinedfields'] = 'Neuer Vorlagensatz besitzt keine definierten Felder!';
$string['nofieldcontent'] = 'Feldinhalt nicht gefunden';
$string['nofieldindatabase'] = 'In dieser Datenbank sind noch keine Felder definiert';
$string['nolisttemplate'] = 'Die Listenansicht wurde noch nicht definiert';
$string['nomatch'] = 'Keine passenden Einträge gefunden';
$string['nomaximum'] = 'Keine Höchstzahl';
$string['norecords'] = 'Keine Einträge in der Datenbank';
$string['nosingletemplate'] = 'Einzelansicht wurde noch nicht definiert';
$string['notapproved'] = 'Der Eintrag wurde bisher nicht freigegeben';
$string['notinjectivemap'] = 'Keine injektive Abbildung';
$string['notopenyet'] = 'Aktivität ist nicht verfügbar bis {$a}';
$string['number'] = 'Zahl';
$string['numberrssarticles'] = 'RSS-Beiträge';
$string['numnotapproved'] = 'Wartend';
$string['numrecords'] = '{$a} Datensätze';
$string['ods'] = '<acronym title="OpenDocument Spreadsheet">ODS</acronym> (OpenOffice)';
$string['optionaldescription'] = 'Beschreibung (optional)';
$string['optionalfilename'] = 'Dateiname (optional)';
$string['other'] = 'Andere';
$string['overrwritedesc'] = 'Vorlage überschreiben, falls sie bereits existiert';
$string['overwrite'] = 'Überschreiben';
$string['overwritesettings'] = 'Bisherige Einträge überschreiben';
$string['pagesize'] = 'Einträge pro Seite';
$string['participants'] = 'Teilnehmer/innen';
$string['picture'] = 'Bild';
$string['pleaseaddsome'] = 'Bitte erzeugen Sie ein Feld oder <a href="{$a}">wählen Sie einen Vorlagensatz</a>, um zu beginnen';
$string['pluginadministration'] = 'Datenbank-Administration';
$string['pluginname'] = 'Datenbank';
$string['portfolionotfile'] = 'In ein Portfolio und nicht als Datei exportieren (nur csv und leap2a)';
$string['presetinfo'] = 'Durch das Sichern als Vorlagensatz wird Ihre Datenbank-Gestaltung für die gesamte Moodle-Installation veröffentlicht. Andere Nutzer/innen können dann diesen Vorlagensatz für ihre Datenbank nutzen.';
$string['presets'] = 'Vorlagensätze';
$string['radiobutton'] = 'Einfachauswahl';
$string['recordapproved'] = 'Datensatz wurde angenommen';
$string['recorddeleted'] = 'Datensatz gelöscht';
$string['recordsnotsaved'] = 'Kein Datensatz wurde gespeichert. Prüfen Sie bitte das Format der hochgeladenen Datei.';
$string['recordssaved'] = 'Datensätze gespeichert';
$string['requireapproval'] = 'Freigabe erforderlich?';
$string['requireapproval_help'] = 'Wenn diese Option aktiviert ist, müssen die Einträge von Trainer/innen erst bestätigt werden, bevor sie für alle anderen angezeigt werden?';
$string['requiredentries'] = 'Erforderliche Einträge';
$string['requiredentries_help'] = 'Die erforderliche Zahl der Einträge gibt die Zahl der eigenen Einträge an, die Teilnehmer/innen liefern müssen, bevor die Aktivität als unvollständig bearbeitet gewertet wird.';
$string['requiredentriestoview'] = 'Erforderliche Einträge vor der Ansicht aller Daten';
$string['requiredentriestoview_help'] = 'Die erforderliche Zahl der Einträge gibt die Zahl der eigenen Einträge an, die Teilnehmer/innen liefern müssen, bevor sie Einträge anderer Teilnehmer/innen einsehen dürfen.

Hinweis: Falls Einträge vor der Ansicht notwendig sind, sollte die Autoverlinkung für die Datenbank deaktiviert sein. Die Autoverlinkung kann nämlich nicht entscheiden, ob jemand die erforderliche Anzahl von Einträgen bereits geliefert hat.';
$string['resetsettings'] = 'Filter zurücksetzen';
$string['resettemplate'] = 'Vorlage zurücksetzen';
$string['resizingimages'] = 'Vorschaubilder anpassen...';
$string['rows'] = 'Zeilen';
$string['rssglobaldisabled'] = 'Deaktiviert. Beachten Sie die Einstellungsseite für die Variablen.';
$string['rsshowmany'] = '(Zahl der neuen Einträge, die angezeigt werden sollen, 0 deaktiviert RSS)';
$string['rsstemplate'] = 'Vorlage für RSS-Feed';
$string['rsstitletemplate'] = 'Vorlage für RSS-Titelzeile';
$string['save'] = 'Speichern';
$string['saveandadd'] = 'Speichern und weitere hinzufügen';
$string['saveandview'] = 'Speichern und anzeigen';
$string['saveaspreset'] = 'Als Vorlagensatz speichern';
$string['saveaspreset_help'] = 'Die Option \'Als Vorlagensatz speichern\' veröffentlicht die Vorlagen und Felder als Vorlagensatz in einer Liste. Andere auf der Website können Ihren Vorlagensatz benutzen, wobei Sie jederzeit den Vorlagensatz wieder entfernen dürfen.';
$string['savesettings'] = 'Einstellungen speichern';
$string['savesuccess'] = 'Erfolgreich gespeichert. Ihr Vorlagensatz wird ab sofort überall in diesem Moodle nutzbar sein.';
$string['savetemplate'] = 'Vorlage speichern';
$string['search'] = 'Suche';
$string['selectedrequired'] = 'Gesamte Auswahl ist erforderlich';
$string['showall'] = 'Alle Einträge anzeigen';
$string['single'] = 'Einzelansicht';
$string['singletemplate'] = 'Vorlage für Einzelansicht';
$string['teachersandstudents'] = '{$a->teachers} und {$a->students}';
$string['templates'] = 'Vorlagen';
$string['templatesaved'] = 'Vorlage wurde gespeichert';
$string['text'] = 'Text';
$string['textarea'] = 'Textbereich';
$string['timeadded'] = 'Zeit erstellt';
$string['timemodified'] = 'Zeit geändert';
$string['todatabase'] = 'in diese Datenbank';
$string['type'] = 'Feld-Typ';
$string['undefinedprocessactionmethod'] = 'In Data_Preset wurde keine Verarbeitungsmethode definiert für: "{$a}".';
$string['unsupportedexport'] = '({$a->fieldtype}) kann nicht exportiert werden';
$string['updatefield'] = 'Bestehendes Feld aktualisieren';
$string['uploadfile'] = 'Datei hochladen';
$string['uploadrecords'] = 'Datensätze als Datei hochladen';
$string['uploadrecords_help'] = 'Einträge können als Textdatei hochgeladen werden, wobei das Dateiformat folgendermaßen strukturiert sein muss:

* Jede Zeile der Datei beinhaltet einen neuen Datensatz
* Jeder Datensatz besteht aus einer Reihe von Daten, die durch Kommas (oder andere Trennzeichen) getrennt sind
* Der erste Datensatz enthält eine Liste von Feldnamen, die das Format der restlichen Datei festlegen

Die Feldbegrenzung ist ein Zeichen, dass jedes Feld im jedem Datensatz zusätzlich abgrenzt. Normalerweise ist es nicht gesetzt.';
$string['url'] = 'URL';
$string['usestandard'] = 'Vorlagensatz benutzen';
$string['usestandard_help'] = 'Um einen auf der gesamten Website verfügbaren Vorlagensatz zu benutzen, wählen Sie ihn aus der Liste aus. Wenn Sie selbst einen Vorlagensatz zur Liste hinzugefügt haben, können Sie ihn hier auch wieder löschen.';
$string['viewfromdate'] = 'Nur Anzeige ab';
$string['viewtodate'] = 'Nur Anzeige bis';
$string['wrongdataid'] = 'Falsche Daten-ID bereitgestellt';
