
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_mood2010`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignment`
--

CREATE TABLE `[[dbprefix]]assignment` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `assignmenttype` varchar(50) NOT NULL DEFAULT '',
  `resubmit` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `preventlate` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `emailteachers` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `var1` bigint(10) DEFAULT '0',
  `var2` bigint(10) DEFAULT '0',
  `var3` bigint(10) DEFAULT '0',
  `var4` bigint(10) DEFAULT '0',
  `var5` bigint(10) DEFAULT '0',
  `maxbytes` bigint(10) unsigned NOT NULL DEFAULT '100000',
  `timedue` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeavailable` bigint(10) unsigned NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignment_submissions`
--

CREATE TABLE `[[dbprefix]]assignment_submissions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `numfiles` bigint(10) unsigned NOT NULL DEFAULT '0',
  `data1` text,
  `data2` text,
  `grade` bigint(11) NOT NULL DEFAULT '0',
  `submissioncomment` text NOT NULL,
  `format` smallint(4) unsigned NOT NULL DEFAULT '0',
  `teacher` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemarked` bigint(10) unsigned NOT NULL DEFAULT '0',
  `mailed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assisubm_use_ix` (`userid`),
  KEY `[[dbprefix]]assisubm_mai_ix` (`mailed`),
  KEY `[[dbprefix]]assisubm_tim_ix` (`timemarked`),
  KEY `[[dbprefix]]assisubm_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Info about submitted assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_controllers`
--

CREATE TABLE `[[dbprefix]]backup_controllers` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) NOT NULL DEFAULT '',
  `operation` varchar(20) NOT NULL DEFAULT 'backup',
  `type` varchar(10) NOT NULL DEFAULT '',
  `itemid` bigint(10) unsigned NOT NULL,
  `format` varchar(20) NOT NULL DEFAULT '',
  `interactive` smallint(4) unsigned NOT NULL,
  `purpose` smallint(4) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `status` smallint(4) unsigned NOT NULL,
  `execution` smallint(4) unsigned NOT NULL,
  `executiontime` bigint(10) unsigned NOT NULL,
  `checksum` varchar(32) NOT NULL DEFAULT '',
  `timecreated` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  `controller` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backcont_bac_uix` (`backupid`),
  KEY `[[dbprefix]]backcont_typite_ix` (`type`,`itemid`),
  KEY `[[dbprefix]]backcont_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store the backup_controllers as they are used' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_courses`
--

CREATE TABLE `[[dbprefix]]backup_courses` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `laststarttime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lastendtime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `laststatus` varchar(1) NOT NULL DEFAULT '0',
  `nextstarttime` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store every course backup status' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_files`
--

CREATE TABLE `[[dbprefix]]backup_files` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `backup_code` bigint(10) unsigned NOT NULL DEFAULT '0',
  `file_type` varchar(10) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `old_id` bigint(10) unsigned NOT NULL DEFAULT '0',
  `new_id` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backfile_bacfilpat_uix` (`backup_code`,`file_type`,`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store and recode ids to user and course files' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_files_template`
--

CREATE TABLE `[[dbprefix]]backup_files_template` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) NOT NULL DEFAULT '',
  `contextid` bigint(10) unsigned NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `filearea` varchar(50) NOT NULL DEFAULT '',
  `itemid` bigint(10) unsigned NOT NULL,
  `info` mediumtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]backfiletemp_bacconco_ix` (`backupid`,`contextid`,`component`,`filearea`,`itemid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store files along the backup process. Note this table isn' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_ids`
--

CREATE TABLE `[[dbprefix]]backup_ids` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `backup_code` bigint(12) unsigned NOT NULL DEFAULT '0',
  `table_name` varchar(30) NOT NULL DEFAULT '',
  `old_id` bigint(10) unsigned NOT NULL DEFAULT '0',
  `new_id` bigint(10) unsigned NOT NULL DEFAULT '0',
  `info` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backids_bactabold_uix` (`backup_code`,`table_name`,`old_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store and convert ids in backup/restore' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_ids_template`
--

CREATE TABLE `[[dbprefix]]backup_ids_template` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) NOT NULL DEFAULT '',
  `itemname` varchar(160) NOT NULL DEFAULT '',
  `itemid` bigint(10) unsigned NOT NULL,
  `newitemid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `parentitemid` bigint(10) unsigned DEFAULT NULL,
  `info` mediumtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backidstemp_baciteit_uix` (`backupid`,`itemname`,`itemid`),
  KEY `[[dbprefix]]backidstemp_bacitepar_ix` (`backupid`,`itemname`,`parentitemid`),
  KEY `[[dbprefix]]backidstemp_bacitenew_ix` (`backupid`,`itemname`,`newitemid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store all sort of ids along the backup process. Note this' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_log`
--

CREATE TABLE `[[dbprefix]]backup_log` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `time` bigint(10) unsigned NOT NULL DEFAULT '0',
  `laststarttime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `info` varchar(255) NOT NULL DEFAULT '',
  `backuptype` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]backlog_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store every course backup log info' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_logs`
--

CREATE TABLE `[[dbprefix]]backup_logs` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) NOT NULL DEFAULT '',
  `loglevel` smallint(4) unsigned NOT NULL,
  `message` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backlogs_bacid_uix` (`backupid`,`id`),
  KEY `[[dbprefix]]backlogs_bac_ix` (`backupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store all the logs from backup and restore operations (by' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block`
--

CREATE TABLE `[[dbprefix]]block` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `version` bigint(10) unsigned NOT NULL DEFAULT '0',
  `cron` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lastcron` bigint(10) unsigned NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]bloc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='contains all installed blocks' AUTO_INCREMENT=40 ;

--
-- Dumping data for table `[[dbprefix]]block`
--

INSERT INTO `[[dbprefix]]block` VALUES
(1, 'activity_modules', 2007101509, 0, 0, 1),
(2, 'admin_bookmarks', 2007101509, 0, 0, 1),
(3, 'blog_menu', 2009071700, 0, 0, 1),
(4, 'blog_recent', 2009070900, 0, 0, 1),
(5, 'blog_tags', 2007101509, 0, 0, 1),
(6, 'calendar_month', 2007101509, 0, 0, 1),
(7, 'calendar_upcoming', 2007101509, 0, 0, 1),
(8, 'comments', 2009072000, 0, 0, 1),
(9, 'community', 2010042701, 0, 0, 1),
(10, 'completionstatus', 2009072800, 0, 0, 1),
(11, 'course_list', 2007101509, 0, 0, 1),
(12, 'course_overview', 2010021100, 0, 0, 1),
(13, 'course_summary', 2007101509, 0, 0, 1),
(14, 'feedback', 2010050200, 0, 0, 0),
(15, 'glossary_random', 2007101509, 0, 0, 1),
(16, 'html', 2010071900, 0, 0, 1),
(17, 'login', 2007101509, 0, 0, 1),
(18, 'mentees', 2007101509, 0, 0, 1),
(19, 'messages', 2007101509, 0, 0, 1),
(20, 'mnet_hosts', 2010112900, 0, 0, 1),
(21, 'myprofile', 2009123100, 0, 0, 1),
(22, 'navigation', 2010091400, 0, 0, 1),
(23, 'news_items', 2007101509, 0, 0, 1),
(24, 'online_users', 2007101510, 0, 0, 1),
(25, 'participants', 2007101509, 0, 0, 1),
(26, 'private_files', 2010030100, 0, 0, 1),
(27, 'quiz_results', 2007101509, 0, 0, 1),
(28, 'recent_activity', 2007101509, 0, 0, 1),
(29, 'rss_client', 2009072901, 300, 0, 1),
(30, 'search', 2010111100, 1, 0, 0),
(31, 'search_forums', 2007101509, 0, 0, 1),
(32, 'section_links', 2007101511, 0, 0, 1),
(33, 'selfcompletion', 2009072800, 0, 0, 1),
(34, 'settings', 2010091400, 0, 0, 1),
(35, 'site_main_menu', 2007101509, 0, 0, 1),
(36, 'social_activities', 2007101509, 0, 0, 1),
(37, 'tag_flickr', 2007101509, 0, 0, 1),
(38, 'tag_youtube', 2007101509, 0, 0, 1),
(39, 'tags', 2010090502, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_community`
--

CREATE TABLE `[[dbprefix]]block_community` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL,
  `coursename` varchar(255) NOT NULL DEFAULT '',
  `coursedescription` longtext,
  `courseurl` varchar(255) NOT NULL DEFAULT '',
  `imageurl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Community block' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_instances`
--

CREATE TABLE `[[dbprefix]]block_instances` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `blockname` varchar(40) NOT NULL DEFAULT '',
  `parentcontextid` bigint(10) unsigned NOT NULL,
  `showinsubcontexts` smallint(4) NOT NULL,
  `pagetypepattern` varchar(64) NOT NULL DEFAULT '',
  `subpagepattern` varchar(16) DEFAULT NULL,
  `defaultregion` varchar(16) NOT NULL DEFAULT '',
  `defaultweight` bigint(10) NOT NULL,
  `configdata` text,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocinst_parshopagsub_ix` (`parentcontextid`,`showinsubcontexts`,`pagetypepattern`,`subpagepattern`),
  KEY `[[dbprefix]]blocinst_par_ix` (`parentcontextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='This table stores block instances. The type of block this is' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]block_instances`
--

INSERT INTO `[[dbprefix]]block_instances` VALUES
(1, 'site_main_menu', 2, 0, 'site-index', NULL, 'side-pre', 0, ''),
(2, 'course_summary', 2, 0, 'site-index', NULL, 'side-post', 0, ''),
(3, 'calendar_month', 2, 0, 'site-index', NULL, 'side-post', 1, ''),
(4, 'navigation', 1, 1, '*', NULL, 'side-pre', 0, ''),
(5, 'settings', 1, 1, '*', NULL, 'side-pre', 1, ''),
(6, 'admin_bookmarks', 1, 0, 'admin-*', NULL, 'side-pre', 0, ''),
(7, 'private_files', 1, 0, 'my-index', '2', 'side-post', 0, ''),
(8, 'online_users', 1, 0, 'my-index', '2', 'side-post', 1, ''),
(9, 'course_overview', 1, 0, 'my-index', '2', 'content', 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_instance_old`
--

CREATE TABLE `[[dbprefix]]block_instance_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `oldid` bigint(10) unsigned NOT NULL,
  `blockid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `pageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `pagetype` varchar(20) NOT NULL DEFAULT '',
  `position` varchar(10) NOT NULL DEFAULT '',
  `weight` smallint(3) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `configdata` text,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocinstold_pag_ix` (`pageid`),
  KEY `[[dbprefix]]blocinstold_pag2_ix` (`pagetype`),
  KEY `[[dbprefix]]blocinstold_blo_ix` (`blockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='backup of 1.9 block instances - to be deleted' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_pinned_old`
--

CREATE TABLE `[[dbprefix]]block_pinned_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `blockid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `pagetype` varchar(20) NOT NULL DEFAULT '',
  `position` varchar(10) NOT NULL DEFAULT '',
  `weight` smallint(3) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `configdata` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocpinnold_pag_ix` (`pagetype`),
  KEY `[[dbprefix]]blocpinnold_blo_ix` (`blockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='backup of 1.9 pinned blocks - to be deleted' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_positions`
--

CREATE TABLE `[[dbprefix]]block_positions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `blockinstanceid` bigint(10) unsigned NOT NULL,
  `contextid` bigint(10) unsigned NOT NULL,
  `pagetype` varchar(64) NOT NULL DEFAULT '',
  `subpage` varchar(16) NOT NULL DEFAULT '',
  `visible` smallint(4) NOT NULL,
  `region` varchar(16) NOT NULL DEFAULT '',
  `weight` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]blocposi_bloconpagsu_uix` (`blockinstanceid`,`contextid`,`pagetype`,`subpage`),
  KEY `[[dbprefix]]blocposi_blo_ix` (`blockinstanceid`),
  KEY `[[dbprefix]]blocposi_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the position of a sticky block_instance on a another ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_rss_client`
--

CREATE TABLE `[[dbprefix]]block_rss_client` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `title` text NOT NULL,
  `preferredtitle` varchar(64) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `shared` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Remote news feed information. Contains the news feed id, the' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_search_documents`
--

CREATE TABLE `[[dbprefix]]block_search_documents` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `docid` varchar(32) NOT NULL DEFAULT '',
  `doctype` varchar(32) NOT NULL DEFAULT 'none',
  `itemtype` varchar(32) NOT NULL DEFAULT 'standard',
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `docdate` bigint(10) unsigned NOT NULL DEFAULT '0',
  `updated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `groupid` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocseardocu_doc_ix` (`docid`),
  KEY `[[dbprefix]]blocseardocu_doc2_ix` (`doctype`),
  KEY `[[dbprefix]]blocseardocu_ite_ix` (`itemtype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='table to store search index backups' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_association`
--

CREATE TABLE `[[dbprefix]]blog_association` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) unsigned NOT NULL,
  `blogid` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blogasso_con_ix` (`contextid`),
  KEY `[[dbprefix]]blogasso_blo_ix` (`blogid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Associations of blog entries with courses and module instanc' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_external`
--

CREATE TABLE `[[dbprefix]]blog_external` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `url` text NOT NULL,
  `filtertags` varchar(255) DEFAULT NULL,
  `failedlastsync` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  `timefetched` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blogexte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='External blog links used for RSS copying of blog entries to ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_filters`
--

CREATE TABLE `[[dbprefix]]cache_filters` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) NOT NULL DEFAULT '',
  `version` bigint(10) unsigned NOT NULL DEFAULT '0',
  `md5key` varchar(32) NOT NULL DEFAULT '',
  `rawtext` text NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cachfilt_filmd5_ix` (`filter`,`md5key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='For keeping information about cached data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_flags`
--

CREATE TABLE `[[dbprefix]]cache_flags` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `flagtype` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `value` mediumtext NOT NULL,
  `expiry` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cachflag_fla_ix` (`flagtype`),
  KEY `[[dbprefix]]cachflag_nam_ix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Cache of time-sensitive flags' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]cache_flags`
--

INSERT INTO `[[dbprefix]]cache_flags` VALUES
(1, 'userpreferenceschanged', '2', [[timestamp]], '1', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_text`
--

CREATE TABLE `[[dbprefix]]cache_text` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `md5key` varchar(32) NOT NULL DEFAULT '',
  `formattedtext` longtext NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cachtext_md5_ix` (`md5key`),
  KEY `[[dbprefix]]cachtext_tim_ix` (`timemodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='For storing temporary copies of processed texts' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]capabilities`
--

CREATE TABLE `[[dbprefix]]capabilities` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `captype` varchar(50) NOT NULL DEFAULT '',
  `contextlevel` bigint(10) unsigned NOT NULL DEFAULT '0',
  `component` varchar(100) NOT NULL DEFAULT '',
  `riskbitmask` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]capa_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='this defines all capabilities' AUTO_INCREMENT=364 ;

--
-- Dumping data for table `[[dbprefix]]capabilities`
--

INSERT INTO `[[dbprefix]]capabilities` VALUES
(1, 'moodle/site:config', 'write', 10, 'moodle', 62),
(2, 'moodle/site:readallmessages', 'read', 10, 'moodle', 8),
(3, 'moodle/site:sendmessage', 'write', 10, 'moodle', 16),
(4, 'moodle/site:approvecourse', 'write', 10, 'moodle', 4),
(5, 'moodle/backup:backupcourse', 'write', 50, 'moodle', 28),
(6, 'moodle/backup:backupsection', 'write', 50, 'moodle', 28),
(7, 'moodle/backup:backupactivity', 'write', 70, 'moodle', 28),
(8, 'moodle/backup:backuptargethub', 'write', 50, 'moodle', 28),
(9, 'moodle/backup:backuptargetimport', 'write', 50, 'moodle', 28),
(10, 'moodle/backup:downloadfile', 'write', 50, 'moodle', 28),
(11, 'moodle/backup:configure', 'write', 50, 'moodle', 28),
(12, 'moodle/backup:userinfo', 'read', 50, 'moodle', 8),
(13, 'moodle/backup:anonymise', 'read', 50, 'moodle', 8),
(14, 'moodle/restore:restorecourse', 'write', 50, 'moodle', 28),
(15, 'moodle/restore:restoresection', 'write', 50, 'moodle', 28),
(16, 'moodle/restore:restoreactivity', 'write', 50, 'moodle', 28),
(17, 'moodle/restore:viewautomatedfilearea', 'write', 50, 'moodle', 28),
(18, 'moodle/restore:restoretargethub', 'write', 50, 'moodle', 28),
(19, 'moodle/restore:restoretargetimport', 'write', 50, 'moodle', 28),
(20, 'moodle/restore:uploadfile', 'write', 50, 'moodle', 28),
(21, 'moodle/restore:configure', 'write', 50, 'moodle', 28),
(22, 'moodle/restore:rolldates', 'write', 50, 'moodle', 0),
(23, 'moodle/restore:userinfo', 'write', 50, 'moodle', 30),
(24, 'moodle/restore:createuser', 'write', 10, 'moodle', 24),
(25, 'moodle/site:manageblocks', 'write', 80, 'moodle', 20),
(26, 'moodle/site:accessallgroups', 'read', 50, 'moodle', 0),
(27, 'moodle/site:viewfullnames', 'read', 50, 'moodle', 0),
(28, 'moodle/site:viewreports', 'read', 50, 'moodle', 8),
(29, 'moodle/site:trustcontent', 'write', 50, 'moodle', 4),
(30, 'moodle/site:uploadusers', 'write', 10, 'moodle', 24),
(31, 'moodle/filter:manage', 'write', 50, 'moodle', 0),
(32, 'moodle/user:create', 'write', 10, 'moodle', 24),
(33, 'moodle/user:delete', 'write', 10, 'moodle', 8),
(34, 'moodle/user:update', 'write', 10, 'moodle', 24),
(35, 'moodle/user:viewdetails', 'read', 50, 'moodle', 0),
(36, 'moodle/user:viewalldetails', 'read', 30, 'moodle', 8),
(37, 'moodle/user:viewhiddendetails', 'read', 50, 'moodle', 8),
(38, 'moodle/user:loginas', 'write', 50, 'moodle', 30),
(39, 'moodle/user:managesyspages', 'write', 10, 'moodle', 0),
(40, 'moodle/user:manageblocks', 'write', 30, 'moodle', 0),
(41, 'moodle/user:manageownblocks', 'write', 10, 'moodle', 0),
(42, 'moodle/user:manageownfiles', 'write', 10, 'moodle', 0),
(43, 'moodle/my:configsyspages', 'write', 10, 'moodle', 0),
(44, 'moodle/role:assign', 'write', 50, 'moodle', 28),
(45, 'moodle/role:review', 'read', 50, 'moodle', 8),
(46, 'moodle/role:override', 'write', 50, 'moodle', 28),
(47, 'moodle/role:safeoverride', 'write', 50, 'moodle', 16),
(48, 'moodle/role:manage', 'write', 10, 'moodle', 28),
(49, 'moodle/role:switchroles', 'read', 50, 'moodle', 12),
(50, 'moodle/category:manage', 'write', 40, 'moodle', 4),
(51, 'moodle/category:viewhiddencategories', 'read', 40, 'moodle', 0),
(52, 'moodle/cohort:manage', 'write', 40, 'moodle', 0),
(53, 'moodle/cohort:assign', 'write', 40, 'moodle', 0),
(54, 'moodle/cohort:view', 'read', 50, 'moodle', 0),
(55, 'moodle/course:create', 'write', 40, 'moodle', 4),
(56, 'moodle/course:request', 'write', 10, 'moodle', 0),
(57, 'moodle/course:delete', 'write', 50, 'moodle', 32),
(58, 'moodle/course:update', 'write', 50, 'moodle', 4),
(59, 'moodle/course:view', 'read', 50, 'moodle', 0),
(60, 'moodle/course:enrolreview', 'read', 50, 'moodle', 8),
(61, 'moodle/course:enrolconfig', 'write', 50, 'moodle', 8),
(62, 'moodle/course:bulkmessaging', 'write', 50, 'moodle', 16),
(63, 'moodle/course:viewhiddenuserfields', 'read', 50, 'moodle', 8),
(64, 'moodle/course:viewhiddencourses', 'read', 50, 'moodle', 0),
(65, 'moodle/course:visibility', 'write', 50, 'moodle', 0),
(66, 'moodle/course:managefiles', 'write', 50, 'moodle', 4),
(67, 'moodle/course:manageactivities', 'write', 50, 'moodle', 4),
(68, 'moodle/course:activityvisibility', 'write', 50, 'moodle', 0),
(69, 'moodle/course:viewhiddenactivities', 'write', 50, 'moodle', 0),
(70, 'moodle/course:viewparticipants', 'read', 50, 'moodle', 0),
(71, 'moodle/course:changefullname', 'write', 50, 'moodle', 4),
(72, 'moodle/course:changeshortname', 'write', 50, 'moodle', 4),
(73, 'moodle/course:changeidnumber', 'write', 50, 'moodle', 4),
(74, 'moodle/course:changecategory', 'write', 50, 'moodle', 4),
(75, 'moodle/course:changesummary', 'write', 50, 'moodle', 4),
(76, 'moodle/site:viewparticipants', 'read', 10, 'moodle', 0),
(77, 'moodle/course:viewscales', 'read', 50, 'moodle', 0),
(78, 'moodle/course:managescales', 'write', 50, 'moodle', 0),
(79, 'moodle/course:managegroups', 'write', 50, 'moodle', 0),
(80, 'moodle/course:reset', 'write', 50, 'moodle', 32),
(81, 'moodle/blog:view', 'read', 10, 'moodle', 0),
(82, 'moodle/blog:search', 'read', 10, 'moodle', 0),
(83, 'moodle/blog:viewdrafts', 'read', 10, 'moodle', 8),
(84, 'moodle/blog:create', 'write', 10, 'moodle', 16),
(85, 'moodle/blog:manageentries', 'write', 10, 'moodle', 16),
(86, 'moodle/blog:manageexternal', 'write', 10, 'moodle', 16),
(87, 'moodle/blog:associatecourse', 'write', 50, 'moodle', 0),
(88, 'moodle/blog:associatemodule', 'write', 70, 'moodle', 0),
(89, 'moodle/calendar:manageownentries', 'write', 50, 'moodle', 16),
(90, 'moodle/calendar:managegroupentries', 'write', 50, 'moodle', 16),
(91, 'moodle/calendar:manageentries', 'write', 50, 'moodle', 16),
(92, 'moodle/user:editprofile', 'write', 30, 'moodle', 24),
(93, 'moodle/user:editownprofile', 'write', 10, 'moodle', 16),
(94, 'moodle/user:changeownpassword', 'write', 10, 'moodle', 0),
(95, 'moodle/user:readuserposts', 'read', 30, 'moodle', 0),
(96, 'moodle/user:readuserblogs', 'read', 30, 'moodle', 0),
(97, 'moodle/user:viewuseractivitiesreport', 'read', 30, 'moodle', 8),
(98, 'moodle/user:editmessageprofile', 'write', 30, 'moodle', 16),
(99, 'moodle/user:editownmessageprofile', 'write', 10, 'moodle', 0),
(100, 'moodle/question:managecategory', 'write', 50, 'moodle', 20),
(101, 'moodle/question:add', 'write', 50, 'moodle', 20),
(102, 'moodle/question:editmine', 'write', 50, 'moodle', 20),
(103, 'moodle/question:editall', 'write', 50, 'moodle', 20),
(104, 'moodle/question:viewmine', 'read', 50, 'moodle', 0),
(105, 'moodle/question:viewall', 'read', 50, 'moodle', 0),
(106, 'moodle/question:usemine', 'read', 50, 'moodle', 0),
(107, 'moodle/question:useall', 'read', 50, 'moodle', 0),
(108, 'moodle/question:movemine', 'write', 50, 'moodle', 0),
(109, 'moodle/question:moveall', 'write', 50, 'moodle', 0),
(110, 'moodle/question:config', 'write', 10, 'moodle', 2),
(111, 'moodle/question:flag', 'write', 50, 'moodle', 0),
(112, 'moodle/site:doclinks', 'read', 10, 'moodle', 0),
(113, 'moodle/course:sectionvisibility', 'write', 50, 'moodle', 0),
(114, 'moodle/course:useremail', 'write', 50, 'moodle', 0),
(115, 'moodle/course:viewhiddensections', 'write', 50, 'moodle', 0),
(116, 'moodle/course:setcurrentsection', 'write', 50, 'moodle', 0),
(117, 'moodle/site:mnetlogintoremote', 'read', 10, 'moodle', 0),
(118, 'moodle/grade:viewall', 'read', 50, 'moodle', 8),
(119, 'moodle/grade:view', 'read', 50, 'moodle', 0),
(120, 'moodle/grade:viewhidden', 'read', 50, 'moodle', 8),
(121, 'moodle/grade:import', 'write', 50, 'moodle', 12),
(122, 'moodle/grade:export', 'read', 50, 'moodle', 8),
(123, 'moodle/grade:manage', 'write', 50, 'moodle', 12),
(124, 'moodle/grade:edit', 'write', 50, 'moodle', 12),
(125, 'moodle/grade:manageoutcomes', 'write', 50, 'moodle', 0),
(126, 'moodle/grade:manageletters', 'write', 50, 'moodle', 0),
(127, 'moodle/grade:hide', 'write', 50, 'moodle', 0),
(128, 'moodle/grade:lock', 'write', 50, 'moodle', 0),
(129, 'moodle/grade:unlock', 'write', 50, 'moodle', 0),
(130, 'moodle/my:manageblocks', 'write', 10, 'moodle', 0),
(131, 'moodle/notes:view', 'read', 50, 'moodle', 0),
(132, 'moodle/notes:manage', 'write', 50, 'moodle', 16),
(133, 'moodle/tag:manage', 'write', 10, 'moodle', 16),
(134, 'moodle/tag:create', 'write', 10, 'moodle', 16),
(135, 'moodle/tag:edit', 'write', 10, 'moodle', 16),
(136, 'moodle/tag:editblocks', 'write', 10, 'moodle', 0),
(137, 'moodle/block:view', 'read', 80, 'moodle', 0),
(138, 'moodle/block:edit', 'write', 80, 'moodle', 20),
(139, 'moodle/portfolio:export', 'read', 10, 'moodle', 0),
(140, 'moodle/comment:view', 'read', 50, 'moodle', 0),
(141, 'moodle/comment:post', 'write', 50, 'moodle', 24),
(142, 'moodle/comment:delete', 'write', 50, 'moodle', 32),
(143, 'moodle/webservice:createtoken', 'write', 10, 'moodle', 62),
(144, 'moodle/rating:view', 'read', 50, 'moodle', 0),
(145, 'moodle/rating:viewany', 'read', 50, 'moodle', 8),
(146, 'moodle/rating:viewall', 'read', 50, 'moodle', 8),
(147, 'moodle/rating:rate', 'write', 50, 'moodle', 0),
(148, 'moodle/course:publish', 'write', 10, 'moodle', 24),
(149, 'moodle/course:markcomplete', 'write', 50, 'moodle', 0),
(150, 'moodle/community:add', 'write', 10, 'moodle', 0),
(151, 'moodle/community:download', 'write', 10, 'moodle', 0),
(152, 'mod/assignment:view', 'read', 70, 'mod_assignment', 0),
(153, 'mod/assignment:submit', 'write', 70, 'mod_assignment', 0),
(154, 'mod/assignment:grade', 'write', 70, 'mod_assignment', 4),
(155, 'mod/assignment:exportownsubmission', 'read', 70, 'mod_assignment', 0),
(156, 'mod/chat:chat', 'write', 70, 'mod_chat', 16),
(157, 'mod/chat:readlog', 'read', 70, 'mod_chat', 0),
(158, 'mod/chat:deletelog', 'write', 70, 'mod_chat', 0),
(159, 'mod/chat:exportparticipatedsession', 'read', 70, 'mod_chat', 8),
(160, 'mod/chat:exportsession', 'read', 70, 'mod_chat', 8),
(161, 'mod/choice:choose', 'write', 70, 'mod_choice', 0),
(162, 'mod/choice:readresponses', 'read', 70, 'mod_choice', 0),
(163, 'mod/choice:deleteresponses', 'write', 70, 'mod_choice', 0),
(164, 'mod/choice:downloadresponses', 'read', 70, 'mod_choice', 0),
(165, 'mod/data:viewentry', 'read', 70, 'mod_data', 0),
(166, 'mod/data:writeentry', 'write', 70, 'mod_data', 16),
(167, 'mod/data:comment', 'write', 70, 'mod_data', 16),
(168, 'mod/data:rate', 'write', 70, 'mod_data', 0),
(169, 'mod/data:viewrating', 'read', 70, 'mod_data', 0),
(170, 'mod/data:viewanyrating', 'read', 70, 'mod_data', 8),
(171, 'mod/data:viewallratings', 'read', 70, 'mod_data', 8),
(172, 'mod/data:approve', 'write', 70, 'mod_data', 16),
(173, 'mod/data:manageentries', 'write', 70, 'mod_data', 16),
(174, 'mod/data:managecomments', 'write', 70, 'mod_data', 16),
(175, 'mod/data:managetemplates', 'write', 70, 'mod_data', 20),
(176, 'mod/data:viewalluserpresets', 'read', 70, 'mod_data', 0),
(177, 'mod/data:manageuserpresets', 'write', 70, 'mod_data', 20),
(178, 'mod/data:exportentry', 'read', 70, 'mod_data', 8),
(179, 'mod/data:exportownentry', 'read', 70, 'mod_data', 0),
(180, 'mod/data:exportallentries', 'read', 70, 'mod_data', 8),
(181, 'mod/feedback:view', 'read', 70, 'mod_feedback', 0),
(182, 'mod/feedback:complete', 'write', 70, 'mod_feedback', 16),
(183, 'mod/feedback:viewanalysepage', 'read', 70, 'mod_feedback', 8),
(184, 'mod/feedback:deletesubmissions', 'write', 70, 'mod_feedback', 0),
(185, 'mod/feedback:mapcourse', 'write', 70, 'mod_feedback', 0),
(186, 'mod/feedback:edititems', 'write', 70, 'mod_feedback', 20),
(187, 'mod/feedback:createprivatetemplate', 'write', 70, 'mod_feedback', 16),
(188, 'mod/feedback:createpublictemplate', 'write', 70, 'mod_feedback', 16),
(189, 'mod/feedback:deletetemplate', 'write', 70, 'mod_feedback', 0),
(190, 'mod/feedback:viewreports', 'read', 70, 'mod_feedback', 8),
(191, 'mod/feedback:receivemail', 'read', 70, 'mod_feedback', 8),
(192, 'mod/folder:view', 'read', 70, 'mod_folder', 0),
(193, 'mod/folder:managefiles', 'write', 70, 'mod_folder', 16),
(194, 'mod/forum:viewdiscussion', 'read', 70, 'mod_forum', 0),
(195, 'mod/forum:viewhiddentimedposts', 'read', 70, 'mod_forum', 0),
(196, 'mod/forum:startdiscussion', 'write', 70, 'mod_forum', 16),
(197, 'mod/forum:replypost', 'write', 70, 'mod_forum', 16),
(198, 'mod/forum:addnews', 'write', 70, 'mod_forum', 16),
(199, 'mod/forum:replynews', 'write', 70, 'mod_forum', 16),
(200, 'mod/forum:viewrating', 'read', 70, 'mod_forum', 0),
(201, 'mod/forum:viewanyrating', 'read', 70, 'mod_forum', 8),
(202, 'mod/forum:viewallratings', 'read', 70, 'mod_forum', 8),
(203, 'mod/forum:rate', 'write', 70, 'mod_forum', 0),
(204, 'mod/forum:createattachment', 'write', 70, 'mod_forum', 16),
(205, 'mod/forum:deleteownpost', 'read', 70, 'mod_forum', 0),
(206, 'mod/forum:deleteanypost', 'read', 70, 'mod_forum', 0),
(207, 'mod/forum:splitdiscussions', 'read', 70, 'mod_forum', 0),
(208, 'mod/forum:movediscussions', 'read', 70, 'mod_forum', 0),
(209, 'mod/forum:editanypost', 'write', 70, 'mod_forum', 16),
(210, 'mod/forum:viewqandawithoutposting', 'read', 70, 'mod_forum', 0),
(211, 'mod/forum:viewsubscribers', 'read', 70, 'mod_forum', 0),
(212, 'mod/forum:managesubscriptions', 'read', 70, 'mod_forum', 16),
(213, 'mod/forum:initialsubscriptions', 'read', 70, 'mod_forum', 0),
(214, 'mod/forum:postwithoutthrottling', 'write', 70, 'mod_forum', 16),
(215, 'mod/forum:exportdiscussion', 'read', 70, 'mod_forum', 8),
(216, 'mod/forum:exportpost', 'read', 70, 'mod_forum', 8),
(217, 'mod/forum:exportownpost', 'read', 70, 'mod_forum', 8),
(218, 'mod/glossary:write', 'write', 70, 'mod_glossary', 16),
(219, 'mod/glossary:manageentries', 'write', 70, 'mod_glossary', 16),
(220, 'mod/glossary:managecategories', 'write', 70, 'mod_glossary', 16),
(221, 'mod/glossary:comment', 'write', 70, 'mod_glossary', 16),
(222, 'mod/glossary:managecomments', 'write', 70, 'mod_glossary', 16),
(223, 'mod/glossary:import', 'write', 70, 'mod_glossary', 16),
(224, 'mod/glossary:export', 'read', 70, 'mod_glossary', 0),
(225, 'mod/glossary:approve', 'write', 70, 'mod_glossary', 16),
(226, 'mod/glossary:rate', 'write', 70, 'mod_glossary', 0),
(227, 'mod/glossary:viewrating', 'read', 70, 'mod_glossary', 0),
(228, 'mod/glossary:viewanyrating', 'read', 70, 'mod_glossary', 8),
(229, 'mod/glossary:viewallratings', 'read', 70, 'mod_glossary', 8),
(230, 'mod/glossary:exportentry', 'read', 70, 'mod_glossary', 8),
(231, 'mod/glossary:exportownentry', 'read', 70, 'mod_glossary', 0),
(232, 'mod/imscp:view', 'read', 70, 'mod_imscp', 0),
(233, 'mod/lesson:edit', 'write', 70, 'mod_lesson', 4),
(234, 'mod/lesson:manage', 'write', 70, 'mod_lesson', 0),
(235, 'mod/page:view', 'read', 70, 'mod_page', 0),
(236, 'mod/quiz:view', 'read', 70, 'mod_quiz', 0),
(237, 'mod/quiz:attempt', 'write', 70, 'mod_quiz', 16),
(238, 'mod/quiz:reviewmyattempts', 'read', 70, 'mod_quiz', 0),
(239, 'mod/quiz:manage', 'write', 70, 'mod_quiz', 16),
(240, 'mod/quiz:manageoverrides', 'write', 70, 'mod_quiz', 0),
(241, 'mod/quiz:preview', 'write', 70, 'mod_quiz', 0),
(242, 'mod/quiz:grade', 'write', 70, 'mod_quiz', 16),
(243, 'mod/quiz:regrade', 'write', 70, 'mod_quiz', 16),
(244, 'mod/quiz:viewreports', 'read', 70, 'mod_quiz', 8),
(245, 'mod/quiz:deleteattempts', 'write', 70, 'mod_quiz', 32),
(246, 'mod/quiz:ignoretimelimits', 'read', 70, 'mod_quiz', 0),
(247, 'mod/quiz:emailconfirmsubmission', 'read', 70, 'mod_quiz', 0),
(248, 'mod/quiz:emailnotifysubmission', 'read', 70, 'mod_quiz', 0),
(249, 'mod/resource:view', 'read', 70, 'mod_resource', 0),
(250, 'mod/scorm:viewreport', 'read', 70, 'mod_scorm', 0),
(251, 'mod/scorm:skipview', 'write', 70, 'mod_scorm', 0),
(252, 'mod/scorm:savetrack', 'write', 70, 'mod_scorm', 0),
(253, 'mod/scorm:viewscores', 'read', 70, 'mod_scorm', 0),
(254, 'mod/scorm:deleteresponses', 'read', 70, 'mod_scorm', 0),
(255, 'mod/survey:participate', 'read', 70, 'mod_survey', 0),
(256, 'mod/survey:readresponses', 'read', 70, 'mod_survey', 0),
(257, 'mod/survey:download', 'read', 70, 'mod_survey', 0),
(258, 'mod/url:view', 'read', 70, 'mod_url', 0),
(259, 'mod/wiki:viewpage', 'read', 70, 'mod_wiki', 0),
(260, 'mod/wiki:editpage', 'write', 70, 'mod_wiki', 16),
(261, 'mod/wiki:createpage', 'write', 70, 'mod_wiki', 16),
(262, 'mod/wiki:viewcomment', 'read', 70, 'mod_wiki', 0),
(263, 'mod/wiki:editcomment', 'write', 70, 'mod_wiki', 16),
(264, 'mod/wiki:managecomment', 'write', 70, 'mod_wiki', 0),
(265, 'mod/wiki:managefiles', 'write', 70, 'mod_wiki', 0),
(266, 'mod/wiki:overridelock', 'write', 70, 'mod_wiki', 0),
(267, 'mod/wiki:managewiki', 'write', 70, 'mod_wiki', 0),
(268, 'mod/workshop:view', 'read', 70, 'mod_workshop', 0),
(269, 'mod/workshop:switchphase', 'write', 70, 'mod_workshop', 0),
(270, 'mod/workshop:editdimensions', 'write', 70, 'mod_workshop', 4),
(271, 'mod/workshop:submit', 'write', 70, 'mod_workshop', 0),
(272, 'mod/workshop:peerassess', 'write', 70, 'mod_workshop', 0),
(273, 'mod/workshop:manageexamples', 'write', 70, 'mod_workshop', 0),
(274, 'mod/workshop:allocate', 'write', 70, 'mod_workshop', 0),
(275, 'mod/workshop:publishsubmissions', 'write', 70, 'mod_workshop', 0),
(276, 'mod/workshop:viewauthornames', 'read', 70, 'mod_workshop', 0),
(277, 'mod/workshop:viewreviewernames', 'read', 70, 'mod_workshop', 0),
(278, 'mod/workshop:viewallsubmissions', 'read', 70, 'mod_workshop', 0),
(279, 'mod/workshop:viewpublishedsubmissions', 'read', 70, 'mod_workshop', 0),
(280, 'mod/workshop:viewauthorpublished', 'read', 70, 'mod_workshop', 0),
(281, 'mod/workshop:viewallassessments', 'read', 70, 'mod_workshop', 0),
(282, 'mod/workshop:overridegrades', 'write', 70, 'mod_workshop', 0),
(283, 'enrol/authorize:config', 'write', 50, 'enrol_authorize', 0),
(284, 'enrol/authorize:manage', 'write', 50, 'enrol_authorize', 0),
(285, 'enrol/authorize:unenrol', 'write', 50, 'enrol_authorize', 0),
(286, 'enrol/authorize:unenrolself', 'write', 50, 'enrol_authorize', 0),
(287, 'enrol/authorize:managepayments', 'write', 10, 'enrol_authorize', 8),
(288, 'enrol/authorize:uploadcsv', 'write', 10, 'enrol_authorize', 4),
(289, 'enrol/category:synchronised', 'write', 10, 'enrol_category', 0),
(290, 'enrol/cohort:config', 'write', 50, 'enrol_cohort', 0),
(291, 'enrol/guest:config', 'write', 50, 'enrol_guest', 0),
(292, 'enrol/ldap:manage', 'write', 50, 'enrol_ldap', 0),
(293, 'enrol/manual:config', 'write', 50, 'enrol_manual', 0),
(294, 'enrol/manual:enrol', 'write', 50, 'enrol_manual', 0),
(295, 'enrol/manual:manage', 'write', 50, 'enrol_manual', 0),
(296, 'enrol/manual:unenrol', 'write', 50, 'enrol_manual', 0),
(297, 'enrol/manual:unenrolself', 'write', 50, 'enrol_manual', 0),
(298, 'enrol/meta:config', 'write', 50, 'enrol_meta', 0),
(299, 'enrol/meta:selectaslinked', 'read', 50, 'enrol_meta', 0),
(300, 'enrol/paypal:config', 'write', 50, 'enrol_paypal', 0),
(301, 'enrol/paypal:manage', 'write', 50, 'enrol_paypal', 0),
(302, 'enrol/paypal:unenrol', 'write', 50, 'enrol_paypal', 0),
(303, 'enrol/paypal:unenrolself', 'write', 50, 'enrol_paypal', 0),
(304, 'enrol/self:config', 'write', 50, 'enrol_self', 0),
(305, 'enrol/self:manage', 'write', 50, 'enrol_self', 0),
(306, 'enrol/self:unenrolself', 'write', 50, 'enrol_self', 0),
(307, 'enrol/self:unenrol', 'write', 50, 'enrol_self', 0),
(308, 'block/online_users:viewlist', 'read', 80, 'block_online_users', 0),
(309, 'block/rss_client:manageownfeeds', 'write', 80, 'block_rss_client', 0),
(310, 'block/rss_client:manageanyfeeds', 'write', 80, 'block_rss_client', 16),
(311, 'report/courseoverview:view', 'read', 10, 'report_courseoverview', 8),
(312, 'report/customlang:view', 'read', 10, 'report_customlang', 2),
(313, 'report/customlang:edit', 'write', 10, 'report_customlang', 6),
(314, 'report/questioninstances:view', 'read', 10, 'report_questioninstances', 0),
(315, 'report/security:view', 'read', 10, 'report_security', 2),
(316, 'report/unittest:view', 'read', 10, 'report_unittest', 32),
(317, 'coursereport/completion:view', 'read', 50, 'coursereport_completion', 8),
(318, 'coursereport/log:view', 'read', 50, 'coursereport_log', 8),
(319, 'coursereport/log:viewlive', 'read', 50, 'coursereport_log', 8),
(320, 'coursereport/log:viewtoday', 'read', 50, 'coursereport_log', 8),
(321, 'coursereport/outline:view', 'read', 50, 'coursereport_outline', 8),
(322, 'coursereport/participation:view', 'read', 50, 'coursereport_participation', 8),
(323, 'coursereport/progress:view', 'read', 50, 'coursereport_progress', 8),
(324, 'coursereport/stats:view', 'read', 50, 'coursereport_stats', 8),
(325, 'gradeexport/ods:view', 'read', 50, 'gradeexport_ods', 8),
(326, 'gradeexport/ods:publish', 'read', 50, 'gradeexport_ods', 8),
(327, 'gradeexport/txt:view', 'read', 50, 'gradeexport_txt', 8),
(328, 'gradeexport/txt:publish', 'read', 50, 'gradeexport_txt', 8),
(329, 'gradeexport/xls:view', 'read', 50, 'gradeexport_xls', 8),
(330, 'gradeexport/xls:publish', 'read', 50, 'gradeexport_xls', 8),
(331, 'gradeexport/xml:view', 'read', 50, 'gradeexport_xml', 8),
(332, 'gradeexport/xml:publish', 'read', 50, 'gradeexport_xml', 8),
(333, 'gradeimport/csv:view', 'write', 50, 'gradeimport_csv', 0),
(334, 'gradeimport/xml:view', 'write', 50, 'gradeimport_xml', 0),
(335, 'gradeimport/xml:publish', 'write', 50, 'gradeimport_xml', 0),
(336, 'gradereport/grader:view', 'read', 50, 'gradereport_grader', 8),
(337, 'gradereport/outcomes:view', 'read', 50, 'gradereport_outcomes', 8),
(338, 'gradereport/overview:view', 'read', 50, 'gradereport_overview', 8),
(339, 'gradereport/user:view', 'read', 50, 'gradereport_user', 8),
(340, 'webservice/amf:use', 'read', 50, 'webservice_amf', 62),
(341, 'webservice/rest:use', 'read', 50, 'webservice_rest', 62),
(342, 'webservice/soap:use', 'read', 50, 'webservice_soap', 62),
(343, 'webservice/xmlrpc:use', 'read', 50, 'webservice_xmlrpc', 62),
(344, 'repository/alfresco:view', 'read', 70, 'repository_alfresco', 0),
(345, 'repository/boxnet:view', 'read', 70, 'repository_boxnet', 0),
(346, 'repository/coursefiles:view', 'read', 70, 'repository_coursefiles', 0),
(347, 'repository/dropbox:view', 'read', 70, 'repository_dropbox', 0),
(348, 'repository/filesystem:view', 'read', 70, 'repository_filesystem', 0),
(349, 'repository/flickr:view', 'read', 70, 'repository_flickr', 0),
(350, 'repository/flickr_public:view', 'read', 70, 'repository_flickr_public', 0),
(351, 'repository/googledocs:view', 'read', 70, 'repository_googledocs', 0),
(352, 'repository/local:view', 'read', 70, 'repository_local', 0),
(353, 'repository/merlot:view', 'read', 70, 'repository_merlot', 0),
(354, 'repository/picasa:view', 'read', 70, 'repository_picasa', 0),
(355, 'repository/recent:view', 'read', 70, 'repository_recent', 0),
(356, 'repository/s3:view', 'read', 70, 'repository_s3', 0),
(357, 'repository/upload:view', 'read', 70, 'repository_upload', 0),
(358, 'repository/url:view', 'read', 70, 'repository_url', 0),
(359, 'repository/user:view', 'read', 70, 'repository_user', 0),
(360, 'repository/webdav:view', 'read', 70, 'repository_webdav', 0),
(361, 'repository/wikimedia:view', 'read', 70, 'repository_wikimedia', 0),
(362, 'repository/youtube:view', 'read', 70, 'repository_youtube', 0),
(363, 'quizreport/statistics:view', 'read', 70, 'quiz_statistics', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat`
--

CREATE TABLE `[[dbprefix]]chat` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `keepdays` bigint(11) NOT NULL DEFAULT '0',
  `studentlogs` smallint(4) NOT NULL DEFAULT '0',
  `chattime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `schedule` smallint(4) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chat_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each of these is a chat room' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat_messages`
--

CREATE TABLE `[[dbprefix]]chat_messages` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `timestamp` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chatmess_use_ix` (`userid`),
  KEY `[[dbprefix]]chatmess_gro_ix` (`groupid`),
  KEY `[[dbprefix]]chatmess_timcha_ix` (`timestamp`,`chatid`),
  KEY `[[dbprefix]]chatmess_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all the actual chat messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat_messages_current`
--

CREATE TABLE `[[dbprefix]]chat_messages_current` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `timestamp` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chatmesscurr_use_ix` (`userid`),
  KEY `[[dbprefix]]chatmesscurr_gro_ix` (`groupid`),
  KEY `[[dbprefix]]chatmesscurr_timcha_ix` (`timestamp`,`chatid`),
  KEY `[[dbprefix]]chatmesscurr_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores current session' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat_users`
--

CREATE TABLE `[[dbprefix]]chat_users` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `chatid` bigint(11) NOT NULL DEFAULT '0',
  `userid` bigint(11) NOT NULL DEFAULT '0',
  `groupid` bigint(11) NOT NULL DEFAULT '0',
  `version` varchar(16) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `firstping` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lastping` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lastmessageping` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sid` varchar(32) NOT NULL DEFAULT '',
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lang` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chatuser_use_ix` (`userid`),
  KEY `[[dbprefix]]chatuser_las_ix` (`lastping`),
  KEY `[[dbprefix]]chatuser_gro_ix` (`groupid`),
  KEY `[[dbprefix]]chatuser_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Keeps track of which users are in which chat rooms' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice`
--

CREATE TABLE `[[dbprefix]]choice` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `publish` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `showresults` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `display` smallint(4) unsigned NOT NULL DEFAULT '0',
  `allowupdate` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `showunanswered` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `limitanswers` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `timeopen` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeclose` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Available choices are stored here' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice_answers`
--

CREATE TABLE `[[dbprefix]]choice_answers` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `optionid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choiansw_use_ix` (`userid`),
  KEY `[[dbprefix]]choiansw_cho_ix` (`choiceid`),
  KEY `[[dbprefix]]choiansw_opt_ix` (`optionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='choices performed by users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice_options`
--

CREATE TABLE `[[dbprefix]]choice_options` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `text` text,
  `maxanswers` bigint(10) unsigned DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choiopti_cho_ix` (`choiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='available options to choice' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cohort`
--

CREATE TABLE `[[dbprefix]]cohort` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) unsigned NOT NULL,
  `name` varchar(254) NOT NULL DEFAULT '',
  `idnumber` varchar(100) DEFAULT NULL,
  `description` text,
  `descriptionformat` tinyint(2) unsigned NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `timecreated` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]coho_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each record represents one cohort (aka site-wide group).' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cohort_members`
--

CREATE TABLE `[[dbprefix]]cohort_members` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `cohortid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeadded` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]cohomemb_cohuse_uix` (`cohortid`,`userid`),
  KEY `[[dbprefix]]cohomemb_coh_ix` (`cohortid`),
  KEY `[[dbprefix]]cohomemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Link a user to a cohort.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) unsigned NOT NULL,
  `commentarea` varchar(255) NOT NULL DEFAULT '',
  `itemid` bigint(10) unsigned NOT NULL,
  `content` text NOT NULL,
  `format` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL,
  `timecreated` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='moodle comments module' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]conf_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Moodle configuration variables' AUTO_INCREMENT=394 ;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
(2, 'rolesactive', '1'),
(3, 'auth', 'email'),
(4, 'auth_pop3mailbox', 'INBOX'),
(5, 'enrol_plugins_enabled', 'manual,guest,self,cohort'),
(6, 'theme', 'standard'),
(7, 'filter_multilang_converted', '1'),
(8, 'siteidentifier', '[[siteidentifier]][[domhost]]'),
(9, 'backup_version', '2008111700'),
(10, 'backup_release', '2.0 dev'),
(11, 'mnet_dispatcher_mode', 'off'),
(12, 'sessiontimeout', '7200'),
(13, 'stringfilters', ''),
(14, 'filterall', '0'),
(15, 'texteditors', 'tinymce,textarea'),
(16, 'mnet_localhost_id', '1'),
(17, 'mnet_all_hosts_id', '2'),
(18, 'siteguest', '1'),
(19, 'siteadmins', '2'),
(20, 'themerev', '163'),
(21, 'licenses', 'unknown,allrightsreserved,public,cc,cc-nd,cc-nc-nd,cc-nc,cc-nc-sa,cc-sa'),
(22, 'version', '2011033010'),
(23, 'enableoutcomes', '0'),
(24, 'usecomments', '1'),
(25, 'usetags', '1'),
(26, 'enablenotes', '1'),
(27, 'enableportfolios', '0'),
(28, 'enablewebservices', '0'),
(29, 'messaging', '1'),
(30, 'messaginghidereadnotifications', '0'),
(31, 'messagingdeletereadnotificationsdelay', '604800'),
(32, 'enablestats', '0'),
(33, 'enablerssfeeds', '0'),
(34, 'bloglevel', '4'),
(35, 'enablecompletion', '0'),
(36, 'enableavailability', '0'),
(37, 'enableplagiarism', '0'),
(38, 'autologinguests', '0'),
(39, 'hiddenuserfields', ''),
(40, 'extrauserselectorfields', 'email'),
(41, 'enablecourserequests', '0'),
(42, 'defaultrequestcategory', '1'),
(43, 'courserequestnotify', ''),
(44, 'grade_profilereport', 'user'),
(45, 'grade_aggregationposition', '1'),
(46, 'grade_includescalesinaggregation', '1'),
(47, 'grade_hiddenasdate', '0'),
(48, 'gradepublishing', '0'),
(49, 'grade_export_displaytype', '1'),
(50, 'grade_export_decimalpoints', '2'),
(51, 'grade_navmethod', '0'),
(52, 'gradeexport', ''),
(53, 'unlimitedgrades', '0'),
(54, 'grade_hideforcedsettings', '1'),
(55, 'grade_aggregation', '11'),
(56, 'grade_aggregation_flag', '0'),
(57, 'grade_aggregations_visible', '0,10,11,12,2,4,6,8,13'),
(58, 'grade_aggregateonlygraded', '1'),
(59, 'grade_aggregateonlygraded_flag', '2'),
(60, 'grade_aggregateoutcomes', '0'),
(61, 'grade_aggregateoutcomes_flag', '2'),
(62, 'grade_aggregatesubcats', '0'),
(63, 'grade_aggregatesubcats_flag', '2'),
(64, 'grade_keephigh', '0'),
(65, 'grade_keephigh_flag', '3'),
(66, 'grade_droplow', '0'),
(67, 'grade_droplow_flag', '2'),
(68, 'grade_displaytype', '1'),
(69, 'grade_decimalpoints', '2'),
(70, 'grade_item_advanced', 'iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime'),
(71, 'grade_report_studentsperpage', '100'),
(72, 'grade_report_quickgrading', '1'),
(73, 'grade_report_showquickfeedback', '0'),
(74, 'grade_report_fixedstudents', '0'),
(75, 'grade_report_meanselection', '1'),
(76, 'grade_report_enableajax', '0'),
(77, 'grade_report_showcalculations', '0'),
(78, 'grade_report_showeyecons', '0'),
(79, 'grade_report_showaverages', '1'),
(80, 'grade_report_showlocks', '0'),
(81, 'grade_report_showranges', '0'),
(82, 'grade_report_showuserimage', '1'),
(83, 'grade_report_showuseridnumber', '0'),
(84, 'grade_report_showactivityicons', '1'),
(85, 'grade_report_shownumberofgrades', '0'),
(86, 'grade_report_averagesdisplaytype', 'inherit'),
(87, 'grade_report_rangesdisplaytype', 'inherit'),
(88, 'grade_report_averagesdecimalpoints', 'inherit'),
(89, 'grade_report_rangesdecimalpoints', 'inherit'),
(90, 'grade_report_overview_showrank', '0'),
(91, 'grade_report_overview_showtotalsifcontainhidden', '0'),
(92, 'grade_report_user_showrank', '0'),
(93, 'grade_report_user_showpercentage', '1'),
(94, 'grade_report_user_showgrade', '1'),
(95, 'grade_report_user_showfeedback', '1'),
(96, 'grade_report_user_showrange', '1'),
(97, 'grade_report_user_showweight', '0'),
(98, 'grade_report_user_showaverage', '0'),
(99, 'grade_report_user_showlettergrade', '0'),
(100, 'grade_report_user_rangedecimals', '0'),
(101, 'grade_report_user_showhiddenitems', '1'),
(102, 'grade_report_user_showtotalsifcontainhidden', '0'),
(103, 'timezone', '99'),
(104, 'forcetimezone', '99'),
(105, 'country', '0'),
(106, 'defaultcity', ''),
(107, 'geoipfile', '[[softdatadir]]/geoip/GeoLiteCity.dat'),
(108, 'googlemapkey', ''),
(109, 'allcountrycodes', ''),
(110, 'autolang', '1'),
(111, 'lang', '[[language]]'),
(112, 'langmenu', '1'),
(113, 'langlist', ''),
(114, 'langcache', '1'),
(115, 'langstringcache', '1'),
(116, 'locale', ''),
(117, 'latinexcelexport', '0'),
(119, 'guestloginbutton', '1'),
(120, 'alternateloginurl', ''),
(121, 'forgottenpasswordurl', ''),
(122, 'auth_instructions', ''),
(123, 'allowemailaddresses', ''),
(124, 'denyemailaddresses', ''),
(125, 'verifychangedemail', '1'),
(126, 'recaptchapublickey', ''),
(127, 'recaptchaprivatekey', ''),
(128, 'sitedefaultlicense', 'allrightsreserved'),
(129, 'cachetext', '60'),
(130, 'filteruploadedfiles', '0'),
(131, 'filtermatchoneperpage', '0'),
(132, 'filtermatchonepertext', '0'),
(133, 'filter_multilang_force_old', '0'),
(134, 'filter_mediaplugin_enable_youtube', '1'),
(135, 'filter_mediaplugin_enable_vimeo', '0'),
(136, 'filter_mediaplugin_enable_mp3', '1'),
(137, 'filter_mediaplugin_enable_flv', '1'),
(138, 'filter_mediaplugin_enable_swf', '1'),
(139, 'filter_mediaplugin_enable_html5audio', '0'),
(140, 'filter_mediaplugin_enable_html5video', '0'),
(141, 'filter_mediaplugin_enable_qt', '1'),
(142, 'filter_mediaplugin_enable_wmp', '1'),
(143, 'filter_mediaplugin_enable_rm', '1'),
(144, 'filter_tex_latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n'),
(145, 'filter_tex_latexbackground', '#FFFFFF'),
(146, 'filter_tex_density', '120'),
(147, 'filter_tex_pathlatex', '/usr/bin/latex'),
(148, 'filter_tex_pathdvips', '/usr/bin/dvips'),
(149, 'filter_tex_pathconvert', '/usr/bin/convert'),
(150, 'filter_tex_convertformat', 'gif'),
(151, 'filter_censor_badwords', ''),
(152, 'portfolio_moderate_filesize_threshold', '1048576'),
(153, 'portfolio_high_filesize_threshold', '5242880'),
(154, 'portfolio_moderate_db_threshold', '20'),
(155, 'portfolio_high_db_threshold', '50'),
(156, 'repositorycacheexpire', '120'),
(157, 'repositoryallowexternallinks', '1'),
(158, 'legacyfilesinnewcourses', '0'),
(159, 'enablewsdocumentation', '0'),
(160, 'allowbeforeblock', '0'),
(161, 'allowedip', ''),
(162, 'blockedip', ''),
(163, 'protectusernames', '1'),
(164, 'forcelogin', '0'),
(165, 'forceloginforprofiles', '1'),
(166, 'forceloginforprofileimage', '0'),
(167, 'opentogoogle', '0'),
(168, 'maxbytes', '0'),
(169, 'userquota', '104857600'),
(170, 'enablehtmlpurifier', '1'),
(171, 'allowobjectembed', '0'),
(172, 'enabletrusttext', '0'),
(173, 'maxeditingtime', '1800'),
(174, 'fullnamedisplay', 'language'),
(175, 'extendedusernamechars', '0'),
(176, 'sitepolicy', ''),
(177, 'sitepolicyguest', ''),
(178, 'keeptagnamecase', '1'),
(179, 'profilesforenrolledusersonly', '1'),
(180, 'cronclionly', '0'),
(181, 'cronremotepassword', ''),
(182, 'passwordpolicy', '1'),
(183, 'minpasswordlength', '8'),
(184, 'minpassworddigits', '1'),
(185, 'minpasswordlower', '1'),
(186, 'minpasswordupper', '1'),
(187, 'minpasswordnonalphanum', '1'),
(188, 'maxconsecutiveidentchars', '0'),
(189, 'groupenrolmentkeypolicy', '1'),
(190, 'disableuserimages', '0'),
(191, 'emailchangeconfirmation', '1'),
(192, 'strictformsrequired', '0'),
(193, 'loginhttps', '0'),
(194, 'cookiesecure', '0'),
(195, 'cookiehttponly', '0'),
(196, 'excludeoldflashclients', '10.0.12'),
(197, 'loginpasswordautocomplete', '0'),
(198, 'restrictmodulesfor', 'none'),
(199, 'restrictbydefault', '0'),
(200, 'displayloginfailures', ''),
(201, 'notifyloginfailures', ''),
(202, 'notifyloginthreshold', '10'),
(203, 'runclamonupload', '0'),
(204, 'pathtoclam', ''),
(205, 'quarantinedir', ''),
(206, 'clamfailureonupload', 'donothing'),
(207, 'themelist', ''),
(208, 'themedesignermode', '0'),
(209, 'allowuserthemes', '0'),
(210, 'allowcoursethemes', '0'),
(211, 'allowcategorythemes', '0'),
(212, 'allowthemechangeonurl', '0'),
(213, 'allowuserblockhiding', '1'),
(214, 'allowblockstodock', '1'),
(215, 'custommenuitems', ''),
(216, 'calendar_adminseesall', '0'),
(217, 'calendar_site_timeformat', '0'),
(218, 'calendar_startwday', '0'),
(219, 'calendar_weekend', '65'),
(220, 'calendar_lookahead', '21'),
(221, 'calendar_maxevents', '10'),
(222, 'enablecalendarexport', '1'),
(223, 'calendar_exportsalt', '[[export_salt]]'),
(224, 'useblogassociations', '1'),
(225, 'useexternalblogs', '1'),
(226, 'externalblogcrontime', '86400'),
(227, 'maxexternalblogsperuser', '1'),
(228, 'blogusecomments', '1'),
(229, 'blogshowcommentscount', '1'),
(230, 'defaulthomepage', '0'),
(231, 'navshowcategories', '1'),
(232, 'navshowallcourses', '0'),
(233, 'navcourselimit', '20'),
(234, 'formatstringstriptags', '1'),
(235, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]'),
(236, 'docroot', 'http://docs.moodle.org'),
(237, 'doctonewwindow', '0'),
(238, 'enableajax', '1'),
(239, 'useexternalyui', '0'),
(240, 'yuicomboloading', '1'),
(241, 'cachejs', '1'),
(242, 'enablecourseajax', '1'),
(243, 'additionalhtmlhead', ''),
(244, 'additionalhtmltopofbody', ''),
(245, 'additionalhtmlfooter', ''),
(246, 'gdversion', '2'),
(247, 'pathtodu', ''),
(248, 'aspellpath', ''),
(249, 'pathtodot', ''),
(250, 'smtphosts', ''),
(251, 'smtpuser', ''),
(252, 'smtppass', ''),
(253, 'smtpmaxbulk', '1'),
(254, 'noreplyaddress', 'noreply@[[domhost]]'),
(255, 'digestmailtime', '17'),
(256, 'sitemailcharset', '0'),
(257, 'allowusermailcharset', '0'),
(258, 'mailnewline', 'LF'),
(259, 'supportpage', ''),
(260, 'jabberhost', ''),
(261, 'jabberserver', ''),
(262, 'jabberusername', ''),
(263, 'jabberpassword', ''),
(264, 'jabberport', '5222'),
(265, 'dbsessions', '1'),
(266, 'sessioncookie', ''),
(267, 'sessioncookiepath', '/'),
(268, 'sessioncookiedomain', ''),
(269, 'statsfirstrun', 'none'),
(270, 'statsmaxruntime', '0'),
(271, 'statsruntimedays', '31'),
(272, 'statsruntimestarthour', '0'),
(273, 'statsruntimestartminute', '0'),
(274, 'statsuserthreshold', '0'),
(275, 'framename', '_top'),
(276, 'slasharguments', '1'),
(277, 'getremoteaddrconf', '0'),
(278, 'proxyhost', ''),
(279, 'proxyport', '0'),
(280, 'proxytype', 'HTTP'),
(281, 'proxyuser', ''),
(282, 'proxypassword', ''),
(283, 'proxybypass', 'localhost, [[serverip]]'),
(284, 'maintenance_enabled', '0'),
(285, 'maintenance_message', ''),
(286, 'deleteunconfirmed', '168'),
(287, 'deleteincompleteusers', '0'),
(288, 'logguests', '1'),
(289, 'loglifetime', '0'),
(290, 'disablegradehistory', '0'),
(291, 'gradehistorylifetime', '0'),
(292, 'numcoursesincombo', '500'),
(293, 'extramemorylimit', '512M'),
(294, 'curlcache', '120'),
(295, 'curltimeoutkbitrate', '56'),
(296, 'enableglobalsearch', '0'),
(297, 'enablesafebrowserintegration', '0'),
(298, 'enablegroupmembersonly', '0'),
(299, 'debug', '0'),
(300, 'debugdisplay', '1'),
(301, 'xmlstrictheaders', '0'),
(302, 'debugsmtp', '0'),
(303, 'perfdebug', '7'),
(304, 'debugstringids', '0'),
(305, 'debugvalidators', '0'),
(306, 'debugpageinfo', '0'),
(307, 'release', '2.0.10 (Build: 20120706)'),
(308, 'jsrev', '162'),
(310, 'notloggedinroleid', '6'),
(311, 'guestroleid', '6'),
(312, 'defaultuserroleid', '7'),
(313, 'creatornewroleid', '3'),
(314, 'gradebookroles', '5'),
(315, 'assignment_maxbytes', '1048576'),
(316, 'assignment_itemstocount', '1'),
(317, 'assignment_showrecentsubmissions', '1'),
(318, 'chat_method', 'ajax'),
(319, 'chat_refresh_userlist', '10'),
(320, 'chat_old_ping', '35'),
(321, 'chat_refresh_room', '5'),
(322, 'chat_normal_updatemode', 'jsupdate'),
(323, 'chat_serverhost', '[[domhost]]'),
(324, 'chat_serverip', '[[serverip]]'),
(325, 'chat_serverport', '9111'),
(326, 'chat_servermax', '100'),
(327, 'data_enablerssfeeds', '0'),
(328, 'feedback_allowfullanonymous', '0'),
(329, 'forum_displaymode', '3'),
(330, 'forum_replytouser', '1'),
(331, 'forum_shortpost', '300'),
(332, 'forum_longpost', '600'),
(333, 'forum_manydiscussions', '100'),
(334, 'forum_maxbytes', '512000'),
(335, 'forum_maxattachments', '9'),
(336, 'forum_trackreadposts', '1'),
(337, 'forum_oldpostdays', '14'),
(338, 'forum_usermarksread', '0'),
(339, 'forum_cleanreadtime', '2'),
(340, 'forum_enablerssfeeds', '0'),
(341, 'forum_enabletimedposts', '0'),
(342, 'glossary_entbypage', '10'),
(343, 'glossary_dupentries', '0'),
(344, 'glossary_allowcomments', '0'),
(345, 'glossary_linkbydefault', '1'),
(346, 'glossary_defaultapproval', '1'),
(347, 'glossary_enablerssfeeds', '0'),
(348, 'glossary_linkentries', '0'),
(349, 'glossary_casesensitive', '0'),
(350, 'glossary_fullmatch', '0'),
(351, 'lesson_slideshowwidth', '640'),
(352, 'lesson_slideshowheight', '480'),
(353, 'lesson_slideshowbgcolor', '#FFFFFF'),
(354, 'lesson_mediawidth', '640'),
(355, 'lesson_mediaheight', '480'),
(356, 'lesson_mediaclose', '0'),
(357, 'lesson_maxhighscores', '10'),
(358, 'lesson_maxanswers', '4'),
(359, 'lesson_defaultnextpage', '0'),
(360, 'block_course_list_adminview', 'all'),
(361, 'block_course_list_hideallcourseslink', '0'),
(362, 'block_online_users_timetosee', '5'),
(363, 'block_rss_client_num_entries', '5'),
(364, 'block_rss_client_timeout', '30'),
(365, 'block_search_enable_file_indexing', '0'),
(366, 'block_search_filetypes', 'PDF,TXT,HTML,PPT,XML,DOC,HTM'),
(367, 'block_search_usemoodleroot', '1'),
(368, 'block_search_limit_index_body', '0'),
(369, 'block_search_pdf_to_text_cmd', 'lib/xpdf/linux/pdftotext -enc UTF-8 -eol unix -q'),
(370, 'block_search_word_to_text_cmd', 'lib/antiword/linux/usr/bin/antiword'),
(371, 'block_search_word_to_text_env', 'ANTIWORDHOME=[[softpath]]/lib/antiword/linux/usr/share/antiword'),
(372, 'search_in_assignment', '1'),
(373, 'search_in_chat', '1'),
(374, 'search_in_data', '1'),
(375, 'search_in_forum', '1'),
(376, 'search_in_glossary', '1'),
(377, 'search_in_label', '1'),
(378, 'search_in_lesson', '1'),
(379, 'search_in_resource', '1'),
(380, 'search_in_wiki', '1'),
(381, 'block_tags_showcoursetags', '0'),
(382, 'profileroles', '5,4,3'),
(383, 'defaultallowedmodules', ''),
(384, 'coursecontact', '3'),
(385, 'frontpage', '1'),
(386, 'frontpageloggedin', '1'),
(387, 'maxcategorydepth', '0'),
(388, 'commentsperpage', '15'),
(389, 'coursesperpage', '20'),
(390, 'defaultfrontpageroleid', '8'),
(391, 'supportname', '[[admin_fname]] [[admin_lname]]'),
(392, 'supportemail', '[[admin_email]]'),
(393, 'registerauth', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_log`
--

CREATE TABLE `[[dbprefix]]config_log` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  `plugin` varchar(100) DEFAULT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` text,
  `oldvalue` text,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]conflog_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]conflog_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Changes done in server configuration through admin UI' AUTO_INCREMENT=702 ;

--
-- Dumping data for table `[[dbprefix]]config_log`
--

INSERT INTO `[[dbprefix]]config_log` VALUES
(1, 0, [[timestamp]], NULL, 'enableoutcomes', '0', NULL),
(2, 0, [[timestamp]], NULL, 'usecomments', '1', NULL),
(3, 0, [[timestamp]], NULL, 'usetags', '1', NULL),
(4, 0, [[timestamp]], NULL, 'enablenotes', '1', NULL),
(5, 0, [[timestamp]], NULL, 'enableportfolios', '0', NULL),
(6, 0, [[timestamp]], NULL, 'enablewebservices', '0', NULL),
(7, 0, [[timestamp]], NULL, 'messaging', '1', NULL),
(8, 0, [[timestamp]], NULL, 'messaginghidereadnotifications', '0', NULL),
(9, 0, [[timestamp]], NULL, 'messagingdeletereadnotificationsdelay', '604800', NULL),
(10, 0, [[timestamp]], NULL, 'enablestats', '0', NULL),
(11, 0, [[timestamp]], NULL, 'enablerssfeeds', '0', NULL),
(12, 0, [[timestamp]], NULL, 'bloglevel', '4', NULL),
(13, 0, [[timestamp]], NULL, 'enablecompletion', '0', NULL),
(14, 0, [[timestamp]], NULL, 'enableavailability', '0', NULL),
(15, 0, [[timestamp]], NULL, 'enableplagiarism', '0', NULL),
(16, 0, [[timestamp]], NULL, 'autologinguests', '0', NULL),
(17, 0, [[timestamp]], NULL, 'hiddenuserfields', '', NULL),
(18, 0, [[timestamp]], NULL, 'extrauserselectorfields', 'email', NULL),
(19, 0, [[timestamp]], 'moodlecourse', 'format', 'weeks', NULL),
(20, 0, [[timestamp]], 'moodlecourse', 'numsections', '10', NULL),
(21, 0, [[timestamp]], 'moodlecourse', 'hiddensections', '0', NULL),
(22, 0, [[timestamp]], 'moodlecourse', 'newsitems', '5', NULL),
(23, 0, [[timestamp]], 'moodlecourse', 'showgrades', '1', NULL),
(24, 0, [[timestamp]], 'moodlecourse', 'showreports', '0', NULL),
(25, 0, [[timestamp]], 'moodlecourse', 'maxbytes', '33554432', NULL),
(26, 0, [[timestamp]], 'moodlecourse', 'groupmode', '0', NULL),
(27, 0, [[timestamp]], 'moodlecourse', 'groupmodeforce', '0', NULL),
(28, 0, [[timestamp]], 'moodlecourse', 'visible', '1', NULL),
(29, 0, [[timestamp]], 'moodlecourse', 'lang', '', NULL),
(30, 0, [[timestamp]], 'moodlecourse', 'enablecompletion', '0', NULL),
(31, 0, [[timestamp]], 'moodlecourse', 'completionstartonenrol', '0', NULL),
(32, 0, [[timestamp]], NULL, 'enablecourserequests', '0', NULL),
(33, 0, [[timestamp]], NULL, 'defaultrequestcategory', '1', NULL),
(34, 0, [[timestamp]], NULL, 'courserequestnotify', '', NULL),
(35, 0, [[timestamp]], 'backup', 'backup_general_users', '1', NULL),
(36, 0, [[timestamp]], 'backup', 'backup_general_users_locked', '0', NULL),
(37, 0, [[timestamp]], 'backup', 'backup_general_anonymize', '0', NULL),
(38, 0, [[timestamp]], 'backup', 'backup_general_anonymize_locked', '0', NULL),
(39, 0, [[timestamp]], 'backup', 'backup_general_role_assignments', '1', NULL),
(40, 0, [[timestamp]], 'backup', 'backup_general_role_assignments_locked', '0', NULL),
(41, 0, [[timestamp]], 'backup', 'backup_general_activities', '1', NULL),
(42, 0, [[timestamp]], 'backup', 'backup_general_activities_locked', '0', NULL),
(43, 0, [[timestamp]], 'backup', 'backup_general_blocks', '1', NULL),
(44, 0, [[timestamp]], 'backup', 'backup_general_blocks_locked', '0', NULL),
(45, 0, [[timestamp]], 'backup', 'backup_general_filters', '1', NULL),
(46, 0, [[timestamp]], 'backup', 'backup_general_filters_locked', '0', NULL),
(47, 0, [[timestamp]], 'backup', 'backup_general_comments', '1', NULL),
(48, 0, [[timestamp]], 'backup', 'backup_general_comments_locked', '0', NULL),
(49, 0, [[timestamp]], 'backup', 'backup_general_userscompletion', '1', NULL),
(50, 0, [[timestamp]], 'backup', 'backup_general_userscompletion_locked', '0', NULL),
(51, 0, [[timestamp]], 'backup', 'backup_general_logs', '0', NULL),
(52, 0, [[timestamp]], 'backup', 'backup_general_logs_locked', '0', NULL),
(53, 0, [[timestamp]], 'backup', 'backup_general_histories', '0', NULL),
(54, 0, [[timestamp]], 'backup', 'backup_general_histories_locked', '0', NULL),
(55, 0, [[timestamp]], 'backup', 'backup_auto_active', '0', NULL),
(56, 0, [[timestamp]], 'backup', 'backup_auto_weekdays', '0000000', NULL),
(57, 0, [[timestamp]], 'backup', 'backup_auto_hour', '0', NULL),
(58, 0, [[timestamp]], 'backup', 'backup_auto_minute', '0', NULL),
(59, 0, [[timestamp]], 'backup', 'backup_auto_storage', '0', NULL),
(60, 0, [[timestamp]], 'backup', 'backup_auto_destination', '', NULL),
(61, 0, [[timestamp]], 'backup', 'backup_auto_keep', '1', NULL),
(62, 0, [[timestamp]], 'backup', 'backup_auto_users', '1', NULL),
(63, 0, [[timestamp]], 'backup', 'backup_auto_role_assignments', '1', NULL),
(64, 0, [[timestamp]], 'backup', 'backup_auto_activities', '1', NULL),
(65, 0, [[timestamp]], 'backup', 'backup_auto_blocks', '1', NULL),
(66, 0, [[timestamp]], 'backup', 'backup_auto_filters', '1', NULL),
(67, 0, [[timestamp]], 'backup', 'backup_auto_comments', '1', NULL),
(68, 0, [[timestamp]], 'backup', 'backup_auto_userscompletion', '1', NULL),
(69, 0, [[timestamp]], 'backup', 'backup_auto_logs', '0', NULL),
(70, 0, [[timestamp]], 'backup', 'backup_auto_histories', '0', NULL),
(71, 0, [[timestamp]], NULL, 'grade_profilereport', 'user', NULL),
(72, 0, [[timestamp]], NULL, 'grade_aggregationposition', '1', NULL),
(73, 0, [[timestamp]], NULL, 'grade_includescalesinaggregation', '1', NULL),
(74, 0, [[timestamp]], NULL, 'grade_hiddenasdate', '0', NULL),
(75, 0, [[timestamp]], NULL, 'gradepublishing', '0', NULL),
(76, 0, [[timestamp]], NULL, 'grade_export_displaytype', '1', NULL),
(77, 0, [[timestamp]], NULL, 'grade_export_decimalpoints', '2', NULL),
(78, 0, [[timestamp]], NULL, 'grade_navmethod', '0', NULL),
(79, 0, [[timestamp]], NULL, 'gradeexport', '', NULL),
(80, 0, [[timestamp]], NULL, 'unlimitedgrades', '0', NULL),
(81, 0, [[timestamp]], NULL, 'grade_hideforcedsettings', '1', NULL),
(82, 0, [[timestamp]], NULL, 'grade_aggregation', '11', NULL),
(83, 0, [[timestamp]], NULL, 'grade_aggregation_flag', '0', NULL),
(84, 0, [[timestamp]], NULL, 'grade_aggregations_visible', '0,10,11,12,2,4,6,8,13', NULL),
(85, 0, [[timestamp]], NULL, 'grade_aggregateonlygraded', '1', NULL),
(86, 0, [[timestamp]], NULL, 'grade_aggregateonlygraded_flag', '2', NULL),
(87, 0, [[timestamp]], NULL, 'grade_aggregateoutcomes', '0', NULL),
(88, 0, [[timestamp]], NULL, 'grade_aggregateoutcomes_flag', '2', NULL),
(89, 0, [[timestamp]], NULL, 'grade_aggregatesubcats', '0', NULL),
(90, 0, [[timestamp]], NULL, 'grade_aggregatesubcats_flag', '2', NULL),
(91, 0, [[timestamp]], NULL, 'grade_keephigh', '0', NULL),
(92, 0, [[timestamp]], NULL, 'grade_keephigh_flag', '3', NULL),
(93, 0, [[timestamp]], NULL, 'grade_droplow', '0', NULL),
(94, 0, [[timestamp]], NULL, 'grade_droplow_flag', '2', NULL),
(95, 0, [[timestamp]], NULL, 'grade_displaytype', '1', NULL),
(96, 0, [[timestamp]], NULL, 'grade_decimalpoints', '2', NULL),
(97, 0, [[timestamp]], NULL, 'grade_item_advanced', 'iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime', NULL),
(98, 0, [[timestamp]], NULL, 'grade_report_studentsperpage', '100', NULL),
(99, 0, [[timestamp]], NULL, 'grade_report_quickgrading', '1', NULL),
(100, 0, [[timestamp]], NULL, 'grade_report_showquickfeedback', '0', NULL),
(101, 0, [[timestamp]], NULL, 'grade_report_fixedstudents', '0', NULL),
(102, 0, [[timestamp]], NULL, 'grade_report_meanselection', '1', NULL),
(103, 0, [[timestamp]], NULL, 'grade_report_enableajax', '0', NULL),
(104, 0, [[timestamp]], NULL, 'grade_report_showcalculations', '0', NULL),
(105, 0, [[timestamp]], NULL, 'grade_report_showeyecons', '0', NULL),
(106, 0, [[timestamp]], NULL, 'grade_report_showaverages', '1', NULL),
(107, 0, [[timestamp]], NULL, 'grade_report_showlocks', '0', NULL),
(108, 0, [[timestamp]], NULL, 'grade_report_showranges', '0', NULL),
(109, 0, [[timestamp]], NULL, 'grade_report_showuserimage', '1', NULL),
(110, 0, [[timestamp]], NULL, 'grade_report_showuseridnumber', '0', NULL),
(111, 0, [[timestamp]], NULL, 'grade_report_showactivityicons', '1', NULL),
(112, 0, [[timestamp]], NULL, 'grade_report_shownumberofgrades', '0', NULL),
(113, 0, [[timestamp]], NULL, 'grade_report_averagesdisplaytype', 'inherit', NULL),
(114, 0, [[timestamp]], NULL, 'grade_report_rangesdisplaytype', 'inherit', NULL),
(115, 0, [[timestamp]], NULL, 'grade_report_averagesdecimalpoints', 'inherit', NULL),
(116, 0, [[timestamp]], NULL, 'grade_report_rangesdecimalpoints', 'inherit', NULL),
(117, 0, [[timestamp]], NULL, 'grade_report_overview_showrank', '0', NULL),
(118, 0, [[timestamp]], NULL, 'grade_report_overview_showtotalsifcontainhidden', '0', NULL),
(119, 0, [[timestamp]], NULL, 'grade_report_user_showrank', '0', NULL),
(120, 0, [[timestamp]], NULL, 'grade_report_user_showpercentage', '1', NULL),
(121, 0, [[timestamp]], NULL, 'grade_report_user_showgrade', '1', NULL),
(122, 0, [[timestamp]], NULL, 'grade_report_user_showfeedback', '1', NULL),
(123, 0, [[timestamp]], NULL, 'grade_report_user_showrange', '1', NULL),
(124, 0, [[timestamp]], NULL, 'grade_report_user_showweight', '0', NULL),
(125, 0, [[timestamp]], NULL, 'grade_report_user_showaverage', '0', NULL),
(126, 0, [[timestamp]], NULL, 'grade_report_user_showlettergrade', '0', NULL),
(127, 0, [[timestamp]], NULL, 'grade_report_user_rangedecimals', '0', NULL),
(128, 0, [[timestamp]], NULL, 'grade_report_user_showhiddenitems', '1', NULL),
(129, 0, [[timestamp]], NULL, 'grade_report_user_showtotalsifcontainhidden', '0', NULL),
(130, 0, [[timestamp]], NULL, 'timezone', '99', NULL),
(131, 0, [[timestamp]], NULL, 'forcetimezone', '99', NULL),
(132, 0, [[timestamp]], NULL, 'country', '0', NULL),
(133, 0, [[timestamp]], NULL, 'defaultcity', '', NULL),
(134, 0, [[timestamp]], NULL, 'geoipfile', '[[softdatadir]]/geoip/GeoLiteCity.dat', NULL),
(135, 0, [[timestamp]], NULL, 'googlemapkey', '', NULL),
(136, 0, [[timestamp]], NULL, 'allcountrycodes', '', NULL),
(137, 0, [[timestamp]], NULL, 'autolang', '1', NULL),
(138, 0, [[timestamp]], NULL, 'lang', 'en', NULL),
(139, 0, [[timestamp]], NULL, 'langmenu', '1', NULL),
(140, 0, [[timestamp]], NULL, 'langlist', '', NULL),
(141, 0, [[timestamp]], NULL, 'langcache', '1', NULL),
(142, 0, [[timestamp]], NULL, 'langstringcache', '1', NULL),
(143, 0, [[timestamp]], NULL, 'locale', '', NULL),
(144, 0, [[timestamp]], NULL, 'latinexcelexport', '0', NULL),
(145, 0, [[timestamp]], NULL, 'registerauth', '', NULL),
(146, 0, [[timestamp]], NULL, 'guestloginbutton', '1', NULL),
(147, 0, [[timestamp]], NULL, 'alternateloginurl', '', NULL),
(148, 0, [[timestamp]], NULL, 'forgottenpasswordurl', '', NULL),
(149, 0, [[timestamp]], NULL, 'auth_instructions', '', NULL),
(150, 0, [[timestamp]], NULL, 'allowemailaddresses', '', NULL),
(151, 0, [[timestamp]], NULL, 'denyemailaddresses', '', NULL),
(152, 0, [[timestamp]], NULL, 'verifychangedemail', '1', NULL),
(153, 0, [[timestamp]], NULL, 'recaptchapublickey', '', NULL),
(154, 0, [[timestamp]], NULL, 'recaptchaprivatekey', '', NULL),
(155, 0, [[timestamp]], 'enrol_database', 'dbtype', '', NULL),
(156, 0, [[timestamp]], 'enrol_database', 'dbhost', 'localhost', NULL),
(157, 0, [[timestamp]], 'enrol_database', 'dbuser', '', NULL),
(158, 0, [[timestamp]], 'enrol_database', 'dbpass', '', NULL),
(159, 0, [[timestamp]], 'enrol_database', 'dbname', '', NULL),
(160, 0, [[timestamp]], 'enrol_database', 'dbencoding', 'utf-8', NULL),
(161, 0, [[timestamp]], 'enrol_database', 'dbsetupsql', '', NULL),
(162, 0, [[timestamp]], 'enrol_database', 'dbsybasequoting', '0', NULL),
(163, 0, [[timestamp]], 'enrol_database', 'debugdb', '0', NULL),
(164, 0, [[timestamp]], 'enrol_database', 'localcoursefield', 'idnumber', NULL),
(165, 0, [[timestamp]], 'enrol_database', 'localuserfield', 'idnumber', NULL),
(166, 0, [[timestamp]], 'enrol_database', 'localrolefield', 'shortname', NULL),
(167, 0, [[timestamp]], 'enrol_database', 'remoteenroltable', '', NULL),
(168, 0, [[timestamp]], 'enrol_database', 'remotecoursefield', '', NULL),
(169, 0, [[timestamp]], 'enrol_database', 'remoteuserfield', '', NULL),
(170, 0, [[timestamp]], 'enrol_database', 'remoterolefield', '', NULL),
(171, 0, [[timestamp]], 'enrol_database', 'ignorehiddencourses', '0', NULL),
(172, 0, [[timestamp]], 'enrol_database', 'unenrolaction', '0', NULL),
(173, 0, [[timestamp]], 'enrol_database', 'newcoursetable', '', NULL),
(174, 0, [[timestamp]], 'enrol_database', 'newcoursefullname', 'fullname', NULL),
(175, 0, [[timestamp]], 'enrol_database', 'newcourseshortname', 'shortname', NULL),
(176, 0, [[timestamp]], 'enrol_database', 'newcourseidnumber', 'idnumber', NULL),
(177, 0, [[timestamp]], 'enrol_database', 'newcoursecategory', '', NULL),
(178, 0, [[timestamp]], 'enrol_database', 'templatecourse', '', NULL),
(179, 0, [[timestamp]], 'enrol_flatfile', 'location', '', NULL),
(180, 0, [[timestamp]], 'enrol_flatfile', 'mailstudents', '0', NULL),
(181, 0, [[timestamp]], 'enrol_flatfile', 'mailteachers', '0', NULL),
(182, 0, [[timestamp]], 'enrol_flatfile', 'mailadmins', '0', NULL),
(183, 0, [[timestamp]], 'enrol_guest', 'requirepassword', '0', NULL),
(184, 0, [[timestamp]], 'enrol_guest', 'usepasswordpolicy', '0', NULL),
(185, 0, [[timestamp]], 'enrol_guest', 'showhint', '0', NULL),
(186, 0, [[timestamp]], 'enrol_guest', 'defaultenrol', '1', NULL),
(187, 0, [[timestamp]], 'enrol_guest', 'status', '1', NULL),
(188, 0, [[timestamp]], 'enrol_guest', 'status_adv', '0', NULL),
(189, 0, [[timestamp]], 'enrol_imsenterprise', 'imsfilelocation', '', NULL),
(190, 0, [[timestamp]], 'enrol_imsenterprise', 'logtolocation', '', NULL),
(191, 0, [[timestamp]], 'enrol_imsenterprise', 'mailadmins', '0', NULL),
(192, 0, [[timestamp]], 'enrol_imsenterprise', 'createnewusers', '0', NULL),
(193, 0, [[timestamp]], 'enrol_imsenterprise', 'imsdeleteusers', '0', NULL),
(194, 0, [[timestamp]], 'enrol_imsenterprise', 'fixcaseusernames', '0', NULL),
(195, 0, [[timestamp]], 'enrol_imsenterprise', 'fixcasepersonalnames', '0', NULL),
(196, 0, [[timestamp]], 'enrol_imsenterprise', 'imssourcedidfallback', '0', NULL),
(197, 0, [[timestamp]], 'enrol_imsenterprise', 'truncatecoursecodes', '0', NULL),
(198, 0, [[timestamp]], 'enrol_imsenterprise', 'createnewcourses', '0', NULL),
(199, 0, [[timestamp]], 'enrol_imsenterprise', 'createnewcategories', '0', NULL),
(200, 0, [[timestamp]], 'enrol_imsenterprise', 'imsunenrol', '0', NULL),
(201, 0, [[timestamp]], 'enrol_imsenterprise', 'imsrestricttarget', '', NULL),
(202, 0, [[timestamp]], 'enrol_imsenterprise', 'imscapitafix', '0', NULL),
(203, 0, [[timestamp]], 'enrol_manual', 'defaultenrol', '1', NULL),
(204, 0, [[timestamp]], 'enrol_manual', 'status', '0', NULL),
(205, 0, [[timestamp]], 'enrol_manual', 'enrolperiod', '0', NULL),
(206, 0, [[timestamp]], 'enrol_paypal', 'paypalbusiness', '', NULL),
(207, 0, [[timestamp]], 'enrol_paypal', 'mailstudents', '0', NULL),
(208, 0, [[timestamp]], 'enrol_paypal', 'mailteachers', '0', NULL),
(209, 0, [[timestamp]], 'enrol_paypal', 'mailadmins', '0', NULL),
(210, 0, [[timestamp]], 'enrol_paypal', 'status', '1', NULL),
(211, 0, [[timestamp]], 'enrol_paypal', 'cost', '0', NULL),
(212, 0, [[timestamp]], 'enrol_paypal', 'currency', 'USD', NULL),
(213, 0, [[timestamp]], 'enrol_paypal', 'enrolperiod', '0', NULL),
(214, 0, [[timestamp]], 'enrol_self', 'requirepassword', '0', NULL),
(215, 0, [[timestamp]], 'enrol_self', 'usepasswordpolicy', '0', NULL),
(216, 0, [[timestamp]], 'enrol_self', 'showhint', '0', NULL),
(217, 0, [[timestamp]], 'enrol_self', 'defaultenrol', '1', NULL),
(218, 0, [[timestamp]], 'enrol_self', 'status', '1', NULL),
(219, 0, [[timestamp]], 'enrol_self', 'groupkey', '0', NULL),
(220, 0, [[timestamp]], 'enrol_self', 'enrolperiod', '0', NULL),
(221, 0, [[timestamp]], 'enrol_self', 'longtimenosee', '0', NULL),
(222, 0, [[timestamp]], 'enrol_self', 'maxenrolled', '0', NULL),
(223, 0, [[timestamp]], 'enrol_self', 'sendcoursewelcomemessage', '1', NULL),
(224, 0, [[timestamp]], 'editor_tinymce', 'spellengine', 'GoogleSpell', NULL),
(225, 0, [[timestamp]], NULL, 'sitedefaultlicense', 'allrightsreserved', NULL),
(226, 0, [[timestamp]], NULL, 'cachetext', '60', NULL),
(227, 0, [[timestamp]], NULL, 'filteruploadedfiles', '0', NULL),
(228, 0, [[timestamp]], NULL, 'filtermatchoneperpage', '0', NULL),
(229, 0, [[timestamp]], NULL, 'filtermatchonepertext', '0', NULL),
(230, 0, [[timestamp]], 'filter_urltolink', 'formats', '0', NULL),
(231, 0, [[timestamp]], 'filter_urltolink', 'embedimages', '1', NULL),
(232, 0, [[timestamp]], 'filter_emoticon', 'formats', '1,4,0', NULL),
(233, 0, [[timestamp]], NULL, 'filter_multilang_force_old', '0', NULL),
(234, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_youtube', '1', NULL),
(235, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_vimeo', '0', NULL),
(236, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_mp3', '1', NULL),
(237, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_flv', '1', NULL),
(238, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_swf', '1', NULL),
(239, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_html5audio', '0', NULL),
(240, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_html5video', '0', NULL),
(241, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_qt', '1', NULL),
(242, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_wmp', '1', NULL),
(243, 0, [[timestamp]], NULL, 'filter_mediaplugin_enable_rm', '1', NULL),
(244, 0, [[timestamp]], NULL, 'filter_tex_latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n', NULL),
(245, 0, [[timestamp]], NULL, 'filter_tex_latexbackground', '#FFFFFF', NULL),
(246, 0, [[timestamp]], NULL, 'filter_tex_density', '120', NULL),
(247, 0, [[timestamp]], NULL, 'filter_tex_pathlatex', '/usr/bin/latex', NULL),
(248, 0, [[timestamp]], NULL, 'filter_tex_pathdvips', '/usr/bin/dvips', NULL),
(249, 0, [[timestamp]], NULL, 'filter_tex_pathconvert', '/usr/bin/convert', NULL),
(250, 0, [[timestamp]], NULL, 'filter_tex_convertformat', 'gif', NULL),
(251, 0, [[timestamp]], NULL, 'filter_censor_badwords', '', NULL),
(252, 0, [[timestamp]], NULL, 'portfolio_moderate_filesize_threshold', '1048576', NULL),
(253, 0, [[timestamp]], NULL, 'portfolio_high_filesize_threshold', '5242880', NULL),
(254, 0, [[timestamp]], NULL, 'portfolio_moderate_db_threshold', '20', NULL),
(255, 0, [[timestamp]], NULL, 'portfolio_high_db_threshold', '50', NULL),
(256, 0, [[timestamp]], NULL, 'repositorycacheexpire', '120', NULL),
(257, 0, [[timestamp]], NULL, 'repositoryallowexternallinks', '1', NULL),
(258, 0, [[timestamp]], NULL, 'legacyfilesinnewcourses', '0', NULL),
(259, 0, [[timestamp]], NULL, 'enablewsdocumentation', '0', NULL),
(260, 0, [[timestamp]], NULL, 'allowbeforeblock', '0', NULL),
(261, 0, [[timestamp]], NULL, 'allowedip', '', NULL),
(262, 0, [[timestamp]], NULL, 'blockedip', '', NULL),
(263, 0, [[timestamp]], NULL, 'protectusernames', '1', NULL),
(264, 0, [[timestamp]], NULL, 'forcelogin', '0', NULL),
(265, 0, [[timestamp]], NULL, 'forceloginforprofiles', '1', NULL),
(266, 0, [[timestamp]], NULL, 'forceloginforprofileimage', '0', NULL),
(267, 0, [[timestamp]], NULL, 'opentogoogle', '0', NULL),
(268, 0, [[timestamp]], NULL, 'maxbytes', '0', NULL),
(269, 0, [[timestamp]], NULL, 'userquota', '104857600', NULL),
(270, 0, [[timestamp]], NULL, 'enablehtmlpurifier', '1', NULL),
(271, 0, [[timestamp]], NULL, 'allowobjectembed', '0', NULL),
(272, 0, [[timestamp]], NULL, 'enabletrusttext', '0', NULL),
(273, 0, [[timestamp]], NULL, 'maxeditingtime', '1800', NULL),
(274, 0, [[timestamp]], NULL, 'fullnamedisplay', 'language', NULL),
(275, 0, [[timestamp]], NULL, 'extendedusernamechars', '0', NULL),
(276, 0, [[timestamp]], NULL, 'sitepolicy', '', NULL),
(277, 0, [[timestamp]], NULL, 'sitepolicyguest', '', NULL),
(278, 0, [[timestamp]], NULL, 'keeptagnamecase', '1', NULL),
(279, 0, [[timestamp]], NULL, 'profilesforenrolledusersonly', '1', NULL),
(280, 0, [[timestamp]], NULL, 'cronclionly', '0', NULL),
(281, 0, [[timestamp]], NULL, 'cronremotepassword', '', NULL),
(282, 0, [[timestamp]], NULL, 'passwordpolicy', '1', NULL),
(283, 0, [[timestamp]], NULL, 'minpasswordlength', '8', NULL),
(284, 0, [[timestamp]], NULL, 'minpassworddigits', '1', NULL),
(285, 0, [[timestamp]], NULL, 'minpasswordlower', '1', NULL),
(286, 0, [[timestamp]], NULL, 'minpasswordupper', '1', NULL),
(287, 0, [[timestamp]], NULL, 'minpasswordnonalphanum', '1', NULL),
(288, 0, [[timestamp]], NULL, 'maxconsecutiveidentchars', '0', NULL),
(289, 0, [[timestamp]], NULL, 'groupenrolmentkeypolicy', '1', NULL),
(290, 0, [[timestamp]], NULL, 'disableuserimages', '0', NULL),
(291, 0, [[timestamp]], NULL, 'emailchangeconfirmation', '1', NULL),
(292, 0, [[timestamp]], NULL, 'strictformsrequired', '0', NULL),
(293, 0, [[timestamp]], NULL, 'loginhttps', '0', NULL),
(294, 0, [[timestamp]], NULL, 'cookiesecure', '0', NULL),
(295, 0, [[timestamp]], NULL, 'cookiehttponly', '0', NULL),
(296, 0, [[timestamp]], NULL, 'excludeoldflashclients', '10.0.12', NULL),
(297, 0, [[timestamp]], NULL, 'loginpasswordautocomplete', '0', NULL),
(298, 0, [[timestamp]], NULL, 'restrictmodulesfor', 'none', NULL),
(299, 0, [[timestamp]], NULL, 'restrictbydefault', '0', NULL),
(300, 0, [[timestamp]], NULL, 'displayloginfailures', '', NULL),
(301, 0, [[timestamp]], NULL, 'notifyloginfailures', '', NULL),
(302, 0, [[timestamp]], NULL, 'notifyloginthreshold', '10', NULL),
(303, 0, [[timestamp]], NULL, 'runclamonupload', '0', NULL),
(304, 0, [[timestamp]], NULL, 'pathtoclam', '', NULL),
(305, 0, [[timestamp]], NULL, 'quarantinedir', '', NULL),
(306, 0, [[timestamp]], NULL, 'clamfailureonupload', 'donothing', NULL),
(307, 0, [[timestamp]], NULL, 'themelist', '', NULL),
(308, 0, [[timestamp]], NULL, 'themedesignermode', '0', NULL),
(309, 0, [[timestamp]], NULL, 'allowuserthemes', '0', NULL),
(310, 0, [[timestamp]], NULL, 'allowcoursethemes', '0', NULL),
(311, 0, [[timestamp]], NULL, 'allowcategorythemes', '0', NULL),
(312, 0, [[timestamp]], NULL, 'allowthemechangeonurl', '0', NULL),
(313, 0, [[timestamp]], NULL, 'allowuserblockhiding', '1', NULL),
(314, 0, [[timestamp]], NULL, 'allowblockstodock', '1', NULL),
(315, 0, [[timestamp]], NULL, 'custommenuitems', '', NULL),
(316, 0, [[timestamp]], 'theme_arialist', 'logo', '', NULL),
(317, 0, [[timestamp]], 'theme_arialist', 'tagline', '', NULL),
(318, 0, [[timestamp]], 'theme_arialist', 'linkcolor', '#f25f0f', NULL),
(319, 0, [[timestamp]], 'theme_arialist', 'regionwidth', '250', NULL),
(320, 0, [[timestamp]], 'theme_arialist', 'customcss', '', NULL),
(321, 0, [[timestamp]], 'theme_brick', 'logo', '', NULL),
(322, 0, [[timestamp]], 'theme_brick', 'linkcolor', '#06365b', NULL),
(323, 0, [[timestamp]], 'theme_brick', 'linkhover', '#5487ad', NULL),
(324, 0, [[timestamp]], 'theme_brick', 'maincolor', '#8e2800', NULL),
(325, 0, [[timestamp]], 'theme_brick', 'maincolorlink', '#fff0a5', NULL),
(326, 0, [[timestamp]], 'theme_brick', 'headingcolor', '#5c3500', NULL),
(327, 0, [[timestamp]], 'theme_formal_white', 'fontsizereference', '13', NULL),
(328, 0, [[timestamp]], 'theme_formal_white', 'noframe', '0', NULL),
(329, 0, [[timestamp]], 'theme_formal_white', 'displaylogo', '1', NULL),
(330, 0, [[timestamp]], 'theme_formal_white', 'logo', '', NULL),
(331, 0, [[timestamp]], 'theme_formal_white', 'headerbgc', '#E3DFD4', NULL),
(332, 0, [[timestamp]], 'theme_formal_white', 'blockcontentbgc', '#F6F6F6', NULL),
(333, 0, [[timestamp]], 'theme_formal_white', 'lblockcolumnbgc', '#E3DFD4', NULL),
(334, 0, [[timestamp]], 'theme_formal_white', 'rblockcolumnbgc', '', NULL),
(335, 0, [[timestamp]], 'theme_formal_white', 'blockcolumnwidth', '200', NULL),
(336, 0, [[timestamp]], 'theme_formal_white', 'footnote', '', NULL),
(337, 0, [[timestamp]], 'theme_formal_white', 'customcss', '', NULL),
(338, 0, [[timestamp]], 'theme_fusion', 'linkcolor', '#2d83d5', NULL),
(339, 0, [[timestamp]], 'theme_fusion', 'tagline', '', NULL),
(340, 0, [[timestamp]], 'theme_fusion', 'footertext', '', NULL),
(341, 0, [[timestamp]], 'theme_fusion', 'customcss', '', NULL),
(342, 0, [[timestamp]], 'theme_magazine', 'background', '', NULL),
(343, 0, [[timestamp]], 'theme_magazine', 'logo', '', NULL),
(344, 0, [[timestamp]], 'theme_magazine', 'linkcolor', '#32529a', NULL),
(345, 0, [[timestamp]], 'theme_magazine', 'linkhover', '#4e2300', NULL),
(346, 0, [[timestamp]], 'theme_magazine', 'maincolor', '#002f2f', NULL),
(347, 0, [[timestamp]], 'theme_magazine', 'maincoloraccent', '#092323', NULL),
(348, 0, [[timestamp]], 'theme_magazine', 'headingcolor', '#4e0000', NULL),
(349, 0, [[timestamp]], 'theme_magazine', 'blockcolor', '#002f2f', NULL),
(350, 0, [[timestamp]], 'theme_magazine', 'forumback', '#e6e2af', NULL),
(351, 0, [[timestamp]], 'theme_nimble', 'tagline', '', NULL),
(352, 0, [[timestamp]], 'theme_nimble', 'footerline', '', NULL),
(353, 0, [[timestamp]], 'theme_nimble', 'backgroundcolor', '#454545', NULL),
(354, 0, [[timestamp]], 'theme_nimble', 'linkcolor', '#2a65b1', NULL),
(355, 0, [[timestamp]], 'theme_nimble', 'linkhover', '#222222', NULL),
(356, 0, [[timestamp]], 'theme_nonzero', 'regionprewidth', '200', NULL),
(357, 0, [[timestamp]], 'theme_nonzero', 'regionpostwidth', '200', NULL),
(358, 0, [[timestamp]], 'theme_nonzero', 'customcss', '', NULL),
(359, 0, [[timestamp]], 'theme_overlay', 'linkcolor', '#428ab5', NULL),
(360, 0, [[timestamp]], 'theme_overlay', 'headercolor', '#2a4c7b', NULL),
(361, 0, [[timestamp]], 'theme_overlay', 'footertext', '', NULL),
(362, 0, [[timestamp]], 'theme_overlay', 'customcss', '', NULL),
(363, 0, [[timestamp]], 'theme_sky_high', 'logo', '', NULL),
(364, 0, [[timestamp]], 'theme_sky_high', 'regionwidth', '240', NULL),
(365, 0, [[timestamp]], 'theme_sky_high', 'footnote', '', NULL),
(366, 0, [[timestamp]], 'theme_sky_high', 'customcss', '', NULL),
(367, 0, [[timestamp]], 'theme_splash', 'logo', '', NULL),
(368, 0, [[timestamp]], 'theme_splash', 'tagline', 'Virtual learning center', NULL),
(369, 0, [[timestamp]], 'theme_splash', 'hide_tagline', '0', NULL),
(370, 0, [[timestamp]], 'theme_splash', 'footnote', '', NULL),
(371, 0, [[timestamp]], 'theme_splash', 'customcss', '', NULL),
(372, 0, [[timestamp]], NULL, 'calendar_adminseesall', '0', NULL),
(373, 0, [[timestamp]], NULL, 'calendar_site_timeformat', '0', NULL),
(374, 0, [[timestamp]], NULL, 'calendar_startwday', '0', NULL),
(375, 0, [[timestamp]], NULL, 'calendar_weekend', '65', NULL),
(376, 0, [[timestamp]], NULL, 'calendar_lookahead', '21', NULL),
(377, 0, [[timestamp]], NULL, 'calendar_maxevents', '10', NULL),
(378, 0, [[timestamp]], NULL, 'enablecalendarexport', '1', NULL),
(379, 0, [[timestamp]], NULL, 'calendar_exportsalt', '[[export_salt]]', NULL),
(380, 0, [[timestamp]], NULL, 'useblogassociations', '1', NULL),
(381, 0, [[timestamp]], NULL, 'useexternalblogs', '1', NULL),
(382, 0, [[timestamp]], NULL, 'externalblogcrontime', '86400', NULL),
(383, 0, [[timestamp]], NULL, 'maxexternalblogsperuser', '1', NULL),
(384, 0, [[timestamp]], NULL, 'blogusecomments', '1', NULL),
(385, 0, [[timestamp]], NULL, 'blogshowcommentscount', '1', NULL),
(386, 0, [[timestamp]], NULL, 'defaulthomepage', '0', NULL),
(387, 0, [[timestamp]], NULL, 'navshowcategories', '1', NULL),
(388, 0, [[timestamp]], NULL, 'navshowallcourses', '0', NULL),
(389, 0, [[timestamp]], NULL, 'navcourselimit', '20', NULL),
(390, 0, [[timestamp]], NULL, 'formatstringstriptags', '1', NULL),
(391, 0, [[timestamp]], NULL, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]', NULL),
(392, 0, [[timestamp]], NULL, 'docroot', 'http://docs.moodle.org', NULL),
(393, 0, [[timestamp]], NULL, 'doctonewwindow', '0', NULL),
(394, 0, [[timestamp]], NULL, 'enableajax', '1', NULL),
(395, 0, [[timestamp]], NULL, 'useexternalyui', '0', NULL),
(396, 0, [[timestamp]], NULL, 'yuicomboloading', '1', NULL),
(397, 0, [[timestamp]], NULL, 'cachejs', '1', NULL),
(398, 0, [[timestamp]], NULL, 'enablecourseajax', '1', NULL),
(399, 0, [[timestamp]], NULL, 'additionalhtmlhead', '', NULL),
(400, 0, [[timestamp]], NULL, 'additionalhtmltopofbody', '', NULL),
(401, 0, [[timestamp]], NULL, 'additionalhtmlfooter', '', NULL),
(402, 0, [[timestamp]], NULL, 'gdversion', '2', NULL),
(403, 0, [[timestamp]], NULL, 'pathtodu', '', NULL),
(404, 0, [[timestamp]], NULL, 'aspellpath', '', NULL),
(405, 0, [[timestamp]], NULL, 'pathtodot', '', NULL),
(406, 0, [[timestamp]], NULL, 'smtphosts', '', NULL),
(407, 0, [[timestamp]], NULL, 'smtpuser', '', NULL),
(408, 0, [[timestamp]], NULL, 'smtppass', '', NULL),
(409, 0, [[timestamp]], NULL, 'smtpmaxbulk', '1', NULL),
(410, 0, [[timestamp]], NULL, 'noreplyaddress', 'noreply@[[domhost]]', NULL),
(411, 0, [[timestamp]], NULL, 'digestmailtime', '17', NULL),
(412, 0, [[timestamp]], NULL, 'sitemailcharset', '0', NULL),
(413, 0, [[timestamp]], NULL, 'allowusermailcharset', '0', NULL),
(414, 0, [[timestamp]], NULL, 'mailnewline', 'LF', NULL),
(415, 0, [[timestamp]], NULL, 'supportpage', '', NULL),
(416, 0, [[timestamp]], NULL, 'jabberhost', '', NULL),
(417, 0, [[timestamp]], NULL, 'jabberserver', '', NULL),
(418, 0, [[timestamp]], NULL, 'jabberusername', '', NULL),
(419, 0, [[timestamp]], NULL, 'jabberpassword', '', NULL),
(420, 0, [[timestamp]], NULL, 'jabberport', '5222', NULL),
(421, 0, [[timestamp]], NULL, 'dbsessions', '1', NULL),
(422, 0, [[timestamp]], NULL, 'sessioncookie', '', NULL),
(423, 0, [[timestamp]], NULL, 'sessioncookiepath', '/', NULL),
(424, 0, [[timestamp]], NULL, 'sessioncookiedomain', '', NULL),
(425, 0, [[timestamp]], NULL, 'statsfirstrun', 'none', NULL),
(426, 0, [[timestamp]], NULL, 'statsmaxruntime', '0', NULL),
(427, 0, [[timestamp]], NULL, 'statsruntimedays', '31', NULL),
(428, 0, [[timestamp]], NULL, 'statsruntimestarthour', '0', NULL),
(429, 0, [[timestamp]], NULL, 'statsruntimestartminute', '0', NULL),
(430, 0, [[timestamp]], NULL, 'statsuserthreshold', '0', NULL),
(431, 0, [[timestamp]], NULL, 'framename', '_top', NULL),
(432, 0, [[timestamp]], NULL, 'slasharguments', '1', NULL),
(433, 0, [[timestamp]], NULL, 'getremoteaddrconf', '0', NULL),
(434, 0, [[timestamp]], NULL, 'proxyhost', '', NULL),
(435, 0, [[timestamp]], NULL, 'proxyport', '0', NULL),
(436, 0, [[timestamp]], NULL, 'proxytype', 'HTTP', NULL),
(437, 0, [[timestamp]], NULL, 'proxyuser', '', NULL),
(438, 0, [[timestamp]], NULL, 'proxypassword', '', NULL),
(439, 0, [[timestamp]], NULL, 'proxybypass', 'localhost, [[clientip]]', NULL),
(440, 0, [[timestamp]], NULL, 'maintenance_enabled', '0', NULL),
(441, 0, [[timestamp]], NULL, 'maintenance_message', '', NULL),
(442, 0, [[timestamp]], NULL, 'deleteunconfirmed', '168', NULL),
(443, 0, [[timestamp]], NULL, 'deleteincompleteusers', '0', NULL),
(444, 0, [[timestamp]], NULL, 'logguests', '1', NULL),
(445, 0, [[timestamp]], NULL, 'loglifetime', '0', NULL),
(446, 0, [[timestamp]], NULL, 'disablegradehistory', '0', NULL),
(447, 0, [[timestamp]], NULL, 'gradehistorylifetime', '0', NULL),
(448, 0, [[timestamp]], NULL, 'numcoursesincombo', '500', NULL),
(449, 0, [[timestamp]], NULL, 'extramemorylimit', '512M', NULL),
(450, 0, [[timestamp]], NULL, 'curlcache', '120', NULL),
(451, 0, [[timestamp]], NULL, 'curltimeoutkbitrate', '56', NULL),
(452, 0, [[timestamp]], NULL, 'enableglobalsearch', '0', NULL),
(453, 0, [[timestamp]], NULL, 'enablesafebrowserintegration', '0', NULL),
(454, 0, [[timestamp]], NULL, 'enablegroupmembersonly', '0', NULL),
(455, 0, [[timestamp]], NULL, 'debug', '0', NULL),
(456, 0, [[timestamp]], NULL, 'debugdisplay', '1', NULL),
(457, 0, [[timestamp]], NULL, 'xmlstrictheaders', '0', NULL),
(458, 0, [[timestamp]], NULL, 'debugsmtp', '0', NULL),
(459, 0, [[timestamp]], NULL, 'perfdebug', '7', NULL),
(460, 0, [[timestamp]], NULL, 'debugstringids', '0', NULL),
(461, 0, [[timestamp]], NULL, 'debugvalidators', '0', NULL),
(462, 0, [[timestamp]], NULL, 'debugpageinfo', '0', NULL),
(463, 2, [[timestamp]], NULL, 'notloggedinroleid', '6', NULL),
(464, 2, [[timestamp]], NULL, 'guestroleid', '6', NULL),
(465, 2, [[timestamp]], NULL, 'defaultuserroleid', '7', NULL),
(466, 2, [[timestamp]], NULL, 'creatornewroleid', '3', NULL),
(467, 2, [[timestamp]], NULL, 'gradebookroles', '5', NULL),
(468, 2, [[timestamp]], NULL, 'assignment_maxbytes', '1048576', NULL),
(469, 2, [[timestamp]], NULL, 'assignment_itemstocount', '1', NULL),
(470, 2, [[timestamp]], NULL, 'assignment_showrecentsubmissions', '1', NULL),
(471, 2, [[timestamp]], NULL, 'chat_method', 'ajax', NULL),
(472, 2, [[timestamp]], NULL, 'chat_refresh_userlist', '10', NULL),
(473, 2, [[timestamp]], NULL, 'chat_old_ping', '35', NULL),
(474, 2, [[timestamp]], NULL, 'chat_refresh_room', '5', NULL),
(475, 2, [[timestamp]], NULL, 'chat_normal_updatemode', 'jsupdate', NULL),
(476, 2, [[timestamp]], NULL, 'chat_serverhost', '[[domhost]]', NULL),
(477, 2, [[timestamp]], NULL, 'chat_serverip', '[[clientip]]', NULL),
(478, 2, [[timestamp]], NULL, 'chat_serverport', '9111', NULL),
(479, 2, [[timestamp]], NULL, 'chat_servermax', '100', NULL),
(480, 2, [[timestamp]], NULL, 'data_enablerssfeeds', '0', NULL),
(481, 2, [[timestamp]], NULL, 'feedback_allowfullanonymous', '0', NULL),
(482, 2, [[timestamp]], 'folder', 'requiremodintro', '1', NULL),
(483, 2, [[timestamp]], NULL, 'forum_displaymode', '3', NULL),
(484, 2, [[timestamp]], NULL, 'forum_replytouser', '1', NULL),
(485, 2, [[timestamp]], NULL, 'forum_shortpost', '300', NULL),
(486, 2, [[timestamp]], NULL, 'forum_longpost', '600', NULL),
(487, 2, [[timestamp]], NULL, 'forum_manydiscussions', '100', NULL),
(488, 2, [[timestamp]], NULL, 'forum_maxbytes', '512000', NULL),
(489, 2, [[timestamp]], NULL, 'forum_maxattachments', '9', NULL),
(490, 2, [[timestamp]], NULL, 'forum_trackreadposts', '1', NULL),
(491, 2, [[timestamp]], NULL, 'forum_oldpostdays', '14', NULL),
(492, 2, [[timestamp]], NULL, 'forum_usermarksread', '0', NULL),
(493, 2, [[timestamp]], NULL, 'forum_cleanreadtime', '2', NULL),
(494, 2, [[timestamp]], NULL, 'forum_enablerssfeeds', '0', NULL),
(495, 2, [[timestamp]], NULL, 'forum_enabletimedposts', '0', NULL),
(496, 2, [[timestamp]], NULL, 'glossary_entbypage', '10', NULL),
(497, 2, [[timestamp]], NULL, 'glossary_dupentries', '0', NULL),
(498, 2, [[timestamp]], NULL, 'glossary_allowcomments', '0', NULL),
(499, 2, [[timestamp]], NULL, 'glossary_linkbydefault', '1', NULL),
(500, 2, [[timestamp]], NULL, 'glossary_defaultapproval', '1', NULL),
(501, 2, [[timestamp]], NULL, 'glossary_enablerssfeeds', '0', NULL),
(502, 2, [[timestamp]], NULL, 'glossary_linkentries', '0', NULL),
(503, 2, [[timestamp]], NULL, 'glossary_casesensitive', '0', NULL),
(504, 2, [[timestamp]], NULL, 'glossary_fullmatch', '0', NULL),
(505, 2, [[timestamp]], 'imscp', 'requiremodintro', '1', NULL),
(506, 2, [[timestamp]], 'imscp', 'keepold', '1', NULL),
(507, 2, [[timestamp]], 'imscp', 'keepold_adv', '0', NULL),
(508, 2, [[timestamp]], NULL, 'lesson_slideshowwidth', '640', NULL),
(509, 2, [[timestamp]], NULL, 'lesson_slideshowheight', '480', NULL),
(510, 2, [[timestamp]], NULL, 'lesson_slideshowbgcolor', '#FFFFFF', NULL),
(511, 2, [[timestamp]], NULL, 'lesson_mediawidth', '640', NULL),
(512, 2, [[timestamp]], NULL, 'lesson_mediaheight', '480', NULL),
(513, 2, [[timestamp]], NULL, 'lesson_mediaclose', '0', NULL),
(514, 2, [[timestamp]], NULL, 'lesson_maxhighscores', '10', NULL),
(515, 2, [[timestamp]], NULL, 'lesson_maxanswers', '4', NULL),
(516, 2, [[timestamp]], NULL, 'lesson_defaultnextpage', '0', NULL),
(517, 2, [[timestamp]], 'page', 'requiremodintro', '1', NULL),
(518, 2, [[timestamp]], 'page', 'displayoptions', '5', NULL),
(519, 2, [[timestamp]], 'page', 'printheading', '1', NULL),
(520, 2, [[timestamp]], 'page', 'printheading_adv', '0', NULL),
(521, 2, [[timestamp]], 'page', 'printintro', '0', NULL),
(522, 2, [[timestamp]], 'page', 'printintro_adv', '0', NULL),
(523, 2, [[timestamp]], 'page', 'display', '5', NULL),
(524, 2, [[timestamp]], 'page', 'display_adv', '1', NULL),
(525, 2, [[timestamp]], 'page', 'popupwidth', '620', NULL),
(526, 2, [[timestamp]], 'page', 'popupwidth_adv', '1', NULL),
(527, 2, [[timestamp]], 'page', 'popupheight', '450', NULL),
(528, 2, [[timestamp]], 'page', 'popupheight_adv', '1', NULL),
(529, 2, [[timestamp]], 'quiz', 'timelimit', '0', NULL),
(530, 2, [[timestamp]], 'quiz', 'timelimit_adv', '0', NULL),
(531, 2, [[timestamp]], 'quiz', 'attempts', '0', NULL),
(532, 2, [[timestamp]], 'quiz', 'attempts_adv', '0', NULL),
(533, 2, [[timestamp]], 'quiz', 'grademethod', '1', NULL),
(534, 2, [[timestamp]], 'quiz', 'grademethod_adv', '0', NULL),
(535, 2, [[timestamp]], 'quiz', 'maximumgrade', '10', NULL),
(536, 2, [[timestamp]], 'quiz', 'shufflequestions', '0', NULL),
(537, 2, [[timestamp]], 'quiz', 'shufflequestions_adv', '0', NULL),
(538, 2, [[timestamp]], 'quiz', 'questionsperpage', '1', NULL),
(539, 2, [[timestamp]], 'quiz', 'questionsperpage_adv', '0', NULL),
(540, 2, [[timestamp]], 'quiz', 'shuffleanswers', '1', NULL),
(541, 2, [[timestamp]], 'quiz', 'shuffleanswers_adv', '0', NULL),
(542, 2, [[timestamp]], 'quiz', 'optionflags', '1', NULL),
(543, 2, [[timestamp]], 'quiz', 'optionflags_adv', '0', NULL),
(544, 2, [[timestamp]], 'quiz', 'penaltyscheme', '1', NULL),
(545, 2, [[timestamp]], 'quiz', 'penaltyscheme_adv', '1', NULL),
(546, 2, [[timestamp]], 'quiz', 'attemptonlast', '0', NULL),
(547, 2, [[timestamp]], 'quiz', 'attemptonlast_adv', '1', NULL),
(548, 2, [[timestamp]], 'quiz', 'review', '1073741823', NULL),
(549, 2, [[timestamp]], 'quiz', 'review_adv', '0', NULL),
(550, 2, [[timestamp]], 'quiz', 'showuserpicture', '0', NULL),
(551, 2, [[timestamp]], 'quiz', 'showuserpicture_adv', '0', NULL),
(552, 2, [[timestamp]], 'quiz', 'decimalpoints', '2', NULL),
(553, 2, [[timestamp]], 'quiz', 'decimalpoints_adv', '0', NULL),
(554, 2, [[timestamp]], 'quiz', 'questiondecimalpoints', '-1', NULL),
(555, 2, [[timestamp]], 'quiz', 'questiondecimalpoints_adv', '0', NULL),
(556, 2, [[timestamp]], 'quiz', 'showblocks', '0', NULL),
(557, 2, [[timestamp]], 'quiz', 'showblocks_adv', '1', NULL),
(558, 2, [[timestamp]], 'quiz', 'password', '', NULL),
(559, 2, [[timestamp]], 'quiz', 'password_adv', '0', NULL),
(560, 2, [[timestamp]], 'quiz', 'subnet', '', NULL),
(561, 2, [[timestamp]], 'quiz', 'subnet_adv', '0', NULL),
(562, 2, [[timestamp]], 'quiz', 'delay1', '0', NULL),
(563, 2, [[timestamp]], 'quiz', 'delay1_adv', '0', NULL),
(564, 2, [[timestamp]], 'quiz', 'delay2', '0', NULL),
(565, 2, [[timestamp]], 'quiz', 'delay2_adv', '0', NULL),
(566, 2, [[timestamp]], 'quiz', 'popup', '0', NULL),
(567, 2, [[timestamp]], 'quiz', 'popup_adv', '1', NULL),
(568, 2, [[timestamp]], 'resource', 'framesize', '130', NULL),
(569, 2, [[timestamp]], 'resource', 'requiremodintro', '1', NULL),
(570, 2, [[timestamp]], 'resource', 'displayoptions', '0,1,4,5,6', NULL),
(571, 2, [[timestamp]], 'resource', 'printheading', '0', NULL),
(572, 2, [[timestamp]], 'resource', 'printheading_adv', '0', NULL),
(573, 2, [[timestamp]], 'resource', 'printintro', '1', NULL),
(574, 2, [[timestamp]], 'resource', 'printintro_adv', '0', NULL),
(575, 2, [[timestamp]], 'resource', 'display', '0', NULL),
(576, 2, [[timestamp]], 'resource', 'display_adv', '0', NULL),
(577, 2, [[timestamp]], 'resource', 'popupwidth', '620', NULL),
(578, 2, [[timestamp]], 'resource', 'popupwidth_adv', '1', NULL),
(579, 2, [[timestamp]], 'resource', 'popupheight', '450', NULL),
(580, 2, [[timestamp]], 'resource', 'popupheight_adv', '1', NULL),
(581, 2, [[timestamp]], 'resource', 'filterfiles', '0', NULL),
(582, 2, [[timestamp]], 'resource', 'filterfiles_adv', '1', NULL),
(583, 2, [[timestamp]], 'scorm', 'grademethod', '1', NULL),
(584, 2, [[timestamp]], 'scorm', 'maxgrade', '100', NULL),
(585, 2, [[timestamp]], 'scorm', 'maxattempts', '0', NULL),
(586, 2, [[timestamp]], 'scorm', 'displayattemptstatus', '0', NULL),
(587, 2, [[timestamp]], 'scorm', 'displaycoursestructure', '0', NULL),
(588, 2, [[timestamp]], 'scorm', 'forcecompleted', '0', NULL),
(589, 2, [[timestamp]], 'scorm', 'forcenewattempt', '0', NULL),
(590, 2, [[timestamp]], 'scorm', 'lastattemptlock', '0', NULL),
(591, 2, [[timestamp]], 'scorm', 'whatgrade', '0', NULL),
(592, 2, [[timestamp]], 'scorm', 'framewidth', '100', NULL),
(593, 2, [[timestamp]], 'scorm', 'frameheight', '500', NULL),
(594, 2, [[timestamp]], 'scorm', 'popup', '0', NULL),
(595, 2, [[timestamp]], 'scorm', 'resizable', '0', NULL),
(596, 2, [[timestamp]], 'scorm', 'scrollbars', '0', NULL),
(597, 2, [[timestamp]], 'scorm', 'directories', '0', NULL),
(598, 2, [[timestamp]], 'scorm', 'location', '0', NULL),
(599, 2, [[timestamp]], 'scorm', 'menubar', '0', NULL),
(600, 2, [[timestamp]], 'scorm', 'toolbar', '0', NULL),
(601, 2, [[timestamp]], 'scorm', 'status', '0', NULL),
(602, 2, [[timestamp]], 'scorm', 'skipview', '0', NULL),
(603, 2, [[timestamp]], 'scorm', 'hidebrowse', '0', NULL),
(604, 2, [[timestamp]], 'scorm', 'hidetoc', '0', NULL),
(605, 2, [[timestamp]], 'scorm', 'hidenav', '0', NULL),
(606, 2, [[timestamp]], 'scorm', 'auto', '0', NULL),
(607, 2, [[timestamp]], 'scorm', 'updatefreq', '0', NULL),
(608, 2, [[timestamp]], 'scorm', 'allowtypeexternal', '0', NULL),
(609, 2, [[timestamp]], 'scorm', 'allowtypelocalsync', '0', NULL),
(610, 2, [[timestamp]], 'scorm', 'allowtypeimsrepository', '0', NULL),
(611, 2, [[timestamp]], 'scorm', 'forcejavascript', '1', NULL),
(612, 2, [[timestamp]], 'scorm', 'allowapidebug', '0', NULL),
(613, 2, [[timestamp]], 'scorm', 'apidebugmask', '.*', NULL),
(614, 2, [[timestamp]], 'url', 'framesize', '130', NULL),
(615, 2, [[timestamp]], 'url', 'requiremodintro', '1', NULL),
(616, 2, [[timestamp]], 'url', 'secretphrase', '', NULL),
(617, 2, [[timestamp]], 'url', 'rolesinparams', '0', NULL),
(618, 2, [[timestamp]], 'url', 'displayoptions', '0,1,5,6', NULL),
(619, 2, [[timestamp]], 'url', 'printheading', '0', NULL),
(620, 2, [[timestamp]], 'url', 'printheading_adv', '0', NULL),
(621, 2, [[timestamp]], 'url', 'printintro', '1', NULL),
(622, 2, [[timestamp]], 'url', 'printintro_adv', '0', NULL),
(623, 2, [[timestamp]], 'url', 'display', '0', NULL),
(624, 2, [[timestamp]], 'url', 'display_adv', '0', NULL),
(625, 2, [[timestamp]], 'url', 'popupwidth', '620', NULL),
(626, 2, [[timestamp]], 'url', 'popupwidth_adv', '1', NULL),
(627, 2, [[timestamp]], 'url', 'popupheight', '450', NULL),
(628, 2, [[timestamp]], 'url', 'popupheight_adv', '1', NULL),
(629, 2, [[timestamp]], 'workshop', 'grade', '80', NULL),
(630, 2, [[timestamp]], 'workshop', 'gradinggrade', '20', NULL),
(631, 2, [[timestamp]], 'workshop', 'gradedecimals', '0', NULL),
(632, 2, [[timestamp]], 'workshop', 'maxbytes', '0', NULL),
(633, 2, [[timestamp]], 'workshop', 'strategy', 'accumulative', NULL),
(634, 2, [[timestamp]], 'workshop', 'examplesmode', '0', NULL),
(635, 2, [[timestamp]], 'workshopallocation_random', 'numofreviews', '5', NULL),
(636, 2, [[timestamp]], 'workshopform_numerrors', 'grade0', 'No', NULL),
(637, 2, [[timestamp]], 'workshopform_numerrors', 'grade1', 'Yes', NULL),
(638, 2, [[timestamp]], 'workshopeval_best', 'comparison', '5', NULL),
(639, 2, [[timestamp]], NULL, 'block_course_list_adminview', 'all', NULL),
(640, 2, [[timestamp]], NULL, 'block_course_list_hideallcourseslink', '0', NULL),
(641, 2, [[timestamp]], NULL, 'block_online_users_timetosee', '5', NULL),
(642, 2, [[timestamp]], NULL, 'block_rss_client_num_entries', '5', NULL),
(643, 2, [[timestamp]], NULL, 'block_rss_client_timeout', '30', NULL),
(644, 2, [[timestamp]], NULL, 'block_search_enable_file_indexing', '0', NULL),
(645, 2, [[timestamp]], NULL, 'block_search_filetypes', 'PDF,TXT,HTML,PPT,XML,DOC,HTM', NULL),
(646, 2, [[timestamp]], NULL, 'block_search_usemoodleroot', '1', NULL),
(647, 2, [[timestamp]], NULL, 'block_search_limit_index_body', '0', NULL),
(648, 2, [[timestamp]], NULL, 'block_search_pdf_to_text_cmd', 'lib/xpdf/linux/pdftotext -enc UTF-8 -eol unix -q', NULL),
(649, 2, [[timestamp]], NULL, 'block_search_word_to_text_cmd', 'lib/antiword/linux/usr/bin/antiword', NULL),
(650, 2, [[timestamp]], NULL, 'block_search_word_to_text_env', 'ANTIWORDHOME=[[softpath]]/lib/antiword/linux/usr/share/antiword', NULL),
(651, 2, [[timestamp]], NULL, 'search_in_assignment', '1', NULL),
(652, 2, [[timestamp]], NULL, 'search_in_chat', '1', NULL),
(653, 2, [[timestamp]], NULL, 'search_in_data', '1', NULL),
(654, 2, [[timestamp]], NULL, 'search_in_forum', '1', NULL),
(655, 2, [[timestamp]], NULL, 'search_in_glossary', '1', NULL),
(656, 2, [[timestamp]], NULL, 'search_in_label', '1', NULL),
(657, 2, [[timestamp]], NULL, 'search_in_lesson', '1', NULL),
(658, 2, [[timestamp]], NULL, 'search_in_resource', '1', NULL),
(659, 2, [[timestamp]], NULL, 'search_in_wiki', '1', NULL),
(660, 2, [[timestamp]], 'blocks/section_links', 'numsections1', '22', NULL),
(661, 2, [[timestamp]], 'blocks/section_links', 'incby1', '2', NULL),
(662, 2, [[timestamp]], 'blocks/section_links', 'numsections2', '40', NULL),
(663, 2, [[timestamp]], 'blocks/section_links', 'incby2', '5', NULL),
(664, 2, [[timestamp]], NULL, 'block_tags_showcoursetags', '0', NULL),
(665, 2, [[timestamp]], 'enrol_cohort', 'roleid', '5', NULL),
(666, 2, [[timestamp]], 'enrol_database', 'defaultrole', '5', NULL),
(667, 2, [[timestamp]], 'enrol_database', 'defaultcategory', '1', NULL),
(668, 2, [[timestamp]], 'enrol_flatfile', 'map_1', 'manager', NULL),
(669, 2, [[timestamp]], 'enrol_flatfile', 'map_2', 'coursecreator', NULL),
(670, 2, [[timestamp]], 'enrol_flatfile', 'map_3', 'editingteacher', NULL),
(671, 2, [[timestamp]], 'enrol_flatfile', 'map_4', 'teacher', NULL),
(672, 2, [[timestamp]], 'enrol_flatfile', 'map_5', 'student', NULL),
(673, 2, [[timestamp]], 'enrol_flatfile', 'map_6', 'guest', NULL),
(674, 2, [[timestamp]], 'enrol_flatfile', 'map_7', 'user', NULL),
(675, 2, [[timestamp]], 'enrol_flatfile', 'map_8', 'frontpage', NULL),
(676, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap01', '5', NULL),
(677, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap02', '3', NULL),
(678, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap03', '3', NULL),
(679, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap04', '5', NULL),
(680, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap05', '0', NULL),
(681, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap06', '4', NULL),
(682, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap07', '0', NULL),
(683, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap08', '4', NULL),
(684, 2, [[timestamp]], 'enrol_manual', 'roleid', '5', NULL),
(685, 2, [[timestamp]], 'enrol_meta', 'nosyncroleids', '', NULL),
(686, 2, [[timestamp]], 'enrol_mnet', 'roleid', '5', NULL),
(687, 2, [[timestamp]], 'enrol_mnet', 'roleid_adv', '1', NULL),
(688, 2, [[timestamp]], 'enrol_paypal', 'roleid', '5', NULL),
(689, 2, [[timestamp]], 'enrol_self', 'roleid', '5', NULL),
(690, 2, [[timestamp]], NULL, 'profileroles', '5,4,3', NULL),
(691, 2, [[timestamp]], NULL, 'defaultallowedmodules', '', NULL),
(692, 2, [[timestamp]], NULL, 'coursecontact', '3', NULL),
(693, 2, [[timestamp]], NULL, 'frontpage', '1', NULL),
(694, 2, [[timestamp]], NULL, 'frontpageloggedin', '1', NULL),
(695, 2, [[timestamp]], NULL, 'maxcategorydepth', '0', NULL),
(696, 2, [[timestamp]], NULL, 'commentsperpage', '15', NULL),
(697, 2, [[timestamp]], NULL, 'coursesperpage', '20', NULL),
(698, 2, [[timestamp]], NULL, 'defaultfrontpageroleid', '8', NULL),
(699, 2, [[timestamp]], NULL, 'supportname', '[[admin_fname]] [[admin_lname]]', NULL),
(700, 2, [[timestamp]], NULL, 'supportemail', '[[admin_email]]', NULL),
(701, 2, [[timestamp]], NULL, 'registerauth', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_plugins`
--

CREATE TABLE `[[dbprefix]]config_plugins` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) NOT NULL DEFAULT 'core',
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]confplug_plunam_uix` (`plugin`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Moodle modules and plugins configuration variables' AUTO_INCREMENT=489 ;

--
-- Dumping data for table `[[dbprefix]]config_plugins`
--

INSERT INTO `[[dbprefix]]config_plugins` VALUES
(1, 'moodlecourse', 'format', 'weeks'),
(2, 'moodlecourse', 'numsections', '10'),
(3, 'moodlecourse', 'hiddensections', '0'),
(4, 'moodlecourse', 'newsitems', '5'),
(5, 'moodlecourse', 'showgrades', '1'),
(6, 'moodlecourse', 'showreports', '0'),
(7, 'moodlecourse', 'maxbytes', '33554432'),
(8, 'moodlecourse', 'groupmode', '0'),
(9, 'moodlecourse', 'groupmodeforce', '0'),
(10, 'moodlecourse', 'visible', '1'),
(11, 'moodlecourse', 'lang', ''),
(12, 'moodlecourse', 'enablecompletion', '0'),
(13, 'moodlecourse', 'completionstartonenrol', '0'),
(14, 'backup', 'backup_general_users', '1'),
(15, 'backup', 'backup_general_users_locked', '0'),
(16, 'backup', 'backup_general_anonymize', '0'),
(17, 'backup', 'backup_general_anonymize_locked', '0'),
(18, 'backup', 'backup_general_role_assignments', '1'),
(19, 'backup', 'backup_general_role_assignments_locked', '0'),
(20, 'backup', 'backup_general_activities', '1'),
(21, 'backup', 'backup_general_activities_locked', '0'),
(22, 'backup', 'backup_general_blocks', '1'),
(23, 'backup', 'backup_general_blocks_locked', '0'),
(24, 'backup', 'backup_general_filters', '1'),
(25, 'backup', 'backup_general_filters_locked', '0'),
(26, 'backup', 'backup_general_comments', '1'),
(27, 'backup', 'backup_general_comments_locked', '0'),
(28, 'backup', 'backup_general_userscompletion', '1'),
(29, 'backup', 'backup_general_userscompletion_locked', '0'),
(30, 'backup', 'backup_general_logs', '0'),
(31, 'backup', 'backup_general_logs_locked', '0'),
(32, 'backup', 'backup_general_histories', '0'),
(33, 'backup', 'backup_general_histories_locked', '0'),
(34, 'backup', 'backup_auto_active', '0'),
(35, 'backup', 'backup_auto_weekdays', '0000000'),
(36, 'backup', 'backup_auto_hour', '0'),
(37, 'backup', 'backup_auto_minute', '0'),
(38, 'backup', 'backup_auto_storage', '0'),
(39, 'backup', 'backup_auto_destination', ''),
(40, 'backup', 'backup_auto_keep', '1'),
(41, 'backup', 'backup_auto_users', '1'),
(42, 'backup', 'backup_auto_role_assignments', '1'),
(43, 'backup', 'backup_auto_activities', '1'),
(44, 'backup', 'backup_auto_blocks', '1'),
(45, 'backup', 'backup_auto_filters', '1'),
(46, 'backup', 'backup_auto_comments', '1'),
(47, 'backup', 'backup_auto_userscompletion', '1'),
(48, 'backup', 'backup_auto_logs', '0'),
(49, 'backup', 'backup_auto_histories', '0'),
(50, 'enrol_database', 'dbtype', ''),
(51, 'enrol_database', 'dbhost', 'localhost'),
(52, 'enrol_database', 'dbuser', ''),
(53, 'enrol_database', 'dbpass', ''),
(54, 'enrol_database', 'dbname', ''),
(55, 'enrol_database', 'dbencoding', 'utf-8'),
(56, 'enrol_database', 'dbsetupsql', ''),
(57, 'enrol_database', 'dbsybasequoting', '0'),
(58, 'enrol_database', 'debugdb', '0'),
(59, 'enrol_database', 'localcoursefield', 'idnumber'),
(60, 'enrol_database', 'localuserfield', 'idnumber'),
(61, 'enrol_database', 'localrolefield', 'shortname'),
(62, 'enrol_database', 'remoteenroltable', ''),
(63, 'enrol_database', 'remotecoursefield', ''),
(64, 'enrol_database', 'remoteuserfield', ''),
(65, 'enrol_database', 'remoterolefield', ''),
(66, 'enrol_database', 'ignorehiddencourses', '0'),
(67, 'enrol_database', 'unenrolaction', '0'),
(68, 'enrol_database', 'newcoursetable', ''),
(69, 'enrol_database', 'newcoursefullname', 'fullname'),
(70, 'enrol_database', 'newcourseshortname', 'shortname'),
(71, 'enrol_database', 'newcourseidnumber', 'idnumber'),
(72, 'enrol_database', 'newcoursecategory', ''),
(73, 'enrol_database', 'templatecourse', ''),
(74, 'enrol_flatfile', 'location', ''),
(75, 'enrol_flatfile', 'mailstudents', '0'),
(76, 'enrol_flatfile', 'mailteachers', '0'),
(77, 'enrol_flatfile', 'mailadmins', '0'),
(78, 'enrol_guest', 'requirepassword', '0'),
(79, 'enrol_guest', 'usepasswordpolicy', '0'),
(80, 'enrol_guest', 'showhint', '0'),
(81, 'enrol_guest', 'defaultenrol', '1'),
(82, 'enrol_guest', 'status', '1'),
(83, 'enrol_guest', 'status_adv', '0'),
(84, 'enrol_imsenterprise', 'imsfilelocation', ''),
(85, 'enrol_imsenterprise', 'logtolocation', ''),
(86, 'enrol_imsenterprise', 'mailadmins', '0'),
(87, 'enrol_imsenterprise', 'createnewusers', '0'),
(88, 'enrol_imsenterprise', 'imsdeleteusers', '0'),
(89, 'enrol_imsenterprise', 'fixcaseusernames', '0'),
(90, 'enrol_imsenterprise', 'fixcasepersonalnames', '0'),
(91, 'enrol_imsenterprise', 'imssourcedidfallback', '0'),
(92, 'enrol_imsenterprise', 'truncatecoursecodes', '0'),
(93, 'enrol_imsenterprise', 'createnewcourses', '0'),
(94, 'enrol_imsenterprise', 'createnewcategories', '0'),
(95, 'enrol_imsenterprise', 'imsunenrol', '0'),
(96, 'enrol_imsenterprise', 'imsrestricttarget', ''),
(97, 'enrol_imsenterprise', 'imscapitafix', '0'),
(98, 'enrol_manual', 'defaultenrol', '1'),
(99, 'enrol_manual', 'status', '0'),
(100, 'enrol_manual', 'enrolperiod', '0'),
(101, 'enrol_paypal', 'paypalbusiness', ''),
(102, 'enrol_paypal', 'mailstudents', '0'),
(103, 'enrol_paypal', 'mailteachers', '0'),
(104, 'enrol_paypal', 'mailadmins', '0'),
(105, 'enrol_paypal', 'status', '1'),
(106, 'enrol_paypal', 'cost', '0'),
(107, 'enrol_paypal', 'currency', 'USD'),
(108, 'enrol_paypal', 'enrolperiod', '0'),
(109, 'enrol_self', 'requirepassword', '0'),
(110, 'enrol_self', 'usepasswordpolicy', '0'),
(111, 'enrol_self', 'showhint', '0'),
(112, 'enrol_self', 'defaultenrol', '1'),
(113, 'enrol_self', 'status', '1'),
(114, 'enrol_self', 'groupkey', '0'),
(115, 'enrol_self', 'enrolperiod', '0'),
(116, 'enrol_self', 'longtimenosee', '0'),
(117, 'enrol_self', 'maxenrolled', '0'),
(118, 'enrol_self', 'sendcoursewelcomemessage', '1'),
(119, 'editor_tinymce', 'spellengine', 'GoogleSpell'),
(120, 'filter_urltolink', 'formats', '0'),
(121, 'filter_urltolink', 'embedimages', '1'),
(122, 'filter_emoticon', 'formats', '1,4,0'),
(123, 'theme_arialist', 'logo', ''),
(124, 'theme_arialist', 'tagline', ''),
(125, 'theme_arialist', 'linkcolor', '#f25f0f'),
(126, 'theme_arialist', 'regionwidth', '250'),
(127, 'theme_arialist', 'customcss', ''),
(128, 'theme_brick', 'logo', ''),
(129, 'theme_brick', 'linkcolor', '#06365b'),
(130, 'theme_brick', 'linkhover', '#5487ad'),
(131, 'theme_brick', 'maincolor', '#8e2800'),
(132, 'theme_brick', 'maincolorlink', '#fff0a5'),
(133, 'theme_brick', 'headingcolor', '#5c3500'),
(134, 'theme_formal_white', 'fontsizereference', '13'),
(135, 'theme_formal_white', 'noframe', '0'),
(136, 'theme_formal_white', 'displaylogo', '1'),
(137, 'theme_formal_white', 'logo', ''),
(138, 'theme_formal_white', 'headerbgc', '#E3DFD4'),
(139, 'theme_formal_white', 'blockcontentbgc', '#F6F6F6'),
(140, 'theme_formal_white', 'lblockcolumnbgc', '#E3DFD4'),
(141, 'theme_formal_white', 'rblockcolumnbgc', ''),
(142, 'theme_formal_white', 'blockcolumnwidth', '200'),
(143, 'theme_formal_white', 'footnote', ''),
(144, 'theme_formal_white', 'customcss', ''),
(145, 'theme_fusion', 'linkcolor', '#2d83d5'),
(146, 'theme_fusion', 'tagline', ''),
(147, 'theme_fusion', 'footertext', ''),
(148, 'theme_fusion', 'customcss', ''),
(149, 'theme_magazine', 'background', ''),
(150, 'theme_magazine', 'logo', ''),
(151, 'theme_magazine', 'linkcolor', '#32529a'),
(152, 'theme_magazine', 'linkhover', '#4e2300'),
(153, 'theme_magazine', 'maincolor', '#002f2f'),
(154, 'theme_magazine', 'maincoloraccent', '#092323'),
(155, 'theme_magazine', 'headingcolor', '#4e0000'),
(156, 'theme_magazine', 'blockcolor', '#002f2f'),
(157, 'theme_magazine', 'forumback', '#e6e2af'),
(158, 'theme_nimble', 'tagline', ''),
(159, 'theme_nimble', 'footerline', ''),
(160, 'theme_nimble', 'backgroundcolor', '#454545'),
(161, 'theme_nimble', 'linkcolor', '#2a65b1'),
(162, 'theme_nimble', 'linkhover', '#222222'),
(163, 'theme_nonzero', 'regionprewidth', '200'),
(164, 'theme_nonzero', 'regionpostwidth', '200'),
(165, 'theme_nonzero', 'customcss', ''),
(166, 'theme_overlay', 'linkcolor', '#428ab5'),
(167, 'theme_overlay', 'headercolor', '#2a4c7b'),
(168, 'theme_overlay', 'footertext', ''),
(169, 'theme_overlay', 'customcss', ''),
(170, 'theme_sky_high', 'logo', ''),
(171, 'theme_sky_high', 'regionwidth', '240'),
(172, 'theme_sky_high', 'footnote', ''),
(173, 'theme_sky_high', 'customcss', ''),
(174, 'theme_splash', 'logo', ''),
(175, 'theme_splash', 'tagline', 'Virtual learning center'),
(176, 'theme_splash', 'hide_tagline', '0'),
(177, 'theme_splash', 'footnote', ''),
(178, 'theme_splash', 'customcss', ''),
(187, 'auth_cas', 'version', '2010072600'),
(189, 'auth_db', 'version', '2009112400'),
(191, 'auth_fc', 'version', '2009112400'),
(193, 'auth_imap', 'version', '2009112400'),
(195, 'auth_ldap', 'version', '2010072600'),
(197, 'auth_manual', 'version', '2011022700'),
(198, 'auth_mnet', 'version', '2010071300'),
(200, 'auth_nntp', 'version', '2009112400'),
(202, 'auth_pam', 'version', '2009112400'),
(204, 'auth_pop3', 'version', '2009112400'),
(206, 'auth_radius', 'version', '2009112400'),
(208, 'auth_shibboleth', 'version', '2009112400'),
(210, 'enrol_authorize', 'version', '2010081203'),
(211, 'enrol_category', 'version', '2010061500'),
(213, 'enrol_cohort', 'version', '2010073100'),
(214, 'enrol_database', 'version', '2010073101'),
(216, 'enrol_flatfile', 'version', '2010091400'),
(217, 'enrol_guest', 'version', '2010081800'),
(218, 'enrol_imsenterprise', 'version', '2011013000'),
(220, 'enrol_ldap', 'version', '2010071100'),
(222, 'enrol_manual', 'version', '2010071201'),
(224, 'enrol_meta', 'version', '2010073100'),
(226, 'enrol_mnet', 'version', '2010071701'),
(227, 'enrol_paypal', 'version', '2010073100'),
(228, 'enrol_self', 'version', '2010090501'),
(230, 'message_email', 'version', '2010090501'),
(232, 'message_jabber', 'version', '2010090501'),
(234, 'message_popup', 'version', '2010090501'),
(238, 'filter_emoticon', 'version', '2010102300'),
(239, 'filter_mediaplugin', 'version', '2011030900'),
(241, 'filter_tex', 'version', '2011031301'),
(243, 'filter_urltolink', 'version', '2010100500'),
(244, 'editor_textarea', 'version', '2010090501'),
(245, 'editor_tinymce', 'version', '2010093000'),
(246, 'report_courseoverview', 'version', '2010090501'),
(247, 'report_customlang', 'version', '2011041900'),
(248, 'report_questioninstances', 'version', '2010090501'),
(249, 'report_security', 'version', '2010090501'),
(250, 'report_unittest', 'version', '2010090501'),
(251, 'report_unsuproles', 'version', '2010071800'),
(252, 'coursereport_completion', 'version', '2010090501'),
(253, 'coursereport_log', 'version', '2010090501'),
(254, 'coursereport_outline', 'version', '2010090501'),
(255, 'coursereport_participation', 'version', '2010090501'),
(256, 'coursereport_progress', 'version', '2010090501'),
(257, 'coursereport_stats', 'version', '2010090501'),
(258, 'gradeexport_ods', 'version', '2010090501'),
(259, 'gradeexport_txt', 'version', '2010090501'),
(260, 'gradeexport_xls', 'version', '2010090501'),
(261, 'gradeexport_xml', 'version', '2010090501'),
(262, 'gradeimport_csv', 'version', '2010090501'),
(263, 'gradeimport_xml', 'version', '2010090501'),
(264, 'gradereport_grader', 'version', '2010090501'),
(265, 'gradereport_outcomes', 'version', '2010090501'),
(266, 'gradereport_overview', 'version', '2010090501'),
(267, 'gradereport_user', 'version', '2010090501'),
(268, 'mnetservice_enrol', 'version', '2010071700'),
(269, 'webservice_amf', 'version', '2009101900'),
(270, 'webservice_rest', 'version', '2009100800'),
(271, 'webservice_soap', 'version', '2009101900'),
(272, 'webservice_xmlrpc', 'version', '2009101900'),
(273, 'repository_alfresco', 'version', '2010050700'),
(274, 'repository_boxnet', 'version', '2009080105'),
(275, 'repository_coursefiles', 'version', '2012010100'),
(276, 'repository_dropbox', 'version', '2010051400'),
(277, 'repository_filesystem', 'version', '2012010100'),
(278, 'repository_flickr', 'version', '2009080102'),
(279, 'repository_flickr_public', 'version', '2009080102'),
(280, 'repository_googledocs', 'version', '2009080102'),
(281, 'repository_local', 'version', '2012010100'),
(283, 'local', 'enablecourseinstances', '0'),
(284, 'local', 'enableuserinstances', '0'),
(285, 'repository_merlot', 'version', '2009111301'),
(286, 'repository_picasa', 'version', '2009080102'),
(287, 'repository_recent', 'version', '2010042202'),
(289, 'recent', 'enablecourseinstances', '0'),
(290, 'recent', 'enableuserinstances', '0'),
(291, 'repository_s3', 'version', '2009080102'),
(292, 'repository_upload', 'version', '2009080102'),
(294, 'upload', 'enablecourseinstances', '0'),
(295, 'upload', 'enableuserinstances', '0'),
(296, 'repository_url', 'version', '2009080102'),
(297, 'repository_user', 'version', '2010052700'),
(299, 'user', 'enablecourseinstances', '0'),
(300, 'user', 'enableuserinstances', '0'),
(301, 'repository_webdav', 'version', '2012010100'),
(302, 'repository_wikimedia', 'version', '2009080102'),
(303, 'repository_youtube', 'version', '2009080102'),
(304, 'portfolio_boxnet', 'version', '2010090501'),
(305, 'portfolio_download', 'version', '2010090501'),
(306, 'portfolio_flickr', 'version', '2010090501'),
(307, 'portfolio_googledocs', 'version', '2010090501'),
(308, 'portfolio_mahara', 'version', '2010090501'),
(309, 'portfolio_picasa', 'version', '2010090501'),
(310, 'qtype_calculated', 'version', '2010090501'),
(311, 'qtype_essay', 'version', '2010090501'),
(312, 'qtype_match', 'version', '2010090501'),
(313, 'qtype_multianswer', 'version', '2010090501'),
(314, 'qtype_multichoice', 'version', '2010090501'),
(315, 'qtype_numerical', 'version', '2010090501'),
(316, 'qtype_randomsamatch', 'version', '2010090501'),
(317, 'qtype_shortanswer', 'version', '2010090501'),
(318, 'qtype_truefalse', 'version', '2010090501'),
(319, 'theme_formal_white', 'version', '2011061301'),
(321, 'assignment_online', 'version', '2010090501'),
(322, 'quiz_overview', 'version', '2009091400'),
(323, 'quiz_statistics', 'version', '2008112103'),
(325, 'workshopform_accumulative', 'version', '2010091700'),
(327, 'workshopform_comments', 'version', '2010091700'),
(329, 'workshopform_numerrors', 'version', '2010091700'),
(331, 'workshopform_rubric', 'version', '2010091700'),
(333, 'workshopeval_best', 'version', '2010090501'),
(334, 'folder', 'requiremodintro', '1'),
(335, 'imscp', 'requiremodintro', '1'),
(336, 'imscp', 'keepold', '1'),
(337, 'imscp', 'keepold_adv', '0'),
(338, 'page', 'requiremodintro', '1'),
(339, 'page', 'displayoptions', '5'),
(340, 'page', 'printheading', '1'),
(341, 'page', 'printheading_adv', '0'),
(342, 'page', 'printintro', '0'),
(343, 'page', 'printintro_adv', '0'),
(344, 'page', 'display', '5'),
(345, 'page', 'display_adv', '1'),
(346, 'page', 'popupwidth', '620'),
(347, 'page', 'popupwidth_adv', '1'),
(348, 'page', 'popupheight', '450'),
(349, 'page', 'popupheight_adv', '1'),
(350, 'quiz', 'timelimit', '0'),
(351, 'quiz', 'timelimit_adv', '0'),
(352, 'quiz', 'attempts', '0'),
(353, 'quiz', 'attempts_adv', '0'),
(354, 'quiz', 'grademethod', '1'),
(355, 'quiz', 'grademethod_adv', '0'),
(356, 'quiz', 'maximumgrade', '10'),
(357, 'quiz', 'shufflequestions', '0'),
(358, 'quiz', 'shufflequestions_adv', '0'),
(359, 'quiz', 'questionsperpage', '1'),
(360, 'quiz', 'questionsperpage_adv', '0'),
(361, 'quiz', 'shuffleanswers', '1'),
(362, 'quiz', 'shuffleanswers_adv', '0'),
(363, 'quiz', 'optionflags', '1'),
(364, 'quiz', 'optionflags_adv', '0'),
(365, 'quiz', 'penaltyscheme', '1'),
(366, 'quiz', 'penaltyscheme_adv', '1'),
(367, 'quiz', 'attemptonlast', '0'),
(368, 'quiz', 'attemptonlast_adv', '1'),
(369, 'quiz', 'review', '1073741823'),
(370, 'quiz', 'review_adv', '0'),
(371, 'quiz', 'showuserpicture', '0'),
(372, 'quiz', 'showuserpicture_adv', '0'),
(373, 'quiz', 'decimalpoints', '2'),
(374, 'quiz', 'decimalpoints_adv', '0'),
(375, 'quiz', 'questiondecimalpoints', '-1'),
(376, 'quiz', 'questiondecimalpoints_adv', '0'),
(377, 'quiz', 'showblocks', '0'),
(378, 'quiz', 'showblocks_adv', '1'),
(379, 'quiz', 'password', ''),
(380, 'quiz', 'password_adv', '0'),
(381, 'quiz', 'subnet', ''),
(382, 'quiz', 'subnet_adv', '0'),
(383, 'quiz', 'delay1', '0'),
(384, 'quiz', 'delay1_adv', '0'),
(385, 'quiz', 'delay2', '0'),
(386, 'quiz', 'delay2_adv', '0'),
(387, 'quiz', 'popup', '0'),
(388, 'quiz', 'popup_adv', '1'),
(389, 'resource', 'framesize', '130'),
(390, 'resource', 'requiremodintro', '1'),
(391, 'resource', 'displayoptions', '0,1,4,5,6'),
(392, 'resource', 'printheading', '0'),
(393, 'resource', 'printheading_adv', '0'),
(394, 'resource', 'printintro', '1'),
(395, 'resource', 'printintro_adv', '0'),
(396, 'resource', 'display', '0'),
(397, 'resource', 'display_adv', '0'),
(398, 'resource', 'popupwidth', '620'),
(399, 'resource', 'popupwidth_adv', '1'),
(400, 'resource', 'popupheight', '450'),
(401, 'resource', 'popupheight_adv', '1'),
(402, 'resource', 'filterfiles', '0'),
(403, 'resource', 'filterfiles_adv', '1'),
(404, 'scorm', 'grademethod', '1'),
(405, 'scorm', 'maxgrade', '100'),
(406, 'scorm', 'maxattempts', '0'),
(407, 'scorm', 'displayattemptstatus', '0'),
(408, 'scorm', 'displaycoursestructure', '0'),
(409, 'scorm', 'forcecompleted', '0'),
(410, 'scorm', 'forcenewattempt', '0'),
(411, 'scorm', 'lastattemptlock', '0'),
(412, 'scorm', 'whatgrade', '0'),
(413, 'scorm', 'framewidth', '100'),
(414, 'scorm', 'frameheight', '500'),
(415, 'scorm', 'popup', '0'),
(416, 'scorm', 'resizable', '0'),
(417, 'scorm', 'scrollbars', '0'),
(418, 'scorm', 'directories', '0'),
(419, 'scorm', 'location', '0'),
(420, 'scorm', 'menubar', '0'),
(421, 'scorm', 'toolbar', '0'),
(422, 'scorm', 'status', '0'),
(423, 'scorm', 'skipview', '0'),
(424, 'scorm', 'hidebrowse', '0'),
(425, 'scorm', 'hidetoc', '0'),
(426, 'scorm', 'hidenav', '0'),
(427, 'scorm', 'auto', '0'),
(428, 'scorm', 'updatefreq', '0'),
(429, 'scorm', 'allowtypeexternal', '0'),
(430, 'scorm', 'allowtypelocalsync', '0'),
(431, 'scorm', 'allowtypeimsrepository', '0'),
(432, 'scorm', 'forcejavascript', '1'),
(433, 'scorm', 'allowapidebug', '0'),
(434, 'scorm', 'apidebugmask', '.*'),
(435, 'url', 'framesize', '130'),
(436, 'url', 'requiremodintro', '1'),
(437, 'url', 'secretphrase', ''),
(438, 'url', 'rolesinparams', '0'),
(439, 'url', 'displayoptions', '0,1,5,6'),
(440, 'url', 'printheading', '0'),
(441, 'url', 'printheading_adv', '0'),
(442, 'url', 'printintro', '1'),
(443, 'url', 'printintro_adv', '0'),
(444, 'url', 'display', '0'),
(445, 'url', 'display_adv', '0'),
(446, 'url', 'popupwidth', '620'),
(447, 'url', 'popupwidth_adv', '1'),
(448, 'url', 'popupheight', '450'),
(449, 'url', 'popupheight_adv', '1'),
(450, 'workshop', 'grade', '80'),
(451, 'workshop', 'gradinggrade', '20'),
(452, 'workshop', 'gradedecimals', '0'),
(453, 'workshop', 'maxbytes', '0'),
(454, 'workshop', 'strategy', 'accumulative'),
(455, 'workshop', 'examplesmode', '0'),
(456, 'workshopallocation_random', 'numofreviews', '5'),
(457, 'workshopform_numerrors', 'grade0', 'No'),
(458, 'workshopform_numerrors', 'grade1', 'Yes'),
(459, 'workshopeval_best', 'comparison', '5'),
(460, 'blocks/section_links', 'numsections1', '22'),
(461, 'blocks/section_links', 'incby1', '2'),
(462, 'blocks/section_links', 'numsections2', '40'),
(463, 'blocks/section_links', 'incby2', '5'),
(464, 'enrol_cohort', 'roleid', '5'),
(465, 'enrol_database', 'defaultrole', '5'),
(466, 'enrol_database', 'defaultcategory', '1'),
(467, 'enrol_flatfile', 'map_1', 'manager'),
(468, 'enrol_flatfile', 'map_2', 'coursecreator'),
(469, 'enrol_flatfile', 'map_3', 'editingteacher'),
(470, 'enrol_flatfile', 'map_4', 'teacher'),
(471, 'enrol_flatfile', 'map_5', 'student'),
(472, 'enrol_flatfile', 'map_6', 'guest'),
(473, 'enrol_flatfile', 'map_7', 'user'),
(474, 'enrol_flatfile', 'map_8', 'frontpage'),
(475, 'enrol_imsenterprise', 'imsrolemap01', '5'),
(476, 'enrol_imsenterprise', 'imsrolemap02', '3'),
(477, 'enrol_imsenterprise', 'imsrolemap03', '3'),
(478, 'enrol_imsenterprise', 'imsrolemap04', '5'),
(479, 'enrol_imsenterprise', 'imsrolemap05', '0'),
(480, 'enrol_imsenterprise', 'imsrolemap06', '4'),
(481, 'enrol_imsenterprise', 'imsrolemap07', '0'),
(482, 'enrol_imsenterprise', 'imsrolemap08', '4'),
(483, 'enrol_manual', 'roleid', '5'),
(484, 'enrol_meta', 'nosyncroleids', ''),
(485, 'enrol_mnet', 'roleid', '5'),
(486, 'enrol_mnet', 'roleid_adv', '1'),
(487, 'enrol_paypal', 'roleid', '5'),
(488, 'enrol_self', 'roleid', '5');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]context`
--

CREATE TABLE `[[dbprefix]]context` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint(10) unsigned NOT NULL DEFAULT '0',
  `instanceid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) DEFAULT NULL,
  `depth` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]cont_conins_uix` (`contextlevel`,`instanceid`),
  KEY `[[dbprefix]]cont_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]cont_pat_ix` (`path`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='one of these must be set' AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]context`
--

INSERT INTO `[[dbprefix]]context` VALUES
(1, 10, 0, '/1', 1),
(2, 50, 1, '/1/2', 2),
(3, 40, 1, '/1/3', 2),
(4, 80, 1, '/1/2/4', 3),
(5, 80, 2, '/1/2/5', 3),
(6, 80, 3, '/1/2/6', 3),
(7, 80, 4, '/1/7', 2),
(8, 80, 5, '/1/8', 2),
(9, 80, 6, '/1/9', 2),
(10, 80, 7, '/1/10', 2),
(11, 80, 8, '/1/11', 2),
(12, 80, 9, '/1/12', 2),
(13, 30, 2, '/1/13', 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]context_temp`
--

CREATE TABLE `[[dbprefix]]context_temp` (
  `id` bigint(10) unsigned NOT NULL,
  `path` varchar(255) NOT NULL DEFAULT '',
  `depth` tinyint(2) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used by build_context_path() in upgrade and cron to keep con';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course`
--

CREATE TABLE `[[dbprefix]]course` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `category` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  `fullname` varchar(254) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `summary` text,
  `summaryformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `format` varchar(10) NOT NULL DEFAULT 'topics',
  `showgrades` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `modinfo` longtext,
  `newsitems` mediumint(5) unsigned NOT NULL DEFAULT '1',
  `startdate` bigint(10) unsigned NOT NULL DEFAULT '0',
  `numsections` mediumint(5) unsigned NOT NULL DEFAULT '1',
  `marker` bigint(10) unsigned NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) unsigned NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) unsigned NOT NULL DEFAULT '0',
  `showreports` smallint(4) unsigned NOT NULL DEFAULT '0',
  `visible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `hiddensections` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `groupmode` smallint(4) unsigned NOT NULL DEFAULT '0',
  `groupmodeforce` smallint(4) unsigned NOT NULL DEFAULT '0',
  `defaultgroupingid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lang` varchar(30) NOT NULL DEFAULT '',
  `theme` varchar(50) NOT NULL DEFAULT '',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `requested` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `restrictmodules` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `enablecompletion` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `completionstartonenrol` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `completionnotify` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cour_cat_ix` (`category`),
  KEY `[[dbprefix]]cour_idn_ix` (`idnumber`),
  KEY `[[dbprefix]]cour_sho_ix` (`shortname`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Central course table' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course`
--

INSERT INTO `[[dbprefix]]course` VALUES
(1, 0, 1, '[[site_name]]', '[[site_desc]]', '', '', 0, 'site', 1, 'a:0:{}', 3, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, '', '', [[timestamp]], [[timestamp]], 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_allowed_modules`
--

CREATE TABLE `[[dbprefix]]course_allowed_modules` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `module` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courallomodu_cou_ix` (`course`),
  KEY `[[dbprefix]]courallomodu_mod_ix` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='allowed modules foreach course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_categories`
--

CREATE TABLE `[[dbprefix]]course_categories` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `descriptionformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `parent` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  `coursecount` bigint(10) unsigned NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `depth` bigint(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `theme` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcate_par_ix` (`parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Course categories' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course_categories`
--

INSERT INTO `[[dbprefix]]course_categories` VALUES
(1, 'Miscellaneous', NULL, 0, 0, 10000, 0, 1, 1, [[timestamp]], 1, '/1', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completions`
--

CREATE TABLE `[[dbprefix]]course_completions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `deleted` tinyint(1) unsigned DEFAULT NULL,
  `timenotified` bigint(10) unsigned DEFAULT NULL,
  `timeenrolled` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timestarted` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timecompleted` bigint(10) unsigned DEFAULT NULL,
  `reaggregate` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]courcomp_cou_ix` (`course`),
  KEY `[[dbprefix]]courcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Course completion records' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_aggr_methd`
--

CREATE TABLE `[[dbprefix]]course_completion_aggr_methd` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `criteriatype` bigint(20) unsigned DEFAULT NULL,
  `method` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `value` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcompaggrmeth_cou_ix` (`course`),
  KEY `[[dbprefix]]courcompaggrmeth_cri_ix` (`criteriatype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Course completion aggregation methods for criteria' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_criteria`
--

CREATE TABLE `[[dbprefix]]course_completion_criteria` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `criteriatype` bigint(20) unsigned NOT NULL DEFAULT '0',
  `module` varchar(100) DEFAULT NULL,
  `moduleinstance` bigint(10) unsigned DEFAULT NULL,
  `courseinstance` bigint(10) unsigned DEFAULT NULL,
  `enrolperiod` bigint(10) unsigned DEFAULT NULL,
  `timeend` bigint(10) unsigned DEFAULT NULL,
  `gradepass` decimal(10,5) DEFAULT NULL,
  `role` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcompcrit_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Course completion criteria' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_crit_compl`
--

CREATE TABLE `[[dbprefix]]course_completion_crit_compl` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `criteriaid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `gradefinal` decimal(10,5) DEFAULT NULL,
  `unenroled` bigint(10) unsigned DEFAULT NULL,
  `deleted` tinyint(1) unsigned DEFAULT NULL,
  `timecompleted` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcompcritcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]courcompcritcomp_cou_ix` (`course`),
  KEY `[[dbprefix]]courcompcritcomp_cri_ix` (`criteriaid`),
  KEY `[[dbprefix]]courcompcritcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Course completion user records' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_notify`
--

CREATE TABLE `[[dbprefix]]course_completion_notify` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `role` bigint(10) unsigned NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `timesent` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcompnoti_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Course completion notification emails' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_display`
--

CREATE TABLE `[[dbprefix]]course_display` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courdisp_couuse_ix` (`course`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores info about how to display the course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules`
--

CREATE TABLE `[[dbprefix]]course_modules` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `module` bigint(10) unsigned NOT NULL DEFAULT '0',
  `instance` bigint(10) unsigned NOT NULL DEFAULT '0',
  `section` bigint(10) unsigned NOT NULL DEFAULT '0',
  `idnumber` varchar(100) DEFAULT NULL,
  `added` bigint(10) unsigned NOT NULL DEFAULT '0',
  `score` smallint(4) NOT NULL DEFAULT '0',
  `indent` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupingid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `groupmembersonly` smallint(4) unsigned NOT NULL DEFAULT '0',
  `completion` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `completiongradeitemnumber` bigint(10) unsigned DEFAULT NULL,
  `completionview` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) unsigned NOT NULL DEFAULT '0',
  `availablefrom` bigint(10) unsigned NOT NULL DEFAULT '0',
  `availableuntil` bigint(10) unsigned NOT NULL DEFAULT '0',
  `showavailability` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courmodu_vis_ix` (`visible`),
  KEY `[[dbprefix]]courmodu_cou_ix` (`course`),
  KEY `[[dbprefix]]courmodu_mod_ix` (`module`),
  KEY `[[dbprefix]]courmodu_ins_ix` (`instance`),
  KEY `[[dbprefix]]courmodu_idncou_ix` (`idnumber`,`course`),
  KEY `[[dbprefix]]courmodu_gro_ix` (`groupingid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='course_modules table retrofitted from MySQL' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules_availability`
--

CREATE TABLE `[[dbprefix]]course_modules_availability` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint(10) unsigned NOT NULL,
  `sourcecmid` bigint(10) unsigned DEFAULT NULL,
  `requiredcompletion` tinyint(1) unsigned DEFAULT NULL,
  `gradeitemid` bigint(10) unsigned DEFAULT NULL,
  `grademin` decimal(10,5) DEFAULT NULL,
  `grademax` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courmoduavai_cou_ix` (`coursemoduleid`),
  KEY `[[dbprefix]]courmoduavai_sou_ix` (`sourcecmid`),
  KEY `[[dbprefix]]courmoduavai_gra_ix` (`gradeitemid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Table stores conditions that affect whether a module/activit' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules_completion`
--

CREATE TABLE `[[dbprefix]]course_modules_completion` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `completionstate` tinyint(1) unsigned NOT NULL,
  `viewed` tinyint(1) unsigned DEFAULT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courmoducomp_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `[[dbprefix]]courmoducomp_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the completion state (completed or not completed, etc' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_published`
--

CREATE TABLE `[[dbprefix]]course_published` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `huburl` varchar(255) DEFAULT NULL,
  `courseid` bigint(10) unsigned NOT NULL,
  `timepublished` bigint(10) unsigned NOT NULL,
  `enrollable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `hubcourseid` bigint(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned DEFAULT '0',
  `timechecked` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Information about how and when an local courses were publish' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_request`
--

CREATE TABLE `[[dbprefix]]course_request` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `fullname` varchar(254) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `summary` text NOT NULL,
  `summaryformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `reason` text NOT NULL,
  `requester` bigint(10) unsigned NOT NULL DEFAULT '0',
  `password` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courrequ_sho_ix` (`shortname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='course requests' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_sections`
--

CREATE TABLE `[[dbprefix]]course_sections` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `section` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `summary` text,
  `summaryformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `sequence` text,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]coursect_cousec_ix` (`course`,`section`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to define the sections for each course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data`
--

CREATE TABLE `[[dbprefix]]data` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `comments` smallint(4) unsigned NOT NULL DEFAULT '0',
  `timeavailablefrom` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeavailableto` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeviewfrom` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeviewto` bigint(10) unsigned NOT NULL DEFAULT '0',
  `requiredentries` int(8) unsigned NOT NULL DEFAULT '0',
  `requiredentriestoview` int(8) unsigned NOT NULL DEFAULT '0',
  `maxentries` int(8) unsigned NOT NULL DEFAULT '0',
  `rssarticles` smallint(4) unsigned NOT NULL DEFAULT '0',
  `singletemplate` text,
  `listtemplate` text,
  `listtemplateheader` text,
  `listtemplatefooter` text,
  `addtemplate` text,
  `rsstemplate` text,
  `rsstitletemplate` text,
  `csstemplate` text,
  `jstemplate` text,
  `asearchtemplate` text,
  `approval` smallint(4) unsigned NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `assessed` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) unsigned NOT NULL DEFAULT '0',
  `defaultsort` bigint(10) unsigned NOT NULL DEFAULT '0',
  `defaultsortdir` smallint(4) unsigned NOT NULL DEFAULT '0',
  `editany` smallint(4) unsigned NOT NULL DEFAULT '0',
  `notification` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]data_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='all database activities' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_content`
--

CREATE TABLE `[[dbprefix]]data_content` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `fieldid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `recordid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `content` longtext,
  `content1` longtext,
  `content2` longtext,
  `content3` longtext,
  `content4` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datacont_rec_ix` (`recordid`),
  KEY `[[dbprefix]]datacont_fie_ix` (`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='the content introduced in each record/fields' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_fields`
--

CREATE TABLE `[[dbprefix]]data_fields` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `dataid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `param1` text,
  `param2` text,
  `param3` text,
  `param4` text,
  `param5` text,
  `param6` text,
  `param7` text,
  `param8` text,
  `param9` text,
  `param10` text,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datafiel_typdat_ix` (`type`,`dataid`),
  KEY `[[dbprefix]]datafiel_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='every field available' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_records`
--

CREATE TABLE `[[dbprefix]]data_records` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `groupid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `dataid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `approved` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datareco_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='every record introduced' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol`
--

CREATE TABLE `[[dbprefix]]enrol` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `enrol` varchar(20) NOT NULL DEFAULT '',
  `status` bigint(10) unsigned NOT NULL DEFAULT '0',
  `courseid` bigint(10) unsigned NOT NULL,
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `enrolperiod` bigint(10) unsigned DEFAULT '0',
  `enrolstartdate` bigint(10) unsigned DEFAULT '0',
  `enrolenddate` bigint(10) unsigned DEFAULT '0',
  `expirynotify` tinyint(1) unsigned DEFAULT '0',
  `expirythreshold` bigint(10) unsigned DEFAULT '0',
  `notifyall` tinyint(1) unsigned DEFAULT '0',
  `password` varchar(50) DEFAULT NULL,
  `cost` varchar(20) DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `roleid` bigint(10) unsigned DEFAULT '0',
  `customint1` bigint(10) DEFAULT NULL,
  `customint2` bigint(10) DEFAULT NULL,
  `customint3` bigint(10) DEFAULT NULL,
  `customint4` bigint(10) DEFAULT NULL,
  `customchar1` varchar(255) DEFAULT NULL,
  `customchar2` varchar(255) DEFAULT NULL,
  `customdec1` decimal(12,7) DEFAULT NULL,
  `customdec2` decimal(12,7) DEFAULT NULL,
  `customtext1` longtext,
  `customtext2` longtext,
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enro_enr_ix` (`enrol`),
  KEY `[[dbprefix]]enro_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Instances of enrolment plugins used in courses, fields marke' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_authorize`
--

CREATE TABLE `[[dbprefix]]enrol_authorize` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `paymentmethod` varchar(6) NOT NULL DEFAULT 'cc',
  `refundinfo` smallint(4) unsigned NOT NULL DEFAULT '0',
  `ccname` varchar(255) NOT NULL DEFAULT '',
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `instanceid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `transid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `status` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `settletime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `amount` varchar(10) NOT NULL DEFAULT '',
  `currency` varchar(3) NOT NULL DEFAULT 'USD',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroauth_cou_ix` (`courseid`),
  KEY `[[dbprefix]]enroauth_use_ix` (`userid`),
  KEY `[[dbprefix]]enroauth_sta_ix` (`status`),
  KEY `[[dbprefix]]enroauth_tra_ix` (`transid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Holds all known information about authorize.net transactions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_authorize_refunds`
--

CREATE TABLE `[[dbprefix]]enrol_authorize_refunds` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `orderid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `amount` varchar(10) NOT NULL DEFAULT '',
  `transid` bigint(20) unsigned DEFAULT '0',
  `settletime` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroauthrefu_tra_ix` (`transid`),
  KEY `[[dbprefix]]enroauthrefu_ord_ix` (`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Authorize.net refunds' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_flatfile`
--

CREATE TABLE `[[dbprefix]]enrol_flatfile` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(30) NOT NULL DEFAULT '',
  `roleid` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `courseid` bigint(10) unsigned NOT NULL,
  `timestart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeend` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroflat_cou_ix` (`courseid`),
  KEY `[[dbprefix]]enroflat_use_ix` (`userid`),
  KEY `[[dbprefix]]enroflat_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='enrol_flatfile table retrofitted from MySQL' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_paypal`
--

CREATE TABLE `[[dbprefix]]enrol_paypal` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `business` varchar(255) NOT NULL DEFAULT '',
  `receiver_email` varchar(255) NOT NULL DEFAULT '',
  `receiver_id` varchar(255) NOT NULL DEFAULT '',
  `item_name` varchar(255) NOT NULL DEFAULT '',
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `instanceid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `memo` varchar(255) NOT NULL DEFAULT '',
  `tax` varchar(255) NOT NULL DEFAULT '',
  `option_name1` varchar(255) NOT NULL DEFAULT '',
  `option_selection1_x` varchar(255) NOT NULL DEFAULT '',
  `option_name2` varchar(255) NOT NULL DEFAULT '',
  `option_selection2_x` varchar(255) NOT NULL DEFAULT '',
  `payment_status` varchar(255) NOT NULL DEFAULT '',
  `pending_reason` varchar(255) NOT NULL DEFAULT '',
  `reason_code` varchar(30) NOT NULL DEFAULT '',
  `txn_id` varchar(255) NOT NULL DEFAULT '',
  `parent_txn_id` varchar(255) NOT NULL DEFAULT '',
  `payment_type` varchar(30) NOT NULL DEFAULT '',
  `timeupdated` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Holds all known information about PayPal transactions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event`
--

CREATE TABLE `[[dbprefix]]event` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `format` smallint(4) unsigned NOT NULL DEFAULT '0',
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `groupid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `repeatid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `modulename` varchar(20) NOT NULL DEFAULT '',
  `instance` bigint(10) unsigned NOT NULL DEFAULT '0',
  `eventtype` varchar(20) NOT NULL DEFAULT '',
  `timestart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeduration` bigint(10) unsigned NOT NULL DEFAULT '0',
  `visible` smallint(4) NOT NULL DEFAULT '1',
  `uuid` varchar(36) NOT NULL DEFAULT '',
  `sequence` bigint(10) unsigned NOT NULL DEFAULT '1',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]even_cou_ix` (`courseid`),
  KEY `[[dbprefix]]even_use_ix` (`userid`),
  KEY `[[dbprefix]]even_tim_ix` (`timestart`),
  KEY `[[dbprefix]]even_tim2_ix` (`timeduration`),
  KEY `[[dbprefix]]even_grocouvisuse_ix` (`groupid`,`courseid`,`visible`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='For everything with a time associated to it' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_handlers`
--

CREATE TABLE `[[dbprefix]]events_handlers` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `eventname` varchar(166) NOT NULL DEFAULT '',
  `component` varchar(166) NOT NULL DEFAULT '',
  `handlerfile` varchar(255) NOT NULL DEFAULT '',
  `handlerfunction` mediumtext,
  `schedule` varchar(255) DEFAULT NULL,
  `status` bigint(10) unsigned NOT NULL DEFAULT '0',
  `internal` tinyint(2) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]evenhand_evecom_uix` (`eventname`,`component`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='This table is for storing which components requests what typ' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]events_handlers`
--

INSERT INTO `[[dbprefix]]events_handlers` VALUES
(1, 'portfolio_send', 'moodle', '/lib/portfolio.php', 's:22:"portfolio_handle_event";', 'cron', 0, 0),
(2, 'user_logout', 'mod_chat', '/mod/chat/lib.php', 's:16:"chat_user_logout";', 'instant', 0, 1),
(3, 'user_enrolled', 'mod_forum', '/mod/forum/lib.php', 's:19:"forum_user_enrolled";', 'instant', 0, 1),
(4, 'user_unenrolled', 'mod_forum', '/mod/forum/lib.php', 's:21:"forum_user_unenrolled";', 'instant', 0, 1),
(5, 'role_assigned', 'enrol_category', '/enrol/category/locallib.php', 'a:2:{i:0;s:22:"enrol_category_handler";i:1;s:13:"role_assigned";}', 'instant', 0, 1),
(6, 'role_unassigned', 'enrol_category', '/enrol/category/locallib.php', 'a:2:{i:0;s:22:"enrol_category_handler";i:1;s:15:"role_unassigned";}', 'instant', 0, 1),
(7, 'cohort_member_added', 'enrol_cohort', '/enrol/cohort/locallib.php', 'a:2:{i:0;s:20:"enrol_cohort_handler";i:1;s:12:"member_added";}', 'instant', 0, 1),
(8, 'cohort_member_removed', 'enrol_cohort', '/enrol/cohort/locallib.php', 'a:2:{i:0;s:20:"enrol_cohort_handler";i:1;s:14:"member_removed";}', 'instant', 0, 1),
(9, 'cohort_deleted', 'enrol_cohort', '/enrol/cohort/locallib.php', 'a:2:{i:0;s:20:"enrol_cohort_handler";i:1;s:7:"deleted";}', 'instant', 0, 1),
(10, 'role_assigned', 'enrol_meta', '/enrol/meta/locallib.php', 'a:2:{i:0;s:18:"enrol_meta_handler";i:1;s:13:"role_assigned";}', 'instant', 0, 1),
(11, 'role_unassigned', 'enrol_meta', '/enrol/meta/locallib.php', 'a:2:{i:0;s:18:"enrol_meta_handler";i:1;s:15:"role_unassigned";}', 'instant', 0, 1),
(12, 'user_enrolled', 'enrol_meta', '/enrol/meta/locallib.php', 'a:2:{i:0;s:18:"enrol_meta_handler";i:1;s:13:"user_enrolled";}', 'instant', 0, 1),
(13, 'user_unenrolled', 'enrol_meta', '/enrol/meta/locallib.php', 'a:2:{i:0;s:18:"enrol_meta_handler";i:1;s:15:"user_unenrolled";}', 'instant', 0, 1),
(14, 'course_deleted', 'enrol_meta', '/enrol/meta/locallib.php', 'a:2:{i:0;s:18:"enrol_meta_handler";i:1;s:14:"course_deleted";}', 'instant', 0, 1),
(15, 'user_deleted', 'portfolio_googledocs', '/portfolio/googledocs/lib.php', 's:33:"portfolio_googledocs_user_deleted";', 'cron', 0, 0),
(16, 'user_deleted', 'portfolio_picasa', '/portfolio/picasa/lib.php', 's:29:"portfolio_picasa_user_deleted";', 'cron', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_queue`
--

CREATE TABLE `[[dbprefix]]events_queue` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `eventdata` longtext NOT NULL,
  `stackdump` mediumtext,
  `userid` bigint(10) unsigned DEFAULT NULL,
  `timecreated` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]evenqueu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='This table is for storing queued events. It stores only one ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_queue_handlers`
--

CREATE TABLE `[[dbprefix]]events_queue_handlers` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `queuedeventid` bigint(10) unsigned NOT NULL,
  `handlerid` bigint(10) unsigned NOT NULL,
  `status` bigint(10) DEFAULT NULL,
  `errormessage` mediumtext,
  `timemodified` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]evenqueuhand_que_ix` (`queuedeventid`),
  KEY `[[dbprefix]]evenqueuhand_han_ix` (`handlerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='This is the list of queued handlers for processing. The even' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_functions`
--

CREATE TABLE `[[dbprefix]]external_functions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `classname` varchar(100) NOT NULL DEFAULT '',
  `methodname` varchar(100) NOT NULL DEFAULT '',
  `classpath` varchar(255) DEFAULT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `capabilities` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]extefunc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='list of all external functions' AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]external_functions`
--

INSERT INTO `[[dbprefix]]external_functions` VALUES
(1, 'moodle_group_create_groups', 'moodle_group_external', 'create_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups'),
(2, 'moodle_group_get_groups', 'moodle_group_external', 'get_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups'),
(3, 'moodle_group_get_course_groups', 'moodle_group_external', 'get_course_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups'),
(4, 'moodle_group_delete_groups', 'moodle_group_external', 'delete_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups'),
(5, 'moodle_group_get_groupmembers', 'moodle_group_external', 'get_groupmembers', 'group/externallib.php', 'moodle', 'moodle/course:managegroups'),
(6, 'moodle_group_add_groupmembers', 'moodle_group_external', 'add_groupmembers', 'group/externallib.php', 'moodle', 'moodle/course:managegroups'),
(7, 'moodle_group_delete_groupmembers', 'moodle_group_external', 'delete_groupmembers', 'group/externallib.php', 'moodle', 'moodle/course:managegroups'),
(8, 'moodle_file_get_files', 'moodle_file_external', 'get_files', 'files/externallib.php', 'moodle', ''),
(9, 'moodle_file_upload', 'moodle_file_external', 'upload', 'files/externallib.php', 'moodle', ''),
(10, 'moodle_user_create_users', 'moodle_user_external', 'create_users', 'user/externallib.php', 'moodle', 'moodle/user:create'),
(11, 'moodle_user_get_users_by_id', 'moodle_user_external', 'get_users_by_id', 'user/externallib.php', 'moodle', 'moodle/user:viewalldetails'),
(12, 'moodle_user_delete_users', 'moodle_user_external', 'delete_users', 'user/externallib.php', 'moodle', 'moodle/user:delete'),
(13, 'moodle_user_update_users', 'moodle_user_external', 'update_users', 'user/externallib.php', 'moodle', 'moodle/user:update'),
(14, 'moodle_enrol_get_enrolled_users', 'moodle_enrol_external', 'get_enrolled_users', 'enrol/externallib.php', 'moodle', 'moodle/site:viewparticipants, moodle/course:viewparticipants,\n            moodle/role:review, moodle/site:accessallgroups, moodle/course:enrolreview'),
(15, 'moodle_role_assign', 'moodle_enrol_external', 'role_assign', 'enrol/externallib.php', 'moodle', 'moodle/role:assign'),
(16, 'moodle_role_unassign', 'moodle_enrol_external', 'role_unassign', 'enrol/externallib.php', 'moodle', 'moodle/role:assign'),
(17, 'moodle_course_get_courses', 'moodle_course_external', 'get_courses', 'course/externallib.php', 'moodle', 'moodle/course:view,moodle/course:update,moodle/course:viewhiddencourses'),
(18, 'moodle_course_create_courses', 'moodle_course_external', 'create_courses', 'course/externallib.php', 'moodle', 'moodle/course:create,moodle/course:visibility'),
(19, 'moodle_enrol_manual_enrol_users', 'moodle_enrol_manual_external', 'manual_enrol_users', 'enrol/manual/externallib.php', 'enrol_manual', 'enrol/manual:enrol');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services`
--

CREATE TABLE `[[dbprefix]]external_services` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `enabled` tinyint(1) unsigned NOT NULL,
  `requiredcapability` varchar(150) DEFAULT NULL,
  `restrictedusers` tinyint(1) unsigned NOT NULL,
  `component` varchar(100) DEFAULT NULL,
  `timecreated` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]exteserv_nam_uix` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='built in and custom external services' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services_functions`
--

CREATE TABLE `[[dbprefix]]external_services_functions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) unsigned NOT NULL,
  `functionname` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]exteservfunc_ext_ix` (`externalserviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='lists functions available in each service group' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services_users`
--

CREATE TABLE `[[dbprefix]]external_services_users` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `iprestriction` varchar(255) DEFAULT NULL,
  `validuntil` bigint(10) unsigned DEFAULT NULL,
  `timecreated` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]exteservuser_ext_ix` (`externalserviceid`),
  KEY `[[dbprefix]]exteservuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='users allowed to use services with restricted users flag' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_tokens`
--

CREATE TABLE `[[dbprefix]]external_tokens` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(128) NOT NULL DEFAULT '',
  `tokentype` smallint(4) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `externalserviceid` bigint(10) unsigned NOT NULL,
  `sid` varchar(128) DEFAULT NULL,
  `contextid` bigint(10) unsigned NOT NULL,
  `creatorid` bigint(20) unsigned NOT NULL DEFAULT '1',
  `iprestriction` varchar(255) DEFAULT NULL,
  `validuntil` bigint(10) unsigned DEFAULT NULL,
  `timecreated` bigint(10) unsigned NOT NULL,
  `lastaccess` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]extetoke_use_ix` (`userid`),
  KEY `[[dbprefix]]extetoke_ext_ix` (`externalserviceid`),
  KEY `[[dbprefix]]extetoke_con_ix` (`contextid`),
  KEY `[[dbprefix]]extetoke_cre_ix` (`creatorid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Security tokens for accessing of external services' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback`
--

CREATE TABLE `[[dbprefix]]feedback` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `anonymous` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `email_notification` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `multiple_submit` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `autonumbering` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `site_after_submit` varchar(255) NOT NULL DEFAULT '',
  `page_after_submit` text NOT NULL,
  `page_after_submitformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `publish_stats` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timeopen` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeclose` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feed_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='all feedbacks' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_completed`
--

CREATE TABLE `[[dbprefix]]feedback_completed` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `random_response` bigint(10) unsigned NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]feedcomp_fee_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='filled out feedback' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_completedtmp`
--

CREATE TABLE `[[dbprefix]]feedback_completedtmp` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `guestid` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `random_response` bigint(10) unsigned NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedcomp_use2_ix` (`userid`),
  KEY `[[dbprefix]]feedcomp_fee2_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='filled out feedback' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_item`
--

CREATE TABLE `[[dbprefix]]feedback_item` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) unsigned NOT NULL DEFAULT '0',
  `template` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `presentation` text NOT NULL,
  `typ` varchar(255) NOT NULL DEFAULT '',
  `hasvalue` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `position` smallint(3) unsigned NOT NULL DEFAULT '0',
  `required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dependitem` bigint(10) unsigned NOT NULL DEFAULT '0',
  `dependvalue` varchar(255) NOT NULL DEFAULT '',
  `options` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feeditem_fee_ix` (`feedback`),
  KEY `[[dbprefix]]feeditem_tem_ix` (`template`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='feedback_items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_sitecourse_map`
--

CREATE TABLE `[[dbprefix]]feedback_sitecourse_map` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `feedbackid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedsitemap_cou_ix` (`courseid`),
  KEY `[[dbprefix]]feedsitemap_fee_ix` (`feedbackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='feedback sitecourse map' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_template`
--

CREATE TABLE `[[dbprefix]]feedback_template` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedtemp_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='templates of feedbackstructures' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_tracking`
--

CREATE TABLE `[[dbprefix]]feedback_tracking` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `feedback` bigint(10) unsigned NOT NULL DEFAULT '0',
  `completed` bigint(10) unsigned NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedtrac_use_ix` (`userid`),
  KEY `[[dbprefix]]feedtrac_fee_ix` (`feedback`),
  KEY `[[dbprefix]]feedtrac_com_ix` (`completed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='feedback trackingdata' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_value`
--

CREATE TABLE `[[dbprefix]]feedback_value` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) unsigned NOT NULL DEFAULT '0',
  `item` bigint(10) unsigned NOT NULL DEFAULT '0',
  `completed` bigint(10) unsigned NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) unsigned NOT NULL DEFAULT '0',
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedvalu_cou_ix` (`course_id`),
  KEY `[[dbprefix]]feedvalu_ite_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='values of the completeds' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_valuetmp`
--

CREATE TABLE `[[dbprefix]]feedback_valuetmp` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) unsigned NOT NULL DEFAULT '0',
  `item` bigint(10) unsigned NOT NULL DEFAULT '0',
  `completed` bigint(10) unsigned NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) unsigned NOT NULL DEFAULT '0',
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedvalu_cou2_ix` (`course_id`),
  KEY `[[dbprefix]]feedvalu_ite2_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='values of the completedstmp' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files`
--

CREATE TABLE `[[dbprefix]]files` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `contenthash` varchar(40) NOT NULL DEFAULT '',
  `pathnamehash` varchar(40) NOT NULL DEFAULT '',
  `contextid` bigint(10) unsigned NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `filearea` varchar(50) NOT NULL DEFAULT '',
  `itemid` bigint(10) unsigned NOT NULL,
  `filepath` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `userid` bigint(10) unsigned DEFAULT NULL,
  `filesize` bigint(10) unsigned NOT NULL,
  `mimetype` varchar(100) DEFAULT NULL,
  `status` bigint(10) unsigned NOT NULL DEFAULT '0',
  `source` text,
  `author` varchar(255) DEFAULT NULL,
  `license` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]file_pat_uix` (`pathnamehash`),
  KEY `[[dbprefix]]file_comfilconite_ix` (`component`,`filearea`,`contextid`,`itemid`),
  KEY `[[dbprefix]]file_con_ix` (`contenthash`),
  KEY `[[dbprefix]]file_con2_ix` (`contextid`),
  KEY `[[dbprefix]]file_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='description of files, content is stored in sha1 file pool' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_active`
--

CREATE TABLE `[[dbprefix]]filter_active` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) NOT NULL DEFAULT '',
  `contextid` bigint(10) unsigned NOT NULL,
  `active` smallint(4) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filtacti_confil_uix` (`contextid`,`filter`),
  KEY `[[dbprefix]]filtacti_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores information about which filters are active in which c' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_config`
--

CREATE TABLE `[[dbprefix]]filter_config` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) NOT NULL DEFAULT '',
  `contextid` bigint(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filtconf_confilnam_uix` (`contextid`,`filter`,`name`),
  KEY `[[dbprefix]]filtconf_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores per-context configuration settings for filters which ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]folder`
--

CREATE TABLE `[[dbprefix]]folder` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `revision` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]fold_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='each record is one folder resource' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum`
--

CREATE TABLE `[[dbprefix]]forum` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL DEFAULT 'general',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `assessed` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) unsigned NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) unsigned NOT NULL DEFAULT '0',
  `maxattachments` bigint(10) unsigned NOT NULL DEFAULT '1',
  `forcesubscribe` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `trackingtype` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `rsstype` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `warnafter` bigint(10) unsigned NOT NULL DEFAULT '0',
  `blockafter` bigint(10) unsigned NOT NULL DEFAULT '0',
  `blockperiod` bigint(10) unsigned NOT NULL DEFAULT '0',
  `completiondiscussions` int(9) unsigned NOT NULL DEFAULT '0',
  `completionreplies` int(9) unsigned NOT NULL DEFAULT '0',
  `completionposts` int(9) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foru_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Forums contain and structure discussion' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_discussions`
--

CREATE TABLE `[[dbprefix]]forum_discussions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `forum` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `firstpost` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '-1',
  `assessed` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `usermodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timestart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeend` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forudisc_use_ix` (`userid`),
  KEY `[[dbprefix]]forudisc_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Forums are composed of discussions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_posts`
--

CREATE TABLE `[[dbprefix]]forum_posts` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `discussion` bigint(10) unsigned NOT NULL DEFAULT '0',
  `parent` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `created` bigint(10) unsigned NOT NULL DEFAULT '0',
  `modified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `mailed` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `messageformat` tinyint(2) NOT NULL DEFAULT '0',
  `messagetrust` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `attachment` varchar(100) NOT NULL DEFAULT '',
  `totalscore` smallint(4) NOT NULL DEFAULT '0',
  `mailnow` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forupost_use_ix` (`userid`),
  KEY `[[dbprefix]]forupost_cre_ix` (`created`),
  KEY `[[dbprefix]]forupost_mai_ix` (`mailed`),
  KEY `[[dbprefix]]forupost_dis_ix` (`discussion`),
  KEY `[[dbprefix]]forupost_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All posts are stored in this table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_queue`
--

CREATE TABLE `[[dbprefix]]forum_queue` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `discussionid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `postid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foruqueu_use_ix` (`userid`),
  KEY `[[dbprefix]]foruqueu_dis_ix` (`discussionid`),
  KEY `[[dbprefix]]foruqueu_pos_ix` (`postid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='For keeping track of posts that will be mailed in digest for' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_read`
--

CREATE TABLE `[[dbprefix]]forum_read` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `forumid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `discussionid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `postid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `firstread` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lastread` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foruread_usefor_ix` (`userid`,`forumid`),
  KEY `[[dbprefix]]foruread_usedis_ix` (`userid`,`discussionid`),
  KEY `[[dbprefix]]foruread_usepos_ix` (`userid`,`postid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tracks each users read posts' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_subscriptions`
--

CREATE TABLE `[[dbprefix]]forum_subscriptions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `forum` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forusubs_use_ix` (`userid`),
  KEY `[[dbprefix]]forusubs_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Keeps track of who is subscribed to what forum' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_track_prefs`
--

CREATE TABLE `[[dbprefix]]forum_track_prefs` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `forumid` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forutracpref_usefor_ix` (`userid`,`forumid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tracks each users untracked forums' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary`
--

CREATE TABLE `[[dbprefix]]glossary` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `allowduplicatedentries` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `displayformat` varchar(50) NOT NULL DEFAULT 'dictionary',
  `mainglossary` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `showspecial` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `showalphabet` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `showall` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `allowcomments` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `allowprintview` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `usedynalink` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `defaultapproval` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `globalglossary` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `entbypage` smallint(3) unsigned NOT NULL DEFAULT '10',
  `editalways` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `rsstype` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `assessed` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) unsigned NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `completionentries` int(9) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glos_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='all glossaries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_alias`
--

CREATE TABLE `[[dbprefix]]glossary_alias` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `entryid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `alias` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosalia_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='entries alias' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_categories`
--

CREATE TABLE `[[dbprefix]]glossary_categories` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `usedynalink` tinyint(2) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gloscate_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='all categories for glossary entries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_entries`
--

CREATE TABLE `[[dbprefix]]glossary_entries` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `concept` varchar(255) NOT NULL DEFAULT '',
  `definition` text NOT NULL,
  `definitionformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `definitiontrust` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `attachment` varchar(100) NOT NULL DEFAULT '',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `teacherentry` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `sourceglossaryid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `usedynalink` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `casesensitive` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `fullmatch` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `approved` tinyint(2) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosentr_use_ix` (`userid`),
  KEY `[[dbprefix]]glosentr_con_ix` (`concept`),
  KEY `[[dbprefix]]glosentr_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='all glossary entries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_entries_categories`
--

CREATE TABLE `[[dbprefix]]glossary_entries_categories` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoryid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `entryid` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosentrcate_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]glosentrcate_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='categories of each glossary entry' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_formats`
--

CREATE TABLE `[[dbprefix]]glossary_formats` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `popupformatname` varchar(50) NOT NULL DEFAULT '',
  `visible` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `showgroup` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `defaultmode` varchar(50) NOT NULL DEFAULT '',
  `defaulthook` varchar(50) NOT NULL DEFAULT '',
  `sortkey` varchar(50) NOT NULL DEFAULT '',
  `sortorder` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Setting of the display formats' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]glossary_formats`
--

INSERT INTO `[[dbprefix]]glossary_formats` VALUES
(1, 'continuous', 'continuous', 1, 1, '', '', '', ''),
(2, 'dictionary', 'dictionary', 1, 1, '', '', '', ''),
(3, 'encyclopedia', 'encyclopedia', 1, 1, '', '', '', ''),
(4, 'entrylist', 'entrylist', 1, 1, '', '', '', ''),
(5, 'faq', 'faq', 1, 1, '', '', '', ''),
(6, 'fullwithauthor', 'fullwithauthor', 1, 1, '', '', '', ''),
(7, 'fullwithoutauthor', 'fullwithoutauthor', 1, 1, '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_categories`
--

CREATE TABLE `[[dbprefix]]grade_categories` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL,
  `parent` bigint(10) unsigned DEFAULT NULL,
  `depth` bigint(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) DEFAULT NULL,
  `fullname` varchar(255) NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `aggregatesubcats` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradcate_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradcate_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='This table keeps information about categories, used for grou' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_categories_history`
--

CREATE TABLE `[[dbprefix]]grade_categories_history` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `action` bigint(10) unsigned NOT NULL DEFAULT '0',
  `oldid` bigint(10) unsigned NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  `loggeduser` bigint(10) unsigned DEFAULT NULL,
  `courseid` bigint(10) unsigned NOT NULL,
  `parent` bigint(10) unsigned DEFAULT NULL,
  `depth` bigint(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) DEFAULT NULL,
  `fullname` varchar(255) NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `aggregatesubcats` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradcatehist_act_ix` (`action`),
  KEY `[[dbprefix]]gradcatehist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradcatehist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradcatehist_par_ix` (`parent`),
  KEY `[[dbprefix]]gradcatehist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='History of grade_categories' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_grades`
--

CREATE TABLE `[[dbprefix]]grade_grades` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) unsigned DEFAULT NULL,
  `usermodified` bigint(10) unsigned DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) unsigned NOT NULL DEFAULT '0',
  `locked` bigint(10) unsigned NOT NULL DEFAULT '0',
  `locktime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `exported` bigint(10) unsigned NOT NULL DEFAULT '0',
  `overridden` bigint(10) unsigned NOT NULL DEFAULT '0',
  `excluded` bigint(10) unsigned NOT NULL DEFAULT '0',
  `feedback` mediumtext,
  `feedbackformat` bigint(10) unsigned NOT NULL DEFAULT '0',
  `information` mediumtext,
  `informationformat` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned DEFAULT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradgrad_useite_uix` (`userid`,`itemid`),
  KEY `[[dbprefix]]gradgrad_locloc_ix` (`locked`,`locktime`),
  KEY `[[dbprefix]]gradgrad_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]gradgrad_raw_ix` (`rawscaleid`),
  KEY `[[dbprefix]]gradgrad_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='grade_grades  This table keeps individual grades for each us' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_grades_history`
--

CREATE TABLE `[[dbprefix]]grade_grades_history` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `action` bigint(10) unsigned NOT NULL DEFAULT '0',
  `oldid` bigint(10) unsigned NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  `loggeduser` bigint(10) unsigned DEFAULT NULL,
  `itemid` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) unsigned DEFAULT NULL,
  `usermodified` bigint(10) unsigned DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) unsigned NOT NULL DEFAULT '0',
  `locked` bigint(10) unsigned NOT NULL DEFAULT '0',
  `locktime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `exported` bigint(10) unsigned NOT NULL DEFAULT '0',
  `overridden` bigint(10) unsigned NOT NULL DEFAULT '0',
  `excluded` bigint(10) unsigned NOT NULL DEFAULT '0',
  `feedback` mediumtext,
  `feedbackformat` bigint(10) unsigned NOT NULL DEFAULT '0',
  `information` mediumtext,
  `informationformat` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradgradhist_act_ix` (`action`),
  KEY `[[dbprefix]]gradgradhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradgradhist_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradgradhist_use_ix` (`userid`),
  KEY `[[dbprefix]]gradgradhist_raw_ix` (`rawscaleid`),
  KEY `[[dbprefix]]gradgradhist_use2_ix` (`usermodified`),
  KEY `[[dbprefix]]gradgradhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='History table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_import_newitem`
--

CREATE TABLE `[[dbprefix]]grade_import_newitem` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `itemname` varchar(255) NOT NULL DEFAULT '',
  `importcode` bigint(10) unsigned NOT NULL,
  `importer` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradimponewi_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='temporary table for storing new grade_item names from grade ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_import_values`
--

CREATE TABLE `[[dbprefix]]grade_import_values` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) unsigned DEFAULT NULL,
  `newgradeitem` bigint(10) unsigned DEFAULT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `feedback` mediumtext,
  `importcode` bigint(10) unsigned NOT NULL,
  `importer` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradimpovalu_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradimpovalu_new_ix` (`newgradeitem`),
  KEY `[[dbprefix]]gradimpovalu_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary table for importing grades' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_items`
--

CREATE TABLE `[[dbprefix]]grade_items` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned DEFAULT NULL,
  `categoryid` bigint(10) unsigned DEFAULT NULL,
  `itemname` varchar(255) DEFAULT NULL,
  `itemtype` varchar(30) NOT NULL DEFAULT '',
  `itemmodule` varchar(30) DEFAULT NULL,
  `iteminstance` bigint(10) unsigned DEFAULT NULL,
  `itemnumber` bigint(10) unsigned DEFAULT NULL,
  `iteminfo` mediumtext,
  `idnumber` varchar(255) DEFAULT NULL,
  `calculation` mediumtext,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) unsigned DEFAULT NULL,
  `outcomeid` bigint(10) unsigned DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  `decimals` tinyint(1) unsigned DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned DEFAULT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]graditem_locloc_ix` (`locked`,`locktime`),
  KEY `[[dbprefix]]graditem_itenee_ix` (`itemtype`,`needsupdate`),
  KEY `[[dbprefix]]graditem_gra_ix` (`gradetype`),
  KEY `[[dbprefix]]graditem_idncou_ix` (`idnumber`,`courseid`),
  KEY `[[dbprefix]]graditem_cou_ix` (`courseid`),
  KEY `[[dbprefix]]graditem_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]graditem_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]graditem_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='This table keeps information about gradeable items (ie colum' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_items_history`
--

CREATE TABLE `[[dbprefix]]grade_items_history` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `action` bigint(10) unsigned NOT NULL DEFAULT '0',
  `oldid` bigint(10) unsigned NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  `loggeduser` bigint(10) unsigned DEFAULT NULL,
  `courseid` bigint(10) unsigned DEFAULT NULL,
  `categoryid` bigint(10) unsigned DEFAULT NULL,
  `itemname` varchar(255) DEFAULT NULL,
  `itemtype` varchar(30) NOT NULL DEFAULT '',
  `itemmodule` varchar(30) DEFAULT NULL,
  `iteminstance` bigint(10) unsigned DEFAULT NULL,
  `itemnumber` bigint(10) unsigned DEFAULT NULL,
  `iteminfo` mediumtext,
  `idnumber` varchar(255) DEFAULT NULL,
  `calculation` mediumtext,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) unsigned DEFAULT NULL,
  `outcomeid` bigint(10) unsigned DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]graditemhist_act_ix` (`action`),
  KEY `[[dbprefix]]graditemhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]graditemhist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]graditemhist_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]graditemhist_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]graditemhist_out_ix` (`outcomeid`),
  KEY `[[dbprefix]]graditemhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='History of grade_items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_letters`
--

CREATE TABLE `[[dbprefix]]grade_letters` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) unsigned NOT NULL,
  `lowerboundary` decimal(10,5) NOT NULL,
  `letter` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradlett_conlowlet_uix` (`contextid`,`lowerboundary`,`letter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Repository for grade letters, for courses and other moodle e' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes`
--

CREATE TABLE `[[dbprefix]]grade_outcomes` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned DEFAULT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `fullname` text NOT NULL,
  `scaleid` bigint(10) unsigned DEFAULT NULL,
  `description` text,
  `descriptionformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned DEFAULT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  `usermodified` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradoutc_cousho_uix` (`courseid`,`shortname`),
  KEY `[[dbprefix]]gradoutc_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutc_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]gradoutc_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='This table describes the outcomes used in the system. An out' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes_courses`
--

CREATE TABLE `[[dbprefix]]grade_outcomes_courses` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL,
  `outcomeid` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradoutccour_couout_uix` (`courseid`,`outcomeid`),
  KEY `[[dbprefix]]gradoutccour_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutccour_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='stores what outcomes are used in what courses.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes_history`
--

CREATE TABLE `[[dbprefix]]grade_outcomes_history` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `action` bigint(10) unsigned NOT NULL DEFAULT '0',
  `oldid` bigint(10) unsigned NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  `loggeduser` bigint(10) unsigned DEFAULT NULL,
  `courseid` bigint(10) unsigned DEFAULT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `fullname` text NOT NULL,
  `scaleid` bigint(10) unsigned DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradoutchist_act_ix` (`action`),
  KEY `[[dbprefix]]gradoutchist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradoutchist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutchist_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]gradoutchist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='History table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_settings`
--

CREATE TABLE `[[dbprefix]]grade_settings` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradsett_counam_uix` (`courseid`,`name`),
  KEY `[[dbprefix]]gradsett_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='gradebook settings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groupings`
--

CREATE TABLE `[[dbprefix]]groupings` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `descriptionformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `configdata` text,
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grou_cou2_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A grouping is a collection of groups. WAS: groups_groupings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groupings_groups`
--

CREATE TABLE `[[dbprefix]]groupings_groups` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupingid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `groupid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeadded` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grougrou_gro_ix` (`groupingid`),
  KEY `[[dbprefix]]grougrou_gro2_ix` (`groupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Link a grouping to a group (note, groups can be in multiple ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL,
  `name` varchar(254) NOT NULL DEFAULT '',
  `description` text,
  `descriptionformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `enrolmentkey` varchar(50) DEFAULT NULL,
  `picture` bigint(10) unsigned NOT NULL DEFAULT '0',
  `hidepicture` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grou_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each record represents a group.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups_members`
--

CREATE TABLE `[[dbprefix]]groups_members` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeadded` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]groumemb_gro_ix` (`groupid`),
  KEY `[[dbprefix]]groumemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Link a user to a group.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]imscp`
--

CREATE TABLE `[[dbprefix]]imscp` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `revision` bigint(10) unsigned NOT NULL DEFAULT '0',
  `keepold` bigint(10) NOT NULL DEFAULT '-1',
  `structure` mediumtext,
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]imsc_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='each record is one imscp resource' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]label`
--

CREATE TABLE `[[dbprefix]]label` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]labe_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines labels' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson`
--

CREATE TABLE `[[dbprefix]]lesson` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `practice` smallint(3) unsigned NOT NULL DEFAULT '0',
  `modattempts` smallint(3) unsigned NOT NULL DEFAULT '0',
  `usepassword` smallint(3) unsigned NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL DEFAULT '',
  `dependency` bigint(10) unsigned NOT NULL DEFAULT '0',
  `conditions` text NOT NULL,
  `grade` smallint(3) NOT NULL DEFAULT '0',
  `custom` smallint(3) unsigned NOT NULL DEFAULT '0',
  `ongoing` smallint(3) unsigned NOT NULL DEFAULT '0',
  `usemaxgrade` smallint(3) NOT NULL DEFAULT '0',
  `maxanswers` smallint(3) unsigned NOT NULL DEFAULT '4',
  `maxattempts` smallint(3) unsigned NOT NULL DEFAULT '5',
  `review` smallint(3) unsigned NOT NULL DEFAULT '0',
  `nextpagedefault` smallint(3) unsigned NOT NULL DEFAULT '0',
  `feedback` smallint(3) unsigned NOT NULL DEFAULT '1',
  `minquestions` smallint(3) unsigned NOT NULL DEFAULT '0',
  `maxpages` smallint(3) unsigned NOT NULL DEFAULT '0',
  `timed` smallint(3) unsigned NOT NULL DEFAULT '0',
  `maxtime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `retake` smallint(3) unsigned NOT NULL DEFAULT '1',
  `activitylink` bigint(10) unsigned NOT NULL DEFAULT '0',
  `mediafile` varchar(255) NOT NULL DEFAULT '',
  `mediaheight` bigint(10) unsigned NOT NULL DEFAULT '100',
  `mediawidth` bigint(10) unsigned NOT NULL DEFAULT '650',
  `mediaclose` smallint(3) unsigned NOT NULL DEFAULT '0',
  `slideshow` smallint(3) unsigned NOT NULL DEFAULT '0',
  `width` bigint(10) unsigned NOT NULL DEFAULT '640',
  `height` bigint(10) unsigned NOT NULL DEFAULT '480',
  `bgcolor` varchar(7) NOT NULL DEFAULT '#FFFFFF',
  `displayleft` smallint(3) unsigned NOT NULL DEFAULT '0',
  `displayleftif` smallint(3) unsigned NOT NULL DEFAULT '0',
  `progressbar` smallint(3) unsigned NOT NULL DEFAULT '0',
  `highscores` smallint(3) unsigned NOT NULL DEFAULT '0',
  `maxhighscores` bigint(10) unsigned NOT NULL DEFAULT '0',
  `available` bigint(10) unsigned NOT NULL DEFAULT '0',
  `deadline` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]less_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines lesson' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_answers`
--

CREATE TABLE `[[dbprefix]]lesson_answers` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `pageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `jumpto` bigint(11) NOT NULL DEFAULT '0',
  `grade` smallint(4) NOT NULL DEFAULT '0',
  `score` bigint(10) NOT NULL DEFAULT '0',
  `flags` smallint(3) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `answer` text,
  `answerformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `response` text,
  `responseformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessansw_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessansw_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines lesson_answers' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_attempts`
--

CREATE TABLE `[[dbprefix]]lesson_attempts` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `pageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `answerid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `retry` smallint(3) unsigned NOT NULL DEFAULT '0',
  `correct` bigint(10) unsigned NOT NULL DEFAULT '0',
  `useranswer` text,
  `timeseen` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessatte_use_ix` (`userid`),
  KEY `[[dbprefix]]lessatte_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessatte_pag_ix` (`pageid`),
  KEY `[[dbprefix]]lessatte_ans_ix` (`answerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines lesson_attempts' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_branch`
--

CREATE TABLE `[[dbprefix]]lesson_branch` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `pageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `retry` bigint(10) unsigned NOT NULL DEFAULT '0',
  `flag` smallint(3) unsigned NOT NULL DEFAULT '0',
  `timeseen` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessbran_use_ix` (`userid`),
  KEY `[[dbprefix]]lessbran_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessbran_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='branches for each lesson/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_grades`
--

CREATE TABLE `[[dbprefix]]lesson_grades` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `grade` double unsigned NOT NULL DEFAULT '0',
  `late` smallint(3) unsigned NOT NULL DEFAULT '0',
  `completed` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]lessgrad_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines lesson_grades' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_high_scores`
--

CREATE TABLE `[[dbprefix]]lesson_high_scores` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `gradeid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `nickname` varchar(5) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lesshighscor_use_ix` (`userid`),
  KEY `[[dbprefix]]lesshighscor_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='high scores for each lesson' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_pages`
--

CREATE TABLE `[[dbprefix]]lesson_pages` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `prevpageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `nextpageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `qtype` smallint(3) unsigned NOT NULL DEFAULT '0',
  `qoption` smallint(3) unsigned NOT NULL DEFAULT '0',
  `layout` smallint(3) unsigned NOT NULL DEFAULT '1',
  `display` smallint(3) unsigned NOT NULL DEFAULT '1',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `contents` text NOT NULL,
  `contentsformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lesspage_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines lesson_pages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_timer`
--

CREATE TABLE `[[dbprefix]]lesson_timer` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `starttime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lessontime` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lesstime_use_ix` (`userid`),
  KEY `[[dbprefix]]lesstime_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='lesson timer for each lesson' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]license`
--

CREATE TABLE `[[dbprefix]]license` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `shortname` varchar(255) DEFAULT NULL,
  `fullname` text,
  `source` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `version` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='store licenses used by moodle' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]license`
--

INSERT INTO `[[dbprefix]]license` VALUES
(1, 'unknown', 'Unknown license', '', 1, 2010033100),
(2, 'allrightsreserved', 'All rights reserved', 'http://en.wikipedia.org/wiki/All_rights_reserved', 1, 2010033100),
(3, 'public', 'Public Domain', 'http://creativecommons.org/licenses/publicdomain/', 1, 2010033100),
(4, 'cc', 'Creative Commons', 'http://creativecommons.org/licenses/by/3.0/', 1, 2010033100),
(5, 'cc-nd', 'Creative Commons - NoDerivs', 'http://creativecommons.org/licenses/by-nd/3.0/', 1, 2010033100),
(6, 'cc-nc-nd', 'Creative Commons - No Commercial NoDerivs', 'http://creativecommons.org/licenses/by-nc-nd/3.0/', 1, 2010033100),
(7, 'cc-nc', 'Creative Commons - No Commercial', 'http://creativecommons.org/licenses/by-nd/3.0/', 1, 2010033100),
(8, 'cc-nc-sa', 'Creative Commons - No Commercial ShareAlike', 'http://creativecommons.org/licenses/by-nc-sa/3.0/', 1, 2010033100),
(9, 'cc-sa', 'Creative Commons - ShareAlike', 'http://creativecommons.org/licenses/by-sa/3.0/', 1, 2010033100);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `module` varchar(20) NOT NULL DEFAULT '',
  `cmid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `action` varchar(40) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `info` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]log_coumodact_ix` (`course`,`module`,`action`),
  KEY `[[dbprefix]]log_tim_ix` (`time`),
  KEY `[[dbprefix]]log_act_ix` (`action`),
  KEY `[[dbprefix]]log_usecou_ix` (`userid`,`course`),
  KEY `[[dbprefix]]log_cmi_ix` (`cmid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Every action is logged as far as possible' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]log`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_display`
--

CREATE TABLE `[[dbprefix]]log_display` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(20) NOT NULL DEFAULT '',
  `action` varchar(40) NOT NULL DEFAULT '',
  `mtable` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(200) NOT NULL DEFAULT '',
  `component` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]logdisp_modact_uix` (`module`,`action`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='For a particular module/action, specifies a moodle table/fie' AUTO_INCREMENT=141 ;

--
-- Dumping data for table `[[dbprefix]]log_display`
--

INSERT INTO `[[dbprefix]]log_display` VALUES
(1, 'user', 'view', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(2, 'course', 'user report', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(3, 'course', 'view', 'course', 'fullname', 'moodle'),
(4, 'course', 'update', 'course', 'fullname', 'moodle'),
(5, 'course', 'enrol', 'course', 'fullname', 'moodle'),
(6, 'course', 'unenrol', 'course', 'fullname', 'moodle'),
(7, 'course', 'report log', 'course', 'fullname', 'moodle'),
(8, 'course', 'report live', 'course', 'fullname', 'moodle'),
(9, 'course', 'report outline', 'course', 'fullname', 'moodle'),
(10, 'course', 'report participation', 'course', 'fullname', 'moodle'),
(11, 'course', 'report stats', 'course', 'fullname', 'moodle'),
(12, 'message', 'write', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(13, 'message', 'read', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(14, 'message', 'add contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(15, 'message', 'remove contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(16, 'message', 'block contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(17, 'message', 'unblock contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(18, 'group', 'view', 'groups', 'name', 'moodle'),
(19, 'tag', 'update', 'tag', 'name', 'moodle'),
(20, 'assignment', 'view', 'assignment', 'name', 'mod_assignment'),
(21, 'assignment', 'add', 'assignment', 'name', 'mod_assignment'),
(22, 'assignment', 'update', 'assignment', 'name', 'mod_assignment'),
(23, 'assignment', 'view submission', 'assignment', 'name', 'mod_assignment'),
(24, 'assignment', 'upload', 'assignment', 'name', 'mod_assignment'),
(25, 'chat', 'view', 'chat', 'name', 'mod_chat'),
(26, 'chat', 'add', 'chat', 'name', 'mod_chat'),
(27, 'chat', 'update', 'chat', 'name', 'mod_chat'),
(28, 'chat', 'report', 'chat', 'name', 'mod_chat'),
(29, 'chat', 'talk', 'chat', 'name', 'mod_chat'),
(30, 'choice', 'view', 'choice', 'name', 'mod_choice'),
(31, 'choice', 'update', 'choice', 'name', 'mod_choice'),
(32, 'choice', 'add', 'choice', 'name', 'mod_choice'),
(33, 'choice', 'report', 'choice', 'name', 'mod_choice'),
(34, 'choice', 'choose', 'choice', 'name', 'mod_choice'),
(35, 'choice', 'choose again', 'choice', 'name', 'mod_choice'),
(36, 'data', 'view', 'data', 'name', 'mod_data'),
(37, 'data', 'add', 'data', 'name', 'mod_data'),
(38, 'data', 'update', 'data', 'name', 'mod_data'),
(39, 'data', 'record delete', 'data', 'name', 'mod_data'),
(40, 'data', 'fields add', 'data_fields', 'name', 'mod_data'),
(41, 'data', 'fields update', 'data_fields', 'name', 'mod_data'),
(42, 'data', 'templates saved', 'data', 'name', 'mod_data'),
(43, 'data', 'templates def', 'data', 'name', 'mod_data'),
(44, 'feedback', 'startcomplete', 'feedback', 'name', 'mod_feedback'),
(45, 'feedback', 'submit', 'feedback', 'name', 'mod_feedback'),
(46, 'feedback', 'delete', 'feedback', 'name', 'mod_feedback'),
(47, 'feedback', 'view', 'feedback', 'name', 'mod_feedback'),
(48, 'feedback', 'view all', 'course', 'shortname', 'mod_feedback'),
(49, 'folder', 'view', 'folder', 'name', 'mod_folder'),
(50, 'folder', 'view all', 'folder', 'name', 'mod_folder'),
(51, 'folder', 'update', 'folder', 'name', 'mod_folder'),
(52, 'folder', 'add', 'folder', 'name', 'mod_folder'),
(53, 'forum', 'add', 'forum', 'name', 'mod_forum'),
(54, 'forum', 'update', 'forum', 'name', 'mod_forum'),
(55, 'forum', 'add discussion', 'forum_discussions', 'name', 'mod_forum'),
(56, 'forum', 'add post', 'forum_posts', 'subject', 'mod_forum'),
(57, 'forum', 'update post', 'forum_posts', 'subject', 'mod_forum'),
(58, 'forum', 'user report', 'user', 'CONCAT(firstname, '' '', lastname)', 'mod_forum'),
(59, 'forum', 'move discussion', 'forum_discussions', 'name', 'mod_forum'),
(60, 'forum', 'view subscribers', 'forum', 'name', 'mod_forum'),
(61, 'forum', 'view discussion', 'forum_discussions', 'name', 'mod_forum'),
(62, 'forum', 'view forum', 'forum', 'name', 'mod_forum'),
(63, 'forum', 'subscribe', 'forum', 'name', 'mod_forum'),
(64, 'forum', 'unsubscribe', 'forum', 'name', 'mod_forum'),
(65, 'glossary', 'add', 'glossary', 'name', 'mod_glossary'),
(66, 'glossary', 'update', 'glossary', 'name', 'mod_glossary'),
(67, 'glossary', 'view', 'glossary', 'name', 'mod_glossary'),
(68, 'glossary', 'view all', 'glossary', 'name', 'mod_glossary'),
(69, 'glossary', 'add entry', 'glossary', 'name', 'mod_glossary'),
(70, 'glossary', 'update entry', 'glossary', 'name', 'mod_glossary'),
(71, 'glossary', 'add category', 'glossary', 'name', 'mod_glossary'),
(72, 'glossary', 'update category', 'glossary', 'name', 'mod_glossary'),
(73, 'glossary', 'delete category', 'glossary', 'name', 'mod_glossary'),
(74, 'glossary', 'approve entry', 'glossary', 'name', 'mod_glossary'),
(75, 'glossary', 'view entry', 'glossary_entries', 'concept', 'mod_glossary'),
(76, 'imscp', 'view', 'imscp', 'name', 'mod_imscp'),
(77, 'imscp', 'view all', 'imscp', 'name', 'mod_imscp'),
(78, 'imscp', 'update', 'imscp', 'name', 'mod_imscp'),
(79, 'imscp', 'add', 'imscp', 'name', 'mod_imscp'),
(80, 'label', 'add', 'label', 'name', 'mod_label'),
(81, 'label', 'update', 'label', 'name', 'mod_label'),
(82, 'lesson', 'start', 'lesson', 'name', 'mod_lesson'),
(83, 'lesson', 'end', 'lesson', 'name', 'mod_lesson'),
(84, 'lesson', 'view', 'lesson_pages', 'title', 'mod_lesson'),
(85, 'page', 'view', 'page', 'name', 'mod_page'),
(86, 'page', 'view all', 'page', 'name', 'mod_page'),
(87, 'page', 'update', 'page', 'name', 'mod_page'),
(88, 'page', 'add', 'page', 'name', 'mod_page'),
(89, 'quiz', 'add', 'quiz', 'name', 'mod_quiz'),
(90, 'quiz', 'update', 'quiz', 'name', 'mod_quiz'),
(91, 'quiz', 'view', 'quiz', 'name', 'mod_quiz'),
(92, 'quiz', 'report', 'quiz', 'name', 'mod_quiz'),
(93, 'quiz', 'attempt', 'quiz', 'name', 'mod_quiz'),
(94, 'quiz', 'submit', 'quiz', 'name', 'mod_quiz'),
(95, 'quiz', 'review', 'quiz', 'name', 'mod_quiz'),
(96, 'quiz', 'editquestions', 'quiz', 'name', 'mod_quiz'),
(97, 'quiz', 'preview', 'quiz', 'name', 'mod_quiz'),
(98, 'quiz', 'start attempt', 'quiz', 'name', 'mod_quiz'),
(99, 'quiz', 'close attempt', 'quiz', 'name', 'mod_quiz'),
(100, 'quiz', 'continue attempt', 'quiz', 'name', 'mod_quiz'),
(101, 'quiz', 'edit override', 'quiz', 'name', 'mod_quiz'),
(102, 'quiz', 'delete override', 'quiz', 'name', 'mod_quiz'),
(103, 'resource', 'view', 'resource', 'name', 'mod_resource'),
(104, 'resource', 'view all', 'resource', 'name', 'mod_resource'),
(105, 'resource', 'update', 'resource', 'name', 'mod_resource'),
(106, 'resource', 'add', 'resource', 'name', 'mod_resource'),
(107, 'scorm', 'view', 'scorm', 'name', 'mod_scorm'),
(108, 'scorm', 'review', 'scorm', 'name', 'mod_scorm'),
(109, 'scorm', 'update', 'scorm', 'name', 'mod_scorm'),
(110, 'scorm', 'add', 'scorm', 'name', 'mod_scorm'),
(111, 'survey', 'add', 'survey', 'name', 'mod_survey'),
(112, 'survey', 'update', 'survey', 'name', 'mod_survey'),
(113, 'survey', 'download', 'survey', 'name', 'mod_survey'),
(114, 'survey', 'view form', 'survey', 'name', 'mod_survey'),
(115, 'survey', 'view graph', 'survey', 'name', 'mod_survey'),
(116, 'survey', 'view report', 'survey', 'name', 'mod_survey'),
(117, 'survey', 'submit', 'survey', 'name', 'mod_survey'),
(118, 'url', 'view', 'url', 'name', 'mod_url'),
(119, 'url', 'view all', 'url', 'name', 'mod_url'),
(120, 'url', 'update', 'url', 'name', 'mod_url'),
(121, 'url', 'add', 'url', 'name', 'mod_url'),
(122, 'workshop', 'add', 'workshop', 'name', 'mod_workshop'),
(123, 'workshop', 'update', 'workshop', 'name', 'mod_workshop'),
(124, 'workshop', 'view', 'workshop', 'name', 'mod_workshop'),
(125, 'workshop', 'view all', 'workshop', 'name', 'mod_workshop'),
(126, 'workshop', 'add submission', 'workshop_submissions', 'title', 'mod_workshop'),
(127, 'workshop', 'update submission', 'workshop_submissions', 'title', 'mod_workshop'),
(128, 'workshop', 'view submission', 'workshop_submissions', 'title', 'mod_workshop'),
(129, 'workshop', 'add assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(130, 'workshop', 'update assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(131, 'workshop', 'add example', 'workshop_submissions', 'title', 'mod_workshop'),
(132, 'workshop', 'update example', 'workshop_submissions', 'title', 'mod_workshop'),
(133, 'workshop', 'view example', 'workshop_submissions', 'title', 'mod_workshop'),
(134, 'workshop', 'add reference assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(135, 'workshop', 'update reference assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(136, 'workshop', 'add example assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(137, 'workshop', 'update example assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(138, 'workshop', 'update aggregate grades', 'workshop', 'name', 'mod_workshop'),
(139, 'workshop', 'update clear aggregated grades', 'workshop', 'name', 'mod_workshop'),
(140, 'workshop', 'update clear assessments', 'workshop', 'name', 'mod_workshop');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_queries`
--

CREATE TABLE `[[dbprefix]]log_queries` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `qtype` mediumint(5) unsigned NOT NULL,
  `sqltext` mediumtext NOT NULL,
  `sqlparams` longtext,
  `error` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `info` text,
  `backtrace` text,
  `exectime` decimal(10,5) NOT NULL,
  `timelogged` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Logged database queries.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message`
--

CREATE TABLE `[[dbprefix]]message` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) unsigned NOT NULL DEFAULT '0',
  `useridto` bigint(10) unsigned NOT NULL DEFAULT '0',
  `subject` text,
  `fullmessage` text,
  `fullmessageformat` smallint(4) unsigned DEFAULT '0',
  `fullmessagehtml` mediumtext,
  `smallmessage` text,
  `notification` tinyint(1) unsigned DEFAULT '0',
  `contexturl` text,
  `contexturlname` text,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mess_use_ix` (`useridfrom`),
  KEY `[[dbprefix]]mess_use2_ix` (`useridto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all unread messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_contacts`
--

CREATE TABLE `[[dbprefix]]message_contacts` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `contactid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `blocked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messcont_usecon_uix` (`userid`,`contactid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maintains lists of relationships between users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_processors`
--

CREATE TABLE `[[dbprefix]]message_processors` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(166) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='List of message output plugins' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]message_processors`
--

INSERT INTO `[[dbprefix]]message_processors` VALUES
(1, 'email'),
(2, 'jabber'),
(3, 'popup');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_providers`
--

CREATE TABLE `[[dbprefix]]message_providers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `component` varchar(200) NOT NULL DEFAULT '',
  `capability` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messprov_comnam_uix` (`component`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='This table stores the message providers (modules and core sy' AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]message_providers`
--

INSERT INTO `[[dbprefix]]message_providers` VALUES
(1, 'notices', 'moodle', 'moodle/site:config'),
(2, 'errors', 'moodle', 'moodle/site:config'),
(3, 'instantmessage', 'moodle', NULL),
(4, 'backup', 'moodle', 'moodle/site:config'),
(5, 'courserequested', 'moodle', 'moodle/site:approvecourse'),
(6, 'courserequestapproved', 'moodle', 'moodle/course:request'),
(7, 'courserequestrejected', 'moodle', 'moodle/course:request'),
(8, 'assignment_updates', 'mod_assignment', NULL),
(9, 'submission', 'mod_feedback', NULL),
(10, 'message', 'mod_feedback', NULL),
(11, 'posts', 'mod_forum', NULL),
(12, 'graded_essay', 'mod_lesson', NULL),
(13, 'submission', 'mod_quiz', 'mod/quiz:emailnotifysubmission'),
(14, 'confirmation', 'mod_quiz', 'mod/quiz:emailconfirmsubmission');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_read`
--

CREATE TABLE `[[dbprefix]]message_read` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) unsigned NOT NULL DEFAULT '0',
  `useridto` bigint(10) unsigned NOT NULL DEFAULT '0',
  `subject` text,
  `fullmessage` text,
  `fullmessageformat` smallint(4) unsigned DEFAULT '0',
  `fullmessagehtml` mediumtext,
  `smallmessage` text,
  `notification` tinyint(1) unsigned DEFAULT '0',
  `contexturl` text,
  `contexturlname` text,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timeread` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messread_use_ix` (`useridfrom`),
  KEY `[[dbprefix]]messread_use2_ix` (`useridto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all messages that have been read' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_working`
--

CREATE TABLE `[[dbprefix]]message_working` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `unreadmessageid` bigint(10) unsigned NOT NULL,
  `processorid` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Lists all the messages and processors that need to be proces' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnetservice_enrol_courses`
--

CREATE TABLE `[[dbprefix]]mnetservice_enrol_courses` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) unsigned NOT NULL,
  `remoteid` bigint(10) unsigned NOT NULL,
  `categoryid` bigint(10) unsigned NOT NULL,
  `categoryname` varchar(255) NOT NULL DEFAULT '',
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  `fullname` varchar(254) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `summary` mediumtext NOT NULL,
  `summaryformat` smallint(3) unsigned DEFAULT '0',
  `startdate` bigint(10) unsigned NOT NULL,
  `roleid` bigint(10) unsigned NOT NULL,
  `rolename` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetenrocour_hosrem_uix` (`hostid`,`remoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Caches the information fetched via XML-RPC about courses on ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnetservice_enrol_enrolments`
--

CREATE TABLE `[[dbprefix]]mnetservice_enrol_enrolments` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `remotecourseid` bigint(10) unsigned NOT NULL,
  `rolename` varchar(255) NOT NULL DEFAULT '',
  `enroltime` bigint(10) unsigned NOT NULL DEFAULT '0',
  `enroltype` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetenroenro_use_ix` (`userid`),
  KEY `[[dbprefix]]mnetenroenro_hos_ix` (`hostid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Caches the information about enrolments of our local users i' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_application`
--

CREATE TABLE `[[dbprefix]]mnet_application` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `display_name` varchar(50) NOT NULL DEFAULT '',
  `xmlrpc_server_url` varchar(255) NOT NULL DEFAULT '',
  `sso_land_url` varchar(255) NOT NULL DEFAULT '',
  `sso_jump_url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Information about applications on remote hosts' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]mnet_application`
--

INSERT INTO `[[dbprefix]]mnet_application` VALUES
(1, 'moodle', 'Moodle', '/mnet/xmlrpc/server.php', '/auth/mnet/land.php', '/auth/mnet/jump.php'),
(2, 'mahara', 'Mahara', '/api/xmlrpc/server.php', '/auth/xmlrpc/land.php', '/auth/xmlrpc/jump.php');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_host`
--

CREATE TABLE `[[dbprefix]]mnet_host` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `wwwroot` varchar(255) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `name` varchar(80) NOT NULL DEFAULT '',
  `public_key` mediumtext NOT NULL,
  `public_key_expires` bigint(10) unsigned NOT NULL DEFAULT '0',
  `transport` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `portno` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `last_connect_time` bigint(10) unsigned NOT NULL DEFAULT '0',
  `last_log_id` bigint(10) unsigned NOT NULL DEFAULT '0',
  `force_theme` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `theme` varchar(100) DEFAULT NULL,
  `applicationid` bigint(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnethost_app_ix` (`applicationid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Information about the local and remote hosts for RPC' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]mnet_host`
--

INSERT INTO `[[dbprefix]]mnet_host` VALUES
(1, 0, '[[softurl]]', '[[serverip]]', '', '', 0, 0, 0, 0, 0, 0, NULL, 1),
(2, 0, '', '', 'All Hosts', '', 0, 0, 0, 0, 0, 0, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_host2service`
--

CREATE TABLE `[[dbprefix]]mnet_host2service` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `serviceid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `publish` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subscribe` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnethost_hosser_uix` (`hostid`,`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Information about the services for a given host' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_log`
--

CREATE TABLE `[[dbprefix]]mnet_log` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `remoteid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `time` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `coursename` varchar(40) NOT NULL DEFAULT '',
  `module` varchar(20) NOT NULL DEFAULT '',
  `cmid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `action` varchar(40) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `info` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetlog_hosusecou_ix` (`hostid`,`userid`,`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Store session data from users migrating to other sites' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_remote_rpc`
--

CREATE TABLE `[[dbprefix]]mnet_remote_rpc` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `functionname` varchar(40) NOT NULL DEFAULT '',
  `xmlrpcpath` varchar(80) NOT NULL DEFAULT '',
  `plugintype` varchar(20) NOT NULL DEFAULT '',
  `pluginname` varchar(20) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='This table describes functions that might be called remotely' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]mnet_remote_rpc`
--

INSERT INTO `[[dbprefix]]mnet_remote_rpc` VALUES
(1, 'user_authorise', 'auth/mnet/auth.php/user_authorise', 'auth', 'mnet', 1),
(2, 'keepalive_server', 'auth/mnet/auth.php/keepalive_server', 'auth', 'mnet', 1),
(3, 'kill_children', 'auth/mnet/auth.php/kill_children', 'auth', 'mnet', 1),
(4, 'refresh_log', 'auth/mnet/auth.php/refresh_log', 'auth', 'mnet', 1),
(5, 'fetch_user_image', 'auth/mnet/auth.php/fetch_user_image', 'auth', 'mnet', 1),
(6, 'fetch_theme_info', 'auth/mnet/auth.php/fetch_theme_info', 'auth', 'mnet', 1),
(7, 'update_enrolments', 'auth/mnet/auth.php/update_enrolments', 'auth', 'mnet', 1),
(8, 'keepalive_client', 'auth/mnet/auth.php/keepalive_client', 'auth', 'mnet', 1),
(9, 'kill_child', 'auth/mnet/auth.php/kill_child', 'auth', 'mnet', 1),
(10, 'available_courses', 'enrol/mnet/enrol.php/available_courses', 'enrol', 'mnet', 1),
(11, 'user_enrolments', 'enrol/mnet/enrol.php/user_enrolments', 'enrol', 'mnet', 1),
(12, 'enrol_user', 'enrol/mnet/enrol.php/enrol_user', 'enrol', 'mnet', 1),
(13, 'unenrol_user', 'enrol/mnet/enrol.php/unenrol_user', 'enrol', 'mnet', 1),
(14, 'course_enrolments', 'enrol/mnet/enrol.php/course_enrolments', 'enrol', 'mnet', 1),
(15, 'send_content_intent', 'portfolio/mahara/lib.php/send_content_intent', 'portfolio', 'mahara', 1),
(16, 'send_content_ready', 'portfolio/mahara/lib.php/send_content_ready', 'portfolio', 'mahara', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_remote_service2rpc`
--

CREATE TABLE `[[dbprefix]]mnet_remote_service2rpc` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `serviceid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `rpcid` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetremoserv_rpcser_uix` (`rpcid`,`serviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Group functions or methods under a service' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]mnet_remote_service2rpc`
--

INSERT INTO `[[dbprefix]]mnet_remote_service2rpc` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 2, 8),
(9, 2, 9),
(10, 3, 10),
(11, 3, 11),
(12, 3, 12),
(13, 3, 13),
(14, 3, 14),
(15, 4, 15),
(16, 4, 16);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_rpc`
--

CREATE TABLE `[[dbprefix]]mnet_rpc` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `functionname` varchar(40) NOT NULL DEFAULT '',
  `xmlrpcpath` varchar(80) NOT NULL DEFAULT '',
  `plugintype` varchar(20) NOT NULL DEFAULT '',
  `pluginname` varchar(20) NOT NULL DEFAULT '',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `help` mediumtext NOT NULL,
  `profile` mediumtext NOT NULL,
  `filename` varchar(100) NOT NULL DEFAULT '',
  `classname` varchar(150) DEFAULT NULL,
  `static` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetrpc_enaxml_ix` (`enabled`,`xmlrpcpath`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Functions or methods that we may publish or subscribe to' AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]mnet_rpc`
--

INSERT INTO `[[dbprefix]]mnet_rpc` VALUES
(1, 'user_authorise', 'auth/mnet/auth.php/user_authorise', 'auth', 'mnet', 1, 'Return user data for the provided token, compare with user_agent string.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:5:"token";s:4:"type";s:6:"string";s:11:"description";s:37:"The unique ID provided by remotehost.";}i:1;a:3:{s:4:"name";s:9:"useragent";s:4:"type";s:6:"string";s:11:"description";s:0:"";}}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:44:"$userdata Array of user info for remote host";}}', 'auth.php', 'auth_plugin_mnet', 0),
(2, 'keepalive_server', 'auth/mnet/auth.php/keepalive_server', 'auth', 'mnet', 1, 'Receives an array of usernames from a remote machine and prods their\nsessions to keep them alive', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:5:"array";s:4:"type";s:5:"array";s:11:"description";s:21:"An array of usernames";}}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:28:""All ok" or an error message";}}', 'auth.php', 'auth_plugin_mnet', 0),
(3, 'kill_children', 'auth/mnet/auth.php/kill_children', 'auth', 'mnet', 1, 'The IdP uses this function to kill child sessions on other hosts', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:28:"Username for session to kill";}i:1;a:3:{s:4:"name";s:9:"useragent";s:4:"type";s:6:"string";s:11:"description";s:0:"";}}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:39:"A plaintext report of what has happened";}}', 'auth.php', 'auth_plugin_mnet', 0),
(4, 'refresh_log', 'auth/mnet/auth.php/refresh_log', 'auth', 'mnet', 1, 'Receives an array of log entries from an SP and adds them to the mnet_log\ntable', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:5:"array";s:4:"type";s:5:"array";s:11:"description";s:21:"An array of usernames";}}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:28:""All ok" or an error message";}}', 'auth.php', 'auth_plugin_mnet', 0),
(5, 'fetch_user_image', 'auth/mnet/auth.php/fetch_user_image', 'auth', 'mnet', 1, 'Returns the user''s profile image info\nIf the user exists and has a profile picture, the returned array will contain keys:\n f1          - the content of the default 100x100px image\n f1_mimetype - the mimetype of the f1 file\n f2          - the content of the 35x35px variant of the image\n f2_mimetype - the mimetype of the f2 file\nThe mimetype information was added in Moodle 2.0. In Moodle 1.x, images are always jpegs.', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:3:"int";s:11:"description";s:18:"The id of the user";}}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:84:"false if user not found, empty array if no picture exists, array with data otherwise";}}', 'auth.php', 'auth_plugin_mnet', 0),
(6, 'fetch_theme_info', 'auth/mnet/auth.php/fetch_theme_info', 'auth', 'mnet', 1, 'Returns the theme information and logo url as strings.', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:14:"The theme info";}}', 'auth.php', 'auth_plugin_mnet', 0),
(7, 'update_enrolments', 'auth/mnet/auth.php/update_enrolments', 'auth', 'mnet', 1, 'Invoke this function _on_ the IDP to update it with enrolment info local to\nthe SP right after calling user_authorise()\nNormally called by the SP after calling user_authorise()', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:12:"The username";}i:1;a:3:{s:4:"name";s:7:"courses";s:4:"type";s:5:"array";s:11:"description";s:0:"";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:0:"";}}', 'auth.php', 'auth_plugin_mnet', 0),
(8, 'keepalive_client', 'auth/mnet/auth.php/keepalive_client', 'auth', 'mnet', 1, 'Poll the IdP server to let it know that a user it has authenticated is still\nonline', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:4:"void";s:11:"description";s:0:"";}}', 'auth.php', 'auth_plugin_mnet', 0),
(9, 'kill_child', 'auth/mnet/auth.php/kill_child', 'auth', 'mnet', 1, 'When the IdP requests that child sessions are terminated,\nthis function will be called on each of the child hosts. The machine that\ncalls the function (over xmlrpc) provides us with the mnethostid we need.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:28:"Username for session to kill";}i:1;a:3:{s:4:"name";s:9:"useragent";s:4:"type";s:6:"string";s:11:"description";s:0:"";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:15:"True on success";}}', 'auth.php', 'auth_plugin_mnet', 0),
(10, 'available_courses', 'enrol/mnet/enrol.php/available_courses', 'enrol', 'mnet', 1, 'Returns list of courses that we offer to the caller for remote enrolment of their users\nSince Moodle 2.0, courses are made available for MNet peers by creating an instance\nof enrol_mnet plugin for the course. Hidden courses are not returned. If there are two\ninstances - one specific for the host and one for ''All hosts'', the setting of the specific\none is used. The id of the peer is kept in customint1, no other custom fields are used.', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:0:"";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(11, 'user_enrolments', 'enrol/mnet/enrol.php/user_enrolments', 'enrol', 'mnet', 1, 'This method has never been implemented in Moodle MNet API', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:11:"empty array";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(12, 'enrol_user', 'enrol/mnet/enrol.php/enrol_user', 'enrol', 'mnet', 1, 'Enrol remote user to our course\nIf we do not have local record for the remote user in our database,\nit gets created here.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"userdata";s:4:"type";s:5:"array";s:11:"description";s:14:"user details {";}i:1;a:3:{s:4:"name";s:8:"courseid";s:4:"type";s:3:"int";s:11:"description";s:19:"our local course id";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:69:"true if the enrolment has been successful, throws exception otherwise";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(13, 'unenrol_user', 'enrol/mnet/enrol.php/unenrol_user', 'enrol', 'mnet', 1, 'Unenrol remote user from our course\nOnly users enrolled via enrol_mnet plugin can be unenrolled remotely. If the\nremote user is enrolled into the local course via some other enrol plugin\n(enrol_manual for example), the remote host can''t touch such enrolment. Please\ndo not report this behaviour as bug, it is a feature ;-)', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:18:"of the remote user";}i:1;a:3:{s:4:"name";s:8:"courseid";s:4:"type";s:3:"int";s:11:"description";s:0:"";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:71:"true if the unenrolment has been successful, throws exception otherwise";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(14, 'course_enrolments', 'enrol/mnet/enrol.php/course_enrolments', 'enrol', 'mnet', 1, 'Returns a list of users from the client server who are enrolled in our course\nSuitable instance of enrol_mnet must be created in the course. This method will not\nreturn any information about the enrolments in courses that are not available for\nremote enrolment, even if their users are enrolled into them via other plugin\n(note the difference from {@link self::user_enrolments()}).\nThis method will return enrolment information for users from hosts regardless\nthe enrolment plugin. It does not matter if the user was enrolled remotely by\ntheir admin or locally. Once the course is available for remote enrolments, we\nwill tell them everything about their users.\nIn Moodle 1.x the returned array used to be indexed by username. The side effect\nof MDL-19219 fix is that we do not need to use such index and therefore we can\nreturn all enrolment records. MNet clients 1.x will only use the last record for\nthe student, if she is enrolled via multiple plugins.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"courseid";s:4:"type";s:3:"int";s:11:"description";s:16:"ID of our course";}i:1;a:3:{s:4:"name";s:5:"roles";s:4:"type";s:5:"array";s:11:"description";s:0:"";}}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:0:"";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(15, 'fetch_file', 'portfolio/mahara/lib.php/fetch_file', 'portfolio', 'mahara', 1, 'xmlrpc (mnet) function to get the file.\nreads in the file and returns it base_64 encoded\nso that it can be enrypted by mnet.', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:5:"token";s:4:"type";s:6:"string";s:11:"description";s:56:"the token recieved previously during send_content_intent";}}s:6:"return";a:2:{s:4:"type";s:4:"void";s:11:"description";s:0:"";}}', 'lib.php', 'portfolio_plugin_mahara', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_service`
--

CREATE TABLE `[[dbprefix]]mnet_service` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` varchar(40) NOT NULL DEFAULT '',
  `apiversion` varchar(10) NOT NULL DEFAULT '',
  `offer` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='A service is a group of functions' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]mnet_service`
--

INSERT INTO `[[dbprefix]]mnet_service` VALUES
(1, 'sso_idp', '', '1', 1),
(2, 'sso_sp', '', '1', 1),
(3, 'mnet_enrol', '', '1', 1),
(4, 'pf', '', '1', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_service2rpc`
--

CREATE TABLE `[[dbprefix]]mnet_service2rpc` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `serviceid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `rpcid` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetserv_rpcser_uix` (`rpcid`,`serviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Group functions or methods under a service' AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]mnet_service2rpc`
--

INSERT INTO `[[dbprefix]]mnet_service2rpc` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 2, 8),
(9, 2, 9),
(10, 3, 10),
(11, 3, 11),
(12, 3, 12),
(13, 3, 13),
(14, 3, 14),
(15, 4, 15);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_session`
--

CREATE TABLE `[[dbprefix]]mnet_session` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `username` varchar(100) NOT NULL DEFAULT '',
  `token` varchar(40) NOT NULL DEFAULT '',
  `mnethostid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `useragent` varchar(40) NOT NULL DEFAULT '',
  `confirm_timeout` bigint(10) unsigned NOT NULL DEFAULT '0',
  `session_id` varchar(40) NOT NULL DEFAULT '',
  `expires` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetsess_tok_uix` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Store session data from users migrating to other sites' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_sso_access_control`
--

CREATE TABLE `[[dbprefix]]mnet_sso_access_control` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL DEFAULT '',
  `mnet_host_id` bigint(10) unsigned NOT NULL DEFAULT '0',
  `accessctrl` varchar(20) NOT NULL DEFAULT 'allow',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetssoaccecont_mneu_uix` (`mnet_host_id`,`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Users by host permitted (or not) to login from a remote prov' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `version` bigint(10) NOT NULL DEFAULT '0',
  `cron` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lastcron` bigint(10) unsigned NOT NULL DEFAULT '0',
  `search` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]modu_nam_ix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='modules available in the site' AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
(1, 'assignment', 2010102600, 60, 0, '', 1),
(2, 'chat', 2010080302, 300, 0, '', 1),
(3, 'choice', 2010101301, 0, 0, '', 1),
(4, 'data', 2010100101, 60, 0, '', 1),
(5, 'feedback', 2011051600, 0, 0, '', 0),
(6, 'folder', 2010101400, 0, 0, '', 1),
(7, 'forum', 2010111500, 60, 0, '', 1),
(8, 'glossary', 2010111501, 0, 0, '', 1),
(9, 'imscp', 2010101400, 0, 0, '', 1),
(10, 'label', 2010080300, 0, 0, '', 1),
(11, 'lesson', 2010122200, 0, 0, '', 1),
(12, 'page', 2010101400, 0, 0, '', 1),
(13, 'quiz', 2010122304, 0, 0, '', 1),
(14, 'resource', 2011022700, 0, 0, '', 1),
(15, 'scorm', 2011021403, 300, 0, '', 1),
(16, 'survey', 2010080300, 0, 0, '', 1),
(17, 'url', 2010101401, 0, 0, '', 1),
(18, 'wiki', 2011011001, 0, 0, '', 1),
(19, 'workshop', 2011030401, 0, 0, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]my_pages`
--

CREATE TABLE `[[dbprefix]]my_pages` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned DEFAULT '0',
  `name` varchar(200) NOT NULL DEFAULT '',
  `private` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sortorder` mediumint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mypage_usepri_ix` (`userid`,`private`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Extra user pages for the My Moodle system' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]my_pages`
--

INSERT INTO `[[dbprefix]]my_pages` VALUES
(1, NULL, '__default', 0, 0),
(2, NULL, '__default', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page`
--

CREATE TABLE `[[dbprefix]]page` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `content` mediumtext,
  `contentformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) unsigned NOT NULL DEFAULT '0',
  `legacyfileslast` bigint(10) unsigned DEFAULT NULL,
  `display` smallint(4) unsigned NOT NULL DEFAULT '0',
  `displayoptions` text,
  `revision` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]page_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each record is one page and its config data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance`
--

CREATE TABLE `[[dbprefix]]portfolio_instance` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `plugin` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='base table (not including config data) for instances of port' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance_config`
--

CREATE TABLE `[[dbprefix]]portfolio_instance_config` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `instance` bigint(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portinstconf_nam_ix` (`name`),
  KEY `[[dbprefix]]portinstconf_ins_ix` (`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='config for portfolio plugin instances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance_user`
--

CREATE TABLE `[[dbprefix]]portfolio_instance_user` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `instance` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portinstuser_ins_ix` (`instance`),
  KEY `[[dbprefix]]portinstuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='user data for portfolio instances.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_log`
--

CREATE TABLE `[[dbprefix]]portfolio_log` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL,
  `time` bigint(10) unsigned NOT NULL,
  `portfolio` bigint(10) unsigned NOT NULL,
  `caller_class` varchar(150) NOT NULL DEFAULT '',
  `caller_file` varchar(255) NOT NULL DEFAULT '',
  `caller_sha1` varchar(255) NOT NULL DEFAULT '',
  `tempdataid` bigint(10) NOT NULL DEFAULT '0',
  `returnurl` varchar(255) NOT NULL DEFAULT '',
  `continueurl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portlog_use_ix` (`userid`),
  KEY `[[dbprefix]]portlog_por_ix` (`portfolio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='log of portfolio transfers (used to later check for duplicat' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_mahara_queue`
--

CREATE TABLE `[[dbprefix]]portfolio_mahara_queue` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `transferid` bigint(10) unsigned NOT NULL,
  `token` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portmahaqueu_tok_ix` (`token`),
  KEY `[[dbprefix]]portmahaqueu_tra_ix` (`transferid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='maps mahara tokens to transfer ids' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_tempdata`
--

CREATE TABLE `[[dbprefix]]portfolio_tempdata` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `data` longtext,
  `expirytime` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `instance` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]porttemp_use_ix` (`userid`),
  KEY `[[dbprefix]]porttemp_ins_ix` (`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='stores temporary data for portfolio exports. the id of this ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post`
--

CREATE TABLE `[[dbprefix]]post` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(20) NOT NULL DEFAULT '',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `groupid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `moduleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `coursemoduleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(128) NOT NULL DEFAULT '',
  `summary` longtext,
  `content` longtext,
  `uniquehash` varchar(128) NOT NULL DEFAULT '',
  `rating` bigint(10) unsigned NOT NULL DEFAULT '0',
  `format` bigint(10) unsigned NOT NULL DEFAULT '0',
  `summaryformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `attachment` varchar(100) DEFAULT NULL,
  `publishstate` varchar(20) NOT NULL DEFAULT 'draft',
  `lastmodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `created` bigint(10) unsigned NOT NULL DEFAULT '0',
  `usermodified` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]post_iduse_uix` (`id`,`userid`),
  KEY `[[dbprefix]]post_las_ix` (`lastmodified`),
  KEY `[[dbprefix]]post_mod_ix` (`module`),
  KEY `[[dbprefix]]post_sub_ix` (`subject`),
  KEY `[[dbprefix]]post_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic post table to hold data blog entries etc in differen' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]profiling`
--

CREATE TABLE `[[dbprefix]]profiling` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `runid` varchar(32) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `totalexecutiontime` bigint(10) unsigned NOT NULL,
  `totalcputime` bigint(10) unsigned NOT NULL,
  `totalcalls` bigint(10) unsigned NOT NULL,
  `totalmemory` bigint(10) unsigned NOT NULL,
  `runreference` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `runcomment` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]prof_run_uix` (`runid`),
  KEY `[[dbprefix]]prof_urlrun_ix` (`url`,`runreference`),
  KEY `[[dbprefix]]prof_timrun_ix` (`timecreated`,`runreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the results of all the profiling runs' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question`
--

CREATE TABLE `[[dbprefix]]question` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `parent` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `questiontext` text NOT NULL,
  `questiontextformat` tinyint(2) NOT NULL DEFAULT '0',
  `generalfeedback` text NOT NULL,
  `generalfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `defaultgrade` decimal(12,7) unsigned NOT NULL DEFAULT '1.0000000',
  `penalty` decimal(12,7) NOT NULL DEFAULT '0.1000000',
  `qtype` varchar(20) NOT NULL DEFAULT '',
  `length` bigint(10) unsigned NOT NULL DEFAULT '1',
  `stamp` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `createdby` bigint(10) unsigned DEFAULT NULL,
  `modifiedby` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ques_cat_ix` (`category`),
  KEY `[[dbprefix]]ques_par_ix` (`parent`),
  KEY `[[dbprefix]]ques_cre_ix` (`createdby`),
  KEY `[[dbprefix]]ques_mod_ix` (`modifiedby`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The questions themselves' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_answers`
--

CREATE TABLE `[[dbprefix]]question_answers` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `answer` text NOT NULL,
  `answerformat` tinyint(2) NOT NULL DEFAULT '0',
  `fraction` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  `feedback` text NOT NULL,
  `feedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesansw_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Answers, with a fractional grade (0-1) and feedback' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempts`
--

CREATE TABLE `[[dbprefix]]question_attempts` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `modulename` varchar(20) NOT NULL DEFAULT 'quiz',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Student attempts. This table gets extended by the modules' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_calculated`
--

CREATE TABLE `[[dbprefix]]question_calculated` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `answer` bigint(10) unsigned NOT NULL DEFAULT '0',
  `tolerance` varchar(20) NOT NULL DEFAULT '0.0',
  `tolerancetype` bigint(10) NOT NULL DEFAULT '1',
  `correctanswerlength` bigint(10) NOT NULL DEFAULT '2',
  `correctanswerformat` bigint(10) NOT NULL DEFAULT '2',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quescalc_ans_ix` (`answer`),
  KEY `[[dbprefix]]quescalc_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for questions of type calculated' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_calculated_options`
--

CREATE TABLE `[[dbprefix]]question_calculated_options` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `synchronize` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `single` smallint(4) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '0',
  `correctfeedback` text,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` text,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` text,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `answernumbering` varchar(10) NOT NULL DEFAULT 'abc',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quescalcopti_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for questions of type calculated' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_categories`
--

CREATE TABLE `[[dbprefix]]question_categories` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contextid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `info` text NOT NULL,
  `infoformat` tinyint(2) NOT NULL DEFAULT '0',
  `stamp` varchar(255) NOT NULL DEFAULT '',
  `parent` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '999',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quescate_con_ix` (`contextid`),
  KEY `[[dbprefix]]quescate_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Categories are for grouping questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_datasets`
--

CREATE TABLE `[[dbprefix]]question_datasets` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `datasetdefinition` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdata_quedat_ix` (`question`,`datasetdefinition`),
  KEY `[[dbprefix]]quesdata_que_ix` (`question`),
  KEY `[[dbprefix]]quesdata_dat_ix` (`datasetdefinition`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Many-many relation between questions and dataset definitions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_dataset_definitions`
--

CREATE TABLE `[[dbprefix]]question_dataset_definitions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `category` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` bigint(10) NOT NULL DEFAULT '0',
  `options` varchar(255) NOT NULL DEFAULT '',
  `itemcount` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdatadefi_cat_ix` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Organises and stores properties for dataset items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_dataset_items`
--

CREATE TABLE `[[dbprefix]]question_dataset_items` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `definition` bigint(10) unsigned NOT NULL DEFAULT '0',
  `itemnumber` bigint(10) unsigned NOT NULL DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdataitem_def_ix` (`definition`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Individual dataset items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_match`
--

CREATE TABLE `[[dbprefix]]question_match` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `subquestions` varchar(255) NOT NULL DEFAULT '',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesmatc_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines fixed matching questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_match_sub`
--

CREATE TABLE `[[dbprefix]]question_match_sub` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` bigint(10) unsigned NOT NULL DEFAULT '0',
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `questiontext` text NOT NULL,
  `questiontextformat` tinyint(2) NOT NULL DEFAULT '0',
  `answertext` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesmatcsub_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines the subquestions that make up a matching question' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_multianswer`
--

CREATE TABLE `[[dbprefix]]question_multianswer` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sequence` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesmult_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for multianswer questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_multichoice`
--

CREATE TABLE `[[dbprefix]]question_multichoice` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `layout` smallint(4) NOT NULL DEFAULT '0',
  `answers` varchar(255) NOT NULL DEFAULT '',
  `single` smallint(4) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` text NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` text NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` text NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `answernumbering` varchar(10) NOT NULL DEFAULT 'abc',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesmult_que2_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for multiple choice questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical`
--

CREATE TABLE `[[dbprefix]]question_numerical` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `answer` bigint(10) unsigned NOT NULL DEFAULT '0',
  `tolerance` varchar(255) NOT NULL DEFAULT '0.0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesnume_ans_ix` (`answer`),
  KEY `[[dbprefix]]quesnume_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for numerical questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical_options`
--

CREATE TABLE `[[dbprefix]]question_numerical_options` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `instructions` text,
  `instructionsformat` tinyint(2) NOT NULL DEFAULT '0',
  `showunits` smallint(4) unsigned NOT NULL DEFAULT '0',
  `unitsleft` smallint(4) NOT NULL DEFAULT '0',
  `unitgradingtype` smallint(4) unsigned NOT NULL DEFAULT '0',
  `unitpenalty` decimal(12,7) unsigned NOT NULL DEFAULT '0.1000000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesnumeopti_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for questions of type numerical This table is also u' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical_units`
--

CREATE TABLE `[[dbprefix]]question_numerical_units` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `multiplier` decimal(40,20) NOT NULL DEFAULT '1.00000000000000000000',
  `unit` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesnumeunit_queuni_uix` (`question`,`unit`),
  KEY `[[dbprefix]]quesnumeunit_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Optional unit options for numerical questions. This table is' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_randomsamatch`
--

CREATE TABLE `[[dbprefix]]question_randomsamatch` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `choose` bigint(10) unsigned NOT NULL DEFAULT '4',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesrand_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Info about a random short-answer matching question' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_sessions`
--

CREATE TABLE `[[dbprefix]]question_sessions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `attemptid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `questionid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `newest` bigint(10) unsigned NOT NULL DEFAULT '0',
  `newgraded` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sumpenalty` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  `manualcomment` text NOT NULL,
  `manualcommentformat` tinyint(2) NOT NULL DEFAULT '0',
  `flagged` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quessess_attque_uix` (`attemptid`,`questionid`),
  KEY `[[dbprefix]]quessess_att_ix` (`attemptid`),
  KEY `[[dbprefix]]quessess_que_ix` (`questionid`),
  KEY `[[dbprefix]]quessess_new_ix` (`newest`),
  KEY `[[dbprefix]]quessess_new2_ix` (`newgraded`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Gives ids of the newest open and newest graded states' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_shortanswer`
--

CREATE TABLE `[[dbprefix]]question_shortanswer` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `answers` varchar(255) NOT NULL DEFAULT '',
  `usecase` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesshor_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for short answer questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_states`
--

CREATE TABLE `[[dbprefix]]question_states` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `attempt` bigint(10) unsigned NOT NULL DEFAULT '0',
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `seq_number` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `answer` text NOT NULL,
  `timestamp` bigint(10) unsigned NOT NULL DEFAULT '0',
  `event` smallint(4) unsigned NOT NULL DEFAULT '0',
  `grade` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  `raw_grade` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  `penalty` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesstat_att_ix` (`attempt`),
  KEY `[[dbprefix]]quesstat_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores user responses to an attempt, and percentage grades' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_truefalse`
--

CREATE TABLE `[[dbprefix]]question_truefalse` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `trueanswer` bigint(10) unsigned NOT NULL DEFAULT '0',
  `falseanswer` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]questrue_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for True-False questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz`
--

CREATE TABLE `[[dbprefix]]quiz` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `timeopen` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeclose` bigint(10) unsigned NOT NULL DEFAULT '0',
  `optionflags` bigint(10) unsigned NOT NULL DEFAULT '0',
  `penaltyscheme` smallint(4) unsigned NOT NULL DEFAULT '0',
  `attempts` mediumint(6) NOT NULL DEFAULT '0',
  `attemptonlast` smallint(4) NOT NULL DEFAULT '0',
  `grademethod` smallint(4) NOT NULL DEFAULT '1',
  `decimalpoints` smallint(4) NOT NULL DEFAULT '2',
  `questiondecimalpoints` smallint(4) NOT NULL DEFAULT '-2',
  `review` bigint(10) unsigned NOT NULL DEFAULT '0',
  `questionsperpage` bigint(10) NOT NULL DEFAULT '0',
  `shufflequestions` smallint(4) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '0',
  `questions` text NOT NULL,
  `sumgrades` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `grade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timelimit` bigint(10) unsigned NOT NULL DEFAULT '0',
  `password` varchar(255) NOT NULL DEFAULT '',
  `subnet` varchar(255) NOT NULL DEFAULT '',
  `popup` smallint(4) NOT NULL DEFAULT '0',
  `delay1` bigint(10) NOT NULL DEFAULT '0',
  `delay2` bigint(10) NOT NULL DEFAULT '0',
  `showuserpicture` smallint(4) NOT NULL DEFAULT '0',
  `showblocks` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quiz_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Main information about each quiz' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_attempts`
--

CREATE TABLE `[[dbprefix]]quiz_attempts` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniqueid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `quiz` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `attempt` mediumint(6) NOT NULL DEFAULT '0',
  `sumgrades` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `timestart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timefinish` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `layout` text NOT NULL,
  `preview` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizatte_uni_uix` (`uniqueid`),
  KEY `[[dbprefix]]quizatte_use_ix` (`userid`),
  KEY `[[dbprefix]]quizatte_qui_ix` (`quiz`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores various attempts on a quiz' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_feedback`
--

CREATE TABLE `[[dbprefix]]quiz_feedback` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `quizid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `feedbacktext` text NOT NULL,
  `feedbacktextformat` tinyint(2) NOT NULL DEFAULT '0',
  `mingrade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `maxgrade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizfeed_qui_ix` (`quizid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Feedback given to students based on which grade band their o' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_grades`
--

CREATE TABLE `[[dbprefix]]quiz_grades` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `quiz` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `grade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]quizgrad_qui_ix` (`quiz`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The overall grade for each user on the quiz, based on their ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_overrides`
--

CREATE TABLE `[[dbprefix]]quiz_overrides` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `quiz` bigint(10) unsigned NOT NULL DEFAULT '0',
  `groupid` bigint(10) unsigned DEFAULT NULL,
  `userid` bigint(10) unsigned DEFAULT NULL,
  `timeopen` bigint(10) unsigned DEFAULT NULL,
  `timeclose` bigint(10) unsigned DEFAULT NULL,
  `timelimit` bigint(10) unsigned DEFAULT NULL,
  `attempts` mediumint(6) unsigned DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizover_qui_ix` (`quiz`),
  KEY `[[dbprefix]]quizover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]quizover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The overrides to quiz settings on a per-user and per-group b' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_question_instances`
--

CREATE TABLE `[[dbprefix]]quiz_question_instances` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `quiz` bigint(10) unsigned NOT NULL DEFAULT '0',
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `grade` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizquesinst_qui_ix` (`quiz`),
  KEY `[[dbprefix]]quizquesinst_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the maximum possible grade (weight) for each question' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_question_regrade`
--

CREATE TABLE `[[dbprefix]]quiz_question_regrade` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) unsigned NOT NULL,
  `attemptid` bigint(10) unsigned NOT NULL,
  `newgrade` decimal(12,7) NOT NULL,
  `oldgrade` decimal(12,7) NOT NULL,
  `regraded` smallint(4) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='This table records which question attempts need regrading an' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_question_response_stats`
--

CREATE TABLE `[[dbprefix]]quiz_question_response_stats` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `quizstatisticsid` bigint(10) unsigned NOT NULL,
  `questionid` bigint(10) unsigned NOT NULL,
  `subqid` bigint(10) unsigned NOT NULL,
  `aid` bigint(10) unsigned NOT NULL,
  `response` longtext,
  `rcount` bigint(10) unsigned DEFAULT NULL,
  `credit` decimal(15,5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Quiz question responses.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_question_statistics`
--

CREATE TABLE `[[dbprefix]]quiz_question_statistics` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `quizstatisticsid` bigint(10) unsigned NOT NULL,
  `questionid` bigint(10) unsigned NOT NULL,
  `subquestion` smallint(4) unsigned NOT NULL,
  `s` bigint(10) unsigned NOT NULL DEFAULT '0',
  `effectiveweight` decimal(15,5) DEFAULT NULL,
  `negcovar` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `discriminationindex` decimal(15,5) DEFAULT NULL,
  `discriminativeefficiency` decimal(15,5) DEFAULT NULL,
  `sd` decimal(15,10) DEFAULT NULL,
  `facility` decimal(15,10) DEFAULT NULL,
  `subquestions` mediumtext,
  `maxgrade` decimal(12,7) DEFAULT NULL,
  `positions` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_report`
--

CREATE TABLE `[[dbprefix]]quiz_report` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `displayorder` bigint(10) unsigned NOT NULL,
  `lastcron` bigint(10) unsigned NOT NULL DEFAULT '0',
  `cron` bigint(10) unsigned NOT NULL DEFAULT '0',
  `capability` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Lists all the installed quiz reports and their display order' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]quiz_report`
--

INSERT INTO `[[dbprefix]]quiz_report` VALUES
(1, 'overview', 10000, 0, 0, NULL),
(2, 'responses', 9000, 0, 0, NULL),
(3, 'grading', 6000, 0, 0, NULL),
(4, 'statistics', 8000, 0, 18000, 'quizreport/statistics:view');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_statistics`
--

CREATE TABLE `[[dbprefix]]quiz_statistics` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `quizid` bigint(10) unsigned NOT NULL,
  `groupid` bigint(10) unsigned NOT NULL,
  `allattempts` smallint(4) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  `firstattemptscount` bigint(10) unsigned NOT NULL,
  `allattemptscount` bigint(10) unsigned NOT NULL,
  `firstattemptsavg` decimal(15,5) DEFAULT NULL,
  `allattemptsavg` decimal(15,5) DEFAULT NULL,
  `median` decimal(15,5) DEFAULT NULL,
  `standarddeviation` decimal(15,5) DEFAULT NULL,
  `skewness` decimal(15,10) DEFAULT NULL,
  `kurtosis` decimal(15,5) DEFAULT NULL,
  `cic` decimal(15,10) DEFAULT NULL,
  `errorratio` decimal(15,10) DEFAULT NULL,
  `standarderror` decimal(15,10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='table to cache results from analysis done in statistics repo' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]rating`
--

CREATE TABLE `[[dbprefix]]rating` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) unsigned NOT NULL,
  `itemid` bigint(10) unsigned NOT NULL,
  `scaleid` bigint(10) NOT NULL,
  `rating` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `timecreated` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]rati_ite_ix` (`itemid`),
  KEY `[[dbprefix]]rati_con_ix` (`contextid`),
  KEY `[[dbprefix]]rati_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='moodle ratings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]registration_hubs`
--

CREATE TABLE `[[dbprefix]]registration_hubs` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(255) NOT NULL DEFAULT '',
  `hubname` varchar(255) NOT NULL DEFAULT '',
  `huburl` varchar(255) NOT NULL DEFAULT '',
  `confirmed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `secret` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='hub where the site is registered on with their associated to' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]report_customlang`
--

CREATE TABLE `[[dbprefix]]report_customlang` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `lang` varchar(20) NOT NULL DEFAULT '',
  `componentid` bigint(10) unsigned NOT NULL,
  `stringid` varchar(255) NOT NULL DEFAULT '',
  `original` longtext NOT NULL,
  `master` longtext,
  `local` longtext,
  `timemodified` bigint(10) unsigned NOT NULL,
  `timecustomized` bigint(10) unsigned DEFAULT NULL,
  `outdated` smallint(3) unsigned DEFAULT '0',
  `modified` smallint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]repocust_lancomstr_uix` (`lang`,`componentid`,`stringid`),
  KEY `[[dbprefix]]repocust_com_ix` (`componentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains the working checkout of all strings and their custo' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]report_customlang_components`
--

CREATE TABLE `[[dbprefix]]report_customlang_components` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains the list of all installed plugins that provide thei' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository`
--

CREATE TABLE `[[dbprefix]]repository` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) unsigned DEFAULT '1',
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='This table contains one entry for every configured external ' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]repository`
--

INSERT INTO `[[dbprefix]]repository` VALUES
(1, 'local', 1, 1),
(2, 'recent', 1, 2),
(3, 'upload', 1, 3),
(4, 'user', 1, 4);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_instances`
--

CREATE TABLE `[[dbprefix]]repository_instances` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `typeid` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `contextid` bigint(10) unsigned NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) unsigned DEFAULT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  `readonly` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='This table contains one entry for every configured external ' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]repository_instances`
--

INSERT INTO `[[dbprefix]]repository_instances` VALUES
(1, '', 1, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(2, '', 2, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(3, '', 3, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(4, '', 4, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_instance_config`
--

CREATE TABLE `[[dbprefix]]repository_instance_config` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The config for intances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource`
--

CREATE TABLE `[[dbprefix]]resource` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `tobemigrated` smallint(4) unsigned NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) unsigned NOT NULL DEFAULT '0',
  `legacyfileslast` bigint(10) unsigned DEFAULT NULL,
  `display` smallint(4) unsigned NOT NULL DEFAULT '0',
  `displayoptions` text,
  `filterfiles` smallint(4) unsigned NOT NULL DEFAULT '0',
  `revision` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]reso_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each record is one resource and its config data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource_old`
--

CREATE TABLE `[[dbprefix]]resource_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `reference` varchar(255) NOT NULL DEFAULT '',
  `intro` text,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `alltext` mediumtext NOT NULL,
  `popup` text NOT NULL,
  `options` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `oldid` bigint(10) unsigned NOT NULL,
  `cmid` bigint(10) unsigned DEFAULT NULL,
  `newmodule` varchar(50) DEFAULT NULL,
  `newid` bigint(10) unsigned DEFAULT NULL,
  `migrated` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]resoold_old_uix` (`oldid`),
  KEY `[[dbprefix]]resoold_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='backup of all old resource instances from 1.9' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role`
--

CREATE TABLE `[[dbprefix]]role` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  `archetype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]role_sor_uix` (`sortorder`),
  UNIQUE KEY `[[dbprefix]]role_nam_uix` (`name`),
  UNIQUE KEY `[[dbprefix]]role_sho_uix` (`shortname`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='moodle roles' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]role`
--

INSERT INTO `[[dbprefix]]role` VALUES
(1, 'Manager', 'manager', 'Managers can access course and modify them, they usually do not participate in courses.', 1, 'manager'),
(2, 'Course creator', 'coursecreator', 'Course creators can create new courses.', 2, 'coursecreator'),
(3, 'Teacher', 'editingteacher', 'Teachers can do anything within a course, including changing the activities and grading students.', 3, 'editingteacher'),
(4, 'Non-editing teacher', 'teacher', 'Non-editing teachers can teach in courses and grade students, but may not alter activities.', 4, 'teacher'),
(5, 'Student', 'student', 'Students generally have fewer privileges within a course.', 5, 'student'),
(6, 'Guest', 'guest', 'Guests have minimal privileges and usually can not enter text anywhere.', 6, 'guest'),
(7, 'Authenticated user', 'user', 'All logged in users.', 7, 'user'),
(8, 'Authenticated user on frontpage', 'frontpage', 'All logged in users in the frontpage course.', 8, 'frontpage');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_assign`
--

CREATE TABLE `[[dbprefix]]role_allow_assign` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `allowassign` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloassi_rolall_uix` (`roleid`,`allowassign`),
  KEY `[[dbprefix]]rolealloassi_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloassi_all_ix` (`allowassign`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='this defines what role can assign what role' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_assign`
--

INSERT INTO `[[dbprefix]]role_allow_assign` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 3, 4),
(7, 3, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_override`
--

CREATE TABLE `[[dbprefix]]role_allow_override` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `allowoverride` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloover_rolall_uix` (`roleid`,`allowoverride`),
  KEY `[[dbprefix]]rolealloover_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloover_all_ix` (`allowoverride`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='this defines what role can override what role' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_override`
--

INSERT INTO `[[dbprefix]]role_allow_override` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 1, 8),
(9, 3, 4),
(10, 3, 5),
(11, 3, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_switch`
--

CREATE TABLE `[[dbprefix]]role_allow_switch` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) unsigned NOT NULL,
  `allowswitch` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloswit_rolall_uix` (`roleid`,`allowswitch`),
  KEY `[[dbprefix]]rolealloswit_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloswit_all_ix` (`allowswitch`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='This table stores which which other roles a user is allowed ' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_switch`
--

INSERT INTO `[[dbprefix]]role_allow_switch` VALUES
(1, 1, 3),
(2, 1, 4),
(3, 1, 5),
(4, 1, 6),
(5, 3, 4),
(6, 3, 5),
(7, 3, 6),
(8, 4, 5),
(9, 4, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_assignments`
--

CREATE TABLE `[[dbprefix]]role_assignments` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `contextid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `modifierid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]roleassi_sor_ix` (`sortorder`),
  KEY `[[dbprefix]]roleassi_rol_ix` (`roleid`),
  KEY `[[dbprefix]]roleassi_con_ix` (`contextid`),
  KEY `[[dbprefix]]roleassi_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='assigning roles in different context' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_capabilities`
--

CREATE TABLE `[[dbprefix]]role_capabilities` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `capability` varchar(255) NOT NULL DEFAULT '',
  `permission` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `modifierid` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolecapa_rolconcap_uix` (`roleid`,`contextid`,`capability`),
  KEY `[[dbprefix]]rolecapa_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolecapa_con_ix` (`contextid`),
  KEY `[[dbprefix]]rolecapa_mod_ix` (`modifierid`),
  KEY `[[dbprefix]]rolecapa_cap_ix` (`capability`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='permission has to be signed, overriding a capability for a p' AUTO_INCREMENT=869 ;

--
-- Dumping data for table `[[dbprefix]]role_capabilities`
--

INSERT INTO `[[dbprefix]]role_capabilities` VALUES
(1, 1, 1, 'moodle/site:readallmessages', 1, [[timestamp]], 0),
(2, 1, 3, 'moodle/site:readallmessages', 1, [[timestamp]], 0),
(3, 1, 1, 'moodle/site:sendmessage', 1, [[timestamp]], 0),
(4, 1, 7, 'moodle/site:sendmessage', 1, [[timestamp]], 0),
(5, 1, 1, 'moodle/site:approvecourse', 1, [[timestamp]], 0),
(6, 1, 3, 'moodle/backup:backupcourse', 1, [[timestamp]], 0),
(7, 1, 1, 'moodle/backup:backupcourse', 1, [[timestamp]], 0),
(8, 1, 3, 'moodle/backup:backupsection', 1, [[timestamp]], 0),
(9, 1, 1, 'moodle/backup:backupsection', 1, [[timestamp]], 0),
(10, 1, 3, 'moodle/backup:backupactivity', 1, [[timestamp]], 0),
(11, 1, 1, 'moodle/backup:backupactivity', 1, [[timestamp]], 0),
(12, 1, 3, 'moodle/backup:backuptargethub', 1, [[timestamp]], 0),
(13, 1, 1, 'moodle/backup:backuptargethub', 1, [[timestamp]], 0),
(14, 1, 3, 'moodle/backup:backuptargetimport', 1, [[timestamp]], 0),
(15, 1, 1, 'moodle/backup:backuptargetimport', 1, [[timestamp]], 0),
(16, 1, 3, 'moodle/backup:downloadfile', 1, [[timestamp]], 0),
(17, 1, 1, 'moodle/backup:downloadfile', 1, [[timestamp]], 0),
(18, 1, 3, 'moodle/backup:configure', 1, [[timestamp]], 0),
(19, 1, 1, 'moodle/backup:configure', 1, [[timestamp]], 0),
(20, 1, 1, 'moodle/backup:userinfo', 1, [[timestamp]], 0),
(21, 1, 1, 'moodle/backup:anonymise', 1, [[timestamp]], 0),
(22, 1, 3, 'moodle/restore:restorecourse', 1, [[timestamp]], 0),
(23, 1, 1, 'moodle/restore:restorecourse', 1, [[timestamp]], 0),
(24, 1, 3, 'moodle/restore:restoresection', 1, [[timestamp]], 0),
(25, 1, 1, 'moodle/restore:restoresection', 1, [[timestamp]], 0),
(26, 1, 3, 'moodle/restore:restoreactivity', 1, [[timestamp]], 0),
(27, 1, 1, 'moodle/restore:restoreactivity', 1, [[timestamp]], 0),
(28, 1, 3, 'moodle/restore:restoretargethub', 1, [[timestamp]], 0),
(29, 1, 1, 'moodle/restore:restoretargethub', 1, [[timestamp]], 0),
(30, 1, 3, 'moodle/restore:restoretargetimport', 1, [[timestamp]], 0),
(31, 1, 1, 'moodle/restore:restoretargetimport', 1, [[timestamp]], 0),
(32, 1, 3, 'moodle/restore:uploadfile', 1, [[timestamp]], 0),
(33, 1, 1, 'moodle/restore:uploadfile', 1, [[timestamp]], 0),
(34, 1, 3, 'moodle/restore:configure', 1, [[timestamp]], 0),
(35, 1, 1, 'moodle/restore:configure', 1, [[timestamp]], 0),
(36, 1, 2, 'moodle/restore:rolldates', 1, [[timestamp]], 0),
(37, 1, 1, 'moodle/restore:rolldates', 1, [[timestamp]], 0),
(38, 1, 1, 'moodle/restore:userinfo', 1, [[timestamp]], 0),
(39, 1, 1, 'moodle/restore:createuser', 1, [[timestamp]], 0),
(40, 1, 3, 'moodle/site:manageblocks', 1, [[timestamp]], 0),
(41, 1, 1, 'moodle/site:manageblocks', 1, [[timestamp]], 0),
(42, 1, 4, 'moodle/site:accessallgroups', 1, [[timestamp]], 0),
(43, 1, 3, 'moodle/site:accessallgroups', 1, [[timestamp]], 0),
(44, 1, 1, 'moodle/site:accessallgroups', 1, [[timestamp]], 0),
(45, 1, 4, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(46, 1, 3, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(47, 1, 1, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(48, 1, 4, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(49, 1, 3, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(50, 1, 1, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(51, 1, 3, 'moodle/site:trustcontent', 1, [[timestamp]], 0),
(52, 1, 1, 'moodle/site:trustcontent', 1, [[timestamp]], 0),
(53, 1, 1, 'moodle/site:uploadusers', 1, [[timestamp]], 0),
(54, 1, 3, 'moodle/filter:manage', 1, [[timestamp]], 0),
(55, 1, 1, 'moodle/filter:manage', 1, [[timestamp]], 0),
(56, 1, 1, 'moodle/user:create', 1, [[timestamp]], 0),
(57, 1, 1, 'moodle/user:delete', 1, [[timestamp]], 0),
(58, 1, 1, 'moodle/user:update', 1, [[timestamp]], 0),
(59, 1, 6, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(60, 1, 5, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(61, 1, 4, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(62, 1, 3, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(63, 1, 1, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(64, 1, 1, 'moodle/user:viewalldetails', 1, [[timestamp]], 0),
(65, 1, 4, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(66, 1, 3, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(67, 1, 1, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(68, 1, 1, 'moodle/user:loginas', 1, [[timestamp]], 0),
(69, 1, 1, 'moodle/user:managesyspages', 1, [[timestamp]], 0),
(70, 1, 7, 'moodle/user:manageownblocks', 1, [[timestamp]], 0),
(71, 1, 7, 'moodle/user:manageownfiles', 1, [[timestamp]], 0),
(72, 1, 1, 'moodle/my:configsyspages', 1, [[timestamp]], 0),
(73, 1, 3, 'moodle/role:assign', 1, [[timestamp]], 0),
(74, 1, 1, 'moodle/role:assign', 1, [[timestamp]], 0),
(75, 1, 4, 'moodle/role:review', 1, [[timestamp]], 0),
(76, 1, 3, 'moodle/role:review', 1, [[timestamp]], 0),
(77, 1, 1, 'moodle/role:review', 1, [[timestamp]], 0),
(78, 1, 1, 'moodle/role:override', 1, [[timestamp]], 0),
(79, 1, 3, 'moodle/role:safeoverride', 1, [[timestamp]], 0),
(80, 1, 1, 'moodle/role:manage', 1, [[timestamp]], 0),
(81, 1, 3, 'moodle/role:switchroles', 1, [[timestamp]], 0),
(82, 1, 1, 'moodle/role:switchroles', 1, [[timestamp]], 0),
(83, 1, 1, 'moodle/category:manage', 1, [[timestamp]], 0),
(84, 1, 2, 'moodle/category:viewhiddencategories', 1, [[timestamp]], 0),
(85, 1, 1, 'moodle/category:viewhiddencategories', 1, [[timestamp]], 0),
(86, 1, 1, 'moodle/cohort:manage', 1, [[timestamp]], 0),
(87, 1, 1, 'moodle/cohort:assign', 1, [[timestamp]], 0),
(88, 1, 3, 'moodle/cohort:view', 1, [[timestamp]], 0),
(89, 1, 1, 'moodle/cohort:view', 1, [[timestamp]], 0),
(90, 1, 2, 'moodle/course:create', 1, [[timestamp]], 0),
(91, 1, 1, 'moodle/course:create', 1, [[timestamp]], 0),
(92, 1, 7, 'moodle/course:request', 1, [[timestamp]], 0),
(93, 1, 1, 'moodle/course:delete', 1, [[timestamp]], 0),
(94, 1, 3, 'moodle/course:update', 1, [[timestamp]], 0),
(95, 1, 1, 'moodle/course:update', 1, [[timestamp]], 0),
(96, 1, 1, 'moodle/course:view', 1, [[timestamp]], 0),
(97, 1, 3, 'moodle/course:enrolreview', 1, [[timestamp]], 0),
(98, 1, 1, 'moodle/course:enrolreview', 1, [[timestamp]], 0),
(99, 1, 3, 'moodle/course:enrolconfig', 1, [[timestamp]], 0),
(100, 1, 1, 'moodle/course:enrolconfig', 1, [[timestamp]], 0),
(101, 1, 4, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(102, 1, 3, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(103, 1, 1, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(104, 1, 4, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(105, 1, 3, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(106, 1, 1, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(107, 1, 2, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(108, 1, 4, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(109, 1, 3, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(110, 1, 1, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(111, 1, 3, 'moodle/course:visibility', 1, [[timestamp]], 0),
(112, 1, 1, 'moodle/course:visibility', 1, [[timestamp]], 0),
(113, 1, 3, 'moodle/course:managefiles', 1, [[timestamp]], 0),
(114, 1, 1, 'moodle/course:managefiles', 1, [[timestamp]], 0),
(115, 1, 3, 'moodle/course:manageactivities', 1, [[timestamp]], 0),
(116, 1, 1, 'moodle/course:manageactivities', 1, [[timestamp]], 0),
(117, 1, 3, 'moodle/course:activityvisibility', 1, [[timestamp]], 0),
(118, 1, 1, 'moodle/course:activityvisibility', 1, [[timestamp]], 0),
(119, 1, 4, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(120, 1, 3, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(121, 1, 1, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(122, 1, 5, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(123, 1, 4, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(124, 1, 3, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(125, 1, 1, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(126, 1, 3, 'moodle/course:changefullname', 1, [[timestamp]], 0),
(127, 1, 1, 'moodle/course:changefullname', 1, [[timestamp]], 0),
(128, 1, 3, 'moodle/course:changeshortname', 1, [[timestamp]], 0),
(129, 1, 1, 'moodle/course:changeshortname', 1, [[timestamp]], 0),
(130, 1, 3, 'moodle/course:changeidnumber', 1, [[timestamp]], 0),
(131, 1, 1, 'moodle/course:changeidnumber', 1, [[timestamp]], 0),
(132, 1, 3, 'moodle/course:changecategory', 1, [[timestamp]], 0),
(133, 1, 1, 'moodle/course:changecategory', 1, [[timestamp]], 0),
(134, 1, 3, 'moodle/course:changesummary', 1, [[timestamp]], 0),
(135, 1, 1, 'moodle/course:changesummary', 1, [[timestamp]], 0),
(136, 1, 1, 'moodle/site:viewparticipants', 1, [[timestamp]], 0),
(137, 1, 5, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(138, 1, 4, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(139, 1, 3, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(140, 1, 1, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(141, 1, 3, 'moodle/course:managescales', 1, [[timestamp]], 0),
(142, 1, 1, 'moodle/course:managescales', 1, [[timestamp]], 0),
(143, 1, 3, 'moodle/course:managegroups', 1, [[timestamp]], 0),
(144, 1, 1, 'moodle/course:managegroups', 1, [[timestamp]], 0),
(145, 1, 3, 'moodle/course:reset', 1, [[timestamp]], 0),
(146, 1, 1, 'moodle/course:reset', 1, [[timestamp]], 0),
(147, 1, 6, 'moodle/blog:view', 1, [[timestamp]], 0),
(148, 1, 7, 'moodle/blog:view', 1, [[timestamp]], 0),
(149, 1, 5, 'moodle/blog:view', 1, [[timestamp]], 0),
(150, 1, 4, 'moodle/blog:view', 1, [[timestamp]], 0),
(151, 1, 3, 'moodle/blog:view', 1, [[timestamp]], 0),
(152, 1, 1, 'moodle/blog:view', 1, [[timestamp]], 0),
(153, 1, 6, 'moodle/blog:search', 1, [[timestamp]], 0),
(154, 1, 7, 'moodle/blog:search', 1, [[timestamp]], 0),
(155, 1, 5, 'moodle/blog:search', 1, [[timestamp]], 0),
(156, 1, 4, 'moodle/blog:search', 1, [[timestamp]], 0),
(157, 1, 3, 'moodle/blog:search', 1, [[timestamp]], 0),
(158, 1, 1, 'moodle/blog:search', 1, [[timestamp]], 0),
(159, 1, 1, 'moodle/blog:viewdrafts', 1, [[timestamp]], 0),
(160, 1, 7, 'moodle/blog:create', 1, [[timestamp]], 0),
(161, 1, 1, 'moodle/blog:create', 1, [[timestamp]], 0),
(162, 1, 4, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(163, 1, 3, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(164, 1, 1, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(165, 1, 5, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(166, 1, 7, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(167, 1, 4, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(168, 1, 3, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(169, 1, 1, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(170, 1, 5, 'moodle/blog:associatecourse', 1, [[timestamp]], 0),
(171, 1, 7, 'moodle/blog:associatecourse', 1, [[timestamp]], 0),
(172, 1, 4, 'moodle/blog:associatecourse', 1, [[timestamp]], 0),
(173, 1, 3, 'moodle/blog:associatecourse', 1, [[timestamp]], 0),
(174, 1, 1, 'moodle/blog:associatecourse', 1, [[timestamp]], 0),
(175, 1, 5, 'moodle/blog:associatemodule', 1, [[timestamp]], 0),
(176, 1, 7, 'moodle/blog:associatemodule', 1, [[timestamp]], 0),
(177, 1, 4, 'moodle/blog:associatemodule', 1, [[timestamp]], 0),
(178, 1, 3, 'moodle/blog:associatemodule', 1, [[timestamp]], 0),
(179, 1, 1, 'moodle/blog:associatemodule', 1, [[timestamp]], 0),
(180, 1, 7, 'moodle/calendar:manageownentries', 1, [[timestamp]], 0),
(181, 1, 1, 'moodle/calendar:manageownentries', 1, [[timestamp]], 0),
(182, 1, 4, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(183, 1, 3, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(184, 1, 1, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(185, 1, 4, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(186, 1, 3, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(187, 1, 1, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(188, 1, 1, 'moodle/user:editprofile', 1, [[timestamp]], 0),
(189, 1, 6, 'moodle/user:editownprofile', -1000, [[timestamp]], 0),
(190, 1, 7, 'moodle/user:editownprofile', 1, [[timestamp]], 0),
(191, 1, 1, 'moodle/user:editownprofile', 1, [[timestamp]], 0),
(192, 1, 6, 'moodle/user:changeownpassword', -1000, [[timestamp]], 0),
(193, 1, 7, 'moodle/user:changeownpassword', 1, [[timestamp]], 0),
(194, 1, 1, 'moodle/user:changeownpassword', 1, [[timestamp]], 0),
(195, 1, 5, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(196, 1, 4, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(197, 1, 3, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(198, 1, 1, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(199, 1, 5, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(200, 1, 4, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(201, 1, 3, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(202, 1, 1, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(203, 1, 1, 'moodle/user:editmessageprofile', 1, [[timestamp]], 0),
(204, 1, 6, 'moodle/user:editownmessageprofile', -1000, [[timestamp]], 0),
(205, 1, 7, 'moodle/user:editownmessageprofile', 1, [[timestamp]], 0),
(206, 1, 1, 'moodle/user:editownmessageprofile', 1, [[timestamp]], 0),
(207, 1, 3, 'moodle/question:managecategory', 1, [[timestamp]], 0),
(208, 1, 1, 'moodle/question:managecategory', 1, [[timestamp]], 0),
(209, 1, 3, 'moodle/question:add', 1, [[timestamp]], 0),
(210, 1, 1, 'moodle/question:add', 1, [[timestamp]], 0),
(211, 1, 3, 'moodle/question:editmine', 1, [[timestamp]], 0),
(212, 1, 1, 'moodle/question:editmine', 1, [[timestamp]], 0),
(213, 1, 3, 'moodle/question:editall', 1, [[timestamp]], 0),
(214, 1, 1, 'moodle/question:editall', 1, [[timestamp]], 0),
(215, 1, 3, 'moodle/question:viewmine', 1, [[timestamp]], 0),
(216, 1, 1, 'moodle/question:viewmine', 1, [[timestamp]], 0),
(217, 1, 3, 'moodle/question:viewall', 1, [[timestamp]], 0),
(218, 1, 1, 'moodle/question:viewall', 1, [[timestamp]], 0),
(219, 1, 3, 'moodle/question:usemine', 1, [[timestamp]], 0),
(220, 1, 1, 'moodle/question:usemine', 1, [[timestamp]], 0),
(221, 1, 3, 'moodle/question:useall', 1, [[timestamp]], 0),
(222, 1, 1, 'moodle/question:useall', 1, [[timestamp]], 0),
(223, 1, 3, 'moodle/question:movemine', 1, [[timestamp]], 0),
(224, 1, 1, 'moodle/question:movemine', 1, [[timestamp]], 0),
(225, 1, 3, 'moodle/question:moveall', 1, [[timestamp]], 0),
(226, 1, 1, 'moodle/question:moveall', 1, [[timestamp]], 0),
(227, 1, 1, 'moodle/question:config', 1, [[timestamp]], 0),
(228, 1, 5, 'moodle/question:flag', 1, [[timestamp]], 0),
(229, 1, 4, 'moodle/question:flag', 1, [[timestamp]], 0),
(230, 1, 3, 'moodle/question:flag', 1, [[timestamp]], 0),
(231, 1, 1, 'moodle/question:flag', 1, [[timestamp]], 0),
(232, 1, 4, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(233, 1, 3, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(234, 1, 1, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(235, 1, 3, 'moodle/course:sectionvisibility', 1, [[timestamp]], 0),
(236, 1, 1, 'moodle/course:sectionvisibility', 1, [[timestamp]], 0),
(237, 1, 3, 'moodle/course:useremail', 1, [[timestamp]], 0),
(238, 1, 1, 'moodle/course:useremail', 1, [[timestamp]], 0),
(239, 1, 3, 'moodle/course:viewhiddensections', 1, [[timestamp]], 0),
(240, 1, 1, 'moodle/course:viewhiddensections', 1, [[timestamp]], 0),
(241, 1, 3, 'moodle/course:setcurrentsection', 1, [[timestamp]], 0),
(242, 1, 1, 'moodle/course:setcurrentsection', 1, [[timestamp]], 0),
(243, 1, 4, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(244, 1, 3, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(245, 1, 1, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(246, 1, 5, 'moodle/grade:view', 1, [[timestamp]], 0),
(247, 1, 4, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(248, 1, 3, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(249, 1, 1, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(250, 1, 3, 'moodle/grade:import', 1, [[timestamp]], 0),
(251, 1, 1, 'moodle/grade:import', 1, [[timestamp]], 0),
(252, 1, 4, 'moodle/grade:export', 1, [[timestamp]], 0),
(253, 1, 3, 'moodle/grade:export', 1, [[timestamp]], 0),
(254, 1, 1, 'moodle/grade:export', 1, [[timestamp]], 0),
(255, 1, 3, 'moodle/grade:manage', 1, [[timestamp]], 0),
(256, 1, 1, 'moodle/grade:manage', 1, [[timestamp]], 0),
(257, 1, 3, 'moodle/grade:edit', 1, [[timestamp]], 0),
(258, 1, 1, 'moodle/grade:edit', 1, [[timestamp]], 0),
(259, 1, 3, 'moodle/grade:manageoutcomes', 1, [[timestamp]], 0),
(260, 1, 1, 'moodle/grade:manageoutcomes', 1, [[timestamp]], 0),
(261, 1, 3, 'moodle/grade:manageletters', 1, [[timestamp]], 0),
(262, 1, 1, 'moodle/grade:manageletters', 1, [[timestamp]], 0),
(263, 1, 3, 'moodle/grade:hide', 1, [[timestamp]], 0),
(264, 1, 1, 'moodle/grade:hide', 1, [[timestamp]], 0),
(265, 1, 3, 'moodle/grade:lock', 1, [[timestamp]], 0),
(266, 1, 1, 'moodle/grade:lock', 1, [[timestamp]], 0),
(267, 1, 3, 'moodle/grade:unlock', 1, [[timestamp]], 0),
(268, 1, 1, 'moodle/grade:unlock', 1, [[timestamp]], 0),
(269, 1, 7, 'moodle/my:manageblocks', 1, [[timestamp]], 0),
(270, 1, 4, 'moodle/notes:view', 1, [[timestamp]], 0),
(271, 1, 3, 'moodle/notes:view', 1, [[timestamp]], 0),
(272, 1, 1, 'moodle/notes:view', 1, [[timestamp]], 0),
(273, 1, 4, 'moodle/notes:manage', 1, [[timestamp]], 0),
(274, 1, 3, 'moodle/notes:manage', 1, [[timestamp]], 0),
(275, 1, 1, 'moodle/notes:manage', 1, [[timestamp]], 0),
(276, 1, 4, 'moodle/tag:manage', 1, [[timestamp]], 0),
(277, 1, 3, 'moodle/tag:manage', 1, [[timestamp]], 0),
(278, 1, 1, 'moodle/tag:manage', 1, [[timestamp]], 0),
(279, 1, 1, 'moodle/tag:create', 1, [[timestamp]], 0),
(280, 1, 7, 'moodle/tag:create', 1, [[timestamp]], 0),
(281, 1, 1, 'moodle/tag:edit', 1, [[timestamp]], 0),
(282, 1, 7, 'moodle/tag:edit', 1, [[timestamp]], 0),
(283, 1, 4, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(284, 1, 3, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(285, 1, 1, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(286, 1, 6, 'moodle/block:view', 1, [[timestamp]], 0),
(287, 1, 7, 'moodle/block:view', 1, [[timestamp]], 0),
(288, 1, 5, 'moodle/block:view', 1, [[timestamp]], 0),
(289, 1, 4, 'moodle/block:view', 1, [[timestamp]], 0),
(290, 1, 3, 'moodle/block:view', 1, [[timestamp]], 0),
(291, 1, 3, 'moodle/block:edit', 1, [[timestamp]], 0),
(292, 1, 7, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(293, 1, 5, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(294, 1, 4, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(295, 1, 3, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(296, 1, 8, 'moodle/comment:view', 1, [[timestamp]], 0),
(297, 1, 6, 'moodle/comment:view', 1, [[timestamp]], 0),
(298, 1, 7, 'moodle/comment:view', 1, [[timestamp]], 0),
(299, 1, 5, 'moodle/comment:view', 1, [[timestamp]], 0),
(300, 1, 4, 'moodle/comment:view', 1, [[timestamp]], 0),
(301, 1, 3, 'moodle/comment:view', 1, [[timestamp]], 0),
(302, 1, 1, 'moodle/comment:view', 1, [[timestamp]], 0),
(303, 1, 7, 'moodle/comment:post', 1, [[timestamp]], 0),
(304, 1, 5, 'moodle/comment:post', 1, [[timestamp]], 0),
(305, 1, 4, 'moodle/comment:post', 1, [[timestamp]], 0),
(306, 1, 3, 'moodle/comment:post', 1, [[timestamp]], 0),
(307, 1, 1, 'moodle/comment:post', 1, [[timestamp]], 0),
(308, 1, 3, 'moodle/comment:delete', 1, [[timestamp]], 0),
(309, 1, 1, 'moodle/comment:delete', 1, [[timestamp]], 0),
(310, 1, 1, 'moodle/webservice:createtoken', 1, [[timestamp]], 0),
(311, 1, 7, 'moodle/rating:view', 1, [[timestamp]], 0),
(312, 1, 5, 'moodle/rating:view', 1, [[timestamp]], 0),
(313, 1, 4, 'moodle/rating:view', 1, [[timestamp]], 0),
(314, 1, 3, 'moodle/rating:view', 1, [[timestamp]], 0),
(315, 1, 1, 'moodle/rating:view', 1, [[timestamp]], 0),
(316, 1, 7, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(317, 1, 5, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(318, 1, 4, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(319, 1, 3, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(320, 1, 1, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(321, 1, 7, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(322, 1, 5, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(323, 1, 4, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(324, 1, 3, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(325, 1, 1, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(326, 1, 7, 'moodle/rating:rate', 1, [[timestamp]], 0),
(327, 1, 5, 'moodle/rating:rate', 1, [[timestamp]], 0),
(328, 1, 4, 'moodle/rating:rate', 1, [[timestamp]], 0),
(329, 1, 3, 'moodle/rating:rate', 1, [[timestamp]], 0),
(330, 1, 1, 'moodle/rating:rate', 1, [[timestamp]], 0),
(331, 1, 1, 'moodle/course:publish', 1, [[timestamp]], 0),
(332, 1, 4, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(333, 1, 3, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(334, 1, 1, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(335, 1, 1, 'moodle/community:add', 1, [[timestamp]], 0),
(336, 1, 4, 'moodle/community:add', 1, [[timestamp]], 0),
(337, 1, 3, 'moodle/community:add', 1, [[timestamp]], 0),
(338, 1, 1, 'moodle/community:download', 1, [[timestamp]], 0),
(339, 1, 3, 'moodle/community:download', 1, [[timestamp]], 0),
(340, 1, 6, 'mod/assignment:view', 1, [[timestamp]], 0),
(341, 1, 5, 'mod/assignment:view', 1, [[timestamp]], 0),
(342, 1, 4, 'mod/assignment:view', 1, [[timestamp]], 0),
(343, 1, 3, 'mod/assignment:view', 1, [[timestamp]], 0),
(344, 1, 1, 'mod/assignment:view', 1, [[timestamp]], 0),
(345, 1, 5, 'mod/assignment:submit', 1, [[timestamp]], 0),
(346, 1, 4, 'mod/assignment:grade', 1, [[timestamp]], 0),
(347, 1, 3, 'mod/assignment:grade', 1, [[timestamp]], 0),
(348, 1, 1, 'mod/assignment:grade', 1, [[timestamp]], 0),
(349, 1, 4, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(350, 1, 3, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(351, 1, 1, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(352, 1, 5, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(353, 1, 5, 'mod/chat:chat', 1, [[timestamp]], 0),
(354, 1, 4, 'mod/chat:chat', 1, [[timestamp]], 0),
(355, 1, 3, 'mod/chat:chat', 1, [[timestamp]], 0),
(356, 1, 1, 'mod/chat:chat', 1, [[timestamp]], 0),
(357, 1, 5, 'mod/chat:readlog', 1, [[timestamp]], 0),
(358, 1, 4, 'mod/chat:readlog', 1, [[timestamp]], 0),
(359, 1, 3, 'mod/chat:readlog', 1, [[timestamp]], 0),
(360, 1, 1, 'mod/chat:readlog', 1, [[timestamp]], 0),
(361, 1, 4, 'mod/chat:deletelog', 1, [[timestamp]], 0),
(362, 1, 3, 'mod/chat:deletelog', 1, [[timestamp]], 0),
(363, 1, 1, 'mod/chat:deletelog', 1, [[timestamp]], 0),
(364, 1, 4, 'mod/chat:exportparticipatedsession', 1, [[timestamp]], 0),
(365, 1, 3, 'mod/chat:exportparticipatedsession', 1, [[timestamp]], 0),
(366, 1, 1, 'mod/chat:exportparticipatedsession', 1, [[timestamp]], 0),
(367, 1, 4, 'mod/chat:exportsession', 1, [[timestamp]], 0),
(368, 1, 3, 'mod/chat:exportsession', 1, [[timestamp]], 0),
(369, 1, 1, 'mod/chat:exportsession', 1, [[timestamp]], 0),
(370, 1, 5, 'mod/choice:choose', 1, [[timestamp]], 0),
(371, 1, 4, 'mod/choice:choose', 1, [[timestamp]], 0),
(372, 1, 3, 'mod/choice:choose', 1, [[timestamp]], 0),
(373, 1, 4, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(374, 1, 3, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(375, 1, 1, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(376, 1, 4, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(377, 1, 3, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(378, 1, 1, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(379, 1, 4, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(380, 1, 3, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(381, 1, 1, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(382, 1, 8, 'mod/data:viewentry', 1, [[timestamp]], 0),
(383, 1, 6, 'mod/data:viewentry', 1, [[timestamp]], 0),
(384, 1, 5, 'mod/data:viewentry', 1, [[timestamp]], 0),
(385, 1, 4, 'mod/data:viewentry', 1, [[timestamp]], 0),
(386, 1, 3, 'mod/data:viewentry', 1, [[timestamp]], 0),
(387, 1, 1, 'mod/data:viewentry', 1, [[timestamp]], 0),
(388, 1, 5, 'mod/data:writeentry', 1, [[timestamp]], 0),
(389, 1, 4, 'mod/data:writeentry', 1, [[timestamp]], 0),
(390, 1, 3, 'mod/data:writeentry', 1, [[timestamp]], 0),
(391, 1, 1, 'mod/data:writeentry', 1, [[timestamp]], 0),
(392, 1, 5, 'mod/data:comment', 1, [[timestamp]], 0),
(393, 1, 4, 'mod/data:comment', 1, [[timestamp]], 0),
(394, 1, 3, 'mod/data:comment', 1, [[timestamp]], 0),
(395, 1, 1, 'mod/data:comment', 1, [[timestamp]], 0),
(396, 1, 4, 'mod/data:rate', 1, [[timestamp]], 0),
(397, 1, 3, 'mod/data:rate', 1, [[timestamp]], 0),
(398, 1, 1, 'mod/data:rate', 1, [[timestamp]], 0),
(399, 1, 4, 'mod/data:viewrating', 1, [[timestamp]], 0),
(400, 1, 3, 'mod/data:viewrating', 1, [[timestamp]], 0),
(401, 1, 1, 'mod/data:viewrating', 1, [[timestamp]], 0),
(402, 1, 4, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(403, 1, 3, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(404, 1, 1, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(405, 1, 4, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(406, 1, 3, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(407, 1, 1, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(408, 1, 4, 'mod/data:approve', 1, [[timestamp]], 0),
(409, 1, 3, 'mod/data:approve', 1, [[timestamp]], 0),
(410, 1, 1, 'mod/data:approve', 1, [[timestamp]], 0),
(411, 1, 4, 'mod/data:manageentries', 1, [[timestamp]], 0),
(412, 1, 3, 'mod/data:manageentries', 1, [[timestamp]], 0),
(413, 1, 1, 'mod/data:manageentries', 1, [[timestamp]], 0),
(414, 1, 4, 'mod/data:managecomments', 1, [[timestamp]], 0),
(415, 1, 3, 'mod/data:managecomments', 1, [[timestamp]], 0),
(416, 1, 1, 'mod/data:managecomments', 1, [[timestamp]], 0),
(417, 1, 3, 'mod/data:managetemplates', 1, [[timestamp]], 0),
(418, 1, 1, 'mod/data:managetemplates', 1, [[timestamp]], 0),
(419, 1, 4, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(420, 1, 3, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(421, 1, 1, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(422, 1, 1, 'mod/data:manageuserpresets', 1, [[timestamp]], 0),
(423, 1, 1, 'mod/data:exportentry', 1, [[timestamp]], 0),
(424, 1, 4, 'mod/data:exportentry', 1, [[timestamp]], 0),
(425, 1, 3, 'mod/data:exportentry', 1, [[timestamp]], 0),
(426, 1, 1, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(427, 1, 4, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(428, 1, 3, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(429, 1, 5, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(430, 1, 1, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(431, 1, 4, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(432, 1, 3, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(433, 1, 6, 'mod/feedback:view', 1, [[timestamp]], 0),
(434, 1, 5, 'mod/feedback:view', 1, [[timestamp]], 0),
(435, 1, 4, 'mod/feedback:view', 1, [[timestamp]], 0),
(436, 1, 3, 'mod/feedback:view', 1, [[timestamp]], 0),
(437, 1, 1, 'mod/feedback:view', 1, [[timestamp]], 0),
(438, 1, 5, 'mod/feedback:complete', 1, [[timestamp]], 0),
(439, 1, 5, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(440, 1, 3, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(441, 1, 1, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(442, 1, 3, 'mod/feedback:deletesubmissions', 1, [[timestamp]], 0),
(443, 1, 1, 'mod/feedback:deletesubmissions', 1, [[timestamp]], 0),
(444, 1, 1, 'mod/feedback:mapcourse', 1, [[timestamp]], 0),
(445, 1, 3, 'mod/feedback:edititems', 1, [[timestamp]], 0),
(446, 1, 1, 'mod/feedback:edititems', 1, [[timestamp]], 0),
(447, 1, 3, 'mod/feedback:createprivatetemplate', 1, [[timestamp]], 0),
(448, 1, 1, 'mod/feedback:createprivatetemplate', 1, [[timestamp]], 0),
(449, 1, 3, 'mod/feedback:createpublictemplate', 1, [[timestamp]], 0),
(450, 1, 1, 'mod/feedback:createpublictemplate', 1, [[timestamp]], 0),
(451, 1, 3, 'mod/feedback:deletetemplate', 1, [[timestamp]], 0),
(452, 1, 1, 'mod/feedback:deletetemplate', 1, [[timestamp]], 0),
(453, 1, 4, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(454, 1, 3, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(455, 1, 1, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(456, 1, 4, 'mod/feedback:receivemail', 1, [[timestamp]], 0),
(457, 1, 3, 'mod/feedback:receivemail', 1, [[timestamp]], 0),
(458, 1, 6, 'mod/folder:view', 1, [[timestamp]], 0),
(459, 1, 7, 'mod/folder:view', 1, [[timestamp]], 0),
(460, 1, 3, 'mod/folder:managefiles', 1, [[timestamp]], 0),
(461, 1, 8, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(462, 1, 6, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(463, 1, 5, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(464, 1, 4, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(465, 1, 3, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(466, 1, 1, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(467, 1, 4, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(468, 1, 3, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(469, 1, 1, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(470, 1, 5, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(471, 1, 4, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(472, 1, 3, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(473, 1, 1, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(474, 1, 5, 'mod/forum:replypost', 1, [[timestamp]], 0),
(475, 1, 4, 'mod/forum:replypost', 1, [[timestamp]], 0),
(476, 1, 3, 'mod/forum:replypost', 1, [[timestamp]], 0),
(477, 1, 1, 'mod/forum:replypost', 1, [[timestamp]], 0),
(478, 1, 4, 'mod/forum:addnews', 1, [[timestamp]], 0),
(479, 1, 3, 'mod/forum:addnews', 1, [[timestamp]], 0),
(480, 1, 1, 'mod/forum:addnews', 1, [[timestamp]], 0),
(481, 1, 4, 'mod/forum:replynews', 1, [[timestamp]], 0),
(482, 1, 3, 'mod/forum:replynews', 1, [[timestamp]], 0),
(483, 1, 1, 'mod/forum:replynews', 1, [[timestamp]], 0),
(484, 1, 5, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(485, 1, 4, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(486, 1, 3, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(487, 1, 1, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(488, 1, 4, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(489, 1, 3, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(490, 1, 1, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(491, 1, 4, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(492, 1, 3, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(493, 1, 1, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(494, 1, 4, 'mod/forum:rate', 1, [[timestamp]], 0),
(495, 1, 3, 'mod/forum:rate', 1, [[timestamp]], 0),
(496, 1, 1, 'mod/forum:rate', 1, [[timestamp]], 0),
(497, 1, 5, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(498, 1, 4, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(499, 1, 3, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(500, 1, 1, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(501, 1, 5, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(502, 1, 4, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(503, 1, 3, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(504, 1, 1, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(505, 1, 4, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(506, 1, 3, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(507, 1, 1, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(508, 1, 4, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(509, 1, 3, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(510, 1, 1, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(511, 1, 4, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(512, 1, 3, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(513, 1, 1, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(514, 1, 4, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(515, 1, 3, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(516, 1, 1, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(517, 1, 4, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(518, 1, 3, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(519, 1, 1, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(520, 1, 4, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(521, 1, 3, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(522, 1, 1, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(523, 1, 4, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(524, 1, 3, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(525, 1, 1, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(526, 1, 4, 'mod/forum:initialsubscriptions', 1, [[timestamp]], 0),
(527, 1, 3, 'mod/forum:initialsubscriptions', 1, [[timestamp]], 0),
(528, 1, 5, 'mod/forum:initialsubscriptions', 1, [[timestamp]], 0),
(529, 1, 4, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(530, 1, 3, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(531, 1, 1, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(532, 1, 4, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(533, 1, 3, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(534, 1, 1, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(535, 1, 4, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(536, 1, 3, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(537, 1, 1, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(538, 1, 4, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(539, 1, 3, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(540, 1, 1, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(541, 1, 5, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(542, 1, 5, 'mod/glossary:write', 1, [[timestamp]], 0),
(543, 1, 4, 'mod/glossary:write', 1, [[timestamp]], 0),
(544, 1, 3, 'mod/glossary:write', 1, [[timestamp]], 0),
(545, 1, 1, 'mod/glossary:write', 1, [[timestamp]], 0),
(546, 1, 4, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(547, 1, 3, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(548, 1, 1, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(549, 1, 4, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(550, 1, 3, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(551, 1, 1, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(552, 1, 5, 'mod/glossary:comment', 1, [[timestamp]], 0),
(553, 1, 4, 'mod/glossary:comment', 1, [[timestamp]], 0),
(554, 1, 3, 'mod/glossary:comment', 1, [[timestamp]], 0),
(555, 1, 1, 'mod/glossary:comment', 1, [[timestamp]], 0),
(556, 1, 4, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(557, 1, 3, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(558, 1, 1, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(559, 1, 4, 'mod/glossary:import', 1, [[timestamp]], 0),
(560, 1, 3, 'mod/glossary:import', 1, [[timestamp]], 0),
(561, 1, 1, 'mod/glossary:import', 1, [[timestamp]], 0),
(562, 1, 4, 'mod/glossary:export', 1, [[timestamp]], 0),
(563, 1, 3, 'mod/glossary:export', 1, [[timestamp]], 0),
(564, 1, 1, 'mod/glossary:export', 1, [[timestamp]], 0),
(565, 1, 4, 'mod/glossary:approve', 1, [[timestamp]], 0),
(566, 1, 3, 'mod/glossary:approve', 1, [[timestamp]], 0),
(567, 1, 1, 'mod/glossary:approve', 1, [[timestamp]], 0),
(568, 1, 4, 'mod/glossary:rate', 1, [[timestamp]], 0),
(569, 1, 3, 'mod/glossary:rate', 1, [[timestamp]], 0),
(570, 1, 1, 'mod/glossary:rate', 1, [[timestamp]], 0),
(571, 1, 4, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(572, 1, 3, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(573, 1, 1, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(574, 1, 4, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(575, 1, 3, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(576, 1, 1, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(577, 1, 4, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(578, 1, 3, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(579, 1, 1, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(580, 1, 4, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(581, 1, 3, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(582, 1, 1, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(583, 1, 4, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(584, 1, 3, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(585, 1, 1, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(586, 1, 5, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(587, 1, 6, 'mod/imscp:view', 1, [[timestamp]], 0),
(588, 1, 7, 'mod/imscp:view', 1, [[timestamp]], 0),
(589, 1, 3, 'mod/lesson:edit', 1, [[timestamp]], 0),
(590, 1, 1, 'mod/lesson:edit', 1, [[timestamp]], 0),
(591, 1, 4, 'mod/lesson:manage', 1, [[timestamp]], 0),
(592, 1, 3, 'mod/lesson:manage', 1, [[timestamp]], 0),
(593, 1, 1, 'mod/lesson:manage', 1, [[timestamp]], 0),
(594, 1, 6, 'mod/page:view', 1, [[timestamp]], 0),
(595, 1, 7, 'mod/page:view', 1, [[timestamp]], 0),
(596, 1, 6, 'mod/quiz:view', 1, [[timestamp]], 0),
(597, 1, 5, 'mod/quiz:view', 1, [[timestamp]], 0),
(598, 1, 4, 'mod/quiz:view', 1, [[timestamp]], 0),
(599, 1, 3, 'mod/quiz:view', 1, [[timestamp]], 0),
(600, 1, 1, 'mod/quiz:view', 1, [[timestamp]], 0),
(601, 1, 5, 'mod/quiz:attempt', 1, [[timestamp]], 0),
(602, 1, 5, 'mod/quiz:reviewmyattempts', 1, [[timestamp]], 0),
(603, 1, 3, 'mod/quiz:manage', 1, [[timestamp]], 0),
(604, 1, 1, 'mod/quiz:manage', 1, [[timestamp]], 0),
(605, 1, 3, 'mod/quiz:manageoverrides', 1, [[timestamp]], 0),
(606, 1, 1, 'mod/quiz:manageoverrides', 1, [[timestamp]], 0),
(607, 1, 4, 'mod/quiz:preview', 1, [[timestamp]], 0),
(608, 1, 3, 'mod/quiz:preview', 1, [[timestamp]], 0),
(609, 1, 1, 'mod/quiz:preview', 1, [[timestamp]], 0),
(610, 1, 4, 'mod/quiz:grade', 1, [[timestamp]], 0),
(611, 1, 3, 'mod/quiz:grade', 1, [[timestamp]], 0),
(612, 1, 1, 'mod/quiz:grade', 1, [[timestamp]], 0),
(613, 1, 4, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(614, 1, 3, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(615, 1, 1, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(616, 1, 4, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(617, 1, 3, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(618, 1, 1, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(619, 1, 3, 'mod/quiz:deleteattempts', 1, [[timestamp]], 0),
(620, 1, 1, 'mod/quiz:deleteattempts', 1, [[timestamp]], 0),
(621, 1, 6, 'mod/resource:view', 1, [[timestamp]], 0),
(622, 1, 7, 'mod/resource:view', 1, [[timestamp]], 0),
(623, 1, 4, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(624, 1, 3, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(625, 1, 1, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(626, 1, 5, 'mod/scorm:skipview', 1, [[timestamp]], 0),
(627, 1, 5, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(628, 1, 4, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(629, 1, 3, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(630, 1, 1, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(631, 1, 5, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(632, 1, 4, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(633, 1, 3, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(634, 1, 1, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(635, 1, 4, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(636, 1, 3, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(637, 1, 1, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(638, 1, 5, 'mod/survey:participate', 1, [[timestamp]], 0),
(639, 1, 4, 'mod/survey:participate', 1, [[timestamp]], 0),
(640, 1, 3, 'mod/survey:participate', 1, [[timestamp]], 0),
(641, 1, 1, 'mod/survey:participate', 1, [[timestamp]], 0),
(642, 1, 4, 'mod/survey:readresponses', 1, [[timestamp]], 0),
(643, 1, 3, 'mod/survey:readresponses', 1, [[timestamp]], 0),
(644, 1, 1, 'mod/survey:readresponses', 1, [[timestamp]], 0),
(645, 1, 4, 'mod/survey:download', 1, [[timestamp]], 0),
(646, 1, 3, 'mod/survey:download', 1, [[timestamp]], 0),
(647, 1, 1, 'mod/survey:download', 1, [[timestamp]], 0),
(648, 1, 6, 'mod/url:view', 1, [[timestamp]], 0),
(649, 1, 7, 'mod/url:view', 1, [[timestamp]], 0),
(650, 1, 6, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(651, 1, 5, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(652, 1, 4, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(653, 1, 3, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(654, 1, 1, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(655, 1, 5, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(656, 1, 4, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(657, 1, 3, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(658, 1, 1, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(659, 1, 5, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(660, 1, 4, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(661, 1, 3, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(662, 1, 1, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(663, 1, 5, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(664, 1, 4, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(665, 1, 3, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(666, 1, 1, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(667, 1, 5, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(668, 1, 4, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(669, 1, 3, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(670, 1, 1, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(671, 1, 4, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(672, 1, 3, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(673, 1, 1, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(674, 1, 4, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(675, 1, 3, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(676, 1, 1, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(677, 1, 4, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(678, 1, 3, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(679, 1, 1, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(680, 1, 4, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(681, 1, 3, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(682, 1, 1, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(683, 1, 6, 'mod/workshop:view', 1, [[timestamp]], 0),
(684, 1, 5, 'mod/workshop:view', 1, [[timestamp]], 0),
(685, 1, 4, 'mod/workshop:view', 1, [[timestamp]], 0),
(686, 1, 3, 'mod/workshop:view', 1, [[timestamp]], 0),
(687, 1, 1, 'mod/workshop:view', 1, [[timestamp]], 0),
(688, 1, 4, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(689, 1, 3, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(690, 1, 1, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(691, 1, 3, 'mod/workshop:editdimensions', 1, [[timestamp]], 0),
(692, 1, 1, 'mod/workshop:editdimensions', 1, [[timestamp]], 0),
(693, 1, 5, 'mod/workshop:submit', 1, [[timestamp]], 0),
(694, 1, 5, 'mod/workshop:peerassess', 1, [[timestamp]], 0),
(695, 1, 4, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(696, 1, 3, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(697, 1, 1, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(698, 1, 4, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(699, 1, 3, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(700, 1, 1, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(701, 1, 4, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(702, 1, 3, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(703, 1, 1, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(704, 1, 5, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(705, 1, 4, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(706, 1, 3, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(707, 1, 1, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(708, 1, 4, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(709, 1, 3, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(710, 1, 1, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(711, 1, 4, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(712, 1, 3, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(713, 1, 1, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(714, 1, 5, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(715, 1, 4, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(716, 1, 3, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(717, 1, 1, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(718, 1, 5, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(719, 1, 4, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(720, 1, 3, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(721, 1, 1, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(722, 1, 4, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(723, 1, 3, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(724, 1, 1, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(725, 1, 4, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(726, 1, 3, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(727, 1, 1, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(728, 1, 1, 'enrol/authorize:config', 1, [[timestamp]], 0),
(729, 1, 1, 'enrol/authorize:manage', 1, [[timestamp]], 0),
(730, 1, 3, 'enrol/authorize:manage', 1, [[timestamp]], 0),
(731, 1, 1, 'enrol/authorize:unenrol', 1, [[timestamp]], 0),
(732, 1, 1, 'enrol/authorize:managepayments', 1, [[timestamp]], 0),
(733, 1, 1, 'enrol/authorize:uploadcsv', 1, [[timestamp]], 0),
(734, 1, 3, 'enrol/cohort:config', 1, [[timestamp]], 0),
(735, 1, 1, 'enrol/cohort:config', 1, [[timestamp]], 0),
(736, 1, 1, 'enrol/guest:config', 1, [[timestamp]], 0),
(737, 1, 3, 'enrol/guest:config', 1, [[timestamp]], 0),
(738, 1, 1, 'enrol/ldap:manage', 1, [[timestamp]], 0),
(739, 1, 1, 'enrol/manual:config', 1, [[timestamp]], 0),
(740, 1, 1, 'enrol/manual:enrol', 1, [[timestamp]], 0),
(741, 1, 3, 'enrol/manual:enrol', 1, [[timestamp]], 0),
(742, 1, 1, 'enrol/manual:manage', 1, [[timestamp]], 0),
(743, 1, 3, 'enrol/manual:manage', 1, [[timestamp]], 0),
(744, 1, 1, 'enrol/manual:unenrol', 1, [[timestamp]], 0),
(745, 1, 3, 'enrol/manual:unenrol', 1, [[timestamp]], 0),
(746, 1, 1, 'enrol/meta:config', 1, [[timestamp]], 0),
(747, 1, 3, 'enrol/meta:config', 1, [[timestamp]], 0),
(748, 1, 1, 'enrol/meta:selectaslinked', 1, [[timestamp]], 0),
(749, 1, 1, 'enrol/paypal:config', 1, [[timestamp]], 0),
(750, 1, 1, 'enrol/paypal:manage', 1, [[timestamp]], 0),
(751, 1, 3, 'enrol/paypal:manage', 1, [[timestamp]], 0),
(752, 1, 1, 'enrol/paypal:unenrol', 1, [[timestamp]], 0),
(753, 1, 3, 'enrol/self:config', 1, [[timestamp]], 0),
(754, 1, 1, 'enrol/self:config', 1, [[timestamp]], 0),
(755, 1, 3, 'enrol/self:manage', 1, [[timestamp]], 0),
(756, 1, 1, 'enrol/self:manage', 1, [[timestamp]], 0),
(757, 1, 5, 'enrol/self:unenrolself', 1, [[timestamp]], 0),
(758, 1, 3, 'enrol/self:unenrol', 1, [[timestamp]], 0),
(759, 1, 1, 'enrol/self:unenrol', 1, [[timestamp]], 0),
(760, 1, 7, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(761, 1, 6, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(762, 1, 5, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(763, 1, 4, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(764, 1, 3, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(765, 1, 1, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(766, 1, 4, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(767, 1, 3, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(768, 1, 1, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(769, 1, 1, 'block/rss_client:manageanyfeeds', 1, [[timestamp]], 0),
(770, 1, 4, 'report/courseoverview:view', 1, [[timestamp]], 0),
(771, 1, 3, 'report/courseoverview:view', 1, [[timestamp]], 0),
(772, 1, 1, 'report/courseoverview:view', 1, [[timestamp]], 0),
(773, 1, 1, 'report/customlang:view', 1, [[timestamp]], 0),
(774, 1, 1, 'report/customlang:edit', 1, [[timestamp]], 0),
(775, 1, 1, 'report/questioninstances:view', 1, [[timestamp]], 0),
(776, 1, 1, 'report/security:view', 1, [[timestamp]], 0),
(777, 1, 1, 'report/unittest:view', 1, [[timestamp]], 0),
(778, 1, 4, 'coursereport/completion:view', 1, [[timestamp]], 0),
(779, 1, 3, 'coursereport/completion:view', 1, [[timestamp]], 0),
(780, 1, 1, 'coursereport/completion:view', 1, [[timestamp]], 0),
(781, 1, 4, 'coursereport/log:view', 1, [[timestamp]], 0),
(782, 1, 3, 'coursereport/log:view', 1, [[timestamp]], 0),
(783, 1, 1, 'coursereport/log:view', 1, [[timestamp]], 0),
(784, 1, 4, 'coursereport/log:viewlive', 1, [[timestamp]], 0),
(785, 1, 3, 'coursereport/log:viewlive', 1, [[timestamp]], 0),
(786, 1, 1, 'coursereport/log:viewlive', 1, [[timestamp]], 0),
(787, 1, 4, 'coursereport/log:viewtoday', 1, [[timestamp]], 0),
(788, 1, 3, 'coursereport/log:viewtoday', 1, [[timestamp]], 0),
(789, 1, 1, 'coursereport/log:viewtoday', 1, [[timestamp]], 0),
(790, 1, 4, 'coursereport/outline:view', 1, [[timestamp]], 0),
(791, 1, 3, 'coursereport/outline:view', 1, [[timestamp]], 0),
(792, 1, 1, 'coursereport/outline:view', 1, [[timestamp]], 0),
(793, 1, 4, 'coursereport/participation:view', 1, [[timestamp]], 0),
(794, 1, 3, 'coursereport/participation:view', 1, [[timestamp]], 0),
(795, 1, 1, 'coursereport/participation:view', 1, [[timestamp]], 0),
(796, 1, 4, 'coursereport/progress:view', 1, [[timestamp]], 0),
(797, 1, 3, 'coursereport/progress:view', 1, [[timestamp]], 0),
(798, 1, 1, 'coursereport/progress:view', 1, [[timestamp]], 0),
(799, 1, 4, 'coursereport/stats:view', 1, [[timestamp]], 0),
(800, 1, 3, 'coursereport/stats:view', 1, [[timestamp]], 0),
(801, 1, 1, 'coursereport/stats:view', 1, [[timestamp]], 0),
(802, 1, 4, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(803, 1, 3, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(804, 1, 1, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(805, 1, 1, 'gradeexport/ods:publish', 1, [[timestamp]], 0),
(806, 1, 4, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(807, 1, 3, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(808, 1, 1, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(809, 1, 1, 'gradeexport/txt:publish', 1, [[timestamp]], 0),
(810, 1, 4, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(811, 1, 3, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(812, 1, 1, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(813, 1, 1, 'gradeexport/xls:publish', 1, [[timestamp]], 0),
(814, 1, 4, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(815, 1, 3, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(816, 1, 1, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(817, 1, 1, 'gradeexport/xml:publish', 1, [[timestamp]], 0),
(818, 1, 3, 'gradeimport/csv:view', 1, [[timestamp]], 0),
(819, 1, 1, 'gradeimport/csv:view', 1, [[timestamp]], 0),
(820, 1, 3, 'gradeimport/xml:view', 1, [[timestamp]], 0),
(821, 1, 1, 'gradeimport/xml:view', 1, [[timestamp]], 0),
(822, 1, 1, 'gradeimport/xml:publish', 1, [[timestamp]], 0),
(823, 1, 4, 'gradereport/grader:view', 1, [[timestamp]], 0),
(824, 1, 3, 'gradereport/grader:view', 1, [[timestamp]], 0),
(825, 1, 1, 'gradereport/grader:view', 1, [[timestamp]], 0),
(826, 1, 4, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(827, 1, 3, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(828, 1, 1, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(829, 1, 5, 'gradereport/overview:view', 1, [[timestamp]], 0),
(830, 1, 1, 'gradereport/overview:view', 1, [[timestamp]], 0),
(831, 1, 5, 'gradereport/user:view', 1, [[timestamp]], 0),
(832, 1, 4, 'gradereport/user:view', 1, [[timestamp]], 0),
(833, 1, 3, 'gradereport/user:view', 1, [[timestamp]], 0),
(834, 1, 1, 'gradereport/user:view', 1, [[timestamp]], 0),
(835, 1, 7, 'repository/alfresco:view', 1, [[timestamp]], 0),
(836, 1, 7, 'repository/boxnet:view', 1, [[timestamp]], 0),
(837, 1, 2, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(838, 1, 4, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(839, 1, 3, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(840, 1, 1, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(841, 1, 7, 'repository/dropbox:view', 1, [[timestamp]], 0),
(842, 1, 2, 'repository/filesystem:view', 1, [[timestamp]], 0),
(843, 1, 4, 'repository/filesystem:view', 1, [[timestamp]], 0),
(844, 1, 3, 'repository/filesystem:view', 1, [[timestamp]], 0),
(845, 1, 1, 'repository/filesystem:view', 1, [[timestamp]], 0),
(846, 1, 7, 'repository/flickr:view', 1, [[timestamp]], 0),
(847, 1, 7, 'repository/flickr_public:view', 1, [[timestamp]], 0),
(848, 1, 7, 'repository/googledocs:view', 1, [[timestamp]], 0),
(849, 1, 2, 'repository/local:view', 1, [[timestamp]], 0),
(850, 1, 4, 'repository/local:view', 1, [[timestamp]], 0),
(851, 1, 3, 'repository/local:view', 1, [[timestamp]], 0),
(852, 1, 1, 'repository/local:view', 1, [[timestamp]], 0),
(853, 1, 7, 'repository/merlot:view', 1, [[timestamp]], 0),
(854, 1, 7, 'repository/picasa:view', 1, [[timestamp]], 0),
(855, 1, 7, 'repository/recent:view', 1, [[timestamp]], 0),
(856, 1, 7, 'repository/s3:view', 1, [[timestamp]], 0),
(857, 1, 7, 'repository/upload:view', 1, [[timestamp]], 0),
(858, 1, 7, 'repository/url:view', 1, [[timestamp]], 0),
(859, 1, 7, 'repository/user:view', 1, [[timestamp]], 0),
(860, 1, 2, 'repository/webdav:view', 1, [[timestamp]], 0),
(861, 1, 4, 'repository/webdav:view', 1, [[timestamp]], 0),
(862, 1, 3, 'repository/webdav:view', 1, [[timestamp]], 0),
(863, 1, 1, 'repository/webdav:view', 1, [[timestamp]], 0),
(864, 1, 7, 'repository/wikimedia:view', 1, [[timestamp]], 0),
(865, 1, 7, 'repository/youtube:view', 1, [[timestamp]], 0),
(866, 1, 4, 'quizreport/statistics:view', 1, [[timestamp]], 0),
(867, 1, 3, 'quizreport/statistics:view', 1, [[timestamp]], 0),
(868, 1, 1, 'quizreport/statistics:view', 1, [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_context_levels`
--

CREATE TABLE `[[dbprefix]]role_context_levels` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) unsigned NOT NULL,
  `contextlevel` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolecontleve_conrol_uix` (`contextlevel`,`roleid`),
  KEY `[[dbprefix]]rolecontleve_rol_ix` (`roleid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Lists which roles can be assigned at which context levels. T' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]role_context_levels`
--

INSERT INTO `[[dbprefix]]role_context_levels` VALUES
(1, 1, 10),
(4, 2, 10),
(2, 1, 40),
(5, 2, 40),
(3, 1, 50),
(6, 3, 50),
(8, 4, 50),
(10, 5, 50),
(7, 3, 70),
(9, 4, 70),
(11, 5, 70);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_names`
--

CREATE TABLE `[[dbprefix]]role_names` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `contextid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolename_rolcon_uix` (`roleid`,`contextid`),
  KEY `[[dbprefix]]rolename_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolename_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='role names in native strings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_sortorder`
--

CREATE TABLE `[[dbprefix]]role_sortorder` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL,
  `roleid` bigint(10) unsigned NOT NULL,
  `contextid` bigint(10) unsigned NOT NULL,
  `sortoder` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolesort_userolcon_uix` (`userid`,`roleid`,`contextid`),
  KEY `[[dbprefix]]rolesort_use_ix` (`userid`),
  KEY `[[dbprefix]]rolesort_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolesort_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='sort order of course managers in a course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scale`
--

CREATE TABLE `[[dbprefix]]scale` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `scale` text NOT NULL,
  `description` text NOT NULL,
  `descriptionformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scal_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Defines grading scales' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scale_history`
--

CREATE TABLE `[[dbprefix]]scale_history` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `action` bigint(10) unsigned NOT NULL DEFAULT '0',
  `oldid` bigint(10) unsigned NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  `loggeduser` bigint(10) unsigned DEFAULT NULL,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `scale` text NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scalhist_act_ix` (`action`),
  KEY `[[dbprefix]]scalhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]scalhist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]scalhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='History table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm`
--

CREATE TABLE `[[dbprefix]]scorm` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `scormtype` varchar(50) NOT NULL DEFAULT 'local',
  `reference` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `version` varchar(9) NOT NULL DEFAULT '',
  `maxgrade` double NOT NULL DEFAULT '0',
  `grademethod` tinyint(2) NOT NULL DEFAULT '0',
  `whatgrade` bigint(10) NOT NULL DEFAULT '0',
  `maxattempt` bigint(10) NOT NULL DEFAULT '1',
  `forcecompleted` tinyint(1) NOT NULL DEFAULT '1',
  `forcenewattempt` tinyint(1) NOT NULL DEFAULT '0',
  `lastattemptlock` tinyint(1) NOT NULL DEFAULT '0',
  `displayattemptstatus` tinyint(1) NOT NULL DEFAULT '1',
  `displaycoursestructure` tinyint(1) NOT NULL DEFAULT '1',
  `updatefreq` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sha1hash` varchar(40) DEFAULT NULL,
  `md5hash` varchar(32) NOT NULL DEFAULT '',
  `revision` bigint(10) unsigned NOT NULL DEFAULT '0',
  `launch` bigint(10) unsigned NOT NULL DEFAULT '0',
  `skipview` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `hidebrowse` tinyint(1) NOT NULL DEFAULT '0',
  `hidetoc` tinyint(1) NOT NULL DEFAULT '0',
  `hidenav` tinyint(1) NOT NULL DEFAULT '0',
  `auto` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `popup` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `options` varchar(255) NOT NULL DEFAULT '',
  `width` bigint(10) unsigned NOT NULL DEFAULT '100',
  `height` bigint(10) unsigned NOT NULL DEFAULT '600',
  `timeopen` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeclose` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scor_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='each table is one SCORM module and its configuration' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes`
--

CREATE TABLE `[[dbprefix]]scorm_scoes` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `scorm` bigint(10) unsigned NOT NULL DEFAULT '0',
  `manifest` varchar(255) NOT NULL DEFAULT '',
  `organization` varchar(255) NOT NULL DEFAULT '',
  `parent` varchar(255) NOT NULL DEFAULT '',
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `launch` text NOT NULL,
  `scormtype` varchar(5) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scorscoe_sco_ix` (`scorm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='each SCO part of the SCORM module' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes_data`
--

CREATE TABLE `[[dbprefix]]scorm_scoes_data` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scorscoedata_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains variable data get from packages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes_track`
--

CREATE TABLE `[[dbprefix]]scorm_scoes_track` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `scormid` bigint(10) NOT NULL DEFAULT '0',
  `scoid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `attempt` bigint(10) unsigned NOT NULL DEFAULT '1',
  `element` varchar(255) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorscoetrac_usescos_uix` (`userid`,`scormid`,`scoid`,`attempt`,`element`),
  KEY `[[dbprefix]]scorscoetrac_use_ix` (`userid`),
  KEY `[[dbprefix]]scorscoetrac_ele_ix` (`element`),
  KEY `[[dbprefix]]scorscoetrac_sco_ix` (`scormid`),
  KEY `[[dbprefix]]scorscoetrac_sco2_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to track SCOes' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_mapinfo`
--

CREATE TABLE `[[dbprefix]]scorm_seq_mapinfo` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `objectiveid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `targetobjectiveid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `readsatisfiedstatus` tinyint(1) NOT NULL DEFAULT '1',
  `readnormalizedmeasure` tinyint(1) NOT NULL DEFAULT '1',
  `writesatisfiedstatus` tinyint(1) NOT NULL DEFAULT '0',
  `writenormalizedmeasure` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqmapi_scoidobj_uix` (`scoid`,`id`,`objectiveid`),
  KEY `[[dbprefix]]scorseqmapi_sco_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqmapi_obj_ix` (`objectiveid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='SCORM2004 objective mapinfo description' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_objective`
--

CREATE TABLE `[[dbprefix]]scorm_seq_objective` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `primaryobj` tinyint(1) NOT NULL DEFAULT '0',
  `objectiveid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `satisfiedbymeasure` tinyint(1) NOT NULL DEFAULT '1',
  `minnormalizedmeasure` float(11,4) unsigned NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqobje_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqobje_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='SCORM2004 objective description' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rolluprule`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rolluprule` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `childactivityset` varchar(15) NOT NULL DEFAULT '',
  `minimumcount` bigint(10) unsigned NOT NULL DEFAULT '0',
  `minimumpercent` float(11,4) unsigned NOT NULL DEFAULT '0.0000',
  `conditioncombination` varchar(3) NOT NULL DEFAULT 'all',
  `action` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqroll_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqroll_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='SCORM2004 sequencing rule' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rolluprulecond`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rolluprulecond` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `rollupruleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `operator` varchar(5) NOT NULL DEFAULT 'noOp',
  `cond` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqroll_scorolid_uix` (`scoid`,`rollupruleid`,`id`),
  KEY `[[dbprefix]]scorseqroll_sco2_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqroll_rol_ix` (`rollupruleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='SCORM2004 sequencing rule' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rulecond`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rulecond` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `ruleconditionsid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `refrencedobjective` varchar(255) NOT NULL DEFAULT '',
  `measurethreshold` float(11,4) NOT NULL DEFAULT '0.0000',
  `operator` varchar(5) NOT NULL DEFAULT 'noOp',
  `cond` varchar(30) NOT NULL DEFAULT 'always',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqrule_idscorul_uix` (`id`,`scoid`,`ruleconditionsid`),
  KEY `[[dbprefix]]scorseqrule_sco2_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqrule_rul_ix` (`ruleconditionsid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='SCORM2004 rule condition' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_ruleconds`
--

CREATE TABLE `[[dbprefix]]scorm_seq_ruleconds` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `conditioncombination` varchar(3) NOT NULL DEFAULT 'all',
  `ruletype` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `action` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqrule_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqrule_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='SCORM2004 rule conditions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `state` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sid` varchar(128) NOT NULL DEFAULT '',
  `userid` bigint(10) unsigned NOT NULL,
  `sessdata` longtext,
  `timecreated` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  `firstip` varchar(45) DEFAULT NULL,
  `lastip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]sess_sid_uix` (`sid`),
  KEY `[[dbprefix]]sess_sta_ix` (`state`),
  KEY `[[dbprefix]]sess_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]sess_tim2_ix` (`timemodified`),
  KEY `[[dbprefix]]sess_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Database based session storage - now recommended' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]sessions`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_daily`
--

CREATE TABLE `[[dbprefix]]stats_daily` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeend` bigint(10) unsigned NOT NULL DEFAULT '0',
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `stattype` varchar(20) NOT NULL DEFAULT 'activity',
  `stat1` bigint(10) unsigned NOT NULL DEFAULT '0',
  `stat2` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statdail_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statdail_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statdail_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to accumulate daily stats' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_monthly`
--

CREATE TABLE `[[dbprefix]]stats_monthly` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeend` bigint(10) unsigned NOT NULL DEFAULT '0',
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `stattype` varchar(20) NOT NULL DEFAULT 'activity',
  `stat1` bigint(10) unsigned NOT NULL DEFAULT '0',
  `stat2` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statmont_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statmont_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statmont_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To accumulate monthly stats' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_daily`
--

CREATE TABLE `[[dbprefix]]stats_user_daily` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeend` bigint(10) unsigned NOT NULL DEFAULT '0',
  `statsreads` bigint(10) unsigned NOT NULL DEFAULT '0',
  `statswrites` bigint(10) unsigned NOT NULL DEFAULT '0',
  `stattype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statuserdail_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statuserdail_use_ix` (`userid`),
  KEY `[[dbprefix]]statuserdail_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statuserdail_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To accumulate daily stats per course/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_monthly`
--

CREATE TABLE `[[dbprefix]]stats_user_monthly` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeend` bigint(10) unsigned NOT NULL DEFAULT '0',
  `statsreads` bigint(10) unsigned NOT NULL DEFAULT '0',
  `statswrites` bigint(10) unsigned NOT NULL DEFAULT '0',
  `stattype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statusermont_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statusermont_use_ix` (`userid`),
  KEY `[[dbprefix]]statusermont_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statusermont_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To accumulate monthly stats per course/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_weekly`
--

CREATE TABLE `[[dbprefix]]stats_user_weekly` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeend` bigint(10) unsigned NOT NULL DEFAULT '0',
  `statsreads` bigint(10) unsigned NOT NULL DEFAULT '0',
  `statswrites` bigint(10) unsigned NOT NULL DEFAULT '0',
  `stattype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statuserweek_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statuserweek_use_ix` (`userid`),
  KEY `[[dbprefix]]statuserweek_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statuserweek_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To accumulate weekly stats per course/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_weekly`
--

CREATE TABLE `[[dbprefix]]stats_weekly` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeend` bigint(10) unsigned NOT NULL DEFAULT '0',
  `roleid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `stattype` varchar(20) NOT NULL DEFAULT 'activity',
  `stat1` bigint(10) unsigned NOT NULL DEFAULT '0',
  `stat2` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statweek_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statweek_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statweek_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To accumulate weekly stats' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey`
--

CREATE TABLE `[[dbprefix]]survey` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `template` bigint(10) unsigned NOT NULL DEFAULT '0',
  `days` mediumint(6) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `questions` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]surv_cou_ix` (`course`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Each record is one SURVEY module with its configuration' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]survey`
--

INSERT INTO `[[dbprefix]]survey` VALUES
(1, 0, 0, 0, 985017600, 985017600, 'collesaname', 'collesaintro', 0, '25,26,27,28,29,30,43,44'),
(2, 0, 0, 0, 985017600, 985017600, 'collespname', 'collespintro', 0, '31,32,33,34,35,36,43,44'),
(3, 0, 0, 0, 985017600, 985017600, 'collesapname', 'collesapintro', 0, '37,38,39,40,41,42,43,44'),
(4, 0, 0, 0, 985017600, 985017600, 'attlsname', 'attlsintro', 0, '65,67,68'),
(5, 0, 0, 0, 985017600, 985017600, 'ciqname', 'ciqintro', 0, '69,70,71,72,73');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey_analysis`
--

CREATE TABLE `[[dbprefix]]survey_analysis` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `survey` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `notes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]survanal_use_ix` (`userid`),
  KEY `[[dbprefix]]survanal_sur_ix` (`survey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='text about each survey submission' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey_answers`
--

CREATE TABLE `[[dbprefix]]survey_answers` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `survey` bigint(10) unsigned NOT NULL DEFAULT '0',
  `question` bigint(10) unsigned NOT NULL DEFAULT '0',
  `time` bigint(10) unsigned NOT NULL DEFAULT '0',
  `answer1` text NOT NULL,
  `answer2` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]survansw_use_ix` (`userid`),
  KEY `[[dbprefix]]survansw_sur_ix` (`survey`),
  KEY `[[dbprefix]]survansw_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='the answers to each questions filled by the users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey_questions`
--

CREATE TABLE `[[dbprefix]]survey_questions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `text` varchar(255) NOT NULL DEFAULT '',
  `shorttext` varchar(30) NOT NULL DEFAULT '',
  `multi` varchar(100) NOT NULL DEFAULT '',
  `intro` varchar(50) NOT NULL DEFAULT '',
  `type` smallint(3) NOT NULL DEFAULT '0',
  `options` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='the questions conforming one survey' AUTO_INCREMENT=74 ;

--
-- Dumping data for table `[[dbprefix]]survey_questions`
--

INSERT INTO `[[dbprefix]]survey_questions` VALUES
(1, 'colles1', 'colles1short', '', '', 1, 'scaletimes5'),
(2, 'colles2', 'colles2short', '', '', 1, 'scaletimes5'),
(3, 'colles3', 'colles3short', '', '', 1, 'scaletimes5'),
(4, 'colles4', 'colles4short', '', '', 1, 'scaletimes5'),
(5, 'colles5', 'colles5short', '', '', 1, 'scaletimes5'),
(6, 'colles6', 'colles6short', '', '', 1, 'scaletimes5'),
(7, 'colles7', 'colles7short', '', '', 1, 'scaletimes5'),
(8, 'colles8', 'colles8short', '', '', 1, 'scaletimes5'),
(9, 'colles9', 'colles9short', '', '', 1, 'scaletimes5'),
(10, 'colles10', 'colles10short', '', '', 1, 'scaletimes5'),
(11, 'colles11', 'colles11short', '', '', 1, 'scaletimes5'),
(12, 'colles12', 'colles12short', '', '', 1, 'scaletimes5'),
(13, 'colles13', 'colles13short', '', '', 1, 'scaletimes5'),
(14, 'colles14', 'colles14short', '', '', 1, 'scaletimes5'),
(15, 'colles15', 'colles15short', '', '', 1, 'scaletimes5'),
(16, 'colles16', 'colles16short', '', '', 1, 'scaletimes5'),
(17, 'colles17', 'colles17short', '', '', 1, 'scaletimes5'),
(18, 'colles18', 'colles18short', '', '', 1, 'scaletimes5'),
(19, 'colles19', 'colles19short', '', '', 1, 'scaletimes5'),
(20, 'colles20', 'colles20short', '', '', 1, 'scaletimes5'),
(21, 'colles21', 'colles21short', '', '', 1, 'scaletimes5'),
(22, 'colles22', 'colles22short', '', '', 1, 'scaletimes5'),
(23, 'colles23', 'colles23short', '', '', 1, 'scaletimes5'),
(24, 'colles24', 'colles24short', '', '', 1, 'scaletimes5'),
(25, 'collesm1', 'collesm1short', '1,2,3,4', 'collesmintro', 1, 'scaletimes5'),
(26, 'collesm2', 'collesm2short', '5,6,7,8', 'collesmintro', 1, 'scaletimes5'),
(27, 'collesm3', 'collesm3short', '9,10,11,12', 'collesmintro', 1, 'scaletimes5'),
(28, 'collesm4', 'collesm4short', '13,14,15,16', 'collesmintro', 1, 'scaletimes5'),
(29, 'collesm5', 'collesm5short', '17,18,19,20', 'collesmintro', 1, 'scaletimes5'),
(30, 'collesm6', 'collesm6short', '21,22,23,24', 'collesmintro', 1, 'scaletimes5'),
(31, 'collesm1', 'collesm1short', '1,2,3,4', 'collesmintro', 2, 'scaletimes5'),
(32, 'collesm2', 'collesm2short', '5,6,7,8', 'collesmintro', 2, 'scaletimes5'),
(33, 'collesm3', 'collesm3short', '9,10,11,12', 'collesmintro', 2, 'scaletimes5'),
(34, 'collesm4', 'collesm4short', '13,14,15,16', 'collesmintro', 2, 'scaletimes5'),
(35, 'collesm5', 'collesm5short', '17,18,19,20', 'collesmintro', 2, 'scaletimes5'),
(36, 'collesm6', 'collesm6short', '21,22,23,24', 'collesmintro', 2, 'scaletimes5'),
(37, 'collesm1', 'collesm1short', '1,2,3,4', 'collesmintro', 3, 'scaletimes5'),
(38, 'collesm2', 'collesm2short', '5,6,7,8', 'collesmintro', 3, 'scaletimes5'),
(39, 'collesm3', 'collesm3short', '9,10,11,12', 'collesmintro', 3, 'scaletimes5'),
(40, 'collesm4', 'collesm4short', '13,14,15,16', 'collesmintro', 3, 'scaletimes5'),
(41, 'collesm5', 'collesm5short', '17,18,19,20', 'collesmintro', 3, 'scaletimes5'),
(42, 'collesm6', 'collesm6short', '21,22,23,24', 'collesmintro', 3, 'scaletimes5'),
(43, 'howlong', '', '', '', 1, 'howlongoptions'),
(44, 'othercomments', '', '', '', 0, NULL),
(45, 'attls1', 'attls1short', '', '', 1, 'scaleagree5'),
(46, 'attls2', 'attls2short', '', '', 1, 'scaleagree5'),
(47, 'attls3', 'attls3short', '', '', 1, 'scaleagree5'),
(48, 'attls4', 'attls4short', '', '', 1, 'scaleagree5'),
(49, 'attls5', 'attls5short', '', '', 1, 'scaleagree5'),
(50, 'attls6', 'attls6short', '', '', 1, 'scaleagree5'),
(51, 'attls7', 'attls7short', '', '', 1, 'scaleagree5'),
(52, 'attls8', 'attls8short', '', '', 1, 'scaleagree5'),
(53, 'attls9', 'attls9short', '', '', 1, 'scaleagree5'),
(54, 'attls10', 'attls10short', '', '', 1, 'scaleagree5'),
(55, 'attls11', 'attls11short', '', '', 1, 'scaleagree5'),
(56, 'attls12', 'attls12short', '', '', 1, 'scaleagree5'),
(57, 'attls13', 'attls13short', '', '', 1, 'scaleagree5'),
(58, 'attls14', 'attls14short', '', '', 1, 'scaleagree5'),
(59, 'attls15', 'attls15short', '', '', 1, 'scaleagree5'),
(60, 'attls16', 'attls16short', '', '', 1, 'scaleagree5'),
(61, 'attls17', 'attls17short', '', '', 1, 'scaleagree5'),
(62, 'attls18', 'attls18short', '', '', 1, 'scaleagree5'),
(63, 'attls19', 'attls19short', '', '', 1, 'scaleagree5'),
(64, 'attls20', 'attls20short', '', '', 1, 'scaleagree5'),
(65, 'attlsm1', 'attlsm1', '45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64', 'attlsmintro', 1, 'scaleagree5'),
(66, '-', '-', '-', '-', 0, '-'),
(67, 'attlsm2', 'attlsm2', '63,62,59,57,55,49,52,50,48,47', 'attlsmintro', -1, 'scaleagree5'),
(68, 'attlsm3', 'attlsm3', '46,54,45,51,60,53,56,58,61,64', 'attlsmintro', -1, 'scaleagree5'),
(69, 'ciq1', 'ciq1short', '', '', 0, NULL),
(70, 'ciq2', 'ciq2short', '', '', 0, NULL),
(71, 'ciq3', 'ciq3short', '', '', 0, NULL),
(72, 'ciq4', 'ciq4short', '', '', 0, NULL),
(73, 'ciq5', 'ciq5short', '', '', 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag`
--

CREATE TABLE `[[dbprefix]]tag` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `rawname` varchar(255) NOT NULL DEFAULT '',
  `tagtype` varchar(255) DEFAULT NULL,
  `description` text,
  `descriptionformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `flag` smallint(4) unsigned DEFAULT '0',
  `timemodified` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tag_nam_uix` (`name`),
  KEY `[[dbprefix]]tag_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tag table - this generic table will replace the old "tags" t' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_correlation`
--

CREATE TABLE `[[dbprefix]]tag_correlation` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `tagid` bigint(10) unsigned NOT NULL,
  `correlatedtags` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tagcorr_tag_ix` (`tagid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The rationale for the ''tag_correlation'' table is performance' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_instance`
--

CREATE TABLE `[[dbprefix]]tag_instance` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `tagid` bigint(10) unsigned NOT NULL,
  `itemtype` varchar(255) NOT NULL DEFAULT '',
  `itemid` bigint(10) unsigned NOT NULL,
  `tiuserid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `ordering` bigint(10) unsigned DEFAULT NULL,
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]taginst_iteitetagtiu_uix` (`itemtype`,`itemid`,`tagid`,`tiuserid`),
  KEY `[[dbprefix]]taginst_tag_ix` (`tagid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='tag_instance table holds the information of associations bet' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]timezone`
--

CREATE TABLE `[[dbprefix]]timezone` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `year` bigint(11) NOT NULL DEFAULT '0',
  `tzrule` varchar(20) NOT NULL DEFAULT '',
  `gmtoff` bigint(11) NOT NULL DEFAULT '0',
  `dstoff` bigint(11) NOT NULL DEFAULT '0',
  `dst_month` tinyint(2) NOT NULL DEFAULT '0',
  `dst_startday` smallint(3) NOT NULL DEFAULT '0',
  `dst_weekday` smallint(3) NOT NULL DEFAULT '0',
  `dst_skipweeks` smallint(3) NOT NULL DEFAULT '0',
  `dst_time` varchar(6) NOT NULL DEFAULT '00:00',
  `std_month` tinyint(2) NOT NULL DEFAULT '0',
  `std_startday` smallint(3) NOT NULL DEFAULT '0',
  `std_weekday` smallint(3) NOT NULL DEFAULT '0',
  `std_skipweeks` smallint(3) NOT NULL DEFAULT '0',
  `std_time` varchar(6) NOT NULL DEFAULT '00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Rules for calculating local wall clock time for users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]upgrade_log`
--

CREATE TABLE `[[dbprefix]]upgrade_log` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` bigint(10) NOT NULL,
  `plugin` varchar(100) DEFAULT NULL,
  `version` varchar(100) DEFAULT NULL,
  `targetversion` varchar(100) DEFAULT NULL,
  `info` varchar(255) NOT NULL DEFAULT '',
  `details` text,
  `backtrace` text,
  `userid` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]upgrlog_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]upgrlog_typtim_ix` (`type`,`timemodified`),
  KEY `[[dbprefix]]upgrlog_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Upgrade logging' AUTO_INCREMENT=431 ;

--
-- Dumping data for table `[[dbprefix]]upgrade_log`
--

INSERT INTO `[[dbprefix]]upgrade_log` VALUES
(1, 0, 'core', '2011033010', '2011033010', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(2, 0, 'core', '2011033010', '2011033010', 'Core installed', NULL, '', 0, [[timestamp]]),
(3, 0, 'mod_assignment', NULL, '2010102600', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(4, 0, 'mod_assignment', '2010102600', '2010102600', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(5, 0, 'mod_chat', NULL, '2010080302', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(6, 0, 'mod_chat', '2010080302', '2010080302', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(7, 0, 'mod_choice', NULL, '2010101301', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(8, 0, 'mod_choice', '2010101301', '2010101301', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(9, 0, 'mod_data', NULL, '2010100101', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(10, 0, 'mod_data', '2010100101', '2010100101', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(11, 0, 'mod_feedback', NULL, '2011051600', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(12, 0, 'mod_feedback', '2011051600', '2011051600', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(13, 0, 'mod_folder', NULL, '2010101400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(14, 0, 'mod_folder', '2010101400', '2010101400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(15, 0, 'mod_forum', NULL, '2010111500', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(16, 0, 'mod_forum', '2010111500', '2010111500', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(17, 0, 'mod_glossary', NULL, '2010111501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(18, 0, 'mod_glossary', '2010111501', '2010111501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(19, 0, 'mod_imscp', NULL, '2010101400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(20, 0, 'mod_imscp', '2010101400', '2010101400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(21, 0, 'mod_label', NULL, '2010080300', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(22, 0, 'mod_label', '2010080300', '2010080300', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(23, 0, 'mod_lesson', NULL, '2010122200', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(24, 0, 'mod_lesson', '2010122200', '2010122200', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(25, 0, 'mod_page', NULL, '2010101400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(26, 0, 'mod_page', '2010101400', '2010101400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(27, 0, 'mod_quiz', NULL, '2010122304', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(28, 0, 'mod_quiz', '2010122304', '2010122304', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(29, 0, 'mod_resource', NULL, '2011022700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(30, 0, 'mod_resource', '2011022700', '2011022700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(31, 0, 'mod_scorm', NULL, '2011021403', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(32, 0, 'mod_scorm', '2011021403', '2011021403', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(33, 0, 'mod_survey', NULL, '2010080300', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(34, 0, 'mod_survey', '2010080300', '2010080300', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(35, 0, 'mod_url', NULL, '2010101401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(36, 0, 'mod_url', '2010101401', '2010101401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(37, 0, 'mod_wiki', NULL, '2011011001', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(38, 0, 'mod_wiki', '2011011001', '2011011001', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(39, 0, 'mod_workshop', NULL, '2011030401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(40, 0, 'mod_workshop', '2011030401', '2011030401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(41, 0, 'auth_cas', NULL, '2010072600', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(42, 0, 'auth_cas', '2010072600', '2010072600', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(43, 0, 'auth_cas', '2010072600', '2010072600', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(44, 0, 'auth_db', NULL, '2009112400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(45, 0, 'auth_db', '2009112400', '2009112400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(46, 0, 'auth_db', '2009112400', '2009112400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(47, 0, 'auth_fc', NULL, '2009112400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(48, 0, 'auth_fc', '2009112400', '2009112400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(49, 0, 'auth_fc', '2009112400', '2009112400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(50, 0, 'auth_imap', NULL, '2009112400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(51, 0, 'auth_imap', '2009112400', '2009112400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(52, 0, 'auth_imap', '2009112400', '2009112400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(53, 0, 'auth_ldap', NULL, '2010072600', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(54, 0, 'auth_ldap', '2010072600', '2010072600', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(55, 0, 'auth_ldap', '2010072600', '2010072600', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(56, 0, 'auth_manual', NULL, '2011022700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(57, 0, 'auth_manual', '2011022700', '2011022700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(58, 0, 'auth_manual', '2011022700', '2011022700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(59, 0, 'auth_mnet', NULL, '2010071300', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(60, 0, 'auth_mnet', '2010071300', '2010071300', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(61, 0, 'auth_mnet', '2010071300', '2010071300', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(62, 0, 'auth_nntp', NULL, '2009112400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(63, 0, 'auth_nntp', '2009112400', '2009112400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(64, 0, 'auth_nntp', '2009112400', '2009112400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(65, 0, 'auth_pam', NULL, '2009112400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(66, 0, 'auth_pam', '2009112400', '2009112400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(67, 0, 'auth_pam', '2009112400', '2009112400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(68, 0, 'auth_pop3', NULL, '2009112400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(69, 0, 'auth_pop3', '2009112400', '2009112400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(70, 0, 'auth_pop3', '2009112400', '2009112400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(71, 0, 'auth_radius', NULL, '2009112400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(72, 0, 'auth_radius', '2009112400', '2009112400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(73, 0, 'auth_radius', '2009112400', '2009112400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(74, 0, 'auth_shibboleth', NULL, '2009112400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(75, 0, 'auth_shibboleth', '2009112400', '2009112400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(76, 0, 'auth_shibboleth', '2009112400', '2009112400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(77, 0, 'enrol_authorize', NULL, '2010081203', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(78, 0, 'enrol_authorize', '2010081203', '2010081203', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(79, 0, 'enrol_authorize', '2010081203', '2010081203', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(80, 0, 'enrol_category', NULL, '2010061500', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(81, 0, 'enrol_category', '2010061500', '2010061500', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(82, 0, 'enrol_category', '2010061500', '2010061500', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(83, 0, 'enrol_cohort', NULL, '2010073100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(84, 0, 'enrol_cohort', '2010073100', '2010073100', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(85, 0, 'enrol_cohort', '2010073100', '2010073100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(86, 0, 'enrol_database', NULL, '2010073101', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(87, 0, 'enrol_database', '2010073101', '2010073101', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(88, 0, 'enrol_database', '2010073101', '2010073101', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(89, 0, 'enrol_flatfile', NULL, '2010091400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(90, 0, 'enrol_flatfile', '2010091400', '2010091400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(91, 0, 'enrol_flatfile', '2010091400', '2010091400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(92, 0, 'enrol_guest', NULL, '2010081800', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(93, 0, 'enrol_guest', '2010081800', '2010081800', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(94, 0, 'enrol_guest', '2010081800', '2010081800', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(95, 0, 'enrol_imsenterprise', NULL, '2011013000', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(96, 0, 'enrol_imsenterprise', '2011013000', '2011013000', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(97, 0, 'enrol_imsenterprise', '2011013000', '2011013000', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(98, 0, 'enrol_ldap', NULL, '2010071100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(99, 0, 'enrol_ldap', '2010071100', '2010071100', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(100, 0, 'enrol_ldap', '2010071100', '2010071100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(101, 0, 'enrol_manual', NULL, '2010071201', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(102, 0, 'enrol_manual', '2010071201', '2010071201', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(103, 0, 'enrol_manual', '2010071201', '2010071201', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(104, 0, 'enrol_meta', NULL, '2010073100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(105, 0, 'enrol_meta', '2010073100', '2010073100', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(106, 0, 'enrol_meta', '2010073100', '2010073100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(107, 0, 'enrol_mnet', NULL, '2010071701', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(108, 0, 'enrol_mnet', '2010071701', '2010071701', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(109, 0, 'enrol_mnet', '2010071701', '2010071701', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(110, 0, 'enrol_paypal', NULL, '2010073100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(111, 0, 'enrol_paypal', '2010073100', '2010073100', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(112, 0, 'enrol_paypal', '2010073100', '2010073100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(113, 0, 'enrol_self', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(114, 0, 'enrol_self', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(115, 0, 'enrol_self', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(116, 0, 'message_email', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(117, 0, 'message_email', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(118, 0, 'message_email', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(119, 0, 'message_jabber', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(120, 0, 'message_jabber', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(121, 0, 'message_jabber', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(122, 0, 'message_popup', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(123, 0, 'message_popup', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(124, 0, 'message_popup', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(125, 0, 'block_activity_modules', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(126, 0, 'block_activity_modules', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(127, 0, 'block_admin_bookmarks', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(128, 0, 'block_admin_bookmarks', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(129, 0, 'block_blog_menu', NULL, '2009071700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(130, 0, 'block_blog_menu', '2009071700', '2009071700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(131, 0, 'block_blog_recent', NULL, '2009070900', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(132, 0, 'block_blog_recent', '2009070900', '2009070900', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(133, 0, 'block_blog_tags', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(134, 0, 'block_blog_tags', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(135, 0, 'block_calendar_month', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(136, 0, 'block_calendar_month', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(137, 0, 'block_calendar_upcoming', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(138, 0, 'block_calendar_upcoming', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(139, 0, 'block_comments', NULL, '2009072000', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(140, 0, 'block_comments', '2009072000', '2009072000', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(141, 0, 'block_community', NULL, '2010042701', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(142, 0, 'block_community', '2010042701', '2010042701', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(143, 0, 'block_completionstatus', NULL, '2009072800', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(144, 0, 'block_completionstatus', '2009072800', '2009072800', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(145, 0, 'block_course_list', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(146, 0, 'block_course_list', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(147, 0, 'block_course_overview', NULL, '2010021100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(148, 0, 'block_course_overview', '2010021100', '2010021100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(149, 0, 'block_course_summary', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(150, 0, 'block_course_summary', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(151, 0, 'block_feedback', NULL, '2010050200', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(152, 0, 'block_feedback', '2010050200', '2010050200', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(153, 0, 'block_glossary_random', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(154, 0, 'block_glossary_random', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(155, 0, 'block_html', NULL, '2010071900', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(156, 0, 'block_html', '2010071900', '2010071900', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(157, 0, 'block_login', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(158, 0, 'block_login', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(159, 0, 'block_mentees', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(160, 0, 'block_mentees', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(161, 0, 'block_messages', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(162, 0, 'block_messages', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(163, 0, 'block_mnet_hosts', NULL, '2010112900', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(164, 0, 'block_mnet_hosts', '2010112900', '2010112900', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(165, 0, 'block_myprofile', NULL, '2009123100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(166, 0, 'block_myprofile', '2009123100', '2009123100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(167, 0, 'block_navigation', NULL, '2010091400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(168, 0, 'block_navigation', '2010091400', '2010091400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(169, 0, 'block_news_items', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(170, 0, 'block_news_items', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(171, 0, 'block_online_users', NULL, '2007101510', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(172, 0, 'block_online_users', '2007101510', '2007101510', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(173, 0, 'block_participants', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(174, 0, 'block_participants', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(175, 0, 'block_private_files', NULL, '2010030100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(176, 0, 'block_private_files', '2010030100', '2010030100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(177, 0, 'block_quiz_results', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(178, 0, 'block_quiz_results', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(179, 0, 'block_recent_activity', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(180, 0, 'block_recent_activity', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(181, 0, 'block_rss_client', NULL, '2009072901', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(182, 0, 'block_rss_client', '2009072901', '2009072901', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(183, 0, 'block_search', NULL, '2010111100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(184, 0, 'block_search', '2010111100', '2010111100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(185, 0, 'block_search_forums', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(186, 0, 'block_search_forums', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(187, 0, 'block_section_links', NULL, '2007101511', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(188, 0, 'block_section_links', '2007101511', '2007101511', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(189, 0, 'block_selfcompletion', NULL, '2009072800', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(190, 0, 'block_selfcompletion', '2009072800', '2009072800', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(191, 0, 'block_settings', NULL, '2010091400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(192, 0, 'block_settings', '2010091400', '2010091400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(193, 0, 'block_site_main_menu', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(194, 0, 'block_site_main_menu', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(195, 0, 'block_social_activities', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(196, 0, 'block_social_activities', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(197, 0, 'block_tag_flickr', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(198, 0, 'block_tag_flickr', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(199, 0, 'block_tag_youtube', NULL, '2007101509', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(200, 0, 'block_tag_youtube', '2007101509', '2007101509', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(201, 0, 'block_tags', NULL, '2010090502', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(202, 0, 'block_tags', '2010090502', '2010090502', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(203, 0, 'filter_emoticon', NULL, '2010102300', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(204, 0, 'filter_emoticon', '2010102300', '2010102300', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(205, 0, 'filter_emoticon', '2010102300', '2010102300', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(206, 0, 'filter_mediaplugin', NULL, '2011030900', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(207, 0, 'filter_mediaplugin', '2011030900', '2011030900', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(208, 0, 'filter_mediaplugin', '2011030900', '2011030900', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(209, 0, 'filter_tex', NULL, '2011031301', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(210, 0, 'filter_tex', '2011031301', '2011031301', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(211, 0, 'filter_tex', '2011031301', '2011031301', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(212, 0, 'filter_urltolink', NULL, '2010100500', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(213, 0, 'filter_urltolink', '2010100500', '2010100500', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(214, 0, 'filter_urltolink', '2010100500', '2010100500', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(215, 0, 'editor_textarea', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(216, 0, 'editor_textarea', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(217, 0, 'editor_textarea', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(218, 0, 'editor_tinymce', NULL, '2010093000', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(219, 0, 'editor_tinymce', '2010093000', '2010093000', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(220, 0, 'editor_tinymce', '2010093000', '2010093000', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(221, 0, 'report_courseoverview', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(222, 0, 'report_courseoverview', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(223, 0, 'report_courseoverview', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(224, 0, 'report_customlang', NULL, '2011041900', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(225, 0, 'report_customlang', '2011041900', '2011041900', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(226, 0, 'report_customlang', '2011041900', '2011041900', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(227, 0, 'report_questioninstances', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(228, 0, 'report_questioninstances', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(229, 0, 'report_questioninstances', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(230, 0, 'report_security', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(231, 0, 'report_security', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(232, 0, 'report_security', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(233, 0, 'report_unittest', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(234, 0, 'report_unittest', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(235, 0, 'report_unittest', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(236, 0, 'report_unsuproles', NULL, '2010071800', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(237, 0, 'report_unsuproles', '2010071800', '2010071800', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(238, 0, 'report_unsuproles', '2010071800', '2010071800', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(239, 0, 'coursereport_completion', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(240, 0, 'coursereport_completion', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(241, 0, 'coursereport_completion', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(242, 0, 'coursereport_log', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(243, 0, 'coursereport_log', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(244, 0, 'coursereport_log', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(245, 0, 'coursereport_outline', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(246, 0, 'coursereport_outline', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(247, 0, 'coursereport_outline', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(248, 0, 'coursereport_participation', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(249, 0, 'coursereport_participation', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(250, 0, 'coursereport_participation', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(251, 0, 'coursereport_progress', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(252, 0, 'coursereport_progress', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(253, 0, 'coursereport_progress', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(254, 0, 'coursereport_stats', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(255, 0, 'coursereport_stats', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(256, 0, 'coursereport_stats', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(257, 0, 'gradeexport_ods', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(258, 0, 'gradeexport_ods', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(259, 0, 'gradeexport_ods', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(260, 0, 'gradeexport_txt', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(261, 0, 'gradeexport_txt', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(262, 0, 'gradeexport_txt', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(263, 0, 'gradeexport_xls', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(264, 0, 'gradeexport_xls', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(265, 0, 'gradeexport_xls', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(266, 0, 'gradeexport_xml', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(267, 0, 'gradeexport_xml', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(268, 0, 'gradeexport_xml', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(269, 0, 'gradeimport_csv', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(270, 0, 'gradeimport_csv', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(271, 0, 'gradeimport_csv', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(272, 0, 'gradeimport_xml', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(273, 0, 'gradeimport_xml', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(274, 0, 'gradeimport_xml', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(275, 0, 'gradereport_grader', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(276, 0, 'gradereport_grader', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(277, 0, 'gradereport_grader', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(278, 0, 'gradereport_outcomes', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(279, 0, 'gradereport_outcomes', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(280, 0, 'gradereport_outcomes', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(281, 0, 'gradereport_overview', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(282, 0, 'gradereport_overview', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(283, 0, 'gradereport_overview', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(284, 0, 'gradereport_user', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(285, 0, 'gradereport_user', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(286, 0, 'gradereport_user', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(287, 0, 'mnetservice_enrol', NULL, '2010071700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(288, 0, 'mnetservice_enrol', '2010071700', '2010071700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(289, 0, 'mnetservice_enrol', '2010071700', '2010071700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(290, 0, 'webservice_amf', NULL, '2009101900', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(291, 0, 'webservice_amf', '2009101900', '2009101900', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(292, 0, 'webservice_amf', '2009101900', '2009101900', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(293, 0, 'webservice_rest', NULL, '2009100800', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(294, 0, 'webservice_rest', '2009100800', '2009100800', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(295, 0, 'webservice_rest', '2009100800', '2009100800', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(296, 0, 'webservice_soap', NULL, '2009101900', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(297, 0, 'webservice_soap', '2009101900', '2009101900', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(298, 0, 'webservice_soap', '2009101900', '2009101900', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(299, 0, 'webservice_xmlrpc', NULL, '2009101900', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(300, 0, 'webservice_xmlrpc', '2009101900', '2009101900', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(301, 0, 'webservice_xmlrpc', '2009101900', '2009101900', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(302, 0, 'repository_alfresco', NULL, '2010050700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(303, 0, 'repository_alfresco', '2010050700', '2010050700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(304, 0, 'repository_alfresco', '2010050700', '2010050700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(305, 0, 'repository_boxnet', NULL, '2009080105', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(306, 0, 'repository_boxnet', '2009080105', '2009080105', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(307, 0, 'repository_boxnet', '2009080105', '2009080105', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(308, 0, 'repository_coursefiles', NULL, '2012010100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(309, 0, 'repository_coursefiles', '2012010100', '2012010100', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(310, 0, 'repository_coursefiles', '2012010100', '2012010100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(311, 0, 'repository_dropbox', NULL, '2010051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(312, 0, 'repository_dropbox', '2010051400', '2010051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(313, 0, 'repository_dropbox', '2010051400', '2010051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(314, 0, 'repository_filesystem', NULL, '2012010100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(315, 0, 'repository_filesystem', '2012010100', '2012010100', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(316, 0, 'repository_filesystem', '2012010100', '2012010100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(317, 0, 'repository_flickr', NULL, '2009080102', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(318, 0, 'repository_flickr', '2009080102', '2009080102', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(319, 0, 'repository_flickr', '2009080102', '2009080102', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(320, 0, 'repository_flickr_public', NULL, '2009080102', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(321, 0, 'repository_flickr_public', '2009080102', '2009080102', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(322, 0, 'repository_flickr_public', '2009080102', '2009080102', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(323, 0, 'repository_googledocs', NULL, '2009080102', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(324, 0, 'repository_googledocs', '2009080102', '2009080102', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(325, 0, 'repository_googledocs', '2009080102', '2009080102', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(326, 0, 'repository_local', NULL, '2012010100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(327, 0, 'repository_local', '2012010100', '2012010100', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(328, 0, 'repository_local', '2012010100', '2012010100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(329, 0, 'repository_merlot', NULL, '2009111301', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(330, 0, 'repository_merlot', '2009111301', '2009111301', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(331, 0, 'repository_merlot', '2009111301', '2009111301', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(332, 0, 'repository_picasa', NULL, '2009080102', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(333, 0, 'repository_picasa', '2009080102', '2009080102', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(334, 0, 'repository_picasa', '2009080102', '2009080102', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(335, 0, 'repository_recent', NULL, '2010042202', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(336, 0, 'repository_recent', '2010042202', '2010042202', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(337, 0, 'repository_recent', '2010042202', '2010042202', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(338, 0, 'repository_s3', NULL, '2009080102', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(339, 0, 'repository_s3', '2009080102', '2009080102', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(340, 0, 'repository_s3', '2009080102', '2009080102', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(341, 0, 'repository_upload', NULL, '2009080102', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(342, 0, 'repository_upload', '2009080102', '2009080102', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(343, 0, 'repository_upload', '2009080102', '2009080102', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(344, 0, 'repository_url', NULL, '2009080102', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(345, 0, 'repository_url', '2009080102', '2009080102', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(346, 0, 'repository_url', '2009080102', '2009080102', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(347, 0, 'repository_user', NULL, '2010052700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(348, 0, 'repository_user', '2010052700', '2010052700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(349, 0, 'repository_user', '2010052700', '2010052700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(350, 0, 'repository_webdav', NULL, '2012010100', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(351, 0, 'repository_webdav', '2012010100', '2012010100', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(352, 0, 'repository_webdav', '2012010100', '2012010100', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(353, 0, 'repository_wikimedia', NULL, '2009080102', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(354, 0, 'repository_wikimedia', '2009080102', '2009080102', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(355, 0, 'repository_wikimedia', '2009080102', '2009080102', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(356, 0, 'repository_youtube', NULL, '2009080102', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(357, 0, 'repository_youtube', '2009080102', '2009080102', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(358, 0, 'repository_youtube', '2009080102', '2009080102', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(359, 0, 'portfolio_boxnet', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(360, 0, 'portfolio_boxnet', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(361, 0, 'portfolio_boxnet', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(362, 0, 'portfolio_download', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(363, 0, 'portfolio_download', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(364, 0, 'portfolio_download', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(365, 0, 'portfolio_flickr', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(366, 0, 'portfolio_flickr', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(367, 0, 'portfolio_flickr', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(368, 0, 'portfolio_googledocs', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(369, 0, 'portfolio_googledocs', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(370, 0, 'portfolio_googledocs', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(371, 0, 'portfolio_mahara', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(372, 0, 'portfolio_mahara', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(373, 0, 'portfolio_mahara', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(374, 0, 'portfolio_picasa', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(375, 0, 'portfolio_picasa', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(376, 0, 'portfolio_picasa', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(377, 0, 'qtype_calculated', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(378, 0, 'qtype_calculated', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(379, 0, 'qtype_calculated', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(380, 0, 'qtype_essay', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(381, 0, 'qtype_essay', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(382, 0, 'qtype_essay', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(383, 0, 'qtype_match', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(384, 0, 'qtype_match', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(385, 0, 'qtype_match', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(386, 0, 'qtype_multianswer', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(387, 0, 'qtype_multianswer', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(388, 0, 'qtype_multianswer', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(389, 0, 'qtype_multichoice', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(390, 0, 'qtype_multichoice', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(391, 0, 'qtype_multichoice', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(392, 0, 'qtype_numerical', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(393, 0, 'qtype_numerical', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(394, 0, 'qtype_numerical', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(395, 0, 'qtype_randomsamatch', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(396, 0, 'qtype_randomsamatch', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(397, 0, 'qtype_randomsamatch', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(398, 0, 'qtype_shortanswer', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(399, 0, 'qtype_shortanswer', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(400, 0, 'qtype_shortanswer', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(401, 0, 'qtype_truefalse', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(402, 0, 'qtype_truefalse', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(403, 0, 'qtype_truefalse', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(404, 0, 'theme_formal_white', NULL, '2011061301', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(405, 0, 'theme_formal_white', '2011061301', '2011061301', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(406, 0, 'theme_formal_white', '2011061301', '2011061301', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(407, 0, 'assignment_online', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(408, 0, 'assignment_online', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(409, 0, 'assignment_online', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(410, 0, 'quiz_overview', NULL, '2009091400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(411, 0, 'quiz_overview', '2009091400', '2009091400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(412, 0, 'quiz_overview', '2009091400', '2009091400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(413, 0, 'quiz_statistics', NULL, '2008112103', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(414, 0, 'quiz_statistics', '2008112103', '2008112103', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(415, 0, 'quiz_statistics', '2008112103', '2008112103', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(416, 0, 'workshopform_accumulative', NULL, '2010091700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(417, 0, 'workshopform_accumulative', '2010091700', '2010091700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(418, 0, 'workshopform_accumulative', '2010091700', '2010091700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(419, 0, 'workshopform_comments', NULL, '2010091700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(420, 0, 'workshopform_comments', '2010091700', '2010091700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(421, 0, 'workshopform_comments', '2010091700', '2010091700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(422, 0, 'workshopform_numerrors', NULL, '2010091700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(423, 0, 'workshopform_numerrors', '2010091700', '2010091700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(424, 0, 'workshopform_numerrors', '2010091700', '2010091700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(425, 0, 'workshopform_rubric', NULL, '2010091700', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(426, 0, 'workshopform_rubric', '2010091700', '2010091700', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(427, 0, 'workshopform_rubric', '2010091700', '2010091700', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(428, 0, 'workshopeval_best', NULL, '2010090501', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(429, 0, 'workshopeval_best', '2010090501', '2010090501', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(430, 0, 'workshopeval_best', '2010090501', '2010090501', 'Plugin installed', NULL, '', 0, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]url`
--

CREATE TABLE `[[dbprefix]]url` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` text,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `externalurl` text,
  `display` smallint(4) unsigned NOT NULL DEFAULT '0',
  `displayoptions` text,
  `parameters` text,
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]url_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='each record is one url resource' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user`
--

CREATE TABLE `[[dbprefix]]user` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `auth` varchar(20) NOT NULL DEFAULT 'manual',
  `confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `policyagreed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `suspended` tinyint(1) NOT NULL DEFAULT '0',
  `mnethostid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `username` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `idnumber` varchar(255) NOT NULL DEFAULT '',
  `firstname` varchar(100) NOT NULL DEFAULT '',
  `lastname` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `emailstop` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `icq` varchar(15) NOT NULL DEFAULT '',
  `skype` varchar(50) NOT NULL DEFAULT '',
  `yahoo` varchar(50) NOT NULL DEFAULT '',
  `aim` varchar(50) NOT NULL DEFAULT '',
  `msn` varchar(50) NOT NULL DEFAULT '',
  `phone1` varchar(20) NOT NULL DEFAULT '',
  `phone2` varchar(20) NOT NULL DEFAULT '',
  `institution` varchar(40) NOT NULL DEFAULT '',
  `department` varchar(30) NOT NULL DEFAULT '',
  `address` varchar(70) NOT NULL DEFAULT '',
  `city` varchar(120) NOT NULL DEFAULT '',
  `country` varchar(2) NOT NULL DEFAULT '',
  `lang` varchar(30) NOT NULL DEFAULT 'en',
  `theme` varchar(50) NOT NULL DEFAULT '',
  `timezone` varchar(100) NOT NULL DEFAULT '99',
  `firstaccess` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lastaccess` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lastlogin` bigint(10) unsigned NOT NULL DEFAULT '0',
  `currentlogin` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(45) NOT NULL DEFAULT '',
  `secret` varchar(15) NOT NULL DEFAULT '',
  `picture` tinyint(1) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `mailformat` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `maildigest` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `maildisplay` tinyint(2) unsigned NOT NULL DEFAULT '2',
  `htmleditor` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ajax` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `autosubscribe` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `trackforums` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `trustbitmask` bigint(10) unsigned NOT NULL DEFAULT '0',
  `imagealt` varchar(255) DEFAULT NULL,
  `screenreader` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]user_mneuse_uix` (`mnethostid`,`username`),
  KEY `[[dbprefix]]user_del_ix` (`deleted`),
  KEY `[[dbprefix]]user_con_ix` (`confirmed`),
  KEY `[[dbprefix]]user_fir_ix` (`firstname`),
  KEY `[[dbprefix]]user_las_ix` (`lastname`),
  KEY `[[dbprefix]]user_cit_ix` (`city`),
  KEY `[[dbprefix]]user_cou_ix` (`country`),
  KEY `[[dbprefix]]user_las2_ix` (`lastaccess`),
  KEY `[[dbprefix]]user_ema_ix` (`email`),
  KEY `[[dbprefix]]user_aut_ix` (`auth`),
  KEY `[[dbprefix]]user_idn_ix` (`idnumber`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='One record for each person' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]user`
--

INSERT INTO `[[dbprefix]]user` VALUES
(1, 'manual', 1, 0, 0, 0, 1, 'guest', '0605220f11ac12fc06944815f4651d22', '', 'Guest user', ' ', 'root@localhost', 0, '', '', '', '', '', '', '', '', '', '', '', '', 'en', '', '99', 0, 0, 0, 0, '', '', 0, '', 'This user is a special user that allows read-only access to some courses.', 0, 1, 0, 2, 1, 1, 1, 0, 0, [[timestamp]], 0, NULL, 0),
(2, 'manual', 1, 0, 0, 0, 1, '[[admin_username]]', '[[admin_pass]]', '', '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', 0, '', '', '', '', '', '', '', '', '', '', 'defaultcity', 'US', '[[language]]', '', '99', 0, [[timestamp]], 0, [[timestamp]], '[[clientip]]', '', 0, '', '', 0, 1, 0, 1, 1, 1, 1, 0, 0, [[timestamp]], 0, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_enrolments`
--

CREATE TABLE `[[dbprefix]]user_enrolments` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` bigint(10) unsigned NOT NULL DEFAULT '0',
  `enrolid` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `timestart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeend` bigint(10) unsigned NOT NULL DEFAULT '2147483647',
  `modifierid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]userenro_enruse_uix` (`enrolid`,`userid`),
  KEY `[[dbprefix]]userenro_enr_ix` (`enrolid`),
  KEY `[[dbprefix]]userenro_use_ix` (`userid`),
  KEY `[[dbprefix]]userenro_mod_ix` (`modifierid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Users participating in courses (aka enrolled users) - everyb' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_info_category`
--

CREATE TABLE `[[dbprefix]]user_info_category` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Customisable fields categories' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_info_data`
--

CREATE TABLE `[[dbprefix]]user_info_data` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `fieldid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `data` longtext NOT NULL,
  `dataformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]userinfodata_usefie_ix` (`userid`,`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data for the customisable user fields' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_info_field`
--

CREATE TABLE `[[dbprefix]]user_info_field` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `shortname` varchar(255) NOT NULL DEFAULT 'shortname',
  `name` longtext NOT NULL,
  `datatype` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `categoryid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sortorder` bigint(10) unsigned NOT NULL DEFAULT '0',
  `required` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `locked` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `visible` smallint(4) unsigned NOT NULL DEFAULT '0',
  `forceunique` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `signup` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `defaultdata` longtext,
  `defaultdataformat` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `param1` longtext,
  `param2` longtext,
  `param3` longtext,
  `param4` longtext,
  `param5` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Customisable user profile fields' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_lastaccess`
--

CREATE TABLE `[[dbprefix]]user_lastaccess` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `courseid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeaccess` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]userlast_usecou_uix` (`userid`,`courseid`),
  KEY `[[dbprefix]]userlast_use_ix` (`userid`),
  KEY `[[dbprefix]]userlast_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To keep track of course page access times, used in online pa' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_preferences`
--

CREATE TABLE `[[dbprefix]]user_preferences` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]userpref_usenam_uix` (`userid`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Allows modules to store arbitrary user preferences' AUTO_INCREMENT=32 ;

--
-- Dumping data for table `[[dbprefix]]user_preferences`
--

INSERT INTO `[[dbprefix]]user_preferences` VALUES
(1, 2, 'message_provider_moodle_notices_loggedin', 'email'),
(2, 2, 'message_provider_moodle_notices_loggedoff', 'email'),
(3, 2, 'message_provider_moodle_errors_loggedin', 'email'),
(4, 2, 'message_provider_moodle_errors_loggedoff', 'email'),
(5, 2, 'message_provider_moodle_instantmessage_loggedin', 'popup'),
(6, 2, 'message_provider_moodle_instantmessage_loggedoff', 'email,popup'),
(7, 2, 'message_provider_moodle_backup_loggedin', 'email'),
(8, 2, 'message_provider_moodle_backup_loggedoff', 'email'),
(9, 2, 'message_provider_moodle_courserequested_loggedin', 'email'),
(10, 2, 'message_provider_moodle_courserequested_loggedoff', 'email'),
(11, 2, 'message_provider_moodle_courserequestapproved_loggedin', 'email'),
(12, 2, 'message_provider_moodle_courserequestapproved_loggedoff', 'email'),
(13, 2, 'message_provider_moodle_courserequestrejected_loggedin', 'email'),
(14, 2, 'message_provider_moodle_courserequestrejected_loggedoff', 'email'),
(15, 2, 'message_provider_mod_assignment_assignment_updates_loggedin', 'email'),
(16, 2, 'message_provider_mod_assignment_assignment_updates_loggedoff', 'email'),
(17, 2, 'message_provider_mod_feedback_submission_loggedin', 'email'),
(18, 2, 'message_provider_mod_feedback_submission_loggedoff', 'email'),
(19, 2, 'message_provider_mod_feedback_message_loggedin', 'email'),
(20, 2, 'message_provider_mod_feedback_message_loggedoff', 'email'),
(21, 2, 'message_provider_mod_forum_posts_loggedin', 'email'),
(22, 2, 'message_provider_mod_forum_posts_loggedoff', 'email'),
(23, 2, 'message_provider_mod_lesson_graded_essay_loggedin', 'email'),
(24, 2, 'message_provider_mod_lesson_graded_essay_loggedoff', 'email'),
(25, 2, 'message_provider_mod_quiz_submission_loggedin', 'email'),
(26, 2, 'message_provider_mod_quiz_submission_loggedoff', 'email'),
(27, 2, 'message_provider_mod_quiz_confirmation_loggedin', 'email'),
(28, 2, 'message_provider_mod_quiz_confirmation_loggedoff', 'email'),
(29, 2, 'auth_forcepasswordchange', '0'),
(30, 2, 'email_bounce_count', '1'),
(31, 2, 'email_send_count', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_private_key`
--

CREATE TABLE `[[dbprefix]]user_private_key` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `script` varchar(128) NOT NULL DEFAULT '',
  `value` varchar(128) NOT NULL DEFAULT '',
  `userid` bigint(10) unsigned NOT NULL,
  `instance` bigint(10) unsigned DEFAULT NULL,
  `iprestriction` varchar(255) DEFAULT NULL,
  `validuntil` bigint(10) unsigned DEFAULT NULL,
  `timecreated` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]userprivkey_scrval_ix` (`script`,`value`),
  KEY `[[dbprefix]]userprivkey_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='access keys used in cookieless scripts - rss, etc.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]webdav_locks`
--

CREATE TABLE `[[dbprefix]]webdav_locks` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `expiry` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `recursive` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `exclusivelock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created` bigint(10) unsigned NOT NULL DEFAULT '0',
  `modified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `owner` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]webdlock_tok_uix` (`token`),
  KEY `[[dbprefix]]webdlock_pat_ix` (`path`),
  KEY `[[dbprefix]]webdlock_exp_ix` (`expiry`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Resource locks for WebDAV users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki`
--

CREATE TABLE `[[dbprefix]]wiki` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT 'Wiki',
  `intro` mediumtext,
  `introformat` smallint(4) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `firstpagetitle` varchar(255) NOT NULL DEFAULT 'First Page',
  `wikimode` varchar(20) NOT NULL DEFAULT 'collaborative',
  `defaultformat` varchar(20) NOT NULL DEFAULT 'creole',
  `forceformat` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `editbegin` bigint(10) unsigned NOT NULL DEFAULT '0',
  `editend` bigint(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]wiki_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores Wiki activity configuration' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_links`
--

CREATE TABLE `[[dbprefix]]wiki_links` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `subwikiid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `frompageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `topageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `tomissingpage` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]wikilink_fro_ix` (`frompageid`),
  KEY `[[dbprefix]]wikilink_sub_ix` (`subwikiid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Page wiki links' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_locks`
--

CREATE TABLE `[[dbprefix]]wiki_locks` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `pageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `sectionname` varchar(255) DEFAULT NULL,
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `lockedat` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Manages page locks' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_pages`
--

CREATE TABLE `[[dbprefix]]wiki_pages` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `subwikiid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT 'title',
  `cachedcontent` mediumtext NOT NULL,
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timerendered` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `pageviews` bigint(10) unsigned NOT NULL DEFAULT '0',
  `readonly` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]wikipage_subtituse_uix` (`subwikiid`,`title`,`userid`),
  KEY `[[dbprefix]]wikipage_sub_ix` (`subwikiid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores wiki pages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_subwikis`
--

CREATE TABLE `[[dbprefix]]wiki_subwikis` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `wikiid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `groupid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]wikisubw_wikgrouse_uix` (`wikiid`,`groupid`,`userid`),
  KEY `[[dbprefix]]wikisubw_wik_ix` (`wikiid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores subwiki instances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_synonyms`
--

CREATE TABLE `[[dbprefix]]wiki_synonyms` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `subwikiid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `pageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `pagesynonym` varchar(255) NOT NULL DEFAULT 'Pagesynonym',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]wikisyno_pagpag_uix` (`pageid`,`pagesynonym`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores wiki pages synonyms' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_versions`
--

CREATE TABLE `[[dbprefix]]wiki_versions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `pageid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `content` mediumtext NOT NULL,
  `contentformat` varchar(20) NOT NULL DEFAULT 'creole',
  `version` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]wikivers_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores wiki page history' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop`
--

CREATE TABLE `[[dbprefix]]workshop` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(3) unsigned NOT NULL DEFAULT '0',
  `instructauthors` longtext,
  `instructauthorsformat` smallint(3) unsigned NOT NULL DEFAULT '0',
  `instructreviewers` longtext,
  `instructreviewersformat` smallint(3) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL,
  `phase` smallint(3) unsigned DEFAULT '0',
  `useexamples` tinyint(2) unsigned DEFAULT '0',
  `usepeerassessment` tinyint(2) unsigned DEFAULT '0',
  `useselfassessment` tinyint(2) unsigned DEFAULT '0',
  `grade` decimal(10,5) unsigned DEFAULT '80.00000',
  `gradinggrade` decimal(10,5) unsigned DEFAULT '20.00000',
  `strategy` varchar(30) NOT NULL DEFAULT '',
  `evaluation` varchar(30) NOT NULL DEFAULT '',
  `gradedecimals` smallint(3) unsigned DEFAULT '0',
  `nattachments` smallint(3) unsigned DEFAULT '0',
  `latesubmissions` tinyint(2) unsigned DEFAULT '0',
  `maxbytes` bigint(10) unsigned DEFAULT '100000',
  `examplesmode` smallint(3) unsigned DEFAULT '0',
  `submissionstart` bigint(10) unsigned DEFAULT '0',
  `submissionend` bigint(10) unsigned DEFAULT '0',
  `assessmentstart` bigint(10) unsigned DEFAULT '0',
  `assessmentend` bigint(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]work_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='This table keeps information about the module instances and ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopeval_best_settings`
--

CREATE TABLE `[[dbprefix]]workshopeval_best_settings` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL,
  `comparison` smallint(3) unsigned DEFAULT '5',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]workbestsett_wor_uix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Settings for the grading evaluation subplugin Comparison wit' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_accumulative`
--

CREATE TABLE `[[dbprefix]]workshopform_accumulative` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL,
  `sort` bigint(10) unsigned DEFAULT '0',
  `description` longtext,
  `descriptionformat` smallint(3) unsigned DEFAULT '0',
  `grade` bigint(10) NOT NULL,
  `weight` mediumint(5) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workaccu_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The assessment dimensions definitions of Accumulative gradin' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_comments`
--

CREATE TABLE `[[dbprefix]]workshopform_comments` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL,
  `sort` bigint(10) unsigned DEFAULT '0',
  `description` longtext,
  `descriptionformat` smallint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workcomm_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The assessment dimensions definitions of Comments strategy f' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_numerrors`
--

CREATE TABLE `[[dbprefix]]workshopform_numerrors` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL,
  `sort` bigint(10) unsigned DEFAULT '0',
  `description` longtext,
  `descriptionformat` smallint(3) unsigned DEFAULT '0',
  `descriptiontrust` bigint(10) unsigned DEFAULT NULL,
  `grade0` varchar(50) DEFAULT NULL,
  `grade1` varchar(50) DEFAULT NULL,
  `weight` mediumint(5) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]worknume_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The assessment dimensions definitions of Number of errors gr' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_numerrors_map`
--

CREATE TABLE `[[dbprefix]]workshopform_numerrors_map` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL,
  `nonegative` bigint(10) unsigned NOT NULL,
  `grade` decimal(10,5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]worknumemap_wornon_uix` (`workshopid`,`nonegative`),
  KEY `[[dbprefix]]worknumemap_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='This maps the number of errors to a percentual grade for sub' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_rubric`
--

CREATE TABLE `[[dbprefix]]workshopform_rubric` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL,
  `sort` bigint(10) unsigned DEFAULT '0',
  `description` longtext,
  `descriptionformat` smallint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workrubr_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The assessment dimensions definitions of Rubric grading stra' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_rubric_config`
--

CREATE TABLE `[[dbprefix]]workshopform_rubric_config` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL,
  `layout` varchar(30) DEFAULT 'list',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]workrubrconf_wor_uix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Configuration table for the Rubric grading strategy' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_rubric_levels`
--

CREATE TABLE `[[dbprefix]]workshopform_rubric_levels` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `dimensionid` bigint(10) unsigned NOT NULL,
  `grade` decimal(10,5) unsigned NOT NULL,
  `definition` longtext,
  `definitionformat` smallint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workrubrleve_dim_ix` (`dimensionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The definition of rubric rating scales' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_aggregations`
--

CREATE TABLE `[[dbprefix]]workshop_aggregations` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL,
  `userid` bigint(10) unsigned NOT NULL,
  `gradinggrade` decimal(10,5) unsigned DEFAULT NULL,
  `timegraded` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]workaggr_woruse_uix` (`workshopid`,`userid`),
  KEY `[[dbprefix]]workaggr_wor_ix` (`workshopid`),
  KEY `[[dbprefix]]workaggr_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Aggregated grades for assessment are stored here. The aggreg' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_assessments`
--

CREATE TABLE `[[dbprefix]]workshop_assessments` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `submissionid` bigint(10) unsigned NOT NULL,
  `reviewerid` bigint(10) unsigned NOT NULL,
  `weight` bigint(10) unsigned NOT NULL DEFAULT '1',
  `timecreated` bigint(10) unsigned DEFAULT '0',
  `timemodified` bigint(10) unsigned DEFAULT '0',
  `grade` decimal(10,5) unsigned DEFAULT NULL,
  `gradinggrade` decimal(10,5) unsigned DEFAULT NULL,
  `gradinggradeover` decimal(10,5) unsigned DEFAULT NULL,
  `gradinggradeoverby` bigint(10) unsigned DEFAULT NULL,
  `feedbackauthor` longtext,
  `feedbackauthorformat` smallint(3) unsigned DEFAULT '0',
  `feedbackreviewer` longtext,
  `feedbackreviewerformat` smallint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workasse_sub_ix` (`submissionid`),
  KEY `[[dbprefix]]workasse_gra_ix` (`gradinggradeoverby`),
  KEY `[[dbprefix]]workasse_rev_ix` (`reviewerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Info about the made assessment and automatically calculated ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_assessments_old`
--

CREATE TABLE `[[dbprefix]]workshop_assessments_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `submissionid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timegraded` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timeagreed` bigint(10) unsigned NOT NULL DEFAULT '0',
  `grade` double NOT NULL DEFAULT '0',
  `gradinggrade` smallint(3) NOT NULL DEFAULT '0',
  `teachergraded` smallint(3) unsigned NOT NULL DEFAULT '0',
  `mailed` smallint(3) unsigned NOT NULL DEFAULT '0',
  `resubmission` smallint(3) unsigned NOT NULL DEFAULT '0',
  `donotuse` smallint(3) unsigned NOT NULL DEFAULT '0',
  `generalcomment` text,
  `teachercomment` text,
  `newplugin` varchar(28) DEFAULT NULL,
  `newid` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workasseold_use_ix` (`userid`),
  KEY `[[dbprefix]]workasseold_mai_ix` (`mailed`),
  KEY `[[dbprefix]]workasseold_wor_ix` (`workshopid`),
  KEY `[[dbprefix]]workasseold_sub_ix` (`submissionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Legacy workshop_assessments table to be dropped later in Moo' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_comments_old`
--

CREATE TABLE `[[dbprefix]]workshop_comments_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assessmentid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `mailed` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `comments` text NOT NULL,
  `newplugin` varchar(28) DEFAULT NULL,
  `newid` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workcommold_use_ix` (`userid`),
  KEY `[[dbprefix]]workcommold_mai_ix` (`mailed`),
  KEY `[[dbprefix]]workcommold_wor_ix` (`workshopid`),
  KEY `[[dbprefix]]workcommold_ass_ix` (`assessmentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Legacy workshop_comments table to be dropped later in Moodle' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_elements_old`
--

CREATE TABLE `[[dbprefix]]workshop_elements_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `elementno` smallint(3) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `scale` smallint(3) unsigned NOT NULL DEFAULT '0',
  `maxscore` smallint(3) unsigned NOT NULL DEFAULT '1',
  `weight` smallint(3) unsigned NOT NULL DEFAULT '11',
  `stddev` double NOT NULL DEFAULT '0',
  `totalassessments` bigint(10) NOT NULL DEFAULT '0',
  `newplugin` varchar(28) DEFAULT NULL,
  `newid` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workelemold_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Legacy workshop_elements table to be dropped later in Moodle' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_grades`
--

CREATE TABLE `[[dbprefix]]workshop_grades` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `assessmentid` bigint(10) unsigned NOT NULL,
  `strategy` varchar(30) NOT NULL DEFAULT '',
  `dimensionid` bigint(10) unsigned NOT NULL,
  `grade` decimal(10,5) unsigned NOT NULL,
  `peercomment` longtext,
  `peercommentformat` smallint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]workgrad_assstrdim_uix` (`assessmentid`,`strategy`,`dimensionid`),
  KEY `[[dbprefix]]workgrad_ass_ix` (`assessmentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='How the reviewers filled-up the grading forms, given grades ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_grades_old`
--

CREATE TABLE `[[dbprefix]]workshop_grades_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assessmentid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `elementno` bigint(10) unsigned NOT NULL DEFAULT '0',
  `feedback` text NOT NULL,
  `grade` smallint(3) NOT NULL DEFAULT '0',
  `newplugin` varchar(28) DEFAULT NULL,
  `newid` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workgradold_wor_ix` (`workshopid`),
  KEY `[[dbprefix]]workgradold_ass_ix` (`assessmentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Legacy workshop_grades table to be dropped later in Moodle 2' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_old`
--

CREATE TABLE `[[dbprefix]]workshop_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `course` bigint(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `wtype` smallint(3) unsigned NOT NULL DEFAULT '0',
  `nelements` smallint(3) unsigned NOT NULL DEFAULT '1',
  `nattachments` smallint(3) unsigned NOT NULL DEFAULT '0',
  `phase` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `format` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `gradingstrategy` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `resubmit` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `agreeassessments` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `hidegrades` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `anonymous` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `includeself` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) unsigned NOT NULL DEFAULT '100000',
  `submissionstart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assessmentstart` bigint(10) unsigned NOT NULL DEFAULT '0',
  `submissionend` bigint(10) unsigned NOT NULL DEFAULT '0',
  `assessmentend` bigint(10) unsigned NOT NULL DEFAULT '0',
  `releasegrades` bigint(10) unsigned NOT NULL DEFAULT '0',
  `grade` smallint(3) NOT NULL DEFAULT '0',
  `gradinggrade` smallint(3) NOT NULL DEFAULT '0',
  `ntassessments` smallint(3) unsigned NOT NULL DEFAULT '0',
  `assessmentcomps` smallint(3) unsigned NOT NULL DEFAULT '2',
  `nsassessments` smallint(3) unsigned NOT NULL DEFAULT '0',
  `overallocation` smallint(3) unsigned NOT NULL DEFAULT '0',
  `timemodified` bigint(10) unsigned NOT NULL DEFAULT '0',
  `teacherweight` smallint(3) unsigned NOT NULL DEFAULT '1',
  `showleaguetable` smallint(3) unsigned NOT NULL DEFAULT '0',
  `usepassword` smallint(3) unsigned NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL DEFAULT '',
  `newplugin` varchar(28) DEFAULT NULL,
  `newid` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workold_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Legacy workshop table to be dropped later in Moodle 2.x' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_rubrics_old`
--

CREATE TABLE `[[dbprefix]]workshop_rubrics_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `elementno` bigint(10) unsigned NOT NULL DEFAULT '0',
  `rubricno` smallint(3) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `newplugin` varchar(28) DEFAULT NULL,
  `newid` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workrubrold_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Legacy workshop_rubrics table to be dropped later in Moodle ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_stockcomments_old`
--

CREATE TABLE `[[dbprefix]]workshop_stockcomments_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `elementno` bigint(10) unsigned NOT NULL DEFAULT '0',
  `comments` text NOT NULL,
  `newplugin` varchar(28) DEFAULT NULL,
  `newid` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workstocold_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Legacy workshop_stockcomments table to be dropped later in M' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_submissions`
--

CREATE TABLE `[[dbprefix]]workshop_submissions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL,
  `example` tinyint(2) unsigned DEFAULT '0',
  `authorid` bigint(10) unsigned NOT NULL,
  `timecreated` bigint(10) unsigned NOT NULL,
  `timemodified` bigint(10) unsigned NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` longtext,
  `contentformat` smallint(3) unsigned NOT NULL DEFAULT '0',
  `contenttrust` smallint(3) unsigned NOT NULL DEFAULT '0',
  `attachment` tinyint(2) unsigned DEFAULT '0',
  `grade` decimal(10,5) unsigned DEFAULT NULL,
  `gradeover` decimal(10,5) unsigned DEFAULT NULL,
  `gradeoverby` bigint(10) unsigned DEFAULT NULL,
  `feedbackauthor` longtext,
  `feedbackauthorformat` smallint(3) unsigned DEFAULT '0',
  `timegraded` bigint(10) unsigned DEFAULT NULL,
  `published` tinyint(2) unsigned DEFAULT '0',
  `late` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]worksubm_wor_ix` (`workshopid`),
  KEY `[[dbprefix]]worksubm_gra_ix` (`gradeoverby`),
  KEY `[[dbprefix]]worksubm_aut_ix` (`authorid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Info about the submission and the aggregation of the grade f' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_submissions_old`
--

CREATE TABLE `[[dbprefix]]workshop_submissions_old` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `userid` bigint(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL DEFAULT '',
  `timecreated` bigint(10) unsigned NOT NULL DEFAULT '0',
  `mailed` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `gradinggrade` smallint(3) unsigned NOT NULL DEFAULT '0',
  `finalgrade` smallint(3) unsigned NOT NULL DEFAULT '0',
  `late` smallint(3) unsigned NOT NULL DEFAULT '0',
  `nassessments` bigint(10) unsigned NOT NULL DEFAULT '0',
  `newplugin` varchar(28) DEFAULT NULL,
  `newid` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]worksubmold_use_ix` (`userid`),
  KEY `[[dbprefix]]worksubmold_mai_ix` (`mailed`),
  KEY `[[dbprefix]]worksubmold_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Legacy workshop_submissions table to be dropped later in Moo' AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
