<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'ja', branch 'MOODLE_20_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'スクリーンショットを追加する';
$string['advertise'] = 'ユーザが参加できるよう、このコースを広告する';
$string['advertised'] = '広告';
$string['advertiseon'] = 'このコースを {$a} に広告する';
$string['advertiseonhub'] = 'このコースをハブに広告する';
$string['advertiseonmoodleorg'] = 'このコースをmoodle.orgに広告する';
$string['advertisepublication_help'] = 'ユーザがこのコースを探して受講登録できるよう、コミュニティハブ上にあなたのコースを広告します。';
$string['all'] = 'すべて';
$string['allowglobalsearch'] = 'このハブを公開して、すべてのコースのグローバルサーチを許可する';
$string['allowpublicsearch'] = 'ユーザが参加できるよう、このハブを公開する';
$string['audience'] = 'オーディエンス';
$string['audienceadmins'] = 'Moodle管理者';
$string['audienceeducators'] = '教育者';
$string['audience_help'] = 'コースが対象とするオーディエンスを選択してください。';
$string['audiencestudents'] = '学生';
$string['badurlformat'] = '無効なURIフォーマット';
$string['cannotsearchcommunity'] = '申し訳ございません、あなたにはこのページを閲覧するための適切なパーミッションがありません。';
$string['community'] = 'コミュニティ';
$string['communityremoved'] = 'あなたのリストからコースリンクが削除されました。';
$string['confirmregistration'] = '登録を承認する';
$string['contactable'] = 'パブリックからのコンタクト';
$string['contactable_help'] = 'この設定を有効にした場合、あなたのメールアドレスがハブに公開されます。';
$string['contactemail'] = '連絡先メール';
$string['contactname'] = '連絡先';
$string['contactphone'] = '電話';
$string['contactphone_help'] = '電話番号はハブ管理者のみに表示され、パブリックに公開されることはありません。';
$string['continue'] = '続ける';
$string['contributornames'] = '他の寄稿者';
$string['contributornames_help'] = 'このフィールドを使用することで、あなたはこのコースに寄稿した人の氏名を一覧表示することができます。';
$string['coursemap'] = 'コースマップ';
$string['coursename'] = '名称';
$string['courseprivate'] = 'プライベート';
$string['coursepublic'] = 'パブリック';
$string['coursepublished'] = 'コースは「 {$a} 」に正常に公開されました。';
$string['courseshortname'] = '省略名';
$string['courseshortname_help'] = 'あなたのコース省略名を入力してください。省略名はユニークである必要はありません。';
$string['coursesnumber'] = 'コース数 ({$a})';
$string['courseunpublished'] = 'すでにコース {$a->courseshortname} は {$a->hubname} に公開されていません。';
$string['courseurl'] = 'コースURI';
$string['courseurl_help'] = 'あなたのコースのURIです。このURIは検索結果のリンクとして表示されます。';
$string['creatorname'] = '作成者';
$string['creatorname_help'] = '作成者はコース作成者です。';
$string['creatornotes'] = '作成者ノート';
$string['creatornotes_help'] = '作成者ノートはこのコースの使い方に関する教師ガイドです。';
$string['deletescreenshots'] = 'これらのスクリーンショットを削除する';
$string['deletescreenshots_help'] = '現在アップロードされているすべてのスクリーンショットを削除します。';
$string['demourl'] = 'デモURI';
$string['demourl_help'] = 'あなたのコースのデモURIを入力してください。デフォルトはあなたのコースのURIです。デモURIは検索結果のリンクとして表示されます。';
$string['description'] = '説明';
$string['description_help'] = 'この説明テキストはハブのコース一覧に表示されます。';
$string['detectednotexistingpublication'] = '{$a->hubname} はすでに存在しないコースを一覧表示しています。このハブ管理者に公開ナンバー {$a->id} を削除するよう報告してください。';
$string['downloadable'] = 'ダウンロード可';
$string['educationallevel'] = '教育レベル';
$string['educationallevel_help'] = 'コースにあてはまる最も適切な学習レベルを選択してください。';
$string['edulevelassociation'] = '団体';
$string['edulevelcorporate'] = '法人';
$string['edulevelgovernment'] = '政府';
$string['edulevelother'] = '他';
$string['edulevelprimary'] = '初等教育';
$string['edulevelsecondary'] = '中等教育';
$string['eduleveltertiary'] = '第三次教育';
$string['emailalert'] = 'メール通知';
$string['emailalert_help'] = 'この設定を有効にした場合、ハブ管理者はセキュリティおよび他の重要なニュースに関してあなたにメール送信します。';
$string['enrollable'] = '登録可';
$string['errorbadimageheightwidth'] = 'イメージの最大サイズは $a->width} X {$a->height} にしてください。';
$string['errorcourseinfo'] = 'ハブ ({$a}) のコースメタデータ検索中にエラーが発生しました。後でこのページをリロードした後、再度コースメタデータを検索してください。そうでない場合、あなたは以下のデフォルトメタデータを使用して登録処理を継続することができます。';
$string['errorcoursepublish'] = 'コース公開中にエラーが発生しました: ({$a}) 後で再度お試しください。';
$string['errorcoursewronglypublished'] = 'ハブから公開エラーが通知されました。後で再度お試しください。';
$string['errorcron'] = '{$a->hubname} の登録更新中にエラーが発生しました: ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = '登録を更新するには、XML-RPCを有効にする必要があります。';
$string['errorhublisting'] = 'Moodle.orgのハブリスト検索中にエラーが発生しました。後で再度お試しください: ({$a})';
$string['errorlangnotrecognized'] = '提供された言語コードはMoodleでは使用できません。{$a} にご連絡ください。';
$string['errorregistration'] = '登録中にエラーが発生しました。後ほど再度お試しください。({$a})';
$string['errorunpublishcourses'] = '予期しないエラーが発生したため、ハブからコースを削除できませんでした。再度お試しいただくか (推奨)、ハブ管理者にご連絡ください。';
$string['existingscreenshotnumber'] = '{$a} 件のスクリーンショットがあります。ハブ管理者があなたのコースを有効にした後、これらのスクリーンショットを閲覧することができるようになります。';
$string['existingscreenshots'] = '既存のスクリーンショット';
$string['forceunregister'] = 'はい、登録データを消去します';
$string['forceunregisterconfirmation'] = 'あなたのサイトは {$a} に到達できません。このハブは一時的に稼動停止しています。あなたが本当にローカルでの登録削除を望まない限り、キャンセルした後、再度お試しください。';
$string['geolocation'] = 'ジオロケーション';
$string['geolocation_help'] = '	
将来的に私たちはロケーションベースの検索を提供します。あなたのコースロケーションを指定したい場合、ここに緯度/経度情報を入力してください (例: -31.947884,115.871285)。この値を求める1つの方法はGoogleマップを使用することです。';
$string['hub'] = 'ハブ';
$string['imageurl'] = 'イメージURI';
$string['imageurl_help'] = 'このイメージはハブに表示されます。また、このイメージは常に利用できるようにしてください。イメージの最大サイズは {$a->width} X {$a->height} です。';
$string['information'] = 'インフォメーション';
$string['language'] = '言語';
$string['language_help'] = 'このコースの主言語です。';
$string['lasttimechecked'] = '最終確認日時';
$string['licence'] = 'ライセンス';
$string['licence_help'] = 'あなたのコース公開に関するライセンスを選択してください。';
$string['logourl'] = 'ロゴURI';
$string['modulenumberaverage'] = 'コースモジュールの平均数 ({$a})';
$string['moodleorg'] = 'Moodle.org';
$string['moodleorgregistrationdetail'] = 'hub.moodle.orgにあるメインのコミュニティハブはMOOCHと呼ばれます。あなたのサイトをMOOCHに登録することで、世界中のMoodleコミュニティに統計情報を提供することができます。あなたはセキュリティ修正に関する早い時期の通知および新しいMoodleのリリースを提供する、配信頻度の低いメーリングリストに参加することもできます。';
$string['moodleorgregistrationdetail2'] = 'このオプションでは、あなのMoodleサイトをhub.moodle.orgのMOOCHに登録することができます。登録費用は無料です。登録の利点はセキュリティ修正に関する通知および新しいMoodleのリリースを提供する、配信頻度の低いメーリングリストにあなたが登録されることです。
デフォルトでは、あなたの情報は秘匿され、第三者に販売したり渡されることはありません。この情報を収集する唯一の目的はサポートおよびMoodleコミュニティ全体の統計図を構築することにあります。登録することを選択した場合、あなたのサイト名、国、URIがMoodleサイトの公開リストに登録されます。すべての登録内容は公開リストに登録される前に手作業で確認されます。登録後はいつでも登録内容 (および公開リストの内容) を更新することができます。';
$string['mustselectsubject'] = 'あなたは学習テーマを選択する必要があります。';
$string['name'] = '名称';
$string['name_help'] = 'この名称はコース一覧に表示されます。';
$string['neverchecked'] = '未チェック';
$string['next'] = '次へ';
$string['no'] = 'No';
$string['nocheckstatusfromunreghub'] = 'サイトがハブに登録されていないため、ステータスはチェックされません。';
$string['nohubselected'] = 'ハブが選択されていません。';
$string['none'] = 'なし
';
$string['nosearch'] = 'ハブまたはコースを公開しない';
$string['notregisteredonhub'] = 'あなたのコースを公開する前に、管理者は少なくとも1つのコースをハブに登録する必要があります。あなたのサイト管理者にご連絡ください。';
$string['notregisteredonmoodleorg'] = 'あなたの管理者はこのサイトをmoodle.orgに登録する必要があります。';
$string['operation'] = '操作';
$string['orenterprivatehub'] = '代わりに、プライベートハブのURIを入力してください:';
$string['participantnumberaverage'] = '平均参加者数 ({$a})';
$string['postaladdress'] = '住所';
$string['postaladdress_help'] = 'このサイトの住所またはこのサイトが存在する場所です。';
$string['postsnumber'] = '投稿数 ({$a})';
$string['previousregistrationdeleted'] = '以前の登録は {$a} から削除されました。あなたは登録処理を再開することができます。ありがとうございます。';
$string['prioritise'] = '優先';
$string['privacy'] = 'プライバシー';
$string['privacy_help'] = 'ハブでは登録サイトを一覧表示することができます。ハブが登録サイトを公開している場合、あなたのサイトを一覧に表示するかどうか選択することができます。';
$string['private'] = 'プライベート';
$string['privatehuburl'] = 'プライベートハブURI';
$string['publicationinfo'] = 'コース公開情報';
$string['publichub'] = 'パブリックハブ';
$string['publishcourse'] = '{$a} を公開する';
$string['publishcourseon'] = '{$a} に公開する';
$string['publishedon'] = '公開済み';
$string['publisheremail'] = '公開者メール';
$string['publisheremail_help'] = 'ハブ管理者は公開済みコースのステータス変更等の情報を公開者メールアドレス宛に通知することができます。';
$string['publishername'] = '公開者';
$string['publishername_help'] = '公開者は公式にコースを公開する個人または団体です。他の人の代理としてコースを公開しない限り、あなたが公開者となります。';
$string['publishon'] = '公開';
$string['publishonmoodleorg'] = 'MOOCHに公開する';
$string['publishonspecifichub'] = '別のハブに公開する';
$string['questionsnumber'] = '問題数 ({$a})';
$string['readvertiseon'] = '{$a} の広告情報を更新する';
$string['registeredcourses'] = '登録済みコース';
$string['registeredmoodleorg'] = 'Moodle.org ({$a})';
$string['registeredon'] = '登録済み';
$string['registeredsites'] = '登録済みサイト';
$string['registeron'] = 'あなたのサイトを登録する';
$string['registeronmoodleorg'] = 'Moodle.org (MOOCH) に登録する';
$string['registeronspecifichub'] = '特定のハブに登録する';
$string['registersite'] = '{$a} に登録する';
$string['registrationconfirmed'] = 'サイト登録承認';
$string['registrationconfirmedon'] = 'あなたはハブ {$a} に登録されました。コース管理メニュー内の「公開」リンクを使用して、このハブにあなたのコースを公開することができます。';
$string['registrationinfo'] = '登録情報';
$string['registrationupdated'] = '登録が更新されました。';
$string['registrationupdatedfailed'] = '登録更新に失敗しました。';
$string['removefromhub'] = 'ハブから登録解除する';
$string['renewregistration'] = '登録を更新する';
$string['resourcesnumber'] = 'リソース数 ({$a})';
$string['restartregistration'] = '登録を再開する';
$string['roleassignmentsnumber'] = 'ロール割り当て数 ({$a})';
$string['screenshots'] = 'スクリーンショット';
$string['screenshots_help'] = 'コースのスクリーンショットすべては検索結果に表示されます。';
$string['search'] = '検索';
$string['selecthub'] = 'ハブを選択する';
$string['selecthubforadvertise'] = '公開のためのハブを選択する';
$string['selecthubforsharing'] = 'アップロードのためにハブを選択する';
$string['selecthubinfo'] = 'コミュニティハブはコースを一覧表示するサーバです。このMoodleサイトが登録しているハブにのみ、あなたのコースを公開することができます。あなたが希望するハブが下記に表示されていない場合、あなたのサイト管理者にご連絡ください。';
$string['sendfollowinginfo'] = '追加情報';
$string['sendfollowinginfo_help'] = '次の情報は全体的な統計のためだけに送信されます。送信された情報は一覧表示されるサイトにおいて公開されることはありません。';
$string['sendingcourse'] = 'コースの送信';
$string['sendingsize'] = 'お待ちください、コースファイルアップロード中です ({$a->total}Mb) ...';
$string['sent'] = '... 完了しました。';
$string['settings'] = '設定';
$string['settingsupdated'] = '設定が更新されました。';
$string['share'] = 'ユーザがダウンロードできるよう、このコースを共有する';
$string['shared'] = '共有';
$string['shareon'] = 'このコースを {$a} にアップロードする';
$string['shareonhub'] = 'このコースをハブにアップロードする';
$string['shareonmoodleorg'] = 'このコースをMOOCHにアップロードする';
$string['sharepublication_help'] = 'このコースをコミュニティハブサーバにアップロードすることで、ユーザがダウンロードして自分のMoodleサイトにインストールできるようになります。';
$string['siteadmin'] = '管理者';
$string['siteadmin_help'] = 'サイト管理者のフルネームです。';
$string['sitecountry'] = '国';
$string['sitecountry_help'] = 'あなたの組織が存在する国です。';
$string['sitecreated'] = 'サイト作成日時';
$string['sitedesc'] = '説明';
$string['sitedesc_help'] = 'あなたのサイト説明はサイト一覧に表示されます。プレインテキストのみ使用してください。';
$string['siteemail'] = 'メールアドレス';
$string['siteemail_help'] = '必要に応じてサイト管理者が連絡できるよう、あなたはメールアドレスを提供する必要があります。このメールアドレスは他の目的に使用されることはありません。直接個人のメールアドレスではなく、ポジションに関係するメールアドレス (例: sitemanager@example.com) の入力をお勧めします。';
$string['sitegeolocation'] = 'ジオロケーション';
$string['sitegeolocation_help'] = '将来的に私たちはロケーションベースのハブ検索を提供します。あなたのサイトロケーションを指定したい場合、ここに緯度/経度情報を入力してください (例: -31.947884,115.871285)。この値を求める1つの方法はGoogleマップを使用することです。';
$string['sitelang'] = '言語';
$string['sitelang_help'] = 'あなたのサイト言語はサイト一覧に表示されます。';
$string['sitename'] = '名称';
$string['sitename_help'] = 'ハブが許可する場合、サイト名はサイト一覧に表示されます。';
$string['sitephone'] = '電話';
$string['sitephone_help'] = 'あなたの電話番号はハブ管理者のみ閲覧することができます。';
$string['siteprivacy'] = 'プライバシー';
$string['siteprivacylinked'] = 'リンク付きサイト名を公開してください';
$string['siteprivacynotpublished'] = 'このサイトを公開しないでください';
$string['siteprivacypublished'] = 'サイト名のみ公開してください';
$string['siteregconfcomment'] = 'あなたのサイトは {$a} の最終確認が必要です ({$a} のスパムを避けるため)。';
$string['siteregistrationcontact'] = 'コンタクトフォーム';
$string['siteregistrationcontact_help'] = 'この設定を有効にした場合、ユーザはハブ上のコンタクトフォーム経由であなたに連絡することができます。ユーザはあなたのメールアドレスを閲覧することはできません。';
$string['siteregistrationemail'] = 'メール通知';
$string['siteregistrationemail_help'] = 'この設定を有効にした場合、ハブ管理者はセキュリティ問題等の重要なニュースをあなたにメール通知することができます。';
$string['siteregistrationupdated'] = 'サイト登録が更新されました。';
$string['siterelease'] = 'Moodleリリース';
$string['siterelease_help'] = 'このサイトのMoodleリリースナンバーです。';
$string['siteupdatedcron'] = '「 {$a} 」のサイト登録が更新されました。';
$string['siteupdatesend'] = 'ハブの登録更新を完了しました。';
$string['siteupdatesstart'] = 'ハブの登録更新を開始します ...';
$string['siteurl'] = 'サイトURI';
$string['siteurl_help'] = 'URIはこのサイトのアドレスです。プライバシー設定にてユーザのサイトアドレス閲覧を許可している場合、このURIが使用されます。';
$string['siteversion'] = 'Moodleバージョン';
$string['siteversion_help'] = 'このサイトのMoodleバージョン';
$string['specifichub'] = '特定ハブ';
$string['specifichubregistrationdetail'] = 'あなたのサイトを他のコミュニティハブに登録することもできます。';
$string['statistics'] = '統計プライバシー';
$string['status'] = 'ハブ一覧';
$string['statuspublished'] = '掲載済み';
$string['statusunpublished'] = '未掲載';
$string['subject'] = '学習テーマ';
$string['subject_help'] = 'コースがカバーする学習領域を選択してください。';
$string['tags'] = 'タグ';
$string['tags_help'] = 'タグにより、あなたのコースをカテゴリ別けして探しやすくします。シンプルで意味のある言葉を使用してください。また、複数のタグはカンマで区切ってください。例: 数学, 代数学, 幾何学';
$string['trustme'] = '信頼する';
$string['type'] = '広告/共有';
$string['unknownstatus'] = '不明';
$string['unlistedurl'] = '未掲載ハブURI';
$string['unprioritise'] = '優先解除';
$string['unpublish'] = '公開停止';
$string['unpublishalladvertisedcourses'] = '現在ハブに公開されているすべてのコースを削除する';
$string['unpublishalluploadedcourses'] = 'ハブにアップロードされているすべてのコースを削除する';
$string['unpublishconfirmation'] = '	
本当にコース「 {$a->courseshortname} 」をハブ「 {$a->hubname} 」から削除してもよろしいですか?';
$string['unpublishcourse'] = '{$a} を公開停止する';
$string['unregister'] = '登録解除';
$string['unregisterconfirmation'] = 'あなたはハブ {$a} からこのサイトを登録解除しようとしています。登録解除した場合、あなたがハブに残したコースを管理できないようになります。本当に登録解除してもよろしいですか?';
$string['unregisterfrom'] = '{$a} から登録解除する';
$string['unregistrationerror'] = 'ハブからのサイト登録解除中にエラーが発生しました: {$a}';
$string['untrustme'] = '未信頼';
$string['update'] = '更新';
$string['updatesite'] = '{$a} の登録を更新する';
$string['updatestatus'] = 'チェックする';
$string['uploaded'] = 'アップロード';
$string['url'] = 'ハブURI';
$string['urlalreadyregistered'] = 'あなたのサイトはすでにこのハブに登録されているようです。これは何らかの問題が生じたことを意味します。再度登録できるよう、ハブ管理者にあなたの登録解除を申請してください。';
$string['usersnumber'] = 'ユーザ数 ({$a})';
$string['warning'] = '警告';
$string['wrongtoken'] = '不明な理由により登録に失敗しました (ネットワーク?)。再度お試しください。';
$string['wrongurlformat'] = '正しくないURIフォーマット';
$string['xmlrpcdisabledcommunity'] = 'サーバでXML-RPC拡張モジュールが有効にされていません。あなたはコースを検索およびダウンロードすることができません。';
$string['xmlrpcdisabledpublish'] = 'サーバでXML-RPC拡張モジュールが有効にされていません。あなたはコースを公開または公開済みコースを管理することができません。';
$string['xmlrpcdisabledregistration'] = 'サーバでXML-RPC拡張モジュールが有効にされていません。有効にするまで、あなたは登録解除またはあなたの登録を更新することができません。';
