<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'it', branch 'MOODLE_20_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptederror'] = 'Errore accettato';
$string['accessnoticesheader'] = 'Puoi visualizzare l\'anteprima del quiz, tuttavia se esiste alemno un tentativo reale, non sarà possibile in quanto:';
$string['action'] = 'Azione';
$string['adaptive'] = 'Modo adattivo';
$string['adaptive_help'] = 'L\'impostazione consente di rispondere più volte alla stessa domanda all\'interno dello stesso tentativo. Se uno studente sbaglia la risposta, potrà rispondere nuovamente ma potrà subire una penalizzazione se l\'impostazione Penalità è attiva.';
$string['addaquestion'] = 'Aggiungi una domanda...';
$string['addarandomquestion'] = 'Aggiungi una domanda casuale...';
$string['addarandomquestion_help'] = 'Le domande casuale sono prese casualmente dalla categoria indicata. Studenti diversi e tentativi diversi dello stesso studente visualizzeranno domande diverse.';
$string['addcategory'] = 'Aggiungi categoria';
$string['adddescriptionlabel'] = 'Aggiungi descrizione/commento';
$string['addingcalculated'] = 'Creazione domanda con Calcolo';
$string['addingdescription'] = 'Creazione domanda Commento';
$string['addingessay'] = 'Creazione domanda con Risposta a Testo libero';
$string['addingmatch'] = 'Creazione domanda a Corrispondenza';
$string['addingmultianswer'] = 'Creazione domanda a Risposte inglobate (Cloze)';
$string['addingmultichoice'] = 'Creazione domanda a Risposta multipla';
$string['addingnumerical'] = 'Creazione domanda Numerica';
$string['addingquestion'] = 'Creazione domanda';
$string['addingquestions'] = 'Questa parte della pagina ti permette di gestire il tuo deposito delle domande. Le domande vengono salvate in categorie per aiutarti a mantenerle organizzate e possono essere utilizzate in qualsiasi quiz del tuo corso o in altri corsi, se decidi di pubblicarle.<br /><br />Dopo aver selezionato o creato una categoria di domande potrai creare o modificare le domande. Puoi selezionare un qualsiasi numero di domande e aggiungerle al quiz nell\'altra parte della pagina.';
$string['addingrandom'] = 'Creazione domanda casuale';
$string['addingrandomsamatch'] = 'Creazione domanda con Corrispondenze a Risposte brevi casuali';
$string['addingshortanswer'] = 'Creazione domanda a Risposta breve';
$string['addingtruefalse'] = 'Creazione domanda Vero/falso';
$string['addmoreoverallfeedbacks'] = 'Aggiungi altri {no} campi per feedback';
$string['addnewgroupoverride'] = 'Aggiungi personalizzazione di gruppo';
$string['addnewpagesafterselected'] = 'Aggiungi nuove pagine dopo le domande selezionate';
$string['addnewquestionsqbank'] = 'Aggiungi domande alla categoria {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Aggiungi personalizzazione individuale';
$string['addpagehere'] = 'Aggiungi pagina';
$string['addquestion'] = 'Aggiungi domanda';
$string['addquestions'] = 'Aggiungi domande';
$string['addquestionstoquiz'] = 'Aggiungi domande al quiz attuale';
$string['addrandom'] = 'Aggiungi {$a} domande casuali';
$string['addrandom1'] = '<< Aggiungi';
$string['addrandom2'] = 'domande casuali';
$string['addrandomfromcategory'] = 'Aggiungi domande casuali dalla categoria:';
$string['addrandomquestion'] = 'Aggiungi domanda casuale';
$string['addrandomquestiontoquiz'] = 'Aggiungi domanda casuale al quiz {$a}';
$string['addselectedtoquiz'] = 'Aggiungi selezione al quiz';
$string['addtoquiz'] = 'Aggiungi al quiz';
$string['affectedstudents'] = '{$a} considerati';
$string['aftereachquestion'] = 'ogni domanda';
$string['afternquestions'] = 'ogni {$a} domande';
$string['age'] = 'età';
$string['aiken'] = 'Formato Aiken';
$string['allattempts'] = 'Tutti i tentativi';
$string['allinone'] = 'Illimitate';
$string['allowreview'] = 'Autorizza revisione';
$string['alreadysubmitted'] = 'È probabile che tu abbia già inviato questo tentativo';
$string['alternativeunits'] = 'Unità alternative';
$string['alwaysavailable'] = 'Sempre disponibile';
$string['analysisoptions'] = 'Opzioni di analisi';
$string['analysistitle'] = 'Tabella per l\'analisi degli elementi';
$string['answer'] = 'Risposta';
$string['answered'] = 'Risposta';
$string['answerhowmany'] = 'Una o più risposte?';
$string['answers'] = 'Risposte';
$string['answersingleno'] = 'Risposte multiple permesse';
$string['answersingleyes'] = 'Una sola risposta';
$string['answerswithacceptederrormarginmustbenumeric'] = 'Le risposte con errore accettato devono essere numeriche';
$string['answertoolong'] = 'Risposta troppo lunga dopo la linea {$a} (255 caratteri max)';
$string['aon'] = 'Formato AON';
$string['areyousureremoveselected'] = 'Confermi la rimozione delle domande selezionate?';
$string['asshownoneditscreen'] = 'Come mostrato sulla pagina di modifica';
$string['attempt'] = 'Tentativo {$a}';
$string['attemptalreadyclosed'] = 'Questo tentativo è già stato completato.';
$string['attemptclosed'] = 'Il tentativo non è stato ancora chiuso';
$string['attemptduration'] = 'Tempo impiegato';
$string['attemptedon'] = 'Tentativo del';
$string['attempterror'] = 'Non puoi tentare questo quiz adesso in quanto: {$a}';
$string['attemptfirst'] = 'Primo tentativo';
$string['attemptincomplete'] = 'Il tentativo (di {$a}) non è stato ancora completato.';
$string['attemptlast'] = 'Ultimo tentativo';
$string['attemptnumber'] = 'Tentativo';
$string['attemptquiznow'] = 'Prova adesso a rispondere al quiz';
$string['attempts'] = 'Tentativi';
$string['attemptsallowed'] = 'Tentativi permessi';
$string['attemptsallowedn'] = 'Tentativi permessi: {$a}';
$string['attemptsdeleted'] = 'Tentativi eliminati';
$string['attemptselection'] = 'Scegli quali tentativi analizzare:';
$string['attemptsexist'] = 'Non puoi più aggiungere o eliminare domande.';
$string['attemptsnum'] = 'Tentativi: {$a}';
$string['attemptsnumthisgroup'] = 'Tentativi: {$a->total} ({$a->group} da questo gruppo)';
$string['attemptsnumyourgroups'] = 'Tentativi: {$a->total} ({$a->group} dai tuoi gruppi)';
$string['attemptsonly'] = 'Mostrare solo gli studenti con tentativi';
$string['attemptsunlimited'] = 'Tentativi illimitati';
$string['back'] = 'Torna all\'anteprima della domanda';
$string['backtoquestionlist'] = 'Torna all\'elenco delle domande';
$string['backtoquiz'] = 'Torna alla modifica del quiz';
$string['basicideasofquiz'] = 'Le basi per costruire un quiz';
$string['bestgrade'] = 'Voto migliore';
$string['blackboard'] = 'Blackboard';
$string['blackboard_six'] = 'Blackboard V6+';
$string['bothattempts'] = 'Visualizza gli studenti con e senza tentativi';
$string['braceerror'] = 'Non è stato possibile  trovare {...} nelle risposte';
$string['browsersecurity'] = 'Livello sicurezza browser';
$string['browsersecurity_help'] = 'Impostando "Pop-up a schermo intero con sicurezza Javascript":

* il quiz si avvierà solo se il browser ha JavaScript abilitato
* il quiz sarà visualizzato a schermo intero in una finestra pop-up senza interfaccia di navigazione che coprirà tutte le finestre sottostanti
* gli studenti per quanto possibile non potranno usare funzioni come il copia e incolla.';
$string['calculated'] = 'con Calcolo';
$string['calculatedquestion'] = 'Domanda con Calcolo non supportata alla linea {$a}. La domanda sarà ignorata.';
$string['cannotcreatepath'] = 'Non è possibile creare il percorso ({$a})';
$string['cannoteditafterattempts'] = 'Non puoi aggiungere o eliminare domande perché esistono tentativi già svolti. ({$a})';
$string['cannotfindprevattempt'] = 'Non è possibile trovare il tentativo da cui ricominciare.';
$string['cannotfindquestionregard'] = 'Errore nella lettura delle domande da rivalutare!';
$string['cannotinsert'] = 'Non è possibile inserire la domanda';
$string['cannotinsertrandomquestion'] = 'Non è stato possibile aggiungere una nuova domanda casuale!';
$string['cannotloadquestion'] = 'Non è stato possibile caricare le opzioni della domanda';
$string['cannotloadtypeinfo'] = 'Impossibile caricare le informazioni specifiche per il tipo di domanda';
$string['cannotopen'] = 'Non è possibile aprire il file da esportare ({$a})';
$string['cannotread'] = 'Non è possibile leggere il file da importare (o il file è vuoto)';
$string['cannotrestore'] = 'Non è stato possibile ripristinare la sessione delle domande';
$string['cannotreviewopen'] = 'Non puoi rivedere il tentativo poiché ancora aperto.';
$string['cannotsavelayout'] = 'Non è stato possibile salvare l\'impaginazione';
$string['cannotsavenumberofquestion'] = 'Non è stato possibile salvare il numero di domande per pagina';
$string['cannotsavequestion'] = 'Non è possibile salvare l\'elenco delle domande';
$string['cannotsetgrade'] = 'Non è possibile impostare un  nuovo voto massimo per il quiz';
$string['cannotsetsumgrades'] = 'Non è stato possibile impostare la somma dei voti';
$string['cannotwrite'] = 'Non è possibile scrivere il file da esportare ({$a})';
$string['caseno'] = 'No, maiuscolo/minuscolo è irrilevante';
$string['casesensitive'] = 'Rilevanza maiuscolo/minuscolo';
$string['caseyes'] = 'Si, maiuscolo/minuscolo è rilevante';
$string['categories'] = 'Categorie';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'La categoria \'{$a}\' è stata aggiunta';
$string['categorydeleted'] = 'La categoria \'{$a}\' è stata eliminata';
$string['categoryinfo'] = 'Descrizione';
$string['categorymove'] = 'La categoria \'{$a->name}\' contiene {$a->count} domande (alcune possono essere domande vecchie, nascoste, ancora in uso in qualche quiz esistente).<br/>Scegli un\'altra categoria per trasferirle in essa.';
$string['categorymoveto'] = 'Sposta in questa categoria';
$string['categorynamecantbeblank'] = 'Il nome della categoria non può essere vuoto';
$string['categorynoedit'] = 'Non hai il privilegio  di modificare la categoria \'{$a}\'.';
$string['categoryupdated'] = 'La categoria è stata modificata con successo';
$string['changessaved'] = 'Le modifiche alle valutazione sono state salvate';
$string['changessavedwitherrors'] = 'Si sono verificati errori durante il salvataggio delle valutazioni aggiornate';
$string['checkanswer'] = 'Controllo';
$string['choice'] = 'Scelta';
$string['choices'] = 'Scelte disponibili';
$string['choosefile'] = 'Scegli un file';
$string['close'] = 'Chiudi finestra';
$string['closebeforeopen'] = 'Non è stato possibile aggiornare il quiz. Hai specificato una data di chiusura antecedente a quella di apertura.';
$string['closed'] = 'Chiuso';
$string['closepreview'] = 'Chiudi anteprima';
$string['closereview'] = 'Chiudi revisione';
$string['comment'] = 'Commento';
$string['commentorgrade'] = 'Commenta o rivaluta';
$string['comments'] = 'Commenti';
$string['completedon'] = 'Terminato';
$string['configadaptive'] = 'Impostando a Si, lo studente avrà la possibilità di rispondere più volte a una domanda anche all\'interno dello stesso tentativo di risposta al quiz.';
$string['configattemptsallowed'] = 'Limitazione del numero di tentativi di risposta al quiz consentiti.';
$string['configdecimaldigits'] = 'Numero di cifre decimali da mostrare nelle valutazioni o nei punteggi degli studenti.';
$string['configdecimalplaces'] = 'Numero di cifre decimali da mostrare nelle valutazioni o nei punteggi dei quiz.';
$string['configdecimalplacesquestion'] = 'Numero di cifre decimali da mostrare nelle valutazioni o nei punteggi delle domande individuali.';
$string['configdelay1'] = 'Dopo il primo tentativo, lo studente dovrà aspettare per il tempo impostato prima di ritentare il quiz';
$string['configdelay1st2nd'] = 'Dopo il primo tentativo, lo studente dovrà aspettare per il tempo impostato prima di ritentare il quiz';
$string['configdelay2'] = 'Lo studente dovrà aspettare per  tempo impostato prima di ritentare il quiz per la terza volta o per le volte successive.';
$string['configdelaylater'] = 'Lo studente dovrà aspettare per  tempo impostato prima di ritentare il quiz per la terza volta o per le volte successive.';
$string['configeachattemptbuildsonthelast'] = 'Permettendo tentativi multipli  ogni nuovo tentativo conterrà i risultati del tentativo precedente.';
$string['configgrademethod'] = 'La strategia di valutazione da usare per calcolare il voto finale se il quiz permette più tentativi.';
$string['configintro'] = 'I valori impostati sotto saranno i valori di default per o nuovi quiz. E\' anche possibile stabilire quali impostazioni siano da considerarsi "avanzate".';
$string['configmaximumgrade'] = 'Il voto di default rispetto al quale sarà rapportato il voto del quiz.';
$string['confignewpageevery'] = 'Quando si aggiungono domande a un quiz, in base a questa impostazione saranno inseriti automaticamente dei salti di pagina .';
$string['configpenaltyscheme'] = 'Penalità da sottrarre per ogni risposta errata nella modalità adattiva.';
$string['configpopup'] = 'Obbliga lo svolgimento del quiz in una finestra popup ed usa JavaScript per limitare le azioni degli utenti.';
$string['configrequirepassword'] = 'Gli studenti devono inserire questa password per accedere all\'esecuzione del quiz.';
$string['configrequiresubnet'] = 'Gli studenti possono rispondere al quiz solo da questi computer.';
$string['configreviewoptions'] = 'Queste opzioni controllano quali informazioni gli utenti possono vedere quando esaminano i tentativi effettuati o i riepiloghi dei quiz.';
$string['configshowblocks'] = 'Consento di visualizzare i blocchi durante lo svolgimento del quiz.';
$string['configshowuserpicture'] = 'Visualizza l\'immagine dell\'utente durante i tentativi di risposta.';
$string['configshufflequestions'] = 'Per ogni tentativo l\'ordine di presentazione delle domande sarà variato in modo casuale..';
$string['configshufflewithin'] = 'L\'impostazione permette di alterare casualmente per  ogni tentativo l\'ordine delle possibili risposte , sempre che la corrispondente opzione sia abilitata nella configurazione delle domande.';
$string['configtimelimit'] = 'Tempo massimo di default (espresso minuti) per rispondere ai quiz. 0 significa senza tempo massimo.';
$string['configtimelimitsec'] = 'Tempo massimo di default, espresso in  secondi, per rispondere ai quiz. 0 significa nessun tempo massimo.';
$string['configurerandomquestion'] = 'Configura domanda';
$string['confirmclose'] = 'Stai per completare questo tentativo. Una volta chiuso non potrai più modificare le tue risposte.';
$string['confirmserverdelete'] = 'Sei sicuro di voler rimuovere il server <b>{$a}</b> dalla lista?';
$string['confirmstartattemptlimit'] = 'Per questo quiz sono previsti {$a} tentativi. L\'accesso al quiz sarà considerato come un tentativo. Vuoi procedere?';
$string['confirmstartattempttimelimit'] = 'Il quiz ha un tempo massimo di svolgimento e consente un massimo di {$a} tentativi. L\'accesso al quiz sarà contato come un tentativo. Vuoi procedere?';
$string['confirmstarttimelimit'] = 'Il Quiz ha un tempo massimo di svolgimento. Sei sicuro di voler iniziare?';
$string['containercategorycreated'] = 'Questa categoria è stata creata per contenere tutte le categorie originali spostate a livello di sito a causa di quanto sotto specificato.';
$string['continueattemptquiz'] = 'Riprendi ultimo tentativo';
$string['continuepreview'] = 'Continua l\'ultima anteprima';
$string['copyingfrom'] = 'Creazione di una copia della domanda \'{$a}\'';
$string['copyingquestion'] = 'Copia di una domanda';
$string['correct'] = 'Giusto';
$string['correctanswer'] = 'Risposta esatta';
$string['correctanswerformula'] = 'Formula della risposta esatta';
$string['correctansweris'] = 'Risposta esatta: {$a}';
$string['correctanswerlength'] = 'Cifre significative';
$string['correctanswers'] = 'Risposte esatte';
$string['correctanswershows'] = 'La risposta corretta avrà';
$string['corrresp'] = 'Risposta corretta';
$string['countdown'] = 'Conto alla rovescia';
$string['countdownfinished'] = 'Il quiz è terminato, devi inviare le tue risposte ora.';
$string['countdowntenminutes'] = 'Il quiz terminerà  tra dieci minuti';
$string['coursetestmanager'] = 'Formato Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Crea una categoria e aggiungi una domanda casuale';
$string['createfirst'] = 'Devi prima creare qualche domanda a risposta-breve.';
$string['createmultiple'] = 'Aggiungi al quiz molte domande casuali';
$string['createnewquestion'] = 'Crea una nuova domanda';
$string['createquestionandadd'] = 'Crea una nuova domanda ed aggiungila al quiz.';
$string['custom'] = 'Formato personalizzato';
$string['dataitemneed'] = 'E\' necessario aggiungere almeno un insieme di elementi per ottenere una domanda valida';
$string['datasetdefinitions'] = 'Definizioni dei dataset riusabili per la categoria {$a}';
$string['datasetnumber'] = 'Numero';
$string['daysavailable'] = 'Giorni disponibili';
$string['decimaldigits'] = 'Cifre decimali nei punteggi';
$string['decimalformat'] = 'decimali';
$string['decimalplaces'] = 'Cifre decimali nei punteggi';
$string['decimalplaces_help'] = 'L\'impostazione stabilisce il numero di cifre decimali da visualizzare nelle valutazioni. L\'impostazione influenza  solamente la visualizzazione dei voti, non influenza la precisione dei calcoli.';
$string['decimalplacesquestion'] = 'Cifre decimali nei punteggi delle domande';
$string['decimalplacesquestion_help'] = 'Le cifre decimali  da usare per visualizzare i punteggi delle singole domande.';
$string['decimalpoints'] = 'Cifre decimali';
$string['decimals'] = 'con {$a}';
$string['default'] = 'Default';
$string['defaultgrade'] = 'Punteggio di default della domanda';
$string['defaultinfo'] = 'La categoria di default per le domande.';
$string['delay1'] = 'Ritardo tra primo e secondo tentativo';
$string['delay1st2nd'] = 'Obbligo attesa tra 1mo e 2ndo tentativo';
$string['delay1st2nd_help'] = 'Dopo il primo tentativo, lo studente dovrà aspettare per il tempo impostato prima di ritentare il quiz';
$string['delay2'] = 'Ritardo tra i successivi tentativi';
$string['delaylater'] = 'Obbligo attesa tra i successivi tentativi';
$string['delaylater_help'] = 'Lo studente dovrà aspettare per  tempo impostato prima di ritentare il quiz per la terza volta o per le volte successive.';
$string['deleteattemptcheck'] = 'Sei sicuro di voler cancellare questi tentativi?';
$string['deletequestioncheck'] = 'Sei sicuro di voler cancellare \'{$a}\'?';
$string['deletequestionscheck'] = 'Sei sicuro di voler cancellare le seguenti domande? <div>{$a}</div>';
$string['deleteselected'] = 'Elimina selezionati';
$string['deletingquestionattempts'] = 'Cancellazione tentativi di risposta';
$string['description'] = 'Commento';
$string['disabled'] = 'Disabilitato';
$string['discrimination'] = 'Indice di discriminazione';
$string['displayoptions'] = 'Opzioni';
$string['download'] = 'Click per il download del file della categoria esportata';
$string['downloadextra'] = '(il file è anche salvato nei files del corso nella cartella /backupdata/quiz)';
$string['duplicateresponse'] = 'Questo invio è stato ignorato perché hai già dato una risposta equivalente.';
$string['eachattemptbuildsonthelast'] = 'Ogni tentativo parte dall\'ultimo';
$string['eachattemptbuildsonthelast_help'] = 'Se sono permessi tentativi multipli e questa impostazione è abilitata,  ogni nuovo tentativo conterrà i risultati del tentativo precedente. In questo modo sarà possibile completare un quiz tentandolo più volte.';
$string['editcategories'] = 'Modifica categorie';
$string['editcategory'] = 'Modifica categoria';
$string['editcatquestions'] = 'Modifica le domande della categoria';
$string['editingcalculated'] = 'Modifica domanda Calcolata';
$string['editingdescription'] = 'Modifica Commento';
$string['editingessay'] = 'Modifica domanda con risposta a Testo libero';
$string['editingmatch'] = 'Modifica domanda a corrispondenza';
$string['editingmultianswer'] = 'Modifica Risposte Inglobate (Cloze)';
$string['editingmultichoice'] = 'Modifica domanda a risposta multipla';
$string['editingnumerical'] = 'Modifica domanda numerica';
$string['editingquestion'] = 'Modifica domanda';
$string['editingquiz'] = 'Modifica quiz';
$string['editingquiz_help'] = 'I concetti da tenere in considerazione per creare un quiz sono:

* Il quiz, che può presentare domande su una o più pagine
* Il deposito delle domande, dove sono memorizzate le domande suddivise in categorie
* Le domande casuali, per presentare domande diverse per ciascuno studente e per ciascun tentativo';
$string['editingrandom'] = 'Modifica domanda casuale';
$string['editingrandomsamatch'] = 'Modifica domanda a Risposta breve con corrispondenze';
$string['editingrqp'] = '{$a}: modifica una domanda';
$string['editingshortanswer'] = 'Modifica domanda a Risposta breve';
$string['editingtruefalse'] = 'Modifica domanda Vero/falso';
$string['editoverride'] = 'Modifica personalizzazione';
$string['editqcats'] = 'Modifica categorie di domande';
$string['editquestions'] = 'Modifica domande';
$string['editquiz'] = 'Modifica quiz';
$string['editquizquestions'] = 'Modifica le domande del quiz';
$string['emailconfirmbody'] = 'Gentile {$a->username},

grazie per aver inviato le tue risposte al quiz \'{$a->quizname}\' nel corso \'{$a->coursename}\' alle {$a->submissiontime}.
Questa email conferma che sono state ricevute correttamente.
Puoi accedere questo quiz all\'indirizzo {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Grazie per aver risposto al quiz \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Conferma invio relativa al quiz: {$a->quizname}';
$string['emailnotifybody'] = 'Gentile {$a->username},

{$a->studentname} ha completato il quiz
\'{$a->quizname}\' ({$a->quizurl})
nel corso \'{$a->coursename}\'
Le risposte possono essere visualizzate all\'indirizzo {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} ha completato {$a->quizname}';
$string['emailnotifysubject'] = '{$a->studentname} ha completato il quiz {$a->quizname}';
$string['empty'] = 'Vuoto';
$string['enabled'] = 'Abilitato';
$string['endtest'] = 'Termina test ...';
$string['erroraccessingreport'] = 'Non puoi accedere a questo report';
$string['errorinquestion'] = 'Errore nella domanda';
$string['errormissingquestion'] = 'Errore: Il sistema ha perso la domanda con id {$a}';
$string['errornotnumbers'] = 'Errore - le risposte devono essere numeriche';
$string['errorsdetected'] = '{$a} errore(i) trovati';
$string['errorunexpectedevent'] = 'Rilevato l\'inatteso codice evento {$a->event} per la domanda {$a->questionid} nel tentativo {$a->attemptid}.';
$string['essay'] = 'Risposta a Testo libero';
$string['essayquestions'] = 'Domande';
$string['event1'] = 'Auto-salvataggio';
$string['event2'] = 'Salvataggio';
$string['event3'] = 'Valutazione';
$string['event5'] = 'Validazione';
$string['event6'] = 'Chiudi e valuta';
$string['event7'] = 'Invia';
$string['event8'] = 'Chiudi';
$string['event9'] = 'Valutazione manuale';
$string['everynquestions'] = 'Ogni {$a} domande';
$string['everyquestion'] = 'Ogni domanda';
$string['everythingon'] = 'Tutto su';
$string['examview'] = 'Examview';
$string['export'] = 'Esporta';
$string['exportcategory'] = 'esporta categoria';
$string['exporterror'] = 'Si è verificato  un errore durante il processo di esportazione';
$string['exportingquestions'] = 'Le domande sono in esportazione';
$string['exportname'] = 'Nome del file';
$string['exportquestions'] = 'Esporta domande su file';
$string['extraattemptrestrictions'] = 'Ulteriori restrizioni sui tentativi';
$string['false'] = 'Falso';
$string['feedback'] = 'Replica';
$string['feedbackerrorboundaryformat'] = 'Le valutazioni di riferimento per il feedback devono essere una percentuale o un numero. Il valore immesso nella posizione {$a} non è valido.';
$string['feedbackerrorboundaryoutofrange'] = 'Le valutazioni di riferimento per il feedback devono essere tra 0% e 100%. Il valore immesso nella posizione {$a} è fuori dell\'intervallo.';
$string['feedbackerrorjunkinboundary'] = 'Devi definire le valutazioni di riferimento senza lasciare  vuoti.';
$string['feedbackerrorjunkinfeedback'] = 'Devi definire i feedback complessivi senza lasciare vuoti.';
$string['feedbackerrororder'] = 'Le valutazioni di riferimento devono essere in ordine decrescente. Il valore immesso nella posizione {$a} è fuori sequenza.';
$string['file'] = 'File';
$string['fileformat'] = 'Formato file';
$string['fillcorrect'] = 'Mostra risposte corrette';
$string['filloutnumericalanswer'] = 'Devi definire almeno una risposta e la relativa tolleranza. La prima risposta corrispondente a quella data sarà usata per determinare il punteggio e il feedback. Se l\'elenco termina con un feedback senza risposta, allora tale feedback sarà mostrato agli studenti la cui risposta non ha trovato corrispondenza con alcuna di quelle previste.';
$string['filloutoneanswer'] = 'Devi fornire almeno una risposta. Le risposte lasciate in bianco non saranno utilizzate. Puoi usare \'*\' per far corrispondere qualsiasi carattere. La prima risposta che corrisponde sarà utilizzata per determinare il punteggio ed il feedback.';
$string['filloutthreequestions'] = 'Devi fornire almeno tre domande con le corrispondenti risposte. Puoi fornire risposte errate aggiuntive inserendo una risposta senza domanda. Gli inserimenti senza domanda e senza risposta non saranno utilizzati.';
$string['fillouttwochoices'] = 'Devi fornire almeno due scelte. Le scelte lasciate in bianco non saranno utilizzate.';
$string['finishattemptdots'] = 'Completa il tentativo...';
$string['finishreview'] = 'Fine revisione';
$string['forceregeneration'] = 'Forza rigenerazione';
$string['formatnotfound'] = 'Formato di importazione/esportazione {$a} non trovato';
$string['formatnotimplemented'] = 'Questo formato non è stato correttamente implementato, si prega di inviare una segnalazione di bug';
$string['formulaerror'] = 'Errori nella formula!';
$string['fractionsaddwrong'] = 'I voti positivi che hai scelto non assommano al 100% ma al {$a}%.<br />Vuoi tornare indietro e correggere?';
$string['fractionsnomax'] = 'Una delle risposte deve essere 100%, perché sia<br />possibile una votazione piena per questa domanda.<br />Vuoi tornare indietro e correggere?';
$string['fromfile'] = 'da file';
$string['functiondisabledbysecuremode'] = 'La funzionalità è al momento disabilitata';
$string['functiontakesatleasttwo'] = 'La funzione {$a} deve avere come minimo due argomenti';
$string['functiontakesnoargs'] = 'La funzione {$a} non ha argomenti';
$string['functiontakesonearg'] = 'La funzione {$a} deve avere un solo argomento';
$string['functiontakesoneortwoargs'] = 'La funzione {$a} deve avere uno o due argomenti';
$string['functiontakestwoargs'] = 'La funzione {$a} deve avere esattamente due argomenti';
$string['generalfeedback'] = 'Feedback generale';
$string['generalfeedback_help'] = '<p>Il feedback generale alla domanda è un testo che viene mostrato allo studente dopo che ha risposto alla domanda stessa. Diversamente dal feedback (specifico), che dipende dal tipo di domanda e dalla specifica risposta data dallo studente, lo stesso generico testo viene mostrato a tutti gli studenti.</p>

<p>Si può controllare quando il feedback generale è mostrato usando i check-box relativi a "Gli studenti possono vedere:" nel form di modifica del quiz.</p>

<p>Il feedback generale può essere usato per dare agli studenti qualche informazione sulla conoscenza che la domanda voleva verificare o per dare agli stessi un link a ulteriori informazioni da leggere nel caso che non abbiano capito la domanda.</p>';
$string['generatevalue'] = 'Genera un nuovo valore tra';
$string['geometric'] = 'Geometrico';
$string['gift'] = 'GIFT';
$string['giftleftbraceerror'] = 'Non trova una {';
$string['giftmatchingformat'] = 'Le risposte alle domande corrispondenti sono formattate impropriamente';
$string['giftnonumericalanswers'] = 'Nessuna risposta trovata per domanda numerica';
$string['giftnovalidquestion'] = 'Non trovata alcuna domanda valida';
$string['giftqtypenotset'] = 'Tipo domanda non impostato';
$string['giftrightbraceerror'] = 'Non trova una }';
$string['grade'] = 'Valutazione';
$string['gradeall'] = 'Valuta tutto';
$string['gradeaverage'] = 'Voto medio';
$string['gradeboundary'] = 'Valutazione';
$string['gradeessays'] = 'Valuta i testi';
$string['gradehighest'] = 'Voto più alto';
$string['grademethod'] = 'Metodo di valutazione';
$string['grademethod_help'] = '<p>Quando sono permessi più tentativi di risposta, vi sono diversi modi di usare i voti intermedi per calcolare il voto finale di uno studente per il quiz.</p>

<h2>Voto più alto</h2>
<p>Il voto finale è il più alto (il migliore) di quelli ottenuti nei vari tentativi.</p>

<h2>Voto medio</h2>
<p>Il voto finale è la media aritmetica dei voti ottenuti nei vari tentativi.</p>

<h2>Primo tentativo</h2>
<p>Il voto finale è quello ottenuto al primo tentativo (gli altri tentativi sono ignorati).</p>

<h2>Ultimo tentativo</h2>
<p>Il voto finale è quello ottenuto all\'ultimo tentativo.</p>';
$string['gradesdeleted'] = 'Valutazioni quiz cancellate';
$string['gradesofar'] = '<b>{$a->method}: {$a->mygrade} / {$a->quizgrade}</b>.';
$string['gradingdetails'] = 'Valutazione di questo invio: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Tenendo conto delle penalità  precedenti, questo dà  <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Questo invio ha ricevuto una penalità  di {$a}.';
$string['gradingdetailszeropenalty'] = 'Non sei stato penalizzato per questo invio.';
$string['gradingmethod'] = 'Metodo di valutazione: {$a}';
$string['groupoverrides'] = 'Personalizzazioni di gruppo';
$string['groupsnone'] = 'In questo corso non ci sono gruppi';
$string['guestsno'] = 'Spiacente, gli ospiti non possono vedere o provare il quiz';
$string['hidebreaks'] = 'Nascondi salti pagina';
$string['hidereordertool'] = 'Nascondi numeri per ordinamento';
$string['history'] = 'Storico delle Risposte:';
$string['illegalformulasyntax'] = 'Sintassi della formula che inizia con \'{$a}\' illegale';
$string['imagedisplay'] = 'Immagine da mostrare';
$string['imagemissing'] = 'Immagine non disponibile alla linea {$a}. Il nome del file sarà ignorato';
$string['import'] = 'Importa';
$string['importcategory'] = 'importa categoria';
$string['importerror'] = 'Errore durante il processo di importazione';
$string['importerrorquestion'] = 'Errore nell\'importazione delle domande';
$string['importfilearea'] = 'Importazione da file già nei files del corso...';
$string['importfileupload'] = 'Caricamento del file da importare';
$string['importfromthisfile'] = 'Importazione da questo file';
$string['import_help'] = 'L\' opzione consente di importare domande da file.

Se il file di importazione contiene anche caratteri non-ASCII, sarà necessario utilizzare la codifica UTF-8. Quando generi i file di importazione delle domande, devi fare attenzione se usi applicativi MS Office in quanto tali applicativi usano delle codifiche particolari che non possono essere gestite correttamente.

I formati di importazione ed esportazione delle domande sono acquisiti da Moodle attraverso plugin, pertanto nel database di Moduli e Plugin potrebbero essere disponibili ulteriori formati.';
$string['importingquestions'] = 'Importazione di {$a} domande da file';
$string['importmax10error'] = 'C\'è un errore nella domanda. Non puoi avere più di dieci risposte';
$string['importmaxerror'] = 'C\'è un errore nella domanda. Ci sono troppe risposte.';
$string['importminerror'] = 'C\'è un errore nella domanda. Non ci sono abbastanza risposte per questo tipo di domanda';
$string['importparseerror'] = 'Trovati errori nell\'analisi del file di importazione. Nessuna domanda è stata importata. Per importare le domande \'buone\' provare di nuovo, impostando prima \'Stop in caso di errore\' a \'No\'';
$string['importquestions'] = 'Importa domande da file';
$string['inactiveoverridehelp'] = '* Gli studenti non appartengono al gruppo corretto oppure non hanno il ruolo giusto per partecipare al quiz';
$string['incorrect'] = 'Sbagliato';
$string['indivresp'] = 'Risposte dei singoli ad ogni elemento';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['introduction'] = 'Introduzione';
$string['invalidattemptid'] = 'Questo ID di tentativo non esiste';
$string['invalidcategory'] = 'ID categoria non valido';
$string['invalidnumericanswer'] = 'Una delle risposte introdotte non è costituita da un numero valido.';
$string['invalidnumerictolerance'] = 'Una delle tolleranze definite non è costituita da un numero valido.';
$string['invalidoverrideid'] = 'L\'id della personalizzazione non è valida';
$string['invalidquestionid'] = 'Id domanda non valido';
$string['invalidquizid'] = 'ID quiz non valido';
$string['invalidsource'] = 'Il sorgente non è accettato come valido.';
$string['invalidsourcetype'] = 'Tipo sorgente non valido.';
$string['invalidstateid'] = 'Id stato non valido';
$string['itemanal'] = 'Analisi delle risposte agli elementi';
$string['itemdefinition'] = 'Definizione';
$string['itemsource'] = 'Sorgente dell\'elemento';
$string['itemsourceformat'] = 'Formato del sorgente dell\'elemento';
$string['itemtypes'] = 'Tipi di domande remote';
$string['lastanswer'] = 'La tua ultima risposta è stata';
$string['layout'] = 'Disposizione';
$string['layoutasshown'] = 'Disposizione pagina come mostrato.';
$string['layoutasshownwithpages'] = 'Disposizione pagina come mostrato. <small>(Salto pagina automatico ogni {$a} domande.)</small>';
$string['layoutshuffledandpaged'] = 'Domande in sequenza casuale con {$a} domande per pagina';
$string['layoutshuffledsinglepage'] = 'Domande in sequenza casuale, tutte in una pagina';
$string['learnwise'] = 'Learnwise';
$string['link'] = 'Collegamento';
$string['listitems'] = 'Elenco degli elementi di questo quiz';
$string['literal'] = 'Letterale';
$string['loadingquestionsfailed'] = 'Caricamento domande fallito: {$a}';
$string['loguniform'] = 'cifre, da una distribuzione loguniform';
$string['makecopy'] = 'Salva come nuova domanda';
$string['managetypes'] = 'Gestisci i tipi di domanda e i servers';
$string['manualgrading'] = 'Valutazioni';
$string['mark'] = 'Invia';
$string['markall'] = 'Invia la pagina';
$string['marks'] = 'Punteggio';
$string['match'] = 'Corrispondenza';
$string['matchanswer'] = 'Risposta corrispondente';
$string['matchanswerno'] = 'Risposta corrispondente {$a}';
$string['matcherror'] = 'Le valutazioni non corrispondono alle opzioni di valutazione - domanda saltata';
$string['matchgrades'] = 'Valutazioni corrispondenti';
$string['matchgradeserror'] = 'Errore se valutazione non in elenco';
$string['matchgradesnearest'] = 'Valutazione più vicina se non in elenco';
$string['max'] = 'Massimo';
$string['messageprovider:confirmation'] = 'Conferma del tuo invio';
$string['messageprovider:submission'] = 'Notifiche di consegne quiz';
$string['min'] = 'Minimo';
$string['minutes'] = 'Minuti';
$string['missinganswer'] = 'Troppo pochi :RISPOSTA, :Sx, :Dx punti per la linea di domanda {$a}. Devi definire come minimo 2 possibili risposte';
$string['missingcorrectanswer'] = 'Deve essere specificata la risposta corretta';
$string['missingformula'] = 'Formula mancante';
$string['missingitemtypename'] = 'Nome mancante';
$string['missingname'] = 'Nome domanda mancante';
$string['missingquestion'] = 'Etichetta della domanda mancante dopo la linea {$a}';
$string['missingquestiontext'] = 'Testo della domanda mancante';
$string['missingword'] = 'Parola mancante';
$string['modulename'] = 'Quiz';
$string['modulename_help'] = 'Il quiz permette di creare questionari composti da vari tipi di domande: scelta multipla, vero/falso, corrispondenza, eccetera. Tutti i tentativi vengono registrati e uò scegliere se inviare un feedback e/o visualizzare le risposte corrette.';
$string['modulenameplural'] = 'Quiz';
$string['moveselectedonpage'] = 'Sposta le domande selezionate a pagina: {$a}';
$string['moveto'] = 'Sposta in >>';
$string['multianswer'] = 'Risposte Inglobate (Cloze)';
$string['multichoice'] = 'Risposta multipla';
$string['multipleanswers'] = 'Scegliere almeno una risposta.';
$string['multiplier'] = 'Moltiplicatore';
$string['name'] = 'Nome';
$string['navnojswarning'] = 'Attenzione: le risposte non vengono salvate usando i link. Utilizzate il pulsante Avanti in fondo alla pagina.';
$string['neverallononepage'] = 'Tutte le domande su una sola pagina';
$string['newattemptfail'] = 'Errore: Non è stato possibile avviare un nuovo tentativo del quiz';
$string['newpage'] = 'Salto pagina';
$string['newpageevery'] = 'Salto pagina';
$string['newpage_help'] = '<p>Per i quiz molto lunghi ha senso distribuire le domande su più pagine, limitando il numero delle stesse per ogni pagina. Aggiungendo domande a un quiz, verranno automaticamente aggiunti dei salti-pagina secondo l\'impostazione che si sceglie qui. Comunque i salti-pagina potranno successivamente essere spostati a mano, come si vuole, nella pagina di modifica del quiz.</p>';
$string['noanswers'] = 'Non è stata selezionata nessuna risposta!';
$string['noattempts'] = 'Nessun tentativo è stato fatto per questo quiz';
$string['noattemptstoshow'] = 'Non ci sono tentativi da mostrare';
$string['nocategory'] = 'Categoria errata o non specificata';
$string['noclose'] = 'Senza data di chiusura';
$string['nocommentsyet'] = 'Ancora nessun commento.';
$string['noconnection'] = 'Al momento non c\'è connessione con un web service che può elaborare questa domanda. Contatta il tuo amministratore di sistema';
$string['nodataset'] = 'niente - non è un metacarattere';
$string['nodatasubmitted'] = 'Non è stato inserito alcun dato.';
$string['noessayquestionsfound'] = 'Non trovata alcuna domanda valutata manualmente';
$string['nogradewarning'] = 'Questo quiz non è valutato, per cui non può essere impostato un feedback complessivo dipendente dalla valutazione.';
$string['nomatchinganswer'] = 'Devi specificare una risposta corrispondente alla domanda \'{$a}\'.';
$string['nominal'] = 'Nominale';
$string['nomoreattempts'] = 'Non sono permessi ulteriori tentativi';
$string['none'] = 'Nessuno';
$string['noopen'] = 'Senza data di apertura';
$string['nooverridedata'] = 'Devi personalizzare almeno una delle impostazioni del quiz';
$string['nopossibledatasets'] = 'Insieme dati non accettabile';
$string['noquestionintext'] = 'Il testo della domanda non contiene alcuna domanda inglobata';
$string['noquestions'] = 'Non sono state aggiunte ancora domande';
$string['noquestionsfound'] = 'Nessuna domanda trovata';
$string['noquestionsinfile'] = 'Non ci sono domande nel file da importare';
$string['noquestionsinquiz'] = 'Non ci sono domande in questo quiz.';
$string['noquestionsnotinuse'] = 'Questa domanda casuale non è in uso, poiché la sua categoria è vuota.';
$string['noquestionsonpage'] = 'Pagina vuota';
$string['noresponse'] = 'Nessuna risposta';
$string['noreview'] = 'Non hai il permesso di rivedere questo quiz';
$string['noreviewattempt'] = 'Non hai il privilegio di rivedere questo tentativo.';
$string['noreviewshort'] = 'Non permesso';
$string['noreviewuntil'] = 'Non hai il permesso di rivedere questo quiz fino a {$a}';
$string['noreviewuntilshort'] = 'Disponibile {$a}';
$string['noscript'] = 'I JavaScript devono essere abilitati per poter continuare!';
$string['notavailable'] = 'Spiacente, il quiz non è disponibile';
$string['notavailabletostudents'] = 'Nota: Attualmente questo quiz non è disponibile agli studenti';
$string['notenoughanswers'] = 'Questo tipo di domanda richiede come minimo {$a} risposte';
$string['notenoughsubquestions'] = 'Non sono state definite abbastanza sottodomande!<br />Vuoi tornare indietro e correggere questa domanda?';
$string['notimedependentitems'] = 'Elementi dipendenti dal tempo non sono attualmente supportati dal modulo quiz. Nel frattempo si può fissare un limite di tempo per l\'intero quiz. Preferisci scegliere un elemento differente (o usare lo stesso l\'elemento corrente)?';
$string['notyourattempt'] = 'Questo non è un tuo tentativo!';
$string['noview'] = 'L\'utente che ha fatto login non ha il permesso di vedere questo quiz';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} hanno eseguito {$a->attemptnum} tentativi';
$string['numattemptsmade'] = 'Effettuati {$a} tentativi su questo quiz';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerica';
$string['numquestionsx'] = 'Domande: {$a}';
$string['onlyteachersexport'] = 'Solo i docenti possono esportare domande';
$string['onlyteachersimport'] = 'Solo i docenti con diritto di modifica possono importare domande';
$string['open'] = 'Senza risposta';
$string['openclosedatesupdated'] = 'Date apertura e chiusura quiz aggiornate';
$string['optional'] = 'opzionale';
$string['orderandpaging'] = 'Ordinamento e impaginazione';
$string['orderandpaging_help'] = 'I numeri 10, 20, 30, ... a fianco di ciascuna domanda indicano l\'ordinamento delle domande. Gli incrementi di 10 consentono di lasciare spazi per inserire ulteriori domande.

Per inserire una interruzione di pagina dopo una determinata domanda, seleziona la casella accanto alla domanda e fai click sul pulsante "Aggiungi pagina dopo la domanda selezionata" .

Per riordinare le domande presenti su più pagine, dai click sul pulsante "Rimpagina" e scegli il numero di domande da far apparire su ciascuna pagina.';
$string['orderingquiz'] = 'Ordinamento e impaginazione';
$string['outof'] = '{$a->grade} su un massimo di {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} su un massimo di {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback complessivo';
$string['overallfeedback_help'] = 'Il feedback complessivo al quiz è un testo che viene mostrato allo studente dopo che ha risposto al quiz stesso. Il testo mostrato può dipendere dalla valutazione finale ottenuta in funzione dei limiti configurati (espressi come percentuale o come numero).';
$string['overdue'] = 'In ritardo';
$string['override'] = 'Personalizzazione';
$string['overridedeletegroupsure'] = 'Sei sicuro di eliminare la personalizzazione per il gruppo {$a}?';
$string['overridedeleteusersure'] = 'Sei sicuro di eliminare la personalizzazione per l\'utente {$a}?';
$string['overridegroup'] = 'Personalizzazione per il gruppo';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Personalizzazioni';
$string['overrideuser'] = 'Personalizzazione per l\'utente';
$string['overrideusereventname'] = '{$a->quiz} - Personalzizzazione';
$string['pagesize'] = 'Tentativi mostrati per pagina:';
$string['paragraphquestion'] = 'Domanda paragrafo non supportata alla linea {$a}. La domanda sarà  ignorata';
$string['parent'] = 'Categoria superiore';
$string['parentcategory'] = 'Categoria superiore';
$string['parsingquestions'] = 'Analisi domande da file di importazione.';
$string['partiallycorrect'] = 'Parzialmente corretto';
$string['passworderror'] = 'La password inserita non è corretta';
$string['penalty'] = 'Penalità';
$string['penaltyscheme'] = 'Penalità';
$string['penaltyscheme_help'] = 'In caso di risposta sbagliata verrà applicata una penalizzazione al punteggio della domanda. Il valore della penalizzazione si imposta nella configurazione della domanda. La penalizzazione si applica solo con il Modo adattivo.';
$string['percentcorrect'] = 'Percentuale corretta';
$string['pleaseclose'] = 'La tua richiesta è stata elaborata. Ora puoi chiudere questa finestra';
$string['pluginadministration'] = 'Gestione Quiz';
$string['pluginname'] = 'Quiz';
$string['popup'] = 'Mostra il quiz in una finestra \'sicura\'';
$string['popupblockerwarning'] = 'Questa sezione del test avviene in modo protetto, il che significa che devi eseguire il quiz in una finestra "sicura". Per favore, disattiva il blocco dei popup nel tuo browser. Grazie.';
$string['popupnotice'] = 'Gli studenti visualizzeranno questo quiz in una finestra "sicura"';
$string['popupwithjavascriptsupport'] = 'Pop-up a schermo intero con sicurezza JavaScript';
$string['preprocesserror'] = 'Si è verificato un errore durante la pre-elaborazione!';
$string['preview'] = 'Anteprima';
$string['previewquestion'] = 'Anteprima domanda';
$string['previewquiz'] = 'Anteprima {$a}';
$string['previewquiznow'] = 'Anteprima quiz';
$string['previous'] = 'Stato precedente';
$string['publish'] = 'Rendere pubblico';
$string['publishedit'] = 'Devi avere il permesso nel corso da pubblicare per aggiungere o modificare le domande in questa categoria';
$string['qname'] = 'nome';
$string['qti'] = 'Formato IMS QTI';
$string['qti_two'] = 'Formato IMS QTI 2.0';
$string['qtypename'] = 'tipo, nome';
$string['question'] = 'Domanda';
$string['questionbankcontents'] = 'Contenuti del Deposito domande';
$string['questionbankmanagement'] = 'Gestione Deposito domande';
$string['questionbehaviour'] = 'Comportamento';
$string['questioncats'] = 'Categorie di domande';
$string['questiondeleted'] = 'La domanda è stata cancellata. Contattare il docente';
$string['questioninuse'] = 'La domanda \'{$a->questionname}\' è attualmente usata in: <br />{$a->quiznames}<br />La domanda non sarà  cancellata da tali quiz ma solamente dalla categoria.';
$string['questionmissing'] = 'Mancano le domande per questa sessione';
$string['questionname'] = 'Nome della domanda';
$string['questionnametoolong'] = 'Nome domanda troppo lungo alla linea {$a} (255 caratteri max). Sarà  troncata.';
$string['questionno'] = 'Domanda {$a}';
$string['questionnotloaded'] = 'La domanda {$a} non può essere caricata dal database';
$string['questionorder'] = 'Ordinamento domande';
$string['questions'] = 'Domande';
$string['questionsinclhidden'] = 'Domande (incluse le nascoste)';
$string['questionsinthisquiz'] = 'Domande in questo quiz';
$string['questionsinuse'] = '(* Le domande evidenziate con un asterisco sono già  utilizzate da qualche quiz. Le domande non saranno cancellate da tali quiz ma solamente dalla categoria.)';
$string['questionsperpage'] = 'Domande per pagina';
$string['questionsperpageselected'] = 'E\' stato definito il numero di domande per pagina per cui l\'impaginazione è al momento bloccata. Come risultato, i controlli per l\'impaginazione sono stati disabilitati. Questo si può cambiare in {$a}.';
$string['questionsperpagex'] = 'Domande per pagina: {$a}';
$string['questiontext'] = 'Testo domanda';
$string['questiontextisempty'] = '[Testo della domanda mancante]';
$string['questiontype'] = 'Tipo domanda {$a}';
$string['questiontypesetupoptions'] = 'Opzioni di impostazione per i tipi domanda:';
$string['quiz:attempt'] = 'Svolgere quiz';
$string['quizavailable'] = 'Il quiz è disponibile fino a: {$a}';
$string['quizclose'] = 'Chiusura';
$string['quizclosed'] = 'Il quiz è stato chiuso il {$a}';
$string['quizcloses'] = 'Chiusura';
$string['quizcloseson'] = 'Questo quiz chiuderà alle {$a}';
$string['quiz:deleteattempts'] = 'Eliminare tentativi dei quiz';
$string['quiz:emailconfirmsubmission'] = 'Ricevere conferma via email all\'invio';
$string['quiz:emailnotifysubmission'] = 'Ricevere notifica via email degli invii';
$string['quiz:grade'] = 'Valutare i quiz manualmente';
$string['quiz:ignoretimelimits'] = 'Ignorare tempo massimo sui quiz';
$string['quizisclosed'] = 'Questo quiz è chiuso';
$string['quizisopen'] = 'Questo quiz è aperto';
$string['quizisopenwillclose'] = 'Quiz aperto (chiude il {$a})';
$string['quiz:manage'] = 'Gestire quiz';
$string['quiz:manageoverrides'] = 'Gestire personalizzazioni quiz';
$string['quiznavigation'] = 'Navigazione quiz';
$string['quiznotavailable'] = 'Il quiz non sarà disponibile fino a: {$a}';
$string['quizopen'] = 'Apertura';
$string['quizopened'] = 'Questo quiz è aperto.';
$string['quizopenedon'] = 'Questo quiz è aperto dal {$a}';
$string['quizopens'] = 'Quiz disponibile';
$string['quizopenwillclose'] = 'Questo quiz è aperto, sarà chiuso il {$a} alle';
$string['quizordernotrandom'] = 'Ordinamento del quiz non casuale';
$string['quizorderrandom'] = '* Ordinamento del quiz casuale';
$string['quiz:preview'] = 'Vedere anteprima quiz';
$string['quiz:regrade'] = 'Rivalutare i tentativi dei quiz';
$string['quiz:reviewmyattempts'] = 'Rivedere i propri tentativi';
$string['quizsettings'] = 'Impostazioni quiz';
$string['quiztimelimit'] = 'Limite di tempo: {$a}';
$string['quiz:view'] = 'Visualizzare informazioni sui quiz';
$string['quiz:viewreports'] = 'Visualizzare report sui quiz';
$string['quizwillopen'] = 'Questo quiz sarà aperto il {$a}';
$string['random'] = 'Domanda casuale';
$string['randomcreate'] = 'Crea Domande casuali';
$string['randomfromcategory'] = 'Domande casuali dalla categoria:';
$string['randomfromexistingcategory'] = 'Domanda random da una categoria esistente';
$string['randomnosubcat'] = 'Domande presenti in questa categoria, escluse le sotto categorie.';
$string['randomquestionusinganewcategory'] = 'Domanda random da una nuova categoria';
$string['randomsamatch'] = 'Corrispondenze a Risposte Brevi casuali';
$string['randomsamatchcreate'] = 'Crea domande con corrispondenze a Risposte Brevi casuali';
$string['randomsamatchintro'] = 'Per ognuna delle seguenti domande, seleziona la corrispondente risposta dal menu a tendina.';
$string['randomsamatchnumber'] = 'Numero di domande da selezionare';
$string['randomwithsubcat'] = 'Domande presenti in questa categoria, incluse le sotto categorie.';
$string['readytosend'] = 'Stai per inviare l\'intero quiz per la valutazione. Sei sicuro di voler continuare?';
$string['reattemptquiz'] = 'Ritenta il quiz';
$string['recentlyaddedquestion'] = 'Domanda aggiunta recentemente';
$string['recurse'] = 'Mostra anche le domande delle sotto-categorie';
$string['regrade'] = 'Rivaluta tutti i tentativi';
$string['regradecomplete'] = 'Tutti i tentativi sono stati rivalutati';
$string['regradecount'] = '{$a->changed} su {$a->attempt} valutazioni sono state cambiate';
$string['regradedisplayexplanation'] = 'I tentativi che cambiano durante la rivalutazione sono mostrati come link alla finestra di revisione della domanda';
$string['regradenotallowed'] = 'Non hai l\'autorizzazione di rivalutare questo quiz';
$string['regradingquestion'] = 'Rivalutazione "<b>{$a}</b>"';
$string['regradingquiz'] = 'Rivalutazione quiz "{$a}"';
$string['relative'] = 'Relativo';
$string['remove'] = 'Rimuovi';
$string['removeallquizattempts'] = 'Cancella tutti i tentativi di risposta al quiz';
$string['removeemptypage'] = 'Rimuovi pagina vuota';
$string['removeselected'] = 'Rimuovi selezionati';
$string['rename'] = 'Cambia il nome';
$string['renderingserverconnectfailed'] = 'Il server <b>{$a}</b> non è riuscito ad elaborare una richiesta RQP. Controlla la correttezza del URL.';
$string['reorderquestions'] = 'Riordina domande';
$string['reordertool'] = 'Mostra numeri per ordinamento';
$string['repaginate'] = 'Reimpagina con <b>{$a}</b> domande per pagina';
$string['repaginatecommand'] = 'Reimpagina';
$string['repaginatenow'] = 'Reimpagina ora';
$string['replace'] = 'Sostituisci';
$string['replacementoptions'] = 'Opzioni di sostituzione';
$string['report'] = 'Report';
$string['reportanalysis'] = 'Analisi risultati';
$string['reportfullstat'] = 'Statistiche dettagliate';
$string['reportmulti_percent'] = 'Percentuali multiple';
$string['reportmulti_q_x_student'] = 'Scelte studente multiple';
$string['reportmulti_resp'] = 'Risposte individuali';
$string['reportnotfound'] = 'Report sconosciuto (<b>{$a}</b>)';
$string['reportoverview'] = 'Riepilogo';
$string['reportregrade'] = 'Rivaluta tentativi';
$string['reportresponses'] = 'Risposte dettagliate';
$string['reports'] = 'Risultati';
$string['reportsimplestat'] = 'Statistiche semplici';
$string['requirepassword'] = 'Password d\'accesso';
$string['requirepassword_help'] = '<p>Questo parametro è opzionale</p>

<p>Specificando una password di acceso, i partecipanti dovranno inserirla prima di poter svolgere il quiz</p>';
$string['requirepasswordmessage'] = 'Per tentare questo quiz è necessario conoscere la password d\'accesso.';
$string['requiresafeexambrowser'] = 'Safe Exam Browser';
$string['requiresubnet'] = 'Indirizzi di rete abilitati';
$string['requiresubnet_help'] = '<p>Questo parametro è opzionale.</p>

<p>E\' possibile limitare l\'accesso a un quiz ai soli computer presenti su una particolare sotto rete di una LAN o di Internet, specificando una lista di indirizzi IP, parziali o completi, separati da virgole.</p>

<p>L\'impostazion è particolarmente utile per "proteggere" un quiz, ad esempio quando si vuole consentire l\'accesso al quiz solo alle persone presenti in un certa sala.</p>

<p>Esempio:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>E\' possibile usatr quattro tipi di sintassi (non possono essere usati nomi di dominio testuali come \'esempio.com\'):
<ol>
<li>Indirizzi IP completi, come <b>192.168.10.1</b> che abiliterà un solo computer (o un proxy).</li>
<li>Indirizzi IP parziali, come <b>192.168</b> che abiliteranno tutti i computer i cui IP iniziano con tali numeri.</li>
<li>Notazioni CIDR, come <b>231.54.211.0/20</b> che permetteranno di specificare dettagliatamente una sottorete.</li>
<li>Un range di indirizzi IP come <b>231.3.56.10-20</b>. Il range si applica all\'ultima parte dell\'indirizzo, per cui l\'esempio significa tutti gli indirizzi da 231.3.56.10 a 231.3.56.20.</li>
</ol>
</p>
<p>Gli spazi bianchi vengono ignorati.</p>';
$string['response'] = 'Risposta';
$string['responses'] = 'Commenti';
$string['results'] = 'Risultati';
$string['reuseifpossible'] = 'Riutilizza precedentemente rimossi';
$string['reverttodefaults'] = 'Torna ai default del quiz';
$string['review'] = 'Revisione';
$string['reviewafter'] = 'Permetti revisione dopo che il quiz è stato chiuso';
$string['reviewalways'] = 'Permetti revisione in qualunque momento';
$string['reviewattempt'] = 'Rivedi tentativo';
$string['reviewbefore'] = 'Permetti revisione durante l\'apertura del quiz';
$string['reviewclosed'] = 'dopo che il quiz è stato chiuso';
$string['reviewimmediately'] = 'subito dopo il tentativo';
$string['reviewnever'] = 'Non permettere mai la revisione';
$string['reviewofattempt'] = 'Revisione del tentativo {$a}';
$string['reviewofpreview'] = 'Revisione anteprima';
$string['reviewopen'] = 'dopo, mentre il quiz è ancora aperto';
$string['reviewoptions'] = 'Gli studenti possono rivedere';
$string['reviewoptionsheading'] = 'Opzioni di revisione';
$string['reviewoptionsheading_help'] = 'Queste opzioni controllano le informazioni che gli utenti potranno visualizzare dopo avere tentato il quiz.

"Subito dopo il tentativo"  significa entro i due minuti successivi al completamento del tentativo. "Dopo, mentre il quiz è ancora aperto" significa come il caso precedente ma entro la data di chiusura del quiz. "Dopo la chiusura del quiz" significa dopo la data di chiusura del quiz. Se il quiz non ha una data di chiusura, questa condizione non sarà mai soddisfatta.';
$string['reviewresponse'] = 'Revisione replica';
$string['reviewresponsetoq'] = 'Rivedi la risposta (domanda {$a})';
$string['reviewthisattempt'] = 'Rivedi le tue risposte a questo tentativo';
$string['rqp'] = 'Domanda remota';
$string['rqps'] = 'Domande remote';
$string['safebrowsererror'] = 'Il quiz è stato configurato per essere eseguito solamente utilizzando Safe Exam Browser. Non è possibile eseguirlo con un browser web standard.';
$string['safebrowsernotice'] = 'Il quiz è stato configurato affinché gli studenti possano eseguirlo solamente utilizzando Safe Exam Browser.';
$string['sameasoverall'] = 'Stesse del punteggio finale';
$string['save'] = 'Salva';
$string['saveandedit'] = 'Salva modifiche e aggiorna domande';
$string['saveattemptfailed'] = 'Errore nel salvataggio dell\'attuale tentativo di risposta al quiz.';
$string['savedfromdeletedcourse'] = 'Salvato dal corso cancellato "<b>{$a}</b>"';
$string['savegrades'] = 'Salva i voti';
$string['savemyanswers'] = 'Salva le mie risposte';
$string['savenosubmit'] = 'Salva senza inviare';
$string['saveoverrideandstay'] = 'Salva ed inserisci un\'altra personalizzazione';
$string['savequiz'] = 'Salva l\'intero quiz';
$string['score'] = 'Valutazione grezza';
$string['scores'] = 'Valutazioni';
$string['select'] = 'Seleziona';
$string['selectall'] = 'Seleziona tutto';
$string['selectcategory'] = 'Seleziona categoria';
$string['selectcategoryabove'] = 'Scegli una delle categorie sopra elencate';
$string['selectedattempts'] = 'Tentativi selezionati...';
$string['selectnone'] = 'Deseleziona tutto';
$string['selectquestiontype'] = '-- Scegli il tipo di domanda --';
$string['serveradded'] = 'Server aggiunto';
$string['serveridentifier'] = 'Identificatore';
$string['serverinfo'] = 'Informazione sul server';
$string['serverinuse'] = 'Il server che stai per cancellare è l\'ultimo server {$a} e ci sono domande che non funzioneranno più se cancelli questo server.';
$string['servers'] = 'Servers';
$string['serverurl'] = 'URL del Server';
$string['settingsoverrides'] = 'Annullamento impostazioni';
$string['shortanswer'] = 'Risposta breve';
$string['show'] = 'Mostra';
$string['showall'] = 'Mostra tutte le domande nella stessa pagina';
$string['showblocks'] = 'Visualizza i blocchi durante lo svolgimento del quiz';
$string['showblocks_help'] = 'Se impostato a si, i blocchi saranno visualizzati durante lo svolgimento del quiz.';
$string['showbreaks'] = 'Mostra salti pagina';
$string['showcategorycontents'] = 'Visualizza il contenuto della categoria {$a->arrow}';
$string['showcorrectanswer'] = 'Mostrare le risposte corrette nel feedback?';
$string['showdetailedmarks'] = 'Mostra punteggi dettagliati';
$string['showeachpage'] = 'Mostra una pagina alla volta';
$string['showfeedback'] = 'Mostrare il feedback dopo le risposte?';
$string['showhidden'] = 'Mostra anche le vecchie domande';
$string['showinsecurepopup'] = 'Finestra popup \'sicura\'';
$string['shownoattempts'] = 'Mostra studenti senza tentativi';
$string['shownoattemptsonly'] = 'Mostra solo gli studenti senza tentativi';
$string['showquestiontext'] = 'Mostra testo domanda nell\'elenco domande';
$string['showteacherattempts'] = 'Mostra i tentativi degli insegnanti';
$string['showuserpicture'] = 'Mostra immagini utente';
$string['showuserpicture_help'] = '<p>Se si abilita questa opzione, il nome dello studente e la sua immagine saranno mostrati durante l\'esecuzione del tentativo di risposta e sulla schermata di revisione.</p>

<p>Un esempio di quando può essere utile una cosa del genere è durante gli esami, per rendere più facile il controllo che un utente non sia entrato con il nome di un altro.</p>';
$string['shuffle'] = 'Ordine casuale';
$string['shuffleanswers'] = 'Risposte in ordine casuale';
$string['shuffledrandomly'] = 'In sequenza casuale';
$string['shufflequestions'] = 'Domande in ordine casuale';
$string['shufflequestionsselected'] = 'Le domande sono impostate in ordine casuale, per questo motivo il pulsante Riordina domande è disabilitato. Per modificare l\'impostazione, {$a}.';
$string['shufflewithin'] = 'Alternative in ordine casuale';
$string['shufflewithin_help'] = '<p>Se si abilita questa opzione, le possibili risposte alternative saranno casualmente alterate ad ogni tentativo di risposta al quiz da parte dello studente, ammesso che questa opzione sia abilitata anche nelle impostazioni delle domande.</p>

<p>Lo scopo è quello di rendere un po\' più difficile, agli studenti, copiare l\'uno dall\'altro.</p>

<p>Questa opzione si applica solamente alle sole domande che visualizzano più alternative di risposta, come le domande a scelta multipla e quelle che prevedono corrispondenze. Per le domande a scelta multipla l\'ordine delle risposte da scegliere è casuale quando questa impostazione è "SI". Per le domande a corrispondenza le risposte possibili sono sempre in ordine casuale e questa opzione stabilisce se in aggiunta sono in ordine casuale anche le coppie domanda-risposta.</p>

<p>Questa opzione non ha nulla a che fare con le Domande Casuali.</p>';
$string['significantfigures'] = 'con {$a}';
$string['significantfiguresformat'] = 'cifre significative';
$string['singleanswer'] = 'Scegliere una risposta.';
$string['sortage'] = 'Ordine temporale';
$string['sortalpha'] = 'Ordine alfabetico';
$string['sortquestionsbyx'] = 'Ordina domande per: {$a}';
$string['sortsubmit'] = 'Ordina domande';
$string['sorttypealpha'] = 'Ordine per tipo, nome';
$string['specificapathnotonquestion'] = 'Il percorso del file non è nella domanda specificata';
$string['specificquestionnotonquiz'] = 'La domanda specificata non è nel quiz specificato.';
$string['startagain'] = 'Ricomincia';
$string['startedon'] = 'Iniziato';
$string['statenotloaded'] = 'Lo stato della domanda {$a} non è stato caricato dal database';
$string['status'] = 'Stato';
$string['stoponerror'] = 'Stop in caso di errore';
$string['submitallandfinish'] = 'Invia tutto e termina';
$string['subneterror'] = 'Spiacente, questo quiz è impostato in modo da essere accessibile solo da certi indirizzi di rete. Attualmente i tuo computer non è abilitato all\'utilizzo di questo quiz.';
$string['subnetnotice'] = 'Questo quiz è impostato in modo da essere accessibile solo da certi indirizzi di rete. Il tuo computer non è su una sotto-rete abilitata. Comunque come insegnante puoi vedere l\'anteprima.';
$string['subnetwrong'] = 'Il quiz è accessibile solo da specifici computer, e questo non è nella lista di quelli abilitati.';
$string['substitutedby'] = 'sarà  sostituito da';
$string['summaryofattempt'] = 'Riepilogo tentativo';
$string['summaryofattempts'] = 'Riepilogo dei tuoi tentativi';
$string['temporaryblocked'] = 'Temporaneamente non è permesso ritentare il quiz.<br />Potrai tentare nuovamente il:';
$string['time'] = 'Ora';
$string['timecompleted'] = 'Completato';
$string['timedelay'] = 'Non è permesso accedere al quiz finché non sarà passato il tempo per poter accedere a un altro quiz';
$string['timeleft'] = 'Tempo rimasto';
$string['timelimit'] = 'Tempo massimo';
$string['timelimitexeeded'] = 'Spiacente! Il tempo per il quiz è scaduto!';
$string['timelimit_help'] = '<p>Per default, i quiz non hanno un tempo massimo per rispondere, per dare allo studente tutto il tempo necessario a completare il quiz stesso.</p>

<p>Se si specifica un tempo massimo, per assicurare che i quiz siano completati in questo intervallo di tempo, questo è quello che succede:</p>

<ul>
  <li>Il supporto Javascript nel browser è obbligatorio - questo permette al timer di lavorare correttamente</li>
  <li>E\' mostrata una finestrella con il timer che esegue un conto alla rovescia</li>
  <li>Quando il tempo scade, il quiz viene salvato automaticamente con qualunque risposta che è stata scritta fino a qual momento</li>
  <li>Se uno studente cerca di imbrogliare e fa passare più di 60 secondi oltre il tempo assegnato, il quiz è automaticamente valutato zero</li>
</ul>';
$string['timelimitmin'] = 'Tempo massimo (minuti)';
$string['timelimitsec'] = 'Tempo massimo (secondi)';
$string['timestr'] = '%H:%M:%S del %d/%m/%y';
$string['timesup'] = 'Tempo scaduto!';
$string['timetaken'] = 'Tempo impiegato';
$string['tofile'] = 'su file';
$string['tolerance'] = 'Tolleranza';
$string['tolerancetype'] = 'Tipo di tolleranza';
$string['toomanyrandom'] = 'Il numero di domande casuali richieste è maggiore di quello  delle domande contenute in questa categoria! ({$a})';
$string['top'] = 'Top';
$string['totalpointsx'] = 'Totale punti: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Totale di {$a} domande nella categoria.';
$string['true'] = 'Vero';
$string['truefalse'] = 'Vero/falso';
$string['truefalseimporterror'] = '<b>Attenzione</b>: La domanda Vero/Falso \'{$a->questiontext}\' potrebbe non essere stata importata correttamente. Non è chiaro se la risposta corretta è Vero o Falso. La domanda è stata importata assumendo che la risposta sia \'{$a->answer}\'. Se non è corretto, la domanda deve essere modificata.';
$string['type'] = 'Tipo';
$string['unfinished'] = 'aperto';
$string['ungraded'] = 'Non valutato';
$string['uniform'] = 'decimali, da una distribuzione uniforme';
$string['unit'] = 'Unità';
$string['unknowntype'] = 'Tipo di domanda non supportato alla linea {$a}. La domanda sarà ignorata';
$string['unsupportedformulafunction'] = 'La funzione {$a} non è supportata';
$string['unusedcategorydeleted'] = 'Questa categoria è stata soppressa poiché dopo l\'eliminazione del corso le domande in essa presenti non erano più utilizzate.';
$string['updatesettings'] = 'Aggiorna impostazioni quiz';
$string['upgradesure'] = '<div>In particolare il modulo quiz  eseguirà  cambiamenti significativi delle tabelle e l\'aggiornamento software non è stato ancora testato sufficientemente. prima di procedere, si raccomanda vivamente di eseguire il backup delle tabelle.</div>';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Questa categoria è stata spostata a livello di sito, perché, dopo la cancellazione del corso, le domande in essa contenute erano utilizzate da altri quiz esistenti nel server.';
$string['useroverrides'] = 'Personalizzazioni individuali';
$string['usersnone'] = 'Nessuno studente ha acceduto il quiz';
$string['validate'] = 'Convalida';
$string['viewallanswers'] = 'Vedi {$a} quiz completati';
$string['viewallreports'] = 'Vedi risultati per {$a} tentativi';
$string['warningmissingtype'] = '<b>Questa domanda è di un tipo ancora non installato sul Moodle che stai usando.<br />Per favore, avverti il tuo amministratore Moodle .</b>';
$string['warningsdetected'] = '{$a} avvertimenti rilevati';
$string['webct'] = 'WebCT';
$string['wheregrade'] = 'Dov\'è il mio voto';
$string['wildcard'] = 'Carattere jolly';
$string['windowclosing'] = 'Questa finestra si chiuderà tra breve.';
$string['withselected'] = 'Seleziona';
$string['withsummary'] = 'con Statistiche Riepilogative';
$string['wronggrade'] = 'Punteggio sbagliato (dopo la linea {$a}):';
$string['wronguse'] = 'Non puoi utilizzare la pagina in questo modo';
$string['xhtml'] = 'Formato XHTML';
$string['xml'] = 'Moodle XML';
$string['xmlimportnoname'] = 'Nome domanda mancante nel file xml';
$string['xmlimportnoquestion'] = 'Testo domanda mancante nel file xml';
$string['xmltypeunsupported'] = 'Il tipo domanda {$a} non è supportata dall\'import xml';
$string['youcannotwait'] = 'Il quiz chiude prima che tu possa iniziare un altro tentativo.';
$string['youmustwait'] = 'Devi aspettare prima di poter riprovare questo quiz. Potrai iniziare un altro tentativo dopo il {$a}.';
$string['youneedtoenrol'] = 'E\' necessaria l\'iscrizione al corso prima di potere eseguire il quiz';
$string['yourfinalgradeis'] = 'Il tuo voto finale per questo quiz è {$a}';
$string['zerosignificantfiguresnotallowed'] = 'La risposta giusta non può avere zero cifre significative!';
