<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'it', branch 'MOODLE_20_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Accesso negato';
$string['accounts'] = 'Profili';
$string['additionalhtml'] = 'HTML aggiuntivo';
$string['additionalhtml_desc'] = 'L\'impostazione consente di specificare codice HTML che comparirà su tutte le pagine. E\' possibile specificare codice HTML da inserire all\'interno del tag HEAD, all\'interno del corpo pagina dopo l\'apertura del tag BODY oppure subito prima della chiusura del tag BODY.<br />L\'uso di questa impostazione permette di aggiungere intestazioni o piè di pagina personalizzati su tutte le pagine, oppure aggiungere servizi quali Google Analytics in modo facile ed indipendente dal tema utilizzato.';
$string['additionalhtmlfooter'] = 'Prima della chiusura del tag BODY';
$string['additionalhtmlfooter_desc'] = 'Il codice HTML verrà aggiunto in tutte le pagine prima della chiusura del tag BODY.';
$string['additionalhtmlhead'] = 'All\'interno del tag HEAD';
$string['additionalhtmlhead_desc'] = 'Il codice HTML verrà aggiunto in tutte le pagine al termine del tag HEAD.';
$string['additionalhtml_heading'] = 'Il codice HTML da aggiungere in tutte le pagine.';
$string['additionalhtmltopofbody'] = 'All\'apertura del tag BODY';
$string['additionalhtmltopofbody_desc'] = 'Il codice HTML verrà aggiunto in tutte le pagine subito dopo l\'apertura del tag BODY.';
$string['adminseesall'] = 'Gli amministratori visualizzano qualsiasi evento';
$string['adminseesallevents'] = 'Gli amministratori visualizzano tutti gli eventi';
$string['adminseesownevents'] = 'Gli amministratori visualizzano solo i propri eventi';
$string['advancedfeatures'] = 'Funzionalità avanzate';
$string['allcountrycodes'] = 'Tutti i codici nazione';
$string['allowbeforeblock'] = 'L\'elenco degli indirizzi autorizzati sarà elaborato per primo';
$string['allowbeforeblockdesc'] = 'Per default l\'elenco degli IP bloccati verrà elaborato per primo. Abilitando questa opzione, sarà elaborato per primo l\'elenco degli IP autorizzati.';
$string['allowblockstodock'] = 'Consenti ai blocchi di usare il dock';
$string['allowcategorythemes'] = 'Consenti la scelta dei temi per le categorie';
$string['allowcoursethemes'] = 'Consenti la scelta dei temi per i corsi';
$string['allowdeletes'] = 'Consenti eliminazione utenti';
$string['allowediplist'] = 'Elenco degli IP autorizzati';
$string['allowemailaddresses'] = 'Domini di posta autorizzati';
$string['allowobjectembed'] = 'Consenti i tag EMBED e OBJECT';
$string['allowrenames'] = 'Consenti la modifica degli username';
$string['allowthemechangeonurl'] = 'Consenti il cambio del tema tramite URL';
$string['allowuserblockhiding'] = 'Consenti agli utenti di nascondere i blocchi';
$string['allowusermailcharset'] = 'Consenti agli utenti di scegliere il set di caratteri';
$string['allowuserswitchrolestheycantassign'] = 'Consenti agli utenti che non hanno il privilegio di attribuire ruoli di cambiare ruolo.';
$string['allowuserthemes'] = 'Consenti agli utenti di scegliere il tema';
$string['antivirus'] = 'Anti-Virus';
$string['appearance'] = 'Aspetto';
$string['aspellpath'] = 'Percorso per aspell';
$string['authentication'] = 'Autenticazione';
$string['authsettings'] = 'Gestione autenticazione';
$string['autolang'] = 'Rilevazione automatica della lingua';
$string['autologinguests'] = 'Login automatico per gli ospiti';
$string['availablelicenses'] = 'Licenze disponibili';
$string['availableto'] = 'Disponibile per';
$string['backgroundcolour'] = 'Colore trasparente';
$string['backups'] = 'Backup';
$string['badwordsconfig'] = 'Inserire l\'elenco personalizzato delle parole da censurare. Ciascuna parola deve essere separata dalle altre con una virgola.';
$string['badwordsdefault'] = 'In mancanza dell\'elenco personalizzato verrà utilizzato l\'elenco di default preso dal Language Pack.';
$string['badwordslist'] = 'Elenco personalizzato delle parole da censurare';
$string['blockediplist'] = 'Elenco degli IP bloccati';
$string['blockinstances'] = 'Istanze';
$string['blockmultiple'] = 'Multiplo';
$string['blockprotect'] = 'Proteggi dalla eliminazione';
$string['blockprotect_help'] = 'E\' possibile proteggere dall\'eliminazione dal contesto del sito determinate istanze di blocchi. Lo scopo è quello di evitare l\'eliminazione accidentale di quei blocchi difficili da ripristinare, come i blocco Navigazione ed il blocco Impostazioni.';
$string['blocksettings'] = 'Gestione blocchi';
$string['blockunprotect'] = 'Rimuovi protezione';
$string['bloglevel'] = 'Visibilità del Blog';
$string['bloglevelupgrade'] = 'Aggiornamento Visibilità del Blog';
$string['bloglevelupgradedescription'] = '<p>Il sito è stato da poco aggiornato a Moodle 2.0.</p>
<p>In Moodle 2.0 la visibilità dei Blog è stata semplificata, tuttavia il tuo sito sta ancora utilizzando le impostazioni di visibilità Blog precedenti.</p>
<p>Per conservare la visibilità dei blog per corso e per gruppo, devi lanciare lo script di aggiornamento che creerà un forum di tipo "blog" in tutti i corsi dove gli iscritti hanno inserito post di blog, copiandoci poi gli interventi. </p>
<p>I Blog verranno poi disattivati a livello di sito. Nessun intervento verrà eliminato durante l\'elaborazione dello script.</p>
<p>Puoi lanciare lo script  accedendo alla <a href="{$a->fixurl}">pagina di aggiornamento Blog</a>.</p>';
$string['bloglevelupgradeinfo'] = 'In Moodle 2.0 la visibilità dei Blog è stata semplificata, tuttavia il tuo sito sta ancora utilizzando le impostazioni di visibilità Blog precedenti. Per conservare la visibilità dei blog per corso e per gruppo, devi lanciare lo script di aggiornamento che creerà un forum di tipo "blog" in tutti i corsi dove gli iscritti hanno inserito post di blog, copiandoci poi gli interventi.I Blog verranno poi disattivati a livello di sito. Nessun intervento verrà eliminato durante l\'elaborazione dello script.';
$string['bloglevelupgradenotice'] = 'il tuo sito sta utilizzando impostazioni di visibilità Blog obsolete, si raccomanda di eseguire <a href="bloglevelupgrade.php">l\'aggiornamento della visibilità blog</a>.';
$string['bloglevelupgradeprogress'] = 'Stato avanzamento della conversione: analizzati {$a->userscount} utenti, convertiti {$a->blogcount} interventi.';
$string['bookmarkadded'] = 'Segnalibro aggiunto.';
$string['bookmarkalreadyexists'] = 'Questa pagina è già presente nei tuoi segnalibri.';
$string['bookmarkdeleted'] = 'Segnalibro eliminato.';
$string['bookmarkthispage'] = 'Aggiungi questa pagina nei tuoi segnalibri';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'La cache e la compressione dei Javascript velocizza notevolmente il caricamento delle pagine ed è fortemente consigliato per i siti in produzione. Gli sviluppatori potrebbero preferire di non l\'impostazione.';
$string['cachetext'] = 'Durata della cache del testo';
$string['cachetype'] = 'Tipo di cache';
$string['calendarexportsalt'] = 'Seme per l\'esportazione del calendario';
$string['calendarsettings'] = 'Calendario';
$string['calendar_weekend'] = 'Giorni del weekend';
$string['cannotdeletemissingqtype'] = 'Non è possibile eliminare il tipo di domanda \'mancante\', poiché è necessaria al sistema.';
$string['cannotdeletemodfilter'] = 'Non puoi disinstallare \'{$a->filter}\' in quanto fa parte del modulo \'{$a->module}\'.';
$string['cannotdeleteqtypeinuse'] = 'Il tipo di domanda \'{$a}\' non può essere eliminato poiché nel deposito delle domande sono presenti domande di questo tipo.';
$string['cannotdeleteqtypeneeded'] = 'Il tipo di domanda \'{$a}\' non può essere eliminato poiché sono presenti domande che dipendono da questo tipo.';
$string['cfgwwwrootslashwarning'] = 'Nel file config.php $CFG->wwwroot è stato definito in modo errato. E\' stato incluso un carattere \'/\' alla fine. Deve essere rimosso o si verificheranno errori imprevisti come <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Nel file config.php $CFG->wwwroot è stato definito in modo errato. Non corrisponde al URL usato per accedere a questa pagina. Deve essere modificato o si verificheranno errori imprevisti come <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'cambia';
$string['changesitelang'] = 'Cambia la lingua del sito';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Si';
$string['choosefiletoedit'] = 'Scegli un file da modificare';
$string['clamfailureonupload'] = 'In caso di errore di Clam AV';
$string['cleanup'] = 'Pulizia';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 's';
$string['cliincorrectvalueerror'] = 'Errore, il valore "{$a->value}" non è corretto per "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valore non corretto, per favore riprova';
$string['clistatusdisabled'] = 'Stato: disabilitato';
$string['clistatusenabled'] = 'Stato: abilitato';
$string['clitypevalue'] = 'inserisci valore';
$string['clitypevaluedefault'] = 'inserisci un valore oppure premi Invio per usare il valore di default ({$a})';
$string['cliunknowoption'] = 'Opzioni non riconosciute:
{$a}
. Per favore utilizza l\'opzione --help.';
$string['cliupgradefinished'] = 'L\'aggiornamento via linea di comando è stato completato correttamente.';
$string['cliyesnoprompt'] = 'inserisci s (per Si) o n (per No)';
$string['commentsperpage'] = 'Commenti visualizzati per pagina';
$string['commonfiltersettings'] = 'Impostazioni comuni dei filtri';
$string['commonsettings'] = 'Impostazioni comuni';
$string['componentinstalled'] = 'Componente installato';
$string['computedfromlogs'] = 'Calcolato dal log a partire da {$a}';
$string['condifmodeditdefaults'] = 'I valori impostati sotto saranno i valori di default durante la creazione di nuove attività. E\' anche possibile stabilire quali impostazioni siano da considerarsi "avanzate".';
$string['confeditorhidebuttons'] = 'Seleziona i pulsanti dell\'editor HTML da nascondere.';
$string['configallcountrycodes'] = 'Questo è l\'elenco delle nazioni, utilizzato in varie parti di Moodle, come ad esempio il profilo utente. Se lasciato vuoto (default), verrà utilizzato l\'elenco presente in countries.php del language pack inglese standard, coincidente con l\'elenco ISO 3166-1. E\' possibile specificare un elenco di codici separati da virgola, ad esempio \'GB,FR,ES\'. Se inserisci codici non standard, devi anche aggiungerli al file countries.php nel tuo language pack e nel language pack inglese.';
$string['configallowassign'] = 'Tramite la matrice sottostante puoi autorizzare i ruoli elencati nella colonna verticale a sinistra ad assegnare ad altri utenti uno o più tra i ruoli presenti sulla riga di intestazione';
$string['configallowblockstodock'] = 'Se il tema scelto supporta questa funzione, gli utenti potranno spostare i blocchi laterali nel dock.';
$string['configallowcategorythemes'] = 'Abilitando questa opzione, i temi potranno essere impostati a livello di categoria. L\'impostazione influenzerà tutte le sotto categorie ed i relativi corsi a meno che gli stessi non abbiano  impostato esplicitamente il tema da utilizzare. ATTENZIONE: L\'abilitazione dei temi di categoria può influenzare le prestazioni.';
$string['configallowcoursethemes'] = 'Se abilitato, sarà  possibile impostare un tema diverso per ogni corso. Il tema del corso avrà precedenza su ogni altra preferenza (tema di sito, tema dell\'utente, tema di sessione).';
$string['configallowemailaddresses'] = 'Se si desidera che le email utilizzabili appartengano solo a determinati domini, è possibile elencare i domini autorizzati in questa impostazione, avendo cura di separare i domini tra loro con uno spazio. Le email che non appartengono ai domini elencati non saranno accettate. Per autorizzare anche i sotto domini, elencare il dominio precedendolo con \'.\'. Ad esempio  <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowobjectembed'] = 'Come misura standard di sicurezza, gli utenti normali non possono includere oggetti multimediali (come Flash) utilizzando esplicitamente i tag EMBED e OBJECT nei testi HTML (possono sempre utilizzare il filtro Plugin multimediali). Se preferisci consentire l\'utilizzo di questi tag, allora dvi abilitare l\'opzione.';
$string['configallowoverride'] = 'Permetti ai ruoli sulla sinistra di modificare i ruoli riportati in colonne';
$string['configallowoverride2'] = 'Tramite la matrice sottostante puoi autorizzare i ruoli elencati nella colonna verticale a sinistra a modificare i ruoli di altri utenti.<br />Si precisa che queste impostazioni avranno effetto solamente per i ruoli che hanno i privilegi moodle/role:override oppure moodle/role:safeoverride.';
$string['configallowswitch'] = 'E\' possibile selezionare i ruoli che possono \'Cambiare ruolo\', in funzione dei ruoli che già si possiedono. Oltre alla impostazione in questa tabella, un utente  deve anche possedere il privilegio moodle/role:switchroles.<br />Da notare che possono cambiare ruolo solo i ruoli che hanno il privilegio moodle/course:view e che non hanno il privilegio moodle/site:doanything. Per questo motivo alcune colonne nella tabella sono disabilitate.';
$string['configallowthemechangeonurl'] = 'L\'impostazione consente di cambiare il tema postponendo a qualsiasi URL di Moodle theme={themename}';
$string['configallowuserblockhiding'] = 'E\' possibile permettere agli utenti di espandere e minimizzare i blocchi laterali del sito. <br>Questa caratteristica utilizza Javascript e i cookie per ricordare lo stato di ogni blocco, influenzando pertanto solo la vista personale dell\'utente.';
$string['configallowusermailcharset'] = 'Abilitando questa opzione, ogni utente sarà in grado di definire il set di caratteri preferito delle email.';
$string['configallowuserswitchrolestheycantassign'] = 'Per cambiare ruolo gli utenti devono possedere il privilegio moodle/role:assign. Abilitando questa impostazione si rimuove la necessità di avere questo privilegio e i ruoli disponibili nel menù a discesa "Cambia ruolo in.." saranno controllati solamente dalle impostazioni della tabella "Autorizzati ad attribuire ruoli".
Si raccomanda che nella tabella "Autorizzati ad attribuire ruoli" non ci siano impostazioni tali da permettere agli utenti di cambiare il proprio ruolo con un ruolo che ha maggiori privilegi.';
$string['configallowuserthemes'] = 'Gli utenti potranno scegliere il loro tema personale. I temi personali hanno la precedenza sui temi del sito, ma non sui temi di corso.';
$string['configallusersaresitestudents'] = 'Ai fini delle attività poste sulla pagina home del sito, tutti gli utenti devono essere considerati studenti? Se si risponde "Si" allora ogni account utente confermato sarà  abilitato a partecipare come studente a queste attività . Se si risponde "No", allora solo gli utenti che sono anche studenti iscritti almeno ad un corso saranno abilitati a partecipare a queste attività  presenti nella pagina home. Solo gli amministratori e i docenti speciali assegnati potranno comportarsi come docenti per queste attività  della pagina home.';
$string['configauthenticationplugins'] = 'Nella tabella soprastante puoi abilitare i plugin di autenticazione ed ordinarli secondo la priorità di esecuzione desiderata.';
$string['configautolang'] = 'Rileva la lingua di default dalle impostazioni del browser.  Se l\'opzione è disabilitata sarà usata la lingua default del sito.';
$string['configautologinguests'] = 'Selezionando questa opzione, i visitatori potranno accedere direttamente ai corsi che consentono l\'accesso agli ospiti';
$string['configbloglevel'] = 'L\'impostazione permette di regolare la visibilità dei blog degli utenti. L\'impostazione regola la visibilità del blog per colui che legge i blog degli utenti ma non altera il privilegio degli utenti di scrivere nel proprio blog. Se non desiderati, i blog possono essere disabilitati.';
$string['configcachetext'] = 'Per siti molto grandi o siti che utilizzano filtri di testo, queste impostazioni possono davvero velocizzare la navigazione. Le copie dei testi saranno mantenute nella loro forma originaria per il tempo impostato. Valori molto ridotti possono provocare un rallentamento generale, mentre valori eccessivi potrebbero causare tempi troppo lunghi nel refresh dei testi principali (ad esempio, nel caso di nuovi collegamenti)';
$string['configcachetype'] = 'E\' possibile impostare il tipo di cache che sarà utilizzata da Moodle. L\'impostazione configura solamente la cache, ricordati di abilitare rcache affinché la cache sia usata realmente. Questa impostazione è utile <strong>solo</strong> se è necessario ridurre il carico sul database - altrimenti Moodle potrebbe girare più lentamente. I siti a medio traffico possono ottenere benefici usando il tipo "internal". Un singolo webserver con installati eAccelerator o Turckmmcache, <em>con le opzioni "shared memory" abilitate </em>, dovrebbe scegliere "eaccelerator". Se hai una installazione multiple-server con uno o più demoni memcached in esecuzione e l\'estensione PHP-memcached, scegli "memcached" e configura le sottostanti opzioni memcached. <br /><strong>Nota:</strong> assicurati di provare le performance sotto carico e regola i parametri di conseguenza - la cache potrebbe rendere il  sito più lento. In situazioni di elevato traffico, eAccelerator e memcached possono dare i benefici maggiori, ma hanno i costi più alti in termini di uso della CPU del server.';
$string['configcalendarexportsalt'] = 'Il seme generato casualmente viene utilizzato per rendere più sicuri i token di autenticazione usati per l\'esportazione dei calendari. Puoi cambiare il seme ma tutti i token di autenticazione al momento attivi non saranno più validi.';
$string['configclamactlikevirus'] = 'Considera infetti i file';
$string['configclamdonothing'] = 'Considera OK i file';
$string['configclamfailureonupload'] = 'Imposta il comportamento nel caso in cui Clam non funzioni correttamente oppure non sia configurato in modo appropriato.  Se imposti \'Considera infetti i file\', i file saranno spostati nell\'area di quarantena o saranno eliminati. Se imposti \'Considera OK i file\', i file verranno trasferiti nella cartella di destinazione. In ogni caso, se Clam antivirus dovesse andare in errore, gli amministratori verranno avvisati. Se imposti \'Considera infetti i file\' e per qualche motivo Clam antivirus dovesse andare in errore (spesso avviene se il valore di pathtoclam è errato), QULASIASI file caricato sarà spostato nell\'area di quarantena o eliminato. Si consiglia di impostare questa variabile con molta attenzione.';
$string['configconvertformat'] = 'Se sono disponibili <i>latex</i>, <i>dvips</i> and <i>convert</i>, le immagini saranno create usando il formato specificato. In mancanza, verrà usato mimeTeX che genererà immagini in formato GIF';
$string['configcookiehttponly'] = 'Abilita le nuove caratteristiche disponibili in PHP 5.2.0. I browser verranno obbligati ad inviare cookie solo tramite protocollo http, in modo da non consentirne l\'accesso da parte di linguaggi di scripting. Non tutti i browser supportano questa caratteristica che potrebbe non essere compatibile con l\'attuale codice. Questa impostazione aiuta a prevenire alcuni tipi di attacchi XSS.';
$string['configcookiesecure'] = 'Se il server accetta solamente connessioni https, allora è opportuno abilitare l\'invio di cookie sicuri. Se abiliti questa impostazione, accertatati che il server web non accetti connessioni http://, oppure imposta un reindirizzamento permanente al protocollo https://. Nel caso in cui l\'indirizzo specificato per <em>wwwroot</em> nel file config.php non contenga https://, questa impostazione  verrà automaticamente disabilitata.';
$string['configcountry'] = 'Il Paese che comparirà per default nelle pagine di creazione di un account utente. Se non si imposta un Paese di default, il campo diventerà a compilazione obbligatoria.';
$string['configcourserequestnotify'] = 'E\' possibile indicare lo username dell\'utente da avvertire in presenza di richieste di nuovi corsi.';
$string['configcourserequestnotify2'] = 'Gli utenti da avvertire in presenza di domande per Corsi a richiesta. L\'elenco riporta solo gli utenti che hanno il privilegio di approvare Corsi a richiesta.';
$string['configcoursesperpage'] = 'Numero di corsi da visualizzare nelle pagine contenenti elenchi di corsi.';
$string['configcronclionly'] = 'Questa opzione disabilita l\'esecuzione del cron via web, permettendola solo dalla linea di comando. L\'opzione annulla le eventuali impostazioni sottostanti relative alla password cron.';
$string['configcronremotepassword'] = 'Lo script cron.php potrà essere essere eseguito da un browser web solo fornendo la password, in accordo alla seguente formato della URL:<pre>
http://site.example.com/admin/cron.php?password=opensesame
</pre> Se l\'impostazione è lasciata vuota, non sarà necessaria nessuna password.script cron.php on può essere eseguito da un browser web senza fornire la password usando il seguente formato di URL:<pre>
http://site.example.com/admin/cron.php?password=opensesame
</pre> Se l\'impostazione è lasciata vuota, non è necessaria nessuna password.';
$string['configcurlcache'] = 'Time-to-live, espresso in secondi, della cache cURL';
$string['configcustommenuitems'] = 'E\' possibile configurare un menu orizzontale personalizzato. Ciascuna linea è composta da testo, un URL (opzionale) e un testo per il tooltip (opzionale), separati dal carattere “|” (pipe). E\' possibile anche indicare sotto menù anteponendo il segno meno, Esempio:
<pre>
Moodle community|http://moodle.org
-Moodle free support|http://moodle.org/support
-Moodle development|http://moodle.org/development
--Moodle Tracker|http://tracker.moodle.org
--Moodle Docs|http://docs.moodle.org
-Moodle News|http://moodle.org/news Moodle company
-Moodle commercial hosting|http://moodle.com/hosting
-Moodle commercial support|http://moodle.com/support
</pre>';
$string['configdbsessions'] = 'E\' possibile memorizzare le informazioni delle sessioni nel database. L\'impostazione è particolarmente utile  per siti molto grandi, con molto traffico o per siti in cluster. Per la maggior parte dei siti questa impostazione può essere lasciata al suo default, in modo da memorizzare i dati di sessione nel file system. Attenzione: cambiare questa impostazione provoca il logout dal sito di tutti gli utenti collegati, voi compresi.';
$string['configdebug'] = 'L\'impostazione permette di regolare il livello di reportistica del PHP. E\' utile esclusivamente per gli sviluppatori.';
$string['configdebugdisplay'] = 'L\'opzione permette di indirizzare il report degli errori nella pagina HTML. Sebbene l\'opzione sia particolarmente comoda, va tenuto presente che l\'invio di messaggi di errore nella pagina HTML altererà l\'XHTML, i JS, i cookie e gli header HTTP. Se non si seleziona l\'opzione, il report sarà inviato nel log del  server, permettendo un miglior debugging. Il nome del log di destinazione è controllato dalla impostazione PHP error_log.opzione permette di indirizzare il report degli errori nella pagina HTML. Sebbene l\'opzione sia particolarmente comoda, va tenuto presente che l\'invio di messaggi di errore nella pagina HTML altererà l\'XHTML, i JS, i cookie e gli header HTTP. Se non selezionate l\'opzione, il report sarà inviato nel log del vostro server, permettendo un miglior debugging. Il nome del log di destinazione è controllato dalla impostazione PHP error_log.';
$string['configdebugpageinfo'] = 'Seleziona l\'opzione se si desidera visualizzare le informazione nel piè di pagina.';
$string['configdebugsmtp'] = 'L\'opzione permette di visualizzare informazioni di debug utili per individuare problemi relativi all\'invio dei email tramite server SMTP.';
$string['configdebugstringids'] = 'L\'opzione è pensata per facilitare i traduttori: attivandola, verrà visualizzata la provenienza di ciascuna  stringa della lingua. (La modifica avrà effetto al prossimo caricamento della pagina).';
$string['configdebugvalidators'] = 'Seleziona l\'opzione se si desidera visualizzare i link ai validator esterni. Per il corretto funzionamento è necessario creare un utente con username <em>w3cvalidator</em> ed abilitare l\'accesso agli ospiti. Tali impostazioni possono consentire accessi non autorizzati al  server, pertanto non va utilizzata su siti in produzione.';
$string['configdefaultallowedmodules'] = 'Per i corsi che ricadono nella categoria sovrastante, quali moduli si vuole che vengano permessi <b>quando il corso è creato</b>?';
$string['configdefaulthomepage'] = 'Imposta la pagina home per gli utenti autenticati';
$string['configdefaultrequestcategory'] = 'I corsi a richiesta, se approvati, saranno automaticamente inseriti nella categoria specificata.';
$string['configdefaultrequestedcategory'] = 'Categoria in cui inserire i corsi a richiesta, una volta approvati.';
$string['configdefaultuserroleid'] = 'A tutti gli utenti autenticati, nel contesto del sito, sarà assegnato il ruolo qui indicato. Tale ruolo viene assegnato in aggiunta ai ruoli che gli utenti già possiedono nel sito. Il valore di default è Utente autenticato. Il ruolo di Utente autenticato non entra in conflitto con nessun altro ruolo: il suo scopo è quello di garantire agli utenti autenticati alcuni privilegi, indipendenti dal fatto di essere iscritti ad un corso, come ad esempio inserire un intervento nel blog, gestire il proprio calendario, eccetera.';
$string['configdeleteincompleteusers'] = 'Dopo questo periodo di tempo, gli account non completati saranno eliminati.';
$string['configdeleteunconfirmed'] = 'Se si sta usando l\'autenticazione e-mail, questo parametro imposta il periodo di tempo entro il quale sarà  accettata la conferma da parte dagli utenti. Trascorso questo periodo, gli utenti non confermati vengono eliminati.';
$string['configdenyemailaddresses'] = 'Se si desidera impedire l\'uso di email appartenenti a taluni domini, in questa impostazione è possibile elencare i domini indesiderati . Le email appartenenti a domini non presenti nell\'elenco potranno invece essere utilizzate. Per includere anche i sotto domini, elencare il dominio precedendolo con \'.\'. Ad esempio, <strong>hotmail.com .yahoo.co.uk.live</strong>';
$string['configdigestmailtime'] = 'Agli utenti che hanno di ricevere i post in formato raccolta, verrà inviata quotidianamente la raccolta dei messaggi. L\'impostazione regola l\'ora di invio della raccolta, che sarà spedita con il cron successivo all\'ora impostata.';
$string['configdisableuserimages'] = 'Gli utenti non potranno  cambiare l\' immagine del proprio profilo.';
$string['configdisplayloginfailures'] = 'Visualizza le informazioni sui login falliti ad utenti selezionati.';
$string['configdocroot'] = 'Imposta il percorso per la Documentazione di Moodle. Puoi cambiare questa impostazione se volete avere la vostra documentazione in linea personalizzata. Comunque, se lo fate, accertatevi che il percorso della vostra documentazione segua lo stesso formato come su http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Abilitatando questa opzione, i collegamenti a Moodle Docs verranno mostrati in una nuova finestra';
$string['configeditordictionary'] = 'Questo valore sarà utilizzato se lo spell checker aspell non dispone del dizionario corrispondente alla lingua degli utenti.';
$string['configeditorfontlist'] = 'Scegli i font che appariranno nella lista drop-down dell\'editor.';
$string['configemailchangeconfirmation'] = 'Obbliga gli utenti a confermare il cambio di email quando modificano l\'indirizzo di posta elettronica nel proprio profilo.';
$string['configenableajax'] = 'Questa impostazione permette di controllare l\'uso di AJAX (interfacce client/server evolute che utilizzano Javascript) in tutto il sito. Con questa impostazione abilitata gli utenti nel loro profilo potranno scegliere se avvalersi di AJAX.';
$string['configenablecalendarexport'] = 'Abilita l\'esportazione o la sottoscrizione ai calendari.';
$string['configenablecomments'] = 'Abilita i commenti';
$string['configenablecourserequests'] = 'Questa impostazione consentirà agli utenti di richiedere corsi.';
$string['configenableglobalsearch'] = 'Questa impostazione abilita la ricerca globale di testo nelle risorse e nelle attività. Non è compatibile con PHP 4.';
$string['configenablegroupmembersonly'] = 'L\'impostazione abilita la funzionalità  \'Disponibile solo per gli appartenenti al raggruppamento\'. Da notare che la funzione aumenterà il carico sul server e che sarà necessario impostare appropriatamente le categorie nel registro del valutatore affinché le attività non siano visibili a coloro che non fanno parte del raggruppamento.';
$string['configenablehtmlpurifier'] = 'Per pulire testo non affidabile verrà usato HTML Purifier al posto di KSES. HTML Purifier è in continuo sviluppo ed è ritenuto più sicuro, al prezzo di un maggior consumo di risorse, ma il codice HTML ripulito avrà meno differenze rispetto all\'originale. Notare che i tag embed e object non possono essere abilitati, e che i tag MathML ed i vecchi tag lang non sono supportati.';
$string['configenablerssfeeds'] = 'Attiva il generatore RSS (RSS Feed) del sito. Per poter utilizzare i feed RSS è necessario attivare anche il generatore RSS nei singoli moduli di attività: per farlo, vai in \'Moduli->Attività\' dal blocco Amministrazione del Sito.';
$string['configenablerssfeedsdisabled'] = 'Non è disponibile poiché il generatore RSS è disabilitato a livello di sito. Per attivarlo, andate in \'configura variabili\' nel pannello di Amministrazione.';
$string['configenablerssfeedsdisabled2'] = 'I feed RSS sono disabilitati a livello di server. Devi abilitarli in Server/RSS.';
$string['configenablesafebrowserintegration'] = 'L\'impostazione aggiunge l\'opzione \'Safe Exam Browser\' nel menù a discesa \'Livello sicurezza browser\' presente nelle impostazioni dei quiz. Per maggiori informazioni: http://safeexambrowser.org.';
$string['configenablestats'] = 'Attivando le statistiche, Moodle elaborerà il log con cadenza giornaliera. La durata dell\'elaborazione  dipenderà dal traffico del sito. Le statistiche permettono di visualizzare graficamente dati sui corsi e sul sito.';
$string['configenabletrusttext'] = 'Per default Moodle ripulisce con cura tutti i testi inseriti dagli utenti, al fine di rimuovere ogni possibile script malevolo, oggetto multimediale od altro che possa mettere a repentaglio la sicurezza. Il sistema di Contenuto Affidabile è un modo per dare ad  utenti degni di fiducia la possibilità di usare funzioni evolute nei loro contenuti senza alcuna interferenza. Per attivare il sistema è necessario abilitare l\'impostazione e poi attribuire il privilegio Contenuto Affidabile ad uno specifico ruolo. I testi creati o caricati dagli utenti che hanno tale ruolo saranno contrassegnati come "affidabili" e non saranno ripuliti prima della visualizzazione.';
$string['configenablewebservices'] = 'I Web service consentono agli utenti di altri sistemi di collegarsi a Moodle e di effettuare varie operazioni. Per maggiore sicurezza, abilitate i Web service solo se avete realmente bisogno di usarli.';
$string['configenablewsdocumentation'] = 'Abilita la generazione automatica della documentazione web service. Un utente web service può accedere alla propria documentazione nella pagina delle chiavi. La documentazione visualizzata è relativa solamente ai protocolli abilitati.';
$string['configerrorlevel'] = 'Imposta il numero di messaggi di errore di PHP che si desidera visualizzare. \'Normale\' è solitamente l\'opzione migliore.';
$string['configexcludeoldflashclients'] = 'Alcune versioni del plugin Adobe Flash player sono note per la loro vulnerabilità ad attacchi provenienti da contenuti Flash malevoli. Questa impostazione permette di stabilire la versione minima necessaria al di sotto della quale Moodle non visualizzerà contenuti Flash agli utenti. Al posto del contenuto Flash verrà visualizzato un file alternativo  con i suggerimenti per aggiornare il plugin. Per disabilitare il controllo lasciare vuota l\'impostazione.';
$string['configextendedusernamechars'] = 'Attiva questa opzione per permettere agli studenti di utilizzare qualsiasi carattere per il proprio nome utente (da notare che l\'impostazione non ha effetti sui loro nomi reali).
L\'impostazione predefinita consente l\'uso dei soli caratteri alfanumerici minuscoli, carattere di sottolineatura (_), segno meno (-), punto (.) o il simbolo "at" (@)';
$string['configextramemorylimit'] = 'Alcuni script, come la ricerca globale, il backup/ripristino o il cron, richiedono maggiore memoria. Aumentare questo valore per siti di grandi dimensioni.';
$string['configextrauserselectorfields'] = 'Durante la selezione degli utenti, ad esempio durante l\'attribuzione dei ruoli o la creazione di gruppi, assieme al nome e cognome verranno visualizzati i  campi qui selezionati, che saranno usati anche per effettuare ricerche. Per motivi di sicurezza, è sconsigliabile visualizzare gli username.';
$string['configfilterall'] = 'Filtra tutte le stringhe, incluse le intestazioni, titoli, barre di navigazione ecc.
E\' utile solo se si usa il filtro multilingua, in mancanza del quale si creerà solo carico supplementare sul sito senza vantaggi apprezzabili.';
$string['configfiltermatchoneperpage'] = 'Il filtro di creazione automatica dei link (auto-link) genererà solo il collegamento alla prima occorrenza del testo trovato nella pagina. Tutte le altre saranno ignorate.';
$string['configfiltermatchonepertext'] = 'Il filtro di creazione automatica dei link (auto-link) genererà solo il collegamento alla prima occorrenza del testo trovata in ogni elemento di testo (es. risorsa, blocco) della pagina. Tutte le altre saranno ignorate. Questa impostazione non viene tenuta in considerazione se Filtra occorrenze una volta per pagina è impostato a <i>si</i>.';
$string['configfilteruploadedfiles'] = 'Imposta il filtraggio antecedente alla visualizzazione dei file caricati: Tutti i file, Solo file HTML oppure Nessuno.';
$string['configforcelogin'] = 'L\'elenco dei corsi e la pagina home del sito per default sono visibili senza doversi autenticare. Se si desidera obbligare i visitatori ad autenticarsi  prima che possano vedere la pagina home o svolgere una qualsiasi attività sul sito, abilitare questa opzione.';
$string['configforceloginforprofiles'] = 'L\'impostazione rende obbligatoria l\'autenticazione con credenziali valide (non come ospite) per  visualizzare i profili di altri utenti. Disabilitando questa impostazione, il contenuto dei profili utente sarà pubblico.';
$string['configframename'] = 'Se si desidera inserire Moodle in un frame, è possibile specificare qui il nome del frame. Altrimenti  questo valore può rimanere su \'_top\'';
$string['configfrontpage'] = 'Puoi impostare gli elementi da visualizzare nella pagina home del sito ed il loro ordine.';
$string['configfrontpageloggedin'] = 'Puoi impostare gli elementi da visualizzare nella pagina home del sito ed il loro ordine per gli utenti che si sono autenticati.';
$string['configfullnamedisplay'] = 'Definisce la modalità  di visualizzazione dei nomi. Per la maggior parte dei siti \'mono-linguistici\' la scelta più efficiente è quella predefinita \'nome+cognome\', ma si potrebbe per esempio voler nascondere i cognomi, oppure lasciar decidere alle impostazioni del Language Pack. (Alcune lingue hanno convenzioni differenti).';
$string['configgdversion'] = 'Indica quale versione della libreria grafica GD (GD library) è installata. La versione mostrata è quella che è stata riconosciuta automaticamente dal sistema. Non modificare questo valore fino a quando non si è consapevoli di ciò che si sta facendo.';
$string['configgeoipfile'] = 'Posizione del file dati GeoIP City. Questo file non fa parte della distribuzione di Moodle e deve essere scaricato separatamente da <a href="http://www.maxmind.com/">MaxMind</a>. E\' possibile acquistare la versione commerciale o utilizzare la versione gratuita.<br/>
Per il download andare su <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz">http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> ed estrarre il file nella cartella "{$a}" del proprio server.';
$string['configgetremoteaddrconf'] = 'Se il server si trova dietro un reverse proxy,  tramite questa  impostazione è possibile indicare quali header HTTP possano ritenersi affidabili per gli indirizzi IP remoti. Gli header vengono letti sequenzialmente a partire dal primo disponibile.';
$string['configgooglemapkey'] = 'E\' necessario inserire una chiave speciale per usare Google Maps per vedere le località corrispondenti agli indirizzi IP. La chiave può essere ottenuta gratuitamente da <a href="http://code.google.com/apis/maps/signup.html">http://code.google.com/apis/maps/signup.html</a>.<br />La URL del tuo sito web è: {$a}';
$string['configgradebookroles'] = 'Questa impostazione permette di specificare i ruoli che figureranno nel Registro Valutazioni. E\' necessario che un utente possegga almeno uno di questi ruoli per figurare nel Registro Valutazioni di un corso.';
$string['configgradeexport'] = 'E\' possibile scegliere i formati preferiti  da usare per l\'esportazione delle valutazioni. I formati scelti durante l\'esportazione imposteranno il campo "Formati utilizzati recentemente" per ciascun Registro valutazioni. Questo aspetto potrebbe far apparire le valutazioni esportate come "nuove" oppure come "aggiornate". Se non sei più che sicuri di come impostare i formati, allora non selezionare nulla.';
$string['confighiddenuserfields'] = 'E\' possibile nascondere alla vista degli utenti che non abbiano il ruolo di docente/amministratore alcuni dei campi presenti nel profilo utente. Lo scopo è quello di aumentare la privacy degli utenti. Per selezionare più campi tieni premuto il tasto CTRL o Command a seconda del sistema operativo in uso.';
$string['configidnumber'] = 'Questa opzione specifica se:
a) all\'utente non viene richiesto un numero ID in assoluto.
b) all\'utente viene richiesto un numero ID ma può lasciarlo in bianco.
c) all\'utente viene richiesto un numero ID e non può lasciarlo in bianco. Se attivato, il numero ID è viualizzato nel profilo degli utenti.';
$string['configintcachemax'] = 'Impostazione valida solo per la cache di tipo "internal". Numero massimo di record da mantenere nella cache. Valore consigliato: 50. Per ridurre l\'uso della memoria utilizzare valori più bassi.';
$string['configintro'] = 'In questa pagina si possono specificare un numero di variabili di configurazione che aiutano Moodle a lavorare al meglio.
Non ti preoccupare troppo a riguardo, i valori predefiniti in genere svolgono bene il loro compito e puoi sempre tornare su questa pagina in un secondo momento per modificare le impostazioni.';
$string['configintroadmin'] = 'In questa pagina devi configurare l\'account dell\'Amministratore primario che avrà  il controllo completo sul sito. Assicurati di fornire uno username e una password sicuri, così come un indirizzo email valido. In seguito sarà possibile assegnare il ruolo di amministratore ad  altri account.';
$string['configintrosite'] = 'Questa pagina  permette di configurare la pagina home e il nome di questo sito.
In un secondo momento sarà possibile tornare su questa pagina e modificare ulteriormente queste impostazioni, seguendo il link \'Impostazioni del sito\' dalla Home Page del sito.pagina vi permette di configurare la pagina home e il nome di questo nuovo sito.
Potrete tornare in un secondo momento su questa pagina per modificare queste impostazioni, seguendo il link \'Impostazioni del sito\' dalla Home Page del sito.Questa pagina';
$string['configintrotimezones'] = 'In questa pagina è possibile aggiornare l\'elenco dei fusi orari e le impostazioni sul passaggio all\'ora legale. L\'elenco dei fusi orari aggiornati sarà cercata in sequenza nei seguenti percorsi di sistema o URL: {$a} Questa procedura di aggiornamento è priva di rischi e non può pregiudicare il buon funzionamento della installazione. Desideri aggiornare l\'elenco dei fusi orari?questa pagina è possibile aggiornare l\'elenco dei fusi orari e le impostazioni sul passaggio all\'ora legale.
L\'elenco dei fusi orari aggiornati sarà cercata in sequenza nei seguenti percorsi di sistema o URL: {$a} Questa procedura di aggiornamento è priva di rischi e non può pregiudicare il buon funzionamento della vostra attuale installazione. Desiderate aggiornare l\'elenco dei fusi orari?';
$string['configiplookup'] = 'Quando si clicca su un indirizzo IP (come per es. 34.12.222.93), come riportato nei log, viene visualizzata una mappa con la localizzazione più probabile di quel IP. Ci sono diversi plugin che si possono scegliere per ottenere questo, ciascuno con i suoi pro e contro.';
$string['configjabberhost'] = 'Il server al quale connettersi per inviare le notifiche jabber';
$string['configjabberpassword'] = 'La password da usare per il collegamento al server Jabber';
$string['configjabberport'] = 'La porta da usare per il collegamento al server Jabber';
$string['configjabberserver'] = 'ID host XMPP (può essere omesso se è uguale all\'host Jabber)';
$string['configjabberusername'] = 'Il nome utenta da usare  per il collegamento al server Jabber';
$string['configkeeptagnamecase'] = 'Spunta questa opzione se vuoi che i nomi delle Tag mantengano i caratteri maiuscoli/minuscoli come definiti dall\'utente che li ha creati.';
$string['configlang'] = 'La lingua di default del sito. Gli utenti che lo desiderano potranno modificare l\'impostazione nel proprio profilo.';
$string['configlangdir'] = 'Molte lingue vengono scritte da destra verso sinistra, altre, come l\'arabo e l\'ebraico, vengono scritte da destra verso sinistra.';
$string['configlanglist'] = 'Lascia vuoto se vuoi consentire agli utenti di scegliere tra tutte le lingue installate. Se preferisci, si può abbreviare il menu delle lingue inserendo un elenco dei codici lingua separati da virgole.
Per esempio: en, es_es, it, fr';
$string['configlangmenu'] = 'Scegliete se pubblicare o meno il menu delle lingue generico sulla Home Page, nella pagina di Login, ecc.
Questa scelta non influisce sulla possibilità  da parte dell\'utente di scegliere una lingua preferita all\'interno del suo profilo personale.';
$string['configlangstringcache'] = 'Esegue il caching delle stringhe delle lingue in file compilati nella cartella dati, migliorando le prestazioni. Se stai traducendo Moodle o modificando stringhe nel codice sorgente, è preferibile disabilitare il caching. ';
$string['configlatinexcelexport'] = 'Scegli la codifica per le esportazioni Excel.';
$string['configlocale'] = 'Scegli la localizzazione del sito - L\'impostazione avrà  effetto sulla visualizzazione delle date. È necessario avere la stessa localizzazione del server installata sul sistema operativo del proprio computer. (Per esempio: it_IT).
Se non sai come impostare, lascia il campo vuoto.';
$string['configloginhttps'] = 'Se attivata, questa impostazione consente a Moodle di utilizzare connessioni sicure di tipo https soltanto per la pagina di login (fornendo una login sicura), tornando successivamente ad una normale connessione http per il resto della navigazione degli altri URL.<br>
PRUDENZA: questa impostazione RICHIEDE che https venga specificatamente attivato sul web server - Se non lo fosse VERRETE BLOCCATI AL DI FUORI DAL SITO!';
$string['configloglifetime'] = 'L\'impostazione specifica la durata di conservazione dei log dell\'\'attività  degli utenti. I log antecedenti questa data verranno eliminati automaticamente.
La cosa migliore è conservare i log il più a lungo possibile ma se disponi di un server sovraccarico o hai problemi di performance, è meglio abbreviare la durata di conservazione. Valori inferiori a 30 non sono consigliati in quanto le statistiche potrebbero non funzionare correttamente.';
$string['configlookahead'] = 'Giorni futuri da controllare';
$string['configmailnewline'] = 'Caratteri Newline (salto riga) usati nei messaggi di posta. Secondo la RFC 822bis è richiesto CRLF, alcuni server di posta converrtono automaticamente LF in CRLF, altri convertono in modo non corretto da CRLF a CRCRLF, altri ancora rifiutano mail con solo LF (qmail per esempio). Provare a cambiare questa impostazione se si riscontrano problemi con messagi non spediti o doppi salti riga.';
$string['configmaxbytes'] = 'Imposta la dimensione massima per gli upload di file. Il valore massimo è limitato dalla variabile PHP  \'upload_max_filesize\' e \'post_max_size\'  e dal valore della variabile \'LimitRequestBody\' di Apache.
L\'impostazione a sua volta limita la dimensione massima degli upload nei corsi e nei moduli. Scegliendo \'Limite server\', sarà usato il valore di upload massimo consentito.';
$string['configmaxconsecutiveidentchars'] = 'Le password non devono contenere un numero di caratteri identici e consecutivi maggiori del valore specificato. Per disabilitare questa verifica inserite il valore 0.';
$string['configmaxeditingtime'] = 'Questo parametro specifica il tempo massimo a disposizione degli utenti per per modificare i loro interventi su forum, commenti del glossario, eccetera. Normalmente 30 minuti è un valore adeguato.';
$string['configmaxevents'] = 'Eventi da anticipare';
$string['configmemcachedhosts'] = 'Per la cache di tipo "memcached". Un elenco (separato da virgole) di host dove è in esecuzione il demone memcached. Si consiglia di usare indirizzi IP per evitare la latenza dovuta alla risoluzione dei nomi tramite DNS. Il tipo di cache memcached non funziona bene se aggiungete o togliete host già configurati.';
$string['configmemcachedpconn'] = 'Per la cache di tipo "memcached". Utilizzo di connessioni persistenti. Usate con attenzione questa impostazione poiché potrebbe provocare un crash di Apache/PHP subito dopo il riavvio del demone memcached.';
$string['configmessaging'] = 'Abilita il sistema di messaggistica interna';
$string['configmessagingdeletereadnotificationsdelay'] = 'Le notifiche lette possono essere eliminate per ridurre lo spazio occupato. E\' possibile specificare per quanto tempo conservare le notifiche lette prima di eliminarle.';
$string['configmessaginghidereadnotifications'] = 'E\' possibile nascondere le notifiche lette, come i post dei forum, durante la visualizzazione dello storico dei messaggi.';
$string['configminpassworddigits'] = 'Le password devono avere almeno questo numero di caratteri numerici.';
$string['configminpasswordlength'] = 'Le password devono essere lunghe almeno questo numero di caratteri.';
$string['configminpasswordlower'] = 'Le password devono avere almeno questo numero di lettere minuscole.';
$string['configminpasswordnonalphanum'] = 'Le password devono avere almeno questo numero di caratteri non alfanumerici.';
$string['configminpasswordupper'] = 'Le password devono avere almeno questo numero di lettere maiuscole.';
$string['configmycoursesperpage'] = 'Numero massimo di corsi presenti nell\'elenco dei corsi ai quali si è iscritti.';
$string['configmymoodleredirect'] = 'L\'impostazione reindirizza gli utenti non amministratori a /my dopo il login, sostituendo anche la navigazione verso la home page con /my';
$string['configmypagelocked'] = 'L\'impostazione impedisce la modifica della pagina di default da parte di utenti che non abbiamo il ruolo di amministratori';
$string['confignavcourselimit'] = 'Limita il numero di corsi visibili agli utenti quando non sono autenticati o non iscritti in nessun corso.';
$string['confignavshowallcourses'] = 'L\'impostazione garantisce che tutti i corsi siano sempre visibili nel blocco navigazione.';
$string['confignavshowcategories'] = 'Visualizza le categorie di corso nelle briciole e nel blocco Navigazione. Le categorie non saranno visualizzate nei corsi dove l\'utente è iscritto, che saranno elencati nel link I miei corsi.';
$string['confignoreplyaddress'] = 'Le mail a volte sono spedite a nome di un utente (per esempio, gli interventi dei forum). L\'indirizzo mail qui specificato sarà  utilizzato come l\'indirizzo "Da" cui proviene il messaggio,nei casi in cui il ricevente non è in grado di replicare direttamente all\'utente (per esempio, quando un utente decide di mantenere il suo indirizzo privato).';
$string['confignotifyloginfailures'] = 'Se sono stati registrati accessi falliti, una mail di notifica può essere spedita. Chi deve ricevere queste notifiche?';
$string['confignotifyloginthreshold'] = 'Se la notifica sugli accessi falliti è attiva, dopo quanti tentativi falliti per utente o per indirizzo IP la notifica deve essere inviata?';
$string['confignotloggedinroleid'] = 'Ai visitatori (utenti non autenticati nel contesto del sito) sarà attribuito il ruolo indicato. Per i visitatori non dovreste scegliere nulla di diverso dal ruolo di Ospite, in ogni caso avete la possibilità di creare nuovi ruoli per i visitatori, con autorizzazioni diverse. Alcune attività, come ad esempio intervenire in un forum, richiederanno comunque all\'utente di autenticarsi.';
$string['configopentogoogle'] = 'L\'impostazione permette a Google di  entrare nel vostro sito come Ospite. Inoltre, coloro che tramite Google raggiungeranno il vostro sito saranno autenticati automaticamente come Ospite. Da notare che l\'impostazione fornisce un accesso trasparente solo a quei corsi che già consentono l\'accesso agli ospiti.';
$string['configoverride'] = 'Definito in config.php';
$string['configpasswordpolicy'] = 'Attivando questa opzione Moodle verificherà le password degli utenti secondo le regole indicate. Le impostazioni seguenti servono a specificare tali regole (le regole password saranno ignorate se questa opzione non è selezionata).';
$string['configpathtoclam'] = 'Percorso assoluto per Clam antivirus. Probabilmente usr/bin/clamscan oppure /usr/bin/clamdscan.
Questo percorso consente a Clam di funzionare.';
$string['configpathtodu'] = 'Percorso assoluto per du. Probabilmente usr/bin/du. Se questo campo viene compilato, le pagine che mostrano il contenuto delle cartelle con molti file verranno elaborate più velocemente.';
$string['configperfdebug'] = 'L\'opzione permette di visualizzare informazioni sulle prestazioni nel piè di pagina del tema standard';
$string['configprofileroles'] = 'Elenco dei ruoli visibili nelle pagine del profilo utente e della partecipazione';
$string['configprofilesforenrolledusersonly'] = 'Per evitare abusi da parte di spammer, non verranno visualizzate le descrizioni dei profili degli utenti non iscritti a corsi. I nuovi utenti potranno aggiungere la  descrizione nel profilo solo dopo essere stati iscritti ad almeno un corso.';
$string['configprotectusernames'] = 'Lo script forget_password.php per default non visualizza nulla che possa aiutare ad indovinare username o email di utenti.';
$string['configproxybypass'] = 'Elenco separato da virgole dei nomi degli host o degli IP (anche parziali) che possono evitare il proxy (ad esempio, 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Se questo <b>server</b> ha bisogno di un  di un proxy (o di un firewall) per accedere a Internet, specificate il nome del proxy. Se non usate proxy, non compilate questo campo.';
$string['configproxypassword'] = 'Password per accedere a internet attraverso il proxy, lasciare vuoto se non utilizzata (è necessaria l\'estensione PHP cURL).';
$string['configproxyport'] = 'Specificate la porta usata dal proxy per accedere ad Internet';
$string['configproxytype'] = 'Tipo di proxy (per il supporto SOCKS5 sono necessari il PHP5 e l\'estensione cURL ).';
$string['configproxyuser'] = 'Username abilitato ad accedere ad internet attraverso il proxy, lasciare vuoto se non utilizzato (è necessaria l\'estensione PHP cURL).';
$string['configquarantinedir'] = 'Se desiderate che Clam antivirus sposti eventuali file infetti in una cartella di quarantena, inseritene il percorso qui. La cartella deve avere i permessi di scrittura da parte del server web. Se lasciate in bianco, o se configurate una directory inesistente o senza i permessi di scrittura necessari, i files infetti saranno eliminati. Non inserite slash di percorso.';
$string['configrcache'] = 'Utilizzo della cache per memorizzare i record del database. Se attivate la cache dei record ricordatevi anche di impostare il tipo di cache!';
$string['configrcachettl'] = 'Time-To-Live (tempo di permanenza) dei record in cache. Si consiglia di usare un valore basso (<15).';
$string['configrecaptchaprivatekey'] = 'Stringa di caratteri usata per comunicare tra il proprio server Moodle e il server recaptcha.net. E\' possibile richiedere una chiave visitando il sito http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Stringa di caratteri usata per visualizzare l\'immagine reCAPTCHA nella pagina di creazione account. L\'immagine è generata dal sito ttp://www.google.com/recaptcha';
$string['configrequestedstudentname'] = 'Termine per \'studente\' da utilizzare nel corsi richiesti';
$string['configrequestedstudentsname'] = 'Termine per \'studenti\' da utilizzare nel corsi richiesti';
$string['configrequestedteachername'] = 'Termine per \'docente\' da utilizzare nel corsi richiesti';
$string['configrequestedteachersname'] = 'Termine per \'docenti\' da utilizzare nel corsi richiesti';
$string['configrequiremodintro'] = 'Disabilitando l\'opzione la descrizione dell\'aattività non sarà più obbligatoria.';
$string['configrestrictbydefault'] = 'I nuovi corsi che vengono creati nella categoria soprastante devono avere restrizioni sui loro moduli?';
$string['configrestrictmodulesfor'] = 'Quali corsi devono avere la <b>possibilità </b> di disabilitare alcuni moduli?';
$string['configrunclamavonupload'] = 'Se abilitato, clam AV sarà usato per fare lo scan di tutti i files caricati.';
$string['configrunclamonupload'] = 'Attivare Clam antivirus sui file in trasferimento? Avrete bisogno di configurare correttamente il percorso nella variabile \'pathtoclam\' per farlo funzionare. (Clam è un antivirus gratuito che si può ottenere dal sito: http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interfaccia';
$string['configsectionmail'] = 'Posta';
$string['configsectionmaintenance'] = 'Manutenzione';
$string['configsectionmisc'] = 'Miscellanea';
$string['configsectionoperatingsystem'] = 'Sistema operativo';
$string['configsectionpermissions'] = 'Permessi';
$string['configsectionrequestedcourse'] = 'Richieste di corsi';
$string['configsectionsecurity'] = 'Sicurezza';
$string['configsectionstats'] = 'Statistiche';
$string['configsectionuser'] = 'Utente';
$string['configsecureforms'] = 'Moodle può utilizzare un livello aggiuntivo di sicurezza nell\'accettazione di dati provenienti da moduli web. Se attivata, la variabile HTTP_REFERER del browser è confrontata con l\'indirizzo del form attuale. In alcuni rari casi questo può causare problemi se l\'utente sta utilizzando un firewall (ad esempio Zonealarm) configurato per rimuovere HTTP_REFERER dal suo traffico web. Uno dei sintomi è rimanere \'bloccato\' su di un form. Se i vostri utenti dovessero avere problemi con la pagina di login (per esempio), potreste disabilitare questa impostazione, anche se questo può esporre il  sito ad attacchi con forzature di password. Se siete in dubbio, lasciate l\'impostazione su \'Si\'.';
$string['configsessioncookie'] = 'E\' possibile personalizzare il prefisso del cookie usato per identificare le sessioni di Moodle. Questa impostazione è opzionale ma è indispensabile se più istanze di Moodle girano sul medesimo sito web.';
$string['configsessioncookiedomain'] = 'Consente di cambiare il dominio dal quale provengono i cookie di Moodle. E\' utile per alcune personalizzazioni di Moodle (ad esempio plugin di autenticazione o di iscrizione) per le quali si rende necessario scambiare le informazioni di sessione con applicazioni web o con sotto domini. <strong>ATTENZIONE: si consiglia di lasciare l\'impostazione al suo default (vuoto) - valori errati potrebbero impedire qualsiasi login al sito.</strong>';
$string['configsessioncookiepath'] = 'E\' possibile personalizzare dove i browser inviano i cookie di Moodle. Potete specificare un sub folder del vostro sito web. In genere il default \'/\' dovrebbe andare bene.';
$string['configsessiontimeout'] = 'la sessione degli utenti autenticati che non svolgono attività per un dato periodo di tempo (ad esempio caricare pagine), viene conclusa automaticamente. Questa variabile specifica il tempo massimo di inattività oltre la quale la sessione sarà considerata conclusa.';
$string['configshowcommentscount'] = 'Visualizza il numero di commenti. Richiederà una query supplementare per visualizzare i link ai commenti.';
$string['configshowsiteparticipantslist'] = 'Tutti gli studenti di questo sito e i docenti del sito saranno mostrati nell\'elenco dei partecipanti. Chi è abilitato a visualizzare la lista dei partecipanti di questo sito?';
$string['configsitedefaultlicense'] = 'Licenza di default del sito';
$string['configsitedefaultlicensehelp'] = 'La licenza di default sarà quella usata per pubblicare contenuti in questo sito';
$string['configsitemailcharset'] = 'Tutte le email generate dal vostro sito saranno inviate utilizzando il set di caratteri impostato qui. Comunque ogni utente può personalizzarlo se è abilitata la prossima impostazione.';
$string['configsitemaxcategorydepth'] = 'Numero max. sotto categorie';
$string['configsitemaxcategorydepthhelp'] = 'Numero massimo visualizzabile di sotto categorie';
$string['configslasharguments'] = 'I file (immagini, upload, ecc) vengono distribuiti mediante uno script che utilizza gli \'slash arguments\' (la seconda opzione a fianco).
Questo metodo permette una migliore gestione dei files nella cache del browser o del proxy server.
Sfortunatamente alcuni server PHP non autorizzano questo metodo, perciò se avete problemi nel visualizzare files e/o immagini trasferiti (ad esempio le immagini del profilo utente), impostate la variabile con la prima opzione.';
$string['configsmartpix'] = 'Con questa impostazione, le icone sono gestite tramite uno script PHP che le cerca prima nel tema grafico corrente, poi in tutti i temi a livello superiore i quindi nella cartella di Moodle /pix. Questo riduce il bisogno di duplicare le immagini all\'interno dei temi, anche se con un piccolo costo di performance.';
$string['configsmtphosts'] = 'E\' possibile impostare il nome qualificato di uno o più server SMTP che Moodle utilizzerà per inviare mail (ad esempio mail.a.com\' oppure \'mail.a.com;mail.b.com\'). Per configurare una porta non di default (diversa dalla 25) è possibile utilizzare la sintassi [server]:[port] (ad esempio \'mail.a.com:587\'). In mancanza di server SMTP, Moodle utilizzerà  il metodo di spedizione mail predefinito in PHP.';
$string['configsmtpmaxbulk'] = 'Massimo numero di messaggi inviati per sessione SMTP. Raggruppare i messaggi può velocizzare l\'invio delle email. Valori inferiori a 2 forzano la creazione di una nuova sessione SMTP per ogni email.';
$string['configsmtpuser'] = 'Se avete specificato un server SMTP che richiede l\'autenticazione, indicate qui lo username e la password relativi.';
$string['configstartwday'] = 'Inizio settimana';
$string['configstatsfirstrun'] = 'Questa impostazione definisce, per la <b>prima elaborazione</b> delle statistiche dei log, da quanto indietro nel tempo devono essere elaborati i log. Se avete molto traffico e non avete un server dedicato, probabilmente non è una buona idea tornare troppo indietro nel tempo, l\'elaborazione potrebbe essere abbastanza lunga ed esosa in termini di risorse necessarie. (Notare che nell\'impostazione , 1 mese = 28 giorni. Nei grafici e nei report generati, 1 mese = 1 mese del calendario.)';
$string['configstatsmaxruntime'] = 'L\'elaborazione delle statistiche può essere abbastanza lunga. Utilizzate una combinazione di questo e del prossimo campo per definire quando farla partire e per quanto tempo.';
$string['configstatsmaxruntime2'] = 'L\'elaborazione delle statistiche può essere molto onerosa. Puoi specificare il tempo massimo consentito per accumulare un giorno di statistiche. Il numero massimo di giorni elaborati nell\'esecuzione di un cron è 31.';
$string['configstatsmaxruntime3'] = 'Definisce il tempo massimo consentito per l\'elaborazione delle statistiche di un giorno. Va tenuto presente che l\'elaborazione delle statistiche è molto onerosa per il server. Il numero massimo di giorni da elaborare tramite cron può essere definito sotto.';
$string['configstatsruntimedays'] = 'Definisce il numero massimo di giorni da elaborare. Se le statistiche sono aggiornate, viene elaborato solamente un giorno. Dovreste aggiustare questo parametro in funzione del carico sul server ed eventualmente ridurlo se sono preferibili elaborazioni più brevi.';
$string['configstatsruntimestart'] = 'A che ora il cron deve <b>avviare</b> l\'elaborazione delle statistiche?';
$string['configstatsuserthreshold'] = 'Specifica il numero minimo di utenti necessario per includere il corso nel computo delle statistiche.';
$string['configstrictformsrequired'] = 'Nelle maschere con campi obbligatori gli utenti non potranno inserire spazi bianchi o interruzioni di linea.';
$string['configstripalltitletags'] = 'Per consentire l\'uso di tag HTML nei nomi delle risorse e delle attività è necessario deselezionare questa opzione.';
$string['configsupportemail'] = 'Indirizzo email al quale  gli utenti del sito possono rivolgersi per richieste di assistenza (ad esempio, quando nuovi utenti creano il proprio account). Se il campo è lasciato vuoto, l\'email non verrà fornita nessuna email di supporto.';
$string['configsupportname'] = 'Il nome della persona o della organizzazione che fornisce supporto tramite email o sito web.';
$string['configsupportpage'] = 'Questo indirizzo web, per gli utenti di questo sito, sarà quello da linkare se si ha bisogno di assistenza (per esempio, quando nuovi utenti creano il proprio account). Se tale indirizzo è lasciato vuoto, non sarà fornito alcun link.';
$string['configthemedesignermode'] = 'Le immagini ed i CSS appartenenti al tema sono conservati nella cache del browser e del server per un periodo di tempo molto lungo. Se stai sviluppando od ottimizzando un tema, attiva questa impostazione utile anche per gli sviluppatori di codice. E\' anche possibile annullare manualmente la cache del tema nella pagina di selezione temi. ATTENZIONE: la modalità theme designer ha un impatto negativo sulle performance del server!';
$string['configthemelist'] = 'Permette di abbreviare il menu di selezione dei temi specificando i nomi dei temi separati da virgole.Lasciando il campo vuoto sarà possibile selezionare qualsiasi tema installato. Esempio: standard,orangewhite.';
$string['configtimezone'] = 'Questo è il fuso orario di default. E\' l\'unico fuso orario standard per la visualizzazione delle date - ogni utente nel profilo può scegliere il proprio fuso orario. Scegliendo "Ora locale del server", il fuso orario di default coinciderà con il fuso orario del sistema operativo che ospita il sito e tale impostazione sarà usata anche come valore di default nel profilo degli utenti. Anche l\'esecuzione del cron per svolgere alcune operazioni pianificate terrà conto del fuso orario di default.';
$string['configunzip'] = 'Indica il percorso del programma Unzip di decompressione dati (Solo per Unix). Se specificato, questo programma si occuperà  di spacchettare i files compressi lato server. Se lasciato in bianco, Moodle utilizzerà le proprie routine interne.';
$string['configuseblogassociations'] = 'Consente agli utenti di organizzare i propri blog associandoli ai cori ed ai moduli di attività.';
$string['configuseexternalyui'] = 'E\' possibile usare i file online disponibili sui server Yahoo&#145;s al posto dei file locali. ATTENZIONE: è necessaria la connessione ad internet, altrimenti AJAX smetterà di funzionare sul tuo sito.';
$string['configuserquota'] = 'Il numero massimo di byte che un utente può utilizzare per memorizzare file personali. {$a->bytes} bytes == {$a->displaysize}';
$string['configusetags'] = 'Abilita la funzionalità Tag nel sito.';
$string['configvariables'] = 'Variabili';
$string['configverifychangedemail'] = 'Abilita la funzione di verifica degli indirizzi di posta elettronica quando gli utenti nel loro profilo modificano l\'email. La verifica viene effettuata sulla base delle liste di domini presenti nelle impostazioni Domini di posta autorizzati e Domini di posta non autorizzati. Se questa impostazione è disabilitata, la verifica dei domini autorizzati verrà operata solo durante la creazione di nuovi account.';
$string['configvisiblecourses'] = 'Permette la visualizzazione e l\'accesso ai corsi presenti in categorie di corso nascoste.';
$string['configwarning'] = 'Fate attenzione a modificare queste impostazioni, valori anomali potrebbero causare problemi.';
$string['configxmlstrictheaders'] = 'L\'opzione permette di generare pagine  usando http headers e prolog XML, consentendo ai browser di visualizzare online gli errori XHTML. E\' utile esclusivamente per gli sviluppatori.';
$string['configyuicomboloading'] = 'L\'impostazione abilita il caricamento combinato ottimizzato dei file delle librerie YUI. Per motivi di performace l\'impostazione dovrebbe essere attiva nei siti in produzione.';
$string['configzip'] = 'Indica il percorso del programma Zip di compressione dati (Solo per Unix).
Se specificato, questo programma si occuperà  di creare archivi di files compressi lato server. Se lasciato in bianco, Moodle utilizzerà  le proprie routine interne.';
$string['confirmation'] = 'Conferma';
$string['confirmdeletecomments'] = 'Stai per eliminare commenti, vuoi proseguire ?';
$string['confirmed'] = 'Confermato';
$string['confirminstall'] = 'Si sta per installare il language pack ({$a}), siete sicuri?';
$string['convertformat'] = 'Output in formato <i>convert</i>';
$string['cookiehttponly'] = 'Solo cookies http';
$string['cookiesecure'] = 'Solo cookies sicuri';
$string['country'] = 'Paese di default';
$string['coursecontact'] = 'Gestori dei corsi';
$string['coursecontact_desc'] = 'E\' possibile indicare quali ruoli far comparire nella descrizione dei corsi. Affinché il nome di un utente compaia nella descrizione di un corso, l\'utente dovrà avere almeno uno dei ruoli qui specificati.';
$string['coursemgmt'] = 'Aggiungi/Modifica corsi';
$string['courseoverview'] = 'Panoramica sui corsi';
$string['courserequestnotify'] = 'Avvertire in caso di richieste';
$string['courserequestnotifyemail'] = 'L\'utente {$a->user} ha presentato richiesta per il corso {$a->link}';
$string['courserequests'] = 'Corsi che sono stati richiesti';
$string['courserequestspending'] = 'Richieste di nuovi corsi da approvare';
$string['courses'] = 'Corsi';
$string['coursesperpage'] = 'Corsi per pagina';
$string['creatornewroleid'] = 'Ruolo del creatore di corsi nei nuovi corsi';
$string['creatornewroleid_help'] = 'Se l\'utente non ha il privilegio di gestire nuovi corsi, allora verrà iscritto al corso con questo ruolo.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Esecuzione cron solamente da linea comando';
$string['cronerrorclionly'] = 'Spiacente, l\'accesso via internet a questa pagina web è stato disabilitato dall\'amministratore.';
$string['cronerrorpassword'] = 'Spiacente, non è stata fornita una password valida per accedere a questa pagina.';
$string['cron_help'] = 'Lo script con.php è utilizzato da alcuni moduli di Moodle per eseguire azioni periodiche, come ad esempio inviare mail dei nuovi interventi sui forum. E\' necessario disporre di un sistema in grado di eseguire il cron con regolarità ad esempio ogni 5 minuti.';
$string['cronremotepassword'] = 'Cron password per accesso remoto';
$string['cronwarning'] = 'Lo  <a href="cron.php">script della routine cron.php</a> non è stato lanciato nelle ultime 24 ore.';
$string['csvdelimiter'] = 'Delimitatore CSV';
$string['ctyperecommended'] = 'L\'installazione dell\'estensione opzionale ctype PHP è fortemente raccomandata per migliorare le performance del sito, specialmente se sono previste lingue non latine.';
$string['ctyperequired'] = 'L\'estensione ctype PHP è richiesta da Moodle, per migliorare le performance del sito e offrire compatibilità multilingua.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrecommended'] = 'L\'installazione della libreria opzionale cURL è fortemente raccomandata per usare il Moodle Networking.';
$string['curlrequired'] = 'L\'estensione PHP cURL è ora necessaria a Moodle per comunicare  con i repostory Moodle.';
$string['curltimeoutkbitrate'] = 'Bitrate da usare per calcolare il timeout del cURL (kbps)';
$string['curltimeoutkbitrate_help'] = 'L\'impostazione è utilizzata per calcolare il  timeout appropriato durante richieste cURL molto grandi. Il calcolo viene effettuato effettuando una request HTTP HEAD per conoscere la dimensione del contenuto. Impostando il valore a 0 , la request non verrà effettuata.';
$string['customcheck'] = 'Altri controlli';
$string['custommenu'] = 'Menu personalizzato';
$string['custommenuitems'] = 'Elementi menu personalizzato';
$string['datarootsecurityerror'] = '<p><strong>AVVISO PER LA SICUREZZA!</strong></p><p>La tua cartella dataroot directory è in una posizione sbagliata ed è esposta al web. Questo significa che tutti i tuoi file privati sono accessibili da chiunque nel mondo, e qualcuno di questi potrebbe essere usato da un cracker per ottenere un accesso non autorizzato come amministartore del tuo sito!</p>
<p><em>Devi</em> spostare la cartella dataroot ({$a}) in un\'altra posizione che non sia nella cartella pubblica per il web, e aggiornare di conseguenza l\'impostazione <code>$CFG->dataroot</code> nel tuo config.php.</p>';
$string['datarootsecuritywarning'] = 'La configurazione del tuo sito potrebbe non essere al sicuro. Accertati che la tua cartella dataroot ({$a}) non sia direttamente accessibile via web.';
$string['dbmigrate'] = 'Migrazione database Moodle';
$string['dbmigrateconnecerror'] = 'Non è possibile connettersi alla base dati specificata.';
$string['dbmigrateencodingerror'] = 'La base dati specificata è codificata come {$a} e non come richiesto (UNICODE/UTF8).<br /> Si prega di indicarne un\'altra.';
$string['dbmigratepostgres'] = 'Sembra che si stia utilizzando PostgreSQL come server della base dati. Per proseguire il processo di migrazione è necessario creare manualmente una nuova base dati con codifica "UNICODE" (PostgreSQL 7) o "UTF8" (PostgreSQL 8) per salvare i dati migrati. Si prega di inserire qui sotto le impostazioni della nuova base dati per continuare:';
$string['dbmigratewarning'] = 'Accertarsi di aver effettuato una copia di sicurezza del database prima di iniziare questa procedura. Se non sicuro su come fare, contatta l\'amministratore di sistema. Il tuo sito di Moodle verrà messo in modalità manutenzione dopo l\'inizio del processo di migrazione.';
$string['dbmigratewarning2'] = '<b>Attenzione: State per iniziare il processo di migrazione della base di dati. Siate certi che sulla vostra base di dati di Moodle sia stata effettuata una copia di sicurezza completa.</b>';
$string['dbmigrationdeprecateddb'] = '<strong>Questa base dati è stata migrata in una nuova base dati UTF8 e è deprecata. Si prega di modificare il file config.php e utilizzare la nuova base dati per questo moodle.</strong>';
$string['dbmigrationdupfailed'] = 'Duplicazione della base dati fallita questo errore possibile:<strong><pre>{$a}</pre></strong>';
$string['dbsessions'] = 'Usa il database per le informazioni di sessione';
$string['dbtest'] = 'Functional DB test';
$string['debug'] = 'Livello di debug';
$string['debugall'] = 'TUTTI: Visualizza i più significativi messaggi di debug del PHP';
$string['debugdeveloper'] = 'SVILUPPATORE: messaggi extra di debug per sviluppatori Moodle';
$string['debugdisplay'] = 'Visualizza messaggi di debug';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MINIMO: Visualizza solo gli errori irreversibili';
$string['debugnone'] = 'NESSUNO: Non visualizzare errori né warning';
$string['debugnormal'] = 'NORMALE: Visualizza errori, warning e notice';
$string['debugpageinfo'] = 'Visualizza le informazioni di pagina';
$string['debugsmtp'] = 'Debug per l\'invio di email';
$string['debugstringids'] = 'Visualizza la provenienza delle stringhe della lingua';
$string['debugvalidators'] = 'Visualizza i link ai validator';
$string['defaultallowedmodules'] = 'Moduli autorizzati per default';
$string['defaultcity'] = 'Città di default';
$string['defaultcity_help'] = 'La città utilizzata per default durante la creazione di nuovi account';
$string['defaulthomepage'] = 'Home page di default per gli utenti';
$string['defaultrequestcategory'] = 'Categoria per i corsi a richiesta';
$string['defaultsettinginfo'] = 'Default: {$a}';
$string['defaultuserroleid'] = 'Ruolo di default per tutti gli utenti';
$string['defaultvalues'] = 'Valori di default';
$string['deleteerrors'] = 'Elimina errori';
$string['deletefilterareyousure'] = 'Sei sicuro di voler eliminare il filtro \'{$a}\'';
$string['deletefilterareyousuremessage'] = 'Siete in procinto di eliminare il filtro \'{$a}\'. Sei sicuro di volerlo disinstallare?';
$string['deletefilterfiles'] = 'Tutti i dati associati al filtro \'{$a->filter}\' sono stati eliminati dal database. Per completare l\'eliminazione ed evitare che il filtro si re-installi automaticamente, devi eliminare anche la cartella {$a->directory} dal tuo server.';
$string['deleteincompleteusers'] = 'Elimina gli utenti con profilo non completato dopo';
$string['deleteqtypeareyousure'] = 'Sei sicuro di voler eliminare il tipo di domanda \'{$a}\'';
$string['deleteqtypeareyousuremessage'] = 'Siete in procinto di eliminare il tipo di domanda \'{$a}\'. Siete sicuri di voler disinstallare questo tipo di domande?';
$string['deleteunconfirmed'] = 'Elimina gli utenti non confermati dopo';
$string['deleteuser'] = 'Elimina l\'utente';
$string['deletingfilter'] = 'Eliminazione del filtro \'{$a}\'';
$string['deletingqtype'] = 'Eliminazione del tipo di domanda \'{$a}\'';
$string['density'] = 'Densità';
$string['denyemailaddresses'] = 'Domini di posta non autorizzati';
$string['development'] = 'Sviluppo';
$string['digestmailtime'] = 'Ora di invio dei messaggi di riepilogo';
$string['disableuserimages'] = 'Disabilita immagini profilo utente';
$string['displayerrorswarning'] = 'Abilitare l\'impostazione PHP <em>display_errors</em> non è raccomandato sui siti di produzione perché alcuni messaggi di errore potrebbero rivelare informazioni sensibili del tuo server.';
$string['displayloginfailures'] = 'Mostra i tentativi falliti di login a';
$string['docroot'] = 'URL del sito di documentazione di Moodle';
$string['doctonewwindow'] = 'Apri in una nuova finestra';
$string['download'] = 'Download';
$string['editennotallowed'] = 'La lingua en_utf8 non può essere modificata da questa pagina - commuta su locale';
$string['edithelpdocs'] = 'Modifica documenti di Help';
$string['editingnoncorelangfile'] = 'State cercando di modificare la traduzione di un modulo/plugin aggiuntivo. Le modifiche di moduli di terze parti possono essere salvate solamente nella cartella locale. In seguito si pu spostare il file con la traduzione nella cartella lang del modulo e/o si può mandare al responsabile del modulo aggiuntivo.';
$string['editlang'] = '<b>Modifica</b>';
$string['editorbackgroundcolor'] = 'Colore di sfondo';
$string['editordictionary'] = 'Dizionario per editor';
$string['editorfontfamily'] = 'Famiglia di font';
$string['editorfontlist'] = 'Elenco di font';
$string['editorfontsize'] = 'Dimensione font';
$string['editorhidebuttons'] = 'Pulsanti nascosti';
$string['editorkillword'] = 'Filtro Word';
$string['editorspelling'] = 'Spelling per editor';
$string['editorspellinghelp'] = 'Abilita o disabilita lo spell-checking. Se abilitato <strong>aspell</strong> deve essere installato sul server.';
$string['editstrings'] = 'Modifica parole o frasi';
$string['emailchangeconfirmation'] = 'Conferma cambio email';
$string['emoticonalt'] = 'Testo alternativo';
$string['emoticoncomponent'] = 'Componente immagine';
$string['emoticonimagename'] = 'Nome immagine';
$string['emoticons'] = 'Emoticon (faccine)';
$string['emoticons_desc'] = 'Il form presenta le faccine (emoticon) in uso nel sito. Per eliminare una riga, salva il form con il campo vuoto. Per aggiungere una faccina, inseriscila sull\'ultimo campo vuoto disponibile. Per reimpostare tutte le faccine, usa il link soprastante.

* Testo (obbligatorio) - Il testo sarà sostituito con la faccina. Il testo deve essere lungo almeno due caratteri.
* Nome immagine (obbligatorio) - Il nome del file contenente l\'immagine della faccina, senza estensione, relativo al folder pix del componente.
* Componente immagine (obbligatorio) - Il componente che fornisce l\'icona
* Testo alternativo (opzionale) - Identificativo della stringa e del componente del testo alternativo alla faccina.';
$string['emoticonsreset'] = 'Reimposta le impostazioni delle faccine ai valori di default';
$string['emoticontext'] = 'Testo';
$string['emptysettingvalue'] = 'Vuoto';
$string['enableajax'] = 'Abilita AJAX';
$string['enablecalendarexport'] = 'Abilita l\'esportazione del calendario';
$string['enablecomments'] = 'Abilita commenti';
$string['enablecourseajax'] = 'Abilita modifica AJAX corsi';
$string['enablecourseajax_desc'] = 'Consente di usare AJAX durante la modifica delle home page dei corsi. Da notare che il formato del corso ed il tema devono supportare AJAX e gli utenti devono abilitare AJAX nel proprio profilo.';
$string['enablecourserequests'] = 'Abilita Corsi a richiesta';
$string['enableglobalsearch'] = 'Abilita ricerca globale';
$string['enablegroupmembersonly'] = 'Abilita disponibilità agli appartenenti al raggruppamento';
$string['enablehtmlpurifier'] = 'Abilita HTML Purifier';
$string['enablerecordcache'] = 'Abilita cache dei record';
$string['enablerssfeeds'] = 'Abilita feed RSS';
$string['enablesafebrowserintegration'] = 'Abilita integrazione Safe Exam Browser';
$string['enablestats'] = 'Abilita statistiche';
$string['enabletrusttext'] = 'Abilita contenuto affidabile';
$string['enablewebservices'] = 'Abilita Web service';
$string['enablewsdocumentation'] = 'Documentazione web service';
$string['encoding'] = 'Codifica';
$string['enrolinstancedefaults'] = 'Default per le istanze del plugin di iscrizione';
$string['enrolinstancedefaults_desc'] = 'Le impostazioni di default del plugin di iscrizione quando si creano nuovi corsi.';
$string['enrolmultipleusers'] = 'Iscrivi gli utenti';
$string['environment'] = 'Ambiente';
$string['environmenterrortodo'] = 'Devi risolvere tutti i problemi ed errori riscontrati prima di procedere con l\'installazione della versione di Moodle selezionata.';
$string['environmenterrorupgrade'] = 'Attenzione: devono essere risolti tutti i problemi ambientali (errori) trovati prima di procedere con l\'aggiornamento di questa versione di Moodle! L\'aggiornamento senza la soluzione di questi requisiti potrebbe causare problemi come perdita di dati. Siete sicuri di continuare comunque con l\'aggiornamento?';
$string['environmentmustfixsetting'] = 'Le impostazioni del PHP devono essere modificate.';
$string['environmentok'] = 'Il tuo server possiede tutti i requisiti minimi necessari.';
$string['environmentrecommendcustomcheck'] = 'Se questo test non ha successo, esiste un potenziale problema.';
$string['environmentrecommendinstall'] = 'l\'installazione e attivazione è consigliata per ottenere migliori risultati';
$string['environmentrecommendversion'] = 'Versione minima consigliata: {$a->needed}.  Versione in uso: {$a->current}';
$string['environmentrequirecustomcheck'] = 'questo test deve passare con successo';
$string['environmentrequireinstall'] = 'E\' necessaria l\'installazione e attivazione';
$string['environmentrequireversion'] = 'Versione minima necessaria: {$a->needed}. Versione in uso: {$a->current}';
$string['environmentsettingok'] = 'Sono state riscontrate le impostazioni consigliate';
$string['environmentshouldfixsetting'] = 'Le impostazioni del PHP dovrebbero essere modificate.';
$string['environmentxmlerror'] = 'Errore durante la lettura dei dati dell\'ambiente ({$a->error_code})';
$string['errordeletingconfig'] = 'Si è verificato un errore durante l\'eliminazione del record di configurazion e della plugin \'{$a}\'.';
$string['errors'] = 'Errori';
$string['errorsetting'] = 'Non è possibile salvare l\'impostazione:';
$string['errorwithsettings'] = 'Alcune impostazioni non sonostate cambiate a causa di un errore';
$string['everyonewhocan'] = 'Chiunque possa \'{$a}\'';
$string['exceptions'] = 'eccezioni';
$string['excludeoldflashclients'] = 'Versione minima Flash player';
$string['experimental'] = 'Sperimentale';
$string['experimentalsettings'] = 'Impostazioni sperimentali';
$string['extendedusernamechars'] = 'Permetti l\'uso di caratteri speciali negli username';
$string['extramemorylimit'] = 'Extra PHP memory limit';
$string['extrauserselectorfields'] = 'Durante la selezione degli utenti, cerca e visualizza';
$string['fatalmagicquotesruntime'] = '<p>E\' stato rilevato un errore di configurazione grave, per favore avvertite l\'amministratore del server.</p><p> Per funzionare correttamente, Moodle ha bisogno che l\'amministratore modifichi le impostazioni del PHP..</p><p><code>magic_quotes_runtime</code> deve essere impostato ad <code>off</code>.</p><p>Potete modificare questa impostazione nel file <code>php.ini</code>, nella configurazione di Apache/IIS <br /> oppure usando file <code>.htaccess</code>.</p>';
$string['fatalsessionautostart'] = '<p>E\' stato rilevato un errore di configurazione grave, per favore avvertite l\'amministratore del server.</p><p> Per funzionare correttamente, Moodle ha bisogno che l\'amministratore modifichi le impostazioni del PHP..</p><p><code>session.auto_start</code> deve essere impostato ad <code>off</code>.</p><p>Potete modificare questa impostazione nel file <code>php.ini</code>, nella configurazione di Apache/IIS <br /> oppure usando file <code>.htaccess</code>.</p>';
$string['filecreated'] = 'Nuovo file creato';
$string['filestoredin'] = 'Salva il file nella cartella:';
$string['filestoredinhelp'] = 'Dove sarà memorizzato il file';
$string['filterall'] = 'Filtra tutte le stringhe';
$string['filtermatchoneperpage'] = 'Filtra occorrenze una volta per pagina';
$string['filtermatchonepertext'] = 'Filtra occorrenze una volta per testo';
$string['filters'] = 'Filtri';
$string['filtersettings'] = 'Gestione filtri';
$string['filtersettingsgeneral'] = 'Impostazioni generali filtro';
$string['filteruploadedfiles'] = 'Applica filtro sui file inviati';
$string['forcelogin'] = 'Imponi il login';
$string['forceloginforprofileimage'] = 'Obbliga gli utenti ad autenticarsi per vedere l\'immagine degli utenti';
$string['forceloginforprofileimage_help'] = 'Gli utenti dovranno autenticarsi per poter visualizzare le immagini contenute nel profilo personale degli altri utenti. Inoltre, in tutti i messaggi email verrà utilizzata l\'immagine standard.';
$string['forceloginforprofiles'] = 'Imponi il login per i profili';
$string['forcetimezone'] = 'Forza il fuso orario di default';
$string['framename'] = 'Nome del frame';
$string['frontpage'] = 'Pagina home';
$string['frontpagebackup'] = 'Backup';
$string['frontpagedefaultrole'] = 'Ruolo di default per la pagina home';
$string['frontpagefilters'] = 'Filtri';
$string['frontpageloggedin'] = 'Elementi della pagina home dopo il login';
$string['frontpageoverrides'] = 'Modifiche ai privilegi della Pagina home';
$string['frontpagequestions'] = 'Domande';
$string['frontpagerestore'] = 'Ripristino';
$string['frontpageroles'] = 'Ruoli';
$string['frontpagesettings'] = 'Impostazioni';
$string['fullnamedisplay'] = 'Formato del nome completo';
$string['gdrecommended'] = 'L\'estensione GD è utilizzata per la conversione di immagini. In assenza, alcune funzioni come le immagini dei profili utente non non saranno disponibili.';
$string['gdversion'] = 'Versione GD';
$string['generalsettings'] = 'Impostazioni generali';
$string['geoipfile'] = 'File dati GeoIP City';
$string['getremoteaddrconf'] = 'Sorgente degli indirizzi IP logged';
$string['globalsquoteswarning'] = '<p><strong>Avviso per la Sicurezza</strong>: per funzionare correttamente, Moodle necessita<br />che vengano fatte alcune modifiche alle vostre impostazioni del PHP.</p><p><em>Dovete</em> impostare <code>register_globals=off</code> e/o <code>magic_quotes_gpc=on</code>.<br />Se possibile, dovete impostare <code>register_globals=off</code> per migliorare la sicurezza generale del server,<br /> anche impostare <code>magic_quotes_gpc=on</code> è raccomandato.<p/><p>Queste impostazioni sono controllate modificando il vostro <code>php.ini</code>, la configurazione di Apache/IIS <br />o il file <code>.htaccess</code>.</p>';
$string['globalswarning'] = '<p><strong>Avviso per la sicurezza</strong>: per funzionare correttamente, Moodle richiede <br />alcune modifiche alle attuali impostazioni del PHP.<p/><p><em>Bisogna</em> impostare <code>register_globals=off</code>.<p>Questa impostazione può essere modificata editando il vostro <code>php.ini</code>, la configurazione Apache/IIS <br />o il file <code>.htaccess</code>.</p>';
$string['googlemapkey'] = 'Google Maps API key';
$string['gotofirst'] = 'Vai alla prima stringa mancante';
$string['gradebook'] = 'Registro valutazioni';
$string['gradebookroles'] = 'Ruoli riportati nel registro';
$string['gradeexport'] = 'Formati preferiti per l\'esportazione delle valutazioni';
$string['groupenrolmentkeypolicy'] = 'Regole chiavi iscrizione ai gruppi';
$string['groupenrolmentkeypolicy_desc'] = 'Attiva le stesse regole delle password per le chiavi di iscrizione ai gruppi.';
$string['guestroleid'] = 'Ruolo per gli ospiti';
$string['guestroleid_help'] = 'Questo ruolo viene assegnato automaticamente agli ospiti. Viene anche assegnato temporaneamente a quegli utenti che pur non iscritti ad un corso vi accedono tramite il plugin iscrizione ospiti.';
$string['helpadminseesall'] = 'Nel calendario agli amministratori saranno visualizzati i soli eventi che li riguardano.';
$string['helpcalendarsettings'] = 'Configura vari aspetti in Moodle relativi al calendario, alle date, alle durate.';
$string['helpforcetimezone'] = 'Potete autorizzare gli utenti a selezionare il proprio fuso orario, oppure imporre a tutti gli utenti l\'uso dello stesso fuso orario.';
$string['helpsitemaintenance'] = 'Per aggiornamenti e altro lavoro.';
$string['helpstartofweek'] = 'Il giorno con cui inizia la settimana';
$string['helpupcominglookahead'] = 'Valore predefinito del numero di giorni futuri dove il calendario cercherà i prossimi eventi.';
$string['helpupcomingmaxevents'] = 'Valore predefinito del numero massimo di eventi prossimi da visualizzare.';
$string['helpweekenddays'] = 'I giorni del weekend saranno visualizzati nel calendario con un colore diverso.';
$string['hiddenuserfields'] = 'Nascondi i campi utente';
$string['hidefromall'] = 'Nascondi a tutti gli utenti';
$string['hidefromnone'] = 'Non nascondere a nessuno';
$string['hidefromstudents'] = 'Nascondi agli studenti';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Impostazioni editor HTML';
$string['htmlsettings'] = 'Impostazioni HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Sicurezza HTTP';
$string['iconvrecommended'] = 'Installare la libreria opzionale ICONV è fortemente consigliato per migliorare le prestazioni, in particolare se il vostro sito usa lingue non latine.';
$string['iconvrequired'] = 'E\' necessario installare l\'estensione ICONV.';
$string['ignore'] = 'Ignora';
$string['importlangreminder'] = 'Il processo di migrazione della base di dati sta per iniziare. Sarà necessario effettuare <b>nuovamente il login</b> perché l\'aggiornamento faccia effetto. Siete pregati di installare i language pack unicode il più presto possibile attraverso Amministrazione->Lingua->Utilità di Importazione Lingue <b>dopo</b> che il processo sia completato.';
$string['importtimezones'] = 'Aggiorna l\'elenco dei fusi orari';
$string['importtimezonescount'] = '{$a->count} fusi orari aggiornati da {$a->source}';
$string['importtimezonesfailed'] = 'Non è stata trovata nessuna sorgente! (Brutta notizia)';
$string['includemoduleuserdata'] = 'Includi i dati utente presenti nei moduli';
$string['incompatibleblocks'] = 'Blocchi non compatibili';
$string['install'] = 'Installa i Language Pack selezionati';
$string['installedlangs'] = 'Language pack installati';
$string['installhijacked'] = 'Spiacente, l\'installazione deve essere completata dallo stesso indirizzo IP dal quale è stata avviata.';
$string['installsessionerror'] = 'Non è possibile inizializzare la sessione PHP, per favore verificate che il vostro browser accetti i cookie.';
$string['intcachemax'] = 'Int. cache max';
$string['intlrecommended'] = 'L\'estensione intl migliora il supporto all\'internazionalizzazione, come l\'ordinamento in accordo alle impostazioni locali';
$string['invalidlangpack'] = 'per modificare questo language pack, dovete inserirlo nel folder delle lingue.';
$string['invalidsection'] = 'Sezione non valida';
$string['invaliduserchangeme'] = 'Il nome utente "changeme" è riservato - non è possibile creare utenti con quel nome utente.';
$string['ipblocked'] = 'Questo sito non è al momento disponibile.';
$string['ipblocker'] = 'Blocco IP';
$string['ipblockersyntax'] = 'Inserisci un IP per ogni linea. E\' possibile inserire un indirizzo IP completo (ad esempio <b>192.168.10.1</b>) per un singolo host, oppure un indirizzo IP parziale (ad esempio <b>192.168.</b>) per tutti gli indirizzi che iniziano con questi numeri. E\' anche possibile usare la notazione CIDR (ad esempio <b>231.54.211.0/20</b>) oppure un intervallo (ad esempio <b>231.3.56.10-20</b>), dove l\'intervallo è specificato dalle ultime quattro cifre. I nomi a dominio non sono supportati. Le linee vuote non sono utilizzate.';
$string['iplookup'] = 'Ricerca indirizzo IP';
$string['iplookupinfo'] = 'Per default Moodle usa il server online gratuito NetGeo (The Internet Geographic Database) per cercare le località degli indirizzi IP. Sfortunatamente questo server non è più aggiornato e può rispondere con dati <em>non corretti</em>. Si raccomanda di installare localmente una copia del database gratuito GeoLite City da MaxMind.<br/>
Le località degli indirizzi IP sono mostrate su una semplice mappa o usando Google Maps. Notare che bisogna avere un Google account e richiedere una Google Maps API key gratuita per abilitare le mappe interattive.';
$string['iplookupmaxmindnote'] = 'Questo prodotto include dati GeoLite creati da MaxMind, disponibili su <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['iplookupnetgeonote'] = 'Al momento è utilizzato il server NetGeo per la ricerca delle informazioni geografiche. Per ottenere risultati più accurati si raccomanda l\'installazione locale di una copia del MaxMind GeoLite database.';
$string['jabber'] = 'Jabber';
$string['jabberhost'] = 'Host Jabber';
$string['jabberpassword'] = 'Password Jabber';
$string['jabberport'] = 'Porta Jabber';
$string['jabberserver'] = 'Server Jabber';
$string['jabberusername'] = 'User name Jabber';
$string['keeptagnamecase'] = 'Caratteri nomi Tag originali';
$string['lang'] = 'Lingua di default';
$string['lang16notify'] = 'Moodle 1.6 e le versioni successive permettono di installare e aggiornare i language pack direttamente da download.moodle.org seguendo il link sottostante.';
$string['langcache'] = 'Cache del menu delle lingue';
$string['langcache_desc'] = 'Cache del menu del lingue. Permette di avere in cahce l\'elenco delle traduzioni disponibili. La cache viene aggiornata tutte le volte che si installa o si elimina in language pack tramite il gestore dei language pack di Moodle. Se installi un language pack a mano, per aggiornare la cache dovrai ricordarti di usare la funzione "Svuota tutte le cache".';
$string['langedit'] = 'Modifica lingua';
$string['langimport'] = 'Utility di importazione lingua';
$string['langimportdisabled'] = 'La funzione di importazione dei language pack è stata disabilitata. I tuoi language pack devono essere aggiornati manualmente a livello di file system.';
$string['langimportsuccess'] = 'Language pack aggiornato correttamente';
$string['langlist'] = 'Lingue sul menu delle lingue';
$string['langlocalpackage'] = 'Modifiche locali';
$string['langmasterenglish'] = 'English pack principale';
$string['langmasterpackage'] = 'Language pack principale';
$string['langmenu'] = 'Mostra il menu delle lingue';
$string['langnoeditenglish'] = 'Non è possibile modificare il language pack inglese di base. Puoi apportare modifiche locali cambiando la cartella della lingua';
$string['langpackinstalled'] = 'Il language pack {$a} è stato installato con successo';
$string['langpackmaintaining'] = 'Gestione language pack';
$string['langpackremoved'] = 'Rimozione Language Pack completata';
$string['langpacks'] = 'Language pack';
$string['langpackupdated'] = 'Language pack {$a} aggiornato correttamente';
$string['langpackupdateskipped'] = 'Aggiornamento del language pack {$a} saltato';
$string['langpackwillbeupdated'] = 'NOTA: Durante l\'aggiornamento, Moodle cercherà di aggiornare il language pack in uso.';
$string['langrmyourself'] = 'Per impedire perdita di dati, lang.php non è in grado di scrivere contenuti vuoti su file esistenti. Rimuovere il file manualmente per evitare questo.';
$string['langstringcache'] = 'Usa la cache per tutte le stringhe delle lingue';
$string['languagesettings'] = 'Impostazioni lingua';
$string['langupdatecomplete'] = 'Aggiornamento Language pack completato';
$string['latexpreamble'] = 'Preambolo LaTex';
$string['latexsettings'] = 'Impostazioni di rendering LaTex';
$string['latinexcelexport'] = 'Codifica Excel';
$string['legacyfilesinnewcourses'] = 'File del corso legacy per i nuovi corsi';
$string['legacyfilesinnewcourses_help'] = 'Per default l\'area legacy file del corso è disponibile solamente nei corsi migrati da versioni precedenti. Si precisa che alcune funzionalità, ad esempio bil backup/ripristino di singole attività non sono compatibili con questa impostazione';
$string['licensesettings'] = 'Impostazioni licenza';
$string['loading'] = 'Caricamento in corso';
$string['localetext'] = 'Localizzazione del sito';
$string['localstringcustomization'] = 'Personalizzazione locale stringhe';
$string['location'] = 'Localizzazione';
$string['locationsettings'] = 'Impostazioni';
$string['locked'] = 'bloccato';
$string['log'] = 'Log';
$string['logguests'] = 'Log di accesso ospite';
$string['logguests_help'] = 'L\'impostazione abilita il log delle azioni svolte dall\'account ospite e dagli utenti non autenticati. Siti molto trafficati potrebbero disabilitare il log per motivi di performance.Nei siti di produzione si raccomanda di mantenere log di accesso ospite abilitato.';
$string['loginhttps'] = 'Usa HTTPS per i login';
$string['loginpasswordautocomplete'] = 'Evita auto completamento password nella schermata di login';
$string['loginpasswordautocomplete_help'] = 'Nella schermata di autenticazione il campo password avrà l\'auto completamento disabilitato. Da notare che questa impostazione non è compatibile con la validazione XHTML strict.';
$string['loglifetime'] = 'Conserva i log per';
$string['longtimewarning'] = '<b>Da notare che questo processo può durare molto tempo.</b>';
$string['mail'] = 'Email';
$string['mailnewline'] = 'Caratteri Newline nelle email';
$string['maintenancemode'] = 'In modalità manutenzione';
$string['maintfileopenerror'] = 'Errore aprendo i file di manutenzione!';
$string['maintinprogress'] = 'Manutenzione in corso...';
$string['managelang'] = 'Gestione';
$string['managelicenses'] = 'Gestione licenze';
$string['manageqtypes'] = 'Gestione tipi domande';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release candidate';
$string['maturity200'] = 'Versione stabile';
$string['maturity50'] = 'Alfa';
$string['maturitycorewarning'] = 'Stai per installare o aggiornare Moodle alla versione "{$a}".
Non trattandosi di una versione pronta per andare in produzione, accertati che tu voglia effetivamente installare/aggiornare a questa versione e che tu abbia effettuato il checkout della versione desiderata del codice sorgente di Moodle.';
$string['maxbytes'] = 'Dimensione massima upload';
$string['maxconsecutiveidentchars'] = 'Caratteri identici consecutivi';
$string['maxeditingtime'] = 'Tempo massimo per l\'editing dei messaggi';
$string['mbstringrecommended'] = 'Installare la libreria opzionale MBSTRING è fortemente consigliato per migliorare le prestazioni, in particolare se il sito usa lingue non latine.';
$string['mediapluginavi'] = 'Abilita filtro .avi';
$string['mediapluginflv'] = 'Abilita filtro .flv';
$string['mediapluginimg'] = 'Abilita auto embed di immagini collegate';
$string['mediapluginmov'] = 'Abilita filtro .mov';
$string['mediapluginmp3'] = 'Abilita filtro .mp3';
$string['mediapluginmpg'] = 'Abilita filtro .mpg';
$string['mediapluginogg'] = 'Abilita filtro .ogg';
$string['mediapluginogv'] = 'Abilita filtro .ogv';
$string['mediapluginram'] = 'Abilita filtro .ram';
$string['mediapluginrm'] = 'Abilita filtro .rm';
$string['mediapluginrpm'] = 'Abilita filtro .rpm';
$string['mediapluginswf'] = 'Abilita filtro .swf';
$string['mediapluginswfnote'] = 'Come misura di sicurezza, gli utenti normali non dovrebbero essere autorizzati ad includere file swf flash';
$string['mediapluginwmv'] = 'Abilita filtro .wmv';
$string['mediapluginyoutube'] = 'Abilita filtro link YouTube';
$string['memcachedhosts'] = 'memcached host';
$string['memcachedpconn'] = 'memcached use persistent connections';
$string['messaging'] = 'Abilita il sistema di messaging';
$string['messagingdeletereadnotificationsdelay'] = 'Elimina notifiche lette';
$string['messaginghidereadnotifications'] = 'Nascondi notifiche lette';
$string['minpassworddigits'] = 'Cifre';
$string['minpasswordlength'] = 'Lunghezza password';
$string['minpasswordlower'] = 'Lettere minuscole';
$string['minpasswordnonalphanum'] = 'Caratteri non alfanumerici';
$string['minpasswordupper'] = 'Lettere maiuscole';
$string['misc'] = 'Generale';
$string['missinglangparent'] = 'Manca il parent language <em>{$a->parent}</em> of <em>{$a->lang}</em>.';
$string['mnetrestore_extusers'] = '<strong>Nota:</strong> Questo file di backup contiene registrazioni di utenti di Moodle remoti in rete che saranno restorate come parte del processo.';
$string['mnetrestore_extusers_admin'] = '<strong>Nota:</strong> Questo file di backup sembra essere stato generato da un\'altra installazione di Moodle e contiene account di utenti Moodle Network. Il processo di ripristino tenterà di associare gli host Moodle Network a ciascun utente da creare. Gli utenti per i quali non sarà possibile l\'associazione, saranno configurati con l\'autenticazione interna al posto della autenticazione mnet. I log del ripristino conterrà informazioni al riguardo.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Nota:</strong> Questo file di backup sembra essere stato generato da un\'altra installazione di Moodle e contiene account di utenti Moodle Network il cui ripristino potrebbe non andare a buon fine. Questa operazione non è supportata. Se siete sicuri che il backup è stato creato su questa installazione di Moodle, o siete certi che tutti gli host Moodle Network sono configurati, allora potete provare ad eseguire il ripristino.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Nota:</strong> Questo file di backup sembra essere stato generato da un\'altra installazione di Moodle e contiene account di utenti Moodle Network. Non sei autorizzato ad eseguire questo tipo di ripristino. Contatta l\'amministratore del sito oppure ripristina il corso senza informazioni sugli utenti (moduli, file...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Il metodo di autenticazione dell\'utente remoto {$a->username} (proveniente da {$a->mnethosturl}) è stato cambiato in autenticazione {$a->auth} locale.';
$string['modeditdefaults'] = 'Valori di default dell\'attività';
$string['modsettings'] = 'Gestione attività';
$string['modulesecurity'] = 'Restrizioni sui Moduli';
$string['multilangforceold'] = 'Forza la vecchia sintassi multilingua: &lt;span&gt; senza la class="multilang" e &lt;lang&gt;';
$string['multilangupgrade'] = 'Aggiornamento multilingua';
$string['multilangupgradeinfo'] = 'La sintassi del filtro multilingua è cambiata dalla 1.8, il tag &lt;lang&gt; non è più supportato. <br /><br />Esempio: &lt;span lang="en" class="multilang">Hello!&lt;/span&gt;&lt;span lang="it" class="multilang">Ciao!&lt;/span&gt;<br /><br /><strong>Vuoi aggiornare la sintassi in tutti i testi esistenti ora?</strong>';
$string['multilangupgradenotice'] = 'Il tuo sito probabilmente sta utilizzando la vecchia sintassi multilingua, <a href="multilangupgrade.php">multilang upgrade</a> è raccomandato.';
$string['mustenablestats'] = 'Le statistiche non sono ancora attivate su questo sito';
$string['mycoursesperpage'] = 'Numero di corsi';
$string['mydashboard'] = 'Dashboard di sistema di default';
$string['mymoodle'] = 'My Moodle';
$string['mymoodleredirect'] = 'Obbliga gli utenti a usare My Moodle';
$string['mypage'] = 'Pagina My Moodle di default';
$string['mypagelocked'] = 'Blocca pagina di default';
$string['myprofile'] = 'Pagina profilo di default';
$string['mysql416bypassed'] = 'Comunque, se il vostro sito sta utilizzando SOLO lingue iso-8859-1 (latin), potete continuare ad utilizzare MySQL 4.1.12 (o successivo) attualmente installato.';
$string['mysql416required'] = 'MySQL 4.1.16 è la versione minima richiesta per Moodle 1.6 per garantire che tutti i dati possano essere convertiti in UTF-8 in futuro.';
$string['navcourselimit'] = 'Max. corsi';
$string['navigationupgrade'] = 'Questo aggiornamento introduce due nuovi blocchi per la navigazione che andranno a sostituire i seguenti blocchi: Amministrazione, Corsi, Attività e Partecipanti. Se hai configurato questi blocchi con privilegi particolari, dovrai verificare che tutto funzioni come atteso.';
$string['navshowallcourses'] = 'Visualizza tutti i corsi';
$string['navshowcategories'] = 'Visualizza categorie di corso';
$string['neverdeleteruns'] = 'Non eliminare i run';
$string['nobookmarksforuser'] = 'Non hai alcun segnalibro';
$string['nochanges'] = 'Nessuna modifica';
$string['nodatabase'] = 'Nessun database';
$string['nolangupdateneeded'] = 'Tutti i language pack sono aggiornati, non sono necessari ulteriori aggiornamenti';
$string['nomissingstrings'] = 'Non ci sono stringhe mancanti';
$string['nonewsettings'] = 'Questo aggiornamento non include nuove impostazioni';
$string['nonexistentbookmark'] = 'Il segnalibro richiesto non esiste';
$string['noreplyaddress'] = 'Indirizzo No-reply';
$string['noresults'] = 'Nessun risultato';
$string['noroles'] = 'Nessun ruolo';
$string['notifications'] = 'Avvisi';
$string['notifyloginfailures'] = 'Indirizzo di email per gli avvisi sui tentativi falliti di login';
$string['notifyloginthreshold'] = 'Soglia per l\'invio di avvisi tramite email';
$string['notloggedinroleid'] = 'Ruolo per i visitatori';
$string['numberofmissingstrings'] = 'Numero stringhe mancanti: {$a}';
$string['numberofstrings'] = 'Totale stringhe: {$a->strings}<br />Mancanti: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['numcoursesincombo'] = 'Numero max. di corsi presenti nel menu a discesa';
$string['numcoursesincombo_help'] = 'Il menu a discesa non funziona bene quando contiene un numero di corsi molto elevato. Se il numero di corsi presenti nel sito supera il valore impostato, allora sarà visualizzato un link ad un elenco di corsi, senza visualizzare tutti i corsi nella pagina home.';
$string['numquestions'] = 'Num. domande';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} nascoste)';
$string['opensslrecommended'] = 'E\' fortemente raccomandata l\'installazione della libreria opzionale OpenSSL -- questa abilita la funzionalità Moodle Networking.';
$string['opentogoogle'] = 'Aperto a Google';
$string['optionalmaintenancemessage'] = 'Messaggio opzionale per la  modalità manutenzione';
$string['order1'] = 'Primo';
$string['order2'] = 'Secondo';
$string['order3'] = 'Terzo';
$string['order4'] = 'Quarto';
$string['passwordpolicy'] = 'Regole password';
$string['pathconvert'] = 'Percorso per l\'eseguibile <i>convert</i>';
$string['pathdvips'] = 'Percorso per l\'eseguibile <i>dvips</i>';
$string['pathlatex'] = 'Percorso per l\'eseguibile <i>latex</i>';
$string['pathtoclam'] = 'Percorso per clam AV';
$string['pathtodot'] = 'Percorso per dot';
$string['pathtodot_help'] = 'Percorso assoluto per l\'eseguibile dot, del tipo /usr/bin/dot. Per generare grafici a partire dai file DOT, è necessario installare l\'eseguibile dot e configurare il percorso. Da notare che per il momento dot è usato solamente per le funzioni di profilazione presenti in Moodle (Sviluppo->Profilazione)';
$string['pathtodu'] = 'Percorso per du';
$string['pathtopgdump'] = 'Percorso per pg_dump';
$string['pathtopgdumpdesc'] = 'Questo è solamente necessario se avete più di un pg_dump sul vostro sistema (per esempio avete più versioni di postgresql installate)';
$string['pathtopgdumpinvalid'] = 'Percorso non valido per pg_dump - percorso errato o non eseguibile';
$string['pathtopsql'] = 'Path per psql';
$string['pathtopsqldesc'] = 'Questo è solamente necessario se avete più di un pgsql sul vostro sistema (per esempio avete più versioni di postgresql installate)';
$string['pathtopsqlinvalid'] = 'Percorso non valido per pgsql - percorso errato o non eseguibile';
$string['pathtounzip'] = 'Percorso per unzip';
$string['pathtozip'] = 'Percorso per zip';
$string['perfdebug'] = 'Visualizza prestazioni';
$string['performance'] = 'Prestazioni';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'Parametro per le operazioni a linea di comando della versione/cluster di PostgreSQL. Se hai un solo postgresql sul sistema o non sei sicuro di cosa significhi, lascialo vuoto.';
$string['php50restricted'] = 'PHP 5.0.x ha diversi problemi conosciuti, si prega di aggiornare alla versione 5.1.x o tornare alle versioni 4.3.x o 4.4.x';
$string['php533warning'] = 'Si raccomanda l\'uso di PHP 5.3.3 o versione successiva';
$string['phpfloatproblem'] = 'E\' stato rilevato un problema inatteso durante l\'utilizzo di numeri a virgola mobile tramite PHP - {$a}';
$string['pleaserefreshregistration'] = 'Questo sito è stato registrato con moodle.org. Ricorda di aggiornare la registrazione se sono state apportate modifiche significative dall\'ultimo aggiornamento, avvenuto il {$a}';
$string['pleaseregister'] = 'Registrando il vostro sito questo pulsante verrà  rimosso';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugin';
$string['profilecategory'] = 'Categoria';
$string['profilecategoryname'] = 'Nome categoria (deve essere unico)';
$string['profilecategorynamenotunique'] = 'Nome categoria già in uso';
$string['profilecommonsettings'] = 'Impostazioni comuni';
$string['profileconfirmcategorydeletion'] = 'Questa categoria contiene {$a} campo/i. Eliminando la categoria, i campi saranno spostati nella categoria immediatamente superiore (oppure in quella immediatamente inferiore se state eliminando la categoria nella posizione più alta).<br/>Siete certi di voler eliminare questa categoria?';
$string['profileconfirmfielddeletion'] = 'Sono presenti {$a} record che contengono valori per questo campo. Eliminando il campo questi i valori saranno perduti.<br/>Siete certi di voler eliminare questo campo?';
$string['profilecreatecategory'] = 'Crea una categoria per i campi personalizzati';
$string['profilecreatefield'] = 'Crea un campo personalizzato:';
$string['profilecreatenewcategory'] = 'Creazione di una categoria per i campi personalizzati';
$string['profilecreatenewfield'] = 'Creazione di un campo personalizzato "{$a}"';
$string['profiledefaultcategory'] = 'Altri campi';
$string['profiledefaultchecked'] = 'Questo campo Checkbox per default è spuntato';
$string['profiledefaultdata'] = 'Valore di default';
$string['profiledeletecategory'] = 'Eliminazione di una categoria';
$string['profiledeletefield'] = 'Eliminazione di un campo';
$string['profiledescription'] = 'Descrizione del campo';
$string['profiledscript'] = 'Lo script è stato profilato';
$string['profiledscriptview'] = 'Visualizza le informazioni di profilazione dello script';
$string['profileeditcategory'] = 'Modifica categoria: {$a}';
$string['profileeditfield'] = 'Modifica campo personalizzato: {$a}';
$string['profilefield'] = 'Campi personalizzati';
$string['profilefieldcolumns'] = 'Colonne';
$string['profilefieldispassword'] = 'E\' un campo password?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Per trasformare un testo in un link, inserisci un URL contenente $$, dove $$ sarà sostituita dal testo. Ad esempio per trasformare un ID Twitter in in link, inserisci http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Link target';
$string['profilefieldmaxlength'] = 'Numero massimo caratteri';
$string['profilefieldrows'] = 'Righe';
$string['profilefields'] = 'Campi personalizzati';
$string['profilefieldsize'] = 'Numero caratteri visualizzati';
$string['profileforceunique'] = 'I dati devono essere univoci?';
$string['profileinvaliddata'] = 'Valore non valido';
$string['profilelocked'] = 'Campo bloccato?';
$string['profilemenudefaultnotinoptions'] = 'Il valore default non è una delle opzioni';
$string['profilemenunooptions'] = 'Nessuna opzione menu inserita';
$string['profilemenuoptions'] = 'Opzioni menu (una per riga)';
$string['profilemenutoofewoptions'] = 'Devi inserire almeno 2 opzioni';
$string['profilename'] = 'Nome';
$string['profilenofieldsdefined'] = 'Non ci sono campi personalizzati';
$string['profilerequired'] = 'Compilazione obbligatoria?';
$string['profileroles'] = 'Ruoli visibili nel profilo';
$string['profilesforenrolledusersonly'] = 'Profili utente visibili solo agli iscritti ai corsi';
$string['profileshortname'] = 'Nome abbreviato (univoco)';
$string['profileshortnamenotunique'] = 'Nome abbreviato già in uso';
$string['profilesignup'] = 'Da compilare nella pagina di creazione account?';
$string['profilespecificsettings'] = 'Impostazioni specifiche';
$string['profilevisible'] = 'A chi è visibile il campo?';
$string['profilevisibleall'] = 'Visibile a tutti';
$string['profilevisible_help'] = '<p>Ad ogni campo creato dall\'utente può essere assegnata una impostazione di visibilità: non visibile, visibile a tutti, visibile all\'utente. L\'impostazione \'non visibile\' sarà normalmente assegnata da un amministratore che vuole mantenere dati privati riguardanti gli utenti. L\'impostazione \'visibile all\'utente\' sarà di solito scelta per un campo contenente informazioni sensibili, mentre \'visibile a tutti\' potrà essere utilizzata per ogni tipo di informazione.
</p>';
$string['profilevisiblenone'] = 'Non visibile';
$string['profilevisibleprivate'] = 'Visibile all\'utente';
$string['profiling'] = 'Profilazione';
$string['profilingallowall'] = 'Profilazione continua';
$string['profilingallowall_help'] = 'L\'impostazione permette di usare ovunque (PGC) il parametro PROFILELALL, volto  alla profilazione di tutti gli script eseguiti durante la sessione Moodle. Per fermare la profilazione è possibile usare il parametro PROFILESTOP.';
$string['profilingallowme'] = 'Profilazione selettiva';
$string['profilingallowme_help'] = 'L\'impostazione permette di usare selettivamente (PGC) il parametro PROFILEME per profilare specifici script. Per fermare la profilazione è possibile usare il parametro DONTPROFILEME.';
$string['profilingautofrec'] = 'Profilazione automatica';
$string['profilingautofrec_help'] = 'L\'impostazione attiverà la profilazione automatica e casuale di richieste (basata sulla frequenza impostata, 1 su XXX). I risultati saranno memorizzati per successive analisi. Da notare che questo tipo di profilazione tiene conto delle impostazioni di include/exclude. Il valore 0 disabilita la profilazione automatica ';
$string['profilingenabled'] = 'Abilita profilazione';
$string['profilingenabled_help'] = 'L\'imposatzione abilita le funzioni di profilazione, il cui comportamento può essere regolato con le impostazioni che segiuono';
$string['profilingexcluded'] = 'Escludi profilazione';
$string['profilingexcluded_help'] = 'Elenco di URL (separato da virgole, esclusi wwwroot assoluti, richimabili) che saranno escluse dalla profilazione rispetto a quelle definite nell\'impostazione "Profile queste"';
$string['profilingincluded'] = 'Profila questi';
$string['profilingincluded_help'] = 'Elenco di URL (assolute, senza wwwroot, raggiungibili, ) separato da virgole da profilare automaticamente. Esempio: /index.php, /course/view.php. E\' anche possibile specificare il carattere jolly * in qualsiasi posizione. Esempio: mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Mantieni profiling run';
$string['profilinglifetime_help'] = 'Imposta il periodo di conservazione dei profiling run precedenti. I run più vecchi saranno periodicamente eliminati. Da notare che i run di riferimento non saranno eliminati.';
$string['protectusernames'] = 'Proteggi gli username';
$string['proxybypass'] = 'Proxy bypass host';
$string['proxyhost'] = 'Proxy host';
$string['proxypassword'] = 'Proxy password';
$string['proxyport'] = 'Porta proxy';
$string['proxytype'] = 'Tipo proxy';
$string['proxyuser'] = 'Proxy username';
$string['purgecaches'] = 'Svuota le cache';
$string['purgecachesconfirm'] = 'Moodle può tenere in cache temi, javascript, stringhe di lingua, testo filtrato, feed rss ed altri tipi di dati. Svuotando le cache i dati saranno eliminati dal server e il browser verrà costretto a ricaricarli, in questo modo potrai essere certo di visualizzare i dati più aggiornati. Svuotare le cache non presenta rischi, tuttavia il sito potrebbe subire un rallentamento fino a quando le cache non saranno ripristinate. ';
$string['purgecachesfinished'] = 'Tutte le cache sono state svuotate';
$string['qtypedeletefiles'] = 'Tutti i dati associati al tipo di domanda  \'{$a->qtype}\' sono stati eliminati dal database. Per completare l\'eliminazione ed evitare che il tipo di domanda si re-installi automaticamente, devi eliminare anche la cartella {$a->directory} dal tuo server.';
$string['qtyperqpwillberemoved'] = 'Durante l\'aggiornamento, il tipo di domanda RQP sarà rimosso. Il sito non ha utilizzato tale tipo di domanda, per cui non si dovrebbe manifestare alcun problema.';
$string['qtyperqpwillberemovedanyway'] = 'Durante l\'aggiornamento, il tipo di domanda RQP sarà rimosso. Il sito ha alcune domande RPQ nel database e queste non funzioneranno più a meno di reinstallare il codice da http://moodle.org/mod/data/view.php?d=13&amp;rid=797 prima di continuare con l\'aggiornamento.';
$string['quarantinedir'] = 'Cartella per quarantena';
$string['question'] = 'Domanda';
$string['questioncwqpfscheck'] = 'Una o più domande "a caso" in un quiz sono impostate in modo da pescare le domande da un misto di categorie condivise e non. Esiste un <a href="{$a->reporturl}">report più dettagliato</a> e leggi anche la <a href="{$a->docsurl}">pagina</a> di Moodle Docs.';
$string['questioncwqpfsok'] = 'Bene. Non ci sono domande "a caso" nei tuoi quiz impostate in modo da pescare le domande da un misto di categorie condivise e non.';
$string['questiontype'] = 'Tipo domanda';
$string['questiontypes'] = 'Tipi domande';
$string['rcache'] = 'Cache dei record';
$string['rcachettl'] = 'TTL della cache dei record';
$string['recaptchaprivatekey'] = 'Chiave privata reCAPTCHA';
$string['recaptchapublickey'] = 'Chiave pubblica reCAPTCHA';
$string['registration'] = 'Registrazione';
$string['releasenoteslink'] = 'Per informazioni su questa versione di Moodle, si prega di consultare le <a target="_blank" href="{$a}">Note di rilascio</a> in linea';
$string['remotelangnotavailable'] = 'Non è possibile installare automaticamente i language pack perché Moodle non riesce a connettersi a download.moodle.org. Si prega di scaricare i corretti file compressi dall\'elenco seguente, copiarli nella cartella {$a} e scompattarli manualmente.';
$string['renameerrors'] = 'Errori nel cambiamento del nome';
$string['requiredentrieschanged'] = '<strong>IMORTANTE - LEGGERE PER FAVORE<br/>(Questo messaggio sarà mostrato solo durante questo aggiornamento)</strong><br/>A causa di un bug fix, cambierà il comportamento delle attività database che fanno uso della impostazione \'Numero minimo di record da inserire\' e \'Numero minimo di record da inserire prima di poter visualizzare il Database\'. Maggiori informazioni su <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forum del modulo database </a>. Il comportamento atteso da queste impostazioni può essere anche letto su  <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>.
<br/><br/>Queste modifiche impattano i seguenti database presenti nel tuo sistema: (Per favore salva adesso l\'elenco e dopo l\'aggiornamento verifica che le attività elencate funzionino come previsto dai docenti.)<br/><strong>{$a->text}</strong><br/>';
$string['requiredtemplate'] = 'Obbligatorio. Si può usare il modello di sintassi (%l = lastname, %f = firstname, %u = username).';
$string['requiremodintro'] = 'Descrizione dell\'attività obbligatoria';
$string['requires'] = 'Richiede';
$string['restrictbydefault'] = 'Limitare i moduli per default';
$string['restrictmodulesfor'] = 'Limitare i moduli per';
$string['reverseproxy'] = 'Reverse proxy';
$string['riskconfig'] = 'Gli utenti possono modificare la configurazione e il comportamento del sito';
$string['riskconfigshort'] = 'Configurazione';
$string['riskdataloss'] = 'L\'utente potrebbe essere in grado di distruggere grandi quantità di dati';
$string['riskdatalossshort'] = 'Rischio di perdita di dati';
$string['riskmanagetrust'] = 'Gli utenti possono modificare le impostazioni di affidabilità di altri utenti';
$string['riskmanagetrustshort'] = 'Gestione rischi';
$string['riskpersonal'] = 'Gli utenti possono avere accesso alle informazioni personali di altri utenti';
$string['riskpersonalshort'] = 'Privacy';
$string['riskspam'] = 'Gli utenti possono inviare spam agli utenti del sito o ad altri';
$string['riskspamshort'] = 'Spam';
$string['riskxss'] = 'Gli utenti possono aggiungere files e testi che permettono il cross-site scripting (XSS)';
$string['riskxssshort'] = 'XSS';
$string['roleswithexceptions'] = '{$a->roles}, con {$a->exceptions}';
$string['rowpreviewnum'] = 'Righe di anteprima';
$string['rssglobaldisabled'] = 'Disabilitato a livello server';
$string['runclamavonupload'] = 'Usa clam AV sui files caricati';
$string['save'] = 'Salva';
$string['savechanges'] = 'Salva modifiche';
$string['search'] = 'Cerca';
$string['searchinsettings'] = 'Cerca nelle impostazioni';
$string['searchresults'] = 'Risultati ricerca';
$string['sectionerror'] = 'Errore di sezione!';
$string['secureforms'] = 'Applica maggiore sicurezza per i form';
$string['security'] = 'Sicurezza';
$string['server'] = 'Server';
$string['serverchecks'] = 'Verifiche server';
$string['serverlimit'] = 'Limite del server';
$string['sessionautostartwarning'] = '<p>E\' stato individutao un errore di configurazione grave, per favore avverti l\'ammnistratore</p><p> Moodle per funzionare correttamente ha bisogno di modifiche alle impostazioni PHP.</p><p><code>session.auto_start</code> deve essere impostato a <code>off</code>.</p><p>E\' possibile cambiare l\'impostazione modificando il file <code>php.ini</code>, la configurazione di Apache/IIS <br />oppure tramite il file  <code>.htaccess</code> sul server.</p>';
$string['sessioncookie'] = 'Prefisso cookie';
$string['sessioncookiedomain'] = 'Dominio cookie';
$string['sessioncookiepath'] = 'Percorso cookie';
$string['sessionhandling'] = 'Gestione sessione';
$string['sessiontimeout'] = 'Timeout di sessione';
$string['settingfileuploads'] = 'Il caricamento di file è necessario per usare l\'ambiente, per favore abilitatelo nelle impostazioni del PHP.';
$string['settingmemorylimit'] = 'E\' stato riscontrato un limite di memoria troppo basso. Per favore aumentate il limite della memoria nelle impostazioni del PHP.';
$string['settingsafemode'] = 'Moodle non è del tutto compatibile con il safe mode, per favore chiedete all\'amministratore del server di impostare il safe mode ad off. Far girare Moodle con il safe mode ad on non è supportato e potrete riscontrare numerosi problemi.';
$string['showcommentscount'] = 'Visualizza il totale dei commenti';
$string['showdetails'] = 'Mostra dettagli';
$string['simpletest'] = 'Unit test';
$string['simplexmlrequired'] = 'Moodle richiede l\'estensione PHP SimpleXML.';
$string['sitelangchanged'] = 'L\'impostazione della lingua del sito è stata cambiata correttamente';
$string['sitemailcharset'] = 'Set di caratteri';
$string['sitemaintenance'] = 'Il sito è sottoposto a manutenzione e non è attualmente disponibile';
$string['sitemaintenancemode'] = 'Manutenzione';
$string['sitemaintenanceoff'] = 'La modalità manutenzione è stata disattivata e il sito è nuovamente operativo.';
$string['sitemaintenanceon'] = 'Il sito è attualmente in manutenzione (solo gli amministratori possono collegarsi o utilizzare il sito).';
$string['sitemaintenancewarning'] = 'Il sito al momento è in manutenzione (solo gli amministratori possono collegarsi o utilizzare il sito). Per ripristinare la normale operatività, <a href="maintenance.php">disattivare la modalità manutenzione</a>.';
$string['sitemaintenancewarning2'] = 'Il sito al momento è in manutenzione (solo gli amministratori possono collegarsi o utilizzare il sito). Per ripristinare la normale operatività, <a href="{$a}"> disattivare la modalità manutenzione</a>.';
$string['sitepolicies'] = 'Politiche del sito';
$string['sitepolicy'] = 'URL delle politiche del sito';
$string['sitepolicyguest'] = 'URL politiche del sito per gli ospiti';
$string['sitepolicyguest_help'] = 'E\' possibile specificare l\'URL delle politiche del sito per gli ospiti. Le politiche dovranno essere accettate per poter utilizzare il sito.
L\'impostazione può contenere un qualsiasi URL pubblico. Nota: l\'accesso di utenti non autenticato può essere evitato attraverso  l\'impostazione forcelogin.';
$string['sitepolicy_help'] = 'Se si dispone di una politica del sito (modalità  di utilizzo) che tutti gli utenti devono leggere e sottoscrivere prima di utilizzare il sito, specificarne qui l\'indirizzo (URL), altrimenti lasciare in bianco. L\'URL può puntare ad un qualsiasi URL pubblico.';
$string['sitesectionhelp'] = 'E\' possibile visualizzare una sezione nella Pagina home.';
$string['slasharguments'] = 'Utilizza gli "slash arguments"';
$string['smartpix'] = 'Ricerca icone intelligente';
$string['smtphosts'] = 'SMTP hosts';
$string['smtpmaxbulk'] = 'Limite per sessione SMTP';
$string['smtppass'] = 'SMTP password';
$string['smtpuser'] = 'SMTP username';
$string['soaprecommended'] = 'L\'estensione opzionale SOAP è utile per i Web service ed acluni moduli contrib.';
$string['spellengine'] = 'Correttore ortografico';
$string['splrequired'] = 'Moodle ha ora bisogno della estensione PHP SPL.';
$string['stats'] = 'Statistiche';
$string['statsfirstrun'] = 'Intervallo massimo di elaborazione';
$string['statsmaxruntime'] = 'Tempo massimo di esecuzione';
$string['statsruntimedays'] = 'Giorni da elaborare';
$string['statsruntimestart'] = 'Eseguire alle';
$string['statsuserthreshold'] = 'Soglia utenti';
$string['stickyblocks'] = 'Blocchi permanenti';
$string['stickyblockscourseview'] = 'Pagina del Corso';
$string['stickyblocksduplicatenotice'] = 'Se aggiungete blocchi permanenti che sono già presenti in una data pagina, tali blocchi risulteranno duplicati.<br />Se riscontrate questa situazione, tenete presente che solo i blocchi permanenti non potranno essere modificati, mentre i blocchi duplicati potranno essere spostati o eliminati.';
$string['stickyblocksmymoodle'] = 'Il mio Moodle';
$string['stickyblockspagetype'] = 'Tipo di pagina da configurare';
$string['strictformsrequired'] = 'Validazione stringente dei campi obbligatori';
$string['stripalltitletags'] = 'Rimuovi tag HTML dai nomi delle attività';
$string['supportemail'] = 'Email assistenza';
$string['supportname'] = 'Nominativo assistenza';
$string['supportpage'] = 'Pagina web assistenza';
$string['switchlang'] = 'Cambia la cartella della lingua';
$string['systempaths'] = 'Percorsi di sistema';
$string['tablenosave'] = 'Le modifiche apportate nella tabella soprastante saranno salvate automaticamente.';
$string['tablesnosave'] = 'Le modifiche apportate nelle tabelle soprastanti saranno salvate automaticamente.';
$string['tabselectedtofront'] = 'Nelle tabelle con tab, il tab selezionato deve essere portato in primo piano?';
$string['tabselectedtofronttext'] = 'Porta in primo piano il tab selezionato';
$string['themedesignermode'] = 'Modalità Theme designer';
$string['themelist'] = 'Elenco temi';
$string['themeresetcaches'] = 'Elimina le cache dei temi';
$string['themeselector'] = 'Selettore tema';
$string['themesettings'] = 'Impostazioni tema';
$string['therewereerrors'] = 'Si sono verificati errori nei vostri dati';
$string['timezone'] = 'Fuso orario di default';
$string['timezoneforced'] = 'L\'amministratore può scegliere di non permettere agli utenti di scegliere il proprio fuso orario.';
$string['timezoneisforcedto'] = 'Obbligare tutti gli utenti all\'utilizzo';
$string['timezonenotforced'] = 'Gli utenti possono scegliere il proprio fuso orario';
$string['tokenizerrecommended'] = 'E\' raccomandata l\'installazione di Tokenizer - estensione opzionale del PHP - per migliorare la funzionalità del Moodle Networking.';
$string['unattendedoperation'] = 'Operazione non assistita';
$string['unbookmarkthispage'] = 'Rimuovi questa pagina dai segnalibri';
$string['unicoderecommended'] = 'E\' raccomandato che tutti i dati vengano memorizzati in formato Unicode (UTF-8). Le nuove installazioni dovrebbero essere effettuate in database che hanno il proprio set di caratteri default impostato come Unicode. Se si sta facendo un aggiornamento, bisogna eseguire il processo di migrazione UTF-8 (vedi pagina di Amministrazione).';
$string['unicoderequired'] = 'E\' richiesto che tutti i dati vengano memorizzati in formato Unicode (UTF-8). Le nuove installazioni dovrebbero essere effettuate in database che hanno il proprio set di caratteri default impostato come Unicode. Se si sta facendo un aggiornamento, bisogna eseguire il processo di migrazione UTF-8 (vedi pagina di Amministrazione).';
$string['unicodeupgradenotice'] = 'In Moodle 1.6 tutte le lingue sono state convertite in Unicode. Per completare l\'aggiornamento di questo sito, è necessario convertire tutti i dati nella base di dati in Unicode utilizzando lo script di conversione. <a href="utfdbmigrate.php">Cliccare qui per eseguire lo script di conversione ora</a>!';
$string['uninstall'] = 'Rimuovi i Language Pack selezionati';
$string['uninstallconfirm'] = 'Si sta per rimuovere completamente il Language Pack {$a}, siete sicuri?';
$string['uninstallplugin'] = 'Rimuovi';
$string['uninstallqtype'] = 'Rimuovi questo tipo domanda.';
$string['unsupported'] = 'Non supportato';
$string['updateaccounts'] = 'Aggiornare registrazioni esistenti';
$string['updatecomponent'] = 'Aggiornamento componenti';
$string['updatelangs'] = 'Aggiorna tutti i Language Pack installati';
$string['updatetimezones'] = 'Aggiorna fusi orari';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 contiene numerose security fix per proteggere le passowrd ed i dati degli utenti nei file di backup. Per effetto di queste fix alcuni privilegi relativi ai backup potrebbero essere cambiati.<br />
Per maggiori informazioni consultare <a href=\'http://docs.moodle.org/en/Moodle_1.9.7_release_notes\' target=\'_blank\'>Moodle 1.9.7 release</a>.</p>';
$string['upgrade197noticesubject'] = 'Moodle 1.9.7 upgrade - Note sulla sicurezza';
$string['upgrade197salt'] = 'Per ridurre il rischio di furto di password, si consiglia vivamente di impostare un password salt. Per maggiori informazioni consultare <a href="{$a}" target="_blank">la documentazione sul password salting</a>.';
$string['upgradeerror'] = 'Si è verificato un errore sconosciuto durante l\'aggiornamento del plugin {$a->plugin} alla versione {$a->version}, non è possibile proseguire.';
$string['upgradeforumread'] = 'Una nuova caratteristica è stata aggiunta a Moodle 1.5 per tracciare gli interventi letti/non letti di un forum.<br />Per utilizzarla, bisogna<a href="{$a}">aggiornare le vostre tabelle</a>.';
$string['upgradeforumreadinfo'] = 'Una nuova caratteristica è stata aggiunta da Moodle 1.5 per tracciare i messaggi letti/non letti di un forum. Per utilizzarla, bisogna aggiornare le vostre tabelle con tutte le informazioni di tracciamento dei messaggi pre-esistenti. Il tempo di esecuzione dipende dalle dimensioni del vostro sito e potrebbe durare anche ore, sottoponendo il server ad un lavoro gravoso. E\' dunque consigliabile farlo in un momento tranquillo. In ogni caso, il sito continuerà  a funzionare durante questa operazione e gli utenti non ne saranno interessati. Una volta lanciato, il processo non dovrebbe essere interrotto, lasciando aperta la finestra del browser. Se si fermasse il processo, chiudendo la finestra del browser, niente paura: si può sempre ricominciare. < br /><br />Si desidera iniziare adesso il processo di aggiornamento?';
$string['upgradelogs'] = 'Per la piena funzionalità, i vostri vecchi log devono essere aggiornati. <a href="{$a}">Ulteriori informazioni</a>';
$string['upgradelogsinfo'] = 'Alcune modifiche hanno cambiato il modo in cui vengono salvati alcuni log. Per poter visualizzare tutti i vecchi log su una base di per-attività , è necessario aggiornarli. In base al tuo sito questa operazione può richiedere molto tempo (es alcune ore) e può essere grosso lavoro per la base dati dei siti grandi. Una volta che l\'aggiornamento è iniziato devi lasciarlo terminare (mantenendo la finestra del browser aperta). Non preoccuparti - il tuo sito continuerà  a lavorare correttamente mentre i log vengono aggiornati.<br /><br />Vuoi aggiornare i log ora?';
$string['upgradesettings'] = 'Nuove impostazioni';
$string['upgradesettingsintro'] = 'Le impostazioni sotto elencate sono state aggiunte durante l\'ultimo aggiornamento di Moodle. Apporta  i cambiamenti necessari ai valori di default e poi clicca su "Salva modifiche" in fondo alla pagina';
$string['upgradestart'] = 'Aggiorna';
$string['upgradesure'] = 'I file di Moodle sono stati aggornati alla versione:
<p><strong>{$a}</strong></p>
<p>Si sta per procedere all\'aggiornamento automatico del server a tale versione. Una volta effettuato questo aggiornamento non sarà  possibile tornare indietro.<br />Desideri procedere?</p>';
$string['upgradetimedout'] = 'L\'aggiornamento è andato in timeout. Per favore riavvia l\'aggiornamento.';
$string['upgradingdata'] = 'Aggiornamento dei dati';
$string['upgradinglogs'] = 'Aggiornamento dei log';
$string['upgradingversion'] = 'Aggiornamento alla nuova versione';
$string['uploadpicture_baduserfield'] = 'L\'attributo utente specificato non è valido. Provare ancora.';
$string['uploadpicture_cannotmovezip'] = 'Un file zip non può essere spostato in una cartella temporanea.';
$string['uploadpicture_cannotprocessdir'] = 'Non è stato possibile elaborare il file zip decompresso.';
$string['uploadpicture_cannotsave'] = 'Non è stato possibile salvare l\'immagine dell\'utente {$a}. Controllate le caratteristiche dell\'immagine.';
$string['uploadpicture_cannotunzip'] = 'Non è possibile decomprimere il file zip contenente le immagini.';
$string['uploadpicture_invalidfilename'] = 'Il file immagine {$a} ha caratteri non validi nel nome. Saltato.';
$string['uploadpicture_overwrite'] = 'Sovrascrivere le immagini utente già esistenti?';
$string['uploadpictures'] = 'Importa immagini utenti';
$string['uploadpictures_help'] = '<p>Le foto degli tenti possono essere caricate come file zip di immagini. I file immagini devono essere chiamati <i>attributo-utente-scelto.estensione</i>. Per esempio, se l\'attributo utente scelto per la corrispondenza delle foto è lo username e lo username è user1234, allora il file si chiamerà user1234.jpg.</p>

<p>I tipi immagini supportati sono gif, jpg, e png.</p>

<p>Nei nomi dei file immagine è indifferente l\'uso di maiuscole o minuscole.</p>';
$string['uploadpicture_userfield'] = 'Identificativo utente da utilizzare per far corrispondere le immagini';
$string['uploadpicture_usernotfound'] = 'Utente con un valore di \'{$a->uservalue}\' per \'{$a->userfield}\' non esiste. Saltato.';
$string['uploadpicture_userskipped'] = 'Saltato utente {$a} (ha già un\'immagine).';
$string['uploadpicture_userupdated'] = 'Immagine per l\'utente {$a} caricata.';
$string['uploadusers'] = 'Importa utenti';
$string['uploadusers_help'] = 'E\' possibile caricare utenti (ed iscriverli ai corsi) tramite file di testo. Il formato del file deve avere le seguenti caratteristiche:

* Ogni riga del file contiene un record
* Il record è una serie di dati separati da virgole o altri delimitatori
La prima riga del file è speciale e contiene le intestazioni con i nomi dei campi e definisce il formato del resto del file
* I campi obbligatori sono username, password, firstname,  lastname, email';
$string['uploaduserspreview'] = 'Anteprima importazione utenti';
$string['uploadusersresult'] = 'Risultati importazione utenti';
$string['upwards'] = 'ed oltre';
$string['useblogassociations'] = 'Abilita associazioni';
$string['useexternalyui'] = 'Utilizza le librerie YUI online';
$string['usehtmleditor'] = 'Usa l\'editor HTML';
$string['user'] = 'Utente';
$string['useraccountupdated'] = 'Utente aggiornato';
$string['useraccountuptodate'] = 'Utente aggiornato';
$string['userbulk'] = 'Azioni su elenchi';
$string['userdeleted'] = 'Utente Eliminato';
$string['userlist'] = 'Elenco utenti';
$string['userpolicies'] = 'Politiche utente';
$string['userpreference'] = 'Preferenze utente';
$string['userquota'] = 'Quota utente';
$string['userrenamed'] = 'Utente rinominato';
$string['users'] = 'Utenti';
$string['userscreated'] = 'Utenti creati';
$string['usersdeleted'] = 'Utenti eliminati';
$string['usersrenamed'] = 'Utenti rinominati';
$string['usersskipped'] = 'Utenti saltati';
$string['usersupdated'] = 'Utenti aggiornati';
$string['usersweakpassword'] = 'Utenti con password debole';
$string['usetags'] = 'Abilita Tag';
$string['uubulk'] = 'Preseleziona per azioni su elenchi';
$string['uubulkall'] = 'Tutti gli utenti';
$string['uubulknew'] = 'Nuovi utenti';
$string['uubulkupdated'] = 'Utenti modificati';
$string['uucsvline'] = 'Riga CSV';
$string['uulegacy1role'] = '(Ruolo studente originale) typeN=1';
$string['uulegacy2role'] = '(Ruolo docente originale) typeN=2';
$string['uulegacy3role'] = '(Ruolo docente non-editor originale) typeN=3';
$string['uunoemailduplicates'] = 'Evita le email duplicate';
$string['uuoptype'] = 'Modalità importazione';
$string['uuoptype_addinc'] = 'Crea tutti gli utenti, aggiungendo un numero agli username ove necessario';
$string['uuoptype_addnew'] = 'Crea solamente i nuovi utenti, ignora gli utenti già esistenti';
$string['uuoptype_addupdate'] = 'Crea i nuovi utenti ed aggiorna gli utenti già esistenti';
$string['uuoptype_update'] = 'Aggiorna solamente gli utenti già esistenti';
$string['uupasswordcron'] = 'Generato tramite cron';
$string['uupasswordnew'] = 'Password per i nuovi utenti';
$string['uupasswordold'] = 'Password per gli utenti già esistenti';
$string['uustandardusernames'] = 'Standardizza gli username';
$string['uuupdateall'] = 'Utilizza i valori contenuti nel file ed i valori di default';
$string['uuupdatefromfile'] = 'Utilizza i valori contenuti nel file';
$string['uuupdatemissing'] = 'Utilizza i valori contenuti nel file ed i valori di default se i campi sono vuoti';
$string['uuupdatetype'] = 'Impostazione campi del profilo utente';
$string['uuusernametemplate'] = 'Modello per gli username';
$string['validateerror'] = 'Questo valore non era valido:';
$string['verifychangedemail'] = 'Controlla i domini quando si cambia l\'email';
$string['warningcurrentsetting'] = 'Valore corrente non valido: {$a}';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Usa le impostazioni seguenti se il tuo server Moodle non può accedere direttamente ad Internet. L\'accesso ad Internet è necessario per scaricare dati di ambiente, language pack, feed RSS, timezone, eccetera.<br /><em>L\'estensione PHP cURL è fortemente raccomandata.</em>';
$string['xmlrpcrecommended'] = 'L\'installazione della estensione opzionale xmlrpc è necessaria per la comunicazione dell\'hub ed è utile per i web service e il Moodle Networking.';
$string['xmlstrictheaders'] = 'Intestazioni XML Strict';
$string['yuicomboloading'] = 'Caricamento YUI combo';
$string['ziprequired'] = 'Moodle richiede l\'estensione Zip PHP. Gli eseguibili info-ZIP o la libreria PclZip non sono più utilizzati.';
