<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'fr', branch 'MOODLE_20_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Accès refusé';
$string['accounts'] = 'Comptes';
$string['additionalhtml'] = 'HTML additionnel';
$string['additionalhtml_desc'] = 'Ces réglages vous permettent de spécifier du code HTML que vous voulez ajouter à chaque page. Cette possibilité existe pour du code à ajouter dans la balise HEAD de la page, ou immédiatement après l\'ouverture de la balise BODY, ou juste avant la fermeture de la balise BODY.<br />Cela vous permet d\'ajouter à chaque page une entête ou un pied de page personnalisé, ou d\'appeler des scripts pour des services tels que Google Analytics, indépendamment du thème choisi pour l\'affichage de votre site.';
$string['additionalhtmlfooter'] = 'Avant la fermeture de BODY';
$string['additionalhtmlfooter_desc'] = 'Ce contenu sera ajouté à chaque page, juste avant la fermeture de la balise BODY.';
$string['additionalhtmlhead'] = 'Dans HEAD';
$string['additionalhtmlhead_desc'] = 'Ce contenu sera ajouté à chaque page, en bas de la balise HEAD.';
$string['additionalhtml_heading'] = 'HTML additionnel à ajouter à chaque page';
$string['additionalhtmltopofbody'] = 'Lorsque BODY est ouvert';
$string['additionalhtmltopofbody_desc'] = 'Ce contenu sera ajouté à chaque page, juste après l\'ouverture de la balise BODY.';
$string['adminseesall'] = 'Les administrateurs voient tout';
$string['adminseesallevents'] = 'Les administrateurs voient tous les événements';
$string['adminseesownevents'] = 'Les administrateurs sont comme tous les autres utilisateurs';
$string['advancedfeatures'] = 'Fonctions avancées';
$string['allcountrycodes'] = 'Tous les codes de pays';
$string['allowbeforeblock'] = 'La liste des adresses IP permises est traitée en premier';
$string['allowbeforeblockdesc'] = 'Par défaut, la liste des adresses IP bloquées est traitée en premier. Lorsque cette option est activée, la liste des adresses IP autorisées sera traitée en premier.';
$string['allowblockstodock'] = 'Permettre aux blocs d\'utiliser le dock';
$string['allowcategorythemes'] = 'Autoriser les thèmes de catégories';
$string['allowcoursethemes'] = 'Autoriser les thèmes de cours';
$string['allowdeletes'] = 'Autoriser les suppressions';
$string['allowediplist'] = 'Liste des IP autorisées';
$string['allowemailaddresses'] = 'Domaines courriel autorisés';
$string['allowobjectembed'] = 'Autoriser les balises EMBED et OBJECT';
$string['allowrenames'] = 'Autoriser le changement des noms';
$string['allowthemechangeonurl'] = 'Autoriser le changement du thème dans l\'URL';
$string['allowuserblockhiding'] = 'Autoriser les utilisateurs à cacher les blocs';
$string['allowusermailcharset'] = 'Autoriser les utilisateurs à choisir un jeu de caractères';
$string['allowuserswitchrolestheycantassign'] = 'Autoriser les utilisateurs à basculer vers des rôles qu\'ils ne peuvent pas attribuer';
$string['allowuserthemes'] = 'Autoriser les thèmes utilisateur';
$string['antivirus'] = 'Anti-virus';
$string['appearance'] = 'Présentation';
$string['aspellpath'] = 'Chemin d\'accès du logiciel <i>aspell</i>';
$string['authentication'] = 'Authentification';
$string['authsettings'] = 'Gestion de l\'authentification';
$string['autolang'] = 'Détection automatique de langue';
$string['autologinguests'] = 'Connecter automatiquement les visiteurs anonymes';
$string['availablelicenses'] = 'Licences disponibles';
$string['availableto'] = 'Disponible pour';
$string['backgroundcolour'] = 'Couleur transparente';
$string['backups'] = 'Sauvegardes';
$string['badwordsconfig'] = 'Taper ici votre liste de mots à censurer, séparés par des virgules.';
$string['badwordsdefault'] = 'Si votre liste de mots à censurer est vide, une liste de mots tirée du paquetage de langue sera utilisée.';
$string['badwordslist'] = 'Votre liste de mots à censurer';
$string['blockediplist'] = 'Liste des IP bloquées';
$string['blockinstances'] = 'Instances';
$string['blockmultiple'] = 'Multiple';
$string['blockprotect'] = 'Protéger contre suppression';
$string['blockprotect_help'] = 'Les instances de bloc sélectionnées seront protégées contre une suppression du contexte du site. Ce réglage est essentiellement utilisé pour s\'assurer que les blocs Navigation et Réglages ne soient pas supprimés par inadvertance.';
$string['blocksettings'] = 'Gestion des blocs';
$string['blockunprotect'] = 'Déprotéger';
$string['bloglevel'] = 'Visibilité des blogs';
$string['bloglevelupgrade'] = 'Modifier la visiblité des blogs';
$string['bloglevelupgradedescription'] = '<p>Ce site a été mis à jour vers la version 2.0 de Moodle.</p>
<p>La visibilité des blogs a été simplifiée dans Moodle 2.0, mais votre site utilise encore les anciens types de visibilité.</p>
<p>Pour préserver la visibilité des blogs au niveau des cours et des groupes, vous devez lancer le script de mise à jour ci-dessous, qui créera un type spécial de forum « blog » dans chaque cours où des participants inscrits ont écrits des articles de blog. Ces articles seront copiés dans ce forum spécial.</p>
<p>Les blogs seront ensuite complètement désactivés au niveau du site, mais aucun article de blog ne sera supprimé par ce processus.</p>
<p>Vous pouvez lancer le script en visitant <a href="{$a->fixurl}">la page de mise à jour des blogs</a>.</p>';
$string['bloglevelupgradeinfo'] = 'La visibilité des blogs a été simplifiée dans Moodle 2.0, mais votre site utilise encore les anciens types de visibilité. Pour préserver la visibilité des blogs au niveau des cours et des groupes, vous devez lancer le script de mise à jour ci-dessous, qui créera un type spécial de forum « blog » dans chaque cours où des participants inscrits ont écrits des articles de blog. Ces articles seront copiés dans ce forum spécial. Les blogs seront ensuite complètement désactivés au niveau du site, mais aucun article de blog ne sera supprimé par ce processus.';
$string['bloglevelupgradenotice'] = 'Votre site utilise un réglage de visibilité des blogs obsolète. La <a href="bloglevelupgrade.php">mise à jour de la visibilité des blogs</a> est recommandée.';
$string['bloglevelupgradeprogress'] = 'Progression de la conversion : {$a->userscount} utilisateurs vérifiés, {$a->blogcount} articles convertis.';
$string['bookmarkadded'] = 'Marque-page ajouté.';
$string['bookmarkalreadyexists'] = 'Vous avez déjà marqué cette page.';
$string['bookmarkdeleted'] = 'Marque-page supprimé.';
$string['bookmarkthispage'] = 'Marquer cette page';
$string['cachejs'] = 'Mettre en cache le JavaScript';
$string['cachejs_help'] = 'La mise en cache et compression du JavaScript améliore de façon importante la performance de chargement des pages. Elle est vivement recommandée sur les sites en production. La désactivation de cette mise en page sera utile aux développeurs.';
$string['cachetext'] = 'Durée de vie du cache texte';
$string['cachetype'] = 'Type de cache';
$string['calendarexportsalt'] = 'Sel de l\'exportation des calendriers';
$string['calendarsettings'] = 'Calendrier';
$string['calendar_weekend'] = 'Jours du week-end';
$string['cannotdeletemissingqtype'] = 'Vous ne pouvez pas supprimer le type manquant, qui est requis par le système.';
$string['cannotdeletemodfilter'] = 'Vous ne pouvez pas désinstaller « {$a->filter} », car il fait partie du module « {$a->module} ».';
$string['cannotdeleteqtypeinuse'] = 'Vous ne pouvez pas supprimer le type « {$a} », car il y a des questions de ce type dans la banque de questions.';
$string['cannotdeleteqtypeneeded'] = 'Vous ne pouvez pas supprimer le type « {$a} », car d\'autres types de question installés en ont besoin.';
$string['cfgwwwrootslashwarning'] = 'Le paramètre $CFG->wwwroot est défini incorrectement dans votre fichier config.php. Vous y avez placé une barre oblique « / » à la fin. Veuillez la retirer, sans quoi vous souffrirez de bogues bizarres, comme celui décrit ici : <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Le paramètre $CFG->wwwroot est défini incorrectement dans votre fichier config.php. Il ne correspond pas à l\'URL que vous utilisez pour accéder à cette page. Veuillez le corriger, sans quoi vous souffrirez de bogues bizarres, comme celui décrit ici : <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'Changer';
$string['changesitelang'] = 'Changer la langue du site';
$string['checkboxno'] = 'Non';
$string['checkboxyes'] = 'Oui';
$string['choosefiletoedit'] = 'Sélectionnez le fichier à modifier';
$string['clamfailureonupload'] = 'Lors d\'un échec de clam AV';
$string['cleanup'] = 'Nettoyage';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Erreur, valeur incorrecte « {$a->value} » pour le paramètre « {$a->option} »';
$string['cliincorrectvalueretry'] = 'Valeur incorrecte, veuillez réessayer';
$string['clistatusdisabled'] = 'Statut : désactivé';
$string['clistatusenabled'] = 'Statut : activé';
$string['clitypevalue'] = 'type valeur';
$string['clitypevaluedefault'] = 'type valeur, tapez Entrée pour utiliser la valeur par défaut ({$a})';
$string['cliunknowoption'] = 'Options non reconnues :
 {$a}.
Utilisez l\'option --help.';
$string['cliupgradefinished'] = 'Mise à jour terminée avec succès.';
$string['cliyesnoprompt'] = 'Tapez y (pour oui) ou n (pour non)';
$string['commentsperpage'] = 'Commentaires affichés par page';
$string['commonfiltersettings'] = 'Réglages communs aux filtres';
$string['commonsettings'] = 'Réglages communs';
$string['componentinstalled'] = 'Composant installé';
$string['computedfromlogs'] = 'Calculé à partir des historiques depuis {$a}.';
$string['condifmodeditdefaults'] = 'Les valeurs définies ici déterminent les valeurs par défaut utilisées dans les réglages des nouvelles activités créées. Il est également possible de configurer les réglages de l\'activité devant être considérés comme réglages avancés.';
$string['confeditorhidebuttons'] = 'Sélectionner les boutons ne devant pas apparaître dans la barre de l\'éditeur.';
$string['configallcountrycodes'] = 'La liste des codes des pays pouvant être choisis par les utilisateurs, par exemple dans le profil. Veuillez indiquer une liste des codes à deux caractères des pays désirés, séparés par des virgules, par exemple « GB,FR,ES ». Si ce champ n\'est pas renseigné (réglage par défaut), la liste standard du fichier « countries.php » du paquetage de langue francophone est utilisée. Cette liste est conforme au standard ISO 3166-1. Si vous indiquez dans ce champ d\'autres codes non standards, vous devrez les ajouter manuellement dans le fichier « countries.php » de votre paquetage de langue.';
$string['configallowassign'] = 'Vous pouvez permettre aux utilisateurs ayant un rôle de la colonne de gauche d\'attribuer certains rôles de chaque colonne à d\'autres utilisateurs';
$string['configallowblockstodock'] = 'Si ce réglage est activé et si le thème utilisé le supporte, les utilisateurs peuvent ranger les blocs dans un dock.';
$string['configallowcategorythemes'] = 'Si vous activez ce réglage, les thèmes pourront être définis au niveau des catégories. Le thème défini pour la catégorie sera hérité par toutes les sous-catégories et tous les cours qui s\'y trouvent, à moins qu\'un thème propre n\'y soit défini spécifiquement. ATTENTION ! L\'activation de cette option pourrait affecter la performance de votre site.';
$string['configallowcoursethemes'] = 'Si vous activez ce réglage, les thèmes pourront être définis au niveau des cours. Les thèmes de cours auront priorité sur tous les autres réglages de thème (thème du site, de la catégorie, de l\'utilisateur ou de la session).';
$string['configallowemailaddresses'] = 'Pour restreindre les adresses de courriel des nouveaux utilisateurs à certains domaines déterminés, saisissez ici les domaines autorisés, séparés par des espaces. Pour autoriser des sous-domaines, indiquez-les en les préfixant d\'un point, par exemple <strong>monecole.fr.ch .ecole.com</strong>. Les adresses de tous les autres domaines et sous-domaines seront rejetées.';
$string['configallowobjectembed'] = 'Par mesure de sécurité, les utilisateurs normaux n\'ont pas la permission d\'inclure explicitement à l\'intérieur de textes des fichiers multimédias (par exemple Flash) à l\'aide de balises EMBED et OBJECT dans le code HTML. Ils peuvent cependant le faire de manière sûre avec le filtre multimédia. Si vous voulez autoriser l\'utilisation de ces balises, activez cette option.';
$string['configallowoverride'] = 'Vous pouvez permettre aux utilisateurs ayant un rôle de la colonne de gauche de définir pour d\'autres utilisateurs des dérogations aux rôles de chaque colonne';
$string['configallowoverride2'] = 'Sélectionnez les rôles pour lesquels les rôles de la colonne de gauche peuvent définir des dérogations.<br />Ce réglage ne s\'applique qu\'aux utilisateurs possédant la capacité moodle/role:override ou la capacité moodle/role:safeoverride.';
$string['configallowswitch'] = 'Sélectionnez les rôles vers lesquels un utilisateur pourra changer de rôle, sur la base des rôles qu\'il possède déjà. En plus d\'une indication dans ce tableau, l\'utilisateur doit également avoir la capacité moodle/role:switchroles pour pouvoir changer de rôle.<br />Il n\'est possible de changer de rôle que vers des rôles ayant la capacité moodle/course:view et n\'ayant pas la capacité moodle/site:doanything. C\'est pourquoi certaines colonnes de ce tableau sont inactives.';
$string['configallowthemechangeonurl'] = 'Si vous activez ce réglage, le thème pourra être changé en ajoutant « theme={NomTheme} » aux URL de Moodle.';
$string['configallowuserblockhiding'] = 'Voulez-vous autoriser les utilisateurs à cacher/afficher les blocs latéraux de ce site ? Cette fonctionnalité utilise Javascript et les cookies pour se souvenir de l\'état d\'affichage de chaque bloc. Elle n\'affecte que l\'affichage du site pour l\'utilisateur.';
$string['configallowusermailcharset'] = 'L\'activation de cette option permettra à chaque utilisateur du site de spécifier son propre encodage des messages par courriel.';
$string['configallowuserswitchrolestheycantassign'] = 'Par défaut, la capacité moodle/role:assign est requise pour qu\'un utilisateur puisse basculer vers un autre rôle. L\'activation de ce réglage supprime cette condition, ce qui a pour résultat que le basculement vers d\'autres rôles n\'est déterminé que par le tableau « Autoriser les attributions de rôles ». Il est recommandé que la configuration de ce tableau ne permette pas de basculer vers un rôle comportant plus d\'autorisations que le rôle existant.';
$string['configallowuserthemes'] = 'Si vous activez ce réglage, les utilisateurs pourront choisir leur propre thème. Le thème choisi par l\'utilisateur aura priorité sur le thème du site (mais pas sur les thèmes des cours).';
$string['configallusersaresitestudents'] = 'Pour les activités affichées sur la page d\'accueil du site, TOUS les utilisateurs doivent-ils être considérés comme des étudiants ? Si vous choisissez « Oui », tout utilisateur possédant un compte confirmé pourra participer à ces activités en tant qu\'étudiant. Si vous choisissez « Non », seuls les participants d\'au moins un cours pourront accéder aux activités de la page d\'accueil.';
$string['configauthenticationplugins'] = 'Veuillez choisir les plugins d\'authentification que vous voulez utiliser et les arranger dans l\'ordre de vérification désiré.';
$string['configautolang'] = 'Détecter automatiquement la langue par défaut d\'après les réglages du navigateur, si la langue par défaut du site est désactivée.';
$string['configautologinguests'] = 'Connecter automatiquement en tant que visiteur anonyme les utilisateurs accédant directement à un cours ouvert aux visiteurs anonymes.';
$string['configbloglevel'] = 'Ce réglage permet de restreindre le niveau auquel les blogs des utilisateurs peuvent être consultés sur ce site. Veuillez remarquer que ce réglage indique le contexte maximal de la personne qui <em>consulte</em> le blog, et non l\'auteur, ni le type des messages de blog. Les blogs peuvent également être désactivés, si vous ne les voulez pas du tout.';
$string['configcachetext'] = 'Ce réglage permet d\'accélérer le temps de réponse des grands sites ou de ceux qui utilisent les filtres. Des copies des textes sont mémorisés pour la durée spécifiée ici. Une valeur trop petite peut allonger légèrement le temps de réponse, mais une valeur trop élevée pourrait engendrer une actualisation pas assez fréquente des textes (avec de nouveaux liens, par exemple).';
$string['configcachetype'] = 'Choisissez un type de cache pour Moodle. Cela ne configurera que le cache. N\'oubliez pas d\'activer <i>rcache</i> pour que le cache soit utilisé pour quelque chose. Cette option est à utiliser <strong>uniquement</strong> si vous devez réduire la charge sur le système de base de données. Si ce n\'est pas le cas, Moodle fonctionnera plus lentement. Les sites servant un trafic moyen verront une amélioration en utilisant l\'option « Interne ». Si votre serveur web est installé avec eAccelerator ou Turckmmcache <em>avec les options de partage de mémoire activées,</em> essayez « eaccelerator ». Si votre Moodle tourne sur plusieurs serveurs, qu\'un ou plusieurs démons <i>memcached</i> fonctionnent et que l\'extension <i>PHP-memcached</i> est activée, choisissez « memcached » et configurez les options memcached ci-dessous.<br /><strong>Attention !</strong> Effectuez des tests de performance en charge et modifiez les réglages en conséquence : les caches peuvent ralentir votre serveur. Si votre serveur sert un trafic élevé, <i>eAccelerator</i> et <i>memcached</i> peuvent apporter le plus d\'amélioration, mais la charge en terme d\'utilisation des processeurs du serveur web augmentera.';
$string['configcalendarexportsalt'] = 'Ce texte aléatoire est utilisé pour améliorer la sécurité des jetons d\'authentification utilisés pour l\'exportation des calendriers. Si vous modifiez ce texte, tous les jetons en cours seront rendus non valides.';
$string['configclamactlikevirus'] = 'Traiter les fichiers comme des virus';
$string['configclamdonothing'] = 'Ne pas traiter les fichiers';
$string['configclamfailureonupload'] = 'Si vous avez configuré clam pour l\'inspection des fichiers déposés et que la configuration n\'est pas correcte ou que clam ne peut être lancé pour une autre raison, quel doit être le comportement ? Si vous indiquez « Traiter les fichiers comme des virus », ils seront déplacés vers un dossier de quarantaine ou détruits. Si vous indiquez « Ne pas traiter les fichiers », les fichiers seront déposés vers leur dossier de destination, sans être inspectés. Dans tous les cas, les administrateurs seront avertis que clam n\'a pas fonctionné. En outre, si vous indiquez « Traiter les fichiers comme des virus » et que clam ne peut pas fonctionner (d\'habitude parce que le chemin « pathtoclam » n\'est pas correct), TOUS les fichiers déposés seront déplacés vers le dossier de quarantaine ou détruits. Soyez prudent avec ce réglage !';
$string['configconvertformat'] = 'Si les exécutables <i>latex</i>, <i>dvips</i> et <i>convert</i> sont disponibles, les images seront créées en utilisant le format indiqué. Dans le cas contraire, mimeTeX sera utilisé pour créer des images en format GIF.';
$string['configcookiehttponly'] = 'Active une nouvelle fonctionnalité de PHP 5.2.0. Les navigateurs doivent envoyer les cookies en utilisant uniquement des requêtes http réelles. Les cookies ne devraient pas être accessibles des langues de script. Ce réglage n\'est pas supporté par tous les navigateurs et n\'est peut-être pas totalement compatible avec le code actuel. Il permet d\'éviter certains types d\'attaques XSS.';
$string['configcookiesecure'] = 'Si le serveur accepte uniquement des connexions https, il est recommandé d\'activer l\'envoi sécurisé des cookies. Une fois activé, assurez-vous que le serveur web n\'accepte pas http:// ou fournit une redirection permanente vers une adresse https://. Si l\'adresse <em>wwwroot</em> ne commence pas par https://, ce réglage est désactivé automatiquement.';
$string['configcountry'] = 'Si vous choisissez un pays ici, il sera sélectionné par défaut lors de la création de nouveaux comptes. Si vous souhaitez forcer les utilisateurs à choisir un pays, laissez ce champ vide.';
$string['configcourserequestnotify'] = 'Indiquez le nom d\'utilisateur de la personne devant être informée lors de la demande de nouveaux cours.';
$string['configcourserequestnotify2'] = 'Les utilisateurs qui seront avertis lors d\'une demande de cours. Seuls les utilisateurs ayant le droit d\'approuver des demandes de cours sont affichés.';
$string['configcoursesperpage'] = 'Saisissez un nombre de cours à afficher par page dans la liste des cours.';
$string['configcronclionly'] = 'Lorsque ce réglage est activé, le script de cron ne peut être lancé que depuis un terminal, plutôt que par l\'intermédiaire d\'un navigateur web. Ce réglage ne tient pas compte du mot de passe de cron indiqué ci-dessous.';
$string['configcronremotepassword'] = 'Si un mot de passe est spécifié dans ce champ, le script de cron ne pourra être lancé depuis un navigateur web qu\'en fournissant ce mot de passe, suivant la syntaxe d\'URL :<pre>
http://site.exemple.fr/admin/cron.php?password=lemotdepasse
</pre>Si le champ n\'est pas renseigné, aucun mot de passe n\'est nécessaire.';
$string['configcurlcache'] = 'Durée de vie du cache cURL, en secondes.';
$string['configcustommenuitems'] = 'Vous pouvez définir ici un menu personnalisé qui sera affiché sur les pages, si le thème le permet. Chaque ligne décrit un élément de menu, et est constituée du texte du menu, d\'une URL (optionnelle) et d\'un texte (optionnel) à afficher dans une infobulle. Ces éléments sont séparés par des caractères « trait vertical » (|). Une structure hiérarchique (optionnelle) peut être définie à l\'aide de tiret au début des lignes. Exemple :
<pre>
Communauté Moodle|http://moodle.org|Le site de la communauté Moodle
-Moodle en français|http://moodle.org/course/view.php?id=20
-Assistance gratuite Moodle|http://moodle.org/support
-Développement de Moodle|http://moodle.org/development
--Traqueur Moodle|http://tracker.moodle.org|Le traqueur de bogues de Moodle
--Moodle Docs|http://docs.moodle.org|La documentation de Moodle
-Nouveautés Moodle|http://moodle.org/news
Entreprise Moodle
-Hébergement commercial Moodle|http://moodle.com/hosting
-Assistance commerciale Moodle|http://moodle.com/support
</pre>';
$string['configdbsessions'] = 'Enregistrer les informations sur les sessions en cours dans la base de données. Ce réglage est surtout utile pour les sites avec de nombreux utilisateurs ou ceux qui sont construits sur des clusters de serveurs. La plupart des sites peuvent laisser cette option désactivée, et ces informations seront stockées sur le disque du serveur. Attention ! si vous changez ce réglage, tous les utilisateurs seront immédiatement déconnectés, vous y compris ! Si vous utilisez une base de données MySQL, assurez-vous que la variable « max_allowed_packet » dans <em>my.cnf</em> (ou <em>my.ini</em>) ait au moins une valeur de 4M.';
$string['configdebug'] = 'Si vous activez cette option, le paramètre PHP « error_reporting » sera augmenté afin que les avertissements soient affichés. Ceci est utile essentiellement pour les développeurs.';
$string['configdebugdisplay'] = 'Une fois ce réglage activé, les rapports d\'erreur seront affichés sur la page HTML. C\'est pratique, mais cela rend non conforme le XHTML, le JS, les cookies et les entêtes HTTP en général. Si le réglage est désactivé, les rapports sont écrits dans les historiques du serveur, permettant un meilleur débogage. Le réglage error_log de PHP contrôle dans quel fichier les rapports sont écrits.';
$string['configdebugpageinfo'] = 'Activer cette option pour afficher des informations sur la page dans le pied de page.';
$string['configdebugsmtp'] = 'Activer le débogage des informations d\'envoi des messages courriel vers le serveur SMTP.';
$string['configdebugstringids'] = 'Ce réglage est destiné à aider les traducteurs de Moodle. Il indique le nom du fichier de langue ainsi que l\'identifiant de chaîne à côté de chaque chaîne de caractères affichée. Ce réglage ne prendra effet que lors du chargement de la prochaine page.';
$string['configdebugvalidators'] = 'Activer cette option si vous voulez que les liens vers des serveurs de validation soient visibles dans le pied de page. Il vous sera peut-être nécessaire de créer dans votre Moodle un nouvel utilisateur dont le nom d\'utilisateur est <em>w3cvalidator</em> et d\'activer l\'accès aux visiteurs anonymes. Ces modifications peuvent ouvrir l\'accès à votre serveur par des personnes non autorisées. Ne les activez pas sur des serveurs en production !';
$string['configdefaultallowedmodules'] = 'Pour les cours de la catégorie ci-dessus, quels modules voulez-vous autoriser <b>lorsque le cours est créé</b> ?';
$string['configdefaulthomepage'] = 'Ce réglage permet de déterminer la page d\'accueil des utilisateurs connectés';
$string['configdefaultrequestcategory'] = 'Les cours demandés par les utilisateurs seront automatiquement classés dans cette catégorie.';
$string['configdefaultrequestedcategory'] = 'Catégorie par défaut où placer les cours dont la demande a été approuvée.';
$string['configdefaultuserroleid'] = 'Tous les utilisateurs connectés auront les capacités du rôle spécifié ici, au niveau du site, EN PLUS de celles de tous les autres rôles qu\'ils ont déjà. Par défaut, il s\'agit du rôle « Utilisateur authentifié ». Il est à remarquer que cela n\'entrera pas en conflit avec les autres rôles disponibles, à moins que vous n\'interdisiez des capacités : cela permet simplement de s\'assurer que tous les utilisateurs possèdent les capacités qui ne peuvent être attribuées au niveau des cours (par exemple écrire des articles de blog, gérer son calendrier, etc.).';
$string['configdeleteincompleteusers'] = 'Après ce laps de temps, les anciens comptes dont la configuration n\'est pas terminée sont supprimés.';
$string['configdeleteunconfirmed'] = 'Si vous utilisez l\'authentification par courriel, c\'est la période pendant laquelle les confirmations des utilisateurs sont acceptées. À l\'échéance de cette période, les comptes non-confirmés sont supprimés.';
$string['configdenyemailaddresses'] = 'Pour interdire les adresses de courriel de certains domaines pour les nouveaux utilisateurs, saisissez ici les domaines rejetés, séparés par des espaces. Pour interdire des sous-domaines, indiquez-les en les préfixant d\'un point, par exemple <strong>hotmail.com yahoo.fr .live.com</strong>. Les adresses de tous les autres domaines seront acceptées.';
$string['configdigestmailtime'] = 'Les utilisateurs désirant recevoir un courriel contenant tous les messages des forums le recevront quotidiennement. Ce réglage détermine l\'heure de la journée à laquelle le courriel sera envoyé (la tâche cron s\'exécutant immédiatement après cette heure enverra le message).';
$string['configdisableuserimages'] = 'Désactiver la modification de l\'image des utilisateurs dans leur profil.';
$string['configdisplayloginfailures'] = 'Permet de proposer aux utilisateurs sélectionnés l\'affichage d\'informations sur les tentatives de connexion.';
$string['configdocroot'] = 'Définit l\'URL du site de documentation Moodle. Vous pouvez modifier cette adresse, si vous disposez de votre propre documentation en ligne. Cependant, si vous la modifiez, assurez-vous que les chemins d\'accès de votre documentation soient de la même forme que sur http://docs.moodle.org/.';
$string['configdoctonewwindow'] = 'Après activation de ce réglage, les liens vers Moodle Docs s\'ouvriront dans une nouvelle fenêtre.';
$string['configeditordictionary'] = 'Cette valeur sera utilisée si aucun dictionnaire dans la langue de l\'utilisateur n\'est disponible pour aspell.';
$string['configeditorfontlist'] = 'Sélectionner les polices à afficher dans le menu déroulant de l\'éditeur.';
$string['configemailchangeconfirmation'] = 'Exiger une confirmation par courriel lors du changement d\'adresse de courriel par les utilisateurs.';
$string['configenableajax'] = 'Ce réglage permet de contrôler l\'utilisation d\'AJAX (interface client/serveur avancée utilisant le JavaScript) sur tout le site. Lorsque ce réglage est activé, les utilisateurs ont le choix de désactiver AJAX dans leur profil. Dans le cas contraire, AJAX est totalement désactivé.';
$string['configenablecalendarexport'] = 'Activer l\'exportation et l\'abonnement aux calendriers.';
$string['configenablecomments'] = 'Activer les commentaires';
$string['configenablecourserequests'] = 'Vous permettrez ainsi à tous les utilisateurs de faire des demandes de création de cours.';
$string['configenableglobalsearch'] = 'Ce réglage active le moteur de recherche plein texte global des ressources et activités, qui n\'est pas compatible avec PHP 4.';
$string['configenablegroupmembersonly'] = 'Si ce réglage est activé, l\'accès aux activités peut être limité aux membres de groupes. Cela peut se traduire par une augmentation de la charge du serveur. En outre, les catégories de carnet de notes doivent être configurées de façon à s\'assurer que les activités sont cachées aux participants ne faisant pas partie du groupe.';
$string['configenablehtmlpurifier'] = 'Utiliser <i>HTML Purifier</i> au lieu de <i>KSES</i> pour le nettoyage de texte non fiable. <i>HTML Purifier</i> est activement développé et probablement plus sûr, mais requiert plus de ressources. Des différences mineures sont à attendre dans le code HTML produit. Il est à remarquer que les balises <i>embed</i> et <i>object</i> ne peuvent pas être activées, et que les balises MathML ne sont pas supportées, tout comme l\'ancienne syntaxe du filtre multilingue.';
$string['configenablerssfeeds'] = 'Activation des flux RSS pour tout le site. Il est également nécessaire d\'activer les flux RSS des différents modules - voyez l\'option Blocs sous Administration -> Configuration.';
$string['configenablerssfeedsdisabled'] = 'Non disponible, car les flux RSS ne sont pas activés pour le site. Pour les activer, voyez l\'option Paramètres techniques sous Administration -> Configuration.';
$string['configenablerssfeedsdisabled2'] = 'Les flux RSS sont désactivés au niveau du site. Vous devez d\'abord les activer sous Serveur > RSS.';
$string['configenablesafebrowserintegration'] = 'Ce réglage permet d\'ajouter l\'option « Nécessite l\'utilisation de Safe Exam Browser » au champ « Sécurité du navigateur » dans les réglages des tests. Voir http://www.safeexambrowser.org/ (en anglais) pour plus d\'informations.';
$string['configenablestats'] = 'Si vous activez ce réglage, le cron automatique de Moodle traitera les historiques et produira quelques statistiques. Suivant la quantité de trafic sur votre site, le traitement peut prendre du temps. Les statistiques vous fourniront d\'intéressants graphiques et des statistiques sur chaque cours ou sur la totalité du site.';
$string['configenabletrusttext'] = 'Par défaut, Moodle nettoie soigneusement tous les fichiers déposés et textes saisis par les utilisateurs, afin d\'en retirer les éventuels scripts, médias, etc. pouvant constituer une faille de sécurité. Le système « Contenu fiable » vous permet de donner à certains utilisateurs en qui vous avez confiance la capacité d\'inclure sans interférence de tels éléments dans leurs ressources. Pour faire fonctionner ce système, veuillez d\'abord l\'activer ici, puis accorder la capacité « Se fier aux contenus » à un rôle spécifique. Les textes créés ou déposés par des utilisateurs ayant ce rôle seront marqués comme fiables et ne seront alors pas nettoyés avant leur affichage.';
$string['configenablewebservices'] = 'Les services web permettent à d\'autres systèmes de se connecter à ce Moodle et y effectuer des opérations. Pour plus de sécurité, cette fonctionnalité doit être désactivée, sauf si vous l\'utilisez réellement.';
$string['configenablewsdocumentation'] = 'Ce réglage active la génération automatique de la documentation des services web. L\'utilisateur d\'un service web peut accéder à sa propre documentation sur sa page de clefs de sécurité {$a}. Seule la documentation sur les protocoles activés est affichée.';
$string['configerrorlevel'] = 'Choisir la quantité d\'avertissement PHP que vous souhaitez voir afficher. « Normal » est généralement le meilleur choix.';
$string['configexcludeoldflashclients'] = 'Certaines versions du plugin Adobe Flash sont vulnérables à des attaques utilisant des contenus Flash malveillants. Vous pouvez indiquer ici une version minimale supportée ; Moodle n\'affichera pas les fichiers Flash pour les personnes utilisant une version antérieure. En lieu et place, ils verront une information leur indiquant comment mettre à jour leur plugin. Aucun contrôle ne sera effectué si vous ne renseignez pas ce champ.';
$string['configextendedusernamechars'] = 'Activez cette option pour permettre aux étudiants d\'utiliser n\'importe quel caractère dans leur nom d\'utilisateur (cette option n\'a aucun effet sur leur nom d\'utilisateur actuel). Par défaut, cette option est désactivée, ce qui restreint les noms d\'utilisateur aux caractères alphanumériques bas de casse et aux caractères sous-ligné (_), tiret (-), point (.) et arobase (@).';
$string['configextramemorylimit'] = 'Ce réglage spécifie la taille maximale de mémoire qu\'un script peut allouer. Cette option est appliquée aux scripts d\'indexation de la recherche, de sauvegarde et de restauration, ainsi qu\'au script admin/health.';
$string['configextrauserselectorfields'] = 'Sélectionnez les champs à rechercher et afficher en plus des noms complets lors de la sélection des utilisateurs, par exemple lors de l\'attribution des rôles ou de l\'ajout d\'utilisateurs à des groupes. Pour des raisons de sécurité, il est conseillé de ne pas sélectionner le champ « nom d\'utilisateur ».';
$string['configfilterall'] = 'Filtrer toutes les chaînes, y compris les entêtes, titres, barre de navigation, etc. Ce réglage n\'est utile qu\'en combinaison avec l\'utilisation du filtre « Contenus multilingues ». Utilisé seul, il ne fera que charger inutilement votre serveur.';
$string['configfiltermatchoneperpage'] = 'Un seul lien automatique par page sera généré par les filtres de liaison automatique, pour chaque première apparition du texte. Toutes les autres occurrences seront ignorées.';
$string['configfiltermatchonepertext'] = 'Un seul lien automatique par élément de texte (par exemple bloc, ressource, etc.) sera généré par les filtres de liaison automatique sur une page. Toutes les autres occurrences seront ignorées. Ce réglage n\'est actif que si le réglage « Filtrer une occurrence par page » est désactivé.';
$string['configfilteruploadedfiles'] = 'Filtrer les fichiers HTML et fichiers texte déposés avant de les afficher, ne filtrer que les fichiers HTML déposés ou ne filtrer aucun fichier.';
$string['configforcelogin'] = 'Habituellement, la page d\'accueil du site et la liste des cours (mais pas les cours eux-mêmes) peuvent être consultés sans se connecter au site. Si vous désirez forcer les visiteurs à se connecter avant de faire QUOI QUE CE SOIT dans le site, veuillez activer cette option.';
$string['configforceloginforprofiles'] = 'L\'activation de ce réglage impose aux visiteurs de se connecter en tant qu\'utilisateur réel (authentifié) pour pouvoir consulter les profils des autres utilisateurs. Si vous le désactivez, il pourra arriver que certains utilisateurs utilisent leur profil pour y inclure de la publicité (spam) ou d\'autres contenus inadéquats, qui seront alors visibles par tout le monde.';
$string['configframename'] = 'Si vous intégrez Moodle dans un cadre (frame), indiquez ici le nom de ce cadre. Dans le cas contraire, cette valeur doit rester « _top »';
$string['configfrontpage'] = 'Les éléments ci-dessus seront affichés sur la page d\'accueil.';
$string['configfrontpageloggedin'] = 'Les éléments sélectionnés seront affichés sur la page d\'accueil pour les utilisateurs connectés.';
$string['configfullnamedisplay'] = 'Ce réglage définit comment les noms sont affichés en format complet. Pour la plupart des sites monolingues, le réglage le plus efficace est le réglage par défaut « Prénom + Nom », mais vous pouvez choisir de cacher les noms de familles, ou de laisser le choix au paquetage de la langue d\'affichage (certaines langues ont des conventions différentes).';
$string['configgdversion'] = 'Indiquer la version de la bibliothèque GD installée sur le serveur. La version sélectionnée par défaut est celle qui a été détectée. Ne pas modifier cette valeur à moins de savoir réellement ce qui en découle.';
$string['configgeoipfile'] = 'Emplacement du fichier binaire GeoIP City. Ce fichier ne fait pas partie de la distribution de Moodle. Il doit être obtenu séparément chez <a href="http://www.maxmind.com/">MaxMind</a>. Vous pouvez soit en acheter une version commerciale, soit utiliser la version gratuite.<br />Téléchargez simplement le fichier <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> et décompressez-le dans le dossier « {$a} » sur votre serveur.';
$string['configgetremoteaddrconf'] = 'Si votre serveur est situé derrière un proxy inverse, vous pouvez utiliser ce réglage pour indiquer les entêtes HTTP dont on peut être sûr qu\'ils contiennent l\'adresse IP distante. Les entêtes sont lues dans l\'ordre indiqué, la première disponible étant utilisée.';
$string['configgooglemapkey'] = 'Vous devez saisir une clef particulière pour utiliser Google Maps pour la localisation des adresses IP. Vous pouvez obtenir gratuitement une telle clef sur <a href="http://code.google.com/apis/maps/signup.html" >http://code.google.com/apis/maps/signup.html</a>.<br />L\'URL de votre site est {$a}';
$string['configgradebookroles'] = 'Ce réglage permet de configurer les rôles apparaissant dans le carnet de notes. Pour être mentionnés dans le carnet de notes d\'un cours, les utilisateurs doivent avoir au moins l\'un de ces rôles dans ce cours.';
$string['configgradeexport'] = 'Sélectionnez les formats d\'exportation privilégiés du carnet de notes. Les sélections mettront en place et utiliseront ensuite un champ « dernière exportation » pour chaque note. Par exemple, cela permettra d\'identifier des notes exportées comme « nouvelles » ou « modifiées ». Si vous n\'êtes pas sûr à ce sujet, ne cochez rien.';
$string['confighiddenuserfields'] = 'Veuillez sélectionner quelles informations vous désirez cacher aux autres utilisateurs du cours que les administrateurs/enseignants. Vous pourrez ainsi améliorer la protection des données des étudiants. Il est possible de sélectionner plusieurs champs.';
$string['configidnumber'] = 'Cette option précise si (a) les utilisateurs doivent indiquer un numéro d\'identification non vide ; (b) les utilisateurs doivent indiquer un numéro d\'identification qui peut être vide ; (c) les utilisateurs n\'ont pas besoin d\'indiquer de numéro d\'identification. Le cas échéant, le numéro d\'identification est affiché dans le profil de l\'utilisateur.';
$string['configintcachemax'] = 'Pour cache interne. Nombre maximum d\'enregistrements à conserver en cache. Valeur recommandée : 50. Pour réduire l\'utilisation de la mémoire, utiliser une valeur plus basse.';
$string['configintro'] = 'Cette page permet de configurer un certain nombre de variables de configuration permettront à Moodle de fonctionner correctement sur ce serveur. Inutile de trop s\'en inquiéter, les paramètres par défaut devraient, la plupart du temps, convenir et il est toujours possible de revenir plus tard sur cette page pour les modifier.';
$string['configintroadmin'] = 'Cette page permet de configurer votre compte administrateur principal qui aura le contrôle total du site. Assurez-vous de lui donner un nom et un mot de passe sûrs, ainsi qu\'une adresse de courriel valable. Vous pourrez créer plus tard d\'autres comptes administrateur.';
$string['configintrosite'] = 'Cette page permet définir l\'aspect de la page d\'accueil et le nom de votre site. Vous pourrez modifier ces paramètres en tout temps en utilisant les menus d\'administration.';
$string['configintrotimezones'] = 'Cette page permet de mettre à jour les données des fuseaux horaires (y compris les changements dus à l\'heure d\'été) et de les intégrer à votre base de données locale. Les nouveautés éventuelles seront téléchargées depuis les emplacements suivants, dans l\'ordre : {$a} Cette procédure est tout à fait sûre. Elle ne peut endommager les installations standards de Moodle. Voulez-vous mettre à jour vos fuseaux horaires maintenant ?';
$string['configiplookup'] = 'Lorsque que vous cliquez sur une adresse IP (par exemple 34.12.222.93) notamment dans les historiques, une carte de monde vous est affichée, avec une estimation la meilleure possible de la localisation de cette adresse IP. Diverses extensions sont disponibles pour effectuer cette tâche, ayant chacune ses avantages et inconvénients.';
$string['configjabberhost'] = 'Le serveur où se connecter pour envoyer les notifications de message Jabber';
$string['configjabberpassword'] = 'Le mot de passe pour la connexion au serveur Jabber';
$string['configjabberport'] = 'Le port à utiliser pour la connexion au serveur Jabber';
$string['configjabberserver'] = 'L\'identifiant du serveur XMPP (peut être laissé vide s\'il s\'agit du même que le serveur Jabber)';
$string['configjabberusername'] = 'Le nom d\'utilisateur pour la connexion au serveur Jabber';
$string['configkeeptagnamecase'] = 'Cocher cette option si vous désirez que les noms des tags conservent leur casse originale, telle que saisie par les utilisateurs qui les créent.';
$string['configlang'] = 'Choisir une langue par défaut pour l\'ensemble du site. Les utilisateurs ont la possibilité de la modifier à l\'aide du menu de langue ou en modifiant le réglage de leur profil personnel.';
$string['configlangdir'] = 'La plupart des langues sont écrites de gauche à droite excepté certaines, comme l\'Arabe ou l\'Hébreu, qui le sont de droite à gauche';
$string['configlanglist'] = 'Laisser ce champ vide pour permettre le choix d\'une langue de cette installation de Moodle. Vous pouvez abréger le menu des langues en spécifiant une liste de codes des langues désirées, par exemple : fr,de,en,it';
$string['configlangmenu'] = 'Déterminer si vous voulez afficher ou non le menu du choix de la langue sur la page d\'accueil, la page de connexion, etc. Les utilisateurs peuvent sélectionner leur langue préférée dans leur propre profil indépendamment de ce réglage.';
$string['configlangstringcache'] = 'Ce réglage active la mise en cache des chaînes de caractères des paquetages de langues dans le dossier de données. Si vous traduisez Moodle ou modifiez des chaînes dans le code source de Moodle, il pourrait être utile de désactiver ce réglage. Sinon, laissez-le activé pour bénéficier d\'une meilleure performance.';
$string['configlatinexcelexport'] = 'Choisir l\'encodage des caractères pour les exportations en format Excel.';
$string['configlocale'] = 'Indiquer un environnement <em>locale</em> pour l\'affichage des dates. <strong>Laissez ce champ vide</strong>, sauf si vous avez une très bonne raison de faire autrement. Si le champ est renseigné, l\'environnement spécifié sera utilisé pour toutes les langues du site et empêchera l\'adaptation automatique de l\'affichage des dates en fonction de la langue choisie par l\'utilisateur.';
$string['configloginhttps'] = 'Cette option permet à Moodle d\'utiliser le protocole https sécurisé uniquement pour la page de connexion, ce qui fournit une connexion sécurisée. Moodle revient ensuite au protocole normal http pour gagner en vitesse. ATTENTION ! Ce réglage requiert l\'activation du protocole https sur le serveur web. Sans cela, vous risquez de NE PLUS POUVOIR ACCÉDER À VOTRE SITE.';
$string['configloglifetime'] = 'Ce champ permet de spécifier la durée de conservation des historiques des utilisateurs. Il est conseillé de choisir une durée aussi longue que possible. Si votre serveur est très fréquenté et que la performance se dégrade, il peut être judicieux de diminuer cette durée. Les valeurs inférieures à 30 ne sont pas recommandées, car les statistiques ne fonctionneraient alors pas correctement.';
$string['configlookahead'] = 'Jours à anticiper';
$string['configmailnewline'] = 'Caractère de nouvelle ligne à utiliser dans les messages par courriel. Selon la RFC 822bis, CRLF est obligatoire. Certains serveurs de courriel effectuent une conversion automatique de LF (LineFeed) vers CRLF (CarriageReturn et LineFeed), tandis que d\'autres effectuent une conversion incorrecte de CRLF vers CRCRLF. D\'autres encore rejettent les messages comprenant LF seulement (par exemple qmail). Si vous avez des problèmes de messages non délivrés ou contenant des lignes vides, essayez de modifier ce réglage.';
$string['configmaxbytes'] = 'Taille maximale des fichiers déposés dans le site, en octets. Cette valeur est limitée par les réglages PHP post_max_size et upload_max_filesize, ainsi que par le réglage Apache LimitRequestBody. Le réglage maxbytes limite quant à lui la taille au niveau des cours. Si vous choisissez « Limite serveur », le maximum alloué par le serveur sera utilisé.';
$string['configmaxconsecutiveidentchars'] = 'Les mots de passe ne doivent pas comporter plus que ce nombre de caractères identiques consécutifs. Indiquez 0 pour désactiver ce contrôle.';
$string['configmaxeditingtime'] = 'Ce paramètre indique la durée pendant laquelle les utilisateurs ont la possibilité de modifier un message, un article de glossaire, etc. qu\'ils ont écrit. Habituellement, 30 minutes est une bonne valeur.';
$string['configmaxevents'] = 'Nombre d\'événements à anticiper';
$string['configmemcachedhosts'] = 'Lors de l\'utilisation de <i>memcached</i>. Liste des serveurs sur lesquels tourne le démon <i>memcached</i>, séparés par des virgules. Indiquer des adresses IP pour éviter les lenteurs du DNS. Si vous ajoutez ou retirez des serveurs d\'une configuration en activité, <i>memcached</i> ne fonctionnera pas bien.';
$string['configmemcachedpconn'] = 'Lors de l\'utilisation de <i>memcached</i>. Utiliser des connexions persistantes. À utiliser avec circonspection : Apache/PHP peut se planter après redémarrage du démon <i>memcached</i>.';
$string['configmessaging'] = 'Le système de messagerie instantanée entre les utilisateurs du site doit-il être activé ?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Les notifications de lecture peuvent être supprimées pour gagner de l\'espace. Après combien de temps une telle notification doit être supprimée ?';
$string['configmessaginghidereadnotifications'] = 'Cacher les notifications de lecture d\'événements (telles que les messages des forums) lors de l\'affichage de l\'historique des messages';
$string['configminpassworddigits'] = 'Les mots de passe doivent comporter au moins ce nombre de chiffres.';
$string['configminpasswordlength'] = 'Les mots de passe doivent comporter au moins ce nombre de caractères.';
$string['configminpasswordlower'] = 'Les mots de passe doivent comporter au moins ce nombre de lettres minuscules.';
$string['configminpasswordnonalphanum'] = 'Les mots de passe doivent comporter au moins ce nombre de caractères non alphanumériques.';
$string['configminpasswordupper'] = 'Les mots de passe doivent comporter au moins ce nombre de lettres majuscules.';
$string['configmycoursesperpage'] = 'Nombre maximal de cours à afficher dans les listes des cours propres à un utilisateur';
$string['configmymoodleredirect'] = 'Ce réglage active la redirection vers le dossier /my lors de la connexion des non-administrateurs et remplace le premier niveau de la barre de navigation du site par /my';
$string['configmypagelocked'] = 'Ce réglage permet d\'éviter la modification de la page par défaut par des non administrateurs';
$string['confignavcourselimit'] = 'Nombre maximum de cours affichés pour des utilisateurs non connectés ou inscrits à aucun cours.';
$string['confignavshowallcourses'] = 'Permet de garantir que tous les cours du site sont affichés dans la navigation de façon permanente.';
$string['confignavshowcategories'] = 'Affiche les catégories de cours dans la barre de navigation et dans le bloc de navigation. Cela n\'est pas le cas avec les cours dans lesquels l\'utilisateur est inscrit, qui seront listés sans catégories sous Mes cours.';
$string['confignoreplyaddress'] = 'Les courriels sont parfois envoyés au nom d\'un utilisateur (par exemple les messages des forums). L\'adresse de courriel spécifiée ici sera utilisée comme adresse de l\'expéditeur lorsqu\'il n\'est pas souhaitable que les utilisateurs répondent directement à l\'auteur du message (par exemple s\'il ne veut pas que son adresse de courriel soit divulguée).';
$string['confignotifyloginfailures'] = 'Lorsque les tentatives de connexion sont enregistrées, des notifications peuvent être envoyées par courriel. Qui doit recevoir ces notifications ?';
$string['confignotifyloginthreshold'] = 'Lorsque les notifications des tentatives de connexion sont activées, combien de tentatives (provenant du même utilisateur ou de la même adresse IP) doivent être notifiées ?';
$string['confignotloggedinroleid'] = 'Les utilisateurs non connectés dans le site seront traités comme si ce rôle leur était accordé au niveau du contexte du site. Le rôle « Visiteur anonyme » est presque toujours ce dont vous aurez besoin ; il se peut toutefois que vous vouliez créer des rôles plus ou moins restrictifs. Les actions telles qu\'écrire des messages dans les forums requièrent toujours une véritable connexion.';
$string['configopentogoogle'] = 'Si vous activez cette option, Google pourra entrer dans votre site en tant qu\'utilisateur anonyme. En outre, les internautes arrivant sur votre site depuis une recherche Google seront automatiquement connectés en tant qu\'utilisateur anonyme. Cependant, cela ne permet un accès transparent qu\'aux cours déjà ouverts aux visiteurs anonymes.';
$string['configoverride'] = 'Défini dans config.php';
$string['configpasswordpolicy'] = 'Après activation de ce réglage, Moodle vérifiera la qualité des mots de passe (longueur, types des caractères, etc.). Utilisez les réglages ci-dessous pour fixer les critères minimaux des mots de passe (ils seront ignorés si ce réglage est désactivé).';
$string['configpathtoclam'] = 'Chemin d\'accès du programme « clam AV ». En général quelque chose comme « /usr/bin/clamscan » ou « /usr/bin/clamdscan ». Cette valeur est indispensable au fonctionnement de clam AV.';
$string['configpathtodu'] = 'Chemin d\'accès du programme « du » (disk usage). En général quelque chose comme « /usr/bin/du ». Si vous spécifiez ce chemin, les pages affichant le contenu de dossiers contenant beaucoup de fichiers se chargeront beaucoup plus vite.';
$string['configperfdebug'] = 'L\'activation de cette option a pour effet l\'affichage d\'informations de performance dans le pied de page du thème standard.';
$string['configprofileroles'] = 'Liste des rôles affichés sur les profils utilisateurs et la page de participation.';
$string['configprofilesforenrolledusersonly'] = 'Afin de prévenir les abus de spammeurs, le profil des utilisateurs qui ne sont inscrits à aucun cours sont cachés. Les nouveaux utilisateurs doivent s\'inscrire au moins à un cours pour pouvoir ajouter une description à leur profil.';
$string['configprotectusernames'] = 'Si ce réglage est activé, la routine de récupération de mot de passe n\'affiche aucun indice pouvant permettre de deviner les noms d\'utilisateurs ou les adresses de courriel.';
$string['configproxybypass'] = 'Liste séparée par des virgules de noms de domaines ou d\'adresses IP (éventuellement partiels) ne devant pas passer par le proxy (par exemple : 192.168., .mondomaine.com)';
$string['configproxyhost'] = 'Si le serveur qui héberge le site Moodle a besoin d\'utiliser un proxy (dans le cas, par exemple, où il existe un firewall sur le réseau), indiquer ici le nom de ce proxy. Sinon laisser vide.';
$string['configproxypassword'] = 'Mot de passe requis pour accéder à Internet au travers du proxy, si nécessaire. Laisser vide dans le cas contraire (l\'extension cURL de PHP est requise).';
$string['configproxyport'] = 'Si le serveur requiert l\'utilisation d\'un proxy, indiquez ici le port du proxy.';
$string['configproxytype'] = 'Type de proxy web (PHP5 et son extension cURL sont requis pour le support de SOCKS5).';
$string['configproxyuser'] = 'Nom d\'utilisateur requis pour accéder à Internet au travers du proxy, si nécessaire. Laisser vide dans le cas contraire (l\'extension cURL de PHP est requise).';
$string['configquarantinedir'] = 'Si vous désirez que clam AV déplace les fichiers infectés vers un dossier de quarantaine, spécifiez ici son chemin d\'accès. Le serveur web doit pouvoir écrire dans ce dossier. Si vous laissez ce champ vide ou si vous spécifiez un dossier inexistant ou sans droit d\'écriture, les fichiers infectés seront détruits. Ne pas écrire la barre oblique finale.';
$string['configrcache'] = 'Utiliser le cache pour stocker les enregistrements de la base de données. N\'oubliez pas de configurer aussi le paramètre « Type de cache » !';
$string['configrcachettl'] = 'Durée de vie des enregistrements en cache, en secondes. Utiliser ici une brève durée (&lt;15).';
$string['configrecaptchaprivatekey'] = 'Chaîne de caractères utilisée pour communiquer entre votre serveur Moodle et le serveur recaptcha.net. Vous pouvez obtenir une telle clef pour votre site en visitant http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Chaîne de caractères utilisée pour afficher l\'élément reCAPTCHA dans le formulaire d\'enregistrement. Cette chaîne est générée par http://www.google.com/recaptcha';
$string['configrequestedstudentname'] = 'Terme utilisé pour « étudiant » dans les cours demandés';
$string['configrequestedstudentsname'] = 'Terme utilisé pour « étudiants » dans les cours demandés';
$string['configrequestedteachername'] = 'Terme utilisé pour « enseignant » dans les cours demandés';
$string['configrequestedteachersname'] = 'Terme utilisé pour « enseignants » dans les cours demandés';
$string['configrequiremodintro'] = 'Cette option définit si vous désirez que les utilisateurs doivent écrire une description pour chaque activité créée.';
$string['configrestrictbydefault'] = 'Les cours créés dans cette catégorie doivent-ils avoir par défaut des restrictions sur les modules ?';
$string['configrestrictmodulesfor'] = 'Quels cours doivent avoir <b>le réglage</b> permettant de désactiver des modules d\'activité ? Ce réglage ne s\'applique qu\'aux enseignants. Les administrateurs pourront toujours ajouter n\'importe quelle activité à des cours.';
$string['configrunclamavonupload'] = 'Une fois ce réglage activé, le logiciel anti-virus clam AV vérifiera tous les fichiers déposés.';
$string['configrunclamonupload'] = 'Lancer clam AV lors du dépôt de fichiers ? Il est indispensable d\'indiquer en outre le chemin d\'accès correct dans le champ « pathtoclam » pour un fonctionnement correct. (Clam AV est un antivirus libre et gratuit que vous pouvez obtenir ici : http://www.clamav.net/)';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'Courriel';
$string['configsectionmaintenance'] = 'Maintenance';
$string['configsectionmisc'] = 'Divers';
$string['configsectionoperatingsystem'] = 'Système d\'exploitation';
$string['configsectionpermissions'] = 'Autorisations';
$string['configsectionrequestedcourse'] = 'Demande de cours';
$string['configsectionsecurity'] = 'Sécurité';
$string['configsectionstats'] = 'Statistiques';
$string['configsectionuser'] = 'Utilisateur';
$string['configsecureforms'] = 'Moodle peut utiliser un niveau additionnel de sécurité pour la gestion des formulaires web. Si cette option est activée, la variable HTTP_REFERRER du navigateur est comparée à l\'adresse du formulaire. Cela peut poser des problèmes lors de l\'utilisation d\'un firewall (p. ex. Zonealarm) configuré pour ôter HTTP_REFERRER de leur trafic web. Le symptôme est alors le « gel » du formulaire. Si vos utilisateurs ont des problèmes de connexion, par exemple sur la page de connexion, désactiver cette option. Dans le doute, réglez cette option sur « Oui ».';
$string['configsessioncookie'] = 'Ce réglage permet de changer le nom du cookie utilisé pour les sessions de Moodle. Il est optionnel et uniquement utile pour éviter les confusions entre cookies sur un site web où tournent plusieurs Moodle.';
$string['configsessioncookiedomain'] = 'Ce réglage vous permet de modifier le domaine depuis lequel les cookies de Moodle sont disponibles. Ceci est utile pour les modifications locales de Moodle (par exemple les plugins d\'authentification ou d\'inscription) nécessitant de partager les informations de session Moodle avec une application web dans un autre sous-domaine. <strong>ATTENTION ! il est vivement recommandé de ne pas modifier ce réglage et de le laisser vide. Une valeur incorrecte empêchera toute connexion au site.</strong>';
$string['configsessioncookiepath'] = 'Si vous voulez modifier l\'endroit où les navigateurs envoient les cookies, vous pouvez changer ce réglage en indiquant un sous-dossier de votre site web. Dans le cas contraire, le réglage par défaut « / » sera adéquat.';
$string['configsessiontimeout'] = 'Les utilisateurs connectés seront automatiquement déconnectés (leur session sera terminée) après le laps de temps d\'inactivité spécifié dans ce champ.';
$string['configshowcommentscount'] = 'Affiche le nombre de commentaires. Ceci coûte une requête supplémentaire dans la base de données lors de l\'affichage du lien vers les commentaires';
$string['configshowsiteparticipantslist'] = 'Tous les étudiants et les enseignants de la page d\'accueil de ce site seront affichés dans la liste des participants du site. Qui doit avoir l\'autorisation de voir cette liste des participants de la page d\'accueil ?';
$string['configsitedefaultlicense'] = 'Licence par défaut du site';
$string['configsitedefaultlicensehelp'] = 'La licence par défaut sera utilisée pour publier les contenus sur ce site';
$string['configsitemailcharset'] = 'Tous les courriels générés par votre site seront envoyés dans l\'encodage de caractères spécifié ici. Toutefois, chaque utilisateur pourra ajuster son encodage si la variable suivante est activée.';
$string['configsitemaxcategorydepth'] = 'Nombre maximum de niveaux de catégories';
$string['configsitemaxcategorydepthhelp'] = 'Indique le nombre maximum de niveaux de catégories affichés';
$string['configslasharguments'] = 'Les fichiers (images, fichiers téléchargés, etc.) sont transmis via un script qui utilise les « slash arguments ». Cette méthode permet à ces fichiers d\'être plus facilement pris en compte par le système de cache des navigateurs web, les proxy, etc. Cependant certains serveurs PHP n\'autorisent pas cette méthode. Par conséquent veuillez désactiver ce réglage si des problèmes d\'affichage des fichiers ou images téléchargés sont rencontrés.';
$string['configsmartpix'] = 'Lorsque ce réglage est activé, les icônes sont affichées via un script PHP, qui les cherche dans le thème actuel, puis dans tous les thèmes parents, et finalement dans le dossier /pix de Moodle. Ainsi il n\'est plus nécessaire de dupliquer les images dans les thèmes, pour un léger coût de performance.';
$string['configsmtphosts'] = 'Indiquer le nom complet d\'un ou plusieurs serveurs SMTP locaux que Moodle devra utiliser pour envoyer des courriels (par exemple, « mail.a.com » ou « mail.a.com;mail.b.com »). Pour indiquer un port non standard (c\'est-à-dire autre que le port 25), utiliser la syntaxe [server]:[port], par exemple « mail.a.com:587 . Si ce paramètre est laissé vide, Moodle utilisera la méthode par défaut de PHP pour envoyer des courriels.';
$string['configsmtpmaxbulk'] = 'Nombre maximum de messages de courriel envoyés lors d\'une session SMTP. En groupant les messages dans une session, on peut accélérer l\'envoi des messages par courriel. Une valeur inférieure à 2 force la création d\'une session SMTP pour chaque message.';
$string['configsmtpuser'] = 'Si vous avez indiqué un nom de serveur SMTP ci-dessus et qu\'il requiert une authentification, entrez ici le nom d\'utilisateur et le mot de passe à utiliser.';
$string['configstartwday'] = 'Début de la semaine';
$string['configstatsfirstrun'] = 'Ce réglage permet de spécifier jusqu\'à quelle date dans le passé les historiques doivent être traités lors de la <b>première fois</b> que le cron traite les statistiques. Si vous avez beaucoup de trafic ou si vous partagez un hébergement, il vous est déconseillé de remonter trop loin dans le temps, car le processus peut prendre beaucoup de temps et nécessite beaucoup de ressources processeur. (Pour ce réglage, veuillez remarquer que 1 mois = 28 jours. Dans les graphiques et statistiques générées, 1 mois = 1 mois du calendrier.)';
$string['configstatsmaxruntime'] = 'Le traitement des statistiques peut être très intensif. Nous vous conseillons d\'utiliser une combinaison de ce champ et du champ suivant pour spécifier quand le traitement sera lancé et durant combien de temps il tournera.';
$string['configstatsmaxruntime2'] = 'Le traitement des statistiques peut être très intensif. Veuillez indiquer la durée maximale permise pour la récolte des statistiques d\'une journée. Le nombre maximum de jours traités durant l\'exécution d\'un cron est 31.';
$string['configstatsmaxruntime3'] = 'Indiquez la durée maximale permise pour le calcul des statistiques d\'une journée, en tenant compte du fait que le traitement des statistiques peut charger considérablement le serveur. Le nombre maximal de jours traités lors d\'une même exécution du cron peut être spécifié ci-dessous.';
$string['configstatsruntimedays'] = 'Indiquez le nombre maximal de jours traités lors d\'une même exécution des statistiques. Lorsque les statistiques sont à jour, un seul jour sera traité. Veuillez donc ajuster cette valeur en tenant compte de la capacité de calcul de votre serveur, en la réduisant si le cron doit être exécuté plus rapidement.';
$string['configstatsruntimestart'] = 'À quel heure le cron lançant le traitement des statistiques doit <b>démarrer</b> ? Veuillez indiquer des heures différentes si plusieurs instances de Moodle sont installées sur le même serveur.';
$string['configstatsuserthreshold'] = 'Ce réglage spécifie le nombre minimum d\'utilisateurs inscrits dans un cours pour que celui-ci soit inclus dans les statistiques.';
$string['configstrictformsrequired'] = 'Si ce réglage est activé, les utilisateurs ne pourront pas ne saisir qu\'un espace et un saut de ligne dans les champs requis.';
$string['configstripalltitletags'] = 'Désactivez cette option si vous voulez autoriser les balises HTML dans le nom des activités et des ressources.';
$string['configsupportemail'] = 'Cette adresse de courriel sera publiée pour les utilisateurs du site comme une adresse où ils peuvent obtenir de l\'assistance (par exemple lors de la création des comptes des nouveaux utilisateurs). Si le champ n\'est pas renseigné, aucune adresse de courriel ne sera publiée à cet effet.';
$string['configsupportname'] = 'Le nom de la personne ou du service fournissant de l\'assistance par courriel ou sur un site web.';
$string['configsupportpage'] = 'Cette adresse sera publiée pour les utilisateurs du site comme le site web où ils peuvent obtenir de l\'assistance (par exemple lors de la création des comptes des nouveaux utilisateurs). Si le champ n\'est pas renseigné, aucun lien ne sera publié à cet effet.';
$string['configthemedesignermode'] = 'Normalement, toutes les images et feuilles de styles des thèmes sont mises en cache par les navigateurs pour une longue durée, afin d\'améliorer les performances. Si vous concevez des thèmes ou développez du code, ce réglage vous permet de ne pas faire afficher les versions stockées en cache. Attention ! Ce réglage rend votre site plus lent pour tous les utilisateurs ! Une alternative est de réinitialiser manuellement les caches de thèmes dans la page de sélection de thèmes.';
$string['configthemelist'] = 'Laissez ce champ vide si vous voulez permettre l\'utilisation de n\'importe quel thème. Si vous voulez raccourcir le menu des thèmes, vous pouvez spécifier ici une liste de noms de thèmes autorisés, séparés par des virgules. Par exemple : « standard,orangewhite ». N\'utilisez pas d\'espaces !';
$string['configtimezone'] = 'Vous pouvez indiquer ici le fuseau horaire par défaut. Ce n\'est le fuseau horaire par défaut que pour l\'affichage des dates. Chaque utilisateur peut modifier ce réglage dans son propre profil. Si vous choisissez « Heure locale du serveur », Moodle utilisera le réglage par défaut du serveur où il est installé. Si l\'utilisateur choisit « Heure locale du serveur » dans son profil, le réglage spécifié ici sera alors utilisé pour lui. Les tâches cron s\'exécutant en fonction de l\'heure utiliseront ce fuseau horaire.';
$string['configunzip'] = 'Indiquer le chemin complet du programme « unzip » (seulement pour Unix). Ce programme est requis pour décompresser des archives zip sur le serveur.';
$string['configuseblogassociations'] = 'Ce réglage détermine si les utilisateurs peuvent organiser leur blog en associant des articles à des cours ou des modules de cours.';
$string['configuseexternalyui'] = 'Utiliser les fichiers en ligne sur les serveurs de Yahoo au lieu des fichiers installés sur votre serveur. Attention ! Sans connexion internet, les fonctionnalités AJAX ne fonctionneront pas sur votre site.';
$string['configuserquota'] = 'Le nombre maximal d\'octets qu\'un utilisateur a à sa disposition pour stocker des fichiers dans sa zone de fichiers personnels. {$a->bytes} octets == {$a->displaysize}';
$string['configusetags'] = 'La fonctionnalité des tags doit-elle être activée sur tout le site ?';
$string['configvariables'] = 'Paramètres techniques';
$string['configverifychangedemail'] = 'Active la vérification des adresses de courriel lorsqu\'elles sont modifiées, en utilisant les réglages des domaines autorisés et interdits. Si ce réglage est désactivé, les restrictions de domaines ne sont appliquées que lors de la création des nouveaux comptes.';
$string['configvisiblecourses'] = 'Afficher normalement les cours placés dans des catégories cachées';
$string['configwarning'] = 'Attention ! Des valeurs inadaptées pour ces paramètres peuvent engendrer des problèmes.';
$string['configxmlstrictheaders'] = 'Si ce réglage est activé, chaque page sera générée avec des entêtes et un prologue http XML, de sorte que les navigateurs afficheront les erreurs XHTML. Ceci n\'est utile que pour les développeurs.';
$string['configyuicomboloading'] = 'Cette option permet un chargement combiné des bibliothèques YUI pour améliorer la performance. Ce réglage devrait être activé sur des sites en production.';
$string['configzip'] = 'Indiquer le chemin complet du programme « zip » (seulement pour Unix). Ce programme est requis pour réaliser des archives zip sur le serveur.';
$string['confirmation'] = 'Confirmation';
$string['confirmdeletecomments'] = 'Voulez-vous vraiment supprimer des commentaires ?';
$string['confirmed'] = 'Confirmé';
$string['confirminstall'] = 'Vous êtes sur le point d\'installer une nouvelle langue ({$a}). Voulez-vous continuer ?';
$string['convertformat'] = 'Format de sortie de <i>convert</i>';
$string['cookiehttponly'] = 'Cookies http uniquement';
$string['cookiesecure'] = 'Cookies sécurisé uniquement';
$string['country'] = 'Pays par défaut';
$string['coursecontact'] = 'Gestionnaires de cours';
$string['coursecontact_desc'] = 'Ce réglage permet de choisir les utilisateurs apparaissant dans la description du cours. Pour être affichés dans la description d\'un cours, les utilisateurs doivent avoir au moins l\'un de ces rôles dans ce cours.';
$string['coursemgmt'] = 'Gestion des cours';
$string['courseoverview'] = 'Vue d\'ensemble cours';
$string['courserequestnotify'] = 'Notification des demandes de cours';
$string['courserequestnotifyemail'] = 'L\'utilisateur {$a->user} a demandé un nouveau cours sur {$a->link}';
$string['courserequests'] = 'Demandes de cours';
$string['courserequestspending'] = 'Demandes de création de cours en attente';
$string['courses'] = 'Cours';
$string['coursesperpage'] = 'Cours par page';
$string['creatornewroleid'] = 'Rôle des créateurs de cours dans les nouveaux cours';
$string['creatornewroleid_help'] = 'Si l\'utilisateur n\'a pas déjà les autorisations de gérer le nouveau cours, il y sera automatiquement inscrit avec ce rôle.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Exécution du cron uniquement en mode terminal';
$string['cronerrorclionly'] = 'Désolé, l\'accès à cette page depuis le web a été désactivé par l\'administrateur';
$string['cronerrorpassword'] = 'Désolé, vous n\'avez pas fourni un mot de passe valide pour accéder à cette page';
$string['cron_help'] = 'Le script de maintenance cron.php permet d\'effectuer des tâches programmées à intervalle régulier pour des modules de Moodle, comme l\'envoi par courriel des copies des messages de forums. Un mécanisme est nécessaire pour lancer ce script de façon régulière, par exemple toutes les 15 minutes.';
$string['cronremotepassword'] = 'Mot de passe pour lancer le cron à distance';
$string['cronwarning'] = 'Le <a href="cron.php">script de maintenance cron.php</a> n\'a pas été lancé depuis au moins 24 heures.';
$string['csvdelimiter'] = 'Séparateur CSV';
$string['ctyperecommended'] = 'L\'installation de l\'extension optionnelle ctype de PHP est vivement recommandée afin d\'améliorer les performances du site, en particulier si votre site utilise des caractères non-latins.';
$string['ctyperequired'] = 'L\'installation de l\'extension ctype de PHP est maintenant requise par Moodle, afin d\'améliorer les performances du site et d\'offrir la compatibilité multilingue.';
$string['curlcache'] = 'Durée du cache cURL';
$string['curlrecommended'] = 'L\'installation de l\'extension optionnelle cURL de PHP est vivement recommandée afin de pouvoir utiliser la fonctionnalité Réseau Moodle.';
$string['curlrequired'] = 'L\'installation de l\'extension cURL de PHP est maintenant requise par Moodle, afin de pouvoir communiquer avec les dépôts de documents de Moodle.';
$string['curltimeoutkbitrate'] = 'Bande passante à utiliser pour le calcul des timeout de cURL (kbps)';
$string['curltimeoutkbitrate_help'] = 'Ce réglage est utilisé pour calculer un timeout adéquat durant les grosses requêtes cURL. Pour ce calcul, une requête HTTP HEAD est effectuée pour déterminer la taille du téléchargement. La valeur 0 désactive cette requête.';
$string['customcheck'] = 'Autres contrôles';
$string['custommenu'] = 'Menu personnalisé';
$string['custommenuitems'] = 'Éléments du menu personnalisé';
$string['datarootsecurityerror'] = '<p><strong>NOTIFICATION DE SÉCURITÉ !</strong></p><p>Votre dossier de données n\'est pas placé au bon endroit. Il est directement exposé au web. Ceci signifie que tous les fichiers privés de votre Moodle sont accessibles pour n\'importe qui et que certains d\'entre eux peuvent être utilisés par des pirates pour accéder de façon non autorisée à l\'administration de votre site !</p><p>Vous <em>devez</em> déplacer votre dossier de données ({$a}) en dehors de votre dossier web public et mettre à jour le réglage <code>$CFG->dataroot</code> de votre fichier config.php de façon adéquate.</p>';
$string['datarootsecuritywarning'] = 'La configuration de votre site semble ne pas être sûre. Veuillez vous assurer que le dossier des données de Moodle ({$a}) ne soit pas directement accessible depuis le web.';
$string['dbmigrate'] = 'Migration de la base de données de Moodle';
$string['dbmigrateconnecerror'] = 'Impossible de se connecter à la base de données spécifiée.';
$string['dbmigrateencodingerror'] = 'La base de données spécifiée a l\'encodage {$a} au lieu de l\'encodage requis UNICODE/UTF8.<br />Veuillez en sélectionner une autre.';
$string['dbmigratepostgres'] = 'Il semble que vous utilisez PostgreSQL comme serveur de base de données. Pour continuer le processus de migration, vous devez créer manuellement une nouvelle base de données avec l\'encodage « UNICODE » (PostgreSQL 7) ou « UTF8 » (PostgreSQL 8) pour stocker les données converties. Veuillez saisir les nouvelles données de connexion de base de données ci-dessous pour continuer :';
$string['dbmigratewarning'] = 'Veuillez vous assurer de bien avoir effectué une copie de sauvegarde de votre base de données Moodle avant de commencer cette procédure. Si vous n\'êtes pas sûr de la façon de le faire, veuillez contacter votre administrateur système. Votre site Moodle sera placé en mode de maintenance mode après le début du processus de migration.';
$string['dbmigratewarning2'] = '<b>Attention ! Vous êtes sur le point de commencer le processus de migration de la base de données de Moodle. Veuillez vous assurez de manière certaine que votre base de données Moodle est sauvegardée.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Cette base de données a été convertie en une nouvelle base de données UTF8. Elle n\'est plus utilisable avec cette version de Moodle. Veuillez modifier votre fichier config.php et utiliser la nouvelle base de données pour ce moodle.</font>';
$string['dbmigrationdupfailed'] = 'La duplication de la base de données a échoué. L\'erreur est vraisemblablement : <font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Stocker les informations de session dans la base de données';
$string['dbtest'] = 'Test fonctionnels de la base de données';
$string['debug'] = 'Messages de débogage';
$string['debugall'] = 'Tout : afficher tous les messages de débogage de PHP';
$string['debugdeveloper'] = 'Développeur : afficher tous les messages de débogage de Moodle';
$string['debugdisplay'] = 'Afficher les informations de débogage';
$string['debugging'] = 'Débogage';
$string['debugminimal'] = 'Minimal : n\'afficher que les erreurs fatales';
$string['debugnone'] = 'Aucun : n\'afficher aucune erreur, ni avertissement';
$string['debugnormal'] = 'Normal : afficher les erreurs, avertissements et notices';
$string['debugpageinfo'] = 'Afficher les informations sur la page';
$string['debugsmtp'] = 'Débogage de l\'envoi des courriels';
$string['debugstringids'] = 'Indiquer l\'origine des chaînes de caractères';
$string['debugvalidators'] = 'Afficher les liens de validation W3C';
$string['defaultallowedmodules'] = 'Modules autorisés par défaut';
$string['defaultcity'] = 'Localité par défaut';
$string['defaultcity_help'] = 'La localité saisie ici sera la ville par défaut lors de la création de nouveaux comptes utilisateurs.';
$string['defaulthomepage'] = 'Page d\'accueil par défaut pour les utilisateurs';
$string['defaultrequestcategory'] = 'Catégorie par défaut des demandes de cours';
$string['defaultsettinginfo'] = 'Défaut : {$a}';
$string['defaultuserroleid'] = 'Rôle par défaut des utilisateurs';
$string['defaultvalues'] = 'Valeurs par défaut';
$string['deleteerrors'] = 'Erreurs lors de suppressions';
$string['deletefilterareyousure'] = 'Voulez-vous vraiment supprimer le filtre « {$a} »?';
$string['deletefilterareyousuremessage'] = 'Vous allez complètement supprimer le filtre « {$a} ». Voulez-vous vraiment effectuer cette opération ?';
$string['deletefilterfiles'] = 'Toutes les données associées au filtre « {$a->filter} » ont été supprimées de la base de données. Pour terminer la suppression du filtre (et éviter ainsi que le filtre se réinstalle de lui-même), veuillez supprimer ce dossier de votre serveur : {$a->directory}';
$string['deleteincompleteusers'] = 'Supprimer les utilisateurs incomplets après';
$string['deleteqtypeareyousure'] = 'Voulez-vous vraiment supprimer le type de question type « {$a} »';
$string['deleteqtypeareyousuremessage'] = 'Vous êtes sur le point de supprimer totalement le type de question « {$a} ». Voulez-vous vraiment désinstaller ce type de question ?';
$string['deleteunconfirmed'] = 'Supprimer les utilisateurs non confirmés après';
$string['deleteuser'] = 'Supprimer l\'utilisateur';
$string['deletingfilter'] = 'Suppression du filtre « {a} »';
$string['deletingqtype'] = 'Suppression du type de question « {$a} »';
$string['density'] = 'Densité';
$string['denyemailaddresses'] = 'Domaines courriel interdits';
$string['development'] = 'Développement';
$string['digestmailtime'] = 'Heure d\'envoi des messages résumés';
$string['disableuserimages'] = 'Désactiver les images des utilisateurs';
$string['displayerrorswarning'] = 'L\'activation du réglage PHP <em>display_errors</em> n\'est pas recommandée sur des sites en production, car certains messages d\'erreur peuvent révéler des informations sensibles au sujet de votre serveur.';
$string['displayloginfailures'] = 'Afficher les erreurs de connexion à';
$string['docroot'] = 'URL du site Moodle Docs';
$string['doctonewwindow'] = 'Ouvrir dans une nouvelle fenêtre';
$string['download'] = 'Télécharger';
$string['editennotallowed'] = 'La langue en_utf8 ne peut pas être modifié depuis cette page. Veuillez passer en langue locale';
$string['edithelpdocs'] = 'Modifier les fichiers d\'aide';
$string['editingnoncorelangfile'] = 'Vous essayez de modifier la traduction d\'un module additionnel. Vous ne pouvez enregistrer cette traduction que dans votre dossier _local. Vous pouvez déplacer le fichier contenant la traduction dans le dossier lang du module et/ou l\'envoyer au responsable du module additionnel.';
$string['editlang'] = '<b>Modifier</b>';
$string['editorbackgroundcolor'] = 'Couleur de fond';
$string['editordictionary'] = 'Dictionnaire de l\'éditeur';
$string['editorfontfamily'] = 'Famille de police';
$string['editorfontlist'] = 'Liste des polices';
$string['editorfontsize'] = 'Corps de police';
$string['editorhidebuttons'] = 'Boutons cachés';
$string['editorkillword'] = 'Filtre Word';
$string['editorspelling'] = 'Correction orthographique de l\'éditeur';
$string['editorspellinghelp'] = 'Activer ou désactiver la correction orthographique. Une fois activée, le programme <strong>aspell</strong> doit être installé sur le serveur.';
$string['editstrings'] = 'Modifier les chaînes de caractères';
$string['emailchangeconfirmation'] = 'Confirmation de modification de courriel';
$string['emoticonalt'] = 'Texte alternatif';
$string['emoticoncomponent'] = 'Composant de l\'image';
$string['emoticonimagename'] = 'Nom de l\'image';
$string['emoticons'] = 'Binettes';
$string['emoticons_desc'] = 'Ce formulaire définit les binettes (ou émoticônes) utilisées sur votre site. Pour définir une nouvelle binette, renseignez les champs de la dernière rangée. Pour supprimer une rangée, effacez son contenu et enregistrez le formulaire. Pour réinitialiser tous les champs à leur valeur par défaut, cliquez sur le lien au-dessous de la table

* Texte (requis) : ce texte sera remplacé par l\'image de la binette. Il doit comporter au moins deux caractères.
* Nom de l\'image (requis) : le nom du fichier de l\'image de la binette, sans extension, relativement au dossier pix du composant.
* Composant de l\'image (requis) : le composant fournissant l\'image.
* Texte alternatif (optionnel) : chaîne de caractères utilisée comme texte alternatif de la binette.';
$string['emoticonsreset'] = 'Réinitialiser les binettes aux valeurs par défaut';
$string['emoticontext'] = 'Texte';
$string['emptysettingvalue'] = 'Vide';
$string['enableajax'] = 'Activer AJAX';
$string['enablecalendarexport'] = 'Activer l\'exportation des calendriers';
$string['enablecomments'] = 'Activer les commentaires';
$string['enablecourseajax'] = 'Activer l\'édition AJAX des cours';
$string['enablecourseajax_desc'] = 'Activer la technologie AJAX lors de l\'édition de la page principale des cours. Le format de cours et le thème doivent supporter l\'édition AJAX et les utilisateurs doivent également activer AJAX dans leur profil.';
$string['enablecourserequests'] = 'Activer les demandes de création de cours';
$string['enableglobalsearch'] = 'Activer la recherche globale';
$string['enablegroupmembersonly'] = 'Activer la restriction aux membres de groupes';
$string['enablehtmlpurifier'] = 'Activer <i>HTML Purifier</i>';
$string['enablerecordcache'] = 'Activer le cache des enregistrements';
$string['enablerssfeeds'] = 'Activer les RSS';
$string['enablesafebrowserintegration'] = 'Activer l\'intégration de « Safe Exam Browser »';
$string['enablestats'] = 'Activer les statistiques';
$string['enabletrusttext'] = 'Activer le système Contenu fiable';
$string['enablewebservices'] = 'Activer les services web';
$string['enablewsdocumentation'] = 'Documentation services web';
$string['encoding'] = 'Encodage';
$string['enrolinstancedefaults'] = 'Réglages par défaut des instances d\'inscription';
$string['enrolinstancedefaults_desc'] = 'Réglages par défaut de l\'inscription dans les nouveaux cours.';
$string['enrolmultipleusers'] = 'Inscrire les utilisateurs';
$string['environment'] = 'Environnement';
$string['environmenterrortodo'] = 'Vous devez résoudre tous les problèmes liés à l\'environnement (erreurs) décrits ci-dessus avant de continuer l\'installation de cette version de Moodle !';
$string['environmenterrorupgrade'] = 'Attention ! Veuillez résoudre tous les problèmes d\'environnement (erreurs) mentionnés ci-dessus avant de continuer la mise à jour vers cette version de Moodle ! La mise à jour sans correction de ces problèmes causera vraisemblablement des problèmes, par exemple des pertes de données. Voulez-vous vraiment continuer maintenant la mise à jour ?';
$string['environmentmustfixsetting'] = 'Le réglage PHP doit être modifié.';
$string['environmentok'] = 'Votre environnement serveur possède les modules requis.';
$string['environmentrecommendcustomcheck'] = 'l\'échec de ce test indique un problème potentiel';
$string['environmentrecommendinstall'] = 'devrait être installé et activé pour une fonctionnalité optimale';
$string['environmentrecommendversion'] = 'la version {$a->needed} est recommandée ; vous utilisez actuellement la version {$a->current}';
$string['environmentrequirecustomcheck'] = 'ce test doit réussir';
$string['environmentrequireinstall'] = 'doit être installé et activé';
$string['environmentrequireversion'] = 'la version {$a->needed} est requise ; vous utilisez actuellement la version {$a->current}';
$string['environmentsettingok'] = 'Réglage recommandé détecté';
$string['environmentshouldfixsetting'] = 'Le réglage PHP devrait être modifié.';
$string['environmentxmlerror'] = 'Erreur lors de la lecture des données d\'environnement ({$a->error_code})';
$string['errordeletingconfig'] = 'Une erreur est survenue lors de la suppression des enregistrements de configuration du plugin « {$a} ».';
$string['errors'] = 'Erreurs';
$string['errorsetting'] = 'Impossible d\'enregistrer le réglage';
$string['errorwithsettings'] = 'Certains réglages n\'ont pas pu être modifiés en raison d\'une erreur.';
$string['everyonewhocan'] = 'Tous les utilisateurs pouvant « {$a} »';
$string['exceptions'] = 'Exceptions';
$string['excludeoldflashclients'] = 'Version du client Flash requise';
$string['experimental'] = 'Expérimental';
$string['experimentalsettings'] = 'Réglages expérimentaux';
$string['extendedusernamechars'] = 'Autoriser les caractères spéciaux dans les noms d\'utilisateur';
$string['extramemorylimit'] = 'Limite de mémoire PHP';
$string['extrauserselectorfields'] = 'Lors de la sélection des utilisateurs, afficher et rechercher';
$string['fatalmagicquotesruntime'] = '<p>Grave erreur de configuration détectée. Veuillez en informer l\'administrateur du serveur.</p><p>Pour fonctionner correctement, Moodle nécessite la modification de certains réglages PHP par l\'administrateur.</p><p><code>magic_quotes_runtime</code> doit être réglé sur <code>off</code>.</p><p>Ce paramètre se règle en modifiant le fichier <code>php.ini</code>, la configuration de<br />Apache/IIS ou le fichier <code>.htaccess</code> sur le serveur.</p>';
$string['fatalsessionautostart'] = '<p>Grave erreur de configuration détectée. Veuillez en informer l\'administrateur du serveur.</p><p>Pour fonctionner correctement, Moodle nécessite la modification de certains réglages PHP par l\'administrateur.</p><p><code>session.auto_start</code> doit être réglé sur <code>off</code>.</p><p>Ce paramètre se règle en modifiant le fichier <code>php.ini</code>, la configuration de<br />Apache/IIS ou le fichier <code>.htaccess</code> sur le serveur.</p>';
$string['filecreated'] = 'Nouveau fichier créé';
$string['filestoredin'] = 'Enregistre le fichier dans le dossier :';
$string['filestoredinhelp'] = 'Où le fichier doit être stocké';
$string['filterall'] = 'Filtrer toutes les chaînes de caractères';
$string['filtermatchoneperpage'] = 'Filtrer une occurrence par page';
$string['filtermatchonepertext'] = 'Filtrer une occurrence par élément';
$string['filters'] = 'Filtres';
$string['filtersettings'] = 'Gestion des filtres';
$string['filtersettingsgeneral'] = 'Réglages généraux des filtres';
$string['filteruploadedfiles'] = 'Filtrer les fichiers déposés';
$string['forcelogin'] = 'Imposer la connexion';
$string['forceloginforprofileimage'] = 'Forcer les utilisateurs à se connecter pour voir les avatars';
$string['forceloginforprofileimage_help'] = 'Si ce réglage est activé, les utilisateurs doivent se connecter afin de voir les images des profils des utilisateurs (avatars). L\'avatar générique sera utilisé pour toutes les notifications par courriel.';
$string['forceloginforprofiles'] = 'Imposer la connexion pour les profils';
$string['forcetimezone'] = 'Imposer un fuseau horaire';
$string['framename'] = 'Nom du cadre';
$string['frontpage'] = 'Page d\'accueil';
$string['frontpagebackup'] = 'Sauvegarde page d\'accueil';
$string['frontpagedefaultrole'] = 'Rôle par défaut sur la page d\'accueil';
$string['frontpagefilters'] = 'Filtres de la page d\'accueil';
$string['frontpageloggedin'] = 'Éléments de la page d\'accueil, une fois connecté';
$string['frontpageoverrides'] = 'Dérogations aux permissions de la page d\'accueil';
$string['frontpagequestions'] = 'Questions de la page d\'accueil';
$string['frontpagerestore'] = 'Restauration page d\'accueil';
$string['frontpageroles'] = 'Rôles page d\'accueil';
$string['frontpagesettings'] = 'Réglages page d\'accueil';
$string['fullnamedisplay'] = 'Format d\'affichage des noms';
$string['gdrecommended'] = 'L\'extension GD est utilisée pour convertir les images. Certaines fonctionnalités, par exemple les avatars des profils, ne seront pas disponibles si GD est manquant.';
$string['gdversion'] = 'Version de GD';
$string['generalsettings'] = 'Réglages généraux';
$string['geoipfile'] = 'Fichier des données GeoIP City';
$string['getremoteaddrconf'] = 'Source de l\'adresse IP enregistrée';
$string['globalsquoteswarning'] = '<p><strong>Notification de sécurité</strong> : pour fonctionner correctement, Moodle nécessite <br />certaines modifications de vos réglages PHP actuels.<p/><p>Vous <em>devez</em> spécifier les réglages <code>register_globals=off</code> et/ou <code>magic_quotes_gpc=on</code>.<br />Si possible, veuillez effectuer le réglage <code>register_globals=off</code>, afin d\'augmenter la sécurité globale <br /> de votre serveur. L\'activation de l\'option <code>magic_quotes_gpc=on</code> est aussi recommandée.<p/><p>Ces réglages sont effectués en modifiant votre fichier <code>php.ini</code>, la configuration<br />de Apache/IIS ou du fichier <code>.htaccess</code>.</p>';
$string['globalswarning'] = '<p><strong>NOTIFICATION DE SÉCURITÉ !</strong></p><p>Pour fonctionner correctement, Moodle nécessite <br />certaines modifications de vos réglages PHP actuels.<p/><p>Vous <em>devez</em> spécifier le réglage <code>register_globals=off</code>.<p>Ce réglage s\'effectue en modifiant le fichier <code>php.ini</code>, la configuration <br />de Apache/IIS ou le fichier <code>.htaccess</code>.</p>';
$string['googlemapkey'] = 'Clef API de Google Maps';
$string['gotofirst'] = 'Afficher la première chaîne manquante';
$string['gradebook'] = 'Carnet de notes';
$string['gradebookroles'] = 'Rôles évalués';
$string['gradeexport'] = 'Modules principaux d\'exportation des notes';
$string['groupenrolmentkeypolicy'] = 'Règles pour les clefs d\'inscription aux groupes';
$string['groupenrolmentkeypolicy_desc'] = 'L\'activation de ce réglage permet d\'imposer aux clefs d\'inscription aux groupes les règles définies pour les mots de passe.';
$string['guestroleid'] = 'Rôle du compte « Visiteur anonyme »';
$string['guestroleid_help'] = 'Ce rôle est automatiquement attribué au compte Utilisateur anonyme. Il est également attribué temporairement aux utilisateurs qui entrent dans un cours via le plugin d\'inscription des utilisateurs anonymes.';
$string['helpadminseesall'] = 'Les administrateurs voient-ils tous les événements du calendrier ou seulement leurs propres événements ?';
$string['helpcalendarsettings'] = 'Configurer le calendrier de Moodle';
$string['helpforcetimezone'] = 'Vous pouvez autoriser les utilisateurs à choisir leur fuseau horaire ou imposer le même fuseau horaire pour tous.';
$string['helpsitemaintenance'] = 'Activer le mode de maintenance';
$string['helpstartofweek'] = 'Quel est le premier jour de la semaine dans le calendrier ?';
$string['helpupcominglookahead'] = 'Par défaut, combien de jours dans le futur le calendrier considère-t-il les événements à venir ?';
$string['helpupcomingmaxevents'] = 'Par défaut, quel est le nombre maximum d\'événements à venir affichés ?';
$string['helpweekenddays'] = 'Quel jours sont traités comme jours du « week-end » et affichés d\'une couleur différente ?';
$string['hiddenuserfields'] = 'Masquer les champs des utilisateurs';
$string['hidefromall'] = 'Cacher pour tous les utilisateurs';
$string['hidefromnone'] = 'Ne pas cacher';
$string['hidefromstudents'] = 'Cacher pour les étudiants';
$string['htmleditor'] = 'Éditeur WYSIWYG';
$string['htmleditorsettings'] = 'Réglages éditeur';
$string['htmlsettings'] = 'Réglages HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Sécurité HTTP';
$string['iconvrecommended'] = 'Bien que l\'extension ICONV de PHP soit facultative, il est vivement recommandé de l\'installer sur le serveur pour de meilleures performances, notamment si votre site supporte des caractères non latins.';
$string['iconvrequired'] = 'L\'installation de l\'extension ICONV de PHP est requise.';
$string['ignore'] = 'Ignorer';
$string['importlangreminder'] = 'Le processus de migration de la base de données commence. Il vous sera nécessaire de <b>vous connecter à nouveau</b> pour que la mise à jour prenne effet. Veuillez installer le paquetage de langue en encodage Unicode aussitôt que possible en suivant Administration -> Langue -> Utilitaire d\'importation de langue <b>après</b> que le processus de migration de la base de données est terminé.';
$string['importtimezones'] = 'Mise à jour des fuseaux horaires';
$string['importtimezonescount'] = '{$a->count} entrées importées depuis {$a->source}';
$string['importtimezonesfailed'] = 'Aucune source de données trouvée !';
$string['includemoduleuserdata'] = 'Inclure les données utilisateurs des modules';
$string['incompatibleblocks'] = 'Blocs incompatibles';
$string['install'] = 'Installer les langues sélectionnées';
$string['installedlangs'] = 'Langues installées';
$string['installhijacked'] = 'L\'installation doit être terminée depuis la même adresse IP.';
$string['installsessionerror'] = 'Impossible d\'initialiser la session PHP. Veuillez vérifier que votre navigateur accepte les cookies.';
$string['intcachemax'] = 'Int. cache max';
$string['intlrecommended'] = 'L\'installation de l\'extension optionnelle Intl de PHP est utilisée pour améliorer le support de l\'internationalisation, par exemple pour les tris alphabétiques.';
$string['invalidlangpack'] = 'Pour pouvoir modifier ce paquetage de langue, veuillez le placer dans le dossier des langues de votre dossier de données.';
$string['invalidsection'] = 'Section non valide.';
$string['invaliduserchangeme'] = 'Le nom d\'utilisateur « changeme » est réservé. Il n\'est pas permis de créer un compte de ce nom.';
$string['ipblocked'] = 'Ce site n\'est actuellement pas accessible.';
$string['ipblocker'] = 'Blocage IP';
$string['ipblockersyntax'] = 'Indiquer une adresse (complète ou partielle) ou une plage d\'adresses par ligne. Des entrées valides sont soit une adresse IP complète (par exemple <b>192.168.10.1</b>), qui correspond à un seul serveur, soit une adresse IP partielle, (par exemple <b>192.168.</b>), qui correspond à la plage des adresses commençant par ces nombres, ou une adresse en format CIDR (par exemple <b>231.54.211.0/20</b>), ou encore une plage d\'adresses IP (par exemple <b>231.3.56.10-20</b>) dans laquelle la plage est indiquée sur la dernière partie de l\'adresse. Les noms de domaines (comme « exemple.fr ») ne sont pas autorisés. Les lignes vides sont ignorées.';
$string['iplookup'] = 'Recherche d\'adresse IP';
$string['iplookupinfo'] = 'Par défaut, Moodle utilise le service en ligne gratuit NetGeo (Internet Geographic Database) pour afficher la localisation des adresses IP. Malheureusement cette base de données n\'est plus entretenue et peut fournir des résultats <em>totalement faux</em>. Il est recommandé d\'installer sur votre serveur une copie gratuite de la base de données GeoLite City de MaxMind.<br />La localisation des adresses IP est affichée sur une simple carte ou à l\'aide de Google Maps. Veuillez remarquer que vous aurez besoin d\'un compte Google et de demander une clef gratuite pour l\'utilisation de l\'API de Google Maps API pour activer les cartes interactives.';
$string['iplookupmaxmindnote'] = 'Ce produit comprend les données GeoLite créées par MaxMind, disponibles gratuitement chez <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['iplookupnetgeonote'] = 'Le serveur NetGeo est actuellement utilisé pour trouver les informations géographiques. Pour obtenir des résultats plus précis, nous recommandons l\'installation d\'une copie de la base de données MaxMind GeoLite sur votre serveur.';
$string['jabber'] = 'Jabber';
$string['jabberhost'] = 'Serveur Jabber';
$string['jabberpassword'] = 'Mot de passe Jabber';
$string['jabberport'] = 'Port Jabber';
$string['jabberserver'] = 'Serveur Jabber';
$string['jabberusername'] = 'Nom d\'utilisateur Jabber';
$string['keeptagnamecase'] = 'Conserver la casse des tags';
$string['lang'] = 'Langue par défaut';
$string['lang16notify'] = 'Les versions de Moodle 1.6 et suivantes vous permettent d\'installer et de mettre à jour les langues directement depuis download.moodle.org en suivant le lien ci-dessous';
$string['langcache'] = 'Cache du menu des langues';
$string['langcache_desc'] = 'Mettre en cache le menu des langues. L\'activation de cette option met en cache la liste des langues disponibles. Le cache est automatiquement reconstruit lors de l\'installation ou de la suppression d\'une langue par le gestionnaire des langues de Moodle. Si vous installez une langue manuellement, veuillez utiliser la fonction de purge des caches pour actualiser la liste.';
$string['langedit'] = 'Modification langue';
$string['langimport'] = 'Utilitaire d\'importation de langues';
$string['langimportdisabled'] = 'L\'utilitaire d\'importation de langues a été désactivé. Veuillez effectuer la mise à jour de vos paquetages de langue manuellement au niveau du système de fichiers de votre serveur.';
$string['langimportsuccess'] = 'Le paquetage de langue a été correctement mis à jour';
$string['langlist'] = 'Langues du menu des langues';
$string['langlocalpackage'] = 'Modifications locales';
$string['langmasterenglish'] = 'Paquetage principal anglais';
$string['langmasterpackage'] = 'Paquetage de langue principal';
$string['langmenu'] = 'Afficher le menu des langues';
$string['langnoeditenglish'] = 'Il n\'est pas possible d\'écraser le paquetage de langue de base en anglais. Veuillez changer de dossier de langue pour effectuer des changements locaux';
$string['langpackinstalled'] = 'Le paquetage de langue {$a} a été correctement installé';
$string['langpackmaintaining'] = 'Maintenance des paquetages de langue';
$string['langpackremoved'] = 'La désinstallation du paquetage de langue est terminée';
$string['langpacks'] = 'Paquetages langue';
$string['langpackupdated'] = 'Le paquetage de langue {$a} a été correctement mis à jour';
$string['langpackupdateskipped'] = 'La mise à jour du paquetage de langue {$a} n\'a pas été effectuée';
$string['langpackwillbeupdated'] = 'Au cours de la mise à jour, Moodle mettra également à jour les paquetages de langue installés.';
$string['langrmyourself'] = 'Pour éviter des pertes de données, Moodle ne peut pas écraser un fichier existant. Veuillez supprimer ce fichier manuellement pour vous en débarrasser.';
$string['langstringcache'] = 'Mettre en cache toutes les chaînes de langue';
$string['languagesettings'] = 'Réglages langue';
$string['langupdatecomplete'] = 'La mise à jour des langues est terminée';
$string['latexpreamble'] = 'Préambule LaTeX';
$string['latexsettings'] = 'Réglages de LaTeX Renderer';
$string['latinexcelexport'] = 'Encodage Excel';
$string['legacyfilesinnewcourses'] = 'Fichiers du cours (obsolète) dans les nouveaux cours';
$string['legacyfilesinnewcourses_help'] = 'Par défaut, les zones de fichiers du cours (obsolètes) ne sont disponibles que dans les cours provenant de mises à jour de versions antérieures. Veuillez prendre note que certaines fonctionnalités, notamment la sauvegarde et la restauration d\'une activité unique, ne sont pas compatibles avec ce réglage.';
$string['licensesettings'] = 'Réglages de licence';
$string['loading'] = 'Chargement';
$string['localetext'] = 'Locale du site';
$string['localstringcustomization'] = 'Modification locale des chaînes de caractères';
$string['location'] = 'Lieu';
$string['locationsettings'] = 'Réglages lieu';
$string['locked'] = 'verrouillé';
$string['log'] = 'Historiques';
$string['logguests'] = 'Enregistrer les historiques de l\'utilisateur anonyme';
$string['logguests_help'] = 'Ce réglage permet d\'enregistrer les actions du compte utilisateur anonyme et des utilisateurs non authentifiés. Les sites avec un grand trafic de visiteurs anonymes devraient désactiver cette option en cas de baisse de performance. Il est recommandé d\'activer ce réglage sur les sites en production.';
$string['loginhttps'] = 'Utiliser HTTPS pour les connexions';
$string['loginpasswordautocomplete'] = 'Empêcher l\'auto-complétion du mot de passe sur le formulaire de connexion';
$string['loginpasswordautocomplete_help'] = 'Quand cette option est désactivée, les utilisateurs peuvent enregistrer le mot de passe de leur compte dans leur navigateur. L\'activation de l\'option aura pour résultat collatéral que votre site ne sera plus conforme aux règles de validation du XHTML strict.';
$string['loglifetime'] = 'Conserver les historiques durant';
$string['longtimewarning'] = '<b>Veuillez remarquer que ce processus peut prendre beaucoup de temps.</b>';
$string['mail'] = 'Courriel';
$string['mailnewline'] = 'Caractère de fin de ligne des courriels';
$string['maintenancemode'] = 'En mode de maintenance';
$string['maintfileopenerror'] = 'Erreur lors de l\'ouverture des fichiers de maintenance !';
$string['maintinprogress'] = 'Opérations de maintenance en cours...';
$string['managelang'] = 'Gérer';
$string['managelicenses'] = 'Gérer les licences';
$string['manageqtypes'] = 'Gérer les types de question';
$string['maturity100'] = 'Bêta';
$string['maturity150'] = 'Version candidate';
$string['maturity200'] = 'Version stable';
$string['maturity50'] = 'Alpha';
$string['maturitycorewarning'] = 'Vous êtes sur le point d\'installer une version ou de mettre à jour Moodle vers un version marquée comme « {$a} », qui n\'est pas considérée comme prête pour la production. Veuillez vous assurer que cette action est intentionnelle et que vous utilisez la version voulue de Moodle.';
$string['maxbytes'] = 'Taille maximale des fichiers déposés';
$string['maxconsecutiveidentchars'] = 'Caractères identiques consecutifs';
$string['maxeditingtime'] = 'Durée maximale de modification des messages';
$string['mbstringrecommended'] = 'Bien que la bibliothèque MBSTRING soit facultative, il est vivement recommandé de l\'installer sur le serveur pour de meilleures performances, notamment si votre site supporte des caractères non latins.';
$string['mediapluginavi'] = 'Activer le filtre .avi';
$string['mediapluginflv'] = 'Activer le filtre .flv';
$string['mediapluginimg'] = 'Activer l\'intégration automatique d\'images liées';
$string['mediapluginmov'] = 'Activer le filtre .mov';
$string['mediapluginmp3'] = 'Activer le filtre .mp3';
$string['mediapluginmpg'] = 'Activer le filtre .mpg';
$string['mediapluginogg'] = 'Autoriser le filtre .ogg';
$string['mediapluginogv'] = 'Autoriser le filtre .ogv';
$string['mediapluginram'] = 'Activer le filtre .ram';
$string['mediapluginrm'] = 'Activer le filtre .rm';
$string['mediapluginrpm'] = 'Activer le filtre .rpm';
$string['mediapluginswf'] = 'Activer le filtre .swf';
$string['mediapluginswfnote'] = 'Par mesure de sécurité, les utilisateurs normaux ne devraient pas avoir la permission d\'intégrer des fichiers flash au format swf.';
$string['mediapluginwmv'] = 'Activer le filtre .wmv';
$string['mediapluginyoutube'] = 'Activer le filtre YouTube';
$string['memcachedhosts'] = 'Serveurs memcached';
$string['memcachedpconn'] = 'Utiliser des connexions memcached persistantes';
$string['messaging'] = 'Activer la messagerie';
$string['messagingdeletereadnotificationsdelay'] = 'Supprimer les notifications de lecture';
$string['messaginghidereadnotifications'] = 'Cacher les notifications de lecture';
$string['minpassworddigits'] = 'Chiffres';
$string['minpasswordlength'] = 'Longueur du mot de passe';
$string['minpasswordlower'] = 'Lettres minuscules';
$string['minpasswordnonalphanum'] = 'Caractères non alphanumériques';
$string['minpasswordupper'] = 'Lettres majuscules';
$string['misc'] = 'Divers';
$string['missinglangparent'] = 'Le paquetage de la langue parente <em>{$a->parent}</em> de <em>{$a->lang}</em> n\'est pas installé.';
$string['mnetrestore_extusers'] = '<strong>Remarque :</strong> ce fichier de sauvegarde contient des comptes utilisateurs distants provenant d\'un réseau Moodle, qui seront restaurés au cours du processus.';
$string['mnetrestore_extusers_admin'] = '<strong>Remarque :</strong> ce fichier de sauvegarde semble provenir d\'une installation de Moodle différente et contient des comptes utilisateurs distants du Réseau Moodle. Le processus de restauration tentera de faire correspondre les serveur Réseau Moodle pour tous les utilisateurs créés. Ceux qui n\'auront pas de correspondance seront automatiquement basculés en mode d\'authentification interne (au lieu de mnet). L\'historique de restauration vous informera à ce sujet.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Remarque :</strong> ce fichier de sauvegarde semble provenir d\'une installation de Moodle différente. Il contient des comptes utilisateurs distants provenant d\'un réseau Moodle dont la restauration pourrait échouer. Cette opération n\'est pas supportée. Si vous êtes vraiment certain que ce fichier a été créé sur ce Moodle, ou si vous pouvez vous assurer que tous les serveurs du réseau Moodle sont configurés correctement, vous pouvez malgré tout tenter la restauration.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Remarque :</strong> ce fichier de sauvegarde semble provenir d\'une installation de Moodle différente et contient des comptes utilisateurs distants du Réseau Moodle. Vous n\'êtes pas autorisé à effectuer ce type de restauration. Veuillez contacter l\'administrateur du site ou restaurer le cours sans les informations des utilisateurs (modules, fichiers, etc.)';
$string['mnetrestore_extusers_switchuserauth'] = 'Authentification de l\'utilisateur {$a->username} du Réseau Moodle distant (provenant de {$a->mnethosturl}) basculée vers utilisateur authentifié localement {$a->auth}.';
$string['modeditdefaults'] = 'Valeurs par défaut des réglages des activités';
$string['modsettings'] = 'Gestion des activités';
$string['modulesecurity'] = 'Sécurité modules';
$string['multilangforceold'] = 'Imposer l\'ancienne syntaxe du filtre multilingue : &lt;span&gt; sans class="multilang" et &lt;lang&gt;';
$string['multilangupgrade'] = 'Mise à jour de la syntaxe multilingue';
$string['multilangupgradeinfo'] = 'La syntaxe du filtre multilingue a été modifiée à partir de la version 1.8 : la balise &lt;lang&gt; n\'est plus supportée.<br /><br />Exemple : &lt;span lang="en" class="multilang">Hello!&lt;/span&gt;&lt;span lang="fr" class="multilang">Bonjour !&lt;/span&gt;<br /><br /><strong>Voulez-vous mettre à jour maintenant la syntaxe multilingue dans tous les textes existants ?</strong>';
$string['multilangupgradenotice'] = 'Votre site utilise vraisemblablement l\'ancienne syntaxe du filtre multilingue. La <a href="multilangupgrade.php">mise à jour de la syntaxe multilingue</a> est recommandée.';
$string['mustenablestats'] = 'Les statistiques n\'ont pas encore été activées sur ce site.';
$string['mycoursesperpage'] = 'Nombre de cours';
$string['mydashboard'] = 'Tableau de bord par défaut';
$string['mymoodle'] = 'Mon Moodle';
$string['mymoodleredirect'] = 'Imposer aux utilisateurs l\'utilisation de Mon Moodle';
$string['mypage'] = 'Page Mon Moodle par défaut';
$string['mypagelocked'] = 'Verrouiller la page par défaut';
$string['myprofile'] = 'Page de profil par défaut';
$string['mysql416bypassed'] = 'Toutefois, si votre site utilise UNIQUEMENT des langues encodées en iso-8859-1 (latin), vous pouvez continuer à utiliser votre version actuelle de MySQL 4.1.12 (ou ultérieure).';
$string['mysql416required'] = 'MySQL 4.1.16 est la version minimale requise pour Moodle 1.6, afin de garantir que toutes les données pourront à l\'avenir être converties en encodage UTF-8.';
$string['navcourselimit'] = 'Limite de cours';
$string['navigationupgrade'] = 'Cette mise à jour introduit deux nouveaux blocs de navigation destinés à remplacer les blocs suivants : Administration, Cours, Activités et Participants. Si vous avez défini des permissions particulières pour ces blocs, veuillez vérifier que tout fonctionne comme vous le désirez.';
$string['navshowallcourses'] = 'Afficher tous les cours';
$string['navshowcategories'] = 'Afficher les catégories de cours';
$string['neverdeleteruns'] = 'Ne jamais supprimer les profilages';
$string['nobookmarksforuser'] = 'vous n\'avez pas de marque-page.';
$string['nochanges'] = 'Aucune modification';
$string['nodatabase'] = 'Pas de base de données';
$string['nolangupdateneeded'] = 'Toutes les langues sont à jour. Aucune mise à jour n\'est nécessaire';
$string['nomissingstrings'] = 'Aucune chaîne manquante';
$string['nonewsettings'] = 'Aucun nouveau réglage n\'a été ajouté lors de cette mise à jour.';
$string['nonexistentbookmark'] = 'Le marque-page demandé n\'existe pas.';
$string['noreplyaddress'] = 'Adresse de non-réponse';
$string['noresults'] = 'Aucun résultat trouvé.';
$string['noroles'] = 'Pas de rôle';
$string['notifications'] = 'Notifications';
$string['notifyloginfailures'] = 'Envoyer les erreurs de connexion à';
$string['notifyloginthreshold'] = 'Seuil pour les notifications par courriel';
$string['notloggedinroleid'] = 'Rôle des utilisateurs non connectés';
$string['numberofmissingstrings'] = 'Nombre de chaînes de caractères manquantes : {$a}';
$string['numberofstrings'] = 'Nombre total de  chaînes de caractères : {$a->strings}<br />Manquantes : {$a->missing} ({$a->missingpercent} %)';
$string['numcoursesincombo'] = 'Nombre maximum de cours dans la liste combinée';
$string['numcoursesincombo_help'] = 'La liste combinée ne fonctionne pas bien avec un grand nombre de cours. Si le nombre total de cours sur ce site est plus grand que la valeur indiquée, un lien vers une liste des cours sera affiché sur la page d\'accueil, au lieu de la liste complète.';
$string['numquestions'] = 'No. de questions';
$string['numquestionsandhidden'] = '{$a->numquestions} (+ {$a->numhidden} cachées)';
$string['opensslrecommended'] = 'L\'installation de la bibliothèque optionnelle OpenSSL est vivement recommandée, afin de pouvoir utiliser la fonctionnalité Réseau Moodle.';
$string['opentogoogle'] = 'Ouvert à Google';
$string['optionalmaintenancemessage'] = 'Message de maintenance facultatif';
$string['order1'] = 'Premier';
$string['order2'] = 'Deuxième';
$string['order3'] = 'Troisième';
$string['order4'] = 'Quatrième';
$string['passwordpolicy'] = 'Règles pour les mots de passe';
$string['pathconvert'] = 'Chemin d\'accès du logiciel <i>convert</i>';
$string['pathdvips'] = 'Chemin d\'accès du logiciel <i>dvips</i>';
$string['pathlatex'] = 'Chemin d\'accès du logiciel <i>latex</i>';
$string['pathtoclam'] = 'Chemin d\'accès du logiciel <i>clam AV</i>';
$string['pathtodot'] = 'Chemin d\'accès à dot';
$string['pathtodot_help'] = 'En principe /usr/bin/dot. Pour permettre de générer des fichiers graphiques à partir de fichiers DOT, vous devez installer l’exécutable dot et indiquer ici son chemin d\'accès. Ceci n\'est pour l\'instant utilisé que dans les fonctions de profilage de Moodle (Développement -> Profilage).';
$string['pathtodu'] = 'Chemin d\'accès du logiciel <i>du</i>';
$string['pathtopgdump'] = 'Chemin d\'accès du logiciel <i>pg_dump</i>';
$string['pathtopgdumpdesc'] = 'Il n\'est nécessaire de renseigner ce champ que si vous avez plus d\'un programme <i>pg_dump</i> sur votre serveur (par exemple si plus d\'une version de postgresql est installée)';
$string['pathtopgdumpinvalid'] = 'Chemin d\'accès à <i>pg_dump</i> non valide. Le chemin est incorrect ou le programme n\'est pas exécutable';
$string['pathtopsql'] = 'Chemin d\'accès du logiciel <i>psql</i>';
$string['pathtopsqldesc'] = 'Il n\'est nécessaire de renseigner ce champ que si vous avez plus d\'un programme <i>psql</i> sur votre serveur (par exemple si plus d\'une version de postgresql est installée)';
$string['pathtopsqlinvalid'] = 'Chemin d\'accès à <i>psql</i> non valide. Le chemin est incorrect ou le programme n\'est pas exécutable';
$string['pathtounzip'] = 'Chemin d\'accès du logiciel <i>unzip</i>';
$string['pathtozip'] = 'Chemin d\'accès du logiciel <i>zip</i>';
$string['perfdebug'] = 'Informations de performance';
$string['performance'] = 'Performance';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'Paramètre de version/cluster de PostgreSQL pour les opérations en ligne de commande. Si vous n\'avez qu\'un seul postgresql sur votre serveur ou n\'êtes pas sûr de ce dont il s\'agit, laissez ce champ vide.';
$string['php50restricted'] = 'Les versions 5.0.x de PHP ont plusieurs problèmes connus. Veuillez mettre à jour PHP à la version 5.1.x ou revenir à une version 4.3.x ou 4.4.x';
$string['php533warning'] = 'PHP 5.3.3 ou ultérieur est recommandé';
$string['phpfloatproblem'] = 'Un problème a été détecté dans le traitement des nombres par PHP : {$a}';
$string['pleaserefreshregistration'] = 'Votre site a été enregistré sur moodle.org. Veuillez envisager de mettre à jour cet enregistrement si des modifications importantes sont survenues depuis votre dernière mise à jour, le {$a}';
$string['pleaseregister'] = 'Pour enlever ce bouton, veuillez enregistrer votre site';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugins';
$string['profilecategory'] = 'Catégorie';
$string['profilecategoryname'] = 'Nom de catégorie (doit être unique)';
$string['profilecategorynamenotunique'] = 'Ce nom de catégorie est déjà utilisé';
$string['profilecommonsettings'] = 'Réglages communs';
$string['profileconfirmcategorydeletion'] = 'Le(s) {$a} champ(s) de cette catégorie seront déplacés dans la catégorie ci-dessus (ou ci-dessous s\'ils sont dans la catégorie racine).<br />Voulez-vous vraiment supprimer cette catégorie ?';
$string['profileconfirmfielddeletion'] = 'Les {$a} enregistrement(s) de ce champ seront supprimés.<br />Voulez-vous vraiment supprimer ce champ ?';
$string['profilecreatecategory'] = 'Créer une nouvelle catégorie de profil';
$string['profilecreatefield'] = 'Créer un nouveau champ de profil :';
$string['profilecreatenewcategory'] = 'Création d\'une catégorie';
$string['profilecreatenewfield'] = 'Création d\'un nouveau champ de profil « {$a} »';
$string['profiledefaultcategory'] = 'Autres champs';
$string['profiledefaultchecked'] = 'Cochée par défaut';
$string['profiledefaultdata'] = 'Valeur par défaut';
$string['profiledeletecategory'] = 'Suppression d\'une catégorie';
$string['profiledeletefield'] = 'Suppression d\'un champ';
$string['profiledescription'] = 'Description du champ';
$string['profiledscript'] = 'Ce script a été profilé';
$string['profiledscriptview'] = 'Afficher l\'information de profilage de ce script';
$string['profileeditcategory'] = 'Modification de la catégorie {$a}';
$string['profileeditfield'] = 'Modification du champ {$a}';
$string['profilefield'] = 'Champ de profil';
$string['profilefieldcolumns'] = 'Colonnes';
$string['profilefieldispassword'] = 'Champ mot de passe';
$string['profilefieldlink'] = 'Lien';
$string['profilefieldlink_help'] = 'Pour transformer un texte en lien, tapez une URL contenant $$. Les $$ seront remplacés par le texte. Par exemple pour transformer un identifiant Twitter en lien, tapez http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Cible du lien';
$string['profilefieldmaxlength'] = 'Longueur maximale';
$string['profilefieldrows'] = 'Lignes';
$string['profilefields'] = 'Champs du profil';
$string['profilefieldsize'] = 'Taille d\'affichage';
$string['profileforceunique'] = 'Les données du champ doivent-elles être uniques ?';
$string['profileinvaliddata'] = 'Valeur incorrecte';
$string['profilelocked'] = 'Ce champ est-il verrouillé ?';
$string['profilemenudefaultnotinoptions'] = 'La valeur par défaut n\'est pas une des options';
$string['profilemenunooptions'] = 'Aucune option de menu n\'est donnée';
$string['profilemenuoptions'] = 'Options de menu (une par ligne)';
$string['profilemenutoofewoptions'] = 'Vous devez fournir au moins 2 options';
$string['profilename'] = 'Nom';
$string['profilenofieldsdefined'] = 'Aucun champ n\'a été défini';
$string['profilerequired'] = 'Ce champ est-il requis ?';
$string['profileroles'] = 'Rôles affichés dans les profils';
$string['profilesforenrolledusersonly'] = 'Affichage du profil des utilisateurs inscrits à des cours uniquement';
$string['profileshortname'] = 'Nom abrégé (doit être unique)';
$string['profileshortnamenotunique'] = 'Ce nom abrégé est déjà utilisé';
$string['profilesignup'] = 'Afficher sur la page de création de compte ?';
$string['profilespecificsettings'] = 'Réglages spécifiques';
$string['profilevisible'] = 'Pour qui ce champ est-il visible ?';
$string['profilevisibleall'] = 'Visible pour tous';
$string['profilevisible_help'] = '* caché : pour les données privées, uniquement visible pour les administrateurs
* visible pour l\'utilisateur : pour les données personnelles, visibles par l\'utilisateur et les administrateurs
* visible pour tous';
$string['profilevisiblenone'] = 'Caché';
$string['profilevisibleprivate'] = 'Visible pour l\'utilisateur';
$string['profiling'] = 'Profilage';
$string['profilingallowall'] = 'Profilage en continu';
$string['profilingallowall_help'] = 'Si vous activez ce réglage, vous pourrez utilisez à tout moment le paramètre PROFILEALL pour activer le profilage de tous les scripts exécutés au cours d\'une session Moodle. De façon analogue, vous pourrez utiliser le paramètre PROFILEALLSTOP pour stopper le profilage.';
$string['profilingallowme'] = 'Profilage sélectif';
$string['profilingallowme_help'] = 'Si vous activez ce réglage, vous pourrez utiliser sélectivement le paramètre PROFILEME et le profilage du script concerné aura lieu. De façon analogue, vous pourrez utiliser le paramètre DONTPROFILEME pour éviter le profilage.';
$string['profilingautofrec'] = 'Profilage automatique';
$string['profilingautofrec_help'] = 'Après activation de ce réglage, certaines requêtes seront choisies aléatoirement, sur la base de la fréquence spécifiée (entre 1 et la valeur du paramètre) et profilées automatiquement, et les résultats du profilage seront stockés pour analyse ultérieure. Ce type de profilage respecte les réglages d\'inclusion/exclusion. Une valeur 0 désactive le profilage automatique.';
$string['profilingenabled'] = 'Activer le profilage';
$string['profilingenabled_help'] = 'Ce réglage permet d\'activer le profilage pour votre site. Vous pourrez alors définir comment le profilage se déroule à l\'aide des options ci-dessous.';
$string['profilingexcluded'] = 'Exclure du profilage';
$string['profilingexcluded_help'] = 'Liste d\'URLs (séparés par des virgules) qui seront exclus du profilage.';
$string['profilingincluded'] = 'Scripts à profiler';
$string['profilingincluded_help'] = 'Liste d\'URLs (séparés par des virgules) qui seront automatiquement profilés. Exemples : /index.php, /course/view.php. Ce champ accepte le caractère joker * à n\'importe quel endroit, par exemple /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Conserver les profilages';
$string['profilinglifetime_help'] = 'Veuillez indiquer le laps de temps durant lequel vous désirez conserver les informations d\'anciens profilages. Les plus anciens seront supprimés périodiquement. Les profilages marqués comme « profilage de référence » ne sont pas concernés par ce réglage et seront de toute manière conservés.';
$string['protectusernames'] = 'Protéger les noms d\'utilisateur';
$string['proxybypass'] = 'Exceptions du proxy';
$string['proxyhost'] = 'Hôte du proxy';
$string['proxypassword'] = 'Mot de passe du proxy';
$string['proxyport'] = 'Port du proxy';
$string['proxytype'] = 'Type de proxy';
$string['proxyuser'] = 'Nom d\'utilisateur du proxy';
$string['purgecaches'] = 'Vider tous les caches';
$string['purgecachesconfirm'] = 'Moodle peut placer en cache les thèmes, le code JavaScript, les chaînes de caractères traduites, le texte filtré, les flux RSS et beaucoup d\'autres données calculées. En effaçant ces caches, des données seront supprimées du serveur et forceront les navigateurs à recalculer les données pour être sûr que les données affichées sont bien celles qui sont à jour. L\'effacement des caches ne cause aucun problème, mais votre site semblera plus lent durant un certain temps, car le serveur et les clients devront calculer les nouvelles données et les placer en cache.';
$string['purgecachesfinished'] = 'Tous les caches ont été vidés.';
$string['qtypedeletefiles'] = 'Toutes les données associées au type de question « {$a->qtype} » ont été supprimées de la base de données. Pour achever la suppression (et éviter ainsi que le type de question se réinstalle automatiquement), vous devez maintenant supprimer de votre serveur le dossier {$a->directory}';
$string['qtyperqpwillberemoved'] = 'Au cours de cette mise à jour, le type de question RQP sera supprimé. Vous n\'utilisiez pas ce type de question, et ne souffrirez donc d\'aucun problème.';
$string['qtyperqpwillberemovedanyway'] = 'Au cours de cette mise à jour, le type de question RQP sera supprimé. Votre base de données comporte des questions RQP, qui ne fonctionneront plus, à moins que vous ne réinstalliez le code disponible sur http://moodle.org/mod/data/view.php?d=13&amp;rid=797 avant de continuer la mise à jour.';
$string['quarantinedir'] = 'Dossier de quarantaine';
$string['question'] = 'Question';
$string['questioncwqpfscheck'] = 'Une ou plusieurs questions aléatoires d\'un test tire ses questions de catégories partagées et de catégories non partagées. Un rapport plus détaillé est visible <a href="{$a->reporturl}">ici</a>. Veuillez consulter Moodle Docs sur <a href="{$a->docsurl}">cette page</a>.';
$string['questioncwqpfsok'] = 'Il n\'y a dans vos tests aucune question aléatoire tirant ses questions de catégories partagées et de catégories non partagées.';
$string['questiontype'] = 'Type de question';
$string['questiontypes'] = 'Types de question';
$string['rcache'] = 'Cache des enregistrements';
$string['rcachettl'] = 'TTL des enregistrements en cache';
$string['recaptchaprivatekey'] = 'Clef privée ReCAPTCHA';
$string['recaptchapublickey'] = 'Clef publique ReCAPTCHA';
$string['registration'] = 'Enregistrement';
$string['releasenoteslink'] = 'Pour des informations sur cette version de Moodle, veuillez consulter les <a target="_blank" href="{$a}">Notes de mise à jour</a> en ligne.';
$string['remotelangnotavailable'] = 'Moodle ne peut pas se connecter au site download.moodle.org. L\'installation automatique des langues ne peut donc pas avoir lieu. Veuillez télécharger le(s) fichier(s) compressé(s) nécessaire(s) dans la liste ci-dessous, les copier dans votre dossier {$a} et les décompresser manuellement.';
$string['renameerrors'] = 'Erreurs lors du changement de nom';
$string['requiredentrieschanged'] = '<strong>IMPORTANT !<br />(Ce message d\'avertissement ne sera affiché que durant cette mise à jour.)</strong><br/>En raison de la correction d\'un bogue, le comportement des bases de données qui utilisent les réglages « Fiches requises » et « Fiches requises avant consultation » est modifié. Une explication détaillée des changements peut être lue dans le <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forum dédié au module Base de données (en anglais)</a> et <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs (en anglais pour l\'instant)</a>.<br/><br/>Cette modification a un impact sur les bases de données suivantes de votre Moodle : (veuillez enregistrer cette liste maintenant et, une fois la mise à jour effectuée, vérifier que ces activités continuent de fonctionner de la façon désirée par l\'enseignant.)<br/><strong>{$a->text}</strong><br/>';
$string['requiredtemplate'] = 'Requis. Vous pouvez utiliser ici la syntaxe de modèle (%l = nom, %f = prénom, %u = nom d\'utilisateur). Voir l\'aide pour des détails et des exemples.';
$string['requiremodintro'] = 'Exiger une description';
$string['requires'] = 'Requiert';
$string['restrictbydefault'] = 'Restreindre par défaut les modules';
$string['restrictmodulesfor'] = 'Restreindre les modules pour';
$string['reverseproxy'] = 'Proxy inverse';
$string['riskconfig'] = 'Les utilisateurs pourraient modifier la configuration et le comportement du site';
$string['riskconfigshort'] = 'Configuration des risques';
$string['riskdataloss'] = 'Les utilisateurs pourraient détruire une grande quantité de contenus ou d\'informations';
$string['riskdatalossshort'] = 'Risque de perte de données';
$string['riskmanagetrust'] = 'Les utilisateurs pourraient modifier les réglages de confiance d\'autres utilisateurs';
$string['riskmanagetrustshort'] = 'Gestion des réglages de confiance';
$string['riskpersonal'] = 'Les utilisateurs pourraient avoir accès aux informations personnelles d\'autres utilisateurs';
$string['riskpersonalshort'] = 'Risque lié à la protection des données';
$string['riskspam'] = 'Les utilisateurs pourraient envoyer du spam à des utilisateurs du site ou d\'autres personnes';
$string['riskspamshort'] = 'Risque de spam';
$string['riskxss'] = 'Les utilisateurs pourraient déposer des fichiers ou écrire des textes permettant le « cross-site scripting » (XSS)';
$string['riskxssshort'] = 'Risque XSS';
$string['roleswithexceptions'] = '{$a->roles}, avec {$a->exceptions}';
$string['rowpreviewnum'] = 'Rangées de prévisualisation';
$string['rssglobaldisabled'] = 'Désactivé au niveau du site';
$string['runclamavonupload'] = 'Vérifier les fichiers déposés avec clam AV';
$string['save'] = 'Enregistrer';
$string['savechanges'] = 'Enregistrer les modifications';
$string['search'] = 'Recherche';
$string['searchinsettings'] = 'Recherche dans les paramètres';
$string['searchresults'] = 'Résultats';
$string['sectionerror'] = 'Erreur de section !';
$string['secureforms'] = 'Utiliser une meilleure sécurité pour les formulaires';
$string['security'] = 'Sécurité';
$string['server'] = 'Serveur';
$string['serverchecks'] = 'Contrôles serveur';
$string['serverlimit'] = 'Limite serveur';
$string['sessionautostartwarning'] = '<p>Une grave erreur de configuration a été détectée. Veuillez en informer l\'administrateur du serveur.</p><p>Pour fonctionner correctement, Moodle a besoin que cet administrateur change les réglages PHP.</p><p>Le réglage <code>session.auto_start</code> doit être désactivé (<code>off</code>).</p><p>Ce réglage peut être modifié sur le serveur dans le fichier <code>php.ini</code>, dans la <br />configuration de Apache/IIS ou dans le fichier <code>.htaccess</code>.</p>';
$string['sessioncookie'] = 'Préfixe du cookie';
$string['sessioncookiedomain'] = 'Domaine du cookie';
$string['sessioncookiepath'] = 'Chemin d\'accès au cookie';
$string['sessionhandling'] = 'Gestion des sessions';
$string['sessiontimeout'] = 'Délai d\'attente';
$string['settingfileuploads'] = 'Le dépôt de fichiers est nécessaire pour un fonctionnement normal. Veuillez l\'activer dans la configuration de PHP.';
$string['settingmemorylimit'] = 'Mémoire insuffisante détectée. Veuillez fixer une limite de mémoire plus élevée dans la configuration de PHP.';
$string['settingsafemode'] = 'Moodle n\'est pas totalement compatible avec le <i>safe mode</i>. Veuillez demander à l\'administrateur du serveur de le désactiver. Le fonctionnement de Moodle avec le <i>safe mode</i> actif n\'est pas supporté. Vous rencontrerez vraisemblablement des problèmes si vous essayez.';
$string['showcommentscount'] = 'Afficher le nombre des commentaires';
$string['showdetails'] = 'Afficher les détails';
$string['simpletest'] = 'Tests unitaires';
$string['simplexmlrequired'] = 'L\'installation de l\'extension SimpleXML de PHP est maintenant requise par Moodle.';
$string['sitelangchanged'] = 'La langue du site a été modifiée';
$string['sitemailcharset'] = 'Jeu de caractères';
$string['sitemaintenance'] = 'Ce site est actuellement en maintenance. Il est donc temporairement non disponible';
$string['sitemaintenancemode'] = 'Mode de maintenance';
$string['sitemaintenanceoff'] = 'Le mode de maintenance a été désactivé et le site fonctionne à nouveau normalement';
$string['sitemaintenanceon'] = 'Votre site est actuellement en mode maintenance (seuls les administrateurs peuvent se connecter et utiliser le site).';
$string['sitemaintenancewarning'] = 'Votre site est actuellement en mode de maintenance (seuls les administrateurs peuvent s\'y connecter). Pour revenir à un fonctionnement normal du site, veuillez <a href="maintenance.php">désactiver le mode de maintenance</a>.';
$string['sitemaintenancewarning2'] = 'Votre site est actuellement en mode de maintenance (seuls les administrateurs peuvent s\'y connecter). Pour revenir à un fonctionnement normal du site, veuillez <a href="{$a}">désactiver le mode de maintenance</a>.';
$string['sitepolicies'] = 'Règles site';
$string['sitepolicy'] = 'URL du règlement de site';
$string['sitepolicyguest'] = 'URL du règlement de site pour visiteurs anonymes';
$string['sitepolicyguest_help'] = 'Si vous voulez imposer aux visiteurs anonymes la lecture et l\'acceptation d\'un règlement avant d\'utiliser ce site, veuillez indiquer ici l\'URL de ce règlement. Dans le cas contraire, laissez le champ vide. N\'importe quelle URL publique peut être spécifiée. Vous pouvez empêcher l\'accès des visiteurs anonymes à votre site à l\'aide du réglage « Imposer la connexion ».';
$string['sitepolicy_help'] = 'Si vous voulez imposer à vos utilisateurs enregistrés la lecture et l\'acceptation d\'un règlement avant d\'utiliser ce site, veuillez indiquer ici l\'URL de ce règlement. Dans le cas contraire, laissez le champ vide. N\'importe quelle URL publique peut être spécifiée.';
$string['sitesectionhelp'] = 'Si cette option est activée, une section sera affichée sur la page d\'accueil du site.';
$string['slasharguments'] = 'Utiliser les « slash arguments »';
$string['smartpix'] = 'Recherche intelligente des icônes';
$string['smtphosts'] = 'Hôtes SMTP';
$string['smtpmaxbulk'] = 'Limite de session SMTP';
$string['smtppass'] = 'Mot de passe SMTP';
$string['smtpuser'] = 'Nom d\'utilisateur SMTP';
$string['soaprecommended'] = 'L\'installation de l\'extension soap de PHP est utile pour les services web et d\'autres modules tiers.';
$string['spellengine'] = 'Vérificateur orthographique';
$string['splrequired'] = 'L\'installation de l\'extension SPL de PHP est maintenant requise par Moodle.';
$string['stats'] = 'Statistiques';
$string['statsfirstrun'] = 'Intervalle maximal de traitement';
$string['statsmaxruntime'] = 'Temps maximal de traitement';
$string['statsruntimedays'] = 'Jours à traiter';
$string['statsruntimestart'] = 'Lancer à';
$string['statsuserthreshold'] = 'Seuil utilisateurs';
$string['stickyblocks'] = 'Blocs fixes';
$string['stickyblockscourseview'] = 'Page de cours';
$string['stickyblocksduplicatenotice'] = 'Si l\'un des blocs que vous ajoutez ici existe déjà sur une page, il y aura alors un doublon.<br />Seul celui qui est fixe ne sera pas modifiable. Le doublon pourra encore être modifié.';
$string['stickyblocksmymoodle'] = 'Mon Moodle';
$string['stickyblockspagetype'] = 'Type de page à configurer';
$string['strictformsrequired'] = 'Validation stricte des champs requis';
$string['stripalltitletags'] = 'Retirer les balises HTML du nom des activités';
$string['supportemail'] = 'Courriel d\'assistance';
$string['supportname'] = 'Nom d\'assistance';
$string['supportpage'] = 'Page d\'assistance';
$string['switchlang'] = 'Changer de dossier de langue';
$string['systempaths'] = 'Chemins système';
$string['tablenosave'] = 'Les modifications dans la table ci-dessus sont enregistrées automatiquement.';
$string['tablesnosave'] = 'Les modifications dans les tables ci-dessus sont enregistrées automatiquement.';
$string['tabselectedtofront'] = 'Dans les tables avec onglets, la rangée contenant l\'onglet sélectionné doit-elle être ramenée au premier plan ?';
$string['tabselectedtofronttext'] = 'Ramener au premier plan la rangée de l\'onglet sélectionné';
$string['themedesignermode'] = 'Mode concepteur de thème';
$string['themelist'] = 'Liste des thèmes';
$string['themeresetcaches'] = 'Vider les caches de thème';
$string['themeselector'] = 'Sélecteur de thème';
$string['themesettings'] = 'Réglages thème';
$string['therewereerrors'] = 'Des erreurs sont présentes dans vos données';
$string['timezone'] = 'Fuseau horaire par défaut';
$string['timezoneforced'] = 'Ce réglage est imposé par l\'administrateur du site';
$string['timezoneisforcedto'] = 'Imposer à tous les utilisateurs l\'utilisation du fuseau horaire';
$string['timezonenotforced'] = 'Les utilisateurs peuvent choisir leur fuseau horaire';
$string['tokenizerrecommended'] = 'L\'installation de l\'extension Tokenizer de PHP est recommandée. Elle améliore les fonctionnalités du Réseau Moodle.';
$string['unattendedoperation'] = 'Opération sans surveillance';
$string['unbookmarkthispage'] = 'Supprimer le marque-page de cette page';
$string['unicoderecommended'] = 'Il est recommandé de stocker toutes vos données en Unicode (UTF-8). Toute nouvelle installation de Moodle devrait être effectuée dans une base de données ayant comme jeu de caractères par défaut Unicode (UTF-8). Si vous effectuez une mise à jour de Moodle, veuillez procéder à la migration de votre base de données en Unicode (voir la page d\'administration).';
$string['unicoderequired'] = 'Le stockage des données en format Unicode (UTF-8) est requis.  Toute nouvelle installation de Moodle doit être effectuée dans une base de données ayant comme jeu de caractères par défaut Unicode (UTF-8). Si vous effectuez une mise à jour de Moodle, veuillez procéder à la migration de votre base de données en Unicode (voir la page d\'administration).';
$string['unicodeupgradenotice'] = 'Dans la version 1.6 de Moodle, toutes les langues ont été migrées en Unicode. Pour terminer la mise à jour de ce site, il est nécessaire de convertir toutes les données de votre base de données en Unicode (UTF-8) à l\'aide de notre script de migration. <a href="utfdbmigrate.php">Cliquez ici pour lancer le script de migration maintenant</a> !';
$string['uninstall'] = 'Désinstaller les langues sélectionnées';
$string['uninstallconfirm'] = 'Vous êtes sur le point de supprimer totalement la langue {$a}. Voulez-vous continuer ?';
$string['uninstallplugin'] = 'Désinstaller';
$string['uninstallqtype'] = 'Désinstaller ce type de question.';
$string['unsupported'] = 'Non supporté';
$string['updateaccounts'] = 'Modifier des comptes existants';
$string['updatecomponent'] = 'Mettre à jour le composant';
$string['updatelangs'] = 'Mettre à jour tous les paquetages de langue installés';
$string['updatetimezones'] = 'Fuseaux horaires';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 comporte un certain nombre de correctifs de sécurité pour les mots de passe et le processus de sauvegarde et restauration, afin de protéger les informations des utilisateurs sur votre site. En conséquence, certains de vos réglages et permissions en lien avec les sauvegardes peuvent avoir été modifiés.<br />Veuillez consulter les <a href="http://docs.moodle.org/fr/Notes_de_mise_%C3%A0_jour_de_Moodle_1.9.7" target="_blank">Notes de mise à jour à Moodle 1.9.7</a> pour plus de détails.</p>';
$string['upgrade197noticesubject'] = 'Notes de sécurité liées à la mise à jour à Moodle 1.9.7';
$string['upgrade197salt'] = 'Afin de réduire de façon importante le risque de vol de mot de passe, il vous est fortement recommandé de définir un sel de mot de passe.<br />Veuillez consulter la <a href="{$a}" target="_blank">documentation sur le sel de mot de passe</a> pour plus d\'informations à ce sujet.';
$string['upgradeerror'] = 'Erreur lors de la mise à jour de {$a->plugin} à la version {$a->version}. Impossible de continuer.';
$string['upgradeforumread'] = 'Moodle 1.5 possède une nouvelle fonctionnalité permettant de signaler quels messages des forums ont été lus.<br />Pour profiter de cette fonctionnalité, les tables de la base de données <a href="{$a}">doivent être mises à jour</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5 possède une nouvelle fonctionnalité permettant de signaler quels messages des forums ont été lus. Pour profiter de cette fonctionnalité, les tables de la base de données doivent être complétées avec le statut de lecture pour les messages existants. Suivant la taille de votre site, cette mise à jour peut prendre beaucoup de temps (quelques heures) et risque de surcharger la base de données. Nous vous conseillons donc de l\'effectuer lors d\'une période creuse. Durant cette mise à jour, votre site continuera à fonctionner et les utilisateurs n\'en seront pas affectés. Une fois l\'opération démarrée, vous devez la laisser se terminer (en laissant ouverte la fenêtre du navigateur). Si par inadvertance vous interrompez le processus, par exemple en fermant la fenêtre, vous pourrez le recommencer sans dommage.<br /><br />Voulez-vous commencer maintenant cette opération ?';
$string['upgradelogs'] = 'Pour profiter de toutes les fonctionnalités, les historiques (logs) doivent être mis à jour. <a href="{$a}">Plus d\'informations</a>';
$string['upgradelogsinfo'] = 'Récemment, des changements ont eu lieu dans la façon de conserver les historiques. Afin de pouvoir profiter de l\'affichage des anciens historiques par activité, ceux-ci doivent être mis à jour. Selon la taille de votre site, cette opération peut durer assez longtemps (c\'est-à-dire plusieurs heures) et peut ralentir les bases de données des sites complexes et très actifs. Une fois l\'opération démarrée, vous devez la laisser se terminer (en laissant ouverte la fenêtre du navigateur). N\'ayez crainte, votre site continuera à très bien fonctionner pour les autres utilisateurs durant la mise à jour des historiques.<br /><br />Voulez-vous mettre à jour maintenant vos historique ?';
$string['upgradesettings'] = 'Nouveaux réglages';
$string['upgradesettingsintro'] = 'Les réglages ci-dessous ont été ajoutés lors de la dernière mise à jour de votre Moodle. Effectuez les modifications nécessaires et cliquez ensuite sur « Enregistrer les modifications » au bas de cette page.';
$string['upgradestart'] = 'Mettre à jour';
$string['upgradesure'] = 'Certains fichiers de votre Moodle ont été modifiés, et vous êtes sur le point<br />de lancer la procédure automatique de mise à jour de votre serveur vers cette version :<br /><br /><strong>{$a}</strong><br /><br />Une fois cette mise à jour effectuée, il sera impossible de revenir en arrière !<br /><br />Veuillez remarquer que le processus peut durer assez longtemps.<br /><br />Voulez-vous vraiment mettre à jour ce Moodle vers cette version ?';
$string['upgradetimedout'] = 'La mise à jour a dépassé le temps imparti. Veuillez recommencer la mise à jour.';
$string['upgradingdata'] = 'Mise à jour des données';
$string['upgradinglogs'] = 'Mise à jour des fichiers d\'historique (logs)';
$string['upgradingversion'] = 'Mise à jour vers une nouvelle version';
$string['uploadpicture_baduserfield'] = 'L\'attribut indiqué n\'est pas valide. Veuillez essayer à nouveau.';
$string['uploadpicture_cannotmovezip'] = 'Impossible de déplacer le fichier zip vers un dossier temporaire.';
$string['uploadpicture_cannotprocessdir'] = 'Impossible de traiter les fichiers décompressés.';
$string['uploadpicture_cannotsave'] = 'Impossible d\'enregistrer l\'avatar pour l\'utilisateur {$a}. Veuillez vérifier le fichier image original.';
$string['uploadpicture_cannotunzip'] = 'Impossible de décompresser le fichier d\'avatars.';
$string['uploadpicture_invalidfilename'] = 'Le nom du fichier image {$a} a des caractères non valides. Il sera ignoré.';
$string['uploadpicture_overwrite'] = 'Écraser les avatars déjà existants ?';
$string['uploadpictures'] = 'Déposer des avatars';
$string['uploadpictures_help'] = 'Les avatars des utilisateurs peuvent être déposés sous la forme d\'un fichier compressé (zip) de fichiers images. Le nom des fichiers images doit être de la forme <i>attribut-choisi.extension</i>. Par exemple, si vous choisissez pour la correspondance des images l\'attribut « nom d\'utilisateur » et que le nom d\'utilisateur de l\'utilisateur concerné est « user1234 », le nom de fichier devrait être « user1234.jpg ».';
$string['uploadpicture_userfield'] = 'Attribut utilisateur à utiliser pour la correspondance des avatars :';
$string['uploadpicture_usernotfound'] = 'Il n\'y a pas d\'utilisateur dont l\'attribut « {$a->userfield} » a la valeur « {$a->uservalue} ». Il sera ignoré.';
$string['uploadpicture_userskipped'] = 'Utilisateur {$a} ignoré (il possède déjà un avatar).';
$string['uploadpicture_userupdated'] = 'Avatar de l\'utilisateur {$a} modifié.';
$string['uploadusers'] = 'Importation d\'utilisateurs';
$string['uploadusers_help'] = 'Il est possible d\'importer manuellement des comptes utilisateurs (et optionnellement inscrits à des cours) à partir d\'un fichier texte, ce fichier doit être formaté de la façon suivante :

* chaque ligne du fichier contient un enregistrement ;
* les données de chaque enregistrement sont séparées par une virgule (ou un autre caractère de séparation) ;
* le premier enregistrement contient le nom des champs qui composent les enregistrements, et détermine ainsi la structure de la suite du fichier ;
* les champs requis sont username, password, firstname, lastname, email';
$string['uploaduserspreview'] = 'Prévisualisation de la création d\'utilisateurs';
$string['uploadusersresult'] = 'Résultats de la création d\'utilisateurs';
$string['upwards'] = 'et ultérieures';
$string['useblogassociations'] = 'Activer les associations';
$string['useexternalyui'] = 'Utiliser les bibliothèques YUI en ligne';
$string['usehtmleditor'] = 'Utiliser l\'éditeur WYSIWYG';
$string['user'] = 'Utilisateur';
$string['useraccountupdated'] = 'Utilisateur modifié';
$string['useraccountuptodate'] = 'Utilisateur à jour';
$string['userbulk'] = 'Actions en lots sur les utilisateurs';
$string['userdeleted'] = 'Utilisateur supprimé';
$string['userlist'] = 'Liste des utilisateurs';
$string['userpolicies'] = 'Règles utilisateurs';
$string['userpreference'] = 'Préférence utilisateur';
$string['userquota'] = 'Quota utilisateur';
$string['userrenamed'] = 'Utilisateur renommé';
$string['users'] = 'Utilisateurs';
$string['userscreated'] = 'Utilisateurs créés';
$string['usersdeleted'] = 'Utilisateurs supprimés';
$string['usersrenamed'] = 'Utilisateurs renommés';
$string['usersskipped'] = 'Utilisateurs ignorés';
$string['usersupdated'] = 'Utilisateurs modifiés';
$string['usersweakpassword'] = 'Utilisateurs avec mot de passe faible';
$string['usetags'] = 'Activer les tags';
$string['uubulk'] = 'Sélectionner pour des opérations en lots';
$string['uubulkall'] = 'Tous les utilisateurs';
$string['uubulknew'] = 'Nouveaux utilisateurs';
$string['uubulkupdated'] = 'Utilisateurs mis à jour';
$string['uucsvline'] = 'Ligne CSV';
$string['uulegacy1role'] = '(Anciennement étudiant) typeN=1';
$string['uulegacy2role'] = '(Anciennement enseignant) typeN=2';
$string['uulegacy3role'] = '(Anciennement enseignant sans droit d\'édition) typeN=3';
$string['uunoemailduplicates'] = 'Empêcher les doublons des adresses de courriel';
$string['uuoptype'] = 'Mode de création';
$string['uuoptype_addinc'] = 'Tout ajouter, y compris un compteur aux noms d\'utilisateurs au besoin';
$string['uuoptype_addnew'] = 'Ajouter seulement les nouveaux, ignorer les utilisateurs existants';
$string['uuoptype_addupdate'] = 'Ajouter les nouveaux et modifier les utilisateurs existants';
$string['uuoptype_update'] = 'Modifier les utilisateurs existants seulement';
$string['uupasswordcron'] = 'Généré dans le cron';
$string['uupasswordnew'] = 'Mot de passe nouvel utilisateur';
$string['uupasswordold'] = 'Mot de passe utilisateur existant';
$string['uustandardusernames'] = 'Standardiser les noms d\'utilisateur';
$string['uuupdateall'] = 'Remplacer avec le fichier et les réglages par défaut';
$string['uuupdatefromfile'] = 'Remplacer avec le fichier';
$string['uuupdatemissing'] = 'Remplir les manquants avec le fichier et les réglages par défaut';
$string['uuupdatetype'] = 'Détails de l\'utilisateur existant';
$string['uuusernametemplate'] = 'Modèle de nom d\'utilisateur';
$string['validateerror'] = 'Cette valeur n\'est pas valide :';
$string['verifychangedemail'] = 'Appliquer les restrictions de domaines lors des modifications d\'adresse de courriel';
$string['warningcurrentsetting'] = 'Valeur actuelle non valide : {$a}';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Renseignez les options suivantes si votre serveur Moodle n\'a pas un accès direct à Internet. L\'accès direct à Internet est requis pour le téléchargement des données de l\'environnement, les paquetages de langue, les flux RSS, les fuseaux horaires, etc.<br /><em>L\'extension cURL de PHP est vivement recommandée.</em>';
$string['xmlrpcrecommended'] = 'L\'installation de l\'extension xmlrpc de PHP est requise pour l\'utilisation du Réseau Moodle.';
$string['xmlstrictheaders'] = 'Entêtes XML strict';
$string['yuicomboloading'] = 'Chargement du combo YUI';
$string['ziprequired'] = 'L\'extension Zip de PHP est maintenant requise par Moodle. Les exécutables info-ZIP et la bibliothèque PclZip ne sont plus utilisés.';
