<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'es', branch 'MOODLE_20_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptederror'] = 'Margen de error';
$string['accessnoticesheader'] = 'Puede previsualizar este cuestionario, pero si éste fuera un intento real, podría ser bloqueado debido a:';
$string['action'] = 'Acción';
$string['adaptive'] = 'Modo adaptativo';
$string['adaptive_help'] = 'Si se activa, se permite más de un intento de respuesta a una pregunta dentro del mismo intento de resolver el cuestionario.
Por ejemplo, si una respuesta se marca como incorrecta, el alumno podrá volver a intentarlo de inmediato. Sin embargo, según se establezca  "Aplicar penalizaciones", se restará una penalización por cada intento equivocado.';
$string['addaquestion'] = 'Agregar una pregunta...';
$string['addarandomquestion'] = 'Agregar una pregunta aleatoria...';
$string['addarandomquestion_help'] = 'Cuando se añade una pregunta al azar, se traduce en que en el cuestionario se inserta una pregunta seleccionada aleatoriamente de entre las que componen la categoría. Esto significa que los distintos alumnos tendrán probablemente una selección distinta de preguntas. Por otra parte, cuando el cuestionario permite múltiples intentos, cada uno de ellos probablemente contendrá una nueva selección de preguntas.';
$string['addcategory'] = 'Añadir categoría';
$string['adddescriptionlabel'] = 'Agregar descripción/etiqueta';
$string['addingcalculated'] = 'Agregando pregunta calculada';
$string['addingdescription'] = 'Agregando descripción';
$string['addingessay'] = 'Agregando ensayo';
$string['addingmatch'] = 'Agregando pregunta de emparejamiento';
$string['addingmultianswer'] = 'Agregando preguntas incrustadas (Cloze)';
$string['addingmultichoice'] = 'Agregando pregunta de opción múltiple';
$string['addingnumerical'] = 'Agregando pregunta numérica';
$string['addingquestion'] = 'Agregando una pregunta';
$string['addingquestions'] = 'Esta parte de la página es el lugar para administrar las preguntas. Las preguntas se agrupan en categorías para ayudarlo en la organización, pero pueden ser utilizadas por cualquier cuestionario en su curso o en otro curso si usted decide \'publicarlas\'.<br />Después seleccionar o crear una categoría podrá crear o editar preguntas. Puede seleccionar cualquiera de esas preguntas para agregarlas al otro lado de la página.';
$string['addingrandom'] = 'Agregando pregunta aleatoria';
$string['addingrandomsamatch'] = 'Agregando pregunta de emparejamiento de respuesta corta aleatoria';
$string['addingshortanswer'] = 'Agregando pregunta de respuesta corta';
$string['addingtruefalse'] = 'Agregando pregunta verdadero/falso';
$string['addmoreoverallfeedbacks'] = 'Agregar {no} campos más de retroalimentación';
$string['addnewgroupoverride'] = 'Agregar anulación de grupo';
$string['addnewpagesafterselected'] = 'Agregar nuevas páginas después de las preguntas seleccionadas';
$string['addnewquestionsqbank'] = 'Agregar preguntas a la categoría {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Agregar anulación de usuario';
$string['addpagehere'] = 'Agregar una página aquí';
$string['addquestion'] = 'Agregar pregunta';
$string['addquestions'] = 'Agregar preguntas';
$string['addquestionstoquiz'] = 'Agregar preguntas al presente cuestionario';
$string['addrandom'] = 'Agregar {$a} preguntas aleatorias';
$string['addrandom1'] = '<< Agregar';
$string['addrandom2'] = 'preguntas aleatorias';
$string['addrandomfromcategory'] = 'Agregar preguntas aleatorias de la categoría:';
$string['addrandomquestion'] = 'Agregar pregunta aleatoria';
$string['addrandomquestiontoquiz'] = 'Agregar pregunta aleatoria al cuestionario {$a}';
$string['addselectedtoquiz'] = 'Agregar al cuestionario';
$string['addtoquiz'] = 'Añadir a cuestionario';
$string['affectedstudents'] = '{$a} afectados';
$string['aftereachquestion'] = 'Después de agregar cada pregunta';
$string['afternquestions'] = 'Después de agretar {$a} preguntas';
$string['age'] = 'edad';
$string['aiken'] = 'Formato Aiken';
$string['allattempts'] = 'Todos los intentos';
$string['allinone'] = 'Sin límite';
$string['allowreview'] = 'Permitir revisión';
$string['alreadysubmitted'] = 'Parece que usted ya respondió este cuestionario';
$string['alternativeunits'] = 'Unidades alternativas';
$string['alwaysavailable'] = 'Siempre disponible';
$string['analysisoptions'] = 'Opciones de análisis';
$string['analysistitle'] = 'Tabla de análisis de ítems';
$string['answer'] = 'Respuesta';
$string['answered'] = 'Contestadas';
$string['answerhowmany'] = '¿Una o varias respuestas?';
$string['answers'] = 'Soluciones -';
$string['answersingleno'] = 'Se permiten varias respuestas';
$string['answersingleyes'] = 'Sólo una respuesta';
$string['answerswithacceptederrormarginmustbenumeric'] = 'Las respuestas con margen de error deben ser numéricas';
$string['answertoolong'] = 'Respuesta demasiado larga después de la línea {$a} (máx. 255 caracteres)';
$string['aon'] = 'Formato AON';
$string['areyousureremoveselected'] = '¿Está seguro de que quiere eliminar todas las preguntas seleccionadas?';
$string['asshownoneditscreen'] = 'Tal como se muestra en la pantalla de edición';
$string['attempt'] = 'Intento {$a}';
$string['attemptalreadyclosed'] = 'Este intento ya ha sido finalizado.';
$string['attemptclosed'] = 'El intento aún no está cerrado';
$string['attemptduration'] = 'Tiempo requerido';
$string['attemptedon'] = 'Intentado el';
$string['attempterror'] = 'No tiene autorización para intentar resolver este cuestionario debido a: {$a}';
$string['attemptfirst'] = 'Primer intento';
$string['attemptincomplete'] = 'Este intento (de {$a}) no se ha completado aún.';
$string['attemptlast'] = 'Último intento';
$string['attemptnumber'] = 'Intento';
$string['attemptquiznow'] = 'Comenzar';
$string['attempts'] = 'Intentos';
$string['attemptsallowed'] = 'Intentos permitidos';
$string['attemptsallowedn'] = 'Intentos permitidos: {$a}';
$string['attemptsdeleted'] = 'Eliminados intentos de resolver el cuestionario';
$string['attemptselection'] = 'Seleccionar qué intentos analizar por ususario:';
$string['attemptsexist'] = 'Ya ha intentado contestar este cuestionario';
$string['attemptsnum'] = 'Intentos: {$a}';
$string['attemptsnumthisgroup'] = 'Intentos: {$a->total} ({$a->group} de este grupo)';
$string['attemptsnumyourgroups'] = 'Intentos: {$a->total} ({$a->group} de sus grupos)';
$string['attemptsonly'] = 'Mostrar solamente estudiantes con intentos';
$string['attemptsunlimited'] = 'Intentos ilimitados';
$string['back'] = 'Volver a la vista previa de la pregunta';
$string['backtoquestionlist'] = 'Volver a lista de preguntas';
$string['backtoquiz'] = 'Volver a la edición de cuestionarios';
$string['basicideasofquiz'] = 'Ideas básicas sobre la realización del cuestionario';
$string['bestgrade'] = 'Calificación máxima';
$string['blackboard'] = 'Blackboard';
$string['blackboard_six'] = 'Blackboard v6+';
$string['bothattempts'] = 'Mostrar estudiantes con y sin intentos';
$string['braceerror'] = 'No se han podido encontrar {...} alrededor de las respuestas';
$string['browsersecurity'] = 'Seguridad del navegador';
$string['browsersecurity_help'] = 'Si está seleccionada la "Pantalla completa emergente con cierta seguridad JavaScript",

* El cuestionario sólo se iniciará si el estudiante tiene un navegador con JavaScript activado
* El cuestionario aparece en una ventana emergente  a pantalla completa que cubre todas las otras ventanas y no tiene controles de navegación
* Se impide a los estudiantes, en la medida de lo posible, el uso de acciones como copiar y pegar';
$string['calculated'] = 'Calculadas';
$string['calculatedquestion'] = 'Pregunta calculada no permitida en la línea {$a}. La pregunta no se tendrá en cuenta';
$string['cannotcreatepath'] = 'No se puede crear la ruta ({$a})';
$string['cannoteditafterattempts'] = 'No puede agregar o quitar preguntas porque este cuestionario ya ha sido respondido. ({$a})';
$string['cannotfindprevattempt'] = 'No se puede encontrar un intento previo en el que basarse';
$string['cannotfindquestionregard'] = 'Error al intentar conseguir preguntas para recalificación.';
$string['cannotinsert'] = 'No se puede insertar pregunta';
$string['cannotinsertrandomquestion'] = 'No se pudo insertar una nueva pregunta aleatoria.';
$string['cannotloadquestion'] = 'No se pudieron cargar las opciones de pregunta';
$string['cannotloadtypeinfo'] = 'Imposible cargar información sobre pregunta específica';
$string['cannotopen'] = 'No se puede exportar el archivo ({$a})';
$string['cannotread'] = 'No se puede leer el archivo importado (o está vacío)';
$string['cannotrestore'] = 'Imposible restaurar sesiones de pregunta';
$string['cannotreviewopen'] = 'No puede revisar este intento: aún está abierto.';
$string['cannotsavelayout'] = 'Imposible guardar el esquema';
$string['cannotsavenumberofquestion'] = 'Imposible guardar el número de preguntas por página';
$string['cannotsavequestion'] = 'No se pudo guardar la lista de preguntas';
$string['cannotsetgrade'] = 'No se pudo ajustar una nueva calificación máxima para el cuestionario';
$string['cannotsetsumgrades'] = 'No se pudo ajustar la suma de calificaciones';
$string['cannotwrite'] = 'No se puede escribir al archivo exportado ({$a})';
$string['caseno'] = 'Igual mayúsculas que minúsculas';
$string['casesensitive'] = 'Diferencia entre mayúsculas y minúsculas';
$string['caseyes'] = 'Mayúsculas y minúsculas deben coincidir';
$string['categories'] = 'Categorías';
$string['category'] = 'Categoría';
$string['categoryadded'] = 'Se añadió la categoría \'{$a}\'';
$string['categorydeleted'] = 'Se eliminó la categoría\'{$a}\'';
$string['categoryinfo'] = 'Información de la categoría';
$string['categorymove'] = 'La categoría \'{$a->name}\' contiene {$a->count} preguntas. Por favor elija otra categoría.';
$string['categorymoveto'] = 'Mover a esta categoría';
$string['categorynamecantbeblank'] = 'El nombre de la categoría no puede estar en blanco';
$string['categorynoedit'] = 'You do not have editing privileges in the category \'{$a}\'.';
$string['categoryupdated'] = 'Categoría actualizada con éxito';
$string['changessaved'] = 'Guardados cambios en calificación';
$string['changessavedwitherrors'] = 'Han ocurrido algunos errores mientras se guardaban los cambios de calificación';
$string['checkanswer'] = 'Comprobar';
$string['choice'] = 'Elección';
$string['choices'] = 'Opciones disponibles';
$string['choosefile'] = 'Seleccione un archivo';
$string['close'] = 'Cerrar vista previa';
$string['closebeforeopen'] = 'No se pudo actualizar el cuestionario: la fecha de cierre es anterior a la de apertura.';
$string['closed'] = 'Cerrado';
$string['closepreview'] = 'Cerrar vista previa';
$string['closereview'] = 'Cerrar revisión';
$string['comment'] = 'Comentario';
$string['commentorgrade'] = 'Hacer comentario o evitar calificación';
$string['comments'] = 'Comentarios';
$string['completedon'] = 'Completado el';
$string['configadaptive'] = 'Si selecciona Sí en esta opción, el estudiante podrá dar múltiples respuestas a una pregunta incluso dentro del mismo intento de resolver el cuestionario.';
$string['configattemptsallowed'] = 'Restricción del número de intentos que los estudiantes tienen para resolver el cuestionario.';
$string['configdecimaldigits'] = 'Número de dígitos a mostrar después del punto decimal cuando se muestran las calificaciones.';
$string['configdecimalplaces'] = 'Número de dígitos a mostrar después del punto decimal cuando se muestren las calificaciones del cuestionario.';
$string['configdecimalplacesquestion'] = 'Número de dígitos a mostrar después del punto decimal cuando se muestren las calificaciones de las preguntas individuales.';
$string['configdelay1'] = 'Si ajusta una demora, el estudiante deberá esperar ese tiempo antes de que pueda intentar resolver el cuestionario tras el primer intento.';
$string['configdelay1st2nd'] = 'Si aquí se fija un tiempo de demora, el estudiante no puede comenzar su segundo intento hasta que haya transcurrido ese tiempo después de terminar su primer intento.';
$string['configdelay2'] = 'Si establece aquí una demora, el estudiante tendrá que esperar ese tiempo antes de efectuar su tercer intento (o posteriores) de resolver el cuestionario.';
$string['configdelaylater'] = 'Si aquí se fija un tiempo de demora, el estudiante no puede comenzar su tercero, cuarto... intento hasta que haya transcurrido ese tiempo después de terminar su anterior intento.';
$string['configeachattemptbuildsonthelast'] = 'Si se permiten múltiples intentos, cada nuevo intento contendrá los resultados del intento previo.';
$string['configgrademethod'] = 'Método que se usará para calcular la calificación final del estudiante en el cuestionario cuando se permiten múltiples intentos.';
$string['configintro'] = 'Los valores que especifique aquí definen los valores por defecto usados en el formulario de especificaciones cuando usted crea un nuevo cuestionario. Puede asimismo configurar qué ajustes de cuestionario se consideran avanzados.';
$string['configmaximumgrade'] = 'Valor por defecto a la que se ajustará la calificación del cuestionario.';
$string['confignewpageevery'] = 'Cuando se agregan preguntas al cuestionario, los saltos de página se insertarán automáticamente de acuerdo con el valor que elija aquí.';
$string['configpenaltyscheme'] = 'Penalización sustraída por cada respuesta errónea en el modo adaptativo.';
$string['configpopup'] = 'Usar \'tricks\' de JavaScript para tratar de restringir copiar y pegar, etc., durante los intentos de resolver este cuestionario.';
$string['configrequirepassword'] = 'Los estudiantes deben escribir su contraseña antes de intentar resolver el cuestionario.';
$string['configrequiresubnet'] = 'Los estudiantes únicamente pueden intentar resolver el cuestionario desde estos ordenadores.';
$string['configreviewoptions'] = 'Estas opciones controlan qué información pueden ver los usuarios cuando revisan un intento de resolver el cuestionario o cuando examinan los informes del cuestionario.';
$string['configshowblocks'] = 'Mostrar bloques durante los intentos de responder al cuestionario.';
$string['configshowuserpicture'] = 'Mostrar en pantalla la imagen del usuario durante los intentos.';
$string['configshufflequestions'] = 'Si habilita esta opción, el orden de preguntas se ordenará al azar cada vez que el estudiante intenta resolver el cuestionario.';
$string['configshufflewithin'] = 'Si habilita esta opción, las partes que componen las preguntas individuales se ordenarán al azar cada vez que un estudiante intenta resolver este cuestionario, en el supuesto de que la opción esté también habilitada en los ajustes de la pregunta.';
$string['configtimelimit'] = 'Tiempo límite por defecto en minutos. 0 significa que no hay límite de tiempo.';
$string['configtimelimitsec'] = 'Tiempo límite (en segundos) predeterminado para resolver los cuestionarios. \'0\' significa que no hay límite de tiempo.';
$string['configurerandomquestion'] = 'Configurar pregunta';
$string['confirmclose'] = 'Está a punto de cerrar este intento. Una vez lo cierre, no podrá cambiar sus respuestas.';
$string['confirmserverdelete'] = '¿Está seguro de que desea eliminar el servidor  <b>{$a}</b> de la lista?';
$string['confirmstartattemptlimit'] = 'Se ha establecido un límite de {$a} intentos para resolver el cuestionario. Está a punto de comenzar un nuevo intento. ¿Desea continuar?';
$string['confirmstartattempttimelimit'] = 'Este cuestionario tiene un límite de tiempo y está restringido a {$a} intentos. El acceso al cuestionario será contado como un intento. ¿Desea continuar?';
$string['confirmstarttimelimit'] = 'El cuestionario tiene un límite de tiempo. ¿Está seguro de que desea comenzar?';
$string['containercategorycreated'] = 'Esta categoría se ha creado para almacenar todas las categorías originales trasladadas al sitio debido a causas especificadas más abajo.';
$string['continueattemptquiz'] = 'Continuar el último intento';
$string['continuepreview'] = 'Continuar la previsualización anterior';
$string['copyingfrom'] = 'Creando una copia de la pregunta \'{$a}\'';
$string['copyingquestion'] = 'Copiando una pregunta';
$string['correct'] = 'Correcto';
$string['correctanswer'] = 'Respuesta correcta';
$string['correctanswerformula'] = 'La respuesta correcta es la fórmula';
$string['correctansweris'] = 'Respuesta correcta: {$a}';
$string['correctanswerlength'] = 'Cifras significativas';
$string['correctanswers'] = 'Respuestas correctas';
$string['correctanswershows'] = 'La respuesta correcta muestra';
$string['corrresp'] = 'Respuesta Correcta';
$string['countdown'] = 'Cuenta atrás';
$string['countdownfinished'] = 'Este cuestionario se está cerrando, debe enviar sus respuestas ahora.';
$string['countdowntenminutes'] = 'El cuestionario se cerrará en diez minutos.';
$string['coursetestmanager'] = 'Formato de Administración de Test de Curso';
$string['createcategoryandaddrandomquestion'] = 'Crear la categoría y añadir pregunta aleatoria';
$string['createfirst'] = 'Antes debe crear algunas preguntas de respuesta corta.';
$string['createmultiple'] = 'Crear múltiples preguntas';
$string['createnewquestion'] = 'Crear una pregunta nueva';
$string['createquestionandadd'] = 'Crear una nueva pregunta y agregarla al cuestionario.';
$string['custom'] = 'Formato personalizado';
$string['dataitemneed'] = 'Necesita agregar al menos un conjunto de ítems para obtener una pregunta válida';
$string['datasetdefinitions'] = 'Definiciones reutilizables del conjunto de datos para la categoría {$a}';
$string['datasetnumber'] = 'Número';
$string['daysavailable'] = 'Días disponible';
$string['decimaldigits'] = 'Número de decimales en calificaciones';
$string['decimalformat'] = 'decimales';
$string['decimalplaces'] = 'Decimales en las calificaciones';
$string['decimalplaces_help'] = '<p>Mediante esta opción usted puede seleccionar el número de
decimales mostrados en la calificación de cada intento.</p>';
$string['decimalplacesquestion'] = 'Decimales en las calificaciones de las preguntas';
$string['decimalplacesquestion_help'] = '<p>Usted puede elegir una precisión diferente cuando se muestran las calificaciones de
preguntas individuales, a diferencia de la puntuación general del cuestionario. Por ejemplo,
es posible que la puntuación final del cuestionario de redondeado al número entero más cercano, mientras que se tienen puntuaciones fraccionarias en las preguntas individuales</p>';
$string['decimalpoints'] = 'Puntos decimales';
$string['decimals'] = 'con {$a}';
$string['default'] = 'Por defecto';
$string['defaultgrade'] = 'Calificación por defecto de la pregunta';
$string['defaultinfo'] = 'Categoría por defecto para las preguntas.';
$string['delay1'] = 'Tiempo entre el primer y el segundo intento';
$string['delay1st2nd'] = 'Forzar demora entre los intentos primero y segundo';
$string['delay1st2nd_help'] = '<p>Si especifica un lapso de tiempo, el estudiante tendrá que esperar ese tiempo antes de poder volver a contestar el cuestionario después del primer intento.</p>';
$string['delay2'] = 'Tiempo entre los intentos posteriores';
$string['delaylater'] = 'Forzar demora entre intentos posteriores';
$string['delaylater_help'] = '<p>Si especifica un lapso de tiempo, el estudiante tendrá que esperar a que transcurra ese tiempo antes de poder intentar contestar el cuestionario por tercera vez o en lo sucesivo.</p>';
$string['deleteattemptcheck'] = '¿Está totalmente seguro que quiere borrar definitivamente estos intentos?';
$string['deletequestioncheck'] = '¿Está totalmente seguro que quieere borrar \'{$a}\'?';
$string['deletequestionscheck'] = '¿Está totalmente seguro que quiere eliminar las siguientes preguntas?<br /><br />{$a}';
$string['deleteselected'] = 'Eliminar seleccionados';
$string['deletingquestionattempts'] = 'Eliminando intentos de resolver el cuestionario';
$string['description'] = 'Descripción';
$string['disabled'] = 'Deshabilitado';
$string['discrimination'] = 'Índice Discrim.';
$string['displayoptions'] = 'Mostrar opciones';
$string['download'] = 'Haga clic para descargar el archivo de categorías exportadas';
$string['downloadextra'] = '(el archivo se almacena también en el directorio /quiz de archivos del curso)';
$string['duplicateresponse'] = 'Este envío ha sido pasado por alto debido a que usted dio una respuesta equivalente con anterioridad.';
$string['eachattemptbuildsonthelast'] = 'Cada intento se basa en el anterior';
$string['eachattemptbuildsonthelast_help'] = '<p>Si se permiten varios intentos y se selecciona <B>Sí</B>, cada nuevo intento contendrá el resultado del anterior. Esto permite completar un cuestionario haciendo varios intentos partiendo en cada uno del resultado anterior.</p>
';
$string['editcategories'] = 'Editar categorías';
$string['editcategory'] = 'Editar categoría';
$string['editcatquestions'] = 'Editar preguntas categóricas';
$string['editingcalculated'] = 'Editando pregunta calculada';
$string['editingdescription'] = 'Editando la descripción';
$string['editingessay'] = 'Editando ensayo';
$string['editingmatch'] = 'Editando pregunta de emparejamiento';
$string['editingmultianswer'] = 'Editando respuestas incrustadas (Cloze)';
$string['editingmultichoice'] = 'Editando una pregunta de opción múltiple';
$string['editingnumerical'] = 'Editando una pregunta numérica';
$string['editingquestion'] = 'Editando pregunta';
$string['editingquiz'] = 'Editando cuestionario';
$string['editingquiz_help'] = 'Cuando se crea un cuestionario, los conceptos básicos son:

* El cuestionario, que contiene preguntas en una o más páginas
* El banco de preguntas, que almacena copias de todas las preguntas organizadas en categorías
* Preguntas aleatorias: Cada vez que se intenta resolver el cuestionario aparecen preguntas diferentes (los estudiantes tienen preguntas diferentes)';
$string['editingrandom'] = 'Editando pregunta aleatoria';
$string['editingrandomsamatch'] = 'Editando pregunta de emparejamiento de respuesta corta aleatoria';
$string['editingrqp'] = '{$a}: editando una pregunta';
$string['editingshortanswer'] = 'Editando una pregunta de respuesta corta';
$string['editingtruefalse'] = 'Editando una pregunta verdadero/falso';
$string['editoverride'] = 'Anular edición';
$string['editqcats'] = 'Editar categorías de preguntas';
$string['editquestions'] = 'Editar preguntas';
$string['editquiz'] = 'Editar cuestionario';
$string['editquizquestions'] = 'Editar preguntas del cuestionario';
$string['emailconfirmbody'] = 'Hola, {$a->username},
Gracias por enviar sus respuestas al cuestionario
\'{$a->quizname}\'
del curso \'{$a->coursename}\'
en {$a->submissiontime}.

Este correo confirma que hemos recibido correctamente sus respuestas.

Puede acceder al cuestionario en esta dirección: {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Gracias por enviar sus respuestas a  \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Confirmación de envío de cuestionario: {$a->quizname}';
$string['emailnotifybody'] = 'Hola, {$a->username},

{$a->studentname} ha completado el cuestionario
\'{$a->quizname}\' ({$a->quizurl})
del curso \'{$a->coursename}\'

Puede revisar su intento en {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} ha completado {$a->quizname}';
$string['emailnotifysubject'] = '{$a->studentname} ha completado el cuestionario {$a->quizname}';
$string['empty'] = 'Vacío';
$string['enabled'] = 'Habilidato';
$string['endtest'] = 'Terminar test...';
$string['erroraccessingreport'] = 'No puede acceder a este informe';
$string['errorinquestion'] = 'Error en la pregunta';
$string['errormissingquestion'] = 'Error: el sistema ha perdido la pregunta con id {$a}';
$string['errornotnumbers'] = 'Error - las respuestas deben ser numéricas';
$string['errorsdetected'] = '{$a} error(es) detectado(s)';
$string['errorunexpectedevent'] = 'Código de evento inesperado {$a->event} encontrado en la pregunta {$a->questionid} en el intento {$a->attemptid}.';
$string['essay'] = 'Ensayo';
$string['essayquestions'] = 'Preguntas';
$string['event1'] = 'Guardar automáticamente';
$string['event2'] = 'Guardar';
$string['event3'] = 'Calificación';
$string['event5'] = 'Validar';
$string['event6'] = 'Cerrar &amp;calificar';
$string['event7'] = 'Enviar';
$string['event8'] = 'Cerrar';
$string['event9'] = 'Calificación manual';
$string['everynquestions'] = 'Cada {$a} preguntas';
$string['everyquestion'] = 'Cada pregunta';
$string['everythingon'] = 'Todo activado';
$string['examview'] = 'Vista de examen';
$string['export'] = 'Exportar';
$string['exportcategory'] = 'categoría de exportación';
$string['exporterror'] = 'Ocurrió un error durante el procesamiento de la exportación';
$string['exportingquestions'] = 'Se están exportando las preguntas al archivo';
$string['exportname'] = 'Nombre del archivo';
$string['exportquestions'] = 'Exportar preguntas a un archivo';
$string['extraattemptrestrictions'] = 'Restricciones extra sobre los intentos';
$string['false'] = 'Falso';
$string['feedback'] = 'Comentario -';
$string['feedbackerrorboundaryformat'] = 'Los límites de la calificación de la retroalimentación deben ser un porcentaje o un número. El valor introducido en el límite {$a} no ha sido reconocido.';
$string['feedbackerrorboundaryoutofrange'] = 'Los límites de la calificación de la retroalimentación deben estar entre 0% y 100%. El valor introducido en el límite {$a} está fuera de límites.';
$string['feedbackerrorjunkinboundary'] = 'Debe rellenar las casillas de los límites de la calificación de la retroalimentación sin dejar huecos.';
$string['feedbackerrorjunkinfeedback'] = 'Debe rellenar las casillas de retroalimentación sin dejar huecos.';
$string['feedbackerrororder'] = 'Los límites de la calificación de la retroalimentación deben estar en orden, comenzando por el más alto. El valor introducido en el límite {$a} está fuera de la secuencia.';
$string['file'] = 'Archivo';
$string['fileformat'] = 'Formato de archivo';
$string['fillcorrect'] = 'Rellene con la opción correcta';
$string['filloutnumericalanswer'] = 'Usted proporciona al menos una respuesta posible y una tolerancia. La primera respuesta emparejada se usará para determinar la puntuación y la retroalimentación. Si proporciona alguna clase de retroalimentación sin ninguna respuesta al final, eso se mostrará a los estudiantes cuya respuesta correcta no está emparejada con ninguna de las demás respuestas.';
$string['filloutoneanswer'] = 'Debe llenar al menos una respuesta posible. Las respuestas en blanco no serán utilizadas.';
$string['filloutthreequestions'] = 'Debe llenar al menos tres preguntas. Las que deje en blanco no serán utilizadas.';
$string['fillouttwochoices'] = 'Debe elegir al menos dos opciones. Las opciones en blanco no serán utilizadas.';
$string['finishattemptdots'] = 'Terminar intento...';
$string['finishreview'] = 'Finalizar revisión';
$string['forceregeneration'] = 'forzar regeneración';
$string['formatnotfound'] = 'No se encuentra el formato {$a} de exportación/importación';
$string['formatnotimplemented'] = 'Este formato no se ha implementado correctamente. Por favor, envíe un mensaje de error.';
$string['formulaerror'] = 'Errores en la fórmula.';
$string['fractionsaddwrong'] = 'Las calificaciones positivas otorgadas no suman 100% sino {$a}%<br />¿Desea regresar y corregir esta pregunta?';
$string['fractionsnomax'] = 'Una de las preguntas debe ser 100% para que sea<br />posible alcanzar la calificación máxima<br />¿Desea regresar y corregir esta pregunta?';
$string['fromfile'] = 'desde archivo:';
$string['functiondisabledbysecuremode'] = 'Esa funcionalidad está actualmente deshabilitada';
$string['functiontakesatleasttwo'] = 'La función {$a} debe tener al menos dos argumentos';
$string['functiontakesnoargs'] = 'La función {$a} no contiene argumentos';
$string['functiontakesonearg'] = 'La función {$a} debe tener exactamente un argumento';
$string['functiontakesoneortwoargs'] = 'La función {$a} debe tener uno o dos argumentos';
$string['functiontakestwoargs'] = 'La función {$a} debe tener exactamente dos argumentos';
$string['generalfeedback'] = 'Retroalimentación general';
$string['generalfeedback_help'] = '<p>La retroalimentación general sobre las preguntas es un texto que se muestra al estudiante una vez que ha intentado responder a una pregunta. A diferencia de la retroalimentación, que depende del tipo de pregunta y de la respuesta dada por el estudiante, aquí se muestra el mismo texto de retroalimentación general a todos los estudiantes.</p>

<p>Usted puede controlar cuándo se muestra a los estudiantes la retroalimentación general utilizando las casillas de verificación "Los estudiantes pueden revisar:" del formulario de edición del cuestionario.</p>

<p>Puede usar la retroalimentación general para dar a los estudiantes información sobre qué conocimientos tratan de comprobar las preguntas, o bien para suministrarles un enlace a más información que podrían usar en el caso de no entender las preguntas.</p>';
$string['generatevalue'] = 'Generar un nuevo valor entre';
$string['geometric'] = 'Geométrica';
$string['gift'] = 'Formato GIFT';
$string['giftleftbraceerror'] = 'No se ha encontrado un {';
$string['giftmatchingformat'] = 'Las respuestas a la pregunta de emparejamiento no están formuladas adecuadamente';
$string['giftnonumericalanswers'] = 'No se han encontrado respuestas a la pregunta numérica';
$string['giftnovalidquestion'] = 'No se ha encontrado una pregunta válida';
$string['giftqtypenotset'] = 'No se ha establecido el tipo de pregunta';
$string['giftrightbraceerror'] = 'No se ha encontrado un }';
$string['grade'] = 'Calificación';
$string['gradeall'] = 'Calificar todo';
$string['gradeaverage'] = 'Promedio de calificaciones';
$string['gradeboundary'] = 'Límites de calificación';
$string['gradeessays'] = 'Calificar ensayos';
$string['gradehighest'] = 'Calificación más alta';
$string['grademethod'] = 'Método de calificación';
$string['grademethod_help'] = '<P>Cuando se permiten múltiples intentos, hay diferentes maneras en las que puede
usar las distintas calificaciones obtenidas para calcular la puntuación final del examen.

<P><B>Calificación más alta</B><P>
<UL>
<P>La puntuación final es la más alta en cualquiera de los intentos.
</UL>

<P><B>Puntuación media</B><P>
<UL>
<P> La puntuación final es el promedio (la media simple) de la puntuación de
todos los intentos.</UL>

<P><B>Primera calificación</B><P>
<UL>
<P>La puntuación final es la obtenida en el primer intento (se ignoran los
demás intentos).</UL>

<P><B>Última calificación</B><P>
<UL>
<P>La calificación final es la obtenida en el intento más reciente.</UL>';
$string['gradesdeleted'] = 'Eliminadas calificaciones del cuestionario';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Puntos para este envío:
{$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Con las penalizaciones previas esto da como resultado
<strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Este envío ha supuesto una penalización de {$a}.';
$string['gradingdetailszeropenalty'] = 'Usted no ha sido penalizado por este envío';
$string['gradingmethod'] = 'Método de calificación: {$a}';
$string['groupoverrides'] = 'Anulaciones de grupo';
$string['groupsnone'] = 'No hay grupos en este curso';
$string['guestsno'] = 'Lo sentimos, los invitados no pueden ver o responder cuestionarios';
$string['hidebreaks'] = 'Ocultar saltos de página';
$string['hidereordertool'] = 'Ocultar herramienta de reordenamiento';
$string['history'] = 'Historial de respuestas';
$string['illegalformulasyntax'] = 'Sintaxis de fórmula ilegal que comienza con \'{$a}\'';
$string['imagedisplay'] = 'Imagen a mostrar';
$string['imagemissing'] = 'Imagen no disponible en la línea {$a}. El archivo no se tendrá en cuenta';
$string['import'] = 'Importar';
$string['importcategory'] = 'importar categoría';
$string['importerror'] = 'Ha ocurrido un error durante el procesamiento de la importación';
$string['importerrorquestion'] = 'Error al importar la pregunta';
$string['importfilearea'] = 'Importar de un archivo que ya está en los archivos del curso...';
$string['importfileupload'] = 'Importar de subida de archivo...';
$string['importfromthisfile'] = 'Importar de este archivo';
$string['import_help'] = 'Esta función permite importar preguntas de archivos externos.

Si su archivo contiene caracteres no ascii, utilice la codificación UTF-8. Sea especialmente cuidadoso con los archivos generados por aplicaciones Microsoft Office, puesto que normalmente utilizan una codificación especial que puede no ser manejada correctamente.

Los formatos de Importar y Exportar son un recurso extensible. Pueden encontrarse disponibles otros formatos opcionales en la base de datos de Módulos y Extensiones.';
$string['importingquestions'] = 'Importando {$a} preguntas del archivo';
$string['importmax10error'] = 'Hay un error en la pregunta. Usted no puede tener más de diez respuestas';
$string['importmaxerror'] = 'Hay un error en la pregunta.
Hay demasiadas respuestas.';
$string['importminerror'] = 'Hay un error en la pregunta. No hay suficientes respuestas para este tipo de pregunta.';
$string['importparseerror'] = 'Se han encontrado errores al analizar el archivo de importación. No se han importado preguntas. Para importar las preguntas bien formuladas, inténtelo de nuevo seleccionando \'No\' en \'Parar si hay errores\'';
$string['importquestions'] = 'Importar preguntas de un archivo';
$string['inactiveoverridehelp'] = '* El estudiante no tiene el rol o el grupo correctos para intentar resolver el cuestionario';
$string['incorrect'] = 'Incorrecto';
$string['indivresp'] = 'Respuestas de los individuos a cada ítem';
$string['info'] = 'Información';
$string['infoshort'] = 'i';
$string['introduction'] = 'Introducción';
$string['invalidattemptid'] = 'No existe un intento con esa ID';
$string['invalidcategory'] = 'El ID de la categoría no es válido';
$string['invalidnumericanswer'] = 'Una de sus respuestas no es un número válido.';
$string['invalidnumerictolerance'] = 'Uno de los valores de tolerancia introducidos no es un número válido.';
$string['invalidoverrideid'] = 'ID de anulación no válido';
$string['invalidquestionid'] = 'ID de pregunta no válida';
$string['invalidquizid'] = 'ID de cuestionario no válida';
$string['invalidsource'] = 'No se acepta la fuente como válida';
$string['invalidsourcetype'] = 'Tipo de fuente no válido.';
$string['invalidstateid'] = 'ID de estado no válida';
$string['itemanal'] = 'Análisis de respuestas por ítem';
$string['itemdefinition'] = 'Definición';
$string['itemsource'] = 'Fuente de ítems';
$string['itemsourceformat'] = 'Formato de la fuente de ítems';
$string['itemtypes'] = 'Tipos de pregunta remotos';
$string['lastanswer'] = 'Su última respuesta fue';
$string['layout'] = 'Esquema';
$string['layoutasshown'] = 'Diseño de página como se muestra.';
$string['layoutasshownwithpages'] = 'Diseño de página como se muestra. <small>(Página nueva automática cada {$a} preguntas.)</small>';
$string['learnwise'] = 'Formato \'learnwise\'';
$string['link'] = 'Enlace';
$string['listitems'] = 'Lista de ítems del cuestionario';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Fallo en la carga de preguntas: {$a}';
$string['loguniform'] = 'dígitos, de una distribución log-uniforme';
$string['makecopy'] = 'Guardar como nueva pregunta';
$string['managetypes'] = 'Gestionar tipos de preguntas y servidores';
$string['manualgrading'] = 'Calificación';
$string['mark'] = 'Enviar';
$string['markall'] = 'Enviar página';
$string['marks'] = 'Puntos';
$string['match'] = 'Emparejamiento';
$string['matchanswer'] = 'Respuesta emparejada';
$string['matchanswerno'] = 'Respuesta emparejada {$a}';
$string['matcherror'] = 'Las calificaciones no se corresponden con las opciones de calificación: la pregunta se pasa por alto';
$string['matchgrades'] = 'Emparejar calificaciones';
$string['matchgradeserror'] = 'Error si la calificación no está en la lista';
$string['matchgradesnearest'] = 'Calificación más próxima si no está en lista';
$string['max'] = 'Máx';
$string['messageprovider:confirmation'] = 'Confirmación de su envío del cuestionario';
$string['messageprovider:submission'] = 'Notificación del envío del custionario';
$string['min'] = 'Mín';
$string['minutes'] = 'Minutos';
$string['missinganswer'] = 'Muy pocos elementos :ANSWER :Lx, :Rx para la pregunta de la línea {$a}. Debe definir al menos dos respuestas posibles';
$string['missingcorrectanswer'] = 'Debe especificar la respuesta correcta';
$string['missingformula'] = 'Fórmula perdida';
$string['missingitemtypename'] = 'Nombre perdido';
$string['missingname'] = 'La pregunta no tiene nombre';
$string['missingquestion'] = 'Falta una etiqueta de pregunta después de la línea {$a}';
$string['missingquestiontext'] = 'No se encuentra el texto de la pregunta';
$string['missingword'] = 'Formato de palabra perdida';
$string['modulename'] = 'Cuestionario';
$string['modulename_help'] = 'El módulo Cuestionario permite al profesor diseñar y plantear cuestionarios con preguntas tipo opción múltiple, verdadero/falso, coincidencia y otras. Cada intento es registrado, y el profesor puede elegir si hacer comentarios de retroalimentación y/o mostrar las respuestas correctas.';
$string['modulenameplural'] = 'Cuestionarios';
$string['moveselectedonpage'] = 'Mover las preguntas seleccionadas a la página: {$a}';
$string['moveto'] = 'Mover a >>';
$string['multianswer'] = 'Respuestas incrustadas (Cloze)';
$string['multichoice'] = 'Opción múltiple';
$string['multipleanswers'] = 'Seleccione  al menos una respuesta.';
$string['multiplier'] = 'Multiplicador';
$string['name'] = 'Nombre';
$string['navnojswarning'] = 'Advertencia: estos vínculos no guardarán sus respuestas. Utilice el botón siguiente en la zona inferior de la página.';
$string['neverallononepage'] = 'Nunca, todas las preguntas en una página';
$string['newattemptfail'] = 'Error: No se ha podido comenzar un nuevo intento en el cuestionario';
$string['newpage'] = 'Página nueva';
$string['newpageevery'] = 'Comenzar automáticamente una nueva página';
$string['newpage_help'] = '<p>En los cuestionarios más extensos tiene sentido alargar el cuestionario en varias páginas limitando el número de preguntas por página. Cuando se añaden preguntas al cuestionario se insetarán automáticamente saltos de página de acuerdo con el ajuste que se introduzca aquí. Sin embargo, uster podrá cambiar a mano los saltos de página más tarde en la página de edición.
</p>';
$string['noanswers'] = 'No se seleccionó ninguna respuesta';
$string['noattempts'] = 'No se ha intentado responder este cuestionario';
$string['noattemptstoshow'] = 'No hay intentos que mostrar';
$string['nocategory'] = 'Categoría incorrecta o no especificada';
$string['noclose'] = 'Sin fecha de cierre';
$string['nocommentsyet'] = 'Aún no hay comentarios.';
$string['noconnection'] = 'En este momento no existe conexión a un servicio web que pueda procesar esta pregunta. Por favor, contacte con su administrador.';
$string['nodataset'] = 'nada - no es un comodín';
$string['nodatasubmitted'] = 'No se han enviado datos.';
$string['noessayquestionsfound'] = 'No se encuentran preguntas calificadas manualmente';
$string['nogradewarning'] = 'Este cuestionario no está calificado, por lo que no puede escribir una retroalimentación global en función de la calificación.';
$string['nomatchinganswer'] = 'Debe especificar una respuesta que se corresponda con la pregunta \'{$a}\'.';
$string['nominal'] = 'Nominal';
$string['nomoreattempts'] = 'No se permiten más intentos';
$string['none'] = 'Ninguno';
$string['noopen'] = 'Sin fecha de apertura';
$string['nooverridedata'] = 'Debe reemplazar al menos uno de los ajustes del cuestionario.';
$string['nopossibledatasets'] = 'No datos posibles';
$string['noquestionintext'] = 'El texto de la pregunta no contiene ninguna pregunta anidada';
$string['noquestions'] = 'Aún no se han agregado preguntas';
$string['noquestionsfound'] = 'No se han encontrado respuestas';
$string['noquestionsinfile'] = 'No hay preguntas en el archivo de importación';
$string['noquestionsinquiz'] = 'No hay preguntas en este cuestionario.';
$string['noquestionsnotinuse'] = 'Esta pregunta aleatoria no está en uso puesto que su categoría está vacía.';
$string['noquestionsonpage'] = 'Página vacía';
$string['noresponse'] = 'Sin respuesta';
$string['noreview'] = 'No está autorizado para revisar este cuestionario';
$string['noreviewattempt'] = 'Usted no tiene permiso para revisar este intento.';
$string['noreviewshort'] = 'No permitido';
$string['noreviewuntil'] = 'No está autorizado para revistar este cuestionario hasta el {$a}';
$string['noreviewuntilshort'] = 'Disponible {$a}';
$string['noscript'] = 'Para continuar, JavaScript debe estar habilitado';
$string['notavailable'] = 'Lo sentimos, el cuestionario no está disponible';
$string['notavailabletostudents'] = 'Nota: Sus estudiantes no pueden acceder en este momento a este cuestionario';
$string['notenoughanswers'] = 'Este tipo de pregunta requiere al menos {$a} respuestas';
$string['notenoughsubquestions'] = 'No se han definido suficientes subpreguntas.<br /> ¿Quiere regresar y arreglar esta pregunta?';
$string['notimedependentitems'] = 'Actualmente el módulo Cuestionario no permite ítems de tiempo limitado. Como alternativa, fije un tiempo límite para todo el cuestionario. ¿Desea elegir un ítem diferente o usar el actual?';
$string['notyourattempt'] = '¡Éste no es su intento!';
$string['noview'] = 'Al usuario identificado no se le permite ver este cuestionario.';
$string['numattempts'] = '{$a->studentnum}
{$a->studentstring} ha hecho
{$a->attemptnum} intentos';
$string['numattemptsmade'] = '{$a} intentos de contestar el cuestionario';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numérico';
$string['numquestionsx'] = 'Preguntas:{$a}';
$string['onlyteachersexport'] = 'Sólo los profesores pueden exportar preguntas';
$string['onlyteachersimport'] = 'Sólo los profesores con permiso de edición pueden importar preguntas';
$string['open'] = 'Sin respusta';
$string['openclosedatesupdated'] = 'Actualizadas fechas de apertura y cierre del cuestionario';
$string['optional'] = 'opcional';
$string['orderandpaging'] = 'Orden y paginación';
$string['orderingquiz'] = 'Orden y paginación';
$string['outof'] = 'de un máximo de';
$string['outofpercent'] = '{$a->grade} de un máximo de {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Retroalimentación global';
$string['overallfeedback_help'] = '<p>La retroalimentación global consiste en un texto que se muestra al estudiante
una vez que ha completado un intento de resolver el cuestionario. El texto puede
depender de la calificación que el estudiante haya conseguido.</p>

<p>Por ejemplo, si usted escribe "¡Buen trabajo!" en la primera caja de retroalimentación,
escribe 40% en la primera caja de límites de la calificación y escribe "Por favor, vuelve a
revisar el trabajo de esta semana", los estudiantes que puntúen 40% o más verán el mensaje
"¡Buen trabajo!", en tanto que los que hayan puntuado menos del 40% verán el otro mensaje.</p>

<p>Los límites de las calificaciones pueden especificarse en forma de porcentajes, por ejemplo
"31.41%", o en forma de números, por ejemplo "7". Si el cuestionario tiene 10 notas, un límite
de calificación de 7 significa 7/10 o superior.</p>';
$string['overdue'] = 'Vencido';
$string['override'] = 'Anular';
$string['overridedeletegroupsure'] = '¿Está seguro que desea eliminar la modificación del grupo {$a}?';
$string['overridedeleteusersure'] = '¿Está seguro que desea eliminar la modificación del usuario {$a}?';
$string['overridegroup'] = 'Reemplazar grupo';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideuser'] = 'Pasar por alto usuario';
$string['pagesize'] = 'Intentos mostrados por página:';
$string['paragraphquestion'] = 'Pregunta de párrafo no permitida en la línea {$a}. La pregunta no se tendrá en cuenta';
$string['parent'] = 'Padre';
$string['parentcategory'] = 'Categoría padre';
$string['parsingquestions'] = 'Analizando preguntas del archivo de importación.';
$string['partiallycorrect'] = 'Parcialmente correcto';
$string['passworderror'] = 'La contraseña es incorrecta';
$string['penalty'] = 'Penalización';
$string['penaltyscheme'] = 'Aplicar penalizaciones';
$string['penaltyscheme_help'] = '<p>Si un cuestionario se ejecuta en modo adaptativo, se permitirá al estudiante intentar responder de nuevo tras una respuesta errónea. En este caso, tal vez usted quiera imponer una penalización por cada respuesta equivocada que sea substraída de la puntuación final de la pregunta. La cantidad de penalización se elige individualmente para cada pregunta cuando se formula o se edita la pregunta.</p>

<p>Este ajuste no tiene efecto a menos que el cuestionario se administre en modo adaptativo.</p>';
$string['percentcorrect'] = 'Porcentaje correcto';
$string['pleaseclose'] = 'Su petición ha sido procesada. Puede ahora cerrar la ventana';
$string['pluginadministration'] = 'Administración del cuestionario';
$string['pluginname'] = 'Cuestionario';
$string['popup'] = 'Mostrar el cuestionario en una ventana "segura"';
$string['popupblockerwarning'] = 'Esta sección del test está en modo seguro, lo que significa que usted necesita completar el cuestionario en una ventana segura. Por favor, desactive el bloqueo de ventanas emergentes. Gracias.';
$string['popupnotice'] = 'Los estudiantes verán este cuestionario en una ventana segura';
$string['popupwithjavascriptsupport'] = 'Ventana emergente a pantalla completa con alguna seguridad JavaScript';
$string['preprocesserror'] = 'Ha ocurrido un error durante el procesamiento previo.';
$string['preview'] = 'Vista previa';
$string['previewquestion'] = 'Vista previa de la pregunta';
$string['previewquiz'] = 'Vista previa del cuestionario';
$string['previewquiznow'] = 'Previsualizar el cuestionario ahora';
$string['previous'] = 'Estado previo';
$string['publish'] = 'Publicar';
$string['publishedit'] = 'Necesita tener permiso en el curso para añadir o editar preguntas en esta categoría';
$string['qname'] = 'nombre';
$string['qti'] = 'Formato IMS QTI';
$string['qti_two'] = 'Formato IMS QTI 2.0';
$string['qtypename'] = 'tipo, nombre';
$string['question'] = 'Pregunta';
$string['questionbankcontents'] = 'Contenido del banco de preguntas';
$string['questionbankmanagement'] = 'Gestión del banco de preguntas';
$string['questionbehaviour'] = 'Comportamiento de las preguntas';
$string['questioncats'] = 'Categorías de pregunta';
$string['questiondeleted'] = 'Esta pregunta ha sido eliminada. Por favor, contacte con su profesor';
$string['questioninuse'] = 'La pregunta \'{$a}\' está en uso:';
$string['questionmissing'] = 'La pregunta de esta sesión está ausente';
$string['questionname'] = 'Nombre de la pregunta';
$string['questionnametoolong'] = 'El nombre de la pregunta de la línea {$a} es demasiado largo (máx. 255 car.). Ha sido truncado.';
$string['questionno'] = 'Pregunta {$a}';
$string['questionnotloaded'] = 'La pregunta {$a} no se ha cargado desde la base de datos';
$string['questionorder'] = 'Orden de las preguntas';
$string['questions'] = 'Preguntas';
$string['questionsinclhidden'] = 'Preguntas (incluídas las ocultas)';
$string['questionsinthisquiz'] = 'Preguntas en este cuestionario';
$string['questionsinuse'] = '(* Las preguntas marcadas con un asterisco ya están en uso en algunos cuestionarios. Esta pregunta no se eliminará de ellos, sino únicamente de la lista de categorías.)';
$string['questionsperpage'] = 'Número máximo de preguntas por página';
$string['questionsperpageselected'] = 'Se ha establecido el número de respuestas por página (la paginación está fijada actualmente). Como resultado, se han desactivado los controles de paginación. Puede cambiar esto en {$a}.';
$string['questionsperpagex'] = 'Preguntas por página: {$a}';
$string['questiontext'] = 'Texto de la pregunta';
$string['questiontextisempty'] = '[Texto de pregunta vacía]';
$string['questiontype'] = 'Tipo de pregunta {$a}';
$string['questiontypesetupoptions'] = 'Ajuste de opciones para los tipos de pregunta:';
$string['quiz:attempt'] = 'Intentar resolver cuestionarios';
$string['quizavailable'] = 'El cuestionario está disponible hasta el {$a}';
$string['quizclose'] = 'Cerrar cuestionario';
$string['quizclosed'] = 'Este cuestionario está cerrado el {$a}';
$string['quizcloses'] = 'Cuestionario cerrado';
$string['quizcloseson'] = 'Este cuestionario se cerrará el {$a}';
$string['quiz:deleteattempts'] = 'Eliminar intentos';
$string['quiz:emailconfirmsubmission'] = 'Confirmación por email al enviar';
$string['quiz:emailnotifysubmission'] = 'Notificación por email de los envíos';
$string['quiz:grade'] = 'Calificar cuestionarios manualmente';
$string['quiz:ignoretimelimits'] = 'Pasa por alto el límite de tiempo en los cuestionarios';
$string['quizisclosed'] = 'Este cuestionario está cerrado';
$string['quizisopen'] = 'Este cuestionario está abierto';
$string['quizisopenwillclose'] = 'El cuestionario se abre (se cierra {$a})';
$string['quiz:manage'] = 'Gestionar cuestionarios';
$string['quiznavigation'] = 'Navegación por el cuestionario';
$string['quiznotavailable'] = 'Este cuestionario no estará disponible hasta el {$a}';
$string['quizopen'] = 'Abrir cuestionario';
$string['quizopened'] = 'Este cuestionario está abierto';
$string['quizopenedon'] = 'Este cuestionario está abierto en {$a}';
$string['quizopens'] = 'Cuestionario abierto';
$string['quizopenwillclose'] = 'Este cuestionario está abierto, se cerrará en {$a}';
$string['quizordernotrandom'] = 'Orden no aleatorio';
$string['quizorderrandom'] = 'Orden aleatorio';
$string['quiz:preview'] = 'Vista previa de cuestionarios';
$string['quiz:regrade'] = 'Recalificar los intentos de resolver el cuestionario';
$string['quiz:reviewmyattempts'] = 'Revisar sus propios intentos';
$string['quizsettings'] = 'Ajustes del cuestionario';
$string['quiztimelimit'] = 'Límite de tiempo: {$a}';
$string['quiz:view'] = 'Ver información sobre el cuestionario';
$string['quiz:viewreports'] = 'Ver informes de cuestionarios';
$string['quizwillopen'] = 'Este cuestionario se abrirá en {$a}';
$string['random'] = 'Pregunta aleatoria';
$string['randomcreate'] = 'Crear preguntas aleatorias';
$string['randomfromcategory'] = 'Pregunta aleatoria de la categoría.';
$string['randomfromexistingcategory'] = 'Pregunta aleatoria desde una categoría existente';
$string['randomnosubcat'] = 'Preguntas sólo de esta categoría, no de sus sub-categorías.';
$string['randomquestionusinganewcategory'] = 'Pregunta aleatoria utilizando una categoría nueva';
$string['randomsamatch'] = 'Emparejamiento aleatorio de respuestas cortas';
$string['randomsamatchcreate'] = 'Crear preguntas de emparejamiento aleatorio de respuestas cortas';
$string['randomsamatchintro'] = 'Para cada una de las siguientes preguntas seleccione la respuesta que haga juego del menú.';
$string['randomsamatchnumber'] = 'Número de preguntas seleccionadas';
$string['randomwithsubcat'] = 'Preguntas de esta categoría y de sus sub-categorías.';
$string['readytosend'] = 'Está a punto de enviar su cuestionario para que sea evaluado. ¿Está seguro de que desea continuar?';
$string['reattemptquiz'] = 'Reintentar el cuestionario';
$string['recentlyaddedquestion'] = 'Pregunta agregada recientemente';
$string['recurse'] = 'Incluir también preguntas de sub-categorías';
$string['regrade'] = 'Recalificar todos los intentos';
$string['regradecomplete'] = 'Todos los intentos han sido recalificados';
$string['regradecount'] = 'Se han cambiado {$a->changed} de {$a->attempt} calificaciones';
$string['regradedisplayexplanation'] = 'Los intentos que cambian durante la recalificación se muestran como hiperenlaces a la ventana de revisión de preguntas';
$string['regradenotallowed'] = 'No dispone de permiso para recalificar este cuestionario';
$string['regradingquestion'] = 'Recalificando "{$a}".';
$string['regradingquiz'] = 'Recalificando el cuestionario "{$a}"';
$string['relative'] = 'Relativa';
$string['remove'] = 'Quitar';
$string['removeallquizattempts'] = 'Eliminar todos los intentos de resolver el cuestionario';
$string['removeemptypage'] = 'Eliminar la página vacía';
$string['removeselected'] = 'Eliminar las seleccionadas';
$string['rename'] = 'Renombrar';
$string['renderingserverconnectfailed'] = 'El servidor {$a} no ha podido procesar una petición RQP. Compruebe que la URL es correcta.';
$string['reorderquestions'] = 'Volver a ordenar las preguntas';
$string['reordertool'] = 'Mostrar herramienta de reordenación';
$string['repaginate'] = 'Repaginar con {$a} preguntas por página';
$string['repaginatecommand'] = 'Paginar de nuevo';
$string['repaginatenow'] = 'Repaginar ahora';
$string['replace'] = 'Reemplazar';
$string['replacementoptions'] = 'Opciones de reemplazar';
$string['report'] = 'Informes';
$string['reportanalysis'] = 'Análisis de ítems';
$string['reportfullstat'] = 'Estadísticas detalladas';
$string['reportmulti_percent'] = 'Porcentajes mútiples';
$string['reportmulti_q_x_student'] = 'Opciones multi-estudiante';
$string['reportmulti_resp'] = 'Respuestas individuales';
$string['reportnotfound'] = 'Informe no conocido ({$a})';
$string['reportoverview'] = 'Vista general';
$string['reportregrade'] = 'Recalificar intentos';
$string['reportresponses'] = 'Respuestas detalladas';
$string['reports'] = 'Informes';
$string['reportsimplestat'] = 'Estadística simple';
$string['requirepassword'] = 'Se requiere contraseña';
$string['requirepassword_help'] = '<p>Es un campo opcional</p>

<p>Si añadimos una contraseña los alumnos deben escribir la misma contraseña antes de que puedan comenzar un intento en el cuestionario.</p>';
$string['requirepasswordmessage'] = 'Para contestar este cuestionario necesita conocer la contraseña';
$string['requiresafeexambrowser'] = 'Requiere el uso de un navegador de examen seguro';
$string['requiresubnet'] = 'Se requiere dirección de red';
$string['requiresubnet_help'] = '<p align=center><b>Se requiere dirección de red</b></p>

<p>Es un campo opcional.</p>

<p>Podemos restringir el acceso a un cuestionario a una subred particular como una red local (LAN) o Internet especificando una lista separada por comas de los números parciales o completos del dirección IP.</p>

<p>Esto es especialmente útil para a proteger el cuestionario y asegurarnos de sólo se realiza desde una determinada aula o red.</p>

<p>Por ejemplo:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>Hay tres tipos de números que podemos utilizar (no podemos utilizar dominios basados en texto como example.com):
<ol>
<li>Direcciones IP completas, tales como 192.168.10.1 que se asocian a un único ordenador (o
Proxy).</li>
<li>Direcciones parciales, tales como 192.168 que se asocian a cualquier red que comience con esos números.</li>
<li>Notación CIDR, como <b>231.54.211.0/20</b> que permiten habilitar con más precisión subredes.</li>
</ol>
</p>

<p>Los espacios en blanco son ignorados.</p>';
$string['response'] = 'Respuesta';
$string['responses'] = 'Respuestas -';
$string['results'] = 'Resultados';
$string['reuseifpossible'] = 'volver a usar las eliminadas previamente';
$string['reverttodefaults'] = 'Volver al cuestionario por defecto';
$string['review'] = 'Revisión';
$string['reviewafter'] = 'Permitir revisión tras cerrar el cuestionario';
$string['reviewalways'] = 'Permitir revisión en cualquier momento';
$string['reviewattempt'] = 'Revisión del intento';
$string['reviewbefore'] = 'Permitir revisión mientras el cuestionario está abierto';
$string['reviewclosed'] = 'Después de cerrar el cuestionario';
$string['reviewimmediately'] = 'Inmediatamente después de cada intento';
$string['reviewnever'] = 'No permitir revisión';
$string['reviewofattempt'] = 'Revisión del intento {$a}';
$string['reviewofpreview'] = 'Revisión de la vista previa';
$string['reviewopen'] = 'Más tarde, mientras el cuestionario está aún abierto';
$string['reviewoptions'] = 'Los estudiantes pueden revisar';
$string['reviewoptionsheading'] = 'Revisar opciones';
$string['reviewoptionsheading_help'] = '<p>Estas opciones controlan qué información pueden ver los usuarios cuando revisan un intento de resolver el cuestionario o cuando consultan los correspondientes informes.</p>

<p>Immediatamente después del intento: la revisión podrá hacerse en los dos minutos siguientes al final de un intento (i.e., tras haber pulsado el usuario \'Enviar todo y terminar\').</p>

<p>Más tarde, mientras el cuestionario está aún abierto: la revisión podrá hacerse en cualquier momento previo a la fecha de cierre.</p>

<p>Una vez que el cuestionario está cerrado: la revisión podrá realizarse una vez que haya pasado la fecha de cierre del cuestionario. Obviamente, si el cuestionario no tiene fecha de cierre, esta opción no es posible.</p>

<p>A los usuarios con permiso para \'Ver calificaciones ocultas\' [moodle/grade:viewhidden]
(normalmente profesores y administradores) no les afectan estas restricciones, de modo que podrán en cualquier momento revisar toda la información relativa a los intentos que los estudiantes hayan hecho de resolver el cuestionario.</p>';
$string['reviewresponse'] = 'Revisar respuesta';
$string['reviewresponsetoq'] = 'Revisar respuesta (pregunta {$a})';
$string['reviewthisattempt'] = 'Revisar sus respuestas en este intento';
$string['rqp'] = 'Pregunta remota';
$string['rqps'] = 'Preguntas remotas';
$string['safebrowsererror'] = 'Se ha determinado que este cuestionario únicamente se conteste usando un navegador de examen seguro. No puede intentar resolverlo con este navegador.';
$string['safebrowsernotice'] = 'Este cuestionario se ha configurado de modo que los estudiantes sólo puedan contestarlo usando un navegador de examen seguro.';
$string['sameasoverall'] = 'Los mismos que para las calificaciones';
$string['save'] = 'Guardar';
$string['saveandedit'] = 'Guardar cambios y editar preguntas';
$string['saveattemptfailed'] = 'No se ha podido guardar el intento de resolver el cuestionario.';
$string['savedfromdeletedcourse'] = 'Guardado del curso eliminado "{$a}"';
$string['savegrades'] = 'Guardar calificaciones';
$string['savemyanswers'] = 'Guardar mis respuestas';
$string['savenosubmit'] = 'Guardar sin enviar';
$string['saveoverrideandstay'] = 'Guardar e introducir otra anulación';
$string['savequiz'] = 'Guardar todo el cuestionario';
$string['score'] = 'Puntuación bruta';
$string['scores'] = 'Puntuaciones -';
$string['select'] = 'Seleccionar';
$string['selectall'] = 'Seleccionar todos';
$string['selectcategory'] = 'Seleccionar categoría';
$string['selectcategoryabove'] = 'Seleccione una categoría';
$string['selectedattempts'] = 'Intentos seleccionados...';
$string['selectnone'] = 'Omitir todos';
$string['selectquestiontype'] = '-- Seleccionar tipo de pregunta --';
$string['serveradded'] = 'Servidor añadido';
$string['serveridentifier'] = 'Identificador';
$string['serverinfo'] = 'Información del servidor';
$string['serverinuse'] = 'El servidor que está a punto de eliminar es el último servidor {$a} y aún quedan preguntas que no funcionarán más si usted elimina este servidor.';
$string['servers'] = 'Servidores';
$string['serverurl'] = 'URL del servidor';
$string['settingsoverrides'] = 'Configuración de anulaciones';
$string['shortanswer'] = 'Respuesta corta';
$string['show'] = 'Mostrar';
$string['showall'] = 'Mostrar todas las preguntas en una página';
$string['showblocks'] = 'Mostrar bloques durante los intentos';
$string['showblocks_help'] = 'Si se selecciona SÍ, se mostrarán los bloques normales durante los intentos de resolver el cuestionario';
$string['showbreaks'] = 'Mostrar saltos de página';
$string['showcategorycontents'] = 'Mostrar el contenido de la categoría {$a->arrow}';
$string['showcorrectanswer'] = '¿Mostrar la respuesta correcta al finalizar?';
$string['showdetailedmarks'] = 'Mostrar nota detallada';
$string['showeachpage'] = 'Mostrar una página cada vez';
$string['showfeedback'] = '¿Mostrar resultado al finalizar?';
$string['showhidden'] = 'Mostrar también preguntas antiguas';
$string['showinsecurepopup'] = 'Utilizar una ventana emergente \'segura\'';
$string['shownoattempts'] = 'Mostrar estudiantes sin intentos';
$string['shownoattemptsonly'] = 'Mostrar sólo estudiantes sin intentos';
$string['showquestiontext'] = 'Mostrar el texto de la pregunta en la lista de preguntas';
$string['showteacherattempts'] = 'Mostrar intentos del profesor';
$string['showuserpicture'] = 'Mostrar la imagen del usuario';
$string['showuserpicture_help'] = '<p> Si usted habilita esta opción, el nombre del estudiante y su imagen serán
    mostradas en la pantalla durante un intento, y en la pantalla de revisión.</p>

<p> Un ejemplo en el que usted quisiera hacer esto es en cuestionarios proctorados
    (vigilados en el aula) para hacer más sencillo el verificar la identidad del usuario
    que intenta el cuestionario.</p>';
$string['shuffle'] = 'Orden al azar';
$string['shuffleanswers'] = 'Respuestas ordenadas al azar';
$string['shuffledrandomly'] = 'Presentadas al azar';
$string['shufflequestions'] = 'Ordenar las preguntas al azar';
$string['shufflequestionsselected'] = 'Las preguntas aparecerán ordenadas al azar. Como resultado, el botón Volver a ordenar las preguntas se ha desactivado. Puede cambiar esto en {$a}.';
$string['shufflewithin'] = 'Ordenar al azar dentro de las preguntas';
$string['shufflewithin_help'] = '<p>Si habilita esta opción, las partes que componen las preguntas individuales se ordenarán al azar cada vez que un estudiante comienza a contestar el cuestionario, suponiendo que la opción también esté habilitada en los ajustes de la pregunta.</p>

<p>Esta opción sólo es aplicable a preguntas que tienen elementos  múltiples, como las preguntas de elección múltiple o de emparejamiento. ';
$string['significantfigures'] = 'con {$a}';
$string['significantfiguresformat'] = 'Cifras significativas';
$string['singleanswer'] = 'Seleccione una respuesta.';
$string['sortage'] = 'Ordenar por edad';
$string['sortalpha'] = 'Ordenar alfabéticamente';
$string['sortquestionsbyx'] = 'Ordenar preguntas por: {$a}';
$string['sortsubmit'] = 'Ordenar preguntas';
$string['sorttypealpha'] = 'Ordenar por tipo, nombre';
$string['specificapathnotonquestion'] = 'La ruta al archivo especificado no está en la pregunta especificada';
$string['specificquestionnotonquiz'] = 'La pregunta especificada no está en el cuestionario especificado';
$string['startagain'] = 'Comenzar de nuevo';
$string['startedon'] = 'Comenzado el';
$string['statenotloaded'] = 'El estado de la pregunta {$a} no ha sido cargado desde la base de datos';
$string['status'] = 'Estatus';
$string['stoponerror'] = 'Parar al encontrar un error';
$string['submitallandfinish'] = 'Enviar todo y terminar';
$string['subneterror'] = 'Lo sentimos, este cuestionario ha sido bloqueado de modo que sólo es accesible desde ciertas direcciones. En este momento su ordenador no está autorizado para usar este cuestionario.';
$string['subnetnotice'] = 'Este cuestionario ha sido bloqueado, de modo que sólo es accesible desde ciertas ubicaciones. Su ordenador no está en una sub-red habilitada. Como profesor, puede acceder en cualquier caso a la vista previa.';
$string['subnetwrong'] = 'Este cuestionario sólo es accesible desde ciertos lugares: este ordenador no está en la lista de admitidos.';
$string['substitutedby'] = 'serán sustituídas por';
$string['summaryofattempt'] = 'Resumen del intento';
$string['summaryofattempts'] = 'Resumen de sus intentos previos';
$string['temporaryblocked'] = 'Durante cierto tiempo no está autorizado a intentar de nuevo resolver el cuestionario.<br /> Podrá intentarlo nuevamente en:';
$string['time'] = 'Tiempo';
$string['timecompleted'] = 'Completado';
$string['timedelay'] = 'No se le permite a realizar el cuestionario debido q que no ha transcurrido el tiempo necesario antes de intentarlo de nuevo.';
$string['timeleft'] = 'Tiempo restante';
$string['timelimit'] = 'Límite de tiempo';
$string['timelimitexeeded'] = 'Lo sentimos. Se ha sobrepasado el límite de tiempo.';
$string['timelimit_help'] = 'Si está activado, un temporizador se visualiza en una ventana flotante (se requiere JavaScript) mostrando una cuenta atrás. Cuando el plazo se finaliza, el cuestionario se envía automáticamente con las respuestas realizadas hasta el momento.';
$string['timelimitmin'] = 'Límite de tiempo (en minutos)';
$string['timelimitsec'] = 'Límite de tiempo (en segundos)';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = '¡Se ha pasado el tiempo!';
$string['timetaken'] = 'Tiempo empleado';
$string['tofile'] = 'al archivo';
$string['tolerance'] = 'Tolerancia';
$string['tolerancetype'] = 'Tipo de tolerancia';
$string['toomanyrandom'] = 'El número requerido de preguntas es mayor de las que contiene esta categoría.';
$string['top'] = 'Arriba';
$string['totalpointsx'] = 'Total de calificaciones: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total de {$a} preguntas en la categoría.';
$string['true'] = 'Verdadero';
$string['truefalse'] = 'Verdadero/Falso';
$string['truefalseimporterror'] = '<b>Atención</b>: La pregunta Verdadero/Falso \'{$a->questiontext}\' no se ha importado correctamente. No está claro si la respuesta correcta es Verdadero o Falso. La pregunta se ha importado asumiendo que la respuesta es \'{$a->answer}\'. Si no fuera correcto, necesitará editar la pregunta.';
$string['type'] = 'Tipo';
$string['unfinished'] = 'abierto';
$string['ungraded'] = 'Sin calificar';
$string['uniform'] = 'decimales, de una distribución uniforme';
$string['unit'] = 'Unidad';
$string['unknowntype'] = 'Tipo de pregunta no permitida en la línea {$a}. La pregunta no se tendrá en cuenta';
$string['unsupportedformulafunction'] = 'La función {$a} no está incluída';
$string['unusedcategorydeleted'] = 'Esta categoría ha sido eliminada, ya que, después de eliminar el curso, sus preguntas no fueron utilizadas nunca más.';
$string['updatesettings'] = 'Actualizar ajustes del cuestionario';
$string['upgradesure'] = '<div style="color: red;">En concreto, el módulo Cuestionario efectuará un extenso cambio de las tablas del cuestionario y esta actualización aún no ha sido suficientemente probada. Le recomendamos encarecidamente a hacer una copia de seguridad de las tablas de su base de datos antes de continuar.</div>';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Esta categoría ha sido trasladada al sitio porque, tras eliminar el curso, sus preguntas estaban en uso por otros cuestionarios del servidor.';
$string['useroverrides'] = '';
$string['usersnone'] = 'Ningún estudiante tiene acceso a este cuestionario';
$string['validate'] = 'Validar';
$string['viewallanswers'] = 'Ver {$a} cuestionarios resueltos';
$string['viewallreports'] = 'Ver los informes de {$a} intentos';
$string['warningmissingtype'] = '<p><b>Este tipo de pregunta aún no ha sido instalado en su Moodle.<br />Por favor, comuníquelo a su administrador.</b></p>';
$string['warningsdetected'] = '{$a} advertencia(s) detectada(s)';
$string['webct'] = 'Formato WebCT';
$string['wheregrade'] = '¿Dónde está mi calificación?';
$string['wildcard'] = 'Comodín';
$string['windowclosing'] = 'Esta ventana se cerrará en breve.';
$string['withselected'] = 'Con seleccionadas';
$string['withsummary'] = 'con estadísticas resumidas';
$string['wronggrade'] = 'Calificación equivocada (después de la línea {$a}) :';
$string['wronguse'] = 'Usted no puede usar esta página así';
$string['xhtml'] = 'Formato XHTML';
$string['xml'] = 'Formato Moodle XML';
$string['xmlimportnoname'] = 'Falta el nombre de la pregunta en el archivo XML';
$string['xmlimportnoquestion'] = 'Falta el texto de la pregunta en el archivo XML';
$string['xmltypeunsupported'] = 'La importación XML no admite el tipo de pregunta {$a}';
$string['youcannotwait'] = 'Este cuestionario se cierra antes de que se le permita comenzar otro intento de resolverlo.';
$string['youmustwait'] = 'Debe esperar antes de volver a intentar resolver este cuestionario. Se le permitirá efectuar otro intento después de {$a}.';
$string['youneedtoenrol'] = 'Necesita matricularse en este curso antes de responder al cuestionario';
$string['yourfinalgradeis'] = 'Su calificación final en este cuestionario es {$a}';
$string['zerosignificantfiguresnotallowed'] = '¡La respuesta correcta no puede tener cero cifras significativas!';
