<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'de', branch 'MOODLE_20_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptederror'] = 'Akzeptierter Fehler';
$string['accessnoticesheader'] = 'Sie können diesen Test in der Vorschau ansehen. Wäre dies ein realer Versuch, würde dies abgeblockt, weil:';
$string['action'] = 'Aktion';
$string['adaptive'] = 'Mehrfachbeantwortung';
$string['adaptive_help'] = 'Mit dieser Funktion wird es möglich eine Frage mehrfach innerhalb eines Testversuchs zu beantworten. Ist eine Frage falsch bewertet, kann der Teilnehmer diese direkt nochmals beantworten. Ist die Option \'Punktabzüge\' aktiviert werden diese berücksichtigt. ';
$string['addaquestion'] = 'Frage hinzufügen...';
$string['addarandomquestion'] = 'Zufallsfrage hinzufügen...';
$string['addarandomquestion_help'] = 'Eine Zufallsfrage wird zufällig aus allen Fragen der gewählten Kategorie ausgewählt. Das führt dazu, dass verschiedene Teilnehmer eine unterschiedliche Auswahl von Fragen im Test zur Beantwortung erhalten. Falls mehrere Versuche beim Test erlaubt sind, werden bei jedem Versuch die Fragen erneut zufällig gewählt.  ';
$string['addcategory'] = 'Kategorie hinzufügen';
$string['adddescriptionlabel'] = 'Textfeld hinzufügen';
$string['addingcalculated'] = 'Berechnungsfrage hinzufügen';
$string['addingdescription'] = 'Beschreibung hinzufügen';
$string['addingessay'] = 'Freitext-Frage hinzufügen';
$string['addingmatch'] = 'Zuordnungsfrage hinzufügen';
$string['addingmultianswer'] = 'Lückentext-Frage hinzufügen (Cloze)';
$string['addingmultichoice'] = 'Multiple-Choice-Frage hinzufügen';
$string['addingnumerical'] = 'Numerische Frage hinzufügen';
$string['addingquestion'] = 'Frage hinzufügen';
$string['addingquestions'] = 'Diese Spalte der Seite dient der Verwaltung der Testfragen. Fragen werden zwecks besseren Überblicks in Kategorien gespeichert und können von jedem Test Ihres Kurses oder sogar von anderen Kursen (wenn die Option "Veröffentlichen" ausgewählt ist) benutzt werden. <br /><br />Nachdem Sie eine Kategorie eingerichtet haben, können Sie Fragen erzeugen oder bearbeiten. Sie können jede einzelne dieser Fragen auswählen und Ihrem Test in der anderen Spalte hinzufügen.';
$string['addingrandom'] = 'Zufallsfrage hinzufügen';
$string['addingrandomsamatch'] = 'Zufällige Kurzantwort-Zuordnung hinzufügen';
$string['addingshortanswer'] = 'Kurztextfrage hinzufügen';
$string['addingtruefalse'] = 'Wahr-Falsch-Frage hinzufügen';
$string['addmoreoverallfeedbacks'] = '{no} weitere Feedbackfelder hinzufügen';
$string['addnewgroupoverride'] = 'Gruppenänderung hinzufügen';
$string['addnewpagesafterselected'] = 'Neue Seite nach markierter Frage hinzufügen';
$string['addnewquestionsqbank'] = 'Fragen zur Kategorie {$a->catname} hinzufügen: {$a->link}';
$string['addnewuseroverride'] = 'Nutzeränderung hinzufügen';
$string['addpagehere'] = 'Seite hier hinzufügen';
$string['addquestion'] = 'Frage hinzufügen';
$string['addquestions'] = 'Fragen hinzufügen';
$string['addquestionstoquiz'] = 'Fragen zu aktuellem Test hinzufügen';
$string['addrandom'] = '{$a} Zufallsfrage(n)';
$string['addrandom1'] = 'Zum Test hinzufügen';
$string['addrandom2'] = 'Zufallsfragen';
$string['addrandomfromcategory'] = 'Zufallsfrage hinzufügen aus der Kategorie:';
$string['addrandomquestion'] = 'Zufallsfrage hinzufügen';
$string['addrandomquestiontoquiz'] = 'Zufallsfrage zum Test {$a} hinzufügen';
$string['addselectedtoquiz'] = 'Auswahl zum Test hinzufügen';
$string['addtoquiz'] = 'Hinzufügen';
$string['affectedstudents'] = 'Bestimmt für {$a}';
$string['aftereachquestion'] = 'Nach jedem Hinzufügen einer Frage';
$string['afternquestions'] = 'Nach dem Hinzufügen von {$a} Fragen';
$string['age'] = 'Alter';
$string['aiken'] = 'AIKEN';
$string['allattempts'] = 'Alle Versuche';
$string['allinone'] = 'Unbegrenzt';
$string['allowreview'] = 'Rückblick erlauben';
$string['alreadysubmitted'] = 'Es sieht so aus, als hätten Sie diesen Versuch schon eingetragen.';
$string['alternativeunits'] = 'Alternative Einheiten';
$string['alwaysavailable'] = 'Immer verfügbar';
$string['analysisoptions'] = 'Analyseoptionen';
$string['analysistitle'] = 'Statistische Analyse der Ergebnisse';
$string['answer'] = 'Antwort';
$string['answered'] = 'Beantwortet';
$string['answerhowmany'] = 'Eine oder mehrere Antworten';
$string['answers'] = 'Antworten';
$string['answersingleno'] = 'Mehrere Antworten erlauben';
$string['answersingleyes'] = 'Nur eine Antwort erlauben';
$string['answerswithacceptederrormarginmustbenumeric'] = 'Antworten mit akzeptiertem Fehler müssen numerisch sein.';
$string['answertoolong'] = 'Die Antwort ist nach Zeile {$a} zu lang (Sie können bis zu 255 Zeichen eingeben).';
$string['aon'] = 'AON';
$string['areyousureremoveselected'] = 'Sind Sie sicher, dass Sie alle ausgewählten Fragen entfernen möchten?';
$string['asshownoneditscreen'] = 'Wie in Bearbeitungsansicht gezeigt';
$string['attempt'] = 'Versuch {$a}';
$string['attemptalreadyclosed'] = 'Dieser Versuch wurde bereits beendet.';
$string['attemptclosed'] = 'Versuch wurde bisher noch nicht geschlossen';
$string['attemptduration'] = 'Verbrauchte Zeit';
$string['attemptedon'] = 'Versucht am';
$string['attempterror'] = 'Sie dürfen diesen Test aktuell nicht versuchen: {$a}';
$string['attemptfirst'] = 'Erster Versuch';
$string['attemptincomplete'] = 'Dieser Versuch von {$a} ist noch nicht vollständig abgeschlossen.';
$string['attemptlast'] = 'Letzter Versuch';
$string['attemptnumber'] = 'Versuch';
$string['attemptquiznow'] = 'Test jetzt durchführen';
$string['attempts'] = 'Versuche';
$string['attemptsallowed'] = 'Erlaubte Versuche';
$string['attemptsallowedn'] = 'Erlaubte Versuche: {$a}';
$string['attemptsdeleted'] = 'Die Testversuche wurden gelöscht.';
$string['attemptselection'] = 'Welche Versuche pro Nutzer/in analysieren:';
$string['attemptsexist'] = 'Sie können jetzt keine Fragen mehr hinzufügen oder entfernen.';
$string['attemptsnum'] = 'Versuche: {$a}';
$string['attemptsnumthisgroup'] = 'Versuche: {$a->total} ({$a->group} von dieser Gruppe)';
$string['attemptsnumyourgroups'] = 'Versuche: {$a->total} ({$a->group} von Ihrer Gruppe)';
$string['attemptsonly'] = 'Nur Teilnehmer/innen anzeigen, die bereits Versuche durchgeführt haben.';
$string['attemptsunlimited'] = 'unbegrenzt';
$string['back'] = 'Zurück zur vorherigen Antwort';
$string['backtoquestionlist'] = 'Zurück zur Fragenliste';
$string['backtoquiz'] = 'Zurück zur Testbearbeitung';
$string['basicideasofquiz'] = 'Die Basisideen zur Testerstellung';
$string['bestgrade'] = 'Beste Bewertung';
$string['blackboard'] = 'Blackboard';
$string['blackboard_six'] = 'Blackboard V6+';
$string['bothattempts'] = 'Teilnehmer/innen mit und ohne durchgeführte Versuche anzeigen';
$string['braceerror'] = 'Es fehlen {...} um die Antworten';
$string['browsersecurity'] = 'Browsersicherheit';
$string['browsersecurity_help'] = 'Wenn \'Volbildmodus mit Javascript-Sicherheit\'  ausgewählt wird

* startet der Test nur wenn der Teilnehmer Javascript im Browser aktiviert hat
* wird der Test im Vollbildmodus ohne weitere Navigationsmöglichkeiten ausgeführt
* sind - soweit dies möglich ist - Funktionen wie Kopieren und Einfügen inaktiv.';
$string['calculated'] = 'Berechnung';
$string['calculatedquestion'] = 'Die Berechnungsfrage in Zeile {$a} wird nicht unterstützt. Die Frage wird ignoriert.';
$string['cannotcreatepath'] = 'Pfad kann nicht angelegt werden ({$a}).';
$string['cannoteditafterattempts'] = 'Sie können keine Frage(n) hinzufügen oder entfernen, da bereits Testversuche registriert sind. ({$a})';
$string['cannotfindprevattempt'] = 'Es wurden keine früheren Versuche gefunden, auf denen aufgebaut werden kann.';
$string['cannotfindquestionregard'] = 'Fehler beim Holen von Fragen zur Bewertung';
$string['cannotinsert'] = 'Frage kann nicht eingefügt werden.';
$string['cannotinsertrandomquestion'] = 'Es kann keine neue Zufallsfrage eingefügt werden.';
$string['cannotloadquestion'] = 'Frageoptionen konnten nicht geladen werden';
$string['cannotloadtypeinfo'] = 'Laden von fragespezifischen Informationen zum Fragetyp war nicht möglich';
$string['cannotopen'] = 'Exportdatei kann nicht geöffnet werden ({$a}).';
$string['cannotread'] = 'Importdatei kann nicht geöffnet werden oder ist leer';
$string['cannotrestore'] = 'Frageabschnitte konnten nicht wiederhergestellt werden';
$string['cannotreviewopen'] = 'Sie können diesen Versuch nicht durchsehen, weil er noch geöffnet ist';
$string['cannotsavelayout'] = 'Das Layout konnte nicht gespeichert werden';
$string['cannotsavenumberofquestion'] = 'Die Anzahl der Fragen pro Seite konnte nicht gespeichert werden';
$string['cannotsavequestion'] = 'Fragenliste kann nicht gespeichert werden';
$string['cannotsetgrade'] = 'Die neue Maximalbewertung des Tests konnte nicht gesetzt werden.';
$string['cannotsetsumgrades'] = 'Einstellungen für Zwischenbewertungen konnten nicht gesetzt werden.';
$string['cannotwrite'] = 'Exportdatei kann nicht erstellt werden ({$a})';
$string['caseno'] = 'Nein, Groß-/Kleinschreibung unwichtig';
$string['casesensitive'] = 'Groß-/Kleinschreibung';
$string['caseyes'] = 'Ja, Groß-/Kleinschreibung muss stimmen';
$string['categories'] = 'Kategorien';
$string['category'] = 'Kategorie';
$string['categoryadded'] = 'Kategorie \'{$a}\' angelegt';
$string['categorydeleted'] = 'Kategorie \'{$a}\' gelöscht';
$string['categoryinfo'] = 'Kategorie-Information';
$string['categorymove'] = 'Die Kategorie \'{$a->name}\' enthält {$a->count} Fragen. Bitte wählen Sie eine andere Kategorie, um sie zu verschieben.';
$string['categorymoveto'] = 'In diese Kategorie verschieben';
$string['categorynamecantbeblank'] = 'Der Name der Kategorie darf nicht leer bleiben.';
$string['categorynoedit'] = 'Sie haben keinen Bearbeitungszugriff auf Kategorie \'{$a}\'.';
$string['categoryupdated'] = 'Die Kategorie wurde erfolgreich aktualisiert.';
$string['changessaved'] = 'Veränderungen bei den Bewertungen wurden gesichert.';
$string['changessavedwitherrors'] = 'Beim Speichern der Bewertungsänderungen sind Fehler aufgetreten';
$string['checkanswer'] = 'Prüfen';
$string['choice'] = 'Antwort';
$string['choices'] = 'Verfügbare Antworten';
$string['choosefile'] = 'Datei auswählen';
$string['close'] = 'Fenster schließen';
$string['closebeforeopen'] = 'Der Test konnte nicht aktualisiert werden. Sie haben einen Endzeitpunkt vor dem Startzeitpunkt angegeben.';
$string['closed'] = 'Beendet';
$string['closepreview'] = 'Vorschau schließen';
$string['closereview'] = 'Überprüfung schließen';
$string['comment'] = 'Kommentar';
$string['commentorgrade'] = 'Kommentieren oder Bewertung überarbeiten';
$string['comments'] = 'Kommentare';
$string['completedon'] = 'Beendet am';
$string['configadaptive'] = 'Wenn Sie die Option \'Ja\' wählen, dann besteht für den/die Teilnehmer/in die Möglichkeit während des Tests mehrere Antworten auf eine Frage zu geben.';
$string['configattemptsallowed'] = 'Beschränkung der Anzahl an Antwortversuchen des/der Teilnehmers/in während des Tests.';
$string['configdecimaldigits'] = 'Anzahl der Nachkommastellen, die bei der Anzeige der Testbewertung aufscheinen sollen.';
$string['configdecimalplaces'] = 'Genauigkeit der Testbewertung (gezeigte Nachkommastellen)';
$string['configdecimalplacesquestion'] = 'Genauigkeit der Testfragenbewertung (gezeigte Nachkommastellen)';
$string['configdelay1'] = 'Wählen Sie eine Zeitverzögerung, wenn Sie möchten, dass Teilnehmer/innen vor einem weiteren Versuch ein Pause einhalten sollen.';
$string['configdelay1st2nd'] = 'Wenn Sie eine Zeitverzögerung aktivieren, können Teilnehmer/innen einen zweiten Testversuch erst nach der eingegeben Zeit durchführen';
$string['configdelay2'] = 'Wählen Sie eine Zeitverzögerung, wenn Sie möchten, dass Teilnehmer/innen vor einem dritten oder weiteren Versuch ein Pause einhalten sollen.';
$string['configdelaylater'] = 'Wenn Sie eine Zeitverzögerung aktivieren, können Teilnehmer/innen einen weiteren Testversuch erst nach der eingegeben Zeit durchführen';
$string['configeachattemptbuildsonthelast'] = 'Wenn mehrere Versuche erlaubt sind, dann enthält jeder Versuch die Ergebnisse des vorhergegangenen Versuchs.';
$string['configgrademethod'] = 'Welche Methode soll zur Berechnung der Note des/der Teilnehmers/in an dem Test herangezogen werden, wenn mehrere Versuche erlaubt sind?';
$string['configintro'] = 'Die Werte, welche Sie hier definieren, sind die Standardwerte, die auf der Einstellungsseite angezeigt werden, wenn Sie einen neuen Test anlegen. Sie können auch festlegen, welche Testeinstellungen als erweitert betrachtet werden.';
$string['configmaximumgrade'] = 'Der Standardwert für diese Testbewertung liegt außerhalb des gewählten Wertes.';
$string['confignewpageevery'] = 'Wenn Sie Fragen zur Testseite hinzufügen, werden in Abhängigkeit der hier gewählten Einstellung an der entsprechenden Stelle automatisch Seitenumbrüche eingefügt.';
$string['configpenaltyscheme'] = 'Im Adaptiven Modus werden bei jeder falschen Antwort Strafpunkte abgezogen.';
$string['configpopup'] = 'Mit Hilfe von Javascript-Tricks wird versucht "Copy and Paste" etc. während eines Testdurchgangs zu verhindern.';
$string['configrequirepassword'] = 'Teilnehmer/innen müssen ein Kennwort eingeben, bevor sie den Test durchführen können.';
$string['configrequiresubnet'] = 'Teilnehmer/innen können den Test nur von diesen Computern durchführen.';
$string['configreviewoptions'] = 'Diese Einstellungen geben an, welche Informationen Nutzer/innen angezeigt werden, wenn sie einen Versuch des Tests einsehen oder einen Blick auf den Testreport werfen.';
$string['configshowblocks'] = 'Blöcke bei den Testversuchen zeigen';
$string['configshowuserpicture'] = 'Nutzerbild anzeigen, während ein Versuch läuft';
$string['configshufflequestions'] = 'Wählen Sie diese Option, wenn Sie möchten, dass die Reihenfolge der Fragen bei jedem Versuch per Zufallsgenerator bestimmt werden soll.';
$string['configshufflewithin'] = 'Wenn Sie diese Option aktivieren, dann werden die Teile, die die individuellen Fragen darstellen, jedes Mal zufällig gewählt, wenn ein/e Teilnehmer/in einen Versuch dieses Tests startet, vorausgesetzt, dass die Auswahl auch in den Frage-Einstellungen ermöglicht wird.';
$string['configtimelimit'] = 'Standard Zeitlimit für Tests in Minuten. 0 bedeutet \'kein Zeitlimit\'.';
$string['configtimelimitsec'] = 'Standard Zeitlimit für Tests in Sekunden. 0 bedeutet \'kein Zeitlimit\'.';
$string['configurerandomquestion'] = 'Konfiguration der Fragen';
$string['confirmclose'] = 'Sie möchten diesen Versuch beenden. Wenn Sie den Versuch einmal beenden, können Sie Ihre Antworten nicht mehr bearbeiten.';
$string['confirmserverdelete'] = 'Sind Sie sicher, dass Sie den Server <b>{$a}</b> aus der Liste löschen wollen?';
$string['confirmstartattemptlimit'] = 'Anzahl der erlaubten Versuche: {$a}. Möchten Sie wirklich einen neuen Versuch starten?';
$string['confirmstartattempttimelimit'] = 'Sie können bis zu {$a} Versuch(e) in diesem Test durchführen. Wenn Sie starten, haben Sie eine begrenzte Zeit für die Durchführung des Versuchs. Wollen Sie jetzt einen neuen Versuch starten?';
$string['confirmstarttimelimit'] = 'Der Test ist zeitlich begrenzt. Wollen Sie jetzt einen Versuch starten?';
$string['containercategorycreated'] = 'Die Kategorie wurde aus den unten genannten Gründen angelegt, um alle Fragen aus anderen Kategorien aufzunehmen.';
$string['continueattemptquiz'] = 'Letzten Versuch fortsetzen';
$string['continuepreview'] = 'Letzte Vorschau fortsetzen';
$string['copyingfrom'] = 'Erstellen einer Kopie der Frage \'{$a}\'';
$string['copyingquestion'] = 'Eine Frage kopieren';
$string['correct'] = 'Richtig';
$string['correctanswer'] = 'Richtige Antwort';
$string['correctanswerformula'] = 'Formel für richtige Antwort';
$string['correctansweris'] = 'Richtige Antwort: {$a}';
$string['correctanswerlength'] = 'Signifikante Zahlen';
$string['correctanswers'] = 'Richtige Antworten';
$string['correctanswershows'] = 'Die richtige Antwort zeigt';
$string['corrresp'] = 'Richtige Antwort';
$string['countdown'] = 'Countdown';
$string['countdownfinished'] = 'Der Test wird gleich beendet, Sie sollten Ihre Antworten jetzt abschicken.';
$string['countdowntenminutes'] = 'Der Test endet in 10 Minuten.';
$string['coursetestmanager'] = 'Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Kategorie anlegen und Zufallsfrage hinzufügen';
$string['createfirst'] = 'Sie müssen zuerst einige Kurztextfragen anlegen.';
$string['createmultiple'] = 'Mehrere Fragen erstellen';
$string['createnewquestion'] = 'Eine neue Frage anlegen';
$string['createquestionandadd'] = 'Eine neue Frage erstellen und zum Test hinzufügen.';
$string['custom'] = 'Eigenes Format';
$string['dataitemneed'] = 'Sie müssen einen Datensatz hinzufügen, um eine gültige Frage zu erzeugen.';
$string['datasetdefinitions'] = 'Wiederverwendbare Datensatzdefinitionen für Kategorie {$a}';
$string['datasetnumber'] = 'Anzahl';
$string['daysavailable'] = 'Tage verfügbar';
$string['decimaldigits'] = 'Dezimalziffern bei der Bewertung';
$string['decimalformat'] = 'Dezimale';
$string['decimalplaces'] = 'Dezimalzahlen in Gesamtbewertung';
$string['decimalplaces_help'] = '<h2>Nachkommastellen</h2>

<p>Mit dieser Einstellung legen Sie die Zahl der angezeigten Nachkommastellen für eine Bewertung  fest. Wenn Sie als Wert \'0\' eintragen, werden nur ganze Zahlen angezeigt.
</p><p>
Die Einstellung beeinflusst nur die Anzeige der Bewertung. Die interne Berechnung und Rundung basiert auf exakten Zahlen.
</p>';
$string['decimalplacesquestion'] = 'Dezimalzahlen in Fragenbewertung';
$string['decimalplacesquestion_help'] = 'Die Einstellung legt die Zahl der angezeigten  Dezimalziffern bei der Bewertung von Fragen fest. ';
$string['decimalpoints'] = 'Dezimalstellen';
$string['decimals'] = 'mit {$a}';
$string['default'] = 'Standard';
$string['defaultgrade'] = 'Standardbewertung (Punkte)';
$string['defaultinfo'] = 'Die Standardkategorie für Fragen';
$string['delay1'] = 'Pause zwischen 1. und 2. Versuch';
$string['delay1st2nd'] = 'Erzwungener Abstand zwischen 1. und 2. Versuch';
$string['delay1st2nd_help'] = '<h2>Pause zwischen 1. und 2. Versuch</h2>

<p>Wenn Sie hier eine Pause einrichten, lässt sich ein zweiter Testversuch erst nach Ablauf dieser Pause durchführen.</p>';
$string['delay2'] = 'Pause bei späteren Versuchen';
$string['delaylater'] = 'Erzwungener Abstand zwischen weiteren Versuchen';
$string['delaylater_help'] = '<h2>Pause bei weiteren Testversuchen</h2>
<p>Wenn Sie hier eine Pause einrichten, lassen sich der dritte und weitere Testversuche erst nach Ablauf dieser Pause starten.</p>';
$string['deleteattemptcheck'] = 'Sind Sie wirklich sicher, dass Sie diese Versuche löschen wollen?';
$string['deletequestioncheck'] = 'Sind Sie wirklich sicher, dass Sie \'{$a}\' löschen möchten?';
$string['deletequestionscheck'] = 'Sind Sie wirklich sicher, dass Sie die folgenden Fragen löschen wollen? <br /><br />{$a}';
$string['deleteselected'] = 'Auswahl löschen';
$string['deletingquestionattempts'] = 'Löschen der Testversuche';
$string['description'] = 'Beschreibung';
$string['disabled'] = 'Deaktiviert';
$string['discrimination'] = 'Discrimination Index';
$string['displayoptions'] = 'Anzeigeoptionen';
$string['download'] = 'Klick zum Download der exportierten Kategorien';
$string['downloadextra'] = '(Datei ist auch im Kursverzeichnis backupdata/quiz abgelegt.)';
$string['duplicateresponse'] = 'Ihre Antwort wurde ignoriert, weil Sie früher bereits eine gleichwertige Antwort gegeben haben.';
$string['eachattemptbuildsonthelast'] = 'Jeder Versuch basiert auf dem vorigen';
$string['eachattemptbuildsonthelast_help'] = '<h2>Jeder Versuch basiert auf dem vorigen</h2>
<p>Sind mehrere Versuche erlaubt und ist bei dieser Einstellung <b>Ja </b>gewählt, so enthält
jeder neue Versuch das Ergebnis des vorherigen. Dies erlaubt
die Fertigstellung eines Tests mit Hilfe mehrerer Versuche.</p>
<p>Um für jeden Versuch einen neuen Test bereitzustellen, wählen
Sie für diese Einstellung <b>Nein</b>.
</p>';
$string['editcategories'] = 'Kategorien bearbeiten';
$string['editcategory'] = 'Kategorie bearbeiten';
$string['editcatquestions'] = 'Fragen bearbeiten';
$string['editingcalculated'] = 'Berechnungsfrage bearbeiten';
$string['editingdescription'] = 'Beschreibung bearbeiten';
$string['editingessay'] = 'Freitext-Frage bearbeiten';
$string['editingmatch'] = 'Zuordnungsfrage bearbeiten';
$string['editingmultianswer'] = 'Lückentext-Frage (Cloze) bearbeiten';
$string['editingmultichoice'] = 'Multiple-Choice-Frage bearbeiten';
$string['editingnumerical'] = 'Numerische Frage bearbeiten';
$string['editingquestion'] = 'Frage wird bearbeitet';
$string['editingquiz'] = 'Test wird bearbeitet';
$string['editingquiz_help'] = 'Für die Zusammenstellung von Tests gibt es mehrere Möglichkeiten:

* Test - Ein Test enthält Fragen, die auf einer oder über mehrere Seiten verteilt angezeigt werden
* Fragensammlung - Ein Test wird aus der  Fragensammlung zusammengestellt, in der alle Fragen kategorisiert als Kopie vorkommen
* Zufallsfragen - Jede Person erhält bei jedem neuen Versuch andere Fragen. Unterschiedliche Personen bekommen unterschiedliche Fragen vorgelegt';
$string['editingrandom'] = 'Zufallsfrage bearbeiten';
$string['editingrandomsamatch'] = 'Zufällige Kurzantwort-Zuordnung bearbeiten';
$string['editingrqp'] = '{$a}: Frage bearbeiten';
$string['editingshortanswer'] = 'Kurztextfrage bearbeiten';
$string['editingtruefalse'] = 'Wahr-Falsch-Frage bearbeiten';
$string['editoverride'] = 'Änderung bearbeiten';
$string['editqcats'] = 'Kategorien bearbeiten';
$string['editquestions'] = 'Fragen bearbeiten';
$string['editquiz'] = 'Testinhalt bearbeiten';
$string['editquizquestions'] = 'Testfragen bearbeiten';
$string['emailconfirmbody'] = 'Hallo {$a->username},

vielen Dank für die Vorlage Ihrer Antworten zu \'{$a->quizname}\' im Kurs \'{$a->coursename}\', eingereicht am
{$a->submissiontime}.

Diese E-Mail bestätigt, dass Ihre Antwort sicher angekommen ist.

Sie können auf den Test zugreifen unter {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Danke für die Übermittlung Ihrer Antworten auf \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Test-Vorlagebestätigung: {$a->quizname}';
$string['emailnotifybody'] = 'Hallo {$a->username},

{$a->studentname} hat den Test \'{$a->quizname}\' ({$a->quizurl}) im Kurs \'{$a->coursename}\' beendet.

Sie können diesen Versuch unter {$a->quizreviewurl} ansehen.';
$string['emailnotifysmall'] = '{$a->studentName} hat {$a->quizname} abgeschlossen';
$string['emailnotifysubject'] = '{$a->studentname} hat den Test {$a->quizname} beendet';
$string['empty'] = 'Leer';
$string['enabled'] = 'Aktiviert';
$string['endtest'] = 'Versuch beenden...';
$string['erroraccessingreport'] = 'Sie können nicht auf den Bericht zugreifen.';
$string['errorinquestion'] = 'Fehler in der Frage';
$string['errormissingquestion'] = 'Fehler: Die Frage mit der id {$a} fehlt';
$string['errornotnumbers'] = 'Fehler: Die Antwort muss eine Zahl sein.';
$string['errorsdetected'] = '{$a} Fehler entdeckt';
$string['errorunexpectedevent'] = 'Unerwarteter Ablaufcode {$a->event}  für Frage {$a->questionid} im Versuch {$a->attemptid} gefunden';
$string['essay'] = 'Freitext';
$string['essayquestions'] = 'Freitext-Fragen';
$string['event1'] = 'Automatische Sicherung';
$string['event2'] = 'Sichern';
$string['event3'] = 'Bewertung';
$string['event5'] = 'Validieren';
$string['event6'] = 'Beenden und bewerten';
$string['event7'] = 'Abgabe';
$string['event8'] = 'Schließen';
$string['event9'] = 'Freitext-Bewertung';
$string['everynquestions'] = 'Nach {$a} Fragen';
$string['everyquestion'] = 'Jede Frage';
$string['everythingon'] = 'Alles einschalten';
$string['examview'] = 'Examview';
$string['export'] = 'Export';
$string['exportcategory'] = 'Exportkategorie';
$string['exporterror'] = 'Beim Export ist ein Fehler aufgetreten.';
$string['exportingquestions'] = 'Die Fragen werden in eine Exportdatei übertragen.';
$string['exportname'] = 'Dateiname';
$string['exportquestions'] = 'Fragen in Datei exportieren';
$string['extraattemptrestrictions'] = 'Weitere Beschränkungen bei Versuchen';
$string['false'] = 'Falsch';
$string['feedback'] = 'Feedback';
$string['feedbackerrorboundaryformat'] = 'Die Bewertungsgrenzen für das Feedback müssen entweder in Prozent oder als Zahl angegeben werden. Der von Ihnen eingegebene Grenzwert {$a} wurde nicht erkannt. Bei Prozentwerten darf kein Leerzeichen zwischen der Zahl und dem Prozentwert stehen.';
$string['feedbackerrorboundaryoutofrange'] = 'Die Bewertungsgrenzen für das Feedback müssen zwischen 0% und 100% liegen. Der von Ihnen eingegebene Grenzwert {$a} liegt außerhalb. Bei Prozentwerten darf kein Leerzeichen zwischen der Zahl und dem Prozentwert stehen.';
$string['feedbackerrorjunkinboundary'] = 'Sie müssen die Bewertungsgrenzen in den Feedback-Feldern ausfüllen, ohne Lücken zu lassen.';
$string['feedbackerrorjunkinfeedback'] = 'Sie müssen die Feedback-Felder ausfüllen, ohne Lücken zu lassen.';
$string['feedbackerrororder'] = 'Bewertungsgrenzen für das Feedback müssen mit dem größten Wert beginnen und bis zum kleinsten Wert fortgeführt werden. Der von Ihnen eingegebene Grenzwert {$a} liegt nicht in der Reihe.';
$string['file'] = 'Datei';
$string['fileformat'] = 'Dateiformat';
$string['fillcorrect'] = 'Korrektur eintragen';
$string['filloutnumericalanswer'] = 'Sie geben eine mögliche Antwort und einen Toleranzwert an. Die erste passende Antwort wird benutzt, um Punktzahl und Feedback zu bestimmen. Falls Sie sich entscheiden, am Ende ein Feedback ohne vorherige Antwort zu geben, so wird dies jenen Teilnehmenden gezeigt, deren Antworten auf keine der Vorgaben passen.';
$string['filloutoneanswer'] = 'Sie müssen mindestens ein Antwortfeld ausfüllen. Leere Felder werden ignoriert.';
$string['filloutthreequestions'] = 'Sie müssen mindestens drei Fragen auswählen. Leere Fragen werden nicht verwendet.';
$string['fillouttwochoices'] = 'Sie müssen mindestens zwei Antwortfelder ausfüllen. Leere Felder werden ignoriert.';
$string['finishattemptdots'] = 'Versuch beenden...';
$string['finishreview'] = 'Überprüfung beenden';
$string['forceregeneration'] = 'erzwungene Wiederherstellung';
$string['formatnotfound'] = 'Das Import-Export-Format {$a} wurde nicht gefunden.';
$string['formatnotimplemented'] = 'Das Format wurde nicht richtig implementiert. Bitte erstellen Sie einen Fehlerbericht.';
$string['formulaerror'] = 'Formularfehler!';
$string['fractionsaddwrong'] = 'Die positiven Bewertungen, die Sie gewählt haben, ergeben keine 100%.
<br />Statt dessen ergeben sie {$a}%.
<br />Möchten Sie zurückgehen und diese Frage korrigieren?';
$string['fractionsnomax'] = 'Eine dieser Antworten sollte 100% sein, damit
<br />es möglich ist, die volle Punktzahl für diese Frage zu bekommen.
<br />Möchten Sie zurückgehen und diese Frage korrigieren?';
$string['fromfile'] = 'aus der Datei:';
$string['functiondisabledbysecuremode'] = 'Diese Funktionalität ist momentan deaktiviert';
$string['functiontakesatleasttwo'] = 'Die Funktion {$a} erfordert mindestens zwei Einträge.';
$string['functiontakesnoargs'] = 'Die Funktion {$a} hat keine Einträge.';
$string['functiontakesonearg'] = 'Die Funktion {$a} erfordert genau einen Eintrag.';
$string['functiontakesoneortwoargs'] = 'Die Funktion {$a} erfordert entweder einen oder zwei Einträge.';
$string['functiontakestwoargs'] = 'Die Funktion {$a} erfordert genau zwei Einträge.';
$string['generalfeedback'] = 'Standard-Feedback';
$string['generalfeedback_help'] = '<h2>Allgemeines Fragen-Feedback</h2>

<p>Das allgemeine Fragen-Feedback besteht aus dem Text, den der/die Teilnehmer/in nach dem Versuch sieht, eine Frage zu beantworten. Anders als das Feedback, das vom Fragetyp und der Nutzerantwort abhängt, wird der Text des allgemeinen Fragen-Feedbacks allen Teilnehmern/innen gezeigt.</p>

<p>Sie können einstellen, wann das generelle Feedback erscheint.</p>';
$string['generatevalue'] = 'Erstelle einen neuen Wert zwischen';
$string['geometric'] = 'Geometrisch';
$string['gift'] = 'GIFT';
$string['giftleftbraceerror'] = '{ wurde nicht gefunden';
$string['giftmatchingformat'] = 'Antwort der Zuordnungsfrage wurde unpassend formatiert.';
$string['giftnonumericalanswers'] = 'Für die numerische Frage wurde keine Antwort gefunden';
$string['giftnovalidquestion'] = 'Es wurde keine gültige Frage gefunden.';
$string['giftqtypenotset'] = 'Der Fragetyp wurde nicht ausgewählt.';
$string['giftrightbraceerror'] = 'a } wurde nicht gefunden';
$string['grade'] = 'Bewertung';
$string['gradeall'] = 'Alle bewerten';
$string['gradeaverage'] = 'Durchschnitt';
$string['gradeboundary'] = 'Bewertungsgrenze';
$string['gradeessays'] = 'Freitexte bewerten';
$string['gradehighest'] = 'Bester Versuch';
$string['grademethod'] = 'Bewertungsmethode';
$string['grademethod_help'] = '<h2>Bewertungsmethode</h2>
<p>Wenn mehrere Versuche erlaubt sind, gibt es unterschiedliche
Möglichkeiten, eine abschließende Bewertung für die Teilnehmer/innen festzulegen.</p>
<p><b>Bester Versuch</b></p>
<div style="margin-left: 2em">
<p>Es zählt die Bewertung des besten Versuchs.</p>
</div>
<p><b>Durchschnitt</b></p>
<div style="margin-left: 2em">
<p>Die abschließende Bewertung ergibt sich aus dem Durchschnitt der Bewertungen aller Versuche.</p>
</div>
<p><b>Erster Versuch</b></p>
<div style="margin-left: 2em">
<p>Es zählt die Bewertung des
ersten Versuchs (die anderen Versuche werden
ignoriert).</p>
</div>
<p><b>Letzter Versuch</b></p>
<div style="margin-left: 2em">
<p>Es zählt die Bewertung des letzten Versuchs.</p>
</div>';
$string['gradesdeleted'] = 'Testbewertungen wurden gelöscht';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Punkte: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Mit früheren Abzügen ergibt dies <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Die Arbeit berücksichtigt einen Abzug von {$a}.';
$string['gradingdetailszeropenalty'] = 'Sie erhalten für diese Arbeit keine Abzüge.';
$string['gradingmethod'] = 'Bewertungsmethode: {$a}';
$string['groupoverrides'] = 'Gruppenänderungen';
$string['groupsnone'] = 'Es gibt in diesem Kurs keine Gruppen';
$string['guestsno'] = 'Gäste können den Test weder sehen noch ausprobieren.';
$string['hidebreaks'] = 'Seitenumbrüche verbergen';
$string['hidereordertool'] = 'Neuanordnung verbergen';
$string['history'] = 'Frühere Antworten:';
$string['illegalformulasyntax'] = 'Fehlerhafte Formel-Syntax, beginnend mit {$a}';
$string['imagedisplay'] = 'Abbildung einfügen';
$string['imagemissing'] = 'Bild in Zeile {$a} ist nicht verfügbar. Der Dateiname wird ignoriert.';
$string['import'] = 'Import';
$string['importcategory'] = 'Kategorie-Import';
$string['importerror'] = 'Beim Import ist ein Fehler aufgetreten';
$string['importerrorquestion'] = 'Fehler beim Import';
$string['importfilearea'] = 'Der Dateiimport in die Kursdateien erfolgt ...';
$string['importfileupload'] = 'Dateiimport von hochgeladener Datei ...';
$string['importfromthisfile'] = 'Import aus dieser Datei';
$string['import_help'] = 'Die Funktion ermöglicht es Fragen aus einer Textdatei zu importieren.
Wenn die Datei non ascii Zeichen (z.B. Umlaute) enthält, muss sie UTF-8 codiert sein. Dateien, die mit Microsoft Office erstellt werden, nutzen meist andere Codierungen und führen zu fehlerhaften Zeichendarstellungen.
Die verfügbaren Import- und Exportfunktionen hängen von den installierten Plugins auf Ihrem System ab. Zusätzliche Formate können in der Module- und Plugindatenbank verfügbar sein.';
$string['importingquestions'] = 'Import von {$a} Fragen aus Datei';
$string['importmax10error'] = 'In der Frage ist ein Fehler aufgetreten. Sie dürfen höchstens zehn Antworten formulieren.';
$string['importmaxerror'] = 'Fehler in der Frage: zu viele Antworten.';
$string['importminerror'] = 'In der Frage ist ein Fehler aufgetreten. Es sind nicht genügend Antworten für diesen Fragetyp angelegt worden.';
$string['importparseerror'] = 'Fehler beim Prüfen der Importdatei gefunden. Keine Fragen importiert. Um nur richtig codierte Fragen zu importieren wiederholen Sie den Vorgang mit der Einstellung \'Bei Fehler stoppen: Nein\'.';
$string['importquestions'] = 'Eine Frage aus einer Datei importieren';
$string['inactiveoverridehelp'] = '* Teilnehmer/innen haben nicht die richtige Gruppenzugehörigkeit, um den Test auszuführen.';
$string['incorrect'] = 'Falsch';
$string['indivresp'] = 'Antworten der einzelnen Personen zu jeder Frage';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['introduction'] = 'Anleitungstext';
$string['invalidattemptid'] = 'Keine solche Versuchs-ID vorhanden';
$string['invalidcategory'] = 'Ungültige Kategorie-ID';
$string['invalidnumericanswer'] = 'Eine der von Ihnen eingegebenen Antworten ist keine gültige Zahl.';
$string['invalidnumerictolerance'] = 'Eine der von Ihnen eingegebenen Toleranzen ist keine gültige Zahl.';
$string['invalidoverrideid'] = 'Ungültige ID-Änderung';
$string['invalidquestionid'] = 'Ungültige Frage-ID';
$string['invalidquizid'] = 'Ungültige Test-ID';
$string['invalidsource'] = 'Die Quelle ist ungültig.';
$string['invalidsourcetype'] = 'Ungültiger Quellentyp.';
$string['invalidstateid'] = 'Ungültige Status-ID';
$string['itemanal'] = 'Antwortanalyse';
$string['itemdefinition'] = 'Definition';
$string['itemsource'] = 'Quellwert';
$string['itemsourceformat'] = 'Quellformat';
$string['itemtypes'] = 'Externer Fragetyp';
$string['lastanswer'] = 'Ihre letzte Antwort war';
$string['layout'] = 'Layout';
$string['layoutasshown'] = 'Seitenlayout wie angezeigt.';
$string['layoutasshownwithpages'] = 'Seitenlayout wie angezeigt. <small>(Automatisch neue Seite nach {$a} Fragen.)</small>';
$string['layoutshuffledandpaged'] = 'Zufällige Reihenfolge der Fragen. {$a} Fragen/Seite.';
$string['layoutshuffledsinglepage'] = 'Zufällige Reihenfolge der Fragen. Alle Fragen auf einer Seite.';
$string['learnwise'] = 'Learnwise';
$string['link'] = 'Link';
$string['listitems'] = 'Liste der Testfragen';
$string['literal'] = 'Schreibweise';
$string['loadingquestionsfailed'] = 'Das Laden der Fragen ist gescheitert: {$a}';
$string['loguniform'] = 'logarithmische Verteilung der Werte';
$string['makecopy'] = 'Als neue Frage abspeichern';
$string['managetypes'] = 'Fragetypen und Server verwalten';
$string['manualgrading'] = 'Bewertung';
$string['mark'] = 'Abschicken';
$string['markall'] = 'Seite bewerten lassen';
$string['marks'] = 'Punkte';
$string['match'] = 'Zuordnung';
$string['matchanswer'] = 'Zugeordnete Antwort';
$string['matchanswerno'] = 'Zutreffende Antworten {$a}';
$string['matcherror'] = 'Die Bewertungen passen nicht zu den Bewertungsoptionen - Frage wurde übersprungen.';
$string['matchgrades'] = 'Bewertungen zuordnen';
$string['matchgradeserror'] = 'Fehler, wenn Note nicht aufgelistet';
$string['matchgradesnearest'] = 'Nächstliegende Bewertung, Note nicht aufgelistet';
$string['max'] = 'Max';
$string['messageprovider:confirmation'] = 'Bestätigung einer eigenen Testabgabe';
$string['messageprovider:submission'] = 'Mitteilung bei Testeinreichungen';
$string['min'] = 'Min';
$string['minutes'] = 'Minuten';
$string['missinganswer'] = 'Zu wenige Angaben :Antworten,:Lx,:Rx für Zeile {$a}. Sie müssen mindestens zwei mögliche Antworten eingeben.';
$string['missingcorrectanswer'] = 'Die korrekte Antwort muss angegeben werden.';
$string['missingformula'] = 'Formel fehlt';
$string['missingitemtypename'] = 'Name fehlt';
$string['missingname'] = 'Der Titel der Frage fehlt';
$string['missingquestion'] = 'Fehlendes Fragezeichen nach Zeile {$a}';
$string['missingquestiontext'] = 'Der Text der Frage fehlt';
$string['missingword'] = 'Lückentext (Missing Word)';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Das Modul \'Test\' erlaubt es, Tests zu entwerfen und zu erstellen, die aus unterschiedlichen Fragetypen (z.B. Multiple-Choice, Wahr/Falsch, Zuordnung) bestehen. Jeder Versuch wird automatisch registriert und die Trainer/innen können wählen, ob ein Feedback gegeben oder ob die richtigen Antworten gezeigt werden sollen.';
$string['modulenameplural'] = 'Tests';
$string['moveselectedonpage'] = 'Verschieben der ausgewählten Fragen zur Seite: {$a}';
$string['moveto'] = 'Verschieben nach >>';
$string['multianswer'] = 'Lückentext (Cloze)';
$string['multichoice'] = 'Multiple-Choice';
$string['multipleanswers'] = 'Antwort(en) wählen:';
$string['multiplier'] = 'Multiplikator';
$string['name'] = 'Name';
$string['navnojswarning'] = 'Achtung: Mit diesen Links werden Ihre Antworten nicht gesichert. Benutzen Sie den Button "Weiter" am Ende der Seite.';
$string['neverallononepage'] = 'Nie, alle Fragen auf einer Seite';
$string['newattemptfail'] = 'Fehler: Ein neuer Versuch des Tests konnte nicht begonnen werden.';
$string['newpage'] = 'Neue Seite';
$string['newpageevery'] = 'Automatisch eine neue Seite beginnen';
$string['newpage_help'] = 'Bei längeren Tests ist es sinnvoll, die Fragen auf mehrere Seiten zu verteilen. Wenn Sie bei der Testzusammenstellung Fragen hinzufügen, werden an der entsprechenden Stelle automatisch Seitenumbrüche eingefügt. Sie können die Seitenumbrüche später manuell anpassen.';
$string['noanswers'] = 'Es wurden keine Antworten ausgewählt!';
$string['noattempts'] = 'Diesen Test hat niemand durchgeführt.';
$string['noattemptstoshow'] = 'Es gibt keine Versuche, die angezeigt werden können.';
$string['nocategory'] = 'Sie haben keine oder eine falsche Kategorie ausgewählt.';
$string['noclose'] = 'Kein Abgabedatum';
$string['nocommentsyet'] = 'Derzeit keine Kommentare vorhanden';
$string['noconnection'] = 'Es gibt derzeit keine Verbindung zu einem Webservice, der diese Frage beantworten kann. Nehmen Sie Kontakt mit der Administration auf.';
$string['nodataset'] = 'nichts - es gibt keine Wildcard';
$string['nodatasubmitted'] = 'Keine Daten abgegeben';
$string['noessayquestionsfound'] = 'Keine Freitext-Fragen gefunden';
$string['nogradewarning'] = 'Der Test ist noch nicht bewertet. Daher gibt es noch keine Gesamtbewertung nach Noten getrennt';
$string['nomatchinganswer'] = 'Sie müssen eine passende Antwort angeben zur Frage \'{$a}\'.';
$string['nominal'] = 'Nominal';
$string['nomoreattempts'] = 'Kein Versuch mehr zugelassen';
$string['none'] = '--';
$string['noopen'] = 'Kein Startzeitpunkt';
$string['nooverridedata'] = 'Sie müssen mindestens eine Testeinstellung ändern.';
$string['nopossibledatasets'] = 'Keine Datensätze möglich';
$string['noquestionintext'] = 'Der Fragetext enthält keine Frageformulierung.';
$string['noquestions'] = 'Es wurden noch keine Fragen eingetragen.';
$string['noquestionsfound'] = 'Keine Fragen gefunden';
$string['noquestionsinfile'] = 'In der Importdatei sind keine Fragen enthalten.';
$string['noquestionsinquiz'] = 'Es gibt keine Fragen in diesem Test.';
$string['noquestionsnotinuse'] = 'Diese Zufallsfrage wird nicht genutzt, da ihre Kategorie leer ist.';
$string['noquestionsonpage'] = 'Leere Seite';
$string['noresponse'] = 'Keine Rückantwort';
$string['noreview'] = 'Sie dürfen diesen Test nicht überprüfen.';
$string['noreviewattempt'] = 'Sie dürfen diesen Versuch nicht prüfen.';
$string['noreviewshort'] = 'Nicht erlaubt.';
$string['noreviewuntil'] = 'Sie dürfen diesen Test bis {$a} nicht überprüfen.';
$string['noreviewuntilshort'] = '{$a} verfügbar';
$string['noscript'] = 'JavaScript muss zum Fortsetzen aktiviert sein!';
$string['notavailable'] = 'Dieser Test steht zur Zeit nicht zur Verfügung.';
$string['notavailabletostudents'] = 'Hinweis: Dieser Test steht den Teilnehmer/innen zur Zeit nicht zur Verfügung.';
$string['notenoughanswers'] = 'Diese Art von Fragen erfordert zumindest {$a} Antworten.';
$string['notenoughsubquestions'] = 'Es wurden noch nicht genügend Unterfragen definiert! <br />Möchten Sie zurückgehen und diese Frage korrigieren?';
$string['notimedependentitems'] = 'Zeitabhängige Einzelaufgaben werden zur Zeit vom Testmodul nicht unterstützt. Sie können jedoch ein Zeitlimit für den gesamten Test festlegen. Wollen Sie eine andere Frage auswählen (oder die derzeitige Frage trotzdem nutzen)?';
$string['notyourattempt'] = 'Dies ist nicht Ihr Versuch!';
$string['noview'] = 'Angemeldete/r Nutzer/in darf diesen Test nicht sehen';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} haben {$a->attemptnum} Versuche durchgeführt.';
$string['numattemptsmade'] = '{$a} Versuche wurden in diesem Test gemacht';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerisch';
$string['numquestionsx'] = 'Fragen: {$a}';
$string['onlyteachersexport'] = 'Nur Trainer/innen können Fragen exportieren';
$string['onlyteachersimport'] = 'Nur Trainer/innen mit Bearbeitungsrecht können Fragen importieren';
$string['open'] = 'Nicht beantwortet';
$string['openclosedatesupdated'] = 'Start- und Schlusstermin des Tests wurden aktualisiert';
$string['optional'] = 'optional';
$string['orderandpaging'] = 'Reihenfolge und Seitenumbrüche';
$string['orderandpaging_help'] = 'Die Zahlen 10, 20, 30, ... neben jeder Frage zeigt deren Reihenfolge an. Die Zahlenfolge in 10er-Schritten lässt Platz, um weitere Fragen einfügen zu können. Um die Reihenfolge der Fragen zu ändern, ändern Sie die Zahlen und klicken auf die Taste \'Neu sortieren\'.

Um Seitenumbrüche nach bestimmten Fragen einzufügen, markieren Sie das Kontrollfeld \'Neue Seite nach markierter Frage hinzufügen\'.

Um Fragen über eine Reihe von Seiten anzuordnen, klicken Sie auf die Taste \'Seitenumbrüche durchführen\' und wählen die gewünschte Anzahl von Fragen pro Seite.';
$string['orderingquiz'] = 'Reihenfolge und Seitenumbrüche';
$string['outof'] = '{$a->grade} von maximal {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} von maximal {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Gesamt-Feedback';
$string['overallfeedback_help'] = '<h2>Gesamt-Feedback </h2>

<p>Das Gesamt-Feedback wird am Ende eines Testdurchlaufs angezeigt. Der Text kann je nach Testergebnis unterschiedlich lauten.</p>

<p>Ein Beispiel: Tragen Sie ein: "Gut gemacht" im ersten Feedback-Feld, 40%
im ersten Bewertungsgrenzfeld, und  "Bitte wiederhole den Inhalt dieser Woche noch einmal"
im zweiten Feedback-Feld. In diesem Fall erhalten Teilnehmende mit einem Ergebnis von 40% richtig oder einem höheren Wert das Feedback "Gut gemacht". Alle anderen erhalten die andere Rückmeldung.  </p>

<p>Mit den Zahlenwerten werden Intervalle beschrieben. Wenn das Testergebnis zwischen dem Wert über und dem Wert unter dem Feedback-Text liegt, wird der zwischen den Werten liegende  Feedback-Text angezeigt.</p>

<p>
Beispiel: 	100%</p><p>
Feedback: 	Gutes Ergebnis</p><p>
Bewertungsgrenzen: 80 %	</p><p>
Feedback: 	Befriedigend</p><p>
Bewertungsgrenzen: 60 %</p>

<p> In diesem Fall wird für Ergebnisse zwischen  100% und 80 % der Feedbacktext "Gutes Ergebnis"	 angezeigt.</p>

<p>Die Bewertungsgrenze kann als Prozentwert (z.B. 31.3%) oder als Zahlwert (z.B. 7) eingetragen werden. Wenn bei Ihrem Test 10 Punkte zu erreichen sind, bedeutet der Wert 7, dass 7 von 10 Punkten erreicht werden müssen. Bei Prozentwerten darf kein Leerzeichen zwischen der Zahl und dem Prozentwert stehen. </p>';
$string['overdue'] = 'Überfällig';
$string['override'] = 'Überschreiben';
$string['overridedeletegroupsure'] = 'Sind Sie sicher, dass Sie die Änderung für die Gruppe {$a} löschen möchten?';
$string['overridedeleteusersure'] = 'Sind Sie sicher, dass Sie die Änderung für Nutzer/in {$a} löschen möchten?';
$string['overridegroup'] = 'Gruppe ändern';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Änderungen';
$string['overrideuser'] = 'Nutzer/in ändern';
$string['overrideusereventname'] = '{$a->quiz} - Änderung';
$string['pagesize'] = 'Wie viele Versuche pro Seite anzeigen:';
$string['paragraphquestion'] = 'Das Fragezeichen in Zeile {$a} wird nicht unterstützt. Die Frage wird ignoriert.';
$string['parent'] = 'Übergeordnete Kategorie';
$string['parentcategory'] = 'Übergeordnete Kategorie';
$string['parsingquestions'] = 'Fragen aus der Importdatei werden ausgewertet (parsing)';
$string['partiallycorrect'] = 'Teilweise richtig';
$string['passworderror'] = 'Das eingegebene Kennwort war falsch.';
$string['penalty'] = 'Abzug';
$string['penaltyscheme'] = 'Abzüge festlegen';
$string['penaltyscheme_help'] = '<h2>Punktabzüge verwenden</h2>

<p>Wenn ein Test im adaptiven Modus abläuft, kann ein/e Teilnehmer/in Fragen noch einmal bearbeiten, die nicht korrekt beantwortet wurden. In diesem Fall können Sie einen Punktabzug festlegen, wenn die Frage nicht beim ersten Mal richtig beantwortet wird. Für jeden weiteren Versuch erfolgt der wiederholte Punktabzug. Die Einstellung muss für jede Frage separat festgelegt werden.</p>

<p>Die Einstellung zeigt nur Wirkung, wenn der adaptive Modus aktiviert ist.</p>';
$string['percentcorrect'] = 'Richtig in Prozent';
$string['pleaseclose'] = 'Ihre Anfrage wurde bearbeitet. Sie können das Fenster jetzt schließen.';
$string['pluginadministration'] = 'Test-Administration';
$string['pluginname'] = 'Test';
$string['popup'] = '"Sicheres" Fenster (nur wenige Browser)';
$string['popupblockerwarning'] = 'Dieser Bereich des Tests läuft im sicheren Modus ab, d.h. Sie müssen den Test in einem sicheren Fenster bearbeiten. Bitte schalten Sie den Popup-Blocker Ihres Browsers aus.';
$string['popupnotice'] = 'Teilnehmer/innen sehen den Test in einem sicheren Fenster.';
$string['popupwithjavascriptsupport'] = 'Vollbild-Popup mit einer gewissen Javascript-Sicherheit';
$string['preprocesserror'] = 'Fehler bei der Verarbeitung (pre-processing)!';
$string['preview'] = 'Vorschau';
$string['previewquestion'] = 'Vorschau der Frage';
$string['previewquiz'] = 'Vorschau {$a}';
$string['previewquiznow'] = 'Vorschau ansehen';
$string['previous'] = 'Letzter Zustand';
$string['publish'] = 'Veröffentlichen';
$string['publishedit'] = 'Um Fragen in dieser Kategorie zu bearbeiten, müssen Sie über die erforderlichen Rechte verfügen.';
$string['qname'] = 'Name';
$string['qti'] = 'IMS-QTI';
$string['qti_two'] = 'Format IMS QTI 2.0';
$string['qtypename'] = 'Typ, Name';
$string['question'] = 'Frage';
$string['questionbankcontents'] = 'Fragensammlung';
$string['questionbankmanagement'] = 'Fragensammlung verwalten';
$string['questionbehaviour'] = 'Frageverhalten';
$string['questioncats'] = 'Fragenkategorien';
$string['questiondeleted'] = 'Diese Frage wurde gelöscht. Fragen Sie bitte Ihre/n Trainer/in.';
$string['questioninuse'] = 'Die Frage \'{$a->questionname}\' wird aktuell benutzt in:<br />{$a->quiznames}<br />. Die Frage kann nicht aus diesen Tests gelöscht werden, sondern nur aus der Kategorienliste ausgetragen.';
$string['questionmissing'] = 'Frage für diesen Abschnitt fehlt';
$string['questionname'] = 'Titel der Frage';
$string['questionnametoolong'] = 'Die Bezeichnung der Frage in Zeile {$a} ist zu lang (max. 255 Zeichen) und wurde gekürzt.';
$string['questionno'] = 'Frage {$a}';
$string['questionnotloaded'] = 'Frage {$a} wurde nicht aus der Datenbank geladen';
$string['questionorder'] = 'Fragenreihenfolge';
$string['questions'] = 'Fragen';
$string['questionsinclhidden'] = 'Fragen (auch die verborgenen)';
$string['questionsinthisquiz'] = 'Fragen für diesen Test';
$string['questionsinuse'] = '(* Fragen mit einem Sternchen werden in Tests verwandt. Diese Fragen werden nicht aus diesen Tests gelöscht, sondern nur aus der Kategorienliste ausgetragen.)';
$string['questionsperpage'] = 'Zahl der Fragen pro Seite';
$string['questionsperpageselected'] = 'Die Einstellung \'Fragen pro Seite\' wurde festgelegt, so dass die Steuerung der Seitenumbrüche im Moment deaktiviert ist. Sie können dies aber ändern: {$a}.';
$string['questionsperpagex'] = 'Fragen pro Seite: {$a}';
$string['questiontext'] = 'Fragetext';
$string['questiontextisempty'] = '[Leerer Fragetext]';
$string['questiontype'] = 'Fragetyp {$a}';
$string['questiontypesetupoptions'] = 'Setup-Optionen für Fragetypen';
$string['quiz:attempt'] = 'Tests ausprobieren';
$string['quizavailable'] = 'Der Test ist verfügbar bis {$a}';
$string['quizclose'] = 'Testschließung';
$string['quizclosed'] = 'Dieser Test schließt am {$a}';
$string['quizcloses'] = 'Testschließung';
$string['quizcloseson'] = 'Dieser Test läuft nur bis {$a}';
$string['quiz:deleteattempts'] = 'Testversuche löschen';
$string['quiz:emailconfirmsubmission'] = 'Bei Abgabe eine E-Mail-Bestätigung erhalten';
$string['quiz:emailnotifysubmission'] = 'Bei Abgaben eine E-Mail-Benachrichtigung erhalten';
$string['quiz:grade'] = 'Tests manuell bewerten';
$string['quiz:ignoretimelimits'] = 'Zeitgrenzen für Tests ignorieren';
$string['quizisclosed'] = 'Dieser Test wurde bereits beendet';
$string['quizisopen'] = 'Aktuell läuft dieser Test';
$string['quizisopenwillclose'] = 'Test geöffnet (Ende {$a})';
$string['quiz:manage'] = 'Tests verwalten';
$string['quiz:manageoverrides'] = 'Teständerungen verwalten';
$string['quiznavigation'] = 'Test-Navigation';
$string['quiznotavailable'] = 'Dieser Test ist nicht verfügbar bis: {$a}';
$string['quizopen'] = 'Testöffnung';
$string['quizopened'] = 'Der Test ist geöffnet';
$string['quizopenedon'] = 'Der Test beginnt am {$a}';
$string['quizopens'] = 'Testöffnung';
$string['quizopenwillclose'] = 'Der Test ist geöffnet und wird geschlossen am {$a} um';
$string['quizordernotrandom'] = 'Die Reihenfolge des Tests ist nicht zufällig';
$string['quizorderrandom'] = '* Die Reihenfolge des Tets ist zufällig';
$string['quiz:preview'] = 'Test-Vorschau';
$string['quiz:regrade'] = 'Neubewertung der Testversuche';
$string['quiz:reviewmyattempts'] = 'Eigene Testversuche erneut ansehen';
$string['quizsettings'] = 'Test-Einstellungen';
$string['quiztimelimit'] = 'Zeitbegrenzung: {$a}';
$string['quiz:view'] = 'Test-Informationen sehen';
$string['quiz:viewreports'] = 'Test-Berichte sehen';
$string['quizwillopen'] = 'Dieser Test wird geöffnet: {$a}';
$string['random'] = 'Zufallsfrage';
$string['randomcreate'] = 'Zufallsfragen erstellen';
$string['randomfromcategory'] = 'Zufallsfrage aus der Kategorie:';
$string['randomfromexistingcategory'] = 'Zufallsfrage in einer bestehenden Kategorie';
$string['randomnosubcat'] = 'Fragen nur aus dieser Kategorie, nicht aus deren Unterkategorien.';
$string['randomquestionusinganewcategory'] = 'Zufallsfrage in einer neuen Kategorie';
$string['randomsamatch'] = 'Zufällige Kurzantwort-Zuordnung';
$string['randomsamatchcreate'] = 'Zufällige Kurzantwort-Zuordnungsfragen erzeugen';
$string['randomsamatchintro'] = 'Wählen Sie für jede der folgenden Fragen die passende Antwort aus dem Menü aus.';
$string['randomsamatchnumber'] = 'Anzahl auszuwählender Fragen';
$string['randomwithsubcat'] = 'Fragen aus dieser Kategorie und aus deren Unterkategorien.';
$string['readytosend'] = 'Sie sind dabei, Ihren Test zur Bewertung abzuschicken. Sind Sie sicher, dass Sie fortfahren wollen?';
$string['reattemptquiz'] = 'Test wiederholen';
$string['recentlyaddedquestion'] = 'Kürzlich hinzugefügte Frage!';
$string['recurse'] = 'Unterkategorien einbeziehen';
$string['regrade'] = 'Alle Versuche neu bewerten';
$string['regradecomplete'] = 'Alle Versuche wurden neu bewertet.';
$string['regradecount'] = '{$a->changed} von {$a->attempt} Noten wurden geändert.';
$string['regradedisplayexplanation'] = 'Versuche, die bei der Neubewertung verändert wurden, werden als Hyperlinks angezeigt.';
$string['regradenotallowed'] = 'Sie haben nicht die Berechtigung zur Neubewertung des Tests.';
$string['regradingquestion'] = 'Neubewertung "{$a}"';
$string['regradingquiz'] = 'Neubewertung Test "{$a}"';
$string['relative'] = 'Relativ';
$string['remove'] = 'Entfernen';
$string['removeallquizattempts'] = 'Alle Testversuche entfernen';
$string['removeemptypage'] = 'Entferne leere Seite';
$string['removeselected'] = 'Ausgewählte entfernen';
$string['rename'] = 'Umbenennen';
$string['renderingserverconnectfailed'] = 'Der Server {$a} konnte die RQP-Anfrage nicht verarbeiten. Prüfen Sie, ob die eingegebene URL korrekt ist.';
$string['reorderquestions'] = 'Neuanordnung der Fragen';
$string['reordertool'] = 'Neuanordnung anzeigen';
$string['repaginate'] = 'Seitenumbrüche mit {$a} Fragen pro Seite durchführen';
$string['repaginatecommand'] = 'Seitenumbrüche durchführen';
$string['repaginatenow'] = 'Seitenumbrüche durchführen';
$string['replace'] = 'Ersetze';
$string['replacementoptions'] = 'Erzetzungsoptionen';
$string['report'] = 'Berichte';
$string['reportanalysis'] = 'Ergebnisanalyse';
$string['reportfullstat'] = 'Ausführliche Statistik';
$string['reportmulti_percent'] = 'Mehrere Prozentsätze';
$string['reportmulti_q_x_student'] = 'Mehrere Teilnehmer/innen';
$string['reportmulti_resp'] = 'Individuelle Rückantwort';
$string['reportnotfound'] = 'Bericht unbekannt ({$a})';
$string['reportoverview'] = 'Übersicht';
$string['reportregrade'] = 'Testversuche löschen';
$string['reportresponses'] = 'Detailantworten';
$string['reports'] = 'Berichte';
$string['reportsimplestat'] = 'Einfache Statistik';
$string['requirepassword'] = 'Kennwort';
$string['requirepassword_help'] = 'Wenn Sie ein Kennwort festlegen, müssen die Teilnehmer/innen
erst das Kennwort eingeben, bevor sie den Test
versuchen können.';
$string['requirepasswordmessage'] = 'Zur Teilnahme am Test benötigen Sie ein Kennwort.';
$string['requiresafeexambrowser'] = 'Benutzung des Safe Exam Browsers erforderlich';
$string['requiresubnet'] = 'IP-Adresse';
$string['requiresubnet_help'] = 'Sie können den Testzugriff auf bestimmte Rechner oder IP-Adressen beschränken, wenn beispielsweise nur Teilnehmer/innen in einem bestimmten Raum den Test durchführen dürfen. Die zugelassenen IP-Adressen geben Sie in einer kommagetrennten Liste teilweise oder vollständig an (z.B. <b>192.168. , 231.54.211.0/20, 231.3.56.211</b>).';
$string['response'] = 'Eingabe TN';
$string['responses'] = 'Eigene Eingaben';
$string['results'] = 'Ergebnisse';
$string['reuseifpossible'] = 'Wiederverwendung kürzlich entfernt';
$string['reverttodefaults'] = 'Test auf die Voreinstellung zurücksetzen';
$string['review'] = 'Bericht';
$string['reviewafter'] = 'Rückblick erlauben, wenn der Test abgeschlossen ist';
$string['reviewalways'] = 'Rückblick immer erlauben';
$string['reviewattempt'] = 'Versuch erneut ansehen';
$string['reviewbefore'] = 'Rückblick erlauben, solange der Test offen ist';
$string['reviewclosed'] = 'Wenn der Test abgeschlossen ist';
$string['reviewimmediately'] = 'Direkt nach dem Versuch';
$string['reviewnever'] = 'Keinen Rückblick erlauben';
$string['reviewofattempt'] = 'Überprüfung des Versuchs {$a}';
$string['reviewofpreview'] = 'Vorschauansicht überprüfen';
$string['reviewopen'] = 'Später, während der Test noch geöffnet ist';
$string['reviewoptions'] = 'Was sollen die Teilnehmer/innen zu welchem Zeitpunkt sehen';
$string['reviewoptionsheading'] = 'Berichtsoptionen';
$string['reviewoptionsheading_help'] = '<h2>Rückschau zulassen</h2>

<p>Mit diesen Optionen legen Sie fest, welche Informationen Teilnehmer/innen angezeigt bekommen, wenn sie einen Testversuch wiederholen oder sich den Ergebnisbericht anschauen.</p>

<p>Direkt nach dem Versuch bedeutet, innerhalb der nächsten beiden Minuten nach dem sie den Test beendet und abgespeichert haben.</p>

<p>Später, während der Test noch offen ist bedeutet, nach den beiden Minuten (siehe oben) und bevor der Testbearbeitungszeitraum abgeschlossen ist.</p>

<p>Nach Beendigung des Tests meint, nach Ende des Bearbeitungszeitraums. Wenn kein solcher Termin definiert ist, ist diese Einstellung nicht sinnvoll. </p>

<p>Nutzer mit der Berechtigung \'Verborgene Bewertungen sehen\' [moodle/grade:viewhidden]
(normalerweie Trainer/innen oder Admins) sind von diesen Einstellungen nicht betroffen und können die Informationen jederzeit sehen.</p>';
$string['reviewresponse'] = 'Antwort erneut anzeigen';
$string['reviewresponsetoq'] = 'Antwort erneut anzeigen (Frage {$a})';
$string['reviewthisattempt'] = 'Einsicht in die eigenen Antworten dieses Versuchs';
$string['rqp'] = 'Remote-Frage';
$string['rqps'] = 'Remote-Fragen';
$string['safebrowsererror'] = 'Dieser Test wurde so eingestellt, dass er ausschließlich im Safe Exam Browser erscheint. Sie können den Test nicht mit Ihrem aktuellen Browser starten.';
$string['safebrowsernotice'] = 'Dieser Test wurde so eingestellt, dass Teilnehmer/innen ihn nur dann starten können, wenn sie den Safe Exam Browser benutzen.';
$string['sameasoverall'] = 'Genauso wie bei Gesamtbewertung';
$string['save'] = 'Speichern';
$string['saveandedit'] = 'Änderungen speichern und Fragen bearbeiten';
$string['saveattemptfailed'] = 'Der derzeitige Testversuch konnte nicht gespeichert werden.';
$string['savedfromdeletedcourse'] = 'Aus dem gelöschten Kurs "{$a}" gespeichert.';
$string['savegrades'] = 'Bewertungen speichern';
$string['savemyanswers'] = 'Meine Antworten auswerten';
$string['savenosubmit'] = 'Zwischenspeichern';
$string['saveoverrideandstay'] = 'Speichern und weitere Änderung';
$string['savequiz'] = 'Diesen gesamten Test speichern';
$string['score'] = 'Punktzahl';
$string['scores'] = 'Punkte';
$string['select'] = 'Auswählen';
$string['selectall'] = 'Alle auswählen';
$string['selectcategory'] = 'Wählen Sie eine Kategorie';
$string['selectcategoryabove'] = 'Wählen Sie oben eine Kategorie';
$string['selectedattempts'] = 'Ausgewählte Versuche ...';
$string['selectnone'] = 'Alle abwählen';
$string['selectquestiontype'] = '-- Wählen Sie einen Fragen-Typ --';
$string['serveradded'] = 'Server hinzugefügt';
$string['serveridentifier'] = 'Identifizierung';
$string['serverinfo'] = 'Serverinformation';
$string['serverinuse'] = 'Der Server {$a}, den Sie löschen wollen, ist der letzte verbleibende {$a} Server. Es gibt Fragen, die nicht mehr funktionieren werden, wenn Sie die Verbindung löschen.';
$string['servers'] = 'Server';
$string['serverurl'] = 'Server-URL';
$string['settingsoverrides'] = 'Einstellungsänderungen';
$string['shortanswer'] = 'Kurzantwort';
$string['show'] = 'Zeigen';
$string['showall'] = 'Alle Fragen auf einer Seite anzeigen';
$string['showblocks'] = 'Blöcke bei den Testversuchen zeigen';
$string['showblocks_help'] = 'Ja bedeutet: die Kursblöcke sind auch während des Testversuchs sichtbar';
$string['showbreaks'] = 'Seitenumbrüche anzeigen';
$string['showcategorycontents'] = 'Kategorie-Inhalte {$a->arrow} anzeigen';
$string['showcorrectanswer'] = 'Mit dem Feedback richtige Antwort anzeigen?';
$string['showdetailedmarks'] = 'Bewertungsdetails anzeigen';
$string['showeachpage'] = 'Seiten einzeln anzeigen';
$string['showfeedback'] = 'Nach dem Antworten Feedback anzeigen?';
$string['showhidden'] = 'Auch alte Fragen anzeigen';
$string['showinsecurepopup'] = 'Browsersicherheit';
$string['shownoattempts'] = 'Teilnehmer/innen anzeigen, die keine Versuche durchgeführt haben';
$string['shownoattemptsonly'] = 'Nur Teilnehmer/innen anzeigen, die keine Versuche durchgeführt haben';
$string['showquestiontext'] = 'Fragetext in der Frageliste mit anzeigen';
$string['showteacherattempts'] = 'Versuche der Trainer/innen anzeigen';
$string['showuserpicture'] = 'Nutzerbild anzeigen';
$string['showuserpicture_help'] = 'Aktiviert bedeutet: Name und Profilbild des Teilnehmers wird während des Testversuchs und bei der Rückschau angezeigt. Das macht es einfacher während einer Prüfung festzustellen, ob der Teilnehmer die Prüfung mit seinem eigenen Account durchführt. ';
$string['shuffle'] = 'Mischen';
$string['shuffleanswers'] = 'Antworten mischen';
$string['shuffledrandomly'] = 'Zufälllige Reihenfolge';
$string['shufflequestions'] = 'Fragen mischen';
$string['shufflequestionsselected'] = 'Es wurde die zufällige Fragenreihenfolge gewählt. Dadurch können einige Funktion zur Anordnung der Fragen nicht genutzt werden. Sie können dies in {$a} ändern.';
$string['shufflewithin'] = 'Antworten innerhalb der Fragen mischen';
$string['shufflewithin_help'] = '<h2>Antworten innerhalb der Fragen mischen</h2>

<p>Mit dieser Option werden die Antworten innerhalb einzelner Fragen bei jedem Versuch zufällig gemischt, vorausgesetzt, diese Option ist auch in den Fragen-Einstellungen aktiviert.
</p>

<p>Absicht dieser Funktion ist es, den Teilnehmenden das Kopieren voneinander zu erschweren.</p>

<p>Die Funktion hat nur dann Auswirkungen, wenn Fragen aus mehreren Teilen bestehen (Multiple-Choice- oder Zuordnungsfragen). Bei Multiple-Choice-Fragen werden die Antworten nur gemischt, wenn diese Option auf &quot;Ja&quot; gestellt ist.  Bei Zuordnungsfragen werden die Antworten immer gemischt. Die Funktion bewirkt dann, dass die Frage-Antwort-Paare auch gemischt werden.</p>

<p>Die Option hat keinen Bezug zur Zufallsfragenfunktion.</p>';
$string['significantfigures'] = 'mit {$a}';
$string['significantfiguresformat'] = 'signifikante Ziffern';
$string['singleanswer'] = 'Antwort wählen:';
$string['sortage'] = 'Sortieren nach Alter';
$string['sortalpha'] = 'Alphabetisch sortieren';
$string['sortquestionsbyx'] = 'Fragen nach {$a} sortieren';
$string['sortsubmit'] = 'Nach Fragen sortieren';
$string['sorttypealpha'] = 'Sortieren nach Typ, Name';
$string['specificapathnotonquestion'] = 'Der angegebene Dateipfad zeigt nicht auf die angegebene Frage';
$string['specificquestionnotonquiz'] = 'Die angegebene Frage kommt nicht im angegebenen Test vor';
$string['startagain'] = 'Erneut starten';
$string['startedon'] = 'Begonnen am';
$string['statenotloaded'] = 'Status der Frage {$a} wurde nicht aus der Datenbank geladen';
$string['status'] = 'Status';
$string['stoponerror'] = 'Bei Fehler anhalten';
$string['submitallandfinish'] = 'Abgabe';
$string['subneterror'] = 'Der Zugang zum Test wurde beschränkt. Aktuell ist der von Ihnen benutzte Computer nicht freigegeben, um damit den Test durchführen können.';
$string['subnetnotice'] = 'Der Zugang zum Test wurde beschränkt. Aktuell ist der von Ihnen benutzte Computer nicht freigegeben, um damit den Test durchführen können. Als Trainer/in dürfen Sie aber von überall aus zugreifen.';
$string['subnetwrong'] = 'Dieser Test kann nur von bestimmten festgelegten Computern aus durchgeführt. Ihr Computer befindet sich nicht auf der Liste.';
$string['substitutedby'] = 'wird ersetzt durch';
$string['summaryofattempt'] = 'Zusammenfassung der Versuche';
$string['summaryofattempts'] = 'Zusammenfassung der vorherigen Versuche';
$string['temporaryblocked'] = 'Sie können für einige Zeit keinen neuen Versuch durchführen. </br>Machen Sie einen weiteren Versuch ab:';
$string['time'] = 'Zeit';
$string['timecompleted'] = 'Beendet';
$string['timedelay'] = 'Bis zum nächsten Testversuch muss einige Zeit verstreichen.';
$string['timeleft'] = 'Verbleibende Zeit';
$string['timelimit'] = 'Zeitbegrenzung';
$string['timelimitexeeded'] = 'Die Zeit für den Test ist abgelaufen!';
$string['timelimit_help'] = '<h2>Zeitbegrenzung</h2>
<p>In der Grundeinstellung haben Tests kein Zeitlimit.</p>
<p>Wenn Sie eine Zeitbegrenzung festlegen, passiert Folgendes:</p>
<ul>

<li>Ein Zeitfenster wird eingeblendet und zeigt die verbleibende
Zeit.</li>
<li>Wenn die Zeit abgelaufen ist, wird der Test automatisch
gespeichert und im letzten Zustand der Bearbeitung
abgegeben.</li>
<li>Wenn ein/e Teilnehmer/in zu schummeln versucht und mehr als
60 Sekunden über die zugewiesene Zeit verwendet, dann wird
der Test automatisch mit Null bewertet.</li>
<li>Wird der Test vor dem Versuch verlassen, wird die Zeit am
Server weitergezählt!!!</li>
<li>Hinweis: Javascript-Unterstützung im Browser ist obligatorisch,
damit die Zeitfunktion korrekt läuft.</li>
</ul>';
$string['timelimitmin'] = 'Zeitbegrenzung (in Minuten)';
$string['timelimitsec'] = 'Zeitbegrenzung (Sekunden)';
$string['timestr'] = '%H:%M:%S am %d/%m/%y';
$string['timesup'] = 'Zeit ist abgelaufen.';
$string['timetaken'] = 'Verbrauchte Zeit';
$string['tofile'] = 'zur Datei';
$string['tolerance'] = 'Toleranz';
$string['tolerancetype'] = 'Toleranztyp';
$string['toomanyrandom'] = 'Die Anzahl der benötigten Zufallsfragen ist größer als die Anzahl der in der Kategorie enthaltenen Fragen! ({$a})';
$string['top'] = 'Spitze';
$string['totalpointsx'] = 'Summe der Bewertungen: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Summe der {$a} Fragen in der Kategorie.';
$string['true'] = 'Wahr';
$string['truefalse'] = 'Wahr-Falsch';
$string['truefalseimporterror'] = '<b>Warnung !</b> Die Wahr-/Falsch-Frage \'{$a->questiontext}\' konnte nicht sicher importiert werden. Es ist nicht klar, ob die korrekte Antwort \'wahr\' oder \'falsch\' ist. Der Import erfolgte unter der Annahme, dass die Antwort ist \'{$a->answer}\'. Falls dies nicht richtig ist, müssen Sie die Frage noch einmal bearbeiten.';
$string['type'] = 'Typ';
$string['unfinished'] = 'offen';
$string['ungraded'] = 'Unbewertet';
$string['uniform'] = 'gleichmäßige Verteilung der Werte';
$string['unit'] = 'Einheit';
$string['unknowntype'] = 'Der Fragetyp in Zeile {$a} wird nicht unterstützt. Die Frage wird ignoriert.';
$string['unsupportedformulafunction'] = 'Die Funktion {$a} wird nicht unterstützt';
$string['unusedcategorydeleted'] = 'Nach dem Löschen des Kurses wurde auch diese Kategorie gelöscht, denn die Fragen wurden nirgendwo mehr eingesetzt.';
$string['updatesettings'] = 'Testeinstellungen aktualisieren';
$string['upgradesure'] = '<div>Das Testmodul nimmt eine Reihe von weitreichenden Veränderungen an den Datenbanktabellen vor. Diese Upgrade-Funktion wurde noch nicht sehr umfassend getestet. Sie sollten daher unbedingt ein Backup Ihrer Datenbanktabellen vornehmen, bevor Sie fortfahren.</div>';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Die Kategorie wurde nach dem Löschen des Kurses verschoben, weil die Fragen noch in anderen Kursen genutzt werden.';
$string['useroverrides'] = 'Nutzeränderungen';
$string['usersnone'] = 'Teilnehmer/innen haben keinen Zugriff auf diesen Test.';
$string['validate'] = 'Gültig';
$string['viewallanswers'] = 'Zeige {$a} ausgefüllte Tests';
$string['viewallreports'] = 'Berichte ansehen für {$a} Versuche';
$string['warningmissingtype'] = '<p><b>Diese Frage ist von einem Typ, der bisher noch nicht in Ihrem Moodle installiert wurde.<br />Bitte fragen Sie Ihren Moodle-Admin.';
$string['warningsdetected'] = '{$a} Warnung(en) entdeckt';
$string['webct'] = 'WebCT';
$string['wheregrade'] = 'Wo ist meine Bewertung?';
$string['wildcard'] = 'Wildcard';
$string['windowclosing'] = 'Das Fenster wird in Kürze geschlossen.';
$string['withselected'] = 'Ausgewählt';
$string['withsummary'] = 'mit zusammenfassender Statistik';
$string['wronggrade'] = 'Falsche Bewertung (nach Zeile {$a}):';
$string['wronguse'] = 'Sie können diese Seite nicht auf diese Art verwenden.';
$string['xhtml'] = 'XHTML Format';
$string['xml'] = 'Moodle-XML Format';
$string['xmlimportnoname'] = 'Fehlender Fragenname in der XML-Datei';
$string['xmlimportnoquestion'] = 'Fehlender Fragetext in der XML-Datei';
$string['xmltypeunsupported'] = 'Der Fragetyp {$a} wird vom XML-Import nicht unterstützt.';
$string['youcannotwait'] = 'Dieser Test wird beendet, bevor Ihnen der Start eines weiteren Versuchs erlaubt wird.';
$string['youmustwait'] = 'Sie müssen abwarten, bevor Sie eine Wiederholung für diesen Test versuchen dürfen. Sie dürfen einen weiteren Versuch nach {$a} beginnen.';
$string['youneedtoenrol'] = 'Sie können den Test nur durchführen, wenn Sie in diesem Kurs als Teilnehmer/in eingetragen sind.';
$string['yourfinalgradeis'] = 'Ihre Gesamtbewertung für diesen Test: {$a}';
$string['zerosignificantfiguresnotallowed'] = 'Die richtige Antwort muss mindestens eine signifikante Ziffer haben!';
