<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'de', branch 'MOODLE_20_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'wird installiert';
$string['action'] = 'Aktion';
$string['actions'] = 'Aktionen';
$string['active'] = 'Aktiv';
$string['activeusers'] = 'Aktive Nutzer/innen';
$string['activities'] = 'Aktivitäten';
$string['activities_help'] = 'Aktivitäten wie z.B. Foren, Tests und Wikis enthalten interaktiven Inhalt, der in den Kurs eingefügt wird.';
$string['activity'] = 'Aktivität';
$string['activityclipboard'] = 'Diese Aktivität verschieben: <b>{$a}</b>';
$string['activityiscurrentlyhidden'] = 'Diese Aktivität ist aktuell verborgen';
$string['activitymodule'] = 'Aktivitäten';
$string['activitymodules'] = 'Aktivitäten';
$string['activityreport'] = 'Aktivitäten';
$string['activityreports'] = 'Aktivitäten';
$string['activityselect'] = 'Wählen Sie eine Aktivität aus, um sie zu verschieben';
$string['activitysince'] = 'Aktivität seit {$a}';
$string['activityweighted'] = 'Aktivitäten pro Nutzer/in';
$string['add'] = 'Hinzufügen';
$string['addactivity'] = 'Aktivität anlegen...';
$string['addadmin'] = 'Administrator/in hinzufügen';
$string['addblock'] = 'Block hinzufügen';
$string['addcomment'] = 'Kommentar hinzufügen...';
$string['addcountertousername'] = 'Anmeldenamen durch Anhängen einer Zahl erzeugen';
$string['addcreator'] = 'Kursersteller/in hinzufügen';
$string['adddots'] = 'Hinzufügen...';
$string['added'] = '{$a} hinzugefügt';
$string['addedrecip'] = '{$a} neuer Empfänger hinzugefügt';
$string['addedrecips'] = '{$a} neue Empfänger hinzugefügt';
$string['addedtogroup'] = 'Zur Gruppe {$a} hinzugefügt';
$string['addedtogroupnot'] = 'Nicht zur Gruppe {$a} hinzugefügt';
$string['addedtogroupnotenrolled'] = 'Nicht zur Gruppe {$a} hinzugefügt, da nicht im Kurs eingeschrieben';
$string['addinganew'] = '{$a} hinzufügen';
$string['addinganewto'] = '{$a->what} zu {$a->to} hinzufügen';
$string['addingdatatoexisting'] = 'Daten zu bestehenden hinzufügen';
$string['addnewcategory'] = 'Kursbereich anlegen';
$string['addnewcourse'] = 'Neuen Kurs anlegen';
$string['addnewuser'] = 'Nutzer/in anlegen';
$string['addnousersrecip'] = 'Nutzer/innen hinzufügen, die sich nicht in die Liste \'{$a}\' eingetragen haben';
$string['addresource'] = 'Arbeitsmaterial anlegen...';
$string['address'] = 'Adresse';
$string['addstudent'] = 'Teilnehmer/in hinzufügen';
$string['addsubcategory'] = 'Kursunterbereich anlegen';
$string['addteacher'] = 'Trainer/in anlegen';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Neues Nutzerkonto manuell anlegen';
$string['adminhelpassignadmins'] = 'Administrator/innen haben vollen Zugriff auf die gesamte Website';
$string['adminhelpassigncreators'] = 'Kursersteller/innen dürfen neue Kurse anlegen';
$string['adminhelpassignsiteroles'] = 'Definierte Rollen der Website auf ausgewählte Nutzer/innen anwenden';
$string['adminhelpassignstudents'] = 'Gehen Sie in einen Kurs und fügen Sie die Teilnehmer/innen über den Administrationsblock hinzu.';
$string['adminhelpauthentication'] = 'Sie können die interne Nutzerkonten oder externe Datenbanken verwenden';
$string['adminhelpbackup'] = 'Datensicherung konfigurieren';
$string['adminhelpconfiguration'] = 'Aussehen und Aufbau der Website konfigurieren';
$string['adminhelpconfigvariables'] = 'Allgemeine Einstellungen der Website konfigurieren';
$string['adminhelpcourses'] = 'Kurse und Kursbereiche verwalten, Personen zuweisen und Kursanträge bearbeiten';
$string['adminhelpeditorsettings'] = 'Grundeinstellungen für den Editor festlegen';
$string['adminhelpedituser'] = 'Nutzerliste durchsuchen und Nutzerprofile bearbeiten';
$string['adminhelpenvironment'] = 'Prüfung, welche der aktuellen und zukünftigen Anforderungen vom Server erfüllt werden';
$string['adminhelpfailurelogs'] = 'Protokoll der fehlgeschlagenen Anmeldeversuche anzeigen';
$string['adminhelphealthcenter'] = 'Website-Probleme automatisch erkennen';
$string['adminhelplanguage'] = 'Aktuelles Sprachpaket überprüfen und bearbeiten';
$string['adminhelplogs'] = 'Logdaten aller Aktivitäten auf der Website anzeigen';
$string['adminhelpmanageblocks'] = 'Installierte Blöcke und deren Einstellungen verwalten';
$string['adminhelpmanagedatabase'] = 'Direkt auf die Datenbank zugreifen (Vorsicht!)';
$string['adminhelpmanagefilters'] = 'Textfilter und deren Einstellungen verwalten';
$string['adminhelpmanagemodules'] = 'Installierte Aktivitätsmodule und deren Einstellungen verwalten';
$string['adminhelpmanageroles'] = 'Rollen definieren, die an Nutzer/innen zugewiesen werden können';
$string['adminhelpmymoodle'] = 'Blöcke für \'Meine Startseite\' der Nutzer/innen konfigurieren';
$string['adminhelpreports'] = 'Logdaten der Website anzeigen';
$string['adminhelpsitefiles'] = 'Dateien veröffentlichen oder externe Datensicherungen hochladen';
$string['adminhelpsitesettings'] = 'Aufbau der Startseite festlegen';
$string['adminhelpstickyblocks'] = 'Feste Blöcke für die Website konfigurieren';
$string['adminhelpthemes'] = 'Design (Farben, Schriften usw.) für die Website auswählen';
$string['adminhelpuploadusers'] = 'Neue Nutzer/innen aus einer Textdatei importieren';
$string['adminhelpusers'] = 'Nutzer/innen anlegen und Authentifizierung konfigurieren';
$string['adminhelpxmldbeditor'] = 'Interface zur Bearbeitung von XMLDB-Dateien (nur für Entwickler/innen)';
$string['administration'] = 'Administration';
$string['administrationsite'] = 'Website-Administration';
$string['administrator'] = 'Administrator/in';
$string['administratordescription'] = 'Administrator/innen haben alle Rechte für die Website und in allen Kursen.';
$string['administrators'] = 'Administrator/innen';
$string['administratorsall'] = 'Alle Administrator/innen';
$string['administratorsandteachers'] = 'Administrator/innen und Trainer/innen';
$string['advanced'] = 'Optional';
$string['advancedfilter'] = 'Erweiterte Suche';
$string['advancedsettings'] = 'Erweiterte Einstellungen';
$string['again'] = 'noch einmal';
$string['aimid'] = 'AIM';
$string['ajaxno'] = 'Nein, nur Standardmöglichkeiten nutzen';
$string['ajaxuse'] = 'JavaScript / Ajax';
$string['ajaxyes'] = 'Ja, erweiterte Möglichkeiten nutzen';
$string['all'] = 'Alle';
$string['allactions'] = 'Alle Aktionen';
$string['allactivities'] = 'Alle Aktivitäten';
$string['allchanges'] = 'Alle Änderungen';
$string['alldays'] = 'Alle Tage';
$string['allfieldsrequired'] = 'Alle Felder sind erforderlich';
$string['allfiles'] = 'Alle Dateien';
$string['allgroups'] = 'Alle Gruppen';
$string['alllogs'] = 'Alle Logdaten';
$string['allmods'] = 'Alle {$a}';
$string['allow'] = 'Zulassen';
$string['allowinternal'] = 'Auch interne Verfahren zulassen';
$string['allownone'] = 'Nichts zulassen';
$string['allownot'] = 'Nicht zulassen';
$string['allparticipants'] = 'Alle Teilnehmer/innen';
$string['allteachers'] = 'Alle Trainer/innen';
$string['alphanumerical'] = 'Darf nur Buchstaben, Zahlen, Bindestrich (-) oder Punkt (.) enthalten';
$string['alreadyconfirmed'] = 'Die Registrierung wurde bereits bestätigt';
$string['always'] = 'Immer';
$string['and'] = '{$a->one} und {$a->two}';
$string['answer'] = 'Antwort';
$string['any'] = 'Beliebig';
$string['approve'] = 'Bestätigen';
$string['areyousuretorestorethis'] = 'Wollen Sie fortsetzen?';
$string['areyousuretorestorethisinfo'] = 'Sie haben später die Möglichkeit, die Sicherung einem bestehenden Kurs hinzuzufügen oder als neuen Kurs anzulegen.';
$string['asc'] = 'Aufsteigend';
$string['assessment'] = 'Beurteilung';
$string['assignadmins'] = 'Administrator/innen zuweisen';
$string['assigncreators'] = 'Kursersteller/innen zuweisen';
$string['assignsiteroles'] = 'Rollen für die gesamte Website zuweisen';
$string['authenticateduser'] = 'Authentifizierte/r Nutzer/in';
$string['authenticateduserdescription'] = 'Alle eingeloggten Nutzer/innen';
$string['authentication'] = 'Authentifizierung';
$string['authenticationplugins'] = 'Plugins zur Authentifizierung';
$string['autosubscribe'] = 'Forum abonnieren';
$string['autosubscribeno'] = 'Nein, Foren nicht automatisch abonnieren';
$string['autosubscribeyes'] = 'Ja, Forum abonnieren, in dem ich einen Beitrag schreibe';
$string['availability'] = 'Verfügbarkeit';
$string['availability_help'] = 'Diese Option legt fest, ob der Kurs in der Kursliste verfügbar ist. Außer Trainer/innen und Admistrator/innen kann niemand den Kurs betreten.';
$string['availablecourses'] = 'Laufende Kurse';
$string['back'] = 'Zurück';
$string['backto'] = 'Zurück zu {$a}';
$string['backtocourselisting'] = 'Zurück zur Kursliste';
$string['backtopageyouwereon'] = 'Zurück zur vorherigen Seite';
$string['backtoparticipants'] = 'Zurück zur Nutzerliste';
$string['backup'] = 'Sicherung';
$string['backupactivehelp'] = 'Wählen Sie, ob automatische Sicherungen durchgeführt werden sollen oder nicht.';
$string['backupcancelled'] = 'Sicherung abgebrochen';
$string['backupcoursefileshelp'] = 'Wenn Sie diese Option aktivieren, werden die Kursdateien in die automatische Sicherung einbezogen.';
$string['backupdate'] = 'Sicherungsdatum';
$string['backupdatenew'] = '&nbsp; {$a->TAG} ist jetzt {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} war {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Sicherungsdetails';
$string['backupexecuteathelp'] = 'Wählen Sie, zu welcher Zeit die automatischen Sicherungen starten sollen.';
$string['backupfailed'] = 'Mehrere Kurse wurden nicht gesichert!!';
$string['backupfilename'] = 'Sicherung';
$string['backupfinished'] = 'Sicherung erfolgreich abgeschlossen';
$string['backupfromthissite'] = 'Wurde eine Sicherung der Website durchgeführt?';
$string['backupgradebookhistoryhelp'] = 'Wenn diese Option aktiviert ist, wird der Bewertungsverlauf in die automatische Kurssicherung einbezogen. Der Bewertungsverlauf darf dafür in den Servereinstellungen nicht deaktiviert sein (disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Wählen Sie, ob die Kursaktivitäten mit oder ohne Nutzerdaten in die automatische Sicherung einbezogen werden sollen';
$string['backupincludemoduleuserdatahelp'] = 'Wählen Sie, ob Sie Kursmodule ohne Nutzerdaten in die automatischen Sicherungen einbeziehen möchten.';
$string['backupkeephelp'] = 'Wie viele Sicherungen wollen Sie von jedem Kurs aufbewahren (ältere Sicherungen werden automatisch gelöscht)?';
$string['backuplogdetailed'] = 'Ausführliches Sicherungsprotokoll';
$string['backuploglaststatus'] = 'Letztes Sicherungsprotokoll';
$string['backupmissinguserinfoperms'] = 'Hinweis: Diese Kurssicherung enthält keine Nutzerdaten. Die Aktivitäten \'Übung\' und \'Workshop\' werden nicht gesichert, weil diese Module nicht kompatibel mit dem Sicherungstyp sind.';
$string['backupnext'] = 'Nächste Sicherung';
$string['backupnonisowarning'] = 'Warnung: Diese Sicherung ist mit einer Nicht-Unicode-Version von Moodle (älter als 1.6) erstellt worden. Falls diese Sicherung Nicht-ISO-8859-1-Texte enthält, können diese Texte bei der Wiederherstellung in dieser Unicode-Version von Moodle zerstört werden. Siehe <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> für weitere Informationen, wie die Sicherung in diesem Fall korrekt wiederhergestellt werden kann.';
$string['backuporiginalname'] = 'Name der Sicherung';
$string['backuproleassignments'] = 'Sicherung der Zuordnungen für diese Rollen';
$string['backupsavetohelp'] = 'Vollständiger Verzeichnispfad, in dem die Sicherungsdateien abgelegt werden sollen <br />(leer lassen, um im Verzeichnis \'backup\' des jeweiligen Kurses zu speichern)';
$string['backupsitefileshelp'] = 'Wenn diese Option aktiviert ist, werden die in Kursen benutzten Dateien der Website in die automatischen Sicherungen einbezogen.';
$string['backuptakealook'] = 'Bitte schauen Sie in das Sicherungsprotokoll: {$a}';
$string['backupuserfileshelp'] = 'Wählen Sie, ob die Nutzerdateien (z.B. Bilder in den Nutzerprofilen) in die automatischen Sicherungen einbezogen werden sollen';
$string['backupversion'] = 'Sicherungsversion';
$string['block'] = 'Block';
$string['blockconfiga'] = 'Block \'{$a}\' konfigurieren';
$string['blockconfigbad'] = 'Dieser Block wurde nicht richtig implementiert, so dass die Konfigurationsseite nicht angezeigt werden kann';
$string['blockdeleteconfirm'] = 'Sie wollen den Block \'{$a}\' vollständig löschen. Damit löschen Sie alle Datenbankeinträge, die mit diesem Block in Verbindung stehen. Wollen Sie diesen Vorgang wirklich fortsetzen?';
$string['blockdeletefiles'] = 'Alle Daten, die mit dem Block \'{$a->block}\' in Verbindung stehen, wurden in der Datenbank gelöscht. Um den Vorgang abzuschließen und sicherzustellen, dass keine Neuinstallation des Blocks erfolgt, sollten Sie das Verzeichnis {$a->directory} auf dem Server löschen.';
$string['blocks'] = 'Blöcke';
$string['blocksaddedit'] = 'Blöcke hinzufügen/bearbeiten';
$string['blockseditoff'] = 'Blockbearbeitung ausschalten';
$string['blocksediton'] = 'Blockbearbeitung einschalten';
$string['blocksetup'] = 'Blocktabellen werden angelegt';
$string['blocksuccess'] = '{$a} Tabellen wurden angelegt';
$string['brief'] = 'Weniger Details';
$string['bycourseorder'] = 'Sortiert nach Kursen';
$string['byname'] = 'von {$a}';
$string['bypassed'] = 'Unberücksichtigt';
$string['cachecontrols'] = 'Cache-Kontrolle';
$string['cancel'] = 'Abbrechen';
$string['cancelled'] = 'Abgebrochen';
$string['categories'] = 'Kursbereiche';
$string['category'] = 'Kursbereich';
$string['categoryadded'] = 'Der Kursbereich \'{$a}\' wurde angelegt';
$string['categorycontents'] = 'Kursunterbereiche und Kurse';
$string['categorycurrentcontents'] = 'Inhalt von {$a}';
$string['categorydeleted'] = 'Der Kursbereich \'{$a}\' wurde gelöscht';
$string['categoryduplicate'] = 'Der Kursbereich \'{$a}\' existiert bereits!';
$string['category_help'] = 'Diese Option legt fest, in welchem Kursbereich der Kurs abgelegt wird.';
$string['categorymodifiedcancel'] = 'Der Kursbereich wurde verändert! Bitte brechen Sie ab und versuchen Sie es noch einmal.';
$string['categoryname'] = 'Name des Kursbereichs';
$string['categoryupdated'] = 'Der Kursbereich \'{$a}\' wurde aktualisiert';
$string['changedpassword'] = 'Kennwort geändert';
$string['changepassword'] = 'Kennwort ändern';
$string['changessaved'] = 'Änderungen gespeichert';
$string['check'] = 'Prüfen';
$string['checkall'] = 'Alles prüfen';
$string['checkingbackup'] = 'Sicherung prüfen';
$string['checkingcourse'] = 'Kurs prüfen';
$string['checkingforbbexport'] = 'Blackboard-Export prüfen';
$string['checkinginstances'] = 'Instanzen prüfen';
$string['checkingsections'] = 'Abschnitte prüfen';
$string['checklanguage'] = 'Sprache prüfen';
$string['checknone'] = 'Nichts prüfen';
$string['childcoursenotfound'] = 'Kurszuordnung nicht gefunden';
$string['childcourses'] = 'Kurszuordnung';
$string['choose'] = 'Auswahl';
$string['choosecourse'] = 'Wählen Sie einen Kurs';
$string['choosedots'] = 'Auswählen...';
$string['chooselivelogs'] = 'Aktuelle Aktivitäten anzeigen';
$string['chooselogs'] = 'Anzuzeigende Logdaten auswählen';
$string['choosereportfilter'] = 'Filter für den Bericht auswählen';
$string['choosetheme'] = 'Design auswählen';
$string['chooseuser'] = 'Nutzer/in auswählen';
$string['city'] = 'Stadt/Ort';
$string['clambroken'] = 'Die Virenprüfung für hochgeladene Dateien wurde aktiviert. In der Konfiguration der Virenprüfung ist jedoch ein Fehler aufgetreten. <br/>Ihre Datei konnte nicht hochgeladen werden. Die Administrator/innen wurden per E-Mail benachrichtigt. <br/>Bitte versuchen Sie später noch einmal, die Datei hochzuladen.';
$string['clamdeletedfile'] = 'Die Datei wurde gelöscht';
$string['clamdeletedfilefailed'] = 'Die Datei konnte nicht gelöscht werden';
$string['clamemailsubject'] = '{$a} :: ClamAV Mitteilung';
$string['clamfailed'] = 'ClamAV wurde nicht vollständig ausgeführt. Die Fehlermeldung lautet: {$a}.';
$string['clamlost'] = 'Moodle verwendet ClamAV zur Virenprüfung für hochgeladene Dateien, aber der Pfad für ClamAV {$a} ist ungültig.';
$string['clamlostandactinglikevirus'] = 'Moodle wurde konfiguriert, dass Dateien nach dem Hochladen als virenverdächtig eingestuft werden, sobald Probleme bei der Ausführung von ClamAV auftreten. Weitere Dateien können nicht hochgeladen werden, solange der Fehler nicht behoben ist.';
$string['clammovedfile'] = 'Die Datei wurde ins Quarantäne-Verzeichnis verschoben. Die neue Link lautet {$a}';
$string['clammovedfilebasic'] = 'Die Datei wurde ins Quarantäne-Verzeichnis verschoben.';
$string['clamquarantinedirfailed'] = 'Die Datei konnte nicht ins Quarantäne-Verzeichnis {$a} verschoben werden. Sie müssen den Fehler beheben, denn  bis auf weiteres werden alle Dateien gelöscht, die als virenverdächtig eingestuft werden.';
$string['clamunknownerror'] = 'Ein unbekannter Fehler ist bei ClamAV aufgetreten.';
$string['cleaningtempdata'] = 'Temporäre Dateien löschen';
$string['clear'] = 'Löschen';
$string['clickhelpiconformoreinfo'] = '... zum Weiterlesen auf das Hilfe-Icon klicken';
$string['clickhere'] = 'Hier klicken...';
$string['clicktochange'] = 'Zum Ändern klicken';
$string['clicktohideshow'] = 'Zum Erweitern oder Zusammenfassen klicken';
$string['closewindow'] = 'Fenster schließen';
$string['collapseall'] = 'Alles schließen';
$string['commentincontext'] = 'Kommentar im Zusammenhang suchen';
$string['comments'] = 'Kommentare';
$string['commentsnotenabled'] = 'Kommentare sind nicht aktiviert';
$string['commentsrequirelogin'] = 'Sie müssen angemeldet sein, um die Kommentare zu sehen';
$string['comparelanguage'] = 'Aktuelles Sprachpaket prüfen und bearbeiten';
$string['complete'] = 'Fertig';
$string['completereport'] = 'Vollständiger Bericht';
$string['configuration'] = 'Konfiguration';
$string['confirm'] = 'Bestätigen';
$string['confirmcheckfull'] = 'Sind Sie sicher, dass Sie {$a} bestätigen möchten?';
$string['confirmed'] = 'Ihre Registrierung wurde bestätigt.';
$string['confirmednot'] = 'Ihre Registrierung wurde noch nicht bestätigt!';
$string['content'] = 'Inhalt';
$string['continue'] = 'Weiter';
$string['continuetocourse'] = 'Klicken Sie hier, um in den Kurs zu gelangen';
$string['convertingwikitomarkdown'] = 'Wiki wird als Markdown konvertiert';
$string['cookiesenabled'] = 'Cookies müssen aktiviert sein!';
$string['cookiesenabled_help'] = '<h2>Cookies</h2>

<p>Diese Moodle-Website benutzt zwei Cookies:</p>

<h3>MoodleSession</h3>
<p>Das wichtigste Cookie heißt <b>MoodleSession</b>. Sie müssen dieses Cookie erlauben, damit Ihr Login bei Ihren Moodle-Zugriffen von Seite zu Seite erhalten bleibt. Nach dem Ausloggen oder dem Schließen Ihres Webbrowsers wird das Cookie gelöscht.</p>

<h3>MoodleID</h3>
<p>Das andere Cookie dient Ihrer Bequemlichkeit. Es speichert den Anmeldenamen im Webbrowser und heißt standardmäßig <b>MoodleID</b>. Dieses Cookie bleibt auch nach dem Ausloggen aus Moodle erhalten. Beim nächsten Login ist dann Ihr Anmeldename bereits eingetragen. Dieses Cookie brauchen Sie nicht zu erlauben, Sie müssen dann allerdings bei jedem Login Ihren Anmeldenamen wieder neu eingeben.</p>';
$string['cookiesnotenabled'] = 'Leider sind Cookies im Browser deaktiviert';
$string['copy'] = 'Kopieren';
$string['copyasnoun'] = 'Kopie';
$string['copyingcoursefiles'] = 'Kursdateien kopieren';
$string['copyingsitefiles'] = 'Im Kurs benutzte Dateien der Website werden kopiert';
$string['copyinguserfiles'] = 'Nutzerdateien kopieren';
$string['copyingzipfile'] = 'ZIP-Datei kopieren';
$string['copyrightnotice'] = 'Urheberrechtshinweis';
$string['coresystem'] = 'Kernsystem';
$string['cost'] = 'Entgelt';
$string['costdefault'] = 'Entgeltvoreinstellung';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Land';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Kurs-Administration';
$string['courseapprovedemail'] = 'Der von Ihnen beantragte Kurs \'{$a->name}\' wurde angelegt und Sie haben Zugriff als {$a->teacher}. Zum neuen Kurs gelangen Sie über {$a->url}.';
$string['courseapprovedemail2'] = 'Der von Ihnen beantragte Kurs \'{$a->name}\' wurde angelegt. Zum neuen Kurs gelangen Sie über {$a->url}.';
$string['courseapprovedfailed'] = 'Das Anlegen des beantragten Kurses ist fehlgeschlagen!';
$string['courseapprovedsubject'] = 'Der von Ihnen beantragte Kurs wurde angelegt.';
$string['courseavailable'] = 'Für Teilnehmer/innen verfügbar';
$string['courseavailablenot'] = 'Für Teilnehmer/innen nicht verfügbar';
$string['coursebackup'] = 'Kurssicherung';
$string['coursecategories'] = 'Kursbereiche';
$string['coursecategory'] = 'Kursbereich';
$string['coursecategorydeleted'] = 'Gelöschter Kursbereich {$a}';
$string['coursecompletion'] = 'Kursabschluss';
$string['coursecompletions'] = 'Kursabschlüsse';
$string['coursecreators'] = 'Kursersteller/in';
$string['coursecreatorsdescription'] = 'Kursersteller/innen dürfen neue Kurse anlegen';
$string['coursedeleted'] = 'Gelöschter Kurs {$a}';
$string['coursefiles'] = 'Alte Kursdateien';
$string['coursefilesedit'] = 'Ältere Kursdateien bearbeiten';
$string['coursefileswarning'] = 'Kursdateien werden nicht mehr genutzt.';
$string['coursefileswarning_help'] = 'Kursdateien werden ab Moodle 2.0 nicht mehr genutzt. Stattdessen könnten externe  Dateiverwaltungsfunktionen verwendet werden.';
$string['courseformatdata'] = 'Kursformatdaten';
$string['courseformats'] = 'Kursformate';
$string['coursegrades'] = 'Kursbewertung';
$string['coursehelpcategory'] = 'Kurse in der Kursliste positionieren und den Teilnehmer/innen das Auffinden erleichtern';
$string['coursehelpforce'] = 'Den Gruppenmodus für alle Aktivitäten des Kurses festlegen';
$string['coursehelpformat'] = 'Die Hauptseite des Kurses wird in diesem Format angezeigt';
$string['coursehelphiddensections'] = 'Mit dem Augensymbol verborgene Abschnitte können für Teilnehmer angedeutet oder ganz ausgeblendet werden.';
$string['coursehelpmaximumupload'] = 'Diese Option legt die maximale Dateigröße fest, die in diesem Kurs hochgeladen werden darf, beschränkt durch die globalen Einstellungen der Website.';
$string['coursehelpnewsitemsnumber'] = 'Anzahl der in eine Nachrichtenblock auf der Kursseite gezeigten Einträge<br />(0 bedeutet, dass der Nachrichtenblock nicht angezeigt wird)';
$string['coursehelpnumberweeks'] = 'Anzahl der Wochen bzw. Themen, die auf der Hauptseite des Kurses angezeigt werden';
$string['coursehelpshowgrades'] = 'Die Anzeige der Bewertungen erlauben. Diese Einstellung verhindert nicht, dass Bewertungen während der Ausführung von Aktivitäten angezeigt werden.';
$string['coursehidden'] = 'Der Kurs steht aktuell für Teilnehmer/innen nicht zur Verfügung.';
$string['courseinfo'] = 'Kursinformation';
$string['courselegacyfiles'] = 'Alte Kursdateien';
$string['courselegacyfiles_help'] = 'Der Bereich Kursdateien liefert eine gewisse Abwärtskompatibilität zu Moodle 1.9 (und älter). Alle Dateien in diesem Bereich sind für alle Teilnehmer/innen im Kurs verfügbar, egal ob sie verlinkt sind oder nicht. Es gibt keinen Weg um herauszufinden, ob die Dateien in diesem Verzeichnis überhaupt in Moodle benutzt werden.

Wenn Sie in diesen Bereich eine Datei speichern, könnten Sie ungewollt Datenschutz- oder Sicherheitsprobleme aufwerfen. Außerdem könnten Dateien bei Sicherungen, Kursimporten oder bei der Freigabe bzw. Wiederbenutzung fehlen. Sie sollten diesen Bereich nur nutzen, wenn Sie wirklich wissen, was Sie tun.

Der folgende Link liefert Ihnen weitere Informationen und Möglichkeiten, um Dateien in Moodle 2.x zu verwalten.';
$string['coursemessage'] = 'Mitteilung an Kursteilnehmer/innen';
$string['coursenotaccessible'] = 'Dieser Kurs ist nicht öffentlich zugänglich';
$string['courseoverview'] = 'Kursübersicht';
$string['courseoverviewgraph'] = 'Kursübersichtsgrafik';
$string['courseprofiles'] = 'Kursprofile';
$string['coursereasonforrejecting'] = 'Begründung für die Ablehnung des Kursantrages';
$string['coursereasonforrejectingemail'] = 'Diese Mitteilung wird per E-Mail an die beantragende Person geschickt';
$string['coursereject'] = 'Kursantrag ablehnen';
$string['courserejected'] = 'Der Kursantrag wurde abgelehnt. Eine Mitteilung wurde übermittelt.';
$string['courserejectemail'] = 'Ihr Kursantrag wurde abgelehnt. Hier folgt die Begründung:

{$a}';
$string['courserejectreason'] = 'Stellen Sie die Gründe für die Ablehnung des Kursantrags kurz dar. <br /> Ihre Erklärung wird per E-Mail versandt.';
$string['courserejectsubject'] = 'Ihr Kursantrag wurde abgelehnt.';
$string['coursereport'] = 'Kursbericht';
$string['coursereports'] = 'Kursberichte';
$string['courserequest'] = 'Beantragung';
$string['courserequestdetails'] = 'Details zum beantragten Kurs';
$string['courserequestfailed'] = 'Ihr Kursantrag konnte nicht gespeichert werden';
$string['courserequestintro'] = 'Mit diesem Formular können Sie die Einrichtung eines neuen Kurses beantragen.<br />Tragen Sie alle Informationen ein, damit die Administrator/innen Ihren Wunsch nachvollziehen und Ihren Antrag bearbeiten können.';
$string['courserequestreason'] = 'Begründung des Kursantrags';
$string['courserequestsuccess'] = 'Ihr Kursantrag wurde erfolgreich gespeichert. In Kürze erhalten Sie per E-Mail eine Mitteilung mit einer Entscheidung.';
$string['courserequestsupport'] = 'Informationen für den Administrator, um diese Kursanfrage zu prüfen';
$string['courserestore'] = 'Kurswiederherstellung';
$string['courses'] = 'Kurse';
$string['coursesectionsummaries'] = 'Beschreibungen zu Kursabschnitten';
$string['coursesettings'] = 'Grundeinstellungen';
$string['coursesmovedout'] = 'Kurse aus {$a} hinaus bewegt';
$string['coursespending'] = 'Kursanträge bearbeiten';
$string['coursestart'] = 'Kursbeginn';
$string['coursesummary'] = 'Kursbeschreibung';
$string['coursesummary_help'] = 'Die Kursbeschreibung wird in der Kursübersicht angezeigt. Bei einer Kurssuche werden die Kursbeschreibungen zusätzlich zu den Kursnamen berücksichtigt.';
$string['courseupdates'] = 'Neues im Kurs';
$string['courseuploadlimit'] = 'Maximale Dateigröße';
$string['create'] = 'Erstellen';
$string['createaccount'] = 'Zugang anlegen (Registrierung)';
$string['createcategory'] = 'Kursbereich erstellen';
$string['createfolder'] = 'Verzeichnis in {$a} erstellen';
$string['createuserandpass'] = 'Wählen Sie Ihren Anmeldenamen und Ihr Kennwort';
$string['createziparchive'] = 'ZIP-Archiv erstellen';
$string['creatingblocks'] = 'Blöcke werden erstellt';
$string['creatingblocksroles'] = 'Rollenzuweisungen und -änderungen auf Blockebene werden erstellt';
$string['creatingblogsinfo'] = 'Bloginformationen werden erstellt';
$string['creatingcategoriesandquestions'] = 'Kategorien und Fragen werden erstellt';
$string['creatingcoursemodules'] = 'Kursaktivitäten werden erstellt';
$string['creatingcourseroles'] = 'Rollenzuweisungen und -änderungen auf Kursebene werden erstellt';
$string['creatingevents'] = 'Termine werden erstellt';
$string['creatinggradebook'] = 'Bewertungen werden erstellt';
$string['creatinggroupings'] = 'Gruppierungen werden erstellt';
$string['creatinggroupingsgroups'] = 'Gruppen werden in die Gruppierungen eingefügt';
$string['creatinggroups'] = 'Gruppen werden erstellt';
$string['creatinglogentries'] = 'Logdaten werden erstellt';
$string['creatingmessagesinfo'] = 'Informationen über Mitteilungen werden erstellt';
$string['creatingmodroles'] = 'Rollenzuweisungen und -änderungen werden auf Modulebene erstellt';
$string['creatingnewcourse'] = 'Neuer Kurs wird erstellt';
$string['creatingrolesdefinitions'] = 'Rollendefinitionen werden erstellt';
$string['creatingscales'] = 'Bewertungsskalen werden erstellt';
$string['creatingsections'] = 'Abschnitte werden erstellt';
$string['creatingtemporarystructures'] = 'Temporäre Strukturen werden erstellt';
$string['creatinguserroles'] = 'Rollenzuweisungen und -änderungen werden auf Nutzerebene erstellt';
$string['creatingusers'] = 'Nutzer/innen werden erstellt';
$string['creatingxmlfile'] = 'XML-Datei wird erstellt';
$string['currency'] = 'Währung';
$string['currentcourseadding'] = 'Aktueller Kurs - Inhalte hinzufügen';
$string['currentcoursedeleting'] = 'Aktueller Kurs - Inhalte vorher löschen';
$string['currentlanguage'] = 'Eingestellte Sprache';
$string['currentlocaltime'] = 'Aktuelle Ortszeit';
$string['currentlyselectedusers'] = 'Aktuell ausgewählte Nutzer/innen';
$string['currentpicture'] = 'Aktuelles Bild';
$string['currentrelease'] = 'Aktuelle Versionsinformationen';
$string['currentversion'] = 'Aktuelle Version';
$string['databasechecking'] = 'Die Moodle-Datenbank wird von Version {$a->oldversion} auf {$a->newversion} aktualisiert';
$string['databaseperformance'] = 'Datenbankleistung';
$string['databasesetup'] = 'Datenbank wird eingerichtet';
$string['databasesuccess'] = 'Datenbank wurde erfolgreich aktualisiert';
$string['databaseupgradebackups'] = 'Sicherungsversion ist jetzt {$a}';
$string['databaseupgradeblocks'] = 'Blockversion ist jetzt {$a}';
$string['databaseupgradegroups'] = 'Gruppenversion ist jetzt {$a}';
$string['databaseupgradelocal'] = 'Version der lokalen Datenbank ist jetzt {$a}';
$string['databaseupgrades'] = 'Datenbank wird aktualisiert';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum geändert';
$string['datemostrecentfirst'] = 'Datum - neuestes zuerst';
$string['datemostrecentlast'] = 'Datum - ältestes zuerst';
$string['day'] = 'Tag';
$string['days'] = 'Tage';
$string['decodinginternallinks'] = 'Interne Links werden dekodiert';
$string['default'] = 'Grundeinstellung';
$string['defaultcoursestudent'] = 'Teilnehmer/in';
$string['defaultcoursestudentdescription'] = 'Teilnehmer/innen haben in einem Kurs grundsätzlich weniger Rechte.';
$string['defaultcoursestudents'] = 'Teilnehmer/innen';
$string['defaultcoursesummary'] = 'Beschreiben Sie kurz, worum es in diesem Kurs geht.';
$string['defaultcourseteacher'] = 'Trainer/in';
$string['defaultcourseteacherdescription'] = 'Moderator/innen dürfen in einem Kurs alles tun, auch Aktivitäten bearbeiten und Teilnehmer/innen beurteilen';
$string['defaultcourseteachers'] = 'Trainer/innen';
$string['delete'] = 'Löschen';
$string['deleteablock'] = 'Block löschen';
$string['deleteall'] = 'Alles löschen';
$string['deleteallcannotundo'] = 'Alles löschen - Wiederherstellung ist nicht möglich';
$string['deleteallcomments'] = 'Alle Kommentare löschen';
$string['deleteallratings'] = 'Alle Bewertungen löschen';
$string['deletecategory'] = 'Kursbereich {$a} löschen';
$string['deletecategorycheck'] = 'Sind Sie wirklich sicher, dass Sie diesen Kursbereich <b>\'{$a}\'</b> vollständig löschen wollen?<br />Alle Kurse werden in den übergeordneten Kursbereich (falls vorhanden) oder in den Kursbereich \'Verschiedenes\' verschoben.';
$string['deletecategorycheck2'] = 'Wenn Sie diesen Kursbereich gelöschen, müssen Sie entscheiden, was mit den darin enthaltenen Kursen und Unterbereichen passieren soll.';
$string['deletecategoryempty'] = 'Dieser Kursbereich ist leer.';
$string['deletecheck'] = '{$a} löschen?';
$string['deletecheckfiles'] = 'Sind Sie wirklich sicher, dass Sie diese Dateien löschen möchten?';
$string['deletecheckfull'] = '{$a} wird nun gelöscht. Sind Sie wirklich sicher?';
$string['deletecheckwarning'] = 'Sie sind dabei, diese Dateien zu löschen';
$string['deletecomment'] = 'Kommentar löschen';
$string['deletecompletely'] = 'Vollständig löschen';
$string['deletecourse'] = 'Kurs löschen';
$string['deletecoursecheck'] = 'Sind Sie sich wirklich sicher, dass Sie diesen Kurs und alle dazugehörenden Daten löschen wollen?';
$string['deleted'] = 'Gelöscht';
$string['deletedactivity'] = '{$a} gelöscht';
$string['deletedcourse'] = '{$a} wurde gelöscht';
$string['deletednot'] = '{$a} konnte nicht gelöscht werden!';
$string['deletelogs'] = 'Logdaten löschen';
$string['deleteselected'] = 'Auswahl löschen';
$string['deleteselectedkey'] = 'Ausgewählten Schlüssel löschen';
$string['deletingcourse'] = '{$a} wird gelöscht';
$string['deletingexistingcoursedata'] = 'Vorhandene Kursdaten werden gelöscht';
$string['deletingolddata'] = 'Alte Daten werden gelöscht';
$string['department'] = 'Abteilung';
$string['desc'] = 'Absteigend';
$string['description'] = 'Beschreibung';
$string['deselectall'] = 'Nichts auswählen';
$string['detailedless'] = 'Weniger Details';
$string['detailedmore'] = 'Mehr Details';
$string['directory'] = 'Verzeichnis';
$string['disable'] = 'Deaktiviert';
$string['disabledcomments'] = 'Kommentare sind deaktiviert';
$string['displayingfirst'] = 'Nur die ersten {$a->count} {$a->things} werden angezeigt';
$string['displayingrecords'] = '{$a} Einträge werden angezeigt';
$string['displayingusers'] = 'Nutzer/innen werden von {$a->start} bis {$a->end} angezeigt';
$string['displayonpage'] = 'Auf einer Seite anzeigen';
$string['documentation'] = 'Moodle-Dokumentation';
$string['down'] = 'Abwärts';
$string['download'] = 'Herunterladen';
$string['downloadall'] = 'Alles herunterladen';
$string['downloadexcel'] = 'Im Excel-Format herunterladen';
$string['downloadfile'] = 'Datei herunterladen';
$string['downloadods'] = 'Im ODS-Format herunterladen';
$string['downloadtext'] = 'Im Text-Format herunterladen';
$string['doyouagree'] = 'Haben Sie diese Bedingungen gelesen, verstanden und stimmen ihnen zu?';
$string['duplicate'] = 'Kopieren';
$string['duplicatinga'] = '{$a} wird dupliziert';
$string['duplicatingain'] = 'Kopiere von {$a->what} nach {$a->in}';
$string['edhelpaspellpath'] = 'Zur Nutzung der Rechtschreibprüfung muss <strong>aspell 0.50</strong> (oder neuer) auf dem Server installiert und der richtige Pfad zu den aspell-Dateien eingerichtet sein. Auf Unix/Linux-Systemen ist dies meist <strong>/usr/bin/aspell</strong>. Es kann aber auch ein anderer Pfad sein.';
$string['edhelpbgcolor'] = 'Legen Sie die Hintergrundfarbe im Bearbeitungsfeld des Editors fest. <br />Gültige Werte sind z.B. #ffffff oder white.';
$string['edhelpcleanword'] = 'Diese Option aktiviert den Filter für Word-formatierte Texte';
$string['edhelpenablespelling'] = 'Diese Option aktiviert die Rechtschreibprüfung. Wenn die Rechtschreibprüfung aktiviert wird, muss <strong>aspell</strong> auf dem Server installiert sein. Der zweite Parameter gibt das <strong>Standardwörterbuch</strong> an. Dieser Parameter wird benutzt, wenn aspell kein Wörterbuch für die aktuell eingestellte Sprache zur Verfügung hat.';
$string['edhelpfontfamily'] = 'Liste verfügbarer Schriftarten. Die einzelnen Schriftarten bzw. Schriftfamilien müssen kommagetrennt angegeben werden.';
$string['edhelpfontlist'] = 'Festlegung der Schriften, die im Dropdown-Menü des Editors gezeigt werden.';
$string['edhelpfontsize'] = 'Voreingestellte Schriftgröße für den Editor
<br />Gültige Werte sind z.B.: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Bearbeiten';
$string['edita'] = '{$a} bearbeiten';
$string['editcategorysettings'] = 'Einstellungen für Kursbereich bearbeiten';
$string['editcategorythis'] = 'Kursbereich bearbeiten';
$string['editcoursesettings'] = 'Kurseinstellungen bearbeiten';
$string['editfiles'] = 'Dateien bearbeiten';
$string['editgroupprofile'] = 'Gruppenprofile bearbeiten';
$string['editinga'] = '{$a} wird bearbeitet';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Dieser Wert darf nicht geändert werden!';
$string['editmyprofile'] = 'Profil bearbeiten';
$string['editorbgcolor'] = 'Hintergrundfarbe';
$string['editorcleanonpaste'] = 'Word-Texte beim Einfügen filtern und bereinigen';
$string['editorcommonsettings'] = 'Standardeinstellungen';
$string['editordefaultfont'] = 'Standardschrift';
$string['editorenablespelling'] = 'Rechtschreibprüfung aktivieren';
$string['editorfontlist'] = 'Schriftenliste';
$string['editorfontsize'] = 'Standardschriftgröße';
$string['editorresettodefaults'] = 'Auf Standardwerte zurücksetzen';
$string['editorsettings'] = 'Einstellungen für den Editor';
$string['editorshortcutkeys'] = 'Tastaturbefehle für den Editor';
$string['editsettings'] = 'Einstellungen bearbeiten';
$string['editsummary'] = 'Bearbeiten';
$string['editthisactivity'] = 'Aktivität bearbeiten';
$string['editthiscategory'] = 'Kursbereich bearbeiten';
$string['edituser'] = 'Nutzerkonten bearbeiten';
$string['email'] = 'E-Mail-Adresse';
$string['emailactive'] = 'E-Mail-Adresse aktiv
';
$string['emailagain'] = 'E-Mail (wiederholen)';
$string['emailcharset'] = 'E-Mail-Zeichensatz';
$string['emailconfirm'] = 'Bestätigen Sie Ihren Zugang.';
$string['emailconfirmation'] = 'Guten Tag {$a->firstname},

wir freuen uns, dass sich im Lernmanagementsystem Moodle \'{$a->sitename}\' angemeldet haben.

Wir haben bei uns eine neue Nutzerregistrierung erhalten bei der Ihre E-Mailadresse eingetragen wurde. Wenn dies richtig ist, bestätigen Sie bitte die Anmeldung über den folgenden Link:

  {$a->link}

Kontrollieren Sie bitte zunächst, ob alle Zeichen der obigen Zeile in dem Link enthalten sind. Falls im Anmeldenamen ein Leerzeichen enthalten ist, kann der Link unterbrochen sein. Klicken Sie dann auf den Link und ergänzen Sie im Browser in der URL-Adresse die restlichen Zeichen des Links.

In den meisten E-Mail-Programmen ist dieser Link aktiv, so dass Sie ihn einfach anklicken können. Wenn dies nicht funktioniert, kopieren Sie bitte die komplette Adresse in die obere Zeile des Browser-Fensters.

Falls die Anmeldung nicht von Ihnen stammt, können Sie diese E-Mail ignorieren. Der Nutzeraccount wird automatisch gelöscht wenn er von Ihnen nicht über einen Klick auf den obigen Link bestätigt wird.

Bei Problemen wenden Sie sich bitte an die Administrator/innen der Website.

Viel Erfolg!
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: Zugangsbestätigung';
$string['emailconfirmsent'] = '<p>Um sicherzugehen, dass sich niemand unberechtigt über die von Ihnen angegebene E-Mail anmeldet, wird eine automatische Benachrichtigung an diese Adresse <b>{$a}</b> gesendet. Je nach Netzlast trifft sie sofort oder auch etwas später bei Ihnen ein.</p>
<p>Die Benachrichtigung enthält eine Anleitung, wie Sie Ihre Registrierung bestätigen.
Danach sind Sie auf dieser Moodle-Seite registriert und können sofort loslegen.</p>
<p>Bei Problemen wenden Sie sich bitte an die Administrator/innen der Website.</p>';
$string['emaildigest'] = 'Forenbeiträge zusammenfassen';
$string['emaildigestcomplete'] = 'Vollständig (tägliche E-Mail mit allen Forumsbeiträgen)';
$string['emaildigestoff'] = 'Einzeln (alle Forumsbeiträge einzeln als E-Mail)';
$string['emaildigestsubjects'] = 'Themen (tägliche E-Mail mit den Themen aller Forumsbeiträge)';
$string['emaildisable'] = 'E-Mail-Adresse ist deaktiviert';
$string['emaildisableclick'] = 'Klicken Sie hier, um den E-Mail-Versand an diese Adresse zu deaktivieren.';
$string['emaildisplay'] = 'E-Mail-Adresse anzeigen';
$string['emaildisplaycourse'] = 'E-Mail-Adresse nur für Kursteilnehmer/innen anzeigen';
$string['emaildisplayhidden'] = 'E-Mail-Adresse verbergen';
$string['emaildisplayno'] = 'Nein, für niemanden sichtbar';
$string['emaildisplayyes'] = 'Ja, für alle sichtbar';
$string['emailenable'] = 'E-Mail-Adresse ist aktiviert';
$string['emailenableclick'] = 'Klicken Sie hier, um den E-Mail-Versand an diese Adresse zu reaktivieren.';
$string['emailexists'] = 'Diese E-Mail-Adresse ist bereits registriert.';
$string['emailformat'] = 'E-Mail-Format';
$string['emailmustbereal'] = 'Wichtig: Geben Sie eine gültige E-Mail-Adresse an. Sie erhalten per E-Mail eine Bestätigung Ihrer Anmeldung.';
$string['emailnotallowed'] = 'E-Mail-Adressen aus den folgenden Domains sind nicht erlaubt: {$a}';
$string['emailnotfound'] = 'Die E-Mail-Adresse wurde nicht in der Datenbank gefunden.';
$string['emailonlyallowed'] = 'Diese E-Mail-Adresse ({$a}) kann nicht verwendet werden. Bitte wenden Sie sich bei Fragen an die Administrator/innen.';
$string['emailpasswordchangeinfo'] = 'Guten Tag {$a->firstname},

jemand (wahrscheinlich Sie) hat ein neues Kennwort für Ihren Zugang auf \'{$a->sitename}\' angefordert.

Um das Kennwort zu ändern, gehen Sie bitte auf folgende Webseite:

{$a->link}

Hinweis: In den meisten E-Mail-Programmen erscheint die Adresse als blauer Link, auf den Sie einfach klicken können. Falls dies nicht funktioniert, kopieren Sie die komplette Adresse in die obere Zeile des Browserfensters.

Bei Problemen wenden Sie sich bitte an die Administrator/innen der Website.

Viel Erfolg!
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Guten Tag {$a->firstname},

jemand (wahrscheinlich Sie) hat ein neues Kennwort für Ihren Zugang auf \'{$a->sitename}\' angefordert.

Bedauerlicherweise ist Ihr Zugang zu dieser Website deaktiviert und kann nicht automatisch zurückgesetzt werden. Wenden Sie sich bitte an die Administrator/innen der Website.

{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Guten Tag {$a->firstname},

jemand (wahrscheinlich Sie) hat ein neues Kennwort für Ihren Zugang auf \'{$a->sitename}\' angefordert.

Das Kennwort kann jedoch nicht auf diesem Weg geändert werden. Wenden Sie sich bitte an die Administrator/innen der Website.

{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Kennwortinformation ändern';
$string['emailpasswordconfirmation'] = 'Guten Tag {$a->firstname},

jemand (wahrscheinlich Sie) hat ein neues Kennwort für Ihren Zugang auf \'{$a->sitename}\' angefordert.

Um dies zu bestätigen und ein neues Kennwort per E-Mail zu erhalten, gehen Sie bitte auf folgende Webseite:

{$a->link}

Hinweis: In den meisten E-Mail-Programmen erscheint die Adresse als blauer Link, auf den Sie einfach klicken können. Falls dies nicht funktioniert, kopieren Sie die komplette Adresse in die obere Zeile des Browserfensters.

Sollten Sie die Kennwortanforderung nicht selber ausgelöst haben, hat vermutlich jemand anders Ihren Loginnamen oder Ihre E-Mail-Adresse eingegeben. Dies ist kein Grund zur Beunruhigung. Ignorieren Sie die Nachricht dann bitte.

Bei Problemen wenden Sie sich bitte an die Administrator/innen der Website.

Viel Erfolg!
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Kennwort-Änderung bestätigen';
$string['emailpasswordconfirmmaybesent'] = '<p>Wenn Sie Ihren Anmeldenamen oder Ihre E-Mail-Adresse korrekt angegeben haben, wird eine automatische Benachrichtigung per E-Mail an Sie gesendet.</p>
<p>Die Benachrichtigung enthält eine Anleitung, wie Sie Ihre Kennwortänderung bestätigen und abschließen.</p>';
$string['emailpasswordconfirmsent'] = '<p>Eine E-Mail zur Bestätigung der Kennwortänderung sollte an Ihre Adresse <b>{$a}</b> gesendet worden sein. <br />Sie enthält eine Anleitung, wie Sie Ihre Kennwortänderung bestätigen und abschließen.</p>';
$string['emailpasswordsent'] = 'Danke für Ihre Bestätigung der Kennwortänderung.
Eine E-Mail mit Ihrem neuen Kennwort wurde an Ihre Adresse <b>{$a->email}</b> gesendet.
Das Kennwort wurde automatisch generiert. Sie können dieses <a href="{$a->link}">Kennwort ändern</a>, um es sich besser merken können.';
$string['enable'] = 'Aktiviert';
$string['encryptedcode'] = 'Verschlüsselter Code';
$string['english'] = 'Englisch';
$string['entercourse'] = 'Hier klicken, um den Kurs zu betreten';
$string['enteremail'] = 'E-Mail-Adresse eingeben';
$string['enteremailaddress'] = 'Geben Sie hier Ihre E-Mail-Adresse ein, um Ihr Kennwort zurückzusetzen. Sie erhalten ein Zufallskennwort per E-Mail zugesendet und dürfen dieses dann selber ändern.';
$string['enterusername'] = 'Anmeldenamen eingeben';
$string['entries'] = 'Eintragungen';
$string['error'] = 'Fehler';
$string['errortoomanylogins'] = 'Sie haben die zulässige Anzahl erfolgloser Zugangsversuche überschritten. Für weitere Versuche müssen Sie Ihren Browser neustarten';
$string['errorwhenconfirming'] = 'Ihre Registrierung wurde bisher nicht erfolgreich abgeschlossen. Wenn Sie auf einen Link in einer E-Mail geklickt haben, um hierher zu gelangen, überprüfen Sie bitte die Vollständigkeit des Links.
Hinweis: Sie können durch Kopieren und Einfügen den Link korrigieren, um so die Bestätigung durchzuführen.';
$string['everybody'] = 'Alle';
$string['executeat'] = 'Ausführen um';
$string['existing'] = 'Vorhandene';
$string['existingadmins'] = 'Vorhandene Administator/innen';
$string['existingcourse'] = 'Vorhandener Kurs';
$string['existingcourseadding'] = 'Vorhandener Kurs - Inhalte hinzufügen';
$string['existingcoursedeleting'] = 'Vorhandener Kurs - Inhalte vorher löschen';
$string['existingcreators'] = 'Vorhandene Kursersteller/innen';
$string['existingstudents'] = 'Eingeschriebene Teilnehmer/innen';
$string['existingteachers'] = 'Vorhandene Trainer/innen';
$string['expandall'] = 'Alle maximieren';
$string['expirynotify'] = 'Nachricht zum Teilnahmeende';
$string['expirynotifyemail'] = 'Die folgenden Teilnehmer/innen dieses Kurses werden nach exakt {$a->threshold} Tagen aus dem Kurs gelöscht:

{$a->current}

Die folgenden Teilnehmer/innen werden in weniger als {$a->threshold} Tagen aus dem Kurs gelöscht:

{$a->past}

Sie können auf der folgenden Seite ihren Teilnahmezeitraum verlängern:
{$a->extendurl}';
$string['expirynotifystudents'] = 'Nachricht an Teilnehmer/innen';
$string['expirynotifystudentsemail'] = 'Liebe/r {$a->studentstr},

wir erinnern Sie daran, dass Ihre Teilnahmedauer für den Kurs {$a->course} in {$a->threshold} Tagen endet.

Nehmen Sie bitte mit Ihren Trainer/innen Kontakt auf, falls Sie weiterhin im Kurs eingeschrieben bleiben wollen.';
$string['expirynotifystudents_help'] = 'Wenn eine Einschreibedauer festgelegt wurde, gibt diese Einstellung an, ob die Teilnehmer/innen per E-Mail über das Einschreibungsende für diesen Kurs informiert werden.';
$string['expirythreshold'] = 'Wie lange vorher';
$string['expirythreshold_help'] = 'Wenn eine Einschreibedauer festgelegt wurde, dann gibt diese Einstellung an, wie viele Tage vorher die Teilnehmer/innen über das Einschreibungsende informiert werden.
';
$string['explanation'] = 'Erläuterung';
$string['extendenrol'] = 'Anmeldung verlängern (individuell)';
$string['extendperiod'] = 'Verlängerter Zeitraum';
$string['failedloginattempts'] = '{$a->attempts} gescheiterte Logins seit Ihrem letzten Besuch';
$string['failedloginattemptsall'] = '{$a->attempts} gescheiterte Logins von {$a->accounts} Nutzer/innen';
$string['feedback'] = 'Rückmeldung';
$string['file'] = 'Datei';
$string['filemissing'] = '{$a} fehlt';
$string['files'] = 'Dateien';
$string['filesfolders'] = 'Dateien / Verzeichnisse';
$string['filloutallfields'] = 'Bitte füllen Sie alle Felder im Formular aus!';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Weitere Kurse finden...';
$string['firstaccess'] = 'Erster Zugriff';
$string['firstname'] = 'Vorname';
$string['firsttime'] = 'Sind Sie das erste Mal auf dieser Website?
<br />Bitte registrieren Sie sich:';
$string['flashlinkmessage'] = 'Bitte aktualisieren Sie jetzt Ihren Flash Player:';
$string['flashupgrademessage'] = 'Um diesen Inhalt abspielen zu können, wird das Flash-Plugin in einer neueren Version benötigt.

Sie müssen sich ausloggen und nach der Aktualisierung erneut einloggen.';
$string['folder'] = 'Verzeichnis';
$string['folderclosed'] = 'Geschlossenes Verzeichnis';
$string['folderopened'] = 'Geöffnetes Verzeichnis';
$string['followingoptional'] = 'Die folgenden Angaben sind optional';
$string['followingrequired'] = 'Die folgenden Angaben sind notwendig';
$string['force'] = 'Übergreifend';
$string['forcedmode'] = 'Festgelegter Modus';
$string['forcelanguage'] = 'Festgelegte Sprache';
$string['forceno'] = 'Nicht festgelegt';
$string['forcepasswordchange'] = 'Kennwortänderung';
$string['forcepasswordchangecheckfull'] = 'Sind Sie absolut sicher, dass Sie {$a} zur Kennwortänderung auffordern möchten?';
$string['forcepasswordchange_help'] = 'Wenn diese Option aktiviert ist, muss das Kennwort beim nächsten Login geändert werden';
$string['forcepasswordchangenot'] = 'Die Kennwortänderung für {$a} konnte nicht angefordert werden';
$string['forcepasswordchangenotice'] = 'Bitte ändern Sie Ihr Kennwort, bevor Sie weiterarbeiten';
$string['forcetheme'] = 'Festgelegtes Design';
$string['forgotaccount'] = 'Kennwort vergessen?';
$string['forgotten'] = 'Anmeldename oder Kennwort vergessen?';
$string['forgottenduplicate'] = 'Diese E-Mail-Adresse wird von mehreren Nutzern verwandt. Geben Sie daher bitte den Anmeldenamen ein.';
$string['forgotteninvalidurl'] = 'Ungültige URL zum Kennwort-Rücksetzen';
$string['format'] = 'Format';
$string['format_help'] = 'Die Kursformate legen das Layout der Kursseite fest.

* SCORM-Format - Ein Lernpaket (SCORM) wird im ersten Kursabschnitt angezeigt, alternativ zur Verwendung des Moduls \'Lernpaket\' (SCORM/AICC)
* Soziales Format - Ein Forum wird auf der Kursseite angezeigt
* Themenformat - Die Kursseite wird in Themenabschnitte eingeteilt
* Wochenformat - Die Kursseite wird in Wochenabschnitte eingeteilt, beginnend mit der ersten Woche nach dem Kursbeginn
';
$string['formathtml'] = 'HTML-Format';
$string['formatmarkdown'] = 'Markdown-Format';
$string['formatplain'] = 'Reines Textformat';
$string['formattext'] = 'Moodle-Text-Format';
$string['formattexttype'] = 'Formatierung';
$string['framesetinfo'] = 'Dieses Frameset-Dokument enthält:';
$string['from'] = 'Von';
$string['frontpagecategorycombo'] = 'Kombiliste';
$string['frontpagecategorynames'] = 'Kursbereiche';
$string['frontpagecourselist'] = 'Kursliste';
$string['frontpagedescription'] = 'Informationen';
$string['frontpagedescriptionhelp'] = 'Diese Informationen zur Website werden auf der Startseite angezeigt.';
$string['frontpageformat'] = 'Format der Startseite';
$string['frontpageformatloggedin'] = 'Format der Startseite nach dem Login';
$string['frontpagenews'] = 'Nachrichten';
$string['frontpagesettings'] = 'Einstellungen der Startseite';
$string['frontpagetopiconly'] = 'HTML-Eingabebereich';
$string['fulllistofcourses'] = 'Alle Kurse';
$string['fullname'] = 'Vollständiger Name';
$string['fullnamecourse'] = 'Kursname (vollständig)';
$string['fullnamecourse_help'] = 'Der vollständige Kursname wird oben auf jeder Kursseite und in der Kursübersicht angezeigt';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Vollständiger Name';
$string['fullprofile'] = 'Ganzes Profil';
$string['fullsitename'] = 'Name der Website';
$string['functiondisabled'] = 'Diese Funktion ist zur Zeit deaktiviert.';
$string['gd1'] = 'GD 1.x ist installiert';
$string['gd2'] = 'GD 2.x ist installiert';
$string['gdneed'] = 'GD muss installiert sein, um diese Grafik anzuzeigen';
$string['gdnot'] = 'GD ist nicht installiert';
$string['general'] = 'Allgemein';
$string['geolocation'] = 'Breitengrad - Längengrad';
$string['gettheselogs'] = 'Logdaten holen';
$string['go'] = 'Start';
$string['gpl'] = 'Copyright (C)1999 onwards Martin Dougiamas http://moodle.com

Dieses Programm ist freie Software. Sie dürfen die Software weiterverbreiten und/oder verändern, und zwar im Rahmen der GNU General Public License, wie sie von der Free Software Foundation veröffentlicht wurde. Es gilt die Version 2 der Lizenz oder (falls Sie dies wünschen) auch jede spätere Version.

Dieses Programm wurde in der Hoffnung erstellt, dass es nützlich sein könnte, allerdings OHNE IRGENDEINE GARANTIE, sogar ohne die implizierte Garantie der Marktfähigkeit oder der Eignung für einen bestimmten Zweck.

Weitere Informationen finden Sie auf der Informationsseite zur Moodle-Lizenz : http://docs.moodle.org/dev/License
';
$string['gpl3'] = 'Copyright (C)1999 onwards Martin Dougiamas http://moodle.com

Dieses Programm ist freie Software. Sie dürfen die Software weiterverbreiten und/oder verändern, und zwar im Rahmen der GNU General Public License, wie sie von der Free Software Foundation veröffentlicht wurde. Es gilt die Version 3 der Lizenz oder (falls Sie dies wünschen) auch jede spätere Version.

Dieses Programm wurde in der Hoffnung erstellt, dass es nützlich sein könnte, allerdings OHNE IRGENDEINE GARANTIE, sogar ohne die implizierte Garantie der Marktfähigkeit oder der Eignung für einen bestimmten Zweck.

Weitere Informationen finden Sie auf der Informationsseite zur Moodle-Lizenz : http://docs.moodle.org/dev/License
';
$string['gpllicense'] = 'GPL-Lizenz';
$string['grade'] = 'Bewertung';
$string['grades'] = 'Bewertungen';
$string['group'] = 'Gruppe';
$string['groupadd'] = 'Neue Gruppe hinzufügen';
$string['groupaddusers'] = 'Markierung zur Gruppe hinzufügen';
$string['groupextendenrol'] = 'Verlängerte Einschreibung für alle';
$string['groupfor'] = 'für Gruppe';
$string['groupinfo'] = 'Info über die markierte Gruppe';
$string['groupinfoedit'] = 'Gruppeneinstellungen bearbeiten';
$string['groupinfomembers'] = 'Info über die markierten Gruppenmitglieder';
$string['groupinfopeople'] = 'Info über die markierten Teilnehmer/innen';
$string['groupmembers'] = 'Gruppenmitglieder';
$string['groupmemberssee'] = 'Gruppenmitglieder sichtbar';
$string['groupmembersselected'] = 'Mitglieder der markierten Gruppe';
$string['groupmode'] = 'Gruppenmodus';
$string['groupmodeforce'] = 'Gruppenmodus erzwingen';
$string['groupmy'] = 'Meine Gruppe';
$string['groupnonmembers'] = 'Teilnehmer/innen, die keiner Gruppe zugeordnet sind';
$string['groupnotamember'] = 'Sie sind kein Mitglied dieser Gruppe.';
$string['grouprandomassign'] = 'Teilnehmer/innen per Zufall auf die Gruppen verteilen';
$string['groupremove'] = 'Ausgewählte Gruppe löschen';
$string['groupremovemembers'] = 'Markierte Gruppenmitglieder aus der Gruppe entfernen';
$string['groups'] = 'Gruppen';
$string['groupsnone'] = 'Keine Gruppen';
$string['groupsseparate'] = 'Getrennte Gruppen';
$string['groupsvisible'] = 'Sichtbare Gruppen';
$string['guest'] = 'Gast';
$string['guestdescription'] = 'Gäste haben minimale Rechte und dürfen normalerweise keine Texte eingeben.';
$string['guestskey'] = 'Für Gäste nur mit Einschreibeschlüssel erlaubt';
$string['guestsno'] = 'Für Gäste nicht erlaubt';
$string['guestsnotallowed'] = 'Der Kurs \'{$a}\' erlaubt Gästen keinen Zugang.';
$string['guestsyes'] = 'Für Gäste erlaubt';
$string['guestuser'] = 'Gast';
$string['guestuserinfo'] = 'Der Nutzer \'Gast\' hat ausschließlich Lesezugriff für Kurse, die den Gastzugriff ausdrücklich erlauben.';
$string['healthcenter'] = 'Analyse der Serverumgebung';
$string['healthnoproblemsfound'] = 'Es wurde kein Problem in der Serverumgebung gefunden';
$string['healthproblemsdetected'] = 'Serverumgebungsprobleme entdeckt!';
$string['healthproblemsolution'] = 'Problemlösung für Serverumgebung';
$string['healthreturntomain'] = 'Weiter';
$string['healthsolution'] = 'Lösung';
$string['help'] = 'Hilfe';
$string['helpprefix2'] = 'Hilfe für {$a}';
$string['helpwiththis'] = 'Hilfe für dies';
$string['hiddenassign'] = 'Verborgene Zuweisung';
$string['hiddenfromstudents'] = 'Für Teilnehmer/innen verborgen';
$string['hiddensections'] = 'Verborgene Abschnitte';
$string['hiddensectionscollapsed'] = 'Mit Hinweis "Nicht verfügbar" anzeigen';
$string['hiddensections_help'] = '<h2>Verborgene Abschnitte</h2>

<p>Diese Einstellung legt fest, ob und wie verborgene Abschnitte für die Teilnehmer/innen angezeigt werden.</p>

<p>In der Standardeinstellung werden sie mit dem Hinweis: "Nicht verfügbar" angezeigt, um den verborgenen Abschnitt zu kennzeichnen. Die Texte und Aktivitäten des verborgenen Abschnitts werden nicht angezeigt. Diese Einstellung ist sinnvoll, um z.B. im Wochen-Format Wochen zu kennzeichnen, in denen kein Unterricht stattfindet.</p>

<p>Sie können Abschnitte auch vollständig verbergen, d.h. die Teilnehmer/innen können dann nicht sehen, dass diese Abschnitte überhaupt existieren. Im Themen-Format kann dies aber zu einer Irritation der Teilnehmer/innen führen, da verborgene Abschnitte in der Zählung der Abschnitte berücksichtigt werden und somit als fehlend interpretiert werden.</p>';
$string['hiddensectionsinvisible'] = 'Vollständig unsichtbar';
$string['hide'] = 'Verbergen';
$string['hideadvancedsettings'] = 'Optionale Felder verbergen';
$string['hidepicture'] = 'Bild verbergen';
$string['hidesection'] = 'Bereich {$a} verbergen';
$string['hidesettings'] = 'Einstellungen verbergen';
$string['hideshowblocks'] = 'Blöcke sichtbar/verbergen';
$string['hidetopicfromothers'] = 'Themenfeld verbergen';
$string['hideweekfromothers'] = 'Woche verbergen';
$string['hits'] = 'Treffer';
$string['hitsoncourse'] = 'Treffer in {$a->coursename} von {$a->username}';
$string['hitsoncoursetoday'] = 'Heutige Treffer in {$a->coursename} von {$a->username}';
$string['home'] = 'Startseite';
$string['hour'] = 'Stunde';
$string['hours'] = 'Stunden';
$string['howtomakethemes'] = 'Wie Sie neue Designs erstellen';
$string['htmleditor'] = 'HTML-Editor verwenden (nicht mit allen Browsern möglich)';
$string['htmleditoravailable'] = 'Der HTML-Editor ist verfügbar';
$string['htmleditordisabled'] = 'Sie haben den HTML-Editor in Ihrem Profil deaktiviert';
$string['htmleditordisabledadmin'] = 'Die Administrator/innen haben den HTML-Editor deaktiviert';
$string['htmleditordisabledbrowser'] = 'Der HTML-Editor ist nicht verfügbar, weil Ihr Browser nicht kompatibel ist. Bitte nutzen Sie eine neuere Browserversion oder einen anderen Browser.';
$string['htmlfilesonly'] = 'Nur HTML-Dateien';
$string['htmlformat'] = 'HTML-Format';
$string['icon'] = 'Icon
';
$string['icqnumber'] = 'ICQ';
$string['idnumber'] = 'ID-Nummer';
$string['idnumbercourse'] = 'Kurs-ID';
$string['idnumbercourse_help'] = '<h2>Kurs-ID-Nummer</h2>

<p>Die Kurs-ID-Nummer wird lediglich zum Abgleich von Kursdaten durch externe Datenbanken benötigt. In Moodle selbst wird die Nummer nicht weiter benötigt bzw. angezeigt. Wenn Sie eine offizielle Kursnummer haben, können Sie diese hier eintragen, andernfalls lassen Sie das Feld leer.</p>';
$string['idnumbermod'] = 'ID-Nummer';
$string['idnumbermod_help'] = 'Wenn eine ID-Nummer vergeben wird, kann die Aktivität in Bewertungsberechnungen identifiziert werden. Falls die Aktivität in keine Berechnung einbezogen wird, kann das Feld für die ID-Nummer leer bleiben.

Die ID-Nummer kann auch bei der Bewertung gesetzt werden, allerdings kann sie nur in der Aktivitätseinstellungen verändert werden.';
$string['idnumbertaken'] = 'Diese ID-Nummer wird bereits benutzt!';
$string['imagealt'] = 'Bildbeschreibung';
$string['import'] = 'Import';
$string['importdata'] = 'Kursdaten importieren';
$string['importdataexported'] = 'Die Daten wurden erfolgreich aus dem Quellkurs exportiert.<br />Jetzt erfolgt der Import in den von Ihnen ausgewählten Zielkurs.';
$string['importdatafinished'] = 'Import abgeschlossen! Weiter zu Ihrem Kurs';
$string['importdatafrom'] = 'Wählen Sie einen Quellkurs, aus dem Daten importiert werden sollen.';
$string['inactive'] = 'Inaktiv';
$string['include'] = 'Einbeziehen';
$string['includeallusers'] = 'Alle Nutzer/innen einbeziehen';
$string['includecoursefiles'] = 'Kursdateien einbeziehen';
$string['includecourseusers'] = 'Kursteilnehmer/innen einbeziehen';
$string['included'] = 'Einbezogen';
$string['includelogentries'] = 'Logdaten einbeziehen';
$string['includemodules'] = 'Module (Aktivitäten) einbeziehen';
$string['includemoduleuserdata'] = 'Nutzerdaten aus Modulen einbeziehen';
$string['includeneededusers'] = 'Notwendige Nutzer/innen einbeziehen';
$string['includenoneusers'] = 'Nicht-Nutzer/innen einbeziehen';
$string['includeroleassignments'] = 'Rollenzuordnungen einbeziehen';
$string['includesitefiles'] = 'In Kursen benutzte Dateien der Website einbeziehen';
$string['includeuserfiles'] = 'Nutzerdateien einbeziehen';
$string['info'] = 'Informationen';
$string['institution'] = 'Institution';
$string['instudentview'] = 'Teilnehmeransicht';
$string['interests'] = 'Interessen';
$string['interestslist'] = 'Persönliche Interessen';
$string['interestslist_help'] = 'Geben Sie Ihre persönlichen Interessen als kommagetrennte Liste an. Ihre Interessen werden auf Ihrer Profilseite als Schlagworte angezeigt.';
$string['invalidemail'] = 'Ungültige E-Mail-Adresse';
$string['invalidlogin'] = 'Ungültige Anmeldedaten, bitte versuchen Sie es erneut!';
$string['invalidusername'] = 'Der Anmeldename darf nur Kleinbuchstaben und Ziffern enthalten, außerdem die Zeichen Unterstrich (_), Bindestrich (-), Punkt (.) sowie das Zeichen @.';
$string['invalidusernameupload'] = 'Ungültiger Anmeldename';
$string['ip_address'] = 'IP-Adresse';
$string['jump'] = 'Sprung';
$string['jumpto'] = 'Direkt zu:';
$string['keep'] = 'Behalten';
$string['keepsearching'] = 'Weiter suchen';
$string['langltr'] = 'Schrift von links nach rechts';
$string['langrtl'] = 'Schrift von rechts nach links';
$string['language'] = 'Sprache';
$string['languagegood'] = 'Dieses Sprachpaket ist auf dem aktuellen Stand!  :-)';
$string['lastaccess'] = 'Letzter Zugriff';
$string['lastedited'] = 'Zuletzt bearbeitet';
$string['lastlogin'] = 'Zuletzt eingeloggt';
$string['lastmodified'] = 'Zuletzt geändert';
$string['lastname'] = 'Nachname';
$string['lastyear'] = 'Letztes Jahr';
$string['latestlanguagepack'] = 'Neuere Version des Sprachpakets bei moodle.org suchen';
$string['layouttable'] = 'Layout-Tabelle';
$string['leavetokeep'] = 'Feld leer lassen, um das gegenwärtige Kennwort zu behalten';
$string['legacythemeinuse'] = 'Diese Website wird im Kompatibilitätsmodus angezeigt, weil Ihr Browser zu alt ist.';
$string['legacythemesaved'] = 'Neues Design gespeichert (unterstützt alte Browser)';
$string['license'] = 'Lizenz';
$string['licenses'] = 'Lizenzen';
$string['liketologin'] = 'Wollen Sie sich jetzt mit Ihren Anmeldedaten einloggen?';
$string['list'] = 'Auflisten';
$string['listfiles'] = 'Liste der Dateien in {$a}';
$string['listofallpeople'] = 'Liste aller Nutzer/innen';
$string['livelogs'] = 'Aktuelle Logdaten der letzten Stunde';
$string['local'] = 'Lokal';
$string['localplugindeleteconfirm'] = 'Sie sind dabei, das lokale Plugin \'{$a}\' zu löschen. Der Vorgang wird endgültig alle Daten in der Datenbank löschen, die mit diesem Plugin verknüpft sind. Sind Sie wirklich sicher, dass Sie weitermachen möchten?';
$string['localplugins'] = 'Lokale Plugins';
$string['localpluginsmanage'] = 'Übersicht';
$string['location'] = 'Ort';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Sie sind angemeldet als {$a}';
$string['loggedinasguest'] = 'Sie sind zur Zeit als Gast angemeldet';
$string['loggedinnot'] = 'Sie sind nicht angemeldet';
$string['login'] = 'Login';
$string['loginalready'] = 'Sie sind bereits angemeldet.';
$string['loginas'] = 'Login als';
$string['loginaspasswordexplain'] = '<p>Sie müssen das spezielle \'Login als\'-Passwort für diese Funktion verwenden. <br />Falls Ihnen dieses Passwort nicht bekannt ist, wenden Sie sich an die Administrator/innen Ihrer Website.</p>';
$string['login_failure_logs'] = 'Login-Fehlerdaten';
$string['loginguest'] = 'Als Gast anmelden';
$string['loginsite'] = 'Login';
$string['loginsteps'] = 'Guten Tag!

Um an den verschiedenen Kursen teilnehmen zu können, müssen Sie sich einen Nutzerzugang für diese Website anlegen. Für einige Kurse könnte zusätzlich ein Zugangsschlüssel notwendig sein.

<p>Gehen Sie dazu bitte wie folgt vor:
<ol size=2>
<li>Füllen Sie das Formular <a href="{$a}">Neuer Zugang</a> mit Ihren Angaben aus.</li>
<li>Sie erhalten umgehend eine Benachrichtigung an die von Ihnen angegebene E-Mail-Adresse.</li>
<li>Lesen Sie diese E-Mail genau und klicken Sie den darin enthaltenen Link an.</li>
<li>Ihr Zugang wird auf diese Weise bestätigt und Sie werden automatisch mit Ihren zuvor angegebenen Zugangsdaten auf der Startseite eingeloggt.</li>
<li>Jetzt wählen Sie bitte den Kurs aus, an dem Sie teilnehmen möchten.</li>
<li>Für einige Kurse ist ein Zugangsschlüssel notwendig. Benutzen Sie dazu bitte den Zugangsschlüssel, den Ihnen Ihre Trainer/in mitgeteilt hat. Mit diesem Zugangsschlüssel können Sie sich in den entsprechenden Kurs einschreiben.</li>
<li>Nun haben Sie einen Nutzerzugang zur Website. Zukünftig müssen Sie jedes Mal den bei Ihrer Registrierung gewählten Anmeldenamen und das Kennwort (im Login-Block auf dieser Seite) eingeben, um sich einzuloggen und Zugang zu den verschiedenen Kursen zu erhalten.</li>
</ol>';
$string['loginstepsnone'] = 'Guten Tag!

Um an den verschiedenen Kursen teilnehmen zu können, müssen Sie sich einen Nutzerzugang für diese Webseite anlegen.

Wählen Sie einen Anmeldenamen und ein Kennwort, die Sie im Formular auf dieser Seite eintragen.
Wenn jemand anders bereits Ihren Anmeldenamen gewählt hat, müssen Sie einen anderen Anmeldenamen verwenden.';
$string['loginto'] = 'Einloggen in \'{$a}\'';
$string['loginusing'] = 'Geben Sie Ihren Anmeldenamen und das Kennwort ein';
$string['logout'] = 'Logout';
$string['logoutconfirm'] = 'Möchten Sie sich wirklich ausloggen?';
$string['logs'] = 'Logdaten';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">mehr</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">mehr</a> ]';
$string['lookback'] = 'Rückschau';
$string['mailadmins'] = 'Administrator/innen informieren';
$string['mailstudents'] = 'Teilnehmer/innen informieren';
$string['mailteachers'] = 'Trainer/innen informieren';
$string['makeafolder'] = 'Verzeichnis erstellen';
$string['makeeditable'] = 'Wenn der Webserver (z.B. Apache) Schreibrechte für \'{$a}\' hat, können Sie die Datei direkt über diese Seite bearbeiten.';
$string['makethismyhome'] = 'Diese Seite zu meiner Startseite machen';
$string['manageblocks'] = 'Blöcke';
$string['managecourses'] = 'Kurse verwalten';
$string['managedatabase'] = 'Datenbank';
$string['manageeditorfiles'] = 'Dateien verwalten, die vom Autor genutzt werden';
$string['managefilters'] = 'Filter';
$string['managemodules'] = 'Module';
$string['manageroles'] = 'Rollen und Rechte';
$string['markedthistopic'] = 'Dieser Abschnitt ist als aktueller Abschnitt gekennzeichnet';
$string['markthistopic'] = 'Diesen Abschnitt als aktuellen Abschnitt kennzeichnen';
$string['matchingsearchandrole'] = 'Anpassung von \'{$a->search}\' und {$a->role}';
$string['maxfilesize'] = 'Maximale Dateigröße: {$a}';
$string['maximumchars'] = 'Höchstens {$a} Buchstaben';
$string['maximumgrade'] = 'Beste Bewertung';
$string['maximumgradex'] = 'Beste Bewertung: {$a}';
$string['maximumshort'] = 'Max.';
$string['maximumupload'] = 'Maximale Dateigröße';
$string['maximumupload_help'] = '<h2>Maximale Dateigröße zum Hochladen</h2>

<p>Diese Einstellungen legt die maximale Größe einer Datei fest, die Teilnehmer/innen im Kurs hochladen können. Diese wird nach oben begrenzt durch die Voraussetzungen des Servers und die Einstellung der Administrator/innen für die gesamte Moodle-Installation.</p>

<p>Es ist möglich, diese Einstellung für einzelne Aktivitäten im Kurs weiter einzuschränken, indem Sie die gleichnamige Einstellung für die einzelne Aktivität entsprechend anpassen.</p>';
$string['maxnumcoursesincombo'] = '<a href="{$a->link}">Übersicht mit {$a->numberofcourses} Kurse</a>.';
$string['maxsize'] = 'Maximale Größe: {$a}';
$string['memberincourse'] = 'Kursteilnehmer/innen';
$string['messagebody'] = 'Mitteilungstext';
$string['messagedselectedusers'] = 'Die ausgewählten Nutzer/innen wurden benachrichtigt, und die Empfängerliste wurde zurückgesetzt.';
$string['messagedselectedusersfailed'] = 'Beim Versenden der Mitteilung ist ein Problem aufgetreten. Es kann sein, dass einzelne Empfänger/innen die Nachricht erhalten haben.';
$string['messageprovider:backup'] = 'Mitteilungen zur Sicherung';
$string['messageprovider:courserequestapproved'] = 'Mitteilung zur genehmigten Kursbeantragung';
$string['messageprovider:courserequested'] = 'Mitteilung zur Kursbeantragung';
$string['messageprovider:courserequestrejected'] = 'Mitteilung zur abgelehnten Kursbeantragung';
$string['messageprovider:errors'] = 'Schwerwiegende Fehler mit dieser Website';
$string['messageprovider:errors_help'] = 'Über diesen Fehler sollten Sie Ihren Admin benachrichtigen.';
$string['messageprovider:instantmessage'] = 'Persönliche Mitteilungen zwischen den Nutzer/innen';
$string['messageprovider:instantmessage_help'] = 'Dieser Abschnitt legt fest was mit Mitteilungen passiert, die von anderen Nutzern Ihnen direkt gesandt werden.';
$string['messageprovider:notices'] = 'Mitteilungen bei kleinen Fehlern';
$string['messageprovider:notices_help'] = 'Es gibt keine Informationen, die ein Admin unbedingt sehen sollte.';
$string['messageselect'] = 'Wählen Sie diese Nutzer/in zum E-Mail-Versand aus';
$string['messageselectadd'] = 'Mitteilung senden';
$string['migratinggrades'] = 'Bewertungen migrieren';
$string['min'] = 'Minute';
$string['mins'] = 'Minuten';
$string['minutes'] = 'Minuten';
$string['miscellaneous'] = 'Verschiedenes';
$string['missingcategory'] = 'Sie müssen einen Kursbereich auswählen';
$string['missingcity'] = 'Stadt/Ort fehlt';
$string['missingcountry'] = 'Land fehlt';
$string['missingdescription'] = 'Beschreibung fehlt';
$string['missingemail'] = 'E-Mail-Adresse fehlt';
$string['missingfirstname'] = 'Vorname fehlt';
$string['missingfromdisk'] = 'Quelle fehlt';
$string['missingfullname'] = 'Name fehlt';
$string['missinglastname'] = 'Nachname fehlt';
$string['missingname'] = 'Name fehlt';
$string['missingnewpassword'] = 'Neues Kennwort fehlt';
$string['missingpassword'] = 'Kennwort fehlt';
$string['missingrecaptchachallengefield'] = 'Fehlendes Eingabefeld für reCaptcha';
$string['missingreqreason'] = 'Begründung fehlt';
$string['missingshortname'] = 'Kurzbezeichnung fehlt';
$string['missingshortsitename'] = 'Kurzbezeichnung der Website fehlt';
$string['missingsitedescription'] = 'Informationen zur Website fehlen';
$string['missingsitename'] = 'Name der Website fehlt';
$string['missingstrings'] = 'Fehlende Texte suchen';
$string['missingstudent'] = 'Sie müssen eine Person auswählen';
$string['missingsummary'] = 'Zusammenfassung fehlt';
$string['missingteacher'] = 'Sie müssen eine Person auswählen';
$string['missingurl'] = 'URL fehlt';
$string['missingusername'] = 'Anmeldename fehlt';
$string['modified'] = 'Geändert';
$string['moduledeleteconfirm'] = 'Sie wollen das Modul \'{$a}\' vollständig löschen. Damit löschen Sie alle Datenbankeinträge, die mit diesem Modul in Verbindung stehen. Wollen Sie diesen Vorgang wirklich fortsetzen?';
$string['moduledeletefiles'] = 'Alle Daten, die mit dem Modul \'{$a->module}\' in Verbindung stehen, wurden in der Datenbank gelöscht. Um den Vorgang abzuschließen und sicherzustellen, dass keine Neuinstallation des Moduls erfolgt, sollten Sie das Verzeichnis {$a->directory} auf dem Server löschen.';
$string['moduleintro'] = 'Beschreibung';
$string['modulesetup'] = 'Lege Modultabellen an';
$string['modulesuccess'] = '{$a} Tabellen wurden korrekt angelegt';
$string['moodledocs'] = 'Dokumentation';
$string['moodledocslink'] = 'Moodle-Dokumentation für diese Seite';
$string['moodlerelease'] = 'Moodle-Release';
$string['moodleversion'] = 'Moodle-Version';
$string['more'] = 'mehr';
$string['morehelp'] = 'Weitere Hilfe';
$string['moreinformation'] = 'Weitere Informationen über diesen Fehler';
$string['moreprofileinfoneeded'] = 'Bitte geben Sie uns einige Informationen zu Ihrer Person.';
$string['mostrecently'] = 'neueste';
$string['move'] = 'Verschieben';
$string['movecategorycontentto'] = 'Hinein verschieben';
$string['movecategoryto'] = 'Kursbereich verschieben nach:';
$string['movecontentstoanothercategory'] = 'Inhalte in andere Kategorie verschieben';
$string['movecourseto'] = 'Kurs verschieben nach:';
$string['movedown'] = 'Nach unten verschieben';
$string['movefilestohere'] = 'Dateien hierhin verschieben';
$string['movefull'] = '{$a} an diese Stelle verschieben';
$string['movehere'] = 'Hierhin verschieben';
$string['moveleft'] = 'Nach links verschieben';
$string['moveright'] = 'Nach rechts verschieben';
$string['movesection'] = 'Bereich {$a} verschieben';
$string['moveselectedcoursesto'] = 'Ausgewählte Kurse verschieben nach ...';
$string['movetoanotherfolder'] = 'In ein anderes Verzeichnis verschieben';
$string['moveup'] = 'Nach oben verschieben';
$string['msnid'] = 'MSN';
$string['mustchangepassword'] = 'Das neue Kennwort darf nicht mit dem alten Kennwort identisch sein.';
$string['mustconfirm'] = 'Sie müssen Ihren Zugang bestätigen';
$string['mycourses'] = 'Meine Kurse';
$string['myfiles'] = 'Eigene Dateien';
$string['myfilesmanage'] = 'Eigene Dateien verwalten';
$string['myhome'] = 'Meine Startseite';
$string['mymoodledashboard'] = 'Mein Bereich';
$string['myprofile'] = 'Mein Profil';
$string['name'] = 'Name';
$string['navigation'] = 'Navigation';
$string['needed'] = 'Benötigt';
$string['never'] = 'Nie';
$string['neverdeletelogs'] = 'Logdaten nie löschen';
$string['new'] = 'Neu';
$string['newaccount'] = 'Neuer Zugang';
$string['newcourse'] = 'Neuer Kurs';
$string['newpassword'] = 'Neues Kennwort';
$string['newpasswordfromlost'] = '<strong>Hinweis:</strong> Ihr <strong> Ersatzkennwort </strong> wurde Ihnen mit einer
<strong> zweiten E-Mail</strong> zugeschickt. Sie können sich jetzt nur noch mit dem Ersatzkennwort aus der E-Mail einloggen..';
$string['newpassword_help'] = 'Lassen Sie dieses Feld leer, um das bisherige Passwort zu behalten.';
$string['newpasswordtext'] = 'Guten Tag {$a->firstname},

Ihr Kennwort auf \'{$a->sitename}\' wurde zurückgesetzt. Ihnen ist ein neues, temporäres Kennwort zugewiesen worden.

Ihre Zugangsdaten lauten jetzt:
   Anmeldename: {$a->username}
   Kennwort: {$a->newpassword}

Bitte folgen Sie diesem Link und ändern Sie Ihr Kennwort:
{$a->link}

Hinweis: In den meisten E-Mail-Programmen erscheint dieser Link blau, so dass Sie diesen anklicken können. Wenn dies nicht funktioniert, kopieren Sie bitte die komplette Adresse in die obere Zeile des Browser-Fensters.

Bei Problemen wenden Sie sich bitte an die Administrator/innen der Website.

Viel Erfolg!
{$a->signoff}';
$string['newpicture'] = 'Neues Foto';
$string['newpicture_help'] = 'Um ein neues Bild hinzuzufügen, wählen Sie ein Bild im Format GIF, JPG oder PNG auf Ihrem lokalen Computer aus und drücken abschließend die Taste "Profil aktualisieren". Das Bild sollte ein quadratisches Format von 100x100 Pixel haben, andernfalls wird es von Moodle automatisch als Quadrat beschnitten und in die Zielgröße verändert.';
$string['newsitem'] = 'Nachricht';
$string['newsitems'] = 'Nachrichten';
$string['newsitemsnumber'] = 'Anzahl neuer Nachrichten';
$string['newsitemsnumber_help'] = '<h2>Anzuzeigende neue Nachrichten</h2>

<p>Ein spezielles Forum im Kurs ist das Nachrichtenforum. Es wird standardmäßig bei Kursen im Wochen- oder Themen-Format angelegt. Dieses Forum ist der richtige Platz, um Mitteilungen für alle Kursteilnehmer/innen zu veröffentlichen. Ein Nachrichtenforum ist standardmäßig so konfiguriert, dass alle Kursteilnehmer/innen die Mitteilungen aus diesem Forum per E-Mail zugesendet bekommen.</p>

<p>Diese Einstellung legt fest, wieviele Nachrichten im Block "Neueste Nachrichten" auf der Kursseite angezeigt werden.</p>

<p>Wenn Sie hier die Einstellung "0 Nachrichten" auswählen, dann wird der Block "Neueste Nachrichten" nicht angezeigt.</p>';
$string['newuser'] = 'Neues Nutzerprofil';
$string['newusernewpasswordsubj'] = 'Neuer Nutzerzugang';
$string['newusernewpasswordtext'] = 'Guten Tag {$a->firstname},

für Sie wurde ein neuer Zugang auf \'{$a->sitename} angelegt. Zugleich erhalten Sie ein neues vorläufiges Kennwort.

Für Sie gelten nun folgende Logindaten:
Anmeldename: {$a->username}
Kennwort: {$a->newpassword}
(Sie werden aufgefordert, dieses vorläufige Kennwort nach dem ersten Login zu ändern.)

Rufen Sie {$a->sitename} auf und loggen Sie sich auf der Seite {$a->link} ein.

Hinweis: In den meisten E-Mail-Programmen erscheint die Adresse als blauer Link, den Sie direkt anklicken können. Falls dies nicht funktioniert, kopieren Sie bitte die komplette Adresse in die obere Zeile des Browserfensters.

Bei Problemen wenden Sie sich bitte an die Administrator/innen der Website.

Viel Erfolg!
{$a->signoff}';
$string['newusers'] = 'Neue Nutzer/innen';
$string['newwindow'] = 'Neues Fenster';
$string['next'] = 'Weiter';
$string['nextsection'] = 'Nächster Bereich';
$string['no'] = 'Nein';
$string['noblockstoaddhere'] = 'Es gibt keine Blöcke, die Sie zu dieser Seite hinzufügen können';
$string['nobody'] = 'Niemand';
$string['nochange'] = 'Keine Änderung';
$string['nocomments'] = 'Noch keine Kommentare';
$string['nocourses'] = 'Keine Kurse';
$string['nocoursesfound'] = 'Keine Kurse mit dem Begriff \'{$a}\' gefunden';
$string['nocoursesyet'] = 'Keine Kurse in diesem Kursbereich';
$string['nodstpresets'] = 'Die Sommerzeitumstellung wurde nicht aktiviert.';
$string['nofilesselected'] = 'Es wurden keine Dateien zur Wiederherstellung ausgewählt.';
$string['nofilesyet'] = 'Bislang wurden keine Dateien für Ihren Kurs hochgeladen.';
$string['nograde'] = 'Keine Bewertung';
$string['noimagesyet'] = 'Bislang wurden keine Grafiken für Ihren Kurs hochgeladen.';
$string['nologsfound'] = 'Es wurden keine Logs gefunden.';
$string['nomatchingusers'] = 'Keine passenden Nutzer/innen \'{$a}\'';
$string['nomorecourses'] = 'Keine weiteren passenden Kurse gefunden';
$string['nomoreidnumber'] = 'Es wird keine ID-Nummer verwendet, um Probleme zu vermeiden.';
$string['none'] = 'Keine';
$string['noneditingteacher'] = 'Trainer/in ohne Bearbeitungsrecht';
$string['noneditingteacherdescription'] = 'Trainer/innen ohne Bearbeitungsrecht dürfen in Kursen unterrichten und Teilnehmer/innen bewerten, aber sie können nichts im Kurs verändern.';
$string['nonstandard'] = 'nicht standardmäßig';
$string['nopendingcourses'] = 'Zur Zeit liegen keine Kursanträge zur Bearbeitung vor';
$string['nopotentialadmins'] = 'Keine potenziellen Administrator/innen vorhanden';
$string['nopotentialcreators'] = 'Keine möglichen Kursersteller/innen vorhanden';
$string['nopotentialstudents'] = 'Keine potenziellen Teilnehmer/innen vorhanden';
$string['nopotentialteachers'] = 'Keine potenziellen Trainer/innen vorhanden';
$string['norecentactivity'] = 'Keine aktuellen Aktivitäten';
$string['noreplybouncemessage'] = 'Sie haben an eine gesperrte E-Mail-Adresse geantwortet. Wenn Sie versucht haben, auf einen Forenbeitrag zu antworten, benutzen Sie bitte direkt das Forum {$a} für Ihre Antwort.

Das war der Inhalt Ihrer Nachicht:';
$string['noreplybouncesubject'] = '{$a} - E-Mail nicht zustellbar';
$string['noreplyname'] = 'Antworten Sie nicht auf diese E-Mail.';
$string['noresults'] = 'Keine Ergebnisse';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Normalfilter';
$string['nosite'] = 'Es konnte kein passender Kurs gefunden werden.';
$string['nostudentsfound'] = 'Kein {$a} gefunden';
$string['nostudentsingroup'] = 'Derzeit sind keine Teilnehmer/innen in dieser Gruppe eingetragen.';
$string['nostudentsyet'] = 'In diesem Kurs ist noch niemand eingeschrieben.';
$string['nosuchemail'] = 'Keine derartige E-Mail-Adresse vorhanden';
$string['notavailable'] = 'Nicht verfügbar';
$string['noteachersyet'] = 'Dieser Kurs hat noch keine Trainer/innen';
$string['notenrolled'] = '{$a} ist nicht in diesen Kurs eingeschrieben.';
$string['notenrolledprofile'] = 'Dieses Profil ist nicht verfügbar, weil die Person bisher den Kurs nicht betreten hat.';
$string['noteusercannotrolldatesoncontext'] = 'Hinweis: Die Möglichkeit zum Datenimport wurde für diese Wiederherstellung deaktiviert, da Sie nicht über die nötigen Rechte verfügen.';
$string['noteuserschangednonetocourse'] = 'Hinweis: Bei der Wiederherstellung von Nutzerdaten (Aktivitäten, Dateien, Mitteilungen) müssen auch die Teilnehmer/innen wiederhergestellt werden. Diese Einstellung wurde automatisch geändert.';
$string['nothingnew'] = 'Nichts Neues seit Ihrem letzten Login';
$string['nothingtodisplay'] = 'Nichts anzuzeigen';
$string['notice'] = 'Hinweis';
$string['noticenewerbackup'] = 'Diese Sicherungsdatei wurde mit Moodle {$a->backuprelease} ({$a->backupversion}) erstellt und ist aktueller als die derzeit installierte Moodle-Version {$a->serverrelease} ({$a->serverversion}). Das kann zu Problemen führen, da ein abwärtskompatibles Wiederherstellen von Sicherungsdateien nicht garantiert wird.';
$string['notifications'] = 'Mitteilungen';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Nutzer/in: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Sie können diese Logdaten unter {$a}/course/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors ansehen.';
$string['notifyloginfailuresmessagestart'] = 'Die Übersicht listet gescheiterte Anmeldeversuche für {$a} auf';
$string['notifyloginfailuressubject'] = '{$a}: Mitteilung über gescheiterte Anmeldeversuche';
$string['notincluded'] = 'Nicht einbezogen';
$string['notingroup'] = 'Diese Aktivität ist nur für Gruppenmitglieder zugänglich. Sie sind kein Gruppenmitglied.';
$string['notpublic'] = 'Nicht öffentlich!';
$string['nousersfound'] = 'Keine Nutzer/innen gefunden';
$string['nousersmatching'] = 'Es wurden keine zu \'{$a}\' passenden Nutzer/innen gefunden.';
$string['nousersyet'] = 'Bislang keine Nutzer/innen vorhanden';
$string['novalidcourses'] = 'Es können keine Kurse angezeigt werden';
$string['now'] = 'jetzt';
$string['numattempts'] = '{$a} gescheiterte Anmeldeversuche';
$string['numberofcourses'] = 'Anzahl der Kurse';
$string['numberweeks'] = 'Anzahl der Wochen/Themen';
$string['numdays'] = '{$a} Tage';
$string['numhours'] = '{$a} Stunden';
$string['numletters'] = '{$a} Zeichen';
$string['numminutes'] = '{$a} Minuten';
$string['nummonths'] = '{$a} Monate';
$string['numseconds'] = '{$a} Sekunden';
$string['numviews'] = '{$a} Ansichten';
$string['numweeks'] = '{$a} Wochen';
$string['numwords'] = '{$a} Worte';
$string['numyears'] = '{$a} Jahre';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Aktuelles Kennwort';
$string['olduserdirectory'] = 'Dies ist das <b>alte</b> Nutzerverzeichnis. Es wird nicht weiter verwendet. Die Dateien wurden in das <b>neue </b> Nutzerverzeichnis kopiert. Das alte Verzeichnis kann daher gelöscht werden, wenn der Kopiervorgang erfolgreich war.';
$string['opentoguests'] = 'Gastzugang';
$string['optional'] = 'optional';
$string['order'] = 'Reihenfolge';
$string['orphanedactivities'] = 'Ungenutzte Aktivitäten';
$string['other'] = 'Sonstige';
$string['outline'] = 'Überblick';
$string['outlinereport'] = 'Zusammenfassung';
$string['page'] = 'Seite';
$string['pageheaderconfigablock'] = 'Konfiguriere einen Block in %fullname%';
$string['pagepath'] = 'Seitenpfad';
$string['pageshouldredirect'] = 'Die Weiterleitung sollte automatisch funktionieren - falls nichts passiert, klicken Sie bitte auf den nachfolgenden Link';
$string['parentcategory'] = 'Übergeordneter Kursbereich';
$string['parentcoursenotfound'] = 'Kurs nicht gefunden!';
$string['parentfolder'] = 'Übergeordnetes Verzeichnis';
$string['participants'] = 'Teilnehmer/innen';
$string['participantslist'] = 'Teilnehmerliste';
$string['participationratio'] = 'Beteiligung';
$string['participationreport'] = 'Bericht über die Beteiligung';
$string['password'] = 'Kennwort';
$string['passwordchanged'] = 'Kennwort wurde geändert';
$string['passwordconfirmchange'] = 'Kennwortänderung bestätigen';
$string['passwordextlink'] = 'Der folgende Link erlaubt, ein vergessenes Kennwort durch ein neues zu ersetzen. Sie verlassen damit Moodle.';
$string['passwordforgotten'] = 'Kennwort vergessen';
$string['passwordforgotteninstructions'] = 'Ihre Daten müssen zuerst in der Moodle-Datenbank gesucht werden. Tragen Sie entweder Ihren Anmeldenamen <strong>oder </strong> Ihre in Moodle registrierte E-Mail-Adresse im entsprechenden Textfeld ein. Es ist nicht erforderlich beide einzutragen.';
$string['passwordforgotteninstructions2'] = 'Um Ihr Passwort zurückzusetzen, tragen Sie bitte Ihren Anmeldenamen oder Ihre E-Mail-Adresse ein. Falls Sie in unserer Datenbank zu finden sind, wird eine E-Mail an Ihre E-Mail-Adresse verschickt, die eine Anleitung für Ihren Zugang enthält.';
$string['passwordnohelp'] = 'Leider ist keine Hilfe vorhanden, um das vergessene Kennwort wiederherzustellen. Bitte wenden Sie sich an Ihre Administrator/innen.';
$string['passwordrecovery'] = 'Ja, bitte beim Login helfen';
$string['passwordsdiffer'] = 'Die Kennworte stimmen nicht überein';
$string['passwordsent'] = 'Kennwort wurde verschickt';
$string['passwordsenttext'] = 'Eine E-Mail mit Ihrem neuen Kennwort wurde an Ihre Adresse {$a->email} gesendet.

Das Kennwort wurde automatisch generiert - Sie können dieses <a href="{$a->link}">Kennwort ändern</a>, um es sich besser merken zu können.';
$string['path'] = 'Pfad';
$string['pathnotexists'] = 'Dieser Pfad existiert nicht auf dem Server!';
$string['pathslasherror'] = 'Die Pfadangabe darf nicht mit einem Schrägstrich enden!';
$string['paymentinstant'] = 'Klicken Sie auf den Button, um das Teilnahmeentgelt zu bezahlen. Sobald dieser Zahlvorgang abgeschlossen ist, werden Sie automatisch in den Kurs eingeschrieben.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b>in Bearbeitung</small>)';
$string['paymentrequired'] = 'Dieser Kurs ist entgeltpflichtig. Bitte bezahlen Sie das Teilnahmeentgelt, um in den Kurs eingeschrieben zu werden.';
$string['payments'] = 'Zahlungen';
$string['paymentsorry'] = 'Vielen Dank für Ihre Zahlung. Der Zahlvorgang wurde jedoch noch nicht vollständig abgeschlossen. Sie sind noch nicht als Teilnehmer/in im Kurs "{$a->fullname}" eingeschrieben. Bitte versuchen Sie es in einigen Minuten noch einmal. Wenn weiterhin Probleme auftauchen, wenden Sie sich bitte an die Trainer/innen ({$a->teacher}) oder die Administrator/innen der Website.';
$string['paymentthanks'] = 'Vielen Dank für Ihre Zahlung. Sie sind nun im Kurs "{$a}" eingeschrieben.';
$string['pendingrequests'] = 'Ausstehende Kursanfragen';
$string['periodending'] = 'Ende des Zeitraums ({$a})';
$string['personal'] = 'Persönlich';
$string['personalprofile'] = 'Persönliches Profil';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobiltelefon';
$string['phpinfo'] = 'PHP-Informationen';
$string['pictureof'] = 'Nutzerbild {$a}';
$string['pictureofuser'] = 'Nutzerbild';
$string['pleaseclose'] = 'Bitte schließen Sie jetzt dieses Fenster.';
$string['pleasesearchmore'] = 'Bitte suchen Sie weiter';
$string['pleaseusesearch'] = 'Bitte benutzen Sie die Suchfunktion';
$string['plugin'] = 'Plugin';
$string['plugincheck'] = 'Plugin-Prüfung';
$string['pluginchecknotice'] = 'Die folgende Übersicht zeigt alle Module, Blöcke und Filter, die in Ihrer aktuellen Moodle-Installation vorhanden sind. Es ist gekennzeichnet, welche Plugins bei Moodle standardmäßig enthalten sind und welche nicht. Für alle nicht standardmäßigen Plugins sollten Updates durchgeführt werden, falls neuere Versionen verfügbar sind.';
$string['plugindeletefiles'] = 'Alle mit dem Plugin \'{$a->name}\' verknüpften Daten wurden in der Datenbank gelöscht. Um zu verhindern, dass sich das Plugin selbst wieder zurückinstalliert, sollten Sie nun folgendes Verzeichnis von Ihrem Server löschen:  {$a->directory}';
$string['pluginsetup'] = 'Lege Plugin-Tabellen an';
$string['policyaccept'] = 'Ich verstehe den Text und stimme ihm zu';
$string['policyagree'] = 'Lesen Sie diese Zustimmungserklärung sorgfältig. Sie müssen erst zustimmen, um diese Website weiter nutzen zu können. Stimmen Sie zu?';
$string['policyagreement'] = 'Zustimmungserklärung';
$string['policyagreementclick'] = 'Link zur Zustimmungserklärung';
$string['popup'] = 'Popup';
$string['popupwindow'] = 'Datei in neuem Fenster öffnen';
$string['popupwindowname'] = 'Popup-Fenster';
$string['post'] = 'Beitrag';
$string['posts'] = 'Beiträge';
$string['potentialadmins'] = 'Mögliche Administrator/innen';
$string['potentialcreators'] = 'Mögliche Kursersteller/innen';
$string['potentialstudents'] = 'Mögliche Teilnehmer/innen';
$string['potentialteachers'] = 'Mögliche Trainer/innen';
$string['preferences'] = 'Voreinstellungen';
$string['preferredlanguage'] = 'Bevorzugte Sprache';
$string['preferredtheme'] = 'Bevorzugtes Design';
$string['preprocessingbackupfile'] = 'Vorbereitung der Sicherung';
$string['preview'] = 'Vorschau';
$string['previewhtml'] = 'Vorschau im HTML-Format';
$string['previeworchoose'] = 'Vorschau oder Auswahl eines Designs';
$string['previous'] = 'Zurück';
$string['previouslyselectedusers'] = 'Früher gewählte Nutzer passen nicht zu \'{$a}\'';
$string['previoussection'] = 'Vorheriger Bereich';
$string['primaryadminsetup'] = 'Account für Hauptadmin';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Diese Profilbeschreibung wird nicht angezeigt, bis diese Person nicht mindestens in einem Kurs eingeschrieben ist.';
$string['publicprofile'] = 'Öffentliches Profil';
$string['publicsitefileswarning'] = 'Achtung: Jeder könnte die hier befindlichen Dateien herunterladen. <br />Diese Dateien sind nicht vor unberechtigten Zugriffen geschützt.';
$string['publicsitefileswarning2'] = 'Achtung: Jeder könnte die hier befindlichen Dateien herunterladen, der die URL kennt (oder erraten kann). Aus Sicherheitsgründen sollten alle hochgeladenen Kurssicherungen sofort nach der Wiederherstellung gelöscht werden.';
$string['publicsitefileswarning3'] = 'Achtung: Jeder könnte diese Dateien herunterladen, wenn er die URL kennt (oder sie erraten kann). Aus Sicherheitsgründen sollten Kurssicherungen ausschließlich im geschützen Verzeichnis \'backupdata\' liegen.';
$string['publish'] = 'Veröffentlichen';
$string['question'] = 'Frage';
$string['questionsinthequestionbank'] = 'Fragen in der Fragenliste';
$string['readinginfofrombackup'] = 'Informationen der Sicherung lesen';
$string['readme'] = 'README';
$string['recentactivity'] = 'Neueste Aktivitäten';
$string['recentactivityreport'] = 'Alle Aktivitäten der letzten Zeit';
$string['recipientslist'] = 'Empfängerliste';
$string['recreatedcategory'] = 'Wiederhergestellter Kursbereich {$a}';
$string['redirect'] = 'Weiterleiten';
$string['refresh'] = 'Aktualisieren';
$string['refreshingevents'] = 'Termine aktualisieren';
$string['registration'] = 'Moodle-Registrierung';
$string['registrationcontact'] = 'Öffentliche Kontakte';
$string['registrationcontactno'] = 'Nein, kein Kontaktformular bereitstellen';
$string['registrationcontactyes'] = 'Ja, ein Kontaktformular für interessierte Nutzer/innen bereitstellen';
$string['registrationemail'] = 'E-Mail-Mitteilungen';
$string['registrationinfo'] = '<p>Diese Seite ermöglicht es Ihnen, Ihre Website auf moodle.org zu registrieren.
Die Registrierung ist kostenlos.
Der Vorteil besteht darin, dass Sie in einer Mailingliste aufgenommen werden,
um sicherheitsrelevante Informationen und  Nachrichten über neue Versionen zu bekommen.</p>
<p>Standardmäßig werden Ihre Informationen nicht veröffentlicht oder an dritte Personen weitergegeben. Die einzigen Gründe, diese Informationen zu sammeln, sind Supportaspekte sowie der Wunsch, ein Statistik von der Moodle-Community als Gesamtheit abzubilden.</p>
<p>Wenn Sie Ihre Moodle-Website registrieren, können Sie den Seitennamen, das Land und die URL zur öffentlichen Liste der Moodle-Seiten hinzufügen.</p>
<p>Jede neue Registrierung wird manuell geprüft, bevor sie zur Liste hinzugefügt wird. Sie können Ihre Registrierung (und den Eintrag in der öffentlichen Liste) jederzeit aktualisieren, indem Sie dieses Formular erneut absenden.</p>';
$string['registrationinfotitle'] = 'Registrierungsdaten';
$string['registrationno'] = 'Nein, ich möchte keine E-Mails erhalten';
$string['registrationsend'] = 'Registrierung an moodle.org senden';
$string['registrationyes'] = 'Ja, ich möchte wichtige Mitteilungen per E-Mail erhalten';
$string['reject'] = 'Ablehnen';
$string['rejectdots'] = 'Ablehnen...';
$string['reload'] = 'Neu laden';
$string['remoteappuser'] = 'Fernnutzer {$a}';
$string['remove'] = 'Löschen';
$string['removeadmin'] = 'Administrator/in löschen';
$string['removecreator'] = 'Kursersteller/in löschen';
$string['removestudent'] = 'Teilnehmer/in löschen';
$string['removeteacher'] = 'Trainer/in löschen';
$string['rename'] = 'Umbenennen';
$string['renamefileto'] = '<b>{$a}</b> umbenennen in';
$string['report'] = 'Bericht';
$string['reports'] = 'Berichte';
$string['repositories'] = 'Dateiverwaltungssysteme';
$string['requestcourse'] = 'Kurs beantragen';
$string['requestedby'] = 'Antrag von';
$string['requestedcourses'] = 'Beantrage Kurse';
$string['requestreason'] = 'Antragsbegründung';
$string['required'] = 'Erforderlich';
$string['requirespayment'] = 'Dieser Kurs setzt die Zahlung einer Teilnahmegebühr voraus';
$string['reset'] = 'Zurücksetzen';
$string['resetcomponent'] = 'Element';
$string['resetcourse'] = 'Kurs zurücksetzen';
$string['resetinfo'] = 'Diese Seite ermöglicht es Ihnen, nutzerspezifische Daten und Beiträge aus einem gewählten Kurs zu entfernen. Alle anderen Daten (Arbeitsmaterialien, Aktivitäten, Einstellungen) bleiben erhalten.

Achtung: Wenn Sie hier Daten zum Löschen auswählen und Ihre Auswahl bestätigen, werden diese Daten unwiederbringlich aus dem Kurs gelöscht.';
$string['resetnotimplemented'] = 'Zurücksetzen ist nicht vorgesehen';
$string['resetstartdate'] = 'Startdatum zurücksetzen';
$string['resetstatus'] = 'Status';
$string['resettask'] = 'Aufgabe';
$string['resettodefaults'] = 'Auf Grundeinstellungen zurücksetzen';
$string['resortcoursesbyname'] = 'Kurse nach Namen sortieren';
$string['resource'] = 'Arbeitsmaterial';
$string['resourcedisplayauto'] = 'Automatisch';
$string['resourcedisplaydownload'] = 'Download erzwingen';
$string['resourcedisplayembed'] = 'Einbetten';
$string['resourcedisplayframe'] = 'Im Frame';
$string['resourcedisplaynew'] = 'Neues Fenster';
$string['resourcedisplayopen'] = 'Öffnen';
$string['resourcedisplaypopup'] = 'Als Popup-Fenster';
$string['resources'] = 'Arbeitsmaterial';
$string['resources_help'] = 'Arbeitsmaterialien ermöglichen es, nahezu jede Art von Webinhalten in Kursen zuverwenden.';
$string['restore'] = 'Wiederherstellen';
$string['restorecancelled'] = 'Wiederherstellung abgebrochen';
$string['restorecannotassignroles'] = 'Bei der Wiederherstellung sollen Rollen zugewiesen werden, aber Sie sind dazu nicht berechtigt.';
$string['restorecannotcreateorassignroles'] = 'Bei der Wiederherstellung sollen Rollen angelegt oder zugewiesen werden, aber Sie sind dazu nicht berechtigt.';
$string['restorecannotcreateuser'] = 'Bei der Wiederherstellung soll das Nutzerkonto \'{$a}\' aus der Sicherungsdatei angelegt werden, aber Sie sind dazu nicht berechtigt.';
$string['restorecannotoverrideperms'] = 'Bei der Wiederherstellung sollen Rechte geändert werden, aber Sie sind dazu nicht berechtigt.';
$string['restorecoursenow'] = 'Kurs wiederherstellen';
$string['restoredaccount'] = 'Wiederhergestelltes Nutzerkonto';
$string['restoredaccountinfo'] = 'Dieses Nutzerkonto wurde ohne Passwort von einem anderen Server importiert. Um ein neues Passwort per E-Mail zu vergeben, klicken Sie bitte auf "Weiter".';
$string['restorefinished'] = 'Wiederherstellung erfolgreich beendet';
$string['restoreto'] = 'Wiederherstellen in';
$string['restoretositeadding'] = 'Warnung: Sie beabsichtigen, Daten zur Startseite hinzuzufügen!';
$string['restoretositedeleting'] = 'Warnung: Sie beabsichtigen, die Startseite wiederherzustellen und vorher alle vorhandenen Daten zu löschen!';
$string['restoreuserconflict'] = 'Der Versuch, das Nutzerkonto \'{$a}\' wiederherzustellen, wird Probleme bereiten';
$string['restoreuserinfofailed'] = 'Die Wiederherstellung des Kurses wurde abgebrochen, weil Sie kein Recht zur Wiederherstellung von Nutzerdaten haben.';
$string['restoreusersprecheck'] = 'Nutzerdaten prüfen';
$string['restoreusersprecheckerror'] = 'Bei der Prüfung der Nutzerdaten wurden Probleme erkannt';
$string['restricted'] = 'Eingeschränkt';
$string['restrictmodules'] = 'Aktivitätsmodule einschränken';
$string['returningtosite'] = 'Zur Nutzung ist ein Login notwendig';
$string['returntooriginaluser'] = 'Zurück zu {$a}';
$string['revert'] = 'Zurücksetzen';
$string['role'] = 'Rolle';
$string['rolemappings'] = 'Rollenplanungen';
$string['rolerenaming'] = 'Umbenennen der Rolle';
$string['rolerenaming_help'] = 'Mit dieser Option können die Namen der Rollen in Ihrem Kurs umbenannt werden. Wenn Sie z.B. \'Trainer/in\' in \'Dozent/in\' für den aktuellen Kurs umbenennen wollen, tragen Sie dies hier ein. Die Rollenberechtigungen werden durch das Umbenennen nicht verändert. Die geänderten Rollenbezeichnungen sind in der Nutzerliste  und an anderen Stellen des Kurses zu sehen. Ist die umbenannte Rolle eine Kursverwalterrolle, dann wird der neue Rollenname ebenso in der Kursliste angezeigt.';
$string['roles'] = 'Rollen';
$string['rss'] = 'RSS-Feeds';
$string['rssarticles'] = 'Zahl neuer RSS-Artikel';
$string['rsserror'] = 'Fehler beim Lesen der RSS-Daten';
$string['rsserrorauth'] = 'Der RSS-Link enthält kein gültiges Authentifizierungstoken.';
$string['rsserrorguest'] = 'Dieser Feed verwendet den Gastzugang für den Datenzugriff. Gäste haben jedoch keine Leserechte für die Inhalte. Gehen Sie nochmals als berechtigter Nutzer  zur Herkunftsseite für den Feed (URL) und rufen Sie  den RSS Feed erneut von dort auf.';
$string['rsstype'] = 'RSS-Feeds für diese Aktivität';
$string['saveandnext'] = 'Speichern und nächste anzeigen';
$string['savechanges'] = 'Änderungen speichern';
$string['savechangesanddisplay'] = 'Speichern und Vorschau';
$string['savechangesandreturntocourse'] = 'Speichern und zum Kurs';
$string['savecomment'] = 'Kommentar speichern';
$string['savedat'] = 'Gesichert unter:';
$string['savepreferences'] = 'Einstellungen speichern';
$string['saveto'] = 'Speichern in';
$string['scale'] = 'Bewertungsskala';
$string['scale_help'] = '<h2>Bewertungsskalen</h2>
<p>Dozent/innen können neue Bewertungskalen erstellen, die
in allen Bewertungsaktivitäten eingesetzt werden können.</p>
<p>Der Name der Skala sollte ein einfacher Satz oder Begriff
sein, der den Charakter eindeutig beschreibt: Er wird in
Auswahllisten und in der Kontexthilfe verwandt.</p>
<p>Die Skala wird durch eine geordnete Liste von Werten
definiert, die vom negativen zum positiven Wert geordnet ist. Die
einzelnen Werte werden durch Kommas getrennt. Zum Beispiel:</p>
<blockquote><i>enttäuschend, nicht gut genug,
durschnittlich, gut, sehr gut, ausgezeichnet!</i></blockquote>
<p>Skalen sollten eine gute Beschreibung ihrer Bedeutung und
ihrer Verwendung beinhalten, denn sie (die Beschreibung) wird auch in
Hilfeseiten für Trainer/innen und Teilnehmer/innen verwendet.</p>
<p>Am Schluss haben Sie eine oder mehrere
Standard-Bewertungsskalen auf der Systemverwaltungsseite
festgelegt, die in allen Kursen genutzt werden können.</p>';
$string['scales'] = 'Bewertungsskalen';
$string['scalescustom'] = 'Nutzerdefinierte Bewertungsskalen';
$string['scalescustomcreate'] = 'Neue Bewertungsskala anlegen';
$string['scalescustomno'] = 'Es wurden noch keine nutzerdefinierten Bewertungsskalen angelegt.';
$string['scalesstandard'] = 'Standard-Bewertungsskalen';
$string['scalestandard'] = 'Standard-Bewertungsskala';
$string['scalestandard_help'] = '<h2>Standardbewertungsskala</h2>
<p>Eine Standardbewertungsskala steht in jedem Kurs zur Verfügung. Im Unterschied dazu kursspezifische Bewertungsskala.</p>';
$string['scalestip'] = 'Um nutzerdefinierte Bewertungsskalen anzulegen, benutzen Sie bitte den Link \'Bewertungsskalen\' im Administrationsblock des Kurses.';
$string['scalestip2'] = 'Zur Erstellung eigener Bewertungsskalen wählen Sie im Administrationsblock des Kurses \'Bewertungen\' und dann \'Aktion auswählen \'Bewertungsskalen\'.';
$string['schedule'] = 'Planung';
$string['screenreaderno'] = 'Nein';
$string['screenreaderuse'] = 'Screenreader';
$string['screenreaderuse_help'] = 'Mit der Einstellung \'Ja\' wird ein barrierefreies Interfaces im Chat und an anderen Stellen verwendet.';
$string['screenreaderyes'] = 'Ja';
$string['screenshot'] = 'Bildschirmfoto';
$string['search'] = 'Suchen';
$string['searchagain'] = 'Erneut suchen';
$string['searchbyemail'] = 'Über die E-Mail-Adresse suchen';
$string['searchbyusername'] = 'Über den Anmeldenamen suchen';
$string['searchcourses'] = 'Kurse suchen';
$string['searchhelp'] = 'Sie können nach mehreren Begriffen gleichzeitig suchen.

Begriff: findet jeden Treffer des Begriffs im gesamten Text

+Begriff: nur exakte Treffer werden gefunden

-Begriff: schließt Ergebnisse, die diesen Begriff enthalten, aus den Treffern aus';
$string['search_help'] = 'Einfache Suche von einem oder mehreren Wörtern, die im Text vorkommen. Zwischen den Suchwörtern bitte Leerzeichen eingeben. Gesuchte Begriffe müssen mindestens drei Zeichen lang sein. ';
$string['searchoptions'] = 'Suchoptionen';
$string['searchresults'] = 'Suchergebnisse';
$string['sec'] = 'Sekunde';
$string['seconds'] = 'Sekunden';
$string['secondstotime172800'] = '2 Tage';
$string['secondstotime259200'] = '3 Tage';
$string['secondstotime345600'] = '4 Tage';
$string['secondstotime432000'] = '5 Tage';
$string['secondstotime518400'] = '6 Tage';
$string['secondstotime604800'] = '1 Woche';
$string['secondstotime86400'] = '1 Tag';
$string['secretalreadyused'] = 'Der Link zur Passwortbestätigung wurde bereits benutzt. Das Passwort wurde nicht geändert.';
$string['secs'] = 'Sekunden';
$string['section'] = 'Abschnitt';
$string['sectionname'] = 'Abschnittsname';
$string['sections'] = 'Abschnitte';
$string['sectionusedefaultname'] = 'Standardmäßigen Abschnittsnamen verwenden';
$string['seealsostats'] = 'Siehe auch: Statistiken';
$string['select'] = 'Auswählen';
$string['selectacountry'] = 'Land auswählen';
$string['selectall'] = 'Alle auswählen';
$string['selectamodule'] = 'Wählen Sie bitte ein Aktivitätsmodul aus';
$string['selectaregion'] = 'Wählen Sie eine Region aus';
$string['selectdefault'] = 'Standard auswählen';
$string['selectedfile'] = 'Ausgewählte Datei';
$string['selectednowmove'] = '{$a} Datei(en) zum Verschieben ausgewählt. Wechseln Sie jetzt in das Zielverzeichnis und klicken Sie auf \'Hierhin verschieben\'.';
$string['selectfiles'] = 'Dateien auswählen';
$string['selectnos'] = 'Alle mit \'Nein\' auswählen';
$string['selectperiod'] = 'Zeitraum auswählen';
$string['senddetails'] = 'Meine Daten per E-Mail zusenden';
$string['separate'] = 'Getrennt';
$string['separateandconnected'] = 'Anwendung von Einzelfakten oder ganzheitliche Wissensnutzung';
$string['separateandconnectedinfo'] = 'Die Skala basiert  oder Theorie von sachbezogenem, isoliertem und vernetztem beziehungsorientiertem Denken (Belenky). Die Theorie beschreibt zwei unterschiedliche Wege wie wir Lernen und Evaluieren können. <ul> <li><<strong>Getrennt/isoliert Denkende</strong> versuchen so objektiv wie möglich zu bleiben und Gefühle und Emotionen nicht zu berücksichtigen. In einer Diskussion mit anderen verteidigen Sie ihre Ideen und analysieren logisch die Ideen der anderen, um darin Löcher zu finden.   </li><li> <strong>Vernetzt, beziehungsorientiert Denkende</strong> sind sehr empfindsam gegenüber anderen Menschen. Sie sind gut trainiert, Empathie zu zeigen, anderen zuzuhören und Fragen zu stellen. Sie stellen eine Verbindung zu anderen her und können sich in deren Standpunkt hineinversetzen. Sie lernen durch den Austausch von Erfahrungen und das führt sie zu dem Wissen anderer Menschen. </li></ul>';
$string['serverlocaltime'] = 'Lokale Serverzeit';
$string['setcategorytheme'] = 'Kategoriedesign festlegen';
$string['settings'] = 'Einstellungen';
$string['shortname'] = 'Kurzbezeichnung';
$string['shortnamecollisionwarning'] = '[*] = Diese Kurzbezeichnung wird bereits für einen anderen Kurs genutzt. Bitte ändern Sie den Eintrag.';
$string['shortnamecourse'] = 'Kursname (kurz)';
$string['shortnamecourse_help'] = '<h2>Kurzbezeichnung des Kurses</h2>

<p>Viele Institutionen haben bereits Kurzbezeichnungen für Ihre Kurse, z.B. BP102 oder COMMS. Selbst wenn es eine solche Kurzbezeichnung für Ihren Kurs noch nicht gibt, überlegen Sie sich eine sinnvolle Bezeichnung und tragen Sie diese hier ein.</p>

<p>Die Kurzbezeichnung wird an verschiedenen Stellen genutzt, an der der vollständige Kursname nicht angebracht ist (z.B. in der Betreff-Zeile bei E-Mails).</p>';
$string['shortnametaken'] = 'Die Kurzbezeichnung wird bereits für einen anderen Kurs ({$a}) verwendet.';
$string['shortnameuser'] = 'Nutzername (kurz)';
$string['shortsitename'] = 'Kurzbezeichnung';
$string['show'] = 'Anzeigen';
$string['showactions'] = 'Aktivitäten anzeigen';
$string['showadvancedsettings'] = 'Optionale Felder anzeigen';
$string['showall'] = 'Alle {$a} anzeigen';
$string['showallcourses'] = 'Alle Kurse anzeigen';
$string['showalltopics'] = 'Alle Themen anzeigen';
$string['showallusers'] = 'Alle Nutzer/innen anzeigen';
$string['showallweeks'] = 'Alle Wochen anzeigen';
$string['showblockcourse'] = 'Liste der Kurse anzeigen, in der dieser Block genutzt wird';
$string['showcomments'] = 'Kommentare sichtbar/verbergen';
$string['showcommentsnonjs'] = 'Kommentare anzeigen';
$string['showgrades'] = 'Bewertungen anzeigen';
$string['showgrades_help'] = 'Viele Kursaktivitäten ermöglichen es, Bewertungen zu erteilen. Diese Einstellung legt fest, ob Teilnehmer/innen eine Übersicht mit allen ihren Bewertungen über den Block \'Kursadministration\' anzeigen lassen können.';
$string['showlistofcourses'] = 'Kursliste anzeigen';
$string['showmodulecourse'] = 'Liste der Kurse anzeigen, in der diese Aktivität genutzt wird';
$string['showonly'] = 'Nur anzeigen';
$string['showonlytopic'] = 'Nur Thema {$a} anzeigen';
$string['showonlyweek'] = 'Nur Woche {$a} anzeigen';
$string['showperpage'] = '{$a} pro Seite anzeigen';
$string['showrecent'] = 'Neue Aktivitäten anzeigen';
$string['showreports'] = 'Aktivitätsberichte';
$string['showreports_help'] = 'Aktivitätsberichte sind für alle Teilnehmer/innen verfügbar und zeigen deren eigenen Aktivitäten im Kurs an (Forenbeiträge, Aufgabenabgabe, Kommentare, Kurszugriffe, usw.). Diese Einstellung legt fest, ob Teilnehmer/innen ihre eigenen Aktivitätsberichte über ihre Profilseite sehen können.';
$string['showsettings'] = 'Einstellungen anzeigen';
$string['showtheselogs'] = 'Diese Logdaten anzeigen';
$string['showthishelpinlanguage'] = 'Anzeige dieser Hilfe in der Sprache: {$a}';
$string['showtopicfromothers'] = 'Themenfeld anzeigen';
$string['showweekfromothers'] = 'Woche anzeigen';
$string['since'] = 'Seit';
$string['sincelast'] = 'seit dem letzten Login';
$string['site'] = 'Website';
$string['sitedefault'] = 'Grundeinstellung';
$string['siteerrors'] = 'Fehler der Website';
$string['sitefiles'] = 'Dateien';
$string['sitefilesused'] = 'In diesem Kursen benutzte Dateien der Website';
$string['sitehome'] = 'Website-Start';
$string['sitelegacyfiles'] = 'Alte Kursdateien';
$string['sitelogs'] = 'Logdaten der Website';
$string['sitenews'] = 'Nachrichten der Website';
$string['sitepages'] = 'Website';
$string['sitepartlist'] = 'Sie besitzen nicht die notwendigen Rechte, um die Teilnehmerliste zu sehen.';
$string['sitepartlist0'] = 'Sie müssen Trainerrechte für die Startseite besitzen, um die vollständige Nutzerliste der Website sehen zu können.';
$string['sitepartlist1'] = 'Sie müssen Trainerrechte besitzen, um die vollständige Nutzerliste der Website sehen zu können.';
$string['sites'] = 'Seiten';
$string['sitesection'] = 'Themenbereich einbeziehen';
$string['sitesettings'] = 'Einstellungen der Website';
$string['siteteachers'] = 'Trainer/innen für die Website';
$string['size'] = 'Größe';
$string['sizeb'] = 'Bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Übersprungen';
$string['skypeid'] = 'Skype';
$string['socialheadline'] = 'Soziales Forum - neue Themen';
$string['someallowguest'] = 'Einige Kurse sind für Gäste zugelassen';
$string['someerrorswerefound'] = 'Eine Information fehlte oder war unzutreffend. Beachten Sie die Hinweise weiter unten.';
$string['sortby'] = 'Sortiert nach';
$string['sortbyx'] = 'Sortierung nach {$a} aufsteigend';
$string['sortbyxreverse'] = 'Sortierung nach {$a} absteigend';
$string['sourcerole'] = 'Ausgangsrolle';
$string['specifyname'] = 'Sie müssen einen Namen festlegen';
$string['standard'] = 'standardmäßig';
$string['starpending'] = '([*] = Kursantrag in Bearbeitung)';
$string['startdate'] = 'Kursbeginn';
$string['startdate_help'] = 'Wenn Sie im Kurs das Wochen-Format benutzen, definiert die Einstellung den ersten Tag der ersten angezeigten Woche im Kurs dar.
Außerdem legt diese Einstellung fest, ab welchem Datum Berichte über Aktivitäten im Kurs angezeigt werden können.';
$string['startingfrom'] = 'Beginn von';
$string['startsignup'] = 'Neuen Zugang anlegen?';
$string['state'] = 'Bundesland/Kanton';
$string['statistics'] = 'Statistiken';
$string['statisticsgraph'] = 'Grafische Darstellung';
$string['stats'] = 'Statistiken';
$string['statslogins'] = 'Logins';
$string['statsmodedetailed'] = 'Detailansicht der Nutzer/innen';
$string['statsmodegeneral'] = 'Übersicht';
$string['statsnodata'] = 'Es gibt keine Daten für diese Kombination aus Kurs und Zeitraum.';
$string['statsnodatauser'] = 'Es gibt keine Daten für die Kombination aus Kurs, Nutzer/in und Zeitraum.';
$string['statsoff'] = 'Statistiken sind zur Zeit nicht aktiviert.';
$string['statsreads'] = 'Anzeigen';
$string['statsreport1'] = 'Logins';
$string['statsreport10'] = 'Aktivitäten der Nutzer/innen';
$string['statsreport11'] = 'Aktivste Kurse';
$string['statsreport12'] = 'Aktivste Kurse (gewichtet)';
$string['statsreport13'] = 'Aktivste Kurse (höchste Teilnehmerzahl)';
$string['statsreport14'] = 'Aktivste Kurse (Zugriffe und Beiträge)';
$string['statsreport2'] = 'Zugriffe (alle Rollen)';
$string['statsreport3'] = 'Beiträge (alle Rollen)';
$string['statsreport4'] = 'Alle Aktivitäten (Trainer/innen und Teilnehmer/innen)';
$string['statsreport5'] = 'Alle Aktivitäten (Zugriffe und Beiträge)';
$string['statsreport7'] = 'Nutzeraktivitäten (Zugriffe und Beiträge)';
$string['statsreport8'] = 'Alle Nutzeraktivitäten';
$string['statsreport9'] = 'Logins (Website)';
$string['statsreportactivity'] = 'Alle Aktivitäten (alle Rollen)';
$string['statsreportactivitybyrole'] = 'Alle Aktivitäten (lesend und schreibend)';
$string['statsreportforuser'] = 'für';
$string['statsreportlogins'] = 'Logins';
$string['statsreportreads'] = 'Zugriffe (alle Rollen)';
$string['statsreporttype'] = 'Berichtsform';
$string['statsreportwrites'] = 'Beiträge (alle Rollen)';
$string['statsstudentactivity'] = 'Aktivitäten der Teilnehmer/innen';
$string['statsstudentreads'] = 'Teilnehmerzugriffe';
$string['statsstudentwrites'] = 'Beiträge der Teilnehmer/innen';
$string['statsteacheractivity'] = 'Aktivitäten der Trainer/innen';
$string['statsteacherreads'] = 'Trainerzugriffe';
$string['statsteacherwrites'] = 'Beiträge der Trainer/innen';
$string['statstimeperiod'] = 'Zeitraum/-dauer:';
$string['statsuniquelogins'] = 'Einmalige Logins';
$string['statsuseractivity'] = 'Alle Aktionen';
$string['statsuserlogins'] = 'Logins';
$string['statsuserreads'] = 'Zugriffe';
$string['statsuserwrites'] = 'Beiträge';
$string['statswrites'] = 'Beiträge';
$string['status'] = 'Status';
$string['stringsnotset'] = 'Folgende Zeichenketten sind nicht in {$a} definiert:';
$string['studentnotallowed'] = 'Sie können diesen Kurs nicht als \'{$a}\' betreten.';
$string['students'] = 'Teilnehmer/innen';
$string['studentsandteachers'] = 'Teilnehmer/innen und Trainer/innen';
$string['subcategories'] = 'Kursunterbereiche';
$string['submit'] = 'Speichern';
$string['success'] = 'erfolgreich';
$string['summary'] = 'Beschreibung';
$string['summary_help'] = '<h2>Themen-/Wochenzusammenfassungen</h2>
<p>Die Themenzusammenfassung sollte aus einem sehr
kurzen Text bestehen, der die Kursteilnehmer/innen auf die Tätigkeiten
innerhalb dieses Themas (oder der Woche) vorbereitet.</p>
<p>Die Zusammenfassung sollte sehr kurz sein, damit die
Kursseite nicht zu lang wird.</p>
<p>Wenn Sie meinen, mehr sagen zu müssen als ein, zwei
Sätze, dann fügen Sie stattdessen eine Arbeitsunterlage zu diesem
Thema bei.</p>';
$string['summaryof'] = 'Beschreibung von {$a}';
$string['supplyinfo'] = 'Weitere Angaben';
$string['switchrolereturn'] = 'Zu meiner Ausgangsrolle zurückkehren';
$string['switchroleto'] = 'Rolle wechseln...';
$string['tag'] = 'Element';
$string['tagalready'] = 'Dieses Element gibt es bereits';
$string['tagmanagement'] = 'Elemente hinzufügen/löschen';
$string['tags'] = 'Schlagworte';
$string['targetrole'] = 'Zielrolle';
$string['teacheronly'] = 'nur für {$a}';
$string['teacherroles'] = '{$a} Rollen';
$string['teachers'] = 'Trainer/innen';
$string['textediting'] = 'Texte bearbeiten';
$string['texteditor'] = 'Standard-Web-Formulare benutzen';
$string['textformat'] = 'Reines Textformat';
$string['thanks'] = 'Danke';
$string['theme'] = 'Design';
$string['themes'] = 'Designs';
$string['themesaved'] = 'Neues Design gespeichert';
$string['thereareno'] = 'Es gibt keine {$a} in diesem Kurs';
$string['thiscategorycontains'] = 'Dieser Kursbereich enthält';
$string['time'] = 'Zeit';
$string['timezone'] = 'Zeitzone';
$string['to'] = 'Bis';
$string['tocreatenewaccount'] = 'Kontoerstellung abbrechen';
$string['today'] = 'Heute';
$string['todaylogs'] = 'Heutige Logdaten';
$string['toeveryone'] = 'Für alle';
$string['toomanybounces'] = 'Mit dieser E-Mail-Adresse sind zu viele Fehler aufgetreten. Sie <b>müssen</b> die E-Mail-Adresse ändern, um fortzufahren.';
$string['toomanytoshow'] = 'Zu viele Nutzer/innen, um alle anzuzeigen';
$string['toomanyusersmatchsearch'] = 'Zu viele Nutzer/innen ({$a->count}) passen zu \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Zu viele Nutzer/innen ({$a}), um alle anzuzeigen';
$string['toonly'] = 'Nur für {$a}';
$string['top'] = 'Oben';
$string['topic'] = 'Thema';
$string['topichide'] = 'Dieses Thema vor {$a} verbergen';
$string['topicoutline'] = 'Kursthemen';
$string['topicshow'] = 'Dieses Thema für {$a} anzeigen';
$string['total'] = 'Insgesamt';
$string['trackforums'] = 'Forenbeiträge markieren';
$string['trackforumsno'] = 'Nein, keine Beiträge markieren';
$string['trackforumsyes'] = 'Ja, neue Beiträge farblich markieren';
$string['trysearching'] = 'Suchfunktion dafür verwenden';
$string['turneditingoff'] = 'Bearbeiten ausschalten';
$string['turneditingon'] = 'Bearbeiten einschalten';
$string['undecided'] = 'unbestimmt';
$string['unfinished'] = 'Noch nicht abgeschlossen';
$string['unknowncategory'] = 'Unbekannter Kursbereich';
$string['unlimited'] = 'Unbegrenzt';
$string['unpacking'] = 'Entpacke {$a}';
$string['unsafepassword'] = 'Unsicheres Kennwort - wählen Sie ein anderes!';
$string['untilcomplete'] = 'Bis zum Abschluss des Prozesses';
$string['unusedaccounts'] = 'Kurszugänge werden automatisch gelöscht, wenn sie mehr als {$a} Tage lang nicht benutzt wurden.';
$string['unzip'] = 'Entpacken';
$string['unzippingbackup'] = 'Sicherung entpacken';
$string['up'] = 'Aufwärts';
$string['update'] = 'Aktualisieren';
$string['updated'] = '{$a} aktualisiert';
$string['updatemymoodleoff'] = 'Anpassen dieser Seite beenden.';
$string['updatemymoodleon'] = 'Diese Seite anpassen';
$string['updatemyprofile'] = 'Profil aktualisieren';
$string['updatesevery'] = 'Aktualisiere alle {$a} Sekunden';
$string['updatethis'] = '{$a} bearbeiten';
$string['updatethiscourse'] = 'Diesen Kurs bearbeiten';
$string['updatinga'] = '{$a} bearbeiten';
$string['updatingain'] = '{$a->what} in {$a->in} bearbeiten';
$string['upload'] = 'Hochladen';
$string['uploadafile'] = 'Datei hochladen';
$string['uploadcantwrite'] = 'Das Schreiben der Datei ist fehlgeschlagen';
$string['uploadedfile'] = 'Die Datei wurde erfolgreich hochgeladen';
$string['uploadedfileto'] = '{$a->file} hochgeladen in {$a->directory}';
$string['uploadedfiletoobig'] = 'Die Datei ist zu groß (maximal {$a} Bytes)';
$string['uploadextension'] = 'Datei-Upload wurde wegen der Dateiendung angehalten';
$string['uploadfailednotrecovering'] = 'Beim Hochladen ist ein Problem mit einer der Dateien {$a->name} aufgetreten.<br />Folgende Fehlermeldung ist aufgetreten:<br />{$a->problem}<br/>
Das Hochladen wurde erfolglos abgebrochen.';
$string['uploadfilelog'] = 'Upload-Log für Datei {$a}';
$string['uploadformlimit'] = 'Die hochzuladene Datei ist größer als zulässig';
$string['uploadlabel'] = 'Titel:';
$string['uploadnewfile'] = 'Neue Datei hochladen';
$string['uploadnofilefound'] = 'Es wurde keine Datei gefunden. Sind Sie sicher, dass Sie eine Datei zum Hochladen ausgewählt haben?';
$string['uploadnotallowed'] = 'Das Hochladen von Dateien ist nicht erlaubt';
$string['uploadnotempdir'] = 'Temporäres Dateiverzeichnis fehlt';
$string['uploadoldfilesdeleted'] = 'Die alte(n) Datei(en) in Ihrem Upload-Bereich wurden gelöscht';
$string['uploadpartialfile'] = 'Die Datei wurde unvollständig hochgeladen';
$string['uploadproblem'] = 'Ein unbekanntes Problem ist beim Hochladen der Datei \'{$a}\' aufgetreten (war sie vielleicht zu groß?)';
$string['uploadrenamedchars'] = 'Die Datei wurde von {$a->oldname} nach {$a->newname} umbenannt, weil der Dateiname ungültige Zeichen enthielt.';
$string['uploadrenamedcollision'] = 'Die Datei wurde von {$a->oldname} nach {$a->newname} umbenannt, weil bereits eine andere Datei mit dem gleichen Dateinamen existierte.';
$string['uploadserverlimit'] = 'Die hochzuladene Datei ist größer als vom Server zugelassen';
$string['uploadthisfile'] = 'Datei hochladen';
$string['url'] = 'URL';
$string['used'] = 'Verwendet';
$string['usedinnplaces'] = 'An {$a} Stellen verwendet';
$string['useforlegacytheme'] = 'Für alte Browser';
$string['useformaintheme'] = 'Für moderne Browser';
$string['usemessageform'] = 'oder verwenden Sie das untenstehende Formular, um eine Mitteilung an die ausgewählten Teilnehmer/innen zu versenden';
$string['user'] = 'Nutzer';
$string['userconfirmed'] = '{$a} bestätigt';
$string['usercurrentsettings'] = 'Mein Profil';
$string['userdata'] = 'Nutzerdaten';
$string['userdeleted'] = 'Dieser Nutzerzugang wurde gelöscht';
$string['userdescription'] = 'Beschreibung';
$string['userdescription_help'] = 'Dieses Feld ermöglicht, einen persönlichen Text einzugeben, der in Ihrem Nutzerprofil angezeigt wird.';
$string['userdetails'] = 'Mehr Details';
$string['userfiles'] = 'Nutzerdateien';
$string['userlist'] = 'Nutzerliste';
$string['username'] = 'Anmeldename';
$string['usernameemailmatch'] = 'Anmeldename und E-Mail-Adresse passen nicht zusammen!';
$string['usernameexists'] = 'Der Anmeldename ist bereits vergeben';
$string['usernamelowercase'] = 'Es sind ausschließlich Kleinbuchstaben erlaubt';
$string['usernamenotfound'] = 'Der Anmeldename wurde nicht in der Datenbank gefunden.';
$string['usernameoremail'] = 'Geben Sie den Anmeldenamen oder die E-Mail-Adresse ein';
$string['usernotconfirmed'] = '{$a} konnte nicht bestätigt werden';
$string['userpic'] = 'Nutzerbild';
$string['users'] = 'Nutzer/innen';
$string['userselectorautoselectunique'] = 'Wenn nur ein/e Nutzer/in zur Suche passt, wähle diesen automatisch.';
$string['userselectorpreserveselected'] = 'Verwerfe ausgewählte Nutzer/innen, wenn sie nicht mehr zur Suche passen.';
$string['userselectorsearchanywhere'] = 'Vergleiche den Suchtext irgendwo im Namen des Benutzers';
$string['usersnew'] = 'Neue Nutzer/innen';
$string['usersnoaccesssince'] = 'Nutzer/innen anzeigen, deren Inaktivität länger dauert als';
$string['userswithfiles'] = 'Nutzer/innen mit Dateien';
$string['useruploadtype'] = 'Art des Nutzeruploads';
$string['userviewingsettings'] = 'Profil von {$a}';
$string['userzones'] = 'Nutzerzonen';
$string['usingexistingcourse'] = 'Vorhandenen Kurs benutzen';
$string['valuealreadyused'] = 'Dieser Wert wurde bereits benutzt.';
$string['version'] = 'Version';
$string['view'] = 'Zugriff';
$string['viewallcourses'] = 'Alle Kurse zeigen';
$string['viewallcoursescategories'] = 'Alle Kurse und Kategorien zeigen';
$string['viewfileinpopup'] = 'Datei in Popup-Fenster anzeigen';
$string['viewprofile'] = 'Profil anzeigen';
$string['views'] = 'Zugriffe';
$string['viewsolution'] = 'Lösung anzeigen';
$string['virusfound'] = 'Achtung! ClamAV hat einen Virus in der Datei von Nutzer/in {$a->user} im Kurs {$a->course} gefunden. Bericht von ClamAV:';
$string['virusfoundlater'] = 'Die Datei mit dem Namen {$a->filename}, hochgeladen am {$a->date} im Kurs {$a->course}, kann einen Virus enthalten. Hier ist eine Information, was mit der Datei passiert ist:<br />
{$a->action}

Falls es sich um eine wichtige Datei handelt, die Ihre Trainer/innen erhalten sollte, müssen Sie die Datei evtl. erneut hochladen.';
$string['virusfoundlateradmin'] = 'Achtung!! Die Datei mit dem Namen {$a->filename}, hochgeladen am {$a->date} im Kurs {$a->course} von {$a->user}, kann einen Virus enthalten. Hier ist eine Information, was mit der Datei passiert ist:<br />
{$a->action}

Eine Nutzernachricht wurde ebenfalls versandt.';
$string['virusfoundlateradminnolog'] = 'Achtung!! Eine Datei mit dem Namen {$a->filename} kann einen Virus enthalten.
Moodle konnte nicht zurückverfolgen, wer diese Datei hochgeladen hat. Hier ist eine  Information, was mit der Datei passiert ist:<br />
{$a->action}';
$string['virusfoundsubject'] = '{$a}: Virus gefunden!';
$string['virusfounduser'] = 'Die von Ihnen hochgeladene Datei {$a->filename} wurde von einem Virenschutzprogramm geprüft und scheint infiziert zu sein. Das Hochladen der Datei war nicht erfolgreich.';
$string['virusplaceholder'] = 'Die hochgeladene Datei ist virenverdächtig. Die Datei wurde verschoben oder gelöscht. Eine Nutzernachricht wurde versandt.';
$string['visible'] = 'Sichtbar';
$string['visibletostudents'] = 'Sichtbar für {$a}';
$string['warningdeleteresource'] = 'Hinweis: Auf {$a} wird in einem Arbeitsmaterial Bezug genommen. Wollen Sie das Arbeitsmaterial aktualisieren?';
$string['webpage'] = 'Webseite';
$string['week'] = 'Woche';
$string['weekhide'] = 'Diese Woche vor {$a} verbergen';
$string['weeklyoutline'] = 'Kursthemen';
$string['weekshow'] = 'Diese Woche für {$a} anzeigen';
$string['welcometocourse'] = 'Willkommen zu {$a}';
$string['welcometocoursetext'] = 'Willkommen im Kurs \'{$a->coursename}\'!

Falls Sie es nicht bereits erledigt haben, sollten Sie Ihr persönliches Nutzerprofil bearbeiten. Auf diese Weise können wir alle mehr über Sie erfahren und besser zusammenarbeiten:

{$a->profileurl}';
$string['whattocallzip'] = 'Wie möchten Sie die ZIP-Datei benennen?';
$string['whattodo'] = 'Was ist zu tun';
$string['windowclosing'] = 'Dieses Fenster sollte sich automatisch schließen - falls nicht, dann tun Sie es jetzt';
$string['withchosenfiles'] = 'Mit ausgewählten Dateien';
$string['withoutuserdata'] = 'Ohne Nutzerdaten';
$string['withselectedusers'] = 'Mit ausgewählten Nutzer/innen ...';
$string['withselectedusers_help'] = '* Nachricht senden - Nachricht wird an die ausgewählten Teilnehmer/innen verschickt
* Notiz hinzufügen - Notiz wird bei der ausgewählten Person hinzugefügt
* Notiz hinzufügen (mehrere) - Notiz wird identisch bei mehreren Personen hinzugefügt';
$string['withuserdata'] = 'Mit Nutzerdaten';
$string['wordforstudent'] = 'Bezeichnung für Teilnehmer/in';
$string['wordforstudenteg'] = 'z.B. Student/in, Schüler/in usw.';
$string['wordforstudents'] = 'Bezeichnung für Teilnehmer/innen';
$string['wordforstudentseg'] = 'z.B. Student/innen, Schüler/innen usw.';
$string['wordforteacher'] = 'Bezeichnung für Trainer/in';
$string['wordforteachereg'] = 'z.B. Lehrer/in, Berater/in, Moderator/in usw.';
$string['wordforteachers'] = 'Bezeichnung für Trainer/innen';
$string['wordforteacherseg'] = 'z.B. Lehrer/innen, Berater/innen, Moderator/innen usw.';
$string['writingblogsinfo'] = 'Bloginformationen werden geschrieben';
$string['writingcategoriesandquestions'] = 'Kategorien und Fragen schreiben';
$string['writingcoursedata'] = 'Kursdaten schreiben';
$string['writingeventsinfo'] = 'Termininformationen schreiben';
$string['writinggeneralinfo'] = 'Allgemeine Informationen schreiben';
$string['writinggradebookinfo'] = 'Bewertungsinformationen schreiben';
$string['writinggroupingsgroupsinfo'] = 'Gruppierungs-/Gruppeninformation schreiben';
$string['writinggroupingsinfo'] = 'Gruppierungsinformation schreiben';
$string['writinggroupsinfo'] = 'Gruppeninformation schreiben';
$string['writingheader'] = 'Header schreiben';
$string['writingloginfo'] = 'Logdaten werden geschrieben';
$string['writingmessagesinfo'] = 'Informationen über Mitteilungen schreiben';
$string['writingmoduleinfo'] = 'Modulinformationen schreiben';
$string['writingscalesinfo'] = 'Bewertungsskaleninformation schreiben';
$string['writinguserinfo'] = 'Nutzerinformationen schreiben';
$string['wrongpassword'] = 'Falsches Kennwort für diesen Anmeldenamen';
$string['xmldbeditor'] = 'XMLDB-Editor';
$string['yahooid'] = 'Yahoo!';
$string['year'] = 'Jahr';
$string['years'] = 'Jahre';
$string['yes'] = 'Ja';
$string['youareabouttocreatezip'] = 'Sie sind dabei, eine ZIP-Datei mit diesem Inhalt anzulegen';
$string['youaregoingtorestorefrom'] = 'Sie sind dabei, die Wiederherstellung zu starten von:';
$string['youneedtoenrol'] = 'Um diese Aktion auszuführen, müssen Sie sich in diesen Kurs eintragen.';
$string['yourlastlogin'] = 'Ihr letztes Login war';
$string['yourself'] = 'sich selbst';
$string['yourteacher'] = '{$a}';
$string['yourwordforx'] = 'Ihre Bezeichnung für \'{$a}\'';
$string['zippingbackup'] = 'Sicherung komprimieren';
