<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'de', branch 'MOODLE_20_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'Screenshots hinzufügen';
$string['advertise'] = 'Diesen Kurs anbieten, damit sich Personen anmelden können';
$string['advertised'] = 'Angeboten';
$string['advertiseon'] = 'Diesen Kurs anbieten auf {$a}';
$string['advertiseonhub'] = 'Diesen Kurs auf einem Hub anbieten';
$string['advertiseonmoodleorg'] = 'Diesen Kurs auf moodle.org anbieten';
$string['advertisepublication_help'] = 'Wenn Sie Ihren Kurs auf einem Hub anbieten, können andere Personen aus der Community diesen Kurs finden und sich dort einschreiben.';
$string['all'] = 'Alles';
$string['allowglobalsearch'] = 'Diesen Hub veröffentlichen und die globale Suche aller Kurse erlauben';
$string['allowpublicsearch'] = 'Diesen Hub veröffentlichen, damit sich Personen anmelden können.';
$string['audience'] = 'Adressaten';
$string['audienceadmins'] = 'Administrator/innen';
$string['audienceeducators'] = 'Unterrichtende';
$string['audience_help'] = 'Angestrebte Zielgruppe des Kurses';
$string['audiencestudents'] = 'Teilnehmer/innen';
$string['badurlformat'] = 'Falsches URL-Format';
$string['cannotsearchcommunity'] = 'Entschuldigung, Sie haben nicht die nötigen Rechte, diese Seite zu sehen.';
$string['community'] = 'Community';
$string['communityremoved'] = 'Dieser Kurslink wurde von Ihrer Liste entfernt';
$string['confirmregistration'] = 'Registrierung bestätigen';
$string['contactable'] = 'Allgemein kontaktierbar';
$string['contactable_help'] = 'Wenn Sie \'Ja\' eingeben, wird Ihre E-Mail-Adresse angezeigt.';
$string['contactemail'] = 'Kontakt-E-Mail';
$string['contactname'] = 'Kontaktname';
$string['contactphone'] = 'Telefon';
$string['contactphone_help'] = 'Telefonnummern werden nur dem Hub-Administrator angezeigt und nicht öffentlicht.';
$string['continue'] = 'Weiter';
$string['contributornames'] = 'Weitere Mitwirkende';
$string['contributornames_help'] = 'Sie können in diesem Feld weitere Namen von Personen eintragen, die bei der Kurserstellung mitgewirkt haben.';
$string['coursemap'] = 'Kursliste';
$string['coursename'] = 'Name';
$string['courseprivate'] = 'Privat';
$string['coursepublic'] = 'Öffentlich';
$string['coursepublished'] = 'Dieser Kurs wurde erfolgreich auf  \'{$a}\' veröffentlicht.';
$string['courseshortname'] = 'Kurzname';
$string['courseshortname_help'] = 'Tragen Sie einen Kurznamen für Ihren Kurs ein. Er muss nicht einmalig sein.';
$string['coursesnumber'] = 'Anzahl von Kursen ({$a})';
$string['courseunpublished'] = 'Der Kurs {$a->courseshortname} ist nicht mehr auf {$a->hubname} veröffentlicht.';
$string['courseurl'] = 'Kurs-URL';
$string['courseurl_help'] = 'Die URL Ihres Kurses wird als Link in den Suchergebnissen angezeigt.';
$string['creatorname'] = 'Kursersteller';
$string['creatorname_help'] = 'Der Kursersteller ist der Autor des Kurses.';
$string['creatornotes'] = 'Hinweise des Kurserstellers';
$string['creatornotes_help'] = 'Hinweise vom Kursersteller sind ein Leitfaden für Trainer/innen für die Handhabung des Kurses.';
$string['deletescreenshots'] = 'Diese Screenshots löschen';
$string['deletescreenshots_help'] = 'Alle aktuell hochgeladenen Screenshots werden gelöscht';
$string['demourl'] = 'Demo-URL';
$string['demourl_help'] = 'Tragen Sie die Demo-URL zu Ihrem Kurs ein.
Normalerweise ist dies die URL zu Ihrem Kurs. Die Demo-URL wird als Link in den Suchergebnissen angezeigt.';
$string['description'] = 'Beschreibung';
$string['description_help'] = 'Dieser Beschreibungstext wird in der Kursliste auf dem Hub angezeigt.';
$string['detectednotexistingpublication'] = '{$a->hubname} zeigt einen nicht mehr existierenden Kurs an. Informieren Sie den Administrator darüber, dass die Kursnummer {$a->id} gelöscht werden soll.';
$string['downloadable'] = 'Herunterladbar';
$string['educationallevel'] = 'Bildungsniveau';
$string['educationallevel_help'] = 'Wählen Sie das angestrebte Kompetenzlevel für den Kurs aus.';
$string['edulevelassociation'] = 'Verband/ Gesellschaft';
$string['edulevelcorporate'] = 'Kooperation';
$string['edulevelgovernment'] = 'Regierung';
$string['edulevelother'] = 'Andere';
$string['edulevelprimary'] = 'Primarstufe';
$string['edulevelsecondary'] = 'Sekundarstufe';
$string['eduleveltertiary'] = 'Tertiärstufe';
$string['emailalert'] = 'E-Mail-Mitteilungen';
$string['emailalert_help'] = 'Wenn dies aktiviert ist, kann der Administrator Sie per Mail über Sicherheitsaspekte und andere wichtige Neuigkeiten informieren.';
$string['enrollable'] = 'Einschreibbar';
$string['errorbadimageheightwidth'] = 'Das Bild sollte folgende Maximalgröße haben {$a->width}px x {$a->height}px';
$string['errorcourseinfo'] = 'Beim Abfragen der Kursmetadaten vom Hub ({$a}) ist ein Fehler aufgetreten. Bitte versuchen Sie später noch einmal, diese Daten zu holen. Alternativ könnten Sie den Registrierungsprozess mit den folgenden standardmäßigen Daten fortsetzen.';
$string['errorcoursepublish'] = 'Während der Kursveröffentlichung ({$a}) ist ein Fehler aufgetreten. Bitte versuchen Sie es später noch einmal.';
$string['errorcoursewronglypublished'] = 'Ein Fehler bei der Kursveröffentlichung wurde vom Server gemeldet. Bitte versuchen Sie es später noch einmal.';
$string['errorcron'] = 'Während der Aktualisierung der Registrierung auf "{$a->hubname}" ist ein Fehler aufgetreten ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = 'XML-RPC muss aktiviert sein, im die Registrierung zu aktualisieren';
$string['errorhublisting'] = 'Ein Fehler ist beim Abfragen der Hubliste bei Moodle.org aufgetreten. Bitte versuchen Sie es später noch einmal. ({$a})';
$string['errorlangnotrecognized'] = 'Der vorgesehene Sprachencode ist Moodle nicht bekannt. Bitte kontaktieren Sie {$a}';
$string['errorregistration'] = 'Ein Fehler ist bei der Registrierung aufgetreten. Bitte versuchen Sie es später noch einmal.  ({$a})';
$string['errorunpublishcourses'] = 'Wegen eines unerwarteten Fehlers konnten die Kurse nicht auf dem Hub gelöscht werden. Versuchen Sie es später nochmal oder nehmen Sie Kontakt zum Hub-Administrator auf.';
$string['existingscreenshotnumber'] = '{$a} vorhandene Screenshots. Sie können die Screenshots erst auf dieser Seite sehen, wenn der Hub-Administrator Ihren Kurs einmalig aktiviert hat.';
$string['existingscreenshots'] = 'Vorhandene Screenshots';
$string['forceunregister'] = 'Registrierungsdaten löschen';
$string['forceunregisterconfirmation'] = 'Ihre Website kann {$a} nicht erreichen. Dieser Hub könnte vorübergehend gestört sein. Wenn Sie nicht wirklich sicher sind, dass Sie Registrierungsdaten löschen möchten, sollten Sie abbrechen und es später nochmal versuchen.';
$string['geolocation'] = 'Geolocation';
$string['geolocation_help'] = 'Zukünftig wird eine geographisch basierte Suche unterstützt. Falls Sie eine Position für Ihren Kurs angeben möchten, tragen Sie hier die Werte für Breiten- und Längengrad ein (z.B. -31.947884,115.871285), wobei Sie die Positionsdaten beispielsweise über Google Maps finden können.';
$string['hub'] = 'Hub';
$string['imageurl'] = 'Bild-URL';
$string['imageurl_help'] = 'Das Bild wird auf dem Hub angezeigt. Dieses Bild muss vom Hub aus jederzeit erreichbar sein. Die maximale Göße sollte {$a->width} x {$a->height} Pixel sein.';
$string['information'] = 'Information';
$string['language'] = 'Sprache';
$string['language_help'] = 'Hauptsprache dieses Kurses';
$string['lasttimechecked'] = 'Letztes mal geprüft';
$string['licence'] = 'Lizenz';
$string['licence_help'] = 'Wählen Sie eine Lizenz aus, unter der Sie Ihren Kurs bereitstellen möchten.';
$string['logourl'] = 'Logo-URL';
$string['modulenumberaverage'] = 'Durchschnittliche Anzahl von Kursmodulen ({$a})';
$string['moodleorg'] = 'Moodle.org';
$string['moodleorgregistrationdetail'] = 'Der wichtigste Community-Hub heißt MOOCH, erreichbar auf hub.moodle.org. Durch die Registrierung Ihrer Website über MOOCH tragen Sie zur Statistik der weltweiten Moodle-Community bei. Sie können sich dort auch in eine Mailingliste eintragen, über die Sie Mitteilungen zu Sicherheitsproblemen und zu neuen Moodle-Releases erhalten.';
$string['moodleorgregistrationdetail2'] = 'Diese Option erlaubt es Ihnen, Ihre Moodle-Instanz über MOOCH auf hub.moodle.org zu registrieren. Die Registrierung ist kostenlos. Hauptvorteil dieser Registrierung ist, dass Sie in eine Mailingliste eingetragen werden und wichtige Mitteilungen zu Sicherheitsproblemen und zu neuen Moodle-Releases erhalten.

Standardmäßig werden alle Daten zu Ihrer Moodle-Instanz vertraulich behandelt und niemals verkauft oder an anderer Stelle weiterverwendet. Die einzigen Gründe zum Sammeln dieser Daten sind Supportzwecke und die Erstellung einer statistischen Übersicht zur Moodle-Community als Gesamtheit. Falls Sie möchten, wird auch der Namen Ihrer Website, Ihr Land und die URL in eine öffentliche Liste der registrierten Moodle-Websites eintragen. Alle neuen Registrierungen werden manuell geprüft, bevor sie hinzugefügt werden. Anschließend können Sie Ihre Registrierung zusammen mit dem Listeneintrag jederzeit aktualisieren.';
$string['mustselectsubject'] = 'Sie müssen ein Thema auswählen';
$string['name'] = 'Name';
$string['name_help'] = 'Dieser Name erscheint in der Kursübersicht.';
$string['neverchecked'] = 'Nie geprüft';
$string['next'] = 'Weiter';
$string['no'] = 'Nein';
$string['nocheckstatusfromunreghub'] = 'Die Seite ist nicht auf dem Hub registrisriert, deshalb kann der Status nicht überprüft werden.';
$string['nohubselected'] = 'Kein Hub ausgewählt';
$string['none'] = 'Keine';
$string['nosearch'] = 'Hub oder Kurse nicht veröffentlichen';
$string['notregisteredonhub'] = 'Ihr Administrator muss diese Website zuerst einmalig bei einem Hub registrieren, bevor Sie einen Kurs veröffentlichen können. Bitte melden Sie sich deswegen bei Ihrem Administrator.';
$string['notregisteredonmoodleorg'] = 'Ihr Admisnistrator muss diese Seite auf moodle.org registrieren.';
$string['operation'] = 'Aktionen';
$string['orenterprivatehub'] = 'Alternativ geben Sie eine private URL ein:';
$string['participantnumberaverage'] = 'Durchschnittsteilnehmerzahl ({$a})';
$string['postaladdress'] = 'Postadresse';
$string['postaladdress_help'] = 'Postadresse der Seite oder des für die Seite Verantwortlichen.';
$string['postsnumber'] = 'Anzahl der Nachrichten ({$a})';
$string['previousregistrationdeleted'] = 'Die vorherige Anmeldung ist bei {$a} gelöscht worden. Sie können den Registrierungsprozess neu beginnen.';
$string['prioritise'] = 'Bevorzugen';
$string['privacy'] = 'Privatsphäre';
$string['privacy_help'] = 'Der Hub könnte eine Liste registrierter Websites zeigen. Falls dies so ist, dürfen Sie wählen, ob Ihre Website ebenfalls in dieser Liste erscheinen soll oder nicht.';
$string['private'] = 'Privat';
$string['privatehuburl'] = 'Private URL';
$string['publicationinfo'] = 'Informationen zur Kursveröffentlichung';
$string['publichub'] = 'Öffentlicher Hub';
$string['publishcourse'] = 'Veröffentlichen {$a}';
$string['publishcourseon'] = 'Veröffentlichen auf {$a}';
$string['publishedon'] = 'Veröffentlicht auf';
$string['publisheremail'] = 'E-Mail-Adresse';
$string['publisheremail_help'] = 'Die E-Mail-Adresse des Herausgebers erlaubt es, dass der Administrator des Hubs über Änderungen beim Status des veröffentlichten Kurses informieren kann. ';
$string['publishername'] = 'Herausgeber';
$string['publishername_help'] = 'Der Herausgeber ist die Person oder die Organisation, die den Kurs offiziell veröffentlicht. Falls Sie den Kurs im Auftrage einer anderen Person veröffentlichen, so sind Sie das.';
$string['publishon'] = 'Veröffentlichen auf';
$string['publishonmoodleorg'] = 'Auf MOOCH veröffentlichen';
$string['publishonspecifichub'] = 'Auf einem anderen Hub veröffentlichen';
$string['questionsnumber'] = 'Anzahl der Fragen ({$a})';
$string['readvertiseon'] = 'Informationen auf {$a} aktualisieren';
$string['registeredcourses'] = 'Registrierte Kurse';
$string['registeredmoodleorg'] = 'Moodle.org ({$a})';
$string['registeredon'] = 'Registriert mit';
$string['registeredsites'] = 'Registrierte Websites';
$string['registeron'] = 'Ihre Website registrieren';
$string['registeronmoodleorg'] = 'Auf Moodle.org (MOOCH) registrieren';
$string['registeronspecifichub'] = 'Auf einem speziellen Hub registrieren';
$string['registersite'] = 'Auf {$a} registrieren';
$string['registrationconfirmed'] = 'Registrierung der Website bestätigt';
$string['registrationconfirmedon'] = 'Sie sind nun auf dem Hub {$a} registriert. Ab sofort können Sie Kurse auf diesem Hub veröffentlichen, indem Sie den Link "Veröffentlichen" im Menü "Kurs-Administration" verwenden.';
$string['registrationinfo'] = 'Registrierungsinformation';
$string['registrationupdated'] = 'Registrierung wurde erneuert.';
$string['registrationupdatedfailed'] = 'Registrierung ist fehlgeschlagen.';
$string['removefromhub'] = 'Vom Hub löschen';
$string['renewregistration'] = 'Registrierung erneuern';
$string['resourcesnumber'] = 'Anzahl der Ressourcen ({$a})';
$string['restartregistration'] = 'Registrierung neu beginnen';
$string['roleassignmentsnumber'] = 'Anzahl der Rollenzuweisungen ({$a})';
$string['screenshots'] = 'Screenshots';
$string['screenshots_help'] = 'Screenshots hinzufügen, die beim Suchergebnis gezeigt werden sollen';
$string['search'] = 'Suche';
$string['selecthub'] = 'Hub auswählen';
$string['selecthubforadvertise'] = 'Hub zur Ankündigung auswählen';
$string['selecthubforsharing'] = 'Hub zum Hochladen auswählen';
$string['selecthubinfo'] = 'Ein Community-Hub ist ein Server, der Moodlekurse listet. Sie können Ihre eigenen Kurse nur auf einem Hub veröffentlichen, bei dem Ihre Website bereits registriert wurde. Falls der gewünschte Hub nicht in der folgenden Liste aufgeführt ist, melden Sie sich bitte bei Ihrem Administrator.';
$string['sendfollowinginfo'] = 'Weitere Informationen';
$string['sendfollowinginfo_help'] = 'Die folgenden Informationen werden nur erfasst, um eine Gesamtstatistik zu erstellen. Sie werden auf keinen Fall irgendwo veröffentlicht. ';
$string['sendingcourse'] = 'Kurs wird gesendet';
$string['sendingsize'] = 'Bitte warten Sie während des Dateiuploads ({$a->total}Mb)...';
$string['sent'] = '... fertig';
$string['settings'] = 'Einstellungen';
$string['settingsupdated'] = 'Die Einstellungen wurden aktualisiert.';
$string['share'] = 'Diesen Kurs zum Download freigeben';
$string['shared'] = 'Freigegeben';
$string['shareon'] = 'Diesen Kurs nach {$a} uploaden';
$string['shareonhub'] = 'Diesen Kurs auf einen Hub laden';
$string['shareonmoodleorg'] = 'Diesen Kurs auf MOOCH laden';
$string['sharepublication_help'] = 'Wenn Sie diesen Kurse auf einen Community-Hub hochladen, können anderen Personen ihn herunterladen und ihn in ihrer eigenen Moodle-Instanz verwenden. ';
$string['siteadmin'] = 'Administrator';
$string['siteadmin_help'] = 'Vollständiger Name des Administrators';
$string['sitecountry'] = 'Land';
$string['sitecountry_help'] = 'Das Land Ihrer Organisation ist enthalten.';
$string['sitecreated'] = 'Seite erstellt';
$string['sitedesc'] = 'Beschreibung';
$string['sitedesc_help'] = 'Die Beschreibung Ihrer Seite kann auf der Liste der Websites gezeigt werden. Bitte geben Sie den Text ohne Formatierungen ein.';
$string['siteemail'] = 'E-Mail-Adresse';
$string['siteemail_help'] = 'Sie müssen eine E-Mail-Adresse angeben, damit Sie der Administrator bei Bedarf kontaktieren kann. Es wird empfohlen, eine E-Mail-Adresse zu verwenden, die Bezug zu einer Position hat (z.B. sitemanager@example.com) und einer einzelnen Person gehört.';
$string['sitegeolocation'] = 'Geolocation';
$string['sitegeolocation_help'] = 'Zukünftig wird eine ortsbezogene Suche in den Hubs möglich sein. Falls Sie den Ort Ihrer Website angeben möchten, tragen Sie bitte die Werte für die geografische Breite und Länge hier ein (z.B. -31.947884,115.871285) Eine Möglichkeit ist, diese Werte über Google Maps zu finden.';
$string['sitelang'] = 'Sprache';
$string['sitelang_help'] = 'Die Sprache Ihrer Website wird in der Liste angezeigt.';
$string['sitename'] = 'Name';
$string['sitename_help'] = 'Der Name dieser Website wird auf der Liste angezeigt, wenn der Hub das zulässt.';
$string['sitephone'] = 'Telefon';
$string['sitephone_help'] = 'Ihre Telefonnummer kann nur vom Administrator gesehen werden.';
$string['siteprivacy'] = 'Datenschutz';
$string['siteprivacylinked'] = 'Namen der Website mit einem Link veröffentlichen';
$string['siteprivacynotpublished'] = 'Bitte diese Website nicht veröffentlichen';
$string['siteprivacypublished'] = 'Nur den Namen der Website veröffentlichen';
$string['siteregconfcomment'] = 'Ihre Website braucht eine endgültige Bestätigung auf {$a} (zur Vermeidung von Spam)';
$string['siteregistrationcontact'] = 'Kontaktformular';
$string['siteregistrationcontact_help'] = 'Wenn diese Option aktiviert ist, können andere Personen über ein Kontaktformular auf dem Hub mit Ihnen in Kontakt treten. Ihre E-Mail-Adresse wird niemals angezeigt.';
$string['siteregistrationemail'] = 'E-Mail-Mitteilungen';
$string['siteregistrationemail_help'] = 'Wenn diese Option aktiviert ist, kann Ihnen der Hub-Administrator über wichtige Mitteilungen wie z.B. Sicherheitswarnungen per E-Mail zusenden.';
$string['siteregistrationupdated'] = 'Seitenregistrierung aktualisiert';
$string['siterelease'] = 'Moodle-Release';
$string['siterelease_help'] = 'Nummer des Moodle-Releases auf dieser Website';
$string['siteupdatedcron'] = 'Website-Registrierung auf "{$a}" aktualisiert';
$string['siteupdatesend'] = 'Website-Registrierung auf den Hubs ist beendet';
$string['siteupdatesstart'] = 'Website-Registrierung auf den Hubs wird aktualisiert...';
$string['siteurl'] = 'Website-URL';
$string['siteurl_help'] = 'Die URL ist die Adresse dieser Website. Falls es die Datenschutzeinstellungen erlauben, dass Adressen von Websites zu sehen sind, dann wird diese Adresse gezeigt.';
$string['siteversion'] = 'Moodle-Version';
$string['siteversion_help'] = 'Moodle-Version dieser Website';
$string['specifichub'] = 'Spezieller Hub';
$string['specifichubregistrationdetail'] = 'Sie können Ihre Website auch bei anderen Community-Hubs registrieren.';
$string['statistics'] = 'Datenschutz der Statistik';
$string['status'] = 'Hubliste';
$string['statuspublished'] = 'Gelistet';
$string['statusunpublished'] = 'Nicht gelistet';
$string['subject'] = 'Thema';
$string['subject_help'] = 'Wählen Sie  des Hauptthema des Kurses aus.';
$string['tags'] = 'Schlagworte';
$string['tags_help'] = 'Schlagworte helfen, Ihren Kurs zu kategorisieren ihn wiederzufinden. Bitte verwenden Sie einfache und aussagekräftige Worte. Trennen Sie mehrere Schlagworte mit einem Komma, z.B. Mathematik, Algebra, Geometrie';
$string['trustme'] = 'Vertrauen';
$string['type'] = 'Angeboten / gemeinsam genutzt';
$string['unknownstatus'] = 'Unbekannt';
$string['unlistedurl'] = 'Ungelistete Hub-URL';
$string['unprioritise'] = 'Nicht bevorzugen';
$string['unpublish'] = 'Unveröffentlicht';
$string['unpublishalladvertisedcourses'] = 'Alle aktuell auf einem Hub angebotenen Kurse entfernen';
$string['unpublishalluploadedcourses'] = 'Alle auf einen Hub hochgeladenen Kurse sind entfernt';
$string['unpublishconfirmation'] = 'Möchten Sie wirklich den Kurs "{$a->courseshortname}" vom Hub "{$a->hubname}" entfernen?';
$string['unpublishcourse'] = 'Unveröffentlicht {$a}';
$string['unregister'] = 'Austragen';
$string['unregisterconfirmation'] = 'Sie sind dabei, diese Website beim Hub {$a} abzumelden. Sobald Sie nicht mehr mit dem Hub verbunden sind, können Sie keine Kurse mehr verwalten, die Sie dort abgelegt haben. Möchten Sie sich wirklich abmelden?';
$string['unregisterfrom'] = 'Austragen aus {$a}';
$string['unregistrationerror'] = 'Ein Fehler ist beim Austragungsversuch vom Hub {$a} aufgetreten';
$string['untrustme'] = 'Nicht vertrauenswürdig';
$string['update'] = 'Update';
$string['updatesite'] = 'Update-Registrierung auf {$a}';
$string['updatestatus'] = 'Jetzt prüfen';
$string['uploaded'] = 'Hochgeladen';
$string['url'] = 'Hub-URL';
$string['urlalreadyregistered'] = 'Ihre Website scheint bereits auf diesem Hub registriert zu sein, was möglicherweise ein Fehler ist. Bitte wenden Sie sich an Ihren Hub-Administrator, damit der Ihre Registrierung zurücksetzt und Sie es nochmal probieren können.';
$string['usersnumber'] = 'Anzahl der Nutzer/innen ({$a})';
$string['warning'] = 'Achtung';
$string['wrongtoken'] = 'Die Registrierung ist aus irgendeinem Grund fehlgeschlagen (Netzwerk?). Bitte versuchen Sie es nochmal.';
$string['wrongurlformat'] = 'Falsches URL-Format';
$string['xmlrpcdisabledcommunity'] = 'Die PHP-Extension XML-RPC ist auf dem Server nicht aktiviert. Sie können keine Kurse suchen oder herunterladen.';
$string['xmlrpcdisabledpublish'] = 'Die PHP-Extension XML-RPC ist auf dem Server nicht aktiviert. Sie können keine Kurse veröffentlichen oder veröffentlichte Kurse verwalten.';
$string['xmlrpcdisabledregistration'] = 'Die PHP-Extension XML-RPC ist auf dem Server nicht aktiviert. Sie können Ihre Registrierung nicht löschen oder aktualisieren.';
