<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'de', branch 'MOODLE_20_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Sie sind bereits als {$a} angemeldet. Bitte melden Sie sich ab, bevor Sie sich mit anderem Anmeldenamen wieder anmelden.';
$string['authnotexisting'] = 'Das Authorisierungsplugin existiert nicht';
$string['backupcontainexternal'] = 'Diese Backup-Datei enthält externe Moodle Netzwerkverbindungen (MNET), die nicht lokal konfiguriert wurden.';
$string['backuptablefail'] = 'Die Backup-Tabellen konnten nicht erstellt werden!';
$string['blockcannotconfig'] = 'Dieser Block erlaubt keine globale Konfiguration';
$string['blockcannotinistantiate'] = 'Problem beim Anlegen des Blocks';
$string['blockcannotread'] = 'Die Daten für die Block-ID {$a} konnten nicht gelesen werden';
$string['blockdoesnotexist'] = 'Dieser Block existiert nicht';
$string['blockdoesnotexistonpage'] = 'Der Block (id={$a->instanceid}) existiert nicht auf dieser Seite ({$a->url}).';
$string['blocknameconflict'] = 'Namenskonflikt: Block {$a->name} hat den gleichen Titel wie ein bereits existierender Block {$a->conflict}!';
$string['callbackrejectcomment'] = 'Modul verweigert das Hinzufügen dieses Kommentars';
$string['cannotaddcoursemodule'] = 'Das neue Kursmodul konnte nicht hinzugefügt werden';
$string['cannotaddcoursemoduletosection'] = 'Das neue Kursmodul konnte in dem Abschnitt nicht eingefügt werden.';
$string['cannotaddmodule'] = 'Modul {$a} konnte nicht zur Modulliste hinzugefügt werden!';
$string['cannotaddnewmodule'] = 'Das neue Modul {$a} konnte nicht hinzugefügt werden';
$string['cannotaddrss'] = 'Sie dürfen keine RSS-Feeds hinzufügen';
$string['cannotaddthisblocktype'] = 'Sie dürfen keinen Block \'{$a}\' zur Seite hinzufügen';
$string['cannotassignrole'] = 'Die Rolle kann im Kurs nicht zugewiesen werden';
$string['cannotassignrolehere'] = 'Sie dürfen die Rolle (id = {$a->roleid}) in diesem Kontext ({$a->context}) nicht zuweisen.';
$string['cannotassignselfasparent'] = 'Etwas kann nicht zu sich selbst als übergeordnete Ebene zugewiesen werden.';
$string['cannotcallscript'] = 'Das Skript kann in dieser Form nicht aufgerufen werden.';
$string['cannotcallusgetselecteduser'] = 'Sie können user_selector::get_selected_user nicht aufrufen, wenn die Mehrfachauswahl (multiselect) aktiviert ist.';
$string['cannotcreatebackupdir'] = 'Das Verzeichnis \'backupdata\' konnte nicht erstellt werden. Der Administrator muss die Zugriffsrechte korrigieren.';
$string['cannotcreatecategory'] = 'Kursbereich wurde nicht eingefügt';
$string['cannotcreategroup'] = 'Fehler beim Anlegen der Gruppe';
$string['cannotcreatelangbase'] = 'Fehler: Das Verzeichnis \'lang\' wurde nicht angelegt';
$string['cannotcreatelangdir'] = 'Verzeichnis \'lang\' wurde nicht angelegt';
$string['cannotcreateorfindstructs'] = 'Fehler beim Suchen oder Anlegen der Kursabschnitte';
$string['cannotcreatepopupwin'] = 'Undefiniertes Element - Popup-Fenster konnte nicht erstellt werden.';
$string['cannotcreatesitedir'] = 'Das Verzeichnis für die Website wurde nicht angelegt. Der Administrator muss die Dateirechte auf dem Server korrigieren.';
$string['cannotcreatetempdir'] = 'Das Verzeichnis \'temp\' wurde nicht angelegt';
$string['cannotcreateuploaddir'] = 'Das Upload-Verzeichnis wurde nicht angelegt. Der Administrator muss die Dateirechte auf dem Server korrigieren.';
$string['cannotcustomisefiltersblockuser'] = 'Sie dürfen keine Filtereinstellungen im Nutzer- oder Blockkontext ändern.';
$string['cannotdeletebackupids'] = 'Frühere Sicherungs-IDs konnten nicht gelöscht werden';
$string['cannotdeletecategorycourse'] = 'Fehler beim Löschen des Kurses \'{$a}\'';
$string['cannotdeletecategoryquestions'] = 'Einige Fragen aus der Kategorie \'{$a}\' konnten nicht gelöscht werden';
$string['cannotdeletecourse'] = 'Sie dürfen diesen Kurs nicht löschen';
$string['cannotdeletecustomfield'] = 'Fehler beim Löschen des Datenfeldes';
$string['cannotdeletedir'] = '\'{$a}\' konnte nicht gelöscht werden';
$string['cannotdeletefile'] = 'Die Datei kann nicht gelöscht werden';
$string['cannotdeleterole'] = 'Das Löschen ist nicht möglich: {$a}';
$string['cannotdeleterolewithid'] = 'Die Rolle mit der ID {$a} konnte nicht gelöscht werden';
$string['cannotdeletethisrole'] = 'Sie können die Rolle nicht löschen, weil sie vom System genutzt wird oder die letzte verbliebende Administratorrolle ist.';
$string['cannotdownloadcomponents'] = 'Einige Komponenten können nicht geladen werden.';
$string['cannotdownloadlanguageupdatelist'] = 'Die Liste der Sprachupdates kann nicht von download.moodle.org geladen werden.';
$string['cannotdownloadzipfile'] = 'ZIP-Datei kann nicht heruntergeladen werden.';
$string['cannoteditcomment'] = 'SIe dürfen keinen fremden Kommentar bearbeiten';
$string['cannoteditcommentexpired'] = 'Die Zeit zur Bearbeitung ist abgelaufen!';
$string['cannoteditpostorblog'] = 'Sie dürfen keine Blogs posten oder bearbeiten.';
$string['cannoteditsiteform'] = 'Sie können die Startseite nicht über dieses Formular bearbeiten';
$string['cannotedityourprofile'] = 'Sie können Ihr Profil nicht bearbeiten';
$string['cannotfindcategory'] = 'Für den Kursbereich kann kein Datensatz  mit der ID {$a} gefunden werden';
$string['cannotfindcomponent'] = 'Komponente wurde nicht gefunden';
$string['cannotfindcontext'] = 'Kontext wurde nicht gefunden';
$string['cannotfindcourse'] = 'Kurs wurde nicht gefunden';
$string['cannotfinddocs'] = 'Die Dokumentation zum Sprachpaket \'{$a}\' wurde nicht gefunden';
$string['cannotfindgradeitem'] = 'Bewertungsaspekt wurde nicht gefunden';
$string['cannotfindgroup'] = 'Gruppe wurde nicht gefunden';
$string['cannotfindhelp'] = 'Die Hilfedateien zum Sprachpaket \'{$a}\'  wurden nicht gefunden';
$string['cannotfindinfo'] = 'Informationen zu \'{$a}\' wurden nicht gefunden';
$string['cannotfindlang'] = 'Sprachpaket \'{$a}\' wurde nicht gefunden!';
$string['cannotfindteacher'] = 'Trainer wurde nicht gefunden';
$string['cannotfinduser'] = 'Nutzerkonto \'{$a}\' wurde nicht gefunden';
$string['cannotgetblock'] = 'Blöcke wurden nicht aus der Datenbank abgerufen';
$string['cannotgetcats'] = 'Fehler beim Lesen des Datensatzes für den Kursbereich';
$string['cannotgetdata'] = 'Daten wurden nicht gefunden';
$string['cannotgradeuser'] = 'Diese Nutzer/in kann nicht bewertet werden';
$string['cannothaveparentcate'] = 'Der Kursbereich kann keinen übergeordneten Kursbereich besitzen!';
$string['cannotimport'] = 'Importfehler';
$string['cannotimportformat'] = 'Dieses Importformat ist bisher nicht implementiert!';
$string['cannotimportgrade'] = 'Importfehler für die Bewertung';
$string['cannotinsertgrade'] = 'Die Bewertung kann nicht ohne Kurs-ID angelegt werden!';
$string['cannotinsertrate'] = 'Die neue Bewertung wurde nicht eingefügt ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Der neue Datensatz ID {$a} wurde nicht eingetragen';
$string['cannotmailconfirm'] = 'Fehler beim E-Mail-Versand zur Bestätigung der Kennwortänderung';
$string['cannotmanualctrack'] = 'Die Aktivität unterstützt keine manuelle Abschlussverfolgung';
$string['cannotmapfield'] = 'Problem bei der Zuordnung aufgetreten. Zwei Felder sind der gleichen Bewertung {$a} zugeordnet.';
$string['cannotmarktopic'] = 'Das Kursfeld konnte nicht markiert werden';
$string['cannotmigratedatacomments'] = 'Kommentare zum Datenmodul können nicht migriert werden';
$string['cannotmodulename'] = 'Bei der Navigationserstellung kann der Modulname nicht festgestellt werden.';
$string['cannotmoduletype'] = 'Bei der Navigationserstellung kann der Modultyp  nicht festgestellt werden.';
$string['cannotmoverolewithid'] = 'Die Rolle mit der ID {$a} kann nicht verschoben werden.';
$string['cannotnetgeo'] = 'Die Verbindung zur Online-Datenbank NetGeo  http://netgeo.caida.org kann nicht hergestellt werden. Bitte prüfen Sie die Proxyeinstellungen oder installieren Sie die Datenbank GeoLiteCity.dat von MaxMind lokal auf Ihrem Server.';
$string['cannotopencsv'] = 'Die CSV-Datei kann nicht geöffnet werden';
$string['cannotopenfile'] = 'Datei \'{$a}\' kann nicht geöffnet werden';
$string['cannotopenforwrit'] = 'Datei \'{$a}\' kann nicht zum Schreiben geöffnet werden';
$string['cannotopentemplate'] = 'Vorlage \'{$a}\' kann nicht geöffnet werden';
$string['cannotopenzip'] = 'Die ZIP-Datei kann nicht geöffnet werden, eventuell wegen eines Bugs der ZIP-Erweiterung bei 64-Bit Betriebssystemen.';
$string['cannotoverridebaserole'] = 'Basisrollen können nicht geändert werden';
$string['cannotoverriderolehere'] = 'Sie dürfen die Rolle (id = {$a->roleid}) in diesem Kontext ({$a->context}) nicht ändern';
$string['cannotreadfile'] = 'Die Datei \'{$a}\' kann nicht gelesen werden';
$string['cannotreadtmpfile'] = 'Fehler beim Lesen von temporären Daten';
$string['cannotreaduploadfile'] = 'Die hochgeladene Datei konnte nicht gelesen werden';
$string['cannotremovefrommeta'] = 'Sie können den ausgewählten Kurs nicht aus diesem Metakurs entfernen!';
$string['cannotresetguestpwd'] = 'Sie dürfen das Kennwort für Gäste nicht ändern';
$string['cannotresetmail'] = 'Fehler beim Setzen und Senden des Kennwortes';
$string['cannotresetthisrole'] = 'Diese Rolle kann nicht zurückgesetzt werden';
$string['cannotrestore'] = 'Die Wiederherstellung wurde wegen eines Fehlers nicht abgeschlossen!';
$string['cannotrestoreadminorcreator'] = 'Sie müssen Kursersteller oder Administrator sein, um die Daten in einen neuen Kurs wiederherstellen zu dürfen!';
$string['cannotrestoreadminoredit'] = 'Sie müssen Kurstrainer oder Administrator sein, um die Daten im ausgewählten Kurs wiederherstellen zu dürfen!';
$string['cannotsaveagreement'] = 'Ihre Zustimmung konnte nicht gespeichert werden';
$string['cannotsaveblock'] = 'Fehler beim Speichern der Block-Einstellungen';
$string['cannotsavecomment'] = 'Kommentar wurde nicht gespeichert';
$string['cannotsavedata'] = 'Daten wurden nicht gespeichert';
$string['cannotsavefile'] = 'Die Datei \'{$a}\' wurde nicht gespeichert!';
$string['cannotsavemd5file'] = 'Die md5-Datei wurde nicht gespeichert';
$string['cannotsavezipfile'] = 'Die ZIP-Datei wurde nicht gespeichert';
$string['cannotservefile'] = 'Die Datei kann nicht bereitgestellt werden. Ursache ist ein Problem mit der Serverkonfiguration.';
$string['cannotsetparentforcatoritem'] = 'Für die Kategorie oder ded Kurseintrag konnte kein übergeordneter Wert zugeordnet werden!';
$string['cannotsetpassword'] = 'Das Kennwort konnte nicht gesetzt werden!';
$string['cannotsetprefgrade'] = 'Präferenz Gesamtergebnisansicht für {$a} konnte für diese Bewertungskategorie nicht gesetzt werden.';
$string['cannotsettheme'] = 'Das Design konnte nicht gesetzt werden!';
$string['cannotsetupblock'] = 'Die Blocktabellen konnten nicht erfolgreich angelegt werden!';
$string['cannotsetupcapformod'] = 'Berechtigungen für {$a} konnten nicht angelegt werden.';
$string['cannotsetupcapforplugin'] = 'Berechtigungen für {$a} konnten nicht angelegt werden.';
$string['cannotshowhidecoursesincategory'] = 'Die Kurse in der Kategorie {$a} können nicht angezeigt / verborgen werden.';
$string['cannotunassigncap'] = 'Abgelehnte Berechtigung {$a->cap} für Rolle {$a->role} konnte nicht ausgetragen werden.';
$string['cannotunassignrolefrom'] = 'Dieses Nutzerkonto konnte nicht aus der Rollenzuweisung gelöscht werden: {$a}';
$string['cannotunzipfile'] = 'Die Datei kann nicht entpackt werden';
$string['cannotupdatemod'] = '{$a} kann nicht aktualisiert werden';
$string['cannotupdatepasswordonextauth'] = 'Die Kennwortaktualisierung für die externe Authentisierung ist fehlgeschlagen: {$a}. Weitere Detail finden Sie in den Logdateien des Servers.';
$string['cannotupdateprofile'] = 'Fehler beim Aktualisieren des Nutzerdatensatzes';
$string['cannotupdaterecord'] = 'Der Datensatz mit der ID {$a} kann nicht aktualisiert werden';
$string['cannotupdaterss'] = 'RSS konnte nicht aktualisiert werden';
$string['cannotupdatesubcourse'] = 'Ein zugeordneter Kurs konnte nicht aktualisiert werden!';
$string['cannotupdateusermsgpref'] = 'Die Nachrichten-Einstellungen des Nutzers kann nicht aktualisiert werden.';
$string['cannotupdateuseronexauth'] = 'Die Aktualisierung der Nutzerdaten für die externe Authentisierung ist fehlgeschlagen: {$a}. Schauen Sie bitte in die Logdateien des Servers, um weitere Details zu erfahren.';
$string['cannotuploadfile'] = 'Fehler beim Hochladen der Datei';
$string['cannotuseadmin'] = 'Sie müssen Administrator/in sein, um diese Seite nutzen zu können';
$string['cannotuseadminadminorteacher'] = 'Sie müssen Trainer/in oder Administrator/in sein, um diese Seite nutzen zu können';
$string['cannotusepage'] = 'Ausschließlich Trainer/innen und Administrator/innen können diese Seite nutzen';
$string['cannotusepage2'] = 'Entschuldigung, aber Sie dürfen diese Seite nicht verwenden';
$string['cannotviewprofile'] = 'Sie können dieses Nutzerprofil nicht ansehen';
$string['cannotviewreport'] = 'Sie können diesen Bericht nicht ansehen';
$string['cannotwritefile'] = 'In die Datei \'{$a}\' kann nicht geschieben werden';
$string['commentmisconf'] = 'Kommentar-ID ist falsch konfiguriert';
$string['componentisuptodate'] = 'Die Komponente ist aktuell.';
$string['confirmsesskeybad'] = 'Der \'session key\' für diese Aktion konnte nicht bestätigt werden. Dieses Sicherheitsfeature schützt Sie vor der nicht beabsichtigten Ausführung wichtiger Funktionen oder der Ausführung von Aktionen durch Dritte in Ihrem Namen. Bitte kontrollieren Sie, ob Sie diese Aktion wirklich ausführen wollen.';
$string['couldnotassignrole'] = 'Ein schwerer, nicht näher bezeichneter Fehler ist aufgetreten, während Sie sich eine Rolle zuweisen wollten.';
$string['couldnotupdatenoexistinguser'] = 'Nutzer konnte nicht aktualisiert werden - Nutzer existiert nicht';
$string['countriesphpempty'] = 'Fehler: Die Datei countries.php im Sprachpaket \'{$a}\' ist leer oder fehlt';
$string['coursedoesnotbelongtocategory'] = 'Der Kurs gehört nicht zu diesem Bereich';
$string['coursegroupunknown'] = 'Es wurde kein Kurs für die Gruppe {$a} festgelegt';
$string['courseidnotfound'] = 'Kurs-ID existiert nicht';
$string['coursemisconf'] = 'Kurs ist falsch konfiguriert.';
$string['courserequestdisabled'] = 'Die aufgerufenen Kurse wurden vom Administrator deaktiviert';
$string['csvcolumnduplicates'] = 'Doppelte Spalten gefunden';
$string['csvemptyfile'] = 'Die CSV-Datei ist leer';
$string['csvfewcolumns'] = 'Nicht genügend Spalten vorhanden - bitte prüfen Sie die Trennzeicheneinstellung';
$string['csvinvalidcols'] = 'Ungültige CSV-Datei: Die erste Zeile muss die Feldbezeichner enthalten. Der Dateityp muss \'erweiterte Felder / Komma getrennt\' oder \'erweiterte Felder mit CAVV-Ergebniscode / Komma getrennt\' sein.';
$string['csvinvalidcolsnum'] = 'Ungültige CSV-Datei - jede Zeile muss 49 oder 70 Felder enthalten';
$string['csvloaderror'] = 'Fehler beim Laden der CSV-Datei aufgetreten';
$string['csvweirdcolumns'] = 'Ungültiges CSV-Format - die Anzahl der Datenfelder ist nicht konstant!';
$string['dbconnectionfailed'] = '<p>Fehler: Datenbankverbindung fehlgeschlagen</p>
<p>Es ist möglich, dass die Datenbank überlastet ist oder nicht ordentlich läuft.</p>
<p>Der Server-Administrator sollte zusätzlich prüfen, ob die Datenbankdetails richtig in der config.php eingetragen sind.</p>';
$string['dbdriverproblem'] = '<p>Fehler: Datenbanktreiber-Problem aufgetreten</a>
<p>Der Server-Administrator sollte die Server-Einstellungen prüfen.</p>
<p>{$a}</p>';
$string['dbsessionbroken'] = 'Ein schwerwiegendes Problem mit der Datenbank-Session wurde erkannt<br /><br />Bitte benachrichtigen Sie den Administrator des Servers';
$string['dbsessionhandlerproblem'] = 'Das Einrichten der Datenbank-Session ist fehlgeschlagen<br /><br />Bitte benachrichtigen Sie den Administrator des Servers';
$string['dbsessionmysqlpacketsize'] = 'Ein scherwiegender Session-Fehler wurde erkannt<br /><br />Bitte informieren Sie den Administrator des Servers, dass dieses Problem auftreten kann, wenn der Wert max_allowed_packet in den MySQL-Einstellungen zu klein festgelegt wurde';
$string['dbupdatefailed'] = 'Datenbankaktualisierung fehlgeschlagen';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" kann nicht verändert werden, weil eine Verbindung mit {$a->offendingtype} "{$a->offendingname}" besteht';
$string['ddlexecuteerror'] = 'Fehler: DDL sql execution';
$string['ddlfieldalreadyexists'] = 'Feld "{$a}" existiert nicht';
$string['ddlfieldnotexist'] = 'Feld "{$a->fieldname}" existiert nicht in der Tabelle "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabelle "{$a}" ist bereits vorhanden';
$string['ddltablenotexist'] = 'Tabelle "{$a}" existiert nicht';
$string['ddlunknownerror'] = 'Unbekannter DDL Library Fehler';
$string['ddlxmlfileerror'] = 'XML Datenbankdatei-Fehler gefunden';
$string['ddsequenceerror'] = 'Falsche Tabellendefinition "{$a}". Es darf nur eine Auto-Spalte geben und die muss als Key definiert sein';
$string['destinationcmnotexit'] = 'Das adressierte Kursmodul existiert nicht';
$string['detectedbrokenplugin'] = 'Plugin "{$a}" ist defekt oder veraltet. Der Prozess wird abgebrochen.';
$string['dmlreadexception'] = 'Fehler beim Lesen der Datenbank';
$string['dmltransactionexception'] = 'Fehler bei Datenbankvorgang';
$string['dmlwriteexception'] = 'Fehler beim Schreiben der Datenbank';
$string['downgradedcore'] = 'Fehler: Der von Ihnen benutzte Code ist ÄLTER als die Version, die speziell für diese Datenbanken geschrieben wurde.';
$string['downloadedfilecheckfailed'] = 'Die Überprüfung der heruntergeladenen Datei ist gescheitert';
$string['duplicatefieldname'] = 'Doppelter Feldname \'{$a}\'';
$string['duplicateparaminsql'] = 'Fehler: Doppelter Parametername in der ABfrage';
$string['duplicaterolename'] = 'Eine Rolle mit diesem Namen gibt es bereits!';
$string['duplicateroleshortname'] = 'Eine Rolle mit diesem Kurznamen gibt es bereits!';
$string['duplicateusername'] = 'Doppelter Anmeldename - Datensatz überspringen';
$string['emailfail'] = 'E-Mail-Versand fehlgeschlagen';
$string['error'] = 'Ein Fehler ist aufgetreten';
$string['errorcleaningdirectory'] = 'Fehler beim Bereinigen des Verzeichnisses "{$a}"';
$string['errorcopyingfiles'] = 'Fehler beim Kopieren der Dateien';
$string['errorcreatingdirectory'] = 'Fehler beim Erstellen des Verzeichnisses "{$a}"';
$string['errorcreatingfile'] = 'Fehler beim Erstellen der Datei "{$a}"';
$string['errorcreatingrole'] = 'Fehler beim Anlegen der Rolle';
$string['errorfetchingrssfeed'] = 'Fehler beim Holen eines RSS Feeds';
$string['erroronline'] = 'Fehler in Zeile {$a}';
$string['errorparsingxml'] = 'Fehler beim Parsen von XML: {$a->errorstring} in Zeile {$a->errorline}, Zeichen {$a->errorchar}';
$string['errorreadingfile'] = 'Fehler beim Lesen der Datei "{$a}"';
$string['errorsavingrequest'] = 'Fehler beim Versuch, Ihre Abfrage zu speichern';
$string['errorsettinguserpref'] = 'Fehler beim Setzen der Nutzereinstellungen';
$string['errorunzippingfiles'] = 'Fehler beim Entpacken der Dateien';
$string['expiredkey'] = 'Abgelaufener Schlüssel';
$string['externalauthpassworderror'] = 'Nichtleeres Kennwort zur externen Authentifizierung';
$string['failtoloadblocks'] = 'Mindestens ein Block ist in der Datenbank registriert, kann aber nicht geladen werden!';
$string['fieldrequired'] = '"{$a}" ist ein Pflichtfeld';
$string['fileexists'] = 'Datei existiert bereits';
$string['filemismatch'] = 'Fehlerhafter Dateiname - die Datei "{$a->current}" sollte {$a->file} heißen.';
$string['filenotfound'] = 'Die gesuchte Datei wurde nicht gefunden.';
$string['filenotreadable'] = 'Datei ist nicht lesbar';
$string['filterdoesnothavelocalconfig'] = 'Der Filter {$a} erlaubt keine lokalen Einstellungen.';
$string['filternotactive'] = 'Der Filter {$a} ist momentan nicht aktiviert';
$string['filternotenabled'] = 'Filter nicht aktiviert!';
$string['filternotinstalled'] = 'Der Filter {$a} ist momentan nicht installiert';
$string['forumblockingtoomanyposts'] = 'Sie haben die Höchstzahl der zulässigen Beiträge für dieses Forum erreicht';
$string['generalexceptionmessage'] = 'Sonderfall - {$a}';
$string['gradepubdisable'] = 'Das Veröffentlichen von Bewertungen ist deaktiviert';
$string['groupalready'] = 'Nutzer/in gehört bereits zur Gruppe {$a}';
$string['groupexistforcourse'] = 'Die Gruppe "{$a}" existiert bereits in diesem Kurs';
$string['groupnotaddederror'] = 'Die Gruppe "{$a}" wurde nicht hinzugefügt';
$string['groupunknown'] = 'Die Gruppe "{$a}" gehört nicht zum ausgewählten Kurs.';
$string['groupusernotmember'] = 'Nutzer/in ist kein Mitglied dieser Gruppe.';
$string['guestnocomment'] = 'Gäste dürfen keine Kommentare schreiben!';
$string['guestnoeditprofile'] = 'Gäste dürfen das Profil nicht bearbeiten';
$string['guestnoeditprofileother'] = 'Das Profil für Gäste kann nicht bearbeitet werden';
$string['guestnorate'] = 'Gäste dürfen keine Beiträge bewerten';
$string['guestsarenotallowed'] = 'Gäste dürfen dies nicht';
$string['hackdetected'] = 'Hacker-Angriff entdeckt!';
$string['hashpoolproblem'] = 'Falscher Inhalt in der Basisdatei {$a}';
$string['headersent'] = 'Header wurde bereits gesendet';
$string['idnumbertaken'] = 'ID-Nummer wird für anderen Kurs bereits genutzt';
$string['importformatnotimplement'] = 'Entschuldigung, der Import dieses Formats wird zur Zeit nicht unterstützt!';
$string['incorrectext'] = 'Die Datei hat eine inkorrekte Dateierweiterung.';
$string['internalauthpassworderror'] = 'Fehlendes Kennwort oder ungültige Kennwortregeln zur internen Authentifizierung';
$string['invalidaccess'] = 'Auf diese Seite wurde nicht richtig zugegriffen';
$string['invalidaccessparameter'] = 'Ungültiger Zugriffsparameter';
$string['invalidaction'] = 'Ungültiger Aktionsparameter';
$string['invalidactivityid'] = 'Ungültige Aktivitäten-ID';
$string['invalidadminsettingname'] = 'Ungültige Admin-Einstellungen ({$a})';
$string['invalidargorconf'] = 'Keine gültigen Argumente angegeben oder falsche Server-Konfiguration';
$string['invalidarguments'] = 'Keine gültigen Argumente angegeben';
$string['invalidblockinstance'] = 'Ungültige Block-Instanz: {$a}';
$string['invalidcategory'] = 'Falscher Kursbereich!';
$string['invalidcategoryid'] = 'Falsche Kursbereichs-ID!';
$string['invalidcomment'] = 'Falscher Kommentar';
$string['invalidcommentarea'] = 'Ungültiger Kommentarbereich';
$string['invalidcommentid'] = 'Ungültige Kommentar-ID';
$string['invalidcommentitemid'] = 'Ungültige Kommentar-ID';
$string['invalidcommentparam'] = 'Ungültige Kommentarparameter';
$string['invalidcomponent'] = 'Ungültiger Komponentenname';
$string['invalidconfirmdata'] = 'Ungültige Bestätigungsdaten';
$string['invalidcontext'] = 'Ungültiger Kontext';
$string['invalidcourse'] = 'Ungültiger Kurs';
$string['invalidcourseid'] = 'Sie versuchen, eine ungültige Kurs-ID zu benutzen: ({$a})';
$string['invalidcourselevel'] = 'Falsche Kontext-Stufe';
$string['invalidcoursemodule'] = 'Ungültige Kursmodul-ID';
$string['invalidcoursenameshort'] = 'Ungültige Kurzbezeichnung für den Kurs';
$string['invaliddata'] = 'Übermittelte Daten sind ungültig';
$string['invaliddatarootpermissions'] = 'Ungültige Berechtigungen im $CFG->dataroot Verzeichnis entdeckt. Der Administrator sollte dies korrigieren.';
$string['invalidelementid'] = 'Falsche Element-ID';
$string['invalidentry'] = 'Dies ist kein gültiger EIntrag!';
$string['invalidevent'] = 'Ungültiges Ereignis';
$string['invalidfieldname'] = '"{$a}" ist ein ungültiger Feldname.';
$string['invalidfiletype'] = '"{$a}" ist ein unzulässiger Dateityp.';
$string['invalidformatpara'] = 'Falsches Format der Auswahlparameter';
$string['invalidformdata'] = 'Falsche Formulardaten!';
$string['invalidfunction'] = 'Falsche Funktion';
$string['invalidgradeitmeid'] = 'Falsche Bewertungsaspekt-ID';
$string['invalidgroupid'] = 'Falsche Gruppen-ID angegeben';
$string['invalidipformat'] = 'Ungültiges IP-Adressformat';
$string['invaliditemid'] = 'Falsche Aspekt-ID';
$string['invalidkey'] = 'Falscher Schlüssel';
$string['invalidlegacy'] = 'Falsche Rollenvererbung für den Typ: {$a}';
$string['invalidmd5'] = 'Der Prüfwert ist ungültig. Versuchen Sie es bitte nochmal!';
$string['invalidmode'] = 'Ungültiger Modus ({$a})';
$string['invalidmodule'] = 'Ungültiges Modul';
$string['invalidmoduleid'] = 'Ungültige Modul-ID';
$string['invalidmodulename'] = 'Ungültiger Modulname: {$a}';
$string['invalidnum'] = 'Ungültiger Zahlenwert';
$string['invalidnumkey'] = 'Das Feld $conditions darf keine numerischen Schlüssel enthalten. Bitte korrigieren Sie den Code!';
$string['invalidoutcome'] = 'Falsche Lernziel ID';
$string['invalidpagesize'] = 'Ungültige Seitengröße';
$string['invalidpasswordpolicy'] = 'Ungültige Kennwortregeln';
$string['invalidpaymentmethod'] = 'Falsche Zahlungsmethode: {$a}';
$string['invalidqueryparam'] = 'FEHLER: Inkorrekte Anzahl von Anfrage-Parametern. Erwartet: {$a->expected}, bekommen: {$a->actual}.';
$string['invalidrecord'] = 'Datensatz kann nicht in der Datenbanktabelle {$a} gefunden werden';
$string['invalidrecordunknown'] = 'Datensatz kann nicht in der Datenbank gefunden werden';
$string['invalidrequest'] = 'Ungültige Abfrage';
$string['invalidrole'] = 'Ungültige Rolle';
$string['invalidroleid'] = 'Ungültige Rollen-ID';
$string['invalidscaleid'] = 'Falsche Skalen-ID';
$string['invalidsection'] = 'Kursmoduldatensatz enthält ungültigen Abschnitt';
$string['invalidsesskey'] = 'Falsche sesskey übergeben, Formular nicht akzeptiert!';
$string['invalidshortname'] = 'Die Kurzbezeichnung für den Kurs ist ungültig';
$string['invalidstatedetected'] = 'Eigentlich hätte hier kein Fehler passieren dürfen: {$a}';
$string['invalidurl'] = 'Ungültige URL';
$string['invaliduser'] = 'Ungültige Nutzer/in';
$string['invaliduserid'] = 'Ungültige Nutzer-ID';
$string['invalidxmlfile'] = '"{$a}" ist eine ungültige XML-Datei.';
$string['iplookupfailed'] = 'Die Geo-Informationen zu dieser IP-Adresse konnten nicht gefunden werden: {$a}';
$string['iplookupprivate'] = 'Private IP-Adressen können nicht lokalisiert werden';
$string['ipmismatch'] = 'IP-Adresse passt nicht';
$string['listcantmovedown'] = 'Fehler beim Verschieben nach unten, denn dieses Element ist das letzte seiner Art';
$string['listcantmoveleft'] = 'Fehler beim Verschieben des Elements nach links, denn es besitzt keine Vorgänger.';
$string['listcantmoveright'] = 'Fehler beim Verschieben des Elements nach rechts, denn es existiert kein Gleiches (Peer), um dieses zum Nachfolger zu machen. Bewegen Sie das Element zuerst unter ein anderes Gleiches (Peer), danach wird das Bewegen nach rechts möglich sein.';
$string['listcantmoveup'] = 'Fehler beim Verschieben des Elements nach oben, denn dieses Element ist das letzte seiner Art';
$string['listnochildren'] = 'Keine Nachfolger (Children) des Elements gefunden.';
$string['listnoitem'] = 'Element konnte nicht gefunden werden';
$string['listnopeers'] = 'Keine Gleichen (Peers) zum Element gefunden.';
$string['listupdatefail'] = 'Datenbankfehler bei der Bearbeitung der Listenhierarchie';
$string['logfilenotavailable'] = 'Keine Logdaten verfügbar';
$string['loginasnoenrol'] = 'Das "Einschreiben" oder "Abmelden" für einem Kurs ist nicht möglich, wenn Sie als andere Person angemeldet sind.';
$string['loginasonecourse'] = 'Sie können sich in diesen Kurs nicht eintragen.<br /> Beenden Sie zuerst die Funktion "Login als", um sich dann in den anderen Kurs einzutragen.';
$string['maxbytes'] = 'Diese Datei ist größer als die Maximalgröße';
$string['messagingdisable'] = 'Das Messaging-System ist für diese Website deaktiviert';
$string['mimetexisnotexist'] = 'Ihr System ist nicht richtig konfiguriert, um mimeTeX ausführen zu können. Sie müssen das geeignete Programm für Ihr Betriebssystem unter der Adresse <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a> herunterladen. Alternativ können Sie sich auch den C-Quellcode unter <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a> herunterladen, kompilieren und dann das ausführbare Programm in das Verzeichnis moodle/filter/tex/ legen.';
$string['mimetexnotexecutable'] = 'Das spezifische Programm mimetex ist nicht ausführbar!';
$string['missingfield'] = 'Feld "{$a}" fehlt';
$string['missingkeyinsql'] = 'Fehler: fehlender Parameter "{$a}" in der Abfrage';
$string['missing_moodle_backup_xml_file'] = 'XML-Datei im Backup fehlt: {$a}';
$string['missingparam'] = 'Notwendiger Parameter "{$a}" fehlt';
$string['missingparameter'] = 'Fehlender Parameter';
$string['missingrequiredfield'] = 'Einige erforderliche Felder sind nicht ausgefüllt.';
$string['missinguseranditemid'] = 'Fehlende userid und itemid';
$string['missingvarname'] = 'Erforderlicher Variablenname fehlt!';
$string['mixedtypesqlparam'] = 'Fehler: Verwechselte Typen bei den SQL-Abfrageparametern!!';
$string['mnetdisable'] = 'MNET ist deaktiviert';
$string['mnetlocal'] = 'Entfernte MNET-Nutzer können sich nicht lokal anmelden';
$string['moduledisable'] = 'Das Modul "{$a}" wurde für diesen speziellen Kurs deaktiviert.';
$string['moduledoesnotexist'] = 'Dieses Modul gibt es nicht';
$string['moduleinstancedoesnotexist'] = 'Die Instanz dieses  Moduls gibt es nicht';
$string['modulemissingcode'] = 'Im Modul {$a} fehlt der Code, um diese Funktion auszuführen.';
$string['multiplerecordsfound'] = 'Mehrere Datensätze gefunden, aber nur ein Datensatz wird erwartet';
$string['multiplerestorenotallow'] = 'Eine mehrfache Ausführung der Wiederherstellung ist nicht erlaubt!';
$string['mustbeloggedin'] = 'Sie müssen sich anmelden, um dies zu tun.';
$string['mustbeteacher'] = 'Diese Seite können Sie nur als Trainer/in ansehen.';
$string['myisamproblem'] = 'Die Datenbank nutzt die Database Engine MyISAM. Es wird empfohlen, stattdessen eine ACID-konforme Engine mit vollständigem Transactionsupport zu verwenden, z.B. InnoDB.';
$string['needcopy'] = 'Sie müssen zuerst etwas kopieren';
$string['needcoursecategroyid'] = 'Die Kurs ID oder Kategorie muss definiert werden.';
$string['needphpext'] = 'Sie müssen {$a} -Unterstützung in Ihrer PHP-Installation hinzufügen';
$string['noadmins'] = 'Keine Adminstratoren!';
$string['noblocks'] = 'Keine Blöcke gefunden!';
$string['nocapabilitytousethisservice'] = 'Nutzer/in besitzt nicht die notwendige Berechtigung, um diesen Service zu nutzen';
$string['nocategorydelete'] = 'Kursbereich "{$a}" kann nicht gelöscht werden!';
$string['nocontext'] = 'Dieser Kurs hat keine gültigen Zusammenhänge.';
$string['nodata'] = 'Keine Daten';
$string['noexistingcategory'] = 'Keine Kategorie vorhanden';
$string['nofile'] = 'Keine Datei ausgewählt';
$string['nofiltersenabled'] = 'Keine Filter aktiviert';
$string['nofolder'] = 'Gesuchtes Verzeichnis existiert nicht';
$string['noformdesc'] = 'Für diese Aktivität wurde keine Formularbeschreibungsdatei formslib gefunden.';
$string['noguest'] = 'Keine Gäste!';
$string['noinstances'] = 'Es gibt keine Instanzen von {$a} in diesem Kurs!';
$string['nologinas'] = 'Sie können sich nicht in der Rolle dieses Nutzers einloggen';
$string['nonmeaningfulcontent'] = 'Kein sinnvoller Inhalt';
$string['noparticipants'] = 'Keine Teilnehmer/innen für diesen Kurs gefunden';
$string['noparticipatorycms'] = 'Sie haben keine beteiligten Kursmodule für einen Bericht.';
$string['nopermissions'] = 'Sie besitzen derzeit keine Rechte, dies zu tun ({$a}).';
$string['nopermissiontocomment'] = 'Sie können keine Kommentare hinzufügen';
$string['nopermissiontodelentry'] = 'Sie dürfen keine fremden Einträge löschen!';
$string['nopermissiontoeditcomment'] = 'Sie dürfen keine fremden Kommentare bearbeiten!';
$string['nopermissiontohide'] = 'Keine Berechtigung zum Verbergen!';
$string['nopermissiontoimportact'] = 'Sie haben nicht die notwendigen Berechtigungen zum Import von Aktivitäten in diesem Kurs.';
$string['nopermissiontolock'] = 'Keine Berechtigung zum Sperren!';
$string['nopermissiontomanagegroup'] = 'Sie haben nicht die Berechtigung, um Gruppen zu verwalten';
$string['nopermissiontorate'] = 'Bewertung von Beiträgen ist nicht erlaubt!';
$string['nopermissiontoshow'] = 'Keine Berechtigung zum Anzeigen!';
$string['nopermissiontounlock'] = 'Keine Berechtigung zum Freigeben!';
$string['nopermissiontoupdatecalendar'] = 'Sie haben derzeit keine Berechtigung, um den Termin zu aktualisieren ';
$string['nopermissiontoviewgrades'] = 'Bewertungen können nicht angezeigt werden';
$string['nopermissiontoviewletergrade'] = 'Fehlende Berechtigung zur Anzeige von Notenstufen';
$string['nopermissiontoviewpage'] = 'Sie haben keinen Zugriff auf diese Seite';
$string['nosite'] = 'Die Kurshauptseite wurde nicht gefunden!';
$string['nositeid'] = 'Keine Site-ID';
$string['nostatstodisplay'] = 'Es sind keine Daten zur Anzeige vorhanden.';
$string['notallowedtoupdateprefremotely'] = 'Sie sind nicht berechtigt, die Nutzereinstellungen aus der ferne zu aktualisieren.';
$string['notavailable'] = 'Dies ist zur Zeit nicht verfügbar.';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Sie sind nicht Mitglied dieser Gruppe im Kurs.';
$string['notownerofkey'] = 'Sie sind nicht der Eigentümer dieses Schlüssels';
$string['nousers'] = 'Kein Nutzer vorhanden!';
$string['onlyadmins'] = 'Diese Funktion können nur Administratoren/innen ausführen';
$string['onlyeditingteachers'] = 'Diese Funktion können nur Trainer/innen mit Bearbeitungsrecht ausführen';
$string['onlyeditown'] = 'Sie können nur eigene Informationen bearbeiten.';
$string['orderidnotfound'] = 'Die Befehls-ID {$a} wurde nicht gefunden';
$string['pagenotexist'] = 'Ein unerwarteter  Fehler ist aufgetreten, weil eine nicht existierende Seite aufgerufen werden sollte.';
$string['pathdoesnotstartslash'] = 'Ungültige Argumente eingetragen. Pfad darf nicht mit Slash beginnen!';
$string['pleasereport'] = 'Wenn Sie etwas Zeit haben, informieren Sie uns bitte darüber, was Sie versucht haben, bevor der Fehler auftrat.';
$string['pluginrequirementsnotmet'] = 'Das Plugin "{$a->pluginname}" ({$a->pluginversion}) konnte nicht installiert werden. Es erfordert eine neuere Version von Moodle (Sie verwenden zur Zeit Version {$a->currentmoodle} - benötigt wird aber Version {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Fehler: Datenbanktabellen-Prefix kann nicht leer sein.({$a})</p>
<p>Der Administrator muss dieses Problem beseitigen.</p>';
$string['prefixtoolong'] = '<p>Fehler: Datenbanktabellen-Prefix ist zu lang ({$a->dbfamily})</p>
<p>Der Administrator muss dieses Problem anpassen. Tabellen- Prefixes in {$a->dbfamily} sind max. {$a->maxlength} Zeichen lang.</p>';
$string['processingstops'] = 'Der Prozess wurde an dieser Stelle gestoppt. Verbleibende Schritte wurden nicht mehr durchgeführt.';
$string['redirecterrordetected'] = 'Nichtunterstützte Weiterleitung gefunden, Scriptausführung abgebrochen';
$string['refoundto'] = 'Kann ersetzt werden durch {$a}';
$string['refoundtoorigi'] = 'Ersetzt durch den Originalbetrag: {$a}';
$string['remotedownloaderror'] = 'Der Download auf Ihren Server konnte nicht ausgeführt werden. Prüfen Sie bitte die Proxy-Einstellungen, die PHP CURL Erweiterung wird dringend empfohlen.<br /><br />Die Datei <a href="{$a->url}">{$a->url}</a> muss nun manuell herunter geladen, entpackt und auf den Server nach "{$a->dest}" kopiert werden. there.';
$string['remotedownloadnotallowed'] = 'Der Download von Komponenten auf Ihren Server ist nicht erlaubt (allow_url_fopen ist deaktiviert). <br /><br /> Die Datei <a href="{$a->url}">{$a->url}</a> muss manuell heruntergeladen werden. Kopieren Sie die Datei nach "{$a->dest}" auf Ihren Server und entpacken Sie sie dort.';
$string['reportnotavailable'] = 'Dieser Berichtstyp ist nur für die Startseite verfügbar';
$string['requireloginerror'] = 'Kurs oder Aktivität nicht benutzbar';
$string['restorechecksumfailed'] = 'Bei der Wiederherstellung sind Probleme aufgetreten. Bitte prüfen Sie die Einstellungen \'PHP memory limit\' und \'DB package size\'.';
$string['restrictedcontextexception'] = 'Missachtung von Kontextbeschränkungen beim Ausführen einer externen Funktion';
$string['restricteduser'] = 'Mit Ihrer aktuellen Anmeldung \'{$a}\' sind Sie nicht zu dieser Aktion berechtigt.';
$string['reverseproxyabused'] = 'Die Einstellung Reverse Proxy wurde aktiviert. Entschuldigung, aber Sie können nicht direkt auf einen anderen Server zugreifen.<br />Bitte nehmen Sie Kontakt mit Ihrem Administrator auf.';
$string['rpcerror'] = 'Ihre MNET-Verbindung ist fehlgeschlagen! Bitte leiten Sie die Fehlermeldung an den Administrator weiter: {$a}';
$string['scheduledbackupsdisabled'] = 'Automatisch terminierte Backups wurden vom  Admin des Servers deaktiviert.';
$string['secretalreadyused'] = 'Der Link zur Passwortbestätigung wurde bereits verwendet. Das Passwort bleibt unverändert.';
$string['sectionnotexist'] = 'Dieser Abschnitt existiert nicht';
$string['sendmessage'] = 'Mitteilung senden';
$string['servicedonotexist'] = 'Service existiert nicht';
$string['sessioncookiesdisable'] = 'Fehlerhafte Verwendung von  require_key_login() - Session Cookie sollte deaktiviert werden!';
$string['sessiondiskfull'] = 'Die Session-Partition ist voll. Ein Login ist zu diesem Zeitpunkt nicht möglich.<br /><br />Bitte benachrichtigen Sie den Server-Administrator.';
$string['sessionerroruser'] = 'Die Zeit ist abgelaufen. Melden Sie sich bitte neu an.';
$string['sessionerroruser2'] = 'Ein Serverfehler ist aufgetreten. Er betrifft Ihre Login-Session. Loggen Sie sich bitte neu ein oder starten Sie Ihren Browser noch einmal.';
$string['sessionipnomatch'] = 'Die IP-Adresse scheint sich seit Ihrem letzten Login geändert zu haben. Dieses Sicherheitsfeature schützt Sie vor dem Diebstahl Ihrer Identität durch Hacker, während Sie auf der Seite arbeiten. Normale Nutzer sollten diese Mitteilung nicht sehen - bitten Sie den Administrator um Hilfe.';
$string['sessionipnomatch2'] = 'Entschuldigung, aber Ihre IP-Adresse hat sich geändert, seit Sie sich eingeloggt haben. Diese Sicherheitsoption schützt davor, dass Ihre Identität gestohlen werden kann, während Sie eingeloggt sind. Sie könnten diese Fehlermeldung auch erhalten, wenn Sie ein Funknetzwerk benutzen oder zwischen unterschiedlichen Netzwerken pendeln (roaming). Bitte fragen Sie für weitere Hilfe den Administrator Ihrer Website. <br /><br />Falls Sie weitermachen möchten, aktualisieren Sie bitte die Seite.';
$string['shortnametaken'] = 'Kurzbezeichnung wird schon für anderen Kurs genutzt';
$string['socksnotsupported'] = 'SOCKS5 Proxy wird in PHP4 nicht unterstützt';
$string['spellcheckernotconf'] = 'Rechtschreibhilfe ist nicht eingerichtet';
$string['sslonlyaccess'] = 'Entschuldigung, aber aus Sicherheitsgründen sind ausschließlich Verbindungen über HTTPS erlaubt';
$string['statscatchupmode'] = 'Die Statistiken befinden sich im sogenannten Catchup-Modus. Bisher sind {$a->daysdone} Tage verarbeitet und {$a->dayspending} Tage werden noch bearbeitet. Prüfen Sie es später noch einmal.';
$string['statsdisable'] = 'Statistik ist nicht aktiviert.';
$string['statsnodata'] = 'Für die Kombination aus Kurs und Zeitraum liegen keine Daten vor.';
$string['storedfilecannotcreatefiledirs'] = 'Beim Anlegen von lokalen Basisverzeichnissen gab es Probleme. Bitte prüfen Sie die Dateirechte im Verzeichnis dataroot.';
$string['storedfilecannotread'] = 'Datei kann nicht gelesen werden, weil es nicht existiert oder es Rechteprobleme gibt';
$string['storedfilenotcreated'] = 'Datei "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}/{$a->filepath}/{$a->filename}" kann nicht angelegt werden';
$string['storedfileproblem'] = 'Unbekannter Fehler mit lokalen Dateien ({$a})';
$string['tagdisabled'] = 'Schlagworte sind deaktiviert!';
$string['tagnotfound'] = 'Der verwendete Tag wurde in der Datenbank nicht gefunden.';
$string['targetdatabasenotempty'] = 'Die Zieldatenbank ist nicht leer. Aus Sicherheitsgründen wurde die Übertragung abgebrochen.';
$string['textconditionsnotallowed'] = 'Ein Vergleich der Textspaltenbedingungen ist nicht zugelassen. Bitte verwenden Sie in Ihrer Abfrage sql_compare_text() . ';
$string['themenotinstall'] = 'Dieses Design ist nicht verfügbar!';
$string['TODO'] = 'Zu erledigen';
$string['tokengenerationfailed'] = 'Das neue Token kann nicht erzeugt werden';
$string['transactionvoid'] = 'Transaktion konnte nicht geleert werden, da sie bereits leer war.';
$string['unenrolerror'] = 'Beim Austragen der Person ist ein Fehler aufgetreten.';
$string['unicodeupgradeerror'] = 'Ihre Datenbank ist bisher nicht im Unicode-Format. Da die zu installierende Moodle-Version nicht in der Lage ist, Ihre Datenbank entsprechend umzuwandeln, müssten Sie zuerst auf Moodle 1.7.x aktualisieren und die Unicode-Umwandlung vornehmen. Anschließend sollte es problemlos möglich sein, auf Moodle {$a} umzusteigen.';
$string['unknowaction'] = 'Unbekannte Aktion!';
$string['unknowcategory'] = 'Kursbereich ist unbekannt!';
$string['unknowcontext'] = 'Dies ist ein unbekannter Kontext "{$a}" in get_child_contexts()!';
$string['unknowformat'] = 'Unbekanntes Format ({$a})';
$string['unknownbackupexporterror'] = 'Unbekannter Fehler bei der Importbearbeitung';
$string['unknownblockregion'] = 'Der Blockbereich \'{$a}\' ist auf dieser Seite nicht zugelassen';
$string['unknowncontext'] = 'Unbekannter Kontext';
$string['unknowncourse'] = 'Unbekannter Kurs "{$a}"';
$string['unknowncourseidnumber'] = 'Unbekannte Kurs-ID "{$a}"';
$string['unknowncourserequest'] = 'Unbekannte Kursanfrage';
$string['unknownfiletype'] = 'Fehler: unbekannter Filtertyp';
$string['unknowngroup'] = 'Unbekannte Gruppe "{$a}"';
$string['unknownhelp'] = 'Unbekanntes Hilfethema "{$a}"';
$string['unknownjsinrequirejs'] = 'JS-Library \'{$a}\' kann nicht gefunden werden';
$string['unknownmodulename'] = 'Unbekannter Modulname für das Formular';
$string['unknownrole'] = 'Unbekannte Rolle "{$a}"';
$string['unknownsortcolumn'] = 'Unbekannte Sortierungsspalte {$a}';
$string['unknownuseraction'] = 'Diese Nutzeraktion wurde nicht verstanden.';
$string['unknownuserselector'] = 'Unbekannter Nutzerauswähler';
$string['unknoworder'] = 'Unbekannte Anforderung';
$string['unknowparamtype'] = 'Unbekannter Parametertyp: {$a}';
$string['unknowquestiontype'] = 'Nicht unterstützter Fragetyp: {$a}';
$string['unknowuploadaction'] = 'Fehler: Unbekannter Uploadvorgang ({$a})';
$string['unspecifycourseid'] = 'Es muss die Kurs-ID, die Kurzbezeichnung oder ID-Nummer angegeben werden.';
$string['unsupportedevent'] = 'Ereignistyp wird nicht unterstützt';
$string['unsupportedstate'] = 'Vollständigkeitsstatus wird nicht unterstützt';
$string['unsupportedwebserver'] = 'Die Webserver-Software ({$a}) wird nicht unterstützt';
$string['upgraderequires19'] = 'Fehler! Es wurde eine neue Moodle-Version auf dem Server installiert. Leider wird das direkte Upgrade auf diese Version nicht unterstützt!<br/>Führen Sie zuerst eine Upgrade auf die letzte Version von 1.9.x durch. Sie haben auch die Möglichkeit, auf die zuvor installierte Version zurückzugreifen wenn Sie die ursprünglichen Dateien wieder reinstallieren.';
$string['upgraderunning'] = 'Für die Website läuft gerade eine Aktualisierung. Bitte versuchen Sie es später nochmal.';
$string['urlnotdefinerss'] = 'URL für RSS-Feed nicht definiert';
$string['useradmineditadmin'] = 'Nur Administratoren können andere Administratorenaccounts bearbeiten.';
$string['useradminodelete'] = 'Administratoraccounts können nicht gelöscht werden';
$string['userautherror'] = 'Unbekanntes Plugin zur Authentifizierung';
$string['userauthunsupported'] = 'Plugin zur Authentifizierung wird nicht unterstützt';
$string['useremailduplicate'] = 'Doppelte Adresse';
$string['usermustbemnet'] = 'Nutzer in der MNET Zugangskontroll-Liste sollten Remote MNET Nutzer sein.';
$string['usernotaddederror'] = 'Nutzer wurde nicht hinzugefügt - Fehler';
$string['usernotaddedregistered'] = 'Nutzer wurde nicht hinzugefügt - er/sie war bereits registriert.';
$string['usernotavailable'] = 'Sie können die Details für diese/n Nutzer/in nicht einsehen.';
$string['usernotdeletedadmin'] = 'Nutzerkonto nicht gelöscht - Administratorkonten können nicht gelöscht werden';
$string['usernotdeletederror'] = 'Nutzer/in wurde nicht gelöscht - unbekannter Fehler';
$string['usernotdeletedmissing'] = 'Nutzer/in wurde nicht gelöscht - Anmeldename wurde nicht gefunden';
$string['usernotdeletedoff'] = 'Nutzer/in nicht gelöscht - Löschen ist nicht erlaubt';
$string['usernotincourse'] = 'Der Nutzer ist nicht in diesem Kurs!';
$string['usernotrenamedadmin'] = 'Administrator/in-Accounts können nicht umbenannt werden.';
$string['usernotrenamedexists'] = 'Nutzer/in wurde nicht umbenannt - der eingegebene Nutzername wird bereits verwendet';
$string['usernotrenamedmissing'] = 'Nutzer/in wurde nicht umbenannt - der alte Nutzername wurde nicht gefunden.';
$string['usernotrenamedoff'] = 'Nutzer/in nicht umbenannt - Umbenennen ist nicht erlaubt.';
$string['usernotupdatedadmin'] = 'Administrator-Accounts können nicht aktualisiert werden.';
$string['usernotupdatederror'] = 'Nutzer/in nicht aktualisiert - unbekannter Fehler';
$string['usernotupdatednotexists'] = 'Nutzer/in nicht aktualisiert - der Account existiert nicht.';
$string['userquotalimit'] = 'Sie haben die Obergrenze für Ihren Datenquota erreicht.';
$string['userselectortoomany'] = 'Die Auswahl user_selector erhielt mehr als eine/n ausgewählten Nutzer/in, obwohl die Mehrfachauswahl (multiselect) deaktiviert ist.';
$string['wrongcall'] = 'Das Skript wurde falsch aufgerufen';
$string['wrongcontextid'] = 'Kontext-ID war falsch (konnte nicht gefunden werden)';
$string['wrongdestpath'] = 'Falscher Pfad';
$string['wrongroleid'] = 'Falsche Rollen-ID';
$string['wrongsourcebase'] = 'Falsche URL-Quelle';
$string['wrongusernamepassword'] = 'Nutzer/in oder Kennwort falsch';
$string['wrongzipfilename'] = 'Falscher ZIP-Dateiname';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Kurs nicht erstellt - fehlende Berechtigung';
$string['wwwrootmismatch'] = 'Ein falscher Zugriff wurde festgestellt. Entschuldigung, aber auf dieser Server sollte ausschließlich über die Adresse "{$a}" zugegriffen werden. Bitte benachrichtigen Sie den Administrator Ihres Servers.';
$string['wwwrootslash'] = 'In der Datei config.php wurde eine falsche Einstellung für $CFG->wwwroot festgestellt. Es darf kein abschließender Slash \'/\' gesetzt sein.<br />Bitte benachrichtigen Sie den Administrator Ihres Servers.';
$string['xmldberror'] = 'XMLDB-Fehler!';
$string['youcannotdeletecategory'] = 'Sie können die Kategorie "{$a}" nicht löschen, da Sie deren Inhalt weder löschen noch verschieben können.';
