<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sv', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Tillträde medgavs inte';
$string['accounts'] = 'Konton';
$string['addcategory'] = 'Lägg till en kategori';
$string['additionalhtml'] = 'Kompletterande HTML';
$string['additionalhtml_desc'] = 'Dessa inställningar låter dig ange HTML kod som du vill ska läggas till varje sida. Du kan ange HTML som kommer att läggas inom HEAD taggen för sidan, direkt efter att body-taggen har öppnats, eller omedelbart innan body-taggen stängs. <br /> Du kan lägga till egna sidhuvud eller sidfot på varje sida, eller lägga till stöd för tjänster som Google Analytics väldigt lätt och oberoende av ditt valda tema.';
$string['additionalhtmlfooter'] = 'Innan BODY avslutas';
$string['additionalhtmlfooter_desc'] = 'Innehåll som finns här kommer att upprepas på alla sidor straxt innan taggen för body stängs. ';
$string['additionalhtmlhead'] = 'Inom HEAD';
$string['additionalhtmlhead_desc'] = 'Innehåll här läggs till botten av HEAD taggen på varje sida.';
$string['additionalhtml_heading'] = 'Kompletterande HTML som ska läggas till till varje sida,';
$string['additionalhtmltopofbody'] = 'När BODY öppnas';
$string['additionalhtmltopofbody_desc'] = 'Innehåll här kommer att läggas in på varje sida omedelbart efter den inledande body-taggen.';
$string['admincategory'] = 'Kategori: {$a}';
$string['adminseesall'] = 'Administratörer ser allt';
$string['adminseesallevents'] = 'Administratörer ser alla händelser';
$string['adminseesownevents'] = 'Administratörer har samma status som alla andra användare';
$string['advancedfeatures'] = 'Avancerade egenskaper';
$string['allcountrycodes'] = 'Alla landkoder';
$string['allowbeforeblock'] = 'Den tillåtna listan kommer att behandlas först';
$string['allowbeforeblockdesc'] = 'Som standard poster i listan över blockerade IP matchas först. Om det här alternativet är aktivt, kommer posterna i den tillåtna IP listan bearbetas innan den blockerade listan.';
$string['allowblockstodock'] = 'Tillåt blocken att använda dockan';
$string['allowcategorythemes'] = 'Tillåt teman för kategorier';
$string['allowcoursethemes'] = 'Tillåt teman för kurser';
$string['allowediplist'] = 'Lista över tillåtna IP-adresser';
$string['allowemailaddresses'] = 'Tillåt  domäner för e-post';
$string['allowframembedding'] = 'Tillåt inbäddning av ramar';
$string['allowframembedding_help'] = 'Tillåt inbäddning av denna webbplats i ramar på externa webbplatser. Aktivering av denna funktion rekommenderas inte av säkerhetsskäl.';
$string['allowguestmymoodle'] = 'Tillåt gäståtkomst till Mitt hem';
$string['allowobjectembed'] = 'Tillåt EMBED- och OBJECT-taggar';
$string['allowthemechangeonurl'] = 'Tillåt ändringar av teman i URLen';
$string['allowuserblockhiding'] = 'Tillåt användarna att dölja block';
$string['allowuserswitchrolestheycantassign'] = 'Tillåt användare utan kapacitet att tilldela roller att ändå byta roller.';
$string['allowuserthemes'] = 'Tillåt användarna att välja teman';
$string['antivirus'] = 'Antivirus';
$string['appearance'] = 'Utseende';
$string['aspellpath'] = 'Sökväg till aspell';
$string['authentication'] = 'Autenticering';
$string['authpreventaccountcreation'] = 'Förhindra att skapa konto vid autentisering';
$string['authpreventaccountcreation_help'] = 'När en användare autentiserar,  skapas ett konto på webbplatsen automatiskt om den inte redan finns. Om en extern databas, såsom LDAP, används för autentisering, och du vill begränsa åtkomsten till webbplatsen för användare med ett befintligt konto dåå skall detta alternativ vara aktiverat.

Nya konton måste skapas manuellt eller via funktionen uppladdning av användare. Observera att denna inställning inte gäller MNET autentisering.';
$string['authsettings'] = 'Administrera autenticering';
$string['autolang'] = 'Identifiera språk automatiskt';
$string['autologinguests'] = 'Logga in gäster automatiskt';
$string['availablelicenses'] = 'Tillgängliga licenser';
$string['availableto'] = 'Tillgänglig till';
$string['backgroundcolour'] = 'Genomskinlig färg';
$string['backups'] = 'Säkerhetskopior';
$string['backup_shortname'] = 'Använd Kursens namn som filnamn för säkerhetskopian.';
$string['backup_shortnamehelp'] = 'Använd kursens namn som en del av filnamnet för säkerhetskopian.';
$string['badwordsconfig'] = 'Mata in Din lista över olämpliga ord separarerade med komman.';
$string['badwordsdefault'] = 'Om den specialutformade standardlistan är tom så kommer en generisk lista från språkpaketet att användas.';
$string['badwordslist'] = 'Standardlista över olämpliga ord';
$string['blockediplist'] = 'Lista över blockerade IP-adresser';
$string['blockeditingmenu'] = 'Block-redigerings meny';
$string['blockeditingmenu_desc'] = 'Om aktiverad kommer många av ikonerna för redigering av block, som visas när redigering är påslaget, att visas i en nedrullnings meny. Detta reducerar innehållet som visas på skärmen genom att gömma ikonerna tills de behövs.';
$string['blockinstances'] = 'Instanser';
$string['blockmultiple'] = 'Flerfaldiga';
$string['blockprotect'] = 'Skydda instanser';
$string['blockprotect_help'] = 'Om du låser en viss typ av block, då kommer ingen att kunna lägga till eller ta bort dem. (Då kan naturligtvis låsas upp igen om de behöver redigeras) Detta är avsett att skydda block såsom navigering och inställningar som är mycket svåra att få tillbaka om de oavsiktligt raderas.';
$string['blocksettings'] = 'Administrera block';
$string['blockunprotect'] = 'Ta bort skydd';
$string['bloglevel'] = 'Synlighet för bloggar';
$string['bookmarkadded'] = 'Ett bokmärke har lagts till';
$string['bookmarkalreadyexists'] = 'Du har redan bokmärkt den här sidan';
$string['bookmarkdeleted'] = 'Bokmärket har tagits bort.';
$string['bookmarkthispage'] = 'Bokmärk den här sidan';
$string['cacheapplication'] = 'Applikation cache';
$string['cacheapplicationhelp'] = 'Cachade objekt delas av alla användare och förfaller vid en bestämd tid.';
$string['cachejs'] = 'Cacha Javascript';
$string['cachejs_help'] = 'Om Du cachar och komprimerar Javascript så får du en markant förbättring av hur sidan laddas in. Detta rekommenderas starkt för skarpa webbplatser. Utvecklare föredrar troligen att avaktivera denna egenskap. ';
$string['cacherequest'] = 'Begär cache';
$string['cacherequesthelp'] = 'Användarspecifik cache som upphör när ansökan är klar. Designad för att ersätta de områden där vi använder statisk lagring.';
$string['cachesession'] = 'Session cache';
$string['cachesessionhelp'] = 'Användarspecifik cache som upphör när användarens session avslutas.';
$string['cachesettings'] = 'Cacheinställningar';
$string['cachetext'] = 'Så länge lagras text i cache-minnet';
$string['caching'] = 'Caching';
$string['calendarexportsalt'] = 'Salt av export av kalender';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendertyp';
$string['calendartype_desc'] = 'Välj en förvald kalendertyp för hela webbplatsen. Inställningen kan åsidosättas i kursinställningarna eller av användare i deras personliga profil.';
$string['calendar_weekend'] = 'Helgdagar';
$string['cannotdeletemodfilter'] = 'Du kan inte avinstallera \'{$a->filter}\' eftersom det är en del av \'{$a->module}\'-modulen.';
$string['cannotuninstall'] = '{$a} kan inte avinstalleras.';
$string['cfgwwwrootslashwarning'] = 'Du har definierat $CFG->wwwroot på fel sätt i din config.php-fil. Du har tagit med ett \'/\'-tecken på slutet. Var snäll och ta bort det om du inte vill råka ut för konstiga buggar som <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Du har definierat $CFG->wwwroot på fel sätt i din config.php-fil. Det matchar inte den URL som du använder för att få tillgång till den här sidan. Var snäll och ta bort det om du inte vill råka ut för konstiga buggar som <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'ändra';
$string['checkboxno'] = 'Nej';
$string['checkboxyes'] = 'Ja';
$string['choosefiletoedit'] = 'Välj en fil för redigering';
$string['clamfailureonupload'] = 'Om clam AV inte fungerar';
$string['cleanup'] = 'Rensa upp';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Fel, värdet "{$a->value}" för "{$a->option}" är inte korrekt.';
$string['cliincorrectvalueretry'] = 'Felaktigt värde, var snäll och försök igen';
$string['clistatusdisabled'] = 'Status: avaktiverad';
$string['clistatusenabled'] = 'Status: aktiverad';
$string['clistatusenabledlater'] = 'status: CLI underhållsläge kommer aktiveras på {$}';
$string['clitypevalue'] = 'Värde för typ';
$string['clitypevaluedefault'] = 'skriv in värdet, klicka på "Enter" om Du vill använda standardvärdet ({$a})';
$string['cliunknowoption'] = 'Ej identifierade alternativ: {$a} Var snäll och använd alternativet Hjälp.';
$string['cliupgradefinished'] = 'Kommandoraden uppdaterades framgångsrikt.';
$string['cliupgradenoneed'] = 'Ingen uppgradering behövs för den installerade versionen {$a}. Tack för att ni kom ändå!';
$string['cliyesnoprompt'] = 'skriv in y (betyder ja) eller n (betyder nej)';
$string['commentsperpage'] = 'Kommentarer, visade per sida';
$string['commonfiltersettings'] = 'Standardinställningar för filter';
$string['commonsettings'] = 'Vanliga inställningar';
$string['componentinstalled'] = 'En komponent har installerats';
$string['computedfromlogs'] = 'Beräknade från loggarna sedan {$a}.';
$string['condifmodeditdefaults'] = 'De värden du anger här definierar standardvärden som används i aktivitetsinställningarna när du skapar en ny aktivitet.';
$string['confeditorhidebuttons'] = 'Välj de knappar som ska vara dolda i HTML-redigeraren.';
$string['configallcountrycodes'] = 'Detta är en lista över länder som kan väljas på olika ställen, till exempel i en användares profil. Om det lämnas tomt (standard) i förteckningen i  countries.php används engelska språkpaketetet som standard. Detta är en lista från ISO 3166-1. Annars kan du ange en kommaseparerad lista av koder, till exempel \'GB, FR, ES\';. Om du lägger till nya, icke-standardiserade koder här, måste du lägga till dem countries.php i \'en\' och ditt språkpaket.';
$string['configallowassign'] = 'Du kan tillåta användare i rollerna på den vänstra sidan att tilldela några av rollerna i kolumnerna till andra användare.';
$string['configallowblockstodock'] = 'Om det är aktiverat och stöds av det valda temat kommer användarna att kunna välja att flytta block till en speciell docka.';
$string['configallowcategorythemes'] = 'Om Du aktiverar detta då går det att ställa in teman på nivån kategorier. Detta kommer att påverka alla \'barn\'-kategorier eller kurser om det inte är så att det finns ett tema som är inställt specifikt för dem. OBS! Om Du aktiverar teman för kategorier så kan det påverka systemets prestanda.';
$string['configallowcoursethemes'] = 'Om Du aktiverar detta så kommer det att bli möjligt för kurser att ställa in sina egna teman. Teman för kurser är giltiga över alla andra val av teman (webbplats, användare, eller teman för sessioner)';
$string['configallowemailaddresses'] = 'Om Du vill att alla nya e-postadresser ska höra till vissa specifika domäner, då ska Du skriva in dem i en kommaseparerad lista här. Alla andra domäner kommer att avvisas. Ett exempel: <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'Om alternativet aktiverats kommer gäster åt Mitt hem, annars omdirigeras gäster till webbplatsen förstasida.';
$string['configallowobjectembed'] = 'Som ett standardmässigt sätt att öka säkerheten så får användare inte bädda in multimedia inne i text (som Flash t.ex.) genom att använda taggarna EMBED eller OBJECT (det går dock att ta med multimedia på ett säkert sätt med hjälp av filtret för multimedia-plugins. Om Du vill tillåta dessa taggar så ska Du aktivera detta alternativ.';
$string['configallowoverride'] = 'Du kan tillåta användare med rollerna på den vänstra sidan att överskrida några av rollerna i kolumnerna.';
$string['configallowoverride2'] = 'Välj vilken roll/vilka roller som kan överridas av respektive roll i vänstra kolumnen.<br />Notera att dessa inställningar endast är applicerbara på användare som antingen har förmågan moodle/role:override eller förmågan moodle/role:safeoverride tillåtna.';
$string['configallowswitch'] = 'Välj vilka roller en användare kan växla till baserat på vilka roller denne redan har. Utöver en post i den här tabellen så måste en användare också ha förmågan moodle/role:switchroles för att kunna växla.<br />Notera att det endast är möjligt att växla till roller som har förmågan moodle/course:view och som inte har förmågan moodle/site:doanything så vissa kolumner i den här tabellen är inaktiverade.';
$string['configallowthemechangeonurl'] = 'Om aktiverad, kan temat ändras genom att lägga till antingen:<br />?theme=temanamn till alla Moodle URL (tex: minmoodlesite.com/?theme=afterburner ) eller <br />&theme=temanamn till valfri intern Moodle URL (tex: minmoodlesite.com/kurs/vy.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Vill Du att användare själva ska kunna välja att dölja/visa ytterkolumnerna (sidoblocken) på hela webbplatsen? Den här egenskapen använder Javascript och cookies för att komma ihåg statusen på varje ihopfällt block och detta påverkar bara det användaren själv ser.';
$string['configallowuserthemes'] = 'Om Du aktiverar detta så kommer det att bli möjligt för användare att ställa in sina egna teman. Teman för användare är giltiga över teman för webbplatsen (men inte över teman för kurser).';
$string['configallusersaresitestudents'] = 'Med tanke på webbplatsens hemsida, bör ALLA användare antas vara studenter/elever/deltagare/lärande? Om Du svarar \'Ja\' då kommer alla med ett bekräftat konto att kunna delta som student/elev/deltagare/lärande i dessa aktiviteter. Om Du svarar \'Nej\' kommer bara de användare som redan är deltagare i åtminstone en kurs att kunna ta del av dessa aktiviteter på hemsidan. Bara administratörer och (distans)lärare med speciella behörigheter kan agera som (distans)lärare i dessa aktiviteter på hemsidan.';
$string['configauthenticationplugins'] = 'Var snäll och välj de plugins som Du vill använda och arrangera dem i den ordning Du vill att de ska användas.  Självregistrering kommer att hanteras av det plugin-program som är förvalt i kolumnen \'Registrering\' (vanligtvis e-post).';
$string['configautolang'] = 'Identifiera standardspråket med hjälp av inställningen i webbläsaren. Om du avaktiverar detta så kommer standardinställningen för webbplatsen att användas.';
$string['configautologinguests'] = 'Ska besökare automatiskt loggas in som gäster när de klickar sig in i kurser med behörighet som gäster?';
$string['configbloglevel'] = 'Den här inställningen gör det möjligt för Dig att begränsa den nivå som kan användas för visning av användarbloggar på den här webbplatsen. Lägg märke till att de anger det maximala sammanhanget för DEN SOM DET VISAS FÖR och inte för den som har gjort inlägget i bloggen eller typerna av blogginlägg. Du kan även avaktivera bloggar helt och hållet om du inte alls vill ha dem.';
$string['configcachetext'] = 'För större webbplatser och webbplatser som använder textfilter kan den här inställningen verkligen snabba upp saker och ting. Kopior av texter kommer att bevaras i sin processade form under den tid som är angiven här. Att ange en alltför kort tid kan göra systemet något långsammare men att ange en alltför lång tid innebär att det tar för lång tid att uppdatera långa texter (med nya länkar t.ex.).';
$string['configcalendarcustomexport'] = 'Aktivera anpassade datumintervall för export av kalender';
$string['configcalendarexportsalt'] = 'Denna slumpmässiga text används för att förbättra säkerheten av autentiseringstoken som används för export av kalendrar. Observera att alla aktuella tokens ogiltigförklaras om du ändrar det här hash saltet.';
$string['configclamactlikevirus'] = 'Behandla filerna som virus';
$string['configclamdonothing'] = 'Behandla filerna som godkända';
$string['configclamfailureonupload'] = 'Om Du har konfigurerat clam så att det ska skanna uppladdade filer men på ett sådant sätt att det är fel gjort eller om det inte går att köra av någon anledning, hur ska det då bete sig? Om Du väljer "Behandla filerna som virus" då kommer de att flyttas till en karantän eller också tas de bort. Om Du väljer "Behandla filerna som godkända" så kommer filerna att flyttas till målkatalogen som vanligt. I vilket fall kommer administratören att få ett meddelande om att clam har misslyckats. Om Du väljer "Behandla filerna som virus" och clam av någon anledning inte fungerar som det ska (vanligtvis för att Du har angivit felaktig pathtoclam) så kommer ALLA filer att flyttas till den angivna karantänen eller tas bort. Var försiktig med denna inställning.';
$string['configconvertformat'] = 'Om <i>latex, dvips</i> och <i>konvertera</i> är tillgängliga, visas bilderna skapas med det angivna formatet. Om det inte är aktiverat kommer mimetex att användas och det kommer att skapa GIF-bilder.';
$string['configcookiehttponly'] = 'Detta aktiverar en ny PHP 5.2.0 egenskap - webbläsare instrueras att skicka en cookie med endast den riktiga http-förfrågan. Cookies bör inte vara tillgängliga för skriptspråk. Detta stöds inte av alla webbläsare så det kanske inte är fullt kompatibelt med nuvarande kod. Detta hjälper till att förhindra vissa typer av XSS attacker.';
$string['configcookiesecure'] = 'Om servern bara accepterar https-anslutningar så rekommenderar vi att man aktiverar utskickning av säkra cookies. Om detta är aktiverat så bör du försäkra dig om att webbservern inte accepterar http:// eller ställ in en permanent vidarekoppling till https:// address. När <em>wwwroot</em> adressen inte startar med https:// så stängs den här inställningen av automatiskt.';
$string['configcountry'] = 'Om Du väljer ett land här så kommer detta land att vara förvalt när det gäller nya användarkonton. Om Du vill tvinga användare att välja ett land så lämnar Du bara det här tomt.';
$string['configcourseoverviewfilesext'] = 'En komma separerad lista över tillåtna filändelser för kurssammanfattningar';
$string['configcourseoverviewfileslimit'] = 'Högsta antal filer som kan bifogas till en kurssammanfattning,';
$string['configcourserequestnotify'] = 'Skriv namnet  för användaren som skall meddelas vid nya kursfötfrågningar.';
$string['configcourserequestnotify2'] = 'Användare som ska meddelas vid en kursförfrågan. Endast användare som kan godkänna kursförfrågningar listas här.';
$string['configcoursesperpage'] = 'Mata in det antal kurser som ska visas per sida i förteckningen över kurser.';
$string['configcourseswithsummarieslimit'] = 'Det maximala antalet kurser som ska visas i en kurslista inklusive sammanfattningar innan den faller tillbaka till en enklare lista.';
$string['configcronclionly'] = 'Om detta är inställt så kommer det bara att vara möjligt att köra skriptet för cron från en kommandorad och inte via webben. Detta överskrider inställningen för lösenordet för cron här nedan.';
$string['configcronremotepassword'] = 'Detta innebär att det inte kommer att gå att köra skriptet cron.php via en webbläsare utan att ange lösenordet genom att använda den följande typen av URL <pre>
http://webbplats.exempel.com/admin/cron.php?password=opensesame
</pre> Om detta lämnas tomt så kommer det inte att krävas något lösenord.';
$string['configcurlcache'] = 'Time-to-live för  cURL cache i sekunder.';
$string['configcustommenuitems'] = 'Du kan konfigurera en anpassad meny här som visas av temat. Varje rad består av textmenyer, en länk URL (tillval) och ett verktygstips titel (tillval), åtskilda av | tecken. Du kan ange en struktur med bindestreck. Till exempel:

<pre>
Moodle community|http://moodle.org
-Moodle free support|http://moodle.org/support
-Moodle development|http://moodle.org/development
--Moodle Tracker|http://tracker.moodle.org
--Moodle Docs|http://docs.moodle.org
-Moodle News|http://moodle.org/news
Moodle company
-Moodle commercial hosting|http://moodle.com/hosting
-Moodle commercial support|http://moodle.com/support </pre>';
$string['configdbsessions'] = 'Om detta är avaktiverat så kommer den här inställningen att lagra information om aktuella sessioner. Detta är speciellt användbart för stora/hårt belastade webbplatser eller webbplatser som är byggda som kluster av servrar. På de flesta webbplatser så borde detta antagligen vara avaktiverat så att serverns hårddisk används istället. Lägg märke till att Du genom att ändra den här inställningen nu kommer att logga ut alla aktuella användare (inkl Dig själv). Om du använder MySQL var då snäll och säkerställ att \'max_allowed_packet\' i my.cnf (eller my.ini) är på åtminstone 4M.';
$string['configdebug'] = 'Om Du aktiverar det här så utökar Du PHP:s felrapportering. Systemet ger då ifrån sig fler varningar. Detta är av värde bara för utvecklare.';
$string['configdebugdisplay'] = 'Om detta är aktiverat så kommer felrapporteringen att ske via en HTML-sida. Detta är praktiskt men XHTML, JS, cookies och HTTP headers
fungerar i allmänhet inte med detta. Om detta är avaktiverat så kommer utdata att skickas till loggarna för Din server, vilket erbjuder bättre felsökning. Inställningen \'error_log\' i PHP styr vilken logg detta går till.';
$string['configdebugpageinfo'] = 'Aktivera detta om Du vill att informationen om sidan ska skrivas ut i sidfoten. ';
$string['configdebugsmtp'] = 'Aktivera detaljerad information om felsökning i samband med att e-post skickas till en SMTP-server.';
$string['configdebugvalidators'] = 'Aktivera om du vill ha länkar till externa valideringsservrar i sidfoten. Du kan behöva skapa nya användare med användarnamn <em>w3cvalidator</em> och aktivera gästaccess. Dessa förändringar kan ge obehöriga åtkomst till servern, använd inte detta på färdiga webbplatser!';
$string['configdefaulthomepage'] = 'Detta avgör hemsidan för inloggade användare';
$string['configdefaultrequestcategory'] = 'De kurser som användare efterfrågar kommer automatiskt att placeras i den här kategorin.';
$string['configdefaultrequestedcategory'] = 'Standarkategori att placera kurser som har begärts i, om de är godkända.';
$string['configdefaultuserroleid'] = 'Alla inloggade användare kommer att tilldelas de kapaciteter som ingår i den roll som Du anger här, detta på webbplatsnivån, TILLSAMMANS med vilken annan roll som helst som de kan ha tilldelats. Det förinställda standardvalet  är autenticerad användare (eller som \'gäst\' i äldre versioner). Lägg märke till att detta inte kommer att vara i konflikt med andra roller som de kan ha, det säkerställer bara att alla användare har kapaciteter som inte går att tilldela på kursnivån (inlägg i bloggar, administration av egen kalender osv).';
$string['configdeleteincompleteusers'] = 'Efter den här perioden kommer gamla, ofullständiga konton att tas bort.';
$string['configdeleteunconfirmed'] = 'Om Du använder autenticering med e-post så är detta den tid inom vilken ett svar från användarna kommer att accepteras. Efter att denna tid har gått ut så kommer alla icke bekräftade konton att tas bort.';
$string['configdenyemailaddresses'] = 'Om Du vill avvisa e-postadresser från specifika domäner så listar Du dem här på samma sätt. Alla andra domäner kommer att accepteras. Ett exempel:
<strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'Avaktivera möjligheten för användare att ändra bilder i användarprofilerna.';
$string['configdisplayloginfailures'] = 'Det här kommer (för utvalda användare) att visa information om inloggningar som inte har lyckats.';
$string['configdndallowtextandlinks'] = 'Aktivera eller inaktivera dra och släppa av text och länkar på en kurssida, vid sidan av att dra och släppa filer. Observera att släpa på text i Firefox eller mellan olika webbläsare är opålitlig och kan resultera i att inga data laddas upp, eller felaktig text laddas upp.';
$string['configdocroot'] = 'Detta definierar vägen till Moodle Docs. Du kan ändra detta om Du vill ha Du vill ha Din egen specialutformade externa dokumentation. Om Du gör det så måste Du dock tänka på att sökvägarna i Din dokumentation använder samma format som http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Om Du aktiverar detta så kommer länkarna till Moodle Docs att visas i ett nytt fönster.';
$string['configeditordictionary'] = 'Det här värdet kommer att användas om det inte finns någon stavningskontroll för aspell på användarens eget språk.';
$string['configeditorfontlist'] = 'Välj de typsnitt som ska visas i redigerarens nedrullningsmeny.';
$string['configemailchangeconfirmation'] = 'Kräv en e-postbekräftelse när användarna ändrar sin e-postadress i sin profil.';
$string['configenableajax'] = 'Den här inställningen tillåter Dig att kontrollera användningen av AJAX (avancerat gränssnitt mellan klient och server som använder sig av JavaScript) globalt på webbplatsen. Om den här inställningen är aktiverad så kommer användarna fortfarande att kunna göra ett val i sina profiler, annars kommer AJAX att vara avaktiverat för alla.';
$string['configenableblogs'] = 'Detta alternativ ger alla användare av webbplatsen tillgång till en egen blogg.';
$string['configenablecalendarexport'] = 'Aktivera export av och prenumeration på kalendrar.';
$string['configenablecomments'] = 'Aktivera kommentarer';
$string['configenablecourserequests'] = 'Det här kommer att tillåta alla användare att begära att en kurs ska skapas.';
$string['configenabledevicedetection'] = 'Möjliggör upptäckt av mobiler, smartphones, plattor eller standard (stationära datorer, bärbara datorer, etc.) för tillämpning av teman och andra funktioner.';
$string['configenablegroupmembersonly'] = 'Aktiverad kan tillgång till aktiviteter begränsas till gruppens medlemmar. Detta kan resultera i en ökad lasten på servern. Dessutom måste betygsbokens kategorier sättas upp på ett visst sätt för att säkerställa att aktiviteten är dold från icke-gruppmedlemmar.';
$string['configenablemobilewebservice'] = 'Aktivera mobiltjänst för den officiella Moodle app-en eller annan app som begär det. För mer information, läs {$a}';
$string['configenablerssfeeds'] = 'Den här omkopplaren kommer att aktivera RSS-inmatningar från hela webbplatsen. För att faktiskt se några förändringar så behöver Du aktivera RSS-inmatningar i de individuella modulerna också - gå till inställningar för moduler i Administration->konfiguration';
$string['configenablerssfeedsdisabled'] = 'Detta är inte tillgängligt eftersom RSS-inmatningar är avaktiverade på hela webbplatsen. För att aktivera dem behöver Du gå till inställning av variabler i Administration->konfiguration';
$string['configenablerssfeedsdisabled2'] = 'RSS-matningar är avaktiverade på servernivå. Du måste först aktivera dem i Server/RSS.';
$string['configenablesafebrowserintegration'] = 'Detta lägger till valet \'Kräv säker webbläsare för test\' till \'Säkerhet när du surfar\' fältet på testinställningsformuläret. Se http://www.safeexambrowser.org/ för mer information.';
$string['configenablestats'] = 'Om Du väljer \'Ja\' här så kommer Moodles cronjob att bearbeta loggarna och samla viss statistik. Beroende på hur mycket trafik det är på Din webbplats så kan det ta en del tid. Om Du aktiverar detta så kommer Du att kunna se en del intressanta grafer och statistik över alla Dina kurser, eller på basis av webbplatsen.';
$string['configenabletrusttext'] = 'Som förinställt standardval så kommer Moodle alltid att noggrant rensa användarinmatad text för att ta bort alla potentiellt dåliga skript, media osv som skulle kunna vara en säkerhetsrisk. Systemet med tillförlitligt innehåll är ett sätt att ge de specifika användare som Du har förtroende för, rätten att inkludera dessa avancerade egenskaper i sitt innehåll utan att Moodle rensar bort det. För att aktivera detta system så behöver Du först aktivera den här inställningen och sedan tilldela tillstånd för tillförlitligt  innehåll till en specifik roll i Moodle. Den text som skapas eller laddas upp av sådana användare kommer att markeras som tillförlitligt och kommer därför inte att rensas bort före visning.';
$string['configenablewebservices'] = 'Webbtjänster gör det möjligt för andra system att logga in till denna Moodle-site och utföra operationer. För extra säkerhet ska den här funktionen inaktiveras om du inte verkligen använder det.';
$string['configenablewsdocumentation'] = 'Aktivera automatisk generering av dokumentation för webbtjänster. En användare kan få tillgång till egen dokumentation på sidan för säkerhetsnycklar {$a}. Det visar endast dokumentationen för de aktiverade protokollen.';
$string['configerrorlevel'] = 'Välj det antal PHP-varningar som Du vill låta visas. \'Normalt\' är vanligtvis det bästa valet.';
$string['configexportlookahead'] = 'Dagar att se framåt under export';
$string['configexportlookback'] = 'Dagar att se tillbaka under export';
$string['configextendedusernamechars'] = 'Aktivera den här inställningen för att låta studenter/elever/deltagare/lärande att använda vilka tecken de vill i sina användarnamn (lägg märke till att detta inte påverkar deras riktiga namn). Standardvalet är "falskt" vilket innebär att man bara kan använda små alfanumeriska tecken, understrykning (_), bindestreck (-), punkt (.) eller snabel-a (@).';
$string['configextramemorylimit'] = 'Vissa skript som sökning, backup/restore eller cron kräver mer minne. Ställ in högre värden för stora webbplatser.';
$string['configfilterall'] = 'Filtrera alla strängar inklusive rubriker, navigationsrader osv. Detta är som mest användbart när Du använder multilang filtret. I andra fall kommer det att belasta Din server utan att tillföra så mycket.';
$string['configfiltermatchoneperpage'] = 'Automatiska filter för länkning kommer bara att skapa en enskild länk för den instansen av en matchande text som hittas på den kompletta sidan. Allt annat ignoreras.';
$string['configfiltermatchonepertext'] = 'Automatiska filter för länkning kommer bara att skapa en enskild länk för en matchande instans av en text i varje enhet (t.ex. block eller resurs etc) som hittas på den kompletta sidan. Allt annat ignoreras. Den här inställningen ignoreras om inställningen för en sida är \'Ja\'.';
$string['configfilteruploadedfiles'] = 'Om Du aktiverar detta så kommer Moodle att bearbeta alla uppladdade HTML- och textfiler genom dessa filter innan de visas.';
$string['configforcelogin'] = 'I normalfallet så kan folk, utan att logga in, se webbplatsens första sida och listan över kurser (men inte kurserna). Om Du vill tvinga dem att logga in innan de kan se någonting alls på webbplatsen så ska Du aktivera den här inställningen.';
$string['configforceloginforprofiles'] = 'Aktivera den här inställningen för att tvinga besökare att logga in via ett riktigt användarkonto (och inte som gäster) innan de får se sidan med användarnas profiler. Som standardval är detta avaktiverat ("falskt") så att presumptiva studenter/elever/deltagare/lärande kan publicera annonser (skräppost) eller annat olämpligt innehåll is sina profiler och detta blir då tillgängligt för alla. ';
$string['configfrontpage'] = 'De komponenter som Du väljer här ovan kommer att visas på webbplatsens ingångssida (första/hem).';
$string['configfrontpagecourselimit'] = 'Högsta antal kurser';
$string['configfrontpagecourselimithelp'] = 'Högsta antal kurser som visas på webbplatsens';
$string['configfrontpageloggedin'] = 'De komponenter som Du väljer här ovan kommer att visas på webbplatsens ingångssida (första/hem) när en användare har loggat in.';
$string['configfullnamedisplay'] = 'Detta definierar hur fullständiga namn visas. För de flesta enspråkiga webbplatser är standardinställningen \'För- och efternamn\' den bästa, men Du kan välja att dölja efternamnet helt och hållet eller låta det aktuella språkpaketet avgöra (en del språk har olika konventioner).';
$string['configgeoipfile'] = 'Placering av den binära datafilen GeoIP City. Den här filen är inte del av Moodle-distributionen så därför måste du hämta den separat från <a href="http://www.maxmind.com/">MaxMind</a>.
Du kan antingen köpa en kommersiell version eller använda den fria versionen. <br /> Ladda bara helt enkelt ner <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> och packa upp den i katalogen "{$a}" på din server.';
$string['configgetremoteaddrconf'] = 'Om din server finns bakom en reverse proxy, kan du använda denna inställning för att ange vilka HTTP-headers som är betrodda med fjärran IP-adressen. Headers läses i ordning, den första tillgängliga används.';
$string['configgradebookroles'] = 'Den här inställningen tillåter Dig att kontrollera vem som dyker upp i betygskatalogen. Användare behöver ha åtminstone en av dessa roller i kurs för att de ska visas i betygskatalogen för den kursen.';
$string['configgradeexport'] = 'Välj vilka exportformat för betygskatalogen som Du vill använda som Dina primära metoder för att exportera betyg. De valda \'plugin\'-programmen kommer då att ställas in och använda ett fält som kallas för \'senast exporterade\' för varje betyg. Detta kan t.ex. komma att resultera i det att exporterade betygsdata identifieras som \'ny/a\' eller \'uppdaterade\'. Om Du är osäker på vad detta innebär så bör Du inte markera några val angående detta.';
$string['confighiddenuserfields'] = 'Markera de fält med information om användare som Du vill dölja från andra användare än lärare i kursen/administratörer. Detta kommer att öka studenternas/elevernas/deltagarnas/de lärandes integritet. Håll nere CTRL-tangenten för att markera ett flertal fält.';
$string['configidnumber'] = 'Den här valmöjligheten specificerar följande: (a)Användarnas ska inte alls behöva ange ID-nummer (b) Användarna kan ange ID-nummer eller avstå från det (c) Användarna måste ange ID-nummer. Om användaren anger sitt ID-nummer så visas det i dennes Presentation.';
$string['configintro'] = 'På denna sida kan Du ange ett antal konfigurationsvariabler som hjälper Moodle att fungera tillfredställande på Din server. Bekymra Dig inte så mycket om det - standardvalen brukar fungera bra och Du kan alltid återvända senare till denna sida för att ändra inställningarna.';
$string['configintroadmin'] = 'På den här sidan kan Du konfigurera Ditt konto som administratör. Som administratör har Du fullständig kontroll över webbapplikationen. Se till att Du har ett säkert användarnamn och lösenord liksom en giltig e-postadress. Du kan skapa fler konton för administratörer senare.';
$string['configintrosite'] = 'Den här sidan låter Dig konfigurera första sidan på webbapplikationen och namnet på den här nya webbplatsen. Du kan komma tillbaka hit senare och ändra på inställningarna. Länken hit heter \'Webbplatsinställningar\'.';
$string['configiplookup'] = 'När Du klickar på en IP-adress (som t.ex. 34.12.222.93), som i loggarna så kommer Du att få se en karta med en kvalificerad gissning om var denna IP finns geografiskt. Det finns olika plugin-program för det här som Du kan välja bland, vart och ett har sina för- och nackdelar.';
$string['configkeeptagnamecase'] = 'Markera detta om Du vill att rubriker för intressen ska ha kvar den ursprungliga skiftlägeskänslighet som de användare som har skapat dem har angivit.';
$string['configlang'] = 'Välj ett förvalt språk för hela webbplatsen. Användarna kan välja ett annat språk senare via språkmeny eller inställningar i sin personliga profil.';
$string['configlanglist'] = 'Låt det här vara tomt om Du vill låta användare välja vilket språk de vill. Om Du vill kan Du dock förkorta språkvalsmenyn genom att mata in en komma-separerad lista med de språkkoder Du vill ha med. Ex. en, es_es,fr,it';
$string['configlangmenu'] = 'Välj om Du vill eller inte vill visa den generella språkmenyn på hemsidan, login-sidan osv. Detta påverkar inte användarnas möjlighet att välja språk i sina egna profiler.';
$string['configlangstringcache'] = 'Cachar alla språksträngar i kompilerade filer i  datakatalogen (moodledata). Om du översätter Moodle eller ändra strängar i Moodle källkoden så du avaktivera det här. Annars lämna den på för att få bättre prestanda.';
$string['configlatinexcelexport'] = 'Väljer teckenuppsättning vid export av Excel';
$string['configlocale'] = 'Välj en regionsinställning för hela webbplatsen (locale) - detta kommer att påverka format och språk för datum (även om dagarnas namn i kalendrarna inte påverkas). Du måste ha denna regionsinställning installerad på Ditt operativsystem. (i t ex linux. en_US.UTF-8 eller es_ES.UTF-8). Om Du inte vet vad Du skall välja, låt det vara tomt.';
$string['configloginhttps'] = 'Om Du aktiverar detta så kommer Moodle att använda en säker https-anslutning bara för sidan för inloggning (för att tillhandahålla säker inloggning). Sedan återgår systemet till den vanliga http-URLen för att snabba upp nerladdningen av sidor. VARNING: Den här inställningen KRÄVER att https är uttryckligen aktiverat på webbservern - om det inte är det så KAN DU STÄNGA DIG UTE FRÅN DIN EGEN WEBBPLATS.';
$string['configloglifetime'] = 'Detta specificerar hur länge Du vill spara loggar om användarnas aktiviteter. Loggar som är äldre än så raderas automatiskt. Det bästa är att spara loggarna så länge som möjligt ifall Du skulle behöva dem. Om Du emellertid har en hårt belastad server och får problem med dess prestanda kanske Du måste ta bort loggar för att spara systemresurser. Värden som är lägre än 30 rekommenderas inte eftersom statistiken kanske inte fungerar som den ska då.';
$string['configlookahead'] = 'Dagar till SeFramåt  (Lookahead)';
$string['configmaxbytes'] = 'Detta specificerar den övergipande maximala storleken på bifogade filer på hela webbsajten. Den här inställningen begränsas av inställningen i PHP-funktionen upload_max_filesize och inställningen i Apache-funktionen LimitRequestBody. Därutöver så begränsar \'maxbytes\' vilken skala som kan väljas på kurs- eller modulnivå.  Om \'Server Limit \' är valt så är det serverns maxvärde som kommer att gälla.';
$string['configmaxconsecutiveidentchars'] = 'Lösenorden får inte ha mer än detta antal på varandra följande identiska tecken. Använd 0 för att inaktivera den här kontrollen.';
$string['configmaxeditingtime'] = 'Detta anger den tid som folk har på sig att redigera om sina foruminlägg, kommentarer i ord- och begreppslistor etc. Vanligtvis är 30 minuter tillräcklig tid.';
$string['configmaxevents'] = 'Händelser innan SeFramåt (Lookahead)';
$string['configmaxusersperpage'] = 'Maximalt antal användare som visas inom användarväljaren i kurs, grupp, korhort, webservice mm.';
$string['configmessaging'] = 'Bör systemet för interna meddelanden mellan användare till webbplatsen vara aktiverat?';
$string['configmessagingallowemailoverride'] = 'Tillåt användare att få e-postmeddelanden som skickas till en annan e-postadress än den e-postadress användaren angett i sin profil';
$string['configmessagingdeletereadnotificationsdelay'] = 'Meddelanden som är lästa kan tas bort för att spara utrymme. Hur lång tid efter att ett meddelande har lästs kan det tas bort?';
$string['configmessaginghidereadnotifications'] = 'Dölj meddelanden som är lästa om händelser som foruminlägg när du tittar på meddelandehistoriken';
$string['configminpassworddigits'] = 'Lösenord måste ha åtminstone så här många siffror.';
$string['configminpasswordlength'] = 'Lösenord måste innehålla åtminstone så här många tecken.';
$string['configminpasswordlower'] = 'Lösenord måste innehålla åtminstone så här många små bokstäver.';
$string['configminpasswordnonalphanum'] = 'Lösenord måste innehålla åtminstone så här många icke alfanumeriska tecken.';
$string['configminpasswordupper'] = 'Lösenord måste innehålla åtminstone så här många stora bokstäver.';
$string['configmobilecssurl'] = 'En CSS-fil för att anpassa ditt mobil app-gränssnitt.';
$string['configmodchooserdefault'] = 'Skall aktivitetsväljaren presenteras för användarna som standard?';
$string['configmycoursesperpage'] = 'Maximalt antal kurser som visas i en lista för en användarens egna kurser';
$string['configmymoodleredirect'] = 'Den här inställningen tvingar fram vidarekoppling till /my för inloggningar för icke-administratörer och ersätter den översta delen av webbplatsens \'brödsmule\'-navigation med /my';
$string['configmypagelocked'] = 'Denna inställning förhindrar standardsidan från att redigeras av  icke-administratörer';
$string['confignavcourselimit'] = 'Begränsar antalet kurser som visas för användaren när de antingen inte är inloggad eller registrerad i någon kurs.';
$string['confignavshowallcourses'] = 'Denna inställning avgör om användare som är registrerade i kurser kan se kurser (lista alla kurser) i navigationen, som tillägg till Mina kurser (lisa över kurser de är registrerade på).';
$string['confignavshowcategories'] = 'Visa kurskategorier i navigationsmenyn och navigationsblock. Detta uppträder inte i kurser som användaren redan är registrerad till, dessa kommer fortfarande listas under Mina kurser utan kategorier.';
$string['confignotifyloginfailures'] = 'Om misslyckade inloggningar har registrerats kan e-postnoteringar skickas ut. Vem ska ha denna information?';
$string['confignotifyloginthreshold'] = 'Om notering av misslyckade inloggningar är aktiverat - hur många sådana försök av en användare från en IP-adress ska det till för att det ska vara värt att göra någon uppmärksam på det?';
$string['confignotloggedinroleid'] = 'Användare som inte är inloggade på webbplatsen kommer att behandlas som om de har tilldelats den här rollen på webbplatsnivå. Oftast kommer Du att gäster ska ha denna roll men Du kan skapa roller som är mer eller mindre restriktiva. Saker som t.ex. att skapa inlägg kräver fortfarande att användaren loggar in på ett korrekt sätt.';
$string['configopentogoogle'] = 'Om Du aktiverar den här inställningen så tillåter Du att Google går in på Din webbplats som gäst(Guest). Dessutom kommer de som kommer till Din webbplats via en Googlesökning att automatiskt loggas in som gäst (Guest). Lägg märke till att detta bara ger tillträde till kurser som redan tillåter åtkomst för gäster.';
$string['configoverride'] = 'Definierad i config.php';
$string['configpasswordpolicy'] = 'Om Du aktiverar detta så kommer Moodle att kontrollera användares lösenord i förhållande till en giltig policy för lösenord. Använd inställningarna här nedan för att ange vilken policy som ska gälla. Om Du väljer \'Nej\' så kommer ingen hänsyn att tas till dessa inställningar.';
$string['configpasswordresettime'] = 'Detta anger den tidsperiod användare har för att validera lösenord efter att ha begärt återställning av lösenord. 30 minuter är vanligtvis ett bra värde.';
$string['configpathtoclam'] = 'Path (sökväg) till Clam AV. Det är antagligen något i stil med /usr/bin/clamscan eller /usr/bin/clamdscan. Du behöver detta för att kunna få clam AV att fungera.';
$string['configpathtodu'] = 'Sökväg till du. Antagligen något i stil med /usr/bin/du. Om Du matar in detta så kommer sidor som visar innehåll i kataloger att köras mycket fortare för kataloger med många filer.';
$string['configperfdebug'] = 'Om Du aktiverar det här så kommer info om prestanda att skrivas ut i sidfoten på standardtemat.';
$string['configprofileroles'] = 'Lista över roller som är synliga på sidorna för användarprofiler och deltagare.';
$string['configprofilesforenrolledusersonly'] = 'För att förhindra missbruk av spammare, är profilbeskrivningar av användare som ännu inte registrerats i någon kurs gömda. Nya användare måste registrera sig i minst en kurs innan de kan lägga till några personliga uppgifter.';
$string['configprotectusernames'] = 'Som förinställt standardval så visar  forget_password.php inte några ledtrådar som tillåter att man gissar användarnamn eller e-postadresser.';
$string['configproxybypass'] = 'Kommaseparerad lista av (partiell) domännamn eller IP-adresser som ska kringgå proxy (t.ex. 192,168.,. Mydomain.com)';
$string['configproxyhost'] = 'Om denna <b>server</b> behöver en proxy (t.ex. en brandvägg) för att nå Internet, ange då proxyns namn (hostname) och port här. Låt det annars vara tomt.';
$string['configproxypassword'] = 'Det behövs ett lösenord för att få tillgång till internet via proxy, detta är  tomt om det inte finns något. (PHP cURL extension required).';
$string['configproxyport'] = 'Om servern behöver använda en proxy-dator, ange då proxy-datorn här.';
$string['configproxytype'] = 'Typ av webbproxy (PHP5 och cURL-extension krävs för SOCKS5-stöd).';
$string['configproxyuser'] = 'Det behövs ett användarnamn för att få tillgång till internet via proxy, detta är  tomt om det inte finns något. (PHP cURL extension required).';
$string['configquarantinedir'] = 'Om Du vill att clam AV ska flytta virussmittade filer till en katalog för karantän så skriver Du in det här. Det måste skrivbart för webbservern. Om Du lämnar detta tomt, eller om Du skriver in en katalog som inte finns eller som är skrivskyddad, så kommer de virussmittade filerna att tas bort. Ta inte med något avslutande snedstreck \'/\'.';
$string['configrecaptchaprivatekey'] = 'En teckensträng som används för kommunikation mellan din Moodle-server och recaptcha.net-servern. Hämta en för den här webbplatsen genom att besöka  http://recaptcha.net.';
$string['configrecaptchapublickey'] = 'En teckensträng som används för att visa
reCAPTCHA-elementet i formuläret för att  registrera sig. Gerererad av http://recaptcha.net.';
$string['configrequestcategoryselection'] = 'Tillåt valet av en kategori när du begär en kurs.';
$string['configrequestedstudentname'] = 'Ord för student/elev/deltagare/lärande i den begärda kursen';
$string['configrequestedstudentsname'] = 'Ord för studenter/elever/deltagare/lärande i den begärda kursen';
$string['configrequestedteachername'] = 'Ord för (distans)lärare, handledare, coach, mentor i den begärda kursen';
$string['configrequestedteachersname'] = 'Ord för (distans)lärare, handledare, coacher, mentorer i den begärda kursen';
$string['configrequiremodintro'] = 'Inaktivera det här alternativet om du inte vill tvinga användarna att ange beskrivning för varje aktivitet.';
$string['configrunclamavonupload'] = 'När detta är aktiverat så kommer clam AV att användas för att skanna alla uppladdade filer.';
$string['configrunclamonupload'] = 'Ska clam AV köras när filer laddas upp? Du behöver en korrekt sökväg (path) i pathtoclam för att detta ska fungera. (Clam AV är ett gratis virusprogram som Du kan ladda der från http://www.clamav.net/)';
$string['configsectioninterface'] = 'Gränssnitt';
$string['configsectionmail'] = 'E-post';
$string['configsectionmaintenance'] = 'Underhåll';
$string['configsectionmisc'] = 'Övrigt';
$string['configsectionoperatingsystem'] = 'Operativsystem';
$string['configsectionpermissions'] = 'Behörigheter';
$string['configsectionrequestedcourse'] = 'Begäran om kurs';
$string['configsectionsecurity'] = 'Säkerhet';
$string['configsectionstats'] = 'Statistik';
$string['configsectionuser'] = 'Användare';
$string['configsecureforms'] = 'Moodle kan använda ytterligare en säkerhetsnivå när systemet tar emot data från ett formulär. Om detta är aktiverat så jämförs webbläsarens variabel HTTP_REFERER med det aktuella formulärets adress. I några enstaka fall kan det ge upphov till problem om användaren utnyttjar en brandvägg (t.ex. Zonealarm) som är inställd på att ta bort HTTP_REFERER från sin webbtrafik,. Symptom på detta är att man "fastnar" på ett formulär. Om Dina användare har problem med loginsidan så kanske Du vill avaktivera den här inställningen även om det öppnar Din sajt för lösenordsattacker. Om Du är tveksam så är det bäst att låta inställningen \'Ja\' vara kvar.';
$string['configsessioncookie'] = 'Med den här inställningen kan Du ändra namnet på den \'cookie\' som används för sessioner i Moodle. Detta är valfritt och behövs egentligen bara när Du kör fler än en instans (kopia) av Moodle på samma webbplats.';
$string['configsessioncookiedomain'] = 'Detta tillåter dig att ändra domänen som Moodles kakor (cookies) är tillgänglöiga från. Detta är användbart för anpassningar av Moodle (tex authenserings- eller anmälningsplugins) som behöver dela Moodles sessionsinformation med en webbapplikation på en annan subdomän.  <strong>VARNING: det rekomenderas starkt att lämna denna inställning som förvalt (tomt) - ett felaktigt värde kommer förhindra all inloggning till webbplatsen.<strong>';
$string['configsessioncookiepath'] = 'Om Du behöver ändra den plats som webbläsaren skickar Moodle cookies till så kan Du ändra den här inställningen till en underkatalog på Din webbplats. Annars bör den förinställda standardinställningen \'/\' fungera bra.';
$string['configsessiontimeout'] = 'Om användare som är inloggade på den här webbplatsen är inaktiva under en lång tid (utan att ladda ner sidor) så loggas de automatiskt ut. (Deras session tar slut). Den här variabeln bestämmer hur lång den tiden ska vara.';
$string['configshowcommentscount'] = 'Visa kommentarsräkning, det kommer kosta ytterligare en databasfråga vid visning av kommentarslänk';
$string['configshowicalsource'] = 'Visa källinformation för iCal händelser';
$string['configshowsiteparticipantslist'] = 'Alla dessa studenter/elever/deltagare/lärande och (distans)lärare kommer att finnas med på listan över deltagare på webbplatsen. Vem ska har rätt att se denna lista?';
$string['configsitedefaultlicense'] = 'Webbplatslicens i standardformat';
$string['configsitedefaultlicensehelp'] = 'Standardlicensen för att publicera innehåll på den här webbplatsen.';
$string['configsitemaxcategorydepth'] = 'Maximalt djup för kategori';
$string['configsitemaxcategorydepthhelp'] = 'Detta anger det maximala djupet för underkategorier som expanderas vid visning av kategorier eller kombo lista. Djupare liggande kategorier kommer uppträda som länkar och användare kan expandera dessa med AJAX förfrågan.';
$string['configslasharguments'] = 'Filer (bilder, uppladdade filer etc) tillhandahålls via ett skript som använder \'slash arguments\' (det andra valet här). Denna metod låter filer lättare bli mellanlagrade i webbklienter, proxyservrar etc. Dessvärre tillåter vissa PHP-servrar inte denna metod, så om Du har problem att se uppladdade filer eller bilder (t.ex. användares bilder) så bör Du avaktivera denna inställning.';
$string['configsmartpix'] = 'Med detta  på så kommer ikoner att visas med hjälp av ett PHP-skript som söker igenom det aktuella temat, därefter igenom  alla \'föräldra\'-teman sedan i Moodle/pix-katalogen. Detta reducerar behovet av att dubblera bildfiler inom teman men det kommer med ett pris i form av något lägre prestanda.';
$string['configstartwday'] = 'Inledning av veckan';
$string['configstatsfirstrun'] = 'Det här anger hur långt tillbaka som loggar ska behandlas <b>första gången</b> som cron-jobbet will behandla statistik. Om Du har mycket trafik och delar server med andra, så är det bäst att inte gå alltför långt tillbaka eftersom det tar tid och är resurskrävande. (Notera att för den här inställningen så är en månad lika med 28 dagar. I diagrammen och rapporterna som skapas så är en månad     lika med en kalendermånad.)';
$string['configstatsmaxruntime'] = 'Behandling av statistik kan vara ganska resurskrävande så använd en kombination av det här fältet och nästa för att ange när det ska köras och hur länge.';
$string['configstatsmaxruntime2'] = 'Behandling av statistik kan bli ganska intensiv så därför bör du ange max hur länge det får ta att samla in all statistik för en dag. Max antal dagar som kan behandlas i en cron-körning är 3.';
$string['configstatsmaxruntime3'] = 'Detta anger den maximala tiden som tillåts för att beräkna statistiken för en dag, men kom ihåg att beräkning av statistik kraftigt kan belasta serverns kapacitet. Det maximala antalet dagar som beräknas i en cron körning kan anges nedan.';
$string['configstatsruntimedays'] = 'Detta anger det maximala antalet dagar som beräknas i varje statistikberäkning. När väl statistiken är uppdaterad kommer endast en dag att beräknas, så anpassa detta värde beroende på din serverbelastning, ange mindre värde om kortare cron körningar behövs.';
$string['configstatsruntimestart'] = 'När ska  cron-jobbet som sköter behandlingen av statistiken börja? Ange olika tider om det finns ett flertal Moodle-installationer på samma fysiska server.';
$string['configstatsuserthreshold'] = 'Den här inställningen anger det minsta antal registrerade användare som krävs för att en kurs ska tas med i statistiska beräkningar.';
$string['configstrictformsrequired'] = 'Om aktiverat hindras användare från att ange mellanslag eller radbrytning i obligatoriska fält i formulär.';
$string['configstripalltitletags'] = 'Avmarkera den här inställningen om Du vill tillåta HTML-taggar i namn på resurser och aktiviteter.';
$string['configsupportemail'] = 'Den här e-postadressen kommer att presenteras för användarna på den här webbplatsen som den adress som de ska använda när de behöver allmän hjälp (t.ex. när nya användare skapar sina egna konton). Om Du inte anger någon e-postadress så kommer det inte att finnas någon sådan kontaktmöjlighet.';
$string['configsupportname'] = 'Det här är namnet på en person eller någon annan enhet som erbjuder allmän support via e-posten eller en webbplats.';
$string['configsupportpage'] = 'Den här adressen till en webbplats kommer att presenteras för användarna på den här webbplatsen som den adress som de ska använda när de behöver allmän hjälp (t.ex. när nya användare skapar sina egna konton). Om Du inte anger någon webbadress så kommer det inte att finnas någon sådan kontaktmöjlighet.';
$string['configthemedesignermode'] = 'Normalt cachelagras alla bilder och stilmallar i webbläsare och på servern under en mycket lång tid, av prestandaskäl. Om du designar teman eller utvecklar kod så vill du förmodligen aktivera detta läge, för att du inte ska få cachade versioner. Varning: detta kommer att göra din webbplats långsammare för alla användare! Alternativt kan du manuellt rensa cachelagringen för teman på sidan Att välja teman.';
$string['configthemelist'] = 'Låt detta vara tomt så att användare kan välja tema själva. Om Du vill ha en mindre urval så kan Du ange en komma-separerad lista med namn på teman här (Använd inte mellanslag). T.ex.: standard,orangewhite';
$string['configtimezone'] = 'Du kan ställa in standardvärdet för tidzon här. Här kan Du ställa in den förvalda tidszonen. Det här är det enda standardvärdet för tidzon som visar datum - varje användare kan ändra denna inställning i sin egen Profil. Med "Servertid"  ställer Du här in Moodles standardvärde i förhållande till serverns operativsystem. men "Servertid" i användarens Profil kommer att ställa användarens standardvärde till detta värde.';
$string['configuseblogassociations'] = 'Ska användare kunna organisera sin blogg genom att koppla ihop bidrag med kurser och kursmoduler?';
$string['configuseexternalyui'] = 'Istället för att använda lokala filer, använd online-filer som finns på Yahoos servrar. VARNING: Detta kräver en Internet-anslutning, annars kommer ingen AJAX att fungera på din webbplats. Denna inställning är inte förenlig med webbplatser som använder https.';
$string['configuserquota'] = 'Maximala antalet byte som en användare kan lagra i sin egen privata filarea. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Om det är aktiverat kommer webbplatsens kortnamn att användas för webbplatssidor nod i navigerings snarare än strängen \'sajtens sidor\'';
$string['configusetags'] = 'Ska funktionaliteten med etiketter vara aktiverad globalt över hela webbplatsen?';
$string['configvariables'] = 'Variabler';
$string['configverifychangedemail'] = 'Möjliggör verifiering av ändrade e-postadresser med hjälp av inställningar för tillåtna och förbjudna e-postdomäner. Om denna inställning är avaktiverad kommer domän endast att vara tvingande vid skapande av ny användare.';
$string['configvisiblecourses'] = 'Visa normalt sett kurser i dolda kategorier';
$string['configwarning'] = 'Var försiktig med att ändra dessa inställningar - konstiga värden kan leda till problem.';
$string['configyuicomboloading'] = 'Detta alternativ aktiverar optimerad kombinerad filladdning
för Yui bibliotek. Denna inställning ska vara aktiverad på produktionsmilöer av prestandaskäl.';
$string['confirmation'] = 'Bekräftelse';
$string['confirmdeletecomments'] = 'Du håller på att ta bort kommentarer, är Du säker?';
$string['confirmed'] = 'Bekräftad';
$string['convertformat'] = '<i>omvandla</i> formatet för output';
$string['cookiehttponly'] = 'Endast http cookies';
$string['cookiesecure'] = 'Endast säkra cookies';
$string['country'] = 'Standardval av land';
$string['coursecontact'] = 'Administratörer av kurs';
$string['coursecontact_desc'] = 'Den här inställningen tillåter Dig att kontrollera vem som dyker upp på kursbeskrivningen. Användarna kommer att behöva ha åtminstone en av dessa roller för att de ska vara synliga på beskrivningen av den kursen.';
$string['courselistshortnames'] = 'Visa utökad kursnamn';
$string['courselistshortnames_desc'] = 'Om aktiverat kommer kursernas kortnamn att visas som tillägg till hela namnet i kurslistor. Om så krävs kan förlängda kursnamn ändras genom att ändra \'courseextendednamedisplay\' språksträngen med språkanpassningsverktyget.';
$string['coursemgmt'] = 'Hantera kurser och kategorier';
$string['courseoverview'] = 'Översikt över kurs';
$string['courserequestnotify'] = 'Meddelande om begäran om kurs';
$string['courserequestnotifyemail'] = 'Användaren {$a->user} har begärt en ny kurs på {$a->link}';
$string['courserequests'] = 'Förfrågningar om kurser';
$string['courserequestspending'] = 'Avvaktande begäranden om kurs ';
$string['courses'] = 'Kurser';
$string['coursesperpage'] = 'Kurser per sida';
$string['courseswithsummarieslimit'] = 'Kurser med gräns för sammanfattningar';
$string['creatornewroleid'] = 'Kursutvecklarens roll i nya kurser';
$string['creatornewroleid_help'] = 'Om användaren inte redan har tillstånd att administrera den nya kursen, kommer användaren automatiskt att registreras med denna roll.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Körning av cron endast via en kommandorad';
$string['cronerrorclionly'] = 'Tyvärr så har tillträde till den här sidan avaktiverats av administratören.';
$string['cronerrorpassword'] = 'Du har tyärr inte angivit något giltigt lösenord för att få tillgång till den här sidan.';
$string['cron_help'] = 'cron.php underhållskriptet hjälper några av Moodle modulerna för att utföra uppgifter på regelbunden basis, såsom utskick av kopior av nya inlägg i forume. En mekanism krävs för att köra skriptet regelbundet t.ex. var 5 minuter';
$string['cronremotepassword'] = 'Lösenord för tillträde till cron på distans.';
$string['cronwarning'] = 'Skriptet <a href="cron.php">cron.php skript för underhåll</a> har inte körts under de senaste 24 timmarna.';
$string['ctyperecommended'] = 'Att installera PHP tillägget ctype är starkt rekomenderat för att förbättra webbplatsens prestanda, speciellt om din webbplats stödjer icke-latinska språk.';
$string['ctyperequired'] = 'PHP tillägget ctype krävs numer av Moodle för att förbättra webbplatsprestandan och för att ge flerspråkskapacitet.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrecommended'] = 'Vi rekommenderar starkt att Du installerar det valfria Curl-biblioteket för att aktivera Moodles funktionalitet för nätverkande.';
$string['curlrequired'] = 'PHP tillägget cURL krävs nu av Moodle för att kommunicera med Moodle arkiv.';
$string['curltimeoutkbitrate'] = 'Bitrate att använda vid beräkning av curl timeout (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Denna inställning används för att beräkna lämplig timeout under stora cURL förfrågningar. Som del i denna beräkning görs en HTTP HEAD förfrågan för att avgöra storleken på innehållet. Om detta sätts till 0 förhindras denna begäran från att utföras.';
$string['currenttheme'] = 'Aktuellt tema';
$string['customcheck'] = 'Andra kontroller';
$string['custommenu'] = 'Standardmeny';
$string['custommenuitems'] = 'Komponenter på standardmenyn';
$string['datarootsecurityerror'] = '<p><strong>SÄKERHETS VARNING!</strong></p><p>Din rotkatalog för data fins på fel plats och är tillgänglig från webben. Detta innebär att alla dina privata filer är tillgängliga för alla i världen, och vissa av dessa filer kan användas för att få otillåten åtkomst till din webbplats!</p>
<p>Du <em>måste</em> flytta din rotkatalog för data (dataroot directory) ({$a}) till en ny plats som inte är innanför din publika webbkatalog, samt uppdatera <code>$CFG->dataroot</code> inställningen i din config.php till den nya katalogen.</p>';
$string['datarootsecuritywarning'] = 'Den konfiguration som Du använder för webbplatsen kanske inte är säker. Var snäll och säkerställ att din dataroot-katalog ({$a}) inte är direkt tillgänglig via webben.';
$string['dbmigrate'] = 'Migration av Moodles databas';
$string['dbmigrateconnecerror'] = 'Det gick inte att ansluta till den angivna databasen.';
$string['dbmigrateencodingerror'] = 'Den databas som har angivits använder teckenuppsättningen {$a} snarare än den UNICODE/UTF8 som krävs.<br />Var snäll och ange en annan.';
$string['dbmigratepostgres'] = 'Det verkar som om Du använder PostgreSQL som databasserver. För att kunna gå vidare med migrationsprocessen behöver Du, manuellt, skapa en ny databas med teckenuppsättningen "UNICODE"(PostgreSQL 7) eller "UTF8" (PostgreSQL 8) för att lagra Dina migrerade data. Var snäll och mata in inställningarna för kopplingen till Din nya databas här nedan för att fortsätta:';
$string['dbmigratewarning'] = 'Var snäll och säkerställ att Du har säkerhetskopierat Din databas till Moodle innan Du påbörjar den här processen: Om Du inte är säker på hur det ska gå till så bör Du kontakta Din systemadministratör. Din Moodle-webbplats kommer att försättas i läge för underhåll efter det att Du har påbörjat migrationsprocessen.';
$string['dbmigratewarning2'] = '<b>VARNING: Du håller på att starta en process för migration av databasen. Var snäll och säkerställ noga att hela Din databas till Moodle har säkerhetskopierats.';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Den här databasen har migrerats till en ny UTF8-kodad databas och är föråldrad.Var snäll och redigera Din config.php och använd den nya databasen för den här instansen av Moodle.</font>';
$string['dbmigrationdupfailed'] = 'Dupliceringen av databasen misslyckades, troligen p g a följande fel:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Använd databasen för information om session';
$string['debug'] = 'Meddelanden om felsökning (debug)';
$string['debugall'] = 'ALLA: Visa alla rimliga meddelanden angående felsökning i PHP.';
$string['debugdeveloper'] = 'UTVECKLARE: extra meddelanden för felsökning för utvecklare.';
$string['debugdisplay'] = 'Visa felmeddelande (debug)';
$string['debugging'] = 'Rättar till fel (debugging)';
$string['debugminimal'] = 'MINIMAL: Visa bara allvarliga fel';
$string['debugnone'] = 'INGA: Visa inte några fel eller varningar';
$string['debugnormal'] = 'NORMAL: Visa fel, varningar och meddelanden.';
$string['debugpageinfo'] = 'Visa information för sida';
$string['debugsmtp'] = 'Felsök distributionen av e-post';
$string['debugstringids'] = 'Visa språksträngarnasoriginal';
$string['debugstringids_desc'] = 'Detta alternativ är avsett att hjälpa översättare. När det är aktiverat kan du, genom att ange parametern strings=1 till en URL-begäran, visa språkfilen ich sträng id vid sidan av respektive sträng som matas ut.';
$string['debugvalidators'] = 'Visa länkarna för validering';
$string['defaultcity'] = 'Förvald standard för stad';
$string['defaultcity_help'] = 'Den stad som Du matar in här kommer att vara den förvalda standarden när nya användarkonton skapas.';
$string['defaultformatnotset'] = 'Fel uppstod vid bestämning av förvalt kursformat. Kontrollera inställningarna.';
$string['defaulthomepage'] = 'Standardiserad hemsida för användare';
$string['defaultrequestcategory'] = 'Förvald standardkategori för kurser som efterfrågas.';
$string['defaultsettinginfo'] = 'Standardinställning: {$a}';
$string['defaultuserroleid'] = 'Förvald roll för alla användare';
$string['deleteincompleteusers'] = 'Ta bort de ofullständiga användarna efteråt';
$string['deleteunconfirmed'] = 'Ta bort alla inte fullt bekräftade användare efteråt';
$string['deleteuser'] = 'Ta bort användare';
$string['density'] = 'Densitet';
$string['denyemailaddresses'] = 'Avstängda e-postdomäner';
$string['development'] = 'Utveckling';
$string['devicedetectregex'] = 'Enhetsdetektering reguljära uttryck';
$string['devicedetectregex_desc'] = '<p> Som standard kan Moodle upptäcka enheter av typen standard (stationära datorer, bärbara datorer, osv.), mobila (telefoner och små handhållna enheter), tablett (iPads, Android tabletter) och äldre (Internet Explorer 6 användare). Tema Väljaren kan användas för att applicera separata teman för att alla dessa. Den här inställningen tillåter reguljära uttryck som möjliggör upptäckten av extra enhetstyper (dessa går före standardtyper). </p><p> Till exempel kan du skriva in det reguljära uttrycket \'/ (MIDP-1.0 | Maemo | Windows CE) /\' för att upptäcka vanliga telefoner till returvärdet "featurephone". Detta lägger till "featurephone" på temaväljaren som gör att du kan lägga till ett tema som ska användas på dessa enheter. Andra telefoner skulle fortfarande använda det tema som valts för deras typ av mobil enhet. </p>';
$string['devicedetectregexexpression'] = 'Reguljärt uttryck';
$string['devicedetectregexvalue'] = 'Returvärde';
$string['devicetype'] = 'Enhetstyp';
$string['disableuserimages'] = 'Avaktivera bilder i användarnas profiler';
$string['displayerrorswarning'] = 'Aktiverande av PHP inställning <em>display_errors</em> rekommenderas inte på servrar i drift med användare eftersom vissa felmeddelanden kan avslöja känslig information om din server.';
$string['displayloginfailures'] = 'Visa misslyckade inloggningsförsök för';
$string['dndallowtextandlinks'] = 'Dra och släpp uppladdning av text/länkar';
$string['docroot'] = 'Dokument root för Extern dokumentation av Moodle';
$string['doctonewwindow'] = 'Öppna i nytt fönster';
$string['download'] = 'Ladda ner';
$string['edithelpdocs'] = 'Redigera hjälpdokument';
$string['editingnoncorelangfile'] = 'Du håller på att försöka modifiera en översättning av en tredjeparts-modul eller ett \'plugin\'-program. Du kan bara spara sådana översättningar i Din _local-mapp. Du kanske vill flytta filen med översättningen till modulens \'lang\'-mapp och/eller skicka den till den som underhåller den modulen.';
$string['editlang'] = '<b>Redigera</b>';
$string['editorbackgroundcolor'] = 'Bakgrundsfärg';
$string['editordictionary'] = 'Ordlista för redigerare';
$string['editorfontfamily'] = 'Typsnitt';
$string['editorfontlist'] = 'Lista över typsnitt';
$string['editorfontsize'] = 'Storlek på typsnitt';
$string['editorhidebuttons'] = 'Dolda knappar';
$string['editorkillword'] = 'Filter för Word-format';
$string['editorspelling'] = 'Stavning för redigerare';
$string['editorspellinghelp'] = 'Aktivera eller avaktivera stavningskontroll. När detta är aktiverat måste <strong>aspell</strong> vara installerat på servern.';
$string['editstrings'] = 'Redigera ord eller fraser';
$string['emailchangeconfirmation'] = 'Bekräftelse av ändrad e-postadress';
$string['emoticonalt'] = 'Alternativ text';
$string['emoticoncomponent'] = 'Komponent till bild';
$string['emoticonimagename'] = 'Namn på bild';
$string['emoticons'] = 'Smilies';
$string['emoticons_desc'] = 'Detta formulär definierar uttryckssymboler (eller smileys) som används på din webbplats. För att ta bort en rad ur tabellen, spara formuläret med ett tomt värde i något av de efterfrågade fälten. För att registrera nya uttryckssymboler fyll i fälten i den sista tomma raden. För att återställa alla fält till förvalda värden följ länken ovan.

* Text (krävs) - Denna text kommer att ersättas med den uttryckssymbolens bild. Den måste vara minst två tecken.
* Bildnamn (krävs) - uttryckssymbilbildens filnamn utan filändelse, relativt sökväg till komponentens pix katalog.
* Bild (krävs) - Den bildfil som ger ikonen.
* Alternativ text (tillval) - Strängidentifierare och del av den alternativa texten för uttryckssymbolen.';
$string['emoticonsreset'] = 'Återställ inställningarna för "smilies" till standardvärden';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Tom';
$string['enableajax'] = 'Aktivera AJAX';
$string['enableblogs'] = 'Aktivera bloggar';
$string['enablecalendarexport'] = 'Aktivera export av kalender';
$string['enablecomments'] = 'Aktivera kommentarer';
$string['enablecourserequests'] = 'Aktivera förfrågan om kurs';
$string['enablecssoptimiser'] = 'Aktivera optimering av CSS';
$string['enablecssoptimiser_desc'] = 'När funktionen är aktiverad kommer CSS att köras genom en optimeringsprocess innan det cachelagras. Optimeraren bearbetar CSS och tar bort dubbletter av regler,stilar och blanksteg samt omformaterar. Observera att om detta aktiveras samtidigt som Läge för design av teman kommer det ge dålig prestanda, men ger en utmärkt hjälp för temadesigners till att skapa optimerad CSS.';
$string['enabled'] = 'Aktiverat';
$string['enabledevicedetection'] = 'Aktivera detektering av enhet';
$string['enablegravatar'] = 'Aktivera Gravatar';
$string['enablegravatar_help'] = 'När funktionen är aktiverad kommer Moodle att försöka hämta en bild för användarprofllen från Gravatar, gäller bara om användaren inte har laddat upp en bild.';
$string['enablegroupmembersonly'] = 'Aktivera endast medlemmar i grupp';
$string['enablemobilewebservice'] = 'Aktivera webbtjänster för mobila enheter';
$string['enablerecordcache'] = 'Aktivera cachning av poster';
$string['enablerssfeeds'] = 'Aktivera RSS-matningar';
$string['enablesafebrowserintegration'] = 'Aktivera integration av webbläsaren för säker examination';
$string['enablestats'] = 'Aktivera statistik';
$string['enabletgzbackups'] = 'Aktivera ny backup-format';
$string['enabletgzbackups_desc'] = 'Om aktiverat kommer framtida säkerhetskopieringar att skapas i ett nytt format för fil komprimering för .mbz filer (internt sparat som tar.gz filer). Detta tar bort restriktionen på storlek för säkerhetskopia på 4GB och kan förbättra prestandan. Återställning stödjer båda formaten och skillnaden bör vara obefintlig för användare.';
$string['enabletgzbackups_nozlib'] = 'PHP tillägget zlib är inte tillgängligt. Det nya säkerhetskopieringsformatet är beroende av detta tillägg och kommer avaktiveras tills zlib är installerat och aktiverat.';
$string['enabletrusttext'] = 'Aktivera tillförlitligt innehåll';
$string['enablewebservices'] = 'Aktivera webbtjänster';
$string['enablewsdocumentation'] = 'Dokumentation av webbtjänster';
$string['enrolinstancedefaults'] = 'Standardvärden för instanser av registreringar';
$string['enrolinstancedefaults_desc'] = 'Standardinställningar för registreringar på nya kurser';
$string['enrolmultipleusers'] = 'Registrera användarna';
$string['environment'] = 'Miljö';
$string['environmenterrortodo'] = 'Du måste lösa de problem som har med den tekniska miljön att göra innan Du fortsätter med att installera den här versionen av Moodle!';
$string['environmenterrorupgrade'] = 'Varning! Du bör lösa alla problem (fel) med miljön som har hittats här ovan innan Du fortsätter uppgraderingen till den här versionen av Moodle. Om Du uppgraderar utan att uppfylla dessa krav så riskerar Du att få problem som t.ex. förlust av data. Är Du säker på att Du vill gå vidare med den här uppgraderingen?';
$string['environmentmustfixsetting'] = 'Inställningen för PHP måste ändras.';
$string['environmentok'] = 'Din server svarar mot alla de minimala kraven.';
$string['environmentrecommendcustomcheck'] = 'Om det här testet misslyckas så signalerar det ett möjligt fel.';
$string['environmentrecommendinstall'] = 'rekommenderas att bli installerad/aktiverad';
$string['environmentrecommendversion'] = 'version {$a->needed} rekommenderas och Du använder  {$a->current}';
$string['environmentrequirecustomcheck'] = 'det här testet måste resultera i ett godkänt';
$string['environmentrequireinstall'] = 'är nödvändig att installera/aktivera';
$string['environmentrequireversion'] = 'version {$a->needed} är nödvändig och Du använder {$a->current}';
$string['environmentsettingok'] = 'Den rekommenderade inställningen har upptäckts';
$string['environmentshouldfixsetting'] = 'Inställningen för PHP bör ändras.';
$string['environmentxmlerror'] = 'Fel i samband med läsning av data angående den tekniska miljön ({$a->error_code})';
$string['errordeletingconfig'] = 'Ett fel inträffade vid borttagning av konfigurationsdata för plugin \'{$a}\'.';
$string['errorsetting'] = 'Det gick inte att spara inställningen:';
$string['errorwithsettings'] = 'P.g.a. ett fel så sparades inte en del inställningar.';
$string['everyonewhocan'] = 'Alla som kan  \'{$a}\'';
$string['exceptions'] = 'undantag';
$string['execpathnotallowed'] = 'Inställning av exekverbara sökvägar är avaktiverat i config.php';
$string['experimental'] = 'Experimentell';
$string['experimentalsettings'] = 'Inställningar för experimentell';
$string['extendedusernamechars'] = 'Tillåt specialtecken i användarnamn';
$string['extramemorylimit'] = 'Extra minnesgräns för PHP';
$string['fatalmagicquotesruntime'] = '<p> Ett allvarligt konfigurationsfel har upptäckts, vänligen meddela serveradministratören. </p><p> För att fungera korrekt, kräver Moodle att administratören ändrar PHP inställningar. </p><p> <code>magic_quotes_runtime</code> måste vara inställd på <code>off</code> . </p><p> Denna inställning kontrolleras genom att redigera <code>php.ini</code> , Apache/IIS <br /> eller <code>.htaccess</code> -filen på servern. </p>';
$string['fatalsessionautostart'] = '<p> Ett allvarligt konfigurationsfel har upptäckts, vänligen meddela serveradministratören. </p><p> För att fungera korrekt, kräver Moodle att administratören ändrar PHP inställningar. </p><p> <code>session.auto_start</code> måste vara inställd på <code>off</code> . </p><p> Denna inställning kontrolleras genom att redigera <code>php.ini</code> , Apache/IIS <br /> eller <code>.htaccess</code> -filen på servern. </p>';
$string['filecreated'] = 'En ny fil har skapats';
$string['filestoredin'] = 'Spara fil till katalog:';
$string['filestoredinhelp'] = 'Där filen kommer att sparas';
$string['filterall'] = 'Filtrera alla strängar';
$string['filtermatchoneperpage'] = 'Filtrera matchning en gång per sida';
$string['filtermatchonepertext'] = 'Filtrera matchning en gång per text';
$string['filters'] = 'Filter';
$string['filtersettings'] = 'Inställningar för filter';
$string['filtersettingsgeneral'] = 'Generella inställningar för filter';
$string['filteruploadedfiles'] = 'Filtrera uppladdade filer';
$string['forcelogin'] = 'Tvinga användare att logga in';
$string['forceloginforprofileimage'] = 'Tvinga användarna att logga in för att se användarnas bilder';
$string['forceloginforprofileimage_help'] = 'Om aktiverad, måste användarna logga in för att se  användarprofilsbilder, standard användarbilden kommer att användas i alla e-postmeddelanden.';
$string['forceloginforprofiles'] = 'Tvinga användare att logga in för profiler';
$string['forcetimezone'] = 'Tvinga tidszon';
$string['formatuninstallwithcourses'] = 'Det finns {$a->count} kurser som använder {$a->format}. Deras format kommer att ändras till {$a->defaultformat} (förvalt format för denna webbplats). Vissa formatspecifika data kan komma att förloras. Är du säker på att du vill fortsätta?';
$string['frontpage'] = 'Ingångssida';
$string['frontpagebackup'] = 'Säkerhetskopia för ingångssida';
$string['frontpagedefaultrole'] = 'Standarroll på ingångssidan';
$string['frontpagefilters'] = 'Filter för ingångssida';
$string['frontpageloggedin'] = 'Komponenter på ingångssidan när man är inloggad-';
$string['frontpageoverrides'] = 'Överskridanden av tillstånden för ingångssida';
$string['frontpagequestions'] = 'Frågor på ingångssidan';
$string['frontpagerestore'] = 'Återställning av ingångssida';
$string['frontpageroles'] = 'Roller på ingångssidan';
$string['frontpagesettings'] = 'Inställningar på ingångssidan';
$string['fullnamedisplay'] = 'Namn i fullt format';
$string['fullnamedisplayprivate'] = 'Format fullständigt namn - privat';
$string['gdrecommended'] = 'GD biblioteket används för konvertering av bilder, om de saknas kommer vissa funktioner såsom bilder av användarprofil inte visas.';
$string['gdrequired'] = 'Tillägget GD krävs nu av Moodle för bildkonvertering.';
$string['generalsettings'] = 'Allmänna inställningar';
$string['geoipfile'] = 'Datafil för GeoIP City';
$string['getremoteaddrconf'] = 'Källa till loggad IP-adress';
$string['globalswarning'] = '<p><strong>Säkerhetsvarning</strong>: för att fungera som det ska så kräver Moodle <br /> att du gör vissa ändringar i dina aktuella inställningar för PHP.</p><p>Du <em>måste</em> ställa in <code>register_globals=off</code>.</p><p>Den här inställningen kan du styra genom att redigera din <code>php.ini</code>, Apache/IIS <br />konfiguration eller <code>.htaccess</code> file.</p>';
$string['googlemapkey3'] = 'API-nyckel V3 för Google Maps';
$string['googlemapkey3_help'] = 'Du måste ange en specifik nyckel för att använda Google Maps för visualisering av IP address uppslagning. Du kan skaffa denna nyckel utan kostnad på <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Gå till den första saknade strängen';
$string['gradebook'] = 'Betygskatalog';
$string['gradebookroles'] = 'Betygssatta roller';
$string['gradeexport'] = 'Primära metoder för att exportera betyg';
$string['gravatardefaulturl'] = 'Förvald bild URL för Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar behöver en standardbild att visa om den inte kan hitta bild för en viss användare. Ge en fullständig URL till en bild. Om du lämnar den här inställningen tom kommer Moodle att försöka använda den mest lämpliga standardbilden för den sida du visar. Observera också att Gravatar har ett antal koder som kan användas för att <a href="https://en.gravatar.com/site/implement/images/#default-image">generera standardbilder</a> .';
$string['groupenrolmentkeypolicy'] = 'Policy för nyckel till registrering';
$string['groupenrolmentkeypolicy_desc'] = 'Om aktiverat kommer Moodle kontrollera gruppnycklar för registrering gentemot en giltig lösenordspolicy.';
$string['guestroleid'] = 'Roll för gäst';
$string['guestroleid_help'] = 'Denna roll tilldelas automatiskt till gästanvändare. Den tilldelas också tillfälligt åt icke registrerade användare som kommer in i kursen via pliginet "Tillåt gäster".';
$string['helpadminseesall'] = 'Kan administratörerna se alla händelser för kalendrar eller bara de som berör dem själva?';
$string['helpcalendarcustomexport'] = 'Aktivera anpassade datumintervall i exportalternativ i kalenderexport. Kalenderexport måste aktiveras innan detta har effekt.';
$string['helpexportlookahead'] = 'Hur många dagar framåt letar kalendern efter händelser under export av det anpassade exportalternativet?';
$string['helpexportlookback'] = 'Hur många dagar bakåt letar kalendern efter händelser under export av det anpassade exportalternativet?';
$string['helpforcetimezone'] = 'Du kan antingen tillåta användare att välja sina tidszoner individuellt eller "diktera" en tidszom som gäller för alla.';
$string['helpshowicalsource'] = 'Om aktiverad, kommer prenumerationsnamn och länk att visas för iCal importerade händelser.';
$string['helpsitemaintenance'] = 'För uppgraderingar och annat arbete';
$string['helpstartofweek'] = 'Vilken dag inleder veckan i kalendern?';
$string['helpupcominglookahead'] = 'Hur många dagar framåt i tiden övervakar kalendern som standard när det gäller kommande händelser?';
$string['helpupcomingmaxevents'] = 'Hur många (maximalt) kommande händelser visas för användarna som standard?';
$string['helpweekenddays'] = 'Vilka dagar i veckan markeras som "helgdagar" och visas med en annan färg?';
$string['hiddenuserfields'] = 'Dölj fält för användare';
$string['hidefromall'] = 'Dölj för alla användare';
$string['hidefromnone'] = 'Dölj inte för någon';
$string['hidefromstudents'] = 'Dölj för studenter/elever/deltagare/lärande';
$string['htmleditor'] = 'HTML-redigerare';
$string['htmleditorsettings'] = 'Inställningar för HTML-redigerare';
$string['htmlsettings'] = 'Inställningar för HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP säkerhet';
$string['hubs'] = 'Hubbar';
$string['iconvrecommended'] = 'Du rekommenderas starkt att installera det valfria ICONV-biblioteket. Detta förbättrar webbplatsens prestanda, speciellt om Din webbplats stödjer icke-latinska språk.';
$string['iconvrequired'] = 'Det är obligatoriskt att installera ett ICONV-tillägg.';
$string['ignore'] = 'Låt detta vara';
$string['includemoduleuserdata'] = 'Ta med modulens användardata';
$string['incompatibleblocks'] = 'Block som inte är kompatibla';
$string['installhijacked'] = 'Installationen måste avslutas från den ursprungliga IP-adress, ledsen.';
$string['installsessionerror'] = 'Kan inte initiera PHP sessioner, kontrollera att din webbläsare accepterar cookies.';
$string['intlrecommended'] = 'Tillägget Intl används för att förbättra stöd för internationalisering, såsom lokal medveten sortering.';
$string['invalidsection'] = 'Ogiltig sektion';
$string['invaliduserchangeme'] = 'Anvädarnamnet "changename" är reserverat - Du kan inte använda det för att skapa ett konto.';
$string['ipblocked'] = 'Den här webbplatsen är f n inte tillgänglig.';
$string['ipblocker'] = 'IP-blockerare';
$string['ipblockersyntax'] = 'Sätt varje post på en rad. Giltiga värden är antingen full IP-adress (t.ex. <b>192.168.10.1)</b> som matchar en enda värd, eller partiell adress (t.ex. <b>192,168.)</b> Som matchar alla adress som börjar med dessa siffror, eller CIDR (såsom <b>231.54.211.0/20)</b> , eller ett intervall av IP-adresser (t.ex. <b>231.3.56.10-20)</b> där området gäller den sista delen av adressen. Text domännamn (som \'example.com\') stöds inte. Tomma rader ignoreras.';
$string['iplookup'] = 'Att söka upp IP-adressen';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">geoPlugin</a> tjänsten används för närvarande för att slå upp geografisk information. För mer exakta resultat rekommenderar vi att installera en lokal kopia av MaxMind GeoLite databasen.';
$string['iplookupinfo'] = 'Som standardmässigt förval använder Moodle den fria NetGeo-(The Internet Geographic Database)servern för att leta reda på IP-adressernas placering men dessvärre så underhålls inte den här databasen längre så den kan returnera <em>helt felaktiga</em> data. Därför rekommenderar vi att du installerar en lokal kopia av den fria GeoLite City-databasen från MaxMind.<br /> IP-adressens placering visas på en enkel karta eller via Google Maps. Var snäll och notera att du måste ha ett Google-konto och ansöka om en gratis Google Maps API-nyckel för att aktivera interaktiva kartor.';
$string['iplookupmaxmindnote'] = 'Den här produkten inkluderar GeoLite data som har skapats av MaxMind som är tillgängligt från  <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'bevara skiftlägeskänslighet för namn på intressen';
$string['lang'] = 'Förvalt språk';
$string['langcache'] = 'Cacha språkmenyn';
$string['langcache_desc'] = 'Cachelagra språkmenyn. Om aktiverat visas listan över tillgängliga översättningar cachelagrad. Cachen uppdateras automatiskt när du installerar eller tar bort ett språkpaket via den inbyggda verktyget för språkpaket . Om du installerar ett nytt språkpaket manuellt, måste du använda funktionen Rensa alla cachar för att uppdatera den cachelagrade listan.';
$string['langlist'] = 'Språk på språkmenyn';
$string['langmenu'] = 'Visa språkmenyn';
$string['langpackwillbeupdated'] = 'Under uppgraderingen kommer Moodle att försöka uppdatera det aktuella valda språkpaketet. ';
$string['langstringcache'] = 'Cacha alla språksträngar';
$string['languagesettings'] = 'Inställningar för språk';
$string['latexpreamble'] = 'LaTeX utkast';
$string['latexsettings'] = 'Inställningar för LaTeX Renderer';
$string['latinexcelexport'] = 'Teckenuppsättning för Excel';
$string['legacyfilesaddallowed'] = 'Tillåt att lägga till gammaldags kursfiler';
$string['legacyfilesaddallowed_help'] = 'Om en kurs har gammaldags kursfiler, tillåt nya filer och mappar att läggas till.';
$string['legacyfilesinnewcourses'] = 'Gammaldags kursfiler i nya kurser.';
$string['legacyfilesinnewcourses_help'] = 'Som standard, är gammaldags kursfiler  tillgängligt endast tillgängligt i uppgraderade kurser. Observera att vissa funktioner som säkerhetskopiering och återställning av aktiviteter inte är kompatibla med den här inställningen.';
$string['licensesettings'] = 'Inställningar för licenser';
$string['linkadmincategories'] = 'Länka adminkategorier';
$string['linkadmincategories_help'] = 'Om aktiverad kommer admin inställningskategorier att visas som länkar i navigationsträdet och kommer att leda till admin kategorisidor.';
$string['loading'] = 'Laddar in';
$string['localetext'] = 'Lokal inställning för hela webbplatsen';
$string['localstringcustomization'] = 'Standardisering av lokala (text)-strängar';
$string['location'] = 'Lokala inställningar';
$string['locationsettings'] = 'Lokala inställningar';
$string['locked'] = 'låst';
$string['lockoutduration'] = 'Varaktighet kontoutelåsning';
$string['lockoutduration_desc'] = 'Utelåst konto automatiskt upplåst efter denna tidsrymd.';
$string['lockoutemailbody'] = 'Ditt konto med användarnamn {$a->username} på server \'{$a->sitename}\'
blev låst på grund av för många felaktiga inloggningsförsök.

För att omedelbart låsa upp kontot gå till följande adress

{$a->link}

I de flesta e-postprogram borde detta visas som en blå länk som du kan klicka på. Om det inte fungerar så kopiera adressen och klistra in den i webbläsarens adressfönster.

Om du behöver hjälp kontakta webbplatsadministratören,
{$a->admin}';
$string['lockouterrorunlock'] = 'Ogiltig information för kontoupplåsning angiven.';
$string['lockoutthreshold'] = 'Tröskelvärde för kontoutelåsning';
$string['lockoutthreshold_desc'] = 'Välj det antal misslyckade inloggningsförsök som resulterar i kontolåsning. Den här funktionen kan missbrukas i överbelastningsattacker.';
$string['lockoutwindow'] = 'Observationsfönster för kontolåsning';
$string['lockoutwindow_desc'] = 'Observationstid för tröskelvärde för kontolåsning, om det inte finns några felaktiga försök kommer räknaren att återställas efter denna tid.';
$string['log'] = 'Loggar';
$string['logguests'] = 'Logga gäståtkomst';
$string['logguests_help'] = 'Den här inställningen aktiverar loggning av åtgärder med gästkonto och inte inloggade användare. Högprofils webbplatser kanske vill inaktivera denna loggning av prestandaskäl. Det rekommenderas att behålla den här inställningen aktiverad på produktionsanläggningar.';
$string['loginhttps'] = 'Använd HTTPS för inloggning';
$string['loginpageautofocus'] = 'Autofokus formulär inloggningssida';
$string['loginpageautofocus_help'] = 'Aktivering av det här alternativet förbättrar användbarheten på inloggningssidan, men automatiskt fältfokus kan betraktas som en tillgänglighetsfråga.';
$string['loginpasswordautocomplete'] = 'Förhindra automatisk komplettering av lösenord på inloggningsformulären';
$string['loginpasswordautocomplete_help'] = 'Om denna funktion är avstängd tillåts användarna spara sina lösenord i sin webbläsare. Om aktiverad kommer den här inställningen att leda till att din webbplats inte valideras som strikt XHTML.';
$string['loglifetime'] = 'Spara loggar i';
$string['longtimewarning'] = 'Var snäll och notera att detta kan ta lång tid.';
$string['maintenancemode'] = 'i läge för underhåll';
$string['maintenancemodeisscheduled'] = 'Webbplatsen övergår till läge för underhåll om {$a} minuter';
$string['maintfileopenerror'] = 'Fel i samband med att filerna för underhål skulle öppnas';
$string['maintinprogress'] = 'Underhåll pågår';
$string['manageformats'] = 'Hantera kursformat';
$string['manageformatsgotosettings'] = 'Förvalt format kan ändras i {$a}';
$string['managelang'] = '<b>Administrera</b>';
$string['managelicenses'] = 'Administrera licenser';
$string['manageqbehaviours'] = 'Hantera frågebeteenden';
$string['manageqtypes'] = 'Administrera frågetyper';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Förhandsutgåva';
$string['maturity200'] = 'Stabil version';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Tips: Du kanske vill köra skriptet med --allow-unstable alternativet';
$string['maturitycoreinfo'] = 'Din webbplats kör för närvarande ostabil "{$a}" utvecklingskod.';
$string['maturitycorewarning'] = 'Versionen av Moodle som du vill installera eller uppgradera till innehåller ostabil "{$a}" utvecklingskod som inte är lämplig för de flesta webbplatser i produktion. Om detta inte är vad du vill göra se till att du uppdaterar från en stabil version av Moodle kod. Se Moodle Docs för mer detaljer.';
$string['maxbytes'] = 'Maximal storlek på uppladdade filer';
$string['maxconsecutiveidentchars'] = 'Efter varandra följande identiska tecken';
$string['maxeditingtime'] = 'Maximal tillåten tid för att redigera inlägg';
$string['maxusersperpage'] = 'Högsta antal användare per sida';
$string['mbstringrecommended'] = 'Du rekommenderas starkt att installera det valfria MBSTRING-biblioteket. Detta förbättrar webbplatsens prestanda, speciellt om Din webbplats stödjer icke-latinska språk.';
$string['mediapluginavi'] = 'Aktivera .avi-filter';
$string['mediapluginflv'] = 'Aktivera .flv filter';
$string['mediapluginimg'] = 'Aktivera automatisk inbäddning av länkade bildet';
$string['mediapluginmov'] = 'Aktivera .mov-filter';
$string['mediapluginmp3'] = 'Aktivera  .mp3-filter';
$string['mediapluginmpg'] = 'Aktivera mpg-filter';
$string['mediapluginogg'] = 'Aktivera .ogg-filter';
$string['mediapluginogv'] = 'Aktivera .ogv-filter';
$string['mediapluginram'] = 'Aktivera .ram filter';
$string['mediapluginrm'] = 'Aktivera .rm filter';
$string['mediapluginrpm'] = 'Aktivera .rpm filter';
$string['mediapluginswf'] = 'Aktivera swf-filter';
$string['mediapluginswfnote'] = 'Som ett standardmässigt sätt att öka säkerheten så bör inte vanliga användare få bädda in swf Flash-filer.';
$string['mediapluginwmv'] = 'Aktivera .wmv-filter';
$string['mediapluginyoutube'] = 'Aktivera filter för länkar från YouTube';
$string['messaging'] = 'memcachad använd fasta anslutningar';
$string['messagingallowemailoverride'] = 'Meddelande per e-post åsidosättande';
$string['messagingdeletereadnotificationsdelay'] = 'Ta bort lästa meddelanden';
$string['messaginghidereadnotifications'] = 'Dölj  lästa meddelanden';
$string['minpassworddigits'] = 'Siffror';
$string['minpasswordlength'] = 'Längd på lösenord';
$string['minpasswordlower'] = 'Små bokstäver';
$string['minpasswordnonalphanum'] = 'Icke-alfanumeriska tecken';
$string['minpasswordupper'] = 'Stora bokstäver';
$string['misc'] = 'Övrigt';
$string['mnetrestore_extusers'] = '<strong>OBS!</strong> Den här säkerhetskopian innehåller fjärranvändarkonton i ett nätverk för Moodle och de kommer att återställas som e n del av processen.';
$string['mnetrestore_extusers_admin'] = '<strong>OBS:</strong> Denna säkerhetskopia verkar komma från en annan Moodle installation och innehåller användarkonton från  utanförliggande Moodlenätverk. Återställningen kommer att försöka matcha Moodle nätverksvärdar för alla skapade användare. De som inte matchar automatiskt kopplas till intern verifiering (istället för Mnet). Återställningsloggen kommer att informera dig om detta.';
$string['mnetrestore_extusers_mismatch'] = '<strong>OBS!</strong> Den här säkerhetskopian kommer uppenbarligen från en annan installation av Moodle och innehåller fjärranvändarkonton i ett nätverk för Moodle som kanske inte går att återställa. Den här operationen stödjs inte. Om Du är säker på att den var skapad på den här installationen av Moodle, eller    om Du kan säkerställa att alla de nödvändiga värdarna i nätverket för Moodle är konfigurerade så kan Du ändå försöka fullfölja återställandet.';
$string['mnetrestore_extusers_noadmin'] = '<strong>OBS:</strong> Denna säkerhetskopia verkar komma från en annan Moodle installation och innehåller användarkonton från  utanförliggande Moodlenätverk. Det är inte tillåtet att utföra denna typ av återställning. Kontakta administratören av webbplatsen eller,alternativt, återställa denna kurs utan någon användarinformation (moduler, filer ...)';
$string['mobile'] = 'Mobil';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Aktivitetsväljaren standard';
$string['modeditdefaults'] = 'Standardvärden för inställningar för aktiviteter';
$string['modeditingmenu'] = 'Menyer för aktivitetsredigering';
$string['modeditingmenu_desc'] = 'Om aktiverad kommer många av de ikoner för aktivitetsredigering, som visas när du tittar på en kurs med redigering på, att visas inom en rullgardinsmeny. Detta minskar innehållet på skärmen när du redigerar en kurs genom att dölja ikonerna tills de behövs.';
$string['modsettings'] = 'Administrera aktiviteter';
$string['modulesecurity'] = 'Säkerhet för modul';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Tvinga fram den gamla syntaxen för flerspråkigt innehåll <span> utan  class="multilang" och <lang>';
$string['mustenablestats'] = 'Statistik har ännu inte aktiverats för den här webbplatsen.';
$string['mycoursesperpage'] = 'Antal kurser';
$string['mymoodle'] = 'Mitt hem';
$string['mymoodleredirect'] = 'Tvinga användare att använda Mitt Moodle';
$string['mypage'] = 'Standardformat för Mitt hem-sida';
$string['mypagelocked'] = 'Lås standardsidan';
$string['myprofile'] = 'Standardformatpå profilsida';
$string['mysql416bypassed'] = 'Om Du emellertid på Din webbplats använder BARA språk som är kodade enligt ISO-8859-1 så kan Du fortsätta att använda Din aktuella installation av MySQL 4.1.12 (eller högre).';
$string['mysql416required'] = 'MySQL 4.1.16 är den äldsta version som Du kan använda tillsammans med Moodle 1.6 om Du vill säkerställa att alla data kan konverteras till UTF-8 i framtiden.';
$string['navadduserpostslinks'] = 'Lägg till  länkar för att visa användarinlägg';
$string['navadduserpostslinks_help'] = 'Om aktiverad kommer två länkar att läggas till varje användare i navigeringen för att visa de diskussioner användaren har startat och de inlägg som användaren har gjort i forum på hela webbplatsen eller i specifika kurser.';
$string['navcourselimit'] = 'Begränsning av kurs';
$string['navigationupgrade'] = 'Denna uppgradering introducerar två nya navigeringsblock som kommer att ersätta dessa block: Administration, Kurser, Aktiviteter och Deltagare. Om du hade satt några speciella behörigheter på dessa block bör du kontrollera att allt beter sig som du vill ha det.';
$string['navshowallcourses'] = 'Visa alla kurser';
$string['navshowcategories'] = 'Visa kategorier av kurser';
$string['navshowfrontpagemods'] = 'Visa aktiviteter på startsidan i navigationen';
$string['navshowfrontpagemods_help'] = 'Om aktiverad kommer aktiviteter på startsidan att visas i navigationen på webbplatsens sidor.';
$string['navshowfullcoursenames'] = 'Visa kursens fullständiga namn';
$string['navshowfullcoursenames_help'] = 'Om aktiverat kommer kurser i navigationen att visas med sitt fulla namn hellre än deras kortnamn.';
$string['navshowmycoursecategories'] = 'Visa min kurskategorier';
$string['navshowmycoursecategories_help'] = 'Om aktiverat kommer kurser i användarens Mina kurser att visas i kategorier.';
$string['navsortmycoursessort'] = 'Sortera mina kurser';
$string['navsortmycoursessort_help'] = 'Detta avgör om kurser listas under Mina kurser enligt sorteringsordningen (dvs den ordning som i Site administration > Kurser > Hantera kurser och kategorier) eller i alfabetisk ordning efter kurs inställning.';
$string['neverdeleteruns'] = 'Radera aldrig körningar';
$string['nobookmarksforuser'] = 'Du har inga bokmärken';
$string['nodatabase'] = 'Ingen databas';
$string['nohttpsformobilewarning'] = 'Det rekommenderas att aktivera HTTPS med ett giltigt certifikat. Moodle app kommer alltid att försöka använda en säker anslutning först.';
$string['nomissingstrings'] = 'Det saknas inga (text)strängar';
$string['nonewsettings'] = 'Inga nya inställningar lades till under den här uppgraderingen.';
$string['nonexistentbookmark'] = 'Det gick inte att hitta det bokmärke som Du efterfrågade.';
$string['noresults'] = 'Det gick inte att hitta några resultat';
$string['noroles'] = 'Inga roller';
$string['notifications'] = 'Meddelanden';
$string['notifyloginfailures'] = 'E-post om misslyckade inloggningar till';
$string['notifyloginthreshold'] = 'Tröskel för meddelanden via e-post';
$string['notloggedinroleid'] = 'Roll för besökare';
$string['numberofmissingstrings'] = 'Antal saknade textsträngar';
$string['numberofstrings'] = 'Det sammanlagda antalet textsträngar: {$a->strings}<br />Saknas: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'Vi rekommenderar starkt att Du installerar det valfria OpenSSL-biblioteket - det möjliggör funktionaliteten för nätverk med Moodle.';
$string['opentogoogle'] = 'Öppen för Google';
$string['optionalmaintenancemessage'] = 'Valfritt meddelande angående underhåll';
$string['order1'] = 'Första';
$string['order2'] = 'Andra';
$string['order3'] = 'Tredje';
$string['order4'] = 'Fjärde';
$string['passwordpolicy'] = 'Policy för lösenord';
$string['pathconvert'] = 'Sökväg för <i>convert</i> binär';
$string['pathdvips'] = 'Sökväg för <i>dvips</i> binär';
$string['pathlatex'] = 'Sökväg för <i>latex</i> binär';
$string['pathtoclam'] = 'Sökväg till clam AV';
$string['pathtodot'] = 'Sökväg till dot';
$string['pathtodu'] = 'Sökväg till du';
$string['pathtopgdump'] = 'Sökväg till pg_dump';
$string['pathtopgdumpdesc'] = 'Det är bara nödvändigt att mata in om Du har mer än en på_dump i Ditt system. (om Du t ex har mer än en version av postgresql installerad).';
$string['pathtopgdumpinvalid'] = 'Ogiltig sökväg till pg_dump - antingen fel sökväg eller också går den inte att använda';
$string['pathtopsql'] = 'Sökväg till psql';
$string['pathtopsqldesc'] = 'Det är bara nödvändigt att mata in om Du har mer än en psql i Ditt system. (om Du t ex har mer än en version av postgresql installerad).';
$string['pathtopsqlinvalid'] = 'Ogiltig sökväg till psql - antingen fel sökväg eller också går den inte att använda';
$string['perfdebug'] = 'Info om prestanda';
$string['performance'] = 'Prestanda';
$string['pgcluster'] = 'PostgreSQL kluster';
$string['pgclusterdescription'] = 'PostgreSQL version/kluster parameter för aktiviteter av typ kommandorad. Om Du bara har en postgresql i Ditt system eller om Du inte vet vad detta är så bör Du lämna tdetta tomt.';
$string['php50restricted'] = 'PHP 5.0.x har ett antal kända problem. Var snäll och uppgradera till 5.1.x eller nedgradera till 4.3.x eller 4.4.x';
$string['php533warning'] = 'PHP 5.3.3 och nyare rekommenderas';
$string['phpfloatproblem'] = 'Upptäckte problem vid hanteringen av flyttal i PHP - {$a}';
$string['pleaserefreshregistration'] = 'Din webbplats har registrerats på moodle.org, var snäll och tänk efter om du vill uppdatera registreringen om det har inträffat väsentliga förändringar sedan din senaste uppdatering, på {$a}.';
$string['pleaseregister'] = 'Var snäll och registrera Din webbplats genom att klicka på den här knappen';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugin-program';
$string['pluginscheck'] = 'Kontrollerar plugin beroenden';
$string['pluginscheckfailed'] = 'Beroenden kontrollen misslyckades för {$a->pluginslist}';
$string['pluginschecktodo'] = 'Du måste lösa alla plugin-krav innan du fortsätter att installera denna Moodle version!';
$string['pluginsoverview'] = 'Plugins översikt';
$string['pluginsoverviewsee'] = 'Se <a href="{$a->url}">plugins översikt</a> sida för mer information.';
$string['profilecategory'] = 'Kategori';
$string['profilecategoryname'] = 'Namn på kategori (måste vara unikt)';
$string['profilecategorynamenotunique'] = 'Det här kategorinamnet används redan';
$string['profilecommonsettings'] = 'Vanliga inställningar';
$string['profileconfirmcategorydeletion'] = 'Det finns {$a} fält i den här kategorin som kommer att flyttas till kategorin ovan (eller nedan om den är längst upp i kategorin) <br /> Vill Du fortfarande ta bort den här kategorin?';
$string['profileconfirmfielddeletion'] = 'Det finns {$a} poster för användare i det här fältet som kommer att tas bort. <br />Är DU säker på att Du vill ta bort det här fältet?';
$string['profilecreatecategory'] = 'Skapa en ny kategori för profil';
$string['profilecreatefield'] = 'Skapa ett nytt fält för kategori';
$string['profilecreatenewcategory'] = 'Skapar en ny kategori';
$string['profilecreatenewfield'] = 'Skapar ett nytt "{$a}" fält för profil';
$string['profiledefaultcategory'] = 'Andra fält';
$string['profiledefaultchecked'] = 'Förvald som standard';
$string['profiledefaultdata'] = 'Förvalt standardvärde';
$string['profiledeletecategory'] = 'Definierar en kategori';
$string['profiledeletefield'] = 'Tar bort fält \'{$a}\'';
$string['profiledescription'] = 'Beskrivning av ett fält';
$string['profiledscript'] = 'Detta skript har profilerats';
$string['profiledscriptview'] = 'Visa profileringsinformation för det här skriptet';
$string['profileeditcategory'] = 'Redigerar kategori: {$a}';
$string['profileeditfield'] = 'Redigerar ett fält för profil: {$a}';
$string['profilefield'] = 'Fält för profil';
$string['profilefieldcolumns'] = 'Kolumner';
$string['profilefieldispassword'] = 'Är detta ett fält för lösenord?';
$string['profilefieldlink'] = 'Länk';
$string['profilefieldlinktarget'] = 'Mål för länk';
$string['profilefieldmaxlength'] = 'Maximal längd';
$string['profilefieldrows'] = 'Rader';
$string['profilefields'] = 'Fält för användarprofil';
$string['profilefieldsize'] = 'Storlek för visning';
$string['profileforceunique'] = 'Ska data vara unika?';
$string['profileinvaliddata'] = 'Ogiltigt värde';
$string['profilelocked'] = 'Är det här fältet låst?';
$string['profilemenudefaultnotinoptions'] = 'Det förvalda standardvärdet går inte att välja.';
$string['profilemenunooptions'] = 'Det finns inte några angivna menyval';
$string['profilemenuoptions'] = 'Menyval (ett per rad)';
$string['profilemenutoofewoptions'] = 'Du måste ange åtminstone två alternativ';
$string['profilename'] = 'Namn';
$string['profilenofieldsdefined'] = 'Inga fält har definierats';
$string['profilerequired'] = 'Är det här fältet obligatoriskt?';
$string['profileroles'] = 'Synliga roller för profil';
$string['profilesforenrolledusersonly'] = 'Profil som endast gäller för registrerade användare';
$string['profileshortname'] = 'Kortnamn (måste vara unikt)';
$string['profileshortnamenotunique'] = 'Kortnamnet används redan';
$string['profilesignup'] = 'Visa på den sida där man skriver in sig?';
$string['profilespecificsettings'] = 'Specifika inställningar';
$string['profilevisible'] = 'För vem är detta fält synligt?';
$string['profilevisibleall'] = 'Synligt för alla';
$string['profilevisible_help'] = '<p>För varje specialutformat fält kan Du göra tre inställningar för synlighet: \'osynlig\', \'alla\' och \'användare\'. Inställningen för \'osynlighet\' bör normalt sett användas när administratören har behov av att ha tillgång till privata data om användare. Inställningen \'användare\' bör normalt sett användas för känslig information medan inställningen \'alla\' kan användas för vilken typ av information som helst.  </p>';
$string['profilevisiblenone'] = 'Inte synligt';
$string['profilevisibleprivate'] = 'Synligt för användare';
$string['profiling'] = 'Profilering';
$string['profilingallowall'] = 'Kontinuerlig profilering';
$string['profilingallowme'] = 'Selektiv profilering';
$string['profilingautofrec'] = 'Automatisk profilering';
$string['profilingenabled'] = 'Aktivera profilering';
$string['profilingexcluded'] = 'Undanta profilering';
$string['profilingincluded'] = 'Profilera dessa';
$string['profilinglifetime'] = 'Behåll profileringskörningarna';
$string['protectusernames'] = 'Skydda användarnamn';
$string['proxyhost'] = 'Proxyvärd';
$string['proxypassword'] = 'Lösenord för proxy';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Typ av proxy';
$string['proxyuser'] = 'Användarnamn för proxy';
$string['purgecaches'] = 'Töm allt i cacheminnet';
$string['purgecachesfinished'] = 'Allt i cacheminnet tömdes';
$string['qtyperqpwillberemoved'] = 'Under uppgraderingen kommer RQP-frågan att tas bort. Du använde inte den här typen av frågor så Du bör inte stöta på några problem.';
$string['qtyperqpwillberemovedanyway'] = 'Under uppgraderingen kommer RQP-frågan att tas bort. Du har några RQP-frågor i Din databas och de kommer att sluta att fungera om Du inte installerar om koden från http://moodle.org/mod/data/view.php?d=13&amp;rid=797 innan Du fortsätter med uppgraderingen.';
$string['quarantinedir'] = 'Katalog för karantän';
$string['question'] = 'Fråga';
$string['questioncwqpfscheck'] = 'En eller flera \'slumpmässiga\' frågor i testet har ställts in för att välja frågor från en blandning av gemensamma och separata kategorier av frågor. Det finns en mer detaljerad rapport <a href="{$a->reporturl}">här</a> och Du kan läsa mer på en sida ur dokumentationen för Moodle a href="{$a->docsurl}">här</a>.';
$string['questioncwqpfsok'] = 'Bra! Det finns inga slumpmässiga frågor i Dina test som är inställda till att välja frågor ur en blandning av gemensamma och separata kategorier av frågor.';
$string['questiontype'] = 'Frågetyp';
$string['questiontypes'] = 'Frågetyper';
$string['recaptchaprivatekey'] = 'Privat nyckel för ReCAPTCHA';
$string['recaptchapublickey'] = 'Offentlig nyckel för ReCAPTCHA';
$string['register'] = 'Registrera din webbplats';
$string['registermoodleorg'] = 'När du registrerar din webbplats med {$a}';
$string['registermoodleorgli3'] = 'Din webbplats är också registrerad hos Moodle.net ({$a}) vilket möjliggör användare med förmågan att publicera kurser (endast administratörer som standard) att publicera kurser på Moodle.net.';
$string['registerwithmoodleorg'] = 'Registrera hos moodle.org';
$string['registration'] = 'Registrering';
$string['registrationwarning'] = 'Din webbplats är inte registrerad.';
$string['releasenoteslink'] = 'För information om den här versionen av Moodle, var snäll och se <a target="_new" href="{$a}">Anteckningar om aktuell version</a>';
$string['rememberusername'] = 'Kom ihåg användarnamn';
$string['reportsmanage'] = 'Hantera rapporter';
$string['requestcategoryselection'] = 'Aktivera val av kategori';
$string['requiremodintro'] = 'Begär beskrivning av aktivitet';
$string['requires'] = 'Begär';
$string['reverseproxy'] = 'Omvänd proxy';
$string['riskconfig'] = 'Användare kan ändra konfiguration och beteende för webbplatsen.';
$string['riskconfigshort'] = 'Risk med konfiguration';
$string['riskdataloss'] = 'Användare kan förstöra stora mängder av innehåll eller information';
$string['riskdatalossshort'] = 'Risk för dataförlust';
$string['riskmanagetrust'] = 'Användare kan ändra andra användares inställningar för tillförlitlighet.';
$string['riskmanagetrustshort'] = 'Administrera tillförlitlighet';
$string['riskpersonal'] = 'Användare skulle kunna få tillgång till privat information om andra användare.';
$string['riskpersonalshort'] = 'Risk för integritet';
$string['riskspam'] = 'Användare skulle kunna skicka skräppost till användare på webbplatsen eller till andra.';
$string['riskspamshort'] = 'Risk för skräppost';
$string['riskxss'] = 'Användare skulle kunna lägga till filer och texter som tillåter skript (XSS) globalt på webbplatsen.';
$string['riskxssshort'] = 'XSS-risk';
$string['roleswithexceptions'] = '$a->roles}, med {$a->exceptions}';
$string['rssglobaldisabled'] = 'Avaktiverad på servernivå';
$string['runclamavonupload'] = 'Använd clam AV för att undersöka uppladdade filer';
$string['save'] = 'Spara';
$string['savechanges'] = 'Spara ändringar';
$string['search'] = 'Sök';
$string['searchinsettings'] = 'Sök i inställningar';
$string['searchresults'] = 'Sök resultat';
$string['sectionerror'] = 'Fel på sektion!';
$string['secureforms'] = 'Använd utvidgad säkerhet för formulär';
$string['security'] = 'Säkerhet';
$string['selectdevice'] = 'Välj enhet';
$string['selecttheme'] = 'Välj tema för enhet {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Server kontroller';
$string['serverlimit'] = 'Server gräns';
$string['sessioncookie'] = 'Prefix för cookie';
$string['sessioncookiedomain'] = 'Domän för cookie';
$string['sessioncookiepath'] = 'Sökväg för cookie';
$string['sessionhandling'] = 'Hantering av sessioner';
$string['sessiontimeout'] = 'Timeout';
$string['settingfileuploads'] = 'Filuppladdning krävs för normal drift, vänligen aktivera det i PHP-inställningar.';
$string['settingmemorylimit'] = 'Otillräckligt minne har upptäcks, ställ högre minnesgräns i PHP inställningar.';
$string['showcommentscount'] = 'Visa räkning av kommentarer';
$string['showdetails'] = 'Visa detaljer';
$string['showuseridentity'] = 'Visa användarens identitet';
$string['showuseridentity_desc'] = 'Vid val av eller sökning efter användare samt vid visning av användarlistor så kommer de här fälten visas utöver användarnas fullständiga namn. Fälten visas enbart för användare som har förmågan moodle/site:viewuseridentity; vilket som standard är lärare och administratörer. (Det här alternativet är lämpligast ifall du väljer ett eller två fält som är obligatoriska vid din institution).';
$string['simplexmlrequired'] = 'Från och med nu kräver Moodle PHP-tillägget  SimpleXML';
$string['sitemaintenance'] = 'Det pågår f.n underhåll på webbplatsen och det är för tillfället inte tillgänglig.';
$string['sitemaintenancemode'] = 'Läge för underhåll';
$string['sitemaintenanceoff'] = 'Läget för underhåll har avaktiverats och webbplatsen fungerar normalt igen.';
$string['sitemaintenanceon'] = 'Din webbplats är f.n. i ett läge för underhåll. (bara adminstratörer kan logga in eller använda platsen).';
$string['sitemaintenancewarning'] = 'Din webbplats är f.n. i ett läge för underhåll. (bara adminstratörer kan logga in). För att återställa den här webbplatsen till normalt operativt läge  <a href="maintenance.php">avaktivera läget för underhåll</a>.';
$string['sitepolicies'] = 'Regler för användning av webbplatsen';
$string['sitepolicy'] = 'URL till regler för användning av webbplatsen';
$string['sitepolicyguest'] = 'URL till webbplatsens policy för gäster';
$string['sitepolicy_help'] = 'Har Du en policy för webbplatsen som alla användare måste se och godkänna innan de får tillträde till den här webbplatsen? Då ska Du ange URL-en till den här. URL-en kan peka vart som helst - en lämplig plats kunde vara en fil i katalogen för webbplatsens filer t.ex. http://dinwebbplats/file.php/1/policy.html';
$string['sitesectionhelp'] = 'Om detta är valt så kommer en sektion för ämnen att visas på webbplatsens ingångssida (hem/första).';
$string['slasharguments'] = 'Använd \'snedstrecks\'-argument';
$string['smartpix'] = 'Smart sökning av bilder';
$string['sort_fullname'] = 'Kursens fullständiga namn';
$string['sort_idnumber'] = 'Kurs ID-nummer';
$string['sort_shortname'] = 'Kursens kortnamn';
$string['sort_sortorder'] = 'Sorteringsordning';
$string['spellengine'] = 'Stavningskontroll';
$string['splrequired'] = ' SPL PHP-tillägget är nu obligatoriskt i Moodle';
$string['stats'] = 'Statistik';
$string['statsfirstrun'] = 'Maximalt intervall för bearbetning';
$string['statsmaxruntime'] = 'Maximal tid för körning';
$string['statsmoodleorg'] = 'statistik';
$string['statsruntimedays'] = 'Dagar att processa';
$string['statsruntimestart'] = 'Kör vid';
$string['statsuserthreshold'] = 'Tröskel för användare';
$string['stickyblocks'] = 'Permantenta block';
$string['stickyblockscourseview'] = 'Kurssida';
$string['stickyblocksduplicatenotice'] = 'Om något av de block som Du lägger till här redan finns på en specifik sida så kommer detta att resultera i att det blir ytterligare en kopia.<br />Bara det markerade blocket kommer att vara låst för redigering, kopian kommer att vara redigeringsbar.';
$string['stickyblocksmymoodle'] = 'Mitt moodle';
$string['stickyblockspagetype'] = 'Typ av sida som ska konfigureras';
$string['strictformsrequired'] = 'Strikt validering av obligatoriska fält';
$string['stripalltitletags'] = 'Ta bort HTML-taggar från alla namn på aktiviteter';
$string['supportcontact'] = 'Support kontakt';
$string['supportemail'] = 'E-post till supporten';
$string['supportname'] = 'Namn på supporten';
$string['supportpage'] = 'Sida för support';
$string['suspenduser'] = 'Spärra användarkonto';
$string['switchlang'] = 'Byt katalog för språk';
$string['systempaths'] = 'Sökvägar för system';
$string['tablenosave'] = 'Ändringarna i den ovanstående tabellen sparas automatiskt.';
$string['tablesnosave'] = 'Ändringarna i de ovanstående tabellerna sparas automatiskt.';
$string['tabselectedtofront'] = 'På tabeller med tabbar bör raden med den för tillfället valda taggen placeras längst fram.';
$string['tabselectedtofronttext'] = 'Flytta den markerade tab-raden till förgrunden';
$string['themedesignermode'] = 'Läge för design av teman';
$string['themelist'] = 'Lista över teman';
$string['themenoselected'] = 'Inget tema har valts';
$string['themeresetcaches'] = 'Töm cachminnet på teman';
$string['themeselect'] = 'Ändra tema';
$string['themeselector'] = 'Att välja teman';
$string['themesettings'] = 'Inställningar för teman';
$string['therewereerrors'] = 'Det fanns fel i Dina data';
$string['thirdpartylibrary'] = 'Bibliotek';
$string['thirdpartylibrarylocation'] = 'Plats';
$string['thirdpartylibs'] = 'Tredjepartsbibliotek';
$string['timezone'] = 'Förvald tidszon';
$string['timezoneforced'] = 'Det här är fastställt av systemadministratören';
$string['timezoneisforcedto'] = 'Tvinga alla användare att använda samma tidszon';
$string['timezonenotforced'] = 'Användare kan själva välja sin egen tidszon';
$string['tokenizerrecommended'] = 'Vi rekommenderar att Du installerar det valfria tillägget PHP Tokenizer - det förbättrar funktionaliteten för nätverk med Moodle.';
$string['tools'] = 'Admin verktyg';
$string['unattendedoperation'] = 'Operation som inte monitoreras';
$string['unbookmarkthispage'] = 'ta bort bokmärket för den här sidan';
$string['unicoderecommended'] = 'Vi rekommenderar att Du lagrar alla Dina data i Unicode (UTF-8). Nya installationer bör genomföras i databaser som har Unicode som förvald standardinställning för teckenuppsättningar. Om Du uppgraderar så bör Du genomföra processen för migration till UTF-8 (se sidan för administration).';
$string['unicoderequired'] = 'Det är ett krav att Du lagrar alla Dina data i Unicode (UTF-8). Nya installationer måste genomföras i databaser som har Unicode som förvald standardinställning för teckenuppsättningar. Om Du uppgraderar så bör Du genomföra processen för migration till UTF-8 (se sidan för administration).';
$string['uninstallplugin'] = 'Avinstallera';
$string['unsupported'] = 'Stödjs inte';
$string['unsuspenduser'] = 'Aktivera användarkonto';
$string['updateaccounts'] = 'Uppdatera befintliga konton';
$string['updateautocheck'] = 'Kontrollera automatiskt efter tillgängliga uppdateringar';
$string['updateautocheck_desc'] = 'Om aktiverad, kommer din webbplats att automatiskt kontrollera efter tillgängliga uppdateringar för både Moodle och alla ytterligare plugin. Om det finns en ny uppdatering tillgänglig, kommer ett meddelande att skickas till administratörer.';
$string['updateavailable'] = 'Det finns en nyare Moodle version tillgänglig!';
$string['updateavailabledetailslink'] = 'Se {$a->url} för mer information';
$string['updateavailableforplugin'] = 'Det finns en nyare version tillgängliga för några av dina plugins!';
$string['updateavailableinstall'] = 'Installera den här uppdateringen';
$string['updateavailable_moreinfo'] = 'Mer info ...';
$string['updateavailablenot'] = '';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Version {$a}';
$string['updatecomponent'] = 'Uppdatera komponent';
$string['updateminmaturity'] = 'Obligatorisk kodmognad';
$string['updatenotifications'] = 'Meddelanden om uppdateringar';
$string['updatenotificationsubject'] = 'Moodle uppdateringar finns tillgängliga ({$a->siteurl})';
$string['upgrade197noticesubject'] = 'Säkerhetsnotiser för uppgradering till Moodle 1.9.7';
$string['upgradeerror'] = 'Okänt fel vid uppgradering av {$a->plugin} till version {$a->version}, kan inte fortsätta.';
$string['upgradeforumread'] = 'En ny egenskap har lagts till i Moodle 1.5. Den innebär att man kan spåra lästa/olästa inlägg. <br />För att använda denna funktion behöver du <a href="{$a}">uppdatera dina tabeller</a>.';
$string['upgradeforumreadinfo'] = 'En ny egenskap har lagts till i Moodle 1.5. Den innebär att man kan spåra lästa/olästa inlägg. För att använda denna funktion behöver du uppdatera dina tabeller med all spårande information för befintliga inlägg. Beroende på hur stor Din webbplats är så kan detta ta en hel del tid och utgöra en belastning på Din databas. Därför är det bäst om Du kan göra detta under en lugn period. Din webbplats kommer emellertid att fortsätta att fungera under denna uppgradering och användarna kommer inte att påverkas. När Du väl har påbörjat denna process så bör Du också fullfölja den (lämna webbläsarens fönter öppet). Skulle Du råka stänga det och avbryta processen så är det ingen stor olycka. Du kan börja om igen. Vill Du påbörja processen för uppgradering nu?';
$string['upgradelogs'] = 'För att Du ska kunna utnyttja all funktionalitet så måste Dina gamla loggar uppgraderas. <a href="{$a}">Mer information</a>';
$string['upgradelogsinfo'] = 'En del förändringar har nyligen gjorts när det gäller hur loggarna lagras. För att Du ska kunna se alla Dina gamla loggar per aktivitet s a s så måste Dina gamla loggar uppgraderas. Detta kan ta lång tid, beroende på hur Din webbplats fungerar och det kan vara rätt krävande för databasen om det är en stor webbplats. När Du väl har påbörjat den här processen så bör Du också slutföra den (genom att hålla webbläsarens fönster öppet). Var dock inte orolig för Dina användare, webbplatsen bör fungera normalt för dem medan detta pågår. <br /><br /> Vill Du uppdatera Dina loggar nu?';
$string['upgradepluginsinfo'] = 'Uppdaterar plugins';
$string['upgradesettings'] = 'Nya inställningar';
$string['upgradesettingsintro'] = 'Inställningarna här nedan lades till under Din senaste uppgradering av Moodle. Gör  (eventuellt) nödvändiga ändringar av de förvalda standardinställningarna och klicka sedan på "Spara inställningar" längst ner på den här sidan.';
$string['upgradestalefiles'] = 'Blandade Moodle versioner upptäckta, uppgraderingen kan inte fortsätta';
$string['upgradestart'] = 'Uppgradera Moodle databasen nu';
$string['upgradesure'] = 'Dina Moodle-filer har ändrats och Du håller på att automatiskt uppgradera Din server till den här versionen:
</p>
<p><strong>{$a}</strong></p>
<p>Du kan inte ångra detta.</p><p>Lägg märke till att detta kan ta lång tid.</p>
<p>Är Du säker på att Du vill uppgradera servern till den här versionen?</p>';
$string['upgradetimedout'] = 'Uppgraderingen avbröts, var snäll och starta om den.';
$string['upgradingdata'] = 'Uppgraderar data';
$string['upgradinglogs'] = 'Uppgraderar loggarna';
$string['upgradingversion'] = 'Uppgraderar till en ny version';
$string['upwards'] = 'uppåt';
$string['useblogassociations'] = 'Aktivera associationer';
$string['useexternalyui'] = 'Använd YUI-bibliotek på nätet';
$string['user'] = 'Användare';
$string['userbulk'] = 'Hantering av användare i \'bulk\'.';
$string['userlist'] = 'Bläddra igenom listan över användare';
$string['userpolicies'] = 'Regler för användning';
$string['userpreference'] = 'Preferenser för användare';
$string['userquota'] = 'Kvot för användare';
$string['users'] = 'Användare';
$string['usetags'] = 'Aktivera funktionaliteten med intressen';
$string['validateerror'] = 'Det här värdet var inte giltigt:';
$string['verifychangedemail'] = 'Begränsa domäner när det görs ändringar av e-postadresser';
$string['warningcurrentsetting'] = 'Ogiltigt aktuellt värde: {$a}';
$string['webproxy'] = 'Webb proxy';
$string['webproxyinfo'] = 'Fyll i följande alternativ om din Moodle-server inte har direkt tillgång till Internet. Tillgång till Internet är nödvändigt för att du ska kunna ladda ner miljödata, språkpaket, RSS-matningar, tidszoner etc.<br /><em>PHP cURL extensionen rekommenderas starkt.</em>';
$string['xmlrpcrecommended'] = 'Att installera det valfria xmlrpc-tillägget är nödvändigt för hub kommunikation och är användbart med tanke på webbtjänster och funktionaliteten i Moodle Nätverk.';
$string['yuicomboloading'] = 'Laddar YUI combo';
$string['zlibenabled'] = 'zlib aktiverat';
