<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'he', branch 'MOODLE_26_STABLE'
 *
 * @package   facetoface
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = 'מוסיף מחזור חדש ב-{$a}';
$string['addmanageremailaddress'] = 'הוסף דואר אלקטרוני של מנהל';
$string['addmanageremailinstruction'] = 'טרם הקלדת כתובת דוא"ל של מנהלך. אנא הקלד כתובת זו כדי להירשם למחזור זה.';
$string['addnewfield'] = 'הוסף שדה מותאם אישית חדש';
$string['addnewfieldlink'] = 'צור שדה מותאם אישית חדש';
$string['addnewnotice'] = 'הוסף הודעת אתר חדשה';
$string['addnewnoticelink'] = 'צור הודעת אתר חדשה';
$string['addremoveattendees'] = 'הוסף/הסר משתתפים';
$string['addsession'] = 'הוסף מחזור חדש';
$string['addstudent'] = 'הוסף משתתף';
$string['alllocations'] = 'כל המיקומים';
$string['allowoverbook'] = 'התר רישום יתר';
$string['allsessionsin'] = 'כל המחזורים ב-{$a}';
$string['alreadysignedup'] = 'נרשמת כבר להדרכה זו';
$string['answer'] = 'היכנס';
$string['answercancel'] = 'התנתק';
$string['approvalreqd'] = 'נדרש אישור';
$string['approvalreqd_help'] = 'כאשר מסומן "נדרש אישור", לומד יצטרך אישור מהמנהל שלו שלו על מנת להירשם להדרכה.';
$string['approve'] = 'אשר';
$string['assessmentyour'] = 'ההערכה שלך';
$string['attendance'] = 'נוכחות';
$string['attendanceinstructions'] = 'בחר משתתפים שנכחו במחזור:';
$string['attendedsession'] = 'השתתף במחזור';
$string['attendees'] = 'משתתפים';
$string['attendeestablesummary'] = 'אנשים המתוכננים להשתתף או שהשתתפו במחזור זה.';
$string['booked'] = 'רשום';
$string['bookingcancelled'] = 'הרשמתך בוטלה.';
$string['bookingcompleted'] = 'הרשמתך בוצעה.';
$string['bookingfull'] = 'ההרשמה מלאה';
$string['bookingopen'] = 'פתוח להרשמה';
$string['bookingstatus'] = 'אתה רשום למחזור זה';
$string['calendareventdescriptionbooking'] = 'אתה רשום <a href="{$a}">למחזור הדרכה זה</a>.';
$string['calendareventdescriptionsession'] = 'אתה יצרת את <a href="{$a}">מחזור הדרכה זה</a>.';
$string['calendaroptions'] = 'אפשרויות לוח שנה';
$string['cancelbooking'] = 'בטל הרשמה';
$string['cancelbookingfor'] = 'בטל הרשמה ל- {$a}';
$string['cancellation'] = 'ביטול';
$string['cancellationconfirm'] = 'האם אתה בטוח שברצונך לבטל הרשמתך למחזור זה?';
$string['cancellationinstrmngr'] = '# הודעה למנהל';
$string['cancellationmessage'] = 'הודעת ביטול';
$string['cancellationmessage_help'] = 'הודעה זו נשלחת כאשר משתמשים מבטלים את רישומם למחזור.';
$string['cancellations'] = 'ביטולים';
$string['cancellationsent'] = 'נשלחה לך הודעת ביטול בדואר אלקטרוני.';
$string['cancellationsentmgr'] = 'נשלחה לך ולמנהל שלך הודעת ביטול בדואר אלקטרוני.';
$string['cancellationstablesummary'] = 'רשימת אנשים שביטלו את הרשמתם למחזור.';
$string['cancelreason'] = 'סיבה';
$string['cannotapproveatcapacity'] = 'אינך יכול לאשר השתתפות משתתפים נוספים מכיוון שהמפגש מלא.';
$string['cannotsignupsessioninprogress'] = 'אינך יכול להירשם. מחזור זה מתקיים כעת';
$string['cannotsignupsessionover'] = 'אינך יכול להירשם, המחזור הסתיים.';
$string['capacity'] = 'מקומות בהדרכה';
$string['changemanageremailaddress'] = 'שנה כתובת דוא"ל של מנהל';
$string['changemanageremailinstruction'] = 'אנא הקלד את כתובת הדוא"ל של המנהל שלך';
$string['clearall'] = 'נקה הכל';
$string['closed'] = 'סגור';
$string['conditions'] = 'תנאים';
$string['conditionsexplanation'] = 'כל הקריטריונים הבאים צריכים להתקיים לפני שהודעה תוצג בלוח השנה:';
$string['confirm'] = 'אשר';
$string['confirmanager'] = 'אשר את הדוא"ל של המנהל שלך';
$string['confirmation'] = 'אישור';
$string['confirmationinstrmngr'] = '# הודעה למנהל';
$string['confirmationmessage'] = 'הודעת אישור';
$string['confirmationmessage_help'] = 'הודעה זו נשלחת כאשר משתמשים נרשמים למחזור.';
$string['confirmationsent'] = 'נשלחה לך הודעת אישור בדואר אלקטרוני.';
$string['confirmationsentmgr'] = 'נשלחה לך ולמנהל שלך הודעת אישור בדואר אלקטרוני.';
$string['confirmmanageremailaddress'] = 'אשר את הדוא"ל של המנהל שלך';
$string['confirmmanageremailaddressquestion'] = 'האם <b>{$a}</b> היא כתובת הדוא"ל העדכני של המנהל שלך?';
$string['confirmmanageremailinstruction1'] = 'בעבר הקלדת כתובת דוא"ל זו של המנהל שלך:';
$string['confirmmanageremailinstruction2'] = 'האם זו עדיין כתובת הדוא"ל של המנהל שלך?';
$string['copy'] = 'העתק';
$string['copyingsession'] = 'מעתיק כמחזור חדש ב-{$a}';
$string['copysession'] = 'העתק מחזור';
$string['cost'] = 'עלות';
$string['costheading'] = 'עלות מחזור';
$string['currentstatus'] = 'סטטוס נוכחי';
$string['customfieldsheading'] = 'שדות מותאמים אישית למחזור';
$string['date'] = 'תאריך';
$string['dateadd'] = 'הוסף תאריך נוסף';
$string['dateremove'] = 'מחק תאריך זה';
$string['datesignedup'] = 'תאריך ההרשמה';
$string['datetext'] = 'אתה רשום לתאריך זה';
$string['decidelater'] = 'החלט מאוחר יותר';
$string['decline'] = 'סרב';
$string['delete'] = 'מחיקה';
$string['deleteall'] = 'מחק הכל';
$string['deletesession'] = 'מחק מחזור';
$string['deletesessionconfirm'] = 'האם אתה בטוח שברצונך למחוק מחזור הדרכה זה וכל הנרשמים לו?';
$string['deletingsession'] = 'מוחק מחזור ב-{$a}';
$string['description'] = 'הודעת פתיחה';
$string['details'] = 'פרטים';
$string['discountcode'] = 'קוד הנחה';
$string['discountcode_help'] = 'קוד הנחה הוא הקוד הנדרש כדי שתופיע עלות ההנחה עבור ההדרכה של העובד.
עם העובד לא מקליד את קוד ההנחה, תופיע העלות הרגילה בתיעוד ההדרכה.';
$string['discountcost'] = 'עלות ההנחה';
$string['discountcost_help'] = 'עלות ההנחה היא הסכום המחויב עבור העובד שיש לו את קוד ההנחה.
אם העובד הקליד את קוד ההנחה בהרשמה להדרכה, עלות ההנחה תופיע בטור העלות בגיליון הציונים של הקורס.';
$string['due'] = 'תאריך יעד';
$string['duration'] = 'משך';
$string['early'] = '{$a} מוקדם';
$string['edit'] = 'ערוך';
$string['editingsession'] = 'עורך מחזור ב-{$a}';
$string['editsession'] = 'ערוך מחזור';
$string['email:instrmngr'] = 'הודעה למנהל';
$string['emailmanager'] = 'שלח הודעה למנהל';
$string['emailmanagercancellation'] = '# שלח הודעה למנהל';
$string['emailmanagerconfirmation'] = '# שלח הודעה למנהל';
$string['emailmanagerreminder'] = '# שלח הודעה למנהל';
$string['email:message'] = 'הודעה';
$string['email:subject'] = 'נושא';
$string['emptylocation'] = 'פרטי מיקום ריקים';
$string['enrolled'] = 'רשום';
$string['error:addalreadysignedupattendee'] = '{$a} כבר רשום למחזור הדרכה בפעילות זו.';
$string['error:addattendee'] = 'לא הייתה אפשרות להוסיף את {$a} למחזור.';
$string['error:cancelbooking'] = 'הייתה בעיה בביטול הרשמתך';
$string['error:cannotemailmanager'] = 'נשלחה הודעת תזכורת {$a->submissionid} למשתמש {$a->userid}, אך לא ניתן לשלוח הודעה לדוא"ל של המנהל ({$a->manageremail}).';
$string['error:cannotemailuser'] = 'לא ניתן לשלוח דוא"ל בקשה מספר {$a->submissionid} למשתמש {$a->userid} ({$a->useremail}).';
$string['error:cannotsendconfirmationmanager'] = 'הודעת אישור נשלחה לדוא"ל שלך, אך הייתה בעיה בשליחת הודעת אישור לדוא"ל של המנהל שלך.';
$string['error:cannotsendconfirmationthirdparty'] = 'הודעת אישור נשלחה אליך ולמנהלך בדוא"ל, אך הייתה בעיה בשליחת הודעת אישור לגורם האחראי על ההדרכה.';
$string['error:cannotsendconfirmationuser'] = 'הייתה בעיה בשליחת הודעת אישור לדוא"ל שלך.';
$string['error:cannotsendconfirmationusermanager'] = 'לא ניתן לשלוח הודעת אישור לדוא"ל שלך ושל המנהל שלך.';
$string['error:cannotsendrequestmanager'] = 'הייתה בעיה בשליחת הודעת בקשת רישום לכתובת הדוא"ל של מנהלך.';
$string['error:cannotsendrequestuser'] = 'הייתה בעיה בשליחת הודעת בקשת רישום לכתובת הדוא"ל שלך.';
$string['error:canttakeattendanceforunstartedsession'] = 'לא ניתן לתעד נוכחות למחזור שטרם החל.';
$string['error:couldnotaddfield'] = 'הוספת שדה מותאם אישית למחזור נכשלה.';
$string['error:couldnotaddnotice'] = 'הוספת הודעת אתר נכשלה.';
$string['error:couldnotaddsession'] = 'הוספת מחזור נכשלה';
$string['error:couldnotaddtrainer'] = 'שמירת מדריך למחזור ההדרכה נכשלה.';
$string['error:couldnotcopysession'] = 'העתקת מחזור נכשלה';
$string['error:couldnotdeletefield'] = 'מחיקת שדה מותאם אישית נכשלה';
$string['error:couldnotdeletenotice'] = 'מחיקת הודעת אתר נכשלה';
$string['error:couldnotdeletesession'] = 'מחיקת מחזור נכשלה';
$string['error:couldnotdeletetrainer'] = 'מחיקת מדריך מחזור ההדרכה נכשלה.';
$string['error:couldnotfindsession'] = 'לא ניתן היה לאתר את המחזור החדש שהוכנס';
$string['error:couldnotsavecustomfield'] = 'שמירת שדה מותאם אישית נכשלה';
$string['error:couldnotupdatecalendar'] = 'עדכון אירוע ההדרכה בלוח השנה נכשל.';
$string['error:couldnotupdatef2frecord'] = 'לא ניתן היה לעדכן תיעוד הרשמה להדרכה בבסיס הנתונים';
$string['error:couldnotupdatefield'] = 'עדכון שדה מותאם אישית נכשל.';
$string['error:couldnotupdatemanageremail'] = 'עדכון כתובת דוא"ל מנהל נכשלה.';
$string['error:couldnotupdatenotice'] = 'עדכון הודעת אתר נכשלה.';
$string['error:couldnotupdatesession'] = 'עדכון מחזור נכשל';
$string['error:coursemisconfigured'] = 'יש בעיה בהגדרות של הקורס';
$string['error:cronprefix'] = 'תקלה: facetoface cron';
$string['error:emptylocation'] = 'מיקום היה ריק.';
$string['error:emptymanageremail'] = 'דוא"ל מנהל ריק';
$string['error:emptyvenue'] = 'פרטי בניין ריקים';
$string['error:enrolmentfailed'] = 'לא ניתן לרשום את {$a} לקורס.';
$string['error:eventoccurred'] = 'אינך יכול לבטל אירוע שכבר התרחש.';
$string['error:f2ffailedupdatestatus'] = 'לא ניתן היה לעדכן את הסטטוס של המשתמש';
$string['error:fieldidincorrect'] = 'קוד שדה לא נכון: {$a}';
$string['error:incorrectcoursemodule'] = 'רכיב קורס אינו תקין';
$string['error:incorrectcoursemoduleid'] = 'קוד רכיב קורס אינו תקין';
$string['error:incorrectcoursemodulesession'] = 'רכיב מחזור הדרכת כיתה אינו תקין';
$string['error:incorrectfacetofaceid'] = 'קוד זיהוי של הדרכה כיתה אינו תקין';
$string['error:incorrectnotificationtype'] = 'לא הוגדר סוג הודעה נכון';
$string['error:invaliduserid'] = 'קוד משתמש לא חוקי';
$string['error:manageremailaddressmissing'] = 'נכון לרגע זה לא מקוצה לך מנהל במערכת. אנא פנה למנהל המערכת.';
$string['error:mustspecifycoursemodulefacetoface'] = 'חובה לציין רכיב קורס או קוד מחזור ההדרכה';
$string['error:nomanageremail'] = 'לא סיפקת כתובת דואר אלקטרוני של מנהלך';
$string['error:nomanagersemailset'] = 'לא הוגדר דוא"ל מנהל';
$string['error:nopermissiontosignup'] = 'אין לך הרשאה להירשם למחזור הדרכה זה.';
$string['error:noticeidincorrect'] = 'קוד זיהוי הודעה אינו תקין: {$a}';
$string['error:problemsigningup'] = 'הייתה בעיה בהרשמתך.';
$string['error:removeattendee'] = 'לא ניתן היה למחוק את {$a} מהמחזור.';
$string['error:sessionstartafterend'] = 'תאריך סיום המחזור הוא לפני תאריך הפתיחה.';
$string['error:shortnametaken'] = 'שדה מותאם אישית בשם קצר זה כבר קיים.';
$string['error:signedupinothersession'] = 'אתה כבר רשום למחזור אחר בהדרכה זו. ניתן להירשם למחזור אחד בלבד בפעילות הדרכת כיתה.';
$string['error:unknownbuttonclicked'] = 'אין פעולה שמקושרת לכפתור שנלחץ';
$string['excelformat'] = 'אקסל';
$string['export'] = 'ייצא';
$string['exportattendance'] = 'ייצא נוכחות';
$string['exporttofile'] = 'ייצא לקובץ';
$string['facetoface'] = 'הדרכת כיתה';
$string['facetoface:addattendees'] = 'הוסף משתתפים למחזור הדרכה';
$string['facetofacebooking'] = 'רישום להדרכת כיתה';
$string['facetoface:editsessions'] = 'הוסף, ערוך, העתק ומחק מחזורי הדרכה';
$string['facetofacename'] = 'שם הדרכת הכיתה';
$string['facetoface:overbook'] = 'הרשמה למחזורים מלאים.';
$string['facetoface:removeattendees'] = 'הסר משתתפים ממחזור הדרכה';
$string['facetofacesession'] = 'מחזור הדרכה';
$string['facetoface:signup'] = 'הירשם למחזור';
$string['facetoface:takeattendance'] = 'רשום נוכחות';
$string['facetoface:view'] = 'צפה בפעילויות הדרכת כיתה ובמחזורים';
$string['facetoface:viewattendees'] = 'צפה ברשימת נוכחות ובמשתתפים';
$string['facetoface:viewcancellations'] = 'צפה בביטולים';
$string['facetoface:viewemptyactivities'] = 'צפה בפעילויות הדרכת כיתה ריקות';
$string['feedback'] = 'משוב';
$string['feedbackupdated'] = 'משוב עודכן ל-{$a} אנשים';
$string['fielddeleteconfirm'] = 'מחק שדה \'{$a}\' וכל נתוני המחזורים המקשורים לו?';
$string['field:multiselect'] = 'בחירה מרובה';
$string['field:select'] = 'תפריט אפשרויות';
$string['field:text'] = 'מלל';
$string['floor'] = 'קומה';
$string['format'] = 'פורמט';
$string['full'] = 'התאריך מלא';
$string['goback'] = 'חזור';
$string['guestsno'] = 'מצטערים, אורחים אינם מורשים להירשם למחזורים.';
$string['icalendarheading'] = 'קבצי iCalendar מצורפים';
$string['import'] = 'ייבא';
$string['info'] = 'מידע';
$string['late'] = '{$a} מאוחר';
$string['location'] = 'מיקום';
$string['lookfor'] = 'חפש';
$string['manageradded'] = 'התקבלה כתובת דוא"ל של המנהל שלך.';
$string['managerchanged'] = 'עודכנה כתובת דוא"ל של המנהל שלך.';
$string['manageremail'] = 'דואר אלקטרוני של המנהל';
$string['manageremailaddress'] = 'כתובת דוא"ל של המנהל';
$string['manageremailformat'] = 'כתובת הדואר האלקטרוני צריכה להיות בפורמט \'{$a}\' כדי להתאים.';
$string['manageremailheading'] = 'כתובות דוא"ל של מנהל';
$string['manageremailinstruction'] = 'כדי להירשם למחזור הדרכה, יש לשלוח דוא"ל אישור אליך עם העתק למנהל שלך.';
$string['manageremailinstructionconfirm'] = 'אנא אשר שזו כתובת הדוא"ל של המנהל שלך:';
$string['managername'] = 'שם המנהל';
$string['managerupdated'] = 'כתובת הדוא"ל של המנהל שלך עודכנה.';
$string['maximumpoints'] = 'מספר מירבי של נקודות.';
$string['maximumsize'] = 'מספר משתתפים מירבי';
$string['message'] = 'שינוי ברישום לקורס {$a->coursename}!

התפנה מקום במחזור במועד {$a->duedate} ({$a->name}) בקורס {$a->coursename}.
בוצע לך רישום למחזור זה. אם התאריך אינו מתאים לך עוד, אנא בטל את הרישום שלך בקישור זה <a href=\'{$a->url}\'>{$a->url}</a>.';
$string['modulename'] = 'הדרכת כיתה';
$string['modulenameplural'] = 'הדרכת כיתה';
$string['moreinfo'] = 'מידע נוסף';
$string['multiday'] = 'רב-יומי';
$string['newmanageremailaddress'] = 'כתובת דוא"ל של המנהל';
$string['noactionableunapprovedrequests'] = 'אין בקשות רישום הממתינות לאישור';
$string['nocustomfields'] = '<p>לא הוגדרו שדות מותאמים אישית.</p>';
$string['nofacetofaces'] = 'אין פעילויות הדרכת כיתה';
$string['none'] = 'אין';
$string['noremindersneedtobesent'] = 'אין תזכורות לשליחה.';
$string['normalcost'] = 'עלות רגילה';
$string['nosignedupusers'] = 'אין משתמשים שנרשמו למחזור זה.';
$string['nositenotices'] = '<p>לא הוגדרו הודעות אתר.</p>';
$string['note'] = 'הערה';
$string['notefull'] = 'גם אם המחזור מלא תוכל להירשם.
תיכלל ברשימת המתנה (צבוע באדום).
אם מישהו יבטל, הראשון ברשימת ההמתנה יצורף למחזור ותישלח לו הודעה בדוא"ל.';
$string['noticedeleteconfirm'] = 'מחק הודעת אתר \'{$a->name}\'?<br/><blockquote>{$a->text}</blockquote>';
$string['noticetext'] = 'מלל ההודעה';
$string['notificationboth'] = 'הודעת דוא"ל ופגישה לאאוטלוק';
$string['notificationemail'] = 'הודעת דוא"ל בלבד';
$string['notificationical'] = 'פגישה לאאוטלוק בלבד';
$string['notificationtype'] = 'סוג ההודעה';
$string['notsignedup'] = 'אינך רשום למחזור זה.';
$string['notsubmittedyet'] = 'טרם בוצעה הערכה';
$string['noupcoming'] = '<p><i>אין מחזורים קרובים</i></p>';
$string['odsformat'] = 'OpenDocument';
$string['onehour'] = 'שעה אחת';
$string['oneminute'] = 'דקה אחת';
$string['options'] = 'אפשרויות';
$string['or'] = 'או';
$string['order'] = 'הזמן';
$string['place'] = 'חדר';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:cost'] = '[cost]';
$string['placeholder:details'] = '[details]';
$string['placeholder:duration'] = '[duration]';
$string['placeholder:facetofacename'] = '[facetofacename]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['pluginadministration'] = 'ניהול הדרכת כיתה';
$string['pluginname'] = 'הדרכת כיתה';
$string['points'] = 'נקודות';
$string['pointsplural'] = 'נקודות';
$string['potentialattendees'] = 'משתתפים פוטנציאליים';
$string['previoussessions'] = 'מחזורים קודמים';
$string['previoussessionslist'] = 'רשימת כל המחזורים הקודמים בפעילות הדרכה זו';
$string['printversionid'] = 'גרסת הדפסה: ללא שם';
$string['printversionname'] = 'גרסת הדפסה: עם שם';
$string['really'] = 'האם אתה בטוח שברצונך למחוק את כל התוצאות של מחזור הדרכה זה?';
$string['registeredon'] = 'נרשם ב:';
$string['registrations'] = 'הרשמות';
$string['reminder'] = 'תזכורת';
$string['reminderinstrmngr'] = '# הודעה למנהל';
$string['remindermessage'] = 'הודעת תזכורת';
$string['reminderperiod'] = 'כמה ימים לפני לשלוח תזכורת';
$string['requestmessage'] = 'הודעת הבקשה';
$string['requeststablesummary'] = 'אנשים המבקשים להשתתף במחזור זה.';
$string['room'] = 'חדר';
$string['saveallfeedback'] = 'שמור את כל התשובות';
$string['saveattendance'] = 'שמור נוכחות';
$string['scheduledsession'] = 'הדרכה מתוכננת';
$string['scheduledsessions'] = 'הדרכות מתוכננות';
$string['seatsavailable'] = 'מקומות פנויים';
$string['seeattendees'] = 'צפה במשתתפים';
$string['sentremindermanager'] = 'שלח דוא"ל תזכורת למנהל של המשתמש';
$string['sentreminderuser'] = 'שלח דוא"ל תזכורת למשתמש';
$string['sessiondate'] = 'תאריך המחזור הוא התאריך בו המחזור מתרחש.';
$string['sessiondatetime'] = 'מועד המחזור';
$string['sessiondatetimeknown'] = 'מועד ההדרכה ידוע';
$string['sessionfinishtime'] = 'שעת סיום המחזור';
$string['sessioninprogress'] = 'מחזור בתהליך';
$string['sessionisfull'] = 'מחזור זה מלא, עליך לבחור מועד אחר או לפנות למדריך.';
$string['sessionover'] = 'המחזור הסתיים';
$string['sessionrequiresmanagerapproval'] = 'מחזור זה דורש אישור מנהל להרשמה.';
$string['sessionroles'] = 'תפקידי המחזור';
$string['sessions'] = 'מחזורים';
$string['sessionsdetailstablesummary'] = 'תיאור מלא של המחזור הנוכחי.';
$string['sessionsoncoursepage'] = 'מספר מחזורים להצגה בעמוד הקורס';
$string['sessionstartdate'] = 'תאריך פתיחת המחזור';
$string['sessionstarttime'] = 'שעת פתיחת המחזור';
$string['sessionvenue'] = 'מיקום המחזור (בניין)';
$string['setting:addchangemanageremail'] = 'בקש מהמשתתפים את כתובת הדוא"ל של המנהל שלהם.';
$string['setting:addchangemanageremail_caption'] = 'כתובת דוא"ל של המנהל';
$string['setting:addchangemanageremaildefault'] = 'בקש מהמשתתפים את כתובת הדוא"ל של המנהל שלהם.';
$string['setting:defaultcancellationinstrmngr'] = 'תבנית הודעת ביטול השתתפות למנהלים.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'הודעת ביטול (למנהלים)';
$string['setting:defaultcancellationinstrmngrdefault'] = '*** לידיעה בלבד ****

הודעה זו נועדה ליידע אותך ש[firstname] [lastname] שציין אותך כמנהל שלו, כבר אינו רשום לקורס הבא.

*** העתק הודעת הביטול עבור [firstname] [lastname] מופיעה למטה ****';
$string['setting:defaultcancellationmessage'] = 'תבנית הודעת ביטול השתתפות למשתמש.';
$string['setting:defaultcancellationmessage_caption'] = 'הודעת ביטול';
$string['setting:defaultcancellationmessagedefault'] = 'זוהי הודעה שנועדה להודיע לך שהרישום שלך להדרכה המפורטת מטה בוטל:

***ביטול הרשמה***

המשתתף: [firstname] [lastname]
ההדרכה: [facetofacename]

משך: [duration]
מועדים:
[alldates]

מיקום: [session:location]
בניין: [session:venue]
חדר: [session:room]';
$string['setting:defaultcancellationsubject'] = 'ברירת מחדל לנושא של הודעות ביטול.';
$string['setting:defaultcancellationsubject_caption'] = 'נושא הודעת הביטול';
$string['setting:defaultcancellationsubjectdefault'] = 'ביטול רישום להדרכה';
$string['setting:defaultconfirmationinstrmngr'] = 'ברירת מחדל לנושא של הודעות אישור רישום.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'הודעת אישור רישום (למנהלים)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** לידיעה בלבד ****

הודעה זו נועדה ליידע אותך ש[firstname] [lastname] שציין אותך כמנהל שלו, נרשם להדרכה המפורטת למטה.

אם אינך המנהל הישיר שלהם, ונראה לך שקיבלת הודעה זו בטעות, אנא השב להודעה זו.
אם אתה רוצה לבחון את השתתפות העובד בהדרכה - אנא בדוק זאת ישירות מולו.

*** העתק הודעת האישור של [firstname] [lastname] מופיע מטה ****';
$string['setting:defaultconfirmationmessage'] = 'הודעת ברירת מחדל לשליחה למשתתפים.';
$string['setting:defaultconfirmationmessage_caption'] = 'הודעת אישור רישום';
$string['setting:defaultconfirmationmessagedefault'] = 'זוהי הודעה שנועדה לאשר את הרישום שלך להדרכה המפורטת מטה:

המשתתף: [firstname] [lastname]
הקורס: [facetofacename]
עלות: [cost]

משך: [duration]
מועדים:
[alldates]

מיקום: [session:location]
בניין: [session:venue]
חדר: [session:room]

*** נא להגיע כעשר דקות לפני תחילת ההדרכה ***

אם תרצה להירשם למועד אחר עליך לבטל ראשית את הרישום למועד זה, ואז להירשם למועד חדש.
כדי לבטל את הרישום, היכנס חזרה לאתר הקורסים, לעמוד של קורס זה, ובחר "בטל הרשמה" במסך המידע על ההדרכה.

[details]

הודעת תזכורת תישלח אליך [reminderperiod] ימים לפני מועד פתיחת ההדרכה.';
$string['setting:defaultconfirmationsubject'] = 'ברירת מחדל לנושא של הודעות אישור רישום.';
$string['setting:defaultconfirmationsubject_caption'] = 'נושא להודעת אישור רישום';
$string['setting:defaultconfirmationsubjectdefault'] = 'אישור רישום להדרכה: [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'ברירת מחדל להודעת תזכורת הנשלחת למנהלים.';
$string['setting:defaultreminderinstrmngr_caption'] = 'הודעת תזכורת (למנהלים)';
$string['setting:defaultreminderinstrmngrdefault'] = '*** הודעת תזכורת בלבד ****

העובד [firstname] [lastname] רשום להדרכה המפורטת, וקיבל גם הוא הודעת תזכורת בדואר אלקטרוני.

אם אינך המנהל הישיר שלהם, ונראה לך שקיבלת הודעה זו בטעות, אנא השב להודעה זו.

*** העתק הודעת התזכורת של [firstname] [lastname] מופיע למטה ****';
$string['setting:defaultremindermessage'] = 'ברירת המחדל להודעת התזכורת הנשלחת למשתתפים.';
$string['setting:defaultremindermessage_caption'] = 'הודעת תזכורת';
$string['setting:defaultremindermessagedefault'] = 'זוהי הודעת תזכורת על השתתפותך בהדרכה המפורטת מטה:

המשתתף: [firstname] [lastname]
הקורס: [facetofacename]
עלות: [cost]

משך: [duration]
מועדים:
[alldates]

מיקום: [session:location]
בניין: [session:venue]
חדר: [session:room]

*** נא להגיע כעשר דקות לפני תחילת ההדרכה ***

אם תרצה להירשם למועד אחר עליך לבטל ראשית את הרישום למועד זה, ואז להירשם למועד חדש.
כדי לבטל את הרישום, היכנס חזרה לאתר הקורסים, לעמוד של קורס זה, ובחר "בטל הרשמה" במסך המידע על ההדרכה.

[details]';
$string['setting:defaultremindersubject'] = 'ברירת מחדל לנושא של הודעת התזכורת.';
$string['setting:defaultremindersubject_caption'] = 'נושא להודעת תזכורת';
$string['setting:defaultremindersubjectdefault'] = 'תזכורת רישום להדרכה: [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestinstrmngrdefault'] = 'הודעה זו נועדה ליידע אותך ש[firstname] [lastname] ואתה רשום כמנהל שלו, ביקש להירשם להדרכה המפורטת למטה.

המשתתף: [firstname] [lastname]
הקורס: [facetofacename]
עלות: [cost]

משך: [duration]
מועדים:
[alldates]

מיקום: [session:location]
בניין: [session:venue]
חדר: [session:room]

נא ללחוץ על הקישור הבא על מנת לאשר את הבקשה:
[attendeeslink]#unapproved

*** העתק הודעת הבקשה של [firstname] [lastname] מופיע למטה ****';
$string['setting:defaultrequestmessagedefault'] = 'בקשתך להירשם להדרכה הבאה נשלחה למנהל שלך:

משתתף: [firstname] [lastname]
קורס: [facetofacename]
עלות: [cost]

משך: [duration]
מועד(ים):
[alldates]

מיקום: [session:location]
בניין: [session:venue]
חדר: [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'בקשת רישום להדרכה: [facetofacename], [starttime]-[finishtime]';
$string['setting:defaultvalue'] = 'ערך ברירת מחדל';
$string['setting:defaultwaitlistedsubject'] = 'ברירת מחדל לנושא הודעת רישום לרשימת המתנה.';
$string['setting:defaultwaitlistedsubject_caption'] = 'נושא להודעת רשימת המתנה';
$string['setting:defaultwaitlistedsubjectdefault'] = 'הנחיות לרישום לרשימת המתנה [facetofacename]';
$string['setting:fromaddress_caption'] = 'כתובת השולח:';
$string['setting:fromaddressdefault'] = 'moodle@example.com';
$string['setting:hidecost'] = 'הסתר שדות עלות וקוד הנחה.';
$string['setting:hidecost_caption'] = 'הסתר עלות והנחה:';
$string['setting:hidediscount'] = 'הסתר רק את שדה קוד הנחה.';
$string['setting:hidediscount_caption'] = 'הסתר הנחה:';
$string['setting:isfilter'] = 'הצג כמסנן';
$string['setting:oneemailperday'] = 'שלח מספר הודעות דוא"ל אם יש מספר מפגשים - אחד לכל מפגש.';
$string['setting:oneemailperday_caption'] = 'הודעה אחת ליום:';
$string['setting:possiblevalues'] = 'רשימת ערכים אפשריים';
$string['setting:sessionroles'] = 'משתמשים להם מוקצים התפקידים הבאים בקורס ניתנים למעקב בכל מחזור הדרכה';
$string['setting:sessionroles_caption'] = 'תפקידי המחזור:';
$string['setting:showinsummary'] = 'הצג בייצוא וברשימות';
$string['setting:type'] = 'סוג שדה';
$string['shortname'] = '# שם קצר';
$string['showbylocation'] = 'הצג לפי מיקום';
$string['showoncalendar'] = 'הצג בלוח השנה';
$string['signup'] = 'הרשמה';
$string['signupfor'] = 'הרשמה ל-{$a}';
$string['signupforsession'] = 'הירשם למחזור פנוי קרוב';
$string['signupforthissession'] = 'הירשם למחזור הדרכה זה';
$string['signups'] = 'הרשמות';
$string['sign-ups'] = 'הרשמות';
$string['sitenoticesheading'] = 'הודעות אתר';
$string['status'] = 'סטטוס';
$string['status_approved'] = 'מאושר';
$string['status_booked'] = 'רשום';
$string['status_declined'] = 'לא אושר';
$string['status_fully_attended'] = 'נכח באופן מלא';
$string['status_no_show'] = 'לא הופיע';
$string['status_partially_attended'] = 'נכח חלקית';
$string['status_requested'] = 'ביקש';
$string['status_session_cancelled'] = 'המחזור בוטל';
$string['status_user_cancelled'] = 'המשתמש ביטל';
$string['status_waitlisted'] = 'ברשימת המתנה';
$string['subject'] = 'שינוי ברישום לקורס {$a->coursename} ({$a->duedate})';
$string['submissions'] = 'בקשות';
$string['submit'] = 'שלח';
$string['submitted'] = 'נשלח';
$string['summary'] = 'סיכום';
$string['suppressemail'] = 'אל תשלח הודעת דוא"ל';
$string['takeattendance'] = 'רישום נוכחות';
$string['thirdpartyemailaddress'] = 'כתובת דוא"ל של האחראי(ם) על ההדרכה';
$string['thirdpartywaitlist'] = 'הודעה לאחראי על ההדרכה על רשימות ההמתנה';
$string['time'] = 'זמן';
$string['timecancelled'] = 'זמן הביטול';
$string['timedue'] = 'מועד אחרון לרישום';
$string['timefinish'] = 'זמן סיום';
$string['timerequested'] = 'זמן הבקשה';
$string['timesignedup'] = 'זמן ההרשמה';
$string['timestart'] = 'זמן התחלה';
$string['unapprovedrequests'] = 'בקשות שלא אושרו';
$string['unknowndate'] = '(תאריך לא ידוע)';
$string['unknowntime'] = '(שעה לא ידועה)';
$string['upcomingsessions'] = 'מחזורים קרובים';
$string['upcomingsessionslist'] = 'רשימת כל המחזורים הקרובים של פעילות הדרכה זו';
$string['updaterequests'] = 'עדכן בקשות';
$string['upgradeprocessinggrades'] = 'מעבד ציוני הדרכת כיתה. זה עשוי לקחת זמן מה אם יש מחזורים רבים...';
$string['usercancelledon'] = 'המשתתף ביטל ב: {$a}';
$string['userdeletedcancel'] = 'המשתמש נמחק';
$string['usernotsignedup'] = 'סטטוס: לא רשום';
$string['usersignedup'] = 'סטטוס: רשום';
$string['usersignedupon'] = 'המשתתף נרשם ב: {$a}';
$string['userwillbewaitlisted'] = 'מחזור זה מלא כעת. על ידי לחיצה על "הרשמה", תצורף לרשימת ההמתנה למחזור.';
$string['validation:needatleastonedate'] = 'עליך לספק לפחות תאריך אחד או לסמן את המחזור כמחזור לרשימת המתנה.';
$string['venue'] = 'בניין';
$string['viewallsessions'] = 'צפה בכל המחזורים';
$string['viewsubmissions'] = 'הצג בקשות רישום';
$string['wait-list'] = 'רשימת המתנה';
$string['wait-listed'] = 'ברשימת המתנה';
$string['waitlistedmessage'] = 'הודעת רשימת המתנה';
$string['xhours'] = '{$a} שעות';
$string['xminutes'] = '{$a} דקות';
$string['youarebooked'] = 'אתה רשום למחזור זה';
$string['youremailaddress'] = 'כתובת הדוא"ל שלך';
