<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'nl', branch 'MOODLE_26_STABLE'
 *
 * @package   facetoface
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = 'Voeg een nieuwe sessie toe in {$a}';
$string['addmanageremailaddress'] = 'Voeg emailadres manager toe';
$string['addmanageremailinstruction'] = 'U heeft nog geen emailadres voor een manager ingevoerd. Voer dat hier inom voor de sessie in te tekenen.';
$string['addremoveattendees'] = 'Aanwezigen toevoegen/verwijderen';
$string['addsession'] = 'Voeg een nieuwe sessie toe';
$string['addstudent'] = 'Voeg een leerling toe';
$string['alllocations'] = 'Alle locaties';
$string['allsessionsin'] = 'Alle sessies in {$a}';
$string['alreadysignedup'] = 'U heeft al ingetekend voor deze sessie.';
$string['answer'] = 'Schrijf in';
$string['answercancel'] = 'Schrijf uit';
$string['assessmentyour'] = 'Uw assessment';
$string['attendance'] = 'Aanwezigheid';
$string['attendanceinstructions'] = 'Selecteer gebruikers die de sessie bijwoonden';
$string['attendedsession'] = 'Bijgewoonde sessie';
$string['attendees'] = 'Aanwezigen';
$string['booked'] = 'Geboekt';
$string['bookingcancelled'] = 'Uw inschrijving is verwijderd';
$string['bookingcompleted'] = 'Uw inschrijving is compleet';
$string['bookingfull'] = 'Inschrijving vol';
$string['bookingopen'] = 'Inschrijving geopend';
$string['bookingstatus'] = 'U bent geboekt voor de volgende sessie';
$string['calendareventdescriptionbooking'] = 'U bent ingeschreven voor deze<a href="{$a}">afspraak</a>.';
$string['calendareventdescriptionsession'] = 'U heeft deze <a href="{$a}">afspraak aangemaakt</a>.';
$string['cancelbooking'] = 'Verwijder boeking';
$string['cancelbookingfor'] = 'Verwijder boeking voor {$a}';
$string['cancellation'] = 'Verwijdering';
$string['cancellationconfirm'] = 'Weet u zeker dat u uw reservering voor deze sessie wilt verwijderen?';
$string['cancellationmessage'] = 'Bericht van verwijderen boeking';
$string['cancellations'] = 'Opzeggingen';
$string['cancellationsent'] = 'U zou een bevestigingsbericht van uw opzegging moeten ontvangen in uW mailbox';
$string['cancellationsentmgr'] = 'U en de sessieleider zouden een bevestigingsbericht van uw opzegging moeten ontvangen via de mail';
$string['capacity'] = 'Aantal plaatsen';
$string['changemanageremailaddress'] = 'Wijzig emailadres sessieleider';
$string['changemanageremailinstruction'] = 'Vul hier het emailadres van de sessieleider in';
$string['clearall'] = 'Maak alle velden leeg';
$string['closed'] = 'Gesloten';
$string['confirm'] = 'Bevestig';
$string['confirmanager'] = 'Bevestig het emailadres van de sessieleider';
$string['confirmation'] = 'Bevestiging';
$string['confirmationmessage'] = 'Bevestigingsmelding';
$string['confirmationsent'] = 'U krijgt een bevestigingsbericht per email';
$string['confirmationsentmgr'] = 'U en de sessieleider ontvangen een bevestiging per email';
$string['confirmmanageremailaddress'] = 'Bevestig emailadres van de sessieleider';
$string['confirmmanageremailaddressquestion'] = 'is <b>{$a}</b> inderdaad het emailadres van de sessieleider?';
$string['confirmmanageremailinstruction1'] = 'U heeft het volgende emailadres ingevoerd:';
$string['confirmmanageremailinstruction2'] = 'Is dit inderdaad het emailadres van de sessieleider?';
$string['copyingsession'] = 'Kopieren als nieuwe sessie in {$a}';
$string['copysession'] = 'Kopieer';
$string['cost'] = 'Kosten';
$string['date'] = 'Datum';
$string['dateadd'] = 'Voeg een nieuwe datum toe';
$string['dateremove'] = 'Verwijder deze datum';
$string['datetext'] = 'U heeft zich ingeschreven voor deze datum';
$string['deleteall'] = 'Verwijder alle';
$string['deletesession'] = 'Verwijder sessie';
$string['deletesessionconfirm'] = 'Wet u zeker dat u deze sessie en alle intekeningen daarvoor wilt verwijderen?';
$string['deletingsession'] = 'Verwijderen van sessie in {$a}';
$string['description'] = 'Introductietekst';
$string['details'] = 'Details';
$string['discountcode'] = 'Kortingscode';
$string['discountcost'] = 'Kortingsprijs';
$string['due'] = 'te voldoen';
$string['duration'] = 'Duur';
$string['early'] = '{$a} vroeg';
$string['editingsession'] = 'Bewerken van sessie in {$a}';
$string['editsession'] = 'Bewerk sessie';
$string['email:instrmngr'] = 'Bericht voor afspraakleider';
$string['emailmanager'] = 'Stuur bericht naar afspraakleider';
$string['email:message'] = 'Bericht';
$string['email:subject'] = 'Onderwerp';
$string['emptylocation'] = 'Plaats is leeg';
$string['error:addalreadysignedupattendee'] = '{$a} is al aangemeld voor deze afspraak.';
$string['error:addattendee'] = 'Kon {$a} niet aan de sessie toevoegen.';
$string['error:cancelbooking'] = 'Er was een probleem bij het opzeggen van uw reservering';
$string['error:cannotemailmanager'] = 'Herinneringsmail voor inschrijving id {$a->submissionid} aan gebruiker $->userid is verstuurd, maar het bericht kon niet worden afgeleverd bij de afspraakleider ({$a->manageremail}).';
$string['error:cannotemailuser'] = 'Kon het bericht van intekening niet versturen naar {$a->submissionid} aan gebruiker {$a->userid} ({$a->useremail}).';
$string['error:cannotsendconfirmationmanager'] = 'Een bevestigingsbericht is verstuurd naar u emailadres, maar er was een probleem met het verzenden van een kopie van het bericht naar de afspraakmanager';
$string['error:cannotsendconfirmationthirdparty'] = 'Een bevestigingsbericht is verstuurd naar u emailadres en dat van de afspraakmanager, maar er was een probleem met het verzenden van een kopie van het bericht naar de andere emailadres(sen)';
$string['error:cannotsendconfirmationuser'] = 'Er was een probleem om het bevestigingsbericht naar u emailadres te versturen';
$string['error:cannotsendconfirmationusermanager'] = 'Bevestigingsbericht kon niet per mail verzonden worden';
$string['error:couldnotaddsession'] = 'Kon geen sessie toevoegen';
$string['error:couldnotcopysession'] = 'Kon geen sessie kopiëren';
$string['error:couldnotdeletesession'] = 'Kon sessie niet verwijderen';
$string['error:couldnotupdatemanageremail'] = 'Kon emailadres niet bijwerken';
$string['error:couldnotupdatesession'] = 'Kon sessie niet bijwerken';
$string['error:coursemisconfigured'] = 'Afspraak is niet goed geconfigureerd';
$string['error:cronprefix'] = 'Error;  facetoface cron:';
$string['error:emptylocation'] = 'Locatie was leeg';
$string['error:emptymanageremail'] = 'Managers emailadres is leeg';
$string['error:emptyvenue'] = 'Ruimte/lokaal was leeg';
$string['error:enrolmentfailed'] = 'Kon {$a} niet bij de cursus inschrijven.';
$string['error:incorrectcoursemodule'] = 'Cursusmodule is onjuist';
$string['error:incorrectcoursemoduleid'] = 'Cursus ID is onjuist';
$string['error:incorrectcoursemodulesession'] = 'Afspraaksessie was onjuist';
$string['error:incorrectfacetofaceid'] = 'afspraak ID was onjuist';
$string['error:invaliduserid'] = 'GebruikersID onbekend';
$string['error:mustspecifycoursemodulefacetoface'] = 'U moet een cursusmodule of afspraak ID opgeven';
$string['error:nomanageremail'] = 'U heeft geen emailadres voor de afspraakmanager ingevoegd';
$string['error:problemsigningup'] = 'Er was een probleem met uw aanmelding';
$string['error:removeattendee'] = 'Kon {$a} niet uit de sessie verwijderen.';
$string['export'] = 'Exporteer';
$string['facetoface'] = 'Afspraak';
$string['facetoface:addattendees'] = 'Aanwezigen toevoegen';
$string['facetofacebooking'] = 'Afspraakreservering';
$string['facetoface:editsessions'] = 'Bewerk, kopieer, verwijder of voeg afspraken toe';
$string['facetofacename'] = 'Naam van de afspraak';
$string['facetoface:removeattendees'] = 'Aanwezigen verwijderen';
$string['facetofacesession'] = 'Afspraak/sessie';
$string['facetoface:signup'] = 'Teken in voor een afspraak';
$string['facetoface:takeattendance'] = 'Neem aanwezigheid op';
$string['facetoface:view'] = 'Bekijk afspraken en sessies';
$string['facetoface:viewattendees'] = 'Bekijk de lijst van aanwezigen';
$string['facetoface:viewcancellations'] = 'Bekijk opzeggingen';
$string['facetoface:viewemptyactivities'] = 'Bekijk lege afspraken';
$string['feedback'] = 'Feedback';
$string['feedbackupdated'] = 'Feedback bijgewerkt voor {$a} personen';
$string['floor'] = 'Verdieping';
$string['full'] = 'Datum is bezet';
$string['goback'] = 'Ga terug';
$string['import'] = 'Importeer';
$string['info'] = 'Info';
$string['late'] = '{$a} te laat';
$string['location'] = 'Locatie';
$string['lookfor'] = 'Zoek';
$string['manageradded'] = 'Het emailadres is geaccepteerd';
$string['managerchanged'] = 'Het emailadres is gewijzigd';
$string['manageremail'] = 'emailadres afspraakleider';
$string['manageremailaddress'] = 'emailadres afspraakleider';
$string['manageremailformat'] = 'Het emailadres moet zijn als {$a} om geaccepteerd te worden';
$string['manageremailinstruction'] = 'Om in te tekenen moet er een bevestigingsmail naar uw adres en dat van de afspraakleider gestuurd worden';
$string['manageremailinstructionconfirm'] = 'Bevestig het emailadres van de afspraakleider';
$string['managername'] = 'Naam afspraakleider';
$string['managerupdated'] = 'Het emailadres van de afspraakleider is bijgewerkt';
$string['maximumpoints'] = 'Maximum punten';
$string['maximumsize'] = 'Maximum aantal deelnemers';
$string['message'] = 'Verandering in de boeking van {$a->coursename}!

Er is een plaats vrijgekomen voor {$a->duedate} ({$a->name}) voor de afspraak {$a->coursename}.

U bent voor deze datum ingeschreven. Als u dan verhindert bent, kunt u zich uitschrijven bij <a href=\'{$a->url}\'>{$a->url}</a>';
$string['modulename'] = 'Afspraak';
$string['modulenameplural'] = 'Afspraken';
$string['moreinfo'] = 'Meer info';
$string['multiday'] = 'Meerdere dagen';
$string['newmanageremailaddress'] = 'emaildres afspraakleider';
$string['nofacetofaces'] = 'Er zijn geen afspraken';
$string['none'] = 'Geen';
$string['noremindersneedtobesent'] = 'Er hoeven geen herinneringen verstuurd te worden';
$string['normalcost'] = 'Normale kosten';
$string['nosignedupusers'] = 'Geen deelnemers hebben zich ingeschreven';
$string['note'] = 'Notitie';
$string['notefull'] = 'Zelfs als de afspraak volgeboekt is, kunt u zich wel aanmelden. U komt dan op de wachtlijst (in het rood weergegeven). Als er een plaats vrijkomt wordt die automatisch uit de wachtlijst opgevuld. Als u geplaatst wordt, krijgt u daar bericht van.';
$string['notificationboth'] = 'Email bericht en iCalendar Gebeurtenis';
$string['notificationemail'] = 'Alleen Email bericht';
$string['notificationical'] = 'Alleen iCalendar gebeurtenis';
$string['notificationtype'] = 'Type bericht';
$string['notsubmittedyet'] = 'Nog niet ge-evalueerd';
$string['noupcoming'] = 'Geen geplande sessies';
$string['onehour'] = '1 uur';
$string['oneminute'] = '1 minuut';
$string['options'] = 'Opties';
$string['or'] = 'of';
$string['order'] = 'Bestel';
$string['place'] = 'Kamer';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:cost'] = '[cost]';
$string['placeholder:details'] = '[details]';
$string['placeholder:duration'] = '[duration]';
$string['placeholder:facetofacename'] = '[facetofacename]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['points'] = 'Punten';
$string['pointsplural'] = 'Punten';
$string['previoussessions'] = 'Eerdere afspraken';
$string['printversionid'] = 'Printversie zonder naam';
$string['printversionname'] = 'Printversie met naam';
$string['really'] = 'Weet u zeker dat u alle resultaten wilt verwijderen';
$string['registeredon'] = 'Geregistreerd op';
$string['registrations'] = 'Registraties';
$string['reminder'] = 'Herinnering';
$string['remindermessage'] = 'Herinneringsboodschap';
$string['reminderperiod'] = 'Aantal dagen voordat een boodschap wordt verstuurd';
$string['room'] = 'Kamer';
$string['saveallfeedback'] = 'Bewaar alle antwoorden';
$string['saveattendance'] = 'Bewaar aanwezigheid';
$string['scheduledsession'] = 'Ingeroosterde afspraak';
$string['scheduledsessions'] = 'Ingeroosterde afspraken';
$string['seatsavailable'] = 'Open plaatsen';
$string['seeattendees'] = 'Bekijk intekeningen';
$string['sentremindermanager'] = 'Stuur herinneringsmail naar beheerder';
$string['sentreminderuser'] = 'Stuur herinneringsmail naar gebruiker';
$string['sessiondate'] = 'Sessie datum';
$string['sessiondatetime'] = 'Sessie datum/tijd';
$string['sessiondatetimeknown'] = 'Sessie datum/tijd bekend';
$string['sessionfinishtime'] = 'Eindtijd sessie';
$string['sessionover'] = 'Sessie over';
$string['sessions'] = 'Sessies';
$string['sessionsoncoursepage'] = 'Sessie getoond op cursuspagina';
$string['sessionstartdate'] = 'Startdatum sessie';
$string['sessionstarttime'] = 'Begintijd sessie';
$string['sessionvenue'] = 'Ruimte/lokaal sessie';
$string['setting:addchangemanageremail'] = 'Vraag gebruikers om het emailadres van de afspraakmanager';
$string['setting:defaultcancellationinstrmngr'] = 'Standaard kennisgeving van afzegging naar de afspraakleider gestuurd.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'Bericht van verwijderen boeking (afspraakleider)';
$string['setting:defaultcancellationinstrmngrdefault'] = '***Ter kennisname***

Dit is een bevestiging dat [firstname][lastname] de volgende cursus heeft afgemeld en u heeft opgegeven als hun teamleider.

***[firstname][lastname]\'s opzegging is hieronder weergegeven ***';
$string['setting:defaultcancellationmessage'] = 'Standaard kennisgeving van afzegging naar de deelnemer gestuurd.';
$string['setting:defaultcancellationmessage_caption'] = 'Bericht van verwijderen boeking';
$string['setting:defaultcancellationmessagedefault'] = 'Dit is een kennisgeving van het opzeggen van de boeking voor de volgende afspraak:

***BOEKING GEANNULEERD***

Deelnemer: [firstname][lastname]
Afspraak: [facetofacename]

Tijdsduur: [duration]
Data: [alldates]

Locatie: [session:location]
Ruimte/lokaal: [session:venue]
Kamer: [session:room]';
$string['setting:defaultcancellationsubject'] = 'Standaard onderwerp voor afzeggingsemails.';
$string['setting:defaultcancellationsubject_caption'] = 'Onderwerp afzegging';
$string['setting:defaultcancellationsubjectdefault'] = 'Opzegging';
$string['setting:defaultconfirmationinstrmngr'] = 'Standaard bevestigingsbericht gestuurd naar afspraakleiders.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Bevestigingsmelding (afspraakleider)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** Kennisgeving***

Dit is een kennisgeving dat [firstname][lastname] zich heeft ingeschreven voor de volgende afspraak en u als teamleider heeft geselecteerd.

Als u dit bericht ten onrechte ontvangt, stuur dit bericht dan terug.

*** [fistname] [lastname]\'s inschrijving wordt hieronder weergegeven ***';
$string['setting:defaultconfirmationmessage'] = 'Standaard bevestigingsbericht gestuurd naar deelnemers.';
$string['setting:defaultconfirmationmessage_caption'] = 'Bevestigingsmelding';
$string['setting:defaultconfirmationmessagedefault'] = 'Dit is een kennisgeving van het bevestigen van de boeking voor de volgende afspraak:

Deelnemer: [firstname][lastname]
Afspraak: [facetofacename]
kosten: [cost]

Tijdsduur: [duration]
Data: [alldates]

Locatie: [session:location]
Ruimte/lokaal: [session:venue]
Kamer: [session:room]

*** probeer ervoor te zorgen op tijd aanwezig te zijn***

[details]

U zult een herinnering van deze afspraak [reminderperiod] ontvangen voor aanvang van de afspraak.';
$string['setting:defaultconfirmationsubject'] = 'Standaard onderwerp voor bevestigingsberichten.';
$string['setting:defaultconfirmationsubject_caption'] = 'Onderwerp van bevestiging';
$string['setting:defaultconfirmationsubjectdefault'] = 'Boekingsbevestiging: [facetofacename],[starttime]-[finishtime][sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'Standaard herinneringsboodschap gestuurd naar afspraakleiders.';
$string['setting:defaultreminderinstrmngr_caption'] = 'Herinneringsboodschap (afspraakleider)';
$string['setting:defaultreminderinstrmngrdefault'] = '***Herinnering***

Uw collega [firstname] [lastname] is bij de volgende afspraak geplaatst en heeft een herinneringsmail ontvangen.

Als u dit bericht ten onrechte heeft ontvangen, stuur deze mail dan terug.

***[firstname] [lastname]\'s herinnering is hieronder weergegeven***';
$string['setting:defaultremindermessage'] = 'Standaard herinneringsboodschap gestuurd naar deelnemers.';
$string['setting:defaultremindermessage_caption'] = 'Herinneringsboodschap';
$string['setting:defaultremindermessagedefault'] = 'Dit is een herinnering dat u geboekt bent voor de volgende afspraak:

Deelnemer: [firstname] [lastname]
Afspraak: [facetofacename]
Kosten:  [cost]

Duur: [duration]
Data:
[alldates]

Locatie: [session:location]
Ruimte/lokaal: [session:venue]
Locatie: [session:room]

*** Zorg er altublieft voor op tijd aanwezig te zijn***

[details';
$string['setting:defaultremindersubject'] = 'Standaard onderwerp voor herinneringsboodschappen.';
$string['setting:defaultremindersubject_caption'] = 'Onderwerp herinneringsboodschap';
$string['setting:defaultremindersubjectdefault'] = 'Afspraakbevestiging-herinnering: [facetofacename],[starttime]-[finishtime],[sessiondate]';
$string['setting:defaultwaitlistedmessage'] = 'Standaard wachtlijst-boodschap gestuurd naar deelnemers.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Wachtlijst boodschap';
$string['setting:defaultwaitlistedmessagedefault'] = 'U bent op de wachtlijst geplaatst voor:

Afspraak: [facetofacename]
Plaats: [session:location]
Deelnemer: [firstname][lastname]

***Dit is geen bevestiging van inschrijving!***

Als deze afspraak beschikbaar komt, zult u er van op de hoogte worden gesteld.';
$string['setting:defaultwaitlistedsubject'] = 'Standaard onderwerp voor wachtlijst-boodschappen.';
$string['setting:defaultwaitlistedsubject_caption'] = 'Onderwerp wachtlijst';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Wachtlijst voor [facetofacename]';
$string['setting:disableicalcancel'] = 'Schakel Opzeggingsberichten met iCalendar bijlages uit.';
$string['setting:disableicalcancel_caption'] = 'Schakel iCalendar opzeggingen uit:';
$string['setting:fromaddress'] = 'Wat zal zichtbaar zijn in het afzenderveld van emails die door deze module wordt verstuurd?';
$string['setting:fromaddressdefault'] = 'moodle@example.com';
$string['setting:manageraddressformat'] = 'Element dat in het emailadres van de afspraakmanager moet voorkomen, voor het adres geaccepteerd wordt';
$string['setting:manageraddressformatdefault'] = 'Email afspraakleider';
$string['setting:manageraddressformatreadable'] = 'Korte beschrijving van de beperkingen van het emailadres van de afspraakmanager';
$string['setting:manageraddressformatreadabledefault'] = 'firstname.lastname@company.com';
$string['setting:oneemailperday'] = 'Stuur meerdere bevestigingsberichten voor meerdaagse gebeurtenissen.';
$string['setting:oneemailperday_caption'] = 'Één bericht per dag:';
$string['showbylocation'] = 'Sorteer op locatie';
$string['signup'] = 'Intekening';
$string['signupfor'] = 'Teken in voor {$a}';
$string['signupforsession'] = 'Teken in voor een beschikbare sessie';
$string['sign-ups'] = 'Intekeningen';
$string['status'] = 'Status';
$string['subject'] = 'Verandering in intekening van {$a->coursename} ({$a->duedate})';
$string['submissions'] = 'Intekeningen';
$string['submit'] = 'Intekenen';
$string['submitted'] = 'Ingetekend';
$string['summary'] = 'Samenvatting';
$string['suppressemail'] = 'Onderdruk bevestigingen per email';
$string['takeattendance'] = 'Neem aanwezigheid op';
$string['thirdpartyemailaddress'] = 'Alternatief emailadres';
$string['thirdpartywaitlist'] = 'Stuur een bericht over sessies op de wachtlijst aan derden';
$string['time'] = 'Tijd';
$string['timecancelled'] = 'Tijd opzegging';
$string['timedue'] = 'Einde registratie';
$string['timefinish'] = 'Eindtijd';
$string['timesignedup'] = 'Tijd van intekening';
$string['timestart'] = 'Begintijd';
$string['unknowndate'] = '(datum onbekend)';
$string['unknowntime'] = '(tijd onbekend)';
$string['upcomingsessions'] = 'Aankomende sessies';
$string['usercancelledon'] = 'Gebruiker heeft afgezegd op {$a}';
$string['usernotsignedup'] = 'Status: niet ingetekend';
$string['usersignedup'] = 'Status: ingetekend';
$string['usersignedupon'] = 'Gebruiker heeft ingetekend op {$a}';
$string['venue'] = 'Ruimte/lokaal';
$string['viewallsessions'] = 'Bekijk alle sessies';
$string['viewsubmissions'] = 'Bekijk intekeningen';
$string['wait-list'] = 'Wachtlijst';
$string['wait-listed'] = 'Op wachtlijst geplaatst';
$string['waitlistedmessage'] = 'Wachtlijst boodschap';
$string['xhours'] = '{$a} uren';
$string['xminutes'] = '{$a} minuten';
$string['youarebooked'] = 'U bent geboekt voor de volgende sessie';
$string['youremailaddress'] = 'Uw emailadres';
