<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   webservice
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Изузетак контроле приступа';
$string['actwebserviceshhdr'] = 'Активни протоколи веб сервиса';
$string['addaservice'] = 'Додај сервис';
$string['addcapabilitytousers'] = 'Провери способности корисника';
$string['addcapabilitytousersdescription'] = 'Корисници треба да имају две способности - webservice:createtoken и способност која одговара протоколу који се користи, нпр. webservice/rest:use, webservice/soap:use. Да бисте то постигли креирајте улогу за веб сервис са допуштеним одговорајућим способностима и доделите је кориснику веб сервиса као системску улогу.';
$string['addfunction'] = 'Додај функцију';
$string['addfunctionhelp'] = 'Изаберите функцију коју желите да додате сервису.';
$string['addfunctions'] = 'Додај функције';
$string['addfunctionsdescription'] = 'Изабери неопходне функције за новокреирани сервис';
$string['addrequiredcapability'] = 'Додели/уклони потребну способност';
$string['addservice'] = 'Додај нови сервис: {$a->name} (id: {$a->id})';
$string['addservicefunction'] = 'Додај функције сервису "{$a}"';
$string['allusers'] = 'Сви корисници';
$string['amftestclient'] = 'AMF тест клијент';
$string['apiexplorer'] = 'API истраживач';
$string['apiexplorernotavalaible'] = 'API истраживач још није доступан.';
$string['arguments'] = 'Аргументи';
$string['authmethod'] = 'Начин провере идентитета';
$string['cannotcreatetoken'] = 'Нема дозвола за креирање токена веб сервиса за сервис {$a}.';
$string['cannotgetcoursecontents'] = 'Није могуће добити садржај курсева';
$string['checkusercapability'] = 'Провери способности корисника';
$string['checkusercapabilitydescription'] = 'Корисник треба да има одговорајуће способности сходно протоколу који се користи, нпр. webservice/rest:use, webservice/soap:use. Да бисте то постигли креирајте улогу за веб сервис са допуштеним способностима за извршење протокола и доделите је кориснику веб сервиса као системску улогу.';
$string['configwebserviceplugins'] = 'Из разлога безбедности треба да буду укључени само протоколи који се користе.';
$string['context'] = 'Контекст';
$string['createservicedescription'] = 'Сервис представља скуп функција веб сервиса. Да би корисник могу да приступу новом сервису дозволићете његову употребу. На страници <strong>Додај сервис </strong> означите опције   Омогући\' и \'Ауторизовани корисник\'. Изаберите и \'Нема захтеване способности\'.';
$string['createserviceforusersdescription'] = 'Сервис представља скуп функција веб сервиса. Да би корисник могу да приступу новом сервису дозволићете његову употребу. На страници <strong>Додај сервис </strong> означите опције Омогући\' и уклоните ознаку са опције \'Ауторизовани корисник\'. Изаберите и \'Нема захтеване способности\'.';
$string['createtoken'] = 'Креирај токен';
$string['createtokenforuser'] = 'Креирај токен за корисника';
$string['createtokenforuserdescription'] = 'Креирај токен за корисника веб сервиса';
$string['createuser'] = 'Креирај специфичног корисника';
$string['createuserdescription'] = 'Корисник веб сервиса је неопходан како би представљао систем који контролише Moodle.';
$string['criteriaerror'] = 'Недостају дозволе за претрагу према критеријуму.';
$string['default'] = 'Подразумевано за "{$a}"';
$string['deleteaservice'] = 'Обриши сервис';
$string['deleteservice'] = 'Обриши сервис: {$a->name} (id: {$a->id})';
$string['deleteserviceconfirm'] = 'Брисањем сервиса биће такође обрисан токени који се односе на тај сервис. Да ли стварно желите да обришете спољни сервис "{$a}"?';
$string['deletetokenconfirm'] = 'Да ли стварно желите да обришете овај токен веб сервиса за <strong>{$a->user}</strong> на сервис <strong>{$a->service}</strong>?';
$string['disabledwarning'] = 'Сви протоколи веб сервиса су онемогућени. Подешавање "Омогући веб сервисе" можете наћи међу напредним функцијама.';
$string['doc'] = 'Документација';
$string['docaccessrefused'] = 'Није Вам дозвољено да видите документацију за овај токен';
$string['documentation'] = 'документација веб сервиса';
$string['downloadfiles'] = 'Могуће је преузимање датотека';
$string['downloadfiles_help'] = 'Ако је ова опција омогућена, било који корисник може да преузме датотеке са њиховим безбедносним кључевима. Наравно, ово се односи само на оне датотеке на сајту за које постоји дозвола за преузимање.';
$string['editaservice'] = 'Уреди сервис';
$string['editservice'] = 'Уреди сервис: {$a->name} (id: {$a->id})';
$string['enabled'] = 'Омогућено';
$string['enabledocumentation'] = 'Омогући документацију за развојне програмере';
$string['enabledocumentationdescription'] = 'Детаљна документација веб сервиса је доступна за омогућене протоколе.';
$string['enablemobilewsoverview'] = 'Идите на {$a->manageservicelink} страницу за администрацију, проверите подешавање "{$a->enablemobileservice}" и сачувајте. Све ће бити подешено за вас и сви корисници сајта ће моћи да користе званичну Moodle аплокацију. Тренутни статус: {$a->wsmobilestatus}';
$string['enableprotocols'] = 'Омогући протоколе';
$string['enableprotocolsdescription'] = 'Најмање један протокол мора бити укључен. Из разлога безбедности, треба омогућите само оне протоколе који ће се користити.';
$string['enablews'] = 'Омогући веб сервисе';
$string['enablewsdescription'] = 'Веб сервиси морају да буду омогућени у напредним функцијама.';
$string['entertoken'] = 'Унесите безбедносни кључ (токен)';
$string['error'] = 'Грешка: {$a}';
$string['errorcatcontextnotvalid'] = 'Не можете да извршите функцију у контексту категорије (category id:{$a->catid}). Порука о грешци контекста гласи: {$a->message}';
$string['errorcodes'] = 'Порука о грешци';
$string['errorcoursecontextnotvalid'] = 'Не можете да извршите функцију у контексту курса (course id:{$a->courseid}). Порука о грешци контекста гласи: {$a->message}';
$string['errorinvalidparam'] = 'Параметар "{$a}" није исправан.';
$string['errornotemptydefaultparamarray'] = 'Параметар описа веб сервиса који се назива \'{$a}\' је једноставна или вишеструка структура. Подразумевана вредност је да он може бити само празан низ. Проверите опис веб сервиса.';
$string['erroroptionalparamarray'] = 'Параметар описа веб сервиса који се назива \'{$a}\' је једноставна или вишеструка структура. Не може бити подешен као VALUE_OPTIONAL. Проверите опис веб сервиса.';
$string['event_webservice_function_called'] = 'Функција веб сервиса позвана';
$string['event_webservice_login_failed'] = 'Пријава веб сервиса није успела';
$string['event_webservice_service_created'] = 'Сервис веб сервиса креиран';
$string['event_webservice_service_updated'] = 'Сервис веб сервиса ажуриран';
$string['event_webservice_service_user_added'] = 'Корисник веб сервиса додат';
$string['event_webservice_service_user_removed'] = 'Корисник веб сервиса уклоњен';
$string['event_webservice_token_created'] = 'Жетон веб сервиса креиран';
$string['event_webservice_token_sent'] = 'Жетон веб сервиса послат';
$string['execute'] = 'Изврши';
$string['executewarnign'] = 'УПОЗОРЕЊЕ: Ако покренете извршавање Ваша база података ће бити измењена а промене не могу бити аутоматски поништене!';
$string['externalservice'] = 'Спољни сервис';
$string['externalservicefunctions'] = 'Функције спољног сервиса';
$string['externalservices'] = 'Спољни сервиси';
$string['externalserviceusers'] = 'Корисници спољног сервиса';
$string['failedtolog'] = 'Неуспешна пријава';
$string['filenameexist'] = 'Назив датотеке већ постоји: {$a}';
$string['forbiddenwsuser'] = 'Није могуће креирати токен за непотврђеног, обрисаног, суспендованог или корисника у улози госта.';
$string['function'] = 'Функција';
$string['functions'] = 'Функције';
$string['generalstructure'] = 'Општа структура';
$string['information'] = 'Информација';
$string['installexistingserviceshortnameerror'] = 'Веб сервис са скраћеним називом "{$a}" већ постоји. Није могуће инсталирати/ажурирати различите веб сервиса са овим скраћеним називом.';
$string['installserviceshortnameerror'] = 'Програмска грешка: скраћени назив сервиса "{$a}" треба да садржи само бројеве, слова и _-..';
$string['invalidextparam'] = 'Неисправан параметар спољног API-ја: {$a}';
$string['invalidextresponse'] = 'Неисправан одговор спољног API-ја: {$a}';
$string['invalidiptoken'] = 'Неисправан токен - Ваша IP адреса није подржана';
$string['invalidtimedtoken'] = 'Неисправан токен - токен је истекао';
$string['invalidtoken'] = 'Неисправан токен - токен није пронађен';
$string['iprestriction'] = 'IP ограничење';
$string['iprestriction_help'] = 'Корисник ће морати да позове веб сервис са неке од наведених IP адреса (раздвојених зарезима).';
$string['key'] = 'Кључ';
$string['keyshelp'] = 'Кључеви се користе за приступ Вашем Moodle корисничком налогу из спољних апликација.';
$string['manageprotocols'] = 'Управљање протоколима';
$string['managetokens'] = 'Управљање токенима';
$string['missingcaps'] = 'Недостају способности';
$string['missingcaps_help'] = 'Списак неопходних способности за сервис, које изабрани корисник нема. Способности које недостају морају бити додате корисниковој улози како би он могао да користи тај сервис.';
$string['missingpassword'] = 'Недостаје лозинка';
$string['missingrequiredcapability'] = 'Могућност {$a} је неопходна.';
$string['missingusername'] = 'Недостаје корисничко име';
$string['missingversionfile'] = 'Програмска грешка: недостаје датотека version.php за компоненту {$a}';
$string['mobilewsdisabled'] = 'Онемогућено';
$string['mobilewsenabled'] = 'Омогућено';
$string['nocapabilitytouseparameter'] = 'Корисник нема потребну способност да би користио параметар {$a}';
$string['nofunctions'] = 'Овај сервис нема функције.';
$string['norequiredcapability'] = 'Нема потребних способности';
$string['notoken'] = 'Списак токена је празан.';
$string['onesystemcontrolling'] = 'Дозволи спољњем систему да контролише Moodle';
$string['onesystemcontrollingdescription'] = 'Следећи кораци вам помажу да подесите Moodle веб сервис као систем који контролише Moodle. Ово укључује подешавање токена (безбедносног кључа)  као метода за проверу идентитета.';
$string['operation'] = 'Операција';
$string['optional'] = 'Опционо';
$string['passwordisexpired'] = 'Лозинка је истекла';
$string['phpparam'] = 'XML-RPC (PHP структура)';
$string['phpresponse'] = 'XML-RPC (PHP структура)';
$string['postrestparam'] = 'PHP код за REST (POST захтев)';
$string['potusers'] = 'Нема ауторизованих корисника';
$string['potusersmatching'] = 'Ниједан овлашћени корисник не одговара';
$string['print'] = 'Штампај све';
$string['protocol'] = 'Протокол';
$string['removefunction'] = 'Уклони';
$string['removefunctionconfirm'] = 'Да ли стварно желите да уклоните функцију "{$a->function}" из сервиса "{$a->service}"?';
$string['requireauthentication'] = 'Овај метод захтева проверу идентитета са xxx овлашћењем.';
$string['required'] = 'Обавезно';
$string['requiredcapability'] = 'Потребна способност';
$string['requiredcapability_help'] = 'Ако је подешено, сервису ће моћи да приступе само корисници са потребним способностима.';
$string['requiredcaps'] = 'Потребне способности';
$string['resettokenconfirm'] = 'Да ли стварно желите да ресетујете овај кључ веб сервиса за корисника: <strong>{$a->user}</strong>, на сервису: <strong>{$a->service}</strong>?';
$string['resettokenconfirmsimple'] = 'Да ли стварно желите да ресетујете овај кључ? Било који сачувани линк који садржи стари кључ неће више радити.';
$string['response'] = 'Одговор';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST';
$string['restoredaccountresetpassword'] = 'Пре добијања токена за обновљени кориснички налог неопходно је ресетовање лозинке.';
$string['restparam'] = 'REST (POST параметри)';
$string['restrictedusers'] = 'Само ауторизовани корисници';
$string['restrictedusers_help'] = 'Ово подешавање одређује да ли ће корисници са овлашћењем да креирају токен веб сервиса, моћи да генеришу токен за овај веб сервис преко својих страница са сигурносним кључем или ће то моћи да ураде само овлашћени, ауторизовани корисници.';
$string['securitykey'] = 'Безбедносни кључ (токен)';
$string['securitykeys'] = 'Безбедносни кључеви';
$string['selectauthorisedusers'] = 'Изабери ауторизоване кориснике';
$string['selectedcapability'] = 'Изабране способности';
$string['selectedcapabilitydoesntexit'] = 'Тренутно подешена потребна способност ({$a}) више не постоји. Промените је и сачувајте промене.';
$string['selectservice'] = 'Изабери сервис';
$string['selectspecificuser'] = 'Изабери одређеног корисника';
$string['selectspecificuserdescription'] = 'Додај корисника веб сервиса као овлашћеног корисника';
$string['service'] = 'Сервис';
$string['servicehelpexplanation'] = 'Сервис представља скуп фунцкија. Сервису могу приступити сви или само одређени корисници.';
$string['servicename'] = 'Назив сервиса';
$string['servicenotavailable'] = 'Веб сервис није доступан (не постоји или је можда онемогућен)';
$string['servicesbuiltin'] = 'Уграђени сервиси';
$string['servicescustom'] = 'Прилагођени сервиси';
$string['serviceusers'] = 'Ауторизовани корисници';
$string['serviceusersettings'] = 'Корисничка подешавања';
$string['serviceusersmatching'] = 'Ауторизовани корисници се поклапају';
$string['serviceuserssettings'] = 'Промени подешавања за ауторизоване кориснике';
$string['simpleauthlog'] = 'Пријава помоћу једноставне провере идентитета';
$string['step'] = 'Корак';
$string['supplyinfo'] = 'Више детаља';
$string['testauserwithtestclientdescription'] = 'Симулирајте спољни приступ сервису користећи пробни клијент веб сервиса. Пре тога, пријавите се као корисник који има способност moodle/webservice:createtoken и преузмите безбедносни кључ на одговарајућој страници у оквиру \'Подешавања мог профила\'. Овај токен ћете користити у пробном клијенту. У клијенту, такође, одаберите омогућени протокол са токеном за проверу иденитета. <strong>УПОЗОРЊЕ: функције које тестирате БИЋЕ ИЗВРШЕНЕ за овог корисника, па будите пажљиви приликом избора онога што желите да тестирате!</strong>';
$string['testclient'] = 'Тест клијент веб сервиса';
$string['testclientdescription'] = '* Пробни клијент веб сервиса <strong>извршава</strong> функције <strong>СТВАРНО</strong>. Немојте да тестирате функције које не познајете. <br/>
* Све постојеће функције веб сервиса нису још имплементиране у пробном клијенту. <br/>
* Како бисте проверили да корисник не може да приступи неким функцијама можете да тестирате функције које нисте одобрили.<br/>
* Да бисте видели јасније поруке о грешкама подесите систем за отклањање грешака (debugging) на <strong>{$a->mode}</strong> у {$a->atag}<br/>* Приступите {$a->amfatag}.';
$string['testwithtestclient'] = 'Тестирај сервис';
$string['testwithtestclientdescription'] = 'Симулирајте спољни приступ сервису користећи пробни клијент веб сервиса. Употребите омогућени протокол са токеном за проверу иденитета. <strong>УПОЗОРЊЕ: функције које тестирате БИЋЕ ИЗВРШЕНЕ, па будите пажљиви приликом избора онога што желите да тестирате!</strong>';
$string['token'] = 'Токен';
$string['tokenauthlog'] = 'Провера идентитета путем токена';
$string['tokencreatedbyadmin'] = 'Може бити ресетовано од стране администратора (*)';
$string['tokencreator'] = 'Аутор';
$string['unknownoptionkey'] = 'Непознат кључ опције ({$a})';
$string['unnamedstringparam'] = 'Параметар стринга није именован.';
$string['updateusersettings'] = 'Ажурирај';
$string['uploadfiles'] = 'Може да учита датотеке';
$string['uploadfiles_help'] = 'Ако је ово подешавање омогућено, сваки корисник може да учита датотеке са својим сигурносним кључем у свој приватни простор за датотеке или простор за радне верзије датотека. Примењују се корисничке квоте које су постављене.';
$string['userasclients'] = 'Корисници као клијенти са токеном';
$string['userasclientsdescription'] = 'Следећи кораци Вам помажу да подесите Moodle веб сервисе за кориснике као клијенте. Ови кораци такође помажу да подесите препоручене токене (безбедносне кључеве) за проверу идентитета. У том случају корисник ће генерисати свој токен на страници \'Безбедносни кључеви\' у оквиру \'Подешавања мог профила\'.';
$string['usermissingcaps'] = 'Недостају способности: {$a}';
$string['usernameorid'] = 'Корисничко име/кориснички ID';
$string['usernameorid_help'] = 'Упиши корисничко име или кориснички ID';
$string['usernameoridnousererror'] = 'Није пронађен ниједан корисник са овим корисничким именом/кориснички ID-ијем';
$string['usernameoridoccurenceerror'] = 'Пронађено више од једно корисник са овим корисничким именом. Молимо, унесите кориснички ID';
$string['usernotallowed'] = 'Кориснику није дозвољено да користи овај сервис. Прво морате да му дозволите коришћење на страници  за администрацију {$a}.';
$string['usersettingssaved'] = 'Корисничка подешавања су сачувана';
$string['validuntil'] = 'Важи до';
$string['validuntil_help'] = 'Ако је подешено, сервис ће након овог датума бити деактивиран за овог корисника.';
$string['webservice'] = 'Веб сервис';
$string['webservices'] = 'Веб сервиси';
$string['webservicesoverview'] = 'Прелед';
$string['webservicetokens'] = 'Токени за веб сервисе';
$string['wrongusernamepassword'] = 'Погрешно корисничко име или лозинка';
$string['wsaccessuserdeleted'] = 'Одбијен је приступ веб сервису за обрисано корисничко име: {$a}';
$string['wsaccessuserexpired'] = 'Одбијен је приступ веб сервису за корисничко име: {$a} којем је истекла лозинка';
$string['wsaccessusernologin'] = 'Одбијен је приступ веб сервису за корисничко име: {$a} којем је као метод провере идентитета подешено \'Без пријаве на систем\'';
$string['wsaccessusersuspended'] = 'Одбијен је приступ веб сервису за суспендовано корисничко име: {$a}';
$string['wsaccessuserunconfirmed'] = 'Одбијен је приступ веб сервису за непотврђено корисничко име: {$a}';
$string['wsclientdoc'] = 'Документација Moodle веб сервис клијента';
$string['wsdocapi'] = 'API Документација';
$string['wsdocumentation'] = 'Документација веб сервиса';
$string['wsdocumentationdisable'] = 'Документација веб сервиса је онемогућена';
$string['wsdocumentationintro'] = 'За креирање клијента препоручујемо Вам да прочитате {$a->doclink}';
$string['wsdocumentationlogin'] = 'или унесите корисничко име и лозинку Вашег веб сервиса';
$string['wspassword'] = 'Лозинка за веб сервис';
$string['wsusername'] = 'Корисничко име за веб сервис';
