<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'sr_cr', branch 'MOODLE_24_STABLE'
 *
 * @package   local_amos
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p>AMOS је скраћеница за Аутоматизовану манипулацију стринговима (Automated Manipulation Of Strings). AMOS је централни репозиторијум стрингова за Moodle и њихове историје. Он прати додавање стрингова на енглеском у програмски код Moodlea, прикупља преводе, управља заједничким пословима превођења и генерише језичке пакете спремне за примену на Moodle серверима.</p> <p>Више информације погледајте на страници <a href="http://docs.moodle.org/en/AMOS">AMOS документација</a>.</p>';
$string['amos'] = 'AMOS - Moodle алат за превођење';
$string['amos:commit'] = 'Предај радну верзију преведених стрингова у главни репозиторијум';
$string['amos:execute'] = 'Изврши дати AMOScript';
$string['amos:importfile'] = 'Увезите стрингове из постављене датотеке и пребаците их у радну верзију';
$string['amos:importstrings'] = 'Увезите стрингове (укључујући и енглеске) директно у главни репозиторијум';
$string['amos:manage'] = 'Уреди AMOS портал';
$string['amos:stage'] = 'Користи AMOS алат за превођење и унеси стрингове у радну верзију';
$string['amos:stash'] = 'Сачувај тренутну радну верзију у трајно сачуване стрингове';
$string['amos:usegoogle'] = 'Користи Google сервис за превођење';
$string['commitbutton'] = 'Предај превод и избаци све из фазе обраде';
$string['commitbutton2'] = 'Предај превод и остави ставке у фази обраде';
$string['commitmessage'] = 'Порука уз предати превод';
$string['commitstage'] = 'Предај радну верзију преведених стрингова';
$string['commitstage_help'] = 'Перманентно смешта све преведене стрингове радне верзије у AMOS репозиторијум. Пре предаје аутоматски се уклањају стрингови који се не могу предати као и застарели стрингови. Чувају се само преведени стрингови који се могу предати. То значи да ће бити предати само они стрингови који су обележени зеленом бојом. Након предаје преведених стрингова из радне верзије се уклањају сви стрингови.';
$string['committableall'] = 'сви језици';
$string['committablenone'] = 'немате овлашћења ни над једним језиком - молимо контактирајте AMOS администратора';
$string['componentsall'] = 'Све';
$string['componentsenlarge'] = 'Увећај';
$string['componentsnone'] = 'Ниједна';
$string['componentsstandard'] = 'Стандардне';
$string['confirmaction'] = 'Ова операција се не може поништити. Јесте ли сигурни?';
$string['contribaccept'] = 'Прихвати';
$string['contribactions'] = 'Акције са предатим преводима';
$string['contribactions_help'] = 'Зависно од ваших права и тока обраде превода, на располагању су вам следеће акције:

* Примени - копира у вашу радну верзију све преведене стрингове, не мењајући их
* Додели мени - поставља вас као особу која је одговорна за преглед и интеграцију послатих превода
* Опозови - укида све доделе  - превод никоме није додељен за преглед и проверу
* Започни преглед - додељује вама нове преводе, подешава статус на \'На прегледу\' и копира послате преводе у вашу радну верзију
* Прихвати - обележава послате преводе као прихваћене
* Одбиј - обележава послате преводе као одбијене. Молимо да у коментару објасните разлоге одбијања.

Преводилац ће бити обавештен е-поштом, када дође до промене статуса превода које је послао.';
$string['contribapply'] = 'Примени';
$string['contribassignee'] = 'Задужен/а';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Додели мени';
$string['contribauthor'] = 'Аутор';
$string['contribclosedno'] = 'Сакриј прихваћене преводе';
$string['contribclosedyes'] = 'Прикажи прихваћене преводе';
$string['contribcomponents'] = 'Компоненте';
$string['contribid'] = 'Идентификатор';
$string['contribincomingnone'] = 'Нема нових превода';
$string['contribincomingsome'] = 'Нови преводи ({$a})';
$string['contriblanguage'] = 'Језик';
$string['contribreject'] = 'Одбиј';
$string['contribresign'] = 'Опозови';
$string['contribstaged'] = 'Радна верзија превода <a href="contrib.php?id={$a->id}">#{$a->id}</a> аутора: {$a->author}';
$string['contribstagedinfo'] = 'Радна верзија превода';
$string['contribstagedinfo_help'] = 'Радна верзија садржи стрингове које су превели чланови заједнице. Претпоставља се да су менаџери језичких пакета прегледали преводе стрингога и потом им подесили им статус на \'Прихваћено\' (ако су преводи потврђени као одговарајући) или \'Одбијено\' (ако из неког разлога преводи не могу да буду укључени у званични језички пакет).';
$string['contribstartreview'] = 'Почни преглед';
$string['contribstatus'] = 'Статус';
$string['contribstatus0'] = 'Ново';
$string['contribstatus10'] = 'На прегледу';
$string['contribstatus20'] = 'Одбијено';
$string['contribstatus30'] = 'Прихваћено';
$string['contribstatus_help'] = 'Ток обраде послатих превода се састоји од неколико стања:

* Нов - преведени стрингови су послати али још нису прегледани
* На прегледу - преведени стрингови су додељени менаџеру језичког пакета и пребачени у радну верзију ради прегледа
* Одбијен - менаџер језичког пакета је одбио послате преводе и вероватно оставио објашњење у коментару
Прихваћен - менаџер језичког пакета је прихватио преведене стрингове';
$string['contribstrings'] = 'Стрингови';
$string['contribstringseq'] = 'нових стрингова: {$a->orig}';
$string['contribstringsnone'] = '{$a->orig} (сви су већ преведени у језичком пакету)';
$string['contribstringssome'] = '{$a->orig} (од којих {$a->same} већ има новији превод)';
$string['contribsubject'] = 'Наслов';
$string['contribsubmittednone'] = 'Нема послатих превода';
$string['contribsubmittedsome'] = 'Ваши преводи ({$a})';
$string['contribtimemodified'] = 'Измењено';
$string['contributions'] = 'Преводи';
$string['creditscontact'] = 'Пошаљи поруку';
$string['creditscontributors'] = 'Остали сарадници';
$string['creditsmaintainedby'] = 'Одржава';
$string['creditsnomaintainer'] = 'У ово тренутку не постоји менаџер језичког пакета. <a href="{$a->url}">Постаните један од њих!</a>';
$string['creditsthanks'] = 'На овој страници желимо да се захвалимо свима који су допринели превођењу Moodlea. Њихов рад је омогући да се Moodlea рашири свуда по свету.';
$string['creditstitlelong'] = 'Менаџери језичког пакета и сарадници';
$string['creditstitleshort'] = 'Заслуге';
$string['diff'] = 'Упореди';
$string['diffaction'] = 'Ако је уочена разлика';
$string['diffaction1'] = 'Пребаци у радну верзију оба превода њихових грана';
$string['diffaction2'] = 'Пребаци у радну верзију новије преводе обе гране';
$string['diffmode'] = 'Пребаци стрингове у радну верзију ако';
$string['diffmode1'] = 'Енглески стрингови су промењени али не и преведени';
$string['diffmode2'] = 'Енглески стрингови нису промењени али преведени јесу';
$string['diffmode3'] = 'Енглески или преведени стрингови су промењени (али не и једни и други)';
$string['diffmode4'] = 'И енглески или преведени стрингови су промењени';
$string['diffprogress'] = 'Упоређивање изабраних грана';
$string['diffprogressdone'] = 'Укупан број пронађених разлика: {$a}';
$string['diffstaged'] = 'разлике';
$string['diffstrings'] = 'Упореди стрингове две гране';
$string['diffstrings_help'] = 'Ово ће упоредити све стрингове две изабране гране. Ако постоји разлика у стринговима обе верзије ће бити пребачене у радну верзију. Након тога можете употребити опцију "Уреди стрингове радне верзије" како бисте прегледали и исправили промене, према потреби.';
$string['diffversions'] = 'Верзије';
$string['emailacceptbody'] = 'Менаџер језичког пакета {$a->assignee} је прихватио ваш превод #{$a->id} {$a->subject}.

За детаљније информације посетите {$a->url}';
$string['emailacceptsubject'] = '[AMOS превод] Прихваћено';
$string['emailcontributionbody'] = 'Корисник {$a->author} је предао нови превод #{$a->id} {$a->subject}.

За детаљније информације посетите: {$a->url}';
$string['emailcontributionsubject'] = '[AMOS превод] Послат је нови превод';
$string['emailrejectbody'] = 'Менаџер језичког пакета {$a->assignee} је одбио Ваш превод #{$a->id} {$a->subject}.

За детаљније информације посетите {$a->url}';
$string['emailrejectsubject'] = '[AMOS превод] Одбијено';
$string['emailreviewbody'] = 'Менаџер језичког пакета {$a->assignee} је започео преглед Вашег превода #{$a->id} {$a->subject}.

За детаљније информације посетите {$a->url}';
$string['emailreviewsubject'] = '[AMOS превод] Преглед је започео';
$string['err_exception'] = 'Грешка: {$a}';
$string['err_invalidlangcode'] = 'Неисправан кôд језика';
$string['err_parser'] = 'Грешка приликом парсирања: {$a}';
$string['filtercmp'] = 'Компоненте';
$string['filtercmp_desc'] = 'Прикажи стрингове за ове компоненте';
$string['filterlng'] = 'Језици';
$string['filterlng_desc'] = 'Прикажи преводе за ове језике';
$string['filtermis'] = 'Разно';
$string['filtermis_desc'] = 'Додатни услови за приказ стрингова';
$string['filtermisfglo'] = 'само непотребни стрингови';
$string['filtermisfhlp'] = 'само стрингови помоћи';
$string['filtermisfmis'] = 'само недостајући и застарели стрингови';
$string['filtermisfstg'] = 'само стрингови из радне верзије';
$string['filtermisfwog'] = 'без непотребних стрингова';
$string['filtersid'] = 'Идентификатор стринга';
$string['filtersid_desc'] = 'Кључ у низу стрингова';
$string['filtersidpartial'] = 'делимично поклапање';
$string['filtertxt'] = 'Подстринг';
$string['filtertxtcasesensitive'] = 'ВЕЛИКА и мала слова';
$string['filtertxt_desc'] = 'Стринг мора да садржи дати текст';
$string['filtertxtregex'] = 'регуларни израз';
$string['filterver'] = 'Верзије';
$string['filterver_desc'] = 'Прикажи стрингове из ових верзија Moodlea';
$string['found'] = 'Пронађено: {$a->found} &nbsp;&nbsp;&nbsp; Недостаје: {$a->missing} ({$a->missingonpage})';
$string['foundinfo'] = 'Број пронађених стрингова';
$string['foundinfo_help'] = 'Приказује укупaн број редова у табели превода, број недостајућих превода, као и број недостајућих превода на текућој страници';
$string['gotofirst'] = 'иди на прву страницу';
$string['gotoprevious'] = 'иди на претходну страницу';
$string['greylisted'] = 'Непотребни стрингови';
$string['greylisted_help'] = 'Moodle језички пакет може да садржи стрингови који нису више у употреби, али још увек нису обрисани. Ови стрингови су означени као \'непотребни\' (\'greylisted\'). Једном када се потврди да се непотребни стрингови више не користе, биће уклоњени из језичког пакета.

Уколико уочите непотребан стринг, који се још увек налази у Вашем језичком пакету Moodlea, молимо вас да нас о томе обавестите поруком на форуму у оквиру курса Translating Moodle, на овом сајту. Иначе, уштедећете драгоцено време ако будете преводили само стрингове који се користе, а игнорисати непотребне.';
$string['greylistedwarning'] = 'стринг је непотребан';
$string['importfile'] = 'Увези преведене стрингове из датотеке';
$string['importfile_help'] = 'Уколико сте своје стрингове превели изван AMOS-a помоћу овог обрасца их можете пребацити у радну верзију

* Датотека мора бити исправна Moodle PHP датотека са стринговима. За пример погледајте у директоријум `/lang/en/` ваше Moodle инсталације.
*Име датотеке мора да се подудара са именом исте датотеке са стринговима енглеског језичког пакета за дату компоненту (нпр. `moodle.php`, `assignment.php` или `enrol_manual.php`).

Сви стрингови пронађени у датотеци биће пребачени у радну верзију за изабрану верзију и језик.

Вишеј PHP датотека може бити обрађен одједном ако их спакујете у ZIP датотеку.';
$string['language'] = 'Језик';
$string['languages'] = 'Језици';
$string['languagesall'] = 'Сви';
$string['languagesnone'] = 'Ниједан';
$string['log'] = 'Запис';
$string['logfilterbranch'] = 'Верзије';
$string['logfiltercommithash'] = 'git хеш';
$string['logfiltercommitmsg'] = 'Порука уз предати превод садржи';
$string['logfiltercommits'] = 'Филтрирање предатих стрингова';
$string['logfiltercommittedafter'] = 'Потврђено после';
$string['logfiltercommittedbefore'] = 'Потврђено пре';
$string['logfiltercomponent'] = 'Компоненте';
$string['logfilterlang'] = 'Језици';
$string['logfiltershow'] = 'Прикажи филтриране потврде и стрингове';
$string['logfiltersource'] = 'Извор';
$string['logfiltersourceamos'] = 'amos (веб алат за превођење)';
$string['logfiltersourceautomerge'] = 'аутоматско спајање (превод копирани из друге гране)';
$string['logfiltersourcebot'] = 'бот (масивне операције извршене од стране скриптa)';
$string['logfiltersourcecommitscript'] = 'commitscript (AMOScript у поруци приликом предаје стрингова)';
$string['logfiltersourcefixdrift'] = 'fixdrift (fixed AMOS-git drift)';
$string['logfiltersourcegit'] = 'git (git mirror Moodle изворног кôда и 1.x пакета)';
$string['logfiltersourceimport'] = 'Увези (импортовани стрингови за нестандардне додатке)';
$string['logfiltersourcerevclean'] = 'revclean (обрнути поступак чишћења)';
$string['logfilterstringid'] = 'Идентификатор стринга';
$string['logfilterstrings'] = 'Филтер стрингова';
$string['logfilterusergrp'] = 'Преводилац';
$string['logfilterusergrpor'] = 'или';
$string['maintainers'] = 'Менаџери језичког пакета';
$string['markuptodate'] = 'Означавање превода као ажурног';
$string['markuptodate_help'] = 'AMOS је открио да је овај стринг можда застарео, пошто је енглеска верзија измењена након што је стринг преведен. Прегледајте превод и уколико сматрате да је ажуран кликните на поље за потврду. У супротном, измените превод.';
$string['merge'] = 'Интегриши';
$string['mergestrings'] = 'Интегриши стрингове из друге гране';
$string['mergestrings_help'] = 'Ово ће покупити све стрингове из изворне гране, који још нису преведени у циљној грани и користе се у њој, а затим их пребацити у радну верзију. Ову алатку можете користити како бисте копирали преведене стрингове у све друге верзије језичког пакета. Алатку могу да користе само менаџери језичких пакета.';
$string['newlanguage'] = 'Нови језик';
$string['nodiffs'] = 'Није пронађена ниједна разлика';
$string['nofiletoimport'] = 'Наведите датотеку за увоз података.';
$string['nologsfound'] = 'Ниједан стринг није пронађен, молимо промените филтере';
$string['nostringsfound'] = 'Ниједан стринг није пронађен';
$string['nostringsfoundonpage'] = 'Ниједан стринг није пронађен на страници {$a}';
$string['nostringtoimport'] = 'Ниједан исправан стринг није пронађен у датотеци. Проверите да ли је име датотеке исправно и да ли је правилно форматирана.';
$string['nothingtomerge'] = 'Изворна грана не садржи ниједан нови стринг који би недостајао у циљној грани. Нема стрингова за интеграцију.';
$string['nothingtostage'] = 'Операција није вратила ниједан стринг који би могао да буде пребачен у радну верзију';
$string['novalidzip'] = 'Није могуће распаковати ZIP датотеку';
$string['numofcommitsabovelimit'] = 'Пронађено је {$a->found} предатих стрингова који се подударају са филтером, користећи {$a->limit} најновијих';
$string['numofcommitsunderlimit'] = 'Пронађено је {$a->found} предатих стрингова који се подударају са филтером';
$string['numofmatchingstrings'] = 'У oквиру овога, {$a->strings} измене од {$a->commits} предатих стрингова се подудара са филтером стрингова';
$string['outdatednotcommitted'] = 'Застарели стрингови';
$string['outdatednotcommitted_help'] = 'AMOS је открио да је овај стринг можда застарео, пошто је енглеска верзија измењена након што је стринг преведен. Молимо, прегледајте превод.';
$string['outdatednotcommittedwarning'] = 'застарело';
$string['ownstashactions'] = 'Акције са сачуваним стринговима';
$string['ownstashactions_help'] = '* Примени - копира преведене стрингове из сачуваних стрингова (stash) у радну верзију (stage), не мењајући при томе  сачуване стринове. Ако стринг већ постоји у радној верзији, он ће бити преписан стрингом који се налази у сачуваним стринговима.
* Примени/Одбаци (Pop) - премешта преведене стрингове у радну верзију и потпуно брише све сачуване стринговe (тј. истовремено извршава команде Примени и Одбаци).
* Одбаци - одбацује тј. брише сачуване стрингове.
* Пошаљи - отвара образац за слање сачуваних стрингова званичним менаџерима  језичког пакета, тако да они могу да укључе Ваш превод у званични језички пакет.';
$string['ownstashes'] = 'Ваши сачувани стрингови';
$string['ownstashes_help'] = 'Ово је списак свих Ваших сачуваних стрингова';
$string['ownstashesnone'] = 'Нема Ваших сачуваних стрингова';
$string['permalink'] = 'перманентни линк';
$string['placeholder'] = 'Варијабле (резервисана места)';
$string['placeholder_help'] = 'Варијабле (резервисана места) су специјалне ознаке унутар стринга, попут `{$a}` или `{$a->something}`. Оне се замењују одговарајућим вредностима приликом приказивања стринга.

Важно је да ове варијабле буду копиране тачно онако како су наведене у оригиналном, енглeском, стрингу. Немојте их преводити нити мењати њихову оријентацију слева-надесно.';
$string['placeholderwarning'] = 'стринг садржи променљиву';
$string['pluginclasscore'] = 'Кључни подсистеми';
$string['pluginclassnonstandard'] = 'Нестандардни додаци';
$string['pluginclassstandard'] = 'Стандардни додаци';
$string['pluginname'] = 'AMOS';
$string['presetcommitmessage'] = 'Превод #{$a->id} аутора: {$a->author}';
$string['presetcommitmessage2'] = 'Недостајући стрингови из {$a->source} су интегрисани у {$a->target} грану';
$string['presetcommitmessage3'] = 'Исправљање разлика између {$a->versiona} и {$a->versionb}';
$string['privileges'] = 'Ваше привилегије';
$string['privilegesnone'] = 'Имате право само да читате јавно доступне информације.';
$string['propagate'] = 'Пропагирај преводе';
$string['propagatednone'] = 'Ниједан превод није пропагиран';
$string['propagatedsome'] = '{$a} превода радне верзије је пропагирано';
$string['propagate_help'] = 'Преводи радне верзије могу да буду пропагирани на изабране гране језичког пакета. AMOS врши итерацију над списком превода радне верзије и покушава да их примени у свим изабраним гранама. Пропагација није могућа:

*ако  су енглески оригинали стрингова различити у изворној и одредишној грани језичког пакета
* ако је стринг убачен у радну верзију више пута са различитим преводом';
$string['propagaterun'] = 'Пропагирај';
$string['requestactions'] = 'Акција';
$string['requestactions_help'] = '* Примени - копирај преведене стрингове из репозиторијума (\'pull request\') у радну верзију. Ако је стринг већ у радној верзији, биће замењен копијом из сачуваних стрингова.
* Сакриј - блокира репозиторијум тако да Вам се он више неће приказивати.';
$string['savefilter'] = 'Сачувај подешавања филтера';
$string['script'] = 'AMOScript';
$string['scriptexecute'] = 'Изврши и резултат пребаци у радну верзију';
$string['script_help'] = 'AMOScript представља скуп инструкција који се извршава над репозиторијумом стрингова';
$string['sourceversion'] = 'Изворна верзија';
$string['stage'] = 'Радна верзија';
$string['stageactions'] = 'Акције са радном верзијом';
$string['stageactions_help'] = '* Уреди радну верзију превода - мења подешавања филтера превода тако да се приказују само преведени стрингови радне верзије.
* Одбаци преводе које се не могу предати - уклања из радне верзије све преведене стрингове које не можете да предате. Пре предаје, из радне верзије се аутоматски уклањају такви стрингови.
* Уклони застареле преводе - уклања из радне верзије све преведене стрингове који, или, не мењају текући превод, или, су старији од најновијих превода у репозиторијуму.Пре предаје, из радне верзије се аутоматски уклањају застарели преводи.
*Обриши све преводе - уклања из радне верзије све преведене стрингове';
$string['stageedit'] = 'Уреди стрингове радне верзије';
$string['stagelang'] = 'Језик';
$string['stageoriginal'] = 'Оригинал';
$string['stageprune'] = 'Одбаци преводе које се не могу предати';
$string['stagerebase'] = 'Уклони застареле преводе';
$string['stagestring'] = 'Стринг';
$string['stagestringsnocommit'] = 'Број преведених стрингова у радној верзији: {$a->staged}';
$string['stagestringsnone'] = 'Нема преведених стрингова у радној верзији';
$string['stagestringssome'] = 'Број преведених стрингова у радној верзији: {$a->staged}, од којих {$a->committable} може бити предато';
$string['stagesubmit'] = 'Пошаљи менаџеру језичког пакета';
$string['stagetranslation'] = 'Превод';
$string['stagetranslation_help'] = 'Приказује преведене стрингове радне верзије који ће бити послати. Боја позадине ћелије значи:

* Зелено - додали сте превод који недостаје и дозвољено Вам је да га пошаљете.
* Жуто - изменили сте стринг и дозвољено Вам је да пошаљете промене
* Плаво - променили сте превод или додали недостајући али Вам није дозвољено да их пошаљете у дати језички пакет.
* Без боје - преведени стринг у радној верзији је исти као већ постојећи и зато неће бити послат.';
$string['stageunstageall'] = 'Обриши све преводе';
$string['stashactions'] = 'Акције са сачуваним стринговима';
$string['stashactions_help'] = 'Део AMOS-а \'Сачувани стрингови\' (stash) представља снимак текуће радне верзије (stage). Сачувани стрингови могу бити послати менаџеру званичног језичког пакета за укључивање у језички пакет.';
$string['stashapply'] = 'Примени';
$string['stashautosave'] = 'Аутоматска резервна копија сачуваних стрингова';
$string['stashautosave_help'] = 'Ова копија сачуваних стрингова (stash) садржи најновији снимак радне верзије преведених стрингова. Можете је користити као резервну копију, нпр. у случају када грешком изгубите све преведене стрингове радне верзије. Употребите команду \'Примени\' да бисте копирали све сачуване стрингове у радну верзију (ако у радној верзији већ постоји превод неког стринга, он ће бити замењен преводом из копије сачуваних стрингова).';
$string['stashcomponents'] = '<span>Компоненте:</span> {$a}';
$string['stashdrop'] = 'Oдустани';
$string['stashes'] = 'Сачувани стрингови';
$string['stashlanguages'] = '<span>Језици:</span> {$a}';
$string['stashpop'] = 'Примени/Одбаци (Pop)';
$string['stashpush'] = 'Пребаци све стрингове из радне верзије међу сачуване стрингове';
$string['stashstrings'] = '<span>Број стрингова:</span> {$a}';
$string['stashsubmit'] = 'Пошаљи менаџеру језичког пакета';
$string['stashsubmitdetails'] = 'Детаљи о послатом преводу';
$string['stashsubmitmessage'] = 'Порука';
$string['stashsubmitsubject'] = 'Наслов';
$string['stashtitle'] = 'Назив сачуваних стрингова';
$string['stashtitledefault'] = 'WIP - {$a->time}';
$string['stringhistory'] = 'Историја';
$string['strings'] = 'Стрингови';
$string['submitting'] = 'Слање превода';
$string['submitting_help'] = 'Ово ће преведене стрингове послати званичним менаџерима језичког пакета. Они ће моћи Ваш превод да пребаце у своје радне верзије, прегледају га и на крају прихвате. Молимо да им приликом слања превода пошаљете и поруку у којој ћете описати шта сте урадили и зашто бисте желели да стрингови које сте превели буде укључен у превод.';
$string['targetversion'] = 'Циљна верзија';
$string['translatorlang'] = 'Језик';
$string['translatorlang_help'] = 'Приказује код језика на који се стринг преводи. Кликните на знак (линк) <strong>+-</strong>  како бисте видели историјат претходних превода стринга.';
$string['translatororiginal'] = 'Оригинал';
$string['translatororiginal_help'] = 'Приказује енглески оригинал стринга. Испод њега, можете да видите линк за превод уз помоћ Google Translatora (под условом да је језик подржан и да је у вашем веб читачу укључена пордршка за Javascript). Такође, можете наћи додатне информације, као нпр. да ли стринг садржи променљиву (резервисано место).';
$string['translatorstring'] = 'Стринг';
$string['translatorstring_help'] = 'Приказује верзију Moodlea, идентификатор стринга и компоненту којој тај стринг припада.';
$string['translatortool'] = 'Алат за превођење';
$string['translatortranslation'] = 'Превод';
$string['translatortranslation_help'] = 'Кликните на ћелију како бисте могли да уређујете њен садржај. Унесите превод и кликните изван ћелије да сачувате превод. Боја позадине ћелије означава:

* Зелено - стринг је већ преведен, можете евентуално да измените превод.
* Жуто - стринг је можда застарео.. Енглеска верзија је вероватно промењена након што је стринг био преведен.
* Црвено - стринг још није преведен. * Плаво - променили сте превод и он је сада у радној верзији.
*Сиво - AMOS не може да се користи за превод овог стринга. На пример, стрингови за Moodle  1.9 морају да се уређује само преко CVS приступа.

Менаџери језичког пакет могу да виде мали црвени симбол у углу ћелија чије садржаје (преводе) могу да потврде.';
$string['typecontrib'] = 'Нестандардни додаци';
$string['typecore'] = 'Кључни подсистеми';
$string['typestandard'] = 'Стандардни додаци';
$string['unstage'] = 'Уклони из радне верзије';
$string['unstageconfirm'] = 'Стварно?';
$string['unstaging'] = 'Уклањање из радне верзије';
$string['version'] = 'Верзија';
